package datafactory

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datafactory/mgmt/2017-09-01-preview/datafactory"

// BasicActivity a pipeline activity.
type BasicActivity interface {
	AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool)
	AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool)
	AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool)
	AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool)
	AsGetMetadataActivity() (*GetMetadataActivity, bool)
	AsWebActivity() (*WebActivity, bool)
	AsLookupActivity() (*LookupActivity, bool)
	AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool)
	AsCustomActivity() (*CustomActivity, bool)
	AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool)
	AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool)
	AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool)
	AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool)
	AsHDInsightPigActivity() (*HDInsightPigActivity, bool)
	AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool)
	AsCopyActivity() (*CopyActivity, bool)
	AsExecutionActivity() (*ExecutionActivity, bool)
	AsBasicExecutionActivity() (BasicExecutionActivity, bool)
	AsFilterActivity() (*FilterActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
	AsBasicControlActivity() (BasicControlActivity, bool)
	AsActivity() (*Activity, bool)
}

// Activity a pipeline activity.
type Activity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicActivity(body []byte) (BasicActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDatabricksNotebook):
		var dna DatabricksNotebookActivity
		err := json.Unmarshal(body, &dna)
		return dna, err
	case string(TypeDataLakeAnalyticsUSQL):
		var dlaua DataLakeAnalyticsUSQLActivity
		err := json.Unmarshal(body, &dlaua)
		return dlaua, err
	case string(TypeAzureMLUpdateResource):
		var amura AzureMLUpdateResourceActivity
		err := json.Unmarshal(body, &amura)
		return amura, err
	case string(TypeAzureMLBatchExecution):
		var ambea AzureMLBatchExecutionActivity
		err := json.Unmarshal(body, &ambea)
		return ambea, err
	case string(TypeGetMetadata):
		var gma GetMetadataActivity
		err := json.Unmarshal(body, &gma)
		return gma, err
	case string(TypeWebActivity):
		var wa WebActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeLookup):
		var la LookupActivity
		err := json.Unmarshal(body, &la)
		return la, err
	case string(TypeSQLServerStoredProcedure):
		var ssspa SQLServerStoredProcedureActivity
		err := json.Unmarshal(body, &ssspa)
		return ssspa, err
	case string(TypeCustom):
		var ca CustomActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecuteSSISPackage):
		var espa ExecuteSSISPackageActivity
		err := json.Unmarshal(body, &espa)
		return espa, err
	case string(TypeHDInsightSpark):
		var hisa HDInsightSparkActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightStreaming):
		var hisa HDInsightStreamingActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightMapReduce):
		var himra HDInsightMapReduceActivity
		err := json.Unmarshal(body, &himra)
		return himra, err
	case string(TypeHDInsightPig):
		var hipa HDInsightPigActivity
		err := json.Unmarshal(body, &hipa)
		return hipa, err
	case string(TypeHDInsightHive):
		var hiha HDInsightHiveActivity
		err := json.Unmarshal(body, &hiha)
		return hiha, err
	case string(TypeCopy):
		var ca CopyActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecution):
		var ea ExecutionActivity
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(TypeFilter):
		var fa FilterActivity
		err := json.Unmarshal(body, &fa)
		return fa, err
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	case string(TypeContainer):
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Activity
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActivityArray(body []byte) ([]BasicActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	a.Type = TypeActivity
	objectMap := make(map[string]interface{})
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.DependsOn != nil {
		objectMap["dependsOn"] = a.DependsOn
	}
	if a.Type != "" {
		objectMap["type"] = a.Type
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for Activity.
func (a Activity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for Activity.
func (a Activity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for Activity.
func (a Activity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for Activity.
func (a Activity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for Activity.
func (a Activity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for Activity.
func (a Activity) AsActivity() (*Activity, bool) {
	return &a, true
}

// AsBasicActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicActivity() (BasicActivity, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				a.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// ActivityDependency activity dependency information.
type ActivityDependency struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Activity - Activity name.
	Activity *string `json:"activity,omitempty"`
	// DependencyConditions - Match-Condition for the dependency.
	DependencyConditions *[]DependencyCondition `json:"dependencyConditions,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityDependency.
func (ad ActivityDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.Activity != nil {
		objectMap["activity"] = ad.Activity
	}
	if ad.DependencyConditions != nil {
		objectMap["dependencyConditions"] = ad.DependencyConditions
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityDependency struct.
func (ad *ActivityDependency) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "activity":
			if v != nil {
				var activity string
				err = json.Unmarshal(*v, &activity)
				if err != nil {
					return err
				}
				ad.Activity = &activity
			}
		case "dependencyConditions":
			if v != nil {
				var dependencyConditions []DependencyCondition
				err = json.Unmarshal(*v, &dependencyConditions)
				if err != nil {
					return err
				}
				ad.DependencyConditions = &dependencyConditions
			}
		}
	}

	return nil
}

// ActivityPolicy execution policy for an activity.
type ActivityPolicy struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Timeout - Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout interface{} `json:"timeout,omitempty"`
	// Retry - Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry interface{} `json:"retry,omitempty"`
	// RetryIntervalInSeconds - Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
	// SecureOutput - When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool `json:"secureOutput,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityPolicy.
func (ap ActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Timeout != nil {
		objectMap["timeout"] = ap.Timeout
	}
	if ap.Retry != nil {
		objectMap["retry"] = ap.Retry
	}
	if ap.RetryIntervalInSeconds != nil {
		objectMap["retryIntervalInSeconds"] = ap.RetryIntervalInSeconds
	}
	if ap.SecureOutput != nil {
		objectMap["secureOutput"] = ap.SecureOutput
	}
	for k, v := range ap.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityPolicy struct.
func (ap *ActivityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ap.AdditionalProperties == nil {
					ap.AdditionalProperties = make(map[string]interface{})
				}
				ap.AdditionalProperties[k] = additionalProperties
			}
		case "timeout":
			if v != nil {
				var timeout interface{}
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				ap.Timeout = timeout
			}
		case "retry":
			if v != nil {
				var retry interface{}
				err = json.Unmarshal(*v, &retry)
				if err != nil {
					return err
				}
				ap.Retry = retry
			}
		case "retryIntervalInSeconds":
			if v != nil {
				var retryIntervalInSeconds int32
				err = json.Unmarshal(*v, &retryIntervalInSeconds)
				if err != nil {
					return err
				}
				ap.RetryIntervalInSeconds = &retryIntervalInSeconds
			}
		case "secureOutput":
			if v != nil {
				var secureOutput bool
				err = json.Unmarshal(*v, &secureOutput)
				if err != nil {
					return err
				}
				ap.SecureOutput = &secureOutput
			}
		}
	}

	return nil
}

// ActivityRun information about an activity run in a pipeline.
type ActivityRun struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// PipelineName - READ-ONLY; The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineRunID - READ-ONLY; The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty"`
	// ActivityName - READ-ONLY; The name of the activity.
	ActivityName *string `json:"activityName,omitempty"`
	// ActivityType - READ-ONLY; The type of the activity.
	ActivityType *string `json:"activityType,omitempty"`
	// ActivityRunID - READ-ONLY; The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty"`
	// LinkedServiceName - READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty"`
	// Status - READ-ONLY; The status of the activity run.
	Status *string `json:"status,omitempty"`
	// ActivityRunStart - READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *date.Time `json:"activityRunStart,omitempty"`
	// ActivityRunEnd - READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *date.Time `json:"activityRunEnd,omitempty"`
	// DurationInMs - READ-ONLY; The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty"`
	// Input - READ-ONLY; The input for the activity.
	Input interface{} `json:"input,omitempty"`
	// Output - READ-ONLY; The output for the activity.
	Output interface{} `json:"output,omitempty"`
	// Error - READ-ONLY; The error if any from the activity run.
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityRun.
func (ar ActivityRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ar.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityRun struct.
func (ar *ActivityRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ar.AdditionalProperties == nil {
					ar.AdditionalProperties = make(map[string]interface{})
				}
				ar.AdditionalProperties[k] = additionalProperties
			}
		case "pipelineName":
			if v != nil {
				var pipelineName string
				err = json.Unmarshal(*v, &pipelineName)
				if err != nil {
					return err
				}
				ar.PipelineName = &pipelineName
			}
		case "pipelineRunId":
			if v != nil {
				var pipelineRunID string
				err = json.Unmarshal(*v, &pipelineRunID)
				if err != nil {
					return err
				}
				ar.PipelineRunID = &pipelineRunID
			}
		case "activityName":
			if v != nil {
				var activityName string
				err = json.Unmarshal(*v, &activityName)
				if err != nil {
					return err
				}
				ar.ActivityName = &activityName
			}
		case "activityType":
			if v != nil {
				var activityType string
				err = json.Unmarshal(*v, &activityType)
				if err != nil {
					return err
				}
				ar.ActivityType = &activityType
			}
		case "activityRunId":
			if v != nil {
				var activityRunID string
				err = json.Unmarshal(*v, &activityRunID)
				if err != nil {
					return err
				}
				ar.ActivityRunID = &activityRunID
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName string
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ar.LinkedServiceName = &linkedServiceName
			}
		case "status":
			if v != nil {
				var status string
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ar.Status = &status
			}
		case "activityRunStart":
			if v != nil {
				var activityRunStart date.Time
				err = json.Unmarshal(*v, &activityRunStart)
				if err != nil {
					return err
				}
				ar.ActivityRunStart = &activityRunStart
			}
		case "activityRunEnd":
			if v != nil {
				var activityRunEnd date.Time
				err = json.Unmarshal(*v, &activityRunEnd)
				if err != nil {
					return err
				}
				ar.ActivityRunEnd = &activityRunEnd
			}
		case "durationInMs":
			if v != nil {
				var durationInMs int32
				err = json.Unmarshal(*v, &durationInMs)
				if err != nil {
					return err
				}
				ar.DurationInMs = &durationInMs
			}
		case "input":
			if v != nil {
				var input interface{}
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ar.Input = input
			}
		case "output":
			if v != nil {
				var output interface{}
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ar.Output = output
			}
		case "error":
			if v != nil {
				var errorVar interface{}
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				ar.Error = errorVar
			}
		}
	}

	return nil
}

// ActivityRunsListResponse a list activity runs.
type ActivityRunsListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of activity runs.
	Value *[]ActivityRun `json:"value,omitempty"`
	// NextLink - The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActivityRunsListResponseIterator provides access to a complete listing of ActivityRun values.
type ActivityRunsListResponseIterator struct {
	i    int
	page ActivityRunsListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActivityRunsListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActivityRunsListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActivityRunsListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActivityRunsListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActivityRunsListResponseIterator) Response() ActivityRunsListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActivityRunsListResponseIterator) Value() ActivityRun {
	if !iter.page.NotDone() {
		return ActivityRun{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActivityRunsListResponseIterator type.
func NewActivityRunsListResponseIterator(page ActivityRunsListResponsePage) ActivityRunsListResponseIterator {
	return ActivityRunsListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr ActivityRunsListResponse) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arlr ActivityRunsListResponse) hasNextLink() bool {
	return arlr.NextLink != nil && len(*arlr.NextLink) != 0
}

// activityRunsListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr ActivityRunsListResponse) activityRunsListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !arlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// ActivityRunsListResponsePage contains a page of ActivityRun values.
type ActivityRunsListResponsePage struct {
	fn   func(context.Context, ActivityRunsListResponse) (ActivityRunsListResponse, error)
	arlr ActivityRunsListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActivityRunsListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActivityRunsListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arlr)
		if err != nil {
			return err
		}
		page.arlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActivityRunsListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActivityRunsListResponsePage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActivityRunsListResponsePage) Response() ActivityRunsListResponse {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActivityRunsListResponsePage) Values() []ActivityRun {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// Creates a new instance of the ActivityRunsListResponsePage type.
func NewActivityRunsListResponsePage(cur ActivityRunsListResponse, getNextPage func(context.Context, ActivityRunsListResponse) (ActivityRunsListResponse, error)) ActivityRunsListResponsePage {
	return ActivityRunsListResponsePage{
		fn:   getNextPage,
		arlr: cur,
	}
}

// AmazonMWSLinkedService amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
	*AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAmazonMWS
	objectMap := make(map[string]interface{})
	if amls.AmazonMWSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AmazonMWSLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return &amls, true
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedService struct.
func (amls *AmazonMWSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonMWSLinkedServiceTypeProperties AmazonMWSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonMWSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AmazonMWSLinkedServiceTypeProperties = &amazonMWSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSLinkedServiceTypeProperties amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// MarketplaceID - The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID interface{} `json:"marketplaceID,omitempty"`
	// SellerID - The Amazon seller ID.
	SellerID interface{} `json:"sellerID,omitempty"`
	// MwsAuthToken - The Amazon MWS authentication token.
	MwsAuthToken BasicSecretBase `json:"mwsAuthToken,omitempty"`
	// AccessKeyID - The access key id used to access data.
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretKey - The secret key used to access data.
	SecretKey BasicSecretBase `json:"secretKey,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedServiceTypeProperties struct.
func (amlstp *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				amlstp.Endpoint = endpoint
			}
		case "marketplaceID":
			if v != nil {
				var marketplaceID interface{}
				err = json.Unmarshal(*v, &marketplaceID)
				if err != nil {
					return err
				}
				amlstp.MarketplaceID = marketplaceID
			}
		case "sellerID":
			if v != nil {
				var sellerID interface{}
				err = json.Unmarshal(*v, &sellerID)
				if err != nil {
					return err
				}
				amlstp.SellerID = sellerID
			}
		case "mwsAuthToken":
			if v != nil {
				mwsAuthToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.MwsAuthToken = mwsAuthToken
			}
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				amlstp.AccessKeyID = accessKeyID
			}
		case "secretKey":
			if v != nil {
				secretKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.SecretKey = secretKey
			}
		case "useEncryptedEndpoints":
			if v != nil {
				var useEncryptedEndpoints interface{}
				err = json.Unmarshal(*v, &useEncryptedEndpoints)
				if err != nil {
					return err
				}
				amlstp.UseEncryptedEndpoints = useEncryptedEndpoints
			}
		case "useHostVerification":
			if v != nil {
				var useHostVerification interface{}
				err = json.Unmarshal(*v, &useHostVerification)
				if err != nil {
					return err
				}
				amlstp.UseHostVerification = useHostVerification
			}
		case "usePeerVerification":
			if v != nil {
				var usePeerVerification interface{}
				err = json.Unmarshal(*v, &usePeerVerification)
				if err != nil {
					return err
				}
				amlstp.UsePeerVerification = usePeerVerification
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonMWSObjectDataset amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	amod.Type = TypeAmazonMWSObject
	objectMap := make(map[string]interface{})
	if amod.Description != nil {
		objectMap["description"] = amod.Description
	}
	if amod.Structure != nil {
		objectMap["structure"] = amod.Structure
	}
	if amod.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amod.LinkedServiceName
	}
	if amod.Parameters != nil {
		objectMap["parameters"] = amod.Parameters
	}
	if amod.Annotations != nil {
		objectMap["annotations"] = amod.Annotations
	}
	if amod.Type != "" {
		objectMap["type"] = amod.Type
	}
	for k, v := range amod.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return &amod, true
}

// AsHTTPDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amod, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSObjectDataset struct.
func (amod *AmazonMWSObjectDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amod.AdditionalProperties == nil {
					amod.AdditionalProperties = make(map[string]interface{})
				}
				amod.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amod.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amod.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amod.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amod.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amod.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amod.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSSource a copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSSource.
func (ams AmazonMWSSource) MarshalJSON() ([]byte, error) {
	ams.Type = TypeAmazonMWSSource
	objectMap := make(map[string]interface{})
	if ams.Query != nil {
		objectMap["query"] = ams.Query
	}
	if ams.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ams.SourceRetryCount
	}
	if ams.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ams.SourceRetryWait
	}
	if ams.Type != "" {
		objectMap["type"] = ams.Type
	}
	for k, v := range ams.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return &ams, true
}

// AsHTTPSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ams, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSSource struct.
func (ams *AmazonMWSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ams.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ams.AdditionalProperties == nil {
					ams.AdditionalProperties = make(map[string]interface{})
				}
				ams.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ams.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ams.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ams.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedService linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
	*AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	arls.Type = TypeAmazonRedshift
	objectMap := make(map[string]interface{})
	if arls.AmazonRedshiftLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = arls.AmazonRedshiftLinkedServiceTypeProperties
	}
	if arls.ConnectVia != nil {
		objectMap["connectVia"] = arls.ConnectVia
	}
	if arls.Description != nil {
		objectMap["description"] = arls.Description
	}
	if arls.Parameters != nil {
		objectMap["parameters"] = arls.Parameters
	}
	if arls.Annotations != nil {
		objectMap["annotations"] = arls.Annotations
	}
	if arls.Type != "" {
		objectMap["type"] = arls.Type
	}
	for k, v := range arls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return &arls, true
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &arls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedService struct.
func (arls *AmazonRedshiftLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftLinkedServiceTypeProperties AmazonRedshiftLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				arls.AmazonRedshiftLinkedServiceTypeProperties = &amazonRedshiftLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if arls.AdditionalProperties == nil {
					arls.AdditionalProperties = make(map[string]interface{})
				}
				arls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				arls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				arls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				arls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				arls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedServiceTypeProperties amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// Server - The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`
	// Username - The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
	// Password - The password of the Amazon Redshift source.
	Password BasicSecretBase `json:"password,omitempty"`
	// Database - The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Port - The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedServiceTypeProperties struct.
func (arlstp *AmazonRedshiftLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "server":
			if v != nil {
				var server interface{}
				err = json.Unmarshal(*v, &server)
				if err != nil {
					return err
				}
				arlstp.Server = server
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				arlstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				arlstp.Password = password
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				arlstp.Database = databaseVar
			}
		case "port":
			if v != nil {
				var port interface{}
				err = json.Unmarshal(*v, &port)
				if err != nil {
					return err
				}
				arlstp.Port = port
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				arlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonRedshiftSource a copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	ars.Type = TypeAmazonRedshiftSource
	objectMap := make(map[string]interface{})
	if ars.Query != nil {
		objectMap["query"] = ars.Query
	}
	if ars.RedshiftUnloadSettings != nil {
		objectMap["redshiftUnloadSettings"] = ars.RedshiftUnloadSettings
	}
	if ars.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ars.SourceRetryCount
	}
	if ars.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ars.SourceRetryWait
	}
	if ars.Type != "" {
		objectMap["type"] = ars.Type
	}
	for k, v := range ars.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return &ars, true
}

// AsResponsysSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ars, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftSource struct.
func (ars *AmazonRedshiftSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ars.Query = query
			}
		case "redshiftUnloadSettings":
			if v != nil {
				var redshiftUnloadSettings RedshiftUnloadSettings
				err = json.Unmarshal(*v, &redshiftUnloadSettings)
				if err != nil {
					return err
				}
				ars.RedshiftUnloadSettings = &redshiftUnloadSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ars.AdditionalProperties == nil {
					ars.AdditionalProperties = make(map[string]interface{})
				}
				ars.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ars.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ars.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ars.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3Dataset a single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
	*AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Dataset.
func (asd AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	asd.Type = TypeAmazonS3Object
	objectMap := make(map[string]interface{})
	if asd.AmazonS3DatasetTypeProperties != nil {
		objectMap["typeProperties"] = asd.AmazonS3DatasetTypeProperties
	}
	if asd.Description != nil {
		objectMap["description"] = asd.Description
	}
	if asd.Structure != nil {
		objectMap["structure"] = asd.Structure
	}
	if asd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asd.LinkedServiceName
	}
	if asd.Parameters != nil {
		objectMap["parameters"] = asd.Parameters
	}
	if asd.Annotations != nil {
		objectMap["annotations"] = asd.Annotations
	}
	if asd.Type != "" {
		objectMap["type"] = asd.Type
	}
	for k, v := range asd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return &asd, true
}

// AsDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &asd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Dataset struct.
func (asd *AmazonS3Dataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3DatasetTypeProperties AmazonS3DatasetTypeProperties
				err = json.Unmarshal(*v, &amazonS3DatasetTypeProperties)
				if err != nil {
					return err
				}
				asd.AmazonS3DatasetTypeProperties = &amazonS3DatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asd.AdditionalProperties == nil {
					asd.AdditionalProperties = make(map[string]interface{})
				}
				asd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3DatasetTypeProperties amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// BucketName - The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`
	// Key - The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key interface{} `json:"key,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// Version - The version for the S3 object. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// Format - The format of files.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the Amazon S3 object.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3DatasetTypeProperties struct.
func (asdtp *AmazonS3DatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asdtp.BucketName = bucketName
			}
		case "key":
			if v != nil {
				var key interface{}
				err = json.Unmarshal(*v, &key)
				if err != nil {
					return err
				}
				asdtp.Key = key
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asdtp.Prefix = prefix
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asdtp.Version = version
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				asdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				asdtp.Compression = compression
			}
		}
	}

	return nil
}

// AmazonS3LinkedService linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
	*AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAmazonS3
	objectMap := make(map[string]interface{})
	if asls.AmazonS3LinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AmazonS3LinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return &asls, true
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedService struct.
func (asls *AmazonS3LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3LinkedServiceTypeProperties AmazonS3LinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonS3LinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AmazonS3LinkedServiceTypeProperties = &amazonS3LinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3LinkedServiceTypeProperties amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// AccessKeyID - The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey BasicSecretBase `json:"secretAccessKey,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedServiceTypeProperties struct.
func (aslstp *AmazonS3LinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				aslstp.AccessKeyID = accessKeyID
			}
		case "secretAccessKey":
			if v != nil {
				secretAccessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SecretAccessKey = secretAccessKey
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AvroFormat the data stored in Avro format.
type AvroFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeDatasetStorageFormat', 'TypeParquetFormat', 'TypeOrcFormat', 'TypeAvroFormat', 'TypeJSONFormat', 'TypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroFormat.
func (af AvroFormat) MarshalJSON() ([]byte, error) {
	af.Type = TypeAvroFormat
	objectMap := make(map[string]interface{})
	if af.Serializer != nil {
		objectMap["serializer"] = af.Serializer
	}
	if af.Deserializer != nil {
		objectMap["deserializer"] = af.Deserializer
	}
	if af.Type != "" {
		objectMap["type"] = af.Type
	}
	for k, v := range af.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsAvroFormat() (*AvroFormat, bool) {
	return &af, true
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return nil, false
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &af, true
}

// UnmarshalJSON is the custom unmarshaler for AvroFormat struct.
func (af *AvroFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if af.AdditionalProperties == nil {
					af.AdditionalProperties = make(map[string]interface{})
				}
				af.AdditionalProperties[k] = additionalProperties
			}
		case "serializer":
			if v != nil {
				var serializer interface{}
				err = json.Unmarshal(*v, &serializer)
				if err != nil {
					return err
				}
				af.Serializer = serializer
			}
		case "deserializer":
			if v != nil {
				var deserializer interface{}
				err = json.Unmarshal(*v, &deserializer)
				if err != nil {
					return err
				}
				af.Deserializer = deserializer
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetStorageFormat
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedService azure Batch linked service.
type AzureBatchLinkedService struct {
	// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
	*AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	abls.Type = TypeAzureBatch
	objectMap := make(map[string]interface{})
	if abls.AzureBatchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abls.AzureBatchLinkedServiceTypeProperties
	}
	if abls.ConnectVia != nil {
		objectMap["connectVia"] = abls.ConnectVia
	}
	if abls.Description != nil {
		objectMap["description"] = abls.Description
	}
	if abls.Parameters != nil {
		objectMap["parameters"] = abls.Parameters
	}
	if abls.Annotations != nil {
		objectMap["annotations"] = abls.Annotations
	}
	if abls.Type != "" {
		objectMap["type"] = abls.Type
	}
	for k, v := range abls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return &abls, true
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedService struct.
func (abls *AzureBatchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBatchLinkedServiceTypeProperties AzureBatchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBatchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abls.AzureBatchLinkedServiceTypeProperties = &azureBatchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abls.AdditionalProperties == nil {
					abls.AdditionalProperties = make(map[string]interface{})
				}
				abls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedServiceTypeProperties azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// AccountName - The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// AccessKey - The Azure Batch account access key.
	AccessKey BasicSecretBase `json:"accessKey,omitempty"`
	// BatchURI - The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI interface{} `json:"batchUri,omitempty"`
	// PoolName - The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName interface{} `json:"poolName,omitempty"`
	// LinkedServiceName - The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedServiceTypeProperties struct.
func (ablstp *AzureBatchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				ablstp.AccountName = accountName
			}
		case "accessKey":
			if v != nil {
				accessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				ablstp.AccessKey = accessKey
			}
		case "batchUri":
			if v != nil {
				var batchURI interface{}
				err = json.Unmarshal(*v, &batchURI)
				if err != nil {
					return err
				}
				ablstp.BatchURI = batchURI
			}
		case "poolName":
			if v != nil {
				var poolName interface{}
				err = json.Unmarshal(*v, &poolName)
				if err != nil {
					return err
				}
				ablstp.PoolName = poolName
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ablstp.LinkedServiceName = &linkedServiceName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				ablstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobDataset the Azure Blob storage.
type AzureBlobDataset struct {
	// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
	*AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobDataset.
func (abd AzureBlobDataset) MarshalJSON() ([]byte, error) {
	abd.Type = TypeAzureBlob
	objectMap := make(map[string]interface{})
	if abd.AzureBlobDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abd.AzureBlobDatasetTypeProperties
	}
	if abd.Description != nil {
		objectMap["description"] = abd.Description
	}
	if abd.Structure != nil {
		objectMap["structure"] = abd.Structure
	}
	if abd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abd.LinkedServiceName
	}
	if abd.Parameters != nil {
		objectMap["parameters"] = abd.Parameters
	}
	if abd.Annotations != nil {
		objectMap["annotations"] = abd.Annotations
	}
	if abd.Type != "" {
		objectMap["type"] = abd.Type
	}
	for k, v := range abd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return &abd, true
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDataset struct.
func (abd *AzureBlobDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobDatasetTypeProperties AzureBlobDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobDatasetTypeProperties)
				if err != nil {
					return err
				}
				abd.AzureBlobDatasetTypeProperties = &azureBlobDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abd.AdditionalProperties == nil {
					abd.AdditionalProperties = make(map[string]interface{})
				}
				abd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobDatasetTypeProperties azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// TableRootLocation - The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation interface{} `json:"tableRootLocation,omitempty"`
	// FileName - The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Azure Blob storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDatasetTypeProperties struct.
func (abdtp *AzureBlobDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abdtp.FolderPath = folderPath
			}
		case "tableRootLocation":
			if v != nil {
				var tableRootLocation interface{}
				err = json.Unmarshal(*v, &tableRootLocation)
				if err != nil {
					return err
				}
				abdtp.TableRootLocation = tableRootLocation
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedService azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
	*AzureDatabricksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) MarshalJSON() ([]byte, error) {
	adls.Type = TypeAzureDatabricks
	objectMap := make(map[string]interface{})
	if adls.AzureDatabricksLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adls.AzureDatabricksLinkedServiceTypeProperties
	}
	if adls.ConnectVia != nil {
		objectMap["connectVia"] = adls.ConnectVia
	}
	if adls.Description != nil {
		objectMap["description"] = adls.Description
	}
	if adls.Parameters != nil {
		objectMap["parameters"] = adls.Parameters
	}
	if adls.Annotations != nil {
		objectMap["annotations"] = adls.Annotations
	}
	if adls.Type != "" {
		objectMap["type"] = adls.Type
	}
	for k, v := range adls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return &adls, true
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedService struct.
func (adls *AzureDatabricksLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksLinkedServiceTypeProperties AzureDatabricksLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adls.AzureDatabricksLinkedServiceTypeProperties = &azureDatabricksLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adls.AdditionalProperties == nil {
					adls.AdditionalProperties = make(map[string]interface{})
				}
				adls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedServiceTypeProperties azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// Domain - <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
	Domain interface{} `json:"domain,omitempty"`
	// AccessToken - Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
	AccessToken BasicSecretBase `json:"accessToken,omitempty"`
	// ExistingClusterID - The id of an existing cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
	ExistingClusterID interface{} `json:"existingClusterId,omitempty"`
	// NewClusterVersion - The Spark version of new cluster. Type: string (or Expression with resultType string).
	NewClusterVersion interface{} `json:"newClusterVersion,omitempty"`
	// NewClusterNumOfWorker - Number of worker nodes that new cluster should have. A string formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 as min and 10 as max. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker interface{} `json:"newClusterNumOfWorker,omitempty"`
	// NewClusterNodeType - The node types of new cluster. Type: string (or Expression with resultType string).
	NewClusterNodeType interface{} `json:"newClusterNodeType,omitempty"`
	// NewClusterSparkConf - a set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]interface{} `json:"newClusterSparkConf"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedServiceTypeProperties.
func (adlstp AzureDatabricksLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlstp.Domain != nil {
		objectMap["domain"] = adlstp.Domain
	}
	objectMap["accessToken"] = adlstp.AccessToken
	if adlstp.ExistingClusterID != nil {
		objectMap["existingClusterId"] = adlstp.ExistingClusterID
	}
	if adlstp.NewClusterVersion != nil {
		objectMap["newClusterVersion"] = adlstp.NewClusterVersion
	}
	if adlstp.NewClusterNumOfWorker != nil {
		objectMap["newClusterNumOfWorker"] = adlstp.NewClusterNumOfWorker
	}
	if adlstp.NewClusterNodeType != nil {
		objectMap["newClusterNodeType"] = adlstp.NewClusterNodeType
	}
	if adlstp.NewClusterSparkConf != nil {
		objectMap["newClusterSparkConf"] = adlstp.NewClusterSparkConf
	}
	if adlstp.EncryptedCredential != nil {
		objectMap["encryptedCredential"] = adlstp.EncryptedCredential
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedServiceTypeProperties struct.
func (adlstp *AzureDatabricksLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "domain":
			if v != nil {
				var domain interface{}
				err = json.Unmarshal(*v, &domain)
				if err != nil {
					return err
				}
				adlstp.Domain = domain
			}
		case "accessToken":
			if v != nil {
				accessToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlstp.AccessToken = accessToken
			}
		case "existingClusterId":
			if v != nil {
				var existingClusterID interface{}
				err = json.Unmarshal(*v, &existingClusterID)
				if err != nil {
					return err
				}
				adlstp.ExistingClusterID = existingClusterID
			}
		case "newClusterVersion":
			if v != nil {
				var newClusterVersion interface{}
				err = json.Unmarshal(*v, &newClusterVersion)
				if err != nil {
					return err
				}
				adlstp.NewClusterVersion = newClusterVersion
			}
		case "newClusterNumOfWorker":
			if v != nil {
				var newClusterNumOfWorker interface{}
				err = json.Unmarshal(*v, &newClusterNumOfWorker)
				if err != nil {
					return err
				}
				adlstp.NewClusterNumOfWorker = newClusterNumOfWorker
			}
		case "newClusterNodeType":
			if v != nil {
				var newClusterNodeType interface{}
				err = json.Unmarshal(*v, &newClusterNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterNodeType = newClusterNodeType
			}
		case "newClusterSparkConf":
			if v != nil {
				var newClusterSparkConf map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkConf)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkConf = newClusterSparkConf
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedService azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
	*AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	adlals.Type = TypeAzureDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties
	}
	if adlals.ConnectVia != nil {
		objectMap["connectVia"] = adlals.ConnectVia
	}
	if adlals.Description != nil {
		objectMap["description"] = adlals.Description
	}
	if adlals.Parameters != nil {
		objectMap["parameters"] = adlals.Parameters
	}
	if adlals.Annotations != nil {
		objectMap["annotations"] = adlals.Annotations
	}
	if adlals.Type != "" {
		objectMap["type"] = adlals.Type
	}
	for k, v := range adlals.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return &adlals, true
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlals, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedService struct.
func (adlals *AzureDataLakeAnalyticsLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeAnalyticsLinkedServiceTypeProperties AzureDataLakeAnalyticsLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeAnalyticsLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties = &azureDataLakeAnalyticsLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlals.AdditionalProperties == nil {
					adlals.AdditionalProperties = make(map[string]interface{})
				}
				adlals.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlals.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlals.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlals.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlals.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlals.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// AccountName - The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// SubscriptionID - Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// DataLakeAnalyticsURI - Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI interface{} `json:"dataLakeAnalyticsUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedServiceTypeProperties struct.
func (adlalstp *AzureDataLakeAnalyticsLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlalstp.AccountName = accountName
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlalstp.Tenant = tenant
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlalstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlalstp.ResourceGroupName = resourceGroupName
			}
		case "dataLakeAnalyticsUri":
			if v != nil {
				var dataLakeAnalyticsURI interface{}
				err = json.Unmarshal(*v, &dataLakeAnalyticsURI)
				if err != nil {
					return err
				}
				adlalstp.DataLakeAnalyticsURI = dataLakeAnalyticsURI
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlalstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDataset azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
	*AzureDataLakeStoreDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) MarshalJSON() ([]byte, error) {
	adlsd.Type = TypeAzureDataLakeStoreFile
	objectMap := make(map[string]interface{})
	if adlsd.AzureDataLakeStoreDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adlsd.AzureDataLakeStoreDatasetTypeProperties
	}
	if adlsd.Description != nil {
		objectMap["description"] = adlsd.Description
	}
	if adlsd.Structure != nil {
		objectMap["structure"] = adlsd.Structure
	}
	if adlsd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adlsd.LinkedServiceName
	}
	if adlsd.Parameters != nil {
		objectMap["parameters"] = adlsd.Parameters
	}
	if adlsd.Annotations != nil {
		objectMap["annotations"] = adlsd.Annotations
	}
	if adlsd.Type != "" {
		objectMap["type"] = adlsd.Type
	}
	for k, v := range adlsd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return &adlsd, true
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adlsd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDataset struct.
func (adlsd *AzureDataLakeStoreDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreDatasetTypeProperties AzureDataLakeStoreDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreDatasetTypeProperties)
				if err != nil {
					return err
				}
				adlsd.AzureDataLakeStoreDatasetTypeProperties = &azureDataLakeStoreDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsd.AdditionalProperties == nil {
					adlsd.AdditionalProperties = make(map[string]interface{})
				}
				adlsd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adlsd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adlsd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDatasetTypeProperties azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// FolderPath - Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Data Lake Store.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDatasetTypeProperties struct.
func (adlsdtp *AzureDataLakeStoreDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				adlsdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				adlsdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				adlsdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				adlsdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedService azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
	*AzureDataLakeStoreLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) MarshalJSON() ([]byte, error) {
	adlsls.Type = TypeAzureDataLakeStore
	objectMap := make(map[string]interface{})
	if adlsls.AzureDataLakeStoreLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlsls.AzureDataLakeStoreLinkedServiceTypeProperties
	}
	if adlsls.ConnectVia != nil {
		objectMap["connectVia"] = adlsls.ConnectVia
	}
	if adlsls.Description != nil {
		objectMap["description"] = adlsls.Description
	}
	if adlsls.Parameters != nil {
		objectMap["parameters"] = adlsls.Parameters
	}
	if adlsls.Annotations != nil {
		objectMap["annotations"] = adlsls.Annotations
	}
	if adlsls.Type != "" {
		objectMap["type"] = adlsls.Type
	}
	for k, v := range adlsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return &adlsls, true
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedService struct.
func (adlsls *AzureDataLakeStoreLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreLinkedServiceTypeProperties AzureDataLakeStoreLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlsls.AzureDataLakeStoreLinkedServiceTypeProperties = &azureDataLakeStoreLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsls.AdditionalProperties == nil {
					adlsls.AdditionalProperties = make(map[string]interface{})
				}
				adlsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedServiceTypeProperties azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// DataLakeStoreURI - Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI interface{} `json:"dataLakeStoreUri,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// AccountName - Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// SubscriptionID - Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedServiceTypeProperties struct.
func (adlslstp *AzureDataLakeStoreLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataLakeStoreUri":
			if v != nil {
				var dataLakeStoreURI interface{}
				err = json.Unmarshal(*v, &dataLakeStoreURI)
				if err != nil {
					return err
				}
				adlslstp.DataLakeStoreURI = dataLakeStoreURI
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlslstp.Tenant = tenant
			}
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlslstp.AccountName = accountName
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlslstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlslstp.ResourceGroupName = resourceGroupName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSink a copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSink
	objectMap := make(map[string]interface{})
	if adlss.CopyBehavior != nil {
		objectMap["copyBehavior"] = adlss.CopyBehavior
	}
	if adlss.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = adlss.WriteBatchSize
	}
	if adlss.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = adlss.WriteBatchTimeout
	}
	if adlss.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = adlss.SinkRetryCount
	}
	if adlss.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = adlss.SinkRetryWait
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return &adlss, true
}

// AsOracleSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSink struct.
func (adlss *AzureDataLakeStoreSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				adlss.CopyBehavior = copyBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				adlss.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				adlss.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				adlss.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				adlss.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSource a copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSource
	objectMap := make(map[string]interface{})
	if adlss.Recursive != nil {
		objectMap["recursive"] = adlss.Recursive
	}
	if adlss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = adlss.SourceRetryCount
	}
	if adlss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = adlss.SourceRetryWait
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return &adlss, true
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSource struct.
func (adlss *AzureDataLakeStoreSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				adlss.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				adlss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				adlss.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureKeyVaultLinkedService azure Key Vault linked service.
type AzureKeyVaultLinkedService struct {
	// AzureKeyVaultLinkedServiceTypeProperties - Azure Key Vault linked service properties.
	*AzureKeyVaultLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) MarshalJSON() ([]byte, error) {
	akvls.Type = TypeAzureKeyVault
	objectMap := make(map[string]interface{})
	if akvls.AzureKeyVaultLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = akvls.AzureKeyVaultLinkedServiceTypeProperties
	}
	if akvls.ConnectVia != nil {
		objectMap["connectVia"] = akvls.ConnectVia
	}
	if akvls.Description != nil {
		objectMap["description"] = akvls.Description
	}
	if akvls.Parameters != nil {
		objectMap["parameters"] = akvls.Parameters
	}
	if akvls.Annotations != nil {
		objectMap["annotations"] = akvls.Annotations
	}
	if akvls.Type != "" {
		objectMap["type"] = akvls.Type
	}
	for k, v := range akvls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return &akvls, true
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &akvls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureKeyVaultLinkedService struct.
func (akvls *AzureKeyVaultLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureKeyVaultLinkedServiceTypeProperties AzureKeyVaultLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureKeyVaultLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				akvls.AzureKeyVaultLinkedServiceTypeProperties = &azureKeyVaultLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if akvls.AdditionalProperties == nil {
					akvls.AdditionalProperties = make(map[string]interface{})
				}
				akvls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				akvls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				akvls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				akvls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				akvls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				akvls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureKeyVaultLinkedServiceTypeProperties azure Key Vault linked service properties.
type AzureKeyVaultLinkedServiceTypeProperties struct {
	// BaseURL - The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
	BaseURL interface{} `json:"baseUrl,omitempty"`
}

// AzureKeyVaultSecretReference azure Key Vault secret reference.
type AzureKeyVaultSecretReference struct {
	// Store - The Azure Key Vault linked service reference.
	Store *LinkedServiceReference `json:"store,omitempty"`
	// SecretName - The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
	SecretName interface{} `json:"secretName,omitempty"`
	// SecretVersion - The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
	SecretVersion interface{} `json:"secretVersion,omitempty"`
	// Type - Possible values include: 'TypeSecretBase', 'TypeSecureString', 'TypeAzureKeyVaultSecret'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	akvsr.Type = TypeAzureKeyVaultSecret
	objectMap := make(map[string]interface{})
	if akvsr.Store != nil {
		objectMap["store"] = akvsr.Store
	}
	if akvsr.SecretName != nil {
		objectMap["secretName"] = akvsr.SecretName
	}
	if akvsr.SecretVersion != nil {
		objectMap["secretVersion"] = akvsr.SecretVersion
	}
	if akvsr.Type != "" {
		objectMap["type"] = akvsr.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureString is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecureString() (*SecureString, bool) {
	return nil, false
}

// AsAzureKeyVaultSecretReference is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsAzureKeyVaultSecretReference() (*AzureKeyVaultSecretReference, bool) {
	return &akvsr, true
}

// AsSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecretBase() (*SecretBase, bool) {
	return nil, false
}

// AsBasicSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsBasicSecretBase() (BasicSecretBase, bool) {
	return &akvsr, true
}

// AzureMLBatchExecutionActivity azure ML Batch Execution activity.
type AzureMLBatchExecutionActivity struct {
	// AzureMLBatchExecutionActivityTypeProperties - Azure ML Batch Execution activity properties.
	*AzureMLBatchExecutionActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) MarshalJSON() ([]byte, error) {
	ambea.Type = TypeAzureMLBatchExecution
	objectMap := make(map[string]interface{})
	if ambea.AzureMLBatchExecutionActivityTypeProperties != nil {
		objectMap["typeProperties"] = ambea.AzureMLBatchExecutionActivityTypeProperties
	}
	if ambea.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ambea.LinkedServiceName
	}
	if ambea.Policy != nil {
		objectMap["policy"] = ambea.Policy
	}
	if ambea.Name != nil {
		objectMap["name"] = ambea.Name
	}
	if ambea.Description != nil {
		objectMap["description"] = ambea.Description
	}
	if ambea.DependsOn != nil {
		objectMap["dependsOn"] = ambea.DependsOn
	}
	if ambea.Type != "" {
		objectMap["type"] = ambea.Type
	}
	for k, v := range ambea.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return &ambea, true
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ambea, true
}

// AsFilterActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ambea, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLBatchExecutionActivity struct.
func (ambea *AzureMLBatchExecutionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLBatchExecutionActivityTypeProperties AzureMLBatchExecutionActivityTypeProperties
				err = json.Unmarshal(*v, &azureMLBatchExecutionActivityTypeProperties)
				if err != nil {
					return err
				}
				ambea.AzureMLBatchExecutionActivityTypeProperties = &azureMLBatchExecutionActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ambea.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				ambea.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ambea.AdditionalProperties == nil {
					ambea.AdditionalProperties = make(map[string]interface{})
				}
				ambea.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ambea.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ambea.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ambea.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ambea.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLBatchExecutionActivityTypeProperties azure ML Batch Execution activity properties.
type AzureMLBatchExecutionActivityTypeProperties struct {
	// GlobalParameters - Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
	GlobalParameters map[string]interface{} `json:"globalParameters"`
	// WebServiceOutputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
	WebServiceOutputs map[string]*AzureMLWebServiceFile `json:"webServiceOutputs"`
	// WebServiceInputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
	WebServiceInputs map[string]*AzureMLWebServiceFile `json:"webServiceInputs"`
}

// MarshalJSON is the custom marshaler for AzureMLBatchExecutionActivityTypeProperties.
func (ambeatp AzureMLBatchExecutionActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ambeatp.GlobalParameters != nil {
		objectMap["globalParameters"] = ambeatp.GlobalParameters
	}
	if ambeatp.WebServiceOutputs != nil {
		objectMap["webServiceOutputs"] = ambeatp.WebServiceOutputs
	}
	if ambeatp.WebServiceInputs != nil {
		objectMap["webServiceInputs"] = ambeatp.WebServiceInputs
	}
	return json.Marshal(objectMap)
}

// AzureMLLinkedService azure ML Web Service linked service.
type AzureMLLinkedService struct {
	// AzureMLLinkedServiceTypeProperties - Azure ML Web Service linked service properties.
	*AzureMLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLLinkedService.
func (amls AzureMLLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAzureML
	objectMap := make(map[string]interface{})
	if amls.AzureMLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AzureMLLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return &amls, true
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLLinkedService struct.
func (amls *AzureMLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLLinkedServiceTypeProperties AzureMLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureMLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AzureMLLinkedServiceTypeProperties = &azureMLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLLinkedServiceTypeProperties azure ML Web Service linked service properties.
type AzureMLLinkedServiceTypeProperties struct {
	// MlEndpoint - The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	MlEndpoint interface{} `json:"mlEndpoint,omitempty"`
	// APIKey - The API key for accessing the Azure ML model endpoint.
	APIKey BasicSecretBase `json:"apiKey,omitempty"`
	// UpdateResourceEndpoint - The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	UpdateResourceEndpoint interface{} `json:"updateResourceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureMLLinkedServiceTypeProperties struct.
func (amlstp *AzureMLLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "mlEndpoint":
			if v != nil {
				var mlEndpoint interface{}
				err = json.Unmarshal(*v, &mlEndpoint)
				if err != nil {
					return err
				}
				amlstp.MlEndpoint = mlEndpoint
			}
		case "apiKey":
			if v != nil {
				APIKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.APIKey = APIKey
			}
		case "updateResourceEndpoint":
			if v != nil {
				var updateResourceEndpoint interface{}
				err = json.Unmarshal(*v, &updateResourceEndpoint)
				if err != nil {
					return err
				}
				amlstp.UpdateResourceEndpoint = updateResourceEndpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				amlstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				amlstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureMLUpdateResourceActivity azure ML Update Resource management activity.
type AzureMLUpdateResourceActivity struct {
	// AzureMLUpdateResourceActivityTypeProperties - Azure ML Update Resource management activity properties.
	*AzureMLUpdateResourceActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) MarshalJSON() ([]byte, error) {
	amura.Type = TypeAzureMLUpdateResource
	objectMap := make(map[string]interface{})
	if amura.AzureMLUpdateResourceActivityTypeProperties != nil {
		objectMap["typeProperties"] = amura.AzureMLUpdateResourceActivityTypeProperties
	}
	if amura.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amura.LinkedServiceName
	}
	if amura.Policy != nil {
		objectMap["policy"] = amura.Policy
	}
	if amura.Name != nil {
		objectMap["name"] = amura.Name
	}
	if amura.Description != nil {
		objectMap["description"] = amura.Description
	}
	if amura.DependsOn != nil {
		objectMap["dependsOn"] = amura.DependsOn
	}
	if amura.Type != "" {
		objectMap["type"] = amura.Type
	}
	for k, v := range amura.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return &amura, true
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &amura, true
}

// AsFilterActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicActivity() (BasicActivity, bool) {
	return &amura, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLUpdateResourceActivity struct.
func (amura *AzureMLUpdateResourceActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMLUpdateResourceActivityTypeProperties AzureMLUpdateResourceActivityTypeProperties
				err = json.Unmarshal(*v, &azureMLUpdateResourceActivityTypeProperties)
				if err != nil {
					return err
				}
				amura.AzureMLUpdateResourceActivityTypeProperties = &azureMLUpdateResourceActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amura.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				amura.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amura.AdditionalProperties == nil {
					amura.AdditionalProperties = make(map[string]interface{})
				}
				amura.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				amura.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amura.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				amura.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amura.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMLUpdateResourceActivityTypeProperties azure ML Update Resource activity properties.
type AzureMLUpdateResourceActivityTypeProperties struct {
	// TrainedModelName - Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
	TrainedModelName interface{} `json:"trainedModelName,omitempty"`
	// TrainedModelLinkedServiceName - Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
	TrainedModelLinkedServiceName *LinkedServiceReference `json:"trainedModelLinkedServiceName,omitempty"`
	// TrainedModelFilePath - The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
	TrainedModelFilePath interface{} `json:"trainedModelFilePath,omitempty"`
}

// AzureMLWebServiceFile azure ML WebService Input/Output file
type AzureMLWebServiceFile struct {
	// FilePath - The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
	FilePath interface{} `json:"filePath,omitempty"`
	// LinkedServiceName - Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
}

// AzureMySQLLinkedService azure MySQL database linked service.
type AzureMySQLLinkedService struct {
	// AzureMySQLLinkedServiceTypeProperties - Azure MySQL database linked service properties.
	*AzureMySQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) MarshalJSON() ([]byte, error) {
	amsls.Type = TypeAzureMySQL
	objectMap := make(map[string]interface{})
	if amsls.AzureMySQLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amsls.AzureMySQLLinkedServiceTypeProperties
	}
	if amsls.ConnectVia != nil {
		objectMap["connectVia"] = amsls.ConnectVia
	}
	if amsls.Description != nil {
		objectMap["description"] = amsls.Description
	}
	if amsls.Parameters != nil {
		objectMap["parameters"] = amsls.Parameters
	}
	if amsls.Annotations != nil {
		objectMap["annotations"] = amsls.Annotations
	}
	if amsls.Type != "" {
		objectMap["type"] = amsls.Type
	}
	for k, v := range amsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return &amsls, true
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLLinkedService struct.
func (amsls *AzureMySQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMySQLLinkedServiceTypeProperties AzureMySQLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureMySQLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amsls.AzureMySQLLinkedServiceTypeProperties = &azureMySQLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amsls.AdditionalProperties == nil {
					amsls.AdditionalProperties = make(map[string]interface{})
				}
				amsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLLinkedServiceTypeProperties azure MySQL database linked service properties.
type AzureMySQLLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AzureMySQLSource a copy activity Azure MySQL source.
type AzureMySQLSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLSource.
func (amss AzureMySQLSource) MarshalJSON() ([]byte, error) {
	amss.Type = TypeAzureMySQLSource
	objectMap := make(map[string]interface{})
	if amss.Query != nil {
		objectMap["query"] = amss.Query
	}
	if amss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = amss.SourceRetryCount
	}
	if amss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = amss.SourceRetryWait
	}
	if amss.Type != "" {
		objectMap["type"] = amss.Type
	}
	for k, v := range amss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return &amss, true
}

// AsHdfsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &amss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLSource struct.
func (amss *AzureMySQLSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				amss.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amss.AdditionalProperties == nil {
					amss.AdditionalProperties = make(map[string]interface{})
				}
				amss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				amss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				amss.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLTableDataset the Azure MySQL database dataset.
type AzureMySQLTableDataset struct {
	// AzureMySQLTableDatasetTypeProperties - Azure MySQL database dataset properties.
	*AzureMySQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) MarshalJSON() ([]byte, error) {
	amstd.Type = TypeAzureMySQLTable
	objectMap := make(map[string]interface{})
	if amstd.AzureMySQLTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = amstd.AzureMySQLTableDatasetTypeProperties
	}
	if amstd.Description != nil {
		objectMap["description"] = amstd.Description
	}
	if amstd.Structure != nil {
		objectMap["structure"] = amstd.Structure
	}
	if amstd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amstd.LinkedServiceName
	}
	if amstd.Parameters != nil {
		objectMap["parameters"] = amstd.Parameters
	}
	if amstd.Annotations != nil {
		objectMap["annotations"] = amstd.Annotations
	}
	if amstd.Type != "" {
		objectMap["type"] = amstd.Type
	}
	for k, v := range amstd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return &amstd, true
}

// AsOracleTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amstd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLTableDataset struct.
func (amstd *AzureMySQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureMySQLTableDatasetTypeProperties AzureMySQLTableDatasetTypeProperties
				err = json.Unmarshal(*v, &azureMySQLTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				amstd.AzureMySQLTableDatasetTypeProperties = &azureMySQLTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amstd.AdditionalProperties == nil {
					amstd.AdditionalProperties = make(map[string]interface{})
				}
				amstd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amstd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amstd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amstd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amstd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amstd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amstd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMySQLTableDatasetTypeProperties azure MySQL database dataset properties.
type AzureMySQLTableDatasetTypeProperties struct {
	// TableName - The Azure MySQL database table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzurePostgreSQLLinkedService azure PostgreSQL linked service.
type AzurePostgreSQLLinkedService struct {
	// AzurePostgreSQLLinkedServiceTypeProperties - Azure PostgreSQL linked service properties.
	*AzurePostgreSQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) MarshalJSON() ([]byte, error) {
	apsls.Type = TypeAzurePostgreSQL
	objectMap := make(map[string]interface{})
	if apsls.AzurePostgreSQLLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = apsls.AzurePostgreSQLLinkedServiceTypeProperties
	}
	if apsls.ConnectVia != nil {
		objectMap["connectVia"] = apsls.ConnectVia
	}
	if apsls.Description != nil {
		objectMap["description"] = apsls.Description
	}
	if apsls.Parameters != nil {
		objectMap["parameters"] = apsls.Parameters
	}
	if apsls.Annotations != nil {
		objectMap["annotations"] = apsls.Annotations
	}
	if apsls.Type != "" {
		objectMap["type"] = apsls.Type
	}
	for k, v := range apsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return &apsls, true
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &apsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLLinkedService struct.
func (apsls *AzurePostgreSQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azurePostgreSQLLinkedServiceTypeProperties AzurePostgreSQLLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azurePostgreSQLLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				apsls.AzurePostgreSQLLinkedServiceTypeProperties = &azurePostgreSQLLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apsls.AdditionalProperties == nil {
					apsls.AdditionalProperties = make(map[string]interface{})
				}
				apsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				apsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				apsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				apsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				apsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzurePostgreSQLLinkedServiceTypeProperties azure PostgreSQL linked service properties.
type AzurePostgreSQLLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AzurePostgreSQLSource a copy activity Azure PostgreSQL source.
type AzurePostgreSQLSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) MarshalJSON() ([]byte, error) {
	apss.Type = TypeAzurePostgreSQLSource
	objectMap := make(map[string]interface{})
	if apss.Query != nil {
		objectMap["query"] = apss.Query
	}
	if apss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = apss.SourceRetryCount
	}
	if apss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = apss.SourceRetryWait
	}
	if apss.Type != "" {
		objectMap["type"] = apss.Type
	}
	for k, v := range apss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return &apss, true
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &apss, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLSource struct.
func (apss *AzurePostgreSQLSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				apss.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apss.AdditionalProperties == nil {
					apss.AdditionalProperties = make(map[string]interface{})
				}
				apss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				apss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				apss.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apss.Type = typeVar
			}
		}
	}

	return nil
}

// AzurePostgreSQLTableDataset azure PostgreSQL dataset.
type AzurePostgreSQLTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) MarshalJSON() ([]byte, error) {
	apstd.Type = TypeAzurePostgreSQLTable
	objectMap := make(map[string]interface{})
	if apstd.Description != nil {
		objectMap["description"] = apstd.Description
	}
	if apstd.Structure != nil {
		objectMap["structure"] = apstd.Structure
	}
	if apstd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = apstd.LinkedServiceName
	}
	if apstd.Parameters != nil {
		objectMap["parameters"] = apstd.Parameters
	}
	if apstd.Annotations != nil {
		objectMap["annotations"] = apstd.Annotations
	}
	if apstd.Type != "" {
		objectMap["type"] = apstd.Type
	}
	for k, v := range apstd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return &apstd, true
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &apstd, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLTableDataset struct.
func (apstd *AzurePostgreSQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apstd.AdditionalProperties == nil {
					apstd.AdditionalProperties = make(map[string]interface{})
				}
				apstd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				apstd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				apstd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				apstd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				apstd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				apstd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apstd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureQueueSink a copy activity Azure Queue sink.
type AzureQueueSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureQueueSink.
func (aqs AzureQueueSink) MarshalJSON() ([]byte, error) {
	aqs.Type = TypeAzureQueueSink
	objectMap := make(map[string]interface{})
	if aqs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = aqs.WriteBatchSize
	}
	if aqs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = aqs.WriteBatchTimeout
	}
	if aqs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = aqs.SinkRetryCount
	}
	if aqs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = aqs.SinkRetryWait
	}
	if aqs.Type != "" {
		objectMap["type"] = aqs.Type
	}
	for k, v := range aqs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return &aqs, true
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &aqs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureQueueSink struct.
func (aqs *AzureQueueSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if aqs.AdditionalProperties == nil {
					aqs.AdditionalProperties = make(map[string]interface{})
				}
				aqs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				aqs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				aqs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				aqs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				aqs.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aqs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchIndexDataset the Azure Search Index.
type AzureSearchIndexDataset struct {
	// AzureSearchIndexDatasetTypeProperties - Properties specific to this dataset type.
	*AzureSearchIndexDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) MarshalJSON() ([]byte, error) {
	asid.Type = TypeAzureSearchIndex
	objectMap := make(map[string]interface{})
	if asid.AzureSearchIndexDatasetTypeProperties != nil {
		objectMap["typeProperties"] = asid.AzureSearchIndexDatasetTypeProperties
	}
	if asid.Description != nil {
		objectMap["description"] = asid.Description
	}
	if asid.Structure != nil {
		objectMap["structure"] = asid.Structure
	}
	if asid.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asid.LinkedServiceName
	}
	if asid.Parameters != nil {
		objectMap["parameters"] = asid.Parameters
	}
	if asid.Annotations != nil {
		objectMap["annotations"] = asid.Annotations
	}
	if asid.Type != "" {
		objectMap["type"] = asid.Type
	}
	for k, v := range asid.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return &asid, true
}

// AsWebTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsBasicDataset() (BasicDataset, bool) {
	return &asid, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchIndexDataset struct.
func (asid *AzureSearchIndexDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSearchIndexDatasetTypeProperties AzureSearchIndexDatasetTypeProperties
				err = json.Unmarshal(*v, &azureSearchIndexDatasetTypeProperties)
				if err != nil {
					return err
				}
				asid.AzureSearchIndexDatasetTypeProperties = &azureSearchIndexDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asid.AdditionalProperties == nil {
					asid.AdditionalProperties = make(map[string]interface{})
				}
				asid.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asid.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asid.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asid.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asid.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asid.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asid.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchIndexDatasetTypeProperties properties specific to this dataset type.
type AzureSearchIndexDatasetTypeProperties struct {
	// IndexName - The name of the Azure Search Index. Type: string (or Expression with resultType string).
	IndexName interface{} `json:"indexName,omitempty"`
}

// AzureSearchIndexSink a copy activity Azure Search Index sink.
type AzureSearchIndexSink struct {
	// WriteBehavior - Specify the write behavior when upserting documents into Azure Search Index.
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) MarshalJSON() ([]byte, error) {
	asis.Type = TypeAzureSearchIndexSink
	objectMap := make(map[string]interface{})
	if asis.WriteBehavior != nil {
		objectMap["writeBehavior"] = asis.WriteBehavior
	}
	if asis.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = asis.WriteBatchSize
	}
	if asis.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = asis.WriteBatchTimeout
	}
	if asis.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = asis.SinkRetryCount
	}
	if asis.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = asis.SinkRetryWait
	}
	if asis.Type != "" {
		objectMap["type"] = asis.Type
	}
	for k, v := range asis.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return &asis, true
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &asis, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchIndexSink struct.
func (asis *AzureSearchIndexSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "writeBehavior":
			if v != nil {
				var writeBehavior interface{}
				err = json.Unmarshal(*v, &writeBehavior)
				if err != nil {
					return err
				}
				asis.WriteBehavior = writeBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asis.AdditionalProperties == nil {
					asis.AdditionalProperties = make(map[string]interface{})
				}
				asis.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				asis.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				asis.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				asis.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				asis.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asis.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchLinkedService linked service for Windows Azure Search Service.
type AzureSearchLinkedService struct {
	// AzureSearchLinkedServiceTypeProperties - Windows Azure Search Service linked service properties.
	*AzureSearchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAzureSearch
	objectMap := make(map[string]interface{})
	if asls.AzureSearchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AzureSearchLinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return &asls, true
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchLinkedService struct.
func (asls *AzureSearchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSearchLinkedServiceTypeProperties AzureSearchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureSearchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AzureSearchLinkedServiceTypeProperties = &azureSearchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSearchLinkedServiceTypeProperties windows Azure Search Service linked service properties.
type AzureSearchLinkedServiceTypeProperties struct {
	// URL - URL for Azure Search service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`
	// Key - Admin Key for Azure Search service
	Key BasicSecretBase `json:"key,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchLinkedServiceTypeProperties struct.
func (aslstp *AzureSearchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL interface{}
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				aslstp.URL = URL
			}
		case "key":
			if v != nil {
				key, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.Key = key
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureSQLDatabaseLinkedService microsoft Azure SQL Database linked service.
type AzureSQLDatabaseLinkedService struct {
	// AzureSQLDatabaseLinkedServiceTypeProperties - Azure SQL Database linked service properties.
	*AzureSQLDatabaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDatabase
	objectMap := make(map[string]interface{})
	if asdls.AzureSQLDatabaseLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asdls.AzureSQLDatabaseLinkedServiceTypeProperties
	}
	if asdls.ConnectVia != nil {
		objectMap["connectVia"] = asdls.ConnectVia
	}
	if asdls.Description != nil {
		objectMap["description"] = asdls.Description
	}
	if asdls.Parameters != nil {
		objectMap["parameters"] = asdls.Parameters
	}
	if asdls.Annotations != nil {
		objectMap["annotations"] = asdls.Annotations
	}
	if asdls.Type != "" {
		objectMap["type"] = asdls.Type
	}
	for k, v := range asdls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return &asdls, true
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asdls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseLinkedService struct.
func (asdls *AzureSQLDatabaseLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSQLDatabaseLinkedServiceTypeProperties AzureSQLDatabaseLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureSQLDatabaseLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asdls.AzureSQLDatabaseLinkedServiceTypeProperties = &azureSQLDatabaseLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asdls.AdditionalProperties == nil {
					asdls.AdditionalProperties = make(map[string]interface{})
				}
				asdls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asdls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asdls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asdls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asdls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDatabaseLinkedServiceTypeProperties azure SQL Database linked service properties.
type AzureSQLDatabaseLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Database.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseLinkedServiceTypeProperties struct.
func (asdlstp *AzureSQLDatabaseLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				asdlstp.ConnectionString = connectionString
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				asdlstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				asdlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureSQLDWLinkedService azure SQL Data Warehouse linked service.
type AzureSQLDWLinkedService struct {
	// AzureSQLDWLinkedServiceTypeProperties - Azure SQL Data Warehouse linked service properties.
	*AzureSQLDWLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDW
	objectMap := make(map[string]interface{})
	if asdls.AzureSQLDWLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asdls.AzureSQLDWLinkedServiceTypeProperties
	}
	if asdls.ConnectVia != nil {
		objectMap["connectVia"] = asdls.ConnectVia
	}
	if asdls.Description != nil {
		objectMap["description"] = asdls.Description
	}
	if asdls.Parameters != nil {
		objectMap["parameters"] = asdls.Parameters
	}
	if asdls.Annotations != nil {
		objectMap["annotations"] = asdls.Annotations
	}
	if asdls.Type != "" {
		objectMap["type"] = asdls.Type
	}
	for k, v := range asdls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return &asdls, true
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asdls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDWLinkedService struct.
func (asdls *AzureSQLDWLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSQLDWLinkedServiceTypeProperties AzureSQLDWLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureSQLDWLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asdls.AzureSQLDWLinkedServiceTypeProperties = &azureSQLDWLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asdls.AdditionalProperties == nil {
					asdls.AdditionalProperties = make(map[string]interface{})
				}
				asdls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asdls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asdls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asdls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asdls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDWLinkedServiceTypeProperties azure SQL Data Warehouse linked service properties.
type AzureSQLDWLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDWLinkedServiceTypeProperties struct.
func (asdlstp *AzureSQLDWLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				asdlstp.ConnectionString = connectionString
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				asdlstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				asdlstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				asdlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureSQLDWTableDataset the Azure SQL Data Warehouse dataset.
type AzureSQLDWTableDataset struct {
	// AzureSQLDWTableDatasetTypeProperties - Azure SQL Data Warehouse dataset properties.
	*AzureSQLDWTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) MarshalJSON() ([]byte, error) {
	asdtd.Type = TypeAzureSQLDWTable
	objectMap := make(map[string]interface{})
	if asdtd.AzureSQLDWTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = asdtd.AzureSQLDWTableDatasetTypeProperties
	}
	if asdtd.Description != nil {
		objectMap["description"] = asdtd.Description
	}
	if asdtd.Structure != nil {
		objectMap["structure"] = asdtd.Structure
	}
	if asdtd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asdtd.LinkedServiceName
	}
	if asdtd.Parameters != nil {
		objectMap["parameters"] = asdtd.Parameters
	}
	if asdtd.Annotations != nil {
		objectMap["annotations"] = asdtd.Annotations
	}
	if asdtd.Type != "" {
		objectMap["type"] = asdtd.Type
	}
	for k, v := range asdtd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return &asdtd, true
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &asdtd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDWTableDataset struct.
func (asdtd *AzureSQLDWTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSQLDWTableDatasetTypeProperties AzureSQLDWTableDatasetTypeProperties
				err = json.Unmarshal(*v, &azureSQLDWTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				asdtd.AzureSQLDWTableDatasetTypeProperties = &azureSQLDWTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asdtd.AdditionalProperties == nil {
					asdtd.AdditionalProperties = make(map[string]interface{})
				}
				asdtd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asdtd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asdtd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asdtd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asdtd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asdtd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdtd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDWTableDatasetTypeProperties azure SQL Data Warehouse dataset properties.
type AzureSQLDWTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureSQLTableDataset the Azure SQL Server database dataset.
type AzureSQLTableDataset struct {
	// AzureSQLTableDatasetTypeProperties - Azure SQL dataset properties.
	*AzureSQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) MarshalJSON() ([]byte, error) {
	astd.Type = TypeAzureSQLTable
	objectMap := make(map[string]interface{})
	if astd.AzureSQLTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = astd.AzureSQLTableDatasetTypeProperties
	}
	if astd.Description != nil {
		objectMap["description"] = astd.Description
	}
	if astd.Structure != nil {
		objectMap["structure"] = astd.Structure
	}
	if astd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = astd.LinkedServiceName
	}
	if astd.Parameters != nil {
		objectMap["parameters"] = astd.Parameters
	}
	if astd.Annotations != nil {
		objectMap["annotations"] = astd.Annotations
	}
	if astd.Type != "" {
		objectMap["type"] = astd.Type
	}
	for k, v := range astd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return &astd, true
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &astd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLTableDataset struct.
func (astd *AzureSQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureSQLTableDatasetTypeProperties AzureSQLTableDatasetTypeProperties
				err = json.Unmarshal(*v, &azureSQLTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				astd.AzureSQLTableDatasetTypeProperties = &azureSQLTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if astd.AdditionalProperties == nil {
					astd.AdditionalProperties = make(map[string]interface{})
				}
				astd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				astd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				astd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				astd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				astd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				astd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				astd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLTableDatasetTypeProperties azure SQL dataset properties.
type AzureSQLTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure SQL database. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureStorageLinkedService the storage account linked service.
type AzureStorageLinkedService struct {
	// AzureStorageLinkedServiceTypeProperties - Azure Storage linked service properties.
	*AzureStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAzureStorage
	objectMap := make(map[string]interface{})
	if asls.AzureStorageLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AzureStorageLinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return &asls, true
}

// AsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureStorageLinkedService struct.
func (asls *AzureStorageLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureStorageLinkedServiceTypeProperties AzureStorageLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureStorageLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AzureStorageLinkedServiceTypeProperties = &azureStorageLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureStorageLinkedServiceTypeProperties azure Storage linked service properties.
type AzureStorageLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// SasURI - SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
	SasURI BasicSecretBase `json:"sasUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureStorageLinkedServiceTypeProperties struct.
func (aslstp *AzureStorageLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				aslstp.ConnectionString = connectionString
			}
		case "sasUri":
			if v != nil {
				sasURI, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SasURI = sasURI
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureTableDataset the Azure Table storage dataset.
type AzureTableDataset struct {
	// AzureTableDatasetTypeProperties - Azure Table dataset properties.
	*AzureTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableDataset.
func (atd AzureTableDataset) MarshalJSON() ([]byte, error) {
	atd.Type = TypeAzureTable
	objectMap := make(map[string]interface{})
	if atd.AzureTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = atd.AzureTableDatasetTypeProperties
	}
	if atd.Description != nil {
		objectMap["description"] = atd.Description
	}
	if atd.Structure != nil {
		objectMap["structure"] = atd.Structure
	}
	if atd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = atd.LinkedServiceName
	}
	if atd.Parameters != nil {
		objectMap["parameters"] = atd.Parameters
	}
	if atd.Annotations != nil {
		objectMap["annotations"] = atd.Annotations
	}
	if atd.Type != "" {
		objectMap["type"] = atd.Type
	}
	for k, v := range atd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return &atd, true
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &atd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableDataset struct.
func (atd *AzureTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureTableDatasetTypeProperties AzureTableDatasetTypeProperties
				err = json.Unmarshal(*v, &azureTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				atd.AzureTableDatasetTypeProperties = &azureTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if atd.AdditionalProperties == nil {
					atd.AdditionalProperties = make(map[string]interface{})
				}
				atd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				atd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				atd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				atd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				atd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				atd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureTableDatasetTypeProperties azure Table dataset properties.
type AzureTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure Table storage. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureTableSink a copy activity Azure Table sink.
type AzureTableSink struct {
	// AzureTableDefaultPartitionKeyValue - Azure Table default partition key value. Type: string (or Expression with resultType string).
	AzureTableDefaultPartitionKeyValue interface{} `json:"azureTableDefaultPartitionKeyValue,omitempty"`
	// AzureTablePartitionKeyName - Azure Table partition key name. Type: string (or Expression with resultType string).
	AzureTablePartitionKeyName interface{} `json:"azureTablePartitionKeyName,omitempty"`
	// AzureTableRowKeyName - Azure Table row key name. Type: string (or Expression with resultType string).
	AzureTableRowKeyName interface{} `json:"azureTableRowKeyName,omitempty"`
	// AzureTableInsertType - Azure Table insert type. Type: string (or Expression with resultType string).
	AzureTableInsertType interface{} `json:"azureTableInsertType,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableSink.
func (ats AzureTableSink) MarshalJSON() ([]byte, error) {
	ats.Type = TypeAzureTableSink
	objectMap := make(map[string]interface{})
	if ats.AzureTableDefaultPartitionKeyValue != nil {
		objectMap["azureTableDefaultPartitionKeyValue"] = ats.AzureTableDefaultPartitionKeyValue
	}
	if ats.AzureTablePartitionKeyName != nil {
		objectMap["azureTablePartitionKeyName"] = ats.AzureTablePartitionKeyName
	}
	if ats.AzureTableRowKeyName != nil {
		objectMap["azureTableRowKeyName"] = ats.AzureTableRowKeyName
	}
	if ats.AzureTableInsertType != nil {
		objectMap["azureTableInsertType"] = ats.AzureTableInsertType
	}
	if ats.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = ats.WriteBatchSize
	}
	if ats.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = ats.WriteBatchTimeout
	}
	if ats.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = ats.SinkRetryCount
	}
	if ats.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = ats.SinkRetryWait
	}
	if ats.Type != "" {
		objectMap["type"] = ats.Type
	}
	for k, v := range ats.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return &ats, true
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ats, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableSink struct.
func (ats *AzureTableSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "azureTableDefaultPartitionKeyValue":
			if v != nil {
				var azureTableDefaultPartitionKeyValue interface{}
				err = json.Unmarshal(*v, &azureTableDefaultPartitionKeyValue)
				if err != nil {
					return err
				}
				ats.AzureTableDefaultPartitionKeyValue = azureTableDefaultPartitionKeyValue
			}
		case "azureTablePartitionKeyName":
			if v != nil {
				var azureTablePartitionKeyName interface{}
				err = json.Unmarshal(*v, &azureTablePartitionKeyName)
				if err != nil {
					return err
				}
				ats.AzureTablePartitionKeyName = azureTablePartitionKeyName
			}
		case "azureTableRowKeyName":
			if v != nil {
				var azureTableRowKeyName interface{}
				err = json.Unmarshal(*v, &azureTableRowKeyName)
				if err != nil {
					return err
				}
				ats.AzureTableRowKeyName = azureTableRowKeyName
			}
		case "azureTableInsertType":
			if v != nil {
				var azureTableInsertType interface{}
				err = json.Unmarshal(*v, &azureTableInsertType)
				if err != nil {
					return err
				}
				ats.AzureTableInsertType = azureTableInsertType
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ats.AdditionalProperties == nil {
					ats.AdditionalProperties = make(map[string]interface{})
				}
				ats.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				ats.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				ats.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				ats.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				ats.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ats.Type = typeVar
			}
		}
	}

	return nil
}

// AzureTableSource a copy activity Azure Table source.
type AzureTableSource struct {
	// AzureTableSourceQuery - Azure Table source query. Type: string (or Expression with resultType string).
	AzureTableSourceQuery interface{} `json:"azureTableSourceQuery,omitempty"`
	// AzureTableSourceIgnoreTableNotFound - Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
	AzureTableSourceIgnoreTableNotFound interface{} `json:"azureTableSourceIgnoreTableNotFound,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableSource.
func (ats AzureTableSource) MarshalJSON() ([]byte, error) {
	ats.Type = TypeAzureTableSource
	objectMap := make(map[string]interface{})
	if ats.AzureTableSourceQuery != nil {
		objectMap["azureTableSourceQuery"] = ats.AzureTableSourceQuery
	}
	if ats.AzureTableSourceIgnoreTableNotFound != nil {
		objectMap["azureTableSourceIgnoreTableNotFound"] = ats.AzureTableSourceIgnoreTableNotFound
	}
	if ats.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ats.SourceRetryCount
	}
	if ats.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ats.SourceRetryWait
	}
	if ats.Type != "" {
		objectMap["type"] = ats.Type
	}
	for k, v := range ats.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return &ats, true
}

// AsCopySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ats, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableSource struct.
func (ats *AzureTableSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "azureTableSourceQuery":
			if v != nil {
				var azureTableSourceQuery interface{}
				err = json.Unmarshal(*v, &azureTableSourceQuery)
				if err != nil {
					return err
				}
				ats.AzureTableSourceQuery = azureTableSourceQuery
			}
		case "azureTableSourceIgnoreTableNotFound":
			if v != nil {
				var azureTableSourceIgnoreTableNotFound interface{}
				err = json.Unmarshal(*v, &azureTableSourceIgnoreTableNotFound)
				if err != nil {
					return err
				}
				ats.AzureTableSourceIgnoreTableNotFound = azureTableSourceIgnoreTableNotFound
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ats.AdditionalProperties == nil {
					ats.AdditionalProperties = make(map[string]interface{})
				}
				ats.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ats.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ats.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ats.Type = typeVar
			}
		}
	}

	return nil
}

// BlobEventsTrigger trigger that runs every time a Blob event occurs.
type BlobEventsTrigger struct {
	// BlobEventsTriggerTypeProperties - Blob Events Trigger properties.
	*BlobEventsTriggerTypeProperties `json:"typeProperties,omitempty"`
	// Pipelines - Pipelines that need to be started.
	Pipelines *[]TriggerPipelineReference `json:"pipelines,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Trigger description.
	Description *string `json:"description,omitempty"`
	// RuntimeState - READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. Possible values include: 'TriggerRuntimeStateStarted', 'TriggerRuntimeStateStopped', 'TriggerRuntimeStateDisabled'
	RuntimeState TriggerRuntimeState `json:"runtimeState,omitempty"`
	// Type - Possible values include: 'TypeTrigger', 'TypeTumblingWindowTrigger', 'TypeBlobEventsTrigger', 'TypeBlobTrigger', 'TypeScheduleTrigger', 'TypeMultiplePipelineTrigger'
	Type TypeBasicTrigger `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobEventsTrigger.
func (bet BlobEventsTrigger) MarshalJSON() ([]byte, error) {
	bet.Type = TypeBlobEventsTrigger
	objectMap := make(map[string]interface{})
	if bet.BlobEventsTriggerTypeProperties != nil {
		objectMap["typeProperties"] = bet.BlobEventsTriggerTypeProperties
	}
	if bet.Pipelines != nil {
		objectMap["pipelines"] = bet.Pipelines
	}
	if bet.Description != nil {
		objectMap["description"] = bet.Description
	}
	if bet.Type != "" {
		objectMap["type"] = bet.Type
	}
	for k, v := range bet.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsTumblingWindowTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsTumblingWindowTrigger() (*TumblingWindowTrigger, bool) {
	return nil, false
}

// AsBlobEventsTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsBlobEventsTrigger() (*BlobEventsTrigger, bool) {
	return &bet, true
}

// AsBlobTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsBlobTrigger() (*BlobTrigger, bool) {
	return nil, false
}

// AsScheduleTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsScheduleTrigger() (*ScheduleTrigger, bool) {
	return nil, false
}

// AsMultiplePipelineTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsMultiplePipelineTrigger() (*MultiplePipelineTrigger, bool) {
	return nil, false
}

// AsBasicMultiplePipelineTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsBasicMultiplePipelineTrigger() (BasicMultiplePipelineTrigger, bool) {
	return &bet, true
}

// AsTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for BlobEventsTrigger.
func (bet BlobEventsTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &bet, true
}

// UnmarshalJSON is the custom unmarshaler for BlobEventsTrigger struct.
func (bet *BlobEventsTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var blobEventsTriggerTypeProperties BlobEventsTriggerTypeProperties
				err = json.Unmarshal(*v, &blobEventsTriggerTypeProperties)
				if err != nil {
					return err
				}
				bet.BlobEventsTriggerTypeProperties = &blobEventsTriggerTypeProperties
			}
		case "pipelines":
			if v != nil {
				var pipelines []TriggerPipelineReference
				err = json.Unmarshal(*v, &pipelines)
				if err != nil {
					return err
				}
				bet.Pipelines = &pipelines
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if bet.AdditionalProperties == nil {
					bet.AdditionalProperties = make(map[string]interface{})
				}
				bet.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				bet.Description = &description
			}
		case "runtimeState":
			if v != nil {
				var runtimeState TriggerRuntimeState
				err = json.Unmarshal(*v, &runtimeState)
				if err != nil {
					return err
				}
				bet.RuntimeState = runtimeState
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicTrigger
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bet.Type = typeVar
			}
		}
	}

	return nil
}

// BlobEventsTriggerTypeProperties blob Events Trigger properties.
type BlobEventsTriggerTypeProperties struct {
	// BlobPathBeginsWith - The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathBeginsWith *string `json:"blobPathBeginsWith,omitempty"`
	// BlobPathEndsWith - The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathEndsWith *string `json:"blobPathEndsWith,omitempty"`
	// IgnoreEmptyBlobs - If set to true, blobs with zero bytes will be ignored.
	IgnoreEmptyBlobs *bool `json:"ignoreEmptyBlobs,omitempty"`
	// Events - The type of events that cause this trigger to fire.
	Events *[]BlobEventTypes `json:"events,omitempty"`
	// Scope - The ARM resource ID of the Storage Account.
	Scope *string `json:"scope,omitempty"`
}

// BlobSink a copy activity Azure Blob sink.
type BlobSink struct {
	// BlobWriterOverwriteFiles - Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
	BlobWriterOverwriteFiles interface{} `json:"blobWriterOverwriteFiles,omitempty"`
	// BlobWriterDateTimeFormat - Blob writer date time format. Type: string (or Expression with resultType string).
	BlobWriterDateTimeFormat interface{} `json:"blobWriterDateTimeFormat,omitempty"`
	// BlobWriterAddHeader - Blob writer add header. Type: boolean (or Expression with resultType boolean).
	BlobWriterAddHeader interface{} `json:"blobWriterAddHeader,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobSink.
func (bs BlobSink) MarshalJSON() ([]byte, error) {
	bs.Type = TypeBlobSink
	objectMap := make(map[string]interface{})
	if bs.BlobWriterOverwriteFiles != nil {
		objectMap["blobWriterOverwriteFiles"] = bs.BlobWriterOverwriteFiles
	}
	if bs.BlobWriterDateTimeFormat != nil {
		objectMap["blobWriterDateTimeFormat"] = bs.BlobWriterDateTimeFormat
	}
	if bs.BlobWriterAddHeader != nil {
		objectMap["blobWriterAddHeader"] = bs.BlobWriterAddHeader
	}
	if bs.CopyBehavior != nil {
		objectMap["copyBehavior"] = bs.CopyBehavior
	}
	if bs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = bs.WriteBatchSize
	}
	if bs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = bs.WriteBatchTimeout
	}
	if bs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = bs.SinkRetryCount
	}
	if bs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = bs.SinkRetryWait
	}
	if bs.Type != "" {
		objectMap["type"] = bs.Type
	}
	for k, v := range bs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsBlobSink() (*BlobSink, bool) {
	return &bs, true
}

// AsAzureTableSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &bs, true
}

// UnmarshalJSON is the custom unmarshaler for BlobSink struct.
func (bs *BlobSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "blobWriterOverwriteFiles":
			if v != nil {
				var blobWriterOverwriteFiles interface{}
				err = json.Unmarshal(*v, &blobWriterOverwriteFiles)
				if err != nil {
					return err
				}
				bs.BlobWriterOverwriteFiles = blobWriterOverwriteFiles
			}
		case "blobWriterDateTimeFormat":
			if v != nil {
				var blobWriterDateTimeFormat interface{}
				err = json.Unmarshal(*v, &blobWriterDateTimeFormat)
				if err != nil {
					return err
				}
				bs.BlobWriterDateTimeFormat = blobWriterDateTimeFormat
			}
		case "blobWriterAddHeader":
			if v != nil {
				var blobWriterAddHeader interface{}
				err = json.Unmarshal(*v, &blobWriterAddHeader)
				if err != nil {
					return err
				}
				bs.BlobWriterAddHeader = blobWriterAddHeader
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				bs.CopyBehavior = copyBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if bs.AdditionalProperties == nil {
					bs.AdditionalProperties = make(map[string]interface{})
				}
				bs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				bs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				bs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				bs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				bs.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = typeVar
			}
		}
	}

	return nil
}

// BlobSource a copy activity Azure Blob source.
type BlobSource struct {
	// TreatEmptyAsNull - Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
	// SkipHeaderLineCount - Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobSource.
func (bs BlobSource) MarshalJSON() ([]byte, error) {
	bs.Type = TypeBlobSource
	objectMap := make(map[string]interface{})
	if bs.TreatEmptyAsNull != nil {
		objectMap["treatEmptyAsNull"] = bs.TreatEmptyAsNull
	}
	if bs.SkipHeaderLineCount != nil {
		objectMap["skipHeaderLineCount"] = bs.SkipHeaderLineCount
	}
	if bs.Recursive != nil {
		objectMap["recursive"] = bs.Recursive
	}
	if bs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = bs.SourceRetryCount
	}
	if bs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = bs.SourceRetryWait
	}
	if bs.Type != "" {
		objectMap["type"] = bs.Type
	}
	for k, v := range bs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsBlobSource() (*BlobSource, bool) {
	return &bs, true
}

// AsAzureTableSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &bs, true
}

// UnmarshalJSON is the custom unmarshaler for BlobSource struct.
func (bs *BlobSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "treatEmptyAsNull":
			if v != nil {
				var treatEmptyAsNull interface{}
				err = json.Unmarshal(*v, &treatEmptyAsNull)
				if err != nil {
					return err
				}
				bs.TreatEmptyAsNull = treatEmptyAsNull
			}
		case "skipHeaderLineCount":
			if v != nil {
				var skipHeaderLineCount interface{}
				err = json.Unmarshal(*v, &skipHeaderLineCount)
				if err != nil {
					return err
				}
				bs.SkipHeaderLineCount = skipHeaderLineCount
			}
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				bs.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if bs.AdditionalProperties == nil {
					bs.AdditionalProperties = make(map[string]interface{})
				}
				bs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				bs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				bs.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = typeVar
			}
		}
	}

	return nil
}

// BlobTrigger trigger that runs every time the selected Blob container changes.
type BlobTrigger struct {
	// BlobTriggerTypeProperties - Blob Trigger properties.
	*BlobTriggerTypeProperties `json:"typeProperties,omitempty"`
	// Pipelines - Pipelines that need to be started.
	Pipelines *[]TriggerPipelineReference `json:"pipelines,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Trigger description.
	Description *string `json:"description,omitempty"`
	// RuntimeState - READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. Possible values include: 'TriggerRuntimeStateStarted', 'TriggerRuntimeStateStopped', 'TriggerRuntimeStateDisabled'
	RuntimeState TriggerRuntimeState `json:"runtimeState,omitempty"`
	// Type - Possible values include: 'TypeTrigger', 'TypeTumblingWindowTrigger', 'TypeBlobEventsTrigger', 'TypeBlobTrigger', 'TypeScheduleTrigger', 'TypeMultiplePipelineTrigger'
	Type TypeBasicTrigger `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobTrigger.
func (bt BlobTrigger) MarshalJSON() ([]byte, error) {
	bt.Type = TypeBlobTrigger
	objectMap := make(map[string]interface{})
	if bt.BlobTriggerTypeProperties != nil {
		objectMap["typeProperties"] = bt.BlobTriggerTypeProperties
	}
	if bt.Pipelines != nil {
		objectMap["pipelines"] = bt.Pipelines
	}
	if bt.Description != nil {
		objectMap["description"] = bt.Description
	}
	if bt.Type != "" {
		objectMap["type"] = bt.Type
	}
	for k, v := range bt.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsTumblingWindowTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsTumblingWindowTrigger() (*TumblingWindowTrigger, bool) {
	return nil, false
}

// AsBlobEventsTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBlobEventsTrigger() (*BlobEventsTrigger, bool) {
	return nil, false
}

// AsBlobTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBlobTrigger() (*BlobTrigger, bool) {
	return &bt, true
}

// AsScheduleTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsScheduleTrigger() (*ScheduleTrigger, bool) {
	return nil, false
}

// AsMultiplePipelineTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsMultiplePipelineTrigger() (*MultiplePipelineTrigger, bool) {
	return nil, false
}

// AsBasicMultiplePipelineTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBasicMultiplePipelineTrigger() (BasicMultiplePipelineTrigger, bool) {
	return &bt, true
}

// AsTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &bt, true
}

// UnmarshalJSON is the custom unmarshaler for BlobTrigger struct.
func (bt *BlobTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var blobTriggerTypeProperties BlobTriggerTypeProperties
				err = json.Unmarshal(*v, &blobTriggerTypeProperties)
				if err != nil {
					return err
				}
				bt.BlobTriggerTypeProperties = &blobTriggerTypeProperties
			}
		case "pipelines":
			if v != nil {
				var pipelines []TriggerPipelineReference
				err = json.Unmarshal(*v, &pipelines)
				if err != nil {
					return err
				}
				bt.Pipelines = &pipelines
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if bt.AdditionalProperties == nil {
					bt.AdditionalProperties = make(map[string]interface{})
				}
				bt.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				bt.Description = &description
			}
		case "runtimeState":
			if v != nil {
				var runtimeState TriggerRuntimeState
				err = json.Unmarshal(*v, &runtimeState)
				if err != nil {
					return err
				}
				bt.RuntimeState = runtimeState
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicTrigger
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bt.Type = typeVar
			}
		}
	}

	return nil
}

// BlobTriggerTypeProperties blob Trigger properties.
type BlobTriggerTypeProperties struct {
	// FolderPath - The path of the container/folder that will trigger the pipeline.
	FolderPath *string `json:"folderPath,omitempty"`
	// MaxConcurrency - The max number of parallel files to handle when it is triggered.
	MaxConcurrency *int32 `json:"maxConcurrency,omitempty"`
	// LinkedService - The Azure Storage linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`
}

// CassandraLinkedService linked service for Cassandra data source.
type CassandraLinkedService struct {
	// CassandraLinkedServiceTypeProperties - Cassandra linked service properties.
	*CassandraLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraLinkedService.
func (cls CassandraLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeCassandra
	objectMap := make(map[string]interface{})
	if cls.CassandraLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = cls.CassandraLinkedServiceTypeProperties
	}
	if cls.ConnectVia != nil {
		objectMap["connectVia"] = cls.ConnectVia
	}
	if cls.Description != nil {
		objectMap["description"] = cls.Description
	}
	if cls.Parameters != nil {
		objectMap["parameters"] = cls.Parameters
	}
	if cls.Annotations != nil {
		objectMap["annotations"] = cls.Annotations
	}
	if cls.Type != "" {
		objectMap["type"] = cls.Type
	}
	for k, v := range cls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return &cls, true
}

// AsWebLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for CassandraLinkedService struct.
func (cls *CassandraLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var cassandraLinkedServiceTypeProperties CassandraLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &cassandraLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				cls.CassandraLinkedServiceTypeProperties = &cassandraLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cls.AdditionalProperties == nil {
					cls.AdditionalProperties = make(map[string]interface{})
				}
				cls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				cls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cls.Type = typeVar
			}
		}
	}

	return nil
}

// CassandraLinkedServiceTypeProperties cassandra linked service properties.
type CassandraLinkedServiceTypeProperties struct {
	// Host - Host name for connection. Type: string (or Expression with resultType string).
	Host interface{} `json:"host,omitempty"`
	// AuthenticationType - AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`
	// Port - The port for the connection. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`
	// Username - Username for authentication. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
	// Password - Password for authentication.
	Password BasicSecretBase `json:"password,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CassandraLinkedServiceTypeProperties struct.
func (clstp *CassandraLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "host":
			if v != nil {
				var host interface{}
				err = json.Unmarshal(*v, &host)
				if err != nil {
					return err
				}
				clstp.Host = host
			}
		case "authenticationType":
			if v != nil {
				var authenticationType interface{}
				err = json.Unmarshal(*v, &authenticationType)
				if err != nil {
					return err
				}
				clstp.AuthenticationType = authenticationType
			}
		case "port":
			if v != nil {
				var port interface{}
				err = json.Unmarshal(*v, &port)
				if err != nil {
					return err
				}
				clstp.Port = port
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				clstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				clstp.Password = password
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				clstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// CassandraSource a copy activity source for a Cassandra database.
type CassandraSource struct {
	// Query - Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// ConsistencyLevel - The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
	ConsistencyLevel interface{} `json:"consistencyLevel,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraSource.
func (cs CassandraSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCassandraSource
	objectMap := make(map[string]interface{})
	if cs.Query != nil {
		objectMap["query"] = cs.Query
	}
	if cs.ConsistencyLevel != nil {
		objectMap["consistencyLevel"] = cs.ConsistencyLevel
	}
	if cs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = cs.SourceRetryCount
	}
	if cs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = cs.SourceRetryWait
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	for k, v := range cs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCassandraSource() (*CassandraSource, bool) {
	return &cs, true
}

// AsWebSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CassandraSource struct.
func (cs *CassandraSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				cs.Query = query
			}
		case "consistencyLevel":
			if v != nil {
				var consistencyLevel interface{}
				err = json.Unmarshal(*v, &consistencyLevel)
				if err != nil {
					return err
				}
				cs.ConsistencyLevel = consistencyLevel
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cs.AdditionalProperties == nil {
					cs.AdditionalProperties = make(map[string]interface{})
				}
				cs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				cs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				cs.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CassandraTableDataset the Cassandra database dataset.
type CassandraTableDataset struct {
	// CassandraTableDatasetTypeProperties - Cassandra dataset properties.
	*CassandraTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableDataset.
func (ctd CassandraTableDataset) MarshalJSON() ([]byte, error) {
	ctd.Type = TypeCassandraTable
	objectMap := make(map[string]interface{})
	if ctd.CassandraTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = ctd.CassandraTableDatasetTypeProperties
	}
	if ctd.Description != nil {
		objectMap["description"] = ctd.Description
	}
	if ctd.Structure != nil {
		objectMap["structure"] = ctd.Structure
	}
	if ctd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ctd.LinkedServiceName
	}
	if ctd.Parameters != nil {
		objectMap["parameters"] = ctd.Parameters
	}
	if ctd.Annotations != nil {
		objectMap["annotations"] = ctd.Annotations
	}
	if ctd.Type != "" {
		objectMap["type"] = ctd.Type
	}
	for k, v := range ctd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return &ctd, true
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ctd, true
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableDataset struct.
func (ctd *CassandraTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var cassandraTableDatasetTypeProperties CassandraTableDatasetTypeProperties
				err = json.Unmarshal(*v, &cassandraTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				ctd.CassandraTableDatasetTypeProperties = &cassandraTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ctd.AdditionalProperties == nil {
					ctd.AdditionalProperties = make(map[string]interface{})
				}
				ctd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ctd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				ctd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ctd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ctd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				ctd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctd.Type = typeVar
			}
		}
	}

	return nil
}

// CassandraTableDatasetTypeProperties cassandra dataset properties.
type CassandraTableDatasetTypeProperties struct {
	// TableName - The table name of the Cassandra database. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
	// Keyspace - The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
	Keyspace interface{} `json:"keyspace,omitempty"`
}

// ConcurLinkedService concur Service linked service.
type ConcurLinkedService struct {
	// ConcurLinkedServiceTypeProperties - Concur Service linked service properties.
	*ConcurLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurLinkedService.
func (cls ConcurLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeConcur
	objectMap := make(map[string]interface{})
	if cls.ConcurLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = cls.ConcurLinkedServiceTypeProperties
	}
	if cls.ConnectVia != nil {
		objectMap["connectVia"] = cls.ConnectVia
	}
	if cls.Description != nil {
		objectMap["description"] = cls.Description
	}
	if cls.Parameters != nil {
		objectMap["parameters"] = cls.Parameters
	}
	if cls.Annotations != nil {
		objectMap["annotations"] = cls.Annotations
	}
	if cls.Type != "" {
		objectMap["type"] = cls.Type
	}
	for k, v := range cls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return &cls, true
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for ConcurLinkedService struct.
func (cls *ConcurLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var concurLinkedServiceTypeProperties ConcurLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &concurLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				cls.ConcurLinkedServiceTypeProperties = &concurLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cls.AdditionalProperties == nil {
					cls.AdditionalProperties = make(map[string]interface{})
				}
				cls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				cls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cls.Type = typeVar
			}
		}
	}

	return nil
}

// ConcurLinkedServiceTypeProperties concur Service linked service properties.
type ConcurLinkedServiceTypeProperties struct {
	// ClientID - Application client_id supplied by Concur App Management.
	ClientID interface{} `json:"clientId,omitempty"`
	// Username - The user name that you use to access Concur Service.
	Username interface{} `json:"username,omitempty"`
	// Password - The password corresponding to the user name that you provided in the username field.
	Password BasicSecretBase `json:"password,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConcurLinkedServiceTypeProperties struct.
func (clstp *ConcurLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "clientId":
			if v != nil {
				var clientID interface{}
				err = json.Unmarshal(*v, &clientID)
				if err != nil {
					return err
				}
				clstp.ClientID = clientID
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				clstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				clstp.Password = password
			}
		case "useEncryptedEndpoints":
			if v != nil {
				var useEncryptedEndpoints interface{}
				err = json.Unmarshal(*v, &useEncryptedEndpoints)
				if err != nil {
					return err
				}
				clstp.UseEncryptedEndpoints = useEncryptedEndpoints
			}
		case "useHostVerification":
			if v != nil {
				var useHostVerification interface{}
				err = json.Unmarshal(*v, &useHostVerification)
				if err != nil {
					return err
				}
				clstp.UseHostVerification = useHostVerification
			}
		case "usePeerVerification":
			if v != nil {
				var usePeerVerification interface{}
				err = json.Unmarshal(*v, &usePeerVerification)
				if err != nil {
					return err
				}
				clstp.UsePeerVerification = usePeerVerification
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				clstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// ConcurObjectDataset concur Service dataset.
type ConcurObjectDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurObjectDataset.
func (cod ConcurObjectDataset) MarshalJSON() ([]byte, error) {
	cod.Type = TypeConcurObject
	objectMap := make(map[string]interface{})
	if cod.Description != nil {
		objectMap["description"] = cod.Description
	}
	if cod.Structure != nil {
		objectMap["structure"] = cod.Structure
	}
	if cod.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = cod.LinkedServiceName
	}
	if cod.Parameters != nil {
		objectMap["parameters"] = cod.Parameters
	}
	if cod.Annotations != nil {
		objectMap["annotations"] = cod.Annotations
	}
	if cod.Type != "" {
		objectMap["type"] = cod.Type
	}
	for k, v := range cod.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return &cod, true
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &cod, true
}

// UnmarshalJSON is the custom unmarshaler for ConcurObjectDataset struct.
func (cod *ConcurObjectDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cod.AdditionalProperties == nil {
					cod.AdditionalProperties = make(map[string]interface{})
				}
				cod.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cod.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				cod.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				cod.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cod.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cod.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cod.Type = typeVar
			}
		}
	}

	return nil
}

// ConcurSource a copy activity Concur Service source.
type ConcurSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurSource.
func (cs ConcurSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeConcurSource
	objectMap := make(map[string]interface{})
	if cs.Query != nil {
		objectMap["query"] = cs.Query
	}
	if cs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = cs.SourceRetryCount
	}
	if cs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = cs.SourceRetryWait
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	for k, v := range cs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsConcurSource() (*ConcurSource, bool) {
	return &cs, true
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for ConcurSource struct.
func (cs *ConcurSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				cs.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cs.AdditionalProperties == nil {
					cs.AdditionalProperties = make(map[string]interface{})
				}
				cs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				cs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				cs.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// BasicControlActivity base class for all control activities like IfCondition, ForEach , Until.
type BasicControlActivity interface {
	AsFilterActivity() (*FilterActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
}

// ControlActivity base class for all control activities like IfCondition, ForEach , Until.
type ControlActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicControlActivity(body []byte) (BasicControlActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeFilter):
		var fa FilterActivity
		err := json.Unmarshal(body, &fa)
		return fa, err
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	default:
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	}
}
func unmarshalBasicControlActivityArray(body []byte) ([]BasicControlActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	caArray := make([]BasicControlActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ca, err := unmarshalBasicControlActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		caArray[index] = ca
	}
	return caArray, nil
}

// MarshalJSON is the custom marshaler for ControlActivity.
func (ca ControlActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeContainer
	objectMap := make(map[string]interface{})
	if ca.Name != nil {
		objectMap["name"] = ca.Name
	}
	if ca.Description != nil {
		objectMap["description"] = ca.Description
	}
	if ca.DependsOn != nil {
		objectMap["dependsOn"] = ca.DependsOn
	}
	if ca.Type != "" {
		objectMap["type"] = ca.Type
	}
	for k, v := range ca.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsControlActivity() (*ControlActivity, bool) {
	return &ca, true
}

// AsBasicControlActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return &ca, true
}

// AsActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for ControlActivity struct.
func (ca *ControlActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ca.AdditionalProperties == nil {
					ca.AdditionalProperties = make(map[string]interface{})
				}
				ca.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ca.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ca.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = typeVar
			}
		}
	}

	return nil
}

// CopyActivity copy activity.
type CopyActivity struct {
	// CopyActivityTypeProperties - Copy activity properties.
	*CopyActivityTypeProperties `json:"typeProperties,omitempty"`
	// Inputs - List of inputs for the activity.
	Inputs *[]DatasetReference `json:"inputs,omitempty"`
	// Outputs - List of outputs for the activity.
	Outputs *[]DatasetReference `json:"outputs,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyActivity.
func (ca CopyActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeCopy
	objectMap := make(map[string]interface{})
	if ca.CopyActivityTypeProperties != nil {
		objectMap["typeProperties"] = ca.CopyActivityTypeProperties
	}
	if ca.Inputs != nil {
		objectMap["inputs"] = ca.Inputs
	}
	if ca.Outputs != nil {
		objectMap["outputs"] = ca.Outputs
	}
	if ca.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ca.LinkedServiceName
	}
	if ca.Policy != nil {
		objectMap["policy"] = ca.Policy
	}
	if ca.Name != nil {
		objectMap["name"] = ca.Name
	}
	if ca.Description != nil {
		objectMap["description"] = ca.Description
	}
	if ca.DependsOn != nil {
		objectMap["dependsOn"] = ca.DependsOn
	}
	if ca.Type != "" {
		objectMap["type"] = ca.Type
	}
	for k, v := range ca.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsCopyActivity() (*CopyActivity, bool) {
	return &ca, true
}

// AsExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ca, true
}

// AsFilterActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CopyActivity struct.
func (ca *CopyActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var copyActivityTypeProperties CopyActivityTypeProperties
				err = json.Unmarshal(*v, &copyActivityTypeProperties)
				if err != nil {
					return err
				}
				ca.CopyActivityTypeProperties = &copyActivityTypeProperties
			}
		case "inputs":
			if v != nil {
				var inputs []DatasetReference
				err = json.Unmarshal(*v, &inputs)
				if err != nil {
					return err
				}
				ca.Inputs = &inputs
			}
		case "outputs":
			if v != nil {
				var outputs []DatasetReference
				err = json.Unmarshal(*v, &outputs)
				if err != nil {
					return err
				}
				ca.Outputs = &outputs
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ca.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				ca.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ca.AdditionalProperties == nil {
					ca.AdditionalProperties = make(map[string]interface{})
				}
				ca.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ca.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ca.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = typeVar
			}
		}
	}

	return nil
}

// CopyActivityTypeProperties copy activity properties.
type CopyActivityTypeProperties struct {
	// Source - Copy activity source.
	Source BasicCopySource `json:"source,omitempty"`
	// Sink - Copy activity sink.
	Sink BasicCopySink `json:"sink,omitempty"`
	// Translator - Copy activity translator. If not specified, tabular translator is used.
	Translator interface{} `json:"translator,omitempty"`
	// EnableStaging - Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableStaging interface{} `json:"enableStaging,omitempty"`
	// StagingSettings - Specifies interim staging settings when EnableStaging is true.
	StagingSettings *StagingSettings `json:"stagingSettings,omitempty"`
	// ParallelCopies - Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
	ParallelCopies interface{} `json:"parallelCopies,omitempty"`
	// CloudDataMovementUnits - Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
	CloudDataMovementUnits interface{} `json:"cloudDataMovementUnits,omitempty"`
	// EnableSkipIncompatibleRow - Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableSkipIncompatibleRow interface{} `json:"enableSkipIncompatibleRow,omitempty"`
	// RedirectIncompatibleRowSettings - Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
	RedirectIncompatibleRowSettings *RedirectIncompatibleRowSettings `json:"redirectIncompatibleRowSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CopyActivityTypeProperties struct.
func (catp *CopyActivityTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "source":
			if v != nil {
				source, err := unmarshalBasicCopySource(*v)
				if err != nil {
					return err
				}
				catp.Source = source
			}
		case "sink":
			if v != nil {
				sink, err := unmarshalBasicCopySink(*v)
				if err != nil {
					return err
				}
				catp.Sink = sink
			}
		case "translator":
			if v != nil {
				var translator interface{}
				err = json.Unmarshal(*v, &translator)
				if err != nil {
					return err
				}
				catp.Translator = translator
			}
		case "enableStaging":
			if v != nil {
				var enableStaging interface{}
				err = json.Unmarshal(*v, &enableStaging)
				if err != nil {
					return err
				}
				catp.EnableStaging = enableStaging
			}
		case "stagingSettings":
			if v != nil {
				var stagingSettings StagingSettings
				err = json.Unmarshal(*v, &stagingSettings)
				if err != nil {
					return err
				}
				catp.StagingSettings = &stagingSettings
			}
		case "parallelCopies":
			if v != nil {
				var parallelCopies interface{}
				err = json.Unmarshal(*v, &parallelCopies)
				if err != nil {
					return err
				}
				catp.ParallelCopies = parallelCopies
			}
		case "cloudDataMovementUnits":
			if v != nil {
				var cloudDataMovementUnits interface{}
				err = json.Unmarshal(*v, &cloudDataMovementUnits)
				if err != nil {
					return err
				}
				catp.CloudDataMovementUnits = cloudDataMovementUnits
			}
		case "enableSkipIncompatibleRow":
			if v != nil {
				var enableSkipIncompatibleRow interface{}
				err = json.Unmarshal(*v, &enableSkipIncompatibleRow)
				if err != nil {
					return err
				}
				catp.EnableSkipIncompatibleRow = enableSkipIncompatibleRow
			}
		case "redirectIncompatibleRowSettings":
			if v != nil {
				var redirectIncompatibleRowSettings RedirectIncompatibleRowSettings
				err = json.Unmarshal(*v, &redirectIncompatibleRowSettings)
				if err != nil {
					return err
				}
				catp.RedirectIncompatibleRowSettings = &redirectIncompatibleRowSettings
			}
		}
	}

	return nil
}

// BasicCopySink a copy activity sink.
type BasicCopySink interface {
	AsSalesforceSink() (*SalesforceSink, bool)
	AsDynamicsSink() (*DynamicsSink, bool)
	AsOdbcSink() (*OdbcSink, bool)
	AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool)
	AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool)
	AsOracleSink() (*OracleSink, bool)
	AsSQLDWSink() (*SQLDWSink, bool)
	AsSQLSink() (*SQLSink, bool)
	AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool)
	AsFileSystemSink() (*FileSystemSink, bool)
	AsBlobSink() (*BlobSink, bool)
	AsAzureTableSink() (*AzureTableSink, bool)
	AsAzureQueueSink() (*AzureQueueSink, bool)
	AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool)
	AsCopySink() (*CopySink, bool)
}

// CopySink a copy activity sink.
type CopySink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

func unmarshalBasicCopySink(body []byte) (BasicCopySink, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeSalesforceSink):
		var ss SalesforceSink
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeDynamicsSink):
		var ds DynamicsSink
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeOdbcSink):
		var osVar OdbcSink
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeAzureSearchIndexSink):
		var asis AzureSearchIndexSink
		err := json.Unmarshal(body, &asis)
		return asis, err
	case string(TypeAzureDataLakeStoreSink):
		var adlss AzureDataLakeStoreSink
		err := json.Unmarshal(body, &adlss)
		return adlss, err
	case string(TypeOracleSink):
		var osVar OracleSink
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeSQLDWSink):
		var sds SQLDWSink
		err := json.Unmarshal(body, &sds)
		return sds, err
	case string(TypeSQLSink):
		var ss SQLSink
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeDocumentDbCollectionSink):
		var ddcs DocumentDbCollectionSink
		err := json.Unmarshal(body, &ddcs)
		return ddcs, err
	case string(TypeFileSystemSink):
		var fss FileSystemSink
		err := json.Unmarshal(body, &fss)
		return fss, err
	case string(TypeBlobSink):
		var bs BlobSink
		err := json.Unmarshal(body, &bs)
		return bs, err
	case string(TypeAzureTableSink):
		var ats AzureTableSink
		err := json.Unmarshal(body, &ats)
		return ats, err
	case string(TypeAzureQueueSink):
		var aqs AzureQueueSink
		err := json.Unmarshal(body, &aqs)
		return aqs, err
	case string(TypeSapCloudForCustomerSink):
		var scfcs SapCloudForCustomerSink
		err := json.Unmarshal(body, &scfcs)
		return scfcs, err
	default:
		var cs CopySink
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCopySinkArray(body []byte) ([]BasicCopySink, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCopySink, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCopySink(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CopySink.
func (cs CopySink) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCopySink
	objectMap := make(map[string]interface{})
	if cs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = cs.WriteBatchSize
	}
	if cs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = cs.WriteBatchTimeout
	}
	if cs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = cs.SinkRetryCount
	}
	if cs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = cs.SinkRetryWait
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	for k, v := range cs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSalesforceSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsCopySink() (*CopySink, bool) {
	return &cs, true
}

// AsBasicCopySink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsBasicCopySink() (BasicCopySink, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CopySink struct.
func (cs *CopySink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cs.AdditionalProperties == nil {
					cs.AdditionalProperties = make(map[string]interface{})
				}
				cs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				cs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				cs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				cs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				cs.SinkRetryWait = sinkRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// BasicCopySource a copy activity source.
type BasicCopySource interface {
	AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool)
	AsResponsysSource() (*ResponsysSource, bool)
	AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool)
	AsVerticaSource() (*VerticaSource, bool)
	AsNetezzaSource() (*NetezzaSource, bool)
	AsZohoSource() (*ZohoSource, bool)
	AsXeroSource() (*XeroSource, bool)
	AsSquareSource() (*SquareSource, bool)
	AsSparkSource() (*SparkSource, bool)
	AsShopifySource() (*ShopifySource, bool)
	AsServiceNowSource() (*ServiceNowSource, bool)
	AsQuickBooksSource() (*QuickBooksSource, bool)
	AsPrestoSource() (*PrestoSource, bool)
	AsPhoenixSource() (*PhoenixSource, bool)
	AsPaypalSource() (*PaypalSource, bool)
	AsMarketoSource() (*MarketoSource, bool)
	AsMariaDBSource() (*MariaDBSource, bool)
	AsMagentoSource() (*MagentoSource, bool)
	AsJiraSource() (*JiraSource, bool)
	AsImpalaSource() (*ImpalaSource, bool)
	AsHubspotSource() (*HubspotSource, bool)
	AsHiveSource() (*HiveSource, bool)
	AsHBaseSource() (*HBaseSource, bool)
	AsGreenplumSource() (*GreenplumSource, bool)
	AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool)
	AsEloquaSource() (*EloquaSource, bool)
	AsDrillSource() (*DrillSource, bool)
	AsCouchbaseSource() (*CouchbaseSource, bool)
	AsConcurSource() (*ConcurSource, bool)
	AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool)
	AsAmazonMWSSource() (*AmazonMWSSource, bool)
	AsHTTPSource() (*HTTPSource, bool)
	AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool)
	AsMongoDbSource() (*MongoDbSource, bool)
	AsCassandraSource() (*CassandraSource, bool)
	AsWebSource() (*WebSource, bool)
	AsOracleSource() (*OracleSource, bool)
	AsAzureMySQLSource() (*AzureMySQLSource, bool)
	AsHdfsSource() (*HdfsSource, bool)
	AsFileSystemSource() (*FileSystemSource, bool)
	AsSQLDWSource() (*SQLDWSource, bool)
	AsSQLSource() (*SQLSource, bool)
	AsSapEccSource() (*SapEccSource, bool)
	AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool)
	AsSalesforceSource() (*SalesforceSource, bool)
	AsRelationalSource() (*RelationalSource, bool)
	AsDynamicsSource() (*DynamicsSource, bool)
	AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool)
	AsBlobSource() (*BlobSource, bool)
	AsAzureTableSource() (*AzureTableSource, bool)
	AsCopySource() (*CopySource, bool)
}

// CopySource a copy activity source.
type CopySource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

func unmarshalBasicCopySource(body []byte) (BasicCopySource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAmazonRedshiftSource):
		var ars AmazonRedshiftSource
		err := json.Unmarshal(body, &ars)
		return ars, err
	case string(TypeResponsysSource):
		var rs ResponsysSource
		err := json.Unmarshal(body, &rs)
		return rs, err
	case string(TypeSalesforceMarketingCloudSource):
		var smcs SalesforceMarketingCloudSource
		err := json.Unmarshal(body, &smcs)
		return smcs, err
	case string(TypeVerticaSource):
		var vs VerticaSource
		err := json.Unmarshal(body, &vs)
		return vs, err
	case string(TypeNetezzaSource):
		var ns NetezzaSource
		err := json.Unmarshal(body, &ns)
		return ns, err
	case string(TypeZohoSource):
		var zs ZohoSource
		err := json.Unmarshal(body, &zs)
		return zs, err
	case string(TypeXeroSource):
		var xs XeroSource
		err := json.Unmarshal(body, &xs)
		return xs, err
	case string(TypeSquareSource):
		var ss SquareSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeSparkSource):
		var ss SparkSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeShopifySource):
		var ss ShopifySource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeServiceNowSource):
		var sns ServiceNowSource
		err := json.Unmarshal(body, &sns)
		return sns, err
	case string(TypeQuickBooksSource):
		var qbs QuickBooksSource
		err := json.Unmarshal(body, &qbs)
		return qbs, err
	case string(TypePrestoSource):
		var ps PrestoSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypePhoenixSource):
		var ps PhoenixSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypePaypalSource):
		var ps PaypalSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypeMarketoSource):
		var ms MarketoSource
		err := json.Unmarshal(body, &ms)
		return ms, err
	case string(TypeMariaDBSource):
		var mds MariaDBSource
		err := json.Unmarshal(body, &mds)
		return mds, err
	case string(TypeMagentoSource):
		var ms MagentoSource
		err := json.Unmarshal(body, &ms)
		return ms, err
	case string(TypeJiraSource):
		var js JiraSource
		err := json.Unmarshal(body, &js)
		return js, err
	case string(TypeImpalaSource):
		var is ImpalaSource
		err := json.Unmarshal(body, &is)
		return is, err
	case string(TypeHubspotSource):
		var hs HubspotSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeHiveSource):
		var hs HiveSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeHBaseSource):
		var hbs HBaseSource
		err := json.Unmarshal(body, &hbs)
		return hbs, err
	case string(TypeGreenplumSource):
		var gs GreenplumSource
		err := json.Unmarshal(body, &gs)
		return gs, err
	case string(TypeGoogleBigQuerySource):
		var gbqs GoogleBigQuerySource
		err := json.Unmarshal(body, &gbqs)
		return gbqs, err
	case string(TypeEloquaSource):
		var es EloquaSource
		err := json.Unmarshal(body, &es)
		return es, err
	case string(TypeDrillSource):
		var ds DrillSource
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeCouchbaseSource):
		var cs CouchbaseSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeConcurSource):
		var cs ConcurSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeAzurePostgreSQLSource):
		var apss AzurePostgreSQLSource
		err := json.Unmarshal(body, &apss)
		return apss, err
	case string(TypeAmazonMWSSource):
		var ams AmazonMWSSource
		err := json.Unmarshal(body, &ams)
		return ams, err
	case string(TypeHTTPSource):
		var hs HTTPSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeAzureDataLakeStoreSource):
		var adlss AzureDataLakeStoreSource
		err := json.Unmarshal(body, &adlss)
		return adlss, err
	case string(TypeMongoDbSource):
		var mds MongoDbSource
		err := json.Unmarshal(body, &mds)
		return mds, err
	case string(TypeCassandraSource):
		var cs CassandraSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeWebSource):
		var ws WebSource
		err := json.Unmarshal(body, &ws)
		return ws, err
	case string(TypeOracleSource):
		var osVar OracleSource
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeAzureMySQLSource):
		var amss AzureMySQLSource
		err := json.Unmarshal(body, &amss)
		return amss, err
	case string(TypeHdfsSource):
		var hs HdfsSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeFileSystemSource):
		var fss FileSystemSource
		err := json.Unmarshal(body, &fss)
		return fss, err
	case string(TypeSQLDWSource):
		var sds SQLDWSource
		err := json.Unmarshal(body, &sds)
		return sds, err
	case string(TypeSQLSource):
		var ss SQLSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeSapEccSource):
		var ses SapEccSource
		err := json.Unmarshal(body, &ses)
		return ses, err
	case string(TypeSapCloudForCustomerSource):
		var scfcs SapCloudForCustomerSource
		err := json.Unmarshal(body, &scfcs)
		return scfcs, err
	case string(TypeSalesforceSource):
		var ss SalesforceSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeRelationalSource):
		var rs RelationalSource
		err := json.Unmarshal(body, &rs)
		return rs, err
	case string(TypeDynamicsSource):
		var ds DynamicsSource
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeDocumentDbCollectionSource):
		var ddcs DocumentDbCollectionSource
		err := json.Unmarshal(body, &ddcs)
		return ddcs, err
	case string(TypeBlobSource):
		var bs BlobSource
		err := json.Unmarshal(body, &bs)
		return bs, err
	case string(TypeAzureTableSource):
		var ats AzureTableSource
		err := json.Unmarshal(body, &ats)
		return ats, err
	default:
		var cs CopySource
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCopySourceArray(body []byte) ([]BasicCopySource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCopySource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCopySource(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CopySource.
func (cs CopySource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCopySource
	objectMap := make(map[string]interface{})
	if cs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = cs.SourceRetryCount
	}
	if cs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = cs.SourceRetryWait
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	for k, v := range cs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCopySource() (*CopySource, bool) {
	return &cs, true
}

// AsBasicCopySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CopySource struct.
func (cs *CopySource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cs.AdditionalProperties == nil {
					cs.AdditionalProperties = make(map[string]interface{})
				}
				cs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				cs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				cs.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CosmosDbLinkedService microsoft Azure Cosmos Database (CosmosDB) linked service.
type CosmosDbLinkedService struct {
	// CosmosDbLinkedServiceTypeProperties - CosmosDB linked service properties.
	*CosmosDbLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) MarshalJSON() ([]byte, error) {
	cdls.Type = TypeCosmosDb
	objectMap := make(map[string]interface{})
	if cdls.CosmosDbLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = cdls.CosmosDbLinkedServiceTypeProperties
	}
	if cdls.ConnectVia != nil {
		objectMap["connectVia"] = cdls.ConnectVia
	}
	if cdls.Description != nil {
		objectMap["description"] = cdls.Description
	}
	if cdls.Parameters != nil {
		objectMap["parameters"] = cdls.Parameters
	}
	if cdls.Annotations != nil {
		objectMap["annotations"] = cdls.Annotations
	}
	if cdls.Type != "" {
		objectMap["type"] = cdls.Type
	}
	for k, v := range cdls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return &cdls, true
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cdls, true
}

// UnmarshalJSON is the custom unmarshaler for CosmosDbLinkedService struct.
func (cdls *CosmosDbLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var cosmosDbLinkedServiceTypeProperties CosmosDbLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &cosmosDbLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				cdls.CosmosDbLinkedServiceTypeProperties = &cosmosDbLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cdls.AdditionalProperties == nil {
					cdls.AdditionalProperties = make(map[string]interface{})
				}
				cdls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				cdls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cdls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cdls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cdls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cdls.Type = typeVar
			}
		}
	}

	return nil
}

// CosmosDbLinkedServiceTypeProperties cosmosDB linked service properties.
type CosmosDbLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// CouchbaseLinkedService couchbase server linked service.
type CouchbaseLinkedService struct {
	// CouchbaseLinkedServiceTypeProperties - Couchbase server linked service properties.
	*CouchbaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeCouchbase
	objectMap := make(map[string]interface{})
	if cls.CouchbaseLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = cls.CouchbaseLinkedServiceTypeProperties
	}
	if cls.ConnectVia != nil {
		objectMap["connectVia"] = cls.ConnectVia
	}
	if cls.Description != nil {
		objectMap["description"] = cls.Description
	}
	if cls.Parameters != nil {
		objectMap["parameters"] = cls.Parameters
	}
	if cls.Annotations != nil {
		objectMap["annotations"] = cls.Annotations
	}
	if cls.Type != "" {
		objectMap["type"] = cls.Type
	}
	for k, v := range cls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return &cls, true
}

// AsConcurLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for CouchbaseLinkedService struct.
func (cls *CouchbaseLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var couchbaseLinkedServiceTypeProperties CouchbaseLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &couchbaseLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				cls.CouchbaseLinkedServiceTypeProperties = &couchbaseLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cls.AdditionalProperties == nil {
					cls.AdditionalProperties = make(map[string]interface{})
				}
				cls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				cls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cls.Type = typeVar
			}
		}
	}

	return nil
}

// CouchbaseLinkedServiceTypeProperties couchbase server linked service properties.
type CouchbaseLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// CouchbaseSource a copy activity Couchbase server source.
type CouchbaseSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseSource.
func (cs CouchbaseSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCouchbaseSource
	objectMap := make(map[string]interface{})
	if cs.Query != nil {
		objectMap["query"] = cs.Query
	}
	if cs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = cs.SourceRetryCount
	}
	if cs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = cs.SourceRetryWait
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	for k, v := range cs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return &cs, true
}

// AsConcurSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CouchbaseSource struct.
func (cs *CouchbaseSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				cs.Query = query
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cs.AdditionalProperties == nil {
					cs.AdditionalProperties = make(map[string]interface{})
				}
				cs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				cs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				cs.SourceRetryWait = sourceRetryWait
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CouchbaseTableDataset couchbase server dataset.
type CouchbaseTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) MarshalJSON() ([]byte, error) {
	ctd.Type = TypeCouchbaseTable
	objectMap := make(map[string]interface{})
	if ctd.Description != nil {
		objectMap["description"] = ctd.Description
	}
	if ctd.Structure != nil {
		objectMap["structure"] = ctd.Structure
	}
	if ctd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ctd.LinkedServiceName
	}
	if ctd.Parameters != nil {
		objectMap["parameters"] = ctd.Parameters
	}
	if ctd.Annotations != nil {
		objectMap["annotations"] = ctd.Annotations
	}
	if ctd.Type != "" {
		objectMap["type"] = ctd.Type
	}
	for k, v := range ctd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return &ctd, true
}

// AsConcurObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ctd, true
}

// UnmarshalJSON is the custom unmarshaler for CouchbaseTableDataset struct.
func (ctd *CouchbaseTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ctd.AdditionalProperties == nil {
					ctd.AdditionalProperties = make(map[string]interface{})
				}
				ctd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ctd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				ctd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ctd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ctd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				ctd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctd.Type = typeVar
			}
		}
	}

	return nil
}

// CreateRunResponse response body with a run identifier.
type CreateRunResponse struct {
	autorest.Response `json:"-"`
	// RunID - Identifier of a run.
	RunID *string `json:"runId,omitempty"`
}

// CustomActivity custom activity type.
type CustomActivity struct {
	// CustomActivityTypeProperties - Custom activity properties.
	*CustomActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeFilter', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomActivity.
func (ca CustomActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeCustom
	objectMap := make(map[string]interface{})
	if ca.CustomActivityTypeProperties != nil {
		objectMap["typeProperties"] = ca.CustomActivityTypeProperties
	}
	if ca.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ca.LinkedServiceName
	}
	if ca.Policy != nil {
		objectMap["policy"] = ca.Policy
	}
	if ca.Name != nil {
		objectMap["name"] = ca.Name
	}
	if ca.Description != nil {
		objectMap["description"] = ca.Description
	}
	if ca.DependsOn != nil {
		objectMap["dependsOn"] = ca.DependsOn
	}
	if ca.Type != "" {
		objectMap["type"] = ca.Type
	}
	for k, v := range ca.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsCustomActivity() (*CustomActivity, bool) {
	return &ca, true
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ca, true
}

// AsFilterActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CustomActivity struct.
func (ca *CustomActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var customActivityTypeProperties CustomActivityTypeProperties
				err = json.Unmarshal(*v, &customActivityTypeProperties)
				if err != nil {
					return err
				}
				ca.CustomActivityTypeProperties = &customActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ca.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				ca.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ca.AdditionalProperties == nil {
					ca.AdditionalProperties = make(map[string]interface{})
				}
				ca.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ca.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ca.DependsOn = &dependsOn
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = typeVar
			}
		}
	}

	return nil
}

// CustomActivityReferenceObject reference objects for custom activity
type CustomActivityReferenceObject struct {
	// LinkedServices - Linked service references.
	LinkedServices *[]LinkedServiceReference `json:"linkedServices,omitempty"`
	// Datasets - Dataset references.
	Datasets *[]DatasetReference `json:"datasets,omitempty"`
}

// CustomActivityTypeProperties custom activity properties.
type CustomActivityTypeProperties struct {
	// Command - Command for custom activity Type: string (or Expression with resultType string).
	Command interface{} `json:"command,omitempty"`
	// ResourceLinkedService - Resource linked service reference.
	ResourceLinkedService *LinkedServiceReference `json:"resourceLinkedService,omitempty"`
	// FolderPath - Folder path for resource files Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// ReferenceObjects - Reference objects
	ReferenceObjects *CustomActivityReferenceObject `json:"referenceObjects,omitempty"`
	// ExtendedProperties - User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
	ExtendedProperties map[string]interface{} `json:"extendedProperties"`
}

// MarshalJSON is the custom marshaler for CustomActivityTypeProperties.
func (catp CustomActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if catp.Command != nil {
		objectMap["command"] = catp.Command
	}
	if catp.ResourceLinkedService != nil {
		objectMap["resourceLinkedService"] = catp.ResourceLinkedService
	}
	if catp.FolderPath != nil {
		objectMap["folderPath"] = catp.FolderPath
	}
	if catp.ReferenceObjects != nil {
		objectMap["referenceObjects"] = catp.ReferenceObjects
	}
	if catp.ExtendedProperties != nil {
		objectMap["extendedProperties"] = catp.ExtendedProperties
	}
	return json.Marshal(objectMap)
}

// CustomDataset the custom dataset.
type CustomDataset struct {
	// TypeProperties - Custom dataset properties.
	TypeProperties interface{} `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDataset.
func (cd CustomDataset) MarshalJSON() ([]byte, error) {
	cd.Type = TypeCustomDataset
	objectMap := make(map[string]interface{})
	if cd.TypeProperties != nil {
		objectMap["typeProperties"] = cd.TypeProperties
	}
	if cd.Description != nil {
		objectMap["description"] = cd.Description
	}
	if cd.Structure != nil {
		objectMap["structure"] = cd.Structure
	}
	if cd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = cd.LinkedServiceName
	}
	if cd.Parameters != nil {
		objectMap["parameters"] = cd.Parameters
	}
	if cd.Annotations != nil {
		objectMap["annotations"] = cd.Annotations
	}
	if cd.Type != "" {
		objectMap["type"] = cd.Type
	}
	for k, v := range cd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCustomDataset() (*CustomDataset, bool) {
	return &cd, true
}

// AsCassandraTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsBasicDataset() (BasicDataset, bool) {
	return &cd, true
}

// UnmarshalJSON is the custom unmarshaler for CustomDataset struct.
func (cd *CustomDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var typeProperties interface{}
				err = json.Unmarshal(*v, &typeProperties)
				if err != nil {
					return err
				}
				cd.TypeProperties = typeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cd.AdditionalProperties == nil {
					cd.AdditionalProperties = make(map[string]interface{})
				}
				cd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				cd.Structure = structure
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				cd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				cd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				cd.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = typeVar
			}
		}
	}

	return nil
}

// CustomDataSourceLinkedService custom linked service.
type CustomDataSourceLinkedService struct {
	// TypeProperties - Custom linked service properties.
	TypeProperties interface{} `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) MarshalJSON() ([]byte, error) {
	cdsls.Type = TypeCustomDataSource
	objectMap := make(map[string]interface{})
	if cdsls.TypeProperties != nil {
		objectMap["typeProperties"] = cdsls.TypeProperties
	}
	if cdsls.ConnectVia != nil {
		objectMap["connectVia"] = cdsls.ConnectVia
	}
	if cdsls.Description != nil {
		objectMap["description"] = cdsls.Description
	}
	if cdsls.Parameters != nil {
		objectMap["parameters"] = cdsls.Parameters
	}
	if cdsls.Annotations != nil {
		objectMap["annotations"] = cdsls.Annotations
	}
	if cdsls.Type != "" {
		objectMap["type"] = cdsls.Type
	}
	for k, v := range cdsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsResponsysLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return &cdsls, true
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls C