package mapsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/maps/mgmt/2020-02-01-preview/maps"
	"github.com/Azure/go-autorest/autorest"
)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, mapsAccountCreateParameters maps.AccountCreateParameters) (result maps.Account, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result maps.Account, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result maps.Accounts, err error)
	ListBySubscription(ctx context.Context) (result maps.Accounts, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result maps.AccountKeys, err error)
	RegenerateKeys(ctx context.Context, resourceGroupName string, accountName string, keySpecification maps.KeySpecification) (result maps.AccountKeys, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, mapsAccountUpdateParameters maps.AccountUpdateParameters) (result maps.Account, err error)
}

var _ AccountsClientAPI = (*maps.AccountsClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	ListOperations(ctx context.Context) (result maps.Operations, err error)
}

var _ ClientAPI = (*maps.Client)(nil)

// PrivateAtlasesClientAPI contains the set of methods on the PrivateAtlasesClient type.
type PrivateAtlasesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, privateAtlasName string, privateAtlasCreateParameters maps.PrivateAtlasCreateParameters) (result maps.PrivateAtlas, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, privateAtlasName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, privateAtlasName string) (result maps.PrivateAtlas, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result maps.PrivateAtlasList, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, privateAtlasName string, privateAtlasUpdateParameters maps.PrivateAtlasUpdateParameters) (result maps.PrivateAtlas, err error)
}

var _ PrivateAtlasesClientAPI = (*maps.PrivateAtlasesClient)(nil)

// CreatorsClientAPI contains the set of methods on the CreatorsClient type.
type CreatorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, creatorName string, creatorCreateParameters maps.CreatorCreateParameters) (result maps.Creator, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, creatorName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, creatorName string) (result maps.Creator, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result maps.CreatorList, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, creatorName string, creatorUpdateParameters maps.CreatorUpdateParameters) (result maps.Creator, err error)
}

var _ CreatorsClientAPI = (*maps.CreatorsClient)(nil)
