package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AggregationFunctionType enumerates the values for aggregation function type.
type AggregationFunctionType string

const (
	// Avg ...
	Avg AggregationFunctionType = "avg"
	// Max ...
	Max AggregationFunctionType = "max"
	// Min ...
	Min AggregationFunctionType = "min"
	// Stdev ...
	Stdev AggregationFunctionType = "stdev"
	// Sum ...
	Sum AggregationFunctionType = "sum"
)

// PossibleAggregationFunctionTypeValues returns an array of possible values for the AggregationFunctionType const type.
func PossibleAggregationFunctionTypeValues() []AggregationFunctionType {
	return []AggregationFunctionType{Avg, Max, Min, Stdev, Sum}
}

// AutomaticTuningDisabledReason enumerates the values for automatic tuning disabled reason.
type AutomaticTuningDisabledReason string

const (
	// AutoConfigured ...
	AutoConfigured AutomaticTuningDisabledReason = "AutoConfigured"
	// Default ...
	Default AutomaticTuningDisabledReason = "Default"
	// Disabled ...
	Disabled AutomaticTuningDisabledReason = "Disabled"
	// InheritedFromServer ...
	InheritedFromServer AutomaticTuningDisabledReason = "InheritedFromServer"
	// NotSupported ...
	NotSupported AutomaticTuningDisabledReason = "NotSupported"
	// QueryStoreOff ...
	QueryStoreOff AutomaticTuningDisabledReason = "QueryStoreOff"
	// QueryStoreReadOnly ...
	QueryStoreReadOnly AutomaticTuningDisabledReason = "QueryStoreReadOnly"
)

// PossibleAutomaticTuningDisabledReasonValues returns an array of possible values for the AutomaticTuningDisabledReason const type.
func PossibleAutomaticTuningDisabledReasonValues() []AutomaticTuningDisabledReason {
	return []AutomaticTuningDisabledReason{AutoConfigured, Default, Disabled, InheritedFromServer, NotSupported, QueryStoreOff, QueryStoreReadOnly}
}

// AutomaticTuningMode enumerates the values for automatic tuning mode.
type AutomaticTuningMode string

const (
	// Auto ...
	Auto AutomaticTuningMode = "Auto"
	// Custom ...
	Custom AutomaticTuningMode = "Custom"
	// Inherit ...
	Inherit AutomaticTuningMode = "Inherit"
	// Unspecified ...
	Unspecified AutomaticTuningMode = "Unspecified"
)

// PossibleAutomaticTuningModeValues returns an array of possible values for the AutomaticTuningMode const type.
func PossibleAutomaticTuningModeValues() []AutomaticTuningMode {
	return []AutomaticTuningMode{Auto, Custom, Inherit, Unspecified}
}

// AutomaticTuningOptionModeActual enumerates the values for automatic tuning option mode actual.
type AutomaticTuningOptionModeActual string

const (
	// Off ...
	Off AutomaticTuningOptionModeActual = "Off"
	// On ...
	On AutomaticTuningOptionModeActual = "On"
)

// PossibleAutomaticTuningOptionModeActualValues returns an array of possible values for the AutomaticTuningOptionModeActual const type.
func PossibleAutomaticTuningOptionModeActualValues() []AutomaticTuningOptionModeActual {
	return []AutomaticTuningOptionModeActual{Off, On}
}

// AutomaticTuningOptionModeDesired enumerates the values for automatic tuning option mode desired.
type AutomaticTuningOptionModeDesired string

const (
	// AutomaticTuningOptionModeDesiredDefault ...
	AutomaticTuningOptionModeDesiredDefault AutomaticTuningOptionModeDesired = "Default"
	// AutomaticTuningOptionModeDesiredOff ...
	AutomaticTuningOptionModeDesiredOff AutomaticTuningOptionModeDesired = "Off"
	// AutomaticTuningOptionModeDesiredOn ...
	AutomaticTuningOptionModeDesiredOn AutomaticTuningOptionModeDesired = "On"
)

// PossibleAutomaticTuningOptionModeDesiredValues returns an array of possible values for the AutomaticTuningOptionModeDesired const type.
func PossibleAutomaticTuningOptionModeDesiredValues() []AutomaticTuningOptionModeDesired {
	return []AutomaticTuningOptionModeDesired{AutomaticTuningOptionModeDesiredDefault, AutomaticTuningOptionModeDesiredOff, AutomaticTuningOptionModeDesiredOn}
}

// AutomaticTuningServerMode enumerates the values for automatic tuning server mode.
type AutomaticTuningServerMode string

const (
	// AutomaticTuningServerModeAuto ...
	AutomaticTuningServerModeAuto AutomaticTuningServerMode = "Auto"
	// AutomaticTuningServerModeCustom ...
	AutomaticTuningServerModeCustom AutomaticTuningServerMode = "Custom"
	// AutomaticTuningServerModeUnspecified ...
	AutomaticTuningServerModeUnspecified AutomaticTuningServerMode = "Unspecified"
)

// PossibleAutomaticTuningServerModeValues returns an array of possible values for the AutomaticTuningServerMode const type.
func PossibleAutomaticTuningServerModeValues() []AutomaticTuningServerMode {
	return []AutomaticTuningServerMode{AutomaticTuningServerModeAuto, AutomaticTuningServerModeCustom, AutomaticTuningServerModeUnspecified}
}

// AutomaticTuningServerReason enumerates the values for automatic tuning server reason.
type AutomaticTuningServerReason string

const (
	// AutomaticTuningServerReasonAutoConfigured ...
	AutomaticTuningServerReasonAutoConfigured AutomaticTuningServerReason = "AutoConfigured"
	// AutomaticTuningServerReasonDefault ...
	AutomaticTuningServerReasonDefault AutomaticTuningServerReason = "Default"
	// AutomaticTuningServerReasonDisabled ...
	AutomaticTuningServerReasonDisabled AutomaticTuningServerReason = "Disabled"
)

// PossibleAutomaticTuningServerReasonValues returns an array of possible values for the AutomaticTuningServerReason const type.
func PossibleAutomaticTuningServerReasonValues() []AutomaticTuningServerReason {
	return []AutomaticTuningServerReason{AutomaticTuningServerReasonAutoConfigured, AutomaticTuningServerReasonDefault, AutomaticTuningServerReasonDisabled}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// CapabilityGroup enumerates the values for capability group.
type CapabilityGroup string

const (
	// SupportedEditions ...
	SupportedEditions CapabilityGroup = "supportedEditions"
	// SupportedElasticPoolEditions ...
	SupportedElasticPoolEditions CapabilityGroup = "supportedElasticPoolEditions"
	// SupportedInstancePoolEditions ...
	SupportedInstancePoolEditions CapabilityGroup = "supportedInstancePoolEditions"
	// SupportedManagedInstanceEditions ...
	SupportedManagedInstanceEditions CapabilityGroup = "supportedManagedInstanceEditions"
	// SupportedManagedInstanceVersions ...
	SupportedManagedInstanceVersions CapabilityGroup = "supportedManagedInstanceVersions"
)

// PossibleCapabilityGroupValues returns an array of possible values for the CapabilityGroup const type.
func PossibleCapabilityGroupValues() []CapabilityGroup {
	return []CapabilityGroup{SupportedEditions, SupportedElasticPoolEditions, SupportedInstancePoolEditions, SupportedManagedInstanceEditions, SupportedManagedInstanceVersions}
}

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable ...
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault ...
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled ...
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible ...
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns an array of possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{CapabilityStatusAvailable, CapabilityStatusDefault, CapabilityStatusDisabled, CapabilityStatusVisible}
}

// CatalogCollationType enumerates the values for catalog collation type.
type CatalogCollationType string

const (
	// DATABASEDEFAULT ...
	DATABASEDEFAULT CatalogCollationType = "DATABASE_DEFAULT"
	// SQLLatin1GeneralCP1CIAS ...
	SQLLatin1GeneralCP1CIAS CatalogCollationType = "SQL_Latin1_General_CP1_CI_AS"
)

// PossibleCatalogCollationTypeValues returns an array of possible values for the CatalogCollationType const type.
func PossibleCatalogCollationTypeValues() []CatalogCollationType {
	return []CatalogCollationType{DATABASEDEFAULT, SQLLatin1GeneralCP1CIAS}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{AlreadyExists, Invalid}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeCopy ...
	CreateModeCopy CreateMode = "Copy"
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeOnlineSecondary ...
	CreateModeOnlineSecondary CreateMode = "OnlineSecondary"
	// CreateModePointInTimeRestore ...
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	// CreateModeRecovery ...
	CreateModeRecovery CreateMode = "Recovery"
	// CreateModeRestore ...
	CreateModeRestore CreateMode = "Restore"
	// CreateModeRestoreExternalBackup ...
	CreateModeRestoreExternalBackup CreateMode = "RestoreExternalBackup"
	// CreateModeRestoreExternalBackupSecondary ...
	CreateModeRestoreExternalBackupSecondary CreateMode = "RestoreExternalBackupSecondary"
	// CreateModeRestoreLongTermRetentionBackup ...
	CreateModeRestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
	// CreateModeSecondary ...
	CreateModeSecondary CreateMode = "Secondary"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeCopy, CreateModeDefault, CreateModeOnlineSecondary, CreateModePointInTimeRestore, CreateModeRecovery, CreateModeRestore, CreateModeRestoreExternalBackup, CreateModeRestoreExternalBackupSecondary, CreateModeRestoreLongTermRetentionBackup, CreateModeSecondary}
}

// DatabaseLicenseType enumerates the values for database license type.
type DatabaseLicenseType string

const (
	// BasePrice ...
	BasePrice DatabaseLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded DatabaseLicenseType = "LicenseIncluded"
)

// PossibleDatabaseLicenseTypeValues returns an array of possible values for the DatabaseLicenseType const type.
func PossibleDatabaseLicenseTypeValues() []DatabaseLicenseType {
	return []DatabaseLicenseType{BasePrice, LicenseIncluded}
}

// DatabaseReadScale enumerates the values for database read scale.
type DatabaseReadScale string

const (
	// DatabaseReadScaleDisabled ...
	DatabaseReadScaleDisabled DatabaseReadScale = "Disabled"
	// DatabaseReadScaleEnabled ...
	DatabaseReadScaleEnabled DatabaseReadScale = "Enabled"
)

// PossibleDatabaseReadScaleValues returns an array of possible values for the DatabaseReadScale const type.
func PossibleDatabaseReadScaleValues() []DatabaseReadScale {
	return []DatabaseReadScale{DatabaseReadScaleDisabled, DatabaseReadScaleEnabled}
}

// DatabaseState1 enumerates the values for database state 1.
type DatabaseState1 string

const (
	// All ...
	All DatabaseState1 = "All"
	// Deleted ...
	Deleted DatabaseState1 = "Deleted"
	// Live ...
	Live DatabaseState1 = "Live"
)

// PossibleDatabaseState1Values returns an array of possible values for the DatabaseState1 const type.
func PossibleDatabaseState1Values() []DatabaseState1 {
	return []DatabaseState1{All, Deleted, Live}
}

// DatabaseState2 enumerates the values for database state 2.
type DatabaseState2 string

const (
	// DatabaseState2All ...
	DatabaseState2All DatabaseState2 = "All"
	// DatabaseState2Deleted ...
	DatabaseState2Deleted DatabaseState2 = "Deleted"
	// DatabaseState2Live ...
	DatabaseState2Live DatabaseState2 = "Live"
)

// PossibleDatabaseState2Values returns an array of possible values for the DatabaseState2 const type.
func PossibleDatabaseState2Values() []DatabaseState2 {
	return []DatabaseState2{DatabaseState2All, DatabaseState2Deleted, DatabaseState2Live}
}

// DatabaseState3 enumerates the values for database state 3.
type DatabaseState3 string

const (
	// DatabaseState3All ...
	DatabaseState3All DatabaseState3 = "All"
	// DatabaseState3Deleted ...
	DatabaseState3Deleted DatabaseState3 = "Deleted"
	// DatabaseState3Live ...
	DatabaseState3Live DatabaseState3 = "Live"
)

// PossibleDatabaseState3Values returns an array of possible values for the DatabaseState3 const type.
func PossibleDatabaseState3Values() []DatabaseState3 {
	return []DatabaseState3{DatabaseState3All, DatabaseState3Deleted, DatabaseState3Live}
}

// DatabaseState4 enumerates the values for database state 4.
type DatabaseState4 string

const (
	// DatabaseState4All ...
	DatabaseState4All DatabaseState4 = "All"
	// DatabaseState4Deleted ...
	DatabaseState4Deleted DatabaseState4 = "Deleted"
	// DatabaseState4Live ...
	DatabaseState4Live DatabaseState4 = "Live"
)

// PossibleDatabaseState4Values returns an array of possible values for the DatabaseState4 const type.
func PossibleDatabaseState4Values() []DatabaseState4 {
	return []DatabaseState4{DatabaseState4All, DatabaseState4Deleted, DatabaseState4Live}
}

// DatabaseState5 enumerates the values for database state 5.
type DatabaseState5 string

const (
	// DatabaseState5All ...
	DatabaseState5All DatabaseState5 = "All"
	// DatabaseState5Deleted ...
	DatabaseState5Deleted DatabaseState5 = "Deleted"
	// DatabaseState5Live ...
	DatabaseState5Live DatabaseState5 = "Live"
)

// PossibleDatabaseState5Values returns an array of possible values for the DatabaseState5 const type.
func PossibleDatabaseState5Values() []DatabaseState5 {
	return []DatabaseState5{DatabaseState5All, DatabaseState5Deleted, DatabaseState5Live}
}

// DatabaseState6 enumerates the values for database state 6.
type DatabaseState6 string

const (
	// DatabaseState6All ...
	DatabaseState6All DatabaseState6 = "All"
	// DatabaseState6Deleted ...
	DatabaseState6Deleted DatabaseState6 = "Deleted"
	// DatabaseState6Live ...
	DatabaseState6Live DatabaseState6 = "Live"
)

// PossibleDatabaseState6Values returns an array of possible values for the DatabaseState6 const type.
func PossibleDatabaseState6Values() []DatabaseState6 {
	return []DatabaseState6{DatabaseState6All, DatabaseState6Deleted, DatabaseState6Live}
}

// DatabaseStatus enumerates the values for database status.
type DatabaseStatus string

const (
	// DatabaseStatusAutoClosed ...
	DatabaseStatusAutoClosed DatabaseStatus = "AutoClosed"
	// DatabaseStatusCopying ...
	DatabaseStatusCopying DatabaseStatus = "Copying"
	// DatabaseStatusCreating ...
	DatabaseStatusCreating DatabaseStatus = "Creating"
	// DatabaseStatusDisabled ...
	DatabaseStatusDisabled DatabaseStatus = "Disabled"
	// DatabaseStatusEmergencyMode ...
	DatabaseStatusEmergencyMode DatabaseStatus = "EmergencyMode"
	// DatabaseStatusInaccessible ...
	DatabaseStatusInaccessible DatabaseStatus = "Inaccessible"
	// DatabaseStatusOffline ...
	DatabaseStatusOffline DatabaseStatus = "Offline"
	// DatabaseStatusOfflineChangingDwPerformanceTiers ...
	DatabaseStatusOfflineChangingDwPerformanceTiers DatabaseStatus = "OfflineChangingDwPerformanceTiers"
	// DatabaseStatusOfflineSecondary ...
	DatabaseStatusOfflineSecondary DatabaseStatus = "OfflineSecondary"
	// DatabaseStatusOnline ...
	DatabaseStatusOnline DatabaseStatus = "Online"
	// DatabaseStatusOnlineChangingDwPerformanceTiers ...
	DatabaseStatusOnlineChangingDwPerformanceTiers DatabaseStatus = "OnlineChangingDwPerformanceTiers"
	// DatabaseStatusPaused ...
	DatabaseStatusPaused DatabaseStatus = "Paused"
	// DatabaseStatusPausing ...
	DatabaseStatusPausing DatabaseStatus = "Pausing"
	// DatabaseStatusRecovering ...
	DatabaseStatusRecovering DatabaseStatus = "Recovering"
	// DatabaseStatusRecoveryPending ...
	DatabaseStatusRecoveryPending DatabaseStatus = "RecoveryPending"
	// DatabaseStatusRestoring ...
	DatabaseStatusRestoring DatabaseStatus = "Restoring"
	// DatabaseStatusResuming ...
	DatabaseStatusResuming DatabaseStatus = "Resuming"
	// DatabaseStatusScaling ...
	DatabaseStatusScaling DatabaseStatus = "Scaling"
	// DatabaseStatusShutdown ...
	DatabaseStatusShutdown DatabaseStatus = "Shutdown"
	// DatabaseStatusStandby ...
	DatabaseStatusStandby DatabaseStatus = "Standby"
	// DatabaseStatusSuspect ...
	DatabaseStatusSuspect DatabaseStatus = "Suspect"
)

// PossibleDatabaseStatusValues returns an array of possible values for the DatabaseStatus const type.
func PossibleDatabaseStatusValues() []DatabaseStatus {
	return []DatabaseStatus{DatabaseStatusAutoClosed, DatabaseStatusCopying, DatabaseStatusCreating, DatabaseStatusDisabled, DatabaseStatusEmergencyMode, DatabaseStatusInaccessible, DatabaseStatusOffline, DatabaseStatusOfflineChangingDwPerformanceTiers, DatabaseStatusOfflineSecondary, DatabaseStatusOnline, DatabaseStatusOnlineChangingDwPerformanceTiers, DatabaseStatusPaused, DatabaseStatusPausing, DatabaseStatusRecovering, DatabaseStatusRecoveryPending, DatabaseStatusRestoring, DatabaseStatusResuming, DatabaseStatusScaling, DatabaseStatusShutdown, DatabaseStatusStandby, DatabaseStatusSuspect}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// Basic ...
	Basic ElasticPoolEdition = "Basic"
	// BusinessCritical ...
	BusinessCritical ElasticPoolEdition = "BusinessCritical"
	// GeneralPurpose ...
	GeneralPurpose ElasticPoolEdition = "GeneralPurpose"
	// Premium ...
	Premium ElasticPoolEdition = "Premium"
	// Standard ...
	Standard ElasticPoolEdition = "Standard"
)

// PossibleElasticPoolEditionValues returns an array of possible values for the ElasticPoolEdition const type.
func PossibleElasticPoolEditionValues() []ElasticPoolEdition {
	return []ElasticPoolEdition{Basic, BusinessCritical, GeneralPurpose, Premium, Standard}
}

// ElasticPoolLicenseType enumerates the values for elastic pool license type.
type ElasticPoolLicenseType string

const (
	// ElasticPoolLicenseTypeBasePrice ...
	ElasticPoolLicenseTypeBasePrice ElasticPoolLicenseType = "BasePrice"
	// ElasticPoolLicenseTypeLicenseIncluded ...
	ElasticPoolLicenseTypeLicenseIncluded ElasticPoolLicenseType = "LicenseIncluded"
)

// PossibleElasticPoolLicenseTypeValues returns an array of possible values for the ElasticPoolLicenseType const type.
func PossibleElasticPoolLicenseTypeValues() []ElasticPoolLicenseType {
	return []ElasticPoolLicenseType{ElasticPoolLicenseTypeBasePrice, ElasticPoolLicenseTypeLicenseIncluded}
}

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating ...
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled ...
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady ...
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns an array of possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{ElasticPoolStateCreating, ElasticPoolStateDisabled, ElasticPoolStateReady}
}

// FailoverGroupReplicationRole enumerates the values for failover group replication role.
type FailoverGroupReplicationRole string

const (
	// Primary ...
	Primary FailoverGroupReplicationRole = "Primary"
	// Secondary ...
	Secondary FailoverGroupReplicationRole = "Secondary"
)

// PossibleFailoverGroupReplicationRoleValues returns an array of possible values for the FailoverGroupReplicationRole const type.
func PossibleFailoverGroupReplicationRoleValues() []FailoverGroupReplicationRole {
	return []FailoverGroupReplicationRole{Primary, Secondary}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// None ...
	None IdentityType = "None"
	// SystemAssigned ...
	SystemAssigned IdentityType = "SystemAssigned"
	// UserAssigned ...
	UserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{None, SystemAssigned, UserAssigned}
}

// InstanceFailoverGroupReplicationRole enumerates the values for instance failover group replication role.
type InstanceFailoverGroupReplicationRole string

const (
	// InstanceFailoverGroupReplicationRolePrimary ...
	InstanceFailoverGroupReplicationRolePrimary InstanceFailoverGroupReplicationRole = "Primary"
	// InstanceFailoverGroupReplicationRoleSecondary ...
	InstanceFailoverGroupReplicationRoleSecondary InstanceFailoverGroupReplicationRole = "Secondary"
)

// PossibleInstanceFailoverGroupReplicationRoleValues returns an array of possible values for the InstanceFailoverGroupReplicationRole const type.
func PossibleInstanceFailoverGroupReplicationRoleValues() []InstanceFailoverGroupReplicationRole {
	return []InstanceFailoverGroupReplicationRole{InstanceFailoverGroupReplicationRolePrimary, InstanceFailoverGroupReplicationRoleSecondary}
}

// InstancePoolLicenseType enumerates the values for instance pool license type.
type InstancePoolLicenseType string

const (
	// InstancePoolLicenseTypeBasePrice ...
	InstancePoolLicenseTypeBasePrice InstancePoolLicenseType = "BasePrice"
	// InstancePoolLicenseTypeLicenseIncluded ...
	InstancePoolLicenseTypeLicenseIncluded InstancePoolLicenseType = "LicenseIncluded"
)

// PossibleInstancePoolLicenseTypeValues returns an array of possible values for the InstancePoolLicenseType const type.
func PossibleInstancePoolLicenseTypeValues() []InstancePoolLicenseType {
	return []InstancePoolLicenseType{InstancePoolLicenseTypeBasePrice, InstancePoolLicenseTypeLicenseIncluded}
}

// JobAgentState enumerates the values for job agent state.
type JobAgentState string

const (
	// JobAgentStateCreating ...
	JobAgentStateCreating JobAgentState = "Creating"
	// JobAgentStateDeleting ...
	JobAgentStateDeleting JobAgentState = "Deleting"
	// JobAgentStateDisabled ...
	JobAgentStateDisabled JobAgentState = "Disabled"
	// JobAgentStateReady ...
	JobAgentStateReady JobAgentState = "Ready"
	// JobAgentStateUpdating ...
	JobAgentStateUpdating JobAgentState = "Updating"
)

// PossibleJobAgentStateValues returns an array of possible values for the JobAgentState const type.
func PossibleJobAgentStateValues() []JobAgentState {
	return []JobAgentState{JobAgentStateCreating, JobAgentStateDeleting, JobAgentStateDisabled, JobAgentStateReady, JobAgentStateUpdating}
}

// JobExecutionLifecycle enumerates the values for job execution lifecycle.
type JobExecutionLifecycle string

const (
	// Canceled ...
	Canceled JobExecutionLifecycle = "Canceled"
	// Created ...
	Created JobExecutionLifecycle = "Created"
	// Failed ...
	Failed JobExecutionLifecycle = "Failed"
	// InProgress ...
	InProgress JobExecutionLifecycle = "InProgress"
	// Skipped ...
	Skipped JobExecutionLifecycle = "Skipped"
	// Succeeded ...
	Succeeded JobExecutionLifecycle = "Succeeded"
	// SucceededWithSkipped ...
	SucceededWithSkipped JobExecutionLifecycle = "SucceededWithSkipped"
	// TimedOut ...
	TimedOut JobExecutionLifecycle = "TimedOut"
	// WaitingForChildJobExecutions ...
	WaitingForChildJobExecutions JobExecutionLifecycle = "WaitingForChildJobExecutions"
	// WaitingForRetry ...
	WaitingForRetry JobExecutionLifecycle = "WaitingForRetry"
)

// PossibleJobExecutionLifecycleValues returns an array of possible values for the JobExecutionLifecycle const type.
func PossibleJobExecutionLifecycleValues() []JobExecutionLifecycle {
	return []JobExecutionLifecycle{Canceled, Created, Failed, InProgress, Skipped, Succeeded, SucceededWithSkipped, TimedOut, WaitingForChildJobExecutions, WaitingForRetry}
}

// JobScheduleType enumerates the values for job schedule type.
type JobScheduleType string

const (
	// Once ...
	Once JobScheduleType = "Once"
	// Recurring ...
	Recurring JobScheduleType = "Recurring"
)

// PossibleJobScheduleTypeValues returns an array of possible values for the JobScheduleType const type.
func PossibleJobScheduleTypeValues() []JobScheduleType {
	return []JobScheduleType{Once, Recurring}
}

// JobStepActionSource enumerates the values for job step action source.
type JobStepActionSource string

const (
	// Inline ...
	Inline JobStepActionSource = "Inline"
)

// PossibleJobStepActionSourceValues returns an array of possible values for the JobStepActionSource const type.
func PossibleJobStepActionSourceValues() []JobStepActionSource {
	return []JobStepActionSource{Inline}
}

// JobStepActionType enumerates the values for job step action type.
type JobStepActionType string

const (
	// TSQL ...
	TSQL JobStepActionType = "TSql"
)

// PossibleJobStepActionTypeValues returns an array of possible values for the JobStepActionType const type.
func PossibleJobStepActionTypeValues() []JobStepActionType {
	return []JobStepActionType{TSQL}
}

// JobStepOutputType enumerates the values for job step output type.
type JobStepOutputType string

const (
	// SQLDatabase ...
	SQLDatabase JobStepOutputType = "SqlDatabase"
)

// PossibleJobStepOutputTypeValues returns an array of possible values for the JobStepOutputType const type.
func PossibleJobStepOutputTypeValues() []JobStepOutputType {
	return []JobStepOutputType{SQLDatabase}
}

// JobTargetGroupMembershipType enumerates the values for job target group membership type.
type JobTargetGroupMembershipType string

const (
	// Exclude ...
	Exclude JobTargetGroupMembershipType = "Exclude"
	// Include ...
	Include JobTargetGroupMembershipType = "Include"
)

// PossibleJobTargetGroupMembershipTypeValues returns an array of possible values for the JobTargetGroupMembershipType const type.
func PossibleJobTargetGroupMembershipTypeValues() []JobTargetGroupMembershipType {
	return []JobTargetGroupMembershipType{Exclude, Include}
}

// JobTargetType enumerates the values for job target type.
type JobTargetType string

const (
	// JobTargetTypeSQLDatabase ...
	JobTargetTypeSQLDatabase JobTargetType = "SqlDatabase"
	// JobTargetTypeSQLElasticPool ...
	JobTargetTypeSQLElasticPool JobTargetType = "SqlElasticPool"
	// JobTargetTypeSQLServer ...
	JobTargetTypeSQLServer JobTargetType = "SqlServer"
	// JobTargetTypeSQLShardMap ...
	JobTargetTypeSQLShardMap JobTargetType = "SqlShardMap"
	// JobTargetTypeTargetGroup ...
	JobTargetTypeTargetGroup JobTargetType = "TargetGroup"
)

// PossibleJobTargetTypeValues returns an array of possible values for the JobTargetType const type.
func PossibleJobTargetTypeValues() []JobTargetType {
	return []JobTargetType{JobTargetTypeSQLDatabase, JobTargetTypeSQLElasticPool, JobTargetTypeSQLServer, JobTargetTypeSQLShardMap, JobTargetTypeTargetGroup}
}

// LogSizeUnit enumerates the values for log size unit.
type LogSizeUnit string

const (
	// Gigabytes ...
	Gigabytes LogSizeUnit = "Gigabytes"
	// Megabytes ...
	Megabytes LogSizeUnit = "Megabytes"
	// Percent ...
	Percent LogSizeUnit = "Percent"
	// Petabytes ...
	Petabytes LogSizeUnit = "Petabytes"
	// Terabytes ...
	Terabytes LogSizeUnit = "Terabytes"
)

// PossibleLogSizeUnitValues returns an array of possible values for the LogSizeUnit const type.
func PossibleLogSizeUnitValues() []LogSizeUnit {
	return []LogSizeUnit{Gigabytes, Megabytes, Percent, Petabytes, Terabytes}
}

// LongTermRetentionDatabaseState enumerates the values for long term retention database state.
type LongTermRetentionDatabaseState string

const (
	// LongTermRetentionDatabaseStateAll ...
	LongTermRetentionDatabaseStateAll LongTermRetentionDatabaseState = "All"
	// LongTermRetentionDatabaseStateDeleted ...
	LongTermRetentionDatabaseStateDeleted LongTermRetentionDatabaseState = "Deleted"
	// LongTermRetentionDatabaseStateLive ...
	LongTermRetentionDatabaseStateLive LongTermRetentionDatabaseState = "Live"
)

// PossibleLongTermRetentionDatabaseStateValues returns an array of possible values for the LongTermRetentionDatabaseState const type.
func PossibleLongTermRetentionDatabaseStateValues() []LongTermRetentionDatabaseState {
	return []LongTermRetentionDatabaseState{LongTermRetentionDatabaseStateAll, LongTermRetentionDatabaseStateDeleted, LongTermRetentionDatabaseStateLive}
}

// ManagedDatabaseCreateMode enumerates the values for managed database create mode.
type ManagedDatabaseCreateMode string

const (
	// ManagedDatabaseCreateModeDefault ...
	ManagedDatabaseCreateModeDefault ManagedDatabaseCreateMode = "Default"
	// ManagedDatabaseCreateModePointInTimeRestore ...
	ManagedDatabaseCreateModePointInTimeRestore ManagedDatabaseCreateMode = "PointInTimeRestore"
	// ManagedDatabaseCreateModeRecovery ...
	ManagedDatabaseCreateModeRecovery ManagedDatabaseCreateMode = "Recovery"
	// ManagedDatabaseCreateModeRestoreExternalBackup ...
	ManagedDatabaseCreateModeRestoreExternalBackup ManagedDatabaseCreateMode = "RestoreExternalBackup"
	// ManagedDatabaseCreateModeRestoreLongTermRetentionBackup ...
	ManagedDatabaseCreateModeRestoreLongTermRetentionBackup ManagedDatabaseCreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleManagedDatabaseCreateModeValues returns an array of possible values for the ManagedDatabaseCreateMode const type.
func PossibleManagedDatabaseCreateModeValues() []ManagedDatabaseCreateMode {
	return []ManagedDatabaseCreateMode{ManagedDatabaseCreateModeDefault, ManagedDatabaseCreateModePointInTimeRestore, ManagedDatabaseCreateModeRecovery, ManagedDatabaseCreateModeRestoreExternalBackup, ManagedDatabaseCreateModeRestoreLongTermRetentionBackup}
}

// ManagedDatabaseStatus enumerates the values for managed database status.
type ManagedDatabaseStatus string

const (
	// Creating ...
	Creating ManagedDatabaseStatus = "Creating"
	// Inaccessible ...
	Inaccessible ManagedDatabaseStatus = "Inaccessible"
	// Offline ...
	Offline ManagedDatabaseStatus = "Offline"
	// Online ...
	Online ManagedDatabaseStatus = "Online"
	// Restoring ...
	Restoring ManagedDatabaseStatus = "Restoring"
	// Shutdown ...
	Shutdown ManagedDatabaseStatus = "Shutdown"
	// Updating ...
	Updating ManagedDatabaseStatus = "Updating"
)

// PossibleManagedDatabaseStatusValues returns an array of possible values for the ManagedDatabaseStatus const type.
func PossibleManagedDatabaseStatusValues() []ManagedDatabaseStatus {
	return []ManagedDatabaseStatus{Creating, Inaccessible, Offline, Online, Restoring, Shutdown, Updating}
}

// ManagedInstanceLicenseType enumerates the values for managed instance license type.
type ManagedInstanceLicenseType string

const (
	// ManagedInstanceLicenseTypeBasePrice ...
	ManagedInstanceLicenseTypeBasePrice ManagedInstanceLicenseType = "BasePrice"
	// ManagedInstanceLicenseTypeLicenseIncluded ...
	ManagedInstanceLicenseTypeLicenseIncluded ManagedInstanceLicenseType = "LicenseIncluded"
)

// PossibleManagedInstanceLicenseTypeValues returns an array of possible values for the ManagedInstanceLicenseType const type.
func PossibleManagedInstanceLicenseTypeValues() []ManagedInstanceLicenseType {
	return []ManagedInstanceLicenseType{ManagedInstanceLicenseTypeBasePrice, ManagedInstanceLicenseTypeLicenseIncluded}
}

// ManagedInstanceProxyOverride enumerates the values for managed instance proxy override.
type ManagedInstanceProxyOverride string

const (
	// ManagedInstanceProxyOverrideDefault ...
	ManagedInstanceProxyOverrideDefault ManagedInstanceProxyOverride = "Default"
	// ManagedInstanceProxyOverrideProxy ...
	ManagedInstanceProxyOverrideProxy ManagedInstanceProxyOverride = "Proxy"
	// ManagedInstanceProxyOverrideRedirect ...
	ManagedInstanceProxyOverrideRedirect ManagedInstanceProxyOverride = "Redirect"
)

// PossibleManagedInstanceProxyOverrideValues returns an array of possible values for the ManagedInstanceProxyOverride const type.
func PossibleManagedInstanceProxyOverrideValues() []ManagedInstanceProxyOverride {
	return []ManagedInstanceProxyOverride{ManagedInstanceProxyOverrideDefault, ManagedInstanceProxyOverrideProxy, ManagedInstanceProxyOverrideRedirect}
}

// ManagedServerCreateMode enumerates the values for managed server create mode.
type ManagedServerCreateMode string

const (
	// ManagedServerCreateModeDefault ...
	ManagedServerCreateModeDefault ManagedServerCreateMode = "Default"
	// ManagedServerCreateModePointInTimeRestore ...
	ManagedServerCreateModePointInTimeRestore ManagedServerCreateMode = "PointInTimeRestore"
)

// PossibleManagedServerCreateModeValues returns an array of possible values for the ManagedServerCreateMode const type.
func PossibleManagedServerCreateModeValues() []ManagedServerCreateMode {
	return []ManagedServerCreateMode{ManagedServerCreateModeDefault, ManagedServerCreateModePointInTimeRestore}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// ManagementOperationStateCancelInProgress ...
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	// ManagementOperationStateCancelled ...
	ManagementOperationStateCancelled ManagementOperationState = "Cancelled"
	// ManagementOperationStateFailed ...
	ManagementOperationStateFailed ManagementOperationState = "Failed"
	// ManagementOperationStateInProgress ...
	ManagementOperationStateInProgress ManagementOperationState = "InProgress"
	// ManagementOperationStatePending ...
	ManagementOperationStatePending ManagementOperationState = "Pending"
	// ManagementOperationStateSucceeded ...
	ManagementOperationStateSucceeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{ManagementOperationStateCancelInProgress, ManagementOperationStateCancelled, ManagementOperationStateFailed, ManagementOperationStateInProgress, ManagementOperationStatePending, ManagementOperationStateSucceeded}
}

// MaxSizeUnit enumerates the values for max size unit.
type MaxSizeUnit string

const (
	// MaxSizeUnitGigabytes ...
	MaxSizeUnitGigabytes MaxSizeUnit = "Gigabytes"
	// MaxSizeUnitMegabytes ...
	MaxSizeUnitMegabytes MaxSizeUnit = "Megabytes"
	// MaxSizeUnitPetabytes ...
	MaxSizeUnitPetabytes MaxSizeUnit = "Petabytes"
	// MaxSizeUnitTerabytes ...
	MaxSizeUnitTerabytes MaxSizeUnit = "Terabytes"
)

// PossibleMaxSizeUnitValues returns an array of possible values for the MaxSizeUnit const type.
func PossibleMaxSizeUnitValues() []MaxSizeUnit {
	return []MaxSizeUnit{MaxSizeUnitGigabytes, MaxSizeUnitMegabytes, MaxSizeUnitPetabytes, MaxSizeUnitTerabytes}
}

// MetricType enumerates the values for metric type.
type MetricType string

const (
	// CPU ...
	CPU MetricType = "cpu"
	// Dtu ...
	Dtu MetricType = "dtu"
	// Duration ...
	Duration MetricType = "duration"
	// Io ...
	Io MetricType = "io"
	// LogIo ...
	LogIo MetricType = "logIo"
)

// PossibleMetricTypeValues returns an array of possible values for the MetricType const type.
func PossibleMetricTypeValues() []MetricType {
	return []MetricType{CPU, Dtu, Duration, Io, LogIo}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser}
}

// PauseDelayTimeUnit enumerates the values for pause delay time unit.
type PauseDelayTimeUnit string

const (
	// Minutes ...
	Minutes PauseDelayTimeUnit = "Minutes"
)

// PossiblePauseDelayTimeUnitValues returns an array of possible values for the PauseDelayTimeUnit const type.
func PossiblePauseDelayTimeUnitValues() []PauseDelayTimeUnit {
	return []PauseDelayTimeUnit{Minutes}
}

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU ...
	DTU PerformanceLevelUnit = "DTU"
	// VCores ...
	VCores PerformanceLevelUnit = "VCores"
)

// PossiblePerformanceLevelUnitValues returns an array of possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{DTU, VCores}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// PrimaryAggregationTypeAverage ...
	PrimaryAggregationTypeAverage PrimaryAggregationType = "Average"
	// PrimaryAggregationTypeCount ...
	PrimaryAggregationTypeCount PrimaryAggregationType = "Count"
	// PrimaryAggregationTypeMaximum ...
	PrimaryAggregationTypeMaximum PrimaryAggregationType = "Maximum"
	// PrimaryAggregationTypeMinimum ...
	PrimaryAggregationTypeMinimum PrimaryAggregationType = "Minimum"
	// PrimaryAggregationTypeNone ...
	PrimaryAggregationTypeNone PrimaryAggregationType = "None"
	// PrimaryAggregationTypeTotal ...
	PrimaryAggregationTypeTotal PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{PrimaryAggregationTypeAverage, PrimaryAggregationTypeCount, PrimaryAggregationTypeMaximum, PrimaryAggregationTypeMinimum, PrimaryAggregationTypeNone, PrimaryAggregationTypeTotal}
}

// PrivateEndpointProvisioningState enumerates the values for private endpoint provisioning state.
type PrivateEndpointProvisioningState string

const (
	// PrivateEndpointProvisioningStateApproving ...
	PrivateEndpointProvisioningStateApproving PrivateEndpointProvisioningState = "Approving"
	// PrivateEndpointProvisioningStateDropping ...
	PrivateEndpointProvisioningStateDropping PrivateEndpointProvisioningState = "Dropping"
	// PrivateEndpointProvisioningStateFailed ...
	PrivateEndpointProvisioningStateFailed PrivateEndpointProvisioningState = "Failed"
	// PrivateEndpointProvisioningStateReady ...
	PrivateEndpointProvisioningStateReady PrivateEndpointProvisioningState = "Ready"
	// PrivateEndpointProvisioningStateRejecting ...
	PrivateEndpointProvisioningStateRejecting PrivateEndpointProvisioningState = "Rejecting"
)

// PossiblePrivateEndpointProvisioningStateValues returns an array of possible values for the PrivateEndpointProvisioningState const type.
func PossiblePrivateEndpointProvisioningStateValues() []PrivateEndpointProvisioningState {
	return []PrivateEndpointProvisioningState{PrivateEndpointProvisioningStateApproving, PrivateEndpointProvisioningStateDropping, PrivateEndpointProvisioningStateFailed, PrivateEndpointProvisioningStateReady, PrivateEndpointProvisioningStateRejecting}
}

// PrivateLinkServiceConnectionStateActionsRequire enumerates the values for private link service connection
// state actions require.
type PrivateLinkServiceConnectionStateActionsRequire string

const (
	// PrivateLinkServiceConnectionStateActionsRequireNone ...
	PrivateLinkServiceConnectionStateActionsRequireNone PrivateLinkServiceConnectionStateActionsRequire = "None"
)

// PossiblePrivateLinkServiceConnectionStateActionsRequireValues returns an array of possible values for the PrivateLinkServiceConnectionStateActionsRequire const type.
func PossiblePrivateLinkServiceConnectionStateActionsRequireValues() []PrivateLinkServiceConnectionStateActionsRequire {
	return []PrivateLinkServiceConnectionStateActionsRequire{PrivateLinkServiceConnectionStateActionsRequireNone}
}

// PrivateLinkServiceConnectionStateStatus enumerates the values for private link service connection state
// status.
type PrivateLinkServiceConnectionStateStatus string

const (
	// Approved ...
	Approved PrivateLinkServiceConnectionStateStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateLinkServiceConnectionStateStatus = "Disconnected"
	// Pending ...
	Pending PrivateLinkServiceConnectionStateStatus = "Pending"
	// Rejected ...
	Rejected PrivateLinkServiceConnectionStateStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStateStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStateStatus const type.
func PossiblePrivateLinkServiceConnectionStateStatusValues() []PrivateLinkServiceConnectionStateStatus {
	return []PrivateLinkServiceConnectionStateStatus{Approved, Disconnected, Pending, Rejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
	// ProvisioningState1Unknown ...
	ProvisioningState1Unknown ProvisioningState1 = "Unknown"
	// ProvisioningState1Updating ...
	ProvisioningState1Updating ProvisioningState1 = "Updating"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Succeeded, ProvisioningState1Unknown, ProvisioningState1Updating}
}

// QueryMetricUnitType enumerates the values for query metric unit type.
type QueryMetricUnitType string

const (
	// Count ...
	Count QueryMetricUnitType = "count"
	// KB ...
	KB QueryMetricUnitType = "KB"
	// Microseconds ...
	Microseconds QueryMetricUnitType = "microseconds"
	// Percentage ...
	Percentage QueryMetricUnitType = "percentage"
)

// PossibleQueryMetricUnitTypeValues returns an array of possible values for the QueryMetricUnitType const type.
func PossibleQueryMetricUnitTypeValues() []QueryMetricUnitType {
	return []QueryMetricUnitType{Count, KB, Microseconds, Percentage}
}

// QueryTimeGrainType enumerates the values for query time grain type.
type QueryTimeGrainType string

const (
	// P1D ...
	P1D QueryTimeGrainType = "P1D"
	// PT1H ...
	PT1H QueryTimeGrainType = "PT1H"
)

// PossibleQueryTimeGrainTypeValues returns an array of possible values for the QueryTimeGrainType const type.
func PossibleQueryTimeGrainTypeValues() []QueryTimeGrainType {
	return []QueryTimeGrainType{P1D, PT1H}
}

// ReadOnlyEndpointFailoverPolicy enumerates the values for read only endpoint failover policy.
type ReadOnlyEndpointFailoverPolicy string

const (
	// ReadOnlyEndpointFailoverPolicyDisabled ...
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	// ReadOnlyEndpointFailoverPolicyEnabled ...
	ReadOnlyEndpointFailoverPolicyEnabled ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// PossibleReadOnlyEndpointFailoverPolicyValues returns an array of possible values for the ReadOnlyEndpointFailoverPolicy const type.
func PossibleReadOnlyEndpointFailoverPolicyValues() []ReadOnlyEndpointFailoverPolicy {
	return []ReadOnlyEndpointFailoverPolicy{ReadOnlyEndpointFailoverPolicyDisabled, ReadOnlyEndpointFailoverPolicyEnabled}
}

// ReadWriteEndpointFailoverPolicy enumerates the values for read write endpoint failover policy.
type ReadWriteEndpointFailoverPolicy string

const (
	// Automatic ...
	Automatic ReadWriteEndpointFailoverPolicy = "Automatic"
	// Manual ...
	Manual ReadWriteEndpointFailoverPolicy = "Manual"
)

// PossibleReadWriteEndpointFailoverPolicyValues returns an array of possible values for the ReadWriteEndpointFailoverPolicy const type.
func PossibleReadWriteEndpointFailoverPolicyValues() []ReadWriteEndpointFailoverPolicy {
	return []ReadWriteEndpointFailoverPolicy{Automatic, Manual}
}

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create ...
	Create RecommendedIndexAction = "Create"
	// Drop ...
	Drop RecommendedIndexAction = "Drop"
	// Rebuild ...
	Rebuild RecommendedIndexAction = "Rebuild"
)

// PossibleRecommendedIndexActionValues returns an array of possible values for the RecommendedIndexAction const type.
func PossibleRecommendedIndexActionValues() []RecommendedIndexAction {
	return []RecommendedIndexAction{Create, Drop, Rebuild}
}

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// RecommendedIndexStateActive ...
	RecommendedIndexStateActive RecommendedIndexState = "Active"
	// RecommendedIndexStateBlocked ...
	RecommendedIndexStateBlocked RecommendedIndexState = "Blocked"
	// RecommendedIndexStateExecuting ...
	RecommendedIndexStateExecuting RecommendedIndexState = "Executing"
	// RecommendedIndexStateExpired ...
	RecommendedIndexStateExpired RecommendedIndexState = "Expired"
	// RecommendedIndexStateIgnored ...
	RecommendedIndexStateIgnored RecommendedIndexState = "Ignored"
	// RecommendedIndexStatePending ...
	RecommendedIndexStatePending RecommendedIndexState = "Pending"
	// RecommendedIndexStatePendingRevert ...
	RecommendedIndexStatePendingRevert RecommendedIndexState = "Pending Revert"
	// RecommendedIndexStateReverted ...
	RecommendedIndexStateReverted RecommendedIndexState = "Reverted"
	// RecommendedIndexStateReverting ...
	RecommendedIndexStateReverting RecommendedIndexState = "Reverting"
	// RecommendedIndexStateSuccess ...
	RecommendedIndexStateSuccess RecommendedIndexState = "Success"
	// RecommendedIndexStateVerifying ...
	RecommendedIndexStateVerifying RecommendedIndexState = "Verifying"
)

// PossibleRecommendedIndexStateValues returns an array of possible values for the RecommendedIndexState const type.
func PossibleRecommendedIndexStateValues() []RecommendedIndexState {
	return []RecommendedIndexState{RecommendedIndexStateActive, RecommendedIndexStateBlocked, RecommendedIndexStateExecuting, RecommendedIndexStateExpired, RecommendedIndexStateIgnored, RecommendedIndexStatePending, RecommendedIndexStatePendingRevert, RecommendedIndexStateReverted, RecommendedIndexStateReverting, RecommendedIndexStateSuccess, RecommendedIndexStateVerifying}
}

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED ...
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE ...
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE ...
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED ...
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// PossibleRecommendedIndexTypeValues returns an array of possible values for the RecommendedIndexType const type.
func PossibleRecommendedIndexTypeValues() []RecommendedIndexType {
	return []RecommendedIndexType{CLUSTERED, CLUSTEREDCOLUMNSTORE, COLUMNSTORE, NONCLUSTERED}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// ReplicaType enumerates the values for replica type.
type ReplicaType string

const (
	// ReplicaTypePrimary ...
	ReplicaTypePrimary ReplicaType = "Primary"
	// ReplicaTypeReadableSecondary ...
	ReplicaTypeReadableSecondary ReplicaType = "ReadableSecondary"
)

// PossibleReplicaTypeValues returns an array of possible values for the ReplicaType const type.
func PossibleReplicaTypeValues() []ReplicaType {
	return []ReplicaType{ReplicaTypePrimary, ReplicaTypeReadableSecondary}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT ...
	AdventureWorksLT SampleName = "AdventureWorksLT"
	// WideWorldImportersFull ...
	WideWorldImportersFull SampleName = "WideWorldImportersFull"
	// WideWorldImportersStd ...
	WideWorldImportersStd SampleName = "WideWorldImportersStd"
)

// PossibleSampleNameValues returns an array of possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{AdventureWorksLT, WideWorldImportersFull, WideWorldImportersStd}
}

// SecondaryType enumerates the values for secondary type.
type SecondaryType string

const (
	// Geo ...
	Geo SecondaryType = "Geo"
	// Named ...
	Named SecondaryType = "Named"
)

// PossibleSecondaryTypeValues returns an array of possible values for the SecondaryType const type.
func PossibleSecondaryTypeValues() []SecondaryType {
	return []SecondaryType{Geo, Named}
}

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled ...
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled ...
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// PossibleSecurityAlertPolicyEmailAccountAdminsValues returns an array of possible values for the SecurityAlertPolicyEmailAccountAdmins const type.
func PossibleSecurityAlertPolicyEmailAccountAdminsValues() []SecurityAlertPolicyEmailAccountAdmins {
	return []SecurityAlertPolicyEmailAccountAdmins{SecurityAlertPolicyEmailAccountAdminsDisabled, SecurityAlertPolicyEmailAccountAdminsEnabled}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled ...
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled ...
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// PossibleSecurityAlertPolicyUseServerDefaultValues returns an array of possible values for the SecurityAlertPolicyUseServerDefault const type.
func PossibleSecurityAlertPolicyUseServerDefaultValues() []SecurityAlertPolicyUseServerDefault {
	return []SecurityAlertPolicyUseServerDefault{SecurityAlertPolicyUseServerDefaultDisabled, SecurityAlertPolicyUseServerDefaultEnabled}
}

// SensitivityLabelRank enumerates the values for sensitivity label rank.
type SensitivityLabelRank string

const (
	// SensitivityLabelRankCritical ...
	SensitivityLabelRankCritical SensitivityLabelRank = "Critical"
	// SensitivityLabelRankHigh ...
	SensitivityLabelRankHigh SensitivityLabelRank = "High"
	// SensitivityLabelRankLow ...
	SensitivityLabelRankLow SensitivityLabelRank = "Low"
	// SensitivityLabelRankMedium ...
	SensitivityLabelRankMedium SensitivityLabelRank = "Medium"
	// SensitivityLabelRankNone ...
	SensitivityLabelRankNone SensitivityLabelRank = "None"
)

// PossibleSensitivityLabelRankValues returns an array of possible values for the SensitivityLabelRank const type.
func PossibleSensitivityLabelRankValues() []SensitivityLabelRank {
	return []SensitivityLabelRank{SensitivityLabelRankCritical, SensitivityLabelRankHigh, SensitivityLabelRankLow, SensitivityLabelRankMedium, SensitivityLabelRankNone}
}

// SensitivityLabelSource enumerates the values for sensitivity label source.
type SensitivityLabelSource string

const (
	// Current ...
	Current SensitivityLabelSource = "current"
	// Recommended ...
	Recommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns an array of possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{Current, Recommended}
}

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault ...
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy ...
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect ...
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns an array of possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{ServerConnectionTypeDefault, ServerConnectionTypeProxy, ServerConnectionTypeRedirect}
}

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// AzureKeyVault ...
	AzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServiceManaged ...
	ServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns an array of possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{AzureKeyVault, ServiceManaged}
}

// ServerPublicNetworkAccess enumerates the values for server public network access.
type ServerPublicNetworkAccess string

const (
	// ServerPublicNetworkAccessDisabled ...
	ServerPublicNetworkAccessDisabled ServerPublicNetworkAccess = "Disabled"
	// ServerPublicNetworkAccessEnabled ...
	ServerPublicNetworkAccessEnabled ServerPublicNetworkAccess = "Enabled"
)

// PossibleServerPublicNetworkAccessValues returns an array of possible values for the ServerPublicNetworkAccess const type.
func PossibleServerPublicNetworkAccessValues() []ServerPublicNetworkAccess {
	return []ServerPublicNetworkAccess{ServerPublicNetworkAccessDisabled, ServerPublicNetworkAccessEnabled}
}

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic ...
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameDS100 ...
	ServiceObjectiveNameDS100 ServiceObjectiveName = "DS100"
	// ServiceObjectiveNameDS1000 ...
	ServiceObjectiveNameDS1000 ServiceObjectiveName = "DS1000"
	// ServiceObjectiveNameDS1200 ...
	ServiceObjectiveNameDS1200 ServiceObjectiveName = "DS1200"
	// ServiceObjectiveNameDS1500 ...
	ServiceObjectiveNameDS1500 ServiceObjectiveName = "DS1500"
	// ServiceObjectiveNameDS200 ...
	ServiceObjectiveNameDS200 ServiceObjectiveName = "DS200"
	// ServiceObjectiveNameDS2000 ...
	ServiceObjectiveNameDS2000 ServiceObjectiveName = "DS2000"
	// ServiceObjectiveNameDS300 ...
	ServiceObjectiveNameDS300 ServiceObjectiveName = "DS300"
	// ServiceObjectiveNameDS400 ...
	ServiceObjectiveNameDS400 ServiceObjectiveName = "DS400"
	// ServiceObjectiveNameDS500 ...
	ServiceObjectiveNameDS500 ServiceObjectiveName = "DS500"
	// ServiceObjectiveNameDS600 ...
	ServiceObjectiveNameDS600 ServiceObjectiveName = "DS600"
	// ServiceObjectiveNameDW100 ...
	ServiceObjectiveNameDW100 ServiceObjectiveName = "DW100"
	// ServiceObjectiveNameDW1000 ...
	ServiceObjectiveNameDW1000 ServiceObjectiveName = "DW1000"
	// ServiceObjectiveNameDW10000c ...
	ServiceObjectiveNameDW10000c ServiceObjectiveName = "DW10000c"
	// ServiceObjectiveNameDW1000c ...
	ServiceObjectiveNameDW1000c ServiceObjectiveName = "DW1000c"
	// ServiceObjectiveNameDW1200 ...
	ServiceObjectiveNameDW1200 ServiceObjectiveName = "DW1200"
	// ServiceObjectiveNameDW1500 ...
	ServiceObjectiveNameDW1500 ServiceObjectiveName = "DW1500"
	// ServiceObjectiveNameDW15000c ...
	ServiceObjectiveNameDW15000c ServiceObjectiveName = "DW15000c"
	// ServiceObjectiveNameDW1500c ...
	ServiceObjectiveNameDW1500c ServiceObjectiveName = "DW1500c"
	// ServiceObjectiveNameDW200 ...
	ServiceObjectiveNameDW200 ServiceObjectiveName = "DW200"
	// ServiceObjectiveNameDW2000 ...
	ServiceObjectiveNameDW2000 ServiceObjectiveName = "DW2000"
	// ServiceObjectiveNameDW2000c ...
	ServiceObjectiveNameDW2000c ServiceObjectiveName = "DW2000c"
	// ServiceObjectiveNameDW2500c ...
	ServiceObjectiveNameDW2500c ServiceObjectiveName = "DW2500c"
	// ServiceObjectiveNameDW300 ...
	ServiceObjectiveNameDW300 ServiceObjectiveName = "DW300"
	// ServiceObjectiveNameDW3000 ...
	ServiceObjectiveNameDW3000 ServiceObjectiveName = "DW3000"
	// ServiceObjectiveNameDW30000c ...
	ServiceObjectiveNameDW30000c ServiceObjectiveName = "DW30000c"
	// ServiceObjectiveNameDW3000c ...
	ServiceObjectiveNameDW3000c ServiceObjectiveName = "DW3000c"
	// ServiceObjectiveNameDW400 ...
	ServiceObjectiveNameDW400 ServiceObjectiveName = "DW400"
	// ServiceObjectiveNameDW500 ...
	ServiceObjectiveNameDW500 ServiceObjectiveName = "DW500"
	// ServiceObjectiveNameDW5000c ...
	ServiceObjectiveNameDW5000c ServiceObjectiveName = "DW5000c"
	// ServiceObjectiveNameDW600 ...
	ServiceObjectiveNameDW600 ServiceObjectiveName = "DW600"
	// ServiceObjectiveNameDW6000 ...
	ServiceObjectiveNameDW6000 ServiceObjectiveName = "DW6000"
	// ServiceObjectiveNameDW6000c ...
	ServiceObjectiveNameDW6000c ServiceObjectiveName = "DW6000c"
	// ServiceObjectiveNameDW7500c ...
	ServiceObjectiveNameDW7500c ServiceObjectiveName = "DW7500c"
	// ServiceObjectiveNameElasticPool ...
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameFree ...
	ServiceObjectiveNameFree ServiceObjectiveName = "Free"
	// ServiceObjectiveNameP1 ...
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 ...
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 ...
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 ...
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 ...
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 ...
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 ...
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNamePRS1 ...
	ServiceObjectiveNamePRS1 ServiceObjectiveName = "PRS1"
	// ServiceObjectiveNamePRS2 ...
	ServiceObjectiveNamePRS2 ServiceObjectiveName = "PRS2"
	// ServiceObjectiveNamePRS4 ...
	ServiceObjectiveNamePRS4 ServiceObjectiveName = "PRS4"
	// ServiceObjectiveNamePRS6 ...
	ServiceObjectiveNamePRS6 ServiceObjectiveName = "PRS6"
	// ServiceObjectiveNameS0 ...
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 ...
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS12 ...
	ServiceObjectiveNameS12 ServiceObjectiveName = "S12"
	// ServiceObjectiveNameS2 ...
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 ...
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameS4 ...
	ServiceObjectiveNameS4 ServiceObjectiveName = "S4"
	// ServiceObjectiveNameS6 ...
	ServiceObjectiveNameS6 ServiceObjectiveName = "S6"
	// ServiceObjectiveNameS7 ...
	ServiceObjectiveNameS7 ServiceObjectiveName = "S7"
	// ServiceObjectiveNameS9 ...
	ServiceObjectiveNameS9 ServiceObjectiveName = "S9"
	// ServiceObjectiveNameSystem ...
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem0 ...
	ServiceObjectiveNameSystem0 ServiceObjectiveName = "System0"
	// ServiceObjectiveNameSystem1 ...
	ServiceObjectiveNameSystem1 ServiceObjectiveName = "System1"
	// ServiceObjectiveNameSystem2 ...
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
	// ServiceObjectiveNameSystem2L ...
	ServiceObjectiveNameSystem2L ServiceObjectiveName = "System2L"
	// ServiceObjectiveNameSystem3 ...
	ServiceObjectiveNameSystem3 ServiceObjectiveName = "System3"
	// ServiceObjectiveNameSystem3L ...
	ServiceObjectiveNameSystem3L ServiceObjectiveName = "System3L"
	// ServiceObjectiveNameSystem4 ...
	ServiceObjectiveNameSystem4 ServiceObjectiveName = "System4"
	// ServiceObjectiveNameSystem4L ...
	ServiceObjectiveNameSystem4L ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns an array of possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{ServiceObjectiveNameBasic, ServiceObjectiveNameDS100, ServiceObjectiveNameDS1000, ServiceObjectiveNameDS1200, ServiceObjectiveNameDS1500, ServiceObjectiveNameDS200, ServiceObjectiveNameDS2000, ServiceObjectiveNameDS300, ServiceObjectiveNameDS400, ServiceObjectiveNameDS500, ServiceObjectiveNameDS600, ServiceObjectiveNameDW100, ServiceObjectiveNameDW1000, ServiceObjectiveNameDW10000c, ServiceObjectiveNameDW1000c, ServiceObjectiveNameDW1200, ServiceObjectiveNameDW1500, ServiceObjectiveNameDW15000c, ServiceObjectiveNameDW1500c, ServiceObjectiveNameDW200, ServiceObjectiveNameDW2000, ServiceObjectiveNameDW2000c, ServiceObjectiveNameDW2500c, ServiceObjectiveNameDW300, ServiceObjectiveNameDW3000, ServiceObjectiveNameDW30000c, ServiceObjectiveNameDW3000c, ServiceObjectiveNameDW400, ServiceObjectiveNameDW500, ServiceObjectiveNameDW5000c, ServiceObjectiveNameDW600, ServiceObjectiveNameDW6000, ServiceObjectiveNameDW6000c, ServiceObjectiveNameDW7500c, ServiceObjectiveNameElasticPool, ServiceObjectiveNameFree, ServiceObjectiveNameP1, ServiceObjectiveNameP11, ServiceObjectiveNameP15, ServiceObjectiveNameP2, ServiceObjectiveNameP3, ServiceObjectiveNameP4, ServiceObjectiveNameP6, ServiceObjectiveNamePRS1, ServiceObjectiveNamePRS2, ServiceObjectiveNamePRS4, ServiceObjectiveNamePRS6, ServiceObjectiveNameS0, ServiceObjectiveNameS1, ServiceObjectiveNameS12, ServiceObjectiveNameS2, ServiceObjectiveNameS3, ServiceObjectiveNameS4, ServiceObjectiveNameS6, ServiceObjectiveNameS7, ServiceObjectiveNameS9, ServiceObjectiveNameSystem, ServiceObjectiveNameSystem0, ServiceObjectiveNameSystem1, ServiceObjectiveNameSystem2, ServiceObjectiveNameSystem2L, ServiceObjectiveNameSystem3, ServiceObjectiveNameSystem3L, ServiceObjectiveNameSystem4, ServiceObjectiveNameSystem4L}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusCanceled ...
	StatusCanceled Status = "Canceled"
	// StatusCompleted ...
	StatusCompleted Status = "Completed"
	// StatusFailed ...
	StatusFailed Status = "Failed"
	// StatusInProgress ...
	StatusInProgress Status = "InProgress"
	// StatusNotStarted ...
	StatusNotStarted Status = "NotStarted"
	// StatusSlowedDown ...
	StatusSlowedDown Status = "SlowedDown"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusCanceled, StatusCompleted, StatusFailed, StatusInProgress, StatusNotStarted, StatusSlowedDown}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// GRS ...
	GRS StorageAccountType = "GRS"
	// LRS ...
	LRS StorageAccountType = "LRS"
	// ZRS ...
	ZRS StorageAccountType = "ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{GRS, LRS, ZRS}
}

// StorageAccountType1 enumerates the values for storage account type 1.
type StorageAccountType1 string

const (
	// StorageAccountType1GRS ...
	StorageAccountType1GRS StorageAccountType1 = "GRS"
	// StorageAccountType1LRS ...
	StorageAccountType1LRS StorageAccountType1 = "LRS"
	// StorageAccountType1ZRS ...
	StorageAccountType1ZRS StorageAccountType1 = "ZRS"
)

// PossibleStorageAccountType1Values returns an array of possible values for the StorageAccountType1 const type.
func PossibleStorageAccountType1Values() []StorageAccountType1 {
	return []StorageAccountType1{StorageAccountType1GRS, StorageAccountType1LRS, StorageAccountType1ZRS}
}

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey ...
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey ...
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns an array of possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{SharedAccessKey, StorageAccessKey}
}

// SyncAgentState enumerates the values for sync agent state.
type SyncAgentState string

const (
	// SyncAgentStateNeverConnected ...
	SyncAgentStateNeverConnected SyncAgentState = "NeverConnected"
	// SyncAgentStateOffline ...
	SyncAgentStateOffline SyncAgentState = "Offline"
	// SyncAgentStateOnline ...
	SyncAgentStateOnline SyncAgentState = "Online"
)

// PossibleSyncAgentStateValues returns an array of possible values for the SyncAgentState const type.
func PossibleSyncAgentStateValues() []SyncAgentState {
	return []SyncAgentState{SyncAgentStateNeverConnected, SyncAgentStateOffline, SyncAgentStateOnline}
}

// SyncConflictResolutionPolicy enumerates the values for sync conflict resolution policy.
type SyncConflictResolutionPolicy string

const (
	// HubWin ...
	HubWin SyncConflictResolutionPolicy = "HubWin"
	// MemberWin ...
	MemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// PossibleSyncConflictResolutionPolicyValues returns an array of possible values for the SyncConflictResolutionPolicy const type.
func PossibleSyncConflictResolutionPolicyValues() []SyncConflictResolutionPolicy {
	return []SyncConflictResolutionPolicy{HubWin, MemberWin}
}

// SyncDirection enumerates the values for sync direction.
type SyncDirection string

const (
	// Bidirectional ...
	Bidirectional SyncDirection = "Bidirectional"
	// OneWayHubToMember ...
	OneWayHubToMember SyncDirection = "OneWayHubToMember"
	// OneWayMemberToHub ...
	OneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// PossibleSyncDirectionValues returns an array of possible values for the SyncDirection const type.
func PossibleSyncDirectionValues() []SyncDirection {
	return []SyncDirection{Bidirectional, OneWayHubToMember, OneWayMemberToHub}
}

// SyncGroupLogType enumerates the values for sync group log type.
type SyncGroupLogType string

const (
	// SyncGroupLogTypeAll ...
	SyncGroupLogTypeAll SyncGroupLogType = "All"
	// SyncGroupLogTypeError ...
	SyncGroupLogTypeError SyncGroupLogType = "Error"
	// SyncGroupLogTypeSuccess ...
	SyncGroupLogTypeSuccess SyncGroupLogType = "Success"
	// SyncGroupLogTypeWarning ...
	SyncGroupLogTypeWarning SyncGroupLogType = "Warning"
)

// PossibleSyncGroupLogTypeValues returns an array of possible values for the SyncGroupLogType const type.
func PossibleSyncGroupLogTypeValues() []SyncGroupLogType {
	return []SyncGroupLogType{SyncGroupLogTypeAll, SyncGroupLogTypeError, SyncGroupLogTypeSuccess, SyncGroupLogTypeWarning}
}

// SyncGroupState enumerates the values for sync group state.
type SyncGroupState string

const (
	// Error ...
	Error SyncGroupState = "Error"
	// Good ...
	Good SyncGroupState = "Good"
	// NotReady ...
	NotReady SyncGroupState = "NotReady"
	// Progressing ...
	Progressing SyncGroupState = "Progressing"
	// Warning ...
	Warning SyncGroupState = "Warning"
)

// PossibleSyncGroupStateValues returns an array of possible values for the SyncGroupState const type.
func PossibleSyncGroupStateValues() []SyncGroupState {
	return []SyncGroupState{Error, Good, NotReady, Progressing, Warning}
}

// SyncMemberDbType enumerates the values for sync member db type.
type SyncMemberDbType string

const (
	// AzureSQLDatabase ...
	AzureSQLDatabase SyncMemberDbType = "AzureSqlDatabase"
	// SQLServerDatabase ...
	SQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// PossibleSyncMemberDbTypeValues returns an array of possible values for the SyncMemberDbType const type.
func PossibleSyncMemberDbTypeValues() []SyncMemberDbType {
	return []SyncMemberDbType{AzureSQLDatabase, SQLServerDatabase}
}

// SyncMemberState enumerates the values for sync member state.
type SyncMemberState string

const (
	// DeProvisioned ...
	DeProvisioned SyncMemberState = "DeProvisioned"
	// DeProvisionFailed ...
	DeProvisionFailed SyncMemberState = "DeProvisionFailed"
	// DeProvisioning ...
	DeProvisioning SyncMemberState = "DeProvisioning"
	// DisabledBackupRestore ...
	DisabledBackupRestore SyncMemberState = "DisabledBackupRestore"
	// DisabledTombstoneCleanup ...
	DisabledTombstoneCleanup SyncMemberState = "DisabledTombstoneCleanup"
	// Provisioned ...
	Provisioned SyncMemberState = "Provisioned"
	// ProvisionFailed ...
	ProvisionFailed SyncMemberState = "ProvisionFailed"
	// Provisioning ...
	Provisioning SyncMemberState = "Provisioning"
	// ReprovisionFailed ...
	ReprovisionFailed SyncMemberState = "ReprovisionFailed"
	// Reprovisioning ...
	Reprovisioning SyncMemberState = "Reprovisioning"
	// SyncCancelled ...
	SyncCancelled SyncMemberState = "SyncCancelled"
	// SyncCancelling ...
	SyncCancelling SyncMemberState = "SyncCancelling"
	// SyncFailed ...
	SyncFailed SyncMemberState = "SyncFailed"
	// SyncInProgress ...
	SyncInProgress SyncMemberState = "SyncInProgress"
	// SyncSucceeded ...
	SyncSucceeded SyncMemberState = "SyncSucceeded"
	// SyncSucceededWithWarnings ...
	SyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	// UnProvisioned ...
	UnProvisioned SyncMemberState = "UnProvisioned"
	// UnReprovisioned ...
	UnReprovisioned SyncMemberState = "UnReprovisioned"
)

// PossibleSyncMemberStateValues returns an array of possible values for the SyncMemberState const type.
func PossibleSyncMemberStateValues() []SyncMemberState {
	return []SyncMemberState{DeProvisioned, DeProvisionFailed, DeProvisioning, DisabledBackupRestore, DisabledTombstoneCleanup, Provisioned, ProvisionFailed, Provisioning, ReprovisionFailed, Reprovisioning, SyncCancelled, SyncCancelling, SyncFailed, SyncInProgress, SyncSucceeded, SyncSucceededWithWarnings, UnProvisioned, UnReprovisioned}
}

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity
// status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting ...
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting ...
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// PossibleTransparentDataEncryptionActivityStatusValues returns an array of possible values for the TransparentDataEncryptionActivityStatus const type.
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return []TransparentDataEncryptionActivityStatus{Decrypting, Encrypting}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// UnitDefinitionTypeBytes ...
	UnitDefinitionTypeBytes UnitDefinitionType = "Bytes"
	// UnitDefinitionTypeBytesPerSecond ...
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// UnitDefinitionTypeCount ...
	UnitDefinitionTypeCount UnitDefinitionType = "Count"
	// UnitDefinitionTypeCountPerSecond ...
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	// UnitDefinitionTypePercent ...
	UnitDefinitionTypePercent UnitDefinitionType = "Percent"
	// UnitDefinitionTypeSeconds ...
	UnitDefinitionTypeSeconds UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns an array of possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{UnitDefinitionTypeBytes, UnitDefinitionTypeBytesPerSecond, UnitDefinitionTypeCount, UnitDefinitionTypeCountPerSecond, UnitDefinitionTypePercent, UnitDefinitionTypeSeconds}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes ...
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond ...
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount ...
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond ...
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent ...
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds ...
	UnitTypeSeconds UnitType = "seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{UnitTypeBytes, UnitTypeBytesPerSecond, UnitTypeCount, UnitTypeCountPerSecond, UnitTypePercent, UnitTypeSeconds}
}

// VirtualNetworkRuleState enumerates the values for virtual network rule state.
type VirtualNetworkRuleState string

const (
	// VirtualNetworkRuleStateDeleting ...
	VirtualNetworkRuleStateDeleting VirtualNetworkRuleState = "Deleting"
	// VirtualNetworkRuleStateInitializing ...
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = "Initializing"
	// VirtualNetworkRuleStateInProgress ...
	VirtualNetworkRuleStateInProgress VirtualNetworkRuleState = "InProgress"
	// VirtualNetworkRuleStateReady ...
	VirtualNetworkRuleStateReady VirtualNetworkRuleState = "Ready"
	// VirtualNetworkRuleStateUnknown ...
	VirtualNetworkRuleStateUnknown VirtualNetworkRuleState = "Unknown"
)

// PossibleVirtualNetworkRuleStateValues returns an array of possible values for the VirtualNetworkRuleState const type.
func PossibleVirtualNetworkRuleStateValues() []VirtualNetworkRuleState {
	return []VirtualNetworkRuleState{VirtualNetworkRuleStateDeleting, VirtualNetworkRuleStateInitializing, VirtualNetworkRuleStateInProgress, VirtualNetworkRuleStateReady, VirtualNetworkRuleStateUnknown}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// VulnerabilityAssessmentPolicyBaselineNameDefault ...
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
	// VulnerabilityAssessmentPolicyBaselineNameMaster ...
	VulnerabilityAssessmentPolicyBaselineNameMaster VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{VulnerabilityAssessmentPolicyBaselineNameDefault, VulnerabilityAssessmentPolicyBaselineNameMaster}
}

// VulnerabilityAssessmentScanState enumerates the values for vulnerability assessment scan state.
type VulnerabilityAssessmentScanState string

const (
	// VulnerabilityAssessmentScanStateFailed ...
	VulnerabilityAssessmentScanStateFailed VulnerabilityAssessmentScanState = "Failed"
	// VulnerabilityAssessmentScanStateFailedToRun ...
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	// VulnerabilityAssessmentScanStateInProgress ...
	VulnerabilityAssessmentScanStateInProgress VulnerabilityAssessmentScanState = "InProgress"
	// VulnerabilityAssessmentScanStatePassed ...
	VulnerabilityAssessmentScanStatePassed VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns an array of possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{VulnerabilityAssessmentScanStateFailed, VulnerabilityAssessmentScanStateFailedToRun, VulnerabilityAssessmentScanStateInProgress, VulnerabilityAssessmentScanStatePassed}
}

// VulnerabilityAssessmentScanTriggerType enumerates the values for vulnerability assessment scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	// VulnerabilityAssessmentScanTriggerTypeOnDemand ...
	VulnerabilityAssessmentScanTriggerTypeOnDemand VulnerabilityAssessmentScanTriggerType = "OnDemand"
	// VulnerabilityAssessmentScanTriggerTypeRecurring ...
	VulnerabilityAssessmentScanTriggerTypeRecurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns an array of possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{VulnerabilityAssessmentScanTriggerTypeOnDemand, VulnerabilityAssessmentScanTriggerTypeRecurring}
}
