package sqlvirtualmachine

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sqlvirtualmachine/mgmt/2017-03-01-preview/sqlvirtualmachine"

// AdditionalFeaturesServerConfigurations additional SQL Server feature settings.
type AdditionalFeaturesServerConfigurations struct {
	// IsRServicesEnabled - Enable or disable R services (SQL 2016 onwards).
	IsRServicesEnabled *bool `json:"isRServicesEnabled,omitempty"`
}

// AutoBackupSettings configure backups for databases in your SQL virtual machine.
type AutoBackupSettings struct {
	// Enable - Enable or disable autobackup on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`
	// EnableEncryption - Enable or disable encryption for backup on SQL virtual machine.
	EnableEncryption *bool `json:"enableEncryption,omitempty"`
	// RetentionPeriod - Retention period of backup: 1-30 days.
	RetentionPeriod *int32 `json:"retentionPeriod,omitempty"`
	// StorageAccountURL - Storage account url where backup will be taken to.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// StorageAccessKey - Storage account key where backup will be taken to.
	StorageAccessKey *string `json:"storageAccessKey,omitempty"`
	// Password - Password for encryption on backup.
	Password *string `json:"password,omitempty"`
	// BackupSystemDbs - Include or exclude system databases from auto backup.
	BackupSystemDbs *bool `json:"backupSystemDbs,omitempty"`
	// BackupScheduleType - Backup schedule type. Possible values include: 'Manual', 'Automated'
	BackupScheduleType BackupScheduleType `json:"backupScheduleType,omitempty"`
	// FullBackupFrequency - Frequency of full backups. In both cases, full backups begin during the next scheduled time window. Possible values include: 'Daily', 'Weekly'
	FullBackupFrequency FullBackupFrequencyType `json:"fullBackupFrequency,omitempty"`
	// FullBackupStartTime - Start time of a given day during which full backups can take place. 0-23 hours.
	FullBackupStartTime *int32 `json:"fullBackupStartTime,omitempty"`
	// FullBackupWindowHours - Duration of the time window of a given day during which full backups can take place. 1-23 hours.
	FullBackupWindowHours *int32 `json:"fullBackupWindowHours,omitempty"`
	// LogBackupFrequency - Frequency of log backups. 5-60 minutes.
	LogBackupFrequency *int32 `json:"logBackupFrequency,omitempty"`
}

// AutoPatchingSettings set a patching window during which Windows and SQL patches will be applied.
type AutoPatchingSettings struct {
	// Enable - Enable or disable autopatching on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`
	// DayOfWeek - Day of week to apply the patch on. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
	DayOfWeek DayOfWeek `json:"dayOfWeek,omitempty"`
	// MaintenanceWindowStartingHour - Hour of the day when patching is initiated. Local VM time.
	MaintenanceWindowStartingHour *int32 `json:"maintenanceWindowStartingHour,omitempty"`
	// MaintenanceWindowDuration - Duration of patching.
	MaintenanceWindowDuration *int32 `json:"maintenanceWindowDuration,omitempty"`
}

// AvailabilityGroupListener a SQL Server availability group listener.
type AvailabilityGroupListener struct {
	autorest.Response `json:"-"`
	// AvailabilityGroupListenerProperties - Resource properties.
	*AvailabilityGroupListenerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailabilityGroupListener.
func (agl AvailabilityGroupListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agl.AvailabilityGroupListenerProperties != nil {
		objectMap["properties"] = agl.AvailabilityGroupListenerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailabilityGroupListener struct.
func (agl *AvailabilityGroupListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availabilityGroupListenerProperties AvailabilityGroupListenerProperties
				err = json.Unmarshal(*v, &availabilityGroupListenerProperties)
				if err != nil {
					return err
				}
				agl.AvailabilityGroupListenerProperties = &availabilityGroupListenerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agl.Type = &typeVar
			}
		}
	}

	return nil
}

// AvailabilityGroupListenerListResult a list of availability group listeners.
type AvailabilityGroupListenerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]AvailabilityGroupListener `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailabilityGroupListenerListResultIterator provides access to a complete listing of
// AvailabilityGroupListener values.
type AvailabilityGroupListenerListResultIterator struct {
	i    int
	page AvailabilityGroupListenerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailabilityGroupListenerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilityGroupListenerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailabilityGroupListenerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailabilityGroupListenerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailabilityGroupListenerListResultIterator) Response() AvailabilityGroupListenerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailabilityGroupListenerListResultIterator) Value() AvailabilityGroupListener {
	if !iter.page.NotDone() {
		return AvailabilityGroupListener{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailabilityGroupListenerListResultIterator type.
func NewAvailabilityGroupListenerListResultIterator(page AvailabilityGroupListenerListResultPage) AvailabilityGroupListenerListResultIterator {
	return AvailabilityGroupListenerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agllr AvailabilityGroupListenerListResult) IsEmpty() bool {
	return agllr.Value == nil || len(*agllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agllr AvailabilityGroupListenerListResult) hasNextLink() bool {
	return agllr.NextLink != nil && len(*agllr.NextLink) != 0
}

// availabilityGroupListenerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agllr AvailabilityGroupListenerListResult) availabilityGroupListenerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !agllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agllr.NextLink)))
}

// AvailabilityGroupListenerListResultPage contains a page of AvailabilityGroupListener values.
type AvailabilityGroupListenerListResultPage struct {
	fn    func(context.Context, AvailabilityGroupListenerListResult) (AvailabilityGroupListenerListResult, error)
	agllr AvailabilityGroupListenerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailabilityGroupListenerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilityGroupListenerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agllr)
		if err != nil {
			return err
		}
		page.agllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailabilityGroupListenerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailabilityGroupListenerListResultPage) NotDone() bool {
	return !page.agllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailabilityGroupListenerListResultPage) Response() AvailabilityGroupListenerListResult {
	return page.agllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailabilityGroupListenerListResultPage) Values() []AvailabilityGroupListener {
	if page.agllr.IsEmpty() {
		return nil
	}
	return *page.agllr.Value
}

// Creates a new instance of the AvailabilityGroupListenerListResultPage type.
func NewAvailabilityGroupListenerListResultPage(cur AvailabilityGroupListenerListResult, getNextPage func(context.Context, AvailabilityGroupListenerListResult) (AvailabilityGroupListenerListResult, error)) AvailabilityGroupListenerListResultPage {
	return AvailabilityGroupListenerListResultPage{
		fn:    getNextPage,
		agllr: cur,
	}
}

// AvailabilityGroupListenerProperties the properties of an availability group listener.
type AvailabilityGroupListenerProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// AvailabilityGroupName - Name of the availability group.
	AvailabilityGroupName *string `json:"availabilityGroupName,omitempty"`
	// LoadBalancerConfigurations - List of load balancer configurations for an availability group listener.
	LoadBalancerConfigurations *[]LoadBalancerConfiguration `json:"loadBalancerConfigurations,omitempty"`
	// CreateDefaultAvailabilityGroupIfNotExist - Create a default availability group if it does not exist.
	CreateDefaultAvailabilityGroupIfNotExist *bool `json:"createDefaultAvailabilityGroupIfNotExist,omitempty"`
	// Port - Listener port.
	Port *int32 `json:"port,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailabilityGroupListenerProperties.
func (aglp AvailabilityGroupListenerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aglp.AvailabilityGroupName != nil {
		objectMap["availabilityGroupName"] = aglp.AvailabilityGroupName
	}
	if aglp.LoadBalancerConfigurations != nil {
		objectMap["loadBalancerConfigurations"] = aglp.LoadBalancerConfigurations
	}
	if aglp.CreateDefaultAvailabilityGroupIfNotExist != nil {
		objectMap["createDefaultAvailabilityGroupIfNotExist"] = aglp.CreateDefaultAvailabilityGroupIfNotExist
	}
	if aglp.Port != nil {
		objectMap["port"] = aglp.Port
	}
	return json.Marshal(objectMap)
}

// AvailabilityGroupListenersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AvailabilityGroupListenersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AvailabilityGroupListenersClient) (AvailabilityGroupListener, error)
}

// AvailabilityGroupListenersDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AvailabilityGroupListenersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AvailabilityGroupListenersClient) (autorest.Response, error)
}

// Group a SQL virtual machine group.
type Group struct {
	autorest.Response `json:"-"`
	// GroupProperties - Resource properties.
	*GroupProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.GroupProperties != nil {
		objectMap["properties"] = g.GroupProperties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				g.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				g.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		}
	}

	return nil
}

// GroupListResult a list of SQL virtual machine groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Group `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (glr GroupListResult) hasNextLink() bool {
	return glr.NextLink != nil && len(*glr.NextLink) != 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !glr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.glr)
		if err != nil {
			return err
		}
		page.glr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{
		fn:  getNextPage,
		glr: cur,
	}
}

// GroupProperties the properties of a SQL virtual machine group.
type GroupProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SQLImageOffer - SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
	SQLImageOffer *string `json:"sqlImageOffer,omitempty"`
	// SQLImageSku - SQL image sku. Possible values include: 'SQLVMGroupImageSkuDeveloper', 'SQLVMGroupImageSkuEnterprise'
	SQLImageSku SQLVMGroupImageSku `json:"sqlImageSku,omitempty"`
	// ScaleType - READ-ONLY; Scale type. Possible values include: 'HA'
	ScaleType ScaleType `json:"scaleType,omitempty"`
	// ClusterManagerType - READ-ONLY; Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and the OS type. Possible values include: 'WSFC'
	ClusterManagerType ClusterManagerType `json:"clusterManagerType,omitempty"`
	// ClusterConfiguration - READ-ONLY; Cluster type. Possible values include: 'Domainful'
	ClusterConfiguration ClusterConfiguration `json:"clusterConfiguration,omitempty"`
	// WsfcDomainProfile - Cluster Active Directory domain profile.
	WsfcDomainProfile *WsfcDomainProfile `json:"wsfcDomainProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupProperties.
func (gp GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.SQLImageOffer != nil {
		objectMap["sqlImageOffer"] = gp.SQLImageOffer
	}
	if gp.SQLImageSku != "" {
		objectMap["sqlImageSku"] = gp.SQLImageSku
	}
	if gp.WsfcDomainProfile != nil {
		objectMap["wsfcDomainProfile"] = gp.WsfcDomainProfile
	}
	return json.Marshal(objectMap)
}

// GroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (Group, error)
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (autorest.Response, error)
}

// GroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (Group, error)
}

// GroupUpdate an update to a SQL virtual machine group.
type GroupUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GroupUpdate.
func (gu GroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gu.Tags != nil {
		objectMap["tags"] = gu.Tags
	}
	return json.Marshal(objectMap)
}

// KeyVaultCredentialSettings configure your SQL virtual machine to be able to connect to the Azure Key
// Vault service.
type KeyVaultCredentialSettings struct {
	// Enable - Enable or disable key vault credential setting.
	Enable *bool `json:"enable,omitempty"`
	// CredentialName - Credential name.
	CredentialName *string `json:"credentialName,omitempty"`
	// AzureKeyVaultURL - Azure Key Vault url.
	AzureKeyVaultURL *string `json:"azureKeyVaultUrl,omitempty"`
	// ServicePrincipalName - Service principal name to access key vault.
	ServicePrincipalName *string `json:"servicePrincipalName,omitempty"`
	// ServicePrincipalSecret - Service principal name secret to access key vault.
	ServicePrincipalSecret *string `json:"servicePrincipalSecret,omitempty"`
}

// ListResult a list of SQL virtual machines.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLVirtualMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of SQLVirtualMachine values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() SQLVirtualMachine {
	if !iter.page.NotDone() {
		return SQLVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of SQLVirtualMachine values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []SQLVirtualMachine {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// LoadBalancerConfiguration a load balancer configuration for an availability group listener.
type LoadBalancerConfiguration struct {
	// PrivateIPAddress - Private IP address.
	PrivateIPAddress *PrivateIPAddress `json:"privateIpAddress,omitempty"`
	// PublicIPAddressResourceID - Resource id of the public IP.
	PublicIPAddressResourceID *string `json:"publicIpAddressResourceId,omitempty"`
	// LoadBalancerResourceID - Resource id of the load balancer.
	LoadBalancerResourceID *string `json:"loadBalancerResourceId,omitempty"`
	// ProbePort - Probe port.
	ProbePort *int32 `json:"probePort,omitempty"`
	// SQLVirtualMachineInstances - List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
	SQLVirtualMachineInstances *[]string `json:"sqlVirtualMachineInstances,omitempty"`
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'User', 'System'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateIPAddress a private IP address bound to the availability group listener.
type PrivateIPAddress struct {
	// IPAddress - Private IP address bound to the availability group listener.
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetResourceID - Subnet used to include private IP.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
}

// Properties the SQL virtual machine properties.
type Properties struct {
	// VirtualMachineResourceID - ARM Resource id of underlying virtual machine created from SQL marketplace image.
	VirtualMachineResourceID *string `json:"virtualMachineResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SQLImageOffer - SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
	SQLImageOffer *string `json:"sqlImageOffer,omitempty"`
	// SQLServerLicenseType - SQL Server license type. Possible values include: 'PAYG', 'AHUB', 'DR'
	SQLServerLicenseType SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`
	// SQLManagement - SQL Server Management type. Possible values include: 'Full', 'LightWeight', 'NoAgent'
	SQLManagement SQLManagementMode `json:"sqlManagement,omitempty"`
	// SQLImageSku - SQL Server edition type. Possible values include: 'Developer', 'Express', 'Standard', 'Enterprise', 'Web'
	SQLImageSku SQLImageSku `json:"sqlImageSku,omitempty"`
	// SQLVirtualMachineGroupResourceID - ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
	SQLVirtualMachineGroupResourceID *string `json:"sqlVirtualMachineGroupResourceId,omitempty"`
	// WsfcDomainCredentials - Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
	WsfcDomainCredentials *WsfcDomainCredentials `json:"wsfcDomainCredentials,omitempty"`
	// AutoPatchingSettings - Auto patching settings for applying critical security updates to SQL virtual machine.
	AutoPatchingSettings *AutoPatchingSettings `json:"autoPatchingSettings,omitempty"`
	// AutoBackupSettings - Auto backup settings for SQL Server.
	AutoBackupSettings *AutoBackupSettings `json:"autoBackupSettings,omitempty"`
	// KeyVaultCredentialSettings - Key vault credential settings.
	KeyVaultCredentialSettings *KeyVaultCredentialSettings `json:"keyVaultCredentialSettings,omitempty"`
	// ServerConfigurationsManagementSettings - SQL Server configuration management settings.
	ServerConfigurationsManagementSettings *ServerConfigurationsManagementSettings `json:"serverConfigurationsManagementSettings,omitempty"`
	// StorageConfigurationSettings - Storage Configuration Settings.
	StorageConfigurationSettings *StorageConfigurationSettings `json:"storageConfigurationSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.VirtualMachineResourceID != nil {
		objectMap["virtualMachineResourceId"] = p.VirtualMachineResourceID
	}
	if p.SQLImageOffer != nil {
		objectMap["sqlImageOffer"] = p.SQLImageOffer
	}
	if p.SQLServerLicenseType != "" {
		objectMap["sqlServerLicenseType"] = p.SQLServerLicenseType
	}
	if p.SQLManagement != "" {
		objectMap["sqlManagement"] = p.SQLManagement
	}
	if p.SQLImageSku != "" {
		objectMap["sqlImageSku"] = p.SQLImageSku
	}
	if p.SQLVirtualMachineGroupResourceID != nil {
		objectMap["sqlVirtualMachineGroupResourceId"] = p.SQLVirtualMachineGroupResourceID
	}
	if p.WsfcDomainCredentials != nil {
		objectMap["wsfcDomainCredentials"] = p.WsfcDomainCredentials
	}
	if p.AutoPatchingSettings != nil {
		objectMap["autoPatchingSettings"] = p.AutoPatchingSettings
	}
	if p.AutoBackupSettings != nil {
		objectMap["autoBackupSettings"] = p.AutoBackupSettings
	}
	if p.KeyVaultCredentialSettings != nil {
		objectMap["keyVaultCredentialSettings"] = p.KeyVaultCredentialSettings
	}
	if p.ServerConfigurationsManagementSettings != nil {
		objectMap["serverConfigurationsManagementSettings"] = p.ServerConfigurationsManagementSettings
	}
	if p.StorageConfigurationSettings != nil {
		objectMap["storageConfigurationSettings"] = p.StorageConfigurationSettings
	}
	return json.Marshal(objectMap)
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// PrincipalID - READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Type - The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource. Possible values include: 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; The Azure Active Directory tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != "" {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// ServerConfigurationsManagementSettings set the connectivity, storage and workload settings.
type ServerConfigurationsManagementSettings struct {
	// SQLConnectivityUpdateSettings - SQL connectivity type settings.
	SQLConnectivityUpdateSettings *SQLConnectivityUpdateSettings `json:"sqlConnectivityUpdateSettings,omitempty"`
	// SQLWorkloadTypeUpdateSettings - SQL workload type settings.
	SQLWorkloadTypeUpdateSettings *SQLWorkloadTypeUpdateSettings `json:"sqlWorkloadTypeUpdateSettings,omitempty"`
	// SQLStorageUpdateSettings - SQL storage update settings.
	SQLStorageUpdateSettings *SQLStorageUpdateSettings `json:"sqlStorageUpdateSettings,omitempty"`
	// AdditionalFeaturesServerConfigurations - Additional SQL feature settings.
	AdditionalFeaturesServerConfigurations *AdditionalFeaturesServerConfigurations `json:"additionalFeaturesServerConfigurations,omitempty"`
}

// SQLConnectivityUpdateSettings set the access level and network port settings for SQL Server.
type SQLConnectivityUpdateSettings struct {
	// ConnectivityType - SQL Server connectivity option. Possible values include: 'LOCAL', 'PRIVATE', 'PUBLIC'
	ConnectivityType ConnectivityType `json:"connectivityType,omitempty"`
	// Port - SQL Server port.
	Port *int32 `json:"port,omitempty"`
	// SQLAuthUpdateUserName - SQL Server sysadmin login to create.
	SQLAuthUpdateUserName *string `json:"sqlAuthUpdateUserName,omitempty"`
	// SQLAuthUpdatePassword - SQL Server sysadmin login password.
	SQLAuthUpdatePassword *string `json:"sqlAuthUpdatePassword,omitempty"`
}

// SQLStorageSettings set disk storage settings for SQL Server.
type SQLStorageSettings struct {
	// Luns - Logical Unit Numbers for the disks.
	Luns *[]int32 `json:"luns,omitempty"`
	// DefaultFilePath - SQL Server default file path
	DefaultFilePath *string `json:"defaultFilePath,omitempty"`
}

// SQLStorageUpdateSettings set disk storage settings for SQL Server.
type SQLStorageUpdateSettings struct {
	// DiskCount - Virtual machine disk count.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// StartingDeviceID - Device id of the first disk to be updated.
	StartingDeviceID *int32 `json:"startingDeviceId,omitempty"`
	// DiskConfigurationType - Disk configuration to apply to SQL Server. Possible values include: 'NEW', 'EXTEND', 'ADD'
	DiskConfigurationType DiskConfigurationType `json:"diskConfigurationType,omitempty"`
}

// SQLVirtualMachine a SQL virtual machine.
type SQLVirtualMachine struct {
	autorest.Response `json:"-"`
	// Identity - Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Properties - Resource properties.
	*Properties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLVirtualMachine.
func (svm SQLVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svm.Identity != nil {
		objectMap["identity"] = svm.Identity
	}
	if svm.Properties != nil {
		objectMap["properties"] = svm.Properties
	}
	if svm.Location != nil {
		objectMap["location"] = svm.Location
	}
	if svm.Tags != nil {
		objectMap["tags"] = svm.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLVirtualMachine struct.
func (svm *SQLVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				svm.Identity = &identity
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				svm.Properties = &properties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				svm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				svm.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				svm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				svm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				svm.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLVirtualMachinesCreateOrUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLVirtualMachinesCreateOrUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLVirtualMachinesClient) (SQLVirtualMachine, error)
}

// SQLVirtualMachinesDeleteFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLVirtualMachinesDeleteFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLVirtualMachinesClient) (autorest.Response, error)
}

// SQLVirtualMachinesUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLVirtualMachinesUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLVirtualMachinesClient) (SQLVirtualMachine, error)
}

// SQLWorkloadTypeUpdateSettings set workload type to optimize storage for SQL Server.
type SQLWorkloadTypeUpdateSettings struct {
	// SQLWorkloadType - SQL Server workload type. Possible values include: 'GENERAL', 'OLTP', 'DW'
	SQLWorkloadType SQLWorkloadType `json:"sqlWorkloadType,omitempty"`
}

// StorageConfigurationSettings storage Configurations for SQL Data, Log and TempDb.
type StorageConfigurationSettings struct {
	// SQLDataSettings - SQL Server Data Storage Settings.
	SQLDataSettings *SQLStorageSettings `json:"sqlDataSettings,omitempty"`
	// SQLLogSettings - SQL Server Log Storage Settings.
	SQLLogSettings *SQLStorageSettings `json:"sqlLogSettings,omitempty"`
	// SQLTempDbSettings - SQL Server TempDb Storage Settings.
	SQLTempDbSettings *SQLStorageSettings `json:"sqlTempDbSettings,omitempty"`
	// DiskConfigurationType - Disk configuration to apply to SQL Server. Possible values include: 'NEW', 'EXTEND', 'ADD'
	DiskConfigurationType DiskConfigurationType `json:"diskConfigurationType,omitempty"`
	// StorageWorkloadType - Storage workload type. Possible values include: 'StorageWorkloadTypeGENERAL', 'StorageWorkloadTypeOLTP', 'StorageWorkloadTypeDW'
	StorageWorkloadType StorageWorkloadType `json:"storageWorkloadType,omitempty"`
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Update an update to a SQL virtual machine.
type Update struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// WsfcDomainCredentials domain credentials for setting up Windows Server Failover Cluster for SQL
// availability group.
type WsfcDomainCredentials struct {
	// ClusterBootstrapAccountPassword - Cluster bootstrap account password.
	ClusterBootstrapAccountPassword *string `json:"clusterBootstrapAccountPassword,omitempty"`
	// ClusterOperatorAccountPassword - Cluster operator account password.
	ClusterOperatorAccountPassword *string `json:"clusterOperatorAccountPassword,omitempty"`
	// SQLServiceAccountPassword - SQL service account password.
	SQLServiceAccountPassword *string `json:"sqlServiceAccountPassword,omitempty"`
}

// WsfcDomainProfile active Directory account details to operate Windows Server Failover Cluster.
type WsfcDomainProfile struct {
	// DomainFqdn - Fully qualified name of the domain.
	DomainFqdn *string `json:"domainFqdn,omitempty"`
	// OuPath - Organizational Unit path in which the nodes and cluster will be present.
	OuPath *string `json:"ouPath,omitempty"`
	// ClusterBootstrapAccount - Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
	ClusterBootstrapAccount *string `json:"clusterBootstrapAccount,omitempty"`
	// ClusterOperatorAccount - Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
	ClusterOperatorAccount *string `json:"clusterOperatorAccount,omitempty"`
	// SQLServiceAccount - Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
	SQLServiceAccount *string `json:"sqlServiceAccount,omitempty"`
	// FileShareWitnessPath - Optional path for fileshare witness.
	FileShareWitnessPath *string `json:"fileShareWitnessPath,omitempty"`
	// StorageAccountURL - Fully qualified ARM resource id of the witness storage account.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// StorageAccountPrimaryKey - Primary key of the witness storage account.
	StorageAccountPrimaryKey *string `json:"storageAccountPrimaryKey,omitempty"`
}
