package training

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Classifier enumerates the values for classifier.
type Classifier string

const (
	// Multiclass ...
	Multiclass Classifier = "Multiclass"
	// Multilabel ...
	Multilabel Classifier = "Multilabel"
)

// PossibleClassifierValues returns an array of possible values for the Classifier const type.
func PossibleClassifierValues() []Classifier {
	return []Classifier{Multiclass, Multilabel}
}

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Classification ...
	Classification DomainType = "Classification"
	// ObjectDetection ...
	ObjectDetection DomainType = "ObjectDetection"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Classification, ObjectDetection}
}

// ExportFlavorModel enumerates the values for export flavor model.
type ExportFlavorModel string

const (
	// Linux ...
	Linux ExportFlavorModel = "Linux"
	// ONNX10 ...
	ONNX10 ExportFlavorModel = "ONNX10"
	// ONNX12 ...
	ONNX12 ExportFlavorModel = "ONNX12"
	// Windows ...
	Windows ExportFlavorModel = "Windows"
)

// PossibleExportFlavorModelValues returns an array of possible values for the ExportFlavorModel const type.
func PossibleExportFlavorModelValues() []ExportFlavorModel {
	return []ExportFlavorModel{Linux, ONNX10, ONNX12, Windows}
}

// ExportPlatformModel enumerates the values for export platform model.
type ExportPlatformModel string

const (
	// CoreML ...
	CoreML ExportPlatformModel = "CoreML"
	// DockerFile ...
	DockerFile ExportPlatformModel = "DockerFile"
	// ONNX ...
	ONNX ExportPlatformModel = "ONNX"
	// TensorFlow ...
	TensorFlow ExportPlatformModel = "TensorFlow"
)

// PossibleExportPlatformModelValues returns an array of possible values for the ExportPlatformModel const type.
func PossibleExportPlatformModelValues() []ExportPlatformModel {
	return []ExportPlatformModel{CoreML, DockerFile, ONNX, TensorFlow}
}

// ExportStatusModel enumerates the values for export status model.
type ExportStatusModel string

const (
	// Done ...
	Done ExportStatusModel = "Done"
	// Exporting ...
	Exporting ExportStatusModel = "Exporting"
	// Failed ...
	Failed ExportStatusModel = "Failed"
)

// PossibleExportStatusModelValues returns an array of possible values for the ExportStatusModel const type.
func PossibleExportStatusModelValues() []ExportStatusModel {
	return []ExportStatusModel{Done, Exporting, Failed}
}

// ImageCreateStatus enumerates the values for image create status.
type ImageCreateStatus string

const (
	// ErrorImageFormat ...
	ErrorImageFormat ImageCreateStatus = "ErrorImageFormat"
	// ErrorImageSize ...
	ErrorImageSize ImageCreateStatus = "ErrorImageSize"
	// ErrorLimitExceed ...
	ErrorLimitExceed ImageCreateStatus = "ErrorLimitExceed"
	// ErrorNegativeAndRegularTagOnSameImage ...
	ErrorNegativeAndRegularTagOnSameImage ImageCreateStatus = "ErrorNegativeAndRegularTagOnSameImage"
	// ErrorRegionLimitExceed ...
	ErrorRegionLimitExceed ImageCreateStatus = "ErrorRegionLimitExceed"
	// ErrorSource ...
	ErrorSource ImageCreateStatus = "ErrorSource"
	// ErrorStorage ...
	ErrorStorage ImageCreateStatus = "ErrorStorage"
	// ErrorTagLimitExceed ...
	ErrorTagLimitExceed ImageCreateStatus = "ErrorTagLimitExceed"
	// ErrorUnknown ...
	ErrorUnknown ImageCreateStatus = "ErrorUnknown"
	// OK ...
	OK ImageCreateStatus = "OK"
	// OKDuplicate ...
	OKDuplicate ImageCreateStatus = "OKDuplicate"
)

// PossibleImageCreateStatusValues returns an array of possible values for the ImageCreateStatus const type.
func PossibleImageCreateStatusValues() []ImageCreateStatus {
	return []ImageCreateStatus{ErrorImageFormat, ErrorImageSize, ErrorLimitExceed, ErrorNegativeAndRegularTagOnSameImage, ErrorRegionLimitExceed, ErrorSource, ErrorStorage, ErrorTagLimitExceed, ErrorUnknown, OK, OKDuplicate}
}

// OrderBy enumerates the values for order by.
type OrderBy string

const (
	// Newest ...
	Newest OrderBy = "Newest"
	// Oldest ...
	Oldest OrderBy = "Oldest"
	// Suggested ...
	Suggested OrderBy = "Suggested"
)

// PossibleOrderByValues returns an array of possible values for the OrderBy const type.
func PossibleOrderByValues() []OrderBy {
	return []OrderBy{Newest, Oldest, Suggested}
}

// TagType enumerates the values for tag type.
type TagType string

const (
	// Negative ...
	Negative TagType = "Negative"
	// Regular ...
	Regular TagType = "Regular"
)

// PossibleTagTypeValues returns an array of possible values for the TagType const type.
func PossibleTagTypeValues() []TagType {
	return []TagType{Negative, Regular}
}
