package automation

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccountState enumerates the values for account state.
type AccountState string

const (
	// Ok ...
	Ok AccountState = "Ok"
	// Suspended ...
	Suspended AccountState = "Suspended"
	// Unavailable ...
	Unavailable AccountState = "Unavailable"
)

// PossibleAccountStateValues returns an array of possible values for the AccountState const type.
func PossibleAccountStateValues() []AccountState {
	return []AccountState{Ok, Suspended, Unavailable}
}

// AgentRegistrationKeyName enumerates the values for agent registration key name.
type AgentRegistrationKeyName string

const (
	// Primary ...
	Primary AgentRegistrationKeyName = "primary"
	// Secondary ...
	Secondary AgentRegistrationKeyName = "secondary"
)

// PossibleAgentRegistrationKeyNameValues returns an array of possible values for the AgentRegistrationKeyName const type.
func PossibleAgentRegistrationKeyNameValues() []AgentRegistrationKeyName {
	return []AgentRegistrationKeyName{Primary, Secondary}
}

// ContentSourceType enumerates the values for content source type.
type ContentSourceType string

const (
	// EmbeddedContent ...
	EmbeddedContent ContentSourceType = "embeddedContent"
	// URI ...
	URI ContentSourceType = "uri"
)

// PossibleContentSourceTypeValues returns an array of possible values for the ContentSourceType const type.
func PossibleContentSourceTypeValues() []ContentSourceType {
	return []ContentSourceType{EmbeddedContent, URI}
}

// CountType enumerates the values for count type.
type CountType string

const (
	// Nodeconfiguration ...
	Nodeconfiguration CountType = "nodeconfiguration"
	// Status ...
	Status CountType = "status"
)

// PossibleCountTypeValues returns an array of possible values for the CountType const type.
func PossibleCountTypeValues() []CountType {
	return []CountType{Nodeconfiguration, Status}
}

// DscConfigurationProvisioningState enumerates the values for dsc configuration provisioning state.
type DscConfigurationProvisioningState string

const (
	// Succeeded ...
	Succeeded DscConfigurationProvisioningState = "Succeeded"
)

// PossibleDscConfigurationProvisioningStateValues returns an array of possible values for the DscConfigurationProvisioningState const type.
func PossibleDscConfigurationProvisioningStateValues() []DscConfigurationProvisioningState {
	return []DscConfigurationProvisioningState{Succeeded}
}

// DscConfigurationState enumerates the values for dsc configuration state.
type DscConfigurationState string

const (
	// DscConfigurationStateEdit ...
	DscConfigurationStateEdit DscConfigurationState = "Edit"
	// DscConfigurationStateNew ...
	DscConfigurationStateNew DscConfigurationState = "New"
	// DscConfigurationStatePublished ...
	DscConfigurationStatePublished DscConfigurationState = "Published"
)

// PossibleDscConfigurationStateValues returns an array of possible values for the DscConfigurationState const type.
func PossibleDscConfigurationStateValues() []DscConfigurationState {
	return []DscConfigurationState{DscConfigurationStateEdit, DscConfigurationStateNew, DscConfigurationStatePublished}
}

// GroupTypeEnum enumerates the values for group type enum.
type GroupTypeEnum string

const (
	// System ...
	System GroupTypeEnum = "System"
	// User ...
	User GroupTypeEnum = "User"
)

// PossibleGroupTypeEnumValues returns an array of possible values for the GroupTypeEnum const type.
func PossibleGroupTypeEnumValues() []GroupTypeEnum {
	return []GroupTypeEnum{System, User}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous ...
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// Found ...
	Found HTTPStatusCode = "Found"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved ...
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb ...
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod ...
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, Ambiguous, BadGateway, BadRequest, Conflict, Continue, Created, ExpectationFailed, Forbidden, Found, GatewayTimeout, Gone, HTTPVersionNotSupported, InternalServerError, LengthRequired, MethodNotAllowed, Moved, MovedPermanently, MultipleChoices, NoContent, NonAuthoritativeInformation, NotAcceptable, NotFound, NotImplemented, NotModified, OK, PartialContent, PaymentRequired, PreconditionFailed, ProxyAuthenticationRequired, Redirect, RedirectKeepVerb, RedirectMethod, RequestedRangeNotSatisfiable, RequestEntityTooLarge, RequestTimeout, RequestURITooLong, ResetContent, SeeOther, ServiceUnavailable, SwitchingProtocols, TemporaryRedirect, Unauthorized, UnsupportedMediaType, Unused, UpgradeRequired, UseProxy}
}

// JobProvisioningState enumerates the values for job provisioning state.
type JobProvisioningState string

const (
	// JobProvisioningStateFailed ...
	JobProvisioningStateFailed JobProvisioningState = "Failed"
	// JobProvisioningStateProcessing ...
	JobProvisioningStateProcessing JobProvisioningState = "Processing"
	// JobProvisioningStateSucceeded ...
	JobProvisioningStateSucceeded JobProvisioningState = "Succeeded"
	// JobProvisioningStateSuspended ...
	JobProvisioningStateSuspended JobProvisioningState = "Suspended"
)

// PossibleJobProvisioningStateValues returns an array of possible values for the JobProvisioningState const type.
func PossibleJobProvisioningStateValues() []JobProvisioningState {
	return []JobProvisioningState{JobProvisioningStateFailed, JobProvisioningStateProcessing, JobProvisioningStateSucceeded, JobProvisioningStateSuspended}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusActivating ...
	JobStatusActivating JobStatus = "Activating"
	// JobStatusBlocked ...
	JobStatusBlocked JobStatus = "Blocked"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusDisconnected ...
	JobStatusDisconnected JobStatus = "Disconnected"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusNew ...
	JobStatusNew JobStatus = "New"
	// JobStatusRemoving ...
	JobStatusRemoving JobStatus = "Removing"
	// JobStatusResuming ...
	JobStatusResuming JobStatus = "Resuming"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "Running"
	// JobStatusStopped ...
	JobStatusStopped JobStatus = "Stopped"
	// JobStatusStopping ...
	JobStatusStopping JobStatus = "Stopping"
	// JobStatusSuspended ...
	JobStatusSuspended JobStatus = "Suspended"
	// JobStatusSuspending ...
	JobStatusSuspending JobStatus = "Suspending"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusActivating, JobStatusBlocked, JobStatusCompleted, JobStatusDisconnected, JobStatusFailed, JobStatusNew, JobStatusRemoving, JobStatusResuming, JobStatusRunning, JobStatusStopped, JobStatusStopping, JobStatusSuspended, JobStatusSuspending}
}

// JobStreamType enumerates the values for job stream type.
type JobStreamType string

const (
	// Any ...
	Any JobStreamType = "Any"
	// Debug ...
	Debug JobStreamType = "Debug"
	// Error ...
	Error JobStreamType = "Error"
	// Output ...
	Output JobStreamType = "Output"
	// Progress ...
	Progress JobStreamType = "Progress"
	// Verbose ...
	Verbose JobStreamType = "Verbose"
	// Warning ...
	Warning JobStreamType = "Warning"
)

// PossibleJobStreamTypeValues returns an array of possible values for the JobStreamType const type.
func PossibleJobStreamTypeValues() []JobStreamType {
	return []JobStreamType{Any, Debug, Error, Output, Progress, Verbose, Warning}
}

// KeyName enumerates the values for key name.
type KeyName string

const (
	// KeyNamePrimary ...
	KeyNamePrimary KeyName = "Primary"
	// KeyNameSecondary ...
	KeyNameSecondary KeyName = "Secondary"
)

// PossibleKeyNameValues returns an array of possible values for the KeyName const type.
func PossibleKeyNameValues() []KeyName {
	return []KeyName{KeyNamePrimary, KeyNameSecondary}
}

// KeyPermissions enumerates the values for key permissions.
type KeyPermissions string

const (
	// Full ...
	Full KeyPermissions = "Full"
	// Read ...
	Read KeyPermissions = "Read"
)

// PossibleKeyPermissionsValues returns an array of possible values for the KeyPermissions const type.
func PossibleKeyPermissionsValues() []KeyPermissions {
	return []KeyPermissions{Full, Read}
}

// LinuxUpdateClasses enumerates the values for linux update classes.
type LinuxUpdateClasses string

const (
	// Critical ...
	Critical LinuxUpdateClasses = "Critical"
	// Other ...
	Other LinuxUpdateClasses = "Other"
	// Security ...
	Security LinuxUpdateClasses = "Security"
	// Unclassified ...
	Unclassified LinuxUpdateClasses = "Unclassified"
)

// PossibleLinuxUpdateClassesValues returns an array of possible values for the LinuxUpdateClasses const type.
func PossibleLinuxUpdateClassesValues() []LinuxUpdateClasses {
	return []LinuxUpdateClasses{Critical, Other, Security, Unclassified}
}

// ModuleProvisioningState enumerates the values for module provisioning state.
type ModuleProvisioningState string

const (
	// ModuleProvisioningStateActivitiesStored ...
	ModuleProvisioningStateActivitiesStored ModuleProvisioningState = "ActivitiesStored"
	// ModuleProvisioningStateCancelled ...
	ModuleProvisioningStateCancelled ModuleProvisioningState = "Cancelled"
	// ModuleProvisioningStateConnectionTypeImported ...
	ModuleProvisioningStateConnectionTypeImported ModuleProvisioningState = "ConnectionTypeImported"
	// ModuleProvisioningStateContentDownloaded ...
	ModuleProvisioningStateContentDownloaded ModuleProvisioningState = "ContentDownloaded"
	// ModuleProvisioningStateContentRetrieved ...
	ModuleProvisioningStateContentRetrieved ModuleProvisioningState = "ContentRetrieved"
	// ModuleProvisioningStateContentStored ...
	ModuleProvisioningStateContentStored ModuleProvisioningState = "ContentStored"
	// ModuleProvisioningStateContentValidated ...
	ModuleProvisioningStateContentValidated ModuleProvisioningState = "ContentValidated"
	// ModuleProvisioningStateCreated ...
	ModuleProvisioningStateCreated ModuleProvisioningState = "Created"
	// ModuleProvisioningStateCreating ...
	ModuleProvisioningStateCreating ModuleProvisioningState = "Creating"
	// ModuleProvisioningStateFailed ...
	ModuleProvisioningStateFailed ModuleProvisioningState = "Failed"
	// ModuleProvisioningStateModuleDataStored ...
	ModuleProvisioningStateModuleDataStored ModuleProvisioningState = "ModuleDataStored"
	// ModuleProvisioningStateModuleImportRunbookComplete ...
	ModuleProvisioningStateModuleImportRunbookComplete ModuleProvisioningState = "ModuleImportRunbookComplete"
	// ModuleProvisioningStateRunningImportModuleRunbook ...
	ModuleProvisioningStateRunningImportModuleRunbook ModuleProvisioningState = "RunningImportModuleRunbook"
	// ModuleProvisioningStateStartingImportModuleRunbook ...
	ModuleProvisioningStateStartingImportModuleRunbook ModuleProvisioningState = "StartingImportModuleRunbook"
	// ModuleProvisioningStateSucceeded ...
	ModuleProvisioningStateSucceeded ModuleProvisioningState = "Succeeded"
	// ModuleProvisioningStateUpdating ...
	ModuleProvisioningStateUpdating ModuleProvisioningState = "Updating"
)

// PossibleModuleProvisioningStateValues returns an array of possible values for the ModuleProvisioningState const type.
func PossibleModuleProvisioningStateValues() []ModuleProvisioningState {
	return []ModuleProvisioningState{ModuleProvisioningStateActivitiesStored, ModuleProvisioningStateCancelled, ModuleProvisioningStateConnectionTypeImported, ModuleProvisioningStateContentDownloaded, ModuleProvisioningStateContentRetrieved, ModuleProvisioningStateContentStored, ModuleProvisioningStateContentValidated, ModuleProvisioningStateCreated, ModuleProvisioningStateCreating, ModuleProvisioningStateFailed, ModuleProvisioningStateModuleDataStored, ModuleProvisioningStateModuleImportRunbookComplete, ModuleProvisioningStateRunningImportModuleRunbook, ModuleProvisioningStateStartingImportModuleRunbook, ModuleProvisioningStateSucceeded, ModuleProvisioningStateUpdating}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// Linux ...
	Linux OperatingSystemType = "Linux"
	// Windows ...
	Windows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{Linux, Windows}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Completed ...
	Completed ProvisioningState = "Completed"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Running ...
	Running ProvisioningState = "Running"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Completed, Failed, Running}
}

// RunbookProvisioningState enumerates the values for runbook provisioning state.
type RunbookProvisioningState string

const (
	// RunbookProvisioningStateSucceeded ...
	RunbookProvisioningStateSucceeded RunbookProvisioningState = "Succeeded"
)

// PossibleRunbookProvisioningStateValues returns an array of possible values for the RunbookProvisioningState const type.
func PossibleRunbookProvisioningStateValues() []RunbookProvisioningState {
	return []RunbookProvisioningState{RunbookProvisioningStateSucceeded}
}

// RunbookState enumerates the values for runbook state.
type RunbookState string

const (
	// RunbookStateEdit ...
	RunbookStateEdit RunbookState = "Edit"
	// RunbookStateNew ...
	RunbookStateNew RunbookState = "New"
	// RunbookStatePublished ...
	RunbookStatePublished RunbookState = "Published"
)

// PossibleRunbookStateValues returns an array of possible values for the RunbookState const type.
func PossibleRunbookStateValues() []RunbookState {
	return []RunbookState{RunbookStateEdit, RunbookStateNew, RunbookStatePublished}
}

// RunbookTypeEnum enumerates the values for runbook type enum.
type RunbookTypeEnum string

const (
	// Graph ...
	Graph RunbookTypeEnum = "Graph"
	// GraphPowerShell ...
	GraphPowerShell RunbookTypeEnum = "GraphPowerShell"
	// GraphPowerShellWorkflow ...
	GraphPowerShellWorkflow RunbookTypeEnum = "GraphPowerShellWorkflow"
	// PowerShell ...
	PowerShell RunbookTypeEnum = "PowerShell"
	// PowerShellWorkflow ...
	PowerShellWorkflow RunbookTypeEnum = "PowerShellWorkflow"
	// Script ...
	Script RunbookTypeEnum = "Script"
)

// PossibleRunbookTypeEnumValues returns an array of possible values for the RunbookTypeEnum const type.
func PossibleRunbookTypeEnumValues() []RunbookTypeEnum {
	return []RunbookTypeEnum{Graph, GraphPowerShell, GraphPowerShellWorkflow, PowerShell, PowerShellWorkflow, Script}
}

// ScheduleDay enumerates the values for schedule day.
type ScheduleDay string

const (
	// Friday ...
	Friday ScheduleDay = "Friday"
	// Monday ...
	Monday ScheduleDay = "Monday"
	// Saturday ...
	Saturday ScheduleDay = "Saturday"
	// Sunday ...
	Sunday ScheduleDay = "Sunday"
	// Thursday ...
	Thursday ScheduleDay = "Thursday"
	// Tuesday ...
	Tuesday ScheduleDay = "Tuesday"
	// Wednesday ...
	Wednesday ScheduleDay = "Wednesday"
)

// PossibleScheduleDayValues returns an array of possible values for the ScheduleDay const type.
func PossibleScheduleDayValues() []ScheduleDay {
	return []ScheduleDay{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// ScheduleFrequency enumerates the values for schedule frequency.
type ScheduleFrequency string

const (
	// Day ...
	Day ScheduleFrequency = "Day"
	// Hour ...
	Hour ScheduleFrequency = "Hour"
	// Minute The minimum allowed interval for Minute schedules is 15 minutes.
	Minute ScheduleFrequency = "Minute"
	// Month ...
	Month ScheduleFrequency = "Month"
	// OneTime ...
	OneTime ScheduleFrequency = "OneTime"
	// Week ...
	Week ScheduleFrequency = "Week"
)

// PossibleScheduleFrequencyValues returns an array of possible values for the ScheduleFrequency const type.
func PossibleScheduleFrequencyValues() []ScheduleFrequency {
	return []ScheduleFrequency{Day, Hour, Minute, Month, OneTime, Week}
}

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// Basic ...
	Basic SkuNameEnum = "Basic"
	// Free ...
	Free SkuNameEnum = "Free"
)

// PossibleSkuNameEnumValues returns an array of possible values for the SkuNameEnum const type.
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return []SkuNameEnum{Basic, Free}
}

// SourceType enumerates the values for source type.
type SourceType string

const (
	// GitHub ...
	GitHub SourceType = "GitHub"
	// VsoGit ...
	VsoGit SourceType = "VsoGit"
	// VsoTfvc ...
	VsoTfvc SourceType = "VsoTfvc"
)

// PossibleSourceTypeValues returns an array of possible values for the SourceType const type.
func PossibleSourceTypeValues() []SourceType {
	return []SourceType{GitHub, VsoGit, VsoTfvc}
}

// StreamType enumerates the values for stream type.
type StreamType string

const (
	// StreamTypeError ...
	StreamTypeError StreamType = "Error"
	// StreamTypeOutput ...
	StreamTypeOutput StreamType = "Output"
)

// PossibleStreamTypeValues returns an array of possible values for the StreamType const type.
func PossibleStreamTypeValues() []StreamType {
	return []StreamType{StreamTypeError, StreamTypeOutput}
}

// SyncType enumerates the values for sync type.
type SyncType string

const (
	// FullSync ...
	FullSync SyncType = "FullSync"
	// PartialSync ...
	PartialSync SyncType = "PartialSync"
)

// PossibleSyncTypeValues returns an array of possible values for the SyncType const type.
func PossibleSyncTypeValues() []SyncType {
	return []SyncType{FullSync, PartialSync}
}

// TagOperators enumerates the values for tag operators.
type TagOperators string

const (
	// TagOperatorsAll ...
	TagOperatorsAll TagOperators = "All"
	// TagOperatorsAny ...
	TagOperatorsAny TagOperators = "Any"
)

// PossibleTagOperatorsValues returns an array of possible values for the TagOperators const type.
func PossibleTagOperatorsValues() []TagOperators {
	return []TagOperators{TagOperatorsAll, TagOperatorsAny}
}

// TokenType enumerates the values for token type.
type TokenType string

const (
	// Oauth ...
	Oauth TokenType = "Oauth"
	// PersonalAccessToken ...
	PersonalAccessToken TokenType = "PersonalAccessToken"
)

// PossibleTokenTypeValues returns an array of possible values for the TokenType const type.
func PossibleTokenTypeValues() []TokenType {
	return []TokenType{Oauth, PersonalAccessToken}
}

// WindowsUpdateClasses enumerates the values for windows update classes.
type WindowsUpdateClasses string

const (
	// WindowsUpdateClassesCritical ...
	WindowsUpdateClassesCritical WindowsUpdateClasses = "Critical"
	// WindowsUpdateClassesDefinition ...
	WindowsUpdateClassesDefinition WindowsUpdateClasses = "Definition"
	// WindowsUpdateClassesFeaturePack ...
	WindowsUpdateClassesFeaturePack WindowsUpdateClasses = "FeaturePack"
	// WindowsUpdateClassesSecurity ...
	WindowsUpdateClassesSecurity WindowsUpdateClasses = "Security"
	// WindowsUpdateClassesServicePack ...
	WindowsUpdateClassesServicePack WindowsUpdateClasses = "ServicePack"
	// WindowsUpdateClassesTools ...
	WindowsUpdateClassesTools WindowsUpdateClasses = "Tools"
	// WindowsUpdateClassesUnclassified ...
	WindowsUpdateClassesUnclassified WindowsUpdateClasses = "Unclassified"
	// WindowsUpdateClassesUpdateRollup ...
	WindowsUpdateClassesUpdateRollup WindowsUpdateClasses = "UpdateRollup"
	// WindowsUpdateClassesUpdates ...
	WindowsUpdateClassesUpdates WindowsUpdateClasses = "Updates"
)

// PossibleWindowsUpdateClassesValues returns an array of possible values for the WindowsUpdateClasses const type.
func PossibleWindowsUpdateClassesValues() []WindowsUpdateClasses {
	return []WindowsUpdateClasses{WindowsUpdateClassesCritical, WindowsUpdateClassesDefinition, WindowsUpdateClassesFeaturePack, WindowsUpdateClassesSecurity, WindowsUpdateClassesServicePack, WindowsUpdateClassesTools, WindowsUpdateClassesUnclassified, WindowsUpdateClassesUpdateRollup, WindowsUpdateClassesUpdates}
}
