package hardwaresecuritymodulesapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/hardwaresecuritymodules/mgmt/2018-10-31-preview/hardwaresecuritymodules"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result hardwaresecuritymodules.DedicatedHsmOperationListResult, err error)
}

var _ OperationsClientAPI = (*hardwaresecuritymodules.OperationsClient)(nil)

// DedicatedHsmClientAPI contains the set of methods on the DedicatedHsmClient type.
type DedicatedHsmClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, parameters hardwaresecuritymodules.DedicatedHsm) (result hardwaresecuritymodules.DedicatedHsmCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result hardwaresecuritymodules.DedicatedHsmDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result hardwaresecuritymodules.DedicatedHsm, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, top *int32) (result hardwaresecuritymodules.DedicatedHsmListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, top *int32) (result hardwaresecuritymodules.DedicatedHsmListResultIterator, err error)
	ListBySubscription(ctx context.Context, top *int32) (result hardwaresecuritymodules.DedicatedHsmListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context, top *int32) (result hardwaresecuritymodules.DedicatedHsmListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, parameters hardwaresecuritymodules.DedicatedHsmPatchParameters) (result hardwaresecuritymodules.DedicatedHsmUpdateFuture, err error)
}

var _ DedicatedHsmClientAPI = (*hardwaresecuritymodules.DedicatedHsmClient)(nil)
