package servicefabricmesh

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/servicefabricmesh/mgmt/2018-09-01-preview/servicefabricmesh"

// AddRemoveReplicaScalingMechanism describes the horizontal auto scaling mechanism that adds or removes
// replicas (containers or container groups).
type AddRemoveReplicaScalingMechanism struct {
	// MinCount - Minimum number of containers (scale down won't be performed below this number).
	MinCount *int32 `json:"minCount,omitempty"`
	// MaxCount - Maximum number of containers (scale up won't be performed above this number).
	MaxCount *int32 `json:"maxCount,omitempty"`
	// ScaleIncrement - Each time auto scaling is performed, this number of containers will be added or removed.
	ScaleIncrement *int32 `json:"scaleIncrement,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingMechanism', 'KindAddRemoveReplica'
	Kind KindBasicAutoScalingMechanism `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) MarshalJSON() ([]byte, error) {
	arrsm.Kind = KindAddRemoveReplica
	objectMap := make(map[string]interface{})
	if arrsm.MinCount != nil {
		objectMap["minCount"] = arrsm.MinCount
	}
	if arrsm.MaxCount != nil {
		objectMap["maxCount"] = arrsm.MaxCount
	}
	if arrsm.ScaleIncrement != nil {
		objectMap["scaleIncrement"] = arrsm.ScaleIncrement
	}
	if arrsm.Kind != "" {
		objectMap["kind"] = arrsm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAddRemoveReplicaScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool) {
	return &arrsm, true
}

// AsAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsAutoScalingMechanism() (*AutoScalingMechanism, bool) {
	return nil, false
}

// AsBasicAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsBasicAutoScalingMechanism() (BasicAutoScalingMechanism, bool) {
	return &arrsm, true
}

// ApplicationProperties describes properties of a application resource.
type ApplicationProperties struct {
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// Services - Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
	// DebugParams - Internal - used by Visual Studio to setup the debugging session on the local development environment.
	DebugParams *string `json:"debugParams,omitempty"`
	// ServiceNames - READ-ONLY; Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Status - READ-ONLY; Status of the application. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the application.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProperties.
func (ap ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	if ap.Services != nil {
		objectMap["services"] = ap.Services
	}
	if ap.Diagnostics != nil {
		objectMap["diagnostics"] = ap.Diagnostics
	}
	if ap.DebugParams != nil {
		objectMap["debugParams"] = ap.DebugParams
	}
	return json.Marshal(objectMap)
}

// ApplicationResourceDescription this type describes an application resource.
type ApplicationResourceDescription struct {
	autorest.Response `json:"-"`
	// ApplicationResourceProperties - This type describes properties of an application resource.
	*ApplicationResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceDescription.
func (ard ApplicationResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ard.ApplicationResourceProperties != nil {
		objectMap["properties"] = ard.ApplicationResourceProperties
	}
	if ard.Tags != nil {
		objectMap["tags"] = ard.Tags
	}
	if ard.Location != nil {
		objectMap["location"] = ard.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceDescription struct.
func (ard *ApplicationResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationResourceProperties ApplicationResourceProperties
				err = json.Unmarshal(*v, &applicationResourceProperties)
				if err != nil {
					return err
				}
				ard.ApplicationResourceProperties = &applicationResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ard.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ard.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ard.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ard.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ard.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationResourceDescriptionList a pageable list of application resources.
type ApplicationResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ApplicationResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationResourceDescriptionListIterator provides access to a complete listing of
// ApplicationResourceDescription values.
type ApplicationResourceDescriptionListIterator struct {
	i    int
	page ApplicationResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationResourceDescriptionListIterator) Response() ApplicationResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationResourceDescriptionListIterator) Value() ApplicationResourceDescription {
	if !iter.page.NotDone() {
		return ApplicationResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationResourceDescriptionListIterator type.
func NewApplicationResourceDescriptionListIterator(page ApplicationResourceDescriptionListPage) ApplicationResourceDescriptionListIterator {
	return ApplicationResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ardl ApplicationResourceDescriptionList) IsEmpty() bool {
	return ardl.Value == nil || len(*ardl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ardl ApplicationResourceDescriptionList) hasNextLink() bool {
	return ardl.NextLink != nil && len(*ardl.NextLink) != 0
}

// applicationResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ardl ApplicationResourceDescriptionList) applicationResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !ardl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ardl.NextLink)))
}

// ApplicationResourceDescriptionListPage contains a page of ApplicationResourceDescription values.
type ApplicationResourceDescriptionListPage struct {
	fn   func(context.Context, ApplicationResourceDescriptionList) (ApplicationResourceDescriptionList, error)
	ardl ApplicationResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ardl)
		if err != nil {
			return err
		}
		page.ardl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationResourceDescriptionListPage) NotDone() bool {
	return !page.ardl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationResourceDescriptionListPage) Response() ApplicationResourceDescriptionList {
	return page.ardl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationResourceDescriptionListPage) Values() []ApplicationResourceDescription {
	if page.ardl.IsEmpty() {
		return nil
	}
	return *page.ardl.Value
}

// Creates a new instance of the ApplicationResourceDescriptionListPage type.
func NewApplicationResourceDescriptionListPage(cur ApplicationResourceDescriptionList, getNextPage func(context.Context, ApplicationResourceDescriptionList) (ApplicationResourceDescriptionList, error)) ApplicationResourceDescriptionListPage {
	return ApplicationResourceDescriptionListPage{
		fn:   getNextPage,
		ardl: cur,
	}
}

// ApplicationResourceProperties this type describes properties of an application resource.
type ApplicationResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// Services - Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
	// DebugParams - Internal - used by Visual Studio to setup the debugging session on the local development environment.
	DebugParams *string `json:"debugParams,omitempty"`
	// ServiceNames - READ-ONLY; Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Status - READ-ONLY; Status of the application. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the application.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceProperties.
func (arp ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Description != nil {
		objectMap["description"] = arp.Description
	}
	if arp.Services != nil {
		objectMap["services"] = arp.Services
	}
	if arp.Diagnostics != nil {
		objectMap["diagnostics"] = arp.Diagnostics
	}
	if arp.DebugParams != nil {
		objectMap["debugParams"] = arp.DebugParams
	}
	return json.Marshal(objectMap)
}

// ApplicationScopedVolume describes a volume whose lifetime is scoped to the application's lifetime.
type ApplicationScopedVolume struct {
	// CreationParameters - Describes parameters for creating application-scoped volumes.
	CreationParameters BasicApplicationScopedVolumeCreationParameters `json:"creationParameters,omitempty"`
	// Name - Name of the volume being referenced.
	Name *string `json:"name,omitempty"`
	// ReadOnly - The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// DestinationPath - The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string `json:"destinationPath,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApplicationScopedVolume struct.
func (asv *ApplicationScopedVolume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "creationParameters":
			if v != nil {
				creationParameters, err := unmarshalBasicApplicationScopedVolumeCreationParameters(*v)
				if err != nil {
					return err
				}
				asv.CreationParameters = creationParameters
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asv.Name = &name
			}
		case "readOnly":
			if v != nil {
				var readOnly bool
				err = json.Unmarshal(*v, &readOnly)
				if err != nil {
					return err
				}
				asv.ReadOnly = &readOnly
			}
		case "destinationPath":
			if v != nil {
				var destinationPath string
				err = json.Unmarshal(*v, &destinationPath)
				if err != nil {
					return err
				}
				asv.DestinationPath = &destinationPath
			}
		}
	}

	return nil
}

// BasicApplicationScopedVolumeCreationParameters describes parameters for creating application-scoped volumes.
type BasicApplicationScopedVolumeCreationParameters interface {
	AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool)
	AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool)
}

// ApplicationScopedVolumeCreationParameters describes parameters for creating application-scoped volumes.
type ApplicationScopedVolumeCreationParameters struct {
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindApplicationScopedVolumeCreationParameters', 'KindServiceFabricVolumeDisk'
	Kind KindBasicApplicationScopedVolumeCreationParameters `json:"kind,omitempty"`
}

func unmarshalBasicApplicationScopedVolumeCreationParameters(body []byte) (BasicApplicationScopedVolumeCreationParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindServiceFabricVolumeDisk):
		var asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk
		err := json.Unmarshal(body, &asvcpsfvd)
		return asvcpsfvd, err
	default:
		var asvcp ApplicationScopedVolumeCreationParameters
		err := json.Unmarshal(body, &asvcp)
		return asvcp, err
	}
}
func unmarshalBasicApplicationScopedVolumeCreationParametersArray(body []byte) ([]BasicApplicationScopedVolumeCreationParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asvcpArray := make([]BasicApplicationScopedVolumeCreationParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asvcp, err := unmarshalBasicApplicationScopedVolumeCreationParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		asvcpArray[index] = asvcp
	}
	return asvcpArray, nil
}

// MarshalJSON is the custom marshaler for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) MarshalJSON() ([]byte, error) {
	asvcp.Kind = KindApplicationScopedVolumeCreationParameters
	objectMap := make(map[string]interface{})
	if asvcp.Description != nil {
		objectMap["description"] = asvcp.Description
	}
	if asvcp.Kind != "" {
		objectMap["kind"] = asvcp.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool) {
	return nil, false
}

// AsApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool) {
	return &asvcp, true
}

// AsBasicApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsBasicApplicationScopedVolumeCreationParameters() (BasicApplicationScopedVolumeCreationParameters, bool) {
	return &asvcp, true
}

// ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk describes parameters for creating
// application-scoped volumes provided by Service Fabric Volume Disks
type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk struct {
	// SizeDisk - Volume size. Possible values include: 'Small', 'Medium', 'Large'
	SizeDisk SizeTypes `json:"sizeDisk,omitempty"`
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindApplicationScopedVolumeCreationParameters', 'KindServiceFabricVolumeDisk'
	Kind KindBasicApplicationScopedVolumeCreationParameters `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) MarshalJSON() ([]byte, error) {
	asvcpsfvd.Kind = KindServiceFabricVolumeDisk
	objectMap := make(map[string]interface{})
	if asvcpsfvd.SizeDisk != "" {
		objectMap["sizeDisk"] = asvcpsfvd.SizeDisk
	}
	if asvcpsfvd.Description != nil {
		objectMap["description"] = asvcpsfvd.Description
	}
	if asvcpsfvd.Kind != "" {
		objectMap["kind"] = asvcpsfvd.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool) {
	return &asvcpsfvd, true
}

// AsApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool) {
	return nil, false
}

// AsBasicApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsBasicApplicationScopedVolumeCreationParameters() (BasicApplicationScopedVolumeCreationParameters, bool) {
	return &asvcpsfvd, true
}

// BasicAutoScalingMechanism describes the mechanism for performing auto scaling operation. Derived classes will
// describe the actual mechanism.
type BasicAutoScalingMechanism interface {
	AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool)
	AsAutoScalingMechanism() (*AutoScalingMechanism, bool)
}

// AutoScalingMechanism describes the mechanism for performing auto scaling operation. Derived classes will
// describe the actual mechanism.
type AutoScalingMechanism struct {
	// Kind - Possible values include: 'KindAutoScalingMechanism', 'KindAddRemoveReplica'
	Kind KindBasicAutoScalingMechanism `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingMechanism(body []byte) (BasicAutoScalingMechanism, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAddRemoveReplica):
		var arrsm AddRemoveReplicaScalingMechanism
		err := json.Unmarshal(body, &arrsm)
		return arrsm, err
	default:
		var asm AutoScalingMechanism
		err := json.Unmarshal(body, &asm)
		return asm, err
	}
}
func unmarshalBasicAutoScalingMechanismArray(body []byte) ([]BasicAutoScalingMechanism, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asmArray := make([]BasicAutoScalingMechanism, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asm, err := unmarshalBasicAutoScalingMechanism(*rawMessage)
		if err != nil {
			return nil, err
		}
		asmArray[index] = asm
	}
	return asmArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingMechanism.
func (asm AutoScalingMechanism) MarshalJSON() ([]byte, error) {
	asm.Kind = KindAutoScalingMechanism
	objectMap := make(map[string]interface{})
	if asm.Kind != "" {
		objectMap["kind"] = asm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAddRemoveReplicaScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool) {
	return nil, false
}

// AsAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsAutoScalingMechanism() (*AutoScalingMechanism, bool) {
	return &asm, true
}

// AsBasicAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsBasicAutoScalingMechanism() (BasicAutoScalingMechanism, bool) {
	return &asm, true
}

// BasicAutoScalingMetric describes the metric that is used for triggering auto scaling operation. Derived classes will
// describe resources or metrics.
type BasicAutoScalingMetric interface {
	AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool)
	AsAutoScalingMetric() (*AutoScalingMetric, bool)
}

// AutoScalingMetric describes the metric that is used for triggering auto scaling operation. Derived classes
// will describe resources or metrics.
type AutoScalingMetric struct {
	// Kind - Possible values include: 'KindAutoScalingMetric', 'KindResource'
	Kind KindBasicAutoScalingMetric `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingMetric(body []byte) (BasicAutoScalingMetric, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindResource):
		var asrm AutoScalingResourceMetric
		err := json.Unmarshal(body, &asrm)
		return asrm, err
	default:
		var asm AutoScalingMetric
		err := json.Unmarshal(body, &asm)
		return asm, err
	}
}
func unmarshalBasicAutoScalingMetricArray(body []byte) ([]BasicAutoScalingMetric, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asmArray := make([]BasicAutoScalingMetric, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asm, err := unmarshalBasicAutoScalingMetric(*rawMessage)
		if err != nil {
			return nil, err
		}
		asmArray[index] = asm
	}
	return asmArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingMetric.
func (asm AutoScalingMetric) MarshalJSON() ([]byte, error) {
	asm.Kind = KindAutoScalingMetric
	objectMap := make(map[string]interface{})
	if asm.Kind != "" {
		objectMap["kind"] = asm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAutoScalingResourceMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool) {
	return nil, false
}

// AsAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsAutoScalingMetric() (*AutoScalingMetric, bool) {
	return &asm, true
}

// AsBasicAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsBasicAutoScalingMetric() (BasicAutoScalingMetric, bool) {
	return &asm, true
}

// AutoScalingPolicy describes the auto scaling policy
type AutoScalingPolicy struct {
	// Name - The name of the auto scaling policy.
	Name *string `json:"name,omitempty"`
	// Trigger - Determines when auto scaling operation will be invoked.
	Trigger BasicAutoScalingTrigger `json:"trigger,omitempty"`
	// Mechanism - The mechanism that is used to scale when auto scaling operation is invoked.
	Mechanism BasicAutoScalingMechanism `json:"mechanism,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutoScalingPolicy struct.
func (asp *AutoScalingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asp.Name = &name
			}
		case "trigger":
			if v != nil {
				trigger, err := unmarshalBasicAutoScalingTrigger(*v)
				if err != nil {
					return err
				}
				asp.Trigger = trigger
			}
		case "mechanism":
			if v != nil {
				mechanism, err := unmarshalBasicAutoScalingMechanism(*v)
				if err != nil {
					return err
				}
				asp.Mechanism = mechanism
			}
		}
	}

	return nil
}

// AutoScalingResourceMetric describes the resource that is used for triggering auto scaling.
type AutoScalingResourceMetric struct {
	// Name - Name of the resource. Possible values include: 'CPU', 'MemoryInGB'
	Name AutoScalingResourceMetricName `json:"name,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingMetric', 'KindResource'
	Kind KindBasicAutoScalingMetric `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) MarshalJSON() ([]byte, error) {
	asrm.Kind = KindResource
	objectMap := make(map[string]interface{})
	if asrm.Name != "" {
		objectMap["name"] = asrm.Name
	}
	if asrm.Kind != "" {
		objectMap["kind"] = asrm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAutoScalingResourceMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool) {
	return &asrm, true
}

// AsAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsAutoScalingMetric() (*AutoScalingMetric, bool) {
	return nil, false
}

// AsBasicAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsBasicAutoScalingMetric() (BasicAutoScalingMetric, bool) {
	return &asrm, true
}

// BasicAutoScalingTrigger describes the trigger for performing auto scaling operation.
type BasicAutoScalingTrigger interface {
	AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool)
	AsAutoScalingTrigger() (*AutoScalingTrigger, bool)
}

// AutoScalingTrigger describes the trigger for performing auto scaling operation.
type AutoScalingTrigger struct {
	// Kind - Possible values include: 'KindAutoScalingTrigger', 'KindAverageLoad'
	Kind KindBasicAutoScalingTrigger `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingTrigger(body []byte) (BasicAutoScalingTrigger, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAverageLoad):
		var alst AverageLoadScalingTrigger
		err := json.Unmarshal(body, &alst)
		return alst, err
	default:
		var astVar AutoScalingTrigger
		err := json.Unmarshal(body, &astVar)
		return astVar, err
	}
}
func unmarshalBasicAutoScalingTriggerArray(body []byte) ([]BasicAutoScalingTrigger, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	astVarArray := make([]BasicAutoScalingTrigger, len(rawMessages))

	for index, rawMessage := range rawMessages {
		astVar, err := unmarshalBasicAutoScalingTrigger(*rawMessage)
		if err != nil {
			return nil, err
		}
		astVarArray[index] = astVar
	}
	return astVarArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingTrigger.
func (astVar AutoScalingTrigger) MarshalJSON() ([]byte, error) {
	astVar.Kind = KindAutoScalingTrigger
	objectMap := make(map[string]interface{})
	if astVar.Kind != "" {
		objectMap["kind"] = astVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAverageLoadScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool) {
	return nil, false
}

// AsAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsAutoScalingTrigger() (*AutoScalingTrigger, bool) {
	return &astVar, true
}

// AsBasicAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsBasicAutoScalingTrigger() (BasicAutoScalingTrigger, bool) {
	return &astVar, true
}

// AvailableOperationDisplay an operation available at the listed Azure resource provider.
type AvailableOperationDisplay struct {
	// Provider - Name of the operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource on which the operation is available.
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the available operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the available operation.
	Description *string `json:"description,omitempty"`
}

// AverageLoadScalingTrigger describes the average load trigger used for auto scaling.
type AverageLoadScalingTrigger struct {
	// Metric - Description of the metric that is used for scaling.
	Metric BasicAutoScalingMetric `json:"metric,omitempty"`
	// LowerLoadThreshold - Lower load threshold (if average load is below this threshold, service will scale down).
	LowerLoadThreshold *float64 `json:"lowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - Upper load threshold (if average load is above this threshold, service will scale up).
	UpperLoadThreshold *float64 `json:"upperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - Scale interval that indicates how often will this trigger be checked.
	ScaleIntervalInSeconds *int32 `json:"scaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingTrigger', 'KindAverageLoad'
	Kind KindBasicAutoScalingTrigger `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	alst.Kind = KindAverageLoad
	objectMap := make(map[string]interface{})
	objectMap["metric"] = alst.Metric
	if alst.LowerLoadThreshold != nil {
		objectMap["lowerLoadThreshold"] = alst.LowerLoadThreshold
	}
	if alst.UpperLoadThreshold != nil {
		objectMap["upperLoadThreshold"] = alst.UpperLoadThreshold
	}
	if alst.ScaleIntervalInSeconds != nil {
		objectMap["scaleIntervalInSeconds"] = alst.ScaleIntervalInSeconds
	}
	if alst.Kind != "" {
		objectMap["kind"] = alst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAverageLoadScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool) {
	return &alst, true
}

// AsAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsAutoScalingTrigger() (*AutoScalingTrigger, bool) {
	return nil, false
}

// AsBasicAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsBasicAutoScalingTrigger() (BasicAutoScalingTrigger, bool) {
	return &alst, true
}

// UnmarshalJSON is the custom unmarshaler for AverageLoadScalingTrigger struct.
func (alst *AverageLoadScalingTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "metric":
			if v != nil {
				metric, err := unmarshalBasicAutoScalingMetric(*v)
				if err != nil {
					return err
				}
				alst.Metric = metric
			}
		case "lowerLoadThreshold":
			if v != nil {
				var lowerLoadThreshold float64
				err = json.Unmarshal(*v, &lowerLoadThreshold)
				if err != nil {
					return err
				}
				alst.LowerLoadThreshold = &lowerLoadThreshold
			}
		case "upperLoadThreshold":
			if v != nil {
				var upperLoadThreshold float64
				err = json.Unmarshal(*v, &upperLoadThreshold)
				if err != nil {
					return err
				}
				alst.UpperLoadThreshold = &upperLoadThreshold
			}
		case "scaleIntervalInSeconds":
			if v != nil {
				var scaleIntervalInSeconds int32
				err = json.Unmarshal(*v, &scaleIntervalInSeconds)
				if err != nil {
					return err
				}
				alst.ScaleIntervalInSeconds = &scaleIntervalInSeconds
			}
		case "kind":
			if v != nil {
				var kind KindBasicAutoScalingTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				alst.Kind = kind
			}
		}
	}

	return nil
}

// AzureInternalMonitoringPipelineSinkDescription diagnostics settings for Geneva.
type AzureInternalMonitoringPipelineSinkDescription struct {
	// AccountName - Azure Internal monitoring pipeline account.
	AccountName *string `json:"accountName,omitempty"`
	// Namespace - Azure Internal monitoring pipeline account namespace.
	Namespace *string `json:"namespace,omitempty"`
	// MaConfigURL - Azure Internal monitoring agent configuration.
	MaConfigURL *string `json:"maConfigUrl,omitempty"`
	// FluentdConfigURL - Azure Internal monitoring agent fluentd configuration.
	FluentdConfigURL interface{} `json:"fluentdConfigUrl,omitempty"`
	// AutoKeyConfigURL - Azure Internal monitoring pipeline autokey associated with the certificate.
	AutoKeyConfigURL *string `json:"autoKeyConfigUrl,omitempty"`
	// Name - Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string `json:"name,omitempty"`
	// Description - A description of the sink.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindDiagnosticsSinkProperties', 'KindAzureInternalMonitoringPipeline'
	Kind KindBasicDiagnosticsSinkProperties `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) MarshalJSON() ([]byte, error) {
	aimpsd.Kind = KindAzureInternalMonitoringPipeline
	objectMap := make(map[string]interface{})
	if aimpsd.AccountName != nil {
		objectMap["accountName"] = aimpsd.AccountName
	}
	if aimpsd.Namespace != nil {
		objectMap["namespace"] = aimpsd.Namespace
	}
	if aimpsd.MaConfigURL != nil {
		objectMap["maConfigUrl"] = aimpsd.MaConfigURL
	}
	if aimpsd.FluentdConfigURL != nil {
		objectMap["fluentdConfigUrl"] = aimpsd.FluentdConfigURL
	}
	if aimpsd.AutoKeyConfigURL != nil {
		objectMap["autoKeyConfigUrl"] = aimpsd.AutoKeyConfigURL
	}
	if aimpsd.Name != nil {
		objectMap["name"] = aimpsd.Name
	}
	if aimpsd.Description != nil {
		objectMap["description"] = aimpsd.Description
	}
	if aimpsd.Kind != "" {
		objectMap["kind"] = aimpsd.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureInternalMonitoringPipelineSinkDescription is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool) {
	return &aimpsd, true
}

// AsDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool) {
	return nil, false
}

// AsBasicDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsBasicDiagnosticsSinkProperties() (BasicDiagnosticsSinkProperties, bool) {
	return &aimpsd, true
}

// ContainerCodePackageProperties describes a container and its runtime properties.
type ContainerCodePackageProperties struct {
	// Name - The name of the code package.
	Name *string `json:"name,omitempty"`
	// Image - The Container image to use.
	Image *string `json:"image,omitempty"`
	// ImageRegistryCredential - Image registry credential.
	ImageRegistryCredential *ImageRegistryCredential `json:"imageRegistryCredential,omitempty"`
	// Entrypoint - Override for the default entry point in the container.
	Entrypoint *string `json:"entrypoint,omitempty"`
	// Commands - Command array to execute within the container in exec form.
	Commands *[]string `json:"commands,omitempty"`
	// EnvironmentVariables - The environment variables to set in this container
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Settings - The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
	Settings *[]Setting `json:"settings,omitempty"`
	// Labels - The labels to set in this container.
	Labels *[]ContainerLabel `json:"labels,omitempty"`
	// Endpoints - The endpoints exposed by this container.
	Endpoints *[]EndpointProperties `json:"endpoints,omitempty"`
	// Resources - The resources required by this container.
	Resources *ResourceRequirements `json:"resources,omitempty"`
	// VolumeRefs - Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
	VolumeRefs *[]VolumeReference `json:"volumeRefs,omitempty"`
	// Volumes - Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
	Volumes *[]ApplicationScopedVolume `json:"volumes,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
	// ReliableCollectionsRefs - A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
	ReliableCollectionsRefs *[]ReliableCollectionsRef `json:"reliableCollectionsRefs,omitempty"`
	// InstanceView - READ-ONLY; Runtime information of a container instance.
	InstanceView *ContainerInstanceView `json:"instanceView,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerCodePackageProperties.
func (ccpp ContainerCodePackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpp.Name != nil {
		objectMap["name"] = ccpp.Name
	}
	if ccpp.Image != nil {
		objectMap["image"] = ccpp.Image
	}
	if ccpp.ImageRegistryCredential != nil {
		objectMap["imageRegistryCredential"] = ccpp.ImageRegistryCredential
	}
	if ccpp.Entrypoint != nil {
		objectMap["entrypoint"] = ccpp.Entrypoint
	}
	if ccpp.Commands != nil {
		objectMap["commands"] = ccpp.Commands
	}
	if ccpp.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = ccpp.EnvironmentVariables
	}
	if ccpp.Settings != nil {
		objectMap["settings"] = ccpp.Settings
	}
	if ccpp.Labels != nil {
		objectMap["labels"] = ccpp.Labels
	}
	if ccpp.Endpoints != nil {
		objectMap["endpoints"] = ccpp.Endpoints
	}
	if ccpp.Resources != nil {
		objectMap["resources"] = ccpp.Resources
	}
	if ccpp.VolumeRefs != nil {
		objectMap["volumeRefs"] = ccpp.VolumeRefs
	}
	if ccpp.Volumes != nil {
		objectMap["volumes"] = ccpp.Volumes
	}
	if ccpp.Diagnostics != nil {
		objectMap["diagnostics"] = ccpp.Diagnostics
	}
	if ccpp.ReliableCollectionsRefs != nil {
		objectMap["reliableCollectionsRefs"] = ccpp.ReliableCollectionsRefs
	}
	return json.Marshal(objectMap)
}

// ContainerEvent a container event.
type ContainerEvent struct {
	// Name - The name of the container event.
	Name *string `json:"name,omitempty"`
	// Count - The count of the event.
	Count *int32 `json:"count,omitempty"`
	// FirstTimestamp - Date/time of the first event.
	FirstTimestamp *string `json:"firstTimestamp,omitempty"`
	// LastTimestamp - Date/time of the last event.
	LastTimestamp *string `json:"lastTimestamp,omitempty"`
	// Message - The event message
	Message *string `json:"message,omitempty"`
	// Type - The event type.
	Type *string `json:"type,omitempty"`
}

// ContainerInstanceView runtime information of a container instance.
type ContainerInstanceView struct {
	// RestartCount - The number of times the container has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty"`
	// CurrentState - Current container instance state.
	CurrentState *ContainerState `json:"currentState,omitempty"`
	// PreviousState - Previous container instance state.
	PreviousState *ContainerState `json:"previousState,omitempty"`
	// Events - The events of this container instance.
	Events *[]ContainerEvent `json:"events,omitempty"`
}

// ContainerLabel describes a container label.
type ContainerLabel struct {
	// Name - The name of the container label.
	Name *string `json:"name,omitempty"`
	// Value - The value of the container label.
	Value *string `json:"value,omitempty"`
}

// ContainerLogs container logs.
type ContainerLogs struct {
	autorest.Response `json:"-"`
	// Content - Container logs.
	Content *string `json:"content,omitempty"`
}

// ContainerState the container state.
type ContainerState struct {
	// State - The state of this container
	State *string `json:"state,omitempty"`
	// StartTime - Date/time when the container state started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExitCode - The container exit code.
	ExitCode *string `json:"exitCode,omitempty"`
	// FinishTime - Date/time when the container state finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// DetailStatus - Human-readable status of this state.
	DetailStatus *string `json:"detailStatus,omitempty"`
}

// DiagnosticsDescription describes the diagnostics options available
type DiagnosticsDescription struct {
	// Sinks - List of supported sinks that can be referenced.
	Sinks *[]BasicDiagnosticsSinkProperties `json:"sinks,omitempty"`
	// Enabled - Status of whether or not sinks are enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// DefaultSinkRefs - The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
	DefaultSinkRefs *[]string `json:"defaultSinkRefs,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticsDescription struct.
func (dd *DiagnosticsDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sinks":
			if v != nil {
				sinks, err := unmarshalBasicDiagnosticsSinkPropertiesArray(*v)
				if err != nil {
					return err
				}
				dd.Sinks = &sinks
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				dd.Enabled = &enabled
			}
		case "defaultSinkRefs":
			if v != nil {
				var defaultSinkRefs []string
				err = json.Unmarshal(*v, &defaultSinkRefs)
				if err != nil {
					return err
				}
				dd.DefaultSinkRefs = &defaultSinkRefs
			}
		}
	}

	return nil
}

// DiagnosticsRef reference to sinks in DiagnosticsDescription.
type DiagnosticsRef struct {
	// Enabled - Status of whether or not sinks are enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// SinkRefs - List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
	SinkRefs *[]string `json:"sinkRefs,omitempty"`
}

// BasicDiagnosticsSinkProperties properties of a DiagnosticsSink.
type BasicDiagnosticsSinkProperties interface {
	AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool)
	AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool)
}

// DiagnosticsSinkProperties properties of a DiagnosticsSink.
type DiagnosticsSinkProperties struct {
	// Name - Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string `json:"name,omitempty"`
	// Description - A description of the sink.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindDiagnosticsSinkProperties', 'KindAzureInternalMonitoringPipeline'
	Kind KindBasicDiagnosticsSinkProperties `json:"kind,omitempty"`
}

func unmarshalBasicDiagnosticsSinkProperties(body []byte) (BasicDiagnosticsSinkProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAzureInternalMonitoringPipeline):
		var aimpsd AzureInternalMonitoringPipelineSinkDescription
		err := json.Unmarshal(body, &aimpsd)
		return aimpsd, err
	default:
		var dsp DiagnosticsSinkProperties
		err := json.Unmarshal(body, &dsp)
		return dsp, err
	}
}
func unmarshalBasicDiagnosticsSinkPropertiesArray(body []byte) ([]BasicDiagnosticsSinkProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dspArray := make([]BasicDiagnosticsSinkProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsp, err := unmarshalBasicDiagnosticsSinkProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		dspArray[index] = dsp
	}
	return dspArray, nil
}

// MarshalJSON is the custom marshaler for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) MarshalJSON() ([]byte, error) {
	dsp.Kind = KindDiagnosticsSinkProperties
	objectMap := make(map[string]interface{})
	if dsp.Name != nil {
		objectMap["name"] = dsp.Name
	}
	if dsp.Description != nil {
		objectMap["description"] = dsp.Description
	}
	if dsp.Kind != "" {
		objectMap["kind"] = dsp.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureInternalMonitoringPipelineSinkDescription is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool) {
	return nil, false
}

// AsDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool) {
	return &dsp, true
}

// AsBasicDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsBasicDiagnosticsSinkProperties() (BasicDiagnosticsSinkProperties, bool) {
	return &dsp, true
}

// EndpointProperties describes a container endpoint.
type EndpointProperties struct {
	// Name - The name of the endpoint.
	Name *string `json:"name,omitempty"`
	// Port - Port used by the container.
	Port *int32 `json:"port,omitempty"`
}

// EndpointRef describes a reference to a service endpoint.
type EndpointRef struct {
	// Name - Name of the endpoint.
	Name *string `json:"name,omitempty"`
}

// EnvironmentVariable describes an environment variable for the container.
type EnvironmentVariable struct {
	// Name - The name of the environment variable.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// ErrorDetailsModel error model details information
type ErrorDetailsModel struct {
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorErrorModel error model information
type ErrorErrorModel struct {
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message    *string `json:"message,omitempty"`
	InnerError *string `json:"innerError,omitempty"`
	// Details - List of error message details.
	Details *[]ErrorDetailsModel `json:"details,omitempty"`
}

// ErrorModel the error details.
type ErrorModel struct {
	// Error - Error model information
	Error *ErrorErrorModel `json:"error,omitempty"`
}

// GatewayDestination describes destination endpoint for routing traffic.
type GatewayDestination struct {
	// ApplicationName - Name of the service fabric Mesh application.
	ApplicationName *string `json:"applicationName,omitempty"`
	// ServiceName - service that contains the endpoint.
	ServiceName *string `json:"serviceName,omitempty"`
	// EndpointName - name of the endpoint in the service.
	EndpointName *string `json:"endpointName,omitempty"`
}

// GatewayProperties describes properties of a gateway resource.
type GatewayProperties struct {
	// Description - User readable description of the gateway.
	Description *string `json:"description,omitempty"`
	// SourceNetwork - Network the gateway should listen on for requests.
	SourceNetwork *NetworkRef `json:"sourceNetwork,omitempty"`
	// DestinationNetwork - Network that the Application is using.
	DestinationNetwork *NetworkRef `json:"destinationNetwork,omitempty"`
	// TCP - Configuration for tcp connectivity for this gateway.
	TCP *[]TCPConfig `json:"tcp,omitempty"`
	// HTTP - Configuration for http connectivity for this gateway.
	HTTP *[]HTTPConfig `json:"http,omitempty"`
	// Status - READ-ONLY; Status of the resource. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the gateway.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// IPAddress - READ-ONLY; IP address of the gateway. This is populated in the response and is ignored for incoming requests.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayProperties.
func (gp GatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Description != nil {
		objectMap["description"] = gp.Description
	}
	if gp.SourceNetwork != nil {
		objectMap["sourceNetwork"] = gp.SourceNetwork
	}
	if gp.DestinationNetwork != nil {
		objectMap["destinationNetwork"] = gp.DestinationNetwork
	}
	if gp.TCP != nil {
		objectMap["tcp"] = gp.TCP
	}
	if gp.HTTP != nil {
		objectMap["http"] = gp.HTTP
	}
	return json.Marshal(objectMap)
}

// GatewayResourceDescription this type describes a gateway resource.
type GatewayResourceDescription struct {
	autorest.Response `json:"-"`
	// GatewayResourceProperties - This type describes properties of a gateway resource.
	*GatewayResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayResourceDescription.
func (grd GatewayResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grd.GatewayResourceProperties != nil {
		objectMap["properties"] = grd.GatewayResourceProperties
	}
	if grd.Tags != nil {
		objectMap["tags"] = grd.Tags
	}
	if grd.Location != nil {
		objectMap["location"] = grd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GatewayResourceDescription struct.
func (grd *GatewayResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gatewayResourceProperties GatewayResourceProperties
				err = json.Unmarshal(*v, &gatewayResourceProperties)
				if err != nil {
					return err
				}
				grd.GatewayResourceProperties = &gatewayResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				grd.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				grd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				grd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				grd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				grd.Type = &typeVar
			}
		}
	}

	return nil
}

// GatewayResourceDescriptionList a pageable list of gateway resources.
type GatewayResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]GatewayResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// GatewayResourceDescriptionListIterator provides access to a complete listing of
// GatewayResourceDescription values.
type GatewayResourceDescriptionListIterator struct {
	i    int
	page GatewayResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GatewayResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GatewayResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GatewayResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GatewayResourceDescriptionListIterator) Response() GatewayResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GatewayResourceDescriptionListIterator) Value() GatewayResourceDescription {
	if !iter.page.NotDone() {
		return GatewayResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GatewayResourceDescriptionListIterator type.
func NewGatewayResourceDescriptionListIterator(page GatewayResourceDescriptionListPage) GatewayResourceDescriptionListIterator {
	return GatewayResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grdl GatewayResourceDescriptionList) IsEmpty() bool {
	return grdl.Value == nil || len(*grdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grdl GatewayResourceDescriptionList) hasNextLink() bool {
	return grdl.NextLink != nil && len(*grdl.NextLink) != 0
}

// gatewayResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grdl GatewayResourceDescriptionList) gatewayResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !grdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grdl.NextLink)))
}

// GatewayResourceDescriptionListPage contains a page of GatewayResourceDescription values.
type GatewayResourceDescriptionListPage struct {
	fn   func(context.Context, GatewayResourceDescriptionList) (GatewayResourceDescriptionList, error)
	grdl GatewayResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GatewayResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GatewayResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grdl)
		if err != nil {
			return err
		}
		page.grdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GatewayResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GatewayResourceDescriptionListPage) NotDone() bool {
	return !page.grdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GatewayResourceDescriptionListPage) Response() GatewayResourceDescriptionList {
	return page.grdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GatewayResourceDescriptionListPage) Values() []GatewayResourceDescription {
	if page.grdl.IsEmpty() {
		return nil
	}
	return *page.grdl.Value
}

// Creates a new instance of the GatewayResourceDescriptionListPage type.
func NewGatewayResourceDescriptionListPage(cur GatewayResourceDescriptionList, getNextPage func(context.Context, GatewayResourceDescriptionList) (GatewayResourceDescriptionList, error)) GatewayResourceDescriptionListPage {
	return GatewayResourceDescriptionListPage{
		fn:   getNextPage,
		grdl: cur,
	}
}

// GatewayResourceProperties this type describes properties of a gateway resource.
type GatewayResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the gateway.
	Description *string `json:"description,omitempty"`
	// SourceNetwork - Network the gateway should listen on for requests.
	SourceNetwork *NetworkRef `json:"sourceNetwork,omitempty"`
	// DestinationNetwork - Network that the Application is using.
	DestinationNetwork *NetworkRef `json:"destinationNetwork,omitempty"`
	// TCP - Configuration for tcp connectivity for this gateway.
	TCP *[]TCPConfig `json:"tcp,omitempty"`
	// HTTP - Configuration for http connectivity for this gateway.
	HTTP *[]HTTPConfig `json:"http,omitempty"`
	// Status - READ-ONLY; Status of the resource. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the gateway.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// IPAddress - READ-ONLY; IP address of the gateway. This is populated in the response and is ignored for incoming requests.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayResourceProperties.
func (grp GatewayResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grp.Description != nil {
		objectMap["description"] = grp.Description
	}
	if grp.SourceNetwork != nil {
		objectMap["sourceNetwork"] = grp.SourceNetwork
	}
	if grp.DestinationNetwork != nil {
		objectMap["destinationNetwork"] = grp.DestinationNetwork
	}
	if grp.TCP != nil {
		objectMap["tcp"] = grp.TCP
	}
	if grp.HTTP != nil {
		objectMap["http"] = grp.HTTP
	}
	return json.Marshal(objectMap)
}

// HTTPConfig describes the http configuration for external connectivity for this network.
type HTTPConfig struct {
	// Name - http gateway config name.
	Name *string `json:"name,omitempty"`
	// Port - Specifies the port at which the service endpoint below needs to be exposed.
	Port *int32 `json:"port,omitempty"`
	// Hosts - description for routing.
	Hosts *[]HTTPHostConfig `json:"hosts,omitempty"`
}

// HTTPHostConfig describes the hostname properties for http routing.
type HTTPHostConfig struct {
	// Name - http hostname config name.
	Name *string `json:"name,omitempty"`
	// Routes - Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
	Routes *[]HTTPRouteConfig `json:"routes,omitempty"`
}

// HTTPRouteConfig describes the hostname properties for http routing.
type HTTPRouteConfig struct {
	// Name - http route name.
	Name *string `json:"name,omitempty"`
	// Match - Describes a rule for http route matching.
	Match *HTTPRouteMatchRule `json:"match,omitempty"`
	// Destination - Describes destination endpoint for routing traffic.
	Destination *GatewayDestination `json:"destination,omitempty"`
}

// HTTPRouteMatchHeader describes header information for http route matching.
type HTTPRouteMatchHeader struct {
	// Name - Name of header to match in request.
	Name *string `json:"name,omitempty"`
	// Value - Value of header to match in request.
	Value *string `json:"value,omitempty"`
	// Type - how to match header value. Possible values include: 'Exact'
	Type HeaderMatchType `json:"type,omitempty"`
}

// HTTPRouteMatchPath path to match for routing.
type HTTPRouteMatchPath struct {
	// Value - Uri path to match for request.
	Value *string `json:"value,omitempty"`
	// Rewrite - replacement string for matched part of the Uri.
	Rewrite *string `json:"rewrite,omitempty"`
	// Type - how to match value in the Uri
	Type *string `json:"type,omitempty"`
}

// HTTPRouteMatchRule describes a rule for http route matching.
type HTTPRouteMatchRule struct {
	// Path - Path to match for routing.
	Path *HTTPRouteMatchPath `json:"path,omitempty"`
	// Headers - headers and their values to match in request.
	Headers *[]HTTPRouteMatchHeader `json:"headers,omitempty"`
}

// ImageRegistryCredential image registry credential.
type ImageRegistryCredential struct {
	// Server - Docker image registry server, without protocol such as `http` and `https`.
	Server *string `json:"server,omitempty"`
	// Username - The username for the private registry.
	Username *string `json:"username,omitempty"`
	// Password - The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
	Password *string `json:"password,omitempty"`
}

// InlinedValueSecretResourceProperties describes the properties of a secret resource whose value is
// provided explicitly as plaintext. The secret resource may have multiple values, each being uniquely
// versioned. The secret value of each version is stored encrypted, and delivered as plaintext into the
// context of applications referencing it.
type InlinedValueSecretResourceProperties struct {
	// Description - User readable description of the secret.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the resource. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the secret.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ContentType - The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
	ContentType *string `json:"contentType,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Kind - Possible values include: 'KindSecretResourcePropertiesBase', 'KindSecretResourceProperties', 'KindInlinedValue'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) MarshalJSON() ([]byte, error) {
	ivsrp.Kind = KindInlinedValue
	objectMap := make(map[string]interface{})
	if ivsrp.Description != nil {
		objectMap["description"] = ivsrp.Description
	}
	if ivsrp.ContentType != nil {
		objectMap["contentType"] = ivsrp.ContentType
	}
	if ivsrp.Kind != "" {
		objectMap["kind"] = ivsrp.Kind
	}
	return json.Marshal(objectMap)
}

// AsSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) AsSecretResourceProperties() (*SecretResourceProperties, bool) {
	return nil, false
}

// AsBasicSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) AsBasicSecretResourceProperties() (BasicSecretResourceProperties, bool) {
	return &ivsrp, true
}

// AsInlinedValueSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) AsInlinedValueSecretResourceProperties() (*InlinedValueSecretResourceProperties, bool) {
	return &ivsrp, true
}

// AsSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) AsSecretResourcePropertiesBase() (*SecretResourcePropertiesBase, bool) {
	return nil, false
}

// AsBasicSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for InlinedValueSecretResourceProperties.
func (ivsrp InlinedValueSecretResourceProperties) AsBasicSecretResourcePropertiesBase() (BasicSecretResourcePropertiesBase, bool) {
	return &ivsrp, true
}

// LocalNetworkResourceProperties information about a Service Fabric container network local to a single
// Service Fabric cluster.
type LocalNetworkResourceProperties struct {
	// NetworkAddressPrefix - Address space for the local container network.
	NetworkAddressPrefix *string `json:"networkAddressPrefix,omitempty"`
	// Description - User readable description of the network.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the network. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the network.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Kind - Possible values include: 'KindNetworkResourcePropertiesBase', 'KindNetworkResourceProperties', 'KindLocal'
	Kind KindBasicNetworkResourcePropertiesBase `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) MarshalJSON() ([]byte, error) {
	lnrp.Kind = KindLocal
	objectMap := make(map[string]interface{})
	if lnrp.NetworkAddressPrefix != nil {
		objectMap["networkAddressPrefix"] = lnrp.NetworkAddressPrefix
	}
	if lnrp.Description != nil {
		objectMap["description"] = lnrp.Description
	}
	if lnrp.Kind != "" {
		objectMap["kind"] = lnrp.Kind
	}
	return json.Marshal(objectMap)
}

// AsNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) AsNetworkResourceProperties() (*NetworkResourceProperties, bool) {
	return nil, false
}

// AsBasicNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) AsBasicNetworkResourceProperties() (BasicNetworkResourceProperties, bool) {
	return &lnrp, true
}

// AsLocalNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) AsLocalNetworkResourceProperties() (*LocalNetworkResourceProperties, bool) {
	return &lnrp, true
}

// AsNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) AsNetworkResourcePropertiesBase() (*NetworkResourcePropertiesBase, bool) {
	return nil, false
}

// AsBasicNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for LocalNetworkResourceProperties.
func (lnrp LocalNetworkResourceProperties) AsBasicNetworkResourcePropertiesBase() (BasicNetworkResourcePropertiesBase, bool) {
	return &lnrp, true
}

// ManagedProxyResource the resource model definition for Azure Resource Manager proxy resource. It will
// have everything other than required location and tags. This proxy resource is explicitly created or
// updated by including it in the parent resource.
type ManagedProxyResource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedProxyResource.
func (mpr ManagedProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpr.Name != nil {
		objectMap["name"] = mpr.Name
	}
	return json.Marshal(objectMap)
}

// NetworkRef describes a network reference in a service.
type NetworkRef struct {
	// Name - Name of the network
	Name *string `json:"name,omitempty"`
	// EndpointRefs - A list of endpoints that are exposed on this network.
	EndpointRefs *[]EndpointRef `json:"endpointRefs,omitempty"`
}

// NetworkResourceDescription this type describes a network resource.
type NetworkResourceDescription struct {
	autorest.Response `json:"-"`
	// Properties - Describes properties of a network resource.
	Properties BasicNetworkResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkResourceDescription.
func (nrd NetworkResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = nrd.Properties
	if nrd.Tags != nil {
		objectMap["tags"] = nrd.Tags
	}
	if nrd.Location != nil {
		objectMap["location"] = nrd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkResourceDescription struct.
func (nrd *NetworkResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicNetworkResourceProperties(*v)
				if err != nil {
					return err
				}
				nrd.Properties = properties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nrd.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nrd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nrd.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkResourceDescriptionList a pageable list of network resources.
type NetworkResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]NetworkResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkResourceDescriptionListIterator provides access to a complete listing of
// NetworkResourceDescription values.
type NetworkResourceDescriptionListIterator struct {
	i    int
	page NetworkResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkResourceDescriptionListIterator) Response() NetworkResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkResourceDescriptionListIterator) Value() NetworkResourceDescription {
	if !iter.page.NotDone() {
		return NetworkResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkResourceDescriptionListIterator type.
func NewNetworkResourceDescriptionListIterator(page NetworkResourceDescriptionListPage) NetworkResourceDescriptionListIterator {
	return NetworkResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nrdl NetworkResourceDescriptionList) IsEmpty() bool {
	return nrdl.Value == nil || len(*nrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nrdl NetworkResourceDescriptionList) hasNextLink() bool {
	return nrdl.NextLink != nil && len(*nrdl.NextLink) != 0
}

// networkResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nrdl NetworkResourceDescriptionList) networkResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !nrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nrdl.NextLink)))
}

// NetworkResourceDescriptionListPage contains a page of NetworkResourceDescription values.
type NetworkResourceDescriptionListPage struct {
	fn   func(context.Context, NetworkResourceDescriptionList) (NetworkResourceDescriptionList, error)
	nrdl NetworkResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nrdl)
		if err != nil {
			return err
		}
		page.nrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkResourceDescriptionListPage) NotDone() bool {
	return !page.nrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkResourceDescriptionListPage) Response() NetworkResourceDescriptionList {
	return page.nrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkResourceDescriptionListPage) Values() []NetworkResourceDescription {
	if page.nrdl.IsEmpty() {
		return nil
	}
	return *page.nrdl.Value
}

// Creates a new instance of the NetworkResourceDescriptionListPage type.
func NewNetworkResourceDescriptionListPage(cur NetworkResourceDescriptionList, getNextPage func(context.Context, NetworkResourceDescriptionList) (NetworkResourceDescriptionList, error)) NetworkResourceDescriptionListPage {
	return NetworkResourceDescriptionListPage{
		fn:   getNextPage,
		nrdl: cur,
	}
}

// BasicNetworkResourceProperties describes properties of a network resource.
type BasicNetworkResourceProperties interface {
	AsLocalNetworkResourceProperties() (*LocalNetworkResourceProperties, bool)
	AsNetworkResourceProperties() (*NetworkResourceProperties, bool)
}

// NetworkResourceProperties describes properties of a network resource.
type NetworkResourceProperties struct {
	// Description - User readable description of the network.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the network. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the network.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// Kind - Possible values include: 'KindNetworkResourcePropertiesBase', 'KindNetworkResourceProperties', 'KindLocal'
	Kind KindBasicNetworkResourcePropertiesBase `json:"kind,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

func unmarshalBasicNetworkResourceProperties(body []byte) (BasicNetworkResourceProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindLocal):
		var lnrp LocalNetworkResourceProperties
		err := json.Unmarshal(body, &lnrp)
		return lnrp, err
	default:
		var nrp NetworkResourceProperties
		err := json.Unmarshal(body, &nrp)
		return nrp, err
	}
}
func unmarshalBasicNetworkResourcePropertiesArray(body []byte) ([]BasicNetworkResourceProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nrpArray := make([]BasicNetworkResourceProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nrp, err := unmarshalBasicNetworkResourceProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		nrpArray[index] = nrp
	}
	return nrpArray, nil
}

// MarshalJSON is the custom marshaler for NetworkResourceProperties.
func (nrp NetworkResourceProperties) MarshalJSON() ([]byte, error) {
	nrp.Kind = KindNetworkResourceProperties
	objectMap := make(map[string]interface{})
	if nrp.Description != nil {
		objectMap["description"] = nrp.Description
	}
	if nrp.Kind != "" {
		objectMap["kind"] = nrp.Kind
	}
	return json.Marshal(objectMap)
}

// AsNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourceProperties.
func (nrp NetworkResourceProperties) AsNetworkResourceProperties() (*NetworkResourceProperties, bool) {
	return &nrp, true
}

// AsBasicNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourceProperties.
func (nrp NetworkResourceProperties) AsBasicNetworkResourceProperties() (BasicNetworkResourceProperties, bool) {
	return &nrp, true
}

// AsLocalNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourceProperties.
func (nrp NetworkResourceProperties) AsLocalNetworkResourceProperties() (*LocalNetworkResourceProperties, bool) {
	return nil, false
}

// AsNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for NetworkResourceProperties.
func (nrp NetworkResourceProperties) AsNetworkResourcePropertiesBase() (*NetworkResourcePropertiesBase, bool) {
	return nil, false
}

// AsBasicNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for NetworkResourceProperties.
func (nrp NetworkResourceProperties) AsBasicNetworkResourcePropertiesBase() (BasicNetworkResourcePropertiesBase, bool) {
	return &nrp, true
}

// BasicNetworkResourcePropertiesBase this type describes the properties of a network resource, including its kind.
type BasicNetworkResourcePropertiesBase interface {
	AsNetworkResourceProperties() (*NetworkResourceProperties, bool)
	AsBasicNetworkResourceProperties() (BasicNetworkResourceProperties, bool)
	AsLocalNetworkResourceProperties() (*LocalNetworkResourceProperties, bool)
	AsNetworkResourcePropertiesBase() (*NetworkResourcePropertiesBase, bool)
}

// NetworkResourcePropertiesBase this type describes the properties of a network resource, including its kind.
type NetworkResourcePropertiesBase struct {
	// Kind - Possible values include: 'KindNetworkResourcePropertiesBase', 'KindNetworkResourceProperties', 'KindLocal'
	Kind KindBasicNetworkResourcePropertiesBase `json:"kind,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

func unmarshalBasicNetworkResourcePropertiesBase(body []byte) (BasicNetworkResourcePropertiesBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindNetworkResourceProperties):
		var nrp NetworkResourceProperties
		err := json.Unmarshal(body, &nrp)
		return nrp, err
	case string(KindLocal):
		var lnrp LocalNetworkResourceProperties
		err := json.Unmarshal(body, &lnrp)
		return lnrp, err
	default:
		var nrpb NetworkResourcePropertiesBase
		err := json.Unmarshal(body, &nrpb)
		return nrpb, err
	}
}
func unmarshalBasicNetworkResourcePropertiesBaseArray(body []byte) ([]BasicNetworkResourcePropertiesBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nrpbArray := make([]BasicNetworkResourcePropertiesBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nrpb, err := unmarshalBasicNetworkResourcePropertiesBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		nrpbArray[index] = nrpb
	}
	return nrpbArray, nil
}

// MarshalJSON is the custom marshaler for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	nrpb.Kind = KindNetworkResourcePropertiesBase
	objectMap := make(map[string]interface{})
	if nrpb.Kind != "" {
		objectMap["kind"] = nrpb.Kind
	}
	return json.Marshal(objectMap)
}

// AsNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) AsNetworkResourceProperties() (*NetworkResourceProperties, bool) {
	return nil, false
}

// AsBasicNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) AsBasicNetworkResourceProperties() (BasicNetworkResourceProperties, bool) {
	return nil, false
}

// AsLocalNetworkResourceProperties is the BasicNetworkResourcePropertiesBase implementation for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) AsLocalNetworkResourceProperties() (*LocalNetworkResourceProperties, bool) {
	return nil, false
}

// AsNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) AsNetworkResourcePropertiesBase() (*NetworkResourcePropertiesBase, bool) {
	return &nrpb, true
}

// AsBasicNetworkResourcePropertiesBase is the BasicNetworkResourcePropertiesBase implementation for NetworkResourcePropertiesBase.
func (nrpb NetworkResourcePropertiesBase) AsBasicNetworkResourcePropertiesBase() (BasicNetworkResourcePropertiesBase, bool) {
	return &nrpb, true
}

// OperationListResult describes the result of the request to list Service Fabric operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Service Fabric operations supported by the Microsoft.ServiceFabric resource provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.Value != nil {
		objectMap["value"] = olr.Value
	}
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult list of operations available at the listed Azure resource provider.
type OperationResult struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// Origin - Origin result
	Origin *string `json:"origin,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProvisionedResourceProperties describes common properties of a provisioned resource.
type ProvisionedResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProxyResource the resource model definition for Azure Resource Manager proxy resource. It will have
// everything other than required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// ReliableCollectionsRef specifying this parameter adds support for reliable collections
type ReliableCollectionsRef struct {
	// Name - Name of ReliableCollection resource. Right now it's not used and you can use any string.
	Name *string `json:"name,omitempty"`
	// DoNotPersistState - False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
	DoNotPersistState *bool `json:"doNotPersistState,omitempty"`
}

// Resource the resource model definition for Azure Resource Manager resource.
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// ResourceLimits this type describes the resource limits for a given container. It describes the most
// amount of resources a container is allowed to use before being restarted.
type ResourceLimits struct {
	// MemoryInGB - The memory limit in GB.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - CPU limits in cores. At present, only full cores are supported.
	CPU *float64 `json:"cpu,omitempty"`
}

// ResourceRequests this type describes the requested resources for a given container. It describes the
// least amount of resources required for the container. A container can consume more than requested
// resources up to the specified limits before being restarted. Currently, the requested resources are
// treated as limits.
type ResourceRequests struct {
	// MemoryInGB - The memory request in GB for this container.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - Requested number of CPU cores. At present, only full cores are supported.
	CPU *float64 `json:"cpu,omitempty"`
}

// ResourceRequirements this type describes the resource requirements for a container or a service.
type ResourceRequirements struct {
	// Requests - Describes the requested resources for a given container.
	Requests *ResourceRequests `json:"requests,omitempty"`
	// Limits - Describes the maximum limits on the resources for a given container.
	Limits *ResourceLimits `json:"limits,omitempty"`
}

// SecretResourceDescription this type describes a secret resource.
type SecretResourceDescription struct {
	autorest.Response `json:"-"`
	// Properties - Describes the properties of a secret resource.
	Properties BasicSecretResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretResourceDescription.
func (srd SecretResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = srd.Properties
	if srd.Tags != nil {
		objectMap["tags"] = srd.Tags
	}
	if srd.Location != nil {
		objectMap["location"] = srd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecretResourceDescription struct.
func (srd *SecretResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicSecretResourceProperties(*v)
				if err != nil {
					return err
				}
				srd.Properties = properties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				srd.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				srd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srd.Type = &typeVar
			}
		}
	}

	return nil
}

// SecretResourceDescriptionList a pageable list of secret resources.
type SecretResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]SecretResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretResourceDescriptionListIterator provides access to a complete listing of SecretResourceDescription
// values.
type SecretResourceDescriptionListIterator struct {
	i    int
	page SecretResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretResourceDescriptionListIterator) Response() SecretResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretResourceDescriptionListIterator) Value() SecretResourceDescription {
	if !iter.page.NotDone() {
		return SecretResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretResourceDescriptionListIterator type.
func NewSecretResourceDescriptionListIterator(page SecretResourceDescriptionListPage) SecretResourceDescriptionListIterator {
	return SecretResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srdl SecretResourceDescriptionList) IsEmpty() bool {
	return srdl.Value == nil || len(*srdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srdl SecretResourceDescriptionList) hasNextLink() bool {
	return srdl.NextLink != nil && len(*srdl.NextLink) != 0
}

// secretResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srdl SecretResourceDescriptionList) secretResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !srdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srdl.NextLink)))
}

// SecretResourceDescriptionListPage contains a page of SecretResourceDescription values.
type SecretResourceDescriptionListPage struct {
	fn   func(context.Context, SecretResourceDescriptionList) (SecretResourceDescriptionList, error)
	srdl SecretResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srdl)
		if err != nil {
			return err
		}
		page.srdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretResourceDescriptionListPage) NotDone() bool {
	return !page.srdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretResourceDescriptionListPage) Response() SecretResourceDescriptionList {
	return page.srdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretResourceDescriptionListPage) Values() []SecretResourceDescription {
	if page.srdl.IsEmpty() {
		return nil
	}
	return *page.srdl.Value
}

// Creates a new instance of the SecretResourceDescriptionListPage type.
func NewSecretResourceDescriptionListPage(cur SecretResourceDescriptionList, getNextPage func(context.Context, SecretResourceDescriptionList) (SecretResourceDescriptionList, error)) SecretResourceDescriptionListPage {
	return SecretResourceDescriptionListPage{
		fn:   getNextPage,
		srdl: cur,
	}
}

// BasicSecretResourceProperties describes the properties of a secret resource.
type BasicSecretResourceProperties interface {
	AsInlinedValueSecretResourceProperties() (*InlinedValueSecretResourceProperties, bool)
	AsSecretResourceProperties() (*SecretResourceProperties, bool)
}

// SecretResourceProperties describes the properties of a secret resource.
type SecretResourceProperties struct {
	// Description - User readable description of the secret.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the resource. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the secret.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ContentType - The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
	ContentType *string `json:"contentType,omitempty"`
	// Kind - Possible values include: 'KindSecretResourcePropertiesBase', 'KindSecretResourceProperties', 'KindInlinedValue'
	Kind Kind `json:"kind,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

func unmarshalBasicSecretResourceProperties(body []byte) (BasicSecretResourceProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindInlinedValue):
		var ivsrp InlinedValueSecretResourceProperties
		err := json.Unmarshal(body, &ivsrp)
		return ivsrp, err
	default:
		var srp SecretResourceProperties
		err := json.Unmarshal(body, &srp)
		return srp, err
	}
}
func unmarshalBasicSecretResourcePropertiesArray(body []byte) ([]BasicSecretResourceProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srpArray := make([]BasicSecretResourceProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srp, err := unmarshalBasicSecretResourceProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		srpArray[index] = srp
	}
	return srpArray, nil
}

// MarshalJSON is the custom marshaler for SecretResourceProperties.
func (srp SecretResourceProperties) MarshalJSON() ([]byte, error) {
	srp.Kind = KindSecretResourceProperties
	objectMap := make(map[string]interface{})
	if srp.Description != nil {
		objectMap["description"] = srp.Description
	}
	if srp.ContentType != nil {
		objectMap["contentType"] = srp.ContentType
	}
	if srp.Kind != "" {
		objectMap["kind"] = srp.Kind
	}
	return json.Marshal(objectMap)
}

// AsSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourceProperties.
func (srp SecretResourceProperties) AsSecretResourceProperties() (*SecretResourceProperties, bool) {
	return &srp, true
}

// AsBasicSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourceProperties.
func (srp SecretResourceProperties) AsBasicSecretResourceProperties() (BasicSecretResourceProperties, bool) {
	return &srp, true
}

// AsInlinedValueSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourceProperties.
func (srp SecretResourceProperties) AsInlinedValueSecretResourceProperties() (*InlinedValueSecretResourceProperties, bool) {
	return nil, false
}

// AsSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for SecretResourceProperties.
func (srp SecretResourceProperties) AsSecretResourcePropertiesBase() (*SecretResourcePropertiesBase, bool) {
	return nil, false
}

// AsBasicSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for SecretResourceProperties.
func (srp SecretResourceProperties) AsBasicSecretResourcePropertiesBase() (BasicSecretResourcePropertiesBase, bool) {
	return &srp, true
}

// BasicSecretResourcePropertiesBase this type describes the properties of a secret resource, including its kind.
type BasicSecretResourcePropertiesBase interface {
	AsSecretResourceProperties() (*SecretResourceProperties, bool)
	AsBasicSecretResourceProperties() (BasicSecretResourceProperties, bool)
	AsInlinedValueSecretResourceProperties() (*InlinedValueSecretResourceProperties, bool)
	AsSecretResourcePropertiesBase() (*SecretResourcePropertiesBase, bool)
}

// SecretResourcePropertiesBase this type describes the properties of a secret resource, including its kind.
type SecretResourcePropertiesBase struct {
	// Kind - Possible values include: 'KindSecretResourcePropertiesBase', 'KindSecretResourceProperties', 'KindInlinedValue'
	Kind Kind `json:"kind,omitempty"`
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

func unmarshalBasicSecretResourcePropertiesBase(body []byte) (BasicSecretResourcePropertiesBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindSecretResourceProperties):
		var srp SecretResourceProperties
		err := json.Unmarshal(body, &srp)
		return srp, err
	case string(KindInlinedValue):
		var ivsrp InlinedValueSecretResourceProperties
		err := json.Unmarshal(body, &ivsrp)
		return ivsrp, err
	default:
		var srpb SecretResourcePropertiesBase
		err := json.Unmarshal(body, &srpb)
		return srpb, err
	}
}
func unmarshalBasicSecretResourcePropertiesBaseArray(body []byte) ([]BasicSecretResourcePropertiesBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srpbArray := make([]BasicSecretResourcePropertiesBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srpb, err := unmarshalBasicSecretResourcePropertiesBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		srpbArray[index] = srpb
	}
	return srpbArray, nil
}

// MarshalJSON is the custom marshaler for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	srpb.Kind = KindSecretResourcePropertiesBase
	objectMap := make(map[string]interface{})
	if srpb.Kind != "" {
		objectMap["kind"] = srpb.Kind
	}
	return json.Marshal(objectMap)
}

// AsSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) AsSecretResourceProperties() (*SecretResourceProperties, bool) {
	return nil, false
}

// AsBasicSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) AsBasicSecretResourceProperties() (BasicSecretResourceProperties, bool) {
	return nil, false
}

// AsInlinedValueSecretResourceProperties is the BasicSecretResourcePropertiesBase implementation for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) AsInlinedValueSecretResourceProperties() (*InlinedValueSecretResourceProperties, bool) {
	return nil, false
}

// AsSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) AsSecretResourcePropertiesBase() (*SecretResourcePropertiesBase, bool) {
	return &srpb, true
}

// AsBasicSecretResourcePropertiesBase is the BasicSecretResourcePropertiesBase implementation for SecretResourcePropertiesBase.
func (srpb SecretResourcePropertiesBase) AsBasicSecretResourcePropertiesBase() (BasicSecretResourcePropertiesBase, bool) {
	return &srpb, true
}

// SecretValue this type represents the unencrypted value of the secret.
type SecretValue struct {
	autorest.Response `json:"-"`
	// Value - The actual value of the secret.
	Value *string `json:"value,omitempty"`
}

// SecretValueProperties this type describes properties of secret value resource.
type SecretValueProperties struct {
	// Value - The actual value of the secret.
	Value *string `json:"value,omitempty"`
}

// SecretValueResourceDescription this type describes a value of a secret resource. The name of this
// resource is the version identifier corresponding to this secret value.
type SecretValueResourceDescription struct {
	autorest.Response `json:"-"`
	// SecretValueResourceProperties - This type describes properties of a secret value resource.
	*SecretValueResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretValueResourceDescription.
func (svrd SecretValueResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svrd.SecretValueResourceProperties != nil {
		objectMap["properties"] = svrd.SecretValueResourceProperties
	}
	if svrd.Tags != nil {
		objectMap["tags"] = svrd.Tags
	}
	if svrd.Location != nil {
		objectMap["location"] = svrd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecretValueResourceDescription struct.
func (svrd *SecretValueResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secretValueResourceProperties SecretValueResourceProperties
				err = json.Unmarshal(*v, &secretValueResourceProperties)
				if err != nil {
					return err
				}
				svrd.SecretValueResourceProperties = &secretValueResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				svrd.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				svrd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				svrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				svrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				svrd.Type = &typeVar
			}
		}
	}

	return nil
}

// SecretValueResourceDescriptionList a pageable list of values of a secret resource. The information does
// not include only the name of the value and not the actual unencrypted value.
type SecretValueResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]SecretValueResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretValueResourceDescriptionListIterator provides access to a complete listing of
// SecretValueResourceDescription values.
type SecretValueResourceDescriptionListIterator struct {
	i    int
	page SecretValueResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretValueResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretValueResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretValueResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretValueResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretValueResourceDescriptionListIterator) Response() SecretValueResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretValueResourceDescriptionListIterator) Value() SecretValueResourceDescription {
	if !iter.page.NotDone() {
		return SecretValueResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretValueResourceDescriptionListIterator type.
func NewSecretValueResourceDescriptionListIterator(page SecretValueResourceDescriptionListPage) SecretValueResourceDescriptionListIterator {
	return SecretValueResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (svrdl SecretValueResourceDescriptionList) IsEmpty() bool {
	return svrdl.Value == nil || len(*svrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (svrdl SecretValueResourceDescriptionList) hasNextLink() bool {
	return svrdl.NextLink != nil && len(*svrdl.NextLink) != 0
}

// secretValueResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (svrdl SecretValueResourceDescriptionList) secretValueResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !svrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(svrdl.NextLink)))
}

// SecretValueResourceDescriptionListPage contains a page of SecretValueResourceDescription values.
type SecretValueResourceDescriptionListPage struct {
	fn    func(context.Context, SecretValueResourceDescriptionList) (SecretValueResourceDescriptionList, error)
	svrdl SecretValueResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretValueResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretValueResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.svrdl)
		if err != nil {
			return err
		}
		page.svrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretValueResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretValueResourceDescriptionListPage) NotDone() bool {
	return !page.svrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretValueResourceDescriptionListPage) Response() SecretValueResourceDescriptionList {
	return page.svrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretValueResourceDescriptionListPage) Values() []SecretValueResourceDescription {
	if page.svrdl.IsEmpty() {
		return nil
	}
	return *page.svrdl.Value
}

// Creates a new instance of the SecretValueResourceDescriptionListPage type.
func NewSecretValueResourceDescriptionListPage(cur SecretValueResourceDescriptionList, getNextPage func(context.Context, SecretValueResourceDescriptionList) (SecretValueResourceDescriptionList, error)) SecretValueResourceDescriptionListPage {
	return SecretValueResourceDescriptionListPage{
		fn:    getNextPage,
		svrdl: cur,
	}
}

// SecretValueResourceProperties this type describes properties of a secret value resource.
type SecretValueResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Value - The actual value of the secret.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretValueResourceProperties.
func (svrp SecretValueResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svrp.Value != nil {
		objectMap["value"] = svrp.Value
	}
	return json.Marshal(objectMap)
}

// ServiceProperties describes properties of a service resource.
type ServiceProperties struct {
	// Description - User readable description of the service.
	Description *string `json:"description,omitempty"`
	// ReplicaCount - The number of replicas of the service to create. Defaults to 1 if not specified.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// AutoScalingPolicies - Auto scaling policies
	AutoScalingPolicies *[]AutoScalingPolicy `json:"autoScalingPolicies,omitempty"`
	// Status - READ-ONLY; Status of the service. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the service.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the service's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the service is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	if sp.ReplicaCount != nil {
		objectMap["replicaCount"] = sp.ReplicaCount
	}
	if sp.AutoScalingPolicies != nil {
		objectMap["autoScalingPolicies"] = sp.AutoScalingPolicies
	}
	return json.Marshal(objectMap)
}

// ServiceReplicaDescription describes a replica of a service resource.
type ServiceReplicaDescription struct {
	autorest.Response `json:"-"`
	// ReplicaName - Name of the replica.
	ReplicaName *string `json:"replicaName,omitempty"`
	// OsType - The operation system required by the code in service. Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemType `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// ServiceReplicaDescriptionList a pageable list of service replicas.
type ServiceReplicaDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ServiceReplicaDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceReplicaDescriptionListIterator provides access to a complete listing of ServiceReplicaDescription
// values.
type ServiceReplicaDescriptionListIterator struct {
	i    int
	page ServiceReplicaDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceReplicaDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceReplicaDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceReplicaDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceReplicaDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceReplicaDescriptionListIterator) Response() ServiceReplicaDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceReplicaDescriptionListIterator) Value() ServiceReplicaDescription {
	if !iter.page.NotDone() {
		return ServiceReplicaDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceReplicaDescriptionListIterator type.
func NewServiceReplicaDescriptionListIterator(page ServiceReplicaDescriptionListPage) ServiceReplicaDescriptionListIterator {
	return ServiceReplicaDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srdl ServiceReplicaDescriptionList) IsEmpty() bool {
	return srdl.Value == nil || len(*srdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srdl ServiceReplicaDescriptionList) hasNextLink() bool {
	return srdl.NextLink != nil && len(*srdl.NextLink) != 0
}

// serviceReplicaDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srdl ServiceReplicaDescriptionList) serviceReplicaDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !srdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srdl.NextLink)))
}

// ServiceReplicaDescriptionListPage contains a page of ServiceReplicaDescription values.
type ServiceReplicaDescriptionListPage struct {
	fn   func(context.Context, ServiceReplicaDescriptionList) (ServiceReplicaDescriptionList, error)
	srdl ServiceReplicaDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceReplicaDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceReplicaDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srdl)
		if err != nil {
			return err
		}
		page.srdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceReplicaDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceReplicaDescriptionListPage) NotDone() bool {
	return !page.srdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceReplicaDescriptionListPage) Response() ServiceReplicaDescriptionList {
	return page.srdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceReplicaDescriptionListPage) Values() []ServiceReplicaDescription {
	if page.srdl.IsEmpty() {
		return nil
	}
	return *page.srdl.Value
}

// Creates a new instance of the ServiceReplicaDescriptionListPage type.
func NewServiceReplicaDescriptionListPage(cur ServiceReplicaDescriptionList, getNextPage func(context.Context, ServiceReplicaDescriptionList) (ServiceReplicaDescriptionList, error)) ServiceReplicaDescriptionListPage {
	return ServiceReplicaDescriptionListPage{
		fn:   getNextPage,
		srdl: cur,
	}
}

// ServiceReplicaProperties describes the properties of a service replica.
type ServiceReplicaProperties struct {
	// OsType - The operation system required by the code in service. Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemType `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// ServiceResourceDescription this type describes a service resource.
type ServiceResourceDescription struct {
	autorest.Response `json:"-"`
	// ServiceResourceProperties - This type describes properties of a service resource.
	*ServiceResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceDescription.
func (srd ServiceResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srd.ServiceResourceProperties != nil {
		objectMap["properties"] = srd.ServiceResourceProperties
	}
	if srd.Name != nil {
		objectMap["name"] = srd.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceDescription struct.
func (srd *ServiceResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceResourceProperties ServiceResourceProperties
				err = json.Unmarshal(*v, &serviceResourceProperties)
				if err != nil {
					return err
				}
				srd.ServiceResourceProperties = &serviceResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srd.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceResourceDescriptionList a pageable list of service resources.
type ServiceResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ServiceResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceResourceDescriptionListIterator provides access to a complete listing of
// ServiceResourceDescription values.
type ServiceResourceDescriptionListIterator struct {
	i    int
	page ServiceResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceResourceDescriptionListIterator) Response() ServiceResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceResourceDescriptionListIterator) Value() ServiceResourceDescription {
	if !iter.page.NotDone() {
		return ServiceResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceResourceDescriptionListIterator type.
func NewServiceResourceDescriptionListIterator(page ServiceResourceDescriptionListPage) ServiceResourceDescriptionListIterator {
	return ServiceResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srdl ServiceResourceDescriptionList) IsEmpty() bool {
	return srdl.Value == nil || len(*srdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srdl ServiceResourceDescriptionList) hasNextLink() bool {
	return srdl.NextLink != nil && len(*srdl.NextLink) != 0
}

// serviceResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srdl ServiceResourceDescriptionList) serviceResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !srdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srdl.NextLink)))
}

// ServiceResourceDescriptionListPage contains a page of ServiceResourceDescription values.
type ServiceResourceDescriptionListPage struct {
	fn   func(context.Context, ServiceResourceDescriptionList) (ServiceResourceDescriptionList, error)
	srdl ServiceResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srdl)
		if err != nil {
			return err
		}
		page.srdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceResourceDescriptionListPage) NotDone() bool {
	return !page.srdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceResourceDescriptionListPage) Response() ServiceResourceDescriptionList {
	return page.srdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceResourceDescriptionListPage) Values() []ServiceResourceDescription {
	if page.srdl.IsEmpty() {
		return nil
	}
	return *page.srdl.Value
}

// Creates a new instance of the ServiceResourceDescriptionListPage type.
func NewServiceResourceDescriptionListPage(cur ServiceResourceDescriptionList, getNextPage func(context.Context, ServiceResourceDescriptionList) (ServiceResourceDescriptionList, error)) ServiceResourceDescriptionListPage {
	return ServiceResourceDescriptionListPage{
		fn:   getNextPage,
		srdl: cur,
	}
}

// ServiceResourceProperties this type describes properties of a service resource.
type ServiceResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OsType - The operation system required by the code in service. Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemType `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
	// Description - User readable description of the service.
	Description *string `json:"description,omitempty"`
	// ReplicaCount - The number of replicas of the service to create. Defaults to 1 if not specified.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// AutoScalingPolicies - Auto scaling policies
	AutoScalingPolicies *[]AutoScalingPolicy `json:"autoScalingPolicies,omitempty"`
	// Status - READ-ONLY; Status of the service. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the service.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the service's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the service is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceProperties.
func (srp ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srp.OsType != "" {
		objectMap["osType"] = srp.OsType
	}
	if srp.CodePackages != nil {
		objectMap["codePackages"] = srp.CodePackages
	}
	if srp.NetworkRefs != nil {
		objectMap["networkRefs"] = srp.NetworkRefs
	}
	if srp.Diagnostics != nil {
		objectMap["diagnostics"] = srp.Diagnostics
	}
	if srp.Description != nil {
		objectMap["description"] = srp.Description
	}
	if srp.ReplicaCount != nil {
		objectMap["replicaCount"] = srp.ReplicaCount
	}
	if srp.AutoScalingPolicies != nil {
		objectMap["autoScalingPolicies"] = srp.AutoScalingPolicies
	}
	return json.Marshal(objectMap)
}

// Setting describes a setting for the container. The setting file path can be fetched from environment
// variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux
// container is "/var/secrets".
type Setting struct {
	// Name - The name of the setting.
	Name *string `json:"name,omitempty"`
	// Value - The value of the setting.
	Value *string `json:"value,omitempty"`
}

// TCPConfig describes the tcp configuration for external connectivity for this network.
type TCPConfig struct {
	// Name - tcp gateway config name.
	Name *string `json:"name,omitempty"`
	// Port - Specifies the port at which the service endpoint below needs to be exposed.
	Port *int32 `json:"port,omitempty"`
	// Destination - Describes destination endpoint for routing traffic.
	Destination *GatewayDestination `json:"destination,omitempty"`
}

// TrackedResource the resource model definition for Azure Resource Manager tracked top-level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VolumeProperties describes properties of a volume resource.
type VolumeProperties struct {
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the volume. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the volume.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// Provider - Provider of the volume.
	Provider *string `json:"provider,omitempty"`
	// AzureFileParameters - This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile `json:"azureFileParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeProperties.
func (vp VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Description != nil {
		objectMap["description"] = vp.Description
	}
	if vp.Provider != nil {
		objectMap["provider"] = vp.Provider
	}
	if vp.AzureFileParameters != nil {
		objectMap["azureFileParameters"] = vp.AzureFileParameters
	}
	return json.Marshal(objectMap)
}

// VolumeProviderParametersAzureFile this type describes a volume provided by an Azure Files file share.
type VolumeProviderParametersAzureFile struct {
	// AccountName - Name of the Azure storage account for the File Share.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - Access key of the Azure storage account for the File Share.
	AccountKey *string `json:"accountKey,omitempty"`
	// ShareName - Name of the Azure Files file share that provides storage for the volume.
	ShareName *string `json:"shareName,omitempty"`
}

// VolumeReference describes a reference to a volume resource.
type VolumeReference struct {
	// Name - Name of the volume being referenced.
	Name *string `json:"name,omitempty"`
	// ReadOnly - The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// DestinationPath - The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string `json:"destinationPath,omitempty"`
}

// VolumeResourceDescription this type describes a volume resource.
type VolumeResourceDescription struct {
	autorest.Response `json:"-"`
	// VolumeResourceProperties - This type describes properties of a volume resource.
	*VolumeResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeResourceDescription.
func (vrd VolumeResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vrd.VolumeResourceProperties != nil {
		objectMap["properties"] = vrd.VolumeResourceProperties
	}
	if vrd.Tags != nil {
		objectMap["tags"] = vrd.Tags
	}
	if vrd.Location != nil {
		objectMap["location"] = vrd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumeResourceDescription struct.
func (vrd *VolumeResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var volumeResourceProperties VolumeResourceProperties
				err = json.Unmarshal(*v, &volumeResourceProperties)
				if err != nil {
					return err
				}
				vrd.VolumeResourceProperties = &volumeResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vrd.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vrd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vrd.Type = &typeVar
			}
		}
	}

	return nil
}

// VolumeResourceDescriptionList a pageable list of volume resources.
type VolumeResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]VolumeResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// VolumeResourceDescriptionListIterator provides access to a complete listing of VolumeResourceDescription
// values.
type VolumeResourceDescriptionListIterator struct {
	i    int
	page VolumeResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VolumeResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VolumeResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VolumeResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VolumeResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VolumeResourceDescriptionListIterator) Response() VolumeResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VolumeResourceDescriptionListIterator) Value() VolumeResourceDescription {
	if !iter.page.NotDone() {
		return VolumeResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VolumeResourceDescriptionListIterator type.
func NewVolumeResourceDescriptionListIterator(page VolumeResourceDescriptionListPage) VolumeResourceDescriptionListIterator {
	return VolumeResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vrdl VolumeResourceDescriptionList) IsEmpty() bool {
	return vrdl.Value == nil || len(*vrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vrdl VolumeResourceDescriptionList) hasNextLink() bool {
	return vrdl.NextLink != nil && len(*vrdl.NextLink) != 0
}

// volumeResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vrdl VolumeResourceDescriptionList) volumeResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !vrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vrdl.NextLink)))
}

// VolumeResourceDescriptionListPage contains a page of VolumeResourceDescription values.
type VolumeResourceDescriptionListPage struct {
	fn   func(context.Context, VolumeResourceDescriptionList) (VolumeResourceDescriptionList, error)
	vrdl VolumeResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VolumeResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VolumeResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vrdl)
		if err != nil {
			return err
		}
		page.vrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VolumeResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VolumeResourceDescriptionListPage) NotDone() bool {
	return !page.vrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VolumeResourceDescriptionListPage) Response() VolumeResourceDescriptionList {
	return page.vrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VolumeResourceDescriptionListPage) Values() []VolumeResourceDescription {
	if page.vrdl.IsEmpty() {
		return nil
	}
	return *page.vrdl.Value
}

// Creates a new instance of the VolumeResourceDescriptionListPage type.
func NewVolumeResourceDescriptionListPage(cur VolumeResourceDescriptionList, getNextPage func(context.Context, VolumeResourceDescriptionList) (VolumeResourceDescriptionList, error)) VolumeResourceDescriptionListPage {
	return VolumeResourceDescriptionListPage{
		fn:   getNextPage,
		vrdl: cur,
	}
}

// VolumeResourceProperties this type describes properties of a volume resource.
type VolumeResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Status - READ-ONLY; Status of the volume. Possible values include: 'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the volume.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// Provider - Provider of the volume.
	Provider *string `json:"provider,omitempty"`
	// AzureFileParameters - This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile `json:"azureFileParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeResourceProperties.
func (vrp VolumeResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vrp.Description != nil {
		objectMap["description"] = vrp.Description
	}
	if vrp.Provider != nil {
		objectMap["provider"] = vrp.Provider
	}
	if vrp.AzureFileParameters != nil {
		objectMap["azureFileParameters"] = vrp.AzureFileParameters
	}
	return json.Marshal(objectMap)
}
