package synapse

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/synapse/mgmt/2019-06-01-preview/synapse"

// AadAdminProperties workspace active directory administrator properties
type AadAdminProperties struct {
	// TenantID - Tenant ID of the workspace active directory administrator
	TenantID *string `json:"tenantId,omitempty"`
	// Login - Login of the workspace active directory administrator
	Login *string `json:"login,omitempty"`
	// AdministratorType - Workspace active directory administrator type
	AdministratorType *string `json:"administratorType,omitempty"`
	// Sid - Object ID of the workspace active directory administrator
	Sid *string `json:"sid,omitempty"`
}

// AutoPauseProperties auto-pausing properties of a Big Data pool powered by Apache Spark
type AutoPauseProperties struct {
	// DelayInMinutes - Number of minutes of idle time before the Big Data pool is automatically paused.
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`
	// Enabled - Whether auto-pausing is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`
}

// AutoScaleProperties auto-scaling properties of a Big Data pool powered by Apache Spark
type AutoScaleProperties struct {
	// MinNodeCount - The minimum number of nodes the Big Data pool can support.
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// Enabled - Whether automatic scaling is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`
	// MaxNodeCount - The maximum number of nodes the Big Data pool can support.
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
}

// AvailableRpOperation an operation that is available in this resource provider
type AvailableRpOperation struct {
	// Display - Display properties of the operation
	Display *AvailableRpOperationDisplayInfo `json:"display,omitempty"`
	// IsDataAction - Whether this operation is a data action
	IsDataAction *string `json:"isDataAction,omitempty"`
	// Name - Operation name
	Name *string `json:"name,omitempty"`
	// OperationMetaPropertyInfo - Operation properties
	*OperationMetaPropertyInfo `json:"properties,omitempty"`
	// Origin - Operation origin
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableRpOperation.
func (aro AvailableRpOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aro.Display != nil {
		objectMap["display"] = aro.Display
	}
	if aro.IsDataAction != nil {
		objectMap["isDataAction"] = aro.IsDataAction
	}
	if aro.Name != nil {
		objectMap["name"] = aro.Name
	}
	if aro.OperationMetaPropertyInfo != nil {
		objectMap["properties"] = aro.OperationMetaPropertyInfo
	}
	if aro.Origin != nil {
		objectMap["origin"] = aro.Origin
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableRpOperation struct.
func (aro *AvailableRpOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "display":
			if v != nil {
				var display AvailableRpOperationDisplayInfo
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				aro.Display = &display
			}
		case "isDataAction":
			if v != nil {
				var isDataAction string
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				aro.IsDataAction = &isDataAction
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aro.Name = &name
			}
		case "properties":
			if v != nil {
				var operationMetaPropertyInfo OperationMetaPropertyInfo
				err = json.Unmarshal(*v, &operationMetaPropertyInfo)
				if err != nil {
					return err
				}
				aro.OperationMetaPropertyInfo = &operationMetaPropertyInfo
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				aro.Origin = &origin
			}
		}
	}

	return nil
}

// AvailableRpOperationDisplayInfo description of an available operation
type AvailableRpOperationDisplayInfo struct {
	// Description - Operation description
	Description *string `json:"description,omitempty"`
	// Resource - Resource type
	Resource *string `json:"resource,omitempty"`
	// Provider - Resource provider name
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// BigDataPoolPatchInfo properties patch for a Big Data pool
type BigDataPoolPatchInfo struct {
	// Tags - Updated tags for the Big Data pool
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BigDataPoolPatchInfo.
func (bdppi BigDataPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bdppi.Tags != nil {
		objectMap["tags"] = bdppi.Tags
	}
	return json.Marshal(objectMap)
}

// BigDataPoolResourceInfo a Big Data pool
type BigDataPoolResourceInfo struct {
	autorest.Response `json:"-"`
	// BigDataPoolResourceProperties - Big Data pool properties
	*BigDataPoolResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BigDataPoolResourceInfo.
func (bdpri BigDataPoolResourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bdpri.BigDataPoolResourceProperties != nil {
		objectMap["properties"] = bdpri.BigDataPoolResourceProperties
	}
	if bdpri.Tags != nil {
		objectMap["tags"] = bdpri.Tags
	}
	if bdpri.Location != nil {
		objectMap["location"] = bdpri.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BigDataPoolResourceInfo struct.
func (bdpri *BigDataPoolResourceInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bigDataPoolResourceProperties BigDataPoolResourceProperties
				err = json.Unmarshal(*v, &bigDataPoolResourceProperties)
				if err != nil {
					return err
				}
				bdpri.BigDataPoolResourceProperties = &bigDataPoolResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bdpri.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bdpri.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bdpri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bdpri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bdpri.Type = &typeVar
			}
		}
	}

	return nil
}

// BigDataPoolResourceInfoListResult collection of Big Data pool information
type BigDataPoolResourceInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of Big Data pools
	Value *[]BigDataPoolResourceInfo `json:"value,omitempty"`
}

// BigDataPoolResourceInfoListResultIterator provides access to a complete listing of
// BigDataPoolResourceInfo values.
type BigDataPoolResourceInfoListResultIterator struct {
	i    int
	page BigDataPoolResourceInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BigDataPoolResourceInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BigDataPoolResourceInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BigDataPoolResourceInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BigDataPoolResourceInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BigDataPoolResourceInfoListResultIterator) Response() BigDataPoolResourceInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BigDataPoolResourceInfoListResultIterator) Value() BigDataPoolResourceInfo {
	if !iter.page.NotDone() {
		return BigDataPoolResourceInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BigDataPoolResourceInfoListResultIterator type.
func NewBigDataPoolResourceInfoListResultIterator(page BigDataPoolResourceInfoListResultPage) BigDataPoolResourceInfoListResultIterator {
	return BigDataPoolResourceInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bdprilr BigDataPoolResourceInfoListResult) IsEmpty() bool {
	return bdprilr.Value == nil || len(*bdprilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bdprilr BigDataPoolResourceInfoListResult) hasNextLink() bool {
	return bdprilr.NextLink != nil && len(*bdprilr.NextLink) != 0
}

// bigDataPoolResourceInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bdprilr BigDataPoolResourceInfoListResult) bigDataPoolResourceInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bdprilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bdprilr.NextLink)))
}

// BigDataPoolResourceInfoListResultPage contains a page of BigDataPoolResourceInfo values.
type BigDataPoolResourceInfoListResultPage struct {
	fn      func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)
	bdprilr BigDataPoolResourceInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BigDataPoolResourceInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BigDataPoolResourceInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bdprilr)
		if err != nil {
			return err
		}
		page.bdprilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BigDataPoolResourceInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BigDataPoolResourceInfoListResultPage) NotDone() bool {
	return !page.bdprilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BigDataPoolResourceInfoListResultPage) Response() BigDataPoolResourceInfoListResult {
	return page.bdprilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BigDataPoolResourceInfoListResultPage) Values() []BigDataPoolResourceInfo {
	if page.bdprilr.IsEmpty() {
		return nil
	}
	return *page.bdprilr.Value
}

// Creates a new instance of the BigDataPoolResourceInfoListResultPage type.
func NewBigDataPoolResourceInfoListResultPage(cur BigDataPoolResourceInfoListResult, getNextPage func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)) BigDataPoolResourceInfoListResultPage {
	return BigDataPoolResourceInfoListResultPage{
		fn:      getNextPage,
		bdprilr: cur,
	}
}

// BigDataPoolResourceProperties properties of a Big Data pool powered by Apache Spark
type BigDataPoolResourceProperties struct {
	// ProvisioningState - The state of the Big Data pool.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// AutoScale - Auto-scaling properties
	AutoScale *AutoScaleProperties `json:"autoScale,omitempty"`
	// CreationDate - The time when the Big Data pool was created.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// AutoPause - Auto-pausing properties
	AutoPause *AutoPauseProperties `json:"autoPause,omitempty"`
	// IsComputeIsolationEnabled - Whether compute isolation is required or not.
	IsComputeIsolationEnabled *bool `json:"isComputeIsolationEnabled,omitempty"`
	// HaveLibraryRequirementsChanged - Whether library requirements changed.
	HaveLibraryRequirementsChanged *bool `json:"haveLibraryRequirementsChanged,omitempty"`
	// SessionLevelPackagesEnabled - Whether session level packages enabled.
	SessionLevelPackagesEnabled *bool `json:"sessionLevelPackagesEnabled,omitempty"`
	// SparkEventsFolder - The Spark events folder
	SparkEventsFolder *string `json:"sparkEventsFolder,omitempty"`
	// NodeCount - The number of nodes in the Big Data pool.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// LibraryRequirements - Library version requirements
	LibraryRequirements *LibraryRequirements `json:"libraryRequirements,omitempty"`
	// SparkConfigProperties - Spark configuration file to specify additional properties
	SparkConfigProperties *LibraryRequirements `json:"sparkConfigProperties,omitempty"`
	// SparkVersion - The Apache Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`
	// DefaultSparkLogFolder - The default folder where Spark logs will be written.
	DefaultSparkLogFolder *string `json:"defaultSparkLogFolder,omitempty"`
	// NodeSize - The level of compute power that each node in the Big Data pool has. Possible values include: 'NodeSizeNone', 'NodeSizeSmall', 'NodeSizeMedium', 'NodeSizeLarge', 'NodeSizeXLarge', 'NodeSizeXXLarge', 'NodeSizeXXXLarge'
	NodeSize NodeSize `json:"nodeSize,omitempty"`
	// NodeSizeFamily - The kind of nodes that the Big Data pool provides. Possible values include: 'NodeSizeFamilyNone', 'NodeSizeFamilyMemoryOptimized'
	NodeSizeFamily NodeSizeFamily `json:"nodeSizeFamily,omitempty"`
}

// BigDataPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BigDataPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BigDataPoolsClient) (BigDataPoolResourceInfo, error)
}

// BigDataPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BigDataPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BigDataPoolsClient) (SetObject, error)
}

// CheckNameAvailabilityRequest a request about whether a workspace name is available
type CheckNameAvailabilityRequest struct {
	// Name - Workspace name
	Name *string `json:"name,omitempty"`
	// Type - Type: workspace
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse a response saying whether the workspace name is available
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Message - Validation message
	Message *string `json:"message,omitempty"`
	// Available - Whether the workspace name is available
	Available *bool `json:"available,omitempty"`
	// Reason - Reason the workspace name is or is not available
	Reason *string `json:"reason,omitempty"`
	// Name - Workspace name
	Name *string `json:"name,omitempty"`
}

// CloudError the object that defines the structure of an Azure Synapse error response.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody the object that defines the structure of an Azure Synapse error.
type CloudErrorBody struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Target - Property name/path in request associated with error.
	Target *string `json:"target,omitempty"`
	// Details - Array with additional error details.
	Details *[]CloudError `json:"details,omitempty"`
}

// CmdkeySetup the custom setup of running cmdkey commands.
type CmdkeySetup struct {
	// CmdkeySetupTypeProperties - Cmdkey command custom setup type properties.
	*CmdkeySetupTypeProperties `json:"typeProperties,omitempty"`
	// Type - Possible values include: 'TypeCustomSetupBase', 'TypeCmdkeySetup', 'TypeEnvironmentVariableSetup', 'TypeComponentSetup'
	Type TypeBasicCustomSetupBase `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CmdkeySetup.
func (cs CmdkeySetup) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCmdkeySetup
	objectMap := make(map[string]interface{})
	if cs.CmdkeySetupTypeProperties != nil {
		objectMap["typeProperties"] = cs.CmdkeySetupTypeProperties
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	return json.Marshal(objectMap)
}

// AsCmdkeySetup is the BasicCustomSetupBase implementation for CmdkeySetup.
func (cs CmdkeySetup) AsCmdkeySetup() (*CmdkeySetup, bool) {
	return &cs, true
}

// AsEnvironmentVariableSetup is the BasicCustomSetupBase implementation for CmdkeySetup.
func (cs CmdkeySetup) AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool) {
	return nil, false
}

// AsComponentSetup is the BasicCustomSetupBase implementation for CmdkeySetup.
func (cs CmdkeySetup) AsComponentSetup() (*ComponentSetup, bool) {
	return nil, false
}

// AsCustomSetupBase is the BasicCustomSetupBase implementation for CmdkeySetup.
func (cs CmdkeySetup) AsCustomSetupBase() (*CustomSetupBase, bool) {
	return nil, false
}

// AsBasicCustomSetupBase is the BasicCustomSetupBase implementation for CmdkeySetup.
func (cs CmdkeySetup) AsBasicCustomSetupBase() (BasicCustomSetupBase, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CmdkeySetup struct.
func (cs *CmdkeySetup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var cmdkeySetupTypeProperties CmdkeySetupTypeProperties
				err = json.Unmarshal(*v, &cmdkeySetupTypeProperties)
				if err != nil {
					return err
				}
				cs.CmdkeySetupTypeProperties = &cmdkeySetupTypeProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCustomSetupBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CmdkeySetupTypeProperties cmdkey command custom setup type properties.
type CmdkeySetupTypeProperties struct {
	// TargetName - The server name of data source access.
	TargetName interface{} `json:"targetName,omitempty"`
	// UserName - The user name of data source access.
	UserName interface{} `json:"userName,omitempty"`
	// Password - The password of data source access.
	Password BasicSecretBase `json:"password,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CmdkeySetupTypeProperties struct.
func (cstp *CmdkeySetupTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetName":
			if v != nil {
				var targetName interface{}
				err = json.Unmarshal(*v, &targetName)
				if err != nil {
					return err
				}
				cstp.TargetName = targetName
			}
		case "userName":
			if v != nil {
				var userName interface{}
				err = json.Unmarshal(*v, &userName)
				if err != nil {
					return err
				}
				cstp.UserName = userName
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				cstp.Password = password
			}
		}
	}

	return nil
}

// ComponentSetup the custom setup of installing 3rd party components.
type ComponentSetup struct {
	// LicensedComponentSetupTypeProperties - Install 3rd party component type properties.
	*LicensedComponentSetupTypeProperties `json:"typeProperties,omitempty"`
	// Type - Possible values include: 'TypeCustomSetupBase', 'TypeCmdkeySetup', 'TypeEnvironmentVariableSetup', 'TypeComponentSetup'
	Type TypeBasicCustomSetupBase `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComponentSetup.
func (cs ComponentSetup) MarshalJSON() ([]byte, error) {
	cs.Type = TypeComponentSetup
	objectMap := make(map[string]interface{})
	if cs.LicensedComponentSetupTypeProperties != nil {
		objectMap["typeProperties"] = cs.LicensedComponentSetupTypeProperties
	}
	if cs.Type != "" {
		objectMap["type"] = cs.Type
	}
	return json.Marshal(objectMap)
}

// AsCmdkeySetup is the BasicCustomSetupBase implementation for ComponentSetup.
func (cs ComponentSetup) AsCmdkeySetup() (*CmdkeySetup, bool) {
	return nil, false
}

// AsEnvironmentVariableSetup is the BasicCustomSetupBase implementation for ComponentSetup.
func (cs ComponentSetup) AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool) {
	return nil, false
}

// AsComponentSetup is the BasicCustomSetupBase implementation for ComponentSetup.
func (cs ComponentSetup) AsComponentSetup() (*ComponentSetup, bool) {
	return &cs, true
}

// AsCustomSetupBase is the BasicCustomSetupBase implementation for ComponentSetup.
func (cs ComponentSetup) AsCustomSetupBase() (*CustomSetupBase, bool) {
	return nil, false
}

// AsBasicCustomSetupBase is the BasicCustomSetupBase implementation for ComponentSetup.
func (cs ComponentSetup) AsBasicCustomSetupBase() (BasicCustomSetupBase, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for ComponentSetup struct.
func (cs *ComponentSetup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var licensedComponentSetupTypeProperties LicensedComponentSetupTypeProperties
				err = json.Unmarshal(*v, &licensedComponentSetupTypeProperties)
				if err != nil {
					return err
				}
				cs.LicensedComponentSetupTypeProperties = &licensedComponentSetupTypeProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCustomSetupBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CreateSQLPoolRestorePointDefinition contains the information necessary to perform a create Sql pool
// restore point operation.
type CreateSQLPoolRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// CustomerManagedKeyDetails details of the customer managed key associated with the workspace
type CustomerManagedKeyDetails struct {
	// Status - READ-ONLY; The customer managed key status on the workspace
	Status *string `json:"status,omitempty"`
	// Key - The key object of the workspace
	Key *WorkspaceKeyDetails `json:"key,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomerManagedKeyDetails.
func (cmkd CustomerManagedKeyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmkd.Key != nil {
		objectMap["key"] = cmkd.Key
	}
	return json.Marshal(objectMap)
}

// BasicCustomSetupBase the base definition of the custom setup.
type BasicCustomSetupBase interface {
	AsCmdkeySetup() (*CmdkeySetup, bool)
	AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool)
	AsComponentSetup() (*ComponentSetup, bool)
	AsCustomSetupBase() (*CustomSetupBase, bool)
}

// CustomSetupBase the base definition of the custom setup.
type CustomSetupBase struct {
	// Type - Possible values include: 'TypeCustomSetupBase', 'TypeCmdkeySetup', 'TypeEnvironmentVariableSetup', 'TypeComponentSetup'
	Type TypeBasicCustomSetupBase `json:"type,omitempty"`
}

func unmarshalBasicCustomSetupBase(body []byte) (BasicCustomSetupBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeCmdkeySetup):
		var cs CmdkeySetup
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeEnvironmentVariableSetup):
		var evs EnvironmentVariableSetup
		err := json.Unmarshal(body, &evs)
		return evs, err
	case string(TypeComponentSetup):
		var cs ComponentSetup
		err := json.Unmarshal(body, &cs)
		return cs, err
	default:
		var csb CustomSetupBase
		err := json.Unmarshal(body, &csb)
		return csb, err
	}
}
func unmarshalBasicCustomSetupBaseArray(body []byte) ([]BasicCustomSetupBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csbArray := make([]BasicCustomSetupBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		csb, err := unmarshalBasicCustomSetupBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		csbArray[index] = csb
	}
	return csbArray, nil
}

// MarshalJSON is the custom marshaler for CustomSetupBase.
func (csb CustomSetupBase) MarshalJSON() ([]byte, error) {
	csb.Type = TypeCustomSetupBase
	objectMap := make(map[string]interface{})
	if csb.Type != "" {
		objectMap["type"] = csb.Type
	}
	return json.Marshal(objectMap)
}

// AsCmdkeySetup is the BasicCustomSetupBase implementation for CustomSetupBase.
func (csb CustomSetupBase) AsCmdkeySetup() (*CmdkeySetup, bool) {
	return nil, false
}

// AsEnvironmentVariableSetup is the BasicCustomSetupBase implementation for CustomSetupBase.
func (csb CustomSetupBase) AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool) {
	return nil, false
}

// AsComponentSetup is the BasicCustomSetupBase implementation for CustomSetupBase.
func (csb CustomSetupBase) AsComponentSetup() (*ComponentSetup, bool) {
	return nil, false
}

// AsCustomSetupBase is the BasicCustomSetupBase implementation for CustomSetupBase.
func (csb CustomSetupBase) AsCustomSetupBase() (*CustomSetupBase, bool) {
	return &csb, true
}

// AsBasicCustomSetupBase is the BasicCustomSetupBase implementation for CustomSetupBase.
func (csb CustomSetupBase) AsBasicCustomSetupBase() (BasicCustomSetupBase, bool) {
	return &csb, true
}

// DataLakeStorageAccountDetails details of the data lake storage account associated with the workspace
type DataLakeStorageAccountDetails struct {
	// AccountURL - Account URL
	AccountURL *string `json:"accountUrl,omitempty"`
	// Filesystem - Filesystem name
	Filesystem *string `json:"filesystem,omitempty"`
}

// DataMaskingPolicy ...
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - READ-ONLY; Fully qualified resource ID of the sql pool
	ManagedBy *string `json:"managedBy,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				dmp.ManagedBy = &managedBy
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicyProperties.
func (dmpp DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmpp.DataMaskingState != "" {
		objectMap["dataMaskingState"] = dmpp.DataMaskingState
	}
	if dmpp.ExemptPrincipals != nil {
		objectMap["exemptPrincipals"] = dmpp.ExemptPrincipals
	}
	return json.Marshal(objectMap)
}

// DataMaskingRule represents a Sql pool data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Sql pool data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a Sql pool data masking rule.
type DataMaskingRuleProperties struct {
	// ID - READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRuleProperties.
func (dmrp DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmrp.AliasName != nil {
		objectMap["aliasName"] = dmrp.AliasName
	}
	if dmrp.RuleState != "" {
		objectMap["ruleState"] = dmrp.RuleState
	}
	if dmrp.SchemaName != nil {
		objectMap["schemaName"] = dmrp.SchemaName
	}
	if dmrp.TableName != nil {
		objectMap["tableName"] = dmrp.TableName
	}
	if dmrp.ColumnName != nil {
		objectMap["columnName"] = dmrp.ColumnName
	}
	if dmrp.MaskingFunction != "" {
		objectMap["maskingFunction"] = dmrp.MaskingFunction
	}
	if dmrp.NumberFrom != nil {
		objectMap["numberFrom"] = dmrp.NumberFrom
	}
	if dmrp.NumberTo != nil {
		objectMap["numberTo"] = dmrp.NumberTo
	}
	if dmrp.PrefixSize != nil {
		objectMap["prefixSize"] = dmrp.PrefixSize
	}
	if dmrp.SuffixSize != nil {
		objectMap["suffixSize"] = dmrp.SuffixSize
	}
	if dmrp.ReplacementString != nil {
		objectMap["replacementString"] = dmrp.ReplacementString
	}
	return json.Marshal(objectMap)
}

// DataWarehouseUserActivities user activities of a data warehouse
type DataWarehouseUserActivities struct {
	autorest.Response `json:"-"`
	// DataWarehouseUserActivitiesProperties - Resource properties.
	*DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivities.
func (dwua DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwua.DataWarehouseUserActivitiesProperties != nil {
		objectMap["properties"] = dwua.DataWarehouseUserActivitiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataWarehouseUserActivities struct.
func (dwua *DataWarehouseUserActivities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataWarehouseUserActivitiesProperties DataWarehouseUserActivitiesProperties
				err = json.Unmarshal(*v, &dataWarehouseUserActivitiesProperties)
				if err != nil {
					return err
				}
				dwua.DataWarehouseUserActivitiesProperties = &dataWarehouseUserActivitiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dwua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dwua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dwua.Type = &typeVar
			}
		}
	}

	return nil
}

// DataWarehouseUserActivitiesProperties user activities of a data warehouse. This currently includes the
// count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests
// dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// ActiveQueriesCount - READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty"`
}

// EncryptionDetails details of the encryption associated with the workspace
type EncryptionDetails struct {
	// DoubleEncryptionEnabled - READ-ONLY; Double Encryption enabled
	DoubleEncryptionEnabled *bool `json:"doubleEncryptionEnabled,omitempty"`
	// Cmk - Customer Managed Key Details
	Cmk *CustomerManagedKeyDetails `json:"cmk,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionDetails.
func (ed EncryptionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ed.Cmk != nil {
		objectMap["cmk"] = ed.Cmk
	}
	return json.Marshal(objectMap)
}

// EntityReference the entity reference.
type EntityReference struct {
	// Type - The type of this referenced entity. Possible values include: 'IntegrationRuntimeReference', 'LinkedServiceReference'
	Type IntegrationRuntimeEntityReferenceType `json:"type,omitempty"`
	// ReferenceName - The name of this referenced entity.
	ReferenceName *string `json:"referenceName,omitempty"`
}

// EnvironmentVariableSetup the custom setup of setting environment variable.
type EnvironmentVariableSetup struct {
	// EnvironmentVariableSetupTypeProperties - Add environment variable type properties.
	*EnvironmentVariableSetupTypeProperties `json:"typeProperties,omitempty"`
	// Type - Possible values include: 'TypeCustomSetupBase', 'TypeCmdkeySetup', 'TypeEnvironmentVariableSetup', 'TypeComponentSetup'
	Type TypeBasicCustomSetupBase `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) MarshalJSON() ([]byte, error) {
	evs.Type = TypeEnvironmentVariableSetup
	objectMap := make(map[string]interface{})
	if evs.EnvironmentVariableSetupTypeProperties != nil {
		objectMap["typeProperties"] = evs.EnvironmentVariableSetupTypeProperties
	}
	if evs.Type != "" {
		objectMap["type"] = evs.Type
	}
	return json.Marshal(objectMap)
}

// AsCmdkeySetup is the BasicCustomSetupBase implementation for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) AsCmdkeySetup() (*CmdkeySetup, bool) {
	return nil, false
}

// AsEnvironmentVariableSetup is the BasicCustomSetupBase implementation for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool) {
	return &evs, true
}

// AsComponentSetup is the BasicCustomSetupBase implementation for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) AsComponentSetup() (*ComponentSetup, bool) {
	return nil, false
}

// AsCustomSetupBase is the BasicCustomSetupBase implementation for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) AsCustomSetupBase() (*CustomSetupBase, bool) {
	return nil, false
}

// AsBasicCustomSetupBase is the BasicCustomSetupBase implementation for EnvironmentVariableSetup.
func (evs EnvironmentVariableSetup) AsBasicCustomSetupBase() (BasicCustomSetupBase, bool) {
	return &evs, true
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentVariableSetup struct.
func (evs *EnvironmentVariableSetup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var environmentVariableSetupTypeProperties EnvironmentVariableSetupTypeProperties
				err = json.Unmarshal(*v, &environmentVariableSetupTypeProperties)
				if err != nil {
					return err
				}
				evs.EnvironmentVariableSetupTypeProperties = &environmentVariableSetupTypeProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCustomSetupBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				evs.Type = typeVar
			}
		}
	}

	return nil
}

// EnvironmentVariableSetupTypeProperties environment variable custom setup type properties.
type EnvironmentVariableSetupTypeProperties struct {
	// VariableName - The name of the environment variable.
	VariableName *string `json:"variableName,omitempty"`
	// VariableValue - The value of the environment variable.
	VariableValue *string `json:"variableValue,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorContract contains details when the response code indicates an error.
type ErrorContract struct {
	// Error - The error details.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorDetail error details
type ErrorDetail struct {
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Target - Error target
	Target *string `json:"target,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ExtendedServerBlobAuditingPolicy an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedServerBlobAuditingPolicyProperties - Resource properties.
	*ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicy.
func (esbap ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esbap.ExtendedServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = esbap.ExtendedServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedServerBlobAuditingPolicy struct.
func (esbap *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedServerBlobAuditingPolicyProperties ExtendedServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedServerBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				esbap.ExtendedServerBlobAuditingPolicyProperties = &extendedServerBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedServerBlobAuditingPolicyListResult a list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedServerBlobAuditingPolicy values.
type ExtendedServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Response() ExtendedServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Value() ExtendedServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultIterator type.
func NewExtendedServerBlobAuditingPolicyListResultIterator(page ExtendedServerBlobAuditingPolicyListResultPage) ExtendedServerBlobAuditingPolicyListResultIterator {
	return ExtendedServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return esbaplr.Value == nil || len(*esbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return esbaplr.NextLink != nil && len(*esbaplr.NextLink) != 0
}

// extendedServerBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) extendedServerBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !esbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(esbaplr.NextLink)))
}

// ExtendedServerBlobAuditingPolicyListResultPage contains a page of ExtendedServerBlobAuditingPolicy
// values.
type ExtendedServerBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)
	esbaplr ExtendedServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.esbaplr)
		if err != nil {
			return err
		}
		page.esbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.esbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Response() ExtendedServerBlobAuditingPolicyListResult {
	return page.esbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Values() []ExtendedServerBlobAuditingPolicy {
	if page.esbaplr.IsEmpty() {
		return nil
	}
	return *page.esbaplr.Value
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultPage type.
func NewExtendedServerBlobAuditingPolicyListResultPage(cur ExtendedServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)) ExtendedServerBlobAuditingPolicyListResultPage {
	return ExtendedServerBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		esbaplr: cur,
	}
}

// ExtendedServerBlobAuditingPolicyProperties properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ExtendedSQLPoolBlobAuditingPolicy an extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedSQLPoolBlobAuditingPolicyProperties - Resource properties.
	*ExtendedSQLPoolBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedSQLPoolBlobAuditingPolicy.
func (espbap ExtendedSQLPoolBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if espbap.ExtendedSQLPoolBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = espbap.ExtendedSQLPoolBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedSQLPoolBlobAuditingPolicy struct.
func (espbap *ExtendedSQLPoolBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedSQLPoolBlobAuditingPolicyProperties ExtendedSQLPoolBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedSQLPoolBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				espbap.ExtendedSQLPoolBlobAuditingPolicyProperties = &extendedSQLPoolBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				espbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				espbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				espbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedSQLPoolBlobAuditingPolicyListResult a list of sql pool extended auditing settings.
type ExtendedSQLPoolBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedSQLPoolBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedSQLPoolBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedSQLPoolBlobAuditingPolicy values.
type ExtendedSQLPoolBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedSQLPoolBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedSQLPoolBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedSQLPoolBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedSQLPoolBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedSQLPoolBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedSQLPoolBlobAuditingPolicyListResultIterator) Response() ExtendedSQLPoolBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedSQLPoolBlobAuditingPolicyListResultIterator) Value() ExtendedSQLPoolBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedSQLPoolBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedSQLPoolBlobAuditingPolicyListResultIterator type.
func NewExtendedSQLPoolBlobAuditingPolicyListResultIterator(page ExtendedSQLPoolBlobAuditingPolicyListResultPage) ExtendedSQLPoolBlobAuditingPolicyListResultIterator {
	return ExtendedSQLPoolBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (espbaplr ExtendedSQLPoolBlobAuditingPolicyListResult) IsEmpty() bool {
	return espbaplr.Value == nil || len(*espbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (espbaplr ExtendedSQLPoolBlobAuditingPolicyListResult) hasNextLink() bool {
	return espbaplr.NextLink != nil && len(*espbaplr.NextLink) != 0
}

// extendedSQLPoolBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (espbaplr ExtendedSQLPoolBlobAuditingPolicyListResult) extendedSQLPoolBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !espbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(espbaplr.NextLink)))
}

// ExtendedSQLPoolBlobAuditingPolicyListResultPage contains a page of ExtendedSQLPoolBlobAuditingPolicy
// values.
type ExtendedSQLPoolBlobAuditingPolicyListResultPage struct {
	fn       func(context.Context, ExtendedSQLPoolBlobAuditingPolicyListResult) (ExtendedSQLPoolBlobAuditingPolicyListResult, error)
	espbaplr ExtendedSQLPoolBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedSQLPoolBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedSQLPoolBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.espbaplr)
		if err != nil {
			return err
		}
		page.espbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedSQLPoolBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedSQLPoolBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.espbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedSQLPoolBlobAuditingPolicyListResultPage) Response() ExtendedSQLPoolBlobAuditingPolicyListResult {
	return page.espbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedSQLPoolBlobAuditingPolicyListResultPage) Values() []ExtendedSQLPoolBlobAuditingPolicy {
	if page.espbaplr.IsEmpty() {
		return nil
	}
	return *page.espbaplr.Value
}

// Creates a new instance of the ExtendedSQLPoolBlobAuditingPolicyListResultPage type.
func NewExtendedSQLPoolBlobAuditingPolicyListResultPage(cur ExtendedSQLPoolBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedSQLPoolBlobAuditingPolicyListResult) (ExtendedSQLPoolBlobAuditingPolicyListResult, error)) ExtendedSQLPoolBlobAuditingPolicyListResultPage {
	return ExtendedSQLPoolBlobAuditingPolicyListResultPage{
		fn:       getNextPage,
		espbaplr: cur,
	}
}

// ExtendedSQLPoolBlobAuditingPolicyProperties properties of an extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicyProperties.
func (gbpp GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbpp.State != "" {
		objectMap["state"] = gbpp.State
	}
	return json.Marshal(objectMap)
}

// GetSsisObjectMetadataRequest the request payload of get SSIS object metadata.
type GetSsisObjectMetadataRequest struct {
	// MetadataPath - Metadata path.
	MetadataPath *string `json:"metadataPath,omitempty"`
}

// BasicIntegrationRuntime azure Synapse nested object which serves as a compute resource for activities.
type BasicIntegrationRuntime interface {
	AsManagedIntegrationRuntime() (*ManagedIntegrationRuntime, bool)
	AsSelfHostedIntegrationRuntime() (*SelfHostedIntegrationRuntime, bool)
	AsIntegrationRuntime() (*IntegrationRuntime, bool)
}

// IntegrationRuntime azure Synapse nested object which serves as a compute resource for activities.
type IntegrationRuntime struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Integration runtime description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeIntegrationRuntime', 'TypeManaged', 'TypeSelfHosted'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicIntegrationRuntime(body []byte) (BasicIntegrationRuntime, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeManaged):
		var mir ManagedIntegrationRuntime
		err := json.Unmarshal(body, &mir)
		return mir, err
	case string(TypeSelfHosted):
		var shir SelfHostedIntegrationRuntime
		err := json.Unmarshal(body, &shir)
		return shir, err
	default:
		var ir IntegrationRuntime
		err := json.Unmarshal(body, &ir)
		return ir, err
	}
}
func unmarshalBasicIntegrationRuntimeArray(body []byte) ([]BasicIntegrationRuntime, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	irArray := make([]BasicIntegrationRuntime, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ir, err := unmarshalBasicIntegrationRuntime(*rawMessage)
		if err != nil {
			return nil, err
		}
		irArray[index] = ir
	}
	return irArray, nil
}

// MarshalJSON is the custom marshaler for IntegrationRuntime.
func (ir IntegrationRuntime) MarshalJSON() ([]byte, error) {
	ir.Type = TypeIntegrationRuntime
	objectMap := make(map[string]interface{})
	if ir.Description != nil {
		objectMap["description"] = ir.Description
	}
	if ir.Type != "" {
		objectMap["type"] = ir.Type
	}
	for k, v := range ir.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntime is the BasicIntegrationRuntime implementation for IntegrationRuntime.
func (ir IntegrationRuntime) AsManagedIntegrationRuntime() (*ManagedIntegrationRuntime, bool) {
	return nil, false
}

// AsSelfHostedIntegrationRuntime is the BasicIntegrationRuntime implementation for IntegrationRuntime.
func (ir IntegrationRuntime) AsSelfHostedIntegrationRuntime() (*SelfHostedIntegrationRuntime, bool) {
	return nil, false
}

// AsIntegrationRuntime is the BasicIntegrationRuntime implementation for IntegrationRuntime.
func (ir IntegrationRuntime) AsIntegrationRuntime() (*IntegrationRuntime, bool) {
	return &ir, true
}

// AsBasicIntegrationRuntime is the BasicIntegrationRuntime implementation for IntegrationRuntime.
func (ir IntegrationRuntime) AsBasicIntegrationRuntime() (BasicIntegrationRuntime, bool) {
	return &ir, true
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntime struct.
func (ir *IntegrationRuntime) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ir.AdditionalProperties == nil {
					ir.AdditionalProperties = make(map[string]interface{})
				}
				ir.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ir.Description = &description
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ir.Type = typeVar
			}
		}
	}

	return nil
}

// IntegrationRuntimeAuthKeys the integration runtime authentication keys.
type IntegrationRuntimeAuthKeys struct {
	autorest.Response `json:"-"`
	// AuthKey1 - The primary integration runtime authentication key.
	AuthKey1 *string `json:"authKey1,omitempty"`
	// AuthKey2 - The secondary integration runtime authentication key.
	AuthKey2 *string `json:"authKey2,omitempty"`
}

// IntegrationRuntimeComputeProperties the compute resource properties for managed integration runtime.
type IntegrationRuntimeComputeProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Location - The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
	Location *string `json:"location,omitempty"`
	// NodeSize - The node size requirement to managed integration runtime.
	NodeSize *string `json:"nodeSize,omitempty"`
	// NumberOfNodes - The required number of nodes for managed integration runtime.
	NumberOfNodes *int32 `json:"numberOfNodes,omitempty"`
	// MaxParallelExecutionsPerNode - Maximum parallel executions count per node for managed integration runtime.
	MaxParallelExecutionsPerNode *int32 `json:"maxParallelExecutionsPerNode,omitempty"`
	// DataFlowProperties - Data flow properties for managed integration runtime.
	DataFlowProperties *IntegrationRuntimeDataFlowProperties `json:"dataFlowProperties,omitempty"`
	// VNetProperties - VNet properties for managed integration runtime.
	VNetProperties *IntegrationRuntimeVNetProperties `json:"vNetProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeComputeProperties.
func (ircp IntegrationRuntimeComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ircp.Location != nil {
		objectMap["location"] = ircp.Location
	}
	if ircp.NodeSize != nil {
		objectMap["nodeSize"] = ircp.NodeSize
	}
	if ircp.NumberOfNodes != nil {
		objectMap["numberOfNodes"] = ircp.NumberOfNodes
	}
	if ircp.MaxParallelExecutionsPerNode != nil {
		objectMap["maxParallelExecutionsPerNode"] = ircp.MaxParallelExecutionsPerNode
	}
	if ircp.DataFlowProperties != nil {
		objectMap["dataFlowProperties"] = ircp.DataFlowProperties
	}
	if ircp.VNetProperties != nil {
		objectMap["vNetProperties"] = ircp.VNetProperties
	}
	for k, v := range ircp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeComputeProperties struct.
func (ircp *IntegrationRuntimeComputeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ircp.AdditionalProperties == nil {
					ircp.AdditionalProperties = make(map[string]interface{})
				}
				ircp.AdditionalProperties[k] = additionalProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ircp.Location = &location
			}
		case "nodeSize":
			if v != nil {
				var nodeSize string
				err = json.Unmarshal(*v, &nodeSize)
				if err != nil {
					return err
				}
				ircp.NodeSize = &nodeSize
			}
		case "numberOfNodes":
			if v != nil {
				var numberOfNodes int32
				err = json.Unmarshal(*v, &numberOfNodes)
				if err != nil {
					return err
				}
				ircp.NumberOfNodes = &numberOfNodes
			}
		case "maxParallelExecutionsPerNode":
			if v != nil {
				var maxParallelExecutionsPerNode int32
				err = json.Unmarshal(*v, &maxParallelExecutionsPerNode)
				if err != nil {
					return err
				}
				ircp.MaxParallelExecutionsPerNode = &maxParallelExecutionsPerNode
			}
		case "dataFlowProperties":
			if v != nil {
				var dataFlowProperties IntegrationRuntimeDataFlowProperties
				err = json.Unmarshal(*v, &dataFlowProperties)
				if err != nil {
					return err
				}
				ircp.DataFlowProperties = &dataFlowProperties
			}
		case "vNetProperties":
			if v != nil {
				var vNetProperties IntegrationRuntimeVNetProperties
				err = json.Unmarshal(*v, &vNetProperties)
				if err != nil {
					return err
				}
				ircp.VNetProperties = &vNetProperties
			}
		}
	}

	return nil
}

// IntegrationRuntimeConnectionInfo connection information for encrypting the on-premises data source
// credentials.
type IntegrationRuntimeConnectionInfo struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ServiceToken - READ-ONLY; The token generated in service. Callers use this token to authenticate to integration runtime.
	ServiceToken *string `json:"serviceToken,omitempty"`
	// IdentityCertThumbprint - READ-ONLY; The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
	IdentityCertThumbprint *string `json:"identityCertThumbprint,omitempty"`
	// HostServiceURI - READ-ONLY; The on-premises integration runtime host URL.
	HostServiceURI *string `json:"hostServiceUri,omitempty"`
	// Version - READ-ONLY; The integration runtime version.
	Version *string `json:"version,omitempty"`
	// PublicKey - READ-ONLY; The public key for encrypting a credential when transferring the credential to the integration runtime.
	PublicKey *string `json:"publicKey,omitempty"`
	// IsIdentityCertExprired - READ-ONLY; Whether the identity certificate is expired.
	IsIdentityCertExprired *bool `json:"isIdentityCertExprired,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeConnectionInfo.
func (irci IntegrationRuntimeConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range irci.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeConnectionInfo struct.
func (irci *IntegrationRuntimeConnectionInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irci.AdditionalProperties == nil {
					irci.AdditionalProperties = make(map[string]interface{})
				}
				irci.AdditionalProperties[k] = additionalProperties
			}
		case "serviceToken":
			if v != nil {
				var serviceToken string
				err = json.Unmarshal(*v, &serviceToken)
				if err != nil {
					return err
				}
				irci.ServiceToken = &serviceToken
			}
		case "identityCertThumbprint":
			if v != nil {
				var identityCertThumbprint string
				err = json.Unmarshal(*v, &identityCertThumbprint)
				if err != nil {
					return err
				}
				irci.IdentityCertThumbprint = &identityCertThumbprint
			}
		case "hostServiceUri":
			if v != nil {
				var hostServiceURI string
				err = json.Unmarshal(*v, &hostServiceURI)
				if err != nil {
					return err
				}
				irci.HostServiceURI = &hostServiceURI
			}
		case "version":
			if v != nil {
				var version string
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				irci.Version = &version
			}
		case "publicKey":
			if v != nil {
				var publicKey string
				err = json.Unmarshal(*v, &publicKey)
				if err != nil {
					return err
				}
				irci.PublicKey = &publicKey
			}
		case "isIdentityCertExprired":
			if v != nil {
				var isIdentityCertExprired bool
				err = json.Unmarshal(*v, &isIdentityCertExprired)
				if err != nil {
					return err
				}
				irci.IsIdentityCertExprired = &isIdentityCertExprired
			}
		}
	}

	return nil
}

// IntegrationRuntimeCustomSetupScriptProperties custom setup script properties for a managed dedicated
// integration runtime.
type IntegrationRuntimeCustomSetupScriptProperties struct {
	// BlobContainerURI - The URI of the Azure blob container that contains the custom setup script.
	BlobContainerURI *string `json:"blobContainerUri,omitempty"`
	// SasToken - The SAS token of the Azure blob container.
	SasToken *SecureString `json:"sasToken,omitempty"`
}

// IntegrationRuntimeDataFlowProperties data flow properties for managed integration runtime.
type IntegrationRuntimeDataFlowProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ComputeType - Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'
	ComputeType DataFlowComputeType `json:"computeType,omitempty"`
	// CoreCount - Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
	CoreCount *int32 `json:"coreCount,omitempty"`
	// TimeToLive - Time to live (in minutes) setting of the cluster which will execute data flow job.
	TimeToLive *int32 `json:"timeToLive,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeDataFlowProperties.
func (irdfp IntegrationRuntimeDataFlowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irdfp.ComputeType != "" {
		objectMap["computeType"] = irdfp.ComputeType
	}
	if irdfp.CoreCount != nil {
		objectMap["coreCount"] = irdfp.CoreCount
	}
	if irdfp.TimeToLive != nil {
		objectMap["timeToLive"] = irdfp.TimeToLive
	}
	for k, v := range irdfp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeDataFlowProperties struct.
func (irdfp *IntegrationRuntimeDataFlowProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irdfp.AdditionalProperties == nil {
					irdfp.AdditionalProperties = make(map[string]interface{})
				}
				irdfp.AdditionalProperties[k] = additionalProperties
			}
		case "computeType":
			if v != nil {
				var computeType DataFlowComputeType
				err = json.Unmarshal(*v, &computeType)
				if err != nil {
					return err
				}
				irdfp.ComputeType = computeType
			}
		case "coreCount":
			if v != nil {
				var coreCount int32
				err = json.Unmarshal(*v, &coreCount)
				if err != nil {
					return err
				}
				irdfp.CoreCount = &coreCount
			}
		case "timeToLive":
			if v != nil {
				var timeToLive int32
				err = json.Unmarshal(*v, &timeToLive)
				if err != nil {
					return err
				}
				irdfp.TimeToLive = &timeToLive
			}
		}
	}

	return nil
}

// IntegrationRuntimeDataProxyProperties data proxy properties for a managed dedicated integration runtime.
type IntegrationRuntimeDataProxyProperties struct {
	// ConnectVia - The self-hosted integration runtime reference.
	ConnectVia *EntityReference `json:"connectVia,omitempty"`
	// StagingLinkedService - The staging linked service reference.
	StagingLinkedService *EntityReference `json:"stagingLinkedService,omitempty"`
	// Path - The path to contain the staged data in the Blob storage.
	Path *string `json:"path,omitempty"`
}

// IntegrationRuntimeListResponse a list of integration runtime resources.
type IntegrationRuntimeListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of integration runtimes.
	Value *[]IntegrationRuntimeResource `json:"value,omitempty"`
	// NextLink - The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationRuntimeListResponseIterator provides access to a complete listing of
// IntegrationRuntimeResource values.
type IntegrationRuntimeListResponseIterator struct {
	i    int
	page IntegrationRuntimeListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationRuntimeListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationRuntimeListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationRuntimeListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationRuntimeListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationRuntimeListResponseIterator) Response() IntegrationRuntimeListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationRuntimeListResponseIterator) Value() IntegrationRuntimeResource {
	if !iter.page.NotDone() {
		return IntegrationRuntimeResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationRuntimeListResponseIterator type.
func NewIntegrationRuntimeListResponseIterator(page IntegrationRuntimeListResponsePage) IntegrationRuntimeListResponseIterator {
	return IntegrationRuntimeListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (irlr IntegrationRuntimeListResponse) IsEmpty() bool {
	return irlr.Value == nil || len(*irlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (irlr IntegrationRuntimeListResponse) hasNextLink() bool {
	return irlr.NextLink != nil && len(*irlr.NextLink) != 0
}

// integrationRuntimeListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (irlr IntegrationRuntimeListResponse) integrationRuntimeListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !irlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(irlr.NextLink)))
}

// IntegrationRuntimeListResponsePage contains a page of IntegrationRuntimeResource values.
type IntegrationRuntimeListResponsePage struct {
	fn   func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)
	irlr IntegrationRuntimeListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationRuntimeListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationRuntimeListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.irlr)
		if err != nil {
			return err
		}
		page.irlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationRuntimeListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationRuntimeListResponsePage) NotDone() bool {
	return !page.irlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationRuntimeListResponsePage) Response() IntegrationRuntimeListResponse {
	return page.irlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationRuntimeListResponsePage) Values() []IntegrationRuntimeResource {
	if page.irlr.IsEmpty() {
		return nil
	}
	return *page.irlr.Value
}

// Creates a new instance of the IntegrationRuntimeListResponsePage type.
func NewIntegrationRuntimeListResponsePage(cur IntegrationRuntimeListResponse, getNextPage func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)) IntegrationRuntimeListResponsePage {
	return IntegrationRuntimeListResponsePage{
		fn:   getNextPage,
		irlr: cur,
	}
}

// IntegrationRuntimeMonitoringData get monitoring data response.
type IntegrationRuntimeMonitoringData struct {
	autorest.Response `json:"-"`
	// Name - Integration runtime name.
	Name *string `json:"name,omitempty"`
	// Nodes - Integration runtime node monitoring data.
	Nodes *[]IntegrationRuntimeNodeMonitoringData `json:"nodes,omitempty"`
}

// IntegrationRuntimeNodeIPAddress the IP address of self-hosted integration runtime node.
type IntegrationRuntimeNodeIPAddress struct {
	autorest.Response `json:"-"`
	// IPAddress - READ-ONLY; The IP address of self-hosted integration runtime node.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// IntegrationRuntimeNodeMonitoringData monitoring data for integration runtime node.
type IntegrationRuntimeNodeMonitoringData struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// NodeName - READ-ONLY; Name of the integration runtime node.
	NodeName *string `json:"nodeName,omitempty"`
	// AvailableMemoryInMB - READ-ONLY; Available memory (MB) on the integration runtime node.
	AvailableMemoryInMB *int32 `json:"availableMemoryInMB,omitempty"`
	// CPUUtilization - READ-ONLY; CPU percentage on the integration runtime node.
	CPUUtilization *int32 `json:"cpuUtilization,omitempty"`
	// ConcurrentJobsLimit - READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty"`
	// ConcurrentJobsRunning - READ-ONLY; The number of jobs currently running on the integration runtime node.
	ConcurrentJobsRunning *int32 `json:"concurrentJobsRunning,omitempty"`
	// MaxConcurrentJobs - READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32 `json:"maxConcurrentJobs,omitempty"`
	// SentBytes - READ-ONLY; Sent bytes on the integration runtime node.
	SentBytes *float64 `json:"sentBytes,omitempty"`
	// ReceivedBytes - READ-ONLY; Received bytes on the integration runtime node.
	ReceivedBytes *float64 `json:"receivedBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeNodeMonitoringData.
func (irnmd IntegrationRuntimeNodeMonitoringData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range irnmd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeNodeMonitoringData struct.
func (irnmd *IntegrationRuntimeNodeMonitoringData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irnmd.AdditionalProperties == nil {
					irnmd.AdditionalProperties = make(map[string]interface{})
				}
				irnmd.AdditionalProperties[k] = additionalProperties
			}
		case "nodeName":
			if v != nil {
				var nodeName string
				err = json.Unmarshal(*v, &nodeName)
				if err != nil {
					return err
				}
				irnmd.NodeName = &nodeName
			}
		case "availableMemoryInMB":
			if v != nil {
				var availableMemoryInMB int32
				err = json.Unmarshal(*v, &availableMemoryInMB)
				if err != nil {
					return err
				}
				irnmd.AvailableMemoryInMB = &availableMemoryInMB
			}
		case "cpuUtilization":
			if v != nil {
				var CPUUtilization int32
				err = json.Unmarshal(*v, &CPUUtilization)
				if err != nil {
					return err
				}
				irnmd.CPUUtilization = &CPUUtilization
			}
		case "concurrentJobsLimit":
			if v != nil {
				var concurrentJobsLimit int32
				err = json.Unmarshal(*v, &concurrentJobsLimit)
				if err != nil {
					return err
				}
				irnmd.ConcurrentJobsLimit = &concurrentJobsLimit
			}
		case "concurrentJobsRunning":
			if v != nil {
				var concurrentJobsRunning int32
				err = json.Unmarshal(*v, &concurrentJobsRunning)
				if err != nil {
					return err
				}
				irnmd.ConcurrentJobsRunning = &concurrentJobsRunning
			}
		case "maxConcurrentJobs":
			if v != nil {
				var maxConcurrentJobs int32
				err = json.Unmarshal(*v, &maxConcurrentJobs)
				if err != nil {
					return err
				}
				irnmd.MaxConcurrentJobs = &maxConcurrentJobs
			}
		case "sentBytes":
			if v != nil {
				var sentBytes float64
				err = json.Unmarshal(*v, &sentBytes)
				if err != nil {
					return err
				}
				irnmd.SentBytes = &sentBytes
			}
		case "receivedBytes":
			if v != nil {
				var receivedBytes float64
				err = json.Unmarshal(*v, &receivedBytes)
				if err != nil {
					return err
				}
				irnmd.ReceivedBytes = &receivedBytes
			}
		}
	}

	return nil
}

// IntegrationRuntimeObjectMetadataRefreshFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type IntegrationRuntimeObjectMetadataRefreshFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimeObjectMetadataClient) (SsisObjectMetadataStatusResponse, error)
}

// IntegrationRuntimeRegenerateKeyParameters parameters to regenerate the authentication key.
type IntegrationRuntimeRegenerateKeyParameters struct {
	// KeyName - The name of the authentication key to regenerate. Possible values include: 'AuthKey1', 'AuthKey2'
	KeyName IntegrationRuntimeAuthKeyName `json:"keyName,omitempty"`
}

// IntegrationRuntimeResource integration runtime resource type.
type IntegrationRuntimeResource struct {
	autorest.Response `json:"-"`
	// Properties - Integration runtime properties.
	Properties BasicIntegrationRuntime `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeResource.
func (irr IntegrationRuntimeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = irr.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeResource struct.
func (irr *IntegrationRuntimeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicIntegrationRuntime(*v)
				if err != nil {
					return err
				}
				irr.Properties = properties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				irr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irr.Type = &typeVar
			}
		}
	}

	return nil
}

// IntegrationRuntimesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IntegrationRuntimesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (IntegrationRuntimeResource, error)
}

// IntegrationRuntimesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IntegrationRuntimesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (autorest.Response, error)
}

// IntegrationRuntimesDisableInteractiveQueryFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type IntegrationRuntimesDisableInteractiveQueryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (autorest.Response, error)
}

// IntegrationRuntimesEnableInteractiveQueryFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type IntegrationRuntimesEnableInteractiveQueryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (autorest.Response, error)
}

// IntegrationRuntimeSsisCatalogInfo catalog information for managed dedicated integration runtime.
type IntegrationRuntimeSsisCatalogInfo struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// CatalogServerEndpoint - The catalog database server URL.
	CatalogServerEndpoint *string `json:"catalogServerEndpoint,omitempty"`
	// CatalogAdminUserName - The administrator user name of catalog database.
	CatalogAdminUserName *string `json:"catalogAdminUserName,omitempty"`
	// CatalogAdminPassword - The password of the administrator user account of the catalog database.
	CatalogAdminPassword *SecureString `json:"catalogAdminPassword,omitempty"`
	// CatalogPricingTier - The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. Possible values include: 'IntegrationRuntimeSsisCatalogPricingTierBasic', 'IntegrationRuntimeSsisCatalogPricingTierStandard', 'IntegrationRuntimeSsisCatalogPricingTierPremium', 'IntegrationRuntimeSsisCatalogPricingTierPremiumRS'
	CatalogPricingTier IntegrationRuntimeSsisCatalogPricingTier `json:"catalogPricingTier,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeSsisCatalogInfo.
func (irsci IntegrationRuntimeSsisCatalogInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irsci.CatalogServerEndpoint != nil {
		objectMap["catalogServerEndpoint"] = irsci.CatalogServerEndpoint
	}
	if irsci.CatalogAdminUserName != nil {
		objectMap["catalogAdminUserName"] = irsci.CatalogAdminUserName
	}
	if irsci.CatalogAdminPassword != nil {
		objectMap["catalogAdminPassword"] = irsci.CatalogAdminPassword
	}
	if irsci.CatalogPricingTier != "" {
		objectMap["catalogPricingTier"] = irsci.CatalogPricingTier
	}
	for k, v := range irsci.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeSsisCatalogInfo struct.
func (irsci *IntegrationRuntimeSsisCatalogInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irsci.AdditionalProperties == nil {
					irsci.AdditionalProperties = make(map[string]interface{})
				}
				irsci.AdditionalProperties[k] = additionalProperties
			}
		case "catalogServerEndpoint":
			if v != nil {
				var catalogServerEndpoint string
				err = json.Unmarshal(*v, &catalogServerEndpoint)
				if err != nil {
					return err
				}
				irsci.CatalogServerEndpoint = &catalogServerEndpoint
			}
		case "catalogAdminUserName":
			if v != nil {
				var catalogAdminUserName string
				err = json.Unmarshal(*v, &catalogAdminUserName)
				if err != nil {
					return err
				}
				irsci.CatalogAdminUserName = &catalogAdminUserName
			}
		case "catalogAdminPassword":
			if v != nil {
				var catalogAdminPassword SecureString
				err = json.Unmarshal(*v, &catalogAdminPassword)
				if err != nil {
					return err
				}
				irsci.CatalogAdminPassword = &catalogAdminPassword
			}
		case "catalogPricingTier":
			if v != nil {
				var catalogPricingTier IntegrationRuntimeSsisCatalogPricingTier
				err = json.Unmarshal(*v, &catalogPricingTier)
				if err != nil {
					return err
				}
				irsci.CatalogPricingTier = catalogPricingTier
			}
		}
	}

	return nil
}

// IntegrationRuntimeSsisProperties SSIS properties for managed integration runtime.
type IntegrationRuntimeSsisProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// CatalogInfo - Catalog information for managed dedicated integration runtime.
	CatalogInfo *IntegrationRuntimeSsisCatalogInfo `json:"catalogInfo,omitempty"`
	// LicenseType - License type for bringing your own license scenario. Possible values include: 'BasePrice', 'LicenseIncluded'
	LicenseType IntegrationRuntimeLicenseType `json:"licenseType,omitempty"`
	// CustomSetupScriptProperties - Custom setup script properties for a managed dedicated integration runtime.
	CustomSetupScriptProperties *IntegrationRuntimeCustomSetupScriptProperties `json:"customSetupScriptProperties,omitempty"`
	// DataProxyProperties - Data proxy properties for a managed dedicated integration runtime.
	DataProxyProperties *IntegrationRuntimeDataProxyProperties `json:"dataProxyProperties,omitempty"`
	// Edition - The edition for the SSIS Integration Runtime. Possible values include: 'Standard', 'Enterprise'
	Edition IntegrationRuntimeEdition `json:"edition,omitempty"`
	// ExpressCustomSetupProperties - Custom setup without script properties for a SSIS integration runtime.
	ExpressCustomSetupProperties *[]BasicCustomSetupBase `json:"expressCustomSetupProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeSsisProperties.
func (irsp IntegrationRuntimeSsisProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irsp.CatalogInfo != nil {
		objectMap["catalogInfo"] = irsp.CatalogInfo
	}
	if irsp.LicenseType != "" {
		objectMap["licenseType"] = irsp.LicenseType
	}
	if irsp.CustomSetupScriptProperties != nil {
		objectMap["customSetupScriptProperties"] = irsp.CustomSetupScriptProperties
	}
	if irsp.DataProxyProperties != nil {
		objectMap["dataProxyProperties"] = irsp.DataProxyProperties
	}
	if irsp.Edition != "" {
		objectMap["edition"] = irsp.Edition
	}
	if irsp.ExpressCustomSetupProperties != nil {
		objectMap["expressCustomSetupProperties"] = irsp.ExpressCustomSetupProperties
	}
	for k, v := range irsp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeSsisProperties struct.
func (irsp *IntegrationRuntimeSsisProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irsp.AdditionalProperties == nil {
					irsp.AdditionalProperties = make(map[string]interface{})
				}
				irsp.AdditionalProperties[k] = additionalProperties
			}
		case "catalogInfo":
			if v != nil {
				var catalogInfo IntegrationRuntimeSsisCatalogInfo
				err = json.Unmarshal(*v, &catalogInfo)
				if err != nil {
					return err
				}
				irsp.CatalogInfo = &catalogInfo
			}
		case "licenseType":
			if v != nil {
				var licenseType IntegrationRuntimeLicenseType
				err = json.Unmarshal(*v, &licenseType)
				if err != nil {
					return err
				}
				irsp.LicenseType = licenseType
			}
		case "customSetupScriptProperties":
			if v != nil {
				var customSetupScriptProperties IntegrationRuntimeCustomSetupScriptProperties
				err = json.Unmarshal(*v, &customSetupScriptProperties)
				if err != nil {
					return err
				}
				irsp.CustomSetupScriptProperties = &customSetupScriptProperties
			}
		case "dataProxyProperties":
			if v != nil {
				var dataProxyProperties IntegrationRuntimeDataProxyProperties
				err = json.Unmarshal(*v, &dataProxyProperties)
				if err != nil {
					return err
				}
				irsp.DataProxyProperties = &dataProxyProperties
			}
		case "edition":
			if v != nil {
				var edition IntegrationRuntimeEdition
				err = json.Unmarshal(*v, &edition)
				if err != nil {
					return err
				}
				irsp.Edition = edition
			}
		case "expressCustomSetupProperties":
			if v != nil {
				expressCustomSetupProperties, err := unmarshalBasicCustomSetupBaseArray(*v)
				if err != nil {
					return err
				}
				irsp.ExpressCustomSetupProperties = &expressCustomSetupProperties
			}
		}
	}

	return nil
}

// IntegrationRuntimesStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IntegrationRuntimesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (IntegrationRuntimeStatusResponse, error)
}

// IntegrationRuntimesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IntegrationRuntimesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IntegrationRuntimesClient) (autorest.Response, error)
}

// BasicIntegrationRuntimeStatus integration runtime status.
type BasicIntegrationRuntimeStatus interface {
	AsManagedIntegrationRuntimeStatus() (*ManagedIntegrationRuntimeStatus, bool)
	AsSelfHostedIntegrationRuntimeStatus() (*SelfHostedIntegrationRuntimeStatus, bool)
	AsIntegrationRuntimeStatus() (*IntegrationRuntimeStatus, bool)
}

// IntegrationRuntimeStatus integration runtime status.
type IntegrationRuntimeStatus struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// DataFactoryName - READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty"`
	// State - READ-ONLY; The state of integration runtime. Possible values include: 'Initial', 'Stopped', 'Started', 'Starting', 'Stopping', 'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
	State IntegrationRuntimeState `json:"state,omitempty"`
	// Type - Possible values include: 'TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus', 'TypeBasicIntegrationRuntimeStatusTypeManaged', 'TypeBasicIntegrationRuntimeStatusTypeSelfHosted'
	Type TypeBasicIntegrationRuntimeStatus `json:"type,omitempty"`
}

func unmarshalBasicIntegrationRuntimeStatus(body []byte) (BasicIntegrationRuntimeStatus, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicIntegrationRuntimeStatusTypeManaged):
		var mirs ManagedIntegrationRuntimeStatus
		err := json.Unmarshal(body, &mirs)
		return mirs, err
	case string(TypeBasicIntegrationRuntimeStatusTypeSelfHosted):
		var shirs SelfHostedIntegrationRuntimeStatus
		err := json.Unmarshal(body, &shirs)
		return shirs, err
	default:
		var irs IntegrationRuntimeStatus
		err := json.Unmarshal(body, &irs)
		return irs, err
	}
}
func unmarshalBasicIntegrationRuntimeStatusArray(body []byte) ([]BasicIntegrationRuntimeStatus, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	irsArray := make([]BasicIntegrationRuntimeStatus, len(rawMessages))

	for index, rawMessage := range rawMessages {
		irs, err := unmarshalBasicIntegrationRuntimeStatus(*rawMessage)
		if err != nil {
			return nil, err
		}
		irsArray[index] = irs
	}
	return irsArray, nil
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeStatus.
func (irs IntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	irs.Type = TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus
	objectMap := make(map[string]interface{})
	if irs.Type != "" {
		objectMap["type"] = irs.Type
	}
	for k, v := range irs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for IntegrationRuntimeStatus.
func (irs IntegrationRuntimeStatus) AsManagedIntegrationRuntimeStatus() (*ManagedIntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsSelfHostedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for IntegrationRuntimeStatus.
func (irs IntegrationRuntimeStatus) AsSelfHostedIntegrationRuntimeStatus() (*SelfHostedIntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for IntegrationRuntimeStatus.
func (irs IntegrationRuntimeStatus) AsIntegrationRuntimeStatus() (*IntegrationRuntimeStatus, bool) {
	return &irs, true
}

// AsBasicIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for IntegrationRuntimeStatus.
func (irs IntegrationRuntimeStatus) AsBasicIntegrationRuntimeStatus() (BasicIntegrationRuntimeStatus, bool) {
	return &irs, true
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeStatus struct.
func (irs *IntegrationRuntimeStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irs.AdditionalProperties == nil {
					irs.AdditionalProperties = make(map[string]interface{})
				}
				irs.AdditionalProperties[k] = additionalProperties
			}
		case "dataFactoryName":
			if v != nil {
				var dataFactoryName string
				err = json.Unmarshal(*v, &dataFactoryName)
				if err != nil {
					return err
				}
				irs.DataFactoryName = &dataFactoryName
			}
		case "state":
			if v != nil {
				var state IntegrationRuntimeState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				irs.State = state
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicIntegrationRuntimeStatus
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irs.Type = typeVar
			}
		}
	}

	return nil
}

// IntegrationRuntimeStatusResponse integration runtime status response.
type IntegrationRuntimeStatusResponse struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The integration runtime name.
	Name *string `json:"name,omitempty"`
	// Properties - Integration runtime properties.
	Properties BasicIntegrationRuntimeStatus `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeStatusResponse.
func (irsr IntegrationRuntimeStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = irsr.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeStatusResponse struct.
func (irsr *IntegrationRuntimeStatusResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irsr.Name = &name
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicIntegrationRuntimeStatus(*v)
				if err != nil {
					return err
				}
				irsr.Properties = properties
			}
		}
	}

	return nil
}

// IntegrationRuntimeVNetProperties vNet properties for managed integration runtime.
type IntegrationRuntimeVNetProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// VNetID - The ID of the VNet that this integration runtime will join.
	VNetID *string `json:"vNetId,omitempty"`
	// Subnet - The name of the subnet this integration runtime will join.
	Subnet *string `json:"subnet,omitempty"`
	// PublicIPs - Resource IDs of the public IP addresses that this integration runtime will use.
	PublicIPs *[]string `json:"publicIPs,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationRuntimeVNetProperties.
func (irvnp IntegrationRuntimeVNetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irvnp.VNetID != nil {
		objectMap["vNetId"] = irvnp.VNetID
	}
	if irvnp.Subnet != nil {
		objectMap["subnet"] = irvnp.Subnet
	}
	if irvnp.PublicIPs != nil {
		objectMap["publicIPs"] = irvnp.PublicIPs
	}
	for k, v := range irvnp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationRuntimeVNetProperties struct.
func (irvnp *IntegrationRuntimeVNetProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if irvnp.AdditionalProperties == nil {
					irvnp.AdditionalProperties = make(map[string]interface{})
				}
				irvnp.AdditionalProperties[k] = additionalProperties
			}
		case "vNetId":
			if v != nil {
				var vNetID string
				err = json.Unmarshal(*v, &vNetID)
				if err != nil {
					return err
				}
				irvnp.VNetID = &vNetID
			}
		case "subnet":
			if v != nil {
				var subnet string
				err = json.Unmarshal(*v, &subnet)
				if err != nil {
					return err
				}
				irvnp.Subnet = &subnet
			}
		case "publicIPs":
			if v != nil {
				var publicIPs []string
				err = json.Unmarshal(*v, &publicIPs)
				if err != nil {
					return err
				}
				irvnp.PublicIPs = &publicIPs
			}
		}
	}

	return nil
}

// IPFirewallRuleInfo IP firewall rule
type IPFirewallRuleInfo struct {
	autorest.Response `json:"-"`
	// IPFirewallRuleProperties - IP firewall rule properties
	*IPFirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IPFirewallRuleInfo.
func (ifri IPFirewallRuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifri.IPFirewallRuleProperties != nil {
		objectMap["properties"] = ifri.IPFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPFirewallRuleInfo struct.
func (ifri *IPFirewallRuleInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPFirewallRuleProperties IPFirewallRuleProperties
				err = json.Unmarshal(*v, &IPFirewallRuleProperties)
				if err != nil {
					return err
				}
				ifri.IPFirewallRuleProperties = &IPFirewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifri.Type = &typeVar
			}
		}
	}

	return nil
}

// IPFirewallRuleInfoListResult list of IP firewall rules
type IPFirewallRuleInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of IP firewall rules
	Value *[]IPFirewallRuleInfo `json:"value,omitempty"`
}

// IPFirewallRuleInfoListResultIterator provides access to a complete listing of IPFirewallRuleInfo values.
type IPFirewallRuleInfoListResultIterator struct {
	i    int
	page IPFirewallRuleInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPFirewallRuleInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFirewallRuleInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IPFirewallRuleInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPFirewallRuleInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPFirewallRuleInfoListResultIterator) Response() IPFirewallRuleInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPFirewallRuleInfoListResultIterator) Value() IPFirewallRuleInfo {
	if !iter.page.NotDone() {
		return IPFirewallRuleInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IPFirewallRuleInfoListResultIterator type.
func NewIPFirewallRuleInfoListResultIterator(page IPFirewallRuleInfoListResultPage) IPFirewallRuleInfoListResultIterator {
	return IPFirewallRuleInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifrilr IPFirewallRuleInfoListResult) IsEmpty() bool {
	return ifrilr.Value == nil || len(*ifrilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifrilr IPFirewallRuleInfoListResult) hasNextLink() bool {
	return ifrilr.NextLink != nil && len(*ifrilr.NextLink) != 0
}

// iPFirewallRuleInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifrilr IPFirewallRuleInfoListResult) iPFirewallRuleInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ifrilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifrilr.NextLink)))
}

// IPFirewallRuleInfoListResultPage contains a page of IPFirewallRuleInfo values.
type IPFirewallRuleInfoListResultPage struct {
	fn     func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)
	ifrilr IPFirewallRuleInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPFirewallRuleInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFirewallRuleInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifrilr)
		if err != nil {
			return err
		}
		page.ifrilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IPFirewallRuleInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPFirewallRuleInfoListResultPage) NotDone() bool {
	return !page.ifrilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPFirewallRuleInfoListResultPage) Response() IPFirewallRuleInfoListResult {
	return page.ifrilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPFirewallRuleInfoListResultPage) Values() []IPFirewallRuleInfo {
	if page.ifrilr.IsEmpty() {
		return nil
	}
	return *page.ifrilr.Value
}

// Creates a new instance of the IPFirewallRuleInfoListResultPage type.
func NewIPFirewallRuleInfoListResultPage(cur IPFirewallRuleInfoListResult, getNextPage func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)) IPFirewallRuleInfoListResultPage {
	return IPFirewallRuleInfoListResultPage{
		fn:     getNextPage,
		ifrilr: cur,
	}
}

// IPFirewallRuleProperties IP firewall rule properties
type IPFirewallRuleProperties struct {
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
	EndIPAddress *string `json:"endIpAddress,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state. Possible values include: 'ProvisioningStateProvisioning', 'ProvisioningStateSucceeded', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateDeleteError'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for IPFirewallRuleProperties.
func (ifrp IPFirewallRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifrp.EndIPAddress != nil {
		objectMap["endIpAddress"] = ifrp.EndIPAddress
	}
	if ifrp.StartIPAddress != nil {
		objectMap["startIpAddress"] = ifrp.StartIPAddress
	}
	return json.Marshal(objectMap)
}

// IPFirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IPFirewallRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IPFirewallRulesClient) (IPFirewallRuleInfo, error)
}

// IPFirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IPFirewallRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IPFirewallRulesClient) (SetObject, error)
}

// IPFirewallRulesReplaceAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IPFirewallRulesReplaceAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IPFirewallRulesClient) (ReplaceAllFirewallRulesOperationResponse, error)
}

// Key a workspace key
type Key struct {
	autorest.Response `json:"-"`
	// KeyProperties - Keys resource properties
	*KeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Key.
func (kVar Key) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kVar.KeyProperties != nil {
		objectMap["properties"] = kVar.KeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Key struct.
func (kVar *Key) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var keyProperties KeyProperties
				err = json.Unmarshal(*v, &keyProperties)
				if err != nil {
					return err
				}
				kVar.KeyProperties = &keyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				kVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				kVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				kVar.Type = &typeVar
			}
		}
	}

	return nil
}

// KeyInfoListResult list of keys
type KeyInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of keys
	Value *[]Key `json:"value,omitempty"`
}

// KeyInfoListResultIterator provides access to a complete listing of Key values.
type KeyInfoListResultIterator struct {
	i    int
	page KeyInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KeyInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *KeyInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KeyInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KeyInfoListResultIterator) Response() KeyInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KeyInfoListResultIterator) Value() Key {
	if !iter.page.NotDone() {
		return Key{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the KeyInfoListResultIterator type.
func NewKeyInfoListResultIterator(page KeyInfoListResultPage) KeyInfoListResultIterator {
	return KeyInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (kilr KeyInfoListResult) IsEmpty() bool {
	return kilr.Value == nil || len(*kilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (kilr KeyInfoListResult) hasNextLink() bool {
	return kilr.NextLink != nil && len(*kilr.NextLink) != 0
}

// keyInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (kilr KeyInfoListResult) keyInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !kilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(kilr.NextLink)))
}

// KeyInfoListResultPage contains a page of Key values.
type KeyInfoListResultPage struct {
	fn   func(context.Context, KeyInfoListResult) (KeyInfoListResult, error)
	kilr KeyInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KeyInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.kilr)
		if err != nil {
			return err
		}
		page.kilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *KeyInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KeyInfoListResultPage) NotDone() bool {
	return !page.kilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KeyInfoListResultPage) Response() KeyInfoListResult {
	return page.kilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KeyInfoListResultPage) Values() []Key {
	if page.kilr.IsEmpty() {
		return nil
	}
	return *page.kilr.Value
}

// Creates a new instance of the KeyInfoListResultPage type.
func NewKeyInfoListResultPage(cur KeyInfoListResult, getNextPage func(context.Context, KeyInfoListResult) (KeyInfoListResult, error)) KeyInfoListResultPage {
	return KeyInfoListResultPage{
		fn:   getNextPage,
		kilr: cur,
	}
}

// KeyProperties key properties
type KeyProperties struct {
	// IsActiveCMK - Used to activate the workspace after a customer managed key is provided.
	IsActiveCMK *bool `json:"isActiveCMK,omitempty"`
	// KeyVaultURL - The Key Vault Url of the workspace key.
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`
}

// LibraryRequirements library requirements for a Big Data pool powered by Apache Spark
type LibraryRequirements struct {
	// Time - READ-ONLY; The last update time of the library requirements file.
	Time *date.Time `json:"time,omitempty"`
	// Content - The library requirements.
	Content *string `json:"content,omitempty"`
	// Filename - The filename of the library requirements file.
	Filename *string `json:"filename,omitempty"`
}

// MarshalJSON is the custom marshaler for LibraryRequirements.
func (lr LibraryRequirements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.Content != nil {
		objectMap["content"] = lr.Content
	}
	if lr.Filename != nil {
		objectMap["filename"] = lr.Filename
	}
	return json.Marshal(objectMap)
}

// LicensedComponentSetupTypeProperties installation of licensed component setup type properties.
type LicensedComponentSetupTypeProperties struct {
	// ComponentName - The name of the 3rd party component.
	ComponentName *string `json:"componentName,omitempty"`
	// LicenseKey - The license key to activate the component.
	LicenseKey BasicSecretBase `json:"licenseKey,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for LicensedComponentSetupTypeProperties struct.
func (lcstp *LicensedComponentSetupTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "componentName":
			if v != nil {
				var componentName string
				err = json.Unmarshal(*v, &componentName)
				if err != nil {
					return err
				}
				lcstp.ComponentName = &componentName
			}
		case "licenseKey":
			if v != nil {
				licenseKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				lcstp.LicenseKey = licenseKey
			}
		}
	}

	return nil
}

// LinkedIntegrationRuntime the linked integration runtime information.
type LinkedIntegrationRuntime struct {
	// Name - READ-ONLY; The name of the linked integration runtime.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - READ-ONLY; The subscription ID for which the linked integration runtime belong to.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DataFactoryName - READ-ONLY; The name of the workspace for which the linked integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty"`
	// DataFactoryLocation - READ-ONLY; The location of the workspace for which the linked integration runtime belong to.
	DataFactoryLocation *string `json:"dataFactoryLocation,omitempty"`
	// CreateTime - READ-ONLY; The creating time of the linked integration runtime.
	CreateTime *date.Time `json:"createTime,omitempty"`
}

// LinkedIntegrationRuntimeKeyAuthorization the key authorization type integration runtime.
type LinkedIntegrationRuntimeKeyAuthorization struct {
	// Key - The key used for authorization.
	Key *SecureString `json:"key,omitempty"`
	// AuthorizationType - Possible values include: 'AuthorizationTypeLinkedIntegrationRuntimeType', 'AuthorizationTypeKey', 'AuthorizationTypeRBAC'
	AuthorizationType AuthorizationType `json:"authorizationType,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedIntegrationRuntimeKeyAuthorization.
func (lirka LinkedIntegrationRuntimeKeyAuthorization) MarshalJSON() ([]byte, error) {
	lirka.AuthorizationType = AuthorizationTypeKey
	objectMap := make(map[string]interface{})
	if lirka.Key != nil {
		objectMap["key"] = lirka.Key
	}
	if lirka.AuthorizationType != "" {
		objectMap["authorizationType"] = lirka.AuthorizationType
	}
	return json.Marshal(objectMap)
}

// AsLinkedIntegrationRuntimeKeyAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeKeyAuthorization.
func (lirka LinkedIntegrationRuntimeKeyAuthorization) AsLinkedIntegrationRuntimeKeyAuthorization() (*LinkedIntegrationRuntimeKeyAuthorization, bool) {
	return &lirka, true
}

// AsLinkedIntegrationRuntimeRbacAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeKeyAuthorization.
func (lirka LinkedIntegrationRuntimeKeyAuthorization) AsLinkedIntegrationRuntimeRbacAuthorization() (*LinkedIntegrationRuntimeRbacAuthorization, bool) {
	return nil, false
}

// AsLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeKeyAuthorization.
func (lirka LinkedIntegrationRuntimeKeyAuthorization) AsLinkedIntegrationRuntimeType() (*LinkedIntegrationRuntimeType, bool) {
	return nil, false
}

// AsBasicLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeKeyAuthorization.
func (lirka LinkedIntegrationRuntimeKeyAuthorization) AsBasicLinkedIntegrationRuntimeType() (BasicLinkedIntegrationRuntimeType, bool) {
	return &lirka, true
}

// LinkedIntegrationRuntimeRbacAuthorization the role based access control (RBAC) authorization type
// integration runtime.
type LinkedIntegrationRuntimeRbacAuthorization struct {
	// ResourceID - The resource identifier of the integration runtime to be shared.
	ResourceID *string `json:"resourceId,omitempty"`
	// AuthorizationType - Possible values include: 'AuthorizationTypeLinkedIntegrationRuntimeType', 'AuthorizationTypeKey', 'AuthorizationTypeRBAC'
	AuthorizationType AuthorizationType `json:"authorizationType,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedIntegrationRuntimeRbacAuthorization.
func (lirra LinkedIntegrationRuntimeRbacAuthorization) MarshalJSON() ([]byte, error) {
	lirra.AuthorizationType = AuthorizationTypeRBAC
	objectMap := make(map[string]interface{})
	if lirra.ResourceID != nil {
		objectMap["resourceId"] = lirra.ResourceID
	}
	if lirra.AuthorizationType != "" {
		objectMap["authorizationType"] = lirra.AuthorizationType
	}
	return json.Marshal(objectMap)
}

// AsLinkedIntegrationRuntimeKeyAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeRbacAuthorization.
func (lirra LinkedIntegrationRuntimeRbacAuthorization) AsLinkedIntegrationRuntimeKeyAuthorization() (*LinkedIntegrationRuntimeKeyAuthorization, bool) {
	return nil, false
}

// AsLinkedIntegrationRuntimeRbacAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeRbacAuthorization.
func (lirra LinkedIntegrationRuntimeRbacAuthorization) AsLinkedIntegrationRuntimeRbacAuthorization() (*LinkedIntegrationRuntimeRbacAuthorization, bool) {
	return &lirra, true
}

// AsLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeRbacAuthorization.
func (lirra LinkedIntegrationRuntimeRbacAuthorization) AsLinkedIntegrationRuntimeType() (*LinkedIntegrationRuntimeType, bool) {
	return nil, false
}

// AsBasicLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeRbacAuthorization.
func (lirra LinkedIntegrationRuntimeRbacAuthorization) AsBasicLinkedIntegrationRuntimeType() (BasicLinkedIntegrationRuntimeType, bool) {
	return &lirra, true
}

// BasicLinkedIntegrationRuntimeType the base definition of a linked integration runtime.
type BasicLinkedIntegrationRuntimeType interface {
	AsLinkedIntegrationRuntimeKeyAuthorization() (*LinkedIntegrationRuntimeKeyAuthorization, bool)
	AsLinkedIntegrationRuntimeRbacAuthorization() (*LinkedIntegrationRuntimeRbacAuthorization, bool)
	AsLinkedIntegrationRuntimeType() (*LinkedIntegrationRuntimeType, bool)
}

// LinkedIntegrationRuntimeType the base definition of a linked integration runtime.
type LinkedIntegrationRuntimeType struct {
	// AuthorizationType - Possible values include: 'AuthorizationTypeLinkedIntegrationRuntimeType', 'AuthorizationTypeKey', 'AuthorizationTypeRBAC'
	AuthorizationType AuthorizationType `json:"authorizationType,omitempty"`
}

func unmarshalBasicLinkedIntegrationRuntimeType(body []byte) (BasicLinkedIntegrationRuntimeType, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["authorizationType"] {
	case string(AuthorizationTypeKey):
		var lirka LinkedIntegrationRuntimeKeyAuthorization
		err := json.Unmarshal(body, &lirka)
		return lirka, err
	case string(AuthorizationTypeRBAC):
		var lirra LinkedIntegrationRuntimeRbacAuthorization
		err := json.Unmarshal(body, &lirra)
		return lirra, err
	default:
		var lirt LinkedIntegrationRuntimeType
		err := json.Unmarshal(body, &lirt)
		return lirt, err
	}
}
func unmarshalBasicLinkedIntegrationRuntimeTypeArray(body []byte) ([]BasicLinkedIntegrationRuntimeType, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lirtArray := make([]BasicLinkedIntegrationRuntimeType, len(rawMessages))

	for index, rawMessage := range rawMessages {
		lirt, err := unmarshalBasicLinkedIntegrationRuntimeType(*rawMessage)
		if err != nil {
			return nil, err
		}
		lirtArray[index] = lirt
	}
	return lirtArray, nil
}

// MarshalJSON is the custom marshaler for LinkedIntegrationRuntimeType.
func (lirt LinkedIntegrationRuntimeType) MarshalJSON() ([]byte, error) {
	lirt.AuthorizationType = AuthorizationTypeLinkedIntegrationRuntimeType
	objectMap := make(map[string]interface{})
	if lirt.AuthorizationType != "" {
		objectMap["authorizationType"] = lirt.AuthorizationType
	}
	return json.Marshal(objectMap)
}

// AsLinkedIntegrationRuntimeKeyAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeType.
func (lirt LinkedIntegrationRuntimeType) AsLinkedIntegrationRuntimeKeyAuthorization() (*LinkedIntegrationRuntimeKeyAuthorization, bool) {
	return nil, false
}

// AsLinkedIntegrationRuntimeRbacAuthorization is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeType.
func (lirt LinkedIntegrationRuntimeType) AsLinkedIntegrationRuntimeRbacAuthorization() (*LinkedIntegrationRuntimeRbacAuthorization, bool) {
	return nil, false
}

// AsLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeType.
func (lirt LinkedIntegrationRuntimeType) AsLinkedIntegrationRuntimeType() (*LinkedIntegrationRuntimeType, bool) {
	return &lirt, true
}

// AsBasicLinkedIntegrationRuntimeType is the BasicLinkedIntegrationRuntimeType implementation for LinkedIntegrationRuntimeType.
func (lirt LinkedIntegrationRuntimeType) AsBasicLinkedIntegrationRuntimeType() (BasicLinkedIntegrationRuntimeType, bool) {
	return &lirt, true
}

// ListAvailableRpOperation ...
type ListAvailableRpOperation struct {
	autorest.Response `json:"-"`
	Value             *[]AvailableRpOperation `json:"value,omitempty"`
}

// ListSQLPoolSecurityAlertPolicies a list of SQL pool security alert policies.
type ListSQLPoolSecurityAlertPolicies struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListSQLPoolSecurityAlertPoliciesIterator provides access to a complete listing of
// SQLPoolSecurityAlertPolicy values.
type ListSQLPoolSecurityAlertPoliciesIterator struct {
	i    int
	page ListSQLPoolSecurityAlertPoliciesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListSQLPoolSecurityAlertPoliciesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListSQLPoolSecurityAlertPoliciesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListSQLPoolSecurityAlertPoliciesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListSQLPoolSecurityAlertPoliciesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListSQLPoolSecurityAlertPoliciesIterator) Response() ListSQLPoolSecurityAlertPolicies {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListSQLPoolSecurityAlertPoliciesIterator) Value() SQLPoolSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return SQLPoolSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListSQLPoolSecurityAlertPoliciesIterator type.
func NewListSQLPoolSecurityAlertPoliciesIterator(page ListSQLPoolSecurityAlertPoliciesPage) ListSQLPoolSecurityAlertPoliciesIterator {
	return ListSQLPoolSecurityAlertPoliciesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lspsap ListSQLPoolSecurityAlertPolicies) IsEmpty() bool {
	return lspsap.Value == nil || len(*lspsap.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lspsap ListSQLPoolSecurityAlertPolicies) hasNextLink() bool {
	return lspsap.NextLink != nil && len(*lspsap.NextLink) != 0
}

// listSQLPoolSecurityAlertPoliciesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lspsap ListSQLPoolSecurityAlertPolicies) listSQLPoolSecurityAlertPoliciesPreparer(ctx context.Context) (*http.Request, error) {
	if !lspsap.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lspsap.NextLink)))
}

// ListSQLPoolSecurityAlertPoliciesPage contains a page of SQLPoolSecurityAlertPolicy values.
type ListSQLPoolSecurityAlertPoliciesPage struct {
	fn     func(context.Context, ListSQLPoolSecurityAlertPolicies) (ListSQLPoolSecurityAlertPolicies, error)
	lspsap ListSQLPoolSecurityAlertPolicies
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListSQLPoolSecurityAlertPoliciesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListSQLPoolSecurityAlertPoliciesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lspsap)
		if err != nil {
			return err
		}
		page.lspsap = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListSQLPoolSecurityAlertPoliciesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListSQLPoolSecurityAlertPoliciesPage) NotDone() bool {
	return !page.lspsap.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListSQLPoolSecurityAlertPoliciesPage) Response() ListSQLPoolSecurityAlertPolicies {
	return page.lspsap
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListSQLPoolSecurityAlertPoliciesPage) Values() []SQLPoolSecurityAlertPolicy {
	if page.lspsap.IsEmpty() {
		return nil
	}
	return *page.lspsap.Value
}

// Creates a new instance of the ListSQLPoolSecurityAlertPoliciesPage type.
func NewListSQLPoolSecurityAlertPoliciesPage(cur ListSQLPoolSecurityAlertPolicies, getNextPage func(context.Context, ListSQLPoolSecurityAlertPolicies) (ListSQLPoolSecurityAlertPolicies, error)) ListSQLPoolSecurityAlertPoliciesPage {
	return ListSQLPoolSecurityAlertPoliciesPage{
		fn:     getNextPage,
		lspsap: cur,
	}
}

// ManagedIdentity the workspace managed identity
type ManagedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the workspace managed identity
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the workspace managed identity
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Type - The type of managed identity for the workspace. Possible values include: 'ResourceIdentityTypeNone', 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIdentity.
func (mi ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Type != "" {
		objectMap["type"] = mi.Type
	}
	return json.Marshal(objectMap)
}

// ManagedIdentitySQLControlSettingsModel sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModel struct {
	autorest.Response `json:"-"`
	// ManagedIdentitySQLControlSettingsModelProperties - Sql Control Settings for workspace managed identity
	*ManagedIdentitySQLControlSettingsModelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIdentitySQLControlSettingsModel.
func (miscsm ManagedIdentitySQLControlSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miscsm.ManagedIdentitySQLControlSettingsModelProperties != nil {
		objectMap["properties"] = miscsm.ManagedIdentitySQLControlSettingsModelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedIdentitySQLControlSettingsModel struct.
func (miscsm *ManagedIdentitySQLControlSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedIdentitySQLControlSettingsModelProperties ManagedIdentitySQLControlSettingsModelProperties
				err = json.Unmarshal(*v, &managedIdentitySQLControlSettingsModelProperties)
				if err != nil {
					return err
				}
				miscsm.ManagedIdentitySQLControlSettingsModelProperties = &managedIdentitySQLControlSettingsModelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miscsm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miscsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miscsm.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedIdentitySQLControlSettingsModelProperties sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModelProperties struct {
	// GrantSQLControlToManagedIdentity - Grant sql control to managed identity
	GrantSQLControlToManagedIdentity *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity `json:"grantSqlControlToManagedIdentity,omitempty"`
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity grant sql control to
// managed identity
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity struct {
	// DesiredState - Desired state. Possible values include: 'DesiredStateEnabled', 'DesiredStateDisabled'
	DesiredState DesiredState `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Actual state. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Unknown'
	ActualState ActualState `json:"actualState,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity.
func (miscsmSctmi ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miscsmSctmi.DesiredState != "" {
		objectMap["desiredState"] = miscsmSctmi.DesiredState
	}
	return json.Marshal(objectMap)
}

// ManagedIntegrationRuntime managed integration runtime, including managed elastic and managed dedicated
// integration runtimes.
type ManagedIntegrationRuntime struct {
	// State - READ-ONLY; Integration runtime state, only valid for managed dedicated integration runtime. Possible values include: 'Initial', 'Stopped', 'Started', 'Starting', 'Stopping', 'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
	State IntegrationRuntimeState `json:"state,omitempty"`
	// ManagedIntegrationRuntimeTypeProperties - Managed integration runtime properties.
	*ManagedIntegrationRuntimeTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Integration runtime description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeIntegrationRuntime', 'TypeManaged', 'TypeSelfHosted'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIntegrationRuntime.
func (mir ManagedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	mir.Type = TypeManaged
	objectMap := make(map[string]interface{})
	if mir.ManagedIntegrationRuntimeTypeProperties != nil {
		objectMap["typeProperties"] = mir.ManagedIntegrationRuntimeTypeProperties
	}
	if mir.Description != nil {
		objectMap["description"] = mir.Description
	}
	if mir.Type != "" {
		objectMap["type"] = mir.Type
	}
	for k, v := range mir.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntime is the BasicIntegrationRuntime implementation for ManagedIntegrationRuntime.
func (mir ManagedIntegrationRuntime) AsManagedIntegrationRuntime() (*ManagedIntegrationRuntime, bool) {
	return &mir, true
}

// AsSelfHostedIntegrationRuntime is the BasicIntegrationRuntime implementation for ManagedIntegrationRuntime.
func (mir ManagedIntegrationRuntime) AsSelfHostedIntegrationRuntime() (*SelfHostedIntegrationRuntime, bool) {
	return nil, false
}

// AsIntegrationRuntime is the BasicIntegrationRuntime implementation for ManagedIntegrationRuntime.
func (mir ManagedIntegrationRuntime) AsIntegrationRuntime() (*IntegrationRuntime, bool) {
	return nil, false
}

// AsBasicIntegrationRuntime is the BasicIntegrationRuntime implementation for ManagedIntegrationRuntime.
func (mir ManagedIntegrationRuntime) AsBasicIntegrationRuntime() (BasicIntegrationRuntime, bool) {
	return &mir, true
}

// UnmarshalJSON is the custom unmarshaler for ManagedIntegrationRuntime struct.
func (mir *ManagedIntegrationRuntime) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "state":
			if v != nil {
				var state IntegrationRuntimeState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mir.State = state
			}
		case "typeProperties":
			if v != nil {
				var managedIntegrationRuntimeTypeProperties ManagedIntegrationRuntimeTypeProperties
				err = json.Unmarshal(*v, &managedIntegrationRuntimeTypeProperties)
				if err != nil {
					return err
				}
				mir.ManagedIntegrationRuntimeTypeProperties = &managedIntegrationRuntimeTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mir.AdditionalProperties == nil {
					mir.AdditionalProperties = make(map[string]interface{})
				}
				mir.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mir.Description = &description
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mir.Type = typeVar
			}
		}
	}

	return nil
}

// ManagedIntegrationRuntimeError error definition for managed integration runtime.
type ManagedIntegrationRuntimeError struct {
	// Time - READ-ONLY; The time when the error occurred.
	Time *date.Time `json:"time,omitempty"`
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Parameters - READ-ONLY; Managed integration runtime error parameters.
	Parameters *[]string `json:"parameters,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
}

// ManagedIntegrationRuntimeNode properties of integration runtime node.
type ManagedIntegrationRuntimeNode struct {
	// NodeID - READ-ONLY; The managed integration runtime node id.
	NodeID *string `json:"nodeId,omitempty"`
	// Status - READ-ONLY; The managed integration runtime node status. Possible values include: 'ManagedIntegrationRuntimeNodeStatusStarting', 'ManagedIntegrationRuntimeNodeStatusAvailable', 'ManagedIntegrationRuntimeNodeStatusRecycling', 'ManagedIntegrationRuntimeNodeStatusUnavailable'
	Status ManagedIntegrationRuntimeNodeStatus `json:"status,omitempty"`
	// Errors - The errors that occurred on this integration runtime node.
	Errors *[]ManagedIntegrationRuntimeError `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIntegrationRuntimeNode.
func (mirn ManagedIntegrationRuntimeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mirn.Errors != nil {
		objectMap["errors"] = mirn.Errors
	}
	return json.Marshal(objectMap)
}

// ManagedIntegrationRuntimeOperationResult properties of managed integration runtime operation result.
type ManagedIntegrationRuntimeOperationResult struct {
	// Type - READ-ONLY; The operation type. Could be start or stop.
	Type *string `json:"type,omitempty"`
	// StartTime - READ-ONLY; The start time of the operation.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Result - READ-ONLY; The operation result.
	Result *string `json:"result,omitempty"`
	// ErrorCode - READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Parameters - READ-ONLY; Managed integration runtime error parameters.
	Parameters *[]string `json:"parameters,omitempty"`
	// ActivityID - READ-ONLY; The activity id for the operation request.
	ActivityID *string `json:"activityId,omitempty"`
}

// ManagedIntegrationRuntimeStatus managed integration runtime status.
type ManagedIntegrationRuntimeStatus struct {
	// ManagedIntegrationRuntimeStatusTypeProperties - Managed integration runtime status type properties.
	*ManagedIntegrationRuntimeStatusTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// DataFactoryName - READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty"`
	// State - READ-ONLY; The state of integration runtime. Possible values include: 'Initial', 'Stopped', 'Started', 'Starting', 'Stopping', 'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
	State IntegrationRuntimeState `json:"state,omitempty"`
	// Type - Possible values include: 'TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus', 'TypeBasicIntegrationRuntimeStatusTypeManaged', 'TypeBasicIntegrationRuntimeStatusTypeSelfHosted'
	Type TypeBasicIntegrationRuntimeStatus `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIntegrationRuntimeStatus.
func (mirs ManagedIntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	mirs.Type = TypeBasicIntegrationRuntimeStatusTypeManaged
	objectMap := make(map[string]interface{})
	if mirs.ManagedIntegrationRuntimeStatusTypeProperties != nil {
		objectMap["typeProperties"] = mirs.ManagedIntegrationRuntimeStatusTypeProperties
	}
	if mirs.Type != "" {
		objectMap["type"] = mirs.Type
	}
	for k, v := range mirs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for ManagedIntegrationRuntimeStatus.
func (mirs ManagedIntegrationRuntimeStatus) AsManagedIntegrationRuntimeStatus() (*ManagedIntegrationRuntimeStatus, bool) {
	return &mirs, true
}

// AsSelfHostedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for ManagedIntegrationRuntimeStatus.
func (mirs ManagedIntegrationRuntimeStatus) AsSelfHostedIntegrationRuntimeStatus() (*SelfHostedIntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for ManagedIntegrationRuntimeStatus.
func (mirs ManagedIntegrationRuntimeStatus) AsIntegrationRuntimeStatus() (*IntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsBasicIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for ManagedIntegrationRuntimeStatus.
func (mirs ManagedIntegrationRuntimeStatus) AsBasicIntegrationRuntimeStatus() (BasicIntegrationRuntimeStatus, bool) {
	return &mirs, true
}

// UnmarshalJSON is the custom unmarshaler for ManagedIntegrationRuntimeStatus struct.
func (mirs *ManagedIntegrationRuntimeStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var managedIntegrationRuntimeStatusTypeProperties ManagedIntegrationRuntimeStatusTypeProperties
				err = json.Unmarshal(*v, &managedIntegrationRuntimeStatusTypeProperties)
				if err != nil {
					return err
				}
				mirs.ManagedIntegrationRuntimeStatusTypeProperties = &managedIntegrationRuntimeStatusTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mirs.AdditionalProperties == nil {
					mirs.AdditionalProperties = make(map[string]interface{})
				}
				mirs.AdditionalProperties[k] = additionalProperties
			}
		case "dataFactoryName":
			if v != nil {
				var dataFactoryName string
				err = json.Unmarshal(*v, &dataFactoryName)
				if err != nil {
					return err
				}
				mirs.DataFactoryName = &dataFactoryName
			}
		case "state":
			if v != nil {
				var state IntegrationRuntimeState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mirs.State = state
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicIntegrationRuntimeStatus
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mirs.Type = typeVar
			}
		}
	}

	return nil
}

// ManagedIntegrationRuntimeStatusTypeProperties managed integration runtime status type properties.
type ManagedIntegrationRuntimeStatusTypeProperties struct {
	// CreateTime - READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// Nodes - READ-ONLY; The list of nodes for managed integration runtime.
	Nodes *[]ManagedIntegrationRuntimeNode `json:"nodes,omitempty"`
	// OtherErrors - READ-ONLY; The errors that occurred on this integration runtime.
	OtherErrors *[]ManagedIntegrationRuntimeError `json:"otherErrors,omitempty"`
	// LastOperation - READ-ONLY; The last operation result that occurred on this integration runtime.
	LastOperation *ManagedIntegrationRuntimeOperationResult `json:"lastOperation,omitempty"`
}

// ManagedIntegrationRuntimeTypeProperties managed integration runtime type properties.
type ManagedIntegrationRuntimeTypeProperties struct {
	// ComputeProperties - The compute resource for managed integration runtime.
	ComputeProperties *IntegrationRuntimeComputeProperties `json:"computeProperties,omitempty"`
	// SsisProperties - SSIS properties for managed integration runtime.
	SsisProperties *IntegrationRuntimeSsisProperties `json:"ssisProperties,omitempty"`
}

// ManagedVirtualNetworkSettings managed Virtual Network Settings
type ManagedVirtualNetworkSettings struct {
	// PreventDataExfiltration - Prevent Data Exfiltration
	PreventDataExfiltration *bool `json:"preventDataExfiltration,omitempty"`
	// LinkedAccessCheckOnTargetResource - Linked Access Check On Target Resource
	LinkedAccessCheckOnTargetResource *bool `json:"linkedAccessCheckOnTargetResource,omitempty"`
	// AllowedAadTenantIdsForLinking - Allowed Aad Tenant Ids For Linking
	AllowedAadTenantIdsForLinking *[]string `json:"allowedAadTenantIdsForLinking,omitempty"`
}

// MetadataSyncConfig configuration for metadata sync
type MetadataSyncConfig struct {
	autorest.Response `json:"-"`
	// MetadataSyncConfigProperties - Metadata Sync Config properties
	*MetadataSyncConfigProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MetadataSyncConfig.
func (msc MetadataSyncConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msc.MetadataSyncConfigProperties != nil {
		objectMap["properties"] = msc.MetadataSyncConfigProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetadataSyncConfig struct.
func (msc *MetadataSyncConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var metadataSyncConfigProperties MetadataSyncConfigProperties
				err = json.Unmarshal(*v, &metadataSyncConfigProperties)
				if err != nil {
					return err
				}
				msc.MetadataSyncConfigProperties = &metadataSyncConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msc.Type = &typeVar
			}
		}
	}

	return nil
}

// MetadataSyncConfigProperties metadata Sync Config properties
type MetadataSyncConfigProperties struct {
	// Enabled - Indicates whether the metadata sync is enabled or disabled
	Enabled *bool `json:"enabled,omitempty"`
	// SyncIntervalInMinutes - The Sync Interval in minutes.
	SyncIntervalInMinutes *int32 `json:"syncIntervalInMinutes,omitempty"`
}

// OperationMetaLogSpecification what is this?
type OperationMetaLogSpecification struct {
	// DisplayName - Log display name
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Time range the log covers
	BlobDuration *string `json:"blobDuration,omitempty"`
	// Name - Log unique name
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricDimensionSpecification what is this?
type OperationMetaMetricDimensionSpecification struct {
	// DisplayName - Dimension display name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Dimension unique name
	Name *string `json:"name,omitempty"`
	// ToBeExportedForShoebox - Whether this metric should be exported for Shoebox
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// OperationMetaMetricSpecification what is this?
type OperationMetaMetricSpecification struct {
	// SourceMdmNamespace - The source MDM namespace
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// DisplayName - Metric display name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Metric unique name
	Name *string `json:"name,omitempty"`
	// AggregationType - Metric aggregation type
	AggregationType *string `json:"aggregationType,omitempty"`
	// DisplayDescription - Metric description
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// SourceMdmAccount - The source MDM account
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// EnableRegionalMdmAccount - Whether the regional MDM account is enabled
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// Unit - Metric units
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Metric dimensions
	Dimensions *[]OperationMetaMetricDimensionSpecification `json:"dimensions,omitempty"`
	// SupportsInstanceLevelAggregation - Whether the metric supports instance-level aggregation
	SupportsInstanceLevelAggregation *bool `json:"supportsInstanceLevelAggregation,omitempty"`
	// MetricFilterPattern - Metric filter
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`
}

// OperationMetaPropertyInfo what is this?
type OperationMetaPropertyInfo struct {
	// ServiceSpecification - Operation service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationMetaServiceSpecification what is this?
type OperationMetaServiceSpecification struct {
	// MetricSpecifications - Service metric specifications
	MetricSpecifications *[]OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
	// LogSpecifications - Service log specifications
	LogSpecifications *[]OperationMetaLogSpecification `json:"logSpecifications,omitempty"`
}

// OperationResource an operation
type OperationResource struct {
	autorest.Response `json:"-"`
	// ID - Operation ID
	ID *string `json:"id,omitempty"`
	// Name - Operation name
	Name *string `json:"name,omitempty"`
	// Status - Operation status. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed', 'OperationStatusCanceled'
	Status OperationStatus `json:"status,omitempty"`
	// Properties - Operation properties
	Properties interface{} `json:"properties,omitempty"`
	// Error - Errors from the operation
	Error *ErrorDetail `json:"error,omitempty"`
	// StartTime - Operation start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Operation start time
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - Completion percentage of the operation
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// PrivateEndpoint private endpoint details
type PrivateEndpoint struct {
	// ID - READ-ONLY; Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Private endpoint connection properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionForPrivateLinkHub ...
type PrivateEndpointConnectionForPrivateLinkHub struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; identifier
	ID *string `json:"id,omitempty"`
	// PrivateEndpointConnectionProperties - Properties of private endpoint connection for private link hub
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionForPrivateLinkHub.
func (pecfplh PrivateEndpointConnectionForPrivateLinkHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecfplh.Name != nil {
		objectMap["name"] = pecfplh.Name
	}
	if pecfplh.Type != nil {
		objectMap["type"] = pecfplh.Type
	}
	if pecfplh.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pecfplh.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionForPrivateLinkHub struct.
func (pecfplh *PrivateEndpointConnectionForPrivateLinkHub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pecfplh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pecfplh.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pecfplh.ID = &ID
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pecfplh.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionForPrivateLinkHubBasic private Endpoint Connection For Private Link Hub - Basic
type PrivateEndpointConnectionForPrivateLinkHubBasic struct {
	// ID - READ-ONLY; identifier
	ID *string `json:"id,omitempty"`
	// PrivateEndpointConnectionProperties - Properties of private endpoint connection for private link hub
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionForPrivateLinkHubBasic.
func (pecfplhb PrivateEndpointConnectionForPrivateLinkHubBasic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecfplhb.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pecfplhb.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionForPrivateLinkHubBasic struct.
func (pecfplhb *PrivateEndpointConnectionForPrivateLinkHubBasic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pecfplhb.ID = &ID
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pecfplhb.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse ...
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse struct {
	autorest.Response `json:"-"`
	Value             *[]PrivateEndpointConnectionForPrivateLinkHub `json:"value,omitempty"`
	NextLink          *string                                       `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator provides access to a
// complete listing of PrivateEndpointConnectionForPrivateLinkHub values.
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator struct {
	i    int
	page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator) Response() PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator) Value() PrivateEndpointConnectionForPrivateLinkHub {
	if !iter.page.NotDone() {
		return PrivateEndpointConnectionForPrivateLinkHub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator type.
func NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator(page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator {
	return PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pecfplhRcr PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) IsEmpty() bool {
	return pecfplhRcr.Value == nil || len(*pecfplhRcr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pecfplhRcr PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) hasNextLink() bool {
	return pecfplhRcr.NextLink != nil && len(*pecfplhRcr.NextLink) != 0
}

// privateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pecfplhRcr PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) privateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !pecfplhRcr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pecfplhRcr.NextLink)))
}

// PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage contains a page of
// PrivateEndpointConnectionForPrivateLinkHub values.
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage struct {
	fn         func(context.Context, PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) (PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, error)
	pecfplhrcr PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pecfplhrcr)
		if err != nil {
			return err
		}
		page.pecfplhrcr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) NotDone() bool {
	return !page.pecfplhrcr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) Response() PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse {
	return page.pecfplhrcr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) Values() []PrivateEndpointConnectionForPrivateLinkHub {
	if page.pecfplhrcr.IsEmpty() {
		return nil
	}
	return *page.pecfplhrcr.Value
}

// Creates a new instance of the PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage type.
func NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage(cur PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, getNextPage func(context.Context, PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) (PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, error)) PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage {
	return PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage{
		fn:         getNextPage,
		pecfplhrcr: cur,
	}
}

// PrivateEndpointConnectionList a list of private endpoint connections
type PrivateEndpointConnectionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListIterator provides access to a complete listing of PrivateEndpointConnection
// values.
type PrivateEndpointConnectionListIterator struct {
	i    int
	page PrivateEndpointConnectionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListIterator) Response() PrivateEndpointConnectionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListIterator type.
func NewPrivateEndpointConnectionListIterator(page PrivateEndpointConnectionListPage) PrivateEndpointConnectionListIterator {
	return PrivateEndpointConnectionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pecl PrivateEndpointConnectionList) IsEmpty() bool {
	return pecl.Value == nil || len(*pecl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pecl PrivateEndpointConnectionList) hasNextLink() bool {
	return pecl.NextLink != nil && len(*pecl.NextLink) != 0
}

// privateEndpointConnectionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pecl PrivateEndpointConnectionList) privateEndpointConnectionListPreparer(ctx context.Context) (*http.Request, error) {
	if !pecl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pecl.NextLink)))
}

// PrivateEndpointConnectionListPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListPage struct {
	fn   func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)
	pecl PrivateEndpointConnectionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pecl)
		if err != nil {
			return err
		}
		page.pecl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListPage) NotDone() bool {
	return !page.pecl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListPage) Response() PrivateEndpointConnectionList {
	return page.pecl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListPage) Values() []PrivateEndpointConnection {
	if page.pecl.IsEmpty() {
		return nil
	}
	return *page.pecl.Value
}

// Creates a new instance of the PrivateEndpointConnectionListPage type.
func NewPrivateEndpointConnectionListPage(cur PrivateEndpointConnectionList, getNextPage func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)) PrivateEndpointConnectionListPage {
	return PrivateEndpointConnectionListPage{
		fn:   getNextPage,
		pecl: cur,
	}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (OperationResource, error)
}

// PrivateLinkHub a privateLinkHub
type PrivateLinkHub struct {
	autorest.Response `json:"-"`
	// PrivateLinkHubProperties - PrivateLinkHub resource properties
	*PrivateLinkHubProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkHub.
func (plh PrivateLinkHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plh.PrivateLinkHubProperties != nil {
		objectMap["properties"] = plh.PrivateLinkHubProperties
	}
	if plh.Tags != nil {
		objectMap["tags"] = plh.Tags
	}
	if plh.Location != nil {
		objectMap["location"] = plh.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkHub struct.
func (plh *PrivateLinkHub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkHubProperties PrivateLinkHubProperties
				err = json.Unmarshal(*v, &privateLinkHubProperties)
				if err != nil {
					return err
				}
				plh.PrivateLinkHubProperties = &privateLinkHubProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plh.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				plh.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plh.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkHubInfoListResult list of privateLinkHubs
type PrivateLinkHubInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of privateLinkHubs
	Value *[]PrivateLinkHub `json:"value,omitempty"`
}

// PrivateLinkHubInfoListResultIterator provides access to a complete listing of PrivateLinkHub values.
type PrivateLinkHubInfoListResultIterator struct {
	i    int
	page PrivateLinkHubInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkHubInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkHubInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkHubInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkHubInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkHubInfoListResultIterator) Response() PrivateLinkHubInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkHubInfoListResultIterator) Value() PrivateLinkHub {
	if !iter.page.NotDone() {
		return PrivateLinkHub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkHubInfoListResultIterator type.
func NewPrivateLinkHubInfoListResultIterator(page PrivateLinkHubInfoListResultPage) PrivateLinkHubInfoListResultIterator {
	return PrivateLinkHubInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plhilr PrivateLinkHubInfoListResult) IsEmpty() bool {
	return plhilr.Value == nil || len(*plhilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plhilr PrivateLinkHubInfoListResult) hasNextLink() bool {
	return plhilr.NextLink != nil && len(*plhilr.NextLink) != 0
}

// privateLinkHubInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plhilr PrivateLinkHubInfoListResult) privateLinkHubInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plhilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plhilr.NextLink)))
}

// PrivateLinkHubInfoListResultPage contains a page of PrivateLinkHub values.
type PrivateLinkHubInfoListResultPage struct {
	fn     func(context.Context, PrivateLinkHubInfoListResult) (PrivateLinkHubInfoListResult, error)
	plhilr PrivateLinkHubInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkHubInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkHubInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plhilr)
		if err != nil {
			return err
		}
		page.plhilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkHubInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkHubInfoListResultPage) NotDone() bool {
	return !page.plhilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkHubInfoListResultPage) Response() PrivateLinkHubInfoListResult {
	return page.plhilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkHubInfoListResultPage) Values() []PrivateLinkHub {
	if page.plhilr.IsEmpty() {
		return nil
	}
	return *page.plhilr.Value
}

// Creates a new instance of the PrivateLinkHubInfoListResultPage type.
func NewPrivateLinkHubInfoListResultPage(cur PrivateLinkHubInfoListResult, getNextPage func(context.Context, PrivateLinkHubInfoListResult) (PrivateLinkHubInfoListResult, error)) PrivateLinkHubInfoListResultPage {
	return PrivateLinkHubInfoListResultPage{
		fn:     getNextPage,
		plhilr: cur,
	}
}

// PrivateLinkHubPatchInfo privateLinkHub patch details
type PrivateLinkHubPatchInfo struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkHubPatchInfo.
func (plhpi PrivateLinkHubPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plhpi.Tags != nil {
		objectMap["tags"] = plhpi.Tags
	}
	return json.Marshal(objectMap)
}

// PrivateLinkHubProperties privateLinkHub properties
type PrivateLinkHubProperties struct {
	// ProvisioningState - PrivateLinkHub provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections
	PrivateEndpointConnections *[]PrivateEndpointConnectionForPrivateLinkHubBasic `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkHubProperties.
func (plhp PrivateLinkHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plhp.ProvisioningState != nil {
		objectMap["provisioningState"] = plhp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// PrivateLinkHubsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateLinkHubsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkHubsClient) (autorest.Response, error)
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; The private link resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkServiceConnectionState connection state details of the private endpoint
type PrivateLinkServiceConnectionState struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionState.
func (plscs PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscs.Status != nil {
		objectMap["status"] = plscs.Status
	}
	if plscs.Description != nil {
		objectMap["description"] = plscs.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// PurviewConfiguration purview Configuration
type PurviewConfiguration struct {
	// PurviewResourceID - Purview Resource ID
	PurviewResourceID *string `json:"purviewResourceId,omitempty"`
}

// QueryInterval a database query.
type QueryInterval struct {
	// IntervalStartTime - READ-ONLY; The start time of the measurement interval (ISO8601 format).
	IntervalStartTime *date.Time `json:"intervalStartTime,omitempty"`
	// ExecutionCount - READ-ONLY; The number of times the query was executed during this interval.
	ExecutionCount *float64 `json:"executionCount,omitempty"`
	// Metrics - READ-ONLY; The list of query metrics during this interval.
	Metrics *[]QueryMetric `json:"metrics,omitempty"`
}

// QueryMetric a database query.
type QueryMetric struct {
	// Name - READ-ONLY; The name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The name of the metric for display in user interface
	DisplayName *string `json:"displayName,omitempty"`
	// Unit - READ-ONLY; The unit of measurement. Possible values include: 'Percentage', 'KB', 'Microseconds'
	Unit QueryMetricUnit `json:"unit,omitempty"`
	// Value - READ-ONLY; The measured value
	Value *float64 `json:"value,omitempty"`
}

// QueryStatistic a database query.
type QueryStatistic struct {
	// QueryID - READ-ONLY; The id of the query
	QueryID *string `json:"queryId,omitempty"`
	// Intervals - READ-ONLY; The list of query intervals.
	Intervals *[]QueryInterval `json:"intervals,omitempty"`
}

// RecoverableSQLPool a recoverable sql pool
type RecoverableSQLPool struct {
	autorest.Response `json:"-"`
	// RecoverableSQLPoolProperties - The properties of a recoverable sql pool
	*RecoverableSQLPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableSQLPool.
func (rsp RecoverableSQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsp.RecoverableSQLPoolProperties != nil {
		objectMap["properties"] = rsp.RecoverableSQLPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableSQLPool struct.
func (rsp *RecoverableSQLPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableSQLPoolProperties RecoverableSQLPoolProperties
				err = json.Unmarshal(*v, &recoverableSQLPoolProperties)
				if err != nil {
					return err
				}
				rsp.RecoverableSQLPoolProperties = &recoverableSQLPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsp.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableSQLPoolListResult the response to a list recoverable sql pools request
type RecoverableSQLPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of recoverable sql pool
	Value *[]RecoverableSQLPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoverableSQLPoolListResultIterator provides access to a complete listing of RecoverableSQLPool values.
type RecoverableSQLPoolListResultIterator struct {
	i    int
	page RecoverableSQLPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoverableSQLPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableSQLPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoverableSQLPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoverableSQLPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoverableSQLPoolListResultIterator) Response() RecoverableSQLPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoverableSQLPoolListResultIterator) Value() RecoverableSQLPool {
	if !iter.page.NotDone() {
		return RecoverableSQLPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoverableSQLPoolListResultIterator type.
func NewRecoverableSQLPoolListResultIterator(page RecoverableSQLPoolListResultPage) RecoverableSQLPoolListResultIterator {
	return RecoverableSQLPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsplr RecoverableSQLPoolListResult) IsEmpty() bool {
	return rsplr.Value == nil || len(*rsplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rsplr RecoverableSQLPoolListResult) hasNextLink() bool {
	return rsplr.NextLink != nil && len(*rsplr.NextLink) != 0
}

// recoverableSQLPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsplr RecoverableSQLPoolListResult) recoverableSQLPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rsplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsplr.NextLink)))
}

// RecoverableSQLPoolListResultPage contains a page of RecoverableSQLPool values.
type RecoverableSQLPoolListResultPage struct {
	fn    func(context.Context, RecoverableSQLPoolListResult) (RecoverableSQLPoolListResult, error)
	rsplr RecoverableSQLPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoverableSQLPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableSQLPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rsplr)
		if err != nil {
			return err
		}
		page.rsplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoverableSQLPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoverableSQLPoolListResultPage) NotDone() bool {
	return !page.rsplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoverableSQLPoolListResultPage) Response() RecoverableSQLPoolListResult {
	return page.rsplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoverableSQLPoolListResultPage) Values() []RecoverableSQLPool {
	if page.rsplr.IsEmpty() {
		return nil
	}
	return *page.rsplr.Value
}

// Creates a new instance of the RecoverableSQLPoolListResultPage type.
func NewRecoverableSQLPoolListResultPage(cur RecoverableSQLPoolListResult, getNextPage func(context.Context, RecoverableSQLPoolListResult) (RecoverableSQLPoolListResult, error)) RecoverableSQLPoolListResultPage {
	return RecoverableSQLPoolListResultPage{
		fn:    getNextPage,
		rsplr: cur,
	}
}

// RecoverableSQLPoolProperties the properties of a recoverable sql pool
type RecoverableSQLPoolProperties struct {
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// LastAvailableBackupDate - READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// ReplaceAllFirewallRulesOperationResponse an existing operation for replacing the firewall rules
type ReplaceAllFirewallRulesOperationResponse struct {
	autorest.Response `json:"-"`
	// OperationID - The operation ID
	OperationID *string `json:"operationId,omitempty"`
}

// ReplaceAllIPFirewallRulesRequest replace all IP firewall rules request
type ReplaceAllIPFirewallRulesRequest struct {
	// IPFirewallRules - IP firewall rule properties
	IPFirewallRules map[string]*IPFirewallRuleProperties `json:"ipFirewallRules"`
}

// MarshalJSON is the custom marshaler for ReplaceAllIPFirewallRulesRequest.
func (raifrr ReplaceAllIPFirewallRulesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if raifrr.IPFirewallRules != nil {
		objectMap["ipFirewallRules"] = raifrr.IPFirewallRules
	}
	return json.Marshal(objectMap)
}

// ReplicationLink represents a Sql pool replication link.
type ReplicationLink struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Location of the workspace that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List Sql pool replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Sql pool replication links housed in the Sql pool.
	Value *[]ReplicationLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLinkListResult.
func (rllr ReplicationLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rllr.Value != nil {
		objectMap["value"] = rllr.Value
	}
	return json.Marshal(objectMap)
}

// ReplicationLinkListResultIterator provides access to a complete listing of ReplicationLink values.
type ReplicationLinkListResultIterator struct {
	i    int
	page ReplicationLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationLinkListResultIterator) Response() ReplicationLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationLinkListResultIterator) Value() ReplicationLink {
	if !iter.page.NotDone() {
		return ReplicationLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationLinkListResultIterator type.
func NewReplicationLinkListResultIterator(page ReplicationLinkListResultPage) ReplicationLinkListResultIterator {
	return ReplicationLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rllr ReplicationLinkListResult) IsEmpty() bool {
	return rllr.Value == nil || len(*rllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rllr ReplicationLinkListResult) hasNextLink() bool {
	return rllr.NextLink != nil && len(*rllr.NextLink) != 0
}

// replicationLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rllr ReplicationLinkListResult) replicationLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rllr.NextLink)))
}

// ReplicationLinkListResultPage contains a page of ReplicationLink values.
type ReplicationLinkListResultPage struct {
	fn   func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)
	rllr ReplicationLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rllr)
		if err != nil {
			return err
		}
		page.rllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationLinkListResultPage) NotDone() bool {
	return !page.rllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationLinkListResultPage) Response() ReplicationLinkListResult {
	return page.rllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationLinkListResultPage) Values() []ReplicationLink {
	if page.rllr.IsEmpty() {
		return nil
	}
	return *page.rllr.Value
}

// Creates a new instance of the ReplicationLinkListResultPage type.
func NewReplicationLinkListResultPage(cur ReplicationLinkListResult, getNextPage func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)) ReplicationLinkListResultPage {
	return ReplicationLinkListResultPage{
		fn:   getNextPage,
		rllr: cur,
	}
}

// ReplicationLinkProperties represents the properties of a Sql pool replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - READ-ONLY; Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - READ-ONLY; The name of the workspace hosting the partner Sql pool.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - READ-ONLY; The name of the partner Sql pool.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - READ-ONLY; The Azure Region of the partner Sql pool.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - READ-ONLY; The role of the Sql pool in the replication link. Possible values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source', 'Copy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - READ-ONLY; The role of the partner Sql pool in the replication link. Possible values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source', 'Copy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - READ-ONLY; The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - READ-ONLY; The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// RestorableDroppedSQLPool a restorable dropped Sql pool
type RestorableDroppedSQLPool struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// RestorableDroppedSQLPoolProperties - The properties of a restorable dropped Sql pool
	*RestorableDroppedSQLPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedSQLPool.
func (rdsp RestorableDroppedSQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdsp.RestorableDroppedSQLPoolProperties != nil {
		objectMap["properties"] = rdsp.RestorableDroppedSQLPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedSQLPool struct.
func (rdsp *RestorableDroppedSQLPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdsp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorableDroppedSQLPoolProperties RestorableDroppedSQLPoolProperties
				err = json.Unmarshal(*v, &restorableDroppedSQLPoolProperties)
				if err != nil {
					return err
				}
				rdsp.RestorableDroppedSQLPoolProperties = &restorableDroppedSQLPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdsp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedSQLPoolListResult the response to a list restorable dropped Sql pools request
type RestorableDroppedSQLPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of restorable dropped Sql pools
	Value *[]RestorableDroppedSQLPool `json:"value,omitempty"`
}

// RestorableDroppedSQLPoolProperties the properties of a restorable dropped Sql pool
type RestorableDroppedSQLPoolProperties struct {
	// DatabaseName - READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// MaxSizeBytes - READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorePoint database restore points.
type RestorePoint struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// RestorePointProperties - Resource properties.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult a list of long term retention backups.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorePoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointListResultIterator provides access to a complete listing of RestorePoint values.
type RestorePointListResultIterator struct {
	i    int
	page RestorePointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorePointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorePointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorePointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorePointListResultIterator) Response() RestorePointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorePointListResultIterator) Value() RestorePoint {
	if !iter.page.NotDone() {
		return RestorePoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorePointListResultIterator type.
func NewRestorePointListResultIterator(page RestorePointListResultPage) RestorePointListResultIterator {
	return RestorePointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rplr RestorePointListResult) IsEmpty() bool {
	return rplr.Value == nil || len(*rplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rplr RestorePointListResult) hasNextLink() bool {
	return rplr.NextLink != nil && len(*rplr.NextLink) != 0
}

// restorePointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rplr RestorePointListResult) restorePointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rplr.NextLink)))
}

// RestorePointListResultPage contains a page of RestorePoint values.
type RestorePointListResultPage struct {
	fn   func(context.Context, RestorePointListResult) (RestorePointListResult, error)
	rplr RestorePointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorePointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rplr)
		if err != nil {
			return err
		}
		page.rplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorePointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorePointListResultPage) NotDone() bool {
	return !page.rplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorePointListResultPage) Response() RestorePointListResult {
	return page.rplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorePointListResultPage) Values() []RestorePoint {
	if page.rplr.IsEmpty() {
		return nil
	}
	return *page.rplr.Value
}

// Creates a new instance of the RestorePointListResultPage type.
func NewRestorePointListResultPage(cur RestorePointListResult, getNextPage func(context.Context, RestorePointListResult) (RestorePointListResult, error)) RestorePointListResultPage {
	return RestorePointListResultPage{
		fn:   getNextPage,
		rplr: cur,
	}
}

// RestorePointProperties properties of a database restore point
type RestorePointProperties struct {
	// RestorePointType - READ-ONLY; The type of restore point. Possible values include: 'CONTINUOUS', 'DISCRETE'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// RestorePointCreationDate - READ-ONLY; The time the backup was taken
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// RestorePointLabel - READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// BasicSecretBase the base definition of a secret type.
type BasicSecretBase interface {
	AsSecureString() (*SecureString, bool)
	AsSecretBase() (*SecretBase, bool)
}

// SecretBase the base definition of a secret type.
type SecretBase struct {
	// Type - Possible values include: 'TypeSecretBase', 'TypeSecureString'
	Type TypeBasicSecretBase `json:"type,omitempty"`
}

func unmarshalBasicSecretBase(body []byte) (BasicSecretBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeSecureString):
		var ss SecureString
		err := json.Unmarshal(body, &ss)
		return ss, err
	default:
		var sb SecretBase
		err := json.Unmarshal(body, &sb)
		return sb, err
	}
}
func unmarshalBasicSecretBaseArray(body []byte) ([]BasicSecretBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sbArray := make([]BasicSecretBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sb, err := unmarshalBasicSecretBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		sbArray[index] = sb
	}
	return sbArray, nil
}

// MarshalJSON is the custom marshaler for SecretBase.
func (sb SecretBase) MarshalJSON() ([]byte, error) {
	sb.Type = TypeSecretBase
	objectMap := make(map[string]interface{})
	if sb.Type != "" {
		objectMap["type"] = sb.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureString is the BasicSecretBase implementation for SecretBase.
func (sb SecretBase) AsSecureString() (*SecureString, bool) {
	return nil, false
}

// AsSecretBase is the BasicSecretBase implementation for SecretBase.
func (sb SecretBase) AsSecretBase() (*SecretBase, bool) {
	return &sb, true
}

// AsBasicSecretBase is the BasicSecretBase implementation for SecretBase.
func (sb SecretBase) AsBasicSecretBase() (BasicSecretBase, bool) {
	return &sb, true
}

// SecureString azure Synapse secure string definition. The string value will be masked with asterisks '*'
// during Get or List API calls.
type SecureString struct {
	// Value - Value of secure string.
	Value *string `json:"value,omitempty"`
	// Type - Possible values include: 'TypeSecretBase', 'TypeSecureString'
	Type TypeBasicSecretBase `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureString.
func (ss SecureString) MarshalJSON() ([]byte, error) {
	ss.Type = TypeSecureString
	objectMap := make(map[string]interface{})
	if ss.Value != nil {
		objectMap["value"] = ss.Value
	}
	if ss.Type != "" {
		objectMap["type"] = ss.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureString is the BasicSecretBase implementation for SecureString.
func (ss SecureString) AsSecureString() (*SecureString, bool) {
	return &ss, true
}

// AsSecretBase is the BasicSecretBase implementation for SecureString.
func (ss SecureString) AsSecretBase() (*SecretBase, bool) {
	return nil, false
}

// AsBasicSecretBase is the BasicSecretBase implementation for SecureString.
func (ss SecureString) AsBasicSecretBase() (BasicSecretBase, bool) {
	return &ss, true
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific Sql pool. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertPolicyProperties.
func (sapp SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sapp.State != "" {
		objectMap["state"] = sapp.State
	}
	if sapp.DisabledAlerts != nil {
		objectMap["disabledAlerts"] = sapp.DisabledAlerts
	}
	if sapp.EmailAddresses != nil {
		objectMap["emailAddresses"] = sapp.EmailAddresses
	}
	if sapp.EmailAccountAdmins != nil {
		objectMap["emailAccountAdmins"] = sapp.EmailAccountAdmins
	}
	if sapp.StorageEndpoint != nil {
		objectMap["storageEndpoint"] = sapp.StorageEndpoint
	}
	if sapp.StorageAccountAccessKey != nil {
		objectMap["storageAccountAccessKey"] = sapp.StorageAccountAccessKey
	}
	if sapp.RetentionDays != nil {
		objectMap["retentionDays"] = sapp.RetentionDays
	}
	return json.Marshal(objectMap)
}

// SelfHostedIntegrationRuntime self-hosted integration runtime.
type SelfHostedIntegrationRuntime struct {
	// SelfHostedIntegrationRuntimeTypeProperties - When this property is not null, means this is a linked integration runtime. The property is used to access original integration runtime.
	*SelfHostedIntegrationRuntimeTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Integration runtime description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeIntegrationRuntime', 'TypeManaged', 'TypeSelfHosted'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelfHostedIntegrationRuntime.
func (shir SelfHostedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	shir.Type = TypeSelfHosted
	objectMap := make(map[string]interface{})
	if shir.SelfHostedIntegrationRuntimeTypeProperties != nil {
		objectMap["typeProperties"] = shir.SelfHostedIntegrationRuntimeTypeProperties
	}
	if shir.Description != nil {
		objectMap["description"] = shir.Description
	}
	if shir.Type != "" {
		objectMap["type"] = shir.Type
	}
	for k, v := range shir.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntime is the BasicIntegrationRuntime implementation for SelfHostedIntegrationRuntime.
func (shir SelfHostedIntegrationRuntime) AsManagedIntegrationRuntime() (*ManagedIntegrationRuntime, bool) {
	return nil, false
}

// AsSelfHostedIntegrationRuntime is the BasicIntegrationRuntime implementation for SelfHostedIntegrationRuntime.
func (shir SelfHostedIntegrationRuntime) AsSelfHostedIntegrationRuntime() (*SelfHostedIntegrationRuntime, bool) {
	return &shir, true
}

// AsIntegrationRuntime is the BasicIntegrationRuntime implementation for SelfHostedIntegrationRuntime.
func (shir SelfHostedIntegrationRuntime) AsIntegrationRuntime() (*IntegrationRuntime, bool) {
	return nil, false
}

// AsBasicIntegrationRuntime is the BasicIntegrationRuntime implementation for SelfHostedIntegrationRuntime.
func (shir SelfHostedIntegrationRuntime) AsBasicIntegrationRuntime() (BasicIntegrationRuntime, bool) {
	return &shir, true
}

// UnmarshalJSON is the custom unmarshaler for SelfHostedIntegrationRuntime struct.
func (shir *SelfHostedIntegrationRuntime) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var selfHostedIntegrationRuntimeTypeProperties SelfHostedIntegrationRuntimeTypeProperties
				err = json.Unmarshal(*v, &selfHostedIntegrationRuntimeTypeProperties)
				if err != nil {
					return err
				}
				shir.SelfHostedIntegrationRuntimeTypeProperties = &selfHostedIntegrationRuntimeTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if shir.AdditionalProperties == nil {
					shir.AdditionalProperties = make(map[string]interface{})
				}
				shir.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				shir.Description = &description
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				shir.Type = typeVar
			}
		}
	}

	return nil
}

// SelfHostedIntegrationRuntimeNode properties of Self-hosted integration runtime node.
type SelfHostedIntegrationRuntimeNode struct {
	autorest.Response `json:"-"`
	// NodeName - READ-ONLY; Name of the integration runtime node.
	NodeName *string `json:"nodeName,omitempty"`
	// MachineName - READ-ONLY; Machine name of the integration runtime node.
	MachineName *string `json:"machineName,omitempty"`
	// HostServiceURI - READ-ONLY; URI for the host machine of the integration runtime.
	HostServiceURI *string `json:"hostServiceUri,omitempty"`
	// Status - READ-ONLY; Status of the integration runtime node. Possible values include: 'SelfHostedIntegrationRuntimeNodeStatusNeedRegistration', 'SelfHostedIntegrationRuntimeNodeStatusOnline', 'SelfHostedIntegrationRuntimeNodeStatusLimited', 'SelfHostedIntegrationRuntimeNodeStatusOffline', 'SelfHostedIntegrationRuntimeNodeStatusUpgrading', 'SelfHostedIntegrationRuntimeNodeStatusInitializing', 'SelfHostedIntegrationRuntimeNodeStatusInitializeFailed'
	Status SelfHostedIntegrationRuntimeNodeStatus `json:"status,omitempty"`
	// Capabilities - READ-ONLY; The integration runtime capabilities dictionary
	Capabilities map[string]*string `json:"capabilities"`
	// VersionStatus - READ-ONLY; Status of the integration runtime node version.
	VersionStatus *string `json:"versionStatus,omitempty"`
	// Version - READ-ONLY; Version of the integration runtime node.
	Version *string `json:"version,omitempty"`
	// RegisterTime - READ-ONLY; The time at which the integration runtime node was registered in ISO8601 format.
	RegisterTime *date.Time `json:"registerTime,omitempty"`
	// LastConnectTime - READ-ONLY; The most recent time at which the integration runtime was connected in ISO8601 format.
	LastConnectTime *date.Time `json:"lastConnectTime,omitempty"`
	// ExpiryTime - READ-ONLY; The time at which the integration runtime will expire in ISO8601 format.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// LastStartTime - READ-ONLY; The time the node last started up.
	LastStartTime *date.Time `json:"lastStartTime,omitempty"`
	// LastStopTime - READ-ONLY; The integration runtime node last stop time.
	LastStopTime *date.Time `json:"lastStopTime,omitempty"`
	// LastUpdateResult - READ-ONLY; The result of the last integration runtime node update. Possible values include: 'None', 'Succeed', 'Fail'
	LastUpdateResult IntegrationRuntimeUpdateResult `json:"lastUpdateResult,omitempty"`
	// LastStartUpdateTime - READ-ONLY; The last time for the integration runtime node update start.
	LastStartUpdateTime *date.Time `json:"lastStartUpdateTime,omitempty"`
	// LastEndUpdateTime - READ-ONLY; The last time for the integration runtime node update end.
	LastEndUpdateTime *date.Time `json:"lastEndUpdateTime,omitempty"`
	// IsActiveDispatcher - READ-ONLY; Indicates whether this node is the active dispatcher for integration runtime requests.
	IsActiveDispatcher *bool `json:"isActiveDispatcher,omitempty"`
	// ConcurrentJobsLimit - READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty"`
	// MaxConcurrentJobs - READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32 `json:"maxConcurrentJobs,omitempty"`
}

// MarshalJSON is the custom marshaler for SelfHostedIntegrationRuntimeNode.
func (shirn SelfHostedIntegrationRuntimeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SelfHostedIntegrationRuntimeStatus self-hosted integration runtime status.
type SelfHostedIntegrationRuntimeStatus struct {
	// SelfHostedIntegrationRuntimeStatusTypeProperties - Self-hosted integration runtime status type properties.
	*SelfHostedIntegrationRuntimeStatusTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// DataFactoryName - READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty"`
	// State - READ-ONLY; The state of integration runtime. Possible values include: 'Initial', 'Stopped', 'Started', 'Starting', 'Stopping', 'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
	State IntegrationRuntimeState `json:"state,omitempty"`
	// Type - Possible values include: 'TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus', 'TypeBasicIntegrationRuntimeStatusTypeManaged', 'TypeBasicIntegrationRuntimeStatusTypeSelfHosted'
	Type TypeBasicIntegrationRuntimeStatus `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelfHostedIntegrationRuntimeStatus.
func (shirs SelfHostedIntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	shirs.Type = TypeBasicIntegrationRuntimeStatusTypeSelfHosted
	objectMap := make(map[string]interface{})
	if shirs.SelfHostedIntegrationRuntimeStatusTypeProperties != nil {
		objectMap["typeProperties"] = shirs.SelfHostedIntegrationRuntimeStatusTypeProperties
	}
	if shirs.Type != "" {
		objectMap["type"] = shirs.Type
	}
	for k, v := range shirs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsManagedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for SelfHostedIntegrationRuntimeStatus.
func (shirs SelfHostedIntegrationRuntimeStatus) AsManagedIntegrationRuntimeStatus() (*ManagedIntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsSelfHostedIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for SelfHostedIntegrationRuntimeStatus.
func (shirs SelfHostedIntegrationRuntimeStatus) AsSelfHostedIntegrationRuntimeStatus() (*SelfHostedIntegrationRuntimeStatus, bool) {
	return &shirs, true
}

// AsIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for SelfHostedIntegrationRuntimeStatus.
func (shirs SelfHostedIntegrationRuntimeStatus) AsIntegrationRuntimeStatus() (*IntegrationRuntimeStatus, bool) {
	return nil, false
}

// AsBasicIntegrationRuntimeStatus is the BasicIntegrationRuntimeStatus implementation for SelfHostedIntegrationRuntimeStatus.
func (shirs SelfHostedIntegrationRuntimeStatus) AsBasicIntegrationRuntimeStatus() (BasicIntegrationRuntimeStatus, bool) {
	return &shirs, true
}

// UnmarshalJSON is the custom unmarshaler for SelfHostedIntegrationRuntimeStatus struct.
func (shirs *SelfHostedIntegrationRuntimeStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var selfHostedIntegrationRuntimeStatusTypeProperties SelfHostedIntegrationRuntimeStatusTypeProperties
				err = json.Unmarshal(*v, &selfHostedIntegrationRuntimeStatusTypeProperties)
				if err != nil {
					return err
				}
				shirs.SelfHostedIntegrationRuntimeStatusTypeProperties = &selfHostedIntegrationRuntimeStatusTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if shirs.AdditionalProperties == nil {
					shirs.AdditionalProperties = make(map[string]interface{})
				}
				shirs.AdditionalProperties[k] = additionalProperties
			}
		case "dataFactoryName":
			if v != nil {
				var dataFactoryName string
				err = json.Unmarshal(*v, &dataFactoryName)
				if err != nil {
					return err
				}
				shirs.DataFactoryName = &dataFactoryName
			}
		case "state":
			if v != nil {
				var state IntegrationRuntimeState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				shirs.State = state
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicIntegrationRuntimeStatus
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				shirs.Type = typeVar
			}
		}
	}

	return nil
}

// SelfHostedIntegrationRuntimeStatusTypeProperties self-hosted integration runtime status type properties.
type SelfHostedIntegrationRuntimeStatusTypeProperties struct {
	// CreateTime - READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// TaskQueueID - READ-ONLY; The task queue id of the integration runtime.
	TaskQueueID *string `json:"taskQueueId,omitempty"`
	// NodeCommunicationChannelEncryptionMode - READ-ONLY; The node communication Channel encryption mode
	NodeCommunicationChannelEncryptionMode *string `json:"nodeCommunicationChannelEncryptionMode,omitempty"`
	// InternalChannelEncryption - READ-ONLY; It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist). Possible values include: 'NotSet', 'SslEncrypted', 'NotEncrypted'
	InternalChannelEncryption IntegrationRuntimeInternalChannelEncryptionMode `json:"internalChannelEncryption,omitempty"`
	// Version - READ-ONLY; Version of the integration runtime.
	Version *string `json:"version,omitempty"`
	// Nodes - The list of nodes for this integration runtime.
	Nodes *[]SelfHostedIntegrationRuntimeNode `json:"nodes,omitempty"`
	// ScheduledUpdateDate - READ-ONLY; The date at which the integration runtime will be scheduled to update, in ISO8601 format.
	ScheduledUpdateDate *date.Time `json:"scheduledUpdateDate,omitempty"`
	// UpdateDelayOffset - READ-ONLY; The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
	UpdateDelayOffset *string `json:"updateDelayOffset,omitempty"`
	// LocalTimeZoneOffset - READ-ONLY; The local time zone offset in hours.
	LocalTimeZoneOffset *string `json:"localTimeZoneOffset,omitempty"`
	// Capabilities - READ-ONLY; Object with additional information about integration runtime capabilities.
	Capabilities map[string]*string `json:"capabilities"`
	// ServiceUrls - READ-ONLY; The URLs for the services used in integration runtime backend service.
	ServiceUrls *[]string `json:"serviceUrls,omitempty"`
	// AutoUpdate - READ-ONLY; Whether Self-hosted integration runtime auto update has been turned on. Possible values include: 'On', 'Off'
	AutoUpdate IntegrationRuntimeAutoUpdate `json:"autoUpdate,omitempty"`
	// VersionStatus - READ-ONLY; Status of the integration runtime version.
	VersionStatus *string `json:"versionStatus,omitempty"`
	// Links - The list of linked integration runtimes that are created to share with this integration runtime.
	Links *[]LinkedIntegrationRuntime `json:"links,omitempty"`
	// PushedVersion - READ-ONLY; The version that the integration runtime is going to update to.
	PushedVersion *string `json:"pushedVersion,omitempty"`
	// LatestVersion - READ-ONLY; The latest version on download center.
	LatestVersion *string `json:"latestVersion,omitempty"`
	// AutoUpdateETA - READ-ONLY; The estimated time when the self-hosted integration runtime will be updated.
	AutoUpdateETA *date.Time `json:"autoUpdateETA,omitempty"`
}

// MarshalJSON is the custom marshaler for SelfHostedIntegrationRuntimeStatusTypeProperties.
func (shirstp SelfHostedIntegrationRuntimeStatusTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shirstp.Nodes != nil {
		objectMap["nodes"] = shirstp.Nodes
	}
	if shirstp.Links != nil {
		objectMap["links"] = shirstp.Links
	}
	return json.Marshal(objectMap)
}

// SelfHostedIntegrationRuntimeTypeProperties the self-hosted integration runtime properties.
type SelfHostedIntegrationRuntimeTypeProperties struct {
	// LinkedInfo - Linked integration runtime type from data factory
	LinkedInfo BasicLinkedIntegrationRuntimeType `json:"linkedInfo,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SelfHostedIntegrationRuntimeTypeProperties struct.
func (shirtp *SelfHostedIntegrationRuntimeTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "linkedInfo":
			if v != nil {
				linkedInfo, err := unmarshalBasicLinkedIntegrationRuntimeType(*v)
				if err != nil {
					return err
				}
				shirtp.LinkedInfo = linkedInfo
			}
		}
	}

	return nil
}

// SensitivityLabel a sensitivity label.
type SensitivityLabel struct {
	autorest.Response `json:"-"`
	// SensitivityLabelProperties - Resource properties.
	*SensitivityLabelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabel.
func (sl SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.SensitivityLabelProperties != nil {
		objectMap["properties"] = sl.SensitivityLabelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SensitivityLabel struct.
func (sl *SensitivityLabel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sensitivityLabelProperties SensitivityLabelProperties
				err = json.Unmarshal(*v, &sensitivityLabelProperties)
				if err != nil {
					return err
				}
				sl.SensitivityLabelProperties = &sensitivityLabelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// SensitivityLabelListResult a list of sensitivity labels.
type SensitivityLabelListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SensitivityLabel `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SensitivityLabelListResultIterator provides access to a complete listing of SensitivityLabel values.
type SensitivityLabelListResultIterator struct {
	i    int
	page SensitivityLabelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SensitivityLabelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SensitivityLabelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SensitivityLabelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SensitivityLabelListResultIterator) Response() SensitivityLabelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SensitivityLabelListResultIterator) Value() SensitivityLabel {
	if !iter.page.NotDone() {
		return SensitivityLabel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SensitivityLabelListResultIterator type.
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return SensitivityLabelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr SensitivityLabelListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sllr SensitivityLabelListResult) hasNextLink() bool {
	return sllr.NextLink != nil && len(*sllr.NextLink) != 0
}

// sensitivityLabelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr SensitivityLabelListResult) sensitivityLabelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// SensitivityLabelListResultPage contains a page of SensitivityLabel values.
type SensitivityLabelListResultPage struct {
	fn   func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)
	sllr SensitivityLabelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SensitivityLabelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sllr)
		if err != nil {
			return err
		}
		page.sllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SensitivityLabelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SensitivityLabelListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SensitivityLabelListResultPage) Response() SensitivityLabelListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SensitivityLabelListResultPage) Values() []SensitivityLabel {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the SensitivityLabelListResultPage type.
func NewSensitivityLabelListResultPage(cur SensitivityLabelListResult, getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return SensitivityLabelListResultPage{
		fn:   getNextPage,
		sllr: cur,
	}
}

// SensitivityLabelProperties properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// LabelName - The label name.
	LabelName *string `json:"labelName,omitempty"`
	// LabelID - The label ID.
	LabelID *string `json:"labelId,omitempty"`
	// InformationType - The information type.
	InformationType *string `json:"informationType,omitempty"`
	// InformationTypeID - The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`
	// IsDisabled - READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabelProperties.
func (slp SensitivityLabelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slp.LabelName != nil {
		objectMap["labelName"] = slp.LabelName
	}
	if slp.LabelID != nil {
		objectMap["labelId"] = slp.LabelID
	}
	if slp.InformationType != nil {
		objectMap["informationType"] = slp.InformationType
	}
	if slp.InformationTypeID != nil {
		objectMap["informationTypeId"] = slp.InformationTypeID
	}
	return json.Marshal(objectMap)
}

// ServerBlobAuditingPolicy a server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ServerBlobAuditingPolicyProperties - Resource properties.
	*ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerBlobAuditingPolicy.
func (sbap ServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbap.ServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = sbap.ServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerBlobAuditingPolicy struct.
func (sbap *ServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverBlobAuditingPolicyProperties ServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &serverBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				sbap.ServerBlobAuditingPolicyProperties = &serverBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerBlobAuditingPolicyListResult a list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ServerBlobAuditingPolicy values.
type ServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerBlobAuditingPolicyListResultIterator) Response() ServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerBlobAuditingPolicyListResultIterator) Value() ServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultIterator type.
func NewServerBlobAuditingPolicyListResultIterator(page ServerBlobAuditingPolicyListResultPage) ServerBlobAuditingPolicyListResultIterator {
	return ServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sbaplr ServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return sbaplr.Value == nil || len(*sbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sbaplr ServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return sbaplr.NextLink != nil && len(*sbaplr.NextLink) != 0
}

// serverBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sbaplr ServerBlobAuditingPolicyListResult) serverBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sbaplr.NextLink)))
}

// ServerBlobAuditingPolicyListResultPage contains a page of ServerBlobAuditingPolicy values.
type ServerBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)
	sbaplr ServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sbaplr)
		if err != nil {
			return err
		}
		page.sbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.sbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerBlobAuditingPolicyListResultPage) Response() ServerBlobAuditingPolicyListResult {
	return page.sbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerBlobAuditingPolicyListResultPage) Values() []ServerBlobAuditingPolicy {
	if page.sbaplr.IsEmpty() {
		return nil
	}
	return *page.sbaplr.Value
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultPage type.
func NewServerBlobAuditingPolicyListResultPage(cur ServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)) ServerBlobAuditingPolicyListResultPage {
	return ServerBlobAuditingPolicyListResultPage{
		fn:     getNextPage,
		sbaplr: cur,
	}
}

// ServerBlobAuditingPolicyProperties properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ServerSecurityAlertPolicy workspace managed Sql server security alert policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// ServerSecurityAlertPolicyProperties - Resource properties.
	*ServerSecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicy.
func (ssap ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssap.ServerSecurityAlertPolicyProperties != nil {
		objectMap["properties"] = ssap.ServerSecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerSecurityAlertPolicy struct.
func (ssap *ServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverSecurityAlertPolicyProperties ServerSecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &serverSecurityAlertPolicyProperties)
				if err != nil {
					return err
				}
				ssap.ServerSecurityAlertPolicyProperties = &serverSecurityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerSecurityAlertPolicyListResult a list of the workspace managed sql server's security alert
// policies.
type ServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ServerSecurityAlertPolicy values.
type ServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page ServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerSecurityAlertPolicyListResultIterator) Response() ServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerSecurityAlertPolicyListResultIterator) Value() ServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerSecurityAlertPolicyListResultIterator type.
func NewServerSecurityAlertPolicyListResultIterator(page ServerSecurityAlertPolicyListResultPage) ServerSecurityAlertPolicyListResultIterator {
	return ServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssaplr ServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return ssaplr.Value == nil || len(*ssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssaplr ServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return ssaplr.NextLink != nil && len(*ssaplr.NextLink) != 0
}

// serverSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssaplr ServerSecurityAlertPolicyListResult) serverSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssaplr.NextLink)))
}

// ServerSecurityAlertPolicyListResultPage contains a page of ServerSecurityAlertPolicy values.
type ServerSecurityAlertPolicyListResultPage struct {
	fn     func(context.Context, ServerSecurityAlertPolicyListResult) (ServerSecurityAlertPolicyListResult, error)
	ssaplr ServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssaplr)
		if err != nil {
			return err
		}
		page.ssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.ssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerSecurityAlertPolicyListResultPage) Response() ServerSecurityAlertPolicyListResult {
	return page.ssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerSecurityAlertPolicyListResultPage) Values() []ServerSecurityAlertPolicy {
	if page.ssaplr.IsEmpty() {
		return nil
	}
	return *page.ssaplr.Value
}

// Creates a new instance of the ServerSecurityAlertPolicyListResultPage type.
func NewServerSecurityAlertPolicyListResultPage(cur ServerSecurityAlertPolicyListResult, getNextPage func(context.Context, ServerSecurityAlertPolicyListResult) (ServerSecurityAlertPolicyListResult, error)) ServerSecurityAlertPolicyListResultPage {
	return ServerSecurityAlertPolicyListResultPage{
		fn:     getNextPage,
		ssaplr: cur,
	}
}

// ServerSecurityAlertPolicyProperties properties of a security alert policy.
type ServerSecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific server. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicyProperties.
func (ssapp ServerSecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssapp.State != "" {
		objectMap["state"] = ssapp.State
	}
	if ssapp.DisabledAlerts != nil {
		objectMap["disabledAlerts"] = ssapp.DisabledAlerts
	}
	if ssapp.EmailAddresses != nil {
		objectMap["emailAddresses"] = ssapp.EmailAddresses
	}
	if ssapp.EmailAccountAdmins != nil {
		objectMap["emailAccountAdmins"] = ssapp.EmailAccountAdmins
	}
	if ssapp.StorageEndpoint != nil {
		objectMap["storageEndpoint"] = ssapp.StorageEndpoint
	}
	if ssapp.StorageAccountAccessKey != nil {
		objectMap["storageAccountAccessKey"] = ssapp.StorageAccountAccessKey
	}
	if ssapp.RetentionDays != nil {
		objectMap["retentionDays"] = ssapp.RetentionDays
	}
	return json.Marshal(objectMap)
}

// ServerUsage represents server metrics.
type ServerUsage struct {
	// Name - READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerUsageListResult represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server metrics for the server.
	Value *[]ServerUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerUsageListResult.
func (sulr ServerUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sulr.Value != nil {
		objectMap["value"] = sulr.Value
	}
	return json.Marshal(objectMap)
}

// ServerUsageListResultIterator provides access to a complete listing of ServerUsage values.
type ServerUsageListResultIterator struct {
	i    int
	page ServerUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerUsageListResultIterator) Response() ServerUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerUsageListResultIterator) Value() ServerUsage {
	if !iter.page.NotDone() {
		return ServerUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerUsageListResultIterator type.
func NewServerUsageListResultIterator(page ServerUsageListResultPage) ServerUsageListResultIterator {
	return ServerUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sulr ServerUsageListResult) IsEmpty() bool {
	return sulr.Value == nil || len(*sulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sulr ServerUsageListResult) hasNextLink() bool {
	return sulr.NextLink != nil && len(*sulr.NextLink) != 0
}

// serverUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sulr ServerUsageListResult) serverUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sulr.NextLink)))
}

// ServerUsageListResultPage contains a page of ServerUsage values.
type ServerUsageListResultPage struct {
	fn   func(context.Context, ServerUsageListResult) (ServerUsageListResult, error)
	sulr ServerUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sulr)
		if err != nil {
			return err
		}
		page.sulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerUsageListResultPage) NotDone() bool {
	return !page.sulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerUsageListResultPage) Response() ServerUsageListResult {
	return page.sulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerUsageListResultPage) Values() []ServerUsage {
	if page.sulr.IsEmpty() {
		return nil
	}
	return *page.sulr.Value
}

// Creates a new instance of the ServerUsageListResultPage type.
func NewServerUsageListResultPage(cur ServerUsageListResult, getNextPage func(context.Context, ServerUsageListResult) (ServerUsageListResult, error)) ServerUsageListResultPage {
	return ServerUsageListResultPage{
		fn:   getNextPage,
		sulr: cur,
	}
}

// ServerVulnerabilityAssessment a server vulnerability assessment.
type ServerVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// ServerVulnerabilityAssessmentProperties - Resource properties.
	*ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityAssessment.
func (sva ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sva.ServerVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = sva.ServerVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerVulnerabilityAssessment struct.
func (sva *ServerVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverVulnerabilityAssessmentProperties ServerVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &serverVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				sva.ServerVulnerabilityAssessmentProperties = &serverVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sva.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerVulnerabilityAssessmentListResult a list of the server's vulnerability assessments.
type ServerVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// ServerVulnerabilityAssessment values.
type ServerVulnerabilityAssessmentListResultIterator struct {
	i    int
	page ServerVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerVulnerabilityAssessmentListResultIterator) Response() ServerVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerVulnerabilityAssessmentListResultIterator) Value() ServerVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return ServerVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerVulnerabilityAssessmentListResultIterator type.
func NewServerVulnerabilityAssessmentListResultIterator(page ServerVulnerabilityAssessmentListResultPage) ServerVulnerabilityAssessmentListResultIterator {
	return ServerVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (svalr ServerVulnerabilityAssessmentListResult) IsEmpty() bool {
	return svalr.Value == nil || len(*svalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (svalr ServerVulnerabilityAssessmentListResult) hasNextLink() bool {
	return svalr.NextLink != nil && len(*svalr.NextLink) != 0
}

// serverVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (svalr ServerVulnerabilityAssessmentListResult) serverVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !svalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(svalr.NextLink)))
}

// ServerVulnerabilityAssessmentListResultPage contains a page of ServerVulnerabilityAssessment values.
type ServerVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, ServerVulnerabilityAssessmentListResult) (ServerVulnerabilityAssessmentListResult, error)
	svalr ServerVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.svalr)
		if err != nil {
			return err
		}
		page.svalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.svalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerVulnerabilityAssessmentListResultPage) Response() ServerVulnerabilityAssessmentListResult {
	return page.svalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerVulnerabilityAssessmentListResultPage) Values() []ServerVulnerabilityAssessment {
	if page.svalr.IsEmpty() {
		return nil
	}
	return *page.svalr.Value
}

// Creates a new instance of the ServerVulnerabilityAssessmentListResultPage type.
func NewServerVulnerabilityAssessmentListResultPage(cur ServerVulnerabilityAssessmentListResult, getNextPage func(context.Context, ServerVulnerabilityAssessmentListResult) (ServerVulnerabilityAssessmentListResult, error)) ServerVulnerabilityAssessmentListResultPage {
	return ServerVulnerabilityAssessmentListResultPage{
		fn:    getNextPage,
		svalr: cur,
	}
}

// ServerVulnerabilityAssessmentProperties properties of a server Vulnerability Assessment.
type ServerVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Sku SQL pool SKU
type Sku struct {
	// Tier - The service tier
	Tier *string `json:"tier,omitempty"`
	// Name - The SKU name
	Name *string `json:"name,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SQLPool a SQL Analytics pool
type SQLPool struct {
	autorest.Response `json:"-"`
	// Sku - SQL pool SKU
	Sku *Sku `json:"sku,omitempty"`
	// SQLPoolResourceProperties - SQL pool properties
	*SQLPoolResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPool.
func (sp SQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Sku != nil {
		objectMap["sku"] = sp.Sku
	}
	if sp.SQLPoolResourceProperties != nil {
		objectMap["properties"] = sp.SQLPoolResourceProperties
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	if sp.Location != nil {
		objectMap["location"] = sp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPool struct.
func (sp *SQLPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sp.Sku = &sku
			}
		case "properties":
			if v != nil {
				var SQLPoolResourceProperties SQLPoolResourceProperties
				err = json.Unmarshal(*v, &SQLPoolResourceProperties)
				if err != nil {
					return err
				}
				sp.SQLPoolResourceProperties = &SQLPoolResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolBlobAuditingPolicy a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// SQLPoolBlobAuditingPolicyProperties - Resource properties.
	*SQLPoolBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolBlobAuditingPolicy.
func (spbap SQLPoolBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spbap.SQLPoolBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = spbap.SQLPoolBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolBlobAuditingPolicy struct.
func (spbap *SQLPoolBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var SQLPoolBlobAuditingPolicyProperties SQLPoolBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &SQLPoolBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				spbap.SQLPoolBlobAuditingPolicyProperties = &SQLPoolBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spbap.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolBlobAuditingPolicyListResult a list of Sql pool auditing settings.
type SQLPoolBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolBlobAuditingPolicyListResultIterator provides access to a complete listing of
// SQLPoolBlobAuditingPolicy values.
type SQLPoolBlobAuditingPolicyListResultIterator struct {
	i    int
	page SQLPoolBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolBlobAuditingPolicyListResultIterator) Response() SQLPoolBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolBlobAuditingPolicyListResultIterator) Value() SQLPoolBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return SQLPoolBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolBlobAuditingPolicyListResultIterator type.
func NewSQLPoolBlobAuditingPolicyListResultIterator(page SQLPoolBlobAuditingPolicyListResultPage) SQLPoolBlobAuditingPolicyListResultIterator {
	return SQLPoolBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spbaplr SQLPoolBlobAuditingPolicyListResult) IsEmpty() bool {
	return spbaplr.Value == nil || len(*spbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spbaplr SQLPoolBlobAuditingPolicyListResult) hasNextLink() bool {
	return spbaplr.NextLink != nil && len(*spbaplr.NextLink) != 0
}

// sQLPoolBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spbaplr SQLPoolBlobAuditingPolicyListResult) sQLPoolBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spbaplr.NextLink)))
}

// SQLPoolBlobAuditingPolicyListResultPage contains a page of SQLPoolBlobAuditingPolicy values.
type SQLPoolBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, SQLPoolBlobAuditingPolicyListResult) (SQLPoolBlobAuditingPolicyListResult, error)
	spbaplr SQLPoolBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spbaplr)
		if err != nil {
			return err
		}
		page.spbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.spbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolBlobAuditingPolicyListResultPage) Response() SQLPoolBlobAuditingPolicyListResult {
	return page.spbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolBlobAuditingPolicyListResultPage) Values() []SQLPoolBlobAuditingPolicy {
	if page.spbaplr.IsEmpty() {
		return nil
	}
	return *page.spbaplr.Value
}

// Creates a new instance of the SQLPoolBlobAuditingPolicyListResultPage type.
func NewSQLPoolBlobAuditingPolicyListResultPage(cur SQLPoolBlobAuditingPolicyListResult, getNextPage func(context.Context, SQLPoolBlobAuditingPolicyListResult) (SQLPoolBlobAuditingPolicyListResult, error)) SQLPoolBlobAuditingPolicyListResultPage {
	return SQLPoolBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		spbaplr: cur,
	}
}

// SQLPoolBlobAuditingPolicyProperties properties of a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResult the response to a list Sql pool operations request
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator provides access to a complete listing of
// SQLPoolOperation values.
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator struct {
	i    int
	page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Response() SQLPoolBlobAuditingPolicySQLPoolOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Value() SQLPoolOperation {
	if !iter.page.NotDone() {
		return SQLPoolOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator type.
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator {
	return SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult) IsEmpty() bool {
	return spbapspolr.Value == nil || len(*spbapspolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult) hasNextLink() bool {
	return spbapspolr.NextLink != nil && len(*spbapspolr.NextLink) != 0
}

// sQLPoolBlobAuditingPolicySQLPoolOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult) sQLPoolBlobAuditingPolicySQLPoolOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spbapspolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spbapspolr.NextLink)))
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage contains a page of SQLPoolOperation values.
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage struct {
	fn         func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)
	spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spbapspolr)
		if err != nil {
			return err
		}
		page.spbapspolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) NotDone() bool {
	return !page.spbapspolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Response() SQLPoolBlobAuditingPolicySQLPoolOperationListResult {
	return page.spbapspolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Values() []SQLPoolOperation {
	if page.spbapspolr.IsEmpty() {
		return nil
	}
	return *page.spbapspolr.Value
}

// Creates a new instance of the SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage type.
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(cur SQLPoolBlobAuditingPolicySQLPoolOperationListResult, getNextPage func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)) SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage {
	return SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage{
		fn:         getNextPage,
		spbapspolr: cur,
	}
}

// SQLPoolColumn a Sql pool column resource.
type SQLPoolColumn struct {
	autorest.Response `json:"-"`
	// SQLPoolColumnProperties - Resource properties.
	*SQLPoolColumnProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolColumn.
func (spc SQLPoolColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spc.SQLPoolColumnProperties != nil {
		objectMap["properties"] = spc.SQLPoolColumnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolColumn struct.
func (spc *SQLPoolColumn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolColumnProperties SQLPoolColumnProperties
				err = json.Unmarshal(*v, &SQLPoolColumnProperties)
				if err != nil {
					return err
				}
				spc.SQLPoolColumnProperties = &SQLPoolColumnProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spc.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolColumnListResult a list of Sql pool columns.
type SQLPoolColumnListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolColumn `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolColumnListResultIterator provides access to a complete listing of SQLPoolColumn values.
type SQLPoolColumnListResultIterator struct {
	i    int
	page SQLPoolColumnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolColumnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolColumnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolColumnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolColumnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolColumnListResultIterator) Response() SQLPoolColumnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolColumnListResultIterator) Value() SQLPoolColumn {
	if !iter.page.NotDone() {
		return SQLPoolColumn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolColumnListResultIterator type.
func NewSQLPoolColumnListResultIterator(page SQLPoolColumnListResultPage) SQLPoolColumnListResultIterator {
	return SQLPoolColumnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spclr SQLPoolColumnListResult) IsEmpty() bool {
	return spclr.Value == nil || len(*spclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spclr SQLPoolColumnListResult) hasNextLink() bool {
	return spclr.NextLink != nil && len(*spclr.NextLink) != 0
}

// sQLPoolColumnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spclr SQLPoolColumnListResult) sQLPoolColumnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spclr.NextLink)))
}

// SQLPoolColumnListResultPage contains a page of SQLPoolColumn values.
type SQLPoolColumnListResultPage struct {
	fn    func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)
	spclr SQLPoolColumnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolColumnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolColumnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spclr)
		if err != nil {
			return err
		}
		page.spclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolColumnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolColumnListResultPage) NotDone() bool {
	return !page.spclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolColumnListResultPage) Response() SQLPoolColumnListResult {
	return page.spclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolColumnListResultPage) Values() []SQLPoolColumn {
	if page.spclr.IsEmpty() {
		return nil
	}
	return *page.spclr.Value
}

// Creates a new instance of the SQLPoolColumnListResultPage type.
func NewSQLPoolColumnListResultPage(cur SQLPoolColumnListResult, getNextPage func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)) SQLPoolColumnListResultPage {
	return SQLPoolColumnListResultPage{
		fn:    getNextPage,
		spclr: cur,
	}
}

// SQLPoolColumnProperties sql pool column properties.
type SQLPoolColumnProperties struct {
	// ColumnType - The column data type. Possible values include: 'Image', 'Text', 'Uniqueidentifier', 'Date', 'Time', 'Datetime2', 'Datetimeoffset', 'Tinyint', 'Smallint', 'Int', 'Smalldatetime', 'Real', 'Money', 'Datetime', 'Float', 'SQLVariant', 'Ntext', 'Bit', 'Decimal', 'Numeric', 'Smallmoney', 'Bigint', 'Hierarchyid', 'Geometry', 'Geography', 'Varbinary', 'Varchar', 'Binary', 'Char', 'Timestamp', 'Nvarchar', 'Nchar', 'XML', 'Sysname'
	ColumnType ColumnDataType `json:"columnType,omitempty"`
}

// SQLPoolConnectionPolicy a Sql pool connection policy.
type SQLPoolConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// SQLPoolConnectionPolicyProperties - Resource properties.
	*SQLPoolConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolConnectionPolicy.
func (spcp SQLPoolConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spcp.SQLPoolConnectionPolicyProperties != nil {
		objectMap["properties"] = spcp.SQLPoolConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolConnectionPolicy struct.
func (spcp *SQLPoolConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spcp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				spcp.Location = &location
			}
		case "properties":
			if v != nil {
				var SQLPoolConnectionPolicyProperties SQLPoolConnectionPolicyProperties
				err = json.Unmarshal(*v, &SQLPoolConnectionPolicyProperties)
				if err != nil {
					return err
				}
				spcp.SQLPoolConnectionPolicyProperties = &SQLPoolConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spcp.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolConnectionPolicyProperties properties of a Sql pool connection policy.
type SQLPoolConnectionPolicyProperties struct {
	// SecurityEnabledAccess - The state of security access.
	SecurityEnabledAccess *string `json:"securityEnabledAccess,omitempty"`
	// ProxyDNSName - The fully qualified host name of the auditing proxy.
	ProxyDNSName *string `json:"proxyDnsName,omitempty"`
	// ProxyPort - The port number of the auditing proxy.
	ProxyPort *string `json:"proxyPort,omitempty"`
	// Visibility - The visibility of the auditing proxy.
	Visibility *string `json:"visibility,omitempty"`
	// UseServerDefault - Whether server default is enabled or disabled.
	UseServerDefault *string `json:"useServerDefault,omitempty"`
	// RedirectionState - The state of proxy redirection.
	RedirectionState *string `json:"redirectionState,omitempty"`
	// State - The connection policy state.
	State *string `json:"state,omitempty"`
}

// SQLPoolInfoListResult list of SQL pools
type SQLPoolInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of SQL pools
	Value *[]SQLPool `json:"value,omitempty"`
}

// SQLPoolInfoListResultIterator provides access to a complete listing of SQLPool values.
type SQLPoolInfoListResultIterator struct {
	i    int
	page SQLPoolInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolInfoListResultIterator) Response() SQLPoolInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolInfoListResultIterator) Value() SQLPool {
	if !iter.page.NotDone() {
		return SQLPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolInfoListResultIterator type.
func NewSQLPoolInfoListResultIterator(page SQLPoolInfoListResultPage) SQLPoolInfoListResultIterator {
	return SQLPoolInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spilr SQLPoolInfoListResult) IsEmpty() bool {
	return spilr.Value == nil || len(*spilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spilr SQLPoolInfoListResult) hasNextLink() bool {
	return spilr.NextLink != nil && len(*spilr.NextLink) != 0
}

// sQLPoolInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spilr SQLPoolInfoListResult) sQLPoolInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spilr.NextLink)))
}

// SQLPoolInfoListResultPage contains a page of SQLPool values.
type SQLPoolInfoListResultPage struct {
	fn    func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)
	spilr SQLPoolInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spilr)
		if err != nil {
			return err
		}
		page.spilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolInfoListResultPage) NotDone() bool {
	return !page.spilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolInfoListResultPage) Response() SQLPoolInfoListResult {
	return page.spilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolInfoListResultPage) Values() []SQLPool {
	if page.spilr.IsEmpty() {
		return nil
	}
	return *page.spilr.Value
}

// Creates a new instance of the SQLPoolInfoListResultPage type.
func NewSQLPoolInfoListResultPage(cur SQLPoolInfoListResult, getNextPage func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)) SQLPoolInfoListResultPage {
	return SQLPoolInfoListResultPage{
		fn:    getNextPage,
		spilr: cur,
	}
}

// SQLPoolOperation a Sql pool operation.
type SQLPoolOperation struct {
	// SQLPoolOperationProperties - Resource properties.
	*SQLPoolOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolOperation.
func (spo SQLPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spo.SQLPoolOperationProperties != nil {
		objectMap["properties"] = spo.SQLPoolOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolOperation struct.
func (spo *SQLPoolOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolOperationProperties SQLPoolOperationProperties
				err = json.Unmarshal(*v, &SQLPoolOperationProperties)
				if err != nil {
					return err
				}
				spo.SQLPoolOperationProperties = &SQLPoolOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spo.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolOperationProperties the properties of a Sql pool operation.
type SQLPoolOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the Sql pool the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'Pending', 'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// SQLPoolPatchInfo a SQL Analytics pool patch info
type SQLPoolPatchInfo struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Sku - SQL pool SKU
	Sku *Sku `json:"sku,omitempty"`
	// SQLPoolResourceProperties - SQL pool properties
	*SQLPoolResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolPatchInfo.
func (sppi SQLPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sppi.Tags != nil {
		objectMap["tags"] = sppi.Tags
	}
	if sppi.Location != nil {
		objectMap["location"] = sppi.Location
	}
	if sppi.Sku != nil {
		objectMap["sku"] = sppi.Sku
	}
	if sppi.SQLPoolResourceProperties != nil {
		objectMap["properties"] = sppi.SQLPoolResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolPatchInfo struct.
func (sppi *SQLPoolPatchInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sppi.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sppi.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sppi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var SQLPoolResourceProperties SQLPoolResourceProperties
				err = json.Unmarshal(*v, &SQLPoolResourceProperties)
				if err != nil {
					return err
				}
				sppi.SQLPoolResourceProperties = &SQLPoolResourceProperties
			}
		}
	}

	return nil
}

// SQLPoolResourceProperties properties of a SQL Analytics pool
type SQLPoolResourceProperties struct {
	// MaxSizeBytes - Maximum size in bytes
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// Collation - Collation mode
	Collation *string `json:"collation,omitempty"`
	// SourceDatabaseID - Source database to create from
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RecoverableDatabaseID - Backup database to restore from
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// ProvisioningState - Resource state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Status - Resource status
	Status *string `json:"status,omitempty"`
	// RestorePointInTime - Snapshot time to restore
	RestorePointInTime *string `json:"restorePointInTime,omitempty"`
	// CreateMode - What is this?
	CreateMode *string `json:"createMode,omitempty"`
	// CreationDate - Date the SQL pool was created
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// SQLPoolRestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLPoolRestorePointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolRestorePointsClient) (RestorePoint, error)
}

// SQLPoolSchema a Sql pool schema resource.
type SQLPoolSchema struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// SQLPoolSchemaListResult a list of Sql pool schemas.
type SQLPoolSchemaListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolSchema `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolSchemaListResultIterator provides access to a complete listing of SQLPoolSchema values.
type SQLPoolSchemaListResultIterator struct {
	i    int
	page SQLPoolSchemaListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolSchemaListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolSchemaListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolSchemaListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolSchemaListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolSchemaListResultIterator) Response() SQLPoolSchemaListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolSchemaListResultIterator) Value() SQLPoolSchema {
	if !iter.page.NotDone() {
		return SQLPoolSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolSchemaListResultIterator type.
func NewSQLPoolSchemaListResultIterator(page SQLPoolSchemaListResultPage) SQLPoolSchemaListResultIterator {
	return SQLPoolSchemaListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spslr SQLPoolSchemaListResult) IsEmpty() bool {
	return spslr.Value == nil || len(*spslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spslr SQLPoolSchemaListResult) hasNextLink() bool {
	return spslr.NextLink != nil && len(*spslr.NextLink) != 0
}

// sQLPoolSchemaListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spslr SQLPoolSchemaListResult) sQLPoolSchemaListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spslr.NextLink)))
}

// SQLPoolSchemaListResultPage contains a page of SQLPoolSchema values.
type SQLPoolSchemaListResultPage struct {
	fn    func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)
	spslr SQLPoolSchemaListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolSchemaListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolSchemaListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spslr)
		if err != nil {
			return err
		}
		page.spslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolSchemaListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolSchemaListResultPage) NotDone() bool {
	return !page.spslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolSchemaListResultPage) Response() SQLPoolSchemaListResult {
	return page.spslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolSchemaListResultPage) Values() []SQLPoolSchema {
	if page.spslr.IsEmpty() {
		return nil
	}
	return *page.spslr.Value
}

// Creates a new instance of the SQLPoolSchemaListResultPage type.
func NewSQLPoolSchemaListResultPage(cur SQLPoolSchemaListResult, getNextPage func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)) SQLPoolSchemaListResultPage {
	return SQLPoolSchemaListResultPage{
		fn:    getNextPage,
		spslr: cur,
	}
}

// SQLPoolsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolsClient) (SQLPool, error)
}

// SQLPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolsClient) (SetObject, error)
}

// SQLPoolSecurityAlertPolicy a Sql pool security alert policy.
type SQLPoolSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolSecurityAlertPolicy.
func (spsap SQLPoolSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spsap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = spsap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolSecurityAlertPolicy struct.
func (spsap *SQLPoolSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				spsap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spsap.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolsPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsPauseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolsClient) (SetObject, error)
}

// SQLPoolsResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolsClient) (SetObject, error)
}

// SQLPoolTable a Sql pool table resource.
type SQLPoolTable struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// SQLPoolTableListResult a list of Sql pool tables.
type SQLPoolTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolTable `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolTableListResultIterator provides access to a complete listing of SQLPoolTable values.
type SQLPoolTableListResultIterator struct {
	i    int
	page SQLPoolTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolTableListResultIterator) Response() SQLPoolTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolTableListResultIterator) Value() SQLPoolTable {
	if !iter.page.NotDone() {
		return SQLPoolTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolTableListResultIterator type.
func NewSQLPoolTableListResultIterator(page SQLPoolTableListResultPage) SQLPoolTableListResultIterator {
	return SQLPoolTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sptlr SQLPoolTableListResult) IsEmpty() bool {
	return sptlr.Value == nil || len(*sptlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sptlr SQLPoolTableListResult) hasNextLink() bool {
	return sptlr.NextLink != nil && len(*sptlr.NextLink) != 0
}

// sQLPoolTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sptlr SQLPoolTableListResult) sQLPoolTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sptlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sptlr.NextLink)))
}

// SQLPoolTableListResultPage contains a page of SQLPoolTable values.
type SQLPoolTableListResultPage struct {
	fn    func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)
	sptlr SQLPoolTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sptlr)
		if err != nil {
			return err
		}
		page.sptlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolTableListResultPage) NotDone() bool {
	return !page.sptlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolTableListResultPage) Response() SQLPoolTableListResult {
	return page.sptlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolTableListResultPage) Values() []SQLPoolTable {
	if page.sptlr.IsEmpty() {
		return nil
	}
	return *page.sptlr.Value
}

// Creates a new instance of the SQLPoolTableListResultPage type.
func NewSQLPoolTableListResultPage(cur SQLPoolTableListResult, getNextPage func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)) SQLPoolTableListResultPage {
	return SQLPoolTableListResultPage{
		fn:    getNextPage,
		sptlr: cur,
	}
}

// SQLPoolUsage the Sql pool usages.
type SQLPoolUsage struct {
	// Name - READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// SQLPoolUsageListResult the response to a list Sql pool usages request.
type SQLPoolUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages for the Sql pool.
	Value *[]SQLPoolUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolUsageListResult.
func (spulr SQLPoolUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spulr.Value != nil {
		objectMap["value"] = spulr.Value
	}
	return json.Marshal(objectMap)
}

// SQLPoolUsageListResultIterator provides access to a complete listing of SQLPoolUsage values.
type SQLPoolUsageListResultIterator struct {
	i    int
	page SQLPoolUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolUsageListResultIterator) Response() SQLPoolUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolUsageListResultIterator) Value() SQLPoolUsage {
	if !iter.page.NotDone() {
		return SQLPoolUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolUsageListResultIterator type.
func NewSQLPoolUsageListResultIterator(page SQLPoolUsageListResultPage) SQLPoolUsageListResultIterator {
	return SQLPoolUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spulr SQLPoolUsageListResult) IsEmpty() bool {
	return spulr.Value == nil || len(*spulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spulr SQLPoolUsageListResult) hasNextLink() bool {
	return spulr.NextLink != nil && len(*spulr.NextLink) != 0
}

// sQLPoolUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spulr SQLPoolUsageListResult) sQLPoolUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spulr.NextLink)))
}

// SQLPoolUsageListResultPage contains a page of SQLPoolUsage values.
type SQLPoolUsageListResultPage struct {
	fn    func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)
	spulr SQLPoolUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spulr)
		if err != nil {
			return err
		}
		page.spulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolUsageListResultPage) NotDone() bool {
	return !page.spulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolUsageListResultPage) Response() SQLPoolUsageListResult {
	return page.spulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolUsageListResultPage) Values() []SQLPoolUsage {
	if page.spulr.IsEmpty() {
		return nil
	}
	return *page.spulr.Value
}

// Creates a new instance of the SQLPoolUsageListResultPage type.
func NewSQLPoolUsageListResultPage(cur SQLPoolUsageListResult, getNextPage func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)) SQLPoolUsageListResultPage {
	return SQLPoolUsageListResultPage{
		fn:    getNextPage,
		spulr: cur,
	}
}

// SQLPoolVulnerabilityAssessment a Sql pool vulnerability assessment.
type SQLPoolVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessment.
func (spva SQLPoolVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spva.SQLPoolVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = spva.SQLPoolVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessment struct.
func (spva *SQLPoolVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentProperties SQLPoolVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				spva.SQLPoolVulnerabilityAssessmentProperties = &SQLPoolVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spva.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentListResult a list of the Sql pool's vulnerability assessments.
type SQLPoolVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// SQLPoolVulnerabilityAssessment values.
type SQLPoolVulnerabilityAssessmentListResultIterator struct {
	i    int
	page SQLPoolVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) Response() SQLPoolVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) Value() SQLPoolVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return SQLPoolVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolVulnerabilityAssessmentListResultIterator type.
func NewSQLPoolVulnerabilityAssessmentListResultIterator(page SQLPoolVulnerabilityAssessmentListResultPage) SQLPoolVulnerabilityAssessmentListResultIterator {
	return SQLPoolVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spvalr SQLPoolVulnerabilityAssessmentListResult) IsEmpty() bool {
	return spvalr.Value == nil || len(*spvalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spvalr SQLPoolVulnerabilityAssessmentListResult) hasNextLink() bool {
	return spvalr.NextLink != nil && len(*spvalr.NextLink) != 0
}

// sQLPoolVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spvalr SQLPoolVulnerabilityAssessmentListResult) sQLPoolVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !spvalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spvalr.NextLink)))
}

// SQLPoolVulnerabilityAssessmentListResultPage contains a page of SQLPoolVulnerabilityAssessment values.
type SQLPoolVulnerabilityAssessmentListResultPage struct {
	fn     func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)
	spvalr SQLPoolVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spvalr)
		if err != nil {
			return err
		}
		page.spvalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.spvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolVulnerabilityAssessmentListResultPage) Response() SQLPoolVulnerabilityAssessmentListResult {
	return page.spvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolVulnerabilityAssessmentListResultPage) Values() []SQLPoolVulnerabilityAssessment {
	if page.spvalr.IsEmpty() {
		return nil
	}
	return *page.spvalr.Value
}

// Creates a new instance of the SQLPoolVulnerabilityAssessmentListResultPage type.
func NewSQLPoolVulnerabilityAssessmentListResultPage(cur SQLPoolVulnerabilityAssessmentListResult, getNextPage func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)) SQLPoolVulnerabilityAssessmentListResultPage {
	return SQLPoolVulnerabilityAssessmentListResultPage{
		fn:     getNextPage,
		spvalr: cur,
	}
}

// SQLPoolVulnerabilityAssessmentProperties properties of a Sql pool Vulnerability Assessment.
type SQLPoolVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaseline a Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessmentRuleBaseline.
func (spvarb SQLPoolVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessmentRuleBaseline struct.
func (spvarb *SQLPoolVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentRuleBaselineProperties SQLPoolVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties = &SQLPoolVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentRuleBaselineItem properties for an Sql pool vulnerability assessment rule
// baseline's result.
type SQLPoolVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaselineProperties properties of a Sql pool vulnerability assessment
// rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]SQLPoolVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// SQLPoolVulnerabilityAssessmentScanExportProperties properties of the export operation's result.
type SQLPoolVulnerabilityAssessmentScanExportProperties struct {
	// ExportedReportLocation - READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty"`
}

// SQLPoolVulnerabilityAssessmentScansExport a Sql pool Vulnerability Assessment scan export resource.
type SQLPoolVulnerabilityAssessmentScansExport struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentScanExportProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessmentScansExport.
func (spvase SQLPoolVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spvase.SQLPoolVulnerabilityAssessmentScanExportProperties != nil {
		objectMap["properties"] = spvase.SQLPoolVulnerabilityAssessmentScanExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessmentScansExport struct.
func (spvase *SQLPoolVulnerabilityAssessmentScansExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentScanExportProperties SQLPoolVulnerabilityAssessmentScanExportProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentScanExportProperties)
				if err != nil {
					return err
				}
				spvase.SQLPoolVulnerabilityAssessmentScanExportProperties = &SQLPoolVulnerabilityAssessmentScanExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spvase.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spvase.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spvase.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLPoolVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolVulnerabilityAssessmentScansClient) (autorest.Response, error)
}

// SQLPoolWorkloadClassifierCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLPoolWorkloadClassifierCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolWorkloadClassifierClient) (WorkloadClassifier, error)
}

// SQLPoolWorkloadClassifierDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLPoolWorkloadClassifierDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolWorkloadClassifierClient) (autorest.Response, error)
}

// SQLPoolWorkloadGroupCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLPoolWorkloadGroupCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolWorkloadGroupClient) (WorkloadGroup, error)
}

// SQLPoolWorkloadGroupDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLPoolWorkloadGroupDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLPoolWorkloadGroupClient) (autorest.Response, error)
}

// SsisEnvironment ssis environment.
type SsisEnvironment struct {
	// FolderID - Folder id which contains environment.
	FolderID *int64 `json:"folderId,omitempty"`
	// Variables - Variable in environment
	Variables *[]SsisVariable `json:"variables,omitempty"`
	// ID - Metadata id.
	ID *int64 `json:"id,omitempty"`
	// Name - Metadata name.
	Name *string `json:"name,omitempty"`
	// Description - Metadata description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeSsisObjectMetadata', 'TypeFolder', 'TypeProject', 'TypePackage', 'TypeEnvironment'
	Type TypeBasicSsisObjectMetadata `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SsisEnvironment.
func (se SsisEnvironment) MarshalJSON() ([]byte, error) {
	se.Type = TypeEnvironment
	objectMap := make(map[string]interface{})
	if se.FolderID != nil {
		objectMap["folderId"] = se.FolderID
	}
	if se.Variables != nil {
		objectMap["variables"] = se.Variables
	}
	if se.ID != nil {
		objectMap["id"] = se.ID
	}
	if se.Name != nil {
		objectMap["name"] = se.Name
	}
	if se.Description != nil {
		objectMap["description"] = se.Description
	}
	if se.Type != "" {
		objectMap["type"] = se.Type
	}
	return json.Marshal(objectMap)
}

// AsSsisFolder is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsSsisFolder() (*SsisFolder, bool) {
	return nil, false
}

// AsSsisProject is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsSsisProject() (*SsisProject, bool) {
	return nil, false
}

// AsSsisPackage is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsSsisPackage() (*SsisPackage, bool) {
	return nil, false
}

// AsSsisEnvironment is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsSsisEnvironment() (*SsisEnvironment, bool) {
	return &se, true
}

// AsSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsSsisObjectMetadata() (*SsisObjectMetadata, bool) {
	return nil, false
}

// AsBasicSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisEnvironment.
func (se SsisEnvironment) AsBasicSsisObjectMetadata() (BasicSsisObjectMetadata, bool) {
	return &se, true
}

// SsisEnvironmentReference ssis environment reference.
type SsisEnvironmentReference struct {
	// ID - Environment reference id.
	ID *int64 `json:"id,omitempty"`
	// EnvironmentFolderName - Environment folder name.
	EnvironmentFolderName *string `json:"environmentFolderName,omitempty"`
	// EnvironmentName - Environment name.
	EnvironmentName *string `json:"environmentName,omitempty"`
	// ReferenceType - Reference type
	ReferenceType *string `json:"referenceType,omitempty"`
}

// SsisFolder ssis folder.
type SsisFolder struct {
	// ID - Metadata id.
	ID *int64 `json:"id,omitempty"`
	// Name - Metadata name.
	Name *string `json:"name,omitempty"`
	// Description - Metadata description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeSsisObjectMetadata', 'TypeFolder', 'TypeProject', 'TypePackage', 'TypeEnvironment'
	Type TypeBasicSsisObjectMetadata `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SsisFolder.
func (sf SsisFolder) MarshalJSON() ([]byte, error) {
	sf.Type = TypeFolder
	objectMap := make(map[string]interface{})
	if sf.ID != nil {
		objectMap["id"] = sf.ID
	}
	if sf.Name != nil {
		objectMap["name"] = sf.Name
	}
	if sf.Description != nil {
		objectMap["description"] = sf.Description
	}
	if sf.Type != "" {
		objectMap["type"] = sf.Type
	}
	return json.Marshal(objectMap)
}

// AsSsisFolder is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsSsisFolder() (*SsisFolder, bool) {
	return &sf, true
}

// AsSsisProject is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsSsisProject() (*SsisProject, bool) {
	return nil, false
}

// AsSsisPackage is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsSsisPackage() (*SsisPackage, bool) {
	return nil, false
}

// AsSsisEnvironment is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsSsisEnvironment() (*SsisEnvironment, bool) {
	return nil, false
}

// AsSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsSsisObjectMetadata() (*SsisObjectMetadata, bool) {
	return nil, false
}

// AsBasicSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisFolder.
func (sf SsisFolder) AsBasicSsisObjectMetadata() (BasicSsisObjectMetadata, bool) {
	return &sf, true
}

// BasicSsisObjectMetadata SSIS object metadata.
type BasicSsisObjectMetadata interface {
	AsSsisFolder() (*SsisFolder, bool)
	AsSsisProject() (*SsisProject, bool)
	AsSsisPackage() (*SsisPackage, bool)
	AsSsisEnvironment() (*SsisEnvironment, bool)
	AsSsisObjectMetadata() (*SsisObjectMetadata, bool)
}

// SsisObjectMetadata SSIS object metadata.
type SsisObjectMetadata struct {
	// ID - Metadata id.
	ID *int64 `json:"id,omitempty"`
	// Name - Metadata name.
	Name *string `json:"name,omitempty"`
	// Description - Metadata description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeSsisObjectMetadata', 'TypeFolder', 'TypeProject', 'TypePackage', 'TypeEnvironment'
	Type TypeBasicSsisObjectMetadata `json:"type,omitempty"`
}

func unmarshalBasicSsisObjectMetadata(body []byte) (BasicSsisObjectMetadata, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeFolder):
		var sf SsisFolder
		err := json.Unmarshal(body, &sf)
		return sf, err
	case string(TypeProject):
		var sp SsisProject
		err := json.Unmarshal(body, &sp)
		return sp, err
	case string(TypePackage):
		var sp SsisPackage
		err := json.Unmarshal(body, &sp)
		return sp, err
	case string(TypeEnvironment):
		var se SsisEnvironment
		err := json.Unmarshal(body, &se)
		return se, err
	default:
		var som SsisObjectMetadata
		err := json.Unmarshal(body, &som)
		return som, err
	}
}
func unmarshalBasicSsisObjectMetadataArray(body []byte) ([]BasicSsisObjectMetadata, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	somArray := make([]BasicSsisObjectMetadata, len(rawMessages))

	for index, rawMessage := range rawMessages {
		som, err := unmarshalBasicSsisObjectMetadata(*rawMessage)
		if err != nil {
			return nil, err
		}
		somArray[index] = som
	}
	return somArray, nil
}

// MarshalJSON is the custom marshaler for SsisObjectMetadata.
func (som SsisObjectMetadata) MarshalJSON() ([]byte, error) {
	som.Type = TypeSsisObjectMetadata
	objectMap := make(map[string]interface{})
	if som.ID != nil {
		objectMap["id"] = som.ID
	}
	if som.Name != nil {
		objectMap["name"] = som.Name
	}
	if som.Description != nil {
		objectMap["description"] = som.Description
	}
	if som.Type != "" {
		objectMap["type"] = som.Type
	}
	return json.Marshal(objectMap)
}

// AsSsisFolder is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsSsisFolder() (*SsisFolder, bool) {
	return nil, false
}

// AsSsisProject is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsSsisProject() (*SsisProject, bool) {
	return nil, false
}

// AsSsisPackage is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsSsisPackage() (*SsisPackage, bool) {
	return nil, false
}

// AsSsisEnvironment is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsSsisEnvironment() (*SsisEnvironment, bool) {
	return nil, false
}

// AsSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsSsisObjectMetadata() (*SsisObjectMetadata, bool) {
	return &som, true
}

// AsBasicSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisObjectMetadata.
func (som SsisObjectMetadata) AsBasicSsisObjectMetadata() (BasicSsisObjectMetadata, bool) {
	return &som, true
}

// SsisObjectMetadataListResponse a list of SSIS object metadata.
type SsisObjectMetadataListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of SSIS object metadata.
	Value *[]BasicSsisObjectMetadata `json:"value,omitempty"`
	// NextLink - The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SsisObjectMetadataListResponse struct.
func (somlr *SsisObjectMetadataListResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicSsisObjectMetadataArray(*v)
				if err != nil {
					return err
				}
				somlr.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				somlr.NextLink = &nextLink
			}
		}
	}

	return nil
}

// SsisObjectMetadataStatusResponse the status of the operation.
type SsisObjectMetadataStatusResponse struct {
	autorest.Response `json:"-"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// Properties - The operation properties.
	Properties *string `json:"properties,omitempty"`
	// Error - The operation error message.
	Error *string `json:"error,omitempty"`
}

// SsisPackage ssis Package.
type SsisPackage struct {
	// FolderID - Folder id which contains package.
	FolderID *int64 `json:"folderId,omitempty"`
	// ProjectVersion - Project version which contains package.
	ProjectVersion *int64 `json:"projectVersion,omitempty"`
	// ProjectID - Project id which contains package.
	ProjectID *int64 `json:"projectId,omitempty"`
	// Parameters - Parameters in package
	Parameters *[]SsisParameter `json:"parameters,omitempty"`
	// ID - Metadata id.
	ID *int64 `json:"id,omitempty"`
	// Name - Metadata name.
	Name *string `json:"name,omitempty"`
	// Description - Metadata description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeSsisObjectMetadata', 'TypeFolder', 'TypeProject', 'TypePackage', 'TypeEnvironment'
	Type TypeBasicSsisObjectMetadata `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SsisPackage.
func (sp SsisPackage) MarshalJSON() ([]byte, error) {
	sp.Type = TypePackage
	objectMap := make(map[string]interface{})
	if sp.FolderID != nil {
		objectMap["folderId"] = sp.FolderID
	}
	if sp.ProjectVersion != nil {
		objectMap["projectVersion"] = sp.ProjectVersion
	}
	if sp.ProjectID != nil {
		objectMap["projectId"] = sp.ProjectID
	}
	if sp.Parameters != nil {
		objectMap["parameters"] = sp.Parameters
	}
	if sp.ID != nil {
		objectMap["id"] = sp.ID
	}
	if sp.Name != nil {
		objectMap["name"] = sp.Name
	}
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	if sp.Type != "" {
		objectMap["type"] = sp.Type
	}
	return json.Marshal(objectMap)
}

// AsSsisFolder is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsSsisFolder() (*SsisFolder, bool) {
	return nil, false
}

// AsSsisProject is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsSsisProject() (*SsisProject, bool) {
	return nil, false
}

// AsSsisPackage is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsSsisPackage() (*SsisPackage, bool) {
	return &sp, true
}

// AsSsisEnvironment is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsSsisEnvironment() (*SsisEnvironment, bool) {
	return nil, false
}

// AsSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsSsisObjectMetadata() (*SsisObjectMetadata, bool) {
	return nil, false
}

// AsBasicSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisPackage.
func (sp SsisPackage) AsBasicSsisObjectMetadata() (BasicSsisObjectMetadata, bool) {
	return &sp, true
}

// SsisParameter ssis parameter.
type SsisParameter struct {
	// ID - Parameter id.
	ID *int64 `json:"id,omitempty"`
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// Description - Parameter description.
	Description *string `json:"description,omitempty"`
	// DataType - Parameter type.
	DataType *string `json:"dataType,omitempty"`
	// Required - Whether parameter is required.
	Required *bool `json:"required,omitempty"`
	// Sensitive - Whether parameter is sensitive.
	Sensitive *bool `json:"sensitive,omitempty"`
	// DesignDefaultValue - Design default value of parameter.
	DesignDefaultValue *string `json:"designDefaultValue,omitempty"`
	// DefaultValue - Default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// SensitiveDefaultValue - Default sensitive value of parameter.
	SensitiveDefaultValue *string `json:"sensitiveDefaultValue,omitempty"`
	// ValueType - Parameter value type.
	ValueType *string `json:"valueType,omitempty"`
	// ValueSet - Parameter value set.
	ValueSet *bool `json:"valueSet,omitempty"`
	// Variable - Parameter reference variable.
	Variable *string `json:"variable,omitempty"`
}

// SsisProject ssis project.
type SsisProject struct {
	// FolderID - Folder id which contains project.
	FolderID *int64 `json:"folderId,omitempty"`
	// Version - Project version.
	Version *int64 `json:"version,omitempty"`
	// EnvironmentRefs - Environment reference in project
	EnvironmentRefs *[]SsisEnvironmentReference `json:"environmentRefs,omitempty"`
	// Parameters - Parameters in project
	Parameters *[]SsisParameter `json:"parameters,omitempty"`
	// ID - Metadata id.
	ID *int64 `json:"id,omitempty"`
	// Name - Metadata name.
	Name *string `json:"name,omitempty"`
	// Description - Metadata description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeSsisObjectMetadata', 'TypeFolder', 'TypeProject', 'TypePackage', 'TypeEnvironment'
	Type TypeBasicSsisObjectMetadata `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SsisProject.
func (sp SsisProject) MarshalJSON() ([]byte, error) {
	sp.Type = TypeProject
	objectMap := make(map[string]interface{})
	if sp.FolderID != nil {
		objectMap["folderId"] = sp.FolderID
	}
	if sp.Version != nil {
		objectMap["version"] = sp.Version
	}
	if sp.EnvironmentRefs != nil {
		objectMap["environmentRefs"] = sp.EnvironmentRefs
	}
	if sp.Parameters != nil {
		objectMap["parameters"] = sp.Parameters
	}
	if sp.ID != nil {
		objectMap["id"] = sp.ID
	}
	if sp.Name != nil {
		objectMap["name"] = sp.Name
	}
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	if sp.Type != "" {
		objectMap["type"] = sp.Type
	}
	return json.Marshal(objectMap)
}

// AsSsisFolder is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsSsisFolder() (*SsisFolder, bool) {
	return nil, false
}

// AsSsisProject is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsSsisProject() (*SsisProject, bool) {
	return &sp, true
}

// AsSsisPackage is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsSsisPackage() (*SsisPackage, bool) {
	return nil, false
}

// AsSsisEnvironment is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsSsisEnvironment() (*SsisEnvironment, bool) {
	return nil, false
}

// AsSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsSsisObjectMetadata() (*SsisObjectMetadata, bool) {
	return nil, false
}

// AsBasicSsisObjectMetadata is the BasicSsisObjectMetadata implementation for SsisProject.
func (sp SsisProject) AsBasicSsisObjectMetadata() (BasicSsisObjectMetadata, bool) {
	return &sp, true
}

// SsisVariable ssis variable.
type SsisVariable struct {
	// ID - Variable id.
	ID *int64 `json:"id,omitempty"`
	// Name - Variable name.
	Name *string `json:"name,omitempty"`
	// Description - Variable description.
	Description *string `json:"description,omitempty"`
	// DataType - Variable type.
	DataType *string `json:"dataType,omitempty"`
	// Sensitive - Whether variable is sensitive.
	Sensitive *bool `json:"sensitive,omitempty"`
	// Value - Variable value.
	Value *string `json:"value,omitempty"`
	// SensitiveValue - Variable sensitive value.
	SensitiveValue *string `json:"sensitiveValue,omitempty"`
}

// SubResource azure Synapse nested resource, which belongs to a workspace.
type SubResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// TopQueries a database query.
type TopQueries struct {
	// AggregationFunction - READ-ONLY; The function that is used to aggregate each query's metrics. Possible values include: 'Min', 'Max', 'Avg', 'Sum'
	AggregationFunction QueryAggregationFunction `json:"aggregationFunction,omitempty"`
	// ExecutionType - READ-ONLY; The execution type that is used to filter the query instances that are returned. Possible values include: 'Any', 'Regular', 'Irregular', 'Aborted', 'Exception'
	ExecutionType QueryExecutionType `json:"executionType,omitempty"`
	// IntervalType - READ-ONLY; The duration of the interval (ISO8601 duration format).
	IntervalType *string `json:"intervalType,omitempty"`
	// NumberOfTopQueries - READ-ONLY; The number of requested queries.
	NumberOfTopQueries *float64 `json:"numberOfTopQueries,omitempty"`
	// ObservationStartTime - READ-ONLY; The start time for queries that are returned (ISO8601 format)
	ObservationStartTime *date.Time `json:"observationStartTime,omitempty"`
	// ObservationEndTime - READ-ONLY; The end time for queries that are returned (ISO8601 format)
	ObservationEndTime *date.Time `json:"observationEndTime,omitempty"`
	// ObservedMetric - READ-ONLY; The type of metric to use for ordering the top metrics. Possible values include: 'CPU', 'Io', 'Logio', 'Duration', 'ExecutionCount'
	ObservedMetric QueryObservedMetricType `json:"observedMetric,omitempty"`
	// Queries - READ-ONLY; The list of queries.
	Queries *[]QueryStatistic `json:"queries,omitempty"`
}

// TopQueriesListResult represents the response to a get top queries request.
type TopQueriesListResult struct {
	// Value - The list of top queries.
	Value *[]TopQueries `json:"value,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a Sql pool transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionListResult a list of transparent data encryption configurations.
type TransparentDataEncryptionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]TransparentDataEncryption `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransparentDataEncryptionListResultIterator provides access to a complete listing of
// TransparentDataEncryption values.
type TransparentDataEncryptionListResultIterator struct {
	i    int
	page TransparentDataEncryptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransparentDataEncryptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransparentDataEncryptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransparentDataEncryptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransparentDataEncryptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransparentDataEncryptionListResultIterator) Response() TransparentDataEncryptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransparentDataEncryptionListResultIterator) Value() TransparentDataEncryption {
	if !iter.page.NotDone() {
		return TransparentDataEncryption{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransparentDataEncryptionListResultIterator type.
func NewTransparentDataEncryptionListResultIterator(page TransparentDataEncryptionListResultPage) TransparentDataEncryptionListResultIterator {
	return TransparentDataEncryptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tdelr TransparentDataEncryptionListResult) IsEmpty() bool {
	return tdelr.Value == nil || len(*tdelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tdelr TransparentDataEncryptionListResult) hasNextLink() bool {
	return tdelr.NextLink != nil && len(*tdelr.NextLink) != 0
}

// transparentDataEncryptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tdelr TransparentDataEncryptionListResult) transparentDataEncryptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tdelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tdelr.NextLink)))
}

// TransparentDataEncryptionListResultPage contains a page of TransparentDataEncryption values.
type TransparentDataEncryptionListResultPage struct {
	fn    func(context.Context, TransparentDataEncryptionListResult) (TransparentDataEncryptionListResult, error)
	tdelr TransparentDataEncryptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransparentDataEncryptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransparentDataEncryptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tdelr)
		if err != nil {
			return err
		}
		page.tdelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransparentDataEncryptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransparentDataEncryptionListResultPage) NotDone() bool {
	return !page.tdelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransparentDataEncryptionListResultPage) Response() TransparentDataEncryptionListResult {
	return page.tdelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransparentDataEncryptionListResultPage) Values() []TransparentDataEncryption {
	if page.tdelr.IsEmpty() {
		return nil
	}
	return *page.tdelr.Value
}

// Creates a new instance of the TransparentDataEncryptionListResultPage type.
func NewTransparentDataEncryptionListResultPage(cur TransparentDataEncryptionListResult, getNextPage func(context.Context, TransparentDataEncryptionListResult) (TransparentDataEncryptionListResult, error)) TransparentDataEncryptionListResultPage {
	return TransparentDataEncryptionListResultPage{
		fn:    getNextPage,
		tdelr: cur,
	}
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// UpdateIntegrationRuntimeNodeRequest update integration runtime node request.
type UpdateIntegrationRuntimeNodeRequest struct {
	// ConcurrentJobsLimit - The number of concurrent jobs permitted to run on the integration runtime node. Values between 1 and maxConcurrentJobs(inclusive) are allowed.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty"`
}

// UpdateIntegrationRuntimeRequest update integration runtime request.
type UpdateIntegrationRuntimeRequest struct {
	// AutoUpdate - Enables or disables the auto-update feature of the self-hosted integration runtime. See https://go.microsoft.com/fwlink/?linkid=854189. Possible values include: 'On', 'Off'
	AutoUpdate IntegrationRuntimeAutoUpdate `json:"autoUpdate,omitempty"`
	// UpdateDelayOffset - The time offset (in hours) in the day, e.g., PT03H is 3 hours. The integration runtime auto update will happen on that time.
	UpdateDelayOffset *string `json:"updateDelayOffset,omitempty"`
}

// VirtualNetworkProfile virtual Network Profile
type VirtualNetworkProfile struct {
	// ComputeSubnetID - Subnet ID used for computes in workspace
	ComputeSubnetID *string `json:"computeSubnetId,omitempty"`
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring
// scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}

// VulnerabilityAssessmentScanError properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// VulnerabilityAssessmentScanRecord a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	autorest.Response `json:"-"`
	// VulnerabilityAssessmentScanRecordProperties - Resource properties.
	*VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecord.
func (vasr VulnerabilityAssessmentScanRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vasr.VulnerabilityAssessmentScanRecordProperties != nil {
		objectMap["properties"] = vasr.VulnerabilityAssessmentScanRecordProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VulnerabilityAssessmentScanRecord struct.
func (vasr *VulnerabilityAssessmentScanRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vulnerabilityAssessmentScanRecordProperties VulnerabilityAssessmentScanRecordProperties
				err = json.Unmarshal(*v, &vulnerabilityAssessmentScanRecordProperties)
				if err != nil {
					return err
				}
				vasr.VulnerabilityAssessmentScanRecordProperties = &vulnerabilityAssessmentScanRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vasr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vasr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vasr.Type = &typeVar
			}
		}
	}

	return nil
}

// VulnerabilityAssessmentScanRecordListResult a list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VulnerabilityAssessmentScanRecord `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VulnerabilityAssessmentScanRecordListResultIterator provides access to a complete listing of
// VulnerabilityAssessmentScanRecord values.
type VulnerabilityAssessmentScanRecordListResultIterator struct {
	i    int
	page VulnerabilityAssessmentScanRecordListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Response() VulnerabilityAssessmentScanRecordListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Value() VulnerabilityAssessmentScanRecord {
	if !iter.page.NotDone() {
		return VulnerabilityAssessmentScanRecord{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultIterator type.
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return VulnerabilityAssessmentScanRecordListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) IsEmpty() bool {
	return vasrlr.Value == nil || len(*vasrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) hasNextLink() bool {
	return vasrlr.NextLink != nil && len(*vasrlr.NextLink) != 0
}

// vulnerabilityAssessmentScanRecordListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) vulnerabilityAssessmentScanRecordListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vasrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vasrlr.NextLink)))
}

// VulnerabilityAssessmentScanRecordListResultPage contains a page of VulnerabilityAssessmentScanRecord
// values.
type VulnerabilityAssessmentScanRecordListResultPage struct {
	fn     func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)
	vasrlr VulnerabilityAssessmentScanRecordListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VulnerabilityAssessmentScanRecordListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vasrlr)
		if err != nil {
			return err
		}
		page.vasrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VulnerabilityAssessmentScanRecordListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VulnerabilityAssessmentScanRecordListResultPage) NotDone() bool {
	return !page.vasrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VulnerabilityAssessmentScanRecordListResultPage) Response() VulnerabilityAssessmentScanRecordListResult {
	return page.vasrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VulnerabilityAssessmentScanRecordListResultPage) Values() []VulnerabilityAssessmentScanRecord {
	if page.vasrlr.IsEmpty() {
		return nil
	}
	return *page.vasrlr.Value
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultPage type.
func NewVulnerabilityAssessmentScanRecordListResultPage(cur VulnerabilityAssessmentScanRecordListResult, getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return VulnerabilityAssessmentScanRecordListResultPage{
		fn:     getNextPage,
		vasrlr: cur,
	}
}

// VulnerabilityAssessmentScanRecordProperties properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// ScanID - READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty"`
	// TriggerType - READ-ONLY; The scan trigger type. Possible values include: 'OnDemand', 'Recurring'
	TriggerType VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty"`
	// State - READ-ONLY; The scan status. Possible values include: 'VulnerabilityAssessmentScanStatePassed', 'VulnerabilityAssessmentScanStateFailed', 'VulnerabilityAssessmentScanStateFailedToRun', 'VulnerabilityAssessmentScanStateInProgress'
	State VulnerabilityAssessmentScanState `json:"state,omitempty"`
	// StartTime - READ-ONLY; The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The scan end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// Errors - READ-ONLY; The scan errors.
	Errors *[]VulnerabilityAssessmentScanError `json:"errors,omitempty"`
	// StorageContainerPath - READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// NumberOfFailedSecurityChecks - READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty"`
}

// WorkloadClassifier workload classifier operations for a data warehouse
type WorkloadClassifier struct {
	autorest.Response `json:"-"`
	// WorkloadClassifierProperties - Resource properties.
	*WorkloadClassifierProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadClassifier.
func (wc WorkloadClassifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WorkloadClassifierProperties != nil {
		objectMap["properties"] = wc.WorkloadClassifierProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadClassifier struct.
func (wc *WorkloadClassifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadClassifierProperties WorkloadClassifierProperties
				err = json.Unmarshal(*v, &workloadClassifierProperties)
				if err != nil {
					return err
				}
				wc.WorkloadClassifierProperties = &workloadClassifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wc.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadClassifierListResult a list of workload classifiers for a workload group.
type WorkloadClassifierListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]WorkloadClassifier `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadClassifierListResultIterator provides access to a complete listing of WorkloadClassifier values.
type WorkloadClassifierListResultIterator struct {
	i    int
	page WorkloadClassifierListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadClassifierListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadClassifierListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadClassifierListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadClassifierListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadClassifierListResultIterator) Response() WorkloadClassifierListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadClassifierListResultIterator) Value() WorkloadClassifier {
	if !iter.page.NotDone() {
		return WorkloadClassifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadClassifierListResultIterator type.
func NewWorkloadClassifierListResultIterator(page WorkloadClassifierListResultPage) WorkloadClassifierListResultIterator {
	return WorkloadClassifierListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wclr WorkloadClassifierListResult) IsEmpty() bool {
	return wclr.Value == nil || len(*wclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wclr WorkloadClassifierListResult) hasNextLink() bool {
	return wclr.NextLink != nil && len(*wclr.NextLink) != 0
}

// workloadClassifierListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wclr WorkloadClassifierListResult) workloadClassifierListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wclr.NextLink)))
}

// WorkloadClassifierListResultPage contains a page of WorkloadClassifier values.
type WorkloadClassifierListResultPage struct {
	fn   func(context.Context, WorkloadClassifierListResult) (WorkloadClassifierListResult, error)
	wclr WorkloadClassifierListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadClassifierListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadClassifierListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wclr)
		if err != nil {
			return err
		}
		page.wclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadClassifierListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadClassifierListResultPage) NotDone() bool {
	return !page.wclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadClassifierListResultPage) Response() WorkloadClassifierListResult {
	return page.wclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadClassifierListResultPage) Values() []WorkloadClassifier {
	if page.wclr.IsEmpty() {
		return nil
	}
	return *page.wclr.Value
}

// Creates a new instance of the WorkloadClassifierListResultPage type.
func NewWorkloadClassifierListResultPage(cur WorkloadClassifierListResult, getNextPage func(context.Context, WorkloadClassifierListResult) (WorkloadClassifierListResult, error)) WorkloadClassifierListResultPage {
	return WorkloadClassifierListResultPage{
		fn:   getNextPage,
		wclr: cur,
	}
}

// WorkloadClassifierProperties workload classifier definition. For more information look at
// sys.workload_management_workload_classifiers (DMV).
type WorkloadClassifierProperties struct {
	// MemberName - The workload classifier member name.
	MemberName *string `json:"memberName,omitempty"`
	// Label - The workload classifier label.
	Label *string `json:"label,omitempty"`
	// Context - The workload classifier context.
	Context *string `json:"context,omitempty"`
	// StartTime - The workload classifier start time for classification.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The workload classifier end time for classification.
	EndTime *string `json:"endTime,omitempty"`
	// Importance - The workload classifier importance.
	Importance *string `json:"importance,omitempty"`
}

// WorkloadGroup workload group operations for a sql pool
type WorkloadGroup struct {
	autorest.Response `json:"-"`
	// WorkloadGroupProperties - Resource properties.
	*WorkloadGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadGroup.
func (wg WorkloadGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wg.WorkloadGroupProperties != nil {
		objectMap["properties"] = wg.WorkloadGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadGroup struct.
func (wg *WorkloadGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadGroupProperties WorkloadGroupProperties
				err = json.Unmarshal(*v, &workloadGroupProperties)
				if err != nil {
					return err
				}
				wg.WorkloadGroupProperties = &workloadGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wg.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadGroupListResult a list of workload groups.
type WorkloadGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]WorkloadGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadGroupListResultIterator provides access to a complete listing of WorkloadGroup values.
type WorkloadGroupListResultIterator struct {
	i    int
	page WorkloadGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadGroupListResultIterator) Response() WorkloadGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadGroupListResultIterator) Value() WorkloadGroup {
	if !iter.page.NotDone() {
		return WorkloadGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadGroupListResultIterator type.
func NewWorkloadGroupListResultIterator(page WorkloadGroupListResultPage) WorkloadGroupListResultIterator {
	return WorkloadGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wglr WorkloadGroupListResult) IsEmpty() bool {
	return wglr.Value == nil || len(*wglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wglr WorkloadGroupListResult) hasNextLink() bool {
	return wglr.NextLink != nil && len(*wglr.NextLink) != 0
}

// workloadGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wglr WorkloadGroupListResult) workloadGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wglr.NextLink)))
}

// WorkloadGroupListResultPage contains a page of WorkloadGroup values.
type WorkloadGroupListResultPage struct {
	fn   func(context.Context, WorkloadGroupListResult) (WorkloadGroupListResult, error)
	wglr WorkloadGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wglr)
		if err != nil {
			return err
		}
		page.wglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadGroupListResultPage) NotDone() bool {
	return !page.wglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadGroupListResultPage) Response() WorkloadGroupListResult {
	return page.wglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadGroupListResultPage) Values() []WorkloadGroup {
	if page.wglr.IsEmpty() {
		return nil
	}
	return *page.wglr.Value
}

// Creates a new instance of the WorkloadGroupListResultPage type.
func NewWorkloadGroupListResultPage(cur WorkloadGroupListResult, getNextPage func(context.Context, WorkloadGroupListResult) (WorkloadGroupListResult, error)) WorkloadGroupListResultPage {
	return WorkloadGroupListResultPage{
		fn:   getNextPage,
		wglr: cur,
	}
}

// WorkloadGroupProperties workload group definition. For more information look at
// sys.workload_management_workload_groups (DMV).
type WorkloadGroupProperties struct {
	// MinResourcePercent - The workload group minimum percentage resource.
	MinResourcePercent *int32 `json:"minResourcePercent,omitempty"`
	// MaxResourcePercent - The workload group cap percentage resource.
	MaxResourcePercent *int32 `json:"maxResourcePercent,omitempty"`
	// MinResourcePercentPerRequest - The workload group request minimum grant percentage.
	MinResourcePercentPerRequest *float64 `json:"minResourcePercentPerRequest,omitempty"`
	// MaxResourcePercentPerRequest - The workload group request maximum grant percentage.
	MaxResourcePercentPerRequest *float64 `json:"maxResourcePercentPerRequest,omitempty"`
	// Importance - The workload group importance level.
	Importance *string `json:"importance,omitempty"`
	// QueryExecutionTimeout - The workload group query execution timeout.
	QueryExecutionTimeout *int32 `json:"queryExecutionTimeout,omitempty"`
}

// Workspace a workspace
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Workspace resource properties
	*WorkspaceProperties `json:"properties,omitempty"`
	// Identity - Identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceAadAdminInfo workspace active directory administrator
type WorkspaceAadAdminInfo struct {
	autorest.Response `json:"-"`
	// AadAdminProperties - Workspace active directory administrator properties
	*AadAdminProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceAadAdminInfo.
func (waai WorkspaceAadAdminInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if waai.AadAdminProperties != nil {
		objectMap["properties"] = waai.AadAdminProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceAadAdminInfo struct.
func (waai *WorkspaceAadAdminInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aadAdminProperties AadAdminProperties
				err = json.Unmarshal(*v, &aadAdminProperties)
				if err != nil {
					return err
				}
				waai.AadAdminProperties = &aadAdminProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				waai.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				waai.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				waai.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceAadAdminsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceAadAdminsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceAadAdminsClient) (WorkspaceAadAdminInfo, error)
}

// WorkspaceAadAdminsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceAadAdminsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceAadAdminsClient) (autorest.Response, error)
}

// WorkspaceInfoListResult list of workspaces
type WorkspaceInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of workspaces
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceInfoListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceInfoListResultIterator struct {
	i    int
	page WorkspaceInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceInfoListResultIterator) Response() WorkspaceInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceInfoListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceInfoListResultIterator type.
func NewWorkspaceInfoListResultIterator(page WorkspaceInfoListResultPage) WorkspaceInfoListResultIterator {
	return WorkspaceInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wilr WorkspaceInfoListResult) IsEmpty() bool {
	return wilr.Value == nil || len(*wilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wilr WorkspaceInfoListResult) hasNextLink() bool {
	return wilr.NextLink != nil && len(*wilr.NextLink) != 0
}

// workspaceInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wilr WorkspaceInfoListResult) workspaceInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wilr.NextLink)))
}

// WorkspaceInfoListResultPage contains a page of Workspace values.
type WorkspaceInfoListResultPage struct {
	fn   func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)
	wilr WorkspaceInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wilr)
		if err != nil {
			return err
		}
		page.wilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceInfoListResultPage) NotDone() bool {
	return !page.wilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceInfoListResultPage) Response() WorkspaceInfoListResult {
	return page.wilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceInfoListResultPage) Values() []Workspace {
	if page.wilr.IsEmpty() {
		return nil
	}
	return *page.wilr.Value
}

// Creates a new instance of the WorkspaceInfoListResultPage type.
func NewWorkspaceInfoListResultPage(cur WorkspaceInfoListResult, getNextPage func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)) WorkspaceInfoListResultPage {
	return WorkspaceInfoListResultPage{
		fn:   getNextPage,
		wilr: cur,
	}
}

// WorkspaceKeyDetails details of the customer managed key associated with the workspace
type WorkspaceKeyDetails struct {
	// Name - Workspace Key sub-resource name
	Name *string `json:"name,omitempty"`
	// KeyVaultURL - Workspace Key sub-resource key vault url
	KeyVaultURL *string `json:"keyVaultUrl,omitempty"`
}

// WorkspaceManagedIdentitySQLControlSettingsCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type WorkspaceManagedIdentitySQLControlSettingsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceManagedIdentitySQLControlSettingsClient) (ManagedIdentitySQLControlSettingsModel, error)
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type WorkspaceManagedSQLServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceManagedSQLServerBlobAuditingPoliciesClient) (ServerBlobAuditingPolicy, error)
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring
// and retrieving the results of a long-running operation.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient) (ExtendedServerBlobAuditingPolicy, error)
}

// WorkspaceManagedSQLServerSecurityAlertPolicyCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type WorkspaceManagedSQLServerSecurityAlertPolicyCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceManagedSQLServerSecurityAlertPolicyClient) (ServerSecurityAlertPolicy, error)
}

// WorkspacePatchInfo workspace patch details
type WorkspacePatchInfo struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`
	// WorkspacePatchProperties - Workspace patch properties
	*WorkspacePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatchInfo.
func (wpi WorkspacePatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpi.Tags != nil {
		objectMap["tags"] = wpi.Tags
	}
	if wpi.Identity != nil {
		objectMap["identity"] = wpi.Identity
	}
	if wpi.WorkspacePatchProperties != nil {
		objectMap["properties"] = wpi.WorkspacePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatchInfo struct.
func (wpi *WorkspacePatchInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wpi.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				wpi.Identity = &identity
			}
		case "properties":
			if v != nil {
				var workspacePatchProperties WorkspacePatchProperties
				err = json.Unmarshal(*v, &workspacePatchProperties)
				if err != nil {
					return err
				}
				wpi.WorkspacePatchProperties = &workspacePatchProperties
			}
		}
	}

	return nil
}

// WorkspacePatchProperties workspace patch properties
type WorkspacePatchProperties struct {
	// SQLAdministratorLoginPassword - SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`
	// ManagedVirtualNetworkSettings - Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings `json:"managedVirtualNetworkSettings,omitempty"`
	// WorkspaceRepositoryConfiguration - Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration `json:"workspaceRepositoryConfiguration,omitempty"`
	// PurviewConfiguration - Purview Configuration
	PurviewConfiguration *PurviewConfiguration `json:"purviewConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Encryption - The encryption details of the workspace
	Encryption *EncryptionDetails `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatchProperties.
func (wpp WorkspacePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpp.SQLAdministratorLoginPassword != nil {
		objectMap["sqlAdministratorLoginPassword"] = wpp.SQLAdministratorLoginPassword
	}
	if wpp.ManagedVirtualNetworkSettings != nil {
		objectMap["managedVirtualNetworkSettings"] = wpp.ManagedVirtualNetworkSettings
	}
	if wpp.WorkspaceRepositoryConfiguration != nil {
		objectMap["workspaceRepositoryConfiguration"] = wpp.WorkspaceRepositoryConfiguration
	}
	if wpp.PurviewConfiguration != nil {
		objectMap["purviewConfiguration"] = wpp.PurviewConfiguration
	}
	if wpp.Encryption != nil {
		objectMap["encryption"] = wpp.Encryption
	}
	return json.Marshal(objectMap)
}

// WorkspaceProperties workspace properties
type WorkspaceProperties struct {
	// DefaultDataLakeStorage - Workspace default data lake storage account details
	DefaultDataLakeStorage *DataLakeStorageAccountDetails `json:"defaultDataLakeStorage,omitempty"`
	// SQLAdministratorLoginPassword - SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`
	// ManagedResourceGroupName - Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
	ManagedResourceGroupName *string `json:"managedResourceGroupName,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SQLAdministratorLogin - Login for workspace SQL active directory administrator
	SQLAdministratorLogin *string `json:"sqlAdministratorLogin,omitempty"`
	// VirtualNetworkProfile - Virtual Network profile
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
	// ConnectivityEndpoints - Connectivity endpoints
	ConnectivityEndpoints map[string]*string `json:"connectivityEndpoints"`
	// ManagedVirtualNetwork - Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
	ManagedVirtualNetwork *string `json:"managedVirtualNetwork,omitempty"`
	// PrivateEndpointConnections - Private endpoint connections to the workspace
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// Encryption - The encryption details of the workspace
	Encryption *EncryptionDetails `json:"encryption,omitempty"`
	// WorkspaceUID - READ-ONLY; The workspace unique identifier
	WorkspaceUID *uuid.UUID `json:"workspaceUID,omitempty"`
	// ExtraProperties - READ-ONLY; Workspace level configs and feature flags
	ExtraProperties map[string]interface{} `json:"extraProperties"`
	// ManagedVirtualNetworkSettings - Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings `json:"managedVirtualNetworkSettings,omitempty"`
	// WorkspaceRepositoryConfiguration - Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration `json:"workspaceRepositoryConfiguration,omitempty"`
	// PurviewConfiguration - Purview Configuration
	PurviewConfiguration *PurviewConfiguration `json:"purviewConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.DefaultDataLakeStorage != nil {
		objectMap["defaultDataLakeStorage"] = wp.DefaultDataLakeStorage
	}
	if wp.SQLAdministratorLoginPassword != nil {
		objectMap["sqlAdministratorLoginPassword"] = wp.SQLAdministratorLoginPassword
	}
	if wp.ManagedResourceGroupName != nil {
		objectMap["managedResourceGroupName"] = wp.ManagedResourceGroupName
	}
	if wp.SQLAdministratorLogin != nil {
		objectMap["sqlAdministratorLogin"] = wp.SQLAdministratorLogin
	}
	if wp.VirtualNetworkProfile != nil {
		objectMap["virtualNetworkProfile"] = wp.VirtualNetworkProfile
	}
	if wp.ConnectivityEndpoints != nil {
		objectMap["connectivityEndpoints"] = wp.ConnectivityEndpoints
	}
	if wp.ManagedVirtualNetwork != nil {
		objectMap["managedVirtualNetwork"] = wp.ManagedVirtualNetwork
	}
	if wp.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = wp.PrivateEndpointConnections
	}
	if wp.Encryption != nil {
		objectMap["encryption"] = wp.Encryption
	}
	if wp.ManagedVirtualNetworkSettings != nil {
		objectMap["managedVirtualNetworkSettings"] = wp.ManagedVirtualNetworkSettings
	}
	if wp.WorkspaceRepositoryConfiguration != nil {
		objectMap["workspaceRepositoryConfiguration"] = wp.WorkspaceRepositoryConfiguration
	}
	if wp.PurviewConfiguration != nil {
		objectMap["purviewConfiguration"] = wp.PurviewConfiguration
	}
	return json.Marshal(objectMap)
}

// WorkspaceRepositoryConfiguration git integration settings
type WorkspaceRepositoryConfiguration struct {
	// Type - Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
	Type *string `json:"type,omitempty"`
	// HostName - GitHub Enterprise host name. For example: https://github.mydomain.com
	HostName *string `json:"hostName,omitempty"`
	// AccountName - Account name
	AccountName *string `json:"accountName,omitempty"`
	// ProjectName - VSTS project name
	ProjectName *string `json:"projectName,omitempty"`
	// RepositoryName - Repository name
	RepositoryName *string `json:"repositoryName,omitempty"`
	// CollaborationBranch - Collaboration branch
	CollaborationBranch *string `json:"collaborationBranch,omitempty"`
	// RootFolder - Root folder to use in the repository
	RootFolder *string `json:"rootFolder,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (SetObject, error)
}

// WorkspaceSQLAadAdminsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceSQLAadAdminsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceSQLAadAdminsClient) (WorkspaceAadAdminInfo, error)
}

// WorkspaceSQLAadAdminsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceSQLAadAdminsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspaceSQLAadAdminsClient) (autorest.Response, error)
}

// WorkspacesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}
