package vmwarecloudsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/vmwarecloudsimple/mgmt/2019-04-01/vmwarecloudsimple"

// AvailableOperation resource provider available operation model
type AvailableOperation struct {
	// Display - The list of operations
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// IsDataAction - Indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Name - {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`
	// Origin - The origin of operation. Possible values include: 'User', 'System', 'Usersystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// AvailableOperationDisplayPropertyServiceSpecification - The list of operation properties
	*AvailableOperationDisplayPropertyServiceSpecification `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableOperation.
func (ao AvailableOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ao.Display != nil {
		objectMap["display"] = ao.Display
	}
	if ao.IsDataAction != nil {
		objectMap["isDataAction"] = ao.IsDataAction
	}
	if ao.Name != nil {
		objectMap["name"] = ao.Name
	}
	if ao.Origin != "" {
		objectMap["origin"] = ao.Origin
	}
	if ao.AvailableOperationDisplayPropertyServiceSpecification != nil {
		objectMap["properties"] = ao.AvailableOperationDisplayPropertyServiceSpecification
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableOperation struct.
func (ao *AvailableOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "display":
			if v != nil {
				var display AvailableOperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				ao.Display = &display
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				ao.IsDataAction = &isDataAction
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ao.Name = &name
			}
		case "origin":
			if v != nil {
				var origin OperationOrigin
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ao.Origin = origin
			}
		case "properties":
			if v != nil {
				var availableOperationDisplayPropertyServiceSpecification AvailableOperationDisplayPropertyServiceSpecification
				err = json.Unmarshal(*v, &availableOperationDisplayPropertyServiceSpecification)
				if err != nil {
					return err
				}
				ao.AvailableOperationDisplayPropertyServiceSpecification = &availableOperationDisplayPropertyServiceSpecification
			}
		}
	}

	return nil
}

// AvailableOperationDisplay resource provider available operation display model
type AvailableOperationDisplay struct {
	// Description - Description of the operation for display purposes
	Description *string `json:"description,omitempty"`
	// Operation - Name of the operation for display purposes
	Operation *string `json:"operation,omitempty"`
	// Provider - Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type for display purposes
	Resource *string `json:"resource,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecification available operation display property service
// specification model
type AvailableOperationDisplayPropertyServiceSpecification struct {
	// ServiceSpecification - The list of specification's service metrics
	ServiceSpecification *AvailableOperationDisplayPropertyServiceSpecificationMetricsList `json:"serviceSpecification,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsItem available operation display property
// service specification metrics item
type AvailableOperationDisplayPropertyServiceSpecificationMetricsItem struct {
	// AggregationType - Metric's aggregation type for e.g. (Average, Total). Possible values include: 'Average', 'Total'
	AggregationType AggregationType `json:"aggregationType,omitempty"`
	// DisplayDescription - Metric's description
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// DisplayName - Human readable metric's name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Metric's name/id
	Name *string `json:"name,omitempty"`
	// Unit - Metric's unit
	Unit *string `json:"unit,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsList list of available operation display
// property service specification metrics
type AvailableOperationDisplayPropertyServiceSpecificationMetricsList struct {
	// MetricSpecifications - Metric specifications of operation
	MetricSpecifications *[]AvailableOperationDisplayPropertyServiceSpecificationMetricsItem `json:"metricSpecifications,omitempty"`
}

// AvailableOperationsListResponse list of available operations
type AvailableOperationsListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of available operations
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Returns a list of available operations
	Value *[]AvailableOperation `json:"value,omitempty"`
}

// AvailableOperationsListResponseIterator provides access to a complete listing of AvailableOperation
// values.
type AvailableOperationsListResponseIterator struct {
	i    int
	page AvailableOperationsListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableOperationsListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableOperationsListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableOperationsListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableOperationsListResponseIterator) Response() AvailableOperationsListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableOperationsListResponseIterator) Value() AvailableOperation {
	if !iter.page.NotDone() {
		return AvailableOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableOperationsListResponseIterator type.
func NewAvailableOperationsListResponseIterator(page AvailableOperationsListResponsePage) AvailableOperationsListResponseIterator {
	return AvailableOperationsListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aolr AvailableOperationsListResponse) IsEmpty() bool {
	return aolr.Value == nil || len(*aolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aolr AvailableOperationsListResponse) hasNextLink() bool {
	return aolr.NextLink != nil && len(*aolr.NextLink) != 0
}

// availableOperationsListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aolr AvailableOperationsListResponse) availableOperationsListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !aolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aolr.NextLink)))
}

// AvailableOperationsListResponsePage contains a page of AvailableOperation values.
type AvailableOperationsListResponsePage struct {
	fn   func(context.Context, AvailableOperationsListResponse) (AvailableOperationsListResponse, error)
	aolr AvailableOperationsListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableOperationsListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aolr)
		if err != nil {
			return err
		}
		page.aolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableOperationsListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableOperationsListResponsePage) NotDone() bool {
	return !page.aolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableOperationsListResponsePage) Response() AvailableOperationsListResponse {
	return page.aolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableOperationsListResponsePage) Values() []AvailableOperation {
	if page.aolr.IsEmpty() {
		return nil
	}
	return *page.aolr.Value
}

// Creates a new instance of the AvailableOperationsListResponsePage type.
func NewAvailableOperationsListResponsePage(cur AvailableOperationsListResponse, getNextPage func(context.Context, AvailableOperationsListResponse) (AvailableOperationsListResponse, error)) AvailableOperationsListResponsePage {
	return AvailableOperationsListResponsePage{
		fn:   getNextPage,
		aolr: cur,
	}
}

// CSRPError general error model
type CSRPError struct {
	// Error - Error's body
	Error *CSRPErrorBody `json:"error,omitempty"`
}

// CSRPErrorBody error properties
type CSRPErrorBody struct {
	// Code - READ-ONLY; Error's code
	Code *string `json:"code,omitempty"`
	// Details - READ-ONLY; Error's details
	Details *[]CSRPErrorBody `json:"details,omitempty"`
	// Message - READ-ONLY; Error's message
	Message *string `json:"message,omitempty"`
	// Target - Error's target
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for CSRPErrorBody.
func (ceb CSRPErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ceb.Target != nil {
		objectMap["target"] = ceb.Target
	}
	return json.Marshal(objectMap)
}

// CustomizationHostName host name model
type CustomizationHostName struct {
	// Name - Hostname
	Name *string `json:"name,omitempty"`
	// Type - Type of host name. Possible values include: 'USERDEFINED', 'PREFIXBASED', 'FIXED', 'VIRTUALMACHINENAME', 'CUSTOMNAME'
	Type Type `json:"type,omitempty"`
}

// CustomizationIdentity ...
type CustomizationIdentity struct {
	// Data - Windows Text Identity. Prepared data
	Data *string `json:"data,omitempty"`
	// HostName - Virtual machine host name settings
	HostName *CustomizationHostName `json:"hostName,omitempty"`
	// Type - Identity type. Possible values include: 'WINDOWSTEXT', 'WINDOWS', 'LINUX'
	Type Type2 `json:"type,omitempty"`
	// UserData - Windows Identity. User data customization
	UserData *CustomizationIdentityUserData `json:"userData,omitempty"`
}

// CustomizationIdentityUserData windows Identity. User data customization
type CustomizationIdentityUserData struct {
	// IsPasswordPredefined - Is password predefined in customization policy
	IsPasswordPredefined *bool `json:"isPasswordPredefined,omitempty"`
}

// CustomizationIPAddress ...
type CustomizationIPAddress struct {
	// Argument - Argument when Custom ip type is selected
	Argument *string `json:"argument,omitempty"`
	// IPAddress - Defined Ip Address when Fixed ip type is selected
	IPAddress *string `json:"ipAddress,omitempty"`
	// Type - Customization Specification ip type. Possible values include: 'Type1CUSTOM', 'Type1DHCPIP', 'Type1FIXEDIP', 'Type1USERDEFINED'
	Type Type1 `json:"type,omitempty"`
}

// CustomizationIPSettings ...
type CustomizationIPSettings struct {
	// Gateway - The list of gateways
	Gateway *[]string `json:"gateway,omitempty"`
	// IP - Ip address customization settings
	IP *CustomizationIPAddress `json:"ip,omitempty"`
	// SubnetMask - Adapter subnet mask
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// CustomizationNicSetting ...
type CustomizationNicSetting struct {
	// Adapter - The list of adapters' settings
	Adapter *CustomizationIPSettings `json:"adapter,omitempty"`
	// MacAddress - NIC mac address
	MacAddress *string `json:"macAddress,omitempty"`
}

// CustomizationPoliciesListResponse list of customization polices response model
type CustomizationPoliciesListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of the Customization policy
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of the customization policies
	Value *[]CustomizationPolicy `json:"value,omitempty"`
}

// CustomizationPoliciesListResponseIterator provides access to a complete listing of CustomizationPolicy
// values.
type CustomizationPoliciesListResponseIterator struct {
	i    int
	page CustomizationPoliciesListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomizationPoliciesListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomizationPoliciesListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomizationPoliciesListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomizationPoliciesListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomizationPoliciesListResponseIterator) Response() CustomizationPoliciesListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomizationPoliciesListResponseIterator) Value() CustomizationPolicy {
	if !iter.page.NotDone() {
		return CustomizationPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomizationPoliciesListResponseIterator type.
func NewCustomizationPoliciesListResponseIterator(page CustomizationPoliciesListResponsePage) CustomizationPoliciesListResponseIterator {
	return CustomizationPoliciesListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr CustomizationPoliciesListResponse) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cplr CustomizationPoliciesListResponse) hasNextLink() bool {
	return cplr.NextLink != nil && len(*cplr.NextLink) != 0
}

// customizationPoliciesListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr CustomizationPoliciesListResponse) customizationPoliciesListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !cplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.NextLink)))
}

// CustomizationPoliciesListResponsePage contains a page of CustomizationPolicy values.
type CustomizationPoliciesListResponsePage struct {
	fn   func(context.Context, CustomizationPoliciesListResponse) (CustomizationPoliciesListResponse, error)
	cplr CustomizationPoliciesListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomizationPoliciesListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomizationPoliciesListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cplr)
		if err != nil {
			return err
		}
		page.cplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomizationPoliciesListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomizationPoliciesListResponsePage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomizationPoliciesListResponsePage) Response() CustomizationPoliciesListResponse {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomizationPoliciesListResponsePage) Values() []CustomizationPolicy {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// Creates a new instance of the CustomizationPoliciesListResponsePage type.
func NewCustomizationPoliciesListResponsePage(cur CustomizationPoliciesListResponse, getNextPage func(context.Context, CustomizationPoliciesListResponse) (CustomizationPoliciesListResponse, error)) CustomizationPoliciesListResponsePage {
	return CustomizationPoliciesListResponsePage{
		fn:   getNextPage,
		cplr: cur,
	}
}

// CustomizationPolicy the virtual machine customization policy
type CustomizationPolicy struct {
	autorest.Response `json:"-"`
	// ID - Customization policy azure id
	ID *string `json:"id,omitempty"`
	// Location - Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Customization policy name
	Name *string `json:"name,omitempty"`
	// CustomizationPolicyProperties - Customization Policy properties
	*CustomizationPolicyProperties `json:"properties,omitempty"`
	// Type - READ-ONLY
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomizationPolicy.
func (cp CustomizationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ID != nil {
		objectMap["id"] = cp.ID
	}
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.CustomizationPolicyProperties != nil {
		objectMap["properties"] = cp.CustomizationPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomizationPolicy struct.
func (cp *CustomizationPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "properties":
			if v != nil {
				var customizationPolicyProperties CustomizationPolicyProperties
				err = json.Unmarshal(*v, &customizationPolicyProperties)
				if err != nil {
					return err
				}
				cp.CustomizationPolicyProperties = &customizationPolicyProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomizationPolicyProperties the properties of Customization policy
type CustomizationPolicyProperties struct {
	// Description - Policy description
	Description *string `json:"description,omitempty"`
	// PrivateCloudID - The Private cloud id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
	// Specification - Detailed customization policy specification
	Specification *CustomizationSpecification `json:"specification,omitempty"`
	// Type - The type of customization (Linux or Windows). Possible values include: 'Type3LINUX', 'Type3WINDOWS'
	Type Type3 `json:"type,omitempty"`
	// Version - Policy version
	Version *string `json:"version,omitempty"`
}

// CustomizationSpecification the specification for Customization Policy
type CustomizationSpecification struct {
	// Identity - Customization Identity. It contains data about user and hostname
	Identity *CustomizationIdentity `json:"identity,omitempty"`
	// NicSettings - Network interface settings
	NicSettings *[]CustomizationNicSetting `json:"nicSettings,omitempty"`
}

// DedicatedCloudNode dedicated cloud node model
type DedicatedCloudNode struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudNodes/{dedicatedCloudNodeName}
	ID *string `json:"id,omitempty"`
	// Location - Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {dedicatedCloudNodeName}
	Name *string `json:"name,omitempty"`
	// DedicatedCloudNodeProperties - Dedicated Cloud Nodes properties
	*DedicatedCloudNodeProperties `json:"properties,omitempty"`
	// Sku - Dedicated Cloud Nodes SKU
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Dedicated Cloud Nodes tags
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedCloudNode.
func (dcn DedicatedCloudNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcn.Location != nil {
		objectMap["location"] = dcn.Location
	}
	if dcn.DedicatedCloudNodeProperties != nil {
		objectMap["properties"] = dcn.DedicatedCloudNodeProperties
	}
	if dcn.Sku != nil {
		objectMap["sku"] = dcn.Sku
	}
	if dcn.Tags != nil {
		objectMap["tags"] = dcn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedCloudNode struct.
func (dcn *DedicatedCloudNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcn.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcn.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcn.Name = &name
			}
		case "properties":
			if v != nil {
				var dedicatedCloudNodeProperties DedicatedCloudNodeProperties
				err = json.Unmarshal(*v, &dedicatedCloudNodeProperties)
				if err != nil {
					return err
				}
				dcn.DedicatedCloudNodeProperties = &dedicatedCloudNodeProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dcn.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcn.Tags = tags
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcn.Type = &typeVar
			}
		}
	}

	return nil
}

// DedicatedCloudNodeListResponse list of dedicated nodes response model
type DedicatedCloudNodeListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the DedicatedCloudNode list
	Value *[]DedicatedCloudNode `json:"value,omitempty"`
}

// DedicatedCloudNodeListResponseIterator provides access to a complete listing of DedicatedCloudNode
// values.
type DedicatedCloudNodeListResponseIterator struct {
	i    int
	page DedicatedCloudNodeListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DedicatedCloudNodeListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedCloudNodeListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DedicatedCloudNodeListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DedicatedCloudNodeListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DedicatedCloudNodeListResponseIterator) Response() DedicatedCloudNodeListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DedicatedCloudNodeListResponseIterator) Value() DedicatedCloudNode {
	if !iter.page.NotDone() {
		return DedicatedCloudNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DedicatedCloudNodeListResponseIterator type.
func NewDedicatedCloudNodeListResponseIterator(page DedicatedCloudNodeListResponsePage) DedicatedCloudNodeListResponseIterator {
	return DedicatedCloudNodeListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcnlr DedicatedCloudNodeListResponse) IsEmpty() bool {
	return dcnlr.Value == nil || len(*dcnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcnlr DedicatedCloudNodeListResponse) hasNextLink() bool {
	return dcnlr.NextLink != nil && len(*dcnlr.NextLink) != 0
}

// dedicatedCloudNodeListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcnlr DedicatedCloudNodeListResponse) dedicatedCloudNodeListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !dcnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcnlr.NextLink)))
}

// DedicatedCloudNodeListResponsePage contains a page of DedicatedCloudNode values.
type DedicatedCloudNodeListResponsePage struct {
	fn    func(context.Context, DedicatedCloudNodeListResponse) (DedicatedCloudNodeListResponse, error)
	dcnlr DedicatedCloudNodeListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DedicatedCloudNodeListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedCloudNodeListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcnlr)
		if err != nil {
			return err
		}
		page.dcnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DedicatedCloudNodeListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DedicatedCloudNodeListResponsePage) NotDone() bool {
	return !page.dcnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DedicatedCloudNodeListResponsePage) Response() DedicatedCloudNodeListResponse {
	return page.dcnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DedicatedCloudNodeListResponsePage) Values() []DedicatedCloudNode {
	if page.dcnlr.IsEmpty() {
		return nil
	}
	return *page.dcnlr.Value
}

// Creates a new instance of the DedicatedCloudNodeListResponsePage type.
func NewDedicatedCloudNodeListResponsePage(cur DedicatedCloudNodeListResponse, getNextPage func(context.Context, DedicatedCloudNodeListResponse) (DedicatedCloudNodeListResponse, error)) DedicatedCloudNodeListResponsePage {
	return DedicatedCloudNodeListResponsePage{
		fn:    getNextPage,
		dcnlr: cur,
	}
}

// DedicatedCloudNodeProperties properties of dedicated cloud node
type DedicatedCloudNodeProperties struct {
	// AvailabilityZoneID - Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string `json:"availabilityZoneId,omitempty"`
	// AvailabilityZoneName - READ-ONLY; Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string `json:"availabilityZoneName,omitempty"`
	// CloudRackName - READ-ONLY; VMWare Cloud Rack Name
	CloudRackName *string `json:"cloudRackName,omitempty"`
	// Created - READ-ONLY; date time the resource was created
	Created interface{} `json:"created,omitempty"`
	// NodesCount - count of nodes to create
	NodesCount *int32 `json:"nodesCount,omitempty"`
	// PlacementGroupID - Placement Group id, e.g. "n1"
	PlacementGroupID *string `json:"placementGroupId,omitempty"`
	// PlacementGroupName - READ-ONLY; Placement Name, e.g. "Placement Group 1"
	PlacementGroupName *string `json:"placementGroupName,omitempty"`
	// PrivateCloudID - READ-ONLY; Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
	// PrivateCloudName - READ-ONLY; Resource Pool Name
	PrivateCloudName *string `json:"privateCloudName,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PurchaseID - purchase id
	PurchaseID *uuid.UUID `json:"purchaseId,omitempty"`
	// SkuDescription - Dedicated Cloud Nodes SKU's description
	*SkuDescription `json:"skuDescription,omitempty"`
	// Status - READ-ONLY; Node status, indicates is private cloud set up on this node or not. Possible values include: 'Unused', 'Used'
	Status NodeStatus `json:"status,omitempty"`
	// VmwareClusterName - READ-ONLY; VMWare Cluster Name
	VmwareClusterName *string `json:"vmwareClusterName,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedCloudNodeProperties.
func (dcnp DedicatedCloudNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcnp.AvailabilityZoneID != nil {
		objectMap["availabilityZoneId"] = dcnp.AvailabilityZoneID
	}
	if dcnp.NodesCount != nil {
		objectMap["nodesCount"] = dcnp.NodesCount
	}
	if dcnp.PlacementGroupID != nil {
		objectMap["placementGroupId"] = dcnp.PlacementGroupID
	}
	if dcnp.PurchaseID != nil {
		objectMap["purchaseId"] = dcnp.PurchaseID
	}
	if dcnp.SkuDescription != nil {
		objectMap["skuDescription"] = dcnp.SkuDescription
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedCloudNodeProperties struct.
func (dcnp *DedicatedCloudNodeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "availabilityZoneId":
			if v != nil {
				var availabilityZoneID string
				err = json.Unmarshal(*v, &availabilityZoneID)
				if err != nil {
					return err
				}
				dcnp.AvailabilityZoneID = &availabilityZoneID
			}
		case "availabilityZoneName":
			if v != nil {
				var availabilityZoneName string
				err = json.Unmarshal(*v, &availabilityZoneName)
				if err != nil {
					return err
				}
				dcnp.AvailabilityZoneName = &availabilityZoneName
			}
		case "cloudRackName":
			if v != nil {
				var cloudRackName string
				err = json.Unmarshal(*v, &cloudRackName)
				if err != nil {
					return err
				}
				dcnp.CloudRackName = &cloudRackName
			}
		case "created":
			if v != nil {
				var created interface{}
				err = json.Unmarshal(*v, &created)
				if err != nil {
					return err
				}
				dcnp.Created = created
			}
		case "nodesCount":
			if v != nil {
				var nodesCount int32
				err = json.Unmarshal(*v, &nodesCount)
				if err != nil {
					return err
				}
				dcnp.NodesCount = &nodesCount
			}
		case "placementGroupId":
			if v != nil {
				var placementGroupID string
				err = json.Unmarshal(*v, &placementGroupID)
				if err != nil {
					return err
				}
				dcnp.PlacementGroupID = &placementGroupID
			}
		case "placementGroupName":
			if v != nil {
				var placementGroupName string
				err = json.Unmarshal(*v, &placementGroupName)
				if err != nil {
					return err
				}
				dcnp.PlacementGroupName = &placementGroupName
			}
		case "privateCloudId":
			if v != nil {
				var privateCloudID string
				err = json.Unmarshal(*v, &privateCloudID)
				if err != nil {
					return err
				}
				dcnp.PrivateCloudID = &privateCloudID
			}
		case "privateCloudName":
			if v != nil {
				var privateCloudName string
				err = json.Unmarshal(*v, &privateCloudName)
				if err != nil {
					return err
				}
				dcnp.PrivateCloudName = &privateCloudName
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				dcnp.ProvisioningState = &provisioningState
			}
		case "purchaseId":
			if v != nil {
				var purchaseID uuid.UUID
				err = json.Unmarshal(*v, &purchaseID)
				if err != nil {
					return err
				}
				dcnp.PurchaseID = &purchaseID
			}
		case "skuDescription":
			if v != nil {
				var skuDescription SkuDescription
				err = json.Unmarshal(*v, &skuDescription)
				if err != nil {
					return err
				}
				dcnp.SkuDescription = &skuDescription
			}
		case "status":
			if v != nil {
				var status NodeStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				dcnp.Status = status
			}
		case "vmwareClusterName":
			if v != nil {
				var vmwareClusterName string
				err = json.Unmarshal(*v, &vmwareClusterName)
				if err != nil {
					return err
				}
				dcnp.VmwareClusterName = &vmwareClusterName
			}
		}
	}

	return nil
}

// DedicatedCloudNodesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DedicatedCloudNodesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedCloudNodesClient) (DedicatedCloudNode, error)
}

// DedicatedCloudService dedicated cloud service model
type DedicatedCloudService struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudServices/{dedicatedCloudServiceName}
	ID *string `json:"id,omitempty"`
	// Location - Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {dedicatedCloudServiceName}
	Name *string `json:"name,omitempty"`
	// DedicatedCloudServiceProperties - The properties of Dedicated Node Service
	*DedicatedCloudServiceProperties `json:"properties,omitempty"`
	// Tags - The list of tags
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedCloudService.
func (dcs DedicatedCloudService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcs.Location != nil {
		objectMap["location"] = dcs.Location
	}
	if dcs.DedicatedCloudServiceProperties != nil {
		objectMap["properties"] = dcs.DedicatedCloudServiceProperties
	}
	if dcs.Tags != nil {
		objectMap["tags"] = dcs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedCloudService struct.
func (dcs *DedicatedCloudService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcs.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcs.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcs.Name = &name
			}
		case "properties":
			if v != nil {
				var dedicatedCloudServiceProperties DedicatedCloudServiceProperties
				err = json.Unmarshal(*v, &dedicatedCloudServiceProperties)
				if err != nil {
					return err
				}
				dcs.DedicatedCloudServiceProperties = &dedicatedCloudServiceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcs.Tags = tags
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcs.Type = &typeVar
			}
		}
	}

	return nil
}

// DedicatedCloudServiceListResponse list of dedicated cloud services
type DedicatedCloudServiceListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the DedicatedCloudService list
	Value *[]DedicatedCloudService `json:"value,omitempty"`
}

// DedicatedCloudServiceListResponseIterator provides access to a complete listing of DedicatedCloudService
// values.
type DedicatedCloudServiceListResponseIterator struct {
	i    int
	page DedicatedCloudServiceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DedicatedCloudServiceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedCloudServiceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DedicatedCloudServiceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DedicatedCloudServiceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DedicatedCloudServiceListResponseIterator) Response() DedicatedCloudServiceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DedicatedCloudServiceListResponseIterator) Value() DedicatedCloudService {
	if !iter.page.NotDone() {
		return DedicatedCloudService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DedicatedCloudServiceListResponseIterator type.
func NewDedicatedCloudServiceListResponseIterator(page DedicatedCloudServiceListResponsePage) DedicatedCloudServiceListResponseIterator {
	return DedicatedCloudServiceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcslr DedicatedCloudServiceListResponse) IsEmpty() bool {
	return dcslr.Value == nil || len(*dcslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcslr DedicatedCloudServiceListResponse) hasNextLink() bool {
	return dcslr.NextLink != nil && len(*dcslr.NextLink) != 0
}

// dedicatedCloudServiceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcslr DedicatedCloudServiceListResponse) dedicatedCloudServiceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !dcslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcslr.NextLink)))
}

// DedicatedCloudServiceListResponsePage contains a page of DedicatedCloudService values.
type DedicatedCloudServiceListResponsePage struct {
	fn    func(context.Context, DedicatedCloudServiceListResponse) (DedicatedCloudServiceListResponse, error)
	dcslr DedicatedCloudServiceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DedicatedCloudServiceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedCloudServiceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcslr)
		if err != nil {
			return err
		}
		page.dcslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DedicatedCloudServiceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DedicatedCloudServiceListResponsePage) NotDone() bool {
	return !page.dcslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DedicatedCloudServiceListResponsePage) Response() DedicatedCloudServiceListResponse {
	return page.dcslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DedicatedCloudServiceListResponsePage) Values() []DedicatedCloudService {
	if page.dcslr.IsEmpty() {
		return nil
	}
	return *page.dcslr.Value
}

// Creates a new instance of the DedicatedCloudServiceListResponsePage type.
func NewDedicatedCloudServiceListResponsePage(cur DedicatedCloudServiceListResponse, getNextPage func(context.Context, DedicatedCloudServiceListResponse) (DedicatedCloudServiceListResponse, error)) DedicatedCloudServiceListResponsePage {
	return DedicatedCloudServiceListResponsePage{
		fn:    getNextPage,
		dcslr: cur,
	}
}

// DedicatedCloudServiceProperties properties of dedicated cloud service
type DedicatedCloudServiceProperties struct {
	// GatewaySubnet - gateway Subnet for the account. It will collect the subnet address and always treat it as /28
	GatewaySubnet *string `json:"gatewaySubnet,omitempty"`
	// IsAccountOnboarded - READ-ONLY; indicates whether account onboarded or not in a given region. Possible values include: 'NotOnBoarded', 'OnBoarded', 'OnBoardingFailed', 'OnBoarding'
	IsAccountOnboarded OnboardingStatus `json:"isAccountOnboarded,omitempty"`
	// Nodes - READ-ONLY; total nodes purchased
	Nodes *int32 `json:"nodes,omitempty"`
	// ServiceURL - READ-ONLY; link to a service management web portal
	ServiceURL *string `json:"serviceURL,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedCloudServiceProperties.
func (dcsp DedicatedCloudServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcsp.GatewaySubnet != nil {
		objectMap["gatewaySubnet"] = dcsp.GatewaySubnet
	}
	return json.Marshal(objectMap)
}

// DedicatedCloudServicesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DedicatedCloudServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedCloudServicesClient) (autorest.Response, error)
}

// GuestOSCustomization guest OS Customization properties
type GuestOSCustomization struct {
	// DNSServers - List of dns servers to use
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// HostName - Virtual Machine hostname
	HostName *string `json:"hostName,omitempty"`
	// Password - Password for login
	Password *string `json:"password,omitempty"`
	// PolicyID - id of customization policy
	PolicyID *string `json:"policyId,omitempty"`
	// Username - Username for login
	Username *string `json:"username,omitempty"`
}

// GuestOSNICCustomization guest OS nic customization
type GuestOSNICCustomization struct {
	// Allocation - IP address allocation method. Possible values include: 'Static', 'Dynamic'
	Allocation Allocation `json:"allocation,omitempty"`
	// DNSServers - List of dns servers to use
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// Gateway - Gateway addresses assigned to nic
	Gateway *[]string `json:"gateway,omitempty"`
	// IPAddress - Static ip address for nic
	IPAddress *string `json:"ipAddress,omitempty"`
	// Mask - Network mask for nic
	Mask *string `json:"mask,omitempty"`
	// PrimaryWinsServer - primary WINS server for Windows
	PrimaryWinsServer *string `json:"primaryWinsServer,omitempty"`
	// SecondaryWinsServer - secondary WINS server for Windows
	SecondaryWinsServer *string `json:"secondaryWinsServer,omitempty"`
}

// OperationError operation error model
type OperationError struct {
	// Code - Error's code
	Code *string `json:"code,omitempty"`
	// Message - Error's message
	Message *string `json:"message,omitempty"`
}

// OperationResource operation status response
type OperationResource struct {
	autorest.Response `json:"-"`
	// EndTime - READ-ONLY; End time of the operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - Error Message if operation failed
	Error *OperationError `json:"error,omitempty"`
	// ID - READ-ONLY; Operation Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation ID
	Name *string `json:"name,omitempty"`
	// StartTime - READ-ONLY; Start time of the operation
	StartTime *date.Time `json:"startTime,omitempty"`
	// Status - READ-ONLY; Operation status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResource.
func (or OperationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Error != nil {
		objectMap["error"] = or.Error
	}
	return json.Marshal(objectMap)
}

// PatchPayload general patch payload modal
type PatchPayload struct {
	// Tags - The tags key:value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PatchPayload.
func (pp PatchPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Tags != nil {
		objectMap["tags"] = pp.Tags
	}
	return json.Marshal(objectMap)
}

// PrivateCloud private cloud model
type PrivateCloud struct {
	autorest.Response `json:"-"`
	// ID - Azure Id, e.g. "/subscriptions/4da99247-a172-4ed6-8ae9-ebed2d12f839/providers/Microsoft.VMwareCloudSimple/privateClouds/cloud123"
	ID *string `json:"id,omitempty"`
	// Location - Location where private cloud created, e.g "westus"
	Location *string `json:"location,omitempty"`
	// Name - Private cloud name
	Name *string `json:"name,omitempty"`
	// PrivateCloudProperties - Private cloud properties
	*PrivateCloudProperties `json:"properties,omitempty"`
	// Type - Azure Resource type. Possible values include: 'MicrosoftVMwareCloudSimpleprivateClouds'
	Type PrivateCloudResourceType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloud.
func (pc PrivateCloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.ID != nil {
		objectMap["id"] = pc.ID
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.PrivateCloudProperties != nil {
		objectMap["properties"] = pc.PrivateCloudProperties
	}
	if pc.Type != "" {
		objectMap["type"] = pc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloud struct.
func (pc *PrivateCloud) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pc.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "properties":
			if v != nil {
				var privateCloudProperties PrivateCloudProperties
				err = json.Unmarshal(*v, &privateCloudProperties)
				if err != nil {
					return err
				}
				pc.PrivateCloudProperties = &privateCloudProperties
			}
		case "type":
			if v != nil {
				var typeVar PrivateCloudResourceType
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = typeVar
			}
		}
	}

	return nil
}

// PrivateCloudList list of private clouds
type PrivateCloudList struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of Private Clouds
	NextLink *string `json:"nextLink,omitempty"`
	// Value - the list of private clouds
	Value *[]PrivateCloud `json:"value,omitempty"`
}

// PrivateCloudListIterator provides access to a complete listing of PrivateCloud values.
type PrivateCloudListIterator struct {
	i    int
	page PrivateCloudListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateCloudListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateCloudListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateCloudListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateCloudListIterator) Response() PrivateCloudList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateCloudListIterator) Value() PrivateCloud {
	if !iter.page.NotDone() {
		return PrivateCloud{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateCloudListIterator type.
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return PrivateCloudListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcl PrivateCloudList) IsEmpty() bool {
	return pcl.Value == nil || len(*pcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcl PrivateCloudList) hasNextLink() bool {
	return pcl.NextLink != nil && len(*pcl.NextLink) != 0
}

// privateCloudListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcl PrivateCloudList) privateCloudListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcl.NextLink)))
}

// PrivateCloudListPage contains a page of PrivateCloud values.
type PrivateCloudListPage struct {
	fn  func(context.Context, PrivateCloudList) (PrivateCloudList, error)
	pcl PrivateCloudList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateCloudListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcl)
		if err != nil {
			return err
		}
		page.pcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateCloudListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateCloudListPage) NotDone() bool {
	return !page.pcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateCloudListPage) Response() PrivateCloudList {
	return page.pcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateCloudListPage) Values() []PrivateCloud {
	if page.pcl.IsEmpty() {
		return nil
	}
	return *page.pcl.Value
}

// Creates a new instance of the PrivateCloudListPage type.
func NewPrivateCloudListPage(cur PrivateCloudList, getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return PrivateCloudListPage{
		fn:  getNextPage,
		pcl: cur,
	}
}

// PrivateCloudProperties properties of private
type PrivateCloudProperties struct {
	// AvailabilityZoneID - Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string `json:"availabilityZoneId,omitempty"`
	// AvailabilityZoneName - Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string `json:"availabilityZoneName,omitempty"`
	// ClustersNumber - Number of clusters
	ClustersNumber *int32 `json:"clustersNumber,omitempty"`
	// CreatedBy - User's emails who created cloud
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedOn - When private cloud was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// DNSServers - Array of DNS servers
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// Expires - Expiration date of PC
	Expires *string `json:"expires,omitempty"`
	// NsxType - Nsx Type, e.g. "Advanced"
	NsxType *string `json:"nsxType,omitempty"`
	// PlacementGroupID - Placement Group id, e.g. "n1"
	PlacementGroupID *string `json:"placementGroupId,omitempty"`
	// PlacementGroupName - Placement Group name
	PlacementGroupName *string `json:"placementGroupName,omitempty"`
	// PrivateCloudID - Id of a private cloud
	PrivateCloudID *uuid.UUID `json:"privateCloudId,omitempty"`
	// ResourcePools - The list of Resource Pools
	ResourcePools *[]ResourcePool `json:"resourcePools,omitempty"`
	// State - Private Cloud state, e.g. "operational"
	State *string `json:"state,omitempty"`
	// TotalCPUCores - Number of cores
	TotalCPUCores *int32 `json:"totalCpuCores,omitempty"`
	// TotalNodes - Number of nodes
	TotalNodes *int32 `json:"totalNodes,omitempty"`
	// TotalRAM - Memory size
	TotalRAM *int32 `json:"totalRam,omitempty"`
	// TotalStorage - Disk space in TB
	TotalStorage *float64 `json:"totalStorage,omitempty"`
	// Type - Virtualization type e.g. "vSphere"
	Type *string `json:"type,omitempty"`
	// VSphereVersion - e.g. "6.5u2"
	VSphereVersion *string `json:"vSphereVersion,omitempty"`
	// VcenterFqdn - FQDN for vcenter access
	VcenterFqdn *string `json:"vcenterFqdn,omitempty"`
	// VcenterRefid - Vcenter ip address
	VcenterRefid *string `json:"vcenterRefid,omitempty"`
	// VirtualMachineTemplates - The list of Virtual Machine Templates
	VirtualMachineTemplates *[]VirtualMachineTemplate `json:"virtualMachineTemplates,omitempty"`
	// VirtualNetworks - The list of Virtual Networks
	VirtualNetworks *[]VirtualNetwork `json:"virtualNetworks,omitempty"`
	// VrOpsEnabled - Is Vrops enabled/disabled
	VrOpsEnabled *bool `json:"vrOpsEnabled,omitempty"`
}

// ResourcePool resource pool model
type ResourcePool struct {
	autorest.Response `json:"-"`
	// ID - resource pool id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty"`
	// Location - READ-ONLY; Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {ResourcePoolName}
	Name *string `json:"name,omitempty"`
	// PrivateCloudID - READ-ONLY; The Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
	// ResourcePoolProperties - Resource pool properties
	*ResourcePoolProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourcePool.
func (rp ResourcePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.ID != nil {
		objectMap["id"] = rp.ID
	}
	if rp.ResourcePoolProperties != nil {
		objectMap["properties"] = rp.ResourcePoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourcePool struct.
func (rp *ResourcePool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "privateCloudId":
			if v != nil {
				var privateCloudID string
				err = json.Unmarshal(*v, &privateCloudID)
				if err != nil {
					return err
				}
				rp.PrivateCloudID = &privateCloudID
			}
		case "properties":
			if v != nil {
				var resourcePoolProperties ResourcePoolProperties
				err = json.Unmarshal(*v, &resourcePoolProperties)
				if err != nil {
					return err
				}
				rp.ResourcePoolProperties = &resourcePoolProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// ResourcePoolProperties properties of resource pool
type ResourcePoolProperties struct {
	// FullName - READ-ONLY; Hierarchical resource pool name
	FullName *string `json:"fullName,omitempty"`
}

// ResourcePoolsListResponse list of resource pools response model
type ResourcePoolsListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of ResourcePoolsList
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the Resource pools list
	Value *[]ResourcePool `json:"value,omitempty"`
}

// ResourcePoolsListResponseIterator provides access to a complete listing of ResourcePool values.
type ResourcePoolsListResponseIterator struct {
	i    int
	page ResourcePoolsListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourcePoolsListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourcePoolsListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourcePoolsListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourcePoolsListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourcePoolsListResponseIterator) Response() ResourcePoolsListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourcePoolsListResponseIterator) Value() ResourcePool {
	if !iter.page.NotDone() {
		return ResourcePool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourcePoolsListResponseIterator type.
func NewResourcePoolsListResponseIterator(page ResourcePoolsListResponsePage) ResourcePoolsListResponseIterator {
	return ResourcePoolsListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rplr ResourcePoolsListResponse) IsEmpty() bool {
	return rplr.Value == nil || len(*rplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rplr ResourcePoolsListResponse) hasNextLink() bool {
	return rplr.NextLink != nil && len(*rplr.NextLink) != 0
}

// resourcePoolsListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rplr ResourcePoolsListResponse) resourcePoolsListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !rplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rplr.NextLink)))
}

// ResourcePoolsListResponsePage contains a page of ResourcePool values.
type ResourcePoolsListResponsePage struct {
	fn   func(context.Context, ResourcePoolsListResponse) (ResourcePoolsListResponse, error)
	rplr ResourcePoolsListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourcePoolsListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourcePoolsListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rplr)
		if err != nil {
			return err
		}
		page.rplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourcePoolsListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourcePoolsListResponsePage) NotDone() bool {
	return !page.rplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourcePoolsListResponsePage) Response() ResourcePoolsListResponse {
	return page.rplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourcePoolsListResponsePage) Values() []ResourcePool {
	if page.rplr.IsEmpty() {
		return nil
	}
	return *page.rplr.Value
}

// Creates a new instance of the ResourcePoolsListResponsePage type.
func NewResourcePoolsListResponsePage(cur ResourcePoolsListResponse, getNextPage func(context.Context, ResourcePoolsListResponse) (ResourcePoolsListResponse, error)) ResourcePoolsListResponsePage {
	return ResourcePoolsListResponsePage{
		fn:   getNextPage,
		rplr: cur,
	}
}

// Sku the purchase SKU for CloudSimple paid resources
type Sku struct {
	// Capacity - The capacity of the SKU
	Capacity *string `json:"capacity,omitempty"`
	// Description - dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz DDR4 ECC Registered DIMM, ...
	Description *string `json:"description,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here
	Family *string `json:"family,omitempty"`
	// Name - The name of the SKU for VMWare CloudSimple Node
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU
	Tier *string `json:"tier,omitempty"`
}

// SkuAvailability SKU availability model
type SkuAvailability struct {
	// DedicatedAvailabilityZoneID - CloudSimple Availability Zone id
	DedicatedAvailabilityZoneID *string `json:"dedicatedAvailabilityZoneId,omitempty"`
	// DedicatedAvailabilityZoneName - CloudSimple Availability Zone Name
	DedicatedAvailabilityZoneName *string `json:"dedicatedAvailabilityZoneName,omitempty"`
	// DedicatedPlacementGroupID - CloudSimple Placement Group Id
	DedicatedPlacementGroupID *string `json:"dedicatedPlacementGroupId,omitempty"`
	// DedicatedPlacementGroupName - CloudSimple Placement Group name
	DedicatedPlacementGroupName *string `json:"dedicatedPlacementGroupName,omitempty"`
	// Limit - indicates how many resources of a given SKU is available in a AZ->PG
	Limit *int32 `json:"limit,omitempty"`
	// ResourceType - resource type e.g. DedicatedCloudNodes
	ResourceType *string `json:"resourceType,omitempty"`
	// SkuID - sku id
	SkuID *string `json:"skuId,omitempty"`
	// SkuName - sku name
	SkuName *string `json:"skuName,omitempty"`
}

// SkuAvailabilityListResponse list of SKU availabilities
type SkuAvailabilityListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the DedicatedPlacementGroupSkuAvailability list
	Value *[]SkuAvailability `json:"value,omitempty"`
}

// SkuAvailabilityListResponseIterator provides access to a complete listing of SkuAvailability values.
type SkuAvailabilityListResponseIterator struct {
	i    int
	page SkuAvailabilityListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuAvailabilityListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuAvailabilityListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuAvailabilityListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuAvailabilityListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuAvailabilityListResponseIterator) Response() SkuAvailabilityListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuAvailabilityListResponseIterator) Value() SkuAvailability {
	if !iter.page.NotDone() {
		return SkuAvailability{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuAvailabilityListResponseIterator type.
func NewSkuAvailabilityListResponseIterator(page SkuAvailabilityListResponsePage) SkuAvailabilityListResponseIterator {
	return SkuAvailabilityListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (salr SkuAvailabilityListResponse) IsEmpty() bool {
	return salr.Value == nil || len(*salr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (salr SkuAvailabilityListResponse) hasNextLink() bool {
	return salr.NextLink != nil && len(*salr.NextLink) != 0
}

// skuAvailabilityListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (salr SkuAvailabilityListResponse) skuAvailabilityListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !salr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(salr.NextLink)))
}

// SkuAvailabilityListResponsePage contains a page of SkuAvailability values.
type SkuAvailabilityListResponsePage struct {
	fn   func(context.Context, SkuAvailabilityListResponse) (SkuAvailabilityListResponse, error)
	salr SkuAvailabilityListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuAvailabilityListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuAvailabilityListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.salr)
		if err != nil {
			return err
		}
		page.salr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuAvailabilityListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuAvailabilityListResponsePage) NotDone() bool {
	return !page.salr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuAvailabilityListResponsePage) Response() SkuAvailabilityListResponse {
	return page.salr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuAvailabilityListResponsePage) Values() []SkuAvailability {
	if page.salr.IsEmpty() {
		return nil
	}
	return *page.salr.Value
}

// Creates a new instance of the SkuAvailabilityListResponsePage type.
func NewSkuAvailabilityListResponsePage(cur SkuAvailabilityListResponse, getNextPage func(context.Context, SkuAvailabilityListResponse) (SkuAvailabilityListResponse, error)) SkuAvailabilityListResponsePage {
	return SkuAvailabilityListResponsePage{
		fn:   getNextPage,
		salr: cur,
	}
}

// SkuDescription the purchase SKU for CloudSimple paid resources
type SkuDescription struct {
	// ID - SKU's id
	ID *string `json:"id,omitempty"`
	// Name - SKU's name
	Name *string `json:"name,omitempty"`
}

// Usage usage model
type Usage struct {
	// CurrentValue - The current usage value
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - limit of a given sku in a region for a subscription. The maximum permitted value for the usage quota. If there is no limit, this value will be -1
	Limit *int32 `json:"limit,omitempty"`
	// Name - Usage name value and localized name
	Name *UsageName `json:"name,omitempty"`
	// Unit - The usages' unit. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
	Unit UsageCount `json:"unit,omitempty"`
}

// UsageListResponse list of usages
type UsageListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; The list of usages
	Value *[]Usage `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageListResponse.
func (ulr UsageListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ulr.NextLink != nil {
		objectMap["nextLink"] = ulr.NextLink
	}
	return json.Marshal(objectMap)
}

// UsageListResponseIterator provides access to a complete listing of Usage values.
type UsageListResponseIterator struct {
	i    int
	page UsageListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageListResponseIterator) Response() UsageListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageListResponseIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageListResponseIterator type.
func NewUsageListResponseIterator(page UsageListResponsePage) UsageListResponseIterator {
	return UsageListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsageListResponse) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UsageListResponse) hasNextLink() bool {
	return ulr.NextLink != nil && len(*ulr.NextLink) != 0
}

// usageListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsageListResponse) usageListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !ulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsageListResponsePage contains a page of Usage values.
type UsageListResponsePage struct {
	fn  func(context.Context, UsageListResponse) (UsageListResponse, error)
	ulr UsageListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageListResponsePage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageListResponsePage) Response() UsageListResponse {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageListResponsePage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsageListResponsePage type.
func NewUsageListResponsePage(cur UsageListResponse, getNextPage func(context.Context, UsageListResponse) (UsageListResponse, error)) UsageListResponsePage {
	return UsageListResponsePage{
		fn:  getNextPage,
		ulr: cur,
	}
}

// UsageName user name model
type UsageName struct {
	// LocalizedValue - e.g. "Virtual Machines"
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - resource type or resource type sku name, e.g. virtualMachines
	Value *string `json:"value,omitempty"`
}

// VirtualDisk virtual disk model
type VirtualDisk struct {
	// ControllerID - Disk's Controller id
	ControllerID *string `json:"controllerId,omitempty"`
	// IndependenceMode - Disk's independence mode type. Possible values include: 'Persistent', 'IndependentPersistent', 'IndependentNonpersistent'
	IndependenceMode DiskIndependenceMode `json:"independenceMode,omitempty"`
	// TotalSize - Disk's total size
	TotalSize *int32 `json:"totalSize,omitempty"`
	// VirtualDiskID - Disk's id
	VirtualDiskID *string `json:"virtualDiskId,omitempty"`
	// VirtualDiskName - READ-ONLY; Disk's display name
	VirtualDiskName *string `json:"virtualDiskName,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualDisk.
func (vd VirtualDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vd.ControllerID != nil {
		objectMap["controllerId"] = vd.ControllerID
	}
	if vd.IndependenceMode != "" {
		objectMap["independenceMode"] = vd.IndependenceMode
	}
	if vd.TotalSize != nil {
		objectMap["totalSize"] = vd.TotalSize
	}
	if vd.VirtualDiskID != nil {
		objectMap["virtualDiskId"] = vd.VirtualDiskID
	}
	return json.Marshal(objectMap)
}

// VirtualDiskController virtual disk controller model
type VirtualDiskController struct {
	// ID - READ-ONLY; Controller's id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The display name of Controller
	Name *string `json:"name,omitempty"`
	// SubType - READ-ONLY; dik controller subtype (VMWARE_PARAVIRTUAL, BUS_PARALLEL, LSI_PARALLEL, LSI_SAS)
	SubType *string `json:"subType,omitempty"`
	// Type - READ-ONLY; disk controller type (SCSI)
	Type *string `json:"type,omitempty"`
}

// VirtualMachine virtual machine model
type VirtualMachine struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/virtualMachines/{virtualMachineName}
	ID *string `json:"id,omitempty"`
	// Location - Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {virtualMachineName}
	Name *string `json:"name,omitempty"`
	// VirtualMachineProperties - Virtual machine properties
	*VirtualMachineProperties `json:"properties,omitempty"`
	// Tags - The list of tags
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if VM.Location != nil {
		objectMap["location"] = VM.Location
	}
	if VM.VirtualMachineProperties != nil {
		objectMap["properties"] = VM.VirtualMachineProperties
	}
	if VM.Tags != nil {
		objectMap["tags"] = VM.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachine struct.
func (VM *VirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				VM.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				VM.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				VM.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineProperties VirtualMachineProperties
				err = json.Unmarshal(*v, &virtualMachineProperties)
				if err != nil {
					return err
				}
				VM.VirtualMachineProperties = &virtualMachineProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				VM.Tags = tags
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				VM.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualMachineListResponse list of virtual machines
type VirtualMachineListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of VirtualMachines
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the VirtualMachine list
	Value *[]VirtualMachine `json:"value,omitempty"`
}

// VirtualMachineListResponseIterator provides access to a complete listing of VirtualMachine values.
type VirtualMachineListResponseIterator struct {
	i    int
	page VirtualMachineListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineListResponseIterator) Response() VirtualMachineListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineListResponseIterator) Value() VirtualMachine {
	if !iter.page.NotDone() {
		return VirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineListResponseIterator type.
func NewVirtualMachineListResponseIterator(page VirtualMachineListResponsePage) VirtualMachineListResponseIterator {
	return VirtualMachineListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmlr VirtualMachineListResponse) IsEmpty() bool {
	return vmlr.Value == nil || len(*vmlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmlr VirtualMachineListResponse) hasNextLink() bool {
	return vmlr.NextLink != nil && len(*vmlr.NextLink) != 0
}

// virtualMachineListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmlr VirtualMachineListResponse) virtualMachineListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !vmlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmlr.NextLink)))
}

// VirtualMachineListResponsePage contains a page of VirtualMachine values.
type VirtualMachineListResponsePage struct {
	fn   func(context.Context, VirtualMachineListResponse) (VirtualMachineListResponse, error)
	vmlr VirtualMachineListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmlr)
		if err != nil {
			return err
		}
		page.vmlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineListResponsePage) NotDone() bool {
	return !page.vmlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineListResponsePage) Response() VirtualMachineListResponse {
	return page.vmlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineListResponsePage) Values() []VirtualMachine {
	if page.vmlr.IsEmpty() {
		return nil
	}
	return *page.vmlr.Value
}

// Creates a new instance of the VirtualMachineListResponsePage type.
func NewVirtualMachineListResponsePage(cur VirtualMachineListResponse, getNextPage func(context.Context, VirtualMachineListResponse) (VirtualMachineListResponse, error)) VirtualMachineListResponsePage {
	return VirtualMachineListResponsePage{
		fn:   getNextPage,
		vmlr: cur,
	}
}

// VirtualMachineProperties properties of virtual machine
type VirtualMachineProperties struct {
	// AmountOfRAM - The amount of memory
	AmountOfRAM *int32 `json:"amountOfRam,omitempty"`
	// Controllers - READ-ONLY; The list of Virtual Disks' Controllers
	Controllers *[]VirtualDiskController `json:"controllers,omitempty"`
	// Customization - Virtual machine properties
	Customization *GuestOSCustomization `json:"customization,omitempty"`
	// Disks - The list of Virtual Disks
	Disks *[]VirtualDisk `json:"disks,omitempty"`
	// Dnsname - READ-ONLY; The DNS name of Virtual Machine in VCenter
	Dnsname *string `json:"dnsname,omitempty"`
	// ExposeToGuestVM - Expose Guest OS or not
	ExposeToGuestVM *bool `json:"exposeToGuestVM,omitempty"`
	// Folder - READ-ONLY; The path to virtual machine folder in VCenter
	Folder *string `json:"folder,omitempty"`
	// GuestOS - READ-ONLY; The name of Guest OS
	GuestOS *string `json:"guestOS,omitempty"`
	// GuestOSType - READ-ONLY; The Guest OS type. Possible values include: 'Linux', 'Windows', 'Other'
	GuestOSType GuestOSType `json:"guestOSType,omitempty"`
	// Nics - The list of Virtual NICs
	Nics *[]VirtualNic `json:"nics,omitempty"`
	// NumberOfCores - The number of CPU cores
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// Password - Password for login. Deprecated - use customization property
	Password *string `json:"password,omitempty"`
	// PrivateCloudID - Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PublicIP - READ-ONLY; The public ip of Virtual Machine
	PublicIP *string `json:"publicIP,omitempty"`
	// ResourcePool - Virtual Machines Resource Pool
	ResourcePool *ResourcePool `json:"resourcePool,omitempty"`
	// Status - READ-ONLY; The status of Virtual machine. Possible values include: 'Running', 'Suspended', 'Poweredoff', 'Updating', 'Deallocating', 'Deleting'
	Status VirtualMachineStatus `json:"status,omitempty"`
	// TemplateID - Virtual Machine Template Id
	TemplateID *string `json:"templateId,omitempty"`
	// Username - Username for login. Deprecated - use customization property
	Username *string `json:"username,omitempty"`
	// VSphereNetworks - The list of Virtual VSphere Networks
	VSphereNetworks *[]string `json:"vSphereNetworks,omitempty"`
	// VMID - READ-ONLY; The internal id of Virtual Machine in VCenter
	VMID *string `json:"vmId,omitempty"`
	// Vmwaretools - READ-ONLY; VMware tools version
	Vmwaretools *string `json:"vmwaretools,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineProperties.
func (vmp VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmp.AmountOfRAM != nil {
		objectMap["amountOfRam"] = vmp.AmountOfRAM
	}
	if vmp.Customization != nil {
		objectMap["customization"] = vmp.Customization
	}
	if vmp.Disks != nil {
		objectMap["disks"] = vmp.Disks
	}
	if vmp.ExposeToGuestVM != nil {
		objectMap["exposeToGuestVM"] = vmp.ExposeToGuestVM
	}
	if vmp.Nics != nil {
		objectMap["nics"] = vmp.Nics
	}
	if vmp.NumberOfCores != nil {
		objectMap["numberOfCores"] = vmp.NumberOfCores
	}
	if vmp.Password != nil {
		objectMap["password"] = vmp.Password
	}
	if vmp.PrivateCloudID != nil {
		objectMap["privateCloudId"] = vmp.PrivateCloudID
	}
	if vmp.ResourcePool != nil {
		objectMap["resourcePool"] = vmp.ResourcePool
	}
	if vmp.TemplateID != nil {
		objectMap["templateId"] = vmp.TemplateID
	}
	if vmp.Username != nil {
		objectMap["username"] = vmp.Username
	}
	if vmp.VSphereNetworks != nil {
		objectMap["vSphereNetworks"] = vmp.VSphereNetworks
	}
	return json.Marshal(objectMap)
}

// VirtualMachinesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachine, error)
}

// VirtualMachinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// VirtualMachinesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// VirtualMachinesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// VirtualMachineStopMode list of virtual machine stop modes
type VirtualMachineStopMode struct {
	// Mode - mode indicates a type of stop operation - reboot, suspend, shutdown or power-off. Possible values include: 'Reboot', 'Suspend', 'Shutdown', 'Poweroff'
	Mode StopMode `json:"mode,omitempty"`
}

// VirtualMachinesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (VirtualMachine, error)
}

// VirtualMachineTemplate virtual machine template model
type VirtualMachineTemplate struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; virtual machine template id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty"`
	// Location - Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {virtualMachineTemplateName}
	Name *string `json:"name,omitempty"`
	// VirtualMachineTemplateProperties - The Virtual Machine Template properties
	*VirtualMachineTemplateProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineTemplate.
func (vmt VirtualMachineTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmt.Location != nil {
		objectMap["location"] = vmt.Location
	}
	if vmt.VirtualMachineTemplateProperties != nil {
		objectMap["properties"] = vmt.VirtualMachineTemplateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualMachineTemplate struct.
func (vmt *VirtualMachineTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vmt.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vmt.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vmt.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualMachineTemplateProperties VirtualMachineTemplateProperties
				err = json.Unmarshal(*v, &virtualMachineTemplateProperties)
				if err != nil {
					return err
				}
				vmt.VirtualMachineTemplateProperties = &virtualMachineTemplateProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vmt.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualMachineTemplateListResponse list of virtual machine templates
type VirtualMachineTemplateListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of VirtualMachineTemplate
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the VM template list
	Value *[]VirtualMachineTemplate `json:"value,omitempty"`
}

// VirtualMachineTemplateListResponseIterator provides access to a complete listing of
// VirtualMachineTemplate values.
type VirtualMachineTemplateListResponseIterator struct {
	i    int
	page VirtualMachineTemplateListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualMachineTemplateListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineTemplateListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualMachineTemplateListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualMachineTemplateListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualMachineTemplateListResponseIterator) Response() VirtualMachineTemplateListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualMachineTemplateListResponseIterator) Value() VirtualMachineTemplate {
	if !iter.page.NotDone() {
		return VirtualMachineTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualMachineTemplateListResponseIterator type.
func NewVirtualMachineTemplateListResponseIterator(page VirtualMachineTemplateListResponsePage) VirtualMachineTemplateListResponseIterator {
	return VirtualMachineTemplateListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vmtlr VirtualMachineTemplateListResponse) IsEmpty() bool {
	return vmtlr.Value == nil || len(*vmtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vmtlr VirtualMachineTemplateListResponse) hasNextLink() bool {
	return vmtlr.NextLink != nil && len(*vmtlr.NextLink) != 0
}

// virtualMachineTemplateListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vmtlr VirtualMachineTemplateListResponse) virtualMachineTemplateListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !vmtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vmtlr.NextLink)))
}

// VirtualMachineTemplateListResponsePage contains a page of VirtualMachineTemplate values.
type VirtualMachineTemplateListResponsePage struct {
	fn    func(context.Context, VirtualMachineTemplateListResponse) (VirtualMachineTemplateListResponse, error)
	vmtlr VirtualMachineTemplateListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualMachineTemplateListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineTemplateListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vmtlr)
		if err != nil {
			return err
		}
		page.vmtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualMachineTemplateListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualMachineTemplateListResponsePage) NotDone() bool {
	return !page.vmtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualMachineTemplateListResponsePage) Response() VirtualMachineTemplateListResponse {
	return page.vmtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualMachineTemplateListResponsePage) Values() []VirtualMachineTemplate {
	if page.vmtlr.IsEmpty() {
		return nil
	}
	return *page.vmtlr.Value
}

// Creates a new instance of the VirtualMachineTemplateListResponsePage type.
func NewVirtualMachineTemplateListResponsePage(cur VirtualMachineTemplateListResponse, getNextPage func(context.Context, VirtualMachineTemplateListResponse) (VirtualMachineTemplateListResponse, error)) VirtualMachineTemplateListResponsePage {
	return VirtualMachineTemplateListResponsePage{
		fn:    getNextPage,
		vmtlr: cur,
	}
}

// VirtualMachineTemplateProperties properties of virtual machine template
type VirtualMachineTemplateProperties struct {
	// AmountOfRAM - The amount of memory
	AmountOfRAM *int32 `json:"amountOfRam,omitempty"`
	// Controllers - The list of Virtual Disk Controllers
	Controllers *[]VirtualDiskController `json:"controllers,omitempty"`
	// Description - The description of Virtual Machine Template
	Description *string `json:"description,omitempty"`
	// Disks - The list of Virtual Disks
	Disks *[]VirtualDisk `json:"disks,omitempty"`
	// ExposeToGuestVM - Expose Guest OS or not
	ExposeToGuestVM *bool `json:"exposeToGuestVM,omitempty"`
	// GuestOS - READ-ONLY; The Guest OS
	GuestOS *string `json:"guestOS,omitempty"`
	// GuestOSType - READ-ONLY; The Guest OS types
	GuestOSType *string `json:"guestOSType,omitempty"`
	// Nics - The list of Virtual NICs
	Nics *[]VirtualNic `json:"nics,omitempty"`
	// NumberOfCores - The number of CPU cores
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// Path - path to folder
	Path *string `json:"path,omitempty"`
	// PrivateCloudID - The Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
	// VSphereNetworks - The list of VSphere networks
	VSphereNetworks *[]string `json:"vSphereNetworks,omitempty"`
	// VSphereTags - The tags from VSphere
	VSphereTags *[]string `json:"vSphereTags,omitempty"`
	// Vmwaretools - READ-ONLY; The VMware tools version
	Vmwaretools *string `json:"vmwaretools,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineTemplateProperties.
func (vmtp VirtualMachineTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vmtp.AmountOfRAM != nil {
		objectMap["amountOfRam"] = vmtp.AmountOfRAM
	}
	if vmtp.Controllers != nil {
		objectMap["controllers"] = vmtp.Controllers
	}
	if vmtp.Description != nil {
		objectMap["description"] = vmtp.Description
	}
	if vmtp.Disks != nil {
		objectMap["disks"] = vmtp.Disks
	}
	if vmtp.ExposeToGuestVM != nil {
		objectMap["exposeToGuestVM"] = vmtp.ExposeToGuestVM
	}
	if vmtp.Nics != nil {
		objectMap["nics"] = vmtp.Nics
	}
	if vmtp.NumberOfCores != nil {
		objectMap["numberOfCores"] = vmtp.NumberOfCores
	}
	if vmtp.Path != nil {
		objectMap["path"] = vmtp.Path
	}
	if vmtp.PrivateCloudID != nil {
		objectMap["privateCloudId"] = vmtp.PrivateCloudID
	}
	if vmtp.VSphereNetworks != nil {
		objectMap["vSphereNetworks"] = vmtp.VSphereNetworks
	}
	if vmtp.VSphereTags != nil {
		objectMap["vSphereTags"] = vmtp.VSphereTags
	}
	return json.Marshal(objectMap)
}

// VirtualNetwork virtual network model
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	// Assignable - READ-ONLY; can be used in vm creation/deletion
	Assignable *bool `json:"assignable,omitempty"`
	// ID - virtual network id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty"`
	// Location - READ-ONLY; Azure region
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; {VirtualNetworkName}
	Name *string `json:"name,omitempty"`
	// VirtualNetworkProperties - Virtual Network properties
	*VirtualNetworkProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.VirtualNetworkProperties != nil {
		objectMap["properties"] = vn.VirtualNetworkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "assignable":
			if v != nil {
				var assignable bool
				err = json.Unmarshal(*v, &assignable)
				if err != nil {
					return err
				}
				vn.Assignable = &assignable
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "properties":
			if v != nil {
				var virtualNetworkProperties VirtualNetworkProperties
				err = json.Unmarshal(*v, &virtualNetworkProperties)
				if err != nil {
					return err
				}
				vn.VirtualNetworkProperties = &virtualNetworkProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkListResponse list of virtual networks
type VirtualNetworkListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link for next list of VirtualNetwork
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Results of the VirtualNetwork list
	Value *[]VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkListResponseIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListResponseIterator struct {
	i    int
	page VirtualNetworkListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListResponseIterator) Response() VirtualNetworkListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListResponseIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkListResponseIterator type.
func NewVirtualNetworkListResponseIterator(page VirtualNetworkListResponsePage) VirtualNetworkListResponseIterator {
	return VirtualNetworkListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnlr VirtualNetworkListResponse) IsEmpty() bool {
	return vnlr.Value == nil || len(*vnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnlr VirtualNetworkListResponse) hasNextLink() bool {
	return vnlr.NextLink != nil && len(*vnlr.NextLink) != 0
}

// virtualNetworkListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlr VirtualNetworkListResponse) virtualNetworkListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !vnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlr.NextLink)))
}

// VirtualNetworkListResponsePage contains a page of VirtualNetwork values.
type VirtualNetworkListResponsePage struct {
	fn   func(context.Context, VirtualNetworkListResponse) (VirtualNetworkListResponse, error)
	vnlr VirtualNetworkListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnlr)
		if err != nil {
			return err
		}
		page.vnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListResponsePage) NotDone() bool {
	return !page.vnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListResponsePage) Response() VirtualNetworkListResponse {
	return page.vnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListResponsePage) Values() []VirtualNetwork {
	if page.vnlr.IsEmpty() {
		return nil
	}
	return *page.vnlr.Value
}

// Creates a new instance of the VirtualNetworkListResponsePage type.
func NewVirtualNetworkListResponsePage(cur VirtualNetworkListResponse, getNextPage func(context.Context, VirtualNetworkListResponse) (VirtualNetworkListResponse, error)) VirtualNetworkListResponsePage {
	return VirtualNetworkListResponsePage{
		fn:   getNextPage,
		vnlr: cur,
	}
}

// VirtualNetworkProperties properties of virtual network
type VirtualNetworkProperties struct {
	// PrivateCloudID - READ-ONLY; The Private Cloud id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`
}

// VirtualNic virtual NIC model
type VirtualNic struct {
	// Customization - guest OS customization for nic
	Customization *GuestOSNICCustomization `json:"customization,omitempty"`
	// IPAddresses - NIC ip address
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// MacAddress - NIC MAC address
	MacAddress *string `json:"macAddress,omitempty"`
	// Network - Virtual Network
	Network *VirtualNetwork `json:"network,omitempty"`
	// NicType - NIC type. Possible values include: 'E1000', 'E1000E', 'PCNET32', 'VMXNET', 'VMXNET2', 'VMXNET3'
	NicType NICType `json:"nicType,omitempty"`
	// PowerOnBoot - Is NIC powered on/off on boot
	PowerOnBoot *bool `json:"powerOnBoot,omitempty"`
	// VirtualNicID - NIC id
	VirtualNicID *string `json:"virtualNicId,omitempty"`
	// VirtualNicName - READ-ONLY; NIC name
	VirtualNicName *string `json:"virtualNicName,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNic.
func (vn VirtualNic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.Customization != nil {
		objectMap["customization"] = vn.Customization
	}
	if vn.IPAddresses != nil {
		objectMap["ipAddresses"] = vn.IPAddresses
	}
	if vn.MacAddress != nil {
		objectMap["macAddress"] = vn.MacAddress
	}
	if vn.Network != nil {
		objectMap["network"] = vn.Network
	}
	if vn.NicType != "" {
		objectMap["nicType"] = vn.NicType
	}
	if vn.PowerOnBoot != nil {
		objectMap["powerOnBoot"] = vn.PowerOnBoot
	}
	if vn.VirtualNicID != nil {
		objectMap["virtualNicId"] = vn.VirtualNicID
	}
	return json.Marshal(objectMap)
}
