package swedish_vocab_test

import (
	"testing"

	"github.com/blevesearch/snowball/swedish"
)

// Test a large set of words for which we know
// the correct stemmed form.
//
func Test_SwedishVocabulary(t *testing.T) {
	testCases := []struct {
		in  string
		out string
	}{
		{"a", "a"},
		{"aaele", "aael"},
		{"aah", "aah"},
		{"ab", "ab"},
		{"abba", "abb"},
		{"abborrar", "abborr"},
		{"abborrarna", "abborr"},
		{"abborre", "abborr"},
		{"abborrpinne", "abborrpin"},
		{"abc", "abc"},
		{"abednego", "abednego"},
		{"abort", "abort"},
		{"abrahams", "abraham"},
		{"absint", "absint"},
		{"abskons", "abskon"},
		{"absolut", "absolut"},
		{"ack", "ack"},
		{"ackompanjerade", "ackompanjer"},
		{"ackord", "ackord"},
		{"acllerbring", "acllerbring"},
		{"acob", "acob"},
		{"ad", "ad"},
		{"adclc", "adclc"},
		{"adcle", "adcl"},
		{"addra", "addr"},
		{"ade", "ade"},
		{"adeie", "adei"},
		{"adel", "adel"},
		{"adelc", "adelc"},
		{"adele", "adel"},
		{"adeles", "adel"},
		{"adelig", "ade"},
		{"adelns", "adeln"},
		{"adelsdam", "adelsdam"},
		{"adelsfröken", "adelsfrök"},
		{"adelskalendern", "adelskalend"},
		{"adelskalendrar", "adelskalendr"},
		{"adelskapen", "adelskap"},
		{"adelsman", "adelsman"},
		{"adelsmän", "adelsmän"},
		{"adelsvapen", "adelsvap"},
		{"aderton", "aderton"},
		{"adertonde", "adertond"},
		{"adertonhundratalet", "adertonhundratalet"},
		{"adertonskilling", "adertonskilling"},
		{"adjunkt", "adjunk"},
		{"adjunkten", "adjunk"},
		{"adjunktur", "adjunktur"},
		{"adjö", "adjö"},
		{"adlades", "adl"},
		{"adler", "adl"},
		{"adlerbeth", "adlerbeth"},
		{"adlig", "adl"},
		{"adliga", "adl"},
		{"adligt", "adl"},
		{"adolfs", "adolf"},
		{"adopterad", "adopter"},
		{"adopterade", "adopter"},
		{"adoratör", "adoratör"},
		{"adress", "adress"},
		{"adressen", "adress"},
		{"adressera", "adresser"},
		{"adresserade", "adresser"},
		{"adresserat", "adresser"},
		{"adt", "adt"},
		{"advent", "advent"},
		{"advoceras", "advocer"},
		{"advokat", "advok"},
		{"advokatyr", "advokatyr"},
		{"aek", "aek"},
		{"aet", "aet"},
		{"aeternitatis", "aeternitatis"},
		{"af", "af"},
		{"afbetalning", "afbetalning"},
		{"afbida", "afbid"},
		{"afbrott", "afbrot"},
		{"afbrutna", "afbrutn"},
		{"afbryta", "afbryt"},
		{"afbröt", "afbröt"},
		{"afdagatagne", "afdagatagn"},
		{"afdrag", "afdrag"},
		{"afdukadt", "afdukad"},
		{"affaires", "affair"},
		{"affallen", "affall"},
		{"affekterade", "affekter"},
		{"affär", "affär"},
		{"affärdande", "affärd"},
		{"affären", "affär"},
		{"affärer", "affär"},
		{"affärerna", "affär"},
		{"affärernas", "affär"},
		{"affärsbrev", "affärsbrev"},
		{"affärsman", "affärsman"},
		{"affärsmannen", "affärsman"},
		{"affärsmannens", "affärsman"},
		{"affärsmin", "affärsmin"},
		{"affärsmässig", "affärsmäss"},
		{"affärsmässiga", "affärsmäss"},
		{"affärsmässigt", "affärsmäss"},
		{"affärsställning", "affärsställning"},
		{"affärsställningen", "affärsställning"},
		{"affärsvänner", "affärsvän"},
		{"afgjord", "afgjord"},
		{"afgjordt", "afgjord"},
		{"afgjort", "afgjort"},
		{"afgrunden", "afgrund"},
		{"afgud", "afgud"},
		{"afgudade", "afgud"},
		{"afgudalika", "afgudalik"},
		{"afgöra", "afgör"},
		{"afhandla", "afhandl"},
		{"afhemta", "afhemt"},
		{"afhjelpa", "afhjelp"},
		{"afhuggen", "afhugg"},
		{"afhålla", "afhåll"},
		{"afhållen", "afhåll"},
		{"afhölja", "afhölj"},
		{"afhöll", "afhöll"},
		{"afhöra", "afhör"},
		{"afhörandet", "afhör"},
		{"afhörde", "afhörd"},
		{"afhört", "afhört"},
		{"afklippt", "afklippt"},
		{"afklädandet", "afkläd"},
		{"afkomman", "afkomman"},
		{"aflagda", "aflag"},
		{"aflyftat", "aflyft"},
		{"afläggare", "aflägg"},
		{"aflägsen", "aflägs"},
		{"aflägsna", "aflägsn"},
		{"aflägsnade", "aflägsn"},
		{"aflägsnare", "aflägsn"},
		{"aflägsnat", "aflägsn"},
		{"aflöper", "aflöp"},
		{"afmagrade", "afmagr"},
		{"afmätta", "afmät"},
		{"afmålade", "afmål"},
		{"afplanka", "afplank"},
		{"afpressade", "afpress"},
		{"afresa", "afres"},
		{"afresan", "afresan"},
		{"afreste", "afrest"},
		{"afri", "afri"},
		{"afrika", "afrik"},
		{"afrikahettan", "afrikahettan"},
		{"afsagt", "afsag"},
		{"afsats", "afsat"},
		{"afse", "afs"},
		{"afseende", "afseend"},
		{"afseenden", "afseend"},
		{"afsides", "afsid"},
		{"afskaffande", "afskaff"},
		{"afsked", "afsked"},
		{"afskedshelsning", "afskedshelsning"},
		{"afskedskopp", "afskedskopp"},
		{"afskedsstunden", "afskedsstund"},
		{"afskilda", "afskild"},
		{"afskilde", "afskild"},
		{"afskurit", "afskurit"},
		{"afsky", "afsky"},
		{"afslag", "afslag"},
		{"afslet", "afslet"},
		{"afslog", "afslog"},
		{"afsluta", "afslut"},
		{"afslutande", "afslut"},
		{"afslutat", "afslut"},
		{"afspisa", "afspis"},
		{"afsteg", "afsteg"},
		{"afstyrka", "afstyrk"},
		{"afstyrkt", "afstyrk"},
		{"afstå", "afstå"},
		{"afstånd", "afstånd"},
		{"afsändt", "afsänd"},
		{"aftaget", "aftaget"},
		{"aftagit", "aftagit"},
		{"aftnar", "aftn"},
		{"aftnarna", "aftn"},
		{"aftnarne", "aftn"},
		{"aftog", "aftog"},
		{"afton", "afton"},
		{"aftonblad", "aftonbl"},
		{"aftonbladet", "aftonbladet"},
		{"aftonbordet", "aftonbordet"},
		{"aftonbön", "aftonbön"},
		{"aftonen", "afton"},
		{"aftonens", "afton"},
		{"aftonfläktar", "aftonfläk"},
		{"aftonlampan", "aftonlampan"},
		{"aftonlandet", "aftonl"},
		{"aftonljuset", "aftonljuset"},
		{"aftonmåltid", "aftonmåltid"},
		{"aftonmåltiden", "aftonmåltid"},
		{"aftonpipan", "aftonpipan"},
		{"aftonpromenad", "aftonpromen"},
		{"aftonringningen", "aftonringning"},
		{"aftons", "afton"},
		{"aftonsken", "aftonsk"},
		{"aftonstjärnan", "aftonstjärnan"},
		{"aftonstund", "aftonstund"},
		{"aftonsällskap", "aftonsällskap"},
		{"aftonvinden", "aftonvind"},
		{"aftvungit", "aftvungit"},
		{"afund", "afund"},
		{"afundsjuka", "afundsjuk"},
		{"afundsvärd", "afundsvärd"},
		{"afundsvärdast", "afundsvärd"},
		{"afvakta", "afvak"},
		{"afvaktade", "afvak"},
		{"afvika", "afvik"},
		{"afvoghet", "afvog"},
		{"afväpnade", "afväpn"},
		{"afväpnades", "afväpn"},
		{"aga", "aga"},
		{"agan", "agan"},
		{"agaren", "agar"},
		{"agda", "agd"},
		{"agde", "agd"},
		{"age", "age"},
		{"agent", "agent"},
		{"agera", "ager"},
		{"agerande", "ager"},
		{"agg", "agg"},
		{"aggande", "agg"},
		{"agn", "agn"},
		{"agnar", "agn"},
		{"agnes", "agn"},
		{"agnet", "agnet"},
		{"ah", "ah"},
		{"air", "air"},
		{"aj", "aj"},
		{"ak", "ak"},
		{"akademien", "akademi"},
		{"akademikamrat", "akademikamr"},
		{"akademikamrater", "akademikamrat"},
		{"akademitid", "akademitid"},
		{"akardroskor", "akardrosk"},
		{"akrarna", "akr"},
		{"akrobat", "akrob"},
		{"aksgrå", "aksgrå"},
		{"akt", "akt"},
		{"akta", "akt"},
		{"aktad", "akt"},
		{"aktade", "akt"},
		{"aktar", "akt"},
		{"aktas", "akt"},
		{"aktat", "akt"},
		{"akten", "akt"},
		{"akterut", "akterut"},
		{"aktiebolag", "aktiebolag"},
		{"aktier", "akti"},
		{"aktierna", "akti"},
		{"aktning", "aktning"},
		{"aktningen", "aktning"},
		{"aktningsfull", "aktningsfull"},
		{"aktningsfullt", "aktningsfull"},
		{"aktningsvärd", "aktningsvärd"},
		{"aktningsvärda", "aktningsvärd"},
		{"aktningsvärde", "aktningsvärd"},
		{"aktningsvärt", "aktningsvärt"},
		{"aktsamt", "aktsamt"},
		{"aktuella", "aktuell"},
		{"aktör", "aktör"},
		{"akva", "akv"},
		{"akvavit", "akvavit"},
		{"al", "al"},
		{"alabaster", "alabast"},
		{"alarmera", "alarmer"},
		{"albuske", "albusk"},
		{"aldng", "aldng"},
		{"aldrig", "aldr"},
		{"alexander", "alexand"},
		{"alfred", "alfred"},
		{"alfvar", "alfv"},
		{"algeriet", "algeriet"},
		{"alice", "alic"},
		{"alkohol", "alkohol"},
		{"alkoholister", "alkoholist"},
		{"alkov", "alkov"},
		{"all", "all"},
		{"alla", "all"},
		{"allan", "allan"},
		{"allas", "all"},
		{"alldaglig", "alldag"},
		{"alldagliga", "alldag"},
		{"alldagligt", "alldag"},
		{"alldeles", "alldel"},
		{"alldenstund", "alldenstund"},
		{"alle", "all"},
		{"alleens", "alle"},
		{"alleer", "alle"},
		{"alleerna", "alle"},
		{"allegori", "allegori"},
		{"allehanda", "allehand"},
		{"allehandaunderliga", "allehandaunder"},
		{"allen", "all"},
		{"allena", "allen"},
		{"allenast", "allen"},
		{"allesam", "allesam"},
		{"allesamman", "allesamman"},
		{"allesammans", "allesamman"},
		{"allhelgonadag", "allhelgonadag"},
		{"allihop", "allihop"},
		{"allmakt", "allmak"},
		{"allmoge", "allmog"},
		{"allmogen", "allmog"},
		{"allmogens", "allmog"},
		{"allmän", "allmän"},
		{"allmänhet", "allmän"},
		{"allmänheten", "allmän"},
		{"allmänhetens", "allmän"},
		{"allmänna", "allmän"},
		{"allmännare", "allmän"},
		{"allmänt", "allmänt"},
		{"allo", "allo"},
		{"allod", "allod"},
		{"allom", "allom"},
		{"allra", "allr"},
		{"allraminst", "allraminst"},
		{"alls", "all"},
		{"allsköns", "allskön"},
		{"allsmägtige", "allsmägt"},
		{"allsmäktig", "allsmäkt"},
		{"allsmäktiga", "allsmäkt"},
		{"allt", "allt"},
		{"alltfor", "alltf"},
		{"alltfort", "alltfort"},
		{"alltför", "alltför"},
		{"alltid", "alltid"},
		{"alltihop", "alltihop"},
		{"alltihopa", "alltihop"},
		{"allting", "allting"},
		{"alltjämt", "alltjämt"},
		{"alltkl", "alltkl"},
		{"alltld", "alltld"},
		{"alltmer", "alltm"},
		{"alltmera", "alltmer"},
		{"alltomkring", "alltomkring"},
		{"alltsa", "allts"},
		{"alltsammams", "alltsammam"},
		{"alltsamman", "alltsamman"},
		{"alltsammans", "alltsamman"},
		{"alltsedan", "alltsedan"},
		{"alltså", "alltså"},
		{"alltäammans", "alltäamman"},
		{"allvar", "allv"},
		{"allvaret", "allvaret"},
		{"allvarlig", "allvar"},
		{"allvarliga", "allvar"},
		{"allvarligare", "allvar"},
		{"allvarligt", "allvar"},
		{"allvarsam", "allvarsam"},
		{"allvarsamma", "allvarsamm"},
		{"allvarsammare", "allvarsamm"},
		{"allvarsamme", "allvarsamm"},
		{"allvarsamt", "allvarsamt"},
		{"alm", "alm"},
		{"almanacka", "almanack"},
		{"almanackan", "almanackan"},
		{"almar", "alm"},
		{"aln", "aln"},
		{"alnar", "aln"},
		{"alsing", "alsing"},
		{"alska", "alsk"},
		{"alskade", "alsk"},
		{"alskande", "alsk"},
		{"alskar", "alsk"},
		{"alstern", "alst"},
		{"alstra", "alstr"},
		{"alstrade", "alstr"},
		{"alstring", "alstring"},
		{"alt", "alt"},
		{"alta", "alt"},
		{"altare", "alt"},
		{"altarens", "alt"},
		{"altaret", "altaret"},
		{"altarets", "altaret"},
		{"altarrunden", "altarrund"},
		{"altartavla", "altartavl"},
		{"altartavlan", "altartavlan"},
		{"altartavlor", "altartavl"},
		{"altartavlorna", "altartavl"},
		{"altid", "altid"},
		{"am", "am"},
		{"amarant", "amarant"},
		{"ambrosius", "ambrosius"},
		{"amen", "amen"},
		{"amerika", "amerik"},
		{"amerikansk", "amerikansk"},
		{"amerikanskt", "amerikansk"},
		{"ametist", "ametist"},
		{"ametister", "ametist"},
		{"ametyst", "ametyst"},
		{"amlan", "amlan"},
		{"amlar", "aml"},
		{"amlat", "aml"},
		{"ammar", "amm"},
		{"amnärkt", "amnärk"},
		{"amo", "amo"},
		{"amor", "amor"},
		{"amour", "amour"},
		{"amours", "amour"},
		{"amp", "amp"},
		{"ampall", "ampall"},
		{"ampla", "ampl"},
		{"amsikte", "amsik"},
		{"amsiktet", "amsiktet"},
		{"an", "an"},
		{"ana", "ana"},
		{"anade", "anad"},
		{"anamma", "anamm"},
		{"anande", "anand"},
		{"anar", "anar"},
		{"anas", "anas"},
		{"anat", "anat"},
		{"anbefalde", "anbefald"},
		{"anbefallde", "anbefalld"},
		{"anbelangar", "anbelang"},
		{"anblick", "anblick"},
		{"anblicken", "anblick"},
		{"anbud", "anbud"},
		{"anbudet", "anbudet"},
		{"anda", "and"},
		{"andades", "and"},
		{"andakt", "andak"},
		{"andakten", "andak"},
		{"andaktsbok", "andaktsbok"},
		{"andaktsfull", "andaktsfull"},
		{"andaktsstund", "andaktsstund"},
		{"andaktsstunder", "andaktsstund"},
		{"andamål", "andamål"},
		{"andan", "andan"},
		{"andande", "and"},
		{"andans", "andan"},
		{"andar", "and"},
		{"andarna", "and"},
		{"andas", "and"},
		{"ande", "and"},
		{"andedrag", "andedrag"},
		{"andedrägt", "andedräg"},
		{"andedräkt", "andedräk"},
		{"andedräkten", "andedräk"},
		{"andel", "andel"},
		{"anden", "and"},
		{"andersen", "anders"},
		{"andesång", "andesång"},
		{"andetag", "andetag"},
		{"andfadd", "andfad"},
		{"andfatt", "andfat"},
		{"andfådd", "andfåd"},
		{"andfått", "andfåt"},
		{"andlig", "and"},
		{"andliga", "and"},
		{"andlige", "and"},
		{"andligen", "and"},
		{"andligt", "and"},
		{"andlöst", "andlös"},
		{"andock", "andock"},
		{"andra", "andr"},
		{"andras", "andr"},
		{"andre", "andr"},
		{"andres", "andr"},
		{"androgyn", "androgyn"},
		{"andrum", "andrum"},
		{"andtäppa", "andtäpp"},
		{"andtäppan", "andtäppan"},
		{"andäktiga", "andäkt"},
		{"andäktigt", "andäkt"},
		{"andå", "andå"},
		{"anej", "anej"},
		{"anekdot", "anekdot"},
		{"anekdoten", "anekdot"},
		{"anekdoter", "anekdot"},
		{"anfall", "anfall"},
		{"anfallen", "anfall"},
		{"anför", "anför"},
		{"anföra", "anför"},
		{"anförande", "anför"},
		{"anförda", "anförd"},
		{"anförde", "anförd"},
		{"anförtro", "anförtro"},
		{"anförtrodda", "anförtrod"},
		{"anförtrodde", "anförtrod"},
		{"anförtroddes", "anförtrod"},
		{"anförtrott", "anförtrot"},
		{"anförvant", "anförvant"},
		{"anförvanters", "anförvanter"},
		{"angar", "ang"},
		{"angder", "angd"},
		{"ange", "ang"},
		{"angeia", "angei"},
		{"angel", "angel"},
		{"angela", "angel"},
		{"angelal", "angelal"},
		{"angelas", "angel"},
		{"angelicus", "angelicus"},
		{"angelo", "angelo"},
		{"angelägen", "angeläg"},
		{"angelägenhet", "angelägen"},
		{"angelägenheten", "angelägen"},
		{"angelägenheter", "angelägen"},
		{"angelägenheterna", "angelägen"},
		{"angeläget", "angeläget"},
		{"angelägna", "angelägn"},
		{"angelägnare", "angelägn"},
		{"angen", "ang"},
		{"angenäm", "angenäm"},
		{"angenäma", "angenäm"},
		{"angenämt", "angenämt"},
		{"angenärn", "angenärn"},
		{"angerfull", "angerfull"},
		{"angest", "angest"},
		{"angestfull", "angestfull"},
		{"angestfulla", "angestfull"},
		{"angick", "angick"},
		{"angifva", "angifv"},
		{"angifvelse", "angifv"},
		{"angivits", "angivit"},
		{"angrepp", "angrepp"},
		{"angripen", "angrip"},
		{"angriper", "angrip"},
		{"angränsande", "angräns"},
		{"angående", "angåend"},
		{"angår", "angår"},
		{"anholt", "anholt"},
		{"anhålla", "anhåll"},
		{"anhållan", "anhållan"},
		{"anhåller", "anhåll"},
		{"anhöll", "anhöll"},
		{"anhöriga", "anhör"},
		{"aning", "aning"},
		{"aningar", "aning"},
		{"aningen", "aning"},
		{"anjovis", "anjovis"},
		{"ankar", "ank"},
		{"ankare", "ank"},
		{"anklaga", "anklag"},
		{"anklagade", "anklag"},
		{"anklagande", "anklag"},
		{"anklagelsen", "anklag"},
		{"anklagelser", "anklag"},
		{"ankom", "ankom"},
		{"ankommet", "ankommet"},
		{"ankomst", "ankomst"},
		{"ankomsten", "ankomst"},
		{"anlag", "anlag"},
		{"anlagd", "anlag"},
		{"anlagen", "anlag"},
		{"anledning", "anledning"},
		{"anledningar", "anledning"},
		{"anledningarna", "anledning"},
		{"anledningen", "anledning"},
		{"anlet", "anlet"},
		{"anlete", "anlet"},
		{"anletes", "anlet"},
		{"anletsdrag", "anletsdrag"},
		{"anletsdragen", "anletsdrag"},
		{"anlita", "anlit"},
		{"anlitad", "anlit"},
		{"anlitades", "anlit"},
		{"anlitar", "anlit"},
		{"anläggning", "anläggning"},
		{"anlände", "anländ"},
		{"anlänt", "anlänt"},
		{"anmaning", "anmaning"},
		{"anmäla", "anmäl"},
		{"anmälan", "anmälan"},
		{"anmälandet", "anmäl"},
		{"anmäler", "anmäl"},
		{"anmält", "anmält"},
		{"anmärk", "anmärk"},
		{"anmärka", "anmärk"},
		{"anmärkning", "anmärkning"},
		{"anmärkningar", "anmärkning"},
		{"anmärkningen", "anmärkning"},
		{"anmärkningsvärda", "anmärkningsvärd"},
		{"anmärkningsvärdt", "anmärkningsvärd"},
		{"anmärkningsvärt", "anmärkningsvärt"},
		{"anmärktc", "anmärktc"},
		{"anmärkte", "anmärk"},
		{"ann", "ann"},
		{"anna", "ann"},
		{"annalkande", "annalk"},
		{"annan", "annan"},
		{"annans", "annan"},
		{"annars", "annar"},
		{"annat", "ann"},
		{"annexkyrkan", "annexkyrkan"},
		{"annika", "annik"},
		{"annikas", "annik"},
		{"annons", "annon"},
		{"annonsen", "annons"},
		{"annonser", "annons"},
		{"annonsera", "annonser"},
		{"annonserades", "annonser"},
		{"annor", "ann"},
		{"annorlm", "annorlm"},
		{"annorlunda", "annorlund"},
		{"annorstädes", "annorstäd"},
		{"annoterade", "annoter"},
		{"anns", "ann"},
		{"annu", "annu"},
		{"anonymt", "anonymt"},
		{"anordnande", "anordn"},
		{"anordningar", "anordning"},
		{"anordningen", "anordning"},
		{"anpassningsförmåga", "anpassningsförmåg"},
		{"anrep", "anrep"},
		{"anropa", "anrop"},
		{"anropade", "anrop"},
		{"anrättning", "anrättning"},
		{"anrättningen", "anrättning"},
		{"ans", "ans"},
		{"ansa", "ans"},
		{"ansade", "ans"},
		{"ansag", "ansag"},
		{"ansatt", "ansat"},
		{"ansatte", "ansat"},
		{"ansattes", "ansat"},
		{"anse", "ans"},
		{"ansedd", "ansed"},
		{"anseende", "anseend"},
		{"anser", "ans"},
		{"anses", "ans"},
		{"ansett", "anset"},
		{"ansigte", "ans"},
		{"ansigtes", "ans"},
		{"ansigtet", "ansigtet"},
		{"ansigtsdrag", "ansigtsdrag"},
		{"ansigtsdragen", "ansigtsdrag"},
		{"ansigtsmusklerna", "ansigtsmuskl"},
		{"ansikte", "ansik"},
		{"ansikten", "ansik"},
		{"ansiktena", "ansikten"},
		{"ansiktet", "ansiktet"},
		{"ansiktets", "ansiktet"},
		{"ansiktsdragens", "ansiktsdrag"},
		{"ansiktshy", "ansiktshy"},
		{"ansiktslupus", "ansiktslupus"},
		{"ansiktsmuskler", "ansiktsmuskl"},
		{"ansiktsuttryck", "ansiktsuttryck"},
		{"ansiktsuttrycket", "ansiktsuttrycket"},
		{"ansiktsytan", "ansiktsytan"},
		{"anskaffa", "anskaff"},
		{"anskaffades", "anskaff"},
		{"anskaffas", "anskaff"},
		{"anskrämliga", "anskräm"},
		{"anslag", "anslag"},
		{"anslagen", "anslag"},
		{"anslagit", "anslagit"},
		{"anslog", "anslog"},
		{"ansluta", "anslut"},
		{"anslå", "anslå"},
		{"anspelning", "anspelning"},
		{"ansprakslösa", "ansprakslös"},
		{"anspråk", "anspråk"},
		{"anspråket", "anspråket"},
		{"anspråksfulla", "anspråksfull"},
		{"anspråkslös", "anspråkslös"},
		{"anspråkslösa", "anspråkslös"},
		{"anspråkslösheten", "anspråkslös"},
		{"anspråkslöst", "anspråkslös"},
		{"anstalt", "anstalt"},
		{"anstalten", "anstalt"},
		{"anstalter", "anstalt"},
		{"anstod", "anstod"},
		{"anstodo", "anstodo"},
		{"anstrykning", "anstrykning"},
		{"anstränga", "ansträng"},
		{"ansträngande", "ansträng"},
		{"ansträngd", "ansträng"},
		{"ansträngda", "ansträng"},
		{"ansträngde", "ansträng"},
		{"anstränger", "ansträng"},
		{"ansträngning", "ansträngning"},
		{"ansträngningar", "ansträngning"},
		{"ansträngningen", "ansträngning"},
		{"ansträngt", "ansträng"},
		{"anställning", "anställning"},
		{"anständig", "anständ"},
		{"anständigt", "anständ"},
		{"anstå", "anstå"},
		{"anstånd", "anstånd"},
		{"anstår", "anstår"},
		{"anstått", "anståt"},
		{"anstötlig", "anstöt"},
		{"anstötligt", "anstöt"},
		{"ansvar", "ansv"},
		{"ansvara", "ansvar"},
		{"ansvarar", "ansvar"},
		{"ansvaret", "ansvaret"},
		{"ansvarsfull", "ansvarsfull"},
		{"ansätta", "ansät"},
		{"ansåg", "ansåg"},
		{"ansåge", "ansåg"},
		{"ansågo", "ansågo"},
		{"ansågs", "ansåg"},
		{"ant", "ant"},
		{"antag", "antag"},
		{"antaga", "antag"},
		{"antagandet", "antag"},
		{"antagas", "antag"},
		{"antagen", "antag"},
		{"antager", "antag"},
		{"antages", "antag"},
		{"antagit", "antagit"},
		{"antagligt", "antag"},
		{"antagna", "antagn"},
		{"antal", "antal"},
		{"antalet", "antalet"},
		{"antar", "ant"},
		{"antastad", "antast"},
		{"anteckna", "anteckn"},
		{"antecknat", "anteckn"},
		{"anteckningar", "anteckning"},
		{"anteckningarna", "anteckning"},
		{"anteckningsbok", "anteckningsbok"},
		{"anteckningsböcker", "anteckningsböck"},
		{"antenner", "anten"},
		{"antidreyfusistisk", "antidreyfusistisk"},
		{"antik", "antik"},
		{"antika", "antik"},
		{"antikvariat", "antikvari"},
		{"antikviteter", "antikvitet"},
		{"antingen", "anting"},
		{"antisemitism", "antisemitism"},
		{"antligen", "ant"},
		{"antog", "antog"},
		{"antogo", "antogo"},
		{"antogos", "antogo"},
		{"antogs", "antog"},
		{"antoinettefichyn", "antoinettefichyn"},
		{"anton", "anton"},
		{"antons", "anton"},
		{"anträd", "anträd"},
		{"anträdde", "anträd"},
		{"anträddes", "anträd"},
		{"antydan", "antydan"},
		{"antydda", "antyd"},
		{"antydde", "antyd"},
		{"antyder", "antyd"},
		{"antydningar", "antydning"},
		{"antytt", "antyt"},
		{"antågande", "antåg"},
		{"anvisad", "anvis"},
		{"anvisade", "anvis"},
		{"anvisat", "anvis"},
		{"använd", "använd"},
		{"använda", "använd"},
		{"användas", "använd"},
		{"använde", "använd"},
		{"använder", "använd"},
		{"användes", "använd"},
		{"användning", "användning"},
		{"användt", "använd"},
		{"använt", "använt"},
		{"använts", "använt"},
		{"apade", "apad"},
		{"apel", "apel"},
		{"apeltelning", "apeltelning"},
		{"apgossen", "apgoss"},
		{"apkäkar", "apkäk"},
		{"aplar", "apl"},
		{"apollinaris", "apollinaris"},
		{"apostlarne", "apostl"},
		{"apotekare", "apotek"},
		{"apotekarens", "apotek"},
		{"apoteket", "apoteket"},
		{"apparanser", "apparans"},
		{"apparition", "apparition"},
		{"applåd", "applåd"},
		{"applådcr", "applådcr"},
		{"applåder", "applåd"},
		{"applådsalvor", "applådsalv"},
		{"april", "april"},
		{"aprildag", "aprildag"},
		{"apropos", "apropo"},
		{"apropå", "apropå"},
		{"aptit", "aptit"},
		{"ar", "ar"},
		{"arabella", "arabell"},
		{"aramell", "aramell"},
		{"arangerad", "aranger"},
		{"aratal", "aratal"},
		{"arbeta", "arbet"},
		{"arbetad", "arbet"},
		{"arbetade", "arbet"},
		{"arbetar", "arbet"},
		{"arbetare", "arbet"},
		{"arbetat", "arbet"},
		{"arbete", "arbet"},
		{"arbeten", "arbet"},
		{"arbeterskor", "arbetersk"},
		{"arbetet", "arbetet"},
		{"arbetets", "arbetet"},
		{"arbetsam", "arbetsam"},
		{"arbetsamhet", "arbetsam"},
		{"arbetsamma", "arbetsamm"},
		{"arbetsblusar", "arbetsblus"},
		{"arbetsbord", "arbetsbord"},
		{"arbetsbördan", "arbetsbördan"},
		{"arbetsdag", "arbetsdag"},
		{"arbetsdagen", "arbetsdag"},
		{"arbetsdagern", "arbetsdag"},
		{"arbetsdrift", "arbetsdrift"},
		{"arbetsfordon", "arbetsfordon"},
		{"arbetsförmåga", "arbetsförmåg"},
		{"arbetshänderna", "arbetshänd"},
		{"arbetskläder", "arbetskläd"},
		{"arbetslag", "arbetslag"},
		{"arbetsmänniskor", "arbetsmännisk"},
		{"arbetsrum", "arbetsrum"},
		{"arbetssamhet", "arbetssam"},
		{"arbetstid", "arbetstid"},
		{"arbetsåkdon", "arbetsåkdon"},
		{"aren", "aren"},
		{"arets", "aret"},
		{"arftagare", "arftag"},
		{"arför", "arför"},
		{"arg", "arg"},
		{"arga", "arg"},
		{"argad", "arg"},
		{"argt", "argt"},
		{"argument", "argument"},
		{"argumenterade", "argumenter"},
		{"aristokrati", "aristokrati"},
		{"aristokratiska", "aristokratisk"},
		{"aristokratiskt", "aristokratisk"},
		{"arit", "arit"},
		{"ark", "ark"},
		{"arkad", "ark"},
		{"arkadisk", "arkadisk"},
		{"arken", "ark"},
		{"arket", "arket"},
		{"arkets", "arket"},
		{"arkipelag", "arkipelag"},
		{"arm", "arm"},
		{"arma", "arm"},
		{"armar", "arm"},
		{"armarna", "arm"},
		{"armarne", "arm"},
		{"armat", "arm"},
		{"armbagarna", "armbag"},
		{"armband", "armband"},
		{"armbågar", "armbåg"},
		{"armbågarna", "armbåg"},
		{"armbåge", "armbåg"},
		{"armbågen", "armbåg"},
		{"arme", "arm"},
		{"armen", "arm"},
		{"armhågarna", "armhåg"},
		{"armod", "armod"},
		{"armodet", "armodet"},
		{"armodets", "armodet"},
		{"armtag", "armtag"},
		{"arna", "arn"},
		{"arnman", "arnman"},
		{"arnmans", "arnman"},
		{"arnoldson", "arnoldson"},
		{"aro", "aro"},
		{"aron", "aron"},
		{"arrangerad", "arranger"},
		{"arrangerade", "arranger"},
		{"arrangerar", "arranger"},
		{"arrangeringen", "arrangering"},
		{"arren", "arr"},
		{"arrenda", "arrend"},
		{"arrendator", "arrendat"},
		{"arrendatorn", "arrendatorn"},
		{"arrendatorns", "arrendatorn"},
		{"arrendators", "arrendator"},
		{"arrendatorsbostadcn", "arrendatorsbostadcn"},
		{"arrendatorsbostaden", "arrendatorsbostad"},
		{"arrendatorsbostadens", "arrendatorsbostad"},
		{"arrendatorsbyggnaden", "arrendatorsbyggnad"},
		{"arrendatorsfrun", "arrendatorsfrun"},
		{"arrer", "arr"},
		{"arrest", "arrest"},
		{"arsenik", "arsenik"},
		{"art", "art"},
		{"artade", "art"},
		{"artar", "art"},
		{"arten", "art"},
		{"artificiella", "artificiell"},
		{"artig", "art"},
		{"artiga", "art"},
		{"artigaste", "art"},
		{"artige", "art"},
		{"artighet", "art"},
		{"artigheten", "art"},
		{"artigheter", "art"},
		{"artigheterna", "art"},
		{"artighetsskratt", "artighetsskrat"},
		{"artigt", "art"},
		{"artikel", "artikel"},
		{"artiklar", "artikl"},
		{"artiklarna", "artikl"},
		{"artistiskt", "artistisk"},
		{"arv", "arv"},
		{"arve", "arv"},
		{"arvedel", "arvedel"},
		{"arves", "arv"},
		{"arvet", "arvet"},
		{"arvid", "arvid"},
		{"arvingar", "arving"},
		{"arvingarnas", "arving"},
		{"arvinge", "arving"},
		{"arvingen", "arving"},
		{"arvlös", "arvlös"},
		{"arvsfrågan", "arvsfrågan"},
		{"arvtagaren", "arvtag"},
		{"arvtagerska", "arvtagersk"},
		{"as", "as"},
		{"asikt", "asik"},
		{"ask", "ask"},
		{"aska", "ask"},
		{"askan", "askan"},
		{"askarna", "ask"},
		{"asken", "ask"},
		{"askenberg", "askenberg"},
		{"askenbergs", "askenberg"},
		{"askgrå", "askgrå"},
		{"asmundssons", "asmundsson"},
		{"asp", "asp"},
		{"aspar", "asp"},
		{"asparna", "asp"},
		{"associerad", "associer"},
		{"assurerat", "assurer"},
		{"astolf", "astolf"},
		{"astrar", "astr"},
		{"astrarna", "astr"},
		{"astronomiska", "astronomisk"},
		{"asynen", "asyn"},
		{"at", "at"},
		{"atelje", "atelj"},
		{"atenarna", "aten"},
		{"atenienn", "atenien"},
		{"ateniennen", "atenien"},
		{"ater", "ater"},
		{"atertaga", "atertag"},
		{"atervända", "atervänd"},
		{"atervånt", "atervånt"},
		{"atl", "atl"},
		{"atltså", "atltså"},
		{"atminstone", "atminston"},
		{"atmosferen", "atmosfer"},
		{"atmosfären", "atmosfär"},
		{"atmosfäriska", "atmosfärisk"},
		{"atog", "atog"},
		{"att", "att"},
		{"attachemang", "attachemang"},
		{"attachement", "attachement"},
		{"attbar", "attb"},
		{"atterbom", "atterbom"},
		{"attesten", "attest"},
		{"attiofjerde", "attiofjerd"},
		{"attityd", "attityd"},
		{"attrapp", "attrapp"},
		{"attrapper", "attrapp"},
		{"au", "au"},
		{"auditorium", "auditorium"},
		{"audumbla", "audumbl"},
		{"augsburgiska", "augsburgisk"},
		{"augusti", "augusti"},
		{"augustikvällarna", "augustikväll"},
		{"auktiga", "aukt"},
		{"auktion", "auktion"},
		{"auktioner", "auktion"},
		{"auktoritet", "auktoritet"},
		{"aura", "aur"},
		{"auskultant", "auskultant"},
		{"australien", "australi"},
		{"australneger", "australneg"},
		{"automat", "autom"},
		{"automatiskt", "automatisk"},
		{"automobil", "automobil"},
		{"av", "av"},
		{"avancerat", "avancer"},
		{"avbedjan", "avbedjan"},
		{"avbida", "avbid"},
		{"avbild", "avbild"},
		{"avbildade", "avbild"},
		{"avblåsts", "avblåst"},
		{"avbrott", "avbrot"},
		{"avbrottet", "avbrottet"},
		{"avbruten", "avbrut"},
		{"avbrutit", "avbrutit"},
		{"avbrutna", "avbrutn"},
		{"avbryta", "avbryt"},
		{"avbrytande", "avbryt"},
		{"avbryter", "avbryt"},
		{"avbränt", "avbränt"},
		{"avbröt", "avbröt"},
		{"avbröts", "avbröt"},
		{"avböjde", "avböjd"},
		{"avdelat", "avdel"},
		{"avdelning", "avdelning"},
		{"avdelningen", "avdelning"},
		{"avdelningskontor", "avdelningskont"},
		{"avdomnad", "avdomn"},
		{"avdrag", "avdrag"},
		{"avdånad", "avdån"},
		{"ave", "ave"},
		{"avec", "avec"},
		{"aven", "aven"},
		{"avfallna", "avfalln"},
		{"avfladd", "avflad"},
		{"avflagade", "avflag"},
		{"avfärd", "avfärd"},
		{"avfärdad", "avfärd"},
		{"avfärden", "avfärd"},
		{"avge", "avg"},
		{"avgjord", "avgjord"},
		{"avgjort", "avgjort"},
		{"avgjorts", "avgjort"},
		{"avgjöras", "avgjör"},
		{"avglömda", "avglömd"},
		{"avgnagda", "avgnag"},
		{"avgrund", "avgrund"},
		{"avgrunden", "avgrund"},
		{"avgrunder", "avgrund"},
		{"avgrundsanden", "avgrunds"},
		{"avgrundsdjup", "avgrundsdjup"},
		{"avgudat", "avgud"},
		{"avgående", "avgåend"},
		{"avgått", "avgåt"},
		{"avgåvo", "avgåvo"},
		{"avgöra", "avgör"},
		{"avgörande", "avgör"},
		{"avhandling", "avhandling"},
		{"avhandlingen", "avhandling"},
		{"avhjälpt", "avhjälpt"},
		{"avhämta", "avhämt"},
		{"avhålla", "avhåll"},
		{"avhållen", "avhåll"},
		{"avhåller", "avhåll"},
		{"avhållsamhet", "avhållsam"},
		{"avhölja", "avhölj"},
		{"avhörde", "avhörd"},
		{"avhört", "avhört"},
		{"avig", "avig"},
		{"aviga", "avig"},
		{"avklädde", "avkläd"},
		{"avkomling", "avkomling"},
		{"avkunnad", "avkun"},
		{"avlade", "avl"},
		{"avlagda", "avlag"},
		{"avlande", "avl"},
		{"avlidna", "avlidn"},
		{"avlidne", "avlidn"},
		{"avlocka", "avlock"},
		{"avloppsrör", "avloppsrör"},
		{"avlupo", "avlupo"},
		{"avlägga", "avlägg"},
		{"avlägsen", "avlägs"},
		{"avlägset", "avlägset"},
		{"avlägsna", "avlägsn"},
		{"avlägsnade", "avlägsn"},
		{"avlägsnare", "avlägsn"},
		{"avlägsnaste", "avlägsn"},
		{"avlägsnat", "avlägsn"},
		{"avlånga", "avlång"},
		{"avlöpa", "avlöp"},
		{"avlöste", "avlöst"},
		{"avlövade", "avlöv"},
		{"avmagrat", "avmagr"},
		{"avmätt", "avmät"},
		{"avmätta", "avmät"},
		{"avpassad", "avpass"},
		{"avresa", "avres"},
		{"avresan", "avresan"},
		{"avrivning", "avrivning"},
		{"avrättsplatsen", "avrättsplats"},
		{"avsatsen", "avsats"},
		{"avsatt", "avsat"},
		{"avseende", "avseend"},
		{"avseenden", "avseend"},
		{"avsett", "avset"},
		{"avsides", "avsid"},
		{"avsigkomna", "avsigkomn"},
		{"avsikt", "avsik"},
		{"avsikten", "avsik"},
		{"avskaven", "avskav"},
		{"avsked", "avsked"},
		{"avskedet", "avskedet"},
		{"avskedsansökan", "avskedsansökan"},
		{"avskedsblick", "avskedsblick"},
		{"avskedsmåltiden", "avskedsmåltid"},
		{"avskild", "avskild"},
		{"avskilda", "avskild"},
		{"avskildhet", "avskild"},
		{"avskrift", "avskrift"},
		{"avskrädeshögen", "avskrädeshög"},
		{"avskum", "avskum"},
		{"avsky", "avsky"},
		{"avskydd", "avskyd"},
		{"avskydda", "avskyd"},
		{"avskydde", "avskyd"},
		{"avskyr", "avskyr"},
		{"avskytt", "avskyt"},
		{"avskyvärda", "avskyvärd"},
		{"avskyvärde", "avskyvärd"},
		{"avskyvärt", "avskyvärt"},
		{"avslag", "avslag"},
		{"avsluta", "avslut"},
		{"avslutade", "avslut"},
		{"avslutades", "avslut"},
		{"avslutat", "avslut"},
		{"avslutning", "avslutning"},
		{"avslöja", "avslöj"},
		{"avslöjade", "avslöj"},
		{"avslöjat", "avslöj"},
		{"avslöt", "avslöt"},
		{"avslöts", "avslöt"},
		{"avsmak", "avsmak"},
		{"avstack", "avstack"},
		{"avstanna", "avstan"},
		{"avstickare", "avstick"},
		{"avstigna", "avstign"},
		{"avstod", "avstod"},
		{"avstubbade", "avstubb"},
		{"avstädades", "avstäd"},
		{"avstå", "avstå"},
		{"avstånd", "avstånd"},
		{"avståndet", "avståndet"},
		{"avstår", "avstår"},
		{"avsvalnat", "avsvaln"},
		{"avsvor", "avsv"},
		{"avsättningen", "avsättning"},
		{"avsöndrat", "avsöndr"},
		{"avtaga", "avtag"},
		{"avtal", "avtal"},
		{"avtala", "avtal"},
		{"avtalade", "avtal"},
		{"avtalat", "avtal"},
		{"avtog", "avtog"},
		{"avtogo", "avtogo"},
		{"avtryck", "avtryck"},
		{"avund", "avund"},
		{"avundade", "avund"},
		{"avundades", "avund"},
		{"avundas", "avund"},
		{"avundats", "avundat"},
		{"avunden", "avund"},
		{"avundens", "avund"},
		{"avunds", "avund"},
		{"avundsjuk", "avundsjuk"},
		{"avundsjuka", "avundsjuk"},
		{"avundsjukan", "avundsjukan"},
		{"avundsjukt", "avundsjuk"},
		{"avundsvärd", "avundsvärd"},
		{"avundsvärda", "avundsvärd"},
		{"avvakta", "avvak"},
		{"avvaktade", "avvak"},
		{"avvaktan", "avvaktan"},
		{"avvaktande", "avvak"},
		{"avverkade", "avverk"},
		{"avvikelse", "avvik"},
		{"avvikelsen", "avvik"},
		{"avvisad", "avvis"},
		{"avvisande", "avvis"},
		{"avväg", "avväg"},
		{"avvägd", "avväg"},
		{"avvägt", "avväg"},
		{"avvärja", "avvärj"},
		{"avvärjande", "avvärj"},
		{"avvärjde", "avvärjd"},
		{"axel", "axel"},
		{"axelbred", "axelbred"},
		{"axeln", "axeln"},
		{"axelryckning", "axelryckning"},
		{"axelryckningen", "axelryckning"},
		{"axens", "axen"},
		{"axlar", "axl"},
		{"axlarna", "axl"},
		{"axlarne", "axl"},
		{"azltså", "azltså"},
		{"azur", "azur"},
		{"azurblått", "azurblåt"},
		{"b", "b"},
		{"ba", "ba"},
		{"babels", "babel"},
		{"babelstorn", "babelstorn"},
		{"babordslanternan", "babordslanternan"},
		{"babordsrelingen", "babordsreling"},
		{"babyloniska", "babylonisk"},
		{"baciller", "bacill"},
		{"bacillerna", "bacill"},
		{"bacillskräck", "bacillskräck"},
		{"backar", "back"},
		{"backe", "back"},
		{"backen", "back"},
		{"backor", "back"},
		{"bad", "bad"},
		{"bada", "bad"},
		{"badade", "bad"},
		{"badades", "bad"},
		{"badat", "bad"},
		{"badc", "badc"},
		{"badden", "badd"},
		{"baddräkt", "baddräk"},
		{"bade", "bad"},
		{"baden", "bad"},
		{"badet", "badet"},
		{"badhuset", "badhuset"},
		{"badkuren", "badkur"},
		{"badning", "badning"},
		{"badrum", "badrum"},
		{"badsejour", "badsejour"},
		{"badsejouren", "badsejour"},
		{"badstranden", "badstr"},
		{"badstuga", "badstug"},
		{"badstugan", "badstugan"},
		{"badstuns", "badstun"},
		{"badstället", "badstället"},
		{"bagare", "bag"},
		{"bagaren", "bag"},
		{"bagarn", "bagarn"},
		{"bagarns", "bagarn"},
		{"bagatell", "bagatell"},
		{"bagateller", "bagatell"},
		{"bagerierna", "bageri"},
		{"bagge", "bagg"},
		{"bagges", "bagg"},
		{"baglig", "bag"},
		{"bah", "bah"},
		{"bahytthattar", "bahytthat"},
		{"bak", "bak"},
		{"baka", "bak"},
		{"bakat", "bak"},
		{"bakbenen", "bakben"},
		{"bakelsehungriga", "bakelsehungr"},
		{"bakelser", "bak"},
		{"baken", "bak"},
		{"bakfoten", "bakfot"},
		{"bakgata", "bakgat"},
		{"bakgrunden", "bakgrund"},
		{"bakhuvud", "bakhuvud"},
		{"bakhåll", "bakhåll"},
		{"bakifrån", "bakifrån"},
		{"baklänges", "bakläng"},
		{"bakom", "bakom"},
		{"bakport", "bakport"},
		{"bakringarna", "bakring"},
		{"baksida", "baksid"},
		{"baktanke", "baktank"},
		{"bakverk", "bakverk"},
		{"bakvändt", "bakvänd"},
		{"bakåt", "bakåt"},
		{"bal", "bal"},
		{"balansera", "balanser"},
		{"balanserade", "balanser"},
		{"balanserande", "balanser"},
		{"baler", "bal"},
		{"balett", "balet"},
		{"balja", "balj"},
		{"baljorna", "balj"},
		{"balkong", "balkong"},
		{"balladen", "ballad"},
		{"balsam", "balsam"},
		{"balsamin", "balsamin"},
		{"balsaminen", "balsamin"},
		{"balsaminer", "balsamin"},
		{"balsaminerna", "balsamin"},
		{"balsaminernas", "balsamin"},
		{"balsampoppeln", "balsampoppeln"},
		{"balsäsong", "balsäsong"},
		{"bamablomstrande", "bamablomstr"},
		{"ban", "ban"},
		{"bana", "ban"},
		{"banade", "ban"},
		{"banala", "banal"},
		{"banan", "banan"},
		{"banar", "ban"},
		{"band", "band"},
		{"bandet", "bandet"},
		{"bandhundens", "bandhund"},
		{"bandrullar", "bandrull"},
		{"bane", "ban"},
		{"baner", "ban"},
		{"bank", "bank"},
		{"bankar", "bank"},
		{"bankdirektören", "bankdirektör"},
		{"banko", "banko"},
		{"bann", "bann"},
		{"banna", "bann"},
		{"bannande", "bann"},
		{"bannor", "bann"},
		{"bans", "ban"},
		{"bar", "bar"},
		{"bara", "bar"},
		{"barbari", "barbari"},
		{"barett", "baret"},
		{"barfota", "barfot"},
		{"barhuvad", "barhuv"},
		{"bari", "bari"},
		{"bark", "bark"},
		{"barkbat", "barkb"},
		{"barm", "barm"},
		{"barmar", "barm"},
		{"barmen", "barm"},
		{"barmhertig", "barmhert"},
		{"barmhertighet", "barmhert"},
		{"barmhärtiga", "barmhärt"},
		{"barmhärtige", "barmhärt"},
		{"barmhärtiges", "barmhärt"},
		{"barmhärtighet", "barmhärt"},
		{"barmhärtigheten", "barmhärt"},
		{"barmhärtighetsdoktorerna", "barmhärtighetsdoktor"},
		{"barmhärtighetsgärningar", "barmhärtighetsgärning"},
		{"barmhärtighetsverk", "barmhärtighetsverk"},
		{"barmhärtigt", "barmhärt"},
		{"barmmorskan", "barmmorskan"},
		{"barn", "barn"},
		{"barnaföderska", "barnafödersk"},
		{"barnansikte", "barnansik"},
		{"barnasinnet", "barnasinnet"},
		{"barnavård", "barnavård"},
		{"barnavårdsnämnden", "barnavårdsnämnd"},
		{"barnbarn", "barnbarn"},
		{"barnbarnen", "barnbarn"},
		{"barnbördshus", "barnbördshus"},
		{"barnbördshuset", "barnbördshuset"},
		{"barndom", "barndom"},
		{"barndomen", "barndom"},
		{"barndomens", "barndom"},
		{"barndoms", "barndom"},
		{"barndomsminnen", "barndomsmin"},
		{"barndomsstad", "barndomsst"},
		{"barndomsår", "barndomsår"},
		{"barndop", "barndop"},
		{"barnen", "barn"},
		{"barnens", "barn"},
		{"barnet", "barnet"},
		{"barnets", "barnet"},
		{"barneu", "barneu"},
		{"barnflicka", "barnflick"},
		{"barnhemmet", "barnhemmet"},
		{"barnhuset", "barnhuset"},
		{"barnjungfru", "barnjungfru"},
		{"barnjungfruns", "barnjungfrun"},
		{"barnkammare", "barnkamm"},
		{"barnkammaren", "barnkamm"},
		{"barnkammarens", "barnkamm"},
		{"barnkära", "barnkär"},
		{"barnlös", "barnlös"},
		{"barnlöst", "barnlös"},
		{"barnmorska", "barnmorsk"},
		{"barnmorskan", "barnmorskan"},
		{"barnmorskans", "barnmorskan"},
		{"barnmorskor", "barnmorsk"},
		{"barnpensionat", "barnpension"},
		{"barnröst", "barnröst"},
		{"barns", "barn"},
		{"barnsbörd", "barnsbörd"},
		{"barnskaran", "barnskaran"},
		{"barnslig", "barns"},
		{"barnsliga", "barns"},
		{"barnsligc", "barnsligc"},
		{"barnslighet", "barns"},
		{"barnsligheten", "barns"},
		{"barnsligheter", "barns"},
		{"barnsligt", "barns"},
		{"barnsnöd", "barnsnöd"},
		{"barnsäng", "barnsäng"},
		{"barnsängar", "barnsäng"},
		{"barnsängskvinnas", "barnsängskvin"},
		{"barnsängskvinnorna", "barnsängskvin"},
		{"barnungar", "barnung"},
		{"barnungarne", "barnung"},
		{"barnungars", "barnungar"},
		{"barnunge", "barnung"},
		{"baron", "baron"},
		{"baronen", "baron"},
		{"baronens", "baron"},
		{"baroner", "baron"},
		{"barr", "barr"},
		{"barren", "barr"},
		{"barriären", "barriär"},
		{"barrskog", "barrskog"},
		{"bars", "bar"},
		{"barsk", "barsk"},
		{"barska", "barsk"},
		{"barske", "barsk"},
		{"barskt", "barsk"},
		{"bart", "bart"},
		{"basar", "bas"},
		{"baserad", "baser"},
		{"basilisken", "basilisk"},
		{"bastanta", "bastant"},
		{"bastigt", "bast"},
		{"bastu", "bastu"},
		{"bastun", "bastun"},
		{"basun", "basun"},
		{"batalj", "batalj"},
		{"batar", "bat"},
		{"batarml", "batarml"},
		{"batist", "batist"},
		{"battre", "battr"},
		{"battys", "batty"},
		{"baudelaire", "baudelair"},
		{"bb", "bb"},
		{"bcgrepp", "bcgrepp"},
		{"bcrg", "bcrg"},
		{"bctt", "bctt"},
		{"bcvekande", "bcvek"},
		{"be", "be"},
		{"beandran", "beandran"},
		{"bearbetades", "bearbet"},
		{"bearbetning", "bearbetning"},
		{"bearbetningen", "bearbetning"},
		{"bearn", "bearn"},
		{"beau", "beau"},
		{"beaune", "beaun"},
		{"bebag", "bebag"},
		{"bebandling", "bebandling"},
		{"bebekommer", "bebekomm"},
		{"beblandelse", "bebland"},
		{"beblomstra", "beblomstr"},
		{"bebodd", "bebod"},
		{"beboddes", "bebod"},
		{"bebos", "bebo"},
		{"bebott", "bebot"},
		{"bebyggare", "bebygg"},
		{"bebåda", "bebåd"},
		{"bebådat", "bebåd"},
		{"beckiga", "beck"},
		{"bed", "bed"},
		{"bedagad", "bedag"},
		{"bedarrat", "bedarr"},
		{"beder", "bed"},
		{"bedit", "bedit"},
		{"bedja", "bedj"},
		{"bedjande", "bedj"},
		{"bedjen", "bedj"},
		{"bedoma", "bedom"},
		{"bedraga", "bedrag"},
		{"bedragare", "bedrag"},
		{"bedragen", "bedrag"},
		{"bedrager", "bedrag"},
		{"bedragit", "bedragit"},
		{"bedragna", "bedragn"},
		{"bedragne", "bedragn"},
		{"bedriva", "bedriv"},
		{"bedrives", "bedriv"},
		{"bedrog", "bedrog"},
		{"bedroge", "bedrog"},
		{"bedrogo", "bedrogo"},
		{"bedrovligt", "bedrov"},
		{"bedrägeri", "bedrägeri"},
		{"bedrägliga", "bedräg"},
		{"bedröfliga", "bedröf"},
		{"bedröfva", "bedröfv"},
		{"bedröfvad", "bedröfv"},
		{"bedröfvade", "bedröfv"},
		{"bedröfvat", "bedröfv"},
		{"bedröfvelse", "bedröfv"},
		{"bedröfvelsen", "bedröfv"},
		{"bedröfvelsens", "bedröfv"},
		{"bedrövad", "bedröv"},
		{"bedrövade", "bedröv"},
		{"bedrövas", "bedröv"},
		{"bedrövelsen", "bedröv"},
		{"bedrövliga", "bedröv"},
		{"bedrövligt", "bedröv"},
		{"bedt", "bedt"},
		{"bedyra", "bedyr"},
		{"bedyrade", "bedyr"},
		{"bedyrar", "bedyr"},
		{"bedyrat", "bedyr"},
		{"bedårade", "bedår"},
		{"bedöma", "bedöm"},
		{"bedömande", "bedöm"},
		{"bedömer", "bedöm"},
		{"bedömt", "bedömt"},
		{"bedövad", "bedöv"},
		{"bedövas", "bedöv"},
		{"bedövningens", "bedövning"},
		{"befalde", "befald"},
		{"befaldes", "befald"},
		{"befalla", "befall"},
		{"befallande", "befall"},
		{"befalld", "befalld"},
		{"befallde", "befalld"},
		{"befaller", "befall"},
		{"befalles", "befall"},
		{"befallning", "befallning"},
		{"befallningar", "befallning"},
		{"befallningen", "befallning"},
		{"befallningsmannen", "befallningsman"},
		{"befallningsmannens", "befallningsman"},
		{"befann", "befan"},
		{"befanns", "befan"},
		{"befans", "befan"},
		{"befara", "befar"},
		{"befarade", "befar"},
		{"befarm", "befarm"},
		{"befatta", "befat"},
		{"befattar", "befat"},
		{"befattning", "befattning"},
		{"befattningar", "befattning"},
		{"befattningen", "befattning"},
		{"befinna", "befin"},
		{"befinner", "befin"},
		{"befinnes", "befin"},
		{"befolkade", "befolk"},
		{"befolkas", "befolk"},
		{"befolkning", "befolkning"},
		{"befolkningen", "befolkning"},
		{"befordran", "befordran"},
		{"befordrat", "befordr"},
		{"befordringar", "befordring"},
		{"befria", "befri"},
		{"befriad", "befri"},
		{"befriade", "befri"},
		{"befriaren", "befri"},
		{"befriat", "befri"},
		{"befrielse", "befri"},
		{"befrielsen", "befri"},
		{"befruktade", "befruk"},
		{"befruktades", "befruk"},
		{"befryndad", "befrynd"},
		{"befrämja", "befrämj"},
		{"befrämjas", "befrämj"},
		{"befunnit", "befunnit"},
		{"befunno", "befunno"},
		{"befälet", "befälet"},
		{"befängd", "befäng"},
		{"befängda", "befäng"},
		{"befängt", "befäng"},
		{"befästa", "befäst"},
		{"begaf", "begaf"},
		{"begagna", "begagn"},
		{"begagnad", "begagn"},
		{"begagnade", "begagn"},
		{"begagnades", "begagn"},
		{"begagnar", "begagn"},
		{"begagnas", "begagn"},
		{"begagnat", "begagn"},
		{"begagnats", "begagnat"},
		{"begart", "begart"},
		{"begav", "begav"},
		{"begavad", "begav"},
		{"bege", "beg"},
		{"begge", "begg"},
		{"begges", "begg"},
		{"begick", "begick"},
		{"begifva", "begifv"},
		{"begifvenhet", "begifven"},
		{"begingo", "begingo"},
		{"begiva", "begiv"},
		{"begrafva", "begrafv"},
		{"begrafvet", "begrafvet"},
		{"begrav", "begrav"},
		{"begrava", "begrav"},
		{"begravas", "begrav"},
		{"begravda", "begravd"},
		{"begraven", "begrav"},
		{"begraver", "begrav"},
		{"begravet", "begravet"},
		{"begravit", "begravit"},
		{"begravna", "begravn"},
		{"begravning", "begravning"},
		{"begravningar", "begravning"},
		{"begravningen", "begravning"},
		{"begravningsbyrå", "begravningsbyrå"},
		{"begravningskaffe", "begravningskaff"},
		{"begrep", "begrep"},
		{"begrepp", "begrepp"},
		{"begreppen", "begrepp"},
		{"begreppet", "begreppet"},
		{"begreppsförvirring", "begreppsförvirring"},
		{"begripa", "begrip"},
		{"begripas", "begrip"},
		{"begripe", "begrip"},
		{"begriper", "begrip"},
		{"begripet", "begripet"},
		{"begripit", "begripit"},
		{"begripliga", "begrip"},
		{"begripligt", "begrip"},
		{"begrov", "begrov"},
		{"begrovs", "begrov"},
		{"begrunda", "begrund"},
		{"begrundade", "begrund"},
		{"begrundande", "begrund"},
		{"begrundanden", "begrund"},
		{"begrundat", "begrund"},
		{"begränsa", "begräns"},
		{"begråta", "begråt"},
		{"begråtit", "begråtit"},
		{"begynna", "begyn"},
		{"begynnande", "begyn"},
		{"begynnelsen", "begynn"},
		{"begynns", "begyn"},
		{"begynt", "begynt"},
		{"begynte", "begynt"},
		{"begär", "begär"},
		{"begära", "begär"},
		{"begäran", "begäran"},
		{"begärda", "begärd"},
		{"begärde", "begärd"},
		{"begärelse", "begär"},
		{"begären", "begär"},
		{"begäret", "begäret"},
		{"begärets", "begäret"},
		{"begärlighet", "begär"},
		{"begärligt", "begär"},
		{"begärt", "begärt"},
		{"begå", "begå"},
		{"begåfvad", "begåfv"},
		{"begånget", "begånget"},
		{"begångna", "begångn"},
		{"begår", "begår"},
		{"begås", "begås"},
		{"begått", "begåt"},
		{"begåvad", "begåv"},
		{"begåvade", "begåv"},
		{"begåvning", "begåvning"},
		{"begåvo", "begåvo"},
		{"behag", "behag"},
		{"behaga", "behag"},
		{"behagade", "behag"},
		{"behagar", "behag"},
		{"behagas", "behag"},
		{"behagat", "behag"},
		{"behaget", "behaget"},
		{"behagfull", "behagfull"},
		{"behaglig", "behag"},
		{"behagliga", "behag"},
		{"behagligare", "behag"},
		{"behagligast", "behag"},
		{"behagligaste", "behag"},
		{"behagligt", "behag"},
		{"behagsjuk", "behagsjuk"},
		{"behagsjuka", "behagsjuk"},
		{"behagsjukan", "behagsjukan"},
		{"behagsjukans", "behagsjukan"},
		{"behagsjukas", "behagsjuk"},
		{"behandla", "behandl"},
		{"behandlades", "behandl"},
		{"behandlas", "behandl"},
		{"behandlat", "behandl"},
		{"behandling", "behandling"},
		{"behandlingen", "behandling"},
		{"beherska", "behersk"},
		{"beherskades", "behersk"},
		{"beherskning", "beherskning"},
		{"behjelplig", "behjelp"},
		{"behjertat", "behjert"},
		{"behof", "behof"},
		{"behofvet", "behofvet"},
		{"behov", "behov"},
		{"behova", "behov"},
		{"behovde", "behovd"},
		{"behoven", "behov"},
		{"behovet", "behovet"},
		{"behovets", "behovet"},
		{"behäftad", "behäft"},
		{"behäftade", "behäft"},
		{"behäftadt", "behäftad"},
		{"behändig", "behänd"},
		{"behändiga", "behänd"},
		{"behändigt", "behänd"},
		{"behärska", "behärsk"},
		{"behärskad", "behärsk"},
		{"behärskade", "behärsk"},
		{"behärskat", "behärsk"},
		{"behärskats", "behärskat"},
		{"behärskning", "behärskning"},
		{"behåll", "behåll"},
		{"behålla", "behåll"},
		{"behåller", "behåll"},
		{"behöfde", "behöfd"},
		{"behöfdes", "behöfd"},
		{"behöfligt", "behöf"},
		{"behöfs", "behöf"},
		{"behöft", "behöft"},
		{"behöfva", "behöfv"},
		{"behöfvas", "behöfv"},
		{"behöfver", "behöfv"},
		{"behöll", "behöll"},
		{"behölle", "behöll"},
		{"behöllo", "behöllo"},
		{"behörig", "behör"},
		{"behörigen", "behör"},
		{"behöva", "behöv"},
		{"behövas", "behöv"},
		{"behövdc", "behövdc"},
		{"behövde", "behövd"},
		{"behövdes", "behövd"},
		{"behöver", "behöv"},
		{"behövs", "behöv"},
		{"behövt", "behövt"},
		{"bekant", "bekant"},
		{"bekanta", "bekant"},
		{"bekantas", "bekant"},
		{"bekante", "bekant"},
		{"bekants", "bekant"},
		{"bekantskap", "bekantskap"},
		{"bekantskapen", "bekantskap"},
		{"bekantskaper", "bekantskap"},
		{"bekantskaperna", "bekantskap"},
		{"bekantskapers", "bekantskaper"},
		{"bekantsskap", "bekantsskap"},
		{"beklaga", "beklag"},
		{"beklagade", "beklag"},
		{"beklagande", "beklag"},
		{"beklagansvärda", "beklagansvärd"},
		{"beklagansvärde", "beklagansvärd"},
		{"beklagansvärt", "beklagansvärt"},
		{"beklagar", "beklag"},
		{"beklagarlsvärd", "beklagarlsvärd"},
		{"beklagat", "beklag"},
		{"beklädd", "bekläd"},
		{"beklämd", "beklämd"},
		{"beklämdhet", "beklämd"},
		{"beklämmande", "beklämm"},
		{"beklämning", "beklämning"},
		{"bekom", "bekom"},
		{"bekomma", "bekomm"},
		{"bekommer", "bekomm"},
		{"bekommit", "bekommit"},
		{"bekostnad", "bekostn"},
		{"bekräfta", "bekräft"},
		{"bekräftar", "bekräft"},
		{"bekräftas", "bekräft"},
		{"bekräftat", "bekräft"},
		{"bekräftelse", "bekräft"},
		{"bekröner", "bekrön"},
		{"bekväm", "bekväm"},
		{"bekväma", "bekväm"},
		{"bekvämaste", "bekväm"},
		{"bekvämde", "bekvämd"},
		{"bekvämlighet", "bekväm"},
		{"bekvämlighetsinrättningarnas", "bekvämlighetsinrättning"},
		{"bekvämt", "bekvämt"},
		{"bekvänlligheter", "bekvänl"},
		{"bekymmer", "bekymm"},
		{"bekymmersam", "bekymmersam"},
		{"bekymmersamma", "bekymmersamm"},
		{"bekymmerslösa", "bekymmerslös"},
		{"bekymmerslösheten", "bekymmerslös"},
		{"bekymra", "bekymr"},
		{"bekymrad", "bekymr"},
		{"bekymrade", "bekymr"},
		{"bekymrar", "bekymr"},
		{"bekymrat", "bekymr"},
		{"bekymren", "bekymr"},
		{"bekymret", "bekymret"},
		{"bekämpa", "bekämp"},
		{"bekämpande", "bekämp"},
		{"bekände", "bekänd"},
		{"bekänn", "bekän"},
		{"bekänna", "bekän"},
		{"bekännare", "bekän"},
		{"bekännelse", "bekänn"},
		{"bekännelsen", "bekänn"},
		{"bekänner", "bekän"},
		{"belagd", "belag"},
		{"belagda", "belag"},
		{"beledsagade", "beledsag"},
		{"belefvad", "belefv"},
		{"beler", "bel"},
		{"bell", "bell"},
		{"bellmans", "bellman"},
		{"bellona", "bellon"},
		{"bells", "bell"},
		{"belopp", "belopp"},
		{"beloppet", "beloppet"},
		{"belsasars", "belsasar"},
		{"belt", "belt"},
		{"belysa", "belys"},
		{"belysning", "belysning"},
		{"belysningen", "belysning"},
		{"belyst", "belyst"},
		{"belysta", "belyst"},
		{"belystes", "belyst"},
		{"belägen", "beläg"},
		{"belägenhet", "belägen"},
		{"belägg", "belägg"},
		{"belägna", "belägn"},
		{"belägrades", "belägr"},
		{"belägrat", "belägr"},
		{"belåten", "belåt"},
		{"belåtenhet", "belåten"},
		{"belåtet", "belåtet"},
		{"belåtna", "belåtn"},
		{"belåtnare", "belåtn"},
		{"belåtnaste", "belåtn"},
		{"belöna", "belön"},
		{"belönade", "belön"},
		{"belönades", "belön"},
		{"belöning", "belöning"},
		{"belöningen", "belöning"},
		{"bem", "bem"},
		{"bemantla", "bemantl"},
		{"bemedlade", "bemedl"},
		{"bemma", "bemm"},
		{"bemägtigade", "bemägt"},
		{"bemägtigat", "bemägt"},
		{"bemäktiga", "bemäkt"},
		{"bemälte", "bemält"},
		{"bemärka", "bemärk"},
		{"bemärkelse", "bemärk"},
		{"bemärkelsedagar", "bemärkelsedag"},
		{"bemärkt", "bemärk"},
		{"bemärkte", "bemärk"},
		{"bemärktes", "bemärk"},
		{"bemöda", "bemöd"},
		{"bemödade", "bemöd"},
		{"bemödande", "bemöd"},
		{"bemödanden", "bemöd"},
		{"bemödandet", "bemöd"},
		{"bemödat", "bemöd"},
		{"bemöta", "bemöt"},
		{"bemötande", "bemöt"},
		{"bemötas", "bemöt"},
		{"bemöter", "bemöt"},
		{"bemött", "bemöt"},
		{"bemötte", "bemöt"},
		{"bemöttes", "bemöt"},
		{"ben", "ben"},
		{"bena", "ben"},
		{"benade", "ben"},
		{"benat", "ben"},
		{"bene", "ben"},
		{"benedia", "benedi"},
		{"benen", "ben"},
		{"benet", "benet"},
		{"benkläder", "benkläd"},
		{"benne", "benn"},
		{"bennes", "benn"},
		{"benno", "benno"},
		{"benägen", "benäg"},
		{"benäget", "benäget"},
		{"benämna", "benämn"},
		{"benämnas", "benämn"},
		{"benämnde", "benämnd"},
		{"benämndes", "benämnd"},
		{"benämner", "benämn"},
		{"benämnes", "benämn"},
		{"benämning", "benämning"},
		{"benämningen", "benämning"},
		{"benådad", "benåd"},
		{"benådade", "benåd"},
		{"benådande", "benåd"},
		{"beprisade", "bepris"},
		{"bepröfvade", "bepröfv"},
		{"bepröfvelser", "bepröfv"},
		{"beprövad", "bepröv"},
		{"beqvämare", "beqväm"},
		{"beqvämlighet", "beqväm"},
		{"beqvämligheter", "beqväm"},
		{"beqvämt", "beqvämt"},
		{"ber", "ber"},
		{"bereda", "bered"},
		{"beredd", "bered"},
		{"beredda", "bered"},
		{"beredde", "bered"},
		{"bereddes", "bered"},
		{"beredskap", "beredskap"},
		{"beredt", "bered"},
		{"beredvillighet", "beredvil"},
		{"beredvilligt", "beredvil"},
		{"berest", "berest"},
		{"berett", "beret"},
		{"berg", "berg"},
		{"berga", "berg"},
		{"bergad", "berg"},
		{"bergar", "berg"},
		{"bergen", "berg"},
		{"bergena", "bergen"},
		{"bergens", "berg"},
		{"berget", "berget"},
		{"bergets", "berget"},
		{"berghäll", "berghäll"},
		{"berghällen", "berghäll"},
		{"bergknallar", "bergknall"},
		{"bergman", "bergman"},
		{"bergning", "bergning"},
		{"bergshäll", "bergshäll"},
		{"bergshällen", "bergshäll"},
		{"bergsmanstapet", "bergsmanstapet"},
		{"bergsprängningen", "bergsprängning"},
		{"bergsspetsen", "bergsspets"},
		{"bergtroll", "bergtroll"},
		{"bergväggen", "bergvägg"},
		{"bernard", "bernard"},
		{"bernards", "bernard"},
		{"berns", "bern"},
		{"bero", "bero"},
		{"berodde", "berod"},
		{"beroende", "beroend"},
		{"beror", "ber"},
		{"bert", "bert"},
		{"berusande", "berus"},
		{"berusat", "berus"},
		{"berusning", "berusning"},
		{"beryktade", "beryk"},
		{"beryktat", "beryk"},
		{"beräkna", "beräkn"},
		{"beräknad", "beräkn"},
		{"beräknade", "beräkn"},
		{"beräknat", "beräkn"},
		{"beräkning", "beräkning"},
		{"beräkningar", "beräkning"},
		{"beräkningarnes", "beräkningarn"},
		{"berätta", "berät"},
		{"berättade", "berät"},
		{"berättades", "berät"},
		{"berättandes", "berät"},
		{"berättar", "berät"},
		{"berättas", "berät"},
		{"berättat", "berät"},
		{"berättats", "berättat"},
		{"berättelse", "berätt"},
		{"berättelsen", "berätt"},
		{"berättelser", "berätt"},
		{"berättigad", "berätt"},
		{"berättigat", "berätt"},
		{"beröfva", "beröfv"},
		{"beröfvade", "beröfv"},
		{"beröm", "beröm"},
		{"berömd", "berömd"},
		{"berömda", "berömd"},
		{"berömde", "berömd"},
		{"berömdes", "berömd"},
		{"berömdheterna", "berömd"},
		{"berömlig", "beröm"},
		{"berömma", "berömm"},
		{"berömmande", "berömm"},
		{"berömmas", "berömm"},
		{"berömmer", "berömm"},
		{"berömvärd", "berömvärd"},
		{"berömvärt", "berömvärt"},
		{"beröra", "berör"},
		{"berörd", "berörd"},
		{"berörda", "berörd"},
		{"berörde", "berörd"},
		{"berördes", "berörd"},
		{"beröring", "beröring"},
		{"beröringen", "beröring"},
		{"beröringspunkt", "beröringspunk"},
		{"berört", "berört"},
		{"berövad", "beröv"},
		{"berövade", "beröv"},
		{"besagde", "besag"},
		{"besannade", "besan"},
		{"besatt", "besat"},
		{"besatta", "besat"},
		{"bese", "bes"},
		{"besegra", "besegr"},
		{"besegrade", "besegr"},
		{"besegras", "besegr"},
		{"besiktigande", "besikt"},
		{"besinming", "besinming"},
		{"besinna", "besin"},
		{"besinnade", "besin"},
		{"besinnar", "besin"},
		{"besinnat", "besin"},
		{"besinning", "besinning"},
		{"besinningstid", "besinningstid"},
		{"besitta", "besit"},
		{"besitter", "besit"},
		{"besittning", "besittning"},
		{"besittnutg", "besittnutg"},
		{"besjungen", "besjung"},
		{"beska", "besk"},
		{"beskaffad", "beskaff"},
		{"beskaffenhet", "beskaffen"},
		{"beskaffenheten", "beskaffen"},
		{"besked", "besked"},
		{"beskedet", "beskedet"},
		{"beskedlig", "besked"},
		{"beskedliga", "besked"},
		{"beskedlige", "besked"},
		{"beskedlighet", "besked"},
		{"beskedligt", "besked"},
		{"beskickning", "beskickning"},
		{"beskickningen", "beskickning"},
		{"beskref", "beskref"},
		{"beskrev", "beskrev"},
		{"beskrevo", "beskrevo"},
		{"beskrifning", "beskrifning"},
		{"beskrifningen", "beskrifning"},
		{"beskrifva", "beskrifv"},
		{"beskrifver", "beskrifv"},
		{"beskrifvit", "beskrifvit"},
		{"beskriva", "beskriv"},
		{"beskrivit", "beskrivit"},
		{"beskrivna", "beskrivn"},
		{"beskrivning", "beskrivning"},
		{"beskrivningar", "beskrivning"},
		{"beskt", "besk"},
		{"beskuggades", "beskugg"},
		{"beskydd", "beskyd"},
		{"beskyddande", "beskyd"},
		{"beskyddare", "beskyd"},
		{"beskyddares", "beskyddar"},
		{"beskyddarinna", "beskyddarin"},
		{"beskyllning", "beskyllning"},
		{"beskyllningar", "beskyllning"},
		{"beskyllningen", "beskyllning"},
		{"beskäftig", "beskäft"},
		{"beskäftigt", "beskäft"},
		{"beskärd", "beskärd"},
		{"beskåda", "beskåd"},
		{"beslag", "beslag"},
		{"beslaget", "beslaget"},
		{"beslut", "beslut"},
		{"besluta", "beslut"},
		{"beslutar", "beslut"},
		{"beslutas", "beslut"},
		{"beslutat", "beslut"},
		{"besluten", "beslut"},
		{"beslutet", "beslutet"},
		{"beslutit", "beslutit"},
		{"beslutsam", "beslutsam"},
		{"beslutsamhet", "beslutsam"},
		{"beslutsamma", "beslutsamm"},
		{"besläktade", "besläk"},
		{"beslöjad", "beslöj"},
		{"beslöjade", "beslöj"},
		{"beslöt", "beslöt"},
		{"beslöto", "beslöto"},
		{"bespara", "bespar"},
		{"besparades", "bespar"},
		{"besparar", "bespar"},
		{"bess", "bess"},
		{"best", "best"},
		{"besten", "best"},
		{"bestjäla", "bestjäl"},
		{"bestod", "bestod"},
		{"bestodo", "bestodo"},
		{"bestraffa", "bestraff"},
		{"bestrida", "bestrid"},
		{"bestridande", "bestrid"},
		{"beströ", "beströ"},
		{"bestyr", "bestyr"},
		{"bestyra", "bestyr"},
		{"bestyret", "bestyret"},
		{"bestyrkt", "bestyrk"},
		{"beställa", "beställ"},
		{"beställd", "beställd"},
		{"beställde", "beställd"},
		{"beställning", "beställning"},
		{"beställsam", "beställsam"},
		{"beställsamt", "beställsamt"},
		{"beställt", "beställt"},
		{"bestämd", "bestämd"},
		{"bestämda", "bestämd"},
		{"bestämdare", "bestämd"},
		{"bestämde", "bestämd"},
		{"bestämdhet", "bestämd"},
		{"bestämdt", "bestämd"},
		{"bestämma", "bestämm"},
		{"bestämmas", "bestämm"},
		{"bestämmelse", "bestämm"},
		{"bestämmelseort", "bestämmelseort"},
		{"bestämt", "bestämt"},
		{"beständig", "beständ"},
		{"beständiga", "beständ"},
		{"beständigt", "beständ"},
		{"bestänkta", "bestänk"},
		{"bestänkte", "bestänk"},
		{"bestärnd", "bestärnd"},
		{"bestå", "bestå"},
		{"bestående", "beståend"},
		{"beståndande", "bestånd"},
		{"består", "består"},
		{"bestört", "bestört"},
		{"bestörtning", "bestörtning"},
		{"besvara", "besvar"},
		{"besvarade", "besvar"},
		{"besvarades", "besvar"},
		{"besvarande", "besvar"},
		{"besvaras", "besvar"},
		{"besvek", "besvek"},
		{"besvikelse", "besvik"},
		{"besviken", "besvik"},
		{"besvor", "besv"},
		{"besvurit", "besvurit"},
		{"besvär", "besvär"},
		{"besvära", "besvär"},
		{"besvärad", "besvär"},
		{"besvärade", "besvär"},
		{"besvärades", "besvär"},
		{"besvärande", "besvär"},
		{"besvärar", "besvär"},
		{"besväras", "besvär"},
		{"besvärat", "besvär"},
		{"besväret", "besväret"},
		{"besvärjande", "besvärj"},
		{"besvärlig", "besvär"},
		{"besvärliga", "besvär"},
		{"besvärligheter", "besvär"},
		{"besvärligt", "besvär"},
		{"besydnerligt", "besydner"},
		{"besyn", "besyn"},
		{"besynnerlig", "besynner"},
		{"besynnerliga", "besynner"},
		{"besynnerligare", "besynner"},
		{"besynnerligaste", "besynner"},
		{"besynnerligen", "besynner"},
		{"besynnerlighet", "besynner"},
		{"besynnerligt", "besynner"},
		{"besättning", "besättning"},
		{"besättningen", "besättning"},
		{"besåg", "besåg"},
		{"besök", "besök"},
		{"besöka", "besök"},
		{"besökande", "besök"},
		{"besöken", "besök"},
		{"besöker", "besök"},
		{"besöket", "besöket"},
		{"besökt", "besök"},
		{"besökta", "besök"},
		{"besökte", "besök"},
		{"besöktes", "besök"},
		{"bet", "bet"},
		{"betade", "bet"},
		{"betaga", "betag"},
		{"betagen", "betag"},
		{"betagit", "betagit"},
		{"betala", "betal"},
		{"betalade", "betal"},
		{"betalar", "betal"},
		{"betalas", "betal"},
		{"betalat", "betal"},
		{"betalda", "betald"},
		{"betalning", "betalning"},
		{"betalningen", "betalning"},
		{"betalt", "betalt"},
		{"betalte", "betalt"},
		{"betankande", "betank"},
		{"betar", "bet"},
		{"bete", "bet"},
		{"beteckningar", "beteckning"},
		{"betedde", "beted"},
		{"betett", "betet"},
		{"beting", "beting"},
		{"betjanar", "betjan"},
		{"betjening", "betjening"},
		{"betjäna", "betjän"},
		{"betjänade", "betjän"},
		{"betjäningen", "betjäning"},
		{"betjänt", "betjänt"},
		{"betlehem", "betlehem"},
		{"betlehems", "betlehem"},
		{"betog", "betog"},
		{"betrak", "betrak"},
		{"betrakta", "betrak"},
		{"betraktad", "betrak"},
		{"betraktadc", "betraktadc"},
		{"betraktade", "betrak"},
		{"betraktades", "betrak"},
		{"betraktande", "betrak"},
		{"betraktar", "betrak"},
		{"betraktas", "betrak"},
		{"betraktat", "betrak"},
		{"betraktelse", "betrakt"},
		{"betraktelsen", "betrakt"},
		{"betraktelser", "betrakt"},
		{"betror", "betr"},
		{"betryck", "betryck"},
		{"betryckt", "betryck"},
		{"betryckta", "betryck"},
		{"betryckte", "betryck"},
		{"beträda", "beträd"},
		{"beträdde", "beträd"},
		{"beträdt", "beträd"},
		{"beträffade", "beträff"},
		{"beträffande", "beträff"},
		{"beträffar", "beträff"},
		{"betsade", "bets"},
		{"betsel", "betsel"},
		{"bett", "bett"},
		{"bettaktelse", "bettakt"},
		{"betty", "betty"},
		{"bettys", "betty"},
		{"betvingare", "betving"},
		{"betvingaren", "betving"},
		{"betvivlade", "betvivl"},
		{"betvivlar", "betvivl"},
		{"betyda", "betyd"},
		{"betydande", "betyd"},
		{"betydde", "betyd"},
		{"betydelse", "betyd"},
		{"betydelsefull", "betydelsefull"},
		{"betydelsefulla", "betydelsefull"},
		{"betydelsefullt", "betydelsefull"},
		{"betydelselösa", "betydelselös"},
		{"betydelsen", "betyd"},
		{"betydenhet", "betyden"},
		{"betyder", "betyd"},
		{"betydlig", "betyd"},
		{"betydliga", "betyd"},
		{"betydligaste", "betyd"},
		{"betydligt", "betyd"},
		{"betyg", "betyg"},
		{"betyga", "betyg"},
		{"betytt", "betyt"},
		{"betäcka", "betäck"},
		{"betäckta", "betäck"},
		{"betäckte", "betäck"},
		{"betänk", "betänk"},
		{"betänka", "betänk"},
		{"betänkande", "betänk"},
		{"betänketid", "betänketid"},
		{"betänklig", "betänk"},
		{"betänkliga", "betänk"},
		{"betänkligheter", "betänk"},
		{"betänkningstid", "betänkningstid"},
		{"betänksam", "betänksam"},
		{"betänksamt", "betänksamt"},
		{"betänkt", "betänk"},
		{"betänkte", "betänk"},
		{"beund", "beund"},
		{"beundra", "beundr"},
		{"beundrad", "beundr"},
		{"beundrade", "beundr"},
		{"beundrades", "beundr"},
		{"beundran", "beundran"},
		{"beundrande", "beundr"},
		{"beundransvärdt", "beundransvärd"},
		{"beundrar", "beundr"},
		{"beundrare", "beundr"},
		{"beundrat", "beundr"},
		{"bevagenhet", "bevagen"},
		{"bevaka", "bevak"},
		{"bevakad", "bevak"},
		{"bevakas", "bevak"},
		{"bevandra", "bevandr"},
		{"bevant", "bevant"},
		{"bevara", "bevar"},
		{"bevarade", "bevar"},
		{"bevarar", "bevar"},
		{"bevaras", "bevar"},
		{"bevarat", "bevar"},
		{"bevare", "bev"},
		{"bevars", "bevar"},
		{"beve", "bev"},
		{"beveka", "bevek"},
		{"bevekande", "bevek"},
		{"bevekelsegrund", "bevekelsegrund"},
		{"bevekelsegrunder", "bevekelsegrund"},
		{"bevekligaste", "bevek"},
		{"bevekt", "bevek"},
		{"bevektes", "bevek"},
		{"beviljad", "bevilj"},
		{"beviljade", "bevilj"},
		{"beviljades", "bevilj"},
		{"beviljas", "bevilj"},
		{"bevingad", "beving"},
		{"bevingat", "beving"},
		{"bevis", "bevis"},
		{"bevisa", "bevis"},
		{"bevisad", "bevis"},
		{"bevisade", "bevis"},
		{"bevisar", "bevis"},
		{"bevisas", "bevis"},
		{"bevisat", "bevis"},
		{"bevisen", "bevis"},
		{"beviset", "beviset"},
		{"bevista", "bevist"},
		{"bevistat", "bevist"},
		{"bevittna", "bevittn"},
		{"bevittnad", "bevittn"},
		{"bevittnade", "bevittn"},
		{"bevittnat", "bevittn"},
		{"bevändt", "bevänd"},
		{"bevänt", "bevänt"},
		{"bevåg", "bevåg"},
		{"bhnd", "bhnd"},
		{"bi", "bi"},
		{"bibehålla", "bibehåll"},
		{"bibehållen", "bibehåll"},
		{"bibehåller", "bibehåll"},
		{"bibehållit", "bibehållit"},
		{"bibehöll", "bibehöll"},
		{"bibehölle", "bibehöll"},
		{"bibel", "bibel"},
		{"bibelens", "bibel"},
		{"bibeln", "bibeln"},
		{"bibelns", "bibeln"},
		{"bibelsprak", "bibelsprak"},
		{"bibelspråk", "bibelspråk"},
		{"biblar", "bibl"},
		{"biblens", "bibl"},
		{"bibliotek", "bibliotek"},
		{"biblioteket", "biblioteket"},
		{"biblioteksfontänen", "biblioteksfontän"},
		{"biblioteksrum", "biblioteksrum"},
		{"biblioteksrummet", "biblioteksrummet"},
		{"bibo", "bibo"},
		{"bicyklister", "bicyklist"},
		{"bidar", "bid"},
		{"bidrag", "bidrag"},
		{"bidraga", "bidrag"},
		{"bidragit", "bidragit"},
		{"bidrar", "bidr"},
		{"bidrog", "bidrog"},
		{"bidrogo", "bidrogo"},
		{"bien", "bien"},
		{"biet", "biet"},
		{"bifall", "bifall"},
		{"bifalla", "bifall"},
		{"bifaller", "bifall"},
		{"bifallet", "bifallet"},
		{"bifallsskrän", "bifallsskrän"},
		{"bifoga", "bifog"},
		{"bifogade", "bifog"},
		{"bifölls", "biföll"},
		{"bihang", "bihang"},
		{"bihanget", "bihanget"},
		{"bikt", "bikt"},
		{"bikta", "bikt"},
		{"bikten", "bikt"},
		{"bikternas", "bikt"},
		{"biktfäder", "biktfäd"},
		{"bil", "bil"},
		{"bila", "bil"},
		{"bilaga", "bilag"},
		{"bilan", "bilan"},
		{"bilar", "bil"},
		{"bilarna", "bil"},
		{"bild", "bild"},
		{"bilda", "bild"},
		{"bildad", "bild"},
		{"bildade", "bild"},
		{"bildades", "bild"},
		{"bildat", "bild"},
		{"bilden", "bild"},
		{"bilder", "bild"},
		{"bilderna", "bild"},
		{"bildhuggeriverk", "bildhuggeriverk"},
		{"bildlikt", "bildlik"},
		{"bildning", "bildning"},
		{"bildningen", "bildning"},
		{"bildningsgrad", "bildningsgr"},
		{"bildstod", "bildstod"},
		{"bilen", "bil"},
		{"bilens", "bil"},
		{"biljett", "biljet"},
		{"biljetten", "biljet"},
		{"biljetter", "biljet"},
		{"biljettluckan", "biljettluckan"},
		{"billig", "bil"},
		{"billiga", "bil"},
		{"billigare", "bil"},
		{"billigheten", "bil"},
		{"billigt", "bil"},
		{"biltoge", "biltog"},
		{"bilägga", "bilägg"},
		{"binamnet", "binamnet"},
		{"binda", "bind"},
		{"bindande", "bind"},
		{"bindel", "bindel"},
		{"binder", "bind"},
		{"bindlar", "bindl"},
		{"bindmössa", "bindmöss"},
		{"bindmössor", "bindmöss"},
		{"bindor", "bind"},
		{"bingar", "bing"},
		{"binglade", "bingl"},
		{"binnikemask", "binnikemask"},
		{"binnikemasken", "binnikemask"},
		{"biograferna", "biograf"},
		{"biografi", "biografi"},
		{"birck", "birck"},
		{"birger", "birg"},
		{"birgers", "birger"},
		{"birgitta", "birgit"},
		{"biroll", "biroll"},
		{"bisak", "bisak"},
		{"bisarraste", "bisarr"},
		{"bisarrerier", "bisarreri"},
		{"bisats", "bisat"},
		{"biskop", "biskop"},
		{"biskopar", "biskop"},
		{"bismak", "bismak"},
		{"bismarck", "bismarck"},
		{"bist", "bist"},
		{"bister", "bist"},
		{"bistert", "bistert"},
		{"bistra", "bistr"},
		{"bistre", "bistr"},
		{"bistånd", "bistånd"},
		{"bistått", "biståt"},
		{"bit", "bit"},
		{"bita", "bit"},
		{"bitande", "bit"},
		{"bitankar", "bitank"},
		{"bitar", "bit"},
		{"bitarna", "bit"},
		{"bitas", "bit"},
		{"biter", "bit"},
		{"bitit", "bitit"},
		{"biträda", "biträd"},
		{"biträde", "biträd"},
		{"biträden", "biträd"},
		{"biträdet", "biträdet"},
		{"bitter", "bitt"},
		{"bitterhet", "bitter"},
		{"bitterheten", "bitter"},
		{"bitterligen", "bitter"},
		{"bittersta", "bitterst"},
		{"bittert", "bittert"},
		{"bittida", "bittid"},
		{"bittra", "bittr"},
		{"bittraste", "bittr"},
		{"bittring", "bittring"},
		{"biått", "biått"},
		{"bjelkar", "bjelk"},
		{"bjelklaget", "bjelklaget"},
		{"bju", "bju"},
		{"bjuda", "bjud"},
		{"bjudande", "bjud"},
		{"bjudas", "bjud"},
		{"bjuden", "bjud"},
		{"bjuder", "bjud"},
		{"bjudes", "bjud"},
		{"bjudit", "bjudit"},
		{"bjudna", "bjudn"},
		{"bjudning", "bjudning"},
		{"bjudningar", "bjudning"},
		{"bjudningskorten", "bjudningskort"},
		{"bjuds", "bjud"},
		{"bjäff", "bjäff"},
		{"bjälkarna", "bjälk"},
		{"bjällra", "bjällr"},
		{"bjärt", "bjärt"},
		{"bjärta", "bjärt"},
		{"bjärtat", "bjärt"},
		{"bjöd", "bjöd"},
		{"bjödo", "bjödo"},
		{"bjödos", "bjödo"},
		{"bjöds", "bjöd"},
		{"björk", "björk"},
		{"björkallen", "björkall"},
		{"björkar", "björk"},
		{"björkarna", "björk"},
		{"björkbacke", "björkback"},
		{"björkdungen", "björkdung"},
		{"björkens", "björk"},
		{"björks", "björk"},
		{"björn", "björn"},
		{"björnars", "björnar"},
		{"björnen", "björn"},
		{"björns", "björn"},
		{"björnspråket", "björnspråket"},
		{"bl", "bl"},
		{"bla", "bla"},
		{"black", "black"},
		{"blacka", "black"},
		{"blacksuddare", "blacksud"},
		{"blackt", "black"},
		{"blad", "blad"},
		{"bladen", "blad"},
		{"bladet", "bladet"},
		{"bladrika", "bladrik"},
		{"bladverket", "bladverket"},
		{"blanchs", "blanch"},
		{"blancmanger", "blancmang"},
		{"bland", "bland"},
		{"blanda", "bland"},
		{"blandad", "bland"},
		{"blandade", "bland"},
		{"blandande", "bland"},
		{"blandar", "bland"},
		{"blandas", "bland"},
		{"blandat", "bland"},
		{"blandning", "blandning"},
		{"blandsäd", "blandsäd"},
		{"blank", "blank"},
		{"blanka", "blank"},
		{"blankskurad", "blankskur"},
		{"blankt", "blank"},
		{"blankte", "blank"},
		{"blanzeflor", "blanzefl"},
		{"blasande", "blas"},
		{"blcv", "blcv"},
		{"ble", "ble"},
		{"bleckmugg", "bleckmugg"},
		{"blef", "blef"},
		{"blefve", "blefv"},
		{"blefvo", "blefvo"},
		{"blek", "blek"},
		{"bleka", "blek"},
		{"blekare", "blek"},
		{"bleke", "blek"},
		{"blekgröna", "blekgrön"},
		{"blekhet", "blek"},
		{"blekna", "blekn"},
		{"bleknade", "blekn"},
		{"bleknande", "blekn"},
		{"bleknar", "blekn"},
		{"blekt", "blekt"},
		{"blekvit", "blekvit"},
		{"blev", "blev"},
		{"bleve", "blev"},
		{"blevo", "blevo"},
		{"bli", "bli"},
		{"blick", "blick"},
		{"blicka", "blick"},
		{"blickade", "blick"},
		{"blickande", "blick"},
		{"blickar", "blick"},
		{"blickarna", "blick"},
		{"blickarnas", "blick"},
		{"blickat", "blick"},
		{"blicken", "blick"},
		{"blid", "blid"},
		{"blida", "blid"},
		{"blidare", "blid"},
		{"blidka", "blidk"},
		{"blif", "blif"},
		{"blifva", "blifv"},
		{"blifver", "blifv"},
		{"blifvit", "blifvit"},
		{"blind", "blind"},
		{"blinda", "blind"},
		{"blindas", "blind"},
		{"blinddörr", "blinddörr"},
		{"blinde", "blind"},
		{"blindhet", "blind"},
		{"blink", "blink"},
		{"blinka", "blink"},
		{"blinkade", "blink"},
		{"blinkande", "blink"},
		{"blinkar", "blink"},
		{"blinkat", "blink"},
		{"blinken", "blink"},
		{"blinkning", "blinkning"},
		{"blint", "blint"},
		{"blir", "blir"},
		{"blitt", "blitt"},
		{"bliv", "bliv"},
		{"bliva", "bliv"},
		{"blivande", "bliv"},
		{"blivit", "blivit"},
		{"blixt", "blixt"},
		{"blixtar", "blixt"},
		{"blixtarna", "blixt"},
		{"blixtlikt", "blixtlik"},
		{"blixtrade", "blixtr"},
		{"blixtrande", "blixtr"},
		{"blixtrat", "blixtr"},
		{"blixtsnabb", "blixtsnabb"},
		{"blixtsnabbt", "blixtsnabbt"},
		{"blod", "blod"},
		{"blodde", "blodd"},
		{"bloddroppe", "bloddropp"},
		{"blodet", "blodet"},
		{"blodets", "blodet"},
		{"blodfläckar", "blodfläck"},
		{"blodfull", "blodfull"},
		{"blodhund", "blodhund"},
		{"blodig", "blod"},
		{"blodiga", "blod"},
		{"blodnatten", "blodnat"},
		{"blodränder", "blodränd"},
		{"blodröd", "blodröd"},
		{"blodröda", "blodröd"},
		{"blodrött", "blodröt"},
		{"blods", "blod"},
		{"blodsarbete", "blodsarbet"},
		{"blodsdroppar", "blodsdropp"},
		{"blodskam", "blodskam"},
		{"blodskulder", "blodskuld"},
		{"blodsprängda", "blodspräng"},
		{"blodstråle", "blodstrål"},
		{"blodstårar", "blodstår"},
		{"blom", "blom"},
		{"blombukett", "blombuket"},
		{"blombuketter", "blombuket"},
		{"blomdoft", "blomdoft"},
		{"blomfrön", "blomfrön"},
		{"blomglaset", "blomglaset"},
		{"blomkrukor", "blomkruk"},
		{"blomkrukorna", "blomkruk"},
		{"blomlik", "blomlik"},
		{"blomma", "blomm"},
		{"blommade", "blomm"},
		{"blomman", "blomman"},
		{"blommande", "blomm"},
		{"blommar", "blomm"},
		{"blommas", "blomm"},
		{"blommat", "blomm"},
		{"blommen", "blomm"},
		{"blommig", "blomm"},
		{"blommon", "blommon"},
		{"blommor", "blomm"},
		{"blommorna", "blomm"},
		{"blommornas", "blomm"},
		{"blommors", "blommor"},
		{"blomning", "blomning"},
		{"blomrabatten", "blomrabat"},
		{"blomrika", "blomrik"},
		{"blomst", "blomst"},
		{"blomster", "blomst"},
		{"blomsteravsky", "blomsteravsky"},
		{"blomsterbutik", "blomsterbutik"},
		{"blomsterbutiken", "blomsterbutik"},
		{"blomsterdoft", "blomsterdoft"},
		{"blomstergudinn", "blomstergudin"},
		{"blomstermångleri", "blomstermångleri"},
		{"blomsterrabatter", "blomsterrabat"},
		{"blomsterrabatterna", "blomsterrabat"},
		{"blomsterskörden", "blomsterskörd"},
		{"blomsterskötsel", "blomsterskötsel"},
		{"blomsterskötseln", "blomsterskötseln"},
		{"blomsterslag", "blomsterslag"},
		{"blomstersträng", "blomstersträng"},
		{"blomsterstänglar", "blomsterstängl"},
		{"blomsterstånd", "blomsterstånd"},
		{"blomstersäden", "blomstersäd"},
		{"blomstertid", "blomstertid"},
		{"blomsterängar", "blomsteräng"},
		{"blomstra", "blomstr"},
		{"blomstrade", "blomstr"},
		{"blomstrand", "blomstrand"},
		{"blomstrande", "blomstr"},
		{"blomstras", "blomstr"},
		{"blomstrat", "blomstr"},
		{"blomstren", "blomstr"},
		{"blomvaserna", "blomvas"},
		{"blond", "blond"},
		{"blonda", "blond"},
		{"blonde", "blond"},
		{"blonder", "blond"},
		{"blondermössa", "blondermöss"},
		{"blondin", "blondin"},
		{"blont", "blont"},
		{"bloss", "bloss"},
		{"blossa", "bloss"},
		{"blossade", "bloss"},
		{"blossande", "bloss"},
		{"blossen", "bloss"},
		{"blossens", "bloss"},
		{"blott", "blott"},
		{"blotta", "blott"},
		{"blottad", "blott"},
		{"blottade", "blott"},
		{"blottat", "blott"},
		{"blottstäld", "blottstäld"},
		{"blottställa", "blottställ"},
		{"blottställd", "blottställd"},
		{"blottställde", "blottställd"},
		{"blottställer", "blottställ"},
		{"blou", "blou"},
		{"blstert", "blstert"},
		{"blume", "blum"},
		{"blumstedt", "blumsted"},
		{"blumstedts", "blumsted"},
		{"blund", "blund"},
		{"blunda", "blund"},
		{"blundade", "blund"},
		{"blundande", "blund"},
		{"blundar", "blund"},
		{"blus", "blus"},
		{"blusen", "blus"},
		{"blusliv", "blusliv"},
		{"bluslivet", "bluslivet"},
		{"bly", "bly"},
		{"blyertspenna", "blyertspen"},
		{"blyg", "blyg"},
		{"blyga", "blyg"},
		{"blygas", "blyg"},
		{"blygdes", "blygd"},
		{"blyghet", "blyg"},
		{"blygheten", "blyg"},
		{"blygs", "blyg"},
		{"blygsam", "blygsam"},
		{"blygsamhet", "blygsam"},
		{"blygsamheten", "blygsam"},
		{"blygsamhetens", "blygsam"},
		{"blygsamma", "blygsamm"},
		{"blygsamt", "blygsamt"},
		{"blygsel", "blygsel"},
		{"blygselkänsla", "blygselkänsl"},
		{"blygselkänslan", "blygselkänslan"},
		{"blygselrodnad", "blygselrodn"},
		{"blygt", "blygt"},
		{"blygts", "blygt"},
		{"blyhagel", "blyhagel"},
		{"blyn", "blyn"},
		{"bläcka", "bläck"},
		{"bläcket", "bläcket"},
		{"bläckfläckar", "bläckfläck"},
		{"bläcksvart", "bläcksvart"},
		{"bläddra", "bläddr"},
		{"bläddrade", "bläddr"},
		{"bläddrande", "bläddr"},
		{"bländad", "bländ"},
		{"bländade", "bländ"},
		{"bländande", "bländ"},
		{"blänk", "blänk"},
		{"blänka", "blänk"},
		{"blänkande", "blänk"},
		{"blänker", "blänk"},
		{"blänkt", "blänk"},
		{"blänkte", "blänk"},
		{"blära", "blär"},
		{"blästern", "bläst"},
		{"blå", "blå"},
		{"blåa", "blåa"},
		{"blåblick", "blåblick"},
		{"blågredelina", "blågredelin"},
		{"blåklocka", "blåklock"},
		{"blåklockor", "blåklock"},
		{"blåklädd", "blåkläd"},
		{"blåmålade", "blåmål"},
		{"blånade", "blån"},
		{"blånande", "blån"},
		{"blånar", "blån"},
		{"blånat", "blån"},
		{"blår", "blår"},
		{"blårandiga", "blårand"},
		{"blårött", "blåröt"},
		{"blås", "blås"},
		{"blåsa", "blås"},
		{"blåsande", "blås"},
		{"blåser", "blås"},
		{"blåsig", "blås"},
		{"blåsor", "blås"},
		{"blåst", "blåst"},
		{"blåsta", "blåst"},
		{"blåste", "blåst"},
		{"blåsten", "blåst"},
		{"blåsyra", "blåsyr"},
		{"blåsyran", "blåsyran"},
		{"blått", "blått"},
		{"blåådrade", "blåådr"},
		{"blöda", "blöd"},
		{"blödande", "blöd"},
		{"blödde", "blödd"},
		{"blöder", "blöd"},
		{"blödig", "blöd"},
		{"blödiga", "blöd"},
		{"blöjor", "blöj"},
		{"blöta", "blöt"},
		{"blött", "blött"},
		{"bo", "bo"},
		{"boa", "boa"},
		{"boan", "boan"},
		{"bock", "bock"},
		{"bocka", "bock"},
		{"bockade", "bock"},
		{"bockar", "bock"},
		{"bocken", "bock"},
		{"bocktörnet", "bocktörnet"},
		{"bod", "bod"},
		{"bodarna", "bod"},
		{"bodarnes", "bodarn"},
		{"bodbetjänt", "bodbetjänt"},
		{"bodbetjänten", "bodbetjänt"},
		{"bodbitrade", "bodbitr"},
		{"bodde", "bodd"},
		{"boddonjuan", "boddonjuan"},
		{"boden", "bod"},
		{"bodfröken", "bodfrök"},
		{"bodfönster", "bodfönst"},
		{"bodkammaren", "bodkamm"},
		{"bodkammarn", "bodkammarn"},
		{"bodknodden", "bodknod"},
		{"boende", "boend"},
		{"boet", "boet"},
		{"boett", "boett"},
		{"boetten", "boett"},
		{"bofast", "bof"},
		{"bog", "bog"},
		{"bogen", "bog"},
		{"bohaget", "bohaget"},
		{"bohuslänningen", "bohuslänning"},
		{"bohusläns", "bohuslän"},
		{"bohuslänska", "bohuslänsk"},
		{"bohuslänske", "bohuslänsk"},
		{"boja", "boj"},
		{"bojt", "bojt"},
		{"bok", "bok"},
		{"boken", "bok"},
		{"bokens", "bok"},
		{"bokföring", "bokföring"},
		{"bokhylla", "bokhyll"},
		{"bokhyllan", "bokhyllan"},
		{"bokhyllor", "bokhyll"},
		{"bokhyllorna", "bokhyll"},
		{"bokna", "bokn"},
		{"bokskåp", "bokskåp"},
		{"bokskåpet", "bokskåpet"},
		{"bokstaf", "bokstaf"},
		{"bokstafven", "bokstafv"},
		{"bokstav", "bokstav"},
		{"bokstaven", "bokstav"},
		{"bokstavlig", "bokstav"},
		{"bokstavligen", "bokstav"},
		{"bokstäver", "bokstäv"},
		{"boktryckare", "boktryck"},
		{"bokvett", "bokvet"},
		{"bolag", "bolag"},
		{"bolagsdirektör", "bolagsdirektör"},
		{"bolagsdirektörn", "bolagsdirektörn"},
		{"bolares", "bolar"},
		{"bolat", "bol"},
		{"boleriska", "bolerisk"},
		{"boll", "boll"},
		{"bolsterhöljda", "bolsterhöljd"},
		{"bom", "bom"},
		{"bomb", "bomb"},
		{"bombasinsförkläde", "bombasinsförkläd"},
		{"bombasinsklänningar", "bombasinsklänning"},
		{"bombasm", "bombasm"},
		{"bomber", "bomb"},
		{"boms", "bom"},
		{"bomull", "bomull"},
		{"bomullen", "bomull"},
		{"bomullschalen", "bomullschal"},
		{"bomullsgardiner", "bomullsgardin"},
		{"bomullskläder", "bomullskläd"},
		{"bomullsklänning", "bomullsklänning"},
		{"bomullsklänningarna", "bomullsklänning"},
		{"bomullsklänningen", "bomullsklänning"},
		{"bomullslärftsgardiner", "bomullslärftsgardin"},
		{"bomullsparaply", "bomullsparaply"},
		{"bomullsplagg", "bomullsplagg"},
		{"bomullssammet", "bomullssammet"},
		{"bomullsschal", "bomullsschal"},
		{"bomullsschalen", "bomullsschal"},
		{"bomullsstrumpor", "bomullsstrump"},
		{"bomullsstrumporna", "bomullsstrump"},
		{"bon", "bon"},
		{"bonat", "bon"},
		{"bonddräng", "bonddräng"},
		{"bonddöttrarna", "bonddöttr"},
		{"bonde", "bond"},
		{"bonden", "bond"},
		{"bondenamn", "bondenamn"},
		{"bondens", "bond"},
		{"bonderomaner", "bonderoman"},
		{"bondesjäl", "bondesjäl"},
		{"bondeska", "bondesk"},
		{"bondeståndet", "bondeståndet"},
		{"bondflicka", "bondflick"},
		{"bondflickan", "bondflickan"},
		{"bondflickans", "bondflickan"},
		{"bondflickor", "bondflick"},
		{"bondflickorna", "bondflick"},
		{"bondflickornas", "bondflick"},
		{"bondfolket", "bondfolket"},
		{"bondgummorna", "bondgumm"},
		{"bondhustru", "bondhustru"},
		{"bondkvinnas", "bondkvin"},
		{"bondkvinnor", "bondkvin"},
		{"bondkärran", "bondkärran"},
		{"bonemotet", "bonemotet"},
		{"bonhomie", "bonhomi"},
		{"boning", "boning"},
		{"boningar", "boning"},
		{"boningsrum", "boningsrum"},
		{"bonjour", "bonjour"},
		{"bonjourer", "bonjour"},
		{"bonjourliknande", "bonjourlikn"},
		{"bonjur", "bonjur"},
		{"bonom", "bonom"},
		{"bopfällda", "bopfälld"},
		{"bor", "bor"},
		{"bora", "bor"},
		{"borag", "borag"},
		{"bord", "bord"},
		{"bordduken", "bordduk"},
		{"borde", "bord"},
		{"bordel", "bordel"},
		{"borden", "bord"},
		{"bordet", "bordet"},
		{"bords", "bord"},
		{"bordsbön", "bordsbön"},
		{"bordsbönen", "bordsbön"},
		{"bordskamrat", "bordskamr"},
		{"bordskanten", "bordskant"},
		{"bordskifva", "bordskifv"},
		{"bordskifvan", "bordskifvan"},
		{"bordstudsaren", "bordstuds"},
		{"bordsänden", "bordsänd"},
		{"bordun", "bordun"},
		{"borg", "borg"},
		{"borgade", "borg"},
		{"borgare", "borg"},
		{"borgarfolk", "borgarfolk"},
		{"borgarhus", "borgarhus"},
		{"borgat", "borg"},
		{"borgen", "borg"},
		{"borgerlig", "borger"},
		{"borgerliga", "borger"},
		{"borgerligt", "borger"},
		{"borgmästare", "borgmäst"},
		{"borgmästaren", "borgmäst"},
		{"borgmästarns", "borgmästarn"},
		{"borjade", "borj"},
		{"borrade", "borr"},
		{"borrades", "borr"},
		{"borrande", "borr"},
		{"borrat", "borr"},
		{"borsta", "borst"},
		{"borstade", "borst"},
		{"borstades", "borst"},
		{"borstar", "borst"},
		{"borste", "borst"},
		{"borsten", "borst"},
		{"borstning", "borstning"},
		{"bort", "bort"},
		{"borta", "bort"},
		{"bortbjuden", "bortbjud"},
		{"bortblåst", "bortblåst"},
		{"bortblåsta", "bortblåst"},
		{"bortbyta", "bortbyt"},
		{"bortbytt", "bortbyt"},
		{"bortdog", "bortdog"},
		{"bortdöende", "bortdöend"},
		{"bortföres", "bortför"},
		{"bortfört", "bortfört"},
		{"bortgingo", "bortgingo"},
		{"bortglömda", "bortglömd"},
		{"bortglömt", "bortglömt"},
		{"bortgång", "bortgång"},
		{"bortgångne", "bortgångn"},
		{"bortifran", "bortifran"},
		{"bortifrån", "bortifrån"},
		{"bortilande", "bortil"},
		{"bortkastade", "bortkast"},
		{"bortkelade", "bortkel"},
		{"bortlade", "bortl"},
		{"bortnöta", "bortnöt"},
		{"bortnött", "bortnöt"},
		{"bortom", "bortom"},
		{"bortprata", "bortprat"},
		{"bortpratade", "bortprat"},
		{"bortre", "bortr"},
		{"bortresa", "bortres"},
		{"bortresta", "bortrest"},
		{"bortsatt", "bortsat"},
		{"bortschasad", "bortschas"},
		{"bortse", "borts"},
		{"bortskaffa", "bortskaff"},
		{"bortskymd", "bortskymd"},
		{"bortskyndande", "bortskynd"},
		{"bortskämd", "bortskämd"},
		{"bortskämda", "bortskämd"},
		{"bortskämdt", "bortskämd"},
		{"bortskämt", "bortskämt"},
		{"bortsköt", "bortsköt"},
		{"bortslitma", "bortslitm"},
		{"bortsnappat", "bortsnapp"},
		{"bortsopade", "bortsop"},
		{"bortspoladt", "bortspolad"},
		{"bortstjäla", "bortstjäl"},
		{"bortsväva", "bortsväv"},
		{"borttaga", "borttag"},
		{"borttappad", "borttapp"},
		{"borttappade", "borttapp"},
		{"borttorka", "borttork"},
		{"borttorkade", "borttork"},
		{"bortvända", "bortvänd"},
		{"bortvände", "bortvänd"},
		{"bortvänt", "bortvänt"},
		{"bortåt", "bortåt"},
		{"boshdem", "boshdem"},
		{"boskap", "boskap"},
		{"boskapen", "boskap"},
		{"boskapens", "boskap"},
		{"bostad", "bost"},
		{"bostaden", "bostad"},
		{"bostäder", "bostäd"},
		{"bosättning", "bosättning"},
		{"bot", "bot"},
		{"bota", "bot"},
		{"botaniken", "botanik"},
		{"botar", "bot"},
		{"botfärdiga", "botfärd"},
		{"botofter", "botoft"},
		{"botpredikanten", "botpredikant"},
		{"bott", "bott"},
		{"botten", "bott"},
		{"bottenfock", "bottenfock"},
		{"bottenrefvadt", "bottenrefvad"},
		{"bottnen", "bottn"},
		{"boulangermarschen", "boulangermarsch"},
		{"bourgogne", "bourgogn"},
		{"boven", "bov"},
		{"bra", "bra"},
		{"bradska", "bradsk"},
		{"bragden", "bragd"},
		{"bragder", "bragd"},
		{"bragt", "bragt"},
		{"bragte", "bragt"},
		{"brakade", "brak"},
		{"brand", "brand"},
		{"brandfärgat", "brandfärg"},
		{"brandförsäkra", "brandförsäkr"},
		{"brandgul", "brandgul"},
		{"brann", "brann"},
		{"brant", "brant"},
		{"branta", "brant"},
		{"branten", "brant"},
		{"branter", "brant"},
		{"branting", "branting"},
		{"brasa", "bras"},
		{"brasan", "brasan"},
		{"brasans", "brasan"},
		{"brasglöd", "brasglöd"},
		{"braska", "brask"},
		{"brasorna", "bras"},
		{"brast", "brast"},
		{"brattom", "brattom"},
		{"braun", "braun"},
		{"braverat", "braver"},
		{"braxenpanka", "braxenpank"},
		{"bred", "bred"},
		{"breda", "bred"},
		{"bredare", "bred"},
		{"bredast", "bred"},
		{"bredaxlad", "bredaxl"},
		{"bredbent", "bredbent"},
		{"bredd", "bredd"},
		{"bredde", "bredd"},
		{"bredden", "bredd"},
		{"breden", "bred"},
		{"breder", "bred"},
		{"bredskyggig", "bredskygg"},
		{"bredskörtade", "bredskört"},
		{"bredvi", "bredvi"},
		{"bredvid", "bredvid"},
		{"bref", "bref"},
		{"brefvet", "brefvet"},
		{"brefvets", "brefvet"},
		{"brett", "brett"},
		{"brev", "brev"},
		{"brevbärarinnans", "brevbärarinnan"},
		{"breven", "brev"},
		{"brevet", "brevet"},
		{"brevets", "brevet"},
		{"brevid", "brevid"},
		{"brevlådan", "brevlådan"},
		{"bricka", "brick"},
		{"brickan", "brickan"},
		{"brigg", "brigg"},
		{"brikoll", "brikoll"},
		{"briljant", "briljant"},
		{"brin", "brin"},
		{"bring", "bring"},
		{"bringa", "bring"},
		{"bringade", "bring"},
		{"bringan", "bringan"},
		{"bringar", "bring"},
		{"bringat", "bring"},
		{"brinna", "brinn"},
		{"brinnande", "brinn"},
		{"brinne", "brinn"},
		{"brinner", "brinn"},
		{"brist", "brist"},
		{"brista", "brist"},
		{"bristande", "brist"},
		{"bristen", "brist"},
		{"brister", "brist"},
		{"bristfälligt", "bristfäl"},
		{"brita", "brit"},
		{"britta", "britt"},
		{"brittas", "britt"},
		{"brittmässvind", "brittmässvind"},
		{"brmna", "brmna"},
		{"bro", "bro"},
		{"broar", "broar"},
		{"brockhaus", "brockhaus"},
		{"broder", "brod"},
		{"brodera", "broder"},
		{"broderad", "broder"},
		{"broderat", "broder"},
		{"broderi", "broderi"},
		{"broderier", "broderi"},
		{"broderiet", "broderiet"},
		{"brodering", "brodering"},
		{"broderliga", "broder"},
		{"brodern", "brod"},
		{"broderns", "brod"},
		{"broderskap", "broderskap"},
		{"brodet", "brodet"},
		{"brokad", "brok"},
		{"brokig", "brok"},
		{"brokiga", "brok"},
		{"brokigt", "brok"},
		{"bromsar", "broms"},
		{"bromsarna", "broms"},
		{"bron", "bron"},
		{"brons", "bron"},
		{"bronserad", "bronser"},
		{"bronsgruppen", "bronsgrupp"},
		{"bronsstoden", "bronsstod"},
		{"bror", "bror"},
		{"brors", "bror"},
		{"brorskål", "brorskål"},
		{"brorson", "brorson"},
		{"brorsonen", "brorson"},
		{"brorsonens", "brorson"},
		{"broräcket", "broräcket"},
		{"brosch", "brosch"},
		{"brost", "brost"},
		{"brostedt", "brosted"},
		{"brostedts", "brosted"},
		{"brott", "brott"},
		{"brottades", "brott"},
		{"brottande", "brott"},
		{"brotten", "brott"},
		{"brottet", "brottet"},
		{"brottets", "brottet"},
		{"brottslig", "brotts"},
		{"brottsliga", "brotts"},
		{"brottslighet", "brotts"},
		{"brottsligt", "brotts"},
		{"brottsling", "brottsling"},
		{"brottslingarne", "brottsling"},
		{"bru", "bru"},
		{"brud", "brud"},
		{"brudckrona", "brudckron"},
		{"brudekrona", "brudekron"},
		{"bruden", "brud"},
		{"brudens", "brud"},
		{"brudgum", "brudgum"},
		{"brudgummen", "brudgumm"},
		{"brudgums", "brudgum"},
		{"brudklädningen", "brudklädning"},
		{"brudklänningen", "brudklänning"},
		{"brudpallen", "brudpall"},
		{"brudparet", "brudparet"},
		{"brudskaran", "brudskaran"},
		{"brudskruden", "brudskrud"},
		{"brudslöja", "brudslöj"},
		{"brudsängen", "brudsäng"},
		{"bruk", "bruk"},
		{"bruka", "bruk"},
		{"brukade", "bruk"},
		{"brukar", "bruk"},
		{"brukas", "bruk"},
		{"brukat", "bruk"},
		{"brukbar", "brukb"},
		{"bruket", "bruket"},
		{"brukliga", "bruk"},
		{"brukspatron", "brukspatron"},
		{"brum", "brum"},
		{"brumma", "brumm"},
		{"brun", "brun"},
		{"bruna", "brun"},
		{"brunbarkade", "brunbark"},
		{"brunbetsad", "brunbets"},
		{"brunbr", "brunbr"},
		{"brunbrända", "brunbränd"},
		{"brunetta", "brunet"},
		{"brunn", "brunn"},
		{"brunnen", "brunn"},
		{"brunnit", "brunnit"},
		{"brunno", "brunno"},
		{"brunnsbal", "brunnsbal"},
		{"brunnsorten", "brunnsort"},
		{"brunnsresan", "brunnsresan"},
		{"brunrosiga", "brunros"},
		{"brunrosigt", "brunros"},
		{"brunröda", "brunröd"},
		{"brunst", "brunst"},
		{"brunstekta", "brunstek"},
		{"brunt", "brunt"},
		{"brunögda", "brunög"},
		{"brus", "brus"},
		{"brusa", "brus"},
		{"brusade", "brus"},
		{"brusala", "brusal"},
		{"brusalahöst", "brusalahöst"},
		{"brusalaljus", "brusalaljus"},
		{"brusalanatt", "brusalanat"},
		{"brusalavår", "brusalavår"},
		{"brusande", "brus"},
		{"brusar", "brus"},
		{"brush", "brush"},
		{"brushen", "brush"},
		{"brusning", "brusning"},
		{"brusten", "brust"},
		{"brustit", "brustit"},
		{"brustna", "brustn"},
		{"brusto", "brusto"},
		{"brutala", "brutal"},
		{"bruten", "brut"},
		{"brutet", "brutet"},
		{"brutit", "brutit"},
		{"brutna", "brutn"},
		{"bry", "bry"},
		{"brydd", "brydd"},
		{"bryddc", "bryddc"},
		{"brydde", "brydd"},
		{"bryderi", "bryderi"},
		{"brydsamma", "brydsamm"},
		{"brygga", "brygg"},
		{"bryggan", "bryggan"},
		{"bryggans", "bryggan"},
		{"bryggarkärra", "bryggarkärr"},
		{"brygghus", "brygghus"},
		{"bryn", "bryn"},
		{"brynostar", "brynost"},
		{"brynt", "brynt"},
		{"bryr", "bryr"},
		{"bryta", "bryt"},
		{"bryter", "bryt"},
		{"brytning", "brytning"},
		{"brytt", "brytt"},
		{"bräckliga", "bräck"},
		{"bräckt", "bräck"},
		{"bräckte", "bräck"},
		{"bräcktes", "bräck"},
		{"brädd", "brädd"},
		{"brädden", "brädd"},
		{"bräder", "bräd"},
		{"bräderna", "bräd"},
		{"brädet", "brädet"},
		{"brädgårdar", "brädgård"},
		{"brädspelet", "brädspelet"},
		{"brädspelsbordet", "brädspelsbordet"},
		{"bräkte", "bräkt"},
		{"bränd", "bränd"},
		{"brända", "bränd"},
		{"brände", "bränd"},
		{"bränn", "bränn"},
		{"bränna", "bränn"},
		{"brännande", "bränn"},
		{"brännas", "bränn"},
		{"bränner", "bränn"},
		{"bränneribyggnaden", "bränneribyggnad"},
		{"bränningar", "bränning"},
		{"bränningarne", "bränning"},
		{"bränningen", "bränning"},
		{"bränningens", "bränning"},
		{"brännpunkt", "brännpunk"},
		{"brännskadan", "brännskadan"},
		{"brännvin", "brännvin"},
		{"brännvinet", "brännvinet"},
		{"brännvinets", "brännvinet"},
		{"brännvinsglas", "brännvinsgl"},
		{"bränt", "bränt"},
		{"bränvin", "bränvin"},
		{"bränvins", "bränvin"},
		{"brätte", "brätt"},
		{"brätten", "brätt"},
		{"brättet", "brättet"},
		{"bråckband", "bråckband"},
		{"bråddjup", "bråddjup"},
		{"bråddjupet", "bråddjupet"},
		{"brådska", "brådsk"},
		{"brådskan", "brådskan"},
		{"brådskande", "brådsk"},
		{"brådstörtade", "brådstört"},
		{"brådstörtande", "brådstört"},
		{"brådt", "brådt"},
		{"brådtom", "brådtom"},
		{"bråelser", "bråels"},
		{"bråk", "bråk"},
		{"bråka", "bråk"},
		{"bråkades", "bråk"},
		{"bråkat", "bråk"},
		{"bråkdel", "bråkdel"},
		{"bråkiga", "bråk"},
		{"brånar", "brån"},
		{"bråte", "bråt"},
		{"bråtet", "bråtet"},
		{"bråtl", "bråtl"},
		{"brått", "brått"},
		{"bråttom", "bråttom"},
		{"bråvik", "bråvik"},
		{"brö", "brö"},
		{"bröd", "bröd"},
		{"brödbitar", "brödbit"},
		{"bröder", "bröd"},
		{"bröderna", "bröd"},
		{"brödernas", "bröd"},
		{"brödet", "brödet"},
		{"brödkaka", "brödkak"},
		{"brödstycke", "brödstyck"},
		{"brödutdelningen", "brödutdelning"},
		{"bröllop", "bröllop"},
		{"bröllopet", "bröllopet"},
		{"bröllops", "bröllop"},
		{"bröllopsdagen", "bröllopsdag"},
		{"bröllopsgästerna", "bröllopsgäst"},
		{"bröllopshus", "bröllopshus"},
		{"bröllopskrans", "bröllopskran"},
		{"bröllopslägrets", "bröllopslägret"},
		{"bröllopsmarskalken", "bröllopsmarskalk"},
		{"bröllopsresa", "bröllopsres"},
		{"bröllopsskaran", "bröllopsskaran"},
		{"bröst", "bröst"},
		{"brösten", "bröst"},
		{"bröstens", "bröst"},
		{"bröstet", "bröstet"},
		{"bröstfickan", "bröstfickan"},
		{"bröstfickans", "bröstfickan"},
		{"bröstförkläde", "bröstförkläd"},
		{"bröstkråset", "bröstkråset"},
		{"bröstvärk", "bröstvärk"},
		{"bröt", "bröt"},
		{"bröto", "bröto"},
		{"brötos", "bröto"},
		{"bt", "bt"},
		{"bttrak", "bttrak"},
		{"bubblade", "bubbl"},
		{"bubblande", "bubbl"},
		{"bubblor", "bubbl"},
		{"buch", "buch"},
		{"bucklade", "buckl"},
		{"bucklorna", "buckl"},
		{"bud", "bud"},
		{"budet", "budet"},
		{"budorden", "budord"},
		{"budordet", "budordet"},
		{"buds", "bud"},
		{"budskap", "budskap"},
		{"buga", "bug"},
		{"bugade", "bug"},
		{"bugande", "bug"},
		{"bugar", "bug"},
		{"bugat", "bug"},
		{"bugning", "bugning"},
		{"bugningar", "bugning"},
		{"buk", "buk"},
		{"bukett", "buket"},
		{"buketten", "buket"},
		{"buketter", "buket"},
		{"bukt", "bukt"},
		{"buktande", "bukt"},
		{"bukter", "bukt"},
		{"buktiga", "bukt"},
		{"bulevarden", "bulevard"},
		{"buljong", "buljong"},
		{"buljongen", "buljong"},
		{"buljongens", "buljong"},
		{"bull", "bull"},
		{"bulle", "bull"},
		{"buller", "bull"},
		{"bullhalva", "bullhalv"},
		{"bullrande", "bullr"},
		{"bullrar", "bullr"},
		{"bullret", "bullret"},
		{"bulor", "bul"},
		{"bulsig", "buls"},
		{"bulta", "bult"},
		{"bultade", "bult"},
		{"bultande", "bult"},
		{"bultar", "bult"},
		{"bulwer", "bulw"},
		{"bunden", "bund"},
		{"bundet", "bundet"},
		{"bundit", "bundit"},
		{"bundna", "bundn"},
		{"bundo", "bundo"},
		{"bundt", "bund"},
		{"bundtar", "bund"},
		{"bundttröja", "bundttröj"},
		{"bunt", "bunt"},
		{"buntar", "bunt"},
		{"bunyans", "bunyan"},
		{"bur", "bur"},
		{"buren", "bur"},
		{"burgund", "burgund"},
		{"burit", "burit"},
		{"burk", "burk"},
		{"burkar", "burk"},
		{"burna", "burn"},
		{"buro", "buro"},
		{"burskap", "burskap"},
		{"busarna", "bus"},
		{"buse", "bus"},
		{"buskar", "busk"},
		{"buskarna", "busk"},
		{"buske", "busk"},
		{"busken", "busk"},
		{"buss", "buss"},
		{"bussen", "buss"},
		{"butelj", "butelj"},
		{"buteljen", "butelj"},
		{"buteljer", "butelj"},
		{"buteljerna", "butelj"},
		{"buteljgrön", "buteljgrön"},
		{"buteljgröna", "buteljgrön"},
		{"butiken", "butik"},
		{"butikernas", "butik"},
		{"butiksfönster", "butiksfönst"},
		{"buttert", "buttert"},
		{"buttra", "buttr"},
		{"buvudet", "buvudet"},
		{"by", "by"},
		{"byar", "byar"},
		{"byffen", "byff"},
		{"bygd", "bygd"},
		{"bygden", "bygd"},
		{"bygderna", "bygd"},
		{"bygdes", "bygd"},
		{"bygdt", "bygd"},
		{"bygga", "bygg"},
		{"byggande", "bygg"},
		{"byggas", "bygg"},
		{"byggd", "bygg"},
		{"byggda", "bygg"},
		{"byggde", "bygg"},
		{"bygger", "bygg"},
		{"byggnad", "byggn"},
		{"byggnaden", "byggnad"},
		{"byggnader", "byggnad"},
		{"byggnaderna", "byggnad"},
		{"byggnadsställningar", "byggnadsställning"},
		{"byggningen", "byggning"},
		{"byggt", "bygg"},
		{"bygningen", "bygning"},
		{"bygt", "bygt"},
		{"bylte", "bylt"},
		{"byn", "byn"},
		{"byns", "byn"},
		{"byrå", "byrå"},
		{"byråar", "byrå"},
		{"byrålådan", "byrålådan"},
		{"byrån", "byrån"},
		{"byråns", "byrån"},
		{"byrånyckel", "byrånyckel"},
		{"bysättning", "bysättning"},
		{"byta", "byt"},
		{"byte", "byt"},
		{"bytet", "bytet"},
		{"byting", "byting"},
		{"bytt", "bytt"},
		{"bytte", "bytt"},
		{"byxfickorna", "byxfick"},
		{"byxor", "byx"},
		{"byxorna", "byx"},
		{"bä", "bä"},
		{"bäckar", "bäck"},
		{"bäckarna", "bäck"},
		{"bäcken", "bäck"},
		{"bäd", "bäd"},
		{"bädd", "bädd"},
		{"bädda", "bädd"},
		{"bäddad", "bädd"},
		{"bäddade", "bädd"},
		{"bäddar", "bädd"},
		{"bädden", "bädd"},
		{"bäfvan", "bäfvan"},
		{"bäfvande", "bäfv"},
		{"bäfvat", "bäfv"},
		{"bägare", "bäg"},
		{"bägarn", "bägarn"},
		{"bägge", "bägg"},
		{"bägges", "bägg"},
		{"bälg", "bälg"},
		{"bält", "bält"},
		{"bän", "bän"},
		{"bänder", "bänd"},
		{"bängde", "bäng"},
		{"bänk", "bänk"},
		{"bänkar", "bänk"},
		{"bänkarna", "bänk"},
		{"bänken", "bänk"},
		{"bänkraden", "bänkrad"},
		{"bär", "bär"},
		{"bära", "bär"},
		{"bärande", "bär"},
		{"bärare", "bär"},
		{"bäras", "bär"},
		{"bären", "bär"},
		{"bärga", "bärg"},
		{"bärgad", "bärg"},
		{"bärgade", "bärg"},
		{"bärlig", "bär"},
		{"bärs", "bär"},
		{"bärsärkaraseri", "bärsärkaraseri"},
		{"bäst", "bäst"},
		{"bästa", "bäst"},
		{"bäste", "bäst"},
		{"bättra", "bättr"},
		{"bättre", "bättr"},
		{"bättringsvägen", "bättringsväg"},
		{"bävade", "bäv"},
		{"bävan", "bävan"},
		{"bävande", "bäv"},
		{"bävar", "bäv"},
		{"bäverråtta", "bäverråt"},
		{"båd", "båd"},
		{"båda", "båd"},
		{"bådande", "båd"},
		{"bådar", "båd"},
		{"bådas", "båd"},
		{"både", "båd"},
		{"bådo", "bådo"},
		{"båga", "båg"},
		{"bågar", "båg"},
		{"båge", "båg"},
		{"bågen", "båg"},
		{"bågiga", "båg"},
		{"båglampa", "båglamp"},
		{"bågna", "bågn"},
		{"bål", "bål"},
		{"båld", "båld"},
		{"bålet", "bålet"},
		{"bålrika", "bålrik"},
		{"bålstor", "bålst"},
		{"bånglade", "bångl"},
		{"bård", "bård"},
		{"bården", "bård"},
		{"bårens", "bår"},
		{"bårhade", "bårh"},
		{"bås", "bås"},
		{"båt", "båt"},
		{"båtar", "båt"},
		{"båtarna", "båt"},
		{"båtarnas", "båt"},
		{"båtarne", "båt"},
		{"båten", "båt"},
		{"båtens", "båt"},
		{"båthuset", "båthuset"},
		{"båtkarl", "båtkarl"},
		{"båtslöjtnanten", "båtslöjtnant"},
		{"böcker", "böck"},
		{"böckerna", "böck"},
		{"böcklins", "böcklin"},
		{"böj", "böj"},
		{"böja", "böj"},
		{"böjd", "böjd"},
		{"böjda", "böjd"},
		{"böjde", "böjd"},
		{"böjdes", "böjd"},
		{"böjelse", "böj"},
		{"böjelser", "böj"},
		{"böjlig", "böj"},
		{"böjliga", "böj"},
		{"böjning", "böjning"},
		{"böjningarna", "böjning"},
		{"böjningen", "böjning"},
		{"böjt", "böjt"},
		{"böl", "böl"},
		{"böld", "böld"},
		{"bölder", "böld"},
		{"bölja", "bölj"},
		{"böljade", "bölj"},
		{"böljeslag", "böljeslag"},
		{"böljor", "bölj"},
		{"böljorna", "bölj"},
		{"böljornas", "bölj"},
		{"böljskum", "böljskum"},
		{"böll", "böll"},
		{"bömisk", "bömisk"},
		{"bön", "bön"},
		{"böncstunder", "böncstund"},
		{"bönder", "bönd"},
		{"bönderna", "bönd"},
		{"böne", "bön"},
		{"bönehus", "bönehus"},
		{"böneman", "böneman"},
		{"bönemöte", "bönemöt"},
		{"bönemöten", "bönemöt"},
		{"bönen", "bön"},
		{"böner", "bön"},
		{"bönerna", "bön"},
		{"bönernas", "bön"},
		{"bönesuck", "bönesuck"},
		{"bönfalla", "bönfall"},
		{"bönfallande", "bönfall"},
		{"bönkapell", "bönkapell"},
		{"bör", "bör"},
		{"böra", "bör"},
		{"börd", "börd"},
		{"börda", "börd"},
		{"bördan", "bördan"},
		{"börde", "börd"},
		{"bördens", "börd"},
		{"börja", "börj"},
		{"börjacle", "börjacl"},
		{"började", "börj"},
		{"börjades", "börj"},
		{"börjam", "börjam"},
		{"början", "början"},
		{"börjar", "börj"},
		{"börjas", "börj"},
		{"börjat", "börj"},
		{"börjen", "börj"},
		{"börs", "bör"},
		{"bört", "bört"},
		{"bössa", "böss"},
		{"bössan", "bössan"},
		{"böttiger", "bött"},
		{"bövelen", "bövel"},
		{"böveln", "böveln"},
		{"c", "c"},
		{"ca", "ca"},
		{"calle", "call"},
		{"camma", "camm"},
		{"canto", "canto"},
		{"care", "car"},
		{"carl", "carl"},
		{"carlo", "carlo"},
		{"carree", "carre"},
		{"causent", "causent"},
		{"cavalleria", "cavalleri"},
		{"ccix", "ccix"},
		{"ccvii", "ccvii"},
		{"ccviii", "ccviii"},
		{"ccx", "ccx"},
		{"cecilia", "cecili"},
		{"cecilias", "cecili"},
		{"cedera", "ceder"},
		{"cell", "cell"},
		{"celle", "cell"},
		{"cellerna", "cell"},
		{"ceremoni", "ceremoni"},
		{"ceremonien", "ceremoni"},
		{"ceremonierna", "ceremoni"},
		{"ceremoniplikter", "ceremoniplik"},
		{"cftcr", "cftcr"},
		{"cfter", "cfter"},
		{"cgent", "cgent"},
		{"ch", "ch"},
		{"chablis", "chablis"},
		{"champagne", "champagn"},
		{"champagnen", "champagn"},
		{"champagnesorten", "champagnesort"},
		{"charlatan", "charlatan"},
		{"charlataner", "charlatan"},
		{"charlatanfasoner", "charlatanfason"},
		{"charm", "charm"},
		{"charmant", "charmant"},
		{"charmanta", "charmant"},
		{"charmerad", "charmer"},
		{"charmörer", "charmör"},
		{"charon", "charon"},
		{"chasseur", "chasseur"},
		{"chelone", "chelon"},
		{"chevalereska", "chevaleresk"},
		{"chevelyr", "chevelyr"},
		{"cheviotstyget", "cheviotstyget"},
		{"chic", "chic"},
		{"chicago", "chicago"},
		{"chiffer", "chiff"},
		{"chiffonjeklaffen", "chiffonjeklaff"},
		{"chiffonjen", "chiffonj"},
		{"chikanerad", "chikaner"},
		{"chloris", "chloris"},
		{"choklad", "chokl"},
		{"chokladbit", "chokladbit"},
		{"chokladbrun", "chokladbrun"},
		{"chokladkaka", "chokladkak"},
		{"chopin", "chopin"},
		{"chopins", "chopin"},
		{"christine", "christin"},
		{"cig", "cig"},
		{"cigarett", "cigaret"},
		{"cigarettstumpen", "cigarettstump"},
		{"cigarr", "cigarr"},
		{"cigarraskan", "cigarraskan"},
		{"cigarrbod", "cigarrbod"},
		{"cigarrbutik", "cigarrbutik"},
		{"cigarren", "cigarr"},
		{"cigarrer", "cigarr"},
		{"cigarrerna", "cigarr"},
		{"cigarrett", "cigarret"},
		{"cigarretten", "cigarret"},
		{"cigarretter", "cigarret"},
		{"cigarrettetui", "cigarrettetui"},
		{"cigarrettspetsen", "cigarrettspets"},
		{"cigarrfodral", "cigarrfodral"},
		{"cigarrfrågan", "cigarrfrågan"},
		{"cigarrkopp", "cigarrkopp"},
		{"cigarröken", "cigarrök"},
		{"cirka", "cirk"},
		{"cirkel", "cirkel"},
		{"cirklar", "cirkl"},
		{"citat", "cit"},
		{"citia", "citi"},
		{"citron", "citron"},
		{"citrongul", "citrongul"},
		{"citronskiva", "citronskiv"},
		{"citronsyrad", "citronsyr"},
		{"civilisation", "civilisation"},
		{"civilisationens", "civilisation"},
		{"civiliserade", "civiliser"},
		{"cj", "cj"},
		{"ckade", "ckad"},
		{"clct", "clct"},
		{"cldrött", "cldrött"},
		{"cleganta", "clegant"},
		{"clownaktigt", "clownakt"},
		{"clätt", "clätt"},
		{"cn", "cn"},
		{"cns", "cns"},
		{"coeur", "coeur"},
		{"coldcream", "coldcream"},
		{"collvins", "collvin"},
		{"cologne", "cologn"},
		{"commun", "commun"},
		{"connoissent", "connoissent"},
		{"corde", "cord"},
		{"corpus", "corpus"},
		{"corydalis", "corydalis"},
		{"cr", "cr"},
		{"creature", "creatur"},
		{"cremer", "crem"},
		{"crepen", "crep"},
		{"croit", "croit"},
		{"ct", "ct"},
		{"ctra", "ctra"},
		{"ctt", "ctt"},
		{"curetterna", "curet"},
		{"cyankalium", "cyankalium"},
		{"cyankaliumpiller", "cyankaliumpill"},
		{"cylinder", "cylind"},
		{"cylinderhatt", "cylinderhat"},
		{"cyrenaiker", "cyrenaik"},
		{"cyrenaikerna", "cyrenaik"},
		{"d", "d"},
		{"da", "da"},
		{"dad", "dad"},
		{"dadcs", "dadc"},
		{"dade", "dad"},
		{"dag", "dag"},
		{"dagama", "dagam"},
		{"dagar", "dag"},
		{"dagarna", "dag"},
		{"dagarnas", "dag"},
		{"dagarne", "dag"},
		{"dagars", "dagar"},
		{"dagas", "dag"},
		{"dagblad", "dagbl"},
		{"dagbladet", "dagbladet"},
		{"dagbladskontoret", "dagbladskontoret"},
		{"dagbok", "dagbok"},
		{"dagboken", "dagbok"},
		{"dagboksblad", "dagboksbl"},
		{"dagbokslappar", "dagbokslapp"},
		{"dagen", "dag"},
		{"dagens", "dag"},
		{"dager", "dag"},
		{"dagern", "dag"},
		{"dagg", "dagg"},
		{"daggdroppe", "daggdropp"},
		{"daggdtoppar", "daggdtopp"},
		{"daggen", "dagg"},
		{"daggfrisk", "daggfrisk"},
		{"daggiga", "dagg"},
		{"daggryningen", "daggryning"},
		{"daglig", "dag"},
		{"dagliga", "dag"},
		{"dagligen", "dag"},
		{"dagligrummet", "dagligrummet"},
		{"dagligt", "dag"},
		{"dagningen", "dagning"},
		{"dags", "dag"},
		{"dagsarbete", "dagsarbet"},
		{"dagsljus", "dagsljus"},
		{"dagsljuset", "dagsljuset"},
		{"dagslång", "dagslång"},
		{"dagslånga", "dagslång"},
		{"dagsresa", "dagsres"},
		{"dagstaho", "dagstaho"},
		{"dagstahohlm", "dagstahohlm"},
		{"dagstaholm", "dagstaholm"},
		{"dal", "dal"},
		{"dala", "dal"},
		{"dalar", "dal"},
		{"dalen", "dal"},
		{"dalfolk", "dalfolk"},
		{"daligt", "dal"},
		{"dalkarl", "dalkarl"},
		{"dallra", "dallr"},
		{"dallrade", "dallr"},
		{"dallrande", "dallr"},
		{"dallring", "dallring"},
		{"dalmålning", "dalmålning"},
		{"dalstedt", "dalsted"},
		{"dam", "dam"},
		{"damast", "dam"},
		{"damastöverdraget", "damastöverdraget"},
		{"dame", "dam"},
		{"damen", "dam"},
		{"damens", "dam"},
		{"damer", "dam"},
		{"damerna", "dam"},
		{"damm", "damm"},
		{"damma", "damm"},
		{"dammade", "damm"},
		{"dammades", "damm"},
		{"dammar", "damm"},
		{"dammen", "damm"},
		{"dammet", "dammet"},
		{"dammig", "damm"},
		{"dammiga", "damm"},
		{"dammkorn", "dammkorn"},
		{"dammskyarna", "dammsky"},
		{"dampäls", "dampäl"},
		{"damring", "damring"},
		{"damtorkar", "damtork"},
		{"dan", "dan"},
		{"dana", "dan"},
		{"danad", "dan"},
		{"dandy", "dandy"},
		{"daniel", "daniel"},
		{"dankar", "dank"},
		{"dans", "dan"},
		{"dansa", "dans"},
		{"dansade", "dans"},
		{"dansande", "dans"},
		{"dansandes", "dans"},
		{"dansar", "dans"},
		{"dansat", "dans"},
		{"dansdocka", "dansdock"},
		{"dansen", "dans"},
		{"dansk", "dansk"},
		{"dansskola", "dansskol"},
		{"danssteg", "danssteg"},
		{"dant", "dant"},
		{"danviken", "danvik"},
		{"dar", "dar"},
		{"darfor", "darf"},
		{"dari", "dari"},
		{"darifrån", "darifrån"},
		{"darom", "darom"},
		{"darr", "darr"},
		{"darra", "darr"},
		{"darrade", "darr"},
		{"darrande", "darr"},
		{"darrar", "darr"},
		{"darrat", "darr"},
		{"darrning", "darrning"},
		{"darvid", "darvid"},
		{"darwinismen", "darwinism"},
		{"dasa", "das"},
		{"daterad", "dater"},
		{"daterar", "dater"},
		{"dato", "dato"},
		{"datorn", "datorn"},
		{"datorsbostaden", "datorsbostad"},
		{"datum", "datum"},
		{"datumen", "datum"},
		{"dc", "dc"},
		{"dcdför", "dcdför"},
		{"dcn", "dcn"},
		{"dct", "dct"},
		{"dcu", "dcu"},
		{"de", "de"},
		{"debatt", "debat"},
		{"debet", "debet"},
		{"december", "decemb"},
		{"decembermörker", "decembermörk"},
		{"decemberstormen", "decemberstorm"},
		{"definition", "definition"},
		{"definitivt", "definitivt"},
		{"defunts", "defunt"},
		{"deg", "deg"},
		{"degen", "deg"},
		{"degkaret", "degkaret"},
		{"dejelig", "deje"},
		{"dekadans", "dekadan"},
		{"deklameras", "deklamer"},
		{"dekokter", "dekok"},
		{"dekorationer", "dekoration"},
		{"dekorationerna", "dekoration"},
		{"dekorativ", "dekorativ"},
		{"dekorerat", "dekorer"},
		{"del", "del"},
		{"dela", "del"},
		{"delad", "del"},
		{"delade", "del"},
		{"delades", "del"},
		{"delaktig", "delakt"},
		{"delande", "del"},
		{"delar", "del"},
		{"delarna", "del"},
		{"delarne", "del"},
		{"delas", "del"},
		{"delat", "del"},
		{"delen", "del"},
		{"delicti", "delicti"},
		{"delikat", "delik"},
		{"delikata", "delikat"},
		{"delikataste", "delikat"},
		{"delila", "delil"},
		{"delma", "delm"},
		{"delos", "delo"},
		{"dels", "del"},
		{"delsen", "dels"},
		{"deltaga", "deltag"},
		{"deltagande", "deltag"},
		{"deltagandet", "deltag"},
		{"deltagaren", "deltag"},
		{"deltagit", "deltagit"},
		{"delvis", "delvis"},
		{"dem", "dem"},
		{"demagogen", "demagog"},
		{"demla", "deml"},
		{"demma", "demm"},
		{"demokratisk", "demokratisk"},
		{"demonen", "demon"},
		{"demonisk", "demonisk"},
		{"demoniskt", "demonisk"},
		{"demonstration", "demonstration"},
		{"demostenes", "demosten"},
		{"demutan", "demutan"},
		{"den", "den"},
		{"dena", "den"},
		{"deneb", "deneb"},
		{"denna", "denn"},
		{"dennas", "denn"},
		{"denne", "denn"},
		{"dennes", "denn"},
		{"dens", "den"},
		{"densamma", "densamm"},
		{"densamme", "densamm"},
		{"denscöconens", "denscöcon"},
		{"departemanget", "departemanget"},
		{"departement", "departement"},
		{"deporterad", "deporter"},
		{"der", "der"},
		{"derade", "der"},
		{"deraf", "deraf"},
		{"deras", "der"},
		{"derefter", "dereft"},
		{"deremot", "deremot"},
		{"derest", "derest"},
		{"derför", "derför"},
		{"derföre", "derför"},
		{"derhän", "derhän"},
		{"deri", "deri"},
		{"derifrån", "derifrån"},
		{"derigenom", "derigenom"},
		{"derinne", "derin"},
		{"derjemte", "derjemt"},
		{"dermed", "dermed"},
		{"dermont", "dermont"},
		{"derna", "dern"},
		{"derom", "derom"},
		{"deromkring", "deromkring"},
		{"derpå", "derpå"},
		{"derstädes", "derstäd"},
		{"dertill", "dertill"},
		{"derunder", "derund"},
		{"deruppe", "derupp"},
		{"deruti", "deruti"},
		{"dervid", "dervid"},
		{"deråt", "deråt"},
		{"deröfver", "deröfv"},
		{"des", "des"},
		{"desamma", "desamm"},
		{"desorganisation", "desorganisation"},
		{"desperat", "desper"},
		{"dess", "dess"},
		{"dessa", "dess"},
		{"dessemellan", "dessemellan"},
		{"desserten", "dessert"},
		{"dessförinnan", "dessförinnan"},
		{"desslikes", "desslik"},
		{"dessouernas", "dessou"},
		{"dessutom", "dessutom"},
		{"desto", "desto"},
		{"det", "det"},
		{"detalj", "detalj"},
		{"detaljer", "detalj"},
		{"detaljkunskaper", "detaljkunskap"},
		{"detektiv", "detektiv"},
		{"deth", "deth"},
		{"detsamma", "detsamm"},
		{"detta", "dett"},
		{"deva", "dev"},
		{"devient", "devient"},
		{"di", "di"},
		{"dia", "dia"},
		{"diagnosen", "diagnos"},
		{"dianatemplet", "dianatemplet"},
		{"diciplars", "diciplar"},
		{"dier", "dier"},
		{"diet", "diet"},
		{"dieten", "diet"},
		{"dietrich", "dietrich"},
		{"dig", "dig"},
		{"diger", "dig"},
		{"dighet", "dig"},
		{"digheter", "dig"},
		{"digitalis", "digitalis"},
		{"digl", "digl"},
		{"dignade", "dign"},
		{"dignande", "dign"},
		{"digt", "digt"},
		{"dikanten", "dikant"},
		{"diken", "dik"},
		{"dikens", "dik"},
		{"diket", "diket"},
		{"dikt", "dikt"},
		{"diktare", "dikt"},
		{"diktarefeber", "diktarefeb"},
		{"diktarna", "dikt"},
		{"diktat", "dikt"},
		{"dikten", "dikt"},
		{"diktens", "dikt"},
		{"dikter", "dikt"},
		{"dikterad", "dikter"},
		{"dikterat", "dikter"},
		{"dikterna", "dikt"},
		{"diktionären", "diktionär"},
		{"dim", "dim"},
		{"dimensioner", "dimension"},
		{"dimma", "dimm"},
		{"dimman", "dimman"},
		{"dimmig", "dimm"},
		{"dimmor", "dimm"},
		{"dimmorna", "dimm"},
		{"din", "din"},
		{"dina", "din"},
		{"dingla", "dingl"},
		{"dinglade", "dingl"},
		{"dinglande", "dingl"},
		{"dinglar", "dingl"},
		{"diplomat", "diplom"},
		{"direkt", "direk"},
		{"direkta", "direk"},
		{"direktör", "direktör"},
		{"direktören", "direktör"},
		{"direktörn", "direktörn"},
		{"discipel", "discipel"},
		{"disciplinen", "disciplin"},
		{"disigt", "dis"},
		{"disk", "disk"},
		{"diska", "disk"},
		{"diskant", "diskant"},
		{"disken", "disk"},
		{"diskret", "diskret"},
		{"diskreta", "diskret"},
		{"diskussion", "diskussion"},
		{"diskutera", "diskuter"},
		{"diskuterade", "diskuter"},
		{"dispens", "disp"},
		{"disponera", "disponer"},
		{"disposition", "disposition"},
		{"disputera", "disputer"},
		{"distansen", "distans"},
		{"distrahera", "distraher"},
		{"distriktet", "distriktet"},
		{"dit", "dit"},
		{"ditin", "ditin"},
		{"ditlades", "ditl"},
		{"ditlocka", "ditlock"},
		{"dito", "dito"},
		{"ditresan", "ditresan"},
		{"ditsatte", "ditsat"},
		{"ditt", "ditt"},
		{"ditåt", "ditåt"},
		{"diurä", "diurä"},
		{"divansbordet", "divansbordet"},
		{"divergensen", "divergens"},
		{"diverse", "divers"},
		{"division", "division"},
		{"dj", "dj"},
		{"djerf", "djerf"},
		{"djerfhet", "djerf"},
		{"djerft", "djerft"},
		{"djerfva", "djerfv"},
		{"djerfve", "djerfv"},
		{"djungel", "djungel"},
		{"djup", "djup"},
		{"djupa", "djup"},
		{"djupare", "djup"},
		{"djupast", "djup"},
		{"djupaste", "djup"},
		{"djupblå", "djupblå"},
		{"djupet", "djupet"},
		{"djupsinnigaste", "djupsinn"},
		{"djupsinnighet", "djupsinn"},
		{"djupsinnigt", "djupsinn"},
		{"djupt", "djupt"},
		{"djur", "djur"},
		{"djuransiktet", "djuransiktet"},
		{"djurbilder", "djurbild"},
		{"djuren", "djur"},
		{"djuret", "djuret"},
		{"djurets", "djuret"},
		{"djurgård", "djurgård"},
		{"djurgården", "djurgård"},
		{"djurgårds", "djurgård"},
		{"djurgårdsbrunn", "djurgårdsbrun"},
		{"djurgårdsspektaklet", "djurgårdsspektaklet"},
		{"djuriskt", "djurisk"},
		{"djurs", "djur"},
		{"djä", "djä"},
		{"djärv", "djärv"},
		{"djärva", "djärv"},
		{"djärvare", "djärv"},
		{"djärvhet", "djärv"},
		{"djärvt", "djärvt"},
		{"djävlar", "djävl"},
		{"djävlarna", "djävl"},
		{"djävulen", "djävul"},
		{"djävuln", "djävuln"},
		{"djävulskvinna", "djävulskvin"},
		{"dli", "dli"},
		{"dll", "dll"},
		{"dln", "dln"},
		{"dlodet", "dlodet"},
		{"docent", "docent"},
		{"dock", "dock"},
		{"docka", "dock"},
		{"dockan", "dockan"},
		{"dockklädningen", "dockklädning"},
		{"dockor", "dock"},
		{"dockorna", "dock"},
		{"dod", "dod"},
		{"doden", "dod"},
		{"dof", "dof"},
		{"doft", "doft"},
		{"dofta", "doft"},
		{"doftade", "doft"},
		{"doftande", "doft"},
		{"doftar", "doft"},
		{"doften", "doft"},
		{"dofters", "dofter"},
		{"doftsjäl", "doftsjäl"},
		{"dofva", "dofv"},
		{"dog", "dog"},
		{"doge", "dog"},
		{"dogg", "dogg"},
		{"dogo", "dogo"},
		{"dok", "dok"},
		{"doktor", "dokt"},
		{"doktorinnan", "doktorinnan"},
		{"doktorn", "doktorn"},
		{"doktorns", "doktorn"},
		{"doktorsdisputation", "doktorsdisputation"},
		{"dokument", "dokument"},
		{"dokumenterat", "dokumenter"},
		{"dokumentet", "dokumentet"},
		{"dold", "dold"},
		{"dolda", "dold"},
		{"dolde", "dold"},
		{"doldes", "dold"},
		{"doljas", "dolj"},
		{"doljer", "dolj"},
		{"doljs", "dolj"},
		{"dolt", "dolt"},
		{"dolts", "dolt"},
		{"dom", "dom"},
		{"domar", "dom"},
		{"domare", "dom"},
		{"domaren", "dom"},
		{"domareuppsyn", "domareuppsyn"},
		{"domarevärdigheten", "domarevärd"},
		{"domarinnan", "domarinnan"},
		{"domcn", "domcn"},
		{"domderade", "domder"},
		{"domedag", "domedag"},
		{"domen", "dom"},
		{"domer", "dom"},
		{"domfällande", "domfäll"},
		{"domkyrka", "domkyrk"},
		{"domkyrkans", "domkyrkan"},
		{"domna", "domn"},
		{"domnad", "domn"},
		{"domnade", "domn"},
		{"domning", "domning"},
		{"domprostgården", "domprostgård"},
		{"doms", "dom"},
		{"domsaga", "domsag"},
		{"domsagan", "domsagan"},
		{"domsagor", "domsag"},
		{"don", "don"},
		{"dopattest", "dopattest"},
		{"dopet", "dopet"},
		{"dopp", "dopp"},
		{"doppa", "dopp"},
		{"doppade", "dopp"},
		{"doppar", "dopp"},
		{"dora", "dor"},
		{"doras", "dor"},
		{"dork", "dork"},
		{"dorr", "dorr"},
		{"dorren", "dorr"},
		{"dosa", "dos"},
		{"dosan", "dosan"},
		{"dosis", "dosis"},
		{"dott", "dott"},
		{"dotter", "dott"},
		{"dotterlig", "dotter"},
		{"dottern", "dott"},
		{"dotterns", "dott"},
		{"dotters", "dotter"},
		{"dov", "dov"},
		{"dova", "dov"},
		{"dovt", "dovt"},
		{"dr", "dr"},
		{"dra", "dra"},
		{"drabant", "drabant"},
		{"drabbningar", "drabbning"},
		{"drack", "drack"},
		{"drag", "drag"},
		{"draga", "drag"},
		{"dragande", "drag"},
		{"dragas", "drag"},
		{"dragen", "drag"},
		{"drager", "drag"},
		{"draget", "draget"},
		{"dragg", "dragg"},
		{"draggen", "dragg"},
		{"dragit", "dragit"},
		{"dragits", "dragit"},
		{"dragkista", "dragkist"},
		{"dragkistan", "dragkistan"},
		{"dragna", "dragn"},
		{"dragning", "dragning"},
		{"dragonerna", "dragon"},
		{"dragshållaren", "dragshåll"},
		{"dragspel", "dragspel"},
		{"drakar", "drak"},
		{"draken", "drak"},
		{"drakens", "drak"},
		{"dramatiska", "dramatisk"},
		{"draperad", "draper"},
		{"draperade", "draper"},
		{"draperande", "draper"},
		{"draperi", "draperi"},
		{"draperier", "draperi"},
		{"draperiet", "draperiet"},
		{"draperingen", "drapering"},
		{"drar", "drar"},
		{"dras", "dras"},
		{"dref", "dref"},
		{"dreg", "dreg"},
		{"dreglande", "dregl"},
		{"dresserad", "dresser"},
		{"drev", "drev"},
		{"dreve", "drev"},
		{"drevkarlar", "drevkarl"},
		{"drevo", "drevo"},
		{"drevs", "drev"},
		{"dreyfus", "dreyfus"},
		{"dreyfusaffären", "dreyfusaffär"},
		{"dreyfusard", "dreyfusard"},
		{"drick", "drick"},
		{"dricka", "drick"},
		{"drickaren", "drick"},
		{"dricker", "drick"},
		{"drickspengar", "drickspeng"},
		{"drickspengarne", "drickspeng"},
		{"drift", "drift"},
		{"driftens", "drift"},
		{"drifter", "drift"},
		{"driftiga", "drift"},
		{"driftige", "drift"},
		{"driftliv", "driftliv"},
		{"drifva", "drifv"},
		{"drifver", "drifv"},
		{"drifvit", "drifvit"},
		{"drifvor", "drifv"},
		{"drill", "drill"},
		{"drillade", "drill"},
		{"drillar", "drill"},
		{"drillat", "drill"},
		{"drillen", "drill"},
		{"dris", "dris"},
		{"dristade", "drist"},
		{"dristar", "drist"},
		{"dristighet", "drist"},
		{"dristigt", "drist"},
		{"driva", "driv"},
		{"drivande", "driv"},
		{"drivans", "drivan"},
		{"driven", "driv"},
		{"driver", "driv"},
		{"drivfjädrar", "drivfjädr"},
		{"drivit", "drivit"},
		{"drivits", "drivit"},
		{"drivna", "drivn"},
		{"drivor", "driv"},
		{"drivorna", "driv"},
		{"drog", "drog"},
		{"drogo", "drogo"},
		{"drogos", "drogo"},
		{"drogs", "drog"},
		{"dropp", "dropp"},
		{"droppa", "dropp"},
		{"droppade", "dropp"},
		{"droppar", "dropp"},
		{"droppe", "dropp"},
		{"droppen", "dropp"},
		{"droska", "drosk"},
		{"droskbil", "droskbil"},
		{"droskkusk", "droskkusk"},
		{"droskkuskarna", "droskkusk"},
		{"droskorna", "drosk"},
		{"drosksläde", "drosksläd"},
		{"drottning", "drottning"},
		{"drottningbenådade", "drottningbenåd"},
		{"drottningen", "drottning"},
		{"drottninggatan", "drottninggatan"},
		{"drucken", "druck"},
		{"druckit", "druckit"},
		{"druckna", "druckn"},
		{"drucko", "drucko"},
		{"drufvans", "drufvan"},
		{"drummel", "drummel"},
		{"drummeln", "drummeln"},
		{"drunkna", "drunkn"},
		{"drunknad", "drunkn"},
		{"drunknade", "drunkn"},
		{"drunknar", "drunkn"},
		{"drunknat", "drunkn"},
		{"drunkningsdöden", "drunkningsdöd"},
		{"drupit", "drupit"},
		{"druvans", "druvan"},
		{"druvor", "druv"},
		{"druvors", "druvor"},
		{"dry", "dry"},
		{"dryaden", "dryad"},
		{"dryck", "dryck"},
		{"drycken", "dryck"},
		{"drycker", "dryck"},
		{"dryftade", "dryft"},
		{"dryga", "dryg"},
		{"drygt", "drygt"},
		{"drypa", "dryp"},
		{"drypande", "dryp"},
		{"dryper", "dryp"},
		{"drägg", "drägg"},
		{"dräkt", "dräkt"},
		{"dräkten", "dräkt"},
		{"dräll", "dräll"},
		{"drällen", "dräll"},
		{"dräng", "dräng"},
		{"drängar", "dräng"},
		{"drängarna", "dräng"},
		{"drängen", "dräng"},
		{"drängnävar", "drängnäv"},
		{"dränka", "dränk"},
		{"dränker", "dränk"},
		{"dräpa", "dräp"},
		{"dräpt", "dräpt"},
		{"dråplig", "dråp"},
		{"dråpliga", "dråp"},
		{"dröja", "dröj"},
		{"dröjande", "dröj"},
		{"dröjde", "dröjd"},
		{"dröjer", "dröj"},
		{"dröjsmål", "dröjsmål"},
		{"dröjt", "dröjt"},
		{"dröm", "dröm"},
		{"drömde", "drömd"},
		{"drömlikt", "drömlik"},
		{"drömma", "drömm"},
		{"drömmande", "drömm"},
		{"drömmar", "drömm"},
		{"drömmare", "drömm"},
		{"drömmarna", "drömm"},
		{"drömmarnas", "drömm"},
		{"drömmars", "drömmar"},
		{"drömmen", "drömm"},
		{"drömmens", "drömm"},
		{"drömmer", "drömm"},
		{"drömt", "drömt"},
		{"drömvärld", "drömvärld"},
		{"dröp", "dröp"},
		{"drövade", "dröv"},
		{"du", "du"},
		{"duat", "duat"},
		{"dubbeldröm", "dubbeldröm"},
		{"dubbelfönstren", "dubbelfönstr"},
		{"dubbelgångare", "dubbelgång"},
		{"dubbelhet", "dubbel"},
		{"dubbelliv", "dubbelliv"},
		{"dubbellorgnett", "dubbellorgnet"},
		{"dubbelroller", "dubbelroll"},
		{"dubbelt", "dubbelt"},
		{"dubbla", "dubbl"},
		{"dufvan", "dufvan"},
		{"duga", "dug"},
		{"dugande", "dug"},
		{"dugde", "dugd"},
		{"duger", "dug"},
		{"duggregn", "duggregn"},
		{"duggregna", "duggregn"},
		{"duggregnet", "duggregnet"},
		{"dugligheten", "dug"},
		{"dugtig", "dugt"},
		{"dugtigt", "dugt"},
		{"duk", "duk"},
		{"duka", "duk"},
		{"dukade", "duk"},
		{"dukades", "duk"},
		{"dukadt", "dukad"},
		{"dukar", "duk"},
		{"dukas", "duk"},
		{"dukat", "duk"},
		{"duken", "duk"},
		{"dukning", "dukning"},
		{"duktig", "dukt"},
		{"duktiga", "dukt"},
		{"duktigare", "dukt"},
		{"duktigt", "dukt"},
		{"dum", "dum"},
		{"dumhet", "dum"},
		{"dumheter", "dum"},
		{"dumma", "dumm"},
		{"dummare", "dumm"},
		{"dummaste", "dumm"},
		{"dumme", "dumm"},
		{"dumt", "dumt"},
		{"dun", "dun"},
		{"dundrade", "dundr"},
		{"dundrar", "dundr"},
		{"dundrat", "dundr"},
		{"duniga", "dun"},
		{"dunigt", "dun"},
		{"dunk", "dunk"},
		{"dunka", "dunk"},
		{"dunkadc", "dunkadc"},
		{"dunkade", "dunk"},
		{"dunkande", "dunk"},
		{"dunkar", "dunk"},
		{"dunkel", "dunkel"},
		{"dunkelt", "dunkelt"},
		{"dunkla", "dunkl"},
		{"dunklar", "dunkl"},
		{"dunklare", "dunkl"},
		{"dunklet", "dunklet"},
		{"duns", "dun"},
		{"dunsar", "duns"},
		{"dunst", "dunst"},
		{"dunstade", "dunst"},
		{"dunstat", "dunst"},
		{"dunster", "dunst"},
		{"dunstkretsen", "dunstkrets"},
		{"dur", "dur"},
		{"durk", "durk"},
		{"dus", "dus"},
		{"duschbad", "duschb"},
		{"dussin", "dussin"},
		{"dusör", "dusör"},
		{"duva", "duv"},
		{"duvan", "duvan"},
		{"duvas", "duv"},
		{"duvor", "duv"},
		{"duvoröst", "duvoröst"},
		{"duvovingar", "duvoving"},
		{"duvoögon", "duvoögon"},
		{"duvunge", "duvung"},
		{"duvögon", "duvögon"},
		{"dvala", "dval"},
		{"dvaldes", "dvald"},
		{"dväljas", "dvälj"},
		{"dvärg", "dvärg"},
		{"dvärgman", "dvärgman"},
		{"dy", "dy"},
		{"dygd", "dygd"},
		{"dygde", "dygd"},
		{"dygden", "dygd"},
		{"dygdig", "dygd"},
		{"dygdige", "dygd"},
		{"dygdigt", "dygd"},
		{"dygn", "dygn"},
		{"dygnet", "dygnet"},
		{"dyka", "dyk"},
		{"dyker", "dyk"},
		{"dykt", "dykt"},
		{"dylik", "dylik"},
		{"dylika", "dylik"},
		{"dylikt", "dylik"},
		{"dyn", "dyn"},
		{"dyna", "dyn"},
		{"dyning", "dyning"},
		{"dyningar", "dyning"},
		{"dyningarna", "dyning"},
		{"dynorna", "dyn"},
		{"dyr", "dyr"},
		{"dyra", "dyr"},
		{"dyrare", "dyr"},
		{"dyraste", "dyr"},
		{"dyrbar", "dyrb"},
		{"dyrbara", "dyrbar"},
		{"dyrbarare", "dyrbar"},
		{"dyrbaraste", "dyrbar"},
		{"dyrbarheter", "dyrbar"},
		{"dyre", "dyr"},
		{"dyrhet", "dyr"},
		{"dyrka", "dyrk"},
		{"dyrkade", "dyrk"},
		{"dyrkan", "dyrkan"},
		{"dyrköpt", "dyrköpt"},
		{"dyrköpta", "dyrköpt"},
		{"dyrt", "dyrt"},
		{"dyst", "dyst"},
		{"dyster", "dyst"},
		{"dysterhet", "dyster"},
		{"dystert", "dystert"},
		{"dystra", "dystr"},
		{"dystre", "dystr"},
		{"dä", "dä"},
		{"däck", "däck"},
		{"däcken", "däck"},
		{"däcket", "däcket"},
		{"däcksbåten", "däcksbåt"},
		{"däckslasten", "däckslast"},
		{"dädan", "dädan"},
		{"dägga", "dägg"},
		{"däl", "däl"},
		{"dämpad", "dämp"},
		{"dämpade", "dämp"},
		{"dämpades", "dämp"},
		{"dämpande", "dämp"},
		{"dämpat", "dämp"},
		{"dämt", "dämt"},
		{"dän", "dän"},
		{"dängde", "däng"},
		{"där", "där"},
		{"därat", "där"},
		{"därav", "därav"},
		{"därbakom", "därbakom"},
		{"därborta", "därbort"},
		{"därefter", "däreft"},
		{"däremot", "däremot"},
		{"därest", "därest"},
		{"därfor", "därf"},
		{"därför", "därför"},
		{"därföre", "därför"},
		{"därhemma", "därhemm"},
		{"därhos", "därho"},
		{"därhän", "därhän"},
		{"däri", "däri"},
		{"därifrall", "därifrall"},
		{"därifran", "därifran"},
		{"därifrån", "därifrån"},
		{"därigenom", "därigenom"},
		{"därigenorm", "därigenorm"},
		{"därinifrån", "därinifrån"},
		{"därinnanför", "därinnanför"},
		{"därinne", "därin"},
		{"därintill", "därintill"},
		{"därinunder", "därinund"},
		{"därjämte", "därjämt"},
		{"därmed", "därmed"},
		{"därnedan", "därnedan"},
		{"därnedanför", "därnedanför"},
		{"därnere", "därner"},
		{"därnäst", "därnäst"},
		{"därom", "därom"},
		{"därpa", "därp"},
		{"därpå", "därpå"},
		{"därstädes", "därstäd"},
		{"därtill", "därtill"},
		{"därunder", "därund"},
		{"däruppe", "därupp"},
		{"därur", "därur"},
		{"därute", "därut"},
		{"däruti", "däruti"},
		{"därutur", "därutur"},
		{"därutöver", "därutöv"},
		{"därvid", "därvid"},
		{"däråt", "däråt"},
		{"däröver", "däröv"},
		{"då", "då"},
		{"dågot", "dågot"},
		{"dålig", "dål"},
		{"dåliga", "dål"},
		{"dåligare", "dål"},
		{"dålighet", "dål"},
		{"dåligt", "dål"},
		{"dån", "dån"},
		{"dånade", "dån"},
		{"dånande", "dån"},
		{"dånar", "dån"},
		{"dånat", "dån"},
		{"dånet", "dånet"},
		{"dåningen", "dåning"},
		{"dår", "dår"},
		{"dåra", "dår"},
		{"dåraktiga", "dårakt"},
		{"dåraktigt", "dårakt"},
		{"dårande", "dår"},
		{"dårars", "dårar"},
		{"dårat", "dår"},
		{"dåre", "dår"},
		{"dåren", "dår"},
		{"dårhus", "dårhus"},
		{"dårhusen", "dårhus"},
		{"dårhuside", "dårhusid"},
		{"dårskap", "dårskap"},
		{"dårskapen", "dårskap"},
		{"dåsa", "dås"},
		{"dåsigt", "dås"},
		{"dö", "dö"},
		{"död", "död"},
		{"döda", "död"},
		{"dödade", "död"},
		{"dödande", "död"},
		{"dödar", "död"},
		{"dödas", "död"},
		{"dödat", "död"},
		{"dödbenskult", "dödbenskult"},
		{"döddagar", "döddag"},
		{"döde", "död"},
		{"döden", "död"},
		{"dödens", "död"},
		{"dödfött", "dödföt"},
		{"dödlig", "död"},
		{"dödliga", "död"},
		{"dödligt", "död"},
		{"döds", "död"},
		{"dödsattesten", "dödsattest"},
		{"dödsbädd", "dödsbäd"},
		{"dödsdag", "dödsdag"},
		{"dödsdömd", "dödsdömd"},
		{"dödsdömde", "dödsdömd"},
		{"dödsfall", "dödsfall"},
		{"dödsfallet", "dödsfallet"},
		{"dödsfiende", "dödsfiend"},
		{"dödskonvulsionerna", "dödskonvulsion"},
		{"dödsmärket", "dödsmärket"},
		{"dödsmörkret", "dödsmörkret"},
		{"dödsorsaken", "dödsorsak"},
		{"dödsskräcken", "dödsskräck"},
		{"dödsskrämda", "dödsskrämd"},
		{"dödsskuegornas", "dödsskueg"},
		{"dödsskuggor", "dödsskugg"},
		{"dödsstraff", "dödsstraff"},
		{"dödsstund", "dödsstund"},
		{"dödssuck", "dödssuck"},
		{"dödssuckar", "dödssuck"},
		{"dödssynd", "dödssynd"},
		{"dödssynderna", "dödssynd"},
		{"dödssäng", "dödssäng"},
		{"dödstyst", "dödstyst"},
		{"dödsångesten", "dödsångest"},
		{"döende", "döend"},
		{"döf", "döf"},
		{"döfstum", "döfstum"},
		{"döfva", "döfv"},
		{"dök", "dök"},
		{"döko", "döko"},
		{"dölja", "dölj"},
		{"döljande", "dölj"},
		{"döljer", "dölj"},
		{"döm", "döm"},
		{"döma", "döm"},
		{"dömd", "dömd"},
		{"dömda", "dömd"},
		{"dömde", "dömd"},
		{"döme", "döm"},
		{"dömer", "döm"},
		{"dömt", "dömt"},
		{"dön", "dön"},
		{"döpt", "döpt"},
		{"dör", "dör"},
		{"döra", "dör"},
		{"dörr", "dörr"},
		{"dörrar", "dörr"},
		{"dörrarna", "dörr"},
		{"dörrcn", "dörrcn"},
		{"dörrell", "dörrell"},
		{"dörren", "dörr"},
		{"dörrlaset", "dörrlaset"},
		{"dörrskyltarna", "dörrskylt"},
		{"dörrspringa", "dörrspring"},
		{"dörrvredet", "dörrvredet"},
		{"dött", "dött"},
		{"döttrar", "döttr"},
		{"döttrarna", "döttr"},
		{"döv", "döv"},
		{"döva", "döv"},
		{"dövad", "döv"},
		{"dövades", "döv"},
		{"e", "e"},
		{"ea", "ea"},
		{"eau", "eau"},
		{"ebbar", "ebb"},
		{"ecklesiastikminister", "ecklesiastikminist"},
		{"ed", "ed"},
		{"eden", "eden"},
		{"eder", "eder"},
		{"edla", "edl"},
		{"edligt", "edl"},
		{"edra", "edr"},
		{"edward", "edward"},
		{"efesus", "efesus"},
		{"effekt", "effek"},
		{"effter", "efft"},
		{"eftcr", "eftcr"},
		{"eftel", "eftel"},
		{"efter", "eft"},
		{"efterapande", "efterap"},
		{"efterbildningen", "efterbildning"},
		{"efterfikar", "efterfik"},
		{"efterfråga", "efterfråg"},
		{"efterfrågade", "efterfråg"},
		{"efterföljd", "efterföljd"},
		{"eftergift", "eftergift"},
		{"eftergifvande", "eftergifv"},
		{"eftergifven", "eftergifv"},
		{"eftergivande", "eftergiv"},
		{"efterhängsenhet", "efterhängsen"},
		{"efterhärma", "efterhärm"},
		{"efterhärmade", "efterhärm"},
		{"efterhållen", "efterhåll"},
		{"efterhörde", "efterhörd"},
		{"efterkomma", "efterkomm"},
		{"efterlemnade", "efterlemn"},
		{"efterlämnade", "efterlämn"},
		{"efterlämnar", "efterlämn"},
		{"efterlämnat", "efterlämn"},
		{"efterlängtad", "efterläng"},
		{"efterlängtade", "efterläng"},
		{"efterlängtar", "efterläng"},
		{"efterlängtat", "efterläng"},
		{"eftermiddag", "eftermiddag"},
		{"eftermiddagarna", "eftermiddag"},
		{"eftermiddagarne", "eftermiddag"},
		{"eftermiddagen", "eftermiddag"},
		{"eftermiddags", "eftermiddag"},
		{"eftermiddagssolen", "eftermiddagssol"},
		{"eftermiddagsvakten", "eftermiddagsvak"},
		{"efternamnet", "efternamnet"},
		{"efterräknade", "efterräkn"},
		{"efterrättelse", "efterrätt"},
		{"efterrätten", "efterrät"},
		{"efterrätter", "efterrät"},
		{"eftersade", "efters"},
		{"efterse", "efters"},
		{"eftersinna", "eftersin"},
		{"eftersinnande", "eftersin"},
		{"eftersom", "eftersom"},
		{"efterspaningar", "efterspaning"},
		{"efterspel", "efterspel"},
		{"efterst", "efterst"},
		{"eftersträfva", "eftersträfv"},
		{"eftersträfvar", "eftersträfv"},
		{"eftersträva", "eftersträv"},
		{"eftersträvade", "eftersträv"},
		{"eftersträvansvärt", "eftersträvansvärt"},
		{"efterstygn", "efterstygn"},
		{"eftersyn", "eftersyn"},
		{"eftersökt", "eftersök"},
		{"eftersökta", "eftersök"},
		{"eftertanke", "eftertank"},
		{"eftertruppen", "eftertrupp"},
		{"eftertryck", "eftertryck"},
		{"eftertryckligt", "eftertryck"},
		{"eftertrycks", "eftertryck"},
		{"efterträdare", "efterträd"},
		{"efterträderska", "efterträdersk"},
		{"efterträtts", "efterträt"},
		{"eftervärkarna", "eftervärk"},
		{"efteråt", "efteråt"},
		{"ega", "ega"},
		{"eganderätt", "eganderät"},
		{"egarinnan", "egarinnan"},
		{"egde", "egd"},
		{"ege", "ege"},
		{"egen", "egen"},
		{"egenart", "egenart"},
		{"egendom", "egendom"},
		{"egendomen", "egendom"},
		{"egendomlig", "egendom"},
		{"egendomliga", "egendom"},
		{"egendomligt", "egendom"},
		{"egenhet", "egen"},
		{"egenheter", "egen"},
		{"egenhändiga", "egenhänd"},
		{"egenkär", "egenkär"},
		{"egenkärlek", "egenkärlek"},
		{"egenkärleken", "egenkärlek"},
		{"egenkärt", "egenkärt"},
		{"egenmäk", "egenmäk"},
		{"egennytta", "egennyt"},
		{"egennyttig", "egennytt"},
		{"egennyttiga", "egennytt"},
		{"egensinnig", "egensinn"},
		{"egensinnigt", "egensinn"},
		{"egenskap", "egenskap"},
		{"egenskapen", "egenskap"},
		{"egenskaper", "egenskap"},
		{"egenskaperna", "egenskap"},
		{"egentlig", "egent"},
		{"egentliga", "egent"},
		{"egentligaste", "egent"},
		{"egentligen", "egent"},
		{"egentligt", "egent"},
		{"eger", "eger"},
		{"eget", "eget"},
		{"egg", "egg"},
		{"egga", "egg"},
		{"eggade", "egg"},
		{"eggar", "egg"},
		{"eggas", "egg"},
		{"eggat", "egg"},
		{"egna", "egn"},
		{"egnade", "egn"},
		{"egnades", "egn"},
		{"egnadt", "egnad"},
		{"egnar", "egn"},
		{"egoism", "egoism"},
		{"egoist", "egoist"},
		{"egoisten", "egoist"},
		{"egoistiska", "egoistisk"},
		{"egoistiskt", "egoistisk"},
		{"egt", "egt"},
		{"egypterna", "egypt"},
		{"egypti", "egypti"},
		{"ehrencreutz", "ehrencreutz"},
		{"ehuru", "ehuru"},
		{"eian", "eian"},
		{"eians", "eian"},
		{"eiffeltornet", "eiffeltornet"},
		{"eine", "ein"},
		{"ej", "ej"},
		{"ejugu", "ejugu"},
		{"ek", "ek"},
		{"eka", "eka"},
		{"ekade", "ekad"},
		{"ekar", "ekar"},
		{"ekas", "ekas"},
		{"ekbord", "ekbord"},
		{"ekered", "ekered"},
		{"ekhult", "ekhult"},
		{"ekhults", "ekhult"},
		{"ekipaget", "ekipaget"},
		{"eklatant", "eklatant"},
		{"eklund", "eklund"},
		{"eklunds", "eklund"},
		{"eklärerat", "eklärer"},
		{"eklöv", "eklöv"},
		{"eko", "eko"},
		{"ekonomien", "ekonomi"},
		{"ekonomiskt", "ekonomisk"},
		{"ekorre", "ekorr"},
		{"ekorren", "ekorr"},
		{"ekotemplet", "ekotemplet"},
		{"eksem", "eksem"},
		{"el", "el"},
		{"elak", "elak"},
		{"elaka", "elak"},
		{"elakare", "elak"},
		{"elakaste", "elak"},
		{"elakhet", "elak"},
		{"elakheter", "elak"},
		{"elakt", "elak"},
		{"elan", "elan"},
		{"eld", "eld"},
		{"elda", "eld"},
		{"eldade", "eld"},
		{"eldar", "eld"},
		{"eldat", "eld"},
		{"eldbrasa", "eldbras"},
		{"elddonen", "elddon"},
		{"elden", "eld"},
		{"eldens", "eld"},
		{"eldgnistor", "eldgnist"},
		{"eldig", "eld"},
		{"eldiga", "eld"},
		{"eldorado", "eldorado"},
		{"eldrod", "eldrod"},
		{"eldros", "eldro"},
		{"eldrosen", "eldros"},
		{"eldröd", "eldröd"},
		{"eldrött", "eldröt"},
		{"eldsken", "eldsk"},
		{"eldskenets", "eldskenet"},
		{"eldstrimma", "eldstrimm"},
		{"eldsvåda", "eldsvåd"},
		{"eldtunga", "eldtung"},
		{"elefant", "elefant"},
		{"eleg", "eleg"},
		{"elegans", "elegan"},
		{"elegant", "elegant"},
		{"eleganta", "elegant"},
		{"eleganten", "elegant"},
		{"eleganter", "elegant"},
		{"elektrisk", "elektrisk"},
		{"elektriska", "elektrisk"},
		{"elektriskt", "elektrisk"},
		{"elektroniska", "elektronisk"},
		{"element", "element"},
		{"elementarkraft", "elementarkraft"},
		{"elementen", "element"},
		{"elementet", "elementet"},
		{"eletty", "eletty"},
		{"elev", "elev"},
		{"eleven", "elev"},
		{"elever", "elev"},
		{"eleverna", "elev"},
		{"elevernas", "elev"},
		{"elfenben", "elfenb"},
		{"elfenbensfärgad", "elfenbensfärg"},
		{"elfqvinnan", "elfqvinnan"},
		{"elfte", "elft"},
		{"elfva", "elfv"},
		{"elfvorna", "elfv"},
		{"eljes", "elj"},
		{"eljest", "eljest"},
		{"ell", "ell"},
		{"ella", "ell"},
		{"ellas", "ell"},
		{"ellen", "ell"},
		{"eller", "ell"},
		{"elon", "elon"},
		{"elsa", "els"},
		{"elva", "elv"},
		{"elände", "eländ"},
		{"eländig", "eländ"},
		{"eländiga", "eländ"},
		{"eländigaste", "eländ"},
		{"eländige", "eländ"},
		{"eländighet", "eländ"},
		{"eländigt", "eländ"},
		{"elån", "elån"},
		{"emanerade", "emaner"},
		{"emaus", "emaus"},
		{"emedan", "emedan"},
		{"emellan", "emellan"},
		{"emellanat", "emellan"},
		{"emellanåt", "emellanåt"},
		{"emellertid", "emellertid"},
		{"emma", "emm"},
		{"emot", "emot"},
		{"emottaga", "emottag"},
		{"emottog", "emottog"},
		{"emploient", "emploient"},
		{"en", "en"},
		{"ena", "ena"},
		{"enahanda", "enahand"},
		{"enas", "enas"},
		{"enbart", "enbart"},
		{"enbuske", "enbusk"},
		{"enda", "end"},
		{"endas", "end"},
		{"endast", "end"},
		{"endaste", "end"},
		{"ende", "end"},
		{"endera", "ender"},
		{"endräkt", "endräk"},
		{"ene", "ene"},
		{"ener", "ener"},
		{"energi", "energi"},
		{"energiska", "energisk"},
		{"energiskt", "energisk"},
		{"enes", "enes"},
		{"enfald", "enfald"},
		{"enfalden", "enfald"},
		{"enfaldig", "enfald"},
		{"enfaldiga", "enfald"},
		{"enfaldighet", "enfald"},
		{"enfaldigt", "enfald"},
		{"enformiga", "enform"},
		{"enformighet", "enform"},
		{"enformigheten", "enform"},
		{"enformigt", "enform"},
		{"enfödde", "enföd"},
		{"engblomo", "engblomo"},
		{"engel", "engel"},
		{"engeln", "engeln"},
		{"engelska", "engelsk"},
		{"engelsmännen", "engelsmän"},
		{"england", "england"},
		{"englar", "engl"},
		{"englarne", "engl"},
		{"englarnes", "englarn"},
		{"enhet", "enhet"},
		{"enig", "enig"},
		{"eniga", "enig"},
		{"enighet", "enig"},
		{"enka", "enk"},
		{"enkcl", "enkcl"},
		{"enkefru", "enkefru"},
		{"enkel", "enkel"},
		{"enkelhet", "enkel"},
		{"enkelt", "enkelt"},
		{"enkla", "enkl"},
		{"enklare", "enkl"},
		{"enklaste", "enkl"},
		{"enkom", "enkom"},
		{"enkor", "enk"},
		{"enleveras", "enlever"},
		{"enlevering", "enlevering"},
		{"enligt", "enl"},
		{"enna", "enn"},
		{"ennui", "ennui"},
		{"enompryglas", "enomprygl"},
		{"enorma", "enorm"},
		{"enris", "enris"},
		{"enrum", "enrum"},
		{"ens", "ens"},
		{"ensam", "ensam"},
		{"ensamen", "ensam"},
		{"ensamhet", "ensam"},
		{"ensamheten", "ensam"},
		{"ensamhetens", "ensam"},
		{"ensamma", "ensamm"},
		{"ensammes", "ensamm"},
		{"ensamt", "ensamt"},
		{"ensarnma", "ensarnm"},
		{"ense", "ens"},
		{"ensittarens", "ensit"},
		{"enskilda", "enskild"},
		{"enskildheter", "enskild"},
		{"enskildt", "enskild"},
		{"enskilt", "enskilt"},
		{"enskilta", "enskilt"},
		{"enslig", "ens"},
		{"ensliga", "ens"},
		{"enslighet", "ens"},
		{"ensligt", "ens"},
		{"enslingen", "ensling"},
		{"enstaka", "enstak"},
		{"enstöring", "enstöring"},
		{"entonig", "enton"},
		{"entoniga", "enton"},
		{"entonigt", "enton"},
		{"enträgen", "enträg"},
		{"enträget", "enträget"},
		{"enträgna", "enträgn"},
		{"enträgnaste", "enträgn"},
		{"enträgne", "enträgn"},
		{"envar", "env"},
		{"enveten", "envet"},
		{"envis", "envis"},
		{"envisa", "envis"},
		{"envisas", "envis"},
		{"envise", "envis"},
		{"envishet", "envis"},
		{"envist", "envist"},
		{"envåldshärskarens", "envåldshärsk"},
		{"envånings", "envåning"},
		{"envåningsbyggnaden", "envåningsbyggnad"},
		{"enär", "enär"},
		{"eol", "eol"},
		{"eolin", "eolin"},
		{"eolsharpor", "eolsharp"},
		{"eolus", "eolus"},
		{"epilepsi", "epilepsi"},
		{"epileptisk", "epileptisk"},
		{"episod", "episod"},
		{"episoder", "episod"},
		{"epistlar", "epistl"},
		{"epok", "epok"},
		{"epokgörande", "epokgör"},
		{"epåletter", "epålet"},
		{"er", "er"},
		{"era", "era"},
		{"erbarmligt", "erbarm"},
		{"erbjuda", "erbjud"},
		{"erbjuder", "erbjud"},
		{"erbjudes", "erbjud"},
		{"erbjudna", "erbjudn"},
		{"erbjöd", "erbjöd"},
		{"erbjöds", "erbjöd"},
		{"erda", "erd"},
		{"erfar", "erf"},
		{"erfara", "erfar"},
		{"erfaren", "erf"},
		{"erfarenhet", "erfaren"},
		{"erfarenheten", "erfaren"},
		{"erfarenheter", "erfaren"},
		{"erfares", "erfar"},
		{"erfaret", "erfaret"},
		{"erfarit", "erfarit"},
		{"erfarna", "erf"},
		{"erfarne", "erf"},
		{"erfor", "erf"},
		{"erforderlig", "erforder"},
		{"erforderligt", "erforder"},
		{"erfordra", "erfordr"},
		{"erfordrade", "erfordr"},
		{"erfordrades", "erfordr"},
		{"erfordras", "erfordr"},
		{"erhalla", "erhall"},
		{"erhålla", "erhåll"},
		{"erhållit", "erhållit"},
		{"erhållna", "erhålln"},
		{"erhöll", "erhöll"},
		{"erhölle", "erhöll"},
		{"erhöllo", "erhöllo"},
		{"erhölls", "erhöll"},
		{"erika", "erik"},
		{"erikas", "erik"},
		{"eriksfärd", "eriksfärd"},
		{"eriksgata", "eriksgat"},
		{"erinnyerna", "erinny"},
		{"erinra", "erinr"},
		{"erinrade", "erinr"},
		{"erinrades", "erinr"},
		{"erinran", "erinran"},
		{"erinrande", "erinr"},
		{"erinrar", "erinr"},
		{"erinrat", "erinr"},
		{"erinring", "erinring"},
		{"erinringar", "erinring"},
		{"erinringen", "erinring"},
		{"erkann", "erkan"},
		{"erkänd", "erkänd"},
		{"erkända", "erkänd"},
		{"erkände", "erkänd"},
		{"erkänn", "erkän"},
		{"erkänna", "erkän"},
		{"erkännande", "erkän"},
		{"erkänner", "erkän"},
		{"erkänsla", "erkänsl"},
		{"erkänt", "erkänt"},
		{"erl", "erl"},
		{"erlade", "erl"},
		{"erlagda", "erlag"},
		{"erlägga", "erlägg"},
		{"erna", "ern"},
		{"ernas", "ern"},
		{"ernestina", "ernestin"},
		{"ernst", "ernst"},
		{"ernå", "ernå"},
		{"ernående", "ernåend"},
		{"erotisk", "erotisk"},
		{"erplagg", "erplagg"},
		{"erre", "err"},
		{"ersatt", "ersat"},
		{"ersatta", "ersat"},
		{"ersatte", "ersat"},
		{"ersätta", "ersät"},
		{"ersätter", "ersät"},
		{"ersättning", "ersättning"},
		{"ert", "ert"},
		{"ertappade", "ertapp"},
		{"ertappat", "ertapp"},
		{"eröfra", "eröfr"},
		{"eröfrade", "eröfr"},
		{"erövra", "erövr"},
		{"erövrad", "erövr"},
		{"erövring", "erövring"},
		{"erövringar", "erövring"},
		{"es", "es"},
		{"esoteriska", "esoterisk"},
		{"ess", "ess"},
		{"esse", "ess"},
		{"essingen", "essing"},
		{"est", "est"},
		{"esterhazys", "esterhazy"},
		{"estetikens", "estetik"},
		{"estetiska", "estetisk"},
		{"estimabel", "estimabel"},
		{"estimabelt", "estimabelt"},
		{"estrad", "estr"},
		{"estraden", "estrad"},
		{"et", "et"},
		{"etan", "etan"},
		{"etc", "etc"},
		{"eteriska", "eterisk"},
		{"eterstruten", "eterstrut"},
		{"etiketter", "etiket"},
		{"etiskt", "etisk"},
		{"etra", "etr"},
		{"etras", "etr"},
		{"etsat", "ets"},
		{"ett", "ett"},
		{"etta", "ett"},
		{"etter", "ett"},
		{"etthundra", "etthundr"},
		{"etty", "etty"},
		{"ettårig", "ettår"},
		{"etuin", "etuin"},
		{"eu", "eu"},
		{"euer", "euer"},
		{"eugeniahemmet", "eugeniahemmet"},
		{"europa", "europ"},
		{"ev", "ev"},
		{"eva", "eva"},
		{"evangelist", "evangelist"},
		{"evangeliums", "evangelium"},
		{"evig", "evig"},
		{"eviga", "evig"},
		{"evige", "evig"},
		{"evighet", "evig"},
		{"evigheten", "evig"},
		{"evighetens", "evig"},
		{"evighetssynpunkt", "evighetssynpunk"},
		{"evighetstanke", "evighetstank"},
		{"evigt", "evig"},
		{"evärdeliga", "evärde"},
		{"ex", "ex"},
		{"exalterad", "exalter"},
		{"exalterade", "exalter"},
		{"examen", "exam"},
		{"examineras", "examiner"},
		{"excellensen", "excellens"},
		{"excentriciteter", "excentricitet"},
		{"exekutionen", "exekution"},
		{"exekutiva", "exekutiv"},
		{"exempel", "exempel"},
		{"exemplar", "exempl"},
		{"exemplarisk", "exemplarisk"},
		{"exemplariska", "exemplarisk"},
		{"exemplen", "exempl"},
		{"exemplet", "exemplet"},
		{"exercera", "exercer"},
		{"existera", "exister"},
		{"exlöjtnanten", "exlöjtnant"},
		{"exotisk", "exotisk"},
		{"expedi", "expedi"},
		{"expedierad", "expedier"},
		{"expeditionen", "expedition"},
		{"expeditionerna", "expedition"},
		{"exposition", "exposition"},
		{"expositionen", "exposition"},
		{"extas", "ext"},
		{"extasen", "extas"},
		{"extatiska", "extatisk"},
		{"extra", "extr"},
		{"extraordinarien", "extraordinari"},
		{"extraordinart", "extraordinart"},
		{"extravagant", "extravagant"},
		{"eörstod", "eörstod"},
		{"f", "f"},
		{"fa", "fa"},
		{"fabian", "fabian"},
		{"fabriker", "fabrik"},
		{"fabriksmärke", "fabriksmärk"},
		{"fabriksskorstenarna", "fabriksskorsten"},
		{"fackelfest", "fackelfest"},
		{"facket", "facket"},
		{"fackla", "fackl"},
		{"fackman", "fackman"},
		{"facktermerna", "fackterm"},
		{"facktidskrift", "facktidskrift"},
		{"facktidskrifter", "facktidskrift"},
		{"faddergåfvor", "faddergåfv"},
		{"fader", "fad"},
		{"faderlig", "fader"},
		{"faderliga", "fader"},
		{"faderlösa", "faderlös"},
		{"fadern", "fad"},
		{"faderns", "fad"},
		{"fadersglädje", "fadersglädj"},
		{"fadershemmet", "fadershemmet"},
		{"fadershjärtat", "fadershjärt"},
		{"fadersnamnet", "fadersnamnet"},
		{"fadrens", "fadr"},
		{"faft", "faft"},
		{"fafänga", "fafäng"},
		{"fagel", "fagel"},
		{"fageln", "fageln"},
		{"fager", "fag"},
		{"fagert", "fagert"},
		{"fagra", "fagr"},
		{"fahlen", "fahl"},
		{"fak", "fak"},
		{"fakta", "fakt"},
		{"faktiskt", "faktisk"},
		{"fal", "fal"},
		{"falaskan", "falaskan"},
		{"falköga", "falkög"},
		{"falkögon", "falkögon"},
		{"fall", "fall"},
		{"falla", "fall"},
		{"fallande", "fall"},
		{"fallen", "fall"},
		{"fallenhet", "fallen"},
		{"faller", "fall"},
		{"fallet", "fallet"},
		{"fallfärdigt", "fallfärd"},
		{"fallit", "fallit"},
		{"fallna", "falln"},
		{"fallucka", "falluck"},
		{"falluckan", "falluckan"},
		{"falnade", "faln"},
		{"falsk", "falsk"},
		{"falska", "falsk"},
		{"falskhet", "falsk"},
		{"falskt", "falsk"},
		{"famil", "famil"},
		{"familj", "familj"},
		{"familjcn", "familjcn"},
		{"familjebjudningarna", "familjebjudning"},
		{"familjebänken", "familjebänk"},
		{"familjefar", "familjef"},
		{"familjeförbindelser", "familjeförbind"},
		{"familjeförhållanden", "familjeförhåll"},
		{"familjegraven", "familjegrav"},
		{"familjehändelser", "familjehänd"},
		{"familjelifvet", "familjelifvet"},
		{"familjen", "familj"},
		{"familjens", "familj"},
		{"familjer", "familj"},
		{"familjeträdet", "familjeträdet"},
		{"familjs", "familj"},
		{"familjtafla", "familjtafl"},
		{"faml", "faml"},
		{"famlade", "faml"},
		{"famlande", "faml"},
		{"famlar", "faml"},
		{"famls", "faml"},
		{"famn", "famn"},
		{"famna", "famn"},
		{"famnadcs", "famnadc"},
		{"famnade", "famn"},
		{"famnades", "famn"},
		{"famnar", "famn"},
		{"famnen", "famn"},
		{"famntag", "famntag"},
		{"famntaget", "famntaget"},
		{"famntagets", "famntaget"},
		{"famntags", "famntag"},
		{"fan", "fan"},
		{"fana", "fan"},
		{"fanders", "fander"},
		{"fanga", "fang"},
		{"fangen", "fang"},
		{"fanliljen", "fanlilj"},
		{"fann", "fann"},
		{"fanns", "fann"},
		{"fans", "fan"},
		{"fantasi", "fantasi"},
		{"fantasien", "fantasi"},
		{"fantasiens", "fantasi"},
		{"fantasier", "fantasi"},
		{"fantastisk", "fantastisk"},
		{"fantastiska", "fantastisk"},
		{"fantastiskt", "fantastisk"},
		{"fantiserade", "fantiser"},
		{"fantiserar", "fantiser"},
		{"fantome", "fantom"},
		{"far", "far"},
		{"fara", "far"},
		{"faran", "faran"},
		{"farande", "far"},
		{"farbroder", "farbrod"},
		{"farbrodern", "farbrod"},
		{"farbroderns", "farbrod"},
		{"farbror", "farbr"},
		{"farbrors", "farbror"},
		{"farbröder", "farbröd"},
		{"fardig", "fard"},
		{"farfadern", "farfad"},
		{"farfar", "farf"},
		{"farfars", "farfar"},
		{"farföräldrar", "farföräldr"},
		{"farföräldrars", "farföräldrar"},
		{"farhåga", "farhåg"},
		{"farhågan", "farhågan"},
		{"farhågor", "farhåg"},
		{"farit", "farit"},
		{"farkost", "farkost"},
		{"farkosten", "farkost"},
		{"farkoster", "farkost"},
		{"farl", "farl"},
		{"farlig", "far"},
		{"farliga", "far"},
		{"farligare", "far"},
		{"farligt", "far"},
		{"farm", "farm"},
		{"farmaceut", "farmaceut"},
		{"farmaceuten", "farmaceut"},
		{"farmor", "farm"},
		{"faror", "far"},
		{"fars", "far"},
		{"farscha", "farsch"},
		{"farstudör", "farstudör"},
		{"farstutrapp", "farstutrapp"},
		{"fart", "fart"},
		{"farten", "fart"},
		{"fartyg", "fartyg"},
		{"fartygen", "fartyg"},
		{"fartyget", "fartyget"},
		{"fartygets", "fartyget"},
		{"fartygs", "fartyg"},
		{"farvatten", "farvat"},
		{"farväl", "farväl"},
		{"fasa", "fas"},
		{"fasad", "fas"},
		{"fasanerna", "fasan"},
		{"fasansfulle", "fasansfull"},
		{"fasansfullt", "fasansfull"},
		{"fasar", "fas"},
		{"fasligen", "fas"},
		{"fasligt", "fas"},
		{"fasoner", "fason"},
		{"fasonerna", "fason"},
		{"fasor", "fas"},
		{"fassor", "fass"},
		{"fast", "fast"},
		{"fasta", "fast"},
		{"fastad", "fast"},
		{"fastaget", "fastaget"},
		{"fastan", "fastan"},
		{"fastare", "fast"},
		{"fastbunden", "fastbund"},
		{"faster", "fast"},
		{"fastern", "fast"},
		{"fasters", "faster"},
		{"fastfrusen", "fastfrus"},
		{"fasthet", "fast"},
		{"fasthäftade", "fasthäft"},
		{"fasthålla", "fasthåll"},
		{"fasthöllo", "fasthöllo"},
		{"fastklistrad", "fastklistr"},
		{"fastlag", "fastlag"},
		{"fastlagskoral", "fastlagskoral"},
		{"fastmer", "fastm"},
		{"fastmö", "fastmö"},
		{"fastna", "fastn"},
		{"fastnade", "fastn"},
		{"fastnaglad", "fastnagl"},
		{"fastnat", "fastn"},
		{"fastrar", "fastr"},
		{"fastställda", "fastställd"},
		{"fastsurrad", "fastsurr"},
		{"fastsurrade", "fastsurr"},
		{"fastän", "fastän"},
		{"fastån", "fastån"},
		{"fat", "fat"},
		{"fatalt", "fatalt"},
		{"fatet", "fatet"},
		{"fatt", "fatt"},
		{"fatta", "fatt"},
		{"fattadc", "fattadc"},
		{"fattade", "fatt"},
		{"fattades", "fatt"},
		{"fattar", "fatt"},
		{"fattas", "fatt"},
		{"fattat", "fatt"},
		{"fattbar", "fattb"},
		{"fattig", "fatt"},
		{"fattiga", "fatt"},
		{"fattigare", "fatt"},
		{"fattigaste", "fatt"},
		{"fattigdom", "fattigdom"},
		{"fattigdomen", "fattigdom"},
		{"fattigdomens", "fattigdom"},
		{"fattige", "fatt"},
		{"fattiglapp", "fattiglapp"},
		{"fattiglappen", "fattiglapp"},
		{"fattigt", "fatt"},
		{"fattning", "fattning"},
		{"fattningsförmåga", "fattningsförmåg"},
		{"fattningsgåva", "fattningsgåv"},
		{"faubourg", "faubourg"},
		{"faure", "faur"},
		{"faust", "faust"},
		{"faute", "faut"},
		{"favitska", "favitsk"},
		{"favoriträtt", "favoriträt"},
		{"fax", "fax"},
		{"fctt", "fctt"},
		{"fdrlovade", "fdrlov"},
		{"fdrvridna", "fdrvridn"},
		{"fe", "fe"},
		{"feber", "feb"},
		{"feberaktig", "feberakt"},
		{"feberaktiga", "feberakt"},
		{"feberdröm", "feberdröm"},
		{"feberhetta", "feberhet"},
		{"febern", "feb"},
		{"feberns", "feb"},
		{"febersjukdom", "febersjukdom"},
		{"febertermometern", "febertermomet"},
		{"febervarm", "febervarm"},
		{"feberyrsel", "feberyrsel"},
		{"feberyrseln", "feberyrseln"},
		{"febrilt", "febrilt"},
		{"februari", "februari"},
		{"feer", "feer"},
		{"feerna", "feern"},
		{"feg", "feg"},
		{"feghet", "feg"},
		{"fegt", "fegt"},
		{"fejade", "fej"},
		{"fejd", "fejd"},
		{"fel", "fel"},
		{"fela", "fel"},
		{"felade", "fel"},
		{"felaktig", "felakt"},
		{"felaktiga", "felakt"},
		{"felande", "fel"},
		{"felas", "fel"},
		{"felat", "fel"},
		{"felet", "felet"},
		{"felfri", "felfri"},
		{"felix", "felix"},
		{"felmodellerad", "felmodeller"},
		{"felslagna", "felslagn"},
		{"felsteg", "felsteg"},
		{"fem", "fem"},
		{"feminin", "feminin"},
		{"femkamp", "femkamp"},
		{"femma", "femm"},
		{"femrio", "femrio"},
		{"femte", "femt"},
		{"femtio", "femtio"},
		{"femtiosex", "femtiosex"},
		{"femtiosju", "femtiosju"},
		{"femtiotalet", "femtiotalet"},
		{"femtioåtta", "femtioåt"},
		{"femton", "femton"},
		{"femtonde", "femtond"},
		{"fen", "fen"},
		{"fena", "fen"},
		{"fenelon", "fenelon"},
		{"fenix", "fenix"},
		{"fenomenens", "fenomen"},
		{"fenster", "fenst"},
		{"ferierna", "feri"},
		{"fermt", "fermt"},
		{"fermtio", "fermtio"},
		{"fernissa", "ferniss"},
		{"fersen", "fers"},
		{"fest", "fest"},
		{"festen", "fest"},
		{"festens", "fest"},
		{"fester", "fest"},
		{"festernas", "fest"},
		{"festklädda", "festkläd"},
		{"festliga", "fest"},
		{"festligaste", "fest"},
		{"festligheten", "fest"},
		{"festligt", "fest"},
		{"fet", "fet"},
		{"feta", "fet"},
		{"fetare", "fet"},
		{"fetknoppen", "fetknopp"},
		{"fetlagd", "fetlag"},
		{"fetlagt", "fetlag"},
		{"fetman", "fetman"},
		{"fetstilsrubriken", "fetstilsrubrik"},
		{"fett", "fett"},
		{"fetthjärta", "fetthjärt"},
		{"fez", "fez"},
		{"fezen", "fez"},
		{"fi", "fi"},
		{"fiaddra", "fiaddr"},
		{"fiat", "fiat"},
		{"fibrer", "fibr"},
		{"fichn", "fichn"},
		{"ficj", "ficj"},
		{"fick", "fick"},
		{"ficka", "fick"},
		{"fickan", "fickan"},
		{"ficker", "fick"},
		{"fickers", "ficker"},
		{"fickor", "fick"},
		{"fickorna", "fick"},
		{"fickpengar", "fickpeng"},
		{"ficktjuvs", "ficktjuv"},
		{"fickur", "fickur"},
		{"fideikommiss", "fideikommiss"},
		{"fiende", "fiend"},
		{"fiendeland", "fiendeland"},
		{"fiender", "fiend"},
		{"fientlig", "fient"},
		{"fientliga", "fient"},
		{"fientlighet", "fient"},
		{"fiffigt", "fiff"},
		{"fig", "fig"},
		{"figur", "figur"},
		{"figuranter", "figurant"},
		{"figuren", "figur"},
		{"figurer", "figur"},
		{"figurerna", "figur"},
		{"figurliga", "figur"},
		{"fiiosofiskt", "fiiosofisk"},
		{"fiiten", "fiit"},
		{"fikar", "fik"},
		{"fikon", "fikon"},
		{"fikonaskörten", "fikonaskört"},
		{"fiktion", "fiktion"},
		{"fiktioner", "fiktion"},
		{"fikusen", "fikus"},
		{"fil", "fil"},
		{"filantroper", "filantrop"},
		{"filbunke", "filbunk"},
		{"filen", "fil"},
		{"filips", "filip"},
		{"filosof", "filosof"},
		{"filosofen", "filosof"},
		{"filosoferna", "filosof"},
		{"filosofi", "filosofi"},
		{"filosofin", "filosofin"},
		{"filosofiska", "filosofisk"},
		{"filt", "filt"},
		{"filtar", "filt"},
		{"filuren", "filur"},
		{"fimbulnatt", "fimbulnat"},
		{"fimla", "fiml"},
		{"fimls", "fiml"},
		{"fin", "fin"},
		{"fina", "fin"},
		{"finansvärlden", "finansvärld"},
		{"finare", "fin"},
		{"finaste", "fin"},
		{"finessen", "finess"},
		{"fingc", "fingc"},
		{"finge", "fing"},
		{"finger", "fing"},
		{"fingerspetsar", "fingerspets"},
		{"fingerspetsarna", "fingerspets"},
		{"fingertoppar", "fingertopp"},
		{"fingertopparna", "fingertopp"},
		{"fingo", "fingo"},
		{"fingra", "fingr"},
		{"fingrade", "fingr"},
		{"fingrar", "fingr"},
		{"fingrarna", "fingr"},
		{"fingrarne", "fingr"},
		{"fingret", "fingret"},
		{"finhet", "fin"},
		{"finheter", "fin"},
		{"finkel", "finkel"},
		{"finkänslig", "finkäns"},
		{"finkänsliga", "finkäns"},
		{"finkänslighet", "finkäns"},
		{"finland", "finland"},
		{"finlandssvenska", "finlandssvensk"},
		{"finländsk", "finländsk"},
		{"finms", "finm"},
		{"finna", "finn"},
		{"finnande", "finn"},
		{"finnandes", "finn"},
		{"finnarna", "finn"},
		{"finnas", "finn"},
		{"finner", "finn"},
		{"finnes", "finn"},
		{"finns", "finn"},
		{"fins", "fin"},
		{"finsk", "finsk"},
		{"finska", "finsk"},
		{"fint", "fint"},
		{"fintlighet", "fint"},
		{"finur", "finur"},
		{"fiol", "fiol"},
		{"fiolen", "fiol"},
		{"fiolin", "fiolin"},
		{"fira", "fir"},
		{"firad", "fir"},
		{"firade", "fir"},
		{"firades", "fir"},
		{"firande", "fir"},
		{"firar", "fir"},
		{"firat", "fir"},
		{"firma", "firm"},
		{"fisk", "fisk"},
		{"fiska", "fisk"},
		{"fiskar", "fisk"},
		{"fiskarbatarna", "fiskarbat"},
		{"fiskarbåtarna", "fiskarbåt"},
		{"fiskare", "fisk"},
		{"fiskaren", "fisk"},
		{"fiskarflicka", "fiskarflick"},
		{"fiskarflickan", "fiskarflickan"},
		{"fiskarflickans", "fiskarflickan"},
		{"fiskargubbe", "fiskargubb"},
		{"fiskarne", "fisk"},
		{"fiskarstugan", "fiskarstugan"},
		{"fiskarstugorna", "fiskarstug"},
		{"fiskat", "fisk"},
		{"fiske", "fisk"},
		{"fisken", "fisk"},
		{"fisket", "fisket"},
		{"fiskfatet", "fiskfatet"},
		{"fiskläge", "fiskläg"},
		{"fisklägen", "fiskläg"},
		{"fiskläget", "fiskläget"},
		{"fisklägets", "fiskläget"},
		{"fisknoten", "fisknot"},
		{"fiskrarne", "fiskr"},
		{"fiskredskap", "fiskredskap"},
		{"fiskredskapen", "fiskredskap"},
		{"fisktorkning", "fisktorkning"},
		{"fisktorkningen", "fisktorkning"},
		{"fistmanspresenterna", "fistmanspresent"},
		{"fix", "fix"},
		{"fixerade", "fixer"},
		{"fixerar", "fixer"},
		{"fiäsk", "fiäsk"},
		{"fjerde", "fjerd"},
		{"fjesk", "fjesk"},
		{"fjeska", "fjesk"},
		{"fjol", "fjol"},
		{"fjolligt", "fjol"},
		{"fjor", "fjor"},
		{"fjorton", "fjorton"},
		{"fjortonde", "fjortond"},
		{"fjortonårig", "fjortonår"},
		{"fjortonöres", "fjortonör"},
		{"fjun", "fjun"},
		{"fjuniga", "fjun"},
		{"fjunlös", "fjunlös"},
		{"fjäder", "fjäd"},
		{"fjäderboa", "fjäderbo"},
		{"fjädern", "fjäd"},
		{"fjädrande", "fjädr"},
		{"fjädrar", "fjädr"},
		{"fjäll", "fjäll"},
		{"fjällen", "fjäll"},
		{"fjälliga", "fjäl"},
		{"fjälligt", "fjäl"},
		{"fjällko", "fjällko"},
		{"fjärde", "fjärd"},
		{"fjärdedelar", "fjärdedel"},
		{"fjärdedelen", "fjärdedel"},
		{"fjärdedels", "fjärdedel"},
		{"fjärden", "fjärd"},
		{"fjärdingsväg", "fjärdingsväg"},
		{"fjäril", "fjäril"},
		{"fjärilar", "fjäril"},
		{"fjärn", "fjärn"},
		{"fjärnt", "fjärnt"},
		{"fjärran", "fjärran"},
		{"fjäsa", "fjäs"},
		{"fjäsad", "fjäs"},
		{"fjäsade", "fjäs"},
		{"fjäsk", "fjäsk"},
		{"fjäska", "fjäsk"},
		{"fjät", "fjät"},
		{"flabbade", "flabb"},
		{"flacka", "flack"},
		{"flackade", "flack"},
		{"flackande", "flack"},
		{"flacken", "flack"},
		{"flackt", "flack"},
		{"fladd", "fladd"},
		{"fladdra", "fladdr"},
		{"fladdrade", "fladdr"},
		{"fladdrande", "fladdr"},
		{"fladdrar", "fladdr"},
		{"fladdrat", "fladdr"},
		{"flagat", "flag"},
		{"flagg", "flagg"},
		{"flaggar", "flagg"},
		{"flaggor", "flagg"},
		{"flagor", "flag"},
		{"flak", "flak"},
		{"flamma", "flamm"},
		{"flammade", "flamm"},
		{"flamman", "flamman"},
		{"flammande", "flamm"},
		{"flammar", "flamm"},
		{"flammorna", "flamm"},
		{"flamröd", "flamröd"},
		{"flandrisk", "flandrisk"},
		{"flarn", "flarn"},
		{"flaska", "flask"},
		{"flaskan", "flaskan"},
		{"flaskor", "flask"},
		{"flat", "flat"},
		{"flata", "flat"},
		{"flaxade", "flax"},
		{"flaxande", "flax"},
		{"flegmatiska", "flegmatisk"},
		{"fler", "fler"},
		{"flera", "fler"},
		{"flesta", "flest"},
		{"flestas", "flest"},
		{"fli", "fli"},
		{"flicka", "flick"},
		{"flickaktig", "flickakt"},
		{"flickaktigt", "flickakt"},
		{"flickan", "flickan"},
		{"flickans", "flickan"},
		{"flickas", "flick"},
		{"flickbarn", "flickbarn"},
		{"flickben", "flickb"},
		{"flickbröst", "flickbröst"},
		{"flickdrömmerierna", "flickdrömmeri"},
		{"flickförtjusningen", "flickförtjusning"},
		{"flickhufvud", "flickhufvud"},
		{"flickhänder", "flickhänd"},
		{"flickkroppen", "flickkropp"},
		{"flickläroverk", "flickläroverk"},
		{"flicklåro", "flicklåro"},
		{"flicknamn", "flicknamn"},
		{"flickor", "flick"},
		{"flickorna", "flick"},
		{"flickornas", "flick"},
		{"flickors", "flickor"},
		{"flickröster", "flickröst"},
		{"flickskolan", "flickskolan"},
		{"flicksnärtor", "flicksnärt"},
		{"flicktiden", "flicktid"},
		{"flickunge", "flickung"},
		{"flickungen", "flickung"},
		{"flickuppfostran", "flickuppfostran"},
		{"flida", "flid"},
		{"flieka", "fliek"},
		{"flik", "flik"},
		{"flikade", "flik"},
		{"flikar", "flik"},
		{"flin", "flin"},
		{"flingor", "fling"},
		{"flinka", "flink"},
		{"flinke", "flink"},
		{"flinkt", "flink"},
		{"flintor", "flint"},
		{"flintskallig", "flintskal"},
		{"flintskallige", "flintskal"},
		{"flit", "flit"},
		{"flitig", "flit"},
		{"flitiga", "flit"},
		{"flitigare", "flit"},
		{"flitige", "flit"},
		{"flitigt", "flit"},
		{"flock", "flock"},
		{"flockade", "flock"},
		{"flockar", "flock"},
		{"flocken", "flock"},
		{"flod", "flod"},
		{"floden", "flod"},
		{"floder", "flod"},
		{"floders", "floder"},
		{"flor", "flor"},
		{"flora", "flor"},
		{"floras", "flor"},
		{"floreal", "floreal"},
		{"florentinarnas", "florentin"},
		{"florerar", "florer"},
		{"floret", "floret"},
		{"florets", "floret"},
		{"florsdraperier", "florsdraperi"},
		{"florstunn", "florstun"},
		{"flossa", "floss"},
		{"flott", "flott"},
		{"flotta", "flott"},
		{"flottan", "flottan"},
		{"flottas", "flott"},
		{"flottglänsande", "flottgläns"},
		{"flottig", "flott"},
		{"flottigare", "flott"},
		{"fluga", "flug"},
		{"flugfångare", "flugfång"},
		{"flugit", "flugit"},
		{"flugmöte", "flugmöt"},
		{"flugor", "flug"},
		{"flugorna", "flug"},
		{"flugornas", "flug"},
		{"flutit", "flutit"},
		{"flux", "flux"},
		{"fly", "fly"},
		{"flydda", "flydd"},
		{"flydde", "flydd"},
		{"flyende", "flyend"},
		{"flyg", "flyg"},
		{"flyga", "flyg"},
		{"flygande", "flyg"},
		{"flygaren", "flyg"},
		{"flygeln", "flygeln"},
		{"flyger", "flyg"},
		{"flyglar", "flygl"},
		{"flygt", "flygt"},
		{"flykt", "flykt"},
		{"flykta", "flykt"},
		{"flyktande", "flykt"},
		{"flyktar", "flykt"},
		{"flykten", "flykt"},
		{"flykter", "flykt"},
		{"flyktig", "flykt"},
		{"flyktiga", "flykt"},
		{"flyktigare", "flykt"},
		{"flyktighet", "flykt"},
		{"flyktigheten", "flykt"},
		{"flyktigt", "flykt"},
		{"flykting", "flykting"},
		{"flyktlg", "flyktlg"},
		{"flyr", "flyr"},
		{"flyta", "flyt"},
		{"flytande", "flyt"},
		{"flyter", "flyt"},
		{"flytt", "flytt"},
		{"flytta", "flytt"},
		{"flyttade", "flytt"},
		{"flyttar", "flytt"},
		{"flyttat", "flytt"},
		{"flyttbar", "flyttb"},
		{"flyttfoglarne", "flyttfogl"},
		{"flyttning", "flyttning"},
		{"fläck", "fläck"},
		{"fläckar", "fläck"},
		{"fläckarna", "fläck"},
		{"fläcken", "fläck"},
		{"fläckig", "fläck"},
		{"fläckigt", "fläck"},
		{"fläcktiga", "fläckt"},
		{"fläder", "fläd"},
		{"fläkt", "fläkt"},
		{"fläktade", "fläkt"},
		{"fläktande", "fläkt"},
		{"fläktar", "fläkt"},
		{"fläktat", "fläkt"},
		{"fläkte", "fläkt"},
		{"flämtade", "flämt"},
		{"flämtamde", "flämtamd"},
		{"flämtande", "flämt"},
		{"flämtar", "flämt"},
		{"flämtat", "flämt"},
		{"flärd", "flärd"},
		{"flärdfull", "flärdfull"},
		{"flärdfulla", "flärdfull"},
		{"flärdlöshet", "flärdlös"},
		{"fläsk", "fläsk"},
		{"fläskbitens", "fläskbit"},
		{"fläskkotlett", "fläskkotlet"},
		{"fläta", "flät"},
		{"flätade", "flät"},
		{"flätan", "flätan"},
		{"flätar", "flät"},
		{"flätor", "flät"},
		{"flåsade", "flås"},
		{"flåsande", "flås"},
		{"flödade", "flöd"},
		{"flödande", "flöd"},
		{"flödar", "flöd"},
		{"flöden", "flöd"},
		{"flödet", "flödet"},
		{"flög", "flög"},
		{"flögo", "flögo"},
		{"flöjel", "flöjel"},
		{"flöjlande", "flöjl"},
		{"flöjlarna", "flöjl"},
		{"flöjt", "flöjt"},
		{"flöjter", "flöjt"},
		{"flöjtverk", "flöjtverk"},
		{"flöt", "flöt"},
		{"fmlstret", "fmlstret"},
		{"fn", "fn"},
		{"fnassel", "fnassel"},
		{"fnissade", "fniss"},
		{"fnitter", "fnitt"},
		{"fnittrade", "fnittr"},
		{"fnittrande", "fnittr"},
		{"fnurrar", "fnurr"},
		{"fnys", "fnys"},
		{"fnysning", "fnysning"},
		{"fnyste", "fnyst"},
		{"fnös", "fnös"},
		{"fnöske", "fnösk"},
		{"foajen", "foaj"},
		{"focken", "fock"},
		{"fockmasten", "fockmast"},
		{"fockskotet", "fockskotet"},
		{"fodcr", "fodcr"},
		{"foderverket", "foderverket"},
		{"fodral", "fodral"},
		{"fodralet", "fodralet"},
		{"fodringsägaren", "fodringsäg"},
		{"foga", "fog"},
		{"fogade", "fog"},
		{"fogarna", "fog"},
		{"fogat", "fog"},
		{"fogdar", "fogd"},
		{"fogde", "fogd"},
		{"fogden", "fogd"},
		{"fogelkvist", "fogelkvist"},
		{"foglig", "fog"},
		{"fogligare", "fog"},
		{"fogligheten", "fog"},
		{"fogligt", "fog"},
		{"fogningar", "fogning"},
		{"folianter", "foliant"},
		{"folie", "foli"},
		{"folies", "foli"},
		{"folja", "folj"},
		{"folk", "folk"},
		{"folkbok", "folkbok"},
		{"folken", "folk"},
		{"folket", "folket"},
		{"folkets", "folket"},
		{"folkhop", "folkhop"},
		{"folkliv", "folkliv"},
		{"folklivet", "folklivet"},
		{"folkmelodi", "folkmelodi"},
		{"folks", "folk"},
		{"folksamlingar", "folksamling"},
		{"folkskarorna", "folkskar"},
		{"folkskollärare", "folkskollär"},
		{"folksägen", "folksäg"},
		{"folksägner", "folksägn"},
		{"folktom", "folktom"},
		{"folktommast", "folktomm"},
		{"folktro", "folktro"},
		{"folkvett", "folkvet"},
		{"folkvimlet", "folkvimlet"},
		{"foll", "foll"},
		{"follo", "follo"},
		{"fonden", "fond"},
		{"fonder", "fond"},
		{"fondmäklaren", "fondmäkl"},
		{"fonstren", "fonstr"},
		{"fonstret", "fonstret"},
		{"for", "for"},
		{"forbi", "forbi"},
		{"forcerat", "forcer"},
		{"ford", "ford"},
		{"fordna", "fordn"},
		{"fordom", "fordom"},
		{"fordomtima", "fordomtim"},
		{"fordon", "fordon"},
		{"fordra", "fordr"},
		{"fordrade", "fordr"},
		{"fordran", "fordran"},
		{"fordrande", "fordr"},
		{"fordrar", "fordr"},
		{"fordras", "fordr"},
		{"fordrat", "fordr"},
		{"fordringar", "fordring"},
		{"fordringsägare", "fordringsäg"},
		{"fordringsägaren", "fordringsäg"},
		{"foredrog", "foredrog"},
		{"forefoll", "forefoll"},
		{"foregaende", "foregaend"},
		{"foreslog", "foreslog"},
		{"forfärligt", "forfär"},
		{"forklade", "forkl"},
		{"form", "form"},
		{"forma", "form"},
		{"formade", "form"},
		{"formande", "form"},
		{"formas", "form"},
		{"format", "form"},
		{"formationer", "formation"},
		{"formats", "format"},
		{"formellt", "formellt"},
		{"formen", "form"},
		{"formens", "form"},
		{"former", "form"},
		{"formerna", "form"},
		{"formligen", "form"},
		{"formlighet", "form"},
		{"formligt", "form"},
		{"formlösa", "formlös"},
		{"formulera", "formuler"},
		{"formuläret", "formuläret"},
		{"formåga", "formåg"},
		{"forn", "forn"},
		{"forna", "forn"},
		{"forne", "forn"},
		{"forntida", "forntid"},
		{"foro", "foro"},
		{"foror", "for"},
		{"forr", "forr"},
		{"fors", "for"},
		{"forsade", "fors"},
		{"forsande", "fors"},
		{"forsar", "fors"},
		{"forsen", "fors"},
		{"forsiktigt", "forsikt"},
		{"forskande", "forsk"},
		{"forskar", "forsk"},
		{"forskarmödorna", "forskarmöd"},
		{"forsla", "forsl"},
		{"forsmädat", "forsmäd"},
		{"forssar", "forss"},
		{"forssling", "forssling"},
		{"forst", "forst"},
		{"forstorad", "forstor"},
		{"forsökte", "forsök"},
		{"fort", "fort"},
		{"fortare", "fort"},
		{"fortepianot", "fortepianot"},
		{"fortfar", "fortf"},
		{"fortfara", "fortfar"},
		{"fortfarande", "fortfar"},
		{"fortfarit", "fortfarit"},
		{"fortfor", "fortf"},
		{"fortforo", "fortforo"},
		{"fortgick", "fortgick"},
		{"fortgång", "fortgång"},
		{"fortgången", "fortgång"},
		{"fortgått", "fortgåt"},
		{"fortjust", "fortjust"},
		{"fortjänster", "fortjänst"},
		{"fortkomst", "fortkomst"},
		{"fortsatt", "fortsat"},
		{"fortsatta", "fortsat"},
		{"fortsatte", "fortsat"},
		{"fortsattes", "fortsat"},
		{"fortskaffningsmedlet", "fortskaffningsmedlet"},
		{"fortsätt", "fortsät"},
		{"fortsätta", "fortsät"},
		{"fortsättandet", "fortsät"},
		{"fortsätter", "fortsät"},
		{"fortsättning", "fortsättning"},
		{"fortsättningen", "fortsättning"},
		{"fortune", "fortun"},
		{"forum", "forum"},
		{"forut", "forut"},
		{"forvandla", "forvandl"},
		{"forvridna", "forvridn"},
		{"forälskad", "forälsk"},
		{"forändrade", "forändr"},
		{"fosfat", "fosf"},
		{"fosforism", "fosforism"},
		{"foster", "fost"},
		{"fosterbarn", "fosterbarn"},
		{"fosterdotter", "fosterdot"},
		{"fosterdottern", "fosterdot"},
		{"fosterfader", "fosterfad"},
		{"fosterfar", "fosterf"},
		{"fosterland", "fosterland"},
		{"fosterlandet", "fosterl"},
		{"fosterlandets", "fosterlandet"},
		{"fosterlands", "fosterland"},
		{"fosterlandsförräderi", "fosterlandsförräderi"},
		{"fosterlandsvän", "fosterlandsvän"},
		{"fosterländska", "fosterländsk"},
		{"fostermodern", "fostermod"},
		{"fostermor", "fosterm"},
		{"fostermors", "fostermor"},
		{"fostrade", "fostr"},
		{"fostrat", "fostr"},
		{"fostret", "fostret"},
		{"fot", "fot"},
		{"fotboll", "fotboll"},
		{"fotbollen", "fotboll"},
		{"foten", "fot"},
		{"fotgängare", "fotgäng"},
		{"fotnot", "fotnot"},
		{"fotogen", "fotog"},
		{"fotogenlampor", "fotogenlamp"},
		{"fotogenlukten", "fotogenluk"},
		{"fotografi", "fotografi"},
		{"fotografier", "fotografi"},
		{"fotografiet", "fotografiet"},
		{"fotografin", "fotografin"},
		{"fotogratiet", "fotogratiet"},
		{"fotpar", "fotp"},
		{"fots", "fot"},
		{"fotsbredd", "fotsbred"},
		{"fotspar", "fotsp"},
		{"fotspår", "fotspår"},
		{"fotsteg", "fotsteg"},
		{"fotstegem", "fotstegem"},
		{"fotstegen", "fotsteg"},
		{"fotterna", "fott"},
		{"fotvandraren", "fotvandr"},
		{"fou", "fou"},
		{"fra", "fra"},
		{"frack", "frack"},
		{"frackarna", "frack"},
		{"fracken", "frack"},
		{"frackens", "frack"},
		{"frackfason", "frackfason"},
		{"frackskörten", "frackskört"},
		{"fradga", "fradg"},
		{"fradgande", "fradg"},
		{"fraga", "frag"},
		{"fragade", "frag"},
		{"fragan", "fragan"},
		{"fragar", "frag"},
		{"fragment", "fragment"},
		{"frall", "frall"},
		{"fralsta", "fralst"},
		{"fram", "fram"},
		{"framat", "fram"},
		{"framatlutad", "framatlut"},
		{"framblickade", "framblick"},
		{"frambragt", "frambrag"},
		{"frambringa", "frambring"},
		{"frambringar", "frambring"},
		{"frambrytande", "frambryt"},
		{"frambröt", "frambröt"},
		{"framburna", "framburn"},
		{"framdeles", "framdel"},
		{"framdraga", "framdrag"},
		{"framdrog", "framdrog"},
		{"framdrogo", "framdrogo"},
		{"framdykande", "framdyk"},
		{"framemot", "framemot"},
		{"framfarna", "framf"},
		{"framfart", "framfart"},
		{"framfor", "framf"},
		{"framfödandet", "framföd"},
		{"framför", "framför"},
		{"framföra", "framför"},
		{"framförallt", "framförallt"},
		{"framförd", "framförd"},
		{"framförde", "framförd"},
		{"framgick", "framgick"},
		{"framgå", "framgå"},
		{"framgång", "framgång"},
		{"framgången", "framgång"},
		{"framgångsrike", "framgångsrik"},
		{"framhjulen", "framhjul"},
		{"framhäva", "framhäv"},
		{"framila", "framil"},
		{"framkalla", "framkall"},
		{"framkallade", "framkall"},
		{"framkalladt", "framkallad"},
		{"framkallat", "framkall"},
		{"framkasta", "framkast"},
		{"framkastad", "framkast"},
		{"framkastade", "framkast"},
		{"framkastat", "framkast"},
		{"framkom", "framkom"},
		{"framkomma", "framkomm"},
		{"framkröp", "framkröp"},
		{"framlagd", "framlag"},
		{"framlefva", "framlefv"},
		{"framleta", "framlet"},
		{"framleva", "framlev"},
		{"framlidne", "framlidn"},
		{"framling", "framling"},
		{"framlockat", "framlock"},
		{"framlägga", "framlägg"},
		{"framman", "framman"},
		{"frammc", "frammc"},
		{"framme", "framm"},
		{"framom", "framom"},
		{"framplocka", "framplock"},
		{"framplockade", "framplock"},
		{"frampressade", "frampress"},
		{"frampustade", "frampust"},
		{"frampå", "frampå"},
		{"framropades", "framrop"},
		{"framrullade", "framrull"},
		{"framräckt", "framräck"},
		{"framsatt", "framsat"},
		{"framsatta", "framsat"},
		{"framsattes", "framsat"},
		{"framsida", "framsid"},
		{"framskimrat", "framskimr"},
		{"framskjuta", "framskjut"},
		{"framskjuten", "framskjut"},
		{"framskred", "framskred"},
		{"framskriden", "framskrid"},
		{"framskymta", "framskymt"},
		{"framskymtade", "framskymt"},
		{"framsläpade", "framsläp"},
		{"framsmyga", "framsmyg"},
		{"framsmögo", "framsmögo"},
		{"framstamma", "framstamm"},
		{"framstammade", "framstamm"},
		{"framsteg", "framsteg"},
		{"framstickande", "framstick"},
		{"framsticker", "framstick"},
		{"framstod", "framstod"},
		{"framsträckt", "framsträck"},
		{"framstupa", "framstup"},
		{"framstälda", "framstäld"},
		{"framstälde", "framstäld"},
		{"framställa", "framställ"},
		{"framställda", "framställd"},
		{"framställning", "framställning"},
		{"framställningar", "framställning"},
		{"framställningen", "framställning"},
		{"framställt", "framställt"},
		{"framstå", "framstå"},
		{"framstående", "framståend"},
		{"framstönat", "framstön"},
		{"framsuckade", "framsuck"},
		{"framt", "framt"},
		{"framtaga", "framtag"},
		{"framtagit", "framtagit"},
		{"framtassarna", "framtass"},
		{"framtid", "framtid"},
		{"framtida", "framtid"},
		{"framtiden", "framtid"},
		{"framtids", "framtid"},
		{"framtidsman", "framtidsman"},
		{"framtidsmän", "framtidsmän"},
		{"framtill", "framtill"},
		{"framtitta", "framtit"},
		{"framtittar", "framtit"},
		{"framtog", "framtog"},
		{"framtogs", "framtog"},
		{"framträda", "framträd"},
		{"framträdande", "framträd"},
		{"framträdde", "framträd"},
		{"framtränga", "framträng"},
		{"framträngde", "framträng"},
		{"framträtt", "framträt"},
		{"framtvinga", "framtving"},
		{"framviskade", "framvisk"},
		{"framviskat", "framvisk"},
		{"framvästes", "framväst"},
		{"framät", "framät"},
		{"framåt", "framåt"},
		{"framåtandan", "framåtandan"},
		{"framåtböjd", "framåtböjd"},
		{"framåtböjt", "framåtböjt"},
		{"framåtlutad", "framåtlut"},
		{"fran", "fran"},
		{"frankens", "frank"},
		{"frankiska", "frankisk"},
		{"frans", "fran"},
		{"fransar", "frans"},
		{"fransk", "fransk"},
		{"franska", "fransk"},
		{"franskt", "fransk"},
		{"fransmännen", "fransmän"},
		{"fransos", "franso"},
		{"fransosen", "fransos"},
		{"fransyska", "fransysk"},
		{"frants", "frant"},
		{"franzen", "franz"},
		{"frapperad", "frapper"},
		{"frapperade", "frapper"},
		{"frarmfört", "frarmfört"},
		{"frasade", "fras"},
		{"frasande", "fras"},
		{"frasen", "fras"},
		{"fraser", "fras"},
		{"fred", "fred"},
		{"fredad", "fred"},
		{"fredag", "fredag"},
		{"fredagen", "fredag"},
		{"fredags", "fredag"},
		{"fredagsförmiddagen", "fredagsförmiddag"},
		{"freden", "fred"},
		{"fredlig", "fred"},
		{"fredliga", "fred"},
		{"fredligare", "fred"},
		{"fredligt", "fred"},
		{"fredlösa", "fredlös"},
		{"fredmans", "fredman"},
		{"fredrik", "fredrik"},
		{"fredrika", "fredrik"},
		{"fredrikas", "fredrik"},
		{"fredrikshalds", "fredrikshald"},
		{"freds", "fred"},
		{"fredsgatan", "fredsgatan"},
		{"fredstraktat", "fredstrak"},
		{"fresta", "frest"},
		{"frestad", "frest"},
		{"frestade", "frest"},
		{"frestades", "frest"},
		{"frestande", "frest"},
		{"frestaren", "frest"},
		{"frestats", "frestat"},
		{"frestelse", "frest"},
		{"frestelsen", "frest"},
		{"frestelsens", "frest"},
		{"frestelser", "frest"},
		{"fri", "fri"},
		{"fria", "fria"},
		{"friad", "friad"},
		{"friade", "friad"},
		{"friar", "friar"},
		{"friardräkten", "friardräk"},
		{"friare", "friar"},
		{"friarefärd", "friarefärd"},
		{"friaren", "friar"},
		{"friarens", "friar"},
		{"friareresa", "friareres"},
		{"friareresan", "friareresan"},
		{"friares", "friar"},
		{"friareärenden", "friareärend"},
		{"friareäventyr", "friareäventyr"},
		{"friat", "friat"},
		{"frid", "frid"},
		{"fridag", "fridag"},
		{"friden", "frid"},
		{"fridens", "frid"},
		{"fridfu", "fridfu"},
		{"fridfulla", "fridfull"},
		{"fridfullt", "fridfull"},
		{"fridlyst", "fridlyst"},
		{"fridlysta", "fridlyst"},
		{"fridlös", "fridlös"},
		{"fridolin", "fridolin"},
		{"fridtjuv", "fridtjuv"},
		{"frieri", "frieri"},
		{"frieriet", "frieriet"},
		{"frieriets", "frieriet"},
		{"frieriterminen", "frieritermin"},
		{"frigjord", "frigjord"},
		{"frigör", "frigör"},
		{"frigöra", "frigör"},
		{"friherrinna", "friherrin"},
		{"friherrinnan", "friherrinnan"},
		{"friherrinnans", "friherrinnan"},
		{"friherrinnor", "friherrin"},
		{"friherrlig", "friherr"},
		{"frihet", "frihet"},
		{"friheten", "frihet"},
		{"frikostig", "frikost"},
		{"frikostighet", "frikost"},
		{"frikostigt", "frikost"},
		{"frikännande", "frikän"},
		{"frileux", "frileux"},
		{"frillornas", "frill"},
		{"frimodig", "frimod"},
		{"frimodighet", "frimod"},
		{"frimodigt", "frimod"},
		{"frimärkena", "frimärken"},
		{"fripredikantens", "fripredikant"},
		{"fris", "fris"},
		{"frisinnad", "frisin"},
		{"frisinnade", "frisin"},
		{"frisk", "frisk"},
		{"friska", "frisk"},
		{"friskare", "frisk"},
		{"friskhet", "frisk"},
		{"friskt", "frisk"},
		{"frispråkande", "frispråk"},
		{"frisrocken", "frisrock"},
		{"fristad", "frist"},
		{"fristunder", "fristund"},
		{"fritid", "fritid"},
		{"fritimmen", "fritimm"},
		{"fritt", "fritt"},
		{"frivoliteter", "frivolitet"},
		{"frivolt", "frivolt"},
		{"frkn", "frkn"},
		{"fro", "fro"},
		{"frodades", "frod"},
		{"frodas", "frod"},
		{"frodig", "frod"},
		{"frojder", "frojd"},
		{"frokenhud", "frokenhud"},
		{"frokn", "frokn"},
		{"froknarna", "frokn"},
		{"froknrrna", "froknrrn"},
		{"from", "from"},
		{"fromhet", "from"},
		{"fromma", "fromm"},
		{"fromme", "fromm"},
		{"fromsinnlig", "fromsinn"},
		{"fromt", "fromt"},
		{"frontespisen", "frontespis"},
		{"fross", "fross"},
		{"frossa", "fross"},
		{"frossade", "fross"},
		{"frossbrytningar", "frossbrytning"},
		{"frost", "frost"},
		{"frosten", "frost"},
		{"frostiga", "frost"},
		{"frostnatt", "frostnat"},
		{"frot", "frot"},
		{"frrb", "frrb"},
		{"frsknarr", "frsknarr"},
		{"fru", "fru"},
		{"fruar", "fruar"},
		{"fruarna", "fruarn"},
		{"fruarnas", "fruarn"},
		{"frukost", "frukost"},
		{"frukostbordet", "frukostbordet"},
		{"frukosten", "frukost"},
		{"frukostera", "frukoster"},
		{"frukostlovet", "frukostlovet"},
		{"frukostrast", "frukostr"},
		{"frukt", "frukt"},
		{"frukta", "frukt"},
		{"fruktad", "frukt"},
		{"fruktade", "frukt"},
		{"fruktan", "fruktan"},
		{"fruktande", "frukt"},
		{"fruktans", "fruktan"},
		{"fruktansvärd", "fruktansvärd"},
		{"fruktansvärda", "fruktansvärd"},
		{"fruktansvärdt", "fruktansvärd"},
		{"fruktansvärt", "fruktansvärt"},
		{"fruktar", "frukt"},
		{"fruktat", "frukt"},
		{"frukten", "frukt"},
		{"frukter", "frukt"},
		{"frukterna", "frukt"},
		{"frukters", "frukter"},
		{"fruktgirlanger", "fruktgirlang"},
		{"fruktkorg", "fruktkorg"},
		{"fruktlösa", "fruktlös"},
		{"fruktlösare", "fruktlös"},
		{"fruktlösheten", "fruktlös"},
		{"fruktlöst", "fruktlös"},
		{"frun", "frun"},
		{"fruns", "frun"},
		{"fruntimmer", "fruntimm"},
		{"fruntimmershand", "fruntimmershand"},
		{"fruntimmershattarna", "fruntimmershat"},
		{"fruntimmershistorier", "fruntimmershistori"},
		{"fruntimmerskappa", "fruntimmerskapp"},
		{"fruntimmerskjortel", "fruntimmerskjortel"},
		{"fruntimmersröst", "fruntimmersröst"},
		{"fruntimren", "fruntimr"},
		{"fruntimrens", "fruntimr"},
		{"fruntimret", "fruntimret"},
		{"frus", "frus"},
		{"frusen", "frus"},
		{"fruset", "fruset"},
		{"frusit", "frusit"},
		{"frusna", "frusn"},
		{"frustade", "frust"},
		{"frustande", "frust"},
		{"frustar", "frust"},
		{"frustulammen", "frustulamm"},
		{"frynt", "frynt"},
		{"fryntlig", "frynt"},
		{"fryntlighet", "frynt"},
		{"fryntligt", "frynt"},
		{"fryntligtvädran", "fryntligtvädran"},
		{"frysa", "frys"},
		{"frysande", "frys"},
		{"fryser", "frys"},
		{"frysning", "frysning"},
		{"fräcka", "fräck"},
		{"fräckare", "fräck"},
		{"fräcke", "fräck"},
		{"fräckhet", "fräck"},
		{"fräckheten", "fräck"},
		{"fräckt", "fräck"},
		{"fräknig", "fräkn"},
		{"fräls", "fräl"},
		{"frälsa", "fräls"},
		{"frälsare", "fräls"},
		{"frälsares", "frälsar"},
		{"frälsets", "frälset"},
		{"frälsning", "frälsning"},
		{"frälsningsarmen", "frälsningsarm"},
		{"frälsningskrokan", "frälsningskrokan"},
		{"frälsningsmöte", "frälsningsmöt"},
		{"frälsningssoldat", "frälsningssold"},
		{"frälsningssoldater", "frälsningssoldat"},
		{"frälsningssoldaterna", "frälsningssoldat"},
		{"frälsningssoldaternas", "frälsningssoldat"},
		{"frälst", "frälst"},
		{"frälsta", "frälst"},
		{"främ", "främ"},
		{"främja", "främj"},
		{"främjandet", "främj"},
		{"främling", "främling"},
		{"främlingar", "främling"},
		{"främlingen", "främling"},
		{"främlings", "främling"},
		{"främmand", "främmand"},
		{"främmandc", "främmandc"},
		{"främmande", "främm"},
		{"främst", "främst"},
		{"främsta", "främst"},
		{"frän", "frän"},
		{"fräna", "frän"},
		{"frände", "fränd"},
		{"fränder", "fränd"},
		{"fränders", "fränder"},
		{"fränt", "fränt"},
		{"fräsa", "fräs"},
		{"fräsande", "fräs"},
		{"fräste", "fräst"},
		{"fräta", "frät"},
		{"frätande", "frät"},
		{"fräter", "frät"},
		{"frätte", "frätt"},
		{"fråga", "fråg"},
		{"frågad", "fråg"},
		{"frågade", "fråg"},
		{"frågan", "frågan"},
		{"frågande", "fråg"},
		{"frågans", "frågan"},
		{"frågar", "fråg"},
		{"frågas", "fråg"},
		{"frågat", "fråg"},
		{"frågetecken", "frågeteck"},
		{"frågor", "fråg"},
		{"frågtecken", "frågteck"},
		{"från", "från"},
		{"fråndragen", "fråndrag"},
		{"frångå", "frångå"},
		{"frångår", "frångår"},
		{"frånskilda", "frånskild"},
		{"frånskilt", "frånskilt"},
		{"frånskjutit", "frånskjutit"},
		{"frånsköts", "frånsköt"},
		{"frånstötande", "frånstöt"},
		{"frånsäger", "frånsäg"},
		{"fråntaga", "fråntag"},
		{"fråntagas", "fråntag"},
		{"fråntager", "fråntag"},
		{"frånträda", "frånträd"},
		{"frånvarande", "frånvar"},
		{"frånvaro", "frånvaro"},
		{"frånvaron", "frånvaron"},
		{"frö", "frö"},
		{"fröding", "fröding"},
		{"fröet", "fröet"},
		{"fröja", "fröj"},
		{"fröjd", "fröjd"},
		{"fröjda", "fröjd"},
		{"fröjdade", "fröjd"},
		{"fröjdades", "fröjd"},
		{"fröjdas", "fröjd"},
		{"fröjde", "fröjd"},
		{"fröjdefulla", "fröjdefull"},
		{"fröjdeljud", "fröjdeljud"},
		{"fröjden", "fröjd"},
		{"fröjder", "fröjd"},
		{"fröjdesalen", "fröjdesal"},
		{"fröjdeämnen", "fröjdeämn"},
		{"fröjdfull", "fröjdfull"},
		{"fröjds", "fröjd"},
		{"fröken", "frök"},
		{"frökens", "frök"},
		{"frökn", "frökn"},
		{"fröknar", "frökn"},
		{"fröknarn", "fröknarn"},
		{"fröknarna", "frökn"},
		{"fröknarnas", "frökn"},
		{"fröknarnn", "fröknarn"},
		{"fröknarno", "fröknarno"},
		{"fröknartl", "fröknartl"},
		{"frömjölet", "frömjölet"},
		{"frön", "frön"},
		{"fröna", "frön"},
		{"frös", "frös"},
		{"fröso", "fröso"},
		{"fsrstås", "fsrstås"},
		{"fter", "fter"},
		{"fugaartade", "fugaart"},
		{"fukt", "fukt"},
		{"fukta", "fukt"},
		{"fuktade", "fukt"},
		{"fuktades", "fukt"},
		{"fuktas", "fukt"},
		{"fuktfläckar", "fuktfläck"},
		{"fuktig", "fukt"},
		{"fuktiga", "fukt"},
		{"fuktigt", "fukt"},
		{"ful", "ful"},
		{"fula", "ful"},
		{"fulare", "ful"},
		{"fulaste", "ful"},
		{"fulhet", "ful"},
		{"full", "full"},
		{"fulla", "full"},
		{"fullare", "full"},
		{"fullastad", "fullast"},
		{"fullaste", "full"},
		{"fullblod", "fullblod"},
		{"fullborda", "fullbord"},
		{"fullbordad", "fullbord"},
		{"fullbordade", "fullbord"},
		{"fullbordan", "fullbordan"},
		{"fullbordat", "fullbord"},
		{"fullfölja", "fullfölj"},
		{"fullgjort", "fullgjort"},
		{"fullgör", "fullgör"},
		{"fullklottrade", "fullklottr"},
		{"fullkomlig", "fullkom"},
		{"fullkomliga", "fullkom"},
		{"fullkomligaste", "fullkom"},
		{"fullkomligen", "fullkom"},
		{"fullkomligheten", "fullkom"},
		{"fullkomligt", "fullkom"},
		{"fullkomnade", "fullkomn"},
		{"fullmånens", "fullmån"},
		{"fullsatt", "fullsat"},
		{"fullsatta", "fullsat"},
		{"fullskrivet", "fullskrivet"},
		{"fullständig", "fullständ"},
		{"fullständigt", "fullständ"},
		{"fullt", "fullt"},
		{"fullvuxen", "fullvux"},
		{"fulländad", "fulländ"},
		{"fulländade", "fulländ"},
		{"fult", "fult"},
		{"fulton", "fulton"},
		{"fumlade", "fuml"},
		{"fumlig", "fum"},
		{"fumliga", "fum"},
		{"fun", "fun"},
		{"fund", "fund"},
		{"funde", "fund"},
		{"fundera", "funder"},
		{"funderadc", "funderadc"},
		{"funderade", "funder"},
		{"funderande", "funder"},
		{"funderar", "funder"},
		{"funderat", "funder"},
		{"funderingar", "fundering"},
		{"funderingarna", "fundering"},
		{"funderiugar", "funderiug"},
		{"fundersamt", "fundersamt"},
		{"fungerande", "funger"},
		{"funktioner", "funktion"},
		{"funna", "funn"},
		{"funnen", "funn"},
		{"funnes", "funn"},
		{"funnit", "funnit"},
		{"funnits", "funnit"},
		{"funno", "funno"},
		{"funnos", "funno"},
		{"funster", "funst"},
		{"furan", "furan"},
		{"furie", "furi"},
		{"furielika", "furielik"},
		{"furore", "furor"},
		{"furorna", "fur"},
		{"furstar", "furst"},
		{"furste", "furst"},
		{"furstes", "furst"},
		{"furstliga", "furst"},
		{"furstligt", "furst"},
		{"furu", "furu"},
		{"furupinnar", "furupin"},
		{"fusk", "fusk"},
		{"fuska", "fusk"},
		{"fuskade", "fusk"},
		{"fuskar", "fusk"},
		{"fusket", "fusket"},
		{"futtig", "futt"},
		{"futtiga", "futt"},
		{"futtigt", "futt"},
		{"fy", "fy"},
		{"fyld", "fyld"},
		{"fylda", "fyld"},
		{"fylde", "fyld"},
		{"fylgia", "fylgi"},
		{"fylla", "fyll"},
		{"fyllandet", "fyll"},
		{"fyllas", "fyll"},
		{"fylld", "fylld"},
		{"fyllda", "fylld"},
		{"fyllde", "fylld"},
		{"fylldes", "fylld"},
		{"fyller", "fyll"},
		{"fylleriet", "fylleriet"},
		{"fylles", "fyll"},
		{"fyllig", "fyl"},
		{"fylliga", "fyl"},
		{"fylligare", "fyl"},
		{"fyllighet", "fyl"},
		{"fylligt", "fyl"},
		{"fyllt", "fyllt"},
		{"fylt", "fylt"},
		{"fynd", "fynd"},
		{"fyndet", "fyndet"},
		{"fyndig", "fynd"},
		{"fyr", "fyr"},
		{"fyra", "fyr"},
		{"fyratiden", "fyratid"},
		{"fyratusen", "fyratus"},
		{"fyrfotingar", "fyrfoting"},
		{"fyrkanter", "fyrkant"},
		{"fyrkantig", "fyrkant"},
		{"fyrkantigt", "fyrkant"},
		{"fyrkar", "fyrk"},
		{"fyrsprång", "fyrsprång"},
		{"fyrstolpig", "fyrstolp"},
		{"fyrtio", "fyrtio"},
		{"fyrtiofem", "fyrtiofem"},
		{"fyrverk", "fyrverk"},
		{"fyrväldigt", "fyrväld"},
		{"fysik", "fysik"},
		{"fysionomi", "fysionomi"},
		{"fysisk", "fysisk"},
		{"fysiska", "fysisk"},
		{"fä", "fä"},
		{"fäder", "fäd"},
		{"fädernesland", "fädernesland"},
		{"fäderneslandet", "fädernesl"},
		{"fäderneslandets", "fäderneslandet"},
		{"fädernestammen", "fädernestamm"},
		{"fädrens", "fädr"},
		{"fägna", "fägn"},
		{"fägnade", "fägn"},
		{"fägnar", "fägn"},
		{"fägring", "fägring"},
		{"fähund", "fähund"},
		{"fäktade", "fäkt"},
		{"fälda", "fäld"},
		{"fälde", "fäld"},
		{"fälla", "fäll"},
		{"fällan", "fällan"},
		{"fällda", "fälld"},
		{"fällde", "fälld"},
		{"fäller", "fäll"},
		{"fällklaff", "fällklaff"},
		{"fällknif", "fällknif"},
		{"fällsäng", "fällsäng"},
		{"fält", "fält"},
		{"fälten", "fält"},
		{"fältens", "fält"},
		{"fälttåg", "fälttåg"},
		{"fäng", "fäng"},
		{"fängelse", "fäng"},
		{"fängelserna", "fäng"},
		{"fängnar", "fängn"},
		{"fängsla", "fängsl"},
		{"fängslad", "fängsl"},
		{"fängslade", "fängsl"},
		{"fängslades", "fängsl"},
		{"fängslande", "fängsl"},
		{"fängslat", "fängsl"},
		{"fängslet", "fängslet"},
		{"fär", "fär"},
		{"färd", "färd"},
		{"färdades", "färd"},
		{"färdas", "färd"},
		{"färde", "färd"},
		{"färden", "färd"},
		{"färdig", "färd"},
		{"färdiga", "färd"},
		{"färdigats", "färdigat"},
		{"färdighet", "färd"},
		{"färdiglovade", "färdiglov"},
		{"färdigt", "färd"},
		{"färg", "färg"},
		{"färgade", "färg"},
		{"färgades", "färg"},
		{"färgar", "färg"},
		{"färgat", "färg"},
		{"färgen", "färg"},
		{"färger", "färg"},
		{"färgerna", "färg"},
		{"färggrann", "färggran"},
		{"färglösa", "färglös"},
		{"färgprakt", "färgprak"},
		{"färgrika", "färgrik"},
		{"färgspel", "färgspel"},
		{"färgton", "färgton"},
		{"färjan", "färjan"},
		{"färliga", "fär"},
		{"färsk", "färsk"},
		{"färska", "färsk"},
		{"färskt", "färsk"},
		{"färsäkrat", "färsäkr"},
		{"fäst", "fäst"},
		{"fästa", "fäst"},
		{"fästad", "fäst"},
		{"fästade", "fäst"},
		{"fästades", "fäst"},
		{"fästadt", "fästad"},
		{"fästas", "fäst"},
		{"fästat", "fäst"},
		{"fäste", "fäst"},
		{"fäster", "fäst"},
		{"fästet", "fästet"},
		{"fästman", "fästman"},
		{"fästmannen", "fästman"},
		{"fästmannens", "fästman"},
		{"fästmö", "fästmö"},
		{"fästmön", "fästmön"},
		{"fästmös", "fästmös"},
		{"fästmöskänkerna", "fästmöskänk"},
		{"fästningen", "fästning"},
		{"fästrman", "fästrman"},
		{"få", "få"},
		{"fåelarnas", "fåel"},
		{"fåfäng", "fåfäng"},
		{"fåfänga", "fåfäng"},
		{"fåfängan", "fåfängan"},
		{"fåfänglighet", "fåfäng"},
		{"fåfängt", "fåfäng"},
		{"fågel", "fågel"},
		{"fågelbur", "fågelbur"},
		{"fågelflock", "fågelflock"},
		{"fågelkropp", "fågelkropp"},
		{"fågelkroppen", "fågelkropp"},
		{"fågelkvist", "fågelkvist"},
		{"fågeln", "fågeln"},
		{"fågelns", "fågeln"},
		{"fågelnäbb", "fågelnäbb"},
		{"fågelnäbbars", "fågelnäbbar"},
		{"fågels", "fågel"},
		{"fågeltro", "fågeltro"},
		{"fågelungars", "fågelungar"},
		{"fågelunge", "fågelung"},
		{"fågelungen", "fågelung"},
		{"fåglar", "fågl"},
		{"fåglarna", "fågl"},
		{"fåglarnas", "fågl"},
		{"fåglars", "fåglar"},
		{"fållat", "fåll"},
		{"fån", "fån"},
		{"fånar", "fån"},
		{"fåne", "fån"},
		{"fång", "fång"},
		{"fånga", "fång"},
		{"fångad", "fång"},
		{"fångade", "fång"},
		{"fångar", "fång"},
		{"fångarne", "fång"},
		{"fångas", "fång"},
		{"fångat", "fång"},
		{"fångcellen", "fångcell"},
		{"fånge", "fång"},
		{"fången", "fång"},
		{"fångenskapen", "fångenskap"},
		{"fångkärra", "fångkärr"},
		{"fånglinan", "fånglinan"},
		{"fångna", "fångn"},
		{"fångst", "fångst"},
		{"fånig", "fån"},
		{"fåniga", "fån"},
		{"fånigt", "fån"},
		{"fåordig", "fåord"},
		{"fåordiga", "fåord"},
		{"får", "får"},
		{"fåra", "får"},
		{"fåraktigt", "fårakt"},
		{"fårbog", "fårbog"},
		{"fåren", "får"},
		{"fåret", "fåret"},
		{"fårskallen", "fårskall"},
		{"fått", "fått"},
		{"fö", "fö"},
		{"föda", "föd"},
		{"födande", "föd"},
		{"födas", "föd"},
		{"född", "född"},
		{"födda", "född"},
		{"födde", "född"},
		{"föddes", "född"},
		{"födelse", "föd"},
		{"födelsedag", "födelsedag"},
		{"födelsedagar", "födelsedag"},
		{"födelsedagen", "födelsedag"},
		{"födelsedagens", "födelsedag"},
		{"födelsedagsbord", "födelsedagsbord"},
		{"födelsedagsbordet", "födelsedagsbordet"},
		{"födelsemysteriet", "födelsemysteriet"},
		{"födelsen", "föd"},
		{"födelser", "föd"},
		{"föder", "föd"},
		{"födes", "föd"},
		{"födgeni", "födgeni"},
		{"födslovåndor", "födslovånd"},
		{"föga", "fög"},
		{"föibi", "föibi"},
		{"föijt", "föijt"},
		{"föl", "föl"},
		{"följ", "följ"},
		{"följa", "följ"},
		{"följaktligen", "följakt"},
		{"följande", "följ"},
		{"följd", "följd"},
		{"följde", "följd"},
		{"följden", "följd"},
		{"följder", "följd"},
		{"följderna", "följd"},
		{"följdes", "följd"},
		{"följe", "följ"},
		{"följer", "följ"},
		{"följeslagare", "följeslag"},
		{"följeslagares", "följeslagar"},
		{"följeslagerska", "följeslagersk"},
		{"följetongen", "följetong"},
		{"följs", "följ"},
		{"följt", "följt"},
		{"föll", "föll"},
		{"fölle", "föll"},
		{"föllo", "föllo"},
		{"fömodan", "fömodan"},
		{"fömuftiga", "fömuft"},
		{"fön", "fön"},
		{"fönster", "fönst"},
		{"fönsterblecket", "fönsterblecket"},
		{"fönsterbrädet", "fönsterbrädet"},
		{"fönsterglaset", "fönsterglaset"},
		{"fönsterglugg", "fönsterglugg"},
		{"fönsterkarm", "fönsterkarm"},
		{"fönsterkarmen", "fönsterkarm"},
		{"fönsterkurtis", "fönsterkurtis"},
		{"fönsterluckor", "fönsterluck"},
		{"fönsterluften", "fönsterluft"},
		{"fönsterlufter", "fönsterluft"},
		{"fönsterlufterna", "fönsterluft"},
		{"fönsterna", "fönst"},
		{"fönsternas", "fönst"},
		{"fönsterpantomimen", "fönsterpantomim"},
		{"fönsterplats", "fönsterplat"},
		{"fönsterrader", "fönsterrad"},
		{"fönsterruta", "fönsterrut"},
		{"fönsterrutan", "fönsterrutan"},
		{"fönsterrutor", "fönsterrut"},
		{"fönsterrutorna", "fönsterrut"},
		{"fönsterspringorna", "fönsterspring"},
		{"fönstrct", "fönstrct"},
		{"fönstren", "fönstr"},
		{"fönstrens", "fönstr"},
		{"fönstret", "fönstret"},
		{"fönstrets", "fönstret"},
		{"för", "för"},
		{"föra", "för"},
		{"förakt", "förak"},
		{"förakta", "förak"},
		{"föraktad", "förak"},
		{"föraktade", "förak"},
		{"föraktande", "förak"},
		{"föraktar", "förak"},
		{"föraktare", "förak"},
		{"föraktas", "förak"},
		{"föraktfuilt", "föraktfuilt"},
		{"föraktlig", "förakt"},
		{"föraktliga", "förakt"},
		{"föraktligare", "förakt"},
		{"föraktligt", "förakt"},
		{"föranledd", "föranled"},
		{"föranledda", "föranled"},
		{"föranledde", "föranled"},
		{"föranlett", "föranlet"},
		{"föranstalta", "föranstalt"},
		{"förarga", "förarg"},
		{"förargad", "förarg"},
		{"förargade", "förarg"},
		{"förargat", "förarg"},
		{"förargelse", "förarg"},
		{"förarglige", "förarg"},
		{"förargligt", "förarg"},
		{"förarsätet", "förarsätet"},
		{"föras", "för"},
		{"förb", "förb"},
		{"förbanna", "förban"},
		{"förbannad", "förban"},
		{"förbannade", "förban"},
		{"förbannat", "förban"},
		{"förbannelse", "förbann"},
		{"förbannelser", "förbann"},
		{"förbarma", "förbarm"},
		{"förbarmade", "förbarm"},
		{"förbarmande", "förbarm"},
		{"förbarmare", "förbarm"},
		{"förbarme", "förbarm"},
		{"förbaskade", "förbask"},
		{"förbaskat", "förbask"},
		{"förbehallsamhet", "förbehallsam"},
		{"förbehåll", "förbehåll"},
		{"förbehållen", "förbehåll"},
		{"förbehåller", "förbehåll"},
		{"förbehållet", "förbehållet"},
		{"förbehållsamhet", "förbehållsam"},
		{"förbereda", "förbered"},
		{"förberedde", "förbered"},
		{"förberedelser", "förbered"},
		{"förberett", "förberet"},
		{"förbi", "förbi"},
		{"förbifarten", "förbifart"},
		{"förbiflytande", "förbiflyt"},
		{"förbigaende", "förbigaend"},
		{"förbigicks", "förbigick"},
		{"förbiglidande", "förbiglid"},
		{"förbigå", "förbigå"},
		{"förbigående", "förbigåend"},
		{"förbigåerlde", "förbigåerld"},
		{"förbiilande", "förbiil"},
		{"förbinclelse", "förbincl"},
		{"förbindelse", "förbind"},
		{"förbindelsen", "förbind"},
		{"förbindelser", "förbind"},
		{"förbindlig", "förbind"},
		{"förbindlighet", "förbind"},
		{"förbindligt", "förbind"},
		{"förbise", "förbis"},
		{"förbisedd", "förbised"},
		{"förbisedda", "förbised"},
		{"förbiser", "förbis"},
		{"förbistring", "förbistring"},
		{"förbisåg", "förbisåg"},
		{"förbittras", "förbittr"},
		{"förbittring", "förbittring"},
		{"förbjude", "förbjud"},
		{"förbjuder", "förbjud"},
		{"förbjudet", "förbjudet"},
		{"förbjudit", "förbjudit"},
		{"förbjudna", "förbjudn"},
		{"förbjöd", "förbjöd"},
		{"förblandat", "förbland"},
		{"förblef", "förblef"},
		{"förblev", "förblev"},
		{"förblevo", "förblevo"},
		{"förbli", "förbli"},
		{"förblifva", "förblifv"},
		{"förblindade", "förblind"},
		{"förblindadt", "förblindad"},
		{"förblindar", "förblind"},
		{"förblir", "förblir"},
		{"förbliv", "förbliv"},
		{"förblivande", "förbliv"},
		{"förbluffade", "förbluff"},
		{"förbluffande", "förbluff"},
		{"förborgade", "förborg"},
		{"förbrinna", "förbrin"},
		{"förbrinner", "förbrin"},
		{"förbrylla", "förbryll"},
		{"förbrytare", "förbryt"},
		{"förbrytelse", "förbryt"},
		{"förbrytelsen", "förbryt"},
		{"förbränd", "förbränd"},
		{"förbrända", "förbränd"},
		{"förbud", "förbud"},
		{"förbund", "förbund"},
		{"förbunde", "förbund"},
		{"förbunden", "förbund"},
		{"förbundit", "förbundit"},
		{"förbundna", "förbundn"},
		{"förbytt", "förbyt"},
		{"förbättra", "förbättr"},
		{"förbättrad", "förbättr"},
		{"förbättrades", "förbättr"},
		{"förbättradt", "förbättrad"},
		{"förbättrat", "förbättr"},
		{"förbättring", "förbättring"},
		{"förbålt", "förbålt"},
		{"förböner", "förbön"},
		{"förc", "förc"},
		{"förd", "förd"},
		{"förda", "förd"},
		{"förde", "förd"},
		{"fördel", "fördel"},
		{"fördelaktig", "fördelakt"},
		{"fördelaktigare", "fördelakt"},
		{"fördelaktigt", "fördelakt"},
		{"fördelande", "fördel"},
		{"fördelar", "fördel"},
		{"fördelningen", "fördelning"},
		{"förden", "förd"},
		{"fördenskull", "fördenskull"},
		{"förderfvet", "förderfvet"},
		{"fördes", "förd"},
		{"fördj", "fördj"},
		{"fördjekladt", "fördjeklad"},
		{"fördjupade", "fördjup"},
		{"fördjupningar", "fördjupning"},
		{"fördjupningen", "fördjupning"},
		{"fördolt", "fördolt"},
		{"fördom", "fördom"},
		{"fördomar", "fördom"},
		{"fördrag", "fördrag"},
		{"fördraga", "fördrag"},
		{"fördragsamhetens", "fördragsam"},
		{"fördrar", "fördr"},
		{"fördrevo", "fördrevo"},
		{"fördriva", "fördriv"},
		{"fördröja", "fördröj"},
		{"fördröjt", "fördröjt"},
		{"fördubblad", "fördubbl"},
		{"fördubblade", "fördubbl"},
		{"fördubbladt", "fördubblad"},
		{"fördunk", "fördunk"},
		{"fördärva", "fördärv"},
		{"fördärvar", "fördärv"},
		{"fördärvat", "fördärv"},
		{"fördärvet", "fördärvet"},
		{"fördöma", "fördöm"},
		{"fördömd", "fördömd"},
		{"fördömda", "fördömd"},
		{"fördömde", "fördömd"},
		{"fördöme", "fördöm"},
		{"fördömt", "fördömt"},
		{"före", "för"},
		{"förebilder", "förebild"},
		{"förebrå", "förebrå"},
		{"förebrådde", "förebråd"},
		{"förebråelse", "förebrå"},
		{"förebråelser", "förebrå"},
		{"förebrående", "förebråend"},
		{"förebud", "förebud"},
		{"förebygga", "förebygg"},
		{"föredrag", "föredrag"},
		{"föredrager", "föredrag"},
		{"föredraget", "föredraget"},
		{"föredragshållare", "föredragshåll"},
		{"föredrog", "föredrog"},
		{"föredöme", "föredöm"},
		{"förefalla", "förefall"},
		{"förefallande", "förefall"},
		{"förefaller", "förefall"},
		{"förefallit", "förefallit"},
		{"föreföll", "föreföll"},
		{"föreföllo", "föreföllo"},
		{"föregick", "föregick"},
		{"föregående", "föregåend"},
		{"föregångare", "föregång"},
		{"föregånget", "föregånget"},
		{"förehades", "föreh"},
		{"förehafvande", "förehafv"},
		{"förehafvandet", "förehafv"},
		{"förehavande", "förehav"},
		{"förehålla", "förehåll"},
		{"förekom", "förekom"},
		{"förekomma", "förekomm"},
		{"förekommande", "förekomm"},
		{"förekommandet", "förekomm"},
		{"förekommer", "förekomm"},
		{"förekommit", "förekommit"},
		{"förekommo", "förekommo"},
		{"förekoms", "förekom"},
		{"förelagt", "förelag"},
		{"föreligga", "föreligg"},
		{"föreligger", "föreligg"},
		{"föreläsning", "föreläsning"},
		{"föreläsningar", "föreläsning"},
		{"föreläsningssalarna", "föreläsningssal"},
		{"föremål", "föremål"},
		{"föremålen", "föremål"},
		{"föremålet", "föremålet"},
		{"fören", "för"},
		{"förena", "fören"},
		{"förenad", "fören"},
		{"förenade", "fören"},
		{"förenande", "fören"},
		{"förenar", "fören"},
		{"förenas", "fören"},
		{"förenat", "fören"},
		{"förening", "förening"},
		{"föreningsband", "föreningsband"},
		{"förer", "för"},
		{"förerska", "förersk"},
		{"föresats", "föresat"},
		{"föresatsen", "föresats"},
		{"föresatser", "föresats"},
		{"föresatt", "föresat"},
		{"föresatte", "föresat"},
		{"föreskrift", "föreskrift"},
		{"föreskrifter", "föreskrift"},
		{"föreslagit", "föreslagit"},
		{"föreslagna", "föreslagn"},
		{"föreslog", "föreslog"},
		{"föreslå", "föreslå"},
		{"förespel", "förespel"},
		{"förestallde", "förestalld"},
		{"förestavade", "förestav"},
		{"förestod", "förestod"},
		{"förestodo", "förestodo"},
		{"förestyr", "förestyr"},
		{"förestälde", "förestäld"},
		{"föreställa", "föreställ"},
		{"föreställande", "föreställ"},
		{"föreställda", "föreställd"},
		{"föreställde", "föreställd"},
		{"föreställdes", "föreställd"},
		{"föreställer", "föreställ"},
		{"föreställning", "föreställning"},
		{"föreställningar", "föreställning"},
		{"föreställningen", "föreställning"},
		{"föreställt", "föreställt"},
		{"förestält", "förestält"},
		{"förestå", "förestå"},
		{"förestående", "föreståend"},
		{"föreståndarinnan", "föreståndarinnan"},
		{"föreståndarinnans", "föreståndarinnan"},
		{"föreståndarinnorna", "föreståndarin"},
		{"föresvävade", "föresväv"},
		{"företa", "föret"},
		{"företag", "företag"},
		{"företaga", "företag"},
		{"företagas", "företag"},
		{"företager", "företag"},
		{"företaget", "företaget"},
		{"företagit", "företagit"},
		{"företagsam", "företagsam"},
		{"förete", "föret"},
		{"företedde", "företed"},
		{"företeelse", "förete"},
		{"företeelser", "förete"},
		{"företog", "företog"},
		{"företogo", "företogo"},
		{"företrädare", "företräd"},
		{"företräde", "företräd"},
		{"företräden", "företräd"},
		{"företrädesvis", "företrädesvis"},
		{"företrädet", "företrädet"},
		{"förevändning", "förevändning"},
		{"förevändningar", "förevändning"},
		{"förevändningen", "förevändning"},
		{"förfall", "förfall"},
		{"förfalla", "förfall"},
		{"förfallen", "förfall"},
		{"förfallodagen", "förfallodag"},
		{"förfalskare", "förfalsk"},
		{"förfalskat", "förfalsk"},
		{"förfara", "förfar"},
		{"förfarit", "förfarit"},
		{"förfaslig", "förfas"},
		{"förfasligt", "förfas"},
		{"författare", "förfat"},
		{"författaren", "förfat"},
		{"författarskap", "författarskap"},
		{"författat", "förfat"},
		{"författats", "författat"},
		{"förfelade", "förfel"},
		{"förfinade", "förfin"},
		{"förfluget", "förfluget"},
		{"förfluten", "förflut"},
		{"förflutit", "förflutit"},
		{"förflutna", "förflutn"},
		{"förflyktigad", "förflykt"},
		{"förflyktigat", "förflykt"},
		{"förflytta", "förflyt"},
		{"förflöt", "förflöt"},
		{"förflöto", "förflöto"},
		{"förfoga", "förfog"},
		{"förfogade", "förfog"},
		{"förfogande", "förfog"},
		{"förfogar", "förfog"},
		{"förfriskas", "förfrisk"},
		{"förfriskning", "förfriskning"},
		{"förfriskningar", "förfriskning"},
		{"förfrusen", "förfrus"},
		{"förfrusna", "förfrusn"},
		{"förfrusne", "förfrusn"},
		{"förfrysa", "förfrys"},
		{"förfrågningar", "förfrågning"},
		{"förfäder", "förfäd"},
		{"förfäiligt", "förfäi"},
		{"förfärad", "förfär"},
		{"förfäran", "förfäran"},
		{"förfärande", "förfär"},
		{"förfäras", "förfär"},
		{"förfärdigats", "förfärdigat"},
		{"förfärlig", "förfär"},
		{"förfärliga", "förfär"},
		{"förfärligare", "förfär"},
		{"förfärligaste", "förfär"},
		{"förfärligt", "förfär"},
		{"förföljaren", "förfölj"},
		{"förföljd", "förföljd"},
		{"förföljde", "förföljd"},
		{"förföljdes", "förföljd"},
		{"förföljelsevansinne", "förföljelsevansin"},
		{"förföljer", "förfölj"},
		{"förföljes", "förfölj"},
		{"förföljs", "förfölj"},
		{"förföljt", "förföljt"},
		{"förföll", "förföll"},
		{"förföllo", "förföllo"},
		{"förföra", "förför"},
		{"förföraren", "förför"},
		{"förförares", "förförar"},
		{"förförelse", "förför"},
		{"förförelsen", "förför"},
		{"förföriska", "förförisk"},
		{"förföriskt", "förförisk"},
		{"förfört", "förfört"},
		{"förgallrade", "förgallr"},
		{"förge", "förg"},
		{"förgick", "förgick"},
		{"förgicks", "förgick"},
		{"förgifta", "förgift"},
		{"förgiftad", "förgift"},
		{"förgiftade", "förgift"},
		{"förgiftat", "förgift"},
		{"förgingo", "förgingo"},
		{"förglömma", "förglömm"},
		{"förgripa", "förgrip"},
		{"förgrunden", "förgrund"},
		{"förgrämda", "förgrämd"},
		{"förgråten", "förgråt"},
		{"förgudade", "förgud"},
		{"förgudning", "förgudning"},
		{"förgylda", "förgyld"},
		{"förgylla", "förgyll"},
		{"förgylld", "förgylld"},
		{"förgyllda", "förgylld"},
		{"förgyllde", "förgylld"},
		{"förgyllning", "förgyllning"},
		{"förgyllt", "förgyllt"},
		{"förgäfves", "förgäfv"},
		{"förgängelse", "förgäng"},
		{"förgängelsen", "förgäng"},
		{"förgängelsens", "förgäng"},
		{"förgängliga", "förgäng"},
		{"förgät", "förgät"},
		{"förgäta", "förgät"},
		{"förgätande", "förgät"},
		{"förgäter", "förgät"},
		{"förgätit", "förgätit"},
		{"förgäves", "förgäv"},
		{"förgången", "förgång"},
		{"förgångna", "förgångn"},
		{"förgår", "förgår"},
		{"förgården", "förgård"},
		{"förgårs", "förgår"},
		{"förgåtts", "förgåt"},
		{"förgör", "förgör"},
		{"förgöra", "förgör"},
		{"förhand", "förhand"},
		{"förhasta", "förhast"},
		{"förhastad", "förhast"},
		{"förhastade", "förhast"},
		{"förhatlig", "förhat"},
		{"förhatliga", "förhat"},
		{"förhexad", "förhex"},
		{"förhinder", "förhind"},
		{"förhindra", "förhindr"},
		{"förhoppning", "förhoppning"},
		{"förhoppningar", "förhoppning"},
		{"förhoppningen", "förhoppning"},
		{"förhoppningens", "förhoppning"},
		{"förhoppningsfull", "förhoppningsfull"},
		{"förhänge", "förhäng"},
		{"förhäpnade", "förhäpn"},
		{"förhärdade", "förhärd"},
		{"förhärdadt", "förhärdad"},
		{"förhäxade", "förhäx"},
		{"förhålla", "förhåll"},
		{"förhållande", "förhåll"},
		{"förhållanden", "förhåll"},
		{"förhållandena", "förhållanden"},
		{"förhållandet", "förhåll"},
		{"förhållen", "förhåll"},
		{"förhåller", "förhåll"},
		{"förhöjda", "förhöjd"},
		{"förhöjdes", "förhöjd"},
		{"förhöjning", "förhöjning"},
		{"förhöll", "förhöll"},
		{"förhör", "förhör"},
		{"förhöra", "förhör"},
		{"förhöret", "förhöret"},
		{"förifra", "förifr"},
		{"förintas", "förint"},
		{"förirrade", "förirr"},
		{"förirrat", "förirr"},
		{"förjaga", "förjag"},
		{"förjagad", "förjag"},
		{"förjagades", "förjag"},
		{"förjagat", "förjag"},
		{"förkasta", "förkast"},
		{"förkastade", "förkast"},
		{"förkastat", "förkast"},
		{"förkastelsedom", "förkastelsedom"},
		{"förklara", "förklar"},
		{"förklarad", "förklar"},
		{"förklarade", "förklar"},
		{"förklarande", "förklar"},
		{"förklarar", "förklar"},
		{"förklaras", "förklar"},
		{"förklarat", "förklar"},
		{"förklaring", "förklaring"},
		{"förklaringen", "förklaring"},
		{"förklarlig", "förklar"},
		{"förklemade", "förklem"},
		{"förklingar", "förkling"},
		{"förklädde", "förkläd"},
		{"förkläde", "förkläd"},
		{"förkläden", "förkläd"},
		{"förklädet", "förklädet"},
		{"förklädnad", "förklädn"},
		{"förknappningar", "förknappning"},
		{"förknippade", "förknipp"},
		{"förkofran", "förkofran"},
		{"förkolna", "förkoln"},
		{"förkorta", "förkort"},
		{"förkortning", "förkortning"},
		{"förkovrar", "förkovr"},
		{"förkroppsligade", "förkropps"},
		{"förkrossande", "förkross"},
		{"förkrossat", "förkross"},
		{"förkrosselsens", "förkross"},
		{"förkrympta", "förkrympt"},
		{"förkunna", "förkun"},
		{"förkunnade", "förkun"},
		{"förkunnare", "förkun"},
		{"förkunnelse", "förkunn"},
		{"förkyla", "förkyl"},
		{"förkyld", "förkyld"},
		{"förkyler", "förkyl"},
		{"förkylning", "förkylning"},
		{"förkylt", "förkylt"},
		{"förkänning", "förkänning"},
		{"förkänsla", "förkänsl"},
		{"förkänslan", "förkänslan"},
		{"förkärlek", "förkärlek"},
		{"förlag", "förlag"},
		{"förlaga", "förlag"},
		{"förlagan", "förlagan"},
		{"förlama", "förlam"},
		{"förlamande", "förlam"},
		{"förlamning", "förlamning"},
		{"förlast", "förl"},
		{"förlata", "förlat"},
		{"förledande", "förled"},
		{"förledas", "förled"},
		{"förledd", "förled"},
		{"förlidna", "förlidn"},
		{"förlig", "för"},
		{"förlika", "förlik"},
		{"förliktes", "förlik"},
		{"förlist", "förlist"},
		{"förlita", "förlit"},
		{"förlitande", "förlit"},
		{"förljufvade", "förljufv"},
		{"förlofning", "förlofning"},
		{"förlopp", "förlopp"},
		{"förlora", "förlor"},
		{"förlorad", "förlor"},
		{"förlorade", "förlor"},
		{"förloradt", "förlorad"},
		{"förlorar", "förlor"},
		{"förloras", "förlor"},
		{"förlorat", "förlor"},
		{"förlossa", "förloss"},
		{"förlossning", "förlossning"},
		{"förlossningen", "förlossning"},
		{"förlossningsbord", "förlossningsbord"},
		{"förlossningsborden", "förlossningsbord"},
		{"förlossningsbordet", "förlossningsbordet"},
		{"förlossningshem", "förlossningshem"},
		{"förlossningshemmet", "förlossningshemmet"},
		{"förlossningspraktikens", "förlossningspraktik"},
		{"förlossningsrummet", "förlossningsrummet"},
		{"förlossningssalar", "förlossningssal"},
		{"förlossningssalen", "förlossningssal"},
		{"förlossningstänger", "förlossningstäng"},
		{"förlov", "förlov"},
		{"förlova", "förlov"},
		{"förlovad", "förlov"},
		{"förlovade", "förlov"},
		{"förlovat", "förlov"},
		{"förlovingskalaset", "förlovingskalaset"},
		{"förlovning", "förlovning"},
		{"förlovningar", "förlovning"},
		{"förlovningen", "förlovning"},
		{"förlovningskalaset", "förlovningskalaset"},
		{"förlovningskyssen", "förlovningskyss"},
		{"förlovningsring", "förlovningsring"},
		{"förlust", "förlust"},
		{"förlustelse", "förlust"},
		{"förlustelser", "förlust"},
		{"förlustelseställen", "förlustelseställ"},
		{"förlusten", "förlust"},
		{"förlägen", "förläg"},
		{"förlägenhet", "förlägen"},
		{"förläget", "förläget"},
		{"förläggare", "förlägg"},
		{"förlägna", "förlägn"},
		{"förlänga", "förläng"},
		{"förlängd", "förläng"},
		{"förlät", "förlät"},
		{"förlåt", "förlåt"},
		{"förlåta", "förlåt"},
		{"förlåtas", "förlåt"},
		{"förlåte", "förlåt"},
		{"förlåtelse", "förlåt"},
		{"förlåter", "förlåt"},
		{"förlåtit", "förlåtit"},
		{"förlåtlig", "förlåt"},
		{"förlåtliga", "förlåt"},
		{"förlåtligt", "förlåt"},
		{"förlöjliga", "förlöj"},
		{"förlöjligande", "förlöj"},
		{"förlösande", "förlös"},
		{"förlöstes", "förlös"},
		{"förmadde", "förmad"},
		{"förmak", "förmak"},
		{"förmaket", "förmaket"},
		{"förman", "förman"},
		{"förmana", "förman"},
		{"förmanade", "förman"},
		{"förmanande", "förman"},
		{"förmanen", "förman"},
		{"förmaning", "förmaning"},
		{"förmaningar", "förmaning"},
		{"förmaningen", "förmaning"},
		{"förmans", "förman"},
		{"förmasten", "förmast"},
		{"förmening", "förmening"},
		{"förmiddag", "förmiddag"},
		{"förmiddagarna", "förmiddag"},
		{"förmiddagarne", "förmiddag"},
		{"förmiddagen", "förmiddag"},
		{"förmiddagens", "förmiddag"},
		{"förmiddags", "förmiddag"},
		{"förmiddagsdräkt", "förmiddagsdräk"},
		{"förmiddagsvandring", "förmiddagsvandring"},
		{"förmiddagsvisiterna", "förmiddagsvisit"},
		{"förmildrad", "förmildr"},
		{"förmildrade", "förmildr"},
		{"förmildrat", "förmildr"},
		{"förminskning", "förminskning"},
		{"förmoda", "förmod"},
		{"förmodade", "förmod"},
		{"förmodan", "förmodan"},
		{"förmodar", "förmod"},
		{"förmodat", "förmod"},
		{"förmodligen", "förmod"},
		{"förmyndare", "förmynd"},
		{"förmyndaren", "förmynd"},
		{"förmän", "förmän"},
		{"förmärka", "förmärk"},
		{"förmärkte", "förmärk"},
		{"förmärs", "förmär"},
		{"förmätet", "förmätet"},
		{"förmätliga", "förmät"},
		{"förmå", "förmå"},
		{"förmådde", "förmåd"},
		{"förmåga", "förmåg"},
		{"förmågan", "förmågan"},
		{"förmål", "förmål"},
		{"förmån", "förmån"},
		{"förmånen", "förmån"},
		{"förmåner", "förmån"},
		{"förmånlig", "förmån"},
		{"förmånliga", "förmån"},
		{"förmånligare", "förmån"},
		{"förmånligast", "förmån"},
		{"förmånligt", "förmån"},
		{"förmår", "förmår"},
		{"förmås", "förmås"},
		{"förmått", "förmåt"},
		{"förmögen", "förmög"},
		{"förmögenhet", "förmögen"},
		{"förmögenheten", "förmögen"},
		{"förmögenheter", "förmögen"},
		{"förmögna", "förmögn"},
		{"förmögnare", "förmögn"},
		{"förmörkar", "förmörk"},
		{"förnam", "förnam"},
		{"förnamn", "förnamn"},
		{"förnedrad", "förnedr"},
		{"förnedrade", "förnedr"},
		{"förnedrande", "förnedr"},
		{"förnedring", "förnedring"},
		{"förneka", "förnek"},
		{"förnekar", "förnek"},
		{"förnimma", "förnimm"},
		{"förnimmelse", "förnimm"},
		{"förnimmelser", "förnimm"},
		{"förning", "förning"},
		{"förnuft", "förnuft"},
		{"förnuftet", "förnuftet"},
		{"förnuftets", "förnuftet"},
		{"förnuftig", "förnuft"},
		{"förnuftiga", "förnuft"},
		{"förnuftigare", "förnuft"},
		{"förnuftigas", "förnuft"},
		{"förnuftigt", "förnuft"},
		{"förnuftsslut", "förnuftsslut"},
		{"förnummit", "förnummit"},
		{"förnummo", "förnummo"},
		{"förnya", "förny"},
		{"förnyad", "förny"},
		{"förnyade", "förny"},
		{"förnyades", "förny"},
		{"förnyas", "förny"},
		{"förnyat", "förny"},
		{"förnäm", "förnäm"},
		{"förnäma", "förnäm"},
		{"förnämare", "förnäm"},
		{"förnämaste", "förnäm"},
		{"förnämhet", "förnäm"},
		{"förnämligast", "förnäm"},
		{"förnämligt", "förnäm"},
		{"förnämsta", "förnämst"},
		{"förnämt", "förnämt"},
		{"förnärmad", "förnärm"},
		{"förnärmat", "förnärm"},
		{"förnödenheter", "förnöden"},
		{"förnöj", "förnöj"},
		{"förnöjd", "förnöjd"},
		{"förnöjda", "förnöjd"},
		{"förnöjde", "förnöjd"},
		{"förnöjdt", "förnöjd"},
		{"förnöjelse", "förnöj"},
		{"förnöjsamhet", "förnöjsam"},
		{"förnöjt", "förnöjt"},
		{"förnötte", "förnöt"},
		{"förolyckade", "förolyck"},
		{"förolyckades", "förolyck"},
		{"förolyckadt", "förolyckad"},
		{"förolämpad", "förolämp"},
		{"förolämpade", "förolämp"},
		{"förolämpar", "förolämp"},
		{"förolämpas", "förolämp"},
		{"förolämpat", "förolämp"},
		{"förolämpning", "förolämpning"},
		{"förolämpningen", "förolämpning"},
		{"förord", "förord"},
		{"förordnande", "förordn"},
		{"förordnandet", "förordn"},
		{"förordnat", "förordn"},
		{"förorsaka", "förorsak"},
		{"förorsakade", "förorsak"},
		{"förorsakat", "förorsak"},
		{"förorättade", "förorät"},
		{"förpestat", "förpest"},
		{"förr", "förr"},
		{"förra", "förr"},
		{"förras", "förr"},
		{"förre", "förr"},
		{"förres", "förr"},
		{"förrgår", "förrgår"},
		{"förringar", "förring"},
		{"förrmak", "förrmak"},
		{"förrstolpiga", "förrstolp"},
		{"förrunne", "förrun"},
		{"förruttnade", "förruttn"},
		{"förruttnelse", "förruttn"},
		{"förryckt", "förryck"},
		{"förryckta", "förryck"},
		{"förräderi", "förräderi"},
		{"förrädisk", "förrädisk"},
		{"förrädiska", "förrädisk"},
		{"förrädiske", "förrädisk"},
		{"förrädiskt", "förrädisk"},
		{"förrän", "förrän"},
		{"förråd", "förråd"},
		{"förråda", "förråd"},
		{"förrådande", "förråd"},
		{"förrådd", "förråd"},
		{"förrådde", "förråd"},
		{"förråder", "förråd"},
		{"förrådskamrar", "förrådskamr"},
		{"förrådt", "förråd"},
		{"förrått", "förråt"},
		{"försagd", "försag"},
		{"försagde", "försag"},
		{"försagt", "försag"},
		{"försaka", "försak"},
		{"försakade", "försak"},
		{"försakar", "försak"},
		{"försakat", "försak"},
		{"försakelse", "försak"},
		{"försakelsen", "försak"},
		{"försakelsens", "försak"},
		{"försakelser", "försak"},
		{"försakrade", "försakr"},
		{"försam", "försam"},
		{"församlade", "församl"},
		{"församladt", "församlad"},
		{"församling", "församling"},
		{"församlingen", "församling"},
		{"församlingens", "församling"},
		{"försatt", "försat"},
		{"försatte", "försat"},
		{"försattes", "försat"},
		{"förse", "förs"},
		{"försedd", "försed"},
		{"försedda", "försed"},
		{"försedt", "försed"},
		{"förseelse", "förse"},
		{"förseglade", "försegl"},
		{"försenad", "försen"},
		{"försett", "förset"},
		{"försiggick", "försiggick"},
		{"försigginge", "försigging"},
		{"försiggingo", "försiggingo"},
		{"försiggår", "försiggår"},
		{"försiggått", "försiggåt"},
		{"försigtig", "försigt"},
		{"försigtighet", "försigt"},
		{"försigtigt", "försigt"},
		{"försik", "försik"},
		{"försiktig", "försikt"},
		{"försiktiga", "försikt"},
		{"försiktighet", "försikt"},
		{"försiktighetsmått", "försiktighetsmåt"},
		{"försiktighetspredikan", "försiktighetspredikan"},
		{"försiktigt", "försikt"},
		{"försiktigtvis", "försiktigtvis"},
		{"försjunka", "försjunk"},
		{"försjunkna", "försjunkn"},
		{"försjönk", "försjönk"},
		{"förskaffade", "förskaff"},
		{"förskaffar", "förskaff"},
		{"förskaffat", "förskaff"},
		{"förskjuten", "förskjut"},
		{"förskjuter", "förskjut"},
		{"förskjutit", "förskjutit"},
		{"förskjutne", "förskjutn"},
		{"förskona", "förskon"},
		{"förskonad", "förskon"},
		{"förskott", "förskot"},
		{"förskrev", "förskrev"},
		{"förskräckelse", "förskräck"},
		{"förskräckes", "förskräck"},
		{"förskräckiigt", "förskräcki"},
		{"förskräcklig", "förskräck"},
		{"förskräckliga", "förskräck"},
		{"förskräckligaste", "förskräck"},
		{"förskräckligt", "förskräck"},
		{"förskräckt", "förskräck"},
		{"förskräckta", "förskräck"},
		{"förskrämd", "förskrämd"},
		{"förskrämda", "förskrämd"},
		{"förskrämt", "förskrämt"},
		{"förskyllan", "förskyllan"},
		{"försköna", "förskön"},
		{"förskönandet", "förskön"},
		{"försköningar", "försköning"},
		{"försköte", "försköt"},
		{"förslag", "förslag"},
		{"förslaget", "förslaget"},
		{"förslagets", "förslaget"},
		{"förslappade", "förslapp"},
		{"förslog", "förslog"},
		{"förslår", "förslår"},
		{"försmak", "försmak"},
		{"försmaken", "försmak"},
		{"försmädelse", "försmäd"},
		{"försmädlig", "försmäd"},
		{"försmädligt", "försmäd"},
		{"försmå", "försmå"},
		{"försmådd", "försmåd"},
		{"försmådda", "försmåd"},
		{"försmådde", "försmåd"},
		{"försmår", "försmår"},
		{"försmått", "försmåt"},
		{"försoffas", "försoff"},
		{"försofva", "försofv"},
		{"försoka", "försok"},
		{"försona", "förson"},
		{"försonad", "förson"},
		{"försonade", "förson"},
		{"försonande", "förson"},
		{"försonat", "förson"},
		{"försoning", "försoning"},
		{"försoningen", "försoning"},
		{"försoningsfanan", "försoningsfanan"},
		{"försonligt", "förson"},
		{"försorg", "försorg"},
		{"försover", "försov"},
		{"förspeglingen", "förspegling"},
		{"förspelet", "förspelet"},
		{"förspildt", "förspild"},
		{"förspilla", "förspill"},
		{"förspilld", "förspilld"},
		{"förspillda", "förspilld"},
		{"förspilt", "förspilt"},
		{"förspordes", "förspord"},
		{"försprång", "försprång"},
		{"förspända", "förspänd"},
		{"förspänt", "förspänt"},
		{"först", "först"},
		{"första", "först"},
		{"förstadsgata", "förstadsgat"},
		{"förstar", "först"},
		{"förstas", "först"},
		{"förstasida", "förstasid"},
		{"förste", "först"},
		{"förstenad", "försten"},
		{"förstenade", "försten"},
		{"förstfödde", "förstföd"},
		{"förstfödslorätt", "förstfödslorät"},
		{"förstklassigt", "förstklass"},
		{"förstkommande", "förstkomm"},
		{"förstnämda", "förstnämd"},
		{"förstod", "förstod"},
		{"förstodo", "förstodo"},
		{"förstorad", "förstor"},
		{"förstorade", "förstor"},
		{"förstorades", "förstor"},
		{"försträcka", "försträck"},
		{"försträckte", "försträck"},
		{"förströ", "förströ"},
		{"förströdd", "förströd"},
		{"förströelse", "förströ"},
		{"förströelser", "förströ"},
		{"förströs", "förströs"},
		{"förstrött", "förströt"},
		{"förstubro", "förstubro"},
		{"förstucken", "förstuck"},
		{"förstudörrn", "förstudörrn"},
		{"förstuga", "förstug"},
		{"förstugan", "förstugan"},
		{"förstugkvisten", "förstugkvist"},
		{"förstugubron", "förstugubron"},
		{"förstugudörren", "förstugudörr"},
		{"förstuguqvistarne", "förstuguqvist"},
		{"förstuguqvisten", "förstuguqvist"},
		{"förstulen", "förstul"},
		{"förstulet", "förstulet"},
		{"förstulna", "förstuln"},
		{"förstummad", "förstumm"},
		{"förstummades", "förstumm"},
		{"förstälda", "förstäld"},
		{"förställa", "förställ"},
		{"förställd", "förställd"},
		{"förställda", "förställd"},
		{"förställing", "förställing"},
		{"förställning", "förställning"},
		{"förstämd", "förstämd"},
		{"förstämda", "förstämd"},
		{"förständiga", "förständ"},
		{"förstärka", "förstärk"},
		{"förstärkt", "förstärk"},
		{"förstå", "förstå"},
		{"förståelse", "förstå"},
		{"förstående", "förståend"},
		{"förstånd", "förstånd"},
		{"förståndet", "förståndet"},
		{"förståndets", "förståndet"},
		{"förståndig", "förstånd"},
		{"förståndiga", "förstånd"},
		{"förståndigare", "förstånd"},
		{"förståndigt", "förstånd"},
		{"förstår", "förstår"},
		{"förstås", "förstås"},
		{"förstått", "förståt"},
		{"förstör", "förstör"},
		{"förstöra", "förstör"},
		{"förstörande", "förstör"},
		{"förstörd", "förstörd"},
		{"förstörda", "förstörd"},
		{"förstörde", "förstörd"},
		{"förstörelsen", "förstör"},
		{"förstörs", "förstör"},
		{"förstört", "förstört"},
		{"försumlighet", "försum"},
		{"försumma", "försumm"},
		{"försummade", "försumm"},
		{"försummadt", "försummad"},
		{"försummas", "försumm"},
		{"försummat", "försumm"},
		{"försummelse", "försumm"},
		{"försupen", "försup"},
		{"försupna", "försupn"},
		{"försutten", "försut"},
		{"försvaga", "försvag"},
		{"försvagad", "försvag"},
		{"försvagade", "försvag"},
		{"försvagat", "försvag"},
		{"försvann", "försvan"},
		{"försvar", "försv"},
		{"försvara", "försvar"},
		{"försvarade", "försvar"},
		{"försvarare", "försvar"},
		{"försvarligt", "försvar"},
		{"försvinna", "försvin"},
		{"försvinnande", "försvin"},
		{"försvinner", "försvin"},
		{"försvunn", "försvun"},
		{"försvunna", "försvun"},
		{"försvunne", "försvun"},
		{"försvunnen", "försvun"},
		{"försvunnet", "försvunnet"},
		{"försvunnit", "försvunnit"},
		{"försvunno", "försvunno"},
		{"försyn", "försyn"},
		{"försynen", "försyn"},
		{"försäkra", "försäkr"},
		{"försäkrade", "försäkr"},
		{"försäkran", "försäkran"},
		{"försäkrar", "försäkr"},
		{"försäkrat", "försäkr"},
		{"försäkringar", "försäkring"},
		{"försäljarna", "försälj"},
		{"försäljning", "försäljning"},
		{"försände", "försänd"},
		{"försätta", "försät"},
		{"försåtligt", "försåt"},
		{"försök", "försök"},
		{"försöka", "försök"},
		{"försöker", "försök"},
		{"försöket", "försöket"},
		{"försökt", "försök"},
		{"försökte", "försök"},
		{"försörjningsinrättningar", "försörjningsinrättning"},
		{"fört", "fört"},
		{"förtaga", "förtag"},
		{"förtager", "förtag"},
		{"förtagit", "förtagit"},
		{"förtal", "förtal"},
		{"förtala", "förtal"},
		{"förteg", "förteg"},
		{"förtegat", "förteg"},
		{"förteget", "förteget"},
		{"förtid", "förtid"},
		{"förtiga", "fört"},
		{"förtigas", "fört"},
		{"förtjena", "förtjen"},
		{"förtjenar", "förtjen"},
		{"förtjenst", "förtjenst"},
		{"förtjensten", "förtjenst"},
		{"förtjenster", "förtjenst"},
		{"förtjenstfull", "förtjenstfull"},
		{"förtjenstfullare", "förtjenstfull"},
		{"förtjent", "förtjent"},
		{"förtjusande", "förtjus"},
		{"förtjusning", "förtjusning"},
		{"förtjust", "förtjust"},
		{"förtjusta", "förtjust"},
		{"förtjuste", "förtjust"},
		{"förtjäna", "förtjän"},
		{"förtjänade", "förtjän"},
		{"förtjänar", "förtjän"},
		{"förtjänst", "förtjänst"},
		{"förtjänster", "förtjänst"},
		{"förtjänstfulla", "förtjänstfull"},
		{"förtjänstfullt", "förtjänstfull"},
		{"förtjänt", "förtjänt"},
		{"förtjänte", "förtjänt"},
		{"förtoppen", "förtopp"},
		{"förtorkade", "förtork"},
		{"förtret", "förtret"},
		{"förtreta", "förtret"},
		{"förtretad", "förtret"},
		{"förtretat", "förtret"},
		{"förtreten", "förtret"},
		{"förtreter", "förtret"},
		{"förtretliga", "förtret"},
		{"förtretlighet", "förtret"},
		{"förtretligheter", "förtret"},
		{"förtro", "förtro"},
		{"förtrodde", "förtrod"},
		{"förtroende", "förtroend"},
		{"förtroendebefattningar", "förtroendebefattning"},
		{"förtroendefullt", "förtroendefull"},
		{"förtroenden", "förtroend"},
		{"förtroendet", "förtroendet"},
		{"förtroendeväckande", "förtroendeväck"},
		{"förtrogen", "förtrog"},
		{"förtrogna", "förtrogn"},
		{"förtrogne", "förtrogn"},
		{"förtrolig", "förtro"},
		{"förtroliga", "förtro"},
		{"förtroligare", "förtro"},
		{"förtroligaste", "förtro"},
		{"förtrolighet", "förtro"},
		{"förtroligheten", "förtro"},
		{"förtroligt", "förtro"},
		{"förtrolla", "förtroll"},
		{"förtrollade", "förtroll"},
		{"förtrollades", "förtroll"},
		{"förtrollande", "förtroll"},
		{"förtrollat", "förtroll"},
		{"förtrollats", "förtrollat"},
		{"förtrollerska", "förtrollersk"},
		{"förtrollning", "förtrollning"},
		{"förtror", "förtr"},
		{"förtrott", "förtrot"},
		{"förtrytelse", "förtryt"},
		{"förtrytelsen", "förtryt"},
		{"förtrytelsens", "förtryt"},
		{"förtryter", "förtryt"},
		{"förtrytsamt", "förtrytsamt"},
		{"förträfflig", "förträff"},
		{"förträffliga", "förträff"},
		{"förträffligaste", "förträff"},
		{"förträfflige", "förträff"},
		{"förträffligt", "förträff"},
		{"förtrösta", "förtröst"},
		{"förtröstan", "förtröstan"},
		{"förtröstande", "förtröst"},
		{"förtröstansfullt", "förtröstansfull"},
		{"förtröstar", "förtröst"},
		{"förtröt", "förtröt"},
		{"förts", "fört"},
		{"förtunnades", "förtun"},
		{"förtvifladt", "förtviflad"},
		{"förtviflan", "förtviflan"},
		{"förtvina", "förtvin"},
		{"förtvivlad", "förtvivl"},
		{"förtvivlade", "förtvivl"},
		{"förtvivlan", "förtvivlan"},
		{"förtvivlat", "förtvivl"},
		{"förty", "förty"},
		{"förtäckta", "förtäck"},
		{"förtälja", "förtälj"},
		{"förtäljde", "förtäljd"},
		{"förtäljer", "förtälj"},
		{"förtäljt", "förtäljt"},
		{"förtära", "förtär"},
		{"förtärande", "förtär"},
		{"förtärd", "förtärd"},
		{"förtärde", "förtärd"},
		{"förtärdes", "förtärd"},
		{"förtärs", "förtär"},
		{"förtätade", "förtät"},
		{"förtöjd", "förtöjd"},
		{"förtörd", "förtörd"},
		{"förtörnad", "förtörn"},
		{"förunderlig", "förunder"},
		{"förunderliga", "förunder"},
		{"förundra", "förundr"},
		{"förundrad", "förundr"},
		{"förundrade", "förundr"},
		{"förundran", "förundran"},
		{"förundrar", "förundr"},
		{"förunnat", "förun"},
		{"förut", "förut"},
		{"förutsatt", "förutsat"},
		{"förutse", "föruts"},
		{"förutser", "föruts"},
		{"förutses", "föruts"},
		{"förutsett", "förutset"},
		{"förutsätter", "förutsät"},
		{"förutsättningen", "förutsättning"},
		{"förvanad", "förvan"},
		{"förvandla", "förvandl"},
		{"förvandlad", "förvandl"},
		{"förvandlade", "förvandl"},
		{"förvandlades", "förvandl"},
		{"förvandlande", "förvandl"},
		{"förvandlar", "förvandl"},
		{"förvandlas", "förvandl"},
		{"förvandlat", "förvandl"},
		{"förvandling", "förvandling"},
		{"förvandlingen", "förvandling"},
		{"förvandlingens", "förvandling"},
		{"förvandlingsverk", "förvandlingsverk"},
		{"förvar", "förv"},
		{"förvara", "förvar"},
		{"förvarade", "förvar"},
		{"förvarades", "förvar"},
		{"förvarar", "förvar"},
		{"förvaras", "förvar"},
		{"förvarat", "förvar"},
		{"förvaringsrum", "förvaringsrum"},
		{"förverkligas", "förverk"},
		{"förvildade", "förvild"},
		{"förvilla", "förvill"},
		{"förvillade", "förvill"},
		{"förvillande", "förvill"},
		{"förvillas", "förvill"},
		{"förvillelse", "förvill"},
		{"förvirrad", "förvirr"},
		{"förvirradc", "förvirradc"},
		{"förvirrade", "förvirr"},
		{"förvirrande", "förvirr"},
		{"förvirras", "förvirr"},
		{"förvirrat", "förvirr"},
		{"förvirring", "förvirring"},
		{"förvirringen", "förvirring"},
		{"förvisad", "förvis"},
		{"förvissa", "förviss"},
		{"förvissad", "förviss"},
		{"förvissade", "förviss"},
		{"förvissar", "förviss"},
		{"förvissat", "förviss"},
		{"förvisso", "förvisso"},
		{"förvreds", "förvred"},
		{"förvrida", "förvrid"},
		{"förvriden", "förvrid"},
		{"förvridet", "förvridet"},
		{"förvridna", "förvridn"},
		{"förvrängd", "förvräng"},
		{"förvägna", "förvägn"},
		{"förvälvas", "förvälv"},
		{"förvänad", "förvän"},
		{"förvänd", "förvänd"},
		{"förväntan", "förväntan"},
		{"förväntansfull", "förväntansfull"},
		{"förväntansfulla", "förväntansfull"},
		{"förväntningar", "förväntning"},
		{"förvärfva", "förvärfv"},
		{"förvärfvade", "förvärfv"},
		{"förvärfvadt", "förvärfvad"},
		{"förvärfvat", "förvärfv"},
		{"förvärrar", "förvärr"},
		{"förvärva", "förvärv"},
		{"förvärvad", "förvärv"},
		{"förvärvade", "förvärv"},
		{"förvärvat", "förvärv"},
		{"förvärvt", "förvärvt"},
		{"förväxling", "förväxling"},
		{"förvåna", "förvån"},
		{"förvånad", "förvån"},
		{"förvånade", "förvån"},
		{"förvånades", "förvån"},
		{"förvånande", "förvån"},
		{"förvånar", "förvån"},
		{"förvånat", "förvån"},
		{"förvåning", "förvåning"},
		{"förvånint", "förvånint"},
		{"förvåren", "förvår"},
		{"föryngrad", "föryngr"},
		{"förädlande", "förädl"},
		{"förädlar", "förädl"},
		{"föräldragården", "föräldragård"},
		{"föräldralösa", "föräldralös"},
		{"föräldralöst", "föräldralös"},
		{"föräldrar", "föräldr"},
		{"föräldrarna", "föräldr"},
		{"föräldrarnas", "föräldr"},
		{"föräldrarne", "föräldr"},
		{"föräldrars", "föräldrar"},
		{"förälskad", "förälsk"},
		{"förälskade", "förälsk"},
		{"förälskat", "förälsk"},
		{"förälskelse", "förälsk"},
		{"föränderlighet", "föränder"},
		{"förändra", "förändr"},
		{"förändrad", "förändr"},
		{"förändrades", "förändr"},
		{"förändras", "förändr"},
		{"förändrat", "förändr"},
		{"förändring", "förändring"},
		{"förändringar", "förändring"},
		{"förändringen", "förändring"},
		{"förärat", "förär"},
		{"föråldrad", "föråldr"},
		{"föråldrade", "föråldr"},
		{"föråldrat", "föråldr"},
		{"förödd", "föröd"},
		{"förödda", "föröd"},
		{"förödelsen", "föröd"},
		{"förödelsens", "föröd"},
		{"förödmjuka", "förödmjuk"},
		{"förödmjukad", "förödmjuk"},
		{"förödmjukande", "förödmjuk"},
		{"förödmjukelse", "förödmjuk"},
		{"förödmjukelser", "förödmjuk"},
		{"förökat", "förök"},
		{"förökning", "förökning"},
		{"förövas", "föröv"},
		{"fösa", "fös"},
		{"fött", "fött"},
		{"föttcrna", "föttcrn"},
		{"fötter", "fött"},
		{"fötterna", "fött"},
		{"fötts", "fött"},
		{"g", "g"},
		{"ga", "ga"},
		{"gabriel", "gabriel"},
		{"gabriella", "gabriell"},
		{"gabriellas", "gabriell"},
		{"gadd", "gadd"},
		{"gaf", "gaf"},
		{"gaffel", "gaffel"},
		{"gafflar", "gaffl"},
		{"gafflarna", "gaffl"},
		{"gafs", "gaf"},
		{"gafvel", "gafvel"},
		{"gafvelkammaren", "gafvelkamm"},
		{"gafveln", "gafveln"},
		{"gagn", "gagn"},
		{"gagna", "gagn"},
		{"gagnade", "gagn"},
		{"gagnar", "gagn"},
		{"gagnat", "gagn"},
		{"gagne", "gagn"},
		{"gagneligast", "gagne"},
		{"gagnlöst", "gagnlös"},
		{"gagns", "gagn"},
		{"galanerna", "galan"},
		{"galant", "galant"},
		{"galanta", "galant"},
		{"galanteri", "galanteri"},
		{"galeas", "gale"},
		{"galeasen", "galeas"},
		{"galen", "gal"},
		{"galenskap", "galenskap"},
		{"galenskaper", "galenskap"},
		{"galet", "galet"},
		{"galgen", "galg"},
		{"galjonsbilder", "galjonsbild"},
		{"gall", "gall"},
		{"gallans", "gallan"},
		{"galleri", "galleri"},
		{"galleriet", "galleriet"},
		{"gallerna", "gall"},
		{"gallfeber", "gallfeb"},
		{"gallhumlen", "gallhuml"},
		{"gallhöna", "gallhön"},
		{"gallimatias", "gallimati"},
		{"galliska", "gallisk"},
		{"gallko", "gallko"},
		{"gallret", "gallret"},
		{"gallskrek", "gallskrek"},
		{"gallsteklar", "gallstekl"},
		{"galläpplen", "galläppl"},
		{"galna", "galn"},
		{"galning", "galning"},
		{"galningar", "galning"},
		{"galningen", "galning"},
		{"galopp", "galopp"},
		{"galoppera", "galopper"},
		{"galoscher", "galosch"},
		{"galoschmakarna", "galoschmak"},
		{"galtar", "galt"},
		{"gam", "gam"},
		{"gamla", "gaml"},
		{"gamlas", "gaml"},
		{"gamle", "gaml"},
		{"gamles", "gaml"},
		{"gamma", "gamm"},
		{"gammal", "gammal"},
		{"gammaldags", "gammaldag"},
		{"gammalklok", "gammalklok"},
		{"gammalmodiga", "gammalmod"},
		{"gammalstafvar", "gammalstafv"},
		{"gammalstavad", "gammalstav"},
		{"gammalsven", "gammalsv"},
		{"gammalt", "gammalt"},
		{"gamman", "gamman"},
		{"gande", "gand"},
		{"gang", "gang"},
		{"gangen", "gang"},
		{"ganger", "gang"},
		{"ganska", "gansk"},
		{"gap", "gap"},
		{"gapa", "gap"},
		{"gapade", "gap"},
		{"gapande", "gap"},
		{"gapar", "gap"},
		{"gapet", "gapet"},
		{"gapskratt", "gapskrat"},
		{"gapskratta", "gapskrat"},
		{"gapskrattar", "gapskrat"},
		{"gar", "gar"},
		{"garcon", "garcon"},
		{"gard", "gard"},
		{"garde", "gard"},
		{"garden", "gard"},
		{"garderoben", "garderob"},
		{"gardin", "gardin"},
		{"gardinen", "gardin"},
		{"gardiner", "gardin"},
		{"gardinerna", "gardin"},
		{"gardinstyger", "gardinstyg"},
		{"gardintyg", "gardintyg"},
		{"gardintyget", "gardintyget"},
		{"gards", "gard"},
		{"gardsplanen", "gardsplan"},
		{"garibaldi", "garibaldi"},
		{"garmla", "garml"},
		{"garn", "garn"},
		{"garna", "garn"},
		{"garnerad", "garner"},
		{"garnerade", "garner"},
		{"garnet", "garnet"},
		{"garnvindan", "garnvindan"},
		{"garnvindor", "garnvind"},
		{"garvade", "garv"},
		{"gasblossen", "gasbloss"},
		{"gasell", "gasell"},
		{"gasförgiftade", "gasförgift"},
		{"gaslykta", "gaslyk"},
		{"gaslyktan", "gaslyktan"},
		{"gaslyktor", "gaslyk"},
		{"gaslyktorna", "gaslyk"},
		{"gaspedalen", "gaspedal"},
		{"gasrampen", "gasramp"},
		{"gasrör", "gasrör"},
		{"gasskyarna", "gassky"},
		{"gasverket", "gasverket"},
		{"gata", "gat"},
		{"gatan", "gatan"},
		{"gatans", "gatan"},
		{"gatfulla", "gatfull"},
		{"gathörn", "gathörn"},
		{"gathörnet", "gathörnet"},
		{"gatlyktorna", "gatlyk"},
		{"gatläggningen", "gatläggning"},
		{"gator", "gat"},
		{"gatorna", "gat"},
		{"gatsopare", "gatsop"},
		{"gatstrykerskorna", "gatstrykersk"},
		{"gatt", "gatt"},
		{"gatukorset", "gatukorset"},
		{"gatukorsning", "gatukorsning"},
		{"gav", "gav"},
		{"gavelrum", "gavelrum"},
		{"gavo", "gavo"},
		{"gavs", "gav"},
		{"gcstalt", "gcstalt"},
		{"gcting", "gcting"},
		{"ge", "ge"},
		{"gebitet", "gebitet"},
		{"gedigen", "ged"},
		{"gedigna", "gedign"},
		{"gehör", "gehör"},
		{"gela", "gel"},
		{"gelatinkapslar", "gelatinkapsl"},
		{"gele", "gel"},
		{"gelikar", "gelik"},
		{"geln", "geln"},
		{"gemen", "gem"},
		{"gemena", "gemen"},
		{"gemene", "gemen"},
		{"gemenliga", "gemen"},
		{"gemenligen", "gemen"},
		{"gemensam", "gemensam"},
		{"gemensamma", "gemensamm"},
		{"gemensamt", "gemensamt"},
		{"gemenskap", "gemenskap"},
		{"gemenskapen", "gemenskap"},
		{"gement", "gement"},
		{"gemnälde", "gemnäld"},
		{"gemyt", "gemyt"},
		{"gemytlig", "gemyt"},
		{"gemytliga", "gemyt"},
		{"gemål", "gemål"},
		{"gen", "gen"},
		{"genast", "gen"},
		{"genealogi", "genealogi"},
		{"generad", "gener"},
		{"generade", "gener"},
		{"generalkonsuler", "generalkonsul"},
		{"generalmajor", "generalmaj"},
		{"generar", "gener"},
		{"generat", "gener"},
		{"generation", "generation"},
		{"generationer", "generation"},
		{"generations", "generation"},
		{"gengäld", "gengäld"},
		{"geni", "geni"},
		{"genier", "geni"},
		{"genljud", "genljud"},
		{"genljöd", "genljöd"},
		{"genmälte", "genmält"},
		{"genom", "genom"},
		{"genomborrande", "genomborr"},
		{"genombrutna", "genombrutn"},
		{"genombröto", "genombröto"},
		{"genomdrifva", "genomdrifv"},
		{"genomflög", "genomflög"},
		{"genomfor", "genomf"},
		{"genomgick", "genomgick"},
		{"genomgingo", "genomgingo"},
		{"genomgå", "genomgå"},
		{"genomgåendet", "genomgåendet"},
		{"genomgången", "genomgång"},
		{"genomgår", "genomgår"},
		{"genomgått", "genomgåt"},
		{"genomhederlig", "genomheder"},
		{"genomila", "genomil"},
		{"genomlefvat", "genomlefv"},
		{"genomletade", "genomlet"},
		{"genomlidit", "genomlidit"},
		{"genompryglade", "genomprygl"},
		{"genomse", "genoms"},
		{"genomskimrad", "genomskimr"},
		{"genomskinlig", "genomskin"},
		{"genomskinliga", "genomskin"},
		{"genomskinligt", "genomskin"},
		{"genomskåda", "genomskåd"},
		{"genomskådar", "genomskåd"},
		{"genomskådat", "genomskåd"},
		{"genomstekt", "genomstek"},
		{"genomströmmades", "genomströmm"},
		{"genomtränga", "genomträng"},
		{"genomträngande", "genomträng"},
		{"genomträngde", "genomträng"},
		{"genomtummat", "genomtumm"},
		{"genomvaka", "genomvak"},
		{"genomvakat", "genomvak"},
		{"genomvåta", "genomvåt"},
		{"genomögnade", "genomögn"},
		{"genorn", "genorn"},
		{"genre", "genr"},
		{"gens", "gen"},
		{"gent", "gent"},
		{"gentil", "gentil"},
		{"gentilaste", "gentil"},
		{"gentle", "gentl"},
		{"gentleman", "gentleman"},
		{"gentlemans", "gentleman"},
		{"genväg", "genväg"},
		{"genvägen", "genväg"},
		{"geometriskt", "geometrisk"},
		{"georgine", "georgin"},
		{"georginer", "georgin"},
		{"georginers", "georginer"},
		{"georgines", "georgin"},
		{"ger", "ger"},
		{"geranium", "geranium"},
		{"gerda", "gerd"},
		{"german", "german"},
		{"germanska", "germansk"},
		{"gerna", "gern"},
		{"gerning", "gerning"},
		{"gerningar", "gerning"},
		{"gest", "gest"},
		{"gestalt", "gestalt"},
		{"gestaltar", "gestalt"},
		{"gestaltcr", "gestaltcr"},
		{"gestalten", "gestalt"},
		{"gestalter", "gestalt"},
		{"gestalterna", "gestalt"},
		{"gesten", "gest"},
		{"gester", "gest"},
		{"gestikulerade", "gestikuler"},
		{"gestikulerande", "gestikuler"},
		{"gesäller", "gesäll"},
		{"gesällerna", "gesäll"},
		{"gesällers", "gesäller"},
		{"get", "get"},
		{"geting", "geting"},
		{"getsemane", "getseman"},
		{"gett", "gett"},
		{"gevär", "gevär"},
		{"geväret", "geväret"},
		{"gevärskolfven", "gevärskolfv"},
		{"gick", "gick"},
		{"gif", "gif"},
		{"gifningen", "gifning"},
		{"gift", "gift"},
		{"gifta", "gift"},
		{"giftas", "gift"},
		{"giftasgrillerna", "giftasgrill"},
		{"giftaslust", "giftaslust"},
		{"giftaslysten", "giftaslyst"},
		{"giftastankarna", "giftastank"},
		{"giftbägare", "giftbäg"},
		{"gifte", "gift"},
		{"gifter", "gift"},
		{"giftermål", "giftermål"},
		{"giftermålet", "giftermålet"},
		{"giftermålsanbud", "giftermålsanbud"},
		{"giftermålsanmälan", "giftermålsanmälan"},
		{"giftermålsförslaget", "giftermålsförslaget"},
		{"giftermålsförsök", "giftermålsförsök"},
		{"giftermålsplaner", "giftermålsplan"},
		{"giftermålsspekulation", "giftermålsspekulation"},
		{"giftermålsvurm", "giftermålsvurm"},
		{"giftet", "giftet"},
		{"giftig", "gift"},
		{"giftiga", "gift"},
		{"giftigaste", "gift"},
		{"giftorätt", "giftorät"},
		{"gifva", "gifv"},
		{"gifvas", "gifv"},
		{"gifve", "gifv"},
		{"gifven", "gifv"},
		{"gifver", "gifv"},
		{"gifvit", "gifvit"},
		{"giga", "gig"},
		{"gigantisk", "gigantisk"},
		{"gigantiska", "gigantisk"},
		{"gikten", "gikt"},
		{"giktfulla", "giktfull"},
		{"giljan", "giljan"},
		{"giljarsträng", "giljarsträng"},
		{"gilla", "gill"},
		{"gillad", "gill"},
		{"gillade", "gill"},
		{"gillat", "gill"},
		{"gillstu", "gillstu"},
		{"gillstugan", "gillstugan"},
		{"gillstutömmar", "gillstutömm"},
		{"ginge", "ging"},
		{"gingo", "gingo"},
		{"ginst", "ginst"},
		{"gips", "gip"},
		{"gipsbild", "gipsbild"},
		{"gipsornament", "gipsornament"},
		{"girig", "gir"},
		{"giriga", "gir"},
		{"girigbuk", "girigbuk"},
		{"girigt", "gir"},
		{"gissa", "giss"},
		{"gissade", "giss"},
		{"gissar", "giss"},
		{"gissat", "giss"},
		{"gissel", "gissel"},
		{"gisselslagen", "gisselslag"},
		{"gisslande", "gissl"},
		{"gissning", "gissning"},
		{"gistnade", "gistn"},
		{"gitarr", "gitarr"},
		{"gitarren", "gitarr"},
		{"gitarrer", "gitarr"},
		{"gitarrerna", "gitarr"},
		{"gitarrknäpp", "gitarrknäpp"},
		{"gitarrspel", "gitarrspel"},
		{"gittat", "gitt"},
		{"gitte", "gitt"},
		{"gitter", "gitt"},
		{"giuseppe", "giusepp"},
		{"giv", "giv"},
		{"giva", "giv"},
		{"givande", "giv"},
		{"givas", "giv"},
		{"give", "giv"},
		{"given", "giv"},
		{"givet", "givet"},
		{"givit", "givit"},
		{"givmilda", "givmild"},
		{"givmildare", "givmild"},
		{"givmildhets", "givmildhet"},
		{"givna", "givn"},
		{"gjord", "gjord"},
		{"gjorda", "gjord"},
		{"gjorde", "gjord"},
		{"gjordes", "gjord"},
		{"gjordt", "gjord"},
		{"gjort", "gjort"},
		{"gjorte", "gjort"},
		{"gjuta", "gjut"},
		{"gjutit", "gjutit"},
		{"gl", "gl"},
		{"glacehandskar", "glacehandsk"},
		{"glad", "glad"},
		{"glada", "glad"},
		{"gladare", "glad"},
		{"gladast", "glad"},
		{"gladaste", "glad"},
		{"gladde", "gladd"},
		{"gladdes", "gladd"},
		{"glade", "glad"},
		{"gladio", "gladio"},
		{"gladja", "gladj"},
		{"gladlynt", "gladlynt"},
		{"gladt", "gladt"},
		{"glam", "glam"},
		{"glan", "glan"},
		{"glans", "glan"},
		{"glansen", "glans"},
		{"glanslös", "glanslös"},
		{"glanslösa", "glanslös"},
		{"glansperiod", "glansperiod"},
		{"glanste", "glanst"},
		{"glappande", "glapp"},
		{"glas", "glas"},
		{"glasblanka", "glasblank"},
		{"glasburk", "glasburk"},
		{"glasdisken", "glasdisk"},
		{"glasdörren", "glasdörr"},
		{"glasen", "glas"},
		{"glaset", "glaset"},
		{"glasets", "glaset"},
		{"glasigt", "glas"},
		{"glasklara", "glasklar"},
		{"glaskupa", "glaskup"},
		{"glaskupan", "glaskupan"},
		{"glaskärl", "glaskärl"},
		{"glaspärlor", "glaspärl"},
		{"glasruta", "glasrut"},
		{"glasskåp", "glasskåp"},
		{"glasveran", "glasveran"},
		{"glasverandan", "glasverandan"},
		{"glasväggen", "glasvägg"},
		{"glasyr", "glasyr"},
		{"glasögon", "glasögon"},
		{"glasögonen", "glasögon"},
		{"glatt", "glatt"},
		{"glatta", "glatt"},
		{"gled", "gled"},
		{"gledo", "gledo"},
		{"glesnade", "glesn"},
		{"glesnande", "glesn"},
		{"glesnar", "glesn"},
		{"glesnat", "glesn"},
		{"glida", "glid"},
		{"glidande", "glid"},
		{"glider", "glid"},
		{"glidit", "glidit"},
		{"glim", "glim"},
		{"glimma", "glimm"},
		{"glimmade", "glimm"},
		{"glimmande", "glimm"},
		{"glimt", "glimt"},
		{"glindrande", "glindr"},
		{"glitter", "glitt"},
		{"glittra", "glittr"},
		{"glittrade", "glittr"},
		{"glittrande", "glittr"},
		{"glittret", "glittret"},
		{"glomma", "glomm"},
		{"glopar", "glop"},
		{"gloria", "glori"},
		{"glufsade", "glufs"},
		{"glugg", "glugg"},
		{"gluggar", "glugg"},
		{"glupande", "glup"},
		{"glupska", "glupsk"},
		{"glupskt", "glupsk"},
		{"gläder", "gläd"},
		{"glädja", "glädj"},
		{"glädjande", "glädj"},
		{"glädjas", "glädj"},
		{"glädje", "glädj"},
		{"glädjeblixt", "glädjeblixt"},
		{"glädjekälla", "glädjekäll"},
		{"glädjen", "glädj"},
		{"glädjens", "glädj"},
		{"glädjerop", "glädjerop"},
		{"glädjerörelse", "glädjerör"},
		{"glädjes", "glädj"},
		{"glädjeskri", "glädjeskri"},
		{"glädjestrålande", "glädjestrål"},
		{"glädjestråle", "glädjestrål"},
		{"glädjetommaste", "glädjetomm"},
		{"gläds", "gläd"},
		{"glädtige", "glädt"},
		{"gläfsande", "gläfs"},
		{"gläfste", "gläfst"},
		{"glän", "glän"},
		{"glänsa", "gläns"},
		{"glänsande", "gläns"},
		{"glänser", "gläns"},
		{"glänst", "glänst"},
		{"glänste", "glänst"},
		{"glänt", "glänt"},
		{"glänta", "glänt"},
		{"gläntade", "glänt"},
		{"gläntan", "gläntan"},
		{"gläntande", "glänt"},
		{"gläntas", "glänt"},
		{"glättigt", "glätt"},
		{"glöd", "glöd"},
		{"glöda", "glöd"},
		{"glödande", "glöd"},
		{"glödde", "glödd"},
		{"glöder", "glöd"},
		{"glödgade", "glödg"},
		{"glödheta", "glödhet"},
		{"glödlamporna", "glödlamp"},
		{"glöm", "glöm"},
		{"glömd", "glömd"},
		{"glömda", "glömd"},
		{"glömde", "glömd"},
		{"glömma", "glömm"},
		{"glömmande", "glömm"},
		{"glömmas", "glömm"},
		{"glömmer", "glömm"},
		{"glömska", "glömsk"},
		{"glömt", "glömt"},
		{"gmlgademlär", "gmlgademlär"},
		{"gnagande", "gnag"},
		{"gnagandr", "gnagandr"},
		{"gnagde", "gnagd"},
		{"gnagt", "gnagt"},
		{"gnat", "gnat"},
		{"gnata", "gnat"},
		{"gnatig", "gnat"},
		{"gnd", "gnd"},
		{"gned", "gned"},
		{"gnedos", "gnedo"},
		{"gnida", "gnid"},
		{"gnissla", "gnissl"},
		{"gnisslade", "gnissl"},
		{"gnisslande", "gnissl"},
		{"gnista", "gnist"},
		{"gnistan", "gnistan"},
		{"gnistor", "gnist"},
		{"gnistrade", "gnistr"},
		{"gnistrande", "gnistr"},
		{"gno", "gno"},
		{"gnodde", "gnodd"},
		{"gnola", "gnol"},
		{"gnolade", "gnol"},
		{"gnolande", "gnol"},
		{"gnolar", "gnol"},
		{"gnolat", "gnol"},
		{"gnomen", "gnom"},
		{"gnomer", "gnom"},
		{"gnott", "gnott"},
		{"gnuggade", "gnugg"},
		{"gny", "gny"},
		{"gnyr", "gnyr"},
		{"gnäggade", "gnägg"},
		{"gnäggande", "gnägg"},
		{"gnälla", "gnäll"},
		{"gnällande", "gnäll"},
		{"gnällde", "gnälld"},
		{"gnäller", "gnäll"},
		{"go", "go"},
		{"god", "god"},
		{"goda", "god"},
		{"godas", "god"},
		{"godbit", "godbit"},
		{"godbitar", "godbit"},
		{"goddagarna", "goddag"},
		{"goddagarne", "goddag"},
		{"goddagspilt", "goddagspilt"},
		{"gode", "god"},
		{"godhet", "god"},
		{"godheten", "god"},
		{"godhjärtade", "godhjärt"},
		{"godlynt", "godlynt"},
		{"godlynthet", "godlynt"},
		{"godmodiga", "godmod"},
		{"godmodighet", "godmod"},
		{"godmodigt", "godmod"},
		{"godnatt", "godnat"},
		{"godo", "godo"},
		{"gods", "god"},
		{"godsagare", "godsag"},
		{"godsagarn", "godsagarn"},
		{"godsaker", "godsak"},
		{"godsakerna", "godsak"},
		{"godset", "godset"},
		{"godsinthet", "godsint"},
		{"godsägare", "godsäg"},
		{"godsägarn", "godsägarn"},
		{"godt", "godt"},
		{"godta", "godt"},
		{"godtgjorde", "godtgjord"},
		{"godtycke", "godtyck"},
		{"goivet", "goivet"},
		{"gol", "gol"},
		{"golf", "golf"},
		{"golfvet", "golfvet"},
		{"golv", "golv"},
		{"golvct", "golvct"},
		{"golvet", "golvet"},
		{"golvspringor", "golvspring"},
		{"golvspringorna", "golvspring"},
		{"gommen", "gomm"},
		{"gonen", "gon"},
		{"gor", "gor"},
		{"gora", "gor"},
		{"gorna", "gorn"},
		{"gossaktigt", "gossakt"},
		{"gossar", "goss"},
		{"gossarna", "goss"},
		{"gossarne", "goss"},
		{"gossc", "gossc"},
		{"gosse", "goss"},
		{"gossel", "gossel"},
		{"gossen", "goss"},
		{"gossens", "goss"},
		{"gosshänder", "gosshänd"},
		{"gosskola", "gosskol"},
		{"gosspannan", "gosspannan"},
		{"gossårens", "gossår"},
		{"got", "got"},
		{"gotisk", "gotisk"},
		{"gott", "gott"},
		{"gottbard", "gottbard"},
		{"gotter", "gott"},
		{"gottfinnande", "gottfin"},
		{"gottgjorde", "gottgjord"},
		{"gottgöra", "gottgör"},
		{"gottgöres", "gottgör"},
		{"gotthard", "gotthard"},
		{"gotthards", "gotthard"},
		{"gottpåse", "gottpås"},
		{"gouttiere", "gouttier"},
		{"gra", "gra"},
		{"grace", "grac"},
		{"gracer", "grac"},
		{"gracerna", "grac"},
		{"graciös", "graciös"},
		{"graciösa", "graciös"},
		{"grad", "grad"},
		{"grader", "grad"},
		{"graders", "grader"},
		{"gradvis", "gradvis"},
		{"graf", "graf"},
		{"grafdjup", "grafdjup"},
		{"grafvarne", "grafv"},
		{"grafven", "grafv"},
		{"grafvens", "grafv"},
		{"gral", "gral"},
		{"grammatikan", "grammatikan"},
		{"gran", "gran"},
		{"granar", "gran"},
		{"granarna", "gran"},
		{"granarnas", "gran"},
		{"grand", "grand"},
		{"granen", "gran"},
		{"grankottarna", "grankot"},
		{"grann", "grann"},
		{"granna", "grann"},
		{"grannar", "grann"},
		{"grannare", "grann"},
		{"grannarne", "grann"},
		{"grannarnes", "grannarn"},
		{"grannaste", "grann"},
		{"granne", "grann"},
		{"grannens", "grann"},
		{"grannes", "grann"},
		{"grannlaga", "grannlag"},
		{"grannlagenhet", "grannlagen"},
		{"grannlåt", "grannlåt"},
		{"grannlåtsdocka", "grannlåtsdock"},
		{"grannlåtsrummen", "grannlåtsrumm"},
		{"grannqvinna", "grannqvin"},
		{"grannskap", "grannskap"},
		{"grannskapet", "grannskapet"},
		{"grannstränderna", "grannstränd"},
		{"grannstugan", "grannstugan"},
		{"grannt", "grannt"},
		{"granorgeln", "granorgeln"},
		{"granris", "granris"},
		{"granrisat", "granris"},
		{"granska", "gransk"},
		{"granskade", "gransk"},
		{"granskande", "gransk"},
		{"granskare", "gransk"},
		{"granskat", "gransk"},
		{"granskog", "granskog"},
		{"granskogen", "granskog"},
		{"grant", "grant"},
		{"grantop", "grantop"},
		{"grata", "grat"},
		{"gratiers", "gratier"},
		{"gratis", "gratis"},
		{"gratulationer", "gratulation"},
		{"gratulera", "gratuler"},
		{"gratulerade", "gratuler"},
		{"grav", "grav"},
		{"gravar", "grav"},
		{"gravarna", "grav"},
		{"graven", "grav"},
		{"gravera", "graver"},
		{"gravlika", "gravlik"},
		{"gravstenar", "gravsten"},
		{"gravstenarna", "gravsten"},
		{"gravvård", "gravvård"},
		{"gravvårdar", "gravvård"},
		{"gravyrer", "gravyr"},
		{"gredelin", "gredelin"},
		{"gredelina", "gredelin"},
		{"gredelint", "gredelint"},
		{"gregorius", "gregorius"},
		{"grekiska", "grekisk"},
		{"gren", "gren"},
		{"grenar", "gren"},
		{"grenarna", "gren"},
		{"grenen", "gren"},
		{"grensle", "grensl"},
		{"grep", "grep"},
		{"grepar", "grep"},
		{"grepe", "grep"},
		{"grepen", "grep"},
		{"grepo", "grepo"},
		{"grepp", "grepp"},
		{"greppet", "greppet"},
		{"greps", "grep"},
		{"gret", "gret"},
		{"gretchens", "gretch"},
		{"grevar", "grev"},
		{"greve", "grev"},
		{"grevegriften", "grevegrift"},
		{"greven", "grev"},
		{"grevens", "grev"},
		{"grevinna", "grevin"},
		{"grevinnan", "grevinnan"},
		{"grevinnor", "grevin"},
		{"grevliga", "grev"},
		{"grevlige", "grev"},
		{"grevligt", "grev"},
		{"griffeltavla", "griffeltavl"},
		{"griller", "grill"},
		{"grillerna", "grill"},
		{"grimas", "grim"},
		{"grimaserade", "grimaser"},
		{"grimaserande", "grimaser"},
		{"grimen", "grim"},
		{"grimma", "grimm"},
		{"grina", "grin"},
		{"grinade", "grin"},
		{"grinande", "grin"},
		{"grind", "grind"},
		{"grindar", "grind"},
		{"grinden", "grind"},
		{"grindstolpar", "grindstolp"},
		{"gripa", "grip"},
		{"gripande", "grip"},
		{"griparna", "grip"},
		{"gripas", "grip"},
		{"gripen", "grip"},
		{"griper", "grip"},
		{"gripit", "gripit"},
		{"gripna", "gripn"},
		{"gris", "gris"},
		{"grisen", "gris"},
		{"gro", "gro"},
		{"groda", "grod"},
		{"grodde", "grodd"},
		{"grodden", "grodd"},
		{"grof", "grof"},
		{"grofkorniga", "grofkorn"},
		{"groft", "groft"},
		{"grofva", "grofv"},
		{"grogg", "grogg"},
		{"groggar", "grogg"},
		{"grop", "grop"},
		{"gropar", "grop"},
		{"groparna", "grop"},
		{"gropen", "grop"},
		{"gropiga", "grop"},
		{"gror", "gror"},
		{"grossess", "grossess"},
		{"grosshandlardotter", "grosshandlardot"},
		{"grosshandlare", "grosshandl"},
		{"grotesk", "grotesk"},
		{"grov", "grov"},
		{"grova", "grov"},
		{"grovkornigaste", "grovkorn"},
		{"grovt", "grovt"},
		{"grubbel", "grubbel"},
		{"grubbla", "grubbl"},
		{"grubblade", "grubbl"},
		{"grubblande", "grubbl"},
		{"grubblandet", "grubbl"},
		{"grubblar", "grubbl"},
		{"grubblat", "grubbl"},
		{"grubbleri", "grubbleri"},
		{"grufliga", "gruf"},
		{"grufligt", "gruf"},
		{"grumlade", "gruml"},
		{"grumlig", "grum"},
		{"grumliga", "grum"},
		{"grumligt", "grum"},
		{"grund", "grund"},
		{"grunda", "grund"},
		{"grundad", "grund"},
		{"grundade", "grund"},
		{"grundas", "grund"},
		{"grundaste", "grund"},
		{"grundat", "grund"},
		{"grundats", "grundat"},
		{"grunddrag", "grunddrag"},
		{"grunddrifterna", "grunddrift"},
		{"grunden", "grund"},
		{"grundet", "grundet"},
		{"grundlagda", "grundlag"},
		{"grundlig", "grund"},
		{"grundligt", "grund"},
		{"grundpelare", "grundpel"},
		{"grundsatsen", "grundsats"},
		{"grundsatser", "grundsats"},
		{"grundval", "grundval"},
		{"grupp", "grupp"},
		{"gruppen", "grupp"},
		{"grupper", "grupp"},
		{"grupperade", "grupper"},
		{"grus", "grus"},
		{"gruset", "gruset"},
		{"gruvade", "gruv"},
		{"gruvlig", "gruv"},
		{"gruvligt", "gruv"},
		{"gry", "gry"},
		{"gryende", "gryend"},
		{"grym", "grym"},
		{"grymheten", "grym"},
		{"grymheter", "grym"},
		{"grymma", "grymm"},
		{"grymmaste", "grymm"},
		{"grymt", "grymt"},
		{"gryngröten", "gryngröt"},
		{"gryning", "gryning"},
		{"gryningen", "gryning"},
		{"gryningens", "gryning"},
		{"gryningsdagern", "gryningsdag"},
		{"grynvälling", "grynvälling"},
		{"gryr", "gryr"},
		{"gryta", "gryt"},
		{"grytor", "gryt"},
		{"grytorna", "gryt"},
		{"gräddade", "grädd"},
		{"grädde", "grädd"},
		{"gräl", "gräl"},
		{"gräla", "gräl"},
		{"grälade", "gräl"},
		{"grälande", "gräl"},
		{"grälat", "gräl"},
		{"grälen", "gräl"},
		{"grälla", "gräll"},
		{"grämde", "grämd"},
		{"grämelse", "gräm"},
		{"grämelsens", "gräm"},
		{"grämer", "gräm"},
		{"grämt", "grämt"},
		{"gränd", "gränd"},
		{"gränden", "gränd"},
		{"gränder", "gränd"},
		{"gränderna", "gränd"},
		{"grändernas", "gränd"},
		{"gräns", "grän"},
		{"gränsade", "gräns"},
		{"gränsande", "gräns"},
		{"gränsen", "gräns"},
		{"gränser", "gräns"},
		{"gränserna", "gräns"},
		{"gränslös", "gränslös"},
		{"gränslöst", "gränslös"},
		{"gräs", "gräs"},
		{"gräsbevuxen", "gräsbevux"},
		{"gräsbevuxna", "gräsbevuxn"},
		{"gräsbänkar", "gräsbänk"},
		{"gräset", "gräset"},
		{"gräsliga", "gräs"},
		{"gräsligaste", "gräs"},
		{"gräsligt", "gräs"},
		{"gräsmattan", "gräsmattan"},
		{"gräsmattor", "gräsmat"},
		{"gräsmattorna", "gräsmat"},
		{"gräsplan", "gräsplan"},
		{"grässtrån", "grässtrån"},
		{"grät", "grät"},
		{"gräto", "gräto"},
		{"gräv", "gräv"},
		{"gräva", "gräv"},
		{"grävda", "grävd"},
		{"grävde", "grävd"},
		{"gräver", "gräv"},
		{"grå", "grå"},
		{"gråa", "gråa"},
		{"gråare", "gråar"},
		{"gråblandad", "gråbland"},
		{"gråblanka", "gråblank"},
		{"gråbleka", "gråblek"},
		{"grådask", "grådask"},
		{"grådaskiga", "grådask"},
		{"grågröna", "grågrön"},
		{"gråhet", "gråhet"},
		{"gråkappeexcellensen", "gråkappeexcellens"},
		{"gråkulet", "gråkulet"},
		{"grånade", "grån"},
		{"grånande", "grån"},
		{"grånat", "grån"},
		{"gråsprängd", "gråspräng"},
		{"gråsprängda", "gråspräng"},
		{"gråsprängdt", "gråsprängd"},
		{"gråsprängt", "gråspräng"},
		{"gråsten", "gråst"},
		{"gråstrimmig", "gråstrimm"},
		{"gråt", "gråt"},
		{"gråta", "gråt"},
		{"gråtande", "gråt"},
		{"gråte", "gråt"},
		{"gråten", "gråt"},
		{"gråter", "gråt"},
		{"gråtfärdig", "gråtfärd"},
		{"gråtit", "gråtit"},
		{"gråtkramp", "gråtkramp"},
		{"grått", "grått"},
		{"gröfsta", "gröfst"},
		{"grön", "grön"},
		{"gröna", "grön"},
		{"grönaktiga", "grönakt"},
		{"gröngräset", "gröngräset"},
		{"grönmålad", "grönmål"},
		{"grönmålade", "grönmål"},
		{"grönska", "grönsk"},
		{"grönskan", "grönskan"},
		{"grönskande", "grönsk"},
		{"grönstedts", "grönsted"},
		{"grönt", "grönt"},
		{"gröt", "gröt"},
		{"gröten", "gröt"},
		{"grötig", "gröt"},
		{"grövre", "grövr"},
		{"gt", "gt"},
		{"gtlbben", "gtlbben"},
		{"gtngo", "gtngo"},
		{"gtvis", "gtvis"},
		{"gu", "gu"},
		{"gubb", "gubb"},
		{"gubbar", "gubb"},
		{"gubbarne", "gubb"},
		{"gubbe", "gubb"},
		{"gubben", "gubb"},
		{"gubbens", "gubb"},
		{"gubbes", "gubb"},
		{"gubbsatiriskt", "gubbsatirisk"},
		{"gubevars", "gubevar"},
		{"gud", "gud"},
		{"gudadryck", "gudadryck"},
		{"gudaktiga", "gudakt"},
		{"gudaktigheten", "gudakt"},
		{"gudarna", "gud"},
		{"gudarnes", "gudarn"},
		{"gudars", "gudar"},
		{"gudbevars", "gudbevar"},
		{"guden", "gud"},
		{"gudens", "gud"},
		{"gudfar", "gudf"},
		{"gudfruktig", "gudfrukt"},
		{"gudfruktiga", "gudfrukt"},
		{"gudfruktigt", "gudfrukt"},
		{"gudi", "gudi"},
		{"gudlöshet", "gudlös"},
		{"gudlöst", "gudlös"},
		{"gudnås", "gudnås"},
		{"gudom", "gudom"},
		{"gudomens", "gudom"},
		{"gudomlig", "gudom"},
		{"gudomliga", "gudom"},
		{"gudomligare", "gudom"},
		{"gudomlighet", "gudom"},
		{"guds", "gud"},
		{"gudsfruktan", "gudsfruktan"},
		{"gudskelov", "gudskelov"},
		{"gudson", "gudson"},
		{"gudstjänstens", "gudstjänst"},
		{"gudsängeln", "gudsängeln"},
		{"guhl", "guhl"},
		{"gul", "gul"},
		{"gula", "gul"},
		{"gulaktig", "gulakt"},
		{"gulbetsade", "gulbets"},
		{"gulblekt", "gulblek"},
		{"guld", "guld"},
		{"guldbroderad", "guldbroder"},
		{"guldbrosch", "guldbrosch"},
		{"gulddosan", "gulddosan"},
		{"guldets", "guldet"},
		{"guldfargad", "guldfarg"},
		{"guldfärg", "guldfärg"},
		{"guldfärgade", "guldfärg"},
		{"guldgula", "guldgul"},
		{"guldklackar", "guldklack"},
		{"guldklot", "guldklot"},
		{"guldlöv", "guldlöv"},
		{"guldpapper", "guldpapp"},
		{"guldprins", "guldprin"},
		{"guldskimmer", "guldskimm"},
		{"guldskimrande", "guldskimr"},
		{"guldskärp", "guldskärp"},
		{"guldskål", "guldskål"},
		{"guldsmedsbutik", "guldsmedsbutik"},
		{"guldsnitt", "guldsnit"},
		{"guldsnusdosan", "guldsnusdosan"},
		{"guldstoft", "guldstoft"},
		{"guldtränsar", "guldträns"},
		{"guldur", "guldur"},
		{"guldårens", "guldår"},
		{"gulgrå", "gulgrå"},
		{"gulgrått", "gulgråt"},
		{"gulgrön", "gulgrön"},
		{"gulhvitt", "gulhvit"},
		{"gulhårige", "gulhår"},
		{"gull", "gull"},
		{"gullet", "gullet"},
		{"gullgult", "gullgult"},
		{"gullros", "gullro"},
		{"gullvivor", "gullviv"},
		{"gulmålad", "gulmål"},
		{"gulna", "guln"},
		{"gulnad", "guln"},
		{"gulnade", "guln"},
		{"gulnat", "guln"},
		{"gulrosig", "gulros"},
		{"gulrosiga", "gulros"},
		{"gulröd", "gulröd"},
		{"gult", "gult"},
		{"gum", "gum"},
		{"gumansikte", "gumansik"},
		{"gumma", "gumm"},
		{"gumman", "gumman"},
		{"gummi", "gummi"},
		{"gummiansikte", "gummiansik"},
		{"gummihandske", "gummihandsk"},
		{"gummiring", "gummiring"},
		{"gummor", "gumm"},
		{"gummorna", "gumm"},
		{"gummors", "gummor"},
		{"gung", "gung"},
		{"gunga", "gung"},
		{"gungade", "gung"},
		{"gungande", "gung"},
		{"gunst", "gunst"},
		{"gunstiga", "gunst"},
		{"gunstige", "gunst"},
		{"gunstigt", "gunst"},
		{"gunstling", "gunstling"},
		{"gunstlingen", "gunstling"},
		{"gunås", "gunås"},
		{"guppade", "gupp"},
		{"gurka", "gurk"},
		{"gurkornas", "gurk"},
		{"gustaf", "gustaf"},
		{"gustav", "gustav"},
		{"guttaperkaboll", "guttaperkaboll"},
		{"gutår", "gutår"},
		{"gyckel", "gyckel"},
		{"gyckla", "gyckl"},
		{"gycklade", "gyckl"},
		{"gycklar", "gyckl"},
		{"gycklare", "gyckl"},
		{"gycklaren", "gyckl"},
		{"gycklarlynne", "gycklarlyn"},
		{"gyllenbandade", "gyllenband"},
		{"gyllenborg", "gyllenborg"},
		{"gyllenc", "gyllenc"},
		{"gyllene", "gyllen"},
		{"gyllenröd", "gyllenröd"},
		{"gyllenstjärnan", "gyllenstjärnan"},
		{"gyllne", "gylln"},
		{"gymnasiitid", "gymnasiitid"},
		{"gymnasist", "gymnasist"},
		{"gymnasisten", "gymnasist"},
		{"gymnasium", "gymnasium"},
		{"gymnastiklokalen", "gymnastiklokal"},
		{"gymnastiklärare", "gymnastiklär"},
		{"gymnastiktavlingarna", "gymnastiktavling"},
		{"gynekologi", "gynekologi"},
		{"gynnad", "gynn"},
		{"gynnade", "gynn"},
		{"gynnande", "gynn"},
		{"gynnar", "gynn"},
		{"gynnare", "gynn"},
		{"gynnsamma", "gynnsamm"},
		{"gynsamma", "gynsamm"},
		{"gynsamt", "gynsamt"},
		{"gäck", "gäck"},
		{"gäcka", "gäck"},
		{"gäckade", "gäck"},
		{"gäckande", "gäck"},
		{"gäckat", "gäck"},
		{"gälda", "gäld"},
		{"gälde", "gäld"},
		{"gäldstugan", "gäldstugan"},
		{"gäll", "gäll"},
		{"gälla", "gäll"},
		{"gällande", "gäll"},
		{"gällde", "gälld"},
		{"gäller", "gäll"},
		{"gällt", "gällt"},
		{"gält", "gält"},
		{"gäma", "gäm"},
		{"gäng", "gäng"},
		{"gänglig", "gäng"},
		{"gängliga", "gäng"},
		{"gängse", "gängs"},
		{"gärd", "gärd"},
		{"gärdena", "gärden"},
		{"gärdesgard", "gärdesgard"},
		{"gärna", "gärn"},
		{"gärning", "gärning"},
		{"gärningen", "gärning"},
		{"gäspa", "gäsp"},
		{"gäspade", "gäsp"},
		{"gäspning", "gäspning"},
		{"gäspningar", "gäspning"},
		{"gäst", "gäst"},
		{"gästabudshus", "gästabudshus"},
		{"gästar", "gäst"},
		{"gästat", "gäst"},
		{"gästbyggningen", "gästbyggning"},
		{"gästen", "gäst"},
		{"gäster", "gäst"},
		{"gästerna", "gäst"},
		{"gästers", "gäster"},
		{"gästfrihet", "gästfri"},
		{"gästfriheten", "gästfri"},
		{"gästfrihetens", "gästfri"},
		{"gästgivaregården", "gästgivaregård"},
		{"gästkammaren", "gästkamm"},
		{"gästkammarn", "gästkammarn"},
		{"gästrum", "gästrum"},
		{"gästrummet", "gästrummet"},
		{"gå", "gå"},
		{"gående", "gåend"},
		{"gåfva", "gåfv"},
		{"gåfve", "gåfv"},
		{"gåfvo", "gåfvo"},
		{"gåfvor", "gåfv"},
		{"gång", "gång"},
		{"gånga", "gång"},
		{"gångar", "gång"},
		{"gångarens", "gång"},
		{"gångarna", "gång"},
		{"gångarnas", "gång"},
		{"gångars", "gångar"},
		{"gångbanan", "gångbanan"},
		{"gången", "gång"},
		{"gångens", "gång"},
		{"gånger", "gång"},
		{"gångerna", "gång"},
		{"gångmattan", "gångmattan"},
		{"gångna", "gångn"},
		{"gångspelet", "gångspelet"},
		{"gångstig", "gångst"},
		{"går", "går"},
		{"gård", "gård"},
		{"gårdagen", "gårdag"},
		{"gårdagens", "gårdag"},
		{"gårdar", "gård"},
		{"gården", "gård"},
		{"gårdens", "gård"},
		{"gårds", "gård"},
		{"gårdsflygel", "gårdsflygel"},
		{"gårdsflygeln", "gårdsflygeln"},
		{"gårdshörnet", "gårdshörnet"},
		{"gårdsmuren", "gårdsmur"},
		{"gårdsplan", "gårdsplan"},
		{"gårdsplanen", "gårdsplan"},
		{"gårkök", "gårkök"},
		{"gåsen", "gås"},
		{"gåsmarsch", "gåsmarsch"},
		{"gåsmarschen", "gåsmarsch"},
		{"gåsvinge", "gåsving"},
		{"gåta", "gåt"},
		{"gåtan", "gåtan"},
		{"gåtfull", "gåtfull"},
		{"gåtfullt", "gåtfull"},
		{"gåtlikt", "gåtlik"},
		{"gåtor", "gåt"},
		{"gåtornas", "gåt"},
		{"gått", "gått"},
		{"gåva", "gåv"},
		{"gåvan", "gåvan"},
		{"gåve", "gåv"},
		{"gåven", "gåv"},
		{"gåvo", "gåvo"},
		{"gåvor", "gåv"},
		{"gödde", "gödd"},
		{"gödsel", "gödsel"},
		{"göia", "göia"},
		{"gök", "gök"},
		{"gökar", "gök"},
		{"göken", "gök"},
		{"göm", "göm"},
		{"gömd", "gömd"},
		{"gömda", "gömd"},
		{"gömde", "gömd"},
		{"gömdt", "gömd"},
		{"gömma", "gömm"},
		{"gömmande", "gömm"},
		{"gömmen", "gömm"},
		{"gömmer", "gömm"},
		{"gömsle", "gömsl"},
		{"gömslen", "gömsl"},
		{"gömställe", "gömställ"},
		{"gömt", "gömt"},
		{"gör", "gör"},
		{"göra", "gör"},
		{"göras", "gör"},
		{"göres", "gör"},
		{"göromål", "göromål"},
		{"göta", "göt"},
		{"göteborg", "göteborg"},
		{"götiska", "götisk"},
		{"h", "h"},
		{"ha", "ha"},
		{"hab", "hab"},
		{"habilement", "habilement"},
		{"habiten", "habit"},
		{"hack", "hack"},
		{"hacka", "hack"},
		{"hackade", "hack"},
		{"hackande", "hack"},
		{"hackar", "hack"},
		{"hackat", "hack"},
		{"hackor", "hack"},
		{"hacle", "hacl"},
		{"had", "had"},
		{"hadc", "hadc"},
		{"hade", "had"},
		{"haf", "haf"},
		{"hafsfrun", "hafsfrun"},
		{"hafsfågel", "hafsfågel"},
		{"hafsjungfru", "hafsjungfru"},
		{"hafsjungfrun", "hafsjungfrun"},
		{"hafsmannen", "hafsman"},
		{"hafsstranden", "hafsstr"},
		{"hafssvallet", "hafssvallet"},
		{"hafstrollen", "hafstroll"},
		{"hafstång", "hafstång"},
		{"hafsvattnet", "hafsvattnet"},
		{"hafsytan", "hafsytan"},
		{"haft", "haft"},
		{"hafva", "hafv"},
		{"hafven", "hafv"},
		{"hafver", "hafv"},
		{"hafvet", "hafvet"},
		{"hafvets", "hafvet"},
		{"haga", "hag"},
		{"hagaparken", "hagapark"},
		{"hagar", "hag"},
		{"hage", "hag"},
		{"hagen", "hag"},
		{"hagens", "hag"},
		{"haglig", "hag"},
		{"haka", "hak"},
		{"hakade", "hak"},
		{"hakan", "hakan"},
		{"hakar", "hak"},
		{"hakat", "hak"},
		{"hakom", "hakom"},
		{"hal", "hal"},
		{"hala", "hal"},
		{"halade", "hal"},
		{"halades", "hal"},
		{"half", "half"},
		{"halfbror", "halfbr"},
		{"halfbrustna", "halfbrustn"},
		{"halfdunkla", "halfdunkl"},
		{"halfförfallet", "halfförfallet"},
		{"halfgod", "halfgod"},
		{"halfgråtande", "halfgråt"},
		{"halfhviskade", "halfhvisk"},
		{"halfhögt", "halfhög"},
		{"halfslocknade", "halfslockn"},
		{"halfslumrade", "halfslumr"},
		{"halfsofvande", "halfsofv"},
		{"halft", "halft"},
		{"halftimme", "halftimm"},
		{"halftrånande", "halftrån"},
		{"halfvan", "halfvan"},
		{"halfvilde", "halfvild"},
		{"halfvissnade", "halfvissn"},
		{"halfvägs", "halfväg"},
		{"halka", "halk"},
		{"halkade", "halk"},
		{"halkat", "halk"},
		{"hall", "hall"},
		{"halla", "hall"},
		{"hallandshedarnas", "hallandshed"},
		{"halle", "hall"},
		{"halleluja", "halleluj"},
		{"hallen", "hall"},
		{"haller", "hall"},
		{"hallit", "hallit"},
		{"hallonen", "hallon"},
		{"hallonkräm", "hallonkräm"},
		{"halls", "hall"},
		{"hallström", "hallström"},
		{"hallucination", "hallucination"},
		{"hallå", "hallå"},
		{"halm", "halm"},
		{"halmgult", "halmgult"},
		{"halmhatt", "halmhat"},
		{"halmhatten", "halmhat"},
		{"hals", "hal"},
		{"halsade", "hals"},
		{"halsar", "hals"},
		{"halsband", "halsband"},
		{"halsduk", "halsduk"},
		{"halsduken", "halsduk"},
		{"halsduksknuten", "halsduksknut"},
		{"halsen", "hals"},
		{"halsgropen", "halsgrop"},
		{"halsstarriga", "halsstarr"},
		{"halt", "halt"},
		{"haltade", "halt"},
		{"haltande", "halt"},
		{"haltar", "halt"},
		{"halts", "halt"},
		{"halv", "halv"},
		{"halva", "halv"},
		{"halvan", "halvan"},
		{"halvannan", "halvannan"},
		{"halvar", "halv"},
		{"halvbildning", "halvbildning"},
		{"halvbutelj", "halvbutelj"},
		{"halvdager", "halvdag"},
		{"halvdagern", "halvdag"},
		{"halvdrömmande", "halvdrömm"},
		{"halvdunklet", "halvdunklet"},
		{"halvdöende", "halvdöend"},
		{"halvfylld", "halvfylld"},
		{"halvfärdig", "halvfärd"},
		{"halvförtäckta", "halvförtäck"},
		{"halvgamle", "halvgaml"},
		{"halvgråtande", "halvgråt"},
		{"halvhögt", "halvhög"},
		{"halvjude", "halvjud"},
		{"halvklart", "halvklart"},
		{"halvklädd", "halvkläd"},
		{"halvkvävd", "halvkvävd"},
		{"halvkvävda", "halvkvävd"},
		{"halvliggande", "halvligg"},
		{"halvläkta", "halvläk"},
		{"halvmedvetet", "halvmedvetet"},
		{"halvmörkret", "halvmörkret"},
		{"halvrökt", "halvrök"},
		{"halvskymd", "halvskymd"},
		{"halvslummer", "halvslumm"},
		{"halvslutna", "halvslutn"},
		{"halvsovande", "halvsov"},
		{"halvstop", "halvstop"},
		{"halvsänkt", "halvsänk"},
		{"halvt", "halvt"},
		{"halvtannat", "halvtan"},
		{"halvtimme", "halvtimm"},
		{"halvtoner", "halvton"},
		{"halvtömt", "halvtömt"},
		{"halvvaken", "halvvak"},
		{"halvvuxen", "halvvux"},
		{"halvvuxna", "halvvuxn"},
		{"halvvägs", "halvväg"},
		{"halvår", "halvår"},
		{"halvöppen", "halvöpp"},
		{"halvöppna", "halvöppn"},
		{"ham", "ham"},
		{"hamburg", "hamburg"},
		{"hamburger", "hamburg"},
		{"hamburgerlotteriet", "hamburgerlotteriet"},
		{"hammare", "hamm"},
		{"hamn", "hamn"},
		{"hamna", "hamn"},
		{"hamnade", "hamn"},
		{"hamnat", "hamn"},
		{"hamnen", "hamn"},
		{"hamngatan", "hamngatan"},
		{"hampfrö", "hampfrö"},
		{"hamrade", "hamr"},
		{"han", "han"},
		{"hand", "hand"},
		{"handarbctcn", "handarbctcn"},
		{"handarbete", "handarbet"},
		{"handduk", "handduk"},
		{"handdukar", "handduk"},
		{"handduken", "handduk"},
		{"handdukshängare", "handdukshäng"},
		{"handel", "handel"},
		{"handeln", "handeln"},
		{"handelsboden", "handelsbod"},
		{"handelsföretag", "handelsföretag"},
		{"handelshus", "handelshus"},
		{"handelsjudar", "handelsjud"},
		{"handelsman", "handelsman"},
		{"handelsmannen", "handelsman"},
		{"handen", "hand"},
		{"handens", "hand"},
		{"hander", "hand"},
		{"handfallen", "handfall"},
		{"handfaten", "handfat"},
		{"handfatet", "handfatet"},
		{"handflatan", "handflatan"},
		{"handfull", "handfull"},
		{"handhafva", "handhafv"},
		{"handhava", "handhav"},
		{"handkammare", "handkamm"},
		{"handkammaren", "handkamm"},
		{"handklappningar", "handklappning"},
		{"handla", "handl"},
		{"handlade", "handl"},
		{"handlande", "handl"},
		{"handlar", "handl"},
		{"handlat", "handl"},
		{"handled", "handled"},
		{"handleden", "handled"},
		{"handling", "handling"},
		{"handlingar", "handling"},
		{"handlingen", "handling"},
		{"handlingens", "handling"},
		{"handlingssätt", "handlingssät"},
		{"handlöst", "handlös"},
		{"handom", "handom"},
		{"handrörelse", "handrör"},
		{"handrörelser", "handrör"},
		{"hands", "hand"},
		{"handskar", "handsk"},
		{"handskats", "handskat"},
		{"handske", "handsk"},
		{"handsken", "handsk"},
		{"handslag", "handslag"},
		{"handstil", "handstil"},
		{"handtaget", "handtaget"},
		{"handteckning", "handteckning"},
		{"handteckningen", "handteckning"},
		{"handtera", "handter"},
		{"handtryckning", "handtryckning"},
		{"handtryckningar", "handtryckning"},
		{"handtverket", "handtverket"},
		{"handtverkslära", "handtverkslär"},
		{"handväskan", "handväskan"},
		{"hane", "han"},
		{"hanhundar", "hanhund"},
		{"hann", "hann"},
		{"hannarnas", "hann"},
		{"hanringdeoch", "hanringdeoch"},
		{"hans", "han"},
		{"hansestäderna", "hansestäd"},
		{"hantera", "hanter"},
		{"hanterar", "hanter"},
		{"hantverk", "hantverk"},
		{"hantverksklassen", "hantverksklass"},
		{"har", "har"},
		{"haraldsson", "haraldsson"},
		{"haraldssons", "haraldsson"},
		{"harang", "harang"},
		{"hard", "hard"},
		{"hardning", "hardning"},
		{"hards", "hard"},
		{"hare", "har"},
		{"harem", "harem"},
		{"haremsdam", "haremsdam"},
		{"haret", "haret"},
		{"harig", "har"},
		{"harklade", "harkl"},
		{"harkrank", "harkrank"},
		{"harl", "harl"},
		{"harm", "harm"},
		{"harmar", "harm"},
		{"harmas", "harm"},
		{"harmen", "harm"},
		{"harmligt", "harm"},
		{"harmoniska", "harmonisk"},
		{"harmoniskt", "harmonisk"},
		{"harmsen", "harms"},
		{"harmset", "harmset"},
		{"harmsna", "harmsn"},
		{"harpolek", "harpolek"},
		{"harpspelerska", "harpspelersk"},
		{"harpun", "harpun"},
		{"harpunen", "harpun"},
		{"harskling", "harskling"},
		{"harvatten", "harvat"},
		{"hasande", "has"},
		{"hasar", "has"},
		{"hasselbacken", "hasselback"},
		{"hasselbacksmiddag", "hasselbacksmiddag"},
		{"hasselblåst", "hasselblåst"},
		{"hasselfrans", "hasselfran"},
		{"hasselkäpp", "hasselkäpp"},
		{"hast", "hast"},
		{"hastade", "hast"},
		{"hastig", "hast"},
		{"hastiga", "hast"},
		{"hastighet", "hast"},
		{"hastigheten", "hast"},
		{"hastigt", "hast"},
		{"hastl", "hastl"},
		{"hat", "hat"},
		{"hata", "hat"},
		{"hatade", "hat"},
		{"hatande", "hat"},
		{"hatar", "hat"},
		{"hatat", "hat"},
		{"hatet", "hatet"},
		{"hatfulla", "hatfull"},
		{"hatska", "hatsk"},
		{"hatt", "hatt"},
		{"hattar", "hatt"},
		{"hattbrättet", "hattbrättet"},
		{"hatten", "hatt"},
		{"hatthyllan", "hatthyllan"},
		{"hattmakare", "hattmak"},
		{"hattskrålla", "hattskråll"},
		{"hau", "hau"},
		{"hav", "hav"},
		{"hava", "hav"},
		{"havande", "hav"},
		{"havannamagasinet", "havannamagasinet"},
		{"have", "hav"},
		{"haven", "hav"},
		{"haver", "hav"},
		{"havet", "havet"},
		{"havets", "havet"},
		{"havrebröd", "havrebröd"},
		{"havs", "hav"},
		{"havsbottnen", "havsbottn"},
		{"havsstranden", "havsstr"},
		{"hbma", "hbma"},
		{"hclgc", "hclgc"},
		{"hclme", "hclme"},
		{"hclt", "hclt"},
		{"hcm", "hcm"},
		{"hcmles", "hcmles"},
		{"hcnncs", "hcnncs"},
		{"hcnne", "hcnne"},
		{"hcnnes", "hcnnes"},
		{"hdde", "hdde"},
		{"hdnom", "hdnom"},
		{"hebrons", "hebron"},
		{"hed", "hed"},
		{"hedar", "hed"},
		{"hedborn", "hedborn"},
		{"heden", "hed"},
		{"hedenhös", "hedenhös"},
		{"heder", "hed"},
		{"hederlig", "heder"},
		{"hederliga", "heder"},
		{"hederlige", "heder"},
		{"hederligheten", "heder"},
		{"hederligt", "heder"},
		{"hedern", "hed"},
		{"hederns", "hed"},
		{"hedersdag", "hedersdag"},
		{"hederskänsla", "hederskänsl"},
		{"hedersmannen", "hedersman"},
		{"hedersord", "hedersord"},
		{"hederspaschan", "hederspaschan"},
		{"hedersplats", "hedersplat"},
		{"hederssak", "hederssak"},
		{"hedersvakt", "hedersvak"},
		{"hedervärda", "hedervärd"},
		{"hednatiden", "hednatid"},
		{"hedrad", "hedr"},
		{"hedrade", "hedr"},
		{"hedrande", "hedr"},
		{"hedrar", "hedr"},
		{"hedrat", "hedr"},
		{"hedrats", "hedrat"},
		{"heidelberg", "heidelberg"},
		{"heidelberga", "heidelberg"},
		{"hej", "hej"},
		{"hejda", "hejd"},
		{"hejdade", "hejd"},
		{"hejdlöst", "hejdlös"},
		{"hektiska", "hektisk"},
		{"hel", "hel"},
		{"hela", "hel"},
		{"helades", "hel"},
		{"helande", "hel"},
		{"helena", "helen"},
		{"helfigur", "helfigur"},
		{"helg", "helg"},
		{"helga", "helg"},
		{"helgad", "helg"},
		{"helgade", "helg"},
		{"helgat", "helg"},
		{"helgdagsaftonen", "helgdagsafton"},
		{"helgdagsdrägt", "helgdagsdräg"},
		{"helgdagshatten", "helgdagshat"},
		{"helgdagskläder", "helgdagskläd"},
		{"helgdagskläderna", "helgdagskläd"},
		{"helgdagsklänning", "helgdagsklänning"},
		{"helgeandsholmens", "helgeandsholm"},
		{"helgedom", "helgedom"},
		{"helgelse", "helg"},
		{"helgjuten", "helgjut"},
		{"helgon", "helgon"},
		{"helgongriften", "helgongrift"},
		{"helhet", "hel"},
		{"helig", "hel"},
		{"heliga", "hel"},
		{"heligaorden", "heligaord"},
		{"heligas", "hel"},
		{"heligaste", "hel"},
		{"helighet", "hel"},
		{"heligt", "hel"},
		{"heller", "hell"},
		{"hellre", "hellr"},
		{"helme", "helm"},
		{"helmes", "helm"},
		{"helsa", "hels"},
		{"helsad", "hels"},
		{"helsade", "hels"},
		{"helsades", "hels"},
		{"helsan", "helsan"},
		{"helsar", "hels"},
		{"helsat", "hels"},
		{"helskinnad", "helskin"},
		{"helsning", "helsning"},
		{"helsningar", "helsning"},
		{"helsningen", "helsning"},
		{"helsosamma", "helsosamm"},
		{"helst", "helst"},
		{"helt", "helt"},
		{"helv", "helv"},
		{"helvete", "helvet"},
		{"helvetes", "helvet"},
		{"helvetet", "helvetet"},
		{"helvetets", "helvetet"},
		{"helvetiska", "helvetisk"},
		{"helvetiskt", "helvetisk"},
		{"hem", "hem"},
		{"hembakade", "hembak"},
		{"hembjuden", "hembjud"},
		{"hembygd", "hembyg"},
		{"hembära", "hembär"},
		{"hemdygder", "hemdyg"},
		{"hemforslad", "hemforsl"},
		{"hemfärden", "hemfärd"},
		{"hemför", "hemför"},
		{"hemförd", "hemförd"},
		{"hemförde", "hemförd"},
		{"hemgift", "hemgift"},
		{"hemgiften", "hemgift"},
		{"hemgjorda", "hemgjord"},
		{"hemgång", "hemgång"},
		{"hemifrån", "hemifrån"},
		{"hemjordens", "hemjord"},
		{"hemkalla", "hemkall"},
		{"hemkommen", "hemkomm"},
		{"hemkommit", "hemkommit"},
		{"hemkomna", "hemkomn"},
		{"hemkomst", "hemkomst"},
		{"hemkomsten", "hemkomst"},
		{"hemkärt", "hemkärt"},
		{"hemland", "hemland"},
		{"hemlc", "hemlc"},
		{"hemle", "heml"},
		{"hemles", "heml"},
		{"hemlig", "hem"},
		{"hemliga", "hem"},
		{"hemlige", "hem"},
		{"hemligen", "hem"},
		{"hemlighet", "hem"},
		{"hemligheten", "hem"},
		{"hemligheter", "hem"},
		{"hemlighets", "hemlighet"},
		{"hemlighetsfull", "hemlighetsfull"},
		{"hemlighetsfulla", "hemlighetsfull"},
		{"hemlighetsfullt", "hemlighetsfull"},
		{"hemligt", "hem"},
		{"hemlotsande", "hemlots"},
		{"hemlängtan", "hemlängtan"},
		{"hemma", "hemm"},
		{"hemmansdöttrar", "hemmansdöttr"},
		{"hemmansägardotter", "hemmansägardot"},
		{"hemmansägare", "hemmansäg"},
		{"hemmastadd", "hemmastad"},
		{"hemmastatt", "hemmastat"},
		{"hemmavaro", "hemmavaro"},
		{"hemme", "hemm"},
		{"hemmes", "hemm"},
		{"hemmet", "hemmet"},
		{"hemmets", "hemmet"},
		{"hemne", "hemn"},
		{"hemort", "hemort"},
		{"hemorten", "hemort"},
		{"hemresa", "hemres"},
		{"hemresan", "hemresan"},
		{"hemresande", "hemres"},
		{"hemrma", "hemrm"},
		{"hemsjuk", "hemsjuk"},
		{"hemsk", "hemsk"},
		{"hemska", "hemsk"},
		{"hemskhet", "hemsk"},
		{"hemskickad", "hemskick"},
		{"hemskt", "hemsk"},
		{"hemstad", "hemst"},
		{"hemsökelsen", "hemsök"},
		{"hemsökelser", "hemsök"},
		{"hemsökte", "hemsök"},
		{"hemsöktes", "hemsök"},
		{"hemta", "hemt"},
		{"hemtade", "hemt"},
		{"hemtades", "hemt"},
		{"hemtar", "hemt"},
		{"hemtrevligt", "hemtrev"},
		{"hemtrevnad", "hemtrevn"},
		{"hemväg", "hemväg"},
		{"hemvägen", "hemväg"},
		{"hemåt", "hemåt"},
		{"hen", "hen"},
		{"henck", "henck"},
		{"hencks", "henck"},
		{"hende", "hend"},
		{"hendec", "hendec"},
		{"henmc", "henmc"},
		{"henme", "henm"},
		{"henmes", "henm"},
		{"henna", "henn"},
		{"hennc", "hennc"},
		{"henncs", "hennc"},
		{"henne", "henn"},
		{"hennes", "henn"},
		{"henning", "henning"},
		{"hennings", "henning"},
		{"hennt", "hennt"},
		{"henrika", "henrik"},
		{"henrle", "henrl"},
		{"heraldik", "heraldik"},
		{"heraldiskt", "heraldisk"},
		{"herbergera", "herberger"},
		{"herbergerat", "herberger"},
		{"herde", "herd"},
		{"herdespel", "herdespel"},
		{"herdesång", "herdesång"},
		{"herdinna", "herdin"},
		{"hergell", "hergell"},
		{"herme", "herm"},
		{"hern", "hern"},
		{"herodes", "herod"},
		{"herodias", "herodi"},
		{"heroiske", "heroisk"},
		{"herr", "herr"},
		{"herran", "herran"},
		{"herranom", "herranom"},
		{"herrans", "herran"},
		{"herrar", "herr"},
		{"herrarna", "herr"},
		{"herrarnas", "herr"},
		{"herrarne", "herr"},
		{"herre", "herr"},
		{"herregud", "herregud"},
		{"herrejestanes", "herrejestan"},
		{"herrekarlar", "herrekarl"},
		{"herrekarlsrock", "herrekarlsrock"},
		{"herrelös", "herrelös"},
		{"herrelösa", "herrelös"},
		{"herren", "herr"},
		{"herrens", "herr"},
		{"herres", "herr"},
		{"herresäte", "herresät"},
		{"herresätena", "herresäten"},
		{"herrgardsekipage", "herrgardsekipag"},
		{"herrgdrdsbyggnaden", "herrgdrdsbyggnad"},
		{"herrgård", "herrgård"},
		{"herrgårdar", "herrgård"},
		{"herrgården", "herrgård"},
		{"herrgårdsbyggnaden", "herrgårdsbyggnad"},
		{"herrgårdsdamerna", "herrgårdsdam"},
		{"herrgårdsekipage", "herrgårdsekipag"},
		{"herrgårdsfröken", "herrgårdsfrök"},
		{"herrgårdsköket", "herrgårdsköket"},
		{"herrgårdsliv", "herrgårdsliv"},
		{"herrgårdsrum", "herrgårdsrum"},
		{"herrinnan", "herrinnan"},
		{"herrn", "herrn"},
		{"herrskap", "herrskap"},
		{"herrskapers", "herrskaper"},
		{"herrskapet", "herrskapet"},
		{"herrskapets", "herrskapet"},
		{"herrskaps", "herrskap"},
		{"herrskapsfolkets", "herrskapsfolket"},
		{"herrskapsklassen", "herrskapsklass"},
		{"herskade", "hersk"},
		{"hertha", "herth"},
		{"herthas", "herth"},
		{"hertig", "hert"},
		{"hertigen", "hert"},
		{"hes", "hes"},
		{"hesa", "hes"},
		{"hesatt", "hesat"},
		{"heslutsamhet", "heslutsam"},
		{"hessingen", "hessing"},
		{"hest", "hest"},
		{"het", "het"},
		{"heta", "het"},
		{"hetare", "het"},
		{"hetast", "het"},
		{"hetat", "het"},
		{"heten", "het"},
		{"hetens", "het"},
		{"heter", "het"},
		{"hetmes", "hetm"},
		{"hets", "het"},
		{"hetsa", "hets"},
		{"hetsad", "hets"},
		{"hetsade", "hets"},
		{"hetsande", "hets"},
		{"hetsar", "hets"},
		{"hetsig", "hets"},
		{"hetsiga", "hets"},
		{"hetsigt", "hets"},
		{"hetsit", "hetsit"},
		{"hetsjakt", "hetsjak"},
		{"hett", "hett"},
		{"hetta", "hett"},
		{"hettade", "hett"},
		{"hettan", "hettan"},
		{"hettande", "hett"},
		{"hette", "hett"},
		{"hga", "hga"},
		{"hi", "hi"},
		{"hicka", "hick"},
		{"him", "him"},
		{"himlabryn", "himlabryn"},
		{"himlabågen", "himlabåg"},
		{"himlafrö", "himlafrö"},
		{"himlande", "himl"},
		{"himlen", "himl"},
		{"himlens", "himl"},
		{"himmel", "himmel"},
		{"himmelen", "himmel"},
		{"himmelens", "himmel"},
		{"himmeln", "himmeln"},
		{"himmelriket", "himmelriket"},
		{"himmelrikets", "himmelriket"},
		{"himmels", "himmel"},
		{"himmelska", "himmelsk"},
		{"himmelskas", "himmelsk"},
		{"himmelske", "himmelsk"},
		{"himmelskt", "himmelsk"},
		{"himmelssäng", "himmelssäng"},
		{"himmelssängen", "himmelssäng"},
		{"himmrlskt", "himmrlsk"},
		{"hin", "hin"},
		{"hind", "hind"},
		{"hinder", "hind"},
		{"hindra", "hindr"},
		{"hindrad", "hindr"},
		{"hindrade", "hindr"},
		{"hindrar", "hindr"},
		{"hindrat", "hindr"},
		{"hink", "hink"},
		{"hinken", "hink"},
		{"hinna", "hinn"},
		{"hinner", "hinn"},
		{"hiram", "hiram"},
		{"hiskligt", "hisk"},
		{"hisnade", "hisn"},
		{"hisnande", "hisn"},
		{"hissades", "hiss"},
		{"historia", "histori"},
		{"historie", "histori"},
		{"historielärare", "historielär"},
		{"historieläraren", "historielär"},
		{"historielärarinnan", "historielärarinnan"},
		{"historiemålning", "historiemålning"},
		{"historien", "histori"},
		{"historier", "histori"},
		{"historierna", "histori"},
		{"historietimme", "historietimm"},
		{"histrioner", "histrion"},
		{"hit", "hit"},
		{"hitbjudit", "hitbjudit"},
		{"hitintills", "hitintill"},
		{"hitresa", "hitres"},
		{"hitskickade", "hitskick"},
		{"hitta", "hitt"},
		{"hittadc", "hittadc"},
		{"hittade", "hitt"},
		{"hittar", "hitt"},
		{"hittat", "hitt"},
		{"hittebarn", "hittebarn"},
		{"hittills", "hittill"},
		{"hitåt", "hitåt"},
		{"hjalmar", "hjalm"},
		{"hjalpa", "hjalp"},
		{"hjalplöshet", "hjalplös"},
		{"hjalplöst", "hjalplös"},
		{"hjalpte", "hjalpt"},
		{"hjarhn", "hjarhn"},
		{"hjarna", "hjarn"},
		{"hjarta", "hjart"},
		{"hjartan", "hjartan"},
		{"hjel", "hjel"},
		{"hjelp", "hjelp"},
		{"hjelpa", "hjelp"},
		{"hjelpe", "hjelp"},
		{"hjelpen", "hjelp"},
		{"hjelper", "hjelp"},
		{"hjelpreda", "hjelpred"},
		{"hjelpt", "hjelpt"},
		{"hjelpte", "hjelpt"},
		{"hjelptes", "hjelpt"},
		{"hjelte", "hjelt"},
		{"hjeltinna", "hjeltin"},
		{"hjerna", "hjern"},
		{"hjernan", "hjernan"},
		{"hjerta", "hjert"},
		{"hjertan", "hjertan"},
		{"hjertandes", "hjert"},
		{"hjertans", "hjertan"},
		{"hjertas", "hjert"},
		{"hjertat", "hjert"},
		{"hjertats", "hjertat"},
		{"hjerteqval", "hjerteqval"},
		{"hjertesorg", "hjertesorg"},
		{"hjerteångest", "hjerteångest"},
		{"hjertgropen", "hjertgrop"},
		{"hjertklappning", "hjertklappning"},
		{"hjertlig", "hjert"},
		{"hjertliga", "hjert"},
		{"hjertligaste", "hjert"},
		{"hjertligen", "hjert"},
		{"hjertligt", "hjert"},
		{"hjertlöse", "hjertlös"},
		{"hjon", "hjon"},
		{"hjord", "hjord"},
		{"hjortronplan", "hjortronplan"},
		{"hjul", "hjul"},
		{"hjulens", "hjul"},
		{"hjulet", "hjulet"},
		{"hjulets", "hjulet"},
		{"hjulspårens", "hjulspår"},
		{"hjälp", "hjälp"},
		{"hjälpa", "hjälp"},
		{"hjälpande", "hjälp"},
		{"hjälpas", "hjälp"},
		{"hjälpe", "hjälp"},
		{"hjälpen", "hjälp"},
		{"hjälper", "hjälp"},
		{"hjälpligt", "hjälp"},
		{"hjälplös", "hjälplös"},
		{"hjälplösa", "hjälplös"},
		{"hjälplöst", "hjälplös"},
		{"hjälpmadam", "hjälpmadam"},
		{"hjälpmadamens", "hjälpmadam"},
		{"hjälpmadammen", "hjälpmadamm"},
		{"hjälpmadams", "hjälpmadam"},
		{"hjälpsam", "hjälpsam"},
		{"hjälpsamma", "hjälpsamm"},
		{"hjälpt", "hjälpt"},
		{"hjälpte", "hjälpt"},
		{"hjälte", "hjält"},
		{"hjältemod", "hjältemod"},
		{"hjältemodig", "hjältemod"},
		{"hjältemodiga", "hjältemod"},
		{"hjältemodigt", "hjältemod"},
		{"hjälten", "hjält"},
		{"hjältes", "hjält"},
		{"hjältinnan", "hjältinnan"},
		{"hjälös", "hjälös"},
		{"hjärna", "hjärn"},
		{"hjärnan", "hjärnan"},
		{"hjärnans", "hjärnan"},
		{"hjärnor", "hjärn"},
		{"hjärta", "hjärt"},
		{"hjärtan", "hjärtan"},
		{"hjärtans", "hjärtan"},
		{"hjärtas", "hjärt"},
		{"hjärtat", "hjärt"},
		{"hjärtats", "hjärtat"},
		{"hjärtegryn", "hjärtegryn"},
		{"hjärtelag", "hjärtelag"},
		{"hjärtemänniskor", "hjärtemännisk"},
		{"hjärtenerv", "hjärtenerv"},
		{"hjärtenära", "hjärtenär"},
		{"hjärterknekt", "hjärterknek"},
		{"hjärterötter", "hjärteröt"},
		{"hjärtesorg", "hjärtesorg"},
		{"hjärtfelet", "hjärtfelet"},
		{"hjärtförlamning", "hjärtförlamning"},
		{"hjärtklappning", "hjärtklappning"},
		{"hjärtklappningen", "hjärtklappning"},
		{"hjärtklämning", "hjärtklämning"},
		{"hjärtlidande", "hjärtlid"},
		{"hjärtlig", "hjärt"},
		{"hjärtliga", "hjärt"},
		{"hjärtligaste", "hjärt"},
		{"hjärtlighet", "hjärt"},
		{"hjärtligt", "hjärt"},
		{"hjärtlös", "hjärtlös"},
		{"hjärtlösa", "hjärtlös"},
		{"hjärtlöst", "hjärtlös"},
		{"hjärtrörande", "hjärtrör"},
		{"hjärtrörelserna", "hjärtrör"},
		{"hjärtsjukdomar", "hjärtsjukdom"},
		{"hjärtslag", "hjärtslag"},
		{"hjäs", "hjäs"},
		{"hjässa", "hjäss"},
		{"hjässan", "hjässan"},
		{"hjålpa", "hjålp"},
		{"hjårta", "hjårt"},
		{"hjårtan", "hjårtan"},
		{"hl", "hl"},
		{"hlalp", "hlalp"},
		{"hlen", "hlen"},
		{"hlften", "hlften"},
		{"hlför", "hlför"},
		{"hlgen", "hlgen"},
		{"hlivit", "hlivit"},
		{"hlixtlik", "hlixtlik"},
		{"hlod", "hlod"},
		{"hltc", "hltc"},
		{"hlte", "hlte"},
		{"hlygrel", "hlygrel"},
		{"hm", "hm"},
		{"hmde", "hmde"},
		{"hml", "hml"},
		{"hnn", "hnn"},
		{"ho", "ho"},
		{"hobktare", "hobk"},
		{"hofkläder", "hofkläd"},
		{"hog", "hog"},
		{"hogt", "hogt"},
		{"hoj", "hoj"},
		{"hol", "hol"},
		{"holl", "holl"},
		{"holländskt", "holländsk"},
		{"holm", "holm"},
		{"holmar", "holm"},
		{"holme", "holm"},
		{"holmen", "holm"},
		{"holmström", "holmström"},
		{"holmströms", "holmström"},
		{"homeros", "homero"},
		{"homme", "homm"},
		{"hon", "hon"},
		{"honett", "honet"},
		{"honnett", "honnet"},
		{"honoll", "honoll"},
		{"honom", "honom"},
		{"hononl", "hononl"},
		{"honor", "hon"},
		{"honorar", "honor"},
		{"honorera", "honorer"},
		{"honung", "honung"},
		{"honungsbytta", "honungsbyt"},
		{"honungshusen", "honungshus"},
		{"honungssöta", "honungssöt"},
		{"hop", "hop"},
		{"hopa", "hop"},
		{"hopade", "hop"},
		{"hopades", "hop"},
		{"hopen", "hop"},
		{"hopfallen", "hopfall"},
		{"hopfällda", "hopfälld"},
		{"hopgyttrade", "hopgyttr"},
		{"hopklämde", "hopklämd"},
		{"hopknipen", "hopknip"},
		{"hopknipet", "hopknipet"},
		{"hopknipna", "hopknipn"},
		{"hopknycklade", "hopknyckl"},
		{"hopknäppte", "hopknäppt"},
		{"hopkopplade", "hopkoppl"},
		{"hopkrupen", "hopkrup"},
		{"hoplagda", "hoplag"},
		{"hoplagt", "hoplag"},
		{"hopp", "hopp"},
		{"hoppa", "hopp"},
		{"hoppade", "hopp"},
		{"hoppades", "hopp"},
		{"hoppande", "hopp"},
		{"hoppar", "hopp"},
		{"hoppas", "hopp"},
		{"hoppats", "hoppat"},
		{"hoppet", "hoppet"},
		{"hoppfulla", "hoppfull"},
		{"hoppla", "hoppl"},
		{"hopplösa", "hopplös"},
		{"hopplöshet", "hopplös"},
		{"hopplöst", "hopplös"},
		{"hoppning", "hoppning"},
		{"hoppningsfullt", "hoppningsfull"},
		{"hoppressade", "hoppress"},
		{"hoprafsat", "hoprafs"},
		{"hopsjunken", "hopsjunk"},
		{"hopsydda", "hopsyd"},
		{"hoptryckt", "hoptryck"},
		{"hopvecklade", "hopveckl"},
		{"hopvek", "hopvek"},
		{"hor", "hor"},
		{"hora", "hor"},
		{"horaktige", "horakt"},
		{"horas", "hor"},
		{"horde", "hord"},
		{"horisk", "horisk"},
		{"horisont", "horisont"},
		{"horisontala", "horisontal"},
		{"horisonten", "horisont"},
		{"horn", "horn"},
		{"hornen", "horn"},
		{"horniga", "horn"},
		{"horribelt", "horribelt"},
		{"horribla", "horribl"},
		{"hort", "hort"},
		{"horta", "hort"},
		{"hos", "hos"},
		{"hospital", "hospital"},
		{"hostade", "host"},
		{"hosten", "host"},
		{"hot", "hot"},
		{"hota", "hot"},
		{"hotad", "hot"},
		{"hotade", "hot"},
		{"hotande", "hot"},
		{"hotar", "hot"},
		{"hotas", "hot"},
		{"hotel", "hotel"},
		{"hotell", "hotell"},
		{"hotellbeställning", "hotellbeställning"},
		{"hotellet", "hotellet"},
		{"hotellgården", "hotellgård"},
		{"hotellrum", "hotellrum"},
		{"hotellrummet", "hotellrummet"},
		{"hotelse", "hot"},
		{"hotelser", "hot"},
		{"hottentottskor", "hottentottsk"},
		{"hov", "hov"},
		{"hovman", "hovman"},
		{"hovmästare", "hovmäst"},
		{"hovmästaren", "hovmäst"},
		{"hovmästarinna", "hovmästarin"},
		{"hovmästarinnan", "hovmästarinnan"},
		{"hovmästarinnans", "hovmästarinnan"},
		{"hovnarr", "hovnarr"},
		{"hovpredikant", "hovpredikant"},
		{"hovrätt", "hovrät"},
		{"hovrätten", "hovrät"},
		{"hr", "hr"},
		{"hra", "hra"},
		{"hrencreutz", "hrencreutz"},
		{"hrudgum", "hrudgum"},
		{"htet", "htet"},
		{"hu", "hu"},
		{"hubert", "hubert"},
		{"hud", "hud"},
		{"hude", "hud"},
		{"huden", "hud"},
		{"hudens", "hud"},
		{"hudingar", "huding"},
		{"hudsjukdomar", "hudsjukdom"},
		{"hufvu", "hufvu"},
		{"hufvud", "hufvud"},
		{"hufvuden", "hufvud"},
		{"hufvudet", "hufvudet"},
		{"hufvudgärden", "hufvudgärd"},
		{"hufvudkudden", "hufvudkud"},
		{"hufvudpersonerna", "hufvudperson"},
		{"hufvudsaken", "hufvudsak"},
		{"hufvudstaden", "hufvudstad"},
		{"hufvudvärk", "hufvudvärk"},
		{"hugad", "hug"},
		{"hugg", "hugg"},
		{"hugga", "hugg"},
		{"huggaren", "hugg"},
		{"huggit", "huggit"},
		{"hugnad", "hugn"},
		{"hugnade", "hugn"},
		{"hugnades", "hugn"},
		{"hugnar", "hugn"},
		{"hugos", "hugo"},
		{"hugskott", "hugskot"},
		{"hugsvalelse", "hugsval"},
		{"huj", "huj"},
		{"hukade", "huk"},
		{"hula", "hul"},
		{"hulda", "huld"},
		{"huldaste", "huld"},
		{"hulde", "huld"},
		{"huldhet", "huld"},
		{"hull", "hull"},
		{"huller", "hull"},
		{"hullet", "hullet"},
		{"hulpit", "hulpit"},
		{"hult", "hult"},
		{"hum", "hum"},
		{"humanaste", "human"},
		{"humanist", "humanist"},
		{"humanitäre", "humanitär"},
		{"humant", "humant"},
		{"humbug", "humbug"},
		{"humbugen", "humbug"},
		{"humd", "humd"},
		{"humle", "huml"},
		{"humlegården", "humlegård"},
		{"humlegårdens", "humlegård"},
		{"humlegårdsgatan", "humlegårdsgatan"},
		{"humlerankor", "humlerank"},
		{"humlesvärm", "humlesvärm"},
		{"humlor", "huml"},
		{"humlornas", "huml"},
		{"hummer", "humm"},
		{"hummertina", "hummertin"},
		{"hummertinan", "hummertinan"},
		{"hummertänger", "hummertäng"},
		{"humor", "hum"},
		{"humorist", "humorist"},
		{"humoristiskt", "humoristisk"},
		{"humrar", "humr"},
		{"humör", "humör"},
		{"hun", "hun"},
		{"hund", "hund"},
		{"hundar", "hund"},
		{"hundarna", "hund"},
		{"hundarne", "hund"},
		{"hunden", "hund"},
		{"hundens", "hund"},
		{"hundgård", "hundgård"},
		{"hundhjärna", "hundhjärn"},
		{"hundlivets", "hundlivet"},
		{"hundra", "hundr"},
		{"hundrade", "hundr"},
		{"hundratals", "hundratal"},
		{"hunds", "hund"},
		{"hundsnus", "hundsnus"},
		{"hundvalp", "hundvalp"},
		{"hunger", "hung"},
		{"hungern", "hung"},
		{"hungerns", "hung"},
		{"hungrat", "hungr"},
		{"hungrig", "hungr"},
		{"hungriga", "hungr"},
		{"hungrigt", "hungr"},
		{"hunne", "hunn"},
		{"hunnet", "hunnet"},
		{"hunnit", "hunnit"},
		{"hunno", "hunno"},
		{"hur", "hur"},
		{"hurdan", "hurdan"},
		{"hurnlegården", "hurnlegård"},
		{"hurrade", "hurr"},
		{"hurtig", "hurt"},
		{"hurtiga", "hurt"},
		{"hurtige", "hurt"},
		{"hurtigt", "hurt"},
		{"huru", "huru"},
		{"hurudan", "hurudan"},
		{"hurudana", "hurudan"},
		{"hurudant", "hurudant"},
		{"huruledes", "huruled"},
		{"hurusom", "hurusom"},
		{"huruvida", "huruvid"},
		{"hus", "hus"},
		{"husbehov", "husbehov"},
		{"husbestyr", "husbestyr"},
		{"husbonde", "husbond"},
		{"husbondefolk", "husbondefolk"},
		{"husbonderätt", "husbonderät"},
		{"husbondes", "husbond"},
		{"husbondeväldet", "husbondeväldet"},
		{"husen", "hus"},
		{"husens", "hus"},
		{"huserade", "huser"},
		{"huseru", "huseru"},
		{"huset", "huset"},
		{"husets", "huset"},
		{"husfolkets", "husfolket"},
		{"husfriden", "husfrid"},
		{"husfridens", "husfrid"},
		{"husfru", "husfru"},
		{"husfrun", "husfrun"},
		{"husfruns", "husfrun"},
		{"husfrus", "husfrus"},
		{"husförestånderska", "husföreståndersk"},
		{"husgeråd", "husgeråd"},
		{"husgerådet", "husgerådet"},
		{"husgöromål", "husgöromål"},
		{"husgöromålet", "husgöromålet"},
		{"hushåll", "hushåll"},
		{"hushålla", "hushåll"},
		{"hushållar", "hushåll"},
		{"hushållerska", "hushållersk"},
		{"hushållerskan", "hushållerskan"},
		{"hushållerskas", "hushållersk"},
		{"hushållet", "hushållet"},
		{"hushållning", "hushållning"},
		{"hushållningen", "hushållning"},
		{"hushålls", "hushåll"},
		{"hushållsaktig", "hushållsakt"},
		{"hushållsaktighet", "hushållsakt"},
		{"hushållsbestyr", "hushållsbestyr"},
		{"hushållsgeni", "hushållsgeni"},
		{"hushållskonto", "hushållskonto"},
		{"hushållspenningarna", "hushållspenning"},
		{"hushållsprinciper", "hushållsprincip"},
		{"hushållsprinciperna", "hushållsprincip"},
		{"hushållssaker", "hushållssak"},
		{"hushållsskola", "hushållsskol"},
		{"hushållsskolan", "hushållsskolan"},
		{"hushållsskolans", "hushållsskolan"},
		{"hushållssumman", "hushållssumman"},
		{"hushållssyssla", "hushållssyssl"},
		{"hushållsuppköp", "hushållsuppköp"},
		{"hushållsvetenskap", "hushållsvetenskap"},
		{"hushållsväg", "hushållsväg"},
		{"hushållvetenskap", "hushållvetenskap"},
		{"husknut", "husknut"},
		{"husknutarna", "husknut"},
		{"husknuten", "husknut"},
		{"huslig", "hus"},
		{"husliga", "hus"},
		{"huslighet", "hus"},
		{"husligt", "hus"},
		{"husläkare", "husläk"},
		{"husläkaren", "husläk"},
		{"husmamsell", "husmamsell"},
		{"husmoder", "husmod"},
		{"husmoderlig", "husmoder"},
		{"husmoderliga", "husmoder"},
		{"husmodern", "husmod"},
		{"husmoderns", "husmod"},
		{"husmor", "husm"},
		{"husnummer", "husnumm"},
		{"huspigan", "huspigan"},
		{"hustaken", "hustak"},
		{"hustru", "hustru"},
		{"hustrublick", "hustrublick"},
		{"hustrumin", "hustrumin"},
		{"hustrun", "hustrun"},
		{"hustruns", "hustrun"},
		{"hustrur", "hustrur"},
		{"hustrurna", "hustrurn"},
		{"hustrurnas", "hustrurn"},
		{"hustrurs", "hustrur"},
		{"hustrus", "hustrus"},
		{"husundersökning", "husundersökning"},
		{"hut", "hut"},
		{"huttrade", "huttr"},
		{"huvadet", "huvadet"},
		{"huvans", "huvan"},
		{"huven", "huv"},
		{"huvu", "huvu"},
		{"huvud", "huvud"},
		{"huvudallen", "huvudall"},
		{"huvudbonaden", "huvudbonad"},
		{"huvudbry", "huvudbry"},
		{"huvudbyggnaden", "huvudbyggnad"},
		{"huvudduk", "huvudduk"},
		{"huvuddukarna", "huvudduk"},
		{"huvuden", "huvud"},
		{"huvudena", "huvuden"},
		{"huvudenas", "huvuden"},
		{"huvudet", "huvudet"},
		{"huvudfiende", "huvudfiend"},
		{"huvudgrupper", "huvudgrupp"},
		{"huvudgärd", "huvudgärd"},
		{"huvudgärden", "huvudgärd"},
		{"huvudkudde", "huvudkud"},
		{"huvudkudden", "huvudkud"},
		{"huvudman", "huvudman"},
		{"huvudrollen", "huvudroll"},
		{"huvudsaken", "huvudsak"},
		{"huvudsakligen", "huvudsak"},
		{"huvudstad", "huvudst"},
		{"huvudstaden", "huvudstad"},
		{"huvudstadens", "huvudstad"},
		{"huvudvillkoret", "huvudvillkoret"},
		{"huvudvärk", "huvudvärk"},
		{"huvudvärken", "huvudvärk"},
		{"hux", "hux"},
		{"hvad", "hvad"},
		{"hvadan", "hvadan"},
		{"hvalf", "hvalf"},
		{"hvalfiskarne", "hvalfisk"},
		{"hvar", "hvar"},
		{"hvaraf", "hvaraf"},
		{"hvarandra", "hvarandr"},
		{"hvardagliga", "hvardag"},
		{"hvardagsgäst", "hvardagsgäst"},
		{"hvardagslag", "hvardagslag"},
		{"hvardera", "hvarder"},
		{"hvarefter", "hvareft"},
		{"hvaremot", "hvaremot"},
		{"hvarest", "hvarest"},
		{"hvarför", "hvarför"},
		{"hvarföre", "hvarför"},
		{"hvari", "hvari"},
		{"hvaribland", "hvaribland"},
		{"hvarifrån", "hvarifrån"},
		{"hvarigenom", "hvarigenom"},
		{"hvarje", "hvarj"},
		{"hvarjehanda", "hvarjehand"},
		{"hvarken", "hvark"},
		{"hvarmed", "hvarmed"},
		{"hvarom", "hvarom"},
		{"hvarpå", "hvarpå"},
		{"hvars", "hvar"},
		{"hvart", "hvart"},
		{"hvarthelst", "hvarthelst"},
		{"hvartill", "hvartill"},
		{"hvarunder", "hvarund"},
		{"hvaruti", "hvaruti"},
		{"hvarvid", "hvarvid"},
		{"hvaråt", "hvaråt"},
		{"hvaröfver", "hvaröfv"},
		{"hvem", "hvem"},
		{"hvems", "hvem"},
		{"hvetebröd", "hvetebröd"},
		{"hvi", "hvi"},
		{"hvila", "hvil"},
		{"hvilade", "hvil"},
		{"hvilat", "hvil"},
		{"hvilka", "hvilk"},
		{"hvilkas", "hvilk"},
		{"hvilken", "hvilk"},
		{"hvilket", "hvilket"},
		{"hvilodag", "hvilodag"},
		{"hvilorum", "hvilorum"},
		{"hvirflar", "hvirfl"},
		{"hviska", "hvisk"},
		{"hviskade", "hvisk"},
		{"hviskande", "hvisk"},
		{"hviskat", "hvisk"},
		{"hvissling", "hvissling"},
		{"hvit", "hvit"},
		{"hvita", "hvit"},
		{"hvitklädd", "hvitkläd"},
		{"hvitt", "hvitt"},
		{"hvtll", "hvtll"},
		{"hvälfde", "hvälfd"},
		{"hy", "hy"},
		{"hyckla", "hyckl"},
		{"hycklare", "hyckl"},
		{"hyckleri", "hyckleri"},
		{"hycklerskan", "hycklerskan"},
		{"hydda", "hydd"},
		{"hyddor", "hydd"},
		{"hygglig", "hygg"},
		{"hyggliga", "hygg"},
		{"hygglige", "hygg"},
		{"hyggligt", "hygg"},
		{"hygienisk", "hygienisk"},
		{"hylla", "hyll"},
		{"hyllan", "hyllan"},
		{"hyllning", "hyllning"},
		{"hyllor", "hyll"},
		{"hyllorna", "hyll"},
		{"hymn", "hymn"},
		{"hymnen", "hymn"},
		{"hymner", "hymn"},
		{"hyn", "hyn"},
		{"hyndan", "hyndan"},
		{"hyndans", "hyndan"},
		{"hypetek", "hypetek"},
		{"hypnotisera", "hypnotiser"},
		{"hypnotiserar", "hypnotiser"},
		{"hypnotiserats", "hypnotiserat"},
		{"hypnotisk", "hypnotisk"},
		{"hypnotism", "hypnotism"},
		{"hypokonder", "hypokond"},
		{"hypotek", "hypotek"},
		{"hyr", "hyr"},
		{"hyra", "hyr"},
		{"hyran", "hyran"},
		{"hyrde", "hyrd"},
		{"hyrer", "hyr"},
		{"hyresgäster", "hyresgäst"},
		{"hyresmannen", "hyresman"},
		{"hyrt", "hyrt"},
		{"hyrvagn", "hyrvagn"},
		{"hyrvagnarna", "hyrvagn"},
		{"hysa", "hys"},
		{"hyser", "hys"},
		{"hyskor", "hysk"},
		{"hyst", "hyst"},
		{"hyste", "hyst"},
		{"hysterisk", "hysterisk"},
		{"hysteriska", "hysterisk"},
		{"hysteriskt", "hysterisk"},
		{"hytten", "hytt"},
		{"hyvel", "hyvel"},
		{"hä", "hä"},
		{"häcklefjäll", "häcklefjäll"},
		{"hädan", "hädan"},
		{"hädanefter", "hädaneft"},
		{"hädangångna", "hädangångn"},
		{"hädangångnas", "hädangångn"},
		{"hädd", "hädd"},
		{"häfda", "häfd"},
		{"häftad", "häft"},
		{"häftade", "häft"},
		{"häfte", "häft"},
		{"häftet", "häftet"},
		{"häftig", "häft"},
		{"häftiga", "häft"},
		{"häftigare", "häft"},
		{"häftighet", "häft"},
		{"häftigt", "häft"},
		{"häggblom", "häggblom"},
		{"häggblommor", "häggblomm"},
		{"häggen", "hägg"},
		{"hägn", "hägn"},
		{"hägnade", "hägn"},
		{"häktad", "häkt"},
		{"häktas", "häkt"},
		{"häkte", "häkt"},
		{"häl", "häl"},
		{"hälarna", "häl"},
		{"hälarne", "häl"},
		{"hälft", "hälft"},
		{"hälften", "hälft"},
		{"hälfter", "hälft"},
		{"hälfterna", "hälft"},
		{"hälla", "häll"},
		{"hällde", "hälld"},
		{"hälleberget", "hälleberget"},
		{"hällen", "häll"},
		{"hällens", "häll"},
		{"hällre", "hällr"},
		{"hälsa", "häls"},
		{"hälsad", "häls"},
		{"hälsade", "häls"},
		{"hälsades", "häls"},
		{"hälsan", "hälsan"},
		{"hälsande", "häls"},
		{"hälsans", "hälsan"},
		{"hälsar", "häls"},
		{"hälsas", "häls"},
		{"hälsat", "häls"},
		{"hälsning", "hälsning"},
		{"hälsningar", "hälsning"},
		{"hälsningarna", "hälsning"},
		{"hälsningen", "hälsning"},
		{"hälsobrunn", "hälsobrun"},
		{"hälsofarlighet", "hälsofar"},
		{"hälsosamt", "hälsosamt"},
		{"hälsotillstånd", "hälsotillstånd"},
		{"hälsovinst", "hälsovinst"},
		{"häm", "häm"},
		{"hämma", "hämm"},
		{"hämna", "hämn"},
		{"hämnade", "hämn"},
		{"hämnar", "hämn"},
		{"hämnas", "hämn"},
		{"hämnd", "hämnd"},
		{"hämta", "hämt"},
		{"hämtade", "hämt"},
		{"hämtande", "hämt"},
		{"hämtar", "hämt"},
		{"hämtat", "hämt"},
		{"hän", "hän"},
		{"hända", "händ"},
		{"händcr", "händcr"},
		{"hände", "händ"},
		{"händels", "händel"},
		{"händelse", "händ"},
		{"händelseförloppet", "händelseförloppet"},
		{"händelsen", "händ"},
		{"händelser", "händ"},
		{"händelserna", "händ"},
		{"händelsevis", "händelsevis"},
		{"händer", "händ"},
		{"händerna", "händ"},
		{"händerochhjälpadem", "händerochhjälpadem"},
		{"händren", "händr"},
		{"händt", "händ"},
		{"hänför", "hänför"},
		{"hänföra", "hänför"},
		{"hänförande", "hänför"},
		{"hänförd", "hänförd"},
		{"hänförda", "hänförd"},
		{"hänfört", "hänfört"},
		{"hänga", "häng"},
		{"hängande", "häng"},
		{"hängbjörkarna", "hängbjörk"},
		{"hängde", "häng"},
		{"hängdes", "häng"},
		{"hänger", "häng"},
		{"hänggranshult", "hänggranshult"},
		{"hängifvenhet", "hängifven"},
		{"hängivenhet", "hängiven"},
		{"hänglar", "hängl"},
		{"hängt", "häng"},
		{"hänqckning", "hänqckning"},
		{"hänryckning", "hänryckning"},
		{"hänryckta", "hänryck"},
		{"hänseende", "hänseend"},
		{"hänseenden", "hänseend"},
		{"hänsyn", "hänsyn"},
		{"hänsynsfull", "hänsynsfull"},
		{"hänsynslös", "hänsynslös"},
		{"hänsynslösa", "hänsynslös"},
		{"hänsynslöst", "hänsynslös"},
		{"hänt", "hänt"},
		{"häntyda", "häntyd"},
		{"häntydande", "häntyd"},
		{"häntydde", "häntyd"},
		{"häntydning", "häntydning"},
		{"häntydningar", "häntydning"},
		{"häntydningen", "häntydning"},
		{"hänvisa", "hänvis"},
		{"hänvisat", "hänvis"},
		{"hänvisning", "hänvisning"},
		{"häpen", "häp"},
		{"häpna", "häpn"},
		{"häpnad", "häpn"},
		{"häpnade", "häpn"},
		{"häpnande", "häpn"},
		{"häpnar", "häpn"},
		{"häpnat", "häpn"},
		{"här", "här"},
		{"härad", "här"},
		{"häradshövding", "häradshövding"},
		{"häradshövdingen", "häradshövding"},
		{"häradsväg", "häradsväg"},
		{"häraf", "häraf"},
		{"härar", "här"},
		{"härav", "härav"},
		{"härbärgera", "härbärger"},
		{"härbärgerar", "härbärger"},
		{"härd", "härd"},
		{"härdad", "härd"},
		{"härdar", "härd"},
		{"härdens", "härd"},
		{"härdningen", "härdning"},
		{"härefter", "häreft"},
		{"häremellan", "häremellan"},
		{"häremot", "häremot"},
		{"härflöt", "härflöt"},
		{"härifran", "härifran"},
		{"härifrån", "härifrån"},
		{"häriig", "häri"},
		{"härjad", "härj"},
		{"härjade", "härj"},
		{"härjadt", "härjad"},
		{"härjande", "härj"},
		{"härjar", "härj"},
		{"härjat", "härj"},
		{"härkomst", "härkomst"},
		{"härledde", "härled"},
		{"härlig", "här"},
		{"härliga", "här"},
		{"härligare", "här"},
		{"härlighet", "här"},
		{"härligheten", "här"},
		{"härligheter", "här"},
		{"härligt", "här"},
		{"härma", "härm"},
		{"härmade", "härm"},
		{"härmande", "härm"},
		{"härmar", "härm"},
		{"härmed", "härmed"},
		{"härmedelst", "härmedelst"},
		{"härnäst", "härnäst"},
		{"härom", "härom"},
		{"häromdagen", "häromdag"},
		{"häromkvällen", "häromkväll"},
		{"häromåret", "häromåret"},
		{"härpå", "härpå"},
		{"härrörde", "härrörd"},
		{"härska", "härsk"},
		{"härskade", "härsk"},
		{"härskaren", "härsk"},
		{"härskarinna", "härskarin"},
		{"härskat", "härsk"},
		{"härstamning", "härstamning"},
		{"härstädes", "härstäd"},
		{"härt", "härt"},
		{"härtill", "härtill"},
		{"härunder", "härund"},
		{"häruppe", "härupp"},
		{"härut", "härut"},
		{"häruti", "häruti"},
		{"härutinnan", "härutinnan"},
		{"härutöver", "härutöv"},
		{"härva", "härv"},
		{"härvid", "härvid"},
		{"härå", "härå"},
		{"häröfver", "häröfv"},
		{"häröver", "häröv"},
		{"häst", "häst"},
		{"hästar", "häst"},
		{"hästarna", "häst"},
		{"hästen", "häst"},
		{"hästhalsen", "hästhals"},
		{"hästryggar", "hästrygg"},
		{"hästryggen", "hästrygg"},
		{"hätsk", "hätsk"},
		{"hätska", "hätsk"},
		{"hätskcnet", "hätskcnet"},
		{"hätskhet", "hätsk"},
		{"hätskt", "hätsk"},
		{"hävda", "hävd"},
		{"hävder", "hävd"},
		{"hävdvunnet", "hävdvunnet"},
		{"häxa", "häx"},
		{"häxdansen", "häxdans"},
		{"häxeri", "häxeri"},
		{"hå", "hå"},
		{"håde", "håd"},
		{"håg", "håg"},
		{"hågad", "håg"},
		{"hågen", "håg"},
		{"hågkomst", "hågkomst"},
		{"hågkomster", "hågkomst"},
		{"håkan", "håkan"},
		{"hål", "hål"},
		{"håla", "hål"},
		{"hålen", "hål"},
		{"håligt", "hål"},
		{"håll", "håll"},
		{"hålla", "håll"},
		{"hållande", "håll"},
		{"hållas", "håll"},
		{"hållbart", "hållbart"},
		{"hålle", "håll"},
		{"håller", "håll"},
		{"hålles", "håll"},
		{"hållet", "hållet"},
		{"hållhakar", "hållhak"},
		{"hållit", "hållit"},
		{"hållning", "hållning"},
		{"hållningen", "hållning"},
		{"hålor", "hål"},
		{"hån", "hån"},
		{"hånade", "hån"},
		{"hånande", "hån"},
		{"hånfull", "hånfull"},
		{"hånfulla", "hånfull"},
		{"hånfullt", "hånfull"},
		{"hångrinande", "hångrin"},
		{"hånle", "hånl"},
		{"hånlog", "hånlog"},
		{"håns", "hån"},
		{"hånskratt", "hånskrat"},
		{"hånskrattade", "hånskrat"},
		{"hår", "hår"},
		{"hård", "hård"},
		{"hårda", "hård"},
		{"hårdare", "hård"},
		{"hårdhet", "hård"},
		{"hårdna", "hårdn"},
		{"hårdnackenhet", "hårdnacken"},
		{"hårdt", "hård"},
		{"håret", "håret"},
		{"hårets", "håret"},
		{"hårfläta", "hårflät"},
		{"hårfästet", "hårfästet"},
		{"hårig", "hår"},
		{"håriga", "hår"},
		{"hårskrud", "hårskrud"},
		{"hårslingor", "hårsling"},
		{"hårslingorna", "hårsling"},
		{"hårsmån", "hårsmån"},
		{"hårstrå", "hårstrå"},
		{"hårt", "hårt"},
		{"hårtestar", "hårtest"},
		{"hö", "hö"},
		{"höflig", "höf"},
		{"höfliga", "höf"},
		{"höflighet", "höf"},
		{"höfligheten", "höf"},
		{"höfligt", "höf"},
		{"höftbred", "höftbred"},
		{"höfter", "höft"},
		{"höfterna", "höft"},
		{"höfternas", "höft"},
		{"höftlinjer", "höftlinj"},
		{"höfvan", "höfvan"},
		{"hög", "hög"},
		{"höga", "hög"},
		{"högadlig", "högad"},
		{"högaktade", "högak"},
		{"högaktar", "högak"},
		{"högar", "hög"},
		{"högas", "hög"},
		{"högblå", "högblå"},
		{"högburen", "högbur"},
		{"högdragen", "högdrag"},
		{"högdraget", "högdraget"},
		{"höge", "hög"},
		{"högeligen", "höge"},
		{"högen", "hög"},
		{"höger", "hög"},
		{"högfärd", "högfärd"},
		{"högfärdig", "högfärd"},
		{"högfärdiga", "högfärd"},
		{"högfärdigt", "högfärd"},
		{"högförnäma", "högförnäm"},
		{"högförnäme", "högförnäm"},
		{"högförnämt", "högförnämt"},
		{"högg", "högg"},
		{"höggrevlig", "höggrev"},
		{"högklackade", "högklack"},
		{"högljudda", "högljud"},
		{"högljuddare", "högljud"},
		{"högljudt", "högljud"},
		{"högljutt", "högljut"},
		{"högmo", "högmo"},
		{"högmod", "högmod"},
		{"högmodet", "högmodet"},
		{"högmodets", "högmodet"},
		{"högmodig", "högmod"},
		{"högmodiga", "högmod"},
		{"högmodige", "högmod"},
		{"högmods", "högmod"},
		{"högmodsandan", "högmodsandan"},
		{"högra", "högr"},
		{"högre", "högr"},
		{"högres", "högr"},
		{"högryggade", "högrygg"},
		{"högröda", "högröd"},
		{"högrödaste", "högröd"},
		{"högsint", "högsint"},
		{"högskaf", "högskaf"},
		{"högskolan", "högskolan"},
		{"högskotan", "högskotan"},
		{"högsommaren", "högsomm"},
		{"högst", "högst"},
		{"högsta", "högst"},
		{"högste", "högst"},
		{"högstes", "högst"},
		{"högsträva", "högsträv"},
		{"högsällt", "högsällt"},
		{"högt", "högt"},
		{"högtid", "högtid"},
		{"högtiden", "högtid"},
		{"högtidlig", "högtid"},
		{"högtidliga", "högtid"},
		{"högtidlighet", "högtid"},
		{"högtidligheten", "högtid"},
		{"högtidligt", "högtid"},
		{"högtidsafton", "högtidsafton"},
		{"högtidsdagen", "högtidsdag"},
		{"högtidsdräkten", "högtidsdräk"},
		{"högtidsstunder", "högtidsstund"},
		{"högtidsstämt", "högtidsstämt"},
		{"högtidstimmen", "högtidstimm"},
		{"högvardiga", "högvard"},
		{"högvälborne", "högvälborn"},
		{"högväxt", "högväxt"},
		{"högväxta", "högväxt"},
		{"högönskliga", "högönsk"},
		{"höj", "höj"},
		{"höja", "höj"},
		{"höjande", "höj"},
		{"höjd", "höjd"},
		{"höjda", "höjd"},
		{"höjde", "höjd"},
		{"höjden", "höjd"},
		{"höjder", "höjd"},
		{"höjderna", "höjd"},
		{"höjdes", "höjd"},
		{"höjer", "höj"},
		{"höjt", "höjt"},
		{"hökar", "hök"},
		{"hökarbod", "hökarbod"},
		{"hökarboden", "hökarbod"},
		{"hökaredisk", "hökaredisk"},
		{"hökarekandidaten", "hökarekandidat"},
		{"hökarens", "hök"},
		{"höken", "hök"},
		{"hökens", "hök"},
		{"hökerimedhjälparen", "hökerimedhjälp"},
		{"hölja", "hölj"},
		{"höljande", "hölj"},
		{"hölje", "hölj"},
		{"höll", "höll"},
		{"hölle", "höll"},
		{"höllo", "höllo"},
		{"höllos", "höllo"},
		{"hölls", "höll"},
		{"höna", "hön"},
		{"hönan", "hönan"},
		{"höns", "hön"},
		{"hönsflickan", "hönsflickan"},
		{"hönsgarden", "hönsgard"},
		{"hönsgården", "hönsgård"},
		{"hör", "hör"},
		{"höra", "hör"},
		{"hörande", "hör"},
		{"höras", "hör"},
		{"hörbart", "hörbart"},
		{"hörd", "hörd"},
		{"hörda", "hörd"},
		{"hördc", "hördc"},
		{"hörde", "hörd"},
		{"hördes", "hörd"},
		{"hören", "hör"},
		{"höres", "hör"},
		{"hörhåll", "hörhåll"},
		{"hörlur", "hörlur"},
		{"hörn", "hörn"},
		{"hörnen", "hörn"},
		{"hörnet", "hörnet"},
		{"hörnkammaren", "hörnkamm"},
		{"hörnkammarn", "hörnkammarn"},
		{"hörnrum", "hörnrum"},
		{"hörnrummet", "hörnrummet"},
		{"hörröret", "hörröret"},
		{"hörs", "hör"},
		{"hörsel", "hörsel"},
		{"hört", "hört"},
		{"höst", "höst"},
		{"höstarna", "höst"},
		{"höstbrasan", "höstbrasan"},
		{"hösten", "höst"},
		{"höstens", "höst"},
		{"höstfest", "höstfest"},
		{"hösthorn", "hösthorn"},
		{"hösthornets", "hösthornet"},
		{"höstkväll", "höstkväll"},
		{"höstkvällars", "höstkvällar"},
		{"höstliga", "höst"},
		{"höstligt", "höst"},
		{"höstluften", "höstluft"},
		{"höstlöv", "höstlöv"},
		{"höstmoln", "höstmoln"},
		{"höstmolnen", "höstmoln"},
		{"höstnattens", "höstnat"},
		{"höstpoet", "höstpoet"},
		{"höstpsalm", "höstpsalm"},
		{"höstregn", "höstregn"},
		{"höstregnet", "höstregnet"},
		{"höststormar", "höststorm"},
		{"höststormarne", "höststorm"},
		{"höststormen", "höststorm"},
		{"höstutsädet", "höstutsädet"},
		{"höstvind", "höstvind"},
		{"höstvioler", "höstviol"},
		{"höstvädrens", "höstvädr"},
		{"hötorget", "hötorget"},
		{"hötte", "hött"},
		{"hövdingen", "hövding"},
		{"höver", "höv"},
		{"höves", "höv"},
		{"höviskt", "hövisk"},
		{"hövlig", "höv"},
		{"hövliga", "höv"},
		{"hövligare", "höv"},
		{"hövlighet", "höv"},
		{"hövligt", "höv"},
		{"i", "i"},
		{"ia", "ia"},
		{"iag", "iag"},
		{"iaktta", "iakt"},
		{"iakttaga", "iakttag"},
		{"iakttagande", "iakttag"},
		{"iakttagas", "iakttag"},
		{"iakttagit", "iakttagit"},
		{"iakttog", "iakttog"},
		{"iakttogo", "iakttogo"},
		{"iangt", "iang"},
		{"ibland", "ibland"},
		{"iblandvaggade", "iblandvagg"},
		{"ibsenpjäs", "ibsenpjäs"},
		{"icautschukdocka", "icautschukdock"},
		{"ick", "ick"},
		{"icka", "ick"},
		{"ickan", "ickan"},
		{"ickc", "ickc"},
		{"icke", "ick"},
		{"ickeömt", "ickeömt"},
		{"icn", "icn"},
		{"icna", "icn"},
		{"idag", "idag"},
		{"ide", "ide"},
		{"idealiska", "idealisk"},
		{"idealitet", "idealitet"},
		{"ideella", "ideell"},
		{"ideellt", "ideellt"},
		{"ideen", "ide"},
		{"ideer", "ide"},
		{"idel", "idel"},
		{"ideliga", "ide"},
		{"ideligen", "ide"},
		{"ideligt", "ide"},
		{"iden", "iden"},
		{"identifiera", "identifier"},
		{"idio", "idio"},
		{"idiot", "idiot"},
		{"idioten", "idiot"},
		{"idiotförtrytelse", "idiotförtryt"},
		{"idiotiskt", "idiotisk"},
		{"idiotmoral", "idiotmoral"},
		{"idiots", "idiot"},
		{"idje", "idj"},
		{"idkat", "idk"},
		{"idoghet", "idog"},
		{"idol", "idol"},
		{"idr", "idr"},
		{"idrottens", "idrot"},
		{"idrottsprestation", "idrottsprestation"},
		{"idyllen", "idyll"},
		{"idylliska", "idyllisk"},
		{"idylliskt", "idyllisk"},
		{"ied", "ied"},
		{"ieende", "ieend"},
		{"ieke", "iek"},
		{"if", "if"},
		{"ifall", "ifall"},
		{"ifran", "ifran"},
		{"ifred", "ifred"},
		{"ifrigt", "ifr"},
		{"ifråga", "ifråg"},
		{"ifrågavarande", "ifrågavar"},
		{"ifråm", "ifråm"},
		{"ifrån", "ifrån"},
		{"ifte", "ift"},
		{"ifver", "ifv"},
		{"ifylla", "ifyll"},
		{"iföljd", "iföljd"},
		{"iförd", "iförd"},
		{"ig", "ig"},
		{"igen", "igen"},
		{"igenkastad", "igenkast"},
		{"igenkände", "igenkänd"},
		{"igenkändes", "igenkänd"},
		{"igenkänna", "igenkän"},
		{"igenkännas", "igenkän"},
		{"igenkänt", "igenkänt"},
		{"igenlöst", "igenlös"},
		{"igenom", "igenom"},
		{"igenslogs", "igenslog"},
		{"ignorera", "ignorer"},
		{"igot", "igot"},
		{"igt", "igt"},
		{"igår", "igår"},
		{"ihjäl", "ihjäl"},
		{"ihop", "ihop"},
		{"ihopfästning", "ihopfästning"},
		{"ihopfört", "ihopfört"},
		{"ihopknogade", "ihopknog"},
		{"ihopkrupen", "ihopkrup"},
		{"ihoplappade", "ihoplapp"},
		{"ihopsmida", "ihopsmid"},
		{"ihopvek", "ihopvek"},
		{"ihärdig", "ihärd"},
		{"ihärdiga", "ihärd"},
		{"ihärdige", "ihärd"},
		{"ihärdighet", "ihärd"},
		{"ihåg", "ihåg"},
		{"ihågkom", "ihågkom"},
		{"ihågkommen", "ihågkomm"},
		{"ihågkommes", "ihågkomm"},
		{"ihågkomna", "ihågkomn"},
		{"ihålig", "ihå"},
		{"ihåliga", "ihå"},
		{"ihåligt", "ihå"},
		{"ihållande", "ihåll"},
		{"ii", "ii"},
		{"iian", "iian"},
		{"iianske", "iiansk"},
		{"iii", "iii"},
		{"iion", "iion"},
		{"iit", "iit"},
		{"iittpå", "iittpå"},
		{"iiv", "iiv"},
		{"iiå", "iiå"},
		{"ijml", "ijml"},
		{"ijud", "ijud"},
		{"ijuda", "ijud"},
		{"ijuder", "ijud"},
		{"ijudet", "ijudet"},
		{"ijum", "ijum"},
		{"ijumma", "ijumm"},
		{"ijumt", "ijumt"},
		{"ijungande", "ijung"},
		{"ijus", "ijus"},
		{"ijusa", "ijus"},
		{"ijusare", "ijus"},
		{"ijusblatt", "ijusblat"},
		{"ijusblå", "ijusblå"},
		{"ijusboll", "ijusboll"},
		{"ijusbruna", "ijusbrun"},
		{"ijuset", "ijuset"},
		{"ijusfläckarna", "ijusfläck"},
		{"ijushuvudet", "ijushuvudet"},
		{"ijussken", "ijussk"},
		{"ijusskenet", "ijusskenet"},
		{"ijusstrimma", "ijusstrimm"},
		{"ijust", "ijust"},
		{"ijuv", "ijuv"},
		{"ijuva", "ijuv"},
		{"ijuvlig", "ijuv"},
		{"ijuvligt", "ijuv"},
		{"ijuvt", "ijuvt"},
		{"ijöd", "ijöd"},
		{"ijödo", "ijödo"},
		{"ijög", "ijög"},
		{"iklädde", "ikläd"},
		{"iklädt", "ikläd"},
		{"iklätt", "iklät"},
		{"ikull", "ikull"},
		{"ikämlas", "ikäml"},
		{"il", "il"},
		{"ila", "ila"},
		{"ilade", "ilad"},
		{"ilan", "ilan"},
		{"ilande", "iland"},
		{"ilar", "ilar"},
		{"ilat", "ilat"},
		{"ilbud", "ilbud"},
		{"ildhets", "ildhet"},
		{"ilennes", "ilen"},
		{"ill", "ill"},
		{"illa", "ill"},
		{"illamående", "illamåend"},
		{"illfundiga", "illfund"},
		{"illistiga", "illist"},
		{"illsskolan", "illsskolan"},
		{"illusion", "illusion"},
		{"illusionen", "illusion"},
		{"illusioner", "illusion"},
		{"illusionsfria", "illusionsfri"},
		{"illustrationer", "illustration"},
		{"illustrerad", "illustrer"},
		{"illvilliga", "illvil"},
		{"ilman", "ilman"},
		{"ilning", "ilning"},
		{"ilon", "ilon"},
		{"ilska", "ilsk"},
		{"ilsken", "ilsk"},
		{"ilsket", "ilsket"},
		{"ilskna", "ilskn"},
		{"ilsnabba", "ilsnabb"},
		{"ilyttade", "ilyt"},
		{"imma", "imm"},
		{"imman", "imman"},
		{"immanuel", "immanuel"},
		{"immaterielt", "immaterielt"},
		{"immodernt", "immodernt"},
		{"impertinent", "impertinent"},
		{"imponerade", "imponer"},
		{"imponerat", "imponer"},
		{"imposant", "imposant"},
		{"improvisationskonst", "improvisationskonst"},
		{"improvisera", "improviser"},
		{"improviserade", "improviser"},
		{"impuls", "impul"},
		{"impulser", "impuls"},
		{"impulsiv", "impulsiv"},
		{"impulsivt", "impulsivt"},
		{"in", "in"},
		{"ina", "ina"},
		{"inackorderat", "inackorder"},
		{"inackorderingen", "inackordering"},
		{"inandades", "inand"},
		{"inandandes", "inand"},
		{"inandas", "inand"},
		{"inb", "inb"},
		{"inbalanserande", "inbalanser"},
		{"inbegripen", "inbegrip"},
		{"inbetalningarna", "inbetalning"},
		{"inbetalningen", "inbetalning"},
		{"inbetalta", "inbetalt"},
		{"inbilla", "inbill"},
		{"inbillad", "inbill"},
		{"inbillade", "inbill"},
		{"inbillar", "inbill"},
		{"inbillat", "inbill"},
		{"inbillning", "inbillning"},
		{"inbillningar", "inbillning"},
		{"inbillningen", "inbillning"},
		{"inbillningskraft", "inbillningskraft"},
		{"inbilska", "inbilsk"},
		{"inbilskhetens", "inbilsk"},
		{"inbiten", "inbit"},
		{"inbjuda", "inbjud"},
		{"inbjudan", "inbjudan"},
		{"inbjudande", "inbjud"},
		{"inbjuden", "inbjud"},
		{"inbjudna", "inbjudn"},
		{"inbjudning", "inbjudning"},
		{"inbjudningen", "inbjudning"},
		{"inbjöd", "inbjöd"},
		{"inbjöds", "inbjöd"},
		{"inbragte", "inbrag"},
		{"inbrant", "inbrant"},
		{"inbringa", "inbring"},
		{"inbringat", "inbring"},
		{"inbrott", "inbrot"},
		{"inbrytande", "inbryt"},
		{"inbränt", "inbränt"},
		{"inbunden", "inbund"},
		{"inburen", "inbur"},
		{"inbäddad", "inbäd"},
		{"ind", "ind"},
		{"indad", "ind"},
		{"inde", "ind"},
		{"indelas", "indel"},
		{"indelning", "indelning"},
		{"inder", "ind"},
		{"indien", "indi"},
		{"indiskräckt", "indiskräck"},
		{"individens", "individ"},
		{"individer", "individ"},
		{"indragas", "indrag"},
		{"indragen", "indrag"},
		{"indragna", "indragn"},
		{"indrog", "indrog"},
		{"indrägtigare", "indrägt"},
		{"industriens", "industri"},
		{"inemot", "inemot"},
		{"infall", "infall"},
		{"infalla", "infall"},
		{"infallet", "infallet"},
		{"infallna", "infalln"},
		{"infamt", "infamt"},
		{"infann", "infan"},
		{"infattningen", "infattning"},
		{"infernaliska", "infernalisk"},
		{"infinna", "infin"},
		{"infinner", "infin"},
		{"influensa", "influens"},
		{"influensaväder", "influensaväd"},
		{"inflytande", "inflyt"},
		{"inflytandet", "inflyt"},
		{"inflytelsen", "inflyt"},
		{"inflytelserika", "inflytelserik"},
		{"inflyttande", "inflyt"},
		{"inflyttat", "inflyt"},
		{"informationen", "information"},
		{"informator", "informat"},
		{"informatorn", "informatorn"},
		{"infria", "infri"},
		{"infriade", "infri"},
		{"infrusen", "infrus"},
		{"infunnit", "infunnit"},
		{"infunno", "infunno"},
		{"inföll", "inföll"},
		{"inför", "inför"},
		{"införa", "inför"},
		{"införande", "inför"},
		{"införd", "införd"},
		{"infördes", "införd"},
		{"införer", "inför"},
		{"införseln", "införseln"},
		{"infört", "infört"},
		{"ing", "ing"},
		{"inga", "ing"},
		{"ingaf", "ingaf"},
		{"ingalunda", "ingalund"},
		{"ingav", "ingav"},
		{"ingelgren", "ingelgr"},
		{"ingelgrens", "ingelgr"},
		{"ingelns", "ingeln"},
		{"ingen", "ing"},
		{"ingendera", "ingender"},
		{"ingenskada", "ingenskad"},
		{"ingenstans", "ingenstan"},
		{"ingenstädes", "ingenstäd"},
		{"ingenting", "ingenting"},
		{"inger", "ing"},
		{"inget", "inget"},
		{"ingick", "ingick"},
		{"ingifva", "ingifv"},
		{"ingingo", "ingingo"},
		{"ingiva", "ingiv"},
		{"ingivelse", "ingiv"},
		{"ingivelsen", "ingiv"},
		{"ingivelsenl", "ingivelsenl"},
		{"ingivit", "ingivit"},
		{"ingjuta", "ingjut"},
		{"inglidande", "inglid"},
		{"ingrarna", "ingr"},
		{"ingripande", "ingrip"},
		{"ingt", "ingt"},
		{"ingå", "ingå"},
		{"ingående", "ingåend"},
		{"ingången", "ingång"},
		{"ingångna", "ingångn"},
		{"ingångsspråk", "ingångsspråk"},
		{"ingått", "ingåt"},
		{"inhaladt", "inhalad"},
		{"inhemta", "inhemt"},
		{"inhemtat", "inhemt"},
		{"inhgande", "inhg"},
		{"inhugget", "inhugget"},
		{"inhuggna", "inhuggn"},
		{"inhämta", "inhämt"},
		{"inhämtade", "inhämt"},
		{"inhämtas", "inhämt"},
		{"inhämtat", "inhämt"},
		{"inhöljd", "inhöljd"},
		{"inhöljt", "inhöljt"},
		{"ini", "ini"},
		{"inifran", "inifran"},
		{"inifrån", "inifrån"},
		{"initialer", "initial"},
		{"injaga", "injag"},
		{"inkallas", "inkall"},
		{"inkilad", "inkil"},
		{"inkiladt", "inkilad"},
		{"inkilat", "inkil"},
		{"inklämd", "inklämd"},
		{"inkognito", "inkognito"},
		{"inkom", "inkom"},
		{"inkomma", "inkomm"},
		{"inkommen", "inkomm"},
		{"inkommer", "inkomm"},
		{"inkommit", "inkommit"},
		{"inkomst", "inkomst"},
		{"inkomsten", "inkomst"},
		{"inkomster", "inkomst"},
		{"inkrupen", "inkrup"},
		{"inkråmet", "inkråmet"},
		{"inköpet", "inköpet"},
		{"inkörsporten", "inkörsport"},
		{"inlade", "inl"},
		{"inlagt", "inlag"},
		{"inlandsklimat", "inlandsklim"},
		{"inled", "inled"},
		{"inledde", "inled"},
		{"inleddes", "inled"},
		{"inledning", "inledning"},
		{"inledningen", "inledning"},
		{"inlindat", "inlind"},
		{"inlägga", "inlägg"},
		{"inläggande", "inlägg"},
		{"inläggningar", "inläggning"},
		{"inlämna", "inlämn"},
		{"inlämnas", "inlämn"},
		{"inlärda", "inlärd"},
		{"inlärt", "inlärt"},
		{"inlät", "inlät"},
		{"inlåst", "inlåst"},
		{"inlåste", "inlåst"},
		{"inlåta", "inlåt"},
		{"inmjölade", "inmjöl"},
		{"inmurad", "inmur"},
		{"innan", "innan"},
		{"innandörne", "innandörn"},
		{"innanför", "innanför"},
		{"innanmätet", "innanmätet"},
		{"inne", "inn"},
		{"innebar", "inneb"},
		{"inneboende", "inneboend"},
		{"innebär", "innebär"},
		{"innebära", "innebär"},
		{"innefattade", "innefat"},
		{"innehade", "inneh"},
		{"innehades", "inneh"},
		{"innehåll", "innehåll"},
		{"innehållande", "innehåll"},
		{"innehåller", "innehåll"},
		{"innehållet", "innehållet"},
		{"innehöll", "innehöll"},
		{"inner", "inn"},
		{"innerlig", "inner"},
		{"innerliga", "inner"},
		{"innerligare", "inner"},
		{"innerligen", "inner"},
		{"innerlighet", "inner"},
		{"innerligt", "inner"},
		{"innerst", "innerst"},
		{"innersta", "innerst"},
		{"innesluten", "inneslut"},
		{"innesluter", "inneslut"},
		{"inneslutit", "inneslutit"},
		{"inneslöt", "inneslöt"},
		{"inneslöts", "inneslöt"},
		{"innevånare", "innevån"},
		{"innu", "innu"},
		{"innästlade", "innästl"},
		{"innästlat", "innästl"},
		{"inom", "inom"},
		{"inomhus", "inomhus"},
		{"inonl", "inonl"},
		{"inpackaåe", "inpackaå"},
		{"inpassad", "inpass"},
		{"inpassas", "inpass"},
		{"inpiskad", "inpisk"},
		{"inplanta", "inplant"},
		{"inplantar", "inplant"},
		{"inplantat", "inplant"},
		{"inpräglade", "inprägl"},
		{"inpudrad", "inpudr"},
		{"inpå", "inpå"},
		{"inqvarterat", "inqvarter"},
		{"inramning", "inramning"},
		{"inre", "inr"},
		{"inredd", "inred"},
		{"inredning", "inredning"},
		{"inredt", "inred"},
		{"inres", "inr"},
		{"inrett", "inret"},
		{"inrikes", "inrik"},
		{"inropades", "inrop"},
		{"inrotade", "inrot"},
		{"inrusande", "inrus"},
		{"inrättat", "inrät"},
		{"inrättning", "inrättning"},
		{"inrådan", "inrådan"},
		{"insatt", "insat"},
		{"insatte", "insat"},
		{"inse", "ins"},
		{"inseende", "inseend"},
		{"insegel", "insegel"},
		{"inseglet", "inseglet"},
		{"insekt", "insek"},
		{"insekter", "insek"},
		{"insekterna", "insek"},
		{"inser", "ins"},
		{"insett", "inset"},
		{"insidan", "insidan"},
		{"insikt", "insik"},
		{"insinuerande", "insinuer"},
		{"insjuknat", "insjukn"},
		{"insjunkna", "insjunkn"},
		{"insjö", "insjö"},
		{"insjöar", "insjö"},
		{"insjöarna", "insjö"},
		{"insjös", "insjös"},
		{"inskeppadt", "inskeppad"},
		{"inskjuta", "inskjut"},
		{"inskrifvet", "inskrifvet"},
		{"inskriven", "inskriv"},
		{"inskrivet", "inskrivet"},
		{"inskrivningsboken", "inskrivningsbok"},
		{"inskrivningspengarna", "inskrivningspeng"},
		{"inskränka", "inskränk"},
		{"inskränkningar", "inskränkning"},
		{"inskränkt", "inskränk"},
		{"inskränkte", "inskränk"},
		{"inskyndande", "inskynd"},
		{"insköt", "insköt"},
		{"insläppa", "insläpp"},
		{"insmög", "insmög"},
		{"insmögo", "insmögo"},
		{"insnärjd", "insnärjd"},
		{"insnöade", "insnö"},
		{"insomnad", "insomn"},
		{"insomnade", "insomn"},
		{"insomnat", "insomn"},
		{"inspara", "inspar"},
		{"insparar", "inspar"},
		{"insparas", "inspar"},
		{"inspektion", "inspektion"},
		{"inspektor", "inspek"},
		{"inspektorens", "inspektor"},
		{"inspiration", "inspiration"},
		{"inspirationer", "inspiration"},
		{"insprängande", "inspräng"},
		{"inspärrad", "inspärr"},
		{"installerad", "installer"},
		{"insteg", "insteg"},
		{"instiftelseorden", "instiftelseord"},
		{"instinkt", "instink"},
		{"instinktartad", "instinktart"},
		{"instinktartadt", "instinktartad"},
		{"instinkten", "instink"},
		{"instinkter", "instink"},
		{"instinktiv", "instinktiv"},
		{"instinktivt", "instinktivt"},
		{"instinktmässigt", "instinktmäss"},
		{"instinktsmässigt", "instinktsmäss"},
		{"instrument", "instrument"},
		{"instrumenten", "instrument"},
		{"instrumentens", "instrument"},
		{"instrumentet", "instrumentet"},
		{"instrumentskåp", "instrumentskåp"},
		{"instundande", "instund"},
		{"instuvade", "instuv"},
		{"inställa", "inställ"},
		{"inställda", "inställd"},
		{"inställsam", "inställsam"},
		{"inställsamhet", "inställsam"},
		{"inställsamma", "inställsamm"},
		{"inställsamt", "inställsamt"},
		{"instämde", "instämd"},
		{"instämmande", "instämm"},
		{"instängd", "instäng"},
		{"instängda", "instäng"},
		{"instöpacket", "instöpacket"},
		{"insugit", "insugit"},
		{"insvepa", "insvep"},
		{"insvept", "insvept"},
		{"insvepta", "insvept"},
		{"insändarna", "insänd"},
		{"insändes", "insänd"},
		{"insätta", "insät"},
		{"insätter", "insät"},
		{"insåg", "insåg"},
		{"insåge", "insåg"},
		{"insågo", "insågo"},
		{"insög", "insög"},
		{"insögo", "insögo"},
		{"insöva", "insöv"},
		{"insövd", "insövd"},
		{"int", "int"},
		{"intaga", "intag"},
		{"intagande", "intag"},
		{"intagen", "intag"},
		{"intager", "intag"},
		{"intagit", "intagit"},
		{"intar", "int"},
		{"intc", "intc"},
		{"inte", "int"},
		{"intelligens", "intel"},
		{"intelligent", "intelligent"},
		{"intensivt", "intensivt"},
		{"interiör", "interiör"},
		{"intermezzot", "intermezzot"},
		{"interneringar", "internering"},
		{"intervjuar", "intervju"},
		{"intet", "intet"},
		{"intetdera", "intetder"},
		{"intetgjord", "intetgjord"},
		{"intill", "intill"},
		{"intillträdgårdensstora", "intillträdgårdensstor"},
		{"intima", "intim"},
		{"intimare", "intim"},
		{"intime", "intim"},
		{"intimt", "intimt"},
		{"intog", "intog"},
		{"intogos", "intogo"},
		{"intonerade", "intoner"},
		{"intorkade", "intork"},
		{"intrassla", "intrassl"},
		{"intrasslade", "intrassl"},
		{"intressant", "intressant"},
		{"intressanta", "intressant"},
		{"intressantare", "intressant"},
		{"intressantaste", "intressant"},
		{"intressante", "intressant"},
		{"intresse", "intress"},
		{"intressen", "intress"},
		{"intressentskap", "intressentskap"},
		{"intressera", "intresser"},
		{"intresserad", "intresser"},
		{"intresserade", "intresser"},
		{"intresserar", "intresser"},
		{"intresserat", "intresser"},
		{"intresset", "intresset"},
		{"intrig", "intr"},
		{"intriger", "intr"},
		{"intrigera", "intriger"},
		{"intrigstycken", "intrigstyck"},
		{"introducerad", "introducer"},
		{"intryck", "intryck"},
		{"intrycket", "intrycket"},
		{"intryckt", "intryck"},
		{"inträda", "inträd"},
		{"inträdande", "inträd"},
		{"inträdde", "inträd"},
		{"inträde", "inträd"},
		{"inträdet", "inträdet"},
		{"inträdt", "inträd"},
		{"inträffa", "inträff"},
		{"inträffade", "inträff"},
		{"inträffande", "inträff"},
		{"inträffar", "inträff"},
		{"inträffat", "inträff"},
		{"intränga", "inträng"},
		{"inträngande", "inträng"},
		{"inträngde", "inträng"},
		{"inträtt", "inträt"},
		{"intrång", "intrång"},
		{"inunder", "inund"},
		{"inuti", "inuti"},
		{"invaliden", "invalid"},
		{"invalider", "invalid"},
		{"invandes", "inv"},
		{"invecklad", "inveckl"},
		{"invecklade", "inveckl"},
		{"invektiv", "invektiv"},
		{"inventarium", "inventarium"},
		{"inverka", "inverk"},
		{"inverkade", "inverk"},
		{"inverkan", "inverkan"},
		{"inverkar", "inverk"},
		{"invid", "invid"},
		{"invigd", "inv"},
		{"inviterat", "inviter"},
		{"invända", "invänd"},
		{"invände", "invänd"},
		{"invändning", "invändning"},
		{"invändningar", "invändning"},
		{"invänta", "invänt"},
		{"inväntade", "invänt"},
		{"invärtes", "invärt"},
		{"invånare", "invån"},
		{"invånarne", "invån"},
		{"inälvor", "inälv"},
		{"inåt", "inåt"},
		{"inåtvänd", "inåtvänd"},
		{"inöfva", "inöfv"},
		{"inöva", "inöv"},
		{"inövad", "inöv"},
		{"iog", "iog"},
		{"iordningställa", "iordningställ"},
		{"ir", "ir"},
		{"iramför", "iramför"},
		{"irene", "iren"},
		{"irisk", "irisk"},
		{"irliga", "irl"},
		{"ironi", "ironi"},
		{"ironiskt", "ironisk"},
		{"irr", "irr"},
		{"irra", "irr"},
		{"irrade", "irr"},
		{"irrande", "irr"},
		{"irrar", "irr"},
		{"irrat", "irr"},
		{"irrfärder", "irrfärd"},
		{"irriterar", "irriter"},
		{"irädstam", "irädstam"},
		{"irågade", "iråg"},
		{"iråkade", "iråk"},
		{"irån", "irån"},
		{"is", "is"},
		{"isa", "isa"},
		{"isade", "isad"},
		{"isak", "isak"},
		{"isande", "isand"},
		{"isas", "isas"},
		{"isaskar", "isask"},
		{"isdroppar", "isdropp"},
		{"isen", "isen"},
		{"isfrusna", "isfrusn"},
		{"isig", "isig"},
		{"isiga", "isig"},
		{"isigt", "isig"},
		{"iskade", "isk"},
		{"iskall", "iskall"},
		{"iskallt", "iskallt"},
		{"iskyla", "iskyl"},
		{"islossningen", "islossning"},
		{"ismassa", "ismass"},
		{"ismassorna", "ismass"},
		{"isning", "isning"},
		{"isolerade", "isoler"},
		{"isop", "isop"},
		{"israelitiskt", "israelitisk"},
		{"israels", "israel"},
		{"isstycke", "isstyck"},
		{"isstycken", "isstyck"},
		{"isstyckena", "isstycken"},
		{"ister", "ist"},
		{"isterhakan", "isterhakan"},
		{"isynnerhet", "isynner"},
		{"isär", "isär"},
		{"it", "it"},
		{"italien", "itali"},
		{"italiensk", "italiensk"},
		{"italienska", "italiensk"},
		{"italienskorna", "italiensk"},
		{"itans", "itan"},
		{"itet", "itet"},
		{"ittlade", "ittl"},
		{"itu", "itu"},
		{"itva", "itv"},
		{"iute", "iut"},
		{"iv", "iv"},
		{"iver", "iver"},
		{"ivrade", "ivr"},
		{"ivrig", "ivr"},
		{"ivriga", "ivr"},
		{"ivrigare", "ivr"},
		{"ivrigt", "ivr"},
		{"ix", "ix"},
		{"iyck", "iyck"},
		{"iycka", "iyck"},
		{"iyckades", "iyck"},
		{"iyckan", "iyckan"},
		{"iyckats", "iyckat"},
		{"iycklig", "iyck"},
		{"iyckliga", "iyck"},
		{"iycklige", "iyck"},
		{"iyckligt", "iyck"},
		{"iyckokänsla", "iyckokänsl"},
		{"iycksalige", "iycksa"},
		{"iyckönska", "iyckönsk"},
		{"iydde", "iydd"},
		{"iyddes", "iydd"},
		{"iydig", "iyd"},
		{"iydigt", "iyd"},
		{"iydnad", "iydn"},
		{"iyf", "iyf"},
		{"iyft", "iyft"},
		{"iyfta", "iyft"},
		{"iyftad", "iyft"},
		{"iyftas", "iyft"},
		{"iyftat", "iyft"},
		{"iyfte", "iyft"},
		{"iyfter", "iyft"},
		{"iyftes", "iyft"},
		{"iyfts", "iyft"},
		{"iyk", "iyk"},
		{"iykt", "iykt"},
		{"iykta", "iykt"},
		{"iyktan", "iyktan"},
		{"iyktor", "iykt"},
		{"iyktorna", "iykt"},
		{"iyktskenet", "iyktskenet"},
		{"iynne", "iynn"},
		{"iysa", "iys"},
		{"iysande", "iys"},
		{"iyser", "iys"},
		{"iyss", "iyss"},
		{"iyssna", "iyssn"},
		{"iyssnade", "iyssn"},
		{"iyssnande", "iyssn"},
		{"iyssnat", "iyssn"},
		{"iyst", "iyst"},
		{"iyste", "iyst"},
		{"iysten", "iyst"},
		{"iystes", "iyst"},
		{"iystna", "iystn"},
		{"iystnad", "iystn"},
		{"iytt", "iytt"},
		{"iänge", "iäng"},
		{"iåg", "iåg"},
		{"iörde", "iörd"},
		{"iörjågade", "iörjåg"},
		{"iörlåt", "iörlåt"},
		{"iörst", "iörst"},
		{"iös", "iös"},
		{"j", "j"},
		{"ja", "ja"},
		{"jacka", "jack"},
		{"jackfickorna", "jackfick"},
		{"jacob", "jacob"},
		{"jacobs", "jacob"},
		{"jacoo", "jacoo"},
		{"jade", "jad"},
		{"jae", "jae"},
		{"jaf", "jaf"},
		{"jag", "jag"},
		{"jaga", "jag"},
		{"jagad", "jag"},
		{"jagade", "jag"},
		{"jagande", "jag"},
		{"jagandets", "jagandet"},
		{"jagar", "jag"},
		{"jagas", "jag"},
		{"jagat", "jag"},
		{"jagats", "jagat"},
		{"jaget", "jaget"},
		{"jaha", "jah"},
		{"jakande", "jak"},
		{"jakob", "jakob"},
		{"jakobs", "jakob"},
		{"jakt", "jakt"},
		{"jaktbössa", "jaktböss"},
		{"jakten", "jakt"},
		{"jakthund", "jakthund"},
		{"jaktkarl", "jaktkarl"},
		{"jaktkarlar", "jaktkarl"},
		{"jaktkarlarne", "jaktkarl"},
		{"jaktkarlens", "jaktkarl"},
		{"jaktlöjtnant", "jaktlöjtnant"},
		{"jaktlöjtnanten", "jaktlöjtnant"},
		{"jaktlöjtnantens", "jaktlöjtnant"},
		{"jalusi", "jalusi"},
		{"jalusien", "jalusi"},
		{"jalusier", "jalusi"},
		{"jalusierna", "jalusi"},
		{"jamaika", "jamaik"},
		{"jamat", "jam"},
		{"jamrande", "jamr"},
		{"jamt", "jamt"},
		{"jande", "jand"},
		{"januari", "januari"},
		{"japanska", "japansk"},
		{"jaquette", "jaquet"},
		{"jaquettekappa", "jaquettekapp"},
		{"jargong", "jargong"},
		{"jasmin", "jasmin"},
		{"jasminen", "jasmin"},
		{"jasminer", "jasmin"},
		{"jasminhäck", "jasminhäck"},
		{"jaspis", "jaspis"},
		{"jaså", "jaså"},
		{"javäl", "javäl"},
		{"jazzvindens", "jazzvind"},
		{"jcrn", "jcrn"},
		{"jcsus", "jcsus"},
		{"je", "je"},
		{"jemföra", "jemför"},
		{"jemföras", "jemför"},
		{"jemförelse", "jemför"},
		{"jemförelser", "jemför"},
		{"jemförelsevis", "jemförelsevis"},
		{"jemförligt", "jemför"},
		{"jemkade", "jemk"},
		{"jemmer", "jemm"},
		{"jemmerfulla", "jemmerfull"},
		{"jemmerrop", "jemmerrop"},
		{"jemn", "jemn"},
		{"jemna", "jemn"},
		{"jemnårigt", "jemnår"},
		{"jemrande", "jemr"},
		{"jemt", "jemt"},
		{"jemte", "jemt"},
		{"jemväl", "jemväl"},
		{"jer", "jer"},
		{"jernkakelugnen", "jernkakelugn"},
		{"jernnatur", "jernnatur"},
		{"jernpansrade", "jernpansr"},
		{"jernringar", "jernring"},
		{"jernrustningarne", "jernrustning"},
		{"jesu", "jesu"},
		{"jesuitens", "jesuit"},
		{"jesum", "jesum"},
		{"jesus", "jesus"},
		{"jettegrytorna", "jettegryt"},
		{"jettekrafter", "jettekraft"},
		{"jettelika", "jettelik"},
		{"jl", "jl"},
		{"jo", "jo"},
		{"job", "job"},
		{"jobs", "job"},
		{"jockeymössa", "jockeymöss"},
		{"johamles", "johaml"},
		{"johan", "johan"},
		{"johannelund", "johannelund"},
		{"johannem", "johannem"},
		{"johannes", "johan"},
		{"johannis", "johannis"},
		{"johans", "johan"},
		{"johansmarschen", "johansmarsch"},
		{"john", "john"},
		{"joho", "joho"},
		{"jojo", "jojo"},
		{"jojomänsan", "jojomänsan"},
		{"jollra", "jollr"},
		{"jollradc", "jollradc"},
		{"jollrade", "jollr"},
		{"jollrande", "jollr"},
		{"jon", "jon"},
		{"jonas", "jon"},
		{"jor", "jor"},
		{"jord", "jord"},
		{"jordades", "jord"},
		{"jordbebyggarens", "jordbebygg"},
		{"jordbrunt", "jordbrunt"},
		{"jordbundna", "jordbundn"},
		{"jordelivets", "jordelivet"},
		{"jorden", "jord"},
		{"jordens", "jord"},
		{"jordevandringen", "jordevandring"},
		{"jordfästningen", "jordfästning"},
		{"jordisk", "jordisk"},
		{"jordiska", "jordisk"},
		{"jordiskt", "jordisk"},
		{"jordklotet", "jordklotet"},
		{"jordvåningen", "jordvåning"},
		{"jordytan", "jordytan"},
		{"joscf", "joscf"},
		{"josef", "josef"},
		{"josefina", "josefin"},
		{"josefinas", "josefin"},
		{"josefs", "josef"},
		{"journalist", "journalist"},
		{"jovialisk", "jovialisk"},
		{"jr", "jr"},
		{"ju", "ju"},
		{"jubel", "jubel"},
		{"jublade", "jubl"},
		{"jublande", "jubl"},
		{"jud", "jud"},
		{"judar", "jud"},
		{"jude", "jud"},
		{"judebarnen", "judebarn"},
		{"judefamilj", "judefamilj"},
		{"judeflicka", "judeflick"},
		{"judehistorier", "judehistori"},
		{"juden", "jud"},
		{"judinnan", "judinnan"},
		{"judiska", "judisk"},
		{"judiske", "judisk"},
		{"judiskt", "judisk"},
		{"judy", "judy"},
		{"judys", "judy"},
		{"jukänthenne", "jukänthen"},
		{"jul", "jul"},
		{"jula", "jul"},
		{"julafton", "julafton"},
		{"julaftonen", "julafton"},
		{"jular", "jul"},
		{"julbjudning", "julbjudning"},
		{"juldagen", "juldag"},
		{"julehalm", "julehalm"},
		{"julen", "jul"},
		{"julens", "jul"},
		{"julepsalm", "julepsalm"},
		{"julevind", "julevind"},
		{"julgranen", "julgran"},
		{"julgris", "julgris"},
		{"julhögtiden", "julhögtid"},
		{"juli", "juli"},
		{"julias", "juli"},
		{"julie", "juli"},
		{"julstöket", "julstöket"},
		{"jungarna", "jung"},
		{"jungfru", "jungfru"},
		{"jungfrudom", "jungfrudom"},
		{"jungfrukropp", "jungfrukropp"},
		{"jungfruliga", "jungfru"},
		{"jungfrun", "jungfrun"},
		{"jungfruns", "jungfrun"},
		{"jungfrur", "jungfrur"},
		{"jungfrurna", "jungfrurn"},
		{"jungfruålderns", "jungfruåld"},
		{"jungman", "jungman"},
		{"jungmannen", "jungman"},
		{"juni", "juni"},
		{"juniafton", "juniafton"},
		{"junior", "juni"},
		{"juniors", "junior"},
		{"junkrarna", "junkr"},
		{"junkrarne", "junkr"},
		{"junlös", "junlös"},
		{"juri", "juri"},
		{"juridik", "juridik"},
		{"juridiken", "juridik"},
		{"juridiska", "juridisk"},
		{"juristerna", "jurist"},
		{"jury", "jury"},
		{"just", "just"},
		{"justera", "juster"},
		{"justerat", "juster"},
		{"justitias", "justiti"},
		{"justitierevisionen", "justitierevision"},
		{"justitierådet", "justitierådet"},
		{"jutland", "jutland"},
		{"juvel", "juvel"},
		{"juveler", "juvel"},
		{"juver", "juv"},
		{"jver", "jver"},
		{"jädrar", "jädr"},
		{"jäfva", "jäfv"},
		{"jägare", "jäg"},
		{"jägaren", "jäg"},
		{"jägarn", "jägarn"},
		{"jägtande", "jägt"},
		{"jäktande", "jäkt"},
		{"jämföras", "jämför"},
		{"jämförde", "jämförd"},
		{"jämförelse", "jämför"},
		{"jämförelsen", "jämför"},
		{"jämförliga", "jämför"},
		{"jämkar", "jämk"},
		{"jämlikheten", "jämlik"},
		{"jämmer", "jämm"},
		{"jämmerdal", "jämmerdal"},
		{"jämmerdalen", "jämmerdal"},
		{"jämmerlig", "jämmer"},
		{"jämmern", "jämm"},
		{"jämmerrop", "jämmerrop"},
		{"jämn", "jämn"},
		{"jämna", "jämn"},
		{"jämnan", "jämnan"},
		{"jämnar", "jämn"},
		{"jämngamla", "jämngaml"},
		{"jämngod", "jämngod"},
		{"jämngrå", "jämngrå"},
		{"jämnt", "jämnt"},
		{"jämnårig", "jämnår"},
		{"jämnåriga", "jämnår"},
		{"jämra", "jämr"},
		{"jämrade", "jämr"},
		{"jämrande", "jämr"},
		{"jämrat", "jämr"},
		{"jämt", "jämt"},
		{"jämte", "jämt"},
		{"jämvikten", "jämvik"},
		{"jämväl", "jämväl"},
		{"jäo", "jäo"},
		{"järn", "järn"},
		{"järnhård", "järnhård"},
		{"järnspira", "järnspir"},
		{"järnsäng", "järnsäng"},
		{"järnvägs", "järnväg"},
		{"järnvägsresan", "järnvägsresan"},
		{"järran", "järran"},
		{"jäsa", "jäs"},
		{"jäsande", "jäs"},
		{"jäser", "jäs"},
		{"jäsning", "jäsning"},
		{"jäst", "jäst"},
		{"jästa", "jäst"},
		{"jäste", "jäst"},
		{"jättar", "jätt"},
		{"jättars", "jättar"},
		{"jätte", "jätt"},
		{"jättebarn", "jättebarn"},
		{"jättegrytan", "jättegrytan"},
		{"jättelik", "jättelik"},
		{"jättenavel", "jättenavel"},
		{"jättesolv", "jättesolv"},
		{"jättesteg", "jättesteg"},
		{"jättestor", "jättest"},
		{"jättetass", "jättetass"},
		{"jätteviskning", "jätteviskning"},
		{"k", "k"},
		{"ka", "ka"},
		{"kabelända", "kabeländ"},
		{"kabinett", "kabinet"},
		{"kabinettet", "kabinettet"},
		{"kackerlackor", "kackerlack"},
		{"kade", "kad"},
		{"kadett", "kadet"},
		{"kafe", "kaf"},
		{"kafebord", "kafebord"},
		{"kafeerna", "kafe"},
		{"kafeet", "kafeet"},
		{"kafeets", "kafeet"},
		{"kafehörn", "kafehörn"},
		{"kaferestaurang", "kaferestaurang"},
		{"kafesoffan", "kafesoffan"},
		{"kaffe", "kaff"},
		{"kaffebord", "kaffebord"},
		{"kaffebordet", "kaffebordet"},
		{"kaffebricka", "kaffebrick"},
		{"kaffebrickan", "kaffebrickan"},
		{"kaffegrädde", "kaffegräd"},
		{"kaffekanna", "kaffekan"},
		{"kaffekannan", "kaffekannan"},
		{"kaffekittel", "kaffekittel"},
		{"kaffekokaren", "kaffekok"},
		{"kaffekopp", "kaffekopp"},
		{"kaffekoppen", "kaffekopp"},
		{"kaffekvarn", "kaffekvarn"},
		{"kaffepanna", "kaffepan"},
		{"kaffepannan", "kaffepannan"},
		{"kaffesyster", "kaffesyst"},
		{"kaffet", "kaffet"},
		{"kaffetimme", "kaffetimm"},
		{"kaffetåren", "kaffetår"},
		{"kaftan", "kaftan"},
		{"kaftanlik", "kaftanlik"},
		{"kaggar", "kagg"},
		{"kah", "kah"},
		{"kaiken", "kaik"},
		{"kains", "kain"},
		{"kaja", "kaj"},
		{"kajen", "kaj"},
		{"kajer", "kaj"},
		{"kajerna", "kaj"},
		{"kajsa", "kajs"},
		{"kajsas", "kajs"},
		{"kaka", "kak"},
		{"kakan", "kakan"},
		{"kakel", "kakel"},
		{"kakelugn", "kakelugn"},
		{"kakelugnar", "kakelugn"},
		{"kakelugnen", "kakelugn"},
		{"kakelugnsfrisen", "kakelugnsfris"},
		{"kakelugnskanten", "kakelugnskant"},
		{"kakfat", "kakf"},
		{"kakfatet", "kakfatet"},
		{"kakor", "kak"},
		{"kakpapper", "kakpapp"},
		{"kaksmet", "kaksmet"},
		{"kala", "kal"},
		{"kalasa", "kalas"},
		{"kalaser", "kalas"},
		{"kalaset", "kalaset"},
		{"kalasskjortorna", "kalasskjort"},
		{"kalendern", "kalend"},
		{"kali", "kali"},
		{"kalk", "kalk"},
		{"kalkar", "kalk"},
		{"kalken", "kalk"},
		{"kalkon", "kalkon"},
		{"kalkonen", "kalkon"},
		{"kalkonerna", "kalkon"},
		{"kalkonskivorna", "kalkonskiv"},
		{"kall", "kall"},
		{"kalla", "kall"},
		{"kallad", "kall"},
		{"kallade", "kall"},
		{"kallades", "kall"},
		{"kalladt", "kallad"},
		{"kallande", "kall"},
		{"kallar", "kall"},
		{"kallas", "kall"},
		{"kallaste", "kall"},
		{"kallat", "kall"},
		{"kallats", "kallat"},
		{"kallbad", "kallb"},
		{"kallblodighet", "kallblod"},
		{"kalle", "kall"},
		{"kallelse", "kall"},
		{"kallnade", "kalln"},
		{"kallnar", "kalln"},
		{"kallnat", "kalln"},
		{"kallsinnighet", "kallsinn"},
		{"kallsvettades", "kallsvet"},
		{"kallt", "kallt"},
		{"kalnrern", "kalnr"},
		{"kalops", "kalop"},
		{"kalt", "kalt"},
		{"kalufs", "kaluf"},
		{"kalufsen", "kalufs"},
		{"kalva", "kalv"},
		{"kalvstekssås", "kalvstekssås"},
		{"kam", "kam"},
		{"kameral", "kameral"},
		{"kamfer", "kamf"},
		{"kamma", "kamm"},
		{"kammad", "kamm"},
		{"kammakaregatan", "kammakaregatan"},
		{"kammar", "kamm"},
		{"kammardörr", "kammardörr"},
		{"kammare", "kamm"},
		{"kammaren", "kamm"},
		{"kammarfönster", "kammarfönst"},
		{"kammargolfvet", "kammargolfvet"},
		{"kammarhandel", "kammarhandel"},
		{"kammarherre", "kammarherr"},
		{"kammarherrinna", "kammarherrin"},
		{"kammarjunkar", "kammarjunk"},
		{"kammarjunkare", "kammarjunk"},
		{"kammarjunkarefullmakt", "kammarjunkarefullmak"},
		{"kammarlifvet", "kammarlifvet"},
		{"kammarn", "kammarn"},
		{"kammarorgel", "kammarorgel"},
		{"kammarspisning", "kammarspisning"},
		{"kammartjenare", "kammartjen"},
		{"kammen", "kamm"},
		{"kammerrerinna", "kammerrerin"},
		{"kamp", "kamp"},
		{"kampar", "kamp"},
		{"kampen", "kamp"},
		{"kamrar", "kamr"},
		{"kamrars", "kamrar"},
		{"kamrat", "kamr"},
		{"kamraten", "kamrat"},
		{"kamrater", "kamrat"},
		{"kamraterna", "kamrat"},
		{"kamraternas", "kamrat"},
		{"kamrem", "kamrem"},
		{"kamrer", "kamr"},
		{"kamrern", "kamr"},
		{"kamrerns", "kamr"},
		{"kamrers", "kamrer"},
		{"kamrerskan", "kamrerskan"},
		{"kan", "kan"},
		{"kana", "kan"},
		{"kanalen", "kanal"},
		{"kanalje", "kanalj"},
		{"kanaljeri", "kanaljeri"},
		{"kanaljerna", "kanalj"},
		{"kande", "kand"},
		{"kandelabrarna", "kandelabr"},
		{"kanderad", "kander"},
		{"kandidaten", "kandidat"},
		{"kanel", "kanel"},
		{"kanhä", "kanhä"},
		{"kanhända", "kanhänd"},
		{"kanistern", "kanist"},
		{"kanna", "kann"},
		{"kannan", "kannan"},
		{"kannans", "kannan"},
		{"kannas", "kann"},
		{"kannstöparsarkasm", "kannstöparsarkasm"},
		{"kanonskott", "kanonskot"},
		{"kanoter", "kanot"},
		{"kanotiärerna", "kanotiär"},
		{"kanskc", "kanskc"},
		{"kanske", "kansk"},
		{"kansla", "kansl"},
		{"kanslirådet", "kanslirådet"},
		{"kanslisekreterare", "kanslisekreter"},
		{"kanslor", "kansl"},
		{"kant", "kant"},
		{"kantad", "kant"},
		{"kantade", "kant"},
		{"kanten", "kant"},
		{"kanter", "kant"},
		{"kanterna", "kant"},
		{"kantig", "kant"},
		{"kantor", "kant"},
		{"kantorn", "kantorn"},
		{"kantorns", "kantorn"},
		{"kantra", "kantr"},
		{"kantrade", "kantr"},
		{"kantring", "kantring"},
		{"kaos", "kaos"},
		{"kapa", "kap"},
		{"kapabel", "kapabel"},
		{"kapell", "kapell"},
		{"kapellens", "kapell"},
		{"kapital", "kapital"},
		{"kapitel", "kapitel"},
		{"kapitlet", "kapitlet"},
		{"kapp", "kapp"},
		{"kappa", "kapp"},
		{"kappan", "kappan"},
		{"kappas", "kapp"},
		{"kappe", "kapp"},
		{"kapplöpning", "kapplöpning"},
		{"kappor", "kapp"},
		{"kapporna", "kapp"},
		{"kapprock", "kapprock"},
		{"kappsäck", "kappsäck"},
		{"kappsäckarna", "kappsäck"},
		{"kappsäcken", "kappsäck"},
		{"kappärm", "kappärm"},
		{"kapriser", "kapris"},
		{"kapslar", "kapsl"},
		{"kapslarna", "kapsl"},
		{"kapten", "kapt"},
		{"kaptenen", "kapten"},
		{"kaptenens", "kapten"},
		{"kaptens", "kapt"},
		{"kaptensvärdighet", "kaptensvärd"},
		{"kapun", "kapun"},
		{"kapunen", "kapun"},
		{"kar", "kar"},
		{"karakter", "karak"},
		{"karakteriserar", "karakteriser"},
		{"karakteristiken", "karakteristik"},
		{"karakteristisk", "karakteristisk"},
		{"karakteristiskt", "karakteristisk"},
		{"karaktär", "karaktär"},
		{"karaktärens", "karaktär"},
		{"karaktärer", "karaktär"},
		{"karaktärslöst", "karaktärslös"},
		{"karamell", "karamell"},
		{"karameller", "karamell"},
		{"karamellkoket", "karamellkoket"},
		{"karbol", "karbol"},
		{"kardborrar", "kardborr"},
		{"karet", "karet"},
		{"karikatyrer", "karikatyr"},
		{"karin", "karin"},
		{"karl", "karl"},
		{"karlar", "karl"},
		{"karlarna", "karl"},
		{"karlarne", "karl"},
		{"karlberg", "karlberg"},
		{"karlbergs", "karlberg"},
		{"karlbergsallen", "karlbergsall"},
		{"karlek", "karlek"},
		{"karlekarl", "karlekarl"},
		{"karlen", "karl"},
		{"karlmark", "karlmark"},
		{"karlmarken", "karlmark"},
		{"karlmarkens", "karlmark"},
		{"karlmarks", "karlmark"},
		{"karlmarkskan", "karlmarkskan"},
		{"karls", "karl"},
		{"karlske", "karlsk"},
		{"karlskepnad", "karlskepn"},
		{"karmrater", "karmrat"},
		{"karmrern", "karmr"},
		{"karmstol", "karmstol"},
		{"karna", "karn"},
		{"karo", "karo"},
		{"karolin", "karolin"},
		{"karolina", "karolin"},
		{"kaross", "kaross"},
		{"karott", "karot"},
		{"karriär", "karriär"},
		{"karriärsynpunkt", "karriärsynpunk"},
		{"karta", "kart"},
		{"kartan", "kartan"},
		{"kartonger", "kartong"},
		{"karusell", "karusell"},
		{"karusellen", "karusell"},
		{"karva", "karv"},
		{"karvat", "karv"},
		{"kas", "kas"},
		{"kaskader", "kaskad"},
		{"kassa", "kass"},
		{"kassaboken", "kassabok"},
		{"kassabokens", "kassabok"},
		{"kassaböcker", "kassaböck"},
		{"kassadirektör", "kassadirektör"},
		{"kassakista", "kassakist"},
		{"kassan", "kassan"},
		{"kasta", "kast"},
		{"kastad", "kast"},
		{"kastadc", "kastadc"},
		{"kastade", "kast"},
		{"kastades", "kast"},
		{"kastande", "kast"},
		{"kastanje", "kastanj"},
		{"kastanjebruna", "kastanjebrun"},
		{"kastanjen", "kastanj"},
		{"kastanjer", "kastanj"},
		{"kastanjernas", "kastanj"},
		{"kastanjeträd", "kastanjeträd"},
		{"kastanjeträden", "kastanjeträd"},
		{"kastar", "kast"},
		{"kastas", "kast"},
		{"kastat", "kast"},
		{"kastats", "kastat"},
		{"kastellan", "kastellan"},
		{"kasus", "kasus"},
		{"katarina", "katarin"},
		{"katastrof", "katastrof"},
		{"katedcrn", "katedcrn"},
		{"kateder", "kated"},
		{"katedern", "kated"},
		{"katedrals", "katedral"},
		{"katekesen", "katekes"},
		{"katolik", "katolik"},
		{"katolsk", "katolsk"},
		{"katolska", "katolsk"},
		{"katrina", "katrin"},
		{"katrinadagen", "katrinadag"},
		{"katrinas", "katrin"},
		{"katsor", "kats"},
		{"katt", "katt"},
		{"katta", "katt"},
		{"kattdjur", "kattdjur"},
		{"katten", "katt"},
		{"kattens", "katt"},
		{"kattlik", "kattlik"},
		{"kattmusik", "kattmusik"},
		{"kattor", "katt"},
		{"katts", "katt"},
		{"kattuner", "kattun"},
		{"kattuns", "kattun"},
		{"kattunsgardiner", "kattunsgardin"},
		{"kattunsklädningen", "kattunsklädning"},
		{"kattunstycken", "kattunstyck"},
		{"kavaj", "kavaj"},
		{"kavajfickorna", "kavajfick"},
		{"kavajkostym", "kavajkostym"},
		{"kavaljer", "kavalj"},
		{"kavaljererna", "kavaljer"},
		{"kavaljern", "kavalj"},
		{"kavaljersmaner", "kavaljersman"},
		{"kavata", "kavat"},
		{"kavet", "kavet"},
		{"kaxig", "kax"},
		{"kedja", "kedj"},
		{"kedjan", "kedjan"},
		{"kedjor", "kedj"},
		{"kejsare", "kejs"},
		{"kejsarinna", "kejsarin"},
		{"kela", "kel"},
		{"kellnern", "kelln"},
		{"kelser", "kels"},
		{"kelt", "kelt"},
		{"ken", "ken"},
		{"kered", "kered"},
		{"kerstin", "kerstin"},
		{"kerstins", "kerstin"},
		{"kerub", "kerub"},
		{"kestner", "kestn"},
		{"kestners", "kestner"},
		{"khngade", "khngad"},
		{"kiang", "kiang"},
		{"kickade", "kick"},
		{"kiga", "kig"},
		{"kihlberg", "kihlberg"},
		{"kikade", "kik"},
		{"kikaren", "kik"},
		{"kiksögon", "kiksögon"},
		{"kilade", "kil"},
		{"killingsfäll", "killingsfäll"},
		{"kin", "kin"},
		{"kind", "kind"},
		{"kindben", "kindb"},
		{"kindbenet", "kindbenet"},
		{"kinden", "kind"},
		{"kindens", "kind"},
		{"kinder", "kind"},
		{"kinderna", "kind"},
		{"kindknotor", "kindknot"},
		{"kinesisk", "kinesisk"},
		{"kinesiska", "kinesisk"},
		{"kinkig", "kink"},
		{"kinkiga", "kink"},
		{"kinkigare", "kink"},
		{"kinkigt", "kink"},
		{"kippa", "kipp"},
		{"kippskor", "kippsk"},
		{"kirurgen", "kirurg"},
		{"kirurger", "kirurg"},
		{"kisade", "kis"},
		{"kisande", "kis"},
		{"kiselstenar", "kiselsten"},
		{"kista", "kist"},
		{"kistan", "kistan"},
		{"kistlock", "kistlock"},
		{"kistor", "kist"},
		{"kitslighet", "kits"},
		{"kitta", "kitt"},
		{"kittel", "kittel"},
		{"kittla", "kittl"},
		{"kittlade", "kittl"},
		{"kittlande", "kittl"},
		{"kiv", "kiv"},
		{"kjol", "kjol"},
		{"kjolar", "kjol"},
		{"kjolarna", "kjol"},
		{"kjolen", "kjol"},
		{"kjolkanten", "kjolkant"},
		{"kjolsäck", "kjolsäck"},
		{"kjortel", "kjortel"},
		{"kjortelfållar", "kjortelfåll"},
		{"kjortelsäck", "kjortelsäck"},
		{"kjortelsäcken", "kjortelsäck"},
		{"kjortlarna", "kjortl"},
		{"kla", "kla"},
		{"klack", "klack"},
		{"klackar", "klack"},
		{"klackarna", "klack"},
		{"klader", "klad"},
		{"klaffbord", "klaffbord"},
		{"klaffen", "klaff"},
		{"klaga", "klag"},
		{"klagade", "klag"},
		{"klagan", "klagan"},
		{"klagande", "klag"},
		{"klagar", "klag"},
		{"klagat", "klag"},
		{"klagomål", "klagomål"},
		{"klampade", "klamp"},
		{"klander", "kland"},
		{"klandra", "klandr"},
		{"klandrade", "klandr"},
		{"klandrar", "klandr"},
		{"klang", "klang"},
		{"klangen", "klang"},
		{"klangfull", "klangfull"},
		{"klangfärg", "klangfärg"},
		{"klanningsficka", "klanningsfick"},
		{"klapp", "klapp"},
		{"klappa", "klapp"},
		{"klappade", "klapp"},
		{"klappande", "klapp"},
		{"klappar", "klapp"},
		{"klappat", "klapp"},
		{"klappning", "klappning"},
		{"klapprade", "klappr"},
		{"klapprande", "klappr"},
		{"klapprandet", "klappr"},
		{"klar", "klar"},
		{"klara", "klar"},
		{"klarar", "klar"},
		{"klarare", "klar"},
		{"klaraste", "klar"},
		{"klarbla", "klarbl"},
		{"klarbär", "klarbär"},
		{"klarhet", "klar"},
		{"klarna", "klarn"},
		{"klarnade", "klarn"},
		{"klarnar", "klarn"},
		{"klart", "klart"},
		{"klarögd", "klarög"},
		{"klarögda", "klarög"},
		{"klas", "klas"},
		{"klasar", "klas"},
		{"klass", "klass"},
		{"klassbildning", "klassbildning"},
		{"klassen", "klass"},
		{"klassens", "klass"},
		{"klasser", "klass"},
		{"klasserna", "klass"},
		{"klassföreståndarinnan", "klassföreståndarinnan"},
		{"klassifikationssystem", "klassifikationssystem"},
		{"klasskamrat", "klasskamr"},
		{"klasskamraten", "klasskamrat"},
		{"klasskamrater", "klasskamrat"},
		{"klassrum", "klassrum"},
		{"klassrummen", "klassrumm"},
		{"klassrummet", "klassrummet"},
		{"klatsch", "klatsch"},
		{"klaver", "klav"},
		{"klaveret", "klaveret"},
		{"kled", "kled"},
		{"klef", "klef"},
		{"klemade", "klem"},
		{"klemande", "klem"},
		{"klemandet", "klem"},
		{"klen", "klen"},
		{"klena", "klen"},
		{"klenod", "klenod"},
		{"klenoder", "klenod"},
		{"klenoders", "klenoder"},
		{"klent", "klent"},
		{"klentrogne", "klentrogn"},
		{"kleptoman", "kleptoman"},
		{"klev", "klev"},
		{"kli", "kli"},
		{"kliar", "kliar"},
		{"kliat", "kliat"},
		{"klibbade", "klibb"},
		{"klibbar", "klibb"},
		{"klibbat", "klibb"},
		{"klimat", "klim"},
		{"klinga", "kling"},
		{"klingade", "kling"},
		{"klingallde", "klingalld"},
		{"klingand", "klingand"},
		{"klingande", "kling"},
		{"klingar", "kling"},
		{"klinkan", "klinkan"},
		{"klintar", "klint"},
		{"klippa", "klipp"},
		{"klippan", "klippan"},
		{"klipper", "klipp"},
		{"klipphålorna", "klipphål"},
		{"klippiga", "klipp"},
		{"klippmassor", "klippmass"},
		{"klippor", "klipp"},
		{"klipporna", "klipp"},
		{"klippt", "klippt"},
		{"klippte", "klippt"},
		{"klipptopparne", "klipptopp"},
		{"klipska", "klipsk"},
		{"klirrade", "klirr"},
		{"klirrande", "klirr"},
		{"kliv", "kliv"},
		{"kliva", "kliv"},
		{"klo", "klo"},
		{"kloaken", "kloak"},
		{"klock", "klock"},
		{"klocka", "klock"},
		{"klockan", "klockan"},
		{"klockans", "klockan"},
		{"klockare", "klock"},
		{"klockaren", "klock"},
		{"klockarens", "klock"},
		{"klockarfar", "klockarf"},
		{"klockarn", "klockarn"},
		{"klockarsonen", "klockarson"},
		{"klockas", "klock"},
		{"klockkedjan", "klockkedjan"},
		{"klocklikt", "klocklik"},
		{"klockor", "klock"},
		{"klockorna", "klock"},
		{"klockornas", "klock"},
		{"klockors", "klockor"},
		{"klockringning", "klockringning"},
		{"kloekornas", "kloek"},
		{"klok", "klok"},
		{"kloka", "klok"},
		{"klokare", "klok"},
		{"klokast", "klok"},
		{"klokaste", "klok"},
		{"kloke", "klok"},
		{"klokhet", "klok"},
		{"klokheten", "klok"},
		{"klokt", "klokt"},
		{"kloliknande", "klolikn"},
		{"klor", "klor"},
		{"klorna", "klorn"},
		{"kloroform", "kloroform"},
		{"kloster", "klost"},
		{"klostergården", "klostergård"},
		{"klosterlik", "klosterlik"},
		{"klot", "klot"},
		{"klotb", "klotb"},
		{"klotrund", "klotrund"},
		{"klotrunda", "klotrund"},
		{"klotrunt", "klotrunt"},
		{"klskade", "klskad"},
		{"klubba", "klubb"},
		{"klubban", "klubban"},
		{"klubben", "klubb"},
		{"kludderi", "kludderi"},
		{"klump", "klump"},
		{"klumpen", "klump"},
		{"klumpig", "klump"},
		{"klungan", "klungan"},
		{"klunk", "klunk"},
		{"klunkar", "klunk"},
		{"klyftigheterna", "klyft"},
		{"klyftor", "klyft"},
		{"klyfver", "klyfv"},
		{"klynka", "klynk"},
		{"klynkade", "klynk"},
		{"klyva", "klyv"},
		{"klyvas", "klyv"},
		{"klä", "klä"},
		{"kläd", "kläd"},
		{"kläda", "kläd"},
		{"klädas", "kläd"},
		{"klädd", "klädd"},
		{"klädda", "klädd"},
		{"klädde", "klädd"},
		{"kläde", "kläd"},
		{"klädedrägt", "klädedräg"},
		{"kläden", "kläd"},
		{"kläder", "kläd"},
		{"kläderna", "kläd"},
		{"klädernas", "kläd"},
		{"klädespersedel", "klädespersedel"},
		{"klädespersedeln", "klädespersedeln"},
		{"klädespersedlarne", "klädespersedl"},
		{"klädkorg", "klädkorg"},
		{"klädmäklaredotter", "klädmäklaredot"},
		{"klädnad", "klädn"},
		{"klädning", "klädning"},
		{"klädningar", "klädning"},
		{"klädningarna", "klädning"},
		{"klädningarnas", "klädning"},
		{"klädningarne", "klädning"},
		{"klädningen", "klädning"},
		{"klädningsliv", "klädningsliv"},
		{"klädsam", "klädsam"},
		{"klädsel", "klädsel"},
		{"klädseln", "klädseln"},
		{"klädstand", "klädstand"},
		{"klädstånd", "klädstånd"},
		{"klädståndet", "klädståndet"},
		{"klädståndsfru", "klädståndsfru"},
		{"klädståndsfruar", "klädståndsfru"},
		{"klädståndsfrun", "klädståndsfrun"},
		{"klädståndsfruns", "klädståndsfrun"},
		{"klädståndsluften", "klädståndsluft"},
		{"klämde", "klämd"},
		{"klämma", "klämm"},
		{"klämman", "klämman"},
		{"klämt", "klämt"},
		{"klämtade", "klämt"},
		{"klämtande", "klämt"},
		{"klämtat", "klämt"},
		{"klämtslag", "klämtslag"},
		{"klämtslaget", "klämtslaget"},
		{"klän", "klän"},
		{"klänga", "kläng"},
		{"klängde", "kläng"},
		{"klänning", "klänning"},
		{"klänningar", "klänning"},
		{"klänningen", "klänning"},
		{"klänningsficka", "klänningsfick"},
		{"klänningskjol", "klänningskjol"},
		{"klänningslivet", "klänningslivet"},
		{"klänningstyget", "klänningstyget"},
		{"kläp", "kläp"},
		{"kläppen", "kläpp"},
		{"klär", "klär"},
		{"klätt", "klätt"},
		{"klättra", "klättr"},
		{"klättrade", "klättr"},
		{"klättrande", "klättr"},
		{"klättrar", "klättr"},
		{"klättrarnas", "klättr"},
		{"klåda", "klåd"},
		{"klådde", "klådd"},
		{"klåfingrigt", "klåfingr"},
		{"klömde", "klömd"},
		{"klöv", "klöv"},
		{"klöver", "klöv"},
		{"klöverblommor", "klöverblomm"},
		{"klövern", "klöv"},
		{"km", "km"},
		{"kna", "kna"},
		{"knaben", "knab"},
		{"knacka", "knack"},
		{"knackade", "knack"},
		{"knackandet", "knack"},
		{"knackar", "knack"},
		{"knackat", "knack"},
		{"knackning", "knackning"},
		{"knackningen", "knackning"},
		{"knaka", "knak"},
		{"knakade", "knak"},
		{"knakande", "knak"},
		{"knall", "knall"},
		{"knallar", "knall"},
		{"knap", "knap"},
		{"knapp", "knapp"},
		{"knappa", "knapp"},
		{"knappar", "knapp"},
		{"knapparna", "knapp"},
		{"knapparne", "knapp"},
		{"knappast", "knapp"},
		{"knapphandlare", "knapphandl"},
		{"knapphandlaren", "knapphandl"},
		{"knapphål", "knapphål"},
		{"knapphålet", "knapphålet"},
		{"knappnål", "knappnål"},
		{"knappt", "knappt"},
		{"knappte", "knappt"},
		{"knaprade", "knapr"},
		{"knapt", "knapt"},
		{"knarra", "knarr"},
		{"knarrade", "knarr"},
		{"knarrande", "knarr"},
		{"knarrar", "knarr"},
		{"knarrigt", "knarr"},
		{"knarrningar", "knarrning"},
		{"knarrningen", "knarrning"},
		{"knaster", "knast"},
		{"knastrade", "knastr"},
		{"knastrande", "knastr"},
		{"knekt", "knekt"},
		{"knektar", "knekt"},
		{"knep", "knep"},
		{"knepe", "knep"},
		{"knip", "knip"},
		{"knipa", "knip"},
		{"knipan", "knipan"},
		{"knipande", "knip"},
		{"kniper", "knip"},
		{"knippa", "knipp"},
		{"knippe", "knipp"},
		{"kniv", "kniv"},
		{"knivar", "kniv"},
		{"knivblad", "knivbl"},
		{"kniven", "kniv"},
		{"kno", "kno"},
		{"knogar", "knog"},
		{"knogat", "knog"},
		{"knopp", "knopp"},
		{"knoppande", "knopp"},
		{"knoppar", "knopp"},
		{"knopparna", "knopp"},
		{"knoppas", "knopp"},
		{"knoppen", "knopp"},
		{"knot", "knot"},
		{"knota", "knot"},
		{"knotade", "knot"},
		{"knotig", "knot"},
		{"knotiga", "knot"},
		{"knotighet", "knot"},
		{"knubbig", "knubb"},
		{"knubbiga", "knubb"},
		{"knuff", "knuff"},
		{"knuffa", "knuff"},
		{"knuffade", "knuff"},
		{"knuffar", "knuff"},
		{"knut", "knut"},
		{"knutar", "knut"},
		{"knutarne", "knut"},
		{"knuten", "knut"},
		{"knutet", "knutet"},
		{"knutit", "knutit"},
		{"knutna", "knutn"},
		{"knyckar", "knyck"},
		{"knyppeldynor", "knyppeldyn"},
		{"knyst", "knyst"},
		{"knysta", "knyst"},
		{"knyta", "knyt"},
		{"knytande", "knyt"},
		{"knyte", "knyt"},
		{"knyten", "knyt"},
		{"knyter", "knyt"},
		{"knä", "knä"},
		{"knäbyxor", "knäbyx"},
		{"knäböjande", "knäböj"},
		{"knäböjde", "knäböjd"},
		{"knäcka", "knäck"},
		{"knäckebröd", "knäckebröd"},
		{"knäckt", "knäck"},
		{"knäckta", "knäck"},
		{"knäckte", "knäck"},
		{"knäet", "knäet"},
		{"knäfveln", "knäfveln"},
		{"knän", "knän"},
		{"knäna", "knän"},
		{"knäppa", "knäpp"},
		{"knäppande", "knäpp"},
		{"knäppen", "knäpp"},
		{"knäppning", "knäppning"},
		{"knäppt", "knäppt"},
		{"knäppta", "knäppt"},
		{"knäppte", "knäppt"},
		{"knäskålar", "knäskål"},
		{"knät", "knät"},
		{"knäveln", "knäveln"},
		{"knöt", "knöt"},
		{"knötos", "knöto"},
		{"ko", "ko"},
		{"kocken", "kock"},
		{"koffert", "koffert"},
		{"koin", "koin"},
		{"koja", "koj"},
		{"kojen", "koj"},
		{"koka", "kok"},
		{"kokade", "kok"},
		{"kokar", "kok"},
		{"kokat", "kok"},
		{"kokerier", "kokeri"},
		{"kokerskan", "kokerskan"},
		{"kokerskor", "kokersk"},
		{"kokett", "koket"},
		{"koketta", "koket"},
		{"kokettera", "koketter"},
		{"koketterar", "koketter"},
		{"koketteri", "koketteri"},
		{"kokhett", "kokhet"},
		{"kokkonst", "kokkonst"},
		{"kokt", "kokt"},
		{"kokta", "kokt"},
		{"kol", "kol"},
		{"koleran", "koleran"},
		{"kolglöden", "kolglöd"},
		{"koliskt", "kolisk"},
		{"kollega", "kolleg"},
		{"kollegan", "kollegan"},
		{"kolleger", "kolleg"},
		{"kollin", "kollin"},
		{"kollrig", "kollr"},
		{"kolonnerna", "kolon"},
		{"kolossal", "kolossal"},
		{"kolossala", "kolossal"},
		{"kolossale", "kolossal"},
		{"kolossalt", "kolossalt"},
		{"kolpor", "kolp"},
		{"kolportera", "kolporter"},
		{"kolportoren", "kolportor"},
		{"kolportör", "kolportör"},
		{"kolportören", "kolportör"},
		{"kolportörens", "kolportör"},
		{"kolportörer", "kolportör"},
		{"kolsvart", "kolsvart"},
		{"kolsvarta", "kolsvart"},
		{"kolsyran", "kolsyran"},
		{"kolt", "kolt"},
		{"kolv", "kolv"},
		{"kom", "kom"},
		{"komediantfolk", "komediantfolk"},
		{"komedien", "komedi"},
		{"komedier", "komedi"},
		{"komfortabelt", "komfortabelt"},
		{"komisk", "komisk"},
		{"komiskt", "komisk"},
		{"komm", "komm"},
		{"komma", "komm"},
		{"kommande", "komm"},
		{"kommandeval", "kommandeval"},
		{"kommandostafven", "kommandostafv"},
		{"kommandoton", "kommandoton"},
		{"komme", "komm"},
		{"kommen", "komm"},
		{"kommendera", "kommender"},
		{"kommenderad", "kommender"},
		{"kommenderade", "kommender"},
		{"kommenderande", "kommender"},
		{"kommenterade", "kommenter"},
		{"kommer", "komm"},
		{"kommet", "kommet"},
		{"komminister", "komminist"},
		{"komministern", "komminist"},
		{"komministersfru", "komministersfru"},
		{"komministersänkan", "komministersänkan"},
		{"komministeränkan", "komministeränkan"},
		{"komministraturen", "komministratur"},
		{"kommissionen", "kommission"},
		{"kommit", "kommit"},
		{"kommiuisterns", "kommiuist"},
		{"kommo", "kommo"},
		{"kommod", "kommod"},
		{"kommoden", "kommod"},
		{"kommunionen", "kommunion"},
		{"komna", "komn"},
		{"kompan", "kompan"},
		{"kompaner", "kompan"},
		{"kompani", "kompani"},
		{"kompanjon", "kompanjon"},
		{"kompanjonerna", "kompanjon"},
		{"kompanjons", "kompanjon"},
		{"kompanjonskap", "kompanjonskap"},
		{"kompass", "kompass"},
		{"kompetent", "kompetent"},
		{"komplimang", "komplimang"},
		{"komponerar", "komponer"},
		{"kompositören", "kompositör"},
		{"komrnit", "komrnit"},
		{"kon", "kon"},
		{"koncentrerar", "koncentrer"},
		{"koncepterna", "koncept"},
		{"konceptet", "konceptet"},
		{"kondition", "kondition"},
		{"konditori", "konditori"},
		{"konditorier", "konditori"},
		{"konditoriet", "konditoriet"},
		{"konfekt", "konfek"},
		{"konfirmand", "konfirmand"},
		{"konfirmationsprästen", "konfirmationspräst"},
		{"konfirmationssvärmeri", "konfirmationssvärmeri"},
		{"konfirmerad", "konfirmer"},
		{"konfirmerades", "konfirmer"},
		{"konfysa", "konfys"},
		{"kongl", "kongl"},
		{"koniska", "konisk"},
		{"konjak", "konjak"},
		{"konjaken", "konjak"},
		{"konjaksbuteljen", "konjaksbutelj"},
		{"konjaksglas", "konjaksgl"},
		{"konkurrens", "konkurr"},
		{"konkurrensen", "konkurrens"},
		{"konkurs", "konkur"},
		{"konradsberg", "konradsberg"},
		{"konseljen", "konselj"},
		{"konsert", "konsert"},
		{"konserter", "konsert"},
		{"konservativa", "konservativ"},
		{"konserver", "konserv"},
		{"konservera", "konserver"},
		{"konserverad", "konserver"},
		{"konspirerande", "konspirer"},
		{"konst", "konst"},
		{"konstanta", "konstant"},
		{"konstapeln", "konstapeln"},
		{"konstatera", "konstater"},
		{"konstaterade", "konstater"},
		{"konstaterandet", "konstater"},
		{"konstaterar", "konstater"},
		{"konstaterat", "konstater"},
		{"konsten", "konst"},
		{"konstens", "konst"},
		{"konster", "konst"},
		{"konsterfarna", "konsterf"},
		{"konsterna", "konst"},
		{"konstgjord", "konstgjord"},
		{"konstgjort", "konstgjort"},
		{"konstgrepp", "konstgrepp"},
		{"konstig", "konst"},
		{"konstiga", "konst"},
		{"konstigt", "konst"},
		{"konstkännaremin", "konstkännaremin"},
		{"konstkännedom", "konstkännedom"},
		{"konstlad", "konstl"},
		{"konstlade", "konstl"},
		{"konstnär", "konstnär"},
		{"konstnärer", "konstnär"},
		{"konstnärligt", "konstnär"},
		{"konstrikt", "konstrik"},
		{"konstruera", "konstruer"},
		{"konstruerade", "konstruer"},
		{"konstruerat", "konstruer"},
		{"konstruktioner", "konstruktion"},
		{"konstverk", "konstverk"},
		{"konstverket", "konstverket"},
		{"konsul", "konsul"},
		{"konsuler", "konsul"},
		{"konsulinnans", "konsulinnan"},
		{"konsulisydamerika", "konsulisydamerik"},
		{"konsuln", "konsuln"},
		{"konsulns", "konsuln"},
		{"konsultationen", "konsultation"},
		{"konsultera", "konsulter"},
		{"kontakt", "kontak"},
		{"kontant", "kontant"},
		{"kontanta", "kontant"},
		{"kontanter", "kontant"},
		{"konterfej", "konterfej"},
		{"kontinent", "kontinent"},
		{"kontor", "kont"},
		{"kontoret", "kontoret"},
		{"kontrabesök", "kontrabesök"},
		{"kontrahenterna", "kontrahent"},
		{"kontrast", "kontr"},
		{"kontraster", "kontrast"},
		{"kontravisit", "kontravisit"},
		{"kontrollörn", "kontrollörn"},
		{"konturen", "kontur"},
		{"konturerna", "kontur"},
		{"konung", "konung"},
		{"konungarnes", "konungarn"},
		{"konungason", "konungason"},
		{"konungen", "konung"},
		{"konungens", "konung"},
		{"konungs", "konung"},
		{"konungsfågel", "konungsfågel"},
		{"konventiklar", "konventikl"},
		{"konventionellt", "konventionellt"},
		{"konversation", "konversation"},
		{"konversationstråden", "konversationstråd"},
		{"konverserade", "konverser"},
		{"konvulsioner", "konvulsion"},
		{"konvulsivisk", "konvulsivisk"},
		{"kop", "kop"},
		{"kopia", "kopi"},
		{"kopp", "kopp"},
		{"koppar", "kopp"},
		{"kopparflaska", "kopparflask"},
		{"kopparfärgade", "kopparfärg"},
		{"kopparn", "kopparn"},
		{"kopparröd", "kopparröd"},
		{"koppartälten", "koppartält"},
		{"koppen", "kopp"},
		{"kopplare", "koppl"},
		{"kopplet", "kopplet"},
		{"kopporna", "kopp"},
		{"kor", "kor"},
		{"koral", "koral"},
		{"koralen", "koral"},
		{"kordong", "kordong"},
		{"korets", "koret"},
		{"korg", "korg"},
		{"korgar", "korg"},
		{"korgen", "korg"},
		{"korgossarna", "korgoss"},
		{"korintierna", "korinti"},
		{"korkas", "kork"},
		{"korken", "kork"},
		{"korkskrufven", "korkskrufv"},
		{"korligen", "kor"},
		{"korn", "korn"},
		{"korna", "korn"},
		{"kornas", "korn"},
		{"kornblixtsky", "kornblixtsky"},
		{"kornblå", "kornblå"},
		{"kornen", "korn"},
		{"kornhamn", "kornhamn"},
		{"kornhamnstorg", "kornhamnstorg"},
		{"kornknarr", "kornknarr"},
		{"korp", "korp"},
		{"korpen", "korp"},
		{"korpulent", "korpulent"},
		{"korrekt", "korrek"},
		{"korrekta", "korrek"},
		{"korridor", "korrid"},
		{"korridoren", "korridor"},
		{"korridorens", "korridor"},
		{"korridorerna", "korridor"},
		{"korrigeras", "korriger"},
		{"kors", "kor"},
		{"korsa", "kors"},
		{"korsad", "kors"},
		{"korsade", "kors"},
		{"korsat", "kors"},
		{"korsblick", "korsblick"},
		{"korsdragande", "korsdrag"},
		{"korsdragerskan", "korsdragerskan"},
		{"korset", "korset"},
		{"korsets", "korset"},
		{"korsfästelse", "korsfäst"},
		{"korsfästes", "korsfäst"},
		{"korslagda", "korslag"},
		{"korsmässa", "korsmäss"},
		{"kort", "kort"},
		{"korta", "kort"},
		{"kortare", "kort"},
		{"kortaste", "kort"},
		{"korteligen", "korte"},
		{"korten", "kort"},
		{"kortet", "kortet"},
		{"korthet", "kort"},
		{"korthugget", "korthugget"},
		{"korthuggna", "korthuggn"},
		{"korthus", "korthus"},
		{"kortklippta", "kortklippt"},
		{"kortlapparna", "kortlapp"},
		{"kortlek", "kortlek"},
		{"kortlekar", "kortlek"},
		{"kortligen", "kort"},
		{"kortsidan", "kortsidan"},
		{"kortspel", "kortspel"},
		{"kortspelsbrodern", "kortspelsbrod"},
		{"korus", "korus"},
		{"korv", "korv"},
		{"korvbeställningar", "korvbeställning"},
		{"korvgörningen", "korvgörning"},
		{"kos", "kos"},
		{"kosan", "kosan"},
		{"kossa", "koss"},
		{"kost", "kost"},
		{"kosta", "kost"},
		{"kostade", "kost"},
		{"kostar", "kost"},
		{"kostat", "kost"},
		{"kostbara", "kostbar"},
		{"kostelig", "koste"},
		{"koster", "kost"},
		{"kostföraktare", "kostförak"},
		{"kostlik", "kostlik"},
		{"kostnad", "kostn"},
		{"kostnaden", "kostnad"},
		{"kostsammare", "kostsamm"},
		{"kostym", "kostym"},
		{"kostymerad", "kostymer"},
		{"kotiljongsmärken", "kotiljongsmärk"},
		{"kotlettben", "kotlettb"},
		{"kotletten", "kotlet"},
		{"kotletter", "kotlet"},
		{"kotor", "kot"},
		{"kott", "kott"},
		{"kotteri", "kotteri"},
		{"kottsliga", "kotts"},
		{"kr", "kr"},
		{"krabat", "krab"},
		{"krabban", "krabban"},
		{"krabbor", "krabb"},
		{"krack", "krack"},
		{"kraf", "kraf"},
		{"kraft", "kraft"},
		{"kraften", "kraft"},
		{"krafter", "kraft"},
		{"krafterna", "kraft"},
		{"kraftfull", "kraftfull"},
		{"kraftfulla", "kraftfull"},
		{"kraftfullare", "kraftfull"},
		{"kraftfullaste", "kraftfull"},
		{"kraftfullhet", "kraftfull"},
		{"kraftfullt", "kraftfull"},
		{"kraftgrepp", "kraftgrepp"},
		{"kraftig", "kraft"},
		{"kraftiga", "kraft"},
		{"kraftigare", "kraft"},
		{"kraftigt", "kraft"},
		{"kragar", "krag"},
		{"krage", "krag"},
		{"kragen", "krag"},
		{"krake", "krak"},
		{"krakornas", "krak"},
		{"kram", "kram"},
		{"krama", "kram"},
		{"kramad", "kram"},
		{"kramade", "kram"},
		{"kramande", "kram"},
		{"kramar", "kram"},
		{"kramp", "kramp"},
		{"krampaktig", "krampakt"},
		{"krampaktigt", "krampakt"},
		{"krampgråt", "krampgråt"},
		{"krampor", "kramp"},
		{"kramporna", "kramp"},
		{"kranier", "krani"},
		{"kranium", "kranium"},
		{"krans", "kran"},
		{"kransad", "krans"},
		{"kransar", "krans"},
		{"kransen", "krans"},
		{"krasande", "kras"},
		{"krasandet", "kras"},
		{"krasch", "krasch"},
		{"krassen", "krass"},
		{"kratta", "kratt"},
		{"krav", "krav"},
		{"kredit", "kredit"},
		{"krediten", "kredit"},
		{"kreditorernas", "kreditor"},
		{"kretin", "kretin"},
		{"krets", "kret"},
		{"kretsa", "krets"},
		{"kretsade", "krets"},
		{"kretsande", "krets"},
		{"kretsar", "krets"},
		{"kretsen", "krets"},
		{"kretsgång", "kretsgång"},
		{"kreverar", "krever"},
		{"krig", "krig"},
		{"krigare", "krig"},
		{"krigaren", "krig"},
		{"krigarsläkt", "krigarsläk"},
		{"kriget", "kriget"},
		{"krigets", "kriget"},
		{"krigsklang", "krigsklang"},
		{"krigslist", "krigslist"},
		{"krigsmakten", "krigsmak"},
		{"krigstillstånd", "krigstillstånd"},
		{"krigstillståndet", "krigstillståndet"},
		{"kriminalberättelser", "kriminalberätt"},
		{"krimskrams", "krimskram"},
		{"kring", "kring"},
		{"kringbjudet", "kringbjudet"},
		{"kringelkrokar", "kringelkrok"},
		{"kringfarande", "kringfar"},
		{"kringfladdrande", "kringfladdr"},
		{"kringla", "kringl"},
		{"kringränd", "kringränd"},
		{"kringränna", "kringrän"},
		{"kringspridarc", "kringspridarc"},
		{"kringspridda", "kringsprid"},
		{"kringvandrande", "kringvandr"},
		{"krist", "krist"},
		{"kristaller", "kristall"},
		{"kristallklar", "kristallkl"},
		{"kristallkronor", "kristallkron"},
		{"kristallvas", "kristallv"},
		{"kristen", "krist"},
		{"kristendom", "kristendom"},
		{"kristenhet", "kristen"},
		{"kristenhets", "kristenhet"},
		{"kristet", "kristet"},
		{"kristi", "kristi"},
		{"kristin", "kristin"},
		{"kristina", "kristin"},
		{"kristinas", "kristin"},
		{"kristlig", "krist"},
		{"kristliga", "krist"},
		{"kristligt", "krist"},
		{"kristna", "kristn"},
		{"kristnade", "kristn"},
		{"kristnas", "kristn"},
		{"kristne", "kristn"},
		{"kristningsnamnet", "kristningsnamnet"},
		{"kristum", "kristum"},
		{"kristusbarnet", "kristusbarnet"},
		{"krit", "krit"},
		{"kritade", "krit"},
		{"kritbiten", "kritbit"},
		{"kritblek", "kritblek"},
		{"kritbleka", "kritblek"},
		{"kritcirkeln", "kritcirkeln"},
		{"krithvita", "krithvit"},
		{"kritik", "kritik"},
		{"kritiserande", "kritiser"},
		{"kritisk", "kritisk"},
		{"kritiska", "kritisk"},
		{"kritvita", "kritvit"},
		{"kritvitt", "kritvit"},
		{"krokan", "krokan"},
		{"krokar", "krok"},
		{"krokarna", "krok"},
		{"kroken", "krok"},
		{"krokig", "krok"},
		{"krokiga", "krok"},
		{"krokna", "krokn"},
		{"krokvägar", "krokväg"},
		{"kromatiska", "kromatisk"},
		{"krona", "kron"},
		{"kronan", "kronan"},
		{"kronans", "kronan"},
		{"kronobåten", "kronobåt"},
		{"kronor", "kron"},
		{"kronprinsen", "kronprins"},
		{"krontjufven", "krontjufv"},
		{"kronärtskocka", "kronärtskock"},
		{"kronärtskockan", "kronärtskockan"},
		{"krop", "krop"},
		{"kropp", "kropp"},
		{"kroppar", "kropp"},
		{"kroppen", "kropp"},
		{"kroppens", "kropp"},
		{"kropps", "kropp"},
		{"kroppsarbetare", "kroppsarbet"},
		{"kroppsbyggnad", "kroppsbyggn"},
		{"kroppskrafter", "kroppskraft"},
		{"kroppslig", "kropps"},
		{"kroppsliga", "kropps"},
		{"kroppsligen", "kropps"},
		{"kroppsligt", "kropps"},
		{"krossa", "kross"},
		{"krossad", "kross"},
		{"krossade", "kross"},
		{"krossades", "kross"},
		{"krossadt", "krossad"},
		{"krossande", "kross"},
		{"krossas", "kross"},
		{"krossat", "kross"},
		{"kruka", "kruk"},
		{"krukan", "krukan"},
		{"krukväxter", "krukväxt"},
		{"krukväxterna", "krukväxt"},
		{"krumbukter", "krumbuk"},
		{"krumma", "krumm"},
		{"krupit", "krupit"},
		{"krus", "krus"},
		{"krusa", "krus"},
		{"krusad", "krus"},
		{"krusade", "krus"},
		{"krusades", "krus"},
		{"krusar", "krus"},
		{"krusiga", "krus"},
		{"krusigt", "krus"},
		{"krusning", "krusning"},
		{"krut", "krut"},
		{"krutet", "krutet"},
		{"krutrök", "krutrök"},
		{"krutsprängt", "krutspräng"},
		{"kry", "kry"},
		{"kryare", "kryar"},
		{"kryat", "kryat"},
		{"kryck", "kryck"},
		{"kryckan", "kryckan"},
		{"kryckor", "kryck"},
		{"kryckorna", "kryck"},
		{"kryddad", "krydd"},
		{"kryddan", "kryddan"},
		{"kryddat", "krydd"},
		{"kryddbod", "kryddbod"},
		{"kryddor", "krydd"},
		{"krylbom", "krylbom"},
		{"krymp", "krymp"},
		{"krympa", "krymp"},
		{"krymper", "krymp"},
		{"krympling", "krympling"},
		{"krymplingars", "krymplingar"},
		{"krymplingen", "krympling"},
		{"krympt", "krympt"},
		{"krympte", "krympt"},
		{"kryp", "kryp"},
		{"krypa", "kryp"},
		{"kryper", "kryp"},
		{"krypskytten", "krypskyt"},
		{"kryssade", "kryss"},
		{"kryssar", "kryss"},
		{"kryssat", "kryss"},
		{"krysta", "kryst"},
		{"kräfde", "kräfd"},
		{"kräfta", "kräft"},
		{"kräftan", "kräftan"},
		{"kräftartad", "kräftart"},
		{"kräftor", "kräft"},
		{"kräftskal", "kräftskal"},
		{"kräk", "kräk"},
		{"kräkas", "kräk"},
		{"kräken", "kräk"},
		{"kräket", "kräket"},
		{"kräktes", "kräkt"},
		{"krälade", "kräl"},
		{"krälande", "kräl"},
		{"krämarborden", "krämarbord"},
		{"krämpor", "krämp"},
		{"krängde", "kräng"},
		{"kränkta", "kränk"},
		{"kräsen", "kräs"},
		{"kräver", "kräv"},
		{"kråka", "kråk"},
		{"kråkans", "kråkan"},
		{"kråkfot", "kråkfot"},
		{"kråkfötter", "kråkföt"},
		{"kråkor", "kråk"},
		{"kråkorna", "kråk"},
		{"kråkunge", "kråkung"},
		{"kråmar", "kråm"},
		{"krångel", "krångel"},
		{"krångla", "krångl"},
		{"krångliga", "krång"},
		{"krångligare", "krång"},
		{"kråsbandet", "kråsb"},
		{"kråset", "kråset"},
		{"kråsnål", "kråsnål"},
		{"krök", "krök"},
		{"kröka", "krök"},
		{"krökar", "krök"},
		{"krökning", "krökning"},
		{"krökningar", "krökning"},
		{"krökningen", "krökning"},
		{"krökt", "krökt"},
		{"krökta", "krökt"},
		{"krökte", "krökt"},
		{"krön", "krön"},
		{"kröna", "krön"},
		{"krönas", "krön"},
		{"krönen", "krön"},
		{"krönet", "krönet"},
		{"krönika", "krönik"},
		{"kröningsdag", "kröningsdag"},
		{"kröningsmarschen", "kröningsmarsch"},
		{"kröningsmynt", "kröningsmynt"},
		{"kröp", "kröp"},
		{"kröpo", "kröpo"},
		{"ktocka", "ktock"},
		{"kuappt", "kuappt"},
		{"kuddar", "kudd"},
		{"kuddarna", "kudd"},
		{"kuddc", "kuddc"},
		{"kudde", "kudd"},
		{"kudden", "kudd"},
		{"kuddvar", "kuddv"},
		{"kufvades", "kufv"},
		{"kufvadt", "kufvad"},
		{"kujonera", "kujoner"},
		{"kula", "kul"},
		{"kulan", "kulan"},
		{"kulen", "kul"},
		{"kulet", "kulet"},
		{"kuliss", "kuliss"},
		{"kulissen", "kuliss"},
		{"kulisserna", "kuliss"},
		{"kull", "kull"},
		{"kullar", "kull"},
		{"kullarna", "kull"},
		{"kullbåtarna", "kullbåt"},
		{"kulle", "kull"},
		{"kullen", "kull"},
		{"kullerstenar", "kullersten"},
		{"kullerstenarna", "kullersten"},
		{"kullerstolen", "kullerstol"},
		{"kullisserna", "kulliss"},
		{"kullkastat", "kullkast"},
		{"kullstjälpt", "kullstjälpt"},
		{"kulma", "kulm"},
		{"kulor", "kul"},
		{"kulorna", "kul"},
		{"kulturen", "kultur"},
		{"kulörta", "kulört"},
		{"kum", "kum"},
		{"kumpanerna", "kumpan"},
		{"kund", "kund"},
		{"kundc", "kundc"},
		{"kunde", "kund"},
		{"kunder", "kund"},
		{"kung", "kung"},
		{"kungen", "kung"},
		{"kungens", "kung"},
		{"kungjorde", "kungjord"},
		{"kungjordes", "kungjord"},
		{"kungl", "kungl"},
		{"kunglig", "kung"},
		{"kungliga", "kung"},
		{"kungsholmen", "kungsholm"},
		{"kungsträdgården", "kungsträdgård"},
		{"kungsängsliljor", "kungsängslilj"},
		{"kunna", "kunn"},
		{"kunnat", "kunn"},
		{"kunnelse", "kunn"},
		{"kunnig", "kunn"},
		{"kunniga", "kunn"},
		{"kunskap", "kunskap"},
		{"kunskaper", "kunskap"},
		{"kupeerna", "kupe"},
		{"kupefönstren", "kupefönstr"},
		{"kupiga", "kup"},
		{"kur", "kur"},
		{"kurage", "kurag"},
		{"kurbits", "kurbit"},
		{"kurbitsen", "kurbits"},
		{"kurbitsmålning", "kurbitsmålning"},
		{"kuren", "kur"},
		{"kurerar", "kurer"},
		{"kurlde", "kurld"},
		{"kurma", "kurm"},
		{"kurna", "kurn"},
		{"kurort", "kurort"},
		{"kurragömmalek", "kurragömmalek"},
		{"kurre", "kurr"},
		{"kurs", "kur"},
		{"kursavgifter", "kursavgift"},
		{"kursen", "kurs"},
		{"kursiv", "kursiv"},
		{"kursiva", "kursiv"},
		{"kurtis", "kurtis"},
		{"kurtisaner", "kurtisan"},
		{"kurtisen", "kurtis"},
		{"kurtiser", "kurtis"},
		{"kurva", "kurv"},
		{"kurvor", "kurv"},
		{"kuscha", "kusch"},
		{"kusin", "kusin"},
		{"kusinens", "kusin"},
		{"kusiner", "kusin"},
		{"kusinerna", "kusin"},
		{"kusinernas", "kusin"},
		{"kusins", "kusin"},
		{"kusken", "kusk"},
		{"kusligt", "kus"},
		{"kust", "kust"},
		{"kustbevakare", "kustbevak"},
		{"kustbevakaren", "kustbevak"},
		{"kustbevakarens", "kustbevak"},
		{"kusten", "kust"},
		{"kustens", "kust"},
		{"kustnaturen", "kustnatur"},
		{"kuststaden", "kuststad"},
		{"kusttjensteman", "kusttjensteman"},
		{"kusttjenstemän", "kusttjenstemän"},
		{"kustuppsyningsmannen", "kustuppsyningsman"},
		{"kut", "kut"},
		{"kutiga", "kut"},
		{"kutter", "kutt"},
		{"kuttra", "kuttr"},
		{"kuva", "kuv"},
		{"kuvad", "kuv"},
		{"kuvade", "kuv"},
		{"kuvert", "kuvert"},
		{"kuvertet", "kuvertet"},
		{"kvadrat", "kvadr"},
		{"kvadraten", "kvadrat"},
		{"kval", "kval"},
		{"kvald", "kvald"},
		{"kvalda", "kvald"},
		{"kvalde", "kvald"},
		{"kvaldes", "kvald"},
		{"kvalfull", "kvalfull"},
		{"kvalfullt", "kvalfull"},
		{"kvalfylld", "kvalfylld"},
		{"kvalitetsvagn", "kvalitetsvagn"},
		{"kvall", "kvall"},
		{"kvalm", "kvalm"},
		{"kvalmig", "kvalm"},
		{"kvalmiga", "kvalm"},
		{"kvar", "kvar"},
		{"kvarblevo", "kvarblevo"},
		{"kvarglömd", "kvarglömd"},
		{"kvarhålla", "kvarhåll"},
		{"kvarhölls", "kvarhöll"},
		{"kvarlevande", "kvarlev"},
		{"kvarlevorna", "kvarlev"},
		{"kvarlämna", "kvarlämn"},
		{"kvarndrängen", "kvarndräng"},
		{"kvarnen", "kvarn"},
		{"kvarnforsen", "kvarnfors"},
		{"kvarnhjul", "kvarnhjul"},
		{"kvarnhjulshatten", "kvarnhjulshat"},
		{"kvarnlekan", "kvarnlekan"},
		{"kvarntorrt", "kvarntorrt"},
		{"kvarnvinden", "kvarnvind"},
		{"kvarsittande", "kvarsit"},
		{"kvarsittare", "kvarsit"},
		{"kvarstod", "kvarstod"},
		{"kvarstå", "kvarstå"},
		{"kvart", "kvart"},
		{"kvartalet", "kvartalet"},
		{"kvartalets", "kvartalet"},
		{"kvartalsvis", "kvartalsvis"},
		{"kvarteis", "kvarteis"},
		{"kvarten", "kvart"},
		{"kvarter", "kvart"},
		{"kvarts", "kvart"},
		{"kvartsbuteljer", "kvartsbutelj"},
		{"kvasten", "kvast"},
		{"kvastkäpp", "kvastkäpp"},
		{"kvav", "kvav"},
		{"kvava", "kvav"},
		{"kvavt", "kvavt"},
		{"kved", "kved"},
		{"kvick", "kvick"},
		{"kvicka", "kvick"},
		{"kvickheter", "kvick"},
		{"kvickna", "kvickn"},
		{"kvickt", "kvick"},
		{"kvida", "kvid"},
		{"kvidande", "kvid"},
		{"kvider", "kvid"},
		{"kvill", "kvill"},
		{"kvin", "kvin"},
		{"kvinna", "kvinn"},
		{"kvinnan", "kvinnan"},
		{"kvinnans", "kvinnan"},
		{"kvinnas", "kvinn"},
		{"kvinnfolk", "kvinnfolk"},
		{"kvinnfolken", "kvinnfolk"},
		{"kvinnlig", "kvinn"},
		{"kvinnliga", "kvinn"},
		{"kvinnlighet", "kvinn"},
		{"kvinnligt", "kvinn"},
		{"kvinno", "kvinno"},
		{"kvinnoarmar", "kvinnoarm"},
		{"kvinnoblomma", "kvinnoblomm"},
		{"kvinnoblomman", "kvinnoblomman"},
		{"kvinnohuvuds", "kvinnohuvud"},
		{"kvinnohår", "kvinnohår"},
		{"kvinnokropp", "kvinnokropp"},
		{"kvinnolist", "kvinnolist"},
		{"kvinnoläkare", "kvinnoläk"},
		{"kvinnoläkaren", "kvinnoläk"},
		{"kvinnomakt", "kvinnomak"},
		{"kvinnomänniska", "kvinnomännisk"},
		{"kvinnor", "kvinn"},
		{"kvinnorna", "kvinn"},
		{"kvinnornas", "kvinn"},
		{"kvinnorov", "kvinnorov"},
		{"kvinnors", "kvinnor"},
		{"kvinnoröst", "kvinnoröst"},
		{"kvinnorösten", "kvinnoröst"},
		{"kvinnosidan", "kvinnosidan"},
		{"kvinnoskepelse", "kvinnoskep"},
		{"kvinnovarelse", "kvinnovar"},
		{"kvinnsperson", "kvinnsperson"},
		{"kvist", "kvist"},
		{"kvistar", "kvist"},
		{"kvisten", "kvist"},
		{"kvitt", "kvitt"},
		{"kvitter", "kvitt"},
		{"kvittera", "kvitter"},
		{"kvitterat", "kvitter"},
		{"kvittning", "kvittning"},
		{"kvittra", "kvittr"},
		{"kvittrade", "kvittr"},
		{"kvittrande", "kvittr"},
		{"kvittrat", "kvittr"},
		{"kväd", "kväd"},
		{"kväden", "kväd"},
		{"kväkarsträng", "kväkarsträng"},
		{"kväljningar", "kväljning"},
		{"kväljningarna", "kväljning"},
		{"kväll", "kväll"},
		{"kvälla", "kväll"},
		{"kvällar", "kväll"},
		{"kvällarna", "kväll"},
		{"kvälldags", "kvälldag"},
		{"kvällen", "kväll"},
		{"kvällens", "kväll"},
		{"kvällshimlens", "kvällshiml"},
		{"kvällsluften", "kvällsluft"},
		{"kvällsolen", "kvällsol"},
		{"kvällspromenad", "kvällspromen"},
		{"kvällssky", "kvällssky"},
		{"kvällstysta", "kvällstyst"},
		{"kvällsvard", "kvällsvard"},
		{"kvällsvarden", "kvällsvard"},
		{"kväsa", "kväs"},
		{"kväv", "kväv"},
		{"kväva", "kväv"},
		{"kvävande", "kväv"},
		{"kvävas", "kväv"},
		{"kvävd", "kvävd"},
		{"kvävda", "kvävd"},
		{"kvävde", "kvävd"},
		{"kvävdes", "kvävd"},
		{"kväve", "kväv"},
		{"kvävs", "kväv"},
		{"kvävt", "kvävt"},
		{"kycklidgar", "kycklidg"},
		{"kycklingar", "kyckling"},
		{"kyffet", "kyffet"},
		{"kyla", "kyl"},
		{"kylde", "kyld"},
		{"kylig", "kyl"},
		{"kyliga", "kyl"},
		{"kyligt", "kyl"},
		{"kymmer", "kymm"},
		{"kymriska", "kymrisk"},
		{"kyparen", "kyp"},
		{"kyrka", "kyrk"},
		{"kyrkan", "kyrkan"},
		{"kyrkans", "kyrkan"},
		{"kyrkfolket", "kyrkfolket"},
		{"kyrkklockan", "kyrkklockan"},
		{"kyrkklockans", "kyrkklockan"},
		{"kyrkobacken", "kyrkoback"},
		{"kyrkofadern", "kyrkofad"},
		{"kyrkogard", "kyrkogard"},
		{"kyrkogardar", "kyrkogard"},
		{"kyrkogård", "kyrkogård"},
		{"kyrkogården", "kyrkogård"},
		{"kyrkogårdens", "kyrkogård"},
		{"kyrkogårdshymner", "kyrkogårdshymn"},
		{"kyrkogårdshörnet", "kyrkogårdshörnet"},
		{"kyrkogårdsmuren", "kyrkogårdsmur"},
		{"kyrkogårdsporten", "kyrkogårdsport"},
		{"kyrkoherde", "kyrkoherd"},
		{"kyrkoherden", "kyrkoherd"},
		{"kyrkomuren", "kyrkomur"},
		{"kyrkomusiken", "kyrkomusik"},
		{"kyrkor", "kyrk"},
		{"kyrkorna", "kyrk"},
		{"kyrkosångarne", "kyrkosång"},
		{"kyrkovärdar", "kyrkovärd"},
		{"kyrkplikt", "kyrkplik"},
		{"kyrkporten", "kyrkport"},
		{"kyrksilvret", "kyrksilvret"},
		{"kyrkspiran", "kyrkspiran"},
		{"kyrktaket", "kyrktaket"},
		{"kyrktornet", "kyrktornet"},
		{"kyrktrappan", "kyrktrappan"},
		{"kyrktuppen", "kyrktupp"},
		{"kyrkvallen", "kyrkvall"},
		{"kysk", "kysk"},
		{"kyska", "kysk"},
		{"kyss", "kyss"},
		{"kyssa", "kyss"},
		{"kyssande", "kyss"},
		{"kyssar", "kyss"},
		{"kyssarna", "kyss"},
		{"kyssas", "kyss"},
		{"kyssen", "kyss"},
		{"kysser", "kyss"},
		{"kysst", "kysst"},
		{"kysste", "kysst"},
		{"kysstes", "kysst"},
		{"käck", "käck"},
		{"käcka", "käck"},
		{"käckaste", "käck"},
		{"käckt", "käck"},
		{"käft", "käft"},
		{"käften", "käft"},
		{"kägla", "kägl"},
		{"käk", "käk"},
		{"käkar", "käk"},
		{"käkarna", "käk"},
		{"kälkborgare", "kälkborg"},
		{"källa", "käll"},
		{"källan", "källan"},
		{"källare", "käll"},
		{"källaren", "käll"},
		{"källarglugg", "källarglugg"},
		{"källarkund", "källarkund"},
		{"källarmästaren", "källarmäst"},
		{"källarmästarfrun", "källarmästarfrun"},
		{"källarn", "källarn"},
		{"källarsal", "källarsal"},
		{"källas", "käll"},
		{"källklar", "källkl"},
		{"källorna", "käll"},
		{"källrar", "källr"},
		{"kälms", "kälm"},
		{"kält", "kält"},
		{"kämla", "käml"},
		{"kämpa", "kämp"},
		{"kämpade", "kämp"},
		{"kämpande", "kämp"},
		{"kämpat", "kämp"},
		{"känbar", "känb"},
		{"känbart", "känbart"},
		{"känd", "känd"},
		{"kända", "känd"},
		{"kändc", "kändc"},
		{"kände", "känd"},
		{"kändes", "känd"},
		{"kängor", "käng"},
		{"känhända", "känhänd"},
		{"känn", "känn"},
		{"känna", "känn"},
		{"kännareblick", "kännareblick"},
		{"kännas", "känn"},
		{"kännbar", "kännb"},
		{"kännbart", "kännbart"},
		{"känncr", "känncr"},
		{"känne", "känn"},
		{"kännedom", "kännedom"},
		{"kännedomen", "kännedom"},
		{"känner", "känn"},
		{"kännes", "känn"},
		{"kännetecken", "känneteck"},
		{"känning", "känning"},
		{"känningar", "känning"},
		{"känns", "känn"},
		{"käns", "kän"},
		{"känsla", "känsl"},
		{"känslan", "känslan"},
		{"känslans", "känslan"},
		{"känslig", "käns"},
		{"känsliga", "käns"},
		{"känslige", "käns"},
		{"känsligt", "käns"},
		{"känsloliv", "känsloliv"},
		{"känslolös", "känslolös"},
		{"känslolöst", "känslolös"},
		{"känslor", "känsl"},
		{"känslorna", "känsl"},
		{"känslornas", "känsl"},
		{"känslostormarna", "känslostorm"},
		{"känslouttryck", "känslouttryck"},
		{"känsö", "känsö"},
		{"känt", "känt"},
		{"känts", "känt"},
		{"käpp", "käpp"},
		{"käppen", "käpp"},
		{"käppkryckan", "käppkryckan"},
		{"kär", "kär"},
		{"kära", "kär"},
		{"kärare", "kär"},
		{"käraste", "kär"},
		{"kärastes", "kärast"},
		{"käre", "kär"},
		{"käresta", "kärest"},
		{"kärestan", "kärestan"},
		{"kärft", "kärft"},
		{"käri", "käri"},
		{"käril", "käril"},
		{"käring", "käring"},
		{"käringar", "käring"},
		{"käringen", "käring"},
		{"kärl", "kärl"},
		{"kärlek", "kärlek"},
		{"kärleken", "kärlek"},
		{"kärlekens", "kärlek"},
		{"kärleks", "kärlek"},
		{"kärleksaffären", "kärleksaffär"},
		{"kärleksakten", "kärleksak"},
		{"kärleksbetygelser", "kärleksbetyg"},
		{"kärleksbrev", "kärleksbrev"},
		{"kärleksfull", "kärleksfull"},
		{"kärleksfulla", "kärleksfull"},
		{"kärleksfulle", "kärleksfull"},
		{"kärleksfullt", "kärleksfull"},
		{"kärleksförkiaringarna", "kärleksförkiaring"},
		{"kärleksförklaring", "kärleksförklaring"},
		{"kärleksförklaringarna", "kärleksförklaring"},
		{"kärleksglam", "kärleksglam"},
		{"kärlekshandel", "kärlekshandel"},
		{"kärlekshistoria", "kärlekshistori"},
		{"kärlekshistorien", "kärlekshistori"},
		{"kärlekshistorier", "kärlekshistori"},
		{"kärleksintrig", "kärleksintr"},
		{"kärlekskamp", "kärlekskamp"},
		{"kärleksmånen", "kärleksmån"},
		{"kärleksmöten", "kärleksmöt"},
		{"kärleksrika", "kärleksrik"},
		{"kärleksromaner", "kärleksroman"},
		{"kärleksscener", "kärleksscen"},
		{"kärleksvarm", "kärleksvarm"},
		{"kärleksveckornas", "kärleksveck"},
		{"kärleksvind", "kärleksvind"},
		{"kärlig", "kär"},
		{"kärligt", "kär"},
		{"kärna", "kärn"},
		{"kärnan", "kärnan"},
		{"kärnfulla", "kärnfull"},
		{"kärnlöst", "kärnlös"},
		{"kärnspråk", "kärnspråk"},
		{"kärr", "kärr"},
		{"kärra", "kärr"},
		{"kärran", "kärran"},
		{"kärren", "kärr"},
		{"kärret", "kärret"},
		{"kärt", "kärt"},
		{"kärv", "kärv"},
		{"kärva", "kärv"},
		{"kärvt", "kärvt"},
		{"kättja", "kättj"},
		{"kättjan", "kättjan"},
		{"kådiga", "kåd"},
		{"kåkar", "kåk"},
		{"kålen", "kål"},
		{"kåpa", "kåp"},
		{"kår", "kår"},
		{"kåren", "kår"},
		{"kåttjefulla", "kåttjefull"},
		{"kökemästarn", "kökemästarn"},
		{"köket", "köket"},
		{"köks", "kök"},
		{"köksbordet", "köksbordet"},
		{"köksfönster", "köksfönst"},
		{"köksgolvet", "köksgolvet"},
		{"kökslampa", "kökslamp"},
		{"köksskåp", "köksskåp"},
		{"köksträdgården", "köksträdgård"},
		{"köksväldet", "köksväldet"},
		{"köld", "köld"},
		{"kölden", "köld"},
		{"köldrysning", "köldrysning"},
		{"kön", "kön"},
		{"könet", "könet"},
		{"königsmarck", "königsmarck"},
		{"königsmarcks", "königsmarck"},
		{"könsdrift", "könsdrift"},
		{"könsliga", "köns"},
		{"köp", "köp"},
		{"köpa", "köp"},
		{"köpare", "köp"},
		{"köparen", "köp"},
		{"köparinnan", "köparinnan"},
		{"köper", "köp"},
		{"köpet", "köpet"},
		{"köpman", "köpman"},
		{"köpmangatan", "köpmangatan"},
		{"köpmannen", "köpman"},
		{"köpmanshus", "köpmanshus"},
		{"köpt", "köpt"},
		{"köpta", "köpt"},
		{"köpte", "köpt"},
		{"kör", "kör"},
		{"köra", "kör"},
		{"körande", "kör"},
		{"köras", "kör"},
		{"körbanan", "körbanan"},
		{"körde", "körd"},
		{"kördes", "körd"},
		{"körjade", "körj"},
		{"körsbär", "körsbär"},
		{"körsbäret", "körsbäret"},
		{"körsbärssaft", "körsbärssaft"},
		{"körsbärssylt", "körsbärssylt"},
		{"körsbärsträd", "körsbärsträd"},
		{"körsbärsträden", "körsbärsträd"},
		{"körsång", "körsång"},
		{"kört", "kört"},
		{"kött", "kött"},
		{"köttben", "köttb"},
		{"köttbullar", "köttbull"},
		{"köttet", "köttet"},
		{"köttets", "köttet"},
		{"köttslig", "kötts"},
		{"l", "l"},
		{"la", "la"},
		{"labyrint", "labyrint"},
		{"lack", "lack"},
		{"lackar", "lack"},
		{"lackeringen", "lackering"},
		{"lackkängornas", "lackkäng"},
		{"lad", "lad"},
		{"lada", "lad"},
		{"ladc", "ladc"},
		{"laddad", "ladd"},
		{"lade", "lad"},
		{"laderartade", "laderart"},
		{"lades", "lad"},
		{"ladugård", "ladugård"},
		{"ladugården", "ladugård"},
		{"ladugårdsförmannen", "ladugårdsförman"},
		{"ladugårdslandet", "ladugårdsl"},
		{"ladugårdspiga", "ladugårdsp"},
		{"lafve", "lafv"},
		{"lag", "lag"},
		{"laga", "lag"},
		{"lagad", "lag"},
		{"lagade", "lag"},
		{"lagar", "lag"},
		{"lagarna", "lag"},
		{"lagarne", "lag"},
		{"lagas", "lag"},
		{"lagat", "lag"},
		{"lagd", "lagd"},
		{"lagda", "lagd"},
		{"lagen", "lag"},
		{"lagenliga", "lagen"},
		{"lagens", "lag"},
		{"lager", "lag"},
		{"lagerheim", "lagerheim"},
		{"laget", "laget"},
		{"laggargamla", "laggargaml"},
		{"laglig", "lag"},
		{"lagliga", "lag"},
		{"lagman", "lagman"},
		{"lagmannen", "lagman"},
		{"lagmannens", "lagman"},
		{"lago", "lago"},
		{"lagom", "lagom"},
		{"lagpara", "lagpar"},
		{"lagra", "lagr"},
		{"lagrade", "lagr"},
		{"lagrar", "lagr"},
		{"lagrat", "lagr"},
		{"lagstiftare", "lagstift"},
		{"lagsökningarna", "lagsökning"},
		{"lagt", "lagt"},
		{"lakan", "lakan"},
		{"lakanen", "lakan"},
		{"lakanet", "lakanet"},
		{"lakej", "lakej"},
		{"lakoniskt", "lakonisk"},
		{"lallade", "lall"},
		{"lam", "lam"},
		{"lama", "lam"},
		{"lamdet", "lamdet"},
		{"lamm", "lamm"},
		{"lammet", "lammet"},
		{"lammungar", "lammung"},
		{"lamna", "lamn"},
		{"lamnade", "lamn"},
		{"lamp", "lamp"},
		{"lampa", "lamp"},
		{"lampan", "lampan"},
		{"lampetterna", "lampet"},
		{"lampglaset", "lampglaset"},
		{"lampor", "lamp"},
		{"lamporna", "lamp"},
		{"lampsken", "lampsk"},
		{"lampskenet", "lampskenet"},
		{"lamt", "lamt"},
		{"lan", "lan"},
		{"land", "land"},
		{"landa", "land"},
		{"landbacken", "landback"},
		{"landborg", "landborg"},
		{"landborgs", "landborg"},
		{"lande", "land"},
		{"landen", "land"},
		{"lander", "land"},
		{"landet", "landet"},
		{"landets", "landet"},
		{"landgången", "landgång"},
		{"landning", "landning"},
		{"lands", "land"},
		{"landsbygden", "landsbyg"},
		{"landsens", "lands"},
		{"landsförsamlingar", "landsförsamling"},
		{"landskap", "landskap"},
		{"landskapet", "landskapet"},
		{"landskyrkornas", "landskyrk"},
		{"landsmål", "landsmål"},
		{"landsorten", "landsort"},
		{"landställe", "landställ"},
		{"landsväg", "landsväg"},
		{"landsvägen", "landsväg"},
		{"landsändar", "landsänd"},
		{"landtlig", "landt"},
		{"landvägen", "landväg"},
		{"lanet", "lanet"},
		{"lang", "lang"},
		{"langa", "lang"},
		{"lange", "lang"},
		{"langrandiga", "langrand"},
		{"langre", "langr"},
		{"langsamt", "langsamt"},
		{"langt", "lang"},
		{"langtade", "lang"},
		{"langtan", "langtan"},
		{"langtancle", "langtancl"},
		{"langtifrån", "langtifrån"},
		{"lantbrukare", "lantbruk"},
		{"lanternorna", "lantern"},
		{"lanthushåll", "lanthushåll"},
		{"lantlig", "lant"},
		{"lantliga", "lant"},
		{"lantligaste", "lant"},
		{"lantligt", "lant"},
		{"lantluft", "lantluft"},
		{"lantluften", "lantluft"},
		{"lantnöje", "lantnöj"},
		{"lantsejuren", "lantsejur"},
		{"lantställe", "lantställ"},
		{"lantstället", "lantstället"},
		{"lanttöser", "lanttös"},
		{"lapade", "lap"},
		{"lapp", "lapp"},
		{"lappar", "lapp"},
		{"lappri", "lappri"},
		{"lapprihändelse", "lapprihänd"},
		{"lapprihändelsen", "lapprihänd"},
		{"lara", "lar"},
		{"larm", "larm"},
		{"larmar", "larm"},
		{"larmet", "larmet"},
		{"larna", "larn"},
		{"lars", "lar"},
		{"larsdotter", "larsdot"},
		{"larses", "lars"},
		{"larsmesse", "larsmess"},
		{"larsmessefärden", "larsmessefärd"},
		{"larsson", "larsson"},
		{"lart", "lart"},
		{"larv", "larv"},
		{"lass", "lass"},
		{"lasset", "lasset"},
		{"lassman", "lassman"},
		{"lassmans", "lassman"},
		{"last", "last"},
		{"lastad", "last"},
		{"lastade", "last"},
		{"lastat", "last"},
		{"lastdjur", "lastdjur"},
		{"lasten", "last"},
		{"laster", "last"},
		{"lasterna", "last"},
		{"lastfulle", "lastfull"},
		{"lastning", "lastning"},
		{"lat", "lat"},
		{"lata", "lat"},
		{"latin", "latin"},
		{"latit", "latit"},
		{"latt", "latt"},
		{"latta", "latt"},
		{"lattare", "latt"},
		{"laura", "laur"},
		{"laurentia", "laurenti"},
		{"lave", "lav"},
		{"lavoar", "lavo"},
		{"lavoaren", "lavo"},
		{"lavoarens", "lavo"},
		{"lazulit", "lazulit"},
		{"lbland", "lbland"},
		{"ldälmandc", "ldälmandc"},
		{"le", "le"},
		{"led", "led"},
		{"leda", "led"},
		{"ledamot", "ledamot"},
		{"ledande", "led"},
		{"ledare", "led"},
		{"ledas", "led"},
		{"ledast", "led"},
		{"ledband", "ledband"},
		{"ledbandet", "ledb"},
		{"ledd", "ledd"},
		{"ledde", "ledd"},
		{"leddes", "ledd"},
		{"lede", "led"},
		{"leder", "led"},
		{"ledes", "led"},
		{"ledig", "led"},
		{"lediga", "led"},
		{"ledighet", "led"},
		{"ledigt", "led"},
		{"ledmotivet", "ledmotivet"},
		{"ledning", "ledning"},
		{"ledo", "ledo"},
		{"leds", "led"},
		{"ledsagade", "ledsag"},
		{"ledsagarinnans", "ledsagarinnan"},
		{"ledsage", "ledsag"},
		{"ledsam", "ledsam"},
		{"ledsamhet", "ledsam"},
		{"ledsamheter", "ledsam"},
		{"ledsamma", "ledsamm"},
		{"ledsamt", "ledsamt"},
		{"ledsen", "leds"},
		{"ledsna", "ledsn"},
		{"ledsnad", "ledsn"},
		{"ledsnade", "ledsn"},
		{"ledsnaden", "ledsnad"},
		{"ledsnar", "ledsn"},
		{"ledsnat", "ledsn"},
		{"ledt", "ledt"},
		{"ledtråd", "ledtråd"},
		{"ledtråden", "ledtråd"},
		{"leendc", "leendc"},
		{"leende", "leend"},
		{"leenden", "leend"},
		{"leendet", "leendet"},
		{"lefde", "lefd"},
		{"lefnad", "lefn"},
		{"lefnadsfrisk", "lefnadsfrisk"},
		{"lefnadslust", "lefnadslust"},
		{"lefnadsomständigheter", "lefnadsomständ"},
		{"lefnadssätt", "lefnadssät"},
		{"lefva", "lefv"},
		{"lefvande", "lefv"},
		{"lefvat", "lefv"},
		{"lefve", "lefv"},
		{"lefver", "lefv"},
		{"lefvernet", "lefvernet"},
		{"legat", "leg"},
		{"legenden", "legend"},
		{"legendens", "legend"},
		{"lejd", "lejd"},
		{"lejon", "lejon"},
		{"lejonet", "lejonet"},
		{"lejonhona", "lejonhon"},
		{"lek", "lek"},
		{"leka", "lek"},
		{"lekamde", "lekamd"},
		{"lekamen", "lekam"},
		{"lekamligen", "lekam"},
		{"lekande", "lek"},
		{"lekar", "lek"},
		{"leken", "lek"},
		{"leker", "lek"},
		{"lekfullt", "lekfull"},
		{"lekhus", "lekhus"},
		{"lekkamrat", "lekkamr"},
		{"lekman", "lekman"},
		{"leks", "lek"},
		{"leksaken", "leksak"},
		{"leksakerna", "leksak"},
		{"lekstugan", "lekstugan"},
		{"lekt", "lekt"},
		{"lekte", "lekt"},
		{"lektion", "lektion"},
		{"lektionen", "lektion"},
		{"lektioner", "lektion"},
		{"lektionerna", "lektion"},
		{"lektionsbordet", "lektionsbordet"},
		{"lektionsdagarna", "lektionsdag"},
		{"lektor", "lekt"},
		{"lektorn", "lektorn"},
		{"lel", "lel"},
		{"lem", "lem"},
		{"lemlästade", "lemläst"},
		{"lemmar", "lemm"},
		{"lemmarna", "lemm"},
		{"lemmarne", "lemm"},
		{"lemmen", "lemm"},
		{"lemna", "lemn"},
		{"lemnad", "lemn"},
		{"lemnade", "lemn"},
		{"lemnadt", "lemnad"},
		{"lemnar", "lemn"},
		{"lemnat", "lemn"},
		{"lemningar", "lemning"},
		{"lemningarne", "lemning"},
		{"len", "len"},
		{"lena", "len"},
		{"lenar", "len"},
		{"lenare", "len"},
		{"lenas", "len"},
		{"lenaste", "len"},
		{"lennarby", "lennarby"},
		{"lent", "lent"},
		{"leopold", "leopold"},
		{"ler", "ler"},
		{"leran", "leran"},
		{"lerkrus", "lerkrus"},
		{"les", "les"},
		{"let", "let"},
		{"leta", "let"},
		{"letade", "let"},
		{"letande", "let"},
		{"letar", "let"},
		{"letas", "let"},
		{"letat", "let"},
		{"lett", "lett"},
		{"letty", "letty"},
		{"leur", "leur"},
		{"leurs", "leur"},
		{"leva", "lev"},
		{"levamde", "levamd"},
		{"levande", "lev"},
		{"levandes", "lev"},
		{"levas", "lev"},
		{"levat", "lev"},
		{"levde", "levd"},
		{"levdes", "levd"},
		{"levdl", "levdl"},
		{"levelse", "lev"},
		{"lever", "lev"},
		{"leverera", "leverer"},
		{"leverne", "levern"},
		{"levin", "levin"},
		{"levins", "levin"},
		{"levnad", "levn"},
		{"levnads", "levnad"},
		{"levnadsfilosofi", "levnadsfilosofi"},
		{"levnadsfriska", "levnadsfrisk"},
		{"levnadsförhållanden", "levnadsförhåll"},
		{"levnadsglad", "levnadsgl"},
		{"levnadsglade", "levnadsgl"},
		{"levnadssättet", "levnadssättet"},
		{"lewinson", "lewinson"},
		{"lexa", "lex"},
		{"lexan", "lexan"},
		{"lexor", "lex"},
		{"lgol", "lgol"},
		{"lgon", "lgon"},
		{"lhl", "lhl"},
		{"li", "li"},
		{"liber", "lib"},
		{"liberalare", "liberal"},
		{"liberale", "liberal"},
		{"liberalt", "liberalt"},
		{"liberi", "liberi"},
		{"licentiat", "licenti"},
		{"licentiaten", "licentiat"},
		{"licka", "lick"},
		{"lickan", "lickan"},
		{"lid", "lid"},
		{"lida", "lid"},
		{"lidande", "lid"},
		{"lidanden", "lid"},
		{"lidandes", "lid"},
		{"lidandet", "lid"},
		{"lidandets", "lidandet"},
		{"lidelse", "lid"},
		{"lidelsefull", "lidelsefull"},
		{"lidelsefullt", "lidelsefull"},
		{"lidelsen", "lid"},
		{"lidelsens", "lid"},
		{"lidelser", "lid"},
		{"liden", "lid"},
		{"lider", "lid"},
		{"liderlig", "lider"},
		{"liderliga", "lider"},
		{"lidit", "lidit"},
		{"lidna", "lidn"},
		{"lie", "lie"},
		{"lieder", "lied"},
		{"lien", "lien"},
		{"lif", "lif"},
		{"lifhanken", "lifhank"},
		{"liflig", "lif"},
		{"lifliga", "lif"},
		{"lifligt", "lif"},
		{"liflös", "liflös"},
		{"liflösa", "liflös"},
		{"liflöst", "liflös"},
		{"lifnärde", "lifnärd"},
		{"lifs", "lif"},
		{"lifsblomma", "lifsblomm"},
		{"lifsfara", "lifsfar"},
		{"lifsfulla", "lifsfull"},
		{"lifsgnistan", "lifsgnistan"},
		{"lifskraft", "lifskraft"},
		{"lifslefvande", "lifslefv"},
		{"lifstid", "lifstid"},
		{"lifstiden", "lifstid"},
		{"lifsuppgift", "lifsuppgift"},
		{"lifva", "lifv"},
		{"lifvad", "lifv"},
		{"lifvade", "lifv"},
		{"lifvar", "lifv"},
		{"lifvas", "lifv"},
		{"lifvet", "lifvet"},
		{"lifvets", "lifvet"},
		{"lig", "lig"},
		{"liga", "lig"},
		{"ligare", "lig"},
		{"lige", "lig"},
		{"ligen", "lig"},
		{"ligg", "ligg"},
		{"ligga", "ligg"},
		{"liggande", "ligg"},
		{"ligger", "ligg"},
		{"lighet", "lig"},
		{"ligheten", "lig"},
		{"lighetens", "lig"},
		{"lighetsfulla", "lighetsfull"},
		{"ligt", "ligt"},
		{"lihsom", "lihsom"},
		{"liit", "liit"},
		{"lik", "lik"},
		{"lika", "lik"},
		{"likadan", "likadan"},
		{"likadana", "likadan"},
		{"likadant", "likadant"},
		{"likadån", "likadån"},
		{"likafullt", "likafull"},
		{"likar", "lik"},
		{"likartade", "likart"},
		{"likartat", "likart"},
		{"likasom", "likasom"},
		{"likaså", "likaså"},
		{"likaval", "likaval"},
		{"likaväl", "likaväl"},
		{"like", "lik"},
		{"liken", "lik"},
		{"liket", "liket"},
		{"likgiltig", "likgilt"},
		{"likgiltiga", "likgilt"},
		{"likgiltigaste", "likgilt"},
		{"likgiltighet", "likgilt"},
		{"likgiltigheten", "likgilt"},
		{"likgiltigt", "likgilt"},
		{"likhet", "lik"},
		{"likheten", "lik"},
		{"liklukt", "likluk"},
		{"likluktande", "likluk"},
		{"likna", "likn"},
		{"liknade", "likn"},
		{"liknande", "likn"},
		{"liknar", "likn"},
		{"liknas", "likn"},
		{"liknelsen", "likn"},
		{"liknöjd", "liknöjd"},
		{"liknöjdhet", "liknöjd"},
		{"likprocessioner", "likprocession"},
		{"liksom", "liksom"},
		{"likså", "likså"},
		{"liksånger", "liksång"},
		{"likt", "likt"},
		{"liktidigt", "liktid"},
		{"liktydig", "liktyd"},
		{"liktydigt", "liktyd"},
		{"likvidera", "likvider"},
		{"likviderade", "likvider"},
		{"likviderande", "likvider"},
		{"likvisst", "likvisst"},
		{"likväl", "likväl"},
		{"likör", "likör"},
		{"lilen", "lil"},
		{"liliamello", "liliamello"},
		{"lilian", "lilian"},
		{"lilja", "lilj"},
		{"liljan", "liljan"},
		{"liljekonvalje", "liljekonvalj"},
		{"liljekonvaljerna", "liljekonvalj"},
		{"liljespön", "liljespön"},
		{"liljevret", "liljevret"},
		{"liljkonvalj", "liljkonvalj"},
		{"liljor", "lilj"},
		{"lill", "lill"},
		{"lilla", "lill"},
		{"lillan", "lillan"},
		{"lille", "lill"},
		{"lilliehöök", "lilliehöök"},
		{"limmeplagg", "limmeplagg"},
		{"lin", "lin"},
		{"lina", "lin"},
		{"linan", "linan"},
		{"lind", "lind"},
		{"lindad", "lind"},
		{"lindade", "lind"},
		{"lindansartruppen", "lindansartrupp"},
		{"lindar", "lind"},
		{"lindarna", "lind"},
		{"lindat", "lind"},
		{"linde", "lind"},
		{"linden", "lind"},
		{"linderots", "linderot"},
		{"lindfelt", "lindfelt"},
		{"lindfelts", "lindfelt"},
		{"lindgren", "lindgr"},
		{"lindgrens", "lindgr"},
		{"lindman", "lindman"},
		{"lindra", "lindr"},
		{"lindrade", "lindr"},
		{"lindrat", "lindr"},
		{"lindrig", "lindr"},
		{"lindriga", "lindr"},
		{"lindrigare", "lindr"},
		{"lindrigast", "lindr"},
		{"lindrigaste", "lindr"},
		{"lindrigt", "lindr"},
		{"lindring", "lindring"},
		{"lindträdet", "lindträdet"},
		{"linet", "linet"},
		{"linets", "linet"},
		{"linfrö", "linfrö"},
		{"lingen", "ling"},
		{"lingon", "lingon"},
		{"lingonris", "lingonris"},
		{"lingonriset", "lingonriset"},
		{"lingult", "lingult"},
		{"linje", "linj"},
		{"linjer", "linj"},
		{"linjerna", "linj"},
		{"linjespel", "linjespel"},
		{"link", "link"},
		{"linkade", "link"},
		{"linne", "linn"},
		{"linnea", "linne"},
		{"linneas", "linne"},
		{"linnel", "linnel"},
		{"linneplagg", "linneplagg"},
		{"linnes", "linn"},
		{"linnet", "linnet"},
		{"linoleummattor", "linoleummat"},
		{"linongsklänningen", "linongsklänning"},
		{"linsädet", "linsädet"},
		{"lintyget", "lintyget"},
		{"lionardos", "lionardo"},
		{"lipa", "lip"},
		{"lipade", "lip"},
		{"liqviden", "liqvid"},
		{"lisa", "lis"},
		{"lisan", "lisan"},
		{"lisas", "lis"},
		{"lisma", "lism"},
		{"lismande", "lism"},
		{"lismar", "lism"},
		{"list", "list"},
		{"listen", "list"},
		{"lister", "list"},
		{"listig", "list"},
		{"listiga", "list"},
		{"listige", "list"},
		{"listigt", "list"},
		{"lit", "lit"},
		{"lita", "lit"},
		{"litanior", "litani"},
		{"litar", "lit"},
		{"litat", "lit"},
		{"litct", "litct"},
		{"lite", "lit"},
		{"litea", "lite"},
		{"liten", "lit"},
		{"litet", "litet"},
		{"litograferad", "litografer"},
		{"littat", "litt"},
		{"litteratur", "litteratur"},
		{"litteraturen", "litteratur"},
		{"litterära", "litterär"},
		{"liua", "liua"},
		{"liudfeldt", "liudfeld"},
		{"liv", "liv"},
		{"livad", "liv"},
		{"livande", "liv"},
		{"livct", "livct"},
		{"livee", "live"},
		{"liver", "liv"},
		{"livet", "livet"},
		{"livets", "livet"},
		{"livförsäkringspremien", "livförsäkringspremi"},
		{"livgardist", "livgardist"},
		{"livkusk", "livkusk"},
		{"livlig", "liv"},
		{"livliga", "liv"},
		{"livligare", "liv"},
		{"livligaste", "liv"},
		{"livlige", "liv"},
		{"livlighet", "liv"},
		{"livligt", "liv"},
		{"livländska", "livländsk"},
		{"livlös", "livlös"},
		{"livmoderns", "livmod"},
		{"livmodersprutor", "livmodersprut"},
		{"livnärt", "livnärt"},
		{"livre", "livr"},
		{"livränta", "livränt"},
		{"livs", "liv"},
		{"livsandar", "livsand"},
		{"livsbejakaren", "livsbejak"},
		{"livsfarligt", "livsfar"},
		{"livsfrukt", "livsfruk"},
		{"livsfröt", "livsfröt"},
		{"livsglädje", "livsglädj"},
		{"livslust", "livslust"},
		{"livstid", "livstid"},
		{"livstiden", "livstid"},
		{"livstycke", "livstyck"},
		{"livstycken", "livstyck"},
		{"livstyckets", "livstycket"},
		{"livsuppgift", "livsuppgift"},
		{"livsåskådning", "livsåskådning"},
		{"livsöde", "livsöd"},
		{"ljettför", "ljettför"},
		{"ljnset", "ljnset"},
		{"lju", "lju"},
		{"ljud", "ljud"},
		{"ljuda", "ljud"},
		{"ljudande", "ljud"},
		{"ljuder", "ljud"},
		{"ljudet", "ljudet"},
		{"ljudit", "ljudit"},
		{"ljudlig", "ljud"},
		{"ljudliga", "ljud"},
		{"ljudlöst", "ljudlös"},
		{"ljuf", "ljuf"},
		{"ljuflig", "ljuf"},
		{"ljufligt", "ljuf"},
		{"ljuft", "ljuft"},
		{"ljufva", "ljufv"},
		{"ljufvare", "ljufv"},
		{"ljufvast", "ljufv"},
		{"ljufvaste", "ljufv"},
		{"ljuga", "ljug"},
		{"ljuger", "ljug"},
		{"ljugit", "ljugit"},
		{"ljum", "ljum"},
		{"ljumhet", "ljum"},
		{"ljumma", "ljumm"},
		{"ljumt", "ljumt"},
		{"ljung", "ljung"},
		{"ljungade", "ljung"},
		{"ljungande", "ljung"},
		{"ljungkvist", "ljungkvist"},
		{"ljus", "ljus"},
		{"ljusa", "ljus"},
		{"ljusare", "ljus"},
		{"ljusastaken", "ljusastak"},
		{"ljusaste", "ljus"},
		{"ljusbiten", "ljusbit"},
		{"ljusblå", "ljusblå"},
		{"ljusblått", "ljusblåt"},
		{"ljusbrun", "ljusbrun"},
		{"ljusen", "ljus"},
		{"ljusens", "ljus"},
		{"ljuset", "ljuset"},
		{"ljusets", "ljuset"},
		{"ljusfläckar", "ljusfläck"},
		{"ljusfläckarna", "ljusfläck"},
		{"ljusgrå", "ljusgrå"},
		{"ljusgrön", "ljusgrön"},
		{"ljusgul", "ljusgul"},
		{"ljushav", "ljushav"},
		{"ljushåriga", "ljushår"},
		{"ljusknekt", "ljusknek"},
		{"ljuskretsen", "ljuskrets"},
		{"ljuslett", "ljuslet"},
		{"ljuslågan", "ljuslågan"},
		{"ljusmelodi", "ljusmelodi"},
		{"ljusna", "ljusn"},
		{"ljusnade", "ljusn"},
		{"ljusnande", "ljusn"},
		{"ljusnar", "ljusn"},
		{"ljusning", "ljusning"},
		{"ljusrandig", "ljusrand"},
		{"ljusringar", "ljusring"},
		{"ljussken", "ljussk"},
		{"ljusskenet", "ljusskenet"},
		{"ljusskyltar", "ljusskylt"},
		{"ljusskymt", "ljusskymt"},
		{"ljusstakar", "ljusstak"},
		{"ljusstrimma", "ljusstrimm"},
		{"ljusstöperskan", "ljusstöperskan"},
		{"ljust", "ljust"},
		{"ljuv", "ljuv"},
		{"ljuva", "ljuv"},
		{"ljuvaste", "ljuv"},
		{"ljuvlig", "ljuv"},
		{"ljuvliga", "ljuv"},
		{"ljuvligaste", "ljuv"},
		{"ljuvligt", "ljuv"},
		{"ljuvt", "ljuvt"},
		{"ljöd", "ljöd"},
		{"ljödo", "ljödo"},
		{"lkar", "lkar"},
		{"ll", "ll"},
		{"lla", "lla"},
		{"llans", "llan"},
		{"ller", "ller"},
		{"lletty", "lletty"},
		{"llng", "llng"},
		{"llolmström", "llolmström"},
		{"llon", "llon"},
		{"lls", "lls"},
		{"llsa", "llsa"},
		{"llu", "llu"},
		{"llöll", "llöll"},
		{"lmg", "lmg"},
		{"lnte", "lnte"},
		{"loade", "load"},
		{"locka", "lock"},
		{"lockade", "lock"},
		{"lockades", "lock"},
		{"lockan", "lockan"},
		{"lockande", "lock"},
		{"lockar", "lock"},
		{"lockarna", "lock"},
		{"lockat", "lock"},
		{"lockbete", "lockbet"},
		{"lockbetet", "lockbetet"},
		{"lockelser", "lock"},
		{"locket", "locket"},
		{"lockiga", "lock"},
		{"lockigt", "lock"},
		{"lodbössa", "lodböss"},
		{"loe", "loe"},
		{"lof", "lof"},
		{"loflig", "lof"},
		{"lofliga", "lof"},
		{"lofligheten", "lof"},
		{"lofligt", "lof"},
		{"loft", "loft"},
		{"loftet", "loftet"},
		{"lofva", "lofv"},
		{"lofvade", "lofv"},
		{"lofvar", "lofv"},
		{"lofvat", "lofv"},
		{"log", "log"},
		{"loge", "log"},
		{"logen", "log"},
		{"logeraden", "logerad"},
		{"loggboken", "loggbok"},
		{"logik", "logik"},
		{"logis", "logis"},
		{"logiska", "logisk"},
		{"logiskt", "logisk"},
		{"logo", "logo"},
		{"lohengrin", "lohengrin"},
		{"loja", "loj"},
		{"lojtnant", "lojtnant"},
		{"lojtnantsfru", "lojtnantsfru"},
		{"lokal", "lokal"},
		{"lokalen", "lokal"},
		{"lokomotivet", "lokomotivet"},
		{"lombardbrucke", "lombardbruck"},
		{"lon", "lon"},
		{"lopp", "lopp"},
		{"loppet", "loppet"},
		{"lorens", "lor"},
		{"lorette", "loret"},
		{"lorgnetten", "lorgnet"},
		{"lorgnetterande", "lorgnetter"},
		{"lorgnettkedja", "lorgnettkedj"},
		{"lorraine", "lorrain"},
		{"los", "los"},
		{"loss", "loss"},
		{"lossade", "loss"},
		{"lossades", "loss"},
		{"lossnade", "lossn"},
		{"lossnat", "lossn"},
		{"lossning", "lossning"},
		{"lost", "lost"},
		{"lott", "lott"},
		{"lottade", "lott"},
		{"lotten", "lott"},
		{"lotter", "lott"},
		{"lotteri", "lotteri"},
		{"lotteripäls", "lotteripäl"},
		{"lotterna", "lott"},
		{"louise", "louis"},
		{"lov", "lov"},
		{"lova", "lov"},
		{"lovade", "lov"},
		{"lovande", "lov"},
		{"lovar", "lov"},
		{"lovat", "lov"},
		{"loven", "lov"},
		{"lovera", "lover"},
		{"loverar", "lover"},
		{"loverat", "lover"},
		{"lovliga", "lov"},
		{"lovligt", "lov"},
		{"lovning", "lovning"},
		{"lovprisade", "lovpris"},
		{"lovsång", "lovsång"},
		{"lovsånger", "lovsång"},
		{"lowärda", "lowärd"},
		{"loz", "loz"},
		{"lr", "lr"},
		{"lsamt", "lsamt"},
		{"lsen", "lsen"},
		{"lstad", "lstad"},
		{"lt", "lt"},
		{"ltj", "ltj"},
		{"lucidor", "lucid"},
		{"lucie", "luci"},
		{"lucies", "luci"},
		{"lucka", "luck"},
		{"luckan", "luckan"},
		{"luckorna", "luck"},
		{"luden", "lud"},
		{"ludna", "ludn"},
		{"luffare", "luff"},
		{"lufsandc", "lufsandc"},
		{"luft", "luft"},
		{"luftdraget", "luftdraget"},
		{"luften", "luft"},
		{"luftens", "luft"},
		{"luftig", "luft"},
		{"luftiga", "luft"},
		{"luftigaste", "luft"},
		{"luftslott", "luftslot"},
		{"luftström", "luftström"},
		{"lugg", "lugg"},
		{"luggslitenhet", "luggsliten"},
		{"luggslitna", "luggslitn"},
		{"lugn", "lugn"},
		{"lugna", "lugn"},
		{"lugnad", "lugn"},
		{"lugnade", "lugn"},
		{"lugnande", "lugn"},
		{"lugnar", "lugn"},
		{"lugnare", "lugn"},
		{"lugnaste", "lugn"},
		{"lugnat", "lugn"},
		{"lugnet", "lugnet"},
		{"lugnt", "lugnt"},
		{"lukt", "lukt"},
		{"lukta", "lukt"},
		{"luktade", "lukt"},
		{"luktar", "lukt"},
		{"lukten", "lukt"},
		{"luktärter", "luktärt"},
		{"lullade", "lull"},
		{"lummiga", "lumm"},
		{"lummigt", "lumm"},
		{"lump", "lump"},
		{"lumpen", "lump"},
		{"lumpet", "lumpet"},
		{"lumpne", "lumpn"},
		{"lumpsamlare", "lumpsaml"},
		{"luna", "lun"},
		{"lunch", "lunch"},
		{"lunchbordet", "lunchbordet"},
		{"lunchen", "lunch"},
		{"lund", "lund"},
		{"lundar", "lund"},
		{"lundarnas", "lund"},
		{"lunetter", "lunet"},
		{"lunginflamma", "lunginflamm"},
		{"lungor", "lung"},
		{"lungorna", "lung"},
		{"lunkade", "lunk"},
		{"lunkentus", "lunkentus"},
		{"luntan", "luntan"},
		{"luntor", "lunt"},
		{"lur", "lur"},
		{"lura", "lur"},
		{"lurad", "lur"},
		{"lurade", "lur"},
		{"lurande", "lur"},
		{"lurar", "lur"},
		{"lurat", "lur"},
		{"luren", "lur"},
		{"lurendrejarn", "lurendrejarn"},
		{"lurendrejarne", "lurendrej"},
		{"lurendrejarnes", "lurendrejarn"},
		{"lurendrejas", "lurendrej"},
		{"lurendrejeri", "lurendrejeri"},
		{"lurendrejeribeslag", "lurendrejeribeslag"},
		{"lurendrejerierna", "lurendrejeri"},
		{"lurendrejeriet", "lurendrejeriet"},
		{"lurfviga", "lurfv"},
		{"luri", "luri"},
		{"lurviga", "lurv"},
		{"luschi", "luschi"},
		{"luschie", "luschi"},
		{"lusen", "lus"},
		{"luska", "lusk"},
		{"lust", "lust"},
		{"lustar", "lust"},
		{"lusteld", "lusteld"},
		{"lusten", "lust"},
		{"lustfyllda", "lustfylld"},
		{"lustfärd", "lustfärd"},
		{"lustfärder", "lustfärd"},
		{"lustgård", "lustgård"},
		{"lustgården", "lustgård"},
		{"lustig", "lust"},
		{"lustiga", "lust"},
		{"lustigaste", "lust"},
		{"lustigt", "lust"},
		{"lustturen", "lusttur"},
		{"lusttåg", "lusttåg"},
		{"lustvandra", "lustvandr"},
		{"lut", "lut"},
		{"luta", "lut"},
		{"lutad", "lut"},
		{"lutade", "lut"},
		{"lutande", "lut"},
		{"lutans", "lutan"},
		{"lutar", "lut"},
		{"lutat", "lut"},
		{"luteransk", "luteransk"},
		{"luther", "luth"},
		{"luthers", "luther"},
		{"luven", "luv"},
		{"lvcka", "lvcka"},
		{"lycka", "lyck"},
		{"lyckades", "lyck"},
		{"lyckadt", "lyckad"},
		{"lyckan", "lyckan"},
		{"lyckans", "lyckan"},
		{"lyckas", "lyck"},
		{"lyckats", "lyckat"},
		{"lycklig", "lyck"},
		{"lyckliga", "lyck"},
		{"lyckligare", "lyck"},
		{"lyckligast", "lyck"},
		{"lyckligaste", "lyck"},
		{"lycklige", "lyck"},
		{"lyckliggöra", "lyckliggör"},
		{"lyckligheten", "lyck"},
		{"lyckligt", "lyck"},
		{"lyckligtvis", "lyckligtvis"},
		{"lyckodagar", "lyckodag"},
		{"lyckodränkta", "lyckodränk"},
		{"lyckodröm", "lyckodröm"},
		{"lyckokänsla", "lyckokänsl"},
		{"lyckopannkakan", "lyckopannkakan"},
		{"lyckoropen", "lyckorop"},
		{"lycksalig", "lycksa"},
		{"lycksaliga", "lycksa"},
		{"lycksalige", "lycksa"},
		{"lycksalighet", "lycksa"},
		{"lycksalighetens", "lycksa"},
		{"lycksälla", "lycksäll"},
		{"lyckt", "lyck"},
		{"lyckönska", "lyckönsk"},
		{"lyckönskar", "lyckönsk"},
		{"lyckönskningar", "lyckönskning"},
		{"lyckönskningarna", "lyckönskning"},
		{"lyckönskningstal", "lyckönskningstal"},
		{"lyda", "lyd"},
		{"lydde", "lydd"},
		{"lyder", "lyd"},
		{"lydig", "lyd"},
		{"lydiga", "lyd"},
		{"lydigt", "lyd"},
		{"lydnad", "lydn"},
		{"lyeker", "lyek"},
		{"lyft", "lyft"},
		{"lyfta", "lyft"},
		{"lyftad", "lyft"},
		{"lyftade", "lyft"},
		{"lyftades", "lyft"},
		{"lyftande", "lyft"},
		{"lyftas", "lyft"},
		{"lyfte", "lyft"},
		{"lyften", "lyft"},
		{"lyfter", "lyft"},
		{"lyftes", "lyft"},
		{"lyholmarne", "lyholm"},
		{"lykta", "lykt"},
		{"lyktan", "lyktan"},
		{"lyktar", "lykt"},
		{"lyktor", "lykt"},
		{"lyktorna", "lykt"},
		{"lyktornas", "lykt"},
		{"lyktstolpe", "lyktstolp"},
		{"lyktstolpen", "lyktstolp"},
		{"lykttändare", "lykttänd"},
		{"lykttändaren", "lykttänd"},
		{"lymmel", "lymmel"},
		{"lymmeln", "lymmeln"},
		{"lyngden", "lyng"},
		{"lynne", "lynn"},
		{"lynnen", "lynn"},
		{"lynnet", "lynnet"},
		{"lyra", "lyr"},
		{"lys", "lys"},
		{"lysa", "lys"},
		{"lysande", "lys"},
		{"lysas", "lys"},
		{"lyser", "lys"},
		{"lysning", "lysning"},
		{"lyss", "lyss"},
		{"lyssna", "lyssn"},
		{"lyssnade", "lyssn"},
		{"lyssnande", "lyssn"},
		{"lyssnar", "lyssn"},
		{"lyssnat", "lyssn"},
		{"lyssnen", "lyssn"},
		{"lyst", "lyst"},
		{"lyste", "lyst"},
		{"lysten", "lyst"},
		{"lyster", "lyst"},
		{"lysterklänning", "lysterklänning"},
		{"lystes", "lyst"},
		{"lystna", "lystn"},
		{"lystnad", "lystn"},
		{"lystrade", "lystr"},
		{"lyte", "lyt"},
		{"lytt", "lytt"},
		{"lytton", "lytton"},
		{"lyx", "lyx"},
		{"lyxartikel", "lyxartikel"},
		{"lyxsaker", "lyxsak"},
		{"lä", "lä"},
		{"läcker", "läck"},
		{"läckerhet", "läcker"},
		{"läckerheter", "läcker"},
		{"läckerheterna", "läcker"},
		{"läckra", "läckr"},
		{"läder", "läd"},
		{"läderband", "läderband"},
		{"läderdynan", "läderdynan"},
		{"läderfabrikör", "läderfabrikör"},
		{"läderlappar", "läderlapp"},
		{"läderläpparna", "läderläpp"},
		{"läderpermar", "läderperm"},
		{"läffsor", "läffs"},
		{"läge", "läg"},
		{"lägenhet", "lägen"},
		{"lägenheten", "lägen"},
		{"läger", "läg"},
		{"lägerelden", "lägereld"},
		{"läget", "läget"},
		{"lägg", "lägg"},
		{"lägga", "lägg"},
		{"läggande", "lägg"},
		{"läggen", "lägg"},
		{"lägger", "lägg"},
		{"lägges", "lägg"},
		{"läggspelet", "läggspelet"},
		{"läglig", "läg"},
		{"lägligt", "läg"},
		{"lägrade", "lägr"},
		{"lägrat", "lägr"},
		{"lägre", "lägr"},
		{"lägret", "lägret"},
		{"lägsen", "lägs"},
		{"lägsna", "lägsn"},
		{"lägsta", "lägst"},
		{"läkarblick", "läkarblick"},
		{"läkare", "läk"},
		{"läkared", "läkared"},
		{"läkaren", "läk"},
		{"läkarens", "läk"},
		{"läkarföreningen", "läkarförening"},
		{"läkarna", "läk"},
		{"läkarpjosk", "läkarpjosk"},
		{"läkarsällskapet", "läkarsällskapet"},
		{"läkarsällskapets", "läkarsällskapet"},
		{"läkas", "läk"},
		{"läkedom", "läkedom"},
		{"läkemedel", "läkemedel"},
		{"läker", "läk"},
		{"läkts", "läkt"},
		{"lämna", "lämn"},
		{"lämnad", "lämn"},
		{"lämnade", "lämn"},
		{"lämnades", "lämn"},
		{"lämnande", "lämn"},
		{"lämnar", "lämn"},
		{"lämnas", "lämn"},
		{"lämnat", "lämn"},
		{"lämnats", "lämnat"},
		{"lämningarna", "lämning"},
		{"lämpa", "lämp"},
		{"lämpar", "lämp"},
		{"lämpas", "lämp"},
		{"lämplig", "lämp"},
		{"lämpliga", "lämp"},
		{"lämpligare", "lämp"},
		{"lämpligen", "lämp"},
		{"lämpligt", "lämp"},
		{"lämpor", "lämp"},
		{"länd", "länd"},
		{"länder", "länd"},
		{"ländska", "ländsk"},
		{"läng", "läng"},
		{"längc", "längc"},
		{"längd", "läng"},
		{"längden", "läng"},
		{"länge", "läng"},
		{"längesedan", "längesedan"},
		{"längesen", "länges"},
		{"längre", "längr"},
		{"längs", "läng"},
		{"längst", "längst"},
		{"längsta", "längst"},
		{"längta", "läng"},
		{"längtade", "läng"},
		{"längtan", "längtan"},
		{"längtande", "läng"},
		{"längtans", "längtan"},
		{"längtansfull", "längtansfull"},
		{"längtansfullt", "längtansfull"},
		{"längtar", "läng"},
		{"längtat", "läng"},
		{"länk", "länk"},
		{"länstol", "länstol"},
		{"länstolen", "länstol"},
		{"läpp", "läpp"},
		{"läppar", "läpp"},
		{"läpparna", "läpp"},
		{"läpparne", "läpp"},
		{"läppen", "läpp"},
		{"läppens", "läpp"},
		{"läppja", "läppj"},
		{"läppjade", "läppj"},
		{"läppjar", "läppj"},
		{"lär", "lär"},
		{"lära", "lär"},
		{"läraktig", "lärakt"},
		{"läran", "läran"},
		{"lärare", "lär"},
		{"lärarebefattning", "lärarebefattning"},
		{"läraren", "lär"},
		{"lärarens", "lär"},
		{"lärares", "lärar"},
		{"lärarevärdighet", "lärarevärd"},
		{"lärarin", "lärarin"},
		{"lärarinna", "lärarin"},
		{"lärarinnan", "lärarinnan"},
		{"lärarinnans", "lärarinnan"},
		{"lärarinnegärning", "lärarinnegärning"},
		{"lärarinnesemina", "lärarinnesemin"},
		{"lärd", "lärd"},
		{"lärda", "lärd"},
		{"lärde", "lärd"},
		{"lärdom", "lärdom"},
		{"lärdomar", "lärdom"},
		{"lärer", "lär"},
		{"lärft", "lärft"},
		{"lärftskramhandlare", "lärftskramhandl"},
		{"lärftskramhandlaren", "lärftskramhandl"},
		{"lärftskramhandlarens", "lärftskramhandl"},
		{"lärgossen", "lärgoss"},
		{"lärjungar", "lärjung"},
		{"lärjunge", "lärjung"},
		{"lärka", "lärk"},
		{"lärkor", "lärk"},
		{"lärkstaden", "lärkstad"},
		{"lärkvingar", "lärkving"},
		{"lärnna", "lärn"},
		{"läroanstalterna", "läroanstalt"},
		{"lärofader", "lärofad"},
		{"läror", "lär"},
		{"lärorummet", "lärorummet"},
		{"lärostriderna", "lärostrid"},
		{"läroverk", "läroverk"},
		{"läroverksadjunkten", "läroverksadjunk"},
		{"lärt", "lärt"},
		{"lärvtskramhandlarns", "lärvtskramhandlarn"},
		{"läs", "läs"},
		{"läsa", "läs"},
		{"läsaren", "läs"},
		{"läsarens", "läs"},
		{"läsas", "läs"},
		{"läser", "läs"},
		{"läses", "läs"},
		{"läsida", "läsid"},
		{"läskar", "läsk"},
		{"läsning", "läsning"},
		{"läsningen", "läsning"},
		{"läspa", "läsp"},
		{"läspade", "läsp"},
		{"läst", "läst"},
		{"läste", "läst"},
		{"lästes", "läst"},
		{"lät", "lät"},
		{"lätande", "lät"},
		{"läte", "lät"},
		{"läten", "lät"},
		{"läto", "läto"},
		{"lätt", "lätt"},
		{"lätta", "lätt"},
		{"lättad", "lätt"},
		{"lättade", "lätt"},
		{"lättadt", "lättad"},
		{"lättare", "lätt"},
		{"lättast", "lätt"},
		{"lättaste", "lätt"},
		{"lättat", "lätt"},
		{"lättböjliga", "lättböj"},
		{"lätteligen", "lätte"},
		{"lättfattligt", "lättfatt"},
		{"lätthet", "lätt"},
		{"lätthänt", "lätthänt"},
		{"lättingen", "lätting"},
		{"lättjefull", "lättjefull"},
		{"lättnad", "lättn"},
		{"lättretliga", "lättret"},
		{"lättrörd", "lättrörd"},
		{"lättsinne", "lättsin"},
		{"lättsinnig", "lättsinn"},
		{"lättsinniga", "lättsinn"},
		{"lättsinnighet", "lättsinn"},
		{"lättsinnigheter", "lättsinn"},
		{"lättsinnigt", "lättsinn"},
		{"lättvindig", "lättvind"},
		{"läxa", "läx"},
		{"läxläsningen", "läxläsning"},
		{"läxorna", "läx"},
		{"låda", "låd"},
		{"lådan", "lådan"},
		{"låding", "låding"},
		{"lådingsfriska", "lådingsfrisk"},
		{"låg", "låg"},
		{"låga", "låg"},
		{"lågade", "låg"},
		{"lågan", "lågan"},
		{"lågande", "låg"},
		{"låge", "låg"},
		{"låghet", "låg"},
		{"lågklackad", "lågklack"},
		{"lågklackade", "lågklack"},
		{"lågo", "lågo"},
		{"lågor", "låg"},
		{"lågorna", "låg"},
		{"lågskon", "lågskon"},
		{"lågt", "lågt"},
		{"lån", "lån"},
		{"låna", "lån"},
		{"lånade", "lån"},
		{"lånar", "lån"},
		{"lånat", "lån"},
		{"lånet", "lånet"},
		{"lång", "lång"},
		{"långa", "lång"},
		{"långan", "långan"},
		{"långbyxor", "långbyx"},
		{"långdraget", "långdraget"},
		{"långfingret", "långfingret"},
		{"långhalsdukar", "långhalsduk"},
		{"långholmen", "långholm"},
		{"långlig", "lång"},
		{"långlåt", "långlåt"},
		{"långor", "lång"},
		{"långrandiga", "långrand"},
		{"långrandigt", "långrand"},
		{"långresa", "långres"},
		{"långrock", "långrock"},
		{"långs", "lång"},
		{"långsam", "långsam"},
		{"långsamheten", "långsam"},
		{"långsamma", "långsamm"},
		{"långsamt", "långsamt"},
		{"långsannt", "långsannt"},
		{"långsides", "långsid"},
		{"långsint", "långsint"},
		{"långt", "lång"},
		{"långtifrån", "långtifrån"},
		{"långtmindre", "långtmindr"},
		{"långvarig", "långvar"},
		{"långvarigt", "långvar"},
		{"långväga", "långväg"},
		{"långväggen", "långvägg"},
		{"låntagaren", "låntag"},
		{"lår", "lår"},
		{"lås", "lås"},
		{"låsa", "lås"},
		{"låset", "låset"},
		{"låsets", "låset"},
		{"låst", "låst"},
		{"låste", "låst"},
		{"låt", "låt"},
		{"låta", "låt"},
		{"låtande", "låt"},
		{"låte", "låt"},
		{"låtelse", "låt"},
		{"låter", "låt"},
		{"låtit", "låtit"},
		{"låtsa", "låts"},
		{"låtsad", "låts"},
		{"låtsade", "låts"},
		{"låtsades", "låts"},
		{"låtsande", "låts"},
		{"låtsar", "låts"},
		{"låtsas", "låts"},
		{"låtsat", "låts"},
		{"låtsats", "låtsat"},
		{"låäng", "låäng"},
		{"löda", "löd"},
		{"löddret", "löddret"},
		{"löfte", "löft"},
		{"löften", "löft"},
		{"löftet", "löftet"},
		{"löftets", "löftet"},
		{"lögn", "lögn"},
		{"lögnen", "lögn"},
		{"lögnens", "lögn"},
		{"lögner", "lögn"},
		{"lögnhals", "lögnhal"},
		{"löj", "löj"},
		{"löje", "löj"},
		{"löjeblandade", "löjebland"},
		{"löjen", "löj"},
		{"löjet", "löjet"},
		{"löjlig", "löj"},
		{"löjliga", "löj"},
		{"löjligaste", "löj"},
		{"löjliget", "löjliget"},
		{"löjlighet", "löj"},
		{"löjligheter", "löj"},
		{"löjligt", "löj"},
		{"löjtnant", "löjtnant"},
		{"löjtnanten", "löjtnant"},
		{"löjtnantens", "löjtnant"},
		{"löjtnantets", "löjtnantet"},
		{"löjtnantskotteri", "löjtnantskotteri"},
		{"lök", "lök"},
		{"löken", "lök"},
		{"lökskivor", "lökskiv"},
		{"lömska", "lömsk"},
		{"lömskt", "lömsk"},
		{"lön", "lön"},
		{"löna", "lön"},
		{"lönade", "lön"},
		{"lönar", "lön"},
		{"lönen", "lön"},
		{"lönn", "lönn"},
		{"lönnarna", "lönn"},
		{"lönnars", "lönnar"},
		{"lönnblad", "lönnbl"},
		{"lönndom", "lönndom"},
		{"lönnligaste", "lönn"},
		{"lönnlåda", "lönnlåd"},
		{"lönnlådan", "lönnlådan"},
		{"lönte", "lönt"},
		{"löpa", "löp"},
		{"löparen", "löp"},
		{"löpeldsgirland", "löpeldsgirland"},
		{"löper", "löp"},
		{"löpt", "löpt"},
		{"löpte", "löpt"},
		{"lördag", "lördag"},
		{"lördagen", "lördag"},
		{"lördagsafton", "lördagsafton"},
		{"lördagsaftonens", "lördagsafton"},
		{"lördagsaftonstonfall", "lördagsaftonstonfall"},
		{"lördagskväll", "lördagskväll"},
		{"lördagskvällarna", "lördagskväll"},
		{"lös", "lös"},
		{"lösa", "lös"},
		{"lösaktiga", "lösakt"},
		{"lösas", "lös"},
		{"lösegendom", "lösegendom"},
		{"lösen", "lös"},
		{"lösens", "lös"},
		{"lösensord", "lösensord"},
		{"löser", "lös"},
		{"lösgjorde", "lösgjord"},
		{"lösning", "lösning"},
		{"lösningar", "lösning"},
		{"lösningen", "lösning"},
		{"lösrycka", "lösryck"},
		{"lösryckt", "lösryck"},
		{"lösryckta", "lösryck"},
		{"löst", "löst"},
		{"löste", "löst"},
		{"lösöreboet", "lösöreboet"},
		{"lötsligt", "löts"},
		{"löv", "löv"},
		{"lövat", "löv"},
		{"lövdungen", "lövdung"},
		{"löven", "löv"},
		{"lövens", "löv"},
		{"lövmassor", "lövmass"},
		{"lövruskor", "lövrusk"},
		{"lövskog", "lövskog"},
		{"lövskogen", "lövskog"},
		{"lövsprångsdova", "lövsprångsdov"},
		{"lövverk", "lövverk"},
		{"lövverket", "lövverket"},
		{"löwenström", "löwenström"},
		{"löwenströms", "löwenström"},
		{"m", "m"},
		{"ma", "ma"},
		{"mac", "mac"},
		{"macson", "macson"},
		{"madame", "madam"},
		{"madamens", "madam"},
		{"madamerna", "madam"},
		{"madde", "madd"},
		{"madeirabuteljen", "madeirabutelj"},
		{"madeleine", "madelein"},
		{"madeleines", "madelein"},
		{"mademoiselle", "mademoisell"},
		{"maderia", "maderi"},
		{"madonna", "madon"},
		{"madonnaliljan", "madonnaliljan"},
		{"madonnan", "madonnan"},
		{"madonnor", "madon"},
		{"madras", "madr"},
		{"magar", "mag"},
		{"magasin", "magasin"},
		{"magasinet", "magasinet"},
		{"magda", "magd"},
		{"magdalena", "magdalen"},
		{"magdas", "magd"},
		{"mage", "mag"},
		{"magen", "mag"},
		{"mager", "mag"},
		{"magert", "magert"},
		{"magister", "magist"},
		{"magistern", "magist"},
		{"magisterns", "magist"},
		{"magnet", "magnet"},
		{"magnetisktinfernaliskt", "magnetisktinfernalisk"},
		{"magnifika", "magnifik"},
		{"magnifikt", "magnifik"},
		{"magra", "magr"},
		{"magrare", "magr"},
		{"magrat", "magr"},
		{"magt", "magt"},
		{"magten", "magt"},
		{"magtpåliggande", "magtpåligg"},
		{"mahogny", "mahogny"},
		{"mahognysekretären", "mahognysekretär"},
		{"mahognyspelbordet", "mahognyspelbordet"},
		{"mahognystolar", "mahognystol"},
		{"mahända", "mahänd"},
		{"maintenon", "maintenon"},
		{"maj", "maj"},
		{"majestät", "majestät"},
		{"majestätet", "majestätet"},
		{"majestäts", "majestät"},
		{"majrock", "majrock"},
		{"majsen", "majs"},
		{"majstänger", "majstäng"},
		{"majstången", "majstång"},
		{"mak", "mak"},
		{"maka", "mak"},
		{"makade", "mak"},
		{"makan", "makan"},
		{"makarna", "mak"},
		{"makas", "mak"},
		{"make", "mak"},
		{"maken", "mak"},
		{"makens", "mak"},
		{"makes", "mak"},
		{"makligt", "mak"},
		{"makt", "makt"},
		{"maktar", "makt"},
		{"makten", "makt"},
		{"makter", "makt"},
		{"maktlös", "maktlös"},
		{"maktlösa", "maktlös"},
		{"maktlöshet", "maktlös"},
		{"maktpålig", "maktpå"},
		{"maktpåliggande", "maktpåligg"},
		{"mal", "mal"},
		{"mala", "mal"},
		{"malat", "mal"},
		{"malda", "mald"},
		{"malde", "mald"},
		{"malen", "mal"},
		{"malena", "malen"},
		{"malla", "mall"},
		{"mallas", "mall"},
		{"malm", "malm"},
		{"malms", "malm"},
		{"malmskillnadsgatan", "malmskillnadsgatan"},
		{"malmtorgsgatan", "malmtorgsgatan"},
		{"maläten", "malät"},
		{"malätet", "malätet"},
		{"mamma", "mamm"},
		{"mammas", "mamm"},
		{"mammor", "mamm"},
		{"mamsell", "mamsell"},
		{"mamsellerna", "mamsell"},
		{"mamsells", "mamsell"},
		{"mamsen", "mams"},
		{"man", "man"},
		{"manade", "man"},
		{"manader", "manad"},
		{"manande", "man"},
		{"manat", "man"},
		{"mandarin", "mandarin"},
		{"mande", "mand"},
		{"mandelblommor", "mandelblomm"},
		{"manderskiöld", "manderskiöld"},
		{"manderström", "manderström"},
		{"maner", "man"},
		{"maneret", "maneret"},
		{"manga", "mang"},
		{"mangfaldiga", "mangfald"},
		{"manhaftigt", "manhaft"},
		{"maningsord", "maningsord"},
		{"manlig", "man"},
		{"manliga", "man"},
		{"manligt", "man"},
		{"mannaålder", "mannaåld"},
		{"mannaålderns", "mannaåld"},
		{"mannaåren", "mannaår"},
		{"mannen", "mann"},
		{"mannens", "mann"},
		{"manniska", "mannisk"},
		{"manniskorna", "mannisk"},
		{"mans", "man"},
		{"manschetter", "manschet"},
		{"manshög", "manshög"},
		{"manskor", "mansk"},
		{"mansperson", "mansperson"},
		{"manssidan", "manssidan"},
		{"mantel", "mantel"},
		{"mantlar", "mantl"},
		{"manuskriptet", "manuskriptet"},
		{"manzanilla", "manzanill"},
		{"manöver", "manöv"},
		{"manövrerade", "manövrer"},
		{"mar", "mar"},
		{"mara", "mar"},
		{"maran", "maran"},
		{"mardröm", "mardröm"},
		{"maren", "mar"},
		{"margit", "margit"},
		{"margits", "margit"},
		{"margot", "margot"},
		{"maria", "mari"},
		{"marias", "mari"},
		{"marie", "mari"},
		{"mariebo", "mariebo"},
		{"mariestad", "mariest"},
		{"mariga", "mar"},
		{"mark", "mark"},
		{"markeh", "markeh"},
		{"markel", "markel"},
		{"markels", "markel"},
		{"marken", "mark"},
		{"markena", "marken"},
		{"markens", "mark"},
		{"markerade", "marker"},
		{"markerat", "marker"},
		{"markerna", "mark"},
		{"markligare", "mark"},
		{"marknad", "markn"},
		{"marknaden", "marknad"},
		{"marknadsvimlet", "marknadsvimlet"},
		{"markvärdigt", "markvärd"},
		{"marmor", "marm"},
		{"marmorbordet", "marmorbordet"},
		{"marmorerade", "marmorer"},
		{"marmorn", "marmorn"},
		{"marmorvit", "marmorvit"},
		{"marna", "marn"},
		{"marocko", "marocko"},
		{"marscbtakt", "marscbtak"},
		{"marsch", "marsch"},
		{"marschen", "marsch"},
		{"marskalk", "marskalk"},
		{"marstrand", "marstrand"},
		{"marstrandsfärden", "marstrandsfärd"},
		{"marstrandsresan", "marstrandsresan"},
		{"marsvind", "marsvind"},
		{"marterade", "marter"},
		{"martin", "martin"},
		{"martyr", "martyr"},
		{"mas", "mas"},
		{"masar", "mas"},
		{"mask", "mask"},
		{"masken", "mask"},
		{"masker", "mask"},
		{"maskerad", "masker"},
		{"maskerader", "maskerad"},
		{"maskeras", "masker"},
		{"maskers", "masker"},
		{"maskiner", "maskin"},
		{"maskineriet", "maskineriet"},
		{"maskinerna", "maskin"},
		{"maskor", "mask"},
		{"mass", "mass"},
		{"massa", "mass"},
		{"massage", "massag"},
		{"masserade", "masser"},
		{"massiva", "massiv"},
		{"massor", "mass"},
		{"massorna", "mass"},
		{"mast", "mast"},
		{"maste", "mast"},
		{"masten", "mast"},
		{"master", "mast"},
		{"masterna", "mast"},
		{"mastodonter", "mastodont"},
		{"masurbjörk", "masurbjörk"},
		{"mat", "mat"},
		{"matar", "mat"},
		{"matbit", "matbit"},
		{"matbordet", "matbordet"},
		{"matdagar", "matdag"},
		{"matdagarna", "matdag"},
		{"matdags", "matdag"},
		{"matematiker", "matematik"},
		{"matematikerns", "matematik"},
		{"matematikläraren", "matematiklär"},
		{"matematiktimmarna", "matematiktimm"},
		{"maten", "mat"},
		{"material", "material"},
		{"materiella", "materiell"},
		{"matfebern", "matfeb"},
		{"matfriske", "matfrisk"},
		{"mathämtaren", "mathämt"},
		{"matilda", "matild"},
		{"matildas", "matild"},
		{"matkorgar", "matkorg"},
		{"matlagning", "matlagning"},
		{"matlust", "matlust"},
		{"matmodern", "matmod"},
		{"matmor", "matm"},
		{"matmors", "matmor"},
		{"matmödrars", "matmödrar"},
		{"matos", "mato"},
		{"matoset", "matoset"},
		{"matrona", "matron"},
		{"matronan", "matronan"},
		{"matronor", "matron"},
		{"matros", "matro"},
		{"matroser", "matros"},
		{"mats", "mat"},
		{"matsal", "matsal"},
		{"matsaled", "matsaled"},
		{"matsalen", "matsal"},
		{"matsalskypare", "matsalskyp"},
		{"matsedeln", "matsedeln"},
		{"matsmältningsprocessen", "matsmältningsprocess"},
		{"matsäck", "matsäck"},
		{"matsäcken", "matsäck"},
		{"matt", "matt"},
		{"matta", "matt"},
		{"mattad", "matt"},
		{"mattan", "mattan"},
		{"mattare", "matt"},
		{"mattas", "matt"},
		{"matte", "matt"},
		{"mattfullt", "mattfull"},
		{"mattighet", "matt"},
		{"mattimmen", "mattimm"},
		{"mattinan", "mattinan"},
		{"matvaror", "matvar"},
		{"maupassants", "maupassant"},
		{"mcd", "mcd"},
		{"mcdan", "mcdan"},
		{"mcn", "mcn"},
		{"mcnade", "mcnad"},
		{"mda", "mda"},
		{"me", "me"},
		{"med", "med"},
		{"medaljong", "medaljong"},
		{"medaljongen", "medaljong"},
		{"medan", "medan"},
		{"medborgare", "medborg"},
		{"medbroder", "medbrod"},
		{"medbrottslingen", "medbrottsling"},
		{"meddela", "meddel"},
		{"meddelade", "meddel"},
		{"meddelades", "meddel"},
		{"meddelande", "meddel"},
		{"meddelar", "meddel"},
		{"meddelat", "meddel"},
		{"medel", "medel"},
		{"medelbar", "medelb"},
		{"medelklassfru", "medelklassfru"},
		{"medelmåttan", "medelmåttan"},
		{"medelmåttigt", "medelmått"},
		{"medelproportionalen", "medelproportional"},
		{"medelväg", "medelväg"},
		{"medelvägen", "medelväg"},
		{"medelålder", "medelåld"},
		{"medelålders", "medelålder"},
		{"meden", "med"},
		{"medfog", "medfog"},
		{"medfödd", "medföd"},
		{"medfödda", "medföd"},
		{"medfölja", "medfölj"},
		{"medföljande", "medfölj"},
		{"medföljt", "medföljt"},
		{"medför", "medför"},
		{"medföra", "medför"},
		{"medförde", "medförd"},
		{"medfört", "medfört"},
		{"medfött", "medföt"},
		{"medgaf", "medgaf"},
		{"medgav", "medgav"},
		{"medge", "medg"},
		{"medger", "medg"},
		{"medgifver", "medgifv"},
		{"medgifvit", "medgifvit"},
		{"medgiva", "medgiv"},
		{"medgives", "medgiv"},
		{"medgåfvo", "medgåfvo"},
		{"medgången", "medgång"},
		{"medgörlig", "medgör"},
		{"medgörlighet", "medgör"},
		{"medgörligt", "medgör"},
		{"medhava", "medhav"},
		{"medhjälpare", "medhjälp"},
		{"medicin", "medicin"},
		{"medicine", "medicin"},
		{"medicinerar", "mediciner"},
		{"medicinsk", "medicinsk"},
		{"medikamentskåp", "medikamentskåp"},
		{"medkänsla", "medkänsl"},
		{"medkänslan", "medkänslan"},
		{"medlande", "medl"},
		{"medlarekall", "medlarekall"},
		{"medlem", "medlem"},
		{"medlen", "medl"},
		{"medlet", "medlet"},
		{"medlidande", "medlid"},
		{"medlidsam", "medlidsam"},
		{"medlidsamt", "medlidsamt"},
		{"medmenniska", "medmennisk"},
		{"medmenniskor", "medmennisk"},
		{"medryckt", "medryck"},
		{"medsystrar", "medsystr"},
		{"medtaga", "medtag"},
		{"medtagande", "medtag"},
		{"medtagit", "medtagit"},
		{"medtog", "medtog"},
		{"medtoge", "medtog"},
		{"medverkan", "medverkan"},
		{"medvetande", "medvet"},
		{"medvetandet", "medvet"},
		{"medveten", "medvet"},
		{"medvetenhet", "medveten"},
		{"medvetet", "medvetet"},
		{"medvetna", "medvetn"},
		{"medvetslös", "medvetslös"},
		{"medvetslöst", "medvetslös"},
		{"medömkan", "medömkan"},
		{"mejade", "mej"},
		{"mejramsknipporna", "mejramsknipp"},
		{"mejsel", "mejsel"},
		{"mekanik", "mekanik"},
		{"mekanisk", "mekanisk"},
		{"mekaniskt", "mekanisk"},
		{"mekanismen", "mekanism"},
		{"mel", "mel"},
		{"melan", "melan"},
		{"melankoli", "melankoli"},
		{"melankolisk", "melankolisk"},
		{"melankoliska", "melankolisk"},
		{"melankoliskt", "melankolisk"},
		{"mellan", "mellan"},
		{"mellanlägg", "mellanlägg"},
		{"mellanländskt", "mellanländsk"},
		{"mellanrum", "mellanrum"},
		{"mellanrummet", "mellanrummet"},
		{"mellantid", "mellantid"},
		{"mellantiden", "mellantid"},
		{"mellantider", "mellantid"},
		{"mellberg", "mellberg"},
		{"meller", "mell"},
		{"mellersta", "mellerst"},
		{"mellin", "mellin"},
		{"mellinska", "mellinsk"},
		{"melodi", "melodi"},
		{"melodien", "melodi"},
		{"melodier", "melodi"},
		{"melodin", "melodin"},
		{"melodiskt", "melodisk"},
		{"melssängen", "melssäng"},
		{"melusina", "melusin"},
		{"men", "men"},
		{"mena", "men"},
		{"menad", "men"},
		{"menade", "men"},
		{"menades", "men"},
		{"menadt", "menad"},
		{"menageri", "menageri"},
		{"menande", "men"},
		{"menar", "men"},
		{"menat", "men"},
		{"menbarasvagtmotståndgjordc", "menbarasvagtmotståndgjordc"},
		{"menera", "mener"},
		{"menighet", "men"},
		{"menigheten", "men"},
		{"mening", "mening"},
		{"meningar", "mening"},
		{"meningarna", "mening"},
		{"meningen", "mening"},
		{"meningslösa", "meningslös"},
		{"meningslöst", "meningslös"},
		{"meningsutbytet", "meningsutbytet"},
		{"menliga", "men"},
		{"menlöshet", "menlös"},
		{"menlöst", "menlös"},
		{"menniska", "mennisk"},
		{"menniskan", "menniskan"},
		{"menniskas", "mennisk"},
		{"menniskoben", "menniskob"},
		{"menniskohjertat", "menniskohjert"},
		{"menniskolifs", "menniskolif"},
		{"menniskor", "mennisk"},
		{"menniskorna", "mennisk"},
		{"menniskornas", "mennisk"},
		{"menniskors", "menniskor"},
		{"menniskosnillets", "menniskosnillet"},
		{"menniskostoftets", "menniskostoftet"},
		{"menniskovänliga", "menniskovän"},
		{"menniskoälskande", "menniskoälsk"},
		{"mensklig", "mensk"},
		{"menskliga", "mensk"},
		{"mensklighetens", "mensk"},
		{"menskor", "mensk"},
		{"ment", "ment"},
		{"mente", "ment"},
		{"mentors", "mentor"},
		{"mentsbestridanden", "mentsbestrid"},
		{"menyn", "menyn"},
		{"mer", "mer"},
		{"mera", "mer"},
		{"merendels", "merendel"},
		{"meritförteckning", "meritförteckning"},
		{"meritlistan", "meritlistan"},
		{"mertens", "mert"},
		{"mes", "mes"},
		{"mest", "mest"},
		{"mesta", "mest"},
		{"met", "met"},
		{"meta", "met"},
		{"metade", "met"},
		{"metall", "metall"},
		{"metallens", "metall"},
		{"metallisk", "metallisk"},
		{"metallklangen", "metallklang"},
		{"metar", "met"},
		{"meter", "met"},
		{"metoden", "metod"},
		{"metref", "metref"},
		{"metrefvar", "metrefv"},
		{"metshatt", "metshat"},
		{"metslent", "metslent"},
		{"metspöet", "metspöet"},
		{"metspön", "metspön"},
		{"mevo", "mevo"},
		{"mi", "mi"},
		{"middag", "middag"},
		{"middagar", "middag"},
		{"middagarna", "middag"},
		{"middagen", "middag"},
		{"middags", "middag"},
		{"middagsbjudning", "middagsbjudning"},
		{"middagsbordet", "middagsbordet"},
		{"middagscigarr", "middagscigarr"},
		{"middagslur", "middagslur"},
		{"middagsluren", "middagslur"},
		{"middagsmåltid", "middagsmåltid"},
		{"middagsskymningen", "middagsskymning"},
		{"middagssällskap", "middagssällskap"},
		{"middagssömn", "middagssömn"},
		{"middagstid", "middagstid"},
		{"middagstiden", "middagstid"},
		{"middagstimmen", "middagstimm"},
		{"middagstimmens", "middagstimm"},
		{"midja", "midj"},
		{"midjan", "midjan"},
		{"midjorna", "midj"},
		{"midnatt", "midnat"},
		{"midnattsmässa", "midnattsmäss"},
		{"midnattssolens", "midnattssol"},
		{"midsommar", "midsomm"},
		{"midsommarblomstret", "midsommarblomstret"},
		{"midsommarbål", "midsommarbål"},
		{"midsommarhelgen", "midsommarhelg"},
		{"midsommarlek", "midsommarlek"},
		{"midsommarnatt", "midsommarnat"},
		{"midsommarnattens", "midsommarnat"},
		{"midsommarstång", "midsommarstång"},
		{"midsommartiden", "midsommartid"},
		{"midt", "midt"},
		{"midtemot", "midtemot"},
		{"midten", "midt"},
		{"mig", "mig"},
		{"miga", "mig"},
		{"migl", "migl"},
		{"mikael", "mikael"},
		{"mil", "mil"},
		{"mild", "mild"},
		{"milda", "mild"},
		{"mildare", "mild"},
		{"mildaste", "mild"},
		{"milde", "mild"},
		{"mildhet", "mild"},
		{"mildrade", "mildr"},
		{"mildrades", "mildr"},
		{"mildt", "mild"},
		{"milens", "mil"},
		{"militär", "militär"},
		{"militären", "militär"},
		{"militärer", "militär"},
		{"militärerna", "militär"},
		{"miljardism", "miljardism"},
		{"miljö", "miljö"},
		{"miljön", "miljön"},
		{"million", "million"},
		{"millioner", "million"},
		{"millionstad", "millionst"},
		{"milme", "milm"},
		{"mils", "mil"},
		{"milstolpe", "milstolp"},
		{"milt", "milt"},
		{"mimik", "mimik"},
		{"min", "min"},
		{"mina", "min"},
		{"minde", "mind"},
		{"minderåriga", "minderår"},
		{"mindes", "mind"},
		{"mindre", "mindr"},
		{"minen", "min"},
		{"miner", "min"},
		{"miniatyr", "miniatyr"},
		{"miniatyrer", "miniatyr"},
		{"minimala", "minimal"},
		{"minnas", "minn"},
		{"minnc", "minnc"},
		{"minne", "minn"},
		{"minnelse", "minn"},
		{"minnen", "minn"},
		{"minnens", "minn"},
		{"minnes", "minn"},
		{"minnesbeta", "minnesbet"},
		{"minnesbetan", "minnesbetan"},
		{"minnesslö", "minnesslö"},
		{"minnet", "minnet"},
		{"minns", "minn"},
		{"minnsann", "minnsan"},
		{"mins", "min"},
		{"minsann", "minsan"},
		{"minska", "minsk"},
		{"minskades", "minsk"},
		{"minskar", "minsk"},
		{"minskning", "minskning"},
		{"minst", "minst"},
		{"minsta", "minst"},
		{"minut", "minut"},
		{"minuten", "minut"},
		{"minuter", "minut"},
		{"minuterna", "minut"},
		{"minuters", "minuter"},
		{"miserablaste", "miserabl"},
		{"miss", "miss"},
		{"missat", "miss"},
		{"missbelåten", "missbelåt"},
		{"missbildat", "missbild"},
		{"missbilliga", "missbil"},
		{"missbruka", "missbruk"},
		{"missbrukade", "missbruk"},
		{"missbrukar", "missbruk"},
		{"missbrukas", "missbruk"},
		{"missfall", "missfall"},
		{"missfoster", "missfost"},
		{"missfostret", "missfostret"},
		{"missförhållande", "missförhåll"},
		{"missförstod", "missförstod"},
		{"missförstå", "missförstå"},
		{"missförstånd", "missförstånd"},
		{"missgrepp", "missgrepp"},
		{"misshag", "misshag"},
		{"misshagade", "misshag"},
		{"misshagar", "misshag"},
		{"misshandel", "misshandel"},
		{"missioncn", "missioncn"},
		{"missionsskolan", "missionsskolan"},
		{"missionsskolans", "missionsskolan"},
		{"missionsverksamhet", "missionsverksam"},
		{"missionär", "missionär"},
		{"missklädde", "misskläd"},
		{"missklädt", "misskläd"},
		{"misskänna", "misskän"},
		{"misskänner", "misskän"},
		{"misskänt", "misskänt"},
		{"misskötta", "missköt"},
		{"missleddes", "missled"},
		{"missljud", "missljud"},
		{"misslyckad", "misslyck"},
		{"misslyckade", "misslyck"},
		{"misslyckades", "misslyck"},
		{"misslyckande", "misslyck"},
		{"misslyckas", "misslyck"},
		{"misslynt", "misslynt"},
		{"misslynthet", "misslynt"},
		{"missmodig", "missmod"},
		{"missnöjd", "missnöjd"},
		{"missnöjda", "missnöjd"},
		{"missnöje", "missnöj"},
		{"missnöjets", "missnöjet"},
		{"missräkning", "missräkning"},
		{"missräkningar", "missräkning"},
		{"misstag", "misstag"},
		{"misstaga", "misstag"},
		{"misstager", "misstag"},
		{"misstaget", "misstaget"},
		{"misstagit", "misstagit"},
		{"misstankar", "misstank"},
		{"misstanke", "misstank"},
		{"misstanken", "misstank"},
		{"misstar", "misst"},
		{"misstog", "misstog"},
		{"misstolkas", "misstolk"},
		{"misstro", "misstro"},
		{"misstrodde", "misstrod"},
		{"misstroende", "misstroend"},
		{"misstrogen", "misstrog"},
		{"misstyck", "misstyck"},
		{"misstycka", "misstyck"},
		{"misstycker", "misstyck"},
		{"misstyd", "misstyd"},
		{"misstyda", "misstyd"},
		{"misstydas", "misstyd"},
		{"misstydde", "misstyd"},
		{"misstyder", "misstyd"},
		{"misstänka", "misstänk"},
		{"misstänker", "misstänk"},
		{"misstänksam", "misstänksam"},
		{"misstänksamhet", "misstänksam"},
		{"misstänksamt", "misstänksamt"},
		{"misstänkt", "misstänk"},
		{"misstänkta", "misstänk"},
		{"misstänkte", "misstänk"},
		{"missunna", "missun"},
		{"missöde", "missöd"},
		{"missöden", "missöd"},
		{"missödet", "missödet"},
		{"mist", "mist"},
		{"mista", "mist"},
		{"mistad", "mist"},
		{"mistat", "mist"},
		{"miste", "mist"},
		{"mister", "mist"},
		{"misär", "misär"},
		{"mit", "mit"},
		{"mitt", "mitt"},
		{"mittbenat", "mittben"},
		{"mittelgången", "mittelgång"},
		{"mittemellan", "mittemellan"},
		{"mittemot", "mittemot"},
		{"mitten", "mitt"},
		{"mittpunkt", "mittpunk"},
		{"mittpå", "mittpå"},
		{"mittunder", "mittund"},
		{"mivit", "mivit"},
		{"mixtur", "mixtur"},
		{"mjella", "mjell"},
		{"mjeltsjuk", "mjeltsjuk"},
		{"mjeltsjuka", "mjeltsjuk"},
		{"mjugg", "mjugg"},
		{"mjuk", "mjuk"},
		{"mjuka", "mjuk"},
		{"mjukare", "mjuk"},
		{"mjukaste", "mjuk"},
		{"mjukhet", "mjuk"},
		{"mjukt", "mjukt"},
		{"mjälla", "mjäll"},
		{"mjältsjuk", "mjältsjuk"},
		{"mjältsjuka", "mjältsjuk"},
		{"mjöd", "mjöd"},
		{"mjöl", "mjöl"},
		{"mjölade", "mjöl"},
		{"mjöldustet", "mjöldustet"},
		{"mjölig", "mjöl"},
		{"mjöligt", "mjöl"},
		{"mjölk", "mjölk"},
		{"mjölkade", "mjölk"},
		{"mjölkaret", "mjölkaret"},
		{"mjölkbyttor", "mjölkbyt"},
		{"mjölken", "mjölk"},
		{"mjölkmagasinet", "mjölkmagasinet"},
		{"mjölkmuggen", "mjölkmugg"},
		{"mjölkvällingen", "mjölkvälling"},
		{"mjölnarn", "mjölnarn"},
		{"mjölnarne", "mjöln"},
		{"mjölsiktningen", "mjölsiktning"},
		{"mjölskäppan", "mjölskäppan"},
		{"mjölsäckar", "mjölsäck"},
		{"mjöltunnan", "mjöltunnan"},
		{"ml", "ml"},
		{"mldrade", "mldrad"},
		{"mlg", "mlg"},
		{"mll", "mll"},
		{"mln", "mln"},
		{"mlskan", "mlskan"},
		{"mn", "mn"},
		{"mna", "mna"},
		{"mngen", "mngen"},
		{"mnn", "mnn"},
		{"mod", "mod"},
		{"modd", "modd"},
		{"modehandlerskor", "modehandlersk"},
		{"modell", "modell"},
		{"modellerade", "modeller"},
		{"moder", "mod"},
		{"moderat", "moder"},
		{"moderlig", "moder"},
		{"moderliga", "moder"},
		{"moderligt", "moder"},
		{"moderlös", "moderlös"},
		{"moderlösa", "moderlös"},
		{"moderlöse", "moderlös"},
		{"modern", "mod"},
		{"moderna", "mod"},
		{"moderniserad", "moderniser"},
		{"moderns", "mod"},
		{"modernt", "modernt"},
		{"moders", "moder"},
		{"modersbarm", "modersbarm"},
		{"modersbröst", "modersbröst"},
		{"modersbröstet", "modersbröstet"},
		{"modershjerta", "modershjert"},
		{"modershjärtat", "modershjärt"},
		{"moderskapets", "moderskapet"},
		{"modesta", "modest"},
		{"modet", "modet"},
		{"modfäld", "modfäld"},
		{"modfälld", "modfälld"},
		{"modig", "mod"},
		{"modiga", "mod"},
		{"modigare", "mod"},
		{"modigt", "mod"},
		{"modlöshet", "modlös"},
		{"modlöst", "modlös"},
		{"modrar", "modr"},
		{"mods", "mod"},
		{"modstulenhet", "modstulen"},
		{"modulerade", "moduler"},
		{"modus", "modus"},
		{"modärna", "modärn"},
		{"mogen", "mog"},
		{"moget", "moget"},
		{"mogma", "mogm"},
		{"mogna", "mogn"},
		{"mognade", "mogn"},
		{"mognadt", "mognad"},
		{"mognar", "mogn"},
		{"mognare", "mogn"},
		{"mognat", "mogn"},
		{"mohikanen", "mohikan"},
		{"mokat", "mok"},
		{"molande", "mol"},
		{"molat", "mol"},
		{"moll", "moll"},
		{"moln", "moln"},
		{"molnen", "moln"},
		{"molnet", "molnet"},
		{"molnkransen", "molnkrans"},
		{"molnmassorna", "molnmass"},
		{"molnskockarna", "molnskock"},
		{"moltke", "moltk"},
		{"mon", "mon"},
		{"monarda", "monard"},
		{"monark", "monark"},
		{"monda", "mond"},
		{"mondäna", "mondän"},
		{"monsieur", "monsieur"},
		{"monte", "mont"},
		{"montmartre", "montmartr"},
		{"mor", "mor"},
		{"mora", "mor"},
		{"moral", "moral"},
		{"moralen", "moral"},
		{"moralens", "moral"},
		{"moraler", "moral"},
		{"moraliska", "moralisk"},
		{"moraliskt", "moralisk"},
		{"moralitet", "moralitet"},
		{"morb", "morb"},
		{"morbror", "morbr"},
		{"morbrors", "morbror"},
		{"mord", "mord"},
		{"mordet", "mordet"},
		{"mordiska", "mordisk"},
		{"mordnatten", "mordnat"},
		{"mordredskap", "mordredskap"},
		{"morell", "morell"},
		{"mores", "mor"},
		{"morfar", "morf"},
		{"morföräldrar", "morföräldr"},
		{"morföräldrarnas", "morföräldr"},
		{"morgnar", "morgn"},
		{"morgnarna", "morgn"},
		{"morgnarne", "morgn"},
		{"morgon", "morgon"},
		{"morgonarbete", "morgonarbet"},
		{"morgoncn", "morgoncn"},
		{"morgondagen", "morgondag"},
		{"morgondagens", "morgondag"},
		{"morgondaggen", "morgondagg"},
		{"morgonen", "morgon"},
		{"morgonens", "morgon"},
		{"morgonglada", "morgonglad"},
		{"morgongryningen", "morgongryning"},
		{"morgongrått", "morgongråt"},
		{"morgonhimlen", "morgonhiml"},
		{"morgonkaffe", "morgonkaff"},
		{"morgonpromenad", "morgonpromen"},
		{"morgonpromenader", "morgonpromenad"},
		{"morgonritt", "morgonrit"},
		{"morgonritter", "morgonrit"},
		{"morgonrock", "morgonrock"},
		{"morgonrocken", "morgonrock"},
		{"morgonsolen", "morgonsol"},
		{"morgonstjerna", "morgonstj"},
		{"morgonstund", "morgonstund"},
		{"morgonstunder", "morgonstund"},
		{"morgonvandringen", "morgonvandring"},
		{"morgonvatten", "morgonvat"},
		{"morior", "mori"},
		{"morka", "mork"},
		{"morknar", "morkn"},
		{"morkret", "morkret"},
		{"mormor", "morm"},
		{"mormors", "mormor"},
		{"morna", "morn"},
		{"morrade", "morr"},
		{"morrande", "morr"},
		{"morrning", "morrning"},
		{"mors", "mor"},
		{"morse", "mors"},
		{"morskt", "morsk"},
		{"mortel", "mortel"},
		{"mosaik", "mosaik"},
		{"mosiga", "mos"},
		{"mosin", "mosin"},
		{"mossa", "moss"},
		{"mossan", "mossan"},
		{"mossen", "moss"},
		{"moster", "most"},
		{"mosters", "moster"},
		{"mostrar", "mostr"},
		{"mot", "mot"},
		{"motarbeta", "motarbet"},
		{"motarbetade", "motarbet"},
		{"motarbetas", "motarbet"},
		{"motbjudande", "motbjud"},
		{"motgift", "motgift"},
		{"motgångar", "motgång"},
		{"motgången", "motgång"},
		{"motiv", "motiv"},
		{"motiverat", "motiver"},
		{"motor", "mot"},
		{"motorernas", "motor"},
		{"motorn", "motorn"},
		{"motsade", "mots"},
		{"motsades", "mots"},
		{"motsagt", "motsag"},
		{"motsats", "motsat"},
		{"motsatsen", "motsats"},
		{"motsatser", "motsats"},
		{"motsatt", "motsat"},
		{"motsatta", "motsat"},
		{"motspänstighet", "motspänst"},
		{"motstod", "motstod"},
		{"motsträfvighet", "motsträfv"},
		{"motsträviga", "motsträv"},
		{"motsträvige", "motsträv"},
		{"motsträvighet", "motsträv"},
		{"motsträvigt", "motsträv"},
		{"motstå", "motstå"},
		{"motstånd", "motstånd"},
		{"motståndet", "motståndet"},
		{"motsvara", "motsvar"},
		{"motsäga", "motsäg"},
		{"motsägelse", "motsäg"},
		{"motsägelsen", "motsäg"},
		{"motsägelser", "motsäg"},
		{"mott", "mott"},
		{"mottag", "mottag"},
		{"mottaga", "mottag"},
		{"mottagande", "mottag"},
		{"mottagandet", "mottag"},
		{"mottagas", "mottag"},
		{"mottagen", "mottag"},
		{"mottager", "mottag"},
		{"mottagit", "mottagit"},
		{"mottagna", "mottagn"},
		{"mottagning", "mottagning"},
		{"mottagningen", "mottagning"},
		{"mottagningsrum", "mottagningsrum"},
		{"mottagningsrummet", "mottagningsrummet"},
		{"mottagningstiden", "mottagningstid"},
		{"mottagningstidens", "mottagningstid"},
		{"mottagningstimmen", "mottagningstimm"},
		{"mottog", "mottog"},
		{"mottogo", "mottogo"},
		{"mottogs", "mottog"},
		{"motvilja", "motvilj"},
		{"motvillighet", "motvil"},
		{"motvilligt", "motvil"},
		{"moy", "moy"},
		{"mozart", "mozart"},
		{"mq", "mq"},
		{"mr", "mr"},
		{"ms", "ms"},
		{"mte", "mte"},
		{"muffen", "muff"},
		{"mulen", "mul"},
		{"mulet", "mulet"},
		{"mull", "mull"},
		{"mullen", "mull"},
		{"mullig", "mul"},
		{"mullrar", "mullr"},
		{"mulna", "muln"},
		{"mulnade", "muln"},
		{"mum", "mum"},
		{"mumielika", "mumielik"},
		{"mumla", "muml"},
		{"mumlade", "muml"},
		{"mumlande", "muml"},
		{"mumlar", "muml"},
		{"mumlat", "muml"},
		{"mumlet", "mumlet"},
		{"mumm", "mumm"},
		{"mums", "mum"},
		{"mumsa", "mums"},
		{"mumsade", "mums"},
		{"mumsande", "mums"},
		{"mumsat", "mums"},
		{"mun", "mun"},
		{"mund", "mund"},
		{"mungipor", "mungip"},
		{"mungiporna", "mungip"},
		{"munken", "munk"},
		{"munklegend", "munklegend"},
		{"munnar", "munn"},
		{"munnarna", "munn"},
		{"munnen", "munn"},
		{"munsbit", "munsbit"},
		{"munstycken", "munstyck"},
		{"munter", "munt"},
		{"munterhet", "munter"},
		{"muntert", "muntert"},
		{"muntlig", "munt"},
		{"muntligen", "munt"},
		{"muntligt", "munt"},
		{"muntra", "muntr"},
		{"muntrande", "muntr"},
		{"muntrare", "muntr"},
		{"muntraste", "muntr"},
		{"muntre", "muntr"},
		{"munvig", "munv"},
		{"munvädren", "munvädr"},
		{"mur", "mur"},
		{"murar", "mur"},
		{"murarna", "mur"},
		{"murbruket", "murbruket"},
		{"muren", "mur"},
		{"murken", "murk"},
		{"murket", "murket"},
		{"murklor", "murkl"},
		{"murklorna", "murkl"},
		{"murkna", "murkn"},
		{"murre", "murr"},
		{"murvel", "murvel"},
		{"murvlar", "murvl"},
		{"murvlarna", "murvl"},
		{"mus", "mus"},
		{"musa", "mus"},
		{"museer", "muse"},
		{"museet", "museet"},
		{"musen", "mus"},
		{"musik", "musik"},
		{"musikalisk", "musikalisk"},
		{"musikaliske", "musikalisk"},
		{"musikanter", "musikant"},
		{"musiken", "musik"},
		{"musikens", "musik"},
		{"musiker", "musik"},
		{"musiknummer", "musiknumm"},
		{"muskel", "muskel"},
		{"muskelspelet", "muskelspelet"},
		{"muskelstarka", "muskelstark"},
		{"musklerna", "muskl"},
		{"muskulatur", "muskulatur"},
		{"muskulös", "muskulös"},
		{"muskötskott", "muskötskot"},
		{"muslinsgardinen", "muslinsgardin"},
		{"musslinsduken", "musslinsduk"},
		{"must", "must"},
		{"mustasch", "mustasch"},
		{"mustascher", "mustasch"},
		{"musten", "must"},
		{"mustig", "must"},
		{"mustiga", "must"},
		{"muta", "mut"},
		{"muttrade", "muttr"},
		{"muttrande", "muttr"},
		{"myckct", "myckct"},
		{"mycke", "myck"},
		{"mycken", "myck"},
		{"myckenhet", "mycken"},
		{"mycket", "mycket"},
		{"myckna", "myckn"},
		{"myeket", "myeket"},
		{"mygg", "mygg"},
		{"myggan", "myggan"},
		{"myggen", "mygg"},
		{"myggor", "mygg"},
		{"myggorna", "mygg"},
		{"myling", "myling"},
		{"mylingarna", "myling"},
		{"mylla", "myll"},
		{"myllrande", "myllr"},
		{"myllrar", "myllr"},
		{"myndig", "mynd"},
		{"myndiga", "mynd"},
		{"myndigare", "mynd"},
		{"myndighet", "mynd"},
		{"myndigheters", "myndigheter"},
		{"myndighets", "myndighet"},
		{"myndling", "myndling"},
		{"mynnat", "mynn"},
		{"mynt", "mynt"},
		{"myra", "myr"},
		{"myran", "myran"},
		{"myrarna", "myr"},
		{"myren", "myr"},
		{"myriader", "myriad"},
		{"myror", "myr"},
		{"myrstack", "myrstack"},
		{"myrstackarna", "myrstack"},
		{"myrten", "myrt"},
		{"myrtenträd", "myrtenträd"},
		{"mysande", "mys"},
		{"myst", "myst"},
		{"myste", "myst"},
		{"mysterer", "myster"},
		{"mysterium", "mysterium"},
		{"mystifikation", "mystifikation"},
		{"mystifikationer", "mystifikation"},
		{"mystik", "mystik"},
		{"mystisk", "mystisk"},
		{"mystiska", "mystisk"},
		{"mystiskt", "mystisk"},
		{"myten", "myt"},
		{"mäblerna", "mäbl"},
		{"mägtade", "mägt"},
		{"mägtig", "mägt"},
		{"mägtigt", "mägt"},
		{"mäkta", "mäkt"},
		{"mäktig", "mäkt"},
		{"mäktiga", "mäkt"},
		{"mäktigare", "mäkt"},
		{"mäktigt", "mäkt"},
		{"mälarbåten", "mälarbåt"},
		{"mälaren", "mäl"},
		{"mälarens", "mäl"},
		{"mälmiskornas", "mälmisk"},
		{"män", "män"},
		{"mändell", "mändell"},
		{"mänga", "mäng"},
		{"mängd", "mäng"},
		{"mängden", "mäng"},
		{"männen", "männ"},
		{"männens", "männ"},
		{"männer", "männ"},
		{"männerna", "männ"},
		{"människa", "människ"},
		{"människan", "människan"},
		{"människans", "människan"},
		{"människas", "människ"},
		{"människo", "människo"},
		{"människobarnens", "människobarn"},
		{"människofiskare", "människofisk"},
		{"människofruktan", "människofruktan"},
		{"människokännedom", "människokännedom"},
		{"människokärlek", "människokärlek"},
		{"människoliv", "människoliv"},
		{"människomaterial", "människomaterial"},
		{"människopsykologi", "människopsykologi"},
		{"människor", "människ"},
		{"människorna", "människ"},
		{"människornas", "människ"},
		{"människors", "människor"},
		{"människorätt", "människorät"},
		{"människoskygghet", "människoskygg"},
		{"människosläktet", "människosläktet"},
		{"människosonen", "människoson"},
		{"människosort", "människosort"},
		{"människovilja", "människovilj"},
		{"människovimlet", "människovimlet"},
		{"människovän", "människovän"},
		{"mäns", "män"},
		{"mänska", "mänsk"},
		{"mänsklig", "mänsk"},
		{"mänskliga", "mänsk"},
		{"mänskligheten", "mänsk"},
		{"mänsklighetens", "mänsk"},
		{"mänskligt", "mänsk"},
		{"mänskor", "mänsk"},
		{"märg", "märg"},
		{"märgfull", "märgfull"},
		{"märk", "märk"},
		{"märka", "märk"},
		{"märkbar", "märkb"},
		{"märkbara", "märkbar"},
		{"märkbarare", "märkbar"},
		{"märkbart", "märkbart"},
		{"märke", "märk"},
		{"märken", "märk"},
		{"märker", "märk"},
		{"märket", "märket"},
		{"märklig", "märk"},
		{"märkliga", "märk"},
		{"märkligheter", "märk"},
		{"märkligt", "märk"},
		{"märkt", "märk"},
		{"märkte", "märk"},
		{"märktes", "märk"},
		{"märkvärdig", "märkvärd"},
		{"märkvärdiga", "märkvärd"},
		{"märkvärdigheter", "märkvärd"},
		{"märkvärdigt", "märkvärd"},
		{"märtas", "märt"},
		{"mässa", "mäss"},
		{"mässade", "mäss"},
		{"mässar", "mäss"},
		{"mässing", "mässing"},
		{"mästare", "mäst"},
		{"mästaren", "mäst"},
		{"mästarn", "mästarn"},
		{"mäste", "mäst"},
		{"mäster", "mäst"},
		{"mästermansyxan", "mästermansyxan"},
		{"mästerstycke", "mästerstyck"},
		{"mästrade", "mästr"},
		{"mäta", "mät"},
		{"mätas", "mät"},
		{"mäter", "mät"},
		{"mätt", "mätt"},
		{"mätta", "mätt"},
		{"mättad", "mätt"},
		{"mättar", "mätt"},
		{"mätte", "mätt"},
		{"må", "må"},
		{"mådde", "mådd"},
		{"mående", "måend"},
		{"måfå", "måfå"},
		{"måg", "måg"},
		{"mågen", "måg"},
		{"mågs", "måg"},
		{"måhända", "måhänd"},
		{"mål", "mål"},
		{"måla", "mål"},
		{"målad", "mål"},
		{"målade", "mål"},
		{"målande", "mål"},
		{"målar", "mål"},
		{"målarakademiens", "målarakademi"},
		{"målare", "mål"},
		{"målareexpositionen", "målareexposition"},
		{"målarfärgen", "målarfärg"},
		{"målarmästare", "målarmäst"},
		{"målas", "mål"},
		{"målat", "mål"},
		{"målet", "målet"},
		{"mållös", "mållös"},
		{"målning", "målning"},
		{"måls", "mål"},
		{"måltid", "måltid"},
		{"måltiden", "måltid"},
		{"måltiderna", "måltid"},
		{"måltidstimmen", "måltidstimm"},
		{"mån", "mån"},
		{"månad", "mån"},
		{"månaden", "månad"},
		{"månader", "månad"},
		{"månaderna", "månad"},
		{"månadernas", "månad"},
		{"månaders", "månader"},
		{"månads", "månad"},
		{"månar", "mån"},
		{"månbristning", "månbristning"},
		{"måndag", "måndag"},
		{"måndagen", "måndag"},
		{"måndc", "måndc"},
		{"månde", "månd"},
		{"måne", "mån"},
		{"månen", "mån"},
		{"många", "mång"},
		{"mångahanda", "mångahand"},
		{"mångdubbelt", "mångdubbelt"},
		{"mångelskan", "mångelskan"},
		{"mången", "mång"},
		{"månget", "månget"},
		{"mångfald", "mångfald"},
		{"mångfaldiga", "mångfald"},
		{"mångfaldigt", "mångfald"},
		{"mångfärgat", "mångfärg"},
		{"månggifte", "månggift"},
		{"månghundraårig", "månghundraår"},
		{"månglarna", "mångl"},
		{"månglittermjöl", "månglittermjöl"},
		{"månglitterskrud", "månglitterskrud"},
		{"mångtydigt", "mångtyd"},
		{"mångårig", "mångår"},
		{"mångåriga", "mångår"},
		{"mångårigt", "mångår"},
		{"månklara", "månklar"},
		{"månljus", "månljus"},
		{"månljuset", "månljuset"},
		{"månn", "månn"},
		{"månne", "månn"},
		{"månsken", "månsk"},
		{"månskenet", "månskenet"},
		{"månskensfantast", "månskensfant"},
		{"månskensnatt", "månskensnat"},
		{"månskensnatten", "månskensnat"},
		{"månskensnätter", "månskensnät"},
		{"månskymning", "månskymning"},
		{"månstrålarna", "månstrål"},
		{"månstråle", "månstrål"},
		{"måntro", "måntro"},
		{"mår", "mår"},
		{"mårten", "mårt"},
		{"mårtens", "mårt"},
		{"måsar", "mås"},
		{"måsle", "måsl"},
		{"måst", "måst"},
		{"måstc", "måstc"},
		{"måste", "måst"},
		{"mått", "mått"},
		{"måtta", "mått"},
		{"måttan", "måttan"},
		{"måtte", "mått"},
		{"måttet", "måttet"},
		{"måttligt", "mått"},
		{"måtto", "måtto"},
		{"mö", "mö"},
		{"möbel", "möbel"},
		{"möbeln", "möbeln"},
		{"möbelöverdrag", "möbelöverdrag"},
		{"möblemang", "möblemang"},
		{"möblemanget", "möblemanget"},
		{"möbler", "möbl"},
		{"möblerade", "möbler"},
		{"möblerar", "möbler"},
		{"möblerat", "möbler"},
		{"möbleringen", "möblering"},
		{"möblerna", "möbl"},
		{"möda", "möd"},
		{"mödan", "mödan"},
		{"mödor", "möd"},
		{"mödosamt", "mödosamt"},
		{"mödrar", "mödr"},
		{"möj", "möj"},
		{"möjliga", "möj"},
		{"möjligast", "möj"},
		{"möjligaste", "möj"},
		{"möjligen", "möj"},
		{"möjlighet", "möj"},
		{"möjligheten", "möj"},
		{"möjligheter", "möj"},
		{"möjligt", "möj"},
		{"möjligtvis", "möjligtvis"},
		{"möjllgt", "möjllg"},
		{"mönster", "mönst"},
		{"mönstrade", "mönstr"},
		{"mönstrande", "mönstr"},
		{"mönstret", "mönstret"},
		{"mönstring", "mönstring"},
		{"mör", "mör"},
		{"mörare", "mör"},
		{"mörbultade", "mörbult"},
		{"mörda", "mörd"},
		{"mördande", "mörd"},
		{"mördar", "mörd"},
		{"mördare", "mörd"},
		{"mördarekula", "mördarekul"},
		{"mördaren", "mörd"},
		{"mördares", "mördar"},
		{"mördarn", "mördarn"},
		{"mördarne", "mörd"},
		{"mörk", "mörk"},
		{"mörka", "mörk"},
		{"mörkare", "mörk"},
		{"mörkaste", "mörk"},
		{"mörkbla", "mörkbl"},
		{"mörkblå", "mörkblå"},
		{"mörkblåglänsande", "mörkblågläns"},
		{"mörkbruna", "mörkbrun"},
		{"mörkbrunt", "mörkbrunt"},
		{"mörke", "mörk"},
		{"mörker", "mörk"},
		{"mörkgrå", "mörkgrå"},
		{"mörkgrön", "mörkgrön"},
		{"mörkhårig", "mörkhår"},
		{"mörklagd", "mörklag"},
		{"mörkna", "mörkn"},
		{"mörknade", "mörkn"},
		{"mörknande", "mörkn"},
		{"mörknar", "mörkn"},
		{"mörknat", "mörkn"},
		{"mörkningen", "mörkning"},
		{"mörkrer", "mörkr"},
		{"mörkret", "mörkret"},
		{"mörkröd", "mörkröd"},
		{"mörkröda", "mörkröd"},
		{"mörksamt", "mörksamt"},
		{"mörksens", "mörks"},
		{"mörkt", "mörk"},
		{"mös", "mös"},
		{"möss", "möss"},
		{"mössa", "möss"},
		{"mössan", "mössan"},
		{"möta", "möt"},
		{"mötande", "möt"},
		{"mötas", "möt"},
		{"möte", "möt"},
		{"möten", "möt"},
		{"mötena", "möten"},
		{"möter", "möt"},
		{"mötes", "möt"},
		{"mötesplats", "mötesplat"},
		{"mötesplatsen", "mötesplats"},
		{"mötet", "mötet"},
		{"möts", "möt"},
		{"mött", "mött"},
		{"mötte", "mött"},
		{"möttes", "mött"},
		{"mötts", "mött"},
		{"n", "n"},
		{"na", "na"},
		{"nacke", "nack"},
		{"nacken", "nack"},
		{"nackens", "nack"},
		{"nackstyf", "nackstyf"},
		{"nad", "nad"},
		{"nadde", "nadd"},
		{"naddes", "nadd"},
		{"nade", "nad"},
		{"nadelön", "nadelön"},
		{"naden", "nad"},
		{"nader", "nad"},
		{"nadig", "nad"},
		{"nafsade", "nafs"},
		{"nafsar", "nafs"},
		{"nafsat", "nafs"},
		{"nagel", "nagel"},
		{"nageln", "nageln"},
		{"naggade", "nagg"},
		{"naggande", "nagg"},
		{"naglande", "nagl"},
		{"naglar", "nagl"},
		{"naglarna", "nagl"},
		{"naglarne", "nagl"},
		{"nagon", "nagon"},
		{"nagonsin", "nagonsin"},
		{"nagot", "nagot"},
		{"nagra", "nagr"},
		{"naiv", "naiv"},
		{"naiva", "naiv"},
		{"naivt", "naivt"},
		{"naken", "nak"},
		{"nakenhet", "naken"},
		{"naket", "naket"},
		{"nakna", "nakn"},
		{"nakterhuset", "nakterhuset"},
		{"nalkades", "nalk"},
		{"nalkas", "nalk"},
		{"namn", "namn"},
		{"namnen", "namn"},
		{"namnet", "namnet"},
		{"namnlös", "namnlös"},
		{"namnlöst", "namnlös"},
		{"namnsdag", "namnsdag"},
		{"namnsdagar", "namnsdag"},
		{"namnteckningar", "namnteckning"},
		{"nan", "nan"},
		{"nande", "nand"},
		{"nankinsbyxor", "nankinsbyx"},
		{"nanna", "nann"},
		{"nannas", "nann"},
		{"nans", "nan"},
		{"napoleon", "napoleon"},
		{"napoleons", "napoleon"},
		{"napoleonsbild", "napoleonsbild"},
		{"napp", "napp"},
		{"nappa", "napp"},
		{"nappte", "nappt"},
		{"nar", "nar"},
		{"nara", "nar"},
		{"narciss", "narciss"},
		{"narcissism", "narcissism"},
		{"narkosmasken", "narkosmask"},
		{"narmn", "narmn"},
		{"narna", "narn"},
		{"narr", "narr"},
		{"narra", "narr"},
		{"narrade", "narr"},
		{"narrades", "narr"},
		{"narraktiga", "narrakt"},
		{"narraktigheterna", "narrakt"},
		{"narrar", "narr"},
		{"narras", "narr"},
		{"narrat", "narr"},
		{"narrats", "narrat"},
		{"narren", "narr"},
		{"narri", "narri"},
		{"narrklocka", "narrklock"},
		{"nasaltoner", "nasalton"},
		{"nasta", "nast"},
		{"nastan", "nastan"},
		{"nat", "nat"},
		{"natarligtvis", "natarligtvis"},
		{"natet", "natet"},
		{"nationaleko", "nationaleko"},
		{"nationers", "nationer"},
		{"nations", "nation"},
		{"natorligtvis", "natorligtvis"},
		{"natt", "natt"},
		{"nattblå", "nattblå"},
		{"nattcll", "nattcll"},
		{"nattdaggen", "nattdagg"},
		{"nattdrakt", "nattdrak"},
		{"nattdräkt", "nattdräk"},
		{"nattduksbord", "nattduksbord"},
		{"nattduksbordet", "nattduksbordet"},
		{"natten", "natt"},
		{"nattens", "natt"},
		{"nattetid", "nattetid"},
		{"nattfjäril", "nattfjäril"},
		{"nattfjäriln", "nattfjäriln"},
		{"nattglim", "nattglim"},
		{"natthämtning", "natthämtning"},
		{"nattkappor", "nattkapp"},
		{"nattlig", "natt"},
		{"nattliga", "natt"},
		{"nattligt", "natt"},
		{"nattlinne", "nattlin"},
		{"nattlinnet", "nattlinnet"},
		{"nattluften", "nattluft"},
		{"nattmössan", "nattmössan"},
		{"nattrock", "nattrock"},
		{"nattrockar", "nattrock"},
		{"nattrocken", "nattrock"},
		{"nattrocksfickan", "nattrocksfickan"},
		{"nattrocksfragmenterna", "nattrocksfragment"},
		{"nattröja", "nattröj"},
		{"natts", "natt"},
		{"nattskjorta", "nattskjort"},
		{"nattskymningen", "nattskymning"},
		{"nattstuga", "nattstug"},
		{"nattsvirare", "nattsvir"},
		{"nattvak", "nattvak"},
		{"nattvakt", "nattvak"},
		{"nattvandrerska", "nattvandrersk"},
		{"nattvarden", "nattvard"},
		{"nattvardens", "nattvard"},
		{"nattvardsbaciller", "nattvardsbacill"},
		{"nattvardsfrågan", "nattvardsfrågan"},
		{"nattvardsgäst", "nattvardsgäst"},
		{"nattvardsgång", "nattvardsgång"},
		{"nattvardskalk", "nattvardskalk"},
		{"nattvardskapslar", "nattvardskapsl"},
		{"nattvardsvinet", "nattvardsvinet"},
		{"nattvind", "nattvind"},
		{"nattvinden", "nattvind"},
		{"natur", "natur"},
		{"naturbarnet", "naturbarnet"},
		{"naturbehov", "naturbehov"},
		{"naturen", "natur"},
		{"naturens", "natur"},
		{"naturer", "natur"},
		{"naturgåfvor", "naturgåfv"},
		{"naturkrafter", "naturkraft"},
		{"naturkunnighet", "naturkunn"},
		{"naturl", "naturl"},
		{"naturlig", "natur"},
		{"naturliga", "natur"},
		{"naturligt", "natur"},
		{"naturligtns", "naturligtn"},
		{"naturligtvis", "naturligtvis"},
		{"naturskönhet", "naturskön"},
		{"navarra", "navarr"},
		{"navel", "navel"},
		{"naveln", "naveln"},
		{"navelsträng", "navelsträng"},
		{"navigation", "navigation"},
		{"navigationen", "navigation"},
		{"nazir", "nazir"},
		{"ncs", "ncs"},
		{"ndade", "ndad"},
		{"ndgon", "ndgon"},
		{"ne", "ne"},
		{"necken", "neck"},
		{"neckens", "neck"},
		{"neckros", "neckro"},
		{"neckrosor", "neckros"},
		{"ned", "ned"},
		{"nedan", "nedan"},
		{"nedanför", "nedanför"},
		{"nedanom", "nedanom"},
		{"nedanstående", "nedanståend"},
		{"nedat", "ned"},
		{"nedbojda", "nedbojd"},
		{"nedborrade", "nedborr"},
		{"nedböjd", "nedböjd"},
		{"nedböjda", "nedböjd"},
		{"nedböjde", "nedböjd"},
		{"nedböjt", "nedböjt"},
		{"neddalat", "neddal"},
		{"neddignade", "neddign"},
		{"neddragen", "neddrag"},
		{"neddragna", "neddragn"},
		{"nederlag", "nederlag"},
		{"nedersta", "nederst"},
		{"nedfallen", "nedfall"},
		{"nedfallna", "nedfalln"},
		{"nedfälda", "nedfäld"},
		{"nedföll", "nedföll"},
		{"nedföllo", "nedföllo"},
		{"nedför", "nedför"},
		{"nedgick", "nedgick"},
		{"nedgrävd", "nedgrävd"},
		{"nedgående", "nedgåend"},
		{"nedgång", "nedgång"},
		{"nedgår", "nedgår"},
		{"nedhalade", "nedhal"},
		{"nedhukad", "nedhuk"},
		{"nedhäng", "nedhäng"},
		{"nedifrån", "nedifrån"},
		{"nedkommen", "nedkomm"},
		{"nedlade", "nedl"},
		{"nedlagt", "nedlag"},
		{"nedlutad", "nedlut"},
		{"nedlägga", "nedlägg"},
		{"nedlåta", "nedlåt"},
		{"nedlåtande", "nedlåt"},
		{"nedlåtenhet", "nedlåten"},
		{"nedlör", "nedlör"},
		{"nedmyllades", "nedmyll"},
		{"nedom", "nedom"},
		{"nedpackning", "nedpackning"},
		{"nedra", "nedr"},
		{"nedramlade", "nedraml"},
		{"nedre", "nedr"},
		{"nedriga", "nedr"},
		{"nedrigt", "nedr"},
		{"nedring", "nedring"},
		{"nedsatt", "nedsat"},
		{"nedsjunka", "nedsjunk"},
		{"nedsjunken", "nedsjunk"},
		{"nedsjunket", "nedsjunket"},
		{"nedsjunkit", "nedsjunkit"},
		{"nedsjönk", "nedsjönk"},
		{"nedskjuten", "nedskjut"},
		{"nedskrifvit", "nedskrifvit"},
		{"nedslagen", "nedslag"},
		{"nedslagenhet", "nedslagen"},
		{"nedslagna", "nedslagn"},
		{"nedslungad", "nedslung"},
		{"nedslående", "nedslåend"},
		{"nedsmutsa", "nedsmuts"},
		{"nedstuckna", "nedstuckn"},
		{"nedstämd", "nedstämd"},
		{"nedstämdhet", "nedstämd"},
		{"nedstämmer", "nedstämm"},
		{"nedstänkt", "nedstänk"},
		{"nedsänkt", "nedsänk"},
		{"nedsättande", "nedsät"},
		{"nedtill", "nedtill"},
		{"nedtog", "nedtog"},
		{"nedtryckt", "nedtryck"},
		{"nedtryckta", "nedtryck"},
		{"nedtrycktas", "nedtryck"},
		{"nedtryckte", "nedtryck"},
		{"nedtyngd", "nedtyng"},
		{"nedtystad", "nedtyst"},
		{"nedviken", "nedvik"},
		{"nedvänd", "nedvänd"},
		{"nedvändt", "nedvänd"},
		{"nedvänt", "nedvänt"},
		{"nedåt", "nedåt"},
		{"nee", "nee"},
		{"neg", "neg"},
		{"neger", "neg"},
		{"negerhår", "negerhår"},
		{"negertroll", "negertroll"},
		{"negligeer", "neglige"},
		{"negress", "negress"},
		{"negresser", "negress"},
		{"nehej", "nehej"},
		{"nej", "nej"},
		{"nejd", "nejd"},
		{"nejden", "nejd"},
		{"nejlika", "nejlik"},
		{"nejlikdoft", "nejlikdoft"},
		{"nejlikor", "nejlik"},
		{"neka", "nek"},
		{"nekade", "nek"},
		{"nekande", "nek"},
		{"nekar", "nek"},
		{"nekas", "nek"},
		{"nekat", "nek"},
		{"nelly", "nelly"},
		{"nem", "nem"},
		{"nemligen", "nem"},
		{"nen", "nen"},
		{"ner", "ner"},
		{"nere", "ner"},
		{"nereus", "nereus"},
		{"nerfälld", "nerfälld"},
		{"nerifrån", "nerifrån"},
		{"nerligt", "ner"},
		{"nersolkade", "nersolk"},
		{"nersuttet", "nersuttet"},
		{"nersölade", "nersöl"},
		{"nertagna", "nertagn"},
		{"nerver", "nerv"},
		{"nervlös", "nervlös"},
		{"nervsjuka", "nervsjuk"},
		{"nervtrådar", "nervtråd"},
		{"nervvärk", "nervvärk"},
		{"nervös", "nervös"},
		{"nervösa", "nervös"},
		{"nervöst", "nervöst"},
		{"nes", "nes"},
		{"net", "net"},
		{"neta", "net"},
		{"netas", "net"},
		{"netty", "netty"},
		{"ni", "ni"},
		{"nia", "nia"},
		{"niais", "niais"},
		{"niaiserie", "niaiseri"},
		{"nic", "nic"},
		{"nicander", "nicand"},
		{"nick", "nick"},
		{"nicka", "nick"},
		{"nickade", "nick"},
		{"nickande", "nick"},
		{"nickar", "nick"},
		{"nickningar", "nickning"},
		{"nietzsche", "nietzsch"},
		{"nigande", "nig"},
		{"niger", "nig"},
		{"nigit", "nigit"},
		{"nigning", "nigning"},
		{"nikotin", "nikotin"},
		{"nils", "nil"},
		{"nimma", "nimm"},
		{"nimmelse", "nimm"},
		{"ning", "ning"},
		{"ningar", "ning"},
		{"ningarna", "ning"},
		{"ningen", "ning"},
		{"ningskjol", "ningskjol"},
		{"ningsrum", "ningsrum"},
		{"ninkande", "nink"},
		{"nio", "nio"},
		{"nionde", "niond"},
		{"nipper", "nipp"},
		{"nish", "nish"},
		{"niska", "nisk"},
		{"niskor", "nisk"},
		{"niskorna", "nisk"},
		{"nisse", "niss"},
		{"nit", "nit"},
		{"nitet", "nitet"},
		{"nitisk", "nitisk"},
		{"nitiske", "nitisk"},
		{"nitton", "nitton"},
		{"nittonde", "nittond"},
		{"nittonåriga", "nittonår"},
		{"njuratalg", "njuratalg"},
		{"njut", "njut"},
		{"njuta", "njut"},
		{"njutande", "njut"},
		{"njuter", "njut"},
		{"njutit", "njutit"},
		{"njutning", "njutning"},
		{"njutningen", "njutning"},
		{"njutningens", "njutning"},
		{"njutningsfullt", "njutningsfull"},
		{"njöt", "njöt"},
		{"njöto", "njöto"},
		{"nk", "nk"},
		{"nlan", "nlan"},
		{"nm", "nm"},
		{"nn", "nn"},
		{"nnan", "nnan"},
		{"nnelankoliskt", "nnelankolisk"},
		{"nninnen", "nninn"},
		{"no", "no"},
		{"noak", "noak"},
		{"nobel", "nobel"},
		{"nobelt", "nobelt"},
		{"nobla", "nobl"},
		{"noblaste", "nobl"},
		{"nobless", "nobless"},
		{"nocturne", "nocturn"},
		{"nog", "nog"},
		{"noga", "nog"},
		{"noggrann", "noggran"},
		{"noggranna", "noggran"},
		{"noggrannhet", "noggran"},
		{"noggrant", "noggrant"},
		{"nogräknad", "nogräkn"},
		{"nogräknade", "nogräkn"},
		{"nolla", "noll"},
		{"nom", "nom"},
		{"nomi", "nomi"},
		{"non", "non"},
		{"nonchalant", "nonchalant"},
		{"nonsens", "nons"},
		{"nordan", "nordan"},
		{"nordenflycht", "nordenflycht"},
		{"nordens", "nord"},
		{"nordiska", "nordisk"},
		{"nordstjärnan", "nordstjärnan"},
		{"nordstjärneriddare", "nordstjärnerid"},
		{"nordvest", "nordvest"},
		{"nordväst", "nordväst"},
		{"nordvästans", "nordvästan"},
		{"nordösten", "nordöst"},
		{"norge", "norg"},
		{"normala", "normal"},
		{"norman", "norman"},
		{"normans", "norman"},
		{"normant", "normant"},
		{"norr", "norr"},
		{"norrbacka", "norrback"},
		{"norrbackaläckerheterna", "norrbackaläcker"},
		{"norrbro", "norrbro"},
		{"norrköping", "norrköping"},
		{"norrland", "norrland"},
		{"norrländska", "norrländsk"},
		{"norrmalmstorg", "norrmalmstorg"},
		{"norrmännen", "norrmän"},
		{"norrström", "norrström"},
		{"norrtull", "norrtull"},
		{"norskt", "norsk"},
		{"nos", "nos"},
		{"nosade", "nos"},
		{"nosande", "nos"},
		{"nosar", "nos"},
		{"nosen", "nos"},
		{"noster", "nost"},
		{"not", "not"},
		{"nota", "not"},
		{"notabiliteternas", "notabilitet"},
		{"notarie", "notari"},
		{"notarien", "notari"},
		{"notariens", "notari"},
		{"notarieus", "notarieus"},
		{"notatien", "notati"},
		{"notificerande", "notificer"},
		{"notis", "notis"},
		{"notisen", "notis"},
		{"notiser", "notis"},
		{"notoriska", "notorisk"},
		{"notre", "notr"},
		{"nous", "nous"},
		{"noveller", "novell"},
		{"novellförfattare", "novellförfat"},
		{"november", "novemb"},
		{"novemberdag", "novemberdag"},
		{"nr", "nr"},
		{"nste", "nste"},
		{"ntya", "ntya"},
		{"ntötte", "ntött"},
		{"nu", "nu"},
		{"nuet", "nuet"},
		{"nuft", "nuft"},
		{"nuftet", "nuftet"},
		{"nuförtiden", "nuförtid"},
		{"numera", "numer"},
		{"nummer", "numm"},
		{"nummerplåt", "nummerplåt"},
		{"nurna", "nurn"},
		{"nutid", "nutid"},
		{"nuvarande", "nuvar"},
		{"nvts", "nvts"},
		{"ny", "ny"},
		{"nya", "nya"},
		{"nyans", "nyan"},
		{"nyanser", "nyans"},
		{"nyare", "nyar"},
		{"nyaste", "nyast"},
		{"nyck", "nyck"},
		{"nyckel", "nyckel"},
		{"nyckelhål", "nyckelhål"},
		{"nyckelhålet", "nyckelhålet"},
		{"nyckeln", "nyckeln"},
		{"nycken", "nyck"},
		{"nycker", "nyck"},
		{"nyckfull", "nyckfull"},
		{"nyckfulla", "nyckfull"},
		{"nydukade", "nyduk"},
		{"nye", "nye"},
		{"nyfallen", "nyfall"},
		{"nyfiken", "nyfik"},
		{"nyfikenhet", "nyfiken"},
		{"nyfikenheten", "nyfiken"},
		{"nyfiket", "nyfiket"},
		{"nyfikna", "nyfikn"},
		{"nyfrälsta", "nyfrälst"},
		{"nyfärgat", "nyfärg"},
		{"nyfödd", "nyföd"},
		{"nyfödda", "nyföd"},
		{"nyföddas", "nyföd"},
		{"nyförlovade", "nyförlov"},
		{"nyfött", "nyföt"},
		{"nygatan", "nygatan"},
		{"nygifta", "nygift"},
		{"nyhet", "nyhet"},
		{"nyheten", "nyhet"},
		{"nyhetens", "nyhet"},
		{"nyheter", "nyhet"},
		{"nykomling", "nykomling"},
		{"nykommen", "nykomm"},
		{"nykomna", "nykomn"},
		{"nykomnas", "nykomn"},
		{"nykter", "nykt"},
		{"nykterhetskalv", "nykterhetskalv"},
		{"nykterhetsskrifter", "nykterhetsskrift"},
		{"nyktert", "nyktert"},
		{"nyktigam", "nyktigam"},
		{"nyktra", "nyktr"},
		{"nyktre", "nyktr"},
		{"nyligen", "nyl"},
		{"nymf", "nymf"},
		{"nymfens", "nymf"},
		{"nymodiga", "nymod"},
		{"nynna", "nynn"},
		{"nynnande", "nynn"},
		{"nyo", "nyo"},
		{"nyomvända", "nyomvänd"},
		{"nypa", "nyp"},
		{"nyper", "nyp"},
		{"nypon", "nypon"},
		{"nys", "nys"},
		{"nysilverbricka", "nysilverbrick"},
		{"nyskurade", "nyskur"},
		{"nyskurat", "nyskur"},
		{"nyss", "nyss"},
		{"nystade", "nyst"},
		{"nystan", "nystan"},
		{"nystfot", "nystfot"},
		{"nystrukna", "nystrukn"},
		{"nystädat", "nystäd"},
		{"nystärkt", "nystärk"},
		{"nytra", "nytr"},
		{"nytt", "nytt"},
		{"nytta", "nytt"},
		{"nyttan", "nyttan"},
		{"nyttfödd", "nyttföd"},
		{"nyttig", "nytt"},
		{"nyttiga", "nytt"},
		{"nyttigare", "nytt"},
		{"nyttigt", "nytt"},
		{"nyttja", "nyttj"},
		{"nyttjade", "nyttj"},
		{"nyttjande", "nyttj"},
		{"nyttjas", "nyttj"},
		{"nytända", "nytänd"},
		{"nyvunna", "nyvun"},
		{"nyväckta", "nyväck"},
		{"nyåret", "nyåret"},
		{"nyårsafton", "nyårsafton"},
		{"nyårsny", "nyårsny"},
		{"näbb", "näbb"},
		{"näbbar", "näbb"},
		{"näbben", "näbb"},
		{"näbbig", "näbb"},
		{"näbbiga", "näbb"},
		{"näckblad", "näckbl"},
		{"näckens", "näck"},
		{"näekros", "näekro"},
		{"näm", "näm"},
		{"nämde", "nämd"},
		{"nämlande", "näml"},
		{"nämligen", "näm"},
		{"nämn", "nämn"},
		{"nämna", "nämn"},
		{"nämnas", "nämn"},
		{"nämnd", "nämnd"},
		{"nämnda", "nämnd"},
		{"nämnde", "nämnd"},
		{"nämndemanslika", "nämndemanslik"},
		{"nämner", "nämn"},
		{"nämnt", "nämnt"},
		{"nämnvärd", "nämnvärd"},
		{"nämt", "nämt"},
		{"nändes", "nänd"},
		{"näpst", "näpst"},
		{"när", "när"},
		{"nära", "när"},
		{"närande", "när"},
		{"närapa", "närap"},
		{"närapå", "närapå"},
		{"närbeläget", "närbeläget"},
		{"närd", "närd"},
		{"närda", "närd"},
		{"närde", "närd"},
		{"närgånget", "närgånget"},
		{"närhet", "när"},
		{"närheten", "när"},
		{"näring", "näring"},
		{"näringsgrenar", "näringsgren"},
		{"näringsämnet", "näringsämnet"},
		{"närke", "närk"},
		{"närma", "närm"},
		{"närmade", "närm"},
		{"närmande", "närm"},
		{"närmar", "närm"},
		{"närmare", "närm"},
		{"närmast", "närm"},
		{"närmaste", "närm"},
		{"närmat", "närm"},
		{"närmre", "närmr"},
		{"närnnda", "närnnd"},
		{"närsynt", "närsynt"},
		{"närsynta", "närsynt"},
		{"närt", "närt"},
		{"närvarande", "närvar"},
		{"närvarandes", "närvar"},
		{"närvaro", "närvaro"},
		{"närvaron", "närvaron"},
		{"näsa", "näs"},
		{"näsan", "näsan"},
		{"näsbenet", "näsbenet"},
		{"näsborrar", "näsborr"},
		{"näsborrarna", "näsborr"},
		{"näsduk", "näsduk"},
		{"näsdukar", "näsduk"},
		{"näsdukarna", "näsduk"},
		{"näsduken", "näsduk"},
		{"näsdukssnibben", "näsdukssnibb"},
		{"näsor", "näs"},
		{"näspärla", "näspärl"},
		{"näst", "näst"},
		{"nästa", "näst"},
		{"nästan", "nästan"},
		{"näste", "näst"},
		{"nästena", "nästen"},
		{"nästföljande", "nästfölj"},
		{"nästipp", "nästipp"},
		{"nästkommande", "nästkomm"},
		{"nästnn", "nästn"},
		{"näsvis", "näsvis"},
		{"näsvisa", "näsvis"},
		{"näsvisare", "näsvis"},
		{"näsvise", "näsvis"},
		{"näsvishet", "näsvis"},
		{"näsvist", "näsvist"},
		{"nät", "nät"},
		{"nätet", "nätet"},
		{"nätets", "nätet"},
		{"näthinnor", "näthin"},
		{"nätt", "nätt"},
		{"nätta", "nätt"},
		{"nättaste", "nätt"},
		{"nätter", "nätt"},
		{"nätterna", "nätt"},
		{"nätters", "nätter"},
		{"nävar", "näv"},
		{"näve", "näv"},
		{"näven", "näv"},
		{"nå", "nå"},
		{"nåd", "nåd"},
		{"nådde", "nådd"},
		{"nådenes", "nåden"},
		{"nådens", "nåd"},
		{"nåder", "nåd"},
		{"nådesmulor", "nådesmul"},
		{"nådetiden", "nådetid"},
		{"nådig", "nåd"},
		{"nådiga", "nåd"},
		{"nådige", "nåd"},
		{"nådigt", "nåd"},
		{"någml", "någml"},
		{"någo", "någo"},
		{"någon", "någon"},
		{"någondera", "någonder"},
		{"någons", "någon"},
		{"någonsin", "någonsin"},
		{"någonstades", "någonst"},
		{"någonstans", "någonstan"},
		{"någonstädes", "någonstäd"},
		{"någonstådes", "någonståd"},
		{"någonting", "någonting"},
		{"någorlunda", "någorlund"},
		{"någorstädes", "någorstäd"},
		{"något", "något"},
		{"någotdera", "någotder"},
		{"några", "någr"},
		{"nåidge", "nåidg"},
		{"nålar", "nål"},
		{"nålen", "nål"},
		{"nånsin", "nånsin"},
		{"når", "når"},
		{"nås", "nås"},
		{"nått", "nått"},
		{"nåväl", "nåväl"},
		{"nöd", "nöd"},
		{"nödd", "nödd"},
		{"nöden", "nöd"},
		{"nödens", "nöd"},
		{"nödfall", "nödfall"},
		{"nödgade", "nödg"},
		{"nödgades", "nödg"},
		{"nödgas", "nödg"},
		{"nödgats", "nödgat"},
		{"nödiga", "nöd"},
		{"nödigt", "nöd"},
		{"nödrop", "nödrop"},
		{"nödsakad", "nödsak"},
		{"nödställds", "nödställd"},
		{"nödtorftigt", "nödtorft"},
		{"nödtvång", "nödtvång"},
		{"nödvandigheten", "nödvand"},
		{"nödvändig", "nödvänd"},
		{"nödvändiga", "nödvänd"},
		{"nödvändigare", "nödvänd"},
		{"nödvändigaste", "nödvänd"},
		{"nödvändighet", "nödvänd"},
		{"nödvändigheten", "nödvänd"},
		{"nödvändighetens", "nödvänd"},
		{"nödvändighetsartiklar", "nödvändighetsartikl"},
		{"nödvändigt", "nödvänd"},
		{"nödvärn", "nödvärn"},
		{"nöja", "nöj"},
		{"nöjd", "nöjd"},
		{"nöjda", "nöjd"},
		{"nöjde", "nöjd"},
		{"nöje", "nöj"},
		{"nöjelse", "nöj"},
		{"nöjen", "nöj"},
		{"nöjena", "nöjen"},
		{"nöjer", "nöj"},
		{"nöjes", "nöj"},
		{"nöjet", "nöjet"},
		{"nöjs", "nöj"},
		{"nöjsam", "nöjsam"},
		{"nöp", "nöp"},
		{"nöt", "nöt"},
		{"nöter", "nöt"},
		{"nötkärna", "nötkärn"},
		{"nötning", "nötning"},
		{"nötta", "nött"},
		{"nötter", "nött"},
		{"o", "o"},
		{"oa", "oa"},
		{"oafbrutet", "oafbrutet"},
		{"oafgjordt", "oafgjord"},
		{"oaktadt", "oaktad"},
		{"oaktat", "oakt"},
		{"oanade", "oan"},
		{"oandligt", "oand"},
		{"oangripet", "oangripet"},
		{"oansenliga", "oansen"},
		{"oanständiga", "oanständ"},
		{"oanständigt", "oanständ"},
		{"oartig", "oart"},
		{"oartikuleradt", "oartikulerad"},
		{"oartikulerat", "oartikuler"},
		{"oavbruten", "oavbrut"},
		{"oavbrutet", "oavbrutet"},
		{"oavbrutna", "oavbrutn"},
		{"oavlåtligen", "oavlåt"},
		{"oavundade", "oavund"},
		{"oavvänt", "oavvänt"},
		{"obarmhärtigt", "obarmhärt"},
		{"obduktion", "obduktion"},
		{"obebyggda", "obebygg"},
		{"obegriplig", "obegrip"},
		{"obegripliga", "obegrip"},
		{"obegripligt", "obegrip"},
		{"obegränsade", "obegräns"},
		{"obehag", "obehag"},
		{"obehaget", "obehaget"},
		{"obehaglig", "obehag"},
		{"obehagliga", "obehag"},
		{"obehagligare", "obehag"},
		{"obehagligt", "obehag"},
		{"obehindradt", "obehindrad"},
		{"obehörig", "obehör"},
		{"obehöriga", "obehör"},
		{"obehövliga", "obehöv"},
		{"obekant", "obekant"},
		{"obekanta", "obekant"},
		{"obekantskapen", "obekantskap"},
		{"obekväma", "obekväm"},
		{"obekymrade", "obekymr"},
		{"obekymrat", "obekymr"},
		{"obelevad", "obelev"},
		{"obemärkt", "obemärk"},
		{"obenägen", "obenäg"},
		{"obenägenhet", "obenägen"},
		{"oberedd", "obered"},
		{"oberoende", "oberoend"},
		{"oberäknade", "oberäkn"},
		{"oberäknadt", "oberäknad"},
		{"oberäknat", "oberäkn"},
		{"oberäknelig", "oberäkne"},
		{"oberäkneligt", "oberäkne"},
		{"oberäknerliga", "oberäkner"},
		{"oberörd", "oberörd"},
		{"oberörda", "oberörd"},
		{"oberördhet", "oberörd"},
		{"oberört", "oberört"},
		{"obesatt", "obesat"},
		{"obeskedligt", "obesked"},
		{"obeskriflig", "obeskrif"},
		{"obeskrifliga", "obeskrif"},
		{"obeskrifligt", "obeskrif"},
		{"obeskrivlig", "obeskriv"},
		{"obeskrivliga", "obeskriv"},
		{"obeskrivligt", "obeskriv"},
		{"obeslutsam", "obeslutsam"},
		{"obeslutsamme", "obeslutsamm"},
		{"obestand", "obestand"},
		{"obestridliga", "obestrid"},
		{"obestämd", "obestämd"},
		{"obestämda", "obestämd"},
		{"obestämt", "obestämt"},
		{"obesvarade", "obesvar"},
		{"obesvärat", "obesvär"},
		{"obetingat", "obeting"},
		{"obetydlig", "obetyd"},
		{"obetydliga", "obetyd"},
		{"obetydligare", "obetyd"},
		{"obetydligaste", "obetyd"},
		{"obetydlige", "obetyd"},
		{"obetydlighet", "obetyd"},
		{"obetydligt", "obetyd"},
		{"obetänksam", "obetänksam"},
		{"obetänksamhet", "obetänksam"},
		{"obetänksamme", "obetänksamm"},
		{"obetänksamt", "obetänksamt"},
		{"obeveklig", "obevek"},
		{"obildad", "obild"},
		{"obildade", "obild"},
		{"obillig", "obil"},
		{"obilliga", "obil"},
		{"obilligt", "obil"},
		{"oblandad", "obland"},
		{"oblandadt", "oblandad"},
		{"obligeant", "obligeant"},
		{"obligera", "obliger"},
		{"oblyg", "oblyg"},
		{"oblyga", "oblyg"},
		{"oblygare", "oblyg"},
		{"oblyghet", "oblyg"},
		{"oblygt", "oblyg"},
		{"obotlig", "obot"},
		{"obotligt", "obot"},
		{"obrottslig", "obrotts"},
		{"obrukbart", "obrukbart"},
		{"observationer", "observation"},
		{"observera", "observer"},
		{"observerade", "observer"},
		{"observerades", "observer"},
		{"observerat", "observer"},
		{"obytt", "obyt"},
		{"obändiga", "obänd"},
		{"oböjliga", "oböj"},
		{"ocb", "ocb"},
		{"occh", "occh"},
		{"ocfi", "ocfi"},
		{"och", "och"},
		{"ock", "ock"},
		{"ockra", "ockr"},
		{"ockrå", "ockrå"},
		{"ocksa", "ocks"},
		{"ocksi", "ocksi"},
		{"också", "också"},
		{"ocl", "ocl"},
		{"odeciderad", "odecider"},
		{"odelad", "odel"},
		{"oderton", "oderton"},
		{"odh", "odh"},
		{"odjur", "odjur"},
		{"odjuren", "odjur"},
		{"odjuret", "odjuret"},
		{"odjurs", "odjur"},
		{"odla", "odl"},
		{"odlade", "odl"},
		{"odlarns", "odlarn"},
		{"odmjuk", "odmjuk"},
		{"odmjukt", "odmjuk"},
		{"odräg", "odräg"},
		{"odräglig", "odräg"},
		{"odrägliga", "odräg"},
		{"odräglige", "odräg"},
		{"odrägligt", "odräg"},
		{"odugliga", "odug"},
		{"odugligt", "odug"},
		{"odygd", "odyg"},
		{"odygdigt", "odygd"},
		{"odödlig", "odöd"},
		{"odödliga", "odöd"},
		{"odödlighet", "odöd"},
		{"odödligt", "odöd"},
		{"oeb", "oeb"},
		{"oeftertänksamma", "oeftertänksamm"},
		{"oegentligen", "oegent"},
		{"oeh", "oeh"},
		{"oeldadt", "oeldad"},
		{"oemotståndlig", "oemotstånd"},
		{"oemotståndligt", "oemotstånd"},
		{"oen", "oen"},
		{"oenothera", "oenother"},
		{"oer", "oer"},
		{"oerfaren", "oerf"},
		{"oerfarna", "oerf"},
		{"oerhörd", "oerhörd"},
		{"oerhörda", "oerhörd"},
		{"oerhördt", "oerhörd"},
		{"oerhört", "oerhört"},
		{"oersättliga", "oersätt"},
		{"of", "of"},
		{"ofantlig", "ofant"},
		{"ofantliga", "ofant"},
		{"ofantligt", "ofant"},
		{"ofarlig", "ofar"},
		{"ofattbara", "ofattbar"},
		{"ofelbara", "ofelbar"},
		{"ofelbart", "ofelbart"},
		{"offentliga", "offent"},
		{"offentligheten", "offent"},
		{"offentligt", "offent"},
		{"offer", "off"},
		{"offerdag", "offerdag"},
		{"officer", "offic"},
		{"officerare", "officer"},
		{"officershem", "officershem"},
		{"officianten", "officiant"},
		{"offra", "offr"},
		{"offrade", "offr"},
		{"offrat", "offr"},
		{"ofog", "ofog"},
		{"oformlig", "oform"},
		{"oformliga", "oform"},
		{"ofrid", "ofrid"},
		{"ofrivillig", "ofrivil"},
		{"ofrivilligt", "ofrivil"},
		{"ofruktbar", "ofruktb"},
		{"ofruktbara", "ofruktbar"},
		{"ofta", "oft"},
		{"oftare", "oft"},
		{"oftast", "oft"},
		{"ofullständigt", "ofullständ"},
		{"ofvan", "ofvan"},
		{"ofvanstående", "ofvanståend"},
		{"ofödda", "oföd"},
		{"oföddas", "oföd"},
		{"oförargliga", "oförarg"},
		{"oförberett", "oförberet"},
		{"ofördelaktiga", "ofördelakt"},
		{"ofördelaktigt", "ofördelakt"},
		{"oförenliga", "ofören"},
		{"oförfalskade", "oförfalsk"},
		{"oförfalskat", "oförfalsk"},
		{"oförfärat", "oförfär"},
		{"oförgiftade", "oförgift"},
		{"oförgripliga", "oförgrip"},
		{"oförhappandes", "oförhapp"},
		{"oförklarligt", "oförklar"},
		{"oförlåtliga", "oförlåt"},
		{"oförminskad", "oförminsk"},
		{"oförmodade", "oförmod"},
		{"oförmodadt", "oförmodad"},
		{"oförmodat", "oförmod"},
		{"oförmärkt", "oförmärk"},
		{"oförmåga", "oförmåg"},
		{"oförsigtighet", "oförsigt"},
		{"oförsiktighet", "oförsikt"},
		{"oförsiktigt", "oförsikt"},
		{"oförskräckt", "oförskräck"},
		{"oförskämd", "oförskämd"},
		{"oförskämda", "oförskämd"},
		{"oförskämdaste", "oförskämd"},
		{"oförskämdt", "oförskämd"},
		{"oförskämt", "oförskämt"},
		{"oförsonade", "oförson"},
		{"oförstäld", "oförstäld"},
		{"oförstående", "oförståend"},
		{"oförstånd", "oförstånd"},
		{"oförståndiga", "oförstånd"},
		{"oförsvarligt", "oförsvar"},
		{"oförsynt", "oförsynt"},
		{"oförsynta", "oförsynt"},
		{"oförsyntheten", "oförsynt"},
		{"oförsörjda", "oförsörjd"},
		{"oförtrutet", "oförtrutet"},
		{"oförtrutna", "oförtrutn"},
		{"oförtöfvadt", "oförtöfvad"},
		{"oförutsedd", "oförutsed"},
		{"oförvitlig", "oförvit"},
		{"oförvägen", "oförväg"},
		{"oförvägenhet", "oförvägen"},
		{"oförvägna", "oförvägn"},
		{"oförytterlig", "oförytter"},
		{"oga", "oga"},
		{"ogenerad", "ogener"},
		{"ogenerat", "ogener"},
		{"ogerna", "ogern"},
		{"ogerning", "ogerning"},
		{"ogift", "ogift"},
		{"ogifta", "ogift"},
		{"ogillade", "ogill"},
		{"ogillande", "ogill"},
		{"ogjorda", "ogjord"},
		{"ogon", "ogon"},
		{"ogonen", "ogon"},
		{"ogonlocken", "ogonlock"},
		{"ogonspringor", "ogonspring"},
		{"ograciös", "ograciös"},
		{"ogrannlaga", "ogrannlag"},
		{"ogrundad", "ogrund"},
		{"ogräset", "ogräset"},
		{"ogudaktigt", "ogudakt"},
		{"ogunst", "ogunst"},
		{"ogunstigt", "ogunst"},
		{"ogärna", "ogärn"},
		{"ogörligt", "ogör"},
		{"ohan", "ohan"},
		{"ohejdad", "ohejd"},
		{"ohejdade", "ohejd"},
		{"ohejdadt", "ohejdad"},
		{"ohelig", "ohe"},
		{"ohjelplige", "ohjelp"},
		{"ohjelpligen", "ohjelp"},
		{"ohjälplig", "ohjälp"},
		{"ohjälpliga", "ohjälp"},
		{"ohjälpligt", "ohjälp"},
		{"ohlea", "ohle"},
		{"oho", "oho"},
		{"ohygglig", "ohygg"},
		{"ohyggliga", "ohygg"},
		{"ohyggligt", "ohygg"},
		{"ohyra", "ohyr"},
		{"ohyvlade", "ohyvl"},
		{"ohöfviskt", "ohöfvisk"},
		{"ohöljt", "ohöljt"},
		{"ohörbar", "ohörb"},
		{"ohörbart", "ohörbart"},
		{"ohövlig", "ohöv"},
		{"ohövligt", "ohöv"},
		{"oid", "oid"},
		{"oigenkänliga", "oigenkän"},
		{"oinskränkt", "oinskränk"},
		{"oinskränkta", "oinskränk"},
		{"oiruktbar", "oiruktb"},
		{"ois", "ois"},
		{"oj", "oj"},
		{"ojemna", "ojemn"},
		{"ojämförligt", "ojämför"},
		{"ojämna", "ojämn"},
		{"ojämnt", "ojämnt"},
		{"ok", "ok"},
		{"oklart", "oklart"},
		{"oknarna", "okn"},
		{"oknytt", "oknyt"},
		{"okonstlade", "okonstl"},
		{"okroppsliga", "okropps"},
		{"okroppsligt", "okropps"},
		{"oktober", "oktob"},
		{"oktoberskymningen", "oktoberskymning"},
		{"okultiverad", "okultiver"},
		{"okunnig", "okunn"},
		{"okunniga", "okunn"},
		{"okunnighet", "okunn"},
		{"okuvlig", "okuv"},
		{"okynne", "okyn"},
		{"okynnig", "okynn"},
		{"okynniga", "okynn"},
		{"okyska", "okysk"},
		{"okyskhetens", "okysk"},
		{"okänd", "okänd"},
		{"okända", "okänd"},
		{"okände", "okänd"},
		{"okänslig", "okäns"},
		{"okänt", "okänt"},
		{"oköpandes", "oköp"},
		{"ola", "ola"},
		{"olatet", "olatet"},
		{"oldsmobile", "oldsmobil"},
		{"olidlig", "olid"},
		{"olidliga", "olid"},
		{"olidligaste", "olid"},
		{"olidligt", "olid"},
		{"olik", "olik"},
		{"olika", "olik"},
		{"olikfärgade", "olikfärg"},
		{"olikt", "olik"},
		{"oliver", "oliv"},
		{"olivgul", "olivgul"},
		{"olivlund", "olivlund"},
		{"olja", "olj"},
		{"oljat", "olj"},
		{"oljefärg", "oljefärg"},
		{"oljekläder", "oljekläd"},
		{"oljelampan", "oljelampan"},
		{"oljelampor", "oljelamp"},
		{"oljelamporna", "oljelamp"},
		{"oljelampornas", "oljelamp"},
		{"oljud", "oljud"},
		{"olle", "oll"},
		{"olmströms", "olmström"},
		{"oloflig", "olof"},
		{"ologiskt", "ologisk"},
		{"olovliga", "olov"},
		{"olssons", "olsson"},
		{"olust", "olust"},
		{"olustig", "olust"},
		{"olustkänslor", "olustkänsl"},
		{"olyck", "olyck"},
		{"olycka", "olyck"},
		{"olyckan", "olyckan"},
		{"olyckas", "olyck"},
		{"olycklig", "olyck"},
		{"olyckliga", "olyck"},
		{"olyckligare", "olyck"},
		{"olycklige", "olyck"},
		{"olyckligt", "olyck"},
		{"olyckligtvis", "olyckligtvis"},
		{"olyckor", "olyck"},
		{"olyckorna", "olyck"},
		{"olycks", "olyck"},
		{"olycksaliga", "olycksa"},
		{"olycksaningar", "olycksaning"},
		{"olycksbådande", "olycksbåd"},
		{"olycksdagen", "olycksdag"},
		{"olyckshändelsen", "olyckshänd"},
		{"olyckshändelser", "olyckshänd"},
		{"olyckshändelserna", "olyckshänd"},
		{"olycksskräcken", "olycksskräck"},
		{"olycksöde", "olycksöd"},
		{"olydig", "olyd"},
		{"olydnad", "olydn"},
		{"olympiska", "olympisk"},
		{"olyska", "olysk"},
		{"olägenheter", "olägen"},
		{"olägligt", "oläg"},
		{"olåten", "olåt"},
		{"olösligt", "olös"},
		{"olösta", "olöst"},
		{"om", "om"},
		{"omaka", "omak"},
		{"omaket", "omaket"},
		{"omanligt", "oman"},
		{"ombedd", "ombed"},
		{"ombilda", "ombild"},
		{"ombord", "ombord"},
		{"ombre", "ombr"},
		{"ombunden", "ombund"},
		{"ombyta", "ombyt"},
		{"ombyte", "ombyt"},
		{"ombytes", "ombyt"},
		{"ombytte", "ombyt"},
		{"omdöme", "omdöm"},
		{"omedelbar", "omedelb"},
		{"omedelbart", "omedelbart"},
		{"omedgörlig", "omedgör"},
		{"omedgörligaste", "omedgör"},
		{"omedveten", "omedvet"},
		{"omedvetet", "omedvetet"},
		{"omedvetna", "omedvetn"},
		{"omelett", "omelet"},
		{"omen", "omen"},
		{"omfamna", "omfamn"},
		{"omfamnande", "omfamn"},
		{"omfamningar", "omfamning"},
		{"omfara", "omfar"},
		{"omfatta", "omfat"},
		{"omfattas", "omfat"},
		{"omflutet", "omflutet"},
		{"omfång", "omfång"},
		{"omfånget", "omfånget"},
		{"omförmäla", "omförmäl"},
		{"omgaf", "omgaf"},
		{"omgav", "omgav"},
		{"omgifning", "omgifning"},
		{"omgifnings", "omgifning"},
		{"omgift", "omgift"},
		{"omgifven", "omgifv"},
		{"omgivande", "omgiv"},
		{"omgiven", "omgiv"},
		{"omgivet", "omgivet"},
		{"omgivning", "omgivning"},
		{"omgivningarna", "omgivning"},
		{"omgjorda", "omgjord"},
		{"omgjordad", "omgjord"},
		{"omgjort", "omgjort"},
		{"omgång", "omgång"},
		{"omgåvo", "omgåvo"},
		{"omhägnad", "omhägn"},
		{"omhängen", "omhäng"},
		{"omigen", "omig"},
		{"omild", "omild"},
		{"omildt", "omild"},
		{"omisskänlig", "omisskän"},
		{"omisskänliga", "omisskän"},
		{"omisskänligaste", "omisskän"},
		{"omisskänligt", "omisskän"},
		{"omisskänneligt", "omisskänne"},
		{"omisskännligt", "omisskänn"},
		{"omisstänksamma", "omisstänksamm"},
		{"omisstänksamme", "omisstänksamm"},
		{"omklädd", "omkläd"},
		{"omklädseln", "omklädseln"},
		{"omklädt", "omkläd"},
		{"omknutet", "omknutet"},
		{"omkomma", "omkomm"},
		{"omkommit", "omkommit"},
		{"omkrets", "omkret"},
		{"omkrh", "omkrh"},
		{"omkring", "omkring"},
		{"omkringströdda", "omkringströd"},
		{"omkriug", "omkriug"},
		{"omkull", "omkull"},
		{"omle", "oml"},
		{"omlindat", "omlind"},
		{"omlopp", "omlopp"},
		{"omläggning", "omläggning"},
		{"ommöblerad", "ommöbler"},
		{"omnibus", "omnibus"},
		{"omnibusarna", "omnibus"},
		{"omnibusarnas", "omnibus"},
		{"omnämda", "omnämd"},
		{"omnämna", "omnämn"},
		{"omnämnandet", "omnämn"},
		{"omnämnda", "omnämnd"},
		{"omnämnde", "omnämnd"},
		{"omnämndes", "omnämnd"},
		{"omodern", "omod"},
		{"omoralisk", "omoralisk"},
		{"omotiverade", "omotiver"},
		{"omotiverat", "omotiver"},
		{"omringa", "omring"},
		{"område", "områd"},
		{"områden", "områd"},
		{"området", "området"},
		{"omsade", "oms"},
		{"omsider", "omsid"},
		{"omskrivningar", "omskrivning"},
		{"omslag", "omslag"},
		{"omslingrad", "omslingr"},
		{"omslutna", "omslutn"},
		{"omslöt", "omslöt"},
		{"omsorg", "omsorg"},
		{"omsorgen", "omsorg"},
		{"omsorger", "omsorg"},
		{"omsorgsfulla", "omsorgsfull"},
		{"omsorgsfullt", "omsorgsfull"},
		{"omspände", "omspänd"},
		{"omstuvning", "omstuvning"},
		{"omstän", "omstän"},
		{"omständighet", "omständ"},
		{"omständigheten", "omständ"},
		{"omständigheter", "omständ"},
		{"omständigheterna", "omständ"},
		{"omstörta", "omstört"},
		{"omstörtningen", "omstörtning"},
		{"omsvep", "omsvep"},
		{"omsvepa", "omsvep"},
		{"omsvepande", "omsvep"},
		{"omsvärmad", "omsvärm"},
		{"omsvävade", "omsväv"},
		{"omsägande", "omsäg"},
		{"omtala", "omtal"},
		{"omtalade", "omtal"},
		{"omtalar", "omtal"},
		{"omtalas", "omtal"},
		{"omtalta", "omtalt"},
		{"omtanke", "omtank"},
		{"omtuggade", "omtugg"},
		{"omtumlad", "omtuml"},
		{"omtvistade", "omtvist"},
		{"omtyckt", "omtyck"},
		{"omtyckta", "omtyck"},
		{"omtänksamhet", "omtänksam"},
		{"omtänksamma", "omtänksamm"},
		{"omtåliga", "omtå"},
		{"omutlig", "omut"},
		{"omvanda", "omvand"},
		{"omväg", "omväg"},
		{"omvägar", "omväg"},
		{"omvända", "omvänd"},
		{"omvände", "omvänd"},
		{"omvändelse", "omvänd"},
		{"omvändt", "omvänd"},
		{"omvärvas", "omvärv"},
		{"omvärvd", "omvärvd"},
		{"omväxling", "omväxling"},
		{"omvårdnad", "omvårdn"},
		{"omänskligt", "omänsk"},
		{"omärklig", "omärk"},
		{"omärkligen", "omärk"},
		{"omärkligt", "omärk"},
		{"omätliga", "omät"},
		{"omätligt", "omät"},
		{"omättliga", "omätt"},
		{"omöjlig", "omöj"},
		{"omöjliga", "omöj"},
		{"omöjligare", "omöj"},
		{"omöjligaste", "omöj"},
		{"omöjligen", "omöj"},
		{"omöjlighet", "omöj"},
		{"omöjligheten", "omöj"},
		{"omöjligt", "omöj"},
		{"on", "on"},
		{"onaturlig", "onatur"},
		{"onaturliga", "onatur"},
		{"onaturligt", "onatur"},
		{"ond", "ond"},
		{"onda", "ond"},
		{"onde", "ond"},
		{"ondo", "ondo"},
		{"ondska", "ondsk"},
		{"ondskefull", "ondskefull"},
		{"ondskefulla", "ondskefull"},
		{"ondskefullt", "ondskefull"},
		{"ondt", "ondt"},
		{"onekligen", "onek"},
		{"onkel", "onkel"},
		{"onkels", "onkel"},
		{"onsdag", "onsdag"},
		{"onsdagen", "onsdag"},
		{"onsdagsafton", "onsdagsafton"},
		{"ont", "ont"},
		{"onus", "onus"},
		{"onytta", "onyt"},
		{"onyttig", "onytt"},
		{"onämnbart", "onämnbart"},
		{"onådigt", "onåd"},
		{"onödig", "onöd"},
		{"onödiga", "onöd"},
		{"onödigt", "onöd"},
		{"onödigtvis", "onödigtvis"},
		{"ooh", "ooh"},
		{"oombedd", "oombed"},
		{"oora", "oor"},
		{"oord", "oord"},
		{"oordnade", "oordn"},
		{"oordnat", "oordn"},
		{"oordning", "oordning"},
		{"opaler", "opal"},
		{"opassamde", "opassamd"},
		{"opassande", "opass"},
		{"opasslighet", "opass"},
		{"opel", "opel"},
		{"opera", "oper"},
		{"operabalett", "operabalet"},
		{"operan", "operan"},
		{"operation", "operation"},
		{"operera", "operer"},
		{"opereras", "operer"},
		{"operor", "oper"},
		{"opinionen", "opinion"},
		{"opp", "opp"},
		{"oppen", "opp"},
		{"opplimens", "opplim"},
		{"opröfvadt", "opröfvad"},
		{"opåräknad", "opåräkn"},
		{"opåräknade", "opåräkn"},
		{"opåräknat", "opåräkn"},
		{"opåtalt", "opåtalt"},
		{"or", "or"},
		{"ora", "ora"},
		{"orakad", "orak"},
		{"orakel", "orakel"},
		{"orangeriet", "orangeriet"},
		{"orangutang", "orangutang"},
		{"orcn", "orcn"},
		{"ord", "ord"},
		{"ordagrant", "ordagrant"},
		{"ordalag", "ordalag"},
		{"ordat", "ord"},
		{"ordbyte", "ordbyt"},
		{"orden", "ord"},
		{"ordens", "ord"},
		{"ordensband", "ordensband"},
		{"ordentlig", "ordent"},
		{"ordentliga", "ordent"},
		{"ordentlighet", "ordent"},
		{"ordentligt", "ordent"},
		{"order", "ord"},
		{"ordet", "ordet"},
		{"ordets", "ordet"},
		{"ordflöde", "ordflöd"},
		{"ordföranden", "ordför"},
		{"ordinarier", "ordinari"},
		{"ordinarierna", "ordinari"},
		{"ordination", "ordination"},
		{"ordinär", "ordinär"},
		{"ordlekarna", "ordlek"},
		{"ordna", "ordn"},
		{"ordnad", "ordn"},
		{"ordnade", "ordn"},
		{"ordnande", "ordn"},
		{"ordnar", "ordn"},
		{"ordnat", "ordn"},
		{"ordning", "ordning"},
		{"ordningen", "ordning"},
		{"ordrikhet", "ordrik"},
		{"ords", "ord"},
		{"ordspråk", "ordspråk"},
		{"ordspråket", "ordspråket"},
		{"ordspråksvisdom", "ordspråksvisdom"},
		{"ordström", "ordström"},
		{"oreda", "ored"},
		{"oredan", "oredan"},
		{"oredig", "ored"},
		{"orediga", "ored"},
		{"oredighet", "ored"},
		{"oredigt", "ored"},
		{"oregelbunden", "oregelbund"},
		{"oregelbundenhet", "oregelbunden"},
		{"oren", "oren"},
		{"orena", "oren"},
		{"orenhet", "oren"},
		{"orenhets", "orenhet"},
		{"orenlighet", "oren"},
		{"orenom", "orenom"},
		{"orerade", "orer"},
		{"oresonhga", "oresonhg"},
		{"oresonlig", "oreson"},
		{"organ", "organ"},
		{"organiserade", "organiser"},
		{"organiskt", "organisk"},
		{"organist", "organist"},
		{"orgel", "orgel"},
		{"orgelhus", "orgelhus"},
		{"orgelmusik", "orgelmusik"},
		{"orgelmusiken", "orgelmusik"},
		{"orgeln", "orgeln"},
		{"orgelns", "orgeln"},
		{"orgelo", "orgelo"},
		{"orgelomsusade", "orgelomsus"},
		{"orglar", "orgl"},
		{"orgorna", "org"},
		{"orgverk", "orgverk"},
		{"orh", "orh"},
		{"orienterad", "orienter"},
		{"original", "original"},
		{"originalspråket", "originalspråket"},
		{"originalutgåvan", "originalutgåvan"},
		{"originell", "originell"},
		{"oriktigt", "orikt"},
		{"orimlig", "orim"},
		{"orimlighet", "orim"},
		{"orimligheter", "orim"},
		{"orimligt", "orim"},
		{"orka", "ork"},
		{"orkade", "ork"},
		{"orkan", "orkan"},
		{"orkanen", "orkan"},
		{"orkanerna", "orkan"},
		{"orkar", "ork"},
		{"orkat", "ork"},
		{"orkestern", "orkest"},
		{"orkesterns", "orkest"},
		{"orkide", "orkid"},
		{"orkideer", "orkide"},
		{"orklös", "orklös"},
		{"orlofssedel", "orlofssedel"},
		{"orlov", "orlov"},
		{"orlovssedel", "orlovssedel"},
		{"orm", "orm"},
		{"ormar", "orm"},
		{"ormdrömmar", "ormdrömm"},
		{"ormen", "orm"},
		{"ormligt", "orm"},
		{"ormskinn", "ormskin"},
		{"ormständighet", "ormständ"},
		{"ormständigheter", "ormständ"},
		{"oro", "oro"},
		{"oroa", "oro"},
		{"oroad", "oro"},
		{"oroade", "oro"},
		{"oroades", "oro"},
		{"oroande", "oro"},
		{"oroar", "oro"},
		{"oroas", "oro"},
		{"oroat", "oro"},
		{"oroats", "oroat"},
		{"orolig", "oro"},
		{"oroliga", "oro"},
		{"oroligare", "oro"},
		{"orolige", "oro"},
		{"oroligt", "oro"},
		{"oron", "oron"},
		{"orons", "oron"},
		{"orrspel", "orrspel"},
		{"orsak", "orsak"},
		{"orsakade", "orsak"},
		{"orsaken", "orsak"},
		{"orsaker", "orsak"},
		{"orsakskedjan", "orsakskedjan"},
		{"ort", "ort"},
		{"orten", "ort"},
		{"ortodox", "ortodox"},
		{"ortstidning", "ortstidning"},
		{"orubbad", "orubb"},
		{"orubbat", "orubb"},
		{"orubbliga", "orubb"},
		{"orubbligt", "orubb"},
		{"oryggliga", "orygg"},
		{"oräkneliga", "oräkne"},
		{"orätt", "orät"},
		{"orättvis", "orättvis"},
		{"orättvisa", "orättvis"},
		{"orättvisan", "orättvisan"},
		{"orättvist", "orättvist"},
		{"oråd", "oråd"},
		{"orådet", "orådet"},
		{"orör", "orör"},
		{"orörd", "orörd"},
		{"orörda", "orörd"},
		{"orörlig", "orör"},
		{"orörliga", "orör"},
		{"orörligt", "orör"},
		{"osa", "osa"},
		{"osalig", "osa"},
		{"osaligt", "osa"},
		{"osams", "osam"},
		{"osanning", "osanning"},
		{"osanningar", "osanning"},
		{"osanningen", "osanning"},
		{"osannolik", "osannolik"},
		{"osborn", "osborn"},
		{"osedd", "osed"},
		{"osedda", "osed"},
		{"osedligheten", "osed"},
		{"oskadlig", "oskad"},
		{"oskadliga", "oskad"},
		{"oskalad", "oskal"},
		{"oskattbara", "oskattbar"},
		{"oskicklig", "oskick"},
		{"oskiljaktiga", "oskiljakt"},
		{"oskrivna", "oskrivn"},
		{"oskuld", "oskuld"},
		{"oskulds", "oskuld"},
		{"oskyldig", "oskyld"},
		{"oskyldiga", "oskyld"},
		{"oskyldighetens", "oskyld"},
		{"oskyldigt", "oskyld"},
		{"oskönt", "oskönt"},
		{"osmakliga", "osmak"},
		{"osnygghet", "osnygg"},
		{"ospard", "ospard"},
		{"ospätt", "ospät"},
		{"oss", "oss"},
		{"ostindiska", "ostindisk"},
		{"ostkupa", "ostkup"},
		{"ostron", "ostron"},
		{"osttransporten", "osttransport"},
		{"ostyrig", "ostyr"},
		{"ostyriga", "ostyr"},
		{"ostyrige", "ostyr"},
		{"ostörd", "ostörd"},
		{"ostörda", "ostörd"},
		{"ostört", "ostört"},
		{"osund", "osund"},
		{"osunda", "osund"},
		{"osvald", "osvald"},
		{"osvikligt", "osvik"},
		{"osviva", "osviv"},
		{"osympatiskt", "osympatisk"},
		{"osyn", "osyn"},
		{"osynlig", "osyn"},
		{"osynliga", "osyn"},
		{"osäkerhet", "osäker"},
		{"osäkert", "osäkert"},
		{"osäkra", "osäkr"},
		{"otack", "otack"},
		{"otackad", "otack"},
		{"otacksam", "otacksam"},
		{"otacksammaste", "otacksamm"},
		{"otacksamme", "otacksamm"},
		{"otacksamt", "otacksamt"},
		{"otaheiti", "otaheiti"},
		{"otaliga", "ota"},
		{"otaligt", "ota"},
		{"otalt", "otalt"},
		{"otanes", "otan"},
		{"otid", "otid"},
		{"otillbörliga", "otillbör"},
		{"otillbörligt", "otillbör"},
		{"otillfreds", "otillfred"},
		{"otillfredsställd", "otillfredsställd"},
		{"otillfredsställda", "otillfredsställd"},
		{"otillfredsställt", "otillfredsställt"},
		{"otillgänglig", "otillgäng"},
		{"otillgängliga", "otillgäng"},
		{"otillgängligt", "otillgäng"},
		{"otillräcklig", "otillräck"},
		{"otillräckligt", "otillräck"},
		{"otillständiga", "otillständ"},
		{"otjenst", "otjenst"},
		{"otjensten", "otjenst"},
		{"otjänliga", "otjän"},
		{"otrevlig", "otrev"},
		{"otrevligaste", "otrev"},
		{"otrevligt", "otrev"},
		{"otro", "otro"},
		{"otrogcn", "otrogcn"},
		{"otrogen", "otrog"},
		{"otrogna", "otrogn"},
		{"otrogne", "otrogn"},
		{"otrohet", "otro"},
		{"otrolig", "otro"},
		{"otroliga", "otro"},
		{"otroligt", "otro"},
		{"otthard", "otthard"},
		{"ottomanen", "ottoman"},
		{"otukten", "otuk"},
		{"otuktiga", "otukt"},
		{"otur", "otur"},
		{"oturen", "otur"},
		{"otvifvelaktigt", "otvifvelakt"},
		{"otvivelaktigt", "otvivelakt"},
		{"otvungenhet", "otvungen"},
		{"otydbara", "otydbar"},
		{"otydlig", "otyd"},
		{"otydliga", "otyd"},
		{"otydligt", "otyd"},
		{"otyg", "otyg"},
		{"otyget", "otyget"},
		{"otyglad", "otygl"},
		{"otympligt", "otymp"},
		{"otäck", "otäck"},
		{"otäcka", "otäck"},
		{"otäckaste", "otäck"},
		{"otäckheter", "otäck"},
		{"otäckt", "otäck"},
		{"otänkbara", "otänkbar"},
		{"otänkbart", "otänkbart"},
		{"otålig", "otå"},
		{"otåliga", "otå"},
		{"otåligare", "otå"},
		{"otålige", "otå"},
		{"otålighet", "otå"},
		{"otåligt", "otå"},
		{"otörstig", "otörst"},
		{"otörstlg", "otörstlg"},
		{"oumbärligaste", "oumbär"},
		{"oundgänglig", "oundgäng"},
		{"oundgängliga", "oundgäng"},
		{"oundgängligaste", "oundgäng"},
		{"oundvikliga", "oundvik"},
		{"oundvikligt", "oundvik"},
		{"oupphörligen", "oupphör"},
		{"oupphörligt", "oupphör"},
		{"oupptaget", "oupptaget"},
		{"outgrundlig", "outgrund"},
		{"outgrundligt", "outgrund"},
		{"outhärdlig", "outhärd"},
		{"outhärdliga", "outhärd"},
		{"outhärdligt", "outhärd"},
		{"outplånligt", "outplån"},
		{"outrannsakligt", "outrannsak"},
		{"outredda", "outred"},
		{"outrotliga", "outrot"},
		{"outsläcklig", "outsläck"},
		{"outsläckligt", "outsläck"},
		{"outsäglig", "outsäg"},
		{"outsägliga", "outsäg"},
		{"outsägligt", "outsäg"},
		{"outtröttlig", "outtrött"},
		{"outtröttliga", "outtrött"},
		{"outvecklad", "outveckl"},
		{"ovad", "ovad"},
		{"oval", "oval"},
		{"ovala", "oval"},
		{"ovan", "ovan"},
		{"ovana", "ovan"},
		{"ovanan", "ovanan"},
		{"ovanfor", "ovanf"},
		{"ovanför", "ovanför"},
		{"ovanlig", "ovan"},
		{"ovanliga", "ovan"},
		{"ovanlighetens", "ovan"},
		{"ovanligt", "ovan"},
		{"ovannämnda", "ovannämnd"},
		{"ovanpå", "ovanpå"},
		{"ovansklig", "ovansk"},
		{"ovant", "ovant"},
		{"ovaraktig", "ovarakt"},
		{"ovarsam", "ovarsam"},
		{"ovarsamt", "ovarsamt"},
		{"over", "over"},
		{"overklig", "overk"},
		{"overkligt", "overk"},
		{"overksam", "overksam"},
		{"overksamhet", "overksam"},
		{"overksamma", "overksamm"},
		{"overretade", "overret"},
		{"overseende", "overseend"},
		{"ovetande", "ovet"},
		{"ovett", "ovet"},
		{"ovidkommande", "ovidkomm"},
		{"ovigda", "ovig"},
		{"oviktig", "ovikt"},
		{"ovilja", "ovilj"},
		{"ovilkorligt", "ovilkor"},
		{"ovill", "ovill"},
		{"ovillkoiliga", "ovillkoi"},
		{"ovillkorligen", "ovillkor"},
		{"ovillkorligt", "ovillkor"},
		{"ovisa", "ovis"},
		{"oviss", "oviss"},
		{"ovisshet", "oviss"},
		{"ovissheten", "oviss"},
		{"ovisst", "ovisst"},
		{"oväder", "oväd"},
		{"oväderspiskade", "oväderspisk"},
		{"ovädrets", "ovädret"},
		{"ovälkomna", "ovälkomn"},
		{"ovälkomne", "ovälkomn"},
		{"ovän", "ovän"},
		{"ovänlig", "ovän"},
		{"ovänligt", "ovän"},
		{"ovänner", "ovän"},
		{"oväntad", "ovänt"},
		{"oväntade", "ovänt"},
		{"oväntat", "ovänt"},
		{"ovärderlig", "ovärder"},
		{"ovärdig", "ovärd"},
		{"ovärdige", "ovärd"},
		{"ovärdigt", "ovärd"},
		{"oväsentligheter", "oväsent"},
		{"oväsentligt", "oväsent"},
		{"oxar", "oxar"},
		{"oxars", "oxar"},
		{"oxbringan", "oxbringan"},
		{"oxe", "oxe"},
		{"oxel", "oxel"},
		{"oxköttet", "oxköttet"},
		{"oäkta", "oäkt"},
		{"oänd", "oänd"},
		{"oändlig", "oänd"},
		{"oändliga", "oänd"},
		{"oändlighet", "oänd"},
		{"oändligt", "oänd"},
		{"oäven", "oäv"},
		{"oåterkalleliga", "oåterkalle"},
		{"oåterkalleligen", "oåterkalle"},
		{"oåtkomlig", "oåtkom"},
		{"oöfverlagda", "oöfverlag"},
		{"oöfvervinnelig", "oöfvervinne"},
		{"oöfvervinneliga", "oöfvervinne"},
		{"oöverskådliga", "oöverskåd"},
		{"oövervinneliga", "oövervinne"},
		{"oövervinneligt", "oövervinne"},
		{"p", "p"},
		{"pa", "pa"},
		{"paa", "paa"},
		{"pablen", "pabl"},
		{"pack", "pack"},
		{"packa", "pack"},
		{"packar", "pack"},
		{"packat", "pack"},
		{"packet", "packet"},
		{"packlår", "packlår"},
		{"packning", "packning"},
		{"packor", "pack"},
		{"packorna", "pack"},
		{"padda", "padd"},
		{"paddan", "paddan"},
		{"pade", "pad"},
		{"pades", "pad"},
		{"pagatt", "pagat"},
		{"page", "pag"},
		{"pah", "pah"},
		{"pahittig", "pahitt"},
		{"pahlcn", "pahlcn"},
		{"pahle", "pahl"},
		{"pahlen", "pahl"},
		{"pahleu", "pahleu"},
		{"pahlr", "pahlr"},
		{"pahlsn", "pahlsn"},
		{"paillen", "paill"},
		{"pajasskratt", "pajasskrat"},
		{"pajrock", "pajrock"},
		{"paket", "paket"},
		{"palade", "pal"},
		{"palats", "palat"},
		{"pall", "pall"},
		{"pallen", "pall"},
		{"palllen", "palll"},
		{"palm", "palm"},
		{"palmaer", "palma"},
		{"palmer", "palm"},
		{"palmqvist", "palmqvist"},
		{"palmsus", "palmsus"},
		{"paltiga", "palt"},
		{"paltlen", "paltl"},
		{"pamparna", "pamp"},
		{"pan", "pan"},
		{"pande", "pand"},
		{"panelen", "panel"},
		{"paneler", "panel"},
		{"pank", "pank"},
		{"panna", "pann"},
		{"pannan", "pannan"},
		{"pannkakor", "pannkak"},
		{"pannorna", "pann"},
		{"pansar", "pans"},
		{"pant", "pant"},
		{"pantomim", "pantomim"},
		{"pantomimen", "pantomim"},
		{"pantomimer", "pantomim"},
		{"pantomimiska", "pantomimisk"},
		{"pantomin", "pantomin"},
		{"pantsätta", "pantsät"},
		{"papiljotter", "papiljot"},
		{"papiljotterna", "papiljot"},
		{"papinianus", "papinianus"},
		{"pappa", "papp"},
		{"pappas", "papp"},
		{"pappask", "pappask"},
		{"pappenheimare", "pappenheim"},
		{"papper", "papp"},
		{"papperen", "papper"},
		{"papperet", "papperet"},
		{"papperskniv", "papperskniv"},
		{"papperslapp", "papperslapp"},
		{"papperslappar", "papperslapp"},
		{"pappersomslag", "pappersomslag"},
		{"pappersremsa", "pappersrems"},
		{"pappersrosetter", "pappersroset"},
		{"pappersrullen", "pappersrull"},
		{"pappersskärmar", "pappersskärm"},
		{"pappersstadga", "pappersstadg"},
		{"papperstuss", "papperstuss"},
		{"par", "par"},
		{"para", "par"},
		{"parad", "par"},
		{"paraden", "parad"},
		{"paradigma", "paradigm"},
		{"paradis", "paradis"},
		{"paradiset", "paradiset"},
		{"parantes", "parant"},
		{"paraply", "paraply"},
		{"paraplyet", "paraplyet"},
		{"paraplymakarna", "paraplymak"},
		{"paraplyn", "paraplyn"},
		{"parasolett", "parasolet"},
		{"parasoletten", "parasolet"},
		{"parasoll", "parasoll"},
		{"parasollernas", "parasoll"},
		{"parce", "parc"},
		{"paren", "par"},
		{"parentes", "parent"},
		{"paret", "paret"},
		{"parets", "paret"},
		{"parfym", "parfym"},
		{"parfymen", "parfym"},
		{"paris", "paris"},
		{"parisiska", "parisisk"},
		{"parken", "park"},
		{"parkens", "park"},
		{"parkernas", "park"},
		{"parkett", "parket"},
		{"parketten", "parket"},
		{"parkettgolv", "parkettgolv"},
		{"parlament", "parlament"},
		{"parlement", "parlement"},
		{"parna", "parn"},
		{"paroit", "paroit"},
		{"paroxysmer", "paroxysm"},
		{"pars", "par"},
		{"parsifal", "parsifal"},
		{"parten", "part"},
		{"parterna", "part"},
		{"parti", "parti"},
		{"partie", "parti"},
		{"partier", "parti"},
		{"partierna", "parti"},
		{"partiet", "partiet"},
		{"partisk", "partisk"},
		{"partiska", "partisk"},
		{"partout", "partout"},
		{"partu", "partu"},
		{"parvis", "parvis"},
		{"pas", "pas"},
		{"pascal", "pascal"},
		{"pass", "pass"},
		{"passa", "pass"},
		{"passade", "pass"},
		{"passagerarna", "passager"},
		{"passande", "pass"},
		{"passar", "pass"},
		{"passat", "pass"},
		{"passera", "passer"},
		{"passerade", "passer"},
		{"passerat", "passer"},
		{"passion", "passion"},
		{"passionens", "passion"},
		{"passionerad", "passioner"},
		{"passionerat", "passioner"},
		{"passiv", "passiv"},
		{"passopp", "passopp"},
		{"past", "past"},
		{"pastor", "past"},
		{"pastorat", "pastor"},
		{"pastoratets", "pastoratet"},
		{"pastorn", "pastorn"},
		{"pastorns", "pastorn"},
		{"pastorsadjunkt", "pastorsadjunk"},
		{"pastorsadjunkten", "pastorsadjunk"},
		{"patent", "patent"},
		{"pater", "pat"},
		{"paternoster", "paternost"},
		{"paternosterskären", "paternosterskär"},
		{"patetisk", "patetisk"},
		{"patetiskt", "patetisk"},
		{"patiens", "pati"},
		{"patienskorten", "patienskort"},
		{"patient", "patient"},
		{"patienten", "patient"},
		{"patientens", "patient"},
		{"patienter", "patient"},
		{"patienterna", "patient"},
		{"patiramfes", "patiramf"},
		{"patos", "pato"},
		{"patrask", "patrask"},
		{"patron", "patron"},
		{"patronen", "patron"},
		{"patronessa", "patroness"},
		{"patronessan", "patronessan"},
		{"patronessas", "patroness"},
		{"patrons", "patron"},
		{"patrull", "patrull"},
		{"paula", "paul"},
		{"pauli", "pauli"},
		{"paus", "paus"},
		{"pausen", "paus"},
		{"pauvre", "pauvr"},
		{"paviljongen", "paviljong"},
		{"pcka", "pcka"},
		{"pclargonia", "pclargoni"},
		{"pctra", "pctra"},
		{"pedalen", "pedal"},
		{"pedantansikte", "pedantansik"},
		{"pedantiskt", "pedantisk"},
		{"peka", "pek"},
		{"pekade", "pek"},
		{"pekande", "pek"},
		{"pekar", "pek"},
		{"pekat", "pek"},
		{"pekfinger", "pekfing"},
		{"pekfingerknoge", "pekfingerknog"},
		{"pekfingret", "pekfingret"},
		{"pelarfasad", "pelarfas"},
		{"pelargonia", "pelargoni"},
		{"pelarn", "pelarn"},
		{"pelham", "pelham"},
		{"pelra", "pelr"},
		{"pendang", "pendang"},
		{"pendangkomedi", "pendangkomedi"},
		{"pendel", "pendel"},
		{"pendylen", "pendyl"},
		{"pendyler", "pendyl"},
		{"pengar", "peng"},
		{"pengarna", "peng"},
		{"pengarne", "peng"},
		{"penjoar", "penjo"},
		{"penjoaren", "penjo"},
		{"penjoarens", "penjo"},
		{"penna", "penn"},
		{"pennan", "pennan"},
		{"penndrag", "penndrag"},
		{"pennfjädersviftningen", "pennfjädersviftning"},
		{"pennfjädrar", "pennfjädr"},
		{"penning", "penning"},
		{"penningar", "penning"},
		{"penningarna", "penning"},
		{"penningbegäret", "penningbegäret"},
		{"penningeaffärer", "penningeaffär"},
		{"penningeförlägenhet", "penningeförlägen"},
		{"penningen", "penning"},
		{"penningens", "penning"},
		{"penningeutgifter", "penningeutgift"},
		{"penninghjälp", "penninghjälp"},
		{"penningpungen", "penningpung"},
		{"penningsumman", "penningsumman"},
		{"penningälskande", "penningälsk"},
		{"pennkniv", "pennkniv"},
		{"pennor", "penn"},
		{"pennorna", "penn"},
		{"pens", "pen"},
		{"pense", "pens"},
		{"penseer", "pense"},
		{"penseldrag", "penseldrag"},
		{"penseln", "penseln"},
		{"penseögonen", "penseögon"},
		{"penseögonens", "penseögon"},
		{"pension", "pension"},
		{"pensionen", "pension"},
		{"pensionerad", "pensioner"},
		{"pensionsbeloppet", "pensionsbeloppet"},
		{"pep", "pep"},
		{"peppar", "pepp"},
		{"pepparroten", "pepparrot"},
		{"pepprad", "peppr"},
		{"pepprat", "peppr"},
		{"per", "per"},
		{"period", "period"},
		{"periodiskt", "periodisk"},
		{"perla", "perl"},
		{"perlrader", "perlrad"},
		{"permar", "perm"},
		{"permission", "permission"},
		{"perrongen", "perrong"},
		{"pers", "per"},
		{"persedlar", "persedl"},
		{"persmässa", "persmäss"},
		{"person", "person"},
		{"personal", "personal"},
		{"personalen", "personal"},
		{"personen", "person"},
		{"personer", "person"},
		{"personfierade", "personfier"},
		{"personifierade", "personifier"},
		{"personlig", "person"},
		{"personliga", "person"},
		{"personligen", "person"},
		{"personlighet", "person"},
		{"personligheter", "person"},
		{"personligt", "person"},
		{"perspektiv", "perspektiv"},
		{"persson", "persson"},
		{"peruk", "peruk"},
		{"perukstock", "perukstock"},
		{"perversa", "pervers"},
		{"pest", "pest"},
		{"pestartad", "pestart"},
		{"pesten", "pest"},
		{"pestilens", "pestil"},
		{"pestsmittad", "pestsmit"},
		{"petade", "pet"},
		{"petat", "pet"},
		{"peter", "pet"},
		{"peters", "peter"},
		{"petits", "petit"},
		{"petra", "petr"},
		{"petras", "petr"},
		{"petri", "petri"},
		{"petter", "pett"},
		{"petters", "petter"},
		{"pfa", "pfa"},
		{"pfalz", "pfalz"},
		{"pfalzgreves", "pfalzgrev"},
		{"phoebus", "phoebus"},
		{"pi", "pi"},
		{"piano", "piano"},
		{"pianolektioner", "pianolektion"},
		{"pianot", "pianot"},
		{"picka", "pick"},
		{"pickade", "pick"},
		{"pickande", "pick"},
		{"pickandet", "pick"},
		{"pickar", "pick"},
		{"pietistisk", "pietistisk"},
		{"piga", "pig"},
		{"pigan", "pigan"},
		{"pigans", "pigan"},
		{"pigg", "pigg"},
		{"pigga", "pigg"},
		{"piggar", "pigg"},
		{"piggare", "pigg"},
		{"pigor", "pig"},
		{"pigslynorna", "pigslyn"},
		{"pigtyp", "pigtyp"},
		{"pik", "pik"},
		{"pikant", "pikant"},
		{"pikanta", "pikant"},
		{"pikar", "pik"},
		{"pil", "pil"},
		{"pilar", "pil"},
		{"pilarna", "pil"},
		{"pilarnas", "pil"},
		{"pilastrar", "pilastr"},
		{"pilen", "pil"},
		{"pilgrim", "pilgrim"},
		{"pilgrimen", "pilgrim"},
		{"pilgrimsvandring", "pilgrimsvandring"},
		{"pilkogret", "pilkogret"},
		{"piller", "pill"},
		{"pillerasken", "pillerask"},
		{"pillerna", "pill"},
		{"pillertrillare", "pillertrill"},
		{"pillman", "pillman"},
		{"pillret", "pillret"},
		{"pilskarp", "pilskarp"},
		{"pilsner", "pilsn"},
		{"pilt", "pilt"},
		{"pimplar", "pimpl"},
		{"pin", "pin"},
		{"pina", "pin"},
		{"pinade", "pin"},
		{"pinades", "pin"},
		{"pinan", "pinan"},
		{"pinar", "pin"},
		{"pinas", "pin"},
		{"pinat", "pin"},
		{"pinats", "pinat"},
		{"pincene", "pincen"},
		{"pincenen", "pincen"},
		{"pinglade", "pingl"},
		{"pingstens", "pingst"},
		{"pingstliljor", "pingstlilj"},
		{"pinliga", "pin"},
		{"pinnarna", "pinn"},
		{"pinsam", "pinsam"},
		{"pinsbacks", "pinsback"},
		{"pion", "pion"},
		{"pionen", "pion"},
		{"pionröd", "pionröd"},
		{"pip", "pip"},
		{"pipa", "pip"},
		{"pipan", "pipan"},
		{"pipande", "pip"},
		{"piper", "pip"},
		{"piperska", "pipersk"},
		{"pipig", "pip"},
		{"pipor", "pip"},
		{"piporna", "pip"},
		{"pippa", "pipp"},
		{"pippor", "pipp"},
		{"pipporna", "pipp"},
		{"pipstumpen", "pipstump"},
		{"pique", "piqu"},
		{"piraten", "pirat"},
		{"piska", "pisk"},
		{"piskade", "pisk"},
		{"piskan", "piskan"},
		{"piskas", "pisk"},
		{"piskat", "pisk"},
		{"piskslag", "piskslag"},
		{"pistol", "pistol"},
		{"pistolerna", "pistol"},
		{"pistolskott", "pistolskot"},
		{"pitscherstickarn", "pitscherstickarn"},
		{"pittoreskt", "pittoresk"},
		{"pjattra", "pjattr"},
		{"pjes", "pjes"},
		{"pjesen", "pjes"},
		{"pjoskas", "pjosk"},
		{"pjunkeri", "pjunkeri"},
		{"pjunkiga", "pjunk"},
		{"pjäs", "pjäs"},
		{"pjäser", "pjäs"},
		{"pl", "pl"},
		{"placera", "placer"},
		{"placerad", "placer"},
		{"placerade", "placer"},
		{"placerat", "placer"},
		{"pladask", "pladask"},
		{"pladder", "pladd"},
		{"pladdrade", "pladdr"},
		{"pladdrande", "pladdr"},
		{"plagg", "plagg"},
		{"plaggen", "plagg"},
		{"plan", "plan"},
		{"planen", "plan"},
		{"planer", "plan"},
		{"planerad", "planer"},
		{"planerat", "planer"},
		{"planet", "planet"},
		{"planeter", "planet"},
		{"plank", "plank"},
		{"planka", "plank"},
		{"planken", "plank"},
		{"planket", "planket"},
		{"plankhjärtat", "plankhjärt"},
		{"planlagda", "planlag"},
		{"planscher", "plansch"},
		{"planschverkshögarna", "planschverkshög"},
		{"planta", "plant"},
		{"plantan", "plantan"},
		{"plantar", "plant"},
		{"planterade", "planter"},
		{"planterar", "planter"},
		{"planterat", "planter"},
		{"plantering", "plantering"},
		{"planteringarne", "plantering"},
		{"planteringens", "plantering"},
		{"plaskande", "plask"},
		{"plats", "plat"},
		{"platsen", "plats"},
		{"platser", "plats"},
		{"platserna", "plats"},
		{"platsombud", "platsombud"},
		{"platt", "platt"},
		{"plattade", "platt"},
		{"plattnosansikte", "plattnosansik"},
		{"pli", "pli"},
		{"pligt", "pligt"},
		{"pligten", "pligt"},
		{"pligter", "pligt"},
		{"plikt", "plikt"},
		{"plikta", "plikt"},
		{"pliktat", "plikt"},
		{"plikten", "plikt"},
		{"plikter", "plikt"},
		{"pliktformulär", "pliktformulär"},
		{"pliktförgätna", "pliktförgätn"},
		{"pliktkänsla", "pliktkänsl"},
		{"pliktskyldiga", "pliktskyld"},
		{"plirade", "plir"},
		{"plirande", "plir"},
		{"plirar", "plir"},
		{"pllkt", "pllkt"},
		{"plocka", "plock"},
		{"plockade", "plock"},
		{"plockar", "plock"},
		{"plockat", "plock"},
		{"plogen", "plog"},
		{"plotsligt", "plots"},
		{"plugga", "plugg"},
		{"pluggade", "plugg"},
		{"plumpa", "plump"},
		{"pluralis", "pluralis"},
		{"plus", "plus"},
		{"plyet", "plyet"},
		{"plym", "plym"},
		{"plymbusken", "plymbusk"},
		{"plysch", "plysch"},
		{"plägade", "pläg"},
		{"plägar", "pläg"},
		{"plär", "plär"},
		{"plättar", "plätt"},
		{"plåeade", "plåead"},
		{"plåga", "plåg"},
		{"plågad", "plåg"},
		{"plågade", "plåg"},
		{"plågan", "plågan"},
		{"plågans", "plågan"},
		{"plågar", "plåg"},
		{"plågas", "plåg"},
		{"plågat", "plåg"},
		{"plågoandar", "plågoand"},
		{"plågoandars", "plågoandar"},
		{"plågoande", "plågo"},
		{"plågor", "plåg"},
		{"plågoris", "plågoris"},
		{"plågorna", "plåg"},
		{"plågorum", "plågorum"},
		{"plågsam", "plågsam"},
		{"plågsamma", "plågsamm"},
		{"plågsammaste", "plågsamm"},
		{"plågsamt", "plågsamt"},
		{"plånades", "plån"},
		{"plånas", "plån"},
		{"plånat", "plån"},
		{"plånbok", "plånbok"},
		{"plånboken", "plånbok"},
		{"plåtskorstenar", "plåtskorsten"},
		{"plåtskärmar", "plåtskärm"},
		{"plåttak", "plåttak"},
		{"plöja", "plöj"},
		{"plöjde", "plöjd"},
		{"plöjdes", "plöjd"},
		{"plöts", "plöt"},
		{"plötslig", "plöts"},
		{"plötsliga", "plöts"},
		{"plötsligt", "plöts"},
		{"pnhlen", "pnhlen"},
		{"pocka", "pock"},
		{"pockade", "pock"},
		{"pockern", "pock"},
		{"poem", "poem"},
		{"poemet", "poemet"},
		{"poesi", "poesi"},
		{"poesibok", "poesibok"},
		{"poesierna", "poesi"},
		{"poet", "poet"},
		{"poete", "poet"},
		{"poetens", "poet"},
		{"poetisk", "poetisk"},
		{"poetiska", "poetisk"},
		{"poetiske", "poetisk"},
		{"poetiskt", "poetisk"},
		{"pohle", "pohl"},
		{"pohls", "pohl"},
		{"pois", "pois"},
		{"poj", "poj"},
		{"pojkaktig", "pojkakt"},
		{"pojkaktigt", "pojkakt"},
		{"pojkar", "pojk"},
		{"pojkbytingen", "pojkbyting"},
		{"pojke", "pojk"},
		{"pojken", "pojk"},
		{"pokaler", "pokal"},
		{"poleja", "polej"},
		{"polen", "pol"},
		{"polera", "poler"},
		{"polerade", "poler"},
		{"polis", "polis"},
		{"polisen", "polis"},
		{"poliskonstapel", "poliskonstapel"},
		{"poliskonstapeln", "poliskonstapeln"},
		{"polisonger", "polisong"},
		{"polissongerna", "polissong"},
		{"politik", "politik"},
		{"politiken", "politik"},
		{"politiker", "politik"},
		{"politiska", "politisk"},
		{"polityr", "polityr"},
		{"polityrkärl", "polityrkärl"},
		{"pomril", "pomril"},
		{"ponerar", "poner"},
		{"ponken", "ponk"},
		{"poppelspiran", "poppelspiran"},
		{"popplar", "poppl"},
		{"popplarne", "poppl"},
		{"popularitet", "popularitet"},
		{"populasen", "populas"},
		{"populi", "populi"},
		{"populär", "populär"},
		{"populärt", "populärt"},
		{"porla", "porl"},
		{"porlade", "porl"},
		{"porlande", "porl"},
		{"porlar", "porl"},
		{"porslin", "porslin"},
		{"porslinerna", "porslin"},
		{"porslinet", "porslinet"},
		{"porslinspröd", "porslinspröd"},
		{"porslinsvasen", "porslinsvas"},
		{"port", "port"},
		{"portalen", "portal"},
		{"portar", "port"},
		{"portativ", "portativ"},
		{"portativa", "portativ"},
		{"porten", "port"},
		{"portens", "port"},
		{"porter", "port"},
		{"portgång", "portgång"},
		{"portgången", "portgång"},
		{"portik", "portik"},
		{"portion", "portion"},
		{"portioner", "portion"},
		{"portiären", "portiär"},
		{"portmonnä", "portmonnä"},
		{"porträtt", "porträt"},
		{"porträttet", "porträttet"},
		{"portugalsvatten", "portugalsvat"},
		{"portugisisk", "portugisisk"},
		{"portvalvet", "portvalvet"},
		{"portvin", "portvin"},
		{"portör", "portör"},
		{"portören", "portör"},
		{"pose", "pos"},
		{"poserande", "poser"},
		{"poserar", "poser"},
		{"position", "position"},
		{"post", "post"},
		{"postb", "postb"},
		{"postbäraren", "postbär"},
		{"postdag", "postdag"},
		{"posten", "post"},
		{"poster", "post"},
		{"posterad", "poster"},
		{"posterade", "poster"},
		{"postilla", "postill"},
		{"postpengar", "postpeng"},
		{"potage", "potag"},
		{"potatis", "potatis"},
		{"potatisen", "potatis"},
		{"potatislandet", "potatisl"},
		{"potatisskal", "potatisskal"},
		{"potches", "potch"},
		{"potemkin", "potemkin"},
		{"potemkins", "potemkin"},
		{"pottkäsburken", "pottkäsburk"},
		{"pr", "pr"},
		{"prakt", "prakt"},
		{"praktartiklar", "praktartikl"},
		{"prakten", "prakt"},
		{"praktfulla", "praktfull"},
		{"praktfullt", "praktfull"},
		{"praktgemak", "praktgemak"},
		{"praktik", "praktik"},
		{"praktiken", "praktik"},
		{"praktisera", "praktiser"},
		{"praktisk", "praktisk"},
		{"praktiska", "praktisk"},
		{"prasslade", "prassl"},
		{"prasslar", "prassl"},
		{"prasslet", "prasslet"},
		{"prat", "prat"},
		{"prata", "prat"},
		{"pratade", "prat"},
		{"pratades", "prat"},
		{"pratar", "prat"},
		{"pratat", "prat"},
		{"pratets", "pratet"},
		{"pratlystna", "pratlystn"},
		{"pratsamma", "pratsamm"},
		{"prcdikan", "prcdikan"},
		{"pre", "pre"},
		{"precis", "precis"},
		{"precist", "precist"},
		{"predestination", "predestination"},
		{"predi", "predi"},
		{"predika", "predik"},
		{"predikade", "predik"},
		{"predikament", "predikament"},
		{"predikan", "predikan"},
		{"predikant", "predikant"},
		{"predikanten", "predikant"},
		{"predikantens", "predikant"},
		{"predikanter", "predikant"},
		{"predikaren", "predik"},
		{"predikat", "predik"},
		{"predikningar", "predikning"},
		{"predikningars", "predikningar"},
		{"predikstolen", "predikstol"},
		{"pregel", "pregel"},
		{"pregeln", "pregeln"},
		{"prejade", "prej"},
		{"prejar", "prej"},
		{"preludier", "preludi"},
		{"premiäraktör", "premiäraktör"},
		{"premiäraktören", "premiäraktör"},
		{"pres", "pres"},
		{"present", "present"},
		{"presentabel", "presentabel"},
		{"presenter", "present"},
		{"presentera", "presenter"},
		{"presenterade", "presenter"},
		{"presenterna", "present"},
		{"press", "press"},
		{"pressa", "press"},
		{"pressade", "press"},
		{"pressande", "press"},
		{"pressat", "press"},
		{"presse", "press"},
		{"pressen", "press"},
		{"prestbetyg", "prestbetyg"},
		{"prestdotter", "prestdot"},
		{"presten", "prest"},
		{"pretention", "pretention"},
		{"pretentioner", "pretention"},
		{"pretentionerna", "pretention"},
		{"pretentiösa", "pretentiös"},
		{"preussen", "preuss"},
		{"preussisk", "preussisk"},
		{"prick", "prick"},
		{"pricka", "prick"},
		{"prickad", "prick"},
		{"pricken", "prick"},
		{"primadolma", "primadolm"},
		{"primariiämbetet", "primariiämbetet"},
		{"primarius", "primarius"},
		{"primus", "primus"},
		{"princesse", "princess"},
		{"principal", "principal"},
		{"prins", "prin"},
		{"prinsar", "prins"},
		{"prinsen", "prins"},
		{"prinsessa", "prinsess"},
		{"prinsessan", "prinsessan"},
		{"prior", "prior"},
		{"pris", "pris"},
		{"prisa", "pris"},
		{"prisade", "pris"},
		{"prisande", "pris"},
		{"prisar", "pris"},
		{"prisat", "pris"},
		{"prisen", "pris"},
		{"priserna", "pris"},
		{"priset", "priset"},
		{"privat", "priv"},
		{"privatbanker", "privatbank"},
		{"privatdöpt", "privatdöpt"},
		{"privilegium", "privilegium"},
		{"pro", "pro"},
		{"problem", "problem"},
		{"problemet", "problemet"},
		{"procent", "procent"},
		{"procentar", "procent"},
		{"procentarhänder", "procentarhänd"},
		{"processen", "process"},
		{"procession", "procession"},
		{"producera", "producer"},
		{"produkter", "produk"},
		{"prof", "prof"},
		{"profana", "profan"},
		{"profession", "profession"},
		{"professionell", "professionell"},
		{"professionella", "professionell"},
		{"professo", "professo"},
		{"professor", "profess"},
		{"professorers", "professorer"},
		{"professorn", "professorn"},
		{"professorns", "professorn"},
		{"professors", "professor"},
		{"profet", "profet"},
		{"profeten", "profet"},
		{"profeter", "profet"},
		{"profetera", "profeter"},
		{"profetia", "profeti"},
		{"profetisk", "profetisk"},
		{"profil", "profil"},
		{"profilen", "profil"},
		{"profseglas", "profsegl"},
		{"profstycke", "profstyck"},
		{"profvets", "profvet"},
		{"programmen", "programm"},
		{"programmet", "programmet"},
		{"projekt", "projek"},
		{"prolongation", "prolongation"},
		{"promenad", "promen"},
		{"promenaden", "promenad"},
		{"promenader", "promenad"},
		{"promenadkängor", "promenadkäng"},
		{"promenadplats", "promenadplat"},
		{"promenadplatsen", "promenadplats"},
		{"promenera", "promener"},
		{"promenerade", "promener"},
		{"promenerande", "promener"},
		{"promenerar", "promener"},
		{"promenerat", "promener"},
		{"prompt", "prompt"},
		{"proportion", "proportion"},
		{"proportionnees", "proportionne"},
		{"propos", "propo"},
		{"proppade", "propp"},
		{"proppar", "propp"},
		{"prosaiska", "prosaisk"},
		{"prosan", "prosan"},
		{"prosans", "prosan"},
		{"prosceniet", "prosceniet"},
		{"prost", "prost"},
		{"prosten", "prost"},
		{"prostens", "prost"},
		{"prostfars", "prostfar"},
		{"prostgården", "prostgård"},
		{"prosthus", "prosthus"},
		{"prostinna", "prostin"},
		{"prostinnan", "prostinnan"},
		{"prostitutionen", "prostitution"},
		{"prosttiteln", "prosttiteln"},
		{"protestanter", "protestant"},
		{"protestera", "protester"},
		{"protesterade", "protester"},
		{"prov", "prov"},
		{"provade", "prov"},
		{"provet", "provet"},
		{"provinser", "provins"},
		{"provisorn", "provisorn"},
		{"provkandidat", "provkandid"},
		{"prudentliga", "prudent"},
		{"prunkade", "prunk"},
		{"prunkande", "prunk"},
		{"prunkar", "prunk"},
		{"prunkat", "prunk"},
		{"prut", "prut"},
		{"pruta", "prut"},
		{"prutade", "prut"},
		{"prutar", "prut"},
		{"prvda", "prvda"},
		{"pryda", "pryd"},
		{"prydas", "pryd"},
		{"prydd", "prydd"},
		{"prydde", "prydd"},
		{"pryddes", "prydd"},
		{"pryder", "pryd"},
		{"prydlig", "pryd"},
		{"prydliga", "pryd"},
		{"prydligaste", "pryd"},
		{"prydlighet", "pryd"},
		{"prydligt", "pryd"},
		{"prydnad", "prydn"},
		{"prydnader", "prydnad"},
		{"prydt", "prydt"},
		{"prygel", "prygel"},
		{"pryrdlig", "pryrd"},
		{"prytt", "prytt"},
		{"prägel", "prägel"},
		{"prägeln", "prägeln"},
		{"präglat", "prägl"},
		{"präk", "präk"},
		{"präktig", "präkt"},
		{"präktiga", "präkt"},
		{"präktigare", "präkt"},
		{"präktigaste", "präkt"},
		{"präktigt", "präkt"},
		{"pränt", "pränt"},
		{"präntad", "pränt"},
		{"präntat", "pränt"},
		{"präst", "präst"},
		{"prästdottern", "prästdot"},
		{"prästen", "präst"},
		{"prästens", "präst"},
		{"präster", "präst"},
		{"prästerlig", "präster"},
		{"prästerligt", "präster"},
		{"prästernas", "präst"},
		{"prästexamen", "prästexam"},
		{"prästgatan", "prästgatan"},
		{"prästgård", "prästgård"},
		{"prästgårdar", "prästgård"},
		{"prästgården", "prästgård"},
		{"prästgårdens", "prästgård"},
		{"prästgårdsbyggnaden", "prästgårdsbyggnad"},
		{"prästgårdsbyggningarna", "prästgårdsbyggning"},
		{"prästgårdsgrinden", "prästgårdsgrind"},
		{"prästhustru", "prästhustru"},
		{"prästkragar", "prästkrag"},
		{"prästkragen", "prästkrag"},
		{"prästkragens", "prästkrag"},
		{"prästman", "prästman"},
		{"prästs", "präst"},
		{"prästvigd", "prästv"},
		{"prål", "prål"},
		{"prålade", "prål"},
		{"prålande", "prål"},
		{"prålar", "prål"},
		{"pråligt", "prål"},
		{"prången", "prång"},
		{"pröfning", "pröfning"},
		{"pröfningen", "pröfning"},
		{"pröfningsskola", "pröfningsskol"},
		{"pröfva", "pröfv"},
		{"pröfvade", "pröfv"},
		{"pröfvades", "pröfv"},
		{"pröfvat", "pröfv"},
		{"pröva", "pröv"},
		{"prövade", "pröv"},
		{"prövande", "pröv"},
		{"prövar", "pröv"},
		{"prövat", "pröv"},
		{"prövning", "prövning"},
		{"prövotid", "prövotid"},
		{"psalm", "psalm"},
		{"psalmbok", "psalmbok"},
		{"psalmen", "psalm"},
		{"psalmer", "psalm"},
		{"psalmeu", "psalmeu"},
		{"psalmsångerskan", "psalmsångerskan"},
		{"psalmtoner", "psalmton"},
		{"psalmvers", "psalmver"},
		{"psalmverser", "psalmvers"},
		{"pseudovetenskaplig", "pseudovetenskap"},
		{"psssa", "psssa"},
		{"psykiatrici", "psykiatrici"},
		{"psykiatrien", "psykiatri"},
		{"psykiska", "psykisk"},
		{"psykofjanter", "psykofjant"},
		{"ptockade", "ptock"},
		{"pu", "pu"},
		{"publik", "publik"},
		{"publika", "publik"},
		{"publiken", "publik"},
		{"publius", "publius"},
		{"puckelrygg", "puckelrygg"},
		{"puckelryggig", "puckelrygg"},
		{"puckelryggige", "puckelrygg"},
		{"puckelryggsleende", "puckelryggsleend"},
		{"puddingen", "pudding"},
		{"pudel", "pudel"},
		{"pudeln", "pudeln"},
		{"puder", "pud"},
		{"pudra", "pudr"},
		{"pudrade", "pudr"},
		{"pudrat", "pudr"},
		{"pudret", "pudret"},
		{"puff", "puff"},
		{"pulcher", "pulch"},
		{"pulla", "pull"},
		{"pullan", "pullan"},
		{"pullor", "pull"},
		{"pulpet", "pulpet"},
		{"pulpeten", "pulpet"},
		{"pulpetlocket", "pulpetlocket"},
		{"pulpetrader", "pulpetrad"},
		{"pulsar", "puls"},
		{"pulsen", "puls"},
		{"pulserade", "pulser"},
		{"pulsslagen", "pulsslag"},
		{"pulvrisera", "pulvriser"},
		{"pund", "pund"},
		{"pung", "pung"},
		{"punkt", "punk"},
		{"punkten", "punk"},
		{"punkter", "punk"},
		{"punkterna", "punk"},
		{"punktlig", "punkt"},
		{"punktlighet", "punkt"},
		{"punktligt", "punkt"},
		{"punsch", "punsch"},
		{"punschbrickor", "punschbrick"},
		{"punschbuteljer", "punschbutelj"},
		{"punschen", "punsch"},
		{"punschglas", "punschgl"},
		{"punschglaset", "punschglaset"},
		{"punschhalvan", "punschhalvan"},
		{"punschorgierna", "punschorgi"},
		{"pupillerna", "pupill"},
		{"pur", "pur"},
		{"pura", "pur"},
		{"purprade", "purpr"},
		{"purpur", "purpur"},
		{"purpuraltan", "purpuraltan"},
		{"purpurflammor", "purpurflamm"},
		{"purpurklädning", "purpurklädning"},
		{"purpurmörka", "purpurmörk"},
		{"purpurröd", "purpurröd"},
		{"purpurröda", "purpurröd"},
		{"pussigt", "puss"},
		{"pust", "pust"},
		{"pustade", "pust"},
		{"pustande", "pust"},
		{"pustar", "pust"},
		{"pusten", "pust"},
		{"put", "put"},
		{"putar", "put"},
		{"puts", "put"},
		{"putsa", "puts"},
		{"putsade", "puts"},
		{"putsat", "puts"},
		{"puttrade", "puttr"},
		{"puzzelarbete", "puzzelarbet"},
		{"puzzlet", "puzzlet"},
		{"puzzlets", "puzzlet"},
		{"pvhlcn", "pvhlcn"},
		{"pyjamas", "pyjam"},
		{"pyngden", "pyng"},
		{"pyre", "pyr"},
		{"pys", "pys"},
		{"pyssla", "pyssl"},
		{"pysslade", "pyssl"},
		{"pyttsan", "pyttsan"},
		{"päls", "päl"},
		{"pälsarna", "päls"},
		{"pälsbrämad", "pälsbräm"},
		{"pälsbrämade", "pälsbräm"},
		{"pälsen", "päls"},
		{"pälsens", "päls"},
		{"pälsfoder", "pälsfod"},
		{"pälskappa", "pälskapp"},
		{"pälskrage", "pälskrag"},
		{"pälsverk", "pälsverk"},
		{"pälsverkens", "pälsverk"},
		{"pälsverket", "pälsverket"},
		{"pärl", "pärl"},
		{"pärlan", "pärlan"},
		{"pärlande", "pärl"},
		{"pärlbandet", "pärlb"},
		{"pärlemo", "pärlemo"},
		{"pärlemor", "pärlem"},
		{"pärlemosmycken", "pärlemosmyck"},
		{"pärlfärgade", "pärlfärg"},
		{"pärlnät", "pärlnät"},
		{"pärlor", "pärl"},
		{"pärlorna", "pärl"},
		{"pärlskum", "pärlskum"},
		{"pärlstickning", "pärlstickning"},
		{"pärmar", "pärm"},
		{"päronet", "päronet"},
		{"päronträd", "päronträd"},
		{"på", "på"},
		{"påa", "påa"},
		{"påbjudit", "påbjudit"},
		{"påbrås", "påbrås"},
		{"påbygd", "påbyg"},
		{"påbygda", "påbyg"},
		{"påbyggnad", "påbyggn"},
		{"påbyggnaden", "påbyggnad"},
		{"påbördade", "påbörd"},
		{"påbörjade", "påbörj"},
		{"pådragna", "pådragn"},
		{"pådrifva", "pådrifv"},
		{"påfallande", "påfall"},
		{"påfann", "påfan"},
		{"påflugenhet", "påflugen"},
		{"påfluget", "påfluget"},
		{"påfogels", "påfogel"},
		{"påfordras", "påfordr"},
		{"påfund", "påfund"},
		{"påfågelsfjäder", "påfågelsfjäd"},
		{"påhitt", "påhit"},
		{"påhittat", "påhit"},
		{"påhälsa", "påhäls"},
		{"påhänget", "påhänget"},
		{"påkommande", "påkomm"},
		{"påkommen", "påkomm"},
		{"påkommet", "påkommet"},
		{"påkostande", "påkost"},
		{"påkörare", "påkör"},
		{"pålagor", "pålag"},
		{"påle", "pål"},
		{"pålen", "pål"},
		{"pålitliga", "pålit"},
		{"pålitlighet", "pålit"},
		{"påmind", "påmind"},
		{"påminde", "påmind"},
		{"påminn", "påmin"},
		{"påminna", "påmin"},
		{"påminnande", "påmin"},
		{"påminnas", "påmin"},
		{"påminnelse", "påminn"},
		{"påminner", "påmin"},
		{"påmint", "påmint"},
		{"pånytt", "pånyt"},
		{"pånyttfödd", "pånyttföd"},
		{"påpasslig", "påpass"},
		{"påpeka", "påpek"},
		{"påpekar", "påpek"},
		{"påpekat", "påpek"},
		{"påräknade", "påräkn"},
		{"påräknat", "påräkn"},
		{"påsatt", "påsat"},
		{"påsatte", "påsat"},
		{"påse", "pås"},
		{"påseende", "påseend"},
		{"påsen", "pås"},
		{"påsens", "pås"},
		{"påskina", "påskin"},
		{"påskyndade", "påskynd"},
		{"påskyndat", "påskynd"},
		{"påskägg", "påskägg"},
		{"påstod", "påstod"},
		{"påstode", "påstod"},
		{"påstods", "påstod"},
		{"påstå", "påstå"},
		{"påstående", "påståend"},
		{"påståendet", "påståendet"},
		{"påstår", "påstår"},
		{"påstås", "påstås"},
		{"påsätta", "påsät"},
		{"påtaga", "påtag"},
		{"påtagen", "påtag"},
		{"påtagit", "påtagit"},
		{"påtaglig", "påtag"},
		{"påtagligare", "påtag"},
		{"påtagligen", "påtag"},
		{"påtagligt", "påtag"},
		{"påtruga", "påtrug"},
		{"påtryckning", "påtryckning"},
		{"påträdde", "påträd"},
		{"påträffas", "påträff"},
		{"påträffat", "påträff"},
		{"påtänkt", "påtänk"},
		{"påvar", "påv"},
		{"påverka", "påverk"},
		{"påverkad", "påverk"},
		{"påverkan", "påverkan"},
		{"pöbeln", "pöbeln"},
		{"pöbelvanan", "pöbelvanan"},
		{"pölar", "pöl"},
		{"pöser", "pös"},
		{"pöste", "pöst"},
		{"qu", "qu"},
		{"qualis", "qualis"},
		{"que", "que"},
		{"quelqu", "quelqu"},
		{"qui", "qui"},
		{"quo", "quo"},
		{"qvad", "qvad"},
		{"qvaf", "qvaf"},
		{"qval", "qval"},
		{"qvald", "qvald"},
		{"qvalda", "qvald"},
		{"qvalen", "qval"},
		{"qvalmig", "qvalm"},
		{"qvar", "qvar"},
		{"qvarblef", "qvarblef"},
		{"qvarblifva", "qvarblifv"},
		{"qvardröja", "qvardröj"},
		{"qvarglömt", "qvarglömt"},
		{"qvarhålla", "qvarhåll"},
		{"qvarlemnat", "qvarlemn"},
		{"qvarstanna", "qvarstan"},
		{"qvarstannade", "qvarstan"},
		{"qvarstod", "qvarstod"},
		{"qvarstodo", "qvarstodo"},
		{"qvart", "qvart"},
		{"qvinfolk", "qvinfolk"},
		{"qvinna", "qvinn"},
		{"qvinnan", "qvinnan"},
		{"qvinnans", "qvinnan"},
		{"qvinnas", "qvinn"},
		{"qvinnfolk", "qvinnfolk"},
		{"qvinnor", "qvinn"},
		{"qvinnorna", "qvinn"},
		{"qvist", "qvist"},
		{"qvitt", "qvitt"},
		{"qväfd", "qväfd"},
		{"qväfda", "qväfd"},
		{"qväfde", "qväfd"},
		{"qväfdt", "qväfd"},
		{"qväfva", "qväfv"},
		{"qväljande", "qvälj"},
		{"qväll", "qväll"},
		{"qvällen", "qväll"},
		{"qvällsbrasan", "qvällsbrasan"},
		{"qvällsvarden", "qvällsvard"},
		{"qväsa", "qväs"},
		{"qväser", "qväs"},
		{"qväses", "qväs"},
		{"r", "r"},
		{"ra", "ra"},
		{"rabatt", "rabat"},
		{"rabatten", "rabat"},
		{"rabatter", "rabat"},
		{"rabatterna", "rabat"},
		{"rackare", "rack"},
		{"rackartyg", "rackartyg"},
		{"racke", "rack"},
		{"rackte", "rack"},
		{"rad", "rad"},
		{"rada", "rad"},
		{"radband", "radband"},
		{"rade", "rad"},
		{"raden", "rad"},
		{"radens", "rad"},
		{"rader", "rad"},
		{"raderna", "rad"},
		{"radikalt", "radikalt"},
		{"radman", "radman"},
		{"radnde", "radnd"},
		{"rafael", "rafael"},
		{"rafaels", "rafael"},
		{"raffinemang", "raffinemang"},
		{"raffinerat", "raffiner"},
		{"rafsade", "rafs"},
		{"ragla", "ragl"},
		{"raglade", "ragl"},
		{"rak", "rak"},
		{"raka", "rak"},
		{"rakade", "rak"},
		{"rakare", "rak"},
		{"rakaste", "rak"},
		{"raket", "raket"},
		{"raketer", "raket"},
		{"raklång", "raklång"},
		{"rakna", "rakn"},
		{"rakningen", "rakning"},
		{"rakt", "rakt"},
		{"ral", "ral"},
		{"ralade", "ral"},
		{"ram", "ram"},
		{"rama", "ram"},
		{"ramandet", "ram"},
		{"ramar", "ram"},
		{"ramen", "ram"},
		{"ramför", "ramför"},
		{"ramlade", "raml"},
		{"ramlar", "raml"},
		{"rammet", "rammet"},
		{"ramna", "ramn"},
		{"ramper", "ramp"},
		{"ramsa", "rams"},
		{"ramshult", "ramshult"},
		{"ramundsson", "ramundsson"},
		{"ramåt", "ramåt"},
		{"ran", "ran"},
		{"rand", "rand"},
		{"rande", "rand"},
		{"randen", "rand"},
		{"randig", "rand"},
		{"randiga", "rand"},
		{"rang", "rang"},
		{"rangera", "ranger"},
		{"rangerad", "ranger"},
		{"rangklass", "rangklass"},
		{"ranglig", "rang"},
		{"rangliga", "rang"},
		{"rangordning", "rangordning"},
		{"rank", "rank"},
		{"rankan", "rankan"},
		{"rann", "rann"},
		{"ransakat", "ransak"},
		{"ransakning", "ransakning"},
		{"ranta", "rant"},
		{"rapitlet", "rapitlet"},
		{"rapp", "rapp"},
		{"rappat", "rapp"},
		{"rappen", "rapp"},
		{"rappet", "rappet"},
		{"raquin", "raquin"},
		{"rar", "rar"},
		{"rara", "rar"},
		{"rare", "rar"},
		{"rarna", "rarn"},
		{"rart", "rart"},
		{"ras", "ras"},
		{"rasa", "ras"},
		{"rasade", "ras"},
		{"rasande", "ras"},
		{"rasansikte", "rasansik"},
		{"rasat", "ras"},
		{"rasen", "ras"},
		{"rasens", "ras"},
		{"raseri", "raseri"},
		{"rask", "rask"},
		{"raska", "rask"},
		{"raskare", "rask"},
		{"raskaste", "rask"},
		{"raske", "rask"},
		{"raskhet", "rask"},
		{"raskolnikov", "raskolnikov"},
		{"raskt", "rask"},
		{"rasmusson", "rasmusson"},
		{"raspade", "rasp"},
		{"raspandet", "rasp"},
		{"rassla", "rassl"},
		{"rasslade", "rassl"},
		{"rasslande", "rassl"},
		{"rast", "rast"},
		{"rasta", "rast"},
		{"rasterna", "rast"},
		{"rastestund", "rastestund"},
		{"rastlös", "rastlös"},
		{"rastlösa", "rastlös"},
		{"rat", "rat"},
		{"ratat", "rat"},
		{"raterna", "rat"},
		{"ratt", "ratt"},
		{"ratten", "ratt"},
		{"razzia", "razzi"},
		{"rcste", "rcste"},
		{"rdr", "rdr"},
		{"re", "re"},
		{"reale", "real"},
		{"recensera", "recenser"},
		{"recenserade", "recenser"},
		{"recept", "recept"},
		{"receptet", "receptet"},
		{"recke", "reck"},
		{"reckes", "reck"},
		{"red", "red"},
		{"reda", "red"},
		{"redan", "redan"},
		{"redare", "red"},
		{"redas", "red"},
		{"redbarhet", "redbar"},
		{"redbart", "redbart"},
		{"redde", "redd"},
		{"reddes", "redd"},
		{"reden", "red"},
		{"reder", "red"},
		{"rederi", "rederi"},
		{"redig", "red"},
		{"rediga", "red"},
		{"redigare", "red"},
		{"redighet", "red"},
		{"redigt", "red"},
		{"redingotkostym", "redingotkostym"},
		{"redlich", "redlich"},
		{"redlichs", "redlich"},
		{"redlig", "red"},
		{"redliga", "red"},
		{"redligaste", "red"},
		{"redlige", "red"},
		{"redlighet", "red"},
		{"redligt", "red"},
		{"redo", "redo"},
		{"redobogen", "redobog"},
		{"redogör", "redogör"},
		{"redogöra", "redogör"},
		{"redogörelse", "redogör"},
		{"reds", "red"},
		{"redskap", "redskap"},
		{"redskapen", "redskap"},
		{"reel", "reel"},
		{"ref", "ref"},
		{"refflade", "reffl"},
		{"reflekterade", "reflekter"},
		{"reflex", "reflex"},
		{"reflexen", "reflex"},
		{"reflexer", "reflex"},
		{"reflexion", "reflexion"},
		{"reflexionen", "reflexion"},
		{"reflexioner", "reflexion"},
		{"reflexionsspegel", "reflexionsspegel"},
		{"reflexionsspegeln", "reflexionsspegeln"},
		{"reflexrörelser", "reflexrör"},
		{"reflexskenet", "reflexskenet"},
		{"reflexverkan", "reflexverkan"},
		{"refrängen", "refräng"},
		{"refuge", "refug"},
		{"refvat", "refv"},
		{"regel", "regel"},
		{"regelbundet", "regelbundet"},
		{"regelbundna", "regelbundn"},
		{"regelmessiga", "regelmess"},
		{"regelmässigt", "regelmäss"},
		{"regeln", "regeln"},
		{"regementschef", "regementschef"},
		{"regent", "regent"},
		{"regentinna", "regentin"},
		{"regera", "reger"},
		{"regerad", "reger"},
		{"regerade", "reger"},
		{"regeringar", "regering"},
		{"regeringsgatan", "regeringsgatan"},
		{"regeringstömmarna", "regeringstömm"},
		{"regissören", "regissör"},
		{"registrator", "registrat"},
		{"registratorn", "registratorn"},
		{"registren", "registr"},
		{"reglad", "regl"},
		{"reglade", "regl"},
		{"reglera", "regler"},
		{"reglerade", "regler"},
		{"reglerar", "regler"},
		{"regn", "regn"},
		{"regna", "regn"},
		{"regnadc", "regnadc"},
		{"regnade", "regn"},
		{"regnar", "regn"},
		{"regnat", "regn"},
		{"regnbågsfärgad", "regnbågsfärg"},
		{"regnbågsljus", "regnbågsljus"},
		{"regnbågsskyn", "regnbågsskyn"},
		{"regndag", "regndag"},
		{"regndroppe", "regndropp"},
		{"regnens", "regn"},
		{"regnet", "regnet"},
		{"regnig", "regn"},
		{"regniga", "regn"},
		{"regnkappa", "regnkapp"},
		{"regnskur", "regnskur"},
		{"regnväder", "regnväd"},
		{"regnvädersdagar", "regnvädersdag"},
		{"rehabiliterad", "rehabiliter"},
		{"rehnska", "rehnsk"},
		{"reklam", "reklam"},
		{"reklamfönster", "reklamfönst"},
		{"rekommendation", "rekommendation"},
		{"rekommendera", "rekommender"},
		{"rekommenderat", "rekommender"},
		{"rekryter", "rekryt"},
		{"rektor", "rekt"},
		{"rektorn", "rektorn"},
		{"rekvirerade", "rekvirer"},
		{"rekvisitionen", "rekvisition"},
		{"relationer", "relation"},
		{"relian", "relian"},
		{"religion", "religion"},
		{"religionen", "religion"},
		{"religionsgrubbel", "religionsgrubbel"},
		{"religionsläraren", "religionslär"},
		{"religiositet", "religiositet"},
		{"religiös", "religiös"},
		{"religiösa", "religiös"},
		{"religiöst", "religiöst"},
		{"reling", "reling"},
		{"relingarna", "reling"},
		{"relingarne", "reling"},
		{"relingen", "reling"},
		{"rell", "rell"},
		{"rem", "rem"},
		{"remmar", "remm"},
		{"remna", "remn"},
		{"remnar", "remn"},
		{"remnorna", "remn"},
		{"remsan", "remsan"},
		{"ren", "ren"},
		{"rena", "ren"},
		{"renare", "ren"},
		{"rendez", "rendez"},
		{"renglänsande", "rengläns"},
		{"rengöra", "rengör"},
		{"rengöras", "rengör"},
		{"renhet", "ren"},
		{"renlighet", "ren"},
		{"renons", "renon"},
		{"rensa", "rens"},
		{"rensade", "rens"},
		{"renskrivning", "renskrivning"},
		{"renskurad", "renskur"},
		{"renskurade", "renskur"},
		{"rent", "rent"},
		{"rentav", "rentav"},
		{"rentvättad", "rentvät"},
		{"rentvättadt", "rentvättad"},
		{"rep", "rep"},
		{"reparation", "reparation"},
		{"reparationen", "reparation"},
		{"reparerade", "reparer"},
		{"reparerat", "reparer"},
		{"repen", "rep"},
		{"repetitionen", "repetition"},
		{"replikerade", "repliker"},
		{"representant", "representant"},
		{"representanterna", "representant"},
		{"representation", "representation"},
		{"representera", "representer"},
		{"representerade", "representer"},
		{"representerar", "representer"},
		{"reputation", "reputation"},
		{"rerna", "rern"},
		{"res", "res"},
		{"resa", "res"},
		{"resan", "resan"},
		{"resande", "res"},
		{"resandes", "res"},
		{"rese", "res"},
		{"reseda", "resed"},
		{"resemåltid", "resemåltid"},
		{"resen", "res"},
		{"resens", "res"},
		{"resepredikant", "resepredikant"},
		{"resepredikanten", "resepredikant"},
		{"reser", "res"},
		{"reses", "res"},
		{"reseskildringar", "reseskildring"},
		{"reshatt", "reshat"},
		{"resignation", "resignation"},
		{"resignerat", "resigner"},
		{"reskassan", "reskassan"},
		{"resklädd", "reskläd"},
		{"resle", "resl"},
		{"reslig", "res"},
		{"resning", "resning"},
		{"resolverar", "resolver"},
		{"reson", "reson"},
		{"resonemang", "resonemang"},
		{"resonemanget", "resonemanget"},
		{"resonera", "resoner"},
		{"resonerar", "resoner"},
		{"resor", "res"},
		{"respass", "respass"},
		{"respekt", "respek"},
		{"respektabel", "respektabel"},
		{"respektabelt", "respektabelt"},
		{"respektabla", "respektabl"},
		{"respekten", "respek"},
		{"respekterar", "respekter"},
		{"respekteras", "respekter"},
		{"respektfull", "respektfull"},
		{"respektlöst", "respektlös"},
		{"respengarna", "respeng"},
		{"respenningar", "respenning"},
		{"respenningarna", "respenning"},
		{"resschatull", "resschatull"},
		{"rest", "rest"},
		{"restaurang", "restaurang"},
		{"restaurangbordet", "restaurangbordet"},
		{"restaurangen", "restaurang"},
		{"restaurangernas", "restaurang"},
		{"restauranghörna", "restauranghörn"},
		{"restc", "restc"},
		{"reste", "rest"},
		{"resten", "rest"},
		{"rester", "rest"},
		{"resulster", "resulst"},
		{"resultat", "result"},
		{"resultatet", "resultatet"},
		{"resulterat", "resulter"},
		{"resurs", "resur"},
		{"resurser", "resurs"},
		{"resårbottnar", "resårbottn"},
		{"ret", "ret"},
		{"reta", "ret"},
		{"retad", "ret"},
		{"retade", "ret"},
		{"retades", "ret"},
		{"retadt", "retad"},
		{"retar", "ret"},
		{"retas", "ret"},
		{"retat", "ret"},
		{"retelse", "ret"},
		{"retelser", "ret"},
		{"retliga", "ret"},
		{"retlige", "ret"},
		{"retligheten", "ret"},
		{"retligt", "ret"},
		{"retsam", "retsam"},
		{"retsamhet", "retsam"},
		{"retsamt", "retsamt"},
		{"rett", "rett"},
		{"retty", "retty"},
		{"reumatism", "reumatism"},
		{"rev", "rev"},
		{"revers", "rever"},
		{"reversen", "revers"},
		{"reverser", "revers"},
		{"revisor", "revis"},
		{"revisorn", "revisorn"},
		{"revolvern", "revolv"},
		{"ri", "ri"},
		{"richardt", "richard"},
		{"ricinolja", "ricinolj"},
		{"rickrickettirack", "rickrickettirack"},
		{"rickrickettiratt", "rickrickettirat"},
		{"rida", "rid"},
		{"ridan", "ridan"},
		{"ridande", "rid"},
		{"riddare", "ridd"},
		{"riddaren", "ridd"},
		{"riddarhustorget", "riddarhustorget"},
		{"ridderliga", "ridder"},
		{"rider", "rid"},
		{"ridit", "ridit"},
		{"ridtur", "ridtur"},
		{"ridå", "ridå"},
		{"ridån", "ridån"},
		{"rierna", "riern"},
		{"rigeln", "rigeln"},
		{"riggad", "rigg"},
		{"rigla", "rigl"},
		{"rigtad", "rigt"},
		{"rigtig", "rigt"},
		{"rigtiga", "rigt"},
		{"rigtighet", "rigt"},
		{"rigtigt", "rigt"},
		{"rigtning", "rigtning"},
		{"rigtningar", "rigtning"},
		{"rijster", "rijst"},
		{"rik", "rik"},
		{"rika", "rik"},
		{"rikare", "rik"},
		{"rikaste", "rik"},
		{"rikc", "rikc"},
		{"rike", "rik"},
		{"rikedom", "rikedom"},
		{"rikedomar", "rikedom"},
		{"rikedomen", "rikedom"},
		{"rikeman", "rikeman"},
		{"riken", "rik"},
		{"rikens", "rik"},
		{"rikes", "rik"},
		{"rikhaltig", "rikhalt"},
		{"rikligen", "rik"},
		{"rikligt", "rik"},
		{"riksdagen", "riksdag"},
		{"riksdagshus", "riksdagshus"},
		{"riksdaler", "riksdal"},
		{"riksdalernas", "riksdal"},
		{"riksdalers", "riksdaler"},
		{"riksgälds", "riksgäld"},
		{"rikt", "rikt"},
		{"rikta", "rikt"},
		{"riktad", "rikt"},
		{"riktade", "rikt"},
		{"riktades", "rikt"},
		{"riktas", "rikt"},
		{"riktat", "rikt"},
		{"riktats", "riktat"},
		{"riktig", "rikt"},
		{"riktiga", "rikt"},
		{"riktigare", "rikt"},
		{"riktigt", "rikt"},
		{"riktning", "riktning"},
		{"riktningar", "riktning"},
		{"riktningen", "riktning"},
		{"rill", "rill"},
		{"rimligtvis", "rimligtvis"},
		{"rimma", "rimm"},
		{"rimmer", "rimm"},
		{"rimnande", "rimn"},
		{"rimrika", "rimrik"},
		{"ring", "ring"},
		{"ringa", "ring"},
		{"ringakta", "ringak"},
		{"ringaktning", "ringaktning"},
		{"ringande", "ring"},
		{"ringar", "ring"},
		{"ringare", "ring"},
		{"ringarna", "ring"},
		{"ringas", "ring"},
		{"ringaste", "ring"},
		{"ringde", "ring"},
		{"ringen", "ring"},
		{"ringer", "ring"},
		{"ringfinger", "ringfing"},
		{"ringhets", "ringhet"},
		{"ringlade", "ringl"},
		{"ringlarne", "ringl"},
		{"ringlinjen", "ringlinj"},
		{"ringning", "ringning"},
		{"ringt", "ring"},
		{"rinna", "rinn"},
		{"rinnande", "rinn"},
		{"ris", "ris"},
		{"riset", "riset"},
		{"risk", "risk"},
		{"risken", "risk"},
		{"risker", "risk"},
		{"riskera", "risker"},
		{"rispor", "risp"},
		{"ristad", "rist"},
		{"ristade", "rist"},
		{"ristat", "rist"},
		{"riste", "rist"},
		{"rita", "rit"},
		{"ritade", "rit"},
		{"ritat", "rit"},
		{"rium", "rium"},
		{"riva", "riv"},
		{"rival", "rival"},
		{"rivande", "riv"},
		{"river", "riv"},
		{"rivilligt", "rivil"},
		{"rivit", "rivit"},
		{"rivits", "rivit"},
		{"rivna", "rivn"},
		{"rleltagande", "rleltag"},
		{"rmed", "rmed"},
		{"rmuff", "rmuff"},
		{"rna", "rna"},
		{"rnaren", "rnar"},
		{"rnt", "rnt"},
		{"rnu", "rnu"},
		{"ro", "ro"},
		{"roa", "roa"},
		{"road", "road"},
		{"roade", "road"},
		{"roande", "roand"},
		{"roar", "roar"},
		{"roat", "roat"},
		{"rochefoucauld", "rochefoucauld"},
		{"rock", "rock"},
		{"rockar", "rock"},
		{"rocken", "rock"},
		{"rockhandeln", "rockhandeln"},
		{"rockor", "rock"},
		{"rockskörten", "rockskört"},
		{"rockskörtet", "rockskörtet"},
		{"rockslaget", "rockslaget"},
		{"rocksvarvare", "rocksvarv"},
		{"rockärmarna", "rockärm"},
		{"rockärmen", "rockärm"},
		{"rod", "rod"},
		{"rodd", "rodd"},
		{"roddarbåtarna", "roddarbåt"},
		{"roddarbåten", "roddarbåt"},
		{"roddare", "rodd"},
		{"roddarmadamens", "roddarmadam"},
		{"roddarmadamer", "roddarmadam"},
		{"roddbåt", "roddbåt"},
		{"rodde", "rodd"},
		{"rodden", "rodd"},
		{"rodin", "rodin"},
		{"rodna", "rodn"},
		{"rodnad", "rodn"},
		{"rodnade", "rodn"},
		{"rodnaden", "rodnad"},
		{"rodnande", "rodn"},
		{"rodnar", "rodn"},
		{"rodnat", "rodn"},
		{"rodret", "rodret"},
		{"rof", "rof"},
		{"roffar", "roff"},
		{"rofgirigheten", "rofgir"},
		{"roflysten", "roflyst"},
		{"roflystne", "roflystn"},
		{"roknar", "rokn"},
		{"rokoko", "rokoko"},
		{"rokokodams", "rokokodam"},
		{"rolf", "rolf"},
		{"rolig", "rol"},
		{"roliga", "rol"},
		{"roligare", "rol"},
		{"roligast", "rol"},
		{"roligaste", "rol"},
		{"rolighetsminister", "rolighetsminist"},
		{"roligt", "rol"},
		{"roll", "roll"},
		{"rollen", "roll"},
		{"roller", "roll"},
		{"rollerna", "roll"},
		{"rolösa", "rolös"},
		{"rom", "rom"},
		{"roman", "roman"},
		{"romanaktiga", "romanakt"},
		{"romanen", "roman"},
		{"romaner", "roman"},
		{"romanord", "romanord"},
		{"romantik", "romantik"},
		{"romantikens", "romantik"},
		{"romantiska", "romantisk"},
		{"romantiskt", "romantisk"},
		{"romantisktkanske", "romantisktkansk"},
		{"romanvärlden", "romanvärld"},
		{"romersk", "romersk"},
		{"ron", "ron"},
		{"rond", "rond"},
		{"ronden", "rond"},
		{"ronneby", "ronneby"},
		{"rop", "rop"},
		{"ropa", "rop"},
		{"ropadc", "ropadc"},
		{"ropade", "rop"},
		{"ropande", "rop"},
		{"ropar", "rop"},
		{"ropat", "rop"},
		{"ropet", "ropet"},
		{"rora", "ror"},
		{"rord", "rord"},
		{"rorde", "rord"},
		{"rorta", "rort"},
		{"rortaljan", "rortaljan"},
		{"ros", "ros"},
		{"rosa", "ros"},
		{"rosafärgade", "rosafärg"},
		{"rosas", "ros"},
		{"roseil", "roseil"},
		{"rosell", "rosell"},
		{"rosells", "rosell"},
		{"rosen", "ros"},
		{"rosenbad", "rosenb"},
		{"rosenberg", "rosenberg"},
		{"rosenbergs", "rosenberg"},
		{"rosenblad", "rosenbl"},
		{"rosenbladen", "rosenblad"},
		{"rosenbuske", "rosenbusk"},
		{"rosendegång", "rosendegång"},
		{"rosendimmor", "rosendimm"},
		{"rosengnista", "rosengnist"},
		{"rosenkindade", "rosenkind"},
		{"rosenkransen", "rosenkrans"},
		{"rosenrauch", "rosenrauch"},
		{"rosenrauchs", "rosenrauch"},
		{"rosenröda", "rosenröd"},
		{"rosenskymningen", "rosenskymning"},
		{"rosenstandens", "rosenstand"},
		{"rosentempel", "rosentempel"},
		{"rosiga", "ros"},
		{"rosigt", "ros"},
		{"rosor", "ros"},
		{"rosorna", "ros"},
		{"rosornas", "ros"},
		{"rost", "rost"},
		{"rosten", "rost"},
		{"roster", "rost"},
		{"rot", "rot"},
		{"rotat", "rot"},
		{"rotfästa", "rotfäst"},
		{"rotsaker", "rotsak"},
		{"rott", "rott"},
		{"rotter", "rott"},
		{"rotting", "rotting"},
		{"rottingen", "rotting"},
		{"rottingslag", "rottingslag"},
		{"rotundan", "rotundan"},
		{"rousseau", "rousseau"},
		{"rov", "rov"},
		{"rovdjurslikt", "rovdjurslik"},
		{"rovdjurständer", "rovdjurständ"},
		{"rovfågelsansikte", "rovfågelsansik"},
		{"rovfågelsansiktet", "rovfågelsansiktet"},
		{"rovtänder", "rovtänd"},
		{"rqd", "rqd"},
		{"rrohnarna", "rrohn"},
		{"rrök", "rrök"},
		{"rs", "rs"},
		{"rtom", "rtom"},
		{"rtsängarna", "rtsäng"},
		{"rtt", "rtt"},
		{"rubba", "rubb"},
		{"rubbad", "rubb"},
		{"rubbade", "rubb"},
		{"rubbar", "rubb"},
		{"rubbning", "rubbning"},
		{"rubbningen", "rubbning"},
		{"rubin", "rubin"},
		{"rubiner", "rubin"},
		{"rubins", "rubin"},
		{"rubriken", "rubrik"},
		{"rucklet", "rucklet"},
		{"ruckliga", "ruck"},
		{"rudekrona", "rudekron"},
		{"rue", "rue"},
		{"ruffen", "ruff"},
		{"rufsig", "rufs"},
		{"rufsiga", "rufs"},
		{"rufsigt", "rufs"},
		{"rufvade", "rufv"},
		{"rugg", "rugg"},
		{"ruggig", "rugg"},
		{"ruinen", "ruin"},
		{"ruiner", "ruin"},
		{"ruinerad", "ruiner"},
		{"ruinerar", "ruiner"},
		{"rull", "rull"},
		{"rulla", "rull"},
		{"rullade", "rull"},
		{"rullande", "rull"},
		{"rullar", "rull"},
		{"rulle", "rull"},
		{"rullgardin", "rullgardin"},
		{"rullgardinen", "rullgardin"},
		{"rullgardiner", "rullgardin"},
		{"rullgardinerna", "rullgardin"},
		{"rullt", "rullt"},
		{"rum", "rum"},
		{"rummen", "rumm"},
		{"rummens", "rumm"},
		{"rummet", "rummet"},
		{"rummets", "rummet"},
		{"rumskamrater", "rumskamrat"},
		{"rumsvåningen", "rumsvåning"},
		{"rund", "rund"},
		{"runda", "rund"},
		{"rundade", "rund"},
		{"rundning", "rundning"},
		{"rundt", "rund"},
		{"rundvälvd", "rundvälvd"},
		{"runeberg", "runeberg"},
		{"runeskrift", "runeskrift"},
		{"rungande", "rung"},
		{"runne", "runn"},
		{"runnit", "runnit"},
		{"runno", "runno"},
		{"runstycke", "runstyck"},
		{"runstycket", "runstycket"},
		{"runt", "runt"},
		{"runtom", "runtom"},
		{"runtomkring", "runtomkring"},
		{"rus", "rus"},
		{"rusa", "rus"},
		{"rusade", "rus"},
		{"rusande", "rus"},
		{"rusar", "rus"},
		{"rusat", "rus"},
		{"ruset", "ruset"},
		{"rusets", "ruset"},
		{"rusig", "rus"},
		{"rusiga", "rus"},
		{"ruskade", "rusk"},
		{"ruskar", "rusk"},
		{"ruskig", "rusk"},
		{"ruskigt", "rusk"},
		{"russeberget", "russeberget"},
		{"russin", "russin"},
		{"rusta", "rust"},
		{"rustade", "rust"},
		{"rustas", "rust"},
		{"rustibus", "rustibus"},
		{"rusticana", "rustican"},
		{"rut", "rut"},
		{"ruta", "rut"},
		{"rutan", "rutan"},
		{"ruter", "rut"},
		{"rutig", "rut"},
		{"rutor", "rut"},
		{"rutorna", "rut"},
		{"rutsch", "rutsch"},
		{"rutten", "rutt"},
		{"ruttenhet", "rutten"},
		{"ruttet", "ruttet"},
		{"ruttna", "ruttn"},
		{"ruttnade", "ruttn"},
		{"ruvade", "ruv"},
		{"ruvande", "ruv"},
		{"ruvat", "ruv"},
		{"rv", "rv"},
		{"rya", "rya"},
		{"rybte", "rybt"},
		{"ryck", "ryck"},
		{"rycka", "ryck"},
		{"ryckande", "ryck"},
		{"rycker", "ryck"},
		{"ryckig", "ryck"},
		{"ryckning", "ryckning"},
		{"ryckningar", "ryckning"},
		{"ryckt", "ryck"},
		{"rycktc", "rycktc"},
		{"ryckte", "ryck"},
		{"rycktes", "ryck"},
		{"ryckts", "ryck"},
		{"rydberg", "rydberg"},
		{"rydbergs", "rydberg"},
		{"rygg", "rygg"},
		{"ryggade", "rygg"},
		{"ryggar", "rygg"},
		{"ryggarna", "rygg"},
		{"ryggen", "rygg"},
		{"ryggraden", "ryggrad"},
		{"ryggstöd", "ryggstöd"},
		{"ryggtavla", "ryggtavl"},
		{"rykande", "ryk"},
		{"ryktbar", "ryktb"},
		{"ryktbara", "ryktbar"},
		{"ryktbarhet", "ryktbar"},
		{"ryktc", "ryktc"},
		{"rykte", "rykt"},
		{"rykten", "rykt"},
		{"ryktes", "rykt"},
		{"ryktet", "ryktet"},
		{"rym", "rym"},
		{"rymd", "rymd"},
		{"rymde", "rymd"},
		{"rymden", "rymd"},
		{"rymdens", "rymd"},
		{"rymder", "rymd"},
		{"rymlig", "rym"},
		{"rymliga", "rym"},
		{"rymma", "rymm"},
		{"rymmer", "rymm"},
		{"rymplingen", "rympling"},
		{"ryn", "ryn"},
		{"rynkade", "rynk"},
		{"rynkades", "rynk"},
		{"rynkar", "rynk"},
		{"rynkig", "rynk"},
		{"rynkiga", "rynk"},
		{"rynkigt", "rynk"},
		{"rynkning", "rynkning"},
		{"rynkor", "rynk"},
		{"rynkorna", "rynk"},
		{"rysa", "rys"},
		{"rysande", "rys"},
		{"ryser", "rys"},
		{"ryslig", "rys"},
		{"rysliga", "rys"},
		{"rysligaste", "rys"},
		{"ryslighet", "rys"},
		{"rysligt", "rys"},
		{"rysning", "rysning"},
		{"ryssviks", "ryssvik"},
		{"ryst", "ryst"},
		{"ryste", "ryst"},
		{"ryter", "ryt"},
		{"rytmer", "rytm"},
		{"ryttare", "rytt"},
		{"ryttmästare", "ryttmäst"},
		{"ryttmästaren", "ryttmäst"},
		{"ryttmästarens", "ryttmäst"},
		{"räck", "räck"},
		{"räcka", "räck"},
		{"räcke", "räck"},
		{"räcken", "räck"},
		{"räcker", "räck"},
		{"räckes", "räck"},
		{"räckhåll", "räckhåll"},
		{"räckt", "räck"},
		{"räckte", "räck"},
		{"räcktes", "räck"},
		{"räckts", "räck"},
		{"räckvidden", "räckvid"},
		{"rädcl", "rädcl"},
		{"rädd", "rädd"},
		{"rädda", "rädd"},
		{"räddad", "rädd"},
		{"räddade", "rädd"},
		{"räddare", "rädd"},
		{"räddat", "rädd"},
		{"räddhågad", "räddhåg"},
		{"räddning", "räddning"},
		{"räddsla", "räddsl"},
		{"rädens", "räd"},
		{"rädisor", "rädis"},
		{"rädisorna", "rädis"},
		{"räds", "räd"},
		{"rädsla", "rädsl"},
		{"rädslan", "rädslan"},
		{"räf", "räf"},
		{"räfvens", "räfv"},
		{"räkna", "räkn"},
		{"räknade", "räkn"},
		{"räknades", "räkn"},
		{"räknar", "räkn"},
		{"räknat", "räkn"},
		{"räknetal", "räknetal"},
		{"räkning", "räkning"},
		{"räkningar", "räkning"},
		{"räkningen", "räkning"},
		{"rämnorna", "rämn"},
		{"ränder", "ränd"},
		{"ränderna", "ränd"},
		{"rännan", "rännan"},
		{"rännil", "rännil"},
		{"rännor", "ränn"},
		{"rännsten", "rännst"},
		{"rännstenarna", "rännsten"},
		{"rännstenen", "rännsten"},
		{"ränseln", "ränseln"},
		{"ränta", "ränt"},
		{"räntan", "räntan"},
		{"räntor", "ränt"},
		{"räring", "räring"},
		{"rätade", "rät"},
		{"rätt", "rätt"},
		{"rätta", "rätt"},
		{"rättade", "rätt"},
		{"rättan", "rättan"},
		{"rättar", "rätt"},
		{"rättare", "rätt"},
		{"rättas", "rätt"},
		{"rättast", "rätt"},
		{"rättat", "rätt"},
		{"rätte", "rätt"},
		{"rättegång", "rättegång"},
		{"rättegångshandlingar", "rättegångshandling"},
		{"rättegångsprotokoll", "rättegångsprotokoll"},
		{"rätteligen", "rätte"},
		{"rätten", "rätt"},
		{"rätter", "rätt"},
		{"rätterna", "rätt"},
		{"rättesnöre", "rättesnör"},
		{"rättfram", "rättfram"},
		{"rättfärdiga", "rättfärd"},
		{"rättfärdigar", "rättfärd"},
		{"rättfärdige", "rättfärd"},
		{"rättfärdighet", "rättfärd"},
		{"rättighet", "rätt"},
		{"rättigheten", "rätt"},
		{"rättigheter", "rätt"},
		{"rättmätiga", "rättmät"},
		{"rättrådighet", "rättråd"},
		{"rättsenliga", "rättsen"},
		{"rättsinniga", "rättsinn"},
		{"rättsinnige", "rättsinn"},
		{"rättskaffens", "rättskaff"},
		{"rättskänsla", "rättskänsl"},
		{"rättsskipningen", "rättsskipning"},
		{"rättsuppfattning", "rättsuppfattning"},
		{"rättvis", "rättvis"},
		{"rättvisa", "rättvis"},
		{"rättvisan", "rättvisan"},
		{"rättvisaste", "rättvis"},
		{"rättvisligen", "rättvis"},
		{"rättvist", "rättvist"},
		{"räv", "räv"},
		{"räven", "räv"},
		{"rääf", "rääf"},
		{"rå", "rå"},
		{"råa", "råa"},
		{"råckor", "råck"},
		{"råd", "råd"},
		{"råda", "råd"},
		{"rådande", "råd"},
		{"rådbråka", "rådbråk"},
		{"rådde", "rådd"},
		{"råden", "råd"},
		{"råder", "råd"},
		{"rådet", "rådet"},
		{"rådfråga", "rådfråg"},
		{"rådfrågade", "rådfråg"},
		{"rådfrågat", "rådfråg"},
		{"rådgivare", "rådgiv"},
		{"rådgöra", "rådgör"},
		{"rådhusets", "rådhuset"},
		{"rådligast", "råd"},
		{"rådlös", "rådlös"},
		{"rådlöshet", "rådlös"},
		{"rådman", "rådman"},
		{"rådplägning", "rådplägning"},
		{"rådplägningar", "rådplägning"},
		{"rådrum", "rådrum"},
		{"råds", "råd"},
		{"rådsförsamling", "rådsförsamling"},
		{"rådslaget", "rådslaget"},
		{"rådt", "rådt"},
		{"rådvill", "rådvill"},
		{"råe", "råe"},
		{"råg", "råg"},
		{"råga", "råg"},
		{"rågade", "råg"},
		{"rågadt", "rågad"},
		{"rågen", "råg"},
		{"rågfält", "rågfält"},
		{"råhet", "råhet"},
		{"råheten", "råhet"},
		{"råk", "råk"},
		{"råka", "råk"},
		{"råkade", "råk"},
		{"råkar", "råk"},
		{"råkas", "råk"},
		{"råkat", "råk"},
		{"råmade", "råm"},
		{"råmandet", "råm"},
		{"råmar", "råm"},
		{"rån", "rån"},
		{"rår", "rår"},
		{"rått", "rått"},
		{"råtta", "rått"},
		{"råttan", "råttan"},
		{"råttbo", "råttbo"},
		{"råttfälla", "råttfäll"},
		{"råttor", "rått"},
		{"råttsvansar", "råttsvans"},
		{"råttögon", "råttögon"},
		{"rö", "rö"},
		{"röcko", "röcko"},
		{"röd", "röd"},
		{"röda", "röd"},
		{"rödaktiga", "rödakt"},
		{"rödare", "röd"},
		{"rödblommig", "rödblomm"},
		{"rödblommiga", "rödblomm"},
		{"rödblå", "rödblå"},
		{"rödbrusig", "rödbrus"},
		{"rödbrusige", "rödbrus"},
		{"röde", "röd"},
		{"rödflammiga", "rödflamm"},
		{"rödfärgad", "rödfärg"},
		{"rödgula", "rödgul"},
		{"rödkantade", "rödkant"},
		{"rödletta", "rödlet"},
		{"rödlätta", "rödlät"},
		{"rödmålade", "rödmål"},
		{"rödrandig", "rödrand"},
		{"rödrandiga", "rödrand"},
		{"rödskinn", "rödskin"},
		{"rödviolett", "rödviolet"},
		{"röfvar", "röfv"},
		{"röja", "röj"},
		{"röjas", "röj"},
		{"röjde", "röjd"},
		{"röjdes", "röjd"},
		{"röjer", "röj"},
		{"röjt", "röjt"},
		{"rök", "rök"},
		{"röka", "rök"},
		{"rökade", "rök"},
		{"rökande", "rök"},
		{"rökare", "rök"},
		{"rökelse", "rök"},
		{"rökelsekar", "rökelsek"},
		{"rökelsemolnen", "rökelsemoln"},
		{"rökelsen", "rök"},
		{"röken", "rök"},
		{"röker", "rök"},
		{"rökhytten", "rökhyt"},
		{"rökmoln", "rökmoln"},
		{"rökmolnen", "rökmoln"},
		{"rökn", "rökn"},
		{"röknarna", "rökn"},
		{"röknarnn", "röknarn"},
		{"röknonno", "röknonno"},
		{"rökoffer", "rökoff"},
		{"rökpelare", "rökpel"},
		{"rökpelaren", "rökpel"},
		{"rökring", "rökring"},
		{"rökringen", "rökring"},
		{"rökrum", "rökrum"},
		{"rökrummet", "rökrummet"},
		{"rökt", "rökt"},
		{"rökte", "rökt"},
		{"rökunrnn", "rökunrn"},
		{"röl", "röl"},
		{"römt", "römt"},
		{"rön", "rön"},
		{"röna", "rön"},
		{"rönet", "rönet"},
		{"rönl", "rönl"},
		{"rönnarnas", "rönn"},
		{"rönnbären", "rönnbär"},
		{"rönt", "rönt"},
		{"rönte", "rönt"},
		{"röntgen", "röntg"},
		{"röntgenfotograferats", "röntgenfotograferat"},
		{"rör", "rör"},
		{"röra", "rör"},
		{"rörande", "rör"},
		{"röras", "rör"},
		{"rörd", "rörd"},
		{"rörda", "rörd"},
		{"rörde", "rörd"},
		{"rördes", "rörd"},
		{"rörelse", "rör"},
		{"rörelsegrader", "rörelsegrad"},
		{"rörelsen", "rör"},
		{"rörelser", "rör"},
		{"rörelserna", "rör"},
		{"rörer", "rör"},
		{"röret", "röret"},
		{"rörlig", "rör"},
		{"rörliga", "rör"},
		{"rörlighet", "rör"},
		{"rörligt", "rör"},
		{"rörsoffan", "rörsoffan"},
		{"rörstrand", "rörstrand"},
		{"rört", "rört"},
		{"rös", "rös"},
		{"röst", "röst"},
		{"rösten", "röst"},
		{"röstens", "röst"},
		{"röster", "röst"},
		{"rösterna", "röst"},
		{"rösts", "röst"},
		{"röt", "röt"},
		{"röta", "röt"},
		{"rötmånadshetta", "rötmånadshet"},
		{"rött", "rött"},
		{"rötta", "rött"},
		{"rötter", "rött"},
		{"rötägg", "rötägg"},
		{"röva", "röv"},
		{"s", "s"},
		{"sa", "sa"},
		{"saa", "saa"},
		{"sabbat", "sabb"},
		{"sabbatsfärd", "sabbatsfärd"},
		{"sabina", "sabin"},
		{"sabinas", "sabin"},
		{"sabiuas", "sabiu"},
		{"sablar", "sabl"},
		{"sack", "sack"},
		{"sadan", "sadan"},
		{"sadana", "sadan"},
		{"sadant", "sadant"},
		{"sadc", "sadc"},
		{"sade", "sad"},
		{"sades", "sad"},
		{"saft", "saft"},
		{"saftade", "saft"},
		{"saftig", "saft"},
		{"saftiga", "saft"},
		{"saftigt", "saft"},
		{"sag", "sag"},
		{"saga", "sag"},
		{"sagan", "sagan"},
		{"sagans", "sagan"},
		{"sagbok", "sagbok"},
		{"sagboken", "sagbok"},
		{"sagdt", "sagd"},
		{"sage", "sag"},
		{"sager", "sag"},
		{"sagogången", "sagogång"},
		{"sagokungen", "sagokung"},
		{"sagolika", "sagolik"},
		{"sagolikt", "sagolik"},
		{"sagoprins", "sagoprin"},
		{"sagor", "sag"},
		{"sagorna", "sag"},
		{"sagoslott", "sagoslot"},
		{"sagotiden", "sagotid"},
		{"sagspanen", "sagspan"},
		{"sagt", "sagt"},
		{"sak", "sak"},
		{"sakar", "sak"},
		{"saken", "sak"},
		{"sakens", "sak"},
		{"saker", "sak"},
		{"sakerna", "sak"},
		{"sakernas", "sak"},
		{"sakert", "sakert"},
		{"sakligt", "sak"},
		{"sakna", "sakn"},
		{"saknad", "sakn"},
		{"saknade", "sakn"},
		{"saknaden", "saknad"},
		{"saknades", "sakn"},
		{"saknar", "sakn"},
		{"saknas", "sakn"},
		{"saknat", "sakn"},
		{"sakramenskade", "sakramensk"},
		{"sakrament", "sakrament"},
		{"sakristian", "sakristian"},
		{"sakristians", "sakristian"},
		{"sakta", "sakt"},
		{"saktade", "sakt"},
		{"saktar", "sakt"},
		{"saktare", "sakt"},
		{"saktat", "sakt"},
		{"saktmod", "saktmod"},
		{"saktmodig", "saktmod"},
		{"saktmodigt", "saktmod"},
		{"sal", "sal"},
		{"salcional", "salcional"},
		{"salen", "sal"},
		{"salens", "sal"},
		{"salig", "sal"},
		{"saliga", "sal"},
		{"salighet", "sal"},
		{"saligheten", "sal"},
		{"saligheters", "saligheter"},
		{"saligt", "sal"},
		{"saliven", "saliv"},
		{"sallan", "sallan"},
		{"sally", "sally"},
		{"sallys", "sally"},
		{"saln", "saln"},
		{"salomo", "salomo"},
		{"salomos", "salomo"},
		{"salong", "salong"},
		{"salongen", "salong"},
		{"salongsbordet", "salongsbordet"},
		{"salsbordet", "salsbordet"},
		{"salsdörren", "salsdörr"},
		{"salsfönstret", "salsfönstret"},
		{"salsgolvet", "salsgolvet"},
		{"salt", "salt"},
		{"salta", "salt"},
		{"saltet", "saltet"},
		{"saltkorn", "saltkorn"},
		{"saltvatten", "saltvat"},
		{"salvan", "salvan"},
		{"sam", "sam"},
		{"samband", "samband"},
		{"samfund", "samfund"},
		{"samfundsförhållande", "samfundsförhåll"},
		{"samhet", "sam"},
		{"samheten", "sam"},
		{"samhälle", "samhäll"},
		{"samhället", "samhället"},
		{"samhällslivet", "samhällslivet"},
		{"samhällsorganisationens", "samhällsorganisation"},
		{"samhällsvetenskapen", "samhällsvetenskap"},
		{"samhörighet", "samhör"},
		{"samklang", "samklang"},
		{"samkväm", "samkväm"},
		{"samla", "saml"},
		{"samlad", "saml"},
		{"samlade", "saml"},
		{"samlades", "saml"},
		{"samlag", "samlag"},
		{"samlalet", "samlalet"},
		{"samlar", "saml"},
		{"samlare", "saml"},
		{"samlas", "saml"},
		{"samlat", "saml"},
		{"samlats", "samlat"},
		{"samling", "samling"},
		{"samlingen", "samling"},
		{"samma", "samm"},
		{"samman", "samman"},
		{"sammanbinda", "sammanbind"},
		{"sammanbinder", "sammanbind"},
		{"sammanbitet", "sammanbitet"},
		{"sammanbitna", "sammanbitn"},
		{"sammanblandat", "sammanbland"},
		{"sammanbrott", "sammanbrot"},
		{"sammandragna", "sammandragn"},
		{"sammandragning", "sammandragning"},
		{"sammandrog", "sammandrog"},
		{"sammanfattningen", "sammanfattning"},
		{"sammanflöt", "sammanflöt"},
		{"sammanföll", "sammanföll"},
		{"sammanhang", "sammanhang"},
		{"sammanhanget", "sammanhanget"},
		{"sammanhängde", "sammanhäng"},
		{"sammanhölle", "sammanhöll"},
		{"sammanklistrade", "sammanklistr"},
		{"sammanknipna", "sammanknipn"},
		{"sammanknuten", "sammanknut"},
		{"sammanknycklat", "sammanknyckl"},
		{"sammanknäppta", "sammanknäppt"},
		{"sammankom", "sammankom"},
		{"sammankomma", "sammankomm"},
		{"sammankomst", "sammankomst"},
		{"sammankomster", "sammankomst"},
		{"sammanlagt", "sammanlag"},
		{"sammanlevnad", "sammanlevn"},
		{"sammanlänka", "sammanlänk"},
		{"sammanpressad", "sammanpress"},
		{"sammanpressade", "sammanpress"},
		{"sammanpressades", "sammanpress"},
		{"sammanrafsat", "sammanrafs"},
		{"sammans", "samman"},
		{"sammanslagna", "sammanslagn"},
		{"sammanslingrade", "sammanslingr"},
		{"sammansluten", "sammanslut"},
		{"sammanslutning", "sammanslutning"},
		{"sammanslå", "sammanslå"},
		{"sammansmälte", "sammansmält"},
		{"sammansmälter", "sammansmält"},
		{"sammansnörd", "sammansnörd"},
		{"sammanstämma", "sammanstämm"},
		{"sammansättning", "sammansättning"},
		{"sammansättningar", "sammansättning"},
		{"sammantorkad", "sammantork"},
		{"sammantrasslat", "sammantrassl"},
		{"sammantryckt", "sammantryck"},
		{"sammantryckta", "sammantryck"},
		{"sammanträde", "sammanträd"},
		{"sammanträden", "sammanträd"},
		{"sammanträffande", "sammanträff"},
		{"sammanträtt", "sammanträt"},
		{"sammanvaro", "sammanvaro"},
		{"samme", "samm"},
		{"sammet", "sammet"},
		{"sammetsblad", "sammetsbl"},
		{"sammetsblus", "sammetsblus"},
		{"sammetskind", "sammetskind"},
		{"sammetskorsett", "sammetskorset"},
		{"sammetslen", "sammetsl"},
		{"sammetslena", "sammetslen"},
		{"sammetslent", "sammetslent"},
		{"sammetsmjukhet", "sammetsmjuk"},
		{"samråd", "samråd"},
		{"samråda", "samråd"},
		{"sams", "sam"},
		{"samsas", "sams"},
		{"samspråk", "samspråk"},
		{"samspråkat", "samspråk"},
		{"samt", "samt"},
		{"samtal", "samtal"},
		{"samtalade", "samtal"},
		{"samtalet", "samtalet"},
		{"samtalets", "samtalet"},
		{"samtalsform", "samtalsform"},
		{"samtalsämnet", "samtalsämnet"},
		{"samtida", "samtid"},
		{"samtidigt", "samtid"},
		{"samtliga", "samt"},
		{"samtycke", "samtyck"},
		{"samtycker", "samtyck"},
		{"samtyckt", "samtyck"},
		{"samuels", "samuel"},
		{"samuelsgatan", "samuelsgatan"},
		{"samvaro", "samvaro"},
		{"samvete", "samvet"},
		{"samveten", "samvet"},
		{"samvetet", "samvetet"},
		{"samvetets", "samvetet"},
		{"samvetsagg", "samvetsagg"},
		{"samvetsgrann", "samvetsgran"},
		{"samvetsgrant", "samvetsgrant"},
		{"samvetskval", "samvetskval"},
		{"samvetslösa", "samvetslös"},
		{"samvetsqval", "samvetsqval"},
		{"samvetssak", "samvetssak"},
		{"san", "san"},
		{"sanatoriet", "sanatoriet"},
		{"sanatorium", "sanatorium"},
		{"sand", "sand"},
		{"sandbottnen", "sandbottn"},
		{"sande", "sand"},
		{"sanden", "sand"},
		{"sandgangen", "sandgang"},
		{"sandgången", "sandgång"},
		{"sandhogen", "sandhog"},
		{"sandkornen", "sandkorn"},
		{"sandplan", "sandplan"},
		{"sandstranden", "sandstr"},
		{"sang", "sang"},
		{"sangen", "sang"},
		{"sanger", "sang"},
		{"sangren", "sangr"},
		{"sankta", "sank"},
		{"sankte", "sank"},
		{"sann", "sann"},
		{"sanna", "sann"},
		{"sannerligen", "sanner"},
		{"sannfärdeligen", "sannfärde"},
		{"sannfärdigheten", "sannfärd"},
		{"sanning", "sanning"},
		{"sanningen", "sanning"},
		{"sanningens", "sanning"},
		{"sanningsdoser", "sanningsdos"},
		{"sanningsenligt", "sanningsen"},
		{"sanningsjakt", "sanningsjak"},
		{"sanningsmängd", "sanningsmäng"},
		{"sannolik", "sannolik"},
		{"sannolikhet", "sannolik"},
		{"sannolikheten", "sannolik"},
		{"sannolikt", "sannolik"},
		{"sannskyldiga", "sannskyld"},
		{"sans", "san"},
		{"sansa", "sans"},
		{"sanslöse", "sanslös"},
		{"sanslöshet", "sanslös"},
		{"sansning", "sansning"},
		{"sansningen", "sansning"},
		{"sant", "sant"},
		{"sar", "sar"},
		{"sarade", "sar"},
		{"sardiner", "sardin"},
		{"sardoniskt", "sardonisk"},
		{"sargad", "sarg"},
		{"sarkasmer", "sarkasm"},
		{"sarkofag", "sarkofag"},
		{"sarkom", "sarkom"},
		{"saron", "saron"},
		{"sarskilt", "sarskilt"},
		{"sasom", "sasom"},
		{"satan", "satan"},
		{"sataniskt", "satanisk"},
		{"satans", "satan"},
		{"satar", "sat"},
		{"satinturc", "satinturc"},
		{"satinturcklädningen", "satinturcklädning"},
		{"satirisk", "satirisk"},
		{"sats", "sat"},
		{"satt", "satt"},
		{"satta", "satt"},
		{"satte", "satt"},
		{"satureja", "saturej"},
		{"satyrgrin", "satyrgrin"},
		{"saviga", "sav"},
		{"sax", "sax"},
		{"saxen", "sax"},
		{"saxofon", "saxofon"},
		{"sc", "sc"},
		{"scdan", "scdan"},
		{"scen", "scen"},
		{"scenen", "scen"},
		{"scener", "scen"},
		{"scenerier", "sceneri"},
		{"scenerna", "scen"},
		{"scgra", "scgra"},
		{"sch", "sch"},
		{"schabrak", "schabrak"},
		{"schack", "schack"},
		{"schackbrädet", "schackbrädet"},
		{"schackproblem", "schackproblem"},
		{"schackspelarens", "schackspel"},
		{"schackspirs", "schackspir"},
		{"schaggsoffan", "schaggsoffan"},
		{"schaggstolar", "schaggstol"},
		{"schakt", "schakt"},
		{"schal", "schal"},
		{"schalar", "schal"},
		{"schalarne", "schal"},
		{"schalen", "schal"},
		{"schalett", "schalet"},
		{"schaletten", "schalet"},
		{"schaletterna", "schalet"},
		{"scharlakanslängtan", "scharlakanslängtan"},
		{"schartaus", "schartaus"},
		{"schasa", "schas"},
		{"schasar", "schas"},
		{"schatterat", "schatter"},
		{"schatull", "schatull"},
		{"schavott", "schavot"},
		{"scheeles", "scheel"},
		{"scheurer", "scheur"},
		{"schism", "schism"},
		{"schopenhauer", "schopenhau"},
		{"schrader", "schrad"},
		{"schweitzeri", "schweitzeri"},
		{"schweiz", "schweiz"},
		{"schweizerierna", "schweizeri"},
		{"schäs", "schäs"},
		{"schäskärran", "schäskärran"},
		{"schäslong", "schäslong"},
		{"schäslongen", "schäslong"},
		{"scr", "scr"},
		{"sd", "sd"},
		{"sdong", "sdong"},
		{"se", "se"},
		{"sedan", "sedan"},
		{"sedd", "sedd"},
		{"sedel", "sedel"},
		{"sedelbok", "sedelbok"},
		{"sedeln", "sedeln"},
		{"seden", "sed"},
		{"seder", "sed"},
		{"sedermera", "sedermer"},
		{"sedesamt", "sedesamt"},
		{"sediga", "sed"},
		{"sedigt", "sed"},
		{"sedlar", "sedl"},
		{"sedlig", "sed"},
		{"sedliga", "sed"},
		{"sedligaste", "sed"},
		{"sedlighet", "sed"},
		{"sedlighetsbrott", "sedlighetsbrot"},
		{"sedligt", "sed"},
		{"sedvanligt", "sedvan"},
		{"seende", "seend"},
		{"sega", "seg"},
		{"segel", "segel"},
		{"segelbåt", "segelbåt"},
		{"segelbåten", "segelbåt"},
		{"segelduksbyxor", "segelduksbyx"},
		{"segelfärdig", "segelfärd"},
		{"segelfärdiga", "segelfärd"},
		{"segellapparne", "segellapp"},
		{"segelleden", "segelled"},
		{"segeltur", "segeltur"},
		{"segeltältet", "segeltältet"},
		{"seger", "seg"},
		{"segerkraft", "segerkraft"},
		{"segerkrans", "segerkran"},
		{"segerstolt", "segerstolt"},
		{"seghet", "seg"},
		{"segla", "segl"},
		{"seglade", "segl"},
		{"seglar", "segl"},
		{"seglare", "segl"},
		{"seglarn", "seglarn"},
		{"seglat", "segl"},
		{"seglen", "segl"},
		{"seglet", "seglet"},
		{"segling", "segling"},
		{"segra", "segr"},
		{"segrade", "segr"},
		{"segrande", "segr"},
		{"segrar", "segr"},
		{"segraren", "segr"},
		{"segrat", "segr"},
		{"sekelslutet", "sekelslutet"},
		{"sekler", "sekl"},
		{"seklet", "seklet"},
		{"seklets", "seklet"},
		{"sekretären", "sekretär"},
		{"sekter", "sekt"},
		{"sekterisk", "sekterisk"},
		{"sektern", "sekt"},
		{"sekterns", "sekt"},
		{"sekun", "sekun"},
		{"sekund", "sekund"},
		{"sekunden", "sekund"},
		{"sekunder", "sekund"},
		{"sekunderna", "sekund"},
		{"sekunders", "sekunder"},
		{"sekunds", "sekund"},
		{"sel", "sel"},
		{"seln", "seln"},
		{"semesterresor", "semesterres"},
		{"seminariets", "seminariet"},
		{"semper", "semp"},
		{"sen", "sen"},
		{"sena", "sen"},
		{"senap", "senap"},
		{"senare", "sen"},
		{"senast", "sen"},
		{"senaste", "sen"},
		{"senbösten", "senböst"},
		{"sene", "sen"},
		{"seneca", "senec"},
		{"senig", "sen"},
		{"senior", "seni"},
		{"sensation", "sensation"},
		{"sensationshistoria", "sensationshistori"},
		{"sensationsutlovande", "sensationsutlov"},
		{"sensommardag", "sensommardag"},
		{"sensommaren", "sensomm"},
		{"sensommarmörkrets", "sensommarmörkret"},
		{"sensommarsol", "sensommarsol"},
		{"sent", "sent"},
		{"sentimental", "sentimental"},
		{"sentimentala", "sentimental"},
		{"sentimentalt", "sentimentalt"},
		{"september", "septemb"},
		{"septemberdag", "septemberdag"},
		{"ser", "ser"},
		{"sermo", "sermo"},
		{"servera", "server"},
		{"serverade", "server"},
		{"serverades", "server"},
		{"serveringen", "servering"},
		{"serveringsflickan", "serveringsflickan"},
		{"serveten", "servet"},
		{"servett", "servet"},
		{"servetten", "servet"},
		{"servetter", "servet"},
		{"servetterna", "servet"},
		{"servilt", "servilt"},
		{"servisen", "servis"},
		{"serviser", "servis"},
		{"ses", "ses"},
		{"seså", "seså"},
		{"sett", "sett"},
		{"seulement", "seulement"},
		{"sex", "sex"},
		{"sexa", "sex"},
		{"sexstyverslant", "sexstyverslant"},
		{"sextiden", "sextid"},
		{"sextio", "sextio"},
		{"sextiosex", "sextiosex"},
		{"sexton", "sexton"},
		{"sextonde", "sextond"},
		{"sextonskilling", "sextonskilling"},
		{"sextonårig", "sextonår"},
		{"sextonåriga", "sextonår"},
		{"sextonårigt", "sextonår"},
		{"sf", "sf"},
		{"sffälle", "sffäll"},
		{"sfi", "sfi"},
		{"sfinxens", "sfinx"},
		{"sfär", "sfär"},
		{"sfärer", "sfär"},
		{"shakespeares", "shakespear"},
		{"shl", "shl"},
		{"shls", "shls"},
		{"shlta", "shlta"},
		{"shod", "shod"},
		{"si", "si"},
		{"siade", "siad"},
		{"siarskägg", "siarskägg"},
		{"sick", "sick"},
		{"sicksack", "sicksack"},
		{"sida", "sid"},
		{"sidan", "sidan"},
		{"siden", "sid"},
		{"sidenband", "sidenband"},
		{"sidenduk", "sidenduk"},
		{"sidenet", "sidenet"},
		{"sidenhatt", "sidenhat"},
		{"sidenkappa", "sidenkapp"},
		{"sidenkläder", "sidenkläd"},
		{"sidenklänning", "sidenklänning"},
		{"sidenknä", "sidenknä"},
		{"sidenkofta", "sidenkoft"},
		{"sidenkramhandlare", "sidenkramhandl"},
		{"sidennattrock", "sidennattrock"},
		{"sidennäsduk", "sidennäsduk"},
		{"sidenpaletå", "sidenpaletå"},
		{"sidenpäls", "sidenpäl"},
		{"sidenrock", "sidenrock"},
		{"sidenrosett", "sidenroset"},
		{"sidenrosetter", "sidenroset"},
		{"sidenschal", "sidenschal"},
		{"sidentak", "sidentak"},
		{"sidentyger", "sidentyg"},
		{"sidentyget", "sidentyget"},
		{"sidentäckta", "sidentäck"},
		{"sidlänt", "sidlänt"},
		{"sidoblick", "sidoblick"},
		{"sidogata", "sidogat"},
		{"sidokammarn", "sidokammarn"},
		{"sidolinjen", "sidolinj"},
		{"sidor", "sid"},
		{"sidorna", "sid"},
		{"sidorum", "sidorum"},
		{"sidotankar", "sidotank"},
		{"sidoväg", "sidoväg"},
		{"sidstycket", "sidstycket"},
		{"siffror", "siffr"},
		{"sig", "sig"},
		{"sigill", "sigill"},
		{"sigillet", "sigillet"},
		{"signal", "signal"},
		{"signalen", "signal"},
		{"signetring", "signetring"},
		{"sigra", "sigr"},
		{"sigretadtillnyfikenhet", "sigretadtillnyfiken"},
		{"sigte", "sigt"},
		{"siig", "siig"},
		{"siiverklart", "siiverklart"},
		{"sikta", "sikt"},
		{"siktade", "sikt"},
		{"sikte", "sikt"},
		{"sikten", "sikt"},
		{"siktena", "sikten"},
		{"siktet", "siktet"},
		{"siktiga", "sikt"},
		{"siktigt", "sikt"},
		{"sil", "sil"},
		{"sila", "sil"},
		{"silade", "sil"},
		{"silande", "sil"},
		{"silfret", "silfret"},
		{"silfverklockan", "silfverklockan"},
		{"silfverlampa", "silfverlamp"},
		{"silfverstjerna", "silfverstj"},
		{"silhuett", "silhuet"},
		{"silhuetten", "silhuet"},
		{"silhuetter", "silhuet"},
		{"siljan", "siljan"},
		{"silke", "silk"},
		{"silkes", "silk"},
		{"silkesblommor", "silkesblomm"},
		{"silkesduken", "silkesduk"},
		{"silkesfloret", "silkesfloret"},
		{"silkeshalsduk", "silkeshalsduk"},
		{"silkeshåret", "silkeshåret"},
		{"silkeslen", "silkesl"},
		{"silkeslena", "silkeslen"},
		{"silkeslent", "silkeslent"},
		{"silkesnäsduk", "silkesnäsduk"},
		{"silkespapper", "silkespapp"},
		{"silkesperuk", "silkesperuk"},
		{"silkesschal", "silkesschal"},
		{"silkesschalen", "silkesschal"},
		{"silkessnodder", "silkessnod"},
		{"silkesstrumporna", "silkesstrump"},
		{"silkesvirret", "silkesvirret"},
		{"silket", "silket"},
		{"silkets", "silket"},
		{"sill", "sill"},
		{"sillstrypare", "sillstryp"},
		{"sillstryparn", "sillstryparn"},
		{"silter", "silt"},
		{"silvanders", "silvander"},
		{"silver", "silv"},
		{"silverax", "silverax"},
		{"silverbeslagen", "silverbeslag"},
		{"silverboetten", "silverboet"},
		{"silverbägare", "silverbäg"},
		{"silverfågel", "silverfågel"},
		{"silvergaffel", "silvergaffel"},
		{"silverglänsande", "silvergläns"},
		{"silverklang", "silverklang"},
		{"silverklara", "silverklar"},
		{"silverklingande", "silverkling"},
		{"silverkniv", "silverkniv"},
		{"silverpapper", "silverpapp"},
		{"silverpokaler", "silverpokal"},
		{"silverrösten", "silverröst"},
		{"silverskedar", "silversked"},
		{"silverskålen", "silverskål"},
		{"silverslant", "silverslant"},
		{"silverslantar", "silverslant"},
		{"silversprängda", "silverspräng"},
		{"silverstake", "silverstak"},
		{"silverstrimma", "silverstrimm"},
		{"simma", "simm"},
		{"simmade", "simm"},
		{"simmande", "simm"},
		{"simmar", "simm"},
		{"simme", "simm"},
		{"simmerska", "simmersk"},
		{"simon", "simon"},
		{"simons", "simon"},
		{"simpel", "simpel"},
		{"simpelt", "simpelt"},
		{"simpla", "simpl"},
		{"simtag", "simtag"},
		{"simulerade", "simuler"},
		{"sin", "sin"},
		{"sina", "sin"},
		{"sinas", "sin"},
		{"sine", "sin"},
		{"sinistrement", "sinistrement"},
		{"sinnad", "sinn"},
		{"sinnade", "sinn"},
		{"sinne", "sinn"},
		{"sinnelag", "sinnelag"},
		{"sinnen", "sinn"},
		{"sinnena", "sinnen"},
		{"sinnenas", "sinnen"},
		{"sinnens", "sinn"},
		{"sinnes", "sinn"},
		{"sinnesbeskaffenhet", "sinnesbeskaffen"},
		{"sinnesförvirring", "sinnesförvirring"},
		{"sinnesförvirringen", "sinnesförvirring"},
		{"sinnesnärvaro", "sinnesnärvaro"},
		{"sinnesoredan", "sinnesoredan"},
		{"sinnesoro", "sinnesoro"},
		{"sinnesrubbning", "sinnesrubbning"},
		{"sinnesrörelse", "sinnesrör"},
		{"sinnessjukdom", "sinnessjukdom"},
		{"sinnessjuke", "sinnessjuk"},
		{"sinnessjukhus", "sinnessjukhus"},
		{"sinnesskakning", "sinnesskakning"},
		{"sinnesstyrka", "sinnesstyrk"},
		{"sinnesstämning", "sinnesstämning"},
		{"sinnessvag", "sinnessvag"},
		{"sinnessvage", "sinnessvag"},
		{"sinnesuppbrusning", "sinnesuppbrusning"},
		{"sinnesyra", "sinnesyr"},
		{"sinnet", "sinnet"},
		{"sinnigt", "sinn"},
		{"sinnliga", "sinn"},
		{"sinnlighet", "sinn"},
		{"sinnligt", "sinn"},
		{"sinnrik", "sinnrik"},
		{"sinnrika", "sinnrik"},
		{"sinom", "sinom"},
		{"sinsemellan", "sinsemellan"},
		{"sinstorakappa", "sinstorakapp"},
		{"sio", "sio"},
		{"sion", "sion"},
		{"sions", "sion"},
		{"sippare", "sipp"},
		{"sippor", "sipp"},
		{"sipprade", "sippr"},
		{"sirap", "sirap"},
		{"siratens", "sirat"},
		{"sirenen", "siren"},
		{"sirlig", "sir"},
		{"sirliga", "sir"},
		{"sist", "sist"},
		{"sista", "sist"},
		{"siste", "sist"},
		{"sistone", "siston"},
		{"sitt", "sitt"},
		{"sitta", "sitt"},
		{"sittande", "sitt"},
		{"sitter", "sitt"},
		{"situation", "situation"},
		{"situationen", "situation"},
		{"situationer", "situation"},
		{"siuta", "siut"},
		{"sj", "sj"},
		{"sjal", "sjal"},
		{"sjalv", "sjalv"},
		{"sjelf", "sjelf"},
		{"sjelfbeherskning", "sjelfbeherskning"},
		{"sjelfförsvar", "sjelfförsv"},
		{"sjelfförvillelsens", "sjelfförvill"},
		{"sjelfkänsla", "sjelfkänsl"},
		{"sjelfkärlek", "sjelfkärlek"},
		{"sjelfmant", "sjelfmant"},
		{"sjelfständig", "sjelfständ"},
		{"sjelfsvåldig", "sjelfsvåld"},
		{"sjelfsvåldiga", "sjelfsvåld"},
		{"sjelft", "sjelft"},
		{"sjelfva", "sjelfv"},
		{"sjelfvaste", "sjelfv"},
		{"sjette", "sjett"},
		{"sjiilv", "sjiilv"},
		{"sjll", "sjll"},
		{"sjmlga", "sjmlga"},
		{"sjongo", "sjongo"},
		{"sjonk", "sjonk"},
		{"sjtik", "sjtik"},
		{"sju", "sju"},
		{"sjuda", "sjud"},
		{"sjudande", "sjud"},
		{"sjugare", "sjug"},
		{"sjuhundrade", "sjuhundr"},
		{"sjuk", "sjuk"},
		{"sjuka", "sjuk"},
		{"sjukbesök", "sjukbesök"},
		{"sjukbädd", "sjukbäd"},
		{"sjukdom", "sjukdom"},
		{"sjukdomar", "sjukdom"},
		{"sjukdomen", "sjukdom"},
		{"sjukdomens", "sjukdom"},
		{"sjukdomsfall", "sjukdomsfall"},
		{"sjukdomsmörkret", "sjukdomsmörkret"},
		{"sjuke", "sjuk"},
		{"sjukes", "sjuk"},
		{"sjukhem", "sjukhem"},
		{"sjukhemmet", "sjukhemmet"},
		{"sjukhus", "sjukhus"},
		{"sjuklig", "sjuk"},
		{"sjukliga", "sjuk"},
		{"sjuklige", "sjuk"},
		{"sjuklighet", "sjuk"},
		{"sjukling", "sjukling"},
		{"sjuklingen", "sjukling"},
		{"sjuklägret", "sjuklägret"},
		{"sjuknade", "sjukn"},
		{"sjuknat", "sjukn"},
		{"sjukroll", "sjukroll"},
		{"sjukrummet", "sjukrummet"},
		{"sjuksköterska", "sjukskötersk"},
		{"sjuksköterskan", "sjuksköterskan"},
		{"sjuksköterskeelev", "sjuksköterskeelev"},
		{"sjuksystern", "sjuksyst"},
		{"sjuksäng", "sjuksäng"},
		{"sjukt", "sjukt"},
		{"sjukvård", "sjukvård"},
		{"sjunde", "sjund"},
		{"sjung", "sjung"},
		{"sjunga", "sjung"},
		{"sjungande", "sjung"},
		{"sjungandes", "sjung"},
		{"sjunge", "sjung"},
		{"sjunger", "sjung"},
		{"sjunges", "sjung"},
		{"sjungit", "sjungit"},
		{"sjunka", "sjunk"},
		{"sjunkandct", "sjunkandct"},
		{"sjunkande", "sjunk"},
		{"sjunken", "sjunk"},
		{"sjunker", "sjunk"},
		{"sjunket", "sjunket"},
		{"sjunkit", "sjunkit"},
		{"sjuttio", "sjuttio"},
		{"sjutton", "sjutton"},
		{"sjuttonarig", "sjuttonar"},
		{"sjuttonariga", "sjuttonar"},
		{"sjuttonaring", "sjuttonaring"},
		{"sjuttonde", "sjuttond"},
		{"sjuttonhundratalet", "sjuttonhundratalet"},
		{"sjuårig", "sjuår"},
		{"sjuårigt", "sjuår"},
		{"sjä", "sjä"},
		{"sjäiv", "sjäiv"},
		{"själ", "själ"},
		{"själafrände", "själafränd"},
		{"själar", "själ"},
		{"själarna", "själ"},
		{"själarne", "själ"},
		{"själars", "själar"},
		{"själasörjare", "själasörj"},
		{"själen", "själ"},
		{"själens", "själ"},
		{"själft", "själft"},
		{"själfulla", "själfull"},
		{"själs", "själ"},
		{"själslidanden", "själslid"},
		{"själsläkekonstnärerna", "själsläkekonstnär"},
		{"själsnärvaro", "själsnärvaro"},
		{"själsstrid", "själsstrid"},
		{"själsstyrka", "själsstyrk"},
		{"själv", "själv"},
		{"själva", "själv"},
		{"självaste", "själv"},
		{"självbe", "självb"},
		{"självbehärskning", "självbehärskning"},
		{"självbelåtna", "självbelåtn"},
		{"självbelåtne", "självbelåtn"},
		{"självdyrkan", "självdyrkan"},
		{"självförakt", "självförak"},
		{"självförebråelse", "självförebrå"},
		{"självförtroende", "självförtroend"},
		{"självförtröstan", "självförtröstan"},
		{"självförvärvd", "självförvärvd"},
		{"själviska", "självisk"},
		{"själviskhet", "självisk"},
		{"självklart", "självklart"},
		{"självmant", "självmant"},
		{"självmedveten", "självmedvet"},
		{"självmord", "självmord"},
		{"självmordstankar", "självmordstank"},
		{"självrådig", "självråd"},
		{"självsvåldigt", "självsvåld"},
		{"självsäker", "självsäk"},
		{"självt", "självt"},
		{"sjätte", "sjätt"},
		{"sjålv", "sjålv"},
		{"sjålva", "sjålv"},
		{"sjö", "sjö"},
		{"sjöar", "sjöar"},
		{"sjöberg", "sjöberg"},
		{"sjöbodarne", "sjöbod"},
		{"sjöboden", "sjöbod"},
		{"sjöbottnen", "sjöbottn"},
		{"sjöbussen", "sjöbuss"},
		{"sjöd", "sjöd"},
		{"sjöfarande", "sjöfar"},
		{"sjöfarare", "sjöfar"},
		{"sjöfoglar", "sjöfogl"},
		{"sjöfoglarne", "sjöfogl"},
		{"sjöfåglarne", "sjöfågl"},
		{"sjöförklaring", "sjöförklaring"},
		{"sjögräs", "sjögräs"},
		{"sjögräset", "sjögräset"},
		{"sjögrönt", "sjögrönt"},
		{"sjögången", "sjögång"},
		{"sjöhistorier", "sjöhistori"},
		{"sjöhistorierna", "sjöhistori"},
		{"sjöluften", "sjöluft"},
		{"sjöman", "sjöman"},
		{"sjömannen", "sjöman"},
		{"sjömannens", "sjöman"},
		{"sjömans", "sjöman"},
		{"sjömansgosse", "sjömansgoss"},
		{"sjömanskavaj", "sjömanskavaj"},
		{"sjömanskostym", "sjömanskostym"},
		{"sjömanssjälen", "sjömanssjäl"},
		{"sjömän", "sjömän"},
		{"sjömännen", "sjömän"},
		{"sjön", "sjön"},
		{"sjöng", "sjöng"},
		{"sjöngo", "sjöngo"},
		{"sjönk", "sjönk"},
		{"sjönko", "sjönko"},
		{"sjöns", "sjön"},
		{"sjöröfvaren", "sjöröfv"},
		{"sjöröfvarn", "sjöröfvarn"},
		{"sjös", "sjös"},
		{"sjösjuka", "sjösjuk"},
		{"sjöskumspipa", "sjöskumspip"},
		{"sjöslag", "sjöslag"},
		{"sjöstranden", "sjöstr"},
		{"sjötullstaxan", "sjötullstaxan"},
		{"sjötungsfilet", "sjötungsfilet"},
		{"sjöväsendet", "sjöväsendet"},
		{"sk", "sk"},
		{"ska", "ska"},
		{"skacklorna", "skackl"},
		{"skada", "skad"},
		{"skadad", "skad"},
		{"skadade", "skad"},
		{"skadan", "skadan"},
		{"skadar", "skad"},
		{"skadat", "skad"},
		{"skade", "skad"},
		{"skadeersättning", "skadeersättning"},
		{"skadeglatt", "skadeglat"},
		{"skadeglädje", "skadeglädj"},
		{"skadeglädjen", "skadeglädj"},
		{"skadegöraren", "skadegör"},
		{"skadespelet", "skadespelet"},
		{"skadlig", "skad"},
		{"skadligare", "skad"},
		{"skadlighet", "skad"},
		{"skadligt", "skad"},
		{"skaf", "skaf"},
		{"skaffa", "skaff"},
		{"skaffade", "skaff"},
		{"skaffar", "skaff"},
		{"skaffat", "skaff"},
		{"skafferiet", "skafferiet"},
		{"skaft", "skaft"},
		{"skaftet", "skaftet"},
		{"skaftig", "skaft"},
		{"skageraks", "skagerak"},
		{"skaji", "skaji"},
		{"skaka", "skak"},
		{"skakad", "skak"},
		{"skakade", "skak"},
		{"skakades", "skak"},
		{"skakande", "skak"},
		{"skakar", "skak"},
		{"skakas", "skak"},
		{"skakat", "skak"},
		{"skakning", "skakning"},
		{"skakningar", "skakning"},
		{"skakningen", "skakning"},
		{"skal", "skal"},
		{"skala", "skal"},
		{"skald", "skald"},
		{"skaldernas", "skald"},
		{"skalds", "skald"},
		{"skalen", "skal"},
		{"skalet", "skalet"},
		{"skall", "skall"},
		{"skallade", "skall"},
		{"skallande", "skall"},
		{"skallar", "skall"},
		{"skallarna", "skall"},
		{"skalle", "skall"},
		{"skallet", "skallet"},
		{"skalv", "skalv"},
		{"skam", "skam"},
		{"skamliga", "skam"},
		{"skamlös", "skamlös"},
		{"skamlöst", "skamlös"},
		{"skammen", "skamm"},
		{"skamrodnaden", "skamrodnad"},
		{"skams", "skam"},
		{"skamsen", "skams"},
		{"skamsna", "skamsn"},
		{"skan", "skan"},
		{"skandal", "skandal"},
		{"skandalen", "skandal"},
		{"skandalhistoria", "skandalhistori"},
		{"skande", "skand"},
		{"skanklad", "skankl"},
		{"skapa", "skap"},
		{"skapad", "skap"},
		{"skapade", "skap"},
		{"skapar", "skap"},
		{"skapare", "skap"},
		{"skapat", "skap"},
		{"skapelse", "skap"},
		{"skapelsens", "skap"},
		{"skaplingar", "skapling"},
		{"skapnad", "skapn"},
		{"skapnaden", "skapnad"},
		{"skapt", "skapt"},
		{"skapta", "skapt"},
		{"skar", "skar"},
		{"skara", "skar"},
		{"skaran", "skaran"},
		{"skarens", "skar"},
		{"skaror", "skar"},
		{"skarp", "skarp"},
		{"skarpa", "skarp"},
		{"skarpare", "skarp"},
		{"skarpaste", "skarp"},
		{"skarpen", "skarp"},
		{"skarpsinne", "skarpsin"},
		{"skarpsinnig", "skarpsinn"},
		{"skarpsinnighet", "skarpsinn"},
		{"skarpslipade", "skarpslip"},
		{"skarpsynt", "skarpsynt"},
		{"skarpsynta", "skarpsynt"},
		{"skarpsyntare", "skarpsynt"},
		{"skarpsynthet", "skarpsynt"},
		{"skarpt", "skarpt"},
		{"skatbos", "skatbo"},
		{"skatt", "skatt"},
		{"skatta", "skatt"},
		{"skattade", "skatt"},
		{"skattande", "skatt"},
		{"skattar", "skatt"},
		{"skatter", "skatt"},
		{"skatterna", "skatt"},
		{"skattkammaren", "skattkamm"},
		{"skavanker", "skavank"},
		{"skavde", "skavd"},
		{"skavit", "skavit"},
		{"ske", "ske"},
		{"skedde", "skedd"},
		{"skeden", "sked"},
		{"skelett", "skelet"},
		{"skelettet", "skelettet"},
		{"sken", "sken"},
		{"skenar", "sken"},
		{"skenbarligen", "skenbar"},
		{"skenbart", "skenbart"},
		{"skenet", "skenet"},
		{"skenhelig", "skenhe"},
		{"skenheliga", "skenhe"},
		{"skenliv", "skenliv"},
		{"skeno", "skeno"},
		{"skenorna", "sken"},
		{"skepelse", "skep"},
		{"skepelsen", "skep"},
		{"skepnad", "skepn"},
		{"skepnaden", "skepnad"},
		{"skepnadendet", "skepnadendet"},
		{"skepnader", "skepnad"},
		{"skepp", "skepp"},
		{"skeppare", "skepp"},
		{"skepparens", "skepp"},
		{"skeppares", "skeppar"},
		{"skepparhistorier", "skepparhistori"},
		{"skeppen", "skepp"},
		{"skeppet", "skeppet"},
		{"skepps", "skepp"},
		{"skeppsbron", "skeppsbron"},
		{"skeppsbrott", "skeppsbrot"},
		{"skeppsbrotten", "skeppsbrot"},
		{"skeppsbruten", "skeppsbrut"},
		{"skeppsbrutne", "skeppsbrutn"},
		{"skeppsgossen", "skeppsgoss"},
		{"skeppsgossens", "skeppsgoss"},
		{"skeppsholmen", "skeppsholm"},
		{"skeppsordningen", "skeppsordning"},
		{"skeppsstolarne", "skeppsstol"},
		{"skeptiskt", "skeptisk"},
		{"sker", "sker"},
		{"skett", "skett"},
		{"skeva", "skev"},
		{"skevt", "skevt"},
		{"skhnrande", "skhnrand"},
		{"skick", "skick"},
		{"skicka", "skick"},
		{"skickade", "skick"},
		{"skickades", "skick"},
		{"skickande", "skick"},
		{"skickar", "skick"},
		{"skickat", "skick"},
		{"skickelse", "skick"},
		{"skickelsen", "skick"},
		{"skicklig", "skick"},
		{"skickliga", "skick"},
		{"skickligaste", "skick"},
		{"skicklighet", "skick"},
		{"skickligheten", "skick"},
		{"skickligt", "skick"},
		{"skidor", "skid"},
		{"skifta", "skift"},
		{"skiftade", "skift"},
		{"skiftande", "skift"},
		{"skiftar", "skift"},
		{"skiften", "skift"},
		{"skiftningen", "skiftning"},
		{"skifvan", "skifvan"},
		{"skild", "skild"},
		{"skilda", "skild"},
		{"skildcs", "skildc"},
		{"skilde", "skild"},
		{"skildes", "skild"},
		{"skildra", "skildr"},
		{"skildrade", "skildr"},
		{"skildringar", "skildring"},
		{"skildringen", "skildring"},
		{"skildt", "skild"},
		{"skilja", "skilj"},
		{"skiljas", "skilj"},
		{"skiljer", "skilj"},
		{"skiljes", "skilj"},
		{"skiljobrevet", "skiljobrevet"},
		{"skilling", "skilling"},
		{"skillnad", "skilln"},
		{"skillnaden", "skillnad"},
		{"skilnad", "skiln"},
		{"skilsmessa", "skilsmess"},
		{"skilsmessan", "skilsmessan"},
		{"skilsmässa", "skilsmäss"},
		{"skilsmässan", "skilsmässan"},
		{"skilt", "skilt"},
		{"skimmer", "skimm"},
		{"skimra", "skimr"},
		{"skimrade", "skimr"},
		{"skimrande", "skimr"},
		{"skimrar", "skimr"},
		{"skin", "skin"},
		{"skina", "skin"},
		{"skinande", "skin"},
		{"skiner", "skin"},
		{"skingra", "skingr"},
		{"skingrades", "skingr"},
		{"skingras", "skingr"},
		{"skinka", "skink"},
		{"skinliga", "skin"},
		{"skinn", "skinn"},
		{"skinnband", "skinnband"},
		{"skinnen", "skinn"},
		{"skinnet", "skinnet"},
		{"skinnfoder", "skinnfod"},
		{"skinnfällar", "skinnfäll"},
		{"skinnklädd", "skinnkläd"},
		{"skinnmadrassen", "skinnmadrass"},
		{"skinnmössa", "skinnmöss"},
		{"skinnskoffert", "skinnskoffert"},
		{"skinnstol", "skinnstol"},
		{"skinnstolar", "skinnstol"},
		{"skinnstolen", "skinnstol"},
		{"skinntorra", "skinntorr"},
		{"skira", "skir"},
		{"skiss", "skiss"},
		{"skiva", "skiv"},
		{"skivan", "skivan"},
		{"skivorna", "skiv"},
		{"skjorta", "skjort"},
		{"skjortan", "skjortan"},
		{"skjortbröst", "skjortbröst"},
		{"skjortkragen", "skjortkrag"},
		{"skjortor", "skjort"},
		{"skjortsöm", "skjortsöm"},
		{"skjortärmarna", "skjortärm"},
		{"skjortärmarne", "skjortärm"},
		{"skjul", "skjul"},
		{"skjut", "skjut"},
		{"skjuta", "skjut"},
		{"skjuten", "skjut"},
		{"skjuter", "skjut"},
		{"skjutfönstret", "skjutfönstret"},
		{"skjutit", "skjutit"},
		{"skjuts", "skjut"},
		{"skjutsa", "skjuts"},
		{"skjutsbonde", "skjutsbond"},
		{"skjutsbondens", "skjutsbond"},
		{"skjutsen", "skjuts"},
		{"skjutsens", "skjuts"},
		{"sknlle", "sknlle"},
		{"sko", "sko"},
		{"skoband", "skoband"},
		{"skock", "skock"},
		{"skocka", "skock"},
		{"skockade", "skock"},
		{"skockades", "skock"},
		{"skockar", "skock"},
		{"skockat", "skock"},
		{"skocken", "skock"},
		{"skog", "skog"},
		{"skogar", "skog"},
		{"skogarna", "skog"},
		{"skogarnas", "skog"},
		{"skogen", "skog"},
		{"skogens", "skog"},
		{"skogig", "skog"},
		{"skogsdungens", "skogsdung"},
		{"skogsdunklet", "skogsdunklet"},
		{"skogsfrun", "skogsfrun"},
		{"skogskuliss", "skogskuliss"},
		{"skogssidan", "skogssidan"},
		{"skogssluttningen", "skogssluttning"},
		{"skogsstigen", "skogsst"},
		{"skogsstigens", "skogsst"},
		{"skogsström", "skogsström"},
		{"skogstjärn", "skogstjärn"},
		{"skoj", "skoj"},
		{"skoja", "skoj"},
		{"skojare", "skoj"},
		{"skol", "skol"},
		{"skola", "skol"},
		{"skolan", "skolan"},
		{"skolans", "skolan"},
		{"skolas", "skol"},
		{"skolbarn", "skolbarn"},
		{"skolböckerna", "skolböck"},
		{"skolen", "skol"},
		{"skolflicka", "skolflick"},
		{"skolflickan", "skolflickan"},
		{"skolflickorna", "skolflick"},
		{"skolföreståndarinnan", "skolföreståndarinnan"},
		{"skolgossarna", "skolgoss"},
		{"skolgossens", "skolgoss"},
		{"skolgosses", "skolgoss"},
		{"skolgården", "skolgård"},
		{"skolhuset", "skolhuset"},
		{"skolkamrater", "skolkamrat"},
		{"skolkar", "skolk"},
		{"skolklockan", "skolklockan"},
		{"skolläraren", "skollär"},
		{"skolmamsell", "skolmamsell"},
		{"skolpojke", "skolpojk"},
		{"skolpojkslivets", "skolpojkslivet"},
		{"skolpojkssättet", "skolpojkssättet"},
		{"skolrummet", "skolrummet"},
		{"skolsalen", "skolsal"},
		{"skolsalens", "skolsal"},
		{"skoltid", "skoltid"},
		{"skoltiden", "skoltid"},
		{"skomakare", "skomak"},
		{"skon", "skon"},
		{"skona", "skon"},
		{"skonande", "skon"},
		{"skonare", "skon"},
		{"skonarn", "skonarn"},
		{"skonerten", "skonert"},
		{"skonsamt", "skonsamt"},
		{"skor", "skor"},
		{"skorna", "skorn"},
		{"skorpor", "skorp"},
		{"skorporna", "skorp"},
		{"skorrande", "skorr"},
		{"skorrning", "skorrning"},
		{"skorsten", "skorst"},
		{"skorstenar", "skorsten"},
		{"skorstenen", "skorsten"},
		{"skorstensfejaren", "skorstensfej"},
		{"skosmörja", "skosmörj"},
		{"skota", "skot"},
		{"skote", "skot"},
		{"skotet", "skotet"},
		{"skott", "skott"},
		{"skottet", "skottet"},
		{"skottkärran", "skottkärran"},
		{"skrackelse", "skrack"},
		{"skral", "skral"},
		{"skraltiga", "skralt"},
		{"skramd", "skramd"},
		{"skramla", "skraml"},
		{"skramlade", "skraml"},
		{"skramlande", "skraml"},
		{"skrammel", "skrammel"},
		{"skrankor", "skrank"},
		{"skrap", "skrap"},
		{"skrapa", "skrap"},
		{"skrapade", "skrap"},
		{"skrapande", "skrap"},
		{"skrapat", "skrap"},
		{"skrapet", "skrapet"},
		{"skrapning", "skrapning"},
		{"skratt", "skratt"},
		{"skratta", "skratt"},
		{"skrattade", "skratt"},
		{"skrattande", "skratt"},
		{"skrattar", "skratt"},
		{"skrattat", "skratt"},
		{"skrattet", "skrattet"},
		{"skrattlust", "skrattlust"},
		{"skrattretande", "skrattret"},
		{"skrattsalva", "skrattsalv"},
		{"skrattsalvor", "skrattsalv"},
		{"skred", "skred"},
		{"skref", "skref"},
		{"skrek", "skrek"},
		{"skreko", "skreko"},
		{"skrev", "skrev"},
		{"skreve", "skrev"},
		{"skrevo", "skrevo"},
		{"skrevor", "skrev"},
		{"skri", "skri"},
		{"skria", "skria"},
		{"skriden", "skrid"},
		{"skrider", "skrid"},
		{"skridit", "skridit"},
		{"skrifning", "skrifning"},
		{"skrifpulpet", "skrifpulpet"},
		{"skrift", "skrift"},
		{"skriften", "skrift"},
		{"skriftens", "skrift"},
		{"skrifter", "skrift"},
		{"skriftligen", "skrift"},
		{"skriftligt", "skrift"},
		{"skrifttecken", "skriftteck"},
		{"skrifva", "skrifv"},
		{"skrifvare", "skrifv"},
		{"skrifvarn", "skrifvarn"},
		{"skrifver", "skrifv"},
		{"skrifvet", "skrifvet"},
		{"skrifvit", "skrifvit"},
		{"skrik", "skrik"},
		{"skrika", "skrik"},
		{"skrikande", "skrik"},
		{"skriken", "skrik"},
		{"skriker", "skrik"},
		{"skriket", "skriket"},
		{"skrikig", "skrik"},
		{"skrikit", "skrikit"},
		{"skritt", "skritt"},
		{"skriv", "skriv"},
		{"skriva", "skriv"},
		{"skrivarens", "skriv"},
		{"skrivas", "skriv"},
		{"skrivbord", "skrivbord"},
		{"skrivbordet", "skrivbordet"},
		{"skrivelse", "skriv"},
		{"skrivelsen", "skriv"},
		{"skriven", "skriv"},
		{"skriver", "skriv"},
		{"skrivet", "skrivet"},
		{"skrivit", "skrivit"},
		{"skrivits", "skrivit"},
		{"skrivkonsten", "skrivkonst"},
		{"skrivmaterialer", "skrivmaterial"},
		{"skrivna", "skrivn"},
		{"skrivning", "skrivning"},
		{"skrivpulpet", "skrivpulpet"},
		{"skrivpulpeten", "skrivpulpet"},
		{"skrivrum", "skrivrum"},
		{"skrockande", "skrock"},
		{"skrockfull", "skrockfull"},
		{"skrodör", "skrodör"},
		{"skrofliga", "skrof"},
		{"skrofvets", "skrofvet"},
		{"skrot", "skrot"},
		{"skrovlig", "skrov"},
		{"skrovliga", "skrov"},
		{"skrubb", "skrubb"},
		{"skrubba", "skrubb"},
		{"skruden", "skrud"},
		{"skrumpet", "skrumpet"},
		{"skrumpnad", "skrumpn"},
		{"skrumpnade", "skrumpn"},
		{"skrupler", "skrupl"},
		{"skruv", "skruv"},
		{"skruvade", "skruv"},
		{"skruvades", "skruv"},
		{"skruven", "skruv"},
		{"skrymtar", "skrymt"},
		{"skrymtare", "skrymt"},
		{"skrynkla", "skrynkl"},
		{"skrynklade", "skrynkl"},
		{"skrynklat", "skrynkl"},
		{"skrynklig", "skrynk"},
		{"skrynkliga", "skrynk"},
		{"skryt", "skryt"},
		{"skryta", "skryt"},
		{"skrytsamhet", "skrytsam"},
		{"skräck", "skräck"},
		{"skräckblandad", "skräckbland"},
		{"skräckfulla", "skräckfull"},
		{"skräckinjagandc", "skräckinjagandc"},
		{"skräckinjagande", "skräckinjag"},
		{"skräddare", "skrädd"},
		{"skräddarräkningen", "skräddarräkning"},
		{"skräll", "skräll"},
		{"skrällde", "skrälld"},
		{"skrämd", "skrämd"},
		{"skrämda", "skrämd"},
		{"skrämde", "skrämd"},
		{"skrämma", "skrämm"},
		{"skrämmande", "skrämm"},
		{"skrämmas", "skrämm"},
		{"skrämmer", "skrämm"},
		{"skrämsel", "skrämsel"},
		{"skrämseln", "skrämseln"},
		{"skrämt", "skrämt"},
		{"skränets", "skränet"},
		{"skränpatriotisk", "skränpatriotisk"},
		{"skräp", "skräp"},
		{"skräpa", "skräp"},
		{"skräpet", "skräpet"},
		{"skräpiga", "skräp"},
		{"skräpkammare", "skräpkamm"},
		{"skräpkamrar", "skräpkamr"},
		{"skrävlande", "skrävl"},
		{"skrået", "skrået"},
		{"skröplig", "skröp"},
		{"skröt", "skröt"},
		{"sku", "sku"},
		{"skudda", "skudd"},
		{"skude", "skud"},
		{"skuderade", "skuder"},
		{"skuffande", "skuff"},
		{"skuffen", "skuff"},
		{"skug", "skug"},
		{"skugfade", "skugf"},
		{"skugga", "skugg"},
		{"skuggad", "skugg"},
		{"skuggade", "skugg"},
		{"skuggades", "skugg"},
		{"skuggan", "skuggan"},
		{"skuggande", "skugg"},
		{"skuggans", "skuggan"},
		{"skuggar", "skugg"},
		{"skuggas", "skugg"},
		{"skuggats", "skuggat"},
		{"skuggbarn", "skuggbarn"},
		{"skuggiga", "skugg"},
		{"skugglika", "skugglik"},
		{"skuggliv", "skuggliv"},
		{"skuggor", "skugg"},
		{"skuggorna", "skugg"},
		{"skuggornas", "skugg"},
		{"skuggorra", "skuggorr"},
		{"skuggpartierna", "skuggparti"},
		{"skuggrikaste", "skuggrik"},
		{"skuggsidor", "skuggsid"},
		{"skuggspel", "skuggspel"},
		{"skul", "skul"},
		{"skuld", "skuld"},
		{"skulda", "skuld"},
		{"skulden", "skuld"},
		{"skulder", "skuld"},
		{"skuldfritt", "skuldfrit"},
		{"skuldförbindelser", "skuldförbind"},
		{"skuldmedveten", "skuldmedvet"},
		{"skuldran", "skuldran"},
		{"skuldregister", "skuldregist"},
		{"skuldror", "skuldr"},
		{"skuldrorna", "skuldr"},
		{"skuldsedel", "skuldsedel"},
		{"skuli", "skuli"},
		{"skulie", "skuli"},
		{"skull", "skull"},
		{"skullc", "skullc"},
		{"skulle", "skull"},
		{"skullen", "skull"},
		{"skulptur", "skulptur"},
		{"skulpturverk", "skulpturverk"},
		{"skum", "skum"},
		{"skumhylt", "skumhylt"},
		{"skumma", "skumm"},
		{"skummande", "skumm"},
		{"skummaste", "skumm"},
		{"skummet", "skummet"},
		{"skummig", "skumm"},
		{"skumpärlorna", "skumpärl"},
		{"skumt", "skumt"},
		{"skumögd", "skumög"},
		{"skura", "skur"},
		{"skurade", "skur"},
		{"skurborste", "skurborst"},
		{"skuren", "skur"},
		{"skurit", "skurit"},
		{"skurk", "skurk"},
		{"skurken", "skurk"},
		{"skurna", "skurn"},
		{"skuro", "skuro"},
		{"skuta", "skut"},
		{"skutan", "skutan"},
		{"skutans", "skutan"},
		{"skutt", "skutt"},
		{"skuzle", "skuzl"},
		{"skvalar", "skval"},
		{"skvallersjuka", "skvallersjuk"},
		{"skvallerspeglar", "skvallerspegl"},
		{"skvallra", "skvallr"},
		{"skvallrade", "skvallr"},
		{"skvallrar", "skvallr"},
		{"skvalpade", "skvalp"},
		{"skvaltar", "skvalt"},
		{"skvdda", "skvdda"},
		{"sky", "sky"},
		{"skyar", "skyar"},
		{"skyarna", "skyarn"},
		{"skydd", "skydd"},
		{"skydda", "skydd"},
		{"skyddade", "skydd"},
		{"skyddadt", "skyddad"},
		{"skyddande", "skydd"},
		{"skyddar", "skydd"},
		{"skyddas", "skydd"},
		{"skydde", "skydd"},
		{"skyddsengel", "skyddsengel"},
		{"skyddsling", "skyddsling"},
		{"skyddslingar", "skyddsling"},
		{"skyddslings", "skyddsling"},
		{"skygg", "skygg"},
		{"skygga", "skygg"},
		{"skyggt", "skygg"},
		{"skyhimmel", "skyhimmel"},
		{"skyhöga", "skyhög"},
		{"skyla", "skyl"},
		{"skylde", "skyld"},
		{"skyldes", "skyld"},
		{"skyldig", "skyld"},
		{"skyldiga", "skyld"},
		{"skyldighet", "skyld"},
		{"skyldigheten", "skyld"},
		{"skyldigheter", "skyld"},
		{"skyldrade", "skyldr"},
		{"skylla", "skyll"},
		{"skyllde", "skylld"},
		{"skylt", "skylt"},
		{"skyltade", "skylt"},
		{"skylten", "skylt"},
		{"skyltfönster", "skyltfönst"},
		{"skym", "skym"},
		{"skymassorna", "skymass"},
		{"skymd", "skymd"},
		{"skymde", "skymd"},
		{"skymf", "skymf"},
		{"skymfa", "skymf"},
		{"skymfad", "skymf"},
		{"skymfande", "skymf"},
		{"skymfen", "skymf"},
		{"skymflig", "skymf"},
		{"skymfligt", "skymf"},
		{"skymlande", "skyml"},
		{"skymma", "skymm"},
		{"skymmande", "skymm"},
		{"skymning", "skymning"},
		{"skymningen", "skymning"},
		{"skymningens", "skymning"},
		{"skymningsalfernas", "skymningsalf"},
		{"skymningsdager", "skymningsdag"},
		{"skymningsstora", "skymningsstor"},
		{"skymningstärnan", "skymningstärnan"},
		{"skymt", "skymt"},
		{"skymta", "skymt"},
		{"skymtade", "skymt"},
		{"skymtar", "skymt"},
		{"skymtat", "skymt"},
		{"skymten", "skymt"},
		{"skyn", "skyn"},
		{"skynda", "skynd"},
		{"skyndade", "skynd"},
		{"skyndar", "skynd"},
		{"skyndat", "skynd"},
		{"skynden", "skynd"},
		{"skyndsamhet", "skyndsam"},
		{"skyndsamt", "skyndsamt"},
		{"skyr", "skyr"},
		{"skytrasorna", "skytras"},
		{"skytt", "skytt"},
		{"skyttarne", "skytt"},
		{"skyttelen", "skyttel"},
		{"skytten", "skytt"},
		{"skytteriet", "skytteriet"},
		{"skyvar", "skyv"},
		{"skäckiga", "skäck"},
		{"skägg", "skägg"},
		{"skäggbotten", "skäggbot"},
		{"skägget", "skägget"},
		{"skäggig", "skägg"},
		{"skäl", "skäl"},
		{"skälet", "skälet"},
		{"skälfvande", "skälfv"},
		{"skälla", "skäll"},
		{"skällande", "skäll"},
		{"skällde", "skälld"},
		{"skäller", "skäll"},
		{"skälles", "skäll"},
		{"skälm", "skälm"},
		{"skälmaktig", "skälmakt"},
		{"skälmen", "skälm"},
		{"skälmska", "skälmsk"},
		{"skälmstycken", "skälmstyck"},
		{"skälva", "skälv"},
		{"skälvande", "skälv"},
		{"skälvde", "skälvd"},
		{"skälver", "skälv"},
		{"skälvosot", "skälvosot"},
		{"skäm", "skäm"},
		{"skämda", "skämd"},
		{"skämde", "skämd"},
		{"skämdes", "skämd"},
		{"skämmas", "skämm"},
		{"skämmer", "skämm"},
		{"skäms", "skäm"},
		{"skämt", "skämt"},
		{"skämta", "skämt"},
		{"skämtade", "skämt"},
		{"skämtande", "skämt"},
		{"skämtar", "skämt"},
		{"skämtet", "skämtet"},
		{"skämtsam", "skämtsam"},
		{"skämtsamhet", "skämtsam"},
		{"skämtsamma", "skämtsamm"},
		{"skämtsamt", "skämtsamt"},
		{"skämttidningarnas", "skämttidning"},
		{"skändar", "skänd"},
		{"skändas", "skänd"},
		{"skänk", "skänk"},
		{"skänka", "skänk"},
		{"skänken", "skänk"},
		{"skänker", "skänk"},
		{"skänks", "skänk"},
		{"skänkt", "skänk"},
		{"skänkte", "skänk"},
		{"skänkts", "skänk"},
		{"skäppa", "skäpp"},
		{"skäppan", "skäppan"},
		{"skär", "skär"},
		{"skära", "skär"},
		{"skäran", "skäran"},
		{"skärande", "skär"},
		{"skärat", "skär"},
		{"skären", "skär"},
		{"skärgård", "skärgård"},
		{"skärgården", "skärgård"},
		{"skärgårdens", "skärgård"},
		{"skärgårds", "skärgård"},
		{"skärgårdsbos", "skärgårdsbo"},
		{"skärgårdsbåtarna", "skärgårdsbåt"},
		{"skärgårdselände", "skärgårdseländ"},
		{"skärgårdsflicka", "skärgårdsflick"},
		{"skärgårdsfolkets", "skärgårdsfolket"},
		{"skärgårdslifvet", "skärgårdslifvet"},
		{"skärgårdsmö", "skärgårdsmö"},
		{"skärgårdstärnan", "skärgårdstärnan"},
		{"skärhet", "skär"},
		{"skärm", "skärm"},
		{"skärmarne", "skärm"},
		{"skärmen", "skärm"},
		{"skärmens", "skärm"},
		{"skärpa", "skärp"},
		{"skärper", "skärp"},
		{"skärpta", "skärpt"},
		{"skärpte", "skärpt"},
		{"skärseld", "skärseld"},
		{"skärt", "skärt"},
		{"skärv", "skärv"},
		{"skärvor", "skärv"},
		{"skåda", "skåd"},
		{"skådad", "skåd"},
		{"skådade", "skåd"},
		{"skådande", "skåd"},
		{"skådat", "skåd"},
		{"skådespel", "skådespel"},
		{"skådespelare", "skådespel"},
		{"skådespelaren", "skådespel"},
		{"skådespelarna", "skådespel"},
		{"skådespelerskor", "skådespelersk"},
		{"skådespelet", "skådespelet"},
		{"skål", "skål"},
		{"skåla", "skål"},
		{"skålen", "skål"},
		{"skåll", "skåll"},
		{"skålpund", "skålpund"},
		{"skåmtade", "skåmt"},
		{"skåne", "skån"},
		{"skåp", "skåp"},
		{"skåpdörren", "skåpdörr"},
		{"skåpet", "skåpet"},
		{"skökor", "skök"},
		{"sköld", "sköld"},
		{"sköldborg", "sköldborg"},
		{"skölj", "skölj"},
		{"skölja", "skölj"},
		{"sköljde", "sköljd"},
		{"sköljer", "skölj"},
		{"sköljt", "sköljt"},
		{"skön", "skön"},
		{"sköna", "skön"},
		{"skönare", "skön"},
		{"skönaste", "skön"},
		{"skönhet", "skön"},
		{"skönheten", "skön"},
		{"skönhetens", "skön"},
		{"skönheter", "skön"},
		{"skönhetssinne", "skönhetssin"},
		{"skönja", "skönj"},
		{"skönjbara", "skönjbar"},
		{"skönjde", "skönjd"},
		{"skönjdes", "skönjd"},
		{"skönjs", "skönj"},
		{"sköns", "skön"},
		{"skönt", "skönt"},
		{"skör", "skör"},
		{"skörd", "skörd"},
		{"skörda", "skörd"},
		{"skördar", "skörd"},
		{"skördat", "skörd"},
		{"skördemogna", "skördemogn"},
		{"skörlevnad", "skörlevn"},
		{"skört", "skört"},
		{"sköt", "sköt"},
		{"sköta", "sköt"},
		{"sköte", "sköt"},
		{"sköter", "sköt"},
		{"sköterska", "skötersk"},
		{"sköterskam", "sköterskam"},
		{"sköterskan", "sköterskan"},
		{"sköterskorna", "skötersk"},
		{"skötet", "skötet"},
		{"sköto", "sköto"},
		{"sköts", "sköt"},
		{"skött", "skött"},
		{"skötte", "skött"},
		{"sköttes", "skött"},
		{"skövla", "skövl"},
		{"sl", "sl"},
		{"sladder", "sladd"},
		{"sladdra", "sladdr"},
		{"sladdrar", "sladdr"},
		{"slaflif", "slaflif"},
		{"slag", "slag"},
		{"slaganfall", "slaganfall"},
		{"slagattack", "slagattack"},
		{"slagbordet", "slagbordet"},
		{"slagdänga", "slagdäng"},
		{"slagdängor", "slagdäng"},
		{"slagen", "slag"},
		{"slaget", "slaget"},
		{"slagfältet", "slagfältet"},
		{"slagit", "slagit"},
		{"slagits", "slagit"},
		{"slagna", "slagn"},
		{"slags", "slag"},
		{"slagskämpe", "slagskämp"},
		{"slaka", "slak"},
		{"slakt", "slakt"},
		{"slaktat", "slakt"},
		{"slakthus", "slakthus"},
		{"slam", "slam"},
		{"slammer", "slamm"},
		{"slamrande", "slamr"},
		{"slamret", "slamret"},
		{"slang", "slang"},
		{"slangbågar", "slangbåg"},
		{"slangbåge", "slangbåg"},
		{"slank", "slank"},
		{"slanka", "slank"},
		{"slannade", "slann"},
		{"slant", "slant"},
		{"slantar", "slant"},
		{"slapp", "slapp"},
		{"slappa", "slapp"},
		{"slappfeta", "slappfet"},
		{"slapphet", "slapp"},
		{"slappna", "slappn"},
		{"slappt", "slappt"},
		{"slappte", "slappt"},
		{"slar", "slar"},
		{"slarf", "slarf"},
		{"slarfva", "slarfv"},
		{"slarvig", "slarv"},
		{"slaskig", "slask"},
		{"slav", "slav"},
		{"slaveri", "slaveri"},
		{"slavinna", "slavin"},
		{"slculle", "slcull"},
		{"sldgo", "sldgo"},
		{"slemmig", "slemm"},
		{"slemmiga", "slemm"},
		{"slet", "slet"},
		{"sleto", "sleto"},
		{"sletos", "sleto"},
		{"slets", "slet"},
		{"slg", "slg"},
		{"slicka", "slick"},
		{"slickadc", "slickadc"},
		{"slickade", "slick"},
		{"slickande", "slick"},
		{"slickar", "slick"},
		{"slida", "slid"},
		{"slikt", "slikt"},
		{"slinga", "sling"},
		{"slingor", "sling"},
		{"slingorna", "sling"},
		{"slingra", "slingr"},
		{"slingrade", "slingr"},
		{"slingrande", "slingr"},
		{"slingrar", "slingr"},
		{"slingrat", "slingr"},
		{"slingriga", "slingr"},
		{"slingringarne", "slingring"},
		{"slinh", "slinh"},
		{"slinka", "slink"},
		{"slinker", "slink"},
		{"slinta", "slint"},
		{"slipad", "slip"},
		{"slipade", "slip"},
		{"slippa", "slipp"},
		{"slipper", "slipp"},
		{"slipprigt", "slippr"},
		{"slips", "slip"},
		{"sliskiga", "slisk"},
		{"sliskigaste", "slisk"},
		{"slita", "slit"},
		{"slitande", "slit"},
		{"slitas", "slit"},
		{"sliten", "slit"},
		{"slitit", "slitit"},
		{"slitits", "slitit"},
		{"slitna", "slitn"},
		{"slitningar", "slitning"},
		{"slits", "slit"},
		{"slitstarkt", "slitstark"},
		{"slock", "slock"},
		{"slockna", "slockn"},
		{"slocknade", "slockn"},
		{"slocknande", "slockn"},
		{"slocknar", "slockn"},
		{"slocknat", "slockn"},
		{"slog", "slog"},
		{"sloge", "slog"},
		{"slogo", "slogo"},
		{"slogos", "slogo"},
		{"slogs", "slog"},
		{"sloka", "slok"},
		{"slokad", "slok"},
		{"slokande", "slok"},
		{"slokar", "slok"},
		{"slot", "slot"},
		{"slott", "slott"},
		{"slottet", "slottet"},
		{"slottsfasaden", "slottsfasad"},
		{"slottskanslibetjänt", "slottskanslibetjänt"},
		{"slottskanslibetjänter", "slottskanslibetjänt"},
		{"slottskanslibetjänterna", "slottskanslibetjänt"},
		{"slottskorridor", "slottskorrid"},
		{"slottsrätten", "slottsrät"},
		{"slottstappning", "slottstappning"},
		{"sluddrade", "sluddr"},
		{"slug", "slug"},
		{"slugare", "slug"},
		{"slugt", "slugt"},
		{"sluka", "sluk"},
		{"slukade", "sluk"},
		{"slukades", "sluk"},
		{"slukar", "sluk"},
		{"slukat", "sluk"},
		{"slummer", "slumm"},
		{"slump", "slump"},
		{"slumpen", "slump"},
		{"slumra", "slumr"},
		{"slumrade", "slumr"},
		{"slumrande", "slumr"},
		{"slumrar", "slumr"},
		{"slumrat", "slumr"},
		{"slunga", "slung"},
		{"slungade", "slung"},
		{"slungat", "slung"},
		{"slunko", "slunko"},
		{"slup", "slup"},
		{"slupen", "slup"},
		{"sluppit", "sluppit"},
		{"sluring", "sluring"},
		{"slusk", "slusk"},
		{"slussen", "sluss"},
		{"slut", "slut"},
		{"sluta", "slut"},
		{"slutad", "slut"},
		{"slutade", "slut"},
		{"slutades", "slut"},
		{"slutadt", "slutad"},
		{"slutande", "slut"},
		{"slutar", "slut"},
		{"slutas", "slut"},
		{"slutat", "slut"},
		{"sluten", "slut"},
		{"slutenhet", "sluten"},
		{"sluter", "slut"},
		{"slutet", "slutet"},
		{"slutit", "slutit"},
		{"slutits", "slutit"},
		{"slutkapitlet", "slutkapitlet"},
		{"slutli", "slutli"},
		{"slutlig", "slut"},
		{"slutliga", "slut"},
		{"slutligen", "slut"},
		{"slutligeu", "slutligeu"},
		{"slutligt", "slut"},
		{"slutmening", "slutmening"},
		{"slutmeningen", "slutmening"},
		{"slutna", "slutn"},
		{"slutpolerade", "slutpoler"},
		{"slutsats", "slutsat"},
		{"slutsatsen", "slutsats"},
		{"slutsatser", "slutsats"},
		{"sluttande", "slutt"},
		{"sluttning", "sluttning"},
		{"sluttningar", "sluttning"},
		{"sluttningen", "sluttning"},
		{"slynan", "slynan"},
		{"slyng", "slyng"},
		{"slyngel", "slyngel"},
		{"slyngelåren", "slyngelår"},
		{"slynåren", "slynår"},
		{"släck", "släck"},
		{"släcka", "släck"},
		{"släckande", "släck"},
		{"släckt", "släck"},
		{"släckta", "släck"},
		{"släckte", "släck"},
		{"släde", "släd"},
		{"slädpartier", "slädparti"},
		{"slädspår", "slädspår"},
		{"slägt", "slägt"},
		{"slägten", "slägt"},
		{"slägting", "slägting"},
		{"slägtingar", "slägting"},
		{"släk", "släk"},
		{"släkt", "släkt"},
		{"släkte", "släkt"},
		{"släkten", "släkt"},
		{"släktens", "släkt"},
		{"släktes", "släkt"},
		{"släktförhållanden", "släktförhåll"},
		{"släkting", "släkting"},
		{"släktingar", "släkting"},
		{"släktingen", "släkting"},
		{"släktkalendrar", "släktkalendr"},
		{"släktled", "släktled"},
		{"släktleds", "släktled"},
		{"släktskap", "släktskap"},
		{"släkttycket", "släkttycket"},
		{"släktvapnet", "släktvapnet"},
		{"sländas", "sländ"},
		{"släng", "släng"},
		{"slänga", "släng"},
		{"slängar", "släng"},
		{"slängde", "släng"},
		{"slänger", "släng"},
		{"slängkappa", "slängkapp"},
		{"slängkyss", "slängkyss"},
		{"slängt", "släng"},
		{"släp", "släp"},
		{"släpa", "släp"},
		{"släpade", "släp"},
		{"släpande", "släp"},
		{"släpar", "släp"},
		{"släpat", "släp"},
		{"släpigt", "släp"},
		{"släpp", "släpp"},
		{"släppa", "släpp"},
		{"släpper", "släpp"},
		{"släppt", "släppt"},
		{"släppte", "släppt"},
		{"släppts", "släppt"},
		{"släpstöfveln", "släpstöfveln"},
		{"slät", "slät"},
		{"släta", "slät"},
		{"slätade", "slät"},
		{"slätkammade", "slätkamm"},
		{"slätrakad", "slätrak"},
		{"slätrakade", "slätrak"},
		{"slätt", "slätt"},
		{"slätten", "slätt"},
		{"slättens", "slätt"},
		{"slätter", "slätt"},
		{"slättäljda", "slättäljd"},
		{"slå", "slå"},
		{"slående", "slåend"},
		{"slåkt", "slåkt"},
		{"slår", "slår"},
		{"slås", "slås"},
		{"slåss", "slåss"},
		{"slö", "slö"},
		{"slöa", "slöa"},
		{"slöhet", "slöhet"},
		{"slöja", "slöj"},
		{"slöjan", "slöjan"},
		{"slöjd", "slöjd"},
		{"slöjdares", "slöjdar"},
		{"slöjdbänk", "slöjdbänk"},
		{"slöjor", "slöj"},
		{"slösa", "slös"},
		{"slösade", "slös"},
		{"slösaktig", "slösakt"},
		{"slösaktiga", "slösakt"},
		{"slösar", "slös"},
		{"slösarna", "slös"},
		{"slösat", "slös"},
		{"slöseri", "slöseri"},
		{"slöserska", "slösersk"},
		{"slöt", "slöt"},
		{"slöto", "slöto"},
		{"slötos", "slöto"},
		{"slött", "slött"},
		{"sm", "sm"},
		{"sma", "sma"},
		{"smackade", "smack"},
		{"smacker", "smack"},
		{"smackningar", "smackning"},
		{"smak", "smak"},
		{"smaka", "smak"},
		{"smakade", "smak"},
		{"smakar", "smak"},
		{"smakat", "smak"},
		{"smaken", "smak"},
		{"smakfull", "smakfull"},
		{"smakfullare", "smakfull"},
		{"smakfullt", "smakfull"},
		{"smaklöst", "smaklös"},
		{"smaksätta", "smaksät"},
		{"smal", "smal"},
		{"smala", "smal"},
		{"smaleende", "smaleend"},
		{"small", "small"},
		{"smalnar", "smaln"},
		{"smalog", "smalog"},
		{"smalt", "smalt"},
		{"smattra", "smattr"},
		{"smattrade", "smattr"},
		{"smattrande", "smattr"},
		{"smedja", "smedj"},
		{"smedjan", "smedjan"},
		{"smeka", "smek"},
		{"smekande", "smek"},
		{"smekas", "smek"},
		{"smekmånaden", "smekmånad"},
		{"smeknamn", "smeknamn"},
		{"smekning", "smekning"},
		{"smekningar", "smekning"},
		{"smekningen", "smekning"},
		{"smeksam", "smeksam"},
		{"smeksamma", "smeksamm"},
		{"smeksamt", "smeksamt"},
		{"smekt", "smekt"},
		{"smekte", "smekt"},
		{"smetade", "smet"},
		{"smetat", "smet"},
		{"smicker", "smick"},
		{"smickrad", "smickr"},
		{"smickrade", "smickr"},
		{"smickrades", "smickr"},
		{"smickrande", "smickr"},
		{"smickrare", "smickr"},
		{"smickrat", "smickr"},
		{"smida", "smid"},
		{"smidig", "smid"},
		{"smidiga", "smid"},
		{"smidigare", "smid"},
		{"smidigt", "smid"},
		{"smil", "smil"},
		{"smilande", "smil"},
		{"smiles", "smil"},
		{"smink", "smink"},
		{"sminka", "smink"},
		{"smisk", "smisk"},
		{"smitta", "smitt"},
		{"smittade", "smitt"},
		{"smittat", "smitt"},
		{"smittoöverföring", "smittoöverföring"},
		{"smlsade", "smlsad"},
		{"smn", "smn"},
		{"smog", "smog"},
		{"smorde", "smord"},
		{"smuggelgodset", "smuggelgodset"},
		{"smuggelhandel", "smuggelhandel"},
		{"smuggla", "smuggl"},
		{"smugglas", "smuggl"},
		{"smuggleriet", "smuggleriet"},
		{"smugit", "smugit"},
		{"smula", "smul"},
		{"smulade", "smul"},
		{"smular", "smul"},
		{"smulat", "smul"},
		{"smulor", "smul"},
		{"smulorna", "smul"},
		{"smultit", "smultit"},
		{"smultron", "smultron"},
		{"smussla", "smussl"},
		{"smuts", "smut"},
		{"smutsa", "smuts"},
		{"smutsade", "smuts"},
		{"smutsas", "smuts"},
		{"smutsat", "smuts"},
		{"smutsbruna", "smutsbrun"},
		{"smutsen", "smuts"},
		{"smutsgrå", "smutsgrå"},
		{"smutsgula", "smutsgul"},
		{"smutsig", "smuts"},
		{"smutsiga", "smuts"},
		{"smutsigt", "smuts"},
		{"smutspöl", "smutspöl"},
		{"smutsröda", "smutsröd"},
		{"smutta", "smutt"},
		{"smuttade", "smutt"},
		{"smuttande", "smutt"},
		{"smy", "smy"},
		{"smycka", "smyck"},
		{"smycken", "smyck"},
		{"smyg", "smyg"},
		{"smyga", "smyg"},
		{"smygande", "smyg"},
		{"smyger", "smyg"},
		{"smyghål", "smyghål"},
		{"smygvägar", "smygväg"},
		{"smäck", "smäck"},
		{"smäcker", "smäck"},
		{"smäckra", "smäckr"},
		{"smäda", "smäd"},
		{"smädar", "smäd"},
		{"smädliga", "smäd"},
		{"smälek", "smälek"},
		{"smäll", "smäll"},
		{"smälla", "smäll"},
		{"smällande", "smäll"},
		{"smällar", "smäll"},
		{"smällde", "smälld"},
		{"smällen", "smäll"},
		{"smäller", "smäll"},
		{"smällt", "smällt"},
		{"smält", "smält"},
		{"smälta", "smält"},
		{"smältande", "smält"},
		{"smälte", "smält"},
		{"smärt", "smärt"},
		{"smärta", "smärt"},
		{"smärtade", "smärt"},
		{"smärtan", "smärtan"},
		{"smärtans", "smärtan"},
		{"smärtare", "smärt"},
		{"smärtas", "smärt"},
		{"smärtfulla", "smärtfull"},
		{"smärtor", "smärt"},
		{"smärtorna", "smärt"},
		{"smärtsam", "smärtsam"},
		{"smärtsamma", "smärtsamm"},
		{"smärtsamt", "smärtsamt"},
		{"små", "små"},
		{"småaktiga", "småakt"},
		{"småbarn", "småbarn"},
		{"småbarnskläder", "småbarnskläd"},
		{"småborgerligt", "småborger"},
		{"småbrödet", "småbrödet"},
		{"småbåtarna", "småbåt"},
		{"småbåtarne", "småbåt"},
		{"smådda", "smådd"},
		{"småfä", "småfä"},
		{"småfåglars", "småfåglar"},
		{"smågnolade", "smågnol"},
		{"smågnolande", "smågnol"},
		{"smågräla", "smågräl"},
		{"småherrarne", "småherr"},
		{"småherrskapet", "småherrskapet"},
		{"småjagterna", "småjag"},
		{"småkräken", "småkräk"},
		{"småkrämaraffärer", "småkrämaraffär"},
		{"småland", "småland"},
		{"småle", "smål"},
		{"småleende", "småleend"},
		{"småleenden", "småleend"},
		{"småleendet", "småleendet"},
		{"småler", "smål"},
		{"smålett", "smålet"},
		{"smålog", "smålog"},
		{"smålogo", "smålogo"},
		{"småländska", "småländsk"},
		{"smålådorna", "smålåd"},
		{"småmynt", "småmynt"},
		{"småmyste", "småmyst"},
		{"småningom", "småningom"},
		{"småningorn", "småningorn"},
		{"småpojkar", "småpojk"},
		{"småpratade", "småprat"},
		{"smårum", "smårum"},
		{"smårummen", "smårumm"},
		{"småsak", "småsak"},
		{"småsaker", "småsak"},
		{"småsinthet", "småsint"},
		{"småskrattade", "småskrat"},
		{"småstad", "småst"},
		{"småstaden", "småstad"},
		{"småsten", "småst"},
		{"småting", "småting"},
		{"småtrippande", "småtripp"},
		{"småtråkiga", "småtråk"},
		{"smått", "smått"},
		{"småvisslande", "småvissl"},
		{"småväxt", "småväxt"},
		{"smög", "smög"},
		{"smögo", "smögo"},
		{"smör", "smör"},
		{"smörbakelser", "smörbak"},
		{"smörbytta", "smörbyt"},
		{"smörbyttor", "smörbyt"},
		{"smördukar", "smörduk"},
		{"smöret", "smöret"},
		{"smörgasar", "smörgas"},
		{"smörgås", "smörgås"},
		{"smörgåsar", "smörgås"},
		{"smörgåsbiten", "smörgåsbit"},
		{"smörgåsbordet", "smörgåsbordet"},
		{"smörgåsen", "smörgås"},
		{"smörj", "smörj"},
		{"smörja", "smörj"},
		{"smörjan", "smörjan"},
		{"sna", "sna"},
		{"snabb", "snabb"},
		{"snabba", "snabb"},
		{"snabbare", "snabb"},
		{"snabbhet", "snabb"},
		{"snabblöpare", "snabblöp"},
		{"snabbt", "snabbt"},
		{"snappat", "snapp"},
		{"snapsar", "snaps"},
		{"snar", "snar"},
		{"snara", "snar"},
		{"snaran", "snaran"},
		{"snarare", "snar"},
		{"snarast", "snar"},
		{"snaraste", "snar"},
		{"snarfyndiga", "snarfynd"},
		{"snarka", "snark"},
		{"snarkande", "snark"},
		{"snarkning", "snarkning"},
		{"snarlik", "snarlik"},
		{"snarlika", "snarlik"},
		{"snarlikt", "snarlik"},
		{"snaror", "snar"},
		{"snarr", "snarr"},
		{"snart", "snart"},
		{"snatta", "snatt"},
		{"snattrande", "snattr"},
		{"snavade", "snav"},
		{"sned", "sned"},
		{"sneddade", "snedd"},
		{"snedsprång", "snedsprång"},
		{"sneglade", "snegl"},
		{"sneglat", "snegl"},
		{"snett", "snett"},
		{"snibben", "snibb"},
		{"snickare", "snick"},
		{"snickaren", "snick"},
		{"snickaresåg", "snickaresåg"},
		{"snigeln", "snigeln"},
		{"snille", "snill"},
		{"snillets", "snillet"},
		{"snillrikt", "snillrik"},
		{"snipigt", "snip"},
		{"snirklade", "snirkl"},
		{"snits", "snit"},
		{"snitt", "snitt"},
		{"snitten", "snitt"},
		{"snm", "snm"},
		{"snobbiga", "snobb"},
		{"snodde", "snodd"},
		{"snoka", "snok"},
		{"snokande", "snok"},
		{"snor", "snor"},
		{"snorungen", "snorung"},
		{"sntto", "sntto"},
		{"snubbla", "snubbl"},
		{"snubblade", "snubbl"},
		{"snubblande", "snubbl"},
		{"snubbor", "snubb"},
		{"snud", "snud"},
		{"snudda", "snudd"},
		{"snuddade", "snudd"},
		{"snuddande", "snudd"},
		{"snuddat", "snudd"},
		{"snuffe", "snuff"},
		{"snufva", "snufv"},
		{"snuggan", "snuggan"},
		{"snurra", "snurr"},
		{"snurrade", "snurr"},
		{"snurrar", "snurr"},
		{"snus", "snus"},
		{"snusa", "snus"},
		{"snusade", "snus"},
		{"snusburken", "snusburk"},
		{"snusbutelj", "snusbutelj"},
		{"snusbuteljer", "snusbutelj"},
		{"snusdosa", "snusdos"},
		{"snusdosan", "snusdosan"},
		{"snusige", "snus"},
		{"snusningar", "snusning"},
		{"snuspaket", "snuspaket"},
		{"snuva", "snuv"},
		{"snyft", "snyft"},
		{"snyfta", "snyft"},
		{"snyftade", "snyft"},
		{"snyftande", "snyft"},
		{"snyftat", "snyft"},
		{"snyftning", "snyftning"},
		{"snyftningar", "snyftning"},
		{"snyftningarna", "snyftning"},
		{"snygg", "snygg"},
		{"snygga", "snygg"},
		{"snyggt", "snygg"},
		{"snyta", "snyt"},
		{"snäc", "snäc"},
		{"snäcka", "snäck"},
		{"snäckor", "snäck"},
		{"snäckorna", "snäck"},
		{"snäll", "snäll"},
		{"snälla", "snäll"},
		{"snällaste", "snäll"},
		{"snälle", "snäll"},
		{"snällt", "snällt"},
		{"snärja", "snärj"},
		{"snärjd", "snärjd"},
		{"snärjer", "snärj"},
		{"snärjt", "snärjt"},
		{"snärt", "snärt"},
		{"snärtade", "snärt"},
		{"snärtat", "snärt"},
		{"snäsige", "snäs"},
		{"snäsigt", "snäs"},
		{"snäste", "snäst"},
		{"snäv", "snäv"},
		{"snäva", "snäv"},
		{"snål", "snål"},
		{"snåla", "snål"},
		{"snålhet", "snål"},
		{"snår", "snår"},
		{"snåren", "snår"},
		{"snårets", "snåret"},
		{"snö", "snö"},
		{"snöa", "snöa"},
		{"snöade", "snöad"},
		{"snöar", "snöar"},
		{"snöat", "snöat"},
		{"snöberg", "snöberg"},
		{"snöduken", "snöduk"},
		{"snögatorna", "snögat"},
		{"snökorn", "snökorn"},
		{"snöliljan", "snöliljan"},
		{"snön", "snön"},
		{"snöping", "snöping"},
		{"snöplig", "snöp"},
		{"snöpliga", "snöp"},
		{"snöpligt", "snöp"},
		{"snörde", "snörd"},
		{"snöre", "snör"},
		{"snören", "snör"},
		{"snöret", "snöret"},
		{"snörpte", "snörpt"},
		{"snörräta", "snörrät"},
		{"snörvlar", "snörvl"},
		{"snösmältningsdag", "snösmältningsdag"},
		{"snöt", "snöt"},
		{"snövind", "snövind"},
		{"snövit", "snövit"},
		{"soare", "soar"},
		{"soareer", "soare"},
		{"sociala", "social"},
		{"societet", "societet"},
		{"societeten", "societet"},
		{"societetens", "societet"},
		{"societeter", "societet"},
		{"societetsdam", "societetsdam"},
		{"societetsnöjena", "societetsnöjen"},
		{"societetsskönheterna", "societetsskön"},
		{"socken", "sock"},
		{"sockenbor", "sockenb"},
		{"sockenkyrkan", "sockenkyrkan"},
		{"socker", "sock"},
		{"sockerbarn", "sockerbarn"},
		{"sockerbit", "sockerbit"},
		{"sockerbitarna", "sockerbit"},
		{"sockerdocka", "sockerdock"},
		{"sockerdricka", "sockerdrick"},
		{"sockerhjärta", "sockerhjärt"},
		{"sockers", "socker"},
		{"sockersöta", "sockersöt"},
		{"sockertopp", "sockertopp"},
		{"sockerurnorna", "sockerurn"},
		{"socknarna", "sockn"},
		{"socknen", "sockn"},
		{"socknens", "sockn"},
		{"sof", "sof"},
		{"soffa", "soff"},
		{"soffan", "soffan"},
		{"soffdynan", "soffdynan"},
		{"soffhörn", "soffhörn"},
		{"soffhörnet", "soffhörnet"},
		{"soffkarmen", "soffkarm"},
		{"sofflock", "sofflock"},
		{"sofforna", "soff"},
		{"sofföverdraget", "sofföverdraget"},
		{"sofi", "sofi"},
		{"sofia", "sofi"},
		{"sofie", "sofi"},
		{"sofielund", "sofielund"},
		{"sofies", "sofi"},
		{"sofismer", "sofism"},
		{"sofisterier", "sofisteri"},
		{"sofva", "sofv"},
		{"sofver", "sofv"},
		{"soien", "soien"},
		{"soker", "sok"},
		{"sokrates", "sokrat"},
		{"sokt", "sokt"},
		{"soktc", "soktc"},
		{"sokte", "sokt"},
		{"sol", "sol"},
		{"sola", "sol"},
		{"solade", "sol"},
		{"solar", "sol"},
		{"solbelyst", "solbelyst"},
		{"solblixt", "solblixt"},
		{"solbränd", "solbränd"},
		{"soldat", "sold"},
		{"soldatens", "soldat"},
		{"soldater", "soldat"},
		{"soldaterna", "soldat"},
		{"soldatfilosofi", "soldatfilosofi"},
		{"solen", "sol"},
		{"solens", "sol"},
		{"solglimtarna", "solglimt"},
		{"solid", "solid"},
		{"soliditet", "soliditet"},
		{"solig", "sol"},
		{"soliga", "sol"},
		{"soligare", "sol"},
		{"soligt", "sol"},
		{"solkiga", "solk"},
		{"solljuset", "solljuset"},
		{"solnedgångarna", "solnedgång"},
		{"solnedgången", "solnedgång"},
		{"solsidan", "solsidan"},
		{"solsken", "solsk"},
		{"solskenet", "solskenet"},
		{"solskensdag", "solskensdag"},
		{"solskensdagar", "solskensdag"},
		{"solskensdagarna", "solskensdag"},
		{"solskensvarma", "solskensvarm"},
		{"solskimmer", "solskimm"},
		{"solstrimma", "solstrimm"},
		{"solstrimman", "solstrimman"},
		{"solstrålar", "solstrål"},
		{"solstrålarna", "solstrål"},
		{"solstrålarnas", "solstrål"},
		{"solstrålarne", "solstrål"},
		{"solstråle", "solstrål"},
		{"soltorka", "soltork"},
		{"soltorkad", "soltork"},
		{"solupp", "solupp"},
		{"soluppgång", "soluppgång"},
		{"soluppgången", "soluppgång"},
		{"som", "som"},
		{"somliga", "som"},
		{"sommar", "somm"},
		{"sommaraftnarna", "sommaraftn"},
		{"sommarafton", "sommarafton"},
		{"sommarblå", "sommarblå"},
		{"sommarbyxor", "sommarbyx"},
		{"sommardag", "sommardag"},
		{"sommardagens", "sommardag"},
		{"sommaren", "somm"},
		{"sommarens", "somm"},
		{"sommarfarväl", "sommarfarväl"},
		{"sommarfjäril", "sommarfjäril"},
		{"sommarfloret", "sommarfloret"},
		{"sommargrönskan", "sommargrönskan"},
		{"sommarhem", "sommarhem"},
		{"sommarhettan", "sommarhettan"},
		{"sommarklänning", "sommarklänning"},
		{"sommarklänningar", "sommarklänning"},
		{"sommarkostym", "sommarkostym"},
		{"sommarkvällen", "sommarkväll"},
		{"sommarlovet", "sommarlovet"},
		{"sommarmoln", "sommarmoln"},
		{"sommarmorgnarna", "sommarmorgn"},
		{"sommarmorgonen", "sommarmorgon"},
		{"sommarn", "sommarn"},
		{"sommarnattsmörkret", "sommarnattsmörkret"},
		{"sommarnattsskymningen", "sommarnattsskymning"},
		{"sommarns", "sommarn"},
		{"sommarnätter", "sommarnät"},
		{"sommarnöje", "sommarnöj"},
		{"sommarnöjet", "sommarnöjet"},
		{"sommarrestaurangerna", "sommarrestaurang"},
		{"sommarrum", "sommarrum"},
		{"sommarsöndag", "sommarsöndag"},
		{"sommartiden", "sommartid"},
		{"sommarvindem", "sommarvindem"},
		{"sommarvinden", "sommarvind"},
		{"somna", "somn"},
		{"somnade", "somn"},
		{"somnar", "somn"},
		{"somnat", "somn"},
		{"somnen", "somn"},
		{"somrarna", "somr"},
		{"somras", "somr"},
		{"somrnaren", "somrn"},
		{"son", "son"},
		{"sonderna", "sond"},
		{"sonen", "son"},
		{"sonens", "son"},
		{"sonett", "sonet"},
		{"sonhustru", "sonhustru"},
		{"sonn", "sonn"},
		{"sons", "son"},
		{"sonson", "sonson"},
		{"sont", "sont"},
		{"sop", "sop"},
		{"sopa", "sop"},
		{"sopade", "sop"},
		{"soppa", "sopp"},
		{"soppan", "soppan"},
		{"soppor", "sopp"},
		{"soppskålen", "soppskål"},
		{"sorg", "sorg"},
		{"sorgbrev", "sorgbrev"},
		{"sorgbundenhet", "sorgbunden"},
		{"sorgdräkt", "sorgdräk"},
		{"sorgefärd", "sorgefärd"},
		{"sorgehuset", "sorgehuset"},
		{"sorgen", "sorg"},
		{"sorgens", "sorg"},
		{"sorger", "sorg"},
		{"sorgesam", "sorgesam"},
		{"sorgfälliga", "sorgfäl"},
		{"sorgfälligare", "sorgfäl"},
		{"sorgfälligaste", "sorgfäl"},
		{"sorgfällighet", "sorgfäl"},
		{"sorgfälligt", "sorgfäl"},
		{"sorglig", "sorg"},
		{"sorgliga", "sorg"},
		{"sorgligt", "sorg"},
		{"sorgmodigaste", "sorgmod"},
		{"sorgmodigt", "sorgmod"},
		{"sorgse", "sorgs"},
		{"sorgsen", "sorgs"},
		{"sorgsenhet", "sorgsen"},
		{"sorgset", "sorgset"},
		{"sorgsna", "sorgsn"},
		{"sorl", "sorl"},
		{"sorlade", "sorl"},
		{"sorlande", "sorl"},
		{"sorlet", "sorlet"},
		{"sorm", "sorm"},
		{"sorn", "sorn"},
		{"sort", "sort"},
		{"sorten", "sort"},
		{"sortens", "sort"},
		{"sorter", "sort"},
		{"sorterade", "sorter"},
		{"sorters", "sorter"},
		{"sorts", "sort"},
		{"sot", "sot"},
		{"sotar", "sot"},
		{"sotarfrun", "sotarfrun"},
		{"sotenäs", "sotenäs"},
		{"sotflammiga", "sotflamm"},
		{"sottiser", "sottis"},
		{"sov", "sov"},
		{"sova", "sov"},
		{"sovande", "sov"},
		{"sover", "sov"},
		{"sovit", "sovit"},
		{"sovo", "sovo"},
		{"sovrum", "sovrum"},
		{"sovrummen", "sovrumm"},
		{"sovrummet", "sovrummet"},
		{"spad", "spad"},
		{"spada", "spad"},
		{"spadar", "spad"},
		{"spade", "spad"},
		{"spader", "spad"},
		{"spaderdam", "spaderdam"},
		{"spak", "spak"},
		{"spakt", "spakt"},
		{"spana", "span"},
		{"spanade", "span"},
		{"spanande", "span"},
		{"spanat", "span"},
		{"spaning", "spaning"},
		{"spaningen", "spaning"},
		{"spanmål", "spanmål"},
		{"spann", "spann"},
		{"spannmålen", "spannmål"},
		{"spansk", "spansk"},
		{"spanska", "spansk"},
		{"spar", "spar"},
		{"spara", "spar"},
		{"sparade", "spar"},
		{"sparar", "spar"},
		{"sparat", "spar"},
		{"sparka", "spark"},
		{"sparkad", "spark"},
		{"sparkade", "spark"},
		{"sparkar", "spark"},
		{"sparkassa", "sparkass"},
		{"sparkassorna", "sparkass"},
		{"sparkat", "spark"},
		{"sparlakan", "sparlakan"},
		{"sparsamhet", "sparsam"},
		{"sparsamhetsskäl", "sparsamhetsskäl"},
		{"sparsamt", "sparsamt"},
		{"sparstyfver", "sparstyfv"},
		{"spartanskt", "spartansk"},
		{"sparv", "sparv"},
		{"sparvar", "sparv"},
		{"sparvarna", "sparv"},
		{"spasmer", "spasm"},
		{"spasmodiskt", "spasmodisk"},
		{"spatsera", "spatser"},
		{"spatserade", "spatser"},
		{"spatserat", "spatser"},
		{"spatserfärd", "spatserfärd"},
		{"spatserrock", "spatserrock"},
		{"spcgel", "spcgel"},
		{"spcjadc", "spcjadc"},
		{"spe", "spe"},
		{"specerihandlare", "specerihandl"},
		{"specialisera", "specialiser"},
		{"specialisten", "specialist"},
		{"specialitet", "specialitet"},
		{"specialstudier", "specialstudi"},
		{"specie", "speci"},
		{"speciella", "speciell"},
		{"speg", "speg"},
		{"spege", "speg"},
		{"spegehl", "spegehl"},
		{"spegel", "spegel"},
		{"spegelbilden", "spegelbild"},
		{"spegelbordet", "spegelbordet"},
		{"spegelglaset", "spegelglaset"},
		{"spegellåda", "spegellåd"},
		{"spegeln", "spegeln"},
		{"spegelyta", "spegelyt"},
		{"spegla", "spegl"},
		{"speglade", "spegl"},
		{"speglades", "spegl"},
		{"speglande", "spegl"},
		{"speglar", "spegl"},
		{"speja", "spej"},
		{"spejade", "spej"},
		{"spejande", "spej"},
		{"spejeri", "spejeri"},
		{"spektakel", "spektakel"},
		{"spektakelbiljett", "spektakelbiljet"},
		{"spektakeldagen", "spektakeldag"},
		{"spektakeltiden", "spektakeltid"},
		{"spektakler", "spektakl"},
		{"spektaklet", "spektaklet"},
		{"spektoren", "spektor"},
		{"spekulant", "spekulant"},
		{"spekulation", "spekulation"},
		{"spekulationer", "spekulation"},
		{"spekulationerna", "spekulation"},
		{"spekulera", "spekuler"},
		{"spekulerade", "spekuler"},
		{"spel", "spel"},
		{"spela", "spel"},
		{"spelade", "spel"},
		{"spelande", "spel"},
		{"spelar", "spel"},
		{"spelat", "spel"},
		{"spelbordet", "spelbordet"},
		{"spelct", "spelct"},
		{"spelen", "spel"},
		{"spelet", "spelet"},
		{"spelevink", "spelevink"},
		{"spelfåglar", "spelfågl"},
		{"spelkort", "spelkort"},
		{"spelman", "spelman"},
		{"spelmän", "spelmän"},
		{"spelpartier", "spelparti"},
		{"spelsen", "spels"},
		{"spelte", "spelt"},
		{"spelvärdarna", "spelvärd"},
		{"spenaten", "spenat"},
		{"spenatkarotten", "spenatkarot"},
		{"spencer", "spenc"},
		{"spens", "spen"},
		{"spenslig", "spens"},
		{"spensliga", "spens"},
		{"spets", "spet"},
		{"spetsade", "spets"},
		{"spetsades", "spets"},
		{"spetsar", "spets"},
		{"spetsen", "spets"},
		{"spetsglas", "spetsgl"},
		{"spetsig", "spets"},
		{"spetsiga", "spets"},
		{"spetsigaste", "spets"},
		{"spetsigt", "spets"},
		{"spetskantade", "spetskant"},
		{"spetskrage", "spetskrag"},
		{"spickeskinkan", "spickeskinkan"},
		{"spik", "spik"},
		{"spiken", "spik"},
		{"spilla", "spill"},
		{"spilld", "spilld"},
		{"spillda", "spilld"},
		{"spilles", "spill"},
		{"spillning", "spillning"},
		{"spillror", "spillr"},
		{"spillrorna", "spillr"},
		{"spiltorna", "spilt"},
		{"spindel", "spindel"},
		{"spindellika", "spindellik"},
		{"spindeln", "spindeln"},
		{"spindelnät", "spindelnät"},
		{"spindelväv", "spindelväv"},
		{"spindelvävar", "spindelväv"},
		{"spindlar", "spindl"},
		{"spindlarnas", "spindl"},
		{"spinna", "spinn"},
		{"spinnas", "spinn"},
		{"spinner", "spinn"},
		{"spinnerskans", "spinnerskan"},
		{"spinnrock", "spinnrock"},
		{"spinnrocken", "spinnrock"},
		{"spion", "spion"},
		{"spionera", "spioner"},
		{"spionerade", "spioner"},
		{"spionerat", "spioner"},
		{"spira", "spir"},
		{"spirade", "spir"},
		{"spiralfjädrar", "spiralfjädr"},
		{"spirande", "spir"},
		{"spirat", "spir"},
		{"spirituosa", "spirituos"},
		{"spis", "spis"},
		{"spisade", "spis"},
		{"spisat", "spis"},
		{"spiseln", "spiseln"},
		{"spiselvärmen", "spiselvärm"},
		{"spisen", "spis"},
		{"spiskanten", "spiskant"},
		{"spisvrån", "spisvrån"},
		{"spjerna", "spjern"},
		{"spjernade", "spjern"},
		{"spjut", "spjut"},
		{"spjutsäng", "spjutsäng"},
		{"spjäll", "spjäll"},
		{"spjärnade", "spjärn"},
		{"spleen", "spleen"},
		{"splitter", "splitt"},
		{"spolen", "spol"},
		{"spoling", "spoling"},
		{"spord", "spord"},
		{"sporer", "spor"},
		{"sporra", "sporr"},
		{"sporrar", "sporr"},
		{"sporre", "sporr"},
		{"sport", "sport"},
		{"spotsk", "spotsk"},
		{"spotskt", "spotsk"},
		{"spotta", "spott"},
		{"spottade", "spott"},
		{"spottstyfver", "spottstyfv"},
		{"sprack", "sprack"},
		{"sprakade", "sprak"},
		{"sprakande", "sprak"},
		{"sprang", "sprang"},
		{"spratt", "spratt"},
		{"sprattlade", "sprattl"},
		{"spred", "spred"},
		{"spredo", "spredo"},
		{"spredos", "spredo"},
		{"spretade", "spret"},
		{"spretande", "spret"},
		{"spricka", "sprick"},
		{"spricker", "sprick"},
		{"sprid", "sprid"},
		{"sprida", "sprid"},
		{"spridas", "sprid"},
		{"spridd", "spridd"},
		{"spridda", "spridd"},
		{"spridt", "spridt"},
		{"spring", "spring"},
		{"springa", "spring"},
		{"springande", "spring"},
		{"springandes", "spring"},
		{"springare", "spring"},
		{"springbrunn", "springbrun"},
		{"springer", "spring"},
		{"springet", "springet"},
		{"springkäringar", "springkäring"},
		{"springorna", "spring"},
		{"springpojke", "springpojk"},
		{"springrer", "springr"},
		{"spriseglet", "spriseglet"},
		{"sprit", "sprit"},
		{"sprita", "sprit"},
		{"spriten", "sprit"},
		{"spritt", "spritt"},
		{"spritta", "spritt"},
		{"sprittande", "spritt"},
		{"spritter", "spritt"},
		{"sprittning", "sprittning"},
		{"sprittningen", "sprittning"},
		{"sprucken", "spruck"},
		{"sprucket", "sprucket"},
		{"spruckit", "spruckit"},
		{"spruckna", "spruckn"},
		{"sprungit", "sprungit"},
		{"sprungo", "sprungo"},
		{"spruta", "sprut"},
		{"sprutade", "sprut"},
		{"sprutto", "sprutto"},
		{"spräcklig", "spräck"},
		{"spräckliga", "spräck"},
		{"spräckt", "spräck"},
		{"spräcktes", "spräck"},
		{"spränga", "spräng"},
		{"sprängande", "spräng"},
		{"sprängas", "spräng"},
		{"sprängd", "spräng"},
		{"sprängda", "spräng"},
		{"sprängdes", "spräng"},
		{"sprängs", "spräng"},
		{"sprätt", "sprätt"},
		{"sprättar", "sprätt"},
		{"språk", "språk"},
		{"språka", "språk"},
		{"språkade", "språk"},
		{"språkas", "språk"},
		{"språkbruk", "språkbruk"},
		{"språket", "språket"},
		{"språkets", "språket"},
		{"språklig", "språk"},
		{"språkliga", "språk"},
		{"språklärare", "språklär"},
		{"språklåda", "språklåd"},
		{"språksam", "språksam"},
		{"språng", "språng"},
		{"språnget", "språnget"},
		{"spröd", "spröd"},
		{"spröda", "spröd"},
		{"spröt", "spröt"},
		{"sprött", "sprött"},
		{"spunnet", "spunnet"},
		{"spydigt", "spyd"},
		{"späd", "späd"},
		{"späda", "späd"},
		{"spädare", "späd"},
		{"spädaste", "späd"},
		{"spädde", "spädd"},
		{"späder", "späd"},
		{"spädes", "späd"},
		{"späka", "späk"},
		{"spänd", "spänd"},
		{"spända", "spänd"},
		{"spände", "spänd"},
		{"spändes", "spänd"},
		{"spändt", "spänd"},
		{"spänn", "spänn"},
		{"spänna", "spänn"},
		{"spännande", "spänn"},
		{"spänner", "spänn"},
		{"spänning", "spänning"},
		{"spänningen", "spänning"},
		{"spänstig", "spänst"},
		{"spänstighet", "spänst"},
		{"spänt", "spänt"},
		{"spänts", "spänt"},
		{"spärrad", "spärr"},
		{"spärrade", "spärr"},
		{"spärras", "spärr"},
		{"spådde", "spådd"},
		{"spånadsgummor", "spånadsgumm"},
		{"spår", "spår"},
		{"spåra", "spår"},
		{"spårat", "spår"},
		{"spåren", "spår"},
		{"spåret", "spåret"},
		{"spårhund", "spårhund"},
		{"spårhundar", "spårhund"},
		{"spårvagn", "spårvagn"},
		{"spårvagnarna", "spårvagn"},
		{"spårvagnarnas", "spårvagn"},
		{"spårvagnen", "spårvagn"},
		{"spått", "spått"},
		{"spö", "spö"},
		{"spöet", "spöet"},
		{"spöka", "spök"},
		{"spökade", "spök"},
		{"spökande", "spök"},
		{"spöke", "spök"},
		{"spökelse", "spök"},
		{"spöken", "spök"},
		{"spökeri", "spökeri"},
		{"spöklikt", "spöklik"},
		{"spökskepp", "spökskepp"},
		{"spörjande", "spörj"},
		{"sqm", "sqm"},
		{"sqvallersjuka", "sqvallersjuk"},
		{"sqvallra", "sqvallr"},
		{"sqvalpa", "sqvalp"},
		{"sqvalpande", "sqvalp"},
		{"srapplar", "srappl"},
		{"sräste", "sräst"},
		{"ssterrikeochomexpedi", "ssterrikeochomexpedi"},
		{"st", "st"},
		{"sta", "sta"},
		{"staaff", "staaff"},
		{"staaffs", "staaff"},
		{"stack", "stack"},
		{"stackare", "stack"},
		{"stackaren", "stack"},
		{"stackarn", "stackarn"},
		{"stackarna", "stack"},
		{"stackars", "stackar"},
		{"stacken", "stack"},
		{"stackrarna", "stackr"},
		{"stad", "stad"},
		{"stadd", "stadd"},
		{"stadda", "stadd"},
		{"staden", "stad"},
		{"stadens", "stad"},
		{"stadfäst", "stadfäst"},
		{"stadfästa", "stadfäst"},
		{"stadfästelsen", "stadfäst"},
		{"stadgade", "stadg"},
		{"stadgadt", "stadgad"},
		{"stadgar", "stadg"},
		{"stadgat", "stadg"},
		{"stadig", "stad"},
		{"stadiga", "stad"},
		{"stadigt", "stad"},
		{"stadigvarande", "stadigvar"},
		{"stadium", "stadium"},
		{"stadsbo", "stadsbo"},
		{"stadsbor", "stadsb"},
		{"stadsdelarna", "stadsdel"},
		{"stadsflickan", "stadsflickan"},
		{"stadsflickorna", "stadsflick"},
		{"stadsfullmäktig", "stadsfullmäkt"},
		{"stadsfullmäktige", "stadsfullmäkt"},
		{"stadspark", "stadspark"},
		{"stadsporten", "stadsport"},
		{"stadsvåning", "stadsvåning"},
		{"staende", "staend"},
		{"stafvade", "stafv"},
		{"stagnelius", "stagnelius"},
		{"staken", "stak"},
		{"staket", "staket"},
		{"staketet", "staketet"},
		{"stal", "stal"},
		{"stall", "stall"},
		{"stallbroder", "stallbrod"},
		{"stallbröder", "stallbröd"},
		{"stallet", "stallet"},
		{"stallgårdens", "stallgård"},
		{"stallmng", "stallmng"},
		{"stallmästargården", "stallmästargård"},
		{"stam", "stam"},
		{"stamfränderna", "stamfränd"},
		{"stamhåll", "stamhåll"},
		{"stamma", "stamm"},
		{"stammade", "stamm"},
		{"stammande", "stamm"},
		{"stammar", "stamm"},
		{"stammarna", "stamm"},
		{"stammarnas", "stamm"},
		{"stammen", "stamm"},
		{"stammoder", "stammod"},
		{"stammors", "stammor"},
		{"stammy", "stammy"},
		{"stampade", "stamp"},
		{"stan", "stan"},
		{"stand", "stand"},
		{"standigt", "stand"},
		{"stank", "stank"},
		{"stanna", "stann"},
		{"stannade", "stann"},
		{"stannande", "stann"},
		{"stannar", "stann"},
		{"stannat", "stann"},
		{"stanny", "stanny"},
		{"stannys", "stanny"},
		{"stapel", "stapel"},
		{"stapeln", "stapeln"},
		{"stapplande", "stappl"},
		{"star", "star"},
		{"stark", "stark"},
		{"starka", "stark"},
		{"starkare", "stark"},
		{"starkast", "stark"},
		{"starkaste", "stark"},
		{"starkl", "starkl"},
		{"starkt", "stark"},
		{"stassen", "stass"},
		{"stat", "stat"},
		{"statardottern", "statardot"},
		{"statarflickan", "statarflickan"},
		{"staten", "stat"},
		{"statens", "stat"},
		{"station", "station"},
		{"stationen", "station"},
		{"stationer", "station"},
		{"stationerna", "station"},
		{"stations", "station"},
		{"stationshuset", "stationshuset"},
		{"stationshållet", "stationshållet"},
		{"stationsinspek", "stationsinspek"},
		{"stationsinspektor", "stationsinspek"},
		{"stationsinspektoren", "stationsinspektor"},
		{"statistiken", "statistik"},
		{"statsråd", "statsråd"},
		{"statstidningen", "statstidning"},
		{"statt", "statt"},
		{"staty", "staty"},
		{"stav", "stav"},
		{"stava", "stav"},
		{"stavad", "stav"},
		{"stavade", "stav"},
		{"stavarna", "stav"},
		{"stavning", "stavning"},
		{"stavningsukas", "stavningsuk"},
		{"stcekars", "stcekar"},
		{"stearin", "stearin"},
		{"stearinen", "stearin"},
		{"steg", "steg"},
		{"stege", "steg"},
		{"stegem", "stegem"},
		{"stegen", "steg"},
		{"steget", "steget"},
		{"stego", "stego"},
		{"stegrade", "stegr"},
		{"stegrades", "stegr"},
		{"stegrar", "stegr"},
		{"stegras", "stegr"},
		{"stegs", "steg"},
		{"steinlens", "steinl"},
		{"stek", "stek"},
		{"steken", "stek"},
		{"stekos", "steko"},
		{"stekt", "stekt"},
		{"stekta", "stekt"},
		{"stekte", "stekt"},
		{"stel", "stel"},
		{"stela", "stel"},
		{"stelbent", "stelbent"},
		{"stelfrusna", "stelfrusn"},
		{"stelfrusne", "stelfrusn"},
		{"stellan", "stellan"},
		{"stellans", "stellan"},
		{"stelnad", "steln"},
		{"stelnade", "steln"},
		{"stelnat", "steln"},
		{"stelt", "stelt"},
		{"sten", "sten"},
		{"stenad", "sten"},
		{"stenade", "sten"},
		{"stenar", "sten"},
		{"stenarna", "sten"},
		{"stenarne", "sten"},
		{"stenbilden", "stenbild"},
		{"stenbord", "stenbord"},
		{"stenbänkar", "stenbänk"},
		{"stenen", "sten"},
		{"stenhammar", "stenhamm"},
		{"stenig", "sten"},
		{"steniga", "sten"},
		{"stenlagd", "stenlag"},
		{"stenläggning", "stenläggning"},
		{"stenläggningen", "stenläggning"},
		{"stenrik", "stenrik"},
		{"stentrappan", "stentrappan"},
		{"stentrappstegen", "stentrappsteg"},
		{"ster", "ster"},
		{"steril", "steril"},
		{"sterila", "steril"},
		{"stetoskop", "stetoskop"},
		{"stetoskopet", "stetoskopet"},
		{"sti", "sti"},
		{"stia", "stia"},
		{"stick", "stick"},
		{"sticka", "stick"},
		{"stickade", "stick"},
		{"stickan", "stickan"},
		{"stickande", "stick"},
		{"sticker", "stick"},
		{"sticket", "sticket"},
		{"stickor", "stick"},
		{"stickord", "stickord"},
		{"stickstrumpan", "stickstrumpan"},
		{"stiernhielm", "stiernhielm"},
		{"stif", "stif"},
		{"stifta", "stift"},
		{"stiftandet", "stift"},
		{"stiftar", "stift"},
		{"stiftare", "stift"},
		{"stiftat", "stift"},
		{"stiftelse", "stift"},
		{"stig", "stig"},
		{"stiga", "stig"},
		{"stigande", "stig"},
		{"stigar", "stig"},
		{"stigen", "stig"},
		{"stiger", "stig"},
		{"stigit", "stigit"},
		{"stiktat", "stikt"},
		{"stil", "stil"},
		{"stilen", "stil"},
		{"still", "still"},
		{"stilla", "still"},
		{"stillade", "still"},
		{"stillande", "still"},
		{"stillas", "still"},
		{"stillastående", "stillaståend"},
		{"stillat", "still"},
		{"stillhet", "still"},
		{"stillheten", "still"},
		{"stillhrt", "stillhrt"},
		{"stillsam", "stillsam"},
		{"stillsamma", "stillsamm"},
		{"stillsamt", "stillsamt"},
		{"stiltje", "stiltj"},
		{"stim", "stim"},
		{"stimma", "stimm"},
		{"stimulera", "stimuler"},
		{"stimulerar", "stimuler"},
		{"stina", "stin"},
		{"sting", "sting"},
		{"stinger", "sting"},
		{"stinkande", "stink"},
		{"stinn", "stinn"},
		{"stir", "stir"},
		{"stirra", "stirr"},
		{"stirrade", "stirr"},
		{"stirrande", "stirr"},
		{"stirrar", "stirr"},
		{"stj", "stj"},
		{"stjarna", "stjarn"},
		{"stjarnall", "stjarnall"},
		{"stjarnor", "stjarn"},
		{"stjerna", "stjern"},
		{"stjufson", "stjufson"},
		{"stjäl", "stjäl"},
		{"stjäla", "stjäl"},
		{"stjälkar", "stjälk"},
		{"stjälkarna", "stjälk"},
		{"stjälpa", "stjälp"},
		{"stjärna", "stjärn"},
		{"stjärnan", "stjärnan"},
		{"stjärnans", "stjärnan"},
		{"stjärnblommor", "stjärnblomm"},
		{"stjärneljusen", "stjärneljus"},
		{"stjärnhimmel", "stjärnhimmel"},
		{"stjärnhimmeln", "stjärnhimmeln"},
		{"stjärnklar", "stjärnkl"},
		{"stjärnljus", "stjärnljus"},
		{"stjärnor", "stjärn"},
		{"stjärnorna", "stjärn"},
		{"stjärnornas", "stjärn"},
		{"stjärnors", "stjärnor"},
		{"stjärnögon", "stjärnögon"},
		{"stock", "stock"},
		{"stockade", "stock"},
		{"stockbolm", "stockbolm"},
		{"stocken", "stock"},
		{"stockhohn", "stockhohn"},
		{"stockholm", "stockholm"},
		{"stockholms", "stockholm"},
		{"stockholmsbekant", "stockholmsbekant"},
		{"stockholmsbo", "stockholmsbo"},
		{"stockholmsflickornas", "stockholmsflick"},
		{"stockholmsgästen", "stockholmsgäst"},
		{"stockholmsregemente", "stockholmsregement"},
		{"stockholmsresan", "stockholmsresan"},
		{"stockholmsrummet", "stockholmsrummet"},
		{"stockholmssocieteten", "stockholmssocietet"},
		{"stockholmsvistelse", "stockholmsvist"},
		{"stockkonservativa", "stockkonservativ"},
		{"stod", "stod"},
		{"stodde", "stodd"},
		{"stode", "stod"},
		{"stoder", "stod"},
		{"stodo", "stodo"},
		{"stodod", "stodod"},
		{"stoff", "stoff"},
		{"stoffet", "stoffet"},
		{"stoft", "stoft"},
		{"stoftet", "stoftet"},
		{"stofthyddans", "stofthyddan"},
		{"stoftskyarna", "stoftsky"},
		{"stoj", "stoj"},
		{"stol", "stol"},
		{"stolar", "stol"},
		{"stolarna", "stol"},
		{"stolen", "stol"},
		{"stollen", "stoll"},
		{"stolpar", "stolp"},
		{"stolparna", "stolp"},
		{"stolpen", "stolp"},
		{"stolskarmen", "stolskarm"},
		{"stolt", "stolt"},
		{"stolta", "stolt"},
		{"stoltaste", "stolt"},
		{"stolte", "stolt"},
		{"stolthet", "stolt"},
		{"stoltheten", "stolt"},
		{"stoltserade", "stoltser"},
		{"stoltserande", "stoltser"},
		{"stoltserar", "stoltser"},
		{"stommen", "stomm"},
		{"stonade", "ston"},
		{"stonande", "ston"},
		{"stop", "stop"},
		{"stopen", "stop"},
		{"stopp", "stopp"},
		{"stoppa", "stopp"},
		{"stoppade", "stopp"},
		{"stoppadt", "stoppad"},
		{"stoppar", "stopp"},
		{"stoppat", "stopp"},
		{"stor", "stor"},
		{"stora", "stor"},
		{"storartad", "storart"},
		{"storartade", "storart"},
		{"storartat", "storart"},
		{"storbladiga", "storblad"},
		{"storbåten", "storbåt"},
		{"storbåtens", "storbåt"},
		{"stordjur", "stordjur"},
		{"store", "stor"},
		{"storgubbar", "storgubb"},
		{"storhet", "stor"},
		{"storheten", "stor"},
		{"storheter", "stor"},
		{"storhets", "storhet"},
		{"storkonungens", "storkonung"},
		{"storkyrkan", "storkyrkan"},
		{"storkyrkobrinken", "storkyrkobrink"},
		{"storlek", "storlek"},
		{"storm", "storm"},
		{"stormade", "storm"},
		{"stormande", "storm"},
		{"stormar", "storm"},
		{"stormarne", "storm"},
		{"stormars", "stormar"},
		{"stormasten", "stormast"},
		{"stormat", "storm"},
		{"stormbyn", "stormbyn"},
		{"stormen", "storm"},
		{"stormens", "storm"},
		{"stormförtjusta", "stormförtjust"},
		{"stormig", "storm"},
		{"stormiga", "storm"},
		{"stormigt", "storm"},
		{"stormodig", "stormod"},
		{"stormodighet", "stormod"},
		{"stormvanda", "stormvand"},
		{"storsjöodjuret", "storsjöodjuret"},
		{"storskärmad", "storskärm"},
		{"storståtlig", "storståt"},
		{"stort", "stort"},
		{"stortvätt", "stortvät"},
		{"storvaxt", "storvaxt"},
		{"storverket", "storverket"},
		{"storvuxna", "storvuxn"},
		{"storvuxne", "storvuxn"},
		{"storväxt", "storväxt"},
		{"storätande", "storät"},
		{"stota", "stot"},
		{"stotrad", "stotr"},
		{"stra", "stra"},
		{"strackta", "strack"},
		{"strackte", "strack"},
		{"straff", "straff"},
		{"straffa", "straff"},
		{"straffad", "straff"},
		{"straffade", "straff"},
		{"straffande", "straff"},
		{"straffas", "straff"},
		{"straffat", "straff"},
		{"straffdom", "straffdom"},
		{"straffdomar", "straffdom"},
		{"straffet", "straffet"},
		{"straffpredikan", "straffpredikan"},
		{"strafftal", "strafftal"},
		{"strala", "stral"},
		{"stralade", "stral"},
		{"stralande", "stral"},
		{"stralar", "stral"},
		{"stramt", "stramt"},
		{"stran", "stran"},
		{"strand", "strand"},
		{"strandade", "strand"},
		{"strandat", "strand"},
		{"strandbo", "strandbo"},
		{"strandbons", "strandbon"},
		{"strandbor", "strandb"},
		{"stranden", "strand"},
		{"strandens", "strand"},
		{"strandmarken", "strandmark"},
		{"strandsätta", "strandsät"},
		{"strandvägen", "strandväg"},
		{"strax", "strax"},
		{"straxt", "straxt"},
		{"streber", "streb"},
		{"streck", "streck"},
		{"strecken", "streck"},
		{"strecket", "strecket"},
		{"stred", "stred"},
		{"stretade", "stret"},
		{"stretande", "stret"},
		{"strid", "strid"},
		{"strida", "strid"},
		{"stridande", "strid"},
		{"stridde", "stridd"},
		{"striden", "strid"},
		{"stridens", "strid"},
		{"strider", "strid"},
		{"stridig", "strid"},
		{"stridiga", "strid"},
		{"stridigheter", "strid"},
		{"strids", "strid"},
		{"stridsbloss", "stridsbloss"},
		{"stridslust", "stridslust"},
		{"stridsämne", "stridsämn"},
		{"strimma", "strimm"},
		{"strimman", "strimman"},
		{"strimmat", "strimm"},
		{"strimmiga", "strimm"},
		{"strimmor", "strimm"},
		{"strimmorna", "strimm"},
		{"strindbergs", "strindberg"},
		{"stripiga", "strip"},
		{"stripigt", "strip"},
		{"stritt", "stritt"},
		{"strlpe", "strlpe"},
		{"strofer", "strof"},
		{"strukit", "strukit"},
		{"struktur", "struktur"},
		{"strumahals", "strumahal"},
		{"strumpeband", "strumpeband"},
		{"strumpfötterna", "strumpföt"},
		{"strumpor", "strump"},
		{"strumporna", "strump"},
		{"strunt", "strunt"},
		{"struntgevär", "struntgevär"},
		{"struntplank", "struntplank"},
		{"struntviktiga", "struntvikt"},
		{"strupar", "strup"},
		{"strupe", "strup"},
		{"strupen", "strup"},
		{"strussenhielm", "strussenhielm"},
		{"strussenhielms", "strussenhielm"},
		{"strut", "strut"},
		{"strutsarna", "struts"},
		{"strutsarnas", "struts"},
		{"strutsen", "struts"},
		{"strutsens", "struts"},
		{"stryk", "stryk"},
		{"stryka", "stryk"},
		{"strykande", "stryk"},
		{"strykas", "stryk"},
		{"stryker", "stryk"},
		{"strykning", "strykning"},
		{"strypsjuka", "strypsjuk"},
		{"strä", "strä"},
		{"sträck", "sträck"},
		{"sträcka", "sträck"},
		{"sträckande", "sträck"},
		{"sträcker", "sträck"},
		{"sträckes", "sträck"},
		{"sträcket", "sträcket"},
		{"sträckor", "sträck"},
		{"sträckt", "sträck"},
		{"sträckta", "sträck"},
		{"sträckte", "sträck"},
		{"sträcktes", "sträck"},
		{"sträf", "sträf"},
		{"sträft", "sträft"},
		{"sträfva", "sträfv"},
		{"sträfvade", "sträfv"},
		{"sträfvan", "sträfvan"},
		{"sträfvar", "sträfv"},
		{"stränder", "stränd"},
		{"stränderna", "stränd"},
		{"strändernas", "stränd"},
		{"sträng", "sträng"},
		{"stränga", "sträng"},
		{"strängar", "sträng"},
		{"strängare", "sträng"},
		{"strängarna", "sträng"},
		{"strängaste", "sträng"},
		{"stränge", "sträng"},
		{"stränghet", "sträng"},
		{"strängnäs", "strängnäs"},
		{"strängt", "sträng"},
		{"sträv", "sträv"},
		{"sträva", "sträv"},
		{"strävade", "sträv"},
		{"strävan", "strävan"},
		{"strävande", "sträv"},
		{"strävar", "sträv"},
		{"strävat", "sträv"},
		{"strävpelare", "strävpel"},
		{"strävsamhet", "strävsam"},
		{"strävsamma", "strävsamm"},
		{"strävsinta", "strävsint"},
		{"strävt", "strävt"},
		{"strå", "strå"},
		{"stråkars", "stråkar"},
		{"stråken", "stråk"},
		{"stråla", "strål"},
		{"strålade", "strål"},
		{"strålande", "strål"},
		{"strålar", "strål"},
		{"strålat", "strål"},
		{"strålbrytning", "strålbrytning"},
		{"stråle", "strål"},
		{"strån", "strån"},
		{"stråt", "stråt"},
		{"strö", "strö"},
		{"strödd", "strödd"},
		{"strödda", "strödd"},
		{"strödde", "strödd"},
		{"ströftåg", "ströftåg"},
		{"ströfva", "ströfv"},
		{"strök", "strök"},
		{"ströko", "ströko"},
		{"ströks", "strök"},
		{"ström", "ström"},
		{"strömma", "strömm"},
		{"strömmade", "strömm"},
		{"strömmar", "strömm"},
		{"strömmarna", "strömm"},
		{"strömmarnas", "strömm"},
		{"strömmen", "strömm"},
		{"strömmens", "strömm"},
		{"strömparterren", "strömparterr"},
		{"strör", "strör"},
		{"strött", "strött"},
		{"ströva", "ströv"},
		{"strövade", "ströv"},
		{"strövat", "ströv"},
		{"strövtåg", "strövtåg"},
		{"stubbe", "stubb"},
		{"stucken", "stuck"},
		{"stuckit", "stuckit"},
		{"stuckna", "stuckn"},
		{"stucko", "stucko"},
		{"student", "student"},
		{"studenten", "student"},
		{"studenter", "student"},
		{"studentkula", "studentkul"},
		{"studera", "studer"},
		{"studerade", "studer"},
		{"studerat", "studer"},
		{"studier", "studi"},
		{"studiet", "studiet"},
		{"studiosi", "studiosi"},
		{"studsa", "studs"},
		{"studsade", "studs"},
		{"studsare", "studs"},
		{"studsaren", "studs"},
		{"stufvade", "stufv"},
		{"stufvar", "stufv"},
		{"stuga", "stug"},
		{"stugan", "stugan"},
		{"stugans", "stugan"},
		{"stugas", "stug"},
		{"stugor", "stug"},
		{"stugorna", "stug"},
		{"stugudörren", "stugudörr"},
		{"stuka", "stuk"},
		{"stulit", "stulit"},
		{"stultade", "stult"},
		{"stultat", "stult"},
		{"stum", "stum"},
		{"stumd", "stumd"},
		{"stumma", "stumm"},
		{"stump", "stump"},
		{"stumpar", "stump"},
		{"stumpen", "stump"},
		{"stumt", "stumt"},
		{"stund", "stund"},
		{"stundade", "stund"},
		{"stundande", "stund"},
		{"stunden", "stund"},
		{"stundens", "stund"},
		{"stunder", "stund"},
		{"stunderna", "stund"},
		{"stundligen", "stund"},
		{"stundom", "stundom"},
		{"stundorm", "stundorm"},
		{"stunds", "stund"},
		{"stungit", "stungit"},
		{"stungo", "stungo"},
		{"stunkit", "stunkit"},
		{"stupa", "stup"},
		{"stupade", "stup"},
		{"stupande", "stup"},
		{"stupar", "stup"},
		{"stupfulle", "stupfull"},
		{"stursk", "stursk"},
		{"stut", "stut"},
		{"stuvade", "stuv"},
		{"stycke", "styck"},
		{"styckegods", "styckegod"},
		{"stycken", "styck"},
		{"stycket", "stycket"},
		{"stycketl", "stycketl"},
		{"styf", "styf"},
		{"styfmunt", "styfmunt"},
		{"styfrar", "styfr"},
		{"styfsinte", "styfsint"},
		{"styfva", "styfv"},
		{"styfvern", "styfv"},
		{"stygg", "stygg"},
		{"stygga", "stygg"},
		{"stygge", "stygg"},
		{"styggelse", "stygg"},
		{"styggt", "stygg"},
		{"stygn", "stygn"},
		{"stympa", "stymp"},
		{"stympad", "stymp"},
		{"stympare", "stymp"},
		{"styng", "styng"},
		{"styr", "styr"},
		{"styra", "styr"},
		{"styrande", "styr"},
		{"styrde", "styrd"},
		{"styre", "styr"},
		{"styrelsen", "styr"},
		{"styret", "styret"},
		{"styrka", "styrk"},
		{"styrkande", "styrk"},
		{"styrker", "styrk"},
		{"styrketår", "styrketår"},
		{"styrkt", "styrk"},
		{"styrkte", "styrk"},
		{"styrktes", "styrk"},
		{"styrman", "styrman"},
		{"styrmans", "styrman"},
		{"styrrummet", "styrrummet"},
		{"styrstång", "styrstång"},
		{"styrstången", "styrstång"},
		{"styrt", "styrt"},
		{"styv", "styv"},
		{"styva", "styv"},
		{"styvbarn", "styvbarn"},
		{"styvdotter", "styvdot"},
		{"styvdottern", "styvdot"},
		{"styver", "styv"},
		{"styverhandeln", "styverhandeln"},
		{"styvfader", "styvfad"},
		{"styvfadern", "styvfad"},
		{"styvfar", "styvf"},
		{"styvmodern", "styvmod"},
		{"styvmor", "styvm"},
		{"styvmorsblom", "styvmorsblom"},
		{"styvna", "styvn"},
		{"styvnade", "styvn"},
		{"styvrarna", "styvr"},
		{"styvson", "styvson"},
		{"styx", "styx"},
		{"stä", "stä"},
		{"stäckta", "stäck"},
		{"städ", "städ"},
		{"städa", "städ"},
		{"städad", "städ"},
		{"städade", "städ"},
		{"städadt", "städad"},
		{"städar", "städ"},
		{"städat", "städ"},
		{"städer", "städ"},
		{"städerna", "städ"},
		{"städes", "städ"},
		{"städja", "städj"},
		{"städning", "städning"},
		{"städningen", "städning"},
		{"städs", "städ"},
		{"städse", "städs"},
		{"stälde", "stäld"},
		{"ställ", "ställ"},
		{"ställa", "ställ"},
		{"ställd", "ställd"},
		{"ställda", "ställd"},
		{"ställde", "ställd"},
		{"ställe", "ställ"},
		{"ställen", "ställ"},
		{"ställer", "ställ"},
		{"stället", "stället"},
		{"ställning", "ställning"},
		{"ställningar", "ställning"},
		{"ställningen", "ställning"},
		{"ställt", "ställt"},
		{"stält", "stält"},
		{"stäm", "stäm"},
		{"stämd", "stämd"},
		{"stämde", "stämd"},
		{"stämma", "stämm"},
		{"stämmas", "stämm"},
		{"stämmer", "stämm"},
		{"stämmor", "stämm"},
		{"stämmornas", "stämm"},
		{"stämning", "stämning"},
		{"stämningen", "stämning"},
		{"stämpla", "stämpl"},
		{"stämplad", "stämpl"},
		{"stämplade", "stämpl"},
		{"stämplades", "stämpl"},
		{"stämt", "stämt"},
		{"stän", "stän"},
		{"ständig", "ständ"},
		{"ständiga", "ständ"},
		{"ständigt", "ständ"},
		{"stäng", "stäng"},
		{"stänga", "stäng"},
		{"stängas", "stäng"},
		{"stängd", "stäng"},
		{"stängda", "stäng"},
		{"stängde", "stäng"},
		{"stängdes", "stäng"},
		{"stängel", "stängel"},
		{"stänger", "stäng"},
		{"stänglar", "stängl"},
		{"stängsel", "stängsel"},
		{"stängseltagg", "stängseltagg"},
		{"stängt", "stäng"},
		{"stänk", "stänk"},
		{"stänker", "stänk"},
		{"stänkt", "stänk"},
		{"stänkte", "stänk"},
		{"stärkande", "stärk"},
		{"stärkkragen", "stärkkrag"},
		{"stärkt", "stärk"},
		{"stärkta", "stärk"},
		{"stå", "stå"},
		{"stående", "ståend"},
		{"stål", "stål"},
		{"stålklang", "stålklang"},
		{"stålvisp", "stålvisp"},
		{"stålvispen", "stålvisp"},
		{"stån", "stån"},
		{"stånd", "stånd"},
		{"ståndaktiga", "ståndakt"},
		{"ståndaktighet", "ståndakt"},
		{"ståndar", "stånd"},
		{"stånden", "stånd"},
		{"ståndet", "ståndet"},
		{"ståndpunkt", "ståndpunk"},
		{"ståndpunkter", "ståndpunk"},
		{"stånds", "stånd"},
		{"stång", "stång"},
		{"stångas", "stång"},
		{"stången", "stång"},
		{"stånkande", "stånk"},
		{"står", "står"},
		{"stårkkrage", "stårkkrag"},
		{"stås", "stås"},
		{"ståt", "ståt"},
		{"ståtar", "ståt"},
		{"ståten", "ståt"},
		{"ståtlig", "ståt"},
		{"ståtliga", "ståt"},
		{"ståtligt", "ståt"},
		{"stått", "stått"},
		{"stöd", "stöd"},
		{"stödd", "stödd"},
		{"stödda", "stödd"},
		{"stödde", "stödd"},
		{"stödet", "stödet"},
		{"stödja", "stödj"},
		{"stödjande", "stödj"},
		{"stödjas", "stödj"},
		{"stödt", "stödt"},
		{"stöflar", "stöfl"},
		{"stöflarne", "stöfl"},
		{"stöka", "stök"},
		{"stökade", "stök"},
		{"stöket", "stöket"},
		{"stöld", "stöld"},
		{"stöna", "stön"},
		{"stönade", "stön"},
		{"stönande", "stön"},
		{"stöper", "stöp"},
		{"stör", "stör"},
		{"störa", "stör"},
		{"störande", "stör"},
		{"störas", "stör"},
		{"störd", "störd"},
		{"störda", "störd"},
		{"störde", "störd"},
		{"stördes", "störd"},
		{"störes", "stör"},
		{"större", "störr"},
		{"störsh", "störsh"},
		{"största", "störst"},
		{"stört", "stört"},
		{"störta", "stört"},
		{"störtade", "stört"},
		{"störtat", "stört"},
		{"störtsjö", "störtsjö"},
		{"störtsjöarne", "störtsjö"},
		{"störtskurar", "störtskur"},
		{"stöt", "stöt"},
		{"stöta", "stöt"},
		{"stötande", "stöt"},
		{"stötar", "stöt"},
		{"stöten", "stöt"},
		{"stöter", "stöt"},
		{"stött", "stött"},
		{"stötta", "stött"},
		{"stötte", "stött"},
		{"stöttes", "stött"},
		{"stötvir", "stötvir"},
		{"stötvis", "stötvis"},
		{"stövare", "stöv"},
		{"stövla", "stövl"},
		{"stövlar", "stövl"},
		{"stövlarna", "stövl"},
		{"sub", "sub"},
		{"subtila", "subtil"},
		{"suc", "suc"},
		{"suck", "suck"},
		{"sucka", "suck"},
		{"suckadc", "suckadc"},
		{"suckade", "suck"},
		{"suckande", "suck"},
		{"suckar", "suck"},
		{"suckarna", "suck"},
		{"suckat", "suck"},
		{"sudda", "sudd"},
		{"suddande", "sudd"},
		{"suddar", "sudd"},
		{"suddats", "suddat"},
		{"suddiga", "sudd"},
		{"sudlade", "sudl"},
		{"sudlades", "sudl"},
		{"sudlats", "sudlat"},
		{"sufflör", "sufflör"},
		{"suga", "sug"},
		{"sugande", "sug"},
		{"sugen", "sug"},
		{"suger", "sug"},
		{"suggskaft", "suggskaft"},
		{"suit", "suit"},
		{"sujetter", "sujet"},
		{"sukade", "suk"},
		{"sulor", "sul"},
		{"sum", "sum"},
		{"summa", "summ"},
		{"summan", "summan"},
		{"summo", "summo"},
		{"sund", "sund"},
		{"sunda", "sund"},
		{"sunden", "sund"},
		{"sundt", "sund"},
		{"sunnansuckar", "sunnansuck"},
		{"sunnanvinden", "sunnanvind"},
		{"sunt", "sunt"},
		{"suntältet", "suntältet"},
		{"supa", "sup"},
		{"suparna", "sup"},
		{"supe", "sup"},
		{"supeen", "supe"},
		{"supeer", "supe"},
		{"supen", "sup"},
		{"supera", "super"},
		{"supige", "sup"},
		{"supit", "supit"},
		{"suput", "suput"},
		{"sur", "sur"},
		{"sura", "sur"},
		{"sure", "sur"},
		{"surmulen", "surmul"},
		{"surrade", "surr"},
		{"surrande", "surr"},
		{"surrar", "surr"},
		{"surrat", "surr"},
		{"surt", "surt"},
		{"sus", "sus"},
		{"susa", "sus"},
		{"susade", "sus"},
		{"susande", "sus"},
		{"susar", "sus"},
		{"suset", "suset"},
		{"sutinera", "sutiner"},
		{"sutte", "sutt"},
		{"suttit", "suttit"},
		{"sutto", "sutto"},
		{"svada", "svad"},
		{"svag", "svag"},
		{"svaga", "svag"},
		{"svagare", "svag"},
		{"svagas", "svag"},
		{"svagaste", "svag"},
		{"svage", "svag"},
		{"svaghet", "svag"},
		{"svagheten", "svag"},
		{"svagheter", "svag"},
		{"svaghetstillstånd", "svaghetstillstånd"},
		{"svagsint", "svagsint"},
		{"svagsinte", "svagsint"},
		{"svagt", "svagt"},
		{"svajar", "svaj"},
		{"sval", "sval"},
		{"svala", "sval"},
		{"svalan", "svalan"},
		{"svalare", "sval"},
		{"svalde", "svald"},
		{"svalen", "sval"},
		{"svalg", "svalg"},
		{"svalget", "svalget"},
		{"svalka", "svalk"},
		{"svalkad", "svalk"},
		{"svalkade", "svalk"},
		{"svalkan", "svalkan"},
		{"svalkar", "svalk"},
		{"svalkas", "svalk"},
		{"svall", "svall"},
		{"svalla", "svall"},
		{"svallade", "svall"},
		{"svallande", "svall"},
		{"svallvågorna", "svallvåg"},
		{"svalna", "svaln"},
		{"svalnande", "svaln"},
		{"svalnar", "svaln"},
		{"svalor", "sval"},
		{"svalorna", "sval"},
		{"svalornas", "sval"},
		{"svalpar", "svalp"},
		{"svalt", "svalt"},
		{"svamp", "svamp"},
		{"svampar", "svamp"},
		{"svampen", "svamp"},
		{"svampiga", "svamp"},
		{"svan", "svan"},
		{"svanar", "svan"},
		{"svandun", "svandun"},
		{"svanen", "svan"},
		{"svanger", "svang"},
		{"svanklang", "svanklang"},
		{"svann", "svann"},
		{"svans", "svan"},
		{"svansar", "svans"},
		{"svansarna", "svans"},
		{"svansen", "svans"},
		{"svanslik", "svanslik"},
		{"svar", "svar"},
		{"svara", "svar"},
		{"svarade", "svar"},
		{"svarar", "svar"},
		{"svararle", "svararl"},
		{"svarat", "svar"},
		{"svarata", "svarat"},
		{"svaren", "svar"},
		{"svaret", "svaret"},
		{"svarh", "svarh"},
		{"svarl", "svarl"},
		{"svars", "svar"},
		{"svarslös", "svarslös"},
		{"svart", "svart"},
		{"svarta", "svart"},
		{"svartare", "svart"},
		{"svartaste", "svart"},
		{"svartens", "svart"},
		{"svartglänsande", "svartgläns"},
		{"svartgrå", "svartgrå"},
		{"svartgråa", "svartgrå"},
		{"svartgröna", "svartgrön"},
		{"svarthårig", "svarthår"},
		{"svartklädd", "svartkläd"},
		{"svartklädda", "svartkläd"},
		{"svartkritsförstoring", "svartkritsförstoring"},
		{"svartmältat", "svartmält"},
		{"svartmålade", "svartmål"},
		{"svartnad", "svartn"},
		{"svartnat", "svartn"},
		{"svartrock", "svartrock"},
		{"svartrökt", "svartrök"},
		{"svartsjuk", "svartsjuk"},
		{"svartsjuka", "svartsjuk"},
		{"svartsjukan", "svartsjukan"},
		{"svartsjuke", "svartsjuk"},
		{"svartsjö", "svartsjö"},
		{"svarv", "svarv"},
		{"svarvade", "svarv"},
		{"svarvstol", "svarvstol"},
		{"svassande", "svass"},
		{"svcn", "svcn"},
		{"svcrige", "svcrig"},
		{"svea", "svea"},
		{"sved", "sved"},
		{"sveda", "sved"},
		{"svedan", "svedan"},
		{"svedd", "svedd"},
		{"svedda", "svedd"},
		{"sveddes", "svedd"},
		{"svedo", "svedo"},
		{"svek", "svek"},
		{"sveko", "sveko"},
		{"sveks", "svek"},
		{"sven", "sven"},
		{"svennen", "svenn"},
		{"svens", "sven"},
		{"svensk", "svensk"},
		{"svenska", "svensk"},
		{"svenskar", "svensk"},
		{"svenskarna", "svensk"},
		{"svenskt", "svensk"},
		{"svepa", "svep"},
		{"svepande", "svep"},
		{"svepning", "svepning"},
		{"svept", "svept"},
		{"svepte", "svept"},
		{"sverige", "sver"},
		{"sveriges", "sver"},
		{"svett", "svett"},
		{"svettas", "svett"},
		{"svettats", "svettat"},
		{"svettdunster", "svettdunst"},
		{"svetten", "svett"},
		{"svida", "svid"},
		{"svidande", "svid"},
		{"svider", "svid"},
		{"svigta", "svigt"},
		{"svigtande", "svigt"},
		{"svika", "svik"},
		{"sviken", "svik"},
		{"sviker", "svik"},
		{"svikit", "svikit"},
		{"svikt", "svikt"},
		{"sviktande", "svikt"},
		{"svimma", "svimm"},
		{"svimmat", "svimm"},
		{"svimningsanfall", "svimningsanfall"},
		{"svinaktiga", "svinakt"},
		{"svindel", "svindel"},
		{"svindlade", "svindl"},
		{"svindlande", "svindl"},
		{"sving", "sving"},
		{"svinga", "sving"},
		{"svingade", "sving"},
		{"svinna", "svinn"},
		{"svinner", "svinn"},
		{"sviskon", "sviskon"},
		{"svit", "svit"},
		{"svor", "svor"},
		{"svullen", "svull"},
		{"svullna", "svulln"},
		{"svullnade", "svulln"},
		{"svulst", "svulst"},
		{"svultit", "svultit"},
		{"svunna", "svunn"},
		{"svunnit", "svunnit"},
		{"svunno", "svunno"},
		{"svuro", "svuro"},
		{"svä", "svä"},
		{"sväfvade", "sväfv"},
		{"svägerska", "svägersk"},
		{"svägerskan", "svägerskan"},
		{"svägerskas", "svägersk"},
		{"svälde", "sväld"},
		{"svälja", "svälj"},
		{"sväljde", "sväljd"},
		{"svälla", "sväll"},
		{"svällamde", "svällamd"},
		{"svällande", "sväll"},
		{"svällaren", "sväll"},
		{"svälld", "svälld"},
		{"svällda", "svälld"},
		{"svällde", "svälld"},
		{"sväller", "sväll"},
		{"svält", "svält"},
		{"svälta", "svält"},
		{"sväng", "sväng"},
		{"svänga", "sväng"},
		{"svängandc", "svängandc"},
		{"svängande", "sväng"},
		{"svängd", "sväng"},
		{"svängda", "sväng"},
		{"svängde", "sväng"},
		{"svängeln", "svängeln"},
		{"svänger", "sväng"},
		{"svängningar", "svängning"},
		{"svängningstiderna", "svängningstid"},
		{"svängt", "sväng"},
		{"svär", "svär"},
		{"svära", "svär"},
		{"svärd", "svärd"},
		{"svärden", "svärd"},
		{"svärdet", "svärdet"},
		{"svärdotter", "svärdot"},
		{"svärdsliljan", "svärdsliljan"},
		{"svärfär", "svärfär"},
		{"svärligt", "svär"},
		{"svärm", "svärm"},
		{"svärma", "svärm"},
		{"svärmade", "svärm"},
		{"svärmande", "svärm"},
		{"svärmar", "svärm"},
		{"svärmat", "svärm"},
		{"svärmeri", "svärmeri"},
		{"svärmisk", "svärmisk"},
		{"svärmiskt", "svärmisk"},
		{"svärmoder", "svärmod"},
		{"svärmor", "svärm"},
		{"svärmors", "svärmor"},
		{"svärntiskt", "svärntisk"},
		{"svärson", "svärson"},
		{"svärta", "svärt"},
		{"svärtad", "svärt"},
		{"svärtat", "svärt"},
		{"sväva", "sväv"},
		{"svävade", "sväv"},
		{"svävande", "sväv"},
		{"svävar", "sväv"},
		{"svävat", "sväv"},
		{"svåger", "svåg"},
		{"svågern", "svåg"},
		{"svågerskap", "svågerskap"},
		{"svångde", "svång"},
		{"svångrem", "svångrem"},
		{"svångremmen", "svångremm"},
		{"svår", "svår"},
		{"svåra", "svår"},
		{"svårare", "svår"},
		{"svårast", "svår"},
		{"svårhanterligt", "svårhanter"},
		{"svårighet", "svår"},
		{"svårigheten", "svår"},
		{"svårigheter", "svår"},
		{"svårigheterna", "svår"},
		{"svårligen", "svår"},
		{"svårmod", "svårmod"},
		{"svårmodig", "svårmod"},
		{"svårt", "svårt"},
		{"sy", "sy"},
		{"sybord", "sybord"},
		{"sybågar", "sybåg"},
		{"sybågen", "sybåg"},
		{"sydamerika", "sydamerik"},
		{"sydde", "sydd"},
		{"sydhavspalm", "sydhavspalm"},
		{"syfilidologi", "syfilidologi"},
		{"syforening", "syforening"},
		{"syforeningens", "syforening"},
		{"syftar", "syft"},
		{"syfte", "syft"},
		{"syförening", "syförening"},
		{"sykorg", "sykorg"},
		{"sykorgen", "sykorg"},
		{"sylf", "sylf"},
		{"sylfers", "sylfer"},
		{"sylt", "sylt"},
		{"syltburkar", "syltburk"},
		{"syltburks", "syltburk"},
		{"sylvia", "sylvi"},
		{"symaskinen", "symaskin"},
		{"symaskinerna", "symaskin"},
		{"symbol", "symbol"},
		{"symbolen", "symbol"},
		{"symboliska", "symbolisk"},
		{"symfoni", "symfoni"},
		{"symmetriska", "symmetrisk"},
		{"sympati", "sympati"},
		{"sympatien", "sympati"},
		{"sympatier", "sympati"},
		{"sympatiserande", "sympatiser"},
		{"sympatisk", "sympatisk"},
		{"sympatiske", "sympatisk"},
		{"symptom", "symptom"},
		{"symtom", "symtom"},
		{"syn", "syn"},
		{"syna", "syn"},
		{"synade", "syn"},
		{"synagogan", "synagogan"},
		{"synas", "syn"},
		{"synbar", "synb"},
		{"synbara", "synbar"},
		{"synbarligen", "synbar"},
		{"synbart", "synbart"},
		{"synd", "synd"},
		{"synda", "synd"},
		{"syndabikt", "syndabik"},
		{"syndade", "synd"},
		{"syndaflod", "syndaflod"},
		{"syndare", "synd"},
		{"syndat", "synd"},
		{"syndedag", "syndedag"},
		{"synden", "synd"},
		{"syndens", "synd"},
		{"synder", "synd"},
		{"syndfulla", "syndfull"},
		{"syndig", "synd"},
		{"syndiga", "synd"},
		{"syndigt", "synd"},
		{"synen", "syn"},
		{"syner", "syn"},
		{"synes", "syn"},
		{"synförmåga", "synförmåg"},
		{"synglas", "syngl"},
		{"synlig", "syn"},
		{"synliga", "syn"},
		{"synmamsellen", "synmamsell"},
		{"synnerhet", "synner"},
		{"synnerliga", "synner"},
		{"synnerligast", "synner"},
		{"synnerligen", "synner"},
		{"synnerligt", "synner"},
		{"synpunkt", "synpunk"},
		{"synpunkten", "synpunk"},
		{"synpunkter", "synpunk"},
		{"syns", "syn"},
		{"synslös", "synslös"},
		{"syntes", "synt"},
		{"syntetiskt", "syntetisk"},
		{"synts", "synt"},
		{"synvilla", "synvill"},
		{"synvinkel", "synvinkel"},
		{"syperb", "syperb"},
		{"syperbt", "syperbt"},
		{"syr", "syr"},
		{"syra", "syr"},
		{"syraks", "syrak"},
		{"syrener", "syren"},
		{"syrenerna", "syren"},
		{"syrenhäck", "syrenhäck"},
		{"syrenträden", "syrenträd"},
		{"syrinx", "syrinx"},
		{"syrliga", "syr"},
		{"syrligt", "syr"},
		{"syrmerhet", "syrmer"},
		{"syrprisen", "syrpris"},
		{"syrpriser", "syrpris"},
		{"syrtut", "syrtut"},
		{"syrtuten", "syrtut"},
		{"sys", "sys"},
		{"sysaker", "sysak"},
		{"syskon", "syskon"},
		{"syskonen", "syskon"},
		{"syskonkärlek", "syskonkärlek"},
		{"syskonringen", "syskonring"},
		{"syskonsjäl", "syskonsjäl"},
		{"syskonskara", "syskonskar"},
		{"syskontycke", "syskontyck"},
		{"syskrin", "syskrin"},
		{"syssel", "syssel"},
		{"sysselsatt", "sysselsat"},
		{"sysselsatta", "sysselsat"},
		{"sysselsatte", "sysselsat"},
		{"sysselsätt", "sysselsät"},
		{"sysselsätta", "sysselsät"},
		{"sysselsätter", "sysselsät"},
		{"sysselsättning", "sysselsättning"},
		{"sysselsättningar", "sysselsättning"},
		{"syssla", "syssl"},
		{"sysslade", "syssl"},
		{"sysslar", "syssl"},
		{"sysslat", "syssl"},
		{"syssling", "syssling"},
		{"sysslo", "sysslo"},
		{"sysslolös", "sysslolös"},
		{"sysslolöshet", "sysslolös"},
		{"sysslolöst", "sysslolös"},
		{"sysslor", "syssl"},
		{"systemet", "systemet"},
		{"syster", "syst"},
		{"systerdotter", "systerdot"},
		{"systerhovmästarinnan", "systerhovmästarinnan"},
		{"systerliga", "syster"},
		{"systern", "syst"},
		{"systerns", "syst"},
		{"systers", "syster"},
		{"systerson", "systerson"},
		{"systrar", "systr"},
		{"systrarna", "systr"},
		{"sytt", "sytt"},
		{"sä", "sä"},
		{"säck", "säck"},
		{"säd", "säd"},
		{"säden", "säd"},
		{"sädesfält", "sädesfält"},
		{"säea", "säea"},
		{"säg", "säg"},
		{"säga", "säg"},
		{"sägandes", "säg"},
		{"sägas", "säg"},
		{"sägen", "säg"},
		{"säger", "säg"},
		{"sägerl", "sägerl"},
		{"säges", "säg"},
		{"sägnerna", "sägn"},
		{"sägs", "säg"},
		{"säkcr", "säkcr"},
		{"säker", "säk"},
		{"säkerhet", "säker"},
		{"säkerhets", "säkerhet"},
		{"säkerligen", "säker"},
		{"säkert", "säkert"},
		{"säkra", "säkr"},
		{"säkrare", "säkr"},
		{"säkrast", "säkr"},
		{"säkraste", "säkr"},
		{"sälar", "säl"},
		{"sälarna", "säl"},
		{"sälarne", "säl"},
		{"sälen", "säl"},
		{"sälhund", "sälhund"},
		{"sälhunden", "sälhund"},
		{"sälja", "sälj"},
		{"säljagt", "säljag"},
		{"säljagten", "säljag"},
		{"säljer", "sälj"},
		{"säljerskans", "säljerskan"},
		{"säll", "säll"},
		{"sälla", "säll"},
		{"sällan", "sällan"},
		{"sällar", "säll"},
		{"sällhet", "säll"},
		{"sällheten", "säll"},
		{"sällhets", "sällhet"},
		{"sällhetsdagar", "sällhetsdag"},
		{"sällsam", "sällsam"},
		{"sällsamma", "sällsamm"},
		{"sällsamt", "sällsamt"},
		{"sällskap", "sällskap"},
		{"sällskapandet", "sällskap"},
		{"sällskapet", "sällskapet"},
		{"sällskapets", "sällskapet"},
		{"sällskapsbroder", "sällskapsbrod"},
		{"sällskapsbröder", "sällskapsbröd"},
		{"sällskapsgåfvor", "sällskapsgåfv"},
		{"sällskapskrets", "sällskapskret"},
		{"sällskapslifvets", "sällskapslifvet"},
		{"sällskapslivet", "sällskapslivet"},
		{"sällskapslivets", "sällskapslivet"},
		{"sällskapsmannen", "sällskapsman"},
		{"sällskapsnöje", "sällskapsnöj"},
		{"sällskapsnöjet", "sällskapsnöjet"},
		{"sällsynt", "sällsynt"},
		{"sällsynta", "sällsynt"},
		{"sällsyntare", "sällsynt"},
		{"sällsyntheter", "sällsynt"},
		{"sälsand", "sälsand"},
		{"sälskinn", "sälskin"},
		{"sälskinns", "sälskin"},
		{"sälskins", "sälskin"},
		{"sälskinsmössa", "sälskinsmöss"},
		{"sälskytt", "sälskyt"},
		{"sälskyttarne", "sälskyt"},
		{"sälskyttarnes", "sälskyttarn"},
		{"sälskytten", "sälskyt"},
		{"sälskytteri", "sälskytteri"},
		{"sälskytteriet", "sälskytteriet"},
		{"sälta", "sält"},
		{"sämre", "sämr"},
		{"sämsta", "sämst"},
		{"sänd", "sänd"},
		{"sända", "sänd"},
		{"sände", "sänd"},
		{"sändebud", "sändebud"},
		{"sänder", "sänd"},
		{"sändes", "sänd"},
		{"säng", "säng"},
		{"sängar", "säng"},
		{"sängarna", "säng"},
		{"sängarne", "säng"},
		{"sängbottnar", "sängbottn"},
		{"sängen", "säng"},
		{"sängens", "säng"},
		{"sänggaflarne", "sänggafl"},
		{"sänghalm", "sänghalm"},
		{"sänghimlen", "sänghiml"},
		{"sänghirnlen", "sänghirnl"},
		{"sängkammardörren", "sängkammardörr"},
		{"sängkammare", "sängkamm"},
		{"sängkammaren", "sängkamm"},
		{"sängkammarlif", "sängkammarlif"},
		{"sängkant", "sängkant"},
		{"sängkanten", "sängkant"},
		{"sängkläder", "sängkläd"},
		{"sängkläderna", "sängkläd"},
		{"sängknapp", "sängknapp"},
		{"sängknapparne", "sängknapp"},
		{"sängknappen", "sängknapp"},
		{"sängliggande", "sängligg"},
		{"sängomhänget", "sängomhänget"},
		{"sängs", "säng"},
		{"sängstolpar", "sängstolp"},
		{"sängtäcket", "sängtäcket"},
		{"sänka", "sänk"},
		{"sänker", "sänk"},
		{"sänkes", "sänk"},
		{"sänkt", "sänk"},
		{"sänkta", "sänk"},
		{"sänktc", "sänktc"},
		{"sänkte", "sänk"},
		{"sänktes", "sänk"},
		{"sänt", "sänt"},
		{"särdeles", "särdel"},
		{"säregen", "säreg"},
		{"särskihl", "särskihl"},
		{"särskil", "särskil"},
		{"särskild", "särskild"},
		{"särskilda", "särskild"},
		{"särskildt", "särskild"},
		{"särskilja", "särskilj"},
		{"särskilt", "särskilt"},
		{"särskilta", "särskilt"},
		{"sätherberg", "sätherberg"},
		{"sätt", "sätt"},
		{"sätta", "sätt"},
		{"sättande", "sätt"},
		{"sättas", "sätt"},
		{"sätte", "sätt"},
		{"sätter", "sätt"},
		{"sättet", "sättet"},
		{"sävliga", "säv"},
		{"sävligheten", "säv"},
		{"så", "så"},
		{"sådan", "sådan"},
		{"sådana", "sådan"},
		{"sådant", "sådant"},
		{"sådarnt", "sådarnt"},
		{"sådd", "sådd"},
		{"sådde", "sådd"},
		{"såg", "såg"},
		{"sågar", "såg"},
		{"såge", "såg"},
		{"sågo", "sågo"},
		{"sågos", "sågo"},
		{"sågs", "såg"},
		{"sågspån", "sågspån"},
		{"såld", "såld"},
		{"sålde", "såld"},
		{"således", "såled"},
		{"sålt", "sålt"},
		{"sålts", "sålt"},
		{"sålunda", "sålund"},
		{"sålurlda", "sålurld"},
		{"sång", "sång"},
		{"sångare", "sång"},
		{"sångaren", "sång"},
		{"sångarkor", "sångark"},
		{"sångarkrans", "sångarkran"},
		{"sångbok", "sångbok"},
		{"sångböcker", "sångböck"},
		{"sången", "sång"},
		{"sångens", "sång"},
		{"sånger", "sång"},
		{"sångerna", "sång"},
		{"sångerska", "sångersk"},
		{"sångfar", "sångf"},
		{"sångfågel", "sångfågel"},
		{"sångfågeln", "sångfågeln"},
		{"sångfåglarna", "sångfågl"},
		{"sångmö", "sångmö"},
		{"såpbubbla", "såpbubbl"},
		{"såpbubblekarlarna", "såpbubblekarl"},
		{"sår", "sår"},
		{"såra", "sår"},
		{"sårad", "sår"},
		{"sårade", "sår"},
		{"sårar", "sår"},
		{"sårat", "sår"},
		{"sårbar", "sårb"},
		{"såren", "sår"},
		{"såret", "såret"},
		{"sårtid", "sårtid"},
		{"såser", "sås"},
		{"såsom", "såsom"},
		{"såta", "såt"},
		{"sått", "sått"},
		{"såvida", "såvid"},
		{"såvitt", "såvit"},
		{"såväl", "såväl"},
		{"söckendagar", "söckendag"},
		{"söder", "söd"},
		{"söderberg", "söderberg"},
		{"södern", "söd"},
		{"söderut", "söderut"},
		{"södra", "södr"},
		{"sög", "sög"},
		{"sögo", "sögo"},
		{"sök", "sök"},
		{"söka", "sök"},
		{"sökande", "sök"},
		{"sökandet", "sök"},
		{"sökas", "sök"},
		{"söken", "sök"},
		{"söker", "sök"},
		{"sökt", "sökt"},
		{"sökta", "sökt"},
		{"sökte", "sökt"},
		{"söla", "söl"},
		{"söm", "söm"},
		{"sömlinghågna", "sömlinghågn"},
		{"sömmarna", "sömm"},
		{"sömmen", "sömm"},
		{"sömmerska", "sömmersk"},
		{"sömn", "sömn"},
		{"sömnad", "sömn"},
		{"sömndrucken", "sömndruck"},
		{"sömnen", "sömn"},
		{"sömnens", "sömn"},
		{"sömngivande", "sömngiv"},
		{"sömngångerska", "sömngångersk"},
		{"sömngångerskas", "sömngångersk"},
		{"sömnig", "sömn"},
		{"sömnigt", "sömn"},
		{"sömnlös", "sömnlös"},
		{"sömnlösa", "sömnlös"},
		{"sömnlöses", "sömnlös"},
		{"sön", "sön"},
		{"sönda", "sönd"},
		{"söndag", "söndag"},
		{"söndagar", "söndag"},
		{"söndagarna", "söndag"},
		{"söndagen", "söndag"},
		{"söndagens", "söndag"},
		{"söndags", "söndag"},
		{"söndagsförmiddag", "söndagsförmiddag"},
		{"söndagsförmiddagen", "söndagsförmiddag"},
		{"söndagskväll", "söndagskväll"},
		{"söndagsmiddagen", "söndagsmiddag"},
		{"söndagsmorgon", "söndagsmorgon"},
		{"söndagsmorgonen", "söndagsmorgon"},
		{"söndagsmorgonens", "söndagsmorgon"},
		{"söndagspredikningar", "söndagspredikning"},
		{"sönder", "sönd"},
		{"sönderbrutna", "sönderbrutn"},
		{"sönderbråka", "sönderbråk"},
		{"sönderbrötos", "sönderbröto"},
		{"sönderklämde", "sönderklämd"},
		{"sönderplockad", "sönderplock"},
		{"sönderrivna", "sönderrivn"},
		{"sönderskuren", "sönderskur"},
		{"sönderslagen", "sönderslag"},
		{"sönderslaget", "sönderslaget"},
		{"söndersleto", "söndersleto"},
		{"sönderslitande", "sönderslit"},
		{"sönderslites", "sönderslit"},
		{"söndertryckte", "söndertryck"},
		{"söndriga", "söndr"},
		{"söner", "sön"},
		{"söp", "söp"},
		{"sörj", "sörj"},
		{"sörja", "sörj"},
		{"sörjande", "sörj"},
		{"sörjd", "sörjd"},
		{"sörjde", "sörjd"},
		{"sörjekläder", "sörjekläd"},
		{"sörjen", "sörj"},
		{"sörjer", "sörj"},
		{"sörjt", "sörjt"},
		{"sörmland", "sörmland"},
		{"sörmlandsgodset", "sörmlandsgodset"},
		{"sörplar", "sörpl"},
		{"söt", "söt"},
		{"söta", "söt"},
		{"sötaktig", "sötakt"},
		{"sötaste", "söt"},
		{"söte", "söt"},
		{"sötma", "sötm"},
		{"sötnos", "sötno"},
		{"sötsaker", "sötsak"},
		{"sötsurt", "sötsurt"},
		{"sött", "sött"},
		{"sövde", "sövd"},
		{"sövdes", "sövd"},
		{"t", "t"},
		{"ta", "ta"},
		{"tableau", "tableau"},
		{"tablå", "tablå"},
		{"tablån", "tablån"},
		{"taburett", "taburet"},
		{"tack", "tack"},
		{"tacka", "tack"},
		{"tackad", "tack"},
		{"tackade", "tack"},
		{"tackar", "tack"},
		{"tackars", "tackar"},
		{"tackat", "tack"},
		{"tackel", "tackel"},
		{"tackladt", "tacklad"},
		{"tacklaget", "tacklaget"},
		{"tackling", "tackling"},
		{"tacklös", "tacklös"},
		{"tacksam", "tacksam"},
		{"tacksamhen", "tacksamh"},
		{"tacksamhet", "tacksam"},
		{"tacksamheten", "tacksam"},
		{"tacksamhetsförbindelse", "tacksamhetsförbind"},
		{"tacksamma", "tacksamm"},
		{"tacksammaste", "tacksamm"},
		{"tacksamme", "tacksamm"},
		{"tacksamt", "tacksamt"},
		{"tacksägelse", "tacksäg"},
		{"tacksägelser", "tacksäg"},
		{"tad", "tad"},
		{"tade", "tad"},
		{"tadel", "tadel"},
		{"tadelfritt", "tadelfrit"},
		{"tadlade", "tadl"},
		{"tadlar", "tadl"},
		{"tafatt", "tafat"},
		{"tafatta", "tafat"},
		{"tafatte", "tafat"},
		{"tafattheten", "tafat"},
		{"tafla", "tafl"},
		{"taflan", "taflan"},
		{"taflor", "tafl"},
		{"tafvelsamlingen", "tafvelsamling"},
		{"tag", "tag"},
		{"taga", "tag"},
		{"tagas", "tag"},
		{"tage", "tag"},
		{"tagel", "tagel"},
		{"tageldynor", "tageldyn"},
		{"tagen", "tag"},
		{"tager", "tag"},
		{"tages", "tag"},
		{"taget", "taget"},
		{"tagg", "tagg"},
		{"taggar", "tagg"},
		{"tagit", "tagit"},
		{"tagits", "tagit"},
		{"taglet", "taglet"},
		{"tagna", "tagn"},
		{"tags", "tag"},
		{"tak", "tak"},
		{"takdroppet", "takdroppet"},
		{"taken", "tak"},
		{"taket", "taket"},
		{"takets", "taket"},
		{"takfönstret", "takfönstret"},
		{"taklampan", "taklampan"},
		{"takränna", "takrän"},
		{"takrännan", "takrännan"},
		{"takrännoma", "takrännom"},
		{"takstolar", "takstol"},
		{"takt", "takt"},
		{"takten", "takt"},
		{"taktpinnen", "taktpin"},
		{"takåsen", "takås"},
		{"tal", "tal"},
		{"tala", "tal"},
		{"talade", "tal"},
		{"talades", "tal"},
		{"taladt", "talad"},
		{"talande", "tal"},
		{"talang", "talang"},
		{"talanger", "talang"},
		{"talar", "tal"},
		{"talare", "tal"},
		{"talas", "tal"},
		{"talat", "tal"},
		{"talen", "tal"},
		{"talesätt", "talesät"},
		{"talet", "talet"},
		{"talets", "talet"},
		{"talg", "talg"},
		{"talgiga", "talg"},
		{"taligt", "tal"},
		{"talis", "talis"},
		{"talisman", "talisman"},
		{"talismanen", "talisman"},
		{"tallar", "tall"},
		{"tallarna", "tall"},
		{"tallen", "tall"},
		{"tallrik", "tallrik"},
		{"tallrikar", "tallrik"},
		{"tallriken", "tallrik"},
		{"tallskog", "tallskog"},
		{"talmikärlek", "talmikärlek"},
		{"talorgan", "talorgan"},
		{"talrika", "talrik"},
		{"talriken", "talrik"},
		{"talrikhet", "talrik"},
		{"talt", "talt"},
		{"talte", "talt"},
		{"taltes", "talt"},
		{"tam", "tam"},
		{"tamburdörren", "tamburdörr"},
		{"tamburen", "tambur"},
		{"tamburens", "tambur"},
		{"tan", "tan"},
		{"tand", "tand"},
		{"tande", "tand"},
		{"tandlösa", "tandlös"},
		{"tandvärk", "tandvärk"},
		{"tangenterna", "tangent"},
		{"tanka", "tank"},
		{"tankar", "tank"},
		{"tankarna", "tank"},
		{"tankarne", "tank"},
		{"tanke", "tank"},
		{"tankeföljd", "tankeföljd"},
		{"tankegång", "tankegång"},
		{"tankekrets", "tankekret"},
		{"tanken", "tank"},
		{"tankeruset", "tankeruset"},
		{"tankeverksamhet", "tankeverksam"},
		{"tankfull", "tankfull"},
		{"tankfulla", "tankfull"},
		{"tankfullt", "tankfull"},
		{"tanklösa", "tanklös"},
		{"tanklöshet", "tanklös"},
		{"tanklöst", "tanklös"},
		{"tankspridd", "tanksprid"},
		{"tankspridt", "tanksprid"},
		{"tankspritt", "tanksprit"},
		{"tankte", "tank"},
		{"tant", "tant"},
		{"tants", "tant"},
		{"tapeten", "tapet"},
		{"tapeter", "tapet"},
		{"tapetstycken", "tapetstyck"},
		{"tappa", "tapp"},
		{"tappade", "tapp"},
		{"tappadt", "tappad"},
		{"tappar", "tapp"},
		{"tappat", "tapp"},
		{"tapper", "tapp"},
		{"tappert", "tappert"},
		{"tappra", "tappr"},
		{"tapprare", "tappr"},
		{"tar", "tar"},
		{"tarar", "tar"},
		{"tarfliga", "tarf"},
		{"tarflighet", "tarf"},
		{"tarfyllda", "tarfylld"},
		{"tarkar", "tark"},
		{"tarm", "tarm"},
		{"tarvar", "tarv"},
		{"tarvlig", "tarv"},
		{"tarvliga", "tarv"},
		{"tarvligare", "tarv"},
		{"tarvligaste", "tarv"},
		{"tarvligt", "tarv"},
		{"tas", "tas"},
		{"tass", "tass"},
		{"tassa", "tass"},
		{"tassade", "tass"},
		{"tassande", "tass"},
		{"tassandet", "tass"},
		{"tassar", "tass"},
		{"tassarna", "tass"},
		{"tassla", "tassl"},
		{"tatt", "tatt"},
		{"taverna", "tav"},
		{"tavernens", "tavern"},
		{"tavla", "tavl"},
		{"tavlan", "tavlan"},
		{"tavlor", "tavl"},
		{"tavlorna", "tavl"},
		{"taxameter", "taxamet"},
		{"taxerades", "taxer"},
		{"te", "te"},
		{"teater", "teat"},
		{"teaterbiljetter", "teaterbiljet"},
		{"teaterkvällen", "teaterkväll"},
		{"teatern", "teat"},
		{"teaterns", "teat"},
		{"teaterpjes", "teaterpj"},
		{"teaterpjäs", "teaterpjäs"},
		{"teaterpjäser", "teaterpjäs"},
		{"teatersalong", "teatersalong"},
		{"teatersalongen", "teatersalong"},
		{"teaterscenerna", "teaterscen"},
		{"teaterstycke", "teaterstyck"},
		{"teaterväsende", "teaterväsend"},
		{"teatrarnas", "teatr"},
		{"tebordet", "tebordet"},
		{"tecken", "teck"},
		{"teckna", "teckn"},
		{"tecknad", "teckn"},
		{"tecknade", "teckn"},
		{"tecknadt", "tecknad"},
		{"tecknar", "teckn"},
		{"tecknat", "teckn"},
		{"tecknen", "teckn"},
		{"tecknet", "tecknet"},
		{"teckning", "teckning"},
		{"teckningar", "teckning"},
		{"teckningen", "teckning"},
		{"tedde", "tedd"},
		{"teddybjörn", "teddybjörn"},
		{"teddybjörnen", "teddybjörn"},
		{"teet", "teet"},
		{"tefat", "tef"},
		{"tefatet", "tefatet"},
		{"teg", "teg"},
		{"tegat", "teg"},
		{"tegel", "tegel"},
		{"tegelrött", "tegelröt"},
		{"tegeltorn", "tegeltorn"},
		{"teglen", "tegl"},
		{"tegner", "tegn"},
		{"tego", "tego"},
		{"tekanistern", "tekanist"},
		{"tekopp", "tekopp"},
		{"tekoppar", "tekopp"},
		{"tekoppen", "tekopp"},
		{"tekök", "tekök"},
		{"telefon", "telefon"},
		{"telefonen", "telefon"},
		{"telefonera", "telefoner"},
		{"telefonerade", "telefoner"},
		{"telefonerar", "telefoner"},
		{"telefonstationen", "telefonstation"},
		{"telefontrad", "telefontr"},
		{"telefontråd", "telefontråd"},
		{"telefontrådarna", "telefontråd"},
		{"telegramstil", "telegramstil"},
		{"telning", "telning"},
		{"telsen", "tels"},
		{"tema", "tem"},
		{"temligen", "tem"},
		{"temligt", "tem"},
		{"tempel", "tempel"},
		{"tempeltjänares", "tempeltjänar"},
		{"tempeltun", "tempeltun"},
		{"templet", "templet"},
		{"tempo", "tempo"},
		{"temps", "temp"},
		{"ten", "ten"},
		{"tendens", "tend"},
		{"tenn", "tenn"},
		{"tennsoldat", "tennsold"},
		{"tennsoldaten", "tennsoldat"},
		{"tenntallrikar", "tenntallrik"},
		{"tens", "ten"},
		{"teodor", "teod"},
		{"teofilius", "teofilius"},
		{"teologer", "teolog"},
		{"teologiska", "teologisk"},
		{"teoretiska", "teoretisk"},
		{"teosofi", "teosofi"},
		{"ter", "ter"},
		{"teresa", "teres"},
		{"teresas", "teres"},
		{"terlosaren", "terlos"},
		{"term", "term"},
		{"termer", "term"},
		{"terminen", "termin"},
		{"termometern", "termomet"},
		{"ternström", "ternström"},
		{"ternströms", "ternström"},
		{"ternströrm", "ternströrm"},
		{"terrassen", "terrass"},
		{"terrier", "terri"},
		{"terriern", "terri"},
		{"terrierns", "terri"},
		{"tesen", "tes"},
		{"tesked", "tesked"},
		{"test", "test"},
		{"testa", "test"},
		{"testamente", "testament"},
		{"testamentel", "testamentel"},
		{"testamentera", "testamenter"},
		{"testamentet", "testamentet"},
		{"testamentets", "testamentet"},
		{"testamentsaffären", "testamentsaffär"},
		{"testamentsfrågan", "testamentsfrågan"},
		{"tet", "tet"},
		{"tete", "tet"},
		{"tetimmen", "tetimm"},
		{"tevattnet", "tevattnet"},
		{"texten", "text"},
		{"thanatophilander", "thanatophiland"},
		{"theol", "theol"},
		{"therese", "theres"},
		{"thomas", "thom"},
		{"thyren", "thyr"},
		{"ti", "ti"},
		{"tia", "tia"},
		{"tibastgren", "tibastgr"},
		{"tiber", "tib"},
		{"ticka", "tick"},
		{"tickade", "tick"},
		{"tickan", "tickan"},
		{"tickande", "tick"},
		{"tickar", "tick"},
		{"tid", "tid"},
		{"tidcns", "tidcn"},
		{"tiden", "tid"},
		{"tidender", "tidend"},
		{"tidens", "tid"},
		{"tider", "tid"},
		{"tiderna", "tid"},
		{"tidernas", "tid"},
		{"tiders", "tider"},
		{"tidevarv", "tidevarv"},
		{"tidevarvs", "tidevarv"},
		{"tidig", "tid"},
		{"tidiga", "tid"},
		{"tidigare", "tid"},
		{"tidigast", "tid"},
		{"tidigt", "tid"},
		{"tidlös", "tidlös"},
		{"tidning", "tidning"},
		{"tidningar", "tidning"},
		{"tidningarna", "tidning"},
		{"tidningarnas", "tidning"},
		{"tidningen", "tidning"},
		{"tidningsblad", "tidningsbl"},
		{"tidningskanten", "tidningskant"},
		{"tidningskontoret", "tidningskontoret"},
		{"tidningspacken", "tidningspack"},
		{"tidningspojke", "tidningspojk"},
		{"tidningsurklipp", "tidningsurklipp"},
		{"tidpunkt", "tidpunk"},
		{"tidrn", "tidrn"},
		{"tids", "tid"},
		{"tidsfördriv", "tidsfördriv"},
		{"tidskrift", "tidskrift"},
		{"tidskrifterna", "tidskrift"},
		{"tidspillan", "tidspillan"},
		{"tidsutsikter", "tidsutsik"},
		{"tidtals", "tidtal"},
		{"tig", "tig"},
		{"tiga", "tig"},
		{"tigande", "tig"},
		{"tiger", "tig"},
		{"tigern", "tig"},
		{"tigga", "tigg"},
		{"tiggande", "tigg"},
		{"tiggaraktig", "tiggarakt"},
		{"tiggare", "tigg"},
		{"tiggarländ", "tiggarländ"},
		{"tiggde", "tigg"},
		{"tigger", "tigg"},
		{"tiggt", "tigg"},
		{"tigt", "tigt"},
		{"tiil", "tiil"},
		{"tiitt", "tiitt"},
		{"tik", "tik"},
		{"til", "til"},
		{"tili", "tili"},
		{"till", "till"},
		{"tillade", "till"},
		{"tillades", "till"},
		{"tillaga", "tillag"},
		{"tillagat", "tillag"},
		{"tillagda", "tillag"},
		{"tillbaka", "tillbak"},
		{"tillbakahålla", "tillbakahåll"},
		{"tillbakalutad", "tillbakalut"},
		{"tillbakalutat", "tillbakalut"},
		{"tillbakaskjuten", "tillbakaskjut"},
		{"tillbakastruket", "tillbakastruket"},
		{"tillbakasänd", "tillbakasänd"},
		{"tillbakavisa", "tillbakavis"},
		{"tillbalka", "tillbalk"},
		{"tillbedjan", "tillbedjan"},
		{"tillbedjande", "tillbedj"},
		{"tillbedjare", "tillbedj"},
		{"tillbedjares", "tillbedjar"},
		{"tillbehöret", "tillbehöret"},
		{"tillber", "tillb"},
		{"tillbett", "tillbet"},
		{"tillbragt", "tillbrag"},
		{"tillbragte", "tillbrag"},
		{"tillbragtes", "tillbrag"},
		{"tillbringa", "tillbring"},
		{"tillbringade", "tillbring"},
		{"tillbringare", "tillbring"},
		{"tillbud", "tillbud"},
		{"tillbättre", "tillbättr"},
		{"tillbörlig", "tillbör"},
		{"tillbörligt", "tillbör"},
		{"tilldelad", "tilldel"},
		{"tilldess", "tilldess"},
		{"tilldraga", "tilldrag"},
		{"tilldragande", "tilldrag"},
		{"tilldragelse", "tilldrag"},
		{"tilldragelser", "tilldrag"},
		{"tilldrog", "tilldrog"},
		{"tillfaller", "tillfall"},
		{"tillflykt", "tillflyk"},
		{"tillflyktsort", "tillflyktsort"},
		{"tillfogad", "tillfog"},
		{"tillfogade", "tillfog"},
		{"tillfogat", "tillfog"},
		{"tillfreds", "tillfred"},
		{"tillfredss", "tillfredss"},
		{"tillfredsstallt", "tillfredsstallt"},
		{"tillfredsstäld", "tillfredsstäld"},
		{"tillfredsstälda", "tillfredsstäld"},
		{"tillfredsställa", "tillfredsställ"},
		{"tillfredsställande", "tillfredsställ"},
		{"tillfredsställd", "tillfredsställd"},
		{"tillfredsställde", "tillfredsställd"},
		{"tillfredsställdes", "tillfredsställd"},
		{"tillfredsställelse", "tillfredsställ"},
		{"tillfredsställelsen", "tillfredsställ"},
		{"tillfrisknad", "tillfriskn"},
		{"tillfrisknade", "tillfriskn"},
		{"tillfälle", "tillfäll"},
		{"tillfällen", "tillfäll"},
		{"tillfället", "tillfället"},
		{"tillfällig", "tillfäl"},
		{"tillfälliga", "tillfäl"},
		{"tillfällighet", "tillfäl"},
		{"tillfälligheten", "tillfäl"},
		{"tillfälligheter", "tillfäl"},
		{"tillfälligt", "tillfäl"},
		{"tillfälligtvis", "tillfälligtvis"},
		{"tillföll", "tillföll"},
		{"tillförordnad", "tillförordn"},
		{"tillförsigt", "tillförs"},
		{"tillgifne", "tillgifn"},
		{"tillgifva", "tillgifv"},
		{"tillgifvenhet", "tillgifven"},
		{"tillgivenhet", "tillgiven"},
		{"tillgjord", "tillgjord"},
		{"tillgjorda", "tillgjord"},
		{"tillgjort", "tillgjort"},
		{"tillgodonjuta", "tillgodonjut"},
		{"tillgänglig", "tillgäng"},
		{"tillgå", "tillgå"},
		{"tillgång", "tillgång"},
		{"tillgångar", "tillgång"},
		{"tillhanda", "tillhand"},
		{"tillhandakommet", "tillhandakommet"},
		{"tillhjälp", "tillhjälp"},
		{"tillhka", "tillhk"},
		{"tillhopa", "tillhop"},
		{"tillhorde", "tillhord"},
		{"tillhort", "tillhort"},
		{"tillhugget", "tillhugget"},
		{"tillhygge", "tillhygg"},
		{"tillhåll", "tillhåll"},
		{"tillhör", "tillhör"},
		{"tillhöra", "tillhör"},
		{"tillhörcle", "tillhörcl"},
		{"tillhörde", "tillhörd"},
		{"tillhörighet", "tillhör"},
		{"tillhörigt", "tillhör"},
		{"tillhört", "tillhört"},
		{"tillika", "tillik"},
		{"tillintetgjord", "tillintetgjord"},
		{"tillintetgöra", "tillintetgör"},
		{"tillit", "tillit"},
		{"tillitsfullt", "tillitsfull"},
		{"tillkalla", "tillkall"},
		{"tillkallandet", "tillkall"},
		{"tillkom", "tillkom"},
		{"tillkommande", "tillkomm"},
		{"tillkommit", "tillkommit"},
		{"tillkommo", "tillkommo"},
		{"tillkänna", "tillkän"},
		{"tillkännagav", "tillkännagav"},
		{"tillkännager", "tillkännag"},
		{"tillkännagifva", "tillkännagifv"},
		{"tillkännagiva", "tillkännagiv"},
		{"tillkännagåfvo", "tillkännagåfvo"},
		{"tillkännagåvo", "tillkännagåvo"},
		{"tilllagas", "tilllag"},
		{"tilllaglt", "tilllaglt"},
		{"tillmäten", "tillmät"},
		{"tillmäter", "tillmät"},
		{"tillmötesgående", "tillmötesgåend"},
		{"tillnamnet", "tillnamnet"},
		{"tilloaka", "tilloak"},
		{"tillreda", "tillred"},
		{"tillredd", "tillred"},
		{"tillredelser", "tillred"},
		{"tillredelserna", "tillred"},
		{"tillreder", "tillred"},
		{"tillrop", "tillrop"},
		{"tillrustningar", "tillrustning"},
		{"tillrustningen", "tillrustning"},
		{"tillryggalagt", "tillryggalag"},
		{"tillräcklig", "tillräck"},
		{"tillräckliga", "tillräck"},
		{"tillräckligt", "tillräck"},
		{"tillräknade", "tillräkn"},
		{"tillräkne", "tillräkn"},
		{"tillrättavisning", "tillrättavisning"},
		{"tillråna", "tillrån"},
		{"tills", "till"},
		{"tillsade", "tills"},
		{"tillsades", "tills"},
		{"tillsagt", "tillsag"},
		{"tillsam", "tillsam"},
		{"tillsamman", "tillsamman"},
		{"tillsammans", "tillsamman"},
		{"tillsats", "tillsat"},
		{"tillse", "tills"},
		{"tillskapade", "tillskap"},
		{"tillskott", "tillskot"},
		{"tillskrev", "tillskrev"},
		{"tillskriv", "tillskriv"},
		{"tillskriva", "tillskriv"},
		{"tillskrivas", "tillskriv"},
		{"tillsluter", "tillslut"},
		{"tillslutit", "tillslutit"},
		{"tillslutna", "tillslutn"},
		{"tillslöt", "tillslöt"},
		{"tillslöts", "tillslöt"},
		{"tillsnörpta", "tillsnörpt"},
		{"tillspetsade", "tillspets"},
		{"tillstod", "tillstod"},
		{"tillstyrkt", "tillstyrk"},
		{"tillstyrkte", "tillstyrk"},
		{"tillstyrt", "tillstyrt"},
		{"tillstädes", "tillstäd"},
		{"tillstädja", "tillstädj"},
		{"tillställd", "tillställd"},
		{"tillställning", "tillställning"},
		{"tillställningar", "tillställning"},
		{"tillställningen", "tillställning"},
		{"tillställt", "tillställt"},
		{"tillständigt", "tillständ"},
		{"tillstå", "tillstå"},
		{"tillstånd", "tillstånd"},
		{"tillståndet", "tillståndet"},
		{"tillstår", "tillstår"},
		{"tillstötande", "tillstöt"},
		{"tillsvidare", "tillsvid"},
		{"tillsyn", "tillsyn"},
		{"tillsäg", "tillsäg"},
		{"tillsäga", "tillsäg"},
		{"tillsägelse", "tillsäg"},
		{"tillsändas", "tillsänd"},
		{"tillsändt", "tillsänd"},
		{"tilltagande", "tilltag"},
		{"tilltagen", "tilltag"},
		{"tilltaget", "tilltaget"},
		{"tilltagsenhet", "tilltagsen"},
		{"tilltala", "tilltal"},
		{"tilltalade", "tilltal"},
		{"tilltalande", "tilltal"},
		{"tilltog", "tilltog"},
		{"tilltogo", "tilltogo"},
		{"tilltrott", "tilltrot"},
		{"tilltygad", "tilltyg"},
		{"tilltänkta", "tilltänk"},
		{"tilltänkte", "tilltänk"},
		{"tilltäppt", "tilltäppt"},
		{"tillvaro", "tillvaro"},
		{"tillvaron", "tillvaron"},
		{"tillvarons", "tillvaron"},
		{"tillverkad", "tillverk"},
		{"tillvridet", "tillvridet"},
		{"tillväxt", "tillväxt"},
		{"tillägg", "tillägg"},
		{"tillägga", "tillägg"},
		{"tilläggas", "tillägg"},
		{"tillägger", "tillägg"},
		{"tillägget", "tillägget"},
		{"tillämnade", "tillämn"},
		{"tillämpade", "tillämp"},
		{"tillämpas", "tillämp"},
		{"tilländalupna", "tilländalupn"},
		{"tillärnade", "tillärn"},
		{"tillärnar", "tillärn"},
		{"tillät", "tillät"},
		{"tilläte", "tillät"},
		{"tilläto", "tilläto"},
		{"tillåt", "tillåt"},
		{"tillåta", "tillåt"},
		{"tillåtas", "tillåt"},
		{"tillåtelse", "tillåt"},
		{"tillåtelsen", "tillåt"},
		{"tillåten", "tillåt"},
		{"tillåter", "tillåt"},
		{"tillåtet", "tillåtet"},
		{"tillåtit", "tillåtit"},
		{"tillåtna", "tillåtn"},
		{"tillökning", "tillökning"},
		{"tillökta", "tillök"},
		{"tilt", "tilt"},
		{"timglaset", "timglaset"},
		{"timjan", "timjan"},
		{"timliga", "tim"},
		{"timligheten", "tim"},
		{"timma", "timm"},
		{"timmai", "timmai"},
		{"timmar", "timm"},
		{"timmarna", "timm"},
		{"timmarne", "timm"},
		{"timmars", "timmar"},
		{"timme", "timm"},
		{"timmen", "timm"},
		{"timmergesäll", "timmergesäll"},
		{"timmerstockar", "timmerstock"},
		{"timmes", "timm"},
		{"timrades", "timr"},
		{"timrar", "timr"},
		{"tinade", "tin"},
		{"tinan", "tinan"},
		{"tinande", "tin"},
		{"tindra", "tindr"},
		{"tindrade", "tindr"},
		{"tindrande", "tindr"},
		{"tindrar", "tindr"},
		{"ting", "ting"},
		{"tingar", "ting"},
		{"tingen", "ting"},
		{"tingens", "ting"},
		{"tingestar", "tingest"},
		{"tingesten", "tingest"},
		{"tingsgöromålen", "tingsgöromål"},
		{"tinktur", "tinktur"},
		{"tinning", "tinning"},
		{"tinningar", "tinning"},
		{"tinningarna", "tinning"},
		{"tinningen", "tinning"},
		{"tintomara", "tintomar"},
		{"tio", "tio"},
		{"tiobedjande", "tiobedj"},
		{"tiodubbelt", "tiodubbelt"},
		{"tiodubblades", "tiodubbl"},
		{"tiofaldigt", "tiofald"},
		{"tiokamp", "tiokamp"},
		{"tion", "tion"},
		{"tionde", "tiond"},
		{"tioner", "tion"},
		{"tior", "tior"},
		{"tiotal", "tiotal"},
		{"tiotiden", "tiotid"},
		{"tiotusental", "tiotusental"},
		{"tir", "tir"},
		{"tisdag", "tisdag"},
		{"tisdagen", "tisdag"},
		{"tisdagsaftnar", "tisdagsaftn"},
		{"tisdagsaftnarna", "tisdagsaftn"},
		{"tiska", "tisk"},
		{"tiskt", "tisk"},
		{"tissla", "tissl"},
		{"tistelöborna", "tistelöb"},
		{"tistelöherrskapet", "tistelöherrskapet"},
		{"tistelön", "tistelön"},
		{"tistelöns", "tistelön"},
		{"tistelöpacket", "tistelöpacket"},
		{"tistelörosen", "tistelöros"},
		{"titel", "titel"},
		{"titelbladet", "titelbladet"},
		{"titeln", "titeln"},
		{"titelsidan", "titelsidan"},
		{"titet", "titet"},
		{"titlarna", "titl"},
		{"titta", "titt"},
		{"tittade", "titt"},
		{"tittande", "titt"},
		{"tittar", "titt"},
		{"tittat", "titt"},
		{"titulerades", "tituler"},
		{"tjenade", "tjen"},
		{"tjenar", "tjen"},
		{"tjenare", "tjen"},
		{"tjenarinnan", "tjenarinnan"},
		{"tjenat", "tjen"},
		{"tjenligast", "tjen"},
		{"tjenst", "tjenst"},
		{"tjenstaktig", "tjenstakt"},
		{"tjenstaktighet", "tjenstakt"},
		{"tjenstaktigt", "tjenstakt"},
		{"tjenstebefattning", "tjenstebefattning"},
		{"tjenstefolk", "tjenstefolk"},
		{"tjenstefolket", "tjenstefolket"},
		{"tjensteman", "tjensteman"},
		{"tjenstemannen", "tjensteman"},
		{"tjensten", "tjenst"},
		{"tjenstepligt", "tjenstep"},
		{"tjenster", "tjenst"},
		{"tjenstflicka", "tjenstflick"},
		{"tjenstfolk", "tjenstfolk"},
		{"tjenstfolket", "tjenstfolket"},
		{"tjenstgörande", "tjenstgör"},
		{"tjenstgöromål", "tjenstgöromål"},
		{"tjent", "tjent"},
		{"tjock", "tjock"},
		{"tjocka", "tjock"},
		{"tjockare", "tjock"},
		{"tjocknar", "tjockn"},
		{"tjockt", "tjock"},
		{"tjog", "tjog"},
		{"tjugo", "tjugo"},
		{"tjugonde", "tjugond"},
		{"tjugu", "tjugu"},
		{"tjuguandra", "tjuguandr"},
		{"tjuguett", "tjuguet"},
		{"tjugufem", "tjugufem"},
		{"tjugufemte", "tjugufemt"},
		{"tjugufjerde", "tjugufjerd"},
		{"tjugufyra", "tjugufyr"},
		{"tjugufyraskilling", "tjugufyraskilling"},
		{"tjuguförsta", "tjuguförst"},
		{"tjugunio", "tjugunio"},
		{"tjugutre", "tjugutr"},
		{"tjugutredje", "tjugutredj"},
		{"tjugutvå", "tjugutvå"},
		{"tjuguåren", "tjuguår"},
		{"tjuguårig", "tjuguår"},
		{"tjuguårige", "tjuguår"},
		{"tjuguåtta", "tjuguåt"},
		{"tjurpannan", "tjurpannan"},
		{"tjusad", "tjus"},
		{"tjusade", "tjus"},
		{"tjusande", "tjus"},
		{"tjusats", "tjusat"},
		{"tjuserska", "tjusersk"},
		{"tjust", "tjust"},
		{"tjusta", "tjust"},
		{"tjut", "tjut"},
		{"tjutande", "tjut"},
		{"tjuter", "tjut"},
		{"tjuv", "tjuv"},
		{"tjuvar", "tjuv"},
		{"tjäll", "tjäll"},
		{"tjäna", "tjän"},
		{"tjänade", "tjän"},
		{"tjänande", "tjän"},
		{"tjänar", "tjän"},
		{"tjänare", "tjän"},
		{"tjänaren", "tjän"},
		{"tjänares", "tjänar"},
		{"tjänarinna", "tjänarin"},
		{"tjänarna", "tjän"},
		{"tjänat", "tjän"},
		{"tjänlig", "tjän"},
		{"tjänliga", "tjän"},
		{"tjänligt", "tjän"},
		{"tjänst", "tjänst"},
		{"tjänstaktig", "tjänstakt"},
		{"tjänstaktighet", "tjänstakt"},
		{"tjänsteande", "tjänste"},
		{"tjänsteflicka", "tjänsteflick"},
		{"tjänsteflickans", "tjänsteflickan"},
		{"tjänstehjon", "tjänstehjon"},
		{"tjänsteman", "tjänsteman"},
		{"tjänstens", "tjänst"},
		{"tjänsteplikter", "tjänsteplik"},
		{"tjänstetid", "tjänstetid"},
		{"tjänstflic", "tjänstflic"},
		{"tjänstflicka", "tjänstflick"},
		{"tjänstflickan", "tjänstflickan"},
		{"tjänstfolk", "tjänstfolk"},
		{"tjänstfolket", "tjänstfolket"},
		{"tjänstgjorde", "tjänstgjord"},
		{"tjänstgör", "tjänstgör"},
		{"tjänstgöra", "tjänstgör"},
		{"tjänstgöring", "tjänstgöring"},
		{"tjänstvilliga", "tjänstvil"},
		{"tjänstvilligt", "tjänstvil"},
		{"tjänte", "tjänt"},
		{"tjära", "tjär"},
		{"tjärn", "tjärn"},
		{"tjärnan", "tjärnan"},
		{"tjärnen", "tjärn"},
		{"tjöt", "tjöt"},
		{"tjöto", "tjöto"},
		{"tmdvek", "tmdvek"},
		{"tnmma", "tnmma"},
		{"tnmt", "tnmt"},
		{"to", "to"},
		{"toalett", "toalet"},
		{"toalettbordet", "toalettbordet"},
		{"toaletten", "toalet"},
		{"toalettens", "toalet"},
		{"tobak", "tobak"},
		{"tobaksindustrien", "tobaksindustri"},
		{"tobaksrullen", "tobaksrull"},
		{"tobaksröken", "tobaksrök"},
		{"tocke", "tock"},
		{"tocken", "tock"},
		{"tockholm", "tockholm"},
		{"tockna", "tockn"},
		{"toddar", "todd"},
		{"toddy", "toddy"},
		{"toddyar", "toddy"},
		{"toddyglas", "toddygl"},
		{"toffel", "toffel"},
		{"toffelklädda", "toffelkläd"},
		{"toffeln", "toffeln"},
		{"tofflor", "toffl"},
		{"tofflorna", "toffl"},
		{"tofs", "tof"},
		{"tofterna", "toft"},
		{"tofvade", "tofv"},
		{"tog", "tog"},
		{"toga", "tog"},
		{"toge", "tog"},
		{"togo", "togo"},
		{"togs", "tog"},
		{"tok", "tok"},
		{"tokig", "tok"},
		{"tokiga", "tok"},
		{"tokigt", "tok"},
		{"tokorna", "tok"},
		{"tokroligheter", "tokro"},
		{"tolf", "tolf"},
		{"tolfte", "tolft"},
		{"tolfva", "tolfv"},
		{"tolfvor", "tolfv"},
		{"tolka", "tolk"},
		{"tolkade", "tolk"},
		{"tolv", "tolv"},
		{"tolvskilling", "tolvskilling"},
		{"tom", "tom"},
		{"tomernas", "tom"},
		{"tomhet", "tom"},
		{"tomhetens", "tom"},
		{"tomhänta", "tomhänt"},
		{"tomma", "tomm"},
		{"tomrum", "tomrum"},
		{"tomrummet", "tomrummet"},
		{"tomt", "tomt"},
		{"tomte", "tomt"},
		{"tomten", "tomt"},
		{"tomter", "tomt"},
		{"tomtormar", "tomtorm"},
		{"ton", "ton"},
		{"tona", "ton"},
		{"tonade", "ton"},
		{"tonart", "tonart"},
		{"tonen", "ton"},
		{"toner", "ton"},
		{"tonerna", "ton"},
		{"tonfall", "tonfall"},
		{"tonfallen", "tonfall"},
		{"tonfallet", "tonfallet"},
		{"tongivande", "tongiv"},
		{"tongångar", "tongång"},
		{"tonigt", "ton"},
		{"tons", "ton"},
		{"tonserie", "tonseri"},
		{"tonåren", "tonår"},
		{"topp", "topp"},
		{"topparna", "topp"},
		{"toquen", "toqu"},
		{"tor", "tor"},
		{"tora", "tor"},
		{"torblad", "torbl"},
		{"torblads", "torblad"},
		{"torcl", "torcl"},
		{"tord", "tord"},
		{"torde", "tord"},
		{"tordes", "tord"},
		{"tords", "tord"},
		{"torens", "tor"},
		{"torfbänk", "torfbänk"},
		{"torftiga", "torft"},
		{"torftigt", "torft"},
		{"torfvorna", "torfv"},
		{"torg", "torg"},
		{"torgen", "torg"},
		{"torget", "torget"},
		{"torgets", "torget"},
		{"torgpriserna", "torgpris"},
		{"torka", "tork"},
		{"torkade", "tork"},
		{"torkades", "tork"},
		{"torkvinden", "torkvind"},
		{"torn", "torn"},
		{"torna", "torn"},
		{"tornas", "torn"},
		{"tornbergs", "tornberg"},
		{"tornet", "tornet"},
		{"tornets", "tornet"},
		{"tornrum", "tornrum"},
		{"torns", "torn"},
		{"torp", "torp"},
		{"torparkök", "torparkök"},
		{"torparson", "torparson"},
		{"torr", "torr"},
		{"torra", "torr"},
		{"torrare", "torr"},
		{"torrhosta", "torrhost"},
		{"torrt", "torrt"},
		{"torsdag", "torsdag"},
		{"torsdagen", "torsdag"},
		{"torsdags", "torsdag"},
		{"torsk", "torsk"},
		{"tortyr", "tortyr"},
		{"torv", "torv"},
		{"torva", "torv"},
		{"torvbänken", "torvbänk"},
		{"tosing", "tosing"},
		{"tosingen", "tosing"},
		{"tossene", "tossen"},
		{"total", "total"},
		{"totalt", "totalt"},
		{"tous", "tous"},
		{"toute", "tout"},
		{"tovsjunga", "tovsjung"},
		{"tra", "tra"},
		{"trad", "trad"},
		{"tradens", "trad"},
		{"tradition", "tradition"},
		{"traditionens", "tradition"},
		{"traditioner", "tradition"},
		{"tradrötter", "tradröt"},
		{"traffa", "traff"},
		{"trafiken", "trafik"},
		{"trage", "trag"},
		{"tragisk", "tragisk"},
		{"tragiska", "tragisk"},
		{"tragiskt", "tragisk"},
		{"trak", "trak"},
		{"trakassera", "trakasser"},
		{"trakigt", "trak"},
		{"trakt", "trakt"},
		{"traktade", "trakt"},
		{"traktar", "trakt"},
		{"traktater", "traktat"},
		{"trakten", "trakt"},
		{"traktens", "trakt"},
		{"trakter", "trakt"},
		{"traktera", "trakter"},
		{"trakterade", "trakter"},
		{"trakterna", "trakt"},
		{"trampa", "tramp"},
		{"trampade", "tramp"},
		{"trampan", "trampan"},
		{"trampar", "tramp"},
		{"trampas", "tramp"},
		{"trampat", "tramp"},
		{"trampats", "trampat"},
		{"trampet", "trampet"},
		{"tran", "tran"},
		{"tranad", "tran"},
		{"tranande", "tran"},
		{"trancherade", "trancher"},
		{"tranebergsbro", "tranebergsbro"},
		{"tranen", "tran"},
		{"tranga", "trang"},
		{"trankilisera", "trankiliser"},
		{"trankiliserad", "trankiliser"},
		{"tranlampas", "tranlamp"},
		{"transport", "transport"},
		{"transporterad", "transporter"},
		{"trap", "trap"},
		{"trapp", "trapp"},
		{"trappa", "trapp"},
		{"trappam", "trappam"},
		{"trappan", "trappan"},
		{"trappans", "trappan"},
		{"trappfönstren", "trappfönstr"},
		{"trappfönstret", "trappfönstret"},
		{"trappor", "trapp"},
		{"trapporna", "trapp"},
		{"trapprummet", "trapprummet"},
		{"trapprummets", "trapprummet"},
		{"trappsteg", "trappsteg"},
		{"trappstegen", "trappsteg"},
		{"trappsteget", "trappsteget"},
		{"trasa", "tras"},
		{"trasig", "tras"},
		{"trasiga", "tras"},
		{"trasigt", "tras"},
		{"trask", "trask"},
		{"traskade", "trask"},
		{"trasmatta", "trasmat"},
		{"trasmattorna", "trasmat"},
		{"trasor", "tras"},
		{"trasorna", "tras"},
		{"trassel", "trassel"},
		{"trassla", "trassl"},
		{"trasslade", "trassl"},
		{"trasslar", "trassl"},
		{"trassligt", "trass"},
		{"trast", "trast"},
		{"tratten", "tratt"},
		{"trav", "trav"},
		{"tre", "tre"},
		{"tredje", "tredj"},
		{"tredjedelar", "tredjedel"},
		{"tredubbelt", "tredubbelt"},
		{"tredubbla", "tredubbl"},
		{"trefalt", "trefalt"},
		{"treflig", "tref"},
		{"trefliga", "tref"},
		{"trefligare", "tref"},
		{"treflige", "tref"},
		{"trefligt", "tref"},
		{"trefnad", "trefn"},
		{"trehundra", "trehundr"},
		{"trekarl", "trekarl"},
		{"trekarlsvänner", "trekarlsvän"},
		{"trenne", "trenn"},
		{"treriksdalerssedel", "treriksdalerssedel"},
		{"treskilling", "treskilling"},
		{"tresse", "tress"},
		{"tretal", "tretal"},
		{"tretiden", "tretid"},
		{"trettio", "trettio"},
		{"trettioarsaldern", "trettioarsald"},
		{"trettiofem", "trettiofem"},
		{"trettiofemte", "trettiofemt"},
		{"trettiosex", "trettiosex"},
		{"trettiotre", "trettiotr"},
		{"trettiotreåriga", "trettiotreår"},
		{"trettiotvå", "trettiotvå"},
		{"trettioårsåldern", "trettioårsåld"},
		{"trettitre", "trettitr"},
		{"tretton", "tretton"},
		{"trettonde", "trettond"},
		{"tretumsspik", "tretumsspik"},
		{"treva", "trev"},
		{"trevade", "trev"},
		{"trevande", "trev"},
		{"trevar", "trev"},
		{"trevlig", "trev"},
		{"trevliga", "trev"},
		{"trevligare", "trev"},
		{"trevligaste", "trev"},
		{"trevlige", "trev"},
		{"trevligheten", "trev"},
		{"trevligt", "trev"},
		{"trevnad", "trevn"},
		{"treåriga", "treår"},
		{"treårsgamla", "treårsgaml"},
		{"triangel", "triangel"},
		{"triangeln", "triangeln"},
		{"triangelns", "triangeln"},
		{"tribun", "tribun"},
		{"trifdes", "trifd"},
		{"trifs", "trif"},
		{"trifvas", "trifv"},
		{"trikå", "trikå"},
		{"trikåer", "trikå"},
		{"trilla", "trill"},
		{"trillade", "trill"},
		{"trinde", "trind"},
		{"trippa", "tripp"},
		{"trippade", "tripp"},
		{"trippande", "tripp"},
		{"trippat", "tripp"},
		{"trist", "trist"},
		{"triste", "trist"},
		{"triumf", "triumf"},
		{"triumfer", "triumf"},
		{"triumferade", "triumfer"},
		{"triumferande", "triumfer"},
		{"trivas", "triv"},
		{"trivdes", "trivd"},
		{"trivs", "triv"},
		{"trivsamt", "trivsamt"},
		{"trivts", "trivt"},
		{"trn", "trn"},
		{"tro", "tro"},
		{"troddc", "troddc"},
		{"trodde", "trodd"},
		{"troddes", "trodd"},
		{"troende", "troend"},
		{"troenden", "troend"},
		{"trofast", "trof"},
		{"trofasta", "trofast"},
		{"trofaste", "trof"},
		{"trofasu", "trofasu"},
		{"trogen", "trog"},
		{"troget", "troget"},
		{"trogna", "trogn"},
		{"trogne", "trogn"},
		{"trohet", "trohet"},
		{"troheten", "trohet"},
		{"trohjertade", "trohjert"},
		{"trohjärtade", "trohjärt"},
		{"trohjärtat", "trohjärt"},
		{"troligaste", "trol"},
		{"troligen", "trol"},
		{"troligt", "trol"},
		{"troligtvis", "troligtvis"},
		{"troll", "troll"},
		{"trolla", "troll"},
		{"trollade", "troll"},
		{"trollats", "trollat"},
		{"trolleri", "trolleri"},
		{"trolleriprofessorernas", "trolleriprofessor"},
		{"trollet", "trollet"},
		{"trollgubben", "trollgubb"},
		{"trollguldet", "trollguldet"},
		{"trollkarl", "trollkarl"},
		{"trollmans", "trollman"},
		{"trollmor", "trollm"},
		{"trollpacka", "trollpack"},
		{"trollsagan", "trollsagan"},
		{"trollspegel", "trollspegel"},
		{"trolofning", "trolofning"},
		{"trolofvad", "trolofv"},
		{"trolos", "trolo"},
		{"trolsk", "trolsk"},
		{"trolska", "trolsk"},
		{"trolskt", "trolsk"},
		{"tron", "tron"},
		{"trona", "tron"},
		{"tronade", "tron"},
		{"tronen", "tron"},
		{"tronens", "tron"},
		{"tronföljare", "tronfölj"},
		{"trons", "tron"},
		{"tror", "tror"},
		{"tros", "tros"},
		{"trosartikel", "trosartikel"},
		{"trosartiklar", "trosartikl"},
		{"trostande", "trost"},
		{"trotjänaren", "trotjän"},
		{"trots", "trot"},
		{"trotsa", "trots"},
		{"trotsande", "trots"},
		{"trotsat", "trots"},
		{"trotsig", "trots"},
		{"trotsiga", "trots"},
		{"trotsigt", "trots"},
		{"trott", "trott"},
		{"trottoaren", "trotto"},
		{"trottoarerna", "trottoar"},
		{"trottoarkanten", "trottoarkant"},
		{"trovärdig", "trovärd"},
		{"trovärdiga", "trovärd"},
		{"trovärdigheten", "trovärd"},
		{"trovärdigt", "trovärd"},
		{"trubbig", "trubb"},
		{"trubbiga", "trubb"},
		{"trubbigt", "trubb"},
		{"trubbnäsa", "trubbnäs"},
		{"trugade", "trug"},
		{"trugat", "trug"},
		{"trumma", "trumm"},
		{"trummade", "trumm"},
		{"trumman", "trumman"},
		{"trummar", "trumm"},
		{"trumpen", "trump"},
		{"trumpet", "trumpet"},
		{"trumpeten", "trumpet"},
		{"trumslag", "trumslag"},
		{"trupp", "trupp"},
		{"truppen", "trupp"},
		{"trupper", "trupp"},
		{"trut", "trut"},
		{"truten", "trut"},
		{"trvckning", "trvckning"},
		{"try", "try"},
		{"tryck", "tryck"},
		{"trycka", "tryck"},
		{"tryckande", "tryck"},
		{"trycker", "tryck"},
		{"trycket", "trycket"},
		{"tryckning", "tryckning"},
		{"trycksvärta", "trycksvärt"},
		{"tryckt", "tryck"},
		{"tryckta", "tryck"},
		{"tryckte", "tryck"},
		{"trycktes", "tryck"},
		{"trygg", "trygg"},
		{"trygga", "trygg"},
		{"tryggad", "trygg"},
		{"tryggaste", "trygg"},
		{"trygghet", "trygg"},
		{"tryggt", "trygg"},
		{"tryta", "tryt"},
		{"trä", "trä"},
		{"träarkitektur", "träarkitektur"},
		{"träben", "träb"},
		{"träbryggan", "träbryggan"},
		{"träbänk", "träbänk"},
		{"träck", "träck"},
		{"träd", "träd"},
		{"träda", "träd"},
		{"trädde", "trädd"},
		{"träden", "träd"},
		{"trädens", "träd"},
		{"trädet", "trädet"},
		{"trädgarden", "trädgard"},
		{"trädgren", "trädgr"},
		{"trädgrenar", "trädgren"},
		{"trädgård", "trädgård"},
		{"trädgårdarna", "trädgård"},
		{"trädgården", "trädgård"},
		{"trädgårdens", "trädgård"},
		{"trädgårdsfönster", "trädgårdsfönst"},
		{"trädgårdsmästarebvggningen", "trädgårdsmästarebvggning"},
		{"trädgårdsmäster", "trädgårdsmäst"},
		{"trädgårdssoffa", "trädgårdssoff"},
		{"trädgårdstäppa", "trädgårdstäpp"},
		{"trädgårdstäppan", "trädgårdstäppan"},
		{"trädknapparne", "trädknapp"},
		{"trädkrona", "trädkron"},
		{"trädkronorna", "trädkron"},
		{"trädkronornas", "trädkron"},
		{"trädrot", "trädrot"},
		{"trädstam", "trädstam"},
		{"trädstammen", "trädstamm"},
		{"trädt", "trädt"},
		{"trädtopparna", "trädtopp"},
		{"träffa", "träff"},
		{"träffad", "träff"},
		{"träffade", "träff"},
		{"träffades", "träff"},
		{"träffar", "träff"},
		{"träffas", "träff"},
		{"träffat", "träff"},
		{"träffats", "träffat"},
		{"träfiade", "träfi"},
		{"trägen", "träg"},
		{"träget", "träget"},
		{"trägna", "trägn"},
		{"trägnast", "trägn"},
		{"trähinken", "trähink"},
		{"trähus", "trähus"},
		{"träla", "träl"},
		{"trälar", "träl"},
		{"trälinna", "trälin"},
		{"trällif", "trällif"},
		{"trälåda", "trälåd"},
		{"trälådan", "trälådan"},
		{"trän", "trän"},
		{"tränga", "träng"},
		{"trängande", "träng"},
		{"trängde", "träng"},
		{"trängdes", "träng"},
		{"tränger", "träng"},
		{"trängre", "trängr"},
		{"trängs", "träng"},
		{"trängseln", "trängseln"},
		{"trängt", "träng"},
		{"tränkbar", "tränkb"},
		{"träsk", "träsk"},
		{"träsnitt", "träsnit"},
		{"trästubbe", "trästubb"},
		{"träta", "trät"},
		{"trätobroder", "trätobrod"},
		{"trätt", "trätt"},
		{"tråd", "tråd"},
		{"trådar", "tråd"},
		{"trådarna", "tråd"},
		{"tråden", "tråd"},
		{"trådgårdar", "trådgård"},
		{"trådnystan", "trådnystan"},
		{"trådsliten", "trådslit"},
		{"trådsmala", "trådsmal"},
		{"tråget", "tråget"},
		{"tråka", "tråk"},
		{"tråkig", "tråk"},
		{"tråkiga", "tråk"},
		{"tråkigaste", "tråk"},
		{"tråkigt", "tråk"},
		{"tråna", "trån"},
		{"trånad", "trån"},
		{"trånade", "trån"},
		{"trånande", "trån"},
		{"trång", "trång"},
		{"trånga", "trång"},
		{"trångaste", "trång"},
		{"trångmål", "trångmål"},
		{"trångt", "trång"},
		{"trånmatta", "trånmat"},
		{"trånsjuk", "trånsjuk"},
		{"trög", "trög"},
		{"tröga", "trög"},
		{"tröge", "trög"},
		{"tröghet", "trög"},
		{"trögtänkt", "trögtänk"},
		{"tröja", "tröj"},
		{"tröjan", "tröjan"},
		{"tröjor", "tröj"},
		{"tröska", "trösk"},
		{"tröskaren", "trösk"},
		{"tröskel", "tröskel"},
		{"tröskeln", "tröskeln"},
		{"tröst", "tröst"},
		{"trösta", "tröst"},
		{"tröstad", "tröst"},
		{"tröstade", "tröst"},
		{"tröstande", "tröst"},
		{"tröstar", "tröst"},
		{"tröstat", "tröst"},
		{"trösten", "tröst"},
		{"tröstfull", "tröstfull"},
		{"tröstfulla", "tröstfull"},
		{"tröstlös", "tröstlös"},
		{"tröstlösa", "tröstlös"},
		{"tröstlöst", "tröstlös"},
		{"tröstrika", "tröstrik"},
		{"tröstrike", "tröstrik"},
		{"tröstrikt", "tröstrik"},
		{"trött", "trött"},
		{"trötta", "trött"},
		{"tröttade", "trött"},
		{"tröttande", "trött"},
		{"tröttar", "trött"},
		{"tröttat", "trött"},
		{"trötte", "trött"},
		{"tröttflugen", "tröttflug"},
		{"trötthet", "trött"},
		{"tröttna", "tröttn"},
		{"tröttnade", "tröttn"},
		{"tröttnande", "tröttn"},
		{"tröttnat", "tröttn"},
		{"tröttsam", "tröttsam"},
		{"tröttsamma", "tröttsamm"},
		{"tröttsamt", "tröttsamt"},
		{"ts", "ts"},
		{"tt", "tt"},
		{"tta", "tta"},
		{"ttm", "ttm"},
		{"tu", "tu"},
		{"tug", "tug"},
		{"tugga", "tugg"},
		{"tuggade", "tugg"},
		{"tuggan", "tuggan"},
		{"tuggande", "tugg"},
		{"tuggar", "tugg"},
		{"tukt", "tukt"},
		{"tukta", "tukt"},
		{"tuktade", "tukt"},
		{"tuktar", "tukt"},
		{"tuktodikten", "tuktodik"},
		{"tuktomästare", "tuktomäst"},
		{"tull", "tull"},
		{"tullar", "tull"},
		{"tullen", "tull"},
		{"tullfri", "tullfri"},
		{"tullförsnillning", "tullförsnillning"},
		{"tullförvaltare", "tullförvalt"},
		{"tullförvaltaren", "tullförvalt"},
		{"tullförvaltarens", "tullförvalt"},
		{"tullförvaltarn", "tullförvaltarn"},
		{"tullförvaltarns", "tullförvaltarn"},
		{"tullförvalterskan", "tullförvalterskan"},
		{"tullförvalterskans", "tullförvalterskan"},
		{"tulljakt", "tulljak"},
		{"tulljakten", "tulljak"},
		{"tulljaktens", "tulljak"},
		{"tullkammare", "tullkamm"},
		{"tullkammaren", "tullkamm"},
		{"tullkammarn", "tullkammarn"},
		{"tullskrifvare", "tullskrifv"},
		{"tullskrifvaren", "tullskrifv"},
		{"tullsnok", "tullsnok"},
		{"tullsnokarne", "tullsnok"},
		{"tullstyrelsen", "tullstyr"},
		{"tulltjensteman", "tulltjensteman"},
		{"tullvaktmästare", "tullvaktmäst"},
		{"tullvaktmästarens", "tullvaktmäst"},
		{"tullväsendet", "tullväsendet"},
		{"tulma", "tulm"},
		{"tulpaner", "tulpan"},
		{"tultade", "tult"},
		{"tulubb", "tulubb"},
		{"tulubben", "tulubb"},
		{"tum", "tum"},
		{"tumla", "tuml"},
		{"tumlade", "tuml"},
		{"tumlar", "tuml"},
		{"tumlare", "tuml"},
		{"tumlat", "tuml"},
		{"tummen", "tumm"},
		{"tung", "tung"},
		{"tunga", "tung"},
		{"tungan", "tungan"},
		{"tungas", "tung"},
		{"tungel", "tungel"},
		{"tungor", "tung"},
		{"tungsinta", "tungsint"},
		{"tungsinthet", "tungsint"},
		{"tungt", "tung"},
		{"tungus", "tungus"},
		{"tunn", "tunn"},
		{"tunna", "tunn"},
		{"tunnan", "tunnan"},
		{"tunnare", "tunn"},
		{"tunnas", "tunn"},
		{"tunnbindare", "tunnbind"},
		{"tunnbindars", "tunnbindar"},
		{"tunnbröds", "tunnbröd"},
		{"tunnor", "tunn"},
		{"tunnorna", "tunn"},
		{"tunnvalv", "tunnvalv"},
		{"tunt", "tunt"},
		{"tupp", "tupp"},
		{"tur", "tur"},
		{"turade", "tur"},
		{"turen", "tur"},
		{"turer", "tur"},
		{"turistsmaken", "turistsmak"},
		{"turken", "turk"},
		{"turkisk", "turkisk"},
		{"turkiska", "turkisk"},
		{"turmmen", "turmm"},
		{"turturduvor", "turturduv"},
		{"turvis", "turvis"},
		{"tusan", "tusan"},
		{"tusch", "tusch"},
		{"tuschritningen", "tuschritning"},
		{"tusen", "tus"},
		{"tusenfalt", "tusenfalt"},
		{"tusentals", "tusental"},
		{"tutade", "tut"},
		{"tutande", "tut"},
		{"tuva", "tuv"},
		{"tuvahisto", "tuvahisto"},
		{"tuvan", "tuvan"},
		{"tuvig", "tuv"},
		{"tuvor", "tuv"},
		{"tva", "tva"},
		{"tvagen", "tvag"},
		{"tvagning", "tvagning"},
		{"tvang", "tvang"},
		{"tvehågsenhet", "tvehågsen"},
		{"tveka", "tvek"},
		{"tvekade", "tvek"},
		{"tvekan", "tvekan"},
		{"tvekande", "tvek"},
		{"tvekat", "tvek"},
		{"tveksam", "tveksam"},
		{"tveksamt", "tveksamt"},
		{"tvenne", "tvenn"},
		{"tver", "tver"},
		{"tvetydig", "tvetyd"},
		{"tvetydiga", "tvetyd"},
		{"tvetydigheter", "tvetyd"},
		{"tvetydigt", "tvetyd"},
		{"tvifla", "tvifl"},
		{"tviflande", "tvifl"},
		{"tviflar", "tvifl"},
		{"tviflets", "tviflet"},
		{"tvifvel", "tvifvel"},
		{"tvillingsjäl", "tvillingsjäl"},
		{"tvillingsyster", "tvillingsyst"},
		{"tvina", "tvin"},
		{"tvinade", "tvin"},
		{"tvinande", "tvin"},
		{"tvinga", "tving"},
		{"tvingad", "tving"},
		{"tvingade", "tving"},
		{"tvingades", "tving"},
		{"tvingar", "tving"},
		{"tvingas", "tving"},
		{"tvingat", "tving"},
		{"tvinsjuka", "tvinsjuk"},
		{"tvinsjukt", "tvinsjuk"},
		{"tvinsot", "tvinsot"},
		{"tvist", "tvist"},
		{"tvista", "tvist"},
		{"tvisten", "tvist"},
		{"tvivel", "tvivel"},
		{"tvivelaktigt", "tvivelakt"},
		{"tvivla", "tvivl"},
		{"tvivlade", "tvivl"},
		{"tvivlande", "tvivl"},
		{"tvivlar", "tvivl"},
		{"tvivlet", "tvivlet"},
		{"tvungen", "tvung"},
		{"tvunget", "tvunget"},
		{"tvungna", "tvungn"},
		{"tvänne", "tvänn"},
		{"tvär", "tvär"},
		{"tvärbjälkar", "tvärbjälk"},
		{"tvären", "tvär"},
		{"tvärs", "tvär"},
		{"tvärsigenom", "tvärsigenom"},
		{"tvärstannade", "tvärstan"},
		{"tvärsäkert", "tvärsäkert"},
		{"tvärsöver", "tvärsöv"},
		{"tvärsövet", "tvärsövet"},
		{"tvärt", "tvärt"},
		{"tvärtemot", "tvärtemot"},
		{"tvärtom", "tvärtom"},
		{"tvärtystnade", "tvärtystn"},
		{"tvätt", "tvätt"},
		{"tvätta", "tvätt"},
		{"tvättad", "tvätt"},
		{"tvättade", "tvätt"},
		{"tvättas", "tvätt"},
		{"tvättat", "tvätt"},
		{"tvättbalja", "tvättbalj"},
		{"tvättbunken", "tvättbunk"},
		{"tvätten", "tvätt"},
		{"tvättfat", "tvättf"},
		{"tvätträkningen", "tvätträkning"},
		{"tvättstallet", "tvättstallet"},
		{"tvättstugan", "tvättstugan"},
		{"två", "två"},
		{"tvåa", "tvåa"},
		{"tvådubbla", "tvådubbl"},
		{"tvål", "tvål"},
		{"tvålfatet", "tvålfatet"},
		{"tvång", "tvång"},
		{"tvånget", "tvånget"},
		{"tvångsarbete", "tvångsarbet"},
		{"tvåriksdalers", "tvåriksdaler"},
		{"tvåriksdalersedel", "tvåriksdalersedel"},
		{"tvåriksdalerssedel", "tvåriksdalerssedel"},
		{"tvåvåningshus", "tvåvåningshus"},
		{"ty", "ty"},
		{"tyck", "tyck"},
		{"tycka", "tyck"},
		{"tyckas", "tyck"},
		{"tycke", "tyck"},
		{"tycken", "tyck"},
		{"tycker", "tyck"},
		{"tyckes", "tyck"},
		{"tyckles", "tyckl"},
		{"tycks", "tyck"},
		{"tyckt", "tyck"},
		{"tycktc", "tycktc"},
		{"tyckte", "tyck"},
		{"tycktes", "tyck"},
		{"tyd", "tyd"},
		{"tyda", "tyd"},
		{"tydande", "tyd"},
		{"tydde", "tydd"},
		{"tydelse", "tyd"},
		{"tyder", "tyd"},
		{"tydlig", "tyd"},
		{"tydliga", "tyd"},
		{"tydligare", "tyd"},
		{"tydligen", "tyd"},
		{"tydlighet", "tyd"},
		{"tydligt", "tyd"},
		{"tydt", "tydt"},
		{"tyg", "tyg"},
		{"tygel", "tygel"},
		{"tygellost", "tygellost"},
		{"tygeln", "tygeln"},
		{"tyger", "tyg"},
		{"tygerna", "tyg"},
		{"tyget", "tyget"},
		{"tyglade", "tygl"},
		{"tyglar", "tygl"},
		{"tygstuvar", "tygstuv"},
		{"tygstycken", "tygstyck"},
		{"tygstövlar", "tygstövl"},
		{"tyko", "tyko"},
		{"tynga", "tyng"},
		{"tyngd", "tyng"},
		{"tyngda", "tyng"},
		{"tyngden", "tyng"},
		{"tynger", "tyng"},
		{"tyngre", "tyngr"},
		{"typ", "typ"},
		{"typiske", "typisk"},
		{"tyrann", "tyran"},
		{"tyrus", "tyrus"},
		{"tysk", "tysk"},
		{"tyska", "tysk"},
		{"tyskarna", "tysk"},
		{"tyskland", "tyskland"},
		{"tyskt", "tysk"},
		{"tyst", "tyst"},
		{"tysta", "tyst"},
		{"tystade", "tyst"},
		{"tystare", "tyst"},
		{"tysthet", "tyst"},
		{"tysthetslöfte", "tysthetslöft"},
		{"tystlåten", "tystlåt"},
		{"tystlåtenhet", "tystlåten"},
		{"tystna", "tystn"},
		{"tystnad", "tystn"},
		{"tystnade", "tystn"},
		{"tystnaden", "tystnad"},
		{"tystnadens", "tystnad"},
		{"tystnar", "tystn"},
		{"tystnat", "tystn"},
		{"tyvärr", "tyvärr"},
		{"täck", "täck"},
		{"täcka", "täck"},
		{"täckare", "täck"},
		{"täckas", "täck"},
		{"täckelset", "täckelset"},
		{"täcken", "täck"},
		{"täckes", "täck"},
		{"täcket", "täcket"},
		{"täcks", "täck"},
		{"täckt", "täck"},
		{"täcktes", "täck"},
		{"täckts", "täck"},
		{"tädkte", "tädk"},
		{"täget", "täget"},
		{"tägga", "tägg"},
		{"täljande", "tälj"},
		{"tälla", "täll"},
		{"tält", "tält"},
		{"tämlig", "täm"},
		{"tämligen", "täm"},
		{"tän", "tän"},
		{"tänd", "tänd"},
		{"tända", "tänd"},
		{"tändande", "tänd"},
		{"tändas", "tänd"},
		{"tände", "tänd"},
		{"tänder", "tänd"},
		{"tänderna", "tänd"},
		{"tändes", "tänd"},
		{"tändsticka", "tändstick"},
		{"tänger", "täng"},
		{"tängerna", "täng"},
		{"tänjas", "tänj"},
		{"tänk", "tänk"},
		{"tänka", "tänk"},
		{"tänkande", "tänk"},
		{"tänkare", "tänk"},
		{"tänkaren", "tänk"},
		{"tänkarna", "tänk"},
		{"tänkarnas", "tänk"},
		{"tänkas", "tänk"},
		{"tänkbar", "tänkb"},
		{"tänkbart", "tänkbart"},
		{"tänke", "tänk"},
		{"tänker", "tänk"},
		{"tänkesätt", "tänkesät"},
		{"tänksamt", "tänksamt"},
		{"tänkt", "tänk"},
		{"tänktc", "tänktc"},
		{"tänkte", "tänk"},
		{"tänt", "tänt"},
		{"tänts", "tänt"},
		{"täppa", "täpp"},
		{"täppan", "täppan"},
		{"tära", "tär"},
		{"tärande", "tär"},
		{"tärd", "tärd"},
		{"tärde", "tärd"},
		{"tärna", "tärn"},
		{"tärnan", "tärnan"},
		{"tärnor", "tärn"},
		{"tärt", "tärt"},
		{"tät", "tät"},
		{"täta", "tät"},
		{"tätare", "tät"},
		{"tätaste", "tät"},
		{"täten", "tät"},
		{"tätnade", "tätn"},
		{"tätt", "tätt"},
		{"tättomslutande", "tättomslut"},
		{"tävlan", "tävlan"},
		{"tävlas", "tävl"},
		{"tå", "tå"},
		{"tåg", "tåg"},
		{"tåga", "tåg"},
		{"tågbygnaden", "tågbygnad"},
		{"tågen", "tåg"},
		{"tåget", "tåget"},
		{"tågpassagerare", "tågpassager"},
		{"tågverket", "tågverket"},
		{"tågändan", "tågändan"},
		{"tål", "tål"},
		{"tåla", "tål"},
		{"tålamod", "tålamod"},
		{"tålamodet", "tålamodet"},
		{"tålde", "tåld"},
		{"tålig", "tål"},
		{"tåliga", "tål"},
		{"tålige", "tål"},
		{"tåligt", "tål"},
		{"tålmodig", "tålmod"},
		{"tåls", "tål"},
		{"tålt", "tålt"},
		{"tålte", "tålt"},
		{"tång", "tång"},
		{"tången", "tång"},
		{"tånk", "tånk"},
		{"tånkte", "tånk"},
		{"tår", "tår"},
		{"tårade", "tår"},
		{"tårades", "tår"},
		{"tårar", "tår"},
		{"tårarna", "tår"},
		{"tårarne", "tår"},
		{"tåren", "tår"},
		{"tårens", "tår"},
		{"tårfuktade", "tårfuk"},
		{"tårfylda", "tårfyld"},
		{"tårfyllda", "tårfylld"},
		{"tårlöst", "tårlös"},
		{"tårna", "tårn"},
		{"tårta", "tårt"},
		{"tårtask", "tårtask"},
		{"tårtbitarna", "tårtbit"},
		{"tårtor", "tårt"},
		{"tårtorna", "tårt"},
		{"tårvätt", "tårvät"},
		{"tårögd", "tårög"},
		{"tårögda", "tårög"},
		{"tåspetsarne", "tåspets"},
		{"tö", "tö"},
		{"töar", "töar"},
		{"töcken", "töck"},
		{"töcknet", "töcknet"},
		{"tölpaktigheten", "tölpakt"},
		{"tölpen", "tölp"},
		{"töm", "töm"},
		{"tömda", "tömd"},
		{"tömde", "tömd"},
		{"tömma", "tömm"},
		{"tömmer", "tömm"},
		{"tömt", "tömt"},
		{"tör", "tör"},
		{"tören", "tör"},
		{"törhända", "törhänd"},
		{"törnet", "törnet"},
		{"törnig", "törn"},
		{"törnroskrans", "törnroskran"},
		{"törnrosor", "törnros"},
		{"törs", "tör"},
		{"törst", "törst"},
		{"törstade", "törst"},
		{"törstig", "törst"},
		{"törstigt", "törst"},
		{"tös", "tös"},
		{"töväder", "töväd"},
		{"u", "u"},
		{"uch", "uch"},
		{"udda", "udd"},
		{"uddas", "udd"},
		{"udde", "udd"},
		{"udden", "udd"},
		{"uddvassa", "uddvass"},
		{"udergår", "udergår"},
		{"uderhålla", "uderhåll"},
		{"uff", "uff"},
		{"ugglor", "uggl"},
		{"ugn", "ugn"},
		{"ugnen", "ugn"},
		{"uilla", "uill"},
		{"ukulele", "ukulel"},
		{"ull", "ull"},
		{"ulla", "ull"},
		{"ullderkläder", "ullderkläd"},
		{"ulle", "ull"},
		{"ullen", "ull"},
		{"ulliga", "ull"},
		{"ullsockar", "ullsock"},
		{"ullt", "ullt"},
		{"ulrik", "ulrik"},
		{"ulster", "ulst"},
		{"ultra", "ultr"},
		{"ulvar", "ulv"},
		{"umbrien", "umbri"},
		{"umbriens", "umbri"},
		{"umbäranden", "umbär"},
		{"umdrande", "umdr"},
		{"umgicks", "umgick"},
		{"umgälla", "umgäll"},
		{"umgänge", "umgäng"},
		{"umgängeslivet", "umgängeslivet"},
		{"umgängesvänner", "umgängesvän"},
		{"umgänget", "umgänget"},
		{"umgås", "umgås"},
		{"umgåtts", "umgåt"},
		{"umler", "uml"},
		{"un", "un"},
		{"undades", "und"},
		{"undan", "undan"},
		{"undanber", "undanb"},
		{"undandraga", "undandrag"},
		{"undandrar", "undandr"},
		{"undandrog", "undandrog"},
		{"undanflykter", "undanflyk"},
		{"undangömd", "undangömd"},
		{"undangömda", "undangömd"},
		{"undanrödja", "undanrödj"},
		{"undanröjt", "undanröjt"},
		{"undansparkade", "undanspark"},
		{"undantag", "undantag"},
		{"undantaget", "undantaget"},
		{"undcrbart", "undcrbart"},
		{"unde", "und"},
		{"under", "und"},
		{"underbar", "underb"},
		{"underbara", "underbar"},
		{"underbart", "underbart"},
		{"underbyggnad", "underbyggn"},
		{"underfund", "underfund"},
		{"underfundig", "underfund"},
		{"underfundigt", "underfund"},
		{"undergifven", "undergifv"},
		{"undergifvenhet", "undergifven"},
		{"undergifvet", "undergifvet"},
		{"undergingo", "undergingo"},
		{"undergivenhet", "undergiven"},
		{"undergivna", "undergivn"},
		{"undergång", "undergång"},
		{"undergången", "undergång"},
		{"undergått", "undergåt"},
		{"undergörande", "undergör"},
		{"underhalla", "underhall"},
		{"underhandlingar", "underhandling"},
		{"underhandlingen", "underhandling"},
		{"underhåll", "underhåll"},
		{"underhålla", "underhåll"},
		{"underhållande", "underhåll"},
		{"underhållen", "underhåll"},
		{"underhållit", "underhållit"},
		{"underhållningen", "underhållning"},
		{"underhöll", "underhöll"},
		{"underhöllo", "underhöllo"},
		{"underjordisk", "underjordisk"},
		{"underjordiska", "underjordisk"},
		{"underkasta", "underkast"},
		{"underkastad", "underkast"},
		{"underkastade", "underkast"},
		{"underkjol", "underkjol"},
		{"underklass", "underklass"},
		{"underkläder", "underkläd"},
		{"underkurer", "underkur"},
		{"underkuvades", "underkuv"},
		{"underlig", "under"},
		{"underliga", "under"},
		{"underligare", "under"},
		{"underligt", "under"},
		{"underliv", "underliv"},
		{"underlivslidande", "underlivslid"},
		{"underlägsen", "underlägs"},
		{"underläpp", "underläpp"},
		{"underläppen", "underläpp"},
		{"underlärarinna", "underlärarin"},
		{"underlärarinnan", "underlärarinnan"},
		{"underlätta", "underlät"},
		{"underlåta", "underlåt"},
		{"underlåtit", "underlåtit"},
		{"underlöjtnant", "underlöjtnant"},
		{"underlöjtnanten", "underlöjtnant"},
		{"undermedvetna", "undermedvetn"},
		{"underordnad", "underordn"},
		{"underordnade", "underordn"},
		{"underordnar", "underordn"},
		{"underredet", "underredet"},
		{"underrätta", "underrät"},
		{"underrättad", "underrät"},
		{"underrättade", "underrät"},
		{"underrättar", "underrät"},
		{"underrättat", "underrät"},
		{"underrättelse", "underrätt"},
		{"underrättelsen", "underrätt"},
		{"underrättelser", "underrätt"},
		{"unders", "under"},
		{"underskattar", "underskat"},
		{"underskrift", "underskrift"},
		{"underskriften", "underskrift"},
		{"understrukna", "understrukn"},
		{"understryk", "understryk"},
		{"understrykningar", "understrykning"},
		{"understundom", "understundom"},
		{"understyrmannen", "understyrman"},
		{"understå", "understå"},
		{"understöd", "understöd"},
		{"undersätsig", "undersäts"},
		{"undersåt", "undersåt"},
		{"undersöka", "undersök"},
		{"undersökas", "undersök"},
		{"undersökning", "undersökning"},
		{"undersökningar", "undersökning"},
		{"undersökningen", "undersökning"},
		{"undersökningsbord", "undersökningsbord"},
		{"undersökningsbordet", "undersökningsbordet"},
		{"undersökningsrum", "undersökningsrum"},
		{"undersökningsrummet", "undersökningsrummet"},
		{"undersökt", "undersök"},
		{"undersökte", "undersök"},
		{"underton", "underton"},
		{"undertrycka", "undertryck"},
		{"undertryckas", "undertryck"},
		{"undertryckt", "undertryck"},
		{"underverk", "underverk"},
		{"undervisa", "undervis"},
		{"undervisade", "undervis"},
		{"undervisat", "undervis"},
		{"undervisning", "undervisning"},
		{"undfalla", "undfall"},
		{"undfallande", "undfall"},
		{"undfallit", "undfallit"},
		{"undfly", "undfly"},
		{"undföll", "undföll"},
		{"undgick", "undgick"},
		{"undgingo", "undgingo"},
		{"undgå", "undgå"},
		{"undkomma", "undkomm"},
		{"undkommo", "undkommo"},
		{"undra", "undr"},
		{"undrade", "undr"},
		{"undran", "undran"},
		{"undrande", "undr"},
		{"undransvärda", "undransvärd"},
		{"undransvärt", "undransvärt"},
		{"undrar", "undr"},
		{"undrat", "undr"},
		{"undseende", "undseend"},
		{"undslapp", "undslapp"},
		{"undsluppit", "undsluppit"},
		{"undsluppna", "undsluppn"},
		{"undsättning", "undsättning"},
		{"undvara", "undvar"},
		{"undvarit", "undvarit"},
		{"undvek", "undvek"},
		{"undvik", "undvik"},
		{"undvika", "undvik"},
		{"undvikande", "undvik"},
		{"undvikas", "undvik"},
		{"undvikes", "undvik"},
		{"ung", "ung"},
		{"unga", "ung"},
		{"ungar", "ung"},
		{"ungarna", "ung"},
		{"ungas", "ung"},
		{"ungdom", "ungdom"},
		{"ungdomar", "ungdom"},
		{"ungdomarna", "ungdom"},
		{"ungdomen", "ungdom"},
		{"ungdomens", "ungdom"},
		{"ungdomlig", "ungdom"},
		{"ungdomliga", "ungdom"},
		{"ungdomligt", "ungdom"},
		{"ungdoms", "ungdom"},
		{"ungdomsaren", "ungdoms"},
		{"ungdomsblomman", "ungdomsblomman"},
		{"ungdomsfröjders", "ungdomsfröjder"},
		{"ungdomskraft", "ungdomskraft"},
		{"ungdomskraften", "ungdomskraft"},
		{"ungdomskärlek", "ungdomskärlek"},
		{"ungdomslättsinne", "ungdomslättsin"},
		{"ungdomsminnen", "ungdomsmin"},
		{"ungdomsrosorna", "ungdomsros"},
		{"ungdomssinnet", "ungdomssinnet"},
		{"ungdomsskaran", "ungdomsskaran"},
		{"ungdomstid", "ungdomstid"},
		{"ungdomsväninna", "ungdomsvänin"},
		{"ungdomsvår", "ungdomsvår"},
		{"ungdomsvörten", "ungdomsvört"},
		{"ungdomsyran", "ungdomsyran"},
		{"ungdomsår", "ungdomsår"},
		{"ungdomsåren", "ungdomsår"},
		{"unge", "ung"},
		{"ungefär", "ungefär"},
		{"ungefärligen", "ungefär"},
		{"ungen", "ung"},
		{"ungersven", "ungersv"},
		{"ungherrar", "ungherr"},
		{"ungherrarna", "ungherr"},
		{"unghjort", "unghjort"},
		{"ungicks", "ungick"},
		{"ungkarl", "ungkarl"},
		{"ungkarlar", "ungkarl"},
		{"ungkarlarna", "ungkarl"},
		{"ungkarlars", "ungkarlar"},
		{"ungkarlen", "ungkarl"},
		{"ungkarls", "ungkarl"},
		{"ungkarlsbostad", "ungkarlsbost"},
		{"ungkarlsliv", "ungkarlsliv"},
		{"ungkarlslivet", "ungkarlslivet"},
		{"ungkarlslivets", "ungkarlslivet"},
		{"ungkarlsrum", "ungkarlsrum"},
		{"ungkarlssoffa", "ungkarlssoff"},
		{"ungkarlsståndet", "ungkarlsståndet"},
		{"ungkarlssäng", "ungkarlssäng"},
		{"ungkärliga", "ungkär"},
		{"ungmö", "ungmö"},
		{"ungmön", "ungmön"},
		{"ungmöns", "ungmön"},
		{"ungskogen", "ungskog"},
		{"ungt", "ungt"},
		{"uniform", "uniform"},
		{"uniformen", "uniform"},
		{"uniformer", "uniform"},
		{"uniformerna", "uniform"},
		{"uniformsmössa", "uniformsmöss"},
		{"uniformsrocken", "uniformsrock"},
		{"unionens", "union"},
		{"universitetet", "universitetet"},
		{"unken", "unk"},
		{"unkna", "unkn"},
		{"unna", "unn"},
		{"unnade", "unn"},
		{"unnar", "unn"},
		{"uns", "uns"},
		{"upmann", "upman"},
		{"upmerksamhet", "upmerksam"},
		{"upp", "upp"},
		{"uppackning", "uppackning"},
		{"uppasser", "uppass"},
		{"uppasserskan", "uppasserskan"},
		{"uppasserskorna", "uppassersk"},
		{"uppassningen", "uppassning"},
		{"uppblossande", "uppbloss"},
		{"uppblåst", "uppblåst"},
		{"uppbrott", "uppbrot"},
		{"uppbyggelse", "uppbygg"},
		{"uppbyggelseböcker", "uppbyggelseböck"},
		{"uppbyggelsestun", "uppbyggelsestun"},
		{"uppbyggliga", "uppbygg"},
		{"uppbyggligt", "uppbygg"},
		{"uppbäddad", "uppbäd"},
		{"uppbära", "uppbär"},
		{"uppdelats", "uppdelat"},
		{"uppdiktad", "uppdik"},
		{"uppdrag", "uppdrag"},
		{"uppdraga", "uppdrag"},
		{"uppdragen", "uppdrag"},
		{"uppdrager", "uppdrag"},
		{"uppdraget", "uppdraget"},
		{"uppdragit", "uppdragit"},
		{"uppdragna", "uppdragn"},
		{"uppdrivet", "uppdrivet"},
		{"uppdrog", "uppdrog"},
		{"uppdukad", "uppduk"},
		{"uppdyka", "uppdyk"},
		{"uppdykande", "uppdyk"},
		{"uppe", "upp"},
		{"uppehälle", "uppehäll"},
		{"uppehåll", "uppehåll"},
		{"uppehålla", "uppehåll"},
		{"uppehållande", "uppehåll"},
		{"uppehållit", "uppehållit"},
		{"uppehöll", "uppehöll"},
		{"uppenbar", "uppenb"},
		{"uppenbarade", "uppenbar"},
		{"uppenbarar", "uppenbar"},
		{"uppenbarat", "uppenbar"},
		{"uppenbarelse", "uppenbar"},
		{"uppenbarelser", "uppenbar"},
		{"uppenbart", "uppenbart"},
		{"uppendagat", "uppendag"},
		{"uppfann", "uppfan"},
		{"uppfarande", "uppfar"},
		{"uppfatta", "uppfat"},
		{"uppfattade", "uppfat"},
		{"uppfattar", "uppfat"},
		{"uppfattat", "uppfat"},
		{"uppfattning", "uppfattning"},
		{"uppfinna", "uppfin"},
		{"uppfinningsrikt", "uppfinningsrik"},
		{"uppfiskades", "uppfisk"},
		{"uppflamma", "uppflamm"},
		{"uppflammande", "uppflamm"},
		{"uppflugen", "uppflug"},
		{"uppflyttade", "uppflyt"},
		{"uppfor", "uppf"},
		{"uppfordrar", "uppfordr"},
		{"uppfostra", "uppfostr"},
		{"uppfostrad", "uppfostr"},
		{"uppfostrade", "uppfostr"},
		{"uppfostran", "uppfostran"},
		{"uppfostrans", "uppfostran"},
		{"uppfostrarinna", "uppfostrarin"},
		{"uppfostras", "uppfostr"},
		{"uppfostrat", "uppfostr"},
		{"uppfostrats", "uppfostrat"},
		{"uppfriska", "uppfrisk"},
		{"uppfriskade", "uppfrisk"},
		{"uppfriskande", "uppfrisk"},
		{"uppfriskar", "uppfrisk"},
		{"uppfriskat", "uppfrisk"},
		{"uppfriskningar", "uppfriskning"},
		{"uppfrätta", "uppfrät"},
		{"uppfunna", "uppfun"},
		{"uppfunnit", "uppfunnit"},
		{"uppfylde", "uppfyld"},
		{"uppfylla", "uppfyll"},
		{"uppfyllande", "uppfyll"},
		{"uppfyllandet", "uppfyll"},
		{"uppfyllas", "uppfyll"},
		{"uppfylld", "uppfylld"},
		{"uppfyllda", "uppfylld"},
		{"uppfyllde", "uppfylld"},
		{"uppfyllelse", "uppfyll"},
		{"uppfyller", "uppfyll"},
		{"uppfyllt", "uppfyllt"},
		{"uppfästade", "uppfäst"},
		{"uppfånga", "uppfång"},
		{"uppfångade", "uppfång"},
		{"uppfångades", "uppfång"},
		{"uppfångat", "uppfång"},
		{"uppfödd", "uppföd"},
		{"uppfödda", "uppföd"},
		{"uppfödt", "uppföd"},
		{"uppför", "uppför"},
		{"uppföra", "uppför"},
		{"uppförande", "uppför"},
		{"uppförd", "uppförd"},
		{"uppförda", "uppförd"},
		{"uppförde", "uppförd"},
		{"uppfördes", "uppförd"},
		{"uppfört", "uppfört"},
		{"uppgaf", "uppgaf"},
		{"uppgav", "uppgav"},
		{"uppgett", "uppget"},
		{"uppgick", "uppgick"},
		{"uppgifna", "uppgifn"},
		{"uppgift", "uppgift"},
		{"uppgiften", "uppgift"},
		{"uppgifter", "uppgift"},
		{"uppgingo", "uppgingo"},
		{"uppgiven", "uppgiv"},
		{"uppgivit", "uppgivit"},
		{"uppgjorda", "uppgjord"},
		{"uppgjorde", "uppgjord"},
		{"uppgjort", "uppgjort"},
		{"uppgräfde", "uppgräfd"},
		{"uppgående", "uppgåend"},
		{"uppgåvo", "uppgåvo"},
		{"uppgöra", "uppgör"},
		{"uppgörande", "uppgör"},
		{"upphandlingar", "upphandling"},
		{"upphet", "upp"},
		{"upphetsad", "upphets"},
		{"upphetsade", "upphets"},
		{"upphetsning", "upphetsning"},
		{"upphettade", "upphet"},
		{"upphettat", "upphet"},
		{"upphitta", "upphit"},
		{"upphjelpa", "upphjelp"},
		{"upphofvet", "upphofvet"},
		{"upphov", "upphov"},
		{"upphuggen", "upphugg"},
		{"upphäfde", "upphäfd"},
		{"upphällningen", "upphällning"},
		{"upphänga", "upphäng"},
		{"upphängda", "upphäng"},
		{"upphängde", "upphäng"},
		{"upphängdes", "upphäng"},
		{"upphävd", "upphävd"},
		{"upphöja", "upphöj"},
		{"upphöjd", "upphöjd"},
		{"upphöjda", "upphöjd"},
		{"upphöjelse", "upphöj"},
		{"upphöjning", "upphöjning"},
		{"upphöjt", "upphöjt"},
		{"upphöra", "upphör"},
		{"upphörande", "upphör"},
		{"upphörde", "upphörd"},
		{"upphört", "upphört"},
		{"uppifrån", "uppifrån"},
		{"uppiggad", "uppigg"},
		{"uppjagade", "uppjag"},
		{"uppkalla", "uppkall"},
		{"uppkallade", "uppkall"},
		{"uppkastad", "uppkast"},
		{"uppkastade", "uppkast"},
		{"uppkastades", "uppkast"},
		{"uppklev", "uppklev"},
		{"uppklättra", "uppklättr"},
		{"uppkom", "uppkom"},
		{"uppkomma", "uppkomm"},
		{"uppkommen", "uppkomm"},
		{"uppkommit", "uppkommit"},
		{"uppkrupen", "uppkrup"},
		{"uppköp", "uppköp"},
		{"upplaga", "upplag"},
		{"upplagd", "upplag"},
		{"uppland", "uppland"},
		{"upplands", "uppland"},
		{"uppledsen", "uppleds"},
		{"upplefde", "upplefd"},
		{"upplefva", "upplefv"},
		{"upplefvadt", "upplefvad"},
		{"upplefvat", "upplefv"},
		{"uppleva", "upplev"},
		{"upplevat", "upplev"},
		{"upplevde", "upplevd"},
		{"uppleve", "upplev"},
		{"upplevelse", "upplev"},
		{"upplevelsen", "upplev"},
		{"upplevelser", "upplev"},
		{"upplifva", "upplifv"},
		{"uppliva", "uppliv"},
		{"upplivad", "uppliv"},
		{"upplivade", "uppliv"},
		{"upplivande", "uppliv"},
		{"upplyft", "upplyft"},
		{"upplyfta", "upplyft"},
		{"upplyftade", "upplyft"},
		{"upplyftande", "upplyft"},
		{"upplyfte", "upplyft"},
		{"upplyftes", "upplyft"},
		{"upplysa", "upplys"},
		{"upplysning", "upplysning"},
		{"upplysningar", "upplysning"},
		{"upplysningen", "upplysning"},
		{"upplyst", "upplyst"},
		{"upplysta", "upplyst"},
		{"upplyste", "upplyst"},
		{"upplystes", "upplyst"},
		{"upplägga", "upplägg"},
		{"uppläsa", "uppläs"},
		{"uppläsningen", "uppläsning"},
		{"uppläst", "uppläst"},
		{"upplästes", "uppläst"},
		{"upplät", "upplät"},
		{"upplågade", "upplåg"},
		{"upplågande", "upplåg"},
		{"upplåste", "upplåst"},
		{"upplåta", "upplåt"},
		{"upplåtit", "upplåtit"},
		{"upplösande", "upplös"},
		{"upplösas", "upplös"},
		{"upplösning", "upplösning"},
		{"upplöst", "upplös"},
		{"upplösta", "upplös"},
		{"uppmana", "uppman"},
		{"uppmanad", "uppman"},
		{"uppmanade", "uppman"},
		{"uppmanades", "uppman"},
		{"uppmanande", "uppman"},
		{"uppmanar", "uppman"},
		{"uppmanat", "uppman"},
		{"uppmaning", "uppmaning"},
		{"uppmaningar", "uppmaning"},
		{"uppmaningen", "uppmaning"},
		{"uppmjukad", "uppmjuk"},
		{"uppmuntra", "uppmuntr"},
		{"uppmuntrad", "uppmuntr"},
		{"uppmuntrade", "uppmuntr"},
		{"uppmuntran", "uppmuntran"},
		{"uppmuntrande", "uppmuntr"},
		{"uppmuntrar", "uppmuntr"},
		{"uppmuntringar", "uppmuntring"},
		{"uppmärk", "uppmärk"},
		{"uppmärksam", "uppmärksam"},
		{"uppmärksamhet", "uppmärksam"},
		{"uppmärksamheten", "uppmärksam"},
		{"uppmärksamheter", "uppmärksam"},
		{"uppmärksamma", "uppmärksamm"},
		{"uppmärksammad", "uppmärksamm"},
		{"uppmärksamme", "uppmärksamm"},
		{"uppmärksamt", "uppmärksamt"},
		{"uppmärksarnt", "uppmärksarnt"},
		{"uppnäsa", "uppnäs"},
		{"uppnådde", "uppnåd"},
		{"uppnått", "uppnåt"},
		{"uppoffra", "uppoffr"},
		{"uppoffrade", "uppoffr"},
		{"uppoffrande", "uppoffr"},
		{"uppoffrar", "uppoffr"},
		{"uppoffras", "uppoffr"},
		{"uppoffrat", "uppoffr"},
		{"uppoffring", "uppoffring"},
		{"uppoffringar", "uppoffring"},
		{"upprepa", "upprep"},
		{"upprepad", "upprep"},
		{"upprepade", "upprep"},
		{"upprepande", "upprep"},
		{"upprepar", "upprep"},
		{"upprepas", "upprep"},
		{"uppreste", "upprest"},
		{"uppretad", "uppret"},
		{"uppretade", "uppret"},
		{"upprifva", "upprifv"},
		{"upprigtig", "upprigt"},
		{"upprigtiga", "upprigt"},
		{"upprigtigt", "upprigt"},
		{"uppriktig", "upprikt"},
		{"uppriktiga", "upprikt"},
		{"uppriktigare", "upprikt"},
		{"uppriktigaste", "upprikt"},
		{"uppriktighet", "upprikt"},
		{"uppriktigt", "upprikt"},
		{"upprivna", "upprivn"},
		{"uppror", "uppr"},
		{"upprorisk", "upprorisk"},
		{"upproriska", "upprorisk"},
		{"upproriske", "upprorisk"},
		{"upprycka", "uppryck"},
		{"uppryckande", "uppryck"},
		{"uppryckas", "uppryck"},
		{"uppryckt", "uppryck"},
		{"uppryckta", "uppryck"},
		{"upprymd", "upprymd"},
		{"uppräkna", "uppräkn"},
		{"upprätade", "upprät"},
		{"upprätt", "upprät"},
		{"upprätta", "upprät"},
		{"upprättad", "upprät"},
		{"upprättelse", "upprätt"},
		{"upprätthålla", "upprätthåll"},
		{"upprör", "upprör"},
		{"upprörande", "upprör"},
		{"upprörd", "upprörd"},
		{"upprörda", "upprörd"},
		{"upprördbet", "upprördbet"},
		{"upprörde", "upprörd"},
		{"upprördes", "upprörd"},
		{"upprördt", "upprörd"},
		{"upprört", "upprört"},
		{"uppsagd", "uppsag"},
		{"uppsala", "uppsal"},
		{"uppsalakamrat", "uppsalakamr"},
		{"uppsalamåne", "uppsalamån"},
		{"uppsalapoesien", "uppsalapoesi"},
		{"uppsatt", "uppsat"},
		{"uppsatte", "uppsat"},
		{"uppseende", "uppseend"},
		{"uppsikt", "uppsik"},
		{"uppskakad", "uppskak"},
		{"uppskakande", "uppskak"},
		{"uppskatta", "uppskat"},
		{"uppskjuta", "uppskjut"},
		{"uppskjutande", "uppskjut"},
		{"uppskjutas", "uppskjut"},
		{"uppskjutet", "uppskjutet"},
		{"uppskjutna", "uppskjutn"},
		{"uppskriva", "uppskriv"},
		{"uppskriven", "uppskriv"},
		{"uppskrämd", "uppskrämd"},
		{"uppskrämda", "uppskrämd"},
		{"uppslag", "uppslag"},
		{"uppslagen", "uppslag"},
		{"uppslaget", "uppslaget"},
		{"uppslagna", "uppslagn"},
		{"uppslitna", "uppslitn"},
		{"uppslitsade", "uppslits"},
		{"uppslog", "uppslog"},
		{"uppsluka", "uppsluk"},
		{"uppslukade", "uppsluk"},
		{"uppslukades", "uppsluk"},
		{"uppslukar", "uppsluk"},
		{"uppslukas", "uppsluk"},
		{"uppsluppen", "uppslupp"},
		{"uppsluppet", "uppsluppet"},
		{"uppsnappa", "uppsnapp"},
		{"uppsnappat", "uppsnapp"},
		{"uppsprang", "uppsprang"},
		{"uppspringande", "uppspring"},
		{"uppspädd", "uppspäd"},
		{"uppspändt", "uppspänd"},
		{"uppspärrade", "uppspärr"},
		{"uppsteg", "uppsteg"},
		{"uppstego", "uppstego"},
		{"uppstigande", "uppst"},
		{"uppstigit", "uppstigit"},
		{"uppstigning", "uppstigning"},
		{"uppstod", "uppstod"},
		{"uppstodo", "uppstodo"},
		{"uppstofferad", "uppstoffer"},
		{"uppstruket", "uppstruket"},
		{"uppställa", "uppställ"},
		{"uppställda", "uppställd"},
		{"uppställt", "uppställt"},
		{"uppstämma", "uppstämm"},
		{"uppstå", "uppstå"},
		{"uppståndelse", "uppstånd"},
		{"uppstår", "uppstår"},
		{"uppstått", "uppståt"},
		{"uppsvälld", "uppsvälld"},
		{"uppsvällda", "uppsvälld"},
		{"uppsvällt", "uppsvällt"},
		{"uppsyn", "uppsyn"},
		{"uppsäga", "uppsäg"},
		{"uppsägningstid", "uppsägningstid"},
		{"uppsände", "uppsänd"},
		{"uppsändt", "uppsänd"},
		{"uppsätta", "uppsät"},
		{"uppsätter", "uppsät"},
		{"uppsåt", "uppsåt"},
		{"uppsöka", "uppsök"},
		{"uppsökte", "uppsök"},
		{"uppt", "uppt"},
		{"upptackt", "upptack"},
		{"upptaga", "upptag"},
		{"upptagen", "upptag"},
		{"upptages", "upptag"},
		{"upptaget", "upptaget"},
		{"upptagit", "upptagit"},
		{"upptagits", "upptagit"},
		{"upptagna", "upptagn"},
		{"upptecknade", "uppteckn"},
		{"upptecknat", "uppteckn"},
		{"upptill", "upptill"},
		{"upptog", "upptog"},
		{"upptogo", "upptogo"},
		{"upptogos", "upptogo"},
		{"upptogs", "upptog"},
		{"upptornade", "upptorn"},
		{"uppträda", "uppträd"},
		{"uppträdande", "uppträd"},
		{"uppträdda", "uppträd"},
		{"uppträdde", "uppträd"},
		{"uppträde", "uppträd"},
		{"uppträden", "uppträd"},
		{"uppträder", "uppträd"},
		{"uppträdet", "uppträdet"},
		{"uppträtt", "uppträt"},
		{"upptäcka", "upptäck"},
		{"upptäckande", "upptäck"},
		{"upptäckas", "upptäck"},
		{"upptäcker", "upptäck"},
		{"upptäcks", "upptäck"},
		{"upptäckt", "upptäck"},
		{"upptäckta", "upptäck"},
		{"upptäckte", "upptäck"},
		{"upptäckten", "upptäck"},
		{"upptäckter", "upptäck"},
		{"upptäcktsfärd", "upptäcktsfärd"},
		{"upptänkligt", "upptänk"},
		{"upptåckt", "upptåck"},
		{"uppvakna", "uppvakn"},
		{"uppvaknande", "uppvakn"},
		{"uppvaknandet", "uppvakn"},
		{"uppvakta", "uppvak"},
		{"uppvaktad", "uppvak"},
		{"uppvaktningsdräkt", "uppvaktningsdräk"},
		{"uppvecklades", "uppveckl"},
		{"uppvikt", "uppvik"},
		{"uppvikta", "uppvik"},
		{"uppvisa", "uppvis"},
		{"uppväckt", "uppväck"},
		{"uppväckte", "uppväck"},
		{"uppväcktes", "uppväck"},
		{"uppvägde", "uppväg"},
		{"uppvärmd", "uppvärmd"},
		{"uppvärmt", "uppvärmt"},
		{"uppväxande", "uppväx"},
		{"uppväxt", "uppväxt"},
		{"uppväxtår", "uppväxtår"},
		{"uppätna", "uppätn"},
		{"uppå", "uppå"},
		{"uppåt", "uppåt"},
		{"uppåtvända", "uppåtvänd"},
		{"ur", "ur"},
		{"urarta", "urart"},
		{"urblekt", "urblek"},
		{"urblekta", "urblek"},
		{"urblåst", "urblåst"},
		{"urboetten", "urboet"},
		{"uren", "uren"},
		{"urens", "uren"},
		{"urer", "urer"},
		{"uret", "uret"},
		{"urgamla", "urgaml"},
		{"urgammal", "urgammal"},
		{"urholka", "urholk"},
		{"urladdade", "urlad"},
		{"urmakarebaronen", "urmakarebaron"},
		{"urmakaren", "urmak"},
		{"urmakarens", "urmak"},
		{"urmakartrall", "urmakartrall"},
		{"urmakeriet", "urmakeriet"},
		{"urmakeriprofessionen", "urmakeriprofession"},
		{"urmodig", "urmod"},
		{"urmodiga", "urmod"},
		{"urmodigt", "urmod"},
		{"urna", "urn"},
		{"urringad", "urring"},
		{"ursakta", "ursak"},
		{"ursinne", "ursin"},
		{"ursinnig", "ursinn"},
		{"ursinniga", "ursinn"},
		{"urskilde", "urskild"},
		{"urskildes", "urskild"},
		{"urskilja", "urskilj"},
		{"urskiljas", "urskilj"},
		{"urskiljbara", "urskiljbar"},
		{"urskiljer", "urskilj"},
		{"urskillning", "urskillning"},
		{"urskilning", "urskilning"},
		{"ursprungligcn", "ursprungligcn"},
		{"ursprungligen", "ursprung"},
		{"ursprungligt", "ursprung"},
		{"ursäkt", "ursäk"},
		{"ursäkta", "ursäk"},
		{"ursäktade", "ursäk"},
		{"ursäktar", "ursäk"},
		{"ursäkten", "ursäk"},
		{"ursäkter", "ursäk"},
		{"urtavla", "urtavl"},
		{"urtiden", "urtid"},
		{"urtypen", "urtyp"},
		{"urval", "urval"},
		{"urverk", "urverk"},
		{"uråldrig", "uråldr"},
		{"uråldriga", "uråldr"},
		{"usa", "usa"},
		{"usel", "usel"},
		{"uselhet", "usel"},
		{"uselt", "uselt"},
		{"usla", "usl"},
		{"usling", "usling"},
		{"uslingarna", "usling"},
		{"uslingen", "usling"},
		{"ut", "ut"},
		{"utaf", "utaf"},
		{"utan", "utan"},
		{"utandades", "utand"},
		{"utandas", "utand"},
		{"utanf", "utanf"},
		{"utanfflr", "utanfflr"},
		{"utanför", "utanför"},
		{"utanföre", "utanför"},
		{"utanläxan", "utanläxan"},
		{"utanskrifterna", "utanskrift"},
		{"utantill", "utantill"},
		{"utas", "utas"},
		{"utav", "utav"},
		{"utbe", "utb"},
		{"utbedja", "utbedj"},
		{"utbekomma", "utbekomm"},
		{"utbilda", "utbild"},
		{"utbildad", "utbild"},
		{"utbildadt", "utbildad"},
		{"utbildat", "utbild"},
		{"utbjuden", "utbjud"},
		{"utblottade", "utblot"},
		{"utblottat", "utblot"},
		{"utbrast", "utbr"},
		{"utbredd", "utbred"},
		{"utbredda", "utbred"},
		{"utbredde", "utbred"},
		{"utbrista", "utbrist"},
		{"utbristande", "utbrist"},
		{"utbrott", "utbrot"},
		{"utbrotten", "utbrot"},
		{"utbrunna", "utbrun"},
		{"utbrunnen", "utbrun"},
		{"utbryta", "utbryt"},
		{"utbröt", "utbröt"},
		{"utbygda", "utbyg"},
		{"utbyggnaden", "utbyggnad"},
		{"utbyta", "utbyt"},
		{"utbyte", "utbyt"},
		{"utbytt", "utbyt"},
		{"utbytte", "utbyt"},
		{"utbyttes", "utbyt"},
		{"utdela", "utdel"},
		{"utdelade", "utdel"},
		{"utdelaren", "utdel"},
		{"utdelning", "utdelning"},
		{"utdet", "utdet"},
		{"utdrag", "utdrag"},
		{"utdraget", "utdraget"},
		{"utdrog", "utdrog"},
		{"utdunstningen", "utdunstning"},
		{"utdöd", "utdöd"},
		{"utdömd", "utdömd"},
		{"ute", "ute"},
		{"uteblef", "uteblef"},
		{"uteblev", "uteblev"},
		{"uteblifva", "uteblifv"},
		{"uteblir", "uteblir"},
		{"uteblivande", "utebliv"},
		{"uteftcr", "uteftcr"},
		{"utefter", "uteft"},
		{"uteglömt", "uteglömt"},
		{"utesluta", "uteslut"},
		{"uteslutande", "uteslut"},
		{"utestänga", "utestäng"},
		{"utestängd", "utestäng"},
		{"utexaminerad", "utexaminer"},
		{"utfall", "utfall"},
		{"utfaller", "utfall"},
		{"utfarande", "utfar"},
		{"utfart", "utfart"},
		{"utfarten", "utfart"},
		{"utfattig", "utfatt"},
		{"utflugen", "utflug"},
		{"utflykt", "utflyk"},
		{"utflykter", "utflyk"},
		{"utflyttad", "utflyt"},
		{"utflyttade", "utflyt"},
		{"utforska", "utforsk"},
		{"utforskat", "utforsk"},
		{"utfrågades", "utfråg"},
		{"utfärd", "utfärd"},
		{"utfärdad", "utfärd"},
		{"utfärdade", "utfärd"},
		{"utfäst", "utfäst"},
		{"utför", "utför"},
		{"utföra", "utför"},
		{"utförandet", "utför"},
		{"utföras", "utför"},
		{"utförd", "utförd"},
		{"utförda", "utförd"},
		{"utförde", "utförd"},
		{"utförligt", "utför"},
		{"utförsel", "utförsel"},
		{"utfört", "utfört"},
		{"utgav", "utgav"},
		{"utgett", "utget"},
		{"utgick", "utgick"},
		{"utgift", "utgift"},
		{"utgifter", "utgift"},
		{"utgifterna", "utgift"},
		{"utgingo", "utgingo"},
		{"utgivit", "utgivit"},
		{"utgjorde", "utgjord"},
		{"utgjordes", "utgjord"},
		{"utgjort", "utgjort"},
		{"utgjuta", "utgjut"},
		{"utgjutelse", "utgjut"},
		{"utgjutelser", "utgjut"},
		{"utgjutit", "utgjutit"},
		{"utgora", "utgor"},
		{"utgrunda", "utgrund"},
		{"utgående", "utgåend"},
		{"utgång", "utgång"},
		{"utgången", "utgång"},
		{"utgångna", "utgångn"},
		{"utgångspunkt", "utgångspunk"},
		{"utgår", "utgår"},
		{"utgåva", "utgåv"},
		{"utgåvan", "utgåvan"},
		{"utgör", "utgör"},
		{"utgöra", "utgör"},
		{"utgöt", "utgöt"},
		{"uthärda", "uthärd"},
		{"uthärdade", "uthärd"},
		{"uthärdar", "uthärd"},
		{"uthärdas", "uthärd"},
		{"uthärdat", "uthärd"},
		{"uthärdligt", "uthärd"},
		{"uthållande", "uthåll"},
		{"uti", "uti"},
		{"utifrån", "utifrån"},
		{"utkallade", "utkall"},
		{"utkasta", "utkast"},
		{"utkastad", "utkast"},
		{"utkastade", "utkast"},
		{"utkik", "utkik"},
		{"utkiksögon", "utkiksögon"},
		{"utkom", "utkom"},
		{"utkämpad", "utkämp"},
		{"utlagt", "utlag"},
		{"utlandet", "utl"},
		{"utledsen", "utleds"},
		{"utlofvade", "utlofv"},
		{"utlopp", "utlopp"},
		{"utlovade", "utlov"},
		{"utlupen", "utlup"},
		{"utländska", "utländsk"},
		{"utlänning", "utlänning"},
		{"utlät", "utlät"},
		{"utlåna", "utlån"},
		{"utlånade", "utlån"},
		{"utlånta", "utlånt"},
		{"utlåtandet", "utlåt"},
		{"utlåter", "utlåt"},
		{"utlösning", "utlösning"},
		{"utlöst", "utlöst"},
		{"utmanande", "utman"},
		{"utmark", "utmark"},
		{"utmarscherande", "utmarscher"},
		{"utmattad", "utmat"},
		{"utmed", "utmed"},
		{"utminutera", "utminuter"},
		{"utminuterades", "utminuter"},
		{"utmärglade", "utmärgl"},
		{"utmärka", "utmärk"},
		{"utmärkelse", "utmärk"},
		{"utmärker", "utmärk"},
		{"utmärkt", "utmärk"},
		{"utmärkta", "utmärk"},
		{"utmärkte", "utmärk"},
		{"utmätas", "utmät"},
		{"utnyttjar", "utnyttj"},
		{"utnämdes", "utnämd"},
		{"utnämnd", "utnämnd"},
		{"utnämner", "utnämn"},
		{"utnött", "utnöt"},
		{"utom", "utom"},
		{"utomdess", "utomdess"},
		{"utomhus", "utomhus"},
		{"utomordentlig", "utomordent"},
		{"utomordentliga", "utomordent"},
		{"utomordentligt", "utomordent"},
		{"utomstående", "utomståend"},
		{"utpeka", "utpek"},
		{"utpekad", "utpek"},
		{"utpekat", "utpek"},
		{"utpinad", "utpin"},
		{"utplåna", "utplån"},
		{"utplånade", "utplån"},
		{"utplånar", "utplån"},
		{"utplånas", "utplån"},
		{"utplånat", "utplån"},
		{"utpresserska", "utpressersk"},
		{"utreda", "utred"},
		{"utrikes", "utrik"},
		{"utrikesminister", "utrikesminist"},
		{"utrop", "utrop"},
		{"utropa", "utrop"},
		{"utropade", "utrop"},
		{"utropet", "utropet"},
		{"utropstecken", "utropsteck"},
		{"utrusande", "utrus"},
		{"utrustad", "utrust"},
		{"utrustat", "utrust"},
		{"utrycka", "utryck"},
		{"utrymda", "utrymd"},
		{"utrymme", "utrymm"},
		{"utrymmet", "utrymmet"},
		{"uträknad", "uträkn"},
		{"uträknade", "uträkn"},
		{"uträknat", "uträkn"},
		{"uträkning", "uträkning"},
		{"uträkningar", "uträkning"},
		{"uträtta", "uträt"},
		{"uträttade", "uträt"},
		{"uträttat", "uträt"},
		{"utrökt", "utrök"},
		{"utröna", "utrön"},
		{"utrönt", "utrönt"},
		{"utsago", "utsago"},
		{"utsagt", "utsag"},
		{"utsatt", "utsat"},
		{"utsatta", "utsat"},
		{"utscende", "utscend"},
		{"utsedd", "utsed"},
		{"utsedda", "utsed"},
		{"utseende", "utseend"},
		{"utseendet", "utseendet"},
		{"utseendets", "utseendet"},
		{"utsigt", "uts"},
		{"utsigten", "uts"},
		{"utsigter", "uts"},
		{"utsikt", "utsik"},
		{"utsikten", "utsik"},
		{"utsikter", "utsik"},
		{"utsikterna", "utsik"},
		{"utsiktsplats", "utsiktsplat"},
		{"utsirad", "utsir"},
		{"utsirade", "utsir"},
		{"utsirat", "utsir"},
		{"utskickad", "utskick"},
		{"utskjutande", "utskjut"},
		{"utskratta", "utskrat"},
		{"utskrattad", "utskrat"},
		{"utskriken", "utskrik"},
		{"utskyndande", "utskynd"},
		{"utskämmas", "utskämm"},
		{"utslag", "utslag"},
		{"utslagen", "utslag"},
		{"utslaget", "utslaget"},
		{"utslagna", "utslagn"},
		{"utsliten", "utslit"},
		{"utslitet", "utslitet"},
		{"utslitna", "utslitn"},
		{"utslockna", "utslockn"},
		{"utsläckt", "utsläck"},
		{"utslätat", "utslät"},
		{"utslår", "utslår"},
		{"utspana", "utspan"},
		{"utspanat", "utspan"},
		{"utsparkad", "utspark"},
		{"utspelats", "utspelat"},
		{"utspridt", "utsprid"},
		{"utspringande", "utspring"},
		{"utspritt", "utsprit"},
		{"utspunnen", "utspun"},
		{"utspända", "utspänd"},
		{"utspärrade", "utspärr"},
		{"utspökade", "utspök"},
		{"utstaende", "utstaend"},
		{"utstickande", "utstick"},
		{"utstod", "utstod"},
		{"utsträckas", "utsträck"},
		{"utsträckt", "utsträck"},
		{"utsträckta", "utsträck"},
		{"utsträckte", "utsträck"},
		{"utstråladc", "utstråladc"},
		{"utstrålade", "utstrål"},
		{"utströddes", "utströd"},
		{"utströmmar", "utströmm"},
		{"utströmmat", "utströmm"},
		{"utstuckit", "utstuckit"},
		{"utstyrd", "utstyrd"},
		{"utstyrda", "utstyrd"},
		{"utstyrt", "utstyrt"},
		{"utställd", "utställd"},
		{"utstående", "utståend"},
		{"utståndna", "utståndn"},
		{"utstått", "utståt"},
		{"utstött", "utstöt"},
		{"utstötta", "utstöt"},
		{"utstöttes", "utstöt"},
		{"utsvulten", "utsvult"},
		{"utsvält", "utsvält"},
		{"utsvävande", "utsväv"},
		{"utsäde", "utsäd"},
		{"utsäga", "utsäg"},
		{"utsätta", "utsät"},
		{"utsått", "utsåt"},
		{"utsökt", "utsök"},
		{"utsökta", "utsök"},
		{"uttaga", "uttag"},
		{"uttages", "uttag"},
		{"uttagna", "uttagn"},
		{"uttal", "uttal"},
		{"uttala", "uttal"},
		{"uttalade", "uttal"},
		{"uttalades", "uttal"},
		{"uttalandet", "uttal"},
		{"uttalar", "uttal"},
		{"uttalas", "uttal"},
		{"uttalat", "uttal"},
		{"uttalet", "uttalet"},
		{"uttog", "uttog"},
		{"uttorkade", "uttork"},
		{"uttorkat", "uttork"},
		{"uttryck", "uttryck"},
		{"uttrycka", "uttryck"},
		{"uttrycker", "uttryck"},
		{"uttrycket", "uttrycket"},
		{"uttryckligen", "uttryck"},
		{"uttrycksfull", "uttrycksfull"},
		{"uttrycksfulla", "uttrycksfull"},
		{"uttrycksfullare", "uttrycksfull"},
		{"uttrycksfullt", "uttrycksfull"},
		{"uttrycksfylla", "uttrycksfyll"},
		{"uttryckssätt", "uttryckssät"},
		{"uttryckt", "uttryck"},
		{"uttryckte", "uttryck"},
		{"uttrötta", "uttröt"},
		{"uttröttad", "uttröt"},
		{"uttyda", "uttyd"},
		{"uttydas", "uttyd"},
		{"uttämt", "uttämt"},
		{"uttänjda", "uttänjd"},
		{"uttänka", "uttänk"},
		{"uttänkt", "uttänk"},
		{"uttömda", "uttömd"},
		{"uttömt", "uttömt"},
		{"utur", "utur"},
		{"utvald", "utvald"},
		{"utvalda", "utvald"},
		{"utvandring", "utvandring"},
		{"utvandringar", "utvandring"},
		{"utvandringarna", "utvandring"},
		{"utveckla", "utveckl"},
		{"utvecklad", "utveckl"},
		{"utvecklade", "utveckl"},
		{"utvecklades", "utveckl"},
		{"utvecklar", "utveckl"},
		{"utvecklat", "utveckl"},
		{"utvecklingen", "utveckling"},
		{"utverka", "utverk"},
		{"utvidga", "utvidg"},
		{"utvidgas", "utvidg"},
		{"utvidgningar", "utvidgning"},
		{"utvisade", "utvis"},
		{"utvisar", "utvis"},
		{"utväg", "utväg"},
		{"utvägar", "utväg"},
		{"utvägen", "utväg"},
		{"utvälja", "utvälj"},
		{"utvända", "utvänd"},
		{"utvärdshus", "utvärdshus"},
		{"utvärdshusen", "utvärdshus"},
		{"utvärtes", "utvärt"},
		{"utäcklat", "utäckl"},
		{"utåt", "utåt"},
		{"utöfva", "utöfv"},
		{"utöfvade", "utöfv"},
		{"utöfvandet", "utöfv"},
		{"utöfvat", "utöfv"},
		{"utöfver", "utöfv"},
		{"utöva", "utöv"},
		{"utövade", "utöv"},
		{"utövar", "utöv"},
		{"utövat", "utöv"},
		{"utöver", "utöv"},
		{"v", "v"},
		{"va", "va"},
		{"vackar", "vack"},
		{"vacker", "vack"},
		{"vackert", "vackert"},
		{"vackla", "vackl"},
		{"vacklade", "vackl"},
		{"vacklande", "vackl"},
		{"vacklar", "vackl"},
		{"vackra", "vackr"},
		{"vackrare", "vackr"},
		{"vackrast", "vackr"},
		{"vackraste", "vackr"},
		{"vackre", "vackr"},
		{"vad", "vad"},
		{"vadade", "vad"},
		{"vadan", "vadan"},
		{"vadar", "vad"},
		{"vadat", "vad"},
		{"vade", "vad"},
		{"vaden", "vad"},
		{"vaderetrosalva", "vaderetrosalv"},
		{"vaderna", "vad"},
		{"vadis", "vadis"},
		{"vadmal", "vadmal"},
		{"vadmals", "vadmal"},
		{"vadmalsöverdrag", "vadmalsöverdrag"},
		{"vador", "vad"},
		{"vadstenaliljan", "vadstenaliljan"},
		{"vadstenaätt", "vadstenaät"},
		{"vaff", "vaff"},
		{"vag", "vag"},
		{"vagade", "vag"},
		{"vagant", "vagant"},
		{"vagarna", "vag"},
		{"vagat", "vag"},
		{"vagen", "vag"},
		{"vagga", "vagg"},
		{"vaggade", "vagg"},
		{"vaggamde", "vaggamd"},
		{"vaggan", "vaggan"},
		{"vaggande", "vagg"},
		{"vaggar", "vagg"},
		{"vaggarna", "vagg"},
		{"vaggat", "vagg"},
		{"vaggen", "vagg"},
		{"vaggfast", "vaggf"},
		{"vagn", "vagn"},
		{"vagnar", "vagn"},
		{"vagnarna", "vagn"},
		{"vagnen", "vagn"},
		{"vagnshjul", "vagnshjul"},
		{"vagor", "vag"},
		{"vagorna", "vag"},
		{"vagskål", "vagskål"},
		{"vaja", "vaj"},
		{"vajade", "vaj"},
		{"vajande", "vaj"},
		{"vajar", "vaj"},
		{"vaka", "vak"},
		{"vakade", "vak"},
		{"vakan", "vakan"},
		{"vakandet", "vak"},
		{"vakar", "vak"},
		{"vakas", "vak"},
		{"vakat", "vak"},
		{"vaken", "vak"},
		{"vaket", "vaket"},
		{"vakllen", "vakll"},
		{"vakna", "vakn"},
		{"vaknade", "vakn"},
		{"vaknar", "vakn"},
		{"vaknat", "vakn"},
		{"vakne", "vakn"},
		{"vaksamhet", "vaksam"},
		{"vaksamma", "vaksamm"},
		{"vaksamme", "vaksamm"},
		{"vaksamt", "vaksamt"},
		{"vakt", "vakt"},
		{"vakta", "vakt"},
		{"vaktande", "vakt"},
		{"vaktar", "vakt"},
		{"vaktare", "vakt"},
		{"vaktarinna", "vaktarin"},
		{"vaktarinnan", "vaktarinnan"},
		{"vaktas", "vakt"},
		{"vaktel", "vaktel"},
		{"vakten", "vakt"},
		{"vakter", "vakt"},
		{"vaktmästare", "vaktmäst"},
		{"vaktmästaren", "vaktmäst"},
		{"vaktmästarn", "vaktmästarn"},
		{"vaktparad", "vaktpar"},
		{"vaktpatrull", "vaktpatrull"},
		{"val", "val"},
		{"valbekanta", "valbekant"},
		{"valborg", "valborg"},
		{"valborgselden", "valborgseld"},
		{"vald", "vald"},
		{"valda", "vald"},
		{"valdaste", "vald"},
		{"valde", "vald"},
		{"valdsamt", "valdsamt"},
		{"valdt", "vald"},
		{"valerius", "valerius"},
		{"valet", "valet"},
		{"valhänt", "valhänt"},
		{"valkar", "valk"},
		{"vall", "vall"},
		{"vallack", "vallack"},
		{"vallar", "vall"},
		{"vallerskans", "vallerskan"},
		{"vallgossen", "vallgoss"},
		{"vallmo", "vallmo"},
		{"vallmoklanning", "vallmoklanning"},
		{"vallmorött", "vallmoröt"},
		{"valmöten", "valmöt"},
		{"valnöt", "valnöt"},
		{"valnötskåp", "valnötskåp"},
		{"valp", "valp"},
		{"valpar", "valp"},
		{"valplatsen", "valplats"},
		{"vals", "val"},
		{"valt", "valt"},
		{"valthorn", "valthorn"},
		{"valthornet", "valthornet"},
		{"valurnan", "valurnan"},
		{"valuta", "valut"},
		{"valv", "valv"},
		{"valven", "valv"},
		{"valvsegel", "valvsegel"},
		{"van", "van"},
		{"vana", "van"},
		{"vanan", "vanan"},
		{"vanartig", "vanart"},
		{"vand", "vand"},
		{"vanda", "vand"},
		{"vande", "vand"},
		{"vandel", "vandel"},
		{"vandla", "vandl"},
		{"vandra", "vandr"},
		{"vandrade", "vandr"},
		{"vandrande", "vandr"},
		{"vandrar", "vandr"},
		{"vandrare", "vandr"},
		{"vandrarn", "vandrarn"},
		{"vandrat", "vandr"},
		{"vandring", "vandring"},
		{"vandringar", "vandring"},
		{"vandringarne", "vandring"},
		{"vandringen", "vandring"},
		{"vandringsmannen", "vandringsman"},
		{"vandringsmän", "vandringsmän"},
		{"vandringsstaven", "vandringsstav"},
		{"vane", "van"},
		{"vanför", "vanför"},
		{"vanhederligt", "vanheder"},
		{"vaningen", "vaning"},
		{"vanka", "vank"},
		{"vankade", "vank"},
		{"vankades", "vank"},
		{"vankas", "vank"},
		{"vankelmod", "vankelmod"},
		{"vankfri", "vankfri"},
		{"vanlig", "van"},
		{"vanliga", "van"},
		{"vanlige", "van"},
		{"vanligen", "van"},
		{"vanligt", "van"},
		{"vanligtvis", "vanligtvis"},
		{"vann", "vann"},
		{"vanor", "van"},
		{"vans", "van"},
		{"vansinne", "vansin"},
		{"vansinnig", "vansinn"},
		{"vansinniga", "vansinn"},
		{"vansinnige", "vansinn"},
		{"vansinnigt", "vansinn"},
		{"vansinning", "vansinning"},
		{"vanskapligt", "vanskap"},
		{"vanskapt", "vanskapt"},
		{"vanskapte", "vanskapt"},
		{"vansklig", "vansk"},
		{"vanskliga", "vansk"},
		{"vanslägtas", "vansläg"},
		{"vanstälde", "vanstäld"},
		{"vanställa", "vanställ"},
		{"vanställd", "vanställd"},
		{"vanställda", "vanställd"},
		{"vant", "vant"},
		{"vanta", "vant"},
		{"vantade", "vant"},
		{"vantarne", "vant"},
		{"vanvett", "vanvet"},
		{"vanvettig", "vanvett"},
		{"vanvettigt", "vanvett"},
		{"vanvördigt", "vanvörd"},
		{"vanärans", "vanäran"},
		{"vanäras", "vanär"},
		{"vapen", "vap"},
		{"vapnen", "vapn"},
		{"var", "var"},
		{"vara", "var"},
		{"varade", "var"},
		{"varaktiga", "varakt"},
		{"varaktighet", "varakt"},
		{"varan", "varan"},
		{"varande", "var"},
		{"varandr", "varandr"},
		{"varandra", "varandr"},
		{"varandras", "varandr"},
		{"varann", "varan"},
		{"varar", "var"},
		{"varardra", "varardr"},
		{"varas", "var"},
		{"varat", "var"},
		{"varav", "varav"},
		{"varda", "vard"},
		{"vardagarna", "vardag"},
		{"vardagen", "vardag"},
		{"vardagens", "vardag"},
		{"vardaglig", "vardag"},
		{"vardagliga", "vardag"},
		{"vardagligt", "vardag"},
		{"vardags", "vardag"},
		{"vardagsklänning", "vardagsklänning"},
		{"vardagslag", "vardagslag"},
		{"vardagsliv", "vardagsliv"},
		{"vardagsmuntert", "vardagsmuntert"},
		{"vardagsrum", "vardagsrum"},
		{"vardagsrummet", "vardagsrummet"},
		{"vardagssaker", "vardagssak"},
		{"vardagsskjortan", "vardagsskjortan"},
		{"varde", "vard"},
		{"varden", "vard"},
		{"vardera", "varder"},
		{"vardetmöjligt", "vardetmöj"},
		{"vare", "var"},
		{"varefter", "vareft"},
		{"varelse", "var"},
		{"varelsedrift", "varelsedrift"},
		{"varelsen", "var"},
		{"varelsens", "var"},
		{"varelser", "var"},
		{"varelserna", "var"},
		{"varelsernas", "var"},
		{"varemot", "varemot"},
		{"varen", "var"},
		{"varenda", "varend"},
		{"varer", "var"},
		{"varest", "varest"},
		{"varf", "varf"},
		{"varfor", "varf"},
		{"varför", "varför"},
		{"vari", "vari"},
		{"variant", "variant"},
		{"varibland", "varibland"},
		{"variden", "varid"},
		{"varie", "vari"},
		{"varierade", "varier"},
		{"varifran", "varifran"},
		{"varifrån", "varifrån"},
		{"varigenom", "varigenom"},
		{"varit", "varit"},
		{"varje", "varj"},
		{"varjehanda", "varjehand"},
		{"vark", "vark"},
		{"varken", "vark"},
		{"varkeo", "varkeo"},
		{"varld", "varld"},
		{"varldar", "varld"},
		{"varligt", "var"},
		{"varm", "varm"},
		{"varma", "varm"},
		{"varmare", "varm"},
		{"varmaste", "varm"},
		{"varmed", "varmed"},
		{"varmt", "varmt"},
		{"varna", "varn"},
		{"varnagel", "varnagel"},
		{"varnar", "varn"},
		{"varnat", "varn"},
		{"varning", "varning"},
		{"varningar", "varning"},
		{"varningen", "varning"},
		{"varom", "varom"},
		{"varor", "var"},
		{"varorna", "var"},
		{"varpå", "varpå"},
		{"vars", "var"},
		{"varsam", "varsam"},
		{"varsamma", "varsamm"},
		{"varsamt", "varsamt"},
		{"varse", "vars"},
		{"varseblef", "varseblef"},
		{"varseblefvo", "varseblefvo"},
		{"varseblev", "varseblev"},
		{"varsebli", "varsebli"},
		{"varseblir", "varseblir"},
		{"varseblivit", "varseblivit"},
		{"varsel", "varsel"},
		{"varsnade", "varsn"},
		{"varsnat", "varsn"},
		{"vart", "vart"},
		{"vartannat", "vartan"},
		{"vartdera", "vartder"},
		{"vartenda", "vartend"},
		{"varthän", "varthän"},
		{"vartill", "vartill"},
		{"varulager", "varulag"},
		{"varunder", "varund"},
		{"varuti", "varuti"},
		{"varv", "varv"},
		{"varvid", "varvid"},
		{"vas", "vas"},
		{"vasabron", "vasabron"},
		{"vasaprinsens", "vasaprins"},
		{"vasar", "vas"},
		{"vasasvenskt", "vasasvensk"},
		{"vasen", "vas"},
		{"vasenla", "vasenl"},
		{"vaser", "vas"},
		{"vaserna", "vas"},
		{"vasken", "vask"},
		{"vass", "vass"},
		{"vassa", "vass"},
		{"vassen", "vass"},
		{"vassrör", "vassrör"},
		{"vasst", "vasst"},
		{"vatt", "vatt"},
		{"vatten", "vatt"},
		{"vattenbutiken", "vattenbutik"},
		{"vattendroppar", "vattendropp"},
		{"vattenglas", "vattengl"},
		{"vattenglaset", "vattenglaset"},
		{"vattenhink", "vattenhink"},
		{"vattenkamla", "vattenkaml"},
		{"vattenkannan", "vattenkannan"},
		{"vattenkaraffin", "vattenkaraffin"},
		{"vattenkaraffinen", "vattenkaraffin"},
		{"vattenledning", "vattenledning"},
		{"vattensoppa", "vattensopp"},
		{"vattentunna", "vattentun"},
		{"vattentäta", "vattentät"},
		{"vattenyta", "vattenyt"},
		{"vattenytan", "vattenytan"},
		{"vattna", "vattn"},
		{"vattnade", "vattn"},
		{"vattnar", "vattn"},
		{"vattnas", "vattn"},
		{"vattnat", "vattn"},
		{"vattnen", "vattn"},
		{"vattnet", "vattnet"},
		{"vattnets", "vattnet"},
		{"vattniga", "vattn"},
		{"vattningen", "vattning"},
		{"vattrad", "vattr"},
		{"vaxade", "vax"},
		{"vaxdocka", "vaxdock"},
		{"vaxduken", "vaxduk"},
		{"vaxgult", "vaxgult"},
		{"vaxte", "vaxt"},
		{"vcck", "vcck"},
		{"vcttig", "vcttig"},
		{"vd", "vd"},
		{"vdelse", "vdels"},
		{"ve", "ve"},
		{"veck", "veck"},
		{"vecka", "veck"},
		{"veckade", "veck"},
		{"veckan", "veckan"},
		{"veckas", "veck"},
		{"vecken", "veck"},
		{"vecklade", "veckl"},
		{"vecklas", "veckl"},
		{"vecklat", "veckl"},
		{"vecko", "vecko"},
		{"veckodagarna", "veckodag"},
		{"veckor", "veck"},
		{"veckorna", "veck"},
		{"veckors", "veckor"},
		{"veckoräfst", "veckoräfst"},
		{"ved", "ved"},
		{"veden", "ved"},
		{"vederbörlig", "vederbör"},
		{"vederbörligen", "vederbör"},
		{"vederfående", "vederfåend"},
		{"vedergälla", "vedergäll"},
		{"vederkvickelse", "vederkvick"},
		{"vederlägga", "vederlägg"},
		{"vederläggning", "vederläggning"},
		{"vedermälen", "vedermäl"},
		{"vedermöda", "vedermöd"},
		{"vedermödor", "vedermöd"},
		{"vederqvicka", "vederqvick"},
		{"vederstyggligaste", "vederstygg"},
		{"vederstyggligt", "vederstygg"},
		{"vedervärdigt", "vedervärd"},
		{"vedkorg", "vedkorg"},
		{"vedkubbarna", "vedkubb"},
		{"vedskutorna", "vedskut"},
		{"vedträ", "vedträ"},
		{"vegetation", "vegetation"},
		{"veitsdans", "veitsdan"},
		{"vek", "vek"},
		{"veka", "vek"},
		{"vekar", "vek"},
		{"veke", "vek"},
		{"veklig", "vek"},
		{"veknande", "vekn"},
		{"veknar", "vekn"},
		{"vekt", "vekt"},
		{"velade", "vel"},
		{"velat", "vel"},
		{"velin", "velin"},
		{"velocipedtävlan", "velocipedtävlan"},
		{"velom", "velom"},
		{"vem", "vem"},
		{"vember", "vemb"},
		{"vemodig", "vemod"},
		{"vemodiga", "vemod"},
		{"vemodigt", "vemod"},
		{"vemodsvår", "vemodsvår"},
		{"vems", "vem"},
		{"ven", "ven"},
		{"veno", "veno"},
		{"venster", "venst"},
		{"venstra", "venstr"},
		{"venus", "venus"},
		{"ver", "ver"},
		{"verallt", "verallt"},
		{"veranda", "verand"},
		{"verandan", "verandan"},
		{"verandaräcket", "verandaräcket"},
		{"verb", "verb"},
		{"verbena", "verben"},
		{"verbum", "verbum"},
		{"verdslig", "verds"},
		{"verdsligt", "verds"},
		{"verk", "verk"},
		{"verka", "verk"},
		{"verkade", "verk"},
		{"verkan", "verkan"},
		{"verkande", "verk"},
		{"verkar", "verk"},
		{"verkat", "verk"},
		{"verken", "verk"},
		{"verket", "verket"},
		{"verkhgen", "verkhg"},
		{"verklig", "verk"},
		{"verkliga", "verk"},
		{"verkligare", "verk"},
		{"verkligaste", "verk"},
		{"verkligen", "verk"},
		{"verklighet", "verk"},
		{"verkligheten", "verk"},
		{"verklighetens", "verk"},
		{"verkligt", "verk"},
		{"verksam", "verksam"},
		{"verksamhet", "verksam"},
		{"verksamheten", "verksam"},
		{"verksamhetsraseri", "verksamhetsraseri"},
		{"verksamma", "verksamm"},
		{"verksammaste", "verksamm"},
		{"verkstad", "verkst"},
		{"verkstaden", "verkstad"},
		{"verkställa", "verkställ"},
		{"verkställande", "verkställ"},
		{"verkställare", "verkställ"},
		{"verkställer", "verkställ"},
		{"verkställighet", "verkstäl"},
		{"verkstält", "verkstält"},
		{"verksäm", "verksäm"},
		{"verktyg", "verktyg"},
		{"verld", "verld"},
		{"verlden", "verld"},
		{"verldens", "verld"},
		{"verldsliga", "verlds"},
		{"verläppen", "verläpp"},
		{"vers", "ver"},
		{"versen", "vers"},
		{"verser", "vers"},
		{"versrad", "versr"},
		{"versrader", "versrad"},
		{"vester", "vest"},
		{"vesterut", "vesterut"},
		{"vestindiefarare", "vestindiefar"},
		{"vestindiefararen", "vestindiefar"},
		{"vestlig", "vest"},
		{"vestliga", "vest"},
		{"vestra", "vestr"},
		{"vestvart", "vestvart"},
		{"vet", "vet"},
		{"veta", "vet"},
		{"vetande", "vet"},
		{"vetat", "vet"},
		{"vetdithanfordendårgången", "vetdithanfordendårgång"},
		{"vete", "vet"},
		{"vetebulle", "vetebull"},
		{"vetenskapen", "vetenskap"},
		{"vetenskapens", "vetenskap"},
		{"vetenskaperna", "vetenskap"},
		{"vetenskaplig", "vetenskap"},
		{"vetenskapliga", "vetenskap"},
		{"vetenskapsakademien", "vetenskapsakademi"},
		{"vetenskapsman", "vetenskapsman"},
		{"vetgirigare", "vetgir"},
		{"vetgirighet", "vetgir"},
		{"vetgirigt", "vetgir"},
		{"vetskap", "vetskap"},
		{"vett", "vett"},
		{"vettet", "vettet"},
		{"vettig", "vett"},
		{"vettigt", "vett"},
		{"vettlös", "vettlös"},
		{"vettlöst", "vettlös"},
		{"vev", "vev"},
		{"vexelvis", "vexelvis"},
		{"vexlat", "vexl"},
		{"vhl", "vhl"},
		{"vhlgar", "vhlgar"},
		{"vi", "vi"},
		{"vice", "vic"},
		{"vichyvatten", "vichyvat"},
		{"vicka", "vick"},
		{"vickan", "vickan"},
		{"vickningar", "vickning"},
		{"vid", "vid"},
		{"vida", "vid"},
		{"vidare", "vid"},
		{"vidblev", "vidblev"},
		{"vidbliva", "vidbliv"},
		{"vidblivit", "vidblivit"},
		{"vidden", "vidd"},
		{"vidgad", "vidg"},
		{"vidgade", "vidg"},
		{"vidgades", "vidg"},
		{"vidgande", "vidg"},
		{"vidgar", "vidg"},
		{"vidgår", "vidgår"},
		{"vidhjärtad", "vidhjärt"},
		{"vidhänga", "vidhäng"},
		{"vidhålla", "vidhåll"},
		{"vidhåller", "vidhåll"},
		{"vidkom", "vidkom"},
		{"vidkommer", "vidkomm"},
		{"vidlyftig", "vidlyft"},
		{"vidlyftiga", "vidlyft"},
		{"vidlyftigare", "vidlyft"},
		{"vidlyftigaste", "vidlyft"},
		{"vidrig", "vidr"},
		{"vidriga", "vidr"},
		{"vidrigt", "vidr"},
		{"vidrör", "vidrör"},
		{"vidröra", "vidrör"},
		{"vidrörde", "vidrörd"},
		{"vidskepelse", "vidskep"},
		{"vidt", "vidt"},
		{"vidtaga", "vidtag"},
		{"vidtalade", "vidtal"},
		{"vidtalat", "vidtal"},
		{"vidtogo", "vidtogo"},
		{"vidunder", "vidund"},
		{"vidunderligt", "vidunder"},
		{"vidåhörandet", "vidåhör"},
		{"vidöppen", "vidöpp"},
		{"vidöppna", "vidöppn"},
		{"vie", "vie"},
		{"vieillissant", "vieillissant"},
		{"vieux", "vieux"},
		{"vifta", "vift"},
		{"viftade", "vift"},
		{"viftande", "vift"},
		{"viftning", "viftning"},
		{"viftningar", "viftning"},
		{"vig", "vig"},
		{"vigas", "vig"},
		{"vighet", "vig"},
		{"vigilans", "vigilan"},
		{"vigilansen", "vigilans"},
		{"vigselattest", "vigselattest"},
		{"vigseln", "vigseln"},
		{"vigselringen", "vigselring"},
		{"vigtig", "vigt"},
		{"vigtiga", "vigt"},
		{"vigtigt", "vigt"},
		{"vii", "vii"},
		{"viii", "viii"},
		{"viile", "viil"},
		{"vik", "vik"},
		{"vika", "vik"},
		{"vikarna", "vik"},
		{"viker", "vik"},
		{"vikingarne", "viking"},
		{"vikit", "vikit"},
		{"vikt", "vikt"},
		{"vikten", "vikt"},
		{"viktig", "vikt"},
		{"viktiga", "vikt"},
		{"viktigare", "vikt"},
		{"viktigaste", "vikt"},
		{"viktigt", "vikt"},
		{"viktor", "vikt"},
		{"vil", "vil"},
		{"vila", "vil"},
		{"vilade", "vil"},
		{"vilan", "vilan"},
		{"vilande", "vil"},
		{"vilar", "vil"},
		{"vilat", "vil"},
		{"vild", "vild"},
		{"vilda", "vild"},
		{"vildand", "vildand"},
		{"vildare", "vild"},
		{"vildarne", "vild"},
		{"vildaste", "vild"},
		{"vilddjur", "vilddjur"},
		{"vilde", "vild"},
		{"vildhet", "vild"},
		{"vildheten", "vild"},
		{"vildmarkens", "vildmark"},
		{"vildt", "vild"},
		{"vildvin", "vildvin"},
		{"vildänder", "vildänd"},
		{"vili", "vili"},
		{"vilie", "vili"},
		{"vilja", "vilj"},
		{"viljan", "viljan"},
		{"viljas", "vilj"},
		{"viljeakt", "viljeak"},
		{"viljes", "vilj"},
		{"vilka", "vilk"},
		{"vilkas", "vilk"},
		{"vilken", "vilk"},
		{"vilkens", "vilk"},
		{"vilket", "vilket"},
		{"vilkets", "vilket"},
		{"vilkor", "vilk"},
		{"vilkoren", "vilkor"},
		{"vill", "vill"},
		{"villa", "vill"},
		{"villan", "villan"},
		{"villande", "vill"},
		{"villastäderna", "villastäd"},
		{"villc", "villc"},
		{"ville", "vill"},
		{"villebradet", "villebradet"},
		{"villebråd", "villebråd"},
		{"villervalla", "villervall"},
		{"villfarelse", "villfar"},
		{"villfarelser", "villfar"},
		{"villfarit", "villfarit"},
		{"villig", "vil"},
		{"villigt", "vil"},
		{"villkor", "villk"},
		{"villkoren", "villkor"},
		{"villkoret", "villkoret"},
		{"villor", "vill"},
		{"villornas", "vill"},
		{"villovägar", "villoväg"},
		{"villrådig", "villråd"},
		{"villrådiga", "villråd"},
		{"viloplats", "viloplat"},
		{"vilse", "vils"},
		{"vilsekommen", "vilsekomm"},
		{"vilsen", "vils"},
		{"vilsna", "vilsn"},
		{"vilt", "vilt"},
		{"vimla", "viml"},
		{"vimlad", "viml"},
		{"vimlade", "viml"},
		{"vimmelkantig", "vimmelkant"},
		{"vin", "vin"},
		{"vinberg", "vinberg"},
		{"vinbuteljen", "vinbutelj"},
		{"vinbären", "vinbär"},
		{"vind", "vind"},
		{"vindande", "vind"},
		{"vindar", "vind"},
		{"vindarnas", "vind"},
		{"vindarne", "vind"},
		{"vinddrag", "vinddrag"},
		{"vinddraget", "vinddraget"},
		{"vinden", "vind"},
		{"vindens", "vind"},
		{"vindfläkt", "vindfläk"},
		{"vindil", "vindil"},
		{"vindlar", "vindl"},
		{"vindsdörr", "vindsdörr"},
		{"vindsdörren", "vindsdörr"},
		{"vindsgluggen", "vindsglugg"},
		{"vindskamma", "vindskamm"},
		{"vindskammare", "vindskamm"},
		{"vindskammaren", "vindskamm"},
		{"vindskupa", "vindskup"},
		{"vindskupans", "vindskupan"},
		{"vindslitet", "vindslitet"},
		{"vindsrummet", "vindsrummet"},
		{"vindstilla", "vindstill"},
		{"vindstrappan", "vindstrappan"},
		{"vindstöt", "vindstöt"},
		{"vinens", "vin"},
		{"viner", "vin"},
		{"vinet", "vinet"},
		{"vinets", "vinet"},
		{"vinflaskan", "vinflaskan"},
		{"ving", "ving"},
		{"vingar", "ving"},
		{"vingarna", "ving"},
		{"vingarnas", "ving"},
		{"vingarne", "ving"},
		{"vingars", "vingar"},
		{"vingen", "ving"},
		{"vinglade", "vingl"},
		{"vingslag", "vingslag"},
		{"vingsus", "vingsus"},
		{"vinhandeln", "vinhandeln"},
		{"vink", "vink"},
		{"vinka", "vink"},
		{"vinkade", "vink"},
		{"vinkades", "vink"},
		{"vinkande", "vink"},
		{"vinkar", "vink"},
		{"vinkat", "vink"},
		{"vinkel", "vinkel"},
		{"vinkeln", "vinkeln"},
		{"vinken", "vink"},
		{"vinklar", "vinkl"},
		{"vinklarna", "vinkl"},
		{"vinkning", "vinkning"},
		{"vinlistan", "vinlistan"},
		{"vinn", "vinn"},
		{"vinna", "vinn"},
		{"vinnas", "vinn"},
		{"vinner", "vinn"},
		{"vinning", "vinning"},
		{"vinnlaggandet", "vinnlagg"},
		{"vinslankar", "vinslank"},
		{"vinst", "vinst"},
		{"vinsten", "vinst"},
		{"vinstgivandc", "vinstgivandc"},
		{"vinter", "vint"},
		{"vinteraftnarna", "vinteraftn"},
		{"vintergatans", "vintergatan"},
		{"vinterhvila", "vinterhvil"},
		{"vinterhvilan", "vinterhvilan"},
		{"vinterkusen", "vinterkus"},
		{"vinterkväll", "vinterkväll"},
		{"vinterkvällar", "vinterkväll"},
		{"vinterlig", "vinter"},
		{"vinterliggare", "vinterligg"},
		{"vintermat", "vinterm"},
		{"vintermånaderna", "vintermånad"},
		{"vintern", "vint"},
		{"vinternatt", "vinternat"},
		{"vinterns", "vint"},
		{"vinterorgel", "vinterorgel"},
		{"vinterqvarter", "vinterqvart"},
		{"vinterresa", "vinterres"},
		{"vinterskymning", "vinterskymning"},
		{"vintersnön", "vintersnön"},
		{"vintertiden", "vintertid"},
		{"vintervärld", "vintervärld"},
		{"vintrar", "vintr"},
		{"vintrarna", "vintr"},
		{"vintras", "vintr"},
		{"vintriga", "vintr"},
		{"vintrigt", "vintr"},
		{"viola", "viol"},
		{"violas", "viol"},
		{"violbrun", "violbrun"},
		{"viole", "viol"},
		{"violer", "viol"},
		{"violerna", "viol"},
		{"violernas", "viol"},
		{"violett", "violet"},
		{"violetta", "violet"},
		{"violiner", "violin"},
		{"violoncell", "violoncell"},
		{"vippade", "vipp"},
		{"vippstjärten", "vippstjärt"},
		{"vips", "vip"},
		{"vira", "vir"},
		{"virade", "vir"},
		{"virriga", "virr"},
		{"virrvarr", "virrvarr"},
		{"virvel", "virvel"},
		{"virvlade", "virvl"},
		{"virvlande", "virvl"},
		{"virvlar", "virvl"},
		{"virvlat", "virvl"},
		{"vis", "vis"},
		{"visa", "vis"},
		{"visad", "vis"},
		{"visade", "vis"},
		{"visan", "visan"},
		{"visande", "vis"},
		{"visans", "visan"},
		{"visar", "vis"},
		{"visare", "vis"},
		{"visarna", "vis"},
		{"visat", "vis"},
		{"visdom", "visdom"},
		{"visdomens", "visdom"},
		{"visdomstiden", "visdomstid"},
		{"vise", "vis"},
		{"vises", "vis"},
		{"viset", "viset"},
		{"vishet", "vis"},
		{"vishetsspråk", "vishetsspråk"},
		{"vision", "vision"},
		{"visit", "visit"},
		{"visitationer", "visitation"},
		{"visiten", "visit"},
		{"visiter", "visit"},
		{"visiterna", "visit"},
		{"visitkort", "visitkort"},
		{"visitkortet", "visitkortet"},
		{"viska", "visk"},
		{"viskadc", "viskadc"},
		{"viskade", "visk"},
		{"viskades", "visk"},
		{"viskande", "visk"},
		{"viskar", "visk"},
		{"viskas", "visk"},
		{"viskat", "visk"},
		{"viskning", "viskning"},
		{"viskningar", "viskning"},
		{"viskningarna", "viskning"},
		{"viskningen", "viskning"},
		{"visky", "visky"},
		{"visligen", "vis"},
		{"visor", "vis"},
		{"visorna", "vis"},
		{"vispa", "visp"},
		{"vispade", "visp"},
		{"vispen", "visp"},
		{"viss", "viss"},
		{"vissa", "viss"},
		{"vissen", "viss"},
		{"visserligen", "visser"},
		{"visset", "visset"},
		{"visshet", "viss"},
		{"vissheten", "viss"},
		{"visslade", "vissl"},
		{"visslande", "vissl"},
		{"visslar", "vissl"},
		{"visslet", "visslet"},
		{"vissling", "vissling"},
		{"visslingen", "vissling"},
		{"vissna", "vissn"},
		{"vissnade", "vissn"},
		{"vissnande", "vissn"},
		{"vissnar", "vissn"},
		{"vissnat", "vissn"},
		{"vissne", "vissn"},
		{"visso", "visso"},
		{"visst", "visst"},
		{"visstc", "visstc"},
		{"visste", "visst"},
		{"vissten", "visst"},
		{"visstump", "visstump"},
		{"visstumpar", "visstump"},
		{"vist", "vist"},
		{"vistades", "vist"},
		{"vistande", "vist"},
		{"vistandet", "vist"},
		{"vistas", "vist"},
		{"vistats", "vistat"},
		{"vistelse", "vist"},
		{"vistelseort", "vistelseort"},
		{"visthusdörren", "visthusdörr"},
		{"visthuset", "visthuset"},
		{"vit", "vit"},
		{"vita", "vit"},
		{"vitalis", "vitalis"},
		{"vitas", "vit"},
		{"vitdukat", "vitduk"},
		{"vithet", "vit"},
		{"vithårig", "vithår"},
		{"vitklädda", "vitkläd"},
		{"vitnade", "vitn"},
		{"vitnande", "vitn"},
		{"vitprickig", "vitprick"},
		{"vitriol", "vitriol"},
		{"vitskimrande", "vitskimr"},
		{"vitskurade", "vitskur"},
		{"vitsord", "vitsord"},
		{"vitt", "vitt"},
		{"vitten", "vitt"},
		{"vittert", "vittert"},
		{"vittna", "vittn"},
		{"vittnade", "vittn"},
		{"vittnande", "vittn"},
		{"vittnar", "vittn"},
		{"vittne", "vittn"},
		{"vittnen", "vittn"},
		{"vittnesmål", "vittnesmål"},
		{"vittutseende", "vittutseend"},
		{"vivant", "vivant"},
		{"vivendi", "vivendi"},
		{"vivo", "vivo"},
		{"vivör", "vivör"},
		{"vjta", "vjta"},
		{"vlsst", "vlsst"},
		{"vo", "vo"},
		{"voa", "voa"},
		{"voila", "voil"},
		{"voix", "voix"},
		{"voll", "voll"},
		{"volym", "volym"},
		{"volymer", "volym"},
		{"von", "von"},
		{"vor", "vor"},
		{"vorden", "vord"},
		{"vore", "vor"},
		{"voro", "voro"},
		{"vot", "vot"},
		{"vou", "vou"},
		{"vous", "vous"},
		{"vov", "vov"},
		{"vox", "vox"},
		{"vpa", "vpa"},
		{"vraarna", "vraarn"},
		{"vrak", "vrak"},
		{"vraket", "vraket"},
		{"vrakplundraren", "vrakplundr"},
		{"vred", "vred"},
		{"vrede", "vred"},
		{"vreden", "vred"},
		{"vredens", "vred"},
		{"vredgade", "vredg"},
		{"vredo", "vredo"},
		{"vresig", "vres"},
		{"vresigheten", "vres"},
		{"vresigt", "vres"},
		{"vrestörnets", "vrestörnet"},
		{"vret", "vret"},
		{"vreten", "vret"},
		{"vrida", "vrid"},
		{"vridande", "vrid"},
		{"vriden", "vrid"},
		{"vrider", "vrid"},
		{"vridit", "vridit"},
		{"vridning", "vridning"},
		{"vristen", "vrist"},
		{"vristerna", "vrist"},
		{"vroks", "vrok"},
		{"vräka", "vräk"},
		{"vräker", "vräk"},
		{"vräkte", "vräkt"},
		{"vrå", "vrå"},
		{"vrål", "vrål"},
		{"vrålade", "vrål"},
		{"vrån", "vrån"},
		{"vrår", "vrår"},
		{"vudare", "vud"},
		{"vulgär", "vulgär"},
		{"vulgära", "vulgär"},
		{"vulkan", "vulkan"},
		{"vunna", "vunn"},
		{"vunne", "vunn"},
		{"vunnet", "vunnet"},
		{"vunnit", "vunnit"},
		{"vurm", "vurm"},
		{"vurmerier", "vurmeri"},
		{"vuxen", "vux"},
		{"vuxit", "vuxit"},
		{"vuxna", "vuxn"},
		{"vuxne", "vuxn"},
		{"vyssa", "vyss"},
		{"vyssjat", "vyssj"},
		{"vä", "vä"},
		{"väck", "väck"},
		{"väcka", "väck"},
		{"väckarklocka", "väckarklock"},
		{"väckarklockan", "väckarklockan"},
		{"väckas", "väck"},
		{"väckelse", "väck"},
		{"väckelsen", "väck"},
		{"väcker", "väck"},
		{"väckes", "väck"},
		{"väckt", "väck"},
		{"väckta", "väck"},
		{"väckte", "väck"},
		{"väcktes", "väck"},
		{"väder", "väd"},
		{"väderbitet", "väderbitet"},
		{"väderbitna", "väderbitn"},
		{"väderhanen", "väderhan"},
		{"väderhorn", "väderhorn"},
		{"väderil", "väderil"},
		{"väderkistan", "väderkistan"},
		{"väderkorn", "väderkorn"},
		{"väderkvarn", "väderkvarn"},
		{"väderkvarns", "väderkvarn"},
		{"väderstreck", "väderstreck"},
		{"vädja", "vädj"},
		{"vädjande", "vädj"},
		{"vädra", "vädr"},
		{"vädrade", "vädr"},
		{"vädrande", "vädr"},
		{"vädrars", "vädrar"},
		{"vädras", "vädr"},
		{"vädret", "vädret"},
		{"vädring", "vädring"},
		{"vädur", "vädur"},
		{"väfen", "väf"},
		{"väfnaden", "väfnad"},
		{"väfva", "väfv"},
		{"väg", "väg"},
		{"väga", "väg"},
		{"vägar", "väg"},
		{"vägarna", "väg"},
		{"vägde", "vägd"},
		{"vägdes", "vägd"},
		{"vägen", "väg"},
		{"väger", "väg"},
		{"vägfolk", "vägfolk"},
		{"vägg", "vägg"},
		{"väggar", "vägg"},
		{"väggarna", "vägg"},
		{"väggarne", "vägg"},
		{"väggen", "vägg"},
		{"väggfast", "väggf"},
		{"väggklockan", "väggklockan"},
		{"väggskåp", "väggskåp"},
		{"väggskåpet", "väggskåpet"},
		{"vägkanten", "vägkant"},
		{"vägnar", "vägn"},
		{"vägra", "vägr"},
		{"vägrade", "vägr"},
		{"vägran", "vägran"},
		{"vägrat", "vägr"},
		{"vägt", "vägt"},
		{"vägvill", "vägvill"},
		{"väi", "väi"},
		{"väja", "väj"},
		{"väjde", "väjd"},
		{"väkt", "väkt"},
		{"väktar", "väkt"},
		{"väl", "väl"},
		{"välan", "välan"},
		{"välartad", "välart"},
		{"välbefinnande", "välbefin"},
		{"välbehag", "välbehag"},
		{"välbehagligt", "välbehag"},
		{"välbehållen", "välbehåll"},
		{"välbehövlig", "välbehöv"},
		{"välbekant", "välbekant"},
		{"välbekanta", "välbekant"},
		{"välbestäld", "välbestäld"},
		{"välbetänkta", "välbetänk"},
		{"välbildad", "välbild"},
		{"välborstade", "välborst"},
		{"välbärgad", "välbärg"},
		{"välde", "väld"},
		{"väldig", "väld"},
		{"väldiga", "väld"},
		{"väldige", "väld"},
		{"väldigt", "väld"},
		{"välfägnad", "välfägn"},
		{"välfärd", "välfärd"},
		{"välförhållande", "välförhåll"},
		{"välförståndiga", "välförstånd"},
		{"välgerning", "välgerning"},
		{"välgerningar", "välgerning"},
		{"välgerningen", "välgerning"},
		{"välgrundade", "välgrund"},
		{"välgärning", "välgärning"},
		{"välgång", "välgång"},
		{"välgörande", "välgör"},
		{"välgörare", "välgör"},
		{"välgörares", "välgörar"},
		{"välgörenheten", "välgören"},
		{"välgörenhetsinrättning", "välgörenhetsinrättning"},
		{"välja", "välj"},
		{"väljande", "välj"},
		{"välklädd", "välkläd"},
		{"välkommande", "välkomm"},
		{"välkommen", "välkomm"},
		{"välkomna", "välkomn"},
		{"välkomnade", "välkomn"},
		{"välkomnande", "välkomn"},
		{"välkänd", "välkänd"},
		{"välkända", "välkänd"},
		{"väll", "väll"},
		{"välla", "väll"},
		{"vällagade", "vällag"},
		{"vällde", "välld"},
		{"välling", "välling"},
		{"vällingen", "välling"},
		{"välljudande", "välljud"},
		{"vällukt", "välluk"},
		{"vällust", "vällust"},
		{"vällusten", "vällust"},
		{"vällustens", "vällust"},
		{"välmanikurefade", "välmanikuref"},
		{"välmanikurerade", "välmanikurer"},
		{"välmenade", "välmen"},
		{"välmenande", "välmen"},
		{"välmening", "välmening"},
		{"välmeningen", "välmening"},
		{"välmenings", "välmening"},
		{"välment", "välment"},
		{"välmenta", "välment"},
		{"välmående", "välmåend"},
		{"välmåga", "välmåg"},
		{"välsigna", "välsign"},
		{"välsignad", "välsign"},
		{"välsignade", "välsign"},
		{"välsignande", "välsign"},
		{"välsignar", "välsign"},
		{"välsignat", "välsign"},
		{"välsigne", "välsign"},
		{"välsignelse", "välsign"},
		{"välsignelsen", "välsign"},
		{"välstånd", "välstånd"},
		{"välståndet", "välståndet"},
		{"vält", "vält"},
		{"välta", "vält"},
		{"vältalare", "vältal"},
		{"vältalig", "välta"},
		{"vältaliga", "välta"},
		{"vältalighet", "välta"},
		{"vältra", "vältr"},
		{"vältrade", "vältr"},
		{"vältrat", "vältr"},
		{"vältänkande", "vältänk"},
		{"välva", "välv"},
		{"välvand", "välvand"},
		{"välvda", "välvd"},
		{"välvde", "välvd"},
		{"välvilja", "välvilj"},
		{"välviljans", "välviljan"},
		{"välvillig", "välvil"},
		{"välvilliga", "välvil"},
		{"välvilligt", "välvil"},
		{"välvt", "välvt"},
		{"välvägnad", "välvägn"},
		{"välväxt", "välväxt"},
		{"väm", "väm"},
		{"vämjelse", "vämj"},
		{"vämjelsen", "vämj"},
		{"vän", "vän"},
		{"vänd", "vänd"},
		{"vända", "vänd"},
		{"vändande", "vänd"},
		{"vände", "vänd"},
		{"vänder", "vänd"},
		{"vändes", "vänd"},
		{"vändning", "vändning"},
		{"vändningar", "vändning"},
		{"vändningen", "vändning"},
		{"vändpunkten", "vändpunk"},
		{"vändt", "vänd"},
		{"vänfasta", "vänfast"},
		{"väninna", "vänin"},
		{"väninnas", "vänin"},
		{"väninnor", "vänin"},
		{"vänja", "vänj"},
		{"vänjer", "vänj"},
		{"vänlig", "vän"},
		{"vänliga", "vän"},
		{"vänligare", "vän"},
		{"vänligaste", "vän"},
		{"vänlige", "vän"},
		{"vänlighet", "vän"},
		{"vänligheten", "vän"},
		{"vänligt", "vän"},
		{"vännen", "vänn"},
		{"vännens", "vänn"},
		{"vänner", "vänn"},
		{"vännerna", "vänn"},
		{"vännernas", "vänn"},
		{"vänners", "vänner"},
		{"väns", "vän"},
		{"vänskap", "vänskap"},
		{"vänskapens", "vänskap"},
		{"vänskaplig", "vänskap"},
		{"vänskapliga", "vänskap"},
		{"vänskapligaste", "vänskap"},
		{"vänskapligt", "vänskap"},
		{"vänskaps", "vänskap"},
		{"vänskapsbefattning", "vänskapsbefattning"},
		{"vänskapsfulla", "vänskapsfull"},
		{"vänskapsfullt", "vänskapsfull"},
		{"vänskapsförbindelse", "vänskapsförbind"},
		{"vänskapsförhållande", "vänskapsförhåll"},
		{"vänskapstjänsten", "vänskapstjänst"},
		{"vänster", "vänst"},
		{"vänstra", "vänstr"},
		{"vänt", "vänt"},
		{"vänta", "vänt"},
		{"väntade", "vänt"},
		{"väntades", "vänt"},
		{"väntan", "väntan"},
		{"väntande", "vänt"},
		{"väntans", "väntan"},
		{"väntar", "vänt"},
		{"väntat", "vänt"},
		{"väntetiden", "väntetid"},
		{"väntjenst", "väntjenst"},
		{"väntpengar", "väntpeng"},
		{"väntrummet", "väntrummet"},
		{"vär", "vär"},
		{"värd", "värd"},
		{"värda", "värd"},
		{"värdat", "värd"},
		{"värde", "värd"},
		{"värdefull", "värdefull"},
		{"värdefulla", "värdefull"},
		{"värdefullare", "värdefull"},
		{"värdelös", "värdelös"},
		{"värdelöst", "värdelös"},
		{"värden", "värd"},
		{"värdepapper", "värdepapp"},
		{"värdera", "värder"},
		{"värderad", "värder"},
		{"värderade", "värder"},
		{"värderar", "värder"},
		{"värdet", "värdet"},
		{"värdfolket", "värdfolket"},
		{"värdig", "värd"},
		{"värdiga", "värd"},
		{"värdige", "värd"},
		{"värdighet", "värd"},
		{"värdigllet", "värdigllet"},
		{"värdigt", "värd"},
		{"värdinna", "värdin"},
		{"värdinnan", "värdinnan"},
		{"värdinnans", "värdinnan"},
		{"värdshus", "värdshus"},
		{"värdshusen", "värdshus"},
		{"värdshuset", "värdshuset"},
		{"värdskapet", "värdskapet"},
		{"värdslig", "värds"},
		{"värdt", "värd"},
		{"värja", "värj"},
		{"värjan", "värjan"},
		{"värjde", "värjd"},
		{"värk", "värk"},
		{"värka", "värk"},
		{"värkarna", "värk"},
		{"värken", "värk"},
		{"värkte", "värk"},
		{"värld", "värld"},
		{"världarna", "värld"},
		{"världarnas", "värld"},
		{"världen", "värld"},
		{"världenes", "världen"},
		{"världens", "värld"},
		{"världsberömdhet", "världsberömd"},
		{"världshaven", "världshav"},
		{"världshistoria", "världshistori"},
		{"världshistoriens", "världshistori"},
		{"världslig", "världs"},
		{"världsliga", "världs"},
		{"världslighet", "världs"},
		{"världsmannens", "världsman"},
		{"världsmaskineriet", "världsmaskineriet"},
		{"världsmedborgaren", "världsmedborg"},
		{"världsordningen", "världsordning"},
		{"världsvimlet", "världsvimlet"},
		{"världsåskådning", "världsåskådning"},
		{"värma", "värm"},
		{"värmande", "värm"},
		{"värmas", "värm"},
		{"värmc", "värmc"},
		{"värmde", "värmd"},
		{"värmdes", "värmd"},
		{"värme", "värm"},
		{"värmen", "värm"},
		{"värmens", "värm"},
		{"värmer", "värm"},
		{"värmt", "värmt"},
		{"värn", "värn"},
		{"värna", "värn"},
		{"värnande", "värn"},
		{"värnlösa", "värnlös"},
		{"värr", "värr"},
		{"värre", "värr"},
		{"värst", "värst"},
		{"värsta", "värst"},
		{"värt", "värt"},
		{"värv", "värv"},
		{"värvar", "värv"},
		{"värvas", "värv"},
		{"väsande", "väs"},
		{"väsen", "väs"},
		{"väsende", "väsend"},
		{"väsendet", "väsendet"},
		{"väsens", "väs"},
		{"väsentlig", "väsent"},
		{"väsentliga", "väsent"},
		{"väsentligen", "väsent"},
		{"väsentligt", "väsent"},
		{"väska", "väsk"},
		{"väskan", "väskan"},
		{"väsnades", "väsn"},
		{"vässade", "väss"},
		{"väst", "väst"},
		{"västar", "väst"},
		{"väste", "väst"},
		{"västen", "väst"},
		{"väster", "väst"},
		{"västergötland", "västergötland"},
		{"västerns", "väst"},
		{"västficka", "västfick"},
		{"västfickan", "västfickan"},
		{"västgötaturen", "västgötatur"},
		{"västkustprästens", "västkustpräst"},
		{"väta", "vät"},
		{"vätte", "vätt"},
		{"vättern", "vätt"},
		{"väva", "väv"},
		{"vävarna", "väv"},
		{"vävd", "vävd"},
		{"väven", "väv"},
		{"väver", "väv"},
		{"väverskan", "väverskan"},
		{"vävning", "vävning"},
		{"vävsalen", "vävsal"},
		{"vävstol", "vävstol"},
		{"vävstolar", "vävstol"},
		{"vävstolen", "vävstol"},
		{"vävstycken", "vävstyck"},
		{"vävts", "vävt"},
		{"växa", "väx"},
		{"växande", "väx"},
		{"växel", "växel"},
		{"växelmyntet", "växelmyntet"},
		{"växelomsättning", "växelomsättning"},
		{"växelvis", "växelvis"},
		{"växer", "väx"},
		{"växla", "växl"},
		{"växlad", "växl"},
		{"växlade", "växl"},
		{"växlades", "växl"},
		{"växlande", "växl"},
		{"växlar", "växl"},
		{"växlat", "växl"},
		{"växlingar", "växling"},
		{"växt", "växt"},
		{"växte", "växt"},
		{"växten", "växt"},
		{"växter", "växt"},
		{"växtslag", "växtslag"},
		{"vådlig", "våd"},
		{"vådliga", "våd"},
		{"våg", "våg"},
		{"våga", "våg"},
		{"vågade", "våg"},
		{"vågar", "våg"},
		{"vågat", "våg"},
		{"vågform", "vågform"},
		{"våghalsiga", "våghals"},
		{"vågigt", "våg"},
		{"vågor", "våg"},
		{"vågorna", "våg"},
		{"vågornas", "våg"},
		{"vågsamma", "vågsamm"},
		{"vågskalen", "vågskal"},
		{"vågskålar", "vågskål"},
		{"vågskålen", "vågskål"},
		{"vågspel", "vågspel"},
		{"vågstycke", "vågstyck"},
		{"våknade", "våkn"},
		{"våld", "våld"},
		{"våldföra", "våldför"},
		{"våldsam", "våldsam"},
		{"våldsamma", "våldsamm"},
		{"våldsamt", "våldsamt"},
		{"våldsmannen", "våldsman"},
		{"våldtäkt", "våldtäk"},
		{"vållat", "våll"},
		{"vålnad", "våln"},
		{"vålnader", "vålnad"},
		{"vånda", "vånd"},
		{"våndades", "vånd"},
		{"våndas", "vånd"},
		{"våning", "våning"},
		{"våningar", "våning"},
		{"våningen", "våning"},
		{"vånnar", "vånn"},
		{"våpet", "våpet"},
		{"vår", "vår"},
		{"våra", "vår"},
		{"vårar", "vår"},
		{"vårarna", "vår"},
		{"vårars", "vårar"},
		{"våras", "vår"},
		{"vårblommor", "vårblomm"},
		{"vårbäcken", "vårbäck"},
		{"vård", "vård"},
		{"vårda", "vård"},
		{"vårdad", "vård"},
		{"vårdade", "vård"},
		{"vårdai", "vårdai"},
		{"vårdande", "vård"},
		{"vårdanstalt", "vårdanstalt"},
		{"vårdar", "vård"},
		{"vårdarinna", "vårdarin"},
		{"vårdarinnans", "vårdarinnan"},
		{"vårdarinnas", "vårdarin"},
		{"vårdat", "vård"},
		{"vården", "vård"},
		{"vårdman", "vårdman"},
		{"vårdmans", "vårdman"},
		{"vårdslös", "vårdslös"},
		{"vårdslösa", "vårdslös"},
		{"vårdslösad", "vårdslös"},
		{"vårdslösat", "vårdslös"},
		{"vårdslöshet", "vårdslös"},
		{"vårdslösheten", "vårdslös"},
		{"vårdslöst", "vårdslös"},
		{"vårdtecken", "vårdteck"},
		{"våren", "vår"},
		{"vårens", "vår"},
		{"vårfloder", "vårflod"},
		{"vårfrusälg", "vårfrusälg"},
		{"vårhimmel", "vårhimmel"},
		{"vårhimmeln", "vårhimmeln"},
		{"vårkvällar", "vårkväll"},
		{"vårkök", "vårkök"},
		{"vårliga", "vår"},
		{"vårluften", "vårluft"},
		{"vårlöksgul", "vårlöksgul"},
		{"vårmorgon", "vårmorgon"},
		{"vårsidan", "vårsidan"},
		{"vårskuggor", "vårskugg"},
		{"vårsälg", "vårsälg"},
		{"vårt", "vårt"},
		{"vårtid", "vårtid"},
		{"vårvind", "vårvind"},
		{"våt", "våt"},
		{"våta", "våt"},
		{"vått", "vått"},
		{"vörda", "vörd"},
		{"vördad", "vörd"},
		{"vördade", "vörd"},
		{"vördig", "vörd"},
		{"vördnad", "vördn"},
		{"vördnaden", "vördnad"},
		{"vördnadsbjudande", "vördnadsbjud"},
		{"vördnadsfull", "vördnadsfull"},
		{"vördnadsfulla", "vördnadsfull"},
		{"vördnadsfulle", "vördnadsfull"},
		{"vördsam", "vördsam"},
		{"vörtbrödsskivor", "vörtbrödsskiv"},
		{"vösa", "vös"},
		{"w", "w"},
		{"wagnerian", "wagnerian"},
		{"wahl", "wahl"},
		{"wahlbom", "wahlbom"},
		{"wahlboms", "wahlbom"},
		{"wahlhom", "wahlhom"},
		{"waller", "wall"},
		{"wallin", "wallin"},
		{"wenden", "wend"},
		{"wendens", "wend"},
		{"westervik", "westervik"},
		{"wette", "wett"},
		{"wetterkranz", "wetterkranz"},
		{"wetterkvist", "wetterkvist"},
		{"wetterkvists", "wetterkvist"},
		{"wetzmann", "wetzman"},
		{"wetzmanns", "wetzman"},
		{"whisky", "whisky"},
		{"whiskytoddar", "whiskytod"},
		{"wie", "wie"},
		{"wien", "wien"},
		{"wienervalsen", "wienervals"},
		{"wilhelm", "wilhelm"},
		{"willblad", "willbl"},
		{"wille", "will"},
		{"winblad", "winbl"},
		{"winblads", "winblad"},
		{"winters", "winter"},
		{"wuhlbom", "wuhlbom"},
		{"wunderhorn", "wunderhorn"},
		{"wålbergs", "wålberg"},
		{"x", "x"},
		{"xerxes", "xerx"},
		{"xi", "xi"},
		{"xii", "xii"},
		{"xiii", "xiii"},
		{"xiv", "xiv"},
		{"xix", "xix"},
		{"xolvet", "xolvet"},
		{"xv", "xv"},
		{"xvi", "xvi"},
		{"xvii", "xvii"},
		{"xviii", "xviii"},
		{"xx", "xx"},
		{"xxi", "xxi"},
		{"xxii", "xxii"},
		{"xxiii", "xxiii"},
		{"xxiv", "xxiv"},
		{"xxix", "xxix"},
		{"xxv", "xxv"},
		{"xxvi", "xxvi"},
		{"xxvii", "xxvii"},
		{"xxviii", "xxviii"},
		{"xxx", "xxx"},
		{"xxxi", "xxxi"},
		{"xxxii", "xxxii"},
		{"xxxiii", "xxxiii"},
		{"y", "y"},
		{"yaket", "yaket"},
		{"yankees", "yanke"},
		{"yar", "yar"},
		{"yarta", "yart"},
		{"ydre", "ydr"},
		{"yfdes", "yfd"},
		{"yfviga", "yfv"},
		{"yktan", "yktan"},
		{"ylldes", "ylld"},
		{"ylle", "yll"},
		{"yllestrumpor", "yllestrump"},
		{"ympas", "ymp"},
		{"yngling", "yngling"},
		{"ynglingar", "yngling"},
		{"ynglingaår", "ynglingaår"},
		{"ynglingen", "yngling"},
		{"ynglingens", "yngling"},
		{"ynglings", "yngling"},
		{"yngre", "yngr"},
		{"yngs", "yng"},
		{"yngst", "yngst"},
		{"yngsta", "yngst"},
		{"yngste", "yngst"},
		{"ynk", "ynk"},
		{"ynklig", "ynk"},
		{"ynkliga", "ynk"},
		{"ynkligt", "ynk"},
		{"ynnest", "ynnest"},
		{"ynnestbevis", "ynnestbevis"},
		{"yppa", "ypp"},
		{"yppat", "ypp"},
		{"ypperlig", "ypper"},
		{"ypperligt", "ypper"},
		{"yppersta", "ypperst"},
		{"yppig", "ypp"},
		{"yppigt", "ypp"},
		{"ypplyfte", "ypplyft"},
		{"yr", "yr"},
		{"yra", "yra"},
		{"yrade", "yrad"},
		{"yrar", "yrar"},
		{"yraste", "yrast"},
		{"yrde", "yrd"},
		{"yrke", "yrk"},
		{"yrken", "yrk"},
		{"yrkesförbindlighet", "yrkesförbind"},
		{"yrket", "yrket"},
		{"yrsel", "yrsel"},
		{"yrseln", "yrseln"},
		{"yrvaken", "yrvak"},
		{"yrvaket", "yrvaket"},
		{"yrvakna", "yrvakn"},
		{"ys", "ys"},
		{"yt", "yt"},
		{"yta", "yta"},
		{"ytan", "ytan"},
		{"ytlig", "ytl"},
		{"ytliga", "ytl"},
		{"ytligt", "ytl"},
		{"ytter", "ytt"},
		{"ytterkläder", "ytterkläd"},
		{"ytterliga", "ytter"},
		{"ytterligarc", "ytterligarc"},
		{"ytterligare", "ytter"},
		{"ytterlighet", "ytter"},
		{"ytterst", "ytterst"},
		{"yttersta", "ytterst"},
		{"yttra", "yttr"},
		{"yttrade", "yttr"},
		{"yttrades", "yttr"},
		{"yttrande", "yttr"},
		{"yttranden", "yttr"},
		{"yttrandet", "yttr"},
		{"yttrar", "yttr"},
		{"yttras", "yttr"},
		{"yttrat", "yttr"},
		{"yttre", "yttr"},
		{"yttryckte", "yttryck"},
		{"yuvaste", "yuv"},
		{"yvas", "yvas"},
		{"yvig", "yvig"},
		{"yviga", "yvig"},
		{"yvigt", "yvig"},
		{"yxa", "yxa"},
		{"yände", "yänd"},
		{"yå", "yå"},
		{"z", "z"},
		{"zarathustra", "zarathustr"},
		{"zolo", "zolo"},
		{"zuaver", "zuav"},
		{"ä", "ä"},
		{"äckel", "äckel"},
		{"äcken", "äck"},
		{"äckliga", "äck"},
		{"ädel", "ädel"},
		{"ädelboren", "ädelbor"},
		{"ädelmod", "ädelmod"},
		{"ädelmodig", "ädelmod"},
		{"ädelstenar", "ädelsten"},
		{"ädelt", "ädelt"},
		{"ädla", "ädl"},
		{"ädlingarna", "ädling"},
		{"ädlingen", "ädling"},
		{"äfven", "äfv"},
		{"äfvensom", "äfvensom"},
		{"äfventyr", "äfventyr"},
		{"äfventyra", "äfventyr"},
		{"äfventyret", "äfventyret"},
		{"äga", "äga"},
		{"äganderätten", "äganderät"},
		{"ägare", "ägar"},
		{"ägaren", "ägar"},
		{"ägarens", "ägar"},
		{"ägarinna", "ägarin"},
		{"ägarinnan", "ägarinnan"},
		{"ägde", "ägd"},
		{"ägdes", "ägd"},
		{"äger", "äger"},
		{"ägg", "ägg"},
		{"ägghyllor", "ägghyll"},
		{"äggklyftorna", "äggklyft"},
		{"ägna", "ägn"},
		{"ägnade", "ägn"},
		{"ägnades", "ägn"},
		{"ägnat", "ägn"},
		{"ägo", "ägo"},
		{"ägodelar", "ägodel"},
		{"ägor", "ägor"},
		{"ägorna", "ägorn"},
		{"ägrett", "ägret"},
		{"ägt", "ägt"},
		{"äh", "äh"},
		{"äidre", "äidr"},
		{"äintligen", "äint"},
		{"äkta", "äkt"},
		{"äktenskap", "äktenskap"},
		{"äktenskapet", "äktenskapet"},
		{"äktenskapets", "äktenskapet"},
		{"äktenskapliga", "äktenskap"},
		{"äktenskapsförbindelse", "äktenskapsförbind"},
		{"äktenskapsskillnad", "äktenskapsskilln"},
		{"äl", "äl"},
		{"äldre", "äldr"},
		{"äldsta", "äldst"},
		{"äldste", "äldst"},
		{"älghuvud", "älghuvud"},
		{"älghuvudet", "älghuvudet"},
		{"älsk", "älsk"},
		{"älska", "älsk"},
		{"älskad", "älsk"},
		{"älskade", "älsk"},
		{"älskades", "älsk"},
		{"älskadt", "älskad"},
		{"älskande", "älsk"},
		{"älskar", "älsk"},
		{"älskare", "älsk"},
		{"älskaren", "älsk"},
		{"älskarens", "älsk"},
		{"älskares", "älskar"},
		{"älskarinna", "älskarin"},
		{"älskat", "älsk"},
		{"älsklig", "älsk"},
		{"älskliga", "älsk"},
		{"älsklige", "älsk"},
		{"älskligt", "älsk"},
		{"älskling", "älskling"},
		{"älsklingar", "älskling"},
		{"älsklingsbarn", "älsklingsbarn"},
		{"älsklingsbarnet", "älsklingsbarnet"},
		{"älsklingsdotter", "älsklingsdot"},
		{"älsklingsdryck", "älsklingsdryck"},
		{"älsklingsdräkt", "älsklingsdräk"},
		{"älsklingsplats", "älsklingsplat"},
		{"älsklingsrock", "älsklingsrock"},
		{"älsklingssång", "älsklingssång"},
		{"älsklingssånger", "älsklingssång"},
		{"älsklingsväg", "älsklingsväg"},
		{"älskogs", "älskog"},
		{"älskogskrank", "älskogskrank"},
		{"älskogssälle", "älskogssäll"},
		{"älskvärd", "älskvärd"},
		{"älskvärda", "älskvärd"},
		{"älskvärdare", "älskvärd"},
		{"älskvärdhet", "älskvärd"},
		{"ältandet", "ält"},
		{"ältar", "ält"},
		{"älvarna", "älv"},
		{"äm", "äm"},
		{"ämabla", "ämabl"},
		{"ämade", "ämad"},
		{"ämar", "ämar"},
		{"ämbetets", "ämbetet"},
		{"ämbets", "ämbet"},
		{"ämbetsberk", "ämbetsberk"},
		{"ämbetsbroders", "ämbetsbroder"},
		{"ämbetsbröderna", "ämbetsbröd"},
		{"ämbetsmanna", "ämbetsman"},
		{"ämbetsmannabanan", "ämbetsmannabanan"},
		{"ämbetsmän", "ämbetsmän"},
		{"ämbetsmännen", "ämbetsmän"},
		{"ämbetsverk", "ämbetsverk"},
		{"ämbetsåligganden", "ämbetsåligg"},
		{"ämnad", "ämn"},
		{"ämnade", "ämn"},
		{"ämnar", "ämn"},
		{"ämnat", "ämn"},
		{"ämne", "ämn"},
		{"ämnen", "ämn"},
		{"ämnet", "ämnet"},
		{"ämret", "ämret"},
		{"ämrnet", "ämrnet"},
		{"än", "än"},
		{"ända", "änd"},
		{"ändalmål", "ändalmål"},
		{"ändamål", "ändamål"},
		{"ändamålet", "ändamålet"},
		{"ändamålets", "ändamålet"},
		{"ändamålslös", "ändamålslös"},
		{"ändan", "ändan"},
		{"ändas", "änd"},
		{"ände", "änd"},
		{"änden", "änd"},
		{"änder", "änd"},
		{"änderna", "änd"},
		{"ändlös", "ändlös"},
		{"ändlösa", "ändlös"},
		{"ändock", "ändock"},
		{"ändra", "ändr"},
		{"ändrad", "ändr"},
		{"ändrade", "ändr"},
		{"ändrades", "ändr"},
		{"ändrar", "ändr"},
		{"ändras", "ändr"},
		{"ändrat", "ändr"},
		{"ändring", "ändring"},
		{"ändtligen", "ändt"},
		{"ändå", "ändå"},
		{"äng", "äng"},
		{"ängar", "äng"},
		{"ängarna", "äng"},
		{"ängarnas", "äng"},
		{"ängars", "ängar"},
		{"ängd", "ängd"},
		{"ängden", "ängd"},
		{"ängderna", "ängd"},
		{"ängel", "ängel"},
		{"ängeln", "ängeln"},
		{"ängen", "äng"},
		{"ängens", "äng"},
		{"änglar", "ängl"},
		{"änglarna", "ängl"},
		{"änglars", "änglar"},
		{"änglavingar", "änglaving"},
		{"ängslade", "ängsl"},
		{"ängslan", "ängslan"},
		{"ängslande", "ängsl"},
		{"ängslas", "ängsl"},
		{"ängslig", "ängs"},
		{"ängsliga", "ängs"},
		{"ängslige", "ängs"},
		{"ängsligt", "ängs"},
		{"änka", "änk"},
		{"änkan", "änkan"},
		{"änkefru", "änkefru"},
		{"änkenåd", "änkenåd"},
		{"änkestand", "änkestand"},
		{"änkling", "änkling"},
		{"änklingen", "änkling"},
		{"änklingstid", "änklingstid"},
		{"änkor", "änk"},
		{"ännu", "ännu"},
		{"änrlå", "änrlå"},
		{"änsande", "äns"},
		{"änt", "änt"},
		{"äntligen", "änt"},
		{"äntligt", "änt"},
		{"äppelgårdens", "äppelgård"},
		{"äpple", "äppl"},
		{"äppleansikte", "äppleansik"},
		{"äppleansiktet", "äppleansiktet"},
		{"äpplen", "äppl"},
		{"äppleträd", "äppleträd"},
		{"är", "är"},
		{"ära", "ära"},
		{"ärade", "ärad"},
		{"äran", "äran"},
		{"ärans", "äran"},
		{"äras", "äras"},
		{"ärat", "ärat"},
		{"ärbar", "ärb"},
		{"ärbara", "ärbar"},
		{"ärbarhet", "ärbar"},
		{"ärbart", "ärbart"},
		{"äregirighet", "äregir"},
		{"äregirigheten", "äregir"},
		{"ärelysten", "ärelyst"},
		{"ärelystna", "ärelystn"},
		{"ärelystnad", "ärelystn"},
		{"ärende", "ärend"},
		{"ärenden", "ärend"},
		{"ärendet", "ärendet"},
		{"ärft", "ärft"},
		{"ärg", "ärg"},
		{"ärgigt", "ärg"},
		{"ärgstrimmor", "ärgstrimm"},
		{"äring", "äring"},
		{"ärkebiskop", "ärkebiskop"},
		{"ärkenarr", "ärkenarr"},
		{"ärlig", "ärl"},
		{"ärliga", "ärl"},
		{"ärlige", "ärl"},
		{"ärligen", "ärl"},
		{"ärligt", "ärl"},
		{"ärm", "ärm"},
		{"ärmar", "ärm"},
		{"ärmarne", "ärm"},
		{"ärmu", "ärmu"},
		{"ärna", "ärn"},
		{"ärnade", "ärn"},
		{"ärnar", "ärn"},
		{"ärnat", "ärn"},
		{"äro", "äro"},
		{"ärones", "äron"},
		{"ärr", "ärr"},
		{"ärter", "ärt"},
		{"ärtskidor", "ärtskid"},
		{"ärtsängarna", "ärtsäng"},
		{"ärva", "ärv"},
		{"ärvd", "ärvd"},
		{"ärvda", "ärvd"},
		{"ärvde", "ärvd"},
		{"ärver", "ärv"},
		{"ärvt", "ärvt"},
		{"äsch", "äsch"},
		{"äskade", "äsk"},
		{"äskar", "äsk"},
		{"ät", "ät"},
		{"äta", "äta"},
		{"ätbart", "ätbart"},
		{"äter", "äter"},
		{"ätit", "ätit"},
		{"ätlt", "ätlt"},
		{"ätningen", "ätning"},
		{"ätt", "ätt"},
		{"ätten", "ätt"},
		{"ättika", "ättik"},
		{"ättikan", "ättikan"},
		{"äu", "äu"},
		{"ävcn", "ävcn"},
		{"även", "även"},
		{"ävensom", "ävensom"},
		{"äventyr", "äventyr"},
		{"äventyrens", "äventyr"},
		{"äventyret", "äventyret"},
		{"äventyrligheter", "äventyr"},
		{"äventyrslysten", "äventyrslyst"},
		{"ävlan", "ävlan"},
		{"å", "å"},
		{"åar", "åar"},
		{"åberopa", "åberop"},
		{"åberopade", "åberop"},
		{"ådagalade", "ådagal"},
		{"ådagalagt", "ådagalag"},
		{"ådagalägger", "ådagalägg"},
		{"åder", "åder"},
		{"åderman", "åderman"},
		{"ådermans", "åderman"},
		{"ådraga", "ådrag"},
		{"ådragit", "ådragit"},
		{"ådrog", "ådrog"},
		{"ådror", "ådr"},
		{"ådrorna", "ådr"},
		{"åg", "åg"},
		{"åh", "åh"},
		{"åhörande", "åhör"},
		{"åhörare", "åhör"},
		{"åhörarinna", "åhörarin"},
		{"åhörarinnan", "åhörarinnan"},
		{"åhörarna", "åhör"},
		{"åhörarnas", "åhör"},
		{"åhörarskaran", "åhörarskaran"},
		{"åhörde", "åhörd"},
		{"åhört", "åhört"},
		{"åj", "åj"},
		{"åja", "åja"},
		{"åjo", "åjo"},
		{"åka", "åka"},
		{"åkdon", "åkdon"},
		{"åkdonet", "åkdonet"},
		{"åker", "åker"},
		{"åkermans", "åkerman"},
		{"åkern", "åkern"},
		{"åkerns", "åkern"},
		{"åklagare", "åklag"},
		{"åkomma", "åkomm"},
		{"åkomman", "åkomman"},
		{"åkrar", "åkr"},
		{"åkrarna", "åkr"},
		{"åkrarnas", "åkr"},
		{"åkt", "åkt"},
		{"åkte", "åkt"},
		{"ål", "ål"},
		{"ålade", "ålad"},
		{"ålande", "åland"},
		{"ålder", "åld"},
		{"ålderdom", "ålderdom"},
		{"ålderdomen", "ålderdom"},
		{"ålderdoms", "ålderdom"},
		{"åldern", "åld"},
		{"ålders", "ålder"},
		{"ålderstigna", "ålderstign"},
		{"åldrad", "åldr"},
		{"åldrade", "åldr"},
		{"åldrades", "åldr"},
		{"åldrat", "åldr"},
		{"åldrats", "åldrat"},
		{"åldrig", "åldr"},
		{"åldrigaste", "åldr"},
		{"åldring", "åldring"},
		{"åliggande", "åligg"},
		{"åliggandet", "åligg"},
		{"ålägger", "ålägg"},
		{"ån", "ån"},
		{"ånga", "ång"},
		{"ångade", "ång"},
		{"ångan", "ångan"},
		{"ångande", "ång"},
		{"ångares", "ångar"},
		{"ångbåten", "ångbåt"},
		{"ångbåtsfärd", "ångbåtsfärd"},
		{"ångbåtslustfärder", "ångbåtslustfärd"},
		{"ånger", "ång"},
		{"ångerfulle", "ångerfull"},
		{"ångerfullt", "ångerfull"},
		{"ångern", "ång"},
		{"ångerns", "ång"},
		{"ångest", "ångest"},
		{"ångesten", "ångest"},
		{"ångestfull", "ångestfull"},
		{"ångestfulla", "ångestfull"},
		{"ångestfullt", "ångestfull"},
		{"ångfartyg", "ångfartyg"},
		{"ångfartygen", "ångfartyg"},
		{"ångor", "ång"},
		{"ångra", "ångr"},
		{"ångrade", "ångr"},
		{"ångrar", "ångr"},
		{"ångrat", "ångr"},
		{"ångslup", "ångslup"},
		{"ångst", "ångst"},
		{"ångsten", "ångst"},
		{"ånyo", "ånyo"},
		{"år", "år"},
		{"åratal", "åratal"},
		{"åren", "åren"},
		{"årens", "åren"},
		{"året", "året"},
		{"årets", "året"},
		{"århundrade", "århundr"},
		{"århundrades", "århundr"},
		{"århundradets", "århundradet"},
		{"årlig", "årl"},
		{"årliga", "årl"},
		{"årligen", "årl"},
		{"årligt", "årl"},
		{"årorna", "årorn"},
		{"års", "års"},
		{"årspremierna", "årspremi"},
		{"årsuppköp", "årsuppköp"},
		{"årtag", "årtag"},
		{"årtal", "årtal"},
		{"årtionden", "årtiond"},
		{"årtusenden", "årtusend"},
		{"åsar", "åsar"},
		{"åse", "åse"},
		{"åsen", "åsen"},
		{"åsett", "åset"},
		{"åsigt", "åsig"},
		{"åsigter", "åsig"},
		{"åsikt", "åsik"},
		{"åsikten", "åsik"},
		{"åsikter", "åsik"},
		{"åska", "åsk"},
		{"åskan", "åskan"},
		{"åskor", "åsk"},
		{"åskstråle", "åskstrål"},
		{"åskådandets", "åskådandet"},
		{"åskådare", "åskåd"},
		{"åskådareplatsen", "åskådareplats"},
		{"åskådares", "åskådar"},
		{"åskådarna", "åskåd"},
		{"åskådarnas", "åskåd"},
		{"åskådlig", "åskåd"},
		{"åskådliga", "åskåd"},
		{"åstad", "åst"},
		{"åstadkomma", "åstadkomm"},
		{"åstadkommit", "åstadkommit"},
		{"åstundar", "åstund"},
		{"åsyftade", "åsyft"},
		{"åsyn", "åsyn"},
		{"åsynen", "åsyn"},
		{"åt", "åt"},
		{"åtaga", "åtag"},
		{"åtager", "åtag"},
		{"åtagit", "åtagit"},
		{"åtar", "åtar"},
		{"åtbörd", "åtbörd"},
		{"åtbörder", "åtbörd"},
		{"åtcr", "åtcr"},
		{"åtdragen", "åtdrag"},
		{"åter", "åter"},
		{"återbetalningen", "återbetalning"},
		{"återbjudande", "återbjud"},
		{"återbringa", "återbring"},
		{"återbud", "återbud"},
		{"återfalla", "återfall"},
		{"återfann", "återfan"},
		{"återfick", "återfick"},
		{"återfingo", "återfingo"},
		{"återfinna", "återfin"},
		{"återfinner", "återfin"},
		{"återfunnit", "återfunnit"},
		{"återfärden", "återfärd"},
		{"återfå", "återfå"},
		{"återfår", "återfår"},
		{"återfått", "återfåt"},
		{"återfödd", "återföd"},
		{"återföll", "återföll"},
		{"återföra", "återför"},
		{"återförsätta", "återförsät"},
		{"återgaf", "återgaf"},
		{"återgav", "återgav"},
		{"återgavs", "återgav"},
		{"återgivit", "återgivit"},
		{"återglansen", "återglans"},
		{"återgälda", "återgäld"},
		{"återgäldade", "återgäld"},
		{"återgåvo", "återgåvo"},
		{"återgåvos", "återgåvo"},
		{"återhålla", "återhåll"},
		{"återhållen", "återhåll"},
		{"återhållsam", "återhållsam"},
		{"återigen", "åter"},
		{"återkalla", "återkall"},
		{"återkallade", "återkall"},
		{"återkallandet", "återkall"},
		{"återklingat", "återkling"},
		{"återkom", "återkom"},
		{"återkomma", "återkomm"},
		{"återkommande", "återkomm"},
		{"återkommen", "återkomm"},
		{"återkommer", "återkomm"},
		{"återkommo", "återkommo"},
		{"återkomst", "återkomst"},
		{"återkomsten", "återkomst"},
		{"återkomsteu", "återkomsteu"},
		{"återräckte", "återräck"},
		{"återse", "åters"},
		{"återseende", "återseend"},
		{"återseendet", "återseendet"},
		{"återsett", "återset"},
		{"återsken", "återsk"},
		{"återspeglade", "återspegl"},
		{"återstar", "återst"},
		{"återstod", "återstod"},
		{"återstoden", "återstod"},
		{"återstodo", "återstodo"},
		{"återställa", "återställ"},
		{"återställande", "återställ"},
		{"återställt", "återställt"},
		{"återstå", "återstå"},
		{"återståen", "återstå"},
		{"återstående", "återståend"},
		{"återstår", "återstår"},
		{"återsvar", "återsv"},
		{"återsågo", "återsågo"},
		{"återtaga", "återtag"},
		{"återtagen", "återtag"},
		{"återtagit", "återtagit"},
		{"återtog", "återtog"},
		{"återtogo", "återtogo"},
		{"återtogs", "återtog"},
		{"återuppliva", "återuppliv"},
		{"återupprepandet", "återupprep"},
		{"återuppstå", "återuppstå"},
		{"återupptages", "återupptag"},
		{"återupptagit", "återupptagit"},
		{"återvaknat", "återvakn"},
		{"återvanda", "återvand"},
		{"återvann", "återvan"},
		{"återvunna", "återvun"},
		{"återväcka", "återväck"},
		{"återvägen", "återväg"},
		{"återvända", "återvänd"},
		{"återvändande", "återvänd"},
		{"återvände", "återvänd"},
		{"återvänder", "återvänd"},
		{"återvändo", "återvändo"},
		{"återvänt", "återvänt"},
		{"återväntades", "återvänt"},
		{"åtfölja", "åtfölj"},
		{"åtföljas", "åtfölj"},
		{"åtföljd", "åtföljd"},
		{"åtföljda", "åtföljd"},
		{"åtföljde", "åtföljd"},
		{"åtföljdes", "åtföljd"},
		{"åtgick", "åtgick"},
		{"åtgingo", "åtgingo"},
		{"åtgå", "åtgå"},
		{"åtgångna", "åtgångn"},
		{"åtknäppt", "åtknäppt"},
		{"åtlutade", "åtlut"},
		{"åtlydd", "åtlyd"},
		{"åtlydde", "åtlyd"},
		{"åtlöje", "åtlöj"},
		{"åtminstone", "åtminston"},
		{"åtnjutande", "åtnjut"},
		{"åtnjutit", "åtnjutit"},
		{"åtnjutna", "åtnjutn"},
		{"åtnjöt", "åtnjöt"},
		{"åtnöj", "åtnöj"},
		{"åto", "åto"},
		{"åtog", "åtog"},
		{"åtrå", "åtrå"},
		{"åtrådda", "åtråd"},
		{"åtråfyllt", "åtråfyllt"},
		{"åtrån", "åtrån"},
		{"åtsittande", "åtsit"},
		{"åtskildes", "åtskild"},
		{"åtskilliga", "åtskil"},
		{"åtskilligt", "åtskil"},
		{"åtsmetat", "åtsmet"},
		{"åtsnurrade", "åtsnurr"},
		{"åtstramade", "åtstram"},
		{"åtstruket", "åtstruket"},
		{"ått", "ått"},
		{"åtta", "ått"},
		{"åttiofjerde", "åttiofjerd"},
		{"åttkantigt", "åttkant"},
		{"åttonde", "åttond"},
		{"åtvridna", "åtvridn"},
		{"ö", "ö"},
		{"öar", "öar"},
		{"öd", "öd"},
		{"öda", "öda"},
		{"ödas", "ödas"},
		{"ödda", "ödd"},
		{"öde", "öde"},
		{"öden", "öden"},
		{"ödesbestämda", "ödesbestämd"},
		{"ödesbestämt", "ödesbestämt"},
		{"ödesdigert", "ödesdigert"},
		{"ödeshemman", "ödeshemman"},
		{"ödeshemmanet", "ödeshemmanet"},
		{"ödet", "ödet"},
		{"ödets", "ödet"},
		{"ödipus", "ödipus"},
		{"ödmjaka", "ödmjak"},
		{"ödmjuk", "ödmjuk"},
		{"ödmjuka", "ödmjuk"},
		{"ödmjukas", "ödmjuk"},
		{"ödmjukast", "ödmjuk"},
		{"ödmjukaste", "ödmjuk"},
		{"ödmjukat", "ödmjuk"},
		{"ödmjukhet", "ödmjuk"},
		{"ödmjukt", "ödmjuk"},
		{"ödsla", "ödsl"},
		{"ödslig", "öds"},
		{"ödsliga", "öds"},
		{"ödsligare", "öds"},
		{"ödslighet", "öds"},
		{"ödslighetens", "öds"},
		{"ödsligt", "öds"},
		{"öfriga", "öfr"},
		{"öfrigt", "öfr"},
		{"öfvade", "öfv"},
		{"öfvadt", "öfvad"},
		{"öfvat", "öfv"},
		{"öfver", "öfv"},
		{"öfverallt", "öfverallt"},
		{"öfverbrytande", "öfverbryt"},
		{"öfverdrag", "öfverdrag"},
		{"öfverdrifven", "öfverdrifv"},
		{"öfverdrifvet", "öfverdrifvet"},
		{"öfverdrogs", "öfverdrog"},
		{"öfverduktig", "öfverdukt"},
		{"öfverdådig", "öfverdåd"},
		{"öfverdådiga", "öfverdåd"},
		{"öfverenskommit", "öfverenskommit"},
		{"öfverensstämde", "öfverensstämd"},
		{"öfverensstämmande", "öfverensstämm"},
		{"öfverensstämmelse", "öfverensstämm"},
		{"öfverflyttade", "öfverflyt"},
		{"öfverflödiga", "öfverflöd"},
		{"öfverflödigt", "öfverflöd"},
		{"öfvergaf", "öfvergaf"},
		{"öfverge", "öfverg"},
		{"öfvergifna", "öfvergifn"},
		{"öfvergifnas", "öfvergifn"},
		{"öfvergifva", "öfvergifv"},
		{"öfvergifven", "öfvergifv"},
		{"öfvergifver", "öfvergifv"},
		{"öfvergåfvo", "öfvergåfvo"},
		{"öfvergår", "öfvergår"},
		{"öfvergått", "öfvergåt"},
		{"öfverhalning", "öfverhalning"},
		{"öfverhufvud", "öfverhufvud"},
		{"öfverhängande", "öfverhäng"},
		{"öfverlade", "öfverl"},
		{"öfverlagt", "öfverlag"},
		{"öfverlastad", "öfverlast"},
		{"öfverlefva", "öfverlefv"},
		{"öfverlefvat", "öfverlefv"},
		{"öfverlemna", "öfverlemn"},
		{"öfverlemnade", "öfverlemn"},
		{"öfverlemnar", "öfverlemn"},
		{"öfverlemnas", "öfverlemn"},
		{"öfverlyckliga", "öfverlyck"},
		{"öfverlägga", "öfverlägg"},
		{"öfverläggning", "öfverläggning"},
		{"öfverläggningar", "öfverläggning"},
		{"öfverlägsenhet", "öfverlägsen"},
		{"öfverlät", "öfverlät"},
		{"öfverlåtande", "öfverlåt"},
		{"öfverman", "öfverman"},
		{"öfvermod", "öfvermod"},
		{"öfvermorgon", "öfvermorgon"},
		{"öfvermåttan", "öfvermåttan"},
		{"öfverraska", "öfverrask"},
		{"öfverraskad", "öfverrask"},
		{"öfverraskade", "öfverrask"},
		{"öfverraskades", "öfverrask"},
		{"öfverraskat", "öfverrask"},
		{"öfverraskning", "öfverraskning"},
		{"öfverraskningen", "öfverraskning"},
		{"öfverräknat", "öfverräkn"},
		{"öfversittare", "öfversit"},
		{"öfverslogo", "öfverslogo"},
		{"öfversta", "öfverst"},
		{"öfversteg", "öfversteg"},
		{"öfverstånden", "öfverstånd"},
		{"öfverståndna", "öfverståndn"},
		{"öfvertaga", "öfvertag"},
		{"öfvertala", "öfvertal"},
		{"öfvertalat", "öfvertal"},
		{"öfvertyga", "öfvertyg"},
		{"öfvertygad", "öfvertyg"},
		{"öfvertygade", "öfvertyg"},
		{"öfvertygande", "öfvertyg"},
		{"öfvertygar", "öfvertyg"},
		{"öfvertygas", "öfvertyg"},
		{"öfvertygat", "öfvertyg"},
		{"öfvertygelse", "öfvertyg"},
		{"öfvertygelsen", "öfvertyg"},
		{"öfvertänkt", "öfvertänk"},
		{"öfvertänkte", "öfvertänk"},
		{"öfvervann", "öfvervan"},
		{"öfvervinna", "öfvervin"},
		{"öfvervunnen", "öfvervun"},
		{"öfverväg", "öfverväg"},
		{"öfvervägande", "öfverväg"},
		{"öfverändakastar", "öfverändakast"},
		{"öga", "öga"},
		{"ögat", "ögat"},
		{"ögats", "ögat"},
		{"ögmlell", "ögmlell"},
		{"ögna", "ögn"},
		{"ögnade", "ögn"},
		{"ögo", "ögo"},
		{"ögon", "ögon"},
		{"ögona", "ögon"},
		{"ögonblick", "ögonblick"},
		{"ögonblicken", "ögonblick"},
		{"ögonblicket", "ögonblicket"},
		{"ögonblickets", "ögonblicket"},
		{"ögonblickliga", "ögonblick"},
		{"ögonblickligen", "ögonblick"},
		{"ögonblickligt", "ögonblick"},
		{"ögonblicks", "ögonblick"},
		{"ögonbryn", "ögonbryn"},
		{"ögonbrynen", "ögonbryn"},
		{"ögonbrynens", "ögonbryn"},
		{"ögonbryrl", "ögonbryrl"},
		{"ögoncn", "ögoncn"},
		{"ögonem", "ögonem"},
		{"ögonen", "ögon"},
		{"ögonens", "ögon"},
		{"ögonfransar", "ögonfrans"},
		{"ögonfägnad", "ögonfägn"},
		{"ögonhar", "ögonh"},
		{"ögonhålorna", "ögonhål"},
		{"ögonhår", "ögonhår"},
		{"ögonhåren", "ögonhår"},
		{"ögonkast", "ögonk"},
		{"ögonkastet", "ögonkastet"},
		{"ögonlock", "ögonlock"},
		{"ögonlocken", "ögonlock"},
		{"ögonmick", "ögonmick"},
		{"ögonmyster", "ögonmyst"},
		{"ögonsigte", "ögons"},
		{"ögonsikte", "ögonsik"},
		{"ögonskenligen", "ögonsken"},
		{"ögonsten", "ögonst"},
		{"ögonsvärta", "ögonsvärt"},
		{"ögonvatten", "ögonvat"},
		{"ögonvitor", "ögonvit"},
		{"öjan", "öjan"},
		{"ök", "ök"},
		{"öka", "öka"},
		{"ökad", "ökad"},
		{"ökade", "ökad"},
		{"ökades", "ökad"},
		{"ökar", "ökar"},
		{"öken", "öken"},
		{"ökentorrt", "ökentorrt"},
		{"ökn", "ökn"},
		{"öknamn", "öknamn"},
		{"öknen", "ökn"},
		{"öknens", "ökn"},
		{"ökniga", "ökn"},
		{"öl", "öl"},
		{"ölet", "ölet"},
		{"ölost", "ölost"},
		{"ölostskålen", "ölostskål"},
		{"ölsupa", "ölsup"},
		{"öltunnor", "öltun"},
		{"öm", "öm"},
		{"ömhet", "ömhet"},
		{"ömhjärtade", "ömhjärt"},
		{"ömkade", "ömk"},
		{"ömkande", "ömk"},
		{"ömkilig", "ömki"},
		{"ömklig", "ömk"},
		{"ömkliga", "ömk"},
		{"ömkligt", "ömk"},
		{"ömma", "ömm"},
		{"ömmade", "ömm"},
		{"ömmande", "ömm"},
		{"ömmare", "ömm"},
		{"ömmaste", "ömm"},
		{"ömme", "ömm"},
		{"ömse", "öms"},
		{"ömsesidig", "ömsesid"},
		{"ömsesidiga", "ömsesid"},
		{"ömsesidigt", "ömsesid"},
		{"ömsinta", "ömsint"},
		{"ömsom", "ömsom"},
		{"ömt", "ömt"},
		{"ömtålig", "ömtå"},
		{"ömtåliga", "ömtå"},
		{"ön", "ön"},
		{"öns", "öns"},
		{"önska", "önsk"},
		{"önskade", "önsk"},
		{"önskan", "önskan"},
		{"önskar", "önsk"},
		{"önskat", "önsk"},
		{"önskligt", "önsk"},
		{"önskningar", "önskning"},
		{"önskningarna", "önskning"},
		{"önskningars", "önskningar"},
		{"önskvärd", "önskvärd"},
		{"önskvärdt", "önskvärd"},
		{"önskvärt", "önskvärt"},
		{"öpp", "öpp"},
		{"öppen", "öpp"},
		{"öppenhet", "öppen"},
		{"öppenhjertig", "öppenhjert"},
		{"öppenhjärtig", "öppenhjärt"},
		{"öppenhjärtigt", "öppenhjärt"},
		{"öppet", "öppet"},
		{"öppna", "öppn"},
		{"öppnad", "öppn"},
		{"öppnade", "öppn"},
		{"öppnades", "öppn"},
		{"öppnar", "öppn"},
		{"öppnas", "öppn"},
		{"öppnat", "öppn"},
		{"öppnats", "öppnat"},
		{"öppnen", "öppn"},
		{"öppningar", "öppning"},
		{"öppningen", "öppning"},
		{"ör", "ör"},
		{"öra", "öra"},
		{"örat", "örat"},
		{"öre", "öre"},
		{"öregrund", "öregrund"},
		{"öresund", "öresund"},
		{"örfilar", "örfil"},
		{"örhinnor", "örhin"},
		{"örklarligt", "örklar"},
		{"örmåga", "örmåg"},
		{"örn", "örn"},
		{"örnar", "örn"},
		{"örnens", "örn"},
		{"örnungen", "örnung"},
		{"öro", "öro"},
		{"öron", "öron"},
		{"öronen", "öron"},
		{"örsnibbarna", "örsnibb"},
		{"örtagård", "örtagård"},
		{"örter", "ört"},
		{"örternas", "ört"},
		{"örvitlig", "örvit"},
		{"ösa", "ösa"},
		{"ösregn", "ösregn"},
		{"ösregna", "ösregn"},
		{"östan", "östan"},
		{"östanvinden", "östanvind"},
		{"öste", "öst"},
		{"öster", "öst"},
		{"östergötland", "östergötland"},
		{"österlandet", "österl"},
		{"östermalm", "östermalm"},
		{"österrike", "österrik"},
		{"östersjön", "östersjön"},
		{"östersjöprovinsernas", "östersjöprovins"},
		{"östligt", "öst"},
		{"östra", "östr"},
		{"öt", "öt"},
		{"öva", "öva"},
		{"övade", "övad"},
		{"övar", "övar"},
		{"övat", "övat"},
		{"övcr", "övcr"},
		{"över", "över"},
		{"överallt", "överallt"},
		{"överbefolkades", "överbefolk"},
		{"överbevisa", "överbevis"},
		{"överbevisar", "överbevis"},
		{"överblivna", "överblivn"},
		{"överbryggad", "överbrygg"},
		{"överdrag", "överdrag"},
		{"överdraget", "överdraget"},
		{"överdriven", "överdriv"},
		{"överdriver", "överdriv"},
		{"överdrivet", "överdrivet"},
		{"överdrivna", "överdrivn"},
		{"överdrogs", "överdrog"},
		{"överdådig", "överdåd"},
		{"överdådigt", "överdåd"},
		{"överens", "över"},
		{"överenskommelse", "överenskomm"},
		{"överenskommelsen", "överenskomm"},
		{"överenskommet", "överenskommet"},
		{"överenskommit", "överenskommit"},
		{"överensstämde", "överensstämd"},
		{"överensstämma", "överensstämm"},
		{"överensstämmande", "överensstämm"},
		{"överensstämmelse", "överensstämm"},
		{"överensstämmer", "överensstämm"},
		{"överfallit", "överfallit"},
		{"överfarten", "överfart"},
		{"överfarter", "överfart"},
		{"överflyglad", "överflygl"},
		{"överflöd", "överflöd"},
		{"överflödande", "överflöd"},
		{"överflödig", "överflöd"},
		{"överflödiga", "överflöd"},
		{"överflödigt", "överflöd"},
		{"överfor", "överf"},
		{"överfull", "överfull"},
		{"överfullt", "överfull"},
		{"överfölls", "överföll"},
		{"övergav", "övergav"},
		{"överge", "överg"},
		{"överger", "överg"},
		{"övergick", "övergick"},
		{"övergiva", "övergiv"},
		{"övergiven", "övergiv"},
		{"övergivet", "övergivet"},
		{"övergivit", "övergivit"},
		{"övergivna", "övergivn"},
		{"övergjutas", "övergjut"},
		{"övergjutits", "övergjutit"},
		{"övergula", "övergul"},
		{"övergå", "övergå"},
		{"övergångar", "övergång"},
		{"övergår", "övergår"},
		{"övergått", "övergåt"},
		{"överhopad", "överhop"},
		{"överhopades", "överhop"},
		{"överhopar", "överhop"},
		{"överhängande", "överhäng"},
		{"överhöljda", "överhöljd"},
		{"överhöljt", "överhöljt"},
		{"överkäken", "överkäk"},
		{"överkörd", "överkörd"},
		{"överlagt", "överlag"},
		{"överlapp", "överlapp"},
		{"överlastad", "överlast"},
		{"överleva", "överlev"},
		{"överlyckliga", "överlyck"},
		{"överlägga", "överlägg"},
		{"överläggning", "överläggning"},
		{"överläggningar", "överläggning"},
		{"överlägsenhet", "överlägsen"},
		{"överlägsna", "överlägsn"},
		{"överläkarens", "överläk"},
		{"överlämna", "överlämn"},
		{"överlämnad", "överlämn"},
		{"överlämnade", "överlämn"},
		{"överlämnar", "överlämn"},
		{"överlämnat", "överlämn"},
		{"överlämnats", "överlämnat"},
		{"överläpp", "överläpp"},
		{"överläppen", "överläpp"},
		{"överlåtit", "överlåtit"},
		{"överman", "överman"},
		{"övermannad", "överman"},
		{"övermod", "övermod"},
		{"övermäktiga", "övermäkt"},
		{"övermäktigt", "övermäkt"},
		{"övermålat", "övermål"},
		{"övermåttan", "övermåttan"},
		{"överordnade", "överordn"},
		{"överraska", "överrask"},
		{"överraskad", "överrask"},
		{"överraskadc", "överraskadc"},
		{"överraskade", "överrask"},
		{"överraskades", "överrask"},
		{"överraskande", "överrask"},
		{"överraskat", "överrask"},
		{"överraskning", "överraskning"},
		{"överraskningar", "överraskning"},
		{"överraskningen", "överraskning"},
		{"överraskningspappor", "överraskningspapp"},
		{"överrock", "överrock"},
		{"överräknade", "överräkn"},
		{"överräknandet", "överräkn"},
		{"överrösta", "överröst"},
		{"översatta", "översat"},
		{"överseendets", "överseendet"},
		{"översh", "översh"},
		{"översittarmin", "översittarmin"},
		{"överskattar", "överskat"},
		{"överskott", "överskot"},
		{"överskrider", "överskrid"},
		{"överskridit", "överskridit"},
		{"överskrift", "överskrift"},
		{"överskådande", "överskåd"},
		{"översta", "överst"},
		{"översteg", "översteg"},
		{"överstelöjtnant", "överstelöjtnant"},
		{"överstelöjtnanten", "överstelöjtnant"},
		{"överstiger", "överst"},
		{"överstinnan", "överstinnan"},
		{"överströmmande", "överströmm"},
		{"överstrött", "överströt"},
		{"översvalla", "översvall"},
		{"översvallande", "översvall"},
		{"översvämmades", "översvämm"},
		{"översvämning", "översvämning"},
		{"översättning", "översättning"},
		{"övertaga", "övertag"},
		{"övertala", "övertal"},
		{"övertalade", "övertal"},
		{"övertalande", "övertal"},
		{"överträffar", "överträff"},
		{"övertvgade", "övertvg"},
		{"övertvgelse", "övertvg"},
		{"övertyg", "övertyg"},
		{"övertyga", "övertyg"},
		{"övertygad", "övertyg"},
		{"övertygade", "övertyg"},
		{"övertygat", "övertyg"},
		{"övertygelse", "övertyg"},
		{"övertygelsen", "övertyg"},
		{"övertänkt", "övertänk"},
		{"övervann", "övervan"},
		{"övervar", "överv"},
		{"övervikt", "övervik"},
		{"övervinna", "övervin"},
		{"övervinnande", "övervin"},
		{"övervunna", "övervun"},
		{"övervunnen", "övervun"},
		{"övervunnit", "övervunnit"},
		{"överväga", "överväg"},
		{"övervägande", "överväg"},
		{"övervägde", "överväg"},
		{"övervägt", "överväg"},
		{"överväldigad", "överväld"},
		{"överändakastad", "överändakast"},
		{"överändakastade", "överändakast"},
		{"övning", "övning"},
		{"övningen", "övning"},
		{"övre", "övr"},
		{"övriga", "övr"},
		{"övrigt", "övr"},
		{"öändligt", "öänd"},
	}
	for _, testCase := range testCases {
		result := swedish.Stem(testCase.in, true)
		if result != testCase.out {
			t.Errorf("Expected %v -> %v, but got %v", testCase.in, testCase.out, result)
		}
	}
}
