﻿// http://www.asahi-net.or.jp/~ax2s-kmtn/character/japan.html
// http://charset.uic.jp/show/shiftjis2004/
enum KANJI_LEVEL
{
	KANJI_LEARNING_ORDER_1 = 0x0001,
	KANJI_LEARNING_ORDER_2 = 0x0002,
	KANJI_LEARNING_ORDER_3 = 0x0004,
	KANJI_LEARNING_ORDER_4 = 0x0008,
	KANJI_LEARNING_ORDER_5 = 0x0010,
	KANJI_LEARNING_ORDER_6 = 0x0020,
	KANJI_LEARNING_ORDER_7 = 0x0040,
	KANJI_LEARNING_ORDER_ADDTIONAL = 0x0100,  // if you find garbled character when playing.

	KANJI_LEARNING_ORDER_ALL = 0x01FF,
	
	KANJI_SJIS_L1 = 0x0200,  // daily use. this is ShiftJIS based The level 1 JIS. Almost the same as KANJI_STANDARD.
	KANJI_SJIS_L2 = 0x0400,  // daily use. this is ShiftJIS based The level 2 JIS. Almost the same as KANJI_STANDARD.
	KANJI_SJIS_L3 = 0x0800,  // not daily use. part of the level 3 and 4 JIS.
	
	KANJI_SJIS_ALL = 0x0E00, // ShiftJIS Kanji full support. It is not able to display all the CJK Unified Ideographs.

	// warning Cannot used. BlockAllocator size over. 2048x4096 size = 0x00400000
	KANJI_STANDARD         = 0x2000, // daily use (JIS X 2008 = The level 1 JIS and The leve 2 JIS)
	KANJI_RARELY_USED      = 0x4000, // not daily use. but, The Chinese characters that may be used in a visual novel game maybe. (JIS X 2012 = The level 3 JIS)
	KANJI_LEVEL4           = 0x8000, // JIS X 2008 extend. (JIS X 2013 = JIS X 2008 + 1259 characters of JIS X 2012 + The level 4 JIS)

};

// The parameter is the learning order.
const unsigned short kanjiFilter[] = {
	0x78A7, KANJI_LEARNING_ORDER_ADDTIONAL,  // 碧
	0x7A9F, KANJI_LEARNING_ORDER_ADDTIONAL,  // 窟
	0x4E00, KANJI_LEARNING_ORDER_1,  // 一	
	0x4E01, KANJI_LEARNING_ORDER_3,  // 丁	
	0x4E03, KANJI_LEARNING_ORDER_1,  // 七	
	0x4E07, KANJI_LEARNING_ORDER_2,  // 万	
	0x4E08, KANJI_LEARNING_ORDER_7,  // 丈	
	0x4E09, KANJI_LEARNING_ORDER_1,  // 三	
	0x4E0A, KANJI_LEARNING_ORDER_1,  // 上	
	0x4E0B, KANJI_LEARNING_ORDER_1,  // 下	
	0x4E0D, KANJI_LEARNING_ORDER_4,  // 不	
	0x4E0E, KANJI_LEARNING_ORDER_7,  // 与	
	0x4E14, KANJI_LEARNING_ORDER_7,  // 且	
	0x4E16, KANJI_LEARNING_ORDER_3,  // 世	
	0x4E18, KANJI_LEARNING_ORDER_7,  // 丘	
	0x4E19, KANJI_LEARNING_ORDER_7,  // 丙	
	0x4E21, KANJI_LEARNING_ORDER_3,  // 両	
	0x4E26, KANJI_LEARNING_ORDER_6,  // 並	
	0x4E2D, KANJI_LEARNING_ORDER_1,  // 中	
	0x4E38, KANJI_LEARNING_ORDER_2,  // 丸	
	0x4E39, KANJI_LEARNING_ORDER_7,  // 丹	
	0x4E3B, KANJI_LEARNING_ORDER_3,  // 主	
	0x4E45, KANJI_LEARNING_ORDER_5,  // 久	
	0x4E4F, KANJI_LEARNING_ORDER_7,  // 乏	
	0x4E57, KANJI_LEARNING_ORDER_3,  // 乗	
	0x4E59, KANJI_LEARNING_ORDER_7,  // 乙	
	0x4E5D, KANJI_LEARNING_ORDER_1,  // 九	
	0x4E71, KANJI_LEARNING_ORDER_6,  // 乱	
	0x4E73, KANJI_LEARNING_ORDER_6,  // 乳	
	0x4E7E, KANJI_LEARNING_ORDER_7,  // 乾	
	0x4E86, KANJI_LEARNING_ORDER_7,  // 了	
	0x4E88, KANJI_LEARNING_ORDER_3,  // 予	
	0x4E89, KANJI_LEARNING_ORDER_4,  // 争	
	0x4E8B, KANJI_LEARNING_ORDER_3,  // 事	
	0x4E8C, KANJI_LEARNING_ORDER_1,  // 二	
	0x4E92, KANJI_LEARNING_ORDER_7,  // 互	
	0x4E94, KANJI_LEARNING_ORDER_1,  // 五	
	0x4E95, KANJI_LEARNING_ORDER_7,  // 井	
	0x4E9C, KANJI_LEARNING_ORDER_7,  // 亜	
	0x4EA1, KANJI_LEARNING_ORDER_6,  // 亡	
	0x4EA4, KANJI_LEARNING_ORDER_2,  // 交	
	0x4EAB, KANJI_LEARNING_ORDER_7,  // 享	
	0x4EAC, KANJI_LEARNING_ORDER_2,  // 京	
	0x4EAD, KANJI_LEARNING_ORDER_7,  // 亭	
	0x4EBA, KANJI_LEARNING_ORDER_1,  // 人	
	0x4EC1, KANJI_LEARNING_ORDER_6,  // 仁	
	0x4ECA, KANJI_LEARNING_ORDER_2,  // 今	
	0x4ECB, KANJI_LEARNING_ORDER_7,  // 介	
	0x4ECF, KANJI_LEARNING_ORDER_5,  // 仏	
	0x4ED5, KANJI_LEARNING_ORDER_3,  // 仕	
	0x4ED6, KANJI_LEARNING_ORDER_3,  // 他	
	0x4ED8, KANJI_LEARNING_ORDER_4,  // 付	
	0x4ED9, KANJI_LEARNING_ORDER_7,  // 仙	
	0x4EE3, KANJI_LEARNING_ORDER_3,  // 代	
	0x4EE4, KANJI_LEARNING_ORDER_4,  // 令	
	0x4EE5, KANJI_LEARNING_ORDER_4,  // 以	
	0x4EEE, KANJI_LEARNING_ORDER_5,  // 仮	
	0x4EF0, KANJI_LEARNING_ORDER_7,  // 仰	
	0x4EF2, KANJI_LEARNING_ORDER_4,  // 仲	
	0x4EF6, KANJI_LEARNING_ORDER_5,  // 件	
	0x4EFB, KANJI_LEARNING_ORDER_5,  // 任	
	0x4F01, KANJI_LEARNING_ORDER_7,  // 企	
	0x4F0F, KANJI_LEARNING_ORDER_7,  // 伏	
	0x4F10, KANJI_LEARNING_ORDER_7,  // 伐	
	0x4F11, KANJI_LEARNING_ORDER_1,  // 休	
	0x4F1A, KANJI_LEARNING_ORDER_2,  // 会	
	0x4F1D, KANJI_LEARNING_ORDER_4,  // 伝	
	0x4F2F, KANJI_LEARNING_ORDER_7,  // 伯	
	0x4F34, KANJI_LEARNING_ORDER_7,  // 伴	
	0x4F38, KANJI_LEARNING_ORDER_7,  // 伸	
	0x4F3A, KANJI_LEARNING_ORDER_7,  // 伺	
	0x4F3C, KANJI_LEARNING_ORDER_5,  // 似	
	0x4F46, KANJI_LEARNING_ORDER_7,  // 但	
	0x4F4D, KANJI_LEARNING_ORDER_4,  // 位	
	0x4F4E, KANJI_LEARNING_ORDER_4,  // 低	
	0x4F4F, KANJI_LEARNING_ORDER_3,  // 住	
	0x4F50, KANJI_LEARNING_ORDER_7,  // 佐	
	0x4F53, KANJI_LEARNING_ORDER_2,  // 体	
	0x4F55, KANJI_LEARNING_ORDER_2,  // 何	
	0x4F59, KANJI_LEARNING_ORDER_5,  // 余	
	0x4F5C, KANJI_LEARNING_ORDER_2,  // 作	
	0x4F73, KANJI_LEARNING_ORDER_7,  // 佳	
	0x4F75, KANJI_LEARNING_ORDER_7,  // 併	
	0x4F7F, KANJI_LEARNING_ORDER_3,  // 使	
	0x4F8B, KANJI_LEARNING_ORDER_4,  // 例	
	0x4F8D, KANJI_LEARNING_ORDER_7,  // 侍	
	0x4F9B, KANJI_LEARNING_ORDER_6,  // 供	
	0x4F9D, KANJI_LEARNING_ORDER_7,  // 依	
	0x4FA1, KANJI_LEARNING_ORDER_5,  // 価	
	0x4FAE, KANJI_LEARNING_ORDER_7,  // 侮	
	0x4FAF, KANJI_LEARNING_ORDER_7,  // 侯	
	0x4FB5, KANJI_LEARNING_ORDER_7,  // 侵	
	0x4FBF, KANJI_LEARNING_ORDER_4,  // 便	
	0x4FC2, KANJI_LEARNING_ORDER_3,  // 係	
	0x4FC3, KANJI_LEARNING_ORDER_7,  // 促	
	0x4FCA, KANJI_LEARNING_ORDER_7,  // 俊	
	0x4FD7, KANJI_LEARNING_ORDER_7,  // 俗	
	0x4FDD, KANJI_LEARNING_ORDER_5,  // 保	
	0x4FE1, KANJI_LEARNING_ORDER_4,  // 信	
	0x4FEE, KANJI_LEARNING_ORDER_5,  // 修	
	0x4FF3, KANJI_LEARNING_ORDER_6,  // 俳	
	0x4FF5, KANJI_LEARNING_ORDER_5,  // 俵	
	0x4FF8, KANJI_LEARNING_ORDER_7,  // 俸	
	0x5009, KANJI_LEARNING_ORDER_4,  // 倉	
	0x500B, KANJI_LEARNING_ORDER_5,  // 個	
	0x500D, KANJI_LEARNING_ORDER_3,  // 倍	
	0x5012, KANJI_LEARNING_ORDER_7,  // 倒	
	0x5019, KANJI_LEARNING_ORDER_4,  // 候	
	0x501F, KANJI_LEARNING_ORDER_4,  // 借	
	0x5023, KANJI_LEARNING_ORDER_7,  // 倣	
	0x5024, KANJI_LEARNING_ORDER_6,  // 値	
	0x502B, KANJI_LEARNING_ORDER_7,  // 倫	
	0x5039, KANJI_LEARNING_ORDER_7,  // 倹	
	0x5049, KANJI_LEARNING_ORDER_7,  // 偉	
	0x504F, KANJI_LEARNING_ORDER_7,  // 偏	
	0x505C, KANJI_LEARNING_ORDER_4,  // 停	
	0x5065, KANJI_LEARNING_ORDER_4,  // 健	
	0x5074, KANJI_LEARNING_ORDER_4,  // 側	
	0x5075, KANJI_LEARNING_ORDER_7,  // 偵	
	0x5076, KANJI_LEARNING_ORDER_7,  // 偶	
	0x507D, KANJI_LEARNING_ORDER_7,  // 偽	
	0x508D, KANJI_LEARNING_ORDER_7,  // 傍	
	0x5091, KANJI_LEARNING_ORDER_7,  // 傑	
	0x5098, KANJI_LEARNING_ORDER_7,  // 傘	
	0x5099, KANJI_LEARNING_ORDER_5,  // 備	
	0x50AC, KANJI_LEARNING_ORDER_7,  // 催	
	0x50B5, KANJI_LEARNING_ORDER_7,  // 債	
	0x50B7, KANJI_LEARNING_ORDER_6,  // 傷	
	0x50BE, KANJI_LEARNING_ORDER_7,  // 傾	
	0x50CD, KANJI_LEARNING_ORDER_4,  // 働	
	0x50CF, KANJI_LEARNING_ORDER_5,  // 像	
	0x50D5, KANJI_LEARNING_ORDER_7,  // 僕	
	0x50DA, KANJI_LEARNING_ORDER_7,  // 僚	
	0x50E7, KANJI_LEARNING_ORDER_7,  // 僧	
	0x5100, KANJI_LEARNING_ORDER_7,  // 儀	
	0x5104, KANJI_LEARNING_ORDER_4,  // 億	
	0x5112, KANJI_LEARNING_ORDER_7,  // 儒	
	0x511F, KANJI_LEARNING_ORDER_7,  // 償	
	0x512A, KANJI_LEARNING_ORDER_6,  // 優	
	0x5143, KANJI_LEARNING_ORDER_2,  // 元	
	0x5144, KANJI_LEARNING_ORDER_2,  // 兄	
	0x5145, KANJI_LEARNING_ORDER_7,  // 充	
	0x5146, KANJI_LEARNING_ORDER_4,  // 兆	
	0x5148, KANJI_LEARNING_ORDER_1,  // 先	
	0x5149, KANJI_LEARNING_ORDER_2,  // 光	
	0x514B, KANJI_LEARNING_ORDER_7,  // 克	
	0x514D, KANJI_LEARNING_ORDER_7,  // 免	
	0x5150, KANJI_LEARNING_ORDER_4,  // 児	
	0x515A, KANJI_LEARNING_ORDER_6,  // 党	
	0x5165, KANJI_LEARNING_ORDER_1,  // 入	
	0x5168, KANJI_LEARNING_ORDER_3,  // 全	
	0x516B, KANJI_LEARNING_ORDER_1,  // 八	
	0x516C, KANJI_LEARNING_ORDER_2,  // 公	
	0x516D, KANJI_LEARNING_ORDER_1,  // 六	
	0x5171, KANJI_LEARNING_ORDER_4,  // 共	
	0x5175, KANJI_LEARNING_ORDER_4,  // 兵	
	0x5177, KANJI_LEARNING_ORDER_3,  // 具	
	0x5178, KANJI_LEARNING_ORDER_4,  // 典	
	0x517C, KANJI_LEARNING_ORDER_7,  // 兼	
	0x5185, KANJI_LEARNING_ORDER_2,  // 内	
	0x5186, KANJI_LEARNING_ORDER_1,  // 円	
	0x518A, KANJI_LEARNING_ORDER_6,  // 冊	
	0x518D, KANJI_LEARNING_ORDER_5,  // 再	
	0x5192, KANJI_LEARNING_ORDER_7,  // 冒	
	0x5197, KANJI_LEARNING_ORDER_7,  // 冗	
	0x5199, KANJI_LEARNING_ORDER_3,  // 写	
	0x51A0, KANJI_LEARNING_ORDER_7,  // 冠	
	0x51AC, KANJI_LEARNING_ORDER_2,  // 冬	
	0x51B7, KANJI_LEARNING_ORDER_4,  // 冷	
	0x51C6, KANJI_LEARNING_ORDER_7,  // 准	
	0x51CD, KANJI_LEARNING_ORDER_7,  // 凍	
	0x51DD, KANJI_LEARNING_ORDER_7,  // 凝	
	0x51E1, KANJI_LEARNING_ORDER_7,  // 凡	
	0x51E6, KANJI_LEARNING_ORDER_6,  // 処	
	0x51F6, KANJI_LEARNING_ORDER_7,  // 凶	
	0x51F8, KANJI_LEARNING_ORDER_7,  // 凸	
	0x51F9, KANJI_LEARNING_ORDER_7,  // 凹	
	0x51FA, KANJI_LEARNING_ORDER_1,  // 出	
	0x5200, KANJI_LEARNING_ORDER_2,  // 刀	
	0x5203, KANJI_LEARNING_ORDER_7,  // 刃	
	0x5206, KANJI_LEARNING_ORDER_2,  // 分	
	0x5207, KANJI_LEARNING_ORDER_2,  // 切	
	0x5208, KANJI_LEARNING_ORDER_7,  // 刈	
	0x520A, KANJI_LEARNING_ORDER_5,  // 刊	
	0x5211, KANJI_LEARNING_ORDER_7,  // 刑	
	0x5217, KANJI_LEARNING_ORDER_3,  // 列	
	0x521D, KANJI_LEARNING_ORDER_4,  // 初	
	0x5224, KANJI_LEARNING_ORDER_5,  // 判	
	0x5225, KANJI_LEARNING_ORDER_4,  // 別	
	0x5229, KANJI_LEARNING_ORDER_4,  // 利	
	0x5230, KANJI_LEARNING_ORDER_7,  // 到	
	0x5236, KANJI_LEARNING_ORDER_5,  // 制	
	0x5237, KANJI_LEARNING_ORDER_4,  // 刷	
	0x5238, KANJI_LEARNING_ORDER_5,  // 券	
	0x523A, KANJI_LEARNING_ORDER_7,  // 刺	
	0x523B, KANJI_LEARNING_ORDER_6,  // 刻	
	0x5247, KANJI_LEARNING_ORDER_5,  // 則	
	0x524A, KANJI_LEARNING_ORDER_7,  // 削	
	0x524D, KANJI_LEARNING_ORDER_2,  // 前	
	0x5256, KANJI_LEARNING_ORDER_7,  // 剖	
	0x525B, KANJI_LEARNING_ORDER_7,  // 剛	
	0x5263, KANJI_LEARNING_ORDER_7,  // 剣	
	0x5264, KANJI_LEARNING_ORDER_7,  // 剤	
	0x526F, KANJI_LEARNING_ORDER_4,  // 副	
	0x5270, KANJI_LEARNING_ORDER_7,  // 剰	
	0x5272, KANJI_LEARNING_ORDER_6,  // 割	
	0x5275, KANJI_LEARNING_ORDER_6,  // 創	
	0x5287, KANJI_LEARNING_ORDER_6,  // 劇	
	0x529B, KANJI_LEARNING_ORDER_1,  // 力	
	0x529F, KANJI_LEARNING_ORDER_4,  // 功	
	0x52A0, KANJI_LEARNING_ORDER_4,  // 加	
	0x52A3, KANJI_LEARNING_ORDER_7,  // 劣	
	0x52A9, KANJI_LEARNING_ORDER_3,  // 助	
	0x52AA, KANJI_LEARNING_ORDER_4,  // 努	
	0x52B1, KANJI_LEARNING_ORDER_7,  // 励	
	0x52B4, KANJI_LEARNING_ORDER_4,  // 労	
	0x52B9, KANJI_LEARNING_ORDER_5,  // 効	
	0x52BE, KANJI_LEARNING_ORDER_7,  // 劾	
	0x52C5, KANJI_LEARNING_ORDER_7,  // 勅	
	0x52C7, KANJI_LEARNING_ORDER_4,  // 勇	
	0x52C9, KANJI_LEARNING_ORDER_3,  // 勉	
	0x52D5, KANJI_LEARNING_ORDER_3,  // 動	
	0x52D8, KANJI_LEARNING_ORDER_7,  // 勘	
	0x52D9, KANJI_LEARNING_ORDER_5,  // 務	
	0x52DD, KANJI_LEARNING_ORDER_3,  // 勝	
	0x52DF, KANJI_LEARNING_ORDER_7,  // 募	
	0x52E2, KANJI_LEARNING_ORDER_5,  // 勢	
	0x52E4, KANJI_LEARNING_ORDER_6,  // 勤	
	0x52E7, KANJI_LEARNING_ORDER_7,  // 勧	
	0x52F2, KANJI_LEARNING_ORDER_7,  // 勲	
	0x52FA, KANJI_LEARNING_ORDER_7,  // 勺	
	0x5301, KANJI_LEARNING_ORDER_7,  // 匁	
	0x5305, KANJI_LEARNING_ORDER_4,  // 包	
	0x5316, KANJI_LEARNING_ORDER_3,  // 化	
	0x5317, KANJI_LEARNING_ORDER_2,  // 北	
	0x5320, KANJI_LEARNING_ORDER_7,  // 匠	
	0x5339, KANJI_LEARNING_ORDER_7,  // 匹	
	0x533A, KANJI_LEARNING_ORDER_3,  // 区	
	0x533B, KANJI_LEARNING_ORDER_3,  // 医	
	0x533F, KANJI_LEARNING_ORDER_7,  // 匿	
	0x5341, KANJI_LEARNING_ORDER_1,  // 十	
	0x5343, KANJI_LEARNING_ORDER_1,  // 千	
	0x5347, KANJI_LEARNING_ORDER_7,  // 升	
	0x5348, KANJI_LEARNING_ORDER_2,  // 午	
	0x534A, KANJI_LEARNING_ORDER_2,  // 半	
	0x5351, KANJI_LEARNING_ORDER_7,  // 卑	
	0x5352, KANJI_LEARNING_ORDER_4,  // 卒	
	0x5353, KANJI_LEARNING_ORDER_7,  // 卓	
	0x5354, KANJI_LEARNING_ORDER_4,  // 協	
	0x5357, KANJI_LEARNING_ORDER_2,  // 南	
	0x5358, KANJI_LEARNING_ORDER_4,  // 単	
	0x535A, KANJI_LEARNING_ORDER_4,  // 博	
	0x5360, KANJI_LEARNING_ORDER_7,  // 占	
	0x5370, KANJI_LEARNING_ORDER_4,  // 印	
	0x5371, KANJI_LEARNING_ORDER_6,  // 危	
	0x5373, KANJI_LEARNING_ORDER_7,  // 即	
	0x5374, KANJI_LEARNING_ORDER_7,  // 却	
	0x5375, KANJI_LEARNING_ORDER_6,  // 卵	
	0x5378, KANJI_LEARNING_ORDER_7,  // 卸	
	0x5384, KANJI_LEARNING_ORDER_7,  // 厄	
	0x5398, KANJI_LEARNING_ORDER_7,  // 厘	
	0x539A, KANJI_LEARNING_ORDER_5,  // 厚	
	0x539F, KANJI_LEARNING_ORDER_2,  // 原	
	0x53B3, KANJI_LEARNING_ORDER_6,  // 厳	
	0x53BB, KANJI_LEARNING_ORDER_3,  // 去	
	0x53C2, KANJI_LEARNING_ORDER_4,  // 参	
	0x53C8, KANJI_LEARNING_ORDER_7,  // 又	
	0x53CA, KANJI_LEARNING_ORDER_7,  // 及	
	0x53CB, KANJI_LEARNING_ORDER_2,  // 友	
	0x53CC, KANJI_LEARNING_ORDER_7,  // 双	
	0x53CD, KANJI_LEARNING_ORDER_3,  // 反	
	0x53CE, KANJI_LEARNING_ORDER_6,  // 収	
	0x53D4, KANJI_LEARNING_ORDER_7,  // 叔	
	0x53D6, KANJI_LEARNING_ORDER_3,  // 取	
	0x53D7, KANJI_LEARNING_ORDER_3,  // 受	
	0x53D9, KANJI_LEARNING_ORDER_7,  // 叙	
	0x53E3, KANJI_LEARNING_ORDER_1,  // 口	
	0x53E4, KANJI_LEARNING_ORDER_2,  // 古	
	0x53E5, KANJI_LEARNING_ORDER_5,  // 句	
	0x53EB, KANJI_LEARNING_ORDER_7,  // 叫	
	0x53EC, KANJI_LEARNING_ORDER_7,  // 召	
	0x53EF, KANJI_LEARNING_ORDER_5,  // 可	
	0x53F0, KANJI_LEARNING_ORDER_2,  // 台	
	0x53F2, KANJI_LEARNING_ORDER_4,  // 史	
	0x53F3, KANJI_LEARNING_ORDER_1,  // 右	
	0x53F7, KANJI_LEARNING_ORDER_3,  // 号	
	0x53F8, KANJI_LEARNING_ORDER_4,  // 司	
	0x5404, KANJI_LEARNING_ORDER_4,  // 各	
	0x5408, KANJI_LEARNING_ORDER_2,  // 合	
	0x5409, KANJI_LEARNING_ORDER_7,  // 吉	
	0x540C, KANJI_LEARNING_ORDER_2,  // 同	
	0x540D, KANJI_LEARNING_ORDER_1,  // 名	
	0x540E, KANJI_LEARNING_ORDER_6,  // 后	
	0x540F, KANJI_LEARNING_ORDER_7,  // 吏	
	0x5410, KANJI_LEARNING_ORDER_7,  // 吐	
	0x5411, KANJI_LEARNING_ORDER_3,  // 向	
	0x541B, KANJI_LEARNING_ORDER_3,  // 君	
	0x541F, KANJI_LEARNING_ORDER_7,  // 吟	
	0x5426, KANJI_LEARNING_ORDER_6,  // 否	
	0x542B, KANJI_LEARNING_ORDER_7,  // 含	
	0x5438, KANJI_LEARNING_ORDER_6,  // 吸	
	0x5439, KANJI_LEARNING_ORDER_7,  // 吹	
	0x5448, KANJI_LEARNING_ORDER_7,  // 呈	
	0x5449, KANJI_LEARNING_ORDER_7,  // 呉	
	0x544A, KANJI_LEARNING_ORDER_4,  // 告	
	0x5468, KANJI_LEARNING_ORDER_4,  // 周	
	0x5473, KANJI_LEARNING_ORDER_3,  // 味	
	0x547C, KANJI_LEARNING_ORDER_6,  // 呼	
	0x547D, KANJI_LEARNING_ORDER_3,  // 命	
	0x548C, KANJI_LEARNING_ORDER_3,  // 和	
	0x54B2, KANJI_LEARNING_ORDER_7,  // 咲	
	0x54C0, KANJI_LEARNING_ORDER_7,  // 哀	
	0x54C1, KANJI_LEARNING_ORDER_3,  // 品	
	0x54E1, KANJI_LEARNING_ORDER_3,  // 員	
	0x54F2, KANJI_LEARNING_ORDER_7,  // 哲	
	0x5506, KANJI_LEARNING_ORDER_7,  // 唆	
	0x5507, KANJI_LEARNING_ORDER_7,  // 唇	
	0x5510, KANJI_LEARNING_ORDER_7,  // 唐	
	0x552F, KANJI_LEARNING_ORDER_7,  // 唯	
	0x5531, KANJI_LEARNING_ORDER_4,  // 唱	
	0x5546, KANJI_LEARNING_ORDER_3,  // 商	
	0x554F, KANJI_LEARNING_ORDER_3,  // 問	
	0x5553, KANJI_LEARNING_ORDER_7,  // 啓	
	0x5584, KANJI_LEARNING_ORDER_6,  // 善	
	0x559A, KANJI_LEARNING_ORDER_7,  // 喚	
	0x559C, KANJI_LEARNING_ORDER_4,  // 喜	
	0x559D, KANJI_LEARNING_ORDER_7,  // 喝	
	0x55AA, KANJI_LEARNING_ORDER_7,  // 喪	
	0x55AB, KANJI_LEARNING_ORDER_7,  // 喫	
	0x55B6, KANJI_LEARNING_ORDER_5,  // 営	
	0x55E3, KANJI_LEARNING_ORDER_7,  // 嗣	
	0x5606, KANJI_LEARNING_ORDER_7,  // 嘆	
	0x5631, KANJI_LEARNING_ORDER_7,  // 嘱	
	0x5668, KANJI_LEARNING_ORDER_4,  // 器	
	0x5674, KANJI_LEARNING_ORDER_7,  // 噴	
	0x5687, KANJI_LEARNING_ORDER_7,  // 嚇	
	0x56DA, KANJI_LEARNING_ORDER_7,  // 囚	
	0x56DB, KANJI_LEARNING_ORDER_1,  // 四	
	0x56DE, KANJI_LEARNING_ORDER_2,  // 回	
	0x56E0, KANJI_LEARNING_ORDER_5,  // 因	
	0x56E3, KANJI_LEARNING_ORDER_5,  // 団	
	0x56F0, KANJI_LEARNING_ORDER_6,  // 困	
	0x56F2, KANJI_LEARNING_ORDER_4,  // 囲	
	0x56F3, KANJI_LEARNING_ORDER_2,  // 図	
	0x56FA, KANJI_LEARNING_ORDER_4,  // 固	
	0x56FD, KANJI_LEARNING_ORDER_2,  // 国	
	0x570F, KANJI_LEARNING_ORDER_7,  // 圏	
	0x5712, KANJI_LEARNING_ORDER_2,  // 園	
	0x571F, KANJI_LEARNING_ORDER_1,  // 土	
	0x5727, KANJI_LEARNING_ORDER_5,  // 圧	
	0x5728, KANJI_LEARNING_ORDER_5,  // 在	
	0x5730, KANJI_LEARNING_ORDER_2,  // 地	
	0x5742, KANJI_LEARNING_ORDER_3,  // 坂	
	0x5747, KANJI_LEARNING_ORDER_5,  // 均	
	0x574A, KANJI_LEARNING_ORDER_7,  // 坊	
	0x5751, KANJI_LEARNING_ORDER_7,  // 坑	
	0x576A, KANJI_LEARNING_ORDER_7,  // 坪	
	0x5782, KANJI_LEARNING_ORDER_6,  // 垂	
	0x578B, KANJI_LEARNING_ORDER_4,  // 型	
	0x57A3, KANJI_LEARNING_ORDER_7,  // 垣	
	0x57CB, KANJI_LEARNING_ORDER_7,  // 埋	
	0x57CE, KANJI_LEARNING_ORDER_6,  // 城	
	0x57DF, KANJI_LEARNING_ORDER_6,  // 域	
	0x57F7, KANJI_LEARNING_ORDER_7,  // 執	
	0x57F9, KANJI_LEARNING_ORDER_7,  // 培	
	0x57FA, KANJI_LEARNING_ORDER_5,  // 基	
	0x5800, KANJI_LEARNING_ORDER_7,  // 堀	
	0x5802, KANJI_LEARNING_ORDER_4,  // 堂	
	0x5805, KANJI_LEARNING_ORDER_7,  // 堅	
	0x5815, KANJI_LEARNING_ORDER_7,  // 堕	
	0x5824, KANJI_LEARNING_ORDER_7,  // 堤	
	0x582A, KANJI_LEARNING_ORDER_7,  // 堪	
	0x5831, KANJI_LEARNING_ORDER_5,  // 報	
	0x5834, KANJI_LEARNING_ORDER_2,  // 場	
	0x5840, KANJI_LEARNING_ORDER_7,  // 塀	
	0x5841, KANJI_LEARNING_ORDER_7,  // 塁	
	0x584A, KANJI_LEARNING_ORDER_7,  // 塊	
	0x5851, KANJI_LEARNING_ORDER_7,  // 塑	
	0x5854, KANJI_LEARNING_ORDER_7,  // 塔	
	0x5857, KANJI_LEARNING_ORDER_7,  // 塗	
	0x585A, KANJI_LEARNING_ORDER_7,  // 塚	
	0x5869, KANJI_LEARNING_ORDER_4,  // 塩	
	0x587E, KANJI_LEARNING_ORDER_7,  // 塾	
	0x5883, KANJI_LEARNING_ORDER_5,  // 境	
	0x5893, KANJI_LEARNING_ORDER_5,  // 墓	
	0x5897, KANJI_LEARNING_ORDER_5,  // 増	
	0x589C, KANJI_LEARNING_ORDER_7,  // 墜	
	0x58A8, KANJI_LEARNING_ORDER_7,  // 墨	
	0x58B3, KANJI_LEARNING_ORDER_7,  // 墳	
	0x58BE, KANJI_LEARNING_ORDER_7,  // 墾	
	0x58C1, KANJI_LEARNING_ORDER_7,  // 壁	
	0x58C7, KANJI_LEARNING_ORDER_7,  // 壇	
	0x58CA, KANJI_LEARNING_ORDER_7,  // 壊	
	0x58CC, KANJI_LEARNING_ORDER_7,  // 壌	
	0x58EB, KANJI_LEARNING_ORDER_4,  // 士	
	0x58EE, KANJI_LEARNING_ORDER_7,  // 壮	
	0x58F0, KANJI_LEARNING_ORDER_2,  // 声	
	0x58F1, KANJI_LEARNING_ORDER_7,  // 壱	
	0x58F2, KANJI_LEARNING_ORDER_2,  // 売	
	0x5909, KANJI_LEARNING_ORDER_4,  // 変	
	0x590F, KANJI_LEARNING_ORDER_2,  // 夏	
	0x5915, KANJI_LEARNING_ORDER_1,  // 夕	
	0x5916, KANJI_LEARNING_ORDER_2,  // 外	
	0x591A, KANJI_LEARNING_ORDER_2,  // 多	
	0x591C, KANJI_LEARNING_ORDER_2,  // 夜	
	0x5922, KANJI_LEARNING_ORDER_5,  // 夢	
	0x5927, KANJI_LEARNING_ORDER_1,  // 大	
	0x5929, KANJI_LEARNING_ORDER_1,  // 天	
	0x592A, KANJI_LEARNING_ORDER_2,  // 太	
	0x592B, KANJI_LEARNING_ORDER_4,  // 夫	
	0x592E, KANJI_LEARNING_ORDER_3,  // 央	
	0x5931, KANJI_LEARNING_ORDER_4,  // 失	
	0x5947, KANJI_LEARNING_ORDER_7,  // 奇	
	0x5949, KANJI_LEARNING_ORDER_7,  // 奉	
	0x594F, KANJI_LEARNING_ORDER_6,  // 奏	
	0x5951, KANJI_LEARNING_ORDER_7,  // 契	
	0x5954, KANJI_LEARNING_ORDER_7,  // 奔	
	0x5965, KANJI_LEARNING_ORDER_7,  // 奥	
	0x5968, KANJI_LEARNING_ORDER_7,  // 奨	
	0x596A, KANJI_LEARNING_ORDER_7,  // 奪	
	0x596E, KANJI_LEARNING_ORDER_6,  // 奮	
	0x5973, KANJI_LEARNING_ORDER_1,  // 女	
	0x5974, KANJI_LEARNING_ORDER_7,  // 奴	
	0x597D, KANJI_LEARNING_ORDER_4,  // 好	
	0x5982, KANJI_LEARNING_ORDER_7,  // 如	
	0x5983, KANJI_LEARNING_ORDER_7,  // 妃	
	0x5984, KANJI_LEARNING_ORDER_7,  // 妄	
	0x598A, KANJI_LEARNING_ORDER_7,  // 妊	
	0x5999, KANJI_LEARNING_ORDER_7,  // 妙	
	0x59A5, KANJI_LEARNING_ORDER_7,  // 妥	
	0x59A8, KANJI_LEARNING_ORDER_7,  // 妨	
	0x59B9, KANJI_LEARNING_ORDER_2,  // 妹	
	0x59BB, KANJI_LEARNING_ORDER_5,  // 妻	
	0x59C9, KANJI_LEARNING_ORDER_2,  // 姉	
	0x59CB, KANJI_LEARNING_ORDER_3,  // 始	
	0x59D3, KANJI_LEARNING_ORDER_7,  // 姓	
	0x59D4, KANJI_LEARNING_ORDER_3,  // 委	
	0x59EB, KANJI_LEARNING_ORDER_7,  // 姫	
	0x59FB, KANJI_LEARNING_ORDER_7,  // 姻	
	0x59FF, KANJI_LEARNING_ORDER_6,  // 姿	
	0x5A01, KANJI_LEARNING_ORDER_7,  // 威	
	0x5A18, KANJI_LEARNING_ORDER_7,  // 娘	
	0x5A20, KANJI_LEARNING_ORDER_7,  // 娠	
	0x5A2F, KANJI_LEARNING_ORDER_7,  // 娯	
	0x5A46, KANJI_LEARNING_ORDER_7,  // 婆	
	0x5A5A, KANJI_LEARNING_ORDER_7,  // 婚	
	0x5A66, KANJI_LEARNING_ORDER_5,  // 婦	
	0x5A7F, KANJI_LEARNING_ORDER_7,  // 婿	
	0x5A92, KANJI_LEARNING_ORDER_7,  // 媒	
	0x5AC1, KANJI_LEARNING_ORDER_7,  // 嫁	
	0x5ACC, KANJI_LEARNING_ORDER_7,  // 嫌	
	0x5AE1, KANJI_LEARNING_ORDER_7,  // 嫡	
	0x5B22, KANJI_LEARNING_ORDER_7,  // 嬢	
	0x5B50, KANJI_LEARNING_ORDER_1,  // 子	
	0x5B54, KANJI_LEARNING_ORDER_7,  // 孔	
	0x5B57, KANJI_LEARNING_ORDER_1,  // 字	
	0x5B58, KANJI_LEARNING_ORDER_6,  // 存	
	0x5B5D, KANJI_LEARNING_ORDER_6,  // 孝	
	0x5B63, KANJI_LEARNING_ORDER_4,  // 季	
	0x5B64, KANJI_LEARNING_ORDER_7,  // 孤	
	0x5B66, KANJI_LEARNING_ORDER_1,  // 学	
	0x5B6B, KANJI_LEARNING_ORDER_4,  // 孫	
	0x5B85, KANJI_LEARNING_ORDER_6,  // 宅	
	0x5B87, KANJI_LEARNING_ORDER_6,  // 宇	
	0x5B88, KANJI_LEARNING_ORDER_3,  // 守	
	0x5B89, KANJI_LEARNING_ORDER_3,  // 安	
	0x5B8C, KANJI_LEARNING_ORDER_4,  // 完	
	0x5B97, KANJI_LEARNING_ORDER_6,  // 宗	
	0x5B98, KANJI_LEARNING_ORDER_4,  // 官	
	0x5B99, KANJI_LEARNING_ORDER_6,  // 宙	
	0x5B9A, KANJI_LEARNING_ORDER_3,  // 定	
	0x5B9C, KANJI_LEARNING_ORDER_7,  // 宜	
	0x5B9D, KANJI_LEARNING_ORDER_6,  // 宝	
	0x5B9F, KANJI_LEARNING_ORDER_3,  // 実	
	0x5BA2, KANJI_LEARNING_ORDER_3,  // 客	
	0x5BA3, KANJI_LEARNING_ORDER_6,  // 宣	
	0x5BA4, KANJI_LEARNING_ORDER_2,  // 室	
	0x5BAE, KANJI_LEARNING_ORDER_3,  // 宮	
	0x5BB0, KANJI_LEARNING_ORDER_7,  // 宰	
	0x5BB3, KANJI_LEARNING_ORDER_4,  // 害	
	0x5BB4, KANJI_LEARNING_ORDER_7,  // 宴	
	0x5BB5, KANJI_LEARNING_ORDER_7,  // 宵	
	0x5BB6, KANJI_LEARNING_ORDER_2,  // 家	
	0x5BB9, KANJI_LEARNING_ORDER_5,  // 容	
	0x5BBF, KANJI_LEARNING_ORDER_3,  // 宿	
	0x5BC2, KANJI_LEARNING_ORDER_7,  // 寂	
	0x5BC4, KANJI_LEARNING_ORDER_5,  // 寄	
	0x5BC6, KANJI_LEARNING_ORDER_6,  // 密	
	0x5BCC, KANJI_LEARNING_ORDER_5,  // 富	
	0x5BD2, KANJI_LEARNING_ORDER_3,  // 寒	
	0x5BDB, KANJI_LEARNING_ORDER_7,  // 寛	
	0x5BDD, KANJI_LEARNING_ORDER_7,  // 寝	
	0x5BDF, KANJI_LEARNING_ORDER_4,  // 察	
	0x5BE1, KANJI_LEARNING_ORDER_7,  // 寡	
	0x5BE7, KANJI_LEARNING_ORDER_7,  // 寧	
	0x5BE9, KANJI_LEARNING_ORDER_7,  // 審	
	0x5BEE, KANJI_LEARNING_ORDER_7,  // 寮	
	0x5BF8, KANJI_LEARNING_ORDER_6,  // 寸	
	0x5BFA, KANJI_LEARNING_ORDER_2,  // 寺	
	0x5BFE, KANJI_LEARNING_ORDER_3,  // 対	
	0x5BFF, KANJI_LEARNING_ORDER_7,  // 寿	
	0x5C01, KANJI_LEARNING_ORDER_7,  // 封	
	0x5C02, KANJI_LEARNING_ORDER_6,  // 専	
	0x5C04, KANJI_LEARNING_ORDER_6,  // 射	
	0x5C06, KANJI_LEARNING_ORDER_6,  // 将	
	0x5C09, KANJI_LEARNING_ORDER_7,  // 尉	
	0x5C0A, KANJI_LEARNING_ORDER_6,  // 尊	
	0x5C0B, KANJI_LEARNING_ORDER_7,  // 尋	
	0x5C0E, KANJI_LEARNING_ORDER_5,  // 導	
	0x5C0F, KANJI_LEARNING_ORDER_1,  // 小	
	0x5C11, KANJI_LEARNING_ORDER_2,  // 少	
	0x5C1A, KANJI_LEARNING_ORDER_7,  // 尚	
	0x5C31, KANJI_LEARNING_ORDER_6,  // 就	
	0x5C3A, KANJI_LEARNING_ORDER_6,  // 尺	
	0x5C3C, KANJI_LEARNING_ORDER_7,  // 尼	
	0x5C3D, KANJI_LEARNING_ORDER_7,  // 尽	
	0x5C3E, KANJI_LEARNING_ORDER_7,  // 尾	
	0x5C3F, KANJI_LEARNING_ORDER_7,  // 尿	
	0x5C40, KANJI_LEARNING_ORDER_3,  // 局	
	0x5C45, KANJI_LEARNING_ORDER_5,  // 居	
	0x5C48, KANJI_LEARNING_ORDER_7,  // 屈	
	0x5C4A, KANJI_LEARNING_ORDER_6,  // 届	
	0x5C4B, KANJI_LEARNING_ORDER_3,  // 屋	
	0x5C55, KANJI_LEARNING_ORDER_6,  // 展	
	0x5C5E, KANJI_LEARNING_ORDER_5,  // 属	
	0x5C64, KANJI_LEARNING_ORDER_6,  // 層	
	0x5C65, KANJI_LEARNING_ORDER_7,  // 履	
	0x5C6F, KANJI_LEARNING_ORDER_7,  // 屯	
	0x5C71, KANJI_LEARNING_ORDER_1,  // 山	
	0x5C90, KANJI_LEARNING_ORDER_7,  // 岐	
	0x5CA9, KANJI_LEARNING_ORDER_2,  // 岩	
	0x5CAC, KANJI_LEARNING_ORDER_7,  // 岬	
	0x5CB3, KANJI_LEARNING_ORDER_7,  // 岳	
	0x5CB8, KANJI_LEARNING_ORDER_3,  // 岸	
	0x5CE0, KANJI_LEARNING_ORDER_7,  // 峠	
	0x5CE1, KANJI_LEARNING_ORDER_7,  // 峡	
	0x5CF0, KANJI_LEARNING_ORDER_7,  // 峰	
	0x5CF6, KANJI_LEARNING_ORDER_3,  // 島	
	0x5D07, KANJI_LEARNING_ORDER_7,  // 崇	
	0x5D0E, KANJI_LEARNING_ORDER_7,  // 崎	
	0x5D29, KANJI_LEARNING_ORDER_7,  // 崩	
	0x5DDD, KANJI_LEARNING_ORDER_1,  // 川	
	0x5DDE, KANJI_LEARNING_ORDER_3,  // 州	
	0x5DE1, KANJI_LEARNING_ORDER_7,  // 巡	
	0x5DE3, KANJI_LEARNING_ORDER_4,  // 巣	
	0x5DE5, KANJI_LEARNING_ORDER_2,  // 工	
	0x5DE6, KANJI_LEARNING_ORDER_1,  // 左	
	0x5DE7, KANJI_LEARNING_ORDER_7,  // 巧	
	0x5DE8, KANJI_LEARNING_ORDER_7,  // 巨	
	0x5DEE, KANJI_LEARNING_ORDER_4,  // 差	
	0x5DF1, KANJI_LEARNING_ORDER_6,  // 己	
	0x5DFB, KANJI_LEARNING_ORDER_6,  // 巻	
	0x5E02, KANJI_LEARNING_ORDER_2,  // 市	
	0x5E03, KANJI_LEARNING_ORDER_5,  // 布	
	0x5E06, KANJI_LEARNING_ORDER_7,  // 帆	
	0x5E0C, KANJI_LEARNING_ORDER_4,  // 希	
	0x5E1D, KANJI_LEARNING_ORDER_7,  // 帝	
	0x5E25, KANJI_LEARNING_ORDER_7,  // 帥	
	0x5E2B, KANJI_LEARNING_ORDER_5,  // 師	
	0x5E2D, KANJI_LEARNING_ORDER_4,  // 席	
	0x5E2F, KANJI_LEARNING_ORDER_4,  // 帯	
	0x5E30, KANJI_LEARNING_ORDER_2,  // 帰	
	0x5E33, KANJI_LEARNING_ORDER_3,  // 帳	
	0x5E38, KANJI_LEARNING_ORDER_5,  // 常	
	0x5E3D, KANJI_LEARNING_ORDER_7,  // 帽	
	0x5E45, KANJI_LEARNING_ORDER_7,  // 幅	
	0x5E55, KANJI_LEARNING_ORDER_6,  // 幕	
	0x5E63, KANJI_LEARNING_ORDER_7,  // 幣	
	0x5E72, KANJI_LEARNING_ORDER_6,  // 干	
	0x5E73, KANJI_LEARNING_ORDER_3,  // 平	
	0x5E74, KANJI_LEARNING_ORDER_1,  // 年	
	0x5E78, KANJI_LEARNING_ORDER_3,  // 幸	
	0x5E79, KANJI_LEARNING_ORDER_5,  // 幹	
	0x5E7B, KANJI_LEARNING_ORDER_7,  // 幻	
	0x5E7C, KANJI_LEARNING_ORDER_6,  // 幼	
	0x5E7D, KANJI_LEARNING_ORDER_7,  // 幽	
	0x5E7E, KANJI_LEARNING_ORDER_7,  // 幾	
	0x5E81, KANJI_LEARNING_ORDER_6,  // 庁	
	0x5E83, KANJI_LEARNING_ORDER_2,  // 広	
	0x5E8A, KANJI_LEARNING_ORDER_7,  // 床	
	0x5E8F, KANJI_LEARNING_ORDER_5,  // 序	
	0x5E95, KANJI_LEARNING_ORDER_4,  // 底	
	0x5E97, KANJI_LEARNING_ORDER_2,  // 店	
	0x5E9C, KANJI_LEARNING_ORDER_4,  // 府	
	0x5EA6, KANJI_LEARNING_ORDER_3,  // 度	
	0x5EA7, KANJI_LEARNING_ORDER_6,  // 座	
	0x5EAB, KANJI_LEARNING_ORDER_3,  // 庫	
	0x5EAD, KANJI_LEARNING_ORDER_3,  // 庭	
	0x5EB6, KANJI_LEARNING_ORDER_7,  // 庶	
	0x5EB7, KANJI_LEARNING_ORDER_4,  // 康	
	0x5EB8, KANJI_LEARNING_ORDER_7,  // 庸	
	0x5EC3, KANJI_LEARNING_ORDER_7,  // 廃	
	0x5EC9, KANJI_LEARNING_ORDER_7,  // 廉	
	0x5ECA, KANJI_LEARNING_ORDER_7,  // 廊	
	0x5EF6, KANJI_LEARNING_ORDER_6,  // 延	
	0x5EF7, KANJI_LEARNING_ORDER_7,  // 廷	
	0x5EFA, KANJI_LEARNING_ORDER_4,  // 建	
	0x5F01, KANJI_LEARNING_ORDER_5,  // 弁	
	0x5F0A, KANJI_LEARNING_ORDER_7,  // 弊	
	0x5F0F, KANJI_LEARNING_ORDER_3,  // 式	
	0x5F10, KANJI_LEARNING_ORDER_7,  // 弐	
	0x5F13, KANJI_LEARNING_ORDER_2,  // 弓	
	0x5F14, KANJI_LEARNING_ORDER_7,  // 弔	
	0x5F15, KANJI_LEARNING_ORDER_2,  // 引	
	0x5F1F, KANJI_LEARNING_ORDER_2,  // 弟	
	0x5F26, KANJI_LEARNING_ORDER_7,  // 弦	
	0x5F27, KANJI_LEARNING_ORDER_7,  // 弧	
	0x5F31, KANJI_LEARNING_ORDER_2,  // 弱	
	0x5F35, KANJI_LEARNING_ORDER_5,  // 張	
	0x5F37, KANJI_LEARNING_ORDER_2,  // 強	
	0x5F3E, KANJI_LEARNING_ORDER_7,  // 弾	
	0x5F53, KANJI_LEARNING_ORDER_2,  // 当	
	0x5F62, KANJI_LEARNING_ORDER_2,  // 形	
	0x5F69, KANJI_LEARNING_ORDER_7,  // 彩	
	0x5F6B, KANJI_LEARNING_ORDER_7,  // 彫	
	0x5F70, KANJI_LEARNING_ORDER_7,  // 彰	
	0x5F71, KANJI_LEARNING_ORDER_7,  // 影	
	0x5F79, KANJI_LEARNING_ORDER_3,  // 役	
	0x5F7C, KANJI_LEARNING_ORDER_7,  // 彼	
	0x5F80, KANJI_LEARNING_ORDER_5,  // 往	
	0x5F81, KANJI_LEARNING_ORDER_7,  // 征	
	0x5F84, KANJI_LEARNING_ORDER_4,  // 径	
	0x5F85, KANJI_LEARNING_ORDER_3,  // 待	
	0x5F8B, KANJI_LEARNING_ORDER_6,  // 律	
	0x5F8C, KANJI_LEARNING_ORDER_2,  // 後	
	0x5F90, KANJI_LEARNING_ORDER_7,  // 徐	
	0x5F92, KANJI_LEARNING_ORDER_4,  // 徒	
	0x5F93, KANJI_LEARNING_ORDER_6,  // 従	
	0x5F97, KANJI_LEARNING_ORDER_4,  // 得	
	0x5FA1, KANJI_LEARNING_ORDER_7,  // 御	
	0x5FA9, KANJI_LEARNING_ORDER_5,  // 復	
	0x5FAA, KANJI_LEARNING_ORDER_7,  // 循	
	0x5FAE, KANJI_LEARNING_ORDER_7,  // 微	
	0x5FB3, KANJI_LEARNING_ORDER_5,  // 徳	
	0x5FB4, KANJI_LEARNING_ORDER_7,  // 徴	
	0x5FB9, KANJI_LEARNING_ORDER_7,  // 徹	
	0x5FC3, KANJI_LEARNING_ORDER_2,  // 心	
	0x5FC5, KANJI_LEARNING_ORDER_4,  // 必	
	0x5FCC, KANJI_LEARNING_ORDER_7,  // 忌	
	0x5FCD, KANJI_LEARNING_ORDER_7,  // 忍	
	0x5FD7, KANJI_LEARNING_ORDER_5,  // 志	
	0x5FD8, KANJI_LEARNING_ORDER_6,  // 忘	
	0x5FD9, KANJI_LEARNING_ORDER_7,  // 忙	
	0x5FDC, KANJI_LEARNING_ORDER_5,  // 応	
	0x5FE0, KANJI_LEARNING_ORDER_6,  // 忠	
	0x5FEB, KANJI_LEARNING_ORDER_5,  // 快	
	0x5FF5, KANJI_LEARNING_ORDER_4,  // 念	
	0x6012, KANJI_LEARNING_ORDER_7,  // 怒	
	0x6016, KANJI_LEARNING_ORDER_7,  // 怖	
	0x601D, KANJI_LEARNING_ORDER_2,  // 思	
	0x6020, KANJI_LEARNING_ORDER_7,  // 怠	
	0x6025, KANJI_LEARNING_ORDER_3,  // 急	
	0x6027, KANJI_LEARNING_ORDER_5,  // 性	
	0x602A, KANJI_LEARNING_ORDER_7,  // 怪	
	0x604B, KANJI_LEARNING_ORDER_7,  // 恋	
	0x6050, KANJI_LEARNING_ORDER_7,  // 恐	
	0x6052, KANJI_LEARNING_ORDER_7,  // 恒	
	0x6065, KANJI_LEARNING_ORDER_7,  // 恥	
	0x6068, KANJI_LEARNING_ORDER_7,  // 恨	
	0x6069, KANJI_LEARNING_ORDER_5,  // 恩	
	0x606D, KANJI_LEARNING_ORDER_7,  // 恭	
	0x606F, KANJI_LEARNING_ORDER_3,  // 息	
	0x6075, KANJI_LEARNING_ORDER_7,  // 恵	
	0x6094, KANJI_LEARNING_ORDER_7,  // 悔	
	0x609F, KANJI_LEARNING_ORDER_7,  // 悟	
	0x60A0, KANJI_LEARNING_ORDER_7,  // 悠	
	0x60A3, KANJI_LEARNING_ORDER_7,  // 患	
	0x60A6, KANJI_LEARNING_ORDER_7,  // 悦	
	0x60A9, KANJI_LEARNING_ORDER_7,  // 悩	
	0x60AA, KANJI_LEARNING_ORDER_3,  // 悪	
	0x60B2, KANJI_LEARNING_ORDER_3,  // 悲	
	0x60BC, KANJI_LEARNING_ORDER_7,  // 悼	
	0x60C5, KANJI_LEARNING_ORDER_5,  // 情	
	0x60D1, KANJI_LEARNING_ORDER_7,  // 惑	
	0x60DC, KANJI_LEARNING_ORDER_7,  // 惜	
	0x60E8, KANJI_LEARNING_ORDER_7,  // 惨	
	0x60F0, KANJI_LEARNING_ORDER_7,  // 惰	
	0x60F3, KANJI_LEARNING_ORDER_3,  // 想	
	0x6101, KANJI_LEARNING_ORDER_7,  // 愁	
	0x6109, KANJI_LEARNING_ORDER_7,  // 愉	
	0x610F, KANJI_LEARNING_ORDER_3,  // 意	
	0x611A, KANJI_LEARNING_ORDER_7,  // 愚	
	0x611B, KANJI_LEARNING_ORDER_4,  // 愛	
	0x611F, KANJI_LEARNING_ORDER_3,  // 感	
	0x6148, KANJI_LEARNING_ORDER_7,  // 慈	
	0x614B, KANJI_LEARNING_ORDER_5,  // 態	
	0x614C, KANJI_LEARNING_ORDER_7,  // 慌	
	0x614E, KANJI_LEARNING_ORDER_7,  // 慎	
	0x6155, KANJI_LEARNING_ORDER_7,  // 慕	
	0x6162, KANJI_LEARNING_ORDER_7,  // 慢	
	0x6163, KANJI_LEARNING_ORDER_5,  // 慣	
	0x6168, KANJI_LEARNING_ORDER_7,  // 慨	
	0x616E, KANJI_LEARNING_ORDER_7,  // 慮	
	0x6170, KANJI_LEARNING_ORDER_7,  // 慰	
	0x6176, KANJI_LEARNING_ORDER_7,  // 慶	
	0x6182, KANJI_LEARNING_ORDER_7,  // 憂	
	0x618E, KANJI_LEARNING_ORDER_7,  // 憎	
	0x61A4, KANJI_LEARNING_ORDER_7,  // 憤	
	0x61A9, KANJI_LEARNING_ORDER_7,  // 憩	
	0x61B2, KANJI_LEARNING_ORDER_6,  // 憲	
	0x61B6, KANJI_LEARNING_ORDER_7,  // 憶	
	0x61BE, KANJI_LEARNING_ORDER_7,  // 憾	
	0x61C7, KANJI_LEARNING_ORDER_7,  // 懇	
	0x61D0, KANJI_LEARNING_ORDER_7,  // 懐	
	0x61F2, KANJI_LEARNING_ORDER_7,  // 懲	
	0x61F8, KANJI_LEARNING_ORDER_7,  // 懸	
	0x6210, KANJI_LEARNING_ORDER_4,  // 成	
	0x6211, KANJI_LEARNING_ORDER_6,  // 我	
	0x6212, KANJI_LEARNING_ORDER_7,  // 戒	
	0x6226, KANJI_LEARNING_ORDER_4,  // 戦	
	0x622F, KANJI_LEARNING_ORDER_7,  // 戯	
	0x6238, KANJI_LEARNING_ORDER_2,  // 戸	
	0x623B, KANJI_LEARNING_ORDER_7,  // 戻	
	0x623F, KANJI_LEARNING_ORDER_7,  // 房	
	0x6240, KANJI_LEARNING_ORDER_3,  // 所	
	0x6247, KANJI_LEARNING_ORDER_7,  // 扇	
	0x6249, KANJI_LEARNING_ORDER_7,  // 扉	
	0x624B, KANJI_LEARNING_ORDER_1,  // 手	
	0x624D, KANJI_LEARNING_ORDER_2,  // 才	
	0x6253, KANJI_LEARNING_ORDER_3,  // 打	
	0x6255, KANJI_LEARNING_ORDER_7,  // 払	
	0x6271, KANJI_LEARNING_ORDER_7,  // 扱	
	0x6276, KANJI_LEARNING_ORDER_7,  // 扶	
	0x6279, KANJI_LEARNING_ORDER_6,  // 批	
	0x627F, KANJI_LEARNING_ORDER_5,  // 承	
	0x6280, KANJI_LEARNING_ORDER_5,  // 技	
	0x6284, KANJI_LEARNING_ORDER_7,  // 抄	
	0x628A, KANJI_LEARNING_ORDER_7,  // 把	
	0x6291, KANJI_LEARNING_ORDER_7,  // 抑	
	0x6295, KANJI_LEARNING_ORDER_3,  // 投	
	0x6297, KANJI_LEARNING_ORDER_7,  // 抗	
	0x6298, KANJI_LEARNING_ORDER_4,  // 折	
	0x629C, KANJI_LEARNING_ORDER_7,  // 抜	
	0x629E, KANJI_LEARNING_ORDER_7,  // 択	
	0x62AB, KANJI_LEARNING_ORDER_7,  // 披	
	0x62B1, KANJI_LEARNING_ORDER_7,  // 抱	
	0x62B5, KANJI_LEARNING_ORDER_7,  // 抵	
	0x62B9, KANJI_LEARNING_ORDER_7,  // 抹	
	0x62BC, KANJI_LEARNING_ORDER_7,  // 押	
	0x62BD, KANJI_LEARNING_ORDER_7,  // 抽	
	0x62C5, KANJI_LEARNING_ORDER_6,  // 担	
	0x62CD, KANJI_LEARNING_ORDER_7,  // 拍	
	0x62D0, KANJI_LEARNING_ORDER_7,  // 拐	
	0x62D2, KANJI_LEARNING_ORDER_7,  // 拒	
	0x62D3, KANJI_LEARNING_ORDER_7,  // 拓	
	0x62D8, KANJI_LEARNING_ORDER_7,  // 拘	
	0x62D9, KANJI_LEARNING_ORDER_7,  // 拙	
	0x62DB, KANJI_LEARNING_ORDER_5,  // 招	
	0x62DD, KANJI_LEARNING_ORDER_6,  // 拝	
	0x62E0, KANJI_LEARNING_ORDER_7,  // 拠	
	0x62E1, KANJI_LEARNING_ORDER_6,  // 拡	
	0x62EC, KANJI_LEARNING_ORDER_7,  // 括	
	0x62F7, KANJI_LEARNING_ORDER_7,  // 拷	
	0x62FE, KANJI_LEARNING_ORDER_3,  // 拾	
	0x6301, KANJI_LEARNING_ORDER_3,  // 持	
	0x6307, KANJI_LEARNING_ORDER_3,  // 指	
	0x6311, KANJI_LEARNING_ORDER_7,  // 挑	
	0x6319, KANJI_LEARNING_ORDER_4,  // 挙	
	0x631F, KANJI_LEARNING_ORDER_7,  // 挟	
	0x632F, KANJI_LEARNING_ORDER_7,  // 振	
	0x633F, KANJI_LEARNING_ORDER_7,  // 挿	
	0x6355, KANJI_LEARNING_ORDER_7,  // 捕	
	0x635C, KANJI_LEARNING_ORDER_7,  // 捜	
	0x6368, KANJI_LEARNING_ORDER_6,  // 捨	
	0x636E, KANJI_LEARNING_ORDER_7,  // 据	
	0x6383, KANJI_LEARNING_ORDER_7,  // 掃	
	0x6388, KANJI_LEARNING_ORDER_5,  // 授	
	0x638C, KANJI_LEARNING_ORDER_7,  // 掌	
	0x6392, KANJI_LEARNING_ORDER_7,  // 排	
	0x6398, KANJI_LEARNING_ORDER_7,  // 掘	
	0x639B, KANJI_LEARNING_ORDER_7,  // 掛	
	0x63A1, KANJI_LEARNING_ORDER_5,  // 採	
	0x63A2, KANJI_LEARNING_ORDER_6,  // 探	
	0x63A5, KANJI_LEARNING_ORDER_5,  // 接	
	0x63A7, KANJI_LEARNING_ORDER_7,  // 控	
	0x63A8, KANJI_LEARNING_ORDER_6,  // 推	
	0x63AA, KANJI_LEARNING_ORDER_7,  // 措	
	0x63B2, KANJI_LEARNING_ORDER_7,  // 掲	
	0x63CF, KANJI_LEARNING_ORDER_7,  // 描	
	0x63D0, KANJI_LEARNING_ORDER_5,  // 提	
	0x63DA, KANJI_LEARNING_ORDER_7,  // 揚	
	0x63DB, KANJI_LEARNING_ORDER_7,  // 換	
	0x63E1, KANJI_LEARNING_ORDER_7,  // 握	
	0x63EE, KANJI_LEARNING_ORDER_6,  // 揮	
	0x63F4, KANJI_LEARNING_ORDER_7,  // 援	
	0x63FA, KANJI_LEARNING_ORDER_7,  // 揺	
	0x640D, KANJI_LEARNING_ORDER_5,  // 損	
	0x642C, KANJI_LEARNING_ORDER_7,  // 搬	
	0x642D, KANJI_LEARNING_ORDER_7,  // 搭	
	0x643A, KANJI_LEARNING_ORDER_7,  // 携	
	0x643E, KANJI_LEARNING_ORDER_7,  // 搾	
	0x6442, KANJI_LEARNING_ORDER_7,  // 摂	
	0x6458, KANJI_LEARNING_ORDER_7,  // 摘	
	0x6469, KANJI_LEARNING_ORDER_7,  // 摩	
	0x6483, KANJI_LEARNING_ORDER_7,  // 撃	
	0x64A4, KANJI_LEARNING_ORDER_7,  // 撤	
	0x64AE, KANJI_LEARNING_ORDER_7,  // 撮	
	0x64B2, KANJI_LEARNING_ORDER_7,  // 撲	
	0x64C1, KANJI_LEARNING_ORDER_7,  // 擁	
	0x64CD, KANJI_LEARNING_ORDER_6,  // 操	
	0x64E6, KANJI_LEARNING_ORDER_7,  // 擦	
	0x64EC, KANJI_LEARNING_ORDER_7,  // 擬	
	0x652F, KANJI_LEARNING_ORDER_5,  // 支	
	0x6539, KANJI_LEARNING_ORDER_4,  // 改	
	0x653B, KANJI_LEARNING_ORDER_7,  // 攻	
	0x653E, KANJI_LEARNING_ORDER_3,  // 放	
	0x653F, KANJI_LEARNING_ORDER_5,  // 政	
	0x6545, KANJI_LEARNING_ORDER_5,  // 故	
	0x654F, KANJI_LEARNING_ORDER_7,  // 敏	
	0x6551, KANJI_LEARNING_ORDER_4,  // 救	
	0x6557, KANJI_LEARNING_ORDER_4,  // 敗	
	0x6559, KANJI_LEARNING_ORDER_2,  // 教	
	0x6562, KANJI_LEARNING_ORDER_7,  // 敢	
	0x6563, KANJI_LEARNING_ORDER_4,  // 散	
	0x656C, KANJI_LEARNING_ORDER_6,  // 敬	
	0x6570, KANJI_LEARNING_ORDER_2,  // 数	
	0x6574, KANJI_LEARNING_ORDER_3,  // 整	
	0x6575, KANJI_LEARNING_ORDER_5,  // 敵	
	0x6577, KANJI_LEARNING_ORDER_7,  // 敷	
	0x6587, KANJI_LEARNING_ORDER_1,  // 文	
	0x6589, KANJI_LEARNING_ORDER_7,  // 斉	
	0x658E, KANJI_LEARNING_ORDER_7,  // 斎	
	0x6597, KANJI_LEARNING_ORDER_7,  // 斗	
	0x6599, KANJI_LEARNING_ORDER_4,  // 料	
	0x659C, KANJI_LEARNING_ORDER_7,  // 斜	
	0x65A4, KANJI_LEARNING_ORDER_7,  // 斤	
	0x65A5, KANJI_LEARNING_ORDER_7,  // 斥	
	0x65AD, KANJI_LEARNING_ORDER_5,  // 断	
	0x65B0, KANJI_LEARNING_ORDER_2,  // 新	
	0x65B9, KANJI_LEARNING_ORDER_2,  // 方	
	0x65BD, KANJI_LEARNING_ORDER_7,  // 施	
	0x65C5, KANJI_LEARNING_ORDER_3,  // 旅	
	0x65CB, KANJI_LEARNING_ORDER_7,  // 旋	
	0x65CF, KANJI_LEARNING_ORDER_3,  // 族	
	0x65D7, KANJI_LEARNING_ORDER_4,  // 旗	
	0x65E2, KANJI_LEARNING_ORDER_7,  // 既	
	0x65E5, KANJI_LEARNING_ORDER_1,  // 日	
	0x65E7, KANJI_LEARNING_ORDER_5,  // 旧	
	0x65E8, KANJI_LEARNING_ORDER_7,  // 旨	
	0x65E9, KANJI_LEARNING_ORDER_1,  // 早	
	0x65EC, KANJI_LEARNING_ORDER_7,  // 旬	
	0x6606, KANJI_LEARNING_ORDER_7,  // 昆	
	0x6607, KANJI_LEARNING_ORDER_7,  // 昇	
	0x660E, KANJI_LEARNING_ORDER_2,  // 明	
	0x6613, KANJI_LEARNING_ORDER_5,  // 易	
	0x6614, KANJI_LEARNING_ORDER_3,  // 昔	
	0x661F, KANJI_LEARNING_ORDER_2,  // 星	
	0x6620, KANJI_LEARNING_ORDER_6,  // 映	
	0x6625, KANJI_LEARNING_ORDER_2,  // 春	
	0x6628, KANJI_LEARNING_ORDER_4,  // 昨	
	0x662D, KANJI_LEARNING_ORDER_3,  // 昭	
	0x662F, KANJI_LEARNING_ORDER_7,  // 是	
	0x663C, KANJI_LEARNING_ORDER_2,  // 昼	
	0x6642, KANJI_LEARNING_ORDER_2,  // 時	
	0x6669, KANJI_LEARNING_ORDER_6,  // 晩	
	0x666E, KANJI_LEARNING_ORDER_7,  // 普	
	0x666F, KANJI_LEARNING_ORDER_4,  // 景	
	0x6674, KANJI_LEARNING_ORDER_2,  // 晴	
	0x6676, KANJI_LEARNING_ORDER_7,  // 晶	
	0x6681, KANJI_LEARNING_ORDER_7,  // 暁	
	0x6687, KANJI_LEARNING_ORDER_7,  // 暇	
	0x6691, KANJI_LEARNING_ORDER_3,  // 暑	
	0x6696, KANJI_LEARNING_ORDER_6,  // 暖	
	0x6697, KANJI_LEARNING_ORDER_3,  // 暗	
	0x66A6, KANJI_LEARNING_ORDER_7,  // 暦	
	0x66AB, KANJI_LEARNING_ORDER_7,  // 暫	
	0x66AE, KANJI_LEARNING_ORDER_6,  // 暮	
	0x66B4, KANJI_LEARNING_ORDER_5,  // 暴	
	0x66C7, KANJI_LEARNING_ORDER_7,  // 曇	
	0x66DC, KANJI_LEARNING_ORDER_2,  // 曜	
	0x66F2, KANJI_LEARNING_ORDER_3,  // 曲	
	0x66F4, KANJI_LEARNING_ORDER_7,  // 更	
	0x66F8, KANJI_LEARNING_ORDER_2,  // 書	
	0x66F9, KANJI_LEARNING_ORDER_7,  // 曹	
	0x66FF, KANJI_LEARNING_ORDER_7,  // 替	
	0x6700, KANJI_LEARNING_ORDER_4,  // 最	
	0x6708, KANJI_LEARNING_ORDER_1,  // 月	
	0x6709, KANJI_LEARNING_ORDER_3,  // 有	
	0x670D, KANJI_LEARNING_ORDER_3,  // 服	
	0x6715, KANJI_LEARNING_ORDER_7,  // 朕	
	0x6717, KANJI_LEARNING_ORDER_6,  // 朗	
	0x671B, KANJI_LEARNING_ORDER_4,  // 望	
	0x671D, KANJI_LEARNING_ORDER_2,  // 朝	
	0x671F, KANJI_LEARNING_ORDER_3,  // 期	
	0x6728, KANJI_LEARNING_ORDER_1,  // 木	
	0x672A, KANJI_LEARNING_ORDER_4,  // 未	
	0x672B, KANJI_LEARNING_ORDER_4,  // 末	
	0x672C, KANJI_LEARNING_ORDER_1,  // 本	
	0x672D, KANJI_LEARNING_ORDER_4,  // 札	
	0x6731, KANJI_LEARNING_ORDER_7,  // 朱	
	0x6734, KANJI_LEARNING_ORDER_7,  // 朴	
	0x673A, KANJI_LEARNING_ORDER_6,  // 机	
	0x673D, KANJI_LEARNING_ORDER_7,  // 朽	
	0x6749, KANJI_LEARNING_ORDER_7,  // 杉	
	0x6750, KANJI_LEARNING_ORDER_4,  // 材	
	0x6751, KANJI_LEARNING_ORDER_1,  // 村	
	0x675F, KANJI_LEARNING_ORDER_4,  // 束	
	0x6761, KANJI_LEARNING_ORDER_5,  // 条	
	0x6765, KANJI_LEARNING_ORDER_2,  // 来	
	0x676F, KANJI_LEARNING_ORDER_7,  // 杯	
	0x6771, KANJI_LEARNING_ORDER_2,  // 東	
	0x677E, KANJI_LEARNING_ORDER_4,  // 松	
	0x677F, KANJI_LEARNING_ORDER_3,  // 板	
	0x6790, KANJI_LEARNING_ORDER_7,  // 析	
	0x6797, KANJI_LEARNING_ORDER_1,  // 林	
	0x679A, KANJI_LEARNING_ORDER_6,  // 枚	
	0x679C, KANJI_LEARNING_ORDER_4,  // 果	
	0x679D, KANJI_LEARNING_ORDER_5,  // 枝	
	0x67A0, KANJI_LEARNING_ORDER_7,  // 枠	
	0x67A2, KANJI_LEARNING_ORDER_7,  // 枢	
	0x67AF, KANJI_LEARNING_ORDER_7,  // 枯	
	0x67B6, KANJI_LEARNING_ORDER_7,  // 架	
	0x67C4, KANJI_LEARNING_ORDER_7,  // 柄	
	0x67D0, KANJI_LEARNING_ORDER_7,  // 某	
	0x67D3, KANJI_LEARNING_ORDER_6,  // 染	
	0x67D4, KANJI_LEARNING_ORDER_7,  // 柔	
	0x67F1, KANJI_LEARNING_ORDER_3,  // 柱	
	0x67F3, KANJI_LEARNING_ORDER_7,  // 柳	
	0x67FB, KANJI_LEARNING_ORDER_5,  // 査	
	0x6804, KANJI_LEARNING_ORDER_4,  // 栄	
	0x6813, KANJI_LEARNING_ORDER_7,  // 栓	
	0x6821, KANJI_LEARNING_ORDER_1,  // 校	
	0x682A, KANJI_LEARNING_ORDER_6,  // 株	
	0x6838, KANJI_LEARNING_ORDER_7,  // 核	
	0x6839, KANJI_LEARNING_ORDER_3,  // 根	
	0x683C, KANJI_LEARNING_ORDER_5,  // 格	
	0x683D, KANJI_LEARNING_ORDER_7,  // 栽	
	0x6843, KANJI_LEARNING_ORDER_7,  // 桃	
	0x6848, KANJI_LEARNING_ORDER_4,  // 案	
	0x6851, KANJI_LEARNING_ORDER_7,  // 桑	
	0x685C, KANJI_LEARNING_ORDER_5,  // 桜	
	0x685F, KANJI_LEARNING_ORDER_7,  // 桟	
	0x6885, KANJI_LEARNING_ORDER_4,  // 梅	
	0x68B0, KANJI_LEARNING_ORDER_4,  // 械	
	0x68C4, KANJI_LEARNING_ORDER_7,  // 棄	
	0x68CB, KANJI_LEARNING_ORDER_7,  // 棋	
	0x68D2, KANJI_LEARNING_ORDER_6,  // 棒	
	0x68DA, KANJI_LEARNING_ORDER_7,  // 棚	
	0x68DF, KANJI_LEARNING_ORDER_7,  // 棟	
	0x68EE, KANJI_LEARNING_ORDER_1,  // 森	
	0x68FA, KANJI_LEARNING_ORDER_7,  // 棺	
	0x690D, KANJI_LEARNING_ORDER_3,  // 植	
	0x691C, KANJI_LEARNING_ORDER_5,  // 検	
	0x696D, KANJI_LEARNING_ORDER_3,  // 業	
	0x6975, KANJI_LEARNING_ORDER_4,  // 極	
	0x697C, KANJI_LEARNING_ORDER_7,  // 楼	
	0x697D, KANJI_LEARNING_ORDER_2,  // 楽	
	0x6982, KANJI_LEARNING_ORDER_7,  // 概	
	0x69CB, KANJI_LEARNING_ORDER_5,  // 構	
	0x69D8, KANJI_LEARNING_ORDER_3,  // 様	
	0x69FD, KANJI_LEARNING_ORDER_7,  // 槽	
	0x6A19, KANJI_LEARNING_ORDER_4,  // 標	
	0x6A21, KANJI_LEARNING_ORDER_6,  // 模	
	0x6A29, KANJI_LEARNING_ORDER_6,  // 権	
	0x6A2A, KANJI_LEARNING_ORDER_3,  // 横	
	0x6A39, KANJI_LEARNING_ORDER_6,  // 樹	
	0x6A4B, KANJI_LEARNING_ORDER_3,  // 橋	
	0x6A5F, KANJI_LEARNING_ORDER_4,  // 機	
	0x6B04, KANJI_LEARNING_ORDER_7,  // 欄	
	0x6B20, KANJI_LEARNING_ORDER_4,  // 欠	
	0x6B21, KANJI_LEARNING_ORDER_3,  // 次	
	0x6B27, KANJI_LEARNING_ORDER_7,  // 欧	
	0x6B32, KANJI_LEARNING_ORDER_6,  // 欲	
	0x6B3A, KANJI_LEARNING_ORDER_7,  // 欺	
	0x6B3E, KANJI_LEARNING_ORDER_7,  // 款	
	0x6B4C, KANJI_LEARNING_ORDER_2,  // 歌	
	0x6B53, KANJI_LEARNING_ORDER_7,  // 歓	
	0x6B62, KANJI_LEARNING_ORDER_2,  // 止	
	0x6B63, KANJI_LEARNING_ORDER_1,  // 正	
	0x6B66, KANJI_LEARNING_ORDER_5,  // 武	
	0x6B69, KANJI_LEARNING_ORDER_2,  // 歩	
	0x6B6F, KANJI_LEARNING_ORDER_3,  // 歯	
	0x6B73, KANJI_LEARNING_ORDER_7,  // 歳	
	0x6B74, KANJI_LEARNING_ORDER_4,  // 歴	
	0x6B7B, KANJI_LEARNING_ORDER_3,  // 死	
	0x6B89, KANJI_LEARNING_ORDER_7,  // 殉	
	0x6B8A, KANJI_LEARNING_ORDER_7,  // 殊	
	0x6B8B, KANJI_LEARNING_ORDER_4,  // 残	
	0x6B96, KANJI_LEARNING_ORDER_7,  // 殖	
	0x6BB4, KANJI_LEARNING_ORDER_7,  // 殴	
	0x6BB5, KANJI_LEARNING_ORDER_6,  // 段	
	0x6BBA, KANJI_LEARNING_ORDER_4,  // 殺	
	0x6BBB, KANJI_LEARNING_ORDER_7,  // 殻	
	0x6BBF, KANJI_LEARNING_ORDER_7,  // 殿	
	0x6BCD, KANJI_LEARNING_ORDER_2,  // 母	
	0x6BCE, KANJI_LEARNING_ORDER_2,  // 毎	
	0x6BD2, KANJI_LEARNING_ORDER_4,  // 毒	
	0x6BD4, KANJI_LEARNING_ORDER_5,  // 比	
	0x6BDB, KANJI_LEARNING_ORDER_2,  // 毛	
	0x6C0F, KANJI_LEARNING_ORDER_4,  // 氏	
	0x6C11, KANJI_LEARNING_ORDER_4,  // 民	
	0x6C17, KANJI_LEARNING_ORDER_1,  // 気	
	0x6C34, KANJI_LEARNING_ORDER_1,  // 水	
	0x6C37, KANJI_LEARNING_ORDER_3,  // 氷	
	0x6C38, KANJI_LEARNING_ORDER_5,  // 永	
	0x6C41, KANJI_LEARNING_ORDER_7,  // 汁	
	0x6C42, KANJI_LEARNING_ORDER_4,  // 求	
	0x6C57, KANJI_LEARNING_ORDER_7,  // 汗	
	0x6C5A, KANJI_LEARNING_ORDER_7,  // 汚	
	0x6C5F, KANJI_LEARNING_ORDER_7,  // 江	
	0x6C60, KANJI_LEARNING_ORDER_2,  // 池	
	0x6C7A, KANJI_LEARNING_ORDER_3,  // 決	
	0x6C7D, KANJI_LEARNING_ORDER_2,  // 汽	
	0x6C88, KANJI_LEARNING_ORDER_7,  // 沈	
	0x6C96, KANJI_LEARNING_ORDER_7,  // 沖	
	0x6CA1, KANJI_LEARNING_ORDER_7,  // 没	
	0x6CA2, KANJI_LEARNING_ORDER_7,  // 沢	
	0x6CB3, KANJI_LEARNING_ORDER_5,  // 河	
	0x6CB8, KANJI_LEARNING_ORDER_7,  // 沸	
	0x6CB9, KANJI_LEARNING_ORDER_3,  // 油	
	0x6CBB, KANJI_LEARNING_ORDER_4,  // 治	
	0x6CBC, KANJI_LEARNING_ORDER_7,  // 沼	
	0x6CBF, KANJI_LEARNING_ORDER_6,  // 沿	
	0x6CC1, KANJI_LEARNING_ORDER_7,  // 況	
	0x6CC9, KANJI_LEARNING_ORDER_6,  // 泉	
	0x6CCA, KANJI_LEARNING_ORDER_7,  // 泊	
	0x6CCC, KANJI_LEARNING_ORDER_7,  // 泌	
	0x6CD5, KANJI_LEARNING_ORDER_4,  // 法	
	0x6CE1, KANJI_LEARNING_ORDER_7,  // 泡	
	0x6CE2, KANJI_LEARNING_ORDER_3,  // 波	
	0x6CE3, KANJI_LEARNING_ORDER_4,  // 泣	
	0x6CE5, KANJI_LEARNING_ORDER_7,  // 泥	
	0x6CE8, KANJI_LEARNING_ORDER_3,  // 注	
	0x6CF0, KANJI_LEARNING_ORDER_7,  // 泰	
	0x6CF3, KANJI_LEARNING_ORDER_3,  // 泳	
	0x6D0B, KANJI_LEARNING_ORDER_3,  // 洋	
	0x6D17, KANJI_LEARNING_ORDER_6,  // 洗	
	0x6D1E, KANJI_LEARNING_ORDER_7,  // 洞	
	0x6D25, KANJI_LEARNING_ORDER_7,  // 津	
	0x6D2A, KANJI_LEARNING_ORDER_7,  // 洪	
	0x6D3B, KANJI_LEARNING_ORDER_2,  // 活	
	0x6D3E, KANJI_LEARNING_ORDER_6,  // 派	
	0x6D41, KANJI_LEARNING_ORDER_3,  // 流	
	0x6D44, KANJI_LEARNING_ORDER_7,  // 浄	
	0x6D45, KANJI_LEARNING_ORDER_4,  // 浅	
	0x6D5C, KANJI_LEARNING_ORDER_7,  // 浜	
	0x6D66, KANJI_LEARNING_ORDER_7,  // 浦	
	0x6D6A, KANJI_LEARNING_ORDER_7,  // 浪	
	0x6D6E, KANJI_LEARNING_ORDER_7,  // 浮	
	0x6D74, KANJI_LEARNING_ORDER_4,  // 浴	
	0x6D77, KANJI_LEARNING_ORDER_2,  // 海	
	0x6D78, KANJI_LEARNING_ORDER_7,  // 浸	
	0x6D88, KANJI_LEARNING_ORDER_3,  // 消	
	0x6D99, KANJI_LEARNING_ORDER_7,  // 涙	
	0x6DAF, KANJI_LEARNING_ORDER_7,  // 涯	
	0x6DB2, KANJI_LEARNING_ORDER_5,  // 液	
	0x6DBC, KANJI_LEARNING_ORDER_7,  // 涼	
	0x6DD1, KANJI_LEARNING_ORDER_7,  // 淑	
	0x6DE1, KANJI_LEARNING_ORDER_7,  // 淡	
	0x6DF1, KANJI_LEARNING_ORDER_3,  // 深	
	0x6DF7, KANJI_LEARNING_ORDER_5,  // 混	
	0x6DFB, KANJI_LEARNING_ORDER_7,  // 添	
	0x6E05, KANJI_LEARNING_ORDER_4,  // 清	
	0x6E07, KANJI_LEARNING_ORDER_7,  // 渇	
	0x6E08, KANJI_LEARNING_ORDER_6,  // 済	
	0x6E09, KANJI_LEARNING_ORDER_7,  // 渉	
	0x6E0B, KANJI_LEARNING_ORDER_7,  // 渋	
	0x6E13, KANJI_LEARNING_ORDER_7,  // 渓	
	0x6E1B, KANJI_LEARNING_ORDER_5,  // 減	
	0x6E21, KANJI_LEARNING_ORDER_7,  // 渡	
	0x6E26, KANJI_LEARNING_ORDER_7,  // 渦	
	0x6E29, KANJI_LEARNING_ORDER_3,  // 温	
	0x6E2C, KANJI_LEARNING_ORDER_5,  // 測	
	0x6E2F, KANJI_LEARNING_ORDER_3,  // 港	
	0x6E56, KANJI_LEARNING_ORDER_3,  // 湖	
	0x6E6F, KANJI_LEARNING_ORDER_3,  // 湯	
	0x6E7E, KANJI_LEARNING_ORDER_7,  // 湾	
	0x6E7F, KANJI_LEARNING_ORDER_7,  // 湿	
	0x6E80, KANJI_LEARNING_ORDER_4,  // 満	
	0x6E90, KANJI_LEARNING_ORDER_6,  // 源	
	0x6E96, KANJI_LEARNING_ORDER_5,  // 準	
	0x6E9D, KANJI_LEARNING_ORDER_7,  // 溝	
	0x6EB6, KANJI_LEARNING_ORDER_7,  // 溶	
	0x6EC5, KANJI_LEARNING_ORDER_7,  // 滅	
	0x6ECB, KANJI_LEARNING_ORDER_7,  // 滋	
	0x6ED1, KANJI_LEARNING_ORDER_7,  // 滑	
	0x6EDD, KANJI_LEARNING_ORDER_7,  // 滝	
	0x6EDE, KANJI_LEARNING_ORDER_7,  // 滞	
	0x6EF4, KANJI_LEARNING_ORDER_7,  // 滴	
	0x6F01, KANJI_LEARNING_ORDER_4,  // 漁	
	0x6F02, KANJI_LEARNING_ORDER_7,  // 漂	
	0x6F06, KANJI_LEARNING_ORDER_7,  // 漆	
	0x6F0F, KANJI_LEARNING_ORDER_7,  // 漏	
	0x6F14, KANJI_LEARNING_ORDER_5,  // 演	
	0x6F20, KANJI_LEARNING_ORDER_7,  // 漠	
	0x6F22, KANJI_LEARNING_ORDER_3,  // 漢	
	0x6F2B, KANJI_LEARNING_ORDER_7,  // 漫	
	0x6F2C, KANJI_LEARNING_ORDER_7,  // 漬	
	0x6F38, KANJI_LEARNING_ORDER_7,  // 漸	
	0x6F54, KANJI_LEARNING_ORDER_5,  // 潔	
	0x6F5C, KANJI_LEARNING_ORDER_7,  // 潜	
	0x6F5F, KANJI_LEARNING_ORDER_7,  // 潟	
	0x6F64, KANJI_LEARNING_ORDER_7,  // 潤	
	0x6F6E, KANJI_LEARNING_ORDER_6,  // 潮	
	0x6F84, KANJI_LEARNING_ORDER_7,  // 澄	
	0x6FC0, KANJI_LEARNING_ORDER_6,  // 激	
	0x6FC1, KANJI_LEARNING_ORDER_7,  // 濁	
	0x6FC3, KANJI_LEARNING_ORDER_7,  // 濃	
	0x6FEB, KANJI_LEARNING_ORDER_7,  // 濫	
	0x6FEF, KANJI_LEARNING_ORDER_7,  // 濯	
	0x702C, KANJI_LEARNING_ORDER_7,  // 瀬	
	0x706B, KANJI_LEARNING_ORDER_1,  // 火	
	0x706F, KANJI_LEARNING_ORDER_4,  // 灯	
	0x7070, KANJI_LEARNING_ORDER_6,  // 灰	
	0x707D, KANJI_LEARNING_ORDER_5,  // 災	
	0x7089, KANJI_LEARNING_ORDER_7,  // 炉	
	0x708A, KANJI_LEARNING_ORDER_7,  // 炊	
	0x708E, KANJI_LEARNING_ORDER_7,  // 炎	
	0x70AD, KANJI_LEARNING_ORDER_3,  // 炭	
	0x70B9, KANJI_LEARNING_ORDER_2,  // 点	
	0x70BA, KANJI_LEARNING_ORDER_7,  // 為	
	0x70C8, KANJI_LEARNING_ORDER_7,  // 烈	
	0x7121, KANJI_LEARNING_ORDER_4,  // 無	
	0x7126, KANJI_LEARNING_ORDER_7,  // 焦	
	0x7136, KANJI_LEARNING_ORDER_4,  // 然	
	0x713C, KANJI_LEARNING_ORDER_4,  // 焼	
	0x7159, KANJI_LEARNING_ORDER_7,  // 煙	
	0x7167, KANJI_LEARNING_ORDER_4,  // 照	
	0x7169, KANJI_LEARNING_ORDER_7,  // 煩	
	0x716E, KANJI_LEARNING_ORDER_7,  // 煮	
	0x719F, KANJI_LEARNING_ORDER_6,  // 熟	
	0x71B1, KANJI_LEARNING_ORDER_4,  // 熱	
	0x71C3, KANJI_LEARNING_ORDER_5,  // 燃	
	0x71C8, KANJI_LEARNING_ORDER_7,  // 燈	
	0x71E5, KANJI_LEARNING_ORDER_7,  // 燥	
	0x7206, KANJI_LEARNING_ORDER_7,  // 爆	
	0x7235, KANJI_LEARNING_ORDER_7,  // 爵	
	0x7236, KANJI_LEARNING_ORDER_2,  // 父	
	0x7247, KANJI_LEARNING_ORDER_6,  // 片	
	0x7248, KANJI_LEARNING_ORDER_5,  // 版	
	0x725B, KANJI_LEARNING_ORDER_2,  // 牛	
	0x7267, KANJI_LEARNING_ORDER_4,  // 牧	
	0x7269, KANJI_LEARNING_ORDER_3,  // 物	
	0x7272, KANJI_LEARNING_ORDER_7,  // 牲	
	0x7279, KANJI_LEARNING_ORDER_4,  // 特	
	0x72A0, KANJI_LEARNING_ORDER_7,  // 犠	
	0x72AC, KANJI_LEARNING_ORDER_1,  // 犬	
	0x72AF, KANJI_LEARNING_ORDER_5,  // 犯	
	0x72B6, KANJI_LEARNING_ORDER_5,  // 状	
	0x72C2, KANJI_LEARNING_ORDER_7,  // 狂	
	0x72E9, KANJI_LEARNING_ORDER_7,  // 狩	
	0x72EC, KANJI_LEARNING_ORDER_5,  // 独	
	0x72ED, KANJI_LEARNING_ORDER_7,  // 狭	
	0x731B, KANJI_LEARNING_ORDER_7,  // 猛	
	0x731F, KANJI_LEARNING_ORDER_7,  // 猟	
	0x732B, KANJI_LEARNING_ORDER_7,  // 猫	
	0x732E, KANJI_LEARNING_ORDER_7,  // 献	
	0x7336, KANJI_LEARNING_ORDER_7,  // 猶	
	0x733F, KANJI_LEARNING_ORDER_7,  // 猿	
	0x7344, KANJI_LEARNING_ORDER_7,  // 獄	
	0x7363, KANJI_LEARNING_ORDER_7,  // 獣	
	0x7372, KANJI_LEARNING_ORDER_7,  // 獲	
	0x7384, KANJI_LEARNING_ORDER_7,  // 玄	
	0x7387, KANJI_LEARNING_ORDER_5,  // 率	
	0x7389, KANJI_LEARNING_ORDER_1,  // 玉	
	0x738B, KANJI_LEARNING_ORDER_1,  // 王	
	0x73CD, KANJI_LEARNING_ORDER_7,  // 珍	
	0x73E0, KANJI_LEARNING_ORDER_7,  // 珠	
	0x73ED, KANJI_LEARNING_ORDER_6,  // 班	
	0x73FE, KANJI_LEARNING_ORDER_5,  // 現	
	0x7403, KANJI_LEARNING_ORDER_3,  // 球	
	0x7406, KANJI_LEARNING_ORDER_2,  // 理	
	0x7434, KANJI_LEARNING_ORDER_7,  // 琴	
	0x74B0, KANJI_LEARNING_ORDER_7,  // 環	
	0x74BD, KANJI_LEARNING_ORDER_7,  // 璽	
	0x74F6, KANJI_LEARNING_ORDER_7,  // 瓶	
	0x7518, KANJI_LEARNING_ORDER_7,  // 甘	
	0x751A, KANJI_LEARNING_ORDER_7,  // 甚	
	0x751F, KANJI_LEARNING_ORDER_1,  // 生	
	0x7523, KANJI_LEARNING_ORDER_4,  // 産	
	0x7528, KANJI_LEARNING_ORDER_2,  // 用	
	0x7530, KANJI_LEARNING_ORDER_1,  // 田	
	0x7531, KANJI_LEARNING_ORDER_3,  // 由	
	0x7532, KANJI_LEARNING_ORDER_7,  // 甲	
	0x7533, KANJI_LEARNING_ORDER_3,  // 申	
	0x7537, KANJI_LEARNING_ORDER_1,  // 男	
	0x753A, KANJI_LEARNING_ORDER_1,  // 町	
	0x753B, KANJI_LEARNING_ORDER_2,  // 画	
	0x754C, KANJI_LEARNING_ORDER_3,  // 界	
	0x7551, KANJI_LEARNING_ORDER_3,  // 畑	
	0x7554, KANJI_LEARNING_ORDER_7,  // 畔	
	0x7559, KANJI_LEARNING_ORDER_5,  // 留	
	0x755C, KANJI_LEARNING_ORDER_7,  // 畜	
	0x755D, KANJI_LEARNING_ORDER_7,  // 畝	
	0x7565, KANJI_LEARNING_ORDER_5,  // 略	
	0x756A, KANJI_LEARNING_ORDER_2,  // 番	
	0x7570, KANJI_LEARNING_ORDER_6,  // 異	
	0x7573, KANJI_LEARNING_ORDER_7,  // 畳	
	0x758E, KANJI_LEARNING_ORDER_7,  // 疎	
	0x7591, KANJI_LEARNING_ORDER_6,  // 疑	
	0x75AB, KANJI_LEARNING_ORDER_7,  // 疫	
	0x75B2, KANJI_LEARNING_ORDER_7,  // 疲	
	0x75BE, KANJI_LEARNING_ORDER_7,  // 疾	
	0x75C5, KANJI_LEARNING_ORDER_3,  // 病	
	0x75C7, KANJI_LEARNING_ORDER_7,  // 症	
	0x75D8, KANJI_LEARNING_ORDER_7,  // 痘	
	0x75DB, KANJI_LEARNING_ORDER_6,  // 痛	
	0x75E2, KANJI_LEARNING_ORDER_7,  // 痢	
	0x75F4, KANJI_LEARNING_ORDER_7,  // 痴	
	0x7642, KANJI_LEARNING_ORDER_7,  // 療	
	0x7652, KANJI_LEARNING_ORDER_7,  // 癒	
	0x7656, KANJI_LEARNING_ORDER_7,  // 癖	
	0x767A, KANJI_LEARNING_ORDER_3,  // 発	
	0x767B, KANJI_LEARNING_ORDER_3,  // 登	
	0x767D, KANJI_LEARNING_ORDER_1,  // 白	
	0x767E, KANJI_LEARNING_ORDER_1,  // 百	
	0x7684, KANJI_LEARNING_ORDER_4,  // 的	
	0x7686, KANJI_LEARNING_ORDER_7,  // 皆	
	0x7687, KANJI_LEARNING_ORDER_6,  // 皇	
	0x76AE, KANJI_LEARNING_ORDER_3,  // 皮	
	0x76BF, KANJI_LEARNING_ORDER_3,  // 皿	
	0x76C6, KANJI_LEARNING_ORDER_7,  // 盆	
	0x76CA, KANJI_LEARNING_ORDER_5,  // 益	
	0x76D7, KANJI_LEARNING_ORDER_7,  // 盗	
	0x76DB, KANJI_LEARNING_ORDER_6,  // 盛	
	0x76DF, KANJI_LEARNING_ORDER_6,  // 盟	
	0x76E3, KANJI_LEARNING_ORDER_7,  // 監	
	0x76E4, KANJI_LEARNING_ORDER_7,  // 盤	
	0x76EE, KANJI_LEARNING_ORDER_1,  // 目	
	0x76F2, KANJI_LEARNING_ORDER_7,  // 盲	
	0x76F4, KANJI_LEARNING_ORDER_2,  // 直	
	0x76F8, KANJI_LEARNING_ORDER_3,  // 相	
	0x76FE, KANJI_LEARNING_ORDER_7,  // 盾	
	0x7701, KANJI_LEARNING_ORDER_4,  // 省	
	0x770B, KANJI_LEARNING_ORDER_6,  // 看	
	0x770C, KANJI_LEARNING_ORDER_3,  // 県	
	0x771F, KANJI_LEARNING_ORDER_3,  // 真	
	0x7720, KANJI_LEARNING_ORDER_7,  // 眠	
	0x773A, KANJI_LEARNING_ORDER_7,  // 眺	
	0x773C, KANJI_LEARNING_ORDER_5,  // 眼	
	0x7740, KANJI_LEARNING_ORDER_3,  // 着	
	0x7761, KANJI_LEARNING_ORDER_7,  // 睡	
	0x7763, KANJI_LEARNING_ORDER_7,  // 督	
	0x77AC, KANJI_LEARNING_ORDER_7,  // 瞬	
	0x77DB, KANJI_LEARNING_ORDER_7,  // 矛	
	0x77E2, KANJI_LEARNING_ORDER_2,  // 矢	
	0x77E5, KANJI_LEARNING_ORDER_2,  // 知	
	0x77ED, KANJI_LEARNING_ORDER_3,  // 短	
	0x77EF, KANJI_LEARNING_ORDER_7,  // 矯	
	0x77F3, KANJI_LEARNING_ORDER_1,  // 石	
	0x7802, KANJI_LEARNING_ORDER_6,  // 砂	
	0x7814, KANJI_LEARNING_ORDER_3,  // 研	
	0x7815, KANJI_LEARNING_ORDER_7,  // 砕	
	0x7832, KANJI_LEARNING_ORDER_7,  // 砲	
	0x7834, KANJI_LEARNING_ORDER_5,  // 破	
	0x785D, KANJI_LEARNING_ORDER_7,  // 硝	
	0x786B, KANJI_LEARNING_ORDER_7,  // 硫	
	0x786C, KANJI_LEARNING_ORDER_7,  // 硬	
	0x7881, KANJI_LEARNING_ORDER_7,  // 碁	
	0x7891, KANJI_LEARNING_ORDER_7,  // 碑	
	0x78BA, KANJI_LEARNING_ORDER_5,  // 確	
	0x78C1, KANJI_LEARNING_ORDER_6,  // 磁	
	0x78E8, KANJI_LEARNING_ORDER_7,  // 磨	
	0x7901, KANJI_LEARNING_ORDER_7,  // 礁	
	0x790E, KANJI_LEARNING_ORDER_7,  // 礎	
	0x793A, KANJI_LEARNING_ORDER_5,  // 示	
	0x793C, KANJI_LEARNING_ORDER_3,  // 礼	
	0x793E, KANJI_LEARNING_ORDER_2,  // 社	
	0x7948, KANJI_LEARNING_ORDER_7,  // 祈	
	0x7949, KANJI_LEARNING_ORDER_7,  // 祉	
	0x7956, KANJI_LEARNING_ORDER_5,  // 祖	
	0x795D, KANJI_LEARNING_ORDER_4,  // 祝	
	0x795E, KANJI_LEARNING_ORDER_3,  // 神	
	0x7965, KANJI_LEARNING_ORDER_7,  // 祥	
	0x7968, KANJI_LEARNING_ORDER_4,  // 票	
	0x796D, KANJI_LEARNING_ORDER_3,  // 祭	
	0x7981, KANJI_LEARNING_ORDER_5,  // 禁	
	0x7985, KANJI_LEARNING_ORDER_7,  // 禅	
	0x798D, KANJI_LEARNING_ORDER_7,  // 禍	
	0x798F, KANJI_LEARNING_ORDER_3,  // 福	
	0x79C0, KANJI_LEARNING_ORDER_7,  // 秀	
	0x79C1, KANJI_LEARNING_ORDER_6,  // 私	
	0x79CB, KANJI_LEARNING_ORDER_2,  // 秋	
	0x79D1, KANJI_LEARNING_ORDER_2,  // 科	
	0x79D2, KANJI_LEARNING_ORDER_3,  // 秒	
	0x79D8, KANJI_LEARNING_ORDER_6,  // 秘	
	0x79DF, KANJI_LEARNING_ORDER_7,  // 租	
	0x79E9, KANJI_LEARNING_ORDER_7,  // 秩	
	0x79F0, KANJI_LEARNING_ORDER_7,  // 称	
	0x79FB, KANJI_LEARNING_ORDER_5,  // 移	
	0x7A0B, KANJI_LEARNING_ORDER_5,  // 程	
	0x7A0E, KANJI_LEARNING_ORDER_5,  // 税	
	0x7A1A, KANJI_LEARNING_ORDER_7,  // 稚	
	0x7A2E, KANJI_LEARNING_ORDER_4,  // 種	
	0x7A32, KANJI_LEARNING_ORDER_7,  // 稲	
	0x7A3C, KANJI_LEARNING_ORDER_7,  // 稼	
	0x7A3F, KANJI_LEARNING_ORDER_7,  // 稿	
	0x7A40, KANJI_LEARNING_ORDER_6,  // 穀	
	0x7A42, KANJI_LEARNING_ORDER_7,  // 穂	
	0x7A4D, KANJI_LEARNING_ORDER_4,  // 積	
	0x7A4F, KANJI_LEARNING_ORDER_7,  // 穏	
	0x7A6B, KANJI_LEARNING_ORDER_7,  // 穫	
	0x7A74, KANJI_LEARNING_ORDER_6,  // 穴	
	0x7A76, KANJI_LEARNING_ORDER_3,  // 究	
	0x7A7A, KANJI_LEARNING_ORDER_1,  // 空	
	0x7A81, KANJI_LEARNING_ORDER_7,  // 突	
	0x7A83, KANJI_LEARNING_ORDER_7,  // 窃	
	0x7A92, KANJI_LEARNING_ORDER_7,  // 窒	
	0x7A93, KANJI_LEARNING_ORDER_6,  // 窓	
	0x7AAE, KANJI_LEARNING_ORDER_7,  // 窮	
	0x7AAF, KANJI_LEARNING_ORDER_7,  // 窯	
	0x7ACB, KANJI_LEARNING_ORDER_1,  // 立	
	0x7ADC, KANJI_LEARNING_ORDER_7,  // 竜	
	0x7AE0, KANJI_LEARNING_ORDER_3,  // 章	
	0x7AE5, KANJI_LEARNING_ORDER_3,  // 童	
	0x7AEF, KANJI_LEARNING_ORDER_7,  // 端	
	0x7AF6, KANJI_LEARNING_ORDER_4,  // 競	
	0x7AF9, KANJI_LEARNING_ORDER_1,  // 竹	
	0x7B11, KANJI_LEARNING_ORDER_4,  // 笑	
	0x7B1B, KANJI_LEARNING_ORDER_3,  // 笛	
	0x7B26, KANJI_LEARNING_ORDER_7,  // 符	
	0x7B2C, KANJI_LEARNING_ORDER_3,  // 第	
	0x7B46, KANJI_LEARNING_ORDER_3,  // 筆	
	0x7B49, KANJI_LEARNING_ORDER_3,  // 等	
	0x7B4B, KANJI_LEARNING_ORDER_6,  // 筋	
	0x7B52, KANJI_LEARNING_ORDER_7,  // 筒	
	0x7B54, KANJI_LEARNING_ORDER_2,  // 答	
	0x7B56, KANJI_LEARNING_ORDER_6,  // 策	
	0x7B87, KANJI_LEARNING_ORDER_7,  // 箇	
	0x7B97, KANJI_LEARNING_ORDER_2,  // 算	
	0x7BA1, KANJI_LEARNING_ORDER_4,  // 管	
	0x7BB1, KANJI_LEARNING_ORDER_3,  // 箱	
	0x7BC0, KANJI_LEARNING_ORDER_4,  // 節	
	0x7BC4, KANJI_LEARNING_ORDER_7,  // 範	
	0x7BC9, KANJI_LEARNING_ORDER_5,  // 築	
	0x7BE4, KANJI_LEARNING_ORDER_7,  // 篤	
	0x7C21, KANJI_LEARNING_ORDER_6,  // 簡	
	0x7C3F, KANJI_LEARNING_ORDER_7,  // 簿	
	0x7C4D, KANJI_LEARNING_ORDER_7,  // 籍	
	0x7C73, KANJI_LEARNING_ORDER_2,  // 米	
	0x7C89, KANJI_LEARNING_ORDER_4,  // 粉	
	0x7C8B, KANJI_LEARNING_ORDER_7,  // 粋	
	0x7C92, KANJI_LEARNING_ORDER_7,  // 粒	
	0x7C97, KANJI_LEARNING_ORDER_7,  // 粗	
	0x7C98, KANJI_LEARNING_ORDER_7,  // 粘	
	0x7C9B, KANJI_LEARNING_ORDER_7,  // 粛	
	0x7CA7, KANJI_LEARNING_ORDER_7,  // 粧	
	0x7CBE, KANJI_LEARNING_ORDER_5,  // 精	
	0x7CD6, KANJI_LEARNING_ORDER_6,  // 糖	
	0x7CE7, KANJI_LEARNING_ORDER_7,  // 糧	
	0x7CF8, KANJI_LEARNING_ORDER_1,  // 糸	
	0x7CFB, KANJI_LEARNING_ORDER_6,  // 系	
	0x7CFE, KANJI_LEARNING_ORDER_7,  // 糾	
	0x7D00, KANJI_LEARNING_ORDER_4,  // 紀	
	0x7D04, KANJI_LEARNING_ORDER_4,  // 約	
	0x7D05, KANJI_LEARNING_ORDER_6,  // 紅	
	0x7D0B, KANJI_LEARNING_ORDER_7,  // 紋	
	0x7D0D, KANJI_LEARNING_ORDER_6,  // 納	
	0x7D14, KANJI_LEARNING_ORDER_6,  // 純	
	0x7D19, KANJI_LEARNING_ORDER_2,  // 紙	
	0x7D1A, KANJI_LEARNING_ORDER_3,  // 級	
	0x7D1B, KANJI_LEARNING_ORDER_7,  // 紛	
	0x7D20, KANJI_LEARNING_ORDER_5,  // 素	
	0x7D21, KANJI_LEARNING_ORDER_7,  // 紡	
	0x7D22, KANJI_LEARNING_ORDER_7,  // 索	
	0x7D2B, KANJI_LEARNING_ORDER_7,  // 紫	
	0x7D2F, KANJI_LEARNING_ORDER_7,  // 累	
	0x7D30, KANJI_LEARNING_ORDER_2,  // 細	
	0x7D33, KANJI_LEARNING_ORDER_7,  // 紳	
	0x7D39, KANJI_LEARNING_ORDER_7,  // 紹	
	0x7D3A, KANJI_LEARNING_ORDER_7,  // 紺	
	0x7D42, KANJI_LEARNING_ORDER_3,  // 終	
	0x7D44, KANJI_LEARNING_ORDER_2,  // 組	
	0x7D4C, KANJI_LEARNING_ORDER_5,  // 経	
	0x7D50, KANJI_LEARNING_ORDER_4,  // 結	
	0x7D5E, KANJI_LEARNING_ORDER_7,  // 絞	
	0x7D61, KANJI_LEARNING_ORDER_7,  // 絡	
	0x7D66, KANJI_LEARNING_ORDER_4,  // 給	
	0x7D71, KANJI_LEARNING_ORDER_5,  // 統	
	0x7D75, KANJI_LEARNING_ORDER_2,  // 絵	
	0x7D76, KANJI_LEARNING_ORDER_5,  // 絶	
	0x7D79, KANJI_LEARNING_ORDER_6,  // 絹	
	0x7D99, KANJI_LEARNING_ORDER_7,  // 継	
	0x7D9A, KANJI_LEARNING_ORDER_4,  // 続	
	0x7DAD, KANJI_LEARNING_ORDER_7,  // 維	
	0x7DB1, KANJI_LEARNING_ORDER_7,  // 綱	
	0x7DB2, KANJI_LEARNING_ORDER_7,  // 網	
	0x7DBF, KANJI_LEARNING_ORDER_5,  // 綿	
	0x7DCA, KANJI_LEARNING_ORDER_7,  // 緊	
	0x7DCF, KANJI_LEARNING_ORDER_5,  // 総	
	0x7DD1, KANJI_LEARNING_ORDER_3,  // 緑	
	0x7DD2, KANJI_LEARNING_ORDER_7,  // 緒	
	0x7DDA, KANJI_LEARNING_ORDER_2,  // 線	
	0x7DE0, KANJI_LEARNING_ORDER_7,  // 締	
	0x7DE8, KANJI_LEARNING_ORDER_5,  // 編	
	0x7DE9, KANJI_LEARNING_ORDER_7,  // 緩	
	0x7DEF, KANJI_LEARNING_ORDER_7,  // 緯	
	0x7DF4, KANJI_LEARNING_ORDER_3,  // 練	
	0x7E01, KANJI_LEARNING_ORDER_7,  // 縁	
	0x7E04, KANJI_LEARNING_ORDER_7,  // 縄	
	0x7E1B, KANJI_LEARNING_ORDER_7,  // 縛	
	0x7E26, KANJI_LEARNING_ORDER_6,  // 縦	
	0x7E2B, KANJI_LEARNING_ORDER_7,  // 縫	
	0x7E2E, KANJI_LEARNING_ORDER_6,  // 縮	
	0x7E3E, KANJI_LEARNING_ORDER_5,  // 績	
	0x7E41, KANJI_LEARNING_ORDER_7,  // 繁	
	0x7E4A, KANJI_LEARNING_ORDER_7,  // 繊	
	0x7E54, KANJI_LEARNING_ORDER_5,  // 織	
	0x7E55, KANJI_LEARNING_ORDER_7,  // 繕	
	0x7E6D, KANJI_LEARNING_ORDER_7,  // 繭	
	0x7E70, KANJI_LEARNING_ORDER_7,  // 繰	
	0x7F36, KANJI_LEARNING_ORDER_7,  // 缶	
	0x7F6A, KANJI_LEARNING_ORDER_5,  // 罪	
	0x7F6E, KANJI_LEARNING_ORDER_4,  // 置	
	0x7F70, KANJI_LEARNING_ORDER_7,  // 罰	
	0x7F72, KANJI_LEARNING_ORDER_6,  // 署	
	0x7F77, KANJI_LEARNING_ORDER_7,  // 罷	
	0x7F85, KANJI_LEARNING_ORDER_7,  // 羅	
	0x7F8A, KANJI_LEARNING_ORDER_3,  // 羊	
	0x7F8E, KANJI_LEARNING_ORDER_3,  // 美	
	0x7FA4, KANJI_LEARNING_ORDER_5,  // 群	
	0x7FA9, KANJI_LEARNING_ORDER_5,  // 義	
	0x7FBD, KANJI_LEARNING_ORDER_2,  // 羽	
	0x7FC1, KANJI_LEARNING_ORDER_7,  // 翁	
	0x7FCC, KANJI_LEARNING_ORDER_6,  // 翌	
	0x7FD2, KANJI_LEARNING_ORDER_3,  // 習	
	0x7FFB, KANJI_LEARNING_ORDER_7,  // 翻	
	0x7FFC, KANJI_LEARNING_ORDER_7,  // 翼	
	0x8001, KANJI_LEARNING_ORDER_4,  // 老	
	0x8003, KANJI_LEARNING_ORDER_2,  // 考	
	0x8005, KANJI_LEARNING_ORDER_3,  // 者	
	0x8010, KANJI_LEARNING_ORDER_7,  // 耐	
	0x8015, KANJI_LEARNING_ORDER_5,  // 耕	
	0x8017, KANJI_LEARNING_ORDER_7,  // 耗	
	0x8033, KANJI_LEARNING_ORDER_1,  // 耳	
	0x8056, KANJI_LEARNING_ORDER_6,  // 聖	
	0x805E, KANJI_LEARNING_ORDER_2,  // 聞	
	0x8074, KANJI_LEARNING_ORDER_7,  // 聴	
	0x8077, KANJI_LEARNING_ORDER_5,  // 職	
	0x8089, KANJI_LEARNING_ORDER_2,  // 肉	
	0x808C, KANJI_LEARNING_ORDER_7,  // 肌	
	0x8096, KANJI_LEARNING_ORDER_7,  // 肖	
	0x809D, KANJI_LEARNING_ORDER_7,  // 肝	
	0x80A2, KANJI_LEARNING_ORDER_7,  // 肢	
	0x80A5, KANJI_LEARNING_ORDER_5,  // 肥	
	0x80A9, KANJI_LEARNING_ORDER_7,  // 肩	
	0x80AA, KANJI_LEARNING_ORDER_7,  // 肪	
	0x80AF, KANJI_LEARNING_ORDER_7,  // 肯	
	0x80B2, KANJI_LEARNING_ORDER_3,  // 育	
	0x80BA, KANJI_LEARNING_ORDER_6,  // 肺	
	0x80C3, KANJI_LEARNING_ORDER_4,  // 胃	
	0x80C6, KANJI_LEARNING_ORDER_7,  // 胆	
	0x80CC, KANJI_LEARNING_ORDER_6,  // 背	
	0x80CE, KANJI_LEARNING_ORDER_7,  // 胎	
	0x80DE, KANJI_LEARNING_ORDER_7,  // 胞	
	0x80F4, KANJI_LEARNING_ORDER_7,  // 胴	
	0x80F8, KANJI_LEARNING_ORDER_6,  // 胸	
	0x80FD, KANJI_LEARNING_ORDER_5,  // 能	
	0x8102, KANJI_LEARNING_ORDER_7,  // 脂	
	0x8105, KANJI_LEARNING_ORDER_7,  // 脅	
	0x8108, KANJI_LEARNING_ORDER_4,  // 脈	
	0x811A, KANJI_LEARNING_ORDER_7,  // 脚	
	0x8131, KANJI_LEARNING_ORDER_7,  // 脱	
	0x8133, KANJI_LEARNING_ORDER_6,  // 脳	
	0x8139, KANJI_LEARNING_ORDER_7,  // 脹	
	0x8150, KANJI_LEARNING_ORDER_7,  // 腐	
	0x8155, KANJI_LEARNING_ORDER_7,  // 腕	
	0x8170, KANJI_LEARNING_ORDER_7,  // 腰	
	0x8178, KANJI_LEARNING_ORDER_4,  // 腸	
	0x8179, KANJI_LEARNING_ORDER_6,  // 腹	
	0x819A, KANJI_LEARNING_ORDER_7,  // 膚	
	0x819C, KANJI_LEARNING_ORDER_7,  // 膜	
	0x81A8, KANJI_LEARNING_ORDER_7,  // 膨	
	0x81D3, KANJI_LEARNING_ORDER_6,  // 臓	
	0x81E3, KANJI_LEARNING_ORDER_4,  // 臣	
	0x81E8, KANJI_LEARNING_ORDER_6,  // 臨	
	0x81EA, KANJI_LEARNING_ORDER_2,  // 自	
	0x81ED, KANJI_LEARNING_ORDER_7,  // 臭	
	0x81F3, KANJI_LEARNING_ORDER_6,  // 至	
	0x81F4, KANJI_LEARNING_ORDER_7,  // 致	
	0x8208, KANJI_LEARNING_ORDER_5,  // 興	
	0x820C, KANJI_LEARNING_ORDER_5,  // 舌	
	0x820E, KANJI_LEARNING_ORDER_5,  // 舎	
	0x8217, KANJI_LEARNING_ORDER_7,  // 舗	
	0x821E, KANJI_LEARNING_ORDER_7,  // 舞	
	0x821F, KANJI_LEARNING_ORDER_7,  // 舟	
	0x822A, KANJI_LEARNING_ORDER_4,  // 航	
	0x822C, KANJI_LEARNING_ORDER_7,  // 般	
	0x8236, KANJI_LEARNING_ORDER_7,  // 舶	
	0x8239, KANJI_LEARNING_ORDER_2,  // 船	
	0x8247, KANJI_LEARNING_ORDER_7,  // 艇	
	0x8266, KANJI_LEARNING_ORDER_7,  // 艦	
	0x826F, KANJI_LEARNING_ORDER_4,  // 良	
	0x8272, KANJI_LEARNING_ORDER_2,  // 色	
	0x828B, KANJI_LEARNING_ORDER_7,  // 芋	
	0x829D, KANJI_LEARNING_ORDER_7,  // 芝	
	0x82B1, KANJI_LEARNING_ORDER_1,  // 花	
	0x82B3, KANJI_LEARNING_ORDER_7,  // 芳	
	0x82B8, KANJI_LEARNING_ORDER_4,  // 芸	
	0x82BD, KANJI_LEARNING_ORDER_4,  // 芽	
	0x82D7, KANJI_LEARNING_ORDER_7,  // 苗	
	0x82E5, KANJI_LEARNING_ORDER_6,  // 若	
	0x82E6, KANJI_LEARNING_ORDER_3,  // 苦	
	0x82F1, KANJI_LEARNING_ORDER_4,  // 英	
	0x8302, KANJI_LEARNING_ORDER_7,  // 茂	
	0x830E, KANJI_LEARNING_ORDER_7,  // 茎	
	0x8336, KANJI_LEARNING_ORDER_2,  // 茶	
	0x8349, KANJI_LEARNING_ORDER_1,  // 草	
	0x8352, KANJI_LEARNING_ORDER_7,  // 荒	
	0x8358, KANJI_LEARNING_ORDER_7,  // 荘	
	0x8377, KANJI_LEARNING_ORDER_3,  // 荷	
	0x83CA, KANJI_LEARNING_ORDER_7,  // 菊	
	0x83CC, KANJI_LEARNING_ORDER_7,  // 菌	
	0x83D3, KANJI_LEARNING_ORDER_7,  // 菓	
	0x83DC, KANJI_LEARNING_ORDER_4,  // 菜	
	0x83EF, KANJI_LEARNING_ORDER_7,  // 華	
	0x843D, KANJI_LEARNING_ORDER_3,  // 落	
	0x8449, KANJI_LEARNING_ORDER_3,  // 葉	
	0x8457, KANJI_LEARNING_ORDER_6,  // 著	
	0x846C, KANJI_LEARNING_ORDER_7,  // 葬	
	0x84B8, KANJI_LEARNING_ORDER_6,  // 蒸	
	0x84C4, KANJI_LEARNING_ORDER_7,  // 蓄	
	0x8535, KANJI_LEARNING_ORDER_6,  // 蔵	
	0x8584, KANJI_LEARNING_ORDER_7,  // 薄	
	0x85A6, KANJI_LEARNING_ORDER_7,  // 薦	
	0x85AA, KANJI_LEARNING_ORDER_7,  // 薪	
	0x85AB, KANJI_LEARNING_ORDER_7,  // 薫	
	0x85AC, KANJI_LEARNING_ORDER_3,  // 薬	
	0x85E9, KANJI_LEARNING_ORDER_7,  // 藩	
	0x85FB, KANJI_LEARNING_ORDER_7,  // 藻	
	0x8650, KANJI_LEARNING_ORDER_7,  // 虐	
	0x865A, KANJI_LEARNING_ORDER_7,  // 虚	
	0x865C, KANJI_LEARNING_ORDER_7,  // 虜	
	0x865E, KANJI_LEARNING_ORDER_7,  // 虞	
	0x866B, KANJI_LEARNING_ORDER_1,  // 虫	
	0x868A, KANJI_LEARNING_ORDER_7,  // 蚊	
	0x8695, KANJI_LEARNING_ORDER_6,  // 蚕	
	0x86C7, KANJI_LEARNING_ORDER_7,  // 蛇	
	0x86CD, KANJI_LEARNING_ORDER_7,  // 蛍	
	0x86EE, KANJI_LEARNING_ORDER_7,  // 蛮	
	0x878D, KANJI_LEARNING_ORDER_7,  // 融	
	0x8840, KANJI_LEARNING_ORDER_3,  // 血	
	0x8846, KANJI_LEARNING_ORDER_6,  // 衆	
	0x884C, KANJI_LEARNING_ORDER_2,  // 行	
	0x8853, KANJI_LEARNING_ORDER_5,  // 術	
	0x8857, KANJI_LEARNING_ORDER_4,  // 街	
	0x885B, KANJI_LEARNING_ORDER_5,  // 衛	
	0x885D, KANJI_LEARNING_ORDER_7,  // 衝	
	0x8861, KANJI_LEARNING_ORDER_7,  // 衡	
	0x8863, KANJI_LEARNING_ORDER_4,  // 衣	
	0x8868, KANJI_LEARNING_ORDER_3,  // 表	
	0x8870, KANJI_LEARNING_ORDER_7,  // 衰	
	0x8877, KANJI_LEARNING_ORDER_7,  // 衷	
	0x888B, KANJI_LEARNING_ORDER_7,  // 袋	
	0x88AB, KANJI_LEARNING_ORDER_7,  // 被	
	0x88C1, KANJI_LEARNING_ORDER_6,  // 裁	
	0x88C2, KANJI_LEARNING_ORDER_7,  // 裂	
	0x88C5, KANJI_LEARNING_ORDER_6,  // 装	
	0x88CF, KANJI_LEARNING_ORDER_6,  // 裏	
	0x88D5, KANJI_LEARNING_ORDER_7,  // 裕	
	0x88DC, KANJI_LEARNING_ORDER_6,  // 補	
	0x88F8, KANJI_LEARNING_ORDER_7,  // 裸	
	0x88FD, KANJI_LEARNING_ORDER_5,  // 製	
	0x8907, KANJI_LEARNING_ORDER_5,  // 複	
	0x8910, KANJI_LEARNING_ORDER_7,  // 褐	
	0x8912, KANJI_LEARNING_ORDER_7,  // 褒	
	0x895F, KANJI_LEARNING_ORDER_7,  // 襟	
	0x8972, KANJI_LEARNING_ORDER_7,  // 襲	
	0x897F, KANJI_LEARNING_ORDER_2,  // 西	
	0x8981, KANJI_LEARNING_ORDER_4,  // 要	
	0x8986, KANJI_LEARNING_ORDER_7,  // 覆	
	0x8987, KANJI_LEARNING_ORDER_7,  // 覇	
	0x898B, KANJI_LEARNING_ORDER_1,  // 見	
	0x898F, KANJI_LEARNING_ORDER_5,  // 規	
	0x8996, KANJI_LEARNING_ORDER_6,  // 視	
	0x899A, KANJI_LEARNING_ORDER_4,  // 覚	
	0x89A7, KANJI_LEARNING_ORDER_6,  // 覧	
	0x89AA, KANJI_LEARNING_ORDER_2,  // 親	
	0x89B3, KANJI_LEARNING_ORDER_4,  // 観	
	0x89D2, KANJI_LEARNING_ORDER_2,  // 角	
	0x89E3, KANJI_LEARNING_ORDER_5,  // 解	
	0x89E6, KANJI_LEARNING_ORDER_7,  // 触	
	0x8A00, KANJI_LEARNING_ORDER_2,  // 言	
	0x8A02, KANJI_LEARNING_ORDER_7,  // 訂	
	0x8A08, KANJI_LEARNING_ORDER_2,  // 計	
	0x8A0E, KANJI_LEARNING_ORDER_6,  // 討	
	0x8A13, KANJI_LEARNING_ORDER_4,  // 訓	
	0x8A17, KANJI_LEARNING_ORDER_7,  // 託	
	0x8A18, KANJI_LEARNING_ORDER_2,  // 記	
	0x8A1F, KANJI_LEARNING_ORDER_7,  // 訟	
	0x8A2A, KANJI_LEARNING_ORDER_6,  // 訪	
	0x8A2D, KANJI_LEARNING_ORDER_5,  // 設	
	0x8A31, KANJI_LEARNING_ORDER_5,  // 許	
	0x8A33, KANJI_LEARNING_ORDER_6,  // 訳	
	0x8A34, KANJI_LEARNING_ORDER_7,  // 訴	
	0x8A3A, KANJI_LEARNING_ORDER_7,  // 診	
	0x8A3C, KANJI_LEARNING_ORDER_5,  // 証	
	0x8A50, KANJI_LEARNING_ORDER_7,  // 詐	
	0x8A54, KANJI_LEARNING_ORDER_7,  // 詔	
	0x8A55, KANJI_LEARNING_ORDER_5,  // 評	
	0x8A5E, KANJI_LEARNING_ORDER_6,  // 詞	
	0x8A60, KANJI_LEARNING_ORDER_7,  // 詠	
	0x8A66, KANJI_LEARNING_ORDER_4,  // 試	
	0x8A69, KANJI_LEARNING_ORDER_3,  // 詩	
	0x8A70, KANJI_LEARNING_ORDER_7,  // 詰	
	0x8A71, KANJI_LEARNING_ORDER_2,  // 話	
	0x8A72, KANJI_LEARNING_ORDER_7,  // 該	
	0x8A73, KANJI_LEARNING_ORDER_7,  // 詳	
	0x8A87, KANJI_LEARNING_ORDER_7,  // 誇	
	0x8A89, KANJI_LEARNING_ORDER_7,  // 誉	
	0x8A8C, KANJI_LEARNING_ORDER_6,  // 誌	
	0x8A8D, KANJI_LEARNING_ORDER_6,  // 認	
	0x8A93, KANJI_LEARNING_ORDER_7,  // 誓	
	0x8A95, KANJI_LEARNING_ORDER_6,  // 誕	
	0x8A98, KANJI_LEARNING_ORDER_7,  // 誘	
	0x8A9E, KANJI_LEARNING_ORDER_2,  // 語	
	0x8AA0, KANJI_LEARNING_ORDER_6,  // 誠	
	0x8AA4, KANJI_LEARNING_ORDER_6,  // 誤	
	0x8AAC, KANJI_LEARNING_ORDER_4,  // 説	
	0x8AAD, KANJI_LEARNING_ORDER_2,  // 読	
	0x8AB2, KANJI_LEARNING_ORDER_4,  // 課	
	0x8ABF, KANJI_LEARNING_ORDER_3,  // 調	
	0x8AC7, KANJI_LEARNING_ORDER_3,  // 談	
	0x8ACB, KANJI_LEARNING_ORDER_7,  // 請	
	0x8AD6, KANJI_LEARNING_ORDER_6,  // 論	
	0x8AED, KANJI_LEARNING_ORDER_7,  // 諭	
	0x8AEE, KANJI_LEARNING_ORDER_7,  // 諮	
	0x8AF8, KANJI_LEARNING_ORDER_6,  // 諸	
	0x8AFE, KANJI_LEARNING_ORDER_7,  // 諾	
	0x8B00, KANJI_LEARNING_ORDER_7,  // 謀	
	0x8B01, KANJI_LEARNING_ORDER_7,  // 謁	
	0x8B04, KANJI_LEARNING_ORDER_7,  // 謄	
	0x8B19, KANJI_LEARNING_ORDER_7,  // 謙	
	0x8B1B, KANJI_LEARNING_ORDER_5,  // 講	
	0x8B1D, KANJI_LEARNING_ORDER_5,  // 謝	
	0x8B21, KANJI_LEARNING_ORDER_7,  // 謡	
	0x8B39, KANJI_LEARNING_ORDER_7,  // 謹	
	0x8B58, KANJI_LEARNING_ORDER_5,  // 識	
	0x8B5C, KANJI_LEARNING_ORDER_7,  // 譜	
	0x8B66, KANJI_LEARNING_ORDER_6,  // 警	
	0x8B70, KANJI_LEARNING_ORDER_4,  // 議	
	0x8B72, KANJI_LEARNING_ORDER_7,  // 譲	
	0x8B77, KANJI_LEARNING_ORDER_5,  // 護	
	0x8C37, KANJI_LEARNING_ORDER_2,  // 谷	
	0x8C46, KANJI_LEARNING_ORDER_3,  // 豆	
	0x8C4A, KANJI_LEARNING_ORDER_5,  // 豊	
	0x8C5A, KANJI_LEARNING_ORDER_7,  // 豚	
	0x8C61, KANJI_LEARNING_ORDER_4,  // 象	
	0x8C6A, KANJI_LEARNING_ORDER_7,  // 豪	
	0x8C9D, KANJI_LEARNING_ORDER_1,  // 貝	
	0x8C9E, KANJI_LEARNING_ORDER_7,  // 貞	
	0x8CA0, KANJI_LEARNING_ORDER_3,  // 負	
	0x8CA1, KANJI_LEARNING_ORDER_5,  // 財	
	0x8CA2, KANJI_LEARNING_ORDER_7,  // 貢	
	0x8CA7, KANJI_LEARNING_ORDER_5,  // 貧	
	0x8CA8, KANJI_LEARNING_ORDER_4,  // 貨	
	0x8CA9, KANJI_LEARNING_ORDER_7,  // 販	
	0x8CAB, KANJI_LEARNING_ORDER_7,  // 貫	
	0x8CAC, KANJI_LEARNING_ORDER_5,  // 責	
	0x8CAF, KANJI_LEARNING_ORDER_4,  // 貯	
	0x8CB4, KANJI_LEARNING_ORDER_6,  // 貴	
	0x8CB7, KANJI_LEARNING_ORDER_2,  // 買	
	0x8CB8, KANJI_LEARNING_ORDER_5,  // 貸	
	0x8CBB, KANJI_LEARNING_ORDER_4,  // 費	
	0x8CBF, KANJI_LEARNING_ORDER_5,  // 貿	
	0x8CC0, KANJI_LEARNING_ORDER_5,  // 賀	
	0x8CC3, KANJI_LEARNING_ORDER_6,  // 賃	
	0x8CC4, KANJI_LEARNING_ORDER_7,  // 賄	
	0x8CC7, KANJI_LEARNING_ORDER_5,  // 資	
	0x8CCA, KANJI_LEARNING_ORDER_7,  // 賊	
	0x8CD3, KANJI_LEARNING_ORDER_7,  // 賓	
	0x8CDB, KANJI_LEARNING_ORDER_5,  // 賛	
	0x8CDC, KANJI_LEARNING_ORDER_7,  // 賜	
	0x8CDE, KANJI_LEARNING_ORDER_4,  // 賞	
	0x8CE0, KANJI_LEARNING_ORDER_7,  // 賠	
	0x8CE2, KANJI_LEARNING_ORDER_7,  // 賢	
	0x8CE6, KANJI_LEARNING_ORDER_7,  // 賦	
	0x8CEA, KANJI_LEARNING_ORDER_5,  // 質	
	0x8CFC, KANJI_LEARNING_ORDER_7,  // 購	
	0x8D08, KANJI_LEARNING_ORDER_7,  // 贈	
	0x8D64, KANJI_LEARNING_ORDER_1,  // 赤	
	0x8D66, KANJI_LEARNING_ORDER_7,  // 赦	
	0x8D70, KANJI_LEARNING_ORDER_2,  // 走	
	0x8D74, KANJI_LEARNING_ORDER_7,  // 赴	
	0x8D77, KANJI_LEARNING_ORDER_3,  // 起	
	0x8D85, KANJI_LEARNING_ORDER_7,  // 超	
	0x8D8A, KANJI_LEARNING_ORDER_7,  // 越	
	0x8DA3, KANJI_LEARNING_ORDER_7,  // 趣	
	0x8DB3, KANJI_LEARNING_ORDER_1,  // 足	
	0x8DDD, KANJI_LEARNING_ORDER_7,  // 距	
	0x8DE1, KANJI_LEARNING_ORDER_7,  // 跡	
	0x8DEF, KANJI_LEARNING_ORDER_3,  // 路	
	0x8DF3, KANJI_LEARNING_ORDER_7,  // 跳	
	0x8DF5, KANJI_LEARNING_ORDER_7,  // 践	
	0x8E0A, KANJI_LEARNING_ORDER_7,  // 踊	
	0x8E0F, KANJI_LEARNING_ORDER_7,  // 踏	
	0x8E8D, KANJI_LEARNING_ORDER_7,  // 躍	
	0x8EAB, KANJI_LEARNING_ORDER_3,  // 身	
	0x8ECA, KANJI_LEARNING_ORDER_1,  // 車	
	0x8ECC, KANJI_LEARNING_ORDER_7,  // 軌	
	0x8ECD, KANJI_LEARNING_ORDER_4,  // 軍	
	0x8ED2, KANJI_LEARNING_ORDER_7,  // 軒	
	0x8EDF, KANJI_LEARNING_ORDER_7,  // 軟	
	0x8EE2, KANJI_LEARNING_ORDER_3,  // 転	
	0x8EF8, KANJI_LEARNING_ORDER_7,  // 軸	
	0x8EFD, KANJI_LEARNING_ORDER_3,  // 軽	
	0x8F03, KANJI_LEARNING_ORDER_7,  // 較	
	0x8F09, KANJI_LEARNING_ORDER_7,  // 載	
	0x8F1D, KANJI_LEARNING_ORDER_7,  // 輝	
	0x8F29, KANJI_LEARNING_ORDER_7,  // 輩	
	0x8F2A, KANJI_LEARNING_ORDER_4,  // 輪	
	0x8F38, KANJI_LEARNING_ORDER_5,  // 輸	
	0x8F44, KANJI_LEARNING_ORDER_7,  // 轄	
	0x8F9B, KANJI_LEARNING_ORDER_7,  // 辛	
	0x8F9E, KANJI_LEARNING_ORDER_4,  // 辞	
	0x8FB1, KANJI_LEARNING_ORDER_7,  // 辱	
	0x8FB2, KANJI_LEARNING_ORDER_3,  // 農	
	0x8FBA, KANJI_LEARNING_ORDER_4,  // 辺	
	0x8FBC, KANJI_LEARNING_ORDER_7,  // 込	
	0x8FC5, KANJI_LEARNING_ORDER_7,  // 迅	
	0x8FCE, KANJI_LEARNING_ORDER_7,  // 迎	
	0x8FD1, KANJI_LEARNING_ORDER_2,  // 近	
	0x8FD4, KANJI_LEARNING_ORDER_3,  // 返	
	0x8FEB, KANJI_LEARNING_ORDER_7,  // 迫	
	0x8FED, KANJI_LEARNING_ORDER_7,  // 迭	
	0x8FF0, KANJI_LEARNING_ORDER_5,  // 述	
	0x8FF7, KANJI_LEARNING_ORDER_5,  // 迷	
	0x8FFD, KANJI_LEARNING_ORDER_3,  // 追	
	0x9000, KANJI_LEARNING_ORDER_5,  // 退	
	0x9001, KANJI_LEARNING_ORDER_3,  // 送	
	0x9003, KANJI_LEARNING_ORDER_7,  // 逃	
	0x9006, KANJI_LEARNING_ORDER_5,  // 逆	
	0x900F, KANJI_LEARNING_ORDER_7,  // 透	
	0x9010, KANJI_LEARNING_ORDER_7,  // 逐	
	0x9013, KANJI_LEARNING_ORDER_7,  // 逓	
	0x9014, KANJI_LEARNING_ORDER_7,  // 途	
	0x901A, KANJI_LEARNING_ORDER_2,  // 通	
	0x901D, KANJI_LEARNING_ORDER_7,  // 逝	
	0x901F, KANJI_LEARNING_ORDER_3,  // 速	
	0x9020, KANJI_LEARNING_ORDER_5,  // 造	
	0x9023, KANJI_LEARNING_ORDER_4,  // 連	
	0x902E, KANJI_LEARNING_ORDER_7,  // 逮	
	0x9031, KANJI_LEARNING_ORDER_2,  // 週	
	0x9032, KANJI_LEARNING_ORDER_3,  // 進	
	0x9038, KANJI_LEARNING_ORDER_7,  // 逸	
	0x9042, KANJI_LEARNING_ORDER_7,  // 遂	
	0x9045, KANJI_LEARNING_ORDER_7,  // 遅	
	0x9047, KANJI_LEARNING_ORDER_7,  // 遇	
	0x904A, KANJI_LEARNING_ORDER_3,  // 遊	
	0x904B, KANJI_LEARNING_ORDER_3,  // 運	
	0x904D, KANJI_LEARNING_ORDER_7,  // 遍	
	0x904E, KANJI_LEARNING_ORDER_5,  // 過	
	0x9053, KANJI_LEARNING_ORDER_2,  // 道	
	0x9054, KANJI_LEARNING_ORDER_4,  // 達	
	0x9055, KANJI_LEARNING_ORDER_7,  // 違	
	0x9060, KANJI_LEARNING_ORDER_2,  // 遠	
	0x9063, KANJI_LEARNING_ORDER_7,  // 遣	
	0x9069, KANJI_LEARNING_ORDER_5,  // 適	
	0x906D, KANJI_LEARNING_ORDER_7,  // 遭	
	0x906E, KANJI_LEARNING_ORDER_7,  // 遮	
	0x9075, KANJI_LEARNING_ORDER_7,  // 遵	
	0x9077, KANJI_LEARNING_ORDER_7,  // 遷	
	0x9078, KANJI_LEARNING_ORDER_4,  // 選	
	0x907A, KANJI_LEARNING_ORDER_6,  // 遺	
	0x907F, KANJI_LEARNING_ORDER_7,  // 避	
	0x9084, KANJI_LEARNING_ORDER_7,  // 還	
	0x90A6, KANJI_LEARNING_ORDER_7,  // 邦	
	0x90AA, KANJI_LEARNING_ORDER_7,  // 邪	
	0x90B8, KANJI_LEARNING_ORDER_7,  // 邸	
	0x90CA, KANJI_LEARNING_ORDER_7,  // 郊	
	0x90CE, KANJI_LEARNING_ORDER_7,  // 郎	
	0x90E1, KANJI_LEARNING_ORDER_4,  // 郡	
	0x90E8, KANJI_LEARNING_ORDER_3,  // 部	
	0x90ED, KANJI_LEARNING_ORDER_7,  // 郭	
	0x90F5, KANJI_LEARNING_ORDER_6,  // 郵	
	0x90F7, KANJI_LEARNING_ORDER_6,  // 郷	
	0x90FD, KANJI_LEARNING_ORDER_3,  // 都	
	0x914C, KANJI_LEARNING_ORDER_7,  // 酌	
	0x914D, KANJI_LEARNING_ORDER_3,  // 配	
	0x9152, KANJI_LEARNING_ORDER_3,  // 酒	
	0x9154, KANJI_LEARNING_ORDER_7,  // 酔	
	0x9162, KANJI_LEARNING_ORDER_7,  // 酢	
	0x916A, KANJI_LEARNING_ORDER_7,  // 酪	
	0x916C, KANJI_LEARNING_ORDER_7,  // 酬	
	0x9175, KANJI_LEARNING_ORDER_7,  // 酵	
	0x9177, KANJI_LEARNING_ORDER_7,  // 酷	
	0x9178, KANJI_LEARNING_ORDER_5,  // 酸	
	0x919C, KANJI_LEARNING_ORDER_7,  // 醜	
	0x91B8, KANJI_LEARNING_ORDER_7,  // 醸	
	0x91C8, KANJI_LEARNING_ORDER_7,  // 釈	
	0x91CC, KANJI_LEARNING_ORDER_2,  // 里	
	0x91CD, KANJI_LEARNING_ORDER_3,  // 重	
	0x91CE, KANJI_LEARNING_ORDER_2,  // 野	
	0x91CF, KANJI_LEARNING_ORDER_4,  // 量	
	0x91D1, KANJI_LEARNING_ORDER_1,  // 金	
	0x91DD, KANJI_LEARNING_ORDER_6,  // 針	
	0x91E3, KANJI_LEARNING_ORDER_7,  // 釣	
	0x920D, KANJI_LEARNING_ORDER_7,  // 鈍	
	0x9234, KANJI_LEARNING_ORDER_7,  // 鈴	
	0x9244, KANJI_LEARNING_ORDER_3,  // 鉄	
	0x925B, KANJI_LEARNING_ORDER_7,  // 鉛	
	0x9262, KANJI_LEARNING_ORDER_7,  // 鉢	
	0x9271, KANJI_LEARNING_ORDER_5,  // 鉱	
	0x9280, KANJI_LEARNING_ORDER_3,  // 銀	
	0x9283, KANJI_LEARNING_ORDER_7,  // 銃	
	0x9285, KANJI_LEARNING_ORDER_5,  // 銅	
	0x9291, KANJI_LEARNING_ORDER_7,  // 銑	
	0x9298, KANJI_LEARNING_ORDER_7,  // 銘	
	0x92AD, KANJI_LEARNING_ORDER_5,  // 銭	
	0x92ED, KANJI_LEARNING_ORDER_7,  // 鋭	
	0x92F3, KANJI_LEARNING_ORDER_7,  // 鋳	
	0x92FC, KANJI_LEARNING_ORDER_6,  // 鋼	
	0x9318, KANJI_LEARNING_ORDER_7,  // 錘	
	0x9320, KANJI_LEARNING_ORDER_7,  // 錠	
	0x932C, KANJI_LEARNING_ORDER_7,  // 錬	
	0x932F, KANJI_LEARNING_ORDER_7,  // 錯	
	0x9332, KANJI_LEARNING_ORDER_4,  // 録	
	0x935B, KANJI_LEARNING_ORDER_7,  // 鍛	
	0x9396, KANJI_LEARNING_ORDER_7,  // 鎖	
	0x93AE, KANJI_LEARNING_ORDER_7,  // 鎮	
	0x93E1, KANJI_LEARNING_ORDER_4,  // 鏡	
	0x9418, KANJI_LEARNING_ORDER_7,  // 鐘	
	0x9451, KANJI_LEARNING_ORDER_7,  // 鑑	
	0x9577, KANJI_LEARNING_ORDER_2,  // 長	
	0x9580, KANJI_LEARNING_ORDER_2,  // 門	
	0x9589, KANJI_LEARNING_ORDER_6,  // 閉	
	0x958B, KANJI_LEARNING_ORDER_3,  // 開	
	0x9591, KANJI_LEARNING_ORDER_7,  // 閑	
	0x9593, KANJI_LEARNING_ORDER_2,  // 間	
	0x95A2, KANJI_LEARNING_ORDER_4,  // 関	
	0x95A3, KANJI_LEARNING_ORDER_6,  // 閣	
	0x95A5, KANJI_LEARNING_ORDER_7,  // 閥	
	0x95B2, KANJI_LEARNING_ORDER_7,  // 閲	
	0x95D8, KANJI_LEARNING_ORDER_7,  // 闘	
	0x9632, KANJI_LEARNING_ORDER_5,  // 防	
	0x963B, KANJI_LEARNING_ORDER_7,  // 阻	
	0x9644, KANJI_LEARNING_ORDER_7,  // 附	
	0x964D, KANJI_LEARNING_ORDER_6,  // 降	
	0x9650, KANJI_LEARNING_ORDER_5,  // 限	
	0x965B, KANJI_LEARNING_ORDER_6,  // 陛	
	0x9662, KANJI_LEARNING_ORDER_3,  // 院	
	0x9663, KANJI_LEARNING_ORDER_7,  // 陣	
	0x9664, KANJI_LEARNING_ORDER_6,  // 除	
	0x9665, KANJI_LEARNING_ORDER_7,  // 陥	
	0x966A, KANJI_LEARNING_ORDER_7,  // 陪	
	0x9670, KANJI_LEARNING_ORDER_7,  // 陰	
	0x9673, KANJI_LEARNING_ORDER_7,  // 陳	
	0x9675, KANJI_LEARNING_ORDER_7,  // 陵	
	0x9676, KANJI_LEARNING_ORDER_7,  // 陶	
	0x9678, KANJI_LEARNING_ORDER_4,  // 陸	
	0x967A, KANJI_LEARNING_ORDER_5,  // 険	
	0x967D, KANJI_LEARNING_ORDER_3,  // 陽	
	0x9685, KANJI_LEARNING_ORDER_7,  // 隅	
	0x9686, KANJI_LEARNING_ORDER_7,  // 隆	
	0x968A, KANJI_LEARNING_ORDER_4,  // 隊	
	0x968E, KANJI_LEARNING_ORDER_3,  // 階	
	0x968F, KANJI_LEARNING_ORDER_7,  // 随	
	0x9694, KANJI_LEARNING_ORDER_7,  // 隔	
	0x969B, KANJI_LEARNING_ORDER_5,  // 際	
	0x969C, KANJI_LEARNING_ORDER_6,  // 障	
	0x96A0, KANJI_LEARNING_ORDER_7,  // 隠	
	0x96A3, KANJI_LEARNING_ORDER_7,  // 隣	
	0x96B7, KANJI_LEARNING_ORDER_7,  // 隷	
	0x96BB, KANJI_LEARNING_ORDER_7,  // 隻	
	0x96C4, KANJI_LEARNING_ORDER_7,  // 雄	
	0x96C5, KANJI_LEARNING_ORDER_7,  // 雅	
	0x96C6, KANJI_LEARNING_ORDER_3,  // 集	
	0x96C7, KANJI_LEARNING_ORDER_7,  // 雇	
	0x96CC, KANJI_LEARNING_ORDER_7,  // 雌	
	0x96D1, KANJI_LEARNING_ORDER_5,  // 雑	
	0x96E2, KANJI_LEARNING_ORDER_7,  // 離	
	0x96E3, KANJI_LEARNING_ORDER_6,  // 難	
	0x96E8, KANJI_LEARNING_ORDER_1,  // 雨	
	0x96EA, KANJI_LEARNING_ORDER_2,  // 雪	
	0x96F0, KANJI_LEARNING_ORDER_7,  // 雰	
	0x96F2, KANJI_LEARNING_ORDER_2,  // 雲	
	0x96F6, KANJI_LEARNING_ORDER_7,  // 零	
	0x96F7, KANJI_LEARNING_ORDER_7,  // 雷	
	0x96FB, KANJI_LEARNING_ORDER_2,  // 電	
	0x9700, KANJI_LEARNING_ORDER_7,  // 需	
	0x9707, KANJI_LEARNING_ORDER_7,  // 震	
	0x970A, KANJI_LEARNING_ORDER_7,  // 霊	
	0x971C, KANJI_LEARNING_ORDER_7,  // 霜	
	0x9727, KANJI_LEARNING_ORDER_7,  // 霧	
	0x9732, KANJI_LEARNING_ORDER_7,  // 露	
	0x9752, KANJI_LEARNING_ORDER_1,  // 青	
	0x9759, KANJI_LEARNING_ORDER_4,  // 静	
	0x975E, KANJI_LEARNING_ORDER_5,  // 非	
	0x9762, KANJI_LEARNING_ORDER_3,  // 面	
	0x9769, KANJI_LEARNING_ORDER_6,  // 革	
	0x9774, KANJI_LEARNING_ORDER_7,  // 靴	
	0x97F3, KANJI_LEARNING_ORDER_1,  // 音	
	0x97FB, KANJI_LEARNING_ORDER_7,  // 韻	
	0x97FF, KANJI_LEARNING_ORDER_7,  // 響	
	0x9802, KANJI_LEARNING_ORDER_6,  // 頂	
	0x9805, KANJI_LEARNING_ORDER_7,  // 項	
	0x9806, KANJI_LEARNING_ORDER_4,  // 順	
	0x9810, KANJI_LEARNING_ORDER_5,  // 預	
	0x9811, KANJI_LEARNING_ORDER_7,  // 頑	
	0x9812, KANJI_LEARNING_ORDER_7,  // 頒	
	0x9818, KANJI_LEARNING_ORDER_5,  // 領	
	0x982D, KANJI_LEARNING_ORDER_2,  // 頭	
	0x983B, KANJI_LEARNING_ORDER_7,  // 頻	
	0x983C, KANJI_LEARNING_ORDER_7,  // 頼	
	0x984C, KANJI_LEARNING_ORDER_3,  // 題	
	0x984D, KANJI_LEARNING_ORDER_5,  // 額	
	0x9854, KANJI_LEARNING_ORDER_2,  // 顔	
	0x9855, KANJI_LEARNING_ORDER_7,  // 顕	
	0x9858, KANJI_LEARNING_ORDER_4,  // 願	
	0x985E, KANJI_LEARNING_ORDER_4,  // 類	
	0x9867, KANJI_LEARNING_ORDER_7,  // 顧	
	0x98A8, KANJI_LEARNING_ORDER_2,  // 風	
	0x98DB, KANJI_LEARNING_ORDER_4,  // 飛	
	0x98DF, KANJI_LEARNING_ORDER_2,  // 食	
	0x98E2, KANJI_LEARNING_ORDER_7,  // 飢	
	0x98EF, KANJI_LEARNING_ORDER_4,  // 飯	
	0x98F2, KANJI_LEARNING_ORDER_3,  // 飲	
	0x98FC, KANJI_LEARNING_ORDER_5,  // 飼	
	0x98FD, KANJI_LEARNING_ORDER_7,  // 飽	
	0x98FE, KANJI_LEARNING_ORDER_7,  // 飾	
	0x990A, KANJI_LEARNING_ORDER_4,  // 養	
	0x9913, KANJI_LEARNING_ORDER_7,  // 餓	
	0x9928, KANJI_LEARNING_ORDER_3,  // 館	
	0x9996, KANJI_LEARNING_ORDER_2,  // 首	
	0x9999, KANJI_LEARNING_ORDER_7,  // 香	
	0x99AC, KANJI_LEARNING_ORDER_2,  // 馬	
	0x99C4, KANJI_LEARNING_ORDER_7,  // 駄	
	0x99C5, KANJI_LEARNING_ORDER_3,  // 駅	
	0x99C6, KANJI_LEARNING_ORDER_7,  // 駆	
	0x99D0, KANJI_LEARNING_ORDER_7,  // 駐	
	0x9A0E, KANJI_LEARNING_ORDER_7,  // 騎	
	0x9A12, KANJI_LEARNING_ORDER_7,  // 騒	
	0x9A13, KANJI_LEARNING_ORDER_4,  // 験	
	0x9A30, KANJI_LEARNING_ORDER_7,  // 騰	
	0x9A5A, KANJI_LEARNING_ORDER_7,  // 驚	
	0x9AA8, KANJI_LEARNING_ORDER_6,  // 骨	
	0x9AC4, KANJI_LEARNING_ORDER_7,  // 髄	
	0x9AD8, KANJI_LEARNING_ORDER_2,  // 高	
	0x9AEA, KANJI_LEARNING_ORDER_7,  // 髪	
	0x9B3C, KANJI_LEARNING_ORDER_7,  // 鬼	
	0x9B42, KANJI_LEARNING_ORDER_7,  // 魂	
	0x9B45, KANJI_LEARNING_ORDER_7,  // 魅	
	0x9B54, KANJI_LEARNING_ORDER_7,  // 魔	
	0x9B5A, KANJI_LEARNING_ORDER_2,  // 魚	
	0x9BAE, KANJI_LEARNING_ORDER_7,  // 鮮	
	0x9BE8, KANJI_LEARNING_ORDER_7,  // 鯨	
	0x9CE5, KANJI_LEARNING_ORDER_2,  // 鳥	
	0x9CF4, KANJI_LEARNING_ORDER_2,  // 鳴	
	0x9D8F, KANJI_LEARNING_ORDER_7,  // 鶏	
	0x9E97, KANJI_LEARNING_ORDER_7,  // 麗	
	0x9EA6, KANJI_LEARNING_ORDER_2,  // 麦	
	0x9EBB, KANJI_LEARNING_ORDER_7,  // 麻	
	0x9EC4, KANJI_LEARNING_ORDER_2,  // 黄	
	0x9ED2, KANJI_LEARNING_ORDER_2,  // 黒	
	0x9ED9, KANJI_LEARNING_ORDER_7,  // 黙	
	0x9F13, KANJI_LEARNING_ORDER_7,  // 鼓	
	0x9F3B, KANJI_LEARNING_ORDER_3,  // 鼻	
	0x9F62, KANJI_LEARNING_ORDER_7,  // 齢	
	0x4E9C, KANJI_STANDARD,  // 亜
	0x5516, KANJI_STANDARD,  // 唖
	0x5A03, KANJI_STANDARD,  // 娃
	0x963F, KANJI_STANDARD,  // 阿
	0x54C0, KANJI_STANDARD,  // 哀
	0x611B, KANJI_STANDARD,  // 愛
	0x6328, KANJI_STANDARD,  // 挨
	0x59F6, KANJI_STANDARD,  // 姶
	0x9022, KANJI_STANDARD,  // 逢
	0x8475, KANJI_STANDARD,  // 葵
	0x831C, KANJI_STANDARD,  // 茜
	0x7A50, KANJI_STANDARD,  // 穐
	0x60AA, KANJI_STANDARD,  // 悪
	0x63E1, KANJI_STANDARD,  // 握
	0x6E25, KANJI_STANDARD,  // 渥
	0x65ED, KANJI_STANDARD,  // 旭
	0x8466, KANJI_STANDARD,  // 葦
	0x82A6, KANJI_STANDARD,  // 芦
	0x9BF5, KANJI_STANDARD,  // 鯵
	0x6893, KANJI_STANDARD,  // 梓
	0x5727, KANJI_STANDARD,  // 圧
	0x65A1, KANJI_STANDARD,  // 斡
	0x6271, KANJI_STANDARD,  // 扱
	0x5B9B, KANJI_STANDARD,  // 宛
	0x59D0, KANJI_STANDARD,  // 姐
	0x867B, KANJI_STANDARD,  // 虻
	0x98F4, KANJI_STANDARD,  // 飴
	0x7D62, KANJI_STANDARD,  // 絢
	0x7DBE, KANJI_STANDARD,  // 綾
	0x9B8E, KANJI_STANDARD,  // 鮎
	0x6216, KANJI_STANDARD,  // 或
	0x7C9F, KANJI_STANDARD,  // 粟
	0x88B7, KANJI_STANDARD,  // 袷
	0x5B89, KANJI_STANDARD,  // 安
	0x5EB5, KANJI_STANDARD,  // 庵
	0x6309, KANJI_STANDARD,  // 按
	0x6697, KANJI_STANDARD,  // 暗
	0x6848, KANJI_STANDARD,  // 案
	0x95C7, KANJI_STANDARD,  // 闇
	0x978D, KANJI_STANDARD,  // 鞍
	0x674F, KANJI_STANDARD,  // 杏
	0x4EE5, KANJI_STANDARD,  // 以
	0x4F0A, KANJI_STANDARD,  // 伊
	0x4F4D, KANJI_STANDARD,  // 位
	0x4F9D, KANJI_STANDARD,  // 依
	0x5049, KANJI_STANDARD,  // 偉
	0x56F2, KANJI_STANDARD,  // 囲
	0x5937, KANJI_STANDARD,  // 夷
	0x59D4, KANJI_STANDARD,  // 委
	0x5A01, KANJI_STANDARD,  // 威
	0x5C09, KANJI_STANDARD,  // 尉
	0x60DF, KANJI_STANDARD,  // 惟
	0x610F, KANJI_STANDARD,  // 意
	0x6170, KANJI_STANDARD,  // 慰
	0x6613, KANJI_STANDARD,  // 易
	0x6905, KANJI_STANDARD,  // 椅
	0x70BA, KANJI_STANDARD,  // 為
	0x754F, KANJI_STANDARD,  // 畏
	0x7570, KANJI_STANDARD,  // 異
	0x79FB, KANJI_STANDARD,  // 移
	0x7DAD, KANJI_STANDARD,  // 維
	0x7DEF, KANJI_STANDARD,  // 緯
	0x80C3, KANJI_STANDARD,  // 胃
	0x840E, KANJI_STANDARD,  // 萎
	0x8863, KANJI_STANDARD,  // 衣
	0x8B02, KANJI_STANDARD,  // 謂
	0x9055, KANJI_STANDARD,  // 違
	0x907A, KANJI_STANDARD,  // 遺
	0x533B, KANJI_STANDARD,  // 医
	0x4E95, KANJI_STANDARD,  // 井
	0x4EA5, KANJI_STANDARD,  // 亥
	0x57DF, KANJI_STANDARD,  // 域
	0x80B2, KANJI_STANDARD,  // 育
	0x90C1, KANJI_STANDARD,  // 郁
	0x78EF, KANJI_STANDARD,  // 磯
	0x4E00, KANJI_STANDARD,  // 一
	0x58F1, KANJI_STANDARD,  // 壱
	0x6EA2, KANJI_STANDARD,  // 溢
	0x9038, KANJI_STANDARD,  // 逸
	0x7A32, KANJI_STANDARD,  // 稲
	0x8328, KANJI_STANDARD,  // 茨
	0x828B, KANJI_STANDARD,  // 芋
	0x9C2F, KANJI_STANDARD,  // 鰯
	0x5141, KANJI_STANDARD,  // 允
	0x5370, KANJI_STANDARD,  // 印
	0x54BD, KANJI_STANDARD,  // 咽
	0x54E1, KANJI_STANDARD,  // 員
	0x56E0, KANJI_STANDARD,  // 因
	0x59FB, KANJI_STANDARD,  // 姻
	0x5F15, KANJI_STANDARD,  // 引
	0x98F2, KANJI_STANDARD,  // 飲
	0x6DEB, KANJI_STANDARD,  // 淫
	0x80E4, KANJI_STANDARD,  // 胤
	0x852D, KANJI_STANDARD,  // 蔭
	0x9662, KANJI_STANDARD,  // 院
	0x9670, KANJI_STANDARD,  // 陰
	0x96A0, KANJI_STANDARD,  // 隠
	0x97FB, KANJI_STANDARD,  // 韻
	0x540B, KANJI_STANDARD,  // 吋
	0x53F3, KANJI_STANDARD,  // 右
	0x5B87, KANJI_STANDARD,  // 宇
	0x70CF, KANJI_STANDARD,  // 烏
	0x7FBD, KANJI_STANDARD,  // 羽
	0x8FC2, KANJI_STANDARD,  // 迂
	0x96E8, KANJI_STANDARD,  // 雨
	0x536F, KANJI_STANDARD,  // 卯
	0x9D5C, KANJI_STANDARD,  // 鵜
	0x7ABA, KANJI_STANDARD,  // 窺
	0x4E11, KANJI_STANDARD,  // 丑
	0x7893, KANJI_STANDARD,  // 碓
	0x81FC, KANJI_STANDARD,  // 臼
	0x6E26, KANJI_STANDARD,  // 渦
	0x5618, KANJI_STANDARD,  // 嘘
	0x5504, KANJI_STANDARD,  // 唄
	0x6B1D, KANJI_STANDARD,  // 欝
	0x851A, KANJI_STANDARD,  // 蔚
	0x9C3B, KANJI_STANDARD,  // 鰻
	0x59E5, KANJI_STANDARD,  // 姥
	0x53A9, KANJI_STANDARD,  // 厩
	0x6D66, KANJI_STANDARD,  // 浦
	0x74DC, KANJI_STANDARD,  // 瓜
	0x958F, KANJI_STANDARD,  // 閏
	0x5642, KANJI_STANDARD,  // 噂
	0x4E91, KANJI_STANDARD,  // 云
	0x904B, KANJI_STANDARD,  // 運
	0x96F2, KANJI_STANDARD,  // 雲
	0x834F, KANJI_STANDARD,  // 荏
	0x990C, KANJI_STANDARD,  // 餌
	0x53E1, KANJI_STANDARD,  // 叡
	0x55B6, KANJI_STANDARD,  // 営
	0x5B30, KANJI_STANDARD,  // 嬰
	0x5F71, KANJI_STANDARD,  // 影
	0x6620, KANJI_STANDARD,  // 映
	0x66F3, KANJI_STANDARD,  // 曳
	0x6804, KANJI_STANDARD,  // 栄
	0x6C38, KANJI_STANDARD,  // 永
	0x6CF3, KANJI_STANDARD,  // 泳
	0x6D29, KANJI_STANDARD,  // 洩
	0x745B, KANJI_STANDARD,  // 瑛
	0x76C8, KANJI_STANDARD,  // 盈
	0x7A4E, KANJI_STANDARD,  // 穎
	0x9834, KANJI_STANDARD,  // 頴
	0x82F1, KANJI_STANDARD,  // 英
	0x885B, KANJI_STANDARD,  // 衛
	0x8A60, KANJI_STANDARD,  // 詠
	0x92ED, KANJI_STANDARD,  // 鋭
	0x6DB2, KANJI_STANDARD,  // 液
	0x75AB, KANJI_STANDARD,  // 疫
	0x76CA, KANJI_STANDARD,  // 益
	0x99C5, KANJI_STANDARD,  // 駅
	0x60A6, KANJI_STANDARD,  // 悦
	0x8B01, KANJI_STANDARD,  // 謁
	0x8D8A, KANJI_STANDARD,  // 越
	0x95B2, KANJI_STANDARD,  // 閲
	0x698E, KANJI_STANDARD,  // 榎
	0x53AD, KANJI_STANDARD,  // 厭
	0x5186, KANJI_STANDARD,  // 円
	0x5712, KANJI_STANDARD,  // 園
	0x5830, KANJI_STANDARD,  // 堰
	0x5944, KANJI_STANDARD,  // 奄
	0x5BB4, KANJI_STANDARD,  // 宴
	0x5EF6, KANJI_STANDARD,  // 延
	0x6028, KANJI_STANDARD,  // 怨
	0x63A9, KANJI_STANDARD,  // 掩
	0x63F4, KANJI_STANDARD,  // 援
	0x6CBF, KANJI_STANDARD,  // 沿
	0x6F14, KANJI_STANDARD,  // 演
	0x708E, KANJI_STANDARD,  // 炎
	0x7114, KANJI_STANDARD,  // 焔
	0x7159, KANJI_STANDARD,  // 煙
	0x71D5, KANJI_STANDARD,  // 燕
	0x733F, KANJI_STANDARD,  // 猿
	0x7E01, KANJI_STANDARD,  // 縁
	0x8276, KANJI_STANDARD,  // 艶
	0x82D1, KANJI_STANDARD,  // 苑
	0x8597, KANJI_STANDARD,  // 薗
	0x9060, KANJI_STANDARD,  // 遠
	0x925B, KANJI_STANDARD,  // 鉛
	0x9D1B, KANJI_STANDARD,  // 鴛
	0x5869, KANJI_STANDARD,  // 塩
	0x65BC, KANJI_STANDARD,  // 於
	0x6C5A, KANJI_STANDARD,  // 汚
	0x7525, KANJI_STANDARD,  // 甥
	0x51F9, KANJI_STANDARD,  // 凹
	0x592E, KANJI_STANDARD,  // 央
	0x5965, KANJI_STANDARD,  // 奥
	0x5F80, KANJI_STANDARD,  // 往
	0x5FDC, KANJI_STANDARD,  // 応
	0x62BC, KANJI_STANDARD,  // 押
	0x65FA, KANJI_STANDARD,  // 旺
	0x6A2A, KANJI_STANDARD,  // 横
	0x6B27, KANJI_STANDARD,  // 欧
	0x6BB4, KANJI_STANDARD,  // 殴
	0x738B, KANJI_STANDARD,  // 王
	0x7FC1, KANJI_STANDARD,  // 翁
	0x8956, KANJI_STANDARD,  // 襖
	0x9D2C, KANJI_STANDARD,  // 鴬
	0x9D0E, KANJI_STANDARD,  // 鴎
	0x9EC4, KANJI_STANDARD,  // 黄
	0x5CA1, KANJI_STANDARD,  // 岡
	0x6C96, KANJI_STANDARD,  // 沖
	0x837B, KANJI_STANDARD,  // 荻
	0x5104, KANJI_STANDARD,  // 億
	0x5C4B, KANJI_STANDARD,  // 屋
	0x61B6, KANJI_STANDARD,  // 憶
	0x81C6, KANJI_STANDARD,  // 臆
	0x6876, KANJI_STANDARD,  // 桶
	0x7261, KANJI_STANDARD,  // 牡
	0x4E59, KANJI_STANDARD,  // 乙
	0x4FFA, KANJI_STANDARD,  // 俺
	0x5378, KANJI_STANDARD,  // 卸
	0x6069, KANJI_STANDARD,  // 恩
	0x6E29, KANJI_STANDARD,  // 温
	0x7A4F, KANJI_STANDARD,  // 穏
	0x97F3, KANJI_STANDARD,  // 音
	0x4E0B, KANJI_STANDARD,  // 下
	0x5316, KANJI_STANDARD,  // 化
	0x4EEE, KANJI_STANDARD,  // 仮
	0x4F55, KANJI_STANDARD,  // 何
	0x4F3D, KANJI_STANDARD,  // 伽
	0x4FA1, KANJI_STANDARD,  // 価
	0x4F73, KANJI_STANDARD,  // 佳
	0x52A0, KANJI_STANDARD,  // 加
	0x53EF, KANJI_STANDARD,  // 可
	0x5609, KANJI_STANDARD,  // 嘉
	0x590F, KANJI_STANDARD,  // 夏
	0x5AC1, KANJI_STANDARD,  // 嫁
	0x5BB6, KANJI_STANDARD,  // 家
	0x5BE1, KANJI_STANDARD,  // 寡
	0x79D1, KANJI_STANDARD,  // 科
	0x6687, KANJI_STANDARD,  // 暇
	0x679C, KANJI_STANDARD,  // 果
	0x67B6, KANJI_STANDARD,  // 架
	0x6B4C, KANJI_STANDARD,  // 歌
	0x6CB3, KANJI_STANDARD,  // 河
	0x706B, KANJI_STANDARD,  // 火
	0x73C2, KANJI_STANDARD,  // 珂
	0x798D, KANJI_STANDARD,  // 禍
	0x79BE, KANJI_STANDARD,  // 禾
	0x7A3C, KANJI_STANDARD,  // 稼
	0x7B87, KANJI_STANDARD,  // 箇
	0x82B1, KANJI_STANDARD,  // 花
	0x82DB, KANJI_STANDARD,  // 苛
	0x8304, KANJI_STANDARD,  // 茄
	0x8377, KANJI_STANDARD,  // 荷
	0x83EF, KANJI_STANDARD,  // 華
	0x83D3, KANJI_STANDARD,  // 菓
	0x8766, KANJI_STANDARD,  // 蝦
	0x8AB2, KANJI_STANDARD,  // 課
	0x5629, KANJI_STANDARD,  // 嘩
	0x8CA8, KANJI_STANDARD,  // 貨
	0x8FE6, KANJI_STANDARD,  // 迦
	0x904E, KANJI_STANDARD,  // 過
	0x971E, KANJI_STANDARD,  // 霞
	0x868A, KANJI_STANDARD,  // 蚊
	0x4FC4, KANJI_STANDARD,  // 俄
	0x5CE8, KANJI_STANDARD,  // 峨
	0x6211, KANJI_STANDARD,  // 我
	0x7259, KANJI_STANDARD,  // 牙
	0x753B, KANJI_STANDARD,  // 画
	0x81E5, KANJI_STANDARD,  // 臥
	0x82BD, KANJI_STANDARD,  // 芽
	0x86FE, KANJI_STANDARD,  // 蛾
	0x8CC0, KANJI_STANDARD,  // 賀
	0x96C5, KANJI_STANDARD,  // 雅
	0x9913, KANJI_STANDARD,  // 餓
	0x99D5, KANJI_STANDARD,  // 駕
	0x4ECB, KANJI_STANDARD,  // 介
	0x4F1A, KANJI_STANDARD,  // 会
	0x89E3, KANJI_STANDARD,  // 解
	0x56DE, KANJI_STANDARD,  // 回
	0x584A, KANJI_STANDARD,  // 塊
	0x58CA, KANJI_STANDARD,  // 壊
	0x5EFB, KANJI_STANDARD,  // 廻
	0x5FEB, KANJI_STANDARD,  // 快
	0x602A, KANJI_STANDARD,  // 怪
	0x6094, KANJI_STANDARD,  // 悔
	0x6062, KANJI_STANDARD,  // 恢
	0x61D0, KANJI_STANDARD,  // 懐
	0x6212, KANJI_STANDARD,  // 戒
	0x62D0, KANJI_STANDARD,  // 拐
	0x6539, KANJI_STANDARD,  // 改
	0x9B41, KANJI_STANDARD,  // 魁
	0x6666, KANJI_STANDARD,  // 晦
	0x68B0, KANJI_STANDARD,  // 械
	0x6D77, KANJI_STANDARD,  // 海
	0x7070, KANJI_STANDARD,  // 灰
	0x754C, KANJI_STANDARD,  // 界
	0x7686, KANJI_STANDARD,  // 皆
	0x7D75, KANJI_STANDARD,  // 絵
	0x82A5, KANJI_STANDARD,  // 芥
	0x87F9, KANJI_STANDARD,  // 蟹
	0x958B, KANJI_STANDARD,  // 開
	0x968E, KANJI_STANDARD,  // 階
	0x8C9D, KANJI_STANDARD,  // 貝
	0x51F1, KANJI_STANDARD,  // 凱
	0x52BE, KANJI_STANDARD,  // 劾
	0x5916, KANJI_STANDARD,  // 外
	0x54B3, KANJI_STANDARD,  // 咳
	0x5BB3, KANJI_STANDARD,  // 害
	0x5D16, KANJI_STANDARD,  // 崖
	0x6168, KANJI_STANDARD,  // 慨
	0x6982, KANJI_STANDARD,  // 概
	0x6DAF, KANJI_STANDARD,  // 涯
	0x788D, KANJI_STANDARD,  // 碍
	0x84CB, KANJI_STANDARD,  // 蓋
	0x8857, KANJI_STANDARD,  // 街
	0x8A72, KANJI_STANDARD,  // 該
	0x93A7, KANJI_STANDARD,  // 鎧
	0x9AB8, KANJI_STANDARD,  // 骸
	0x6D6C, KANJI_STANDARD,  // 浬
	0x99A8, KANJI_STANDARD,  // 馨
	0x86D9, KANJI_STANDARD,  // 蛙
	0x57A3, KANJI_STANDARD,  // 垣
	0x67FF, KANJI_STANDARD,  // 柿
	0x86CE, KANJI_STANDARD,  // 蛎
	0x920E, KANJI_STANDARD,  // 鈎
	0x5283, KANJI_STANDARD,  // 劃
	0x5687, KANJI_STANDARD,  // 嚇
	0x5404, KANJI_STANDARD,  // 各
	0x5ED3, KANJI_STANDARD,  // 廓
	0x62E1, KANJI_STANDARD,  // 拡
	0x64B9, KANJI_STANDARD,  // 撹
	0x683C, KANJI_STANDARD,  // 格
	0x6838, KANJI_STANDARD,  // 核
	0x6BBB, KANJI_STANDARD,  // 殻
	0x7372, KANJI_STANDARD,  // 獲
	0x78BA, KANJI_STANDARD,  // 確
	0x7A6B, KANJI_STANDARD,  // 穫
	0x899A, KANJI_STANDARD,  // 覚
	0x89D2, KANJI_STANDARD,  // 角
	0x8D6B, KANJI_STANDARD,  // 赫
	0x8F03, KANJI_STANDARD,  // 較
	0x90ED, KANJI_STANDARD,  // 郭
	0x95A3, KANJI_STANDARD,  // 閣
	0x9694, KANJI_STANDARD,  // 隔
	0x9769, KANJI_STANDARD,  // 革
	0x5B66, KANJI_STANDARD,  // 学
	0x5CB3, KANJI_STANDARD,  // 岳
	0x697D, KANJI_STANDARD,  // 楽
	0x984D, KANJI_STANDARD,  // 額
	0x984E, KANJI_STANDARD,  // 顎
	0x639B, KANJI_STANDARD,  // 掛
	0x7B20, KANJI_STANDARD,  // 笠
	0x6A2B, KANJI_STANDARD,  // 樫
	0x6A7F, KANJI_STANDARD,  // 橿
	0x68B6, KANJI_STANDARD,  // 梶
	0x9C0D, KANJI_STANDARD,  // 鰍
	0x6F5F, KANJI_STANDARD,  // 潟
	0x5272, KANJI_STANDARD,  // 割
	0x559D, KANJI_STANDARD,  // 喝
	0x6070, KANJI_STANDARD,  // 恰
	0x62EC, KANJI_STANDARD,  // 括
	0x6D3B, KANJI_STANDARD,  // 活
	0x6E07, KANJI_STANDARD,  // 渇
	0x6ED1, KANJI_STANDARD,  // 滑
	0x845B, KANJI_STANDARD,  // 葛
	0x8910, KANJI_STANDARD,  // 褐
	0x8F44, KANJI_STANDARD,  // 轄
	0x4E14, KANJI_STANDARD,  // 且
	0x9C39, KANJI_STANDARD,  // 鰹
	0x53F6, KANJI_STANDARD,  // 叶
	0x691B, KANJI_STANDARD,  // 椛
	0x6A3A, KANJI_STANDARD,  // 樺
	0x9784, KANJI_STANDARD,  // 鞄
	0x682A, KANJI_STANDARD,  // 株
	0x515C, KANJI_STANDARD,  // 兜
	0x7AC3, KANJI_STANDARD,  // 竃
	0x84B2, KANJI_STANDARD,  // 蒲
	0x91DC, KANJI_STANDARD,  // 釜
	0x938C, KANJI_STANDARD,  // 鎌
	0x565B, KANJI_STANDARD,  // 噛
	0x9D28, KANJI_STANDARD,  // 鴨
	0x6822, KANJI_STANDARD,  // 栢
	0x8305, KANJI_STANDARD,  // 茅
	0x8431, KANJI_STANDARD,  // 萱
	0x7CA5, KANJI_STANDARD,  // 粥
	0x5208, KANJI_STANDARD,  // 刈
	0x82C5, KANJI_STANDARD,  // 苅
	0x74E6, KANJI_STANDARD,  // 瓦
	0x4E7E, KANJI_STANDARD,  // 乾
	0x4F83, KANJI_STANDARD,  // 侃
	0x51A0, KANJI_STANDARD,  // 冠
	0x5BD2, KANJI_STANDARD,  // 寒
	0x520A, KANJI_STANDARD,  // 刊
	0x52D8, KANJI_STANDARD,  // 勘
	0x52E7, KANJI_STANDARD,  // 勧
	0x5DFB, KANJI_STANDARD,  // 巻
	0x559A, KANJI_STANDARD,  // 喚
	0x582A, KANJI_STANDARD,  // 堪
	0x59E6, KANJI_STANDARD,  // 姦
	0x5B8C, KANJI_STANDARD,  // 完
	0x5B98, KANJI_STANDARD,  // 官
	0x5BDB, KANJI_STANDARD,  // 寛
	0x5E72, KANJI_STANDARD,  // 干
	0x5E79, KANJI_STANDARD,  // 幹
	0x60A3, KANJI_STANDARD,  // 患
	0x611F, KANJI_STANDARD,  // 感
	0x6163, KANJI_STANDARD,  // 慣
	0x61BE, KANJI_STANDARD,  // 憾
	0x63DB, KANJI_STANDARD,  // 換
	0x6562, KANJI_STANDARD,  // 敢
	0x67D1, KANJI_STANDARD,  // 柑
	0x6853, KANJI_STANDARD,  // 桓
	0x68FA, KANJI_STANDARD,  // 棺
	0x6B3E, KANJI_STANDARD,  // 款
	0x6B53, KANJI_STANDARD,  // 歓
	0x6C57, KANJI_STANDARD,  // 汗
	0x6F22, KANJI_STANDARD,  // 漢
	0x6F97, KANJI_STANDARD,  // 澗
	0x6F45, KANJI_STANDARD,  // 潅
	0x74B0, KANJI_STANDARD,  // 環
	0x7518, KANJI_STANDARD,  // 甘
	0x76E3, KANJI_STANDARD,  // 監
	0x770B, KANJI_STANDARD,  // 看
	0x7AFF, KANJI_STANDARD,  // 竿
	0x7BA1, KANJI_STANDARD,  // 管
	0x7C21, KANJI_STANDARD,  // 簡
	0x7DE9, KANJI_STANDARD,  // 緩
	0x7F36, KANJI_STANDARD,  // 缶
	0x7FF0, KANJI_STANDARD,  // 翰
	0x809D, KANJI_STANDARD,  // 肝
	0x8266, KANJI_STANDARD,  // 艦
	0x839E, KANJI_STANDARD,  // 莞
	0x89B3, KANJI_STANDARD,  // 観
	0x8ACC, KANJI_STANDARD,  // 諌
	0x8CAB, KANJI_STANDARD,  // 貫
	0x9084, KANJI_STANDARD,  // 還
	0x9451, KANJI_STANDARD,  // 鑑
	0x9593, KANJI_STANDARD,  // 間
	0x9591, KANJI_STANDARD,  // 閑
	0x95A2, KANJI_STANDARD,  // 関
	0x9665, KANJI_STANDARD,  // 陥
	0x97D3, KANJI_STANDARD,  // 韓
	0x9928, KANJI_STANDARD,  // 館
	0x8218, KANJI_STANDARD,  // 舘
	0x4E38, KANJI_STANDARD,  // 丸
	0x542B, KANJI_STANDARD,  // 含
	0x5CB8, KANJI_STANDARD,  // 岸
	0x5DCC, KANJI_STANDARD,  // 巌
	0x73A9, KANJI_STANDARD,  // 玩
	0x764C, KANJI_STANDARD,  // 癌
	0x773C, KANJI_STANDARD,  // 眼
	0x5CA9, KANJI_STANDARD,  // 岩
	0x7FEB, KANJI_STANDARD,  // 翫
	0x8D0B, KANJI_STANDARD,  // 贋
	0x96C1, KANJI_STANDARD,  // 雁
	0x9811, KANJI_STANDARD,  // 頑
	0x9854, KANJI_STANDARD,  // 顔
	0x9858, KANJI_STANDARD,  // 願
	0x4F01, KANJI_STANDARD,  // 企
	0x4F0E, KANJI_STANDARD,  // 伎
	0x5371, KANJI_STANDARD,  // 危
	0x559C, KANJI_STANDARD,  // 喜
	0x5668, KANJI_STANDARD,  // 器
	0x57FA, KANJI_STANDARD,  // 基
	0x5947, KANJI_STANDARD,  // 奇
	0x5B09, KANJI_STANDARD,  // 嬉
	0x5BC4, KANJI_STANDARD,  // 寄
	0x5C90, KANJI_STANDARD,  // 岐
	0x5E0C, KANJI_STANDARD,  // 希
	0x5E7E, KANJI_STANDARD,  // 幾
	0x5FCC, KANJI_STANDARD,  // 忌
	0x63EE, KANJI_STANDARD,  // 揮
	0x673A, KANJI_STANDARD,  // 机
	0x65D7, KANJI_STANDARD,  // 旗
	0x65E2, KANJI_STANDARD,  // 既
	0x671F, KANJI_STANDARD,  // 期
	0x68CB, KANJI_STANDARD,  // 棋
	0x68C4, KANJI_STANDARD,  // 棄
	0x6A5F, KANJI_STANDARD,  // 機
	0x5E30, KANJI_STANDARD,  // 帰
	0x6BC5, KANJI_STANDARD,  // 毅
	0x6C17, KANJI_STANDARD,  // 気
	0x6C7D, KANJI_STANDARD,  // 汽
	0x757F, KANJI_STANDARD,  // 畿
	0x7948, KANJI_STANDARD,  // 祈
	0x5B63, KANJI_STANDARD,  // 季
	0x7A00, KANJI_STANDARD,  // 稀
	0x7D00, KANJI_STANDARD,  // 紀
	0x5FBD, KANJI_STANDARD,  // 徽
	0x898F, KANJI_STANDARD,  // 規
	0x8A18, KANJI_STANDARD,  // 記
	0x8CB4, KANJI_STANDARD,  // 貴
	0x8D77, KANJI_STANDARD,  // 起
	0x8ECC, KANJI_STANDARD,  // 軌
	0x8F1D, KANJI_STANDARD,  // 輝
	0x98E2, KANJI_STANDARD,  // 飢
	0x9A0E, KANJI_STANDARD,  // 騎
	0x9B3C, KANJI_STANDARD,  // 鬼
	0x4E80, KANJI_STANDARD,  // 亀
	0x507D, KANJI_STANDARD,  // 偽
	0x5100, KANJI_STANDARD,  // 儀
	0x5993, KANJI_STANDARD,  // 妓
	0x5B9C, KANJI_STANDARD,  // 宜
	0x622F, KANJI_STANDARD,  // 戯
	0x6280, KANJI_STANDARD,  // 技
	0x64EC, KANJI_STANDARD,  // 擬
	0x6B3A, KANJI_STANDARD,  // 欺
	0x72A0, KANJI_STANDARD,  // 犠
	0x7591, KANJI_STANDARD,  // 疑
	0x7947, KANJI_STANDARD,  // 祇
	0x7FA9, KANJI_STANDARD,  // 義
	0x87FB, KANJI_STANDARD,  // 蟻
	0x8ABC, KANJI_STANDARD,  // 誼
	0x8B70, KANJI_STANDARD,  // 議
	0x63AC, KANJI_STANDARD,  // 掬
	0x83CA, KANJI_STANDARD,  // 菊
	0x97A0, KANJI_STANDARD,  // 鞠
	0x5409, KANJI_STANDARD,  // 吉
	0x5403, KANJI_STANDARD,  // 吃
	0x55AB, KANJI_STANDARD,  // 喫
	0x6854, KANJI_STANDARD,  // 桔
	0x6A58, KANJI_STANDARD,  // 橘
	0x8A70, KANJI_STANDARD,  // 詰
	0x7827, KANJI_STANDARD,  // 砧
	0x6775, KANJI_STANDARD,  // 杵
	0x9ECD, KANJI_STANDARD,  // 黍
	0x5374, KANJI_STANDARD,  // 却
	0x5BA2, KANJI_STANDARD,  // 客
	0x811A, KANJI_STANDARD,  // 脚
	0x8650, KANJI_STANDARD,  // 虐
	0x9006, KANJI_STANDARD,  // 逆
	0x4E18, KANJI_STANDARD,  // 丘
	0x4E45, KANJI_STANDARD,  // 久
	0x4EC7, KANJI_STANDARD,  // 仇
	0x4F11, KANJI_STANDARD,  // 休
	0x53CA, KANJI_STANDARD,  // 及
	0x5438, KANJI_STANDARD,  // 吸
	0x5BAE, KANJI_STANDARD,  // 宮
	0x5F13, KANJI_STANDARD,  // 弓
	0x6025, KANJI_STANDARD,  // 急
	0x6551, KANJI_STANDARD,  // 救
	0x673D, KANJI_STANDARD,  // 朽
	0x6C42, KANJI_STANDARD,  // 求
	0x6C72, KANJI_STANDARD,  // 汲
	0x6CE3, KANJI_STANDARD,  // 泣
	0x7078, KANJI_STANDARD,  // 灸
	0x7403, KANJI_STANDARD,  // 球
	0x7A76, KANJI_STANDARD,  // 究
	0x7AAE, KANJI_STANDARD,  // 窮
	0x7B08, KANJI_STANDARD,  // 笈
	0x7D1A, KANJI_STANDARD,  // 級
	0x7CFE, KANJI_STANDARD,  // 糾
	0x7D66, KANJI_STANDARD,  // 給
	0x65E7, KANJI_STANDARD,  // 旧
	0x725B, KANJI_STANDARD,  // 牛
	0x53BB, KANJI_STANDARD,  // 去
	0x5C45, KANJI_STANDARD,  // 居
	0x5DE8, KANJI_STANDARD,  // 巨
	0x62D2, KANJI_STANDARD,  // 拒
	0x62E0, KANJI_STANDARD,  // 拠
	0x6319, KANJI_STANDARD,  // 挙
	0x6E20, KANJI_STANDARD,  // 渠
	0x865A, KANJI_STANDARD,  // 虚
	0x8A31, KANJI_STANDARD,  // 許
	0x8DDD, KANJI_STANDARD,  // 距
	0x92F8, KANJI_STANDARD,  // 鋸
	0x6F01, KANJI_STANDARD,  // 漁
	0x79A6, KANJI_STANDARD,  // 禦
	0x9B5A, KANJI_STANDARD,  // 魚
	0x4EA8, KANJI_STANDARD,  // 亨
	0x4EAB, KANJI_STANDARD,  // 享
	0x4EAC, KANJI_STANDARD,  // 京
	0x4F9B, KANJI_STANDARD,  // 供
	0x4FA0, KANJI_STANDARD,  // 侠
	0x50D1, KANJI_STANDARD,  // 僑
	0x5147, KANJI_STANDARD,  // 兇
	0x7AF6, KANJI_STANDARD,  // 競
	0x5171, KANJI_STANDARD,  // 共
	0x51F6, KANJI_STANDARD,  // 凶
	0x5354, KANJI_STANDARD,  // 協
	0x5321, KANJI_STANDARD,  // 匡
	0x537F, KANJI_STANDARD,  // 卿
	0x53EB, KANJI_STANDARD,  // 叫
	0x55AC, KANJI_STANDARD,  // 喬
	0x5883, KANJI_STANDARD,  // 境
	0x5CE1, KANJI_STANDARD,  // 峡
	0x5F37, KANJI_STANDARD,  // 強
	0x5F4A, KANJI_STANDARD,  // 彊
	0x602F, KANJI_STANDARD,  // 怯
	0x6050, KANJI_STANDARD,  // 恐
	0x606D, KANJI_STANDARD,  // 恭
	0x631F, KANJI_STANDARD,  // 挟
	0x6559, KANJI_STANDARD,  // 教
	0x6A4B, KANJI_STANDARD,  // 橋
	0x6CC1, KANJI_STANDARD,  // 況
	0x72C2, KANJI_STANDARD,  // 狂
	0x72ED, KANJI_STANDARD,  // 狭
	0x77EF, KANJI_STANDARD,  // 矯
	0x80F8, KANJI_STANDARD,  // 胸
	0x8105, KANJI_STANDARD,  // 脅
	0x8208, KANJI_STANDARD,  // 興
	0x854E, KANJI_STANDARD,  // 蕎
	0x90F7, KANJI_STANDARD,  // 郷
	0x93E1, KANJI_STANDARD,  // 鏡
	0x97FF, KANJI_STANDARD,  // 響
	0x9957, KANJI_STANDARD,  // 饗
	0x9A5A, KANJI_STANDARD,  // 驚
	0x4EF0, KANJI_STANDARD,  // 仰
	0x51DD, KANJI_STANDARD,  // 凝
	0x5C2D, KANJI_STANDARD,  // 尭
	0x6681, KANJI_STANDARD,  // 暁
	0x696D, KANJI_STANDARD,  // 業
	0x5C40, KANJI_STANDARD,  // 局
	0x66F2, KANJI_STANDARD,  // 曲
	0x6975, KANJI_STANDARD,  // 極
	0x7389, KANJI_STANDARD,  // 玉
	0x6850, KANJI_STANDARD,  // 桐
	0x7C81, KANJI_STANDARD,  // 粁
	0x50C5, KANJI_STANDARD,  // 僅
	0x52E4, KANJI_STANDARD,  // 勤
	0x5747, KANJI_STANDARD,  // 均
	0x5DFE, KANJI_STANDARD,  // 巾
	0x9326, KANJI_STANDARD,  // 錦
	0x65A4, KANJI_STANDARD,  // 斤
	0x6B23, KANJI_STANDARD,  // 欣
	0x6B3D, KANJI_STANDARD,  // 欽
	0x7434, KANJI_STANDARD,  // 琴
	0x7981, KANJI_STANDARD,  // 禁
	0x79BD, KANJI_STANDARD,  // 禽
	0x7B4B, KANJI_STANDARD,  // 筋
	0x7DCA, KANJI_STANDARD,  // 緊
	0x82B9, KANJI_STANDARD,  // 芹
	0x83CC, KANJI_STANDARD,  // 菌
	0x887F, KANJI_STANDARD,  // 衿
	0x895F, KANJI_STANDARD,  // 襟
	0x8B39, KANJI_STANDARD,  // 謹
	0x8FD1, KANJI_STANDARD,  // 近
	0x91D1, KANJI_STANDARD,  // 金
	0x541F, KANJI_STANDARD,  // 吟
	0x9280, KANJI_STANDARD,  // 銀
	0x4E5D, KANJI_STANDARD,  // 九
	0x5036, KANJI_STANDARD,  // 倶
	0x53E5, KANJI_STANDARD,  // 句
	0x533A, KANJI_STANDARD,  // 区
	0x72D7, KANJI_STANDARD,  // 狗
	0x7396, KANJI_STANDARD,  // 玖
	0x77E9, KANJI_STANDARD,  // 矩
	0x82E6, KANJI_STANDARD,  // 苦
	0x8EAF, KANJI_STANDARD,  // 躯
	0x99C6, KANJI_STANDARD,  // 駆
	0x99C8, KANJI_STANDARD,  // 駈
	0x99D2, KANJI_STANDARD,  // 駒
	0x5177, KANJI_STANDARD,  // 具
	0x611A, KANJI_STANDARD,  // 愚
	0x865E, KANJI_STANDARD,  // 虞
	0x55B0, KANJI_STANDARD,  // 喰
	0x7A7A, KANJI_STANDARD,  // 空
	0x5076, KANJI_STANDARD,  // 偶
	0x5BD3, KANJI_STANDARD,  // 寓
	0x9047, KANJI_STANDARD,  // 遇
	0x9685, KANJI_STANDARD,  // 隅
	0x4E32, KANJI_STANDARD,  // 串
	0x6ADB, KANJI_STANDARD,  // 櫛
	0x91E7, KANJI_STANDARD,  // 釧
	0x5C51, KANJI_STANDARD,  // 屑
	0x5C48, KANJI_STANDARD,  // 屈
	0x6398, KANJI_STANDARD,  // 掘
	0x7A9F, KANJI_STANDARD,  // 窟
	0x6C93, KANJI_STANDARD,  // 沓
	0x9774, KANJI_STANDARD,  // 靴
	0x8F61, KANJI_STANDARD,  // 轡
	0x7AAA, KANJI_STANDARD,  // 窪
	0x718A, KANJI_STANDARD,  // 熊
	0x9688, KANJI_STANDARD,  // 隈
	0x7C82, KANJI_STANDARD,  // 粂
	0x6817, KANJI_STANDARD,  // 栗
	0x7E70, KANJI_STANDARD,  // 繰
	0x6851, KANJI_STANDARD,  // 桑
	0x936C, KANJI_STANDARD,  // 鍬
	0x52F2, KANJI_STANDARD,  // 勲
	0x541B, KANJI_STANDARD,  // 君
	0x85AB, KANJI_STANDARD,  // 薫
	0x8A13, KANJI_STANDARD,  // 訓
	0x7FA4, KANJI_STANDARD,  // 群
	0x8ECD, KANJI_STANDARD,  // 軍
	0x90E1, KANJI_STANDARD,  // 郡
	0x5366, KANJI_STANDARD,  // 卦
	0x8888, KANJI_STANDARD,  // 袈
	0x7941, KANJI_STANDARD,  // 祁
	0x4FC2, KANJI_STANDARD,  // 係
	0x50BE, KANJI_STANDARD,  // 傾
	0x5211, KANJI_STANDARD,  // 刑
	0x5144, KANJI_STANDARD,  // 兄
	0x5553, KANJI_STANDARD,  // 啓
	0x572D, KANJI_STANDARD,  // 圭
	0x73EA, KANJI_STANDARD,  // 珪
	0x578B, KANJI_STANDARD,  // 型
	0x5951, KANJI_STANDARD,  // 契
	0x5F62, KANJI_STANDARD,  // 形
	0x5F84, KANJI_STANDARD,  // 径
	0x6075, KANJI_STANDARD,  // 恵
	0x6176, KANJI_STANDARD,  // 慶
	0x6167, KANJI_STANDARD,  // 慧
	0x61A9, KANJI_STANDARD,  // 憩
	0x63B2, KANJI_STANDARD,  // 掲
	0x643A, KANJI_STANDARD,  // 携
	0x656C, KANJI_STANDARD,  // 敬
	0x666F, KANJI_STANDARD,  // 景
	0x6842, KANJI_STANDARD,  // 桂
	0x6E13, KANJI_STANDARD,  // 渓
	0x7566, KANJI_STANDARD,  // 畦
	0x7A3D, KANJI_STANDARD,  // 稽
	0x7CFB, KANJI_STANDARD,  // 系
	0x7D4C, KANJI_STANDARD,  // 経
	0x7D99, KANJI_STANDARD,  // 継
	0x7E4B, KANJI_STANDARD,  // 繋
	0x7F6B, KANJI_STANDARD,  // 罫
	0x830E, KANJI_STANDARD,  // 茎
	0x834A, KANJI_STANDARD,  // 荊
	0x86CD, KANJI_STANDARD,  // 蛍
	0x8A08, KANJI_STANDARD,  // 計
	0x8A63, KANJI_STANDARD,  // 詣
	0x8B66, KANJI_STANDARD,  // 警
	0x8EFD, KANJI_STANDARD,  // 軽
	0x981A, KANJI_STANDARD,  // 頚
	0x9D8F, KANJI_STANDARD,  // 鶏
	0x82B8, KANJI_STANDARD,  // 芸
	0x8FCE, KANJI_STANDARD,  // 迎
	0x9BE8, KANJI_STANDARD,  // 鯨
	0x5287, KANJI_STANDARD,  // 劇
	0x621F, KANJI_STANDARD,  // 戟
	0x6483, KANJI_STANDARD,  // 撃
	0x6FC0, KANJI_STANDARD,  // 激
	0x9699, KANJI_STANDARD,  // 隙
	0x6841, KANJI_STANDARD,  // 桁
	0x5091, KANJI_STANDARD,  // 傑
	0x6B20, KANJI_STANDARD,  // 欠
	0x6C7A, KANJI_STANDARD,  // 決
	0x6F54, KANJI_STANDARD,  // 潔
	0x7A74, KANJI_STANDARD,  // 穴
	0x7D50, KANJI_STANDARD,  // 結
	0x8840, KANJI_STANDARD,  // 血
	0x8A23, KANJI_STANDARD,  // 訣
	0x6708, KANJI_STANDARD,  // 月
	0x4EF6, KANJI_STANDARD,  // 件
	0x5039, KANJI_STANDARD,  // 倹
	0x5026, KANJI_STANDARD,  // 倦
	0x5065, KANJI_STANDARD,  // 健
	0x517C, KANJI_STANDARD,  // 兼
	0x5238, KANJI_STANDARD,  // 券
	0x5263, KANJI_STANDARD,  // 剣
	0x55A7, KANJI_STANDARD,  // 喧
	0x570F, KANJI_STANDARD,  // 圏
	0x5805, KANJI_STANDARD,  // 堅
	0x5ACC, KANJI_STANDARD,  // 嫌
	0x5EFA, KANJI_STANDARD,  // 建
	0x61B2, KANJI_STANDARD,  // 憲
	0x61F8, KANJI_STANDARD,  // 懸
	0x62F3, KANJI_STANDARD,  // 拳
	0x6372, KANJI_STANDARD,  // 捲
	0x691C, KANJI_STANDARD,  // 検
	0x6A29, KANJI_STANDARD,  // 権
	0x727D, KANJI_STANDARD,  // 牽
	0x72AC, KANJI_STANDARD,  // 犬
	0x732E, KANJI_STANDARD,  // 献
	0x7814, KANJI_STANDARD,  // 研
	0x786F, KANJI_STANDARD,  // 硯
	0x7D79, KANJI_STANDARD,  // 絹
	0x770C, KANJI_STANDARD,  // 県
	0x80A9, KANJI_STANDARD,  // 肩
	0x898B, KANJI_STANDARD,  // 見
	0x8B19, KANJI_STANDARD,  // 謙
	0x8CE2, KANJI_STANDARD,  // 賢
	0x8ED2, KANJI_STANDARD,  // 軒
	0x9063, KANJI_STANDARD,  // 遣
	0x9375, KANJI_STANDARD,  // 鍵
	0x967A, KANJI_STANDARD,  // 険
	0x9855, KANJI_STANDARD,  // 顕
	0x9A13, KANJI_STANDARD,  // 験
	0x9E78, KANJI_STANDARD,  // 鹸
	0x5143, KANJI_STANDARD,  // 元
	0x539F, KANJI_STANDARD,  // 原
	0x53B3, KANJI_STANDARD,  // 厳
	0x5E7B, KANJI_STANDARD,  // 幻
	0x5F26, KANJI_STANDARD,  // 弦
	0x6E1B, KANJI_STANDARD,  // 減
	0x6E90, KANJI_STANDARD,  // 源
	0x7384, KANJI_STANDARD,  // 玄
	0x73FE, KANJI_STANDARD,  // 現
	0x7D43, KANJI_STANDARD,  // 絃
	0x8237, KANJI_STANDARD,  // 舷
	0x8A00, KANJI_STANDARD,  // 言
	0x8AFA, KANJI_STANDARD,  // 諺
	0x9650, KANJI_STANDARD,  // 限
	0x4E4E, KANJI_STANDARD,  // 乎
	0x500B, KANJI_STANDARD,  // 個
	0x53E4, KANJI_STANDARD,  // 古
	0x547C, KANJI_STANDARD,  // 呼
	0x56FA, KANJI_STANDARD,  // 固
	0x59D1, KANJI_STANDARD,  // 姑
	0x5B64, KANJI_STANDARD,  // 孤
	0x5DF1, KANJI_STANDARD,  // 己
	0x5EAB, KANJI_STANDARD,  // 庫
	0x5F27, KANJI_STANDARD,  // 弧
	0x6238, KANJI_STANDARD,  // 戸
	0x6545, KANJI_STANDARD,  // 故
	0x67AF, KANJI_STANDARD,  // 枯
	0x6E56, KANJI_STANDARD,  // 湖
	0x72D0, KANJI_STANDARD,  // 狐
	0x7CCA, KANJI_STANDARD,  // 糊
	0x88B4, KANJI_STANDARD,  // 袴
	0x80A1, KANJI_STANDARD,  // 股
	0x80E1, KANJI_STANDARD,  // 胡
	0x83F0, KANJI_STANDARD,  // 菰
	0x864E, KANJI_STANDARD,  // 虎
	0x8A87, KANJI_STANDARD,  // 誇
	0x8DE8, KANJI_STANDARD,  // 跨
	0x9237, KANJI_STANDARD,  // 鈷
	0x96C7, KANJI_STANDARD,  // 雇
	0x9867, KANJI_STANDARD,  // 顧
	0x9F13, KANJI_STANDARD,  // 鼓
	0x4E94, KANJI_STANDARD,  // 五
	0x4E92, KANJI_STANDARD,  // 互
	0x4F0D, KANJI_STANDARD,  // 伍
	0x5348, KANJI_STANDARD,  // 午
	0x5449, KANJI_STANDARD,  // 呉
	0x543E, KANJI_STANDARD,  // 吾
	0x5A2F, KANJI_STANDARD,  // 娯
	0x5F8C, KANJI_STANDARD,  // 後
	0x5FA1, KANJI_STANDARD,  // 御
	0x609F, KANJI_STANDARD,  // 悟
	0x68A7, KANJI_STANDARD,  // 梧
	0x6A8E, KANJI_STANDARD,  // 檎
	0x745A, KANJI_STANDARD,  // 瑚
	0x7881, KANJI_STANDARD,  // 碁
	0x8A9E, KANJI_STANDARD,  // 語
	0x8AA4, KANJI_STANDARD,  // 誤
	0x8B77, KANJI_STANDARD,  // 護
	0x9190, KANJI_STANDARD,  // 醐
	0x4E5E, KANJI_STANDARD,  // 乞
	0x9BC9, KANJI_STANDARD,  // 鯉
	0x4EA4, KANJI_STANDARD,  // 交
	0x4F7C, KANJI_STANDARD,  // 佼
	0x4FAF, KANJI_STANDARD,  // 侯
	0x5019, KANJI_STANDARD,  // 候
	0x5016, KANJI_STANDARD,  // 倖
	0x5149, KANJI_STANDARD,  // 光
	0x516C, KANJI_STANDARD,  // 公
	0x529F, KANJI_STANDARD,  // 功
	0x52B9, KANJI_STANDARD,  // 効
	0x52FE, KANJI_STANDARD,  // 勾
	0x539A, KANJI_STANDARD,  // 厚
	0x53E3, KANJI_STANDARD,  // 口
	0x5411, KANJI_STANDARD,  // 向
	0x540E, KANJI_STANDARD,  // 后
	0x5589, KANJI_STANDARD,  // 喉
	0x5751, KANJI_STANDARD,  // 坑
	0x57A2, KANJI_STANDARD,  // 垢
	0x597D, KANJI_STANDARD,  // 好
	0x5B54, KANJI_STANDARD,  // 孔
	0x5B5D, KANJI_STANDARD,  // 孝
	0x5B8F, KANJI_STANDARD,  // 宏
	0x5DE5, KANJI_STANDARD,  // 工
	0x5DE7, KANJI_STANDARD,  // 巧
	0x5DF7, KANJI_STANDARD,  // 巷
	0x5E78, KANJI_STANDARD,  // 幸
	0x5E83, KANJI_STANDARD,  // 広
	0x5E9A, KANJI_STANDARD,  // 庚
	0x5EB7, KANJI_STANDARD,  // 康
	0x5F18, KANJI_STANDARD,  // 弘
	0x6052, KANJI_STANDARD,  // 恒
	0x614C, KANJI_STANDARD,  // 慌
	0x6297, KANJI_STANDARD,  // 抗
	0x62D8, KANJI_STANDARD,  // 拘
	0x63A7, KANJI_STANDARD,  // 控
	0x653B, KANJI_STANDARD,  // 攻
	0x6602, KANJI_STANDARD,  // 昂
	0x6643, KANJI_STANDARD,  // 晃
	0x66F4, KANJI_STANDARD,  // 更
	0x676D, KANJI_STANDARD,  // 杭
	0x6821, KANJI_STANDARD,  // 校
	0x6897, KANJI_STANDARD,  // 梗
	0x69CB, KANJI_STANDARD,  // 構
	0x6C5F, KANJI_STANDARD,  // 江
	0x6D2A, KANJI_STANDARD,  // 洪
	0x6D69, KANJI_STANDARD,  // 浩
	0x6E2F, KANJI_STANDARD,  // 港
	0x6E9D, KANJI_STANDARD,  // 溝
	0x7532, KANJI_STANDARD,  // 甲
	0x7687, KANJI_STANDARD,  // 皇
	0x786C, KANJI_STANDARD,  // 硬
	0x7A3F, KANJI_STANDARD,  // 稿
	0x7CE0, KANJI_STANDARD,  // 糠
	0x7D05, KANJI_STANDARD,  // 紅
	0x7D18, KANJI_STANDARD,  // 紘
	0x7D5E, KANJI_STANDARD,  // 絞
	0x7DB1, KANJI_STANDARD,  // 綱
	0x8015, KANJI_STANDARD,  // 耕
	0x8003, KANJI_STANDARD,  // 考
	0x80AF, KANJI_STANDARD,  // 肯
	0x80B1, KANJI_STANDARD,  // 肱
	0x8154, KANJI_STANDARD,  // 腔
	0x818F, KANJI_STANDARD,  // 膏
	0x822A, KANJI_STANDARD,  // 航
	0x8352, KANJI_STANDARD,  // 荒
	0x884C, KANJI_STANDARD,  // 行
	0x8861, KANJI_STANDARD,  // 衡
	0x8B1B, KANJI_STANDARD,  // 講
	0x8CA2, KANJI_STANDARD,  // 貢
	0x8CFC, KANJI_STANDARD,  // 購
	0x90CA, KANJI_STANDARD,  // 郊
	0x9175, KANJI_STANDARD,  // 酵
	0x9271, KANJI_STANDARD,  // 鉱
	0x783F, KANJI_STANDARD,  // 砿
	0x92FC, KANJI_STANDARD,  // 鋼
	0x95A4, KANJI_STANDARD,  // 閤
	0x964D, KANJI_STANDARD,  // 降
	0x9805, KANJI_STANDARD,  // 項
	0x9999, KANJI_STANDARD,  // 香
	0x9AD8, KANJI_STANDARD,  // 高
	0x9D3B, KANJI_STANDARD,  // 鴻
	0x525B, KANJI_STANDARD,  // 剛
	0x52AB, KANJI_STANDARD,  // 劫
	0x53F7, KANJI_STANDARD,  // 号
	0x5408, KANJI_STANDARD,  // 合
	0x58D5, KANJI_STANDARD,  // 壕
	0x62F7, KANJI_STANDARD,  // 拷
	0x6FE0, KANJI_STANDARD,  // 濠
	0x8C6A, KANJI_STANDARD,  // 豪
	0x8F5F, KANJI_STANDARD,  // 轟
	0x9EB9, KANJI_STANDARD,  // 麹
	0x514B, KANJI_STANDARD,  // 克
	0x523B, KANJI_STANDARD,  // 刻
	0x544A, KANJI_STANDARD,  // 告
	0x56FD, KANJI_STANDARD,  // 国
	0x7A40, KANJI_STANDARD,  // 穀
	0x9177, KANJI_STANDARD,  // 酷
	0x9D60, KANJI_STANDARD,  // 鵠
	0x9ED2, KANJI_STANDARD,  // 黒
	0x7344, KANJI_STANDARD,  // 獄
	0x6F09, KANJI_STANDARD,  // 漉
	0x8170, KANJI_STANDARD,  // 腰
	0x7511, KANJI_STANDARD,  // 甑
	0x5FFD, KANJI_STANDARD,  // 忽
	0x60DA, KANJI_STANDARD,  // 惚
	0x9AA8, KANJI_STANDARD,  // 骨
	0x72DB, KANJI_STANDARD,  // 狛
	0x8FBC, KANJI_STANDARD,  // 込
	0x6B64, KANJI_STANDARD,  // 此
	0x9803, KANJI_STANDARD,  // 頃
	0x4ECA, KANJI_STANDARD,  // 今
	0x56F0, KANJI_STANDARD,  // 困
	0x5764, KANJI_STANDARD,  // 坤
	0x58BE, KANJI_STANDARD,  // 墾
	0x5A5A, KANJI_STANDARD,  // 婚
	0x6068, KANJI_STANDARD,  // 恨
	0x61C7, KANJI_STANDARD,  // 懇
	0x660F, KANJI_STANDARD,  // 昏
	0x6606, KANJI_STANDARD,  // 昆
	0x6839, KANJI_STANDARD,  // 根
	0x68B1, KANJI_STANDARD,  // 梱
	0x6DF7, KANJI_STANDARD,  // 混
	0x75D5, KANJI_STANDARD,  // 痕
	0x7D3A, KANJI_STANDARD,  // 紺
	0x826E, KANJI_STANDARD,  // 艮
	0x9B42, KANJI_STANDARD,  // 魂
	0x4E9B, KANJI_STANDARD,  // 些
	0x4F50, KANJI_STANDARD,  // 佐
	0x53C9, KANJI_STANDARD,  // 叉
	0x5506, KANJI_STANDARD,  // 唆
	0x5D6F, KANJI_STANDARD,  // 嵯
	0x5DE6, KANJI_STANDARD,  // 左
	0x5DEE, KANJI_STANDARD,  // 差
	0x67FB, KANJI_STANDARD,  // 査
	0x6C99, KANJI_STANDARD,  // 沙
	0x7473, KANJI_STANDARD,  // 瑳
	0x7802, KANJI_STANDARD,  // 砂
	0x8A50, KANJI_STANDARD,  // 詐
	0x9396, KANJI_STANDARD,  // 鎖
	0x88DF, KANJI_STANDARD,  // 裟
	0x5750, KANJI_STANDARD,  // 坐
	0x5EA7, KANJI_STANDARD,  // 座
	0x632B, KANJI_STANDARD,  // 挫
	0x50B5, KANJI_STANDARD,  // 債
	0x50AC, KANJI_STANDARD,  // 催
	0x518D, KANJI_STANDARD,  // 再
	0x6700, KANJI_STANDARD,  // 最
	0x54C9, KANJI_STANDARD,  // 哉
	0x585E, KANJI_STANDARD,  // 塞
	0x59BB, KANJI_STANDARD,  // 妻
	0x5BB0, KANJI_STANDARD,  // 宰
	0x5F69, KANJI_STANDARD,  // 彩
	0x624D, KANJI_STANDARD,  // 才
	0x63A1, KANJI_STANDARD,  // 採
	0x683D, KANJI_STANDARD,  // 栽
	0x6B73, KANJI_STANDARD,  // 歳
	0x6E08, KANJI_STANDARD,  // 済
	0x707D, KANJI_STANDARD,  // 災
	0x91C7, KANJI_STANDARD,  // 采
	0x7280, KANJI_STANDARD,  // 犀
	0x7815, KANJI_STANDARD,  // 砕
	0x7826, KANJI_STANDARD,  // 砦
	0x796D, KANJI_STANDARD,  // 祭
	0x658E, KANJI_STANDARD,  // 斎
	0x7D30, KANJI_STANDARD,  // 細
	0x83DC, KANJI_STANDARD,  // 菜
	0x88C1, KANJI_STANDARD,  // 裁
	0x8F09, KANJI_STANDARD,  // 載
	0x969B, KANJI_STANDARD,  // 際
	0x5264, KANJI_STANDARD,  // 剤
	0x5728, KANJI_STANDARD,  // 在
	0x6750, KANJI_STANDARD,  // 材
	0x7F6A, KANJI_STANDARD,  // 罪
	0x8CA1, KANJI_STANDARD,  // 財
	0x51B4, KANJI_STANDARD,  // 冴
	0x5742, KANJI_STANDARD,  // 坂
	0x962A, KANJI_STANDARD,  // 阪
	0x583A, KANJI_STANDARD,  // 堺
	0x698A, KANJI_STANDARD,  // 榊
	0x80B4, KANJI_STANDARD,  // 肴
	0x54B2, KANJI_STANDARD,  // 咲
	0x5D0E, KANJI_STANDARD,  // 崎
	0x57FC, KANJI_STANDARD,  // 埼
	0x7895, KANJI_STANDARD,  // 碕
	0x9DFA, KANJI_STANDARD,  // 鷺
	0x4F5C, KANJI_STANDARD,  // 作
	0x524A, KANJI_STANDARD,  // 削
	0x548B, KANJI_STANDARD,  // 咋
	0x643E, KANJI_STANDARD,  // 搾
	0x6628, KANJI_STANDARD,  // 昨
	0x6714, KANJI_STANDARD,  // 朔
	0x67F5, KANJI_STANDARD,  // 柵
	0x7A84, KANJI_STANDARD,  // 窄
	0x7B56, KANJI_STANDARD,  // 策
	0x7D22, KANJI_STANDARD,  // 索
	0x932F, KANJI_STANDARD,  // 錯
	0x685C, KANJI_STANDARD,  // 桜
	0x9BAD, KANJI_STANDARD,  // 鮭
	0x7B39, KANJI_STANDARD,  // 笹
	0x5319, KANJI_STANDARD,  // 匙
	0x518A, KANJI_STANDARD,  // 冊
	0x5237, KANJI_STANDARD,  // 刷
	0x5BDF, KANJI_STANDARD,  // 察
	0x62F6, KANJI_STANDARD,  // 拶
	0x64AE, KANJI_STANDARD,  // 撮
	0x64E6, KANJI_STANDARD,  // 擦
	0x672D, KANJI_STANDARD,  // 札
	0x6BBA, KANJI_STANDARD,  // 殺
	0x85A9, KANJI_STANDARD,  // 薩
	0x96D1, KANJI_STANDARD,  // 雑
	0x7690, KANJI_STANDARD,  // 皐
	0x9BD6, KANJI_STANDARD,  // 鯖
	0x634C, KANJI_STANDARD,  // 捌
	0x9306, KANJI_STANDARD,  // 錆
	0x9BAB, KANJI_STANDARD,  // 鮫
	0x76BF, KANJI_STANDARD,  // 皿
	0x6652, KANJI_STANDARD,  // 晒
	0x4E09, KANJI_STANDARD,  // 三
	0x5098, KANJI_STANDARD,  // 傘
	0x53C2, KANJI_STANDARD,  // 参
	0x5C71, KANJI_STANDARD,  // 山
	0x60E8, KANJI_STANDARD,  // 惨
	0x6492, KANJI_STANDARD,  // 撒
	0x6563, KANJI_STANDARD,  // 散
	0x685F, KANJI_STANDARD,  // 桟
	0x71E6, KANJI_STANDARD,  // 燦
	0x73CA, KANJI_STANDARD,  // 珊
	0x7523, KANJI_STANDARD,  // 産
	0x7B97, KANJI_STANDARD,  // 算
	0x7E82, KANJI_STANDARD,  // 纂
	0x8695, KANJI_STANDARD,  // 蚕
	0x8B83, KANJI_STANDARD,  // 讃
	0x8CDB, KANJI_STANDARD,  // 賛
	0x9178, KANJI_STANDARD,  // 酸
	0x9910, KANJI_STANDARD,  // 餐
	0x65AC, KANJI_STANDARD,  // 斬
	0x66AB, KANJI_STANDARD,  // 暫
	0x6B8B, KANJI_STANDARD,  // 残
	0x4ED5, KANJI_STANDARD,  // 仕
	0x4ED4, KANJI_STANDARD,  // 仔
	0x4F3A, KANJI_STANDARD,  // 伺
	0x4F7F, KANJI_STANDARD,  // 使
	0x523A, KANJI_STANDARD,  // 刺
	0x53F8, KANJI_STANDARD,  // 司
	0x53F2, KANJI_STANDARD,  // 史
	0x55E3, KANJI_STANDARD,  // 嗣
	0x56DB, KANJI_STANDARD,  // 四
	0x58EB, KANJI_STANDARD,  // 士
	0x59CB, KANJI_STANDARD,  // 始
	0x59C9, KANJI_STANDARD,  // 姉
	0x59FF, KANJI_STANDARD,  // 姿
	0x5B50, KANJI_STANDARD,  // 子
	0x5C4D, KANJI_STANDARD,  // 屍
	0x5E02, KANJI_STANDARD,  // 市
	0x5E2B, KANJI_STANDARD,  // 師
	0x5FD7, KANJI_STANDARD,  // 志
	0x601D, KANJI_STANDARD,  // 思
	0x6307, KANJI_STANDARD,  // 指
	0x652F, KANJI_STANDARD,  // 支
	0x5B5C, KANJI_STANDARD,  // 孜
	0x65AF, KANJI_STANDARD,  // 斯
	0x65BD, KANJI_STANDARD,  // 施
	0x65E8, KANJI_STANDARD,  // 旨
	0x679D, KANJI_STANDARD,  // 枝
	0x6B62, KANJI_STANDARD,  // 止
	0x6B7B, KANJI_STANDARD,  // 死
	0x6C0F, KANJI_STANDARD,  // 氏
	0x7345, KANJI_STANDARD,  // 獅
	0x7949, KANJI_STANDARD,  // 祉
	0x79C1, KANJI_STANDARD,  // 私
	0x7CF8, KANJI_STANDARD,  // 糸
	0x7D19, KANJI_STANDARD,  // 紙
	0x7D2B, KANJI_STANDARD,  // 紫
	0x80A2, KANJI_STANDARD,  // 肢
	0x8102, KANJI_STANDARD,  // 脂
	0x81F3, KANJI_STANDARD,  // 至
	0x8996, KANJI_STANDARD,  // 視
	0x8A5E, KANJI_STANDARD,  // 詞
	0x8A69, KANJI_STANDARD,  // 詩
	0x8A66, KANJI_STANDARD,  // 試
	0x8A8C, KANJI_STANDARD,  // 誌
	0x8AEE, KANJI_STANDARD,  // 諮
	0x8CC7, KANJI_STANDARD,  // 資
	0x8CDC, KANJI_STANDARD,  // 賜
	0x96CC, KANJI_STANDARD,  // 雌
	0x98FC, KANJI_STANDARD,  // 飼
	0x6B6F, KANJI_STANDARD,  // 歯
	0x4E8B, KANJI_STANDARD,  // 事
	0x4F3C, KANJI_STANDARD,  // 似
	0x4F8D, KANJI_STANDARD,  // 侍
	0x5150, KANJI_STANDARD,  // 児
	0x5B57, KANJI_STANDARD,  // 字
	0x5BFA, KANJI_STANDARD,  // 寺
	0x6148, KANJI_STANDARD,  // 慈
	0x6301, KANJI_STANDARD,  // 持
	0x6642, KANJI_STANDARD,  // 時
	0x6B21, KANJI_STANDARD,  // 次
	0x6ECB, KANJI_STANDARD,  // 滋
	0x6CBB, KANJI_STANDARD,  // 治
	0x723E, KANJI_STANDARD,  // 爾
	0x74BD, KANJI_STANDARD,  // 璽
	0x75D4, KANJI_STANDARD,  // 痔
	0x78C1, KANJI_STANDARD,  // 磁
	0x793A, KANJI_STANDARD,  // 示
	0x800C, KANJI_STANDARD,  // 而
	0x8033, KANJI_STANDARD,  // 耳
	0x81EA, KANJI_STANDARD,  // 自
	0x8494, KANJI_STANDARD,  // 蒔
	0x8F9E, KANJI_STANDARD,  // 辞
	0x6C50, KANJI_STANDARD,  // 汐
	0x9E7F, KANJI_STANDARD,  // 鹿
	0x5F0F, KANJI_STANDARD,  // 式
	0x8B58, KANJI_STANDARD,  // 識
	0x9D2B, KANJI_STANDARD,  // 鴫
	0x7AFA, KANJI_STANDARD,  // 竺
	0x8EF8, KANJI_STANDARD,  // 軸
	0x5B8D, KANJI_STANDARD,  // 宍
	0x96EB, KANJI_STANDARD,  // 雫
	0x4E03, KANJI_STANDARD,  // 七
	0x53F1, KANJI_STANDARD,  // 叱
	0x57F7, KANJI_STANDARD,  // 執
	0x5931, KANJI_STANDARD,  // 失
	0x5AC9, KANJI_STANDARD,  // 嫉
	0x5BA4, KANJI_STANDARD,  // 室
	0x6089, KANJI_STANDARD,  // 悉
	0x6E7F, KANJI_STANDARD,  // 湿
	0x6F06, KANJI_STANDARD,  // 漆
	0x75BE, KANJI_STANDARD,  // 疾
	0x8CEA, KANJI_STANDARD,  // 質
	0x5B9F, KANJI_STANDARD,  // 実
	0x8500, KANJI_STANDARD,  // 蔀
	0x7BE0, KANJI_STANDARD,  // 篠
	0x5072, KANJI_STANDARD,  // 偲
	0x67F4, KANJI_STANDARD,  // 柴
	0x829D, KANJI_STANDARD,  // 芝
	0x5C61, KANJI_STANDARD,  // 屡
	0x854A, KANJI_STANDARD,  // 蕊
	0x7E1E, KANJI_STANDARD,  // 縞
	0x820E, KANJI_STANDARD,  // 舎
	0x5199, KANJI_STANDARD,  // 写
	0x5C04, KANJI_STANDARD,  // 射
	0x6368, KANJI_STANDARD,  // 捨
	0x8D66, KANJI_STANDARD,  // 赦
	0x659C, KANJI_STANDARD,  // 斜
	0x716E, KANJI_STANDARD,  // 煮
	0x793E, KANJI_STANDARD,  // 社
	0x7D17, KANJI_STANDARD,  // 紗
	0x8005, KANJI_STANDARD,  // 者
	0x8B1D, KANJI_STANDARD,  // 謝
	0x8ECA, KANJI_STANDARD,  // 車
	0x906E, KANJI_STANDARD,  // 遮
	0x86C7, KANJI_STANDARD,  // 蛇
	0x90AA, KANJI_STANDARD,  // 邪
	0x501F, KANJI_STANDARD,  // 借
	0x52FA, KANJI_STANDARD,  // 勺
	0x5C3A, KANJI_STANDARD,  // 尺
	0x6753, KANJI_STANDARD,  // 杓
	0x707C, KANJI_STANDARD,  // 灼
	0x7235, KANJI_STANDARD,  // 爵
	0x914C, KANJI_STANDARD,  // 酌
	0x91C8, KANJI_STANDARD,  // 釈
	0x932B, KANJI_STANDARD,  // 錫
	0x82E5, KANJI_STANDARD,  // 若
	0x5BC2, KANJI_STANDARD,  // 寂
	0x5F31, KANJI_STANDARD,  // 弱
	0x60F9, KANJI_STANDARD,  // 惹
	0x4E3B, KANJI_STANDARD,  // 主
	0x53D6, KANJI_STANDARD,  // 取
	0x5B88, KANJI_STANDARD,  // 守
	0x624B, KANJI_STANDARD,  // 手
	0x6731, KANJI_STANDARD,  // 朱
	0x6B8A, KANJI_STANDARD,  // 殊
	0x72E9, KANJI_STANDARD,  // 狩
	0x73E0, KANJI_STANDARD,  // 珠
	0x7A2E, KANJI_STANDARD,  // 種
	0x816B, KANJI_STANDARD,  // 腫
	0x8DA3, KANJI_STANDARD,  // 趣
	0x9152, KANJI_STANDARD,  // 酒
	0x9996, KANJI_STANDARD,  // 首
	0x5112, KANJI_STANDARD,  // 儒
	0x53D7, KANJI_STANDARD,  // 受
	0x546A, KANJI_STANDARD,  // 呪
	0x5BFF, KANJI_STANDARD,  // 寿
	0x6388, KANJI_STANDARD,  // 授
	0x6A39, KANJI_STANDARD,  // 樹
	0x7DAC, KANJI_STANDARD,  // 綬
	0x9700, KANJI_STANDARD,  // 需
	0x56DA, KANJI_STANDARD,  // 囚
	0x53CE, KANJI_STANDARD,  // 収
	0x5468, KANJI_STANDARD,  // 周
	0x5B97, KANJI_STANDARD,  // 宗
	0x5C31, KANJI_STANDARD,  // 就
	0x5DDE, KANJI_STANDARD,  // 州
	0x4FEE, KANJI_STANDARD,  // 修
	0x6101, KANJI_STANDARD,  // 愁
	0x62FE, KANJI_STANDARD,  // 拾
	0x6D32, KANJI_STANDARD,  // 洲
	0x79C0, KANJI_STANDARD,  // 秀
	0x79CB, KANJI_STANDARD,  // 秋
	0x7D42, KANJI_STANDARD,  // 終
	0x7E4D, KANJI_STANDARD,  // 繍
	0x7FD2, KANJI_STANDARD,  // 習
	0x81ED, KANJI_STANDARD,  // 臭
	0x821F, KANJI_STANDARD,  // 舟
	0x8490, KANJI_STANDARD,  // 蒐
	0x8846, KANJI_STANDARD,  // 衆
	0x8972, KANJI_STANDARD,  // 襲
	0x8B90, KANJI_STANDARD,  // 讐
	0x8E74, KANJI_STANDARD,  // 蹴
	0x8F2F, KANJI_STANDARD,  // 輯
	0x9031, KANJI_STANDARD,  // 週
	0x914B, KANJI_STANDARD,  // 酋
	0x916C, KANJI_STANDARD,  // 酬
	0x96C6, KANJI_STANDARD,  // 集
	0x919C, KANJI_STANDARD,  // 醜
	0x4EC0, KANJI_STANDARD,  // 什
	0x4F4F, KANJI_STANDARD,  // 住
	0x5145, KANJI_STANDARD,  // 充
	0x5341, KANJI_STANDARD,  // 十
	0x5F93, KANJI_STANDARD,  // 従
	0x620E, KANJI_STANDARD,  // 戎
	0x67D4, KANJI_STANDARD,  // 柔
	0x6C41, KANJI_STANDARD,  // 汁
	0x6E0B, KANJI_STANDARD,  // 渋
	0x7363, KANJI_STANDARD,  // 獣
	0x7E26, KANJI_STANDARD,  // 縦
	0x91CD, KANJI_STANDARD,  // 重
	0x9283, KANJI_STANDARD,  // 銃
	0x53D4, KANJI_STANDARD,  // 叔
	0x5919, KANJI_STANDARD,  // 夙
	0x5BBF, KANJI_STANDARD,  // 宿
	0x6DD1, KANJI_STANDARD,  // 淑
	0x795D, KANJI_STANDARD,  // 祝
	0x7E2E, KANJI_STANDARD,  // 縮
	0x7C9B, KANJI_STANDARD,  // 粛
	0x587E, KANJI_STANDARD,  // 塾
	0x719F, KANJI_STANDARD,  // 熟
	0x51FA, KANJI_STANDARD,  // 出
	0x8853, KANJI_STANDARD,  // 術
	0x8FF0, KANJI_STANDARD,  // 述
	0x4FCA, KANJI_STANDARD,  // 俊
	0x5CFB, KANJI_STANDARD,  // 峻
	0x6625, KANJI_STANDARD,  // 春
	0x77AC, KANJI_STANDARD,  // 瞬
	0x7AE3, KANJI_STANDARD,  // 竣
	0x821C, KANJI_STANDARD,  // 舜
	0x99FF, KANJI_STANDARD,  // 駿
	0x51C6, KANJI_STANDARD,  // 准
	0x5FAA, KANJI_STANDARD,  // 循
	0x65EC, KANJI_STANDARD,  // 旬
	0x696F, KANJI_STANDARD,  // 楯
	0x6B89, KANJI_STANDARD,  // 殉
	0x6DF3, KANJI_STANDARD,  // 淳
	0x6E96, KANJI_STANDARD,  // 準
	0x6F64, KANJI_STANDARD,  // 潤
	0x76FE, KANJI_STANDARD,  // 盾
	0x7D14, KANJI_STANDARD,  // 純
	0x5DE1, KANJI_STANDARD,  // 巡
	0x9075, KANJI_STANDARD,  // 遵
	0x9187, KANJI_STANDARD,  // 醇
	0x9806, KANJI_STANDARD,  // 順
	0x51E6, KANJI_STANDARD,  // 処
	0x521D, KANJI_STANDARD,  // 初
	0x6240, KANJI_STANDARD,  // 所
	0x6691, KANJI_STANDARD,  // 暑
	0x66D9, KANJI_STANDARD,  // 曙
	0x6E1A, KANJI_STANDARD,  // 渚
	0x5EB6, KANJI_STANDARD,  // 庶
	0x7DD2, KANJI_STANDARD,  // 緒
	0x7F72, KANJI_STANDARD,  // 署
	0x66F8, KANJI_STANDARD,  // 書
	0x85AF, KANJI_STANDARD,  // 薯
	0x85F7, KANJI_STANDARD,  // 藷
	0x8AF8, KANJI_STANDARD,  // 諸
	0x52A9, KANJI_STANDARD,  // 助
	0x53D9, KANJI_STANDARD,  // 叙
	0x5973, KANJI_STANDARD,  // 女
	0x5E8F, KANJI_STANDARD,  // 序
	0x5F90, KANJI_STANDARD,  // 徐
	0x6055, KANJI_STANDARD,  // 恕
	0x92E4, KANJI_STANDARD,  // 鋤
	0x9664, KANJI_STANDARD,  // 除
	0x50B7, KANJI_STANDARD,  // 傷
	0x511F, KANJI_STANDARD,  // 償
	0x52DD, KANJI_STANDARD,  // 勝
	0x5320, KANJI_STANDARD,  // 匠
	0x5347, KANJI_STANDARD,  // 升
	0x53EC, KANJI_STANDARD,  // 召
	0x54E8, KANJI_STANDARD,  // 哨
	0x5546, KANJI_STANDARD,  // 商
	0x5531, KANJI_STANDARD,  // 唱
	0x5617, KANJI_STANDARD,  // 嘗
	0x5968, KANJI_STANDARD,  // 奨
	0x59BE, KANJI_STANDARD,  // 妾
	0x5A3C, KANJI_STANDARD,  // 娼
	0x5BB5, KANJI_STANDARD,  // 宵
	0x5C06, KANJI_STANDARD,  // 将
	0x5C0F, KANJI_STANDARD,  // 小
	0x5C11, KANJI_STANDARD,  // 少
	0x5C1A, KANJI_STANDARD,  // 尚
	0x5E84, KANJI_STANDARD,  // 庄
	0x5E8A, KANJI_STANDARD,  // 床
	0x5EE0, KANJI_STANDARD,  // 廠
	0x5F70, KANJI_STANDARD,  // 彰
	0x627F, KANJI_STANDARD,  // 承
	0x6284, KANJI_STANDARD,  // 抄
	0x62DB, KANJI_STANDARD,  // 招
	0x638C, KANJI_STANDARD,  // 掌
	0x6377, KANJI_STANDARD,  // 捷
	0x6607, KANJI_STANDARD,  // 昇
	0x660C, KANJI_STANDARD,  // 昌
	0x662D, KANJI_STANDARD,  // 昭
	0x6676, KANJI_STANDARD,  // 晶
	0x677E, KANJI_STANDARD,  // 松
	0x68A2, KANJI_STANDARD,  // 梢
	0x6A1F, KANJI_STANDARD,  // 樟
	0x6A35, KANJI_STANDARD,  // 樵
	0x6CBC, KANJI_STANDARD,  // 沼
	0x6D88, KANJI_STANDARD,  // 消
	0x6E09, KANJI_STANDARD,  // 渉
	0x6E58, KANJI_STANDARD,  // 湘
	0x713C, KANJI_STANDARD,  // 焼
	0x7126, KANJI_STANDARD,  // 焦
	0x7167, KANJI_STANDARD,  // 照
	0x75C7, KANJI_STANDARD,  // 症
	0x7701, KANJI_STANDARD,  // 省
	0x785D, KANJI_STANDARD,  // 硝
	0x7901, KANJI_STANDARD,  // 礁
	0x7965, KANJI_STANDARD,  // 祥
	0x79F0, KANJI_STANDARD,  // 称
	0x7AE0, KANJI_STANDARD,  // 章
	0x7B11, KANJI_STANDARD,  // 笑
	0x7CA7, KANJI_STANDARD,  // 粧
	0x7D39, KANJI_STANDARD,  // 紹
	0x8096, KANJI_STANDARD,  // 肖
	0x83D6, KANJI_STANDARD,  // 菖
	0x848B, KANJI_STANDARD,  // 蒋
	0x8549, KANJI_STANDARD,  // 蕉
	0x885D, KANJI_STANDARD,  // 衝
	0x88F3, KANJI_STANDARD,  // 裳
	0x8A1F, KANJI_STANDARD,  // 訟
	0x8A3C, KANJI_STANDARD,  // 証
	0x8A54, KANJI_STANDARD,  // 詔
	0x8A73, KANJI_STANDARD,  // 詳
	0x8C61, KANJI_STANDARD,  // 象
	0x8CDE, KANJI_STANDARD,  // 賞
	0x91A4, KANJI_STANDARD,  // 醤
	0x9266, KANJI_STANDARD,  // 鉦
	0x937E, KANJI_STANDARD,  // 鍾
	0x9418, KANJI_STANDARD,  // 鐘
	0x969C, KANJI_STANDARD,  // 障
	0x9798, KANJI_STANDARD,  // 鞘
	0x4E0A, KANJI_STANDARD,  // 上
	0x4E08, KANJI_STANDARD,  // 丈
	0x4E1E, KANJI_STANDARD,  // 丞
	0x4E57, KANJI_STANDARD,  // 乗
	0x5197, KANJI_STANDARD,  // 冗
	0x5270, KANJI_STANDARD,  // 剰
	0x57CE, KANJI_STANDARD,  // 城
	0x5834, KANJI_STANDARD,  // 場
	0x58CC, KANJI_STANDARD,  // 壌
	0x5B22, KANJI_STANDARD,  // 嬢
	0x5E38, KANJI_STANDARD,  // 常
	0x60C5, KANJI_STANDARD,  // 情
	0x64FE, KANJI_STANDARD,  // 擾
	0x6761, KANJI_STANDARD,  // 条
	0x6756, KANJI_STANDARD,  // 杖
	0x6D44, KANJI_STANDARD,  // 浄
	0x72B6, KANJI_STANDARD,  // 状
	0x7573, KANJI_STANDARD,  // 畳
	0x7A63, KANJI_STANDARD,  // 穣
	0x84B8, KANJI_STANDARD,  // 蒸
	0x8B72, KANJI_STANDARD,  // 譲
	0x91B8, KANJI_STANDARD,  // 醸
	0x9320, KANJI_STANDARD,  // 錠
	0x5631, KANJI_STANDARD,  // 嘱
	0x57F4, KANJI_STANDARD,  // 埴
	0x98FE, KANJI_STANDARD,  // 飾
	0x62ED, KANJI_STANDARD,  // 拭
	0x690D, KANJI_STANDARD,  // 植
	0x6B96, KANJI_STANDARD,  // 殖
	0x71ED, KANJI_STANDARD,  // 燭
	0x7E54, KANJI_STANDARD,  // 織
	0x8077, KANJI_STANDARD,  // 職
	0x8272, KANJI_STANDARD,  // 色
	0x89E6, KANJI_STANDARD,  // 触
	0x98DF, KANJI_STANDARD,  // 食
	0x8755, KANJI_STANDARD,  // 蝕
	0x8FB1, KANJI_STANDARD,  // 辱
	0x5C3B, KANJI_STANDARD,  // 尻
	0x4F38, KANJI_STANDARD,  // 伸
	0x4FE1, KANJI_STANDARD,  // 信
	0x4FB5, KANJI_STANDARD,  // 侵
	0x5507, KANJI_STANDARD,  // 唇
	0x5A20, KANJI_STANDARD,  // 娠
	0x5BDD, KANJI_STANDARD,  // 寝
	0x5BE9, KANJI_STANDARD,  // 審
	0x5FC3, KANJI_STANDARD,  // 心
	0x614E, KANJI_STANDARD,  // 慎
	0x632F, KANJI_STANDARD,  // 振
	0x65B0, KANJI_STANDARD,  // 新
	0x664B, KANJI_STANDARD,  // 晋
	0x68EE, KANJI_STANDARD,  // 森
	0x699B, KANJI_STANDARD,  // 榛
	0x6D78, KANJI_STANDARD,  // 浸
	0x6DF1, KANJI_STANDARD,  // 深
	0x7533, KANJI_STANDARD,  // 申
	0x75B9, KANJI_STANDARD,  // 疹
	0x771F, KANJI_STANDARD,  // 真
	0x795E, KANJI_STANDARD,  // 神
	0x79E6, KANJI_STANDARD,  // 秦
	0x7D33, KANJI_STANDARD,  // 紳
	0x81E3, KANJI_STANDARD,  // 臣
	0x82AF, KANJI_STANDARD,  // 芯
	0x85AA, KANJI_STANDARD,  // 薪
	0x89AA, KANJI_STANDARD,  // 親
	0x8A3A, KANJI_STANDARD,  // 診
	0x8EAB, KANJI_STANDARD,  // 身
	0x8F9B, KANJI_STANDARD,  // 辛
	0x9032, KANJI_STANDARD,  // 進
	0x91DD, KANJI_STANDARD,  // 針
	0x9707, KANJI_STANDARD,  // 震
	0x4EBA, KANJI_STANDARD,  // 人
	0x4EC1, KANJI_STANDARD,  // 仁
	0x5203, KANJI_STANDARD,  // 刃
	0x5875, KANJI_STANDARD,  // 塵
	0x58EC, KANJI_STANDARD,  // 壬
	0x5C0B, KANJI_STANDARD,  // 尋
	0x751A, KANJI_STANDARD,  // 甚
	0x5C3D, KANJI_STANDARD,  // 尽
	0x814E, KANJI_STANDARD,  // 腎
	0x8A0A, KANJI_STANDARD,  // 訊
	0x8FC5, KANJI_STANDARD,  // 迅
	0x9663, KANJI_STANDARD,  // 陣
	0x976D, KANJI_STANDARD,  // 靭
	0x7B25, KANJI_STANDARD,  // 笥
	0x8ACF, KANJI_STANDARD,  // 諏
	0x9808, KANJI_STANDARD,  // 須
	0x9162, KANJI_STANDARD,  // 酢
	0x56F3, KANJI_STANDARD,  // 図
	0x53A8, KANJI_STANDARD,  // 厨
	0x9017, KANJI_STANDARD,  // 逗
	0x5439, KANJI_STANDARD,  // 吹
	0x5782, KANJI_STANDARD,  // 垂
	0x5E25, KANJI_STANDARD,  // 帥
	0x63A8, KANJI_STANDARD,  // 推
	0x6C34, KANJI_STANDARD,  // 水
	0x708A, KANJI_STANDARD,  // 炊
	0x7761, KANJI_STANDARD,  // 睡
	0x7C8B, KANJI_STANDARD,  // 粋
	0x7FE0, KANJI_STANDARD,  // 翠
	0x8870, KANJI_STANDARD,  // 衰
	0x9042, KANJI_STANDARD,  // 遂
	0x9154, KANJI_STANDARD,  // 酔
	0x9310, KANJI_STANDARD,  // 錐
	0x9318, KANJI_STANDARD,  // 錘
	0x968F, KANJI_STANDARD,  // 随
	0x745E, KANJI_STANDARD,  // 瑞
	0x9AC4, KANJI_STANDARD,  // 髄
	0x5D07, KANJI_STANDARD,  // 崇
	0x5D69, KANJI_STANDARD,  // 嵩
	0x6570, KANJI_STANDARD,  // 数
	0x67A2, KANJI_STANDARD,  // 枢
	0x8DA8, KANJI_STANDARD,  // 趨
	0x96DB, KANJI_STANDARD,  // 雛
	0x636E, KANJI_STANDARD,  // 据
	0x6749, KANJI_STANDARD,  // 杉
	0x6919, KANJI_STANDARD,  // 椙
	0x83C5, KANJI_STANDARD,  // 菅
	0x9817, KANJI_STANDARD,  // 頗
	0x96C0, KANJI_STANDARD,  // 雀
	0x88FE, KANJI_STANDARD,  // 裾
	0x6F84, KANJI_STANDARD,  // 澄
	0x647A, KANJI_STANDARD,  // 摺
	0x5BF8, KANJI_STANDARD,  // 寸
	0x4E16, KANJI_STANDARD,  // 世
	0x702C, KANJI_STANDARD,  // 瀬
	0x755D, KANJI_STANDARD,  // 畝
	0x662F, KANJI_STANDARD,  // 是
	0x51C4, KANJI_STANDARD,  // 凄
	0x5236, KANJI_STANDARD,  // 制
	0x52E2, KANJI_STANDARD,  // 勢
	0x59D3, KANJI_STANDARD,  // 姓
	0x5F81, KANJI_STANDARD,  // 征
	0x6027, KANJI_STANDARD,  // 性
	0x6210, KANJI_STANDARD,  // 成
	0x653F, KANJI_STANDARD,  // 政
	0x6574, KANJI_STANDARD,  // 整
	0x661F, KANJI_STANDARD,  // 星
	0x6674, KANJI_STANDARD,  // 晴
	0x68F2, KANJI_STANDARD,  // 棲
	0x6816, KANJI_STANDARD,  // 栖
	0x6B63, KANJI_STANDARD,  // 正
	0x6E05, KANJI_STANDARD,  // 清
	0x7272, KANJI_STANDARD,  // 牲
	0x751F, KANJI_STANDARD,  // 生
	0x76DB, KANJI_STANDARD,  // 盛
	0x7CBE, KANJI_STANDARD,  // 精
	0x8056, KANJI_STANDARD,  // 聖
	0x58F0, KANJI_STANDARD,  // 声
	0x88FD, KANJI_STANDARD,  // 製
	0x897F, KANJI_STANDARD,  // 西
	0x8AA0, KANJI_STANDARD,  // 誠
	0x8A93, KANJI_STANDARD,  // 誓
	0x8ACB, KANJI_STANDARD,  // 請
	0x901D, KANJI_STANDARD,  // 逝
	0x9192, KANJI_STANDARD,  // 醒
	0x9752, KANJI_STANDARD,  // 青
	0x9759, KANJI_STANDARD,  // 静
	0x6589, KANJI_STANDARD,  // 斉
	0x7A0E, KANJI_STANDARD,  // 税
	0x8106, KANJI_STANDARD,  // 脆
	0x96BB, KANJI_STANDARD,  // 隻
	0x5E2D, KANJI_STANDARD,  // 席
	0x60DC, KANJI_STANDARD,  // 惜
	0x621A, KANJI_STANDARD,  // 戚
	0x65A5, KANJI_STANDARD,  // 斥
	0x6614, KANJI_STANDARD,  // 昔
	0x6790, KANJI_STANDARD,  // 析
	0x77F3, KANJI_STANDARD,  // 石
	0x7A4D, KANJI_STANDARD,  // 積
	0x7C4D, KANJI_STANDARD,  // 籍
	0x7E3E, KANJI_STANDARD,  // 績
	0x810A, KANJI_STANDARD,  // 脊
	0x8CAC, KANJI_STANDARD,  // 責
	0x8D64, KANJI_STANDARD,  // 赤
	0x8DE1, KANJI_STANDARD,  // 跡
	0x8E5F, KANJI_STANDARD,  // 蹟
	0x78A9, KANJI_STANDARD,  // 碩
	0x5207, KANJI_STANDARD,  // 切
	0x62D9, KANJI_STANDARD,  // 拙
	0x63A5, KANJI_STANDARD,  // 接
	0x6442, KANJI_STANDARD,  // 摂
	0x6298, KANJI_STANDARD,  // 折
	0x8A2D, KANJI_STANDARD,  // 設
	0x7A83, KANJI_STANDARD,  // 窃
	0x7BC0, KANJI_STANDARD,  // 節
	0x8AAC, KANJI_STANDARD,  // 説
	0x96EA, KANJI_STANDARD,  // 雪
	0x7D76, KANJI_STANDARD,  // 絶
	0x820C, KANJI_STANDARD,  // 舌
	0x8749, KANJI_STANDARD,  // 蝉
	0x4ED9, KANJI_STANDARD,  // 仙
	0x5148, KANJI_STANDARD,  // 先
	0x5343, KANJI_STANDARD,  // 千
	0x5360, KANJI_STANDARD,  // 占
	0x5BA3, KANJI_STANDARD,  // 宣
	0x5C02, KANJI_STANDARD,  // 専
	0x5C16, KANJI_STANDARD,  // 尖
	0x5DDD, KANJI_STANDARD,  // 川
	0x6226, KANJI_STANDARD,  // 戦
	0x6247, KANJI_STANDARD,  // 扇
	0x64B0, KANJI_STANDARD,  // 撰
	0x6813, KANJI_STANDARD,  // 栓
	0x6834, KANJI_STANDARD,  // 栴
	0x6CC9, KANJI_STANDARD,  // 泉
	0x6D45, KANJI_STANDARD,  // 浅
	0x6D17, KANJI_STANDARD,  // 洗
	0x67D3, KANJI_STANDARD,  // 染
	0x6F5C, KANJI_STANDARD,  // 潜
	0x714E, KANJI_STANDARD,  // 煎
	0x717D, KANJI_STANDARD,  // 煽
	0x65CB, KANJI_STANDARD,  // 旋
	0x7A7F, KANJI_STANDARD,  // 穿
	0x7BAD, KANJI_STANDARD,  // 箭
	0x7DDA, KANJI_STANDARD,  // 線
	0x7E4A, KANJI_STANDARD,  // 繊
	0x7FA8, KANJI_STANDARD,  // 羨
	0x817A, KANJI_STANDARD,  // 腺
	0x821B, KANJI_STANDARD,  // 舛
	0x8239, KANJI_STANDARD,  // 船
	0x85A6, KANJI_STANDARD,  // 薦
	0x8A6E, KANJI_STANDARD,  // 詮
	0x8CCE, KANJI_STANDARD,  // 賎
	0x8DF5, KANJI_STANDARD,  // 践
	0x9078, KANJI_STANDARD,  // 選
	0x9077, KANJI_STANDARD,  // 遷
	0x92AD, KANJI_STANDARD,  // 銭
	0x9291, KANJI_STANDARD,  // 銑
	0x9583, KANJI_STANDARD,  // 閃
	0x9BAE, KANJI_STANDARD,  // 鮮
	0x524D, KANJI_STANDARD,  // 前
	0x5584, KANJI_STANDARD,  // 善
	0x6F38, KANJI_STANDARD,  // 漸
	0x7136, KANJI_STANDARD,  // 然
	0x5168, KANJI_STANDARD,  // 全
	0x7985, KANJI_STANDARD,  // 禅
	0x7E55, KANJI_STANDARD,  // 繕
	0x81B3, KANJI_STANDARD,  // 膳
	0x7CCE, KANJI_STANDARD,  // 糎
	0x564C, KANJI_STANDARD,  // 噌
	0x5851, KANJI_STANDARD,  // 塑
	0x5CA8, KANJI_STANDARD,  // 岨
	0x63AA, KANJI_STANDARD,  // 措
	0x66FE, KANJI_STANDARD,  // 曾
	0x66FD, KANJI_STANDARD,  // 曽
	0x695A, KANJI_STANDARD,  // 楚
	0x72D9, KANJI_STANDARD,  // 狙
	0x758F, KANJI_STANDARD,  // 疏
	0x758E, KANJI_STANDARD,  // 疎
	0x790E, KANJI_STANDARD,  // 礎
	0x7956, KANJI_STANDARD,  // 祖
	0x79DF, KANJI_STANDARD,  // 租
	0x7C97, KANJI_STANDARD,  // 粗
	0x7D20, KANJI_STANDARD,  // 素
	0x7D44, KANJI_STANDARD,  // 組
	0x8607, KANJI_STANDARD,  // 蘇
	0x8A34, KANJI_STANDARD,  // 訴
	0x963B, KANJI_STANDARD,  // 阻
	0x9061, KANJI_STANDARD,  // 遡
	0x9F20, KANJI_STANDARD,  // 鼠
	0x50E7, KANJI_STANDARD,  // 僧
	0x5275, KANJI_STANDARD,  // 創
	0x53CC, KANJI_STANDARD,  // 双
	0x53E2, KANJI_STANDARD,  // 叢
	0x5009, KANJI_STANDARD,  // 倉
	0x55AA, KANJI_STANDARD,  // 喪
	0x58EE, KANJI_STANDARD,  // 壮
	0x594F, KANJI_STANDARD,  // 奏
	0x723D, KANJI_STANDARD,  // 爽
	0x5B8B, KANJI_STANDARD,  // 宋
	0x5C64, KANJI_STANDARD,  // 層
	0x531D, KANJI_STANDARD,  // 匝
	0x60E3, KANJI_STANDARD,  // 惣
	0x60F3, KANJI_STANDARD,  // 想
	0x635C, KANJI_STANDARD,  // 捜
	0x6383, KANJI_STANDARD,  // 掃
	0x633F, KANJI_STANDARD,  // 挿
	0x63BB, KANJI_STANDARD,  // 掻
	0x64CD, KANJI_STANDARD,  // 操
	0x65E9, KANJI_STANDARD,  // 早
	0x66F9, KANJI_STANDARD,  // 曹
	0x5DE3, KANJI_STANDARD,  // 巣
	0x69CD, KANJI_STANDARD,  // 槍
	0x69FD, KANJI_STANDARD,  // 槽
	0x6F15, KANJI_STANDARD,  // 漕
	0x71E5, KANJI_STANDARD,  // 燥
	0x4E89, KANJI_STANDARD,  // 争
	0x75E9, KANJI_STANDARD,  // 痩
	0x76F8, KANJI_STANDARD,  // 相
	0x7A93, KANJI_STANDARD,  // 窓
	0x7CDF, KANJI_STANDARD,  // 糟
	0x7DCF, KANJI_STANDARD,  // 総
	0x7D9C, KANJI_STANDARD,  // 綜
	0x8061, KANJI_STANDARD,  // 聡
	0x8349, KANJI_STANDARD,  // 草
	0x8358, KANJI_STANDARD,  // 荘
	0x846C, KANJI_STANDARD,  // 葬
	0x84BC, KANJI_STANDARD,  // 蒼
	0x85FB, KANJI_STANDARD,  // 藻
	0x88C5, KANJI_STANDARD,  // 装
	0x8D70, KANJI_STANDARD,  // 走
	0x9001, KANJI_STANDARD,  // 送
	0x906D, KANJI_STANDARD,  // 遭
	0x9397, KANJI_STANDARD,  // 鎗
	0x971C, KANJI_STANDARD,  // 霜
	0x9A12, KANJI_STANDARD,  // 騒
	0x50CF, KANJI_STANDARD,  // 像
	0x5897, KANJI_STANDARD,  // 増
	0x618E, KANJI_STANDARD,  // 憎
	0x81D3, KANJI_STANDARD,  // 臓
	0x8535, KANJI_STANDARD,  // 蔵
	0x8D08, KANJI_STANDARD,  // 贈
	0x9020, KANJI_STANDARD,  // 造
	0x4FC3, KANJI_STANDARD,  // 促
	0x5074, KANJI_STANDARD,  // 側
	0x5247, KANJI_STANDARD,  // 則
	0x5373, KANJI_STANDARD,  // 即
	0x606F, KANJI_STANDARD,  // 息
	0x6349, KANJI_STANDARD,  // 捉
	0x675F, KANJI_STANDARD,  // 束
	0x6E2C, KANJI_STANDARD,  // 測
	0x8DB3, KANJI_STANDARD,  // 足
	0x901F, KANJI_STANDARD,  // 速
	0x4FD7, KANJI_STANDARD,  // 俗
	0x5C5E, KANJI_STANDARD,  // 属
	0x8CCA, KANJI_STANDARD,  // 賊
	0x65CF, KANJI_STANDARD,  // 族
	0x7D9A, KANJI_STANDARD,  // 続
	0x5352, KANJI_STANDARD,  // 卒
	0x8896, KANJI_STANDARD,  // 袖
	0x5176, KANJI_STANDARD,  // 其
	0x63C3, KANJI_STANDARD,  // 揃
	0x5B58, KANJI_STANDARD,  // 存
	0x5B6B, KANJI_STANDARD,  // 孫
	0x5C0A, KANJI_STANDARD,  // 尊
	0x640D, KANJI_STANDARD,  // 損
	0x6751, KANJI_STANDARD,  // 村
	0x905C, KANJI_STANDARD,  // 遜
	0x4ED6, KANJI_STANDARD,  // 他
	0x591A, KANJI_STANDARD,  // 多
	0x592A, KANJI_STANDARD,  // 太
	0x6C70, KANJI_STANDARD,  // 汰
	0x8A51, KANJI_STANDARD,  // 詑
	0x553E, KANJI_STANDARD,  // 唾
	0x5815, KANJI_STANDARD,  // 堕
	0x59A5, KANJI_STANDARD,  // 妥
	0x60F0, KANJI_STANDARD,  // 惰
	0x6253, KANJI_STANDARD,  // 打
	0x67C1, KANJI_STANDARD,  // 柁
	0x8235, KANJI_STANDARD,  // 舵
	0x6955, KANJI_STANDARD,  // 楕
	0x9640, KANJI_STANDARD,  // 陀
	0x99C4, KANJI_STANDARD,  // 駄
	0x9A28, KANJI_STANDARD,  // 騨
	0x4F53, KANJI_STANDARD,  // 体
	0x5806, KANJI_STANDARD,  // 堆
	0x5BFE, KANJI_STANDARD,  // 対
	0x8010, KANJI_STANDARD,  // 耐
	0x5CB1, KANJI_STANDARD,  // 岱
	0x5E2F, KANJI_STANDARD,  // 帯
	0x5F85, KANJI_STANDARD,  // 待
	0x6020, KANJI_STANDARD,  // 怠
	0x614B, KANJI_STANDARD,  // 態
	0x6234, KANJI_STANDARD,  // 戴
	0x66FF, KANJI_STANDARD,  // 替
	0x6CF0, KANJI_STANDARD,  // 泰
	0x6EDE, KANJI_STANDARD,  // 滞
	0x80CE, KANJI_STANDARD,  // 胎
	0x817F, KANJI_STANDARD,  // 腿
	0x82D4, KANJI_STANDARD,  // 苔
	0x888B, KANJI_STANDARD,  // 袋
	0x8CB8, KANJI_STANDARD,  // 貸
	0x9000, KANJI_STANDARD,  // 退
	0x902E, KANJI_STANDARD,  // 逮
	0x968A, KANJI_STANDARD,  // 隊
	0x9EDB, KANJI_STANDARD,  // 黛
	0x9BDB, KANJI_STANDARD,  // 鯛
	0x4EE3, KANJI_STANDARD,  // 代
	0x53F0, KANJI_STANDARD,  // 台
	0x5927, KANJI_STANDARD,  // 大
	0x7B2C, KANJI_STANDARD,  // 第
	0x918D, KANJI_STANDARD,  // 醍
	0x984C, KANJI_STANDARD,  // 題
	0x9DF9, KANJI_STANDARD,  // 鷹
	0x6EDD, KANJI_STANDARD,  // 滝
	0x7027, KANJI_STANDARD,  // 瀧
	0x5353, KANJI_STANDARD,  // 卓
	0x5544, KANJI_STANDARD,  // 啄
	0x5B85, KANJI_STANDARD,  // 宅
	0x6258, KANJI_STANDARD,  // 托
	0x629E, KANJI_STANDARD,  // 択
	0x62D3, KANJI_STANDARD,  // 拓
	0x6CA2, KANJI_STANDARD,  // 沢
	0x6FEF, KANJI_STANDARD,  // 濯
	0x7422, KANJI_STANDARD,  // 琢
	0x8A17, KANJI_STANDARD,  // 託
	0x9438, KANJI_STANDARD,  // 鐸
	0x6FC1, KANJI_STANDARD,  // 濁
	0x8AFE, KANJI_STANDARD,  // 諾
	0x8338, KANJI_STANDARD,  // 茸
	0x51E7, KANJI_STANDARD,  // 凧
	0x86F8, KANJI_STANDARD,  // 蛸
	0x53EA, KANJI_STANDARD,  // 只
	0x53E9, KANJI_STANDARD,  // 叩
	0x4F46, KANJI_STANDARD,  // 但
	0x9054, KANJI_STANDARD,  // 達
	0x8FB0, KANJI_STANDARD,  // 辰
	0x596A, KANJI_STANDARD,  // 奪
	0x8131, KANJI_STANDARD,  // 脱
	0x5DFD, KANJI_STANDARD,  // 巽
	0x7AEA, KANJI_STANDARD,  // 竪
	0x8FBF, KANJI_STANDARD,  // 辿
	0x68DA, KANJI_STANDARD,  // 棚
	0x8C37, KANJI_STANDARD,  // 谷
	0x72F8, KANJI_STANDARD,  // 狸
	0x9C48, KANJI_STANDARD,  // 鱈
	0x6A3D, KANJI_STANDARD,  // 樽
	0x8AB0, KANJI_STANDARD,  // 誰
	0x4E39, KANJI_STANDARD,  // 丹
	0x5358, KANJI_STANDARD,  // 単
	0x5606, KANJI_STANDARD,  // 嘆
	0x5766, KANJI_STANDARD,  // 坦
	0x62C5, KANJI_STANDARD,  // 担
	0x63A2, KANJI_STANDARD,  // 探
	0x65E6, KANJI_STANDARD,  // 旦
	0x6B4E, KANJI_STANDARD,  // 歎
	0x6DE1, KANJI_STANDARD,  // 淡
	0x6E5B, KANJI_STANDARD,  // 湛
	0x70AD, KANJI_STANDARD,  // 炭
	0x77ED, KANJI_STANDARD,  // 短
	0x7AEF, KANJI_STANDARD,  // 端
	0x7BAA, KANJI_STANDARD,  // 箪
	0x7DBB, KANJI_STANDARD,  // 綻
	0x803D, KANJI_STANDARD,  // 耽
	0x80C6, KANJI_STANDARD,  // 胆
	0x86CB, KANJI_STANDARD,  // 蛋
	0x8A95, KANJI_STANDARD,  // 誕
	0x935B, KANJI_STANDARD,  // 鍛
	0x56E3, KANJI_STANDARD,  // 団
	0x58C7, KANJI_STANDARD,  // 壇
	0x5F3E, KANJI_STANDARD,  // 弾
	0x65AD, KANJI_STANDARD,  // 断
	0x6696, KANJI_STANDARD,  // 暖
	0x6A80, KANJI_STANDARD,  // 檀
	0x6BB5, KANJI_STANDARD,  // 段
	0x7537, KANJI_STANDARD,  // 男
	0x8AC7, KANJI_STANDARD,  // 談
	0x5024, KANJI_STANDARD,  // 値
	0x77E5, KANJI_STANDARD,  // 知
	0x5730, KANJI_STANDARD,  // 地
	0x5F1B, KANJI_STANDARD,  // 弛
	0x6065, KANJI_STANDARD,  // 恥
	0x667A, KANJI_STANDARD,  // 智
	0x6C60, KANJI_STANDARD,  // 池
	0x75F4, KANJI_STANDARD,  // 痴
	0x7A1A, KANJI_STANDARD,  // 稚
	0x7F6E, KANJI_STANDARD,  // 置
	0x81F4, KANJI_STANDARD,  // 致
	0x8718, KANJI_STANDARD,  // 蜘
	0x9045, KANJI_STANDARD,  // 遅
	0x99B3, KANJI_STANDARD,  // 馳
	0x7BC9, KANJI_STANDARD,  // 築
	0x755C, KANJI_STANDARD,  // 畜
	0x7AF9, KANJI_STANDARD,  // 竹
	0x7B51, KANJI_STANDARD,  // 筑
	0x84C4, KANJI_STANDARD,  // 蓄
	0x9010, KANJI_STANDARD,  // 逐
	0x79E9, KANJI_STANDARD,  // 秩
	0x7A92, KANJI_STANDARD,  // 窒
	0x8336, KANJI_STANDARD,  // 茶
	0x5AE1, KANJI_STANDARD,  // 嫡
	0x7740, KANJI_STANDARD,  // 着
	0x4E2D, KANJI_STANDARD,  // 中
	0x4EF2, KANJI_STANDARD,  // 仲
	0x5B99, KANJI_STANDARD,  // 宙
	0x5FE0, KANJI_STANDARD,  // 忠
	0x62BD, KANJI_STANDARD,  // 抽
	0x663C, KANJI_STANDARD,  // 昼
	0x67F1, KANJI_STANDARD,  // 柱
	0x6CE8, KANJI_STANDARD,  // 注
	0x866B, KANJI_STANDARD,  // 虫
	0x8877, KANJI_STANDARD,  // 衷
	0x8A3B, KANJI_STANDARD,  // 註
	0x914E, KANJI_STANDARD,  // 酎
	0x92F3, KANJI_STANDARD,  // 鋳
	0x99D0, KANJI_STANDARD,  // 駐
	0x6A17, KANJI_STANDARD,  // 樗
	0x7026, KANJI_STANDARD,  // 瀦
	0x732A, KANJI_STANDARD,  // 猪
	0x82E7, KANJI_STANDARD,  // 苧
	0x8457, KANJI_STANDARD,  // 著
	0x8CAF, KANJI_STANDARD,  // 貯
	0x4E01, KANJI_STANDARD,  // 丁
	0x5146, KANJI_STANDARD,  // 兆
	0x51CB, KANJI_STANDARD,  // 凋
	0x558B, KANJI_STANDARD,  // 喋
	0x5BF5, KANJI_STANDARD,  // 寵
	0x5E16, KANJI_STANDARD,  // 帖
	0x5E33, KANJI_STANDARD,  // 帳
	0x5E81, KANJI_STANDARD,  // 庁
	0x5F14, KANJI_STANDARD,  // 弔
	0x5F35, KANJI_STANDARD,  // 張
	0x5F6B, KANJI_STANDARD,  // 彫
	0x5FB4, KANJI_STANDARD,  // 徴
	0x61F2, KANJI_STANDARD,  // 懲
	0x6311, KANJI_STANDARD,  // 挑
	0x66A2, KANJI_STANDARD,  // 暢
	0x671D, KANJI_STANDARD,  // 朝
	0x6F6E, KANJI_STANDARD,  // 潮
	0x7252, KANJI_STANDARD,  // 牒
	0x753A, KANJI_STANDARD,  // 町
	0x773A, KANJI_STANDARD,  // 眺
	0x8074, KANJI_STANDARD,  // 聴
	0x8139, KANJI_STANDARD,  // 脹
	0x8178, KANJI_STANDARD,  // 腸
	0x8776, KANJI_STANDARD,  // 蝶
	0x8ABF, KANJI_STANDARD,  // 調
	0x8ADC, KANJI_STANDARD,  // 諜
	0x8D85, KANJI_STANDARD,  // 超
	0x8DF3, KANJI_STANDARD,  // 跳
	0x929A, KANJI_STANDARD,  // 銚
	0x9577, KANJI_STANDARD,  // 長
	0x9802, KANJI_STANDARD,  // 頂
	0x9CE5, KANJI_STANDARD,  // 鳥
	0x52C5, KANJI_STANDARD,  // 勅
	0x6357, KANJI_STANDARD,  // 捗
	0x76F4, KANJI_STANDARD,  // 直
	0x6715, KANJI_STANDARD,  // 朕
	0x6C88, KANJI_STANDARD,  // 沈
	0x73CD, KANJI_STANDARD,  // 珍
	0x8CC3, KANJI_STANDARD,  // 賃
	0x93AE, KANJI_STANDARD,  // 鎮
	0x9673, KANJI_STANDARD,  // 陳
	0x6D25, KANJI_STANDARD,  // 津
	0x589C, KANJI_STANDARD,  // 墜
	0x690E, KANJI_STANDARD,  // 椎
	0x69CC, KANJI_STANDARD,  // 槌
	0x8FFD, KANJI_STANDARD,  // 追
	0x939A, KANJI_STANDARD,  // 鎚
	0x75DB, KANJI_STANDARD,  // 痛
	0x901A, KANJI_STANDARD,  // 通
	0x585A, KANJI_STANDARD,  // 塚
	0x6802, KANJI_STANDARD,  // 栂
	0x63B4, KANJI_STANDARD,  // 掴
	0x69FB, KANJI_STANDARD,  // 槻
	0x4F43, KANJI_STANDARD,  // 佃
	0x6F2C, KANJI_STANDARD,  // 漬
	0x67D8, KANJI_STANDARD,  // 柘
	0x8FBB, KANJI_STANDARD,  // 辻
	0x8526, KANJI_STANDARD,  // 蔦
	0x7DB4, KANJI_STANDARD,  // 綴
	0x9354, KANJI_STANDARD,  // 鍔
	0x693F, KANJI_STANDARD,  // 椿
	0x6F70, KANJI_STANDARD,  // 潰
	0x576A, KANJI_STANDARD,  // 坪
	0x58F7, KANJI_STANDARD,  // 壷
	0x5B2C, KANJI_STANDARD,  // 嬬
	0x7D2C, KANJI_STANDARD,  // 紬
	0x722A, KANJI_STANDARD,  // 爪
	0x540A, KANJI_STANDARD,  // 吊
	0x91E3, KANJI_STANDARD,  // 釣
	0x9DB4, KANJI_STANDARD,  // 鶴
	0x4EAD, KANJI_STANDARD,  // 亭
	0x4F4E, KANJI_STANDARD,  // 低
	0x505C, KANJI_STANDARD,  // 停
	0x5075, KANJI_STANDARD,  // 偵
	0x5243, KANJI_STANDARD,  // 剃
	0x8C9E, KANJI_STANDARD,  // 貞
	0x5448, KANJI_STANDARD,  // 呈
	0x5824, KANJI_STANDARD,  // 堤
	0x5B9A, KANJI_STANDARD,  // 定
	0x5E1D, KANJI_STANDARD,  // 帝
	0x5E95, KANJI_STANDARD,  // 底
	0x5EAD, KANJI_STANDARD,  // 庭
	0x5EF7, KANJI_STANDARD,  // 廷
	0x5F1F, KANJI_STANDARD,  // 弟
	0x608C, KANJI_STANDARD,  // 悌
	0x62B5, KANJI_STANDARD,  // 抵
	0x633A, KANJI_STANDARD,  // 挺
	0x63D0, KANJI_STANDARD,  // 提
	0x68AF, KANJI_STANDARD,  // 梯
	0x6C40, KANJI_STANDARD,  // 汀
	0x7887, KANJI_STANDARD,  // 碇
	0x798E, KANJI_STANDARD,  // 禎
	0x7A0B, KANJI_STANDARD,  // 程
	0x7DE0, KANJI_STANDARD,  // 締
	0x8247, KANJI_STANDARD,  // 艇
	0x8A02, KANJI_STANDARD,  // 訂
	0x8AE6, KANJI_STANDARD,  // 諦
	0x8E44, KANJI_STANDARD,  // 蹄
	0x9013, KANJI_STANDARD,  // 逓
	0x90B8, KANJI_STANDARD,  // 邸
	0x912D, KANJI_STANDARD,  // 鄭
	0x91D8, KANJI_STANDARD,  // 釘
	0x9F0E, KANJI_STANDARD,  // 鼎
	0x6CE5, KANJI_STANDARD,  // 泥
	0x6458, KANJI_STANDARD,  // 摘
	0x64E2, KANJI_STANDARD,  // 擢
	0x6575, KANJI_STANDARD,  // 敵
	0x6EF4, KANJI_STANDARD,  // 滴
	0x7684, KANJI_STANDARD,  // 的
	0x7B1B, KANJI_STANDARD,  // 笛
	0x9069, KANJI_STANDARD,  // 適
	0x93D1, KANJI_STANDARD,  // 鏑
	0x6EBA, KANJI_STANDARD,  // 溺
	0x54F2, KANJI_STANDARD,  // 哲
	0x5FB9, KANJI_STANDARD,  // 徹
	0x64A4, KANJI_STANDARD,  // 撤
	0x8F4D, KANJI_STANDARD,  // 轍
	0x8FED, KANJI_STANDARD,  // 迭
	0x9244, KANJI_STANDARD,  // 鉄
	0x5178, KANJI_STANDARD,  // 典
	0x586B, KANJI_STANDARD,  // 填
	0x5929, KANJI_STANDARD,  // 天
	0x5C55, KANJI_STANDARD,  // 展
	0x5E97, KANJI_STANDARD,  // 店
	0x6DFB, KANJI_STANDARD,  // 添
	0x7E8F, KANJI_STANDARD,  // 纏
	0x751C, KANJI_STANDARD,  // 甜
	0x8CBC, KANJI_STANDARD,  // 貼
	0x8EE2, KANJI_STANDARD,  // 転
	0x985B, KANJI_STANDARD,  // 顛
	0x70B9, KANJI_STANDARD,  // 点
	0x4F1D, KANJI_STANDARD,  // 伝
	0x6BBF, KANJI_STANDARD,  // 殿
	0x6FB1, KANJI_STANDARD,  // 澱
	0x7530, KANJI_STANDARD,  // 田
	0x96FB, KANJI_STANDARD,  // 電
	0x514E, KANJI_STANDARD,  // 兎
	0x5410, KANJI_STANDARD,  // 吐
	0x5835, KANJI_STANDARD,  // 堵
	0x5857, KANJI_STANDARD,  // 塗
	0x59AC, KANJI_STANDARD,  // 妬
	0x5C60, KANJI_STANDARD,  // 屠
	0x5F92, KANJI_STANDARD,  // 徒
	0x6597, KANJI_STANDARD,  // 斗
	0x675C, KANJI_STANDARD,  // 杜
	0x6E21, KANJI_STANDARD,  // 渡
	0x767B, KANJI_STANDARD,  // 登
	0x83DF, KANJI_STANDARD,  // 菟
	0x8CED, KANJI_STANDARD,  // 賭
	0x9014, KANJI_STANDARD,  // 途
	0x90FD, KANJI_STANDARD,  // 都
	0x934D, KANJI_STANDARD,  // 鍍
	0x7825, KANJI_STANDARD,  // 砥
	0x783A, KANJI_STANDARD,  // 砺
	0x52AA, KANJI_STANDARD,  // 努
	0x5EA6, KANJI_STANDARD,  // 度
	0x571F, KANJI_STANDARD,  // 土
	0x5974, KANJI_STANDARD,  // 奴
	0x6012, KANJI_STANDARD,  // 怒
	0x5012, KANJI_STANDARD,  // 倒
	0x515A, KANJI_STANDARD,  // 党
	0x51AC, KANJI_STANDARD,  // 冬
	0x51CD, KANJI_STANDARD,  // 凍
	0x5200, KANJI_STANDARD,  // 刀
	0x5510, KANJI_STANDARD,  // 唐
	0x5854, KANJI_STANDARD,  // 塔
	0x5858, KANJI_STANDARD,  // 塘
	0x5957, KANJI_STANDARD,  // 套
	0x5B95, KANJI_STANDARD,  // 宕
	0x5CF6, KANJI_STANDARD,  // 島
	0x5D8B, KANJI_STANDARD,  // 嶋
	0x60BC, KANJI_STANDARD,  // 悼
	0x6295, KANJI_STANDARD,  // 投
	0x642D, KANJI_STANDARD,  // 搭
	0x6771, KANJI_STANDARD,  // 東
	0x6843, KANJI_STANDARD,  // 桃
	0x68BC, KANJI_STANDARD,  // 梼
	0x68DF, KANJI_STANDARD,  // 棟
	0x76D7, KANJI_STANDARD,  // 盗
	0x6DD8, KANJI_STANDARD,  // 淘
	0x6E6F, KANJI_STANDARD,  // 湯
	0x6D9B, KANJI_STANDARD,  // 涛
	0x706F, KANJI_STANDARD,  // 灯
	0x71C8, KANJI_STANDARD,  // 燈
	0x5F53, KANJI_STANDARD,  // 当
	0x75D8, KANJI_STANDARD,  // 痘
	0x7977, KANJI_STANDARD,  // 祷
	0x7B49, KANJI_STANDARD,  // 等
	0x7B54, KANJI_STANDARD,  // 答
	0x7B52, KANJI_STANDARD,  // 筒
	0x7CD6, KANJI_STANDARD,  // 糖
	0x7D71, KANJI_STANDARD,  // 統
	0x5230, KANJI_STANDARD,  // 到
	0x8463, KANJI_STANDARD,  // 董
	0x8569, KANJI_STANDARD,  // 蕩
	0x85E4, KANJI_STANDARD,  // 藤
	0x8A0E, KANJI_STANDARD,  // 討
	0x8B04, KANJI_STANDARD,  // 謄
	0x8C46, KANJI_STANDARD,  // 豆
	0x8E0F, KANJI_STANDARD,  // 踏
	0x9003, KANJI_STANDARD,  // 逃
	0x900F, KANJI_STANDARD,  // 透
	0x9419, KANJI_STANDARD,  // 鐙
	0x9676, KANJI_STANDARD,  // 陶
	0x982D, KANJI_STANDARD,  // 頭
	0x9A30, KANJI_STANDARD,  // 騰
	0x95D8, KANJI_STANDARD,  // 闘
	0x50CD, KANJI_STANDARD,  // 働
	0x52D5, KANJI_STANDARD,  // 動
	0x540C, KANJI_STANDARD,  // 同
	0x5802, KANJI_STANDARD,  // 堂
	0x5C0E, KANJI_STANDARD,  // 導
	0x61A7, KANJI_STANDARD,  // 憧
	0x649E, KANJI_STANDARD,  // 撞
	0x6D1E, KANJI_STANDARD,  // 洞
	0x77B3, KANJI_STANDARD,  // 瞳
	0x7AE5, KANJI_STANDARD,  // 童
	0x80F4, KANJI_STANDARD,  // 胴
	0x8404, KANJI_STANDARD,  // 萄
	0x9053, KANJI_STANDARD,  // 道
	0x9285, KANJI_STANDARD,  // 銅
	0x5CE0, KANJI_STANDARD,  // 峠
	0x9D07, KANJI_STANDARD,  // 鴇
	0x533F, KANJI_STANDARD,  // 匿
	0x5F97, KANJI_STANDARD,  // 得
	0x5FB3, KANJI_STANDARD,  // 徳
	0x6D9C, KANJI_STANDARD,  // 涜
	0x7279, KANJI_STANDARD,  // 特
	0x7763, KANJI_STANDARD,  // 督
	0x79BF, KANJI_STANDARD,  // 禿
	0x7BE4, KANJI_STANDARD,  // 篤
	0x6BD2, KANJI_STANDARD,  // 毒
	0x72EC, KANJI_STANDARD,  // 独
	0x8AAD, KANJI_STANDARD,  // 読
	0x6803, KANJI_STANDARD,  // 栃
	0x6A61, KANJI_STANDARD,  // 橡
	0x51F8, KANJI_STANDARD,  // 凸
	0x7A81, KANJI_STANDARD,  // 突
	0x6934, KANJI_STANDARD,  // 椴
	0x5C4A, KANJI_STANDARD,  // 届
	0x9CF6, KANJI_STANDARD,  // 鳶
	0x82EB, KANJI_STANDARD,  // 苫
	0x5BC5, KANJI_STANDARD,  // 寅
	0x9149, KANJI_STANDARD,  // 酉
	0x701E, KANJI_STANDARD,  // 瀞
	0x5678, KANJI_STANDARD,  // 噸
	0x5C6F, KANJI_STANDARD,  // 屯
	0x60C7, KANJI_STANDARD,  // 惇
	0x6566, KANJI_STANDARD,  // 敦
	0x6C8C, KANJI_STANDARD,  // 沌
	0x8C5A, KANJI_STANDARD,  // 豚
	0x9041, KANJI_STANDARD,  // 遁
	0x9813, KANJI_STANDARD,  // 頓
	0x5451, KANJI_STANDARD,  // 呑
	0x66C7, KANJI_STANDARD,  // 曇
	0x920D, KANJI_STANDARD,  // 鈍
	0x5948, KANJI_STANDARD,  // 奈
	0x90A3, KANJI_STANDARD,  // 那
	0x5185, KANJI_STANDARD,  // 内
	0x4E4D, KANJI_STANDARD,  // 乍
	0x51EA, KANJI_STANDARD,  // 凪
	0x8599, KANJI_STANDARD,  // 薙
	0x8B0E, KANJI_STANDARD,  // 謎
	0x7058, KANJI_STANDARD,  // 灘
	0x637A, KANJI_STANDARD,  // 捺
	0x934B, KANJI_STANDARD,  // 鍋
	0x6962, KANJI_STANDARD,  // 楢
	0x99B4, KANJI_STANDARD,  // 馴
	0x7E04, KANJI_STANDARD,  // 縄
	0x7577, KANJI_STANDARD,  // 畷
	0x5357, KANJI_STANDARD,  // 南
	0x6960, KANJI_STANDARD,  // 楠
	0x8EDF, KANJI_STANDARD,  // 軟
	0x96E3, KANJI_STANDARD,  // 難
	0x6C5D, KANJI_STANDARD,  // 汝
	0x4E8C, KANJI_STANDARD,  // 二
	0x5C3C, KANJI_STANDARD,  // 尼
	0x5F10, KANJI_STANDARD,  // 弐
	0x8FE9, KANJI_STANDARD,  // 迩
	0x5302, KANJI_STANDARD,  // 匂
	0x8CD1, KANJI_STANDARD,  // 賑
	0x8089, KANJI_STANDARD,  // 肉
	0x8679, KANJI_STANDARD,  // 虹
	0x5EFF, KANJI_STANDARD,  // 廿
	0x65E5, KANJI_STANDARD,  // 日
	0x4E73, KANJI_STANDARD,  // 乳
	0x5165, KANJI_STANDARD,  // 入
	0x5982, KANJI_STANDARD,  // 如
	0x5C3F, KANJI_STANDARD,  // 尿
	0x97EE, KANJI_STANDARD,  // 韮
	0x4EFB, KANJI_STANDARD,  // 任
	0x598A, KANJI_STANDARD,  // 妊
	0x5FCD, KANJI_STANDARD,  // 忍
	0x8A8D, KANJI_STANDARD,  // 認
	0x6FE1, KANJI_STANDARD,  // 濡
	0x79B0, KANJI_STANDARD,  // 禰
	0x7962, KANJI_STANDARD,  // 祢
	0x5BE7, KANJI_STANDARD,  // 寧
	0x8471, KANJI_STANDARD,  // 葱
	0x732B, KANJI_STANDARD,  // 猫
	0x71B1, KANJI_STANDARD,  // 熱
	0x5E74, KANJI_STANDARD,  // 年
	0x5FF5, KANJI_STANDARD,  // 念
	0x637B, KANJI_STANDARD,  // 捻
	0x649A, KANJI_STANDARD,  // 撚
	0x71C3, KANJI_STANDARD,  // 燃
	0x7C98, KANJI_STANDARD,  // 粘
	0x4E43, KANJI_STANDARD,  // 乃
	0x5EFC, KANJI_STANDARD,  // 廼
	0x4E4B, KANJI_STANDARD,  // 之
	0x57DC, KANJI_STANDARD,  // 埜
	0x56A2, KANJI_STANDARD,  // 嚢
	0x60A9, KANJI_STANDARD,  // 悩
	0x6FC3, KANJI_STANDARD,  // 濃
	0x7D0D, KANJI_STANDARD,  // 納
	0x80FD, KANJI_STANDARD,  // 能
	0x8133, KANJI_STANDARD,  // 脳
	0x81BF, KANJI_STANDARD,  // 膿
	0x8FB2, KANJI_STANDARD,  // 農
	0x8997, KANJI_STANDARD,  // 覗
	0x86A4, KANJI_STANDARD,  // 蚤
	0x5DF4, KANJI_STANDARD,  // 巴
	0x628A, KANJI_STANDARD,  // 把
	0x64AD, KANJI_STANDARD,  // 播
	0x8987, KANJI_STANDARD,  // 覇
	0x6777, KANJI_STANDARD,  // 杷
	0x6CE2, KANJI_STANDARD,  // 波
	0x6D3E, KANJI_STANDARD,  // 派
	0x7436, KANJI_STANDARD,  // 琶
	0x7834, KANJI_STANDARD,  // 破
	0x5A46, KANJI_STANDARD,  // 婆
	0x7F75, KANJI_STANDARD,  // 罵
	0x82AD, KANJI_STANDARD,  // 芭
	0x99AC, KANJI_STANDARD,  // 馬
	0x4FF3, KANJI_STANDARD,  // 俳
	0x5EC3, KANJI_STANDARD,  // 廃
	0x62DD, KANJI_STANDARD,  // 拝
	0x6392, KANJI_STANDARD,  // 排
	0x6557, KANJI_STANDARD,  // 敗
	0x676F, KANJI_STANDARD,  // 杯
	0x76C3, KANJI_STANDARD,  // 盃
	0x724C, KANJI_STANDARD,  // 牌
	0x80CC, KANJI_STANDARD,  // 背
	0x80BA, KANJI_STANDARD,  // 肺
	0x8F29, KANJI_STANDARD,  // 輩
	0x914D, KANJI_STANDARD,  // 配
	0x500D, KANJI_STANDARD,  // 倍
	0x57F9, KANJI_STANDARD,  // 培
	0x5A92, KANJI_STANDARD,  // 媒
	0x6885, KANJI_STANDARD,  // 梅
	0x6973, KANJI_STANDARD,  // 楳
	0x7164, KANJI_STANDARD,  // 煤
	0x72FD, KANJI_STANDARD,  // 狽
	0x8CB7, KANJI_STANDARD,  // 買
	0x58F2, KANJI_STANDARD,  // 売
	0x8CE0, KANJI_STANDARD,  // 賠
	0x966A, KANJI_STANDARD,  // 陪
	0x9019, KANJI_STANDARD,  // 這
	0x877F, KANJI_STANDARD,  // 蝿
	0x79E4, KANJI_STANDARD,  // 秤
	0x77E7, KANJI_STANDARD,  // 矧
	0x8429, KANJI_STANDARD,  // 萩
	0x4F2F, KANJI_STANDARD,  // 伯
	0x5265, KANJI_STANDARD,  // 剥
	0x535A, KANJI_STANDARD,  // 博
	0x62CD, KANJI_STANDARD,  // 拍
	0x67CF, KANJI_STANDARD,  // 柏
	0x6CCA, KANJI_STANDARD,  // 泊
	0x767D, KANJI_STANDARD,  // 白
	0x7B94, KANJI_STANDARD,  // 箔
	0x7C95, KANJI_STANDARD,  // 粕
	0x8236, KANJI_STANDARD,  // 舶
	0x8584, KANJI_STANDARD,  // 薄
	0x8FEB, KANJI_STANDARD,  // 迫
	0x66DD, KANJI_STANDARD,  // 曝
	0x6F20, KANJI_STANDARD,  // 漠
	0x7206, KANJI_STANDARD,  // 爆
	0x7E1B, KANJI_STANDARD,  // 縛
	0x83AB, KANJI_STANDARD,  // 莫
	0x99C1, KANJI_STANDARD,  // 駁
	0x9EA6, KANJI_STANDARD,  // 麦
	0x51FD, KANJI_STANDARD,  // 函
	0x7BB1, KANJI_STANDARD,  // 箱
	0x7872, KANJI_STANDARD,  // 硲
	0x7BB8, KANJI_STANDARD,  // 箸
	0x8087, KANJI_STANDARD,  // 肇
	0x7B48, KANJI_STANDARD,  // 筈
	0x6AE8, KANJI_STANDARD,  // 櫨
	0x5E61, KANJI_STANDARD,  // 幡
	0x808C, KANJI_STANDARD,  // 肌
	0x7551, KANJI_STANDARD,  // 畑
	0x7560, KANJI_STANDARD,  // 畠
	0x516B, KANJI_STANDARD,  // 八
	0x9262, KANJI_STANDARD,  // 鉢
	0x6E8C, KANJI_STANDARD,  // 溌
	0x767A, KANJI_STANDARD,  // 発
	0x9197, KANJI_STANDARD,  // 醗
	0x9AEA, KANJI_STANDARD,  // 髪
	0x4F10, KANJI_STANDARD,  // 伐
	0x7F70, KANJI_STANDARD,  // 罰
	0x629C, KANJI_STANDARD,  // 抜
	0x7B4F, KANJI_STANDARD,  // 筏
	0x95A5, KANJI_STANDARD,  // 閥
	0x9CE9, KANJI_STANDARD,  // 鳩
	0x567A, KANJI_STANDARD,  // 噺
	0x5859, KANJI_STANDARD,  // 塙
	0x86E4, KANJI_STANDARD,  // 蛤
	0x96BC, KANJI_STANDARD,  // 隼
	0x4F34, KANJI_STANDARD,  // 伴
	0x5224, KANJI_STANDARD,  // 判
	0x534A, KANJI_STANDARD,  // 半
	0x53CD, KANJI_STANDARD,  // 反
	0x53DB, KANJI_STANDARD,  // 叛
	0x5E06, KANJI_STANDARD,  // 帆
	0x642C, KANJI_STANDARD,  // 搬
	0x6591, KANJI_STANDARD,  // 斑
	0x677F, KANJI_STANDARD,  // 板
	0x6C3E, KANJI_STANDARD,  // 氾
	0x6C4E, KANJI_STANDARD,  // 汎
	0x7248, KANJI_STANDARD,  // 版
	0x72AF, KANJI_STANDARD,  // 犯
	0x73ED, KANJI_STANDARD,  // 班
	0x7554, KANJI_STANDARD,  // 畔
	0x7E41, KANJI_STANDARD,  // 繁
	0x822C, KANJI_STANDARD,  // 般
	0x85E9, KANJI_STANDARD,  // 藩
	0x8CA9, KANJI_STANDARD,  // 販
	0x7BC4, KANJI_STANDARD,  // 範
	0x91C6, KANJI_STANDARD,  // 釆
	0x7169, KANJI_STANDARD,  // 煩
	0x9812, KANJI_STANDARD,  // 頒
	0x98EF, KANJI_STANDARD,  // 飯
	0x633D, KANJI_STANDARD,  // 挽
	0x6669, KANJI_STANDARD,  // 晩
	0x756A, KANJI_STANDARD,  // 番
	0x76E4, KANJI_STANDARD,  // 盤
	0x78D0, KANJI_STANDARD,  // 磐
	0x8543, KANJI_STANDARD,  // 蕃
	0x86EE, KANJI_STANDARD,  // 蛮
	0x532A, KANJI_STANDARD,  // 匪
	0x5351, KANJI_STANDARD,  // 卑
	0x5426, KANJI_STANDARD,  // 否
	0x5983, KANJI_STANDARD,  // 妃
	0x5E87, KANJI_STANDARD,  // 庇
	0x5F7C, KANJI_STANDARD,  // 彼
	0x60B2, KANJI_STANDARD,  // 悲
	0x6249, KANJI_STANDARD,  // 扉
	0x6279, KANJI_STANDARD,  // 批
	0x62AB, KANJI_STANDARD,  // 披
	0x6590, KANJI_STANDARD,  // 斐
	0x6BD4, KANJI_STANDARD,  // 比
	0x6CCC, KANJI_STANDARD,  // 泌
	0x75B2, KANJI_STANDARD,  // 疲
	0x76AE, KANJI_STANDARD,  // 皮
	0x7891, KANJI_STANDARD,  // 碑
	0x79D8, KANJI_STANDARD,  // 秘
	0x7DCB, KANJI_STANDARD,  // 緋
	0x7F77, KANJI_STANDARD,  // 罷
	0x80A5, KANJI_STANDARD,  // 肥
	0x88AB, KANJI_STANDARD,  // 被
	0x8AB9, KANJI_STANDARD,  // 誹
	0x8CBB, KANJI_STANDARD,  // 費
	0x907F, KANJI_STANDARD,  // 避
	0x975E, KANJI_STANDARD,  // 非
	0x98DB, KANJI_STANDARD,  // 飛
	0x6A0B, KANJI_STANDARD,  // 樋
	0x7C38, KANJI_STANDARD,  // 簸
	0x5099, KANJI_STANDARD,  // 備
	0x5C3E, KANJI_STANDARD,  // 尾
	0x5FAE, KANJI_STANDARD,  // 微
	0x6787, KANJI_STANDARD,  // 枇
	0x6BD8, KANJI_STANDARD,  // 毘
	0x7435, KANJI_STANDARD,  // 琵
	0x7709, KANJI_STANDARD,  // 眉
	0x7F8E, KANJI_STANDARD,  // 美
	0x9F3B, KANJI_STANDARD,  // 鼻
	0x67CA, KANJI_STANDARD,  // 柊
	0x7A17, KANJI_STANDARD,  // 稗
	0x5339, KANJI_STANDARD,  // 匹
	0x758B, KANJI_STANDARD,  // 疋
	0x9AED, KANJI_STANDARD,  // 髭
	0x5F66, KANJI_STANDARD,  // 彦
	0x819D, KANJI_STANDARD,  // 膝
	0x83F1, KANJI_STANDARD,  // 菱
	0x8098, KANJI_STANDARD,  // 肘
	0x5F3C, KANJI_STANDARD,  // 弼
	0x5FC5, KANJI_STANDARD,  // 必
	0x7562, KANJI_STANDARD,  // 畢
	0x7B46, KANJI_STANDARD,  // 筆
	0x903C, KANJI_STANDARD,  // 逼
	0x6867, KANJI_STANDARD,  // 桧
	0x59EB, KANJI_STANDARD,  // 姫
	0x5A9B, KANJI_STANDARD,  // 媛
	0x7D10, KANJI_STANDARD,  // 紐
	0x767E, KANJI_STANDARD,  // 百
	0x8B2C, KANJI_STANDARD,  // 謬
	0x4FF5, KANJI_STANDARD,  // 俵
	0x5F6A, KANJI_STANDARD,  // 彪
	0x6A19, KANJI_STANDARD,  // 標
	0x6C37, KANJI_STANDARD,  // 氷
	0x6F02, KANJI_STANDARD,  // 漂
	0x74E2, KANJI_STANDARD,  // 瓢
	0x7968, KANJI_STANDARD,  // 票
	0x8868, KANJI_STANDARD,  // 表
	0x8A55, KANJI_STANDARD,  // 評
	0x8C79, KANJI_STANDARD,  // 豹
	0x5EDF, KANJI_STANDARD,  // 廟
	0x63CF, KANJI_STANDARD,  // 描
	0x75C5, KANJI_STANDARD,  // 病
	0x79D2, KANJI_STANDARD,  // 秒
	0x82D7, KANJI_STANDARD,  // 苗
	0x9328, KANJI_STANDARD,  // 錨
	0x92F2, KANJI_STANDARD,  // 鋲
	0x849C, KANJI_STANDARD,  // 蒜
	0x86ED, KANJI_STANDARD,  // 蛭
	0x9C2D, KANJI_STANDARD,  // 鰭
	0x54C1, KANJI_STANDARD,  // 品
	0x5F6C, KANJI_STANDARD,  // 彬
	0x658C, KANJI_STANDARD,  // 斌
	0x6D5C, KANJI_STANDARD,  // 浜
	0x7015, KANJI_STANDARD,  // 瀕
	0x8CA7, KANJI_STANDARD,  // 貧
	0x8CD3, KANJI_STANDARD,  // 賓
	0x983B, KANJI_STANDARD,  // 頻
	0x654F, KANJI_STANDARD,  // 敏
	0x74F6, KANJI_STANDARD,  // 瓶
	0x4E0D, KANJI_STANDARD,  // 不
	0x4ED8, KANJI_STANDARD,  // 付
	0x57E0, KANJI_STANDARD,  // 埠
	0x592B, KANJI_STANDARD,  // 夫
	0x5A66, KANJI_STANDARD,  // 婦
	0x5BCC, KANJI_STANDARD,  // 富
	0x51A8, KANJI_STANDARD,  // 冨
	0x5E03, KANJI_STANDARD,  // 布
	0x5E9C, KANJI_STANDARD,  // 府
	0x6016, KANJI_STANDARD,  // 怖
	0x6276, KANJI_STANDARD,  // 扶
	0x6577, KANJI_STANDARD,  // 敷
	0x65A7, KANJI_STANDARD,  // 斧
	0x666E, KANJI_STANDARD,  // 普
	0x6D6E, KANJI_STANDARD,  // 浮
	0x7236, KANJI_STANDARD,  // 父
	0x7B26, KANJI_STANDARD,  // 符
	0x8150, KANJI_STANDARD,  // 腐
	0x819A, KANJI_STANDARD,  // 膚
	0x8299, KANJI_STANDARD,  // 芙
	0x8B5C, KANJI_STANDARD,  // 譜
	0x8CA0, KANJI_STANDARD,  // 負
	0x8CE6, KANJI_STANDARD,  // 賦
	0x8D74, KANJI_STANDARD,  // 赴
	0x961C, KANJI_STANDARD,  // 阜
	0x9644, KANJI_STANDARD,  // 附
	0x4FAE, KANJI_STANDARD,  // 侮
	0x64AB, KANJI_STANDARD,  // 撫
	0x6B66, KANJI_STANDARD,  // 武
	0x821E, KANJI_STANDARD,  // 舞
	0x8461, KANJI_STANDARD,  // 葡
	0x856A, KANJI_STANDARD,  // 蕪
	0x90E8, KANJI_STANDARD,  // 部
	0x5C01, KANJI_STANDARD,  // 封
	0x6953, KANJI_STANDARD,  // 楓
	0x98A8, KANJI_STANDARD,  // 風
	0x847A, KANJI_STANDARD,  // 葺
	0x8557, KANJI_STANDARD,  // 蕗
	0x4F0F, KANJI_STANDARD,  // 伏
	0x526F, KANJI_STANDARD,  // 副
	0x5FA9, KANJI_STANDARD,  // 復
	0x5E45, KANJI_STANDARD,  // 幅
	0x670D, KANJI_STANDARD,  // 服
	0x798F, KANJI_STANDARD,  // 福
	0x8179, KANJI_STANDARD,  // 腹
	0x8907, KANJI_STANDARD,  // 複
	0x8986, KANJI_STANDARD,  // 覆
	0x6DF5, KANJI_STANDARD,  // 淵
	0x5F17, KANJI_STANDARD,  // 弗
	0x6255, KANJI_STANDARD,  // 払
	0x6CB8, KANJI_STANDARD,  // 沸
	0x4ECF, KANJI_STANDARD,  // 仏
	0x7269, KANJI_STANDARD,  // 物
	0x9B92, KANJI_STANDARD,  // 鮒
	0x5206, KANJI_STANDARD,  // 分
	0x543B, KANJI_STANDARD,  // 吻
	0x5674, KANJI_STANDARD,  // 噴
	0x58B3, KANJI_STANDARD,  // 墳
	0x61A4, KANJI_STANDARD,  // 憤
	0x626E, KANJI_STANDARD,  // 扮
	0x711A, KANJI_STANDARD,  // 焚
	0x596E, KANJI_STANDARD,  // 奮
	0x7C89, KANJI_STANDARD,  // 粉
	0x7CDE, KANJI_STANDARD,  // 糞
	0x7D1B, KANJI_STANDARD,  // 紛
	0x96F0, KANJI_STANDARD,  // 雰
	0x6587, KANJI_STANDARD,  // 文
	0x805E, KANJI_STANDARD,  // 聞
	0x4E19, KANJI_STANDARD,  // 丙
	0x4F75, KANJI_STANDARD,  // 併
	0x5175, KANJI_STANDARD,  // 兵
	0x5840, KANJI_STANDARD,  // 塀
	0x5E63, KANJI_STANDARD,  // 幣
	0x5E73, KANJI_STANDARD,  // 平
	0x5F0A, KANJI_STANDARD,  // 弊
	0x67C4, KANJI_STANDARD,  // 柄
	0x4E26, KANJI_STANDARD,  // 並
	0x853D, KANJI_STANDARD,  // 蔽
	0x9589, KANJI_STANDARD,  // 閉
	0x965B, KANJI_STANDARD,  // 陛
	0x7C73, KANJI_STANDARD,  // 米
	0x9801, KANJI_STANDARD,  // 頁
	0x50FB, KANJI_STANDARD,  // 僻
	0x58C1, KANJI_STANDARD,  // 壁
	0x7656, KANJI_STANDARD,  // 癖
	0x78A7, KANJI_STANDARD,  // 碧
	0x5225, KANJI_STANDARD,  // 別
	0x77A5, KANJI_STANDARD,  // 瞥
	0x8511, KANJI_STANDARD,  // 蔑
	0x7B86, KANJI_STANDARD,  // 箆
	0x504F, KANJI_STANDARD,  // 偏
	0x5909, KANJI_STANDARD,  // 変
	0x7247, KANJI_STANDARD,  // 片
	0x7BC7, KANJI_STANDARD,  // 篇
	0x7DE8, KANJI_STANDARD,  // 編
	0x8FBA, KANJI_STANDARD,  // 辺
	0x8FD4, KANJI_STANDARD,  // 返
	0x904D, KANJI_STANDARD,  // 遍
	0x4FBF, KANJI_STANDARD,  // 便
	0x52C9, KANJI_STANDARD,  // 勉
	0x5A29, KANJI_STANDARD,  // 娩
	0x5F01, KANJI_STANDARD,  // 弁
	0x97AD, KANJI_STANDARD,  // 鞭
	0x4FDD, KANJI_STANDARD,  // 保
	0x8217, KANJI_STANDARD,  // 舗
	0x92EA, KANJI_STANDARD,  // 鋪
	0x5703, KANJI_STANDARD,  // 圃
	0x6355, KANJI_STANDARD,  // 捕
	0x6B69, KANJI_STANDARD,  // 歩
	0x752B, KANJI_STANDARD,  // 甫
	0x88DC, KANJI_STANDARD,  // 補
	0x8F14, KANJI_STANDARD,  // 輔
	0x7A42, KANJI_STANDARD,  // 穂
	0x52DF, KANJI_STANDARD,  // 募
	0x5893, KANJI_STANDARD,  // 墓
	0x6155, KANJI_STANDARD,  // 慕
	0x620A, KANJI_STANDARD,  // 戊
	0x66AE, KANJI_STANDARD,  // 暮
	0x6BCD, KANJI_STANDARD,  // 母
	0x7C3F, KANJI_STANDARD,  // 簿
	0x83E9, KANJI_STANDARD,  // 菩
	0x5023, KANJI_STANDARD,  // 倣
	0x4FF8, KANJI_STANDARD,  // 俸
	0x5305, KANJI_STANDARD,  // 包
	0x5446, KANJI_STANDARD,  // 呆
	0x5831, KANJI_STANDARD,  // 報
	0x5949, KANJI_STANDARD,  // 奉
	0x5B9D, KANJI_STANDARD,  // 宝
	0x5CF0, KANJI_STANDARD,  // 峰
	0x5CEF, KANJI_STANDARD,  // 峯
	0x5D29, KANJI_STANDARD,  // 崩
	0x5E96, KANJI_STANDARD,  // 庖
	0x62B1, KANJI_STANDARD,  // 抱
	0x6367, KANJI_STANDARD,  // 捧
	0x653E, KANJI_STANDARD,  // 放
	0x65B9, KANJI_STANDARD,  // 方
	0x670B, KANJI_STANDARD,  // 朋
	0x6CD5, KANJI_STANDARD,  // 法
	0x6CE1, KANJI_STANDARD,  // 泡
	0x70F9, KANJI_STANDARD,  // 烹
	0x7832, KANJI_STANDARD,  // 砲
	0x7E2B, KANJI_STANDARD,  // 縫
	0x80DE, KANJI_STANDARD,  // 胞
	0x82B3, KANJI_STANDARD,  // 芳
	0x840C, KANJI_STANDARD,  // 萌
	0x84EC, KANJI_STANDARD,  // 蓬
	0x8702, KANJI_STANDARD,  // 蜂
	0x8912, KANJI_STANDARD,  // 褒
	0x8A2A, KANJI_STANDARD,  // 訪
	0x8C4A, KANJI_STANDARD,  // 豊
	0x90A6, KANJI_STANDARD,  // 邦
	0x92D2, KANJI_STANDARD,  // 鋒
	0x98FD, KANJI_STANDARD,  // 飽
	0x9CF3, KANJI_STANDARD,  // 鳳
	0x9D6C, KANJI_STANDARD,  // 鵬
	0x4E4F, KANJI_STANDARD,  // 乏
	0x4EA1, KANJI_STANDARD,  // 亡
	0x508D, KANJI_STANDARD,  // 傍
	0x5256, KANJI_STANDARD,  // 剖
	0x574A, KANJI_STANDARD,  // 坊
	0x59A8, KANJI_STANDARD,  // 妨
	0x5E3D, KANJI_STANDARD,  // 帽
	0x5FD8, KANJI_STANDARD,  // 忘
	0x5FD9, KANJI_STANDARD,  // 忙
	0x623F, KANJI_STANDARD,  // 房
	0x66B4, KANJI_STANDARD,  // 暴
	0x671B, KANJI_STANDARD,  // 望
	0x67D0, KANJI_STANDARD,  // 某
	0x68D2, KANJI_STANDARD,  // 棒
	0x5192, KANJI_STANDARD,  // 冒
	0x7D21, KANJI_STANDARD,  // 紡
	0x80AA, KANJI_STANDARD,  // 肪
	0x81A8, KANJI_STANDARD,  // 膨
	0x8B00, KANJI_STANDARD,  // 謀
	0x8C8C, KANJI_STANDARD,  // 貌
	0x8CBF, KANJI_STANDARD,  // 貿
	0x927E, KANJI_STANDARD,  // 鉾
	0x9632, KANJI_STANDARD,  // 防
	0x5420, KANJI_STANDARD,  // 吠
	0x982C, KANJI_STANDARD,  // 頬
	0x5317, KANJI_STANDARD,  // 北
	0x50D5, KANJI_STANDARD,  // 僕
	0x535C, KANJI_STANDARD,  // 卜
	0x58A8, KANJI_STANDARD,  // 墨
	0x64B2, KANJI_STANDARD,  // 撲
	0x6734, KANJI_STANDARD,  // 朴
	0x7267, KANJI_STANDARD,  // 牧
	0x7766, KANJI_STANDARD,  // 睦
	0x7A46, KANJI_STANDARD,  // 穆
	0x91E6, KANJI_STANDARD,  // 釦
	0x52C3, KANJI_STANDARD,  // 勃
	0x6CA1, KANJI_STANDARD,  // 没
	0x6B86, KANJI_STANDARD,  // 殆
	0x5800, KANJI_STANDARD,  // 堀
	0x5E4C, KANJI_STANDARD,  // 幌
	0x5954, KANJI_STANDARD,  // 奔
	0x672C, KANJI_STANDARD,  // 本
	0x7FFB, KANJI_STANDARD,  // 翻
	0x51E1, KANJI_STANDARD,  // 凡
	0x76C6, KANJI_STANDARD,  // 盆
	0x6469, KANJI_STANDARD,  // 摩
	0x78E8, KANJI_STANDARD,  // 磨
	0x9B54, KANJI_STANDARD,  // 魔
	0x9EBB, KANJI_STANDARD,  // 麻
	0x57CB, KANJI_STANDARD,  // 埋
	0x59B9, KANJI_STANDARD,  // 妹
	0x6627, KANJI_STANDARD,  // 昧
	0x679A, KANJI_STANDARD,  // 枚
	0x6BCE, KANJI_STANDARD,  // 毎
	0x54E9, KANJI_STANDARD,  // 哩
	0x69D9, KANJI_STANDARD,  // 槙
	0x5E55, KANJI_STANDARD,  // 幕
	0x819C, KANJI_STANDARD,  // 膜
	0x6795, KANJI_STANDARD,  // 枕
	0x9BAA, KANJI_STANDARD,  // 鮪
	0x67FE, KANJI_STANDARD,  // 柾
	0x9C52, KANJI_STANDARD,  // 鱒
	0x685D, KANJI_STANDARD,  // 桝
	0x4EA6, KANJI_STANDARD,  // 亦
	0x4FE3, KANJI_STANDARD,  // 俣
	0x53C8, KANJI_STANDARD,  // 又
	0x62B9, KANJI_STANDARD,  // 抹
	0x672B, KANJI_STANDARD,  // 末
	0x6CAB, KANJI_STANDARD,  // 沫
	0x8FC4, KANJI_STANDARD,  // 迄
	0x4FAD, KANJI_STANDARD,  // 侭
	0x7E6D, KANJI_STANDARD,  // 繭
	0x9EBF, KANJI_STANDARD,  // 麿
	0x4E07, KANJI_STANDARD,  // 万
	0x6162, KANJI_STANDARD,  // 慢
	0x6E80, KANJI_STANDARD,  // 満
	0x6F2B, KANJI_STANDARD,  // 漫
	0x8513, KANJI_STANDARD,  // 蔓
	0x5473, KANJI_STANDARD,  // 味
	0x672A, KANJI_STANDARD,  // 未
	0x9B45, KANJI_STANDARD,  // 魅
	0x5DF3, KANJI_STANDARD,  // 巳
	0x7B95, KANJI_STANDARD,  // 箕
	0x5CAC, KANJI_STANDARD,  // 岬
	0x5BC6, KANJI_STANDARD,  // 密
	0x871C, KANJI_STANDARD,  // 蜜
	0x6E4A, KANJI_STANDARD,  // 湊
	0x84D1, KANJI_STANDARD,  // 蓑
	0x7A14, KANJI_STANDARD,  // 稔
	0x8108, KANJI_STANDARD,  // 脈
	0x5999, KANJI_STANDARD,  // 妙
	0x7C8D, KANJI_STANDARD,  // 粍
	0x6C11, KANJI_STANDARD,  // 民
	0x7720, KANJI_STANDARD,  // 眠
	0x52D9, KANJI_STANDARD,  // 務
	0x5922, KANJI_STANDARD,  // 夢
	0x7121, KANJI_STANDARD,  // 無
	0x725F, KANJI_STANDARD,  // 牟
	0x77DB, KANJI_STANDARD,  // 矛
	0x9727, KANJI_STANDARD,  // 霧
	0x9D61, KANJI_STANDARD,  // 鵡
	0x690B, KANJI_STANDARD,  // 椋
	0x5A7F, KANJI_STANDARD,  // 婿
	0x5A18, KANJI_STANDARD,  // 娘
	0x51A5, KANJI_STANDARD,  // 冥
	0x540D, KANJI_STANDARD,  // 名
	0x547D, KANJI_STANDARD,  // 命
	0x660E, KANJI_STANDARD,  // 明
	0x76DF, KANJI_STANDARD,  // 盟
	0x8FF7, KANJI_STANDARD,  // 迷
	0x9298, KANJI_STANDARD,  // 銘
	0x9CF4, KANJI_STANDARD,  // 鳴
	0x59EA, KANJI_STANDARD,  // 姪
	0x725D, KANJI_STANDARD,  // 牝
	0x6EC5, KANJI_STANDARD,  // 滅
	0x514D, KANJI_STANDARD,  // 免
	0x68C9, KANJI_STANDARD,  // 棉
	0x7DBF, KANJI_STANDARD,  // 綿
	0x7DEC, KANJI_STANDARD,  // 緬
	0x9762, KANJI_STANDARD,  // 面
	0x9EBA, KANJI_STANDARD,  // 麺
	0x6478, KANJI_STANDARD,  // 摸
	0x6A21, KANJI_STANDARD,  // 模
	0x8302, KANJI_STANDARD,  // 茂
	0x5984, KANJI_STANDARD,  // 妄
	0x5B5F, KANJI_STANDARD,  // 孟
	0x6BDB, KANJI_STANDARD,  // 毛
	0x731B, KANJI_STANDARD,  // 猛
	0x76F2, KANJI_STANDARD,  // 盲
	0x7DB2, KANJI_STANDARD,  // 網
	0x8017, KANJI_STANDARD,  // 耗
	0x8499, KANJI_STANDARD,  // 蒙
	0x5132, KANJI_STANDARD,  // 儲
	0x6728, KANJI_STANDARD,  // 木
	0x9ED9, KANJI_STANDARD,  // 黙
	0x76EE, KANJI_STANDARD,  // 目
	0x6762, KANJI_STANDARD,  // 杢
	0x52FF, KANJI_STANDARD,  // 勿
	0x9905, KANJI_STANDARD,  // 餅
	0x5C24, KANJI_STANDARD,  // 尤
	0x623B, KANJI_STANDARD,  // 戻
	0x7C7E, KANJI_STANDARD,  // 籾
	0x8CB0, KANJI_STANDARD,  // 貰
	0x554F, KANJI_STANDARD,  // 問
	0x60B6, KANJI_STANDARD,  // 悶
	0x7D0B, KANJI_STANDARD,  // 紋
	0x9580, KANJI_STANDARD,  // 門
	0x5301, KANJI_STANDARD,  // 匁
	0x4E5F, KANJI_STANDARD,  // 也
	0x51B6, KANJI_STANDARD,  // 冶
	0x591C, KANJI_STANDARD,  // 夜
	0x723A, KANJI_STANDARD,  // 爺
	0x8036, KANJI_STANDARD,  // 耶
	0x91CE, KANJI_STANDARD,  // 野
	0x5F25, KANJI_STANDARD,  // 弥
	0x77E2, KANJI_STANDARD,  // 矢
	0x5384, KANJI_STANDARD,  // 厄
	0x5F79, KANJI_STANDARD,  // 役
	0x7D04, KANJI_STANDARD,  // 約
	0x85AC, KANJI_STANDARD,  // 薬
	0x8A33, KANJI_STANDARD,  // 訳
	0x8E8D, KANJI_STANDARD,  // 躍
	0x9756, KANJI_STANDARD,  // 靖
	0x67F3, KANJI_STANDARD,  // 柳
	0x85AE, KANJI_STANDARD,  // 薮
	0x9453, KANJI_STANDARD,  // 鑓
	0x6109, KANJI_STANDARD,  // 愉
	0x6108, KANJI_STANDARD,  // 愈
	0x6CB9, KANJI_STANDARD,  // 油
	0x7652, KANJI_STANDARD,  // 癒
	0x8AED, KANJI_STANDARD,  // 諭
	0x8F38, KANJI_STANDARD,  // 輸
	0x552F, KANJI_STANDARD,  // 唯
	0x4F51, KANJI_STANDARD,  // 佑
	0x512A, KANJI_STANDARD,  // 優
	0x52C7, KANJI_STANDARD,  // 勇
	0x53CB, KANJI_STANDARD,  // 友
	0x5BA5, KANJI_STANDARD,  // 宥
	0x5E7D, KANJI_STANDARD,  // 幽
	0x60A0, KANJI_STANDARD,  // 悠
	0x6182, KANJI_STANDARD,  // 憂
	0x63D6, KANJI_STANDARD,  // 揖
	0x6709, KANJI_STANDARD,  // 有
	0x67DA, KANJI_STANDARD,  // 柚
	0x6E67, KANJI_STANDARD,  // 湧
	0x6D8C, KANJI_STANDARD,  // 涌
	0x7336, KANJI_STANDARD,  // 猶
	0x7337, KANJI_STANDARD,  // 猷
	0x7531, KANJI_STANDARD,  // 由
	0x7950, KANJI_STANDARD,  // 祐
	0x88D5, KANJI_STANDARD,  // 裕
	0x8A98, KANJI_STANDARD,  // 誘
	0x904A, KANJI_STANDARD,  // 遊
	0x9091, KANJI_STANDARD,  // 邑
	0x90F5, KANJI_STANDARD,  // 郵
	0x96C4, KANJI_STANDARD,  // 雄
	0x878D, KANJI_STANDARD,  // 融
	0x5915, KANJI_STANDARD,  // 夕
	0x4E88, KANJI_STANDARD,  // 予
	0x4F59, KANJI_STANDARD,  // 余
	0x4E0E, KANJI_STANDARD,  // 与
	0x8A89, KANJI_STANDARD,  // 誉
	0x8F3F, KANJI_STANDARD,  // 輿
	0x9810, KANJI_STANDARD,  // 預
	0x50AD, KANJI_STANDARD,  // 傭
	0x5E7C, KANJI_STANDARD,  // 幼
	0x5996, KANJI_STANDARD,  // 妖
	0x5BB9, KANJI_STANDARD,  // 容
	0x5EB8, KANJI_STANDARD,  // 庸
	0x63DA, KANJI_STANDARD,  // 揚
	0x63FA, KANJI_STANDARD,  // 揺
	0x64C1, KANJI_STANDARD,  // 擁
	0x66DC, KANJI_STANDARD,  // 曜
	0x694A, KANJI_STANDARD,  // 楊
	0x69D8, KANJI_STANDARD,  // 様
	0x6D0B, KANJI_STANDARD,  // 洋
	0x6EB6, KANJI_STANDARD,  // 溶
	0x7194, KANJI_STANDARD,  // 熔
	0x7528, KANJI_STANDARD,  // 用
	0x7AAF, KANJI_STANDARD,  // 窯
	0x7F8A, KANJI_STANDARD,  // 羊
	0x8000, KANJI_STANDARD,  // 耀
	0x8449, KANJI_STANDARD,  // 葉
	0x84C9, KANJI_STANDARD,  // 蓉
	0x8981, KANJI_STANDARD,  // 要
	0x8B21, KANJI_STANDARD,  // 謡
	0x8E0A, KANJI_STANDARD,  // 踊
	0x9065, KANJI_STANDARD,  // 遥
	0x967D, KANJI_STANDARD,  // 陽
	0x990A, KANJI_STANDARD,  // 養
	0x617E, KANJI_STANDARD,  // 慾
	0x6291, KANJI_STANDARD,  // 抑
	0x6B32, KANJI_STANDARD,  // 欲
	0x6C83, KANJI_STANDARD,  // 沃
	0x6D74, KANJI_STANDARD,  // 浴
	0x7FCC, KANJI_STANDARD,  // 翌
	0x7FFC, KANJI_STANDARD,  // 翼
	0x6DC0, KANJI_STANDARD,  // 淀
	0x7F85, KANJI_STANDARD,  // 羅
	0x87BA, KANJI_STANDARD,  // 螺
	0x88F8, KANJI_STANDARD,  // 裸
	0x6765, KANJI_STANDARD,  // 来
	0x83B1, KANJI_STANDARD,  // 莱
	0x983C, KANJI_STANDARD,  // 頼
	0x96F7, KANJI_STANDARD,  // 雷
	0x6D1B, KANJI_STANDARD,  // 洛
	0x7D61, KANJI_STANDARD,  // 絡
	0x843D, KANJI_STANDARD,  // 落
	0x916A, KANJI_STANDARD,  // 酪
	0x4E71, KANJI_STANDARD,  // 乱
	0x5375, KANJI_STANDARD,  // 卵
	0x5D50, KANJI_STANDARD,  // 嵐
	0x6B04, KANJI_STANDARD,  // 欄
	0x6FEB, KANJI_STANDARD,  // 濫
	0x85CD, KANJI_STANDARD,  // 藍
	0x862D, KANJI_STANDARD,  // 蘭
	0x89A7, KANJI_STANDARD,  // 覧
	0x5229, KANJI_STANDARD,  // 利
	0x540F, KANJI_STANDARD,  // 吏
	0x5C65, KANJI_STANDARD,  // 履
	0x674E, KANJI_STANDARD,  // 李
	0x68A8, KANJI_STANDARD,  // 梨
	0x7406, KANJI_STANDARD,  // 理
	0x7483, KANJI_STANDARD,  // 璃
	0x75E2, KANJI_STANDARD,  // 痢
	0x88CF, KANJI_STANDARD,  // 裏
	0x88E1, KANJI_STANDARD,  // 裡
	0x91CC, KANJI_STANDARD,  // 里
	0x96E2, KANJI_STANDARD,  // 離
	0x9678, KANJI_STANDARD,  // 陸
	0x5F8B, KANJI_STANDARD,  // 律
	0x7387, KANJI_STANDARD,  // 率
	0x7ACB, KANJI_STANDARD,  // 立
	0x844E, KANJI_STANDARD,  // 葎
	0x63A0, KANJI_STANDARD,  // 掠
	0x7565, KANJI_STANDARD,  // 略
	0x5289, KANJI_STANDARD,  // 劉
	0x6D41, KANJI_STANDARD,  // 流
	0x6E9C, KANJI_STANDARD,  // 溜
	0x7409, KANJI_STANDARD,  // 琉
	0x7559, KANJI_STANDARD,  // 留
	0x786B, KANJI_STANDARD,  // 硫
	0x7C92, KANJI_STANDARD,  // 粒
	0x9686, KANJI_STANDARD,  // 隆
	0x7ADC, KANJI_STANDARD,  // 竜
	0x9F8D, KANJI_STANDARD,  // 龍
	0x4FB6, KANJI_STANDARD,  // 侶
	0x616E, KANJI_STANDARD,  // 慮
	0x65C5, KANJI_STANDARD,  // 旅
	0x865C, KANJI_STANDARD,  // 虜
	0x4E86, KANJI_STANDARD,  // 了
	0x4EAE, KANJI_STANDARD,  // 亮
	0x50DA, KANJI_STANDARD,  // 僚
	0x4E21, KANJI_STANDARD,  // 両
	0x51CC, KANJI_STANDARD,  // 凌
	0x5BEE, KANJI_STANDARD,  // 寮
	0x6599, KANJI_STANDARD,  // 料
	0x6881, KANJI_STANDARD,  // 梁
	0x6DBC, KANJI_STANDARD,  // 涼
	0x731F, KANJI_STANDARD,  // 猟
	0x7642, KANJI_STANDARD,  // 療
	0x77AD, KANJI_STANDARD,  // 瞭
	0x7A1C, KANJI_STANDARD,  // 稜
	0x7CE7, KANJI_STANDARD,  // 糧
	0x826F, KANJI_STANDARD,  // 良
	0x8AD2, KANJI_STANDARD,  // 諒
	0x907C, KANJI_STANDARD,  // 遼
	0x91CF, KANJI_STANDARD,  // 量
	0x9675, KANJI_STANDARD,  // 陵
	0x9818, KANJI_STANDARD,  // 領
	0x529B, KANJI_STANDARD,  // 力
	0x7DD1, KANJI_STANDARD,  // 緑
	0x502B, KANJI_STANDARD,  // 倫
	0x5398, KANJI_STANDARD,  // 厘
	0x6797, KANJI_STANDARD,  // 林
	0x6DCB, KANJI_STANDARD,  // 淋
	0x71D0, KANJI_STANDARD,  // 燐
	0x7433, KANJI_STANDARD,  // 琳
	0x81E8, KANJI_STANDARD,  // 臨
	0x8F2A, KANJI_STANDARD,  // 輪
	0x96A3, KANJI_STANDARD,  // 隣
	0x9C57, KANJI_STANDARD,  // 鱗
	0x9E9F, KANJI_STANDARD,  // 麟
	0x7460, KANJI_STANDARD,  // 瑠
	0x5841, KANJI_STANDARD,  // 塁
	0x6D99, KANJI_STANDARD,  // 涙
	0x7D2F, KANJI_STANDARD,  // 累
	0x985E, KANJI_STANDARD,  // 類
	0x4EE4, KANJI_STANDARD,  // 令
	0x4F36, KANJI_STANDARD,  // 伶
	0x4F8B, KANJI_STANDARD,  // 例
	0x51B7, KANJI_STANDARD,  // 冷
	0x52B1, KANJI_STANDARD,  // 励
	0x5DBA, KANJI_STANDARD,  // 嶺
	0x601C, KANJI_STANDARD,  // 怜
	0x73B2, KANJI_STANDARD,  // 玲
	0x793C, KANJI_STANDARD,  // 礼
	0x82D3, KANJI_STANDARD,  // 苓
	0x9234, KANJI_STANDARD,  // 鈴
	0x96B7, KANJI_STANDARD,  // 隷
	0x96F6, KANJI_STANDARD,  // 零
	0x970A, KANJI_STANDARD,  // 霊
	0x9E97, KANJI_STANDARD,  // 麗
	0x9F62, KANJI_STANDARD,  // 齢
	0x66A6, KANJI_STANDARD,  // 暦
	0x6B74, KANJI_STANDARD,  // 歴
	0x5217, KANJI_STANDARD,  // 列
	0x52A3, KANJI_STANDARD,  // 劣
	0x70C8, KANJI_STANDARD,  // 烈
	0x88C2, KANJI_STANDARD,  // 裂
	0x5EC9, KANJI_STANDARD,  // 廉
	0x604B, KANJI_STANDARD,  // 恋
	0x6190, KANJI_STANDARD,  // 憐
	0x6F23, KANJI_STANDARD,  // 漣
	0x7149, KANJI_STANDARD,  // 煉
	0x7C3E, KANJI_STANDARD,  // 簾
	0x7DF4, KANJI_STANDARD,  // 練
	0x806F, KANJI_STANDARD,  // 聯
	0x84EE, KANJI_STANDARD,  // 蓮
	0x9023, KANJI_STANDARD,  // 連
	0x932C, KANJI_STANDARD,  // 錬
	0x5442, KANJI_STANDARD,  // 呂
	0x9B6F, KANJI_STANDARD,  // 魯
	0x6AD3, KANJI_STANDARD,  // 櫓
	0x7089, KANJI_STANDARD,  // 炉
	0x8CC2, KANJI_STANDARD,  // 賂
	0x8DEF, KANJI_STANDARD,  // 路
	0x9732, KANJI_STANDARD,  // 露
	0x52B4, KANJI_STANDARD,  // 労
	0x5A41, KANJI_STANDARD,  // 婁
	0x5ECA, KANJI_STANDARD,  // 廊
	0x5F04, KANJI_STANDARD,  // 弄
	0x6717, KANJI_STANDARD,  // 朗
	0x697C, KANJI_STANDARD,  // 楼
	0x6994, KANJI_STANDARD,  // 榔
	0x6D6A, KANJI_STANDARD,  // 浪
	0x6F0F, KANJI_STANDARD,  // 漏
	0x7262, KANJI_STANDARD,  // 牢
	0x72FC, KANJI_STANDARD,  // 狼
	0x7BED, KANJI_STANDARD,  // 篭
	0x8001, KANJI_STANDARD,  // 老
	0x807E, KANJI_STANDARD,  // 聾
	0x874B, KANJI_STANDARD,  // 蝋
	0x90CE, KANJI_STANDARD,  // 郎
	0x516D, KANJI_STANDARD,  // 六
	0x9E93, KANJI_STANDARD,  // 麓
	0x7984, KANJI_STANDARD,  // 禄
	0x808B, KANJI_STANDARD,  // 肋
	0x9332, KANJI_STANDARD,  // 録
	0x8AD6, KANJI_STANDARD,  // 論
	0x502D, KANJI_STANDARD,  // 倭
	0x548C, KANJI_STANDARD,  // 和
	0x8A71, KANJI_STANDARD,  // 話
	0x6B6A, KANJI_STANDARD,  // 歪
	0x8CC4, KANJI_STANDARD,  // 賄
	0x8107, KANJI_STANDARD,  // 脇
	0x60D1, KANJI_STANDARD,  // 惑
	0x67A0, KANJI_STANDARD,  // 枠
	0x9DF2, KANJI_STANDARD,  // 鷲
	0x4E99, KANJI_STANDARD,  // 亙
	0x4E98, KANJI_STANDARD,  // 亘
	0x9C10, KANJI_STANDARD,  // 鰐
	0x8A6B, KANJI_STANDARD,  // 詫
	0x85C1, KANJI_STANDARD,  // 藁
	0x8568, KANJI_STANDARD,  // 蕨
	0x6900, KANJI_STANDARD,  // 椀
	0x6E7E, KANJI_STANDARD,  // 湾
	0x7897, KANJI_STANDARD,  // 碗
	0x8155, KANJI_STANDARD,  // 腕
	0x5F0C, KANJI_STANDARD,  // 弌
	0x4E10, KANJI_STANDARD,  // 丐
	0x4E15, KANJI_STANDARD,  // 丕
	0x4E2A, KANJI_STANDARD,  // 个
	0x4E31, KANJI_STANDARD,  // 丱
	0x4E36, KANJI_STANDARD,  // 丶
	0x4E3C, KANJI_STANDARD,  // 丼
	0x4E3F, KANJI_STANDARD,  // 丿
	0x4E42, KANJI_STANDARD,  // 乂
	0x4E56, KANJI_STANDARD,  // 乖
	0x4E58, KANJI_STANDARD,  // 乘
	0x4E82, KANJI_STANDARD,  // 亂
	0x4E85, KANJI_STANDARD,  // 亅
	0x8C6B, KANJI_STANDARD,  // 豫
	0x4E8A, KANJI_STANDARD,  // 亊
	0x8212, KANJI_STANDARD,  // 舒
	0x5F0D, KANJI_STANDARD,  // 弍
	0x4E8E, KANJI_STANDARD,  // 于
	0x4E9E, KANJI_STANDARD,  // 亞
	0x4E9F, KANJI_STANDARD,  // 亟
	0x4EA0, KANJI_STANDARD,  // 亠
	0x4EA2, KANJI_STANDARD,  // 亢
	0x4EB0, KANJI_STANDARD,  // 亰
	0x4EB3, KANJI_STANDARD,  // 亳
	0x4EB6, KANJI_STANDARD,  // 亶
	0x4ECE, KANJI_STANDARD,  // 从
	0x4ECD, KANJI_STANDARD,  // 仍
	0x4EC4, KANJI_STANDARD,  // 仄
	0x4EC6, KANJI_STANDARD,  // 仆
	0x4EC2, KANJI_STANDARD,  // 仂
	0x4ED7, KANJI_STANDARD,  // 仗
	0x4EDE, KANJI_STANDARD,  // 仞
	0x4EED, KANJI_STANDARD,  // 仭
	0x4EDF, KANJI_STANDARD,  // 仟
	0x4EF7, KANJI_STANDARD,  // 价
	0x4F09, KANJI_STANDARD,  // 伉
	0x4F5A, KANJI_STANDARD,  // 佚
	0x4F30, KANJI_STANDARD,  // 估
	0x4F5B, KANJI_STANDARD,  // 佛
	0x4F5D, KANJI_STANDARD,  // 佝
	0x4F57, KANJI_STANDARD,  // 佗
	0x4F47, KANJI_STANDARD,  // 佇
	0x4F76, KANJI_STANDARD,  // 佶
	0x4F88, KANJI_STANDARD,  // 侈
	0x4F8F, KANJI_STANDARD,  // 侏
	0x4F98, KANJI_STANDARD,  // 侘
	0x4F7B, KANJI_STANDARD,  // 佻
	0x4F69, KANJI_STANDARD,  // 佩
	0x4F70, KANJI_STANDARD,  // 佰
	0x4F91, KANJI_STANDARD,  // 侑
	0x4F6F, KANJI_STANDARD,  // 佯
	0x4F86, KANJI_STANDARD,  // 來
	0x4F96, KANJI_STANDARD,  // 侖
	0x5118, KANJI_STANDARD,  // 儘
	0x4FD4, KANJI_STANDARD,  // 俔
	0x4FDF, KANJI_STANDARD,  // 俟
	0x4FCE, KANJI_STANDARD,  // 俎
	0x4FD8, KANJI_STANDARD,  // 俘
	0x4FDB, KANJI_STANDARD,  // 俛
	0x4FD1, KANJI_STANDARD,  // 俑
	0x4FDA, KANJI_STANDARD,  // 俚
	0x4FD0, KANJI_STANDARD,  // 俐
	0x4FE4, KANJI_STANDARD,  // 俤
	0x4FE5, KANJI_STANDARD,  // 俥
	0x501A, KANJI_STANDARD,  // 倚
	0x5028, KANJI_STANDARD,  // 倨
	0x5014, KANJI_STANDARD,  // 倔
	0x502A, KANJI_STANDARD,  // 倪
	0x5025, KANJI_STANDARD,  // 倥
	0x5005, KANJI_STANDARD,  // 倅
	0x4F1C, KANJI_STANDARD,  // 伜
	0x4FF6, KANJI_STANDARD,  // 俶
	0x5021, KANJI_STANDARD,  // 倡
	0x5029, KANJI_STANDARD,  // 倩
	0x502C, KANJI_STANDARD,  // 倬
	0x4FFE, KANJI_STANDARD,  // 俾
	0x4FEF, KANJI_STANDARD,  // 俯
	0x5011, KANJI_STANDARD,  // 們
	0x5006, KANJI_STANDARD,  // 倆
	0x5043, KANJI_STANDARD,  // 偃
	0x5047, KANJI_STANDARD,  // 假
	0x6703, KANJI_STANDARD,  // 會
	0x5055, KANJI_STANDARD,  // 偕
	0x5050, KANJI_STANDARD,  // 偐
	0x5048, KANJI_STANDARD,  // 偈
	0x505A, KANJI_STANDARD,  // 做
	0x5056, KANJI_STANDARD,  // 偖
	0x506C, KANJI_STANDARD,  // 偬
	0x5078, KANJI_STANDARD,  // 偸
	0x5080, KANJI_STANDARD,  // 傀
	0x509A, KANJI_STANDARD,  // 傚
	0x5085, KANJI_STANDARD,  // 傅
	0x50B4, KANJI_STANDARD,  // 傴
	0x50B2, KANJI_STANDARD,  // 傲
	0x50C9, KANJI_STANDARD,  // 僉
	0x50CA, KANJI_STANDARD,  // 僊
	0x50B3, KANJI_STANDARD,  // 傳
	0x50C2, KANJI_STANDARD,  // 僂
	0x50D6, KANJI_STANDARD,  // 僖
	0x50DE, KANJI_STANDARD,  // 僞
	0x50E5, KANJI_STANDARD,  // 僥
	0x50ED, KANJI_STANDARD,  // 僭
	0x50E3, KANJI_STANDARD,  // 僣
	0x50EE, KANJI_STANDARD,  // 僮
	0x50F9, KANJI_STANDARD,  // 價
	0x50F5, KANJI_STANDARD,  // 僵
	0x5109, KANJI_STANDARD,  // 儉
	0x5101, KANJI_STANDARD,  // 儁
	0x5102, KANJI_STANDARD,  // 儂
	0x5116, KANJI_STANDARD,  // 儖
	0x5115, KANJI_STANDARD,  // 儕
	0x5114, KANJI_STANDARD,  // 儔
	0x511A, KANJI_STANDARD,  // 儚
	0x5121, KANJI_STANDARD,  // 儡
	0x513A, KANJI_STANDARD,  // 儺
	0x5137, KANJI_STANDARD,  // 儷
	0x513C, KANJI_STANDARD,  // 儼
	0x513B, KANJI_STANDARD,  // 儻
	0x513F, KANJI_STANDARD,  // 儿
	0x5140, KANJI_STANDARD,  // 兀
	0x5152, KANJI_STANDARD,  // 兒
	0x514C, KANJI_STANDARD,  // 兌
	0x5154, KANJI_STANDARD,  // 兔
	0x5162, KANJI_STANDARD,  // 兢
	0x7AF8, KANJI_STANDARD,  // 竸
	0x5169, KANJI_STANDARD,  // 兩
	0x516A, KANJI_STANDARD,  // 兪
	0x516E, KANJI_STANDARD,  // 兮
	0x5180, KANJI_STANDARD,  // 冀
	0x5182, KANJI_STANDARD,  // 冂
	0x56D8, KANJI_STANDARD,  // 囘
	0x518C, KANJI_STANDARD,  // 册
	0x5189, KANJI_STANDARD,  // 冉
	0x518F, KANJI_STANDARD,  // 冏
	0x5191, KANJI_STANDARD,  // 冑
	0x5193, KANJI_STANDARD,  // 冓
	0x5195, KANJI_STANDARD,  // 冕
	0x5196, KANJI_STANDARD,  // 冖
	0x51A4, KANJI_STANDARD,  // 冤
	0x51A6, KANJI_STANDARD,  // 冦
	0x51A2, KANJI_STANDARD,  // 冢
	0x51A9, KANJI_STANDARD,  // 冩
	0x51AA, KANJI_STANDARD,  // 冪
	0x51AB, KANJI_STANDARD,  // 冫
	0x51B3, KANJI_STANDARD,  // 决
	0x51B1, KANJI_STANDARD,  // 冱
	0x51B2, KANJI_STANDARD,  // 冲
	0x51B0, KANJI_STANDARD,  // 冰
	0x51B5, KANJI_STANDARD,  // 况
	0x51BD, KANJI_STANDARD,  // 冽
	0x51C5, KANJI_STANDARD,  // 凅
	0x51C9, KANJI_STANDARD,  // 凉
	0x51DB, KANJI_STANDARD,  // 凛
	0x51E0, KANJI_STANDARD,  // 几
	0x8655, KANJI_STANDARD,  // 處
	0x51E9, KANJI_STANDARD,  // 凩
	0x51ED, KANJI_STANDARD,  // 凭
	0x51F0, KANJI_STANDARD,  // 凰
	0x51F5, KANJI_STANDARD,  // 凵
	0x51FE, KANJI_STANDARD,  // 凾
	0x5204, KANJI_STANDARD,  // 刄
	0x520B, KANJI_STANDARD,  // 刋
	0x5214, KANJI_STANDARD,  // 刔
	0x520E, KANJI_STANDARD,  // 刎
	0x5227, KANJI_STANDARD,  // 刧
	0x522A, KANJI_STANDARD,  // 刪
	0x522E, KANJI_STANDARD,  // 刮
	0x5233, KANJI_STANDARD,  // 刳
	0x5239, KANJI_STANDARD,  // 刹
	0x524F, KANJI_STANDARD,  // 剏
	0x5244, KANJI_STANDARD,  // 剄
	0x524B, KANJI_STANDARD,  // 剋
	0x524C, KANJI_STANDARD,  // 剌
	0x525E, KANJI_STANDARD,  // 剞
	0x5254, KANJI_STANDARD,  // 剔
	0x526A, KANJI_STANDARD,  // 剪
	0x5274, KANJI_STANDARD,  // 剴
	0x5269, KANJI_STANDARD,  // 剩
	0x5273, KANJI_STANDARD,  // 剳
	0x527F, KANJI_STANDARD,  // 剿
	0x527D, KANJI_STANDARD,  // 剽
	0x528D, KANJI_STANDARD,  // 劍
	0x5294, KANJI_STANDARD,  // 劔
	0x5292, KANJI_STANDARD,  // 劒
	0x5271, KANJI_STANDARD,  // 剱
	0x5288, KANJI_STANDARD,  // 劈
	0x5291, KANJI_STANDARD,  // 劑
	0x8FA8, KANJI_STANDARD,  // 辨
	0x8FA7, KANJI_STANDARD,  // 辧
	0x52AC, KANJI_STANDARD,  // 劬
	0x52AD, KANJI_STANDARD,  // 劭
	0x52BC, KANJI_STANDARD,  // 劼
	0x52B5, KANJI_STANDARD,  // 劵
	0x52C1, KANJI_STANDARD,  // 勁
	0x52CD, KANJI_STANDARD,  // 勍
	0x52D7, KANJI_STANDARD,  // 勗
	0x52DE, KANJI_STANDARD,  // 勞
	0x52E3, KANJI_STANDARD,  // 勣
	0x52E6, KANJI_STANDARD,  // 勦
	0x98ED, KANJI_STANDARD,  // 飭
	0x52E0, KANJI_STANDARD,  // 勠
	0x52F3, KANJI_STANDARD,  // 勳
	0x52F5, KANJI_STANDARD,  // 勵
	0x52F8, KANJI_STANDARD,  // 勸
	0x52F9, KANJI_STANDARD,  // 勹
	0x5306, KANJI_STANDARD,  // 匆
	0x5308, KANJI_STANDARD,  // 匈
	0x7538, KANJI_STANDARD,  // 甸
	0x530D, KANJI_STANDARD,  // 匍
	0x5310, KANJI_STANDARD,  // 匐
	0x530F, KANJI_STANDARD,  // 匏
	0x5315, KANJI_STANDARD,  // 匕
	0x531A, KANJI_STANDARD,  // 匚
	0x5323, KANJI_STANDARD,  // 匣
	0x532F, KANJI_STANDARD,  // 匯
	0x5331, KANJI_STANDARD,  // 匱
	0x5333, KANJI_STANDARD,  // 匳
	0x5338, KANJI_STANDARD,  // 匸
	0x5340, KANJI_STANDARD,  // 區
	0x5346, KANJI_STANDARD,  // 卆
	0x5345, KANJI_STANDARD,  // 卅
	0x4E17, KANJI_STANDARD,  // 丗
	0x5349, KANJI_STANDARD,  // 卉
	0x534D, KANJI_STANDARD,  // 卍
	0x51D6, KANJI_STANDARD,  // 凖
	0x535E, KANJI_STANDARD,  // 卞
	0x5369, KANJI_STANDARD,  // 卩
	0x536E, KANJI_STANDARD,  // 卮
	0x5918, KANJI_STANDARD,  // 夘
	0x537B, KANJI_STANDARD,  // 卻
	0x5377, KANJI_STANDARD,  // 卷
	0x5382, KANJI_STANDARD,  // 厂
	0x5396, KANJI_STANDARD,  // 厖
	0x53A0, KANJI_STANDARD,  // 厠
	0x53A6, KANJI_STANDARD,  // 厦
	0x53A5, KANJI_STANDARD,  // 厥
	0x53AE, KANJI_STANDARD,  // 厮
	0x53B0, KANJI_STANDARD,  // 厰
	0x53B6, KANJI_STANDARD,  // 厶
	0x53C3, KANJI_STANDARD,  // 參
	0x7C12, KANJI_STANDARD,  // 簒
	0x96D9, KANJI_STANDARD,  // 雙
	0x53DF, KANJI_STANDARD,  // 叟
	0x66FC, KANJI_STANDARD,  // 曼
	0x71EE, KANJI_STANDARD,  // 燮
	0x53EE, KANJI_STANDARD,  // 叮
	0x53E8, KANJI_STANDARD,  // 叨
	0x53ED, KANJI_STANDARD,  // 叭
	0x53FA, KANJI_STANDARD,  // 叺
	0x5401, KANJI_STANDARD,  // 吁
	0x543D, KANJI_STANDARD,  // 吽
	0x5440, KANJI_STANDARD,  // 呀
	0x542C, KANJI_STANDARD,  // 听
	0x542D, KANJI_STANDARD,  // 吭
	0x543C, KANJI_STANDARD,  // 吼
	0x542E, KANJI_STANDARD,  // 吮
	0x5436, KANJI_STANDARD,  // 吶
	0x5429, KANJI_STANDARD,  // 吩
	0x541D, KANJI_STANDARD,  // 吝
	0x544E, KANJI_STANDARD,  // 呎
	0x548F, KANJI_STANDARD,  // 咏
	0x5475, KANJI_STANDARD,  // 呵
	0x548E, KANJI_STANDARD,  // 咎
	0x545F, KANJI_STANDARD,  // 呟
	0x5471, KANJI_STANDARD,  // 呱
	0x5477, KANJI_STANDARD,  // 呷
	0x5470, KANJI_STANDARD,  // 呰
	0x5492, KANJI_STANDARD,  // 咒
	0x547B, KANJI_STANDARD,  // 呻
	0x5480, KANJI_STANDARD,  // 咀
	0x5476, KANJI_STANDARD,  // 呶
	0x5484, KANJI_STANDARD,  // 咄
	0x5490, KANJI_STANDARD,  // 咐
	0x5486, KANJI_STANDARD,  // 咆
	0x54C7, KANJI_STANDARD,  // 哇
	0x54A2, KANJI_STANDARD,  // 咢
	0x54B8, KANJI_STANDARD,  // 咸
	0x54A5, KANJI_STANDARD,  // 咥
	0x54AC, KANJI_STANDARD,  // 咬
	0x54C4, KANJI_STANDARD,  // 哄
	0x54C8, KANJI_STANDARD,  // 哈
	0x54A8, KANJI_STANDARD,  // 咨
	0x54AB, KANJI_STANDARD,  // 咫
	0x54C2, KANJI_STANDARD,  // 哂
	0x54A4, KANJI_STANDARD,  // 咤
	0x54BE, KANJI_STANDARD,  // 咾
	0x54BC, KANJI_STANDARD,  // 咼
	0x54D8, KANJI_STANDARD,  // 哘
	0x54E5, KANJI_STANDARD,  // 哥
	0x54E6, KANJI_STANDARD,  // 哦
	0x550F, KANJI_STANDARD,  // 唏
	0x5514, KANJI_STANDARD,  // 唔
	0x54FD, KANJI_STANDARD,  // 哽
	0x54EE, KANJI_STANDARD,  // 哮
	0x54ED, KANJI_STANDARD,  // 哭
	0x54FA, KANJI_STANDARD,  // 哺
	0x54E2, KANJI_STANDARD,  // 哢
	0x5539, KANJI_STANDARD,  // 唹
	0x5540, KANJI_STANDARD,  // 啀
	0x5563, KANJI_STANDARD,  // 啣
	0x554C, KANJI_STANDARD,  // 啌
	0x552E, KANJI_STANDARD,  // 售
	0x555C, KANJI_STANDARD,  // 啜
	0x5545, KANJI_STANDARD,  // 啅
	0x5556, KANJI_STANDARD,  // 啖
	0x5557, KANJI_STANDARD,  // 啗
	0x5538, KANJI_STANDARD,  // 唸
	0x5533, KANJI_STANDARD,  // 唳
	0x555D, KANJI_STANDARD,  // 啝
	0x5599, KANJI_STANDARD,  // 喙
	0x5580, KANJI_STANDARD,  // 喀
	0x54AF, KANJI_STANDARD,  // 咯
	0x558A, KANJI_STANDARD,  // 喊
	0x559F, KANJI_STANDARD,  // 喟
	0x557B, KANJI_STANDARD,  // 啻
	0x557E, KANJI_STANDARD,  // 啾
	0x5598, KANJI_STANDARD,  // 喘
	0x559E, KANJI_STANDARD,  // 喞
	0x55AE, KANJI_STANDARD,  // 單
	0x557C, KANJI_STANDARD,  // 啼
	0x5583, KANJI_STANDARD,  // 喃
	0x55A9, KANJI_STANDARD,  // 喩
	0x5587, KANJI_STANDARD,  // 喇
	0x55A8, KANJI_STANDARD,  // 喨
	0x55DA, KANJI_STANDARD,  // 嗚
	0x55C5, KANJI_STANDARD,  // 嗅
	0x55DF, KANJI_STANDARD,  // 嗟
	0x55C4, KANJI_STANDARD,  // 嗄
	0x55DC, KANJI_STANDARD,  // 嗜
	0x55E4, KANJI_STANDARD,  // 嗤
	0x55D4, KANJI_STANDARD,  // 嗔
	0x5614, KANJI_STANDARD,  // 嘔
	0x55F7, KANJI_STANDARD,  // 嗷
	0x5616, KANJI_STANDARD,  // 嘖
	0x55FE, KANJI_STANDARD,  // 嗾
	0x55FD, KANJI_STANDARD,  // 嗽
	0x561B, KANJI_STANDARD,  // 嘛
	0x55F9, KANJI_STANDARD,  // 嗹
	0x564E, KANJI_STANDARD,  // 噎
	0x5650, KANJI_STANDARD,  // 噐
	0x71DF, KANJI_STANDARD,  // 營
	0x5634, KANJI_STANDARD,  // 嘴
	0x5636, KANJI_STANDARD,  // 嘶
	0x5632, KANJI_STANDARD,  // 嘲
	0x5638, KANJI_STANDARD,  // 嘸
	0x566B, KANJI_STANDARD,  // 噫
	0x5664, KANJI_STANDARD,  // 噤
	0x562F, KANJI_STANDARD,  // 嘯
	0x566C, KANJI_STANDARD,  // 噬
	0x566A, KANJI_STANDARD,  // 噪
	0x5686, KANJI_STANDARD,  // 嚆
	0x5680, KANJI_STANDARD,  // 嚀
	0x568A, KANJI_STANDARD,  // 嚊
	0x56A0, KANJI_STANDARD,  // 嚠
	0x5694, KANJI_STANDARD,  // 嚔
	0x568F, KANJI_STANDARD,  // 嚏
	0x56A5, KANJI_STANDARD,  // 嚥
	0x56AE, KANJI_STANDARD,  // 嚮
	0x56B6, KANJI_STANDARD,  // 嚶
	0x56B4, KANJI_STANDARD,  // 嚴
	0x56C2, KANJI_STANDARD,  // 囂
	0x56BC, KANJI_STANDARD,  // 嚼
	0x56C1, KANJI_STANDARD,  // 囁
	0x56C3, KANJI_STANDARD,  // 囃
	0x56C0, KANJI_STANDARD,  // 囀
	0x56C8, KANJI_STANDARD,  // 囈
	0x56CE, KANJI_STANDARD,  // 囎
	0x56D1, KANJI_STANDARD,  // 囑
	0x56D3, KANJI_STANDARD,  // 囓
	0x56D7, KANJI_STANDARD,  // 囗
	0x56EE, KANJI_STANDARD,  // 囮
	0x56F9, KANJI_STANDARD,  // 囹
	0x5700, KANJI_STANDARD,  // 圀
	0x56FF, KANJI_STANDARD,  // 囿
	0x5704, KANJI_STANDARD,  // 圄
	0x5709, KANJI_STANDARD,  // 圉
	0x5708, KANJI_STANDARD,  // 圈
	0x570B, KANJI_STANDARD,  // 國
	0x570D, KANJI_STANDARD,  // 圍
	0x5713, KANJI_STANDARD,  // 圓
	0x5718, KANJI_STANDARD,  // 團
	0x5716, KANJI_STANDARD,  // 圖
	0x55C7, KANJI_STANDARD,  // 嗇
	0x571C, KANJI_STANDARD,  // 圜
	0x5726, KANJI_STANDARD,  // 圦
	0x5737, KANJI_STANDARD,  // 圷
	0x5738, KANJI_STANDARD,  // 圸
	0x574E, KANJI_STANDARD,  // 坎
	0x573B, KANJI_STANDARD,  // 圻
	0x5740, KANJI_STANDARD,  // 址
	0x574F, KANJI_STANDARD,  // 坏
	0x5769, KANJI_STANDARD,  // 坩
	0x57C0, KANJI_STANDARD,  // 埀
	0x5788, KANJI_STANDARD,  // 垈
	0x5761, KANJI_STANDARD,  // 坡
	0x577F, KANJI_STANDARD,  // 坿
	0x5789, KANJI_STANDARD,  // 垉
	0x5793, KANJI_STANDARD,  // 垓
	0x57A0, KANJI_STANDARD,  // 垠
	0x57B3, KANJI_STANDARD,  // 垳
	0x57A4, KANJI_STANDARD,  // 垤
	0x57AA, KANJI_STANDARD,  // 垪
	0x57B0, KANJI_STANDARD,  // 垰
	0x57C3, KANJI_STANDARD,  // 埃
	0x57C6, KANJI_STANDARD,  // 埆
	0x57D4, KANJI_STANDARD,  // 埔
	0x57D2, KANJI_STANDARD,  // 埒
	0x57D3, KANJI_STANDARD,  // 埓
	0x580A, KANJI_STANDARD,  // 堊
	0x57D6, KANJI_STANDARD,  // 埖
	0x57E3, KANJI_STANDARD,  // 埣
	0x580B, KANJI_STANDARD,  // 堋
	0x5819, KANJI_STANDARD,  // 堙
	0x581D, KANJI_STANDARD,  // 堝
	0x5872, KANJI_STANDARD,  // 塲
	0x5821, KANJI_STANDARD,  // 堡
	0x5862, KANJI_STANDARD,  // 塢
	0x584B, KANJI_STANDARD,  // 塋
	0x5870, KANJI_STANDARD,  // 塰
	0x6BC0, KANJI_STANDARD,  // 毀
	0x5852, KANJI_STANDARD,  // 塒
	0x583D, KANJI_STANDARD,  // 堽
	0x5879, KANJI_STANDARD,  // 塹
	0x5885, KANJI_STANDARD,  // 墅
	0x58B9, KANJI_STANDARD,  // 墹
	0x589F, KANJI_STANDARD,  // 墟
	0x58AB, KANJI_STANDARD,  // 墫
	0x58BA, KANJI_STANDARD,  // 墺
	0x58DE, KANJI_STANDARD,  // 壞
	0x58BB, KANJI_STANDARD,  // 墻
	0x58B8, KANJI_STANDARD,  // 墸
	0x58AE, KANJI_STANDARD,  // 墮
	0x58C5, KANJI_STANDARD,  // 壅
	0x58D3, KANJI_STANDARD,  // 壓
	0x58D1, KANJI_STANDARD,  // 壑
	0x58D7, KANJI_STANDARD,  // 壗
	0x58D9, KANJI_STANDARD,  // 壙
	0x58D8, KANJI_STANDARD,  // 壘
	0x58E5, KANJI_STANDARD,  // 壥
	0x58DC, KANJI_STANDARD,  // 壜
	0x58E4, KANJI_STANDARD,  // 壤
	0x58DF, KANJI_STANDARD,  // 壟
	0x58EF, KANJI_STANDARD,  // 壯
	0x58FA, KANJI_STANDARD,  // 壺
	0x58F9, KANJI_STANDARD,  // 壹
	0x58FB, KANJI_STANDARD,  // 壻
	0x58FC, KANJI_STANDARD,  // 壼
	0x58FD, KANJI_STANDARD,  // 壽
	0x5902, KANJI_STANDARD,  // 夂
	0x590A, KANJI_STANDARD,  // 夊
	0x5910, KANJI_STANDARD,  // 夐
	0x591B, KANJI_STANDARD,  // 夛
	0x68A6, KANJI_STANDARD,  // 梦
	0x5925, KANJI_STANDARD,  // 夥
	0x592C, KANJI_STANDARD,  // 夬
	0x592D, KANJI_STANDARD,  // 夭
	0x5932, KANJI_STANDARD,  // 夲
	0x5938, KANJI_STANDARD,  // 夸
	0x593E, KANJI_STANDARD,  // 夾
	0x7AD2, KANJI_STANDARD,  // 竒
	0x5955, KANJI_STANDARD,  // 奕
	0x5950, KANJI_STANDARD,  // 奐
	0x594E, KANJI_STANDARD,  // 奎
	0x595A, KANJI_STANDARD,  // 奚
	0x5958, KANJI_STANDARD,  // 奘
	0x5962, KANJI_STANDARD,  // 奢
	0x5960, KANJI_STANDARD,  // 奠
	0x5967, KANJI_STANDARD,  // 奧
	0x596C, KANJI_STANDARD,  // 奬
	0x5969, KANJI_STANDARD,  // 奩
	0x5978, KANJI_STANDARD,  // 奸
	0x5981, KANJI_STANDARD,  // 妁
	0x599D, KANJI_STANDARD,  // 妝
	0x4F5E, KANJI_STANDARD,  // 佞
	0x4FAB, KANJI_STANDARD,  // 侫
	0x59A3, KANJI_STANDARD,  // 妣
	0x59B2, KANJI_STANDARD,  // 妲
	0x59C6, KANJI_STANDARD,  // 姆
	0x59E8, KANJI_STANDARD,  // 姨
	0x59DC, KANJI_STANDARD,  // 姜
	0x598D, KANJI_STANDARD,  // 妍
	0x59D9, KANJI_STANDARD,  // 姙
	0x59DA, KANJI_STANDARD,  // 姚
	0x5A25, KANJI_STANDARD,  // 娥
	0x5A1F, KANJI_STANDARD,  // 娟
	0x5A11, KANJI_STANDARD,  // 娑
	0x5A1C, KANJI_STANDARD,  // 娜
	0x5A09, KANJI_STANDARD,  // 娉
	0x5A1A, KANJI_STANDARD,  // 娚
	0x5A40, KANJI_STANDARD,  // 婀
	0x5A6C, KANJI_STANDARD,  // 婬
	0x5A49, KANJI_STANDARD,  // 婉
	0x5A35, KANJI_STANDARD,  // 娵
	0x5A36, KANJI_STANDARD,  // 娶
	0x5A62, KANJI_STANDARD,  // 婢
	0x5A6A, KANJI_STANDARD,  // 婪
	0x5A9A, KANJI_STANDARD,  // 媚
	0x5ABC, KANJI_STANDARD,  // 媼
	0x5ABE, KANJI_STANDARD,  // 媾
	0x5ACB, KANJI_STANDARD,  // 嫋
	0x5AC2, KANJI_STANDARD,  // 嫂
	0x5ABD, KANJI_STANDARD,  // 媽
	0x5AE3, KANJI_STANDARD,  // 嫣
	0x5AD7, KANJI_STANDARD,  // 嫗
	0x5AE6, KANJI_STANDARD,  // 嫦
	0x5AE9, KANJI_STANDARD,  // 嫩
	0x5AD6, KANJI_STANDARD,  // 嫖
	0x5AFA, KANJI_STANDARD,  // 嫺
	0x5AFB, KANJI_STANDARD,  // 嫻
	0x5B0C, KANJI_STANDARD,  // 嬌
	0x5B0B, KANJI_STANDARD,  // 嬋
	0x5B16, KANJI_STANDARD,  // 嬖
	0x5B32, KANJI_STANDARD,  // 嬲
	0x5AD0, KANJI_STANDARD,  // 嫐
	0x5B2A, KANJI_STANDARD,  // 嬪
	0x5B36, KANJI_STANDARD,  // 嬶
	0x5B3E, KANJI_STANDARD,  // 嬾
	0x5B43, KANJI_STANDARD,  // 孃
	0x5B45, KANJI_STANDARD,  // 孅
	0x5B40, KANJI_STANDARD,  // 孀
	0x5B51, KANJI_STANDARD,  // 孑
	0x5B55, KANJI_STANDARD,  // 孕
	0x5B5A, KANJI_STANDARD,  // 孚
	0x5B5B, KANJI_STANDARD,  // 孛
	0x5B65, KANJI_STANDARD,  // 孥
	0x5B69, KANJI_STANDARD,  // 孩
	0x5B70, KANJI_STANDARD,  // 孰
	0x5B73, KANJI_STANDARD,  // 孳
	0x5B75, KANJI_STANDARD,  // 孵
	0x5B78, KANJI_STANDARD,  // 學
	0x6588, KANJI_STANDARD,  // 斈
	0x5B7A, KANJI_STANDARD,  // 孺
	0x5B80, KANJI_STANDARD,  // 宀
	0x5B83, KANJI_STANDARD,  // 它
	0x5BA6, KANJI_STANDARD,  // 宦
	0x5BB8, KANJI_STANDARD,  // 宸
	0x5BC3, KANJI_STANDARD,  // 寃
	0x5BC7, KANJI_STANDARD,  // 寇
	0x5BC9, KANJI_STANDARD,  // 寉
	0x5BD4, KANJI_STANDARD,  // 寔
	0x5BD0, KANJI_STANDARD,  // 寐
	0x5BE4, KANJI_STANDARD,  // 寤
	0x5BE6, KANJI_STANDARD,  // 實
	0x5BE2, KANJI_STANDARD,  // 寢
	0x5BDE, KANJI_STANDARD,  // 寞
	0x5BE5, KANJI_STANDARD,  // 寥
	0x5BEB, KANJI_STANDARD,  // 寫
	0x5BF0, KANJI_STANDARD,  // 寰
	0x5BF6, KANJI_STANDARD,  // 寶
	0x5BF3, KANJI_STANDARD,  // 寳
	0x5C05, KANJI_STANDARD,  // 尅
	0x5C07, KANJI_STANDARD,  // 將
	0x5C08, KANJI_STANDARD,  // 專
	0x5C0D, KANJI_STANDARD,  // 對
	0x5C13, KANJI_STANDARD,  // 尓
	0x5C20, KANJI_STANDARD,  // 尠
	0x5C22, KANJI_STANDARD,  // 尢
	0x5C28, KANJI_STANDARD,  // 尨
	0x5C38, KANJI_STANDARD,  // 尸
	0x5C39, KANJI_STANDARD,  // 尹
	0x5C41, KANJI_STANDARD,  // 屁
	0x5C46, KANJI_STANDARD,  // 屆
	0x5C4E, KANJI_STANDARD,  // 屎
	0x5C53, KANJI_STANDARD,  // 屓
	0x5C50, KANJI_STANDARD,  // 屐
	0x5C4F, KANJI_STANDARD,  // 屏
	0x5B71, KANJI_STANDARD,  // 孱
	0x5C6C, KANJI_STANDARD,  // 屬
	0x5C6E, KANJI_STANDARD,  // 屮
	0x4E62, KANJI_STANDARD,  // 乢
	0x5C76, KANJI_STANDARD,  // 屶
	0x5C79, KANJI_STANDARD,  // 屹
	0x5C8C, KANJI_STANDARD,  // 岌
	0x5C91, KANJI_STANDARD,  // 岑
	0x5C94, KANJI_STANDARD,  // 岔
	0x599B, KANJI_STANDARD,  // 妛
	0x5CAB, KANJI_STANDARD,  // 岫
	0x5CBB, KANJI_STANDARD,  // 岻
	0x5CB6, KANJI_STANDARD,  // 岶
	0x5CBC, KANJI_STANDARD,  // 岼
	0x5CB7, KANJI_STANDARD,  // 岷
	0x5CC5, KANJI_STANDARD,  // 峅
	0x5CBE, KANJI_STANDARD,  // 岾
	0x5CC7, KANJI_STANDARD,  // 峇
	0x5CD9, KANJI_STANDARD,  // 峙
	0x5CE9, KANJI_STANDARD,  // 峩
	0x5CFD, KANJI_STANDARD,  // 峽
	0x5CFA, KANJI_STANDARD,  // 峺
	0x5CED, KANJI_STANDARD,  // 峭
	0x5D8C, KANJI_STANDARD,  // 嶌
	0x5CEA, KANJI_STANDARD,  // 峪
	0x5D0B, KANJI_STANDARD,  // 崋
	0x5D15, KANJI_STANDARD,  // 崕
	0x5D17, KANJI_STANDARD,  // 崗
	0x5D5C, KANJI_STANDARD,  // 嵜
	0x5D1F, KANJI_STANDARD,  // 崟
	0x5D1B, KANJI_STANDARD,  // 崛
	0x5D11, KANJI_STANDARD,  // 崑
	0x5D14, KANJI_STANDARD,  // 崔
	0x5D22, KANJI_STANDARD,  // 崢
	0x5D1A, KANJI_STANDARD,  // 崚
	0x5D19, KANJI_STANDARD,  // 崙
	0x5D18, KANJI_STANDARD,  // 崘
	0x5D4C, KANJI_STANDARD,  // 嵌
	0x5D52, KANJI_STANDARD,  // 嵒
	0x5D4E, KANJI_STANDARD,  // 嵎
	0x5D4B, KANJI_STANDARD,  // 嵋
	0x5D6C, KANJI_STANDARD,  // 嵬
	0x5D73, KANJI_STANDARD,  // 嵳
	0x5D76, KANJI_STANDARD,  // 嵶
	0x5D87, KANJI_STANDARD,  // 嶇
	0x5D84, KANJI_STANDARD,  // 嶄
	0x5D82, KANJI_STANDARD,  // 嶂
	0x5DA2, KANJI_STANDARD,  // 嶢
	0x5D9D, KANJI_STANDARD,  // 嶝
	0x5DAC, KANJI_STANDARD,  // 嶬
	0x5DAE, KANJI_STANDARD,  // 嶮
	0x5DBD, KANJI_STANDARD,  // 嶽
	0x5D90, KANJI_STANDARD,  // 嶐
	0x5DB7, KANJI_STANDARD,  // 嶷
	0x5DBC, KANJI_STANDARD,  // 嶼
	0x5DC9, KANJI_STANDARD,  // 巉
	0x5DCD, KANJI_STANDARD,  // 巍
	0x5DD3, KANJI_STANDARD,  // 巓
	0x5DD2, KANJI_STANDARD,  // 巒
	0x5DD6, KANJI_STANDARD,  // 巖
	0x5DDB, KANJI_STANDARD,  // 巛
	0x5DEB, KANJI_STANDARD,  // 巫
	0x5DF2, KANJI_STANDARD,  // 已
	0x5DF5, KANJI_STANDARD,  // 巵
	0x5E0B, KANJI_STANDARD,  // 帋
	0x5E1A, KANJI_STANDARD,  // 帚
	0x5E19, KANJI_STANDARD,  // 帙
	0x5E11, KANJI_STANDARD,  // 帑
	0x5E1B, KANJI_STANDARD,  // 帛
	0x5E36, KANJI_STANDARD,  // 帶
	0x5E37, KANJI_STANDARD,  // 帷
	0x5E44, KANJI_STANDARD,  // 幄
	0x5E43, KANJI_STANDARD,  // 幃
	0x5E40, KANJI_STANDARD,  // 幀
	0x5E4E, KANJI_STANDARD,  // 幎
	0x5E57, KANJI_STANDARD,  // 幗
	0x5E54, KANJI_STANDARD,  // 幔
	0x5E5F, KANJI_STANDARD,  // 幟
	0x5E62, KANJI_STANDARD,  // 幢
	0x5E64, KANJI_STANDARD,  // 幤
	0x5E47, KANJI_STANDARD,  // 幇
	0x5E75, KANJI_STANDARD,  // 幵
	0x5E76, KANJI_STANDARD,  // 并
	0x5E7A, KANJI_STANDARD,  // 幺
	0x9EBC, KANJI_STANDARD,  // 麼
	0x5E7F, KANJI_STANDARD,  // 广
	0x5EA0, KANJI_STANDARD,  // 庠
	0x5EC1, KANJI_STANDARD,  // 廁
	0x5EC2, KANJI_STANDARD,  // 廂
	0x5EC8, KANJI_STANDARD,  // 廈
	0x5ED0, KANJI_STANDARD,  // 廐
	0x5ECF, KANJI_STANDARD,  // 廏
	0x5ED6, KANJI_STANDARD,  // 廖
	0x5EE3, KANJI_STANDARD,  // 廣
	0x5EDD, KANJI_STANDARD,  // 廝
	0x5EDA, KANJI_STANDARD,  // 廚
	0x5EDB, KANJI_STANDARD,  // 廛
	0x5EE2, KANJI_STANDARD,  // 廢
	0x5EE1, KANJI_STANDARD,  // 廡
	0x5EE8, KANJI_STANDARD,  // 廨
	0x5EE9, KANJI_STANDARD,  // 廩
	0x5EEC, KANJI_STANDARD,  // 廬
	0x5EF1, KANJI_STANDARD,  // 廱
	0x5EF3, KANJI_STANDARD,  // 廳
	0x5EF0, KANJI_STANDARD,  // 廰
	0x5EF4, KANJI_STANDARD,  // 廴
	0x5EF8, KANJI_STANDARD,  // 廸
	0x5EFE, KANJI_STANDARD,  // 廾
	0x5F03, KANJI_STANDARD,  // 弃
	0x5F09, KANJI_STANDARD,  // 弉
	0x5F5D, KANJI_STANDARD,  // 彝
	0x5F5C, KANJI_STANDARD,  // 彜
	0x5F0B, KANJI_STANDARD,  // 弋
	0x5F11, KANJI_STANDARD,  // 弑
	0x5F16, KANJI_STANDARD,  // 弖
	0x5F29, KANJI_STANDARD,  // 弩
	0x5F2D, KANJI_STANDARD,  // 弭
	0x5F38, KANJI_STANDARD,  // 弸
	0x5F41, KANJI_STANDARD,  // 彁
	0x5F48, KANJI_STANDARD,  // 彈
	0x5F4C, KANJI_STANDARD,  // 彌
	0x5F4E, KANJI_STANDARD,  // 彎
	0x5F2F, KANJI_STANDARD,  // 弯
	0x5F51, KANJI_STANDARD,  // 彑
	0x5F56, KANJI_STANDARD,  // 彖
	0x5F57, KANJI_STANDARD,  // 彗
	0x5F59, KANJI_STANDARD,  // 彙
	0x5F61, KANJI_STANDARD,  // 彡
	0x5F6D, KANJI_STANDARD,  // 彭
	0x5F73, KANJI_STANDARD,  // 彳
	0x5F77, KANJI_STANDARD,  // 彷
	0x5F83, KANJI_STANDARD,  // 徃
	0x5F82, KANJI_STANDARD,  // 徂
	0x5F7F, KANJI_STANDARD,  // 彿
	0x5F8A, KANJI_STANDARD,  // 徊
	0x5F88, KANJI_STANDARD,  // 很
	0x5F91, KANJI_STANDARD,  // 徑
	0x5F87, KANJI_STANDARD,  // 徇
	0x5F9E, KANJI_STANDARD,  // 從
	0x5F99, KANJI_STANDARD,  // 徙
	0x5F98, KANJI_STANDARD,  // 徘
	0x5FA0, KANJI_STANDARD,  // 徠
	0x5FA8, KANJI_STANDARD,  // 徨
	0x5FAD, KANJI_STANDARD,  // 徭
	0x5FBC, KANJI_STANDARD,  // 徼
	0x5FD6, KANJI_STANDARD,  // 忖
	0x5FFB, KANJI_STANDARD,  // 忻
	0x5FE4, KANJI_STANDARD,  // 忤
	0x5FF8, KANJI_STANDARD,  // 忸
	0x5FF1, KANJI_STANDARD,  // 忱
	0x5FDD, KANJI_STANDARD,  // 忝
	0x60B3, KANJI_STANDARD,  // 悳
	0x5FFF, KANJI_STANDARD,  // 忿
	0x6021, KANJI_STANDARD,  // 怡
	0x6060, KANJI_STANDARD,  // 恠
	0x6019, KANJI_STANDARD,  // 怙
	0x6010, KANJI_STANDARD,  // 怐
	0x6029, KANJI_STANDARD,  // 怩
	0x600E, KANJI_STANDARD,  // 怎
	0x6031, KANJI_STANDARD,  // 怱
	0x601B, KANJI_STANDARD,  // 怛
	0x6015, KANJI_STANDARD,  // 怕
	0x602B, KANJI_STANDARD,  // 怫
	0x6026, KANJI_STANDARD,  // 怦
	0x600F, KANJI_STANDARD,  // 怏
	0x603A, KANJI_STANDARD,  // 怺
	0x605A, KANJI_STANDARD,  // 恚
	0x6041, KANJI_STANDARD,  // 恁
	0x606A, KANJI_STANDARD,  // 恪
	0x6077, KANJI_STANDARD,  // 恷
	0x605F, KANJI_STANDARD,  // 恟
	0x604A, KANJI_STANDARD,  // 恊
	0x6046, KANJI_STANDARD,  // 恆
	0x604D, KANJI_STANDARD,  // 恍
	0x6063, KANJI_STANDARD,  // 恣
	0x6043, KANJI_STANDARD,  // 恃
	0x6064, KANJI_STANDARD,  // 恤
	0x6042, KANJI_STANDARD,  // 恂
	0x606C, KANJI_STANDARD,  // 恬
	0x606B, KANJI_STANDARD,  // 恫
	0x6059, KANJI_STANDARD,  // 恙
	0x6081, KANJI_STANDARD,  // 悁
	0x608D, KANJI_STANDARD,  // 悍
	0x60E7, KANJI_STANDARD,  // 惧
	0x6083, KANJI_STANDARD,  // 悃
	0x609A, KANJI_STANDARD,  // 悚
	0x6084, KANJI_STANDARD,  // 悄
	0x609B, KANJI_STANDARD,  // 悛
	0x6096, KANJI_STANDARD,  // 悖
	0x6097, KANJI_STANDARD,  // 悗
	0x6092, KANJI_STANDARD,  // 悒
	0x60A7, KANJI_STANDARD,  // 悧
	0x608B, KANJI_STANDARD,  // 悋
	0x60E1, KANJI_STANDARD,  // 惡
	0x60B8, KANJI_STANDARD,  // 悸
	0x60E0, KANJI_STANDARD,  // 惠
	0x60D3, KANJI_STANDARD,  // 惓
	0x60B4, KANJI_STANDARD,  // 悴
	0x5FF0, KANJI_STANDARD,  // 忰
	0x60BD, KANJI_STANDARD,  // 悽
	0x60C6, KANJI_STANDARD,  // 惆
	0x60B5, KANJI_STANDARD,  // 悵
	0x60D8, KANJI_STANDARD,  // 惘
	0x614D, KANJI_STANDARD,  // 慍
	0x6115, KANJI_STANDARD,  // 愕
	0x6106, KANJI_STANDARD,  // 愆
	0x60F6, KANJI_STANDARD,  // 惶
	0x60F7, KANJI_STANDARD,  // 惷
	0x6100, KANJI_STANDARD,  // 愀
	0x60F4, KANJI_STANDARD,  // 惴
	0x60FA, KANJI_STANDARD,  // 惺
	0x6103, KANJI_STANDARD,  // 愃
	0x6121, KANJI_STANDARD,  // 愡
	0x60FB, KANJI_STANDARD,  // 惻
	0x60F1, KANJI_STANDARD,  // 惱
	0x610D, KANJI_STANDARD,  // 愍
	0x610E, KANJI_STANDARD,  // 愎
	0x6147, KANJI_STANDARD,  // 慇
	0x613E, KANJI_STANDARD,  // 愾
	0x6128, KANJI_STANDARD,  // 愨
	0x6127, KANJI_STANDARD,  // 愧
	0x614A, KANJI_STANDARD,  // 慊
	0x613F, KANJI_STANDARD,  // 愿
	0x613C, KANJI_STANDARD,  // 愼
	0x612C, KANJI_STANDARD,  // 愬
	0x6134, KANJI_STANDARD,  // 愴
	0x613D, KANJI_STANDARD,  // 愽
	0x6142, KANJI_STANDARD,  // 慂
	0x6144, KANJI_STANDARD,  // 慄
	0x6173, KANJI_STANDARD,  // 慳
	0x6177, KANJI_STANDARD,  // 慷
	0x6158, KANJI_STANDARD,  // 慘
	0x6159, KANJI_STANDARD,  // 慙
	0x615A, KANJI_STANDARD,  // 慚
	0x616B, KANJI_STANDARD,  // 慫
	0x6174, KANJI_STANDARD,  // 慴
	0x616F, KANJI_STANDARD,  // 慯
	0x6165, KANJI_STANDARD,  // 慥
	0x6171, KANJI_STANDARD,  // 慱
	0x615F, KANJI_STANDARD,  // 慟
	0x615D, KANJI_STANDARD,  // 慝
	0x6153, KANJI_STANDARD,  // 慓
	0x6175, KANJI_STANDARD,  // 慵
	0x6199, KANJI_STANDARD,  // 憙
	0x6196, KANJI_STANDARD,  // 憖
	0x6187, KANJI_STANDARD,  // 憇
	0x61AC, KANJI_STANDARD,  // 憬
	0x6194, KANJI_STANDARD,  // 憔
	0x619A, KANJI_STANDARD,  // 憚
	0x618A, KANJI_STANDARD,  // 憊
	0x6191, KANJI_STANDARD,  // 憑
	0x61AB, KANJI_STANDARD,  // 憫
	0x61AE, KANJI_STANDARD,  // 憮
	0x61CC, KANJI_STANDARD,  // 懌
	0x61CA, KANJI_STANDARD,  // 懊
	0x61C9, KANJI_STANDARD,  // 應
	0x61F7, KANJI_STANDARD,  // 懷
	0x61C8, KANJI_STANDARD,  // 懈
	0x61C3, KANJI_STANDARD,  // 懃
	0x61C6, KANJI_STANDARD,  // 懆
	0x61BA, KANJI_STANDARD,  // 憺
	0x61CB, KANJI_STANDARD,  // 懋
	0x7F79, KANJI_STANDARD,  // 罹
	0x61CD, KANJI_STANDARD,  // 懍
	0x61E6, KANJI_STANDARD,  // 懦
	0x61E3, KANJI_STANDARD,  // 懣
	0x61F6, KANJI_STANDARD,  // 懶
	0x61FA, KANJI_STANDARD,  // 懺
	0x61F4, KANJI_STANDARD,  // 懴
	0x61FF, KANJI_STANDARD,  // 懿
	0x61FD, KANJI_STANDARD,  // 懽
	0x61FC, KANJI_STANDARD,  // 懼
	0x61FE, KANJI_STANDARD,  // 懾
	0x6200, KANJI_STANDARD,  // 戀
	0x6208, KANJI_STANDARD,  // 戈
	0x6209, KANJI_STANDARD,  // 戉
	0x620D, KANJI_STANDARD,  // 戍
	0x620C, KANJI_STANDARD,  // 戌
	0x6214, KANJI_STANDARD,  // 戔
	0x621B, KANJI_STANDARD,  // 戛
	0x621E, KANJI_STANDARD,  // 戞
	0x6221, KANJI_STANDARD,  // 戡
	0x622A, KANJI_STANDARD,  // 截
	0x622E, KANJI_STANDARD,  // 戮
	0x6230, KANJI_STANDARD,  // 戰
	0x6232, KANJI_STANDARD,  // 戲
	0x6233, KANJI_STANDARD,  // 戳
	0x6241, KANJI_STANDARD,  // 扁
	0x624E, KANJI_STANDARD,  // 扎
	0x625E, KANJI_STANDARD,  // 扞
	0x6263, KANJI_STANDARD,  // 扣
	0x625B, KANJI_STANDARD,  // 扛
	0x6260, KANJI_STANDARD,  // 扠
	0x6268, KANJI_STANDARD,  // 扨
	0x627C, KANJI_STANDARD,  // 扼
	0x6282, KANJI_STANDARD,  // 抂
	0x6289, KANJI_STANDARD,  // 抉
	0x627E, KANJI_STANDARD,  // 找
	0x6292, KANJI_STANDARD,  // 抒
	0x6293, KANJI_STANDARD,  // 抓
	0x6296, KANJI_STANDARD,  // 抖
	0x62D4, KANJI_STANDARD,  // 拔
	0x6283, KANJI_STANDARD,  // 抃
	0x6294, KANJI_STANDARD,  // 抔
	0x62D7, KANJI_STANDARD,  // 拗
	0x62D1, KANJI_STANDARD,  // 拑
	0x62BB, KANJI_STANDARD,  // 抻
	0x62CF, KANJI_STANDARD,  // 拏
	0x62FF, KANJI_STANDARD,  // 拿
	0x62C6, KANJI_STANDARD,  // 拆
	0x64D4, KANJI_STANDARD,  // 擔
	0x62C8, KANJI_STANDARD,  // 拈
	0x62DC, KANJI_STANDARD,  // 拜
	0x62CC, KANJI_STANDARD,  // 拌
	0x62CA, KANJI_STANDARD,  // 拊
	0x62C2, KANJI_STANDARD,  // 拂
	0x62C7, KANJI_STANDARD,  // 拇
	0x629B, KANJI_STANDARD,  // 抛
	0x62C9, KANJI_STANDARD,  // 拉
	0x630C, KANJI_STANDARD,  // 挌
	0x62EE, KANJI_STANDARD,  // 拮
	0x62F1, KANJI_STANDARD,  // 拱
	0x6327, KANJI_STANDARD,  // 挧
	0x6302, KANJI_STANDARD,  // 挂
	0x6308, KANJI_STANDARD,  // 挈
	0x62EF, KANJI_STANDARD,  // 拯
	0x62F5, KANJI_STANDARD,  // 拵
	0x6350, KANJI_STANDARD,  // 捐
	0x633E, KANJI_STANDARD,  // 挾
	0x634D, KANJI_STANDARD,  // 捍
	0x641C, KANJI_STANDARD,  // 搜
	0x634F, KANJI_STANDARD,  // 捏
	0x6396, KANJI_STANDARD,  // 掖
	0x638E, KANJI_STANDARD,  // 掎
	0x6380, KANJI_STANDARD,  // 掀
	0x63AB, KANJI_STANDARD,  // 掫
	0x6376, KANJI_STANDARD,  // 捶
	0x63A3, KANJI_STANDARD,  // 掣
	0x638F, KANJI_STANDARD,  // 掏
	0x6389, KANJI_STANDARD,  // 掉
	0x639F, KANJI_STANDARD,  // 掟
	0x63B5, KANJI_STANDARD,  // 掵
	0x636B, KANJI_STANDARD,  // 捫
	0x6369, KANJI_STANDARD,  // 捩
	0x63BE, KANJI_STANDARD,  // 掾
	0x63E9, KANJI_STANDARD,  // 揩
	0x63C0, KANJI_STANDARD,  // 揀
	0x63C6, KANJI_STANDARD,  // 揆
	0x63E3, KANJI_STANDARD,  // 揣
	0x63C9, KANJI_STANDARD,  // 揉
	0x63D2, KANJI_STANDARD,  // 插
	0x63F6, KANJI_STANDARD,  // 揶
	0x63C4, KANJI_STANDARD,  // 揄
	0x6416, KANJI_STANDARD,  // 搖
	0x6434, KANJI_STANDARD,  // 搴
	0x6406, KANJI_STANDARD,  // 搆
	0x6413, KANJI_STANDARD,  // 搓
	0x6426, KANJI_STANDARD,  // 搦
	0x6436, KANJI_STANDARD,  // 搶
	0x651D, KANJI_STANDARD,  // 攝
	0x6417, KANJI_STANDARD,  // 搗
	0x6428, KANJI_STANDARD,  // 搨
	0x640F, KANJI_STANDARD,  // 搏
	0x6467, KANJI_STANDARD,  // 摧
	0x646F, KANJI_STANDARD,  // 摯
	0x6476, KANJI_STANDARD,  // 摶
	0x644E, KANJI_STANDARD,  // 摎
	0x652A, KANJI_STANDARD,  // 攪
	0x6495, KANJI_STANDARD,  // 撕
	0x6493, KANJI_STANDARD,  // 撓
	0x64A5, KANJI_STANDARD,  // 撥
	0x64A9, KANJI_STANDARD,  // 撩
	0x6488, KANJI_STANDARD,  // 撈
	0x64BC, KANJI_STANDARD,  // 撼
	0x64DA, KANJI_STANDARD,  // 據
	0x64D2, KANJI_STANDARD,  // 擒
	0x64C5, KANJI_STANDARD,  // 擅
	0x64C7, KANJI_STANDARD,  // 擇
	0x64BB, KANJI_STANDARD,  // 撻
	0x64D8, KANJI_STANDARD,  // 擘
	0x64C2, KANJI_STANDARD,  // 擂
	0x64F1, KANJI_STANDARD,  // 擱
	0x64E7, KANJI_STANDARD,  // 擧
	0x8209, KANJI_STANDARD,  // 舉
	0x64E0, KANJI_STANDARD,  // 擠
	0x64E1, KANJI_STANDARD,  // 擡
	0x62AC, KANJI_STANDARD,  // 抬
	0x64E3, KANJI_STANDARD,  // 擣
	0x64EF, KANJI_STANDARD,  // 擯
	0x652C, KANJI_STANDARD,  // 攬
	0x64F6, KANJI_STANDARD,  // 擶
	0x64F4, KANJI_STANDARD,  // 擴
	0x64F2, KANJI_STANDARD,  // 擲
	0x64FA, KANJI_STANDARD,  // 擺
	0x6500, KANJI_STANDARD,  // 攀
	0x64FD, KANJI_STANDARD,  // 擽
	0x6518, KANJI_STANDARD,  // 攘
	0x651C, KANJI_STANDARD,  // 攜
	0x6505, KANJI_STANDARD,  // 攅
	0x6524, KANJI_STANDARD,  // 攤
	0x6523, KANJI_STANDARD,  // 攣
	0x652B, KANJI_STANDARD,  // 攫
	0x6534, KANJI_STANDARD,  // 攴
	0x6535, KANJI_STANDARD,  // 攵
	0x6537, KANJI_STANDARD,  // 攷
	0x6536, KANJI_STANDARD,  // 收
	0x6538, KANJI_STANDARD,  // 攸
	0x754B, KANJI_STANDARD,  // 畋
	0x6548, KANJI_STANDARD,  // 效
	0x6556, KANJI_STANDARD,  // 敖
	0x6555, KANJI_STANDARD,  // 敕
	0x654D, KANJI_STANDARD,  // 敍
	0x6558, KANJI_STANDARD,  // 敘
	0x655E, KANJI_STANDARD,  // 敞
	0x655D, KANJI_STANDARD,  // 敝
	0x6572, KANJI_STANDARD,  // 敲
	0x6578, KANJI_STANDARD,  // 數
	0x6582, KANJI_STANDARD,  // 斂
	0x6583, KANJI_STANDARD,  // 斃
	0x8B8A, KANJI_STANDARD,  // 變
	0x659B, KANJI_STANDARD,  // 斛
	0x659F, KANJI_STANDARD,  // 斟
	0x65AB, KANJI_STANDARD,  // 斫
	0x65B7, KANJI_STANDARD,  // 斷
	0x65C3, KANJI_STANDARD,  // 旃
	0x65C6, KANJI_STANDARD,  // 旆
	0x65C1, KANJI_STANDARD,  // 旁
	0x65C4, KANJI_STANDARD,  // 旄
	0x65CC, KANJI_STANDARD,  // 旌
	0x65D2, KANJI_STANDARD,  // 旒
	0x65DB, KANJI_STANDARD,  // 旛
	0x65D9, KANJI_STANDARD,  // 旙
	0x65E0, KANJI_STANDARD,  // 无
	0x65E1, KANJI_STANDARD,  // 旡
	0x65F1, KANJI_STANDARD,  // 旱
	0x6772, KANJI_STANDARD,  // 杲
	0x660A, KANJI_STANDARD,  // 昊
	0x6603, KANJI_STANDARD,  // 昃
	0x65FB, KANJI_STANDARD,  // 旻
	0x6773, KANJI_STANDARD,  // 杳
	0x6635, KANJI_STANDARD,  // 昵
	0x6636, KANJI_STANDARD,  // 昶
	0x6634, KANJI_STANDARD,  // 昴
	0x661C, KANJI_STANDARD,  // 昜
	0x664F, KANJI_STANDARD,  // 晏
	0x6644, KANJI_STANDARD,  // 晄
	0x6649, KANJI_STANDARD,  // 晉
	0x6641, KANJI_STANDARD,  // 晁
	0x665E, KANJI_STANDARD,  // 晞
	0x665D, KANJI_STANDARD,  // 晝
	0x6664, KANJI_STANDARD,  // 晤
	0x6667, KANJI_STANDARD,  // 晧
	0x6668, KANJI_STANDARD,  // 晨
	0x665F, KANJI_STANDARD,  // 晟
	0x6662, KANJI_STANDARD,  // 晢
	0x6670, KANJI_STANDARD,  // 晰
	0x6683, KANJI_STANDARD,  // 暃
	0x6688, KANJI_STANDARD,  // 暈
	0x668E, KANJI_STANDARD,  // 暎
	0x6689, KANJI_STANDARD,  // 暉
	0x6684, KANJI_STANDARD,  // 暄
	0x6698, KANJI_STANDARD,  // 暘
	0x669D, KANJI_STANDARD,  // 暝
	0x66C1, KANJI_STANDARD,  // 曁
	0x66B9, KANJI_STANDARD,  // 暹
	0x66C9, KANJI_STANDARD,  // 曉
	0x66BE, KANJI_STANDARD,  // 暾
	0x66BC, KANJI_STANDARD,  // 暼
	0x66C4, KANJI_STANDARD,  // 曄
	0x66B8, KANJI_STANDARD,  // 暸
	0x66D6, KANJI_STANDARD,  // 曖
	0x66DA, KANJI_STANDARD,  // 曚
	0x66E0, KANJI_STANDARD,  // 曠
	0x663F, KANJI_STANDARD,  // 昿
	0x66E6, KANJI_STANDARD,  // 曦
	0x66E9, KANJI_STANDARD,  // 曩
	0x66F0, KANJI_STANDARD,  // 曰
	0x66F5, KANJI_STANDARD,  // 曵
	0x66F7, KANJI_STANDARD,  // 曷
	0x670F, KANJI_STANDARD,  // 朏
	0x6716, KANJI_STANDARD,  // 朖
	0x671E, KANJI_STANDARD,  // 朞
	0x6726, KANJI_STANDARD,  // 朦
	0x6727, KANJI_STANDARD,  // 朧
	0x9738, KANJI_STANDARD,  // 霸
	0x672E, KANJI_STANDARD,  // 朮
	0x673F, KANJI_STANDARD,  // 朿
	0x6736, KANJI_STANDARD,  // 朶
	0x6741, KANJI_STANDARD,  // 杁
	0x6738, KANJI_STANDARD,  // 朸
	0x6737, KANJI_STANDARD,  // 朷
	0x6746, KANJI_STANDARD,  // 杆
	0x675E, KANJI_STANDARD,  // 杞
	0x6760, KANJI_STANDARD,  // 杠
	0x6759, KANJI_STANDARD,  // 杙
	0x6763, KANJI_STANDARD,  // 杣
	0x6764, KANJI_STANDARD,  // 杤
	0x6789, KANJI_STANDARD,  // 枉
	0x6770, KANJI_STANDARD,  // 杰
	0x67A9, KANJI_STANDARD,  // 枩
	0x677C, KANJI_STANDARD,  // 杼
	0x676A, KANJI_STANDARD,  // 杪
	0x678C, KANJI_STANDARD,  // 枌
	0x678B, KANJI_STANDARD,  // 枋
	0x67A6, KANJI_STANDARD,  // 枦
	0x67A1, KANJI_STANDARD,  // 枡
	0x6785, KANJI_STANDARD,  // 枅
	0x67B7, KANJI_STANDARD,  // 枷
	0x67EF, KANJI_STANDARD,  // 柯
	0x67B4, KANJI_STANDARD,  // 枴
	0x67EC, KANJI_STANDARD,  // 柬
	0x67B3, KANJI_STANDARD,  // 枳
	0x67E9, KANJI_STANDARD,  // 柩
	0x67B8, KANJI_STANDARD,  // 枸
	0x67E4, KANJI_STANDARD,  // 柤
	0x67DE, KANJI_STANDARD,  // 柞
	0x67DD, KANJI_STANDARD,  // 柝
	0x67E2, KANJI_STANDARD,  // 柢
	0x67EE, KANJI_STANDARD,  // 柮
	0x67B9, KANJI_STANDARD,  // 枹
	0x67CE, KANJI_STANDARD,  // 柎
	0x67C6, KANJI_STANDARD,  // 柆
	0x67E7, KANJI_STANDARD,  // 柧
	0x6A9C, KANJI_STANDARD,  // 檜
	0x681E, KANJI_STANDARD,  // 栞
	0x6846, KANJI_STANDARD,  // 框
	0x6829, KANJI_STANDARD,  // 栩
	0x6840, KANJI_STANDARD,  // 桀
	0x684D, KANJI_STANDARD,  // 桍
	0x6832, KANJI_STANDARD,  // 栲
	0x684E, KANJI_STANDARD,  // 桎
	0x68B3, KANJI_STANDARD,  // 梳
	0x682B, KANJI_STANDARD,  // 栫
	0x6859, KANJI_STANDARD,  // 桙
	0x6863, KANJI_STANDARD,  // 档
	0x6877, KANJI_STANDARD,  // 桷
	0x687F, KANJI_STANDARD,  // 桿
	0x689F, KANJI_STANDARD,  // 梟
	0x688F, KANJI_STANDARD,  // 梏
	0x68AD, KANJI_STANDARD,  // 梭
	0x6894, KANJI_STANDARD,  // 梔
	0x689D, KANJI_STANDARD,  // 條
	0x689B, KANJI_STANDARD,  // 梛
	0x6883, KANJI_STANDARD,  // 梃
	0x6AAE, KANJI_STANDARD,  // 檮
	0x68B9, KANJI_STANDARD,  // 梹
	0x6874, KANJI_STANDARD,  // 桴
	0x68B5, KANJI_STANDARD,  // 梵
	0x68A0, KANJI_STANDARD,  // 梠
	0x68BA, KANJI_STANDARD,  // 梺
	0x690F, KANJI_STANDARD,  // 椏
	0x688D, KANJI_STANDARD,  // 梍
	0x687E, KANJI_STANDARD,  // 桾
	0x6901, KANJI_STANDARD,  // 椁
	0x68CA, KANJI_STANDARD,  // 棊
	0x6908, KANJI_STANDARD,  // 椈
	0x68D8, KANJI_STANDARD,  // 棘
	0x6922, KANJI_STANDARD,  // 椢
	0x6926, KANJI_STANDARD,  // 椦
	0x68E1, KANJI_STANDARD,  // 棡
	0x690C, KANJI_STANDARD,  // 椌
	0x68CD, KANJI_STANDARD,  // 棍
	0x68D4, KANJI_STANDARD,  // 棔
	0x68E7, KANJI_STANDARD,  // 棧
	0x68D5, KANJI_STANDARD,  // 棕
	0x6936, KANJI_STANDARD,  // 椶
	0x6912, KANJI_STANDARD,  // 椒
	0x6904, KANJI_STANDARD,  // 椄
	0x68D7, KANJI_STANDARD,  // 棗
	0x68E3, KANJI_STANDARD,  // 棣
	0x6925, KANJI_STANDARD,  // 椥
	0x68F9, KANJI_STANDARD,  // 棹
	0x68E0, KANJI_STANDARD,  // 棠
	0x68EF, KANJI_STANDARD,  // 棯
	0x6928, KANJI_STANDARD,  // 椨
	0x692A, KANJI_STANDARD,  // 椪
	0x691A, KANJI_STANDARD,  // 椚
	0x6923, KANJI_STANDARD,  // 椣
	0x6921, KANJI_STANDARD,  // 椡
	0x68C6, KANJI_STANDARD,  // 棆
	0x6979, KANJI_STANDARD,  // 楹
	0x6977, KANJI_STANDARD,  // 楷
	0x695C, KANJI_STANDARD,  // 楜
	0x6978, KANJI_STANDARD,  // 楸
	0x696B, KANJI_STANDARD,  // 楫
	0x6954, KANJI_STANDARD,  // 楔
	0x697E, KANJI_STANDARD,  // 楾
	0x696E, KANJI_STANDARD,  // 楮
	0x6939, KANJI_STANDARD,  // 椹
	0x6974, KANJI_STANDARD,  // 楴
	0x693D, KANJI_STANDARD,  // 椽
	0x6959, KANJI_STANDARD,  // 楙
	0x6930, KANJI_STANDARD,  // 椰
	0x6961, KANJI_STANDARD,  // 楡
	0x695E, KANJI_STANDARD,  // 楞
	0x695D, KANJI_STANDARD,  // 楝
	0x6981, KANJI_STANDARD,  // 榁
	0x696A, KANJI_STANDARD,  // 楪
	0x69B2, KANJI_STANDARD,  // 榲
	0x69AE, KANJI_STANDARD,  // 榮
	0x69D0, KANJI_STANDARD,  // 槐
	0x69BF, KANJI_STANDARD,  // 榿
	0x69C1, KANJI_STANDARD,  // 槁
	0x69D3, KANJI_STANDARD,  // 槓
	0x69BE, KANJI_STANDARD,  // 榾
	0x69CE, KANJI_STANDARD,  // 槎
	0x5BE8, KANJI_STANDARD,  // 寨
	0x69CA, KANJI_STANDARD,  // 槊
	0x69DD, KANJI_STANDARD,  // 槝
	0x69BB, KANJI_STANDARD,  // 榻
	0x69C3, KANJI_STANDARD,  // 槃
	0x69A7, KANJI_STANDARD,  // 榧
	0x6A2E, KANJI_STANDARD,  // 樮
	0x6991, KANJI_STANDARD,  // 榑
	0x69A0, KANJI_STANDARD,  // 榠
	0x699C, KANJI_STANDARD,  // 榜
	0x6995, KANJI_STANDARD,  // 榕
	0x69B4, KANJI_STANDARD,  // 榴
	0x69DE, KANJI_STANDARD,  // 槞
	0x69E8, KANJI_STANDARD,  // 槨
	0x6A02, KANJI_STANDARD,  // 樂
	0x6A1B, KANJI_STANDARD,  // 樛
	0x69FF, KANJI_STANDARD,  // 槿
	0x6B0A, KANJI_STANDARD,  // 權
	0x69F9, KANJI_STANDARD,  // 槹
	0x69F2, KANJI_STANDARD,  // 槲
	0x69E7, KANJI_STANDARD,  // 槧
	0x6A05, KANJI_STANDARD,  // 樅
	0x69B1, KANJI_STANDARD,  // 榱
	0x6A1E, KANJI_STANDARD,  // 樞
	0x69ED, KANJI_STANDARD,  // 槭
	0x6A14, KANJI_STANDARD,  // 樔
	0x69EB, KANJI_STANDARD,  // 槫
	0x6A0A, KANJI_STANDARD,  // 樊
	0x6A12, KANJI_STANDARD,  // 樒
	0x6AC1, KANJI_STANDARD,  // 櫁
	0x6A23, KANJI_STANDARD,  // 樣
	0x6A13, KANJI_STANDARD,  // 樓
	0x6A44, KANJI_STANDARD,  // 橄
	0x6A0C, KANJI_STANDARD,  // 樌
	0x6A72, KANJI_STANDARD,  // 橲
	0x6A36, KANJI_STANDARD,  // 樶
	0x6A78, KANJI_STANDARD,  // 橸
	0x6A47, KANJI_STANDARD,  // 橇
	0x6A62, KANJI_STANDARD,  // 橢
	0x6A59, KANJI_STANDARD,  // 橙
	0x6A66, KANJI_STANDARD,  // 橦
	0x6A48, KANJI_STANDARD,  // 橈
	0x6A38, KANJI_STANDARD,  // 樸
	0x6A22, KANJI_STANDARD,  // 樢
	0x6A90, KANJI_STANDARD,  // 檐
	0x6A8D, KANJI_STANDARD,  // 檍
	0x6AA0, KANJI_STANDARD,  // 檠
	0x6A84, KANJI_STANDARD,  // 檄
	0x6AA2, KANJI_STANDARD,  // 檢
	0x6AA3, KANJI_STANDARD,  // 檣
	0x6A97, KANJI_STANDARD,  // 檗
	0x8617, KANJI_STANDARD,  // 蘗
	0x6ABB, KANJI_STANDARD,  // 檻
	0x6AC3, KANJI_STANDARD,  // 櫃
	0x6AC2, KANJI_STANDARD,  // 櫂
	0x6AB8, KANJI_STANDARD,  // 檸
	0x6AB3, KANJI_STANDARD,  // 檳
	0x6AAC, KANJI_STANDARD,  // 檬
	0x6ADE, KANJI_STANDARD,  // 櫞
	0x6AD1, KANJI_STANDARD,  // 櫑
	0x6ADF, KANJI_STANDARD,  // 櫟
	0x6AAA, KANJI_STANDARD,  // 檪
	0x6ADA, KANJI_STANDARD,  // 櫚
	0x6AEA, KANJI_STANDARD,  // 櫪
	0x6AFB, KANJI_STANDARD,  // 櫻
	0x6B05, KANJI_STANDARD,  // 欅
	0x8616, KANJI_STANDARD,  // 蘖
	0x6AFA, KANJI_STANDARD,  // 櫺
	0x6B12, KANJI_STANDARD,  // 欒
	0x6B16, KANJI_STANDARD,  // 欖
	0x9B31, KANJI_STANDARD,  // 鬱
	0x6B1F, KANJI_STANDARD,  // 欟
	0x6B38, KANJI_STANDARD,  // 欸
	0x6B37, KANJI_STANDARD,  // 欷
	0x76DC, KANJI_STANDARD,  // 盜
	0x6B39, KANJI_STANDARD,  // 欹
	0x98EE, KANJI_STANDARD,  // 飮
	0x6B47, KANJI_STANDARD,  // 歇
	0x6B43, KANJI_STANDARD,  // 歃
	0x6B49, KANJI_STANDARD,  // 歉
	0x6B50, KANJI_STANDARD,  // 歐
	0x6B59, KANJI_STANDARD,  // 歙
	0x6B54, KANJI_STANDARD,  // 歔
	0x6B5B, KANJI_STANDARD,  // 歛
	0x6B5F, KANJI_STANDARD,  // 歟
	0x6B61, KANJI_STANDARD,  // 歡
	0x6B78, KANJI_STANDARD,  // 歸
	0x6B79, KANJI_STANDARD,  // 歹
	0x6B7F, KANJI_STANDARD,  // 歿
	0x6B80, KANJI_STANDARD,  // 殀
	0x6B84, KANJI_STANDARD,  // 殄
	0x6B83, KANJI_STANDARD,  // 殃
	0x6B8D, KANJI_STANDARD,  // 殍
	0x6B98, KANJI_STANDARD,  // 殘
	0x6B95, KANJI_STANDARD,  // 殕
	0x6B9E, KANJI_STANDARD,  // 殞
	0x6BA4, KANJI_STANDARD,  // 殤
	0x6BAA, KANJI_STANDARD,  // 殪
	0x6BAB, KANJI_STANDARD,  // 殫
	0x6BAF, KANJI_STANDARD,  // 殯
	0x6BB2, KANJI_STANDARD,  // 殲
	0x6BB1, KANJI_STANDARD,  // 殱
	0x6BB3, KANJI_STANDARD,  // 殳
	0x6BB7, KANJI_STANDARD,  // 殷
	0x6BBC, KANJI_STANDARD,  // 殼
	0x6BC6, KANJI_STANDARD,  // 毆
	0x6BCB, KANJI_STANDARD,  // 毋
	0x6BD3, KANJI_STANDARD,  // 毓
	0x6BDF, KANJI_STANDARD,  // 毟
	0x6BEC, KANJI_STANDARD,  // 毬
	0x6BEB, KANJI_STANDARD,  // 毫
	0x6BF3, KANJI_STANDARD,  // 毳
	0x6BEF, KANJI_STANDARD,  // 毯
	0x9EBE, KANJI_STANDARD,  // 麾
	0x6C08, KANJI_STANDARD,  // 氈
	0x6C13, KANJI_STANDARD,  // 氓
	0x6C14, KANJI_STANDARD,  // 气
	0x6C1B, KANJI_STANDARD,  // 氛
	0x6C24, KANJI_STANDARD,  // 氤
	0x6C23, KANJI_STANDARD,  // 氣
	0x6C5E, KANJI_STANDARD,  // 汞
	0x6C55, KANJI_STANDARD,  // 汕
	0x6C62, KANJI_STANDARD,  // 汢
	0x6C6A, KANJI_STANDARD,  // 汪
	0x6C82, KANJI_STANDARD,  // 沂
	0x6C8D, KANJI_STANDARD,  // 沍
	0x6C9A, KANJI_STANDARD,  // 沚
	0x6C81, KANJI_STANDARD,  // 沁
	0x6C9B, KANJI_STANDARD,  // 沛
	0x6C7E, KANJI_STANDARD,  // 汾
	0x6C68, KANJI_STANDARD,  // 汨
	0x6C73, KANJI_STANDARD,  // 汳
	0x6C92, KANJI_STANDARD,  // 沒
	0x6C90, KANJI_STANDARD,  // 沐
	0x6CC4, KANJI_STANDARD,  // 泄
	0x6CF1, KANJI_STANDARD,  // 泱
	0x6CD3, KANJI_STANDARD,  // 泓
	0x6CBD, KANJI_STANDARD,  // 沽
	0x6CD7, KANJI_STANDARD,  // 泗
	0x6CC5, KANJI_STANDARD,  // 泅
	0x6CDD, KANJI_STANDARD,  // 泝
	0x6CAE, KANJI_STANDARD,  // 沮
	0x6CB1, KANJI_STANDARD,  // 沱
	0x6CBE, KANJI_STANDARD,  // 沾
	0x6CBA, KANJI_STANDARD,  // 沺
	0x6CDB, KANJI_STANDARD,  // 泛
	0x6CEF, KANJI_STANDARD,  // 泯
	0x6CD9, KANJI_STANDARD,  // 泙
	0x6CEA, KANJI_STANDARD,  // 泪
	0x6D1F, KANJI_STANDARD,  // 洟
	0x884D, KANJI_STANDARD,  // 衍
	0x6D36, KANJI_STANDARD,  // 洶
	0x6D2B, KANJI_STANDARD,  // 洫
	0x6D3D, KANJI_STANDARD,  // 洽
	0x6D38, KANJI_STANDARD,  // 洸
	0x6D19, KANJI_STANDARD,  // 洙
	0x6D35, KANJI_STANDARD,  // 洵
	0x6D33, KANJI_STANDARD,  // 洳
	0x6D12, KANJI_STANDARD,  // 洒
	0x6D0C, KANJI_STANDARD,  // 洌
	0x6D63, KANJI_STANDARD,  // 浣
	0x6D93, KANJI_STANDARD,  // 涓
	0x6D64, KANJI_STANDARD,  // 浤
	0x6D5A, KANJI_STANDARD,  // 浚
	0x6D79, KANJI_STANDARD,  // 浹
	0x6D59, KANJI_STANDARD,  // 浙
	0x6D8E, KANJI_STANDARD,  // 涎
	0x6D95, KANJI_STANDARD,  // 涕
	0x6FE4, KANJI_STANDARD,  // 濤
	0x6D85, KANJI_STANDARD,  // 涅
	0x6DF9, KANJI_STANDARD,  // 淹
	0x6E15, KANJI_STANDARD,  // 渕
	0x6E0A, KANJI_STANDARD,  // 渊
	0x6DB5, KANJI_STANDARD,  // 涵
	0x6DC7, KANJI_STANDARD,  // 淇
	0x6DE6, KANJI_STANDARD,  // 淦
	0x6DB8, KANJI_STANDARD,  // 涸
	0x6DC6, KANJI_STANDARD,  // 淆
	0x6DEC, KANJI_STANDARD,  // 淬
	0x6DDE, KANJI_STANDARD,  // 淞
	0x6DCC, KANJI_STANDARD,  // 淌
	0x6DE8, KANJI_STANDARD,  // 淨
	0x6DD2, KANJI_STANDARD,  // 淒
	0x6DC5, KANJI_STANDARD,  // 淅
	0x6DFA, KANJI_STANDARD,  // 淺
	0x6DD9, KANJI_STANDARD,  // 淙
	0x6DE4, KANJI_STANDARD,  // 淤
	0x6DD5, KANJI_STANDARD,  // 淕
	0x6DEA, KANJI_STANDARD,  // 淪
	0x6DEE, KANJI_STANDARD,  // 淮
	0x6E2D, KANJI_STANDARD,  // 渭
	0x6E6E, KANJI_STANDARD,  // 湮
	0x6E2E, KANJI_STANDARD,  // 渮
	0x6E19, KANJI_STANDARD,  // 渙
	0x6E72, KANJI_STANDARD,  // 湲
	0x6E5F, KANJI_STANDARD,  // 湟
	0x6E3E, KANJI_STANDARD,  // 渾
	0x6E23, KANJI_STANDARD,  // 渣
	0x6E6B, KANJI_STANDARD,  // 湫
	0x6E2B, KANJI_STANDARD,  // 渫
	0x6E76, KANJI_STANDARD,  // 湶
	0x6E4D, KANJI_STANDARD,  // 湍
	0x6E1F, KANJI_STANDARD,  // 渟
	0x6E43, KANJI_STANDARD,  // 湃
	0x6E3A, KANJI_STANDARD,  // 渺
	0x6E4E, KANJI_STANDARD,  // 湎
	0x6E24, KANJI_STANDARD,  // 渤
	0x6EFF, KANJI_STANDARD,  // 滿
	0x6E1D, KANJI_STANDARD,  // 渝
	0x6E38, KANJI_STANDARD,  // 游
	0x6E82, KANJI_STANDARD,  // 溂
	0x6EAA, KANJI_STANDARD,  // 溪
	0x6E98, KANJI_STANDARD,  // 溘
	0x6EC9, KANJI_STANDARD,  // 滉
	0x6EB7, KANJI_STANDARD,  // 溷
	0x6ED3, KANJI_STANDARD,  // 滓
	0x6EBD, KANJI_STANDARD,  // 溽
	0x6EAF, KANJI_STANDARD,  // 溯
	0x6EC4, KANJI_STANDARD,  // 滄
	0x6EB2, KANJI_STANDARD,  // 溲
	0x6ED4, KANJI_STANDARD,  // 滔
	0x6ED5, KANJI_STANDARD,  // 滕
	0x6E8F, KANJI_STANDARD,  // 溏
	0x6EA5, KANJI_STANDARD,  // 溥
	0x6EC2, KANJI_STANDARD,  // 滂
	0x6E9F, KANJI_STANDARD,  // 溟
	0x6F41, KANJI_STANDARD,  // 潁
	0x6F11, KANJI_STANDARD,  // 漑
	0x704C, KANJI_STANDARD,  // 灌
	0x6EEC, KANJI_STANDARD,  // 滬
	0x6EF8, KANJI_STANDARD,  // 滸
	0x6EFE, KANJI_STANDARD,  // 滾
	0x6F3F, KANJI_STANDARD,  // 漿
	0x6EF2, KANJI_STANDARD,  // 滲
	0x6F31, KANJI_STANDARD,  // 漱
	0x6EEF, KANJI_STANDARD,  // 滯
	0x6F32, KANJI_STANDARD,  // 漲
	0x6ECC, KANJI_STANDARD,  // 滌
	0x6F3E, KANJI_STANDARD,  // 漾
	0x6F13, KANJI_STANDARD,  // 漓
	0x6EF7, KANJI_STANDARD,  // 滷
	0x6F86, KANJI_STANDARD,  // 澆
	0x6F7A, KANJI_STANDARD,  // 潺
	0x6F78, KANJI_STANDARD,  // 潸
	0x6F81, KANJI_STANDARD,  // 澁
	0x6F80, KANJI_STANDARD,  // 澀
	0x6F6F, KANJI_STANDARD,  // 潯
	0x6F5B, KANJI_STANDARD,  // 潛
	0x6FF3, KANJI_STANDARD,  // 濳
	0x6F6D, KANJI_STANDARD,  // 潭
	0x6F82, KANJI_STANDARD,  // 澂
	0x6F7C, KANJI_STANDARD,  // 潼
	0x6F58, KANJI_STANDARD,  // 潘
	0x6F8E, KANJI_STANDARD,  // 澎
	0x6F91, KANJI_STANDARD,  // 澑
	0x6FC2, KANJI_STANDARD,  // 濂
	0x6F66, KANJI_STANDARD,  // 潦
	0x6FB3, KANJI_STANDARD,  // 澳
	0x6FA3, KANJI_STANDARD,  // 澣
	0x6FA1, KANJI_STANDARD,  // 澡
	0x6FA4, KANJI_STANDARD,  // 澤
	0x6FB9, KANJI_STANDARD,  // 澹
	0x6FC6, KANJI_STANDARD,  // 濆
	0x6FAA, KANJI_STANDARD,  // 澪
	0x6FDF, KANJI_STANDARD,  // 濟
	0x6FD5, KANJI_STANDARD,  // 濕
	0x6FEC, KANJI_STANDARD,  // 濬
	0x6FD4, KANJI_STANDARD,  // 濔
	0x6FD8, KANJI_STANDARD,  // 濘
	0x6FF1, KANJI_STANDARD,  // 濱
	0x6FEE, KANJI_STANDARD,  // 濮
	0x6FDB, KANJI_STANDARD,  // 濛
	0x7009, KANJI_STANDARD,  // 瀉
	0x700B, KANJI_STANDARD,  // 瀋
	0x6FFA, KANJI_STANDARD,  // 濺
	0x7011, KANJI_STANDARD,  // 瀑
	0x7001, KANJI_STANDARD,  // 瀁
	0x700F, KANJI_STANDARD,  // 瀏
	0x6FFE, KANJI_STANDARD,  // 濾
	0x701B, KANJI_STANDARD,  // 瀛
	0x701A, KANJI_STANDARD,  // 瀚
	0x6F74, KANJI_STANDARD,  // 潴
	0x701D, KANJI_STANDARD,  // 瀝
	0x7018, KANJI_STANDARD,  // 瀘
	0x701F, KANJI_STANDARD,  // 瀟
	0x7030, KANJI_STANDARD,  // 瀰
	0x703E, KANJI_STANDARD,  // 瀾
	0x7032, KANJI_STANDARD,  // 瀲
	0x7051, KANJI_STANDARD,  // 灑
	0x7063, KANJI_STANDARD,  // 灣
	0x7099, KANJI_STANDARD,  // 炙
	0x7092, KANJI_STANDARD,  // 炒
	0x70AF, KANJI_STANDARD,  // 炯
	0x70F1, KANJI_STANDARD,  // 烱
	0x70AC, KANJI_STANDARD,  // 炬
	0x70B8, KANJI_STANDARD,  // 炸
	0x70B3, KANJI_STANDARD,  // 炳
	0x70AE, KANJI_STANDARD,  // 炮
	0x70DF, KANJI_STANDARD,  // 烟
	0x70CB, KANJI_STANDARD,  // 烋
	0x70DD, KANJI_STANDARD,  // 烝
	0x70D9, KANJI_STANDARD,  // 烙
	0x7109, KANJI_STANDARD,  // 焉
	0x70FD, KANJI_STANDARD,  // 烽
	0x711C, KANJI_STANDARD,  // 焜
	0x7119, KANJI_STANDARD,  // 焙
	0x7165, KANJI_STANDARD,  // 煥
	0x7155, KANJI_STANDARD,  // 煕
	0x7188, KANJI_STANDARD,  // 熈
	0x7166, KANJI_STANDARD,  // 煦
	0x7162, KANJI_STANDARD,  // 煢
	0x714C, KANJI_STANDARD,  // 煌
	0x7156, KANJI_STANDARD,  // 煖
	0x716C, KANJI_STANDARD,  // 煬
	0x718F, KANJI_STANDARD,  // 熏
	0x71FB, KANJI_STANDARD,  // 燻
	0x7184, KANJI_STANDARD,  // 熄
	0x7195, KANJI_STANDARD,  // 熕
	0x71A8, KANJI_STANDARD,  // 熨
	0x71AC, KANJI_STANDARD,  // 熬
	0x71D7, KANJI_STANDARD,  // 燗
	0x71B9, KANJI_STANDARD,  // 熹
	0x71BE, KANJI_STANDARD,  // 熾
	0x71D2, KANJI_STANDARD,  // 燒
	0x71C9, KANJI_STANDARD,  // 燉
	0x71D4, KANJI_STANDARD,  // 燔
	0x71CE, KANJI_STANDARD,  // 燎
	0x71E0, KANJI_STANDARD,  // 燠
	0x71EC, KANJI_STANDARD,  // 燬
	0x71E7, KANJI_STANDARD,  // 燧
	0x71F5, KANJI_STANDARD,  // 燵
	0x71FC, KANJI_STANDARD,  // 燼
	0x71F9, KANJI_STANDARD,  // 燹
	0x71FF, KANJI_STANDARD,  // 燿
	0x720D, KANJI_STANDARD,  // 爍
	0x7210, KANJI_STANDARD,  // 爐
	0x721B, KANJI_STANDARD,  // 爛
	0x7228, KANJI_STANDARD,  // 爨
	0x722D, KANJI_STANDARD,  // 爭
	0x722C, KANJI_STANDARD,  // 爬
	0x7230, KANJI_STANDARD,  // 爰
	0x7232, KANJI_STANDARD,  // 爲
	0x723B, KANJI_STANDARD,  // 爻
	0x723C, KANJI_STANDARD,  // 爼
	0x723F, KANJI_STANDARD,  // 爿
	0x7240, KANJI_STANDARD,  // 牀
	0x7246, KANJI_STANDARD,  // 牆
	0x724B, KANJI_STANDARD,  // 牋
	0x7258, KANJI_STANDARD,  // 牘
	0x7274, KANJI_STANDARD,  // 牴
	0x727E, KANJI_STANDARD,  // 牾
	0x7282, KANJI_STANDARD,  // 犂
	0x7281, KANJI_STANDARD,  // 犁
	0x7287, KANJI_STANDARD,  // 犇
	0x7292, KANJI_STANDARD,  // 犒
	0x7296, KANJI_STANDARD,  // 犖
	0x72A2, KANJI_STANDARD,  // 犢
	0x72A7, KANJI_STANDARD,  // 犧
	0x72B9, KANJI_STANDARD,  // 犹
	0x72B2, KANJI_STANDARD,  // 犲
	0x72C3, KANJI_STANDARD,  // 狃
	0x72C6, KANJI_STANDARD,  // 狆
	0x72C4, KANJI_STANDARD,  // 狄
	0x72CE, KANJI_STANDARD,  // 狎
	0x72D2, KANJI_STANDARD,  // 狒
	0x72E2, KANJI_STANDARD,  // 狢
	0x72E0, KANJI_STANDARD,  // 狠
	0x72E1, KANJI_STANDARD,  // 狡
	0x72F9, KANJI_STANDARD,  // 狹
	0x72F7, KANJI_STANDARD,  // 狷
	0x500F, KANJI_STANDARD,  // 倏
	0x7317, KANJI_STANDARD,  // 猗
	0x730A, KANJI_STANDARD,  // 猊
	0x731C, KANJI_STANDARD,  // 猜
	0x7316, KANJI_STANDARD,  // 猖
	0x731D, KANJI_STANDARD,  // 猝
	0x7334, KANJI_STANDARD,  // 猴
	0x732F, KANJI_STANDARD,  // 猯
	0x7329, KANJI_STANDARD,  // 猩
	0x7325, KANJI_STANDARD,  // 猥
	0x733E, KANJI_STANDARD,  // 猾
	0x734E, KANJI_STANDARD,  // 獎
	0x734F, KANJI_STANDARD,  // 獏
	0x9ED8, KANJI_STANDARD,  // 默
	0x7357, KANJI_STANDARD,  // 獗
	0x736A, KANJI_STANDARD,  // 獪
	0x7368, KANJI_STANDARD,  // 獨
	0x7370, KANJI_STANDARD,  // 獰
	0x7378, KANJI_STANDARD,  // 獸
	0x7375, KANJI_STANDARD,  // 獵
	0x737B, KANJI_STANDARD,  // 獻
	0x737A, KANJI_STANDARD,  // 獺
	0x73C8, KANJI_STANDARD,  // 珈
	0x73B3, KANJI_STANDARD,  // 玳
	0x73CE, KANJI_STANDARD,  // 珎
	0x73BB, KANJI_STANDARD,  // 玻
	0x73C0, KANJI_STANDARD,  // 珀
	0x73E5, KANJI_STANDARD,  // 珥
	0x73EE, KANJI_STANDARD,  // 珮
	0x73DE, KANJI_STANDARD,  // 珞
	0x74A2, KANJI_STANDARD,  // 璢
	0x7405, KANJI_STANDARD,  // 琅
	0x746F, KANJI_STANDARD,  // 瑯
	0x7425, KANJI_STANDARD,  // 琥
	0x73F8, KANJI_STANDARD,  // 珸
	0x7432, KANJI_STANDARD,  // 琲
	0x743A, KANJI_STANDARD,  // 琺
	0x7455, KANJI_STANDARD,  // 瑕
	0x743F, KANJI_STANDARD,  // 琿
	0x745F, KANJI_STANDARD,  // 瑟
	0x7459, KANJI_STANDARD,  // 瑙
	0x7441, KANJI_STANDARD,  // 瑁
	0x745C, KANJI_STANDARD,  // 瑜
	0x7469, KANJI_STANDARD,  // 瑩
	0x7470, KANJI_STANDARD,  // 瑰
	0x7463, KANJI_STANDARD,  // 瑣
	0x746A, KANJI_STANDARD,  // 瑪
	0x7476, KANJI_STANDARD,  // 瑶
	0x747E, KANJI_STANDARD,  // 瑾
	0x748B, KANJI_STANDARD,  // 璋
	0x749E, KANJI_STANDARD,  // 璞
	0x74A7, KANJI_STANDARD,  // 璧
	0x74CA, KANJI_STANDARD,  // 瓊
	0x74CF, KANJI_STANDARD,  // 瓏
	0x74D4, KANJI_STANDARD,  // 瓔
	0x73F1, KANJI_STANDARD,  // 珱
	0x74E0, KANJI_STANDARD,  // 瓠
	0x74E3, KANJI_STANDARD,  // 瓣
	0x74E7, KANJI_STANDARD,  // 瓧
	0x74E9, KANJI_STANDARD,  // 瓩
	0x74EE, KANJI_STANDARD,  // 瓮
	0x74F2, KANJI_STANDARD,  // 瓲
	0x74F0, KANJI_STANDARD,  // 瓰
	0x74F1, KANJI_STANDARD,  // 瓱
	0x74F8, KANJI_STANDARD,  // 瓸
	0x74F7, KANJI_STANDARD,  // 瓷
	0x7504, KANJI_STANDARD,  // 甄
	0x7503, KANJI_STANDARD,  // 甃
	0x7505, KANJI_STANDARD,  // 甅
	0x750C, KANJI_STANDARD,  // 甌
	0x750E, KANJI_STANDARD,  // 甎
	0x750D, KANJI_STANDARD,  // 甍
	0x7515, KANJI_STANDARD,  // 甕
	0x7513, KANJI_STANDARD,  // 甓
	0x751E, KANJI_STANDARD,  // 甞
	0x7526, KANJI_STANDARD,  // 甦
	0x752C, KANJI_STANDARD,  // 甬
	0x753C, KANJI_STANDARD,  // 甼
	0x7544, KANJI_STANDARD,  // 畄
	0x754D, KANJI_STANDARD,  // 畍
	0x754A, KANJI_STANDARD,  // 畊
	0x7549, KANJI_STANDARD,  // 畉
	0x755B, KANJI_STANDARD,  // 畛
	0x7546, KANJI_STANDARD,  // 畆
	0x755A, KANJI_STANDARD,  // 畚
	0x7569, KANJI_STANDARD,  // 畩
	0x7564, KANJI_STANDARD,  // 畤
	0x7567, KANJI_STANDARD,  // 畧
	0x756B, KANJI_STANDARD,  // 畫
	0x756D, KANJI_STANDARD,  // 畭
	0x7578, KANJI_STANDARD,  // 畸
	0x7576, KANJI_STANDARD,  // 當
	0x7586, KANJI_STANDARD,  // 疆
	0x7587, KANJI_STANDARD,  // 疇
	0x7574, KANJI_STANDARD,  // 畴
	0x758A, KANJI_STANDARD,  // 疊
	0x7589, KANJI_STANDARD,  // 疉
	0x7582, KANJI_STANDARD,  // 疂
	0x7594, KANJI_STANDARD,  // 疔
	0x759A, KANJI_STANDARD,  // 疚
	0x759D, KANJI_STANDARD,  // 疝
	0x75A5, KANJI_STANDARD,  // 疥
	0x75A3, KANJI_STANDARD,  // 疣
	0x75C2, KANJI_STANDARD,  // 痂
	0x75B3, KANJI_STANDARD,  // 疳
	0x75C3, KANJI_STANDARD,  // 痃
	0x75B5, KANJI_STANDARD,  // 疵
	0x75BD, KANJI_STANDARD,  // 疽
	0x75B8, KANJI_STANDARD,  // 疸
	0x75BC, KANJI_STANDARD,  // 疼
	0x75B1, KANJI_STANDARD,  // 疱
	0x75CD, KANJI_STANDARD,  // 痍
	0x75CA, KANJI_STANDARD,  // 痊
	0x75D2, KANJI_STANDARD,  // 痒
	0x75D9, KANJI_STANDARD,  // 痙
	0x75E3, KANJI_STANDARD,  // 痣
	0x75DE, KANJI_STANDARD,  // 痞
	0x75FE, KANJI_STANDARD,  // 痾
	0x75FF, KANJI_STANDARD,  // 痿
	0x75FC, KANJI_STANDARD,  // 痼
	0x7601, KANJI_STANDARD,  // 瘁
	0x75F0, KANJI_STANDARD,  // 痰
	0x75FA, KANJI_STANDARD,  // 痺
	0x75F2, KANJI_STANDARD,  // 痲
	0x75F3, KANJI_STANDARD,  // 痳
	0x760B, KANJI_STANDARD,  // 瘋
	0x760D, KANJI_STANDARD,  // 瘍
	0x7609, KANJI_STANDARD,  // 瘉
	0x761F, KANJI_STANDARD,  // 瘟
	0x7627, KANJI_STANDARD,  // 瘧
	0x7620, KANJI_STANDARD,  // 瘠
	0x7621, KANJI_STANDARD,  // 瘡
	0x7622, KANJI_STANDARD,  // 瘢
	0x7624, KANJI_STANDARD,  // 瘤
	0x7634, KANJI_STANDARD,  // 瘴
	0x7630, KANJI_STANDARD,  // 瘰
	0x763B, KANJI_STANDARD,  // 瘻
	0x7647, KANJI_STANDARD,  // 癇
	0x7648, KANJI_STANDARD,  // 癈
	0x7646, KANJI_STANDARD,  // 癆
	0x765C, KANJI_STANDARD,  // 癜
	0x7658, KANJI_STANDARD,  // 癘
	0x7661, KANJI_STANDARD,  // 癡
	0x7662, KANJI_STANDARD,  // 癢
	0x7668, KANJI_STANDARD,  // 癨
	0x7669, KANJI_STANDARD,  // 癩
	0x766A, KANJI_STANDARD,  // 癪
	0x7667, KANJI_STANDARD,  // 癧
	0x766C, KANJI_STANDARD,  // 癬
	0x7670, KANJI_STANDARD,  // 癰
	0x7672, KANJI_STANDARD,  // 癲
	0x7676, KANJI_STANDARD,  // 癶
	0x7678, KANJI_STANDARD,  // 癸
	0x767C, KANJI_STANDARD,  // 發
	0x7680, KANJI_STANDARD,  // 皀
	0x7683, KANJI_STANDARD,  // 皃
	0x7688, KANJI_STANDARD,  // 皈
	0x768B, KANJI_STANDARD,  // 皋
	0x768E, KANJI_STANDARD,  // 皎
	0x7696, KANJI_STANDARD,  // 皖
	0x7693, KANJI_STANDARD,  // 皓
	0x7699, KANJI_STANDARD,  // 皙
	0x769A, KANJI_STANDARD,  // 皚
	0x76B0, KANJI_STANDARD,  // 皰
	0x76B4, KANJI_STANDARD,  // 皴
	0x76B8, KANJI_STANDARD,  // 皸
	0x76B9, KANJI_STANDARD,  // 皹
	0x76BA, KANJI_STANDARD,  // 皺
	0x76C2, KANJI_STANDARD,  // 盂
	0x76CD, KANJI_STANDARD,  // 盍
	0x76D6, KANJI_STANDARD,  // 盖
	0x76D2, KANJI_STANDARD,  // 盒
	0x76DE, KANJI_STANDARD,  // 盞
	0x76E1, KANJI_STANDARD,  // 盡
	0x76E5, KANJI_STANDARD,  // 盥
	0x76E7, KANJI_STANDARD,  // 盧
	0x76EA, KANJI_STANDARD,  // 盪
	0x862F, KANJI_STANDARD,  // 蘯
	0x76FB, KANJI_STANDARD,  // 盻
	0x7708, KANJI_STANDARD,  // 眈
	0x7707, KANJI_STANDARD,  // 眇
	0x7704, KANJI_STANDARD,  // 眄
	0x7729, KANJI_STANDARD,  // 眩
	0x7724, KANJI_STANDARD,  // 眤
	0x771E, KANJI_STANDARD,  // 眞
	0x7725, KANJI_STANDARD,  // 眥
	0x7726, KANJI_STANDARD,  // 眦
	0x771B, KANJI_STANDARD,  // 眛
	0x7737, KANJI_STANDARD,  // 眷
	0x7738, KANJI_STANDARD,  // 眸
	0x7747, KANJI_STANDARD,  // 睇
	0x775A, KANJI_STANDARD,  // 睚
	0x7768, KANJI_STANDARD,  // 睨
	0x776B, KANJI_STANDARD,  // 睫
	0x775B, KANJI_STANDARD,  // 睛
	0x7765, KANJI_STANDARD,  // 睥
	0x777F, KANJI_STANDARD,  // 睿
	0x777E, KANJI_STANDARD,  // 睾
	0x7779, KANJI_STANDARD,  // 睹
	0x778E, KANJI_STANDARD,  // 瞎
	0x778B, KANJI_STANDARD,  // 瞋
	0x7791, KANJI_STANDARD,  // 瞑
	0x77A0, KANJI_STANDARD,  // 瞠
	0x779E, KANJI_STANDARD,  // 瞞
	0x77B0, KANJI_STANDARD,  // 瞰
	0x77B6, KANJI_STANDARD,  // 瞶
	0x77B9, KANJI_STANDARD,  // 瞹
	0x77BF, KANJI_STANDARD,  // 瞿
	0x77BC, KANJI_STANDARD,  // 瞼
	0x77BD, KANJI_STANDARD,  // 瞽
	0x77BB, KANJI_STANDARD,  // 瞻
	0x77C7, KANJI_STANDARD,  // 矇
	0x77CD, KANJI_STANDARD,  // 矍
	0x77D7, KANJI_STANDARD,  // 矗
	0x77DA, KANJI_STANDARD,  // 矚
	0x77DC, KANJI_STANDARD,  // 矜
	0x77E3, KANJI_STANDARD,  // 矣
	0x77EE, KANJI_STANDARD,  // 矮
	0x77FC, KANJI_STANDARD,  // 矼
	0x780C, KANJI_STANDARD,  // 砌
	0x7812, KANJI_STANDARD,  // 砒
	0x7926, KANJI_STANDARD,  // 礦
	0x7820, KANJI_STANDARD,  // 砠
	0x792A, KANJI_STANDARD,  // 礪
	0x7845, KANJI_STANDARD,  // 硅
	0x788E, KANJI_STANDARD,  // 碎
	0x7874, KANJI_STANDARD,  // 硴
	0x7886, KANJI_STANDARD,  // 碆
	0x787C, KANJI_STANDARD,  // 硼
	0x789A, KANJI_STANDARD,  // 碚
	0x788C, KANJI_STANDARD,  // 碌
	0x78A3, KANJI_STANDARD,  // 碣
	0x78B5, KANJI_STANDARD,  // 碵
	0x78AA, KANJI_STANDARD,  // 碪
	0x78AF, KANJI_STANDARD,  // 碯
	0x78D1, KANJI_STANDARD,  // 磑
	0x78C6, KANJI_STANDARD,  // 磆
	0x78CB, KANJI_STANDARD,  // 磋
	0x78D4, KANJI_STANDARD,  // 磔
	0x78BE, KANJI_STANDARD,  // 碾
	0x78BC, KANJI_STANDARD,  // 碼
	0x78C5, KANJI_STANDARD,  // 磅
	0x78CA, KANJI_STANDARD,  // 磊
	0x78EC, KANJI_STANDARD,  // 磬
	0x78E7, KANJI_STANDARD,  // 磧
	0x78DA, KANJI_STANDARD,  // 磚
	0x78FD, KANJI_STANDARD,  // 磽
	0x78F4, KANJI_STANDARD,  // 磴
	0x7907, KANJI_STANDARD,  // 礇
	0x7912, KANJI_STANDARD,  // 礒
	0x7911, KANJI_STANDARD,  // 礑
	0x7919, KANJI_STANDARD,  // 礙
	0x792C, KANJI_STANDARD,  // 礬
	0x792B, KANJI_STANDARD,  // 礫
	0x7940, KANJI_STANDARD,  // 祀
	0x7960, KANJI_STANDARD,  // 祠
	0x7957, KANJI_STANDARD,  // 祗
	0x795F, KANJI_STANDARD,  // 祟
	0x795A, KANJI_STANDARD,  // 祚
	0x7955, KANJI_STANDARD,  // 祕
	0x7953, KANJI_STANDARD,  // 祓
	0x797A, KANJI_STANDARD,  // 祺
	0x797F, KANJI_STANDARD,  // 祿
	0x798A, KANJI_STANDARD,  // 禊
	0x799D, KANJI_STANDARD,  // 禝
	0x79A7, KANJI_STANDARD,  // 禧
	0x9F4B, KANJI_STANDARD,  // 齋
	0x79AA, KANJI_STANDARD,  // 禪
	0x79AE, KANJI_STANDARD,  // 禮
	0x79B3, KANJI_STANDARD,  // 禳
	0x79B9, KANJI_STANDARD,  // 禹
	0x79BA, KANJI_STANDARD,  // 禺
	0x79C9, KANJI_STANDARD,  // 秉
	0x79D5, KANJI_STANDARD,  // 秕
	0x79E7, KANJI_STANDARD,  // 秧
	0x79EC, KANJI_STANDARD,  // 秬
	0x79E1, KANJI_STANDARD,  // 秡
	0x79E3, KANJI_STANDARD,  // 秣
	0x7A08, KANJI_STANDARD,  // 稈
	0x7A0D, KANJI_STANDARD,  // 稍
	0x7A18, KANJI_STANDARD,  // 稘
	0x7A19, KANJI_STANDARD,  // 稙
	0x7A20, KANJI_STANDARD,  // 稠
	0x7A1F, KANJI_STANDARD,  // 稟
	0x7980, KANJI_STANDARD,  // 禀
	0x7A31, KANJI_STANDARD,  // 稱
	0x7A3B, KANJI_STANDARD,  // 稻
	0x7A3E, KANJI_STANDARD,  // 稾
	0x7A37, KANJI_STANDARD,  // 稷
	0x7A43, KANJI_STANDARD,  // 穃
	0x7A57, KANJI_STANDARD,  // 穗
	0x7A49, KANJI_STANDARD,  // 穉
	0x7A61, KANJI_STANDARD,  // 穡
	0x7A62, KANJI_STANDARD,  // 穢
	0x7A69, KANJI_STANDARD,  // 穩
	0x9F9D, KANJI_STANDARD,  // 龝
	0x7A70, KANJI_STANDARD,  // 穰
	0x7A79, KANJI_STANDARD,  // 穹
	0x7A7D, KANJI_STANDARD,  // 穽
	0x7A88, KANJI_STANDARD,  // 窈
	0x7A97, KANJI_STANDARD,  // 窗
	0x7A95, KANJI_STANDARD,  // 窕
	0x7A98, KANJI_STANDARD,  // 窘
	0x7A96, KANJI_STANDARD,  // 窖
	0x7AA9, KANJI_STANDARD,  // 窩
	0x7AC8, KANJI_STANDARD,  // 竈
	0x7AB0, KANJI_STANDARD,  // 窰
	0x7AB6, KANJI_STANDARD,  // 窶
	0x7AC5, KANJI_STANDARD,  // 竅
	0x7AC4, KANJI_STANDARD,  // 竄
	0x7ABF, KANJI_STANDARD,  // 窿
	0x9083, KANJI_STANDARD,  // 邃
	0x7AC7, KANJI_STANDARD,  // 竇
	0x7ACA, KANJI_STANDARD,  // 竊
	0x7ACD, KANJI_STANDARD,  // 竍
	0x7ACF, KANJI_STANDARD,  // 竏
	0x7AD5, KANJI_STANDARD,  // 竕
	0x7AD3, KANJI_STANDARD,  // 竓
	0x7AD9, KANJI_STANDARD,  // 站
	0x7ADA, KANJI_STANDARD,  // 竚
	0x7ADD, KANJI_STANDARD,  // 竝
	0x7AE1, KANJI_STANDARD,  // 竡
	0x7AE2, KANJI_STANDARD,  // 竢
	0x7AE6, KANJI_STANDARD,  // 竦
	0x7AED, KANJI_STANDARD,  // 竭
	0x7AF0, KANJI_STANDARD,  // 竰
	0x7B02, KANJI_STANDARD,  // 笂
	0x7B0F, KANJI_STANDARD,  // 笏
	0x7B0A, KANJI_STANDARD,  // 笊
	0x7B06, KANJI_STANDARD,  // 笆
	0x7B33, KANJI_STANDARD,  // 笳
	0x7B18, KANJI_STANDARD,  // 笘
	0x7B19, KANJI_STANDARD,  // 笙
	0x7B1E, KANJI_STANDARD,  // 笞
	0x7B35, KANJI_STANDARD,  // 笵
	0x7B28, KANJI_STANDARD,  // 笨
	0x7B36, KANJI_STANDARD,  // 笶
	0x7B50, KANJI_STANDARD,  // 筐
	0x7B7A, KANJI_STANDARD,  // 筺
	0x7B04, KANJI_STANDARD,  // 笄
	0x7B4D, KANJI_STANDARD,  // 筍
	0x7B0B, KANJI_STANDARD,  // 笋
	0x7B4C, KANJI_STANDARD,  // 筌
	0x7B45, KANJI_STANDARD,  // 筅
	0x7B75, KANJI_STANDARD,  // 筵
	0x7B65, KANJI_STANDARD,  // 筥
	0x7B74, KANJI_STANDARD,  // 筴
	0x7B67, KANJI_STANDARD,  // 筧
	0x7B70, KANJI_STANDARD,  // 筰
	0x7B71, KANJI_STANDARD,  // 筱
	0x7B6C, KANJI_STANDARD,  // 筬
	0x7B6E, KANJI_STANDARD,  // 筮
	0x7B9D, KANJI_STANDARD,  // 箝
	0x7B98, KANJI_STANDARD,  // 箘
	0x7B9F, KANJI_STANDARD,  // 箟
	0x7B8D, KANJI_STANDARD,  // 箍
	0x7B9C, KANJI_STANDARD,  // 箜
	0x7B9A, KANJI_STANDARD,  // 箚
	0x7B8B, KANJI_STANDARD,  // 箋
	0x7B92, KANJI_STANDARD,  // 箒
	0x7B8F, KANJI_STANDARD,  // 箏
	0x7B5D, KANJI_STANDARD,  // 筝
	0x7B99, KANJI_STANDARD,  // 箙
	0x7BCB, KANJI_STANDARD,  // 篋
	0x7BC1, KANJI_STANDARD,  // 篁
	0x7BCC, KANJI_STANDARD,  // 篌
	0x7BCF, KANJI_STANDARD,  // 篏
	0x7BB4, KANJI_STANDARD,  // 箴
	0x7BC6, KANJI_STANDARD,  // 篆
	0x7BDD, KANJI_STANDARD,  // 篝
	0x7BE9, KANJI_STANDARD,  // 篩
	0x7C11, KANJI_STANDARD,  // 簑
	0x7C14, KANJI_STANDARD,  // 簔
	0x7BE6, KANJI_STANDARD,  // 篦
	0x7BE5, KANJI_STANDARD,  // 篥
	0x7C60, KANJI_STANDARD,  // 籠
	0x7C00, KANJI_STANDARD,  // 簀
	0x7C07, KANJI_STANDARD,  // 簇
	0x7C13, KANJI_STANDARD,  // 簓
	0x7BF3, KANJI_STANDARD,  // 篳
	0x7BF7, KANJI_STANDARD,  // 篷
	0x7C17, KANJI_STANDARD,  // 簗
	0x7C0D, KANJI_STANDARD,  // 簍
	0x7BF6, KANJI_STANDARD,  // 篶
	0x7C23, KANJI_STANDARD,  // 簣
	0x7C27, KANJI_STANDARD,  // 簧
	0x7C2A, KANJI_STANDARD,  // 簪
	0x7C1F, KANJI_STANDARD,  // 簟
	0x7C37, KANJI_STANDARD,  // 簷
	0x7C2B, KANJI_STANDARD,  // 簫
	0x7C3D, KANJI_STANDARD,  // 簽
	0x7C4C, KANJI_STANDARD,  // 籌
	0x7C43, KANJI_STANDARD,  // 籃
	0x7C54, KANJI_STANDARD,  // 籔
	0x7C4F, KANJI_STANDARD,  // 籏
	0x7C40, KANJI_STANDARD,  // 籀
	0x7C50, KANJI_STANDARD,  // 籐
	0x7C58, KANJI_STANDARD,  // 籘
	0x7C5F, KANJI_STANDARD,  // 籟
	0x7C64, KANJI_STANDARD,  // 籤
	0x7C56, KANJI_STANDARD,  // 籖
	0x7C65, KANJI_STANDARD,  // 籥
	0x7C6C, KANJI_STANDARD,  // 籬
	0x7C75, KANJI_STANDARD,  // 籵
	0x7C83, KANJI_STANDARD,  // 粃
	0x7C90, KANJI_STANDARD,  // 粐
	0x7CA4, KANJI_STANDARD,  // 粤
	0x7CAD, KANJI_STANDARD,  // 粭
	0x7CA2, KANJI_STANDARD,  // 粢
	0x7CAB, KANJI_STANDARD,  // 粫
	0x7CA1, KANJI_STANDARD,  // 粡
	0x7CA8, KANJI_STANDARD,  // 粨
	0x7CB3, KANJI_STANDARD,  // 粳
	0x7CB2, KANJI_STANDARD,  // 粲
	0x7CB1, KANJI_STANDARD,  // 粱
	0x7CAE, KANJI_STANDARD,  // 粮
	0x7CB9, KANJI_STANDARD,  // 粹
	0x7CBD, KANJI_STANDARD,  // 粽
	0x7CC0, KANJI_STANDARD,  // 糀
	0x7CC5, KANJI_STANDARD,  // 糅
	0x7CC2, KANJI_STANDARD,  // 糂
	0x7CD8, KANJI_STANDARD,  // 糘
	0x7CD2, KANJI_STANDARD,  // 糒
	0x7CDC, KANJI_STANDARD,  // 糜
	0x7CE2, KANJI_STANDARD,  // 糢
	0x9B3B, KANJI_STANDARD,  // 鬻
	0x7CEF, KANJI_STANDARD,  // 糯
	0x7CF2, KANJI_STANDARD,  // 糲
	0x7CF4, KANJI_STANDARD,  // 糴
	0x7CF6, KANJI_STANDARD,  // 糶
	0x7CFA, KANJI_STANDARD,  // 糺
	0x7D06, KANJI_STANDARD,  // 紆
	0x7D02, KANJI_STANDARD,  // 紂
	0x7D1C, KANJI_STANDARD,  // 紜
	0x7D15, KANJI_STANDARD,  // 紕
	0x7D0A, KANJI_STANDARD,  // 紊
	0x7D45, KANJI_STANDARD,  // 絅
	0x7D4B, KANJI_STANDARD,  // 絋
	0x7D2E, KANJI_STANDARD,  // 紮
	0x7D32, KANJI_STANDARD,  // 紲
	0x7D3F, KANJI_STANDARD,  // 紿
	0x7D35, KANJI_STANDARD,  // 紵
	0x7D46, KANJI_STANDARD,  // 絆
	0x7D73, KANJI_STANDARD,  // 絳
	0x7D56, KANJI_STANDARD,  // 絖
	0x7D4E, KANJI_STANDARD,  // 絎
	0x7D72, KANJI_STANDARD,  // 絲
	0x7D68, KANJI_STANDARD,  // 絨
	0x7D6E, KANJI_STANDARD,  // 絮
	0x7D4F, KANJI_STANDARD,  // 絏
	0x7D63, KANJI_STANDARD,  // 絣
	0x7D93, KANJI_STANDARD,  // 經
	0x7D89, KANJI_STANDARD,  // 綉
	0x7D5B, KANJI_STANDARD,  // 絛
	0x7D8F, KANJI_STANDARD,  // 綏
	0x7D7D, KANJI_STANDARD,  // 絽
	0x7D9B, KANJI_STANDARD,  // 綛
	0x7DBA, KANJI_STANDARD,  // 綺
	0x7DAE, KANJI_STANDARD,  // 綮
	0x7DA3, KANJI_STANDARD,  // 綣
	0x7DB5, KANJI_STANDARD,  // 綵
	0x7DC7, KANJI_STANDARD,  // 緇
	0x7DBD, KANJI_STANDARD,  // 綽
	0x7DAB, KANJI_STANDARD,  // 綫
	0x7E3D, KANJI_STANDARD,  // 總
	0x7DA2, KANJI_STANDARD,  // 綢
	0x7DAF, KANJI_STANDARD,  // 綯
	0x7DDC, KANJI_STANDARD,  // 緜
	0x7DB8, KANJI_STANDARD,  // 綸
	0x7D9F, KANJI_STANDARD,  // 綟
	0x7DB0, KANJI_STANDARD,  // 綰
	0x7DD8, KANJI_STANDARD,  // 緘
	0x7DDD, KANJI_STANDARD,  // 緝
	0x7DE4, KANJI_STANDARD,  // 緤
	0x7DDE, KANJI_STANDARD,  // 緞
	0x7DFB, KANJI_STANDARD,  // 緻
	0x7DF2, KANJI_STANDARD,  // 緲
	0x7DE1, KANJI_STANDARD,  // 緡
	0x7E05, KANJI_STANDARD,  // 縅
	0x7E0A, KANJI_STANDARD,  // 縊
	0x7E23, KANJI_STANDARD,  // 縣
	0x7E21, KANJI_STANDARD,  // 縡
	0x7E12, KANJI_STANDARD,  // 縒
	0x7E31, KANJI_STANDARD,  // 縱
	0x7E1F, KANJI_STANDARD,  // 縟
	0x7E09, KANJI_STANDARD,  // 縉
	0x7E0B, KANJI_STANDARD,  // 縋
	0x7E22, KANJI_STANDARD,  // 縢
	0x7E46, KANJI_STANDARD,  // 繆
	0x7E66, KANJI_STANDARD,  // 繦
	0x7E3B, KANJI_STANDARD,  // 縻
	0x7E35, KANJI_STANDARD,  // 縵
	0x7E39, KANJI_STANDARD,  // 縹
	0x7E43, KANJI_STANDARD,  // 繃
	0x7E37, KANJI_STANDARD,  // 縷
	0x7E32, KANJI_STANDARD,  // 縲
	0x7E3A, KANJI_STANDARD,  // 縺
	0x7E67, KANJI_STANDARD,  // 繧
	0x7E5D, KANJI_STANDARD,  // 繝
	0x7E56, KANJI_STANDARD,  // 繖
	0x7E5E, KANJI_STANDARD,  // 繞
	0x7E59, KANJI_STANDARD,  // 繙
	0x7E5A, KANJI_STANDARD,  // 繚
	0x7E79, KANJI_STANDARD,  // 繹
	0x7E6A, KANJI_STANDARD,  // 繪
	0x7E69, KANJI_STANDARD,  // 繩
	0x7E7C, KANJI_STANDARD,  // 繼
	0x7E7B, KANJI_STANDARD,  // 繻
	0x7E83, KANJI_STANDARD,  // 纃
	0x7DD5, KANJI_STANDARD,  // 緕
	0x7E7D, KANJI_STANDARD,  // 繽
	0x8FAE, KANJI_STANDARD,  // 辮
	0x7E7F, KANJI_STANDARD,  // 繿
	0x7E88, KANJI_STANDARD,  // 纈
	0x7E89, KANJI_STANDARD,  // 纉
	0x7E8C, KANJI_STANDARD,  // 續
	0x7E92, KANJI_STANDARD,  // 纒
	0x7E90, KANJI_STANDARD,  // 纐
	0x7E93, KANJI_STANDARD,  // 纓
	0x7E94, KANJI_STANDARD,  // 纔
	0x7E96, KANJI_STANDARD,  // 纖
	0x7E8E, KANJI_STANDARD,  // 纎
	0x7E9B, KANJI_STANDARD,  // 纛
	0x7E9C, KANJI_STANDARD,  // 纜
	0x7F38, KANJI_STANDARD,  // 缸
	0x7F3A, KANJI_STANDARD,  // 缺
	0x7F45, KANJI_STANDARD,  // 罅
	0x7F4C, KANJI_STANDARD,  // 罌
	0x7F4D, KANJI_STANDARD,  // 罍
	0x7F4E, KANJI_STANDARD,  // 罎
	0x7F50, KANJI_STANDARD,  // 罐
	0x7F51, KANJI_STANDARD,  // 网
	0x7F55, KANJI_STANDARD,  // 罕
	0x7F54, KANJI_STANDARD,  // 罔
	0x7F58, KANJI_STANDARD,  // 罘
	0x7F5F, KANJI_STANDARD,  // 罟
	0x7F60, KANJI_STANDARD,  // 罠
	0x7F68, KANJI_STANDARD,  // 罨
	0x7F69, KANJI_STANDARD,  // 罩
	0x7F67, KANJI_STANDARD,  // 罧
	0x7F78, KANJI_STANDARD,  // 罸
	0x7F82, KANJI_STANDARD,  // 羂
	0x7F86, KANJI_STANDARD,  // 羆
	0x7F83, KANJI_STANDARD,  // 羃
	0x7F88, KANJI_STANDARD,  // 羈
	0x7F87, KANJI_STANDARD,  // 羇
	0x7F8C, KANJI_STANDARD,  // 羌
	0x7F94, KANJI_STANDARD,  // 羔
	0x7F9E, KANJI_STANDARD,  // 羞
	0x7F9D, KANJI_STANDARD,  // 羝
	0x7F9A, KANJI_STANDARD,  // 羚
	0x7FA3, KANJI_STANDARD,  // 羣
	0x7FAF, KANJI_STANDARD,  // 羯
	0x7FB2, KANJI_STANDARD,  // 羲
	0x7FB9, KANJI_STANDARD,  // 羹
	0x7FAE, KANJI_STANDARD,  // 羮
	0x7FB6, KANJI_STANDARD,  // 羶
	0x7FB8, KANJI_STANDARD,  // 羸
	0x8B71, KANJI_STANDARD,  // 譱
	0x7FC5, KANJI_STANDARD,  // 翅
	0x7FC6, KANJI_STANDARD,  // 翆
	0x7FCA, KANJI_STANDARD,  // 翊
	0x7FD5, KANJI_STANDARD,  // 翕
	0x7FD4, KANJI_STANDARD,  // 翔
	0x7FE1, KANJI_STANDARD,  // 翡
	0x7FE6, KANJI_STANDARD,  // 翦
	0x7FE9, KANJI_STANDARD,  // 翩
	0x7FF3, KANJI_STANDARD,  // 翳
	0x7FF9, KANJI_STANDARD,  // 翹
	0x98DC, KANJI_STANDARD,  // 飜
	0x8006, KANJI_STANDARD,  // 耆
	0x8004, KANJI_STANDARD,  // 耄
	0x800B, KANJI_STANDARD,  // 耋
	0x8012, KANJI_STANDARD,  // 耒
	0x8018, KANJI_STANDARD,  // 耘
	0x8019, KANJI_STANDARD,  // 耙
	0x801C, KANJI_STANDARD,  // 耜
	0x8021, KANJI_STANDARD,  // 耡
	0x8028, KANJI_STANDARD,  // 耨
	0x803F, KANJI_STANDARD,  // 耿
	0x803B, KANJI_STANDARD,  // 耻
	0x804A, KANJI_STANDARD,  // 聊
	0x8046, KANJI_STANDARD,  // 聆
	0x8052, KANJI_STANDARD,  // 聒
	0x8058, KANJI_STANDARD,  // 聘
	0x805A, KANJI_STANDARD,  // 聚
	0x805F, KANJI_STANDARD,  // 聟
	0x8062, KANJI_STANDARD,  // 聢
	0x8068, KANJI_STANDARD,  // 聨
	0x8073, KANJI_STANDARD,  // 聳
	0x8072, KANJI_STANDARD,  // 聲
	0x8070, KANJI_STANDARD,  // 聰
	0x8076, KANJI_STANDARD,  // 聶
	0x8079, KANJI_STANDARD,  // 聹
	0x807D, KANJI_STANDARD,  // 聽
	0x807F, KANJI_STANDARD,  // 聿
	0x8084, KANJI_STANDARD,  // 肄
	0x8086, KANJI_STANDARD,  // 肆
	0x8085, KANJI_STANDARD,  // 肅
	0x809B, KANJI_STANDARD,  // 肛
	0x8093, KANJI_STANDARD,  // 肓
	0x809A, KANJI_STANDARD,  // 肚
	0x80AD, KANJI_STANDARD,  // 肭
	0x5190, KANJI_STANDARD,  // 冐
	0x80AC, KANJI_STANDARD,  // 肬
	0x80DB, KANJI_STANDARD,  // 胛
	0x80E5, KANJI_STANDARD,  // 胥
	0x80D9, KANJI_STANDARD,  // 胙
	0x80DD, KANJI_STANDARD,  // 胝
	0x80C4, KANJI_STANDARD,  // 胄
	0x80DA, KANJI_STANDARD,  // 胚
	0x80D6, KANJI_STANDARD,  // 胖
	0x8109, KANJI_STANDARD,  // 脉
	0x80EF, KANJI_STANDARD,  // 胯
	0x80F1, KANJI_STANDARD,  // 胱
	0x811B, KANJI_STANDARD,  // 脛
	0x8129, KANJI_STANDARD,  // 脩
	0x8123, KANJI_STANDARD,  // 脣
	0x812F, KANJI_STANDARD,  // 脯
	0x814B, KANJI_STANDARD,  // 腋
	0x968B, KANJI_STANDARD,  // 隋
	0x8146, KANJI_STANDARD,  // 腆
	0x813E, KANJI_STANDARD,  // 脾
	0x8153, KANJI_STANDARD,  // 腓
	0x8151, KANJI_STANDARD,  // 腑
	0x80FC, KANJI_STANDARD,  // 胼
	0x8171, KANJI_STANDARD,  // 腱
	0x816E, KANJI_STANDARD,  // 腮
	0x8165, KANJI_STANDARD,  // 腥
	0x8166, KANJI_STANDARD,  // 腦
	0x8174, KANJI_STANDARD,  // 腴
	0x8183, KANJI_STANDARD,  // 膃
	0x8188, KANJI_STANDARD,  // 膈
	0x818A, KANJI_STANDARD,  // 膊
	0x8180, KANJI_STANDARD,  // 膀
	0x8182, KANJI_STANDARD,  // 膂
	0x81A0, KANJI_STANDARD,  // 膠
	0x8195, KANJI_STANDARD,  // 膕
	0x81A4, KANJI_STANDARD,  // 膤
	0x81A3, KANJI_STANDARD,  // 膣
	0x815F, KANJI_STANDARD,  // 腟
	0x8193, KANJI_STANDARD,  // 膓
	0x81A9, KANJI_STANDARD,  // 膩
	0x81B0, KANJI_STANDARD,  // 膰
	0x81B5, KANJI_STANDARD,  // 膵
	0x81BE, KANJI_STANDARD,  // 膾
	0x81B8, KANJI_STANDARD,  // 膸
	0x81BD, KANJI_STANDARD,  // 膽
	0x81C0, KANJI_STANDARD,  // 臀
	0x81C2, KANJI_STANDARD,  // 臂
	0x81BA, KANJI_STANDARD,  // 膺
	0x81C9, KANJI_STANDARD,  // 臉
	0x81CD, KANJI_STANDARD,  // 臍
	0x81D1, KANJI_STANDARD,  // 臑
	0x81D9, KANJI_STANDARD,  // 臙
	0x81D8, KANJI_STANDARD,  // 臘
	0x81C8, KANJI_STANDARD,  // 臈
	0x81DA, KANJI_STANDARD,  // 臚
	0x81DF, KANJI_STANDARD,  // 臟
	0x81E0, KANJI_STANDARD,  // 臠
	0x81E7, KANJI_STANDARD,  // 臧
	0x81FA, KANJI_STANDARD,  // 臺
	0x81FB, KANJI_STANDARD,  // 臻
	0x81FE, KANJI_STANDARD,  // 臾
	0x8201, KANJI_STANDARD,  // 舁
	0x8202, KANJI_STANDARD,  // 舂
	0x8205, KANJI_STANDARD,  // 舅
	0x8207, KANJI_STANDARD,  // 與
	0x820A, KANJI_STANDARD,  // 舊
	0x820D, KANJI_STANDARD,  // 舍
	0x8210, KANJI_STANDARD,  // 舐
	0x8216, KANJI_STANDARD,  // 舖
	0x8229, KANJI_STANDARD,  // 舩
	0x822B, KANJI_STANDARD,  // 舫
	0x8238, KANJI_STANDARD,  // 舸
	0x8233, KANJI_STANDARD,  // 舳
	0x8240, KANJI_STANDARD,  // 艀
	0x8259, KANJI_STANDARD,  // 艙
	0x8258, KANJI_STANDARD,  // 艘
	0x825D, KANJI_STANDARD,  // 艝
	0x825A, KANJI_STANDARD,  // 艚
	0x825F, KANJI_STANDARD,  // 艟
	0x8264, KANJI_STANDARD,  // 艤
	0x8262, KANJI_STANDARD,  // 艢
	0x8268, KANJI_STANDARD,  // 艨
	0x826A, KANJI_STANDARD,  // 艪
	0x826B, KANJI_STANDARD,  // 艫
	0x822E, KANJI_STANDARD,  // 舮
	0x8271, KANJI_STANDARD,  // 艱
	0x8277, KANJI_STANDARD,  // 艷
	0x8278, KANJI_STANDARD,  // 艸
	0x827E, KANJI_STANDARD,  // 艾
	0x828D, KANJI_STANDARD,  // 芍
	0x8292, KANJI_STANDARD,  // 芒
	0x82AB, KANJI_STANDARD,  // 芫
	0x829F, KANJI_STANDARD,  // 芟
	0x82BB, KANJI_STANDARD,  // 芻
	0x82AC, KANJI_STANDARD,  // 芬
	0x82E1, KANJI_STANDARD,  // 苡
	0x82E3, KANJI_STANDARD,  // 苣
	0x82DF, KANJI_STANDARD,  // 苟
	0x82D2, KANJI_STANDARD,  // 苒
	0x82F4, KANJI_STANDARD,  // 苴
	0x82F3, KANJI_STANDARD,  // 苳
	0x82FA, KANJI_STANDARD,  // 苺
	0x8393, KANJI_STANDARD,  // 莓
	0x8303, KANJI_STANDARD,  // 范
	0x82FB, KANJI_STANDARD,  // 苻
	0x82F9, KANJI_STANDARD,  // 苹
	0x82DE, KANJI_STANDARD,  // 苞
	0x8306, KANJI_STANDARD,  // 茆
	0x82DC, KANJI_STANDARD,  // 苜
	0x8309, KANJI_STANDARD,  // 茉
	0x82D9, KANJI_STANDARD,  // 苙
	0x8335, KANJI_STANDARD,  // 茵
	0x8334, KANJI_STANDARD,  // 茴
	0x8316, KANJI_STANDARD,  // 茖
	0x8332, KANJI_STANDARD,  // 茲
	0x8331, KANJI_STANDARD,  // 茱
	0x8340, KANJI_STANDARD,  // 荀
	0x8339, KANJI_STANDARD,  // 茹
	0x8350, KANJI_STANDARD,  // 荐
	0x8345, KANJI_STANDARD,  // 荅
	0x832F, KANJI_STANDARD,  // 茯
	0x832B, KANJI_STANDARD,  // 茫
	0x8317, KANJI_STANDARD,  // 茗
	0x8318, KANJI_STANDARD,  // 茘
	0x8385, KANJI_STANDARD,  // 莅
	0x839A, KANJI_STANDARD,  // 莚
	0x83AA, KANJI_STANDARD,  // 莪
	0x839F, KANJI_STANDARD,  // 莟
	0x83A2, KANJI_STANDARD,  // 莢
	0x8396, KANJI_STANDARD,  // 莖
	0x8323, KANJI_STANDARD,  // 茣
	0x838E, KANJI_STANDARD,  // 莎
	0x8387, KANJI_STANDARD,  // 莇
	0x838A, KANJI_STANDARD,  // 莊
	0x837C, KANJI_STANDARD,  // 荼
	0x83B5, KANJI_STANDARD,  // 莵
	0x8373, KANJI_STANDARD,  // 荳
	0x8375, KANJI_STANDARD,  // 荵
	0x83A0, KANJI_STANDARD,  // 莠
	0x8389, KANJI_STANDARD,  // 莉
	0x83A8, KANJI_STANDARD,  // 莨
	0x83F4, KANJI_STANDARD,  // 菴
	0x8413, KANJI_STANDARD,  // 萓
	0x83EB, KANJI_STANDARD,  // 菫
	0x83CE, KANJI_STANDARD,  // 菎
	0x83FD, KANJI_STANDARD,  // 菽
	0x8403, KANJI_STANDARD,  // 萃
	0x83D8, KANJI_STANDARD,  // 菘
	0x840B, KANJI_STANDARD,  // 萋
	0x83C1, KANJI_STANDARD,  // 菁
	0x83F7, KANJI_STANDARD,  // 菷
	0x8407, KANJI_STANDARD,  // 萇
	0x83E0, KANJI_STANDARD,  // 菠
	0x83F2, KANJI_STANDARD,  // 菲
	0x840D, KANJI_STANDARD,  // 萍
	0x8422, KANJI_STANDARD,  // 萢
	0x8420, KANJI_STANDARD,  // 萠
	0x83BD, KANJI_STANDARD,  // 莽
	0x8438, KANJI_STANDARD,  // 萸
	0x8506, KANJI_STANDARD,  // 蔆
	0x83FB, KANJI_STANDARD,  // 菻
	0x846D, KANJI_STANDARD,  // 葭
	0x842A, KANJI_STANDARD,  // 萪
	0x843C, KANJI_STANDARD,  // 萼
	0x855A, KANJI_STANDARD,  // 蕚
	0x8484, KANJI_STANDARD,  // 蒄
	0x8477, KANJI_STANDARD,  // 葷
	0x846B, KANJI_STANDARD,  // 葫
	0x84AD, KANJI_STANDARD,  // 蒭
	0x846E, KANJI_STANDARD,  // 葮
	0x8482, KANJI_STANDARD,  // 蒂
	0x8469, KANJI_STANDARD,  // 葩
	0x8446, KANJI_STANDARD,  // 葆
	0x842C, KANJI_STANDARD,  // 萬
	0x846F, KANJI_STANDARD,  // 葯
	0x8479, KANJI_STANDARD,  // 葹
	0x8435, KANJI_STANDARD,  // 萵
	0x84CA, KANJI_STANDARD,  // 蓊
	0x8462, KANJI_STANDARD,  // 葢
	0x84B9, KANJI_STANDARD,  // 蒹
	0x84BF, KANJI_STANDARD,  // 蒿
	0x849F, KANJI_STANDARD,  // 蒟
	0x84D9, KANJI_STANDARD,  // 蓙
	0x84CD, KANJI_STANDARD,  // 蓍
	0x84BB, KANJI_STANDARD,  // 蒻
	0x84DA, KANJI_STANDARD,  // 蓚
	0x84D0, KANJI_STANDARD,  // 蓐
	0x84C1, KANJI_STANDARD,  // 蓁
	0x84C6, KANJI_STANDARD,  // 蓆
	0x84D6, KANJI_STANDARD,  // 蓖
	0x84A1, KANJI_STANDARD,  // 蒡
	0x8521, KANJI_STANDARD,  // 蔡
	0x84FF, KANJI_STANDARD,  // 蓿
	0x84F4, KANJI_STANDARD,  // 蓴
	0x8517, KANJI_STANDARD,  // 蔗
	0x8518, KANJI_STANDARD,  // 蔘
	0x852C, KANJI_STANDARD,  // 蔬
	0x851F, KANJI_STANDARD,  // 蔟
	0x8515, KANJI_STANDARD,  // 蔕
	0x8514, KANJI_STANDARD,  // 蔔
	0x84FC, KANJI_STANDARD,  // 蓼
	0x8540, KANJI_STANDARD,  // 蕀
	0x8563, KANJI_STANDARD,  // 蕣
	0x8558, KANJI_STANDARD,  // 蕘
	0x8548, KANJI_STANDARD,  // 蕈
	0x8541, KANJI_STANDARD,  // 蕁
	0x8602, KANJI_STANDARD,  // 蘂
	0x854B, KANJI_STANDARD,  // 蕋
	0x8555, KANJI_STANDARD,  // 蕕
	0x8580, KANJI_STANDARD,  // 薀
	0x85A4, KANJI_STANDARD,  // 薤
	0x8588, KANJI_STANDARD,  // 薈
	0x8591, KANJI_STANDARD,  // 薑
	0x858A, KANJI_STANDARD,  // 薊
	0x85A8, KANJI_STANDARD,  // 薨
	0x856D, KANJI_STANDARD,  // 蕭
	0x8594, KANJI_STANDARD,  // 薔
	0x859B, KANJI_STANDARD,  // 薛
	0x85EA, KANJI_STANDARD,  // 藪
	0x8587, KANJI_STANDARD,  // 薇
	0x859C, KANJI_STANDARD,  // 薜
	0x8577, KANJI_STANDARD,  // 蕷
	0x857E, KANJI_STANDARD,  // 蕾
	0x8590, KANJI_STANDARD,  // 薐
	0x85C9, KANJI_STANDARD,  // 藉
	0x85BA, KANJI_STANDARD,  // 薺
	0x85CF, KANJI_STANDARD,  // 藏
	0x85B9, KANJI_STANDARD,  // 薹
	0x85D0, KANJI_STANDARD,  // 藐
	0x85D5, KANJI_STANDARD,  // 藕
	0x85DD, KANJI_STANDARD,  // 藝
	0x85E5, KANJI_STANDARD,  // 藥
	0x85DC, KANJI_STANDARD,  // 藜
	0x85F9, KANJI_STANDARD,  // 藹
	0x860A, KANJI_STANDARD,  // 蘊
	0x8613, KANJI_STANDARD,  // 蘓
	0x860B, KANJI_STANDARD,  // 蘋
	0x85FE, KANJI_STANDARD,  // 藾
	0x85FA, KANJI_STANDARD,  // 藺
	0x8606, KANJI_STANDARD,  // 蘆
	0x8622, KANJI_STANDARD,  // 蘢
	0x861A, KANJI_STANDARD,  // 蘚
	0x8630, KANJI_STANDARD,  // 蘰
	0x863F, KANJI_STANDARD,  // 蘿
	0x864D, KANJI_STANDARD,  // 虍
	0x4E55, KANJI_STANDARD,  // 乕
	0x8654, KANJI_STANDARD,  // 虔
	0x865F, KANJI_STANDARD,  // 號
	0x8667, KANJI_STANDARD,  // 虧
	0x8671, KANJI_STANDARD,  // 虱
	0x8693, KANJI_STANDARD,  // 蚓
	0x86A3, KANJI_STANDARD,  // 蚣
	0x86A9, KANJI_STANDARD,  // 蚩
	0x86AA, KANJI_STANDARD,  // 蚪
	0x868B, KANJI_STANDARD,  // 蚋
	0x868C, KANJI_STANDARD,  // 蚌
	0x86B6, KANJI_STANDARD,  // 蚶
	0x86AF, KANJI_STANDARD,  // 蚯
	0x86C4, KANJI_STANDARD,  // 蛄
	0x86C6, KANJI_STANDARD,  // 蛆
	0x86B0, KANJI_STANDARD,  // 蚰
	0x86C9, KANJI_STANDARD,  // 蛉
	0x8823, KANJI_STANDARD,  // 蠣
	0x86AB, KANJI_STANDARD,  // 蚫
	0x86D4, KANJI_STANDARD,  // 蛔
	0x86DE, KANJI_STANDARD,  // 蛞
	0x86E9, KANJI_STANDARD,  // 蛩
	0x86EC, KANJI_STANDARD,  // 蛬
	0x86DF, KANJI_STANDARD,  // 蛟
	0x86DB, KANJI_STANDARD,  // 蛛
	0x86EF, KANJI_STANDARD,  // 蛯
	0x8712, KANJI_STANDARD,  // 蜒
	0x8706, KANJI_STANDARD,  // 蜆
	0x8708, KANJI_STANDARD,  // 蜈
	0x8700, KANJI_STANDARD,  // 蜀
	0x8703, KANJI_STANDARD,  // 蜃
	0x86FB, KANJI_STANDARD,  // 蛻
	0x8711, KANJI_STANDARD,  // 蜑
	0x8709, KANJI_STANDARD,  // 蜉
	0x870D, KANJI_STANDARD,  // 蜍
	0x86F9, KANJI_STANDARD,  // 蛹
	0x870A, KANJI_STANDARD,  // 蜊
	0x8734, KANJI_STANDARD,  // 蜴
	0x873F, KANJI_STANDARD,  // 蜿
	0x8737, KANJI_STANDARD,  // 蜷
	0x873B, KANJI_STANDARD,  // 蜻
	0x8725, KANJI_STANDARD,  // 蜥
	0x8729, KANJI_STANDARD,  // 蜩
	0x871A, KANJI_STANDARD,  // 蜚
	0x8760, KANJI_STANDARD,  // 蝠
	0x875F, KANJI_STANDARD,  // 蝟
	0x8778, KANJI_STANDARD,  // 蝸
	0x874C, KANJI_STANDARD,  // 蝌
	0x874E, KANJI_STANDARD,  // 蝎
	0x8774, KANJI_STANDARD,  // 蝴
	0x8757, KANJI_STANDARD,  // 蝗
	0x8768, KANJI_STANDARD,  // 蝨
	0x876E, KANJI_STANDARD,  // 蝮
	0x8759, KANJI_STANDARD,  // 蝙
	0x8753, KANJI_STANDARD,  // 蝓
	0x8763, KANJI_STANDARD,  // 蝣
	0x876A, KANJI_STANDARD,  // 蝪
	0x8805, KANJI_STANDARD,  // 蠅
	0x87A2, KANJI_STANDARD,  // 螢
	0x879F, KANJI_STANDARD,  // 螟
	0x8782, KANJI_STANDARD,  // 螂
	0x87AF, KANJI_STANDARD,  // 螯
	0x87CB, KANJI_STANDARD,  // 蟋
	0x87BD, KANJI_STANDARD,  // 螽
	0x87C0, KANJI_STANDARD,  // 蟀
	0x87D0, KANJI_STANDARD,  // 蟐
	0x96D6, KANJI_STANDARD,  // 雖
	0x87AB, KANJI_STANDARD,  // 螫
	0x87C4, KANJI_STANDARD,  // 蟄
	0x87B3, KANJI_STANDARD,  // 螳
	0x87C7, KANJI_STANDARD,  // 蟇
	0x87C6, KANJI_STANDARD,  // 蟆
	0x87BB, KANJI_STANDARD,  // 螻
	0x87EF, KANJI_STANDARD,  // 蟯
	0x87F2, KANJI_STANDARD,  // 蟲
	0x87E0, KANJI_STANDARD,  // 蟠
	0x880F, KANJI_STANDARD,  // 蠏
	0x880D, KANJI_STANDARD,  // 蠍
	0x87FE, KANJI_STANDARD,  // 蟾
	0x87F6, KANJI_STANDARD,  // 蟶
	0x87F7, KANJI_STANDARD,  // 蟷
	0x880E, KANJI_STANDARD,  // 蠎
	0x87D2, KANJI_STANDARD,  // 蟒
	0x8811, KANJI_STANDARD,  // 蠑
	0x8816, KANJI_STANDARD,  // 蠖
	0x8815, KANJI_STANDARD,  // 蠕
	0x8822, KANJI_STANDARD,  // 蠢
	0x8821, KANJI_STANDARD,  // 蠡
	0x8831, KANJI_STANDARD,  // 蠱
	0x8836, KANJI_STANDARD,  // 蠶
	0x8839, KANJI_STANDARD,  // 蠹
	0x8827, KANJI_STANDARD,  // 蠧
	0x883B, KANJI_STANDARD,  // 蠻
	0x8844, KANJI_STANDARD,  // 衄
	0x8842, KANJI_STANDARD,  // 衂
	0x8852, KANJI_STANDARD,  // 衒
	0x8859, KANJI_STANDARD,  // 衙
	0x885E, KANJI_STANDARD,  // 衞
	0x8862, KANJI_STANDARD,  // 衢
	0x886B, KANJI_STANDARD,  // 衫
	0x8881, KANJI_STANDARD,  // 袁
	0x887E, KANJI_STANDARD,  // 衾
	0x889E, KANJI_STANDARD,  // 袞
	0x8875, KANJI_STANDARD,  // 衵
	0x887D, KANJI_STANDARD,  // 衽
	0x88B5, KANJI_STANDARD,  // 袵
	0x8872, KANJI_STANDARD,  // 衲
	0x8882, KANJI_STANDARD,  // 袂
	0x8897, KANJI_STANDARD,  // 袗
	0x8892, KANJI_STANDARD,  // 袒
	0x88AE, KANJI_STANDARD,  // 袮
	0x8899, KANJI_STANDARD,  // 袙
	0x88A2, KANJI_STANDARD,  // 袢
	0x888D, KANJI_STANDARD,  // 袍
	0x88A4, KANJI_STANDARD,  // 袤
	0x88B0, KANJI_STANDARD,  // 袰
	0x88BF, KANJI_STANDARD,  // 袿
	0x88B1, KANJI_STANDARD,  // 袱
	0x88C3, KANJI_STANDARD,  // 裃
	0x88C4, KANJI_STANDARD,  // 裄
	0x88D4, KANJI_STANDARD,  // 裔
	0x88D8, KANJI_STANDARD,  // 裘
	0x88D9, KANJI_STANDARD,  // 裙
	0x88DD, KANJI_STANDARD,  // 裝
	0x88F9, KANJI_STANDARD,  // 裹
	0x8902, KANJI_STANDARD,  // 褂
	0x88FC, KANJI_STANDARD,  // 裼
	0x88F4, KANJI_STANDARD,  // 裴
	0x88E8, KANJI_STANDARD,  // 裨
	0x88F2, KANJI_STANDARD,  // 裲
	0x8904, KANJI_STANDARD,  // 褄
	0x890C, KANJI_STANDARD,  // 褌
	0x890A, KANJI_STANDARD,  // 褊
	0x8913, KANJI_STANDARD,  // 褓
	0x8943, KANJI_STANDARD,  // 襃
	0x891E, KANJI_STANDARD,  // 褞
	0x8925, KANJI_STANDARD,  // 褥
	0x892A, KANJI_STANDARD,  // 褪
	0x892B, KANJI_STANDARD,  // 褫
	0x8941, KANJI_STANDARD,  // 襁
	0x8944, KANJI_STANDARD,  // 襄
	0x893B, KANJI_STANDARD,  // 褻
	0x8936, KANJI_STANDARD,  // 褶
	0x8938, KANJI_STANDARD,  // 褸
	0x894C, KANJI_STANDARD,  // 襌
	0x891D, KANJI_STANDARD,  // 褝
	0x8960, KANJI_STANDARD,  // 襠
	0x895E, KANJI_STANDARD,  // 襞
	0x8966, KANJI_STANDARD,  // 襦
	0x8964, KANJI_STANDARD,  // 襤
	0x896D, KANJI_STANDARD,  // 襭
	0x896A, KANJI_STANDARD,  // 襪
	0x896F, KANJI_STANDARD,  // 襯
	0x8974, KANJI_STANDARD,  // 襴
	0x8977, KANJI_STANDARD,  // 襷
	0x897E, KANJI_STANDARD,  // 襾
	0x8983, KANJI_STANDARD,  // 覃
	0x8988, KANJI_STANDARD,  // 覈
	0x898A, KANJI_STANDARD,  // 覊
	0x8993, KANJI_STANDARD,  // 覓
	0x8998, KANJI_STANDARD,  // 覘
	0x89A1, KANJI_STANDARD,  // 覡
	0x89A9, KANJI_STANDARD,  // 覩
	0x89A6, KANJI_STANDARD,  // 覦
	0x89AC, KANJI_STANDARD,  // 覬
	0x89AF, KANJI_STANDARD,  // 覯
	0x89B2, KANJI_STANDARD,  // 覲
	0x89BA, KANJI_STANDARD,  // 覺
	0x89BD, KANJI_STANDARD,  // 覽
	0x89BF, KANJI_STANDARD,  // 覿
	0x89C0, KANJI_STANDARD,  // 觀
	0x89DA, KANJI_STANDARD,  // 觚
	0x89DC, KANJI_STANDARD,  // 觜
	0x89DD, KANJI_STANDARD,  // 觝
	0x89E7, KANJI_STANDARD,  // 觧
	0x89F4, KANJI_STANDARD,  // 觴
	0x89F8, KANJI_STANDARD,  // 觸
	0x8A03, KANJI_STANDARD,  // 訃
	0x8A16, KANJI_STANDARD,  // 訖
	0x8A10, KANJI_STANDARD,  // 訐
	0x8A0C, KANJI_STANDARD,  // 訌
	0x8A1B, KANJI_STANDARD,  // 訛
	0x8A1D, KANJI_STANDARD,  // 訝
	0x8A25, KANJI_STANDARD,  // 訥
	0x8A36, KANJI_STANDARD,  // 訶
	0x8A41, KANJI_STANDARD,  // 詁
	0x8A5B, KANJI_STANDARD,  // 詛
	0x8A52, KANJI_STANDARD,  // 詒
	0x8A46, KANJI_STANDARD,  // 詆
	0x8A48, KANJI_STANDARD,  // 詈
	0x8A7C, KANJI_STANDARD,  // 詼
	0x8A6D, KANJI_STANDARD,  // 詭
	0x8A6C, KANJI_STANDARD,  // 詬
	0x8A62, KANJI_STANDARD,  // 詢
	0x8A85, KANJI_STANDARD,  // 誅
	0x8A82, KANJI_STANDARD,  // 誂
	0x8A84, KANJI_STANDARD,  // 誄
	0x8AA8, KANJI_STANDARD,  // 誨
	0x8AA1, KANJI_STANDARD,  // 誡
	0x8A91, KANJI_STANDARD,  // 誑
	0x8AA5, KANJI_STANDARD,  // 誥
	0x8AA6, KANJI_STANDARD,  // 誦
	0x8A9A, KANJI_STANDARD,  // 誚
	0x8AA3, KANJI_STANDARD,  // 誣
	0x8AC4, KANJI_STANDARD,  // 諄
	0x8ACD, KANJI_STANDARD,  // 諍
	0x8AC2, KANJI_STANDARD,  // 諂
	0x8ADA, KANJI_STANDARD,  // 諚
	0x8AEB, KANJI_STANDARD,  // 諫
	0x8AF3, KANJI_STANDARD,  // 諳
	0x8AE7, KANJI_STANDARD,  // 諧
	0x8AE4, KANJI_STANDARD,  // 諤
	0x8AF1, KANJI_STANDARD,  // 諱
	0x8B14, KANJI_STANDARD,  // 謔
	0x8AE0, KANJI_STANDARD,  // 諠
	0x8AE2, KANJI_STANDARD,  // 諢
	0x8AF7, KANJI_STANDARD,  // 諷
	0x8ADE, KANJI_STANDARD,  // 諞
	0x8ADB, KANJI_STANDARD,  // 諛
	0x8B0C, KANJI_STANDARD,  // 謌
	0x8B07, KANJI_STANDARD,  // 謇
	0x8B1A, KANJI_STANDARD,  // 謚
	0x8AE1, KANJI_STANDARD,  // 諡
	0x8B16, KANJI_STANDARD,  // 謖
	0x8B10, KANJI_STANDARD,  // 謐
	0x8B17, KANJI_STANDARD,  // 謗
	0x8B20, KANJI_STANDARD,  // 謠
	0x8B33, KANJI_STANDARD,  // 謳
	0x97AB, KANJI_STANDARD,  // 鞫
	0x8B26, KANJI_STANDARD,  // 謦
	0x8B2B, KANJI_STANDARD,  // 謫
	0x8B3E, KANJI_STANDARD,  // 謾
	0x8B28, KANJI_STANDARD,  // 謨
	0x8B41, KANJI_STANDARD,  // 譁
	0x8B4C, KANJI_STANDARD,  // 譌
	0x8B4F, KANJI_STANDARD,  // 譏
	0x8B4E, KANJI_STANDARD,  // 譎
	0x8B49, KANJI_STANDARD,  // 證
	0x8B56, KANJI_STANDARD,  // 譖
	0x8B5B, KANJI_STANDARD,  // 譛
	0x8B5A, KANJI_STANDARD,  // 譚
	0x8B6B, KANJI_STANDARD,  // 譫
	0x8B5F, KANJI_STANDARD,  // 譟
	0x8B6C, KANJI_STANDARD,  // 譬
	0x8B6F, KANJI_STANDARD,  // 譯
	0x8B74, KANJI_STANDARD,  // 譴
	0x8B7D, KANJI_STANDARD,  // 譽
	0x8B80, KANJI_STANDARD,  // 讀
	0x8B8C, KANJI_STANDARD,  // 讌
	0x8B8E, KANJI_STANDARD,  // 讎
	0x8B92, KANJI_STANDARD,  // 讒
	0x8B93, KANJI_STANDARD,  // 讓
	0x8B96, KANJI_STANDARD,  // 讖
	0x8B99, KANJI_STANDARD,  // 讙
	0x8B9A, KANJI_STANDARD,  // 讚
	0x8C3A, KANJI_STANDARD,  // 谺
	0x8C41, KANJI_STANDARD,  // 豁
	0x8C3F, KANJI_STANDARD,  // 谿
	0x8C48, KANJI_STANDARD,  // 豈
	0x8C4C, KANJI_STANDARD,  // 豌
	0x8C4E, KANJI_STANDARD,  // 豎
	0x8C50, KANJI_STANDARD,  // 豐
	0x8C55, KANJI_STANDARD,  // 豕
	0x8C62, KANJI_STANDARD,  // 豢
	0x8C6C, KANJI_STANDARD,  // 豬
	0x8C78, KANJI_STANDARD,  // 豸
	0x8C7A, KANJI_STANDARD,  // 豺
	0x8C82, KANJI_STANDARD,  // 貂
	0x8C89, KANJI_STANDARD,  // 貉
	0x8C85, KANJI_STANDARD,  // 貅
	0x8C8A, KANJI_STANDARD,  // 貊
	0x8C8D, KANJI_STANDARD,  // 貍
	0x8C8E, KANJI_STANDARD,  // 貎
	0x8C94, KANJI_STANDARD,  // 貔
	0x8C7C, KANJI_STANDARD,  // 豼
	0x8C98, KANJI_STANDARD,  // 貘
	0x621D, KANJI_STANDARD,  // 戝
	0x8CAD, KANJI_STANDARD,  // 貭
	0x8CAA, KANJI_STANDARD,  // 貪
	0x8CBD, KANJI_STANDARD,  // 貽
	0x8CB2, KANJI_STANDARD,  // 貲
	0x8CB3, KANJI_STANDARD,  // 貳
	0x8CAE, KANJI_STANDARD,  // 貮
	0x8CB6, KANJI_STANDARD,  // 貶
	0x8CC8, KANJI_STANDARD,  // 賈
	0x8CC1, KANJI_STANDARD,  // 賁
	0x8CE4, KANJI_STANDARD,  // 賤
	0x8CE3, KANJI_STANDARD,  // 賣
	0x8CDA, KANJI_STANDARD,  // 賚
	0x8CFD, KANJI_STANDARD,  // 賽
	0x8CFA, KANJI_STANDARD,  // 賺
	0x8CFB, KANJI_STANDARD,  // 賻
	0x8D04, KANJI_STANDARD,  // 贄
	0x8D05, KANJI_STANDARD,  // 贅
	0x8D0A, KANJI_STANDARD,  // 贊
	0x8D07, KANJI_STANDARD,  // 贇
	0x8D0F, KANJI_STANDARD,  // 贏
	0x8D0D, KANJI_STANDARD,  // 贍
	0x8D10, KANJI_STANDARD,  // 贐
	0x9F4E, KANJI_STANDARD,  // 齎
	0x8D13, KANJI_STANDARD,  // 贓
	0x8CCD, KANJI_STANDARD,  // 賍
	0x8D14, KANJI_STANDARD,  // 贔
	0x8D16, KANJI_STANDARD,  // 贖
	0x8D67, KANJI_STANDARD,  // 赧
	0x8D6D, KANJI_STANDARD,  // 赭
	0x8D71, KANJI_STANDARD,  // 赱
	0x8D73, KANJI_STANDARD,  // 赳
	0x8D81, KANJI_STANDARD,  // 趁
	0x8D99, KANJI_STANDARD,  // 趙
	0x8DC2, KANJI_STANDARD,  // 跂
	0x8DBE, KANJI_STANDARD,  // 趾
	0x8DBA, KANJI_STANDARD,  // 趺
	0x8DCF, KANJI_STANDARD,  // 跏
	0x8DDA, KANJI_STANDARD,  // 跚
	0x8DD6, KANJI_STANDARD,  // 跖
	0x8DCC, KANJI_STANDARD,  // 跌
	0x8DDB, KANJI_STANDARD,  // 跛
	0x8DCB, KANJI_STANDARD,  // 跋
	0x8DEA, KANJI_STANDARD,  // 跪
	0x8DEB, KANJI_STANDARD,  // 跫
	0x8DDF, KANJI_STANDARD,  // 跟
	0x8DE3, KANJI_STANDARD,  // 跣
	0x8DFC, KANJI_STANDARD,  // 跼
	0x8E08, KANJI_STANDARD,  // 踈
	0x8E09, KANJI_STANDARD,  // 踉
	0x8DFF, KANJI_STANDARD,  // 跿
	0x8E1D, KANJI_STANDARD,  // 踝
	0x8E1E, KANJI_STANDARD,  // 踞
	0x8E10, KANJI_STANDARD,  // 踐
	0x8E1F, KANJI_STANDARD,  // 踟
	0x8E42, KANJI_STANDARD,  // 蹂
	0x8E35, KANJI_STANDARD,  // 踵
	0x8E30, KANJI_STANDARD,  // 踰
	0x8E34, KANJI_STANDARD,  // 踴
	0x8E4A, KANJI_STANDARD,  // 蹊
	0x8E47, KANJI_STANDARD,  // 蹇
	0x8E49, KANJI_STANDARD,  // 蹉
	0x8E4C, KANJI_STANDARD,  // 蹌
	0x8E50, KANJI_STANDARD,  // 蹐
	0x8E48, KANJI_STANDARD,  // 蹈
	0x8E59, KANJI_STANDARD,  // 蹙
	0x8E64, KANJI_STANDARD,  // 蹤
	0x8E60, KANJI_STANDARD,  // 蹠
	0x8E2A, KANJI_STANDARD,  // 踪
	0x8E63, KANJI_STANDARD,  // 蹣
	0x8E55, KANJI_STANDARD,  // 蹕
	0x8E76, KANJI_STANDARD,  // 蹶
	0x8E72, KANJI_STANDARD,  // 蹲
	0x8E7C, KANJI_STANDARD,  // 蹼
	0x8E81, KANJI_STANDARD,  // 躁
	0x8E87, KANJI_STANDARD,  // 躇
	0x8E85, KANJI_STANDARD,  // 躅
	0x8E84, KANJI_STANDARD,  // 躄
	0x8E8B, KANJI_STANDARD,  // 躋
	0x8E8A, KANJI_STANDARD,  // 躊
	0x8E93, KANJI_STANDARD,  // 躓
	0x8E91, KANJI_STANDARD,  // 躑
	0x8E94, KANJI_STANDARD,  // 躔
	0x8E99, KANJI_STANDARD,  // 躙
	0x8EAA, KANJI_STANDARD,  // 躪
	0x8EA1, KANJI_STANDARD,  // 躡
	0x8EAC, KANJI_STANDARD,  // 躬
	0x8EB0, KANJI_STANDARD,  // 躰
	0x8EC6, KANJI_STANDARD,  // 軆
	0x8EB1, KANJI_STANDARD,  // 躱
	0x8EBE, KANJI_STANDARD,  // 躾
	0x8EC5, KANJI_STANDARD,  // 軅
	0x8EC8, KANJI_STANDARD,  // 軈
	0x8ECB, KANJI_STANDARD,  // 軋
	0x8EDB, KANJI_STANDARD,  // 軛
	0x8EE3, KANJI_STANDARD,  // 軣
	0x8EFC, KANJI_STANDARD,  // 軼
	0x8EFB, KANJI_STANDARD,  // 軻
	0x8EEB, KANJI_STANDARD,  // 軫
	0x8EFE, KANJI_STANDARD,  // 軾
	0x8F0A, KANJI_STANDARD,  // 輊
	0x8F05, KANJI_STANDARD,  // 輅
	0x8F15, KANJI_STANDARD,  // 輕
	0x8F12, KANJI_STANDARD,  // 輒
	0x8F19, KANJI_STANDARD,  // 輙
	0x8F13, KANJI_STANDARD,  // 輓
	0x8F1C, KANJI_STANDARD,  // 輜
	0x8F1F, KANJI_STANDARD,  // 輟
	0x8F1B, KANJI_STANDARD,  // 輛
	0x8F0C, KANJI_STANDARD,  // 輌
	0x8F26, KANJI_STANDARD,  // 輦
	0x8F33, KANJI_STANDARD,  // 輳
	0x8F3B, KANJI_STANDARD,  // 輻
	0x8F39, KANJI_STANDARD,  // 輹
	0x8F45, KANJI_STANDARD,  // 轅
	0x8F42, KANJI_STANDARD,  // 轂
	0x8F3E, KANJI_STANDARD,  // 輾
	0x8F4C, KANJI_STANDARD,  // 轌
	0x8F49, KANJI_STANDARD,  // 轉
	0x8F46, KANJI_STANDARD,  // 轆
	0x8F4E, KANJI_STANDARD,  // 轎
	0x8F57, KANJI_STANDARD,  // 轗
	0x8F5C, KANJI_STANDARD,  // 轜
	0x8F62, KANJI_STANDARD,  // 轢
	0x8F63, KANJI_STANDARD,  // 轣
	0x8F64, KANJI_STANDARD,  // 轤
	0x8F9C, KANJI_STANDARD,  // 辜
	0x8F9F, KANJI_STANDARD,  // 辟
	0x8FA3, KANJI_STANDARD,  // 辣
	0x8FAD, KANJI_STANDARD,  // 辭
	0x8FAF, KANJI_STANDARD,  // 辯
	0x8FB7, KANJI_STANDARD,  // 辷
	0x8FDA, KANJI_STANDARD,  // 迚
	0x8FE5, KANJI_STANDARD,  // 迥
	0x8FE2, KANJI_STANDARD,  // 迢
	0x8FEA, KANJI_STANDARD,  // 迪
	0x8FEF, KANJI_STANDARD,  // 迯
	0x9087, KANJI_STANDARD,  // 邇
	0x8FF4, KANJI_STANDARD,  // 迴
	0x9005, KANJI_STANDARD,  // 逅
	0x8FF9, KANJI_STANDARD,  // 迹
	0x8FFA, KANJI_STANDARD,  // 迺
	0x9011, KANJI_STANDARD,  // 逑
	0x9015, KANJI_STANDARD,  // 逕
	0x9021, KANJI_STANDARD,  // 逡
	0x900D, KANJI_STANDARD,  // 逍
	0x901E, KANJI_STANDARD,  // 逞
	0x9016, KANJI_STANDARD,  // 逖
	0x900B, KANJI_STANDARD,  // 逋
	0x9027, KANJI_STANDARD,  // 逧
	0x9036, KANJI_STANDARD,  // 逶
	0x9035, KANJI_STANDARD,  // 逵
	0x9039, KANJI_STANDARD,  // 逹
	0x8FF8, KANJI_STANDARD,  // 迸
	0x904F, KANJI_STANDARD,  // 遏
	0x9050, KANJI_STANDARD,  // 遐
	0x9051, KANJI_STANDARD,  // 遑
	0x9052, KANJI_STANDARD,  // 遒
	0x900E, KANJI_STANDARD,  // 逎
	0x9049, KANJI_STANDARD,  // 遉
	0x903E, KANJI_STANDARD,  // 逾
	0x9056, KANJI_STANDARD,  // 遖
	0x9058, KANJI_STANDARD,  // 遘
	0x905E, KANJI_STANDARD,  // 遞
	0x9068, KANJI_STANDARD,  // 遨
	0x906F, KANJI_STANDARD,  // 遯
	0x9076, KANJI_STANDARD,  // 遶
	0x96A8, KANJI_STANDARD,  // 隨
	0x9072, KANJI_STANDARD,  // 遲
	0x9082, KANJI_STANDARD,  // 邂
	0x907D, KANJI_STANDARD,  // 遽
	0x9081, KANJI_STANDARD,  // 邁
	0x9080, KANJI_STANDARD,  // 邀
	0x908A, KANJI_STANDARD,  // 邊
	0x9089, KANJI_STANDARD,  // 邉
	0x908F, KANJI_STANDARD,  // 邏
	0x90A8, KANJI_STANDARD,  // 邨
	0x90AF, KANJI_STANDARD,  // 邯
	0x90B1, KANJI_STANDARD,  // 邱
	0x90B5, KANJI_STANDARD,  // 邵
	0x90E2, KANJI_STANDARD,  // 郢
	0x90E4, KANJI_STANDARD,  // 郤
	0x6248, KANJI_STANDARD,  // 扈
	0x90DB, KANJI_STANDARD,  // 郛
	0x9102, KANJI_STANDARD,  // 鄂
	0x9112, KANJI_STANDARD,  // 鄒
	0x9119, KANJI_STANDARD,  // 鄙
	0x9132, KANJI_STANDARD,  // 鄲
	0x9130, KANJI_STANDARD,  // 鄰
	0x914A, KANJI_STANDARD,  // 酊
	0x9156, KANJI_STANDARD,  // 酖
	0x9158, KANJI_STANDARD,  // 酘
	0x9163, KANJI_STANDARD,  // 酣
	0x9165, KANJI_STANDARD,  // 酥
	0x9169, KANJI_STANDARD,  // 酩
	0x9173, KANJI_STANDARD,  // 酳
	0x9172, KANJI_STANDARD,  // 酲
	0x918B, KANJI_STANDARD,  // 醋
	0x9189, KANJI_STANDARD,  // 醉
	0x9182, KANJI_STANDARD,  // 醂
	0x91A2, KANJI_STANDARD,  // 醢
	0x91AB, KANJI_STANDARD,  // 醫
	0x91AF, KANJI_STANDARD,  // 醯
	0x91AA, KANJI_STANDARD,  // 醪
	0x91B5, KANJI_STANDARD,  // 醵
	0x91B4, KANJI_STANDARD,  // 醴
	0x91BA, KANJI_STANDARD,  // 醺
	0x91C0, KANJI_STANDARD,  // 釀
	0x91C1, KANJI_STANDARD,  // 釁
	0x91C9, KANJI_STANDARD,  // 釉
	0x91CB, KANJI_STANDARD,  // 釋
	0x91D0, KANJI_STANDARD,  // 釐
	0x91D6, KANJI_STANDARD,  // 釖
	0x91DF, KANJI_STANDARD,  // 釟
	0x91E1, KANJI_STANDARD,  // 釡
	0x91DB, KANJI_STANDARD,  // 釛
	0x91FC, KANJI_STANDARD,  // 釼
	0x91F5, KANJI_STANDARD,  // 釵
	0x91F6, KANJI_STANDARD,  // 釶
	0x921E, KANJI_STANDARD,  // 鈞
	0x91FF, KANJI_STANDARD,  // 釿
	0x9214, KANJI_STANDARD,  // 鈔
	0x922C, KANJI_STANDARD,  // 鈬
	0x9215, KANJI_STANDARD,  // 鈕
	0x9211, KANJI_STANDARD,  // 鈑
	0x925E, KANJI_STANDARD,  // 鉞
	0x9257, KANJI_STANDARD,  // 鉗
	0x9245, KANJI_STANDARD,  // 鉅
	0x9249, KANJI_STANDARD,  // 鉉
	0x9264, KANJI_STANDARD,  // 鉤
	0x9248, KANJI_STANDARD,  // 鉈
	0x9295, KANJI_STANDARD,  // 銕
	0x923F, KANJI_STANDARD,  // 鈿
	0x924B, KANJI_STANDARD,  // 鉋
	0x9250, KANJI_STANDARD,  // 鉐
	0x929C, KANJI_STANDARD,  // 銜
	0x9296, KANJI_STANDARD,  // 銖
	0x9293, KANJI_STANDARD,  // 銓
	0x929B, KANJI_STANDARD,  // 銛
	0x925A, KANJI_STANDARD,  // 鉚
	0x92CF, KANJI_STANDARD,  // 鋏
	0x92B9, KANJI_STANDARD,  // 銹
	0x92B7, KANJI_STANDARD,  // 銷
	0x92E9, KANJI_STANDARD,  // 鋩
	0x930F, KANJI_STANDARD,  // 錏
	0x92FA, KANJI_STANDARD,  // 鋺
	0x9344, KANJI_STANDARD,  // 鍄
	0x932E, KANJI_STANDARD,  // 錮
	0x9319, KANJI_STANDARD,  // 錙
	0x9322, KANJI_STANDARD,  // 錢
	0x931A, KANJI_STANDARD,  // 錚
	0x9323, KANJI_STANDARD,  // 錣
	0x933A, KANJI_STANDARD,  // 錺
	0x9335, KANJI_STANDARD,  // 錵
	0x933B, KANJI_STANDARD,  // 錻
	0x935C, KANJI_STANDARD,  // 鍜
	0x9360, KANJI_STANDARD,  // 鍠
	0x937C, KANJI_STANDARD,  // 鍼
	0x936E, KANJI_STANDARD,  // 鍮
	0x9356, KANJI_STANDARD,  // 鍖
	0x93B0, KANJI_STANDARD,  // 鎰
	0x93AC, KANJI_STANDARD,  // 鎬
	0x93AD, KANJI_STANDARD,  // 鎭
	0x9394, KANJI_STANDARD,  // 鎔
	0x93B9, KANJI_STANDARD,  // 鎹
	0x93D6, KANJI_STANDARD,  // 鏖
	0x93D7, KANJI_STANDARD,  // 鏗
	0x93E8, KANJI_STANDARD,  // 鏨
	0x93E5, KANJI_STANDARD,  // 鏥
	0x93D8, KANJI_STANDARD,  // 鏘
	0x93C3, KANJI_STANDARD,  // 鏃
	0x93DD, KANJI_STANDARD,  // 鏝
	0x93D0, KANJI_STANDARD,  // 鏐
	0x93C8, KANJI_STANDARD,  // 鏈
	0x93E4, KANJI_STANDARD,  // 鏤
	0x941A, KANJI_STANDARD,  // 鐚
	0x9414, KANJI_STANDARD,  // 鐔
	0x9413, KANJI_STANDARD,  // 鐓
	0x9403, KANJI_STANDARD,  // 鐃
	0x9407, KANJI_STANDARD,  // 鐇
	0x9410, KANJI_STANDARD,  // 鐐
	0x9436, KANJI_STANDARD,  // 鐶
	0x942B, KANJI_STANDARD,  // 鐫
	0x9435, KANJI_STANDARD,  // 鐵
	0x9421, KANJI_STANDARD,  // 鐡
	0x943A, KANJI_STANDARD,  // 鐺
	0x9441, KANJI_STANDARD,  // 鑁
	0x9452, KANJI_STANDARD,  // 鑒
	0x9444, KANJI_STANDARD,  // 鑄
	0x945B, KANJI_STANDARD,  // 鑛
	0x9460, KANJI_STANDARD,  // 鑠
	0x9462, KANJI_STANDARD,  // 鑢
	0x945E, KANJI_STANDARD,  // 鑞
	0x946A, KANJI_STANDARD,  // 鑪
	0x9229, KANJI_STANDARD,  // 鈩
	0x9470, KANJI_STANDARD,  // 鑰
	0x9475, KANJI_STANDARD,  // 鑵
	0x9477, KANJI_STANDARD,  // 鑷
	0x947D, KANJI_STANDARD,  // 鑽
	0x945A, KANJI_STANDARD,  // 鑚
	0x947C, KANJI_STANDARD,  // 鑼
	0x947E, KANJI_STANDARD,  // 鑾
	0x9481, KANJI_STANDARD,  // 钁
	0x947F, KANJI_STANDARD,  // 鑿
	0x9582, KANJI_STANDARD,  // 閂
	0x9587, KANJI_STANDARD,  // 閇
	0x958A, KANJI_STANDARD,  // 閊
	0x9594, KANJI_STANDARD,  // 閔
	0x9596, KANJI_STANDARD,  // 閖
	0x9598, KANJI_STANDARD,  // 閘
	0x9599, KANJI_STANDARD,  // 閙
	0x95A0, KANJI_STANDARD,  // 閠
	0x95A8, KANJI_STANDARD,  // 閨
	0x95A7, KANJI_STANDARD,  // 閧
	0x95AD, KANJI_STANDARD,  // 閭
	0x95BC, KANJI_STANDARD,  // 閼
	0x95BB, KANJI_STANDARD,  // 閻
	0x95B9, KANJI_STANDARD,  // 閹
	0x95BE, KANJI_STANDARD,  // 閾
	0x95CA, KANJI_STANDARD,  // 闊
	0x6FF6, KANJI_STANDARD,  // 濶
	0x95C3, KANJI_STANDARD,  // 闃
	0x95CD, KANJI_STANDARD,  // 闍
	0x95CC, KANJI_STANDARD,  // 闌
	0x95D5, KANJI_STANDARD,  // 闕
	0x95D4, KANJI_STANDARD,  // 闔
	0x95D6, KANJI_STANDARD,  // 闖
	0x95DC, KANJI_STANDARD,  // 關
	0x95E1, KANJI_STANDARD,  // 闡
	0x95E5, KANJI_STANDARD,  // 闥
	0x95E2, KANJI_STANDARD,  // 闢
	0x9621, KANJI_STANDARD,  // 阡
	0x9628, KANJI_STANDARD,  // 阨
	0x962E, KANJI_STANDARD,  // 阮
	0x962F, KANJI_STANDARD,  // 阯
	0x9642, KANJI_STANDARD,  // 陂
	0x964C, KANJI_STANDARD,  // 陌
	0x964F, KANJI_STANDARD,  // 陏
	0x964B, KANJI_STANDARD,  // 陋
	0x9677, KANJI_STANDARD,  // 陷
	0x965C, KANJI_STANDARD,  // 陜
	0x965E, KANJI_STANDARD,  // 陞
	0x965D, KANJI_STANDARD,  // 陝
	0x965F, KANJI_STANDARD,  // 陟
	0x9666, KANJI_STANDARD,  // 陦
	0x9672, KANJI_STANDARD,  // 陲
	0x966C, KANJI_STANDARD,  // 陬
	0x968D, KANJI_STANDARD,  // 隍
	0x9698, KANJI_STANDARD,  // 隘
	0x9695, KANJI_STANDARD,  // 隕
	0x9697, KANJI_STANDARD,  // 隗
	0x96AA, KANJI_STANDARD,  // 險
	0x96A7, KANJI_STANDARD,  // 隧
	0x96B1, KANJI_STANDARD,  // 隱
	0x96B2, KANJI_STANDARD,  // 隲
	0x96B0, KANJI_STANDARD,  // 隰
	0x96B4, KANJI_STANDARD,  // 隴
	0x96B6, KANJI_STANDARD,  // 隶
	0x96B8, KANJI_STANDARD,  // 隸
	0x96B9, KANJI_STANDARD,  // 隹
	0x96CE, KANJI_STANDARD,  // 雎
	0x96CB, KANJI_STANDARD,  // 雋
	0x96C9, KANJI_STANDARD,  // 雉
	0x96CD, KANJI_STANDARD,  // 雍
	0x894D, KANJI_STANDARD,  // 襍
	0x96DC, KANJI_STANDARD,  // 雜
	0x970D, KANJI_STANDARD,  // 霍
	0x96D5, KANJI_STANDARD,  // 雕
	0x96F9, KANJI_STANDARD,  // 雹
	0x9704, KANJI_STANDARD,  // 霄
	0x9706, KANJI_STANDARD,  // 霆
	0x9708, KANJI_STANDARD,  // 霈
	0x9713, KANJI_STANDARD,  // 霓
	0x970E, KANJI_STANDARD,  // 霎
	0x9711, KANJI_STANDARD,  // 霑
	0x970F, KANJI_STANDARD,  // 霏
	0x9716, KANJI_STANDARD,  // 霖
	0x9719, KANJI_STANDARD,  // 霙
	0x9724, KANJI_STANDARD,  // 霤
	0x972A, KANJI_STANDARD,  // 霪
	0x9730, KANJI_STANDARD,  // 霰
	0x9739, KANJI_STANDARD,  // 霹
	0x973D, KANJI_STANDARD,  // 霽
	0x973E, KANJI_STANDARD,  // 霾
	0x9744, KANJI_STANDARD,  // 靄
	0x9746, KANJI_STANDARD,  // 靆
	0x9748, KANJI_STANDARD,  // 靈
	0x9742, KANJI_STANDARD,  // 靂
	0x9749, KANJI_STANDARD,  // 靉
	0x975C, KANJI_STANDARD,  // 靜
	0x9760, KANJI_STANDARD,  // 靠
	0x9764, KANJI_STANDARD,  // 靤
	0x9766, KANJI_STANDARD,  // 靦
	0x9768, KANJI_STANDARD,  // 靨
	0x52D2, KANJI_STANDARD,  // 勒
	0x976B, KANJI_STANDARD,  // 靫
	0x9771, KANJI_STANDARD,  // 靱
	0x9779, KANJI_STANDARD,  // 靹
	0x9785, KANJI_STANDARD,  // 鞅
	0x977C, KANJI_STANDARD,  // 靼
	0x9781, KANJI_STANDARD,  // 鞁
	0x977A, KANJI_STANDARD,  // 靺
	0x9786, KANJI_STANDARD,  // 鞆
	0x978B, KANJI_STANDARD,  // 鞋
	0x978F, KANJI_STANDARD,  // 鞏
	0x9790, KANJI_STANDARD,  // 鞐
	0x979C, KANJI_STANDARD,  // 鞜
	0x97A8, KANJI_STANDARD,  // 鞨
	0x97A6, KANJI_STANDARD,  // 鞦
	0x97A3, KANJI_STANDARD,  // 鞣
	0x97B3, KANJI_STANDARD,  // 鞳
	0x97B4, KANJI_STANDARD,  // 鞴
	0x97C3, KANJI_STANDARD,  // 韃
	0x97C6, KANJI_STANDARD,  // 韆
	0x97C8, KANJI_STANDARD,  // 韈
	0x97CB, KANJI_STANDARD,  // 韋
	0x97DC, KANJI_STANDARD,  // 韜
	0x97ED, KANJI_STANDARD,  // 韭
	0x9F4F, KANJI_STANDARD,  // 齏
	0x97F2, KANJI_STANDARD,  // 韲
	0x7ADF, KANJI_STANDARD,  // 竟
	0x97F6, KANJI_STANDARD,  // 韶
	0x97F5, KANJI_STANDARD,  // 韵
	0x980F, KANJI_STANDARD,  // 頏
	0x980C, KANJI_STANDARD,  // 頌
	0x9838, KANJI_STANDARD,  // 頸
	0x9824, KANJI_STANDARD,  // 頤
	0x9821, KANJI_STANDARD,  // 頡
	0x9837, KANJI_STANDARD,  // 頷
	0x983D, KANJI_STANDARD,  // 頽
	0x9846, KANJI_STANDARD,  // 顆
	0x984F, KANJI_STANDARD,  // 顏
	0x984B, KANJI_STANDARD,  // 顋
	0x986B, KANJI_STANDARD,  // 顫
	0x986F, KANJI_STANDARD,  // 顯
	0x9870, KANJI_STANDARD,  // 顰
	0x9871, KANJI_STANDARD,  // 顱
	0x9874, KANJI_STANDARD,  // 顴
	0x9873, KANJI_STANDARD,  // 顳
	0x98AA, KANJI_STANDARD,  // 颪
	0x98AF, KANJI_STANDARD,  // 颯
	0x98B1, KANJI_STANDARD,  // 颱
	0x98B6, KANJI_STANDARD,  // 颶
	0x98C4, KANJI_STANDARD,  // 飄
	0x98C3, KANJI_STANDARD,  // 飃
	0x98C6, KANJI_STANDARD,  // 飆
	0x98E9, KANJI_STANDARD,  // 飩
	0x98EB, KANJI_STANDARD,  // 飫
	0x9903, KANJI_STANDARD,  // 餃
	0x9909, KANJI_STANDARD,  // 餉
	0x9912, KANJI_STANDARD,  // 餒
	0x9914, KANJI_STANDARD,  // 餔
	0x9918, KANJI_STANDARD,  // 餘
	0x9921, KANJI_STANDARD,  // 餡
	0x991D, KANJI_STANDARD,  // 餝
	0x991E, KANJI_STANDARD,  // 餞
	0x9924, KANJI_STANDARD,  // 餤
	0x9920, KANJI_STANDARD,  // 餠
	0x992C, KANJI_STANDARD,  // 餬
	0x992E, KANJI_STANDARD,  // 餮
	0x993D, KANJI_STANDARD,  // 餽
	0x993E, KANJI_STANDARD,  // 餾
	0x9942, KANJI_STANDARD,  // 饂
	0x9949, KANJI_STANDARD,  // 饉
	0x9945, KANJI_STANDARD,  // 饅
	0x9950, KANJI_STANDARD,  // 饐
	0x994B, KANJI_STANDARD,  // 饋
	0x9951, KANJI_STANDARD,  // 饑
	0x9952, KANJI_STANDARD,  // 饒
	0x994C, KANJI_STANDARD,  // 饌
	0x9955, KANJI_STANDARD,  // 饕
	0x9997, KANJI_STANDARD,  // 馗
	0x9998, KANJI_STANDARD,  // 馘
	0x99A5, KANJI_STANDARD,  // 馥
	0x99AD, KANJI_STANDARD,  // 馭
	0x99AE, KANJI_STANDARD,  // 馮
	0x99BC, KANJI_STANDARD,  // 馼
	0x99DF, KANJI_STANDARD,  // 駟
	0x99DB, KANJI_STANDARD,  // 駛
	0x99DD, KANJI_STANDARD,  // 駝
	0x99D8, KANJI_STANDARD,  // 駘
	0x99D1, KANJI_STANDARD,  // 駑
	0x99ED, KANJI_STANDARD,  // 駭
	0x99EE, KANJI_STANDARD,  // 駮
	0x99F1, KANJI_STANDARD,  // 駱
	0x99F2, KANJI_STANDARD,  // 駲
	0x99FB, KANJI_STANDARD,  // 駻
	0x99F8, KANJI_STANDARD,  // 駸
	0x9A01, KANJI_STANDARD,  // 騁
	0x9A0F, KANJI_STANDARD,  // 騏
	0x9A05, KANJI_STANDARD,  // 騅
	0x99E2, KANJI_STANDARD,  // 駢
	0x9A19, KANJI_STANDARD,  // 騙
	0x9A2B, KANJI_STANDARD,  // 騫
	0x9A37, KANJI_STANDARD,  // 騷
	0x9A45, KANJI_STANDARD,  // 驅
	0x9A42, KANJI_STANDARD,  // 驂
	0x9A40, KANJI_STANDARD,  // 驀
	0x9A43, KANJI_STANDARD,  // 驃
	0x9A3E, KANJI_STANDARD,  // 騾
	0x9A55, KANJI_STANDARD,  // 驕
	0x9A4D, KANJI_STANDARD,  // 驍
	0x9A5B, KANJI_STANDARD,  // 驛
	0x9A57, KANJI_STANDARD,  // 驗
	0x9A5F, KANJI_STANDARD,  // 驟
	0x9A62, KANJI_STANDARD,  // 驢
	0x9A65, KANJI_STANDARD,  // 驥
	0x9A64, KANJI_STANDARD,  // 驤
	0x9A69, KANJI_STANDARD,  // 驩
	0x9A6B, KANJI_STANDARD,  // 驫
	0x9A6A, KANJI_STANDARD,  // 驪
	0x9AAD, KANJI_STANDARD,  // 骭
	0x9AB0, KANJI_STANDARD,  // 骰
	0x9ABC, KANJI_STANDARD,  // 骼
	0x9AC0, KANJI_STANDARD,  // 髀
	0x9ACF, KANJI_STANDARD,  // 髏
	0x9AD1, KANJI_STANDARD,  // 髑
	0x9AD3, KANJI_STANDARD,  // 髓
	0x9AD4, KANJI_STANDARD,  // 體
	0x9ADE, KANJI_STANDARD,  // 髞
	0x9ADF, KANJI_STANDARD,  // 髟
	0x9AE2, KANJI_STANDARD,  // 髢
	0x9AE3, KANJI_STANDARD,  // 髣
	0x9AE6, KANJI_STANDARD,  // 髦
	0x9AEF, KANJI_STANDARD,  // 髯
	0x9AEB, KANJI_STANDARD,  // 髫
	0x9AEE, KANJI_STANDARD,  // 髮
	0x9AF4, KANJI_STANDARD,  // 髴
	0x9AF1, KANJI_STANDARD,  // 髱
	0x9AF7, KANJI_STANDARD,  // 髷
	0x9AFB, KANJI_STANDARD,  // 髻
	0x9B06, KANJI_STANDARD,  // 鬆
	0x9B18, KANJI_STANDARD,  // 鬘
	0x9B1A, KANJI_STANDARD,  // 鬚
	0x9B1F, KANJI_STANDARD,  // 鬟
	0x9B22, KANJI_STANDARD,  // 鬢
	0x9B23, KANJI_STANDARD,  // 鬣
	0x9B25, KANJI_STANDARD,  // 鬥
	0x9B27, KANJI_STANDARD,  // 鬧
	0x9B28, KANJI_STANDARD,  // 鬨
	0x9B29, KANJI_STANDARD,  // 鬩
	0x9B2A, KANJI_STANDARD,  // 鬪
	0x9B2E, KANJI_STANDARD,  // 鬮
	0x9B2F, KANJI_STANDARD,  // 鬯
	0x9B32, KANJI_STANDARD,  // 鬲
	0x9B44, KANJI_STANDARD,  // 魄
	0x9B43, KANJI_STANDARD,  // 魃
	0x9B4F, KANJI_STANDARD,  // 魏
	0x9B4D, KANJI_STANDARD,  // 魍
	0x9B4E, KANJI_STANDARD,  // 魎
	0x9B51, KANJI_STANDARD,  // 魑
	0x9B58, KANJI_STANDARD,  // 魘
	0x9B74, KANJI_STANDARD,  // 魴
	0x9B93, KANJI_STANDARD,  // 鮓
	0x9B83, KANJI_STANDARD,  // 鮃
	0x9B91, KANJI_STANDARD,  // 鮑
	0x9B96, KANJI_STANDARD,  // 鮖
	0x9B97, KANJI_STANDARD,  // 鮗
	0x9B9F, KANJI_STANDARD,  // 鮟
	0x9BA0, KANJI_STANDARD,  // 鮠
	0x9BA8, KANJI_STANDARD,  // 鮨
	0x9BB4, KANJI_STANDARD,  // 鮴
	0x9BC0, KANJI_STANDARD,  // 鯀
	0x9BCA, KANJI_STANDARD,  // 鯊
	0x9BB9, KANJI_STANDARD,  // 鮹
	0x9BC6, KANJI_STANDARD,  // 鯆
	0x9BCF, KANJI_STANDARD,  // 鯏
	0x9BD1, KANJI_STANDARD,  // 鯑
	0x9BD2, KANJI_STANDARD,  // 鯒
	0x9BE3, KANJI_STANDARD,  // 鯣
	0x9BE2, KANJI_STANDARD,  // 鯢
	0x9BE4, KANJI_STANDARD,  // 鯤
	0x9BD4, KANJI_STANDARD,  // 鯔
	0x9BE1, KANJI_STANDARD,  // 鯡
	0x9C3A, KANJI_STANDARD,  // 鰺
	0x9BF2, KANJI_STANDARD,  // 鯲
	0x9BF1, KANJI_STANDARD,  // 鯱
	0x9BF0, KANJI_STANDARD,  // 鯰
	0x9C15, KANJI_STANDARD,  // 鰕
	0x9C14, KANJI_STANDARD,  // 鰔
	0x9C09, KANJI_STANDARD,  // 鰉
	0x9C13, KANJI_STANDARD,  // 鰓
	0x9C0C, KANJI_STANDARD,  // 鰌
	0x9C06, KANJI_STANDARD,  // 鰆
	0x9C08, KANJI_STANDARD,  // 鰈
	0x9C12, KANJI_STANDARD,  // 鰒
	0x9C0A, KANJI_STANDARD,  // 鰊
	0x9C04, KANJI_STANDARD,  // 鰄
	0x9C2E, KANJI_STANDARD,  // 鰮
	0x9C1B, KANJI_STANDARD,  // 鰛
	0x9C25, KANJI_STANDARD,  // 鰥
	0x9C24, KANJI_STANDARD,  // 鰤
	0x9C21, KANJI_STANDARD,  // 鰡
	0x9C30, KANJI_STANDARD,  // 鰰
	0x9C47, KANJI_STANDARD,  // 鱇
	0x9C32, KANJI_STANDARD,  // 鰲
	0x9C46, KANJI_STANDARD,  // 鱆
	0x9C3E, KANJI_STANDARD,  // 鰾
	0x9C5A, KANJI_STANDARD,  // 鱚
	0x9C60, KANJI_STANDARD,  // 鱠
	0x9C67, KANJI_STANDARD,  // 鱧
	0x9C76, KANJI_STANDARD,  // 鱶
	0x9C78, KANJI_STANDARD,  // 鱸
	0x9CE7, KANJI_STANDARD,  // 鳧
	0x9CEC, KANJI_STANDARD,  // 鳬
	0x9CF0, KANJI_STANDARD,  // 鳰
	0x9D09, KANJI_STANDARD,  // 鴉
	0x9D08, KANJI_STANDARD,  // 鴈
	0x9CEB, KANJI_STANDARD,  // 鳫
	0x9D03, KANJI_STANDARD,  // 鴃
	0x9D06, KANJI_STANDARD,  // 鴆
	0x9D2A, KANJI_STANDARD,  // 鴪
	0x9D26, KANJI_STANDARD,  // 鴦
	0x9DAF, KANJI_STANDARD,  // 鶯
	0x9D23, KANJI_STANDARD,  // 鴣
	0x9D1F, KANJI_STANDARD,  // 鴟
	0x9D44, KANJI_STANDARD,  // 鵄
	0x9D15, KANJI_STANDARD,  // 鴕
	0x9D12, KANJI_STANDARD,  // 鴒
	0x9D41, KANJI_STANDARD,  // 鵁
	0x9D3F, KANJI_STANDARD,  // 鴿
	0x9D3E, KANJI_STANDARD,  // 鴾
	0x9D46, KANJI_STANDARD,  // 鵆
	0x9D48, KANJI_STANDARD,  // 鵈
	0x9D5D, KANJI_STANDARD,  // 鵝
	0x9D5E, KANJI_STANDARD,  // 鵞
	0x9D64, KANJI_STANDARD,  // 鵤
	0x9D51, KANJI_STANDARD,  // 鵑
	0x9D50, KANJI_STANDARD,  // 鵐
	0x9D59, KANJI_STANDARD,  // 鵙
	0x9D72, KANJI_STANDARD,  // 鵲
	0x9D89, KANJI_STANDARD,  // 鶉
	0x9D87, KANJI_STANDARD,  // 鶇
	0x9DAB, KANJI_STANDARD,  // 鶫
	0x9D6F, KANJI_STANDARD,  // 鵯
	0x9D7A, KANJI_STANDARD,  // 鵺
	0x9D9A, KANJI_STANDARD,  // 鶚
	0x9DA4, KANJI_STANDARD,  // 鶤
	0x9DA9, KANJI_STANDARD,  // 鶩
	0x9DB2, KANJI_STANDARD,  // 鶲
	0x9DC4, KANJI_STANDARD,  // 鷄
	0x9DC1, KANJI_STANDARD,  // 鷁
	0x9DBB, KANJI_STANDARD,  // 鶻
	0x9DB8, KANJI_STANDARD,  // 鶸
	0x9DBA, KANJI_STANDARD,  // 鶺
	0x9DC6, KANJI_STANDARD,  // 鷆
	0x9DCF, KANJI_STANDARD,  // 鷏
	0x9DC2, KANJI_STANDARD,  // 鷂
	0x9DD9, KANJI_STANDARD,  // 鷙
	0x9DD3, KANJI_STANDARD,  // 鷓
	0x9DF8, KANJI_STANDARD,  // 鷸
	0x9DE6, KANJI_STANDARD,  // 鷦
	0x9DED, KANJI_STANDARD,  // 鷭
	0x9DEF, KANJI_STANDARD,  // 鷯
	0x9DFD, KANJI_STANDARD,  // 鷽
	0x9E1A, KANJI_STANDARD,  // 鸚
	0x9E1B, KANJI_STANDARD,  // 鸛
	0x9E1E, KANJI_STANDARD,  // 鸞
	0x9E75, KANJI_STANDARD,  // 鹵
	0x9E79, KANJI_STANDARD,  // 鹹
	0x9E7D, KANJI_STANDARD,  // 鹽
	0x9E81, KANJI_STANDARD,  // 麁
	0x9E88, KANJI_STANDARD,  // 麈
	0x9E8B, KANJI_STANDARD,  // 麋
	0x9E8C, KANJI_STANDARD,  // 麌
	0x9E92, KANJI_STANDARD,  // 麒
	0x9E95, KANJI_STANDARD,  // 麕
	0x9E91, KANJI_STANDARD,  // 麑
	0x9E9D, KANJI_STANDARD,  // 麝
	0x9EA5, KANJI_STANDARD,  // 麥
	0x9EA9, KANJI_STANDARD,  // 麩
	0x9EB8, KANJI_STANDARD,  // 麸
	0x9EAA, KANJI_STANDARD,  // 麪
	0x9EAD, KANJI_STANDARD,  // 麭
	0x9761, KANJI_STANDARD,  // 靡
	0x9ECC, KANJI_STANDARD,  // 黌
	0x9ECE, KANJI_STANDARD,  // 黎
	0x9ECF, KANJI_STANDARD,  // 黏
	0x9ED0, KANJI_STANDARD,  // 黐
	0x9ED4, KANJI_STANDARD,  // 黔
	0x9EDC, KANJI_STANDARD,  // 黜
	0x9EDE, KANJI_STANDARD,  // 點
	0x9EDD, KANJI_STANDARD,  // 黝
	0x9EE0, KANJI_STANDARD,  // 黠
	0x9EE5, KANJI_STANDARD,  // 黥
	0x9EE8, KANJI_STANDARD,  // 黨
	0x9EEF, KANJI_STANDARD,  // 黯
	0x9EF4, KANJI_STANDARD,  // 黴
	0x9EF6, KANJI_STANDARD,  // 黶
	0x9EF7, KANJI_STANDARD,  // 黷
	0x9EF9, KANJI_STANDARD,  // 黹
	0x9EFB, KANJI_STANDARD,  // 黻
	0x9EFC, KANJI_STANDARD,  // 黼
	0x9EFD, KANJI_STANDARD,  // 黽
	0x9F07, KANJI_STANDARD,  // 鼇
	0x9F08, KANJI_STANDARD,  // 鼈
	0x76B7, KANJI_STANDARD,  // 皷
	0x9F15, KANJI_STANDARD,  // 鼕
	0x9F21, KANJI_STANDARD,  // 鼡
	0x9F2C, KANJI_STANDARD,  // 鼬
	0x9F3E, KANJI_STANDARD,  // 鼾
	0x9F4A, KANJI_STANDARD,  // 齊
	0x9F52, KANJI_STANDARD,  // 齒
	0x9F54, KANJI_STANDARD,  // 齔
	0x9F63, KANJI_STANDARD,  // 齣
	0x9F5F, KANJI_STANDARD,  // 齟
	0x9F60, KANJI_STANDARD,  // 齠
	0x9F61, KANJI_STANDARD,  // 齡
	0x9F66, KANJI_STANDARD,  // 齦
	0x9F67, KANJI_STANDARD,  // 齧
	0x9F6C, KANJI_STANDARD,  // 齬
	0x9F6A, KANJI_STANDARD,  // 齪
	0x9F77, KANJI_STANDARD,  // 齷
	0x9F72, KANJI_STANDARD,  // 齲
	0x9F76, KANJI_STANDARD,  // 齶
	0x9F95, KANJI_STANDARD,  // 龕
	0x9F9C, KANJI_STANDARD,  // 龜
	0x9FA0, KANJI_STANDARD,  // 龠
	0x582F, KANJI_STANDARD,  // 堯
	0x69C7, KANJI_STANDARD,  // 槇
	0x9059, KANJI_STANDARD,  // 遙
	0x7464, KANJI_STANDARD,  // 瑤
	0x51DC, KANJI_STANDARD,  // 凜
	0x7199, KANJI_STANDARD,  // 熙
	0x4E02, KANJI_RARELY_USED,  // 丂
	0x4E04, KANJI_RARELY_USED,  // 丄
	0x4E05, KANJI_RARELY_USED,  // 丅
	0x4E0C, KANJI_RARELY_USED,  // 丌
	0x4E12, KANJI_RARELY_USED,  // 丒
	0x4E1F, KANJI_RARELY_USED,  // 丟
	0x4E23, KANJI_RARELY_USED,  // 丣
	0x4E24, KANJI_RARELY_USED,  // 两
	0x4E28, KANJI_RARELY_USED,  // 丨
	0x4E2B, KANJI_RARELY_USED,  // 丫
	0x4E2E, KANJI_RARELY_USED,  // 丮
	0x4E2F, KANJI_RARELY_USED,  // 丯
	0x4E30, KANJI_RARELY_USED,  // 丰
	0x4E35, KANJI_RARELY_USED,  // 丵
	0x4E40, KANJI_RARELY_USED,  // 乀
	0x4E41, KANJI_RARELY_USED,  // 乁
	0x4E44, KANJI_RARELY_USED,  // 乄
	0x4E47, KANJI_RARELY_USED,  // 乇
	0x4E51, KANJI_RARELY_USED,  // 乑
	0x4E5A, KANJI_RARELY_USED,  // 乚
	0x4E5C, KANJI_RARELY_USED,  // 乜
	0x4E63, KANJI_RARELY_USED,  // 乣
	0x4E68, KANJI_RARELY_USED,  // 乨
	0x4E69, KANJI_RARELY_USED,  // 乩
	0x4E74, KANJI_RARELY_USED,  // 乴
	0x4E75, KANJI_RARELY_USED,  // 乵
	0x4E79, KANJI_RARELY_USED,  // 乹
	0x4E7F, KANJI_RARELY_USED,  // 乿
	0x4E8D, KANJI_RARELY_USED,  // 亍
	0x4E96, KANJI_RARELY_USED,  // 亖
	0x4E97, KANJI_RARELY_USED,  // 亗
	0x4E9D, KANJI_RARELY_USED,  // 亝
	0x4EAF, KANJI_RARELY_USED,  // 亯
	0x4EB9, KANJI_RARELY_USED,  // 亹
	0x4EC3, KANJI_RARELY_USED,  // 仃
	0x4ED0, KANJI_RARELY_USED,  // 仐
	0x4EDA, KANJI_RARELY_USED,  // 仚
	0x4EDB, KANJI_RARELY_USED,  // 仛
	0x4EE0, KANJI_RARELY_USED,  // 仠
	0x4EE1, KANJI_RARELY_USED,  // 仡
	0x4EE2, KANJI_RARELY_USED,  // 仢
	0x4EE8, KANJI_RARELY_USED,  // 仨
	0x4EEF, KANJI_RARELY_USED,  // 仯
	0x4EF1, KANJI_RARELY_USED,  // 仱
	0x4EF3, KANJI_RARELY_USED,  // 仳
	0x4EF5, KANJI_RARELY_USED,  // 仵
	0x4EFD, KANJI_RARELY_USED,  // 份
	0x4EFE, KANJI_RARELY_USED,  // 仾
	0x4EFF, KANJI_RARELY_USED,  // 仿
	0x4F00, KANJI_RARELY_USED,  // 伀
	0x4F02, KANJI_RARELY_USED,  // 伂
	0x4F03, KANJI_RARELY_USED,  // 伃
	0x4F08, KANJI_RARELY_USED,  // 伈
	0x4F0B, KANJI_RARELY_USED,  // 伋
	0x4F0C, KANJI_RARELY_USED,  // 伌
	0x4F12, KANJI_RARELY_USED,  // 伒
	0x4F15, KANJI_RARELY_USED,  // 伕
	0x4F16, KANJI_RARELY_USED,  // 伖
	0x4F17, KANJI_RARELY_USED,  // 众
	0x4F19, KANJI_RARELY_USED,  // 伙
	0x4F2E, KANJI_RARELY_USED,  // 伮
	0x4F31, KANJI_RARELY_USED,  // 伱
	0x4F60, KANJI_RARELY_USED,  // 你
	0x4F33, KANJI_RARELY_USED,  // 伳
	0x4F35, KANJI_RARELY_USED,  // 伵
	0x4F37, KANJI_RARELY_USED,  // 伷
	0x4F39, KANJI_RARELY_USED,  // 伹
	0x4F3B, KANJI_RARELY_USED,  // 伻
	0x4F3E, KANJI_RARELY_USED,  // 伾
	0x4F40, KANJI_RARELY_USED,  // 佀
	0x4F42, KANJI_RARELY_USED,  // 佂
	0x4F48, KANJI_RARELY_USED,  // 佈
	0x4F49, KANJI_RARELY_USED,  // 佉
	0x4F4B, KANJI_RARELY_USED,  // 佋
	0x4F4C, KANJI_RARELY_USED,  // 佌
	0x4F52, KANJI_RARELY_USED,  // 佒
	0x4F54, KANJI_RARELY_USED,  // 佔
	0x4F56, KANJI_RARELY_USED,  // 佖
	0x4F58, KANJI_RARELY_USED,  // 佘
	0x4F5F, KANJI_RARELY_USED,  // 佟
	0x4F63, KANJI_RARELY_USED,  // 佣
	0x4F6A, KANJI_RARELY_USED,  // 佪
	0x4F6C, KANJI_RARELY_USED,  // 佬
	0x4F6E, KANJI_RARELY_USED,  // 佮
	0x4F71, KANJI_RARELY_USED,  // 佱
	0x4F77, KANJI_RARELY_USED,  // 佷
	0x4F78, KANJI_RARELY_USED,  // 佸
	0x4F79, KANJI_RARELY_USED,  // 佹
	0x4F7A, KANJI_RARELY_USED,  // 佺
	0x4F7D, KANJI_RARELY_USED,  // 佽
	0x4F7E, KANJI_RARELY_USED,  // 佾
	0x4F81, KANJI_RARELY_USED,  // 侁
	0x4F82, KANJI_RARELY_USED,  // 侂
	0x4F84, KANJI_RARELY_USED,  // 侄
	0x4F85, KANJI_RARELY_USED,  // 侅
	0x4F89, KANJI_RARELY_USED,  // 侉
	0x4F8A, KANJI_RARELY_USED,  // 侊
	0x4F8C, KANJI_RARELY_USED,  // 侌
	0x4F8E, KANJI_RARELY_USED,  // 侎
	0x4F90, KANJI_RARELY_USED,  // 侐
	0x4F92, KANJI_RARELY_USED,  // 侒
	0x4F93, KANJI_RARELY_USED,  // 侓
	0x4F94, KANJI_RARELY_USED,  // 侔
	0x4F97, KANJI_RARELY_USED,  // 侗
	0x4F99, KANJI_RARELY_USED,  // 侙
	0x4F9A, KANJI_RARELY_USED,  // 侚
	0x4F9E, KANJI_RARELY_USED,  // 侞
	0x4F9F, KANJI_RARELY_USED,  // 侟
	0x4FB2, KANJI_RARELY_USED,  // 侲
	0x4FB7, KANJI_RARELY_USED,  // 侷
	0x4FB9, KANJI_RARELY_USED,  // 侹
	0x4FBB, KANJI_RARELY_USED,  // 侻
	0x4FBC, KANJI_RARELY_USED,  // 侼
	0x4FBD, KANJI_RARELY_USED,  // 侽
	0x4FBE, KANJI_RARELY_USED,  // 侾
	0x4FC0, KANJI_RARELY_USED,  // 俀
	0x4FC1, KANJI_RARELY_USED,  // 俁
	0x4FC5, KANJI_RARELY_USED,  // 俅
	0x4FC6, KANJI_RARELY_USED,  // 俆
	0x4FC8, KANJI_RARELY_USED,  // 俈
	0x4FC9, KANJI_RARELY_USED,  // 俉
	0x4FCB, KANJI_RARELY_USED,  // 俋
	0x4FCC, KANJI_RARELY_USED,  // 俌
	0x4FCD, KANJI_RARELY_USED,  // 俍
	0x4FCF, KANJI_RARELY_USED,  // 俏
	0x4FD2, KANJI_RARELY_USED,  // 俒
	0x4FDC, KANJI_RARELY_USED,  // 俜
	0x4FE0, KANJI_RARELY_USED,  // 俠
	0x4FE2, KANJI_RARELY_USED,  // 俢
	0x4FF0, KANJI_RARELY_USED,  // 俰
	0x4FF2, KANJI_RARELY_USED,  // 俲
	0x4FFC, KANJI_RARELY_USED,  // 俼
	0x4FFD, KANJI_RARELY_USED,  // 俽
	0x4FFF, KANJI_RARELY_USED,  // 俿
	0x5000, KANJI_RARELY_USED,  // 倀
	0x5001, KANJI_RARELY_USED,  // 倁
	0x5004, KANJI_RARELY_USED,  // 倄
	0x5007, KANJI_RARELY_USED,  // 倇
	0x500A, KANJI_RARELY_USED,  // 倊
	0x500C, KANJI_RARELY_USED,  // 倌
	0x500E, KANJI_RARELY_USED,  // 倎
	0x5010, KANJI_RARELY_USED,  // 倐
	0x5013, KANJI_RARELY_USED,  // 倓
	0x5017, KANJI_RARELY_USED,  // 倗
	0x5018, KANJI_RARELY_USED,  // 倘
	0x501B, KANJI_RARELY_USED,  // 倛
	0x501C, KANJI_RARELY_USED,  // 倜
	0x501D, KANJI_RARELY_USED,  // 倝
	0x501E, KANJI_RARELY_USED,  // 倞
	0x5022, KANJI_RARELY_USED,  // 倢
	0x5027, KANJI_RARELY_USED,  // 倧
	0x502E, KANJI_RARELY_USED,  // 倮
	0x5030, KANJI_RARELY_USED,  // 倰
	0x5032, KANJI_RARELY_USED,  // 倲
	0x5033, KANJI_RARELY_USED,  // 倳
	0x5035, KANJI_RARELY_USED,  // 倵
	0x5040, KANJI_RARELY_USED,  // 偀
	0x5041, KANJI_RARELY_USED,  // 偁
	0x5042, KANJI_RARELY_USED,  // 偂
	0x5045, KANJI_RARELY_USED,  // 偅
	0x5046, KANJI_RARELY_USED,  // 偆
	0x504A, KANJI_RARELY_USED,  // 偊
	0x504C, KANJI_RARELY_USED,  // 偌
	0x504E, KANJI_RARELY_USED,  // 偎
	0x5051, KANJI_RARELY_USED,  // 偑
	0x5052, KANJI_RARELY_USED,  // 偒
	0x5053, KANJI_RARELY_USED,  // 偓
	0x5057, KANJI_RARELY_USED,  // 偗
	0x5059, KANJI_RARELY_USED,  // 偙
	0x505F, KANJI_RARELY_USED,  // 偟
	0x5060, KANJI_RARELY_USED,  // 偠
	0x5062, KANJI_RARELY_USED,  // 偢
	0x5063, KANJI_RARELY_USED,  // 偣
	0x5066, KANJI_RARELY_USED,  // 偦
	0x5067, KANJI_RARELY_USED,  // 偧
	0x506A, KANJI_RARELY_USED,  // 偪
	0x506D, KANJI_RARELY_USED,  // 偭
	0x5070, KANJI_RARELY_USED,  // 偰
	0x5071, KANJI_RARELY_USED,  // 偱
	0x503B, KANJI_RARELY_USED,  // 倻
	0x5081, KANJI_RARELY_USED,  // 傁
	0x5083, KANJI_RARELY_USED,  // 傃
	0x5084, KANJI_RARELY_USED,  // 傄
	0x5086, KANJI_RARELY_USED,  // 傆
	0x508A, KANJI_RARELY_USED,  // 傊
	0x508E, KANJI_RARELY_USED,  // 傎
	0x508F, KANJI_RARELY_USED,  // 傏
	0x5090, KANJI_RARELY_USED,  // 傐
	0x5092, KANJI_RARELY_USED,  // 傒
	0x5093, KANJI_RARELY_USED,  // 傓
	0x5094, KANJI_RARELY_USED,  // 傔
	0x5096, KANJI_RARELY_USED,  // 傖
	0x509B, KANJI_RARELY_USED,  // 傛
	0x509C, KANJI_RARELY_USED,  // 傜
	0x509E, KANJI_RARELY_USED,  // 傞
	0x509F, KANJI_RARELY_USED,  // 傟
	0x50A0, KANJI_RARELY_USED,  // 傠
	0x50A1, KANJI_RARELY_USED,  // 傡
	0x50A2, KANJI_RARELY_USED,  // 傢
	0x50AA, KANJI_RARELY_USED,  // 傪
	0x50AF, KANJI_RARELY_USED,  // 傯
	0x50B0, KANJI_RARELY_USED,  // 傰
	0x50B9, KANJI_RARELY_USED,  // 傹
	0x50BA, KANJI_RARELY_USED,  // 傺
	0x50BD, KANJI_RARELY_USED,  // 傽
	0x50C0, KANJI_RARELY_USED,  // 僀
	0x50C3, KANJI_RARELY_USED,  // 僃
	0x50C4, KANJI_RARELY_USED,  // 僄
	0x50C7, KANJI_RARELY_USED,  // 僇
	0x50CC, KANJI_RARELY_USED,  // 僌
	0x50CE, KANJI_RARELY_USED,  // 僎
	0x50D0, KANJI_RARELY_USED,  // 僐
	0x50D3, KANJI_RARELY_USED,  // 僓
	0x50D4, KANJI_RARELY_USED,  // 僔
	0x50D8, KANJI_RARELY_USED,  // 僘
	0x50DC, KANJI_RARELY_USED,  // 僜
	0x50DD, KANJI_RARELY_USED,  // 僝
	0x50DF, KANJI_RARELY_USED,  // 僟
	0x50E2, KANJI_RARELY_USED,  // 僢
	0x50E4, KANJI_RARELY_USED,  // 僤
	0x50E6, KANJI_RARELY_USED,  // 僦
	0x50E8, KANJI_RARELY_USED,  // 僨
	0x50E9, KANJI_RARELY_USED,  // 僩
	0x50EF, KANJI_RARELY_USED,  // 僯
	0x50F1, KANJI_RARELY_USED,  // 僱
	0x50F6, KANJI_RARELY_USED,  // 僶
	0x50FA, KANJI_RARELY_USED,  // 僺
	0x50FE, KANJI_RARELY_USED,  // 僾
	0x5103, KANJI_RARELY_USED,  // 儃
	0x5106, KANJI_RARELY_USED,  // 儆
	0x5107, KANJI_RARELY_USED,  // 儇
	0x5108, KANJI_RARELY_USED,  // 儈
	0x510B, KANJI_RARELY_USED,  // 儋
	0x510C, KANJI_RARELY_USED,  // 儌
	0x510D, KANJI_RARELY_USED,  // 儍
	0x510E, KANJI_RARELY_USED,  // 儎
	0x50F2, KANJI_RARELY_USED,  // 僲
	0x5110, KANJI_RARELY_USED,  // 儐
	0x5117, KANJI_RARELY_USED,  // 儗
	0x5119, KANJI_RARELY_USED,  // 儙
	0x511B, KANJI_RARELY_USED,  // 儛
	0x511C, KANJI_RARELY_USED,  // 儜
	0x511D, KANJI_RARELY_USED,  // 儝
	0x511E, KANJI_RARELY_USED,  // 儞
	0x5123, KANJI_RARELY_USED,  // 儣
	0x5127, KANJI_RARELY_USED,  // 儧
	0x5128, KANJI_RARELY_USED,  // 儨
	0x512C, KANJI_RARELY_USED,  // 儬
	0x512D, KANJI_RARELY_USED,  // 儭
	0x512F, KANJI_RARELY_USED,  // 儯
	0x5131, KANJI_RARELY_USED,  // 儱
	0x5133, KANJI_RARELY_USED,  // 儳
	0x5134, KANJI_RARELY_USED,  // 儴
	0x5135, KANJI_RARELY_USED,  // 儵
	0x5138, KANJI_RARELY_USED,  // 儸
	0x5139, KANJI_RARELY_USED,  // 儹
	0x5142, KANJI_RARELY_USED,  // 兂
	0x514A, KANJI_RARELY_USED,  // 兊
	0x514F, KANJI_RARELY_USED,  // 兏
	0x5153, KANJI_RARELY_USED,  // 兓
	0x5155, KANJI_RARELY_USED,  // 兕
	0x5157, KANJI_RARELY_USED,  // 兗
	0x5158, KANJI_RARELY_USED,  // 兘
	0x515F, KANJI_RARELY_USED,  // 兟
	0x5164, KANJI_RARELY_USED,  // 兤
	0x5166, KANJI_RARELY_USED,  // 兦
	0x517E, KANJI_RARELY_USED,  // 兾
	0x5183, KANJI_RARELY_USED,  // 冃
	0x5184, KANJI_RARELY_USED,  // 冄
	0x518B, KANJI_RARELY_USED,  // 冋
	0x518E, KANJI_RARELY_USED,  // 冎
	0x5198, KANJI_RARELY_USED,  // 冘
	0x519D, KANJI_RARELY_USED,  // 冝
	0x51A1, KANJI_RARELY_USED,  // 冡
	0x51A3, KANJI_RARELY_USED,  // 冣
	0x51AD, KANJI_RARELY_USED,  // 冭
	0x51B8, KANJI_RARELY_USED,  // 冸
	0x51BA, KANJI_RARELY_USED,  // 冺
	0x51BC, KANJI_RARELY_USED,  // 冼
	0x51BE, KANJI_RARELY_USED,  // 冾
	0x51BF, KANJI_RARELY_USED,  // 冿
	0x51C2, KANJI_RARELY_USED,  // 凂
	0x51C8, KANJI_RARELY_USED,  // 凈
	0x51CF, KANJI_RARELY_USED,  // 减
	0x51D1, KANJI_RARELY_USED,  // 凑
	0x51D2, KANJI_RARELY_USED,  // 凒
	0x51D3, KANJI_RARELY_USED,  // 凓
	0x51D5, KANJI_RARELY_USED,  // 凕
	0x51D8, KANJI_RARELY_USED,  // 凘
	0x51DE, KANJI_RARELY_USED,  // 凞
	0x51E2, KANJI_RARELY_USED,  // 凢
	0x51E5, KANJI_RARELY_USED,  // 凥
	0x51EE, KANJI_RARELY_USED,  // 凮
	0x51F2, KANJI_RARELY_USED,  // 凲
	0x51F3, KANJI_RARELY_USED,  // 凳
	0x51F4, KANJI_RARELY_USED,  // 凴
	0x51F7, KANJI_RARELY_USED,  // 凷
	0x5201, KANJI_RARELY_USED,  // 刁
	0x5202, KANJI_RARELY_USED,  // 刂
	0x5205, KANJI_RARELY_USED,  // 刅
	0x5212, KANJI_RARELY_USED,  // 划
	0x5213, KANJI_RARELY_USED,  // 刓
	0x5215, KANJI_RARELY_USED,  // 刕
	0x5216, KANJI_RARELY_USED,  // 刖
	0x5218, KANJI_RARELY_USED,  // 刘
	0x5222, KANJI_RARELY_USED,  // 刢
	0x5228, KANJI_RARELY_USED,  // 刨
	0x5231, KANJI_RARELY_USED,  // 刱
	0x5232, KANJI_RARELY_USED,  // 刲
	0x5235, KANJI_RARELY_USED,  // 刵
	0x523C, KANJI_RARELY_USED,  // 刼
	0x5245, KANJI_RARELY_USED,  // 剅
	0x5249, KANJI_RARELY_USED,  // 剉
	0x5255, KANJI_RARELY_USED,  // 剕
	0x5257, KANJI_RARELY_USED,  // 剗
	0x5258, KANJI_RARELY_USED,  // 剘
	0x525A, KANJI_RARELY_USED,  // 剚
	0x525C, KANJI_RARELY_USED,  // 剜
	0x525F, KANJI_RARELY_USED,  // 剟
	0x5260, KANJI_RARELY_USED,  // 剠
	0x5261, KANJI_RARELY_USED,  // 剡
	0x5266, KANJI_RARELY_USED,  // 剦
	0x526E, KANJI_RARELY_USED,  // 剮
	0x5277, KANJI_RARELY_USED,  // 剷
	0x5278, KANJI_RARELY_USED,  // 剸
	0x5279, KANJI_RARELY_USED,  // 剹
	0x5280, KANJI_RARELY_USED,  // 劀
	0x5282, KANJI_RARELY_USED,  // 劂
	0x5285, KANJI_RARELY_USED,  // 劅
	0x528A, KANJI_RARELY_USED,  // 劊
	0x528C, KANJI_RARELY_USED,  // 劌
	0x5293, KANJI_RARELY_USED,  // 劓
	0x5295, KANJI_RARELY_USED,  // 劕
	0x5296, KANJI_RARELY_USED,  // 劖
	0x5297, KANJI_RARELY_USED,  // 劗
	0x5298, KANJI_RARELY_USED,  // 劘
	0x529A, KANJI_RARELY_USED,  // 劚
	0x529C, KANJI_RARELY_USED,  // 劜
	0x52A4, KANJI_RARELY_USED,  // 劤
	0x52A5, KANJI_RARELY_USED,  // 劥
	0x52A6, KANJI_RARELY_USED,  // 劦
	0x52A7, KANJI_RARELY_USED,  // 劧
	0x52AF, KANJI_RARELY_USED,  // 劯
	0x52B0, KANJI_RARELY_USED,  // 劰
	0x52B6, KANJI_RARELY_USED,  // 劶
	0x52B7, KANJI_RARELY_USED,  // 劷
	0x52B8, KANJI_RARELY_USED,  // 劸
	0x52BA, KANJI_RARELY_USED,  // 劺
	0x52BB, KANJI_RARELY_USED,  // 劻
	0x52BD, KANJI_RARELY_USED,  // 劽
	0x52C0, KANJI_RARELY_USED,  // 勀
	0x52C4, KANJI_RARELY_USED,  // 勄
	0x52C6, KANJI_RARELY_USED,  // 勆
	0x52C8, KANJI_RARELY_USED,  // 勈
	0x52CC, KANJI_RARELY_USED,  // 勌
	0x52CF, KANJI_RARELY_USED,  // 勏
	0x52D1, KANJI_RARELY_USED,  // 勑
	0x52D4, KANJI_RARELY_USED,  // 勔
	0x52D6, KANJI_RARELY_USED,  // 勖
	0x52DB, KANJI_RARELY_USED,  // 勛
	0x52DC, KANJI_RARELY_USED,  // 勜
	0x52E1, KANJI_RARELY_USED,  // 勡
	0x52E5, KANJI_RARELY_USED,  // 勥
	0x52E8, KANJI_RARELY_USED,  // 勨
	0x52E9, KANJI_RARELY_USED,  // 勩
	0x52EA, KANJI_RARELY_USED,  // 勪
	0x52EC, KANJI_RARELY_USED,  // 勬
	0x52F0, KANJI_RARELY_USED,  // 勰
	0x52F1, KANJI_RARELY_USED,  // 勱
	0x52F4, KANJI_RARELY_USED,  // 勴
	0x52F6, KANJI_RARELY_USED,  // 勶
	0x52F7, KANJI_RARELY_USED,  // 勷
	0x5300, KANJI_RARELY_USED,  // 匀
	0x5303, KANJI_RARELY_USED,  // 匃
	0x530A, KANJI_RARELY_USED,  // 匊
	0x530B, KANJI_RARELY_USED,  // 匋
	0x530C, KANJI_RARELY_USED,  // 匌
	0x5311, KANJI_RARELY_USED,  // 匑
	0x5313, KANJI_RARELY_USED,  // 匓
	0x5318, KANJI_RARELY_USED,  // 匘
	0x531B, KANJI_RARELY_USED,  // 匛
	0x531C, KANJI_RARELY_USED,  // 匜
	0x531E, KANJI_RARELY_USED,  // 匞
	0x531F, KANJI_RARELY_USED,  // 匟
	0x5325, KANJI_RARELY_USED,  // 匥
	0x5327, KANJI_RARELY_USED,  // 匧
	0x5328, KANJI_RARELY_USED,  // 匨
	0x5329, KANJI_RARELY_USED,  // 匩
	0x532B, KANJI_RARELY_USED,  // 匫
	0x532C, KANJI_RARELY_USED,  // 匬
	0x532D, KANJI_RARELY_USED,  // 匭
	0x5330, KANJI_RARELY_USED,  // 匰
	0x5332, KANJI_RARELY_USED,  // 匲
	0x5335, KANJI_RARELY_USED,  // 匵
	0x533C, KANJI_RARELY_USED,  // 匼
	0x533D, KANJI_RARELY_USED,  // 匽
	0x533E, KANJI_RARELY_USED,  // 匾
	0x5342, KANJI_RARELY_USED,  // 卂
	0x534C, KANJI_RARELY_USED,  // 卌
	0x534B, KANJI_RARELY_USED,  // 卋
	0x5359, KANJI_RARELY_USED,  // 卙
	0x535B, KANJI_RARELY_USED,  // 卛
	0x5361, KANJI_RARELY_USED,  // 卡
	0x5363, KANJI_RARELY_USED,  // 卣
	0x5365, KANJI_RARELY_USED,  // 卥
	0x536C, KANJI_RARELY_USED,  // 卬
	0x536D, KANJI_RARELY_USED,  // 卭
	0x5372, KANJI_RARELY_USED,  // 卲
	0x5379, KANJI_RARELY_USED,  // 卹
	0x537E, KANJI_RARELY_USED,  // 卾
	0x5383, KANJI_RARELY_USED,  // 厃
	0x5387, KANJI_RARELY_USED,  // 厇
	0x5388, KANJI_RARELY_USED,  // 厈
	0x538E, KANJI_RARELY_USED,  // 厎
	0x5393, KANJI_RARELY_USED,  // 厓
	0x5394, KANJI_RARELY_USED,  // 厔
	0x5399, KANJI_RARELY_USED,  // 厙
	0x539D, KANJI_RARELY_USED,  // 厝
	0x53A1, KANJI_RARELY_USED,  // 厡
	0x53A4, KANJI_RARELY_USED,  // 厤
	0x53AA, KANJI_RARELY_USED,  // 厪
	0x53AB, KANJI_RARELY_USED,  // 厫
	0x53AF, KANJI_RARELY_USED,  // 厯
	0x53B2, KANJI_RARELY_USED,  // 厲
	0x53B4, KANJI_RARELY_USED,  // 厴
	0x53B5, KANJI_RARELY_USED,  // 厵
	0x53B7, KANJI_RARELY_USED,  // 厷
	0x53B8, KANJI_RARELY_USED,  // 厸
	0x53BA, KANJI_RARELY_USED,  // 厺
	0x53BD, KANJI_RARELY_USED,  // 厽
	0x53C0, KANJI_RARELY_USED,  // 叀
	0x53C5, KANJI_RARELY_USED,  // 叅
	0x53CF, KANJI_RARELY_USED,  // 叏
	0x53D2, KANJI_RARELY_USED,  // 叒
	0x53D3, KANJI_RARELY_USED,  // 叓
	0x53D5, KANJI_RARELY_USED,  // 叕
	0x53DA, KANJI_RARELY_USED,  // 叚
	0x53DD, KANJI_RARELY_USED,  // 叝
	0x53DE, KANJI_RARELY_USED,  // 叞
	0x53E0, KANJI_RARELY_USED,  // 叠
	0x53E6, KANJI_RARELY_USED,  // 另
	0x53E7, KANJI_RARELY_USED,  // 叧
	0x53F5, KANJI_RARELY_USED,  // 叵
	0x5402, KANJI_RARELY_USED,  // 吂
	0x5413, KANJI_RARELY_USED,  // 吓
	0x541A, KANJI_RARELY_USED,  // 吚
	0x5421, KANJI_RARELY_USED,  // 吡
	0x5427, KANJI_RARELY_USED,  // 吧
	0x5428, KANJI_RARELY_USED,  // 吨
	0x542A, KANJI_RARELY_USED,  // 吪
	0x542F, KANJI_RARELY_USED,  // 启
	0x5431, KANJI_RARELY_USED,  // 吱
	0x5434, KANJI_RARELY_USED,  // 吴
	0x5435, KANJI_RARELY_USED,  // 吵
	0x5443, KANJI_RARELY_USED,  // 呃
	0x5444, KANJI_RARELY_USED,  // 呄
	0x5447, KANJI_RARELY_USED,  // 呇
	0x544D, KANJI_RARELY_USED,  // 呍
	0x544F, KANJI_RARELY_USED,  // 呏
	0x545E, KANJI_RARELY_USED,  // 呞
	0x5462, KANJI_RARELY_USED,  // 呢
	0x5464, KANJI_RARELY_USED,  // 呤
	0x5466, KANJI_RARELY_USED,  // 呦
	0x5467, KANJI_RARELY_USED,  // 呧
	0x5469, KANJI_RARELY_USED,  // 呩
	0x546B, KANJI_RARELY_USED,  // 呫
	0x546D, KANJI_RARELY_USED,  // 呭
	0x546E, KANJI_RARELY_USED,  // 呮
	0x5474, KANJI_RARELY_USED,  // 呴
	0x547F, KANJI_RARELY_USED,  // 呿
	0x5481, KANJI_RARELY_USED,  // 咁
	0x5483, KANJI_RARELY_USED,  // 咃
	0x5485, KANJI_RARELY_USED,  // 咅
	0x5488, KANJI_RARELY_USED,  // 咈
	0x5489, KANJI_RARELY_USED,  // 咉
	0x548D, KANJI_RARELY_USED,  // 咍
	0x5491, KANJI_RARELY_USED,  // 咑
	0x5495, KANJI_RARELY_USED,  // 咕
	0x5496, KANJI_RARELY_USED,  // 咖
	0x549C, KANJI_RARELY_USED,  // 咜
	0x549F, KANJI_RARELY_USED,  // 咟
	0x54A1, KANJI_RARELY_USED,  // 咡
	0x54A6, KANJI_RARELY_USED,  // 咦
	0x54A7, KANJI_RARELY_USED,  // 咧
	0x54A9, KANJI_RARELY_USED,  // 咩
	0x54AA, KANJI_RARELY_USED,  // 咪
	0x54AD, KANJI_RARELY_USED,  // 咭
	0x54AE, KANJI_RARELY_USED,  // 咮
	0x54B1, KANJI_RARELY_USED,  // 咱
	0x54B7, KANJI_RARELY_USED,  // 咷
	0x54B9, KANJI_RARELY_USED,  // 咹
	0x54BA, KANJI_RARELY_USED,  // 咺
	0x54BB, KANJI_RARELY_USED,  // 咻
	0x54BF, KANJI_RARELY_USED,  // 咿
	0x54C6, KANJI_RARELY_USED,  // 哆
	0x54CA, KANJI_RARELY_USED,  // 哊
	0x54CD, KANJI_RARELY_USED,  // 响
	0x54CE, KANJI_RARELY_USED,  // 哎
	0x54E0, KANJI_RARELY_USED,  // 哠
	0x54EA, KANJI_RARELY_USED,  // 哪
	0x54EC, KANJI_RARELY_USED,  // 哬
	0x54EF, KANJI_RARELY_USED,  // 哯
	0x54F6, KANJI_RARELY_USED,  // 哶
	0x54FC, KANJI_RARELY_USED,  // 哼
	0x54FE, KANJI_RARELY_USED,  // 哾
	0x54FF, KANJI_RARELY_USED,  // 哿
	0x5500, KANJI_RARELY_USED,  // 唀
	0x5501, KANJI_RARELY_USED,  // 唁
	0x5505, KANJI_RARELY_USED,  // 唅
	0x5508, KANJI_RARELY_USED,  // 唈
	0x5509, KANJI_RARELY_USED,  // 唉
	0x550C, KANJI_RARELY_USED,  // 唌
	0x550D, KANJI_RARELY_USED,  // 唍
	0x550E, KANJI_RARELY_USED,  // 唎
	0x5515, KANJI_RARELY_USED,  // 唕
	0x552A, KANJI_RARELY_USED,  // 唪
	0x552B, KANJI_RARELY_USED,  // 唫
	0x5532, KANJI_RARELY_USED,  // 唲
	0x5535, KANJI_RARELY_USED,  // 唵
	0x5536, KANJI_RARELY_USED,  // 唶
	0x553B, KANJI_RARELY_USED,  // 唻
	0x553C, KANJI_RARELY_USED,  // 唼
	0x553D, KANJI_RARELY_USED,  // 唽
	0x5541, KANJI_RARELY_USED,  // 啁
	0x5547, KANJI_RARELY_USED,  // 啇
	0x5549, KANJI_RARELY_USED,  // 啉
	0x554A, KANJI_RARELY_USED,  // 啊
	0x554D, KANJI_RARELY_USED,  // 啍
	0x5550, KANJI_RARELY_USED,  // 啐
	0x5551, KANJI_RARELY_USED,  // 啑
	0x5558, KANJI_RARELY_USED,  // 啘
	0x555A, KANJI_RARELY_USED,  // 啚
	0x555B, KANJI_RARELY_USED,  // 啛
	0x555E, KANJI_RARELY_USED,  // 啞
	0x5560, KANJI_RARELY_USED,  // 啠
	0x5561, KANJI_RARELY_USED,  // 啡
	0x5564, KANJI_RARELY_USED,  // 啤
	0x5566, KANJI_RARELY_USED,  // 啦
	0x557F, KANJI_RARELY_USED,  // 啿
	0x5581, KANJI_RARELY_USED,  // 喁
	0x5582, KANJI_RARELY_USED,  // 喂
	0x5586, KANJI_RARELY_USED,  // 喆
	0x5588, KANJI_RARELY_USED,  // 喈
	0x558E, KANJI_RARELY_USED,  // 喎
	0x558F, KANJI_RARELY_USED,  // 喏
	0x5591, KANJI_RARELY_USED,  // 喑
	0x5592, KANJI_RARELY_USED,  // 喒
	0x5593, KANJI_RARELY_USED,  // 喓
	0x5594, KANJI_RARELY_USED,  // 喔
	0x5597, KANJI_RARELY_USED,  // 喗
	0x55A3, KANJI_RARELY_USED,  // 喣
	0x55A4, KANJI_RARELY_USED,  // 喤
	0x55AD, KANJI_RARELY_USED,  // 喭
	0x55B2, KANJI_RARELY_USED,  // 喲
	0x55BF, KANJI_RARELY_USED,  // 喿
	0x55C1, KANJI_RARELY_USED,  // 嗁
	0x55C3, KANJI_RARELY_USED,  // 嗃
	0x55C6, KANJI_RARELY_USED,  // 嗆
	0x55C9, KANJI_RARELY_USED,  // 嗉
	0x55CB, KANJI_RARELY_USED,  // 嗋
	0x55CC, KANJI_RARELY_USED,  // 嗌
	0x55CE, KANJI_RARELY_USED,  // 嗎
	0x55D1, KANJI_RARELY_USED,  // 嗑
	0x55D2, KANJI_RARELY_USED,  // 嗒
	0x55D3, KANJI_RARELY_USED,  // 嗓
	0x55D7, KANJI_RARELY_USED,  // 嗗
	0x55D8, KANJI_RARELY_USED,  // 嗘
	0x55DB, KANJI_RARELY_USED,  // 嗛
	0x55DE, KANJI_RARELY_USED,  // 嗞
	0x55E2, KANJI_RARELY_USED,  // 嗢
	0x55E9, KANJI_RARELY_USED,  // 嗩
	0x55F6, KANJI_RARELY_USED,  // 嗶
	0x55FF, KANJI_RARELY_USED,  // 嗿
	0x5605, KANJI_RARELY_USED,  // 嘅
	0x5608, KANJI_RARELY_USED,  // 嘈
	0x560A, KANJI_RARELY_USED,  // 嘊
	0x560D, KANJI_RARELY_USED,  // 嘍
	0x560E, KANJI_RARELY_USED,  // 嘎
	0x560F, KANJI_RARELY_USED,  // 嘏
	0x5610, KANJI_RARELY_USED,  // 嘐
	0x5611, KANJI_RARELY_USED,  // 嘑
	0x5612, KANJI_RARELY_USED,  // 嘒
	0x5619, KANJI_RARELY_USED,  // 嘙
	0x562C, KANJI_RARELY_USED,  // 嘬
	0x5630, KANJI_RARELY_USED,  // 嘰
	0x5633, KANJI_RARELY_USED,  // 嘳
	0x5635, KANJI_RARELY_USED,  // 嘵
	0x5637, KANJI_RARELY_USED,  // 嘷
	0x5639, KANJI_RARELY_USED,  // 嘹
	0x563B, KANJI_RARELY_USED,  // 嘻
	0x563C, KANJI_RARELY_USED,  // 嘼
	0x563D, KANJI_RARELY_USED,  // 嘽
	0x563F, KANJI_RARELY_USED,  // 嘿
	0x5640, KANJI_RARELY_USED,  // 噀
	0x5641, KANJI_RARELY_USED,  // 噁
	0x5643, KANJI_RARELY_USED,  // 噃
	0x5644, KANJI_RARELY_USED,  // 噄
	0x5646, KANJI_RARELY_USED,  // 噆
	0x5649, KANJI_RARELY_USED,  // 噉
	0x564B, KANJI_RARELY_USED,  // 噋
	0x564D, KANJI_RARELY_USED,  // 噍
	0x564F, KANJI_RARELY_USED,  // 噏
	0x5654, KANJI_RARELY_USED,  // 噔
	0x565E, KANJI_RARELY_USED,  // 噞
	0x5660, KANJI_RARELY_USED,  // 噠
	0x5661, KANJI_RARELY_USED,  // 噡
	0x5662, KANJI_RARELY_USED,  // 噢
	0x5663, KANJI_RARELY_USED,  // 噣
	0x5666, KANJI_RARELY_USED,  // 噦
	0x5669, KANJI_RARELY_USED,  // 噩
	0x566D, KANJI_RARELY_USED,  // 噭
	0x566F, KANJI_RARELY_USED,  // 噯
	0x5671, KANJI_RARELY_USED,  // 噱
	0x5672, KANJI_RARELY_USED,  // 噲
	0x5675, KANJI_RARELY_USED,  // 噵
	0x5684, KANJI_RARELY_USED,  // 嚄
	0x5685, KANJI_RARELY_USED,  // 嚅
	0x5688, KANJI_RARELY_USED,  // 嚈
	0x568B, KANJI_RARELY_USED,  // 嚋
	0x568C, KANJI_RARELY_USED,  // 嚌
	0x5695, KANJI_RARELY_USED,  // 嚕
	0x5699, KANJI_RARELY_USED,  // 嚙
	0x569A, KANJI_RARELY_USED,  // 嚚
	0x569D, KANJI_RARELY_USED,  // 嚝
	0x569E, KANJI_RARELY_USED,  // 嚞
	0x569F, KANJI_RARELY_USED,  // 嚟
	0x56A6, KANJI_RARELY_USED,  // 嚦
	0x56A7, KANJI_RARELY_USED,  // 嚧
	0x56A8, KANJI_RARELY_USED,  // 嚨
	0x56A9, KANJI_RARELY_USED,  // 嚩
	0x56AB, KANJI_RARELY_USED,  // 嚫
	0x56AC, KANJI_RARELY_USED,  // 嚬
	0x56AD, KANJI_RARELY_USED,  // 嚭
	0x56B1, KANJI_RARELY_USED,  // 嚱
	0x56B3, KANJI_RARELY_USED,  // 嚳
	0x56B7, KANJI_RARELY_USED,  // 嚷
	0x56BE, KANJI_RARELY_USED,  // 嚾
	0x56C5, KANJI_RARELY_USED,  // 囅
	0x56C9, KANJI_RARELY_USED,  // 囉
	0x56CA, KANJI_RARELY_USED,  // 囊
	0x56CB, KANJI_RARELY_USED,  // 囋
	0x56CF, KANJI_RARELY_USED,  // 囏
	0x56D0, KANJI_RARELY_USED,  // 囐
	0x56CC, KANJI_RARELY_USED,  // 囌
	0x56CD, KANJI_RARELY_USED,  // 囍
	0x56D9, KANJI_RARELY_USED,  // 囙
	0x56DC, KANJI_RARELY_USED,  // 囜
	0x56DD, KANJI_RARELY_USED,  // 囝
	0x56DF, KANJI_RARELY_USED,  // 囟
	0x56E1, KANJI_RARELY_USED,  // 囡
	0x56E4, KANJI_RARELY_USED,  // 囤
	0x56E5, KANJI_RARELY_USED,  // 囥
	0x56E6, KANJI_RARELY_USED,  // 囦
	0x56E7, KANJI_RARELY_USED,  // 囧
	0x56E8, KANJI_RARELY_USED,  // 囨
	0x56F1, KANJI_RARELY_USED,  // 囱
	0x56EB, KANJI_RARELY_USED,  // 囫
	0x56ED, KANJI_RARELY_USED,  // 园
	0x56F6, KANJI_RARELY_USED,  // 囶
	0x56F7, KANJI_RARELY_USED,  // 囷
	0x5701, KANJI_RARELY_USED,  // 圁
	0x5702, KANJI_RARELY_USED,  // 圂
	0x5707, KANJI_RARELY_USED,  // 圇
	0x570A, KANJI_RARELY_USED,  // 圊
	0x570C, KANJI_RARELY_USED,  // 圌
	0x5711, KANJI_RARELY_USED,  // 圑
	0x5715, KANJI_RARELY_USED,  // 圕
	0x571A, KANJI_RARELY_USED,  // 圚
	0x571B, KANJI_RARELY_USED,  // 圛
	0x571D, KANJI_RARELY_USED,  // 圝
	0x5720, KANJI_RARELY_USED,  // 圠
	0x5722, KANJI_RARELY_USED,  // 圢
	0x5723, KANJI_RARELY_USED,  // 圣
	0x5724, KANJI_RARELY_USED,  // 圤
	0x5725, KANJI_RARELY_USED,  // 圥
	0x5729, KANJI_RARELY_USED,  // 圩
	0x572A, KANJI_RARELY_USED,  // 圪
	0x572C, KANJI_RARELY_USED,  // 圬
	0x572E, KANJI_RARELY_USED,  // 圮
	0x572F, KANJI_RARELY_USED,  // 圯
	0x5733, KANJI_RARELY_USED,  // 圳
	0x5734, KANJI_RARELY_USED,  // 圴
	0x573D, KANJI_RARELY_USED,  // 圽
	0x573E, KANJI_RARELY_USED,  // 圾
	0x573F, KANJI_RARELY_USED,  // 圿
	0x5745, KANJI_RARELY_USED,  // 坅
	0x5746, KANJI_RARELY_USED,  // 坆
	0x574C, KANJI_RARELY_USED,  // 坌
	0x574D, KANJI_RARELY_USED,  // 坍
	0x5752, KANJI_RARELY_USED,  // 坒
	0x5762, KANJI_RARELY_USED,  // 坢
	0x5765, KANJI_RARELY_USED,  // 坥
	0x5767, KANJI_RARELY_USED,  // 坧
	0x5768, KANJI_RARELY_USED,  // 坨
	0x576B, KANJI_RARELY_USED,  // 坫
	0x576D, KANJI_RARELY_USED,  // 坭
	0x576E, KANJI_RARELY_USED,  // 坮
	0x576F, KANJI_RARELY_USED,  // 坯
	0x5770, KANJI_RARELY_USED,  // 坰
	0x5771, KANJI_RARELY_USED,  // 坱
	0x5773, KANJI_RARELY_USED,  // 坳
	0x5774, KANJI_RARELY_USED,  // 坴
	0x5775, KANJI_RARELY_USED,  // 坵
	0x5777, KANJI_RARELY_USED,  // 坷
	0x5779, KANJI_RARELY_USED,  // 坹
	0x577A, KANJI_RARELY_USED,  // 坺
	0x577B, KANJI_RARELY_USED,  // 坻
	0x577C, KANJI_RARELY_USED,  // 坼
	0x577E, KANJI_RARELY_USED,  // 坾
	0x5781, KANJI_RARELY_USED,  // 垁
	0x5783, KANJI_RARELY_USED,  // 垃
	0x578C, KANJI_RARELY_USED,  // 垌
	0x5794, KANJI_RARELY_USED,  // 垔
	0x5797, KANJI_RARELY_USED,  // 垗
	0x5799, KANJI_RARELY_USED,  // 垙
	0x579A, KANJI_RARELY_USED,  // 垚
	0x579C, KANJI_RARELY_USED,  // 垜
	0x579D, KANJI_RARELY_USED,  // 垝
	0x579E, KANJI_RARELY_USED,  // 垞
	0x579F, KANJI_RARELY_USED,  // 垟
	0x57A1, KANJI_RARELY_USED,  // 垡
	0x5795, KANJI_RARELY_USED,  // 垕
	0x57A7, KANJI_RARELY_USED,  // 垧
	0x57A8, KANJI_RARELY_USED,  // 垨
	0x57A9, KANJI_RARELY_USED,  // 垩
	0x57AC, KANJI_RARELY_USED,  // 垬
	0x57B8, KANJI_RARELY_USED,  // 垸
	0x57BD, KANJI_RARELY_USED,  // 垽
	0x57C7, KANJI_RARELY_USED,  // 埇
	0x57C8, KANJI_RARELY_USED,  // 埈
	0x57CC, KANJI_RARELY_USED,  // 埌
	0x57CF, KANJI_RARELY_USED,  // 埏
	0x57D5, KANJI_RARELY_USED,  // 埕
	0x57DD, KANJI_RARELY_USED,  // 埝
	0x57DE, KANJI_RARELY_USED,  // 埞
	0x57E4, KANJI_RARELY_USED,  // 埤
	0x57E6, KANJI_RARELY_USED,  // 埦
	0x57E7, KANJI_RARELY_USED,  // 埧
	0x57E9, KANJI_RARELY_USED,  // 埩
	0x57ED, KANJI_RARELY_USED,  // 埭
	0x57F0, KANJI_RARELY_USED,  // 埰
	0x57F5, KANJI_RARELY_USED,  // 埵
	0x57F6, KANJI_RARELY_USED,  // 埶
	0x57F8, KANJI_RARELY_USED,  // 埸
	0x57FD, KANJI_RARELY_USED,  // 埽
	0x57FE, KANJI_RARELY_USED,  // 埾
	0x57FF, KANJI_RARELY_USED,  // 埿
	0x5803, KANJI_RARELY_USED,  // 堃
	0x5804, KANJI_RARELY_USED,  // 堄
	0x5808, KANJI_RARELY_USED,  // 堈
	0x5809, KANJI_RARELY_USED,  // 堉
	0x57E1, KANJI_RARELY_USED,  // 埡
	0x580C, KANJI_RARELY_USED,  // 堌
	0x580D, KANJI_RARELY_USED,  // 堍
	0x581B, KANJI_RARELY_USED,  // 堛
	0x581E, KANJI_RARELY_USED,  // 堞
	0x581F, KANJI_RARELY_USED,  // 堟
	0x5820, KANJI_RARELY_USED,  // 堠
	0x5826, KANJI_RARELY_USED,  // 堦
	0x5827, KANJI_RARELY_USED,  // 堧
	0x582D, KANJI_RARELY_USED,  // 堭
	0x5832, KANJI_RARELY_USED,  // 堲
	0x5839, KANJI_RARELY_USED,  // 堹
	0x583F, KANJI_RARELY_USED,  // 堿
	0x5849, KANJI_RARELY_USED,  // 塉
	0x584C, KANJI_RARELY_USED,  // 塌
	0x584D, KANJI_RARELY_USED,  // 塍
	0x584F, KANJI_RARELY_USED,  // 塏
	0x5850, KANJI_RARELY_USED,  // 塐
	0x5855, KANJI_RARELY_USED,  // 塕
	0x585F, KANJI_RARELY_USED,  // 塟
	0x5861, KANJI_RARELY_USED,  // 塡
	0x5864, KANJI_RARELY_USED,  // 塤
	0x5867, KANJI_RARELY_USED,  // 塧
	0x5868, KANJI_RARELY_USED,  // 塨
	0x5878, KANJI_RARELY_USED,  // 塸
	0x587C, KANJI_RARELY_USED,  // 塼
	0x587F, KANJI_RARELY_USED,  // 塿
	0x5880, KANJI_RARELY_USED,  // 墀
	0x5881, KANJI_RARELY_USED,  // 墁
	0x5887, KANJI_RARELY_USED,  // 墇
	0x5888, KANJI_RARELY_USED,  // 墈
	0x5889, KANJI_RARELY_USED,  // 墉
	0x588A, KANJI_RARELY_USED,  // 墊
	0x588C, KANJI_RARELY_USED,  // 墌
	0x588D, KANJI_RARELY_USED,  // 墍
	0x588F, KANJI_RARELY_USED,  // 墏
	0x5890, KANJI_RARELY_USED,  // 墐
	0x5894, KANJI_RARELY_USED,  // 墔
	0x5896, KANJI_RARELY_USED,  // 墖
	0x589D, KANJI_RARELY_USED,  // 墝
	0x58A0, KANJI_RARELY_USED,  // 墠
	0x58A1, KANJI_RARELY_USED,  // 墡
	0x58A2, KANJI_RARELY_USED,  // 墢
	0x58A6, KANJI_RARELY_USED,  // 墦
	0x58A9, KANJI_RARELY_USED,  // 墩
	0x58B1, KANJI_RARELY_USED,  // 墱
	0x58B2, KANJI_RARELY_USED,  // 墲
	0x58C4, KANJI_RARELY_USED,  // 壄
	0x58BC, KANJI_RARELY_USED,  // 墼
	0x58C2, KANJI_RARELY_USED,  // 壂
	0x58C8, KANJI_RARELY_USED,  // 壈
	0x58CD, KANJI_RARELY_USED,  // 壍
	0x58CE, KANJI_RARELY_USED,  // 壎
	0x58D0, KANJI_RARELY_USED,  // 壐
	0x58D2, KANJI_RARELY_USED,  // 壒
	0x58D4, KANJI_RARELY_USED,  // 壔
	0x58D6, KANJI_RARELY_USED,  // 壖
	0x58DA, KANJI_RARELY_USED,  // 壚
	0x58DD, KANJI_RARELY_USED,  // 壝
	0x58E1, KANJI_RARELY_USED,  // 壡
	0x58E2, KANJI_RARELY_USED,  // 壢
	0x58E9, KANJI_RARELY_USED,  // 壩
	0x58F3, KANJI_RARELY_USED,  // 壳
	0x5905, KANJI_RARELY_USED,  // 夅
	0x5906, KANJI_RARELY_USED,  // 夆
	0x590B, KANJI_RARELY_USED,  // 夋
	0x590C, KANJI_RARELY_USED,  // 夌
	0x5912, KANJI_RARELY_USED,  // 夒
	0x5913, KANJI_RARELY_USED,  // 夓
	0x5914, KANJI_RARELY_USED,  // 夔
	0x8641, KANJI_RARELY_USED,  // 虁
	0x591D, KANJI_RARELY_USED,  // 夝
	0x5921, KANJI_RARELY_USED,  // 夡
	0x5923, KANJI_RARELY_USED,  // 夣
	0x5924, KANJI_RARELY_USED,  // 夤
	0x5928, KANJI_RARELY_USED,  // 夨
	0x592F, KANJI_RARELY_USED,  // 夯
	0x5930, KANJI_RARELY_USED,  // 夰
	0x5933, KANJI_RARELY_USED,  // 夳
	0x5935, KANJI_RARELY_USED,  // 夵
	0x5936, KANJI_RARELY_USED,  // 夶
	0x593F, KANJI_RARELY_USED,  // 夿
	0x5943, KANJI_RARELY_USED,  // 奃
	0x5946, KANJI_RARELY_USED,  // 奆
	0x5952, KANJI_RARELY_USED,  // 奒
	0x5953, KANJI_RARELY_USED,  // 奓
	0x5959, KANJI_RARELY_USED,  // 奙
	0x595B, KANJI_RARELY_USED,  // 奛
	0x595D, KANJI_RARELY_USED,  // 奝
	0x595E, KANJI_RARELY_USED,  // 奞
	0x595F, KANJI_RARELY_USED,  // 奟
	0x5961, KANJI_RARELY_USED,  // 奡
	0x5963, KANJI_RARELY_USED,  // 奣
	0x596B, KANJI_RARELY_USED,  // 奫
	0x596D, KANJI_RARELY_USED,  // 奭
	0x596F, KANJI_RARELY_USED,  // 奯
	0x5972, KANJI_RARELY_USED,  // 奲
	0x5975, KANJI_RARELY_USED,  // 奵
	0x5976, KANJI_RARELY_USED,  // 奶
	0x5979, KANJI_RARELY_USED,  // 她
	0x597B, KANJI_RARELY_USED,  // 奻
	0x597C, KANJI_RARELY_USED,  // 奼
	0x598B, KANJI_RARELY_USED,  // 妋
	0x598C, KANJI_RARELY_USED,  // 妌
	0x598E, KANJI_RARELY_USED,  // 妎
	0x5992, KANJI_RARELY_USED,  // 妒
	0x5995, KANJI_RARELY_USED,  // 妕
	0x5997, KANJI_RARELY_USED,  // 妗
	0x599F, KANJI_RARELY_USED,  // 妟
	0x59A4, KANJI_RARELY_USED,  // 妤
	0x59A7, KANJI_RARELY_USED,  // 妧
	0x59AD, KANJI_RARELY_USED,  // 妭
	0x59AE, KANJI_RARELY_USED,  // 妮
	0x59AF, KANJI_RARELY_USED,  // 妯
	0x59B0, KANJI_RARELY_USED,  // 妰
	0x59B3, KANJI_RARELY_USED,  // 妳
	0x59B7, KANJI_RARELY_USED,  // 妷
	0x59BA, KANJI_RARELY_USED,  // 妺
	0x59BC, KANJI_RARELY_USED,  // 妼
	0x59C1, KANJI_RARELY_USED,  // 姁
	0x59C3, KANJI_RARELY_USED,  // 姃
	0x59C4, KANJI_RARELY_USED,  // 姄
	0x59C8, KANJI_RARELY_USED,  // 姈
	0x59CA, KANJI_RARELY_USED,  // 姊
	0x59CD, KANJI_RARELY_USED,  // 姍
	0x59D2, KANJI_RARELY_USED,  // 姒
	0x59DD, KANJI_RARELY_USED,  // 姝
	0x59DE, KANJI_RARELY_USED,  // 姞
	0x59DF, KANJI_RARELY_USED,  // 姟
	0x59E3, KANJI_RARELY_USED,  // 姣
	0x59E4, KANJI_RARELY_USED,  // 姤
	0x59E7, KANJI_RARELY_USED,  // 姧
	0x59EE, KANJI_RARELY_USED,  // 姮
	0x59EF, KANJI_RARELY_USED,  // 姯
	0x59F1, KANJI_RARELY_USED,  // 姱
	0x59F2, KANJI_RARELY_USED,  // 姲
	0x59F4, KANJI_RARELY_USED,  // 姴
	0x59F7, KANJI_RARELY_USED,  // 姷
	0x5A00, KANJI_RARELY_USED,  // 娀
	0x5A04, KANJI_RARELY_USED,  // 娄
	0x5A0C, KANJI_RARELY_USED,  // 娌
	0x5A0D, KANJI_RARELY_USED,  // 娍
	0x5A0E, KANJI_RARELY_USED,  // 娎
	0x5A12, KANJI_RARELY_USED,  // 娒
	0x5A13, KANJI_RARELY_USED,  // 娓
	0x5A1E, KANJI_RARELY_USED,  // 娞
	0x5A23, KANJI_RARELY_USED,  // 娣
	0x5A24, KANJI_RARELY_USED,  // 娤
	0x5A27, KANJI_RARELY_USED,  // 娧
	0x5A28, KANJI_RARELY_USED,  // 娨
	0x5A2A, KANJI_RARELY_USED,  // 娪
	0x5A2D, KANJI_RARELY_USED,  // 娭
	0x5A30, KANJI_RARELY_USED,  // 娰
	0x5A44, KANJI_RARELY_USED,  // 婄
	0x5A45, KANJI_RARELY_USED,  // 婅
	0x5A47, KANJI_RARELY_USED,  // 婇
	0x5A48, KANJI_RARELY_USED,  // 婈
	0x5A4C, KANJI_RARELY_USED,  // 婌
	0x5A50, KANJI_RARELY_USED,  // 婐
	0x5A55, KANJI_RARELY_USED,  // 婕
	0x5A5E, KANJI_RARELY_USED,  // 婞
	0x5A63, KANJI_RARELY_USED,  // 婣
	0x5A65, KANJI_RARELY_USED,  // 婥
	0x5A67, KANJI_RARELY_USED,  // 婧
	0x5A6D, KANJI_RARELY_USED,  // 婭
	0x5A77, KANJI_RARELY_USED,  // 婷
	0x5A7A, KANJI_RARELY_USED,  // 婺
	0x5A7B, KANJI_RARELY_USED,  // 婻
	0x5A7E, KANJI_RARELY_USED,  // 婾
	0x5A8B, KANJI_RARELY_USED,  // 媋
	0x5A90, KANJI_RARELY_USED,  // 媐
	0x5A93, KANJI_RARELY_USED,  // 媓
	0x5A96, KANJI_RARELY_USED,  // 媖
	0x5A99, KANJI_RARELY_USED,  // 媙
	0x5A9C, KANJI_RARELY_USED,  // 媜
	0x5A9E, KANJI_RARELY_USED,  // 媞
	0x5A9F, KANJI_RARELY_USED,  // 媟
	0x5AA0, KANJI_RARELY_USED,  // 媠
	0x5AA2, KANJI_RARELY_USED,  // 媢
	0x5AA7, KANJI_RARELY_USED,  // 媧
	0x5AAC, KANJI_RARELY_USED,  // 媬
	0x5AB1, KANJI_RARELY_USED,  // 媱
	0x5AB2, KANJI_RARELY_USED,  // 媲
	0x5AB3, KANJI_RARELY_USED,  // 媳
	0x5AB5, KANJI_RARELY_USED,  // 媵
	0x5AB8, KANJI_RARELY_USED,  // 媸
	0x5ABA, KANJI_RARELY_USED,  // 媺
	0x5ABB, KANJI_RARELY_USED,  // 媻
	0x5ABF, KANJI_RARELY_USED,  // 媿
	0x5AC4, KANJI_RARELY_USED,  // 嫄
	0x5AC6, KANJI_RARELY_USED,  // 嫆
	0x5AC8, KANJI_RARELY_USED,  // 嫈
	0x5ACF, KANJI_RARELY_USED,  // 嫏
	0x5ADA, KANJI_RARELY_USED,  // 嫚
	0x5ADC, KANJI_RARELY_USED,  // 嫜
	0x5AE0, KANJI_RARELY_USED,  // 嫠
	0x5AE5, KANJI_RARELY_USED,  // 嫥
	0x5AEA, KANJI_RARELY_USED,  // 嫪
	0x5AEE, KANJI_RARELY_USED,  // 嫮
	0x5AF5, KANJI_RARELY_USED,  // 嫵
	0x5AF6, KANJI_RARELY_USED,  // 嫶
	0x5AFD, KANJI_RARELY_USED,  // 嫽
	0x5B00, KANJI_RARELY_USED,  // 嬀
	0x5B01, KANJI_RARELY_USED,  // 嬁
	0x5B08, KANJI_RARELY_USED,  // 嬈
	0x5B17, KANJI_RARELY_USED,  // 嬗
	0x5B34, KANJI_RARELY_USED,  // 嬴
	0x5B19, KANJI_RARELY_USED,  // 嬙
	0x5B1B, KANJI_RARELY_USED,  // 嬛
	0x5B1D, KANJI_RARELY_USED,  // 嬝
	0x5B21, KANJI_RARELY_USED,  // 嬡
	0x5B25, KANJI_RARELY_USED,  // 嬥
	0x5B2D, KANJI_RARELY_USED,  // 嬭
	0x5B38, KANJI_RARELY_USED,  // 嬸
	0x5B41, KANJI_RARELY_USED,  // 孁
	0x5B4B, KANJI_RARELY_USED,  // 孋
	0x5B4C, KANJI_RARELY_USED,  // 孌
	0x5B52, KANJI_RARELY_USED,  // 孒
	0x5B56, KANJI_RARELY_USED,  // 孖
	0x5B5E, KANJI_RARELY_USED,  // 孞
	0x5B68, KANJI_RARELY_USED,  // 孨
	0x5B6E, KANJI_RARELY_USED,  // 孮
	0x5B6F, KANJI_RARELY_USED,  // 孯
	0x5B7C, KANJI_RARELY_USED,  // 孼
	0x5B7D, KANJI_RARELY_USED,  // 孽
	0x5B7E, KANJI_RARELY_USED,  // 孾
	0x5B7F, KANJI_RARELY_USED,  // 孿
	0x5B81, KANJI_RARELY_USED,  // 宁
	0x5B84, KANJI_RARELY_USED,  // 宄
	0x5B86, KANJI_RARELY_USED,  // 宆
	0x5B8A, KANJI_RARELY_USED,  // 宊
	0x5B8E, KANJI_RARELY_USED,  // 宎
	0x5B90, KANJI_RARELY_USED,  // 宐
	0x5B91, KANJI_RARELY_USED,  // 宑
	0x5B93, KANJI_RARELY_USED,  // 宓
	0x5B94, KANJI_RARELY_USED,  // 宔
	0x5B96, KANJI_RARELY_USED,  // 宖
	0x5BA8, KANJI_RARELY_USED,  // 宨
	0x5BA9, KANJI_RARELY_USED,  // 宩
	0x5BAC, KANJI_RARELY_USED,  // 宬
	0x5BAD, KANJI_RARELY_USED,  // 宭
	0x5BAF, KANJI_RARELY_USED,  // 宯
	0x5BB1, KANJI_RARELY_USED,  // 宱
	0x5BB2, KANJI_RARELY_USED,  // 宲
	0x5BB7, KANJI_RARELY_USED,  // 宷
	0x5BBA, KANJI_RARELY_USED,  // 宺
	0x5BBC, KANJI_RARELY_USED,  // 宼
	0x5BC0, KANJI_RARELY_USED,  // 寀
	0x5BC1, KANJI_RARELY_USED,  // 寁
	0x5BCD, KANJI_RARELY_USED,  // 寍
	0x5BCF, KANJI_RARELY_USED,  // 寏
	0x5BD6, KANJI_RARELY_USED,  // 寖
	0x5BD7, KANJI_RARELY_USED,  // 寗
	0x5BD8, KANJI_RARELY_USED,  // 寘
	0x5BD9, KANJI_RARELY_USED,  // 寙
	0x5BDA, KANJI_RARELY_USED,  // 寚
	0x5BE0, KANJI_RARELY_USED,  // 寠
	0x5BEF, KANJI_RARELY_USED,  // 寯
	0x5BF1, KANJI_RARELY_USED,  // 寱
	0x5BF4, KANJI_RARELY_USED,  // 寴
	0x5BFD, KANJI_RARELY_USED,  // 寽
	0x5C0C, KANJI_RARELY_USED,  // 尌
	0x5C17, KANJI_RARELY_USED,  // 尗
	0x5C1E, KANJI_RARELY_USED,  // 尞
	0x5C1F, KANJI_RARELY_USED,  // 尟
	0x5C23, KANJI_RARELY_USED,  // 尣
	0x5C26, KANJI_RARELY_USED,  // 尦
	0x5C29, KANJI_RARELY_USED,  // 尩
	0x5C2B, KANJI_RARELY_USED,  // 尫
	0x5C2C, KANJI_RARELY_USED,  // 尬
	0x5C2E, KANJI_RARELY_USED,  // 尮
	0x5C30, KANJI_RARELY_USED,  // 尰
	0x5C32, KANJI_RARELY_USED,  // 尲
	0x5C35, KANJI_RARELY_USED,  // 尵
	0x5C36, KANJI_RARELY_USED,  // 尶
	0x5C59, KANJI_RARELY_USED,  // 屙
	0x5C5A, KANJI_RARELY_USED,  // 屚
	0x5C5C, KANJI_RARELY_USED,  // 屜
	0x5C62, KANJI_RARELY_USED,  // 屢
	0x5C63, KANJI_RARELY_USED,  // 屣
	0x5C67, KANJI_RARELY_USED,  // 屧
	0x5C68, KANJI_RARELY_USED,  // 屨
	0x5C69, KANJI_RARELY_USED,  // 屩
	0x5C6D, KANJI_RARELY_USED,  // 屭
	0x5C70, KANJI_RARELY_USED,  // 屰
	0x5C74, KANJI_RARELY_USED,  // 屴
	0x5C75, KANJI_RARELY_USED,  // 屵
	0x5C7A, KANJI_RARELY_USED,  // 屺
	0x5C7B, KANJI_RARELY_USED,  // 屻
	0x5C7C, KANJI_RARELY_USED,  // 屼
	0x5C7D, KANJI_RARELY_USED,  // 屽
	0x5C87, KANJI_RARELY_USED,  // 岇
	0x5C88, KANJI_RARELY_USED,  // 岈
	0x5C8A, KANJI_RARELY_USED,  // 岊
	0x5C8F, KANJI_RARELY_USED,  // 岏
	0x5C92, KANJI_RARELY_USED,  // 岒
	0x5C9D, KANJI_RARELY_USED,  // 岝
	0x5C9F, KANJI_RARELY_USED,  // 岟
	0x5CA0, KANJI_RARELY_USED,  // 岠
	0x5CA2, KANJI_RARELY_USED,  // 岢
	0x5CA3, KANJI_RARELY_USED,  // 岣
	0x5CA6, KANJI_RARELY_USED,  // 岦
	0x5CAA, KANJI_RARELY_USED,  // 岪
	0x5CB2, KANJI_RARELY_USED,  // 岲
	0x5CB4, KANJI_RARELY_USED,  // 岴
	0x5CB5, KANJI_RARELY_USED,  // 岵
	0x5CBA, KANJI_RARELY_USED,  // 岺
	0x5CC9, KANJI_RARELY_USED,  // 峉
	0x5CCB, KANJI_RARELY_USED,  // 峋
	0x5CD2, KANJI_RARELY_USED,  // 峒
	0x5CDD, KANJI_RARELY_USED,  // 峝
	0x5CD7, KANJI_RARELY_USED,  // 峗
	0x5CEE, KANJI_RARELY_USED,  // 峮
	0x5CF1, KANJI_RARELY_USED,  // 峱
	0x5CF2, KANJI_RARELY_USED,  // 峲
	0x5CF4, KANJI_RARELY_USED,  // 峴
	0x5D01, KANJI_RARELY_USED,  // 崁
	0x5D06, KANJI_RARELY_USED,  // 崆
	0x5D0D, KANJI_RARELY_USED,  // 崍
	0x5D12, KANJI_RARELY_USED,  // 崒
	0x5D2B, KANJI_RARELY_USED,  // 崫
	0x5D23, KANJI_RARELY_USED,  // 崣
	0x5D24, KANJI_RARELY_USED,  // 崤
	0x5D26, KANJI_RARELY_USED,  // 崦
	0x5D27, KANJI_RARELY_USED,  // 崧
	0x5D31, KANJI_RARELY_USED,  // 崱
	0x5D34, KANJI_RARELY_USED,  // 崴
	0x5D39, KANJI_RARELY_USED,  // 崹
	0x5D3D, KANJI_RARELY_USED,  // 崽
	0x5D3F, KANJI_RARELY_USED,  // 崿
	0x5D42, KANJI_RARELY_USED,  // 嵂
	0x5D43, KANJI_RARELY_USED,  // 嵃
	0x5D46, KANJI_RARELY_USED,  // 嵆
	0x5D48, KANJI_RARELY_USED,  // 嵈
	0x5D55, KANJI_RARELY_USED,  // 嵕
	0x5D51, KANJI_RARELY_USED,  // 嵑
	0x5D59, KANJI_RARELY_USED,  // 嵙
	0x5D4A, KANJI_RARELY_USED,  // 嵊
	0x5D5F, KANJI_RARELY_USED,  // 嵟
	0x5D60, KANJI_RARELY_USED,  // 嵠
	0x5D61, KANJI_RARELY_USED,  // 嵡
	0x5D62, KANJI_RARELY_USED,  // 嵢
	0x5D64, KANJI_RARELY_USED,  // 嵤
	0x5D6A, KANJI_RARELY_USED,  // 嵪
	0x5D6D, KANJI_RARELY_USED,  // 嵭
	0x5D70, KANJI_RARELY_USED,  // 嵰
	0x5D79, KANJI_RARELY_USED,  // 嵹
	0x5D7A, KANJI_RARELY_USED,  // 嵺
	0x5D7E, KANJI_RARELY_USED,  // 嵾
	0x5D7F, KANJI_RARELY_USED,  // 嵿
	0x5D81, KANJI_RARELY_USED,  // 嶁
	0x5D83, KANJI_RARELY_USED,  // 嶃
	0x5D88, KANJI_RARELY_USED,  // 嶈
	0x5D8A, KANJI_RARELY_USED,  // 嶊
	0x5D92, KANJI_RARELY_USED,  // 嶒
	0x5D93, KANJI_RARELY_USED,  // 嶓
	0x5D94, KANJI_RARELY_USED,  // 嶔
	0x5D95, KANJI_RARELY_USED,  // 嶕
	0x5D99, KANJI_RARELY_USED,  // 嶙
	0x5D9B, KANJI_RARELY_USED,  // 嶛
	0x5D9F, KANJI_RARELY_USED,  // 嶟
	0x5DA0, KANJI_RARELY_USED,  // 嶠
	0x5DA7, KANJI_RARELY_USED,  // 嶧
	0x5DAB, KANJI_RARELY_USED,  // 嶫
	0x5DB0, KANJI_RARELY_USED,  // 嶰
	0x5DB4, KANJI_RARELY_USED,  // 嶴
	0x5DB8, KANJI_RARELY_USED,  // 嶸
	0x5DB9, KANJI_RARELY_USED,  // 嶹
	0x5DC3, KANJI_RARELY_USED,  // 巃
	0x5DC7, KANJI_RARELY_USED,  // 巇
	0x5DCB, KANJI_RARELY_USED,  // 巋
	0x5DD0, KANJI_RARELY_USED,  // 巐
	0x5DCE, KANJI_RARELY_USED,  // 巎
	0x5DD8, KANJI_RARELY_USED,  // 巘
	0x5DD9, KANJI_RARELY_USED,  // 巙
	0x5DE0, KANJI_RARELY_USED,  // 巠
	0x5DE4, KANJI_RARELY_USED,  // 巤
	0x5DE9, KANJI_RARELY_USED,  // 巩
	0x5DF8, KANJI_RARELY_USED,  // 巸
	0x5DF9, KANJI_RARELY_USED,  // 巹
	0x5E00, KANJI_RARELY_USED,  // 帀
	0x5E07, KANJI_RARELY_USED,  // 帇
	0x5E0D, KANJI_RARELY_USED,  // 帍
	0x5E12, KANJI_RARELY_USED,  // 帒
	0x5E14, KANJI_RARELY_USED,  // 帔
	0x5E15, KANJI_RARELY_USED,  // 帕
	0x5E18, KANJI_RARELY_USED,  // 帘
	0x5E1F, KANJI_RARELY_USED,  // 帟
	0x5E20, KANJI_RARELY_USED,  // 帠
	0x5E2E, KANJI_RARELY_USED,  // 帮
	0x5E28, KANJI_RARELY_USED,  // 帨
	0x5E32, KANJI_RARELY_USED,  // 帲
	0x5E35, KANJI_RARELY_USED,  // 帵
	0x5E3E, KANJI_RARELY_USED,  // 帾
	0x5E4B, KANJI_RARELY_USED,  // 幋
	0x5E50, KANJI_RARELY_USED,  // 幐
	0x5E49, KANJI_RARELY_USED,  // 幉
	0x5E51, KANJI_RARELY_USED,  // 幑
	0x5E56, KANJI_RARELY_USED,  // 幖
	0x5E58, KANJI_RARELY_USED,  // 幘
	0x5E5B, KANJI_RARELY_USED,  // 幛
	0x5E5C, KANJI_RARELY_USED,  // 幜
	0x5E5E, KANJI_RARELY_USED,  // 幞
	0x5E68, KANJI_RARELY_USED,  // 幨
	0x5E6A, KANJI_RARELY_USED,  // 幪
	0x5E6B, KANJI_RARELY_USED,  // 幫
	0x5E6C, KANJI_RARELY_USED,  // 幬
	0x5E6D, KANJI_RARELY_USED,  // 幭
	0x5E6E, KANJI_RARELY_USED,  // 幮
	0x5E70, KANJI_RARELY_USED,  // 幰
	0x5E80, KANJI_RARELY_USED,  // 庀
	0x5E8B, KANJI_RARELY_USED,  // 庋
	0x5E8E, KANJI_RARELY_USED,  // 庎
	0x5EA2, KANJI_RARELY_USED,  // 庢
	0x5EA4, KANJI_RARELY_USED,  // 庤
	0x5EA5, KANJI_RARELY_USED,  // 庥
	0x5EA8, KANJI_RARELY_USED,  // 庨
	0x5EAA, KANJI_RARELY_USED,  // 庪
	0x5EAC, KANJI_RARELY_USED,  // 庬
	0x5EB1, KANJI_RARELY_USED,  // 庱
	0x5EB3, KANJI_RARELY_USED,  // 庳
	0x5EBD, KANJI_RARELY_USED,  // 庽
	0x5EBE, KANJI_RARELY_USED,  // 庾
	0x5EBF, KANJI_RARELY_USED,  // 庿
	0x5EC6, KANJI_RARELY_USED,  // 廆
	0x5ECC, KANJI_RARELY_USED,  // 廌
	0x5ECB, KANJI_RARELY_USED,  // 廋
	0x5ECE, KANJI_RARELY_USED,  // 廎
	0x5ED1, KANJI_RARELY_USED,  // 廑
	0x5ED2, KANJI_RARELY_USED,  // 廒
	0x5ED4, KANJI_RARELY_USED,  // 廔
	0x5ED5, KANJI_RARELY_USED,  // 廕
	0x5EDC, KANJI_RARELY_USED,  // 廜
	0x5EDE, KANJI_RARELY_USED,  // 廞
	0x5EE5, KANJI_RARELY_USED,  // 廥
	0x5EEB, KANJI_RARELY_USED,  // 廫
	0x5F02, KANJI_RARELY_USED,  // 异
	0x5F06, KANJI_RARELY_USED,  // 弆
	0x5F07, KANJI_RARELY_USED,  // 弇
	0x5F08, KANJI_RARELY_USED,  // 弈
	0x5F0E, KANJI_RARELY_USED,  // 弎
	0x5F19, KANJI_RARELY_USED,  // 弙
	0x5F1C, KANJI_RARELY_USED,  // 弜
	0x5F1D, KANJI_RARELY_USED,  // 弝
	0x5F21, KANJI_RARELY_USED,  // 弡
	0x5F22, KANJI_RARELY_USED,  // 弢
	0x5F23, KANJI_RARELY_USED,  // 弣
	0x5F24, KANJI_RARELY_USED,  // 弤
	0x5F28, KANJI_RARELY_USED,  // 弨
	0x5F2B, KANJI_RARELY_USED,  // 弫
	0x5F2C, KANJI_RARELY_USED,  // 弬
	0x5F2E, KANJI_RARELY_USED,  // 弮
	0x5F30, KANJI_RARELY_USED,  // 弰
	0x5F34, KANJI_RARELY_USED,  // 弴
	0x5F36, KANJI_RARELY_USED,  // 弶
	0x5F3B, KANJI_RARELY_USED,  // 弻
	0x5F3D, KANJI_RARELY_USED,  // 弽
	0x5F3F, KANJI_RARELY_USED,  // 弿
	0x5F40, KANJI_RARELY_USED,  // 彀
	0x5F44, KANJI_RARELY_USED,  // 彄
	0x5F45, KANJI_RARELY_USED,  // 彅
	0x5F47, KANJI_RARELY_USED,  // 彇
	0x5F4D, KANJI_RARELY_USED,  // 彍
	0x5F50, KANJI_RARELY_USED,  // 彐
	0x5F54, KANJI_RARELY_USED,  // 彔
	0x5F58, KANJI_RARELY_USED,  // 彘
	0x5F5B, KANJI_RARELY_USED,  // 彛
	0x5F60, KANJI_RARELY_USED,  // 彠
	0x5F63, KANJI_RARELY_USED,  // 彣
	0x5F64, KANJI_RARELY_USED,  // 彤
	0x5F67, KANJI_RARELY_USED,  // 彧
	0x5F6F, KANJI_RARELY_USED,  // 彯
	0x5F72, KANJI_RARELY_USED,  // 彲
	0x5F74, KANJI_RARELY_USED,  // 彴
	0x5F75, KANJI_RARELY_USED,  // 彵
	0x5F78, KANJI_RARELY_USED,  // 彸
	0x5F7A, KANJI_RARELY_USED,  // 彺
	0x5F7D, KANJI_RARELY_USED,  // 彽
	0x5F7E, KANJI_RARELY_USED,  // 彾
	0x5F89, KANJI_RARELY_USED,  // 徉
	0x5F8D, KANJI_RARELY_USED,  // 徍
	0x5F8F, KANJI_RARELY_USED,  // 徏
	0x5F96, KANJI_RARELY_USED,  // 徖
	0x5F9C, KANJI_RARELY_USED,  // 徜
	0x5F9D, KANJI_RARELY_USED,  // 徝
	0x5FA2, KANJI_RARELY_USED,  // 徢
	0x5FA7, KANJI_RARELY_USED,  // 徧
	0x5FAB, KANJI_RARELY_USED,  // 徫
	0x5FA4, KANJI_RARELY_USED,  // 徤
	0x5FAC, KANJI_RARELY_USED,  // 徬
	0x5FAF, KANJI_RARELY_USED,  // 徯
	0x5FB0, KANJI_RARELY_USED,  // 徰
	0x5FB1, KANJI_RARELY_USED,  // 徱
	0x5FB8, KANJI_RARELY_USED,  // 徸
	0x5FC4, KANJI_RARELY_USED,  // 忄
	0x5FC7, KANJI_RARELY_USED,  // 忇
	0x5FC8, KANJI_RARELY_USED,  // 忈
	0x5FC9, KANJI_RARELY_USED,  // 忉
	0x5FCB, KANJI_RARELY_USED,  // 忋
	0x5FD0, KANJI_RARELY_USED,  // 忐
	0x5FD1, KANJI_RARELY_USED,  // 忑
	0x5FD2, KANJI_RARELY_USED,  // 忒
	0x5FD3, KANJI_RARELY_USED,  // 忓
	0x5FD4, KANJI_RARELY_USED,  // 忔
	0x5FDE, KANJI_RARELY_USED,  // 忞
	0x5FE1, KANJI_RARELY_USED,  // 忡
	0x5FE2, KANJI_RARELY_USED,  // 忢
	0x5FE8, KANJI_RARELY_USED,  // 忨
	0x5FE9, KANJI_RARELY_USED,  // 忩
	0x5FEA, KANJI_RARELY_USED,  // 忪
	0x5FEC, KANJI_RARELY_USED,  // 忬
	0x5FED, KANJI_RARELY_USED,  // 忭
	0x5FEE, KANJI_RARELY_USED,  // 忮
	0x5FEF, KANJI_RARELY_USED,  // 忯
	0x5FF2, KANJI_RARELY_USED,  // 忲
	0x5FF3, KANJI_RARELY_USED,  // 忳
	0x5FF6, KANJI_RARELY_USED,  // 忶
	0x5FFA, KANJI_RARELY_USED,  // 忺
	0x5FFC, KANJI_RARELY_USED,  // 忼
	0x6007, KANJI_RARELY_USED,  // 怇
	0x600A, KANJI_RARELY_USED,  // 怊
	0x600D, KANJI_RARELY_USED,  // 怍
	0x6013, KANJI_RARELY_USED,  // 怓
	0x6014, KANJI_RARELY_USED,  // 怔
	0x6017, KANJI_RARELY_USED,  // 怗
	0x6018, KANJI_RARELY_USED,  // 怘
	0x601A, KANJI_RARELY_USED,  // 怚
	0x601F, KANJI_RARELY_USED,  // 怟
	0x6024, KANJI_RARELY_USED,  // 怤
	0x602D, KANJI_RARELY_USED,  // 怭
	0x6033, KANJI_RARELY_USED,  // 怳
	0x6035, KANJI_RARELY_USED,  // 怵
	0x6040, KANJI_RARELY_USED,  // 恀
	0x6047, KANJI_RARELY_USED,  // 恇
	0x6048, KANJI_RARELY_USED,  // 恈
	0x6049, KANJI_RARELY_USED,  // 恉
	0x604C, KANJI_RARELY_USED,  // 恌
	0x6051, KANJI_RARELY_USED,  // 恑
	0x6054, KANJI_RARELY_USED,  // 恔
	0x6056, KANJI_RARELY_USED,  // 恖
	0x6057, KANJI_RARELY_USED,  // 恗
	0x605D, KANJI_RARELY_USED,  // 恝
	0x6061, KANJI_RARELY_USED,  // 恡
	0x6067, KANJI_RARELY_USED,  // 恧
	0x6071, KANJI_RARELY_USED,  // 恱
	0x607E, KANJI_RARELY_USED,  // 恾
	0x607F, KANJI_RARELY_USED,  // 恿
	0x6082, KANJI_RARELY_USED,  // 悂
	0x6086, KANJI_RARELY_USED,  // 悆
	0x6088, KANJI_RARELY_USED,  // 悈
	0x608A, KANJI_RARELY_USED,  // 悊
	0x608E, KANJI_RARELY_USED,  // 悎
	0x6091, KANJI_RARELY_USED,  // 悑
	0x6093, KANJI_RARELY_USED,  // 悓
	0x6095, KANJI_RARELY_USED,  // 悕
	0x6098, KANJI_RARELY_USED,  // 悘
	0x609D, KANJI_RARELY_USED,  // 悝
	0x609E, KANJI_RARELY_USED,  // 悞
	0x60A2, KANJI_RARELY_USED,  // 悢
	0x60A4, KANJI_RARELY_USED,  // 悤
	0x60A5, KANJI_RARELY_USED,  // 悥
	0x60A8, KANJI_RARELY_USED,  // 您
	0x60B0, KANJI_RARELY_USED,  // 悰
	0x60B1, KANJI_RARELY_USED,  // 悱
	0x60B7, KANJI_RARELY_USED,  // 悷
	0x60BB, KANJI_RARELY_USED,  // 悻
	0x60BE, KANJI_RARELY_USED,  // 悾
	0x60C2, KANJI_RARELY_USED,  // 惂
	0x60C4, KANJI_RARELY_USED,  // 惄
	0x60C8, KANJI_RARELY_USED,  // 惈
	0x60C9, KANJI_RARELY_USED,  // 惉
	0x60CA, KANJI_RARELY_USED,  // 惊
	0x60CB, KANJI_RARELY_USED,  // 惋
	0x60CE, KANJI_RARELY_USED,  // 惎
	0x60CF, KANJI_RARELY_USED,  // 惏
	0x60D4, KANJI_RARELY_USED,  // 惔
	0x60D5, KANJI_RARELY_USED,  // 惕
	0x60D9, KANJI_RARELY_USED,  // 惙
	0x60DB, KANJI_RARELY_USED,  // 惛
	0x60DD, KANJI_RARELY_USED,  // 惝
	0x60DE, KANJI_RARELY_USED,  // 惞
	0x60E2, KANJI_RARELY_USED,  // 惢
	0x60E5, KANJI_RARELY_USED,  // 惥
	0x60F2, KANJI_RARELY_USED,  // 惲
	0x60F5, KANJI_RARELY_USED,  // 惵
	0x60F8, KANJI_RARELY_USED,  // 惸
	0x60FC, KANJI_RARELY_USED,  // 惼
	0x60FD, KANJI_RARELY_USED,  // 惽
	0x6102, KANJI_RARELY_USED,  // 愂
	0x6107, KANJI_RARELY_USED,  // 愇
	0x610A, KANJI_RARELY_USED,  // 愊
	0x610C, KANJI_RARELY_USED,  // 愌
	0x6110, KANJI_RARELY_USED,  // 愐
	0x6111, KANJI_RARELY_USED,  // 愑
	0x6112, KANJI_RARELY_USED,  // 愒
	0x6113, KANJI_RARELY_USED,  // 愓
	0x6114, KANJI_RARELY_USED,  // 愔
	0x6116, KANJI_RARELY_USED,  // 愖
	0x6117, KANJI_RARELY_USED,  // 愗
	0x6119, KANJI_RARELY_USED,  // 愙
	0x611C, KANJI_RARELY_USED,  // 愜
	0x611E, KANJI_RARELY_USED,  // 愞
	0x6122, KANJI_RARELY_USED,  // 愢
	0x612A, KANJI_RARELY_USED,  // 愪
	0x612B, KANJI_RARELY_USED,  // 愫
	0x6130, KANJI_RARELY_USED,  // 愰
	0x6131, KANJI_RARELY_USED,  // 愱
	0x6135, KANJI_RARELY_USED,  // 愵
	0x6136, KANJI_RARELY_USED,  // 愶
	0x6137, KANJI_RARELY_USED,  // 愷
	0x6139, KANJI_RARELY_USED,  // 愹
	0x6141, KANJI_RARELY_USED,  // 慁
	0x6145, KANJI_RARELY_USED,  // 慅
	0x6146, KANJI_RARELY_USED,  // 慆
	0x6149, KANJI_RARELY_USED,  // 慉
	0x615E, KANJI_RARELY_USED,  // 慞
	0x6160, KANJI_RARELY_USED,  // 慠
	0x616C, KANJI_RARELY_USED,  // 慬
	0x6172, KANJI_RARELY_USED,  // 慲
	0x6178, KANJI_RARELY_USED,  // 慸
	0x617B, KANJI_RARELY_USED,  // 慻
	0x617C, KANJI_RARELY_USED,  // 慼
	0x617F, KANJI_RARELY_USED,  // 慿
	0x6180, KANJI_RARELY_USED,  // 憀
	0x6181, KANJI_RARELY_USED,  // 憁
	0x6183, KANJI_RARELY_USED,  // 憃
	0x6184, KANJI_RARELY_USED,  // 憄
	0x618B, KANJI_RARELY_USED,  // 憋
	0x618D, KANJI_RARELY_USED,  // 憍
	0x6192, KANJI_RARELY_USED,  // 憒
	0x6193, KANJI_RARELY_USED,  // 憓
	0x6197, KANJI_RARELY_USED,  // 憗
	0x6198, KANJI_RARELY_USED,  // 憘
	0x619C, KANJI_RARELY_USED,  // 憜
	0x619D, KANJI_RARELY_USED,  // 憝
	0x619F, KANJI_RARELY_USED,  // 憟
	0x61A0, KANJI_RARELY_USED,  // 憠
	0x61A5, KANJI_RARELY_USED,  // 憥
	0x61A8, KANJI_RARELY_USED,  // 憨
	0x61AA, KANJI_RARELY_USED,  // 憪
	0x61AD, KANJI_RARELY_USED,  // 憭
	0x61B8, KANJI_RARELY_USED,  // 憸
	0x61B9, KANJI_RARELY_USED,  // 憹
	0x61BC, KANJI_RARELY_USED,  // 憼
	0x61C0, KANJI_RARELY_USED,  // 懀
	0x61C1, KANJI_RARELY_USED,  // 懁
	0x61C2, KANJI_RARELY_USED,  // 懂
	0x61CE, KANJI_RARELY_USED,  // 懎
	0x61CF, KANJI_RARELY_USED,  // 懏
	0x61D5, KANJI_RARELY_USED,  // 懕
	0x61DC, KANJI_RARELY_USED,  // 懜
	0x61DD, KANJI_RARELY_USED,  // 懝
	0x61DE, KANJI_RARELY_USED,  // 懞
	0x61DF, KANJI_RARELY_USED,  // 懟
	0x61E1, KANJI_RARELY_USED,  // 懡
	0x61E2, KANJI_RARELY_USED,  // 懢
	0x61E7, KANJI_RARELY_USED,  // 懧
	0x61E9, KANJI_RARELY_USED,  // 懩
	0x61E5, KANJI_RARELY_USED,  // 懥
	0x61EC, KANJI_RARELY_USED,  // 懬
	0x61ED, KANJI_RARELY_USED,  // 懭
	0x61EF, KANJI_RARELY_USED,  // 懯
	0x6201, KANJI_RARELY_USED,  // 戁
	0x6203, KANJI_RARELY_USED,  // 戃
	0x6204, KANJI_RARELY_USED,  // 戄
	0x6207, KANJI_RARELY_USED,  // 戇
	0x6213, KANJI_RARELY_USED,  // 戓
	0x6215, KANJI_RARELY_USED,  // 戕
	0x621C, KANJI_RARELY_USED,  // 戜
	0x6220, KANJI_RARELY_USED,  // 戠
	0x6222, KANJI_RARELY_USED,  // 戢
	0x6223, KANJI_RARELY_USED,  // 戣
	0x6227, KANJI_RARELY_USED,  // 戧
	0x6229, KANJI_RARELY_USED,  // 戩
	0x622B, KANJI_RARELY_USED,  // 戫
	0x6239, KANJI_RARELY_USED,  // 戹
	0x623D, KANJI_RARELY_USED,  // 戽
	0x6242, KANJI_RARELY_USED,  // 扂
	0x6243, KANJI_RARELY_USED,  // 扃
	0x6244, KANJI_RARELY_USED,  // 扄
	0x6246, KANJI_RARELY_USED,  // 扆
	0x624C, KANJI_RARELY_USED,  // 扌
	0x6250, KANJI_RARELY_USED,  // 扐
	0x6251, KANJI_RARELY_USED,  // 扑
	0x6252, KANJI_RARELY_USED,  // 扒
	0x6254, KANJI_RARELY_USED,  // 扔
	0x6256, KANJI_RARELY_USED,  // 扖
	0x625A, KANJI_RARELY_USED,  // 扚
	0x625C, KANJI_RARELY_USED,  // 扜
	0x6264, KANJI_RARELY_USED,  // 扤
	0x626D, KANJI_RARELY_USED,  // 扭
	0x626F, KANJI_RARELY_USED,  // 扯
	0x6273, KANJI_RARELY_USED,  // 扳
	0x627A, KANJI_RARELY_USED,  // 扺
	0x627D, KANJI_RARELY_USED,  // 扽
	0x628D, KANJI_RARELY_USED,  // 抍
	0x628E, KANJI_RARELY_USED,  // 抎
	0x628F, KANJI_RARELY_USED,  // 抏
	0x6290, KANJI_RARELY_USED,  // 抐
	0x62A6, KANJI_RARELY_USED,  // 抦
	0x62A8, KANJI_RARELY_USED,  // 抨
	0x62B3, KANJI_RARELY_USED,  // 抳
	0x62B6, KANJI_RARELY_USED,  // 抶
	0x62B7, KANJI_RARELY_USED,  // 抷
	0x62BA, KANJI_RARELY_USED,  // 抺
	0x62BE, KANJI_RARELY_USED,  // 抾
	0x62BF, KANJI_RARELY_USED,  // 抿
	0x62C4, KANJI_RARELY_USED,  // 拄
	0x62CE, KANJI_RARELY_USED,  // 拎
	0x62D5, KANJI_RARELY_USED,  // 拕
	0x62D6, KANJI_RARELY_USED,  // 拖
	0x62DA, KANJI_RARELY_USED,  // 拚
	0x62EA, KANJI_RARELY_USED,  // 拪
	0x62F2, KANJI_RARELY_USED,  // 拲
	0x62F4, KANJI_RARELY_USED,  // 拴
	0x62FC, KANJI_RARELY_USED,  // 拼
	0x62FD, KANJI_RARELY_USED,  // 拽
	0x6303, KANJI_RARELY_USED,  // 挃
	0x6304, KANJI_RARELY_USED,  // 挄
	0x630A, KANJI_RARELY_USED,  // 挊
	0x630B, KANJI_RARELY_USED,  // 挋
	0x630D, KANJI_RARELY_USED,  // 挍
	0x6310, KANJI_RARELY_USED,  // 挐
	0x6313, KANJI_RARELY_USED,  // 挓
	0x6316, KANJI_RARELY_USED,  // 挖
	0x6318, KANJI_RARELY_USED,  // 挘
	0x6329, KANJI_RARELY_USED,  // 挩
	0x632A, KANJI_RARELY_USED,  // 挪
	0x632D, KANJI_RARELY_USED,  // 挭
	0x6335, KANJI_RARELY_USED,  // 挵
	0x6336, KANJI_RARELY_USED,  // 挶
	0x6339, KANJI_RARELY_USED,  // 挹
	0x633C, KANJI_RARELY_USED,  // 挼
	0x6341, KANJI_RARELY_USED,  // 捁
	0x6342, KANJI_RARELY_USED,  // 捂
	0x6343, KANJI_RARELY_USED,  // 捃
	0x6344, KANJI_RARELY_USED,  // 捄
	0x6346, KANJI_RARELY_USED,  // 捆
	0x634A, KANJI_RARELY_USED,  // 捊
	0x634B, KANJI_RARELY_USED,  // 捋
	0x634E, KANJI_RARELY_USED,  // 捎
	0x6352, KANJI_RARELY_USED,  // 捒
	0x6353, KANJI_RARELY_USED,  // 捓
	0x6354, KANJI_RARELY_USED,  // 捔
	0x6358, KANJI_RARELY_USED,  // 捘
	0x635B, KANJI_RARELY_USED,  // 捛
	0x6365, KANJI_RARELY_USED,  // 捥
	0x6366, KANJI_RARELY_USED,  // 捦
	0x636C, KANJI_RARELY_USED,  // 捬
	0x636D, KANJI_RARELY_USED,  // 捭
	0x6371, KANJI_RARELY_USED,  // 捱
	0x6374, KANJI_RARELY_USED,  // 捴
	0x6375, KANJI_RARELY_USED,  // 捵
	0x6378, KANJI_RARELY_USED,  // 捸
	0x637C, KANJI_RARELY_USED,  // 捼
	0x637D, KANJI_RARELY_USED,  // 捽
	0x637F, KANJI_RARELY_USED,  // 捿
	0x6382, KANJI_RARELY_USED,  // 掂
	0x6384, KANJI_RARELY_USED,  // 掄
	0x6387, KANJI_RARELY_USED,  // 掇
	0x638A, KANJI_RARELY_USED,  // 掊
	0x6390, KANJI_RARELY_USED,  // 掐
	0x6394, KANJI_RARELY_USED,  // 掔
	0x6395, KANJI_RARELY_USED,  // 掕
	0x6399, KANJI_RARELY_USED,  // 掙
	0x639A, KANJI_RARELY_USED,  // 掚
	0x639E, KANJI_RARELY_USED,  // 掞
	0x63A4, KANJI_RARELY_USED,  // 掤
	0x63A6, KANJI_RARELY_USED,  // 掦
	0x63AD, KANJI_RARELY_USED,  // 掭
	0x63AE, KANJI_RARELY_USED,  // 掮
	0x63AF, KANJI_RARELY_USED,  // 掯
	0x63BD, KANJI_RARELY_USED,  // 掽
	0x63C1, KANJI_RARELY_USED,  // 揁
	0x63C5, KANJI_RARELY_USED,  // 揅
	0x63C8, KANJI_RARELY_USED,  // 揈
	0x63CE, KANJI_RARELY_USED,  // 揎
	0x63D1, KANJI_RARELY_USED,  // 揑
	0x63D3, KANJI_RARELY_USED,  // 揓
	0x63D4, KANJI_RARELY_USED,  // 揔
	0x63D5, KANJI_RARELY_USED,  // 揕
	0x63DC, KANJI_RARELY_USED,  // 揜
	0x63E0, KANJI_RARELY_USED,  // 揠
	0x63E5, KANJI_RARELY_USED,  // 揥
	0x63EA, KANJI_RARELY_USED,  // 揪
	0x63EC, KANJI_RARELY_USED,  // 揬
	0x63F2, KANJI_RARELY_USED,  // 揲
	0x63F3, KANJI_RARELY_USED,  // 揳
	0x63F5, KANJI_RARELY_USED,  // 揵
	0x63F8, KANJI_RARELY_USED,  // 揸
	0x63F9, KANJI_RARELY_USED,  // 揹
	0x6409, KANJI_RARELY_USED,  // 搉
	0x640A, KANJI_RARELY_USED,  // 搊
	0x6410, KANJI_RARELY_USED,  // 搐
	0x6412, KANJI_RARELY_USED,  // 搒
	0x6414, KANJI_RARELY_USED,  // 搔
	0x6418, KANJI_RARELY_USED,  // 搘
	0x641E, KANJI_RARELY_USED,  // 搞
	0x6420, KANJI_RARELY_USED,  // 搠
	0x6422, KANJI_RARELY_USED,  // 搢
	0x6424, KANJI_RARELY_USED,  // 搤
	0x6425, KANJI_RARELY_USED,  // 搥
	0x6429, KANJI_RARELY_USED,  // 搩
	0x642A, KANJI_RARELY_USED,  // 搪
	0x642F, KANJI_RARELY_USED,  // 搯
	0x6430, KANJI_RARELY_USED,  // 搰
	0x6435, KANJI_RARELY_USED,  // 搵
	0x643D, KANJI_RARELY_USED,  // 搽
	0x643F, KANJI_RARELY_USED,  // 搿
	0x644B, KANJI_RARELY_USED,  // 摋
	0x644F, KANJI_RARELY_USED,  // 摏
	0x6451, KANJI_RARELY_USED,  // 摑
	0x6452, KANJI_RARELY_USED,  // 摒
	0x6453, KANJI_RARELY_USED,  // 摓
	0x6454, KANJI_RARELY_USED,  // 摔
	0x645A, KANJI_RARELY_USED,  // 摚
	0x645B, KANJI_RARELY_USED,  // 摛
	0x645C, KANJI_RARELY_USED,  // 摜
	0x645D, KANJI_RARELY_USED,  // 摝
	0x645F, KANJI_RARELY_USED,  // 摟
	0x6460, KANJI_RARELY_USED,  // 摠
	0x6461, KANJI_RARELY_USED,  // 摡
	0x6463, KANJI_RARELY_USED,  // 摣
	0x646D, KANJI_RARELY_USED,  // 摭
	0x6473, KANJI_RARELY_USED,  // 摳
	0x6474, KANJI_RARELY_USED,  // 摴
	0x647B, KANJI_RARELY_USED,  // 摻
	0x647D, KANJI_RARELY_USED,  // 摽
	0x6485, KANJI_RARELY_USED,  // 撅
	0x6487, KANJI_RARELY_USED,  // 撇
	0x648F, KANJI_RARELY_USED,  // 撏
	0x6490, KANJI_RARELY_USED,  // 撐
	0x6491, KANJI_RARELY_USED,  // 撑
	0x6498, KANJI_RARELY_USED,  // 撘
	0x6499, KANJI_RARELY_USED,  // 撙
	0x649B, KANJI_RARELY_USED,  // 撛
	0x649D, KANJI_RARELY_USED,  // 撝
	0x649F, KANJI_RARELY_USED,  // 撟
	0x64A1, KANJI_RARELY_USED,  // 撡
	0x64A3, KANJI_RARELY_USED,  // 撣
	0x64A6, KANJI_RARELY_USED,  // 撦
	0x64A8, KANJI_RARELY_USED,  // 撨
	0x64AC, KANJI_RARELY_USED,  // 撬
	0x64B3, KANJI_RARELY_USED,  // 撳
	0x64BD, KANJI_RARELY_USED,  // 撽
	0x64BE, KANJI_RARELY_USED,  // 撾
	0x64BF, KANJI_RARELY_USED,  // 撿
	0x64C4, KANJI_RARELY_USED,  // 擄
	0x64C9, KANJI_RARELY_USED,  // 擉
	0x64CA, KANJI_RARELY_USED,  // 擊
	0x64CB, KANJI_RARELY_USED,  // 擋
	0x64CC, KANJI_RARELY_USED,  // 擌
	0x64CE, KANJI_RARELY_USED,  // 擎
	0x64D0, KANJI_RARELY_USED,  // 擐
	0x64D1, KANJI_RARELY_USED,  // 擑
	0x64D5, KANJI_RARELY_USED,  // 擕
	0x64D7, KANJI_RARELY_USED,  // 擗
	0x64E4, KANJI_RARELY_USED,  // 擤
	0x64E5, KANJI_RARELY_USED,  // 擥
	0x64E9, KANJI_RARELY_USED,  // 擩
	0x64EA, KANJI_RARELY_USED,  // 擪
	0x64ED, KANJI_RARELY_USED,  // 擭
	0x64F0, KANJI_RARELY_USED,  // 擰
	0x64F5, KANJI_RARELY_USED,  // 擵
	0x64F7, KANJI_RARELY_USED,  // 擷
	0x64FB, KANJI_RARELY_USED,  // 擻
	0x64FF, KANJI_RARELY_USED,  // 擿
	0x6501, KANJI_RARELY_USED,  // 攁
	0x6504, KANJI_RARELY_USED,  // 攄
	0x6508, KANJI_RARELY_USED,  // 攈
	0x6509, KANJI_RARELY_USED,  // 攉
	0x650A, KANJI_RARELY_USED,  // 攊
	0x650F, KANJI_RARELY_USED,  // 攏
	0x6513, KANJI_RARELY_USED,  // 攓
	0x6514, KANJI_RARELY_USED,  // 攔
	0x6516, KANJI_RARELY_USED,  // 攖
	0x6519, KANJI_RARELY_USED,  // 攙
	0x651B, KANJI_RARELY_USED,  // 攛
	0x651E, KANJI_RARELY_USED,  // 攞
	0x651F, KANJI_RARELY_USED,  // 攟
	0x6522, KANJI_RARELY_USED,  // 攢
	0x6526, KANJI_RARELY_USED,  // 攦
	0x6529, KANJI_RARELY_USED,  // 攩
	0x652E, KANJI_RARELY_USED,  // 攮
	0x6531, KANJI_RARELY_USED,  // 攱
	0x653A, KANJI_RARELY_USED,  // 攺
	0x653C, KANJI_RARELY_USED,  // 攼
	0x653D, KANJI_RARELY_USED,  // 攽
	0x6543, KANJI_RARELY_USED,  // 敃
	0x6547, KANJI_RARELY_USED,  // 敇
	0x6549, KANJI_RARELY_USED,  // 敉
	0x6550, KANJI_RARELY_USED,  // 敐
	0x6552, KANJI_RARELY_USED,  // 敒
	0x6554, KANJI_RARELY_USED,  // 敔
	0x655F, KANJI_RARELY_USED,  // 敟
	0x6560, KANJI_RARELY_USED,  // 敠
	0x6567, KANJI_RARELY_USED,  // 敧
	0x656B, KANJI_RARELY_USED,  // 敫
	0x657A, KANJI_RARELY_USED,  // 敺
	0x657D, KANJI_RARELY_USED,  // 敽
	0x6581, KANJI_RARELY_USED,  // 斁
	0x6585, KANJI_RARELY_USED,  // 斅
	0x658A, KANJI_RARELY_USED,  // 斊
	0x6592, KANJI_RARELY_USED,  // 斒
	0x6595, KANJI_RARELY_USED,  // 斕
	0x6598, KANJI_RARELY_USED,  // 斘
	0x659D, KANJI_RARELY_USED,  // 斝
	0x65A0, KANJI_RARELY_USED,  // 斠
	0x65A3, KANJI_RARELY_USED,  // 斣
	0x65A6, KANJI_RARELY_USED,  // 斦
	0x65AE, KANJI_RARELY_USED,  // 斮
	0x65B2, KANJI_RARELY_USED,  // 斲
	0x65B3, KANJI_RARELY_USED,  // 斳
	0x65B4, KANJI_RARELY_USED,  // 斴
	0x65BF, KANJI_RARELY_USED,  // 斿
	0x65C2, KANJI_RARELY_USED,  // 旂
	0x65C8, KANJI_RARELY_USED,  // 旈
	0x65C9, KANJI_RARELY_USED,  // 旉
	0x65CE, KANJI_RARELY_USED,  // 旎
	0x65D0, KANJI_RARELY_USED,  // 旐
	0x65D4, KANJI_RARELY_USED,  // 旔
	0x65D6, KANJI_RARELY_USED,  // 旖
	0x65D8, KANJI_RARELY_USED,  // 旘
	0x65DF, KANJI_RARELY_USED,  // 旟
	0x65F0, KANJI_RARELY_USED,  // 旰
	0x65F2, KANJI_RARELY_USED,  // 旲
	0x65F4, KANJI_RARELY_USED,  // 旴
	0x65F5, KANJI_RARELY_USED,  // 旵
	0x65F9, KANJI_RARELY_USED,  // 旹
	0x65FE, KANJI_RARELY_USED,  // 旾
	0x65FF, KANJI_RARELY_USED,  // 旿
	0x6600, KANJI_RARELY_USED,  // 昀
	0x6604, KANJI_RARELY_USED,  // 昄
	0x6608, KANJI_RARELY_USED,  // 昈
	0x6609, KANJI_RARELY_USED,  // 昉
	0x660D, KANJI_RARELY_USED,  // 昍
	0x6611, KANJI_RARELY_USED,  // 昑
	0x6612, KANJI_RARELY_USED,  // 昒
	0x6615, KANJI_RARELY_USED,  // 昕
	0x6616, KANJI_RARELY_USED,  // 昖
	0x661D, KANJI_RARELY_USED,  // 昝
	0x661E, KANJI_RARELY_USED,  // 昞
	0x6621, KANJI_RARELY_USED,  // 昡
	0x6622, KANJI_RARELY_USED,  // 昢
	0x6623, KANJI_RARELY_USED,  // 昣
	0x6624, KANJI_RARELY_USED,  // 昤
	0x6626, KANJI_RARELY_USED,  // 昦
	0x6629, KANJI_RARELY_USED,  // 昩
	0x662A, KANJI_RARELY_USED,  // 昪
	0x662B, KANJI_RARELY_USED,  // 昫
	0x662C, KANJI_RARELY_USED,  // 昬
	0x662E, KANJI_RARELY_USED,  // 昮
	0x6630, KANJI_RARELY_USED,  // 昰
	0x6631, KANJI_RARELY_USED,  // 昱
	0x6633, KANJI_RARELY_USED,  // 昳
	0x6639, KANJI_RARELY_USED,  // 昹
	0x6637, KANJI_RARELY_USED,  // 昷
	0x6640, KANJI_RARELY_USED,  // 晀
	0x6645, KANJI_RARELY_USED,  // 晅
	0x6646, KANJI_RARELY_USED,  // 晆
	0x664A, KANJI_RARELY_USED,  // 晊
	0x664C, KANJI_RARELY_USED,  // 晌
	0x6651, KANJI_RARELY_USED,  // 晑
	0x664E, KANJI_RARELY_USED,  // 晎
	0x6657, KANJI_RARELY_USED,  // 晗
	0x6658, KANJI_RARELY_USED,  // 晘
	0x6659, KANJI_RARELY_USED,  // 晙
	0x665B, KANJI_RARELY_USED,  // 晛
	0x665C, KANJI_RARELY_USED,  // 晜
	0x6660, KANJI_RARELY_USED,  // 晠
	0x6661, KANJI_RARELY_USED,  // 晡
	0x66FB, KANJI_RARELY_USED,  // 曻
	0x666A, KANJI_RARELY_USED,  // 晪
	0x666B, KANJI_RARELY_USED,  // 晫
	0x666C, KANJI_RARELY_USED,  // 晬
	0x667E, KANJI_RARELY_USED,  // 晾
	0x6673, KANJI_RARELY_USED,  // 晳
	0x6675, KANJI_RARELY_USED,  // 晵
	0x667F, KANJI_RARELY_USED,  // 晿
	0x6677, KANJI_RARELY_USED,  // 晷
	0x6678, KANJI_RARELY_USED,  // 晸
	0x6679, KANJI_RARELY_USED,  // 晹
	0x667B, KANJI_RARELY_USED,  // 晻
	0x6680, KANJI_RARELY_USED,  // 暀
	0x667C, KANJI_RARELY_USED,  // 晼
	0x668B, KANJI_RARELY_USED,  // 暋
	0x668C, KANJI_RARELY_USED,  // 暌
	0x668D, KANJI_RARELY_USED,  // 暍
	0x6690, KANJI_RARELY_USED,  // 暐
	0x6692, KANJI_RARELY_USED,  // 暒
	0x6699, KANJI_RARELY_USED,  // 暙
	0x669A, KANJI_RARELY_USED,  // 暚
	0x669B, KANJI_RARELY_USED,  // 暛
	0x669C, KANJI_RARELY_USED,  // 暜
	0x669F, KANJI_RARELY_USED,  // 暟
	0x66A0, KANJI_RARELY_USED,  // 暠
	0x66A4, KANJI_RARELY_USED,  // 暤
	0x66AD, KANJI_RARELY_USED,  // 暭
	0x66B1, KANJI_RARELY_USED,  // 暱
	0x66B2, KANJI_RARELY_USED,  // 暲
	0x66B5, KANJI_RARELY_USED,  // 暵
	0x66BB, KANJI_RARELY_USED,  // 暻
	0x66BF, KANJI_RARELY_USED,  // 暿
	0x66C0, KANJI_RARELY_USED,  // 曀
	0x66C2, KANJI_RARELY_USED,  // 曂
	0x66C3, KANJI_RARELY_USED,  // 曃
	0x66C8, KANJI_RARELY_USED,  // 曈
	0x66CC, KANJI_RARELY_USED,  // 曌
	0x66CE, KANJI_RARELY_USED,  // 曎
	0x66CF, KANJI_RARELY_USED,  // 曏
	0x66D4, KANJI_RARELY_USED,  // 曔
	0x66DB, KANJI_RARELY_USED,  // 曛
	0x66DF, KANJI_RARELY_USED,  // 曟
	0x66E8, KANJI_RARELY_USED,  // 曨
	0x66EB, KANJI_RARELY_USED,  // 曫
	0x66EC, KANJI_RARELY_USED,  // 曬
	0x66EE, KANJI_RARELY_USED,  // 曮
	0x66FA, KANJI_RARELY_USED,  // 曺
	0x6705, KANJI_RARELY_USED,  // 朅
	0x6707, KANJI_RARELY_USED,  // 朇
	0x670E, KANJI_RARELY_USED,  // 朎
	0x6713, KANJI_RARELY_USED,  // 朓
	0x6719, KANJI_RARELY_USED,  // 朙
	0x671C, KANJI_RARELY_USED,  // 朜
	0x6720, KANJI_RARELY_USED,  // 朠
	0x6722, KANJI_RARELY_USED,  // 朢
	0x6733, KANJI_RARELY_USED,  // 朳
	0x673E, KANJI_RARELY_USED,  // 朾
	0x6745, KANJI_RARELY_USED,  // 杅
	0x6747, KANJI_RARELY_USED,  // 杇
	0x6748, KANJI_RARELY_USED,  // 杈
	0x674C, KANJI_RARELY_USED,  // 杌
	0x6754, KANJI_RARELY_USED,  // 杔
	0x6755, KANJI_RARELY_USED,  // 杕
	0x675D, KANJI_RARELY_USED,  // 杝
	0x6766, KANJI_RARELY_USED,  // 杦
	0x676C, KANJI_RARELY_USED,  // 杬
	0x676E, KANJI_RARELY_USED,  // 杮
	0x6774, KANJI_RARELY_USED,  // 杴
	0x6776, KANJI_RARELY_USED,  // 杶
	0x677B, KANJI_RARELY_USED,  // 杻
	0x6781, KANJI_RARELY_USED,  // 极
	0x6784, KANJI_RARELY_USED,  // 构
	0x678E, KANJI_RARELY_USED,  // 枎
	0x678F, KANJI_RARELY_USED,  // 枏
	0x6791, KANJI_RARELY_USED,  // 枑
	0x6793, KANJI_RARELY_USED,  // 枓
	0x6796, KANJI_RARELY_USED,  // 枖
	0x6798, KANJI_RARELY_USED,  // 枘
	0x6799, KANJI_RARELY_USED,  // 枙
	0x679B, KANJI_RARELY_USED,  // 枛
	0x67B0, KANJI_RARELY_USED,  // 枰
	0x67B1, KANJI_RARELY_USED,  // 枱
	0x67B2, KANJI_RARELY_USED,  // 枲
	0x67B5, KANJI_RARELY_USED,  // 枵
	0x67BB, KANJI_RARELY_USED,  // 枻
	0x67BC, KANJI_RARELY_USED,  // 枼
	0x67BD, KANJI_RARELY_USED,  // 枽
	0x67F9, KANJI_RARELY_USED,  // 柹
	0x67C0, KANJI_RARELY_USED,  // 柀
	0x67C2, KANJI_RARELY_USED,  // 柂
	0x67C3, KANJI_RARELY_USED,  // 柃
	0x67C5, KANJI_RARELY_USED,  // 柅
	0x67C8, KANJI_RARELY_USED,  // 柈
	0x67C9, KANJI_RARELY_USED,  // 柉
	0x67D2, KANJI_RARELY_USED,  // 柒
	0x67D7, KANJI_RARELY_USED,  // 柗
	0x67D9, KANJI_RARELY_USED,  // 柙
	0x67DC, KANJI_RARELY_USED,  // 柜
	0x67E1, KANJI_RARELY_USED,  // 柡
	0x67E6, KANJI_RARELY_USED,  // 柦
	0x67F0, KANJI_RARELY_USED,  // 柰
	0x67F2, KANJI_RARELY_USED,  // 柲
	0x67F6, KANJI_RARELY_USED,  // 柶
	0x67F7, KANJI_RARELY_USED,  // 柷
	0x6852, KANJI_RARELY_USED,  // 桒
	0x6814, KANJI_RARELY_USED,  // 栔
	0x6819, KANJI_RARELY_USED,  // 栙
	0x681D, KANJI_RARELY_USED,  // 栝
	0x681F, KANJI_RARELY_USED,  // 栟
	0x6828, KANJI_RARELY_USED,  // 栨
	0x6827, KANJI_RARELY_USED,  // 栧
	0x682C, KANJI_RARELY_USED,  // 栬
	0x682D, KANJI_RARELY_USED,  // 栭
	0x682F, KANJI_RARELY_USED,  // 栯
	0x6830, KANJI_RARELY_USED,  // 栰
	0x6831, KANJI_RARELY_USED,  // 栱
	0x6833, KANJI_RARELY_USED,  // 栳
	0x683B, KANJI_RARELY_USED,  // 栻
	0x683F, KANJI_RARELY_USED,  // 栿
	0x6844, KANJI_RARELY_USED,  // 桄
	0x6845, KANJI_RARELY_USED,  // 桅
	0x684A, KANJI_RARELY_USED,  // 桊
	0x684C, KANJI_RARELY_USED,  // 桌
	0x6855, KANJI_RARELY_USED,  // 桕
	0x6857, KANJI_RARELY_USED,  // 桗
	0x6858, KANJI_RARELY_USED,  // 桘
	0x685B, KANJI_RARELY_USED,  // 桛
	0x686B, KANJI_RARELY_USED,  // 桫
	0x686E, KANJI_RARELY_USED,  // 桮
	0x686F, KANJI_RARELY_USED,  // 桯
	0x6870, KANJI_RARELY_USED,  // 桰
	0x6871, KANJI_RARELY_USED,  // 桱
	0x6872, KANJI_RARELY_USED,  // 桲
	0x6875, KANJI_RARELY_USED,  // 桵
	0x6879, KANJI_RARELY_USED,  // 桹
	0x687A, KANJI_RARELY_USED,  // 桺
	0x687B, KANJI_RARELY_USED,  // 桻
	0x687C, KANJI_RARELY_USED,  // 桼
	0x6882, KANJI_RARELY_USED,  // 梂
	0x6884, KANJI_RARELY_USED,  // 梄
	0x6886, KANJI_RARELY_USED,  // 梆
	0x6888, KANJI_RARELY_USED,  // 梈
	0x6896, KANJI_RARELY_USED,  // 梖
	0x6898, KANJI_RARELY_USED,  // 梘
	0x689A, KANJI_RARELY_USED,  // 梚
	0x689C, KANJI_RARELY_USED,  // 梜
	0x68A1, KANJI_RARELY_USED,  // 梡
	0x68A3, KANJI_RARELY_USED,  // 梣
	0x68A5, KANJI_RARELY_USED,  // 梥
	0x68A9, KANJI_RARELY_USED,  // 梩
	0x68AA, KANJI_RARELY_USED,  // 梪
	0x68AE, KANJI_RARELY_USED,  // 梮
	0x68B2, KANJI_RARELY_USED,  // 梲
	0x68BB, KANJI_RARELY_USED,  // 梻
	0x68C5, KANJI_RARELY_USED,  // 棅
	0x68C8, KANJI_RARELY_USED,  // 棈
	0x68CC, KANJI_RARELY_USED,  // 棌
	0x68CF, KANJI_RARELY_USED,  // 棏
	0x68D0, KANJI_RARELY_USED,  // 棐
	0x68D1, KANJI_RARELY_USED,  // 棑
	0x68D3, KANJI_RARELY_USED,  // 棓
	0x68D6, KANJI_RARELY_USED,  // 棖
	0x68D9, KANJI_RARELY_USED,  // 棙
	0x68DC, KANJI_RARELY_USED,  // 棜
	0x68DD, KANJI_RARELY_USED,  // 棝
	0x68E5, KANJI_RARELY_USED,  // 棥
	0x68E8, KANJI_RARELY_USED,  // 棨
	0x68EA, KANJI_RARELY_USED,  // 棪
	0x68EB, KANJI_RARELY_USED,  // 棫
	0x68EC, KANJI_RARELY_USED,  // 棬
	0x68ED, KANJI_RARELY_USED,  // 棭
	0x68F0, KANJI_RARELY_USED,  // 棰
	0x68F1, KANJI_RARELY_USED,  // 棱
	0x68F5, KANJI_RARELY_USED,  // 棵
	0x68F6, KANJI_RARELY_USED,  // 棶
	0x68FB, KANJI_RARELY_USED,  // 棻
	0x68FC, KANJI_RARELY_USED,  // 棼
	0x68FD, KANJI_RARELY_USED,  // 棽
	0x6906, KANJI_RARELY_USED,  // 椆
	0x6909, KANJI_RARELY_USED,  // 椉
	0x690A, KANJI_RARELY_USED,  // 椊
	0x6910, KANJI_RARELY_USED,  // 椐
	0x6911, KANJI_RARELY_USED,  // 椑
	0x6913, KANJI_RARELY_USED,  // 椓
	0x6916, KANJI_RARELY_USED,  // 椖
	0x6917, KANJI_RARELY_USED,  // 椗
	0x6931, KANJI_RARELY_USED,  // 椱
	0x6933, KANJI_RARELY_USED,  // 椳
	0x6935, KANJI_RARELY_USED,  // 椵
	0x6938, KANJI_RARELY_USED,  // 椸
	0x693B, KANJI_RARELY_USED,  // 椻
	0x6942, KANJI_RARELY_USED,  // 楂
	0x6945, KANJI_RARELY_USED,  // 楅
	0x6949, KANJI_RARELY_USED,  // 楉
	0x694E, KANJI_RARELY_USED,  // 楎
	0x6957, KANJI_RARELY_USED,  // 楗
	0x695B, KANJI_RARELY_USED,  // 楛
	0x6963, KANJI_RARELY_USED,  // 楣
	0x6964, KANJI_RARELY_USED,  // 楤
	0x6965, KANJI_RARELY_USED,  // 楥
	0x6966, KANJI_RARELY_USED,  // 楦
	0x6968, KANJI_RARELY_USED,  // 楨
	0x6969, KANJI_RARELY_USED,  // 楩
	0x696C, KANJI_RARELY_USED,  // 楬
	0x6970, KANJI_RARELY_USED,  // 楰
	0x6971, KANJI_RARELY_USED,  // 楱
	0x6972, KANJI_RARELY_USED,  // 楲
	0x697A, KANJI_RARELY_USED,  // 楺
	0x697B, KANJI_RARELY_USED,  // 楻
	0x697F, KANJI_RARELY_USED,  // 楿
	0x6980, KANJI_RARELY_USED,  // 榀
	0x698D, KANJI_RARELY_USED,  // 榍
	0x6992, KANJI_RARELY_USED,  // 榒
	0x6996, KANJI_RARELY_USED,  // 榖
	0x6998, KANJI_RARELY_USED,  // 榘
	0x69A1, KANJI_RARELY_USED,  // 榡
	0x69A5, KANJI_RARELY_USED,  // 榥
	0x69A6, KANJI_RARELY_USED,  // 榦
	0x69A8, KANJI_RARELY_USED,  // 榨
	0x69AB, KANJI_RARELY_USED,  // 榫
	0x69AD, KANJI_RARELY_USED,  // 榭
	0x69AF, KANJI_RARELY_USED,  // 榯
	0x69B7, KANJI_RARELY_USED,  // 榷
	0x69B8, KANJI_RARELY_USED,  // 榸
	0x69BA, KANJI_RARELY_USED,  // 榺
	0x69BC, KANJI_RARELY_USED,  // 榼
	0x69C5, KANJI_RARELY_USED,  // 槅
	0x69C8, KANJI_RARELY_USED,  // 槈
	0x69D1, KANJI_RARELY_USED,  // 槑
	0x69D6, KANJI_RARELY_USED,  // 槖
	0x69D7, KANJI_RARELY_USED,  // 槗
	0x69E2, KANJI_RARELY_USED,  // 槢
	0x69E5, KANJI_RARELY_USED,  // 槥
	0x69EE, KANJI_RARELY_USED,  // 槮
	0x69EF, KANJI_RARELY_USED,  // 槯
	0x69F1, KANJI_RARELY_USED,  // 槱
	0x69F3, KANJI_RARELY_USED,  // 槳
	0x69F5, KANJI_RARELY_USED,  // 槵
	0x69FE, KANJI_RARELY_USED,  // 槾
	0x6A00, KANJI_RARELY_USED,  // 樀
	0x6A01, KANJI_RARELY_USED,  // 樁
	0x6A03, KANJI_RARELY_USED,  // 樃
	0x6A0F, KANJI_RARELY_USED,  // 樏
	0x6A11, KANJI_RARELY_USED,  // 樑
	0x6A15, KANJI_RARELY_USED,  // 樕
	0x6A1A, KANJI_RARELY_USED,  // 樚
	0x6A1D, KANJI_RARELY_USED,  // 樝
	0x6A20, KANJI_RARELY_USED,  // 樠
	0x6A24, KANJI_RARELY_USED,  // 樤
	0x6A28, KANJI_RARELY_USED,  // 樨
	0x6A30, KANJI_RARELY_USED,  // 樰
	0x6A32, KANJI_RARELY_USED,  // 樲
	0x6A34, KANJI_RARELY_USED,  // 樴
	0x6A37, KANJI_RARELY_USED,  // 樷
	0x6A3B, KANJI_RARELY_USED,  // 樻
	0x6A3E, KANJI_RARELY_USED,  // 樾
	0x6A3F, KANJI_RARELY_USED,  // 樿
	0x6A45, KANJI_RARELY_USED,  // 橅
	0x6A46, KANJI_RARELY_USED,  // 橆
	0x6A49, KANJI_RARELY_USED,  // 橉
	0x6A4A, KANJI_RARELY_USED,  // 橊
	0x6A4E, KANJI_RARELY_USED,  // 橎
	0x6A50, KANJI_RARELY_USED,  // 橐
	0x6A51, KANJI_RARELY_USED,  // 橑
	0x6A52, KANJI_RARELY_USED,  // 橒
	0x6A55, KANJI_RARELY_USED,  // 橕
	0x6A56, KANJI_RARELY_USED,  // 橖
	0x6A5B, KANJI_RARELY_USED,  // 橛
	0x6A64, KANJI_RARELY_USED,  // 橤
	0x6A67, KANJI_RARELY_USED,  // 橧
	0x6A6A, KANJI_RARELY_USED,  // 橪
	0x6A71, KANJI_RARELY_USED,  // 橱
	0x6A73, KANJI_RARELY_USED,  // 橳
	0x6A7E, KANJI_RARELY_USED,  // 橾
	0x6A81, KANJI_RARELY_USED,  // 檁
	0x6A83, KANJI_RARELY_USED,  // 檃
	0x6A86, KANJI_RARELY_USED,  // 檆
	0x6A87, KANJI_RARELY_USED,  // 檇
	0x6A89, KANJI_RARELY_USED,  // 檉
	0x6A8B, KANJI_RARELY_USED,  // 檋
	0x6A91, KANJI_RARELY_USED,  // 檑
	0x6A9B, KANJI_RARELY_USED,  // 檛
	0x6A9D, KANJI_RARELY_USED,  // 檝
	0x6A9E, KANJI_RARELY_USED,  // 檞
	0x6A9F, KANJI_RARELY_USED,  // 檟
	0x6AA5, KANJI_RARELY_USED,  // 檥
	0x6AAB, KANJI_RARELY_USED,  // 檫
	0x6AAF, KANJI_RARELY_USED,  // 檯
	0x6AB0, KANJI_RARELY_USED,  // 檰
	0x6AB1, KANJI_RARELY_USED,  // 檱
	0x6AB4, KANJI_RARELY_USED,  // 檴
	0x6ABD, KANJI_RARELY_USED,  // 檽
	0x6ABE, KANJI_RARELY_USED,  // 檾
	0x6ABF, KANJI_RARELY_USED,  // 檿
	0x6AC6, KANJI_RARELY_USED,  // 櫆
	0x6AC9, KANJI_RARELY_USED,  // 櫉
	0x6AC8, KANJI_RARELY_USED,  // 櫈
	0x6ACC, KANJI_RARELY_USED,  // 櫌
	0x6AD0, KANJI_RARELY_USED,  // 櫐
	0x6AD4, KANJI_RARELY_USED,  // 櫔
	0x6AD5, KANJI_RARELY_USED,  // 櫕
	0x6AD6, KANJI_RARELY_USED,  // 櫖
	0x6ADC, KANJI_RARELY_USED,  // 櫜
	0x6ADD, KANJI_RARELY_USED,  // 櫝
	0x6AE4, KANJI_RARELY_USED,  // 櫤
	0x6AE7, KANJI_RARELY_USED,  // 櫧
	0x6AEC, KANJI_RARELY_USED,  // 櫬
	0x6AF0, KANJI_RARELY_USED,  // 櫰
	0x6AF1, KANJI_RARELY_USED,  // 櫱
	0x6AF2, KANJI_RARELY_USED,  // 櫲
	0x6AFC, KANJI_RARELY_USED,  // 櫼
	0x6AFD, KANJI_RARELY_USED,  // 櫽
	0x6B02, KANJI_RARELY_USED,  // 欂
	0x6B03, KANJI_RARELY_USED,  // 欃
	0x6B06, KANJI_RARELY_USED,  // 欆
	0x6B07, KANJI_RARELY_USED,  // 欇
	0x6B09, KANJI_RARELY_USED,  // 欉
	0x6B0F, KANJI_RARELY_USED,  // 欏
	0x6B10, KANJI_RARELY_USED,  // 欐
	0x6B11, KANJI_RARELY_USED,  // 欑
	0x6B17, KANJI_RARELY_USED,  // 欗
	0x6B1B, KANJI_RARELY_USED,  // 欛
	0x6B1E, KANJI_RARELY_USED,  // 欞
	0x6B24, KANJI_RARELY_USED,  // 欤
	0x6B28, KANJI_RARELY_USED,  // 欨
	0x6B2B, KANJI_RARELY_USED,  // 欫
	0x6B2C, KANJI_RARELY_USED,  // 欬
	0x6B2F, KANJI_RARELY_USED,  // 欯
	0x6B35, KANJI_RARELY_USED,  // 欵
	0x6B36, KANJI_RARELY_USED,  // 欶
	0x6B3B, KANJI_RARELY_USED,  // 欻
	0x6B3F, KANJI_RARELY_USED,  // 欿
	0x6B46, KANJI_RARELY_USED,  // 歆
	0x6B4A, KANJI_RARELY_USED,  // 歊
	0x6B4D, KANJI_RARELY_USED,  // 歍
	0x6B52, KANJI_RARELY_USED,  // 歒
	0x6B56, KANJI_RARELY_USED,  // 歖
	0x6B58, KANJI_RARELY_USED,  // 歘
	0x6B5D, KANJI_RARELY_USED,  // 歝
	0x6B60, KANJI_RARELY_USED,  // 歠
	0x6B67, KANJI_RARELY_USED,  // 歧
	0x6B6B, KANJI_RARELY_USED,  // 歫
	0x6B6E, KANJI_RARELY_USED,  // 歮
	0x6B70, KANJI_RARELY_USED,  // 歰
	0x6B75, KANJI_RARELY_USED,  // 歵
	0x6B7D, KANJI_RARELY_USED,  // 歽
	0x6B7E, KANJI_RARELY_USED,  // 歾
	0x6B82, KANJI_RARELY_USED,  // 殂
	0x6B85, KANJI_RARELY_USED,  // 殅
	0x6B97, KANJI_RARELY_USED,  // 殗
	0x6B9B, KANJI_RARELY_USED,  // 殛
	0x6B9F, KANJI_RARELY_USED,  // 殟
	0x6BA0, KANJI_RARELY_USED,  // 殠
	0x6BA2, KANJI_RARELY_USED,  // 殢
	0x6BA3, KANJI_RARELY_USED,  // 殣
	0x6BA8, KANJI_RARELY_USED,  // 殨
	0x6BA9, KANJI_RARELY_USED,  // 殩
	0x6BAC, KANJI_RARELY_USED,  // 殬
	0x6BAD, KANJI_RARELY_USED,  // 殭
	0x6BAE, KANJI_RARELY_USED,  // 殮
	0x6BB0, KANJI_RARELY_USED,  // 殰
	0x6BB8, KANJI_RARELY_USED,  // 殸
	0x6BB9, KANJI_RARELY_USED,  // 殹
	0x6BBD, KANJI_RARELY_USED,  // 殽
	0x6BBE, KANJI_RARELY_USED,  // 殾
	0x6BC3, KANJI_RARELY_USED,  // 毃
	0x6BC4, KANJI_RARELY_USED,  // 毄
	0x6BC9, KANJI_RARELY_USED,  // 毉
	0x6BCC, KANJI_RARELY_USED,  // 毌
	0x6BD6, KANJI_RARELY_USED,  // 毖
	0x6BDA, KANJI_RARELY_USED,  // 毚
	0x6BE1, KANJI_RARELY_USED,  // 毡
	0x6BE3, KANJI_RARELY_USED,  // 毣
	0x6BE6, KANJI_RARELY_USED,  // 毦
	0x6BE7, KANJI_RARELY_USED,  // 毧
	0x6BEE, KANJI_RARELY_USED,  // 毮
	0x6BF1, KANJI_RARELY_USED,  // 毱
	0x6BF7, KANJI_RARELY_USED,  // 毷
	0x6BF9, KANJI_RARELY_USED,  // 毹
	0x6BFF, KANJI_RARELY_USED,  // 毿
	0x6C02, KANJI_RARELY_USED,  // 氂
	0x6C04, KANJI_RARELY_USED,  // 氄
	0x6C05, KANJI_RARELY_USED,  // 氅
	0x6C09, KANJI_RARELY_USED,  // 氉
	0x6C0D, KANJI_RARELY_USED,  // 氍
	0x6C0E, KANJI_RARELY_USED,  // 氎
	0x6C10, KANJI_RARELY_USED,  // 氐
	0x6C12, KANJI_RARELY_USED,  // 氒
	0x6C19, KANJI_RARELY_USED,  // 氙
	0x6C1F, KANJI_RARELY_USED,  // 氟
	0x6C26, KANJI_RARELY_USED,  // 氦
	0x6C27, KANJI_RARELY_USED,  // 氧
	0x6C28, KANJI_RARELY_USED,  // 氨
	0x6C2C, KANJI_RARELY_USED,  // 氬
	0x6C2E, KANJI_RARELY_USED,  // 氮
	0x6C33, KANJI_RARELY_USED,  // 氳
	0x6C35, KANJI_RARELY_USED,  // 氵
	0x6C36, KANJI_RARELY_USED,  // 氶
	0x6C3A, KANJI_RARELY_USED,  // 氺
	0x6C3B, KANJI_RARELY_USED,  // 氻
	0x6C3F, KANJI_RARELY_USED,  // 氿
	0x6C4A, KANJI_RARELY_USED,  // 汊
	0x6C4B, KANJI_RARELY_USED,  // 汋
	0x6C4D, KANJI_RARELY_USED,  // 汍
	0x6C4F, KANJI_RARELY_USED,  // 汏
	0x6C52, KANJI_RARELY_USED,  // 汒
	0x6C54, KANJI_RARELY_USED,  // 汔
	0x6C59, KANJI_RARELY_USED,  // 汙
	0x6C5B, KANJI_RARELY_USED,  // 汛
	0x6C5C, KANJI_RARELY_USED,  // 汜
	0x6C6B, KANJI_RARELY_USED,  // 汫
	0x6C6D, KANJI_RARELY_USED,  // 汭
	0x6C6F, KANJI_RARELY_USED,  // 汯
	0x6C74, KANJI_RARELY_USED,  // 汴
	0x6C76, KANJI_RARELY_USED,  // 汶
	0x6C78, KANJI_RARELY_USED,  // 汸
	0x6C79, KANJI_RARELY_USED,  // 汹
	0x6C7B, KANJI_RARELY_USED,  // 汻
	0x6C85, KANJI_RARELY_USED,  // 沅
	0x6C86, KANJI_RARELY_USED,  // 沆
	0x6C87, KANJI_RARELY_USED,  // 沇
	0x6C89, KANJI_RARELY_USED,  // 沉
	0x6C94, KANJI_RARELY_USED,  // 沔
	0x6C95, KANJI_RARELY_USED,  // 沕
	0x6C97, KANJI_RARELY_USED,  // 沗
	0x6C98, KANJI_RARELY_USED,  // 沘
	0x6C9C, KANJI_RARELY_USED,  // 沜
	0x6C9F, KANJI_RARELY_USED,  // 沟
	0x6CB0, KANJI_RARELY_USED,  // 沰
	0x6CB2, KANJI_RARELY_USED,  // 沲
	0x6CB4, KANJI_RARELY_USED,  // 沴
	0x6CC2, KANJI_RARELY_USED,  // 泂
	0x6CC6, KANJI_RARELY_USED,  // 泆
	0x6CCD, KANJI_RARELY_USED,  // 泍
	0x6CCF, KANJI_RARELY_USED,  // 泏
	0x6CD0, KANJI_RARELY_USED,  // 泐
	0x6CD1, KANJI_RARELY_USED,  // 泑
	0x6CD2, KANJI_RARELY_USED,  // 泒
	0x6CD4, KANJI_RARELY_USED,  // 泔
	0x6CD6, KANJI_RARELY_USED,  // 泖
	0x6CDA, KANJI_RARELY_USED,  // 泚
	0x6CDC, KANJI_RARELY_USED,  // 泜
	0x6CE0, KANJI_RARELY_USED,  // 泠
	0x6CE7, KANJI_RARELY_USED,  // 泧
	0x6CE9, KANJI_RARELY_USED,  // 泩
	0x6CEB, KANJI_RARELY_USED,  // 泫
	0x6CEC, KANJI_RARELY_USED,  // 泬
	0x6CEE, KANJI_RARELY_USED,  // 泮
	0x6CF2, KANJI_RARELY_USED,  // 泲
	0x6CF4, KANJI_RARELY_USED,  // 泴
	0x6D04, KANJI_RARELY_USED,  // 洄
	0x6D07, KANJI_RARELY_USED,  // 洇
	0x6D0A, KANJI_RARELY_USED,  // 洊
	0x6D0E, KANJI_RARELY_USED,  // 洎
	0x6D0F, KANJI_RARELY_USED,  // 洏
	0x6D11, KANJI_RARELY_USED,  // 洑
	0x6D13, KANJI_RARELY_USED,  // 洓
	0x6D1A, KANJI_RARELY_USED,  // 洚
	0x6D26, KANJI_RARELY_USED,  // 洦
	0x6D27, KANJI_RARELY_USED,  // 洧
	0x6D28, KANJI_RARELY_USED,  // 洨
	0x6C67, KANJI_RARELY_USED,  // 汧
	0x6D2E, KANJI_RARELY_USED,  // 洮
	0x6D2F, KANJI_RARELY_USED,  // 洯
	0x6D31, KANJI_RARELY_USED,  // 洱
	0x6D39, KANJI_RARELY_USED,  // 洹
	0x6D3C, KANJI_RARELY_USED,  // 洼
	0x6D3F, KANJI_RARELY_USED,  // 洿
	0x6D57, KANJI_RARELY_USED,  // 浗
	0x6D5E, KANJI_RARELY_USED,  // 浞
	0x6D5F, KANJI_RARELY_USED,  // 浟
	0x6D61, KANJI_RARELY_USED,  // 浡
	0x6D65, KANJI_RARELY_USED,  // 浥
	0x6D67, KANJI_RARELY_USED,  // 浧
	0x6D6F, KANJI_RARELY_USED,  // 浯
	0x6D70, KANJI_RARELY_USED,  // 浰
	0x6D7C, KANJI_RARELY_USED,  // 浼
	0x6D82, KANJI_RARELY_USED,  // 涂
	0x6D87, KANJI_RARELY_USED,  // 涇
	0x6D91, KANJI_RARELY_USED,  // 涑
	0x6D92, KANJI_RARELY_USED,  // 涒
	0x6D94, KANJI_RARELY_USED,  // 涔
	0x6D96, KANJI_RARELY_USED,  // 涖
	0x6D97, KANJI_RARELY_USED,  // 涗
	0x6D98, KANJI_RARELY_USED,  // 涘
	0x6DAA, KANJI_RARELY_USED,  // 涪
	0x6DAC, KANJI_RARELY_USED,  // 涬
	0x6DB4, KANJI_RARELY_USED,  // 涴
	0x6DB7, KANJI_RARELY_USED,  // 涷
	0x6DB9, KANJI_RARELY_USED,  // 涹
	0x6DBD, KANJI_RARELY_USED,  // 涽
	0x6DBF, KANJI_RARELY_USED,  // 涿
	0x6DC4, KANJI_RARELY_USED,  // 淄
	0x6DC8, KANJI_RARELY_USED,  // 淈
	0x6DCA, KANJI_RARELY_USED,  // 淊
	0x6DCE, KANJI_RARELY_USED,  // 淎
	0x6DCF, KANJI_RARELY_USED,  // 淏
	0x6DD6, KANJI_RARELY_USED,  // 淖
	0x6DDB, KANJI_RARELY_USED,  // 淛
	0x6DDD, KANJI_RARELY_USED,  // 淝
	0x6DDF, KANJI_RARELY_USED,  // 淟
	0x6DE0, KANJI_RARELY_USED,  // 淠
	0x6DE2, KANJI_RARELY_USED,  // 淢
	0x6DE5, KANJI_RARELY_USED,  // 淥
	0x6DE9, KANJI_RARELY_USED,  // 淩
	0x6DEF, KANJI_RARELY_USED,  // 淯
	0x6DF0, KANJI_RARELY_USED,  // 淰
	0x6DF4, KANJI_RARELY_USED,  // 淴
	0x6DF6, KANJI_RARELY_USED,  // 淶
	0x6DFC, KANJI_RARELY_USED,  // 淼
	0x6E00, KANJI_RARELY_USED,  // 渀
	0x6E04, KANJI_RARELY_USED,  // 渄
	0x6E1E, KANJI_RARELY_USED,  // 渞
	0x6E22, KANJI_RARELY_USED,  // 渢
	0x6E27, KANJI_RARELY_USED,  // 渧
	0x6E32, KANJI_RARELY_USED,  // 渲
	0x6E36, KANJI_RARELY_USED,  // 渶
	0x6E39, KANJI_RARELY_USED,  // 渹
	0x6E3B, KANJI_RARELY_USED,  // 渻
	0x6E3C, KANJI_RARELY_USED,  // 渼
	0x6E44, KANJI_RARELY_USED,  // 湄
	0x6E45, KANJI_RARELY_USED,  // 湅
	0x6E48, KANJI_RARELY_USED,  // 湈
	0x6E49, KANJI_RARELY_USED,  // 湉
	0x6E4B, KANJI_RARELY_USED,  // 湋
	0x6E4F, KANJI_RARELY_USED,  // 湏
	0x6E51, KANJI_RARELY_USED,  // 湑
	0x6E52, KANJI_RARELY_USED,  // 湒
	0x6E53, KANJI_RARELY_USED,  // 湓
	0x6E54, KANJI_RARELY_USED,  // 湔
	0x6E57, KANJI_RARELY_USED,  // 湗
	0x6E5C, KANJI_RARELY_USED,  // 湜
	0x6E5D, KANJI_RARELY_USED,  // 湝
	0x6E5E, KANJI_RARELY_USED,  // 湞
	0x6E62, KANJI_RARELY_USED,  // 湢
	0x6E63, KANJI_RARELY_USED,  // 湣
	0x6E68, KANJI_RARELY_USED,  // 湨
	0x6E73, KANJI_RARELY_USED,  // 湳
	0x6E7B, KANJI_RARELY_USED,  // 湻
	0x6E7D, KANJI_RARELY_USED,  // 湽
	0x6E8D, KANJI_RARELY_USED,  // 溍
	0x6E93, KANJI_RARELY_USED,  // 溓
	0x6E99, KANJI_RARELY_USED,  // 溙
	0x6EA0, KANJI_RARELY_USED,  // 溠
	0x6EA7, KANJI_RARELY_USED,  // 溧
	0x6EAD, KANJI_RARELY_USED,  // 溭
	0x6EAE, KANJI_RARELY_USED,  // 溮
	0x6EB1, KANJI_RARELY_USED,  // 溱
	0x6EB3, KANJI_RARELY_USED,  // 溳
	0x6EBB, KANJI_RARELY_USED,  // 溻
	0x6EBF, KANJI_RARELY_USED,  // 溿
	0x6EC0, KANJI_RARELY_USED,  // 滀
	0x6EC1, KANJI_RARELY_USED,  // 滁
	0x6EC3, KANJI_RARELY_USED,  // 滃
	0x6EC7, KANJI_RARELY_USED,  // 滇
	0x6EC8, KANJI_RARELY_USED,  // 滈
	0x6ECA, KANJI_RARELY_USED,  // 滊
	0x6ECD, KANJI_RARELY_USED,  // 滍
	0x6ECE, KANJI_RARELY_USED,  // 滎
	0x6ECF, KANJI_RARELY_USED,  // 滏
	0x6EEB, KANJI_RARELY_USED,  // 滫
	0x6EED, KANJI_RARELY_USED,  // 滭
	0x6EEE, KANJI_RARELY_USED,  // 滮
	0x6EF9, KANJI_RARELY_USED,  // 滹
	0x6EFB, KANJI_RARELY_USED,  // 滻
	0x6EFD, KANJI_RARELY_USED,  // 滽
	0x6F04, KANJI_RARELY_USED,  // 漄
	0x6F08, KANJI_RARELY_USED,  // 漈
	0x6F0A, KANJI_RARELY_USED,  // 漊
	0x6F0C, KANJI_RARELY_USED,  // 漌
	0x6F0D, KANJI_RARELY_USED,  // 漍
	0x6F16, KANJI_RARELY_USED,  // 漖
	0x6F18, KANJI_RARELY_USED,  // 漘
	0x6F1A, KANJI_RARELY_USED,  // 漚
	0x6F1B, KANJI_RARELY_USED,  // 漛
	0x6F26, KANJI_RARELY_USED,  // 漦
	0x6F29, KANJI_RARELY_USED,  // 漩
	0x6F2A, KANJI_RARELY_USED,  // 漪
	0x6F2F, KANJI_RARELY_USED,  // 漯
	0x6F30, KANJI_RARELY_USED,  // 漰
	0x6F33, KANJI_RARELY_USED,  // 漳
	0x6F36, KANJI_RARELY_USED,  // 漶
	0x6F3B, KANJI_RARELY_USED,  // 漻
	0x6F3C, KANJI_RARELY_USED,  // 漼
	0x6F2D, KANJI_RARELY_USED,  // 漭
	0x6F4F, KANJI_RARELY_USED,  // 潏
	0x6F51, KANJI_RARELY_USED,  // 潑
	0x6F52, KANJI_RARELY_USED,  // 潒
	0x6F53, KANJI_RARELY_USED,  // 潓
	0x6F57, KANJI_RARELY_USED,  // 潗
	0x6F59, KANJI_RARELY_USED,  // 潙
	0x6F5A, KANJI_RARELY_USED,  // 潚
	0x6F5D, KANJI_RARELY_USED,  // 潝
	0x6F5E, KANJI_RARELY_USED,  // 潞
	0x6F61, KANJI_RARELY_USED,  // 潡
	0x6F62, KANJI_RARELY_USED,  // 潢
	0x6F68, KANJI_RARELY_USED,  // 潨
	0x6F6C, KANJI_RARELY_USED,  // 潬
	0x6F7D, KANJI_RARELY_USED,  // 潽
	0x6F7E, KANJI_RARELY_USED,  // 潾
	0x6F83, KANJI_RARELY_USED,  // 澃
	0x6F87, KANJI_RARELY_USED,  // 澇
	0x6F88, KANJI_RARELY_USED,  // 澈
	0x6F8B, KANJI_RARELY_USED,  // 澋
	0x6F8C, KANJI_RARELY_USED,  // 澌
	0x6F8D, KANJI_RARELY_USED,  // 澍
	0x6F90, KANJI_RARELY_USED,  // 澐
	0x6F92, KANJI_RARELY_USED,  // 澒
	0x6F93, KANJI_RARELY_USED,  // 澓
	0x6F94, KANJI_RARELY_USED,  // 澔
	0x6F96, KANJI_RARELY_USED,  // 澖
	0x6F9A, KANJI_RARELY_USED,  // 澚
	0x6F9F, KANJI_RARELY_USED,  // 澟
	0x6FA0, KANJI_RARELY_USED,  // 澠
	0x6FA5, KANJI_RARELY_USED,  // 澥
	0x6FA6, KANJI_RARELY_USED,  // 澦
	0x6FA7, KANJI_RARELY_USED,  // 澧
	0x6FA8, KANJI_RARELY_USED,  // 澨
	0x6FAE, KANJI_RARELY_USED,  // 澮
	0x6FAF, KANJI_RARELY_USED,  // 澯
	0x6FB0, KANJI_RARELY_USED,  // 澰
	0x6FB5, KANJI_RARELY_USED,  // 澵
	0x6FB6, KANJI_RARELY_USED,  // 澶
	0x6FBC, KANJI_RARELY_USED,  // 澼
	0x6FC5, KANJI_RARELY_USED,  // 濅
	0x6FC7, KANJI_RARELY_USED,  // 濇
	0x6FC8, KANJI_RARELY_USED,  // 濈
	0x6FCA, KANJI_RARELY_USED,  // 濊
	0x6FDA, KANJI_RARELY_USED,  // 濚
	0x6FDE, KANJI_RARELY_USED,  // 濞
	0x6FE8, KANJI_RARELY_USED,  // 濨
	0x6FE9, KANJI_RARELY_USED,  // 濩
	0x6FF0, KANJI_RARELY_USED,  // 濰
	0x6FF5, KANJI_RARELY_USED,  // 濵
	0x6FF9, KANJI_RARELY_USED,  // 濹
	0x6FFC, KANJI_RARELY_USED,  // 濼
	0x6FFD, KANJI_RARELY_USED,  // 濽
	0x7000, KANJI_RARELY_USED,  // 瀀
	0x7005, KANJI_RARELY_USED,  // 瀅
	0x7006, KANJI_RARELY_USED,  // 瀆
	0x7007, KANJI_RARELY_USED,  // 瀇
	0x700D, KANJI_RARELY_USED,  // 瀍
	0x7017, KANJI_RARELY_USED,  // 瀗
	0x7020, KANJI_RARELY_USED,  // 瀠
	0x7023, KANJI_RARELY_USED,  // 瀣
	0x702F, KANJI_RARELY_USED,  // 瀯
	0x7034, KANJI_RARELY_USED,  // 瀴
	0x7037, KANJI_RARELY_USED,  // 瀷
	0x7039, KANJI_RARELY_USED,  // 瀹
	0x703C, KANJI_RARELY_USED,  // 瀼
	0x7043, KANJI_RARELY_USED,  // 灃
	0x7044, KANJI_RARELY_USED,  // 灄
	0x7048, KANJI_RARELY_USED,  // 灈
	0x7049, KANJI_RARELY_USED,  // 灉
	0x704A, KANJI_RARELY_USED,  // 灊
	0x704B, KANJI_RARELY_USED,  // 灋
	0x7054, KANJI_RARELY_USED,  // 灔
	0x7055, KANJI_RARELY_USED,  // 灕
	0x705D, KANJI_RARELY_USED,  // 灝
	0x705E, KANJI_RARELY_USED,  // 灞
	0x704E, KANJI_RARELY_USED,  // 灎
	0x7064, KANJI_RARELY_USED,  // 灤
	0x7065, KANJI_RARELY_USED,  // 灥
	0x706C, KANJI_RARELY_USED,  // 灬
	0x706E, KANJI_RARELY_USED,  // 灮
	0x7075, KANJI_RARELY_USED,  // 灵
	0x7076, KANJI_RARELY_USED,  // 灶
	0x707E, KANJI_RARELY_USED,  // 灾
	0x7081, KANJI_RARELY_USED,  // 炁
	0x7085, KANJI_RARELY_USED,  // 炅
	0x7086, KANJI_RARELY_USED,  // 炆
	0x7094, KANJI_RARELY_USED,  // 炔
	0x7095, KANJI_RARELY_USED,  // 炕
	0x7096, KANJI_RARELY_USED,  // 炖
	0x7097, KANJI_RARELY_USED,  // 炗
	0x7098, KANJI_RARELY_USED,  // 炘
	0x709B, KANJI_RARELY_USED,  // 炛
	0x70A4, KANJI_RARELY_USED,  // 炤
	0x70AB, KANJI_RARELY_USED,  // 炫
	0x70B0, KANJI_RARELY_USED,  // 炰
	0x70B1, KANJI_RARELY_USED,  // 炱
	0x70B4, KANJI_RARELY_USED,  // 炴
	0x70B7, KANJI_RARELY_USED,  // 炷
	0x70CA, KANJI_RARELY_USED,  // 烊
	0x70D1, KANJI_RARELY_USED,  // 烑
	0x70D3, KANJI_RARELY_USED,  // 烓
	0x70D4, KANJI_RARELY_USED,  // 烔
	0x70D5, KANJI_RARELY_USED,  // 烕
	0x70D6, KANJI_RARELY_USED,  // 烖
	0x70D8, KANJI_RARELY_USED,  // 烘
	0x70DC, KANJI_RARELY_USED,  // 烜
	0x70E4, KANJI_RARELY_USED,  // 烤
	0x70FA, KANJI_RARELY_USED,  // 烺
	0x7103, KANJI_RARELY_USED,  // 焃
	0x7104, KANJI_RARELY_USED,  // 焄
	0x7105, KANJI_RARELY_USED,  // 焅
	0x7106, KANJI_RARELY_USED,  // 焆
	0x7107, KANJI_RARELY_USED,  // 焇
	0x710B, KANJI_RARELY_USED,  // 焋
	0x710C, KANJI_RARELY_USED,  // 焌
	0x710F, KANJI_RARELY_USED,  // 焏
	0x711E, KANJI_RARELY_USED,  // 焞
	0x7120, KANJI_RARELY_USED,  // 焠
	0x712B, KANJI_RARELY_USED,  // 焫
	0x712D, KANJI_RARELY_USED,  // 焭
	0x712F, KANJI_RARELY_USED,  // 焯
	0x7130, KANJI_RARELY_USED,  // 焰
	0x7131, KANJI_RARELY_USED,  // 焱
	0x7138, KANJI_RARELY_USED,  // 焸
	0x7141, KANJI_RARELY_USED,  // 煁
	0x7145, KANJI_RARELY_USED,  // 煅
	0x7146, KANJI_RARELY_USED,  // 煆
	0x7147, KANJI_RARELY_USED,  // 煇
	0x714A, KANJI_RARELY_USED,  // 煊
	0x714B, KANJI_RARELY_USED,  // 煋
	0x7150, KANJI_RARELY_USED,  // 煐
	0x7152, KANJI_RARELY_USED,  // 煒
	0x7157, KANJI_RARELY_USED,  // 煗
	0x715A, KANJI_RARELY_USED,  // 煚
	0x715C, KANJI_RARELY_USED,  // 煜
	0x715E, KANJI_RARELY_USED,  // 煞
	0x7160, KANJI_RARELY_USED,  // 煠
	0x7168, KANJI_RARELY_USED,  // 煨
	0x7179, KANJI_RARELY_USED,  // 煹
	0x7180, KANJI_RARELY_USED,  // 熀
	0x7185, KANJI_RARELY_USED,  // 熅
	0x7187, KANJI_RARELY_USED,  // 熇
	0x718C, KANJI_RARELY_USED,  // 熌
	0x7192, KANJI_RARELY_USED,  // 熒
	0x719A, KANJI_RARELY_USED,  // 熚
	0x719B, KANJI_RARELY_USED,  // 熛
	0x71A0, KANJI_RARELY_USED,  // 熠
	0x71A2, KANJI_RARELY_USED,  // 熢
	0x71AF, KANJI_RARELY_USED,  // 熯
	0x71B0, KANJI_RARELY_USED,  // 熰
	0x71B2, KANJI_RARELY_USED,  // 熲
	0x71B3, KANJI_RARELY_USED,  // 熳
	0x71BA, KANJI_RARELY_USED,  // 熺
	0x71BF, KANJI_RARELY_USED,  // 熿
	0x71C0, KANJI_RARELY_USED,  // 燀
	0x71C1, KANJI_RARELY_USED,  // 燁
	0x71C4, KANJI_RARELY_USED,  // 燄
	0x71CB, KANJI_RARELY_USED,  // 燋
	0x71CC, KANJI_RARELY_USED,  // 燌
	0x71D3, KANJI_RARELY_USED,  // 燓
	0x71D6, KANJI_RARELY_USED,  // 燖
	0x71D9, KANJI_RARELY_USED,  // 燙
	0x71DA, KANJI_RARELY_USED,  // 燚
	0x71DC, KANJI_RARELY_USED,  // 燜
	0x71F8, KANJI_RARELY_USED,  // 燸
	0x71FE, KANJI_RARELY_USED,  // 燾
	0x7200, KANJI_RARELY_USED,  // 爀
	0x7207, KANJI_RARELY_USED,  // 爇
	0x7208, KANJI_RARELY_USED,  // 爈
	0x7209, KANJI_RARELY_USED,  // 爉
	0x7213, KANJI_RARELY_USED,  // 爓
	0x7217, KANJI_RARELY_USED,  // 爗
	0x721A, KANJI_RARELY_USED,  // 爚
	0x721D, KANJI_RARELY_USED,  // 爝
	0x721F, KANJI_RARELY_USED,  // 爟
	0x7224, KANJI_RARELY_USED,  // 爤
	0x722B, KANJI_RARELY_USED,  // 爫
	0x722F, KANJI_RARELY_USED,  // 爯
	0x7234, KANJI_RARELY_USED,  // 爴
	0x7238, KANJI_RARELY_USED,  // 爸
	0x7239, KANJI_RARELY_USED,  // 爹
	0x7241, KANJI_RARELY_USED,  // 牁
	0x7242, KANJI_RARELY_USED,  // 牂
	0x7243, KANJI_RARELY_USED,  // 牃
	0x7245, KANJI_RARELY_USED,  // 牅
	0x724E, KANJI_RARELY_USED,  // 牎
	0x724F, KANJI_RARELY_USED,  // 牏
	0x7250, KANJI_RARELY_USED,  // 牐
	0x7253, KANJI_RARELY_USED,  // 牓
	0x7255, KANJI_RARELY_USED,  // 牕
	0x7256, KANJI_RARELY_USED,  // 牖
	0x725A, KANJI_RARELY_USED,  // 牚
	0x725C, KANJI_RARELY_USED,  // 牜
	0x725E, KANJI_RARELY_USED,  // 牞
	0x7260, KANJI_RARELY_USED,  // 牠
	0x7263, KANJI_RARELY_USED,  // 牣
	0x7268, KANJI_RARELY_USED,  // 牨
	0x726B, KANJI_RARELY_USED,  // 牫
	0x726E, KANJI_RARELY_USED,  // 牮
	0x726F, KANJI_RARELY_USED,  // 牯
	0x7271, KANJI_RARELY_USED,  // 牱
	0x7277, KANJI_RARELY_USED,  // 牷
	0x7278, KANJI_RARELY_USED,  // 牸
	0x727B, KANJI_RARELY_USED,  // 牻
	0x727C, KANJI_RARELY_USED,  // 牼
	0x727F, KANJI_RARELY_USED,  // 牿
	0x7284, KANJI_RARELY_USED,  // 犄
	0x7289, KANJI_RARELY_USED,  // 犉
	0x728D, KANJI_RARELY_USED,  // 犍
	0x728E, KANJI_RARELY_USED,  // 犎
	0x7293, KANJI_RARELY_USED,  // 犓
	0x729B, KANJI_RARELY_USED,  // 犛
	0x72A8, KANJI_RARELY_USED,  // 犨
	0x72AD, KANJI_RARELY_USED,  // 犭
	0x72AE, KANJI_RARELY_USED,  // 犮
	0x72B1, KANJI_RARELY_USED,  // 犱
	0x72B4, KANJI_RARELY_USED,  // 犴
	0x72BE, KANJI_RARELY_USED,  // 犾
	0x72C1, KANJI_RARELY_USED,  // 狁
	0x72C7, KANJI_RARELY_USED,  // 狇
	0x72C9, KANJI_RARELY_USED,  // 狉
	0x72CC, KANJI_RARELY_USED,  // 狌
	0x72D5, KANJI_RARELY_USED,  // 狕
	0x72D6, KANJI_RARELY_USED,  // 狖
	0x72D8, KANJI_RARELY_USED,  // 狘
	0x72DF, KANJI_RARELY_USED,  // 狟
	0x72E5, KANJI_RARELY_USED,  // 狥
	0x72F3, KANJI_RARELY_USED,  // 狳
	0x72F4, KANJI_RARELY_USED,  // 狴
	0x72FA, KANJI_RARELY_USED,  // 狺
	0x72FB, KANJI_RARELY_USED,  // 狻
	0x72FE, KANJI_RARELY_USED,  // 狾
	0x7302, KANJI_RARELY_USED,  // 猂
	0x7304, KANJI_RARELY_USED,  // 猄
	0x7305, KANJI_RARELY_USED,  // 猅
	0x7307, KANJI_RARELY_USED,  // 猇
	0x730B, KANJI_RARELY_USED,  // 猋
	0x730D, KANJI_RARELY_USED,  // 猍
	0x7312, KANJI_RARELY_USED,  // 猒
	0x7313, KANJI_RARELY_USED,  // 猓
	0x7318, KANJI_RARELY_USED,  // 猘
	0x7319, KANJI_RARELY_USED,  // 猙
	0x731E, KANJI_RARELY_USED,  // 猞
	0x7322, KANJI_RARELY_USED,  // 猢
	0x7324, KANJI_RARELY_USED,  // 猤
	0x7327, KANJI_RARELY_USED,  // 猧
	0x7328, KANJI_RARELY_USED,  // 猨
	0x732C, KANJI_RARELY_USED,  // 猬
	0x7331, KANJI_RARELY_USED,  // 猱
	0x7332, KANJI_RARELY_USED,  // 猲
	0x7335, KANJI_RARELY_USED,  // 猵
	0x733A, KANJI_RARELY_USED,  // 猺
	0x733B, KANJI_RARELY_USED,  // 猻
	0x733D, KANJI_RARELY_USED,  // 猽
	0x7343, KANJI_RARELY_USED,  // 獃
	0x734D, KANJI_RARELY_USED,  // 獍
	0x7350, KANJI_RARELY_USED,  // 獐
	0x7352, KANJI_RARELY_USED,  // 獒
	0x7356, KANJI_RARELY_USED,  // 獖
	0x7358, KANJI_RARELY_USED,  // 獘
	0x735D, KANJI_RARELY_USED,  // 獝
	0x735E, KANJI_RARELY_USED,  // 獞
	0x735F, KANJI_RARELY_USED,  // 獟
	0x7360, KANJI_RARELY_USED,  // 獠
	0x7366, KANJI_RARELY_USED,  // 獦
	0x7367, KANJI_RARELY_USED,  // 獧
	0x7369, KANJI_RARELY_USED,  // 獩
	0x736B, KANJI_RARELY_USED,  // 獫
	0x736C, KANJI_RARELY_USED,  // 獬
	0x736E, KANJI_RARELY_USED,  // 獮
	0x736F, KANJI_RARELY_USED,  // 獯
	0x7371, KANJI_RARELY_USED,  // 獱
	0x7377, KANJI_RARELY_USED,  // 獷
	0x7379, KANJI_RARELY_USED,  // 獹
	0x737C, KANJI_RARELY_USED,  // 獼
	0x7380, KANJI_RARELY_USED,  // 玀
	0x7381, KANJI_RARELY_USED,  // 玁
	0x7383, KANJI_RARELY_USED,  // 玃
	0x7385, KANJI_RARELY_USED,  // 玅
	0x7386, KANJI_RARELY_USED,  // 玆
	0x738E, KANJI_RARELY_USED,  // 玎
	0x7390, KANJI_RARELY_USED,  // 玐
	0x7393, KANJI_RARELY_USED,  // 玓
	0x7395, KANJI_RARELY_USED,  // 玕
	0x7397, KANJI_RARELY_USED,  // 玗
	0x7398, KANJI_RARELY_USED,  // 玘
	0x739C, KANJI_RARELY_USED,  // 玜
	0x739E, KANJI_RARELY_USED,  // 玞
	0x739F, KANJI_RARELY_USED,  // 玟
	0x73A0, KANJI_RARELY_USED,  // 玠
	0x73A2, KANJI_RARELY_USED,  // 玢
	0x73A5, KANJI_RARELY_USED,  // 玥
	0x73A6, KANJI_RARELY_USED,  // 玦
	0x73AA, KANJI_RARELY_USED,  // 玪
	0x73AB, KANJI_RARELY_USED,  // 玫
	0x73AD, KANJI_RARELY_USED,  // 玭
	0x73B5, KANJI_RARELY_USED,  // 玵
	0x73B7, KANJI_RARELY_USED,  // 玷
	0x73B9, KANJI_RARELY_USED,  // 玹
	0x73BC, KANJI_RARELY_USED,  // 玼
	0x73BD, KANJI_RARELY_USED,  // 玽
	0x73BF, KANJI_RARELY_USED,  // 玿
	0x73C5, KANJI_RARELY_USED,  // 珅
	0x73C6, KANJI_RARELY_USED,  // 珆
	0x73C9, KANJI_RARELY_USED,  // 珉
	0x73CB, KANJI_RARELY_USED,  // 珋
	0x73CC, KANJI_RARELY_USED,  // 珌
	0x73CF, KANJI_RARELY_USED,  // 珏
	0x73D2, KANJI_RARELY_USED,  // 珒
	0x73D3, KANJI_RARELY_USED,  // 珓
	0x73D6, KANJI_RARELY_USED,  // 珖
	0x73D9, KANJI_RARELY_USED,  // 珙
	0x73DD, KANJI_RARELY_USED,  // 珝
	0x73E1, KANJI_RARELY_USED,  // 珡
	0x73E3, KANJI_RARELY_USED,  // 珣
	0x73E6, KANJI_RARELY_USED,  // 珦
	0x73E7, KANJI_RARELY_USED,  // 珧
	0x73E9, KANJI_RARELY_USED,  // 珩
	0x73F4, KANJI_RARELY_USED,  // 珴
	0x73F5, KANJI_RARELY_USED,  // 珵
	0x73F7, KANJI_RARELY_USED,  // 珷
	0x73F9, KANJI_RARELY_USED,  // 珹
	0x73FA, KANJI_RARELY_USED,  // 珺
	0x73FB, KANJI_RARELY_USED,  // 珻
	0x73FD, KANJI_RARELY_USED,  // 珽
	0x73FF, KANJI_RARELY_USED,  // 珿
	0x7400, KANJI_RARELY_USED,  // 琀
	0x7401, KANJI_RARELY_USED,  // 琁
	0x7404, KANJI_RARELY_USED,  // 琄
	0x7407, KANJI_RARELY_USED,  // 琇
	0x740A, KANJI_RARELY_USED,  // 琊
	0x7411, KANJI_RARELY_USED,  // 琑
	0x741A, KANJI_RARELY_USED,  // 琚
	0x741B, KANJI_RARELY_USED,  // 琛
	0x7424, KANJI_RARELY_USED,  // 琤
	0x7426, KANJI_RARELY_USED,  // 琦
	0x7428, KANJI_RARELY_USED,  // 琨
	0x7429, KANJI_RARELY_USED,  // 琩
	0x742A, KANJI_RARELY_USED,  // 琪
	0x742B, KANJI_RARELY_USED,  // 琫
	0x742C, KANJI_RARELY_USED,  // 琬
	0x742D, KANJI_RARELY_USED,  // 琭
	0x742E, KANJI_RARELY_USED,  // 琮
	0x742F, KANJI_RARELY_USED,  // 琯
	0x7430, KANJI_RARELY_USED,  // 琰
	0x7431, KANJI_RARELY_USED,  // 琱
	0x7439, KANJI_RARELY_USED,  // 琹
	0x7440, KANJI_RARELY_USED,  // 瑀
	0x7443, KANJI_RARELY_USED,  // 瑃
	0x7444, KANJI_RARELY_USED,  // 瑄
	0x7446, KANJI_RARELY_USED,  // 瑆
	0x7447, KANJI_RARELY_USED,  // 瑇
	0x744B, KANJI_RARELY_USED,  // 瑋
	0x744D, KANJI_RARELY_USED,  // 瑍
	0x7451, KANJI_RARELY_USED,  // 瑑
	0x7452, KANJI_RARELY_USED,  // 瑒
	0x7457, KANJI_RARELY_USED,  // 瑗
	0x745D, KANJI_RARELY_USED,  // 瑝
	0x7462, KANJI_RARELY_USED,  // 瑢
	0x7466, KANJI_RARELY_USED,  // 瑦
	0x7467, KANJI_RARELY_USED,  // 瑧
	0x7468, KANJI_RARELY_USED,  // 瑨
	0x746B, KANJI_RARELY_USED,  // 瑫
	0x746D, KANJI_RARELY_USED,  // 瑭
	0x746E, KANJI_RARELY_USED,  // 瑮
	0x7471, KANJI_RARELY_USED,  // 瑱
	0x7472, KANJI_RARELY_USED,  // 瑲
	0x7480, KANJI_RARELY_USED,  // 璀
	0x7481, KANJI_RARELY_USED,  // 璁
	0x7485, KANJI_RARELY_USED,  // 璅
	0x7486, KANJI_RARELY_USED,  // 璆
	0x7487, KANJI_RARELY_USED,  // 璇
	0x7489, KANJI_RARELY_USED,  // 璉
	0x748F, KANJI_RARELY_USED,  // 璏
	0x7490, KANJI_RARELY_USED,  // 璐
	0x7491, KANJI_RARELY_USED,  // 璑
	0x7492, KANJI_RARELY_USED,  // 璒
	0x7498, KANJI_RARELY_USED,  // 璘
	0x7499, KANJI_RARELY_USED,  // 璙
	0x749A, KANJI_RARELY_USED,  // 璚
	0x749C, KANJI_RARELY_USED,  // 璜
	0x749F, KANJI_RARELY_USED,  // 璟
	0x74A0, KANJI_RARELY_USED,  // 璠
	0x74A1, KANJI_RARELY_USED,  // 璡
	0x74A3, KANJI_RARELY_USED,  // 璣
	0x74A6, KANJI_RARELY_USED,  // 璦
	0x74A8, KANJI_RARELY_USED,  // 璨
	0x74A9, KANJI_RARELY_USED,  // 璩
	0x74AA, KANJI_RARELY_USED,  // 璪
	0x74AB, KANJI_RARELY_USED,  // 璫
	0x74AE, KANJI_RARELY_USED,  // 璮
	0x74AF, KANJI_RARELY_USED,  // 璯
	0x74B1, KANJI_RARELY_USED,  // 璱
	0x74B2, KANJI_RARELY_USED,  // 璲
	0x74B5, KANJI_RARELY_USED,  // 璵
	0x74B9, KANJI_RARELY_USED,  // 璹
	0x74BB, KANJI_RARELY_USED,  // 璻
	0x74BF, KANJI_RARELY_USED,  // 璿
	0x74C8, KANJI_RARELY_USED,  // 瓈
	0x74C9, KANJI_RARELY_USED,  // 瓉
	0x74CC, KANJI_RARELY_USED,  // 瓌
	0x74D0, KANJI_RARELY_USED,  // 瓐
	0x74D3, KANJI_RARELY_USED,  // 瓓
	0x74D8, KANJI_RARELY_USED,  // 瓘
	0x74DA, KANJI_RARELY_USED,  // 瓚
	0x74DB, KANJI_RARELY_USED,  // 瓛
	0x74DE, KANJI_RARELY_USED,  // 瓞
	0x74DF, KANJI_RARELY_USED,  // 瓟
	0x74E4, KANJI_RARELY_USED,  // 瓤
	0x74E8, KANJI_RARELY_USED,  // 瓨
	0x74EA, KANJI_RARELY_USED,  // 瓪
	0x74EB, KANJI_RARELY_USED,  // 瓫
	0x74EF, KANJI_RARELY_USED,  // 瓯
	0x74F4, KANJI_RARELY_USED,  // 瓴
	0x74FA, KANJI_RARELY_USED,  // 瓺
	0x74FB, KANJI_RARELY_USED,  // 瓻
	0x74FC, KANJI_RARELY_USED,  // 瓼
	0x74FF, KANJI_RARELY_USED,  // 瓿
	0x7506, KANJI_RARELY_USED,  // 甆
	0x7512, KANJI_RARELY_USED,  // 甒
	0x7516, KANJI_RARELY_USED,  // 甖
	0x7517, KANJI_RARELY_USED,  // 甗
	0x7520, KANJI_RARELY_USED,  // 甠
	0x7521, KANJI_RARELY_USED,  // 甡
	0x7524, KANJI_RARELY_USED,  // 甤
	0x7527, KANJI_RARELY_USED,  // 甧
	0x7529, KANJI_RARELY_USED,  // 甩
	0x752A, KANJI_RARELY_USED,  // 甪
	0x752F, KANJI_RARELY_USED,  // 甯
	0x7536, KANJI_RARELY_USED,  // 甶
	0x7539, KANJI_RARELY_USED,  // 甹
	0x753D, KANJI_RARELY_USED,  // 甽
	0x753E, KANJI_RARELY_USED,  // 甾
	0x753F, KANJI_RARELY_USED,  // 甿
	0x7540, KANJI_RARELY_USED,  // 畀
	0x7543, KANJI_RARELY_USED,  // 畃
	0x7547, KANJI_RARELY_USED,  // 畇
	0x7548, KANJI_RARELY_USED,  // 畈
	0x754E, KANJI_RARELY_USED,  // 畎
	0x7550, KANJI_RARELY_USED,  // 畐
	0x7552, KANJI_RARELY_USED,  // 畒
	0x7557, KANJI_RARELY_USED,  // 畗
	0x755E, KANJI_RARELY_USED,  // 畞
	0x755F, KANJI_RARELY_USED,  // 畟
	0x7561, KANJI_RARELY_USED,  // 畡
	0x756F, KANJI_RARELY_USED,  // 畯
	0x7571, KANJI_RARELY_USED,  // 畱
	0x7579, KANJI_RARELY_USED,  // 畹
	0x757A, KANJI_RARELY_USED,  // 畺
	0x757B, KANJI_RARELY_USED,  // 畻
	0x757C, KANJI_RARELY_USED,  // 畼
	0x757D, KANJI_RARELY_USED,  // 畽
	0x757E, KANJI_RARELY_USED,  // 畾
	0x7581, KANJI_RARELY_USED,  // 疁
	0x7585, KANJI_RARELY_USED,  // 疅
	0x7590, KANJI_RARELY_USED,  // 疐
	0x7592, KANJI_RARELY_USED,  // 疒
	0x7593, KANJI_RARELY_USED,  // 疓
	0x7595, KANJI_RARELY_USED,  // 疕
	0x7599, KANJI_RARELY_USED,  // 疙
	0x759C, KANJI_RARELY_USED,  // 疜
	0x75A2, KANJI_RARELY_USED,  // 疢
	0x75A4, KANJI_RARELY_USED,  // 疤
	0x75B4, KANJI_RARELY_USED,  // 疴
	0x75BA, KANJI_RARELY_USED,  // 疺
	0x75BF, KANJI_RARELY_USED,  // 疿
	0x75C0, KANJI_RARELY_USED,  // 痀
	0x75C1, KANJI_RARELY_USED,  // 痁
	0x75C4, KANJI_RARELY_USED,  // 痄
	0x75C6, KANJI_RARELY_USED,  // 痆
	0x75CC, KANJI_RARELY_USED,  // 痌
	0x75CE, KANJI_RARELY_USED,  // 痎
	0x75CF, KANJI_RARELY_USED,  // 痏
	0x75D7, KANJI_RARELY_USED,  // 痗
	0x75DC, KANJI_RARELY_USED,  // 痜
	0x75DF, KANJI_RARELY_USED,  // 痟
	0x75E0, KANJI_RARELY_USED,  // 痠
	0x75E1, KANJI_RARELY_USED,  // 痡
	0x75E4, KANJI_RARELY_USED,  // 痤
	0x75E7, KANJI_RARELY_USED,  // 痧
	0x75EC, KANJI_RARELY_USED,  // 痬
	0x75EE, KANJI_RARELY_USED,  // 痮
	0x75EF, KANJI_RARELY_USED,  // 痯
	0x75F1, KANJI_RARELY_USED,  // 痱
	0x75F9, KANJI_RARELY_USED,  // 痹
	0x7600, KANJI_RARELY_USED,  // 瘀
	0x7602, KANJI_RARELY_USED,  // 瘂
	0x7603, KANJI_RARELY_USED,  // 瘃
	0x7604, KANJI_RARELY_USED,  // 瘄
	0x7607, KANJI_RARELY_USED,  // 瘇
	0x7608, KANJI_RARELY_USED,  // 瘈
	0x760A, KANJI_RARELY_USED,  // 瘊
	0x760C, KANJI_RARELY_USED,  // 瘌
	0x760F, KANJI_RARELY_USED,  // 瘏
	0x7612, KANJI_RARELY_USED,  // 瘒
	0x7613, KANJI_RARELY_USED,  // 瘓
	0x7615, KANJI_RARELY_USED,  // 瘕
	0x7616, KANJI_RARELY_USED,  // 瘖
	0x7619, KANJI_RARELY_USED,  // 瘙
	0x761B, KANJI_RARELY_USED,  // 瘛
	0x761C, KANJI_RARELY_USED,  // 瘜
	0x761D, KANJI_RARELY_USED,  // 瘝
	0x761E, KANJI_RARELY_USED,  // 瘞
	0x7623, KANJI_RARELY_USED,  // 瘣
	0x7625, KANJI_RARELY_USED,  // 瘥
	0x7626, KANJI_RARELY_USED,  // 瘦
	0x7629, KANJI_RARELY_USED,  // 瘩
	0x762D, KANJI_RARELY_USED,  // 瘭
	0x7632, KANJI_RARELY_USED,  // 瘲
	0x7633, KANJI_RARELY_USED,  // 瘳
	0x7635, KANJI_RARELY_USED,  // 瘵
	0x7638, KANJI_RARELY_USED,  // 瘸
	0x7639, KANJI_RARELY_USED,  // 瘹
	0x763A, KANJI_RARELY_USED,  // 瘺
	0x763C, KANJI_RARELY_USED,  // 瘼
	0x764A, KANJI_RARELY_USED,  // 癊
	0x7640, KANJI_RARELY_USED,  // 癀
	0x7641, KANJI_RARELY_USED,  // 癁
	0x7643, KANJI_RARELY_USED,  // 癃
	0x7644, KANJI_RARELY_USED,  // 癄
	0x7645, KANJI_RARELY_USED,  // 癅
	0x7649, KANJI_RARELY_USED,  // 癉
	0x764B, KANJI_RARELY_USED,  // 癋
	0x7655, KANJI_RARELY_USED,  // 癕
	0x7659, KANJI_RARELY_USED,  // 癙
	0x765F, KANJI_RARELY_USED,  // 癟
	0x7664, KANJI_RARELY_USED,  // 癤
	0x7665, KANJI_RARELY_USED,  // 癥
	0x766D, KANJI_RARELY_USED,  // 癭
	0x766E, KANJI_RARELY_USED,  // 癮
	0x766F, KANJI_RARELY_USED,  // 癯
	0x7671, KANJI_RARELY_USED,  // 癱
	0x7674, KANJI_RARELY_USED,  // 癴
	0x7681, KANJI_RARELY_USED,  // 皁
	0x7685, KANJI_RARELY_USED,  // 皅
	0x768C, KANJI_RARELY_USED,  // 皌
	0x768D, KANJI_RARELY_USED,  // 皍
	0x7695, KANJI_RARELY_USED,  // 皕
	0x769B, KANJI_RARELY_USED,  // 皛
	0x769C, KANJI_RARELY_USED,  // 皜
	0x769D, KANJI_RARELY_USED,  // 皝
	0x769F, KANJI_RARELY_USED,  // 皟
	0x76A0, KANJI_RARELY_USED,  // 皠
	0x76A2, KANJI_RARELY_USED,  // 皢
	0x76A3, KANJI_RARELY_USED,  // 皣
	0x76A4, KANJI_RARELY_USED,  // 皤
	0x76A5, KANJI_RARELY_USED,  // 皥
	0x76A6, KANJI_RARELY_USED,  // 皦
	0x76A7, KANJI_RARELY_USED,  // 皧
	0x76A8, KANJI_RARELY_USED,  // 皨
	0x76AA, KANJI_RARELY_USED,  // 皪
	0x76AD, KANJI_RARELY_USED,  // 皭
	0x76BD, KANJI_RARELY_USED,  // 皽
	0x76C1, KANJI_RARELY_USED,  // 盁
	0x76C5, KANJI_RARELY_USED,  // 盅
	0x76C9, KANJI_RARELY_USED,  // 盉
	0x76CB, KANJI_RARELY_USED,  // 盋
	0x76CC, KANJI_RARELY_USED,  // 盌
	0x76CE, KANJI_RARELY_USED,  // 盎
	0x76D4, KANJI_RARELY_USED,  // 盔
	0x76D9, KANJI_RARELY_USED,  // 盙
	0x76E0, KANJI_RARELY_USED,  // 盠
	0x76E6, KANJI_RARELY_USED,  // 盦
	0x76E8, KANJI_RARELY_USED,  // 盨
	0x76EC, KANJI_RARELY_USED,  // 盬
	0x76F0, KANJI_RARELY_USED,  // 盰
	0x76F1, KANJI_RARELY_USED,  // 盱
	0x76F6, KANJI_RARELY_USED,  // 盶
	0x76F9, KANJI_RARELY_USED,  // 盹
	0x76FC, KANJI_RARELY_USED,  // 盼
	0x7700, KANJI_RARELY_USED,  // 眀
	0x7706, KANJI_RARELY_USED,  // 眆
	0x770A, KANJI_RARELY_USED,  // 眊
	0x770E, KANJI_RARELY_USED,  // 眎
	0x7712, KANJI_RARELY_USED,  // 眒
	0x7714, KANJI_RARELY_USED,  // 眔
	0x7715, KANJI_RARELY_USED,  // 眕
	0x7717, KANJI_RARELY_USED,  // 眗
	0x7719, KANJI_RARELY_USED,  // 眙
	0x771A, KANJI_RARELY_USED,  // 眚
	0x771C, KANJI_RARELY_USED,  // 眜
	0x7722, KANJI_RARELY_USED,  // 眢
	0x7728, KANJI_RARELY_USED,  // 眨
	0x772D, KANJI_RARELY_USED,  // 眭
	0x772E, KANJI_RARELY_USED,  // 眮
	0x772F, KANJI_RARELY_USED,  // 眯
	0x7734, KANJI_RARELY_USED,  // 眴
	0x7735, KANJI_RARELY_USED,  // 眵
	0x7736, KANJI_RARELY_USED,  // 眶
	0x7739, KANJI_RARELY_USED,  // 眹
	0x773D, KANJI_RARELY_USED,  // 眽
	0x773E, KANJI_RARELY_USED,  // 眾
	0x7742, KANJI_RARELY_USED,  // 睂
	0x7745, KANJI_RARELY_USED,  // 睅
	0x7746, KANJI_RARELY_USED,  // 睆
	0x774A, KANJI_RARELY_USED,  // 睊
	0x774D, KANJI_RARELY_USED,  // 睍
	0x774E, KANJI_RARELY_USED,  // 睎
	0x774F, KANJI_RARELY_USED,  // 睏
	0x7752, KANJI_RARELY_USED,  // 睒
	0x7756, KANJI_RARELY_USED,  // 睖
	0x7757, KANJI_RARELY_USED,  // 睗
	0x775C, KANJI_RARELY_USED,  // 睜
	0x775E, KANJI_RARELY_USED,  // 睞
	0x775F, KANJI_RARELY_USED,  // 睟
	0x7760, KANJI_RARELY_USED,  // 睠
	0x7762, KANJI_RARELY_USED,  // 睢
	0x7764, KANJI_RARELY_USED,  // 睤
	0x7767, KANJI_RARELY_USED,  // 睧
	0x776A, KANJI_RARELY_USED,  // 睪
	0x776C, KANJI_RARELY_USED,  // 睬
	0x7770, KANJI_RARELY_USED,  // 睰
	0x7772, KANJI_RARELY_USED,  // 睲
	0x7773, KANJI_RARELY_USED,  // 睳
	0x7774, KANJI_RARELY_USED,  // 睴
	0x777A, KANJI_RARELY_USED,  // 睺
	0x777D, KANJI_RARELY_USED,  // 睽
	0x7780, KANJI_RARELY_USED,  // 瞀
	0x7784, KANJI_RARELY_USED,  // 瞄
	0x778C, KANJI_RARELY_USED,  // 瞌
	0x778D, KANJI_RARELY_USED,  // 瞍
	0x7794, KANJI_RARELY_USED,  // 瞔
	0x7795, KANJI_RARELY_USED,  // 瞕
	0x7796, KANJI_RARELY_USED,  // 瞖
	0x779A, KANJI_RARELY_USED,  // 瞚
	0x779F, KANJI_RARELY_USED,  // 瞟
	0x77A2, KANJI_RARELY_USED,  // 瞢
	0x77A7, KANJI_RARELY_USED,  // 瞧
	0x77AA, KANJI_RARELY_USED,  // 瞪
	0x77AE, KANJI_RARELY_USED,  // 瞮
	0x77AF, KANJI_RARELY_USED,  // 瞯
	0x77B1, KANJI_RARELY_USED,  // 瞱
	0x77B5, KANJI_RARELY_USED,  // 瞵
	0x77BE, KANJI_RARELY_USED,  // 瞾
	0x77C3, KANJI_RARELY_USED,  // 矃
	0x77C9, KANJI_RARELY_USED,  // 矉
	0x77D1, KANJI_RARELY_USED,  // 矑
	0x77D2, KANJI_RARELY_USED,  // 矒
	0x77D5, KANJI_RARELY_USED,  // 矕
	0x77D9, KANJI_RARELY_USED,  // 矙
	0x77DE, KANJI_RARELY_USED,  // 矞
	0x77DF, KANJI_RARELY_USED,  // 矟
	0x77E0, KANJI_RARELY_USED,  // 矠
	0x77E4, KANJI_RARELY_USED,  // 矤
	0x77E6, KANJI_RARELY_USED,  // 矦
	0x77EA, KANJI_RARELY_USED,  // 矪
	0x77EC, KANJI_RARELY_USED,  // 矬
	0x77F0, KANJI_RARELY_USED,  // 矰
	0x77F1, KANJI_RARELY_USED,  // 矱
	0x77F4, KANJI_RARELY_USED,  // 矴
	0x77F8, KANJI_RARELY_USED,  // 矸
	0x77FB, KANJI_RARELY_USED,  // 矻
	0x7805, KANJI_RARELY_USED,  // 砅
	0x7806, KANJI_RARELY_USED,  // 砆
	0x7809, KANJI_RARELY_USED,  // 砉
	0x780D, KANJI_RARELY_USED,  // 砍
	0x780E, KANJI_RARELY_USED,  // 砎
	0x7811, KANJI_RARELY_USED,  // 砑
	0x781D, KANJI_RARELY_USED,  // 砝
	0x7821, KANJI_RARELY_USED,  // 砡
	0x7822, KANJI_RARELY_USED,  // 砢
	0x7823, KANJI_RARELY_USED,  // 砣
	0x782D, KANJI_RARELY_USED,  // 砭
	0x782E, KANJI_RARELY_USED,  // 砮
	0x7830, KANJI_RARELY_USED,  // 砰
	0x7835, KANJI_RARELY_USED,  // 砵
	0x7837, KANJI_RARELY_USED,  // 砷
	0x7843, KANJI_RARELY_USED,  // 硃
	0x7844, KANJI_RARELY_USED,  // 硄
	0x7847, KANJI_RARELY_USED,  // 硇
	0x7848, KANJI_RARELY_USED,  // 硈
	0x784C, KANJI_RARELY_USED,  // 硌
	0x784E, KANJI_RARELY_USED,  // 硎
	0x7852, KANJI_RARELY_USED,  // 硒
	0x785C, KANJI_RARELY_USED,  // 硜
	0x785E, KANJI_RARELY_USED,  // 硞
	0x7860, KANJI_RARELY_USED,  // 硠
	0x7861, KANJI_RARELY_USED,  // 硡
	0x7863, KANJI_RARELY_USED,  // 硣
	0x7864, KANJI_RARELY_USED,  // 硤
	0x7868, KANJI_RARELY_USED,  // 硨
	0x786A, KANJI_RARELY_USED,  // 硪
	0x786E, KANJI_RARELY_USED,  // 确
	0x787A, KANJI_RARELY_USED,  // 硺
	0x787E, KANJI_RARELY_USED,  // 硾
	0x788A, KANJI_RARELY_USED,  // 碊
	0x788F, KANJI_RARELY_USED,  // 碏
	0x7894, KANJI_RARELY_USED,  // 碔
	0x7898, KANJI_RARELY_USED,  // 碘
	0x78A1, KANJI_RARELY_USED,  // 碡
	0x789D, KANJI_RARELY_USED,  // 碝
	0x789E, KANJI_RARELY_USED,  // 碞
	0x789F, KANJI_RARELY_USED,  // 碟
	0x78A4, KANJI_RARELY_USED,  // 碤
	0x78A8, KANJI_RARELY_USED,  // 碨
	0x78AC, KANJI_RARELY_USED,  // 碬
	0x78AD, KANJI_RARELY_USED,  // 碭
	0x78B0, KANJI_RARELY_USED,  // 碰
	0x78B1, KANJI_RARELY_USED,  // 碱
	0x78B2, KANJI_RARELY_USED,  // 碲
	0x78B3, KANJI_RARELY_USED,  // 碳
	0x78BB, KANJI_RARELY_USED,  // 碻
	0x78BD, KANJI_RARELY_USED,  // 碽
	0x78BF, KANJI_RARELY_USED,  // 碿
	0x78C7, KANJI_RARELY_USED,  // 磇
	0x78C8, KANJI_RARELY_USED,  // 磈
	0x78C9, KANJI_RARELY_USED,  // 磉
	0x78CC, KANJI_RARELY_USED,  // 磌
	0x78CE, KANJI_RARELY_USED,  // 磎
	0x78D2, KANJI_RARELY_USED,  // 磒
	0x78D3, KANJI_RARELY_USED,  // 磓
	0x78D5, KANJI_RARELY_USED,  // 磕
	0x78D6, KANJI_RARELY_USED,  // 磖
	0x78E4, KANJI_RARELY_USED,  // 磤
	0x78DB, KANJI_RARELY_USED,  // 磛
	0x78DF, KANJI_RARELY_USED,  // 磟
	0x78E0, KANJI_RARELY_USED,  // 磠
	0x78E1, KANJI_RARELY_USED,  // 磡
	0x78E6, KANJI_RARELY_USED,  // 磦
	0x78EA, KANJI_RARELY_USED,  // 磪
	0x78F2, KANJI_RARELY_USED,  // 磲
	0x78F3, KANJI_RARELY_USED,  // 磳
	0x7900, KANJI_RARELY_USED,  // 礀
	0x78F6, KANJI_RARELY_USED,  // 磶
	0x78F7, KANJI_RARELY_USED,  // 磷
	0x78FA, KANJI_RARELY_USED,  // 磺
	0x78FB, KANJI_RARELY_USED,  // 磻
	0x78FF, KANJI_RARELY_USED,  // 磿
	0x7906, KANJI_RARELY_USED,  // 礆
	0x790C, KANJI_RARELY_USED,  // 礌
	0x7910, KANJI_RARELY_USED,  // 礐
	0x791A, KANJI_RARELY_USED,  // 礚
	0x791C, KANJI_RARELY_USED,  // 礜
	0x791E, KANJI_RARELY_USED,  // 礞
	0x791F, KANJI_RARELY_USED,  // 礟
	0x7920, KANJI_RARELY_USED,  // 礠
	0x7925, KANJI_RARELY_USED,  // 礥
	0x7927, KANJI_RARELY_USED,  // 礧
	0x7929, KANJI_RARELY_USED,  // 礩
	0x792D, KANJI_RARELY_USED,  // 礭
	0x7931, KANJI_RARELY_USED,  // 礱
	0x7934, KANJI_RARELY_USED,  // 礴
	0x7935, KANJI_RARELY_USED,  // 礵
	0x793B, KANJI_RARELY_USED,  // 礻
	0x793D, KANJI_RARELY_USED,  // 礽
	0x793F, KANJI_RARELY_USED,  // 礿
	0x7944, KANJI_RARELY_USED,  // 祄
	0x7945, KANJI_RARELY_USED,  // 祅
	0x7946, KANJI_RARELY_USED,  // 祆
	0x794A, KANJI_RARELY_USED,  // 祊
	0x794B, KANJI_RARELY_USED,  // 祋
	0x794F, KANJI_RARELY_USED,  // 祏
	0x7951, KANJI_RARELY_USED,  // 祑
	0x7954, KANJI_RARELY_USED,  // 祔
	0x7958, KANJI_RARELY_USED,  // 祘
	0x795B, KANJI_RARELY_USED,  // 祛
	0x795C, KANJI_RARELY_USED,  // 祜
	0x7967, KANJI_RARELY_USED,  // 祧
	0x7969, KANJI_RARELY_USED,  // 祩
	0x796B, KANJI_RARELY_USED,  // 祫
	0x7972, KANJI_RARELY_USED,  // 祲
	0x7979, KANJI_RARELY_USED,  // 祹
	0x797B, KANJI_RARELY_USED,  // 祻
	0x797C, KANJI_RARELY_USED,  // 祼
	0x797E, KANJI_RARELY_USED,  // 祾
	0x798B, KANJI_RARELY_USED,  // 禋
	0x798C, KANJI_RARELY_USED,  // 禌
	0x7991, KANJI_RARELY_USED,  // 禑
	0x7993, KANJI_RARELY_USED,  // 禓
	0x7994, KANJI_RARELY_USED,  // 禔
	0x7995, KANJI_RARELY_USED,  // 禕
	0x7996, KANJI_RARELY_USED,  // 禖
	0x7998, KANJI_RARELY_USED,  // 禘
	0x799B, KANJI_RARELY_USED,  // 禛
	0x799C, KANJI_RARELY_USED,  // 禜
	0x79A1, KANJI_RARELY_USED,  // 禡
	0x79A8, KANJI_RARELY_USED,  // 禨
	0x79A9, KANJI_RARELY_USED,  // 禩
	0x79AB, KANJI_RARELY_USED,  // 禫
	0x79AF, KANJI_RARELY_USED,  // 禯
	0x79B1, KANJI_RARELY_USED,  // 禱
	0x79B4, KANJI_RARELY_USED,  // 禴
	0x79B8, KANJI_RARELY_USED,  // 禸
	0x79BB, KANJI_RARELY_USED,  // 离
	0x79C2, KANJI_RARELY_USED,  // 秂
	0x79C4, KANJI_RARELY_USED,  // 秄
	0x79C7, KANJI_RARELY_USED,  // 秇
	0x79C8, KANJI_RARELY_USED,  // 秈
	0x79CA, KANJI_RARELY_USED,  // 秊
	0x79CF, KANJI_RARELY_USED,  // 秏
	0x79D4, KANJI_RARELY_USED,  // 秔
	0x79D6, KANJI_RARELY_USED,  // 秖
	0x79DA, KANJI_RARELY_USED,  // 秚
	0x79DD, KANJI_RARELY_USED,  // 秝
	0x79DE, KANJI_RARELY_USED,  // 秞
	0x79E0, KANJI_RARELY_USED,  // 秠
	0x79E2, KANJI_RARELY_USED,  // 秢
	0x79E5, KANJI_RARELY_USED,  // 秥
	0x79EA, KANJI_RARELY_USED,  // 秪
	0x79EB, KANJI_RARELY_USED,  // 秫
	0x79ED, KANJI_RARELY_USED,  // 秭
	0x79F1, KANJI_RARELY_USED,  // 秱
	0x79F8, KANJI_RARELY_USED,  // 秸
	0x79FC, KANJI_RARELY_USED,  // 秼
	0x7A02, KANJI_RARELY_USED,  // 稂
	0x7A03, KANJI_RARELY_USED,  // 稃
	0x7A07, KANJI_RARELY_USED,  // 稇
	0x7A09, KANJI_RARELY_USED,  // 稉
	0x7A0A, KANJI_RARELY_USED,  // 稊
	0x7A0C, KANJI_RARELY_USED,  // 稌
	0x7A11, KANJI_RARELY_USED,  // 稑
	0x7A15, KANJI_RARELY_USED,  // 稕
	0x7A1B, KANJI_RARELY_USED,  // 稛
	0x7A1E, KANJI_RARELY_USED,  // 稞
	0x7A21, KANJI_RARELY_USED,  // 稡
	0x7A27, KANJI_RARELY_USED,  // 稧
	0x7A2B, KANJI_RARELY_USED,  // 稫
	0x7A2D, KANJI_RARELY_USED,  // 稭
	0x7A2F, KANJI_RARELY_USED,  // 稯
	0x7A30, KANJI_RARELY_USED,  // 稰
	0x7A34, KANJI_RARELY_USED,  // 稴
	0x7A35, KANJI_RARELY_USED,  // 稵
	0x7A38, KANJI_RARELY_USED,  // 稸
	0x7A39, KANJI_RARELY_USED,  // 稹
	0x7A3A, KANJI_RARELY_USED,  // 稺
	0x7A44, KANJI_RARELY_USED,  // 穄
	0x7A45, KANJI_RARELY_USED,  // 穅
	0x7A47, KANJI_RARELY_USED,  // 穇
	0x7A48, KANJI_RARELY_USED,  // 穈
	0x7A4C, KANJI_RARELY_USED,  // 穌
	0x7A55, KANJI_RARELY_USED,  // 穕
	0x7A56, KANJI_RARELY_USED,  // 穖
	0x7A59, KANJI_RARELY_USED,  // 穙
	0x7A5C, KANJI_RARELY_USED,  // 穜
	0x7A5D, KANJI_RARELY_USED,  // 穝
	0x7A5F, KANJI_RARELY_USED,  // 穟
	0x7A60, KANJI_RARELY_USED,  // 穠
	0x7A65, KANJI_RARELY_USED,  // 穥
	0x7A67, KANJI_RARELY_USED,  // 穧
	0x7A6A, KANJI_RARELY_USED,  // 穪
	0x7A6D, KANJI_RARELY_USED,  // 穭
	0x7A75, KANJI_RARELY_USED,  // 穵
	0x7A78, KANJI_RARELY_USED,  // 穸
	0x7A7E, KANJI_RARELY_USED,  // 穾
	0x7A80, KANJI_RARELY_USED,  // 窀
	0x7A82, KANJI_RARELY_USED,  // 窂
	0x7A85, KANJI_RARELY_USED,  // 窅
	0x7A86, KANJI_RARELY_USED,  // 窆
	0x7A8A, KANJI_RARELY_USED,  // 窊
	0x7A8B, KANJI_RARELY_USED,  // 窋
	0x7A90, KANJI_RARELY_USED,  // 窐
	0x7A91, KANJI_RARELY_USED,  // 窑
	0x7A94, KANJI_RARELY_USED,  // 窔
	0x7A9E, KANJI_RARELY_USED,  // 窞
	0x7AA0, KANJI_RARELY_USED,  // 窠
	0x7AA3, KANJI_RARELY_USED,  // 窣
	0x7AAC, KANJI_RARELY_USED,  // 窬
	0x7AB3, KANJI_RARELY_USED,  // 窳
	0x7AB5, KANJI_RARELY_USED,  // 窵
	0x7AB9, KANJI_RARELY_USED,  // 窹
	0x7ABB, KANJI_RARELY_USED,  // 窻
	0x7ABC, KANJI_RARELY_USED,  // 窼
	0x7AC6, KANJI_RARELY_USED,  // 竆
	0x7AC9, KANJI_RARELY_USED,  // 竉
	0x7ACC, KANJI_RARELY_USED,  // 竌
	0x7ACE, KANJI_RARELY_USED,  // 竎
	0x7AD1, KANJI_RARELY_USED,  // 竑
	0x7ADB, KANJI_RARELY_USED,  // 竛
	0x7AE8, KANJI_RARELY_USED,  // 竨
	0x7AE9, KANJI_RARELY_USED,  // 竩
	0x7AEB, KANJI_RARELY_USED,  // 竫
	0x7AEC, KANJI_RARELY_USED,  // 竬
	0x7AF1, KANJI_RARELY_USED,  // 竱
	0x7AF4, KANJI_RARELY_USED,  // 竴
	0x7AFB, KANJI_RARELY_USED,  // 竻
	0x7AFD, KANJI_RARELY_USED,  // 竽
	0x7AFE, KANJI_RARELY_USED,  // 竾
	0x7B07, KANJI_RARELY_USED,  // 笇
	0x7B14, KANJI_RARELY_USED,  // 笔
	0x7B1F, KANJI_RARELY_USED,  // 笟
	0x7B23, KANJI_RARELY_USED,  // 笣
	0x7B27, KANJI_RARELY_USED,  // 笧
	0x7B29, KANJI_RARELY_USED,  // 笩
	0x7B2A, KANJI_RARELY_USED,  // 笪
	0x7B2B, KANJI_RARELY_USED,  // 笫
	0x7B2D, KANJI_RARELY_USED,  // 笭
	0x7B2E, KANJI_RARELY_USED,  // 笮
	0x7B2F, KANJI_RARELY_USED,  // 笯
	0x7B30, KANJI_RARELY_USED,  // 笰
	0x7B31, KANJI_RARELY_USED,  // 笱
	0x7B34, KANJI_RARELY_USED,  // 笴
	0x7B3D, KANJI_RARELY_USED,  // 笽
	0x7B3F, KANJI_RARELY_USED,  // 笿
	0x7B40, KANJI_RARELY_USED,  // 筀
	0x7B41, KANJI_RARELY_USED,  // 筁
	0x7B47, KANJI_RARELY_USED,  // 筇
	0x7B4E, KANJI_RARELY_USED,  // 筎
	0x7B55, KANJI_RARELY_USED,  // 筕
	0x7B60, KANJI_RARELY_USED,  // 筠
	0x7B64, KANJI_RARELY_USED,  // 筤
	0x7B66, KANJI_RARELY_USED,  // 筦
	0x7B69, KANJI_RARELY_USED,  // 筩
	0x7B6A, KANJI_RARELY_USED,  // 筪
	0x7B6D, KANJI_RARELY_USED,  // 筭
	0x7B6F, KANJI_RARELY_USED,  // 筯
	0x7B72, KANJI_RARELY_USED,  // 筲
	0x7B73, KANJI_RARELY_USED,  // 筳
	0x7B77, KANJI_RARELY_USED,  // 筷
	0x7B84, KANJI_RARELY_USED,  // 箄
	0x7B89, KANJI_RARELY_USED,  // 箉
	0x7B8E, KANJI_RARELY_USED,  // 箎
	0x7B90, KANJI_RARELY_USED,  // 箐
	0x7B91, KANJI_RARELY_USED,  // 箑
	0x7B96, KANJI_RARELY_USED,  // 箖
	0x7B9B, KANJI_RARELY_USED,  // 箛
	0x7B9E, KANJI_RARELY_USED,  // 箞
	0x7BA0, KANJI_RARELY_USED,  // 箠
	0x7BA5, KANJI_RARELY_USED,  // 箥
	0x7BAC, KANJI_RARELY_USED,  // 箬
	0x7BAF, KANJI_RARELY_USED,  // 箯
	0x7BB0, KANJI_RARELY_USED,  // 箰
	0x7BB2, KANJI_RARELY_USED,  // 箲
	0x7BB5, KANJI_RARELY_USED,  // 箵
	0x7BB6, KANJI_RARELY_USED,  // 箶
	0x7BBA, KANJI_RARELY_USED,  // 箺
	0x7BBB, KANJI_RARELY_USED,  // 箻
	0x7BBC, KANJI_RARELY_USED,  // 箼
	0x7BBD, KANJI_RARELY_USED,  // 箽
	0x7BC2, KANJI_RARELY_USED,  // 篂
	0x7BC5, KANJI_RARELY_USED,  // 篅
	0x7BC8, KANJI_RARELY_USED,  // 篈
	0x7BCA, KANJI_RARELY_USED,  // 篊
	0x7BD4, KANJI_RARELY_USED,  // 篔
	0x7BD6, KANJI_RARELY_USED,  // 篖
	0x7BD7, KANJI_RARELY_USED,  // 篗
	0x7BD9, KANJI_RARELY_USED,  // 篙
	0x7BDA, KANJI_RARELY_USED,  // 篚
	0x7BDB, KANJI_RARELY_USED,  // 篛
	0x7BE8, KANJI_RARELY_USED,  // 篨
	0x7BEA, KANJI_RARELY_USED,  // 篪
	0x7BF2, KANJI_RARELY_USED,  // 篲
	0x7BF4, KANJI_RARELY_USED,  // 篴
	0x7BF5, KANJI_RARELY_USED,  // 篵
	0x7BF8, KANJI_RARELY_USED,  // 篸
	0x7BF9, KANJI_RARELY_USED,  // 篹
	0x7BFA, KANJI_RARELY_USED,  // 篺
	0x7BFC, KANJI_RARELY_USED,  // 篼
	0x7BFE, KANJI_RARELY_USED,  // 篾
	0x7C01, KANJI_RARELY_USED,  // 簁
	0x7C02, KANJI_RARELY_USED,  // 簂
	0x7C03, KANJI_RARELY_USED,  // 簃
	0x7C04, KANJI_RARELY_USED,  // 簄
	0x7C06, KANJI_RARELY_USED,  // 簆
	0x7C09, KANJI_RARELY_USED,  // 簉
	0x7C0B, KANJI_RARELY_USED,  // 簋
	0x7C0C, KANJI_RARELY_USED,  // 簌
	0x7C0E, KANJI_RARELY_USED,  // 簎
	0x7C0F, KANJI_RARELY_USED,  // 簏
	0x7C19, KANJI_RARELY_USED,  // 簙
	0x7C1B, KANJI_RARELY_USED,  // 簛
	0x7C20, KANJI_RARELY_USED,  // 簠
	0x7C25, KANJI_RARELY_USED,  // 簥
	0x7C26, KANJI_RARELY_USED,  // 簦
	0x7C28, KANJI_RARELY_USED,  // 簨
	0x7C2C, KANJI_RARELY_USED,  // 簬
	0x7C31, KANJI_RARELY_USED,  // 簱
	0x7C33, KANJI_RARELY_USED,  // 簳
	0x7C34, KANJI_RARELY_USED,  // 簴
	0x7C36, KANJI_RARELY_USED,  // 簶
	0x7C39, KANJI_RARELY_USED,  // 簹
	0x7C3A, KANJI_RARELY_USED,  // 簺
	0x7C46, KANJI_RARELY_USED,  // 籆
	0x7C4A, KANJI_RARELY_USED,  // 籊
	0x7C55, KANJI_RARELY_USED,  // 籕
	0x7C51, KANJI_RARELY_USED,  // 籑
	0x7C52, KANJI_RARELY_USED,  // 籒
	0x7C53, KANJI_RARELY_USED,  // 籓
	0x7C59, KANJI_RARELY_USED,  // 籙
	0x7C5A, KANJI_RARELY_USED,  // 籚
	0x7C5B, KANJI_RARELY_USED,  // 籛
	0x7C5C, KANJI_RARELY_USED,  // 籜
	0x7C5D, KANJI_RARELY_USED,  // 籝
	0x7C5E, KANJI_RARELY_USED,  // 籞
	0x7C61, KANJI_RARELY_USED,  // 籡
	0x7C63, KANJI_RARELY_USED,  // 籣
	0x7C67, KANJI_RARELY_USED,  // 籧
	0x7C69, KANJI_RARELY_USED,  // 籩
	0x7C6D, KANJI_RARELY_USED,  // 籭
	0x7C6E, KANJI_RARELY_USED,  // 籮
	0x7C70, KANJI_RARELY_USED,  // 籰
	0x7C72, KANJI_RARELY_USED,  // 籲
	0x7C79, KANJI_RARELY_USED,  // 籹
	0x7C7C, KANJI_RARELY_USED,  // 籼
	0x7C7D, KANJI_RARELY_USED,  // 籽
	0x7C86, KANJI_RARELY_USED,  // 粆
	0x7C87, KANJI_RARELY_USED,  // 粇
	0x7C8F, KANJI_RARELY_USED,  // 粏
	0x7C94, KANJI_RARELY_USED,  // 粔
	0x7C9E, KANJI_RARELY_USED,  // 粞
	0x7CA0, KANJI_RARELY_USED,  // 粠
	0x7CA6, KANJI_RARELY_USED,  // 粦
	0x7CB0, KANJI_RARELY_USED,  // 粰
	0x7CB6, KANJI_RARELY_USED,  // 粶
	0x7CB7, KANJI_RARELY_USED,  // 粷
	0x7CBA, KANJI_RARELY_USED,  // 粺
	0x7CBB, KANJI_RARELY_USED,  // 粻
	0x7CBC, KANJI_RARELY_USED,  // 粼
	0x7CBF, KANJI_RARELY_USED,  // 粿
	0x7CC4, KANJI_RARELY_USED,  // 糄
	0x7CC7, KANJI_RARELY_USED,  // 糇
	0x7CC8, KANJI_RARELY_USED,  // 糈
	0x7CC9, KANJI_RARELY_USED,  // 糉
	0x7CCD, KANJI_RARELY_USED,  // 糍
	0x7CCF, KANJI_RARELY_USED,  // 糏
	0x7CD3, KANJI_RARELY_USED,  // 糓
	0x7CD4, KANJI_RARELY_USED,  // 糔
	0x7CD5, KANJI_RARELY_USED,  // 糕
	0x7CD7, KANJI_RARELY_USED,  // 糗
	0x7CD9, KANJI_RARELY_USED,  // 糙
	0x7CDA, KANJI_RARELY_USED,  // 糚
	0x7CDD, KANJI_RARELY_USED,  // 糝
	0x7CE6, KANJI_RARELY_USED,  // 糦
	0x7CE9, KANJI_RARELY_USED,  // 糩
	0x7CEB, KANJI_RARELY_USED,  // 糫
	0x7CF5, KANJI_RARELY_USED,  // 糵
	0x7D03, KANJI_RARELY_USED,  // 紃
	0x7D07, KANJI_RARELY_USED,  // 紇
	0x7D08, KANJI_RARELY_USED,  // 紈
	0x7D09, KANJI_RARELY_USED,  // 紉
	0x7D0F, KANJI_RARELY_USED,  // 紏
	0x7D11, KANJI_RARELY_USED,  // 紑
	0x7D12, KANJI_RARELY_USED,  // 紒
	0x7D13, KANJI_RARELY_USED,  // 紓
	0x7D16, KANJI_RARELY_USED,  // 紖
	0x7D1D, KANJI_RARELY_USED,  // 紝
	0x7D1E, KANJI_RARELY_USED,  // 紞
	0x7D23, KANJI_RARELY_USED,  // 紣
	0x7D26, KANJI_RARELY_USED,  // 紦
	0x7D2A, KANJI_RARELY_USED,  // 紪
	0x7D2D, KANJI_RARELY_USED,  // 紭
	0x7D31, KANJI_RARELY_USED,  // 紱
	0x7D3C, KANJI_RARELY_USED,  // 紼
	0x7D3D, KANJI_RARELY_USED,  // 紽
	0x7D3E, KANJI_RARELY_USED,  // 紾
	0x7D40, KANJI_RARELY_USED,  // 絀
	0x7D41, KANJI_RARELY_USED,  // 絁
	0x7D47, KANJI_RARELY_USED,  // 絇
	0x7D48, KANJI_RARELY_USED,  // 絈
	0x7D4D, KANJI_RARELY_USED,  // 絍
	0x7D51, KANJI_RARELY_USED,  // 絑
	0x7D53, KANJI_RARELY_USED,  // 絓
	0x7D57, KANJI_RARELY_USED,  // 絗
	0x7D59, KANJI_RARELY_USED,  // 絙
	0x7D5A, KANJI_RARELY_USED,  // 絚
	0x7D5C, KANJI_RARELY_USED,  // 絜
	0x7D5D, KANJI_RARELY_USED,  // 絝
	0x7D65, KANJI_RARELY_USED,  // 絥
	0x7D67, KANJI_RARELY_USED,  // 絧
	0x7D6A, KANJI_RARELY_USED,  // 絪
	0x7D70, KANJI_RARELY_USED,  // 絰
	0x7D78, KANJI_RARELY_USED,  // 絸
	0x7D7A, KANJI_RARELY_USED,  // 絺
	0x7D7B, KANJI_RARELY_USED,  // 絻
	0x7D7F, KANJI_RARELY_USED,  // 絿
	0x7D81, KANJI_RARELY_USED,  // 綁
	0x7D82, KANJI_RARELY_USED,  // 綂
	0x7D83, KANJI_RARELY_USED,  // 綃
	0x7D85, KANJI_RARELY_USED,  // 綅
	0x7D86, KANJI_RARELY_USED,  // 綆
	0x7D88, KANJI_RARELY_USED,  // 綈
	0x7D8B, KANJI_RARELY_USED,  // 綋
	0x7D8C, KANJI_RARELY_USED,  // 綌
	0x7D8D, KANJI_RARELY_USED,  // 綍
	0x7D91, KANJI_RARELY_USED,  // 綑
	0x7D96, KANJI_RARELY_USED,  // 綖
	0x7D97, KANJI_RARELY_USED,  // 綗
	0x7D9D, KANJI_RARELY_USED,  // 綝
	0x7D9E, KANJI_RARELY_USED,  // 綞
	0x7DA6, KANJI_RARELY_USED,  // 綦
	0x7DA7, KANJI_RARELY_USED,  // 綧
	0x7DAA, KANJI_RARELY_USED,  // 綪
	0x7DB3, KANJI_RARELY_USED,  // 綳
	0x7DB6, KANJI_RARELY_USED,  // 綶
	0x7DB7, KANJI_RARELY_USED,  // 綷
	0x7DB9, KANJI_RARELY_USED,  // 綹
	0x7DC2, KANJI_RARELY_USED,  // 緂
	0x7DC3, KANJI_RARELY_USED,  // 緃
	0x7DC4, KANJI_RARELY_USED,  // 緄
	0x7DC5, KANJI_RARELY_USED,  // 緅
	0x7DC6, KANJI_RARELY_USED,  // 緆
	0x7DCC, KANJI_RARELY_USED,  // 緌
	0x7DCD, KANJI_RARELY_USED,  // 緍
	0x7DCE, KANJI_RARELY_USED,  // 緎
	0x7DD7, KANJI_RARELY_USED,  // 緗
	0x7DD9, KANJI_RARELY_USED,  // 緙
	0x7E00, KANJI_RARELY_USED,  // 縀
	0x7DE2, KANJI_RARELY_USED,  // 緢
	0x7DE5, KANJI_RARELY_USED,  // 緥
	0x7DE6, KANJI_RARELY_USED,  // 緦
	0x7DEA, KANJI_RARELY_USED,  // 緪
	0x7DEB, KANJI_RARELY_USED,  // 緫
	0x7DED, KANJI_RARELY_USED,  // 緭
	0x7DF1, KANJI_RARELY_USED,  // 緱
	0x7DF5, KANJI_RARELY_USED,  // 緵
	0x7DF6, KANJI_RARELY_USED,  // 緶
	0x7DF9, KANJI_RARELY_USED,  // 緹
	0x7DFA, KANJI_RARELY_USED,  // 緺
	0x7E08, KANJI_RARELY_USED,  // 縈
	0x7E10, KANJI_RARELY_USED,  // 縐
	0x7E11, KANJI_RARELY_USED,  // 縑
	0x7E15, KANJI_RARELY_USED,  // 縕
	0x7E17, KANJI_RARELY_USED,  // 縗
	0x7E1C, KANJI_RARELY_USED,  // 縜
	0x7E1D, KANJI_RARELY_USED,  // 縝
	0x7E20, KANJI_RARELY_USED,  // 縠
	0x7E27, KANJI_RARELY_USED,  // 縧
	0x7E28, KANJI_RARELY_USED,  // 縨
	0x7E2C, KANJI_RARELY_USED,  // 縬
	0x7E2D, KANJI_RARELY_USED,  // 縭
	0x7E2F, KANJI_RARELY_USED,  // 縯
	0x7E33, KANJI_RARELY_USED,  // 縳
	0x7E36, KANJI_RARELY_USED,  // 縶
	0x7E3F, KANJI_RARELY_USED,  // 縿
	0x7E44, KANJI_RARELY_USED,  // 繄
	0x7E45, KANJI_RARELY_USED,  // 繅
	0x7E47, KANJI_RARELY_USED,  // 繇
	0x7E4E, KANJI_RARELY_USED,  // 繎
	0x7E50, KANJI_RARELY_USED,  // 繐
	0x7E52, KANJI_RARELY_USED,  // 繒
	0x7E58, KANJI_RARELY_USED,  // 繘
	0x7E5F, KANJI_RARELY_USED,  // 繟
	0x7E61, KANJI_RARELY_USED,  // 繡
	0x7E62, KANJI_RARELY_USED,  // 繢
	0x7E65, KANJI_RARELY_USED,  // 繥
	0x7E6B, KANJI_RARELY_USED,  // 繫
	0x7E6E, KANJI_RARELY_USED,  // 繮
	0x7E6F, KANJI_RARELY_USED,  // 繯
	0x7E73, KANJI_RARELY_USED,  // 繳
	0x7E78, KANJI_RARELY_USED,  // 繸
	0x7E7E, KANJI_RARELY_USED,  // 繾
	0x7E81, KANJI_RARELY_USED,  // 纁
	0x7E86, KANJI_RARELY_USED,  // 纆
	0x7E87, KANJI_RARELY_USED,  // 纇
	0x7E8A, KANJI_RARELY_USED,  // 纊
	0x7E8D, KANJI_RARELY_USED,  // 纍
	0x7E91, KANJI_RARELY_USED,  // 纑
	0x7E95, KANJI_RARELY_USED,  // 纕
	0x7E98, KANJI_RARELY_USED,  // 纘
	0x7E9A, KANJI_RARELY_USED,  // 纚
	0x7E9D, KANJI_RARELY_USED,  // 纝
	0x7E9E, KANJI_RARELY_USED,  // 纞
	0x7F3C, KANJI_RARELY_USED,  // 缼
	0x7F3B, KANJI_RARELY_USED,  // 缻
	0x7F3D, KANJI_RARELY_USED,  // 缽
	0x7F3E, KANJI_RARELY_USED,  // 缾
	0x7F3F, KANJI_RARELY_USED,  // 缿
	0x7F43, KANJI_RARELY_USED,  // 罃
	0x7F44, KANJI_RARELY_USED,  // 罄
	0x7F47, KANJI_RARELY_USED,  // 罇
	0x7F4F, KANJI_RARELY_USED,  // 罏
	0x7F52, KANJI_RARELY_USED,  // 罒
	0x7F53, KANJI_RARELY_USED,  // 罓
	0x7F5B, KANJI_RARELY_USED,  // 罛
	0x7F5C, KANJI_RARELY_USED,  // 罜
	0x7F5D, KANJI_RARELY_USED,  // 罝
	0x7F61, KANJI_RARELY_USED,  // 罡
	0x7F63, KANJI_RARELY_USED,  // 罣
	0x7F64, KANJI_RARELY_USED,  // 罤
	0x7F65, KANJI_RARELY_USED,  // 罥
	0x7F66, KANJI_RARELY_USED,  // 罦
	0x7F6D, KANJI_RARELY_USED,  // 罭
	0x7F71, KANJI_RARELY_USED,  // 罱
	0x7F7D, KANJI_RARELY_USED,  // 罽
	0x7F7E, KANJI_RARELY_USED,  // 罾
	0x7F7F, KANJI_RARELY_USED,  // 罿
	0x7F80, KANJI_RARELY_USED,  // 羀
	0x7F8B, KANJI_RARELY_USED,  // 羋
	0x7F8D, KANJI_RARELY_USED,  // 羍
	0x7F8F, KANJI_RARELY_USED,  // 羏
	0x7F90, KANJI_RARELY_USED,  // 羐
	0x7F91, KANJI_RARELY_USED,  // 羑
	0x7F96, KANJI_RARELY_USED,  // 羖
	0x7F97, KANJI_RARELY_USED,  // 羗
	0x7F9C, KANJI_RARELY_USED,  // 羜
	0x7FA1, KANJI_RARELY_USED,  // 羡
	0x7FA2, KANJI_RARELY_USED,  // 羢
	0x7FA6, KANJI_RARELY_USED,  // 羦
	0x7FAA, KANJI_RARELY_USED,  // 羪
	0x7FAD, KANJI_RARELY_USED,  // 羭
	0x7FB4, KANJI_RARELY_USED,  // 羴
	0x7FBC, KANJI_RARELY_USED,  // 羼
	0x7FBF, KANJI_RARELY_USED,  // 羿
	0x7FC0, KANJI_RARELY_USED,  // 翀
	0x7FC3, KANJI_RARELY_USED,  // 翃
	0x7FC8, KANJI_RARELY_USED,  // 翈
	0x7FCE, KANJI_RARELY_USED,  // 翎
	0x7FCF, KANJI_RARELY_USED,  // 翏
	0x7FDB, KANJI_RARELY_USED,  // 翛
	0x7FDF, KANJI_RARELY_USED,  // 翟
	0x7FE3, KANJI_RARELY_USED,  // 翣
	0x7FE5, KANJI_RARELY_USED,  // 翥
	0x7FE8, KANJI_RARELY_USED,  // 翨
	0x7FEC, KANJI_RARELY_USED,  // 翬
	0x7FEE, KANJI_RARELY_USED,  // 翮
	0x7FEF, KANJI_RARELY_USED,  // 翯
	0x7FF2, KANJI_RARELY_USED,  // 翲
	0x7FFA, KANJI_RARELY_USED,  // 翺
	0x7FFD, KANJI_RARELY_USED,  // 翽
	0x7FFE, KANJI_RARELY_USED,  // 翾
	0x7FFF, KANJI_RARELY_USED,  // 翿
	0x8007, KANJI_RARELY_USED,  // 耇
	0x8008, KANJI_RARELY_USED,  // 耈
	0x800A, KANJI_RARELY_USED,  // 耊
	0x800D, KANJI_RARELY_USED,  // 耍
	0x800E, KANJI_RARELY_USED,  // 耎
	0x800F, KANJI_RARELY_USED,  // 耏
	0x8011, KANJI_RARELY_USED,  // 耑
	0x8013, KANJI_RARELY_USED,  // 耓
	0x8014, KANJI_RARELY_USED,  // 耔
	0x8016, KANJI_RARELY_USED,  // 耖
	0x801D, KANJI_RARELY_USED,  // 耝
	0x801E, KANJI_RARELY_USED,  // 耞
	0x801F, KANJI_RARELY_USED,  // 耟
	0x8020, KANJI_RARELY_USED,  // 耠
	0x8024, KANJI_RARELY_USED,  // 耤
	0x8026, KANJI_RARELY_USED,  // 耦
	0x802C, KANJI_RARELY_USED,  // 耬
	0x802E, KANJI_RARELY_USED,  // 耮
	0x8030, KANJI_RARELY_USED,  // 耰
	0x8034, KANJI_RARELY_USED,  // 耴
	0x8035, KANJI_RARELY_USED,  // 耵
	0x8037, KANJI_RARELY_USED,  // 耷
	0x8039, KANJI_RARELY_USED,  // 耹
	0x803A, KANJI_RARELY_USED,  // 耺
	0x803C, KANJI_RARELY_USED,  // 耼
	0x803E, KANJI_RARELY_USED,  // 耾
	0x8040, KANJI_RARELY_USED,  // 聀
	0x8044, KANJI_RARELY_USED,  // 聄
	0x8060, KANJI_RARELY_USED,  // 聠
	0x8064, KANJI_RARELY_USED,  // 聤
	0x8066, KANJI_RARELY_USED,  // 聦
	0x806D, KANJI_RARELY_USED,  // 聭
	0x8071, KANJI_RARELY_USED,  // 聱
	0x8075, KANJI_RARELY_USED,  // 聵
	0x8081, KANJI_RARELY_USED,  // 肁
	0x8088, KANJI_RARELY_USED,  // 肈
	0x808E, KANJI_RARELY_USED,  // 肎
	0x809C, KANJI_RARELY_USED,  // 肜
	0x809E, KANJI_RARELY_USED,  // 肞
	0x80A6, KANJI_RARELY_USED,  // 肦
	0x80A7, KANJI_RARELY_USED,  // 肧
	0x80AB, KANJI_RARELY_USED,  // 肫
	0x80B8, KANJI_RARELY_USED,  // 肸
	0x80B9, KANJI_RARELY_USED,  // 肹
	0x80C8, KANJI_RARELY_USED,  // 胈
	0x80CD, KANJI_RARELY_USED,  // 胍
	0x80CF, KANJI_RARELY_USED,  // 胏
	0x80D2, KANJI_RARELY_USED,  // 胒
	0x80D4, KANJI_RARELY_USED,  // 胔
	0x80D5, KANJI_RARELY_USED,  // 胕
	0x80D7, KANJI_RARELY_USED,  // 胗
	0x80D8, KANJI_RARELY_USED,  // 胘
	0x80E0, KANJI_RARELY_USED,  // 胠
	0x80ED, KANJI_RARELY_USED,  // 胭
	0x80EE, KANJI_RARELY_USED,  // 胮
	0x80F0, KANJI_RARELY_USED,  // 胰
	0x80F2, KANJI_RARELY_USED,  // 胲
	0x80F3, KANJI_RARELY_USED,  // 胳
	0x80F6, KANJI_RARELY_USED,  // 胶
	0x80F9, KANJI_RARELY_USED,  // 胹
	0x80FA, KANJI_RARELY_USED,  // 胺
	0x80FE, KANJI_RARELY_USED,  // 胾
	0x8103, KANJI_RARELY_USED,  // 脃
	0x810B, KANJI_RARELY_USED,  // 脋
	0x8116, KANJI_RARELY_USED,  // 脖
	0x8117, KANJI_RARELY_USED,  // 脗
	0x8118, KANJI_RARELY_USED,  // 脘
	0x811C, KANJI_RARELY_USED,  // 脜
	0x811E, KANJI_RARELY_USED,  // 脞
	0x8120, KANJI_RARELY_USED,  // 脠
	0x8124, KANJI_RARELY_USED,  // 脤
	0x8127, KANJI_RARELY_USED,  // 脧
	0x812C, KANJI_RARELY_USED,  // 脬
	0x8130, KANJI_RARELY_USED,  // 脰
	0x8135, KANJI_RARELY_USED,  // 脵
	0x813A, KANJI_RARELY_USED,  // 脺
	0x813C, KANJI_RARELY_USED,  // 脼
	0x8145, KANJI_RARELY_USED,  // 腅
	0x8147, KANJI_RARELY_USED,  // 腇
	0x814A, KANJI_RARELY_USED,  // 腊
	0x814C, KANJI_RARELY_USED,  // 腌
	0x8152, KANJI_RARELY_USED,  // 腒
	0x8157, KANJI_RARELY_USED,  // 腗
	0x8160, KANJI_RARELY_USED,  // 腠
	0x8161, KANJI_RARELY_USED,  // 腡
	0x8167, KANJI_RARELY_USED,  // 腧
	0x8168, KANJI_RARELY_USED,  // 腨
	0x8169, KANJI_RARELY_USED,  // 腩
	0x816D, KANJI_RARELY_USED,  // 腭
	0x816F, KANJI_RARELY_USED,  // 腯
	0x8177, KANJI_RARELY_USED,  // 腷
	0x8181, KANJI_RARELY_USED,  // 膁
	0x8190, KANJI_RARELY_USED,  // 膐
	0x8184, KANJI_RARELY_USED,  // 膄
	0x8185, KANJI_RARELY_USED,  // 膅
	0x8186, KANJI_RARELY_USED,  // 膆
	0x818B, KANJI_RARELY_USED,  // 膋
	0x818E, KANJI_RARELY_USED,  // 膎
	0x8196, KANJI_RARELY_USED,  // 膖
	0x8198, KANJI_RARELY_USED,  // 膘
	0x819B, KANJI_RARELY_USED,  // 膛
	0x819E, KANJI_RARELY_USED,  // 膞
	0x81A2, KANJI_RARELY_USED,  // 膢
	0x81AE, KANJI_RARELY_USED,  // 膮
	0x81B2, KANJI_RARELY_USED,  // 膲
	0x81B4, KANJI_RARELY_USED,  // 膴
	0x81BB, KANJI_RARELY_USED,  // 膻
	0x81CB, KANJI_RARELY_USED,  // 臋
	0x81C3, KANJI_RARELY_USED,  // 臃
	0x81C5, KANJI_RARELY_USED,  // 臅
	0x81CA, KANJI_RARELY_USED,  // 臊
	0x81CE, KANJI_RARELY_USED,  // 臎
	0x81CF, KANJI_RARELY_USED,  // 臏
	0x81D5, KANJI_RARELY_USED,  // 臕
	0x81D7, KANJI_RARELY_USED,  // 臗
	0x81DB, KANJI_RARELY_USED,  // 臛
	0x81DD, KANJI_RARELY_USED,  // 臝
	0x81DE, KANJI_RARELY_USED,  // 臞
	0x81E1, KANJI_RARELY_USED,  // 臡
	0x81E4, KANJI_RARELY_USED,  // 臤
	0x81EB, KANJI_RARELY_USED,  // 臫
	0x81EC, KANJI_RARELY_USED,  // 臬
	0x81F0, KANJI_RARELY_USED,  // 臰
	0x81F1, KANJI_RARELY_USED,  // 臱
	0x81F2, KANJI_RARELY_USED,  // 臲
	0x81F5, KANJI_RARELY_USED,  // 臵
	0x81F6, KANJI_RARELY_USED,  // 臶
	0x81F8, KANJI_RARELY_USED,  // 臸
	0x81F9, KANJI_RARELY_USED,  // 臹
	0x81FD, KANJI_RARELY_USED,  // 臽
	0x81FF, KANJI_RARELY_USED,  // 臿
	0x8200, KANJI_RARELY_USED,  // 舀
	0x8203, KANJI_RARELY_USED,  // 舃
	0x820F, KANJI_RARELY_USED,  // 舏
	0x8213, KANJI_RARELY_USED,  // 舓
	0x8214, KANJI_RARELY_USED,  // 舔
	0x8219, KANJI_RARELY_USED,  // 舙
	0x821A, KANJI_RARELY_USED,  // 舚
	0x821D, KANJI_RARELY_USED,  // 舝
	0x8221, KANJI_RARELY_USED,  // 舡
	0x8222, KANJI_RARELY_USED,  // 舢
	0x8228, KANJI_RARELY_USED,  // 舨
	0x8232, KANJI_RARELY_USED,  // 舲
	0x8234, KANJI_RARELY_USED,  // 舴
	0x823A, KANJI_RARELY_USED,  // 舺
	0x8243, KANJI_RARELY_USED,  // 艃
	0x8244, KANJI_RARELY_USED,  // 艄
	0x8245, KANJI_RARELY_USED,  // 艅
	0x8246, KANJI_RARELY_USED,  // 艆
	0x824B, KANJI_RARELY_USED,  // 艋
	0x824E, KANJI_RARELY_USED,  // 艎
	0x824F, KANJI_RARELY_USED,  // 艏
	0x8251, KANJI_RARELY_USED,  // 艑
	0x8256, KANJI_RARELY_USED,  // 艖
	0x825C, KANJI_RARELY_USED,  // 艜
	0x8260, KANJI_RARELY_USED,  // 艠
	0x8263, KANJI_RARELY_USED,  // 艣
	0x8267, KANJI_RARELY_USED,  // 艧
	0x826D, KANJI_RARELY_USED,  // 艭
	0x8274, KANJI_RARELY_USED,  // 艴
	0x827B, KANJI_RARELY_USED,  // 艻
	0x827D, KANJI_RARELY_USED,  // 艽
	0x827F, KANJI_RARELY_USED,  // 艿
	0x8280, KANJI_RARELY_USED,  // 芀
	0x8281, KANJI_RARELY_USED,  // 芁
	0x8283, KANJI_RARELY_USED,  // 芃
	0x8284, KANJI_RARELY_USED,  // 芄
	0x8287, KANJI_RARELY_USED,  // 芇
	0x8289, KANJI_RARELY_USED,  // 芉
	0x828A, KANJI_RARELY_USED,  // 芊
	0x828E, KANJI_RARELY_USED,  // 芎
	0x8291, KANJI_RARELY_USED,  // 芑
	0x8294, KANJI_RARELY_USED,  // 芔
	0x8296, KANJI_RARELY_USED,  // 芖
	0x8298, KANJI_RARELY_USED,  // 芘
	0x829A, KANJI_RARELY_USED,  // 芚
	0x829B, KANJI_RARELY_USED,  // 芛
	0x82A0, KANJI_RARELY_USED,  // 芠
	0x82A1, KANJI_RARELY_USED,  // 芡
	0x82A3, KANJI_RARELY_USED,  // 芣
	0x82A4, KANJI_RARELY_USED,  // 芤
	0x82A7, KANJI_RARELY_USED,  // 芧
	0x82A8, KANJI_RARELY_USED,  // 芨
	0x82A9, KANJI_RARELY_USED,  // 芩
	0x82AA, KANJI_RARELY_USED,  // 芪
	0x82AE, KANJI_RARELY_USED,  // 芮
	0x82B0, KANJI_RARELY_USED,  // 芰
	0x82B2, KANJI_RARELY_USED,  // 芲
	0x82B4, KANJI_RARELY_USED,  // 芴
	0x82B7, KANJI_RARELY_USED,  // 芷
	0x82BA, KANJI_RARELY_USED,  // 芺
	0x82BC, KANJI_RARELY_USED,  // 芼
	0x82BE, KANJI_RARELY_USED,  // 芾
	0x82BF, KANJI_RARELY_USED,  // 芿
	0x82C6, KANJI_RARELY_USED,  // 苆
	0x82D0, KANJI_RARELY_USED,  // 苐
	0x82D5, KANJI_RARELY_USED,  // 苕
	0x82DA, KANJI_RARELY_USED,  // 苚
	0x82E0, KANJI_RARELY_USED,  // 苠
	0x82E2, KANJI_RARELY_USED,  // 苢
	0x82E4, KANJI_RARELY_USED,  // 苤
	0x82E8, KANJI_RARELY_USED,  // 苨
	0x82EA, KANJI_RARELY_USED,  // 苪
	0x82ED, KANJI_RARELY_USED,  // 苭
	0x82EF, KANJI_RARELY_USED,  // 苯
	0x82F6, KANJI_RARELY_USED,  // 苶
	0x82F7, KANJI_RARELY_USED,  // 苷
	0x82FD, KANJI_RARELY_USED,  // 苽
	0x82FE, KANJI_RARELY_USED,  // 苾
	0x8300, KANJI_RARELY_USED,  // 茀
	0x8301, KANJI_RARELY_USED,  // 茁
	0x8307, KANJI_RARELY_USED,  // 茇
	0x8308, KANJI_RARELY_USED,  // 茈
	0x830A, KANJI_RARELY_USED,  // 茊
	0x830B, KANJI_RARELY_USED,  // 茋
	0x8354, KANJI_RARELY_USED,  // 荔
	0x831B, KANJI_RARELY_USED,  // 茛
	0x831D, KANJI_RARELY_USED,  // 茝
	0x831E, KANJI_RARELY_USED,  // 茞
	0x831F, KANJI_RARELY_USED,  // 茟
	0x8321, KANJI_RARELY_USED,  // 茡
	0x8322, KANJI_RARELY_USED,  // 茢
	0x832C, KANJI_RARELY_USED,  // 茬
	0x832D, KANJI_RARELY_USED,  // 茭
	0x832E, KANJI_RARELY_USED,  // 茮
	0x8330, KANJI_RARELY_USED,  // 茰
	0x8333, KANJI_RARELY_USED,  // 茳
	0x8337, KANJI_RARELY_USED,  // 茷
	0x833A, KANJI_RARELY_USED,  // 茺
	0x833C, KANJI_RARELY_USED,  // 茼
	0x833D, KANJI_RARELY_USED,  // 茽
	0x8342, KANJI_RARELY_USED,  // 荂
	0x8343, KANJI_RARELY_USED,  // 荃
	0x8344, KANJI_RARELY_USED,  // 荄
	0x8347, KANJI_RARELY_USED,  // 荇
	0x834D, KANJI_RARELY_USED,  // 荍
	0x834E, KANJI_RARELY_USED,  // 荎
	0x8351, KANJI_RARELY_USED,  // 荑
	0x8355, KANJI_RARELY_USED,  // 荕
	0x8356, KANJI_RARELY_USED,  // 荖
	0x8357, KANJI_RARELY_USED,  // 荗
	0x8370, KANJI_RARELY_USED,  // 荰
	0x8378, KANJI_RARELY_USED,  // 荸
	0x837D, KANJI_RARELY_USED,  // 荽
	0x837F, KANJI_RARELY_USED,  // 荿
	0x8380, KANJI_RARELY_USED,  // 莀
	0x8382, KANJI_RARELY_USED,  // 莂
	0x8384, KANJI_RARELY_USED,  // 莄
	0x8386, KANJI_RARELY_USED,  // 莆
	0x838D, KANJI_RARELY_USED,  // 莍
	0x8392, KANJI_RARELY_USED,  // 莒
	0x8394, KANJI_RARELY_USED,  // 莔
	0x8395, KANJI_RARELY_USED,  // 莕
	0x8398, KANJI_RARELY_USED,  // 莘
	0x8399, KANJI_RARELY_USED,  // 莙
	0x839B, KANJI_RARELY_USED,  // 莛
	0x839C, KANJI_RARELY_USED,  // 莜
	0x839D, KANJI_RARELY_USED,  // 莝
	0x83A6, KANJI_RARELY_USED,  // 莦
	0x83A7, KANJI_RARELY_USED,  // 莧
	0x83A9, KANJI_RARELY_USED,  // 莩
	0x83AC, KANJI_RARELY_USED,  // 莬
	0x83BE, KANJI_RARELY_USED,  // 莾
	0x83BF, KANJI_RARELY_USED,  // 莿
	0x83C0, KANJI_RARELY_USED,  // 菀
	0x83C7, KANJI_RARELY_USED,  // 菇
	0x83C9, KANJI_RARELY_USED,  // 菉
	0x83CF, KANJI_RARELY_USED,  // 菏
	0x83D0, KANJI_RARELY_USED,  // 菐
	0x83D1, KANJI_RARELY_USED,  // 菑
	0x83D4, KANJI_RARELY_USED,  // 菔
	0x83DD, KANJI_RARELY_USED,  // 菝
	0x8353, KANJI_RARELY_USED,  // 荓
	0x83E8, KANJI_RARELY_USED,  // 菨
	0x83EA, KANJI_RARELY_USED,  // 菪
	0x83F6, KANJI_RARELY_USED,  // 菶
	0x83F8, KANJI_RARELY_USED,  // 菸
	0x83F9, KANJI_RARELY_USED,  // 菹
	0x83FC, KANJI_RARELY_USED,  // 菼
	0x8401, KANJI_RARELY_USED,  // 萁
	0x8406, KANJI_RARELY_USED,  // 萆
	0x840A, KANJI_RARELY_USED,  // 萊
	0x840F, KANJI_RARELY_USED,  // 萏
	0x8411, KANJI_RARELY_USED,  // 萑
	0x8415, KANJI_RARELY_USED,  // 萕
	0x8419, KANJI_RARELY_USED,  // 萙
	0x83AD, KANJI_RARELY_USED,  // 莭
	0x842F, KANJI_RARELY_USED,  // 萯
	0x8439, KANJI_RARELY_USED,  // 萹
	0x8445, KANJI_RARELY_USED,  // 葅
	0x8447, KANJI_RARELY_USED,  // 葇
	0x8448, KANJI_RARELY_USED,  // 葈
	0x844A, KANJI_RARELY_USED,  // 葊
	0x844D, KANJI_RARELY_USED,  // 葍
	0x844F, KANJI_RARELY_USED,  // 葏
	0x8451, KANJI_RARELY_USED,  // 葑
	0x8452, KANJI_RARELY_USED,  // 葒
	0x8456, KANJI_RARELY_USED,  // 葖
	0x8458, KANJI_RARELY_USED,  // 葘
	0x8459, KANJI_RARELY_USED,  // 葙
	0x845A, KANJI_RARELY_USED,  // 葚
	0x845C, KANJI_RARELY_USED,  // 葜
	0x8460, KANJI_RARELY_USED,  // 葠
	0x8464, KANJI_RARELY_USED,  // 葤
	0x8465, KANJI_RARELY_USED,  // 葥
	0x8467, KANJI_RARELY_USED,  // 葧
	0x846A, KANJI_RARELY_USED,  // 葪
	0x8470, KANJI_RARELY_USED,  // 葰
	0x8473, KANJI_RARELY_USED,  // 葳
	0x8474, KANJI_RARELY_USED,  // 葴
	0x8476, KANJI_RARELY_USED,  // 葶
	0x8478, KANJI_RARELY_USED,  // 葸
	0x847C, KANJI_RARELY_USED,  // 葼
	0x847D, KANJI_RARELY_USED,  // 葽
	0x8481, KANJI_RARELY_USED,  // 蒁
	0x8485, KANJI_RARELY_USED,  // 蒅
	0x8492, KANJI_RARELY_USED,  // 蒒
	0x8493, KANJI_RARELY_USED,  // 蒓
	0x8495, KANJI_RARELY_USED,  // 蒕
	0x849E, KANJI_RARELY_USED,  // 蒞
	0x84A6, KANJI_RARELY_USED,  // 蒦
	0x84A8, KANJI_RARELY_USED,  // 蒨
	0x84A9, KANJI_RARELY_USED,  // 蒩
	0x84AA, KANJI_RARELY_USED,  // 蒪
	0x84AF, KANJI_RARELY_USED,  // 蒯
	0x84B1, KANJI_RARELY_USED,  // 蒱
	0x84B4, KANJI_RARELY_USED,  // 蒴
	0x84BA, KANJI_RARELY_USED,  // 蒺
	0x84BD, KANJI_RARELY_USED,  // 蒽
	0x84BE, KANJI_RARELY_USED,  // 蒾
	0x84C0, KANJI_RARELY_USED,  // 蓀
	0x84C2, KANJI_RARELY_USED,  // 蓂
	0x84C7, KANJI_RARELY_USED,  // 蓇
	0x84C8, KANJI_RARELY_USED,  // 蓈
	0x84CC, KANJI_RARELY_USED,  // 蓌
	0x84CF, KANJI_RARELY_USED,  // 蓏
	0x84D3, KANJI_RARELY_USED,  // 蓓
	0x84DC, KANJI_RARELY_USED,  // 蓜
	0x84E7, KANJI_RARELY_USED,  // 蓧
	0x84EA, KANJI_RARELY_USED,  // 蓪
	0x84EF, KANJI_RARELY_USED,  // 蓯
	0x84F0, KANJI_RARELY_USED,  // 蓰
	0x84F1, KANJI_RARELY_USED,  // 蓱
	0x84F2, KANJI_RARELY_USED,  // 蓲
	0x84F7, KANJI_RARELY_USED,  // 蓷
	0x8532, KANJI_RARELY_USED,  // 蔲
	0x84FA, KANJI_RARELY_USED,  // 蓺
	0x84FB, KANJI_RARELY_USED,  // 蓻
	0x84FD, KANJI_RARELY_USED,  // 蓽
	0x8502, KANJI_RARELY_USED,  // 蔂
	0x8503, KANJI_RARELY_USED,  // 蔃
	0x8507, KANJI_RARELY_USED,  // 蔇
	0x850C, KANJI_RARELY_USED,  // 蔌
	0x850E, KANJI_RARELY_USED,  // 蔎
	0x8510, KANJI_RARELY_USED,  // 蔐
	0x851C, KANJI_RARELY_USED,  // 蔜
	0x851E, KANJI_RARELY_USED,  // 蔞
	0x8522, KANJI_RARELY_USED,  // 蔢
	0x8523, KANJI_RARELY_USED,  // 蔣
	0x8524, KANJI_RARELY_USED,  // 蔤
	0x8525, KANJI_RARELY_USED,  // 蔥
	0x8527, KANJI_RARELY_USED,  // 蔧
	0x852A, KANJI_RARELY_USED,  // 蔪
	0x852B, KANJI_RARELY_USED,  // 蔫
	0x852F, KANJI_RARELY_USED,  // 蔯
	0x8533, KANJI_RARELY_USED,  // 蔳
	0x8534, KANJI_RARELY_USED,  // 蔴
	0x8536, KANJI_RARELY_USED,  // 蔶
	0x853F, KANJI_RARELY_USED,  // 蔿
	0x8546, KANJI_RARELY_USED,  // 蕆
	0x854F, KANJI_RARELY_USED,  // 蕏
	0x8550, KANJI_RARELY_USED,  // 蕐
	0x8551, KANJI_RARELY_USED,  // 蕑
	0x8552, KANJI_RARELY_USED,  // 蕒
	0x8553, KANJI_RARELY_USED,  // 蕓
	0x8556, KANJI_RARELY_USED,  // 蕖
	0x8559, KANJI_RARELY_USED,  // 蕙
	0x855C, KANJI_RARELY_USED,  // 蕜
	0x855D, KANJI_RARELY_USED,  // 蕝
	0x855E, KANJI_RARELY_USED,  // 蕞
	0x855F, KANJI_RARELY_USED,  // 蕟
	0x8560, KANJI_RARELY_USED,  // 蕠
	0x8561, KANJI_RARELY_USED,  // 蕡
	0x8562, KANJI_RARELY_USED,  // 蕢
	0x8564, KANJI_RARELY_USED,  // 蕤
	0x856B, KANJI_RARELY_USED,  // 蕫
	0x856F, KANJI_RARELY_USED,  // 蕯
	0x8579, KANJI_RARELY_USED,  // 蕹
	0x857A, KANJI_RARELY_USED,  // 蕺
	0x857B, KANJI_RARELY_USED,  // 蕻
	0x857D, KANJI_RARELY_USED,  // 蕽
	0x857F, KANJI_RARELY_USED,  // 蕿
	0x8581, KANJI_RARELY_USED,  // 薁
	0x8585, KANJI_RARELY_USED,  // 薅
	0x8586, KANJI_RARELY_USED,  // 薆
	0x8589, KANJI_RARELY_USED,  // 薉
	0x858B, KANJI_RARELY_USED,  // 薋
	0x858C, KANJI_RARELY_USED,  // 薌
	0x858F, KANJI_RARELY_USED,  // 薏
	0x8593, KANJI_RARELY_USED,  // 薓
	0x8598, KANJI_RARELY_USED,  // 薘
	0x859D, KANJI_RARELY_USED,  // 薝
	0x859F, KANJI_RARELY_USED,  // 薟
	0x85A0, KANJI_RARELY_USED,  // 薠
	0x85A2, KANJI_RARELY_USED,  // 薢
	0x85A5, KANJI_RARELY_USED,  // 薥
	0x85A7, KANJI_RARELY_USED,  // 薧
	0x85B4, KANJI_RARELY_USED,  // 薴
	0x85B6, KANJI_RARELY_USED,  // 薶
	0x85B7, KANJI_RARELY_USED,  // 薷
	0x85B8, KANJI_RARELY_USED,  // 薸
	0x85BC, KANJI_RARELY_USED,  // 薼
	0x85BD, KANJI_RARELY_USED,  // 薽
	0x85BE, KANJI_RARELY_USED,  // 薾
	0x85BF, KANJI_RARELY_USED,  // 薿
	0x85C2, KANJI_RARELY_USED,  // 藂
	0x85C7, KANJI_RARELY_USED,  // 藇
	0x85CA, KANJI_RARELY_USED,  // 藊
	0x85CB, KANJI_RARELY_USED,  // 藋
	0x85CE, KANJI_RARELY_USED,  // 藎
	0x85AD, KANJI_RARELY_USED,  // 薭
	0x85D8, KANJI_RARELY_USED,  // 藘
	0x85DA, KANJI_RARELY_USED,  // 藚
	0x85DF, KANJI_RARELY_USED,  // 藟
	0x85E0, KANJI_RARELY_USED,  // 藠
	0x85E6, KANJI_RARELY_USED,  // 藦
	0x85E8, KANJI_RARELY_USED,  // 藨
	0x85ED, KANJI_RARELY_USED,  // 藭
	0x85F3, KANJI_RARELY_USED,  // 藳
	0x85F6, KANJI_RARELY_USED,  // 藶
	0x85FC, KANJI_RARELY_USED,  // 藼
	0x85FF, KANJI_RARELY_USED,  // 藿
	0x8600, KANJI_RARELY_USED,  // 蘀
	0x8604, KANJI_RARELY_USED,  // 蘄
	0x8605, KANJI_RARELY_USED,  // 蘅
	0x860D, KANJI_RARELY_USED,  // 蘍
	0x860E, KANJI_RARELY_USED,  // 蘎
	0x8610, KANJI_RARELY_USED,  // 蘐
	0x8611, KANJI_RARELY_USED,  // 蘑
	0x8612, KANJI_RARELY_USED,  // 蘒
	0x8618, KANJI_RARELY_USED,  // 蘘
	0x8619, KANJI_RARELY_USED,  // 蘙
	0x861B, KANJI_RARELY_USED,  // 蘛
	0x861E, KANJI_RARELY_USED,  // 蘞
	0x8621, KANJI_RARELY_USED,  // 蘡
	0x8627, KANJI_RARELY_USED,  // 蘧
	0x8629, KANJI_RARELY_USED,  // 蘩
	0x8636, KANJI_RARELY_USED,  // 蘶
	0x8638, KANJI_RARELY_USED,  // 蘸
	0x863A, KANJI_RARELY_USED,  // 蘺
	0x863C, KANJI_RARELY_USED,  // 蘼
	0x863D, KANJI_RARELY_USED,  // 蘽
	0x8640, KANJI_RARELY_USED,  // 虀
	0x8642, KANJI_RARELY_USED,  // 虂
	0x8646, KANJI_RARELY_USED,  // 虆
	0x8652, KANJI_RARELY_USED,  // 虒
	0x8653, KANJI_RARELY_USED,  // 虓
	0x8656, KANJI_RARELY_USED,  // 虖
	0x8657, KANJI_RARELY_USED,  // 虗
	0x8658, KANJI_RARELY_USED,  // 虘
	0x8659, KANJI_RARELY_USED,  // 虙
	0x865D, KANJI_RARELY_USED,  // 虝
	0x8660, KANJI_RARELY_USED,  // 虠
	0x8661, KANJI_RARELY_USED,  // 虡
	0x8662, KANJI_RARELY_USED,  // 虢
	0x8663, KANJI_RARELY_USED,  // 虣
	0x8664, KANJI_RARELY_USED,  // 虤
	0x8669, KANJI_RARELY_USED,  // 虩
	0x866C, KANJI_RARELY_USED,  // 虬
	0x866F, KANJI_RARELY_USED,  // 虯
	0x8675, KANJI_RARELY_USED,  // 虵
	0x8676, KANJI_RARELY_USED,  // 虶
	0x8677, KANJI_RARELY_USED,  // 虷
	0x867A, KANJI_RARELY_USED,  // 虺
	0x868D, KANJI_RARELY_USED,  // 蚍
	0x8691, KANJI_RARELY_USED,  // 蚑
	0x8696, KANJI_RARELY_USED,  // 蚖
	0x8698, KANJI_RARELY_USED,  // 蚘
	0x869A, KANJI_RARELY_USED,  // 蚚
	0x869C, KANJI_RARELY_USED,  // 蚜
	0x86A1, KANJI_RARELY_USED,  // 蚡
	0x86A6, KANJI_RARELY_USED,  // 蚦
	0x86A7, KANJI_RARELY_USED,  // 蚧
	0x86A8, KANJI_RARELY_USED,  // 蚨
	0x86AD, KANJI_RARELY_USED,  // 蚭
	0x86B1, KANJI_RARELY_USED,  // 蚱
	0x86B3, KANJI_RARELY_USED,  // 蚳
	0x86B4, KANJI_RARELY_USED,  // 蚴
	0x86B5, KANJI_RARELY_USED,  // 蚵
	0x86B7, KANJI_RARELY_USED,  // 蚷
	0x86B8, KANJI_RARELY_USED,  // 蚸
	0x86B9, KANJI_RARELY_USED,  // 蚹
	0x86BF, KANJI_RARELY_USED,  // 蚿
	0x86C0, KANJI_RARELY_USED,  // 蛀
	0x86C1, KANJI_RARELY_USED,  // 蛁
	0x86C3, KANJI_RARELY_USED,  // 蛃
	0x86C5, KANJI_RARELY_USED,  // 蛅
	0x86D1, KANJI_RARELY_USED,  // 蛑
	0x86D2, KANJI_RARELY_USED,  // 蛒
	0x86D5, KANJI_RARELY_USED,  // 蛕
	0x86D7, KANJI_RARELY_USED,  // 蛗
	0x86DA, KANJI_RARELY_USED,  // 蛚
	0x86DC, KANJI_RARELY_USED,  // 蛜
	0x86E0, KANJI_RARELY_USED,  // 蛠
	0x86E3, KANJI_RARELY_USED,  // 蛣
	0x86E5, KANJI_RARELY_USED,  // 蛥
	0x86E7, KANJI_RARELY_USED,  // 蛧
	0x8688, KANJI_RARELY_USED,  // 蚈
	0x86FA, KANJI_RARELY_USED,  // 蛺
	0x86FC, KANJI_RARELY_USED,  // 蛼
	0x86FD, KANJI_RARELY_USED,  // 蛽
	0x8704, KANJI_RARELY_USED,  // 蜄
	0x8705, KANJI_RARELY_USED,  // 蜅
	0x8707, KANJI_RARELY_USED,  // 蜇
	0x870B, KANJI_RARELY_USED,  // 蜋
	0x870E, KANJI_RARELY_USED,  // 蜎
	0x870F, KANJI_RARELY_USED,  // 蜏
	0x8710, KANJI_RARELY_USED,  // 蜐
	0x8713, KANJI_RARELY_USED,  // 蜓
	0x8714, KANJI_RARELY_USED,  // 蜔
	0x8719, KANJI_RARELY_USED,  // 蜙
	0x871E, KANJI_RARELY_USED,  // 蜞
	0x871F, KANJI_RARELY_USED,  // 蜟
	0x8721, KANJI_RARELY_USED,  // 蜡
	0x8723, KANJI_RARELY_USED,  // 蜣
	0x8728, KANJI_RARELY_USED,  // 蜨
	0x872E, KANJI_RARELY_USED,  // 蜮
	0x872F, KANJI_RARELY_USED,  // 蜯
	0x8731, KANJI_RARELY_USED,  // 蜱
	0x8732, KANJI_RARELY_USED,  // 蜲
	0x8739, KANJI_RARELY_USED,  // 蜹
	0x873A, KANJI_RARELY_USED,  // 蜺
	0x873C, KANJI_RARELY_USED,  // 蜼
	0x873D, KANJI_RARELY_USED,  // 蜽
	0x873E, KANJI_RARELY_USED,  // 蜾
	0x8740, KANJI_RARELY_USED,  // 蝀
	0x8743, KANJI_RARELY_USED,  // 蝃
	0x8745, KANJI_RARELY_USED,  // 蝅
	0x874D, KANJI_RARELY_USED,  // 蝍
	0x8758, KANJI_RARELY_USED,  // 蝘
	0x875D, KANJI_RARELY_USED,  // 蝝
	0x8761, KANJI_RARELY_USED,  // 蝡
	0x8764, KANJI_RARELY_USED,  // 蝤
	0x8765, KANJI_RARELY_USED,  // 蝥
	0x876F, KANJI_RARELY_USED,  // 蝯
	0x8771, KANJI_RARELY_USED,  // 蝱
	0x8772, KANJI_RARELY_USED,  // 蝲
	0x877B, KANJI_RARELY_USED,  // 蝻
	0x8783, KANJI_RARELY_USED,  // 螃
	0x8784, KANJI_RARELY_USED,  // 螄
	0x8785, KANJI_RARELY_USED,  // 螅
	0x8786, KANJI_RARELY_USED,  // 螆
	0x8787, KANJI_RARELY_USED,  // 螇
	0x8788, KANJI_RARELY_USED,  // 螈
	0x8789, KANJI_RARELY_USED,  // 螉
	0x878B, KANJI_RARELY_USED,  // 螋
	0x878C, KANJI_RARELY_USED,  // 螌
	0x8790, KANJI_RARELY_USED,  // 螐
	0x8793, KANJI_RARELY_USED,  // 螓
	0x8795, KANJI_RARELY_USED,  // 螕
	0x8797, KANJI_RARELY_USED,  // 螗
	0x8798, KANJI_RARELY_USED,  // 螘
	0x8799, KANJI_RARELY_USED,  // 螙
	0x879E, KANJI_RARELY_USED,  // 螞
	0x87A0, KANJI_RARELY_USED,  // 螠
	0x87A3, KANJI_RARELY_USED,  // 螣
	0x87A7, KANJI_RARELY_USED,  // 螧
	0x87AC, KANJI_RARELY_USED,  // 螬
	0x87AD, KANJI_RARELY_USED,  // 螭
	0x87AE, KANJI_RARELY_USED,  // 螮
	0x87B1, KANJI_RARELY_USED,  // 螱
	0x87B5, KANJI_RARELY_USED,  // 螵
	0x87BE, KANJI_RARELY_USED,  // 螾
	0x87BF, KANJI_RARELY_USED,  // 螿
	0x87C1, KANJI_RARELY_USED,  // 蟁
	0x87C8, KANJI_RARELY_USED,  // 蟈
	0x87C9, KANJI_RARELY_USED,  // 蟉
	0x87CA, KANJI_RARELY_USED,  // 蟊
	0x87CE, KANJI_RARELY_USED,  // 蟎
	0x87D5, KANJI_RARELY_USED,  // 蟕
	0x87D6, KANJI_RARELY_USED,  // 蟖
	0x87D9, KANJI_RARELY_USED,  // 蟙
	0x87DA, KANJI_RARELY_USED,  // 蟚
	0x87DC, KANJI_RARELY_USED,  // 蟜
	0x87DF, KANJI_RARELY_USED,  // 蟟
	0x87E2, KANJI_RARELY_USED,  // 蟢
	0x87E3, KANJI_RARELY_USED,  // 蟣
	0x87E4, KANJI_RARELY_USED,  // 蟤
	0x87EA, KANJI_RARELY_USED,  // 蟪
	0x87EB, KANJI_RARELY_USED,  // 蟫
	0x87ED, KANJI_RARELY_USED,  // 蟭
	0x87F1, KANJI_RARELY_USED,  // 蟱
	0x87F3, KANJI_RARELY_USED,  // 蟳
	0x87F8, KANJI_RARELY_USED,  // 蟸
	0x87FA, KANJI_RARELY_USED,  // 蟺
	0x87FF, KANJI_RARELY_USED,  // 蟿
	0x8801, KANJI_RARELY_USED,  // 蠁
	0x8803, KANJI_RARELY_USED,  // 蠃
	0x8806, KANJI_RARELY_USED,  // 蠆
	0x8809, KANJI_RARELY_USED,  // 蠉
	0x880A, KANJI_RARELY_USED,  // 蠊
	0x880B, KANJI_RARELY_USED,  // 蠋
	0x8810, KANJI_RARELY_USED,  // 蠐
	0x8819, KANJI_RARELY_USED,  // 蠙
	0x8812, KANJI_RARELY_USED,  // 蠒
	0x8813, KANJI_RARELY_USED,  // 蠓
	0x8814, KANJI_RARELY_USED,  // 蠔
	0x8818, KANJI_RARELY_USED,  // 蠘
	0x881A, KANJI_RARELY_USED,  // 蠚
	0x881B, KANJI_RARELY_USED,  // 蠛
	0x881C, KANJI_RARELY_USED,  // 蠜
	0x881E, KANJI_RARELY_USED,  // 蠞
	0x881F, KANJI_RARELY_USED,  // 蠟
	0x8828, KANJI_RARELY_USED,  // 蠨
	0x882D, KANJI_RARELY_USED,  // 蠭
	0x882E, KANJI_RARELY_USED,  // 蠮
	0x8830, KANJI_RARELY_USED,  // 蠰
	0x8832, KANJI_RARELY_USED,  // 蠲
	0x8835, KANJI_RARELY_USED,  // 蠵
	0x883A, KANJI_RARELY_USED,  // 蠺
	0x883C, KANJI_RARELY_USED,  // 蠼
	0x8841, KANJI_RARELY_USED,  // 衁
	0x8843, KANJI_RARELY_USED,  // 衃
	0x8845, KANJI_RARELY_USED,  // 衅
	0x8848, KANJI_RARELY_USED,  // 衈
	0x8849, KANJI_RARELY_USED,  // 衉
	0x884A, KANJI_RARELY_USED,  // 衊
	0x884B, KANJI_RARELY_USED,  // 衋
	0x884E, KANJI_RARELY_USED,  // 衎
	0x8851, KANJI_RARELY_USED,  // 衑
	0x8855, KANJI_RARELY_USED,  // 衕
	0x8856, KANJI_RARELY_USED,  // 衖
	0x8858, KANJI_RARELY_USED,  // 衘
	0x885A, KANJI_RARELY_USED,  // 衚
	0x885C, KANJI_RARELY_USED,  // 衜
	0x885F, KANJI_RARELY_USED,  // 衟
	0x8860, KANJI_RARELY_USED,  // 衠
	0x8864, KANJI_RARELY_USED,  // 衤
	0x8869, KANJI_RARELY_USED,  // 衩
	0x8871, KANJI_RARELY_USED,  // 衱
	0x8879, KANJI_RARELY_USED,  // 衹
	0x887B, KANJI_RARELY_USED,  // 衻
	0x8880, KANJI_RARELY_USED,  // 袀
	0x8898, KANJI_RARELY_USED,  // 袘
	0x889A, KANJI_RARELY_USED,  // 袚
	0x889B, KANJI_RARELY_USED,  // 袛
	0x889C, KANJI_RARELY_USED,  // 袜
	0x889F, KANJI_RARELY_USED,  // 袟
	0x88A0, KANJI_RARELY_USED,  // 袠
	0x88A8, KANJI_RARELY_USED,  // 袨
	0x88AA, KANJI_RARELY_USED,  // 袪
	0x88BA, KANJI_RARELY_USED,  // 袺
	0x88BD, KANJI_RARELY_USED,  // 袽
	0x88BE, KANJI_RARELY_USED,  // 袾
	0x88C0, KANJI_RARELY_USED,  // 裀
	0x88CA, KANJI_RARELY_USED,  // 裊
	0x88CB, KANJI_RARELY_USED,  // 裋
	0x88CC, KANJI_RARELY_USED,  // 裌
	0x88CD, KANJI_RARELY_USED,  // 裍
	0x88CE, KANJI_RARELY_USED,  // 裎
	0x88D1, KANJI_RARELY_USED,  // 裑
	0x88D2, KANJI_RARELY_USED,  // 裒
	0x88D3, KANJI_RARELY_USED,  // 裓
	0x88DB, KANJI_RARELY_USED,  // 裛
	0x88DE, KANJI_RARELY_USED,  // 裞
	0x88E7, KANJI_RARELY_USED,  // 裧
	0x88EF, KANJI_RARELY_USED,  // 裯
	0x88F0, KANJI_RARELY_USED,  // 裰
	0x88F1, KANJI_RARELY_USED,  // 裱
	0x88F5, KANJI_RARELY_USED,  // 裵
	0x88F7, KANJI_RARELY_USED,  // 裷
	0x8901, KANJI_RARELY_USED,  // 褁
	0x8906, KANJI_RARELY_USED,  // 褆
	0x890D, KANJI_RARELY_USED,  // 褍
	0x890E, KANJI_RARELY_USED,  // 褎
	0x890F, KANJI_RARELY_USED,  // 褏
	0x8915, KANJI_RARELY_USED,  // 褕
	0x8916, KANJI_RARELY_USED,  // 褖
	0x8918, KANJI_RARELY_USED,  // 褘
	0x8919, KANJI_RARELY_USED,  // 褙
	0x891A, KANJI_RARELY_USED,  // 褚
	0x891C, KANJI_RARELY_USED,  // 褜
	0x8920, KANJI_RARELY_USED,  // 褠
	0x8926, KANJI_RARELY_USED,  // 褦
	0x8927, KANJI_RARELY_USED,  // 褧
	0x8928, KANJI_RARELY_USED,  // 褨
	0x8930, KANJI_RARELY_USED,  // 褰
	0x8931, KANJI_RARELY_USED,  // 褱
	0x8932, KANJI_RARELY_USED,  // 褲
	0x8935, KANJI_RARELY_USED,  // 褵
	0x8939, KANJI_RARELY_USED,  // 褹
	0x893A, KANJI_RARELY_USED,  // 褺
	0x893E, KANJI_RARELY_USED,  // 褾
	0x8940, KANJI_RARELY_USED,  // 襀
	0x8942, KANJI_RARELY_USED,  // 襂
	0x8945, KANJI_RARELY_USED,  // 襅
	0x8946, KANJI_RARELY_USED,  // 襆
	0x8949, KANJI_RARELY_USED,  // 襉
	0x894F, KANJI_RARELY_USED,  // 襏
	0x8952, KANJI_RARELY_USED,  // 襒
	0x8957, KANJI_RARELY_USED,  // 襗
	0x895A, KANJI_RARELY_USED,  // 襚
	0x895B, KANJI_RARELY_USED,  // 襛
	0x895C, KANJI_RARELY_USED,  // 襜
	0x8961, KANJI_RARELY_USED,  // 襡
	0x8962, KANJI_RARELY_USED,  // 襢
	0x8963, KANJI_RARELY_USED,  // 襣
	0x896B, KANJI_RARELY_USED,  // 襫
	0x896E, KANJI_RARELY_USED,  // 襮
	0x8970, KANJI_RARELY_USED,  // 襰
	0x8973, KANJI_RARELY_USED,  // 襳
	0x8975, KANJI_RARELY_USED,  // 襵
	0x897A, KANJI_RARELY_USED,  // 襺
	0x897B, KANJI_RARELY_USED,  // 襻
	0x897C, KANJI_RARELY_USED,  // 襼
	0x897D, KANJI_RARELY_USED,  // 襽
	0x8989, KANJI_RARELY_USED,  // 覉
	0x898D, KANJI_RARELY_USED,  // 覍
	0x8990, KANJI_RARELY_USED,  // 覐
	0x8994, KANJI_RARELY_USED,  // 覔
	0x8995, KANJI_RARELY_USED,  // 覕
	0x899B, KANJI_RARELY_USED,  // 覛
	0x899C, KANJI_RARELY_USED,  // 覜
	0x899F, KANJI_RARELY_USED,  // 覟
	0x89A0, KANJI_RARELY_USED,  // 覠
	0x89A5, KANJI_RARELY_USED,  // 覥
	0x89B0, KANJI_RARELY_USED,  // 覰
	0x89B4, KANJI_RARELY_USED,  // 覴
	0x89B5, KANJI_RARELY_USED,  // 覵
	0x89B6, KANJI_RARELY_USED,  // 覶
	0x89B7, KANJI_RARELY_USED,  // 覷
	0x89BC, KANJI_RARELY_USED,  // 覼
	0x89D4, KANJI_RARELY_USED,  // 觔
	0x89D5, KANJI_RARELY_USED,  // 觕
	0x89D6, KANJI_RARELY_USED,  // 觖
	0x89D7, KANJI_RARELY_USED,  // 觗
	0x89D8, KANJI_RARELY_USED,  // 觘
	0x89E5, KANJI_RARELY_USED,  // 觥
	0x89E9, KANJI_RARELY_USED,  // 觩
	0x89EB, KANJI_RARELY_USED,  // 觫
	0x89ED, KANJI_RARELY_USED,  // 觭
	0x89F1, KANJI_RARELY_USED,  // 觱
	0x89F3, KANJI_RARELY_USED,  // 觳
	0x89F6, KANJI_RARELY_USED,  // 觶
	0x89F9, KANJI_RARELY_USED,  // 觹
	0x89FD, KANJI_RARELY_USED,  // 觽
	0x89FF, KANJI_RARELY_USED,  // 觿
	0x8A04, KANJI_RARELY_USED,  // 訄
	0x8A05, KANJI_RARELY_USED,  // 訅
	0x8A07, KANJI_RARELY_USED,  // 訇
	0x8A0F, KANJI_RARELY_USED,  // 訏
	0x8A11, KANJI_RARELY_USED,  // 訑
	0x8A12, KANJI_RARELY_USED,  // 訒
	0x8A14, KANJI_RARELY_USED,  // 訔
	0x8A15, KANJI_RARELY_USED,  // 訕
	0x8A1E, KANJI_RARELY_USED,  // 訞
	0x8A20, KANJI_RARELY_USED,  // 訠
	0x8A22, KANJI_RARELY_USED,  // 訢
	0x8A24, KANJI_RARELY_USED,  // 訤
	0x8A26, KANJI_RARELY_USED,  // 訦
	0x8A2B, KANJI_RARELY_USED,  // 訫
	0x8A2C, KANJI_RARELY_USED,  // 訬
	0x8A2F, KANJI_RARELY_USED,  // 訯
	0x8A35, KANJI_RARELY_USED,  // 訵
	0x8A37, KANJI_RARELY_USED,  // 訷
	0x8A3D, KANJI_RARELY_USED,  // 訽
	0x8A3E, KANJI_RARELY_USED,  // 訾
	0x8A40, KANJI_RARELY_USED,  // 詀
	0x8A43, KANJI_RARELY_USED,  // 詃
	0x8A45, KANJI_RARELY_USED,  // 詅
	0x8A47, KANJI_RARELY_USED,  // 詇
	0x8A49, KANJI_RARELY_USED,  // 詉
	0x8A4D, KANJI_RARELY_USED,  // 詍
	0x8A4E, KANJI_RARELY_USED,  // 詎
	0x8A53, KANJI_RARELY_USED,  // 詓
	0x8A56, KANJI_RARELY_USED,  // 詖
	0x8A57, KANJI_RARELY_USED,  // 詗
	0x8A58, KANJI_RARELY_USED,  // 詘
	0x8A5C, KANJI_RARELY_USED,  // 詜
	0x8A5D, KANJI_RARELY_USED,  // 詝
	0x8A61, KANJI_RARELY_USED,  // 詡
	0x8A65, KANJI_RARELY_USED,  // 詥
	0x8A67, KANJI_RARELY_USED,  // 詧
	0x8A75, KANJI_RARELY_USED,  // 詵
	0x8A76, KANJI_RARELY_USED,  // 詶
	0x8A77, KANJI_RARELY_USED,  // 詷
	0x8A79, KANJI_RARELY_USED,  // 詹
	0x8A7A, KANJI_RARELY_USED,  // 詺
	0x8A7B, KANJI_RARELY_USED,  // 詻
	0x8A7E, KANJI_RARELY_USED,  // 詾
	0x8A7F, KANJI_RARELY_USED,  // 詿
	0x8A80, KANJI_RARELY_USED,  // 誀
	0x8A83, KANJI_RARELY_USED,  // 誃
	0x8A86, KANJI_RARELY_USED,  // 誆
	0x8A8B, KANJI_RARELY_USED,  // 誋
	0x8A8F, KANJI_RARELY_USED,  // 誏
	0x8A90, KANJI_RARELY_USED,  // 誐
	0x8A92, KANJI_RARELY_USED,  // 誒
	0x8A96, KANJI_RARELY_USED,  // 誖
	0x8A97, KANJI_RARELY_USED,  // 誗
	0x8A99, KANJI_RARELY_USED,  // 誙
	0x8A9F, KANJI_RARELY_USED,  // 誟
	0x8AA7, KANJI_RARELY_USED,  // 誧
	0x8AA9, KANJI_RARELY_USED,  // 誩
	0x8AAE, KANJI_RARELY_USED,  // 誮
	0x8AAF, KANJI_RARELY_USED,  // 誯
	0x8AB3, KANJI_RARELY_USED,  // 誳
	0x8AB6, KANJI_RARELY_USED,  // 誶
	0x8AB7, KANJI_RARELY_USED,  // 誷
	0x8ABB, KANJI_RARELY_USED,  // 誻
	0x8ABE, KANJI_RARELY_USED,  // 誾
	0x8AC3, KANJI_RARELY_USED,  // 諃
	0x8AC6, KANJI_RARELY_USED,  // 諆
	0x8AC8, KANJI_RARELY_USED,  // 諈
	0x8AC9, KANJI_RARELY_USED,  // 諉
	0x8ACA, KANJI_RARELY_USED,  // 諊
	0x8AD1, KANJI_RARELY_USED,  // 諑
	0x8AD3, KANJI_RARELY_USED,  // 諓
	0x8AD4, KANJI_RARELY_USED,  // 諔
	0x8AD5, KANJI_RARELY_USED,  // 諕
	0x8AD7, KANJI_RARELY_USED,  // 諗
	0x8ADD, KANJI_RARELY_USED,  // 諝
	0x8ADF, KANJI_RARELY_USED,  // 諟
	0x8AEC, KANJI_RARELY_USED,  // 諬
	0x8AF0, KANJI_RARELY_USED,  // 諰
	0x8AF4, KANJI_RARELY_USED,  // 諴
	0x8AF5, KANJI_RARELY_USED,  // 諵
	0x8AF6, KANJI_RARELY_USED,  // 諶
	0x8AFC, KANJI_RARELY_USED,  // 諼
	0x8AFF, KANJI_RARELY_USED,  // 諿
	0x8B05, KANJI_RARELY_USED,  // 謅
	0x8B06, KANJI_RARELY_USED,  // 謆
	0x8B0B, KANJI_RARELY_USED,  // 謋
	0x8B11, KANJI_RARELY_USED,  // 謑
	0x8B1C, KANJI_RARELY_USED,  // 謜
	0x8B1E, KANJI_RARELY_USED,  // 謞
	0x8B1F, KANJI_RARELY_USED,  // 謟
	0x8B0A, KANJI_RARELY_USED,  // 謊
	0x8B2D, KANJI_RARELY_USED,  // 謭
	0x8B30, KANJI_RARELY_USED,  // 謰
	0x8B37, KANJI_RARELY_USED,  // 謷
	0x8B3C, KANJI_RARELY_USED,  // 謼
	0x8B42, KANJI_RARELY_USED,  // 譂
	0x8B43, KANJI_RARELY_USED,  // 譃
	0x8B44, KANJI_RARELY_USED,  // 譄
	0x8B45, KANJI_RARELY_USED,  // 譅
	0x8B46, KANJI_RARELY_USED,  // 譆
	0x8B48, KANJI_RARELY_USED,  // 譈
	0x8B52, KANJI_RARELY_USED,  // 譒
	0x8B53, KANJI_RARELY_USED,  // 譓
	0x8B54, KANJI_RARELY_USED,  // 譔
	0x8B59, KANJI_RARELY_USED,  // 譙
	0x8B4D, KANJI_RARELY_USED,  // 譍
	0x8B5E, KANJI_RARELY_USED,  // 譞
	0x8B63, KANJI_RARELY_USED,  // 譣
	0x8B6D, KANJI_RARELY_USED,  // 譭
	0x8B76, KANJI_RARELY_USED,  // 譶
	0x8B78, KANJI_RARELY_USED,  // 譸
	0x8B79, KANJI_RARELY_USED,  // 譹
	0x8B7C, KANJI_RARELY_USED,  // 譼
	0x8B7E, KANJI_RARELY_USED,  // 譾
	0x8B81, KANJI_RARELY_USED,  // 讁
	0x8B84, KANJI_RARELY_USED,  // 讄
	0x8B85, KANJI_RARELY_USED,  // 讅
	0x8B8B, KANJI_RARELY_USED,  // 讋
	0x8B8D, KANJI_RARELY_USED,  // 讍
	0x8B8F, KANJI_RARELY_USED,  // 讏
	0x8B94, KANJI_RARELY_USED,  // 讔
	0x8B95, KANJI_RARELY_USED,  // 讕
	0x8B9C, KANJI_RARELY_USED,  // 讜
	0x8B9E, KANJI_RARELY_USED,  // 讞
	0x8B9F, KANJI_RARELY_USED,  // 讟
	0x8C38, KANJI_RARELY_USED,  // 谸
	0x8C39, KANJI_RARELY_USED,  // 谹
	0x8C3D, KANJI_RARELY_USED,  // 谽
	0x8C3E, KANJI_RARELY_USED,  // 谾
	0x8C45, KANJI_RARELY_USED,  // 豅
	0x8C47, KANJI_RARELY_USED,  // 豇
	0x8C49, KANJI_RARELY_USED,  // 豉
	0x8C4B, KANJI_RARELY_USED,  // 豋
	0x8C4F, KANJI_RARELY_USED,  // 豏
	0x8C51, KANJI_RARELY_USED,  // 豑
	0x8C53, KANJI_RARELY_USED,  // 豓
	0x8C54, KANJI_RARELY_USED,  // 豔
	0x8C57, KANJI_RARELY_USED,  // 豗
	0x8C58, KANJI_RARELY_USED,  // 豘
	0x8C5B, KANJI_RARELY_USED,  // 豛
	0x8C5D, KANJI_RARELY_USED,  // 豝
	0x8C59, KANJI_RARELY_USED,  // 豙
	0x8C63, KANJI_RARELY_USED,  // 豣
	0x8C64, KANJI_RARELY_USED,  // 豤
	0x8C66, KANJI_RARELY_USED,  // 豦
	0x8C68, KANJI_RARELY_USED,  // 豨
	0x8C69, KANJI_RARELY_USED,  // 豩
	0x8C6D, KANJI_RARELY_USED,  // 豭
	0x8C73, KANJI_RARELY_USED,  // 豳
	0x8C75, KANJI_RARELY_USED,  // 豵
	0x8C76, KANJI_RARELY_USED,  // 豶
	0x8C7B, KANJI_RARELY_USED,  // 豻
	0x8C7E, KANJI_RARELY_USED,  // 豾
	0x8C86, KANJI_RARELY_USED,  // 貆
	0x8C87, KANJI_RARELY_USED,  // 貇
	0x8C8B, KANJI_RARELY_USED,  // 貋
	0x8C90, KANJI_RARELY_USED,  // 貐
	0x8C92, KANJI_RARELY_USED,  // 貒
	0x8C93, KANJI_RARELY_USED,  // 貓
	0x8C99, KANJI_RARELY_USED,  // 貙
	0x8C9B, KANJI_RARELY_USED,  // 貛
	0x8C9C, KANJI_RARELY_USED,  // 貜
	0x8CA4, KANJI_RARELY_USED,  // 貤
	0x8CB9, KANJI_RARELY_USED,  // 貹
	0x8CBA, KANJI_RARELY_USED,  // 貺
	0x8CC5, KANJI_RARELY_USED,  // 賅
	0x8CC6, KANJI_RARELY_USED,  // 賆
	0x8CC9, KANJI_RARELY_USED,  // 賉
	0x8CCB, KANJI_RARELY_USED,  // 賋
	0x8CCF, KANJI_RARELY_USED,  // 賏
	0x8CD6, KANJI_RARELY_USED,  // 賖
	0x8CD5, KANJI_RARELY_USED,  // 賕
	0x8CD9, KANJI_RARELY_USED,  // 賙
	0x8CDD, KANJI_RARELY_USED,  // 賝
	0x8CE1, KANJI_RARELY_USED,  // 賡
	0x8CE8, KANJI_RARELY_USED,  // 賨
	0x8CEC, KANJI_RARELY_USED,  // 賬
	0x8CEF, KANJI_RARELY_USED,  // 賯
	0x8CF0, KANJI_RARELY_USED,  // 賰
	0x8CF2, KANJI_RARELY_USED,  // 賲
	0x8CF5, KANJI_RARELY_USED,  // 賵
	0x8CF7, KANJI_RARELY_USED,  // 賷
	0x8CF8, KANJI_RARELY_USED,  // 賸
	0x8CFE, KANJI_RARELY_USED,  // 賾
	0x8CFF, KANJI_RARELY_USED,  // 賿
	0x8D01, KANJI_RARELY_USED,  // 贁
	0x8D03, KANJI_RARELY_USED,  // 贃
	0x8D09, KANJI_RARELY_USED,  // 贉
	0x8D12, KANJI_RARELY_USED,  // 贒
	0x8D17, KANJI_RARELY_USED,  // 贗
	0x8D1B, KANJI_RARELY_USED,  // 贛
	0x8D65, KANJI_RARELY_USED,  // 赥
	0x8D69, KANJI_RARELY_USED,  // 赩
	0x8D6C, KANJI_RARELY_USED,  // 赬
	0x8D6E, KANJI_RARELY_USED,  // 赮
	0x8D7F, KANJI_RARELY_USED,  // 赿
	0x8D82, KANJI_RARELY_USED,  // 趂
	0x8D84, KANJI_RARELY_USED,  // 趄
	0x8D88, KANJI_RARELY_USED,  // 趈
	0x8D8D, KANJI_RARELY_USED,  // 趍
	0x8D90, KANJI_RARELY_USED,  // 趐
	0x8D91, KANJI_RARELY_USED,  // 趑
	0x8D95, KANJI_RARELY_USED,  // 趕
	0x8D9E, KANJI_RARELY_USED,  // 趞
	0x8D9F, KANJI_RARELY_USED,  // 趟
	0x8DA0, KANJI_RARELY_USED,  // 趠
	0x8DA6, KANJI_RARELY_USED,  // 趦
	0x8DAB, KANJI_RARELY_USED,  // 趫
	0x8DAC, KANJI_RARELY_USED,  // 趬
	0x8DAF, KANJI_RARELY_USED,  // 趯
	0x8DB2, KANJI_RARELY_USED,  // 趲
	0x8DB5, KANJI_RARELY_USED,  // 趵
	0x8DB7, KANJI_RARELY_USED,  // 趷
	0x8DB9, KANJI_RARELY_USED,  // 趹
	0x8DBB, KANJI_RARELY_USED,  // 趻
	0x8DC0, KANJI_RARELY_USED,  // 跀
	0x8DC5, KANJI_RARELY_USED,  // 跅
	0x8DC6, KANJI_RARELY_USED,  // 跆
	0x8DC7, KANJI_RARELY_USED,  // 跇
	0x8DC8, KANJI_RARELY_USED,  // 跈
	0x8DCA, KANJI_RARELY_USED,  // 跊
	0x8DCE, KANJI_RARELY_USED,  // 跎
	0x8DD1, KANJI_RARELY_USED,  // 跑
	0x8DD4, KANJI_RARELY_USED,  // 跔
	0x8DD5, KANJI_RARELY_USED,  // 跕
	0x8DD7, KANJI_RARELY_USED,  // 跗
	0x8DD9, KANJI_RARELY_USED,  // 跙
	0x8DE4, KANJI_RARELY_USED,  // 跤
	0x8DE5, KANJI_RARELY_USED,  // 跥
	0x8DE7, KANJI_RARELY_USED,  // 跧
	0x8DEC, KANJI_RARELY_USED,  // 跬
	0x8DF0, KANJI_RARELY_USED,  // 跰
	0x8DBC, KANJI_RARELY_USED,  // 趼
	0x8DF1, KANJI_RARELY_USED,  // 跱
	0x8DF2, KANJI_RARELY_USED,  // 跲
	0x8DF4, KANJI_RARELY_USED,  // 跴
	0x8DFD, KANJI_RARELY_USED,  // 跽
	0x8E01, KANJI_RARELY_USED,  // 踁
	0x8E04, KANJI_RARELY_USED,  // 踄
	0x8E05, KANJI_RARELY_USED,  // 踅
	0x8E06, KANJI_RARELY_USED,  // 踆
	0x8E0B, KANJI_RARELY_USED,  // 踋
	0x8E11, KANJI_RARELY_USED,  // 踑
	0x8E14, KANJI_RARELY_USED,  // 踔
	0x8E16, KANJI_RARELY_USED,  // 踖
	0x8E20, KANJI_RARELY_USED,  // 踠
	0x8E21, KANJI_RARELY_USED,  // 踡
	0x8E22, KANJI_RARELY_USED,  // 踢
	0x8E23, KANJI_RARELY_USED,  // 踣
	0x8E26, KANJI_RARELY_USED,  // 踦
	0x8E27, KANJI_RARELY_USED,  // 踧
	0x8E31, KANJI_RARELY_USED,  // 踱
	0x8E33, KANJI_RARELY_USED,  // 踳
	0x8E36, KANJI_RARELY_USED,  // 踶
	0x8E37, KANJI_RARELY_USED,  // 踷
	0x8E38, KANJI_RARELY_USED,  // 踸
	0x8E39, KANJI_RARELY_USED,  // 踹
	0x8E3D, KANJI_RARELY_USED,  // 踽
	0x8E40, KANJI_RARELY_USED,  // 蹀
	0x8E41, KANJI_RARELY_USED,  // 蹁
	0x8E4B, KANJI_RARELY_USED,  // 蹋
	0x8E4D, KANJI_RARELY_USED,  // 蹍
	0x8E4E, KANJI_RARELY_USED,  // 蹎
	0x8E4F, KANJI_RARELY_USED,  // 蹏
	0x8E54, KANJI_RARELY_USED,  // 蹔
	0x8E5B, KANJI_RARELY_USED,  // 蹛
	0x8E5C, KANJI_RARELY_USED,  // 蹜
	0x8E5D, KANJI_RARELY_USED,  // 蹝
	0x8E5E, KANJI_RARELY_USED,  // 蹞
	0x8E61, KANJI_RARELY_USED,  // 蹡
	0x8E62, KANJI_RARELY_USED,  // 蹢
	0x8E69, KANJI_RARELY_USED,  // 蹩
	0x8E6C, KANJI_RARELY_USED,  // 蹬
	0x8E6D, KANJI_RARELY_USED,  // 蹭
	0x8E6F, KANJI_RARELY_USED,  // 蹯
	0x8E70, KANJI_RARELY_USED,  // 蹰
	0x8E71, KANJI_RARELY_USED,  // 蹱
	0x8E79, KANJI_RARELY_USED,  // 蹹
	0x8E7A, KANJI_RARELY_USED,  // 蹺
	0x8E7B, KANJI_RARELY_USED,  // 蹻
	0x8E82, KANJI_RARELY_USED,  // 躂
	0x8E83, KANJI_RARELY_USED,  // 躃
	0x8E89, KANJI_RARELY_USED,  // 躉
	0x8E90, KANJI_RARELY_USED,  // 躐
	0x8E92, KANJI_RARELY_USED,  // 躒
	0x8E95, KANJI_RARELY_USED,  // 躕
	0x8E9A, KANJI_RARELY_USED,  // 躚
	0x8E9B, KANJI_RARELY_USED,  // 躛
	0x8E9D, KANJI_RARELY_USED,  // 躝
	0x8E9E, KANJI_RARELY_USED,  // 躞
	0x8EA2, KANJI_RARELY_USED,  // 躢
	0x8EA7, KANJI_RARELY_USED,  // 躧
	0x8EA9, KANJI_RARELY_USED,  // 躩
	0x8EAD, KANJI_RARELY_USED,  // 躭
	0x8EAE, KANJI_RARELY_USED,  // 躮
	0x8EB3, KANJI_RARELY_USED,  // 躳
	0x8EB5, KANJI_RARELY_USED,  // 躵
	0x8EBA, KANJI_RARELY_USED,  // 躺
	0x8EBB, KANJI_RARELY_USED,  // 躻
	0x8EC0, KANJI_RARELY_USED,  // 軀
	0x8EC1, KANJI_RARELY_USED,  // 軁
	0x8EC3, KANJI_RARELY_USED,  // 軃
	0x8EC4, KANJI_RARELY_USED,  // 軄
	0x8EC7, KANJI_RARELY_USED,  // 軇
	0x8ECF, KANJI_RARELY_USED,  // 軏
	0x8ED1, KANJI_RARELY_USED,  // 軑
	0x8ED4, KANJI_RARELY_USED,  // 軔
	0x8EDC, KANJI_RARELY_USED,  // 軜
	0x8EE8, KANJI_RARELY_USED,  // 軨
	0x8EEE, KANJI_RARELY_USED,  // 軮
	0x8EF0, KANJI_RARELY_USED,  // 軰
	0x8EF1, KANJI_RARELY_USED,  // 軱
	0x8EF7, KANJI_RARELY_USED,  // 軷
	0x8EF9, KANJI_RARELY_USED,  // 軹
	0x8EFA, KANJI_RARELY_USED,  // 軺
	0x8EED, KANJI_RARELY_USED,  // 軭
	0x8F00, KANJI_RARELY_USED,  // 輀
	0x8F02, KANJI_RARELY_USED,  // 輂
	0x8F07, KANJI_RARELY_USED,  // 輇
	0x8F08, KANJI_RARELY_USED,  // 輈
	0x8F0F, KANJI_RARELY_USED,  // 輏
	0x8F10, KANJI_RARELY_USED,  // 輐
	0x8F16, KANJI_RARELY_USED,  // 輖
	0x8F17, KANJI_RARELY_USED,  // 輗
	0x8F18, KANJI_RARELY_USED,  // 輘
	0x8F1E, KANJI_RARELY_USED,  // 輞
	0x8F20, KANJI_RARELY_USED,  // 輠
	0x8F21, KANJI_RARELY_USED,  // 輡
	0x8F23, KANJI_RARELY_USED,  // 輣
	0x8F25, KANJI_RARELY_USED,  // 輥
	0x8F27, KANJI_RARELY_USED,  // 輧
	0x8F28, KANJI_RARELY_USED,  // 輨
	0x8F2C, KANJI_RARELY_USED,  // 輬
	0x8F2D, KANJI_RARELY_USED,  // 輭
	0x8F2E, KANJI_RARELY_USED,  // 輮
	0x8F34, KANJI_RARELY_USED,  // 輴
	0x8F35, KANJI_RARELY_USED,  // 輵
	0x8F36, KANJI_RARELY_USED,  // 輶
	0x8F37, KANJI_RARELY_USED,  // 輷
	0x8F3A, KANJI_RARELY_USED,  // 輺
	0x8F40, KANJI_RARELY_USED,  // 轀
	0x8F41, KANJI_RARELY_USED,  // 轁
	0x8F43, KANJI_RARELY_USED,  // 轃
	0x8F47, KANJI_RARELY_USED,  // 轇
	0x8F4F, KANJI_RARELY_USED,  // 轏
	0x8F51, KANJI_RARELY_USED,  // 轑
	0x8F52, KANJI_RARELY_USED,  // 轒
	0x8F53, KANJI_RARELY_USED,  // 轓
	0x8F54, KANJI_RARELY_USED,  // 轔
	0x8F55, KANJI_RARELY_USED,  // 轕
	0x8F58, KANJI_RARELY_USED,  // 轘
	0x8F5D, KANJI_RARELY_USED,  // 轝
	0x8F5E, KANJI_RARELY_USED,  // 轞
	0x8F65, KANJI_RARELY_USED,  // 轥
	0x8F9D, KANJI_RARELY_USED,  // 辝
	0x8FA0, KANJI_RARELY_USED,  // 辠
	0x8FA1, KANJI_RARELY_USED,  // 辡
	0x8FA4, KANJI_RARELY_USED,  // 辤
	0x8FA5, KANJI_RARELY_USED,  // 辥
	0x8FA6, KANJI_RARELY_USED,  // 辦
	0x8FB5, KANJI_RARELY_USED,  // 辵
	0x8FB6, KANJI_RARELY_USED,  // 辶
	0x8FB8, KANJI_RARELY_USED,  // 辸
	0x8FBE, KANJI_RARELY_USED,  // 达
	0x8FC0, KANJI_RARELY_USED,  // 迀
	0x8FC1, KANJI_RARELY_USED,  // 迁
	0x8FC6, KANJI_RARELY_USED,  // 迆
	0x8FCA, KANJI_RARELY_USED,  // 迊
	0x8FCB, KANJI_RARELY_USED,  // 迋
	0x8FCD, KANJI_RARELY_USED,  // 迍
	0x8FD0, KANJI_RARELY_USED,  // 运
	0x8FD2, KANJI_RARELY_USED,  // 迒
	0x8FD3, KANJI_RARELY_USED,  // 迓
	0x8FD5, KANJI_RARELY_USED,  // 迕
	0x8FE0, KANJI_RARELY_USED,  // 迠
	0x8FE3, KANJI_RARELY_USED,  // 迣
	0x8FE4, KANJI_RARELY_USED,  // 迤
	0x8FE8, KANJI_RARELY_USED,  // 迨
	0x8FEE, KANJI_RARELY_USED,  // 迮
	0x8FF1, KANJI_RARELY_USED,  // 迱
	0x8FF5, KANJI_RARELY_USED,  // 迵
	0x8FF6, KANJI_RARELY_USED,  // 迶
	0x8FFB, KANJI_RARELY_USED,  // 迻
	0x8FFE, KANJI_RARELY_USED,  // 迾
	0x9002, KANJI_RARELY_USED,  // 适
	0x9004, KANJI_RARELY_USED,  // 逄
	0x9008, KANJI_RARELY_USED,  // 逈
	0x900C, KANJI_RARELY_USED,  // 逌
	0x9018, KANJI_RARELY_USED,  // 逘
	0x901B, KANJI_RARELY_USED,  // 逛
	0x9028, KANJI_RARELY_USED,  // 逨
	0x9029, KANJI_RARELY_USED,  // 逩
	0x902F, KANJI_RARELY_USED,  // 逯
	0x902A, KANJI_RARELY_USED,  // 逪
	0x902C, KANJI_RARELY_USED,  // 逬
	0x902D, KANJI_RARELY_USED,  // 逭
	0x9033, KANJI_RARELY_USED,  // 逳
	0x9034, KANJI_RARELY_USED,  // 逴
	0x9037, KANJI_RARELY_USED,  // 逷
	0x903F, KANJI_RARELY_USED,  // 逿
	0x9043, KANJI_RARELY_USED,  // 遃
	0x9044, KANJI_RARELY_USED,  // 遄
	0x904C, KANJI_RARELY_USED,  // 遌
	0x905B, KANJI_RARELY_USED,  // 遛
	0x905D, KANJI_RARELY_USED,  // 遝
	0x9062, KANJI_RARELY_USED,  // 遢
	0x9066, KANJI_RARELY_USED,  // 遦
	0x9067, KANJI_RARELY_USED,  // 遧
	0x906C, KANJI_RARELY_USED,  // 遬
	0x9070, KANJI_RARELY_USED,  // 遰
	0x9074, KANJI_RARELY_USED,  // 遴
	0x9079, KANJI_RARELY_USED,  // 遹
	0x9085, KANJI_RARELY_USED,  // 邅
	0x9088, KANJI_RARELY_USED,  // 邈
	0x908B, KANJI_RARELY_USED,  // 邋
	0x908C, KANJI_RARELY_USED,  // 邌
	0x908E, KANJI_RARELY_USED,  // 邎
	0x9090, KANJI_RARELY_USED,  // 邐
	0x9095, KANJI_RARELY_USED,  // 邕
	0x9097, KANJI_RARELY_USED,  // 邗
	0x9098, KANJI_RARELY_USED,  // 邘
	0x9099, KANJI_RARELY_USED,  // 邙
	0x909B, KANJI_RARELY_USED,  // 邛
	0x90A0, KANJI_RARELY_USED,  // 邠
	0x90A1, KANJI_RARELY_USED,  // 邡
	0x90A2, KANJI_RARELY_USED,  // 邢
	0x90A5, KANJI_RARELY_USED,  // 邥
	0x90B0, KANJI_RARELY_USED,  // 邰
	0x90B2, KANJI_RARELY_USED,  // 邲
	0x90B3, KANJI_RARELY_USED,  // 邳
	0x90B4, KANJI_RARELY_USED,  // 邴
	0x90B6, KANJI_RARELY_USED,  // 邶
	0x90BD, KANJI_RARELY_USED,  // 邽
	0x90CC, KANJI_RARELY_USED,  // 郌
	0x90BE, KANJI_RARELY_USED,  // 邾
	0x90C3, KANJI_RARELY_USED,  // 郃
	0x90C4, KANJI_RARELY_USED,  // 郄
	0x90C5, KANJI_RARELY_USED,  // 郅
	0x90C7, KANJI_RARELY_USED,  // 郇
	0x90C8, KANJI_RARELY_USED,  // 郈
	0x90D5, KANJI_RARELY_USED,  // 郕
	0x90D7, KANJI_RARELY_USED,  // 郗
	0x90D8, KANJI_RARELY_USED,  // 郘
	0x90D9, KANJI_RARELY_USED,  // 郙
	0x90DC, KANJI_RARELY_USED,  // 郜
	0x90DD, KANJI_RARELY_USED,  // 郝
	0x90DF, KANJI_RARELY_USED,  // 郟
	0x90E5, KANJI_RARELY_USED,  // 郥
	0x90D2, KANJI_RARELY_USED,  // 郒
	0x90F6, KANJI_RARELY_USED,  // 郶
	0x90EB, KANJI_RARELY_USED,  // 郫
	0x90EF, KANJI_RARELY_USED,  // 郯
	0x90F0, KANJI_RARELY_USED,  // 郰
	0x90F4, KANJI_RARELY_USED,  // 郴
	0x90FE, KANJI_RARELY_USED,  // 郾
	0x90FF, KANJI_RARELY_USED,  // 郿
	0x9100, KANJI_RARELY_USED,  // 鄀
	0x9104, KANJI_RARELY_USED,  // 鄄
	0x9105, KANJI_RARELY_USED,  // 鄅
	0x9106, KANJI_RARELY_USED,  // 鄆
	0x9108, KANJI_RARELY_USED,  // 鄈
	0x910D, KANJI_RARELY_USED,  // 鄍
	0x9110, KANJI_RARELY_USED,  // 鄐
	0x9114, KANJI_RARELY_USED,  // 鄔
	0x9116, KANJI_RARELY_USED,  // 鄖
	0x9117, KANJI_RARELY_USED,  // 鄗
	0x9118, KANJI_RARELY_USED,  // 鄘
	0x911A, KANJI_RARELY_USED,  // 鄚
	0x911C, KANJI_RARELY_USED,  // 鄜
	0x911E, KANJI_RARELY_USED,  // 鄞
	0x9120, KANJI_RARELY_USED,  // 鄠
	0x9125, KANJI_RARELY_USED,  // 鄥
	0x9122, KANJI_RARELY_USED,  // 鄢
	0x9123, KANJI_RARELY_USED,  // 鄣
	0x9127, KANJI_RARELY_USED,  // 鄧
	0x9129, KANJI_RARELY_USED,  // 鄩
	0x912E, KANJI_RARELY_USED,  // 鄮
	0x912F, KANJI_RARELY_USED,  // 鄯
	0x9131, KANJI_RARELY_USED,  // 鄱
	0x9134, KANJI_RARELY_USED,  // 鄴
	0x9136, KANJI_RARELY_USED,  // 鄶
	0x9137, KANJI_RARELY_USED,  // 鄷
	0x9139, KANJI_RARELY_USED,  // 鄹
	0x913A, KANJI_RARELY_USED,  // 鄺
	0x913C, KANJI_RARELY_USED,  // 鄼
	0x913D, KANJI_RARELY_USED,  // 鄽
	0x9143, KANJI_RARELY_USED,  // 酃
	0x9147, KANJI_RARELY_USED,  // 酇
	0x9148, KANJI_RARELY_USED,  // 酈
	0x914F, KANJI_RARELY_USED,  // 酏
	0x9153, KANJI_RARELY_USED,  // 酓
	0x9157, KANJI_RARELY_USED,  // 酗
	0x9159, KANJI_RARELY_USED,  // 酙
	0x915A, KANJI_RARELY_USED,  // 酚
	0x915B, KANJI_RARELY_USED,  // 酛
	0x9161, KANJI_RARELY_USED,  // 酡
	0x9164, KANJI_RARELY_USED,  // 酤
	0x9167, KANJI_RARELY_USED,  // 酧
	0x916D, KANJI_RARELY_USED,  // 酭
	0x9174, KANJI_RARELY_USED,  // 酴
	0x9179, KANJI_RARELY_USED,  // 酹
	0x917A, KANJI_RARELY_USED,  // 酺
	0x917B, KANJI_RARELY_USED,  // 酻
	0x9181, KANJI_RARELY_USED,  // 醁
	0x9183, KANJI_RARELY_USED,  // 醃
	0x9185, KANJI_RARELY_USED,  // 醅
	0x9186, KANJI_RARELY_USED,  // 醆
	0x918A, KANJI_RARELY_USED,  // 醊
	0x918E, KANJI_RARELY_USED,  // 醎
	0x9191, KANJI_RARELY_USED,  // 醑
	0x9193, KANJI_RARELY_USED,  // 醓
	0x9194, KANJI_RARELY_USED,  // 醔
	0x9195, KANJI_RARELY_USED,  // 醕
	0x9198, KANJI_RARELY_USED,  // 醘
	0x919E, KANJI_RARELY_USED,  // 醞
	0x91A1, KANJI_RARELY_USED,  // 醡
	0x91A6, KANJI_RARELY_USED,  // 醦
	0x91A8, KANJI_RARELY_USED,  // 醨
	0x91AC, KANJI_RARELY_USED,  // 醬
	0x91AD, KANJI_RARELY_USED,  // 醭
	0x91AE, KANJI_RARELY_USED,  // 醮
	0x91B0, KANJI_RARELY_USED,  // 醰
	0x91B1, KANJI_RARELY_USED,  // 醱
	0x91B2, KANJI_RARELY_USED,  // 醲
	0x91B3, KANJI_RARELY_USED,  // 醳
	0x91B6, KANJI_RARELY_USED,  // 醶
	0x91BB, KANJI_RARELY_USED,  // 醻
	0x91BC, KANJI_RARELY_USED,  // 醼
	0x91BD, KANJI_RARELY_USED,  // 醽
	0x91BF, KANJI_RARELY_USED,  // 醿
	0x91C2, KANJI_RARELY_USED,  // 釂
	0x91C3, KANJI_RARELY_USED,  // 釃
	0x91C5, KANJI_RARELY_USED,  // 釅
	0x91D3, KANJI_RARELY_USED,  // 釓
	0x91D4, KANJI_RARELY_USED,  // 釔
	0x91D7, KANJI_RARELY_USED,  // 釗
	0x91D9, KANJI_RARELY_USED,  // 釙
	0x91DA, KANJI_RARELY_USED,  // 釚
	0x91DE, KANJI_RARELY_USED,  // 釞
	0x91E4, KANJI_RARELY_USED,  // 釤
	0x91E5, KANJI_RARELY_USED,  // 釥
	0x91E9, KANJI_RARELY_USED,  // 釩
	0x91EA, KANJI_RARELY_USED,  // 釪
	0x91EC, KANJI_RARELY_USED,  // 釬
	0x91ED, KANJI_RARELY_USED,  // 釭
	0x91EE, KANJI_RARELY_USED,  // 釮
	0x91EF, KANJI_RARELY_USED,  // 釯
	0x91F0, KANJI_RARELY_USED,  // 釰
	0x91F1, KANJI_RARELY_USED,  // 釱
	0x91F7, KANJI_RARELY_USED,  // 釷
	0x91F9, KANJI_RARELY_USED,  // 釹
	0x91FB, KANJI_RARELY_USED,  // 釻
	0x91FD, KANJI_RARELY_USED,  // 釽
	0x9200, KANJI_RARELY_USED,  // 鈀
	0x9201, KANJI_RARELY_USED,  // 鈁
	0x9204, KANJI_RARELY_USED,  // 鈄
	0x9205, KANJI_RARELY_USED,  // 鈅
	0x9206, KANJI_RARELY_USED,  // 鈆
	0x9207, KANJI_RARELY_USED,  // 鈇
	0x9209, KANJI_RARELY_USED,  // 鈉
	0x920A, KANJI_RARELY_USED,  // 鈊
	0x920C, KANJI_RARELY_USED,  // 鈌
	0x9210, KANJI_RARELY_USED,  // 鈐
	0x9212, KANJI_RARELY_USED,  // 鈒
	0x9213, KANJI_RARELY_USED,  // 鈓
	0x9216, KANJI_RARELY_USED,  // 鈖
	0x9218, KANJI_RARELY_USED,  // 鈘
	0x921C, KANJI_RARELY_USED,  // 鈜
	0x921D, KANJI_RARELY_USED,  // 鈝
	0x9223, KANJI_RARELY_USED,  // 鈣
	0x9224, KANJI_RARELY_USED,  // 鈤
	0x9225, KANJI_RARELY_USED,  // 鈥
	0x9226, KANJI_RARELY_USED,  // 鈦
	0x9228, KANJI_RARELY_USED,  // 鈨
	0x922E, KANJI_RARELY_USED,  // 鈮
	0x922F, KANJI_RARELY_USED,  // 鈯
	0x9230, KANJI_RARELY_USED,  // 鈰
	0x9233, KANJI_RARELY_USED,  // 鈳
	0x9235, KANJI_RARELY_USED,  // 鈵
	0x9236, KANJI_RARELY_USED,  // 鈶
	0x9238, KANJI_RARELY_USED,  // 鈸
	0x9239, KANJI_RARELY_USED,  // 鈹
	0x923A, KANJI_RARELY_USED,  // 鈺
	0x923C, KANJI_RARELY_USED,  // 鈼
	0x923E, KANJI_RARELY_USED,  // 鈾
	0x9240, KANJI_RARELY_USED,  // 鉀
	0x9242, KANJI_RARELY_USED,  // 鉂
	0x9243, KANJI_RARELY_USED,  // 鉃
	0x9246, KANJI_RARELY_USED,  // 鉆
	0x9247, KANJI_RARELY_USED,  // 鉇
	0x924A, KANJI_RARELY_USED,  // 鉊
	0x924D, KANJI_RARELY_USED,  // 鉍
	0x924E, KANJI_RARELY_USED,  // 鉎
	0x924F, KANJI_RARELY_USED,  // 鉏
	0x9251, KANJI_RARELY_USED,  // 鉑
	0x9258, KANJI_RARELY_USED,  // 鉘
	0x9259, KANJI_RARELY_USED,  // 鉙
	0x925C, KANJI_RARELY_USED,  // 鉜
	0x925D, KANJI_RARELY_USED,  // 鉝
	0x9260, KANJI_RARELY_USED,  // 鉠
	0x9261, KANJI_RARELY_USED,  // 鉡
	0x9265, KANJI_RARELY_USED,  // 鉥
	0x9267, KANJI_RARELY_USED,  // 鉧
	0x9268, KANJI_RARELY_USED,  // 鉨
	0x9269, KANJI_RARELY_USED,  // 鉩
	0x926E, KANJI_RARELY_USED,  // 鉮
	0x926F, KANJI_RARELY_USED,  // 鉯
	0x9270, KANJI_RARELY_USED,  // 鉰
	0x9275, KANJI_RARELY_USED,  // 鉵
	0x9276, KANJI_RARELY_USED,  // 鉶
	0x9277, KANJI_RARELY_USED,  // 鉷
	0x9278, KANJI_RARELY_USED,  // 鉸
	0x9279, KANJI_RARELY_USED,  // 鉹
	0x927B, KANJI_RARELY_USED,  // 鉻
	0x927C, KANJI_RARELY_USED,  // 鉼
	0x927D, KANJI_RARELY_USED,  // 鉽
	0x927F, KANJI_RARELY_USED,  // 鉿
	0x9288, KANJI_RARELY_USED,  // 銈
	0x9289, KANJI_RARELY_USED,  // 銉
	0x928A, KANJI_RARELY_USED,  // 銊
	0x928D, KANJI_RARELY_USED,  // 銍
	0x928E, KANJI_RARELY_USED,  // 銎
	0x9292, KANJI_RARELY_USED,  // 銒
	0x9297, KANJI_RARELY_USED,  // 銗
	0x9299, KANJI_RARELY_USED,  // 銙
	0x929F, KANJI_RARELY_USED,  // 銟
	0x92A0, KANJI_RARELY_USED,  // 銠
	0x92A4, KANJI_RARELY_USED,  // 銤
	0x92A5, KANJI_RARELY_USED,  // 銥
	0x92A7, KANJI_RARELY_USED,  // 銧
	0x92A8, KANJI_RARELY_USED,  // 銨
	0x92AB, KANJI_RARELY_USED,  // 銫
	0x92AF, KANJI_RARELY_USED,  // 銯
	0x92B2, KANJI_RARELY_USED,  // 銲
	0x92B6, KANJI_RARELY_USED,  // 銶
	0x92B8, KANJI_RARELY_USED,  // 銸
	0x92BA, KANJI_RARELY_USED,  // 銺
	0x92BB, KANJI_RARELY_USED,  // 銻
	0x92BC, KANJI_RARELY_USED,  // 銼
	0x92BD, KANJI_RARELY_USED,  // 銽
	0x92BF, KANJI_RARELY_USED,  // 銿
	0x92C0, KANJI_RARELY_USED,  // 鋀
	0x92C1, KANJI_RARELY_USED,  // 鋁
	0x92C2, KANJI_RARELY_USED,  // 鋂
	0x92C3, KANJI_RARELY_USED,  // 鋃
	0x92C5, KANJI_RARELY_USED,  // 鋅
	0x92C6, KANJI_RARELY_USED,  // 鋆
	0x92C7, KANJI_RARELY_USED,  // 鋇
	0x92C8, KANJI_RARELY_USED,  // 鋈
	0x92CB, KANJI_RARELY_USED,  // 鋋
	0x92CC, KANJI_RARELY_USED,  // 鋌
	0x92CD, KANJI_RARELY_USED,  // 鋍
	0x92CE, KANJI_RARELY_USED,  // 鋎
	0x92D0, KANJI_RARELY_USED,  // 鋐
	0x92D3, KANJI_RARELY_USED,  // 鋓
	0x92D5, KANJI_RARELY_USED,  // 鋕
	0x92D7, KANJI_RARELY_USED,  // 鋗
	0x92D8, KANJI_RARELY_USED,  // 鋘
	0x92D9, KANJI_RARELY_USED,  // 鋙
	0x92DC, KANJI_RARELY_USED,  // 鋜
	0x92DD, KANJI_RARELY_USED,  // 鋝
	0x92DF, KANJI_RARELY_USED,  // 鋟
	0x92E0, KANJI_RARELY_USED,  // 鋠
	0x92E1, KANJI_RARELY_USED,  // 鋡
	0x92E3, KANJI_RARELY_USED,  // 鋣
	0x92E5, KANJI_RARELY_USED,  // 鋥
	0x92E7, KANJI_RARELY_USED,  // 鋧
	0x92E8, KANJI_RARELY_USED,  // 鋨
	0x92EC, KANJI_RARELY_USED,  // 鋬
	0x92EE, KANJI_RARELY_USED,  // 鋮
	0x92F0, KANJI_RARELY_USED,  // 鋰
	0x92F9, KANJI_RARELY_USED,  // 鋹
	0x92FB, KANJI_RARELY_USED,  // 鋻
	0x92FF, KANJI_RARELY_USED,  // 鋿
	0x9300, KANJI_RARELY_USED,  // 錀
	0x9302, KANJI_RARELY_USED,  // 錂
	0x9308, KANJI_RARELY_USED,  // 錈
	0x930D, KANJI_RARELY_USED,  // 錍
	0x9311, KANJI_RARELY_USED,  // 錑
	0x9314, KANJI_RARELY_USED,  // 錔
	0x9315, KANJI_RARELY_USED,  // 錕
	0x931C, KANJI_RARELY_USED,  // 錜
	0x931D, KANJI_RARELY_USED,  // 錝
	0x931E, KANJI_RARELY_USED,  // 錞
	0x931F, KANJI_RARELY_USED,  // 錟
	0x9321, KANJI_RARELY_USED,  // 錡
	0x9324, KANJI_RARELY_USED,  // 錤
	0x9325, KANJI_RARELY_USED,  // 錥
	0x9327, KANJI_RARELY_USED,  // 錧
	0x9329, KANJI_RARELY_USED,  // 錩
	0x932A, KANJI_RARELY_USED,  // 錪
	0x9333, KANJI_RARELY_USED,  // 錳
	0x9334, KANJI_RARELY_USED,  // 錴
	0x9336, KANJI_RARELY_USED,  // 錶
	0x9337, KANJI_RARELY_USED,  // 錷
	0x9347, KANJI_RARELY_USED,  // 鍇
	0x9348, KANJI_RARELY_USED,  // 鍈
	0x9349, KANJI_RARELY_USED,  // 鍉
	0x9350, KANJI_RARELY_USED,  // 鍐
	0x9351, KANJI_RARELY_USED,  // 鍑
	0x9352, KANJI_RARELY_USED,  // 鍒
	0x9355, KANJI_RARELY_USED,  // 鍕
	0x9357, KANJI_RARELY_USED,  // 鍗
	0x9358, KANJI_RARELY_USED,  // 鍘
	0x935A, KANJI_RARELY_USED,  // 鍚
	0x935E, KANJI_RARELY_USED,  // 鍞
	0x9364, KANJI_RARELY_USED,  // 鍤
	0x9365, KANJI_RARELY_USED,  // 鍥
	0x9367, KANJI_RARELY_USED,  // 鍧
	0x9369, KANJI_RARELY_USED,  // 鍩
	0x936A, KANJI_RARELY_USED,  // 鍪
	0x936D, KANJI_RARELY_USED,  // 鍭
	0x936F, KANJI_RARELY_USED,  // 鍯
	0x9370, KANJI_RARELY_USED,  // 鍰
	0x9371, KANJI_RARELY_USED,  // 鍱
	0x9373, KANJI_RARELY_USED,  // 鍳
	0x9374, KANJI_RARELY_USED,  // 鍴
	0x9376, KANJI_RARELY_USED,  // 鍶
	0x937A, KANJI_RARELY_USED,  // 鍺
	0x937D, KANJI_RARELY_USED,  // 鍽
	0x937F, KANJI_RARELY_USED,  // 鍿
	0x9380, KANJI_RARELY_USED,  // 鎀
	0x9381, KANJI_RARELY_USED,  // 鎁
	0x9382, KANJI_RARELY_USED,  // 鎂
	0x9388, KANJI_RARELY_USED,  // 鎈
	0x938A, KANJI_RARELY_USED,  // 鎊
	0x938B, KANJI_RARELY_USED,  // 鎋
	0x938D, KANJI_RARELY_USED,  // 鎍
	0x938F, KANJI_RARELY_USED,  // 鎏
	0x9392, KANJI_RARELY_USED,  // 鎒
	0x9395, KANJI_RARELY_USED,  // 鎕
	0x9398, KANJI_RARELY_USED,  // 鎘
	0x939B, KANJI_RARELY_USED,  // 鎛
	0x939E, KANJI_RARELY_USED,  // 鎞
	0x93A1, KANJI_RARELY_USED,  // 鎡
	0x93A3, KANJI_RARELY_USED,  // 鎣
	0x93A4, KANJI_RARELY_USED,  // 鎤
	0x93A6, KANJI_RARELY_USED,  // 鎦
	0x93A8, KANJI_RARELY_USED,  // 鎨
	0x93AB, KANJI_RARELY_USED,  // 鎫
	0x93B4, KANJI_RARELY_USED,  // 鎴
	0x93B5, KANJI_RARELY_USED,  // 鎵
	0x93B6, KANJI_RARELY_USED,  // 鎶
	0x93BA, KANJI_RARELY_USED,  // 鎺
	0x93A9, KANJI_RARELY_USED,  // 鎩
	0x93C1, KANJI_RARELY_USED,  // 鏁
	0x93C4, KANJI_RARELY_USED,  // 鏄
	0x93C5, KANJI_RARELY_USED,  // 鏅
	0x93C6, KANJI_RARELY_USED,  // 鏆
	0x93C7, KANJI_RARELY_USED,  // 鏇
	0x93C9, KANJI_RARELY_USED,  // 鏉
	0x93CA, KANJI_RARELY_USED,  // 鏊
	0x93CB, KANJI_RARELY_USED,  // 鏋
	0x93CC, KANJI_RARELY_USED,  // 鏌
	0x93CD, KANJI_RARELY_USED,  // 鏍
	0x93D3, KANJI_RARELY_USED,  // 鏓
	0x93D9, KANJI_RARELY_USED,  // 鏙
	0x93DC, KANJI_RARELY_USED,  // 鏜
	0x93DE, KANJI_RARELY_USED,  // 鏞
	0x93DF, KANJI_RARELY_USED,  // 鏟
	0x93E2, KANJI_RARELY_USED,  // 鏢
	0x93E6, KANJI_RARELY_USED,  // 鏦
	0x93E7, KANJI_RARELY_USED,  // 鏧
	0x93F9, KANJI_RARELY_USED,  // 鏹
	0x93F7, KANJI_RARELY_USED,  // 鏷
	0x93F8, KANJI_RARELY_USED,  // 鏸
	0x93FA, KANJI_RARELY_USED,  // 鏺
	0x93FB, KANJI_RARELY_USED,  // 鏻
	0x93FD, KANJI_RARELY_USED,  // 鏽
	0x9401, KANJI_RARELY_USED,  // 鐁
	0x9402, KANJI_RARELY_USED,  // 鐂
	0x9404, KANJI_RARELY_USED,  // 鐄
	0x9408, KANJI_RARELY_USED,  // 鐈
	0x9409, KANJI_RARELY_USED,  // 鐉
	0x940D, KANJI_RARELY_USED,  // 鐍
	0x940E, KANJI_RARELY_USED,  // 鐎
	0x940F, KANJI_RARELY_USED,  // 鐏
	0x9415, KANJI_RARELY_USED,  // 鐕
	0x9416, KANJI_RARELY_USED,  // 鐖
	0x9417, KANJI_RARELY_USED,  // 鐗
	0x941F, KANJI_RARELY_USED,  // 鐟
	0x942E, KANJI_RARELY_USED,  // 鐮
	0x942F, KANJI_RARELY_USED,  // 鐯
	0x9431, KANJI_RARELY_USED,  // 鐱
	0x9432, KANJI_RARELY_USED,  // 鐲
	0x9433, KANJI_RARELY_USED,  // 鐳
	0x9434, KANJI_RARELY_USED,  // 鐴
	0x943B, KANJI_RARELY_USED,  // 鐻
	0x943F, KANJI_RARELY_USED,  // 鐿
	0x943D, KANJI_RARELY_USED,  // 鐽
	0x9443, KANJI_RARELY_USED,  // 鑃
	0x9445, KANJI_RARELY_USED,  // 鑅
	0x9448, KANJI_RARELY_USED,  // 鑈
	0x944A, KANJI_RARELY_USED,  // 鑊
	0x944C, KANJI_RARELY_USED,  // 鑌
	0x9455, KANJI_RARELY_USED,  // 鑕
	0x9459, KANJI_RARELY_USED,  // 鑙
	0x945C, KANJI_RARELY_USED,  // 鑜
	0x945F, KANJI_RARELY_USED,  // 鑟
	0x9461, KANJI_RARELY_USED,  // 鑡
	0x9463, KANJI_RARELY_USED,  // 鑣
	0x9468, KANJI_RARELY_USED,  // 鑨
	0x946B, KANJI_RARELY_USED,  // 鑫
	0x946D, KANJI_RARELY_USED,  // 鑭
	0x946E, KANJI_RARELY_USED,  // 鑮
	0x946F, KANJI_RARELY_USED,  // 鑯
	0x9471, KANJI_RARELY_USED,  // 鑱
	0x9472, KANJI_RARELY_USED,  // 鑲
	0x9484, KANJI_RARELY_USED,  // 钄
	0x9483, KANJI_RARELY_USED,  // 钃
	0x9578, KANJI_RARELY_USED,  // 镸
	0x9579, KANJI_RARELY_USED,  // 镹
	0x957E, KANJI_RARELY_USED,  // 镾
	0x9584, KANJI_RARELY_USED,  // 閄
	0x9588, KANJI_RARELY_USED,  // 閈
	0x958C, KANJI_RARELY_USED,  // 閌
	0x958D, KANJI_RARELY_USED,  // 閍
	0x958E, KANJI_RARELY_USED,  // 閎
	0x959D, KANJI_RARELY_USED,  // 閝
	0x959E, KANJI_RARELY_USED,  // 閞
	0x959F, KANJI_RARELY_USED,  // 閟
	0x95A1, KANJI_RARELY_USED,  // 閡
	0x95A6, KANJI_RARELY_USED,  // 閦
	0x95A9, KANJI_RARELY_USED,  // 閩
	0x95AB, KANJI_RARELY_USED,  // 閫
	0x95AC, KANJI_RARELY_USED,  // 閬
	0x95B4, KANJI_RARELY_USED,  // 閴
	0x95B6, KANJI_RARELY_USED,  // 閶
	0x95BA, KANJI_RARELY_USED,  // 閺
	0x95BD, KANJI_RARELY_USED,  // 閽
	0x95BF, KANJI_RARELY_USED,  // 閿
	0x95C6, KANJI_RARELY_USED,  // 闆
	0x95C8, KANJI_RARELY_USED,  // 闈
	0x95C9, KANJI_RARELY_USED,  // 闉
	0x95CB, KANJI_RARELY_USED,  // 闋
	0x95D0, KANJI_RARELY_USED,  // 闐
	0x95D1, KANJI_RARELY_USED,  // 闑
	0x95D2, KANJI_RARELY_USED,  // 闒
	0x95D3, KANJI_RARELY_USED,  // 闓
	0x95D9, KANJI_RARELY_USED,  // 闙
	0x95DA, KANJI_RARELY_USED,  // 闚
	0x95DD, KANJI_RARELY_USED,  // 闝
	0x95DE, KANJI_RARELY_USED,  // 闞
	0x95DF, KANJI_RARELY_USED,  // 闟
	0x95E0, KANJI_RARELY_USED,  // 闠
	0x95E4, KANJI_RARELY_USED,  // 闤
	0x95E6, KANJI_RARELY_USED,  // 闦
	0x961D, KANJI_RARELY_USED,  // 阝
	0x961E, KANJI_RARELY_USED,  // 阞
	0x9622, KANJI_RARELY_USED,  // 阢
	0x9624, KANJI_RARELY_USED,  // 阤
	0x9625, KANJI_RARELY_USED,  // 阥
	0x9626, KANJI_RARELY_USED,  // 阦
	0x962C, KANJI_RARELY_USED,  // 阬
	0x9631, KANJI_RARELY_USED,  // 阱
	0x9633, KANJI_RARELY_USED,  // 阳
	0x9637, KANJI_RARELY_USED,  // 阷
	0x9638, KANJI_RARELY_USED,  // 阸
	0x9639, KANJI_RARELY_USED,  // 阹
	0x963A, KANJI_RARELY_USED,  // 阺
	0x963C, KANJI_RARELY_USED,  // 阼
	0x963D, KANJI_RARELY_USED,  // 阽
	0x9641, KANJI_RARELY_USED,  // 陁
	0x9652, KANJI_RARELY_USED,  // 陒
	0x9654, KANJI_RARELY_USED,  // 陔
	0x9656, KANJI_RARELY_USED,  // 陖
	0x9657, KANJI_RARELY_USED,  // 陗
	0x9658, KANJI_RARELY_USED,  // 陘
	0x9661, KANJI_RARELY_USED,  // 陡
	0x966E, KANJI_RARELY_USED,  // 陮
	0x9674, KANJI_RARELY_USED,  // 陴
	0x967B, KANJI_RARELY_USED,  // 陻
	0x967C, KANJI_RARELY_USED,  // 陼
	0x967E, KANJI_RARELY_USED,  // 陾
	0x967F, KANJI_RARELY_USED,  // 陿
	0x9681, KANJI_RARELY_USED,  // 隁
	0x9682, KANJI_RARELY_USED,  // 隂
	0x9683, KANJI_RARELY_USED,  // 隃
	0x9684, KANJI_RARELY_USED,  // 隄
	0x9689, KANJI_RARELY_USED,  // 隉
	0x9691, KANJI_RARELY_USED,  // 隑
	0x9696, KANJI_RARELY_USED,  // 隖
	0x969A, KANJI_RARELY_USED,  // 隚
	0x969D, KANJI_RARELY_USED,  // 隝
	0x969F, KANJI_RARELY_USED,  // 隟
	0x96A4, KANJI_RARELY_USED,  // 隤
	0x96A5, KANJI_RARELY_USED,  // 隥
	0x96A6, KANJI_RARELY_USED,  // 隦
	0x96A9, KANJI_RARELY_USED,  // 隩
	0x96AE, KANJI_RARELY_USED,  // 隮
	0x96AF, KANJI_RARELY_USED,  // 隯
	0x96B3, KANJI_RARELY_USED,  // 隳
	0x96BA, KANJI_RARELY_USED,  // 隺
	0x96CA, KANJI_RARELY_USED,  // 雊
	0x96D2, KANJI_RARELY_USED,  // 雒
	0x5DB2, KANJI_RARELY_USED,  // 嶲
	0x96D8, KANJI_RARELY_USED,  // 雘
	0x96DA, KANJI_RARELY_USED,  // 雚
	0x96DD, KANJI_RARELY_USED,  // 雝
	0x96DE, KANJI_RARELY_USED,  // 雞
	0x96DF, KANJI_RARELY_USED,  // 雟
	0x96E9, KANJI_RARELY_USED,  // 雩
	0x96EF, KANJI_RARELY_USED,  // 雯
	0x96F1, KANJI_RARELY_USED,  // 雱
	0x96FA, KANJI_RARELY_USED,  // 雺
	0x9702, KANJI_RARELY_USED,  // 霂
	0x9703, KANJI_RARELY_USED,  // 霃
	0x9705, KANJI_RARELY_USED,  // 霅
	0x9709, KANJI_RARELY_USED,  // 霉
	0x971A, KANJI_RARELY_USED,  // 霚
	0x971B, KANJI_RARELY_USED,  // 霛
	0x971D, KANJI_RARELY_USED,  // 霝
	0x9721, KANJI_RARELY_USED,  // 霡
	0x9722, KANJI_RARELY_USED,  // 霢
	0x9723, KANJI_RARELY_USED,  // 霣
	0x9728, KANJI_RARELY_USED,  // 霨
	0x9731, KANJI_RARELY_USED,  // 霱
	0x9733, KANJI_RARELY_USED,  // 霳
	0x9741, KANJI_RARELY_USED,  // 靁
	0x9743, KANJI_RARELY_USED,  // 靃
	0x974A, KANJI_RARELY_USED,  // 靊
	0x974E, KANJI_RARELY_USED,  // 靎
	0x974F, KANJI_RARELY_USED,  // 靏
	0x9755, KANJI_RARELY_USED,  // 靕
	0x9757, KANJI_RARELY_USED,  // 靗
	0x9758, KANJI_RARELY_USED,  // 靘
	0x975A, KANJI_RARELY_USED,  // 靚
	0x975B, KANJI_RARELY_USED,  // 靛
	0x9763, KANJI_RARELY_USED,  // 靣
	0x9767, KANJI_RARELY_USED,  // 靧
	0x976A, KANJI_RARELY_USED,  // 靪
	0x976E, KANJI_RARELY_USED,  // 靮
	0x9773, KANJI_RARELY_USED,  // 靳
	0x9776, KANJI_RARELY_USED,  // 靶
	0x9777, KANJI_RARELY_USED,  // 靷
	0x9778, KANJI_RARELY_USED,  // 靸
	0x977B, KANJI_RARELY_USED,  // 靻
	0x977D, KANJI_RARELY_USED,  // 靽
	0x977F, KANJI_RARELY_USED,  // 靿
	0x9780, KANJI_RARELY_USED,  // 鞀
	0x9789, KANJI_RARELY_USED,  // 鞉
	0x9795, KANJI_RARELY_USED,  // 鞕
	0x9796, KANJI_RARELY_USED,  // 鞖
	0x9797, KANJI_RARELY_USED,  // 鞗
	0x9799, KANJI_RARELY_USED,  // 鞙
	0x979A, KANJI_RARELY_USED,  // 鞚
	0x979E, KANJI_RARELY_USED,  // 鞞
	0x979F, KANJI_RARELY_USED,  // 鞟
	0x97A2, KANJI_RARELY_USED,  // 鞢
	0x97AC, KANJI_RARELY_USED,  // 鞬
	0x97AE, KANJI_RARELY_USED,  // 鞮
	0x97B1, KANJI_RARELY_USED,  // 鞱
	0x97B2, KANJI_RARELY_USED,  // 鞲
	0x97B5, KANJI_RARELY_USED,  // 鞵
	0x97B6, KANJI_RARELY_USED,  // 鞶
	0x97B8, KANJI_RARELY_USED,  // 鞸
	0x97B9, KANJI_RARELY_USED,  // 鞹
	0x97BA, KANJI_RARELY_USED,  // 鞺
	0x97BC, KANJI_RARELY_USED,  // 鞼
	0x97BE, KANJI_RARELY_USED,  // 鞾
	0x97BF, KANJI_RARELY_USED,  // 鞿
	0x97C1, KANJI_RARELY_USED,  // 韁
	0x97C4, KANJI_RARELY_USED,  // 韄
	0x97C5, KANJI_RARELY_USED,  // 韅
	0x97C7, KANJI_RARELY_USED,  // 韇
	0x97C9, KANJI_RARELY_USED,  // 韉
	0x97CA, KANJI_RARELY_USED,  // 韊
	0x97CC, KANJI_RARELY_USED,  // 韌
	0x97CD, KANJI_RARELY_USED,  // 韍
	0x97CE, KANJI_RARELY_USED,  // 韎
	0x97D0, KANJI_RARELY_USED,  // 韐
	0x97D1, KANJI_RARELY_USED,  // 韑
	0x97D4, KANJI_RARELY_USED,  // 韔
	0x97D7, KANJI_RARELY_USED,  // 韗
	0x97D8, KANJI_RARELY_USED,  // 韘
	0x97D9, KANJI_RARELY_USED,  // 韙
	0x97DD, KANJI_RARELY_USED,  // 韝
	0x97DE, KANJI_RARELY_USED,  // 韞
	0x97E0, KANJI_RARELY_USED,  // 韠
	0x97DB, KANJI_RARELY_USED,  // 韛
	0x97E1, KANJI_RARELY_USED,  // 韡
	0x97E4, KANJI_RARELY_USED,  // 韤
	0x97EF, KANJI_RARELY_USED,  // 韯
	0x97F1, KANJI_RARELY_USED,  // 韱
	0x97F4, KANJI_RARELY_USED,  // 韴
	0x97F7, KANJI_RARELY_USED,  // 韷
	0x97F8, KANJI_RARELY_USED,  // 韸
	0x97FA, KANJI_RARELY_USED,  // 韺
	0x9807, KANJI_RARELY_USED,  // 頇
	0x980A, KANJI_RARELY_USED,  // 頊
	0x9819, KANJI_RARELY_USED,  // 頙
	0x980D, KANJI_RARELY_USED,  // 頍
	0x980E, KANJI_RARELY_USED,  // 頎
	0x9814, KANJI_RARELY_USED,  // 頔
	0x9816, KANJI_RARELY_USED,  // 頖
	0x981C, KANJI_RARELY_USED,  // 頜
	0x981E, KANJI_RARELY_USED,  // 頞
	0x9820, KANJI_RARELY_USED,  // 頠
	0x9823, KANJI_RARELY_USED,  // 頣
	0x9826, KANJI_RARELY_USED,  // 頦
	0x982B, KANJI_RARELY_USED,  // 頫
	0x982E, KANJI_RARELY_USED,  // 頮
	0x982F, KANJI_RARELY_USED,  // 頯
	0x9830, KANJI_RARELY_USED,  // 頰
	0x9832, KANJI_RARELY_USED,  // 頲
	0x9833, KANJI_RARELY_USED,  // 頳
	0x9835, KANJI_RARELY_USED,  // 頵
	0x9825, KANJI_RARELY_USED,  // 頥
	0x983E, KANJI_RARELY_USED,  // 頾
	0x9844, KANJI_RARELY_USED,  // 顄
	0x9847, KANJI_RARELY_USED,  // 顇
	0x984A, KANJI_RARELY_USED,  // 顊
	0x9851, KANJI_RARELY_USED,  // 顑
	0x9852, KANJI_RARELY_USED,  // 顒
	0x9853, KANJI_RARELY_USED,  // 顓
	0x9856, KANJI_RARELY_USED,  // 顖
	0x9857, KANJI_RARELY_USED,  // 顗
	0x9859, KANJI_RARELY_USED,  // 顙
	0x985A, KANJI_RARELY_USED,  // 顚
	0x9862, KANJI_RARELY_USED,  // 顢
	0x9863, KANJI_RARELY_USED,  // 顣
	0x9865, KANJI_RARELY_USED,  // 顥
	0x9866, KANJI_RARELY_USED,  // 顦
	0x986A, KANJI_RARELY_USED,  // 顪
	0x986C, KANJI_RARELY_USED,  // 顬
	0x98AB, KANJI_RARELY_USED,  // 颫
	0x98AD, KANJI_RARELY_USED,  // 颭
	0x98AE, KANJI_RARELY_USED,  // 颮
	0x98B0, KANJI_RARELY_USED,  // 颰
	0x98B4, KANJI_RARELY_USED,  // 颴
	0x98B7, KANJI_RARELY_USED,  // 颷
	0x98B8, KANJI_RARELY_USED,  // 颸
	0x98BA, KANJI_RARELY_USED,  // 颺
	0x98BB, KANJI_RARELY_USED,  // 颻
	0x98BF, KANJI_RARELY_USED,  // 颿
	0x98C2, KANJI_RARELY_USED,  // 飂
	0x98C5, KANJI_RARELY_USED,  // 飅
	0x98C8, KANJI_RARELY_USED,  // 飈
	0x98CC, KANJI_RARELY_USED,  // 飌
	0x98E1, KANJI_RARELY_USED,  // 飡
	0x98E3, KANJI_RARELY_USED,  // 飣
	0x98E5, KANJI_RARELY_USED,  // 飥
	0x98E6, KANJI_RARELY_USED,  // 飦
	0x98E7, KANJI_RARELY_USED,  // 飧
	0x98EA, KANJI_RARELY_USED,  // 飪
	0x98F3, KANJI_RARELY_USED,  // 飳
	0x98F6, KANJI_RARELY_USED,  // 飶
	0x9902, KANJI_RARELY_USED,  // 餂
	0x9907, KANJI_RARELY_USED,  // 餇
	0x9908, KANJI_RARELY_USED,  // 餈
	0x9911, KANJI_RARELY_USED,  // 餑
	0x9915, KANJI_RARELY_USED,  // 餕
	0x9916, KANJI_RARELY_USED,  // 餖
	0x9917, KANJI_RARELY_USED,  // 餗
	0x991A, KANJI_RARELY_USED,  // 餚
	0x991B, KANJI_RARELY_USED,  // 餛
	0x991C, KANJI_RARELY_USED,  // 餜
	0x991F, KANJI_RARELY_USED,  // 餟
	0x9922, KANJI_RARELY_USED,  // 餢
	0x9926, KANJI_RARELY_USED,  // 餦
	0x9927, KANJI_RARELY_USED,  // 餧
	0x992B, KANJI_RARELY_USED,  // 餫
	0x9931, KANJI_RARELY_USED,  // 餱
	0x9932, KANJI_RARELY_USED,  // 餲
	0x9933, KANJI_RARELY_USED,  // 餳
	0x9934, KANJI_RARELY_USED,  // 餴
	0x9935, KANJI_RARELY_USED,  // 餵
	0x9939, KANJI_RARELY_USED,  // 餹
	0x993A, KANJI_RARELY_USED,  // 餺
	0x993B, KANJI_RARELY_USED,  // 餻
	0x993C, KANJI_RARELY_USED,  // 餼
	0x9940, KANJI_RARELY_USED,  // 饀
	0x9941, KANJI_RARELY_USED,  // 饁
	0x9946, KANJI_RARELY_USED,  // 饆
	0x9947, KANJI_RARELY_USED,  // 饇
	0x9948, KANJI_RARELY_USED,  // 饈
	0x994D, KANJI_RARELY_USED,  // 饍
	0x994E, KANJI_RARELY_USED,  // 饎
	0x9954, KANJI_RARELY_USED,  // 饔
	0x9958, KANJI_RARELY_USED,  // 饘
	0x9959, KANJI_RARELY_USED,  // 饙
	0x995B, KANJI_RARELY_USED,  // 饛
	0x995C, KANJI_RARELY_USED,  // 饜
	0x995E, KANJI_RARELY_USED,  // 饞
	0x995F, KANJI_RARELY_USED,  // 饟
	0x9960, KANJI_RARELY_USED,  // 饠
	0x999B, KANJI_RARELY_USED,  // 馛
	0x999D, KANJI_RARELY_USED,  // 馝
	0x999F, KANJI_RARELY_USED,  // 馟
	0x99A6, KANJI_RARELY_USED,  // 馦
	0x99B0, KANJI_RARELY_USED,  // 馰
	0x99B1, KANJI_RARELY_USED,  // 馱
	0x99B2, KANJI_RARELY_USED,  // 馲
	0x99B5, KANJI_RARELY_USED,  // 馵
	0x99B9, KANJI_RARELY_USED,  // 馹
	0x99BA, KANJI_RARELY_USED,  // 馺
	0x99BD, KANJI_RARELY_USED,  // 馽
	0x99BF, KANJI_RARELY_USED,  // 馿
	0x99C3, KANJI_RARELY_USED,  // 駃
	0x99C9, KANJI_RARELY_USED,  // 駉
	0x99D3, KANJI_RARELY_USED,  // 駓
	0x99D4, KANJI_RARELY_USED,  // 駔
	0x99D9, KANJI_RARELY_USED,  // 駙
	0x99DA, KANJI_RARELY_USED,  // 駚
	0x99DC, KANJI_RARELY_USED,  // 駜
	0x99DE, KANJI_RARELY_USED,  // 駞
	0x99E7, KANJI_RARELY_USED,  // 駧
	0x99EA, KANJI_RARELY_USED,  // 駪
	0x99EB, KANJI_RARELY_USED,  // 駫
	0x99EC, KANJI_RARELY_USED,  // 駬
	0x99F0, KANJI_RARELY_USED,  // 駰
	0x99F4, KANJI_RARELY_USED,  // 駴
	0x99F5, KANJI_RARELY_USED,  // 駵
	0x99F9, KANJI_RARELY_USED,  // 駹
	0x99FD, KANJI_RARELY_USED,  // 駽
	0x99FE, KANJI_RARELY_USED,  // 駾
	0x9A02, KANJI_RARELY_USED,  // 騂
	0x9A03, KANJI_RARELY_USED,  // 騃
	0x9A04, KANJI_RARELY_USED,  // 騄
	0x9A0B, KANJI_RARELY_USED,  // 騋
	0x9A0C, KANJI_RARELY_USED,  // 騌
	0x9A10, KANJI_RARELY_USED,  // 騐
	0x9A11, KANJI_RARELY_USED,  // 騑
	0x9A16, KANJI_RARELY_USED,  // 騖
	0x9A1E, KANJI_RARELY_USED,  // 騞
	0x9A20, KANJI_RARELY_USED,  // 騠
	0x9A22, KANJI_RARELY_USED,  // 騢
	0x9A23, KANJI_RARELY_USED,  // 騣
	0x9A24, KANJI_RARELY_USED,  // 騤
	0x9A27, KANJI_RARELY_USED,  // 騧
	0x9A2D, KANJI_RARELY_USED,  // 騭
	0x9A2E, KANJI_RARELY_USED,  // 騮
	0x9A33, KANJI_RARELY_USED,  // 騳
	0x9A35, KANJI_RARELY_USED,  // 騵
	0x9A36, KANJI_RARELY_USED,  // 騶
	0x9A38, KANJI_RARELY_USED,  // 騸
	0x9A47, KANJI_RARELY_USED,  // 驇
	0x9A41, KANJI_RARELY_USED,  // 驁
	0x9A44, KANJI_RARELY_USED,  // 驄
	0x9A4A, KANJI_RARELY_USED,  // 驊
	0x9A4B, KANJI_RARELY_USED,  // 驋
	0x9A4C, KANJI_RARELY_USED,  // 驌
	0x9A4E, KANJI_RARELY_USED,  // 驎
	0x9A51, KANJI_RARELY_USED,  // 驑
	0x9A54, KANJI_RARELY_USED,  // 驔
	0x9A56, KANJI_RARELY_USED,  // 驖
	0x9A5D, KANJI_RARELY_USED,  // 驝
	0x9AAA, KANJI_RARELY_USED,  // 骪
	0x9AAC, KANJI_RARELY_USED,  // 骬
	0x9AAE, KANJI_RARELY_USED,  // 骮
	0x9AAF, KANJI_RARELY_USED,  // 骯
	0x9AB2, KANJI_RARELY_USED,  // 骲
	0x9AB4, KANJI_RARELY_USED,  // 骴
	0x9AB5, KANJI_RARELY_USED,  // 骵
	0x9AB6, KANJI_RARELY_USED,  // 骶
	0x9AB9, KANJI_RARELY_USED,  // 骹
	0x9ABB, KANJI_RARELY_USED,  // 骻
	0x9ABE, KANJI_RARELY_USED,  // 骾
	0x9ABF, KANJI_RARELY_USED,  // 骿
	0x9AC1, KANJI_RARELY_USED,  // 髁
	0x9AC3, KANJI_RARELY_USED,  // 髃
	0x9AC6, KANJI_RARELY_USED,  // 髆
	0x9AC8, KANJI_RARELY_USED,  // 髈
	0x9ACE, KANJI_RARELY_USED,  // 髎
	0x9AD0, KANJI_RARELY_USED,  // 髐
	0x9AD2, KANJI_RARELY_USED,  // 髒
	0x9AD5, KANJI_RARELY_USED,  // 髕
	0x9AD6, KANJI_RARELY_USED,  // 髖
	0x9AD7, KANJI_RARELY_USED,  // 髗
	0x9ADB, KANJI_RARELY_USED,  // 髛
	0x9ADC, KANJI_RARELY_USED,  // 髜
	0x9AE0, KANJI_RARELY_USED,  // 髠
	0x9AE4, KANJI_RARELY_USED,  // 髤
	0x9AE5, KANJI_RARELY_USED,  // 髥
	0x9AE7, KANJI_RARELY_USED,  // 髧
	0x9AE9, KANJI_RARELY_USED,  // 髩
	0x9AEC, KANJI_RARELY_USED,  // 髬
	0x9AF2, KANJI_RARELY_USED,  // 髲
	0x9AF3, KANJI_RARELY_USED,  // 髳
	0x9AF5, KANJI_RARELY_USED,  // 髵
	0x9AF9, KANJI_RARELY_USED,  // 髹
	0x9AFA, KANJI_RARELY_USED,  // 髺
	0x9AFD, KANJI_RARELY_USED,  // 髽
	0x9AFF, KANJI_RARELY_USED,  // 髿
	0x9B00, KANJI_RARELY_USED,  // 鬀
	0x9B01, KANJI_RARELY_USED,  // 鬁
	0x9B02, KANJI_RARELY_USED,  // 鬂
	0x9B03, KANJI_RARELY_USED,  // 鬃
	0x9B04, KANJI_RARELY_USED,  // 鬄
	0x9B05, KANJI_RARELY_USED,  // 鬅
	0x9B08, KANJI_RARELY_USED,  // 鬈
	0x9B09, KANJI_RARELY_USED,  // 鬉
	0x9B0B, KANJI_RARELY_USED,  // 鬋
	0x9B0C, KANJI_RARELY_USED,  // 鬌
	0x9B0D, KANJI_RARELY_USED,  // 鬍
	0x9B0E, KANJI_RARELY_USED,  // 鬎
	0x9B10, KANJI_RARELY_USED,  // 鬐
	0x9B12, KANJI_RARELY_USED,  // 鬒
	0x9B16, KANJI_RARELY_USED,  // 鬖
	0x9B19, KANJI_RARELY_USED,  // 鬙
	0x9B1B, KANJI_RARELY_USED,  // 鬛
	0x9B1C, KANJI_RARELY_USED,  // 鬜
	0x9B20, KANJI_RARELY_USED,  // 鬠
	0x9B26, KANJI_RARELY_USED,  // 鬦
	0x9B2B, KANJI_RARELY_USED,  // 鬫
	0x9B2D, KANJI_RARELY_USED,  // 鬭
	0x9B33, KANJI_RARELY_USED,  // 鬳
	0x9B34, KANJI_RARELY_USED,  // 鬴
	0x9B35, KANJI_RARELY_USED,  // 鬵
	0x9B37, KANJI_RARELY_USED,  // 鬷
	0x9B39, KANJI_RARELY_USED,  // 鬹
	0x9B3A, KANJI_RARELY_USED,  // 鬺
	0x9B3D, KANJI_RARELY_USED,  // 鬽
	0x9B48, KANJI_RARELY_USED,  // 魈
	0x9B4B, KANJI_RARELY_USED,  // 魋
	0x9B4C, KANJI_RARELY_USED,  // 魌
	0x9B55, KANJI_RARELY_USED,  // 魕
	0x9B56, KANJI_RARELY_USED,  // 魖
	0x9B57, KANJI_RARELY_USED,  // 魗
	0x9B5B, KANJI_RARELY_USED,  // 魛
	0x9B5E, KANJI_RARELY_USED,  // 魞
	0x9B61, KANJI_RARELY_USED,  // 魡
	0x9B63, KANJI_RARELY_USED,  // 魣
	0x9B65, KANJI_RARELY_USED,  // 魥
	0x9B66, KANJI_RARELY_USED,  // 魦
	0x9B68, KANJI_RARELY_USED,  // 魨
	0x9B6A, KANJI_RARELY_USED,  // 魪
	0x9B6B, KANJI_RARELY_USED,  // 魫
	0x9B6C, KANJI_RARELY_USED,  // 魬
	0x9B6D, KANJI_RARELY_USED,  // 魭
	0x9B6E, KANJI_RARELY_USED,  // 魮
	0x9B73, KANJI_RARELY_USED,  // 魳
	0x9B75, KANJI_RARELY_USED,  // 魵
	0x9B77, KANJI_RARELY_USED,  // 魷
	0x9B78, KANJI_RARELY_USED,  // 魸
	0x9B79, KANJI_RARELY_USED,  // 魹
	0x9B7F, KANJI_RARELY_USED,  // 魿
	0x9B80, KANJI_RARELY_USED,  // 鮀
	0x9B84, KANJI_RARELY_USED,  // 鮄
	0x9B85, KANJI_RARELY_USED,  // 鮅
	0x9B86, KANJI_RARELY_USED,  // 鮆
	0x9B87, KANJI_RARELY_USED,  // 鮇
	0x9B89, KANJI_RARELY_USED,  // 鮉
	0x9B8A, KANJI_RARELY_USED,  // 鮊
	0x9B8B, KANJI_RARELY_USED,  // 鮋
	0x9B8D, KANJI_RARELY_USED,  // 鮍
	0x9B8F, KANJI_RARELY_USED,  // 鮏
	0x9B90, KANJI_RARELY_USED,  // 鮐
	0x9B94, KANJI_RARELY_USED,  // 鮔
	0x9B9A, KANJI_RARELY_USED,  // 鮚
	0x9B9D, KANJI_RARELY_USED,  // 鮝
	0x9B9E, KANJI_RARELY_USED,  // 鮞
	0x9BA6, KANJI_RARELY_USED,  // 鮦
	0x9BA7, KANJI_RARELY_USED,  // 鮧
	0x9BA9, KANJI_RARELY_USED,  // 鮩
	0x9BAC, KANJI_RARELY_USED,  // 鮬
	0x9BB0, KANJI_RARELY_USED,  // 鮰
	0x9BB1, KANJI_RARELY_USED,  // 鮱
	0x9BB2, KANJI_RARELY_USED,  // 鮲
	0x9BB7, KANJI_RARELY_USED,  // 鮷
	0x9BB8, KANJI_RARELY_USED,  // 鮸
	0x9BBB, KANJI_RARELY_USED,  // 鮻
	0x9BBC, KANJI_RARELY_USED,  // 鮼
	0x9BBE, KANJI_RARELY_USED,  // 鮾
	0x9BBF, KANJI_RARELY_USED,  // 鮿
	0x9BC1, KANJI_RARELY_USED,  // 鯁
	0x9BC7, KANJI_RARELY_USED,  // 鯇
	0x9BC8, KANJI_RARELY_USED,  // 鯈
	0x9BCE, KANJI_RARELY_USED,  // 鯎
	0x9BD0, KANJI_RARELY_USED,  // 鯐
	0x9BD7, KANJI_RARELY_USED,  // 鯗
	0x9BD8, KANJI_RARELY_USED,  // 鯘
	0x9BDD, KANJI_RARELY_USED,  // 鯝
	0x9BDF, KANJI_RARELY_USED,  // 鯟
	0x9BE5, KANJI_RARELY_USED,  // 鯥
	0x9BE7, KANJI_RARELY_USED,  // 鯧
	0x9BEA, KANJI_RARELY_USED,  // 鯪
	0x9BEB, KANJI_RARELY_USED,  // 鯫
	0x9BEF, KANJI_RARELY_USED,  // 鯯
	0x9BF3, KANJI_RARELY_USED,  // 鯳
	0x9BF7, KANJI_RARELY_USED,  // 鯷
	0x9BF8, KANJI_RARELY_USED,  // 鯸
	0x9BF9, KANJI_RARELY_USED,  // 鯹
	0x9BFA, KANJI_RARELY_USED,  // 鯺
	0x9BFD, KANJI_RARELY_USED,  // 鯽
	0x9BFF, KANJI_RARELY_USED,  // 鯿
	0x9C00, KANJI_RARELY_USED,  // 鰀
	0x9C02, KANJI_RARELY_USED,  // 鰂
	0x9C0B, KANJI_RARELY_USED,  // 鰋
	0x9C0F, KANJI_RARELY_USED,  // 鰏
	0x9C11, KANJI_RARELY_USED,  // 鰑
	0x9C16, KANJI_RARELY_USED,  // 鰖
	0x9C18, KANJI_RARELY_USED,  // 鰘
	0x9C19, KANJI_RARELY_USED,  // 鰙
	0x9C1A, KANJI_RARELY_USED,  // 鰚
	0x9C1C, KANJI_RARELY_USED,  // 鰜
	0x9C1E, KANJI_RARELY_USED,  // 鰞
	0x9C22, KANJI_RARELY_USED,  // 鰢
	0x9C23, KANJI_RARELY_USED,  // 鰣
	0x9C26, KANJI_RARELY_USED,  // 鰦
	0x9C27, KANJI_RARELY_USED,  // 鰧
	0x9C28, KANJI_RARELY_USED,  // 鰨
	0x9C29, KANJI_RARELY_USED,  // 鰩
	0x9C2A, KANJI_RARELY_USED,  // 鰪
	0x9C31, KANJI_RARELY_USED,  // 鰱
	0x9C35, KANJI_RARELY_USED,  // 鰵
	0x9C36, KANJI_RARELY_USED,  // 鰶
	0x9C37, KANJI_RARELY_USED,  // 鰷
	0x9C3D, KANJI_RARELY_USED,  // 鰽
	0x9C41, KANJI_RARELY_USED,  // 鱁
	0x9C43, KANJI_RARELY_USED,  // 鱃
	0x9C44, KANJI_RARELY_USED,  // 鱄
	0x9C45, KANJI_RARELY_USED,  // 鱅
	0x9C49, KANJI_RARELY_USED,  // 鱉
	0x9C4A, KANJI_RARELY_USED,  // 鱊
	0x9C4E, KANJI_RARELY_USED,  // 鱎
	0x9C4F, KANJI_RARELY_USED,  // 鱏
	0x9C50, KANJI_RARELY_USED,  // 鱐
	0x9C53, KANJI_RARELY_USED,  // 鱓
	0x9C54, KANJI_RARELY_USED,  // 鱔
	0x9C56, KANJI_RARELY_USED,  // 鱖
	0x9C58, KANJI_RARELY_USED,  // 鱘
	0x9C5B, KANJI_RARELY_USED,  // 鱛
	0x9C5D, KANJI_RARELY_USED,  // 鱝
	0x9C5E, KANJI_RARELY_USED,  // 鱞
	0x9C5F, KANJI_RARELY_USED,  // 鱟
	0x9C63, KANJI_RARELY_USED,  // 鱣
	0x9C69, KANJI_RARELY_USED,  // 鱩
	0x9C6A, KANJI_RARELY_USED,  // 鱪
	0x9C5C, KANJI_RARELY_USED,  // 鱜
	0x9C6B, KANJI_RARELY_USED,  // 鱫
	0x9C68, KANJI_RARELY_USED,  // 鱨
	0x9C6E, KANJI_RARELY_USED,  // 鱮
	0x9C70, KANJI_RARELY_USED,  // 鱰
	0x9C72, KANJI_RARELY_USED,  // 鱲
	0x9C75, KANJI_RARELY_USED,  // 鱵
	0x9C77, KANJI_RARELY_USED,  // 鱷
	0x9C7B, KANJI_RARELY_USED,  // 鱻
	0x9CE6, KANJI_RARELY_USED,  // 鳦
	0x9CF2, KANJI_RARELY_USED,  // 鳲
	0x9CF7, KANJI_RARELY_USED,  // 鳷
	0x9CF9, KANJI_RARELY_USED,  // 鳹
	0x9D0B, KANJI_RARELY_USED,  // 鴋
	0x9D02, KANJI_RARELY_USED,  // 鴂
	0x9D11, KANJI_RARELY_USED,  // 鴑
	0x9D17, KANJI_RARELY_USED,  // 鴗
	0x9D18, KANJI_RARELY_USED,  // 鴘
	0x9D1C, KANJI_RARELY_USED,  // 鴜
	0x9D1D, KANJI_RARELY_USED,  // 鴝
	0x9D1E, KANJI_RARELY_USED,  // 鴞
	0x9D2F, KANJI_RARELY_USED,  // 鴯
	0x9D30, KANJI_RARELY_USED,  // 鴰
	0x9D32, KANJI_RARELY_USED,  // 鴲
	0x9D33, KANJI_RARELY_USED,  // 鴳
	0x9D34, KANJI_RARELY_USED,  // 鴴
	0x9D3A, KANJI_RARELY_USED,  // 鴺
	0x9D3C, KANJI_RARELY_USED,  // 鴼
	0x9D45, KANJI_RARELY_USED,  // 鵅
	0x9D3D, KANJI_RARELY_USED,  // 鴽
	0x9D42, KANJI_RARELY_USED,  // 鵂
	0x9D43, KANJI_RARELY_USED,  // 鵃
	0x9D47, KANJI_RARELY_USED,  // 鵇
	0x9D4A, KANJI_RARELY_USED,  // 鵊
	0x9D53, KANJI_RARELY_USED,  // 鵓
	0x9D54, KANJI_RARELY_USED,  // 鵔
	0x9D5F, KANJI_RARELY_USED,  // 鵟
	0x9D63, KANJI_RARELY_USED,  // 鵣
	0x9D62, KANJI_RARELY_USED,  // 鵢
	0x9D65, KANJI_RARELY_USED,  // 鵥
	0x9D69, KANJI_RARELY_USED,  // 鵩
	0x9D6A, KANJI_RARELY_USED,  // 鵪
	0x9D6B, KANJI_RARELY_USED,  // 鵫
	0x9D70, KANJI_RARELY_USED,  // 鵰
	0x9D76, KANJI_RARELY_USED,  // 鵶
	0x9D77, KANJI_RARELY_USED,  // 鵷
	0x9D7B, KANJI_RARELY_USED,  // 鵻
	0x9D7C, KANJI_RARELY_USED,  // 鵼
	0x9D7E, KANJI_RARELY_USED,  // 鵾
	0x9D83, KANJI_RARELY_USED,  // 鶃
	0x9D84, KANJI_RARELY_USED,  // 鶄
	0x9D86, KANJI_RARELY_USED,  // 鶆
	0x9D8A, KANJI_RARELY_USED,  // 鶊
	0x9D8D, KANJI_RARELY_USED,  // 鶍
	0x9D8E, KANJI_RARELY_USED,  // 鶎
	0x9D92, KANJI_RARELY_USED,  // 鶒
	0x9D93, KANJI_RARELY_USED,  // 鶓
	0x9D95, KANJI_RARELY_USED,  // 鶕
	0x9D96, KANJI_RARELY_USED,  // 鶖
	0x9D97, KANJI_RARELY_USED,  // 鶗
	0x9D98, KANJI_RARELY_USED,  // 鶘
	0x9DA1, KANJI_RARELY_USED,  // 鶡
	0x9DAA, KANJI_RARELY_USED,  // 鶪
	0x9DAC, KANJI_RARELY_USED,  // 鶬
	0x9DAE, KANJI_RARELY_USED,  // 鶮
	0x9DB1, KANJI_RARELY_USED,  // 鶱
	0x9DB5, KANJI_RARELY_USED,  // 鶵
	0x9DB9, KANJI_RARELY_USED,  // 鶹
	0x9DBC, KANJI_RARELY_USED,  // 鶼
	0x9DBF, KANJI_RARELY_USED,  // 鶿
	0x9DC3, KANJI_RARELY_USED,  // 鷃
	0x9DC7, KANJI_RARELY_USED,  // 鷇
	0x9DC9, KANJI_RARELY_USED,  // 鷉
	0x9DCA, KANJI_RARELY_USED,  // 鷊
	0x9DD4, KANJI_RARELY_USED,  // 鷔
	0x9DD5, KANJI_RARELY_USED,  // 鷕
	0x9DD6, KANJI_RARELY_USED,  // 鷖
	0x9DD7, KANJI_RARELY_USED,  // 鷗
	0x9DDA, KANJI_RARELY_USED,  // 鷚
	0x9DDE, KANJI_RARELY_USED,  // 鷞
	0x9DDF, KANJI_RARELY_USED,  // 鷟
	0x9DE0, KANJI_RARELY_USED,  // 鷠
	0x9DE5, KANJI_RARELY_USED,  // 鷥
	0x9DE7, KANJI_RARELY_USED,  // 鷧
	0x9DE9, KANJI_RARELY_USED,  // 鷩
	0x9DEB, KANJI_RARELY_USED,  // 鷫
	0x9DEE, KANJI_RARELY_USED,  // 鷮
	0x9DF0, KANJI_RARELY_USED,  // 鷰
	0x9DF3, KANJI_RARELY_USED,  // 鷳
	0x9DF4, KANJI_RARELY_USED,  // 鷴
	0x9DFE, KANJI_RARELY_USED,  // 鷾
	0x9E0A, KANJI_RARELY_USED,  // 鸊
	0x9E02, KANJI_RARELY_USED,  // 鸂
	0x9E07, KANJI_RARELY_USED,  // 鸇
	0x9E0E, KANJI_RARELY_USED,  // 鸎
	0x9E10, KANJI_RARELY_USED,  // 鸐
	0x9E11, KANJI_RARELY_USED,  // 鸑
	0x9E12, KANJI_RARELY_USED,  // 鸒
	0x9E15, KANJI_RARELY_USED,  // 鸕
	0x9E16, KANJI_RARELY_USED,  // 鸖
	0x9E19, KANJI_RARELY_USED,  // 鸙
	0x9E1C, KANJI_RARELY_USED,  // 鸜
	0x9E1D, KANJI_RARELY_USED,  // 鸝
	0x9E7A, KANJI_RARELY_USED,  // 鹺
	0x9E7B, KANJI_RARELY_USED,  // 鹻
	0x9E7C, KANJI_RARELY_USED,  // 鹼
	0x9E80, KANJI_RARELY_USED,  // 麀
	0x9E82, KANJI_RARELY_USED,  // 麂
	0x9E83, KANJI_RARELY_USED,  // 麃
	0x9E84, KANJI_RARELY_USED,  // 麄
	0x9E85, KANJI_RARELY_USED,  // 麅
	0x9E87, KANJI_RARELY_USED,  // 麇
	0x9E8E, KANJI_RARELY_USED,  // 麎
	0x9E8F, KANJI_RARELY_USED,  // 麏
	0x9E96, KANJI_RARELY_USED,  // 麖
	0x9E98, KANJI_RARELY_USED,  // 麘
	0x9E9B, KANJI_RARELY_USED,  // 麛
	0x9E9E, KANJI_RARELY_USED,  // 麞
	0x9EA4, KANJI_RARELY_USED,  // 麤
	0x9EA8, KANJI_RARELY_USED,  // 麨
	0x9EAC, KANJI_RARELY_USED,  // 麬
	0x9EAE, KANJI_RARELY_USED,  // 麮
	0x9EAF, KANJI_RARELY_USED,  // 麯
	0x9EB0, KANJI_RARELY_USED,  // 麰
	0x9EB3, KANJI_RARELY_USED,  // 麳
	0x9EB4, KANJI_RARELY_USED,  // 麴
	0x9EB5, KANJI_RARELY_USED,  // 麵
	0x9EC6, KANJI_RARELY_USED,  // 黆
	0x9EC8, KANJI_RARELY_USED,  // 黈
	0x9ECB, KANJI_RARELY_USED,  // 黋
	0x9ED5, KANJI_RARELY_USED,  // 黕
	0x9EDF, KANJI_RARELY_USED,  // 黟
	0x9EE4, KANJI_RARELY_USED,  // 黤
	0x9EE7, KANJI_RARELY_USED,  // 黧
	0x9EEC, KANJI_RARELY_USED,  // 黬
	0x9EED, KANJI_RARELY_USED,  // 黭
	0x9EEE, KANJI_RARELY_USED,  // 黮
	0x9EF0, KANJI_RARELY_USED,  // 黰
	0x9EF1, KANJI_RARELY_USED,  // 黱
	0x9EF2, KANJI_RARELY_USED,  // 黲
	0x9EF5, KANJI_RARELY_USED,  // 黵
	0x9EF8, KANJI_RARELY_USED,  // 黸
	0x9EFF, KANJI_RARELY_USED,  // 黿
	0x9F02, KANJI_RARELY_USED,  // 鼂
	0x9F03, KANJI_RARELY_USED,  // 鼃
	0x9F09, KANJI_RARELY_USED,  // 鼉
	0x9F0F, KANJI_RARELY_USED,  // 鼏
	0x9F10, KANJI_RARELY_USED,  // 鼐
	0x9F11, KANJI_RARELY_USED,  // 鼑
	0x9F12, KANJI_RARELY_USED,  // 鼒
	0x9F14, KANJI_RARELY_USED,  // 鼔
	0x9F16, KANJI_RARELY_USED,  // 鼖
	0x9F17, KANJI_RARELY_USED,  // 鼗
	0x9F19, KANJI_RARELY_USED,  // 鼙
	0x9F1A, KANJI_RARELY_USED,  // 鼚
	0x9F1B, KANJI_RARELY_USED,  // 鼛
	0x9F1F, KANJI_RARELY_USED,  // 鼟
	0x9F22, KANJI_RARELY_USED,  // 鼢
	0x9F26, KANJI_RARELY_USED,  // 鼦
	0x9F2A, KANJI_RARELY_USED,  // 鼪
	0x9F2B, KANJI_RARELY_USED,  // 鼫
	0x9F2F, KANJI_RARELY_USED,  // 鼯
	0x9F31, KANJI_RARELY_USED,  // 鼱
	0x9F32, KANJI_RARELY_USED,  // 鼲
	0x9F34, KANJI_RARELY_USED,  // 鼴
	0x9F37, KANJI_RARELY_USED,  // 鼷
	0x9F39, KANJI_RARELY_USED,  // 鼹
	0x9F3A, KANJI_RARELY_USED,  // 鼺
	0x9F3C, KANJI_RARELY_USED,  // 鼼
	0x9F3D, KANJI_RARELY_USED,  // 鼽
	0x9F3F, KANJI_RARELY_USED,  // 鼿
	0x9F41, KANJI_RARELY_USED,  // 齁
	0x9F43, KANJI_RARELY_USED,  // 齃
	0x9F44, KANJI_RARELY_USED,  // 齄
	0x9F45, KANJI_RARELY_USED,  // 齅
	0x9F46, KANJI_RARELY_USED,  // 齆
	0x9F47, KANJI_RARELY_USED,  // 齇
	0x9F53, KANJI_RARELY_USED,  // 齓
	0x9F55, KANJI_RARELY_USED,  // 齕
	0x9F56, KANJI_RARELY_USED,  // 齖
	0x9F57, KANJI_RARELY_USED,  // 齗
	0x9F58, KANJI_RARELY_USED,  // 齘
	0x9F5A, KANJI_RARELY_USED,  // 齚
	0x9F5D, KANJI_RARELY_USED,  // 齝
	0x9F5E, KANJI_RARELY_USED,  // 齞
	0x9F68, KANJI_RARELY_USED,  // 齨
	0x9F69, KANJI_RARELY_USED,  // 齩
	0x9F6D, KANJI_RARELY_USED,  // 齭
	0x9F6E, KANJI_RARELY_USED,  // 齮
	0x9F6F, KANJI_RARELY_USED,  // 齯
	0x9F70, KANJI_RARELY_USED,  // 齰
	0x9F71, KANJI_RARELY_USED,  // 齱
	0x9F73, KANJI_RARELY_USED,  // 齳
	0x9F75, KANJI_RARELY_USED,  // 齵
	0x9F7A, KANJI_RARELY_USED,  // 齺
	0x9F7D, KANJI_RARELY_USED,  // 齽
	0x9F8F, KANJI_RARELY_USED,  // 龏
	0x9F90, KANJI_RARELY_USED,  // 龐
	0x9F91, KANJI_RARELY_USED,  // 龑
	0x9F92, KANJI_RARELY_USED,  // 龒
	0x9F94, KANJI_RARELY_USED,  // 龔
	0x9F96, KANJI_RARELY_USED,  // 龖
	0x9F97, KANJI_RARELY_USED,  // 龗
	0x9F9E, KANJI_RARELY_USED,  // 龞
	0x9FA1, KANJI_RARELY_USED,  // 龡
	0x9FA2, KANJI_RARELY_USED,  // 龢
	0x9FA3, KANJI_RARELY_USED,  // 龣
	0x9FA5, KANJI_RARELY_USED,  // 龥
	0x4FF1, KANJI_LEVEL4,  // 俱
	0xD840, KANJI_LEVEL4,  // �
	0xDC0B, KANJI_LEVEL4,  // �
	0x3402, KANJI_LEVEL4,  // 㐂
	0x4E28, KANJI_LEVEL4,  // 丨
	0x4E2F, KANJI_LEVEL4,  // 丯
	0x4E30, KANJI_LEVEL4,  // 丰
	0x4E8D, KANJI_LEVEL4,  // 亍
	0x4EE1, KANJI_LEVEL4,  // 仡
	0x4EFD, KANJI_LEVEL4,  // 份
	0x4EFF, KANJI_LEVEL4,  // 仿
	0x4F03, KANJI_LEVEL4,  // 伃
	0x4F0B, KANJI_LEVEL4,  // 伋
	0x4F60, KANJI_LEVEL4,  // 你
	0x4F48, KANJI_LEVEL4,  // 佈
	0x4F49, KANJI_LEVEL4,  // 佉
	0x4F56, KANJI_LEVEL4,  // 佖
	0x4F5F, KANJI_LEVEL4,  // 佟
	0x4F6A, KANJI_LEVEL4,  // 佪
	0x4F6C, KANJI_LEVEL4,  // 佬
	0x4F7E, KANJI_LEVEL4,  // 佾
	0x4F8A, KANJI_LEVEL4,  // 侊
	0x4F94, KANJI_LEVEL4,  // 侔
	0x4F97, KANJI_LEVEL4,  // 侗
	0xFA30, KANJI_LEVEL4,  // 侮
	0x4FC9, KANJI_LEVEL4,  // 俉
	0x4FE0, KANJI_LEVEL4,  // 俠
	0x5001, KANJI_LEVEL4,  // 倁
	0x5002, KANJI_LEVEL4,  // 倂
	0x500E, KANJI_LEVEL4,  // 倎
	0x5018, KANJI_LEVEL4,  // 倘
	0x5027, KANJI_LEVEL4,  // 倧
	0x502E, KANJI_LEVEL4,  // 倮
	0x5040, KANJI_LEVEL4,  // 偀
	0x503B, KANJI_LEVEL4,  // 倻
	0x5041, KANJI_LEVEL4,  // 偁
	0x5094, KANJI_LEVEL4,  // 傔
	0x50CC, KANJI_LEVEL4,  // 僌
	0x50F2, KANJI_LEVEL4,  // 僲
	0x50D0, KANJI_LEVEL4,  // 僐
	0x50E6, KANJI_LEVEL4,  // 僦
	0xFA31, KANJI_LEVEL4,  // 僧
	0x5106, KANJI_LEVEL4,  // 儆
	0x5103, KANJI_LEVEL4,  // 儃
	0x510B, KANJI_LEVEL4,  // 儋
	0x511E, KANJI_LEVEL4,  // 儞
	0x5135, KANJI_LEVEL4,  // 儵
	0x514A, KANJI_LEVEL4,  // 兊
	0xFA32, KANJI_LEVEL4,  // 免
	0x5155, KANJI_LEVEL4,  // 兕
	0x5157, KANJI_LEVEL4,  // 兗
	0x34B5, KANJI_LEVEL4,  // 㒵
	0x519D, KANJI_LEVEL4,  // 冝
	0x51C3, KANJI_LEVEL4,  // 凃
	0x51CA, KANJI_LEVEL4,  // 凊
	0x51DE, KANJI_LEVEL4,  // 凞
	0x51E2, KANJI_LEVEL4,  // 凢
	0x51EE, KANJI_LEVEL4,  // 凮
	0x5201, KANJI_LEVEL4,  // 刁
	0x34DB, KANJI_LEVEL4,  // 㓛
	0x5213, KANJI_LEVEL4,  // 刓
	0x5215, KANJI_LEVEL4,  // 刕
	0x5249, KANJI_LEVEL4,  // 剉
	0x5257, KANJI_LEVEL4,  // 剗
	0x5261, KANJI_LEVEL4,  // 剡
	0x5293, KANJI_LEVEL4,  // 劓
	0x52C8, KANJI_LEVEL4,  // 勈
	0xFA33, KANJI_LEVEL4,  // 勉
	0x52CC, KANJI_LEVEL4,  // 勌
	0x52D0, KANJI_LEVEL4,  // 勐
	0x52D6, KANJI_LEVEL4,  // 勖
	0x52DB, KANJI_LEVEL4,  // 勛
	0xFA34, KANJI_LEVEL4,  // 勤
	0x52F0, KANJI_LEVEL4,  // 勰
	0x52FB, KANJI_LEVEL4,  // 勻
	0x5300, KANJI_LEVEL4,  // 匀
	0x5307, KANJI_LEVEL4,  // 匇
	0x531C, KANJI_LEVEL4,  // 匜
	0xFA35, KANJI_LEVEL4,  // 卑
	0x5361, KANJI_LEVEL4,  // 卡
	0x5363, KANJI_LEVEL4,  // 卣
	0x537D, KANJI_LEVEL4,  // 卽
	0x5393, KANJI_LEVEL4,  // 厓
	0x539D, KANJI_LEVEL4,  // 厝
	0x53B2, KANJI_LEVEL4,  // 厲
	0x5412, KANJI_LEVEL4,  // 吒
	0x5427, KANJI_LEVEL4,  // 吧
	0x544D, KANJI_LEVEL4,  // 呍
	0x549C, KANJI_LEVEL4,  // 咜
	0x546B, KANJI_LEVEL4,  // 呫
	0x5474, KANJI_LEVEL4,  // 呴
	0x547F, KANJI_LEVEL4,  // 呿
	0x5488, KANJI_LEVEL4,  // 咈
	0x5496, KANJI_LEVEL4,  // 咖
	0x54A1, KANJI_LEVEL4,  // 咡
	0x54A9, KANJI_LEVEL4,  // 咩
	0x54C6, KANJI_LEVEL4,  // 哆
	0x54FF, KANJI_LEVEL4,  // 哿
	0x550E, KANJI_LEVEL4,  // 唎
	0x552B, KANJI_LEVEL4,  // 唫
	0x5535, KANJI_LEVEL4,  // 唵
	0x5550, KANJI_LEVEL4,  // 啐
	0x555E, KANJI_LEVEL4,  // 啞
	0x5581, KANJI_LEVEL4,  // 喁
	0x5586, KANJI_LEVEL4,  // 喆
	0x558E, KANJI_LEVEL4,  // 喎
	0xFA36, KANJI_LEVEL4,  // 喝
	0x55AD, KANJI_LEVEL4,  // 喭
	0x55CE, KANJI_LEVEL4,  // 嗎
	0xFA37, KANJI_LEVEL4,  // 嘆
	0x5608, KANJI_LEVEL4,  // 嘈
	0x560E, KANJI_LEVEL4,  // 嘎
	0x563B, KANJI_LEVEL4,  // 嘻
	0x5649, KANJI_LEVEL4,  // 噉
	0x5676, KANJI_LEVEL4,  // 噶
	0x5666, KANJI_LEVEL4,  // 噦
	0xFA38, KANJI_LEVEL4,  // 器
	0x566F, KANJI_LEVEL4,  // 噯
	0x5671, KANJI_LEVEL4,  // 噱
	0x5672, KANJI_LEVEL4,  // 噲
	0x5699, KANJI_LEVEL4,  // 嚙
	0x569E, KANJI_LEVEL4,  // 嚞
	0x56A9, KANJI_LEVEL4,  // 嚩
	0x56AC, KANJI_LEVEL4,  // 嚬
	0x56B3, KANJI_LEVEL4,  // 嚳
	0x56C9, KANJI_LEVEL4,  // 囉
	0x56CA, KANJI_LEVEL4,  // 囊
	0x570A, KANJI_LEVEL4,  // 圊
	0xD844, KANJI_LEVEL4,  // �
	0xDE3D, KANJI_LEVEL4,  // �
	0x5721, KANJI_LEVEL4,  // 圡
	0x572F, KANJI_LEVEL4,  // 圯
	0x5733, KANJI_LEVEL4,  // 圳
	0x5734, KANJI_LEVEL4,  // 圴
	0x5770, KANJI_LEVEL4,  // 坰
	0x5777, KANJI_LEVEL4,  // 坷
	0x577C, KANJI_LEVEL4,  // 坼
	0x579C, KANJI_LEVEL4,  // 垜
	0xFA0F, KANJI_LEVEL4,  // 﨏
	0xD844, KANJI_LEVEL4,  // �
	0xDF1B, KANJI_LEVEL4,  // �
	0x57B8, KANJI_LEVEL4,  // 垸
	0x57C7, KANJI_LEVEL4,  // 埇
	0x57C8, KANJI_LEVEL4,  // 埈
	0x57CF, KANJI_LEVEL4,  // 埏
	0x57E4, KANJI_LEVEL4,  // 埤
	0x57ED, KANJI_LEVEL4,  // 埭
	0x57F5, KANJI_LEVEL4,  // 埵
	0x57F6, KANJI_LEVEL4,  // 埶
	0x57FF, KANJI_LEVEL4,  // 埿
	0x5809, KANJI_LEVEL4,  // 堉
	0xFA10, KANJI_LEVEL4,  // 塚
	0x5861, KANJI_LEVEL4,  // 塡
	0x5864, KANJI_LEVEL4,  // 塤
	0xFA39, KANJI_LEVEL4,  // 塀
	0x587C, KANJI_LEVEL4,  // 塼
	0x5889, KANJI_LEVEL4,  // 墉
	0x589E, KANJI_LEVEL4,  // 增
	0xFA3A, KANJI_LEVEL4,  // 墨
	0x58A9, KANJI_LEVEL4,  // 墩
	0xD845, KANJI_LEVEL4,  // �
	0xDC6E, KANJI_LEVEL4,  // �
	0x58D2, KANJI_LEVEL4,  // 壒
	0x58CE, KANJI_LEVEL4,  // 壎
	0x58D4, KANJI_LEVEL4,  // 壔
	0x58DA, KANJI_LEVEL4,  // 壚
	0x58E0, KANJI_LEVEL4,  // 壠
	0x58E9, KANJI_LEVEL4,  // 壩
	0x590C, KANJI_LEVEL4,  // 夌
	0x8641, KANJI_LEVEL4,  // 虁
	0x595D, KANJI_LEVEL4,  // 奝
	0x596D, KANJI_LEVEL4,  // 奭
	0x598B, KANJI_LEVEL4,  // 妋
	0x5992, KANJI_LEVEL4,  // 妒
	0x59A4, KANJI_LEVEL4,  // 妤
	0x59C3, KANJI_LEVEL4,  // 姃
	0x59D2, KANJI_LEVEL4,  // 姒
	0x59DD, KANJI_LEVEL4,  // 姝
	0x5A13, KANJI_LEVEL4,  // 娓
	0x5A23, KANJI_LEVEL4,  // 娣
	0x5A67, KANJI_LEVEL4,  // 婧
	0x5A6D, KANJI_LEVEL4,  // 婭
	0x5A77, KANJI_LEVEL4,  // 婷
	0x5A7E, KANJI_LEVEL4,  // 婾
	0x5A84, KANJI_LEVEL4,  // 媄
	0x5A9E, KANJI_LEVEL4,  // 媞
	0x5AA7, KANJI_LEVEL4,  // 媧
	0x5AC4, KANJI_LEVEL4,  // 嫄
	0xD846, KANJI_LEVEL4,  // �
	0xDCBD, KANJI_LEVEL4,  // �
	0x5B19, KANJI_LEVEL4,  // 嬙
	0x5B25, KANJI_LEVEL4,  // 嬥
	0x525D, KANJI_LEVEL4,  // 剝
	0x4E9C, KANJI_LEVEL4,  // 亜
	0x5516, KANJI_LEVEL4,  // 唖
	0x5A03, KANJI_LEVEL4,  // 娃
	0x963F, KANJI_LEVEL4,  // 阿
	0x54C0, KANJI_LEVEL4,  // 哀
	0x611B, KANJI_LEVEL4,  // 愛
	0x6328, KANJI_LEVEL4,  // 挨
	0x59F6, KANJI_LEVEL4,  // 姶
	0x9022, KANJI_LEVEL4,  // 逢
	0x8475, KANJI_LEVEL4,  // 葵
	0x831C, KANJI_LEVEL4,  // 茜
	0x7A50, KANJI_LEVEL4,  // 穐
	0x60AA, KANJI_LEVEL4,  // 悪
	0x63E1, KANJI_LEVEL4,  // 握
	0x6E25, KANJI_LEVEL4,  // 渥
	0x65ED, KANJI_LEVEL4,  // 旭
	0x8466, KANJI_LEVEL4,  // 葦
	0x82A6, KANJI_LEVEL4,  // 芦
	0x9BF5, KANJI_LEVEL4,  // 鯵
	0x6893, KANJI_LEVEL4,  // 梓
	0x5727, KANJI_LEVEL4,  // 圧
	0x65A1, KANJI_LEVEL4,  // 斡
	0x6271, KANJI_LEVEL4,  // 扱
	0x5B9B, KANJI_LEVEL4,  // 宛
	0x59D0, KANJI_LEVEL4,  // 姐
	0x867B, KANJI_LEVEL4,  // 虻
	0x98F4, KANJI_LEVEL4,  // 飴
	0x7D62, KANJI_LEVEL4,  // 絢
	0x7DBE, KANJI_LEVEL4,  // 綾
	0x9B8E, KANJI_LEVEL4,  // 鮎
	0x6216, KANJI_LEVEL4,  // 或
	0x7C9F, KANJI_LEVEL4,  // 粟
	0x88B7, KANJI_LEVEL4,  // 袷
	0x5B89, KANJI_LEVEL4,  // 安
	0x5EB5, KANJI_LEVEL4,  // 庵
	0x6309, KANJI_LEVEL4,  // 按
	0x6697, KANJI_LEVEL4,  // 暗
	0x6848, KANJI_LEVEL4,  // 案
	0x95C7, KANJI_LEVEL4,  // 闇
	0x978D, KANJI_LEVEL4,  // 鞍
	0x674F, KANJI_LEVEL4,  // 杏
	0x4EE5, KANJI_LEVEL4,  // 以
	0x4F0A, KANJI_LEVEL4,  // 伊
	0x4F4D, KANJI_LEVEL4,  // 位
	0x4F9D, KANJI_LEVEL4,  // 依
	0x5049, KANJI_LEVEL4,  // 偉
	0x56F2, KANJI_LEVEL4,  // 囲
	0x5937, KANJI_LEVEL4,  // 夷
	0x59D4, KANJI_LEVEL4,  // 委
	0x5A01, KANJI_LEVEL4,  // 威
	0x5C09, KANJI_LEVEL4,  // 尉
	0x60DF, KANJI_LEVEL4,  // 惟
	0x610F, KANJI_LEVEL4,  // 意
	0x6170, KANJI_LEVEL4,  // 慰
	0x6613, KANJI_LEVEL4,  // 易
	0x6905, KANJI_LEVEL4,  // 椅
	0x70BA, KANJI_LEVEL4,  // 為
	0x754F, KANJI_LEVEL4,  // 畏
	0x7570, KANJI_LEVEL4,  // 異
	0x79FB, KANJI_LEVEL4,  // 移
	0x7DAD, KANJI_LEVEL4,  // 維
	0x7DEF, KANJI_LEVEL4,  // 緯
	0x80C3, KANJI_LEVEL4,  // 胃
	0x840E, KANJI_LEVEL4,  // 萎
	0x8863, KANJI_LEVEL4,  // 衣
	0x8B02, KANJI_LEVEL4,  // 謂
	0x9055, KANJI_LEVEL4,  // 違
	0x907A, KANJI_LEVEL4,  // 遺
	0x533B, KANJI_LEVEL4,  // 医
	0x4E95, KANJI_LEVEL4,  // 井
	0x4EA5, KANJI_LEVEL4,  // 亥
	0x57DF, KANJI_LEVEL4,  // 域
	0x80B2, KANJI_LEVEL4,  // 育
	0x90C1, KANJI_LEVEL4,  // 郁
	0x78EF, KANJI_LEVEL4,  // 磯
	0x4E00, KANJI_LEVEL4,  // 一
	0x58F1, KANJI_LEVEL4,  // 壱
	0x6EA2, KANJI_LEVEL4,  // 溢
	0x9038, KANJI_LEVEL4,  // 逸
	0x7A32, KANJI_LEVEL4,  // 稲
	0x8328, KANJI_LEVEL4,  // 茨
	0x828B, KANJI_LEVEL4,  // 芋
	0x9C2F, KANJI_LEVEL4,  // 鰯
	0x5141, KANJI_LEVEL4,  // 允
	0x5370, KANJI_LEVEL4,  // 印
	0x54BD, KANJI_LEVEL4,  // 咽
	0x54E1, KANJI_LEVEL4,  // 員
	0x56E0, KANJI_LEVEL4,  // 因
	0x59FB, KANJI_LEVEL4,  // 姻
	0x5F15, KANJI_LEVEL4,  // 引
	0x98F2, KANJI_LEVEL4,  // 飲
	0x6DEB, KANJI_LEVEL4,  // 淫
	0x80E4, KANJI_LEVEL4,  // 胤
	0x852D, KANJI_LEVEL4,  // 蔭
	0x9662, KANJI_LEVEL4,  // 院
	0x9670, KANJI_LEVEL4,  // 陰
	0x96A0, KANJI_LEVEL4,  // 隠
	0x97FB, KANJI_LEVEL4,  // 韻
	0x540B, KANJI_LEVEL4,  // 吋
	0x53F3, KANJI_LEVEL4,  // 右
	0x5B87, KANJI_LEVEL4,  // 宇
	0x70CF, KANJI_LEVEL4,  // 烏
	0x7FBD, KANJI_LEVEL4,  // 羽
	0x8FC2, KANJI_LEVEL4,  // 迂
	0x96E8, KANJI_LEVEL4,  // 雨
	0x536F, KANJI_LEVEL4,  // 卯
	0x9D5C, KANJI_LEVEL4,  // 鵜
	0x7ABA, KANJI_LEVEL4,  // 窺
	0x4E11, KANJI_LEVEL4,  // 丑
	0x7893, KANJI_LEVEL4,  // 碓
	0x81FC, KANJI_LEVEL4,  // 臼
	0x6E26, KANJI_LEVEL4,  // 渦
	0x5618, KANJI_LEVEL4,  // 嘘
	0x5504, KANJI_LEVEL4,  // 唄
	0x6B1D, KANJI_LEVEL4,  // 欝
	0x851A, KANJI_LEVEL4,  // 蔚
	0x9C3B, KANJI_LEVEL4,  // 鰻
	0x59E5, KANJI_LEVEL4,  // 姥
	0x53A9, KANJI_LEVEL4,  // 厩
	0x6D66, KANJI_LEVEL4,  // 浦
	0x74DC, KANJI_LEVEL4,  // 瓜
	0x958F, KANJI_LEVEL4,  // 閏
	0x5642, KANJI_LEVEL4,  // 噂
	0x4E91, KANJI_LEVEL4,  // 云
	0x904B, KANJI_LEVEL4,  // 運
	0x96F2, KANJI_LEVEL4,  // 雲
	0x834F, KANJI_LEVEL4,  // 荏
	0x990C, KANJI_LEVEL4,  // 餌
	0x53E1, KANJI_LEVEL4,  // 叡
	0x55B6, KANJI_LEVEL4,  // 営
	0x5B30, KANJI_LEVEL4,  // 嬰
	0x5F71, KANJI_LEVEL4,  // 影
	0x6620, KANJI_LEVEL4,  // 映
	0x66F3, KANJI_LEVEL4,  // 曳
	0x6804, KANJI_LEVEL4,  // 栄
	0x6C38, KANJI_LEVEL4,  // 永
	0x6CF3, KANJI_LEVEL4,  // 泳
	0x6D29, KANJI_LEVEL4,  // 洩
	0x745B, KANJI_LEVEL4,  // 瑛
	0x76C8, KANJI_LEVEL4,  // 盈
	0x7A4E, KANJI_LEVEL4,  // 穎
	0x9834, KANJI_LEVEL4,  // 頴
	0x82F1, KANJI_LEVEL4,  // 英
	0x885B, KANJI_LEVEL4,  // 衛
	0x8A60, KANJI_LEVEL4,  // 詠
	0x92ED, KANJI_LEVEL4,  // 鋭
	0x6DB2, KANJI_LEVEL4,  // 液
	0x75AB, KANJI_LEVEL4,  // 疫
	0x76CA, KANJI_LEVEL4,  // 益
	0x99C5, KANJI_LEVEL4,  // 駅
	0x60A6, KANJI_LEVEL4,  // 悦
	0x8B01, KANJI_LEVEL4,  // 謁
	0x8D8A, KANJI_LEVEL4,  // 越
	0x95B2, KANJI_LEVEL4,  // 閲
	0x698E, KANJI_LEVEL4,  // 榎
	0x53AD, KANJI_LEVEL4,  // 厭
	0x5186, KANJI_LEVEL4,  // 円
	0x5712, KANJI_LEVEL4,  // 園
	0x5830, KANJI_LEVEL4,  // 堰
	0x5944, KANJI_LEVEL4,  // 奄
	0x5BB4, KANJI_LEVEL4,  // 宴
	0x5EF6, KANJI_LEVEL4,  // 延
	0x6028, KANJI_LEVEL4,  // 怨
	0x63A9, KANJI_LEVEL4,  // 掩
	0x63F4, KANJI_LEVEL4,  // 援
	0x6CBF, KANJI_LEVEL4,  // 沿
	0x6F14, KANJI_LEVEL4,  // 演
	0x708E, KANJI_LEVEL4,  // 炎
	0x7114, KANJI_LEVEL4,  // 焔
	0x7159, KANJI_LEVEL4,  // 煙
	0x71D5, KANJI_LEVEL4,  // 燕
	0x733F, KANJI_LEVEL4,  // 猿
	0x7E01, KANJI_LEVEL4,  // 縁
	0x8276, KANJI_LEVEL4,  // 艶
	0x82D1, KANJI_LEVEL4,  // 苑
	0x8597, KANJI_LEVEL4,  // 薗
	0x9060, KANJI_LEVEL4,  // 遠
	0x925B, KANJI_LEVEL4,  // 鉛
	0x9D1B, KANJI_LEVEL4,  // 鴛
	0x5869, KANJI_LEVEL4,  // 塩
	0x65BC, KANJI_LEVEL4,  // 於
	0x6C5A, KANJI_LEVEL4,  // 汚
	0x7525, KANJI_LEVEL4,  // 甥
	0x51F9, KANJI_LEVEL4,  // 凹
	0x592E, KANJI_LEVEL4,  // 央
	0x5965, KANJI_LEVEL4,  // 奥
	0x5F80, KANJI_LEVEL4,  // 往
	0x5FDC, KANJI_LEVEL4,  // 応
	0x62BC, KANJI_LEVEL4,  // 押
	0x65FA, KANJI_LEVEL4,  // 旺
	0x6A2A, KANJI_LEVEL4,  // 横
	0x6B27, KANJI_LEVEL4,  // 欧
	0x6BB4, KANJI_LEVEL4,  // 殴
	0x738B, KANJI_LEVEL4,  // 王
	0x7FC1, KANJI_LEVEL4,  // 翁
	0x8956, KANJI_LEVEL4,  // 襖
	0x9D2C, KANJI_LEVEL4,  // 鴬
	0x9D0E, KANJI_LEVEL4,  // 鴎
	0x9EC4, KANJI_LEVEL4,  // 黄
	0x5CA1, KANJI_LEVEL4,  // 岡
	0x6C96, KANJI_LEVEL4,  // 沖
	0x837B, KANJI_LEVEL4,  // 荻
	0x5104, KANJI_LEVEL4,  // 億
	0x5C4B, KANJI_LEVEL4,  // 屋
	0x61B6, KANJI_LEVEL4,  // 憶
	0x81C6, KANJI_LEVEL4,  // 臆
	0x6876, KANJI_LEVEL4,  // 桶
	0x7261, KANJI_LEVEL4,  // 牡
	0x4E59, KANJI_LEVEL4,  // 乙
	0x4FFA, KANJI_LEVEL4,  // 俺
	0x5378, KANJI_LEVEL4,  // 卸
	0x6069, KANJI_LEVEL4,  // 恩
	0x6E29, KANJI_LEVEL4,  // 温
	0x7A4F, KANJI_LEVEL4,  // 穏
	0x97F3, KANJI_LEVEL4,  // 音
	0x4E0B, KANJI_LEVEL4,  // 下
	0x5316, KANJI_LEVEL4,  // 化
	0x4EEE, KANJI_LEVEL4,  // 仮
	0x4F55, KANJI_LEVEL4,  // 何
	0x4F3D, KANJI_LEVEL4,  // 伽
	0x4FA1, KANJI_LEVEL4,  // 価
	0x4F73, KANJI_LEVEL4,  // 佳
	0x52A0, KANJI_LEVEL4,  // 加
	0x53EF, KANJI_LEVEL4,  // 可
	0x5609, KANJI_LEVEL4,  // 嘉
	0x590F, KANJI_LEVEL4,  // 夏
	0x5AC1, KANJI_LEVEL4,  // 嫁
	0x5BB6, KANJI_LEVEL4,  // 家
	0x5BE1, KANJI_LEVEL4,  // 寡
	0x79D1, KANJI_LEVEL4,  // 科
	0x6687, KANJI_LEVEL4,  // 暇
	0x679C, KANJI_LEVEL4,  // 果
	0x67B6, KANJI_LEVEL4,  // 架
	0x6B4C, KANJI_LEVEL4,  // 歌
	0x6CB3, KANJI_LEVEL4,  // 河
	0x706B, KANJI_LEVEL4,  // 火
	0x73C2, KANJI_LEVEL4,  // 珂
	0x798D, KANJI_LEVEL4,  // 禍
	0x79BE, KANJI_LEVEL4,  // 禾
	0x7A3C, KANJI_LEVEL4,  // 稼
	0x7B87, KANJI_LEVEL4,  // 箇
	0x82B1, KANJI_LEVEL4,  // 花
	0x82DB, KANJI_LEVEL4,  // 苛
	0x8304, KANJI_LEVEL4,  // 茄
	0x8377, KANJI_LEVEL4,  // 荷
	0x83EF, KANJI_LEVEL4,  // 華
	0x83D3, KANJI_LEVEL4,  // 菓
	0x8766, KANJI_LEVEL4,  // 蝦
	0x8AB2, KANJI_LEVEL4,  // 課
	0x5629, KANJI_LEVEL4,  // 嘩
	0x8CA8, KANJI_LEVEL4,  // 貨
	0x8FE6, KANJI_LEVEL4,  // 迦
	0x904E, KANJI_LEVEL4,  // 過
	0x971E, KANJI_LEVEL4,  // 霞
	0x868A, KANJI_LEVEL4,  // 蚊
	0x4FC4, KANJI_LEVEL4,  // 俄
	0x5CE8, KANJI_LEVEL4,  // 峨
	0x6211, KANJI_LEVEL4,  // 我
	0x7259, KANJI_LEVEL4,  // 牙
	0x753B, KANJI_LEVEL4,  // 画
	0x81E5, KANJI_LEVEL4,  // 臥
	0x82BD, KANJI_LEVEL4,  // 芽
	0x86FE, KANJI_LEVEL4,  // 蛾
	0x8CC0, KANJI_LEVEL4,  // 賀
	0x96C5, KANJI_LEVEL4,  // 雅
	0x9913, KANJI_LEVEL4,  // 餓
	0x99D5, KANJI_LEVEL4,  // 駕
	0x4ECB, KANJI_LEVEL4,  // 介
	0x4F1A, KANJI_LEVEL4,  // 会
	0x89E3, KANJI_LEVEL4,  // 解
	0x56DE, KANJI_LEVEL4,  // 回
	0x584A, KANJI_LEVEL4,  // 塊
	0x58CA, KANJI_LEVEL4,  // 壊
	0x5EFB, KANJI_LEVEL4,  // 廻
	0x5FEB, KANJI_LEVEL4,  // 快
	0x602A, KANJI_LEVEL4,  // 怪
	0x6094, KANJI_LEVEL4,  // 悔
	0x6062, KANJI_LEVEL4,  // 恢
	0x61D0, KANJI_LEVEL4,  // 懐
	0x6212, KANJI_LEVEL4,  // 戒
	0x62D0, KANJI_LEVEL4,  // 拐
	0x6539, KANJI_LEVEL4,  // 改
	0x9B41, KANJI_LEVEL4,  // 魁
	0x6666, KANJI_LEVEL4,  // 晦
	0x68B0, KANJI_LEVEL4,  // 械
	0x6D77, KANJI_LEVEL4,  // 海
	0x7070, KANJI_LEVEL4,  // 灰
	0x754C, KANJI_LEVEL4,  // 界
	0x7686, KANJI_LEVEL4,  // 皆
	0x7D75, KANJI_LEVEL4,  // 絵
	0x82A5, KANJI_LEVEL4,  // 芥
	0x87F9, KANJI_LEVEL4,  // 蟹
	0x958B, KANJI_LEVEL4,  // 開
	0x968E, KANJI_LEVEL4,  // 階
	0x8C9D, KANJI_LEVEL4,  // 貝
	0x51F1, KANJI_LEVEL4,  // 凱
	0x52BE, KANJI_LEVEL4,  // 劾
	0x5916, KANJI_LEVEL4,  // 外
	0x54B3, KANJI_LEVEL4,  // 咳
	0x5BB3, KANJI_LEVEL4,  // 害
	0x5D16, KANJI_LEVEL4,  // 崖
	0x6168, KANJI_LEVEL4,  // 慨
	0x6982, KANJI_LEVEL4,  // 概
	0x6DAF, KANJI_LEVEL4,  // 涯
	0x788D, KANJI_LEVEL4,  // 碍
	0x84CB, KANJI_LEVEL4,  // 蓋
	0x8857, KANJI_LEVEL4,  // 街
	0x8A72, KANJI_LEVEL4,  // 該
	0x93A7, KANJI_LEVEL4,  // 鎧
	0x9AB8, KANJI_LEVEL4,  // 骸
	0x6D6C, KANJI_LEVEL4,  // 浬
	0x99A8, KANJI_LEVEL4,  // 馨
	0x86D9, KANJI_LEVEL4,  // 蛙
	0x57A3, KANJI_LEVEL4,  // 垣
	0x67FF, KANJI_LEVEL4,  // 柿
	0x86CE, KANJI_LEVEL4,  // 蛎
	0x920E, KANJI_LEVEL4,  // 鈎
	0x5283, KANJI_LEVEL4,  // 劃
	0x5687, KANJI_LEVEL4,  // 嚇
	0x5404, KANJI_LEVEL4,  // 各
	0x5ED3, KANJI_LEVEL4,  // 廓
	0x62E1, KANJI_LEVEL4,  // 拡
	0x64B9, KANJI_LEVEL4,  // 撹
	0x683C, KANJI_LEVEL4,  // 格
	0x6838, KANJI_LEVEL4,  // 核
	0x6BBB, KANJI_LEVEL4,  // 殻
	0x7372, KANJI_LEVEL4,  // 獲
	0x78BA, KANJI_LEVEL4,  // 確
	0x7A6B, KANJI_LEVEL4,  // 穫
	0x899A, KANJI_LEVEL4,  // 覚
	0x89D2, KANJI_LEVEL4,  // 角
	0x8D6B, KANJI_LEVEL4,  // 赫
	0x8F03, KANJI_LEVEL4,  // 較
	0x90ED, KANJI_LEVEL4,  // 郭
	0x95A3, KANJI_LEVEL4,  // 閣
	0x9694, KANJI_LEVEL4,  // 隔
	0x9769, KANJI_LEVEL4,  // 革
	0x5B66, KANJI_LEVEL4,  // 学
	0x5CB3, KANJI_LEVEL4,  // 岳
	0x697D, KANJI_LEVEL4,  // 楽
	0x984D, KANJI_LEVEL4,  // 額
	0x984E, KANJI_LEVEL4,  // 顎
	0x639B, KANJI_LEVEL4,  // 掛
	0x7B20, KANJI_LEVEL4,  // 笠
	0x6A2B, KANJI_LEVEL4,  // 樫
	0x6A7F, KANJI_LEVEL4,  // 橿
	0x68B6, KANJI_LEVEL4,  // 梶
	0x9C0D, KANJI_LEVEL4,  // 鰍
	0x6F5F, KANJI_LEVEL4,  // 潟
	0x5272, KANJI_LEVEL4,  // 割
	0x559D, KANJI_LEVEL4,  // 喝
	0x6070, KANJI_LEVEL4,  // 恰
	0x62EC, KANJI_LEVEL4,  // 括
	0x6D3B, KANJI_LEVEL4,  // 活
	0x6E07, KANJI_LEVEL4,  // 渇
	0x6ED1, KANJI_LEVEL4,  // 滑
	0x845B, KANJI_LEVEL4,  // 葛
	0x8910, KANJI_LEVEL4,  // 褐
	0x8F44, KANJI_LEVEL4,  // 轄
	0x4E14, KANJI_LEVEL4,  // 且
	0x9C39, KANJI_LEVEL4,  // 鰹
	0x53F6, KANJI_LEVEL4,  // 叶
	0x691B, KANJI_LEVEL4,  // 椛
	0x6A3A, KANJI_LEVEL4,  // 樺
	0x9784, KANJI_LEVEL4,  // 鞄
	0x682A, KANJI_LEVEL4,  // 株
	0x515C, KANJI_LEVEL4,  // 兜
	0x7AC3, KANJI_LEVEL4,  // 竃
	0x84B2, KANJI_LEVEL4,  // 蒲
	0x91DC, KANJI_LEVEL4,  // 釜
	0x938C, KANJI_LEVEL4,  // 鎌
	0x565B, KANJI_LEVEL4,  // 噛
	0x9D28, KANJI_LEVEL4,  // 鴨
	0x6822, KANJI_LEVEL4,  // 栢
	0x8305, KANJI_LEVEL4,  // 茅
	0x8431, KANJI_LEVEL4,  // 萱
	0x7CA5, KANJI_LEVEL4,  // 粥
	0x5208, KANJI_LEVEL4,  // 刈
	0x82C5, KANJI_LEVEL4,  // 苅
	0x74E6, KANJI_LEVEL4,  // 瓦
	0x4E7E, KANJI_LEVEL4,  // 乾
	0x4F83, KANJI_LEVEL4,  // 侃
	0x51A0, KANJI_LEVEL4,  // 冠
	0x5BD2, KANJI_LEVEL4,  // 寒
	0x520A, KANJI_LEVEL4,  // 刊
	0x52D8, KANJI_LEVEL4,  // 勘
	0x52E7, KANJI_LEVEL4,  // 勧
	0x5DFB, KANJI_LEVEL4,  // 巻
	0x559A, KANJI_LEVEL4,  // 喚
	0x582A, KANJI_LEVEL4,  // 堪
	0x59E6, KANJI_LEVEL4,  // 姦
	0x5B8C, KANJI_LEVEL4,  // 完
	0x5B98, KANJI_LEVEL4,  // 官
	0x5BDB, KANJI_LEVEL4,  // 寛
	0x5E72, KANJI_LEVEL4,  // 干
	0x5E79, KANJI_LEVEL4,  // 幹
	0x60A3, KANJI_LEVEL4,  // 患
	0x611F, KANJI_LEVEL4,  // 感
	0x6163, KANJI_LEVEL4,  // 慣
	0x61BE, KANJI_LEVEL4,  // 憾
	0x63DB, KANJI_LEVEL4,  // 換
	0x6562, KANJI_LEVEL4,  // 敢
	0x67D1, KANJI_LEVEL4,  // 柑
	0x6853, KANJI_LEVEL4,  // 桓
	0x68FA, KANJI_LEVEL4,  // 棺
	0x6B3E, KANJI_LEVEL4,  // 款
	0x6B53, KANJI_LEVEL4,  // 歓
	0x6C57, KANJI_LEVEL4,  // 汗
	0x6F22, KANJI_LEVEL4,  // 漢
	0x6F97, KANJI_LEVEL4,  // 澗
	0x6F45, KANJI_LEVEL4,  // 潅
	0x74B0, KANJI_LEVEL4,  // 環
	0x7518, KANJI_LEVEL4,  // 甘
	0x76E3, KANJI_LEVEL4,  // 監
	0x770B, KANJI_LEVEL4,  // 看
	0x7AFF, KANJI_LEVEL4,  // 竿
	0x7BA1, KANJI_LEVEL4,  // 管
	0x7C21, KANJI_LEVEL4,  // 簡
	0x7DE9, KANJI_LEVEL4,  // 緩
	0x7F36, KANJI_LEVEL4,  // 缶
	0x7FF0, KANJI_LEVEL4,  // 翰
	0x809D, KANJI_LEVEL4,  // 肝
	0x8266, KANJI_LEVEL4,  // 艦
	0x839E, KANJI_LEVEL4,  // 莞
	0x89B3, KANJI_LEVEL4,  // 観
	0x8ACC, KANJI_LEVEL4,  // 諌
	0x8CAB, KANJI_LEVEL4,  // 貫
	0x9084, KANJI_LEVEL4,  // 還
	0x9451, KANJI_LEVEL4,  // 鑑
	0x9593, KANJI_LEVEL4,  // 間
	0x9591, KANJI_LEVEL4,  // 閑
	0x95A2, KANJI_LEVEL4,  // 関
	0x9665, KANJI_LEVEL4,  // 陥
	0x97D3, KANJI_LEVEL4,  // 韓
	0x9928, KANJI_LEVEL4,  // 館
	0x8218, KANJI_LEVEL4,  // 舘
	0x4E38, KANJI_LEVEL4,  // 丸
	0x542B, KANJI_LEVEL4,  // 含
	0x5CB8, KANJI_LEVEL4,  // 岸
	0x5DCC, KANJI_LEVEL4,  // 巌
	0x73A9, KANJI_LEVEL4,  // 玩
	0x764C, KANJI_LEVEL4,  // 癌
	0x773C, KANJI_LEVEL4,  // 眼
	0x5CA9, KANJI_LEVEL4,  // 岩
	0x7FEB, KANJI_LEVEL4,  // 翫
	0x8D0B, KANJI_LEVEL4,  // 贋
	0x96C1, KANJI_LEVEL4,  // 雁
	0x9811, KANJI_LEVEL4,  // 頑
	0x9854, KANJI_LEVEL4,  // 顔
	0x9858, KANJI_LEVEL4,  // 願
	0x4F01, KANJI_LEVEL4,  // 企
	0x4F0E, KANJI_LEVEL4,  // 伎
	0x5371, KANJI_LEVEL4,  // 危
	0x559C, KANJI_LEVEL4,  // 喜
	0x5668, KANJI_LEVEL4,  // 器
	0x57FA, KANJI_LEVEL4,  // 基
	0x5947, KANJI_LEVEL4,  // 奇
	0x5B09, KANJI_LEVEL4,  // 嬉
	0x5BC4, KANJI_LEVEL4,  // 寄
	0x5C90, KANJI_LEVEL4,  // 岐
	0x5E0C, KANJI_LEVEL4,  // 希
	0x5E7E, KANJI_LEVEL4,  // 幾
	0x5FCC, KANJI_LEVEL4,  // 忌
	0x63EE, KANJI_LEVEL4,  // 揮
	0x673A, KANJI_LEVEL4,  // 机
	0x65D7, KANJI_LEVEL4,  // 旗
	0x65E2, KANJI_LEVEL4,  // 既
	0x671F, KANJI_LEVEL4,  // 期
	0x68CB, KANJI_LEVEL4,  // 棋
	0x68C4, KANJI_LEVEL4,  // 棄
	0x6A5F, KANJI_LEVEL4,  // 機
	0x5E30, KANJI_LEVEL4,  // 帰
	0x6BC5, KANJI_LEVEL4,  // 毅
	0x6C17, KANJI_LEVEL4,  // 気
	0x6C7D, KANJI_LEVEL4,  // 汽
	0x757F, KANJI_LEVEL4,  // 畿
	0x7948, KANJI_LEVEL4,  // 祈
	0x5B63, KANJI_LEVEL4,  // 季
	0x7A00, KANJI_LEVEL4,  // 稀
	0x7D00, KANJI_LEVEL4,  // 紀
	0x5FBD, KANJI_LEVEL4,  // 徽
	0x898F, KANJI_LEVEL4,  // 規
	0x8A18, KANJI_LEVEL4,  // 記
	0x8CB4, KANJI_LEVEL4,  // 貴
	0x8D77, KANJI_LEVEL4,  // 起
	0x8ECC, KANJI_LEVEL4,  // 軌
	0x8F1D, KANJI_LEVEL4,  // 輝
	0x98E2, KANJI_LEVEL4,  // 飢
	0x9A0E, KANJI_LEVEL4,  // 騎
	0x9B3C, KANJI_LEVEL4,  // 鬼
	0x4E80, KANJI_LEVEL4,  // 亀
	0x507D, KANJI_LEVEL4,  // 偽
	0x5100, KANJI_LEVEL4,  // 儀
	0x5993, KANJI_LEVEL4,  // 妓
	0x5B9C, KANJI_LEVEL4,  // 宜
	0x622F, KANJI_LEVEL4,  // 戯
	0x6280, KANJI_LEVEL4,  // 技
	0x64EC, KANJI_LEVEL4,  // 擬
	0x6B3A, KANJI_LEVEL4,  // 欺
	0x72A0, KANJI_LEVEL4,  // 犠
	0x7591, KANJI_LEVEL4,  // 疑
	0x7947, KANJI_LEVEL4,  // 祇
	0x7FA9, KANJI_LEVEL4,  // 義
	0x87FB, KANJI_LEVEL4,  // 蟻
	0x8ABC, KANJI_LEVEL4,  // 誼
	0x8B70, KANJI_LEVEL4,  // 議
	0x63AC, KANJI_LEVEL4,  // 掬
	0x83CA, KANJI_LEVEL4,  // 菊
	0x97A0, KANJI_LEVEL4,  // 鞠
	0x5409, KANJI_LEVEL4,  // 吉
	0x5403, KANJI_LEVEL4,  // 吃
	0x55AB, KANJI_LEVEL4,  // 喫
	0x6854, KANJI_LEVEL4,  // 桔
	0x6A58, KANJI_LEVEL4,  // 橘
	0x8A70, KANJI_LEVEL4,  // 詰
	0x7827, KANJI_LEVEL4,  // 砧
	0x6775, KANJI_LEVEL4,  // 杵
	0x9ECD, KANJI_LEVEL4,  // 黍
	0x5374, KANJI_LEVEL4,  // 却
	0x5BA2, KANJI_LEVEL4,  // 客
	0x811A, KANJI_LEVEL4,  // 脚
	0x8650, KANJI_LEVEL4,  // 虐
	0x9006, KANJI_LEVEL4,  // 逆
	0x4E18, KANJI_LEVEL4,  // 丘
	0x4E45, KANJI_LEVEL4,  // 久
	0x4EC7, KANJI_LEVEL4,  // 仇
	0x4F11, KANJI_LEVEL4,  // 休
	0x53CA, KANJI_LEVEL4,  // 及
	0x5438, KANJI_LEVEL4,  // 吸
	0x5BAE, KANJI_LEVEL4,  // 宮
	0x5F13, KANJI_LEVEL4,  // 弓
	0x6025, KANJI_LEVEL4,  // 急
	0x6551, KANJI_LEVEL4,  // 救
	0x673D, KANJI_LEVEL4,  // 朽
	0x6C42, KANJI_LEVEL4,  // 求
	0x6C72, KANJI_LEVEL4,  // 汲
	0x6CE3, KANJI_LEVEL4,  // 泣
	0x7078, KANJI_LEVEL4,  // 灸
	0x7403, KANJI_LEVEL4,  // 球
	0x7A76, KANJI_LEVEL4,  // 究
	0x7AAE, KANJI_LEVEL4,  // 窮
	0x7B08, KANJI_LEVEL4,  // 笈
	0x7D1A, KANJI_LEVEL4,  // 級
	0x7CFE, KANJI_LEVEL4,  // 糾
	0x7D66, KANJI_LEVEL4,  // 給
	0x65E7, KANJI_LEVEL4,  // 旧
	0x725B, KANJI_LEVEL4,  // 牛
	0x53BB, KANJI_LEVEL4,  // 去
	0x5C45, KANJI_LEVEL4,  // 居
	0x5DE8, KANJI_LEVEL4,  // 巨
	0x62D2, KANJI_LEVEL4,  // 拒
	0x62E0, KANJI_LEVEL4,  // 拠
	0x6319, KANJI_LEVEL4,  // 挙
	0x6E20, KANJI_LEVEL4,  // 渠
	0x865A, KANJI_LEVEL4,  // 虚
	0x8A31, KANJI_LEVEL4,  // 許
	0x8DDD, KANJI_LEVEL4,  // 距
	0x92F8, KANJI_LEVEL4,  // 鋸
	0x6F01, KANJI_LEVEL4,  // 漁
	0x79A6, KANJI_LEVEL4,  // 禦
	0x9B5A, KANJI_LEVEL4,  // 魚
	0x4EA8, KANJI_LEVEL4,  // 亨
	0x4EAB, KANJI_LEVEL4,  // 享
	0x4EAC, KANJI_LEVEL4,  // 京
	0x4F9B, KANJI_LEVEL4,  // 供
	0x4FA0, KANJI_LEVEL4,  // 侠
	0x50D1, KANJI_LEVEL4,  // 僑
	0x5147, KANJI_LEVEL4,  // 兇
	0x7AF6, KANJI_LEVEL4,  // 競
	0x5171, KANJI_LEVEL4,  // 共
	0x51F6, KANJI_LEVEL4,  // 凶
	0x5354, KANJI_LEVEL4,  // 協
	0x5321, KANJI_LEVEL4,  // 匡
	0x537F, KANJI_LEVEL4,  // 卿
	0x53EB, KANJI_LEVEL4,  // 叫
	0x55AC, KANJI_LEVEL4,  // 喬
	0x5883, KANJI_LEVEL4,  // 境
	0x5CE1, KANJI_LEVEL4,  // 峡
	0x5F37, KANJI_LEVEL4,  // 強
	0x5F4A, KANJI_LEVEL4,  // 彊
	0x602F, KANJI_LEVEL4,  // 怯
	0x6050, KANJI_LEVEL4,  // 恐
	0x606D, KANJI_LEVEL4,  // 恭
	0x631F, KANJI_LEVEL4,  // 挟
	0x6559, KANJI_LEVEL4,  // 教
	0x6A4B, KANJI_LEVEL4,  // 橋
	0x6CC1, KANJI_LEVEL4,  // 況
	0x72C2, KANJI_LEVEL4,  // 狂
	0x72ED, KANJI_LEVEL4,  // 狭
	0x77EF, KANJI_LEVEL4,  // 矯
	0x80F8, KANJI_LEVEL4,  // 胸
	0x8105, KANJI_LEVEL4,  // 脅
	0x8208, KANJI_LEVEL4,  // 興
	0x854E, KANJI_LEVEL4,  // 蕎
	0x90F7, KANJI_LEVEL4,  // 郷
	0x93E1, KANJI_LEVEL4,  // 鏡
	0x97FF, KANJI_LEVEL4,  // 響
	0x9957, KANJI_LEVEL4,  // 饗
	0x9A5A, KANJI_LEVEL4,  // 驚
	0x4EF0, KANJI_LEVEL4,  // 仰
	0x51DD, KANJI_LEVEL4,  // 凝
	0x5C2D, KANJI_LEVEL4,  // 尭
	0x6681, KANJI_LEVEL4,  // 暁
	0x696D, KANJI_LEVEL4,  // 業
	0x5C40, KANJI_LEVEL4,  // 局
	0x66F2, KANJI_LEVEL4,  // 曲
	0x6975, KANJI_LEVEL4,  // 極
	0x7389, KANJI_LEVEL4,  // 玉
	0x6850, KANJI_LEVEL4,  // 桐
	0x7C81, KANJI_LEVEL4,  // 粁
	0x50C5, KANJI_LEVEL4,  // 僅
	0x52E4, KANJI_LEVEL4,  // 勤
	0x5747, KANJI_LEVEL4,  // 均
	0x5DFE, KANJI_LEVEL4,  // 巾
	0x9326, KANJI_LEVEL4,  // 錦
	0x65A4, KANJI_LEVEL4,  // 斤
	0x6B23, KANJI_LEVEL4,  // 欣
	0x6B3D, KANJI_LEVEL4,  // 欽
	0x7434, KANJI_LEVEL4,  // 琴
	0x7981, KANJI_LEVEL4,  // 禁
	0x79BD, KANJI_LEVEL4,  // 禽
	0x7B4B, KANJI_LEVEL4,  // 筋
	0x7DCA, KANJI_LEVEL4,  // 緊
	0x82B9, KANJI_LEVEL4,  // 芹
	0x83CC, KANJI_LEVEL4,  // 菌
	0x887F, KANJI_LEVEL4,  // 衿
	0x895F, KANJI_LEVEL4,  // 襟
	0x8B39, KANJI_LEVEL4,  // 謹
	0x8FD1, KANJI_LEVEL4,  // 近
	0x91D1, KANJI_LEVEL4,  // 金
	0x541F, KANJI_LEVEL4,  // 吟
	0x9280, KANJI_LEVEL4,  // 銀
	0x4E5D, KANJI_LEVEL4,  // 九
	0x5036, KANJI_LEVEL4,  // 倶
	0x53E5, KANJI_LEVEL4,  // 句
	0x533A, KANJI_LEVEL4,  // 区
	0x72D7, KANJI_LEVEL4,  // 狗
	0x7396, KANJI_LEVEL4,  // 玖
	0x77E9, KANJI_LEVEL4,  // 矩
	0x82E6, KANJI_LEVEL4,  // 苦
	0x8EAF, KANJI_LEVEL4,  // 躯
	0x99C6, KANJI_LEVEL4,  // 駆
	0x99C8, KANJI_LEVEL4,  // 駈
	0x99D2, KANJI_LEVEL4,  // 駒
	0x5177, KANJI_LEVEL4,  // 具
	0x611A, KANJI_LEVEL4,  // 愚
	0x865E, KANJI_LEVEL4,  // 虞
	0x55B0, KANJI_LEVEL4,  // 喰
	0x7A7A, KANJI_LEVEL4,  // 空
	0x5076, KANJI_LEVEL4,  // 偶
	0x5BD3, KANJI_LEVEL4,  // 寓
	0x9047, KANJI_LEVEL4,  // 遇
	0x9685, KANJI_LEVEL4,  // 隅
	0x4E32, KANJI_LEVEL4,  // 串
	0x6ADB, KANJI_LEVEL4,  // 櫛
	0x91E7, KANJI_LEVEL4,  // 釧
	0x5C51, KANJI_LEVEL4,  // 屑
	0x5C48, KANJI_LEVEL4,  // 屈
	0x6398, KANJI_LEVEL4,  // 掘
	0x7A9F, KANJI_LEVEL4,  // 窟
	0x6C93, KANJI_LEVEL4,  // 沓
	0x9774, KANJI_LEVEL4,  // 靴
	0x8F61, KANJI_LEVEL4,  // 轡
	0x7AAA, KANJI_LEVEL4,  // 窪
	0x718A, KANJI_LEVEL4,  // 熊
	0x9688, KANJI_LEVEL4,  // 隈
	0x7C82, KANJI_LEVEL4,  // 粂
	0x6817, KANJI_LEVEL4,  // 栗
	0x7E70, KANJI_LEVEL4,  // 繰
	0x6851, KANJI_LEVEL4,  // 桑
	0x936C, KANJI_LEVEL4,  // 鍬
	0x52F2, KANJI_LEVEL4,  // 勲
	0x541B, KANJI_LEVEL4,  // 君
	0x85AB, KANJI_LEVEL4,  // 薫
	0x8A13, KANJI_LEVEL4,  // 訓
	0x7FA4, KANJI_LEVEL4,  // 群
	0x8ECD, KANJI_LEVEL4,  // 軍
	0x90E1, KANJI_LEVEL4,  // 郡
	0x5366, KANJI_LEVEL4,  // 卦
	0x8888, KANJI_LEVEL4,  // 袈
	0x7941, KANJI_LEVEL4,  // 祁
	0x4FC2, KANJI_LEVEL4,  // 係
	0x50BE, KANJI_LEVEL4,  // 傾
	0x5211, KANJI_LEVEL4,  // 刑
	0x5144, KANJI_LEVEL4,  // 兄
	0x5553, KANJI_LEVEL4,  // 啓
	0x572D, KANJI_LEVEL4,  // 圭
	0x73EA, KANJI_LEVEL4,  // 珪
	0x578B, KANJI_LEVEL4,  // 型
	0x5951, KANJI_LEVEL4,  // 契
	0x5F62, KANJI_LEVEL4,  // 形
	0x5F84, KANJI_LEVEL4,  // 径
	0x6075, KANJI_LEVEL4,  // 恵
	0x6176, KANJI_LEVEL4,  // 慶
	0x6167, KANJI_LEVEL4,  // 慧
	0x61A9, KANJI_LEVEL4,  // 憩
	0x63B2, KANJI_LEVEL4,  // 掲
	0x643A, KANJI_LEVEL4,  // 携
	0x656C, KANJI_LEVEL4,  // 敬
	0x666F, KANJI_LEVEL4,  // 景
	0x6842, KANJI_LEVEL4,  // 桂
	0x6E13, KANJI_LEVEL4,  // 渓
	0x7566, KANJI_LEVEL4,  // 畦
	0x7A3D, KANJI_LEVEL4,  // 稽
	0x7CFB, KANJI_LEVEL4,  // 系
	0x7D4C, KANJI_LEVEL4,  // 経
	0x7D99, KANJI_LEVEL4,  // 継
	0x7E4B, KANJI_LEVEL4,  // 繋
	0x7F6B, KANJI_LEVEL4,  // 罫
	0x830E, KANJI_LEVEL4,  // 茎
	0x834A, KANJI_LEVEL4,  // 荊
	0x86CD, KANJI_LEVEL4,  // 蛍
	0x8A08, KANJI_LEVEL4,  // 計
	0x8A63, KANJI_LEVEL4,  // 詣
	0x8B66, KANJI_LEVEL4,  // 警
	0x8EFD, KANJI_LEVEL4,  // 軽
	0x981A, KANJI_LEVEL4,  // 頚
	0x9D8F, KANJI_LEVEL4,  // 鶏
	0x82B8, KANJI_LEVEL4,  // 芸
	0x8FCE, KANJI_LEVEL4,  // 迎
	0x9BE8, KANJI_LEVEL4,  // 鯨
	0x5287, KANJI_LEVEL4,  // 劇
	0x621F, KANJI_LEVEL4,  // 戟
	0x6483, KANJI_LEVEL4,  // 撃
	0x6FC0, KANJI_LEVEL4,  // 激
	0x9699, KANJI_LEVEL4,  // 隙
	0x6841, KANJI_LEVEL4,  // 桁
	0x5091, KANJI_LEVEL4,  // 傑
	0x6B20, KANJI_LEVEL4,  // 欠
	0x6C7A, KANJI_LEVEL4,  // 決
	0x6F54, KANJI_LEVEL4,  // 潔
	0x7A74, KANJI_LEVEL4,  // 穴
	0x7D50, KANJI_LEVEL4,  // 結
	0x8840, KANJI_LEVEL4,  // 血
	0x8A23, KANJI_LEVEL4,  // 訣
	0x6708, KANJI_LEVEL4,  // 月
	0x4EF6, KANJI_LEVEL4,  // 件
	0x5039, KANJI_LEVEL4,  // 倹
	0x5026, KANJI_LEVEL4,  // 倦
	0x5065, KANJI_LEVEL4,  // 健
	0x517C, KANJI_LEVEL4,  // 兼
	0x5238, KANJI_LEVEL4,  // 券
	0x5263, KANJI_LEVEL4,  // 剣
	0x55A7, KANJI_LEVEL4,  // 喧
	0x570F, KANJI_LEVEL4,  // 圏
	0x5805, KANJI_LEVEL4,  // 堅
	0x5ACC, KANJI_LEVEL4,  // 嫌
	0x5EFA, KANJI_LEVEL4,  // 建
	0x61B2, KANJI_LEVEL4,  // 憲
	0x61F8, KANJI_LEVEL4,  // 懸
	0x62F3, KANJI_LEVEL4,  // 拳
	0x6372, KANJI_LEVEL4,  // 捲
	0x691C, KANJI_LEVEL4,  // 検
	0x6A29, KANJI_LEVEL4,  // 権
	0x727D, KANJI_LEVEL4,  // 牽
	0x72AC, KANJI_LEVEL4,  // 犬
	0x732E, KANJI_LEVEL4,  // 献
	0x7814, KANJI_LEVEL4,  // 研
	0x786F, KANJI_LEVEL4,  // 硯
	0x7D79, KANJI_LEVEL4,  // 絹
	0x770C, KANJI_LEVEL4,  // 県
	0x80A9, KANJI_LEVEL4,  // 肩
	0x898B, KANJI_LEVEL4,  // 見
	0x8B19, KANJI_LEVEL4,  // 謙
	0x8CE2, KANJI_LEVEL4,  // 賢
	0x8ED2, KANJI_LEVEL4,  // 軒
	0x9063, KANJI_LEVEL4,  // 遣
	0x9375, KANJI_LEVEL4,  // 鍵
	0x967A, KANJI_LEVEL4,  // 険
	0x9855, KANJI_LEVEL4,  // 顕
	0x9A13, KANJI_LEVEL4,  // 験
	0x9E78, KANJI_LEVEL4,  // 鹸
	0x5143, KANJI_LEVEL4,  // 元
	0x539F, KANJI_LEVEL4,  // 原
	0x53B3, KANJI_LEVEL4,  // 厳
	0x5E7B, KANJI_LEVEL4,  // 幻
	0x5F26, KANJI_LEVEL4,  // 弦
	0x6E1B, KANJI_LEVEL4,  // 減
	0x6E90, KANJI_LEVEL4,  // 源
	0x7384, KANJI_LEVEL4,  // 玄
	0x73FE, KANJI_LEVEL4,  // 現
	0x7D43, KANJI_LEVEL4,  // 絃
	0x8237, KANJI_LEVEL4,  // 舷
	0x8A00, KANJI_LEVEL4,  // 言
	0x8AFA, KANJI_LEVEL4,  // 諺
	0x9650, KANJI_LEVEL4,  // 限
	0x4E4E, KANJI_LEVEL4,  // 乎
	0x500B, KANJI_LEVEL4,  // 個
	0x53E4, KANJI_LEVEL4,  // 古
	0x547C, KANJI_LEVEL4,  // 呼
	0x56FA, KANJI_LEVEL4,  // 固
	0x59D1, KANJI_LEVEL4,  // 姑
	0x5B64, KANJI_LEVEL4,  // 孤
	0x5DF1, KANJI_LEVEL4,  // 己
	0x5EAB, KANJI_LEVEL4,  // 庫
	0x5F27, KANJI_LEVEL4,  // 弧
	0x6238, KANJI_LEVEL4,  // 戸
	0x6545, KANJI_LEVEL4,  // 故
	0x67AF, KANJI_LEVEL4,  // 枯
	0x6E56, KANJI_LEVEL4,  // 湖
	0x72D0, KANJI_LEVEL4,  // 狐
	0x7CCA, KANJI_LEVEL4,  // 糊
	0x88B4, KANJI_LEVEL4,  // 袴
	0x80A1, KANJI_LEVEL4,  // 股
	0x80E1, KANJI_LEVEL4,  // 胡
	0x83F0, KANJI_LEVEL4,  // 菰
	0x864E, KANJI_LEVEL4,  // 虎
	0x8A87, KANJI_LEVEL4,  // 誇
	0x8DE8, KANJI_LEVEL4,  // 跨
	0x9237, KANJI_LEVEL4,  // 鈷
	0x96C7, KANJI_LEVEL4,  // 雇
	0x9867, KANJI_LEVEL4,  // 顧
	0x9F13, KANJI_LEVEL4,  // 鼓
	0x4E94, KANJI_LEVEL4,  // 五
	0x4E92, KANJI_LEVEL4,  // 互
	0x4F0D, KANJI_LEVEL4,  // 伍
	0x5348, KANJI_LEVEL4,  // 午
	0x5449, KANJI_LEVEL4,  // 呉
	0x543E, KANJI_LEVEL4,  // 吾
	0x5A2F, KANJI_LEVEL4,  // 娯
	0x5F8C, KANJI_LEVEL4,  // 後
	0x5FA1, KANJI_LEVEL4,  // 御
	0x609F, KANJI_LEVEL4,  // 悟
	0x68A7, KANJI_LEVEL4,  // 梧
	0x6A8E, KANJI_LEVEL4,  // 檎
	0x745A, KANJI_LEVEL4,  // 瑚
	0x7881, KANJI_LEVEL4,  // 碁
	0x8A9E, KANJI_LEVEL4,  // 語
	0x8AA4, KANJI_LEVEL4,  // 誤
	0x8B77, KANJI_LEVEL4,  // 護
	0x9190, KANJI_LEVEL4,  // 醐
	0x4E5E, KANJI_LEVEL4,  // 乞
	0x9BC9, KANJI_LEVEL4,  // 鯉
	0x4EA4, KANJI_LEVEL4,  // 交
	0x4F7C, KANJI_LEVEL4,  // 佼
	0x4FAF, KANJI_LEVEL4,  // 侯
	0x5019, KANJI_LEVEL4,  // 候
	0x5016, KANJI_LEVEL4,  // 倖
	0x5149, KANJI_LEVEL4,  // 光
	0x516C, KANJI_LEVEL4,  // 公
	0x529F, KANJI_LEVEL4,  // 功
	0x52B9, KANJI_LEVEL4,  // 効
	0x52FE, KANJI_LEVEL4,  // 勾
	0x539A, KANJI_LEVEL4,  // 厚
	0x53E3, KANJI_LEVEL4,  // 口
	0x5411, KANJI_LEVEL4,  // 向
	0x540E, KANJI_LEVEL4,  // 后
	0x5589, KANJI_LEVEL4,  // 喉
	0x5751, KANJI_LEVEL4,  // 坑
	0x57A2, KANJI_LEVEL4,  // 垢
	0x597D, KANJI_LEVEL4,  // 好
	0x5B54, KANJI_LEVEL4,  // 孔
	0x5B5D, KANJI_LEVEL4,  // 孝
	0x5B8F, KANJI_LEVEL4,  // 宏
	0x5DE5, KANJI_LEVEL4,  // 工
	0x5DE7, KANJI_LEVEL4,  // 巧
	0x5DF7, KANJI_LEVEL4,  // 巷
	0x5E78, KANJI_LEVEL4,  // 幸
	0x5E83, KANJI_LEVEL4,  // 広
	0x5E9A, KANJI_LEVEL4,  // 庚
	0x5EB7, KANJI_LEVEL4,  // 康
	0x5F18, KANJI_LEVEL4,  // 弘
	0x6052, KANJI_LEVEL4,  // 恒
	0x614C, KANJI_LEVEL4,  // 慌
	0x6297, KANJI_LEVEL4,  // 抗
	0x62D8, KANJI_LEVEL4,  // 拘
	0x63A7, KANJI_LEVEL4,  // 控
	0x653B, KANJI_LEVEL4,  // 攻
	0x6602, KANJI_LEVEL4,  // 昂
	0x6643, KANJI_LEVEL4,  // 晃
	0x66F4, KANJI_LEVEL4,  // 更
	0x676D, KANJI_LEVEL4,  // 杭
	0x6821, KANJI_LEVEL4,  // 校
	0x6897, KANJI_LEVEL4,  // 梗
	0x69CB, KANJI_LEVEL4,  // 構
	0x6C5F, KANJI_LEVEL4,  // 江
	0x6D2A, KANJI_LEVEL4,  // 洪
	0x6D69, KANJI_LEVEL4,  // 浩
	0x6E2F, KANJI_LEVEL4,  // 港
	0x6E9D, KANJI_LEVEL4,  // 溝
	0x7532, KANJI_LEVEL4,  // 甲
	0x7687, KANJI_LEVEL4,  // 皇
	0x786C, KANJI_LEVEL4,  // 硬
	0x7A3F, KANJI_LEVEL4,  // 稿
	0x7CE0, KANJI_LEVEL4,  // 糠
	0x7D05, KANJI_LEVEL4,  // 紅
	0x7D18, KANJI_LEVEL4,  // 紘
	0x7D5E, KANJI_LEVEL4,  // 絞
	0x7DB1, KANJI_LEVEL4,  // 綱
	0x8015, KANJI_LEVEL4,  // 耕
	0x8003, KANJI_LEVEL4,  // 考
	0x80AF, KANJI_LEVEL4,  // 肯
	0x80B1, KANJI_LEVEL4,  // 肱
	0x8154, KANJI_LEVEL4,  // 腔
	0x818F, KANJI_LEVEL4,  // 膏
	0x822A, KANJI_LEVEL4,  // 航
	0x8352, KANJI_LEVEL4,  // 荒
	0x884C, KANJI_LEVEL4,  // 行
	0x8861, KANJI_LEVEL4,  // 衡
	0x8B1B, KANJI_LEVEL4,  // 講
	0x8CA2, KANJI_LEVEL4,  // 貢
	0x8CFC, KANJI_LEVEL4,  // 購
	0x90CA, KANJI_LEVEL4,  // 郊
	0x9175, KANJI_LEVEL4,  // 酵
	0x9271, KANJI_LEVEL4,  // 鉱
	0x783F, KANJI_LEVEL4,  // 砿
	0x92FC, KANJI_LEVEL4,  // 鋼
	0x95A4, KANJI_LEVEL4,  // 閤
	0x964D, KANJI_LEVEL4,  // 降
	0x9805, KANJI_LEVEL4,  // 項
	0x9999, KANJI_LEVEL4,  // 香
	0x9AD8, KANJI_LEVEL4,  // 高
	0x9D3B, KANJI_LEVEL4,  // 鴻
	0x525B, KANJI_LEVEL4,  // 剛
	0x52AB, KANJI_LEVEL4,  // 劫
	0x53F7, KANJI_LEVEL4,  // 号
	0x5408, KANJI_LEVEL4,  // 合
	0x58D5, KANJI_LEVEL4,  // 壕
	0x62F7, KANJI_LEVEL4,  // 拷
	0x6FE0, KANJI_LEVEL4,  // 濠
	0x8C6A, KANJI_LEVEL4,  // 豪
	0x8F5F, KANJI_LEVEL4,  // 轟
	0x9EB9, KANJI_LEVEL4,  // 麹
	0x514B, KANJI_LEVEL4,  // 克
	0x523B, KANJI_LEVEL4,  // 刻
	0x544A, KANJI_LEVEL4,  // 告
	0x56FD, KANJI_LEVEL4,  // 国
	0x7A40, KANJI_LEVEL4,  // 穀
	0x9177, KANJI_LEVEL4,  // 酷
	0x9D60, KANJI_LEVEL4,  // 鵠
	0x9ED2, KANJI_LEVEL4,  // 黒
	0x7344, KANJI_LEVEL4,  // 獄
	0x6F09, KANJI_LEVEL4,  // 漉
	0x8170, KANJI_LEVEL4,  // 腰
	0x7511, KANJI_LEVEL4,  // 甑
	0x5FFD, KANJI_LEVEL4,  // 忽
	0x60DA, KANJI_LEVEL4,  // 惚
	0x9AA8, KANJI_LEVEL4,  // 骨
	0x72DB, KANJI_LEVEL4,  // 狛
	0x8FBC, KANJI_LEVEL4,  // 込
	0x6B64, KANJI_LEVEL4,  // 此
	0x9803, KANJI_LEVEL4,  // 頃
	0x4ECA, KANJI_LEVEL4,  // 今
	0x56F0, KANJI_LEVEL4,  // 困
	0x5764, KANJI_LEVEL4,  // 坤
	0x58BE, KANJI_LEVEL4,  // 墾
	0x5A5A, KANJI_LEVEL4,  // 婚
	0x6068, KANJI_LEVEL4,  // 恨
	0x61C7, KANJI_LEVEL4,  // 懇
	0x660F, KANJI_LEVEL4,  // 昏
	0x6606, KANJI_LEVEL4,  // 昆
	0x6839, KANJI_LEVEL4,  // 根
	0x68B1, KANJI_LEVEL4,  // 梱
	0x6DF7, KANJI_LEVEL4,  // 混
	0x75D5, KANJI_LEVEL4,  // 痕
	0x7D3A, KANJI_LEVEL4,  // 紺
	0x826E, KANJI_LEVEL4,  // 艮
	0x9B42, KANJI_LEVEL4,  // 魂
	0x4E9B, KANJI_LEVEL4,  // 些
	0x4F50, KANJI_LEVEL4,  // 佐
	0x53C9, KANJI_LEVEL4,  // 叉
	0x5506, KANJI_LEVEL4,  // 唆
	0x5D6F, KANJI_LEVEL4,  // 嵯
	0x5DE6, KANJI_LEVEL4,  // 左
	0x5DEE, KANJI_LEVEL4,  // 差
	0x67FB, KANJI_LEVEL4,  // 査
	0x6C99, KANJI_LEVEL4,  // 沙
	0x7473, KANJI_LEVEL4,  // 瑳
	0x7802, KANJI_LEVEL4,  // 砂
	0x8A50, KANJI_LEVEL4,  // 詐
	0x9396, KANJI_LEVEL4,  // 鎖
	0x88DF, KANJI_LEVEL4,  // 裟
	0x5750, KANJI_LEVEL4,  // 坐
	0x5EA7, KANJI_LEVEL4,  // 座
	0x632B, KANJI_LEVEL4,  // 挫
	0x50B5, KANJI_LEVEL4,  // 債
	0x50AC, KANJI_LEVEL4,  // 催
	0x518D, KANJI_LEVEL4,  // 再
	0x6700, KANJI_LEVEL4,  // 最
	0x54C9, KANJI_LEVEL4,  // 哉
	0x585E, KANJI_LEVEL4,  // 塞
	0x59BB, KANJI_LEVEL4,  // 妻
	0x5BB0, KANJI_LEVEL4,  // 宰
	0x5F69, KANJI_LEVEL4,  // 彩
	0x624D, KANJI_LEVEL4,  // 才
	0x63A1, KANJI_LEVEL4,  // 採
	0x683D, KANJI_LEVEL4,  // 栽
	0x6B73, KANJI_LEVEL4,  // 歳
	0x6E08, KANJI_LEVEL4,  // 済
	0x707D, KANJI_LEVEL4,  // 災
	0x91C7, KANJI_LEVEL4,  // 采
	0x7280, KANJI_LEVEL4,  // 犀
	0x7815, KANJI_LEVEL4,  // 砕
	0x7826, KANJI_LEVEL4,  // 砦
	0x796D, KANJI_LEVEL4,  // 祭
	0x658E, KANJI_LEVEL4,  // 斎
	0x7D30, KANJI_LEVEL4,  // 細
	0x83DC, KANJI_LEVEL4,  // 菜
	0x88C1, KANJI_LEVEL4,  // 裁
	0x8F09, KANJI_LEVEL4,  // 載
	0x969B, KANJI_LEVEL4,  // 際
	0x5264, KANJI_LEVEL4,  // 剤
	0x5728, KANJI_LEVEL4,  // 在
	0x6750, KANJI_LEVEL4,  // 材
	0x7F6A, KANJI_LEVEL4,  // 罪
	0x8CA1, KANJI_LEVEL4,  // 財
	0x51B4, KANJI_LEVEL4,  // 冴
	0x5742, KANJI_LEVEL4,  // 坂
	0x962A, KANJI_LEVEL4,  // 阪
	0x583A, KANJI_LEVEL4,  // 堺
	0x698A, KANJI_LEVEL4,  // 榊
	0x80B4, KANJI_LEVEL4,  // 肴
	0x54B2, KANJI_LEVEL4,  // 咲
	0x5D0E, KANJI_LEVEL4,  // 崎
	0x57FC, KANJI_LEVEL4,  // 埼
	0x7895, KANJI_LEVEL4,  // 碕
	0x9DFA, KANJI_LEVEL4,  // 鷺
	0x4F5C, KANJI_LEVEL4,  // 作
	0x524A, KANJI_LEVEL4,  // 削
	0x548B, KANJI_LEVEL4,  // 咋
	0x643E, KANJI_LEVEL4,  // 搾
	0x6628, KANJI_LEVEL4,  // 昨
	0x6714, KANJI_LEVEL4,  // 朔
	0x67F5, KANJI_LEVEL4,  // 柵
	0x7A84, KANJI_LEVEL4,  // 窄
	0x7B56, KANJI_LEVEL4,  // 策
	0x7D22, KANJI_LEVEL4,  // 索
	0x932F, KANJI_LEVEL4,  // 錯
	0x685C, KANJI_LEVEL4,  // 桜
	0x9BAD, KANJI_LEVEL4,  // 鮭
	0x7B39, KANJI_LEVEL4,  // 笹
	0x5319, KANJI_LEVEL4,  // 匙
	0x518A, KANJI_LEVEL4,  // 冊
	0x5237, KANJI_LEVEL4,  // 刷
	0x5BDF, KANJI_LEVEL4,  // 察
	0x62F6, KANJI_LEVEL4,  // 拶
	0x64AE, KANJI_LEVEL4,  // 撮
	0x64E6, KANJI_LEVEL4,  // 擦
	0x672D, KANJI_LEVEL4,  // 札
	0x6BBA, KANJI_LEVEL4,  // 殺
	0x85A9, KANJI_LEVEL4,  // 薩
	0x96D1, KANJI_LEVEL4,  // 雑
	0x7690, KANJI_LEVEL4,  // 皐
	0x9BD6, KANJI_LEVEL4,  // 鯖
	0x634C, KANJI_LEVEL4,  // 捌
	0x9306, KANJI_LEVEL4,  // 錆
	0x9BAB, KANJI_LEVEL4,  // 鮫
	0x76BF, KANJI_LEVEL4,  // 皿
	0x6652, KANJI_LEVEL4,  // 晒
	0x4E09, KANJI_LEVEL4,  // 三
	0x5098, KANJI_LEVEL4,  // 傘
	0x53C2, KANJI_LEVEL4,  // 参
	0x5C71, KANJI_LEVEL4,  // 山
	0x60E8, KANJI_LEVEL4,  // 惨
	0x6492, KANJI_LEVEL4,  // 撒
	0x6563, KANJI_LEVEL4,  // 散
	0x685F, KANJI_LEVEL4,  // 桟
	0x71E6, KANJI_LEVEL4,  // 燦
	0x73CA, KANJI_LEVEL4,  // 珊
	0x7523, KANJI_LEVEL4,  // 産
	0x7B97, KANJI_LEVEL4,  // 算
	0x7E82, KANJI_LEVEL4,  // 纂
	0x8695, KANJI_LEVEL4,  // 蚕
	0x8B83, KANJI_LEVEL4,  // 讃
	0x8CDB, KANJI_LEVEL4,  // 賛
	0x9178, KANJI_LEVEL4,  // 酸
	0x9910, KANJI_LEVEL4,  // 餐
	0x65AC, KANJI_LEVEL4,  // 斬
	0x66AB, KANJI_LEVEL4,  // 暫
	0x6B8B, KANJI_LEVEL4,  // 残
	0x4ED5, KANJI_LEVEL4,  // 仕
	0x4ED4, KANJI_LEVEL4,  // 仔
	0x4F3A, KANJI_LEVEL4,  // 伺
	0x4F7F, KANJI_LEVEL4,  // 使
	0x523A, KANJI_LEVEL4,  // 刺
	0x53F8, KANJI_LEVEL4,  // 司
	0x53F2, KANJI_LEVEL4,  // 史
	0x55E3, KANJI_LEVEL4,  // 嗣
	0x56DB, KANJI_LEVEL4,  // 四
	0x58EB, KANJI_LEVEL4,  // 士
	0x59CB, KANJI_LEVEL4,  // 始
	0x59C9, KANJI_LEVEL4,  // 姉
	0x59FF, KANJI_LEVEL4,  // 姿
	0x5B50, KANJI_LEVEL4,  // 子
	0x5C4D, KANJI_LEVEL4,  // 屍
	0x5E02, KANJI_LEVEL4,  // 市
	0x5E2B, KANJI_LEVEL4,  // 師
	0x5FD7, KANJI_LEVEL4,  // 志
	0x601D, KANJI_LEVEL4,  // 思
	0x6307, KANJI_LEVEL4,  // 指
	0x652F, KANJI_LEVEL4,  // 支
	0x5B5C, KANJI_LEVEL4,  // 孜
	0x65AF, KANJI_LEVEL4,  // 斯
	0x65BD, KANJI_LEVEL4,  // 施
	0x65E8, KANJI_LEVEL4,  // 旨
	0x679D, KANJI_LEVEL4,  // 枝
	0x6B62, KANJI_LEVEL4,  // 止
	0x6B7B, KANJI_LEVEL4,  // 死
	0x6C0F, KANJI_LEVEL4,  // 氏
	0x7345, KANJI_LEVEL4,  // 獅
	0x7949, KANJI_LEVEL4,  // 祉
	0x79C1, KANJI_LEVEL4,  // 私
	0x7CF8, KANJI_LEVEL4,  // 糸
	0x7D19, KANJI_LEVEL4,  // 紙
	0x7D2B, KANJI_LEVEL4,  // 紫
	0x80A2, KANJI_LEVEL4,  // 肢
	0x8102, KANJI_LEVEL4,  // 脂
	0x81F3, KANJI_LEVEL4,  // 至
	0x8996, KANJI_LEVEL4,  // 視
	0x8A5E, KANJI_LEVEL4,  // 詞
	0x8A69, KANJI_LEVEL4,  // 詩
	0x8A66, KANJI_LEVEL4,  // 試
	0x8A8C, KANJI_LEVEL4,  // 誌
	0x8AEE, KANJI_LEVEL4,  // 諮
	0x8CC7, KANJI_LEVEL4,  // 資
	0x8CDC, KANJI_LEVEL4,  // 賜
	0x96CC, KANJI_LEVEL4,  // 雌
	0x98FC, KANJI_LEVEL4,  // 飼
	0x6B6F, KANJI_LEVEL4,  // 歯
	0x4E8B, KANJI_LEVEL4,  // 事
	0x4F3C, KANJI_LEVEL4,  // 似
	0x4F8D, KANJI_LEVEL4,  // 侍
	0x5150, KANJI_LEVEL4,  // 児
	0x5B57, KANJI_LEVEL4,  // 字
	0x5BFA, KANJI_LEVEL4,  // 寺
	0x6148, KANJI_LEVEL4,  // 慈
	0x6301, KANJI_LEVEL4,  // 持
	0x6642, KANJI_LEVEL4,  // 時
	0x6B21, KANJI_LEVEL4,  // 次
	0x6ECB, KANJI_LEVEL4,  // 滋
	0x6CBB, KANJI_LEVEL4,  // 治
	0x723E, KANJI_LEVEL4,  // 爾
	0x74BD, KANJI_LEVEL4,  // 璽
	0x75D4, KANJI_LEVEL4,  // 痔
	0x78C1, KANJI_LEVEL4,  // 磁
	0x793A, KANJI_LEVEL4,  // 示
	0x800C, KANJI_LEVEL4,  // 而
	0x8033, KANJI_LEVEL4,  // 耳
	0x81EA, KANJI_LEVEL4,  // 自
	0x8494, KANJI_LEVEL4,  // 蒔
	0x8F9E, KANJI_LEVEL4,  // 辞
	0x6C50, KANJI_LEVEL4,  // 汐
	0x9E7F, KANJI_LEVEL4,  // 鹿
	0x5F0F, KANJI_LEVEL4,  // 式
	0x8B58, KANJI_LEVEL4,  // 識
	0x9D2B, KANJI_LEVEL4,  // 鴫
	0x7AFA, KANJI_LEVEL4,  // 竺
	0x8EF8, KANJI_LEVEL4,  // 軸
	0x5B8D, KANJI_LEVEL4,  // 宍
	0x96EB, KANJI_LEVEL4,  // 雫
	0x4E03, KANJI_LEVEL4,  // 七
	0x53F1, KANJI_LEVEL4,  // 叱
	0x57F7, KANJI_LEVEL4,  // 執
	0x5931, KANJI_LEVEL4,  // 失
	0x5AC9, KANJI_LEVEL4,  // 嫉
	0x5BA4, KANJI_LEVEL4,  // 室
	0x6089, KANJI_LEVEL4,  // 悉
	0x6E7F, KANJI_LEVEL4,  // 湿
	0x6F06, KANJI_LEVEL4,  // 漆
	0x75BE, KANJI_LEVEL4,  // 疾
	0x8CEA, KANJI_LEVEL4,  // 質
	0x5B9F, KANJI_LEVEL4,  // 実
	0x8500, KANJI_LEVEL4,  // 蔀
	0x7BE0, KANJI_LEVEL4,  // 篠
	0x5072, KANJI_LEVEL4,  // 偲
	0x67F4, KANJI_LEVEL4,  // 柴
	0x829D, KANJI_LEVEL4,  // 芝
	0x5C61, KANJI_LEVEL4,  // 屡
	0x854A, KANJI_LEVEL4,  // 蕊
	0x7E1E, KANJI_LEVEL4,  // 縞
	0x820E, KANJI_LEVEL4,  // 舎
	0x5199, KANJI_LEVEL4,  // 写
	0x5C04, KANJI_LEVEL4,  // 射
	0x6368, KANJI_LEVEL4,  // 捨
	0x8D66, KANJI_LEVEL4,  // 赦
	0x659C, KANJI_LEVEL4,  // 斜
	0x716E, KANJI_LEVEL4,  // 煮
	0x793E, KANJI_LEVEL4,  // 社
	0x7D17, KANJI_LEVEL4,  // 紗
	0x8005, KANJI_LEVEL4,  // 者
	0x8B1D, KANJI_LEVEL4,  // 謝
	0x8ECA, KANJI_LEVEL4,  // 車
	0x906E, KANJI_LEVEL4,  // 遮
	0x86C7, KANJI_LEVEL4,  // 蛇
	0x90AA, KANJI_LEVEL4,  // 邪
	0x501F, KANJI_LEVEL4,  // 借
	0x52FA, KANJI_LEVEL4,  // 勺
	0x5C3A, KANJI_LEVEL4,  // 尺
	0x6753, KANJI_LEVEL4,  // 杓
	0x707C, KANJI_LEVEL4,  // 灼
	0x7235, KANJI_LEVEL4,  // 爵
	0x914C, KANJI_LEVEL4,  // 酌
	0x91C8, KANJI_LEVEL4,  // 釈
	0x932B, KANJI_LEVEL4,  // 錫
	0x82E5, KANJI_LEVEL4,  // 若
	0x5BC2, KANJI_LEVEL4,  // 寂
	0x5F31, KANJI_LEVEL4,  // 弱
	0x60F9, KANJI_LEVEL4,  // 惹
	0x4E3B, KANJI_LEVEL4,  // 主
	0x53D6, KANJI_LEVEL4,  // 取
	0x5B88, KANJI_LEVEL4,  // 守
	0x624B, KANJI_LEVEL4,  // 手
	0x6731, KANJI_LEVEL4,  // 朱
	0x6B8A, KANJI_LEVEL4,  // 殊
	0x72E9, KANJI_LEVEL4,  // 狩
	0x73E0, KANJI_LEVEL4,  // 珠
	0x7A2E, KANJI_LEVEL4,  // 種
	0x816B, KANJI_LEVEL4,  // 腫
	0x8DA3, KANJI_LEVEL4,  // 趣
	0x9152, KANJI_LEVEL4,  // 酒
	0x9996, KANJI_LEVEL4,  // 首
	0x5112, KANJI_LEVEL4,  // 儒
	0x53D7, KANJI_LEVEL4,  // 受
	0x546A, KANJI_LEVEL4,  // 呪
	0x5BFF, KANJI_LEVEL4,  // 寿
	0x6388, KANJI_LEVEL4,  // 授
	0x6A39, KANJI_LEVEL4,  // 樹
	0x7DAC, KANJI_LEVEL4,  // 綬
	0x9700, KANJI_LEVEL4,  // 需
	0x56DA, KANJI_LEVEL4,  // 囚
	0x53CE, KANJI_LEVEL4,  // 収
	0x5468, KANJI_LEVEL4,  // 周
	0x5B97, KANJI_LEVEL4,  // 宗
	0x5C31, KANJI_LEVEL4,  // 就
	0x5DDE, KANJI_LEVEL4,  // 州
	0x4FEE, KANJI_LEVEL4,  // 修
	0x6101, KANJI_LEVEL4,  // 愁
	0x62FE, KANJI_LEVEL4,  // 拾
	0x6D32, KANJI_LEVEL4,  // 洲
	0x79C0, KANJI_LEVEL4,  // 秀
	0x79CB, KANJI_LEVEL4,  // 秋
	0x7D42, KANJI_LEVEL4,  // 終
	0x7E4D, KANJI_LEVEL4,  // 繍
	0x7FD2, KANJI_LEVEL4,  // 習
	0x81ED, KANJI_LEVEL4,  // 臭
	0x821F, KANJI_LEVEL4,  // 舟
	0x8490, KANJI_LEVEL4,  // 蒐
	0x8846, KANJI_LEVEL4,  // 衆
	0x8972, KANJI_LEVEL4,  // 襲
	0x8B90, KANJI_LEVEL4,  // 讐
	0x8E74, KANJI_LEVEL4,  // 蹴
	0x8F2F, KANJI_LEVEL4,  // 輯
	0x9031, KANJI_LEVEL4,  // 週
	0x914B, KANJI_LEVEL4,  // 酋
	0x916C, KANJI_LEVEL4,  // 酬
	0x96C6, KANJI_LEVEL4,  // 集
	0x919C, KANJI_LEVEL4,  // 醜
	0x4EC0, KANJI_LEVEL4,  // 什
	0x4F4F, KANJI_LEVEL4,  // 住
	0x5145, KANJI_LEVEL4,  // 充
	0x5341, KANJI_LEVEL4,  // 十
	0x5F93, KANJI_LEVEL4,  // 従
	0x620E, KANJI_LEVEL4,  // 戎
	0x67D4, KANJI_LEVEL4,  // 柔
	0x6C41, KANJI_LEVEL4,  // 汁
	0x6E0B, KANJI_LEVEL4,  // 渋
	0x7363, KANJI_LEVEL4,  // 獣
	0x7E26, KANJI_LEVEL4,  // 縦
	0x91CD, KANJI_LEVEL4,  // 重
	0x9283, KANJI_LEVEL4,  // 銃
	0x53D4, KANJI_LEVEL4,  // 叔
	0x5919, KANJI_LEVEL4,  // 夙
	0x5BBF, KANJI_LEVEL4,  // 宿
	0x6DD1, KANJI_LEVEL4,  // 淑
	0x795D, KANJI_LEVEL4,  // 祝
	0x7E2E, KANJI_LEVEL4,  // 縮
	0x7C9B, KANJI_LEVEL4,  // 粛
	0x587E, KANJI_LEVEL4,  // 塾
	0x719F, KANJI_LEVEL4,  // 熟
	0x51FA, KANJI_LEVEL4,  // 出
	0x8853, KANJI_LEVEL4,  // 術
	0x8FF0, KANJI_LEVEL4,  // 述
	0x4FCA, KANJI_LEVEL4,  // 俊
	0x5CFB, KANJI_LEVEL4,  // 峻
	0x6625, KANJI_LEVEL4,  // 春
	0x77AC, KANJI_LEVEL4,  // 瞬
	0x7AE3, KANJI_LEVEL4,  // 竣
	0x821C, KANJI_LEVEL4,  // 舜
	0x99FF, KANJI_LEVEL4,  // 駿
	0x51C6, KANJI_LEVEL4,  // 准
	0x5FAA, KANJI_LEVEL4,  // 循
	0x65EC, KANJI_LEVEL4,  // 旬
	0x696F, KANJI_LEVEL4,  // 楯
	0x6B89, KANJI_LEVEL4,  // 殉
	0x6DF3, KANJI_LEVEL4,  // 淳
	0x6E96, KANJI_LEVEL4,  // 準
	0x6F64, KANJI_LEVEL4,  // 潤
	0x76FE, KANJI_LEVEL4,  // 盾
	0x7D14, KANJI_LEVEL4,  // 純
	0x5DE1, KANJI_LEVEL4,  // 巡
	0x9075, KANJI_LEVEL4,  // 遵
	0x9187, KANJI_LEVEL4,  // 醇
	0x9806, KANJI_LEVEL4,  // 順
	0x51E6, KANJI_LEVEL4,  // 処
	0x521D, KANJI_LEVEL4,  // 初
	0x6240, KANJI_LEVEL4,  // 所
	0x6691, KANJI_LEVEL4,  // 暑
	0x66D9, KANJI_LEVEL4,  // 曙
	0x6E1A, KANJI_LEVEL4,  // 渚
	0x5EB6, KANJI_LEVEL4,  // 庶
	0x7DD2, KANJI_LEVEL4,  // 緒
	0x7F72, KANJI_LEVEL4,  // 署
	0x66F8, KANJI_LEVEL4,  // 書
	0x85AF, KANJI_LEVEL4,  // 薯
	0x85F7, KANJI_LEVEL4,  // 藷
	0x8AF8, KANJI_LEVEL4,  // 諸
	0x52A9, KANJI_LEVEL4,  // 助
	0x53D9, KANJI_LEVEL4,  // 叙
	0x5973, KANJI_LEVEL4,  // 女
	0x5E8F, KANJI_LEVEL4,  // 序
	0x5F90, KANJI_LEVEL4,  // 徐
	0x6055, KANJI_LEVEL4,  // 恕
	0x92E4, KANJI_LEVEL4,  // 鋤
	0x9664, KANJI_LEVEL4,  // 除
	0x50B7, KANJI_LEVEL4,  // 傷
	0x511F, KANJI_LEVEL4,  // 償
	0x52DD, KANJI_LEVEL4,  // 勝
	0x5320, KANJI_LEVEL4,  // 匠
	0x5347, KANJI_LEVEL4,  // 升
	0x53EC, KANJI_LEVEL4,  // 召
	0x54E8, KANJI_LEVEL4,  // 哨
	0x5546, KANJI_LEVEL4,  // 商
	0x5531, KANJI_LEVEL4,  // 唱
	0x5617, KANJI_LEVEL4,  // 嘗
	0x5968, KANJI_LEVEL4,  // 奨
	0x59BE, KANJI_LEVEL4,  // 妾
	0x5A3C, KANJI_LEVEL4,  // 娼
	0x5BB5, KANJI_LEVEL4,  // 宵
	0x5C06, KANJI_LEVEL4,  // 将
	0x5C0F, KANJI_LEVEL4,  // 小
	0x5C11, KANJI_LEVEL4,  // 少
	0x5C1A, KANJI_LEVEL4,  // 尚
	0x5E84, KANJI_LEVEL4,  // 庄
	0x5E8A, KANJI_LEVEL4,  // 床
	0x5EE0, KANJI_LEVEL4,  // 廠
	0x5F70, KANJI_LEVEL4,  // 彰
	0x627F, KANJI_LEVEL4,  // 承
	0x6284, KANJI_LEVEL4,  // 抄
	0x62DB, KANJI_LEVEL4,  // 招
	0x638C, KANJI_LEVEL4,  // 掌
	0x6377, KANJI_LEVEL4,  // 捷
	0x6607, KANJI_LEVEL4,  // 昇
	0x660C, KANJI_LEVEL4,  // 昌
	0x662D, KANJI_LEVEL4,  // 昭
	0x6676, KANJI_LEVEL4,  // 晶
	0x677E, KANJI_LEVEL4,  // 松
	0x68A2, KANJI_LEVEL4,  // 梢
	0x6A1F, KANJI_LEVEL4,  // 樟
	0x6A35, KANJI_LEVEL4,  // 樵
	0x6CBC, KANJI_LEVEL4,  // 沼
	0x6D88, KANJI_LEVEL4,  // 消
	0x6E09, KANJI_LEVEL4,  // 渉
	0x6E58, KANJI_LEVEL4,  // 湘
	0x713C, KANJI_LEVEL4,  // 焼
	0x7126, KANJI_LEVEL4,  // 焦
	0x7167, KANJI_LEVEL4,  // 照
	0x75C7, KANJI_LEVEL4,  // 症
	0x7701, KANJI_LEVEL4,  // 省
	0x785D, KANJI_LEVEL4,  // 硝
	0x7901, KANJI_LEVEL4,  // 礁
	0x7965, KANJI_LEVEL4,  // 祥
	0x79F0, KANJI_LEVEL4,  // 称
	0x7AE0, KANJI_LEVEL4,  // 章
	0x7B11, KANJI_LEVEL4,  // 笑
	0x7CA7, KANJI_LEVEL4,  // 粧
	0x7D39, KANJI_LEVEL4,  // 紹
	0x8096, KANJI_LEVEL4,  // 肖
	0x83D6, KANJI_LEVEL4,  // 菖
	0x848B, KANJI_LEVEL4,  // 蒋
	0x8549, KANJI_LEVEL4,  // 蕉
	0x885D, KANJI_LEVEL4,  // 衝
	0x88F3, KANJI_LEVEL4,  // 裳
	0x8A1F, KANJI_LEVEL4,  // 訟
	0x8A3C, KANJI_LEVEL4,  // 証
	0x8A54, KANJI_LEVEL4,  // 詔
	0x8A73, KANJI_LEVEL4,  // 詳
	0x8C61, KANJI_LEVEL4,  // 象
	0x8CDE, KANJI_LEVEL4,  // 賞
	0x91A4, KANJI_LEVEL4,  // 醤
	0x9266, KANJI_LEVEL4,  // 鉦
	0x937E, KANJI_LEVEL4,  // 鍾
	0x9418, KANJI_LEVEL4,  // 鐘
	0x969C, KANJI_LEVEL4,  // 障
	0x9798, KANJI_LEVEL4,  // 鞘
	0x4E0A, KANJI_LEVEL4,  // 上
	0x4E08, KANJI_LEVEL4,  // 丈
	0x4E1E, KANJI_LEVEL4,  // 丞
	0x4E57, KANJI_LEVEL4,  // 乗
	0x5197, KANJI_LEVEL4,  // 冗
	0x5270, KANJI_LEVEL4,  // 剰
	0x57CE, KANJI_LEVEL4,  // 城
	0x5834, KANJI_LEVEL4,  // 場
	0x58CC, KANJI_LEVEL4,  // 壌
	0x5B22, KANJI_LEVEL4,  // 嬢
	0x5E38, KANJI_LEVEL4,  // 常
	0x60C5, KANJI_LEVEL4,  // 情
	0x64FE, KANJI_LEVEL4,  // 擾
	0x6761, KANJI_LEVEL4,  // 条
	0x6756, KANJI_LEVEL4,  // 杖
	0x6D44, KANJI_LEVEL4,  // 浄
	0x72B6, KANJI_LEVEL4,  // 状
	0x7573, KANJI_LEVEL4,  // 畳
	0x7A63, KANJI_LEVEL4,  // 穣
	0x84B8, KANJI_LEVEL4,  // 蒸
	0x8B72, KANJI_LEVEL4,  // 譲
	0x91B8, KANJI_LEVEL4,  // 醸
	0x9320, KANJI_LEVEL4,  // 錠
	0x5631, KANJI_LEVEL4,  // 嘱
	0x57F4, KANJI_LEVEL4,  // 埴
	0x98FE, KANJI_LEVEL4,  // 飾
	0x62ED, KANJI_LEVEL4,  // 拭
	0x690D, KANJI_LEVEL4,  // 植
	0x6B96, KANJI_LEVEL4,  // 殖
	0x71ED, KANJI_LEVEL4,  // 燭
	0x7E54, KANJI_LEVEL4,  // 織
	0x8077, KANJI_LEVEL4,  // 職
	0x8272, KANJI_LEVEL4,  // 色
	0x89E6, KANJI_LEVEL4,  // 触
	0x98DF, KANJI_LEVEL4,  // 食
	0x8755, KANJI_LEVEL4,  // 蝕
	0x8FB1, KANJI_LEVEL4,  // 辱
	0x5C3B, KANJI_LEVEL4,  // 尻
	0x4F38, KANJI_LEVEL4,  // 伸
	0x4FE1, KANJI_LEVEL4,  // 信
	0x4FB5, KANJI_LEVEL4,  // 侵
	0x5507, KANJI_LEVEL4,  // 唇
	0x5A20, KANJI_LEVEL4,  // 娠
	0x5BDD, KANJI_LEVEL4,  // 寝
	0x5BE9, KANJI_LEVEL4,  // 審
	0x5FC3, KANJI_LEVEL4,  // 心
	0x614E, KANJI_LEVEL4,  // 慎
	0x632F, KANJI_LEVEL4,  // 振
	0x65B0, KANJI_LEVEL4,  // 新
	0x664B, KANJI_LEVEL4,  // 晋
	0x68EE, KANJI_LEVEL4,  // 森
	0x699B, KANJI_LEVEL4,  // 榛
	0x6D78, KANJI_LEVEL4,  // 浸
	0x6DF1, KANJI_LEVEL4,  // 深
	0x7533, KANJI_LEVEL4,  // 申
	0x75B9, KANJI_LEVEL4,  // 疹
	0x771F, KANJI_LEVEL4,  // 真
	0x795E, KANJI_LEVEL4,  // 神
	0x79E6, KANJI_LEVEL4,  // 秦
	0x7D33, KANJI_LEVEL4,  // 紳
	0x81E3, KANJI_LEVEL4,  // 臣
	0x82AF, KANJI_LEVEL4,  // 芯
	0x85AA, KANJI_LEVEL4,  // 薪
	0x89AA, KANJI_LEVEL4,  // 親
	0x8A3A, KANJI_LEVEL4,  // 診
	0x8EAB, KANJI_LEVEL4,  // 身
	0x8F9B, KANJI_LEVEL4,  // 辛
	0x9032, KANJI_LEVEL4,  // 進
	0x91DD, KANJI_LEVEL4,  // 針
	0x9707, KANJI_LEVEL4,  // 震
	0x4EBA, KANJI_LEVEL4,  // 人
	0x4EC1, KANJI_LEVEL4,  // 仁
	0x5203, KANJI_LEVEL4,  // 刃
	0x5875, KANJI_LEVEL4,  // 塵
	0x58EC, KANJI_LEVEL4,  // 壬
	0x5C0B, KANJI_LEVEL4,  // 尋
	0x751A, KANJI_LEVEL4,  // 甚
	0x5C3D, KANJI_LEVEL4,  // 尽
	0x814E, KANJI_LEVEL4,  // 腎
	0x8A0A, KANJI_LEVEL4,  // 訊
	0x8FC5, KANJI_LEVEL4,  // 迅
	0x9663, KANJI_LEVEL4,  // 陣
	0x976D, KANJI_LEVEL4,  // 靭
	0x7B25, KANJI_LEVEL4,  // 笥
	0x8ACF, KANJI_LEVEL4,  // 諏
	0x9808, KANJI_LEVEL4,  // 須
	0x9162, KANJI_LEVEL4,  // 酢
	0x56F3, KANJI_LEVEL4,  // 図
	0x53A8, KANJI_LEVEL4,  // 厨
	0x9017, KANJI_LEVEL4,  // 逗
	0x5439, KANJI_LEVEL4,  // 吹
	0x5782, KANJI_LEVEL4,  // 垂
	0x5E25, KANJI_LEVEL4,  // 帥
	0x63A8, KANJI_LEVEL4,  // 推
	0x6C34, KANJI_LEVEL4,  // 水
	0x708A, KANJI_LEVEL4,  // 炊
	0x7761, KANJI_LEVEL4,  // 睡
	0x7C8B, KANJI_LEVEL4,  // 粋
	0x7FE0, KANJI_LEVEL4,  // 翠
	0x8870, KANJI_LEVEL4,  // 衰
	0x9042, KANJI_LEVEL4,  // 遂
	0x9154, KANJI_LEVEL4,  // 酔
	0x9310, KANJI_LEVEL4,  // 錐
	0x9318, KANJI_LEVEL4,  // 錘
	0x968F, KANJI_LEVEL4,  // 随
	0x745E, KANJI_LEVEL4,  // 瑞
	0x9AC4, KANJI_LEVEL4,  // 髄
	0x5D07, KANJI_LEVEL4,  // 崇
	0x5D69, KANJI_LEVEL4,  // 嵩
	0x6570, KANJI_LEVEL4,  // 数
	0x67A2, KANJI_LEVEL4,  // 枢
	0x8DA8, KANJI_LEVEL4,  // 趨
	0x96DB, KANJI_LEVEL4,  // 雛
	0x636E, KANJI_LEVEL4,  // 据
	0x6749, KANJI_LEVEL4,  // 杉
	0x6919, KANJI_LEVEL4,  // 椙
	0x83C5, KANJI_LEVEL4,  // 菅
	0x9817, KANJI_LEVEL4,  // 頗
	0x96C0, KANJI_LEVEL4,  // 雀
	0x88FE, KANJI_LEVEL4,  // 裾
	0x6F84, KANJI_LEVEL4,  // 澄
	0x647A, KANJI_LEVEL4,  // 摺
	0x5BF8, KANJI_LEVEL4,  // 寸
	0x4E16, KANJI_LEVEL4,  // 世
	0x702C, KANJI_LEVEL4,  // 瀬
	0x755D, KANJI_LEVEL4,  // 畝
	0x662F, KANJI_LEVEL4,  // 是
	0x51C4, KANJI_LEVEL4,  // 凄
	0x5236, KANJI_LEVEL4,  // 制
	0x52E2, KANJI_LEVEL4,  // 勢
	0x59D3, KANJI_LEVEL4,  // 姓
	0x5F81, KANJI_LEVEL4,  // 征
	0x6027, KANJI_LEVEL4,  // 性
	0x6210, KANJI_LEVEL4,  // 成
	0x653F, KANJI_LEVEL4,  // 政
	0x6574, KANJI_LEVEL4,  // 整
	0x661F, KANJI_LEVEL4,  // 星
	0x6674, KANJI_LEVEL4,  // 晴
	0x68F2, KANJI_LEVEL4,  // 棲
	0x6816, KANJI_LEVEL4,  // 栖
	0x6B63, KANJI_LEVEL4,  // 正
	0x6E05, KANJI_LEVEL4,  // 清
	0x7272, KANJI_LEVEL4,  // 牲
	0x751F, KANJI_LEVEL4,  // 生
	0x76DB, KANJI_LEVEL4,  // 盛
	0x7CBE, KANJI_LEVEL4,  // 精
	0x8056, KANJI_LEVEL4,  // 聖
	0x58F0, KANJI_LEVEL4,  // 声
	0x88FD, KANJI_LEVEL4,  // 製
	0x897F, KANJI_LEVEL4,  // 西
	0x8AA0, KANJI_LEVEL4,  // 誠
	0x8A93, KANJI_LEVEL4,  // 誓
	0x8ACB, KANJI_LEVEL4,  // 請
	0x901D, KANJI_LEVEL4,  // 逝
	0x9192, KANJI_LEVEL4,  // 醒
	0x9752, KANJI_LEVEL4,  // 青
	0x9759, KANJI_LEVEL4,  // 静
	0x6589, KANJI_LEVEL4,  // 斉
	0x7A0E, KANJI_LEVEL4,  // 税
	0x8106, KANJI_LEVEL4,  // 脆
	0x96BB, KANJI_LEVEL4,  // 隻
	0x5E2D, KANJI_LEVEL4,  // 席
	0x60DC, KANJI_LEVEL4,  // 惜
	0x621A, KANJI_LEVEL4,  // 戚
	0x65A5, KANJI_LEVEL4,  // 斥
	0x6614, KANJI_LEVEL4,  // 昔
	0x6790, KANJI_LEVEL4,  // 析
	0x77F3, KANJI_LEVEL4,  // 石
	0x7A4D, KANJI_LEVEL4,  // 積
	0x7C4D, KANJI_LEVEL4,  // 籍
	0x7E3E, KANJI_LEVEL4,  // 績
	0x810A, KANJI_LEVEL4,  // 脊
	0x8CAC, KANJI_LEVEL4,  // 責
	0x8D64, KANJI_LEVEL4,  // 赤
	0x8DE1, KANJI_LEVEL4,  // 跡
	0x8E5F, KANJI_LEVEL4,  // 蹟
	0x78A9, KANJI_LEVEL4,  // 碩
	0x5207, KANJI_LEVEL4,  // 切
	0x62D9, KANJI_LEVEL4,  // 拙
	0x63A5, KANJI_LEVEL4,  // 接
	0x6442, KANJI_LEVEL4,  // 摂
	0x6298, KANJI_LEVEL4,  // 折
	0x8A2D, KANJI_LEVEL4,  // 設
	0x7A83, KANJI_LEVEL4,  // 窃
	0x7BC0, KANJI_LEVEL4,  // 節
	0x8AAC, KANJI_LEVEL4,  // 説
	0x96EA, KANJI_LEVEL4,  // 雪
	0x7D76, KANJI_LEVEL4,  // 絶
	0x820C, KANJI_LEVEL4,  // 舌
	0x8749, KANJI_LEVEL4,  // 蝉
	0x4ED9, KANJI_LEVEL4,  // 仙
	0x5148, KANJI_LEVEL4,  // 先
	0x5343, KANJI_LEVEL4,  // 千
	0x5360, KANJI_LEVEL4,  // 占
	0x5BA3, KANJI_LEVEL4,  // 宣
	0x5C02, KANJI_LEVEL4,  // 専
	0x5C16, KANJI_LEVEL4,  // 尖
	0x5DDD, KANJI_LEVEL4,  // 川
	0x6226, KANJI_LEVEL4,  // 戦
	0x6247, KANJI_LEVEL4,  // 扇
	0x64B0, KANJI_LEVEL4,  // 撰
	0x6813, KANJI_LEVEL4,  // 栓
	0x6834, KANJI_LEVEL4,  // 栴
	0x6CC9, KANJI_LEVEL4,  // 泉
	0x6D45, KANJI_LEVEL4,  // 浅
	0x6D17, KANJI_LEVEL4,  // 洗
	0x67D3, KANJI_LEVEL4,  // 染
	0x6F5C, KANJI_LEVEL4,  // 潜
	0x714E, KANJI_LEVEL4,  // 煎
	0x717D, KANJI_LEVEL4,  // 煽
	0x65CB, KANJI_LEVEL4,  // 旋
	0x7A7F, KANJI_LEVEL4,  // 穿
	0x7BAD, KANJI_LEVEL4,  // 箭
	0x7DDA, KANJI_LEVEL4,  // 線
	0x7E4A, KANJI_LEVEL4,  // 繊
	0x7FA8, KANJI_LEVEL4,  // 羨
	0x817A, KANJI_LEVEL4,  // 腺
	0x821B, KANJI_LEVEL4,  // 舛
	0x8239, KANJI_LEVEL4,  // 船
	0x85A6, KANJI_LEVEL4,  // 薦
	0x8A6E, KANJI_LEVEL4,  // 詮
	0x8CCE, KANJI_LEVEL4,  // 賎
	0x8DF5, KANJI_LEVEL4,  // 践
	0x9078, KANJI_LEVEL4,  // 選
	0x9077, KANJI_LEVEL4,  // 遷
	0x92AD, KANJI_LEVEL4,  // 銭
	0x9291, KANJI_LEVEL4,  // 銑
	0x9583, KANJI_LEVEL4,  // 閃
	0x9BAE, KANJI_LEVEL4,  // 鮮
	0x524D, KANJI_LEVEL4,  // 前
	0x5584, KANJI_LEVEL4,  // 善
	0x6F38, KANJI_LEVEL4,  // 漸
	0x7136, KANJI_LEVEL4,  // 然
	0x5168, KANJI_LEVEL4,  // 全
	0x7985, KANJI_LEVEL4,  // 禅
	0x7E55, KANJI_LEVEL4,  // 繕
	0x81B3, KANJI_LEVEL4,  // 膳
	0x7CCE, KANJI_LEVEL4,  // 糎
	0x564C, KANJI_LEVEL4,  // 噌
	0x5851, KANJI_LEVEL4,  // 塑
	0x5CA8, KANJI_LEVEL4,  // 岨
	0x63AA, KANJI_LEVEL4,  // 措
	0x66FE, KANJI_LEVEL4,  // 曾
	0x66FD, KANJI_LEVEL4,  // 曽
	0x695A, KANJI_LEVEL4,  // 楚
	0x72D9, KANJI_LEVEL4,  // 狙
	0x758F, KANJI_LEVEL4,  // 疏
	0x758E, KANJI_LEVEL4,  // 疎
	0x790E, KANJI_LEVEL4,  // 礎
	0x7956, KANJI_LEVEL4,  // 祖
	0x79DF, KANJI_LEVEL4,  // 租
	0x7C97, KANJI_LEVEL4,  // 粗
	0x7D20, KANJI_LEVEL4,  // 素
	0x7D44, KANJI_LEVEL4,  // 組
	0x8607, KANJI_LEVEL4,  // 蘇
	0x8A34, KANJI_LEVEL4,  // 訴
	0x963B, KANJI_LEVEL4,  // 阻
	0x9061, KANJI_LEVEL4,  // 遡
	0x9F20, KANJI_LEVEL4,  // 鼠
	0x50E7, KANJI_LEVEL4,  // 僧
	0x5275, KANJI_LEVEL4,  // 創
	0x53CC, KANJI_LEVEL4,  // 双
	0x53E2, KANJI_LEVEL4,  // 叢
	0x5009, KANJI_LEVEL4,  // 倉
	0x55AA, KANJI_LEVEL4,  // 喪
	0x58EE, KANJI_LEVEL4,  // 壮
	0x594F, KANJI_LEVEL4,  // 奏
	0x723D, KANJI_LEVEL4,  // 爽
	0x5B8B, KANJI_LEVEL4,  // 宋
	0x5C64, KANJI_LEVEL4,  // 層
	0x531D, KANJI_LEVEL4,  // 匝
	0x60E3, KANJI_LEVEL4,  // 惣
	0x60F3, KANJI_LEVEL4,  // 想
	0x635C, KANJI_LEVEL4,  // 捜
	0x6383, KANJI_LEVEL4,  // 掃
	0x633F, KANJI_LEVEL4,  // 挿
	0x63BB, KANJI_LEVEL4,  // 掻
	0x64CD, KANJI_LEVEL4,  // 操
	0x65E9, KANJI_LEVEL4,  // 早
	0x66F9, KANJI_LEVEL4,  // 曹
	0x5DE3, KANJI_LEVEL4,  // 巣
	0x69CD, KANJI_LEVEL4,  // 槍
	0x69FD, KANJI_LEVEL4,  // 槽
	0x6F15, KANJI_LEVEL4,  // 漕
	0x71E5, KANJI_LEVEL4,  // 燥
	0x4E89, KANJI_LEVEL4,  // 争
	0x75E9, KANJI_LEVEL4,  // 痩
	0x76F8, KANJI_LEVEL4,  // 相
	0x7A93, KANJI_LEVEL4,  // 窓
	0x7CDF, KANJI_LEVEL4,  // 糟
	0x7DCF, KANJI_LEVEL4,  // 総
	0x7D9C, KANJI_LEVEL4,  // 綜
	0x8061, KANJI_LEVEL4,  // 聡
	0x8349, KANJI_LEVEL4,  // 草
	0x8358, KANJI_LEVEL4,  // 荘
	0x846C, KANJI_LEVEL4,  // 葬
	0x84BC, KANJI_LEVEL4,  // 蒼
	0x85FB, KANJI_LEVEL4,  // 藻
	0x88C5, KANJI_LEVEL4,  // 装
	0x8D70, KANJI_LEVEL4,  // 走
	0x9001, KANJI_LEVEL4,  // 送
	0x906D, KANJI_LEVEL4,  // 遭
	0x9397, KANJI_LEVEL4,  // 鎗
	0x971C, KANJI_LEVEL4,  // 霜
	0x9A12, KANJI_LEVEL4,  // 騒
	0x50CF, KANJI_LEVEL4,  // 像
	0x5897, KANJI_LEVEL4,  // 増
	0x618E, KANJI_LEVEL4,  // 憎
	0x81D3, KANJI_LEVEL4,  // 臓
	0x8535, KANJI_LEVEL4,  // 蔵
	0x8D08, KANJI_LEVEL4,  // 贈
	0x9020, KANJI_LEVEL4,  // 造
	0x4FC3, KANJI_LEVEL4,  // 促
	0x5074, KANJI_LEVEL4,  // 側
	0x5247, KANJI_LEVEL4,  // 則
	0x5373, KANJI_LEVEL4,  // 即
	0x606F, KANJI_LEVEL4,  // 息
	0x6349, KANJI_LEVEL4,  // 捉
	0x675F, KANJI_LEVEL4,  // 束
	0x6E2C, KANJI_LEVEL4,  // 測
	0x8DB3, KANJI_LEVEL4,  // 足
	0x901F, KANJI_LEVEL4,  // 速
	0x4FD7, KANJI_LEVEL4,  // 俗
	0x5C5E, KANJI_LEVEL4,  // 属
	0x8CCA, KANJI_LEVEL4,  // 賊
	0x65CF, KANJI_LEVEL4,  // 族
	0x7D9A, KANJI_LEVEL4,  // 続
	0x5352, KANJI_LEVEL4,  // 卒
	0x8896, KANJI_LEVEL4,  // 袖
	0x5176, KANJI_LEVEL4,  // 其
	0x63C3, KANJI_LEVEL4,  // 揃
	0x5B58, KANJI_LEVEL4,  // 存
	0x5B6B, KANJI_LEVEL4,  // 孫
	0x5C0A, KANJI_LEVEL4,  // 尊
	0x640D, KANJI_LEVEL4,  // 損
	0x6751, KANJI_LEVEL4,  // 村
	0x905C, KANJI_LEVEL4,  // 遜
	0x4ED6, KANJI_LEVEL4,  // 他
	0x591A, KANJI_LEVEL4,  // 多
	0x592A, KANJI_LEVEL4,  // 太
	0x6C70, KANJI_LEVEL4,  // 汰
	0x8A51, KANJI_LEVEL4,  // 詑
	0x553E, KANJI_LEVEL4,  // 唾
	0x5815, KANJI_LEVEL4,  // 堕
	0x59A5, KANJI_LEVEL4,  // 妥
	0x60F0, KANJI_LEVEL4,  // 惰
	0x6253, KANJI_LEVEL4,  // 打
	0x67C1, KANJI_LEVEL4,  // 柁
	0x8235, KANJI_LEVEL4,  // 舵
	0x6955, KANJI_LEVEL4,  // 楕
	0x9640, KANJI_LEVEL4,  // 陀
	0x99C4, KANJI_LEVEL4,  // 駄
	0x9A28, KANJI_LEVEL4,  // 騨
	0x4F53, KANJI_LEVEL4,  // 体
	0x5806, KANJI_LEVEL4,  // 堆
	0x5BFE, KANJI_LEVEL4,  // 対
	0x8010, KANJI_LEVEL4,  // 耐
	0x5CB1, KANJI_LEVEL4,  // 岱
	0x5E2F, KANJI_LEVEL4,  // 帯
	0x5F85, KANJI_LEVEL4,  // 待
	0x6020, KANJI_LEVEL4,  // 怠
	0x614B, KANJI_LEVEL4,  // 態
	0x6234, KANJI_LEVEL4,  // 戴
	0x66FF, KANJI_LEVEL4,  // 替
	0x6CF0, KANJI_LEVEL4,  // 泰
	0x6EDE, KANJI_LEVEL4,  // 滞
	0x80CE, KANJI_LEVEL4,  // 胎
	0x817F, KANJI_LEVEL4,  // 腿
	0x82D4, KANJI_LEVEL4,  // 苔
	0x888B, KANJI_LEVEL4,  // 袋
	0x8CB8, KANJI_LEVEL4,  // 貸
	0x9000, KANJI_LEVEL4,  // 退
	0x902E, KANJI_LEVEL4,  // 逮
	0x968A, KANJI_LEVEL4,  // 隊
	0x9EDB, KANJI_LEVEL4,  // 黛
	0x9BDB, KANJI_LEVEL4,  // 鯛
	0x4EE3, KANJI_LEVEL4,  // 代
	0x53F0, KANJI_LEVEL4,  // 台
	0x5927, KANJI_LEVEL4,  // 大
	0x7B2C, KANJI_LEVEL4,  // 第
	0x918D, KANJI_LEVEL4,  // 醍
	0x984C, KANJI_LEVEL4,  // 題
	0x9DF9, KANJI_LEVEL4,  // 鷹
	0x6EDD, KANJI_LEVEL4,  // 滝
	0x7027, KANJI_LEVEL4,  // 瀧
	0x5353, KANJI_LEVEL4,  // 卓
	0x5544, KANJI_LEVEL4,  // 啄
	0x5B85, KANJI_LEVEL4,  // 宅
	0x6258, KANJI_LEVEL4,  // 托
	0x629E, KANJI_LEVEL4,  // 択
	0x62D3, KANJI_LEVEL4,  // 拓
	0x6CA2, KANJI_LEVEL4,  // 沢
	0x6FEF, KANJI_LEVEL4,  // 濯
	0x7422, KANJI_LEVEL4,  // 琢
	0x8A17, KANJI_LEVEL4,  // 託
	0x9438, KANJI_LEVEL4,  // 鐸
	0x6FC1, KANJI_LEVEL4,  // 濁
	0x8AFE, KANJI_LEVEL4,  // 諾
	0x8338, KANJI_LEVEL4,  // 茸
	0x51E7, KANJI_LEVEL4,  // 凧
	0x86F8, KANJI_LEVEL4,  // 蛸
	0x53EA, KANJI_LEVEL4,  // 只
	0x53E9, KANJI_LEVEL4,  // 叩
	0x4F46, KANJI_LEVEL4,  // 但
	0x9054, KANJI_LEVEL4,  // 達
	0x8FB0, KANJI_LEVEL4,  // 辰
	0x596A, KANJI_LEVEL4,  // 奪
	0x8131, KANJI_LEVEL4,  // 脱
	0x5DFD, KANJI_LEVEL4,  // 巽
	0x7AEA, KANJI_LEVEL4,  // 竪
	0x8FBF, KANJI_LEVEL4,  // 辿
	0x68DA, KANJI_LEVEL4,  // 棚
	0x8C37, KANJI_LEVEL4,  // 谷
	0x72F8, KANJI_LEVEL4,  // 狸
	0x9C48, KANJI_LEVEL4,  // 鱈
	0x6A3D, KANJI_LEVEL4,  // 樽
	0x8AB0, KANJI_LEVEL4,  // 誰
	0x4E39, KANJI_LEVEL4,  // 丹
	0x5358, KANJI_LEVEL4,  // 単
	0x5606, KANJI_LEVEL4,  // 嘆
	0x5766, KANJI_LEVEL4,  // 坦
	0x62C5, KANJI_LEVEL4,  // 担
	0x63A2, KANJI_LEVEL4,  // 探
	0x65E6, KANJI_LEVEL4,  // 旦
	0x6B4E, KANJI_LEVEL4,  // 歎
	0x6DE1, KANJI_LEVEL4,  // 淡
	0x6E5B, KANJI_LEVEL4,  // 湛
	0x70AD, KANJI_LEVEL4,  // 炭
	0x77ED, KANJI_LEVEL4,  // 短
	0x7AEF, KANJI_LEVEL4,  // 端
	0x7BAA, KANJI_LEVEL4,  // 箪
	0x7DBB, KANJI_LEVEL4,  // 綻
	0x803D, KANJI_LEVEL4,  // 耽
	0x80C6, KANJI_LEVEL4,  // 胆
	0x86CB, KANJI_LEVEL4,  // 蛋
	0x8A95, KANJI_LEVEL4,  // 誕
	0x935B, KANJI_LEVEL4,  // 鍛
	0x56E3, KANJI_LEVEL4,  // 団
	0x58C7, KANJI_LEVEL4,  // 壇
	0x5F3E, KANJI_LEVEL4,  // 弾
	0x65AD, KANJI_LEVEL4,  // 断
	0x6696, KANJI_LEVEL4,  // 暖
	0x6A80, KANJI_LEVEL4,  // 檀
	0x6BB5, KANJI_LEVEL4,  // 段
	0x7537, KANJI_LEVEL4,  // 男
	0x8AC7, KANJI_LEVEL4,  // 談
	0x5024, KANJI_LEVEL4,  // 値
	0x77E5, KANJI_LEVEL4,  // 知
	0x5730, KANJI_LEVEL4,  // 地
	0x5F1B, KANJI_LEVEL4,  // 弛
	0x6065, KANJI_LEVEL4,  // 恥
	0x667A, KANJI_LEVEL4,  // 智
	0x6C60, KANJI_LEVEL4,  // 池
	0x75F4, KANJI_LEVEL4,  // 痴
	0x7A1A, KANJI_LEVEL4,  // 稚
	0x7F6E, KANJI_LEVEL4,  // 置
	0x81F4, KANJI_LEVEL4,  // 致
	0x8718, KANJI_LEVEL4,  // 蜘
	0x9045, KANJI_LEVEL4,  // 遅
	0x99B3, KANJI_LEVEL4,  // 馳
	0x7BC9, KANJI_LEVEL4,  // 築
	0x755C, KANJI_LEVEL4,  // 畜
	0x7AF9, KANJI_LEVEL4,  // 竹
	0x7B51, KANJI_LEVEL4,  // 筑
	0x84C4, KANJI_LEVEL4,  // 蓄
	0x9010, KANJI_LEVEL4,  // 逐
	0x79E9, KANJI_LEVEL4,  // 秩
	0x7A92, KANJI_LEVEL4,  // 窒
	0x8336, KANJI_LEVEL4,  // 茶
	0x5AE1, KANJI_LEVEL4,  // 嫡
	0x7740, KANJI_LEVEL4,  // 着
	0x4E2D, KANJI_LEVEL4,  // 中
	0x4EF2, KANJI_LEVEL4,  // 仲
	0x5B99, KANJI_LEVEL4,  // 宙
	0x5FE0, KANJI_LEVEL4,  // 忠
	0x62BD, KANJI_LEVEL4,  // 抽
	0x663C, KANJI_LEVEL4,  // 昼
	0x67F1, KANJI_LEVEL4,  // 柱
	0x6CE8, KANJI_LEVEL4,  // 注
	0x866B, KANJI_LEVEL4,  // 虫
	0x8877, KANJI_LEVEL4,  // 衷
	0x8A3B, KANJI_LEVEL4,  // 註
	0x914E, KANJI_LEVEL4,  // 酎
	0x92F3, KANJI_LEVEL4,  // 鋳
	0x99D0, KANJI_LEVEL4,  // 駐
	0x6A17, KANJI_LEVEL4,  // 樗
	0x7026, KANJI_LEVEL4,  // 瀦
	0x732A, KANJI_LEVEL4,  // 猪
	0x82E7, KANJI_LEVEL4,  // 苧
	0x8457, KANJI_LEVEL4,  // 著
	0x8CAF, KANJI_LEVEL4,  // 貯
	0x4E01, KANJI_LEVEL4,  // 丁
	0x5146, KANJI_LEVEL4,  // 兆
	0x51CB, KANJI_LEVEL4,  // 凋
	0x558B, KANJI_LEVEL4,  // 喋
	0x5BF5, KANJI_LEVEL4,  // 寵
	0x5E16, KANJI_LEVEL4,  // 帖
	0x5E33, KANJI_LEVEL4,  // 帳
	0x5E81, KANJI_LEVEL4,  // 庁
	0x5F14, KANJI_LEVEL4,  // 弔
	0x5F35, KANJI_LEVEL4,  // 張
	0x5F6B, KANJI_LEVEL4,  // 彫
	0x5FB4, KANJI_LEVEL4,  // 徴
	0x61F2, KANJI_LEVEL4,  // 懲
	0x6311, KANJI_LEVEL4,  // 挑
	0x66A2, KANJI_LEVEL4,  // 暢
	0x671D, KANJI_LEVEL4,  // 朝
	0x6F6E, KANJI_LEVEL4,  // 潮
	0x7252, KANJI_LEVEL4,  // 牒
	0x753A, KANJI_LEVEL4,  // 町
	0x773A, KANJI_LEVEL4,  // 眺
	0x8074, KANJI_LEVEL4,  // 聴
	0x8139, KANJI_LEVEL4,  // 脹
	0x8178, KANJI_LEVEL4,  // 腸
	0x8776, KANJI_LEVEL4,  // 蝶
	0x8ABF, KANJI_LEVEL4,  // 調
	0x8ADC, KANJI_LEVEL4,  // 諜
	0x8D85, KANJI_LEVEL4,  // 超
	0x8DF3, KANJI_LEVEL4,  // 跳
	0x929A, KANJI_LEVEL4,  // 銚
	0x9577, KANJI_LEVEL4,  // 長
	0x9802, KANJI_LEVEL4,  // 頂
	0x9CE5, KANJI_LEVEL4,  // 鳥
	0x52C5, KANJI_LEVEL4,  // 勅
	0x6357, KANJI_LEVEL4,  // 捗
	0x76F4, KANJI_LEVEL4,  // 直
	0x6715, KANJI_LEVEL4,  // 朕
	0x6C88, KANJI_LEVEL4,  // 沈
	0x73CD, KANJI_LEVEL4,  // 珍
	0x8CC3, KANJI_LEVEL4,  // 賃
	0x93AE, KANJI_LEVEL4,  // 鎮
	0x9673, KANJI_LEVEL4,  // 陳
	0x6D25, KANJI_LEVEL4,  // 津
	0x589C, KANJI_LEVEL4,  // 墜
	0x690E, KANJI_LEVEL4,  // 椎
	0x69CC, KANJI_LEVEL4,  // 槌
	0x8FFD, KANJI_LEVEL4,  // 追
	0x939A, KANJI_LEVEL4,  // 鎚
	0x75DB, KANJI_LEVEL4,  // 痛
	0x901A, KANJI_LEVEL4,  // 通
	0x585A, KANJI_LEVEL4,  // 塚
	0x6802, KANJI_LEVEL4,  // 栂
	0x63B4, KANJI_LEVEL4,  // 掴
	0x69FB, KANJI_LEVEL4,  // 槻
	0x4F43, KANJI_LEVEL4,  // 佃
	0x6F2C, KANJI_LEVEL4,  // 漬
	0x67D8, KANJI_LEVEL4,  // 柘
	0x8FBB, KANJI_LEVEL4,  // 辻
	0x8526, KANJI_LEVEL4,  // 蔦
	0x7DB4, KANJI_LEVEL4,  // 綴
	0x9354, KANJI_LEVEL4,  // 鍔
	0x693F, KANJI_LEVEL4,  // 椿
	0x6F70, KANJI_LEVEL4,  // 潰
	0x576A, KANJI_LEVEL4,  // 坪
	0x58F7, KANJI_LEVEL4,  // 壷
	0x5B2C, KANJI_LEVEL4,  // 嬬
	0x7D2C, KANJI_LEVEL4,  // 紬
	0x722A, KANJI_LEVEL4,  // 爪
	0x540A, KANJI_LEVEL4,  // 吊
	0x91E3, KANJI_LEVEL4,  // 釣
	0x9DB4, KANJI_LEVEL4,  // 鶴
	0x4EAD, KANJI_LEVEL4,  // 亭
	0x4F4E, KANJI_LEVEL4,  // 低
	0x505C, KANJI_LEVEL4,  // 停
	0x5075, KANJI_LEVEL4,  // 偵
	0x5243, KANJI_LEVEL4,  // 剃
	0x8C9E, KANJI_LEVEL4,  // 貞
	0x5448, KANJI_LEVEL4,  // 呈
	0x5824, KANJI_LEVEL4,  // 堤
	0x5B9A, KANJI_LEVEL4,  // 定
	0x5E1D, KANJI_LEVEL4,  // 帝
	0x5E95, KANJI_LEVEL4,  // 底
	0x5EAD, KANJI_LEVEL4,  // 庭
	0x5EF7, KANJI_LEVEL4,  // 廷
	0x5F1F, KANJI_LEVEL4,  // 弟
	0x608C, KANJI_LEVEL4,  // 悌
	0x62B5, KANJI_LEVEL4,  // 抵
	0x633A, KANJI_LEVEL4,  // 挺
	0x63D0, KANJI_LEVEL4,  // 提
	0x68AF, KANJI_LEVEL4,  // 梯
	0x6C40, KANJI_LEVEL4,  // 汀
	0x7887, KANJI_LEVEL4,  // 碇
	0x798E, KANJI_LEVEL4,  // 禎
	0x7A0B, KANJI_LEVEL4,  // 程
	0x7DE0, KANJI_LEVEL4,  // 締
	0x8247, KANJI_LEVEL4,  // 艇
	0x8A02, KANJI_LEVEL4,  // 訂
	0x8AE6, KANJI_LEVEL4,  // 諦
	0x8E44, KANJI_LEVEL4,  // 蹄
	0x9013, KANJI_LEVEL4,  // 逓
	0x90B8, KANJI_LEVEL4,  // 邸
	0x912D, KANJI_LEVEL4,  // 鄭
	0x91D8, KANJI_LEVEL4,  // 釘
	0x9F0E, KANJI_LEVEL4,  // 鼎
	0x6CE5, KANJI_LEVEL4,  // 泥
	0x6458, KANJI_LEVEL4,  // 摘
	0x64E2, KANJI_LEVEL4,  // 擢
	0x6575, KANJI_LEVEL4,  // 敵
	0x6EF4, KANJI_LEVEL4,  // 滴
	0x7684, KANJI_LEVEL4,  // 的
	0x7B1B, KANJI_LEVEL4,  // 笛
	0x9069, KANJI_LEVEL4,  // 適
	0x93D1, KANJI_LEVEL4,  // 鏑
	0x6EBA, KANJI_LEVEL4,  // 溺
	0x54F2, KANJI_LEVEL4,  // 哲
	0x5FB9, KANJI_LEVEL4,  // 徹
	0x64A4, KANJI_LEVEL4,  // 撤
	0x8F4D, KANJI_LEVEL4,  // 轍
	0x8FED, KANJI_LEVEL4,  // 迭
	0x9244, KANJI_LEVEL4,  // 鉄
	0x5178, KANJI_LEVEL4,  // 典
	0x586B, KANJI_LEVEL4,  // 填
	0x5929, KANJI_LEVEL4,  // 天
	0x5C55, KANJI_LEVEL4,  // 展
	0x5E97, KANJI_LEVEL4,  // 店
	0x6DFB, KANJI_LEVEL4,  // 添
	0x7E8F, KANJI_LEVEL4,  // 纏
	0x751C, KANJI_LEVEL4,  // 甜
	0x8CBC, KANJI_LEVEL4,  // 貼
	0x8EE2, KANJI_LEVEL4,  // 転
	0x985B, KANJI_LEVEL4,  // 顛
	0x70B9, KANJI_LEVEL4,  // 点
	0x4F1D, KANJI_LEVEL4,  // 伝
	0x6BBF, KANJI_LEVEL4,  // 殿
	0x6FB1, KANJI_LEVEL4,  // 澱
	0x7530, KANJI_LEVEL4,  // 田
	0x96FB, KANJI_LEVEL4,  // 電
	0x514E, KANJI_LEVEL4,  // 兎
	0x5410, KANJI_LEVEL4,  // 吐
	0x5835, KANJI_LEVEL4,  // 堵
	0x5857, KANJI_LEVEL4,  // 塗
	0x59AC, KANJI_LEVEL4,  // 妬
	0x5C60, KANJI_LEVEL4,  // 屠
	0x5F92, KANJI_LEVEL4,  // 徒
	0x6597, KANJI_LEVEL4,  // 斗
	0x675C, KANJI_LEVEL4,  // 杜
	0x6E21, KANJI_LEVEL4,  // 渡
	0x767B, KANJI_LEVEL4,  // 登
	0x83DF, KANJI_LEVEL4,  // 菟
	0x8CED, KANJI_LEVEL4,  // 賭
	0x9014, KANJI_LEVEL4,  // 途
	0x90FD, KANJI_LEVEL4,  // 都
	0x934D, KANJI_LEVEL4,  // 鍍
	0x7825, KANJI_LEVEL4,  // 砥
	0x783A, KANJI_LEVEL4,  // 砺
	0x52AA, KANJI_LEVEL4,  // 努
	0x5EA6, KANJI_LEVEL4,  // 度
	0x571F, KANJI_LEVEL4,  // 土
	0x5974, KANJI_LEVEL4,  // 奴
	0x6012, KANJI_LEVEL4,  // 怒
	0x5012, KANJI_LEVEL4,  // 倒
	0x515A, KANJI_LEVEL4,  // 党
	0x51AC, KANJI_LEVEL4,  // 冬
	0x51CD, KANJI_LEVEL4,  // 凍
	0x5200, KANJI_LEVEL4,  // 刀
	0x5510, KANJI_LEVEL4,  // 唐
	0x5854, KANJI_LEVEL4,  // 塔
	0x5858, KANJI_LEVEL4,  // 塘
	0x5957, KANJI_LEVEL4,  // 套
	0x5B95, KANJI_LEVEL4,  // 宕
	0x5CF6, KANJI_LEVEL4,  // 島
	0x5D8B, KANJI_LEVEL4,  // 嶋
	0x60BC, KANJI_LEVEL4,  // 悼
	0x6295, KANJI_LEVEL4,  // 投
	0x642D, KANJI_LEVEL4,  // 搭
	0x6771, KANJI_LEVEL4,  // 東
	0x6843, KANJI_LEVEL4,  // 桃
	0x68BC, KANJI_LEVEL4,  // 梼
	0x68DF, KANJI_LEVEL4,  // 棟
	0x76D7, KANJI_LEVEL4,  // 盗
	0x6DD8, KANJI_LEVEL4,  // 淘
	0x6E6F, KANJI_LEVEL4,  // 湯
	0x6D9B, KANJI_LEVEL4,  // 涛
	0x706F, KANJI_LEVEL4,  // 灯
	0x71C8, KANJI_LEVEL4,  // 燈
	0x5F53, KANJI_LEVEL4,  // 当
	0x75D8, KANJI_LEVEL4,  // 痘
	0x7977, KANJI_LEVEL4,  // 祷
	0x7B49, KANJI_LEVEL4,  // 等
	0x7B54, KANJI_LEVEL4,  // 答
	0x7B52, KANJI_LEVEL4,  // 筒
	0x7CD6, KANJI_LEVEL4,  // 糖
	0x7D71, KANJI_LEVEL4,  // 統
	0x5230, KANJI_LEVEL4,  // 到
	0x8463, KANJI_LEVEL4,  // 董
	0x8569, KANJI_LEVEL4,  // 蕩
	0x85E4, KANJI_LEVEL4,  // 藤
	0x8A0E, KANJI_LEVEL4,  // 討
	0x8B04, KANJI_LEVEL4,  // 謄
	0x8C46, KANJI_LEVEL4,  // 豆
	0x8E0F, KANJI_LEVEL4,  // 踏
	0x9003, KANJI_LEVEL4,  // 逃
	0x900F, KANJI_LEVEL4,  // 透
	0x9419, KANJI_LEVEL4,  // 鐙
	0x9676, KANJI_LEVEL4,  // 陶
	0x982D, KANJI_LEVEL4,  // 頭
	0x9A30, KANJI_LEVEL4,  // 騰
	0x95D8, KANJI_LEVEL4,  // 闘
	0x50CD, KANJI_LEVEL4,  // 働
	0x52D5, KANJI_LEVEL4,  // 動
	0x540C, KANJI_LEVEL4,  // 同
	0x5802, KANJI_LEVEL4,  // 堂
	0x5C0E, KANJI_LEVEL4,  // 導
	0x61A7, KANJI_LEVEL4,  // 憧
	0x649E, KANJI_LEVEL4,  // 撞
	0x6D1E, KANJI_LEVEL4,  // 洞
	0x77B3, KANJI_LEVEL4,  // 瞳
	0x7AE5, KANJI_LEVEL4,  // 童
	0x80F4, KANJI_LEVEL4,  // 胴
	0x8404, KANJI_LEVEL4,  // 萄
	0x9053, KANJI_LEVEL4,  // 道
	0x9285, KANJI_LEVEL4,  // 銅
	0x5CE0, KANJI_LEVEL4,  // 峠
	0x9D07, KANJI_LEVEL4,  // 鴇
	0x533F, KANJI_LEVEL4,  // 匿
	0x5F97, KANJI_LEVEL4,  // 得
	0x5FB3, KANJI_LEVEL4,  // 徳
	0x6D9C, KANJI_LEVEL4,  // 涜
	0x7279, KANJI_LEVEL4,  // 特
	0x7763, KANJI_LEVEL4,  // 督
	0x79BF, KANJI_LEVEL4,  // 禿
	0x7BE4, KANJI_LEVEL4,  // 篤
	0x6BD2, KANJI_LEVEL4,  // 毒
	0x72EC, KANJI_LEVEL4,  // 独
	0x8AAD, KANJI_LEVEL4,  // 読
	0x6803, KANJI_LEVEL4,  // 栃
	0x6A61, KANJI_LEVEL4,  // 橡
	0x51F8, KANJI_LEVEL4,  // 凸
	0x7A81, KANJI_LEVEL4,  // 突
	0x6934, KANJI_LEVEL4,  // 椴
	0x5C4A, KANJI_LEVEL4,  // 届
	0x9CF6, KANJI_LEVEL4,  // 鳶
	0x82EB, KANJI_LEVEL4,  // 苫
	0x5BC5, KANJI_LEVEL4,  // 寅
	0x9149, KANJI_LEVEL4,  // 酉
	0x701E, KANJI_LEVEL4,  // 瀞
	0x5678, KANJI_LEVEL4,  // 噸
	0x5C6F, KANJI_LEVEL4,  // 屯
	0x60C7, KANJI_LEVEL4,  // 惇
	0x6566, KANJI_LEVEL4,  // 敦
	0x6C8C, KANJI_LEVEL4,  // 沌
	0x8C5A, KANJI_LEVEL4,  // 豚
	0x9041, KANJI_LEVEL4,  // 遁
	0x9813, KANJI_LEVEL4,  // 頓
	0x5451, KANJI_LEVEL4,  // 呑
	0x66C7, KANJI_LEVEL4,  // 曇
	0x920D, KANJI_LEVEL4,  // 鈍
	0x5948, KANJI_LEVEL4,  // 奈
	0x90A3, KANJI_LEVEL4,  // 那
	0x5185, KANJI_LEVEL4,  // 内
	0x4E4D, KANJI_LEVEL4,  // 乍
	0x51EA, KANJI_LEVEL4,  // 凪
	0x8599, KANJI_LEVEL4,  // 薙
	0x8B0E, KANJI_LEVEL4,  // 謎
	0x7058, KANJI_LEVEL4,  // 灘
	0x637A, KANJI_LEVEL4,  // 捺
	0x934B, KANJI_LEVEL4,  // 鍋
	0x6962, KANJI_LEVEL4,  // 楢
	0x99B4, KANJI_LEVEL4,  // 馴
	0x7E04, KANJI_LEVEL4,  // 縄
	0x7577, KANJI_LEVEL4,  // 畷
	0x5357, KANJI_LEVEL4,  // 南
	0x6960, KANJI_LEVEL4,  // 楠
	0x8EDF, KANJI_LEVEL4,  // 軟
	0x96E3, KANJI_LEVEL4,  // 難
	0x6C5D, KANJI_LEVEL4,  // 汝
	0x4E8C, KANJI_LEVEL4,  // 二
	0x5C3C, KANJI_LEVEL4,  // 尼
	0x5F10, KANJI_LEVEL4,  // 弐
	0x8FE9, KANJI_LEVEL4,  // 迩
	0x5302, KANJI_LEVEL4,  // 匂
	0x8CD1, KANJI_LEVEL4,  // 賑
	0x8089, KANJI_LEVEL4,  // 肉
	0x8679, KANJI_LEVEL4,  // 虹
	0x5EFF, KANJI_LEVEL4,  // 廿
	0x65E5, KANJI_LEVEL4,  // 日
	0x4E73, KANJI_LEVEL4,  // 乳
	0x5165, KANJI_LEVEL4,  // 入
	0x5982, KANJI_LEVEL4,  // 如
	0x5C3F, KANJI_LEVEL4,  // 尿
	0x97EE, KANJI_LEVEL4,  // 韮
	0x4EFB, KANJI_LEVEL4,  // 任
	0x598A, KANJI_LEVEL4,  // 妊
	0x5FCD, KANJI_LEVEL4,  // 忍
	0x8A8D, KANJI_LEVEL4,  // 認
	0x6FE1, KANJI_LEVEL4,  // 濡
	0x79B0, KANJI_LEVEL4,  // 禰
	0x7962, KANJI_LEVEL4,  // 祢
	0x5BE7, KANJI_LEVEL4,  // 寧
	0x8471, KANJI_LEVEL4,  // 葱
	0x732B, KANJI_LEVEL4,  // 猫
	0x71B1, KANJI_LEVEL4,  // 熱
	0x5E74, KANJI_LEVEL4,  // 年
	0x5FF5, KANJI_LEVEL4,  // 念
	0x637B, KANJI_LEVEL4,  // 捻
	0x649A, KANJI_LEVEL4,  // 撚
	0x71C3, KANJI_LEVEL4,  // 燃
	0x7C98, KANJI_LEVEL4,  // 粘
	0x4E43, KANJI_LEVEL4,  // 乃
	0x5EFC, KANJI_LEVEL4,  // 廼
	0x4E4B, KANJI_LEVEL4,  // 之
	0x57DC, KANJI_LEVEL4,  // 埜
	0x56A2, KANJI_LEVEL4,  // 嚢
	0x60A9, KANJI_LEVEL4,  // 悩
	0x6FC3, KANJI_LEVEL4,  // 濃
	0x7D0D, KANJI_LEVEL4,  // 納
	0x80FD, KANJI_LEVEL4,  // 能
	0x8133, KANJI_LEVEL4,  // 脳
	0x81BF, KANJI_LEVEL4,  // 膿
	0x8FB2, KANJI_LEVEL4,  // 農
	0x8997, KANJI_LEVEL4,  // 覗
	0x86A4, KANJI_LEVEL4,  // 蚤
	0x5DF4, KANJI_LEVEL4,  // 巴
	0x628A, KANJI_LEVEL4,  // 把
	0x64AD, KANJI_LEVEL4,  // 播
	0x8987, KANJI_LEVEL4,  // 覇
	0x6777, KANJI_LEVEL4,  // 杷
	0x6CE2, KANJI_LEVEL4,  // 波
	0x6D3E, KANJI_LEVEL4,  // 派
	0x7436, KANJI_LEVEL4,  // 琶
	0x7834, KANJI_LEVEL4,  // 破
	0x5A46, KANJI_LEVEL4,  // 婆
	0x7F75, KANJI_LEVEL4,  // 罵
	0x82AD, KANJI_LEVEL4,  // 芭
	0x99AC, KANJI_LEVEL4,  // 馬
	0x4FF3, KANJI_LEVEL4,  // 俳
	0x5EC3, KANJI_LEVEL4,  // 廃
	0x62DD, KANJI_LEVEL4,  // 拝
	0x6392, KANJI_LEVEL4,  // 排
	0x6557, KANJI_LEVEL4,  // 敗
	0x676F, KANJI_LEVEL4,  // 杯
	0x76C3, KANJI_LEVEL4,  // 盃
	0x724C, KANJI_LEVEL4,  // 牌
	0x80CC, KANJI_LEVEL4,  // 背
	0x80BA, KANJI_LEVEL4,  // 肺
	0x8F29, KANJI_LEVEL4,  // 輩
	0x914D, KANJI_LEVEL4,  // 配
	0x500D, KANJI_LEVEL4,  // 倍
	0x57F9, KANJI_LEVEL4,  // 培
	0x5A92, KANJI_LEVEL4,  // 媒
	0x6885, KANJI_LEVEL4,  // 梅
	0x6973, KANJI_LEVEL4,  // 楳
	0x7164, KANJI_LEVEL4,  // 煤
	0x72FD, KANJI_LEVEL4,  // 狽
	0x8CB7, KANJI_LEVEL4,  // 買
	0x58F2, KANJI_LEVEL4,  // 売
	0x8CE0, KANJI_LEVEL4,  // 賠
	0x966A, KANJI_LEVEL4,  // 陪
	0x9019, KANJI_LEVEL4,  // 這
	0x877F, KANJI_LEVEL4,  // 蝿
	0x79E4, KANJI_LEVEL4,  // 秤
	0x77E7, KANJI_LEVEL4,  // 矧
	0x8429, KANJI_LEVEL4,  // 萩
	0x4F2F, KANJI_LEVEL4,  // 伯
	0x5265, KANJI_LEVEL4,  // 剥
	0x535A, KANJI_LEVEL4,  // 博
	0x62CD, KANJI_LEVEL4,  // 拍
	0x67CF, KANJI_LEVEL4,  // 柏
	0x6CCA, KANJI_LEVEL4,  // 泊
	0x767D, KANJI_LEVEL4,  // 白
	0x7B94, KANJI_LEVEL4,  // 箔
	0x7C95, KANJI_LEVEL4,  // 粕
	0x8236, KANJI_LEVEL4,  // 舶
	0x8584, KANJI_LEVEL4,  // 薄
	0x8FEB, KANJI_LEVEL4,  // 迫
	0x66DD, KANJI_LEVEL4,  // 曝
	0x6F20, KANJI_LEVEL4,  // 漠
	0x7206, KANJI_LEVEL4,  // 爆
	0x7E1B, KANJI_LEVEL4,  // 縛
	0x83AB, KANJI_LEVEL4,  // 莫
	0x99C1, KANJI_LEVEL4,  // 駁
	0x9EA6, KANJI_LEVEL4,  // 麦
	0x51FD, KANJI_LEVEL4,  // 函
	0x7BB1, KANJI_LEVEL4,  // 箱
	0x7872, KANJI_LEVEL4,  // 硲
	0x7BB8, KANJI_LEVEL4,  // 箸
	0x8087, KANJI_LEVEL4,  // 肇
	0x7B48, KANJI_LEVEL4,  // 筈
	0x6AE8, KANJI_LEVEL4,  // 櫨
	0x5E61, KANJI_LEVEL4,  // 幡
	0x808C, KANJI_LEVEL4,  // 肌
	0x7551, KANJI_LEVEL4,  // 畑
	0x7560, KANJI_LEVEL4,  // 畠
	0x516B, KANJI_LEVEL4,  // 八
	0x9262, KANJI_LEVEL4,  // 鉢
	0x6E8C, KANJI_LEVEL4,  // 溌
	0x767A, KANJI_LEVEL4,  // 発
	0x9197, KANJI_LEVEL4,  // 醗
	0x9AEA, KANJI_LEVEL4,  // 髪
	0x4F10, KANJI_LEVEL4,  // 伐
	0x7F70, KANJI_LEVEL4,  // 罰
	0x629C, KANJI_LEVEL4,  // 抜
	0x7B4F, KANJI_LEVEL4,  // 筏
	0x95A5, KANJI_LEVEL4,  // 閥
	0x9CE9, KANJI_LEVEL4,  // 鳩
	0x567A, KANJI_LEVEL4,  // 噺
	0x5859, KANJI_LEVEL4,  // 塙
	0x86E4, KANJI_LEVEL4,  // 蛤
	0x96BC, KANJI_LEVEL4,  // 隼
	0x4F34, KANJI_LEVEL4,  // 伴
	0x5224, KANJI_LEVEL4,  // 判
	0x534A, KANJI_LEVEL4,  // 半
	0x53CD, KANJI_LEVEL4,  // 反
	0x53DB, KANJI_LEVEL4,  // 叛
	0x5E06, KANJI_LEVEL4,  // 帆
	0x642C, KANJI_LEVEL4,  // 搬
	0x6591, KANJI_LEVEL4,  // 斑
	0x677F, KANJI_LEVEL4,  // 板
	0x6C3E, KANJI_LEVEL4,  // 氾
	0x6C4E, KANJI_LEVEL4,  // 汎
	0x7248, KANJI_LEVEL4,  // 版
	0x72AF, KANJI_LEVEL4,  // 犯
	0x73ED, KANJI_LEVEL4,  // 班
	0x7554, KANJI_LEVEL4,  // 畔
	0x7E41, KANJI_LEVEL4,  // 繁
	0x822C, KANJI_LEVEL4,  // 般
	0x85E9, KANJI_LEVEL4,  // 藩
	0x8CA9, KANJI_LEVEL4,  // 販
	0x7BC4, KANJI_LEVEL4,  // 範
	0x91C6, KANJI_LEVEL4,  // 釆
	0x7169, KANJI_LEVEL4,  // 煩
	0x9812, KANJI_LEVEL4,  // 頒
	0x98EF, KANJI_LEVEL4,  // 飯
	0x633D, KANJI_LEVEL4,  // 挽
	0x6669, KANJI_LEVEL4,  // 晩
	0x756A, KANJI_LEVEL4,  // 番
	0x76E4, KANJI_LEVEL4,  // 盤
	0x78D0, KANJI_LEVEL4,  // 磐
	0x8543, KANJI_LEVEL4,  // 蕃
	0x86EE, KANJI_LEVEL4,  // 蛮
	0x532A, KANJI_LEVEL4,  // 匪
	0x5351, KANJI_LEVEL4,  // 卑
	0x5426, KANJI_LEVEL4,  // 否
	0x5983, KANJI_LEVEL4,  // 妃
	0x5E87, KANJI_LEVEL4,  // 庇
	0x5F7C, KANJI_LEVEL4,  // 彼
	0x60B2, KANJI_LEVEL4,  // 悲
	0x6249, KANJI_LEVEL4,  // 扉
	0x6279, KANJI_LEVEL4,  // 批
	0x62AB, KANJI_LEVEL4,  // 披
	0x6590, KANJI_LEVEL4,  // 斐
	0x6BD4, KANJI_LEVEL4,  // 比
	0x6CCC, KANJI_LEVEL4,  // 泌
	0x75B2, KANJI_LEVEL4,  // 疲
	0x76AE, KANJI_LEVEL4,  // 皮
	0x7891, KANJI_LEVEL4,  // 碑
	0x79D8, KANJI_LEVEL4,  // 秘
	0x7DCB, KANJI_LEVEL4,  // 緋
	0x7F77, KANJI_LEVEL4,  // 罷
	0x80A5, KANJI_LEVEL4,  // 肥
	0x88AB, KANJI_LEVEL4,  // 被
	0x8AB9, KANJI_LEVEL4,  // 誹
	0x8CBB, KANJI_LEVEL4,  // 費
	0x907F, KANJI_LEVEL4,  // 避
	0x975E, KANJI_LEVEL4,  // 非
	0x98DB, KANJI_LEVEL4,  // 飛
	0x6A0B, KANJI_LEVEL4,  // 樋
	0x7C38, KANJI_LEVEL4,  // 簸
	0x5099, KANJI_LEVEL4,  // 備
	0x5C3E, KANJI_LEVEL4,  // 尾
	0x5FAE, KANJI_LEVEL4,  // 微
	0x6787, KANJI_LEVEL4,  // 枇
	0x6BD8, KANJI_LEVEL4,  // 毘
	0x7435, KANJI_LEVEL4,  // 琵
	0x7709, KANJI_LEVEL4,  // 眉
	0x7F8E, KANJI_LEVEL4,  // 美
	0x9F3B, KANJI_LEVEL4,  // 鼻
	0x67CA, KANJI_LEVEL4,  // 柊
	0x7A17, KANJI_LEVEL4,  // 稗
	0x5339, KANJI_LEVEL4,  // 匹
	0x758B, KANJI_LEVEL4,  // 疋
	0x9AED, KANJI_LEVEL4,  // 髭
	0x5F66, KANJI_LEVEL4,  // 彦
	0x819D, KANJI_LEVEL4,  // 膝
	0x83F1, KANJI_LEVEL4,  // 菱
	0x8098, KANJI_LEVEL4,  // 肘
	0x5F3C, KANJI_LEVEL4,  // 弼
	0x5FC5, KANJI_LEVEL4,  // 必
	0x7562, KANJI_LEVEL4,  // 畢
	0x7B46, KANJI_LEVEL4,  // 筆
	0x903C, KANJI_LEVEL4,  // 逼
	0x6867, KANJI_LEVEL4,  // 桧
	0x59EB, KANJI_LEVEL4,  // 姫
	0x5A9B, KANJI_LEVEL4,  // 媛
	0x7D10, KANJI_LEVEL4,  // 紐
	0x767E, KANJI_LEVEL4,  // 百
	0x8B2C, KANJI_LEVEL4,  // 謬
	0x4FF5, KANJI_LEVEL4,  // 俵
	0x5F6A, KANJI_LEVEL4,  // 彪
	0x6A19, KANJI_LEVEL4,  // 標
	0x6C37, KANJI_LEVEL4,  // 氷
	0x6F02, KANJI_LEVEL4,  // 漂
	0x74E2, KANJI_LEVEL4,  // 瓢
	0x7968, KANJI_LEVEL4,  // 票
	0x8868, KANJI_LEVEL4,  // 表
	0x8A55, KANJI_LEVEL4,  // 評
	0x8C79, KANJI_LEVEL4,  // 豹
	0x5EDF, KANJI_LEVEL4,  // 廟
	0x63CF, KANJI_LEVEL4,  // 描
	0x75C5, KANJI_LEVEL4,  // 病
	0x79D2, KANJI_LEVEL4,  // 秒
	0x82D7, KANJI_LEVEL4,  // 苗
	0x9328, KANJI_LEVEL4,  // 錨
	0x92F2, KANJI_LEVEL4,  // 鋲
	0x849C, KANJI_LEVEL4,  // 蒜
	0x86ED, KANJI_LEVEL4,  // 蛭
	0x9C2D, KANJI_LEVEL4,  // 鰭
	0x54C1, KANJI_LEVEL4,  // 品
	0x5F6C, KANJI_LEVEL4,  // 彬
	0x658C, KANJI_LEVEL4,  // 斌
	0x6D5C, KANJI_LEVEL4,  // 浜
	0x7015, KANJI_LEVEL4,  // 瀕
	0x8CA7, KANJI_LEVEL4,  // 貧
	0x8CD3, KANJI_LEVEL4,  // 賓
	0x983B, KANJI_LEVEL4,  // 頻
	0x654F, KANJI_LEVEL4,  // 敏
	0x74F6, KANJI_LEVEL4,  // 瓶
	0x4E0D, KANJI_LEVEL4,  // 不
	0x4ED8, KANJI_LEVEL4,  // 付
	0x57E0, KANJI_LEVEL4,  // 埠
	0x592B, KANJI_LEVEL4,  // 夫
	0x5A66, KANJI_LEVEL4,  // 婦
	0x5BCC, KANJI_LEVEL4,  // 富
	0x51A8, KANJI_LEVEL4,  // 冨
	0x5E03, KANJI_LEVEL4,  // 布
	0x5E9C, KANJI_LEVEL4,  // 府
	0x6016, KANJI_LEVEL4,  // 怖
	0x6276, KANJI_LEVEL4,  // 扶
	0x6577, KANJI_LEVEL4,  // 敷
	0x65A7, KANJI_LEVEL4,  // 斧
	0x666E, KANJI_LEVEL4,  // 普
	0x6D6E, KANJI_LEVEL4,  // 浮
	0x7236, KANJI_LEVEL4,  // 父
	0x7B26, KANJI_LEVEL4,  // 符
	0x8150, KANJI_LEVEL4,  // 腐
	0x819A, KANJI_LEVEL4,  // 膚
	0x8299, KANJI_LEVEL4,  // 芙
	0x8B5C, KANJI_LEVEL4,  // 譜
	0x8CA0, KANJI_LEVEL4,  // 負
	0x8CE6, KANJI_LEVEL4,  // 賦
	0x8D74, KANJI_LEVEL4,  // 赴
	0x961C, KANJI_LEVEL4,  // 阜
	0x9644, KANJI_LEVEL4,  // 附
	0x4FAE, KANJI_LEVEL4,  // 侮
	0x64AB, KANJI_LEVEL4,  // 撫
	0x6B66, KANJI_LEVEL4,  // 武
	0x821E, KANJI_LEVEL4,  // 舞
	0x8461, KANJI_LEVEL4,  // 葡
	0x856A, KANJI_LEVEL4,  // 蕪
	0x90E8, KANJI_LEVEL4,  // 部
	0x5C01, KANJI_LEVEL4,  // 封
	0x6953, KANJI_LEVEL4,  // 楓
	0x98A8, KANJI_LEVEL4,  // 風
	0x847A, KANJI_LEVEL4,  // 葺
	0x8557, KANJI_LEVEL4,  // 蕗
	0x4F0F, KANJI_LEVEL4,  // 伏
	0x526F, KANJI_LEVEL4,  // 副
	0x5FA9, KANJI_LEVEL4,  // 復
	0x5E45, KANJI_LEVEL4,  // 幅
	0x670D, KANJI_LEVEL4,  // 服
	0x798F, KANJI_LEVEL4,  // 福
	0x8179, KANJI_LEVEL4,  // 腹
	0x8907, KANJI_LEVEL4,  // 複
	0x8986, KANJI_LEVEL4,  // 覆
	0x6DF5, KANJI_LEVEL4,  // 淵
	0x5F17, KANJI_LEVEL4,  // 弗
	0x6255, KANJI_LEVEL4,  // 払
	0x6CB8, KANJI_LEVEL4,  // 沸
	0x4ECF, KANJI_LEVEL4,  // 仏
	0x7269, KANJI_LEVEL4,  // 物
	0x9B92, KANJI_LEVEL4,  // 鮒
	0x5206, KANJI_LEVEL4,  // 分
	0x543B, KANJI_LEVEL4,  // 吻
	0x5674, KANJI_LEVEL4,  // 噴
	0x58B3, KANJI_LEVEL4,  // 墳
	0x61A4, KANJI_LEVEL4,  // 憤
	0x626E, KANJI_LEVEL4,  // 扮
	0x711A, KANJI_LEVEL4,  // 焚
	0x596E, KANJI_LEVEL4,  // 奮
	0x7C89, KANJI_LEVEL4,  // 粉
	0x7CDE, KANJI_LEVEL4,  // 糞
	0x7D1B, KANJI_LEVEL4,  // 紛
	0x96F0, KANJI_LEVEL4,  // 雰
	0x6587, KANJI_LEVEL4,  // 文
	0x805E, KANJI_LEVEL4,  // 聞
	0x4E19, KANJI_LEVEL4,  // 丙
	0x4F75, KANJI_LEVEL4,  // 併
	0x5175, KANJI_LEVEL4,  // 兵
	0x5840, KANJI_LEVEL4,  // 塀
	0x5E63, KANJI_LEVEL4,  // 幣
	0x5E73, KANJI_LEVEL4,  // 平
	0x5F0A, KANJI_LEVEL4,  // 弊
	0x67C4, KANJI_LEVEL4,  // 柄
	0x4E26, KANJI_LEVEL4,  // 並
	0x853D, KANJI_LEVEL4,  // 蔽
	0x9589, KANJI_LEVEL4,  // 閉
	0x965B, KANJI_LEVEL4,  // 陛
	0x7C73, KANJI_LEVEL4,  // 米
	0x9801, KANJI_LEVEL4,  // 頁
	0x50FB, KANJI_LEVEL4,  // 僻
	0x58C1, KANJI_LEVEL4,  // 壁
	0x7656, KANJI_LEVEL4,  // 癖
	0x78A7, KANJI_LEVEL4,  // 碧
	0x5225, KANJI_LEVEL4,  // 別
	0x77A5, KANJI_LEVEL4,  // 瞥
	0x8511, KANJI_LEVEL4,  // 蔑
	0x7B86, KANJI_LEVEL4,  // 箆
	0x504F, KANJI_LEVEL4,  // 偏
	0x5909, KANJI_LEVEL4,  // 変
	0x7247, KANJI_LEVEL4,  // 片
	0x7BC7, KANJI_LEVEL4,  // 篇
	0x7DE8, KANJI_LEVEL4,  // 編
	0x8FBA, KANJI_LEVEL4,  // 辺
	0x8FD4, KANJI_LEVEL4,  // 返
	0x904D, KANJI_LEVEL4,  // 遍
	0x4FBF, KANJI_LEVEL4,  // 便
	0x52C9, KANJI_LEVEL4,  // 勉
	0x5A29, KANJI_LEVEL4,  // 娩
	0x5F01, KANJI_LEVEL4,  // 弁
	0x97AD, KANJI_LEVEL4,  // 鞭
	0x4FDD, KANJI_LEVEL4,  // 保
	0x8217, KANJI_LEVEL4,  // 舗
	0x92EA, KANJI_LEVEL4,  // 鋪
	0x5703, KANJI_LEVEL4,  // 圃
	0x6355, KANJI_LEVEL4,  // 捕
	0x6B69, KANJI_LEVEL4,  // 歩
	0x752B, KANJI_LEVEL4,  // 甫
	0x88DC, KANJI_LEVEL4,  // 補
	0x8F14, KANJI_LEVEL4,  // 輔
	0x7A42, KANJI_LEVEL4,  // 穂
	0x52DF, KANJI_LEVEL4,  // 募
	0x5893, KANJI_LEVEL4,  // 墓
	0x6155, KANJI_LEVEL4,  // 慕
	0x620A, KANJI_LEVEL4,  // 戊
	0x66AE, KANJI_LEVEL4,  // 暮
	0x6BCD, KANJI_LEVEL4,  // 母
	0x7C3F, KANJI_LEVEL4,  // 簿
	0x83E9, KANJI_LEVEL4,  // 菩
	0x5023, KANJI_LEVEL4,  // 倣
	0x4FF8, KANJI_LEVEL4,  // 俸
	0x5305, KANJI_LEVEL4,  // 包
	0x5446, KANJI_LEVEL4,  // 呆
	0x5831, KANJI_LEVEL4,  // 報
	0x5949, KANJI_LEVEL4,  // 奉
	0x5B9D, KANJI_LEVEL4,  // 宝
	0x5CF0, KANJI_LEVEL4,  // 峰
	0x5CEF, KANJI_LEVEL4,  // 峯
	0x5D29, KANJI_LEVEL4,  // 崩
	0x5E96, KANJI_LEVEL4,  // 庖
	0x62B1, KANJI_LEVEL4,  // 抱
	0x6367, KANJI_LEVEL4,  // 捧
	0x653E, KANJI_LEVEL4,  // 放
	0x65B9, KANJI_LEVEL4,  // 方
	0x670B, KANJI_LEVEL4,  // 朋
	0x6CD5, KANJI_LEVEL4,  // 法
	0x6CE1, KANJI_LEVEL4,  // 泡
	0x70F9, KANJI_LEVEL4,  // 烹
	0x7832, KANJI_LEVEL4,  // 砲
	0x7E2B, KANJI_LEVEL4,  // 縫
	0x80DE, KANJI_LEVEL4,  // 胞
	0x82B3, KANJI_LEVEL4,  // 芳
	0x840C, KANJI_LEVEL4,  // 萌
	0x84EC, KANJI_LEVEL4,  // 蓬
	0x8702, KANJI_LEVEL4,  // 蜂
	0x8912, KANJI_LEVEL4,  // 褒
	0x8A2A, KANJI_LEVEL4,  // 訪
	0x8C4A, KANJI_LEVEL4,  // 豊
	0x90A6, KANJI_LEVEL4,  // 邦
	0x92D2, KANJI_LEVEL4,  // 鋒
	0x98FD, KANJI_LEVEL4,  // 飽
	0x9CF3, KANJI_LEVEL4,  // 鳳
	0x9D6C, KANJI_LEVEL4,  // 鵬
	0x4E4F, KANJI_LEVEL4,  // 乏
	0x4EA1, KANJI_LEVEL4,  // 亡
	0x508D, KANJI_LEVEL4,  // 傍
	0x5256, KANJI_LEVEL4,  // 剖
	0x574A, KANJI_LEVEL4,  // 坊
	0x59A8, KANJI_LEVEL4,  // 妨
	0x5E3D, KANJI_LEVEL4,  // 帽
	0x5FD8, KANJI_LEVEL4,  // 忘
	0x5FD9, KANJI_LEVEL4,  // 忙
	0x623F, KANJI_LEVEL4,  // 房
	0x66B4, KANJI_LEVEL4,  // 暴
	0x671B, KANJI_LEVEL4,  // 望
	0x67D0, KANJI_LEVEL4,  // 某
	0x68D2, KANJI_LEVEL4,  // 棒
	0x5192, KANJI_LEVEL4,  // 冒
	0x7D21, KANJI_LEVEL4,  // 紡
	0x80AA, KANJI_LEVEL4,  // 肪
	0x81A8, KANJI_LEVEL4,  // 膨
	0x8B00, KANJI_LEVEL4,  // 謀
	0x8C8C, KANJI_LEVEL4,  // 貌
	0x8CBF, KANJI_LEVEL4,  // 貿
	0x927E, KANJI_LEVEL4,  // 鉾
	0x9632, KANJI_LEVEL4,  // 防
	0x5420, KANJI_LEVEL4,  // 吠
	0x982C, KANJI_LEVEL4,  // 頬
	0x5317, KANJI_LEVEL4,  // 北
	0x50D5, KANJI_LEVEL4,  // 僕
	0x535C, KANJI_LEVEL4,  // 卜
	0x58A8, KANJI_LEVEL4,  // 墨
	0x64B2, KANJI_LEVEL4,  // 撲
	0x6734, KANJI_LEVEL4,  // 朴
	0x7267, KANJI_LEVEL4,  // 牧
	0x7766, KANJI_LEVEL4,  // 睦
	0x7A46, KANJI_LEVEL4,  // 穆
	0x91E6, KANJI_LEVEL4,  // 釦
	0x52C3, KANJI_LEVEL4,  // 勃
	0x6CA1, KANJI_LEVEL4,  // 没
	0x6B86, KANJI_LEVEL4,  // 殆
	0x5800, KANJI_LEVEL4,  // 堀
	0x5E4C, KANJI_LEVEL4,  // 幌
	0x5954, KANJI_LEVEL4,  // 奔
	0x672C, KANJI_LEVEL4,  // 本
	0x7FFB, KANJI_LEVEL4,  // 翻
	0x51E1, KANJI_LEVEL4,  // 凡
	0x76C6, KANJI_LEVEL4,  // 盆
	0x6469, KANJI_LEVEL4,  // 摩
	0x78E8, KANJI_LEVEL4,  // 磨
	0x9B54, KANJI_LEVEL4,  // 魔
	0x9EBB, KANJI_LEVEL4,  // 麻
	0x57CB, KANJI_LEVEL4,  // 埋
	0x59B9, KANJI_LEVEL4,  // 妹
	0x6627, KANJI_LEVEL4,  // 昧
	0x679A, KANJI_LEVEL4,  // 枚
	0x6BCE, KANJI_LEVEL4,  // 毎
	0x54E9, KANJI_LEVEL4,  // 哩
	0x69D9, KANJI_LEVEL4,  // 槙
	0x5E55, KANJI_LEVEL4,  // 幕
	0x819C, KANJI_LEVEL4,  // 膜
	0x6795, KANJI_LEVEL4,  // 枕
	0x9BAA, KANJI_LEVEL4,  // 鮪
	0x67FE, KANJI_LEVEL4,  // 柾
	0x9C52, KANJI_LEVEL4,  // 鱒
	0x685D, KANJI_LEVEL4,  // 桝
	0x4EA6, KANJI_LEVEL4,  // 亦
	0x4FE3, KANJI_LEVEL4,  // 俣
	0x53C8, KANJI_LEVEL4,  // 又
	0x62B9, KANJI_LEVEL4,  // 抹
	0x672B, KANJI_LEVEL4,  // 末
	0x6CAB, KANJI_LEVEL4,  // 沫
	0x8FC4, KANJI_LEVEL4,  // 迄
	0x4FAD, KANJI_LEVEL4,  // 侭
	0x7E6D, KANJI_LEVEL4,  // 繭
	0x9EBF, KANJI_LEVEL4,  // 麿
	0x4E07, KANJI_LEVEL4,  // 万
	0x6162, KANJI_LEVEL4,  // 慢
	0x6E80, KANJI_LEVEL4,  // 満
	0x6F2B, KANJI_LEVEL4,  // 漫
	0x8513, KANJI_LEVEL4,  // 蔓
	0x5473, KANJI_LEVEL4,  // 味
	0x672A, KANJI_LEVEL4,  // 未
	0x9B45, KANJI_LEVEL4,  // 魅
	0x5DF3, KANJI_LEVEL4,  // 巳
	0x7B95, KANJI_LEVEL4,  // 箕
	0x5CAC, KANJI_LEVEL4,  // 岬
	0x5BC6, KANJI_LEVEL4,  // 密
	0x871C, KANJI_LEVEL4,  // 蜜
	0x6E4A, KANJI_LEVEL4,  // 湊
	0x84D1, KANJI_LEVEL4,  // 蓑
	0x7A14, KANJI_LEVEL4,  // 稔
	0x8108, KANJI_LEVEL4,  // 脈
	0x5999, KANJI_LEVEL4,  // 妙
	0x7C8D, KANJI_LEVEL4,  // 粍
	0x6C11, KANJI_LEVEL4,  // 民
	0x7720, KANJI_LEVEL4,  // 眠
	0x52D9, KANJI_LEVEL4,  // 務
	0x5922, KANJI_LEVEL4,  // 夢
	0x7121, KANJI_LEVEL4,  // 無
	0x725F, KANJI_LEVEL4,  // 牟
	0x77DB, KANJI_LEVEL4,  // 矛
	0x9727, KANJI_LEVEL4,  // 霧
	0x9D61, KANJI_LEVEL4,  // 鵡
	0x690B, KANJI_LEVEL4,  // 椋
	0x5A7F, KANJI_LEVEL4,  // 婿
	0x5A18, KANJI_LEVEL4,  // 娘
	0x51A5, KANJI_LEVEL4,  // 冥
	0x540D, KANJI_LEVEL4,  // 名
	0x547D, KANJI_LEVEL4,  // 命
	0x660E, KANJI_LEVEL4,  // 明
	0x76DF, KANJI_LEVEL4,  // 盟
	0x8FF7, KANJI_LEVEL4,  // 迷
	0x9298, KANJI_LEVEL4,  // 銘
	0x9CF4, KANJI_LEVEL4,  // 鳴
	0x59EA, KANJI_LEVEL4,  // 姪
	0x725D, KANJI_LEVEL4,  // 牝
	0x6EC5, KANJI_LEVEL4,  // 滅
	0x514D, KANJI_LEVEL4,  // 免
	0x68C9, KANJI_LEVEL4,  // 棉
	0x7DBF, KANJI_LEVEL4,  // 綿
	0x7DEC, KANJI_LEVEL4,  // 緬
	0x9762, KANJI_LEVEL4,  // 面
	0x9EBA, KANJI_LEVEL4,  // 麺
	0x6478, KANJI_LEVEL4,  // 摸
	0x6A21, KANJI_LEVEL4,  // 模
	0x8302, KANJI_LEVEL4,  // 茂
	0x5984, KANJI_LEVEL4,  // 妄
	0x5B5F, KANJI_LEVEL4,  // 孟
	0x6BDB, KANJI_LEVEL4,  // 毛
	0x731B, KANJI_LEVEL4,  // 猛
	0x76F2, KANJI_LEVEL4,  // 盲
	0x7DB2, KANJI_LEVEL4,  // 網
	0x8017, KANJI_LEVEL4,  // 耗
	0x8499, KANJI_LEVEL4,  // 蒙
	0x5132, KANJI_LEVEL4,  // 儲
	0x6728, KANJI_LEVEL4,  // 木
	0x9ED9, KANJI_LEVEL4,  // 黙
	0x76EE, KANJI_LEVEL4,  // 目
	0x6762, KANJI_LEVEL4,  // 杢
	0x52FF, KANJI_LEVEL4,  // 勿
	0x9905, KANJI_LEVEL4,  // 餅
	0x5C24, KANJI_LEVEL4,  // 尤
	0x623B, KANJI_LEVEL4,  // 戻
	0x7C7E, KANJI_LEVEL4,  // 籾
	0x8CB0, KANJI_LEVEL4,  // 貰
	0x554F, KANJI_LEVEL4,  // 問
	0x60B6, KANJI_LEVEL4,  // 悶
	0x7D0B, KANJI_LEVEL4,  // 紋
	0x9580, KANJI_LEVEL4,  // 門
	0x5301, KANJI_LEVEL4,  // 匁
	0x4E5F, KANJI_LEVEL4,  // 也
	0x51B6, KANJI_LEVEL4,  // 冶
	0x591C, KANJI_LEVEL4,  // 夜
	0x723A, KANJI_LEVEL4,  // 爺
	0x8036, KANJI_LEVEL4,  // 耶
	0x91CE, KANJI_LEVEL4,  // 野
	0x5F25, KANJI_LEVEL4,  // 弥
	0x77E2, KANJI_LEVEL4,  // 矢
	0x5384, KANJI_LEVEL4,  // 厄
	0x5F79, KANJI_LEVEL4,  // 役
	0x7D04, KANJI_LEVEL4,  // 約
	0x85AC, KANJI_LEVEL4,  // 薬
	0x8A33, KANJI_LEVEL4,  // 訳
	0x8E8D, KANJI_LEVEL4,  // 躍
	0x9756, KANJI_LEVEL4,  // 靖
	0x67F3, KANJI_LEVEL4,  // 柳
	0x85AE, KANJI_LEVEL4,  // 薮
	0x9453, KANJI_LEVEL4,  // 鑓
	0x6109, KANJI_LEVEL4,  // 愉
	0x6108, KANJI_LEVEL4,  // 愈
	0x6CB9, KANJI_LEVEL4,  // 油
	0x7652, KANJI_LEVEL4,  // 癒
	0x8AED, KANJI_LEVEL4,  // 諭
	0x8F38, KANJI_LEVEL4,  // 輸
	0x552F, KANJI_LEVEL4,  // 唯
	0x4F51, KANJI_LEVEL4,  // 佑
	0x512A, KANJI_LEVEL4,  // 優
	0x52C7, KANJI_LEVEL4,  // 勇
	0x53CB, KANJI_LEVEL4,  // 友
	0x5BA5, KANJI_LEVEL4,  // 宥
	0x5E7D, KANJI_LEVEL4,  // 幽
	0x60A0, KANJI_LEVEL4,  // 悠
	0x6182, KANJI_LEVEL4,  // 憂
	0x63D6, KANJI_LEVEL4,  // 揖
	0x6709, KANJI_LEVEL4,  // 有
	0x67DA, KANJI_LEVEL4,  // 柚
	0x6E67, KANJI_LEVEL4,  // 湧
	0x6D8C, KANJI_LEVEL4,  // 涌
	0x7336, KANJI_LEVEL4,  // 猶
	0x7337, KANJI_LEVEL4,  // 猷
	0x7531, KANJI_LEVEL4,  // 由
	0x7950, KANJI_LEVEL4,  // 祐
	0x88D5, KANJI_LEVEL4,  // 裕
	0x8A98, KANJI_LEVEL4,  // 誘
	0x904A, KANJI_LEVEL4,  // 遊
	0x9091, KANJI_LEVEL4,  // 邑
	0x90F5, KANJI_LEVEL4,  // 郵
	0x96C4, KANJI_LEVEL4,  // 雄
	0x878D, KANJI_LEVEL4,  // 融
	0x5915, KANJI_LEVEL4,  // 夕
	0x4E88, KANJI_LEVEL4,  // 予
	0x4F59, KANJI_LEVEL4,  // 余
	0x4E0E, KANJI_LEVEL4,  // 与
	0x8A89, KANJI_LEVEL4,  // 誉
	0x8F3F, KANJI_LEVEL4,  // 輿
	0x9810, KANJI_LEVEL4,  // 預
	0x50AD, KANJI_LEVEL4,  // 傭
	0x5E7C, KANJI_LEVEL4,  // 幼
	0x5996, KANJI_LEVEL4,  // 妖
	0x5BB9, KANJI_LEVEL4,  // 容
	0x5EB8, KANJI_LEVEL4,  // 庸
	0x63DA, KANJI_LEVEL4,  // 揚
	0x63FA, KANJI_LEVEL4,  // 揺
	0x64C1, KANJI_LEVEL4,  // 擁
	0x66DC, KANJI_LEVEL4,  // 曜
	0x694A, KANJI_LEVEL4,  // 楊
	0x69D8, KANJI_LEVEL4,  // 様
	0x6D0B, KANJI_LEVEL4,  // 洋
	0x6EB6, KANJI_LEVEL4,  // 溶
	0x7194, KANJI_LEVEL4,  // 熔
	0x7528, KANJI_LEVEL4,  // 用
	0x7AAF, KANJI_LEVEL4,  // 窯
	0x7F8A, KANJI_LEVEL4,  // 羊
	0x8000, KANJI_LEVEL4,  // 耀
	0x8449, KANJI_LEVEL4,  // 葉
	0x84C9, KANJI_LEVEL4,  // 蓉
	0x8981, KANJI_LEVEL4,  // 要
	0x8B21, KANJI_LEVEL4,  // 謡
	0x8E0A, KANJI_LEVEL4,  // 踊
	0x9065, KANJI_LEVEL4,  // 遥
	0x967D, KANJI_LEVEL4,  // 陽
	0x990A, KANJI_LEVEL4,  // 養
	0x617E, KANJI_LEVEL4,  // 慾
	0x6291, KANJI_LEVEL4,  // 抑
	0x6B32, KANJI_LEVEL4,  // 欲
	0x6C83, KANJI_LEVEL4,  // 沃
	0x6D74, KANJI_LEVEL4,  // 浴
	0x7FCC, KANJI_LEVEL4,  // 翌
	0x7FFC, KANJI_LEVEL4,  // 翼
	0x6DC0, KANJI_LEVEL4,  // 淀
	0x7F85, KANJI_LEVEL4,  // 羅
	0x87BA, KANJI_LEVEL4,  // 螺
	0x88F8, KANJI_LEVEL4,  // 裸
	0x6765, KANJI_LEVEL4,  // 来
	0x83B1, KANJI_LEVEL4,  // 莱
	0x983C, KANJI_LEVEL4,  // 頼
	0x96F7, KANJI_LEVEL4,  // 雷
	0x6D1B, KANJI_LEVEL4,  // 洛
	0x7D61, KANJI_LEVEL4,  // 絡
	0x843D, KANJI_LEVEL4,  // 落
	0x916A, KANJI_LEVEL4,  // 酪
	0x4E71, KANJI_LEVEL4,  // 乱
	0x5375, KANJI_LEVEL4,  // 卵
	0x5D50, KANJI_LEVEL4,  // 嵐
	0x6B04, KANJI_LEVEL4,  // 欄
	0x6FEB, KANJI_LEVEL4,  // 濫
	0x85CD, KANJI_LEVEL4,  // 藍
	0x862D, KANJI_LEVEL4,  // 蘭
	0x89A7, KANJI_LEVEL4,  // 覧
	0x5229, KANJI_LEVEL4,  // 利
	0x540F, KANJI_LEVEL4,  // 吏
	0x5C65, KANJI_LEVEL4,  // 履
	0x674E, KANJI_LEVEL4,  // 李
	0x68A8, KANJI_LEVEL4,  // 梨
	0x7406, KANJI_LEVEL4,  // 理
	0x7483, KANJI_LEVEL4,  // 璃
	0x75E2, KANJI_LEVEL4,  // 痢
	0x88CF, KANJI_LEVEL4,  // 裏
	0x88E1, KANJI_LEVEL4,  // 裡
	0x91CC, KANJI_LEVEL4,  // 里
	0x96E2, KANJI_LEVEL4,  // 離
	0x9678, KANJI_LEVEL4,  // 陸
	0x5F8B, KANJI_LEVEL4,  // 律
	0x7387, KANJI_LEVEL4,  // 率
	0x7ACB, KANJI_LEVEL4,  // 立
	0x844E, KANJI_LEVEL4,  // 葎
	0x63A0, KANJI_LEVEL4,  // 掠
	0x7565, KANJI_LEVEL4,  // 略
	0x5289, KANJI_LEVEL4,  // 劉
	0x6D41, KANJI_LEVEL4,  // 流
	0x6E9C, KANJI_LEVEL4,  // 溜
	0x7409, KANJI_LEVEL4,  // 琉
	0x7559, KANJI_LEVEL4,  // 留
	0x786B, KANJI_LEVEL4,  // 硫
	0x7C92, KANJI_LEVEL4,  // 粒
	0x9686, KANJI_LEVEL4,  // 隆
	0x7ADC, KANJI_LEVEL4,  // 竜
	0x9F8D, KANJI_LEVEL4,  // 龍
	0x4FB6, KANJI_LEVEL4,  // 侶
	0x616E, KANJI_LEVEL4,  // 慮
	0x65C5, KANJI_LEVEL4,  // 旅
	0x865C, KANJI_LEVEL4,  // 虜
	0x4E86, KANJI_LEVEL4,  // 了
	0x4EAE, KANJI_LEVEL4,  // 亮
	0x50DA, KANJI_LEVEL4,  // 僚
	0x4E21, KANJI_LEVEL4,  // 両
	0x51CC, KANJI_LEVEL4,  // 凌
	0x5BEE, KANJI_LEVEL4,  // 寮
	0x6599, KANJI_LEVEL4,  // 料
	0x6881, KANJI_LEVEL4,  // 梁
	0x6DBC, KANJI_LEVEL4,  // 涼
	0x731F, KANJI_LEVEL4,  // 猟
	0x7642, KANJI_LEVEL4,  // 療
	0x77AD, KANJI_LEVEL4,  // 瞭
	0x7A1C, KANJI_LEVEL4,  // 稜
	0x7CE7, KANJI_LEVEL4,  // 糧
	0x826F, KANJI_LEVEL4,  // 良
	0x8AD2, KANJI_LEVEL4,  // 諒
	0x907C, KANJI_LEVEL4,  // 遼
	0x91CF, KANJI_LEVEL4,  // 量
	0x9675, KANJI_LEVEL4,  // 陵
	0x9818, KANJI_LEVEL4,  // 領
	0x529B, KANJI_LEVEL4,  // 力
	0x7DD1, KANJI_LEVEL4,  // 緑
	0x502B, KANJI_LEVEL4,  // 倫
	0x5398, KANJI_LEVEL4,  // 厘
	0x6797, KANJI_LEVEL4,  // 林
	0x6DCB, KANJI_LEVEL4,  // 淋
	0x71D0, KANJI_LEVEL4,  // 燐
	0x7433, KANJI_LEVEL4,  // 琳
	0x81E8, KANJI_LEVEL4,  // 臨
	0x8F2A, KANJI_LEVEL4,  // 輪
	0x96A3, KANJI_LEVEL4,  // 隣
	0x9C57, KANJI_LEVEL4,  // 鱗
	0x9E9F, KANJI_LEVEL4,  // 麟
	0x7460, KANJI_LEVEL4,  // 瑠
	0x5841, KANJI_LEVEL4,  // 塁
	0x6D99, KANJI_LEVEL4,  // 涙
	0x7D2F, KANJI_LEVEL4,  // 累
	0x985E, KANJI_LEVEL4,  // 類
	0x4EE4, KANJI_LEVEL4,  // 令
	0x4F36, KANJI_LEVEL4,  // 伶
	0x4F8B, KANJI_LEVEL4,  // 例
	0x51B7, KANJI_LEVEL4,  // 冷
	0x52B1, KANJI_LEVEL4,  // 励
	0x5DBA, KANJI_LEVEL4,  // 嶺
	0x601C, KANJI_LEVEL4,  // 怜
	0x73B2, KANJI_LEVEL4,  // 玲
	0x793C, KANJI_LEVEL4,  // 礼
	0x82D3, KANJI_LEVEL4,  // 苓
	0x9234, KANJI_LEVEL4,  // 鈴
	0x96B7, KANJI_LEVEL4,  // 隷
	0x96F6, KANJI_LEVEL4,  // 零
	0x970A, KANJI_LEVEL4,  // 霊
	0x9E97, KANJI_LEVEL4,  // 麗
	0x9F62, KANJI_LEVEL4,  // 齢
	0x66A6, KANJI_LEVEL4,  // 暦
	0x6B74, KANJI_LEVEL4,  // 歴
	0x5217, KANJI_LEVEL4,  // 列
	0x52A3, KANJI_LEVEL4,  // 劣
	0x70C8, KANJI_LEVEL4,  // 烈
	0x88C2, KANJI_LEVEL4,  // 裂
	0x5EC9, KANJI_LEVEL4,  // 廉
	0x604B, KANJI_LEVEL4,  // 恋
	0x6190, KANJI_LEVEL4,  // 憐
	0x6F23, KANJI_LEVEL4,  // 漣
	0x7149, KANJI_LEVEL4,  // 煉
	0x7C3E, KANJI_LEVEL4,  // 簾
	0x7DF4, KANJI_LEVEL4,  // 練
	0x806F, KANJI_LEVEL4,  // 聯
	0x84EE, KANJI_LEVEL4,  // 蓮
	0x9023, KANJI_LEVEL4,  // 連
	0x932C, KANJI_LEVEL4,  // 錬
	0x5442, KANJI_LEVEL4,  // 呂
	0x9B6F, KANJI_LEVEL4,  // 魯
	0x6AD3, KANJI_LEVEL4,  // 櫓
	0x7089, KANJI_LEVEL4,  // 炉
	0x8CC2, KANJI_LEVEL4,  // 賂
	0x8DEF, KANJI_LEVEL4,  // 路
	0x9732, KANJI_LEVEL4,  // 露
	0x52B4, KANJI_LEVEL4,  // 労
	0x5A41, KANJI_LEVEL4,  // 婁
	0x5ECA, KANJI_LEVEL4,  // 廊
	0x5F04, KANJI_LEVEL4,  // 弄
	0x6717, KANJI_LEVEL4,  // 朗
	0x697C, KANJI_LEVEL4,  // 楼
	0x6994, KANJI_LEVEL4,  // 榔
	0x6D6A, KANJI_LEVEL4,  // 浪
	0x6F0F, KANJI_LEVEL4,  // 漏
	0x7262, KANJI_LEVEL4,  // 牢
	0x72FC, KANJI_LEVEL4,  // 狼
	0x7BED, KANJI_LEVEL4,  // 篭
	0x8001, KANJI_LEVEL4,  // 老
	0x807E, KANJI_LEVEL4,  // 聾
	0x874B, KANJI_LEVEL4,  // 蝋
	0x90CE, KANJI_LEVEL4,  // 郎
	0x516D, KANJI_LEVEL4,  // 六
	0x9E93, KANJI_LEVEL4,  // 麓
	0x7984, KANJI_LEVEL4,  // 禄
	0x808B, KANJI_LEVEL4,  // 肋
	0x9332, KANJI_LEVEL4,  // 録
	0x8AD6, KANJI_LEVEL4,  // 論
	0x502D, KANJI_LEVEL4,  // 倭
	0x548C, KANJI_LEVEL4,  // 和
	0x8A71, KANJI_LEVEL4,  // 話
	0x6B6A, KANJI_LEVEL4,  // 歪
	0x8CC4, KANJI_LEVEL4,  // 賄
	0x8107, KANJI_LEVEL4,  // 脇
	0x60D1, KANJI_LEVEL4,  // 惑
	0x67A0, KANJI_LEVEL4,  // 枠
	0x9DF2, KANJI_LEVEL4,  // 鷲
	0x4E99, KANJI_LEVEL4,  // 亙
	0x4E98, KANJI_LEVEL4,  // 亘
	0x9C10, KANJI_LEVEL4,  // 鰐
	0x8A6B, KANJI_LEVEL4,  // 詫
	0x85C1, KANJI_LEVEL4,  // 藁
	0x8568, KANJI_LEVEL4,  // 蕨
	0x6900, KANJI_LEVEL4,  // 椀
	0x6E7E, KANJI_LEVEL4,  // 湾
	0x7897, KANJI_LEVEL4,  // 碗
	0x8155, KANJI_LEVEL4,  // 腕
	0xD842, KANJI_LEVEL4,  // �
	0xDF9F, KANJI_LEVEL4,  // �
	0x5B41, KANJI_LEVEL4,  // 孁
	0x5B56, KANJI_LEVEL4,  // 孖
	0x5B7D, KANJI_LEVEL4,  // 孽
	0x5B93, KANJI_LEVEL4,  // 宓
	0x5BD8, KANJI_LEVEL4,  // 寘
	0x5BEC, KANJI_LEVEL4,  // 寬
	0x5C12, KANJI_LEVEL4,  // 尒
	0x5C1E, KANJI_LEVEL4,  // 尞
	0x5C23, KANJI_LEVEL4,  // 尣
	0x5C2B, KANJI_LEVEL4,  // 尫
	0x378D, KANJI_LEVEL4,  // 㞍
	0x5C62, KANJI_LEVEL4,  // 屢
	0xFA3B, KANJI_LEVEL4,  // 層
	0xFA3C, KANJI_LEVEL4,  // 屮
	0xD845, KANJI_LEVEL4,  // �
	0xDEB4, KANJI_LEVEL4,  // �
	0x5C7A, KANJI_LEVEL4,  // 屺
	0x5C8F, KANJI_LEVEL4,  // 岏
	0x5C9F, KANJI_LEVEL4,  // 岟
	0x5CA3, KANJI_LEVEL4,  // 岣
	0x5CAA, KANJI_LEVEL4,  // 岪
	0x5CBA, KANJI_LEVEL4,  // 岺
	0x5CCB, KANJI_LEVEL4,  // 峋
	0x5CD0, KANJI_LEVEL4,  // 峐
	0x5CD2, KANJI_LEVEL4,  // 峒
	0x5CF4, KANJI_LEVEL4,  // 峴
	0xD847, KANJI_LEVEL4,  // �
	0xDE34, KANJI_LEVEL4,  // �
	0x37E2, KANJI_LEVEL4,  // 㟢
	0x5D0D, KANJI_LEVEL4,  // 崍
	0x5D27, KANJI_LEVEL4,  // 崧
	0xFA11, KANJI_LEVEL4,  // 﨑
	0x5D46, KANJI_LEVEL4,  // 嵆
	0x5D47, KANJI_LEVEL4,  // 嵇
	0x5D53, KANJI_LEVEL4,  // 嵓
	0x5D4A, KANJI_LEVEL4,  // 嵊
	0x5D6D, KANJI_LEVEL4,  // 嵭
	0x5D81, KANJI_LEVEL4,  // 嶁
	0x5DA0, KANJI_LEVEL4,  // 嶠
	0x5DA4, KANJI_LEVEL4,  // 嶤
	0x5DA7, KANJI_LEVEL4,  // 嶧
	0x5DB8, KANJI_LEVEL4,  // 嶸
	0x5DCB, KANJI_LEVEL4,  // 巋
	0x541E, KANJI_LEVEL4,  // 吞
	0x5F0C, KANJI_LEVEL4,  // 弌
	0x4E10, KANJI_LEVEL4,  // 丐
	0x4E15, KANJI_LEVEL4,  // 丕
	0x4E2A, KANJI_LEVEL4,  // 个
	0x4E31, KANJI_LEVEL4,  // 丱
	0x4E36, KANJI_LEVEL4,  // 丶
	0x4E3C, KANJI_LEVEL4,  // 丼
	0x4E3F, KANJI_LEVEL4,  // 丿
	0x4E42, KANJI_LEVEL4,  // 乂
	0x4E56, KANJI_LEVEL4,  // 乖
	0x4E58, KANJI_LEVEL4,  // 乘
	0x4E82, KANJI_LEVEL4,  // 亂
	0x4E85, KANJI_LEVEL4,  // 亅
	0x8C6B, KANJI_LEVEL4,  // 豫
	0x4E8A, KANJI_LEVEL4,  // 亊
	0x8212, KANJI_LEVEL4,  // 舒
	0x5F0D, KANJI_LEVEL4,  // 弍
	0x4E8E, KANJI_LEVEL4,  // 于
	0x4E9E, KANJI_LEVEL4,  // 亞
	0x4E9F, KANJI_LEVEL4,  // 亟
	0x4EA0, KANJI_LEVEL4,  // 亠
	0x4EA2, KANJI_LEVEL4,  // 亢
	0x4EB0, KANJI_LEVEL4,  // 亰
	0x4EB3, KANJI_LEVEL4,  // 亳
	0x4EB6, KANJI_LEVEL4,  // 亶
	0x4ECE, KANJI_LEVEL4,  // 从
	0x4ECD, KANJI_LEVEL4,  // 仍
	0x4EC4, KANJI_LEVEL4,  // 仄
	0x4EC6, KANJI_LEVEL4,  // 仆
	0x4EC2, KANJI_LEVEL4,  // 仂
	0x4ED7, KANJI_LEVEL4,  // 仗
	0x4EDE, KANJI_LEVEL4,  // 仞
	0x4EED, KANJI_LEVEL4,  // 仭
	0x4EDF, KANJI_LEVEL4,  // 仟
	0x4EF7, KANJI_LEVEL4,  // 价
	0x4F09, KANJI_LEVEL4,  // 伉
	0x4F5A, KANJI_LEVEL4,  // 佚
	0x4F30, KANJI_LEVEL4,  // 估
	0x4F5B, KANJI_LEVEL4,  // 佛
	0x4F5D, KANJI_LEVEL4,  // 佝
	0x4F57, KANJI_LEVEL4,  // 佗
	0x4F47, KANJI_LEVEL4,  // 佇
	0x4F76, KANJI_LEVEL4,  // 佶
	0x4F88, KANJI_LEVEL4,  // 侈
	0x4F8F, KANJI_LEVEL4,  // 侏
	0x4F98, KANJI_LEVEL4,  // 侘
	0x4F7B, KANJI_LEVEL4,  // 佻
	0x4F69, KANJI_LEVEL4,  // 佩
	0x4F70, KANJI_LEVEL4,  // 佰
	0x4F91, KANJI_LEVEL4,  // 侑
	0x4F6F, KANJI_LEVEL4,  // 佯
	0x4F86, KANJI_LEVEL4,  // 來
	0x4F96, KANJI_LEVEL4,  // 侖
	0x5118, KANJI_LEVEL4,  // 儘
	0x4FD4, KANJI_LEVEL4,  // 俔
	0x4FDF, KANJI_LEVEL4,  // 俟
	0x4FCE, KANJI_LEVEL4,  // 俎
	0x4FD8, KANJI_LEVEL4,  // 俘
	0x4FDB, KANJI_LEVEL4,  // 俛
	0x4FD1, KANJI_LEVEL4,  // 俑
	0x4FDA, KANJI_LEVEL4,  // 俚
	0x4FD0, KANJI_LEVEL4,  // 俐
	0x4FE4, KANJI_LEVEL4,  // 俤
	0x4FE5, KANJI_LEVEL4,  // 俥
	0x501A, KANJI_LEVEL4,  // 倚
	0x5028, KANJI_LEVEL4,  // 倨
	0x5014, KANJI_LEVEL4,  // 倔
	0x502A, KANJI_LEVEL4,  // 倪
	0x5025, KANJI_LEVEL4,  // 倥
	0x5005, KANJI_LEVEL4,  // 倅
	0x4F1C, KANJI_LEVEL4,  // 伜
	0x4FF6, KANJI_LEVEL4,  // 俶
	0x5021, KANJI_LEVEL4,  // 倡
	0x5029, KANJI_LEVEL4,  // 倩
	0x502C, KANJI_LEVEL4,  // 倬
	0x4FFE, KANJI_LEVEL4,  // 俾
	0x4FEF, KANJI_LEVEL4,  // 俯
	0x5011, KANJI_LEVEL4,  // 們
	0x5006, KANJI_LEVEL4,  // 倆
	0x5043, KANJI_LEVEL4,  // 偃
	0x5047, KANJI_LEVEL4,  // 假
	0x6703, KANJI_LEVEL4,  // 會
	0x5055, KANJI_LEVEL4,  // 偕
	0x5050, KANJI_LEVEL4,  // 偐
	0x5048, KANJI_LEVEL4,  // 偈
	0x505A, KANJI_LEVEL4,  // 做
	0x5056, KANJI_LEVEL4,  // 偖
	0x506C, KANJI_LEVEL4,  // 偬
	0x5078, KANJI_LEVEL4,  // 偸
	0x5080, KANJI_LEVEL4,  // 傀
	0x509A, KANJI_LEVEL4,  // 傚
	0x5085, KANJI_LEVEL4,  // 傅
	0x50B4, KANJI_LEVEL4,  // 傴
	0x50B2, KANJI_LEVEL4,  // 傲
	0x50C9, KANJI_LEVEL4,  // 僉
	0x50CA, KANJI_LEVEL4,  // 僊
	0x50B3, KANJI_LEVEL4,  // 傳
	0x50C2, KANJI_LEVEL4,  // 僂
	0x50D6, KANJI_LEVEL4,  // 僖
	0x50DE, KANJI_LEVEL4,  // 僞
	0x50E5, KANJI_LEVEL4,  // 僥
	0x50ED, KANJI_LEVEL4,  // 僭
	0x50E3, KANJI_LEVEL4,  // 僣
	0x50EE, KANJI_LEVEL4,  // 僮
	0x50F9, KANJI_LEVEL4,  // 價
	0x50F5, KANJI_LEVEL4,  // 僵
	0x5109, KANJI_LEVEL4,  // 儉
	0x5101, KANJI_LEVEL4,  // 儁
	0x5102, KANJI_LEVEL4,  // 儂
	0x5116, KANJI_LEVEL4,  // 儖
	0x5115, KANJI_LEVEL4,  // 儕
	0x5114, KANJI_LEVEL4,  // 儔
	0x511A, KANJI_LEVEL4,  // 儚
	0x5121, KANJI_LEVEL4,  // 儡
	0x513A, KANJI_LEVEL4,  // 儺
	0x5137, KANJI_LEVEL4,  // 儷
	0x513C, KANJI_LEVEL4,  // 儼
	0x513B, KANJI_LEVEL4,  // 儻
	0x513F, KANJI_LEVEL4,  // 儿
	0x5140, KANJI_LEVEL4,  // 兀
	0x5152, KANJI_LEVEL4,  // 兒
	0x514C, KANJI_LEVEL4,  // 兌
	0x5154, KANJI_LEVEL4,  // 兔
	0x5162, KANJI_LEVEL4,  // 兢
	0x7AF8, KANJI_LEVEL4,  // 竸
	0x5169, KANJI_LEVEL4,  // 兩
	0x516A, KANJI_LEVEL4,  // 兪
	0x516E, KANJI_LEVEL4,  // 兮
	0x5180, KANJI_LEVEL4,  // 冀
	0x5182, KANJI_LEVEL4,  // 冂
	0x56D8, KANJI_LEVEL4,  // 囘
	0x518C, KANJI_LEVEL4,  // 册
	0x5189, KANJI_LEVEL4,  // 冉
	0x518F, KANJI_LEVEL4,  // 冏
	0x5191, KANJI_LEVEL4,  // 冑
	0x5193, KANJI_LEVEL4,  // 冓
	0x5195, KANJI_LEVEL4,  // 冕
	0x5196, KANJI_LEVEL4,  // 冖
	0x51A4, KANJI_LEVEL4,  // 冤
	0x51A6, KANJI_LEVEL4,  // 冦
	0x51A2, KANJI_LEVEL4,  // 冢
	0x51A9, KANJI_LEVEL4,  // 冩
	0x51AA, KANJI_LEVEL4,  // 冪
	0x51AB, KANJI_LEVEL4,  // 冫
	0x51B3, KANJI_LEVEL4,  // 决
	0x51B1, KANJI_LEVEL4,  // 冱
	0x51B2, KANJI_LEVEL4,  // 冲
	0x51B0, KANJI_LEVEL4,  // 冰
	0x51B5, KANJI_LEVEL4,  // 况
	0x51BD, KANJI_LEVEL4,  // 冽
	0x51C5, KANJI_LEVEL4,  // 凅
	0x51C9, KANJI_LEVEL4,  // 凉
	0x51DB, KANJI_LEVEL4,  // 凛
	0x51E0, KANJI_LEVEL4,  // 几
	0x8655, KANJI_LEVEL4,  // 處
	0x51E9, KANJI_LEVEL4,  // 凩
	0x51ED, KANJI_LEVEL4,  // 凭
	0x51F0, KANJI_LEVEL4,  // 凰
	0x51F5, KANJI_LEVEL4,  // 凵
	0x51FE, KANJI_LEVEL4,  // 凾
	0x5204, KANJI_LEVEL4,  // 刄
	0x520B, KANJI_LEVEL4,  // 刋
	0x5214, KANJI_LEVEL4,  // 刔
	0x520E, KANJI_LEVEL4,  // 刎
	0x5227, KANJI_LEVEL4,  // 刧
	0x522A, KANJI_LEVEL4,  // 刪
	0x522E, KANJI_LEVEL4,  // 刮
	0x5233, KANJI_LEVEL4,  // 刳
	0x5239, KANJI_LEVEL4,  // 刹
	0x524F, KANJI_LEVEL4,  // 剏
	0x5244, KANJI_LEVEL4,  // 剄
	0x524B, KANJI_LEVEL4,  // 剋
	0x524C, KANJI_LEVEL4,  // 剌
	0x525E, KANJI_LEVEL4,  // 剞
	0x5254, KANJI_LEVEL4,  // 剔
	0x526A, KANJI_LEVEL4,  // 剪
	0x5274, KANJI_LEVEL4,  // 剴
	0x5269, KANJI_LEVEL4,  // 剩
	0x5273, KANJI_LEVEL4,  // 剳
	0x527F, KANJI_LEVEL4,  // 剿
	0x527D, KANJI_LEVEL4,  // 剽
	0x528D, KANJI_LEVEL4,  // 劍
	0x5294, KANJI_LEVEL4,  // 劔
	0x5292, KANJI_LEVEL4,  // 劒
	0x5271, KANJI_LEVEL4,  // 剱
	0x5288, KANJI_LEVEL4,  // 劈
	0x5291, KANJI_LEVEL4,  // 劑
	0x8FA8, KANJI_LEVEL4,  // 辨
	0x8FA7, KANJI_LEVEL4,  // 辧
	0x52AC, KANJI_LEVEL4,  // 劬
	0x52AD, KANJI_LEVEL4,  // 劭
	0x52BC, KANJI_LEVEL4,  // 劼
	0x52B5, KANJI_LEVEL4,  // 劵
	0x52C1, KANJI_LEVEL4,  // 勁
	0x52CD, KANJI_LEVEL4,  // 勍
	0x52D7, KANJI_LEVEL4,  // 勗
	0x52DE, KANJI_LEVEL4,  // 勞
	0x52E3, KANJI_LEVEL4,  // 勣
	0x52E6, KANJI_LEVEL4,  // 勦
	0x98ED, KANJI_LEVEL4,  // 飭
	0x52E0, KANJI_LEVEL4,  // 勠
	0x52F3, KANJI_LEVEL4,  // 勳
	0x52F5, KANJI_LEVEL4,  // 勵
	0x52F8, KANJI_LEVEL4,  // 勸
	0x52F9, KANJI_LEVEL4,  // 勹
	0x5306, KANJI_LEVEL4,  // 匆
	0x5308, KANJI_LEVEL4,  // 匈
	0x7538, KANJI_LEVEL4,  // 甸
	0x530D, KANJI_LEVEL4,  // 匍
	0x5310, KANJI_LEVEL4,  // 匐
	0x530F, KANJI_LEVEL4,  // 匏
	0x5315, KANJI_LEVEL4,  // 匕
	0x531A, KANJI_LEVEL4,  // 匚
	0x5323, KANJI_LEVEL4,  // 匣
	0x532F, KANJI_LEVEL4,  // 匯
	0x5331, KANJI_LEVEL4,  // 匱
	0x5333, KANJI_LEVEL4,  // 匳
	0x5338, KANJI_LEVEL4,  // 匸
	0x5340, KANJI_LEVEL4,  // 區
	0x5346, KANJI_LEVEL4,  // 卆
	0x5345, KANJI_LEVEL4,  // 卅
	0x4E17, KANJI_LEVEL4,  // 丗
	0x5349, KANJI_LEVEL4,  // 卉
	0x534D, KANJI_LEVEL4,  // 卍
	0x51D6, KANJI_LEVEL4,  // 凖
	0x535E, KANJI_LEVEL4,  // 卞
	0x5369, KANJI_LEVEL4,  // 卩
	0x536E, KANJI_LEVEL4,  // 卮
	0x5918, KANJI_LEVEL4,  // 夘
	0x537B, KANJI_LEVEL4,  // 卻
	0x5377, KANJI_LEVEL4,  // 卷
	0x5382, KANJI_LEVEL4,  // 厂
	0x5396, KANJI_LEVEL4,  // 厖
	0x53A0, KANJI_LEVEL4,  // 厠
	0x53A6, KANJI_LEVEL4,  // 厦
	0x53A5, KANJI_LEVEL4,  // 厥
	0x53AE, KANJI_LEVEL4,  // 厮
	0x53B0, KANJI_LEVEL4,  // 厰
	0x53B6, KANJI_LEVEL4,  // 厶
	0x53C3, KANJI_LEVEL4,  // 參
	0x7C12, KANJI_LEVEL4,  // 簒
	0x96D9, KANJI_LEVEL4,  // 雙
	0x53DF, KANJI_LEVEL4,  // 叟
	0x66FC, KANJI_LEVEL4,  // 曼
	0x71EE, KANJI_LEVEL4,  // 燮
	0x53EE, KANJI_LEVEL4,  // 叮
	0x53E8, KANJI_LEVEL4,  // 叨
	0x53ED, KANJI_LEVEL4,  // 叭
	0x53FA, KANJI_LEVEL4,  // 叺
	0x5401, KANJI_LEVEL4,  // 吁
	0x543D, KANJI_LEVEL4,  // 吽
	0x5440, KANJI_LEVEL4,  // 呀
	0x542C, KANJI_LEVEL4,  // 听
	0x542D, KANJI_LEVEL4,  // 吭
	0x543C, KANJI_LEVEL4,  // 吼
	0x542E, KANJI_LEVEL4,  // 吮
	0x5436, KANJI_LEVEL4,  // 吶
	0x5429, KANJI_LEVEL4,  // 吩
	0x541D, KANJI_LEVEL4,  // 吝
	0x544E, KANJI_LEVEL4,  // 呎
	0x548F, KANJI_LEVEL4,  // 咏
	0x5475, KANJI_LEVEL4,  // 呵
	0x548E, KANJI_LEVEL4,  // 咎
	0x545F, KANJI_LEVEL4,  // 呟
	0x5471, KANJI_LEVEL4,  // 呱
	0x5477, KANJI_LEVEL4,  // 呷
	0x5470, KANJI_LEVEL4,  // 呰
	0x5492, KANJI_LEVEL4,  // 咒
	0x547B, KANJI_LEVEL4,  // 呻
	0x5480, KANJI_LEVEL4,  // 咀
	0x5476, KANJI_LEVEL4,  // 呶
	0x5484, KANJI_LEVEL4,  // 咄
	0x5490, KANJI_LEVEL4,  // 咐
	0x5486, KANJI_LEVEL4,  // 咆
	0x54C7, KANJI_LEVEL4,  // 哇
	0x54A2, KANJI_LEVEL4,  // 咢
	0x54B8, KANJI_LEVEL4,  // 咸
	0x54A5, KANJI_LEVEL4,  // 咥
	0x54AC, KANJI_LEVEL4,  // 咬
	0x54C4, KANJI_LEVEL4,  // 哄
	0x54C8, KANJI_LEVEL4,  // 哈
	0x54A8, KANJI_LEVEL4,  // 咨
	0x54AB, KANJI_LEVEL4,  // 咫
	0x54C2, KANJI_LEVEL4,  // 哂
	0x54A4, KANJI_LEVEL4,  // 咤
	0x54BE, KANJI_LEVEL4,  // 咾
	0x54BC, KANJI_LEVEL4,  // 咼
	0x54D8, KANJI_LEVEL4,  // 哘
	0x54E5, KANJI_LEVEL4,  // 哥
	0x54E6, KANJI_LEVEL4,  // 哦
	0x550F, KANJI_LEVEL4,  // 唏
	0x5514, KANJI_LEVEL4,  // 唔
	0x54FD, KANJI_LEVEL4,  // 哽
	0x54EE, KANJI_LEVEL4,  // 哮
	0x54ED, KANJI_LEVEL4,  // 哭
	0x54FA, KANJI_LEVEL4,  // 哺
	0x54E2, KANJI_LEVEL4,  // 哢
	0x5539, KANJI_LEVEL4,  // 唹
	0x5540, KANJI_LEVEL4,  // 啀
	0x5563, KANJI_LEVEL4,  // 啣
	0x554C, KANJI_LEVEL4,  // 啌
	0x552E, KANJI_LEVEL4,  // 售
	0x555C, KANJI_LEVEL4,  // 啜
	0x5545, KANJI_LEVEL4,  // 啅
	0x5556, KANJI_LEVEL4,  // 啖
	0x5557, KANJI_LEVEL4,  // 啗
	0x5538, KANJI_LEVEL4,  // 唸
	0x5533, KANJI_LEVEL4,  // 唳
	0x555D, KANJI_LEVEL4,  // 啝
	0x5599, KANJI_LEVEL4,  // 喙
	0x5580, KANJI_LEVEL4,  // 喀
	0x54AF, KANJI_LEVEL4,  // 咯
	0x558A, KANJI_LEVEL4,  // 喊
	0x559F, KANJI_LEVEL4,  // 喟
	0x557B, KANJI_LEVEL4,  // 啻
	0x557E, KANJI_LEVEL4,  // 啾
	0x5598, KANJI_LEVEL4,  // 喘
	0x559E, KANJI_LEVEL4,  // 喞
	0x55AE, KANJI_LEVEL4,  // 單
	0x557C, KANJI_LEVEL4,  // 啼
	0x5583, KANJI_LEVEL4,  // 喃
	0x55A9, KANJI_LEVEL4,  // 喩
	0x5587, KANJI_LEVEL4,  // 喇
	0x55A8, KANJI_LEVEL4,  // 喨
	0x55DA, KANJI_LEVEL4,  // 嗚
	0x55C5, KANJI_LEVEL4,  // 嗅
	0x55DF, KANJI_LEVEL4,  // 嗟
	0x55C4, KANJI_LEVEL4,  // 嗄
	0x55DC, KANJI_LEVEL4,  // 嗜
	0x55E4, KANJI_LEVEL4,  // 嗤
	0x55D4, KANJI_LEVEL4,  // 嗔
	0x5614, KANJI_LEVEL4,  // 嘔
	0x55F7, KANJI_LEVEL4,  // 嗷
	0x5616, KANJI_LEVEL4,  // 嘖
	0x55FE, KANJI_LEVEL4,  // 嗾
	0x55FD, KANJI_LEVEL4,  // 嗽
	0x561B, KANJI_LEVEL4,  // 嘛
	0x55F9, KANJI_LEVEL4,  // 嗹
	0x564E, KANJI_LEVEL4,  // 噎
	0x5650, KANJI_LEVEL4,  // 噐
	0x71DF, KANJI_LEVEL4,  // 營
	0x5634, KANJI_LEVEL4,  // 嘴
	0x5636, KANJI_LEVEL4,  // 嘶
	0x5632, KANJI_LEVEL4,  // 嘲
	0x5638, KANJI_LEVEL4,  // 嘸
	0x566B, KANJI_LEVEL4,  // 噫
	0x5664, KANJI_LEVEL4,  // 噤
	0x562F, KANJI_LEVEL4,  // 嘯
	0x566C, KANJI_LEVEL4,  // 噬
	0x566A, KANJI_LEVEL4,  // 噪
	0x5686, KANJI_LEVEL4,  // 嚆
	0x5680, KANJI_LEVEL4,  // 嚀
	0x568A, KANJI_LEVEL4,  // 嚊
	0x56A0, KANJI_LEVEL4,  // 嚠
	0x5694, KANJI_LEVEL4,  // 嚔
	0x568F, KANJI_LEVEL4,  // 嚏
	0x56A5, KANJI_LEVEL4,  // 嚥
	0x56AE, KANJI_LEVEL4,  // 嚮
	0x56B6, KANJI_LEVEL4,  // 嚶
	0x56B4, KANJI_LEVEL4,  // 嚴
	0x56C2, KANJI_LEVEL4,  // 囂
	0x56BC, KANJI_LEVEL4,  // 嚼
	0x56C1, KANJI_LEVEL4,  // 囁
	0x56C3, KANJI_LEVEL4,  // 囃
	0x56C0, KANJI_LEVEL4,  // 囀
	0x56C8, KANJI_LEVEL4,  // 囈
	0x56CE, KANJI_LEVEL4,  // 囎
	0x56D1, KANJI_LEVEL4,  // 囑
	0x56D3, KANJI_LEVEL4,  // 囓
	0x56D7, KANJI_LEVEL4,  // 囗
	0x56EE, KANJI_LEVEL4,  // 囮
	0x56F9, KANJI_LEVEL4,  // 囹
	0x5700, KANJI_LEVEL4,  // 圀
	0x56FF, KANJI_LEVEL4,  // 囿
	0x5704, KANJI_LEVEL4,  // 圄
	0x5709, KANJI_LEVEL4,  // 圉
	0x5708, KANJI_LEVEL4,  // 圈
	0x570B, KANJI_LEVEL4,  // 國
	0x570D, KANJI_LEVEL4,  // 圍
	0x5713, KANJI_LEVEL4,  // 圓
	0x5718, KANJI_LEVEL4,  // 團
	0x5716, KANJI_LEVEL4,  // 圖
	0x55C7, KANJI_LEVEL4,  // 嗇
	0x571C, KANJI_LEVEL4,  // 圜
	0x5726, KANJI_LEVEL4,  // 圦
	0x5737, KANJI_LEVEL4,  // 圷
	0x5738, KANJI_LEVEL4,  // 圸
	0x574E, KANJI_LEVEL4,  // 坎
	0x573B, KANJI_LEVEL4,  // 圻
	0x5740, KANJI_LEVEL4,  // 址
	0x574F, KANJI_LEVEL4,  // 坏
	0x5769, KANJI_LEVEL4,  // 坩
	0x57C0, KANJI_LEVEL4,  // 埀
	0x5788, KANJI_LEVEL4,  // 垈
	0x5761, KANJI_LEVEL4,  // 坡
	0x577F, KANJI_LEVEL4,  // 坿
	0x5789, KANJI_LEVEL4,  // 垉
	0x5793, KANJI_LEVEL4,  // 垓
	0x57A0, KANJI_LEVEL4,  // 垠
	0x57B3, KANJI_LEVEL4,  // 垳
	0x57A4, KANJI_LEVEL4,  // 垤
	0x57AA, KANJI_LEVEL4,  // 垪
	0x57B0, KANJI_LEVEL4,  // 垰
	0x57C3, KANJI_LEVEL4,  // 埃
	0x57C6, KANJI_LEVEL4,  // 埆
	0x57D4, KANJI_LEVEL4,  // 埔
	0x57D2, KANJI_LEVEL4,  // 埒
	0x57D3, KANJI_LEVEL4,  // 埓
	0x580A, KANJI_LEVEL4,  // 堊
	0x57D6, KANJI_LEVEL4,  // 埖
	0x57E3, KANJI_LEVEL4,  // 埣
	0x580B, KANJI_LEVEL4,  // 堋
	0x5819, KANJI_LEVEL4,  // 堙
	0x581D, KANJI_LEVEL4,  // 堝
	0x5872, KANJI_LEVEL4,  // 塲
	0x5821, KANJI_LEVEL4,  // 堡
	0x5862, KANJI_LEVEL4,  // 塢
	0x584B, KANJI_LEVEL4,  // 塋
	0x5870, KANJI_LEVEL4,  // 塰
	0x6BC0, KANJI_LEVEL4,  // 毀
	0x5852, KANJI_LEVEL4,  // 塒
	0x583D, KANJI_LEVEL4,  // 堽
	0x5879, KANJI_LEVEL4,  // 塹
	0x5885, KANJI_LEVEL4,  // 墅
	0x58B9, KANJI_LEVEL4,  // 墹
	0x589F, KANJI_LEVEL4,  // 墟
	0x58AB, KANJI_LEVEL4,  // 墫
	0x58BA, KANJI_LEVEL4,  // 墺
	0x58DE, KANJI_LEVEL4,  // 壞
	0x58BB, KANJI_LEVEL4,  // 墻
	0x58B8, KANJI_LEVEL4,  // 墸
	0x58AE, KANJI_LEVEL4,  // 墮
	0x58C5, KANJI_LEVEL4,  // 壅
	0x58D3, KANJI_LEVEL4,  // 壓
	0x58D1, KANJI_LEVEL4,  // 壑
	0x58D7, KANJI_LEVEL4,  // 壗
	0x58D9, KANJI_LEVEL4,  // 壙
	0x58D8, KANJI_LEVEL4,  // 壘
	0x58E5, KANJI_LEVEL4,  // 壥
	0x58DC, KANJI_LEVEL4,  // 壜
	0x58E4, KANJI_LEVEL4,  // 壤
	0x58DF, KANJI_LEVEL4,  // 壟
	0x58EF, KANJI_LEVEL4,  // 壯
	0x58FA, KANJI_LEVEL4,  // 壺
	0x58F9, KANJI_LEVEL4,  // 壹
	0x58FB, KANJI_LEVEL4,  // 壻
	0x58FC, KANJI_LEVEL4,  // 壼
	0x58FD, KANJI_LEVEL4,  // 壽
	0x5902, KANJI_LEVEL4,  // 夂
	0x590A, KANJI_LEVEL4,  // 夊
	0x5910, KANJI_LEVEL4,  // 夐
	0x591B, KANJI_LEVEL4,  // 夛
	0x68A6, KANJI_LEVEL4,  // 梦
	0x5925, KANJI_LEVEL4,  // 夥
	0x592C, KANJI_LEVEL4,  // 夬
	0x592D, KANJI_LEVEL4,  // 夭
	0x5932, KANJI_LEVEL4,  // 夲
	0x5938, KANJI_LEVEL4,  // 夸
	0x593E, KANJI_LEVEL4,  // 夾
	0x7AD2, KANJI_LEVEL4,  // 竒
	0x5955, KANJI_LEVEL4,  // 奕
	0x5950, KANJI_LEVEL4,  // 奐
	0x594E, KANJI_LEVEL4,  // 奎
	0x595A, KANJI_LEVEL4,  // 奚
	0x5958, KANJI_LEVEL4,  // 奘
	0x5962, KANJI_LEVEL4,  // 奢
	0x5960, KANJI_LEVEL4,  // 奠
	0x5967, KANJI_LEVEL4,  // 奧
	0x596C, KANJI_LEVEL4,  // 奬
	0x5969, KANJI_LEVEL4,  // 奩
	0x5978, KANJI_LEVEL4,  // 奸
	0x5981, KANJI_LEVEL4,  // 妁
	0x599D, KANJI_LEVEL4,  // 妝
	0x4F5E, KANJI_LEVEL4,  // 佞
	0x4FAB, KANJI_LEVEL4,  // 侫
	0x59A3, KANJI_LEVEL4,  // 妣
	0x59B2, KANJI_LEVEL4,  // 妲
	0x59C6, KANJI_LEVEL4,  // 姆
	0x59E8, KANJI_LEVEL4,  // 姨
	0x59DC, KANJI_LEVEL4,  // 姜
	0x598D, KANJI_LEVEL4,  // 妍
	0x59D9, KANJI_LEVEL4,  // 姙
	0x59DA, KANJI_LEVEL4,  // 姚
	0x5A25, KANJI_LEVEL4,  // 娥
	0x5A1F, KANJI_LEVEL4,  // 娟
	0x5A11, KANJI_LEVEL4,  // 娑
	0x5A1C, KANJI_LEVEL4,  // 娜
	0x5A09, KANJI_LEVEL4,  // 娉
	0x5A1A, KANJI_LEVEL4,  // 娚
	0x5A40, KANJI_LEVEL4,  // 婀
	0x5A6C, KANJI_LEVEL4,  // 婬
	0x5A49, KANJI_LEVEL4,  // 婉
	0x5A35, KANJI_LEVEL4,  // 娵
	0x5A36, KANJI_LEVEL4,  // 娶
	0x5A62, KANJI_LEVEL4,  // 婢
	0x5A6A, KANJI_LEVEL4,  // 婪
	0x5A9A, KANJI_LEVEL4,  // 媚
	0x5ABC, KANJI_LEVEL4,  // 媼
	0x5ABE, KANJI_LEVEL4,  // 媾
	0x5ACB, KANJI_LEVEL4,  // 嫋
	0x5AC2, KANJI_LEVEL4,  // 嫂
	0x5ABD, KANJI_LEVEL4,  // 媽
	0x5AE3, KANJI_LEVEL4,  // 嫣
	0x5AD7, KANJI_LEVEL4,  // 嫗
	0x5AE6, KANJI_LEVEL4,  // 嫦
	0x5AE9, KANJI_LEVEL4,  // 嫩
	0x5AD6, KANJI_LEVEL4,  // 嫖
	0x5AFA, KANJI_LEVEL4,  // 嫺
	0x5AFB, KANJI_LEVEL4,  // 嫻
	0x5B0C, KANJI_LEVEL4,  // 嬌
	0x5B0B, KANJI_LEVEL4,  // 嬋
	0x5B16, KANJI_LEVEL4,  // 嬖
	0x5B32, KANJI_LEVEL4,  // 嬲
	0x5AD0, KANJI_LEVEL4,  // 嫐
	0x5B2A, KANJI_LEVEL4,  // 嬪
	0x5B36, KANJI_LEVEL4,  // 嬶
	0x5B3E, KANJI_LEVEL4,  // 嬾
	0x5B43, KANJI_LEVEL4,  // 孃
	0x5B45, KANJI_LEVEL4,  // 孅
	0x5B40, KANJI_LEVEL4,  // 孀
	0x5B51, KANJI_LEVEL4,  // 孑
	0x5B55, KANJI_LEVEL4,  // 孕
	0x5B5A, KANJI_LEVEL4,  // 孚
	0x5B5B, KANJI_LEVEL4,  // 孛
	0x5B65, KANJI_LEVEL4,  // 孥
	0x5B69, KANJI_LEVEL4,  // 孩
	0x5B70, KANJI_LEVEL4,  // 孰
	0x5B73, KANJI_LEVEL4,  // 孳
	0x5B75, KANJI_LEVEL4,  // 孵
	0x5B78, KANJI_LEVEL4,  // 學
	0x6588, KANJI_LEVEL4,  // 斈
	0x5B7A, KANJI_LEVEL4,  // 孺
	0x5B80, KANJI_LEVEL4,  // 宀
	0x5B83, KANJI_LEVEL4,  // 它
	0x5BA6, KANJI_LEVEL4,  // 宦
	0x5BB8, KANJI_LEVEL4,  // 宸
	0x5BC3, KANJI_LEVEL4,  // 寃
	0x5BC7, KANJI_LEVEL4,  // 寇
	0x5BC9, KANJI_LEVEL4,  // 寉
	0x5BD4, KANJI_LEVEL4,  // 寔
	0x5BD0, KANJI_LEVEL4,  // 寐
	0x5BE4, KANJI_LEVEL4,  // 寤
	0x5BE6, KANJI_LEVEL4,  // 實
	0x5BE2, KANJI_LEVEL4,  // 寢
	0x5BDE, KANJI_LEVEL4,  // 寞
	0x5BE5, KANJI_LEVEL4,  // 寥
	0x5BEB, KANJI_LEVEL4,  // 寫
	0x5BF0, KANJI_LEVEL4,  // 寰
	0x5BF6, KANJI_LEVEL4,  // 寶
	0x5BF3, KANJI_LEVEL4,  // 寳
	0x5C05, KANJI_LEVEL4,  // 尅
	0x5C07, KANJI_LEVEL4,  // 將
	0x5C08, KANJI_LEVEL4,  // 專
	0x5C0D, KANJI_LEVEL4,  // 對
	0x5C13, KANJI_LEVEL4,  // 尓
	0x5C20, KANJI_LEVEL4,  // 尠
	0x5C22, KANJI_LEVEL4,  // 尢
	0x5C28, KANJI_LEVEL4,  // 尨
	0x5C38, KANJI_LEVEL4,  // 尸
	0x5C39, KANJI_LEVEL4,  // 尹
	0x5C41, KANJI_LEVEL4,  // 屁
	0x5C46, KANJI_LEVEL4,  // 屆
	0x5C4E, KANJI_LEVEL4,  // 屎
	0x5C53, KANJI_LEVEL4,  // 屓
	0x5C50, KANJI_LEVEL4,  // 屐
	0x5C4F, KANJI_LEVEL4,  // 屏
	0x5B71, KANJI_LEVEL4,  // 孱
	0x5C6C, KANJI_LEVEL4,  // 屬
	0x5C6E, KANJI_LEVEL4,  // 屮
	0x4E62, KANJI_LEVEL4,  // 乢
	0x5C76, KANJI_LEVEL4,  // 屶
	0x5C79, KANJI_LEVEL4,  // 屹
	0x5C8C, KANJI_LEVEL4,  // 岌
	0x5C91, KANJI_LEVEL4,  // 岑
	0x5C94, KANJI_LEVEL4,  // 岔
	0x599B, KANJI_LEVEL4,  // 妛
	0x5CAB, KANJI_LEVEL4,  // 岫
	0x5CBB, KANJI_LEVEL4,  // 岻
	0x5CB6, KANJI_LEVEL4,  // 岶
	0x5CBC, KANJI_LEVEL4,  // 岼
	0x5CB7, KANJI_LEVEL4,  // 岷
	0x5CC5, KANJI_LEVEL4,  // 峅
	0x5CBE, KANJI_LEVEL4,  // 岾
	0x5CC7, KANJI_LEVEL4,  // 峇
	0x5CD9, KANJI_LEVEL4,  // 峙
	0x5CE9, KANJI_LEVEL4,  // 峩
	0x5CFD, KANJI_LEVEL4,  // 峽
	0x5CFA, KANJI_LEVEL4,  // 峺
	0x5CED, KANJI_LEVEL4,  // 峭
	0x5D8C, KANJI_LEVEL4,  // 嶌
	0x5CEA, KANJI_LEVEL4,  // 峪
	0x5D0B, KANJI_LEVEL4,  // 崋
	0x5D15, KANJI_LEVEL4,  // 崕
	0x5D17, KANJI_LEVEL4,  // 崗
	0x5D5C, KANJI_LEVEL4,  // 嵜
	0x5D1F, KANJI_LEVEL4,  // 崟
	0x5D1B, KANJI_LEVEL4,  // 崛
	0x5D11, KANJI_LEVEL4,  // 崑
	0x5D14, KANJI_LEVEL4,  // 崔
	0x5D22, KANJI_LEVEL4,  // 崢
	0x5D1A, KANJI_LEVEL4,  // 崚
	0x5D19, KANJI_LEVEL4,  // 崙
	0x5D18, KANJI_LEVEL4,  // 崘
	0x5D4C, KANJI_LEVEL4,  // 嵌
	0x5D52, KANJI_LEVEL4,  // 嵒
	0x5D4E, KANJI_LEVEL4,  // 嵎
	0x5D4B, KANJI_LEVEL4,  // 嵋
	0x5D6C, KANJI_LEVEL4,  // 嵬
	0x5D73, KANJI_LEVEL4,  // 嵳
	0x5D76, KANJI_LEVEL4,  // 嵶
	0x5D87, KANJI_LEVEL4,  // 嶇
	0x5D84, KANJI_LEVEL4,  // 嶄
	0x5D82, KANJI_LEVEL4,  // 嶂
	0x5DA2, KANJI_LEVEL4,  // 嶢
	0x5D9D, KANJI_LEVEL4,  // 嶝
	0x5DAC, KANJI_LEVEL4,  // 嶬
	0x5DAE, KANJI_LEVEL4,  // 嶮
	0x5DBD, KANJI_LEVEL4,  // 嶽
	0x5D90, KANJI_LEVEL4,  // 嶐
	0x5DB7, KANJI_LEVEL4,  // 嶷
	0x5DBC, KANJI_LEVEL4,  // 嶼
	0x5DC9, KANJI_LEVEL4,  // 巉
	0x5DCD, KANJI_LEVEL4,  // 巍
	0x5DD3, KANJI_LEVEL4,  // 巓
	0x5DD2, KANJI_LEVEL4,  // 巒
	0x5DD6, KANJI_LEVEL4,  // 巖
	0x5DDB, KANJI_LEVEL4,  // 巛
	0x5DEB, KANJI_LEVEL4,  // 巫
	0x5DF2, KANJI_LEVEL4,  // 已
	0x5DF5, KANJI_LEVEL4,  // 巵
	0x5E0B, KANJI_LEVEL4,  // 帋
	0x5E1A, KANJI_LEVEL4,  // 帚
	0x5E19, KANJI_LEVEL4,  // 帙
	0x5E11, KANJI_LEVEL4,  // 帑
	0x5E1B, KANJI_LEVEL4,  // 帛
	0x5E36, KANJI_LEVEL4,  // 帶
	0x5E37, KANJI_LEVEL4,  // 帷
	0x5E44, KANJI_LEVEL4,  // 幄
	0x5E43, KANJI_LEVEL4,  // 幃
	0x5E40, KANJI_LEVEL4,  // 幀
	0x5E4E, KANJI_LEVEL4,  // 幎
	0x5E57, KANJI_LEVEL4,  // 幗
	0x5E54, KANJI_LEVEL4,  // 幔
	0x5E5F, KANJI_LEVEL4,  // 幟
	0x5E62, KANJI_LEVEL4,  // 幢
	0x5E64, KANJI_LEVEL4,  // 幤
	0x5E47, KANJI_LEVEL4,  // 幇
	0x5E75, KANJI_LEVEL4,  // 幵
	0x5E76, KANJI_LEVEL4,  // 并
	0x5E7A, KANJI_LEVEL4,  // 幺
	0x9EBC, KANJI_LEVEL4,  // 麼
	0x5E7F, KANJI_LEVEL4,  // 广
	0x5EA0, KANJI_LEVEL4,  // 庠
	0x5EC1, KANJI_LEVEL4,  // 廁
	0x5EC2, KANJI_LEVEL4,  // 廂
	0x5EC8, KANJI_LEVEL4,  // 廈
	0x5ED0, KANJI_LEVEL4,  // 廐
	0x5ECF, KANJI_LEVEL4,  // 廏
	0x5ED6, KANJI_LEVEL4,  // 廖
	0x5EE3, KANJI_LEVEL4,  // 廣
	0x5EDD, KANJI_LEVEL4,  // 廝
	0x5EDA, KANJI_LEVEL4,  // 廚
	0x5EDB, KANJI_LEVEL4,  // 廛
	0x5EE2, KANJI_LEVEL4,  // 廢
	0x5EE1, KANJI_LEVEL4,  // 廡
	0x5EE8, KANJI_LEVEL4,  // 廨
	0x5EE9, KANJI_LEVEL4,  // 廩
	0x5EEC, KANJI_LEVEL4,  // 廬
	0x5EF1, KANJI_LEVEL4,  // 廱
	0x5EF3, KANJI_LEVEL4,  // 廳
	0x5EF0, KANJI_LEVEL4,  // 廰
	0x5EF4, KANJI_LEVEL4,  // 廴
	0x5EF8, KANJI_LEVEL4,  // 廸
	0x5EFE, KANJI_LEVEL4,  // 廾
	0x5F03, KANJI_LEVEL4,  // 弃
	0x5F09, KANJI_LEVEL4,  // 弉
	0x5F5D, KANJI_LEVEL4,  // 彝
	0x5F5C, KANJI_LEVEL4,  // 彜
	0x5F0B, KANJI_LEVEL4,  // 弋
	0x5F11, KANJI_LEVEL4,  // 弑
	0x5F16, KANJI_LEVEL4,  // 弖
	0x5F29, KANJI_LEVEL4,  // 弩
	0x5F2D, KANJI_LEVEL4,  // 弭
	0x5F38, KANJI_LEVEL4,  // 弸
	0x5F41, KANJI_LEVEL4,  // 彁
	0x5F48, KANJI_LEVEL4,  // 彈
	0x5F4C, KANJI_LEVEL4,  // 彌
	0x5F4E, KANJI_LEVEL4,  // 彎
	0x5F2F, KANJI_LEVEL4,  // 弯
	0x5F51, KANJI_LEVEL4,  // 彑
	0x5F56, KANJI_LEVEL4,  // 彖
	0x5F57, KANJI_LEVEL4,  // 彗
	0x5F59, KANJI_LEVEL4,  // 彙
	0x5F61, KANJI_LEVEL4,  // 彡
	0x5F6D, KANJI_LEVEL4,  // 彭
	0x5F73, KANJI_LEVEL4,  // 彳
	0x5F77, KANJI_LEVEL4,  // 彷
	0x5F83, KANJI_LEVEL4,  // 徃
	0x5F82, KANJI_LEVEL4,  // 徂
	0x5F7F, KANJI_LEVEL4,  // 彿
	0x5F8A, KANJI_LEVEL4,  // 徊
	0x5F88, KANJI_LEVEL4,  // 很
	0x5F91, KANJI_LEVEL4,  // 徑
	0x5F87, KANJI_LEVEL4,  // 徇
	0x5F9E, KANJI_LEVEL4,  // 從
	0x5F99, KANJI_LEVEL4,  // 徙
	0x5F98, KANJI_LEVEL4,  // 徘
	0x5FA0, KANJI_LEVEL4,  // 徠
	0x5FA8, KANJI_LEVEL4,  // 徨
	0x5FAD, KANJI_LEVEL4,  // 徭
	0x5FBC, KANJI_LEVEL4,  // 徼
	0x5FD6, KANJI_LEVEL4,  // 忖
	0x5FFB, KANJI_LEVEL4,  // 忻
	0x5FE4, KANJI_LEVEL4,  // 忤
	0x5FF8, KANJI_LEVEL4,  // 忸
	0x5FF1, KANJI_LEVEL4,  // 忱
	0x5FDD, KANJI_LEVEL4,  // 忝
	0x60B3, KANJI_LEVEL4,  // 悳
	0x5FFF, KANJI_LEVEL4,  // 忿
	0x6021, KANJI_LEVEL4,  // 怡
	0x6060, KANJI_LEVEL4,  // 恠
	0x6019, KANJI_LEVEL4,  // 怙
	0x6010, KANJI_LEVEL4,  // 怐
	0x6029, KANJI_LEVEL4,  // 怩
	0x600E, KANJI_LEVEL4,  // 怎
	0x6031, KANJI_LEVEL4,  // 怱
	0x601B, KANJI_LEVEL4,  // 怛
	0x6015, KANJI_LEVEL4,  // 怕
	0x602B, KANJI_LEVEL4,  // 怫
	0x6026, KANJI_LEVEL4,  // 怦
	0x600F, KANJI_LEVEL4,  // 怏
	0x603A, KANJI_LEVEL4,  // 怺
	0x605A, KANJI_LEVEL4,  // 恚
	0x6041, KANJI_LEVEL4,  // 恁
	0x606A, KANJI_LEVEL4,  // 恪
	0x6077, KANJI_LEVEL4,  // 恷
	0x605F, KANJI_LEVEL4,  // 恟
	0x604A, KANJI_LEVEL4,  // 恊
	0x6046, KANJI_LEVEL4,  // 恆
	0x604D, KANJI_LEVEL4,  // 恍
	0x6063, KANJI_LEVEL4,  // 恣
	0x6043, KANJI_LEVEL4,  // 恃
	0x6064, KANJI_LEVEL4,  // 恤
	0x6042, KANJI_LEVEL4,  // 恂
	0x606C, KANJI_LEVEL4,  // 恬
	0x606B, KANJI_LEVEL4,  // 恫
	0x6059, KANJI_LEVEL4,  // 恙
	0x6081, KANJI_LEVEL4,  // 悁
	0x608D, KANJI_LEVEL4,  // 悍
	0x60E7, KANJI_LEVEL4,  // 惧
	0x6083, KANJI_LEVEL4,  // 悃
	0x609A, KANJI_LEVEL4,  // 悚
	0x6084, KANJI_LEVEL4,  // 悄
	0x609B, KANJI_LEVEL4,  // 悛
	0x6096, KANJI_LEVEL4,  // 悖
	0x6097, KANJI_LEVEL4,  // 悗
	0x6092, KANJI_LEVEL4,  // 悒
	0x60A7, KANJI_LEVEL4,  // 悧
	0x608B, KANJI_LEVEL4,  // 悋
	0x60E1, KANJI_LEVEL4,  // 惡
	0x60B8, KANJI_LEVEL4,  // 悸
	0x60E0, KANJI_LEVEL4,  // 惠
	0x60D3, KANJI_LEVEL4,  // 惓
	0x60B4, KANJI_LEVEL4,  // 悴
	0x5FF0, KANJI_LEVEL4,  // 忰
	0x60BD, KANJI_LEVEL4,  // 悽
	0x60C6, KANJI_LEVEL4,  // 惆
	0x60B5, KANJI_LEVEL4,  // 悵
	0x60D8, KANJI_LEVEL4,  // 惘
	0x614D, KANJI_LEVEL4,  // 慍
	0x6115, KANJI_LEVEL4,  // 愕
	0x6106, KANJI_LEVEL4,  // 愆
	0x60F6, KANJI_LEVEL4,  // 惶
	0x60F7, KANJI_LEVEL4,  // 惷
	0x6100, KANJI_LEVEL4,  // 愀
	0x60F4, KANJI_LEVEL4,  // 惴
	0x60FA, KANJI_LEVEL4,  // 惺
	0x6103, KANJI_LEVEL4,  // 愃
	0x6121, KANJI_LEVEL4,  // 愡
	0x60FB, KANJI_LEVEL4,  // 惻
	0x60F1, KANJI_LEVEL4,  // 惱
	0x610D, KANJI_LEVEL4,  // 愍
	0x610E, KANJI_LEVEL4,  // 愎
	0x6147, KANJI_LEVEL4,  // 慇
	0x613E, KANJI_LEVEL4,  // 愾
	0x6128, KANJI_LEVEL4,  // 愨
	0x6127, KANJI_LEVEL4,  // 愧
	0x614A, KANJI_LEVEL4,  // 慊
	0x613F, KANJI_LEVEL4,  // 愿
	0x613C, KANJI_LEVEL4,  // 愼
	0x612C, KANJI_LEVEL4,  // 愬
	0x6134, KANJI_LEVEL4,  // 愴
	0x613D, KANJI_LEVEL4,  // 愽
	0x6142, KANJI_LEVEL4,  // 慂
	0x6144, KANJI_LEVEL4,  // 慄
	0x6173, KANJI_LEVEL4,  // 慳
	0x6177, KANJI_LEVEL4,  // 慷
	0x6158, KANJI_LEVEL4,  // 慘
	0x6159, KANJI_LEVEL4,  // 慙
	0x615A, KANJI_LEVEL4,  // 慚
	0x616B, KANJI_LEVEL4,  // 慫
	0x6174, KANJI_LEVEL4,  // 慴
	0x616F, KANJI_LEVEL4,  // 慯
	0x6165, KANJI_LEVEL4,  // 慥
	0x6171, KANJI_LEVEL4,  // 慱
	0x615F, KANJI_LEVEL4,  // 慟
	0x615D, KANJI_LEVEL4,  // 慝
	0x6153, KANJI_LEVEL4,  // 慓
	0x6175, KANJI_LEVEL4,  // 慵
	0x6199, KANJI_LEVEL4,  // 憙
	0x6196, KANJI_LEVEL4,  // 憖
	0x6187, KANJI_LEVEL4,  // 憇
	0x61AC, KANJI_LEVEL4,  // 憬
	0x6194, KANJI_LEVEL4,  // 憔
	0x619A, KANJI_LEVEL4,  // 憚
	0x618A, KANJI_LEVEL4,  // 憊
	0x6191, KANJI_LEVEL4,  // 憑
	0x61AB, KANJI_LEVEL4,  // 憫
	0x61AE, KANJI_LEVEL4,  // 憮
	0x61CC, KANJI_LEVEL4,  // 懌
	0x61CA, KANJI_LEVEL4,  // 懊
	0x61C9, KANJI_LEVEL4,  // 應
	0x61F7, KANJI_LEVEL4,  // 懷
	0x61C8, KANJI_LEVEL4,  // 懈
	0x61C3, KANJI_LEVEL4,  // 懃
	0x61C6, KANJI_LEVEL4,  // 懆
	0x61BA, KANJI_LEVEL4,  // 憺
	0x61CB, KANJI_LEVEL4,  // 懋
	0x7F79, KANJI_LEVEL4,  // 罹
	0x61CD, KANJI_LEVEL4,  // 懍
	0x61E6, KANJI_LEVEL4,  // 懦
	0x61E3, KANJI_LEVEL4,  // 懣
	0x61F6, KANJI_LEVEL4,  // 懶
	0x61FA, KANJI_LEVEL4,  // 懺
	0x61F4, KANJI_LEVEL4,  // 懴
	0x61FF, KANJI_LEVEL4,  // 懿
	0x61FD, KANJI_LEVEL4,  // 懽
	0x61FC, KANJI_LEVEL4,  // 懼
	0x61FE, KANJI_LEVEL4,  // 懾
	0x6200, KANJI_LEVEL4,  // 戀
	0x6208, KANJI_LEVEL4,  // 戈
	0x6209, KANJI_LEVEL4,  // 戉
	0x620D, KANJI_LEVEL4,  // 戍
	0x620C, KANJI_LEVEL4,  // 戌
	0x6214, KANJI_LEVEL4,  // 戔
	0x621B, KANJI_LEVEL4,  // 戛
	0x621E, KANJI_LEVEL4,  // 戞
	0x6221, KANJI_LEVEL4,  // 戡
	0x622A, KANJI_LEVEL4,  // 截
	0x622E, KANJI_LEVEL4,  // 戮
	0x6230, KANJI_LEVEL4,  // 戰
	0x6232, KANJI_LEVEL4,  // 戲
	0x6233, KANJI_LEVEL4,  // 戳
	0x6241, KANJI_LEVEL4,  // 扁
	0x624E, KANJI_LEVEL4,  // 扎
	0x625E, KANJI_LEVEL4,  // 扞
	0x6263, KANJI_LEVEL4,  // 扣
	0x625B, KANJI_LEVEL4,  // 扛
	0x6260, KANJI_LEVEL4,  // 扠
	0x6268, KANJI_LEVEL4,  // 扨
	0x627C, KANJI_LEVEL4,  // 扼
	0x6282, KANJI_LEVEL4,  // 抂
	0x6289, KANJI_LEVEL4,  // 抉
	0x627E, KANJI_LEVEL4,  // 找
	0x6292, KANJI_LEVEL4,  // 抒
	0x6293, KANJI_LEVEL4,  // 抓
	0x6296, KANJI_LEVEL4,  // 抖
	0x62D4, KANJI_LEVEL4,  // 拔
	0x6283, KANJI_LEVEL4,  // 抃
	0x6294, KANJI_LEVEL4,  // 抔
	0x62D7, KANJI_LEVEL4,  // 拗
	0x62D1, KANJI_LEVEL4,  // 拑
	0x62BB, KANJI_LEVEL4,  // 抻
	0x62CF, KANJI_LEVEL4,  // 拏
	0x62FF, KANJI_LEVEL4,  // 拿
	0x62C6, KANJI_LEVEL4,  // 拆
	0x64D4, KANJI_LEVEL4,  // 擔
	0x62C8, KANJI_LEVEL4,  // 拈
	0x62DC, KANJI_LEVEL4,  // 拜
	0x62CC, KANJI_LEVEL4,  // 拌
	0x62CA, KANJI_LEVEL4,  // 拊
	0x62C2, KANJI_LEVEL4,  // 拂
	0x62C7, KANJI_LEVEL4,  // 拇
	0x629B, KANJI_LEVEL4,  // 抛
	0x62C9, KANJI_LEVEL4,  // 拉
	0x630C, KANJI_LEVEL4,  // 挌
	0x62EE, KANJI_LEVEL4,  // 拮
	0x62F1, KANJI_LEVEL4,  // 拱
	0x6327, KANJI_LEVEL4,  // 挧
	0x6302, KANJI_LEVEL4,  // 挂
	0x6308, KANJI_LEVEL4,  // 挈
	0x62EF, KANJI_LEVEL4,  // 拯
	0x62F5, KANJI_LEVEL4,  // 拵
	0x6350, KANJI_LEVEL4,  // 捐
	0x633E, KANJI_LEVEL4,  // 挾
	0x634D, KANJI_LEVEL4,  // 捍
	0x641C, KANJI_LEVEL4,  // 搜
	0x634F, KANJI_LEVEL4,  // 捏
	0x6396, KANJI_LEVEL4,  // 掖
	0x638E, KANJI_LEVEL4,  // 掎
	0x6380, KANJI_LEVEL4,  // 掀
	0x63AB, KANJI_LEVEL4,  // 掫
	0x6376, KANJI_LEVEL4,  // 捶
	0x63A3, KANJI_LEVEL4,  // 掣
	0x638F, KANJI_LEVEL4,  // 掏
	0x6389, KANJI_LEVEL4,  // 掉
	0x639F, KANJI_LEVEL4,  // 掟
	0x63B5, KANJI_LEVEL4,  // 掵
	0x636B, KANJI_LEVEL4,  // 捫
	0x6369, KANJI_LEVEL4,  // 捩
	0x63BE, KANJI_LEVEL4,  // 掾
	0x63E9, KANJI_LEVEL4,  // 揩
	0x63C0, KANJI_LEVEL4,  // 揀
	0x63C6, KANJI_LEVEL4,  // 揆
	0x63E3, KANJI_LEVEL4,  // 揣
	0x63C9, KANJI_LEVEL4,  // 揉
	0x63D2, KANJI_LEVEL4,  // 插
	0x63F6, KANJI_LEVEL4,  // 揶
	0x63C4, KANJI_LEVEL4,  // 揄
	0x6416, KANJI_LEVEL4,  // 搖
	0x6434, KANJI_LEVEL4,  // 搴
	0x6406, KANJI_LEVEL4,  // 搆
	0x6413, KANJI_LEVEL4,  // 搓
	0x6426, KANJI_LEVEL4,  // 搦
	0x6436, KANJI_LEVEL4,  // 搶
	0x651D, KANJI_LEVEL4,  // 攝
	0x6417, KANJI_LEVEL4,  // 搗
	0x6428, KANJI_LEVEL4,  // 搨
	0x640F, KANJI_LEVEL4,  // 搏
	0x6467, KANJI_LEVEL4,  // 摧
	0x646F, KANJI_LEVEL4,  // 摯
	0x6476, KANJI_LEVEL4,  // 摶
	0x644E, KANJI_LEVEL4,  // 摎
	0x652A, KANJI_LEVEL4,  // 攪
	0x6495, KANJI_LEVEL4,  // 撕
	0x6493, KANJI_LEVEL4,  // 撓
	0x64A5, KANJI_LEVEL4,  // 撥
	0x64A9, KANJI_LEVEL4,  // 撩
	0x6488, KANJI_LEVEL4,  // 撈
	0x64BC, KANJI_LEVEL4,  // 撼
	0x64DA, KANJI_LEVEL4,  // 據
	0x64D2, KANJI_LEVEL4,  // 擒
	0x64C5, KANJI_LEVEL4,  // 擅
	0x64C7, KANJI_LEVEL4,  // 擇
	0x64BB, KANJI_LEVEL4,  // 撻
	0x64D8, KANJI_LEVEL4,  // 擘
	0x64C2, KANJI_LEVEL4,  // 擂
	0x64F1, KANJI_LEVEL4,  // 擱
	0x64E7, KANJI_LEVEL4,  // 擧
	0x8209, KANJI_LEVEL4,  // 舉
	0x64E0, KANJI_LEVEL4,  // 擠
	0x64E1, KANJI_LEVEL4,  // 擡
	0x62AC, KANJI_LEVEL4,  // 抬
	0x64E3, KANJI_LEVEL4,  // 擣
	0x64EF, KANJI_LEVEL4,  // 擯
	0x652C, KANJI_LEVEL4,  // 攬
	0x64F6, KANJI_LEVEL4,  // 擶
	0x64F4, KANJI_LEVEL4,  // 擴
	0x64F2, KANJI_LEVEL4,  // 擲
	0x64FA, KANJI_LEVEL4,  // 擺
	0x6500, KANJI_LEVEL4,  // 攀
	0x64FD, KANJI_LEVEL4,  // 擽
	0x6518, KANJI_LEVEL4,  // 攘
	0x651C, KANJI_LEVEL4,  // 攜
	0x6505, KANJI_LEVEL4,  // 攅
	0x6524, KANJI_LEVEL4,  // 攤
	0x6523, KANJI_LEVEL4,  // 攣
	0x652B, KANJI_LEVEL4,  // 攫
	0x6534, KANJI_LEVEL4,  // 攴
	0x6535, KANJI_LEVEL4,  // 攵
	0x6537, KANJI_LEVEL4,  // 攷
	0x6536, KANJI_LEVEL4,  // 收
	0x6538, KANJI_LEVEL4,  // 攸
	0x754B, KANJI_LEVEL4,  // 畋
	0x6548, KANJI_LEVEL4,  // 效
	0x6556, KANJI_LEVEL4,  // 敖
	0x6555, KANJI_LEVEL4,  // 敕
	0x654D, KANJI_LEVEL4,  // 敍
	0x6558, KANJI_LEVEL4,  // 敘
	0x655E, KANJI_LEVEL4,  // 敞
	0x655D, KANJI_LEVEL4,  // 敝
	0x6572, KANJI_LEVEL4,  // 敲
	0x6578, KANJI_LEVEL4,  // 數
	0x6582, KANJI_LEVEL4,  // 斂
	0x6583, KANJI_LEVEL4,  // 斃
	0x8B8A, KANJI_LEVEL4,  // 變
	0x659B, KANJI_LEVEL4,  // 斛
	0x659F, KANJI_LEVEL4,  // 斟
	0x65AB, KANJI_LEVEL4,  // 斫
	0x65B7, KANJI_LEVEL4,  // 斷
	0x65C3, KANJI_LEVEL4,  // 旃
	0x65C6, KANJI_LEVEL4,  // 旆
	0x65C1, KANJI_LEVEL4,  // 旁
	0x65C4, KANJI_LEVEL4,  // 旄
	0x65CC, KANJI_LEVEL4,  // 旌
	0x65D2, KANJI_LEVEL4,  // 旒
	0x65DB, KANJI_LEVEL4,  // 旛
	0x65D9, KANJI_LEVEL4,  // 旙
	0x65E0, KANJI_LEVEL4,  // 无
	0x65E1, KANJI_LEVEL4,  // 旡
	0x65F1, KANJI_LEVEL4,  // 旱
	0x6772, KANJI_LEVEL4,  // 杲
	0x660A, KANJI_LEVEL4,  // 昊
	0x6603, KANJI_LEVEL4,  // 昃
	0x65FB, KANJI_LEVEL4,  // 旻
	0x6773, KANJI_LEVEL4,  // 杳
	0x6635, KANJI_LEVEL4,  // 昵
	0x6636, KANJI_LEVEL4,  // 昶
	0x6634, KANJI_LEVEL4,  // 昴
	0x661C, KANJI_LEVEL4,  // 昜
	0x664F, KANJI_LEVEL4,  // 晏
	0x6644, KANJI_LEVEL4,  // 晄
	0x6649, KANJI_LEVEL4,  // 晉
	0x6641, KANJI_LEVEL4,  // 晁
	0x665E, KANJI_LEVEL4,  // 晞
	0x665D, KANJI_LEVEL4,  // 晝
	0x6664, KANJI_LEVEL4,  // 晤
	0x6667, KANJI_LEVEL4,  // 晧
	0x6668, KANJI_LEVEL4,  // 晨
	0x665F, KANJI_LEVEL4,  // 晟
	0x6662, KANJI_LEVEL4,  // 晢
	0x6670, KANJI_LEVEL4,  // 晰
	0x6683, KANJI_LEVEL4,  // 暃
	0x6688, KANJI_LEVEL4,  // 暈
	0x668E, KANJI_LEVEL4,  // 暎
	0x6689, KANJI_LEVEL4,  // 暉
	0x6684, KANJI_LEVEL4,  // 暄
	0x6698, KANJI_LEVEL4,  // 暘
	0x669D, KANJI_LEVEL4,  // 暝
	0x66C1, KANJI_LEVEL4,  // 曁
	0x66B9, KANJI_LEVEL4,  // 暹
	0x66C9, KANJI_LEVEL4,  // 曉
	0x66BE, KANJI_LEVEL4,  // 暾
	0x66BC, KANJI_LEVEL4,  // 暼
	0x66C4, KANJI_LEVEL4,  // 曄
	0x66B8, KANJI_LEVEL4,  // 暸
	0x66D6, KANJI_LEVEL4,  // 曖
	0x66DA, KANJI_LEVEL4,  // 曚
	0x66E0, KANJI_LEVEL4,  // 曠
	0x663F, KANJI_LEVEL4,  // 昿
	0x66E6, KANJI_LEVEL4,  // 曦
	0x66E9, KANJI_LEVEL4,  // 曩
	0x66F0, KANJI_LEVEL4,  // 曰
	0x66F5, KANJI_LEVEL4,  // 曵
	0x66F7, KANJI_LEVEL4,  // 曷
	0x670F, KANJI_LEVEL4,  // 朏
	0x6716, KANJI_LEVEL4,  // 朖
	0x671E, KANJI_LEVEL4,  // 朞
	0x6726, KANJI_LEVEL4,  // 朦
	0x6727, KANJI_LEVEL4,  // 朧
	0x9738, KANJI_LEVEL4,  // 霸
	0x672E, KANJI_LEVEL4,  // 朮
	0x673F, KANJI_LEVEL4,  // 朿
	0x6736, KANJI_LEVEL4,  // 朶
	0x6741, KANJI_LEVEL4,  // 杁
	0x6738, KANJI_LEVEL4,  // 朸
	0x6737, KANJI_LEVEL4,  // 朷
	0x6746, KANJI_LEVEL4,  // 杆
	0x675E, KANJI_LEVEL4,  // 杞
	0x6760, KANJI_LEVEL4,  // 杠
	0x6759, KANJI_LEVEL4,  // 杙
	0x6763, KANJI_LEVEL4,  // 杣
	0x6764, KANJI_LEVEL4,  // 杤
	0x6789, KANJI_LEVEL4,  // 枉
	0x6770, KANJI_LEVEL4,  // 杰
	0x67A9, KANJI_LEVEL4,  // 枩
	0x677C, KANJI_LEVEL4,  // 杼
	0x676A, KANJI_LEVEL4,  // 杪
	0x678C, KANJI_LEVEL4,  // 枌
	0x678B, KANJI_LEVEL4,  // 枋
	0x67A6, KANJI_LEVEL4,  // 枦
	0x67A1, KANJI_LEVEL4,  // 枡
	0x6785, KANJI_LEVEL4,  // 枅
	0x67B7, KANJI_LEVEL4,  // 枷
	0x67EF, KANJI_LEVEL4,  // 柯
	0x67B4, KANJI_LEVEL4,  // 枴
	0x67EC, KANJI_LEVEL4,  // 柬
	0x67B3, KANJI_LEVEL4,  // 枳
	0x67E9, KANJI_LEVEL4,  // 柩
	0x67B8, KANJI_LEVEL4,  // 枸
	0x67E4, KANJI_LEVEL4,  // 柤
	0x67DE, KANJI_LEVEL4,  // 柞
	0x67DD, KANJI_LEVEL4,  // 柝
	0x67E2, KANJI_LEVEL4,  // 柢
	0x67EE, KANJI_LEVEL4,  // 柮
	0x67B9, KANJI_LEVEL4,  // 枹
	0x67CE, KANJI_LEVEL4,  // 柎
	0x67C6, KANJI_LEVEL4,  // 柆
	0x67E7, KANJI_LEVEL4,  // 柧
	0x6A9C, KANJI_LEVEL4,  // 檜
	0x681E, KANJI_LEVEL4,  // 栞
	0x6846, KANJI_LEVEL4,  // 框
	0x6829, KANJI_LEVEL4,  // 栩
	0x6840, KANJI_LEVEL4,  // 桀
	0x684D, KANJI_LEVEL4,  // 桍
	0x6832, KANJI_LEVEL4,  // 栲
	0x684E, KANJI_LEVEL4,  // 桎
	0x68B3, KANJI_LEVEL4,  // 梳
	0x682B, KANJI_LEVEL4,  // 栫
	0x6859, KANJI_LEVEL4,  // 桙
	0x6863, KANJI_LEVEL4,  // 档
	0x6877, KANJI_LEVEL4,  // 桷
	0x687F, KANJI_LEVEL4,  // 桿
	0x689F, KANJI_LEVEL4,  // 梟
	0x688F, KANJI_LEVEL4,  // 梏
	0x68AD, KANJI_LEVEL4,  // 梭
	0x6894, KANJI_LEVEL4,  // 梔
	0x689D, KANJI_LEVEL4,  // 條
	0x689B, KANJI_LEVEL4,  // 梛
	0x6883, KANJI_LEVEL4,  // 梃
	0x6AAE, KANJI_LEVEL4,  // 檮
	0x68B9, KANJI_LEVEL4,  // 梹
	0x6874, KANJI_LEVEL4,  // 桴
	0x68B5, KANJI_LEVEL4,  // 梵
	0x68A0, KANJI_LEVEL4,  // 梠
	0x68BA, KANJI_LEVEL4,  // 梺
	0x690F, KANJI_LEVEL4,  // 椏
	0x688D, KANJI_LEVEL4,  // 梍
	0x687E, KANJI_LEVEL4,  // 桾
	0x6901, KANJI_LEVEL4,  // 椁
	0x68CA, KANJI_LEVEL4,  // 棊
	0x6908, KANJI_LEVEL4,  // 椈
	0x68D8, KANJI_LEVEL4,  // 棘
	0x6922, KANJI_LEVEL4,  // 椢
	0x6926, KANJI_LEVEL4,  // 椦
	0x68E1, KANJI_LEVEL4,  // 棡
	0x690C, KANJI_LEVEL4,  // 椌
	0x68CD, KANJI_LEVEL4,  // 棍
	0x68D4, KANJI_LEVEL4,  // 棔
	0x68E7, KANJI_LEVEL4,  // 棧
	0x68D5, KANJI_LEVEL4,  // 棕
	0x6936, KANJI_LEVEL4,  // 椶
	0x6912, KANJI_LEVEL4,  // 椒
	0x6904, KANJI_LEVEL4,  // 椄
	0x68D7, KANJI_LEVEL4,  // 棗
	0x68E3, KANJI_LEVEL4,  // 棣
	0x6925, KANJI_LEVEL4,  // 椥
	0x68F9, KANJI_LEVEL4,  // 棹
	0x68E0, KANJI_LEVEL4,  // 棠
	0x68EF, KANJI_LEVEL4,  // 棯
	0x6928, KANJI_LEVEL4,  // 椨
	0x692A, KANJI_LEVEL4,  // 椪
	0x691A, KANJI_LEVEL4,  // 椚
	0x6923, KANJI_LEVEL4,  // 椣
	0x6921, KANJI_LEVEL4,  // 椡
	0x68C6, KANJI_LEVEL4,  // 棆
	0x6979, KANJI_LEVEL4,  // 楹
	0x6977, KANJI_LEVEL4,  // 楷
	0x695C, KANJI_LEVEL4,  // 楜
	0x6978, KANJI_LEVEL4,  // 楸
	0x696B, KANJI_LEVEL4,  // 楫
	0x6954, KANJI_LEVEL4,  // 楔
	0x697E, KANJI_LEVEL4,  // 楾
	0x696E, KANJI_LEVEL4,  // 楮
	0x6939, KANJI_LEVEL4,  // 椹
	0x6974, KANJI_LEVEL4,  // 楴
	0x693D, KANJI_LEVEL4,  // 椽
	0x6959, KANJI_LEVEL4,  // 楙
	0x6930, KANJI_LEVEL4,  // 椰
	0x6961, KANJI_LEVEL4,  // 楡
	0x695E, KANJI_LEVEL4,  // 楞
	0x695D, KANJI_LEVEL4,  // 楝
	0x6981, KANJI_LEVEL4,  // 榁
	0x696A, KANJI_LEVEL4,  // 楪
	0x69B2, KANJI_LEVEL4,  // 榲
	0x69AE, KANJI_LEVEL4,  // 榮
	0x69D0, KANJI_LEVEL4,  // 槐
	0x69BF, KANJI_LEVEL4,  // 榿
	0x69C1, KANJI_LEVEL4,  // 槁
	0x69D3, KANJI_LEVEL4,  // 槓
	0x69BE, KANJI_LEVEL4,  // 榾
	0x69CE, KANJI_LEVEL4,  // 槎
	0x5BE8, KANJI_LEVEL4,  // 寨
	0x69CA, KANJI_LEVEL4,  // 槊
	0x69DD, KANJI_LEVEL4,  // 槝
	0x69BB, KANJI_LEVEL4,  // 榻
	0x69C3, KANJI_LEVEL4,  // 槃
	0x69A7, KANJI_LEVEL4,  // 榧
	0x6A2E, KANJI_LEVEL4,  // 樮
	0x6991, KANJI_LEVEL4,  // 榑
	0x69A0, KANJI_LEVEL4,  // 榠
	0x699C, KANJI_LEVEL4,  // 榜
	0x6995, KANJI_LEVEL4,  // 榕
	0x69B4, KANJI_LEVEL4,  // 榴
	0x69DE, KANJI_LEVEL4,  // 槞
	0x69E8, KANJI_LEVEL4,  // 槨
	0x6A02, KANJI_LEVEL4,  // 樂
	0x6A1B, KANJI_LEVEL4,  // 樛
	0x69FF, KANJI_LEVEL4,  // 槿
	0x6B0A, KANJI_LEVEL4,  // 權
	0x69F9, KANJI_LEVEL4,  // 槹
	0x69F2, KANJI_LEVEL4,  // 槲
	0x69E7, KANJI_LEVEL4,  // 槧
	0x6A05, KANJI_LEVEL4,  // 樅
	0x69B1, KANJI_LEVEL4,  // 榱
	0x6A1E, KANJI_LEVEL4,  // 樞
	0x69ED, KANJI_LEVEL4,  // 槭
	0x6A14, KANJI_LEVEL4,  // 樔
	0x69EB, KANJI_LEVEL4,  // 槫
	0x6A0A, KANJI_LEVEL4,  // 樊
	0x6A12, KANJI_LEVEL4,  // 樒
	0x6AC1, KANJI_LEVEL4,  // 櫁
	0x6A23, KANJI_LEVEL4,  // 樣
	0x6A13, KANJI_LEVEL4,  // 樓
	0x6A44, KANJI_LEVEL4,  // 橄
	0x6A0C, KANJI_LEVEL4,  // 樌
	0x6A72, KANJI_LEVEL4,  // 橲
	0x6A36, KANJI_LEVEL4,  // 樶
	0x6A78, KANJI_LEVEL4,  // 橸
	0x6A47, KANJI_LEVEL4,  // 橇
	0x6A62, KANJI_LEVEL4,  // 橢
	0x6A59, KANJI_LEVEL4,  // 橙
	0x6A66, KANJI_LEVEL4,  // 橦
	0x6A48, KANJI_LEVEL4,  // 橈
	0x6A38, KANJI_LEVEL4,  // 樸
	0x6A22, KANJI_LEVEL4,  // 樢
	0x6A90, KANJI_LEVEL4,  // 檐
	0x6A8D, KANJI_LEVEL4,  // 檍
	0x6AA0, KANJI_LEVEL4,  // 檠
	0x6A84, KANJI_LEVEL4,  // 檄
	0x6AA2, KANJI_LEVEL4,  // 檢
	0x6AA3, KANJI_LEVEL4,  // 檣
	0x6A97, KANJI_LEVEL4,  // 檗
	0x8617, KANJI_LEVEL4,  // 蘗
	0x6ABB, KANJI_LEVEL4,  // 檻
	0x6AC3, KANJI_LEVEL4,  // 櫃
	0x6AC2, KANJI_LEVEL4,  // 櫂
	0x6AB8, KANJI_LEVEL4,  // 檸
	0x6AB3, KANJI_LEVEL4,  // 檳
	0x6AAC, KANJI_LEVEL4,  // 檬
	0x6ADE, KANJI_LEVEL4,  // 櫞
	0x6AD1, KANJI_LEVEL4,  // 櫑
	0x6ADF, KANJI_LEVEL4,  // 櫟
	0x6AAA, KANJI_LEVEL4,  // 檪
	0x6ADA, KANJI_LEVEL4,  // 櫚
	0x6AEA, KANJI_LEVEL4,  // 櫪
	0x6AFB, KANJI_LEVEL4,  // 櫻
	0x6B05, KANJI_LEVEL4,  // 欅
	0x8616, KANJI_LEVEL4,  // 蘖
	0x6AFA, KANJI_LEVEL4,  // 櫺
	0x6B12, KANJI_LEVEL4,  // 欒
	0x6B16, KANJI_LEVEL4,  // 欖
	0x9B31, KANJI_LEVEL4,  // 鬱
	0x6B1F, KANJI_LEVEL4,  // 欟
	0x6B38, KANJI_LEVEL4,  // 欸
	0x6B37, KANJI_LEVEL4,  // 欷
	0x76DC, KANJI_LEVEL4,  // 盜
	0x6B39, KANJI_LEVEL4,  // 欹
	0x98EE, KANJI_LEVEL4,  // 飮
	0x6B47, KANJI_LEVEL4,  // 歇
	0x6B43, KANJI_LEVEL4,  // 歃
	0x6B49, KANJI_LEVEL4,  // 歉
	0x6B50, KANJI_LEVEL4,  // 歐
	0x6B59, KANJI_LEVEL4,  // 歙
	0x6B54, KANJI_LEVEL4,  // 歔
	0x6B5B, KANJI_LEVEL4,  // 歛
	0x6B5F, KANJI_LEVEL4,  // 歟
	0x6B61, KANJI_LEVEL4,  // 歡
	0x6B78, KANJI_LEVEL4,  // 歸
	0x6B79, KANJI_LEVEL4,  // 歹
	0x6B7F, KANJI_LEVEL4,  // 歿
	0x6B80, KANJI_LEVEL4,  // 殀
	0x6B84, KANJI_LEVEL4,  // 殄
	0x6B83, KANJI_LEVEL4,  // 殃
	0x6B8D, KANJI_LEVEL4,  // 殍
	0x6B98, KANJI_LEVEL4,  // 殘
	0x6B95, KANJI_LEVEL4,  // 殕
	0x6B9E, KANJI_LEVEL4,  // 殞
	0x6BA4, KANJI_LEVEL4,  // 殤
	0x6BAA, KANJI_LEVEL4,  // 殪
	0x6BAB, KANJI_LEVEL4,  // 殫
	0x6BAF, KANJI_LEVEL4,  // 殯
	0x6BB2, KANJI_LEVEL4,  // 殲
	0x6BB1, KANJI_LEVEL4,  // 殱
	0x6BB3, KANJI_LEVEL4,  // 殳
	0x6BB7, KANJI_LEVEL4,  // 殷
	0x6BBC, KANJI_LEVEL4,  // 殼
	0x6BC6, KANJI_LEVEL4,  // 毆
	0x6BCB, KANJI_LEVEL4,  // 毋
	0x6BD3, KANJI_LEVEL4,  // 毓
	0x6BDF, KANJI_LEVEL4,  // 毟
	0x6BEC, KANJI_LEVEL4,  // 毬
	0x6BEB, KANJI_LEVEL4,  // 毫
	0x6BF3, KANJI_LEVEL4,  // 毳
	0x6BEF, KANJI_LEVEL4,  // 毯
	0x9EBE, KANJI_LEVEL4,  // 麾
	0x6C08, KANJI_LEVEL4,  // 氈
	0x6C13, KANJI_LEVEL4,  // 氓
	0x6C14, KANJI_LEVEL4,  // 气
	0x6C1B, KANJI_LEVEL4,  // 氛
	0x6C24, KANJI_LEVEL4,  // 氤
	0x6C23, KANJI_LEVEL4,  // 氣
	0x6C5E, KANJI_LEVEL4,  // 汞
	0x6C55, KANJI_LEVEL4,  // 汕
	0x6C62, KANJI_LEVEL4,  // 汢
	0x6C6A, KANJI_LEVEL4,  // 汪
	0x6C82, KANJI_LEVEL4,  // 沂
	0x6C8D, KANJI_LEVEL4,  // 沍
	0x6C9A, KANJI_LEVEL4,  // 沚
	0x6C81, KANJI_LEVEL4,  // 沁
	0x6C9B, KANJI_LEVEL4,  // 沛
	0x6C7E, KANJI_LEVEL4,  // 汾
	0x6C68, KANJI_LEVEL4,  // 汨
	0x6C73, KANJI_LEVEL4,  // 汳
	0x6C92, KANJI_LEVEL4,  // 沒
	0x6C90, KANJI_LEVEL4,  // 沐
	0x6CC4, KANJI_LEVEL4,  // 泄
	0x6CF1, KANJI_LEVEL4,  // 泱
	0x6CD3, KANJI_LEVEL4,  // 泓
	0x6CBD, KANJI_LEVEL4,  // 沽
	0x6CD7, KANJI_LEVEL4,  // 泗
	0x6CC5, KANJI_LEVEL4,  // 泅
	0x6CDD, KANJI_LEVEL4,  // 泝
	0x6CAE, KANJI_LEVEL4,  // 沮
	0x6CB1, KANJI_LEVEL4,  // 沱
	0x6CBE, KANJI_LEVEL4,  // 沾
	0x6CBA, KANJI_LEVEL4,  // 沺
	0x6CDB, KANJI_LEVEL4,  // 泛
	0x6CEF, KANJI_LEVEL4,  // 泯
	0x6CD9, KANJI_LEVEL4,  // 泙
	0x6CEA, KANJI_LEVEL4,  // 泪
	0x6D1F, KANJI_LEVEL4,  // 洟
	0x884D, KANJI_LEVEL4,  // 衍
	0x6D36, KANJI_LEVEL4,  // 洶
	0x6D2B, KANJI_LEVEL4,  // 洫
	0x6D3D, KANJI_LEVEL4,  // 洽
	0x6D38, KANJI_LEVEL4,  // 洸
	0x6D19, KANJI_LEVEL4,  // 洙
	0x6D35, KANJI_LEVEL4,  // 洵
	0x6D33, KANJI_LEVEL4,  // 洳
	0x6D12, KANJI_LEVEL4,  // 洒
	0x6D0C, KANJI_LEVEL4,  // 洌
	0x6D63, KANJI_LEVEL4,  // 浣
	0x6D93, KANJI_LEVEL4,  // 涓
	0x6D64, KANJI_LEVEL4,  // 浤
	0x6D5A, KANJI_LEVEL4,  // 浚
	0x6D79, KANJI_LEVEL4,  // 浹
	0x6D59, KANJI_LEVEL4,  // 浙
	0x6D8E, KANJI_LEVEL4,  // 涎
	0x6D95, KANJI_LEVEL4,  // 涕
	0x6FE4, KANJI_LEVEL4,  // 濤
	0x6D85, KANJI_LEVEL4,  // 涅
	0x6DF9, KANJI_LEVEL4,  // 淹
	0x6E15, KANJI_LEVEL4,  // 渕
	0x6E0A, KANJI_LEVEL4,  // 渊
	0x6DB5, KANJI_LEVEL4,  // 涵
	0x6DC7, KANJI_LEVEL4,  // 淇
	0x6DE6, KANJI_LEVEL4,  // 淦
	0x6DB8, KANJI_LEVEL4,  // 涸
	0x6DC6, KANJI_LEVEL4,  // 淆
	0x6DEC, KANJI_LEVEL4,  // 淬
	0x6DDE, KANJI_LEVEL4,  // 淞
	0x6DCC, KANJI_LEVEL4,  // 淌
	0x6DE8, KANJI_LEVEL4,  // 淨
	0x6DD2, KANJI_LEVEL4,  // 淒
	0x6DC5, KANJI_LEVEL4,  // 淅
	0x6DFA, KANJI_LEVEL4,  // 淺
	0x6DD9, KANJI_LEVEL4,  // 淙
	0x6DE4, KANJI_LEVEL4,  // 淤
	0x6DD5, KANJI_LEVEL4,  // 淕
	0x6DEA, KANJI_LEVEL4,  // 淪
	0x6DEE, KANJI_LEVEL4,  // 淮
	0x6E2D, KANJI_LEVEL4,  // 渭
	0x6E6E, KANJI_LEVEL4,  // 湮
	0x6E2E, KANJI_LEVEL4,  // 渮
	0x6E19, KANJI_LEVEL4,  // 渙
	0x6E72, KANJI_LEVEL4,  // 湲
	0x6E5F, KANJI_LEVEL4,  // 湟
	0x6E3E, KANJI_LEVEL4,  // 渾
	0x6E23, KANJI_LEVEL4,  // 渣
	0x6E6B, KANJI_LEVEL4,  // 湫
	0x6E2B, KANJI_LEVEL4,  // 渫
	0x6E76, KANJI_LEVEL4,  // 湶
	0x6E4D, KANJI_LEVEL4,  // 湍
	0x6E1F, KANJI_LEVEL4,  // 渟
	0x6E43, KANJI_LEVEL4,  // 湃
	0x6E3A, KANJI_LEVEL4,  // 渺
	0x6E4E, KANJI_LEVEL4,  // 湎
	0x6E24, KANJI_LEVEL4,  // 渤
	0x6EFF, KANJI_LEVEL4,  // 滿
	0x6E1D, KANJI_LEVEL4,  // 渝
	0x6E38, KANJI_LEVEL4,  // 游
	0x6E82, KANJI_LEVEL4,  // 溂
	0x6EAA, KANJI_LEVEL4,  // 溪
	0x6E98, KANJI_LEVEL4,  // 溘
	0x6EC9, KANJI_LEVEL4,  // 滉
	0x6EB7, KANJI_LEVEL4,  // 溷
	0x6ED3, KANJI_LEVEL4,  // 滓
	0x6EBD, KANJI_LEVEL4,  // 溽
	0x6EAF, KANJI_LEVEL4,  // 溯
	0x6EC4, KANJI_LEVEL4,  // 滄
	0x6EB2, KANJI_LEVEL4,  // 溲
	0x6ED4, KANJI_LEVEL4,  // 滔
	0x6ED5, KANJI_LEVEL4,  // 滕
	0x6E8F, KANJI_LEVEL4,  // 溏
	0x6EA5, KANJI_LEVEL4,  // 溥
	0x6EC2, KANJI_LEVEL4,  // 滂
	0x6E9F, KANJI_LEVEL4,  // 溟
	0x6F41, KANJI_LEVEL4,  // 潁
	0x6F11, KANJI_LEVEL4,  // 漑
	0x704C, KANJI_LEVEL4,  // 灌
	0x6EEC, KANJI_LEVEL4,  // 滬
	0x6EF8, KANJI_LEVEL4,  // 滸
	0x6EFE, KANJI_LEVEL4,  // 滾
	0x6F3F, KANJI_LEVEL4,  // 漿
	0x6EF2, KANJI_LEVEL4,  // 滲
	0x6F31, KANJI_LEVEL4,  // 漱
	0x6EEF, KANJI_LEVEL4,  // 滯
	0x6F32, KANJI_LEVEL4,  // 漲
	0x6ECC, KANJI_LEVEL4,  // 滌
	0x6F3E, KANJI_LEVEL4,  // 漾
	0x6F13, KANJI_LEVEL4,  // 漓
	0x6EF7, KANJI_LEVEL4,  // 滷
	0x6F86, KANJI_LEVEL4,  // 澆
	0x6F7A, KANJI_LEVEL4,  // 潺
	0x6F78, KANJI_LEVEL4,  // 潸
	0x6F81, KANJI_LEVEL4,  // 澁
	0x6F80, KANJI_LEVEL4,  // 澀
	0x6F6F, KANJI_LEVEL4,  // 潯
	0x6F5B, KANJI_LEVEL4,  // 潛
	0x6FF3, KANJI_LEVEL4,  // 濳
	0x6F6D, KANJI_LEVEL4,  // 潭
	0x6F82, KANJI_LEVEL4,  // 澂
	0x6F7C, KANJI_LEVEL4,  // 潼
	0x6F58, KANJI_LEVEL4,  // 潘
	0x6F8E, KANJI_LEVEL4,  // 澎
	0x6F91, KANJI_LEVEL4,  // 澑
	0x6FC2, KANJI_LEVEL4,  // 濂
	0x6F66, KANJI_LEVEL4,  // 潦
	0x6FB3, KANJI_LEVEL4,  // 澳
	0x6FA3, KANJI_LEVEL4,  // 澣
	0x6FA1, KANJI_LEVEL4,  // 澡
	0x6FA4, KANJI_LEVEL4,  // 澤
	0x6FB9, KANJI_LEVEL4,  // 澹
	0x6FC6, KANJI_LEVEL4,  // 濆
	0x6FAA, KANJI_LEVEL4,  // 澪
	0x6FDF, KANJI_LEVEL4,  // 濟
	0x6FD5, KANJI_LEVEL4,  // 濕
	0x6FEC, KANJI_LEVEL4,  // 濬
	0x6FD4, KANJI_LEVEL4,  // 濔
	0x6FD8, KANJI_LEVEL4,  // 濘
	0x6FF1, KANJI_LEVEL4,  // 濱
	0x6FEE, KANJI_LEVEL4,  // 濮
	0x6FDB, KANJI_LEVEL4,  // 濛
	0x7009, KANJI_LEVEL4,  // 瀉
	0x700B, KANJI_LEVEL4,  // 瀋
	0x6FFA, KANJI_LEVEL4,  // 濺
	0x7011, KANJI_LEVEL4,  // 瀑
	0x7001, KANJI_LEVEL4,  // 瀁
	0x700F, KANJI_LEVEL4,  // 瀏
	0x6FFE, KANJI_LEVEL4,  // 濾
	0x701B, KANJI_LEVEL4,  // 瀛
	0x701A, KANJI_LEVEL4,  // 瀚
	0x6F74, KANJI_LEVEL4,  // 潴
	0x701D, KANJI_LEVEL4,  // 瀝
	0x7018, KANJI_LEVEL4,  // 瀘
	0x701F, KANJI_LEVEL4,  // 瀟
	0x7030, KANJI_LEVEL4,  // 瀰
	0x703E, KANJI_LEVEL4,  // 瀾
	0x7032, KANJI_LEVEL4,  // 瀲
	0x7051, KANJI_LEVEL4,  // 灑
	0x7063, KANJI_LEVEL4,  // 灣
	0x7099, KANJI_LEVEL4,  // 炙
	0x7092, KANJI_LEVEL4,  // 炒
	0x70AF, KANJI_LEVEL4,  // 炯
	0x70F1, KANJI_LEVEL4,  // 烱
	0x70AC, KANJI_LEVEL4,  // 炬
	0x70B8, KANJI_LEVEL4,  // 炸
	0x70B3, KANJI_LEVEL4,  // 炳
	0x70AE, KANJI_LEVEL4,  // 炮
	0x70DF, KANJI_LEVEL4,  // 烟
	0x70CB, KANJI_LEVEL4,  // 烋
	0x70DD, KANJI_LEVEL4,  // 烝
	0x70D9, KANJI_LEVEL4,  // 烙
	0x7109, KANJI_LEVEL4,  // 焉
	0x70FD, KANJI_LEVEL4,  // 烽
	0x711C, KANJI_LEVEL4,  // 焜
	0x7119, KANJI_LEVEL4,  // 焙
	0x7165, KANJI_LEVEL4,  // 煥
	0x7155, KANJI_LEVEL4,  // 煕
	0x7188, KANJI_LEVEL4,  // 熈
	0x7166, KANJI_LEVEL4,  // 煦
	0x7162, KANJI_LEVEL4,  // 煢
	0x714C, KANJI_LEVEL4,  // 煌
	0x7156, KANJI_LEVEL4,  // 煖
	0x716C, KANJI_LEVEL4,  // 煬
	0x718F, KANJI_LEVEL4,  // 熏
	0x71FB, KANJI_LEVEL4,  // 燻
	0x7184, KANJI_LEVEL4,  // 熄
	0x7195, KANJI_LEVEL4,  // 熕
	0x71A8, KANJI_LEVEL4,  // 熨
	0x71AC, KANJI_LEVEL4,  // 熬
	0x71D7, KANJI_LEVEL4,  // 燗
	0x71B9, KANJI_LEVEL4,  // 熹
	0x71BE, KANJI_LEVEL4,  // 熾
	0x71D2, KANJI_LEVEL4,  // 燒
	0x71C9, KANJI_LEVEL4,  // 燉
	0x71D4, KANJI_LEVEL4,  // 燔
	0x71CE, KANJI_LEVEL4,  // 燎
	0x71E0, KANJI_LEVEL4,  // 燠
	0x71EC, KANJI_LEVEL4,  // 燬
	0x71E7, KANJI_LEVEL4,  // 燧
	0x71F5, KANJI_LEVEL4,  // 燵
	0x71FC, KANJI_LEVEL4,  // 燼
	0x71F9, KANJI_LEVEL4,  // 燹
	0x71FF, KANJI_LEVEL4,  // 燿
	0x720D, KANJI_LEVEL4,  // 爍
	0x7210, KANJI_LEVEL4,  // 爐
	0x721B, KANJI_LEVEL4,  // 爛
	0x7228, KANJI_LEVEL4,  // 爨
	0x722D, KANJI_LEVEL4,  // 爭
	0x722C, KANJI_LEVEL4,  // 爬
	0x7230, KANJI_LEVEL4,  // 爰
	0x7232, KANJI_LEVEL4,  // 爲
	0x723B, KANJI_LEVEL4,  // 爻
	0x723C, KANJI_LEVEL4,  // 爼
	0x723F, KANJI_LEVEL4,  // 爿
	0x7240, KANJI_LEVEL4,  // 牀
	0x7246, KANJI_LEVEL4,  // 牆
	0x724B, KANJI_LEVEL4,  // 牋
	0x7258, KANJI_LEVEL4,  // 牘
	0x7274, KANJI_LEVEL4,  // 牴
	0x727E, KANJI_LEVEL4,  // 牾
	0x7282, KANJI_LEVEL4,  // 犂
	0x7281, KANJI_LEVEL4,  // 犁
	0x7287, KANJI_LEVEL4,  // 犇
	0x7292, KANJI_LEVEL4,  // 犒
	0x7296, KANJI_LEVEL4,  // 犖
	0x72A2, KANJI_LEVEL4,  // 犢
	0x72A7, KANJI_LEVEL4,  // 犧
	0x72B9, KANJI_LEVEL4,  // 犹
	0x72B2, KANJI_LEVEL4,  // 犲
	0x72C3, KANJI_LEVEL4,  // 狃
	0x72C6, KANJI_LEVEL4,  // 狆
	0x72C4, KANJI_LEVEL4,  // 狄
	0x72CE, KANJI_LEVEL4,  // 狎
	0x72D2, KANJI_LEVEL4,  // 狒
	0x72E2, KANJI_LEVEL4,  // 狢
	0x72E0, KANJI_LEVEL4,  // 狠
	0x72E1, KANJI_LEVEL4,  // 狡
	0x72F9, KANJI_LEVEL4,  // 狹
	0x72F7, KANJI_LEVEL4,  // 狷
	0x500F, KANJI_LEVEL4,  // 倏
	0x7317, KANJI_LEVEL4,  // 猗
	0x730A, KANJI_LEVEL4,  // 猊
	0x731C, KANJI_LEVEL4,  // 猜
	0x7316, KANJI_LEVEL4,  // 猖
	0x731D, KANJI_LEVEL4,  // 猝
	0x7334, KANJI_LEVEL4,  // 猴
	0x732F, KANJI_LEVEL4,  // 猯
	0x7329, KANJI_LEVEL4,  // 猩
	0x7325, KANJI_LEVEL4,  // 猥
	0x733E, KANJI_LEVEL4,  // 猾
	0x734E, KANJI_LEVEL4,  // 獎
	0x734F, KANJI_LEVEL4,  // 獏
	0x9ED8, KANJI_LEVEL4,  // 默
	0x7357, KANJI_LEVEL4,  // 獗
	0x736A, KANJI_LEVEL4,  // 獪
	0x7368, KANJI_LEVEL4,  // 獨
	0x7370, KANJI_LEVEL4,  // 獰
	0x7378, KANJI_LEVEL4,  // 獸
	0x7375, KANJI_LEVEL4,  // 獵
	0x737B, KANJI_LEVEL4,  // 獻
	0x737A, KANJI_LEVEL4,  // 獺
	0x73C8, KANJI_LEVEL4,  // 珈
	0x73B3, KANJI_LEVEL4,  // 玳
	0x73CE, KANJI_LEVEL4,  // 珎
	0x73BB, KANJI_LEVEL4,  // 玻
	0x73C0, KANJI_LEVEL4,  // 珀
	0x73E5, KANJI_LEVEL4,  // 珥
	0x73EE, KANJI_LEVEL4,  // 珮
	0x73DE, KANJI_LEVEL4,  // 珞
	0x74A2, KANJI_LEVEL4,  // 璢
	0x7405, KANJI_LEVEL4,  // 琅
	0x746F, KANJI_LEVEL4,  // 瑯
	0x7425, KANJI_LEVEL4,  // 琥
	0x73F8, KANJI_LEVEL4,  // 珸
	0x7432, KANJI_LEVEL4,  // 琲
	0x743A, KANJI_LEVEL4,  // 琺
	0x7455, KANJI_LEVEL4,  // 瑕
	0x743F, KANJI_LEVEL4,  // 琿
	0x745F, KANJI_LEVEL4,  // 瑟
	0x7459, KANJI_LEVEL4,  // 瑙
	0x7441, KANJI_LEVEL4,  // 瑁
	0x745C, KANJI_LEVEL4,  // 瑜
	0x7469, KANJI_LEVEL4,  // 瑩
	0x7470, KANJI_LEVEL4,  // 瑰
	0x7463, KANJI_LEVEL4,  // 瑣
	0x746A, KANJI_LEVEL4,  // 瑪
	0x7476, KANJI_LEVEL4,  // 瑶
	0x747E, KANJI_LEVEL4,  // 瑾
	0x748B, KANJI_LEVEL4,  // 璋
	0x749E, KANJI_LEVEL4,  // 璞
	0x74A7, KANJI_LEVEL4,  // 璧
	0x74CA, KANJI_LEVEL4,  // 瓊
	0x74CF, KANJI_LEVEL4,  // 瓏
	0x74D4, KANJI_LEVEL4,  // 瓔
	0x73F1, KANJI_LEVEL4,  // 珱
	0x74E0, KANJI_LEVEL4,  // 瓠
	0x74E3, KANJI_LEVEL4,  // 瓣
	0x74E7, KANJI_LEVEL4,  // 瓧
	0x74E9, KANJI_LEVEL4,  // 瓩
	0x74EE, KANJI_LEVEL4,  // 瓮
	0x74F2, KANJI_LEVEL4,  // 瓲
	0x74F0, KANJI_LEVEL4,  // 瓰
	0x74F1, KANJI_LEVEL4,  // 瓱
	0x74F8, KANJI_LEVEL4,  // 瓸
	0x74F7, KANJI_LEVEL4,  // 瓷
	0x7504, KANJI_LEVEL4,  // 甄
	0x7503, KANJI_LEVEL4,  // 甃
	0x7505, KANJI_LEVEL4,  // 甅
	0x750C, KANJI_LEVEL4,  // 甌
	0x750E, KANJI_LEVEL4,  // 甎
	0x750D, KANJI_LEVEL4,  // 甍
	0x7515, KANJI_LEVEL4,  // 甕
	0x7513, KANJI_LEVEL4,  // 甓
	0x751E, KANJI_LEVEL4,  // 甞
	0x7526, KANJI_LEVEL4,  // 甦
	0x752C, KANJI_LEVEL4,  // 甬
	0x753C, KANJI_LEVEL4,  // 甼
	0x7544, KANJI_LEVEL4,  // 畄
	0x754D, KANJI_LEVEL4,  // 畍
	0x754A, KANJI_LEVEL4,  // 畊
	0x7549, KANJI_LEVEL4,  // 畉
	0x755B, KANJI_LEVEL4,  // 畛
	0x7546, KANJI_LEVEL4,  // 畆
	0x755A, KANJI_LEVEL4,  // 畚
	0x7569, KANJI_LEVEL4,  // 畩
	0x7564, KANJI_LEVEL4,  // 畤
	0x7567, KANJI_LEVEL4,  // 畧
	0x756B, KANJI_LEVEL4,  // 畫
	0x756D, KANJI_LEVEL4,  // 畭
	0x7578, KANJI_LEVEL4,  // 畸
	0x7576, KANJI_LEVEL4,  // 當
	0x7586, KANJI_LEVEL4,  // 疆
	0x7587, KANJI_LEVEL4,  // 疇
	0x7574, KANJI_LEVEL4,  // 畴
	0x758A, KANJI_LEVEL4,  // 疊
	0x7589, KANJI_LEVEL4,  // 疉
	0x7582, KANJI_LEVEL4,  // 疂
	0x7594, KANJI_LEVEL4,  // 疔
	0x759A, KANJI_LEVEL4,  // 疚
	0x759D, KANJI_LEVEL4,  // 疝
	0x75A5, KANJI_LEVEL4,  // 疥
	0x75A3, KANJI_LEVEL4,  // 疣
	0x75C2, KANJI_LEVEL4,  // 痂
	0x75B3, KANJI_LEVEL4,  // 疳
	0x75C3, KANJI_LEVEL4,  // 痃
	0x75B5, KANJI_LEVEL4,  // 疵
	0x75BD, KANJI_LEVEL4,  // 疽
	0x75B8, KANJI_LEVEL4,  // 疸
	0x75BC, KANJI_LEVEL4,  // 疼
	0x75B1, KANJI_LEVEL4,  // 疱
	0x75CD, KANJI_LEVEL4,  // 痍
	0x75CA, KANJI_LEVEL4,  // 痊
	0x75D2, KANJI_LEVEL4,  // 痒
	0x75D9, KANJI_LEVEL4,  // 痙
	0x75E3, KANJI_LEVEL4,  // 痣
	0x75DE, KANJI_LEVEL4,  // 痞
	0x75FE, KANJI_LEVEL4,  // 痾
	0x75FF, KANJI_LEVEL4,  // 痿
	0x75FC, KANJI_LEVEL4,  // 痼
	0x7601, KANJI_LEVEL4,  // 瘁
	0x75F0, KANJI_LEVEL4,  // 痰
	0x75FA, KANJI_LEVEL4,  // 痺
	0x75F2, KANJI_LEVEL4,  // 痲
	0x75F3, KANJI_LEVEL4,  // 痳
	0x760B, KANJI_LEVEL4,  // 瘋
	0x760D, KANJI_LEVEL4,  // 瘍
	0x7609, KANJI_LEVEL4,  // 瘉
	0x761F, KANJI_LEVEL4,  // 瘟
	0x7627, KANJI_LEVEL4,  // 瘧
	0x7620, KANJI_LEVEL4,  // 瘠
	0x7621, KANJI_LEVEL4,  // 瘡
	0x7622, KANJI_LEVEL4,  // 瘢
	0x7624, KANJI_LEVEL4,  // 瘤
	0x7634, KANJI_LEVEL4,  // 瘴
	0x7630, KANJI_LEVEL4,  // 瘰
	0x763B, KANJI_LEVEL4,  // 瘻
	0x7647, KANJI_LEVEL4,  // 癇
	0x7648, KANJI_LEVEL4,  // 癈
	0x7646, KANJI_LEVEL4,  // 癆
	0x765C, KANJI_LEVEL4,  // 癜
	0x7658, KANJI_LEVEL4,  // 癘
	0x7661, KANJI_LEVEL4,  // 癡
	0x7662, KANJI_LEVEL4,  // 癢
	0x7668, KANJI_LEVEL4,  // 癨
	0x7669, KANJI_LEVEL4,  // 癩
	0x766A, KANJI_LEVEL4,  // 癪
	0x7667, KANJI_LEVEL4,  // 癧
	0x766C, KANJI_LEVEL4,  // 癬
	0x7670, KANJI_LEVEL4,  // 癰
	0x7672, KANJI_LEVEL4,  // 癲
	0x7676, KANJI_LEVEL4,  // 癶
	0x7678, KANJI_LEVEL4,  // 癸
	0x767C, KANJI_LEVEL4,  // 發
	0x7680, KANJI_LEVEL4,  // 皀
	0x7683, KANJI_LEVEL4,  // 皃
	0x7688, KANJI_LEVEL4,  // 皈
	0x768B, KANJI_LEVEL4,  // 皋
	0x768E, KANJI_LEVEL4,  // 皎
	0x7696, KANJI_LEVEL4,  // 皖
	0x7693, KANJI_LEVEL4,  // 皓
	0x7699, KANJI_LEVEL4,  // 皙
	0x769A, KANJI_LEVEL4,  // 皚
	0x76B0, KANJI_LEVEL4,  // 皰
	0x76B4, KANJI_LEVEL4,  // 皴
	0x76B8, KANJI_LEVEL4,  // 皸
	0x76B9, KANJI_LEVEL4,  // 皹
	0x76BA, KANJI_LEVEL4,  // 皺
	0x76C2, KANJI_LEVEL4,  // 盂
	0x76CD, KANJI_LEVEL4,  // 盍
	0x76D6, KANJI_LEVEL4,  // 盖
	0x76D2, KANJI_LEVEL4,  // 盒
	0x76DE, KANJI_LEVEL4,  // 盞
	0x76E1, KANJI_LEVEL4,  // 盡
	0x76E5, KANJI_LEVEL4,  // 盥
	0x76E7, KANJI_LEVEL4,  // 盧
	0x76EA, KANJI_LEVEL4,  // 盪
	0x862F, KANJI_LEVEL4,  // 蘯
	0x76FB, KANJI_LEVEL4,  // 盻
	0x7708, KANJI_LEVEL4,  // 眈
	0x7707, KANJI_LEVEL4,  // 眇
	0x7704, KANJI_LEVEL4,  // 眄
	0x7729, KANJI_LEVEL4,  // 眩
	0x7724, KANJI_LEVEL4,  // 眤
	0x771E, KANJI_LEVEL4,  // 眞
	0x7725, KANJI_LEVEL4,  // 眥
	0x7726, KANJI_LEVEL4,  // 眦
	0x771B, KANJI_LEVEL4,  // 眛
	0x7737, KANJI_LEVEL4,  // 眷
	0x7738, KANJI_LEVEL4,  // 眸
	0x7747, KANJI_LEVEL4,  // 睇
	0x775A, KANJI_LEVEL4,  // 睚
	0x7768, KANJI_LEVEL4,  // 睨
	0x776B, KANJI_LEVEL4,  // 睫
	0x775B, KANJI_LEVEL4,  // 睛
	0x7765, KANJI_LEVEL4,  // 睥
	0x777F, KANJI_LEVEL4,  // 睿
	0x777E, KANJI_LEVEL4,  // 睾
	0x7779, KANJI_LEVEL4,  // 睹
	0x778E, KANJI_LEVEL4,  // 瞎
	0x778B, KANJI_LEVEL4,  // 瞋
	0x7791, KANJI_LEVEL4,  // 瞑
	0x77A0, KANJI_LEVEL4,  // 瞠
	0x779E, KANJI_LEVEL4,  // 瞞
	0x77B0, KANJI_LEVEL4,  // 瞰
	0x77B6, KANJI_LEVEL4,  // 瞶
	0x77B9, KANJI_LEVEL4,  // 瞹
	0x77BF, KANJI_LEVEL4,  // 瞿
	0x77BC, KANJI_LEVEL4,  // 瞼
	0x77BD, KANJI_LEVEL4,  // 瞽
	0x77BB, KANJI_LEVEL4,  // 瞻
	0x77C7, KANJI_LEVEL4,  // 矇
	0x77CD, KANJI_LEVEL4,  // 矍
	0x77D7, KANJI_LEVEL4,  // 矗
	0x77DA, KANJI_LEVEL4,  // 矚
	0x77DC, KANJI_LEVEL4,  // 矜
	0x77E3, KANJI_LEVEL4,  // 矣
	0x77EE, KANJI_LEVEL4,  // 矮
	0x77FC, KANJI_LEVEL4,  // 矼
	0x780C, KANJI_LEVEL4,  // 砌
	0x7812, KANJI_LEVEL4,  // 砒
	0x7926, KANJI_LEVEL4,  // 礦
	0x7820, KANJI_LEVEL4,  // 砠
	0x792A, KANJI_LEVEL4,  // 礪
	0x7845, KANJI_LEVEL4,  // 硅
	0x788E, KANJI_LEVEL4,  // 碎
	0x7874, KANJI_LEVEL4,  // 硴
	0x7886, KANJI_LEVEL4,  // 碆
	0x787C, KANJI_LEVEL4,  // 硼
	0x789A, KANJI_LEVEL4,  // 碚
	0x788C, KANJI_LEVEL4,  // 碌
	0x78A3, KANJI_LEVEL4,  // 碣
	0x78B5, KANJI_LEVEL4,  // 碵
	0x78AA, KANJI_LEVEL4,  // 碪
	0x78AF, KANJI_LEVEL4,  // 碯
	0x78D1, KANJI_LEVEL4,  // 磑
	0x78C6, KANJI_LEVEL4,  // 磆
	0x78CB, KANJI_LEVEL4,  // 磋
	0x78D4, KANJI_LEVEL4,  // 磔
	0x78BE, KANJI_LEVEL4,  // 碾
	0x78BC, KANJI_LEVEL4,  // 碼
	0x78C5, KANJI_LEVEL4,  // 磅
	0x78CA, KANJI_LEVEL4,  // 磊
	0x78EC, KANJI_LEVEL4,  // 磬
	0x78E7, KANJI_LEVEL4,  // 磧
	0x78DA, KANJI_LEVEL4,  // 磚
	0x78FD, KANJI_LEVEL4,  // 磽
	0x78F4, KANJI_LEVEL4,  // 磴
	0x7907, KANJI_LEVEL4,  // 礇
	0x7912, KANJI_LEVEL4,  // 礒
	0x7911, KANJI_LEVEL4,  // 礑
	0x7919, KANJI_LEVEL4,  // 礙
	0x792C, KANJI_LEVEL4,  // 礬
	0x792B, KANJI_LEVEL4,  // 礫
	0x7940, KANJI_LEVEL4,  // 祀
	0x7960, KANJI_LEVEL4,  // 祠
	0x7957, KANJI_LEVEL4,  // 祗
	0x795F, KANJI_LEVEL4,  // 祟
	0x795A, KANJI_LEVEL4,  // 祚
	0x7955, KANJI_LEVEL4,  // 祕
	0x7953, KANJI_LEVEL4,  // 祓
	0x797A, KANJI_LEVEL4,  // 祺
	0x797F, KANJI_LEVEL4,  // 祿
	0x798A, KANJI_LEVEL4,  // 禊
	0x799D, KANJI_LEVEL4,  // 禝
	0x79A7, KANJI_LEVEL4,  // 禧
	0x9F4B, KANJI_LEVEL4,  // 齋
	0x79AA, KANJI_LEVEL4,  // 禪
	0x79AE, KANJI_LEVEL4,  // 禮
	0x79B3, KANJI_LEVEL4,  // 禳
	0x79B9, KANJI_LEVEL4,  // 禹
	0x79BA, KANJI_LEVEL4,  // 禺
	0x79C9, KANJI_LEVEL4,  // 秉
	0x79D5, KANJI_LEVEL4,  // 秕
	0x79E7, KANJI_LEVEL4,  // 秧
	0x79EC, KANJI_LEVEL4,  // 秬
	0x79E1, KANJI_LEVEL4,  // 秡
	0x79E3, KANJI_LEVEL4,  // 秣
	0x7A08, KANJI_LEVEL4,  // 稈
	0x7A0D, KANJI_LEVEL4,  // 稍
	0x7A18, KANJI_LEVEL4,  // 稘
	0x7A19, KANJI_LEVEL4,  // 稙
	0x7A20, KANJI_LEVEL4,  // 稠
	0x7A1F, KANJI_LEVEL4,  // 稟
	0x7980, KANJI_LEVEL4,  // 禀
	0x7A31, KANJI_LEVEL4,  // 稱
	0x7A3B, KANJI_LEVEL4,  // 稻
	0x7A3E, KANJI_LEVEL4,  // 稾
	0x7A37, KANJI_LEVEL4,  // 稷
	0x7A43, KANJI_LEVEL4,  // 穃
	0x7A57, KANJI_LEVEL4,  // 穗
	0x7A49, KANJI_LEVEL4,  // 穉
	0x7A61, KANJI_LEVEL4,  // 穡
	0x7A62, KANJI_LEVEL4,  // 穢
	0x7A69, KANJI_LEVEL4,  // 穩
	0x9F9D, KANJI_LEVEL4,  // 龝
	0x7A70, KANJI_LEVEL4,  // 穰
	0x7A79, KANJI_LEVEL4,  // 穹
	0x7A7D, KANJI_LEVEL4,  // 穽
	0x7A88, KANJI_LEVEL4,  // 窈
	0x7A97, KANJI_LEVEL4,  // 窗
	0x7A95, KANJI_LEVEL4,  // 窕
	0x7A98, KANJI_LEVEL4,  // 窘
	0x7A96, KANJI_LEVEL4,  // 窖
	0x7AA9, KANJI_LEVEL4,  // 窩
	0x7AC8, KANJI_LEVEL4,  // 竈
	0x7AB0, KANJI_LEVEL4,  // 窰
	0x7AB6, KANJI_LEVEL4,  // 窶
	0x7AC5, KANJI_LEVEL4,  // 竅
	0x7AC4, KANJI_LEVEL4,  // 竄
	0x7ABF, KANJI_LEVEL4,  // 窿
	0x9083, KANJI_LEVEL4,  // 邃
	0x7AC7, KANJI_LEVEL4,  // 竇
	0x7ACA, KANJI_LEVEL4,  // 竊
	0x7ACD, KANJI_LEVEL4,  // 竍
	0x7ACF, KANJI_LEVEL4,  // 竏
	0x7AD5, KANJI_LEVEL4,  // 竕
	0x7AD3, KANJI_LEVEL4,  // 竓
	0x7AD9, KANJI_LEVEL4,  // 站
	0x7ADA, KANJI_LEVEL4,  // 竚
	0x7ADD, KANJI_LEVEL4,  // 竝
	0x7AE1, KANJI_LEVEL4,  // 竡
	0x7AE2, KANJI_LEVEL4,  // 竢
	0x7AE6, KANJI_LEVEL4,  // 竦
	0x7AED, KANJI_LEVEL4,  // 竭
	0x7AF0, KANJI_LEVEL4,  // 竰
	0x7B02, KANJI_LEVEL4,  // 笂
	0x7B0F, KANJI_LEVEL4,  // 笏
	0x7B0A, KANJI_LEVEL4,  // 笊
	0x7B06, KANJI_LEVEL4,  // 笆
	0x7B33, KANJI_LEVEL4,  // 笳
	0x7B18, KANJI_LEVEL4,  // 笘
	0x7B19, KANJI_LEVEL4,  // 笙
	0x7B1E, KANJI_LEVEL4,  // 笞
	0x7B35, KANJI_LEVEL4,  // 笵
	0x7B28, KANJI_LEVEL4,  // 笨
	0x7B36, KANJI_LEVEL4,  // 笶
	0x7B50, KANJI_LEVEL4,  // 筐
	0x7B7A, KANJI_LEVEL4,  // 筺
	0x7B04, KANJI_LEVEL4,  // 笄
	0x7B4D, KANJI_LEVEL4,  // 筍
	0x7B0B, KANJI_LEVEL4,  // 笋
	0x7B4C, KANJI_LEVEL4,  // 筌
	0x7B45, KANJI_LEVEL4,  // 筅
	0x7B75, KANJI_LEVEL4,  // 筵
	0x7B65, KANJI_LEVEL4,  // 筥
	0x7B74, KANJI_LEVEL4,  // 筴
	0x7B67, KANJI_LEVEL4,  // 筧
	0x7B70, KANJI_LEVEL4,  // 筰
	0x7B71, KANJI_LEVEL4,  // 筱
	0x7B6C, KANJI_LEVEL4,  // 筬
	0x7B6E, KANJI_LEVEL4,  // 筮
	0x7B9D, KANJI_LEVEL4,  // 箝
	0x7B98, KANJI_LEVEL4,  // 箘
	0x7B9F, KANJI_LEVEL4,  // 箟
	0x7B8D, KANJI_LEVEL4,  // 箍
	0x7B9C, KANJI_LEVEL4,  // 箜
	0x7B9A, KANJI_LEVEL4,  // 箚
	0x7B8B, KANJI_LEVEL4,  // 箋
	0x7B92, KANJI_LEVEL4,  // 箒
	0x7B8F, KANJI_LEVEL4,  // 箏
	0x7B5D, KANJI_LEVEL4,  // 筝
	0x7B99, KANJI_LEVEL4,  // 箙
	0x7BCB, KANJI_LEVEL4,  // 篋
	0x7BC1, KANJI_LEVEL4,  // 篁
	0x7BCC, KANJI_LEVEL4,  // 篌
	0x7BCF, KANJI_LEVEL4,  // 篏
	0x7BB4, KANJI_LEVEL4,  // 箴
	0x7BC6, KANJI_LEVEL4,  // 篆
	0x7BDD, KANJI_LEVEL4,  // 篝
	0x7BE9, KANJI_LEVEL4,  // 篩
	0x7C11, KANJI_LEVEL4,  // 簑
	0x7C14, KANJI_LEVEL4,  // 簔
	0x7BE6, KANJI_LEVEL4,  // 篦
	0x7BE5, KANJI_LEVEL4,  // 篥
	0x7C60, KANJI_LEVEL4,  // 籠
	0x7C00, KANJI_LEVEL4,  // 簀
	0x7C07, KANJI_LEVEL4,  // 簇
	0x7C13, KANJI_LEVEL4,  // 簓
	0x7BF3, KANJI_LEVEL4,  // 篳
	0x7BF7, KANJI_LEVEL4,  // 篷
	0x7C17, KANJI_LEVEL4,  // 簗
	0x7C0D, KANJI_LEVEL4,  // 簍
	0x7BF6, KANJI_LEVEL4,  // 篶
	0x7C23, KANJI_LEVEL4,  // 簣
	0x7C27, KANJI_LEVEL4,  // 簧
	0x7C2A, KANJI_LEVEL4,  // 簪
	0x7C1F, KANJI_LEVEL4,  // 簟
	0x7C37, KANJI_LEVEL4,  // 簷
	0x7C2B, KANJI_LEVEL4,  // 簫
	0x7C3D, KANJI_LEVEL4,  // 簽
	0x7C4C, KANJI_LEVEL4,  // 籌
	0x7C43, KANJI_LEVEL4,  // 籃
	0x7C54, KANJI_LEVEL4,  // 籔
	0x7C4F, KANJI_LEVEL4,  // 籏
	0x7C40, KANJI_LEVEL4,  // 籀
	0x7C50, KANJI_LEVEL4,  // 籐
	0x7C58, KANJI_LEVEL4,  // 籘
	0x7C5F, KANJI_LEVEL4,  // 籟
	0x7C64, KANJI_LEVEL4,  // 籤
	0x7C56, KANJI_LEVEL4,  // 籖
	0x7C65, KANJI_LEVEL4,  // 籥
	0x7C6C, KANJI_LEVEL4,  // 籬
	0x7C75, KANJI_LEVEL4,  // 籵
	0x7C83, KANJI_LEVEL4,  // 粃
	0x7C90, KANJI_LEVEL4,  // 粐
	0x7CA4, KANJI_LEVEL4,  // 粤
	0x7CAD, KANJI_LEVEL4,  // 粭
	0x7CA2, KANJI_LEVEL4,  // 粢
	0x7CAB, KANJI_LEVEL4,  // 粫
	0x7CA1, KANJI_LEVEL4,  // 粡
	0x7CA8, KANJI_LEVEL4,  // 粨
	0x7CB3, KANJI_LEVEL4,  // 粳
	0x7CB2, KANJI_LEVEL4,  // 粲
	0x7CB1, KANJI_LEVEL4,  // 粱
	0x7CAE, KANJI_LEVEL4,  // 粮
	0x7CB9, KANJI_LEVEL4,  // 粹
	0x7CBD, KANJI_LEVEL4,  // 粽
	0x7CC0, KANJI_LEVEL4,  // 糀
	0x7CC5, KANJI_LEVEL4,  // 糅
	0x7CC2, KANJI_LEVEL4,  // 糂
	0x7CD8, KANJI_LEVEL4,  // 糘
	0x7CD2, KANJI_LEVEL4,  // 糒
	0x7CDC, KANJI_LEVEL4,  // 糜
	0x7CE2, KANJI_LEVEL4,  // 糢
	0x9B3B, KANJI_LEVEL4,  // 鬻
	0x7CEF, KANJI_LEVEL4,  // 糯
	0x7CF2, KANJI_LEVEL4,  // 糲
	0x7CF4, KANJI_LEVEL4,  // 糴
	0x7CF6, KANJI_LEVEL4,  // 糶
	0x7CFA, KANJI_LEVEL4,  // 糺
	0x7D06, KANJI_LEVEL4,  // 紆
	0x7D02, KANJI_LEVEL4,  // 紂
	0x7D1C, KANJI_LEVEL4,  // 紜
	0x7D15, KANJI_LEVEL4,  // 紕
	0x7D0A, KANJI_LEVEL4,  // 紊
	0x7D45, KANJI_LEVEL4,  // 絅
	0x7D4B, KANJI_LEVEL4,  // 絋
	0x7D2E, KANJI_LEVEL4,  // 紮
	0x7D32, KANJI_LEVEL4,  // 紲
	0x7D3F, KANJI_LEVEL4,  // 紿
	0x7D35, KANJI_LEVEL4,  // 紵
	0x7D46, KANJI_LEVEL4,  // 絆
	0x7D73, KANJI_LEVEL4,  // 絳
	0x7D56, KANJI_LEVEL4,  // 絖
	0x7D4E, KANJI_LEVEL4,  // 絎
	0x7D72, KANJI_LEVEL4,  // 絲
	0x7D68, KANJI_LEVEL4,  // 絨
	0x7D6E, KANJI_LEVEL4,  // 絮
	0x7D4F, KANJI_LEVEL4,  // 絏
	0x7D63, KANJI_LEVEL4,  // 絣
	0x7D93, KANJI_LEVEL4,  // 經
	0x7D89, KANJI_LEVEL4,  // 綉
	0x7D5B, KANJI_LEVEL4,  // 絛
	0x7D8F, KANJI_LEVEL4,  // 綏
	0x7D7D, KANJI_LEVEL4,  // 絽
	0x7D9B, KANJI_LEVEL4,  // 綛
	0x7DBA, KANJI_LEVEL4,  // 綺
	0x7DAE, KANJI_LEVEL4,  // 綮
	0x7DA3, KANJI_LEVEL4,  // 綣
	0x7DB5, KANJI_LEVEL4,  // 綵
	0x7DC7, KANJI_LEVEL4,  // 緇
	0x7DBD, KANJI_LEVEL4,  // 綽
	0x7DAB, KANJI_LEVEL4,  // 綫
	0x7E3D, KANJI_LEVEL4,  // 總
	0x7DA2, KANJI_LEVEL4,  // 綢
	0x7DAF, KANJI_LEVEL4,  // 綯
	0x7DDC, KANJI_LEVEL4,  // 緜
	0x7DB8, KANJI_LEVEL4,  // 綸
	0x7D9F, KANJI_LEVEL4,  // 綟
	0x7DB0, KANJI_LEVEL4,  // 綰
	0x7DD8, KANJI_LEVEL4,  // 緘
	0x7DDD, KANJI_LEVEL4,  // 緝
	0x7DE4, KANJI_LEVEL4,  // 緤
	0x7DDE, KANJI_LEVEL4,  // 緞
	0x7DFB, KANJI_LEVEL4,  // 緻
	0x7DF2, KANJI_LEVEL4,  // 緲
	0x7DE1, KANJI_LEVEL4,  // 緡
	0x7E05, KANJI_LEVEL4,  // 縅
	0x7E0A, KANJI_LEVEL4,  // 縊
	0x7E23, KANJI_LEVEL4,  // 縣
	0x7E21, KANJI_LEVEL4,  // 縡
	0x7E12, KANJI_LEVEL4,  // 縒
	0x7E31, KANJI_LEVEL4,  // 縱
	0x7E1F, KANJI_LEVEL4,  // 縟
	0x7E09, KANJI_LEVEL4,  // 縉
	0x7E0B, KANJI_LEVEL4,  // 縋
	0x7E22, KANJI_LEVEL4,  // 縢
	0x7E46, KANJI_LEVEL4,  // 繆
	0x7E66, KANJI_LEVEL4,  // 繦
	0x7E3B, KANJI_LEVEL4,  // 縻
	0x7E35, KANJI_LEVEL4,  // 縵
	0x7E39, KANJI_LEVEL4,  // 縹
	0x7E43, KANJI_LEVEL4,  // 繃
	0x7E37, KANJI_LEVEL4,  // 縷
	0x7E32, KANJI_LEVEL4,  // 縲
	0x7E3A, KANJI_LEVEL4,  // 縺
	0x7E67, KANJI_LEVEL4,  // 繧
	0x7E5D, KANJI_LEVEL4,  // 繝
	0x7E56, KANJI_LEVEL4,  // 繖
	0x7E5E, KANJI_LEVEL4,  // 繞
	0x7E59, KANJI_LEVEL4,  // 繙
	0x7E5A, KANJI_LEVEL4,  // 繚
	0x7E79, KANJI_LEVEL4,  // 繹
	0x7E6A, KANJI_LEVEL4,  // 繪
	0x7E69, KANJI_LEVEL4,  // 繩
	0x7E7C, KANJI_LEVEL4,  // 繼
	0x7E7B, KANJI_LEVEL4,  // 繻
	0x7E83, KANJI_LEVEL4,  // 纃
	0x7DD5, KANJI_LEVEL4,  // 緕
	0x7E7D, KANJI_LEVEL4,  // 繽
	0x8FAE, KANJI_LEVEL4,  // 辮
	0x7E7F, KANJI_LEVEL4,  // 繿
	0x7E88, KANJI_LEVEL4,  // 纈
	0x7E89, KANJI_LEVEL4,  // 纉
	0x7E8C, KANJI_LEVEL4,  // 續
	0x7E92, KANJI_LEVEL4,  // 纒
	0x7E90, KANJI_LEVEL4,  // 纐
	0x7E93, KANJI_LEVEL4,  // 纓
	0x7E94, KANJI_LEVEL4,  // 纔
	0x7E96, KANJI_LEVEL4,  // 纖
	0x7E8E, KANJI_LEVEL4,  // 纎
	0x7E9B, KANJI_LEVEL4,  // 纛
	0x7E9C, KANJI_LEVEL4,  // 纜
	0x7F38, KANJI_LEVEL4,  // 缸
	0x7F3A, KANJI_LEVEL4,  // 缺
	0x7F45, KANJI_LEVEL4,  // 罅
	0x7F4C, KANJI_LEVEL4,  // 罌
	0x7F4D, KANJI_LEVEL4,  // 罍
	0x7F4E, KANJI_LEVEL4,  // 罎
	0x7F50, KANJI_LEVEL4,  // 罐
	0x7F51, KANJI_LEVEL4,  // 网
	0x7F55, KANJI_LEVEL4,  // 罕
	0x7F54, KANJI_LEVEL4,  // 罔
	0x7F58, KANJI_LEVEL4,  // 罘
	0x7F5F, KANJI_LEVEL4,  // 罟
	0x7F60, KANJI_LEVEL4,  // 罠
	0x7F68, KANJI_LEVEL4,  // 罨
	0x7F69, KANJI_LEVEL4,  // 罩
	0x7F67, KANJI_LEVEL4,  // 罧
	0x7F78, KANJI_LEVEL4,  // 罸
	0x7F82, KANJI_LEVEL4,  // 羂
	0x7F86, KANJI_LEVEL4,  // 羆
	0x7F83, KANJI_LEVEL4,  // 羃
	0x7F88, KANJI_LEVEL4,  // 羈
	0x7F87, KANJI_LEVEL4,  // 羇
	0x7F8C, KANJI_LEVEL4,  // 羌
	0x7F94, KANJI_LEVEL4,  // 羔
	0x7F9E, KANJI_LEVEL4,  // 羞
	0x7F9D, KANJI_LEVEL4,  // 羝
	0x7F9A, KANJI_LEVEL4,  // 羚
	0x7FA3, KANJI_LEVEL4,  // 羣
	0x7FAF, KANJI_LEVEL4,  // 羯
	0x7FB2, KANJI_LEVEL4,  // 羲
	0x7FB9, KANJI_LEVEL4,  // 羹
	0x7FAE, KANJI_LEVEL4,  // 羮
	0x7FB6, KANJI_LEVEL4,  // 羶
	0x7FB8, KANJI_LEVEL4,  // 羸
	0x8B71, KANJI_LEVEL4,  // 譱
	0x7FC5, KANJI_LEVEL4,  // 翅
	0x7FC6, KANJI_LEVEL4,  // 翆
	0x7FCA, KANJI_LEVEL4,  // 翊
	0x7FD5, KANJI_LEVEL4,  // 翕
	0x7FD4, KANJI_LEVEL4,  // 翔
	0x7FE1, KANJI_LEVEL4,  // 翡
	0x7FE6, KANJI_LEVEL4,  // 翦
	0x7FE9, KANJI_LEVEL4,  // 翩
	0x7FF3, KANJI_LEVEL4,  // 翳
	0x7FF9, KANJI_LEVEL4,  // 翹
	0x98DC, KANJI_LEVEL4,  // 飜
	0x8006, KANJI_LEVEL4,  // 耆
	0x8004, KANJI_LEVEL4,  // 耄
	0x800B, KANJI_LEVEL4,  // 耋
	0x8012, KANJI_LEVEL4,  // 耒
	0x8018, KANJI_LEVEL4,  // 耘
	0x8019, KANJI_LEVEL4,  // 耙
	0x801C, KANJI_LEVEL4,  // 耜
	0x8021, KANJI_LEVEL4,  // 耡
	0x8028, KANJI_LEVEL4,  // 耨
	0x803F, KANJI_LEVEL4,  // 耿
	0x803B, KANJI_LEVEL4,  // 耻
	0x804A, KANJI_LEVEL4,  // 聊
	0x8046, KANJI_LEVEL4,  // 聆
	0x8052, KANJI_LEVEL4,  // 聒
	0x8058, KANJI_LEVEL4,  // 聘
	0x805A, KANJI_LEVEL4,  // 聚
	0x805F, KANJI_LEVEL4,  // 聟
	0x8062, KANJI_LEVEL4,  // 聢
	0x8068, KANJI_LEVEL4,  // 聨
	0x8073, KANJI_LEVEL4,  // 聳
	0x8072, KANJI_LEVEL4,  // 聲
	0x8070, KANJI_LEVEL4,  // 聰
	0x8076, KANJI_LEVEL4,  // 聶
	0x8079, KANJI_LEVEL4,  // 聹
	0x807D, KANJI_LEVEL4,  // 聽
	0x807F, KANJI_LEVEL4,  // 聿
	0x8084, KANJI_LEVEL4,  // 肄
	0x8086, KANJI_LEVEL4,  // 肆
	0x8085, KANJI_LEVEL4,  // 肅
	0x809B, KANJI_LEVEL4,  // 肛
	0x8093, KANJI_LEVEL4,  // 肓
	0x809A, KANJI_LEVEL4,  // 肚
	0x80AD, KANJI_LEVEL4,  // 肭
	0x5190, KANJI_LEVEL4,  // 冐
	0x80AC, KANJI_LEVEL4,  // 肬
	0x80DB, KANJI_LEVEL4,  // 胛
	0x80E5, KANJI_LEVEL4,  // 胥
	0x80D9, KANJI_LEVEL4,  // 胙
	0x80DD, KANJI_LEVEL4,  // 胝
	0x80C4, KANJI_LEVEL4,  // 胄
	0x80DA, KANJI_LEVEL4,  // 胚
	0x80D6, KANJI_LEVEL4,  // 胖
	0x8109, KANJI_LEVEL4,  // 脉
	0x80EF, KANJI_LEVEL4,  // 胯
	0x80F1, KANJI_LEVEL4,  // 胱
	0x811B, KANJI_LEVEL4,  // 脛
	0x8129, KANJI_LEVEL4,  // 脩
	0x8123, KANJI_LEVEL4,  // 脣
	0x812F, KANJI_LEVEL4,  // 脯
	0x814B, KANJI_LEVEL4,  // 腋
	0x968B, KANJI_LEVEL4,  // 隋
	0x8146, KANJI_LEVEL4,  // 腆
	0x813E, KANJI_LEVEL4,  // 脾
	0x8153, KANJI_LEVEL4,  // 腓
	0x8151, KANJI_LEVEL4,  // 腑
	0x80FC, KANJI_LEVEL4,  // 胼
	0x8171, KANJI_LEVEL4,  // 腱
	0x816E, KANJI_LEVEL4,  // 腮
	0x8165, KANJI_LEVEL4,  // 腥
	0x8166, KANJI_LEVEL4,  // 腦
	0x8174, KANJI_LEVEL4,  // 腴
	0x8183, KANJI_LEVEL4,  // 膃
	0x8188, KANJI_LEVEL4,  // 膈
	0x818A, KANJI_LEVEL4,  // 膊
	0x8180, KANJI_LEVEL4,  // 膀
	0x8182, KANJI_LEVEL4,  // 膂
	0x81A0, KANJI_LEVEL4,  // 膠
	0x8195, KANJI_LEVEL4,  // 膕
	0x81A4, KANJI_LEVEL4,  // 膤
	0x81A3, KANJI_LEVEL4,  // 膣
	0x815F, KANJI_LEVEL4,  // 腟
	0x8193, KANJI_LEVEL4,  // 膓
	0x81A9, KANJI_LEVEL4,  // 膩
	0x81B0, KANJI_LEVEL4,  // 膰
	0x81B5, KANJI_LEVEL4,  // 膵
	0x81BE, KANJI_LEVEL4,  // 膾
	0x81B8, KANJI_LEVEL4,  // 膸
	0x81BD, KANJI_LEVEL4,  // 膽
	0x81C0, KANJI_LEVEL4,  // 臀
	0x81C2, KANJI_LEVEL4,  // 臂
	0x81BA, KANJI_LEVEL4,  // 膺
	0x81C9, KANJI_LEVEL4,  // 臉
	0x81CD, KANJI_LEVEL4,  // 臍
	0x81D1, KANJI_LEVEL4,  // 臑
	0x81D9, KANJI_LEVEL4,  // 臙
	0x81D8, KANJI_LEVEL4,  // 臘
	0x81C8, KANJI_LEVEL4,  // 臈
	0x81DA, KANJI_LEVEL4,  // 臚
	0x81DF, KANJI_LEVEL4,  // 臟
	0x81E0, KANJI_LEVEL4,  // 臠
	0x81E7, KANJI_LEVEL4,  // 臧
	0x81FA, KANJI_LEVEL4,  // 臺
	0x81FB, KANJI_LEVEL4,  // 臻
	0x81FE, KANJI_LEVEL4,  // 臾
	0x8201, KANJI_LEVEL4,  // 舁
	0x8202, KANJI_LEVEL4,  // 舂
	0x8205, KANJI_LEVEL4,  // 舅
	0x8207, KANJI_LEVEL4,  // 與
	0x820A, KANJI_LEVEL4,  // 舊
	0x820D, KANJI_LEVEL4,  // 舍
	0x8210, KANJI_LEVEL4,  // 舐
	0x8216, KANJI_LEVEL4,  // 舖
	0x8229, KANJI_LEVEL4,  // 舩
	0x822B, KANJI_LEVEL4,  // 舫
	0x8238, KANJI_LEVEL4,  // 舸
	0x8233, KANJI_LEVEL4,  // 舳
	0x8240, KANJI_LEVEL4,  // 艀
	0x8259, KANJI_LEVEL4,  // 艙
	0x8258, KANJI_LEVEL4,  // 艘
	0x825D, KANJI_LEVEL4,  // 艝
	0x825A, KANJI_LEVEL4,  // 艚
	0x825F, KANJI_LEVEL4,  // 艟
	0x8264, KANJI_LEVEL4,  // 艤
	0x8262, KANJI_LEVEL4,  // 艢
	0x8268, KANJI_LEVEL4,  // 艨
	0x826A, KANJI_LEVEL4,  // 艪
	0x826B, KANJI_LEVEL4,  // 艫
	0x822E, KANJI_LEVEL4,  // 舮
	0x8271, KANJI_LEVEL4,  // 艱
	0x8277, KANJI_LEVEL4,  // 艷
	0x8278, KANJI_LEVEL4,  // 艸
	0x827E, KANJI_LEVEL4,  // 艾
	0x828D, KANJI_LEVEL4,  // 芍
	0x8292, KANJI_LEVEL4,  // 芒
	0x82AB, KANJI_LEVEL4,  // 芫
	0x829F, KANJI_LEVEL4,  // 芟
	0x82BB, KANJI_LEVEL4,  // 芻
	0x82AC, KANJI_LEVEL4,  // 芬
	0x82E1, KANJI_LEVEL4,  // 苡
	0x82E3, KANJI_LEVEL4,  // 苣
	0x82DF, KANJI_LEVEL4,  // 苟
	0x82D2, KANJI_LEVEL4,  // 苒
	0x82F4, KANJI_LEVEL4,  // 苴
	0x82F3, KANJI_LEVEL4,  // 苳
	0x82FA, KANJI_LEVEL4,  // 苺
	0x8393, KANJI_LEVEL4,  // 莓
	0x8303, KANJI_LEVEL4,  // 范
	0x82FB, KANJI_LEVEL4,  // 苻
	0x82F9, KANJI_LEVEL4,  // 苹
	0x82DE, KANJI_LEVEL4,  // 苞
	0x8306, KANJI_LEVEL4,  // 茆
	0x82DC, KANJI_LEVEL4,  // 苜
	0x8309, KANJI_LEVEL4,  // 茉
	0x82D9, KANJI_LEVEL4,  // 苙
	0x8335, KANJI_LEVEL4,  // 茵
	0x8334, KANJI_LEVEL4,  // 茴
	0x8316, KANJI_LEVEL4,  // 茖
	0x8332, KANJI_LEVEL4,  // 茲
	0x8331, KANJI_LEVEL4,  // 茱
	0x8340, KANJI_LEVEL4,  // 荀
	0x8339, KANJI_LEVEL4,  // 茹
	0x8350, KANJI_LEVEL4,  // 荐
	0x8345, KANJI_LEVEL4,  // 荅
	0x832F, KANJI_LEVEL4,  // 茯
	0x832B, KANJI_LEVEL4,  // 茫
	0x8317, KANJI_LEVEL4,  // 茗
	0x8318, KANJI_LEVEL4,  // 茘
	0x8385, KANJI_LEVEL4,  // 莅
	0x839A, KANJI_LEVEL4,  // 莚
	0x83AA, KANJI_LEVEL4,  // 莪
	0x839F, KANJI_LEVEL4,  // 莟
	0x83A2, KANJI_LEVEL4,  // 莢
	0x8396, KANJI_LEVEL4,  // 莖
	0x8323, KANJI_LEVEL4,  // 茣
	0x838E, KANJI_LEVEL4,  // 莎
	0x8387, KANJI_LEVEL4,  // 莇
	0x838A, KANJI_LEVEL4,  // 莊
	0x837C, KANJI_LEVEL4,  // 荼
	0x83B5, KANJI_LEVEL4,  // 莵
	0x8373, KANJI_LEVEL4,  // 荳
	0x8375, KANJI_LEVEL4,  // 荵
	0x83A0, KANJI_LEVEL4,  // 莠
	0x8389, KANJI_LEVEL4,  // 莉
	0x83A8, KANJI_LEVEL4,  // 莨
	0x83F4, KANJI_LEVEL4,  // 菴
	0x8413, KANJI_LEVEL4,  // 萓
	0x83EB, KANJI_LEVEL4,  // 菫
	0x83CE, KANJI_LEVEL4,  // 菎
	0x83FD, KANJI_LEVEL4,  // 菽
	0x8403, KANJI_LEVEL4,  // 萃
	0x83D8, KANJI_LEVEL4,  // 菘
	0x840B, KANJI_LEVEL4,  // 萋
	0x83C1, KANJI_LEVEL4,  // 菁
	0x83F7, KANJI_LEVEL4,  // 菷
	0x8407, KANJI_LEVEL4,  // 萇
	0x83E0, KANJI_LEVEL4,  // 菠
	0x83F2, KANJI_LEVEL4,  // 菲
	0x840D, KANJI_LEVEL4,  // 萍
	0x8422, KANJI_LEVEL4,  // 萢
	0x8420, KANJI_LEVEL4,  // 萠
	0x83BD, KANJI_LEVEL4,  // 莽
	0x8438, KANJI_LEVEL4,  // 萸
	0x8506, KANJI_LEVEL4,  // 蔆
	0x83FB, KANJI_LEVEL4,  // 菻
	0x846D, KANJI_LEVEL4,  // 葭
	0x842A, KANJI_LEVEL4,  // 萪
	0x843C, KANJI_LEVEL4,  // 萼
	0x855A, KANJI_LEVEL4,  // 蕚
	0x8484, KANJI_LEVEL4,  // 蒄
	0x8477, KANJI_LEVEL4,  // 葷
	0x846B, KANJI_LEVEL4,  // 葫
	0x84AD, KANJI_LEVEL4,  // 蒭
	0x846E, KANJI_LEVEL4,  // 葮
	0x8482, KANJI_LEVEL4,  // 蒂
	0x8469, KANJI_LEVEL4,  // 葩
	0x8446, KANJI_LEVEL4,  // 葆
	0x842C, KANJI_LEVEL4,  // 萬
	0x846F, KANJI_LEVEL4,  // 葯
	0x8479, KANJI_LEVEL4,  // 葹
	0x8435, KANJI_LEVEL4,  // 萵
	0x84CA, KANJI_LEVEL4,  // 蓊
	0x8462, KANJI_LEVEL4,  // 葢
	0x84B9, KANJI_LEVEL4,  // 蒹
	0x84BF, KANJI_LEVEL4,  // 蒿
	0x849F, KANJI_LEVEL4,  // 蒟
	0x84D9, KANJI_LEVEL4,  // 蓙
	0x84CD, KANJI_LEVEL4,  // 蓍
	0x84BB, KANJI_LEVEL4,  // 蒻
	0x84DA, KANJI_LEVEL4,  // 蓚
	0x84D0, KANJI_LEVEL4,  // 蓐
	0x84C1, KANJI_LEVEL4,  // 蓁
	0x84C6, KANJI_LEVEL4,  // 蓆
	0x84D6, KANJI_LEVEL4,  // 蓖
	0x84A1, KANJI_LEVEL4,  // 蒡
	0x8521, KANJI_LEVEL4,  // 蔡
	0x84FF, KANJI_LEVEL4,  // 蓿
	0x84F4, KANJI_LEVEL4,  // 蓴
	0x8517, KANJI_LEVEL4,  // 蔗
	0x8518, KANJI_LEVEL4,  // 蔘
	0x852C, KANJI_LEVEL4,  // 蔬
	0x851F, KANJI_LEVEL4,  // 蔟
	0x8515, KANJI_LEVEL4,  // 蔕
	0x8514, KANJI_LEVEL4,  // 蔔
	0x84FC, KANJI_LEVEL4,  // 蓼
	0x8540, KANJI_LEVEL4,  // 蕀
	0x8563, KANJI_LEVEL4,  // 蕣
	0x8558, KANJI_LEVEL4,  // 蕘
	0x8548, KANJI_LEVEL4,  // 蕈
	0x8541, KANJI_LEVEL4,  // 蕁
	0x8602, KANJI_LEVEL4,  // 蘂
	0x854B, KANJI_LEVEL4,  // 蕋
	0x8555, KANJI_LEVEL4,  // 蕕
	0x8580, KANJI_LEVEL4,  // 薀
	0x85A4, KANJI_LEVEL4,  // 薤
	0x8588, KANJI_LEVEL4,  // 薈
	0x8591, KANJI_LEVEL4,  // 薑
	0x858A, KANJI_LEVEL4,  // 薊
	0x85A8, KANJI_LEVEL4,  // 薨
	0x856D, KANJI_LEVEL4,  // 蕭
	0x8594, KANJI_LEVEL4,  // 薔
	0x859B, KANJI_LEVEL4,  // 薛
	0x85EA, KANJI_LEVEL4,  // 藪
	0x8587, KANJI_LEVEL4,  // 薇
	0x859C, KANJI_LEVEL4,  // 薜
	0x8577, KANJI_LEVEL4,  // 蕷
	0x857E, KANJI_LEVEL4,  // 蕾
	0x8590, KANJI_LEVEL4,  // 薐
	0x85C9, KANJI_LEVEL4,  // 藉
	0x85BA, KANJI_LEVEL4,  // 薺
	0x85CF, KANJI_LEVEL4,  // 藏
	0x85B9, KANJI_LEVEL4,  // 薹
	0x85D0, KANJI_LEVEL4,  // 藐
	0x85D5, KANJI_LEVEL4,  // 藕
	0x85DD, KANJI_LEVEL4,  // 藝
	0x85E5, KANJI_LEVEL4,  // 藥
	0x85DC, KANJI_LEVEL4,  // 藜
	0x85F9, KANJI_LEVEL4,  // 藹
	0x860A, KANJI_LEVEL4,  // 蘊
	0x8613, KANJI_LEVEL4,  // 蘓
	0x860B, KANJI_LEVEL4,  // 蘋
	0x85FE, KANJI_LEVEL4,  // 藾
	0x85FA, KANJI_LEVEL4,  // 藺
	0x8606, KANJI_LEVEL4,  // 蘆
	0x8622, KANJI_LEVEL4,  // 蘢
	0x861A, KANJI_LEVEL4,  // 蘚
	0x8630, KANJI_LEVEL4,  // 蘰
	0x863F, KANJI_LEVEL4,  // 蘿
	0x864D, KANJI_LEVEL4,  // 虍
	0x4E55, KANJI_LEVEL4,  // 乕
	0x8654, KANJI_LEVEL4,  // 虔
	0x865F, KANJI_LEVEL4,  // 號
	0x8667, KANJI_LEVEL4,  // 虧
	0x8671, KANJI_LEVEL4,  // 虱
	0x8693, KANJI_LEVEL4,  // 蚓
	0x86A3, KANJI_LEVEL4,  // 蚣
	0x86A9, KANJI_LEVEL4,  // 蚩
	0x86AA, KANJI_LEVEL4,  // 蚪
	0x868B, KANJI_LEVEL4,  // 蚋
	0x868C, KANJI_LEVEL4,  // 蚌
	0x86B6, KANJI_LEVEL4,  // 蚶
	0x86AF, KANJI_LEVEL4,  // 蚯
	0x86C4, KANJI_LEVEL4,  // 蛄
	0x86C6, KANJI_LEVEL4,  // 蛆
	0x86B0, KANJI_LEVEL4,  // 蚰
	0x86C9, KANJI_LEVEL4,  // 蛉
	0x8823, KANJI_LEVEL4,  // 蠣
	0x86AB, KANJI_LEVEL4,  // 蚫
	0x86D4, KANJI_LEVEL4,  // 蛔
	0x86DE, KANJI_LEVEL4,  // 蛞
	0x86E9, KANJI_LEVEL4,  // 蛩
	0x86EC, KANJI_LEVEL4,  // 蛬
	0x86DF, KANJI_LEVEL4,  // 蛟
	0x86DB, KANJI_LEVEL4,  // 蛛
	0x86EF, KANJI_LEVEL4,  // 蛯
	0x8712, KANJI_LEVEL4,  // 蜒
	0x8706, KANJI_LEVEL4,  // 蜆
	0x8708, KANJI_LEVEL4,  // 蜈
	0x8700, KANJI_LEVEL4,  // 蜀
	0x8703, KANJI_LEVEL4,  // 蜃
	0x86FB, KANJI_LEVEL4,  // 蛻
	0x8711, KANJI_LEVEL4,  // 蜑
	0x8709, KANJI_LEVEL4,  // 蜉
	0x870D, KANJI_LEVEL4,  // 蜍
	0x86F9, KANJI_LEVEL4,  // 蛹
	0x870A, KANJI_LEVEL4,  // 蜊
	0x8734, KANJI_LEVEL4,  // 蜴
	0x873F, KANJI_LEVEL4,  // 蜿
	0x8737, KANJI_LEVEL4,  // 蜷
	0x873B, KANJI_LEVEL4,  // 蜻
	0x8725, KANJI_LEVEL4,  // 蜥
	0x8729, KANJI_LEVEL4,  // 蜩
	0x871A, KANJI_LEVEL4,  // 蜚
	0x8760, KANJI_LEVEL4,  // 蝠
	0x875F, KANJI_LEVEL4,  // 蝟
	0x8778, KANJI_LEVEL4,  // 蝸
	0x874C, KANJI_LEVEL4,  // 蝌
	0x874E, KANJI_LEVEL4,  // 蝎
	0x8774, KANJI_LEVEL4,  // 蝴
	0x8757, KANJI_LEVEL4,  // 蝗
	0x8768, KANJI_LEVEL4,  // 蝨
	0x876E, KANJI_LEVEL4,  // 蝮
	0x8759, KANJI_LEVEL4,  // 蝙
	0x8753, KANJI_LEVEL4,  // 蝓
	0x8763, KANJI_LEVEL4,  // 蝣
	0x876A, KANJI_LEVEL4,  // 蝪
	0x8805, KANJI_LEVEL4,  // 蠅
	0x87A2, KANJI_LEVEL4,  // 螢
	0x879F, KANJI_LEVEL4,  // 螟
	0x8782, KANJI_LEVEL4,  // 螂
	0x87AF, KANJI_LEVEL4,  // 螯
	0x87CB, KANJI_LEVEL4,  // 蟋
	0x87BD, KANJI_LEVEL4,  // 螽
	0x87C0, KANJI_LEVEL4,  // 蟀
	0x87D0, KANJI_LEVEL4,  // 蟐
	0x96D6, KANJI_LEVEL4,  // 雖
	0x87AB, KANJI_LEVEL4,  // 螫
	0x87C4, KANJI_LEVEL4,  // 蟄
	0x87B3, KANJI_LEVEL4,  // 螳
	0x87C7, KANJI_LEVEL4,  // 蟇
	0x87C6, KANJI_LEVEL4,  // 蟆
	0x87BB, KANJI_LEVEL4,  // 螻
	0x87EF, KANJI_LEVEL4,  // 蟯
	0x87F2, KANJI_LEVEL4,  // 蟲
	0x87E0, KANJI_LEVEL4,  // 蟠
	0x880F, KANJI_LEVEL4,  // 蠏
	0x880D, KANJI_LEVEL4,  // 蠍
	0x87FE, KANJI_LEVEL4,  // 蟾
	0x87F6, KANJI_LEVEL4,  // 蟶
	0x87F7, KANJI_LEVEL4,  // 蟷
	0x880E, KANJI_LEVEL4,  // 蠎
	0x87D2, KANJI_LEVEL4,  // 蟒
	0x8811, KANJI_LEVEL4,  // 蠑
	0x8816, KANJI_LEVEL4,  // 蠖
	0x8815, KANJI_LEVEL4,  // 蠕
	0x8822, KANJI_LEVEL4,  // 蠢
	0x8821, KANJI_LEVEL4,  // 蠡
	0x8831, KANJI_LEVEL4,  // 蠱
	0x8836, KANJI_LEVEL4,  // 蠶
	0x8839, KANJI_LEVEL4,  // 蠹
	0x8827, KANJI_LEVEL4,  // 蠧
	0x883B, KANJI_LEVEL4,  // 蠻
	0x8844, KANJI_LEVEL4,  // 衄
	0x8842, KANJI_LEVEL4,  // 衂
	0x8852, KANJI_LEVEL4,  // 衒
	0x8859, KANJI_LEVEL4,  // 衙
	0x885E, KANJI_LEVEL4,  // 衞
	0x8862, KANJI_LEVEL4,  // 衢
	0x886B, KANJI_LEVEL4,  // 衫
	0x8881, KANJI_LEVEL4,  // 袁
	0x887E, KANJI_LEVEL4,  // 衾
	0x889E, KANJI_LEVEL4,  // 袞
	0x8875, KANJI_LEVEL4,  // 衵
	0x887D, KANJI_LEVEL4,  // 衽
	0x88B5, KANJI_LEVEL4,  // 袵
	0x8872, KANJI_LEVEL4,  // 衲
	0x8882, KANJI_LEVEL4,  // 袂
	0x8897, KANJI_LEVEL4,  // 袗
	0x8892, KANJI_LEVEL4,  // 袒
	0x88AE, KANJI_LEVEL4,  // 袮
	0x8899, KANJI_LEVEL4,  // 袙
	0x88A2, KANJI_LEVEL4,  // 袢
	0x888D, KANJI_LEVEL4,  // 袍
	0x88A4, KANJI_LEVEL4,  // 袤
	0x88B0, KANJI_LEVEL4,  // 袰
	0x88BF, KANJI_LEVEL4,  // 袿
	0x88B1, KANJI_LEVEL4,  // 袱
	0x88C3, KANJI_LEVEL4,  // 裃
	0x88C4, KANJI_LEVEL4,  // 裄
	0x88D4, KANJI_LEVEL4,  // 裔
	0x88D8, KANJI_LEVEL4,  // 裘
	0x88D9, KANJI_LEVEL4,  // 裙
	0x88DD, KANJI_LEVEL4,  // 裝
	0x88F9, KANJI_LEVEL4,  // 裹
	0x8902, KANJI_LEVEL4,  // 褂
	0x88FC, KANJI_LEVEL4,  // 裼
	0x88F4, KANJI_LEVEL4,  // 裴
	0x88E8, KANJI_LEVEL4,  // 裨
	0x88F2, KANJI_LEVEL4,  // 裲
	0x8904, KANJI_LEVEL4,  // 褄
	0x890C, KANJI_LEVEL4,  // 褌
	0x890A, KANJI_LEVEL4,  // 褊
	0x8913, KANJI_LEVEL4,  // 褓
	0x8943, KANJI_LEVEL4,  // 襃
	0x891E, KANJI_LEVEL4,  // 褞
	0x8925, KANJI_LEVEL4,  // 褥
	0x892A, KANJI_LEVEL4,  // 褪
	0x892B, KANJI_LEVEL4,  // 褫
	0x8941, KANJI_LEVEL4,  // 襁
	0x8944, KANJI_LEVEL4,  // 襄
	0x893B, KANJI_LEVEL4,  // 褻
	0x8936, KANJI_LEVEL4,  // 褶
	0x8938, KANJI_LEVEL4,  // 褸
	0x894C, KANJI_LEVEL4,  // 襌
	0x891D, KANJI_LEVEL4,  // 褝
	0x8960, KANJI_LEVEL4,  // 襠
	0x895E, KANJI_LEVEL4,  // 襞
	0x8966, KANJI_LEVEL4,  // 襦
	0x8964, KANJI_LEVEL4,  // 襤
	0x896D, KANJI_LEVEL4,  // 襭
	0x896A, KANJI_LEVEL4,  // 襪
	0x896F, KANJI_LEVEL4,  // 襯
	0x8974, KANJI_LEVEL4,  // 襴
	0x8977, KANJI_LEVEL4,  // 襷
	0x897E, KANJI_LEVEL4,  // 襾
	0x8983, KANJI_LEVEL4,  // 覃
	0x8988, KANJI_LEVEL4,  // 覈
	0x898A, KANJI_LEVEL4,  // 覊
	0x8993, KANJI_LEVEL4,  // 覓
	0x8998, KANJI_LEVEL4,  // 覘
	0x89A1, KANJI_LEVEL4,  // 覡
	0x89A9, KANJI_LEVEL4,  // 覩
	0x89A6, KANJI_LEVEL4,  // 覦
	0x89AC, KANJI_LEVEL4,  // 覬
	0x89AF, KANJI_LEVEL4,  // 覯
	0x89B2, KANJI_LEVEL4,  // 覲
	0x89BA, KANJI_LEVEL4,  // 覺
	0x89BD, KANJI_LEVEL4,  // 覽
	0x89BF, KANJI_LEVEL4,  // 覿
	0x89C0, KANJI_LEVEL4,  // 觀
	0x89DA, KANJI_LEVEL4,  // 觚
	0x89DC, KANJI_LEVEL4,  // 觜
	0x89DD, KANJI_LEVEL4,  // 觝
	0x89E7, KANJI_LEVEL4,  // 觧
	0x89F4, KANJI_LEVEL4,  // 觴
	0x89F8, KANJI_LEVEL4,  // 觸
	0x8A03, KANJI_LEVEL4,  // 訃
	0x8A16, KANJI_LEVEL4,  // 訖
	0x8A10, KANJI_LEVEL4,  // 訐
	0x8A0C, KANJI_LEVEL4,  // 訌
	0x8A1B, KANJI_LEVEL4,  // 訛
	0x8A1D, KANJI_LEVEL4,  // 訝
	0x8A25, KANJI_LEVEL4,  // 訥
	0x8A36, KANJI_LEVEL4,  // 訶
	0x8A41, KANJI_LEVEL4,  // 詁
	0x8A5B, KANJI_LEVEL4,  // 詛
	0x8A52, KANJI_LEVEL4,  // 詒
	0x8A46, KANJI_LEVEL4,  // 詆
	0x8A48, KANJI_LEVEL4,  // 詈
	0x8A7C, KANJI_LEVEL4,  // 詼
	0x8A6D, KANJI_LEVEL4,  // 詭
	0x8A6C, KANJI_LEVEL4,  // 詬
	0x8A62, KANJI_LEVEL4,  // 詢
	0x8A85, KANJI_LEVEL4,  // 誅
	0x8A82, KANJI_LEVEL4,  // 誂
	0x8A84, KANJI_LEVEL4,  // 誄
	0x8AA8, KANJI_LEVEL4,  // 誨
	0x8AA1, KANJI_LEVEL4,  // 誡
	0x8A91, KANJI_LEVEL4,  // 誑
	0x8AA5, KANJI_LEVEL4,  // 誥
	0x8AA6, KANJI_LEVEL4,  // 誦
	0x8A9A, KANJI_LEVEL4,  // 誚
	0x8AA3, KANJI_LEVEL4,  // 誣
	0x8AC4, KANJI_LEVEL4,  // 諄
	0x8ACD, KANJI_LEVEL4,  // 諍
	0x8AC2, KANJI_LEVEL4,  // 諂
	0x8ADA, KANJI_LEVEL4,  // 諚
	0x8AEB, KANJI_LEVEL4,  // 諫
	0x8AF3, KANJI_LEVEL4,  // 諳
	0x8AE7, KANJI_LEVEL4,  // 諧
	0x8AE4, KANJI_LEVEL4,  // 諤
	0x8AF1, KANJI_LEVEL4,  // 諱
	0x8B14, KANJI_LEVEL4,  // 謔
	0x8AE0, KANJI_LEVEL4,  // 諠
	0x8AE2, KANJI_LEVEL4,  // 諢
	0x8AF7, KANJI_LEVEL4,  // 諷
	0x8ADE, KANJI_LEVEL4,  // 諞
	0x8ADB, KANJI_LEVEL4,  // 諛
	0x8B0C, KANJI_LEVEL4,  // 謌
	0x8B07, KANJI_LEVEL4,  // 謇
	0x8B1A, KANJI_LEVEL4,  // 謚
	0x8AE1, KANJI_LEVEL4,  // 諡
	0x8B16, KANJI_LEVEL4,  // 謖
	0x8B10, KANJI_LEVEL4,  // 謐
	0x8B17, KANJI_LEVEL4,  // 謗
	0x8B20, KANJI_LEVEL4,  // 謠
	0x8B33, KANJI_LEVEL4,  // 謳
	0x97AB, KANJI_LEVEL4,  // 鞫
	0x8B26, KANJI_LEVEL4,  // 謦
	0x8B2B, KANJI_LEVEL4,  // 謫
	0x8B3E, KANJI_LEVEL4,  // 謾
	0x8B28, KANJI_LEVEL4,  // 謨
	0x8B41, KANJI_LEVEL4,  // 譁
	0x8B4C, KANJI_LEVEL4,  // 譌
	0x8B4F, KANJI_LEVEL4,  // 譏
	0x8B4E, KANJI_LEVEL4,  // 譎
	0x8B49, KANJI_LEVEL4,  // 證
	0x8B56, KANJI_LEVEL4,  // 譖
	0x8B5B, KANJI_LEVEL4,  // 譛
	0x8B5A, KANJI_LEVEL4,  // 譚
	0x8B6B, KANJI_LEVEL4,  // 譫
	0x8B5F, KANJI_LEVEL4,  // 譟
	0x8B6C, KANJI_LEVEL4,  // 譬
	0x8B6F, KANJI_LEVEL4,  // 譯
	0x8B74, KANJI_LEVEL4,  // 譴
	0x8B7D, KANJI_LEVEL4,  // 譽
	0x8B80, KANJI_LEVEL4,  // 讀
	0x8B8C, KANJI_LEVEL4,  // 讌
	0x8B8E, KANJI_LEVEL4,  // 讎
	0x8B92, KANJI_LEVEL4,  // 讒
	0x8B93, KANJI_LEVEL4,  // 讓
	0x8B96, KANJI_LEVEL4,  // 讖
	0x8B99, KANJI_LEVEL4,  // 讙
	0x8B9A, KANJI_LEVEL4,  // 讚
	0x8C3A, KANJI_LEVEL4,  // 谺
	0x8C41, KANJI_LEVEL4,  // 豁
	0x8C3F, KANJI_LEVEL4,  // 谿
	0x8C48, KANJI_LEVEL4,  // 豈
	0x8C4C, KANJI_LEVEL4,  // 豌
	0x8C4E, KANJI_LEVEL4,  // 豎
	0x8C50, KANJI_LEVEL4,  // 豐
	0x8C55, KANJI_LEVEL4,  // 豕
	0x8C62, KANJI_LEVEL4,  // 豢
	0x8C6C, KANJI_LEVEL4,  // 豬
	0x8C78, KANJI_LEVEL4,  // 豸
	0x8C7A, KANJI_LEVEL4,  // 豺
	0x8C82, KANJI_LEVEL4,  // 貂
	0x8C89, KANJI_LEVEL4,  // 貉
	0x8C85, KANJI_LEVEL4,  // 貅
	0x8C8A, KANJI_LEVEL4,  // 貊
	0x8C8D, KANJI_LEVEL4,  // 貍
	0x8C8E, KANJI_LEVEL4,  // 貎
	0x8C94, KANJI_LEVEL4,  // 貔
	0x8C7C, KANJI_LEVEL4,  // 豼
	0x8C98, KANJI_LEVEL4,  // 貘
	0x621D, KANJI_LEVEL4,  // 戝
	0x8CAD, KANJI_LEVEL4,  // 貭
	0x8CAA, KANJI_LEVEL4,  // 貪
	0x8CBD, KANJI_LEVEL4,  // 貽
	0x8CB2, KANJI_LEVEL4,  // 貲
	0x8CB3, KANJI_LEVEL4,  // 貳
	0x8CAE, KANJI_LEVEL4,  // 貮
	0x8CB6, KANJI_LEVEL4,  // 貶
	0x8CC8, KANJI_LEVEL4,  // 賈
	0x8CC1, KANJI_LEVEL4,  // 賁
	0x8CE4, KANJI_LEVEL4,  // 賤
	0x8CE3, KANJI_LEVEL4,  // 賣
	0x8CDA, KANJI_LEVEL4,  // 賚
	0x8CFD, KANJI_LEVEL4,  // 賽
	0x8CFA, KANJI_LEVEL4,  // 賺
	0x8CFB, KANJI_LEVEL4,  // 賻
	0x8D04, KANJI_LEVEL4,  // 贄
	0x8D05, KANJI_LEVEL4,  // 贅
	0x8D0A, KANJI_LEVEL4,  // 贊
	0x8D07, KANJI_LEVEL4,  // 贇
	0x8D0F, KANJI_LEVEL4,  // 贏
	0x8D0D, KANJI_LEVEL4,  // 贍
	0x8D10, KANJI_LEVEL4,  // 贐
	0x9F4E, KANJI_LEVEL4,  // 齎
	0x8D13, KANJI_LEVEL4,  // 贓
	0x8CCD, KANJI_LEVEL4,  // 賍
	0x8D14, KANJI_LEVEL4,  // 贔
	0x8D16, KANJI_LEVEL4,  // 贖
	0x8D67, KANJI_LEVEL4,  // 赧
	0x8D6D, KANJI_LEVEL4,  // 赭
	0x8D71, KANJI_LEVEL4,  // 赱
	0x8D73, KANJI_LEVEL4,  // 赳
	0x8D81, KANJI_LEVEL4,  // 趁
	0x8D99, KANJI_LEVEL4,  // 趙
	0x8DC2, KANJI_LEVEL4,  // 跂
	0x8DBE, KANJI_LEVEL4,  // 趾
	0x8DBA, KANJI_LEVEL4,  // 趺
	0x8DCF, KANJI_LEVEL4,  // 跏
	0x8DDA, KANJI_LEVEL4,  // 跚
	0x8DD6, KANJI_LEVEL4,  // 跖
	0x8DCC, KANJI_LEVEL4,  // 跌
	0x8DDB, KANJI_LEVEL4,  // 跛
	0x8DCB, KANJI_LEVEL4,  // 跋
	0x8DEA, KANJI_LEVEL4,  // 跪
	0x8DEB, KANJI_LEVEL4,  // 跫
	0x8DDF, KANJI_LEVEL4,  // 跟
	0x8DE3, KANJI_LEVEL4,  // 跣
	0x8DFC, KANJI_LEVEL4,  // 跼
	0x8E08, KANJI_LEVEL4,  // 踈
	0x8E09, KANJI_LEVEL4,  // 踉
	0x8DFF, KANJI_LEVEL4,  // 跿
	0x8E1D, KANJI_LEVEL4,  // 踝
	0x8E1E, KANJI_LEVEL4,  // 踞
	0x8E10, KANJI_LEVEL4,  // 踐
	0x8E1F, KANJI_LEVEL4,  // 踟
	0x8E42, KANJI_LEVEL4,  // 蹂
	0x8E35, KANJI_LEVEL4,  // 踵
	0x8E30, KANJI_LEVEL4,  // 踰
	0x8E34, KANJI_LEVEL4,  // 踴
	0x8E4A, KANJI_LEVEL4,  // 蹊
	0x8E47, KANJI_LEVEL4,  // 蹇
	0x8E49, KANJI_LEVEL4,  // 蹉
	0x8E4C, KANJI_LEVEL4,  // 蹌
	0x8E50, KANJI_LEVEL4,  // 蹐
	0x8E48, KANJI_LEVEL4,  // 蹈
	0x8E59, KANJI_LEVEL4,  // 蹙
	0x8E64, KANJI_LEVEL4,  // 蹤
	0x8E60, KANJI_LEVEL4,  // 蹠
	0x8E2A, KANJI_LEVEL4,  // 踪
	0x8E63, KANJI_LEVEL4,  // 蹣
	0x8E55, KANJI_LEVEL4,  // 蹕
	0x8E76, KANJI_LEVEL4,  // 蹶
	0x8E72, KANJI_LEVEL4,  // 蹲
	0x8E7C, KANJI_LEVEL4,  // 蹼
	0x8E81, KANJI_LEVEL4,  // 躁
	0x8E87, KANJI_LEVEL4,  // 躇
	0x8E85, KANJI_LEVEL4,  // 躅
	0x8E84, KANJI_LEVEL4,  // 躄
	0x8E8B, KANJI_LEVEL4,  // 躋
	0x8E8A, KANJI_LEVEL4,  // 躊
	0x8E93, KANJI_LEVEL4,  // 躓
	0x8E91, KANJI_LEVEL4,  // 躑
	0x8E94, KANJI_LEVEL4,  // 躔
	0x8E99, KANJI_LEVEL4,  // 躙
	0x8EAA, KANJI_LEVEL4,  // 躪
	0x8EA1, KANJI_LEVEL4,  // 躡
	0x8EAC, KANJI_LEVEL4,  // 躬
	0x8EB0, KANJI_LEVEL4,  // 躰
	0x8EC6, KANJI_LEVEL4,  // 軆
	0x8EB1, KANJI_LEVEL4,  // 躱
	0x8EBE, KANJI_LEVEL4,  // 躾
	0x8EC5, KANJI_LEVEL4,  // 軅
	0x8EC8, KANJI_LEVEL4,  // 軈
	0x8ECB, KANJI_LEVEL4,  // 軋
	0x8EDB, KANJI_LEVEL4,  // 軛
	0x8EE3, KANJI_LEVEL4,  // 軣
	0x8EFC, KANJI_LEVEL4,  // 軼
	0x8EFB, KANJI_LEVEL4,  // 軻
	0x8EEB, KANJI_LEVEL4,  // 軫
	0x8EFE, KANJI_LEVEL4,  // 軾
	0x8F0A, KANJI_LEVEL4,  // 輊
	0x8F05, KANJI_LEVEL4,  // 輅
	0x8F15, KANJI_LEVEL4,  // 輕
	0x8F12, KANJI_LEVEL4,  // 輒
	0x8F19, KANJI_LEVEL4,  // 輙
	0x8F13, KANJI_LEVEL4,  // 輓
	0x8F1C, KANJI_LEVEL4,  // 輜
	0x8F1F, KANJI_LEVEL4,  // 輟
	0x8F1B, KANJI_LEVEL4,  // 輛
	0x8F0C, KANJI_LEVEL4,  // 輌
	0x8F26, KANJI_LEVEL4,  // 輦
	0x8F33, KANJI_LEVEL4,  // 輳
	0x8F3B, KANJI_LEVEL4,  // 輻
	0x8F39, KANJI_LEVEL4,  // 輹
	0x8F45, KANJI_LEVEL4,  // 轅
	0x8F42, KANJI_LEVEL4,  // 轂
	0x8F3E, KANJI_LEVEL4,  // 輾
	0x8F4C, KANJI_LEVEL4,  // 轌
	0x8F49, KANJI_LEVEL4,  // 轉
	0x8F46, KANJI_LEVEL4,  // 轆
	0x8F4E, KANJI_LEVEL4,  // 轎
	0x8F57, KANJI_LEVEL4,  // 轗
	0x8F5C, KANJI_LEVEL4,  // 轜
	0x8F62, KANJI_LEVEL4,  // 轢
	0x8F63, KANJI_LEVEL4,  // 轣
	0x8F64, KANJI_LEVEL4,  // 轤
	0x8F9C, KANJI_LEVEL4,  // 辜
	0x8F9F, KANJI_LEVEL4,  // 辟
	0x8FA3, KANJI_LEVEL4,  // 辣
	0x8FAD, KANJI_LEVEL4,  // 辭
	0x8FAF, KANJI_LEVEL4,  // 辯
	0x8FB7, KANJI_LEVEL4,  // 辷
	0x8FDA, KANJI_LEVEL4,  // 迚
	0x8FE5, KANJI_LEVEL4,  // 迥
	0x8FE2, KANJI_LEVEL4,  // 迢
	0x8FEA, KANJI_LEVEL4,  // 迪
	0x8FEF, KANJI_LEVEL4,  // 迯
	0x9087, KANJI_LEVEL4,  // 邇
	0x8FF4, KANJI_LEVEL4,  // 迴
	0x9005, KANJI_LEVEL4,  // 逅
	0x8FF9, KANJI_LEVEL4,  // 迹
	0x8FFA, KANJI_LEVEL4,  // 迺
	0x9011, KANJI_LEVEL4,  // 逑
	0x9015, KANJI_LEVEL4,  // 逕
	0x9021, KANJI_LEVEL4,  // 逡
	0x900D, KANJI_LEVEL4,  // 逍
	0x901E, KANJI_LEVEL4,  // 逞
	0x9016, KANJI_LEVEL4,  // 逖
	0x900B, KANJI_LEVEL4,  // 逋
	0x9027, KANJI_LEVEL4,  // 逧
	0x9036, KANJI_LEVEL4,  // 逶
	0x9035, KANJI_LEVEL4,  // 逵
	0x9039, KANJI_LEVEL4,  // 逹
	0x8FF8, KANJI_LEVEL4,  // 迸
	0x904F, KANJI_LEVEL4,  // 遏
	0x9050, KANJI_LEVEL4,  // 遐
	0x9051, KANJI_LEVEL4,  // 遑
	0x9052, KANJI_LEVEL4,  // 遒
	0x900E, KANJI_LEVEL4,  // 逎
	0x9049, KANJI_LEVEL4,  // 遉
	0x903E, KANJI_LEVEL4,  // 逾
	0x9056, KANJI_LEVEL4,  // 遖
	0x9058, KANJI_LEVEL4,  // 遘
	0x905E, KANJI_LEVEL4,  // 遞
	0x9068, KANJI_LEVEL4,  // 遨
	0x906F, KANJI_LEVEL4,  // 遯
	0x9076, KANJI_LEVEL4,  // 遶
	0x96A8, KANJI_LEVEL4,  // 隨
	0x9072, KANJI_LEVEL4,  // 遲
	0x9082, KANJI_LEVEL4,  // 邂
	0x907D, KANJI_LEVEL4,  // 遽
	0x9081, KANJI_LEVEL4,  // 邁
	0x9080, KANJI_LEVEL4,  // 邀
	0x908A, KANJI_LEVEL4,  // 邊
	0x9089, KANJI_LEVEL4,  // 邉
	0x908F, KANJI_LEVEL4,  // 邏
	0x90A8, KANJI_LEVEL4,  // 邨
	0x90AF, KANJI_LEVEL4,  // 邯
	0x90B1, KANJI_LEVEL4,  // 邱
	0x90B5, KANJI_LEVEL4,  // 邵
	0x90E2, KANJI_LEVEL4,  // 郢
	0x90E4, KANJI_LEVEL4,  // 郤
	0x6248, KANJI_LEVEL4,  // 扈
	0x90DB, KANJI_LEVEL4,  // 郛
	0x9102, KANJI_LEVEL4,  // 鄂
	0x9112, KANJI_LEVEL4,  // 鄒
	0x9119, KANJI_LEVEL4,  // 鄙
	0x9132, KANJI_LEVEL4,  // 鄲
	0x9130, KANJI_LEVEL4,  // 鄰
	0x914A, KANJI_LEVEL4,  // 酊
	0x9156, KANJI_LEVEL4,  // 酖
	0x9158, KANJI_LEVEL4,  // 酘
	0x9163, KANJI_LEVEL4,  // 酣
	0x9165, KANJI_LEVEL4,  // 酥
	0x9169, KANJI_LEVEL4,  // 酩
	0x9173, KANJI_LEVEL4,  // 酳
	0x9172, KANJI_LEVEL4,  // 酲
	0x918B, KANJI_LEVEL4,  // 醋
	0x9189, KANJI_LEVEL4,  // 醉
	0x9182, KANJI_LEVEL4,  // 醂
	0x91A2, KANJI_LEVEL4,  // 醢
	0x91AB, KANJI_LEVEL4,  // 醫
	0x91AF, KANJI_LEVEL4,  // 醯
	0x91AA, KANJI_LEVEL4,  // 醪
	0x91B5, KANJI_LEVEL4,  // 醵
	0x91B4, KANJI_LEVEL4,  // 醴
	0x91BA, KANJI_LEVEL4,  // 醺
	0x91C0, KANJI_LEVEL4,  // 釀
	0x91C1, KANJI_LEVEL4,  // 釁
	0x91C9, KANJI_LEVEL4,  // 釉
	0x91CB, KANJI_LEVEL4,  // 釋
	0x91D0, KANJI_LEVEL4,  // 釐
	0x91D6, KANJI_LEVEL4,  // 釖
	0x91DF, KANJI_LEVEL4,  // 釟
	0x91E1, KANJI_LEVEL4,  // 釡
	0x91DB, KANJI_LEVEL4,  // 釛
	0x91FC, KANJI_LEVEL4,  // 釼
	0x91F5, KANJI_LEVEL4,  // 釵
	0x91F6, KANJI_LEVEL4,  // 釶
	0x921E, KANJI_LEVEL4,  // 鈞
	0x91FF, KANJI_LEVEL4,  // 釿
	0x9214, KANJI_LEVEL4,  // 鈔
	0x922C, KANJI_LEVEL4,  // 鈬
	0x9215, KANJI_LEVEL4,  // 鈕
	0x9211, KANJI_LEVEL4,  // 鈑
	0x925E, KANJI_LEVEL4,  // 鉞
	0x9257, KANJI_LEVEL4,  // 鉗
	0x9245, KANJI_LEVEL4,  // 鉅
	0x9249, KANJI_LEVEL4,  // 鉉
	0x9264, KANJI_LEVEL4,  // 鉤
	0x9248, KANJI_LEVEL4,  // 鉈
	0x9295, KANJI_LEVEL4,  // 銕
	0x923F, KANJI_LEVEL4,  // 鈿
	0x924B, KANJI_LEVEL4,  // 鉋
	0x9250, KANJI_LEVEL4,  // 鉐
	0x929C, KANJI_LEVEL4,  // 銜
	0x9296, KANJI_LEVEL4,  // 銖
	0x9293, KANJI_LEVEL4,  // 銓
	0x929B, KANJI_LEVEL4,  // 銛
	0x925A, KANJI_LEVEL4,  // 鉚
	0x92CF, KANJI_LEVEL4,  // 鋏
	0x92B9, KANJI_LEVEL4,  // 銹
	0x92B7, KANJI_LEVEL4,  // 銷
	0x92E9, KANJI_LEVEL4,  // 鋩
	0x930F, KANJI_LEVEL4,  // 錏
	0x92FA, KANJI_LEVEL4,  // 鋺
	0x9344, KANJI_LEVEL4,  // 鍄
	0x932E, KANJI_LEVEL4,  // 錮
	0x9319, KANJI_LEVEL4,  // 錙
	0x9322, KANJI_LEVEL4,  // 錢
	0x931A, KANJI_LEVEL4,  // 錚
	0x9323, KANJI_LEVEL4,  // 錣
	0x933A, KANJI_LEVEL4,  // 錺
	0x9335, KANJI_LEVEL4,  // 錵
	0x933B, KANJI_LEVEL4,  // 錻
	0x935C, KANJI_LEVEL4,  // 鍜
	0x9360, KANJI_LEVEL4,  // 鍠
	0x937C, KANJI_LEVEL4,  // 鍼
	0x936E, KANJI_LEVEL4,  // 鍮
	0x9356, KANJI_LEVEL4,  // 鍖
	0x93B0, KANJI_LEVEL4,  // 鎰
	0x93AC, KANJI_LEVEL4,  // 鎬
	0x93AD, KANJI_LEVEL4,  // 鎭
	0x9394, KANJI_LEVEL4,  // 鎔
	0x93B9, KANJI_LEVEL4,  // 鎹
	0x93D6, KANJI_LEVEL4,  // 鏖
	0x93D7, KANJI_LEVEL4,  // 鏗
	0x93E8, KANJI_LEVEL4,  // 鏨
	0x93E5, KANJI_LEVEL4,  // 鏥
	0x93D8, KANJI_LEVEL4,  // 鏘
	0x93C3, KANJI_LEVEL4,  // 鏃
	0x93DD, KANJI_LEVEL4,  // 鏝
	0x93D0, KANJI_LEVEL4,  // 鏐
	0x93C8, KANJI_LEVEL4,  // 鏈
	0x93E4, KANJI_LEVEL4,  // 鏤
	0x941A, KANJI_LEVEL4,  // 鐚
	0x9414, KANJI_LEVEL4,  // 鐔
	0x9413, KANJI_LEVEL4,  // 鐓
	0x9403, KANJI_LEVEL4,  // 鐃
	0x9407, KANJI_LEVEL4,  // 鐇
	0x9410, KANJI_LEVEL4,  // 鐐
	0x9436, KANJI_LEVEL4,  // 鐶
	0x942B, KANJI_LEVEL4,  // 鐫
	0x9435, KANJI_LEVEL4,  // 鐵
	0x9421, KANJI_LEVEL4,  // 鐡
	0x943A, KANJI_LEVEL4,  // 鐺
	0x9441, KANJI_LEVEL4,  // 鑁
	0x9452, KANJI_LEVEL4,  // 鑒
	0x9444, KANJI_LEVEL4,  // 鑄
	0x945B, KANJI_LEVEL4,  // 鑛
	0x9460, KANJI_LEVEL4,  // 鑠
	0x9462, KANJI_LEVEL4,  // 鑢
	0x945E, KANJI_LEVEL4,  // 鑞
	0x946A, KANJI_LEVEL4,  // 鑪
	0x9229, KANJI_LEVEL4,  // 鈩
	0x9470, KANJI_LEVEL4,  // 鑰
	0x9475, KANJI_LEVEL4,  // 鑵
	0x9477, KANJI_LEVEL4,  // 鑷
	0x947D, KANJI_LEVEL4,  // 鑽
	0x945A, KANJI_LEVEL4,  // 鑚
	0x947C, KANJI_LEVEL4,  // 鑼
	0x947E, KANJI_LEVEL4,  // 鑾
	0x9481, KANJI_LEVEL4,  // 钁
	0x947F, KANJI_LEVEL4,  // 鑿
	0x9582, KANJI_LEVEL4,  // 閂
	0x9587, KANJI_LEVEL4,  // 閇
	0x958A, KANJI_LEVEL4,  // 閊
	0x9594, KANJI_LEVEL4,  // 閔
	0x9596, KANJI_LEVEL4,  // 閖
	0x9598, KANJI_LEVEL4,  // 閘
	0x9599, KANJI_LEVEL4,  // 閙
	0x95A0, KANJI_LEVEL4,  // 閠
	0x95A8, KANJI_LEVEL4,  // 閨
	0x95A7, KANJI_LEVEL4,  // 閧
	0x95AD, KANJI_LEVEL4,  // 閭
	0x95BC, KANJI_LEVEL4,  // 閼
	0x95BB, KANJI_LEVEL4,  // 閻
	0x95B9, KANJI_LEVEL4,  // 閹
	0x95BE, KANJI_LEVEL4,  // 閾
	0x95CA, KANJI_LEVEL4,  // 闊
	0x6FF6, KANJI_LEVEL4,  // 濶
	0x95C3, KANJI_LEVEL4,  // 闃
	0x95CD, KANJI_LEVEL4,  // 闍
	0x95CC, KANJI_LEVEL4,  // 闌
	0x95D5, KANJI_LEVEL4,  // 闕
	0x95D4, KANJI_LEVEL4,  // 闔
	0x95D6, KANJI_LEVEL4,  // 闖
	0x95DC, KANJI_LEVEL4,  // 關
	0x95E1, KANJI_LEVEL4,  // 闡
	0x95E5, KANJI_LEVEL4,  // 闥
	0x95E2, KANJI_LEVEL4,  // 闢
	0x9621, KANJI_LEVEL4,  // 阡
	0x9628, KANJI_LEVEL4,  // 阨
	0x962E, KANJI_LEVEL4,  // 阮
	0x962F, KANJI_LEVEL4,  // 阯
	0x9642, KANJI_LEVEL4,  // 陂
	0x964C, KANJI_LEVEL4,  // 陌
	0x964F, KANJI_LEVEL4,  // 陏
	0x964B, KANJI_LEVEL4,  // 陋
	0x9677, KANJI_LEVEL4,  // 陷
	0x965C, KANJI_LEVEL4,  // 陜
	0x965E, KANJI_LEVEL4,  // 陞
	0x965D, KANJI_LEVEL4,  // 陝
	0x965F, KANJI_LEVEL4,  // 陟
	0x9666, KANJI_LEVEL4,  // 陦
	0x9672, KANJI_LEVEL4,  // 陲
	0x966C, KANJI_LEVEL4,  // 陬
	0x968D, KANJI_LEVEL4,  // 隍
	0x9698, KANJI_LEVEL4,  // 隘
	0x9695, KANJI_LEVEL4,  // 隕
	0x9697, KANJI_LEVEL4,  // 隗
	0x96AA, KANJI_LEVEL4,  // 險
	0x96A7, KANJI_LEVEL4,  // 隧
	0x96B1, KANJI_LEVEL4,  // 隱
	0x96B2, KANJI_LEVEL4,  // 隲
	0x96B0, KANJI_LEVEL4,  // 隰
	0x96B4, KANJI_LEVEL4,  // 隴
	0x96B6, KANJI_LEVEL4,  // 隶
	0x96B8, KANJI_LEVEL4,  // 隸
	0x96B9, KANJI_LEVEL4,  // 隹
	0x96CE, KANJI_LEVEL4,  // 雎
	0x96CB, KANJI_LEVEL4,  // 雋
	0x96C9, KANJI_LEVEL4,  // 雉
	0x96CD, KANJI_LEVEL4,  // 雍
	0x894D, KANJI_LEVEL4,  // 襍
	0x96DC, KANJI_LEVEL4,  // 雜
	0x970D, KANJI_LEVEL4,  // 霍
	0x96D5, KANJI_LEVEL4,  // 雕
	0x96F9, KANJI_LEVEL4,  // 雹
	0x9704, KANJI_LEVEL4,  // 霄
	0x9706, KANJI_LEVEL4,  // 霆
	0x9708, KANJI_LEVEL4,  // 霈
	0x9713, KANJI_LEVEL4,  // 霓
	0x970E, KANJI_LEVEL4,  // 霎
	0x9711, KANJI_LEVEL4,  // 霑
	0x970F, KANJI_LEVEL4,  // 霏
	0x9716, KANJI_LEVEL4,  // 霖
	0x9719, KANJI_LEVEL4,  // 霙
	0x9724, KANJI_LEVEL4,  // 霤
	0x972A, KANJI_LEVEL4,  // 霪
	0x9730, KANJI_LEVEL4,  // 霰
	0x9739, KANJI_LEVEL4,  // 霹
	0x973D, KANJI_LEVEL4,  // 霽
	0x973E, KANJI_LEVEL4,  // 霾
	0x9744, KANJI_LEVEL4,  // 靄
	0x9746, KANJI_LEVEL4,  // 靆
	0x9748, KANJI_LEVEL4,  // 靈
	0x9742, KANJI_LEVEL4,  // 靂
	0x9749, KANJI_LEVEL4,  // 靉
	0x975C, KANJI_LEVEL4,  // 靜
	0x9760, KANJI_LEVEL4,  // 靠
	0x9764, KANJI_LEVEL4,  // 靤
	0x9766, KANJI_LEVEL4,  // 靦
	0x9768, KANJI_LEVEL4,  // 靨
	0x52D2, KANJI_LEVEL4,  // 勒
	0x976B, KANJI_LEVEL4,  // 靫
	0x9771, KANJI_LEVEL4,  // 靱
	0x9779, KANJI_LEVEL4,  // 靹
	0x9785, KANJI_LEVEL4,  // 鞅
	0x977C, KANJI_LEVEL4,  // 靼
	0x9781, KANJI_LEVEL4,  // 鞁
	0x977A, KANJI_LEVEL4,  // 靺
	0x9786, KANJI_LEVEL4,  // 鞆
	0x978B, KANJI_LEVEL4,  // 鞋
	0x978F, KANJI_LEVEL4,  // 鞏
	0x9790, KANJI_LEVEL4,  // 鞐
	0x979C, KANJI_LEVEL4,  // 鞜
	0x97A8, KANJI_LEVEL4,  // 鞨
	0x97A6, KANJI_LEVEL4,  // 鞦
	0x97A3, KANJI_LEVEL4,  // 鞣
	0x97B3, KANJI_LEVEL4,  // 鞳
	0x97B4, KANJI_LEVEL4,  // 鞴
	0x97C3, KANJI_LEVEL4,  // 韃
	0x97C6, KANJI_LEVEL4,  // 韆
	0x97C8, KANJI_LEVEL4,  // 韈
	0x97CB, KANJI_LEVEL4,  // 韋
	0x97DC, KANJI_LEVEL4,  // 韜
	0x97ED, KANJI_LEVEL4,  // 韭
	0x9F4F, KANJI_LEVEL4,  // 齏
	0x97F2, KANJI_LEVEL4,  // 韲
	0x7ADF, KANJI_LEVEL4,  // 竟
	0x97F6, KANJI_LEVEL4,  // 韶
	0x97F5, KANJI_LEVEL4,  // 韵
	0x980F, KANJI_LEVEL4,  // 頏
	0x980C, KANJI_LEVEL4,  // 頌
	0x9838, KANJI_LEVEL4,  // 頸
	0x9824, KANJI_LEVEL4,  // 頤
	0x9821, KANJI_LEVEL4,  // 頡
	0x9837, KANJI_LEVEL4,  // 頷
	0x983D, KANJI_LEVEL4,  // 頽
	0x9846, KANJI_LEVEL4,  // 顆
	0x984F, KANJI_LEVEL4,  // 顏
	0x984B, KANJI_LEVEL4,  // 顋
	0x986B, KANJI_LEVEL4,  // 顫
	0x986F, KANJI_LEVEL4,  // 顯
	0x9870, KANJI_LEVEL4,  // 顰
	0x9871, KANJI_LEVEL4,  // 顱
	0x9874, KANJI_LEVEL4,  // 顴
	0x9873, KANJI_LEVEL4,  // 顳
	0x98AA, KANJI_LEVEL4,  // 颪
	0x98AF, KANJI_LEVEL4,  // 颯
	0x98B1, KANJI_LEVEL4,  // 颱
	0x98B6, KANJI_LEVEL4,  // 颶
	0x98C4, KANJI_LEVEL4,  // 飄
	0x98C3, KANJI_LEVEL4,  // 飃
	0x98C6, KANJI_LEVEL4,  // 飆
	0x98E9, KANJI_LEVEL4,  // 飩
	0x98EB, KANJI_LEVEL4,  // 飫
	0x9903, KANJI_LEVEL4,  // 餃
	0x9909, KANJI_LEVEL4,  // 餉
	0x9912, KANJI_LEVEL4,  // 餒
	0x9914, KANJI_LEVEL4,  // 餔
	0x9918, KANJI_LEVEL4,  // 餘
	0x9921, KANJI_LEVEL4,  // 餡
	0x991D, KANJI_LEVEL4,  // 餝
	0x991E, KANJI_LEVEL4,  // 餞
	0x9924, KANJI_LEVEL4,  // 餤
	0x9920, KANJI_LEVEL4,  // 餠
	0x992C, KANJI_LEVEL4,  // 餬
	0x992E, KANJI_LEVEL4,  // 餮
	0x993D, KANJI_LEVEL4,  // 餽
	0x993E, KANJI_LEVEL4,  // 餾
	0x9942, KANJI_LEVEL4,  // 饂
	0x9949, KANJI_LEVEL4,  // 饉
	0x9945, KANJI_LEVEL4,  // 饅
	0x9950, KANJI_LEVEL4,  // 饐
	0x994B, KANJI_LEVEL4,  // 饋
	0x9951, KANJI_LEVEL4,  // 饑
	0x9952, KANJI_LEVEL4,  // 饒
	0x994C, KANJI_LEVEL4,  // 饌
	0x9955, KANJI_LEVEL4,  // 饕
	0x9997, KANJI_LEVEL4,  // 馗
	0x9998, KANJI_LEVEL4,  // 馘
	0x99A5, KANJI_LEVEL4,  // 馥
	0x99AD, KANJI_LEVEL4,  // 馭
	0x99AE, KANJI_LEVEL4,  // 馮
	0x99BC, KANJI_LEVEL4,  // 馼
	0x99DF, KANJI_LEVEL4,  // 駟
	0x99DB, KANJI_LEVEL4,  // 駛
	0x99DD, KANJI_LEVEL4,  // 駝
	0x99D8, KANJI_LEVEL4,  // 駘
	0x99D1, KANJI_LEVEL4,  // 駑
	0x99ED, KANJI_LEVEL4,  // 駭
	0x99EE, KANJI_LEVEL4,  // 駮
	0x99F1, KANJI_LEVEL4,  // 駱
	0x99F2, KANJI_LEVEL4,  // 駲
	0x99FB, KANJI_LEVEL4,  // 駻
	0x99F8, KANJI_LEVEL4,  // 駸
	0x9A01, KANJI_LEVEL4,  // 騁
	0x9A0F, KANJI_LEVEL4,  // 騏
	0x9A05, KANJI_LEVEL4,  // 騅
	0x99E2, KANJI_LEVEL4,  // 駢
	0x9A19, KANJI_LEVEL4,  // 騙
	0x9A2B, KANJI_LEVEL4,  // 騫
	0x9A37, KANJI_LEVEL4,  // 騷
	0x9A45, KANJI_LEVEL4,  // 驅
	0x9A42, KANJI_LEVEL4,  // 驂
	0x9A40, KANJI_LEVEL4,  // 驀
	0x9A43, KANJI_LEVEL4,  // 驃
	0x9A3E, KANJI_LEVEL4,  // 騾
	0x9A55, KANJI_LEVEL4,  // 驕
	0x9A4D, KANJI_LEVEL4,  // 驍
	0x9A5B, KANJI_LEVEL4,  // 驛
	0x9A57, KANJI_LEVEL4,  // 驗
	0x9A5F, KANJI_LEVEL4,  // 驟
	0x9A62, KANJI_LEVEL4,  // 驢
	0x9A65, KANJI_LEVEL4,  // 驥
	0x9A64, KANJI_LEVEL4,  // 驤
	0x9A69, KANJI_LEVEL4,  // 驩
	0x9A6B, KANJI_LEVEL4,  // 驫
	0x9A6A, KANJI_LEVEL4,  // 驪
	0x9AAD, KANJI_LEVEL4,  // 骭
	0x9AB0, KANJI_LEVEL4,  // 骰
	0x9ABC, KANJI_LEVEL4,  // 骼
	0x9AC0, KANJI_LEVEL4,  // 髀
	0x9ACF, KANJI_LEVEL4,  // 髏
	0x9AD1, KANJI_LEVEL4,  // 髑
	0x9AD3, KANJI_LEVEL4,  // 髓
	0x9AD4, KANJI_LEVEL4,  // 體
	0x9ADE, KANJI_LEVEL4,  // 髞
	0x9ADF, KANJI_LEVEL4,  // 髟
	0x9AE2, KANJI_LEVEL4,  // 髢
	0x9AE3, KANJI_LEVEL4,  // 髣
	0x9AE6, KANJI_LEVEL4,  // 髦
	0x9AEF, KANJI_LEVEL4,  // 髯
	0x9AEB, KANJI_LEVEL4,  // 髫
	0x9AEE, KANJI_LEVEL4,  // 髮
	0x9AF4, KANJI_LEVEL4,  // 髴
	0x9AF1, KANJI_LEVEL4,  // 髱
	0x9AF7, KANJI_LEVEL4,  // 髷
	0x9AFB, KANJI_LEVEL4,  // 髻
	0x9B06, KANJI_LEVEL4,  // 鬆
	0x9B18, KANJI_LEVEL4,  // 鬘
	0x9B1A, KANJI_LEVEL4,  // 鬚
	0x9B1F, KANJI_LEVEL4,  // 鬟
	0x9B22, KANJI_LEVEL4,  // 鬢
	0x9B23, KANJI_LEVEL4,  // 鬣
	0x9B25, KANJI_LEVEL4,  // 鬥
	0x9B27, KANJI_LEVEL4,  // 鬧
	0x9B28, KANJI_LEVEL4,  // 鬨
	0x9B29, KANJI_LEVEL4,  // 鬩
	0x9B2A, KANJI_LEVEL4,  // 鬪
	0x9B2E, KANJI_LEVEL4,  // 鬮
	0x9B2F, KANJI_LEVEL4,  // 鬯
	0x9B32, KANJI_LEVEL4,  // 鬲
	0x9B44, KANJI_LEVEL4,  // 魄
	0x9B43, KANJI_LEVEL4,  // 魃
	0x9B4F, KANJI_LEVEL4,  // 魏
	0x9B4D, KANJI_LEVEL4,  // 魍
	0x9B4E, KANJI_LEVEL4,  // 魎
	0x9B51, KANJI_LEVEL4,  // 魑
	0x9B58, KANJI_LEVEL4,  // 魘
	0x9B74, KANJI_LEVEL4,  // 魴
	0x9B93, KANJI_LEVEL4,  // 鮓
	0x9B83, KANJI_LEVEL4,  // 鮃
	0x9B91, KANJI_LEVEL4,  // 鮑
	0x9B96, KANJI_LEVEL4,  // 鮖
	0x9B97, KANJI_LEVEL4,  // 鮗
	0x9B9F, KANJI_LEVEL4,  // 鮟
	0x9BA0, KANJI_LEVEL4,  // 鮠
	0x9BA8, KANJI_LEVEL4,  // 鮨
	0x9BB4, KANJI_LEVEL4,  // 鮴
	0x9BC0, KANJI_LEVEL4,  // 鯀
	0x9BCA, KANJI_LEVEL4,  // 鯊
	0x9BB9, KANJI_LEVEL4,  // 鮹
	0x9BC6, KANJI_LEVEL4,  // 鯆
	0x9BCF, KANJI_LEVEL4,  // 鯏
	0x9BD1, KANJI_LEVEL4,  // 鯑
	0x9BD2, KANJI_LEVEL4,  // 鯒
	0x9BE3, KANJI_LEVEL4,  // 鯣
	0x9BE2, KANJI_LEVEL4,  // 鯢
	0x9BE4, KANJI_LEVEL4,  // 鯤
	0x9BD4, KANJI_LEVEL4,  // 鯔
	0x9BE1, KANJI_LEVEL4,  // 鯡
	0x9C3A, KANJI_LEVEL4,  // 鰺
	0x9BF2, KANJI_LEVEL4,  // 鯲
	0x9BF1, KANJI_LEVEL4,  // 鯱
	0x9BF0, KANJI_LEVEL4,  // 鯰
	0x9C15, KANJI_LEVEL4,  // 鰕
	0x9C14, KANJI_LEVEL4,  // 鰔
	0x9C09, KANJI_LEVEL4,  // 鰉
	0x9C13, KANJI_LEVEL4,  // 鰓
	0x9C0C, KANJI_LEVEL4,  // 鰌
	0x9C06, KANJI_LEVEL4,  // 鰆
	0x9C08, KANJI_LEVEL4,  // 鰈
	0x9C12, KANJI_LEVEL4,  // 鰒
	0x9C0A, KANJI_LEVEL4,  // 鰊
	0x9C04, KANJI_LEVEL4,  // 鰄
	0x9C2E, KANJI_LEVEL4,  // 鰮
	0x9C1B, KANJI_LEVEL4,  // 鰛
	0x9C25, KANJI_LEVEL4,  // 鰥
	0x9C24, KANJI_LEVEL4,  // 鰤
	0x9C21, KANJI_LEVEL4,  // 鰡
	0x9C30, KANJI_LEVEL4,  // 鰰
	0x9C47, KANJI_LEVEL4,  // 鱇
	0x9C32, KANJI_LEVEL4,  // 鰲
	0x9C46, KANJI_LEVEL4,  // 鱆
	0x9C3E, KANJI_LEVEL4,  // 鰾
	0x9C5A, KANJI_LEVEL4,  // 鱚
	0x9C60, KANJI_LEVEL4,  // 鱠
	0x9C67, KANJI_LEVEL4,  // 鱧
	0x9C76, KANJI_LEVEL4,  // 鱶
	0x9C78, KANJI_LEVEL4,  // 鱸
	0x9CE7, KANJI_LEVEL4,  // 鳧
	0x9CEC, KANJI_LEVEL4,  // 鳬
	0x9CF0, KANJI_LEVEL4,  // 鳰
	0x9D09, KANJI_LEVEL4,  // 鴉
	0x9D08, KANJI_LEVEL4,  // 鴈
	0x9CEB, KANJI_LEVEL4,  // 鳫
	0x9D03, KANJI_LEVEL4,  // 鴃
	0x9D06, KANJI_LEVEL4,  // 鴆
	0x9D2A, KANJI_LEVEL4,  // 鴪
	0x9D26, KANJI_LEVEL4,  // 鴦
	0x9DAF, KANJI_LEVEL4,  // 鶯
	0x9D23, KANJI_LEVEL4,  // 鴣
	0x9D1F, KANJI_LEVEL4,  // 鴟
	0x9D44, KANJI_LEVEL4,  // 鵄
	0x9D15, KANJI_LEVEL4,  // 鴕
	0x9D12, KANJI_LEVEL4,  // 鴒
	0x9D41, KANJI_LEVEL4,  // 鵁
	0x9D3F, KANJI_LEVEL4,  // 鴿
	0x9D3E, KANJI_LEVEL4,  // 鴾
	0x9D46, KANJI_LEVEL4,  // 鵆
	0x9D48, KANJI_LEVEL4,  // 鵈
	0x9D5D, KANJI_LEVEL4,  // 鵝
	0x9D5E, KANJI_LEVEL4,  // 鵞
	0x9D64, KANJI_LEVEL4,  // 鵤
	0x9D51, KANJI_LEVEL4,  // 鵑
	0x9D50, KANJI_LEVEL4,  // 鵐
	0x9D59, KANJI_LEVEL4,  // 鵙
	0x9D72, KANJI_LEVEL4,  // 鵲
	0x9D89, KANJI_LEVEL4,  // 鶉
	0x9D87, KANJI_LEVEL4,  // 鶇
	0x9DAB, KANJI_LEVEL4,  // 鶫
	0x9D6F, KANJI_LEVEL4,  // 鵯
	0x9D7A, KANJI_LEVEL4,  // 鵺
	0x9D9A, KANJI_LEVEL4,  // 鶚
	0x9DA4, KANJI_LEVEL4,  // 鶤
	0x9DA9, KANJI_LEVEL4,  // 鶩
	0x9DB2, KANJI_LEVEL4,  // 鶲
	0x9DC4, KANJI_LEVEL4,  // 鷄
	0x9DC1, KANJI_LEVEL4,  // 鷁
	0x9DBB, KANJI_LEVEL4,  // 鶻
	0x9DB8, KANJI_LEVEL4,  // 鶸
	0x9DBA, KANJI_LEVEL4,  // 鶺
	0x9DC6, KANJI_LEVEL4,  // 鷆
	0x9DCF, KANJI_LEVEL4,  // 鷏
	0x9DC2, KANJI_LEVEL4,  // 鷂
	0x9DD9, KANJI_LEVEL4,  // 鷙
	0x9DD3, KANJI_LEVEL4,  // 鷓
	0x9DF8, KANJI_LEVEL4,  // 鷸
	0x9DE6, KANJI_LEVEL4,  // 鷦
	0x9DED, KANJI_LEVEL4,  // 鷭
	0x9DEF, KANJI_LEVEL4,  // 鷯
	0x9DFD, KANJI_LEVEL4,  // 鷽
	0x9E1A, KANJI_LEVEL4,  // 鸚
	0x9E1B, KANJI_LEVEL4,  // 鸛
	0x9E1E, KANJI_LEVEL4,  // 鸞
	0x9E75, KANJI_LEVEL4,  // 鹵
	0x9E79, KANJI_LEVEL4,  // 鹹
	0x9E7D, KANJI_LEVEL4,  // 鹽
	0x9E81, KANJI_LEVEL4,  // 麁
	0x9E88, KANJI_LEVEL4,  // 麈
	0x9E8B, KANJI_LEVEL4,  // 麋
	0x9E8C, KANJI_LEVEL4,  // 麌
	0x9E92, KANJI_LEVEL4,  // 麒
	0x9E95, KANJI_LEVEL4,  // 麕
	0x9E91, KANJI_LEVEL4,  // 麑
	0x9E9D, KANJI_LEVEL4,  // 麝
	0x9EA5, KANJI_LEVEL4,  // 麥
	0x9EA9, KANJI_LEVEL4,  // 麩
	0x9EB8, KANJI_LEVEL4,  // 麸
	0x9EAA, KANJI_LEVEL4,  // 麪
	0x9EAD, KANJI_LEVEL4,  // 麭
	0x9761, KANJI_LEVEL4,  // 靡
	0x9ECC, KANJI_LEVEL4,  // 黌
	0x9ECE, KANJI_LEVEL4,  // 黎
	0x9ECF, KANJI_LEVEL4,  // 黏
	0x9ED0, KANJI_LEVEL4,  // 黐
	0x9ED4, KANJI_LEVEL4,  // 黔
	0x9EDC, KANJI_LEVEL4,  // 黜
	0x9EDE, KANJI_LEVEL4,  // 點
	0x9EDD, KANJI_LEVEL4,  // 黝
	0x9EE0, KANJI_LEVEL4,  // 黠
	0x9EE5, KANJI_LEVEL4,  // 黥
	0x9EE8, KANJI_LEVEL4,  // 黨
	0x9EEF, KANJI_LEVEL4,  // 黯
	0x9EF4, KANJI_LEVEL4,  // 黴
	0x9EF6, KANJI_LEVEL4,  // 黶
	0x9EF7, KANJI_LEVEL4,  // 黷
	0x9EF9, KANJI_LEVEL4,  // 黹
	0x9EFB, KANJI_LEVEL4,  // 黻
	0x9EFC, KANJI_LEVEL4,  // 黼
	0x9EFD, KANJI_LEVEL4,  // 黽
	0x9F07, KANJI_LEVEL4,  // 鼇
	0x9F08, KANJI_LEVEL4,  // 鼈
	0x76B7, KANJI_LEVEL4,  // 皷
	0x9F15, KANJI_LEVEL4,  // 鼕
	0x9F21, KANJI_LEVEL4,  // 鼡
	0x9F2C, KANJI_LEVEL4,  // 鼬
	0x9F3E, KANJI_LEVEL4,  // 鼾
	0x9F4A, KANJI_LEVEL4,  // 齊
	0x9F52, KANJI_LEVEL4,  // 齒
	0x9F54, KANJI_LEVEL4,  // 齔
	0x9F63, KANJI_LEVEL4,  // 齣
	0x9F5F, KANJI_LEVEL4,  // 齟
	0x9F60, KANJI_LEVEL4,  // 齠
	0x9F61, KANJI_LEVEL4,  // 齡
	0x9F66, KANJI_LEVEL4,  // 齦
	0x9F67, KANJI_LEVEL4,  // 齧
	0x9F6C, KANJI_LEVEL4,  // 齬
	0x9F6A, KANJI_LEVEL4,  // 齪
	0x9F77, KANJI_LEVEL4,  // 齷
	0x9F72, KANJI_LEVEL4,  // 齲
	0x9F76, KANJI_LEVEL4,  // 齶
	0x9F95, KANJI_LEVEL4,  // 龕
	0x9F9C, KANJI_LEVEL4,  // 龜
	0x9FA0, KANJI_LEVEL4,  // 龠
	0x582F, KANJI_LEVEL4,  // 堯
	0x69C7, KANJI_LEVEL4,  // 槇
	0x9059, KANJI_LEVEL4,  // 遙
	0x7464, KANJI_LEVEL4,  // 瑤
	0x51DC, KANJI_LEVEL4,  // 凜
	0x7199, KANJI_LEVEL4,  // 熙
	0x5653, KANJI_LEVEL4,  // 噓
	0x5DE2, KANJI_LEVEL4,  // 巢
	0x5E14, KANJI_LEVEL4,  // 帔
	0x5E18, KANJI_LEVEL4,  // 帘
	0x5E58, KANJI_LEVEL4,  // 幘
	0x5E5E, KANJI_LEVEL4,  // 幞
	0x5EBE, KANJI_LEVEL4,  // 庾
	0xF928, KANJI_LEVEL4,  // 廊
	0x5ECB, KANJI_LEVEL4,  // 廋
	0x5EF9, KANJI_LEVEL4,  // 廹
	0x5F00, KANJI_LEVEL4,  // 开
	0x5F02, KANJI_LEVEL4,  // 异
	0x5F07, KANJI_LEVEL4,  // 弇
	0x5F1D, KANJI_LEVEL4,  // 弝
	0x5F23, KANJI_LEVEL4,  // 弣
	0x5F34, KANJI_LEVEL4,  // 弴
	0x5F36, KANJI_LEVEL4,  // 弶
	0x5F3D, KANJI_LEVEL4,  // 弽
	0x5F40, KANJI_LEVEL4,  // 彀
	0x5F45, KANJI_LEVEL4,  // 彅
	0x5F54, KANJI_LEVEL4,  // 彔
	0x5F58, KANJI_LEVEL4,  // 彘
	0x5F64, KANJI_LEVEL4,  // 彤
	0x5F67, KANJI_LEVEL4,  // 彧
	0x5F7D, KANJI_LEVEL4,  // 彽
	0x5F89, KANJI_LEVEL4,  // 徉
	0x5F9C, KANJI_LEVEL4,  // 徜
	0x5FA7, KANJI_LEVEL4,  // 徧
	0x5FAF, KANJI_LEVEL4,  // 徯
	0x5FB5, KANJI_LEVEL4,  // 徵
	0x5FB7, KANJI_LEVEL4,  // 德
	0x5FC9, KANJI_LEVEL4,  // 忉
	0x5FDE, KANJI_LEVEL4,  // 忞
	0x5FE1, KANJI_LEVEL4,  // 忡
	0x5FE9, KANJI_LEVEL4,  // 忩
	0x600D, KANJI_LEVEL4,  // 怍
	0x6014, KANJI_LEVEL4,  // 怔
	0x6018, KANJI_LEVEL4,  // 怘
	0x6033, KANJI_LEVEL4,  // 怳
	0x6035, KANJI_LEVEL4,  // 怵
	0x6047, KANJI_LEVEL4,  // 恇
	0xFA3D, KANJI_LEVEL4,  // 悔
	0x609D, KANJI_LEVEL4,  // 悝
	0x609E, KANJI_LEVEL4,  // 悞
	0x60CB, KANJI_LEVEL4,  // 惋
	0x60D4, KANJI_LEVEL4,  // 惔
	0x60D5, KANJI_LEVEL4,  // 惕
	0x60DD, KANJI_LEVEL4,  // 惝
	0x60F8, KANJI_LEVEL4,  // 惸
	0x611C, KANJI_LEVEL4,  // 愜
	0x612B, KANJI_LEVEL4,  // 愫
	0x6130, KANJI_LEVEL4,  // 愰
	0x6137, KANJI_LEVEL4,  // 愷
	0xFA3E, KANJI_LEVEL4,  // 慨
	0x618D, KANJI_LEVEL4,  // 憍
	0xFA3F, KANJI_LEVEL4,  // 憎
	0x61BC, KANJI_LEVEL4,  // 憼
	0x61B9, KANJI_LEVEL4,  // 憹
	0xFA40, KANJI_LEVEL4,  // 懲
	0x6222, KANJI_LEVEL4,  // 戢
	0x623E, KANJI_LEVEL4,  // 戾
	0x6243, KANJI_LEVEL4,  // 扃
	0x6256, KANJI_LEVEL4,  // 扖
	0x625A, KANJI_LEVEL4,  // 扚
	0x626F, KANJI_LEVEL4,  // 扯
	0x6285, KANJI_LEVEL4,  // 抅
	0x62C4, KANJI_LEVEL4,  // 拄
	0x62D6, KANJI_LEVEL4,  // 拖
	0x62FC, KANJI_LEVEL4,  // 拼
	0x630A, KANJI_LEVEL4,  // 挊
	0x6318, KANJI_LEVEL4,  // 挘
	0x6339, KANJI_LEVEL4,  // 挹
	0x6343, KANJI_LEVEL4,  // 捃
	0x6365, KANJI_LEVEL4,  // 捥
	0x637C, KANJI_LEVEL4,  // 捼
	0x63E5, KANJI_LEVEL4,  // 揥
	0x63ED, KANJI_LEVEL4,  // 揭
	0x63F5, KANJI_LEVEL4,  // 揵
	0x6410, KANJI_LEVEL4,  // 搐
	0x6414, KANJI_LEVEL4,  // 搔
	0x6422, KANJI_LEVEL4,  // 搢
	0x6479, KANJI_LEVEL4,  // 摹
	0x6451, KANJI_LEVEL4,  // 摑
	0x6460, KANJI_LEVEL4,  // 摠
	0x646D, KANJI_LEVEL4,  // 摭
	0x64CE, KANJI_LEVEL4,  // 擎
	0x64BE, KANJI_LEVEL4,  // 撾
	0x64BF, KANJI_LEVEL4,  // 撿
	0x64C4, KANJI_LEVEL4,  // 擄
	0x64CA, KANJI_LEVEL4,  // 擊
	0x64D0, KANJI_LEVEL4,  // 擐
	0x64F7, KANJI_LEVEL4,  // 擷
	0x64FB, KANJI_LEVEL4,  // 擻
	0x6522, KANJI_LEVEL4,  // 攢
	0x6529, KANJI_LEVEL4,  // 攩
	0xFA41, KANJI_LEVEL4,  // 敏
	0x6567, KANJI_LEVEL4,  // 敧
	0x659D, KANJI_LEVEL4,  // 斝
	0xFA42, KANJI_LEVEL4,  // 既
	0x6600, KANJI_LEVEL4,  // 昀
	0x6609, KANJI_LEVEL4,  // 昉
	0x6615, KANJI_LEVEL4,  // 昕
	0x661E, KANJI_LEVEL4,  // 昞
	0x663A, KANJI_LEVEL4,  // 昺
	0x6622, KANJI_LEVEL4,  // 昢
	0x6624, KANJI_LEVEL4,  // 昤
	0x662B, KANJI_LEVEL4,  // 昫
	0x6630, KANJI_LEVEL4,  // 昰
	0x6631, KANJI_LEVEL4,  // 昱
	0x6633, KANJI_LEVEL4,  // 昳
	0x66FB, KANJI_LEVEL4,  // 曻
	0x6648, KANJI_LEVEL4,  // 晈
	0x664C, KANJI_LEVEL4,  // 晌
	0xD84C, KANJI_LEVEL4,  // �
	0xDDC4, KANJI_LEVEL4,  // �
	0x6659, KANJI_LEVEL4,  // 晙
	0x665A, KANJI_LEVEL4,  // 晚
	0x6661, KANJI_LEVEL4,  // 晡
	0x6665, KANJI_LEVEL4,  // 晥
	0x6673, KANJI_LEVEL4,  // 晳
	0x6677, KANJI_LEVEL4,  // 晷
	0x6678, KANJI_LEVEL4,  // 晸
	0x668D, KANJI_LEVEL4,  // 暍
	0xFA43, KANJI_LEVEL4,  // 暑
	0x66A0, KANJI_LEVEL4,  // 暠
	0x66B2, KANJI_LEVEL4,  // 暲
	0x66BB, KANJI_LEVEL4,  // 暻
	0x66C6, KANJI_LEVEL4,  // 曆
	0x66C8, KANJI_LEVEL4,  // 曈
	0x3B22, KANJI_LEVEL4,  // 㬢
	0x66DB, KANJI_LEVEL4,  // 曛
	0x66E8, KANJI_LEVEL4,  // 曨
	0x66FA, KANJI_LEVEL4,  // 曺
	0x6713, KANJI_LEVEL4,  // 朓
	0xF929, KANJI_LEVEL4,  // 朗
	0x6733, KANJI_LEVEL4,  // 朳
	0x6766, KANJI_LEVEL4,  // 杦
	0x6747, KANJI_LEVEL4,  // 杇
	0x6748, KANJI_LEVEL4,  // 杈
	0x677B, KANJI_LEVEL4,  // 杻
	0x6781, KANJI_LEVEL4,  // 极
	0x6793, KANJI_LEVEL4,  // 枓
	0x6798, KANJI_LEVEL4,  // 枘
	0x679B, KANJI_LEVEL4,  // 枛
	0x67BB, KANJI_LEVEL4,  // 枻
	0x67F9, KANJI_LEVEL4,  // 柹
	0x67C0, KANJI_LEVEL4,  // 柀
	0x67D7, KANJI_LEVEL4,  // 柗
	0x67FC, KANJI_LEVEL4,  // 柼
	0x6801, KANJI_LEVEL4,  // 栁
	0x6852, KANJI_LEVEL4,  // 桒
	0x681D, KANJI_LEVEL4,  // 栝
	0x682C, KANJI_LEVEL4,  // 栬
	0x6831, KANJI_LEVEL4,  // 栱
	0x685B, KANJI_LEVEL4,  // 桛
	0x6872, KANJI_LEVEL4,  // 桲
	0x6875, KANJI_LEVEL4,  // 桵
	0xFA44, KANJI_LEVEL4,  // 梅
	0x68A3, KANJI_LEVEL4,  // 梣
	0x68A5, KANJI_LEVEL4,  // 梥
	0x68B2, KANJI_LEVEL4,  // 梲
	0x68C8, KANJI_LEVEL4,  // 棈
	0x68D0, KANJI_LEVEL4,  // 棐
	0x68E8, KANJI_LEVEL4,  // 棨
	0x68ED, KANJI_LEVEL4,  // 棭
	0x68F0, KANJI_LEVEL4,  // 棰
	0x68F1, KANJI_LEVEL4,  // 棱
	0x68FC, KANJI_LEVEL4,  // 棼
	0x690A, KANJI_LEVEL4,  // 椊
	0x6949, KANJI_LEVEL4,  // 楉
	0xD84D, KANJI_LEVEL4,  // �
	0xDDC4, KANJI_LEVEL4,  // �
	0x6935, KANJI_LEVEL4,  // 椵
	0x6942, KANJI_LEVEL4,  // 楂
	0x6957, KANJI_LEVEL4,  // 楗
	0x6963, KANJI_LEVEL4,  // 楣
	0x6964, KANJI_LEVEL4,  // 楤
	0x6968, KANJI_LEVEL4,  // 楨
	0x6980, KANJI_LEVEL4,  // 榀
	0xFA14, KANJI_LEVEL4,  // 﨔
	0x69A5, KANJI_LEVEL4,  // 榥
	0x69AD, KANJI_LEVEL4,  // 榭
	0x69CF, KANJI_LEVEL4,  // 槏
	0x3BB6, KANJI_LEVEL4,  // 㮶
	0x3BC3, KANJI_LEVEL4,  // 㯃
	0x69E2, KANJI_LEVEL4,  // 槢
	0x69E9, KANJI_LEVEL4,  // 槩
	0x69EA, KANJI_LEVEL4,  // 槪
	0x69F5, KANJI_LEVEL4,  // 槵
	0x69F6, KANJI_LEVEL4,  // 槶
	0x6A0F, KANJI_LEVEL4,  // 樏
	0x6A15, KANJI_LEVEL4,  // 樕
	0xD84D, KANJI_LEVEL4,  // �
	0xDF3F, KANJI_LEVEL4,  // �
	0x6A3B, KANJI_LEVEL4,  // 樻
	0x6A3E, KANJI_LEVEL4,  // 樾
	0x6A45, KANJI_LEVEL4,  // 橅
	0x6A50, KANJI_LEVEL4,  // 橐
	0x6A56, KANJI_LEVEL4,  // 橖
	0x6A5B, KANJI_LEVEL4,  // 橛
	0x6A6B, KANJI_LEVEL4,  // 橫
	0x6A73, KANJI_LEVEL4,  // 橳
	0xD84D, KANJI_LEVEL4,  // �
	0xDF63, KANJI_LEVEL4,  // �
	0x6A89, KANJI_LEVEL4,  // 檉
	0x6A94, KANJI_LEVEL4,  // 檔
	0x6A9D, KANJI_LEVEL4,  // 檝
	0x6A9E, KANJI_LEVEL4,  // 檞
	0x6AA5, KANJI_LEVEL4,  // 檥
	0x6AE4, KANJI_LEVEL4,  // 櫤
	0x6AE7, KANJI_LEVEL4,  // 櫧
	0x3C0F, KANJI_LEVEL4,  // 㰏
	0xF91D, KANJI_LEVEL4,  // 欄
	0x6B1B, KANJI_LEVEL4,  // 欛
	0x6B1E, KANJI_LEVEL4,  // 欞
	0x6B2C, KANJI_LEVEL4,  // 欬
	0x6B35, KANJI_LEVEL4,  // 欵
	0x6B46, KANJI_LEVEL4,  // 歆
	0x6B56, KANJI_LEVEL4,  // 歖
	0x6B60, KANJI_LEVEL4,  // 歠
	0x6B65, KANJI_LEVEL4,  // 步
	0x6B67, KANJI_LEVEL4,  // 歧
	0x6B77, KANJI_LEVEL4,  // 歷
	0x6B82, KANJI_LEVEL4,  // 殂
	0x6BA9, KANJI_LEVEL4,  // 殩
	0x6BAD, KANJI_LEVEL4,  // 殭
	0xF970, KANJI_LEVEL4,  // 殺
	0x6BCF, KANJI_LEVEL4,  // 每
	0x6BD6, KANJI_LEVEL4,  // 毖
	0x6BD7, KANJI_LEVEL4,  // 毗
	0x6BFF, KANJI_LEVEL4,  // 毿
	0x6C05, KANJI_LEVEL4,  // 氅
	0x6C10, KANJI_LEVEL4,  // 氐
	0x6C33, KANJI_LEVEL4,  // 氳
	0x6C59, KANJI_LEVEL4,  // 汙
	0x6C5C, KANJI_LEVEL4,  // 汜
	0x6CAA, KANJI_LEVEL4,  // 沪
	0x6C74, KANJI_LEVEL4,  // 汴
	0x6C76, KANJI_LEVEL4,  // 汶
	0x6C85, KANJI_LEVEL4,  // 沅
	0x6C86, KANJI_LEVEL4,  // 沆
	0x6C98, KANJI_LEVEL4,  // 沘
	0x6C9C, KANJI_LEVEL4,  // 沜
	0x6CFB, KANJI_LEVEL4,  // 泻
	0x6CC6, KANJI_LEVEL4,  // 泆
	0x6CD4, KANJI_LEVEL4,  // 泔
	0x6CE0, KANJI_LEVEL4,  // 泠
	0x6CEB, KANJI_LEVEL4,  // 泫
	0x6CEE, KANJI_LEVEL4,  // 泮
	0xD84F, KANJI_LEVEL4,  // �
	0xDCFE, KANJI_LEVEL4,  // �
	0x6D04, KANJI_LEVEL4,  // 洄
	0x6D0E, KANJI_LEVEL4,  // 洎
	0x6D2E, KANJI_LEVEL4,  // 洮
	0x6D31, KANJI_LEVEL4,  // 洱
	0x6D39, KANJI_LEVEL4,  // 洹
	0x6D3F, KANJI_LEVEL4,  // 洿
	0x6D58, KANJI_LEVEL4,  // 浘
	0x6D65, KANJI_LEVEL4,  // 浥
	0xFA45, KANJI_LEVEL4,  // 海
	0x6D82, KANJI_LEVEL4,  // 涂
	0x6D87, KANJI_LEVEL4,  // 涇
	0x6D89, KANJI_LEVEL4,  // 涉
	0x6D94, KANJI_LEVEL4,  // 涔
	0x6DAA, KANJI_LEVEL4,  // 涪
	0x6DAC, KANJI_LEVEL4,  // 涬
	0x6DBF, KANJI_LEVEL4,  // 涿
	0x6DC4, KANJI_LEVEL4,  // 淄
	0x6DD6, KANJI_LEVEL4,  // 淖
	0x6DDA, KANJI_LEVEL4,  // 淚
	0x6DDB, KANJI_LEVEL4,  // 淛
	0x6DDD, KANJI_LEVEL4,  // 淝
	0x6DFC, KANJI_LEVEL4,  // 淼
	0xFA46, KANJI_LEVEL4,  // 渚
	0x6E34, KANJI_LEVEL4,  // 渴
	0x6E44, KANJI_LEVEL4,  // 湄
	0x6E5C, KANJI_LEVEL4,  // 湜
	0x6E5E, KANJI_LEVEL4,  // 湞
	0x6EAB, KANJI_LEVEL4,  // 溫
	0x6EB1, KANJI_LEVEL4,  // 溱
	0x6EC1, KANJI_LEVEL4,  // 滁
	0x6EC7, KANJI_LEVEL4,  // 滇
	0x6ECE, KANJI_LEVEL4,  // 滎
	0x6F10, KANJI_LEVEL4,  // 漐
	0x6F1A, KANJI_LEVEL4,  // 漚
	0xFA47, KANJI_LEVEL4,  // 漢
	0x6F2A, KANJI_LEVEL4,  // 漪
	0x6F2F, KANJI_LEVEL4,  // 漯
	0x6F33, KANJI_LEVEL4,  // 漳
	0x6F51, KANJI_LEVEL4,  // 潑
	0x6F59, KANJI_LEVEL4,  // 潙
	0x6F5E, KANJI_LEVEL4,  // 潞
	0x6F61, KANJI_LEVEL4,  // 潡
	0x6F62, KANJI_LEVEL4,  // 潢
	0x6F7E, KANJI_LEVEL4,  // 潾
	0x6F88, KANJI_LEVEL4,  // 澈
	0x6F8C, KANJI_LEVEL4,  // 澌
	0x6F8D, KANJI_LEVEL4,  // 澍
	0x6F94, KANJI_LEVEL4,  // 澔
	0x6FA0, KANJI_LEVEL4,  // 澠
	0x6FA7, KANJI_LEVEL4,  // 澧
	0x6FB6, KANJI_LEVEL4,  // 澶
	0x6FBC, KANJI_LEVEL4,  // 澼
	0x6FC7, KANJI_LEVEL4,  // 濇
	0x6FCA, KANJI_LEVEL4,  // 濊
	0x6FF9, KANJI_LEVEL4,  // 濹
	0x6FF0, KANJI_LEVEL4,  // 濰
	0x6FF5, KANJI_LEVEL4,  // 濵
	0x7005, KANJI_LEVEL4,  // 瀅
	0x7006, KANJI_LEVEL4,  // 瀆
	0x7028, KANJI_LEVEL4,  // 瀨
	0x704A, KANJI_LEVEL4,  // 灊
	0x705D, KANJI_LEVEL4,  // 灝
	0x705E, KANJI_LEVEL4,  // 灞
	0x704E, KANJI_LEVEL4,  // 灎
	0x7064, KANJI_LEVEL4,  // 灤
	0x7075, KANJI_LEVEL4,  // 灵
	0x7085, KANJI_LEVEL4,  // 炅
	0x70A4, KANJI_LEVEL4,  // 炤
	0x70AB, KANJI_LEVEL4,  // 炫
	0x70B7, KANJI_LEVEL4,  // 炷
	0x70D4, KANJI_LEVEL4,  // 烔
	0x70D8, KANJI_LEVEL4,  // 烘
	0x70E4, KANJI_LEVEL4,  // 烤
	0x710F, KANJI_LEVEL4,  // 焏
	0x712B, KANJI_LEVEL4,  // 焫
	0x711E, KANJI_LEVEL4,  // 焞
	0x7120, KANJI_LEVEL4,  // 焠
	0x712E, KANJI_LEVEL4,  // 焮
	0x7130, KANJI_LEVEL4,  // 焰
	0x7146, KANJI_LEVEL4,  // 煆
	0x7147, KANJI_LEVEL4,  // 煇
	0x7151, KANJI_LEVEL4,  // 煑
	0xFA48, KANJI_LEVEL4,  // 煮
	0x7152, KANJI_LEVEL4,  // 煒
	0x715C, KANJI_LEVEL4,  // 煜
	0x7160, KANJI_LEVEL4,  // 煠
	0x7168, KANJI_LEVEL4,  // 煨
	0xFA15, KANJI_LEVEL4,  // 凞
	0x7185, KANJI_LEVEL4,  // 熅
	0x7187, KANJI_LEVEL4,  // 熇
	0x7192, KANJI_LEVEL4,  // 熒
	0x71C1, KANJI_LEVEL4,  // 燁
	0x71BA, KANJI_LEVEL4,  // 熺
	0x71C4, KANJI_LEVEL4,  // 燄
	0x71FE, KANJI_LEVEL4,  // 燾
	0x7200, KANJI_LEVEL4,  // 爀
	0x7215, KANJI_LEVEL4,  // 爕
	0x7255, KANJI_LEVEL4,  // 牕
	0x7256, KANJI_LEVEL4,  // 牖
	0x3E3F, KANJI_LEVEL4,  // 㸿
	0x728D, KANJI_LEVEL4,  // 犍
	0x729B, KANJI_LEVEL4,  // 犛
	0x72BE, KANJI_LEVEL4,  // 犾
	0x72C0, KANJI_LEVEL4,  // 狀
	0x72FB, KANJI_LEVEL4,  // 狻
	0xD851, KANJI_LEVEL4,  // �
	0xDFF1, KANJI_LEVEL4,  // �
	0x7327, KANJI_LEVEL4,  // 猧
	0x7328, KANJI_LEVEL4,  // 猨
	0xFA16, KANJI_LEVEL4,  // 猪
	0x7350, KANJI_LEVEL4,  // 獐
	0x7366, KANJI_LEVEL4,  // 獦
	0x737C, KANJI_LEVEL4,  // 獼
	0x7395, KANJI_LEVEL4,  // 玕
	0x739F, KANJI_LEVEL4,  // 玟
	0x73A0, KANJI_LEVEL4,  // 玠
	0x73A2, KANJI_LEVEL4,  // 玢
	0x73A6, KANJI_LEVEL4,  // 玦
	0x73AB, KANJI_LEVEL4,  // 玫
	0x73C9, KANJI_LEVEL4,  // 珉
	0x73CF, KANJI_LEVEL4,  // 珏
	0x73D6, KANJI_LEVEL4,  // 珖
	0x73D9, KANJI_LEVEL4,  // 珙
	0x73E3, KANJI_LEVEL4,  // 珣
	0x73E9, KANJI_LEVEL4,  // 珩
	0x7407, KANJI_LEVEL4,  // 琇
	0x740A, KANJI_LEVEL4,  // 琊
	0x741A, KANJI_LEVEL4,  // 琚
	0x741B, KANJI_LEVEL4,  // 琛
	0xFA4A, KANJI_LEVEL4,  // 琢
	0x7426, KANJI_LEVEL4,  // 琦
	0x7428, KANJI_LEVEL4,  // 琨
	0x742A, KANJI_LEVEL4,  // 琪
	0x742B, KANJI_LEVEL4,  // 琫
	0x742C, KANJI_LEVEL4,  // 琬
	0x742E, KANJI_LEVEL4,  // 琮
	0x742F, KANJI_LEVEL4,  // 琯
	0x7430, KANJI_LEVEL4,  // 琰
	0x7444, KANJI_LEVEL4,  // 瑄
	0x7446, KANJI_LEVEL4,  // 瑆
	0x7447, KANJI_LEVEL4,  // 瑇
	0x744B, KANJI_LEVEL4,  // 瑋
	0x7457, KANJI_LEVEL4,  // 瑗
	0x7462, KANJI_LEVEL4,  // 瑢
	0x746B, KANJI_LEVEL4,  // 瑫
	0x746D, KANJI_LEVEL4,  // 瑭
	0x7486, KANJI_LEVEL4,  // 璆
	0x7487, KANJI_LEVEL4,  // 璇
	0x7489, KANJI_LEVEL4,  // 璉
	0x7498, KANJI_LEVEL4,  // 璘
	0x749C, KANJI_LEVEL4,  // 璜
	0x749F, KANJI_LEVEL4,  // 璟
	0x74A3, KANJI_LEVEL4,  // 璣
	0x7490, KANJI_LEVEL4,  // 璐
	0x74A6, KANJI_LEVEL4,  // 璦
	0x74A8, KANJI_LEVEL4,  // 璨
	0x74A9, KANJI_LEVEL4,  // 璩
	0x74B5, KANJI_LEVEL4,  // 璵
	0x74BF, KANJI_LEVEL4,  // 璿
	0x74C8, KANJI_LEVEL4,  // 瓈
	0x74C9, KANJI_LEVEL4,  // 瓉
	0x74DA, KANJI_LEVEL4,  // 瓚
	0x74FF, KANJI_LEVEL4,  // 瓿
	0x7501, KANJI_LEVEL4,  // 甁
	0x7517, KANJI_LEVEL4,  // 甗
	0x752F, KANJI_LEVEL4,  // 甯
	0x756F, KANJI_LEVEL4,  // 畯
	0x7579, KANJI_LEVEL4,  // 畹
	0x7592, KANJI_LEVEL4,  // 疒
	0x3F72, KANJI_LEVEL4,  // 㽲
	0x75CE, KANJI_LEVEL4,  // 痎
	0x75E4, KANJI_LEVEL4,  // 痤
	0x7600, KANJI_LEVEL4,  // 瘀
	0x7602, KANJI_LEVEL4,  // 瘂
	0x7608, KANJI_LEVEL4,  // 瘈
	0x7615, KANJI_LEVEL4,  // 瘕
	0x7616, KANJI_LEVEL4,  // 瘖
	0x7619, KANJI_LEVEL4,  // 瘙
	0x761E, KANJI_LEVEL4,  // 瘞
	0x762D, KANJI_LEVEL4,  // 瘭
	0x7635, KANJI_LEVEL4,  // 瘵
	0x7643, KANJI_LEVEL4,  // 癃
	0x764B, KANJI_LEVEL4,  // 癋
	0x7664, KANJI_LEVEL4,  // 癤
	0x7665, KANJI_LEVEL4,  // 癥
	0x766D, KANJI_LEVEL4,  // 癭
	0x766F, KANJI_LEVEL4,  // 癯
	0x7671, KANJI_LEVEL4,  // 癱
	0x7681, KANJI_LEVEL4,  // 皁
	0x769B, KANJI_LEVEL4,  // 皛
	0x769D, KANJI_LEVEL4,  // 皝
	0x769E, KANJI_LEVEL4,  // 皞
	0x76A6, KANJI_LEVEL4,  // 皦
	0x76AA, KANJI_LEVEL4,  // 皪
	0x76B6, KANJI_LEVEL4,  // 皶
	0x76C5, KANJI_LEVEL4,  // 盅
	0x76CC, KANJI_LEVEL4,  // 盌
	0x76CE, KANJI_LEVEL4,  // 盎
	0x76D4, KANJI_LEVEL4,  // 盔
	0x76E6, KANJI_LEVEL4,  // 盦
	0x76F1, KANJI_LEVEL4,  // 盱
	0x76FC, KANJI_LEVEL4,  // 盼
	0x770A, KANJI_LEVEL4,  // 眊
	0x7719, KANJI_LEVEL4,  // 眙
	0x7734, KANJI_LEVEL4,  // 眴
	0x7736, KANJI_LEVEL4,  // 眶
	0x7746, KANJI_LEVEL4,  // 睆
	0x774D, KANJI_LEVEL4,  // 睍
	0x774E, KANJI_LEVEL4,  // 睎
	0x775C, KANJI_LEVEL4,  // 睜
	0x775F, KANJI_LEVEL4,  // 睟
	0x7762, KANJI_LEVEL4,  // 睢
	0x777A, KANJI_LEVEL4,  // 睺
	0x7780, KANJI_LEVEL4,  // 瞀
	0x7794, KANJI_LEVEL4,  // 瞔
	0x77AA, KANJI_LEVEL4,  // 瞪
	0x77E0, KANJI_LEVEL4,  // 矠
	0x782D, KANJI_LEVEL4,  // 砭
	0xD855, KANJI_LEVEL4,  // �
	0xDC8E, KANJI_LEVEL4,  // �
	0x7843, KANJI_LEVEL4,  // 硃
	0x784E, KANJI_LEVEL4,  // 硎
	0x784F, KANJI_LEVEL4,  // 硏
	0x7851, KANJI_LEVEL4,  // 硑
	0x7868, KANJI_LEVEL4,  // 硨
	0x786E, KANJI_LEVEL4,  // 确
	0xFA4B, KANJI_LEVEL4,  // 碑
	0x78B0, KANJI_LEVEL4,  // 碰
	0xD855, KANJI_LEVEL4,  // �
	0xDD0E, KANJI_LEVEL4,  // �
	0x78AD, KANJI_LEVEL4,  // 碭
	0x78E4, KANJI_LEVEL4,  // 磤
	0x78F2, KANJI_LEVEL4,  // 磲
	0x7900, KANJI_LEVEL4,  // 礀
	0x78F7, KANJI_LEVEL4,  // 磷
	0x791C, KANJI_LEVEL4,  // 礜
	0x792E, KANJI_LEVEL4,  // 礮
	0x7931, KANJI_LEVEL4,  // 礱
	0x7934, KANJI_LEVEL4,  // 礴
	0xFA4C, KANJI_LEVEL4,  // 社
	0xFA4D, KANJI_LEVEL4,  // 祉
	0x7945, KANJI_LEVEL4,  // 祅
	0x7946, KANJI_LEVEL4,  // 祆
	0xFA4E, KANJI_LEVEL4,  // 祈
	0xFA4F, KANJI_LEVEL4,  // 祐
	0xFA50, KANJI_LEVEL4,  // 祖
	0x795C, KANJI_LEVEL4,  // 祜
	0xFA51, KANJI_LEVEL4,  // 祝
	0xFA19, KANJI_LEVEL4,  // 神
	0xFA1A, KANJI_LEVEL4,  // 祥
	0x7979, KANJI_LEVEL4,  // 祹
	0xFA52, KANJI_LEVEL4,  // 禍
	0xFA53, KANJI_LEVEL4,  // 禎
	0xFA1B, KANJI_LEVEL4,  // 福
	0x7998, KANJI_LEVEL4,  // 禘
	0x79B1, KANJI_LEVEL4,  // 禱
	0x79B8, KANJI_LEVEL4,  // 禸
	0x79C8, KANJI_LEVEL4,  // 秈
	0x79CA, KANJI_LEVEL4,  // 秊
	0xD855, KANJI_LEVEL4,  // �
	0xDF71, KANJI_LEVEL4,  // �
	0x79D4, KANJI_LEVEL4,  // 秔
	0x79DE, KANJI_LEVEL4,  // 秞
	0x79EB, KANJI_LEVEL4,  // 秫
	0x79ED, KANJI_LEVEL4,  // 秭
	0x7A03, KANJI_LEVEL4,  // 稃
	0xFA54, KANJI_LEVEL4,  // 穀
	0x7A39, KANJI_LEVEL4,  // 稹
	0x7A5D, KANJI_LEVEL4,  // 穝
	0x7A6D, KANJI_LEVEL4,  // 穭
	0xFA55, KANJI_LEVEL4,  // 突
	0x7A85, KANJI_LEVEL4,  // 窅
	0x7AA0, KANJI_LEVEL4,  // 窠
	0xD856, KANJI_LEVEL4,  // �
	0xDDC4, KANJI_LEVEL4,  // �
	0x7AB3, KANJI_LEVEL4,  // 窳
	0x7ABB, KANJI_LEVEL4,  // 窻
	0x7ACE, KANJI_LEVEL4,  // 竎
	0x7AEB, KANJI_LEVEL4,  // 竫
	0x7AFD, KANJI_LEVEL4,  // 竽
	0x7B12, KANJI_LEVEL4,  // 笒
	0x7B2D, KANJI_LEVEL4,  // 笭
	0x7B3B, KANJI_LEVEL4,  // 笻
	0x7B47, KANJI_LEVEL4,  // 筇
	0x7B4E, KANJI_LEVEL4,  // 筎
	0x7B60, KANJI_LEVEL4,  // 筠
	0x7B6D, KANJI_LEVEL4,  // 筭
	0x7B6F, KANJI_LEVEL4,  // 筯
	0x7B72, KANJI_LEVEL4,  // 筲
	0x7B9E, KANJI_LEVEL4,  // 箞
	0xFA56, KANJI_LEVEL4,  // 節
	0x7BD7, KANJI_LEVEL4,  // 篗
	0x7BD9, KANJI_LEVEL4,  // 篙
	0x7C01, KANJI_LEVEL4,  // 簁
	0x7C31, KANJI_LEVEL4,  // 簱
	0x7C1E, KANJI_LEVEL4,  // 簞
	0x7C20, KANJI_LEVEL4,  // 簠
	0x7C33, KANJI_LEVEL4,  // 簳
	0x7C36, KANJI_LEVEL4,  // 簶
	0x4264, KANJI_LEVEL4,  // 䉤
	0xD857, KANJI_LEVEL4,  // �
	0xDDA1, KANJI_LEVEL4,  // �
	0x7C59, KANJI_LEVEL4,  // 籙
	0x7C6D, KANJI_LEVEL4,  // 籭
	0x7C79, KANJI_LEVEL4,  // 籹
	0x7C8F, KANJI_LEVEL4,  // 粏
	0x7C94, KANJI_LEVEL4,  // 粔
	0x7CA0, KANJI_LEVEL4,  // 粠
	0x7CBC, KANJI_LEVEL4,  // 粼
	0x7CD5, KANJI_LEVEL4,  // 糕
	0x7CD9, KANJI_LEVEL4,  // 糙
	0x7CDD, KANJI_LEVEL4,  // 糝
	0x7D07, KANJI_LEVEL4,  // 紇
	0x7D08, KANJI_LEVEL4,  // 紈
	0x7D13, KANJI_LEVEL4,  // 紓
	0x7D1D, KANJI_LEVEL4,  // 紝
	0x7D23, KANJI_LEVEL4,  // 紣
	0x7D31, KANJI_LEVEL4,  // 紱
	0x7D41, KANJI_LEVEL4,  // 絁
	0x7D48, KANJI_LEVEL4,  // 絈
	0x7D53, KANJI_LEVEL4,  // 絓
	0x7D5C, KANJI_LEVEL4,  // 絜
	0x7D7A, KANJI_LEVEL4,  // 絺
	0x7D83, KANJI_LEVEL4,  // 綃
	0x7D8B, KANJI_LEVEL4,  // 綋
	0x7DA0, KANJI_LEVEL4,  // 綠
	0x7DA6, KANJI_LEVEL4,  // 綦
	0x7DC2, KANJI_LEVEL4,  // 緂
	0x7DCC, KANJI_LEVEL4,  // 緌
	0x7DD6, KANJI_LEVEL4,  // 緖
	0x7DE3, KANJI_LEVEL4,  // 緣
	0xFA57, KANJI_LEVEL4,  // 練
	0x7E28, KANJI_LEVEL4,  // 縨
	0x7E08, KANJI_LEVEL4,  // 縈
	0x7E11, KANJI_LEVEL4,  // 縑
	0x7E15, KANJI_LEVEL4,  // 縕
	0xFA59, KANJI_LEVEL4,  // 繁
	0x7E47, KANJI_LEVEL4,  // 繇
	0x7E52, KANJI_LEVEL4,  // 繒
	0x7E61, KANJI_LEVEL4,  // 繡
	0x7E8A, KANJI_LEVEL4,  // 纊
	0x7E8D, KANJI_LEVEL4,  // 纍
	0x7F47, KANJI_LEVEL4,  // 罇
	0xFA5A, KANJI_LEVEL4,  // 署
	0x7F91, KANJI_LEVEL4,  // 羑
	0x7F97, KANJI_LEVEL4,  // 羗
	0x7FBF, KANJI_LEVEL4,  // 羿
	0x7FCE, KANJI_LEVEL4,  // 翎
	0x7FDB, KANJI_LEVEL4,  // 翛
	0x7FDF, KANJI_LEVEL4,  // 翟
	0x7FEC, KANJI_LEVEL4,  // 翬
	0x7FEE, KANJI_LEVEL4,  // 翮
	0x7FFA, KANJI_LEVEL4,  // 翺
	0xFA5B, KANJI_LEVEL4,  // 者
	0x8014, KANJI_LEVEL4,  // 耔
	0x8026, KANJI_LEVEL4,  // 耦
	0x8035, KANJI_LEVEL4,  // 耵
	0x8037, KANJI_LEVEL4,  // 耷
	0x803C, KANJI_LEVEL4,  // 耼
	0x80CA, KANJI_LEVEL4,  // 胊
	0x80D7, KANJI_LEVEL4,  // 胗
	0x80E0, KANJI_LEVEL4,  // 胠
	0x80F3, KANJI_LEVEL4,  // 胳
	0x8118, KANJI_LEVEL4,  // 脘
	0x814A, KANJI_LEVEL4,  // 腊
	0x8160, KANJI_LEVEL4,  // 腠
	0x8167, KANJI_LEVEL4,  // 腧
	0x8168, KANJI_LEVEL4,  // 腨
	0x816D, KANJI_LEVEL4,  // 腭
	0x81BB, KANJI_LEVEL4,  // 膻
	0x81CA, KANJI_LEVEL4,  // 臊
	0x81CF, KANJI_LEVEL4,  // 臏
	0x81D7, KANJI_LEVEL4,  // 臗
	0xFA5C, KANJI_LEVEL4,  // 臭
	0x4453, KANJI_LEVEL4,  // 䑓
	0x445B, KANJI_LEVEL4,  // 䑛
	0x8260, KANJI_LEVEL4,  // 艠
	0x8274, KANJI_LEVEL4,  // 艴
	0xD85A, KANJI_LEVEL4,  // �
	0xDEFF, KANJI_LEVEL4,  // �
	0x828E, KANJI_LEVEL4,  // 芎
	0x82A1, KANJI_LEVEL4,  // 芡
	0x82A3, KANJI_LEVEL4,  // 芣
	0x82A4, KANJI_LEVEL4,  // 芤
	0x82A9, KANJI_LEVEL4,  // 芩
	0x82AE, KANJI_LEVEL4,  // 芮
	0x82B7, KANJI_LEVEL4,  // 芷
	0x82BE, KANJI_LEVEL4,  // 芾
	0x82BF, KANJI_LEVEL4,  // 芿
	0x82C6, KANJI_LEVEL4,  // 苆
	0x82D5, KANJI_LEVEL4,  // 苕
	0x82FD, KANJI_LEVEL4,  // 苽
	0x82FE, KANJI_LEVEL4,  // 苾
	0x8300, KANJI_LEVEL4,  // 茀
	0x8301, KANJI_LEVEL4,  // 茁
	0x8362, KANJI_LEVEL4,  // 荢
	0x8322, KANJI_LEVEL4,  // 茢
	0x832D, KANJI_LEVEL4,  // 茭
	0x833A, KANJI_LEVEL4,  // 茺
	0x8343, KANJI_LEVEL4,  // 荃
	0x8347, KANJI_LEVEL4,  // 荇
	0x8351, KANJI_LEVEL4,  // 荑
	0x8355, KANJI_LEVEL4,  // 荕
	0x837D, KANJI_LEVEL4,  // 荽
	0x8386, KANJI_LEVEL4,  // 莆
	0x8392, KANJI_LEVEL4,  // 莒
	0x8398, KANJI_LEVEL4,  // 莘
	0x83A7, KANJI_LEVEL4,  // 莧
	0x83A9, KANJI_LEVEL4,  // 莩
	0x83BF, KANJI_LEVEL4,  // 莿
	0x83C0, KANJI_LEVEL4,  // 菀
	0x83C7, KANJI_LEVEL4,  // 菇
	0x83CF, KANJI_LEVEL4,  // 菏
	0x83D1, KANJI_LEVEL4,  // 菑
	0x83E1, KANJI_LEVEL4,  // 菡
	0x83EA, KANJI_LEVEL4,  // 菪
	0x8401, KANJI_LEVEL4,  // 萁
	0x8406, KANJI_LEVEL4,  // 萆
	0x840A, KANJI_LEVEL4,  // 萊
	0xFA5F, KANJI_LEVEL4,  // 著
	0x8448, KANJI_LEVEL4,  // 葈
	0x845F, KANJI_LEVEL4,  // 葟
	0x8470, KANJI_LEVEL4,  // 葰
	0x8473, KANJI_LEVEL4,  // 葳
	0x8485, KANJI_LEVEL4,  // 蒅
	0x849E, KANJI_LEVEL4,  // 蒞
	0x84AF, KANJI_LEVEL4,  // 蒯
	0x84B4, KANJI_LEVEL4,  // 蒴
	0x84BA, KANJI_LEVEL4,  // 蒺
	0x84C0, KANJI_LEVEL4,  // 蓀
	0x84C2, KANJI_LEVEL4,  // 蓂
	0xD85B, KANJI_LEVEL4,  // �
	0xDE40, KANJI_LEVEL4,  // �
	0x8532, KANJI_LEVEL4,  // 蔲
	0x851E, KANJI_LEVEL4,  // 蔞
	0x8523, KANJI_LEVEL4,  // 蔣
	0x852F, KANJI_LEVEL4,  // 蔯
	0x8559, KANJI_LEVEL4,  // 蕙
	0x8564, KANJI_LEVEL4,  // 蕤
	0xFA1F, KANJI_LEVEL4,  // 﨟
	0x85AD, KANJI_LEVEL4,  // 薭
	0x857A, KANJI_LEVEL4,  // 蕺
	0x858C, KANJI_LEVEL4,  // 薌
	0x858F, KANJI_LEVEL4,  // 薏
	0x85A2, KANJI_LEVEL4,  // 薢
	0x85B0, KANJI_LEVEL4,  // 薰
	0x85CB, KANJI_LEVEL4,  // 藋
	0x85CE, KANJI_LEVEL4,  // 藎
	0x85ED, KANJI_LEVEL4,  // 藭
	0x8612, KANJI_LEVEL4,  // 蘒
	0x85FF, KANJI_LEVEL4,  // 藿
	0x8604, KANJI_LEVEL4,  // 蘄
	0x8605, KANJI_LEVEL4,  // 蘅
	0x8610, KANJI_LEVEL4,  // 蘐
	0xD85C, KANJI_LEVEL4,  // �
	0xDCF4, KANJI_LEVEL4,  // �
	0x8618, KANJI_LEVEL4,  // 蘘
	0x8629, KANJI_LEVEL4,  // 蘩
	0x8638, KANJI_LEVEL4,  // 蘸
	0x8657, KANJI_LEVEL4,  // 虗
	0x865B, KANJI_LEVEL4,  // 虛
	0xF936, KANJI_LEVEL4,  // 虜
	0x8662, KANJI_LEVEL4,  // 虢
	0x459D, KANJI_LEVEL4,  // 䖝
	0x866C, KANJI_LEVEL4,  // 虬
	0x8675, KANJI_LEVEL4,  // 虵
	0x8698, KANJI_LEVEL4,  // 蚘
	0x86B8, KANJI_LEVEL4,  // 蚸
	0x86FA, KANJI_LEVEL4,  // 蛺
	0x86FC, KANJI_LEVEL4,  // 蛼
	0x86FD, KANJI_LEVEL4,  // 蛽
	0x870B, KANJI_LEVEL4,  // 蜋
	0x8771, KANJI_LEVEL4,  // 蝱
	0x8787, KANJI_LEVEL4,  // 螇
	0x8788, KANJI_LEVEL4,  // 螈
	0x87AC, KANJI_LEVEL4,  // 螬
	0x87AD, KANJI_LEVEL4,  // 螭
	0x87B5, KANJI_LEVEL4,  // 螵
	0x45EA, KANJI_LEVEL4,  // 䗪
	0x87D6, KANJI_LEVEL4,  // 蟖
	0x87EC, KANJI_LEVEL4,  // 蟬
	0x8806, KANJI_LEVEL4,  // 蠆
	0x880A, KANJI_LEVEL4,  // 蠊
	0x8810, KANJI_LEVEL4,  // 蠐
	0x8814, KANJI_LEVEL4,  // 蠔
	0x881F, KANJI_LEVEL4,  // 蠟
	0x8898, KANJI_LEVEL4,  // 袘
	0x88AA, KANJI_LEVEL4,  // 袪
	0x88CA, KANJI_LEVEL4,  // 裊
	0x88CE, KANJI_LEVEL4,  // 裎
	0xD85D, KANJI_LEVEL4,  // �
	0xDE84, KANJI_LEVEL4,  // �
	0x88F5, KANJI_LEVEL4,  // 裵
	0x891C, KANJI_LEVEL4,  // 褜
	0xFA60, KANJI_LEVEL4,  // 褐
	0x8918, KANJI_LEVEL4,  // 褘
	0x8919, KANJI_LEVEL4,  // 褙
	0x891A, KANJI_LEVEL4,  // 褚
	0x8927, KANJI_LEVEL4,  // 褧
	0x8930, KANJI_LEVEL4,  // 褰
	0x8932, KANJI_LEVEL4,  // 褲
	0x8939, KANJI_LEVEL4,  // 褹
	0x8940, KANJI_LEVEL4,  // 襀
	0x8994, KANJI_LEVEL4,  // 覔
	0xFA61, KANJI_LEVEL4,  // 視
	0x89D4, KANJI_LEVEL4,  // 觔
	0x89E5, KANJI_LEVEL4,  // 觥
	0x89F6, KANJI_LEVEL4,  // 觶
	0x8A12, KANJI_LEVEL4,  // 訒
	0x8A15, KANJI_LEVEL4,  // 訕
	0x8A22, KANJI_LEVEL4,  // 訢
	0x8A37, KANJI_LEVEL4,  // 訷
	0x8A47, KANJI_LEVEL4,  // 詇
	0x8A4E, KANJI_LEVEL4,  // 詎
	0x8A5D, KANJI_LEVEL4,  // 詝
	0x8A61, KANJI_LEVEL4,  // 詡
	0x8A75, KANJI_LEVEL4,  // 詵
	0x8A79, KANJI_LEVEL4,  // 詹
	0x8AA7, KANJI_LEVEL4,  // 誧
	0x8AD0, KANJI_LEVEL4,  // 諐
	0x8ADF, KANJI_LEVEL4,  // 諟
	0x8AF4, KANJI_LEVEL4,  // 諴
	0x8AF6, KANJI_LEVEL4,  // 諶
	0xFA22, KANJI_LEVEL4,  // 諸
	0xFA62, KANJI_LEVEL4,  // 謁
	0xFA63, KANJI_LEVEL4,  // 謹
	0x8B46, KANJI_LEVEL4,  // 譆
	0x8B54, KANJI_LEVEL4,  // 譔
	0x8B59, KANJI_LEVEL4,  // 譙
	0x8B69, KANJI_LEVEL4,  // 譩
	0x8B9D, KANJI_LEVEL4,  // 讝
	0x8C49, KANJI_LEVEL4,  // 豉
	0x8C68, KANJI_LEVEL4,  // 豨
	0xFA64, KANJI_LEVEL4,  // 賓
	0x8CE1, KANJI_LEVEL4,  // 賡
	0x8CF4, KANJI_LEVEL4,  // 賴
	0x8CF8, KANJI_LEVEL4,  // 賸
	0x8CFE, KANJI_LEVEL4,  // 賾
	0xFA65, KANJI_LEVEL4,  // 贈
	0x8D12, KANJI_LEVEL4,  // 贒
	0x8D1B, KANJI_LEVEL4,  // 贛
	0x8DAF, KANJI_LEVEL4,  // 趯
	0x8DCE, KANJI_LEVEL4,  // 跎
	0x8DD1, KANJI_LEVEL4,  // 跑
	0x8DD7, KANJI_LEVEL4,  // 跗
	0x8E20, KANJI_LEVEL4,  // 踠
	0x8E23, KANJI_LEVEL4,  // 踣
	0x8E3D, KANJI_LEVEL4,  // 踽
	0x8E70, KANJI_LEVEL4,  // 蹰
	0x8E7B, KANJI_LEVEL4,  // 蹻
	0xD860, KANJI_LEVEL4,  // �
	0xDE77, KANJI_LEVEL4,  // �
	0x8EC0, KANJI_LEVEL4,  // 軀
	0x4844, KANJI_LEVEL4,  // 䡄
	0x8EFA, KANJI_LEVEL4,  // 軺
	0x8F1E, KANJI_LEVEL4,  // 輞
	0x8F2D, KANJI_LEVEL4,  // 輭
	0x8F36, KANJI_LEVEL4,  // 輶
	0x8F54, KANJI_LEVEL4,  // 轔
	0xD860, KANJI_LEVEL4,  // �
	0xDFCD, KANJI_LEVEL4,  // �
	0x8FA6, KANJI_LEVEL4,  // 辦
	0x8FB5, KANJI_LEVEL4,  // 辵
	0x8FE4, KANJI_LEVEL4,  // 迤
	0x8FE8, KANJI_LEVEL4,  // 迨
	0x8FEE, KANJI_LEVEL4,  // 迮
	0x9008, KANJI_LEVEL4,  // 逈
	0x902D, KANJI_LEVEL4,  // 逭
	0xFA67, KANJI_LEVEL4,  // 逸
	0x9088, KANJI_LEVEL4,  // 邈
	0x9095, KANJI_LEVEL4,  // 邕
	0x9097, KANJI_LEVEL4,  // 邗
	0x9099, KANJI_LEVEL4,  // 邙
	0x909B, KANJI_LEVEL4,  // 邛
	0x90A2, KANJI_LEVEL4,  // 邢
	0x90B3, KANJI_LEVEL4,  // 邳
	0x90BE, KANJI_LEVEL4,  // 邾
	0x90C4, KANJI_LEVEL4,  // 郄
	0x90C5, KANJI_LEVEL4,  // 郅
	0x90C7, KANJI_LEVEL4,  // 郇
	0x90D7, KANJI_LEVEL4,  // 郗
	0x90DD, KANJI_LEVEL4,  // 郝
	0x90DE, KANJI_LEVEL4,  // 郞
	0x90EF, KANJI_LEVEL4,  // 郯
	0x90F4, KANJI_LEVEL4,  // 郴
	0xFA26, KANJI_LEVEL4,  // 都
	0x9114, KANJI_LEVEL4,  // 鄔
	0x9115, KANJI_LEVEL4,  // 鄕
	0x9116, KANJI_LEVEL4,  // 鄖
	0x9122, KANJI_LEVEL4,  // 鄢
	0x9123, KANJI_LEVEL4,  // 鄣
	0x9127, KANJI_LEVEL4,  // 鄧
	0x912F, KANJI_LEVEL4,  // 鄯
	0x9131, KANJI_LEVEL4,  // 鄱
	0x9134, KANJI_LEVEL4,  // 鄴
	0x913D, KANJI_LEVEL4,  // 鄽
	0x9148, KANJI_LEVEL4,  // 酈
	0x915B, KANJI_LEVEL4,  // 酛
	0x9183, KANJI_LEVEL4,  // 醃
	0x919E, KANJI_LEVEL4,  // 醞
	0x91AC, KANJI_LEVEL4,  // 醬
	0x91B1, KANJI_LEVEL4,  // 醱
	0x91BC, KANJI_LEVEL4,  // 醼
	0x91D7, KANJI_LEVEL4,  // 釗
	0x91FB, KANJI_LEVEL4,  // 釻
	0x91E4, KANJI_LEVEL4,  // 釤
	0x91E5, KANJI_LEVEL4,  // 釥
	0x91ED, KANJI_LEVEL4,  // 釭
	0x91F1, KANJI_LEVEL4,  // 釱
	0x9207, KANJI_LEVEL4,  // 鈇
	0x9210, KANJI_LEVEL4,  // 鈐
	0x9238, KANJI_LEVEL4,  // 鈸
	0x9239, KANJI_LEVEL4,  // 鈹
	0x923A, KANJI_LEVEL4,  // 鈺
	0x923C, KANJI_LEVEL4,  // 鈼
	0x9240, KANJI_LEVEL4,  // 鉀
	0x9243, KANJI_LEVEL4,  // 鉃
	0x924F, KANJI_LEVEL4,  // 鉏
	0x9278, KANJI_LEVEL4,  // 鉸
	0x9288, KANJI_LEVEL4,  // 銈
	0x92C2, KANJI_LEVEL4,  // 鋂
	0x92CB, KANJI_LEVEL4,  // 鋋
	0x92CC, KANJI_LEVEL4,  // 鋌
	0x92D3, KANJI_LEVEL4,  // 鋓
	0x92E0, KANJI_LEVEL4,  // 鋠
	0x92FF, KANJI_LEVEL4,  // 鋿
	0x9304, KANJI_LEVEL4,  // 錄
	0x931F, KANJI_LEVEL4,  // 錟
	0x9321, KANJI_LEVEL4,  // 錡
	0x9325, KANJI_LEVEL4,  // 錥
	0x9348, KANJI_LEVEL4,  // 鍈
	0x9349, KANJI_LEVEL4,  // 鍉
	0x934A, KANJI_LEVEL4,  // 鍊
	0x9364, KANJI_LEVEL4,  // 鍤
	0x9365, KANJI_LEVEL4,  // 鍥
	0x936A, KANJI_LEVEL4,  // 鍪
	0x9370, KANJI_LEVEL4,  // 鍰
	0x939B, KANJI_LEVEL4,  // 鎛
	0x93A3, KANJI_LEVEL4,  // 鎣
	0x93BA, KANJI_LEVEL4,  // 鎺
	0x93C6, KANJI_LEVEL4,  // 鏆
	0x93DE, KANJI_LEVEL4,  // 鏞
	0x93DF, KANJI_LEVEL4,  // 鏟
	0x9404, KANJI_LEVEL4,  // 鐄
	0x93FD, KANJI_LEVEL4,  // 鏽
	0x9433, KANJI_LEVEL4,  // 鐳
	0x944A, KANJI_LEVEL4,  // 鑊
	0x9463, KANJI_LEVEL4,  // 鑣
	0x946B, KANJI_LEVEL4,  // 鑫
	0x9471, KANJI_LEVEL4,  // 鑱
	0x9472, KANJI_LEVEL4,  // 鑲
	0x958E, KANJI_LEVEL4,  // 閎
	0x959F, KANJI_LEVEL4,  // 閟
	0x95A6, KANJI_LEVEL4,  // 閦
	0x95A9, KANJI_LEVEL4,  // 閩
	0x95AC, KANJI_LEVEL4,  // 閬
	0x95B6, KANJI_LEVEL4,  // 閶
	0x95BD, KANJI_LEVEL4,  // 閽
	0x95CB, KANJI_LEVEL4,  // 闋
	0x95D0, KANJI_LEVEL4,  // 闐
	0x95D3, KANJI_LEVEL4,  // 闓
	0x49B0, KANJI_LEVEL4,  // 䦰
	0x95DA, KANJI_LEVEL4,  // 闚
	0x95DE, KANJI_LEVEL4,  // 闞
	0x9658, KANJI_LEVEL4,  // 陘
	0x9684, KANJI_LEVEL4,  // 隄
	0xF9DC, KANJI_LEVEL4,  // 隆
	0x969D, KANJI_LEVEL4,  // 隝
	0x96A4, KANJI_LEVEL4,  // 隤
	0x96A5, KANJI_LEVEL4,  // 隥
	0x96D2, KANJI_LEVEL4,  // 雒
	0x96DE, KANJI_LEVEL4,  // 雞
	0xFA68, KANJI_LEVEL4,  // 難
	0x96E9, KANJI_LEVEL4,  // 雩
	0x96EF, KANJI_LEVEL4,  // 雯
	0x9733, KANJI_LEVEL4,  // 霳
	0x973B, KANJI_LEVEL4,  // 霻
	0x974D, KANJI_LEVEL4,  // 靍
	0x974E, KANJI_LEVEL4,  // 靎
	0x974F, KANJI_LEVEL4,  // 靏
	0x975A, KANJI_LEVEL4,  // 靚
	0x976E, KANJI_LEVEL4,  // 靮
	0x9773, KANJI_LEVEL4,  // 靳
	0x9795, KANJI_LEVEL4,  // 鞕
	0x97AE, KANJI_LEVEL4,  // 鞮
	0x97BA, KANJI_LEVEL4,  // 鞺
	0x97C1, KANJI_LEVEL4,  // 韁
	0x97C9, KANJI_LEVEL4,  // 韉
	0x97DE, KANJI_LEVEL4,  // 韞
	0x97DB, KANJI_LEVEL4,  // 韛
	0x97F4, KANJI_LEVEL4,  // 韴
	0xFA69, KANJI_LEVEL4,  // 響
	0x980A, KANJI_LEVEL4,  // 頊
	0x981E, KANJI_LEVEL4,  // 頞
	0x982B, KANJI_LEVEL4,  // 頫
	0x9830, KANJI_LEVEL4,  // 頰
	0xFA6A, KANJI_LEVEL4,  // 頻
	0x9852, KANJI_LEVEL4,  // 顒
	0x9853, KANJI_LEVEL4,  // 顓
	0x9856, KANJI_LEVEL4,  // 顖
	0x9857, KANJI_LEVEL4,  // 顗
	0x9859, KANJI_LEVEL4,  // 顙
	0x985A, KANJI_LEVEL4,  // 顚
	0xF9D0, KANJI_LEVEL4,  // 類
	0x9865, KANJI_LEVEL4,  // 顥
	0x986C, KANJI_LEVEL4,  // 顬
	0x98BA, KANJI_LEVEL4,  // 颺
	0x98C8, KANJI_LEVEL4,  // 飈
	0x98E7, KANJI_LEVEL4,  // 飧
	0x9958, KANJI_LEVEL4,  // 饘
	0x999E, KANJI_LEVEL4,  // 馞
	0x9A02, KANJI_LEVEL4,  // 騂
	0x9A03, KANJI_LEVEL4,  // 騃
	0x9A24, KANJI_LEVEL4,  // 騤
	0x9A2D, KANJI_LEVEL4,  // 騭
	0x9A2E, KANJI_LEVEL4,  // 騮
	0x9A38, KANJI_LEVEL4,  // 騸
	0x9A4A, KANJI_LEVEL4,  // 驊
	0x9A4E, KANJI_LEVEL4,  // 驎
	0x9A52, KANJI_LEVEL4,  // 驒
	0x9AB6, KANJI_LEVEL4,  // 骶
	0x9AC1, KANJI_LEVEL4,  // 髁
	0x9AC3, KANJI_LEVEL4,  // 髃
	0x9ACE, KANJI_LEVEL4,  // 髎
	0x9AD6, KANJI_LEVEL4,  // 髖
	0x9AF9, KANJI_LEVEL4,  // 髹
	0x9B02, KANJI_LEVEL4,  // 鬂
	0x9B08, KANJI_LEVEL4,  // 鬈
	0x9B20, KANJI_LEVEL4,  // 鬠
	0x4C17, KANJI_LEVEL4,  // 䰗
	0x9B2D, KANJI_LEVEL4,  // 鬭
	0x9B5E, KANJI_LEVEL4,  // 魞
	0x9B79, KANJI_LEVEL4,  // 魹
	0x9B66, KANJI_LEVEL4,  // 魦
	0x9B72, KANJI_LEVEL4,  // 魲
	0x9B75, KANJI_LEVEL4,  // 魵
	0x9B84, KANJI_LEVEL4,  // 鮄
	0x9B8A, KANJI_LEVEL4,  // 鮊
	0x9B8F, KANJI_LEVEL4,  // 鮏
	0x9B9E, KANJI_LEVEL4,  // 鮞
	0x9BA7, KANJI_LEVEL4,  // 鮧
	0x9BC1, KANJI_LEVEL4,  // 鯁
	0x9BCE, KANJI_LEVEL4,  // 鯎
	0x9BE5, KANJI_LEVEL4,  // 鯥
	0x9BF8, KANJI_LEVEL4,  // 鯸
	0x9BFD, KANJI_LEVEL4,  // 鯽
	0x9C00, KANJI_LEVEL4,  // 鰀
	0x9C23, KANJI_LEVEL4,  // 鰣
	0x9C41, KANJI_LEVEL4,  // 鱁
	0x9C4F, KANJI_LEVEL4,  // 鱏
	0x9C50, KANJI_LEVEL4,  // 鱐
	0x9C53, KANJI_LEVEL4,  // 鱓
	0x9C63, KANJI_LEVEL4,  // 鱣
	0x9C65, KANJI_LEVEL4,  // 鱥
	0x9C77, KANJI_LEVEL4,  // 鱷
	0x9D1D, KANJI_LEVEL4,  // 鴝
	0x9D1E, KANJI_LEVEL4,  // 鴞
	0x9D43, KANJI_LEVEL4,  // 鵃
	0x9D47, KANJI_LEVEL4,  // 鵇
	0x9D52, KANJI_LEVEL4,  // 鵒
	0x9D63, KANJI_LEVEL4,  // 鵣
	0x9D70, KANJI_LEVEL4,  // 鵰
	0x9D7C, KANJI_LEVEL4,  // 鵼
	0x9D8A, KANJI_LEVEL4,  // 鶊
	0x9D96, KANJI_LEVEL4,  // 鶖
	0x9DC0, KANJI_LEVEL4,  // 鷀
	0x9DAC, KANJI_LEVEL4,  // 鶬
	0x9DBC, KANJI_LEVEL4,  // 鶼
	0x9DD7, KANJI_LEVEL4,  // 鷗
	0xD868, KANJI_LEVEL4,  // �
	0xDD90, KANJI_LEVEL4,  // �
	0x9DE7, KANJI_LEVEL4,  // 鷧
	0x9E07, KANJI_LEVEL4,  // 鸇
	0x9E15, KANJI_LEVEL4,  // 鸕
	0x9E7C, KANJI_LEVEL4,  // 鹼
	0x9E9E, KANJI_LEVEL4,  // 麞
	0x9EA4, KANJI_LEVEL4,  // 麤
	0x9EAC, KANJI_LEVEL4,  // 麬
	0x9EAF, KANJI_LEVEL4,  // 麯
	0x9EB4, KANJI_LEVEL4,  // 麴
	0x9EB5, KANJI_LEVEL4,  // 麵
	0x9EC3, KANJI_LEVEL4,  // 黃
	0x9ED1, KANJI_LEVEL4,  // 黑
	0x9F10, KANJI_LEVEL4,  // 鼐
	0x9F39, KANJI_LEVEL4,  // 鼹
	0x9F57, KANJI_LEVEL4,  // 齗
	0x9F90, KANJI_LEVEL4,  // 龐
	0x9F94, KANJI_LEVEL4,  // 龔
	0x9F97, KANJI_LEVEL4,  // 龗
	0x9FA2, KANJI_LEVEL4,  // 龢
	0x59F8, KANJI_LEVEL4,  // 姸
	0x5C5B, KANJI_LEVEL4,  // 屛
	0x5E77, KANJI_LEVEL4,  // 幷
	0x7626, KANJI_LEVEL4,  // 瘦
	0x7E6B, KANJI_LEVEL4,  // 繫
	0xD840, KANJI_LEVEL4,  // �
	0xDC89, KANJI_LEVEL4,  // �
	0x4E02, KANJI_LEVEL4,  // 丂
	0x4E0F, KANJI_LEVEL4,  // 丏
	0x4E12, KANJI_LEVEL4,  // 丒
	0x4E29, KANJI_LEVEL4,  // 丩
	0x4E2B, KANJI_LEVEL4,  // 丫
	0x4E2E, KANJI_LEVEL4,  // 丮
	0x4E40, KANJI_LEVEL4,  // 乀
	0x4E47, KANJI_LEVEL4,  // 乇
	0x4E48, KANJI_LEVEL4,  // 么
	0xD840, KANJI_LEVEL4,  // �
	0xDCA2, KANJI_LEVEL4,  // �
	0x4E51, KANJI_LEVEL4,  // 乑
	0x3406, KANJI_LEVEL4,  // 㐆
	0xD840, KANJI_LEVEL4,  // �
	0xDCA4, KANJI_LEVEL4,  // �
	0x4E5A, KANJI_LEVEL4,  // 乚
	0x4E69, KANJI_LEVEL4,  // 乩
	0x4E9D, KANJI_LEVEL4,  // 亝
	0x342C, KANJI_LEVEL4,  // 㐬
	0x342E, KANJI_LEVEL4,  // 㐮
	0x4EB9, KANJI_LEVEL4,  // 亹
	0x4EBB, KANJI_LEVEL4,  // 亻
	0xD840, KANJI_LEVEL4,  // �
	0xDDA2, KANJI_LEVEL4,  // �
	0x4EBC, KANJI_LEVEL4,  // 亼
	0x4EC3, KANJI_LEVEL4,  // 仃
	0x4EC8, KANJI_LEVEL4,  // 仈
	0x4ED0, KANJI_LEVEL4,  // 仐
	0x4EEB, KANJI_LEVEL4,  // 仫
	0x4EDA, KANJI_LEVEL4,  // 仚
	0x4EF1, KANJI_LEVEL4,  // 仱
	0x4EF5, KANJI_LEVEL4,  // 仵
	0x4F00, KANJI_LEVEL4,  // 伀
	0x4F16, KANJI_LEVEL4,  // 伖
	0x4F64, KANJI_LEVEL4,  // 佤
	0x4F37, KANJI_LEVEL4,  // 伷
	0x4F3E, KANJI_LEVEL4,  // 伾
	0x4F54, KANJI_LEVEL4,  // 佔
	0x4F58, KANJI_LEVEL4,  // 佘
	0xD840, KANJI_LEVEL4,  // �
	0xDE13, KANJI_LEVEL4,  // �
	0x4F77, KANJI_LEVEL4,  // 佷
	0x4F78, KANJI_LEVEL4,  // 佸
	0x4F7A, KANJI_LEVEL4,  // 佺
	0x4F7D, KANJI_LEVEL4,  // 佽
	0x4F82, KANJI_LEVEL4,  // 侂
	0x4F85, KANJI_LEVEL4,  // 侅
	0x4F92, KANJI_LEVEL4,  // 侒
	0x4F9A, KANJI_LEVEL4,  // 侚
	0x4FE6, KANJI_LEVEL4,  // 俦
	0x4FB2, KANJI_LEVEL4,  // 侲
	0x4FBE, KANJI_LEVEL4,  // 侾
	0x4FC5, KANJI_LEVEL4,  // 俅
	0x4FCB, KANJI_LEVEL4,  // 俋
	0x4FCF, KANJI_LEVEL4,  // 俏
	0x4FD2, KANJI_LEVEL4,  // 俒
	0x346A, KANJI_LEVEL4,  // 㑪
	0x4FF2, KANJI_LEVEL4,  // 俲
	0x5000, KANJI_LEVEL4,  // 倀
	0x5010, KANJI_LEVEL4,  // 倐
	0x5013, KANJI_LEVEL4,  // 倓
	0x501C, KANJI_LEVEL4,  // 倜
	0x501E, KANJI_LEVEL4,  // 倞
	0x5022, KANJI_LEVEL4,  // 倢
	0x3468, KANJI_LEVEL4,  // 㑨
	0x5042, KANJI_LEVEL4,  // 偂
	0x5046, KANJI_LEVEL4,  // 偆
	0x504E, KANJI_LEVEL4,  // 偎
	0x5053, KANJI_LEVEL4,  // 偓
	0x5057, KANJI_LEVEL4,  // 偗
	0x5063, KANJI_LEVEL4,  // 偣
	0x5066, KANJI_LEVEL4,  // 偦
	0x506A, KANJI_LEVEL4,  // 偪
	0x5070, KANJI_LEVEL4,  // 偰
	0x50A3, KANJI_LEVEL4,  // 傣
	0x5088, KANJI_LEVEL4,  // 傈
	0x5092, KANJI_LEVEL4,  // 傒
	0x5093, KANJI_LEVEL4,  // 傓
	0x5095, KANJI_LEVEL4,  // 傕
	0x5096, KANJI_LEVEL4,  // 傖
	0x509C, KANJI_LEVEL4,  // 傜
	0x50AA, KANJI_LEVEL4,  // 傪
	0xD840, KANJI_LEVEL4,  // �
	0xDF2B, KANJI_LEVEL4,  // �
	0x50B1, KANJI_LEVEL4,  // 傱
	0x50BA, KANJI_LEVEL4,  // 傺
	0x50BB, KANJI_LEVEL4,  // 傻
	0x50C4, KANJI_LEVEL4,  // 僄
	0x50C7, KANJI_LEVEL4,  // 僇
	0x50F3, KANJI_LEVEL4,  // 僳
	0xD840, KANJI_LEVEL4,  // �
	0xDF81, KANJI_LEVEL4,  // �
	0x50CE, KANJI_LEVEL4,  // 僎
	0xD840, KANJI_LEVEL4,  // �
	0xDF71, KANJI_LEVEL4,  // �
	0x50D4, KANJI_LEVEL4,  // 僔
	0x50D9, KANJI_LEVEL4,  // 僙
	0x50E1, KANJI_LEVEL4,  // 僡
	0x50E9, KANJI_LEVEL4,  // 僩
	0x3492, KANJI_LEVEL4,  // 㒒
	0x5108, KANJI_LEVEL4,  // 儈
	0xD840, KANJI_LEVEL4,  // �
	0xDFF9, KANJI_LEVEL4,  // �
	0x5117, KANJI_LEVEL4,  // 儗
	0x511B, KANJI_LEVEL4,  // 儛
	0xD841, KANJI_LEVEL4,  // �
	0xDC4A, KANJI_LEVEL4,  // �
	0x5160, KANJI_LEVEL4,  // 兠
	0xD841, KANJI_LEVEL4,  // �
	0xDD09, KANJI_LEVEL4,  // �
	0x5173, KANJI_LEVEL4,  // 关
	0x5183, KANJI_LEVEL4,  // 冃
	0x518B, KANJI_LEVEL4,  // 冋
	0x34BC, KANJI_LEVEL4,  // 㒼
	0x5198, KANJI_LEVEL4,  // 冘
	0x51A3, KANJI_LEVEL4,  // 冣
	0x51AD, KANJI_LEVEL4,  // 冭
	0x34C7, KANJI_LEVEL4,  // 㓇
	0x51BC, KANJI_LEVEL4,  // 冼
	0xD841, KANJI_LEVEL4,  // �
	0xDDD6, KANJI_LEVEL4,  // �
	0xD841, KANJI_LEVEL4,  // �
	0xDE28, KANJI_LEVEL4,  // �
	0x51F3, KANJI_LEVEL4,  // 凳
	0x51F4, KANJI_LEVEL4,  // 凴
	0x5202, KANJI_LEVEL4,  // 刂
	0x5212, KANJI_LEVEL4,  // 划
	0x5216, KANJI_LEVEL4,  // 刖
	0xD841, KANJI_LEVEL4,  // �
	0xDF4F, KANJI_LEVEL4,  // �
	0x5255, KANJI_LEVEL4,  // 剕
	0x525C, KANJI_LEVEL4,  // 剜
	0x526C, KANJI_LEVEL4,  // 剬
	0x5277, KANJI_LEVEL4,  // 剷
	0x5284, KANJI_LEVEL4,  // 劄
	0x5282, KANJI_LEVEL4,  // 劂
	0xD842, KANJI_LEVEL4,  // �
	0xDC07, KANJI_LEVEL4,  // �
	0x5298, KANJI_LEVEL4,  // 劘
	0xD842, KANJI_LEVEL4,  // �
	0xDC3A, KANJI_LEVEL4,  // �
	0x52A4, KANJI_LEVEL4,  // 劤
	0x52A6, KANJI_LEVEL4,  // 劦
	0x52AF, KANJI_LEVEL4,  // 劯
	0x52BA, KANJI_LEVEL4,  // 劺
	0x52BB, KANJI_LEVEL4,  // 劻
	0x52CA, KANJI_LEVEL4,  // 勊
	0x351F, KANJI_LEVEL4,  // 㔟
	0x52D1, KANJI_LEVEL4,  // 勑
	0xD842, KANJI_LEVEL4,  // �
	0xDCB9, KANJI_LEVEL4,  // �
	0x52F7, KANJI_LEVEL4,  // 勷
	0x530A, KANJI_LEVEL4,  // 匊
	0x530B, KANJI_LEVEL4,  // 匋
	0x5324, KANJI_LEVEL4,  // 匤
	0x5335, KANJI_LEVEL4,  // 匵
	0x533E, KANJI_LEVEL4,  // 匾
	0x5342, KANJI_LEVEL4,  // 卂
	0xD842, KANJI_LEVEL4,  // �
	0xDD7C, KANJI_LEVEL4,  // �
	0xD842, KANJI_LEVEL4,  // �
	0xDD9D, KANJI_LEVEL4,  // �
	0x5367, KANJI_LEVEL4,  // 卧
	0x536C, KANJI_LEVEL4,  // 卬
	0x537A, KANJI_LEVEL4,  // 卺
	0x53A4, KANJI_LEVEL4,  // 厤
	0x53B4, KANJI_LEVEL4,  // 厴
	0xD842, KANJI_LEVEL4,  // �
	0xDED3, KANJI_LEVEL4,  // �
	0x53B7, KANJI_LEVEL4,  // 厷
	0x53C0, KANJI_LEVEL4,  // 叀
	0xD842, KANJI_LEVEL4,  // �
	0xDF1D, KANJI_LEVEL4,  // �
	0x355D, KANJI_LEVEL4,  // 㕝
	0x355E, KANJI_LEVEL4,  // 㕞
	0x53D5, KANJI_LEVEL4,  // 叕
	0x53DA, KANJI_LEVEL4,  // 叚
	0x3563, KANJI_LEVEL4,  // 㕣
	0x53F4, KANJI_LEVEL4,  // 叴
	0x53F5, KANJI_LEVEL4,  // 叵
	0x5455, KANJI_LEVEL4,  // 呕
	0x5424, KANJI_LEVEL4,  // 吤
	0x5428, KANJI_LEVEL4,  // 吨
	0x356E, KANJI_LEVEL4,  // 㕮
	0x5443, KANJI_LEVEL4,  // 呃
	0x5462, KANJI_LEVEL4,  // 呢
	0x5466, KANJI_LEVEL4,  // 呦
	0x546C, KANJI_LEVEL4,  // 呬
	0x548A, KANJI_LEVEL4,  // 咊
	0x548D, KANJI_LEVEL4,  // 咍
	0x5495, KANJI_LEVEL4,  // 咕
	0x54A0, KANJI_LEVEL4,  // 咠
	0x54A6, KANJI_LEVEL4,  // 咦
	0x54AD, KANJI_LEVEL4,  // 咭
	0x54AE, KANJI_LEVEL4,  // 咮
	0x54B7, KANJI_LEVEL4,  // 咷
	0x54BA, KANJI_LEVEL4,  // 咺
	0x54BF, KANJI_LEVEL4,  // 咿
	0x54C3, KANJI_LEVEL4,  // 哃
	0xD843, KANJI_LEVEL4,  // �
	0xDD45, KANJI_LEVEL4,  // �
	0x54EC, KANJI_LEVEL4,  // 哬
	0x54EF, KANJI_LEVEL4,  // 哯
	0x54F1, KANJI_LEVEL4,  // 哱
	0x54F3, KANJI_LEVEL4,  // 哳
	0x5500, KANJI_LEVEL4,  // 唀
	0x5501, KANJI_LEVEL4,  // 唁
	0x5509, KANJI_LEVEL4,  // 唉
	0x553C, KANJI_LEVEL4,  // 唼
	0x5541, KANJI_LEVEL4,  // 啁
	0x35A6, KANJI_LEVEL4,  // 㖦
	0x5547, KANJI_LEVEL4,  // 啇
	0x554A, KANJI_LEVEL4,  // 啊
	0x35A8, KANJI_LEVEL4,  // 㖨
	0x5560, KANJI_LEVEL4,  // 啠
	0x5561, KANJI_LEVEL4,  // 啡
	0x5564, KANJI_LEVEL4,  // 啤
	0xD843, KANJI_LEVEL4,  // �
	0xDDE1, KANJI_LEVEL4,  // �
	0x557D, KANJI_LEVEL4,  // 啽
	0x5582, KANJI_LEVEL4,  // 喂
	0x5588, KANJI_LEVEL4,  // 喈
	0x5591, KANJI_LEVEL4,  // 喑
	0x35C5, KANJI_LEVEL4,  // 㗅
	0x55D2, KANJI_LEVEL4,  // 嗒
	0xD843, KANJI_LEVEL4,  // �
	0xDE95, KANJI_LEVEL4,  // �
	0xD843, KANJI_LEVEL4,  // �
	0xDE6D, KANJI_LEVEL4,  // �
	0x55BF, KANJI_LEVEL4,  // 喿
	0x55C9, KANJI_LEVEL4,  // 嗉
	0x55CC, KANJI_LEVEL4,  // 嗌
	0x55D1, KANJI_LEVEL4,  // 嗑
	0x55DD, KANJI_LEVEL4,  // 嗝
	0x35DA, KANJI_LEVEL4,  // 㗚
	0x55E2, KANJI_LEVEL4,  // 嗢
	0xD843, KANJI_LEVEL4,  // �
	0xDE64, KANJI_LEVEL4,  // �
	0x55E9, KANJI_LEVEL4,  // 嗩
	0x5628, KANJI_LEVEL4,  // 嘨
	0xD843, KANJI_LEVEL4,  // �
	0xDF5F, KANJI_LEVEL4,  // �
	0x5607, KANJI_LEVEL4,  // 嘇
	0x5610, KANJI_LEVEL4,  // 嘐
	0x5630, KANJI_LEVEL4,  // 嘰
	0x5637, KANJI_LEVEL4,  // 嘷
	0x35F4, KANJI_LEVEL4,  // 㗴
	0x563D, KANJI_LEVEL4,  // 嘽
	0x563F, KANJI_LEVEL4,  // 嘿
	0x5640, KANJI_LEVEL4,  // 噀
	0x5647, KANJI_LEVEL4,  // 噇
	0x565E, KANJI_LEVEL4,  // 噞
	0x5660, KANJI_LEVEL4,  // 噠
	0x566D, KANJI_LEVEL4,  // 噭
	0x3605, KANJI_LEVEL4,  // 㘅
	0x5688, KANJI_LEVEL4,  // 嚈
	0x568C, KANJI_LEVEL4,  // 嚌
	0x5695, KANJI_LEVEL4,  // 嚕
	0x569A, KANJI_LEVEL4,  // 嚚
	0x569D, KANJI_LEVEL4,  // 嚝
	0x56A8, KANJI_LEVEL4,  // 嚨
	0x56AD, KANJI_LEVEL4,  // 嚭
	0x56B2, KANJI_LEVEL4,  // 嚲
	0x56C5, KANJI_LEVEL4,  // 囅
	0x56CD, KANJI_LEVEL4,  // 囍
	0x56DF, KANJI_LEVEL4,  // 囟
	0x56E8, KANJI_LEVEL4,  // 囨
	0x56F6, KANJI_LEVEL4,  // 囶
	0x56F7, KANJI_LEVEL4,  // 囷
	0xD844, KANJI_LEVEL4,  // �
	0xDE01, KANJI_LEVEL4,  // �
	0x5715, KANJI_LEVEL4,  // 圕
	0x5723, KANJI_LEVEL4,  // 圣
	0xD844, KANJI_LEVEL4,  // �
	0xDE55, KANJI_LEVEL4,  // �
	0x5729, KANJI_LEVEL4,  // 圩
	0xD844, KANJI_LEVEL4,  // �
	0xDE7B, KANJI_LEVEL4,  // �
	0x5745, KANJI_LEVEL4,  // 坅
	0x5746, KANJI_LEVEL4,  // 坆
	0x574C, KANJI_LEVEL4,  // 坌
	0x574D, KANJI_LEVEL4,  // 坍
	0xD844, KANJI_LEVEL4,  // �
	0xDE74, KANJI_LEVEL4,  // �
	0x5768, KANJI_LEVEL4,  // 坨
	0x576F, KANJI_LEVEL4,  // 坯
	0x5773, KANJI_LEVEL4,  // 坳
	0x5774, KANJI_LEVEL4,  // 坴
	0x5775, KANJI_LEVEL4,  // 坵
	0x577B, KANJI_LEVEL4,  // 坻
	0xD844, KANJI_LEVEL4,  // �
	0xDEE4, KANJI_LEVEL4,  // �
	0xD844, KANJI_LEVEL4,  // �
	0xDED7, KANJI_LEVEL4,  // �
	0x57AC, KANJI_LEVEL4,  // 垬
	0x579A, KANJI_LEVEL4,  // 垚
	0x579D, KANJI_LEVEL4,  // 垝
	0x579E, KANJI_LEVEL4,  // 垞
	0x57A8, KANJI_LEVEL4,  // 垨
	0x57D7, KANJI_LEVEL4,  // 埗
	0xD844, KANJI_LEVEL4,  // �
	0xDEFD, KANJI_LEVEL4,  // �
	0x57CC, KANJI_LEVEL4,  // 埌
	0xD844, KANJI_LEVEL4,  // �
	0xDF36, KANJI_LEVEL4,  // �
	0xD844, KANJI_LEVEL4,  // �
	0xDF44, KANJI_LEVEL4,  // �
	0x57DE, KANJI_LEVEL4,  // 埞
	0x57E6, KANJI_LEVEL4,  // 埦
	0x57F0, KANJI_LEVEL4,  // 埰
	0x364A, KANJI_LEVEL4,  // 㙊
	0x57F8, KANJI_LEVEL4,  // 埸
	0x57FB, KANJI_LEVEL4,  // 埻
	0x57FD, KANJI_LEVEL4,  // 埽
	0x5804, KANJI_LEVEL4,  // 堄
	0x581E, KANJI_LEVEL4,  // 堞
	0x5820, KANJI_LEVEL4,  // 堠
	0x5827, KANJI_LEVEL4,  // 堧
	0x5832, KANJI_LEVEL4,  // 堲
	0x5839, KANJI_LEVEL4,  // 堹
	0xD844, KANJI_LEVEL4,  // �
	0xDFC4, KANJI_LEVEL4,  // �
	0x5849, KANJI_LEVEL4,  // 塉
	0x584C, KANJI_LEVEL4,  // 塌
	0x5867, KANJI_LEVEL4,  // 塧
	0x588A, KANJI_LEVEL4,  // 墊
	0x588B, KANJI_LEVEL4,  // 墋
	0x588D, KANJI_LEVEL4,  // 墍
	0x588F, KANJI_LEVEL4,  // 墏
	0x5890, KANJI_LEVEL4,  // 墐
	0x5894, KANJI_LEVEL4,  // 墔
	0x589D, KANJI_LEVEL4,  // 墝
	0x58AA, KANJI_LEVEL4,  // 墪
	0x58B1, KANJI_LEVEL4,  // 墱
	0xD845, KANJI_LEVEL4,  // �
	0xDC6D, KANJI_LEVEL4,  // �
	0x58C3, KANJI_LEVEL4,  // 壃
	0x58CD, KANJI_LEVEL4,  // 壍
	0x58E2, KANJI_LEVEL4,  // 壢
	0x58F3, KANJI_LEVEL4,  // 壳
	0x58F4, KANJI_LEVEL4,  // 壴
	0x5905, KANJI_LEVEL4,  // 夅
	0x5906, KANJI_LEVEL4,  // 夆
	0x590B, KANJI_LEVEL4,  // 夋
	0x590D, KANJI_LEVEL4,  // 复
	0x5914, KANJI_LEVEL4,  // 夔
	0x5924, KANJI_LEVEL4,  // 夤
	0xD845, KANJI_LEVEL4,  // �
	0xDDD7, KANJI_LEVEL4,  // �
	0x3691, KANJI_LEVEL4,  // 㚑
	0x593D, KANJI_LEVEL4,  // 夽
	0x3699, KANJI_LEVEL4,  // 㚙
	0x5946, KANJI_LEVEL4,  // 奆
	0x3696, KANJI_LEVEL4,  // 㚖
	0xD85B, KANJI_LEVEL4,  // �
	0xDC29, KANJI_LEVEL4,  // �
	0x595B, KANJI_LEVEL4,  // 奛
	0x595F, KANJI_LEVEL4,  // 奟
	0xD845, KANJI_LEVEL4,  // �
	0xDE47, KANJI_LEVEL4,  // �
	0x5975, KANJI_LEVEL4,  // 奵
	0x5976, KANJI_LEVEL4,  // 奶
	0x597C, KANJI_LEVEL4,  // 奼
	0x599F, KANJI_LEVEL4,  // 妟
	0x59AE, KANJI_LEVEL4,  // 妮
	0x59BC, KANJI_LEVEL4,  // 妼
	0x59C8, KANJI_LEVEL4,  // 姈
	0x59CD, KANJI_LEVEL4,  // 姍
	0x59DE, KANJI_LEVEL4,  // 姞
	0x59E3, KANJI_LEVEL4,  // 姣
	0x59E4, KANJI_LEVEL4,  // 姤
	0x59E7, KANJI_LEVEL4,  // 姧
	0x59EE, KANJI_LEVEL4,  // 姮
	0xD845, KANJI_LEVEL4,  // �
	0xDF06, KANJI_LEVEL4,  // �
	0xD845, KANJI_LEVEL4,  // �
	0xDF42, KANJI_LEVEL4,  // �
	0x36CF, KANJI_LEVEL4,  // 㛏
	0x5A0C, KANJI_LEVEL4,  // 娌
	0x5A0D, KANJI_LEVEL4,  // 娍
	0x5A17, KANJI_LEVEL4,  // 娗
	0x5A27, KANJI_LEVEL4,  // 娧
	0x5A2D, KANJI_LEVEL4,  // 娭
	0x5A55, KANJI_LEVEL4,  // 婕
	0x5A65, KANJI_LEVEL4,  // 婥
	0x5A7A, KANJI_LEVEL4,  // 婺
	0x5A8B, KANJI_LEVEL4,  // 媋
	0x5A9C, KANJI_LEVEL4,  // 媜
	0x5A9F, KANJI_LEVEL4,  // 媟
	0x5AA0, KANJI_LEVEL4,  // 媠
	0x5AA2, KANJI_LEVEL4,  // 媢
	0x5AB1, KANJI_LEVEL4,  // 媱
	0x5AB3, KANJI_LEVEL4,  // 媳
	0x5AB5, KANJI_LEVEL4,  // 媵
	0x5ABA, KANJI_LEVEL4,  // 媺
	0x5ABF, KANJI_LEVEL4,  // 媿
	0x5ADA, KANJI_LEVEL4,  // 嫚
	0x5ADC, KANJI_LEVEL4,  // 嫜
	0x5AE0, KANJI_LEVEL4,  // 嫠
	0x5AE5, KANJI_LEVEL4,  // 嫥
	0x5AF0, KANJI_LEVEL4,  // 嫰
	0x5AEE, KANJI_LEVEL4,  // 嫮
	0x5AF5, KANJI_LEVEL4,  // 嫵
	0x5B00, KANJI_LEVEL4,  // 嬀
	0x5B08, KANJI_LEVEL4,  // 嬈
	0x5B17, KANJI_LEVEL4,  // 嬗
	0x5B34, KANJI_LEVEL4,  // 嬴
	0x5B2D, KANJI_LEVEL4,  // 嬭
	0x5B4C, KANJI_LEVEL4,  // 孌
	0x5B52, KANJI_LEVEL4,  // 孒
	0x5B68, KANJI_LEVEL4,  // 孨
	0x5B6F, KANJI_LEVEL4,  // 孯
	0x5B7C, KANJI_LEVEL4,  // 孼
	0x5B7F, KANJI_LEVEL4,  // 孿
	0x5B81, KANJI_LEVEL4,  // 宁
	0x5B84, KANJI_LEVEL4,  // 宄
	0xD846, KANJI_LEVEL4,  // �
	0xDDC3, KANJI_LEVEL4,  // �
	0x5B96, KANJI_LEVEL4,  // 宖
	0x5BAC, KANJI_LEVEL4,  // 宬
	0x3761, KANJI_LEVEL4,  // 㝡
	0x5BC0, KANJI_LEVEL4,  // 寀
	0x3762, KANJI_LEVEL4,  // 㝢
	0x5BCE, KANJI_LEVEL4,  // 寎
	0x5BD6, KANJI_LEVEL4,  // 寖
	0x376C, KANJI_LEVEL4,  // 㝬
	0x376B, KANJI_LEVEL4,  // 㝫
	0x5BF1, KANJI_LEVEL4,  // 寱
	0x5BFD, KANJI_LEVEL4,  // 寽
	0x3775, KANJI_LEVEL4,  // 㝵
	0x5C03, KANJI_LEVEL4,  // 尃
	0x5C29, KANJI_LEVEL4,  // 尩
	0x5C30, KANJI_LEVEL4,  // 尰
	0xD847, KANJI_LEVEL4,  // �
	0xDC56, KANJI_LEVEL4,  // �
	0x5C5F, KANJI_LEVEL4,  // 屟
	0x5C63, KANJI_LEVEL4,  // 屣
	0x5C67, KANJI_LEVEL4,  // 屧
	0x5C68, KANJI_LEVEL4,  // 屨
	0x5C69, KANJI_LEVEL4,  // 屩
	0x5C70, KANJI_LEVEL4,  // 屰
	0xD847, KANJI_LEVEL4,  // �
	0xDD2D, KANJI_LEVEL4,  // �
	0xD847, KANJI_LEVEL4,  // �
	0xDD45, KANJI_LEVEL4,  // �
	0x5C7C, KANJI_LEVEL4,  // 屼
	0xD847, KANJI_LEVEL4,  // �
	0xDD78, KANJI_LEVEL4,  // �
	0xD847, KANJI_LEVEL4,  // �
	0xDD62, KANJI_LEVEL4,  // �
	0x5C88, KANJI_LEVEL4,  // 岈
	0x5C8A, KANJI_LEVEL4,  // 岊
	0x37C1, KANJI_LEVEL4,  // 㟁
	0xD847, KANJI_LEVEL4,  // �
	0xDDA1, KANJI_LEVEL4,  // �
	0xD847, KANJI_LEVEL4,  // �
	0xDD9C, KANJI_LEVEL4,  // �
	0x5CA0, KANJI_LEVEL4,  // 岠
	0x5CA2, KANJI_LEVEL4,  // 岢
	0x5CA6, KANJI_LEVEL4,  // 岦
	0x5CA7, KANJI_LEVEL4,  // 岧
	0xD847, KANJI_LEVEL4,  // �
	0xDD92, KANJI_LEVEL4,  // �
	0x5CAD, KANJI_LEVEL4,  // 岭
	0x5CB5, KANJI_LEVEL4,  // 岵
	0xD847, KANJI_LEVEL4,  // �
	0xDDB7, KANJI_LEVEL4,  // �
	0x5CC9, KANJI_LEVEL4,  // 峉
	0xD847, KANJI_LEVEL4,  // �
	0xDDE0, KANJI_LEVEL4,  // �
	0xD847, KANJI_LEVEL4,  // �
	0xDE33, KANJI_LEVEL4,  // �
	0x5D06, KANJI_LEVEL4,  // 崆
	0x5D10, KANJI_LEVEL4,  // 崐
	0x5D2B, KANJI_LEVEL4,  // 崫
	0x5D1D, KANJI_LEVEL4,  // 崝
	0x5D20, KANJI_LEVEL4,  // 崠
	0x5D24, KANJI_LEVEL4,  // 崤
	0x5D26, KANJI_LEVEL4,  // 崦
	0x5D31, KANJI_LEVEL4,  // 崱
	0x5D39, KANJI_LEVEL4,  // 崹
	0x5D42, KANJI_LEVEL4,  // 嵂
	0x37E8, KANJI_LEVEL4,  // 㟨
	0x5D61, KANJI_LEVEL4,  // 嵡
	0x5D6A, KANJI_LEVEL4,  // 嵪
	0x37F4, KANJI_LEVEL4,  // 㟴
	0x5D70, KANJI_LEVEL4,  // 嵰
	0xD847, KANJI_LEVEL4,  // �
	0xDF1E, KANJI_LEVEL4,  // �
	0x37FD, KANJI_LEVEL4,  // 㟽
	0x5D88, KANJI_LEVEL4,  // 嶈
	0x3800, KANJI_LEVEL4,  // 㠀
	0x5D92, KANJI_LEVEL4,  // 嶒
	0x5D94, KANJI_LEVEL4,  // 嶔
	0x5D97, KANJI_LEVEL4,  // 嶗
	0x5D99, KANJI_LEVEL4,  // 嶙
	0x5DB0, KANJI_LEVEL4,  // 嶰
	0x5DB2, KANJI_LEVEL4,  // 嶲
	0x5DB4, KANJI_LEVEL4,  // 嶴
	0xD847, KANJI_LEVEL4,  // �
	0xDF76, KANJI_LEVEL4,  // �
	0x5DB9, KANJI_LEVEL4,  // 嶹
	0x5DD1, KANJI_LEVEL4,  // 巑
	0x5DD7, KANJI_LEVEL4,  // 巗
	0x5DD8, KANJI_LEVEL4,  // 巘
	0x5DE0, KANJI_LEVEL4,  // 巠
	0xD847, KANJI_LEVEL4,  // �
	0xDFFA, KANJI_LEVEL4,  // �
	0x5DE4, KANJI_LEVEL4,  // 巤
	0x5DE9, KANJI_LEVEL4,  // 巩
	0x382F, KANJI_LEVEL4,  // 㠯
	0x5E00, KANJI_LEVEL4,  // 帀
	0x3836, KANJI_LEVEL4,  // 㠶
	0x5E12, KANJI_LEVEL4,  // 帒
	0x5E15, KANJI_LEVEL4,  // 帕
	0x3840, KANJI_LEVEL4,  // 㡀
	0x5E1F, KANJI_LEVEL4,  // 帟
	0x5E2E, KANJI_LEVEL4,  // 帮
	0x5E3E, KANJI_LEVEL4,  // 帾
	0x5E49, KANJI_LEVEL4,  // 幉
	0x385C, KANJI_LEVEL4,  // 㡜
	0x5E56, KANJI_LEVEL4,  // 幖
	0x3861, KANJI_LEVEL4,  // 㡡
	0x5E6B, KANJI_LEVEL4,  // 幫
	0x5E6C, KANJI_LEVEL4,  // 幬
	0x5E6D, KANJI_LEVEL4,  // 幭
	0x5E6E, KANJI_LEVEL4,  // 幮
	0xD848, KANJI_LEVEL4,  // �
	0xDD7B, KANJI_LEVEL4,  // �
	0x5EA5, KANJI_LEVEL4,  // 庥
	0x5EAA, KANJI_LEVEL4,  // 庪
	0x5EAC, KANJI_LEVEL4,  // 庬
	0x5EB9, KANJI_LEVEL4,  // 庹
	0x5EBF, KANJI_LEVEL4,  // 庿
	0x5EC6, KANJI_LEVEL4,  // 廆
	0x5ED2, KANJI_LEVEL4,  // 廒
	0x5ED9, KANJI_LEVEL4,  // 廙
	0xD848, KANJI_LEVEL4,  // �
	0xDF1E, KANJI_LEVEL4,  // �
	0x5EFD, KANJI_LEVEL4,  // 廽
	0x5F08, KANJI_LEVEL4,  // 弈
	0x5F0E, KANJI_LEVEL4,  // 弎
	0x5F1C, KANJI_LEVEL4,  // 弜
	0xD848, KANJI_LEVEL4,  // �
	0xDFAD, KANJI_LEVEL4,  // �
	0x5F1E, KANJI_LEVEL4,  // 弞
	0x5F47, KANJI_LEVEL4,  // 彇
	0x5F63, KANJI_LEVEL4,  // 彣
	0x5F72, KANJI_LEVEL4,  // 彲
	0x5F7E, KANJI_LEVEL4,  // 彾
	0x5F8F, KANJI_LEVEL4,  // 徏
	0x5FA2, KANJI_LEVEL4,  // 徢
	0x5FA4, KANJI_LEVEL4,  // 徤
	0x5FB8, KANJI_LEVEL4,  // 徸
	0x5FC4, KANJI_LEVEL4,  // 忄
	0x38FA, KANJI_LEVEL4,  // 㣺
	0x5FC7, KANJI_LEVEL4,  // 忇
	0x5FCB, KANJI_LEVEL4,  // 忋
	0x5FD2, KANJI_LEVEL4,  // 忒
	0x5FD3, KANJI_LEVEL4,  // 忓
	0x5FD4, KANJI_LEVEL4,  // 忔
	0x5FE2, KANJI_LEVEL4,  // 忢
	0x5FEE, KANJI_LEVEL4,  // 忮
	0x5FEF, KANJI_LEVEL4,  // 忯
	0x5FF3, KANJI_LEVEL4,  // 忳
	0x5FFC, KANJI_LEVEL4,  // 忼
	0x3917, KANJI_LEVEL4,  // 㤗
	0x6017, KANJI_LEVEL4,  // 怗
	0x6022, KANJI_LEVEL4,  // 怢
	0x6024, KANJI_LEVEL4,  // 怤
	0x391A, KANJI_LEVEL4,  // 㤚
	0x604C, KANJI_LEVEL4,  // 恌
	0x607F, KANJI_LEVEL4,  // 恿
	0x608A, KANJI_LEVEL4,  // 悊
	0x6095, KANJI_LEVEL4,  // 悕
	0x60A8, KANJI_LEVEL4,  // 您
	0xD849, KANJI_LEVEL4,  // �
	0xDEF3, KANJI_LEVEL4,  // �
	0x60B0, KANJI_LEVEL4,  // 悰
	0x60B1, KANJI_LEVEL4,  // 悱
	0x60BE, KANJI_LEVEL4,  // 悾
	0x60C8, KANJI_LEVEL4,  // 惈
	0x60D9, KANJI_LEVEL4,  // 惙
	0x60DB, KANJI_LEVEL4,  // 惛
	0x60EE, KANJI_LEVEL4,  // 惮
	0x60F2, KANJI_LEVEL4,  // 惲
	0x60F5, KANJI_LEVEL4,  // 惵
	0x6110, KANJI_LEVEL4,  // 愐
	0x6112, KANJI_LEVEL4,  // 愒
	0x6113, KANJI_LEVEL4,  // 愓
	0x6119, KANJI_LEVEL4,  // 愙
	0x611E, KANJI_LEVEL4,  // 愞
	0x613A, KANJI_LEVEL4,  // 愺
	0x396F, KANJI_LEVEL4,  // 㥯
	0x6141, KANJI_LEVEL4,  // 慁
	0x6146, KANJI_LEVEL4,  // 慆
	0x6160, KANJI_LEVEL4,  // 慠
	0x617C, KANJI_LEVEL4,  // 慼
	0xD84A, KANJI_LEVEL4,  // �
	0xDC5B, KANJI_LEVEL4,  // �
	0x6192, KANJI_LEVEL4,  // 憒
	0x6193, KANJI_LEVEL4,  // 憓
	0x6197, KANJI_LEVEL4,  // 憗
	0x6198, KANJI_LEVEL4,  // 憘
	0x61A5, KANJI_LEVEL4,  // 憥
	0x61A8, KANJI_LEVEL4,  // 憨
	0x61AD, KANJI_LEVEL4,  // 憭
	0xD84A, KANJI_LEVEL4,  // �
	0xDCAB, KANJI_LEVEL4,  // �
	0x61D5, KANJI_LEVEL4,  // 懕
	0x61DD, KANJI_LEVEL4,  // 懝
	0x61DF, KANJI_LEVEL4,  // 懟
	0x61F5, KANJI_LEVEL4,  // 懵
	0xD84A, KANJI_LEVEL4,  // �
	0xDD8F, KANJI_LEVEL4,  // �
	0x6215, KANJI_LEVEL4,  // 戕
	0x6223, KANJI_LEVEL4,  // 戣
	0x6229, KANJI_LEVEL4,  // 戩
	0x6246, KANJI_LEVEL4,  // 扆
	0x624C, KANJI_LEVEL4,  // 扌
	0x6251, KANJI_LEVEL4,  // 扑
	0x6252, KANJI_LEVEL4,  // 扒
	0x6261, KANJI_LEVEL4,  // 扡
	0x6264, KANJI_LEVEL4,  // 扤
	0x627B, KANJI_LEVEL4,  // 扻
	0x626D, KANJI_LEVEL4,  // 扭
	0x6273, KANJI_LEVEL4,  // 扳
	0x6299, KANJI_LEVEL4,  // 抙
	0x62A6, KANJI_LEVEL4,  // 抦
	0x62D5, KANJI_LEVEL4,  // 拕
	0xD84A, KANJI_LEVEL4,  // �
	0xDEB8, KANJI_LEVEL4,  // �
	0x62FD, KANJI_LEVEL4,  // 拽
	0x6303, KANJI_LEVEL4,  // 挃
	0x630D, KANJI_LEVEL4,  // 挍
	0x6310, KANJI_LEVEL4,  // 挐
	0xD84A, KANJI_LEVEL4,  // �
	0xDF4F, KANJI_LEVEL4,  // �
	0xD84A, KANJI_LEVEL4,  // �
	0xDF50, KANJI_LEVEL4,  // �
	0x6332, KANJI_LEVEL4,  // 挲
	0x6335, KANJI_LEVEL4,  // 挵
	0x633B, KANJI_LEVEL4,  // 挻
	0x633C, KANJI_LEVEL4,  // 挼
	0x6341, KANJI_LEVEL4,  // 捁
	0x6344, KANJI_LEVEL4,  // 捄
	0x634E, KANJI_LEVEL4,  // 捎
	0xD84A, KANJI_LEVEL4,  // �
	0xDF46, KANJI_LEVEL4,  // �
	0x6359, KANJI_LEVEL4,  // 捙
	0xD84B, KANJI_LEVEL4,  // �
	0xDC1D, KANJI_LEVEL4,  // �
	0xD84A, KANJI_LEVEL4,  // �
	0xDFA6, KANJI_LEVEL4,  // �
	0x636C, KANJI_LEVEL4,  // 捬
	0x6384, KANJI_LEVEL4,  // 掄
	0x6399, KANJI_LEVEL4,  // 掙
	0xD84B, KANJI_LEVEL4,  // �
	0xDC24, KANJI_LEVEL4,  // �
	0x6394, KANJI_LEVEL4,  // 掔
	0x63BD, KANJI_LEVEL4,  // 掽
	0x63F7, KANJI_LEVEL4,  // 揷
	0x63D4, KANJI_LEVEL4,  // 揔
	0x63D5, KANJI_LEVEL4,  // 揕
	0x63DC, KANJI_LEVEL4,  // 揜
	0x63E0, KANJI_LEVEL4,  // 揠
	0x63EB, KANJI_LEVEL4,  // 揫
	0x63EC, KANJI_LEVEL4,  // 揬
	0x63F2, KANJI_LEVEL4,  // 揲
	0x6409, KANJI_LEVEL4,  // 搉
	0x641E, KANJI_LEVEL4,  // 搞
	0x6425, KANJI_LEVEL4,  // 搥
	0x6429, KANJI_LEVEL4,  // 搩
	0x642F, KANJI_LEVEL4,  // 搯
	0x645A, KANJI_LEVEL4,  // 摚
	0x645B, KANJI_LEVEL4,  // 摛
	0x645D, KANJI_LEVEL4,  // 摝
	0x6473, KANJI_LEVEL4,  // 摳
	0x647D, KANJI_LEVEL4,  // 摽
	0x6487, KANJI_LEVEL4,  // 撇
	0x6491, KANJI_LEVEL4,  // 撑
	0x649D, KANJI_LEVEL4,  // 撝
	0x649F, KANJI_LEVEL4,  // 撟
	0x64CB, KANJI_LEVEL4,  // 擋
	0x64CC, KANJI_LEVEL4,  // 擌
	0x64D5, KANJI_LEVEL4,  // 擕
	0x64D7, KANJI_LEVEL4,  // 擗
	0xD84B, KANJI_LEVEL4,  // �
	0xDDE1, KANJI_LEVEL4,  // �
	0x64E4, KANJI_LEVEL4,  // 擤
	0x64E5, KANJI_LEVEL4,  // 擥
	0x64FF, KANJI_LEVEL4,  // 擿
	0x6504, KANJI_LEVEL4,  // 攄
	0x3A6E, KANJI_LEVEL4,  // 㩮
	0x650F, KANJI_LEVEL4,  // 攏
	0x6514, KANJI_LEVEL4,  // 攔
	0x6516, KANJI_LEVEL4,  // 攖
	0x3A73, KANJI_LEVEL4,  // 㩳
	0x651E, KANJI_LEVEL4,  // 攞
	0x6532, KANJI_LEVEL4,  // 攲
	0x6544, KANJI_LEVEL4,  // 敄
	0x6554, KANJI_LEVEL4,  // 敔
	0x656B, KANJI_LEVEL4,  // 敫
	0x657A, KANJI_LEVEL4,  // 敺
	0x6581, KANJI_LEVEL4,  // 斁
	0x6584, KANJI_LEVEL4,  // 斄
	0x6585, KANJI_LEVEL4,  // 斅
	0x658A, KANJI_LEVEL4,  // 斊
	0x65B2, KANJI_LEVEL4,  // 斲
	0x65B5, KANJI_LEVEL4,  // 斵
	0x65B8, KANJI_LEVEL4,  // 斸
	0x65BF, KANJI_LEVEL4,  // 斿
	0x65C2, KANJI_LEVEL4,  // 旂
	0x65C9, KANJI_LEVEL4,  // 旉
	0x65D4, KANJI_LEVEL4,  // 旔
	0x3AD6, KANJI_LEVEL4,  // 㫖
	0x65F2, KANJI_LEVEL4,  // 旲
	0x65F9, KANJI_LEVEL4,  // 旹
	0x65FC, KANJI_LEVEL4,  // 旼
	0x6604, KANJI_LEVEL4,  // 昄
	0x6608, KANJI_LEVEL4,  // 昈
	0x6621, KANJI_LEVEL4,  // 昡
	0x662A, KANJI_LEVEL4,  // 昪
	0x6645, KANJI_LEVEL4,  // 晅
	0x6651, KANJI_LEVEL4,  // 晑
	0x664E, KANJI_LEVEL4,  // 晎
	0x3AEA, KANJI_LEVEL4,  // 㫪
	0xD84C, KANJI_LEVEL4,  // �
	0xDDC3, KANJI_LEVEL4,  // �
	0x6657, KANJI_LEVEL4,  // 晗
	0x665B, KANJI_LEVEL4,  // 晛
	0x6663, KANJI_LEVEL4,  // 晣
	0xD84C, KANJI_LEVEL4,  // �
	0xDDF5, KANJI_LEVEL4,  // �
	0xD84C, KANJI_LEVEL4,  // �
	0xDDB6, KANJI_LEVEL4,  // �
	0x666A, KANJI_LEVEL4,  // 晪
	0x666B, KANJI_LEVEL4,  // 晫
	0x666C, KANJI_LEVEL4,  // 晬
	0x666D, KANJI_LEVEL4,  // 晭
	0x667B, KANJI_LEVEL4,  // 晻
	0x6680, KANJI_LEVEL4,  // 暀
	0x6690, KANJI_LEVEL4,  // 暐
	0x6692, KANJI_LEVEL4,  // 暒
	0x6699, KANJI_LEVEL4,  // 暙
	0x3B0E, KANJI_LEVEL4,  // 㬎
	0x66AD, KANJI_LEVEL4,  // 暭
	0x66B1, KANJI_LEVEL4,  // 暱
	0x66B5, KANJI_LEVEL4,  // 暵
	0x3B1A, KANJI_LEVEL4,  // 㬚
	0x66BF, KANJI_LEVEL4,  // 暿
	0x3B1C, KANJI_LEVEL4,  // 㬜
	0x66EC, KANJI_LEVEL4,  // 曬
	0x3AD7, KANJI_LEVEL4,  // 㫗
	0x6701, KANJI_LEVEL4,  // 朁
	0x6705, KANJI_LEVEL4,  // 朅
	0x6712, KANJI_LEVEL4,  // 朒
	0xD84C, KANJI_LEVEL4,  // �
	0xDF72, KANJI_LEVEL4,  // �
	0x6719, KANJI_LEVEL4,  // 朙
	0xD84C, KANJI_LEVEL4,  // �
	0xDFD3, KANJI_LEVEL4,  // �
	0xD84C, KANJI_LEVEL4,  // �
	0xDFD2, KANJI_LEVEL4,  // �
	0x674C, KANJI_LEVEL4,  // 杌
	0x674D, KANJI_LEVEL4,  // 杍
	0x6754, KANJI_LEVEL4,  // 杔
	0x675D, KANJI_LEVEL4,  // 杝
	0xD84C, KANJI_LEVEL4,  // �
	0xDFD0, KANJI_LEVEL4,  // �
	0xD84C, KANJI_LEVEL4,  // �
	0xDFE4, KANJI_LEVEL4,  // �
	0xD84C, KANJI_LEVEL4,  // �
	0xDFD5, KANJI_LEVEL4,  // �
	0x6774, KANJI_LEVEL4,  // 杴
	0x6776, KANJI_LEVEL4,  // 杶
	0xD84C, KANJI_LEVEL4,  // �
	0xDFDA, KANJI_LEVEL4,  // �
	0x6792, KANJI_LEVEL4,  // 枒
	0xD84C, KANJI_LEVEL4,  // �
	0xDFDF, KANJI_LEVEL4,  // �
	0x8363, KANJI_LEVEL4,  // 荣
	0x6810, KANJI_LEVEL4,  // 栐
	0x67B0, KANJI_LEVEL4,  // 枰
	0x67B2, KANJI_LEVEL4,  // 枲
	0x67C3, KANJI_LEVEL4,  // 柃
	0x67C8, KANJI_LEVEL4,  // 柈
	0x67D2, KANJI_LEVEL4,  // 柒
	0x67D9, KANJI_LEVEL4,  // 柙
	0x67DB, KANJI_LEVEL4,  // 柛
	0x67F0, KANJI_LEVEL4,  // 柰
	0x67F7, KANJI_LEVEL4,  // 柷
	0xD84D, KANJI_LEVEL4,  // �
	0xDC4A, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDC51, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDC4B, KANJI_LEVEL4,  // �
	0x6818, KANJI_LEVEL4,  // 栘
	0x681F, KANJI_LEVEL4,  // 栟
	0x682D, KANJI_LEVEL4,  // 栭
	0xD84D, KANJI_LEVEL4,  // �
	0xDC65, KANJI_LEVEL4,  // �
	0x6833, KANJI_LEVEL4,  // 栳
	0x683B, KANJI_LEVEL4,  // 栻
	0x683E, KANJI_LEVEL4,  // 栾
	0x6844, KANJI_LEVEL4,  // 桄
	0x6845, KANJI_LEVEL4,  // 桅
	0x6849, KANJI_LEVEL4,  // 桉
	0x684C, KANJI_LEVEL4,  // 桌
	0x6855, KANJI_LEVEL4,  // 桕
	0x6857, KANJI_LEVEL4,  // 桗
	0x3B77, KANJI_LEVEL4,  // 㭷
	0x686B, KANJI_LEVEL4,  // 桫
	0x686E, KANJI_LEVEL4,  // 桮
	0x687A, KANJI_LEVEL4,  // 桺
	0x687C, KANJI_LEVEL4,  // 桼
	0x6882, KANJI_LEVEL4,  // 梂
	0x6890, KANJI_LEVEL4,  // 梐
	0x6896, KANJI_LEVEL4,  // 梖
	0x3B6D, KANJI_LEVEL4,  // 㭭
	0x6898, KANJI_LEVEL4,  // 梘
	0x6899, KANJI_LEVEL4,  // 梙
	0x689A, KANJI_LEVEL4,  // 梚
	0x689C, KANJI_LEVEL4,  // 梜
	0x68AA, KANJI_LEVEL4,  // 梪
	0x68AB, KANJI_LEVEL4,  // 梫
	0x68B4, KANJI_LEVEL4,  // 梴
	0x68BB, KANJI_LEVEL4,  // 梻
	0x68FB, KANJI_LEVEL4,  // 棻
	0xD84D, KANJI_LEVEL4,  // �
	0xDCE4, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDD5A, KANJI_LEVEL4,  // �
	0xFA13, KANJI_LEVEL4,  // 﨓
	0x68C3, KANJI_LEVEL4,  // 棃
	0x68C5, KANJI_LEVEL4,  // 棅
	0x68CC, KANJI_LEVEL4,  // 棌
	0x68CF, KANJI_LEVEL4,  // 棏
	0x68D6, KANJI_LEVEL4,  // 棖
	0x68D9, KANJI_LEVEL4,  // 棙
	0x68E4, KANJI_LEVEL4,  // 棤
	0x68E5, KANJI_LEVEL4,  // 棥
	0x68EC, KANJI_LEVEL4,  // 棬
	0x68F7, KANJI_LEVEL4,  // 棷
	0x6903, KANJI_LEVEL4,  // 椃
	0x6907, KANJI_LEVEL4,  // 椇
	0x3B87, KANJI_LEVEL4,  // 㮇
	0x3B88, KANJI_LEVEL4,  // 㮈
	0xD84D, KANJI_LEVEL4,  // �
	0xDD94, KANJI_LEVEL4,  // �
	0x693B, KANJI_LEVEL4,  // 椻
	0x3B8D, KANJI_LEVEL4,  // 㮍
	0x6946, KANJI_LEVEL4,  // 楆
	0x6969, KANJI_LEVEL4,  // 楩
	0x696C, KANJI_LEVEL4,  // 楬
	0x6972, KANJI_LEVEL4,  // 楲
	0x697A, KANJI_LEVEL4,  // 楺
	0x697F, KANJI_LEVEL4,  // 楿
	0x6992, KANJI_LEVEL4,  // 榒
	0x3BA4, KANJI_LEVEL4,  // 㮤
	0x6996, KANJI_LEVEL4,  // 榖
	0x6998, KANJI_LEVEL4,  // 榘
	0x69A6, KANJI_LEVEL4,  // 榦
	0x69B0, KANJI_LEVEL4,  // 榰
	0x69B7, KANJI_LEVEL4,  // 榷
	0x69BA, KANJI_LEVEL4,  // 榺
	0x69BC, KANJI_LEVEL4,  // 榼
	0x69C0, KANJI_LEVEL4,  // 槀
	0x69D1, KANJI_LEVEL4,  // 槑
	0x69D6, KANJI_LEVEL4,  // 槖
	0xD84D, KANJI_LEVEL4,  // �
	0xDE39, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDE47, KANJI_LEVEL4,  // �
	0x6A30, KANJI_LEVEL4,  // 樰
	0xD84D, KANJI_LEVEL4,  // �
	0xDE38, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDE3A, KANJI_LEVEL4,  // �
	0x69E3, KANJI_LEVEL4,  // 槣
	0x69EE, KANJI_LEVEL4,  // 槮
	0x69EF, KANJI_LEVEL4,  // 槯
	0x69F3, KANJI_LEVEL4,  // 槳
	0x3BCD, KANJI_LEVEL4,  // 㯍
	0x69F4, KANJI_LEVEL4,  // 槴
	0x69FE, KANJI_LEVEL4,  // 槾
	0x6A11, KANJI_LEVEL4,  // 樑
	0x6A1A, KANJI_LEVEL4,  // 樚
	0x6A1D, KANJI_LEVEL4,  // 樝
	0xD84D, KANJI_LEVEL4,  // �
	0xDF1C, KANJI_LEVEL4,  // �
	0x6A32, KANJI_LEVEL4,  // 樲
	0x6A33, KANJI_LEVEL4,  // 樳
	0x6A34, KANJI_LEVEL4,  // 樴
	0x6A3F, KANJI_LEVEL4,  // 樿
	0x6A46, KANJI_LEVEL4,  // 橆
	0x6A49, KANJI_LEVEL4,  // 橉
	0x6A7A, KANJI_LEVEL4,  // 橺
	0x6A4E, KANJI_LEVEL4,  // 橎
	0x6A52, KANJI_LEVEL4,  // 橒
	0x6A64, KANJI_LEVEL4,  // 橤
	0xD84D, KANJI_LEVEL4,  // �
	0xDF0C, KANJI_LEVEL4,  // �
	0x6A7E, KANJI_LEVEL4,  // 橾
	0x6A83, KANJI_LEVEL4,  // 檃
	0x6A8B, KANJI_LEVEL4,  // 檋
	0x3BF0, KANJI_LEVEL4,  // 㯰
	0x6A91, KANJI_LEVEL4,  // 檑
	0x6A9F, KANJI_LEVEL4,  // 檟
	0x6AA1, KANJI_LEVEL4,  // 檡
	0xD84D, KANJI_LEVEL4,  // �
	0xDF64, KANJI_LEVEL4,  // �
	0x6AAB, KANJI_LEVEL4,  // 檫
	0x6ABD, KANJI_LEVEL4,  // 檽
	0x6AC6, KANJI_LEVEL4,  // 櫆
	0x6AD4, KANJI_LEVEL4,  // 櫔
	0x6AD0, KANJI_LEVEL4,  // 櫐
	0x6ADC, KANJI_LEVEL4,  // 櫜
	0x6ADD, KANJI_LEVEL4,  // 櫝
	0xD84D, KANJI_LEVEL4,  // �
	0xDFFF, KANJI_LEVEL4,  // �
	0xD84D, KANJI_LEVEL4,  // �
	0xDFE7, KANJI_LEVEL4,  // �
	0x6AEC, KANJI_LEVEL4,  // 櫬
	0x6AF1, KANJI_LEVEL4,  // 櫱
	0x6AF2, KANJI_LEVEL4,  // 櫲
	0x6AF3, KANJI_LEVEL4,  // 櫳
	0x6AFD, KANJI_LEVEL4,  // 櫽
	0xD84E, KANJI_LEVEL4,  // �
	0xDC24, KANJI_LEVEL4,  // �
	0x6B0B, KANJI_LEVEL4,  // 欋
	0x6B0F, KANJI_LEVEL4,  // 欏
	0x6B10, KANJI_LEVEL4,  // 欐
	0x6B11, KANJI_LEVEL4,  // 欑
	0xD84E, KANJI_LEVEL4,  // �
	0xDC3D, KANJI_LEVEL4,  // �
	0x6B17, KANJI_LEVEL4,  // 欗
	0x3C26, KANJI_LEVEL4,  // 㰦
	0x6B2F, KANJI_LEVEL4,  // 欯
	0x6B4A, KANJI_LEVEL4,  // 歊
	0x6B58, KANJI_LEVEL4,  // 歘
	0x6B6C, KANJI_LEVEL4,  // 歬
	0x6B75, KANJI_LEVEL4,  // 歵
	0x6B7A, KANJI_LEVEL4,  // 歺
	0x6B81, KANJI_LEVEL4,  // 殁
	0x6B9B, KANJI_LEVEL4,  // 殛
	0x6BAE, KANJI_LEVEL4,  // 殮
	0xD84E, KANJI_LEVEL4,  // �
	0xDE98, KANJI_LEVEL4,  // �
	0x6BBD, KANJI_LEVEL4,  // 殽
	0x6BBE, KANJI_LEVEL4,  // 殾
	0x6BC7, KANJI_LEVEL4,  // 毇
	0x6BC8, KANJI_LEVEL4,  // 毈
	0x6BC9, KANJI_LEVEL4,  // 毉
	0x6BDA, KANJI_LEVEL4,  // 毚
	0x6BE6, KANJI_LEVEL4,  // 毦
	0x6BE7, KANJI_LEVEL4,  // 毧
	0x6BEE, KANJI_LEVEL4,  // 毮
	0x6BF1, KANJI_LEVEL4,  // 毱
	0x6C02, KANJI_LEVEL4,  // 氂
	0x6C0A, KANJI_LEVEL4,  // 氊
	0x6C0E, KANJI_LEVEL4,  // 氎
	0x6C35, KANJI_LEVEL4,  // 氵
	0x6C36, KANJI_LEVEL4,  // 氶
	0x6C3A, KANJI_LEVEL4,  // 氺
	0xD84F, KANJI_LEVEL4,  // �
	0xDC7F, KANJI_LEVEL4,  // �
	0x6C3F, KANJI_LEVEL4,  // 氿
	0x6C4D, KANJI_LEVEL4,  // 汍
	0x6C5B, KANJI_LEVEL4,  // 汛
	0x6C6D, KANJI_LEVEL4,  // 汭
	0x6C84, KANJI_LEVEL4,  // 沄
	0x6C89, KANJI_LEVEL4,  // 沉
	0x3CC3, KANJI_LEVEL4,  // 㳃
	0x6C94, KANJI_LEVEL4,  // 沔
	0x6C95, KANJI_LEVEL4,  // 沕
	0x6C97, KANJI_LEVEL4,  // 沗
	0x6CAD, KANJI_LEVEL4,  // 沭
	0x6CC2, KANJI_LEVEL4,  // 泂
	0x6CD0, KANJI_LEVEL4,  // 泐
	0x3CD2, KANJI_LEVEL4,  // 㳒
	0x6CD6, KANJI_LEVEL4,  // 泖
	0x6CDA, KANJI_LEVEL4,  // 泚
	0x6CDC, KANJI_LEVEL4,  // 泜
	0x6CE9, KANJI_LEVEL4,  // 泩
	0x6CEC, KANJI_LEVEL4,  // 泬
	0x6CED, KANJI_LEVEL4,  // 泭
	0xD84F, KANJI_LEVEL4,  // �
	0xDD00, KANJI_LEVEL4,  // �
	0x6D00, KANJI_LEVEL4,  // 洀
	0x6D0A, KANJI_LEVEL4,  // 洊
	0x6D24, KANJI_LEVEL4,  // 洤
	0x6D26, KANJI_LEVEL4,  // 洦
	0x6D27, KANJI_LEVEL4,  // 洧
	0x6C67, KANJI_LEVEL4,  // 汧
	0x6D2F, KANJI_LEVEL4,  // 洯
	0x6D3C, KANJI_LEVEL4,  // 洼
	0x6D5B, KANJI_LEVEL4,  // 浛
	0x6D5E, KANJI_LEVEL4,  // 浞
	0x6D60, KANJI_LEVEL4,  // 浠
	0x6D70, KANJI_LEVEL4,  // 浰
	0x6D80, KANJI_LEVEL4,  // 涀
	0x6D81, KANJI_LEVEL4,  // 涁
	0x6D8A, KANJI_LEVEL4,  // 涊
	0x6D8D, KANJI_LEVEL4,  // 涍
	0x6D91, KANJI_LEVEL4,  // 涑
	0x6D98, KANJI_LEVEL4,  // 涘
	0xD84F, KANJI_LEVEL4,  // �
	0xDD40, KANJI_LEVEL4,  // �
	0x6E17, KANJI_LEVEL4,  // 渗
	0xD84F, KANJI_LEVEL4,  // �
	0xDDFA, KANJI_LEVEL4,  // �
	0xD84F, KANJI_LEVEL4,  // �
	0xDDF9, KANJI_LEVEL4,  // �
	0xD84F, KANJI_LEVEL4,  // �
	0xDDD3, KANJI_LEVEL4,  // �
	0x6DAB, KANJI_LEVEL4,  // 涫
	0x6DAE, KANJI_LEVEL4,  // 涮
	0x6DB4, KANJI_LEVEL4,  // 涴
	0x6DC2, KANJI_LEVEL4,  // 淂
	0x6D34, KANJI_LEVEL4,  // 洴
	0x6DC8, KANJI_LEVEL4,  // 淈
	0x6DCE, KANJI_LEVEL4,  // 淎
	0x6DCF, KANJI_LEVEL4,  // 淏
	0x6DD0, KANJI_LEVEL4,  // 淐
	0x6DDF, KANJI_LEVEL4,  // 淟
	0x6DE9, KANJI_LEVEL4,  // 淩
	0x6DF6, KANJI_LEVEL4,  // 淶
	0x6E36, KANJI_LEVEL4,  // 渶
	0x6E1E, KANJI_LEVEL4,  // 渞
	0x6E22, KANJI_LEVEL4,  // 渢
	0x6E27, KANJI_LEVEL4,  // 渧
	0x3D11, KANJI_LEVEL4,  // 㴑
	0x6E32, KANJI_LEVEL4,  // 渲
	0x6E3C, KANJI_LEVEL4,  // 渼
	0x6E48, KANJI_LEVEL4,  // 湈
	0x6E49, KANJI_LEVEL4,  // 湉
	0x6E4B, KANJI_LEVEL4,  // 湋
	0x6E4C, KANJI_LEVEL4,  // 湌
	0x6E4F, KANJI_LEVEL4,  // 湏
	0x6E51, KANJI_LEVEL4,  // 湑
	0x6E53, KANJI_LEVEL4,  // 湓
	0x6E54, KANJI_LEVEL4,  // 湔
	0x6E57, KANJI_LEVEL4,  // 湗
	0x6E63, KANJI_LEVEL4,  // 湣
	0x3D1E, KANJI_LEVEL4,  // 㴞
	0x6E93, KANJI_LEVEL4,  // 溓
	0x6EA7, KANJI_LEVEL4,  // 溧
	0x6EB4, KANJI_LEVEL4,  // 溴
	0x6EBF, KANJI_LEVEL4,  // 溿
	0x6EC3, KANJI_LEVEL4,  // 滃
	0x6ECA, KANJI_LEVEL4,  // 滊
	0x6ED9, KANJI_LEVEL4,  // 滙
	0x6F35, KANJI_LEVEL4,  // 漵
	0x6EEB, KANJI_LEVEL4,  // 滫
	0x6EF9, KANJI_LEVEL4,  // 滹
	0x6EFB, KANJI_LEVEL4,  // 滻
	0x6F0A, KANJI_LEVEL4,  // 漊
	0x6F0C, KANJI_LEVEL4,  // 漌
	0x6F18, KANJI_LEVEL4,  // 漘
	0x6F25, KANJI_LEVEL4,  // 漥
	0x6F36, KANJI_LEVEL4,  // 漶
	0x6F3C, KANJI_LEVEL4,  // 漼
	0xD84F, KANJI_LEVEL4,  // �
	0xDF7E, KANJI_LEVEL4,  // �
	0x6F52, KANJI_LEVEL4,  // 潒
	0x6F57, KANJI_LEVEL4,  // 潗
	0x6F5A, KANJI_LEVEL4,  // 潚
	0x6F60, KANJI_LEVEL4,  // 潠
	0x6F68, KANJI_LEVEL4,  // 潨
	0x6F98, KANJI_LEVEL4,  // 澘
	0x6F7D, KANJI_LEVEL4,  // 潽
	0x6F90, KANJI_LEVEL4,  // 澐
	0x6F96, KANJI_LEVEL4,  // 澖
	0x6FBE, KANJI_LEVEL4,  // 澾
	0x6F9F, KANJI_LEVEL4,  // 澟
	0x6FA5, KANJI_LEVEL4,  // 澥
	0x6FAF, KANJI_LEVEL4,  // 澯
	0x3D64, KANJI_LEVEL4,  // 㵤
	0x6FB5, KANJI_LEVEL4,  // 澵
	0x6FC8, KANJI_LEVEL4,  // 濈
	0x6FC9, KANJI_LEVEL4,  // 濉
	0x6FDA, KANJI_LEVEL4,  // 濚
	0x6FDE, KANJI_LEVEL4,  // 濞
	0x6FE9, KANJI_LEVEL4,  // 濩
	0xD850, KANJI_LEVEL4,  // �
	0xDC96, KANJI_LEVEL4,  // �
	0x6FFC, KANJI_LEVEL4,  // 濼
	0x7000, KANJI_LEVEL4,  // 瀀
	0x7007, KANJI_LEVEL4,  // 瀇
	0x700A, KANJI_LEVEL4,  // 瀊
	0x7023, KANJI_LEVEL4,  // 瀣
	0xD850, KANJI_LEVEL4,  // �
	0xDD03, KANJI_LEVEL4,  // �
	0x7039, KANJI_LEVEL4,  // 瀹
	0x703A, KANJI_LEVEL4,  // 瀺
	0x703C, KANJI_LEVEL4,  // 瀼
	0x7043, KANJI_LEVEL4,  // 灃
	0x7047, KANJI_LEVEL4,  // 灇
	0x704B, KANJI_LEVEL4,  // 灋
	0x3D9A, KANJI_LEVEL4,  // 㶚
	0x7054, KANJI_LEVEL4,  // 灔
	0x7065, KANJI_LEVEL4,  // 灥
	0x7069, KANJI_LEVEL4,  // 灩
	0x706C, KANJI_LEVEL4,  // 灬
	0x706E, KANJI_LEVEL4,  // 灮
	0x7076, KANJI_LEVEL4,  // 灶
	0x707E, KANJI_LEVEL4,  // 灾
	0x7081, KANJI_LEVEL4,  // 炁
	0x7086, KANJI_LEVEL4,  // 炆
	0x7095, KANJI_LEVEL4,  // 炕
	0x7097, KANJI_LEVEL4,  // 炗
	0x70BB, KANJI_LEVEL4,  // 炻
	0xD850, KANJI_LEVEL4,  // �
	0xDDC6, KANJI_LEVEL4,  // �
	0x709F, KANJI_LEVEL4,  // 炟
	0x70B1, KANJI_LEVEL4,  // 炱
	0xD850, KANJI_LEVEL4,  // �
	0xDDFE, KANJI_LEVEL4,  // �
	0x70EC, KANJI_LEVEL4,  // 烬
	0x70CA, KANJI_LEVEL4,  // 烊
	0x70D1, KANJI_LEVEL4,  // 烑
	0x70D3, KANJI_LEVEL4,  // 烓
	0x70DC, KANJI_LEVEL4,  // 烜
	0x7103, KANJI_LEVEL4,  // 焃
	0x7104, KANJI_LEVEL4,  // 焄
	0x7106, KANJI_LEVEL4,  // 焆
	0x7107, KANJI_LEVEL4,  // 焇
	0x7108, KANJI_LEVEL4,  // 焈
	0x710C, KANJI_LEVEL4,  // 焌
	0x3DC0, KANJI_LEVEL4,  // 㷀
	0x712F, KANJI_LEVEL4,  // 焯
	0x7131, KANJI_LEVEL4,  // 焱
	0x7150, KANJI_LEVEL4,  // 煐
	0x714A, KANJI_LEVEL4,  // 煊
	0x7153, KANJI_LEVEL4,  // 煓
	0x715E, KANJI_LEVEL4,  // 煞
	0x3DD4, KANJI_LEVEL4,  // 㷔
	0x7196, KANJI_LEVEL4,  // 熖
	0x7180, KANJI_LEVEL4,  // 熀
	0x719B, KANJI_LEVEL4,  // 熛
	0x71A0, KANJI_LEVEL4,  // 熠
	0x71A2, KANJI_LEVEL4,  // 熢
	0x71AE, KANJI_LEVEL4,  // 熮
	0x71AF, KANJI_LEVEL4,  // 熯
	0x71B3, KANJI_LEVEL4,  // 熳
	0xD850, KANJI_LEVEL4,  // �
	0xDFBC, KANJI_LEVEL4,  // �
	0x71CB, KANJI_LEVEL4,  // 燋
	0x71D3, KANJI_LEVEL4,  // 燓
	0x71D9, KANJI_LEVEL4,  // 燙
	0x71DC, KANJI_LEVEL4,  // 燜
	0x7207, KANJI_LEVEL4,  // 爇
	0x3E05, KANJI_LEVEL4,  // 㸅
	0xFA49, KANJI_LEVEL4,  // 爫
	0x722B, KANJI_LEVEL4,  // 爫
	0x7234, KANJI_LEVEL4,  // 爴
	0x7238, KANJI_LEVEL4,  // 爸
	0x7239, KANJI_LEVEL4,  // 爹
	0x4E2C, KANJI_LEVEL4,  // 丬
	0x7242, KANJI_LEVEL4,  // 牂
	0x7253, KANJI_LEVEL4,  // 牓
	0x7257, KANJI_LEVEL4,  // 牗
	0x7263, KANJI_LEVEL4,  // 牣
	0xD851, KANJI_LEVEL4,  // �
	0xDE29, KANJI_LEVEL4,  // �
	0x726E, KANJI_LEVEL4,  // 牮
	0x726F, KANJI_LEVEL4,  // 牯
	0x7278, KANJI_LEVEL4,  // 牸
	0x727F, KANJI_LEVEL4,  // 牿
	0x728E, KANJI_LEVEL4,  // 犎
	0xD851, KANJI_LEVEL4,  // �
	0xDEA5, KANJI_LEVEL4,  // �
	0x72AD, KANJI_LEVEL4,  // 犭
	0x72AE, KANJI_LEVEL4,  // 犮
	0x72B0, KANJI_LEVEL4,  // 犰
	0x72B1, KANJI_LEVEL4,  // 犱
	0x72C1, KANJI_LEVEL4,  // 狁
	0x3E60, KANJI_LEVEL4,  // 㹠
	0x72CC, KANJI_LEVEL4,  // 狌
	0x3E66, KANJI_LEVEL4,  // 㹦
	0x3E68, KANJI_LEVEL4,  // 㹨
	0x72F3, KANJI_LEVEL4,  // 狳
	0x72FA, KANJI_LEVEL4,  // 狺
	0x7307, KANJI_LEVEL4,  // 猇
	0x7312, KANJI_LEVEL4,  // 猒
	0x7318, KANJI_LEVEL4,  // 猘
	0x7319, KANJI_LEVEL4,  // 猙
	0x3E83, KANJI_LEVEL4,  // 㺃
	0x7339, KANJI_LEVEL4,  // 猹
	0x732C, KANJI_LEVEL4,  // 猬
	0x7331, KANJI_LEVEL4,  // 猱
	0x7333, KANJI_LEVEL4,  // 猳
	0x733D, KANJI_LEVEL4,  // 猽
	0x7352, KANJI_LEVEL4,  // 獒
	0x3E94, KANJI_LEVEL4,  // 㺔
	0x736B, KANJI_LEVEL4,  // 獫
	0x736C, KANJI_LEVEL4,  // 獬
	0xD852, KANJI_LEVEL4,  // �
	0xDC96, KANJI_LEVEL4,  // �
	0x736E, KANJI_LEVEL4,  // 獮
	0x736F, KANJI_LEVEL4,  // 獯
	0x7371, KANJI_LEVEL4,  // 獱
	0x7377, KANJI_LEVEL4,  // 獷
	0x7381, KANJI_LEVEL4,  // 玁
	0x7385, KANJI_LEVEL4,  // 玅
	0x738A, KANJI_LEVEL4,  // 玊
	0x7394, KANJI_LEVEL4,  // 玔
	0x7398, KANJI_LEVEL4,  // 玘
	0x739C, KANJI_LEVEL4,  // 玜
	0x739E, KANJI_LEVEL4,  // 玞
	0x73A5, KANJI_LEVEL4,  // 玥
	0x73A8, KANJI_LEVEL4,  // 玨
	0x73B5, KANJI_LEVEL4,  // 玵
	0x73B7, KANJI_LEVEL4,  // 玷
	0x73B9, KANJI_LEVEL4,  // 玹
	0x73BC, KANJI_LEVEL4,  // 玼
	0x73BF, KANJI_LEVEL4,  // 玿
	0x73C5, KANJI_LEVEL4,  // 珅
	0x73CB, KANJI_LEVEL4,  // 珋
	0x73E1, KANJI_LEVEL4,  // 珡
	0x73E7, KANJI_LEVEL4,  // 珧
	0x73F9, KANJI_LEVEL4,  // 珹
	0x7413, KANJI_LEVEL4,  // 琓
	0x73FA, KANJI_LEVEL4,  // 珺
	0x7401, KANJI_LEVEL4,  // 琁
	0x7424, KANJI_LEVEL4,  // 琤
	0x7431, KANJI_LEVEL4,  // 琱
	0x7439, KANJI_LEVEL4,  // 琹
	0x7453, KANJI_LEVEL4,  // 瑓
	0x7440, KANJI_LEVEL4,  // 瑀
	0x7443, KANJI_LEVEL4,  // 瑃
	0x744D, KANJI_LEVEL4,  // 瑍
	0x7452, KANJI_LEVEL4,  // 瑒
	0x745D, KANJI_LEVEL4,  // 瑝
	0x7471, KANJI_LEVEL4,  // 瑱
	0x7481, KANJI_LEVEL4,  // 璁
	0x7485, KANJI_LEVEL4,  // 璅
	0x7488, KANJI_LEVEL4,  // 璈
	0xD852, KANJI_LEVEL4,  // �
	0xDE4D, KANJI_LEVEL4,  // �
	0x7492, KANJI_LEVEL4,  // 璒
	0x7497, KANJI_LEVEL4,  // 璗
	0x7499, KANJI_LEVEL4,  // 璙
	0x74A0, KANJI_LEVEL4,  // 璠
	0x74A1, KANJI_LEVEL4,  // 璡
	0x74A5, KANJI_LEVEL4,  // 璥
	0x74AA, KANJI_LEVEL4,  // 璪
	0x74AB, KANJI_LEVEL4,  // 璫
	0x74B9, KANJI_LEVEL4,  // 璹
	0x74BB, KANJI_LEVEL4,  // 璻
	0x74BA, KANJI_LEVEL4,  // 璺
	0x74D6, KANJI_LEVEL4,  // 瓖
	0x74D8, KANJI_LEVEL4,  // 瓘
	0x74DE, KANJI_LEVEL4,  // 瓞
	0x74EF, KANJI_LEVEL4,  // 瓯
	0x74EB, KANJI_LEVEL4,  // 瓫
	0xD852, KANJI_LEVEL4,  // �
	0xDF56, KANJI_LEVEL4,  // �
	0x74FA, KANJI_LEVEL4,  // 瓺
	0xD852, KANJI_LEVEL4,  // �
	0xDF6F, KANJI_LEVEL4,  // �
	0x7520, KANJI_LEVEL4,  // 甠
	0x7524, KANJI_LEVEL4,  // 甤
	0x752A, KANJI_LEVEL4,  // 甪
	0x3F57, KANJI_LEVEL4,  // 㽗
	0xD853, KANJI_LEVEL4,  // �
	0xDC16, KANJI_LEVEL4,  // �
	0x753D, KANJI_LEVEL4,  // 甽
	0x753E, KANJI_LEVEL4,  // 甾
	0x7540, KANJI_LEVEL4,  // 畀
	0x7548, KANJI_LEVEL4,  // 畈
	0x754E, KANJI_LEVEL4,  // 畎
	0x7550, KANJI_LEVEL4,  // 畐
	0x7552, KANJI_LEVEL4,  // 畒
	0x756C, KANJI_LEVEL4,  // 畬
	0x7572, KANJI_LEVEL4,  // 畲
	0x7571, KANJI_LEVEL4,  // 畱
	0x757A, KANJI_LEVEL4,  // 畺
	0x757D, KANJI_LEVEL4,  // 畽
	0x757E, KANJI_LEVEL4,  // 畾
	0x7581, KANJI_LEVEL4,  // 疁
	0xD853, KANJI_LEVEL4,  // �
	0xDD14, KANJI_LEVEL4,  // �
	0x758C, KANJI_LEVEL4,  // 疌
	0x3F75, KANJI_LEVEL4,  // 㽵
	0x75A2, KANJI_LEVEL4,  // 疢
	0x3F77, KANJI_LEVEL4,  // 㽷
	0x75B0, KANJI_LEVEL4,  // 疰
	0x75B7, KANJI_LEVEL4,  // 疷
	0x75BF, KANJI_LEVEL4,  // 疿
	0x75C0, KANJI_LEVEL4,  // 痀
	0x75C6, KANJI_LEVEL4,  // 痆
	0x75CF, KANJI_LEVEL4,  // 痏
	0x75D3, KANJI_LEVEL4,  // 痓
	0x75DD, KANJI_LEVEL4,  // 痝
	0x75DF, KANJI_LEVEL4,  // 痟
	0x75E0, KANJI_LEVEL4,  // 痠
	0x75E7, KANJI_LEVEL4,  // 痧
	0x75EC, KANJI_LEVEL4,  // 痬
	0x75EE, KANJI_LEVEL4,  // 痮
	0x75F1, KANJI_LEVEL4,  // 痱
	0x75F9, KANJI_LEVEL4,  // 痹
	0x7603, KANJI_LEVEL4,  // 瘃
	0x7618, KANJI_LEVEL4,  // 瘘
	0x7607, KANJI_LEVEL4,  // 瘇
	0x760F, KANJI_LEVEL4,  // 瘏
	0x3FAE, KANJI_LEVEL4,  // 㾮
	0xD853, KANJI_LEVEL4,  // �
	0xDE0E, KANJI_LEVEL4,  // �
	0x7613, KANJI_LEVEL4,  // 瘓
	0x761B, KANJI_LEVEL4,  // 瘛
	0x761C, KANJI_LEVEL4,  // 瘜
	0xD853, KANJI_LEVEL4,  // �
	0xDE37, KANJI_LEVEL4,  // �
	0x7625, KANJI_LEVEL4,  // 瘥
	0x7628, KANJI_LEVEL4,  // 瘨
	0x763C, KANJI_LEVEL4,  // 瘼
	0x7633, KANJI_LEVEL4,  // 瘳
	0xD853, KANJI_LEVEL4,  // �
	0xDE6A, KANJI_LEVEL4,  // �
	0x3FC9, KANJI_LEVEL4,  // 㿉
	0x7641, KANJI_LEVEL4,  // 癁
	0xD853, KANJI_LEVEL4,  // �
	0xDE8B, KANJI_LEVEL4,  // �
	0x7649, KANJI_LEVEL4,  // 癉
	0x7655, KANJI_LEVEL4,  // 癕
	0x3FD7, KANJI_LEVEL4,  // 㿗
	0x766E, KANJI_LEVEL4,  // 癮
	0x7695, KANJI_LEVEL4,  // 皕
	0x769C, KANJI_LEVEL4,  // 皜
	0x76A1, KANJI_LEVEL4,  // 皡
	0x76A0, KANJI_LEVEL4,  // 皠
	0x76A7, KANJI_LEVEL4,  // 皧
	0x76A8, KANJI_LEVEL4,  // 皨
	0x76AF, KANJI_LEVEL4,  // 皯
	0xD854, KANJI_LEVEL4,  // �
	0xDC4A, KANJI_LEVEL4,  // �
	0x76C9, KANJI_LEVEL4,  // 盉
	0xD854, KANJI_LEVEL4,  // �
	0xDC55, KANJI_LEVEL4,  // �
	0x76E8, KANJI_LEVEL4,  // 盨
	0x76EC, KANJI_LEVEL4,  // 盬
	0xD854, KANJI_LEVEL4,  // �
	0xDD22, KANJI_LEVEL4,  // �
	0x7717, KANJI_LEVEL4,  // 眗
	0x771A, KANJI_LEVEL4,  // 眚
	0x772D, KANJI_LEVEL4,  // 眭
	0x7735, KANJI_LEVEL4,  // 眵
	0xD854, KANJI_LEVEL4,  // �
	0xDDA9, KANJI_LEVEL4,  // �
	0x4039, KANJI_LEVEL4,  // 䀹
	0xD854, KANJI_LEVEL4,  // �
	0xDDE5, KANJI_LEVEL4,  // �
	0xD854, KANJI_LEVEL4,  // �
	0xDDCD, KANJI_LEVEL4,  // �
	0x7758, KANJI_LEVEL4,  // 睘
	0x7760, KANJI_LEVEL4,  // 睠
	0x776A, KANJI_LEVEL4,  // 睪
	0xD854, KANJI_LEVEL4,  // �
	0xDE1E, KANJI_LEVEL4,  // �
	0x7772, KANJI_LEVEL4,  // 睲
	0x777C, KANJI_LEVEL4,  // 睼
	0x777D, KANJI_LEVEL4,  // 睽
	0xD854, KANJI_LEVEL4,  // �
	0xDE4C, KANJI_LEVEL4,  // �
	0x4058, KANJI_LEVEL4,  // 䁘
	0x779A, KANJI_LEVEL4,  // 瞚
	0x779F, KANJI_LEVEL4,  // 瞟
	0x77A2, KANJI_LEVEL4,  // 瞢
	0x77A4, KANJI_LEVEL4,  // 瞤
	0x77A9, KANJI_LEVEL4,  // 瞩
	0x77DE, KANJI_LEVEL4,  // 矞
	0x77DF, KANJI_LEVEL4,  // 矟
	0x77E4, KANJI_LEVEL4,  // 矤
	0x77E6, KANJI_LEVEL4,  // 矦
	0x77EA, KANJI_LEVEL4,  // 矪
	0x77EC, KANJI_LEVEL4,  // 矬
	0x4093, KANJI_LEVEL4,  // 䂓
	0x77F0, KANJI_LEVEL4,  // 矰
	0x77F4, KANJI_LEVEL4,  // 矴
	0x77FB, KANJI_LEVEL4,  // 矻
	0xD855, KANJI_LEVEL4,  // �
	0xDC2E, KANJI_LEVEL4,  // �
	0x7805, KANJI_LEVEL4,  // 砅
	0x7806, KANJI_LEVEL4,  // 砆
	0x7809, KANJI_LEVEL4,  // 砉
	0x780D, KANJI_LEVEL4,  // 砍
	0x7819, KANJI_LEVEL4,  // 砙
	0x7821, KANJI_LEVEL4,  // 砡
	0x782C, KANJI_LEVEL4,  // 砬
	0x7847, KANJI_LEVEL4,  // 硇
	0x7864, KANJI_LEVEL4,  // 硤
	0x786A, KANJI_LEVEL4,  // 硪
	0xD855, KANJI_LEVEL4,  // �
	0xDCD9, KANJI_LEVEL4,  // �
	0x788A, KANJI_LEVEL4,  // 碊
	0x7894, KANJI_LEVEL4,  // 碔
	0x78A4, KANJI_LEVEL4,  // 碤
	0x789D, KANJI_LEVEL4,  // 碝
	0x789E, KANJI_LEVEL4,  // 碞
	0x789F, KANJI_LEVEL4,  // 碟
	0x78BB, KANJI_LEVEL4,  // 碻
	0x78C8, KANJI_LEVEL4,  // 磈
	0x78CC, KANJI_LEVEL4,  // 磌
	0x78CE, KANJI_LEVEL4,  // 磎
	0x78D5, KANJI_LEVEL4,  // 磕
	0x78E0, KANJI_LEVEL4,  // 磠
	0x78E1, KANJI_LEVEL4,  // 磡
	0x78E6, KANJI_LEVEL4,  // 磦
	0x78F9, KANJI_LEVEL4,  // 磹
	0x78FA, KANJI_LEVEL4,  // 磺
	0x78FB, KANJI_LEVEL4,  // 磻
	0x78FE, KANJI_LEVEL4,  // 磾
	0xD855, KANJI_LEVEL4,  // �
	0xDDA7, KANJI_LEVEL4,  // �
	0x7910, KANJI_LEVEL4,  // 礐
	0x791B, KANJI_LEVEL4,  // 礛
	0x7930, KANJI_LEVEL4,  // 礰
	0x7925, KANJI_LEVEL4,  // 礥
	0x793B, KANJI_LEVEL4,  // 礻
	0x794A, KANJI_LEVEL4,  // 祊
	0x7958, KANJI_LEVEL4,  // 祘
	0x795B, KANJI_LEVEL4,  // 祛
	0x4105, KANJI_LEVEL4,  // 䄅
	0x7967, KANJI_LEVEL4,  // 祧
	0x7972, KANJI_LEVEL4,  // 祲
	0x7994, KANJI_LEVEL4,  // 禔
	0x7995, KANJI_LEVEL4,  // 禕
	0x7996, KANJI_LEVEL4,  // 禖
	0x799B, KANJI_LEVEL4,  // 禛
	0x79A1, KANJI_LEVEL4,  // 禡
	0x79A9, KANJI_LEVEL4,  // 禩
	0x79B4, KANJI_LEVEL4,  // 禴
	0x79BB, KANJI_LEVEL4,  // 离
	0x79C2, KANJI_LEVEL4,  // 秂
	0x79C7, KANJI_LEVEL4,  // 秇
	0x79CC, KANJI_LEVEL4,  // 秌
	0x79CD, KANJI_LEVEL4,  // 种
	0x79D6, KANJI_LEVEL4,  // 秖
	0x4148, KANJI_LEVEL4,  // 䅈
	0xD855, KANJI_LEVEL4,  // �
	0xDFA9, KANJI_LEVEL4,  // �
	0xD855, KANJI_LEVEL4,  // �
	0xDFB4, KANJI_LEVEL4,  // �
	0x414F, KANJI_LEVEL4,  // 䅏
	0x7A0A, KANJI_LEVEL4,  // 稊
	0x7A11, KANJI_LEVEL4,  // 稑
	0x7A15, KANJI_LEVEL4,  // 稕
	0x7A1B, KANJI_LEVEL4,  // 稛
	0x7A1E, KANJI_LEVEL4,  // 稞
	0x4163, KANJI_LEVEL4,  // 䅣
	0x7A2D, KANJI_LEVEL4,  // 稭
	0x7A38, KANJI_LEVEL4,  // 稸
	0x7A47, KANJI_LEVEL4,  // 穇
	0x7A4C, KANJI_LEVEL4,  // 穌
	0x7A56, KANJI_LEVEL4,  // 穖
	0x7A59, KANJI_LEVEL4,  // 穙
	0x7A5C, KANJI_LEVEL4,  // 穜
	0x7A5F, KANJI_LEVEL4,  // 穟
	0x7A60, KANJI_LEVEL4,  // 穠
	0x7A67, KANJI_LEVEL4,  // 穧
	0x7A6A, KANJI_LEVEL4,  // 穪
	0x7A75, KANJI_LEVEL4,  // 穵
	0x7A78, KANJI_LEVEL4,  // 穸
	0x7A82, KANJI_LEVEL4,  // 窂
	0x7A8A, KANJI_LEVEL4,  // 窊
	0x7A90, KANJI_LEVEL4,  // 窐
	0x7AA3, KANJI_LEVEL4,  // 窣
	0x7AAC, KANJI_LEVEL4,  // 窬
	0xD856, KANJI_LEVEL4,  // �
	0xDDD4, KANJI_LEVEL4,  // �
	0x41B4, KANJI_LEVEL4,  // 䆴
	0x7AB9, KANJI_LEVEL4,  // 窹
	0x7ABC, KANJI_LEVEL4,  // 窼
	0x7ABE, KANJI_LEVEL4,  // 窾
	0x41BF, KANJI_LEVEL4,  // 䆿
	0x7ACC, KANJI_LEVEL4,  // 竌
	0x7AD1, KANJI_LEVEL4,  // 竑
	0x7AE7, KANJI_LEVEL4,  // 竧
	0x7AE8, KANJI_LEVEL4,  // 竨
	0x7AF4, KANJI_LEVEL4,  // 竴
	0xD856, KANJI_LEVEL4,  // �
	0xDEE4, KANJI_LEVEL4,  // �
	0xD856, KANJI_LEVEL4,  // �
	0xDEE3, KANJI_LEVEL4,  // �
	0x7B07, KANJI_LEVEL4,  // 笇
	0xD856, KANJI_LEVEL4,  // �
	0xDEF1, KANJI_LEVEL4,  // �
	0x7B3D, KANJI_LEVEL4,  // 笽
	0x7B27, KANJI_LEVEL4,  // 笧
	0x7B2A, KANJI_LEVEL4,  // 笪
	0x7B2E, KANJI_LEVEL4,  // 笮
	0x7B2F, KANJI_LEVEL4,  // 笯
	0x7B31, KANJI_LEVEL4,  // 笱
	0x41E6, KANJI_LEVEL4,  // 䇦
	0x41F3, KANJI_LEVEL4,  // 䇳
	0x7B7F, KANJI_LEVEL4,  // 筿
	0x7B41, KANJI_LEVEL4,  // 筁
	0x41EE, KANJI_LEVEL4,  // 䇮
	0x7B55, KANJI_LEVEL4,  // 筕
	0x7B79, KANJI_LEVEL4,  // 筹
	0x7B64, KANJI_LEVEL4,  // 筤
	0x7B66, KANJI_LEVEL4,  // 筦
	0x7B69, KANJI_LEVEL4,  // 筩
	0x7B73, KANJI_LEVEL4,  // 筳
	0xD856, KANJI_LEVEL4,  // �
	0xDFB2, KANJI_LEVEL4,  // �
	0x4207, KANJI_LEVEL4,  // 䈇
	0x7B90, KANJI_LEVEL4,  // 箐
	0x7B91, KANJI_LEVEL4,  // 箑
	0x7B9B, KANJI_LEVEL4,  // 箛
	0x420E, KANJI_LEVEL4,  // 䈎
	0x7BAF, KANJI_LEVEL4,  // 箯
	0x7BB5, KANJI_LEVEL4,  // 箵
	0x7BBC, KANJI_LEVEL4,  // 箼
	0x7BC5, KANJI_LEVEL4,  // 篅
	0x7BCA, KANJI_LEVEL4,  // 篊
	0xD857, KANJI_LEVEL4,  // �
	0xDC4B, KANJI_LEVEL4,  // �
	0xD857, KANJI_LEVEL4,  // �
	0xDC64, KANJI_LEVEL4,  // �
	0x7BD4, KANJI_LEVEL4,  // 篔
	0x7BD6, KANJI_LEVEL4,  // 篖
	0x7BDA, KANJI_LEVEL4,  // 篚
	0x7BEA, KANJI_LEVEL4,  // 篪
	0x7BF0, KANJI_LEVEL4,  // 篰
	0x7C03, KANJI_LEVEL4,  // 簃
	0x7C0B, KANJI_LEVEL4,  // 簋
	0x7C0E, KANJI_LEVEL4,  // 簎
	0x7C0F, KANJI_LEVEL4,  // 簏
	0x7C26, KANJI_LEVEL4,  // 簦
	0x7C45, KANJI_LEVEL4,  // 籅
	0x7C4A, KANJI_LEVEL4,  // 籊
	0x7C51, KANJI_LEVEL4,  // 籑
	0x7C57, KANJI_LEVEL4,  // 籗
	0x7C5E, KANJI_LEVEL4,  // 籞
	0x7C61, KANJI_LEVEL4,  // 籡
	0x7C69, KANJI_LEVEL4,  // 籩
	0x7C6E, KANJI_LEVEL4,  // 籮
	0x7C6F, KANJI_LEVEL4,  // 籯
	0x7C70, KANJI_LEVEL4,  // 籰
	0xD857, KANJI_LEVEL4,  // �
	0xDE2E, KANJI_LEVEL4,  // �
	0xD857, KANJI_LEVEL4,  // �
	0xDE56, KANJI_LEVEL4,  // �
	0xD857, KANJI_LEVEL4,  // �
	0xDE65, KANJI_LEVEL4,  // �
	0x7CA6, KANJI_LEVEL4,  // 粦
	0xD857, KANJI_LEVEL4,  // �
	0xDE62, KANJI_LEVEL4,  // �
	0x7CB6, KANJI_LEVEL4,  // 粶
	0x7CB7, KANJI_LEVEL4,  // 粷
	0x7CBF, KANJI_LEVEL4,  // 粿
	0xD857, KANJI_LEVEL4,  // �
	0xDED8, KANJI_LEVEL4,  // �
	0x7CC4, KANJI_LEVEL4,  // 糄
	0xD857, KANJI_LEVEL4,  // �
	0xDEC2, KANJI_LEVEL4,  // �
	0x7CC8, KANJI_LEVEL4,  // 糈
	0x7CCD, KANJI_LEVEL4,  // 糍
	0xD857, KANJI_LEVEL4,  // �
	0xDEE8, KANJI_LEVEL4,  // �
	0x7CD7, KANJI_LEVEL4,  // 糗
	0xD857, KANJI_LEVEL4,  // �
	0xDF23, KANJI_LEVEL4,  // �
	0x7CE6, KANJI_LEVEL4,  // 糦
	0x7CEB, KANJI_LEVEL4,  // 糫
	0xD857, KANJI_LEVEL4,  // �
	0xDF5C, KANJI_LEVEL4,  // �
	0x7CF5, KANJI_LEVEL4,  // 糵
	0x7D03, KANJI_LEVEL4,  // 紃
	0x7D09, KANJI_LEVEL4,  // 紉
	0x42C6, KANJI_LEVEL4,  // 䋆
	0x7D12, KANJI_LEVEL4,  // 紒
	0x7D1E, KANJI_LEVEL4,  // 紞
	0xD857, KANJI_LEVEL4,  // �
	0xDFE0, KANJI_LEVEL4,  // �
	0xD857, KANJI_LEVEL4,  // �
	0xDFD4, KANJI_LEVEL4,  // �
	0x7D3D, KANJI_LEVEL4,  // 紽
	0x7D3E, KANJI_LEVEL4,  // 紾
	0x7D40, KANJI_LEVEL4,  // 絀
	0x7D47, KANJI_LEVEL4,  // 絇
	0xD858, KANJI_LEVEL4,  // �
	0xDC0C, KANJI_LEVEL4,  // �
	0xD857, KANJI_LEVEL4,  // �
	0xDFFB, KANJI_LEVEL4,  // �
	0x42D6, KANJI_LEVEL4,  // 䋖
	0x7D59, KANJI_LEVEL4,  // 絙
	0x7D5A, KANJI_LEVEL4,  // 絚
	0x7D6A, KANJI_LEVEL4,  // 絪
	0x7D70, KANJI_LEVEL4,  // 絰
	0x42DD, KANJI_LEVEL4,  // 䋝
	0x7D7F, KANJI_LEVEL4,  // 絿
	0xD858, KANJI_LEVEL4,  // �
	0xDC17, KANJI_LEVEL4,  // �
	0x7D86, KANJI_LEVEL4,  // 綆
	0x7D88, KANJI_LEVEL4,  // 綈
	0x7D8C, KANJI_LEVEL4,  // 綌
	0x7D97, KANJI_LEVEL4,  // 綗
	0xD858, KANJI_LEVEL4,  // �
	0xDC60, KANJI_LEVEL4,  // �
	0x7D9D, KANJI_LEVEL4,  // 綝
	0x7DA7, KANJI_LEVEL4,  // 綧
	0x7DAA, KANJI_LEVEL4,  // 綪
	0x7DB6, KANJI_LEVEL4,  // 綶
	0x7DB7, KANJI_LEVEL4,  // 綷
	0x7DC0, KANJI_LEVEL4,  // 緀
	0x7DD7, KANJI_LEVEL4,  // 緗
	0x7DD9, KANJI_LEVEL4,  // 緙
	0x7DE6, KANJI_LEVEL4,  // 緦
	0x7DF1, KANJI_LEVEL4,  // 緱
	0x7DF9, KANJI_LEVEL4,  // 緹
	0x4302, KANJI_LEVEL4,  // 䌂
	0xD858, KANJI_LEVEL4,  // �
	0xDCED, KANJI_LEVEL4,  // �
	0xFA58, KANJI_LEVEL4,  // 縉
	0x7E10, KANJI_LEVEL4,  // 縐
	0x7E17, KANJI_LEVEL4,  // 縗
	0x7E1D, KANJI_LEVEL4,  // 縝
	0x7E20, KANJI_LEVEL4,  // 縠
	0x7E27, KANJI_LEVEL4,  // 縧
	0x7E2C, KANJI_LEVEL4,  // 縬
	0x7E45, KANJI_LEVEL4,  // 繅
	0x7E73, KANJI_LEVEL4,  // 繳
	0x7E75, KANJI_LEVEL4,  // 繵
	0x7E7E, KANJI_LEVEL4,  // 繾
	0x7E86, KANJI_LEVEL4,  // 纆
	0x7E87, KANJI_LEVEL4,  // 纇
	0x432B, KANJI_LEVEL4,  // 䌫
	0x7E91, KANJI_LEVEL4,  // 纑
	0x7E98, KANJI_LEVEL4,  // 纘
	0x7E9A, KANJI_LEVEL4,  // 纚
	0x4343, KANJI_LEVEL4,  // 䍃
	0x7F3C, KANJI_LEVEL4,  // 缼
	0x7F3B, KANJI_LEVEL4,  // 缻
	0x7F3E, KANJI_LEVEL4,  // 缾
	0x7F43, KANJI_LEVEL4,  // 罃
	0x7F44, KANJI_LEVEL4,  // 罄
	0x7F4F, KANJI_LEVEL4,  // 罏
	0x34C1, KANJI_LEVEL4,  // 㓁
	0xD858, KANJI_LEVEL4,  // �
	0xDE70, KANJI_LEVEL4,  // �
	0x7F52, KANJI_LEVEL4,  // 罒
	0xD858, KANJI_LEVEL4,  // �
	0xDE86, KANJI_LEVEL4,  // �
	0x7F61, KANJI_LEVEL4,  // 罡
	0x7F63, KANJI_LEVEL4,  // 罣
	0x7F64, KANJI_LEVEL4,  // 罤
	0x7F6D, KANJI_LEVEL4,  // 罭
	0x7F7D, KANJI_LEVEL4,  // 罽
	0x7F7E, KANJI_LEVEL4,  // 罾
	0xD858, KANJI_LEVEL4,  // �
	0xDF4C, KANJI_LEVEL4,  // �
	0x7F90, KANJI_LEVEL4,  // 羐
	0x517B, KANJI_LEVEL4,  // 养
	0xD84F, KANJI_LEVEL4,  // �
	0xDD0E, KANJI_LEVEL4,  // �
	0x7F96, KANJI_LEVEL4,  // 羖
	0x7F9C, KANJI_LEVEL4,  // 羜
	0x7FAD, KANJI_LEVEL4,  // 羭
	0xD859, KANJI_LEVEL4,  // �
	0xDC02, KANJI_LEVEL4,  // �
	0x7FC3, KANJI_LEVEL4,  // 翃
	0x7FCF, KANJI_LEVEL4,  // 翏
	0x7FE3, KANJI_LEVEL4,  // 翣
	0x7FE5, KANJI_LEVEL4,  // 翥
	0x7FEF, KANJI_LEVEL4,  // 翯
	0x7FF2, KANJI_LEVEL4,  // 翲
	0x8002, KANJI_LEVEL4,  // 耂
	0x800A, KANJI_LEVEL4,  // 耊
	0x8008, KANJI_LEVEL4,  // 耈
	0x800E, KANJI_LEVEL4,  // 耎
	0x8011, KANJI_LEVEL4,  // 耑
	0x8016, KANJI_LEVEL4,  // 耖
	0x8024, KANJI_LEVEL4,  // 耤
	0x802C, KANJI_LEVEL4,  // 耬
	0x8030, KANJI_LEVEL4,  // 耰
	0x8043, KANJI_LEVEL4,  // 聃
	0x8066, KANJI_LEVEL4,  // 聦
	0x8071, KANJI_LEVEL4,  // 聱
	0x8075, KANJI_LEVEL4,  // 聵
	0x807B, KANJI_LEVEL4,  // 聻
	0x8099, KANJI_LEVEL4,  // 肙
	0x809C, KANJI_LEVEL4,  // 肜
	0x80A4, KANJI_LEVEL4,  // 肤
	0x80A7, KANJI_LEVEL4,  // 肧
	0x80B8, KANJI_LEVEL4,  // 肸
	0xD859, KANJI_LEVEL4,  // �
	0xDE7E, KANJI_LEVEL4,  // �
	0x80C5, KANJI_LEVEL4,  // 胅
	0x80D5, KANJI_LEVEL4,  // 胕
	0x80D8, KANJI_LEVEL4,  // 胘
	0x80E6, KANJI_LEVEL4,  // 胦
	0xD859, KANJI_LEVEL4,  // �
	0xDEB0, KANJI_LEVEL4,  // �
	0x810D, KANJI_LEVEL4,  // 脍
	0x80F5, KANJI_LEVEL4,  // 胵
	0x80FB, KANJI_LEVEL4,  // 胻
	0x43EE, KANJI_LEVEL4,  // 䏮
	0x8135, KANJI_LEVEL4,  // 脵
	0x8116, KANJI_LEVEL4,  // 脖
	0x811E, KANJI_LEVEL4,  // 脞
	0x43F0, KANJI_LEVEL4,  // 䏰
	0x8124, KANJI_LEVEL4,  // 脤
	0x8127, KANJI_LEVEL4,  // 脧
	0x812C, KANJI_LEVEL4,  // 脬
	0xD859, KANJI_LEVEL4,  // �
	0xDF1D, KANJI_LEVEL4,  // �
	0x813D, KANJI_LEVEL4,  // 脽
	0x4408, KANJI_LEVEL4,  // 䐈
	0x8169, KANJI_LEVEL4,  // 腩
	0x4417, KANJI_LEVEL4,  // 䐗
	0x8181, KANJI_LEVEL4,  // 膁
	0x441C, KANJI_LEVEL4,  // 䐜
	0x8184, KANJI_LEVEL4,  // 膄
	0x8185, KANJI_LEVEL4,  // 膅
	0x4422, KANJI_LEVEL4,  // 䐢
	0x8198, KANJI_LEVEL4,  // 膘
	0x81B2, KANJI_LEVEL4,  // 膲
	0x81C1, KANJI_LEVEL4,  // 臁
	0x81C3, KANJI_LEVEL4,  // 臃
	0x81D6, KANJI_LEVEL4,  // 臖
	0x81DB, KANJI_LEVEL4,  // 臛
	0xD85A, KANJI_LEVEL4,  // �
	0xDCDD, KANJI_LEVEL4,  // �
	0x81E4, KANJI_LEVEL4,  // 臤
	0xD85A, KANJI_LEVEL4,  // �
	0xDCEA, KANJI_LEVEL4,  // �
	0x81EC, KANJI_LEVEL4,  // 臬
	0xD85A, KANJI_LEVEL4,  // �
	0xDD51, KANJI_LEVEL4,  // �
	0x81FD, KANJI_LEVEL4,  // 臽
	0x81FF, KANJI_LEVEL4,  // 臿
	0xD85A, KANJI_LEVEL4,  // �
	0xDD6F, KANJI_LEVEL4,  // �
	0x8204, KANJI_LEVEL4,  // 舄
	0xD85A, KANJI_LEVEL4,  // �
	0xDDDD, KANJI_LEVEL4,  // �
	0x8219, KANJI_LEVEL4,  // 舙
	0x8221, KANJI_LEVEL4,  // 舡
	0x8222, KANJI_LEVEL4,  // 舢
	0xD85A, KANJI_LEVEL4,  // �
	0xDE1E, KANJI_LEVEL4,  // �
	0x8232, KANJI_LEVEL4,  // 舲
	0x8234, KANJI_LEVEL4,  // 舴
	0x823C, KANJI_LEVEL4,  // 舼
	0x8246, KANJI_LEVEL4,  // 艆
	0x8249, KANJI_LEVEL4,  // 艉
	0x8245, KANJI_LEVEL4,  // 艅
	0xD85A, KANJI_LEVEL4,  // �
	0xDE58, KANJI_LEVEL4,  // �
	0x824B, KANJI_LEVEL4,  // 艋
	0x4476, KANJI_LEVEL4,  // 䑶
	0x824F, KANJI_LEVEL4,  // 艏
	0x447A, KANJI_LEVEL4,  // 䑺
	0x8257, KANJI_LEVEL4,  // 艗
	0xD85A, KANJI_LEVEL4,  // �
	0xDE8C, KANJI_LEVEL4,  // �
	0x825C, KANJI_LEVEL4,  // 艜
	0x8263, KANJI_LEVEL4,  // 艣
	0xD85A, KANJI_LEVEL4,  // �
	0xDEB7, KANJI_LEVEL4,  // �
	0xFA5D, KANJI_LEVEL4,  // 艹
	0xFA5E, KANJI_LEVEL4,  // 艹
	0x8279, KANJI_LEVEL4,  // 艹
	0x4491, KANJI_LEVEL4,  // 䒑
	0x827D, KANJI_LEVEL4,  // 艽
	0x827F, KANJI_LEVEL4,  // 艿
	0x8283, KANJI_LEVEL4,  // 芃
	0x828A, KANJI_LEVEL4,  // 芊
	0x8293, KANJI_LEVEL4,  // 芓
	0x82A7, KANJI_LEVEL4,  // 芧
	0x82A8, KANJI_LEVEL4,  // 芨
	0x82B2, KANJI_LEVEL4,  // 芲
	0x82B4, KANJI_LEVEL4,  // 芴
	0x82BA, KANJI_LEVEL4,  // 芺
	0x82BC, KANJI_LEVEL4,  // 芼
	0x82E2, KANJI_LEVEL4,  // 苢
	0x82E8, KANJI_LEVEL4,  // 苨
	0x82F7, KANJI_LEVEL4,  // 苷
	0x8307, KANJI_LEVEL4,  // 茇
	0x8308, KANJI_LEVEL4,  // 茈
	0x830C, KANJI_LEVEL4,  // 茌
	0x8354, KANJI_LEVEL4,  // 荔
	0x831B, KANJI_LEVEL4,  // 茛
	0x831D, KANJI_LEVEL4,  // 茝
	0x8330, KANJI_LEVEL4,  // 茰
	0x833C, KANJI_LEVEL4,  // 茼
	0x8344, KANJI_LEVEL4,  // 荄
	0x8357, KANJI_LEVEL4,  // 荗
	0x44BE, KANJI_LEVEL4,  // 䒾
	0x837F, KANJI_LEVEL4,  // 荿
	0x44D4, KANJI_LEVEL4,  // 䓔
	0x44B3, KANJI_LEVEL4,  // 䒳
	0x838D, KANJI_LEVEL4,  // 莍
	0x8394, KANJI_LEVEL4,  // 莔
	0x8395, KANJI_LEVEL4,  // 莕
	0x839B, KANJI_LEVEL4,  // 莛
	0x839D, KANJI_LEVEL4,  // 莝
	0x83C9, KANJI_LEVEL4,  // 菉
	0x83D0, KANJI_LEVEL4,  // 菐
	0x83D4, KANJI_LEVEL4,  // 菔
	0x83DD, KANJI_LEVEL4,  // 菝
	0x83E5, KANJI_LEVEL4,  // 菥
	0x83F9, KANJI_LEVEL4,  // 菹
	0x840F, KANJI_LEVEL4,  // 萏
	0x8411, KANJI_LEVEL4,  // 萑
	0x8415, KANJI_LEVEL4,  // 萕
	0xD85B, KANJI_LEVEL4,  // �
	0xDC73, KANJI_LEVEL4,  // �
	0x8417, KANJI_LEVEL4,  // 萗
	0x8439, KANJI_LEVEL4,  // 萹
	0x844A, KANJI_LEVEL4,  // 葊
	0x844F, KANJI_LEVEL4,  // 葏
	0x8451, KANJI_LEVEL4,  // 葑
	0x8452, KANJI_LEVEL4,  // 葒
	0x8459, KANJI_LEVEL4,  // 葙
	0x845A, KANJI_LEVEL4,  // 葚
	0x845C, KANJI_LEVEL4,  // 葜
	0xD85B, KANJI_LEVEL4,  // �
	0xDCDD, KANJI_LEVEL4,  // �
	0x8465, KANJI_LEVEL4,  // 葥
	0x8476, KANJI_LEVEL4,  // 葶
	0x8478, KANJI_LEVEL4,  // 葸
	0x847C, KANJI_LEVEL4,  // 葼
	0x8481, KANJI_LEVEL4,  // 蒁
	0x450D, KANJI_LEVEL4,  // 䔍
	0x84DC, KANJI_LEVEL4,  // 蓜
	0x8497, KANJI_LEVEL4,  // 蒗
	0x84A6, KANJI_LEVEL4,  // 蒦
	0x84BE, KANJI_LEVEL4,  // 蒾
	0x4508, KANJI_LEVEL4,  // 䔈
	0x84CE, KANJI_LEVEL4,  // 蓎
	0x84CF, KANJI_LEVEL4,  // 蓏
	0x84D3, KANJI_LEVEL4,  // 蓓
	0xD85B, KANJI_LEVEL4,  // �
	0xDE65, KANJI_LEVEL4,  // �
	0x84E7, KANJI_LEVEL4,  // 蓧
	0x84EA, KANJI_LEVEL4,  // 蓪
	0x84EF, KANJI_LEVEL4,  // 蓯
	0x84F0, KANJI_LEVEL4,  // 蓰
	0x84F1, KANJI_LEVEL4,  // 蓱
	0x84FA, KANJI_LEVEL4,  // 蓺
	0x84FD, KANJI_LEVEL4,  // 蓽
	0x850C, KANJI_LEVEL4,  // 蔌
	0x851B, KANJI_LEVEL4,  // 蔛
	0x8524, KANJI_LEVEL4,  // 蔤
	0x8525, KANJI_LEVEL4,  // 蔥
	0x852B, KANJI_LEVEL4,  // 蔫
	0x8534, KANJI_LEVEL4,  // 蔴
	0x854F, KANJI_LEVEL4,  // 蕏
	0x856F, KANJI_LEVEL4,  // 蕯
	0x4525, KANJI_LEVEL4,  // 䔥
	0x4543, KANJI_LEVEL4,  // 䕃
	0x853E, KANJI_LEVEL4,  // 蔾
	0x8551, KANJI_LEVEL4,  // 蕑
	0x8553, KANJI_LEVEL4,  // 蕓
	0x855E, KANJI_LEVEL4,  // 蕞
	0x8561, KANJI_LEVEL4,  // 蕡
	0x8562, KANJI_LEVEL4,  // 蕢
	0xD85B, KANJI_LEVEL4,  // �
	0xDF94, KANJI_LEVEL4,  // �
	0x857B, KANJI_LEVEL4,  // 蕻
	0x857D, KANJI_LEVEL4,  // 蕽
	0x857F, KANJI_LEVEL4,  // 蕿
	0x8581, KANJI_LEVEL4,  // 薁
	0x8586, KANJI_LEVEL4,  // 薆
	0x8593, KANJI_LEVEL4,  // 薓
	0x859D, KANJI_LEVEL4,  // 薝
	0x859F, KANJI_LEVEL4,  // 薟
	0xD85B, KANJI_LEVEL4,  // �
	0xDFF8, KANJI_LEVEL4,  // �
	0xD85B, KANJI_LEVEL4,  // �
	0xDFF6, KANJI_LEVEL4,  // �
	0xD85B, KANJI_LEVEL4,  // �
	0xDFF7, KANJI_LEVEL4,  // �
	0x85B7, KANJI_LEVEL4,  // 薷
	0x85BC, KANJI_LEVEL4,  // 薼
	0x85C7, KANJI_LEVEL4,  // 藇
	0x85CA, KANJI_LEVEL4,  // 藊
	0x85D8, KANJI_LEVEL4,  // 藘
	0x85D9, KANJI_LEVEL4,  // 藙
	0x85DF, KANJI_LEVEL4,  // 藟
	0x85E1, KANJI_LEVEL4,  // 藡
	0x85E6, KANJI_LEVEL4,  // 藦
	0x85F6, KANJI_LEVEL4,  // 藶
	0x8600, KANJI_LEVEL4,  // 蘀
	0x8611, KANJI_LEVEL4,  // 蘑
	0x861E, KANJI_LEVEL4,  // 蘞
	0x8621, KANJI_LEVEL4,  // 蘡
	0x8624, KANJI_LEVEL4,  // 蘤
	0x8627, KANJI_LEVEL4,  // 蘧
	0xD85C, KANJI_LEVEL4,  // �
	0xDD0D, KANJI_LEVEL4,  // �
	0x8639, KANJI_LEVEL4,  // 蘹
	0x863C, KANJI_LEVEL4,  // 蘼
	0xD85C, KANJI_LEVEL4,  // �
	0xDD39, KANJI_LEVEL4,  // �
	0x8640, KANJI_LEVEL4,  // 虀
	0xFA20, KANJI_LEVEL4,  // 蘒
	0x8653, KANJI_LEVEL4,  // 虓
	0x8656, KANJI_LEVEL4,  // 虖
	0x866F, KANJI_LEVEL4,  // 虯
	0x8677, KANJI_LEVEL4,  // 虷
	0x867A, KANJI_LEVEL4,  // 虺
	0x8687, KANJI_LEVEL4,  // 蚇
	0x8689, KANJI_LEVEL4,  // 蚉
	0x868D, KANJI_LEVEL4,  // 蚍
	0x8691, KANJI_LEVEL4,  // 蚑
	0x869C, KANJI_LEVEL4,  // 蚜
	0x869D, KANJI_LEVEL4,  // 蚝
	0x86A8, KANJI_LEVEL4,  // 蚨
	0xFA21, KANJI_LEVEL4,  // 﨡
	0x86B1, KANJI_LEVEL4,  // 蚱
	0x86B3, KANJI_LEVEL4,  // 蚳
	0x86C1, KANJI_LEVEL4,  // 蛁
	0x86C3, KANJI_LEVEL4,  // 蛃
	0x86D1, KANJI_LEVEL4,  // 蛑
	0x86D5, KANJI_LEVEL4,  // 蛕
	0x86D7, KANJI_LEVEL4,  // 蛗
	0x86E3, KANJI_LEVEL4,  // 蛣
	0x86E6, KANJI_LEVEL4,  // 蛦
	0x45B8, KANJI_LEVEL4,  // 䖸
	0x8705, KANJI_LEVEL4,  // 蜅
	0x8707, KANJI_LEVEL4,  // 蜇
	0x870E, KANJI_LEVEL4,  // 蜎
	0x8710, KANJI_LEVEL4,  // 蜐
	0x8713, KANJI_LEVEL4,  // 蜓
	0x8719, KANJI_LEVEL4,  // 蜙
	0x871F, KANJI_LEVEL4,  // 蜟
	0x8721, KANJI_LEVEL4,  // 蜡
	0x8723, KANJI_LEVEL4,  // 蜣
	0x8731, KANJI_LEVEL4,  // 蜱
	0x873A, KANJI_LEVEL4,  // 蜺
	0x873E, KANJI_LEVEL4,  // 蜾
	0x8740, KANJI_LEVEL4,  // 蝀
	0x8743, KANJI_LEVEL4,  // 蝃
	0x8751, KANJI_LEVEL4,  // 蝑
	0x8758, KANJI_LEVEL4,  // 蝘
	0x8764, KANJI_LEVEL4,  // 蝤
	0x8765, KANJI_LEVEL4,  // 蝥
	0x8772, KANJI_LEVEL4,  // 蝲
	0x877C, KANJI_LEVEL4,  // 蝼
	0xD85C, KANJI_LEVEL4,  // �
	0xDFDB, KANJI_LEVEL4,  // �
	0xD85C, KANJI_LEVEL4,  // �
	0xDFDA, KANJI_LEVEL4,  // �
	0x87A7, KANJI_LEVEL4,  // 螧
	0x8789, KANJI_LEVEL4,  // 螉
	0x878B, KANJI_LEVEL4,  // 螋
	0x8793, KANJI_LEVEL4,  // 螓
	0x87A0, KANJI_LEVEL4,  // 螠
	0xD85C, KANJI_LEVEL4,  // �
	0xDFFE, KANJI_LEVEL4,  // �
	0x45E5, KANJI_LEVEL4,  // 䗥
	0x87BE, KANJI_LEVEL4,  // 螾
	0xD85D, KANJI_LEVEL4,  // �
	0xDC10, KANJI_LEVEL4,  // �
	0x87C1, KANJI_LEVEL4,  // 蟁
	0x87CE, KANJI_LEVEL4,  // 蟎
	0x87F5, KANJI_LEVEL4,  // 蟵
	0x87DF, KANJI_LEVEL4,  // 蟟
	0xD85D, KANJI_LEVEL4,  // �
	0xDC49, KANJI_LEVEL4,  // �
	0x87E3, KANJI_LEVEL4,  // 蟣
	0x87E5, KANJI_LEVEL4,  // 蟥
	0x87E6, KANJI_LEVEL4,  // 蟦
	0x87EA, KANJI_LEVEL4,  // 蟪
	0x87EB, KANJI_LEVEL4,  // 蟫
	0x87ED, KANJI_LEVEL4,  // 蟭
	0x8801, KANJI_LEVEL4,  // 蠁
	0x8803, KANJI_LEVEL4,  // 蠃
	0x880B, KANJI_LEVEL4,  // 蠋
	0x8813, KANJI_LEVEL4,  // 蠓
	0x8828, KANJI_LEVEL4,  // 蠨
	0x882E, KANJI_LEVEL4,  // 蠮
	0x8832, KANJI_LEVEL4,  // 蠲
	0x883C, KANJI_LEVEL4,  // 蠼
	0x460F, KANJI_LEVEL4,  // 䘏
	0x884A, KANJI_LEVEL4,  // 衊
	0x8858, KANJI_LEVEL4,  // 衘
	0x885F, KANJI_LEVEL4,  // 衟
	0x8864, KANJI_LEVEL4,  // 衤
	0xD85D, KANJI_LEVEL4,  // �
	0xDE15, KANJI_LEVEL4,  // �
	0xD85D, KANJI_LEVEL4,  // �
	0xDE14, KANJI_LEVEL4,  // �
	0x8869, KANJI_LEVEL4,  // 衩
	0xD85D, KANJI_LEVEL4,  // �
	0xDE31, KANJI_LEVEL4,  // �
	0x886F, KANJI_LEVEL4,  // 衯
	0x88A0, KANJI_LEVEL4,  // 袠
	0x88BC, KANJI_LEVEL4,  // 袼
	0x88BD, KANJI_LEVEL4,  // 袽
	0x88BE, KANJI_LEVEL4,  // 袾
	0x88C0, KANJI_LEVEL4,  // 裀
	0x88D2, KANJI_LEVEL4,  // 裒
	0xD85D, KANJI_LEVEL4,  // �
	0xDE93, KANJI_LEVEL4,  // �
	0x88D1, KANJI_LEVEL4,  // 裑
	0x88D3, KANJI_LEVEL4,  // 裓
	0x88DB, KANJI_LEVEL4,  // 裛
	0x88F0, KANJI_LEVEL4,  // 裰
	0x88F1, KANJI_LEVEL4,  // 裱
	0x4641, KANJI_LEVEL4,  // 䙁
	0x8901, KANJI_LEVEL4,  // 褁
	0xD85D, KANJI_LEVEL4,  // �
	0xDF0E, KANJI_LEVEL4,  // �
	0x8937, KANJI_LEVEL4,  // 褷
	0xD85D, KANJI_LEVEL4,  // �
	0xDF23, KANJI_LEVEL4,  // �
	0x8942, KANJI_LEVEL4,  // 襂
	0x8945, KANJI_LEVEL4,  // 襅
	0x8949, KANJI_LEVEL4,  // 襉
	0xD85D, KANJI_LEVEL4,  // �
	0xDF52, KANJI_LEVEL4,  // �
	0x4665, KANJI_LEVEL4,  // 䙥
	0x8962, KANJI_LEVEL4,  // 襢
	0x8980, KANJI_LEVEL4,  // 覀
	0x8989, KANJI_LEVEL4,  // 覉
	0x8990, KANJI_LEVEL4,  // 覐
	0x899F, KANJI_LEVEL4,  // 覟
	0x89B0, KANJI_LEVEL4,  // 覰
	0x89B7, KANJI_LEVEL4,  // 覷
	0x89D6, KANJI_LEVEL4,  // 觖
	0x89D8, KANJI_LEVEL4,  // 觘
	0x89EB, KANJI_LEVEL4,  // 觫
	0x46A1, KANJI_LEVEL4,  // 䚡
	0x89F1, KANJI_LEVEL4,  // 觱
	0x89F3, KANJI_LEVEL4,  // 觳
	0x89FD, KANJI_LEVEL4,  // 觽
	0x89FF, KANJI_LEVEL4,  // 觿
	0x46AF, KANJI_LEVEL4,  // 䚯
	0x8A11, KANJI_LEVEL4,  // 訑
	0x8A14, KANJI_LEVEL4,  // 訔
	0xD85E, KANJI_LEVEL4,  // �
	0xDD85, KANJI_LEVEL4,  // �
	0x8A21, KANJI_LEVEL4,  // 訡
	0x8A35, KANJI_LEVEL4,  // 訵
	0x8A3E, KANJI_LEVEL4,  // 訾
	0x8A45, KANJI_LEVEL4,  // 詅
	0x8A4D, KANJI_LEVEL4,  // 詍
	0x8A58, KANJI_LEVEL4,  // 詘
	0x8AAE, KANJI_LEVEL4,  // 誮
	0x8A90, KANJI_LEVEL4,  // 誐
	0x8AB7, KANJI_LEVEL4,  // 誷
	0x8ABE, KANJI_LEVEL4,  // 誾
	0x8AD7, KANJI_LEVEL4,  // 諗
	0x8AFC, KANJI_LEVEL4,  // 諼
	0xD85E, KANJI_LEVEL4,  // �
	0xDE84, KANJI_LEVEL4,  // �
	0x8B0A, KANJI_LEVEL4,  // 謊
	0x8B05, KANJI_LEVEL4,  // 謅
	0x8B0D, KANJI_LEVEL4,  // 謍
	0x8B1C, KANJI_LEVEL4,  // 謜
	0x8B1F, KANJI_LEVEL4,  // 謟
	0x8B2D, KANJI_LEVEL4,  // 謭
	0x8B43, KANJI_LEVEL4,  // 譃
	0x470C, KANJI_LEVEL4,  // 䜌
	0x8B51, KANJI_LEVEL4,  // 譑
	0x8B5E, KANJI_LEVEL4,  // 譞
	0x8B76, KANJI_LEVEL4,  // 譶
	0x8B7F, KANJI_LEVEL4,  // 譿
	0x8B81, KANJI_LEVEL4,  // 讁
	0x8B8B, KANJI_LEVEL4,  // 讋
	0x8B94, KANJI_LEVEL4,  // 讔
	0x8B95, KANJI_LEVEL4,  // 讕
	0x8B9C, KANJI_LEVEL4,  // 讜
	0x8B9E, KANJI_LEVEL4,  // 讞
	0x8C39, KANJI_LEVEL4,  // 谹
	0xD85E, KANJI_LEVEL4,  // �
	0xDFB3, KANJI_LEVEL4,  // �
	0x8C3D, KANJI_LEVEL4,  // 谽
	0xD85E, KANJI_LEVEL4,  // �
	0xDFBE, KANJI_LEVEL4,  // �
	0xD85E, KANJI_LEVEL4,  // �
	0xDFC7, KANJI_LEVEL4,  // �
	0x8C45, KANJI_LEVEL4,  // 豅
	0x8C47, KANJI_LEVEL4,  // 豇
	0x8C4F, KANJI_LEVEL4,  // 豏
	0x8C54, KANJI_LEVEL4,  // 豔
	0x8C57, KANJI_LEVEL4,  // 豗
	0x8C69, KANJI_LEVEL4,  // 豩
	0x8C6D, KANJI_LEVEL4,  // 豭
	0x8C73, KANJI_LEVEL4,  // 豳
	0xD85F, KANJI_LEVEL4,  // �
	0xDCB8, KANJI_LEVEL4,  // �
	0x8C93, KANJI_LEVEL4,  // 貓
	0x8C92, KANJI_LEVEL4,  // 貒
	0x8C99, KANJI_LEVEL4,  // 貙
	0x4764, KANJI_LEVEL4,  // 䝤
	0x8C9B, KANJI_LEVEL4,  // 貛
	0x8CA4, KANJI_LEVEL4,  // 貤
	0x8CD6, KANJI_LEVEL4,  // 賖
	0x8CD5, KANJI_LEVEL4,  // 賕
	0x8CD9, KANJI_LEVEL4,  // 賙
	0xD85F, KANJI_LEVEL4,  // �
	0xDDA0, KANJI_LEVEL4,  // �
	0x8CF0, KANJI_LEVEL4,  // 賰
	0x8CF1, KANJI_LEVEL4,  // 賱
	0xD85F, KANJI_LEVEL4,  // �
	0xDE10, KANJI_LEVEL4,  // �
	0x8D09, KANJI_LEVEL4,  // 贉
	0x8D0E, KANJI_LEVEL4,  // 贎
	0x8D6C, KANJI_LEVEL4,  // 赬
	0x8D84, KANJI_LEVEL4,  // 趄
	0x8D95, KANJI_LEVEL4,  // 趕
	0x8DA6, KANJI_LEVEL4,  // 趦
	0xD85F, KANJI_LEVEL4,  // �
	0xDFB7, KANJI_LEVEL4,  // �
	0x8DC6, KANJI_LEVEL4,  // 跆
	0x8DC8, KANJI_LEVEL4,  // 跈
	0x8DD9, KANJI_LEVEL4,  // 跙
	0x8DEC, KANJI_LEVEL4,  // 跬
	0x8E0C, KANJI_LEVEL4,  // 踌
	0x47FD, KANJI_LEVEL4,  // 䟽
	0x8DFD, KANJI_LEVEL4,  // 跽
	0x8E06, KANJI_LEVEL4,  // 踆
	0xD860, KANJI_LEVEL4,  // �
	0xDC8A, KANJI_LEVEL4,  // �
	0x8E14, KANJI_LEVEL4,  // 踔
	0x8E16, KANJI_LEVEL4,  // 踖
	0x8E21, KANJI_LEVEL4,  // 踡
	0x8E22, KANJI_LEVEL4,  // 踢
	0x8E27, KANJI_LEVEL4,  // 踧
	0xD860, KANJI_LEVEL4,  // �
	0xDCBB, KANJI_LEVEL4,  // �
	0x4816, KANJI_LEVEL4,  // 䠖
	0x8E36, KANJI_LEVEL4,  // 踶
	0x8E39, KANJI_LEVEL4,  // 踹
	0x8E4B, KANJI_LEVEL4,  // 蹋
	0x8E54, KANJI_LEVEL4,  // 蹔
	0x8E62, KANJI_LEVEL4,  // 蹢
	0x8E6C, KANJI_LEVEL4,  // 蹬
	0x8E6D, KANJI_LEVEL4,  // 蹭
	0x8E6F, KANJI_LEVEL4,  // 蹯
	0x8E98, KANJI_LEVEL4,  // 躘
	0x8E9E, KANJI_LEVEL4,  // 躞
	0x8EAE, KANJI_LEVEL4,  // 躮
	0x8EB3, KANJI_LEVEL4,  // 躳
	0x8EB5, KANJI_LEVEL4,  // 躵
	0x8EB6, KANJI_LEVEL4,  // 躶
	0x8EBB, KANJI_LEVEL4,  // 躻
	0xD860, KANJI_LEVEL4,  // �
	0xDE82, KANJI_LEVEL4,  // �
	0x8ED1, KANJI_LEVEL4,  // 軑
	0x8ED4, KANJI_LEVEL4,  // 軔
	0x484E, KANJI_LEVEL4,  // 䡎
	0x8EF9, KANJI_LEVEL4,  // 軹
	0xD860, KANJI_LEVEL4,  // �
	0xDEF3, KANJI_LEVEL4,  // �
	0x8F00, KANJI_LEVEL4,  // 輀
	0x8F08, KANJI_LEVEL4,  // 輈
	0x8F17, KANJI_LEVEL4,  // 輗
	0x8F2B, KANJI_LEVEL4,  // 輫
	0x8F40, KANJI_LEVEL4,  // 轀
	0x8F4A, KANJI_LEVEL4,  // 轊
	0x8F58, KANJI_LEVEL4,  // 轘
	0xD861, KANJI_LEVEL4,  // �
	0xDC0C, KANJI_LEVEL4,  // �
	0x8FA4, KANJI_LEVEL4,  // 辤
	0x8FB4, KANJI_LEVEL4,  // 辴
	0xFA66, KANJI_LEVEL4,  // 辶
	0x8FB6, KANJI_LEVEL4,  // 辶
	0xD861, KANJI_LEVEL4,  // �
	0xDC55, KANJI_LEVEL4,  // �
	0x8FC1, KANJI_LEVEL4,  // 迁
	0x8FC6, KANJI_LEVEL4,  // 迆
	0xFA24, KANJI_LEVEL4,  // 﨤
	0x8FCA, KANJI_LEVEL4,  // 迊
	0x8FCD, KANJI_LEVEL4,  // 迍
	0x8FD3, KANJI_LEVEL4,  // 迓
	0x8FD5, KANJI_LEVEL4,  // 迕
	0x8FE0, KANJI_LEVEL4,  // 迠
	0x8FF1, KANJI_LEVEL4,  // 迱
	0x8FF5, KANJI_LEVEL4,  // 迵
	0x8FFB, KANJI_LEVEL4,  // 迻
	0x9002, KANJI_LEVEL4,  // 适
	0x900C, KANJI_LEVEL4,  // 逌
	0x9037, KANJI_LEVEL4,  // 逷
	0xD861, KANJI_LEVEL4,  // �
	0xDD6B, KANJI_LEVEL4,  // �
	0x9043, KANJI_LEVEL4,  // 遃
	0x9044, KANJI_LEVEL4,  // 遄
	0x905D, KANJI_LEVEL4,  // 遝
	0xD861, KANJI_LEVEL4,  // �
	0xDDC8, KANJI_LEVEL4,  // �
	0xD861, KANJI_LEVEL4,  // �
	0xDDC9, KANJI_LEVEL4,  // �
	0x9085, KANJI_LEVEL4,  // 邅
	0x908C, KANJI_LEVEL4,  // 邌
	0x9090, KANJI_LEVEL4,  // 邐
	0x961D, KANJI_LEVEL4,  // 阝
	0x90A1, KANJI_LEVEL4,  // 邡
	0x48B5, KANJI_LEVEL4,  // 䢵
	0x90B0, KANJI_LEVEL4,  // 邰
	0x90B6, KANJI_LEVEL4,  // 邶
	0x90C3, KANJI_LEVEL4,  // 郃
	0x90C8, KANJI_LEVEL4,  // 郈
	0xD861, KANJI_LEVEL4,  // �
	0xDED7, KANJI_LEVEL4,  // �
	0x90DC, KANJI_LEVEL4,  // 郜
	0x90DF, KANJI_LEVEL4,  // 郟
	0xD861, KANJI_LEVEL4,  // �
	0xDEFA, KANJI_LEVEL4,  // �
	0x90F6, KANJI_LEVEL4,  // 郶
	0x90F2, KANJI_LEVEL4,  // 郲
	0x9100, KANJI_LEVEL4,  // 鄀
	0x90EB, KANJI_LEVEL4,  // 郫
	0x90FE, KANJI_LEVEL4,  // 郾
	0x90FF, KANJI_LEVEL4,  // 郿
	0x9104, KANJI_LEVEL4,  // 鄄
	0x9106, KANJI_LEVEL4,  // 鄆
	0x9118, KANJI_LEVEL4,  // 鄘
	0x911C, KANJI_LEVEL4,  // 鄜
	0x911E, KANJI_LEVEL4,  // 鄞
	0x9137, KANJI_LEVEL4,  // 鄷
	0x9139, KANJI_LEVEL4,  // 鄹
	0x913A, KANJI_LEVEL4,  // 鄺
	0x9146, KANJI_LEVEL4,  // 酆
	0x9147, KANJI_LEVEL4,  // 酇
	0x9157, KANJI_LEVEL4,  // 酗
	0x9159, KANJI_LEVEL4,  // 酙
	0x9161, KANJI_LEVEL4,  // 酡
	0x9164, KANJI_LEVEL4,  // 酤
	0x9174, KANJI_LEVEL4,  // 酴
	0x9179, KANJI_LEVEL4,  // 酹
	0x9185, KANJI_LEVEL4,  // 醅
	0x918E, KANJI_LEVEL4,  // 醎
	0x91A8, KANJI_LEVEL4,  // 醨
	0x91AE, KANJI_LEVEL4,  // 醮
	0x91B3, KANJI_LEVEL4,  // 醳
	0x91B6, KANJI_LEVEL4,  // 醶
	0x91C3, KANJI_LEVEL4,  // 釃
	0x91C4, KANJI_LEVEL4,  // 釄
	0x91DA, KANJI_LEVEL4,  // 釚
	0xD862, KANJI_LEVEL4,  // �
	0xDD49, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDD46, KANJI_LEVEL4,  // �
	0x91EC, KANJI_LEVEL4,  // 釬
	0x91EE, KANJI_LEVEL4,  // 釮
	0x9201, KANJI_LEVEL4,  // 鈁
	0x920A, KANJI_LEVEL4,  // 鈊
	0x9216, KANJI_LEVEL4,  // 鈖
	0x9217, KANJI_LEVEL4,  // 鈗
	0xD862, KANJI_LEVEL4,  // �
	0xDD6B, KANJI_LEVEL4,  // �
	0x9233, KANJI_LEVEL4,  // 鈳
	0x9242, KANJI_LEVEL4,  // 鉂
	0x9247, KANJI_LEVEL4,  // 鉇
	0x924A, KANJI_LEVEL4,  // 鉊
	0x924E, KANJI_LEVEL4,  // 鉎
	0x9251, KANJI_LEVEL4,  // 鉑
	0x9256, KANJI_LEVEL4,  // 鉖
	0x9259, KANJI_LEVEL4,  // 鉙
	0x9260, KANJI_LEVEL4,  // 鉠
	0x9261, KANJI_LEVEL4,  // 鉡
	0x9265, KANJI_LEVEL4,  // 鉥
	0x9267, KANJI_LEVEL4,  // 鉧
	0x9268, KANJI_LEVEL4,  // 鉨
	0xD862, KANJI_LEVEL4,  // �
	0xDD87, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDD88, KANJI_LEVEL4,  // �
	0x927C, KANJI_LEVEL4,  // 鉼
	0x927D, KANJI_LEVEL4,  // 鉽
	0x927F, KANJI_LEVEL4,  // 鉿
	0x9289, KANJI_LEVEL4,  // 銉
	0x928D, KANJI_LEVEL4,  // 銍
	0x9297, KANJI_LEVEL4,  // 銗
	0x9299, KANJI_LEVEL4,  // 銙
	0x929F, KANJI_LEVEL4,  // 銟
	0x92A7, KANJI_LEVEL4,  // 銧
	0x92AB, KANJI_LEVEL4,  // 銫
	0xD862, KANJI_LEVEL4,  // �
	0xDDBA, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDDBB, KANJI_LEVEL4,  // �
	0x92B2, KANJI_LEVEL4,  // 銲
	0x92BF, KANJI_LEVEL4,  // 銿
	0x92C0, KANJI_LEVEL4,  // 鋀
	0x92C6, KANJI_LEVEL4,  // 鋆
	0x92CE, KANJI_LEVEL4,  // 鋎
	0x92D0, KANJI_LEVEL4,  // 鋐
	0x92D7, KANJI_LEVEL4,  // 鋗
	0x92D9, KANJI_LEVEL4,  // 鋙
	0x92E5, KANJI_LEVEL4,  // 鋥
	0x92E7, KANJI_LEVEL4,  // 鋧
	0x9311, KANJI_LEVEL4,  // 錑
	0xD862, KANJI_LEVEL4,  // �
	0xDE1E, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDE29, KANJI_LEVEL4,  // �
	0x92F7, KANJI_LEVEL4,  // 鋷
	0x92F9, KANJI_LEVEL4,  // 鋹
	0x92FB, KANJI_LEVEL4,  // 鋻
	0x9302, KANJI_LEVEL4,  // 錂
	0x930D, KANJI_LEVEL4,  // 錍
	0x9315, KANJI_LEVEL4,  // 錕
	0x931D, KANJI_LEVEL4,  // 錝
	0x931E, KANJI_LEVEL4,  // 錞
	0x9327, KANJI_LEVEL4,  // 錧
	0x9329, KANJI_LEVEL4,  // 錩
	0xD862, KANJI_LEVEL4,  // �
	0xDE71, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDE43, KANJI_LEVEL4,  // �
	0x9347, KANJI_LEVEL4,  // 鍇
	0x9351, KANJI_LEVEL4,  // 鍑
	0x9357, KANJI_LEVEL4,  // 鍗
	0x935A, KANJI_LEVEL4,  // 鍚
	0x936B, KANJI_LEVEL4,  // 鍫
	0x9371, KANJI_LEVEL4,  // 鍱
	0x9373, KANJI_LEVEL4,  // 鍳
	0x93A1, KANJI_LEVEL4,  // 鎡
	0xD862, KANJI_LEVEL4,  // �
	0xDE99, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDECD, KANJI_LEVEL4,  // �
	0x9388, KANJI_LEVEL4,  // 鎈
	0x938B, KANJI_LEVEL4,  // 鎋
	0x938F, KANJI_LEVEL4,  // 鎏
	0x939E, KANJI_LEVEL4,  // 鎞
	0x93F5, KANJI_LEVEL4,  // 鏵
	0xD862, KANJI_LEVEL4,  // �
	0xDEE4, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDEDD, KANJI_LEVEL4,  // �
	0x93F1, KANJI_LEVEL4,  // 鏱
	0x93C1, KANJI_LEVEL4,  // 鏁
	0x93C7, KANJI_LEVEL4,  // 鏇
	0x93DC, KANJI_LEVEL4,  // 鏜
	0x93E2, KANJI_LEVEL4,  // 鏢
	0x93E7, KANJI_LEVEL4,  // 鏧
	0x9409, KANJI_LEVEL4,  // 鐉
	0x940F, KANJI_LEVEL4,  // 鐏
	0x9416, KANJI_LEVEL4,  // 鐖
	0x9417, KANJI_LEVEL4,  // 鐗
	0x93FB, KANJI_LEVEL4,  // 鏻
	0x9432, KANJI_LEVEL4,  // 鐲
	0x9434, KANJI_LEVEL4,  // 鐴
	0x943B, KANJI_LEVEL4,  // 鐻
	0x9445, KANJI_LEVEL4,  // 鑅
	0xD862, KANJI_LEVEL4,  // �
	0xDFC1, KANJI_LEVEL4,  // �
	0xD862, KANJI_LEVEL4,  // �
	0xDFEF, KANJI_LEVEL4,  // �
	0x946D, KANJI_LEVEL4,  // 鑭
	0x946F, KANJI_LEVEL4,  // 鑯
	0x9578, KANJI_LEVEL4,  // 镸
	0x9579, KANJI_LEVEL4,  // 镹
	0x9586, KANJI_LEVEL4,  // 閆
	0x958C, KANJI_LEVEL4,  // 閌
	0x958D, KANJI_LEVEL4,  // 閍
	0xD863, KANJI_LEVEL4,  // �
	0xDD10, KANJI_LEVEL4,  // �
	0x95AB, KANJI_LEVEL4,  // 閫
	0x95B4, KANJI_LEVEL4,  // 閴
	0xD863, KANJI_LEVEL4,  // �
	0xDD71, KANJI_LEVEL4,  // �
	0x95C8, KANJI_LEVEL4,  // 闈
	0xD863, KANJI_LEVEL4,  // �
	0xDDFB, KANJI_LEVEL4,  // �
	0xD863, KANJI_LEVEL4,  // �
	0xDE1F, KANJI_LEVEL4,  // �
	0x962C, KANJI_LEVEL4,  // 阬
	0x9633, KANJI_LEVEL4,  // 阳
	0x9634, KANJI_LEVEL4,  // 阴
	0xD863, KANJI_LEVEL4,  // �
	0xDE36, KANJI_LEVEL4,  // �
	0x963C, KANJI_LEVEL4,  // 阼
	0x9641, KANJI_LEVEL4,  // 陁
	0x9661, KANJI_LEVEL4,  // 陡
	0xD863, KANJI_LEVEL4,  // �
	0xDE89, KANJI_LEVEL4,  // �
	0x9682, KANJI_LEVEL4,  // 隂
	0xD863, KANJI_LEVEL4,  // �
	0xDEEB, KANJI_LEVEL4,  // �
	0x969A, KANJI_LEVEL4,  // 隚
	0xD863, KANJI_LEVEL4,  // �
	0xDF32, KANJI_LEVEL4,  // �
	0x49E7, KANJI_LEVEL4,  // 䧧
	0x96A9, KANJI_LEVEL4,  // 隩
	0x96AF, KANJI_LEVEL4,  // 隯
	0x96B3, KANJI_LEVEL4,  // 隳
	0x96BA, KANJI_LEVEL4,  // 隺
	0x96BD, KANJI_LEVEL4,  // 隽
	0x49FA, KANJI_LEVEL4,  // 䧺
	0xD863, KANJI_LEVEL4,  // �
	0xDFF8, KANJI_LEVEL4,  // �
	0x96D8, KANJI_LEVEL4,  // 雘
	0x96DA, KANJI_LEVEL4,  // 雚
	0x96DD, KANJI_LEVEL4,  // 雝
	0x4A04, KANJI_LEVEL4,  // 䨄
	0x9714, KANJI_LEVEL4,  // 霔
	0x9723, KANJI_LEVEL4,  // 霣
	0x4A29, KANJI_LEVEL4,  // 䨩
	0x9736, KANJI_LEVEL4,  // 霶
	0x9741, KANJI_LEVEL4,  // 靁
	0x9747, KANJI_LEVEL4,  // 靇
	0x9755, KANJI_LEVEL4,  // 靕
	0x9757, KANJI_LEVEL4,  // 靗
	0x975B, KANJI_LEVEL4,  // 靛
	0x976A, KANJI_LEVEL4,  // 靪
	0xD864, KANJI_LEVEL4,  // �
	0xDEA0, KANJI_LEVEL4,  // �
	0xD864, KANJI_LEVEL4,  // �
	0xDEB1, KANJI_LEVEL4,  // �
	0x9796, KANJI_LEVEL4,  // 鞖
	0x979A, KANJI_LEVEL4,  // 鞚
	0x979E, KANJI_LEVEL4,  // 鞞
	0x97A2, KANJI_LEVEL4,  // 鞢
	0x97B1, KANJI_LEVEL4,  // 鞱
	0x97B2, KANJI_LEVEL4,  // 鞲
	0x97BE, KANJI_LEVEL4,  // 鞾
	0x97CC, KANJI_LEVEL4,  // 韌
	0x97D1, KANJI_LEVEL4,  // 韑
	0x97D4, KANJI_LEVEL4,  // 韔
	0x97D8, KANJI_LEVEL4,  // 韘
	0x97D9, KANJI_LEVEL4,  // 韙
	0x97E1, KANJI_LEVEL4,  // 韡
	0x97F1, KANJI_LEVEL4,  // 韱
	0x9804, KANJI_LEVEL4,  // 頄
	0x980D, KANJI_LEVEL4,  // 頍
	0x980E, KANJI_LEVEL4,  // 頎
	0x9814, KANJI_LEVEL4,  // 頔
	0x9816, KANJI_LEVEL4,  // 頖
	0x4ABC, KANJI_LEVEL4,  // 䪼
	0xD865, KANJI_LEVEL4,  // �
	0xDC90, KANJI_LEVEL4,  // �
	0x9823, KANJI_LEVEL4,  // 頣
	0x9832, KANJI_LEVEL4,  // 頲
	0x9833, KANJI_LEVEL4,  // 頳
	0x9825, KANJI_LEVEL4,  // 頥
	0x9847, KANJI_LEVEL4,  // 顇
	0x9866, KANJI_LEVEL4,  // 顦
	0x98AB, KANJI_LEVEL4,  // 颫
	0x98AD, KANJI_LEVEL4,  // 颭
	0x98B0, KANJI_LEVEL4,  // 颰
	0xD865, KANJI_LEVEL4,  // �
	0xDDCF, KANJI_LEVEL4,  // �
	0x98B7, KANJI_LEVEL4,  // 颷
	0x98B8, KANJI_LEVEL4,  // 颸
	0x98BB, KANJI_LEVEL4,  // 颻
	0x98BC, KANJI_LEVEL4,  // 颼
	0x98BF, KANJI_LEVEL4,  // 颿
	0x98C2, KANJI_LEVEL4,  // 飂
	0x98C7, KANJI_LEVEL4,  // 飇
	0x98CB, KANJI_LEVEL4,  // 飋
	0x98E0, KANJI_LEVEL4,  // 飠
	0xD865, KANJI_LEVEL4,  // �
	0xDE7F, KANJI_LEVEL4,  // �
	0x98E1, KANJI_LEVEL4,  // 飡
	0x98E3, KANJI_LEVEL4,  // 飣
	0x98E5, KANJI_LEVEL4,  // 飥
	0x98EA, KANJI_LEVEL4,  // 飪
	0x98F0, KANJI_LEVEL4,  // 飰
	0x98F1, KANJI_LEVEL4,  // 飱
	0x98F3, KANJI_LEVEL4,  // 飳
	0x9908, KANJI_LEVEL4,  // 餈
	0x4B3B, KANJI_LEVEL4,  // 䬻
	0xD865, KANJI_LEVEL4,  // �
	0xDEF0, KANJI_LEVEL4,  // �
	0x9916, KANJI_LEVEL4,  // 餖
	0x9917, KANJI_LEVEL4,  // 餗
	0xD865, KANJI_LEVEL4,  // �
	0xDF19, KANJI_LEVEL4,  // �
	0x991A, KANJI_LEVEL4,  // 餚
	0x991B, KANJI_LEVEL4,  // 餛
	0x991C, KANJI_LEVEL4,  // 餜
	0xD865, KANJI_LEVEL4,  // �
	0xDF50, KANJI_LEVEL4,  // �
	0x9931, KANJI_LEVEL4,  // 餱
	0x9932, KANJI_LEVEL4,  // 餲
	0x9933, KANJI_LEVEL4,  // 餳
	0x993A, KANJI_LEVEL4,  // 餺
	0x993B, KANJI_LEVEL4,  // 餻
	0x993C, KANJI_LEVEL4,  // 餼
	0x9940, KANJI_LEVEL4,  // 饀
	0x9941, KANJI_LEVEL4,  // 饁
	0x9946, KANJI_LEVEL4,  // 饆
	0x994D, KANJI_LEVEL4,  // 饍
	0x994E, KANJI_LEVEL4,  // 饎
	0x995C, KANJI_LEVEL4,  // 饜
	0x995F, KANJI_LEVEL4,  // 饟
	0x9960, KANJI_LEVEL4,  // 饠
	0x99A3, KANJI_LEVEL4,  // 馣
	0x99A6, KANJI_LEVEL4,  // 馦
	0x99B9, KANJI_LEVEL4,  // 馹
	0x99BD, KANJI_LEVEL4,  // 馽
	0x99BF, KANJI_LEVEL4,  // 馿
	0x99C3, KANJI_LEVEL4,  // 駃
	0x99C9, KANJI_LEVEL4,  // 駉
	0x99D4, KANJI_LEVEL4,  // 駔
	0x99D9, KANJI_LEVEL4,  // 駙
	0x99DE, KANJI_LEVEL4,  // 駞
	0xD866, KANJI_LEVEL4,  // �
	0xDCC6, KANJI_LEVEL4,  // �
	0x99F0, KANJI_LEVEL4,  // 駰
	0x99F9, KANJI_LEVEL4,  // 駹
	0x99FC, KANJI_LEVEL4,  // 駼
	0x9A0A, KANJI_LEVEL4,  // 騊
	0x9A11, KANJI_LEVEL4,  // 騑
	0x9A16, KANJI_LEVEL4,  // 騖
	0x9A1A, KANJI_LEVEL4,  // 騚
	0x9A20, KANJI_LEVEL4,  // 騠
	0x9A31, KANJI_LEVEL4,  // 騱
	0x9A36, KANJI_LEVEL4,  // 騶
	0x9A44, KANJI_LEVEL4,  // 驄
	0x9A4C, KANJI_LEVEL4,  // 驌
	0x9A58, KANJI_LEVEL4,  // 驘
	0x4BC2, KANJI_LEVEL4,  // 䯂
	0x9AAF, KANJI_LEVEL4,  // 骯
	0x4BCA, KANJI_LEVEL4,  // 䯊
	0x9AB7, KANJI_LEVEL4,  // 骷
	0x4BD2, KANJI_LEVEL4,  // 䯒
	0x9AB9, KANJI_LEVEL4,  // 骹
	0xD866, KANJI_LEVEL4,  // �
	0xDE72, KANJI_LEVEL4,  // �
	0x9AC6, KANJI_LEVEL4,  // 髆
	0x9AD0, KANJI_LEVEL4,  // 髐
	0x9AD2, KANJI_LEVEL4,  // 髒
	0x9AD5, KANJI_LEVEL4,  // 髕
	0x4BE8, KANJI_LEVEL4,  // 䯨
	0x9ADC, KANJI_LEVEL4,  // 髜
	0x9AE0, KANJI_LEVEL4,  // 髠
	0x9AE5, KANJI_LEVEL4,  // 髥
	0x9AE9, KANJI_LEVEL4,  // 髩
	0x9B03, KANJI_LEVEL4,  // 鬃
	0x9B0C, KANJI_LEVEL4,  // 鬌
	0x9B10, KANJI_LEVEL4,  // 鬐
	0x9B12, KANJI_LEVEL4,  // 鬒
	0x9B16, KANJI_LEVEL4,  // 鬖
	0x9B1C, KANJI_LEVEL4,  // 鬜
	0x9B2B, KANJI_LEVEL4,  // 鬫
	0x9B33, KANJI_LEVEL4,  // 鬳
	0x9B3D, KANJI_LEVEL4,  // 鬽
	0x4C20, KANJI_LEVEL4,  // 䰠
	0x9B4B, KANJI_LEVEL4,  // 魋
	0x9B63, KANJI_LEVEL4,  // 魣
	0x9B65, KANJI_LEVEL4,  // 魥
	0x9B6B, KANJI_LEVEL4,  // 魫
	0x9B6C, KANJI_LEVEL4,  // 魬
	0x9B73, KANJI_LEVEL4,  // 魳
	0x9B76, KANJI_LEVEL4,  // 魶
	0x9B77, KANJI_LEVEL4,  // 魷
	0x9BA6, KANJI_LEVEL4,  // 鮦
	0x9BAC, KANJI_LEVEL4,  // 鮬
	0x9BB1, KANJI_LEVEL4,  // 鮱
	0xD867, KANJI_LEVEL4,  // �
	0xDDDB, KANJI_LEVEL4,  // �
	0xD867, KANJI_LEVEL4,  // �
	0xDE3D, KANJI_LEVEL4,  // �
	0x9BB2, KANJI_LEVEL4,  // 鮲
	0x9BB8, KANJI_LEVEL4,  // 鮸
	0x9BBE, KANJI_LEVEL4,  // 鮾
	0x9BC7, KANJI_LEVEL4,  // 鯇
	0x9BF3, KANJI_LEVEL4,  // 鯳
	0x9BD8, KANJI_LEVEL4,  // 鯘
	0x9BDD, KANJI_LEVEL4,  // 鯝
	0x9BE7, KANJI_LEVEL4,  // 鯧
	0x9BEA, KANJI_LEVEL4,  // 鯪
	0x9BEB, KANJI_LEVEL4,  // 鯫
	0x9BEF, KANJI_LEVEL4,  // 鯯
	0x9BEE, KANJI_LEVEL4,  // 鯮
	0xD867, KANJI_LEVEL4,  // �
	0xDE15, KANJI_LEVEL4,  // �
	0x9BFA, KANJI_LEVEL4,  // 鯺
	0xD867, KANJI_LEVEL4,  // �
	0xDE8A, KANJI_LEVEL4,  // �
	0x9BF7, KANJI_LEVEL4,  // 鯷
	0xD867, KANJI_LEVEL4,  // �
	0xDE49, KANJI_LEVEL4,  // �
	0x9C16, KANJI_LEVEL4,  // 鰖
	0x9C18, KANJI_LEVEL4,  // 鰘
	0x9C19, KANJI_LEVEL4,  // 鰙
	0x9C1A, KANJI_LEVEL4,  // 鰚
	0x9C1D, KANJI_LEVEL4,  // 鰝
	0x9C22, KANJI_LEVEL4,  // 鰢
	0x9C27, KANJI_LEVEL4,  // 鰧
	0x9C29, KANJI_LEVEL4,  // 鰩
	0x9C2A, KANJI_LEVEL4,  // 鰪
	0xD867, KANJI_LEVEL4,  // �
	0xDEC4, KANJI_LEVEL4,  // �
	0x9C31, KANJI_LEVEL4,  // 鰱
	0x9C36, KANJI_LEVEL4,  // 鰶
	0x9C37, KANJI_LEVEL4,  // 鰷
	0x9C45, KANJI_LEVEL4,  // 鱅
	0x9C5C, KANJI_LEVEL4,  // 鱜
	0xD867, KANJI_LEVEL4,  // �
	0xDEE9, KANJI_LEVEL4,  // �
	0x9C49, KANJI_LEVEL4,  // 鱉
	0x9C4A, KANJI_LEVEL4,  // 鱊
	0xD867, KANJI_LEVEL4,  // �
	0xDEDB, KANJI_LEVEL4,  // �
	0x9C54, KANJI_LEVEL4,  // 鱔
	0x9C58, KANJI_LEVEL4,  // 鱘
	0x9C5B, KANJI_LEVEL4,  // 鱛
	0x9C5D, KANJI_LEVEL4,  // 鱝
	0x9C5F, KANJI_LEVEL4,  // 鱟
	0x9C69, KANJI_LEVEL4,  // 鱩
	0x9C6A, KANJI_LEVEL4,  // 鱪
	0x9C6B, KANJI_LEVEL4,  // 鱫
	0x9C6D, KANJI_LEVEL4,  // 鱭
	0x9C6E, KANJI_LEVEL4,  // 鱮
	0x9C70, KANJI_LEVEL4,  // 鱰
	0x9C72, KANJI_LEVEL4,  // 鱲
	0x9C75, KANJI_LEVEL4,  // 鱵
	0x9C7A, KANJI_LEVEL4,  // 鱺
	0x9CE6, KANJI_LEVEL4,  // 鳦
	0x9CF2, KANJI_LEVEL4,  // 鳲
	0x9D0B, KANJI_LEVEL4,  // 鴋
	0x9D02, KANJI_LEVEL4,  // 鴂
	0xD867, KANJI_LEVEL4,  // �
	0xDFCE, KANJI_LEVEL4,  // �
	0x9D11, KANJI_LEVEL4,  // 鴑
	0x9D17, KANJI_LEVEL4,  // 鴗
	0x9D18, KANJI_LEVEL4,  // 鴘
	0xD868, KANJI_LEVEL4,  // �
	0xDC2F, KANJI_LEVEL4,  // �
	0x4CC4, KANJI_LEVEL4,  // 䳄
	0xD868, KANJI_LEVEL4,  // �
	0xDC1A, KANJI_LEVEL4,  // �
	0x9D32, KANJI_LEVEL4,  // 鴲
	0x4CD1, KANJI_LEVEL4,  // 䳑
	0x9D42, KANJI_LEVEL4,  // 鵂
	0x9D4A, KANJI_LEVEL4,  // 鵊
	0x9D5F, KANJI_LEVEL4,  // 鵟
	0x9D62, KANJI_LEVEL4,  // 鵢
	0xD868, KANJI_LEVEL4,  // �
	0xDCF9, KANJI_LEVEL4,  // �
	0x9D69, KANJI_LEVEL4,  // 鵩
	0x9D6B, KANJI_LEVEL4,  // 鵫
	0xD868, KANJI_LEVEL4,  // �
	0xDC82, KANJI_LEVEL4,  // �
	0x9D73, KANJI_LEVEL4,  // 鵳
	0x9D76, KANJI_LEVEL4,  // 鵶
	0x9D77, KANJI_LEVEL4,  // 鵷
	0x9D7E, KANJI_LEVEL4,  // 鵾
	0x9D84, KANJI_LEVEL4,  // 鶄
	0x9D8D, KANJI_LEVEL4,  // 鶍
	0x9D99, KANJI_LEVEL4,  // 鶙
	0x9DA1, KANJI_LEVEL4,  // 鶡
	0x9DBF, KANJI_LEVEL4,  // 鶿
	0x9DB5, KANJI_LEVEL4,  // 鶵
	0x9DB9, KANJI_LEVEL4,  // 鶹
	0x9DBD, KANJI_LEVEL4,  // 鶽
	0x9DC3, KANJI_LEVEL4,  // 鷃
	0x9DC7, KANJI_LEVEL4,  // 鷇
	0x9DC9, KANJI_LEVEL4,  // 鷉
	0x9DD6, KANJI_LEVEL4,  // 鷖
	0x9DDA, KANJI_LEVEL4,  // 鷚
	0x9DDF, KANJI_LEVEL4,  // 鷟
	0x9DE0, KANJI_LEVEL4,  // 鷠
	0x9DE3, KANJI_LEVEL4,  // 鷣
	0x9DF4, KANJI_LEVEL4,  // 鷴
	0x4D07, KANJI_LEVEL4,  // 䴇
	0x9E0A, KANJI_LEVEL4,  // 鸊
	0x9E02, KANJI_LEVEL4,  // 鸂
	0x9E0D, KANJI_LEVEL4,  // 鸍
	0x9E19, KANJI_LEVEL4,  // 鸙
	0x9E1C, KANJI_LEVEL4,  // 鸜
	0x9E1D, KANJI_LEVEL4,  // 鸝
	0x9E7B, KANJI_LEVEL4,  // 鹻
	0xD848, KANJI_LEVEL4,  // �
	0xDE18, KANJI_LEVEL4,  // �
	0x9E80, KANJI_LEVEL4,  // 麀
	0x9E85, KANJI_LEVEL4,  // 麅
	0x9E9B, KANJI_LEVEL4,  // 麛
	0x9EA8, KANJI_LEVEL4,  // 麨
	0xD868, KANJI_LEVEL4,  // �
	0xDF8C, KANJI_LEVEL4,  // �
	0x9EBD, KANJI_LEVEL4,  // 麽
	0xD869, KANJI_LEVEL4,  // �
	0xDC37, KANJI_LEVEL4,  // �
	0x9EDF, KANJI_LEVEL4,  // 黟
	0x9EE7, KANJI_LEVEL4,  // 黧
	0x9EEE, KANJI_LEVEL4,  // 黮
	0x9EFF, KANJI_LEVEL4,  // 黿
	0x9F02, KANJI_LEVEL4,  // 鼂
	0x4D77, KANJI_LEVEL4,  // 䵷
	0x9F03, KANJI_LEVEL4,  // 鼃
	0x9F17, KANJI_LEVEL4,  // 鼗
	0x9F19, KANJI_LEVEL4,  // 鼙
	0x9F2F, KANJI_LEVEL4,  // 鼯
	0x9F37, KANJI_LEVEL4,  // 鼷
	0x9F3A, KANJI_LEVEL4,  // 鼺
	0x9F3D, KANJI_LEVEL4,  // 鼽
	0x9F41, KANJI_LEVEL4,  // 齁
	0x9F45, KANJI_LEVEL4,  // 齅
	0x9F46, KANJI_LEVEL4,  // 齆
	0x9F53, KANJI_LEVEL4,  // 齓
	0x9F55, KANJI_LEVEL4,  // 齕
	0x9F58, KANJI_LEVEL4,  // 齘
	0xD869, KANJI_LEVEL4,  // �
	0xDDF1, KANJI_LEVEL4,  // �
	0x9F5D, KANJI_LEVEL4,  // 齝
	0xD869, KANJI_LEVEL4,  // �
	0xDE02, KANJI_LEVEL4,  // �
	0x9F69, KANJI_LEVEL4,  // 齩
	0xD869, KANJI_LEVEL4,  // �
	0xDE1A, KANJI_LEVEL4,  // �
	0x9F6D, KANJI_LEVEL4,  // 齭
	0x9F70, KANJI_LEVEL4,  // 齰
	0x9F75, KANJI_LEVEL4,  // 齵
	0xD869, KANJI_LEVEL4,  // �
	0xDEB2, KANJI_LEVEL4,  // �
	0x4E9C, KANJI_SJIS_L1,  // 亜
	0x5516, KANJI_SJIS_L1,  // 唖
	0x5A03, KANJI_SJIS_L1,  // 娃
	0x963F, KANJI_SJIS_L1,  // 阿
	0x54C0, KANJI_SJIS_L1,  // 哀
	0x611B, KANJI_SJIS_L1,  // 愛
	0x6328, KANJI_SJIS_L1,  // 挨
	0x59F6, KANJI_SJIS_L1,  // 姶
	0x9022, KANJI_SJIS_L1,  // 逢
	0x8475, KANJI_SJIS_L1,  // 葵
	0x831C, KANJI_SJIS_L1,  // 茜
	0x7A50, KANJI_SJIS_L1,  // 穐
	0x60AA, KANJI_SJIS_L1,  // 悪
	0x63E1, KANJI_SJIS_L1,  // 握
	0x6E25, KANJI_SJIS_L1,  // 渥
	0x65ED, KANJI_SJIS_L1,  // 旭
	0x8466, KANJI_SJIS_L1,  // 葦
	0x82A6, KANJI_SJIS_L1,  // 芦
	0x9BF5, KANJI_SJIS_L1,  // 鯵
	0x6893, KANJI_SJIS_L1,  // 梓
	0x5727, KANJI_SJIS_L1,  // 圧
	0x65A1, KANJI_SJIS_L1,  // 斡
	0x6271, KANJI_SJIS_L1,  // 扱
	0x5B9B, KANJI_SJIS_L1,  // 宛
	0x59D0, KANJI_SJIS_L1,  // 姐
	0x867B, KANJI_SJIS_L1,  // 虻
	0x98F4, KANJI_SJIS_L1,  // 飴
	0x7D62, KANJI_SJIS_L1,  // 絢
	0x7DBE, KANJI_SJIS_L1,  // 綾
	0x9B8E, KANJI_SJIS_L1,  // 鮎
	0x6216, KANJI_SJIS_L1,  // 或
	0x7C9F, KANJI_SJIS_L1,  // 粟
	0x88B7, KANJI_SJIS_L1,  // 袷
	0x5B89, KANJI_SJIS_L1,  // 安
	0x5EB5, KANJI_SJIS_L1,  // 庵
	0x6309, KANJI_SJIS_L1,  // 按
	0x6697, KANJI_SJIS_L1,  // 暗
	0x6848, KANJI_SJIS_L1,  // 案
	0x95C7, KANJI_SJIS_L1,  // 闇
	0x978D, KANJI_SJIS_L1,  // 鞍
	0x674F, KANJI_SJIS_L1,  // 杏
	0x4EE5, KANJI_SJIS_L1,  // 以
	0x4F0A, KANJI_SJIS_L1,  // 伊
	0x4F4D, KANJI_SJIS_L1,  // 位
	0x4F9D, KANJI_SJIS_L1,  // 依
	0x5049, KANJI_SJIS_L1,  // 偉
	0x56F2, KANJI_SJIS_L1,  // 囲
	0x5937, KANJI_SJIS_L1,  // 夷
	0x59D4, KANJI_SJIS_L1,  // 委
	0x5A01, KANJI_SJIS_L1,  // 威
	0x5C09, KANJI_SJIS_L1,  // 尉
	0x60DF, KANJI_SJIS_L1,  // 惟
	0x610F, KANJI_SJIS_L1,  // 意
	0x6170, KANJI_SJIS_L1,  // 慰
	0x6613, KANJI_SJIS_L1,  // 易
	0x6905, KANJI_SJIS_L1,  // 椅
	0x70BA, KANJI_SJIS_L1,  // 為
	0x754F, KANJI_SJIS_L1,  // 畏
	0x7570, KANJI_SJIS_L1,  // 異
	0x79FB, KANJI_SJIS_L1,  // 移
	0x7DAD, KANJI_SJIS_L1,  // 維
	0x7DEF, KANJI_SJIS_L1,  // 緯
	0x80C3, KANJI_SJIS_L1,  // 胃
	0x840E, KANJI_SJIS_L1,  // 萎
	0x8863, KANJI_SJIS_L1,  // 衣
	0x8B02, KANJI_SJIS_L1,  // 謂
	0x9055, KANJI_SJIS_L1,  // 違
	0x907A, KANJI_SJIS_L1,  // 遺
	0x533B, KANJI_SJIS_L1,  // 医
	0x4E95, KANJI_SJIS_L1,  // 井
	0x4EA5, KANJI_SJIS_L1,  // 亥
	0x57DF, KANJI_SJIS_L1,  // 域
	0x80B2, KANJI_SJIS_L1,  // 育
	0x90C1, KANJI_SJIS_L1,  // 郁
	0x78EF, KANJI_SJIS_L1,  // 磯
	0x4E00, KANJI_SJIS_L1,  // 一
	0x58F1, KANJI_SJIS_L1,  // 壱
	0x6EA2, KANJI_SJIS_L1,  // 溢
	0x9038, KANJI_SJIS_L1,  // 逸
	0x7A32, KANJI_SJIS_L1,  // 稲
	0x8328, KANJI_SJIS_L1,  // 茨
	0x828B, KANJI_SJIS_L1,  // 芋
	0x9C2F, KANJI_SJIS_L1,  // 鰯
	0x5141, KANJI_SJIS_L1,  // 允
	0x5370, KANJI_SJIS_L1,  // 印
	0x54BD, KANJI_SJIS_L1,  // 咽
	0x54E1, KANJI_SJIS_L1,  // 員
	0x56E0, KANJI_SJIS_L1,  // 因
	0x59FB, KANJI_SJIS_L1,  // 姻
	0x5F15, KANJI_SJIS_L1,  // 引
	0x98F2, KANJI_SJIS_L1,  // 飲
	0x6DEB, KANJI_SJIS_L1,  // 淫
	0x80E4, KANJI_SJIS_L1,  // 胤
	0x852D, KANJI_SJIS_L1,  // 蔭
	0x9662, KANJI_SJIS_L1,  // 院
	0x9670, KANJI_SJIS_L1,  // 陰
	0x96A0, KANJI_SJIS_L1,  // 隠
	0x97FB, KANJI_SJIS_L1,  // 韻
	0x540B, KANJI_SJIS_L1,  // 吋
	0x53F3, KANJI_SJIS_L1,  // 右
	0x5B87, KANJI_SJIS_L1,  // 宇
	0x70CF, KANJI_SJIS_L1,  // 烏
	0x7FBD, KANJI_SJIS_L1,  // 羽
	0x8FC2, KANJI_SJIS_L1,  // 迂
	0x96E8, KANJI_SJIS_L1,  // 雨
	0x536F, KANJI_SJIS_L1,  // 卯
	0x9D5C, KANJI_SJIS_L1,  // 鵜
	0x7ABA, KANJI_SJIS_L1,  // 窺
	0x4E11, KANJI_SJIS_L1,  // 丑
	0x7893, KANJI_SJIS_L1,  // 碓
	0x81FC, KANJI_SJIS_L1,  // 臼
	0x6E26, KANJI_SJIS_L1,  // 渦
	0x5618, KANJI_SJIS_L1,  // 嘘
	0x5504, KANJI_SJIS_L1,  // 唄
	0x6B1D, KANJI_SJIS_L1,  // 欝
	0x851A, KANJI_SJIS_L1,  // 蔚
	0x9C3B, KANJI_SJIS_L1,  // 鰻
	0x59E5, KANJI_SJIS_L1,  // 姥
	0x53A9, KANJI_SJIS_L1,  // 厩
	0x6D66, KANJI_SJIS_L1,  // 浦
	0x74DC, KANJI_SJIS_L1,  // 瓜
	0x958F, KANJI_SJIS_L1,  // 閏
	0x5642, KANJI_SJIS_L1,  // 噂
	0x4E91, KANJI_SJIS_L1,  // 云
	0x904B, KANJI_SJIS_L1,  // 運
	0x96F2, KANJI_SJIS_L1,  // 雲
	0x834F, KANJI_SJIS_L1,  // 荏
	0x990C, KANJI_SJIS_L1,  // 餌
	0x53E1, KANJI_SJIS_L1,  // 叡
	0x55B6, KANJI_SJIS_L1,  // 営
	0x5B30, KANJI_SJIS_L1,  // 嬰
	0x5F71, KANJI_SJIS_L1,  // 影
	0x6620, KANJI_SJIS_L1,  // 映
	0x66F3, KANJI_SJIS_L1,  // 曳
	0x6804, KANJI_SJIS_L1,  // 栄
	0x6C38, KANJI_SJIS_L1,  // 永
	0x6CF3, KANJI_SJIS_L1,  // 泳
	0x6D29, KANJI_SJIS_L1,  // 洩
	0x745B, KANJI_SJIS_L1,  // 瑛
	0x76C8, KANJI_SJIS_L1,  // 盈
	0x7A4E, KANJI_SJIS_L1,  // 穎
	0x9834, KANJI_SJIS_L1,  // 頴
	0x82F1, KANJI_SJIS_L1,  // 英
	0x885B, KANJI_SJIS_L1,  // 衛
	0x8A60, KANJI_SJIS_L1,  // 詠
	0x92ED, KANJI_SJIS_L1,  // 鋭
	0x6DB2, KANJI_SJIS_L1,  // 液
	0x75AB, KANJI_SJIS_L1,  // 疫
	0x76CA, KANJI_SJIS_L1,  // 益
	0x99C5, KANJI_SJIS_L1,  // 駅
	0x60A6, KANJI_SJIS_L1,  // 悦
	0x8B01, KANJI_SJIS_L1,  // 謁
	0x8D8A, KANJI_SJIS_L1,  // 越
	0x95B2, KANJI_SJIS_L1,  // 閲
	0x698E, KANJI_SJIS_L1,  // 榎
	0x53AD, KANJI_SJIS_L1,  // 厭
	0x5186, KANJI_SJIS_L1,  // 円
	0x3000, KANJI_SJIS_L1,  // 　
	0x5712, KANJI_SJIS_L1,  // 園
	0x5830, KANJI_SJIS_L1,  // 堰
	0x5944, KANJI_SJIS_L1,  // 奄
	0x5BB4, KANJI_SJIS_L1,  // 宴
	0x5EF6, KANJI_SJIS_L1,  // 延
	0x6028, KANJI_SJIS_L1,  // 怨
	0x63A9, KANJI_SJIS_L1,  // 掩
	0x63F4, KANJI_SJIS_L1,  // 援
	0x6CBF, KANJI_SJIS_L1,  // 沿
	0x6F14, KANJI_SJIS_L1,  // 演
	0x708E, KANJI_SJIS_L1,  // 炎
	0x7114, KANJI_SJIS_L1,  // 焔
	0x7159, KANJI_SJIS_L1,  // 煙
	0x71D5, KANJI_SJIS_L1,  // 燕
	0x733F, KANJI_SJIS_L1,  // 猿
	0x7E01, KANJI_SJIS_L1,  // 縁
	0x8276, KANJI_SJIS_L1,  // 艶
	0x82D1, KANJI_SJIS_L1,  // 苑
	0x8597, KANJI_SJIS_L1,  // 薗
	0x9060, KANJI_SJIS_L1,  // 遠
	0x925B, KANJI_SJIS_L1,  // 鉛
	0x9D1B, KANJI_SJIS_L1,  // 鴛
	0x5869, KANJI_SJIS_L1,  // 塩
	0x65BC, KANJI_SJIS_L1,  // 於
	0x6C5A, KANJI_SJIS_L1,  // 汚
	0x7525, KANJI_SJIS_L1,  // 甥
	0x51F9, KANJI_SJIS_L1,  // 凹
	0x592E, KANJI_SJIS_L1,  // 央
	0x5965, KANJI_SJIS_L1,  // 奥
	0x5F80, KANJI_SJIS_L1,  // 往
	0x5FDC, KANJI_SJIS_L1,  // 応
	0x62BC, KANJI_SJIS_L1,  // 押
	0x65FA, KANJI_SJIS_L1,  // 旺
	0x6A2A, KANJI_SJIS_L1,  // 横
	0x6B27, KANJI_SJIS_L1,  // 欧
	0x6BB4, KANJI_SJIS_L1,  // 殴
	0x738B, KANJI_SJIS_L1,  // 王
	0x7FC1, KANJI_SJIS_L1,  // 翁
	0x8956, KANJI_SJIS_L1,  // 襖
	0x9D2C, KANJI_SJIS_L1,  // 鴬
	0x9D0E, KANJI_SJIS_L1,  // 鴎
	0x9EC4, KANJI_SJIS_L1,  // 黄
	0x5CA1, KANJI_SJIS_L1,  // 岡
	0x6C96, KANJI_SJIS_L1,  // 沖
	0x837B, KANJI_SJIS_L1,  // 荻
	0x5104, KANJI_SJIS_L1,  // 億
	0x5C4B, KANJI_SJIS_L1,  // 屋
	0x61B6, KANJI_SJIS_L1,  // 憶
	0x81C6, KANJI_SJIS_L1,  // 臆
	0x6876, KANJI_SJIS_L1,  // 桶
	0x7261, KANJI_SJIS_L1,  // 牡
	0x4E59, KANJI_SJIS_L1,  // 乙
	0x4FFA, KANJI_SJIS_L1,  // 俺
	0x5378, KANJI_SJIS_L1,  // 卸
	0x6069, KANJI_SJIS_L1,  // 恩
	0x6E29, KANJI_SJIS_L1,  // 温
	0x7A4F, KANJI_SJIS_L1,  // 穏
	0x97F3, KANJI_SJIS_L1,  // 音
	0x4E0B, KANJI_SJIS_L1,  // 下
	0x5316, KANJI_SJIS_L1,  // 化
	0x4EEE, KANJI_SJIS_L1,  // 仮
	0x4F55, KANJI_SJIS_L1,  // 何
	0x4F3D, KANJI_SJIS_L1,  // 伽
	0x4FA1, KANJI_SJIS_L1,  // 価
	0x4F73, KANJI_SJIS_L1,  // 佳
	0x52A0, KANJI_SJIS_L1,  // 加
	0x53EF, KANJI_SJIS_L1,  // 可
	0x5609, KANJI_SJIS_L1,  // 嘉
	0x590F, KANJI_SJIS_L1,  // 夏
	0x5AC1, KANJI_SJIS_L1,  // 嫁
	0x5BB6, KANJI_SJIS_L1,  // 家
	0x5BE1, KANJI_SJIS_L1,  // 寡
	0x79D1, KANJI_SJIS_L1,  // 科
	0x6687, KANJI_SJIS_L1,  // 暇
	0x679C, KANJI_SJIS_L1,  // 果
	0x67B6, KANJI_SJIS_L1,  // 架
	0x6B4C, KANJI_SJIS_L1,  // 歌
	0x6CB3, KANJI_SJIS_L1,  // 河
	0x706B, KANJI_SJIS_L1,  // 火
	0x73C2, KANJI_SJIS_L1,  // 珂
	0x798D, KANJI_SJIS_L1,  // 禍
	0x79BE, KANJI_SJIS_L1,  // 禾
	0x7A3C, KANJI_SJIS_L1,  // 稼
	0x7B87, KANJI_SJIS_L1,  // 箇
	0x82B1, KANJI_SJIS_L1,  // 花
	0x82DB, KANJI_SJIS_L1,  // 苛
	0x8304, KANJI_SJIS_L1,  // 茄
	0x8377, KANJI_SJIS_L1,  // 荷
	0x83EF, KANJI_SJIS_L1,  // 華
	0x83D3, KANJI_SJIS_L1,  // 菓
	0x8766, KANJI_SJIS_L1,  // 蝦
	0x8AB2, KANJI_SJIS_L1,  // 課
	0x5629, KANJI_SJIS_L1,  // 嘩
	0x8CA8, KANJI_SJIS_L1,  // 貨
	0x8FE6, KANJI_SJIS_L1,  // 迦
	0x904E, KANJI_SJIS_L1,  // 過
	0x971E, KANJI_SJIS_L1,  // 霞
	0x868A, KANJI_SJIS_L1,  // 蚊
	0x4FC4, KANJI_SJIS_L1,  // 俄
	0x5CE8, KANJI_SJIS_L1,  // 峨
	0x6211, KANJI_SJIS_L1,  // 我
	0x7259, KANJI_SJIS_L1,  // 牙
	0x753B, KANJI_SJIS_L1,  // 画
	0x81E5, KANJI_SJIS_L1,  // 臥
	0x82BD, KANJI_SJIS_L1,  // 芽
	0x86FE, KANJI_SJIS_L1,  // 蛾
	0x8CC0, KANJI_SJIS_L1,  // 賀
	0x96C5, KANJI_SJIS_L1,  // 雅
	0x9913, KANJI_SJIS_L1,  // 餓
	0x99D5, KANJI_SJIS_L1,  // 駕
	0x4ECB, KANJI_SJIS_L1,  // 介
	0x4F1A, KANJI_SJIS_L1,  // 会
	0x89E3, KANJI_SJIS_L1,  // 解
	0x56DE, KANJI_SJIS_L1,  // 回
	0x584A, KANJI_SJIS_L1,  // 塊
	0x58CA, KANJI_SJIS_L1,  // 壊
	0x5EFB, KANJI_SJIS_L1,  // 廻
	0x5FEB, KANJI_SJIS_L1,  // 快
	0x602A, KANJI_SJIS_L1,  // 怪
	0x6094, KANJI_SJIS_L1,  // 悔
	0x6062, KANJI_SJIS_L1,  // 恢
	0x61D0, KANJI_SJIS_L1,  // 懐
	0x6212, KANJI_SJIS_L1,  // 戒
	0x62D0, KANJI_SJIS_L1,  // 拐
	0x6539, KANJI_SJIS_L1,  // 改
	0x9B41, KANJI_SJIS_L1,  // 魁
	0x6666, KANJI_SJIS_L1,  // 晦
	0x68B0, KANJI_SJIS_L1,  // 械
	0x6D77, KANJI_SJIS_L1,  // 海
	0x7070, KANJI_SJIS_L1,  // 灰
	0x754C, KANJI_SJIS_L1,  // 界
	0x7686, KANJI_SJIS_L1,  // 皆
	0x7D75, KANJI_SJIS_L1,  // 絵
	0x82A5, KANJI_SJIS_L1,  // 芥
	0x87F9, KANJI_SJIS_L1,  // 蟹
	0x958B, KANJI_SJIS_L1,  // 開
	0x968E, KANJI_SJIS_L1,  // 階
	0x8C9D, KANJI_SJIS_L1,  // 貝
	0x51F1, KANJI_SJIS_L1,  // 凱
	0x52BE, KANJI_SJIS_L1,  // 劾
	0x5916, KANJI_SJIS_L1,  // 外
	0x54B3, KANJI_SJIS_L1,  // 咳
	0x5BB3, KANJI_SJIS_L1,  // 害
	0x5D16, KANJI_SJIS_L1,  // 崖
	0x6168, KANJI_SJIS_L1,  // 慨
	0x6982, KANJI_SJIS_L1,  // 概
	0x6DAF, KANJI_SJIS_L1,  // 涯
	0x788D, KANJI_SJIS_L1,  // 碍
	0x84CB, KANJI_SJIS_L1,  // 蓋
	0x8857, KANJI_SJIS_L1,  // 街
	0x8A72, KANJI_SJIS_L1,  // 該
	0x93A7, KANJI_SJIS_L1,  // 鎧
	0x9AB8, KANJI_SJIS_L1,  // 骸
	0x6D6C, KANJI_SJIS_L1,  // 浬
	0x99A8, KANJI_SJIS_L1,  // 馨
	0x86D9, KANJI_SJIS_L1,  // 蛙
	0x57A3, KANJI_SJIS_L1,  // 垣
	0x67FF, KANJI_SJIS_L1,  // 柿
	0x86CE, KANJI_SJIS_L1,  // 蛎
	0x920E, KANJI_SJIS_L1,  // 鈎
	0x5283, KANJI_SJIS_L1,  // 劃
	0x5687, KANJI_SJIS_L1,  // 嚇
	0x5404, KANJI_SJIS_L1,  // 各
	0x5ED3, KANJI_SJIS_L1,  // 廓
	0x62E1, KANJI_SJIS_L1,  // 拡
	0x64B9, KANJI_SJIS_L1,  // 撹
	0x683C, KANJI_SJIS_L1,  // 格
	0x6838, KANJI_SJIS_L1,  // 核
	0x6BBB, KANJI_SJIS_L1,  // 殻
	0x7372, KANJI_SJIS_L1,  // 獲
	0x78BA, KANJI_SJIS_L1,  // 確
	0x7A6B, KANJI_SJIS_L1,  // 穫
	0x899A, KANJI_SJIS_L1,  // 覚
	0x89D2, KANJI_SJIS_L1,  // 角
	0x8D6B, KANJI_SJIS_L1,  // 赫
	0x8F03, KANJI_SJIS_L1,  // 較
	0x90ED, KANJI_SJIS_L1,  // 郭
	0x95A3, KANJI_SJIS_L1,  // 閣
	0x9694, KANJI_SJIS_L1,  // 隔
	0x9769, KANJI_SJIS_L1,  // 革
	0x5B66, KANJI_SJIS_L1,  // 学
	0x5CB3, KANJI_SJIS_L1,  // 岳
	0x697D, KANJI_SJIS_L1,  // 楽
	0x984D, KANJI_SJIS_L1,  // 額
	0x984E, KANJI_SJIS_L1,  // 顎
	0x639B, KANJI_SJIS_L1,  // 掛
	0x7B20, KANJI_SJIS_L1,  // 笠
	0x6A2B, KANJI_SJIS_L1,  // 樫
	0x3000, KANJI_SJIS_L1,  // 　
	0x6A7F, KANJI_SJIS_L1,  // 橿
	0x68B6, KANJI_SJIS_L1,  // 梶
	0x9C0D, KANJI_SJIS_L1,  // 鰍
	0x6F5F, KANJI_SJIS_L1,  // 潟
	0x5272, KANJI_SJIS_L1,  // 割
	0x559D, KANJI_SJIS_L1,  // 喝
	0x6070, KANJI_SJIS_L1,  // 恰
	0x62EC, KANJI_SJIS_L1,  // 括
	0x6D3B, KANJI_SJIS_L1,  // 活
	0x6E07, KANJI_SJIS_L1,  // 渇
	0x6ED1, KANJI_SJIS_L1,  // 滑
	0x845B, KANJI_SJIS_L1,  // 葛
	0x8910, KANJI_SJIS_L1,  // 褐
	0x8F44, KANJI_SJIS_L1,  // 轄
	0x4E14, KANJI_SJIS_L1,  // 且
	0x9C39, KANJI_SJIS_L1,  // 鰹
	0x53F6, KANJI_SJIS_L1,  // 叶
	0x691B, KANJI_SJIS_L1,  // 椛
	0x6A3A, KANJI_SJIS_L1,  // 樺
	0x9784, KANJI_SJIS_L1,  // 鞄
	0x682A, KANJI_SJIS_L1,  // 株
	0x515C, KANJI_SJIS_L1,  // 兜
	0x7AC3, KANJI_SJIS_L1,  // 竃
	0x84B2, KANJI_SJIS_L1,  // 蒲
	0x91DC, KANJI_SJIS_L1,  // 釜
	0x938C, KANJI_SJIS_L1,  // 鎌
	0x565B, KANJI_SJIS_L1,  // 噛
	0x9D28, KANJI_SJIS_L1,  // 鴨
	0x6822, KANJI_SJIS_L1,  // 栢
	0x8305, KANJI_SJIS_L1,  // 茅
	0x8431, KANJI_SJIS_L1,  // 萱
	0x7CA5, KANJI_SJIS_L1,  // 粥
	0x5208, KANJI_SJIS_L1,  // 刈
	0x82C5, KANJI_SJIS_L1,  // 苅
	0x74E6, KANJI_SJIS_L1,  // 瓦
	0x4E7E, KANJI_SJIS_L1,  // 乾
	0x4F83, KANJI_SJIS_L1,  // 侃
	0x51A0, KANJI_SJIS_L1,  // 冠
	0x5BD2, KANJI_SJIS_L1,  // 寒
	0x520A, KANJI_SJIS_L1,  // 刊
	0x52D8, KANJI_SJIS_L1,  // 勘
	0x52E7, KANJI_SJIS_L1,  // 勧
	0x5DFB, KANJI_SJIS_L1,  // 巻
	0x559A, KANJI_SJIS_L1,  // 喚
	0x582A, KANJI_SJIS_L1,  // 堪
	0x59E6, KANJI_SJIS_L1,  // 姦
	0x5B8C, KANJI_SJIS_L1,  // 完
	0x5B98, KANJI_SJIS_L1,  // 官
	0x5BDB, KANJI_SJIS_L1,  // 寛
	0x5E72, KANJI_SJIS_L1,  // 干
	0x5E79, KANJI_SJIS_L1,  // 幹
	0x60A3, KANJI_SJIS_L1,  // 患
	0x611F, KANJI_SJIS_L1,  // 感
	0x6163, KANJI_SJIS_L1,  // 慣
	0x61BE, KANJI_SJIS_L1,  // 憾
	0x63DB, KANJI_SJIS_L1,  // 換
	0x6562, KANJI_SJIS_L1,  // 敢
	0x67D1, KANJI_SJIS_L1,  // 柑
	0x6853, KANJI_SJIS_L1,  // 桓
	0x68FA, KANJI_SJIS_L1,  // 棺
	0x6B3E, KANJI_SJIS_L1,  // 款
	0x6B53, KANJI_SJIS_L1,  // 歓
	0x6C57, KANJI_SJIS_L1,  // 汗
	0x6F22, KANJI_SJIS_L1,  // 漢
	0x6F97, KANJI_SJIS_L1,  // 澗
	0x6F45, KANJI_SJIS_L1,  // 潅
	0x74B0, KANJI_SJIS_L1,  // 環
	0x7518, KANJI_SJIS_L1,  // 甘
	0x76E3, KANJI_SJIS_L1,  // 監
	0x770B, KANJI_SJIS_L1,  // 看
	0x7AFF, KANJI_SJIS_L1,  // 竿
	0x7BA1, KANJI_SJIS_L1,  // 管
	0x7C21, KANJI_SJIS_L1,  // 簡
	0x7DE9, KANJI_SJIS_L1,  // 緩
	0x7F36, KANJI_SJIS_L1,  // 缶
	0x7FF0, KANJI_SJIS_L1,  // 翰
	0x809D, KANJI_SJIS_L1,  // 肝
	0x8266, KANJI_SJIS_L1,  // 艦
	0x839E, KANJI_SJIS_L1,  // 莞
	0x89B3, KANJI_SJIS_L1,  // 観
	0x8ACC, KANJI_SJIS_L1,  // 諌
	0x8CAB, KANJI_SJIS_L1,  // 貫
	0x9084, KANJI_SJIS_L1,  // 還
	0x9451, KANJI_SJIS_L1,  // 鑑
	0x9593, KANJI_SJIS_L1,  // 間
	0x9591, KANJI_SJIS_L1,  // 閑
	0x95A2, KANJI_SJIS_L1,  // 関
	0x9665, KANJI_SJIS_L1,  // 陥
	0x97D3, KANJI_SJIS_L1,  // 韓
	0x9928, KANJI_SJIS_L1,  // 館
	0x8218, KANJI_SJIS_L1,  // 舘
	0x4E38, KANJI_SJIS_L1,  // 丸
	0x542B, KANJI_SJIS_L1,  // 含
	0x5CB8, KANJI_SJIS_L1,  // 岸
	0x5DCC, KANJI_SJIS_L1,  // 巌
	0x73A9, KANJI_SJIS_L1,  // 玩
	0x764C, KANJI_SJIS_L1,  // 癌
	0x773C, KANJI_SJIS_L1,  // 眼
	0x5CA9, KANJI_SJIS_L1,  // 岩
	0x7FEB, KANJI_SJIS_L1,  // 翫
	0x8D0B, KANJI_SJIS_L1,  // 贋
	0x96C1, KANJI_SJIS_L1,  // 雁
	0x9811, KANJI_SJIS_L1,  // 頑
	0x9854, KANJI_SJIS_L1,  // 顔
	0x9858, KANJI_SJIS_L1,  // 願
	0x4F01, KANJI_SJIS_L1,  // 企
	0x4F0E, KANJI_SJIS_L1,  // 伎
	0x5371, KANJI_SJIS_L1,  // 危
	0x559C, KANJI_SJIS_L1,  // 喜
	0x5668, KANJI_SJIS_L1,  // 器
	0x57FA, KANJI_SJIS_L1,  // 基
	0x5947, KANJI_SJIS_L1,  // 奇
	0x5B09, KANJI_SJIS_L1,  // 嬉
	0x5BC4, KANJI_SJIS_L1,  // 寄
	0x5C90, KANJI_SJIS_L1,  // 岐
	0x5E0C, KANJI_SJIS_L1,  // 希
	0x5E7E, KANJI_SJIS_L1,  // 幾
	0x5FCC, KANJI_SJIS_L1,  // 忌
	0x63EE, KANJI_SJIS_L1,  // 揮
	0x673A, KANJI_SJIS_L1,  // 机
	0x65D7, KANJI_SJIS_L1,  // 旗
	0x65E2, KANJI_SJIS_L1,  // 既
	0x671F, KANJI_SJIS_L1,  // 期
	0x68CB, KANJI_SJIS_L1,  // 棋
	0x68C4, KANJI_SJIS_L1,  // 棄
	0x6A5F, KANJI_SJIS_L1,  // 機
	0x5E30, KANJI_SJIS_L1,  // 帰
	0x6BC5, KANJI_SJIS_L1,  // 毅
	0x6C17, KANJI_SJIS_L1,  // 気
	0x6C7D, KANJI_SJIS_L1,  // 汽
	0x757F, KANJI_SJIS_L1,  // 畿
	0x7948, KANJI_SJIS_L1,  // 祈
	0x5B63, KANJI_SJIS_L1,  // 季
	0x7A00, KANJI_SJIS_L1,  // 稀
	0x7D00, KANJI_SJIS_L1,  // 紀
	0x5FBD, KANJI_SJIS_L1,  // 徽
	0x898F, KANJI_SJIS_L1,  // 規
	0x8A18, KANJI_SJIS_L1,  // 記
	0x8CB4, KANJI_SJIS_L1,  // 貴
	0x8D77, KANJI_SJIS_L1,  // 起
	0x8ECC, KANJI_SJIS_L1,  // 軌
	0x8F1D, KANJI_SJIS_L1,  // 輝
	0x98E2, KANJI_SJIS_L1,  // 飢
	0x9A0E, KANJI_SJIS_L1,  // 騎
	0x9B3C, KANJI_SJIS_L1,  // 鬼
	0x4E80, KANJI_SJIS_L1,  // 亀
	0x507D, KANJI_SJIS_L1,  // 偽
	0x5100, KANJI_SJIS_L1,  // 儀
	0x5993, KANJI_SJIS_L1,  // 妓
	0x5B9C, KANJI_SJIS_L1,  // 宜
	0x622F, KANJI_SJIS_L1,  // 戯
	0x6280, KANJI_SJIS_L1,  // 技
	0x64EC, KANJI_SJIS_L1,  // 擬
	0x6B3A, KANJI_SJIS_L1,  // 欺
	0x72A0, KANJI_SJIS_L1,  // 犠
	0x7591, KANJI_SJIS_L1,  // 疑
	0x7947, KANJI_SJIS_L1,  // 祇
	0x7FA9, KANJI_SJIS_L1,  // 義
	0x87FB, KANJI_SJIS_L1,  // 蟻
	0x8ABC, KANJI_SJIS_L1,  // 誼
	0x8B70, KANJI_SJIS_L1,  // 議
	0x63AC, KANJI_SJIS_L1,  // 掬
	0x83CA, KANJI_SJIS_L1,  // 菊
	0x97A0, KANJI_SJIS_L1,  // 鞠
	0x5409, KANJI_SJIS_L1,  // 吉
	0x5403, KANJI_SJIS_L1,  // 吃
	0x55AB, KANJI_SJIS_L1,  // 喫
	0x6854, KANJI_SJIS_L1,  // 桔
	0x6A58, KANJI_SJIS_L1,  // 橘
	0x8A70, KANJI_SJIS_L1,  // 詰
	0x7827, KANJI_SJIS_L1,  // 砧
	0x6775, KANJI_SJIS_L1,  // 杵
	0x9ECD, KANJI_SJIS_L1,  // 黍
	0x5374, KANJI_SJIS_L1,  // 却
	0x5BA2, KANJI_SJIS_L1,  // 客
	0x811A, KANJI_SJIS_L1,  // 脚
	0x8650, KANJI_SJIS_L1,  // 虐
	0x9006, KANJI_SJIS_L1,  // 逆
	0x4E18, KANJI_SJIS_L1,  // 丘
	0x4E45, KANJI_SJIS_L1,  // 久
	0x4EC7, KANJI_SJIS_L1,  // 仇
	0x4F11, KANJI_SJIS_L1,  // 休
	0x53CA, KANJI_SJIS_L1,  // 及
	0x5438, KANJI_SJIS_L1,  // 吸
	0x5BAE, KANJI_SJIS_L1,  // 宮
	0x5F13, KANJI_SJIS_L1,  // 弓
	0x6025, KANJI_SJIS_L1,  // 急
	0x6551, KANJI_SJIS_L1,  // 救
	0x3000, KANJI_SJIS_L1,  // 　
	0x673D, KANJI_SJIS_L1,  // 朽
	0x6C42, KANJI_SJIS_L1,  // 求
	0x6C72, KANJI_SJIS_L1,  // 汲
	0x6CE3, KANJI_SJIS_L1,  // 泣
	0x7078, KANJI_SJIS_L1,  // 灸
	0x7403, KANJI_SJIS_L1,  // 球
	0x7A76, KANJI_SJIS_L1,  // 究
	0x7AAE, KANJI_SJIS_L1,  // 窮
	0x7B08, KANJI_SJIS_L1,  // 笈
	0x7D1A, KANJI_SJIS_L1,  // 級
	0x7CFE, KANJI_SJIS_L1,  // 糾
	0x7D66, KANJI_SJIS_L1,  // 給
	0x65E7, KANJI_SJIS_L1,  // 旧
	0x725B, KANJI_SJIS_L1,  // 牛
	0x53BB, KANJI_SJIS_L1,  // 去
	0x5C45, KANJI_SJIS_L1,  // 居
	0x5DE8, KANJI_SJIS_L1,  // 巨
	0x62D2, KANJI_SJIS_L1,  // 拒
	0x62E0, KANJI_SJIS_L1,  // 拠
	0x6319, KANJI_SJIS_L1,  // 挙
	0x6E20, KANJI_SJIS_L1,  // 渠
	0x865A, KANJI_SJIS_L1,  // 虚
	0x8A31, KANJI_SJIS_L1,  // 許
	0x8DDD, KANJI_SJIS_L1,  // 距
	0x92F8, KANJI_SJIS_L1,  // 鋸
	0x6F01, KANJI_SJIS_L1,  // 漁
	0x79A6, KANJI_SJIS_L1,  // 禦
	0x9B5A, KANJI_SJIS_L1,  // 魚
	0x4EA8, KANJI_SJIS_L1,  // 亨
	0x4EAB, KANJI_SJIS_L1,  // 享
	0x4EAC, KANJI_SJIS_L1,  // 京
	0x4F9B, KANJI_SJIS_L1,  // 供
	0x4FA0, KANJI_SJIS_L1,  // 侠
	0x50D1, KANJI_SJIS_L1,  // 僑
	0x5147, KANJI_SJIS_L1,  // 兇
	0x7AF6, KANJI_SJIS_L1,  // 競
	0x5171, KANJI_SJIS_L1,  // 共
	0x51F6, KANJI_SJIS_L1,  // 凶
	0x5354, KANJI_SJIS_L1,  // 協
	0x5321, KANJI_SJIS_L1,  // 匡
	0x537F, KANJI_SJIS_L1,  // 卿
	0x53EB, KANJI_SJIS_L1,  // 叫
	0x55AC, KANJI_SJIS_L1,  // 喬
	0x5883, KANJI_SJIS_L1,  // 境
	0x5CE1, KANJI_SJIS_L1,  // 峡
	0x5F37, KANJI_SJIS_L1,  // 強
	0x5F4A, KANJI_SJIS_L1,  // 彊
	0x602F, KANJI_SJIS_L1,  // 怯
	0x6050, KANJI_SJIS_L1,  // 恐
	0x606D, KANJI_SJIS_L1,  // 恭
	0x631F, KANJI_SJIS_L1,  // 挟
	0x6559, KANJI_SJIS_L1,  // 教
	0x6A4B, KANJI_SJIS_L1,  // 橋
	0x6CC1, KANJI_SJIS_L1,  // 況
	0x72C2, KANJI_SJIS_L1,  // 狂
	0x72ED, KANJI_SJIS_L1,  // 狭
	0x77EF, KANJI_SJIS_L1,  // 矯
	0x80F8, KANJI_SJIS_L1,  // 胸
	0x8105, KANJI_SJIS_L1,  // 脅
	0x8208, KANJI_SJIS_L1,  // 興
	0x854E, KANJI_SJIS_L1,  // 蕎
	0x90F7, KANJI_SJIS_L1,  // 郷
	0x93E1, KANJI_SJIS_L1,  // 鏡
	0x97FF, KANJI_SJIS_L1,  // 響
	0x9957, KANJI_SJIS_L1,  // 饗
	0x9A5A, KANJI_SJIS_L1,  // 驚
	0x4EF0, KANJI_SJIS_L1,  // 仰
	0x51DD, KANJI_SJIS_L1,  // 凝
	0x5C2D, KANJI_SJIS_L1,  // 尭
	0x6681, KANJI_SJIS_L1,  // 暁
	0x696D, KANJI_SJIS_L1,  // 業
	0x5C40, KANJI_SJIS_L1,  // 局
	0x66F2, KANJI_SJIS_L1,  // 曲
	0x6975, KANJI_SJIS_L1,  // 極
	0x7389, KANJI_SJIS_L1,  // 玉
	0x6850, KANJI_SJIS_L1,  // 桐
	0x7C81, KANJI_SJIS_L1,  // 粁
	0x50C5, KANJI_SJIS_L1,  // 僅
	0x52E4, KANJI_SJIS_L1,  // 勤
	0x5747, KANJI_SJIS_L1,  // 均
	0x5DFE, KANJI_SJIS_L1,  // 巾
	0x9326, KANJI_SJIS_L1,  // 錦
	0x65A4, KANJI_SJIS_L1,  // 斤
	0x6B23, KANJI_SJIS_L1,  // 欣
	0x6B3D, KANJI_SJIS_L1,  // 欽
	0x7434, KANJI_SJIS_L1,  // 琴
	0x7981, KANJI_SJIS_L1,  // 禁
	0x79BD, KANJI_SJIS_L1,  // 禽
	0x7B4B, KANJI_SJIS_L1,  // 筋
	0x7DCA, KANJI_SJIS_L1,  // 緊
	0x82B9, KANJI_SJIS_L1,  // 芹
	0x83CC, KANJI_SJIS_L1,  // 菌
	0x887F, KANJI_SJIS_L1,  // 衿
	0x895F, KANJI_SJIS_L1,  // 襟
	0x8B39, KANJI_SJIS_L1,  // 謹
	0x8FD1, KANJI_SJIS_L1,  // 近
	0x91D1, KANJI_SJIS_L1,  // 金
	0x541F, KANJI_SJIS_L1,  // 吟
	0x9280, KANJI_SJIS_L1,  // 銀
	0x4E5D, KANJI_SJIS_L1,  // 九
	0x5036, KANJI_SJIS_L1,  // 倶
	0x53E5, KANJI_SJIS_L1,  // 句
	0x533A, KANJI_SJIS_L1,  // 区
	0x72D7, KANJI_SJIS_L1,  // 狗
	0x7396, KANJI_SJIS_L1,  // 玖
	0x77E9, KANJI_SJIS_L1,  // 矩
	0x82E6, KANJI_SJIS_L1,  // 苦
	0x8EAF, KANJI_SJIS_L1,  // 躯
	0x99C6, KANJI_SJIS_L1,  // 駆
	0x99C8, KANJI_SJIS_L1,  // 駈
	0x99D2, KANJI_SJIS_L1,  // 駒
	0x5177, KANJI_SJIS_L1,  // 具
	0x611A, KANJI_SJIS_L1,  // 愚
	0x865E, KANJI_SJIS_L1,  // 虞
	0x55B0, KANJI_SJIS_L1,  // 喰
	0x7A7A, KANJI_SJIS_L1,  // 空
	0x5076, KANJI_SJIS_L1,  // 偶
	0x5BD3, KANJI_SJIS_L1,  // 寓
	0x9047, KANJI_SJIS_L1,  // 遇
	0x9685, KANJI_SJIS_L1,  // 隅
	0x4E32, KANJI_SJIS_L1,  // 串
	0x6ADB, KANJI_SJIS_L1,  // 櫛
	0x91E7, KANJI_SJIS_L1,  // 釧
	0x5C51, KANJI_SJIS_L1,  // 屑
	0x5C48, KANJI_SJIS_L1,  // 屈
	0x6398, KANJI_SJIS_L1,  // 掘
	0x7A9F, KANJI_SJIS_L1,  // 窟
	0x6C93, KANJI_SJIS_L1,  // 沓
	0x9774, KANJI_SJIS_L1,  // 靴
	0x8F61, KANJI_SJIS_L1,  // 轡
	0x7AAA, KANJI_SJIS_L1,  // 窪
	0x718A, KANJI_SJIS_L1,  // 熊
	0x9688, KANJI_SJIS_L1,  // 隈
	0x7C82, KANJI_SJIS_L1,  // 粂
	0x6817, KANJI_SJIS_L1,  // 栗
	0x7E70, KANJI_SJIS_L1,  // 繰
	0x6851, KANJI_SJIS_L1,  // 桑
	0x936C, KANJI_SJIS_L1,  // 鍬
	0x52F2, KANJI_SJIS_L1,  // 勲
	0x541B, KANJI_SJIS_L1,  // 君
	0x85AB, KANJI_SJIS_L1,  // 薫
	0x8A13, KANJI_SJIS_L1,  // 訓
	0x7FA4, KANJI_SJIS_L1,  // 群
	0x8ECD, KANJI_SJIS_L1,  // 軍
	0x90E1, KANJI_SJIS_L1,  // 郡
	0x5366, KANJI_SJIS_L1,  // 卦
	0x8888, KANJI_SJIS_L1,  // 袈
	0x7941, KANJI_SJIS_L1,  // 祁
	0x4FC2, KANJI_SJIS_L1,  // 係
	0x50BE, KANJI_SJIS_L1,  // 傾
	0x5211, KANJI_SJIS_L1,  // 刑
	0x5144, KANJI_SJIS_L1,  // 兄
	0x5553, KANJI_SJIS_L1,  // 啓
	0x572D, KANJI_SJIS_L1,  // 圭
	0x73EA, KANJI_SJIS_L1,  // 珪
	0x578B, KANJI_SJIS_L1,  // 型
	0x5951, KANJI_SJIS_L1,  // 契
	0x5F62, KANJI_SJIS_L1,  // 形
	0x5F84, KANJI_SJIS_L1,  // 径
	0x6075, KANJI_SJIS_L1,  // 恵
	0x6176, KANJI_SJIS_L1,  // 慶
	0x6167, KANJI_SJIS_L1,  // 慧
	0x61A9, KANJI_SJIS_L1,  // 憩
	0x63B2, KANJI_SJIS_L1,  // 掲
	0x643A, KANJI_SJIS_L1,  // 携
	0x656C, KANJI_SJIS_L1,  // 敬
	0x666F, KANJI_SJIS_L1,  // 景
	0x6842, KANJI_SJIS_L1,  // 桂
	0x6E13, KANJI_SJIS_L1,  // 渓
	0x7566, KANJI_SJIS_L1,  // 畦
	0x7A3D, KANJI_SJIS_L1,  // 稽
	0x7CFB, KANJI_SJIS_L1,  // 系
	0x7D4C, KANJI_SJIS_L1,  // 経
	0x7D99, KANJI_SJIS_L1,  // 継
	0x7E4B, KANJI_SJIS_L1,  // 繋
	0x7F6B, KANJI_SJIS_L1,  // 罫
	0x830E, KANJI_SJIS_L1,  // 茎
	0x834A, KANJI_SJIS_L1,  // 荊
	0x86CD, KANJI_SJIS_L1,  // 蛍
	0x8A08, KANJI_SJIS_L1,  // 計
	0x8A63, KANJI_SJIS_L1,  // 詣
	0x8B66, KANJI_SJIS_L1,  // 警
	0x8EFD, KANJI_SJIS_L1,  // 軽
	0x981A, KANJI_SJIS_L1,  // 頚
	0x9D8F, KANJI_SJIS_L1,  // 鶏
	0x82B8, KANJI_SJIS_L1,  // 芸
	0x8FCE, KANJI_SJIS_L1,  // 迎
	0x9BE8, KANJI_SJIS_L1,  // 鯨
	0x3000, KANJI_SJIS_L1,  // 　
	0x5287, KANJI_SJIS_L1,  // 劇
	0x621F, KANJI_SJIS_L1,  // 戟
	0x6483, KANJI_SJIS_L1,  // 撃
	0x6FC0, KANJI_SJIS_L1,  // 激
	0x9699, KANJI_SJIS_L1,  // 隙
	0x6841, KANJI_SJIS_L1,  // 桁
	0x5091, KANJI_SJIS_L1,  // 傑
	0x6B20, KANJI_SJIS_L1,  // 欠
	0x6C7A, KANJI_SJIS_L1,  // 決
	0x6F54, KANJI_SJIS_L1,  // 潔
	0x7A74, KANJI_SJIS_L1,  // 穴
	0x7D50, KANJI_SJIS_L1,  // 結
	0x8840, KANJI_SJIS_L1,  // 血
	0x8A23, KANJI_SJIS_L1,  // 訣
	0x6708, KANJI_SJIS_L1,  // 月
	0x4EF6, KANJI_SJIS_L1,  // 件
	0x5039, KANJI_SJIS_L1,  // 倹
	0x5026, KANJI_SJIS_L1,  // 倦
	0x5065, KANJI_SJIS_L1,  // 健
	0x517C, KANJI_SJIS_L1,  // 兼
	0x5238, KANJI_SJIS_L1,  // 券
	0x5263, KANJI_SJIS_L1,  // 剣
	0x55A7, KANJI_SJIS_L1,  // 喧
	0x570F, KANJI_SJIS_L1,  // 圏
	0x5805, KANJI_SJIS_L1,  // 堅
	0x5ACC, KANJI_SJIS_L1,  // 嫌
	0x5EFA, KANJI_SJIS_L1,  // 建
	0x61B2, KANJI_SJIS_L1,  // 憲
	0x61F8, KANJI_SJIS_L1,  // 懸
	0x62F3, KANJI_SJIS_L1,  // 拳
	0x6372, KANJI_SJIS_L1,  // 捲
	0x691C, KANJI_SJIS_L1,  // 検
	0x6A29, KANJI_SJIS_L1,  // 権
	0x727D, KANJI_SJIS_L1,  // 牽
	0x72AC, KANJI_SJIS_L1,  // 犬
	0x732E, KANJI_SJIS_L1,  // 献
	0x7814, KANJI_SJIS_L1,  // 研
	0x786F, KANJI_SJIS_L1,  // 硯
	0x7D79, KANJI_SJIS_L1,  // 絹
	0x770C, KANJI_SJIS_L1,  // 県
	0x80A9, KANJI_SJIS_L1,  // 肩
	0x898B, KANJI_SJIS_L1,  // 見
	0x8B19, KANJI_SJIS_L1,  // 謙
	0x8CE2, KANJI_SJIS_L1,  // 賢
	0x8ED2, KANJI_SJIS_L1,  // 軒
	0x9063, KANJI_SJIS_L1,  // 遣
	0x9375, KANJI_SJIS_L1,  // 鍵
	0x967A, KANJI_SJIS_L1,  // 険
	0x9855, KANJI_SJIS_L1,  // 顕
	0x9A13, KANJI_SJIS_L1,  // 験
	0x9E78, KANJI_SJIS_L1,  // 鹸
	0x5143, KANJI_SJIS_L1,  // 元
	0x539F, KANJI_SJIS_L1,  // 原
	0x53B3, KANJI_SJIS_L1,  // 厳
	0x5E7B, KANJI_SJIS_L1,  // 幻
	0x5F26, KANJI_SJIS_L1,  // 弦
	0x6E1B, KANJI_SJIS_L1,  // 減
	0x6E90, KANJI_SJIS_L1,  // 源
	0x7384, KANJI_SJIS_L1,  // 玄
	0x73FE, KANJI_SJIS_L1,  // 現
	0x7D43, KANJI_SJIS_L1,  // 絃
	0x8237, KANJI_SJIS_L1,  // 舷
	0x8A00, KANJI_SJIS_L1,  // 言
	0x8AFA, KANJI_SJIS_L1,  // 諺
	0x9650, KANJI_SJIS_L1,  // 限
	0x4E4E, KANJI_SJIS_L1,  // 乎
	0x500B, KANJI_SJIS_L1,  // 個
	0x53E4, KANJI_SJIS_L1,  // 古
	0x547C, KANJI_SJIS_L1,  // 呼
	0x56FA, KANJI_SJIS_L1,  // 固
	0x59D1, KANJI_SJIS_L1,  // 姑
	0x5B64, KANJI_SJIS_L1,  // 孤
	0x5DF1, KANJI_SJIS_L1,  // 己
	0x5EAB, KANJI_SJIS_L1,  // 庫
	0x5F27, KANJI_SJIS_L1,  // 弧
	0x6238, KANJI_SJIS_L1,  // 戸
	0x6545, KANJI_SJIS_L1,  // 故
	0x67AF, KANJI_SJIS_L1,  // 枯
	0x6E56, KANJI_SJIS_L1,  // 湖
	0x72D0, KANJI_SJIS_L1,  // 狐
	0x7CCA, KANJI_SJIS_L1,  // 糊
	0x88B4, KANJI_SJIS_L1,  // 袴
	0x80A1, KANJI_SJIS_L1,  // 股
	0x80E1, KANJI_SJIS_L1,  // 胡
	0x83F0, KANJI_SJIS_L1,  // 菰
	0x864E, KANJI_SJIS_L1,  // 虎
	0x8A87, KANJI_SJIS_L1,  // 誇
	0x8DE8, KANJI_SJIS_L1,  // 跨
	0x9237, KANJI_SJIS_L1,  // 鈷
	0x96C7, KANJI_SJIS_L1,  // 雇
	0x9867, KANJI_SJIS_L1,  // 顧
	0x9F13, KANJI_SJIS_L1,  // 鼓
	0x4E94, KANJI_SJIS_L1,  // 五
	0x4E92, KANJI_SJIS_L1,  // 互
	0x4F0D, KANJI_SJIS_L1,  // 伍
	0x5348, KANJI_SJIS_L1,  // 午
	0x5449, KANJI_SJIS_L1,  // 呉
	0x543E, KANJI_SJIS_L1,  // 吾
	0x5A2F, KANJI_SJIS_L1,  // 娯
	0x5F8C, KANJI_SJIS_L1,  // 後
	0x5FA1, KANJI_SJIS_L1,  // 御
	0x609F, KANJI_SJIS_L1,  // 悟
	0x68A7, KANJI_SJIS_L1,  // 梧
	0x6A8E, KANJI_SJIS_L1,  // 檎
	0x745A, KANJI_SJIS_L1,  // 瑚
	0x7881, KANJI_SJIS_L1,  // 碁
	0x8A9E, KANJI_SJIS_L1,  // 語
	0x8AA4, KANJI_SJIS_L1,  // 誤
	0x8B77, KANJI_SJIS_L1,  // 護
	0x9190, KANJI_SJIS_L1,  // 醐
	0x4E5E, KANJI_SJIS_L1,  // 乞
	0x9BC9, KANJI_SJIS_L1,  // 鯉
	0x4EA4, KANJI_SJIS_L1,  // 交
	0x4F7C, KANJI_SJIS_L1,  // 佼
	0x4FAF, KANJI_SJIS_L1,  // 侯
	0x5019, KANJI_SJIS_L1,  // 候
	0x5016, KANJI_SJIS_L1,  // 倖
	0x5149, KANJI_SJIS_L1,  // 光
	0x516C, KANJI_SJIS_L1,  // 公
	0x529F, KANJI_SJIS_L1,  // 功
	0x52B9, KANJI_SJIS_L1,  // 効
	0x52FE, KANJI_SJIS_L1,  // 勾
	0x539A, KANJI_SJIS_L1,  // 厚
	0x53E3, KANJI_SJIS_L1,  // 口
	0x5411, KANJI_SJIS_L1,  // 向
	0x540E, KANJI_SJIS_L1,  // 后
	0x5589, KANJI_SJIS_L1,  // 喉
	0x5751, KANJI_SJIS_L1,  // 坑
	0x57A2, KANJI_SJIS_L1,  // 垢
	0x597D, KANJI_SJIS_L1,  // 好
	0x5B54, KANJI_SJIS_L1,  // 孔
	0x5B5D, KANJI_SJIS_L1,  // 孝
	0x5B8F, KANJI_SJIS_L1,  // 宏
	0x5DE5, KANJI_SJIS_L1,  // 工
	0x5DE7, KANJI_SJIS_L1,  // 巧
	0x5DF7, KANJI_SJIS_L1,  // 巷
	0x5E78, KANJI_SJIS_L1,  // 幸
	0x5E83, KANJI_SJIS_L1,  // 広
	0x5E9A, KANJI_SJIS_L1,  // 庚
	0x5EB7, KANJI_SJIS_L1,  // 康
	0x5F18, KANJI_SJIS_L1,  // 弘
	0x6052, KANJI_SJIS_L1,  // 恒
	0x614C, KANJI_SJIS_L1,  // 慌
	0x6297, KANJI_SJIS_L1,  // 抗
	0x62D8, KANJI_SJIS_L1,  // 拘
	0x63A7, KANJI_SJIS_L1,  // 控
	0x653B, KANJI_SJIS_L1,  // 攻
	0x6602, KANJI_SJIS_L1,  // 昂
	0x6643, KANJI_SJIS_L1,  // 晃
	0x66F4, KANJI_SJIS_L1,  // 更
	0x676D, KANJI_SJIS_L1,  // 杭
	0x6821, KANJI_SJIS_L1,  // 校
	0x6897, KANJI_SJIS_L1,  // 梗
	0x69CB, KANJI_SJIS_L1,  // 構
	0x6C5F, KANJI_SJIS_L1,  // 江
	0x6D2A, KANJI_SJIS_L1,  // 洪
	0x6D69, KANJI_SJIS_L1,  // 浩
	0x6E2F, KANJI_SJIS_L1,  // 港
	0x6E9D, KANJI_SJIS_L1,  // 溝
	0x7532, KANJI_SJIS_L1,  // 甲
	0x7687, KANJI_SJIS_L1,  // 皇
	0x786C, KANJI_SJIS_L1,  // 硬
	0x7A3F, KANJI_SJIS_L1,  // 稿
	0x7CE0, KANJI_SJIS_L1,  // 糠
	0x7D05, KANJI_SJIS_L1,  // 紅
	0x7D18, KANJI_SJIS_L1,  // 紘
	0x7D5E, KANJI_SJIS_L1,  // 絞
	0x7DB1, KANJI_SJIS_L1,  // 綱
	0x8015, KANJI_SJIS_L1,  // 耕
	0x8003, KANJI_SJIS_L1,  // 考
	0x80AF, KANJI_SJIS_L1,  // 肯
	0x80B1, KANJI_SJIS_L1,  // 肱
	0x8154, KANJI_SJIS_L1,  // 腔
	0x818F, KANJI_SJIS_L1,  // 膏
	0x822A, KANJI_SJIS_L1,  // 航
	0x8352, KANJI_SJIS_L1,  // 荒
	0x884C, KANJI_SJIS_L1,  // 行
	0x8861, KANJI_SJIS_L1,  // 衡
	0x8B1B, KANJI_SJIS_L1,  // 講
	0x8CA2, KANJI_SJIS_L1,  // 貢
	0x8CFC, KANJI_SJIS_L1,  // 購
	0x90CA, KANJI_SJIS_L1,  // 郊
	0x9175, KANJI_SJIS_L1,  // 酵
	0x9271, KANJI_SJIS_L1,  // 鉱
	0x783F, KANJI_SJIS_L1,  // 砿
	0x92FC, KANJI_SJIS_L1,  // 鋼
	0x95A4, KANJI_SJIS_L1,  // 閤
	0x964D, KANJI_SJIS_L1,  // 降
	0x3000, KANJI_SJIS_L1,  // 　
	0x9805, KANJI_SJIS_L1,  // 項
	0x9999, KANJI_SJIS_L1,  // 香
	0x9AD8, KANJI_SJIS_L1,  // 高
	0x9D3B, KANJI_SJIS_L1,  // 鴻
	0x525B, KANJI_SJIS_L1,  // 剛
	0x52AB, KANJI_SJIS_L1,  // 劫
	0x53F7, KANJI_SJIS_L1,  // 号
	0x5408, KANJI_SJIS_L1,  // 合
	0x58D5, KANJI_SJIS_L1,  // 壕
	0x62F7, KANJI_SJIS_L1,  // 拷
	0x6FE0, KANJI_SJIS_L1,  // 濠
	0x8C6A, KANJI_SJIS_L1,  // 豪
	0x8F5F, KANJI_SJIS_L1,  // 轟
	0x9EB9, KANJI_SJIS_L1,  // 麹
	0x514B, KANJI_SJIS_L1,  // 克
	0x523B, KANJI_SJIS_L1,  // 刻
	0x544A, KANJI_SJIS_L1,  // 告
	0x56FD, KANJI_SJIS_L1,  // 国
	0x7A40, KANJI_SJIS_L1,  // 穀
	0x9177, KANJI_SJIS_L1,  // 酷
	0x9D60, KANJI_SJIS_L1,  // 鵠
	0x9ED2, KANJI_SJIS_L1,  // 黒
	0x7344, KANJI_SJIS_L1,  // 獄
	0x6F09, KANJI_SJIS_L1,  // 漉
	0x8170, KANJI_SJIS_L1,  // 腰
	0x7511, KANJI_SJIS_L1,  // 甑
	0x5FFD, KANJI_SJIS_L1,  // 忽
	0x60DA, KANJI_SJIS_L1,  // 惚
	0x9AA8, KANJI_SJIS_L1,  // 骨
	0x72DB, KANJI_SJIS_L1,  // 狛
	0x8FBC, KANJI_SJIS_L1,  // 込
	0x6B64, KANJI_SJIS_L1,  // 此
	0x9803, KANJI_SJIS_L1,  // 頃
	0x4ECA, KANJI_SJIS_L1,  // 今
	0x56F0, KANJI_SJIS_L1,  // 困
	0x5764, KANJI_SJIS_L1,  // 坤
	0x58BE, KANJI_SJIS_L1,  // 墾
	0x5A5A, KANJI_SJIS_L1,  // 婚
	0x6068, KANJI_SJIS_L1,  // 恨
	0x61C7, KANJI_SJIS_L1,  // 懇
	0x660F, KANJI_SJIS_L1,  // 昏
	0x6606, KANJI_SJIS_L1,  // 昆
	0x6839, KANJI_SJIS_L1,  // 根
	0x68B1, KANJI_SJIS_L1,  // 梱
	0x6DF7, KANJI_SJIS_L1,  // 混
	0x75D5, KANJI_SJIS_L1,  // 痕
	0x7D3A, KANJI_SJIS_L1,  // 紺
	0x826E, KANJI_SJIS_L1,  // 艮
	0x9B42, KANJI_SJIS_L1,  // 魂
	0x4E9B, KANJI_SJIS_L1,  // 些
	0x4F50, KANJI_SJIS_L1,  // 佐
	0x53C9, KANJI_SJIS_L1,  // 叉
	0x5506, KANJI_SJIS_L1,  // 唆
	0x5D6F, KANJI_SJIS_L1,  // 嵯
	0x5DE6, KANJI_SJIS_L1,  // 左
	0x5DEE, KANJI_SJIS_L1,  // 差
	0x67FB, KANJI_SJIS_L1,  // 査
	0x6C99, KANJI_SJIS_L1,  // 沙
	0x7473, KANJI_SJIS_L1,  // 瑳
	0x7802, KANJI_SJIS_L1,  // 砂
	0x8A50, KANJI_SJIS_L1,  // 詐
	0x9396, KANJI_SJIS_L1,  // 鎖
	0x88DF, KANJI_SJIS_L1,  // 裟
	0x5750, KANJI_SJIS_L1,  // 坐
	0x5EA7, KANJI_SJIS_L1,  // 座
	0x632B, KANJI_SJIS_L1,  // 挫
	0x50B5, KANJI_SJIS_L1,  // 債
	0x50AC, KANJI_SJIS_L1,  // 催
	0x518D, KANJI_SJIS_L1,  // 再
	0x6700, KANJI_SJIS_L1,  // 最
	0x54C9, KANJI_SJIS_L1,  // 哉
	0x585E, KANJI_SJIS_L1,  // 塞
	0x59BB, KANJI_SJIS_L1,  // 妻
	0x5BB0, KANJI_SJIS_L1,  // 宰
	0x5F69, KANJI_SJIS_L1,  // 彩
	0x624D, KANJI_SJIS_L1,  // 才
	0x63A1, KANJI_SJIS_L1,  // 採
	0x683D, KANJI_SJIS_L1,  // 栽
	0x6B73, KANJI_SJIS_L1,  // 歳
	0x6E08, KANJI_SJIS_L1,  // 済
	0x707D, KANJI_SJIS_L1,  // 災
	0x91C7, KANJI_SJIS_L1,  // 采
	0x7280, KANJI_SJIS_L1,  // 犀
	0x7815, KANJI_SJIS_L1,  // 砕
	0x7826, KANJI_SJIS_L1,  // 砦
	0x796D, KANJI_SJIS_L1,  // 祭
	0x658E, KANJI_SJIS_L1,  // 斎
	0x7D30, KANJI_SJIS_L1,  // 細
	0x83DC, KANJI_SJIS_L1,  // 菜
	0x88C1, KANJI_SJIS_L1,  // 裁
	0x8F09, KANJI_SJIS_L1,  // 載
	0x969B, KANJI_SJIS_L1,  // 際
	0x5264, KANJI_SJIS_L1,  // 剤
	0x5728, KANJI_SJIS_L1,  // 在
	0x6750, KANJI_SJIS_L1,  // 材
	0x7F6A, KANJI_SJIS_L1,  // 罪
	0x8CA1, KANJI_SJIS_L1,  // 財
	0x51B4, KANJI_SJIS_L1,  // 冴
	0x5742, KANJI_SJIS_L1,  // 坂
	0x962A, KANJI_SJIS_L1,  // 阪
	0x583A, KANJI_SJIS_L1,  // 堺
	0x698A, KANJI_SJIS_L1,  // 榊
	0x80B4, KANJI_SJIS_L1,  // 肴
	0x54B2, KANJI_SJIS_L1,  // 咲
	0x5D0E, KANJI_SJIS_L1,  // 崎
	0x57FC, KANJI_SJIS_L1,  // 埼
	0x7895, KANJI_SJIS_L1,  // 碕
	0x9DFA, KANJI_SJIS_L1,  // 鷺
	0x4F5C, KANJI_SJIS_L1,  // 作
	0x524A, KANJI_SJIS_L1,  // 削
	0x548B, KANJI_SJIS_L1,  // 咋
	0x643E, KANJI_SJIS_L1,  // 搾
	0x6628, KANJI_SJIS_L1,  // 昨
	0x6714, KANJI_SJIS_L1,  // 朔
	0x67F5, KANJI_SJIS_L1,  // 柵
	0x7A84, KANJI_SJIS_L1,  // 窄
	0x7B56, KANJI_SJIS_L1,  // 策
	0x7D22, KANJI_SJIS_L1,  // 索
	0x932F, KANJI_SJIS_L1,  // 錯
	0x685C, KANJI_SJIS_L1,  // 桜
	0x9BAD, KANJI_SJIS_L1,  // 鮭
	0x7B39, KANJI_SJIS_L1,  // 笹
	0x5319, KANJI_SJIS_L1,  // 匙
	0x518A, KANJI_SJIS_L1,  // 冊
	0x5237, KANJI_SJIS_L1,  // 刷
	0x5BDF, KANJI_SJIS_L1,  // 察
	0x62F6, KANJI_SJIS_L1,  // 拶
	0x64AE, KANJI_SJIS_L1,  // 撮
	0x64E6, KANJI_SJIS_L1,  // 擦
	0x672D, KANJI_SJIS_L1,  // 札
	0x6BBA, KANJI_SJIS_L1,  // 殺
	0x85A9, KANJI_SJIS_L1,  // 薩
	0x96D1, KANJI_SJIS_L1,  // 雑
	0x7690, KANJI_SJIS_L1,  // 皐
	0x9BD6, KANJI_SJIS_L1,  // 鯖
	0x634C, KANJI_SJIS_L1,  // 捌
	0x9306, KANJI_SJIS_L1,  // 錆
	0x9BAB, KANJI_SJIS_L1,  // 鮫
	0x76BF, KANJI_SJIS_L1,  // 皿
	0x6652, KANJI_SJIS_L1,  // 晒
	0x4E09, KANJI_SJIS_L1,  // 三
	0x5098, KANJI_SJIS_L1,  // 傘
	0x53C2, KANJI_SJIS_L1,  // 参
	0x5C71, KANJI_SJIS_L1,  // 山
	0x60E8, KANJI_SJIS_L1,  // 惨
	0x6492, KANJI_SJIS_L1,  // 撒
	0x6563, KANJI_SJIS_L1,  // 散
	0x685F, KANJI_SJIS_L1,  // 桟
	0x71E6, KANJI_SJIS_L1,  // 燦
	0x73CA, KANJI_SJIS_L1,  // 珊
	0x7523, KANJI_SJIS_L1,  // 産
	0x7B97, KANJI_SJIS_L1,  // 算
	0x7E82, KANJI_SJIS_L1,  // 纂
	0x8695, KANJI_SJIS_L1,  // 蚕
	0x8B83, KANJI_SJIS_L1,  // 讃
	0x8CDB, KANJI_SJIS_L1,  // 賛
	0x9178, KANJI_SJIS_L1,  // 酸
	0x9910, KANJI_SJIS_L1,  // 餐
	0x65AC, KANJI_SJIS_L1,  // 斬
	0x66AB, KANJI_SJIS_L1,  // 暫
	0x6B8B, KANJI_SJIS_L1,  // 残
	0x4ED5, KANJI_SJIS_L1,  // 仕
	0x4ED4, KANJI_SJIS_L1,  // 仔
	0x4F3A, KANJI_SJIS_L1,  // 伺
	0x4F7F, KANJI_SJIS_L1,  // 使
	0x523A, KANJI_SJIS_L1,  // 刺
	0x53F8, KANJI_SJIS_L1,  // 司
	0x53F2, KANJI_SJIS_L1,  // 史
	0x55E3, KANJI_SJIS_L1,  // 嗣
	0x56DB, KANJI_SJIS_L1,  // 四
	0x58EB, KANJI_SJIS_L1,  // 士
	0x59CB, KANJI_SJIS_L1,  // 始
	0x59C9, KANJI_SJIS_L1,  // 姉
	0x59FF, KANJI_SJIS_L1,  // 姿
	0x5B50, KANJI_SJIS_L1,  // 子
	0x5C4D, KANJI_SJIS_L1,  // 屍
	0x5E02, KANJI_SJIS_L1,  // 市
	0x5E2B, KANJI_SJIS_L1,  // 師
	0x5FD7, KANJI_SJIS_L1,  // 志
	0x601D, KANJI_SJIS_L1,  // 思
	0x6307, KANJI_SJIS_L1,  // 指
	0x652F, KANJI_SJIS_L1,  // 支
	0x5B5C, KANJI_SJIS_L1,  // 孜
	0x65AF, KANJI_SJIS_L1,  // 斯
	0x65BD, KANJI_SJIS_L1,  // 施
	0x65E8, KANJI_SJIS_L1,  // 旨
	0x679D, KANJI_SJIS_L1,  // 枝
	0x6B62, KANJI_SJIS_L1,  // 止
	0x3000, KANJI_SJIS_L1,  // 　
	0x6B7B, KANJI_SJIS_L1,  // 死
	0x6C0F, KANJI_SJIS_L1,  // 氏
	0x7345, KANJI_SJIS_L1,  // 獅
	0x7949, KANJI_SJIS_L1,  // 祉
	0x79C1, KANJI_SJIS_L1,  // 私
	0x7CF8, KANJI_SJIS_L1,  // 糸
	0x7D19, KANJI_SJIS_L1,  // 紙
	0x7D2B, KANJI_SJIS_L1,  // 紫
	0x80A2, KANJI_SJIS_L1,  // 肢
	0x8102, KANJI_SJIS_L1,  // 脂
	0x81F3, KANJI_SJIS_L1,  // 至
	0x8996, KANJI_SJIS_L1,  // 視
	0x8A5E, KANJI_SJIS_L1,  // 詞
	0x8A69, KANJI_SJIS_L1,  // 詩
	0x8A66, KANJI_SJIS_L1,  // 試
	0x8A8C, KANJI_SJIS_L1,  // 誌
	0x8AEE, KANJI_SJIS_L1,  // 諮
	0x8CC7, KANJI_SJIS_L1,  // 資
	0x8CDC, KANJI_SJIS_L1,  // 賜
	0x96CC, KANJI_SJIS_L1,  // 雌
	0x98FC, KANJI_SJIS_L1,  // 飼
	0x6B6F, KANJI_SJIS_L1,  // 歯
	0x4E8B, KANJI_SJIS_L1,  // 事
	0x4F3C, KANJI_SJIS_L1,  // 似
	0x4F8D, KANJI_SJIS_L1,  // 侍
	0x5150, KANJI_SJIS_L1,  // 児
	0x5B57, KANJI_SJIS_L1,  // 字
	0x5BFA, KANJI_SJIS_L1,  // 寺
	0x6148, KANJI_SJIS_L1,  // 慈
	0x6301, KANJI_SJIS_L1,  // 持
	0x6642, KANJI_SJIS_L1,  // 時
	0x6B21, KANJI_SJIS_L1,  // 次
	0x6ECB, KANJI_SJIS_L1,  // 滋
	0x6CBB, KANJI_SJIS_L1,  // 治
	0x723E, KANJI_SJIS_L1,  // 爾
	0x74BD, KANJI_SJIS_L1,  // 璽
	0x75D4, KANJI_SJIS_L1,  // 痔
	0x78C1, KANJI_SJIS_L1,  // 磁
	0x793A, KANJI_SJIS_L1,  // 示
	0x800C, KANJI_SJIS_L1,  // 而
	0x8033, KANJI_SJIS_L1,  // 耳
	0x81EA, KANJI_SJIS_L1,  // 自
	0x8494, KANJI_SJIS_L1,  // 蒔
	0x8F9E, KANJI_SJIS_L1,  // 辞
	0x6C50, KANJI_SJIS_L1,  // 汐
	0x9E7F, KANJI_SJIS_L1,  // 鹿
	0x5F0F, KANJI_SJIS_L1,  // 式
	0x8B58, KANJI_SJIS_L1,  // 識
	0x9D2B, KANJI_SJIS_L1,  // 鴫
	0x7AFA, KANJI_SJIS_L1,  // 竺
	0x8EF8, KANJI_SJIS_L1,  // 軸
	0x5B8D, KANJI_SJIS_L1,  // 宍
	0x96EB, KANJI_SJIS_L1,  // 雫
	0x4E03, KANJI_SJIS_L1,  // 七
	0x53F1, KANJI_SJIS_L1,  // 叱
	0x57F7, KANJI_SJIS_L1,  // 執
	0x5931, KANJI_SJIS_L1,  // 失
	0x5AC9, KANJI_SJIS_L1,  // 嫉
	0x5BA4, KANJI_SJIS_L1,  // 室
	0x6089, KANJI_SJIS_L1,  // 悉
	0x6E7F, KANJI_SJIS_L1,  // 湿
	0x6F06, KANJI_SJIS_L1,  // 漆
	0x75BE, KANJI_SJIS_L1,  // 疾
	0x8CEA, KANJI_SJIS_L1,  // 質
	0x5B9F, KANJI_SJIS_L1,  // 実
	0x8500, KANJI_SJIS_L1,  // 蔀
	0x7BE0, KANJI_SJIS_L1,  // 篠
	0x5072, KANJI_SJIS_L1,  // 偲
	0x67F4, KANJI_SJIS_L1,  // 柴
	0x829D, KANJI_SJIS_L1,  // 芝
	0x5C61, KANJI_SJIS_L1,  // 屡
	0x854A, KANJI_SJIS_L1,  // 蕊
	0x7E1E, KANJI_SJIS_L1,  // 縞
	0x820E, KANJI_SJIS_L1,  // 舎
	0x5199, KANJI_SJIS_L1,  // 写
	0x5C04, KANJI_SJIS_L1,  // 射
	0x6368, KANJI_SJIS_L1,  // 捨
	0x8D66, KANJI_SJIS_L1,  // 赦
	0x659C, KANJI_SJIS_L1,  // 斜
	0x716E, KANJI_SJIS_L1,  // 煮
	0x793E, KANJI_SJIS_L1,  // 社
	0x7D17, KANJI_SJIS_L1,  // 紗
	0x8005, KANJI_SJIS_L1,  // 者
	0x8B1D, KANJI_SJIS_L1,  // 謝
	0x8ECA, KANJI_SJIS_L1,  // 車
	0x906E, KANJI_SJIS_L1,  // 遮
	0x86C7, KANJI_SJIS_L1,  // 蛇
	0x90AA, KANJI_SJIS_L1,  // 邪
	0x501F, KANJI_SJIS_L1,  // 借
	0x52FA, KANJI_SJIS_L1,  // 勺
	0x5C3A, KANJI_SJIS_L1,  // 尺
	0x6753, KANJI_SJIS_L1,  // 杓
	0x707C, KANJI_SJIS_L1,  // 灼
	0x7235, KANJI_SJIS_L1,  // 爵
	0x914C, KANJI_SJIS_L1,  // 酌
	0x91C8, KANJI_SJIS_L1,  // 釈
	0x932B, KANJI_SJIS_L1,  // 錫
	0x82E5, KANJI_SJIS_L1,  // 若
	0x5BC2, KANJI_SJIS_L1,  // 寂
	0x5F31, KANJI_SJIS_L1,  // 弱
	0x60F9, KANJI_SJIS_L1,  // 惹
	0x4E3B, KANJI_SJIS_L1,  // 主
	0x53D6, KANJI_SJIS_L1,  // 取
	0x5B88, KANJI_SJIS_L1,  // 守
	0x624B, KANJI_SJIS_L1,  // 手
	0x6731, KANJI_SJIS_L1,  // 朱
	0x6B8A, KANJI_SJIS_L1,  // 殊
	0x72E9, KANJI_SJIS_L1,  // 狩
	0x73E0, KANJI_SJIS_L1,  // 珠
	0x7A2E, KANJI_SJIS_L1,  // 種
	0x816B, KANJI_SJIS_L1,  // 腫
	0x8DA3, KANJI_SJIS_L1,  // 趣
	0x9152, KANJI_SJIS_L1,  // 酒
	0x9996, KANJI_SJIS_L1,  // 首
	0x5112, KANJI_SJIS_L1,  // 儒
	0x53D7, KANJI_SJIS_L1,  // 受
	0x546A, KANJI_SJIS_L1,  // 呪
	0x5BFF, KANJI_SJIS_L1,  // 寿
	0x6388, KANJI_SJIS_L1,  // 授
	0x6A39, KANJI_SJIS_L1,  // 樹
	0x7DAC, KANJI_SJIS_L1,  // 綬
	0x9700, KANJI_SJIS_L1,  // 需
	0x56DA, KANJI_SJIS_L1,  // 囚
	0x53CE, KANJI_SJIS_L1,  // 収
	0x5468, KANJI_SJIS_L1,  // 周
	0x5B97, KANJI_SJIS_L1,  // 宗
	0x5C31, KANJI_SJIS_L1,  // 就
	0x5DDE, KANJI_SJIS_L1,  // 州
	0x4FEE, KANJI_SJIS_L1,  // 修
	0x6101, KANJI_SJIS_L1,  // 愁
	0x62FE, KANJI_SJIS_L1,  // 拾
	0x6D32, KANJI_SJIS_L1,  // 洲
	0x79C0, KANJI_SJIS_L1,  // 秀
	0x79CB, KANJI_SJIS_L1,  // 秋
	0x7D42, KANJI_SJIS_L1,  // 終
	0x7E4D, KANJI_SJIS_L1,  // 繍
	0x7FD2, KANJI_SJIS_L1,  // 習
	0x81ED, KANJI_SJIS_L1,  // 臭
	0x821F, KANJI_SJIS_L1,  // 舟
	0x8490, KANJI_SJIS_L1,  // 蒐
	0x8846, KANJI_SJIS_L1,  // 衆
	0x8972, KANJI_SJIS_L1,  // 襲
	0x8B90, KANJI_SJIS_L1,  // 讐
	0x8E74, KANJI_SJIS_L1,  // 蹴
	0x8F2F, KANJI_SJIS_L1,  // 輯
	0x9031, KANJI_SJIS_L1,  // 週
	0x914B, KANJI_SJIS_L1,  // 酋
	0x916C, KANJI_SJIS_L1,  // 酬
	0x96C6, KANJI_SJIS_L1,  // 集
	0x919C, KANJI_SJIS_L1,  // 醜
	0x4EC0, KANJI_SJIS_L1,  // 什
	0x4F4F, KANJI_SJIS_L1,  // 住
	0x5145, KANJI_SJIS_L1,  // 充
	0x5341, KANJI_SJIS_L1,  // 十
	0x5F93, KANJI_SJIS_L1,  // 従
	0x620E, KANJI_SJIS_L1,  // 戎
	0x67D4, KANJI_SJIS_L1,  // 柔
	0x6C41, KANJI_SJIS_L1,  // 汁
	0x6E0B, KANJI_SJIS_L1,  // 渋
	0x7363, KANJI_SJIS_L1,  // 獣
	0x7E26, KANJI_SJIS_L1,  // 縦
	0x91CD, KANJI_SJIS_L1,  // 重
	0x9283, KANJI_SJIS_L1,  // 銃
	0x53D4, KANJI_SJIS_L1,  // 叔
	0x5919, KANJI_SJIS_L1,  // 夙
	0x5BBF, KANJI_SJIS_L1,  // 宿
	0x6DD1, KANJI_SJIS_L1,  // 淑
	0x795D, KANJI_SJIS_L1,  // 祝
	0x7E2E, KANJI_SJIS_L1,  // 縮
	0x7C9B, KANJI_SJIS_L1,  // 粛
	0x587E, KANJI_SJIS_L1,  // 塾
	0x719F, KANJI_SJIS_L1,  // 熟
	0x51FA, KANJI_SJIS_L1,  // 出
	0x8853, KANJI_SJIS_L1,  // 術
	0x8FF0, KANJI_SJIS_L1,  // 述
	0x4FCA, KANJI_SJIS_L1,  // 俊
	0x5CFB, KANJI_SJIS_L1,  // 峻
	0x6625, KANJI_SJIS_L1,  // 春
	0x77AC, KANJI_SJIS_L1,  // 瞬
	0x7AE3, KANJI_SJIS_L1,  // 竣
	0x821C, KANJI_SJIS_L1,  // 舜
	0x99FF, KANJI_SJIS_L1,  // 駿
	0x51C6, KANJI_SJIS_L1,  // 准
	0x5FAA, KANJI_SJIS_L1,  // 循
	0x65EC, KANJI_SJIS_L1,  // 旬
	0x696F, KANJI_SJIS_L1,  // 楯
	0x6B89, KANJI_SJIS_L1,  // 殉
	0x6DF3, KANJI_SJIS_L1,  // 淳
	0x3000, KANJI_SJIS_L1,  // 　
	0x6E96, KANJI_SJIS_L1,  // 準
	0x6F64, KANJI_SJIS_L1,  // 潤
	0x76FE, KANJI_SJIS_L1,  // 盾
	0x7D14, KANJI_SJIS_L1,  // 純
	0x5DE1, KANJI_SJIS_L1,  // 巡
	0x9075, KANJI_SJIS_L1,  // 遵
	0x9187, KANJI_SJIS_L1,  // 醇
	0x9806, KANJI_SJIS_L1,  // 順
	0x51E6, KANJI_SJIS_L1,  // 処
	0x521D, KANJI_SJIS_L1,  // 初
	0x6240, KANJI_SJIS_L1,  // 所
	0x6691, KANJI_SJIS_L1,  // 暑
	0x66D9, KANJI_SJIS_L1,  // 曙
	0x6E1A, KANJI_SJIS_L1,  // 渚
	0x5EB6, KANJI_SJIS_L1,  // 庶
	0x7DD2, KANJI_SJIS_L1,  // 緒
	0x7F72, KANJI_SJIS_L1,  // 署
	0x66F8, KANJI_SJIS_L1,  // 書
	0x85AF, KANJI_SJIS_L1,  // 薯
	0x85F7, KANJI_SJIS_L1,  // 藷
	0x8AF8, KANJI_SJIS_L1,  // 諸
	0x52A9, KANJI_SJIS_L1,  // 助
	0x53D9, KANJI_SJIS_L1,  // 叙
	0x5973, KANJI_SJIS_L1,  // 女
	0x5E8F, KANJI_SJIS_L1,  // 序
	0x5F90, KANJI_SJIS_L1,  // 徐
	0x6055, KANJI_SJIS_L1,  // 恕
	0x92E4, KANJI_SJIS_L1,  // 鋤
	0x9664, KANJI_SJIS_L1,  // 除
	0x50B7, KANJI_SJIS_L1,  // 傷
	0x511F, KANJI_SJIS_L1,  // 償
	0x52DD, KANJI_SJIS_L1,  // 勝
	0x5320, KANJI_SJIS_L1,  // 匠
	0x5347, KANJI_SJIS_L1,  // 升
	0x53EC, KANJI_SJIS_L1,  // 召
	0x54E8, KANJI_SJIS_L1,  // 哨
	0x5546, KANJI_SJIS_L1,  // 商
	0x5531, KANJI_SJIS_L1,  // 唱
	0x5617, KANJI_SJIS_L1,  // 嘗
	0x5968, KANJI_SJIS_L1,  // 奨
	0x59BE, KANJI_SJIS_L1,  // 妾
	0x5A3C, KANJI_SJIS_L1,  // 娼
	0x5BB5, KANJI_SJIS_L1,  // 宵
	0x5C06, KANJI_SJIS_L1,  // 将
	0x5C0F, KANJI_SJIS_L1,  // 小
	0x5C11, KANJI_SJIS_L1,  // 少
	0x5C1A, KANJI_SJIS_L1,  // 尚
	0x5E84, KANJI_SJIS_L1,  // 庄
	0x5E8A, KANJI_SJIS_L1,  // 床
	0x5EE0, KANJI_SJIS_L1,  // 廠
	0x5F70, KANJI_SJIS_L1,  // 彰
	0x627F, KANJI_SJIS_L1,  // 承
	0x6284, KANJI_SJIS_L1,  // 抄
	0x62DB, KANJI_SJIS_L1,  // 招
	0x638C, KANJI_SJIS_L1,  // 掌
	0x6377, KANJI_SJIS_L1,  // 捷
	0x6607, KANJI_SJIS_L1,  // 昇
	0x660C, KANJI_SJIS_L1,  // 昌
	0x662D, KANJI_SJIS_L1,  // 昭
	0x6676, KANJI_SJIS_L1,  // 晶
	0x677E, KANJI_SJIS_L1,  // 松
	0x68A2, KANJI_SJIS_L1,  // 梢
	0x6A1F, KANJI_SJIS_L1,  // 樟
	0x6A35, KANJI_SJIS_L1,  // 樵
	0x6CBC, KANJI_SJIS_L1,  // 沼
	0x6D88, KANJI_SJIS_L1,  // 消
	0x6E09, KANJI_SJIS_L1,  // 渉
	0x6E58, KANJI_SJIS_L1,  // 湘
	0x713C, KANJI_SJIS_L1,  // 焼
	0x7126, KANJI_SJIS_L1,  // 焦
	0x7167, KANJI_SJIS_L1,  // 照
	0x75C7, KANJI_SJIS_L1,  // 症
	0x7701, KANJI_SJIS_L1,  // 省
	0x785D, KANJI_SJIS_L1,  // 硝
	0x7901, KANJI_SJIS_L1,  // 礁
	0x7965, KANJI_SJIS_L1,  // 祥
	0x79F0, KANJI_SJIS_L1,  // 称
	0x7AE0, KANJI_SJIS_L1,  // 章
	0x7B11, KANJI_SJIS_L1,  // 笑
	0x7CA7, KANJI_SJIS_L1,  // 粧
	0x7D39, KANJI_SJIS_L1,  // 紹
	0x8096, KANJI_SJIS_L1,  // 肖
	0x83D6, KANJI_SJIS_L1,  // 菖
	0x848B, KANJI_SJIS_L1,  // 蒋
	0x8549, KANJI_SJIS_L1,  // 蕉
	0x885D, KANJI_SJIS_L1,  // 衝
	0x88F3, KANJI_SJIS_L1,  // 裳
	0x8A1F, KANJI_SJIS_L1,  // 訟
	0x8A3C, KANJI_SJIS_L1,  // 証
	0x8A54, KANJI_SJIS_L1,  // 詔
	0x8A73, KANJI_SJIS_L1,  // 詳
	0x8C61, KANJI_SJIS_L1,  // 象
	0x8CDE, KANJI_SJIS_L1,  // 賞
	0x91A4, KANJI_SJIS_L1,  // 醤
	0x9266, KANJI_SJIS_L1,  // 鉦
	0x937E, KANJI_SJIS_L1,  // 鍾
	0x9418, KANJI_SJIS_L1,  // 鐘
	0x969C, KANJI_SJIS_L1,  // 障
	0x9798, KANJI_SJIS_L1,  // 鞘
	0x4E0A, KANJI_SJIS_L1,  // 上
	0x4E08, KANJI_SJIS_L1,  // 丈
	0x4E1E, KANJI_SJIS_L1,  // 丞
	0x4E57, KANJI_SJIS_L1,  // 乗
	0x5197, KANJI_SJIS_L1,  // 冗
	0x5270, KANJI_SJIS_L1,  // 剰
	0x57CE, KANJI_SJIS_L1,  // 城
	0x5834, KANJI_SJIS_L1,  // 場
	0x58CC, KANJI_SJIS_L1,  // 壌
	0x5B22, KANJI_SJIS_L1,  // 嬢
	0x5E38, KANJI_SJIS_L1,  // 常
	0x60C5, KANJI_SJIS_L1,  // 情
	0x64FE, KANJI_SJIS_L1,  // 擾
	0x6761, KANJI_SJIS_L1,  // 条
	0x6756, KANJI_SJIS_L1,  // 杖
	0x6D44, KANJI_SJIS_L1,  // 浄
	0x72B6, KANJI_SJIS_L1,  // 状
	0x7573, KANJI_SJIS_L1,  // 畳
	0x7A63, KANJI_SJIS_L1,  // 穣
	0x84B8, KANJI_SJIS_L1,  // 蒸
	0x8B72, KANJI_SJIS_L1,  // 譲
	0x91B8, KANJI_SJIS_L1,  // 醸
	0x9320, KANJI_SJIS_L1,  // 錠
	0x5631, KANJI_SJIS_L1,  // 嘱
	0x57F4, KANJI_SJIS_L1,  // 埴
	0x98FE, KANJI_SJIS_L1,  // 飾
	0x62ED, KANJI_SJIS_L1,  // 拭
	0x690D, KANJI_SJIS_L1,  // 植
	0x6B96, KANJI_SJIS_L1,  // 殖
	0x71ED, KANJI_SJIS_L1,  // 燭
	0x7E54, KANJI_SJIS_L1,  // 織
	0x8077, KANJI_SJIS_L1,  // 職
	0x8272, KANJI_SJIS_L1,  // 色
	0x89E6, KANJI_SJIS_L1,  // 触
	0x98DF, KANJI_SJIS_L1,  // 食
	0x8755, KANJI_SJIS_L1,  // 蝕
	0x8FB1, KANJI_SJIS_L1,  // 辱
	0x5C3B, KANJI_SJIS_L1,  // 尻
	0x4F38, KANJI_SJIS_L1,  // 伸
	0x4FE1, KANJI_SJIS_L1,  // 信
	0x4FB5, KANJI_SJIS_L1,  // 侵
	0x5507, KANJI_SJIS_L1,  // 唇
	0x5A20, KANJI_SJIS_L1,  // 娠
	0x5BDD, KANJI_SJIS_L1,  // 寝
	0x5BE9, KANJI_SJIS_L1,  // 審
	0x5FC3, KANJI_SJIS_L1,  // 心
	0x614E, KANJI_SJIS_L1,  // 慎
	0x632F, KANJI_SJIS_L1,  // 振
	0x65B0, KANJI_SJIS_L1,  // 新
	0x664B, KANJI_SJIS_L1,  // 晋
	0x68EE, KANJI_SJIS_L1,  // 森
	0x699B, KANJI_SJIS_L1,  // 榛
	0x6D78, KANJI_SJIS_L1,  // 浸
	0x6DF1, KANJI_SJIS_L1,  // 深
	0x7533, KANJI_SJIS_L1,  // 申
	0x75B9, KANJI_SJIS_L1,  // 疹
	0x771F, KANJI_SJIS_L1,  // 真
	0x795E, KANJI_SJIS_L1,  // 神
	0x79E6, KANJI_SJIS_L1,  // 秦
	0x7D33, KANJI_SJIS_L1,  // 紳
	0x81E3, KANJI_SJIS_L1,  // 臣
	0x82AF, KANJI_SJIS_L1,  // 芯
	0x85AA, KANJI_SJIS_L1,  // 薪
	0x89AA, KANJI_SJIS_L1,  // 親
	0x8A3A, KANJI_SJIS_L1,  // 診
	0x8EAB, KANJI_SJIS_L1,  // 身
	0x8F9B, KANJI_SJIS_L1,  // 辛
	0x9032, KANJI_SJIS_L1,  // 進
	0x91DD, KANJI_SJIS_L1,  // 針
	0x9707, KANJI_SJIS_L1,  // 震
	0x4EBA, KANJI_SJIS_L1,  // 人
	0x4EC1, KANJI_SJIS_L1,  // 仁
	0x5203, KANJI_SJIS_L1,  // 刃
	0x5875, KANJI_SJIS_L1,  // 塵
	0x58EC, KANJI_SJIS_L1,  // 壬
	0x5C0B, KANJI_SJIS_L1,  // 尋
	0x751A, KANJI_SJIS_L1,  // 甚
	0x5C3D, KANJI_SJIS_L1,  // 尽
	0x814E, KANJI_SJIS_L1,  // 腎
	0x8A0A, KANJI_SJIS_L1,  // 訊
	0x8FC5, KANJI_SJIS_L1,  // 迅
	0x9663, KANJI_SJIS_L1,  // 陣
	0x976D, KANJI_SJIS_L1,  // 靭
	0x7B25, KANJI_SJIS_L1,  // 笥
	0x8ACF, KANJI_SJIS_L1,  // 諏
	0x9808, KANJI_SJIS_L1,  // 須
	0x9162, KANJI_SJIS_L1,  // 酢
	0x56F3, KANJI_SJIS_L1,  // 図
	0x53A8, KANJI_SJIS_L1,  // 厨
	0x3000, KANJI_SJIS_L1,  // 　
	0x9017, KANJI_SJIS_L1,  // 逗
	0x5439, KANJI_SJIS_L1,  // 吹
	0x5782, KANJI_SJIS_L1,  // 垂
	0x5E25, KANJI_SJIS_L1,  // 帥
	0x63A8, KANJI_SJIS_L1,  // 推
	0x6C34, KANJI_SJIS_L1,  // 水
	0x708A, KANJI_SJIS_L1,  // 炊
	0x7761, KANJI_SJIS_L1,  // 睡
	0x7C8B, KANJI_SJIS_L1,  // 粋
	0x7FE0, KANJI_SJIS_L1,  // 翠
	0x8870, KANJI_SJIS_L1,  // 衰
	0x9042, KANJI_SJIS_L1,  // 遂
	0x9154, KANJI_SJIS_L1,  // 酔
	0x9310, KANJI_SJIS_L1,  // 錐
	0x9318, KANJI_SJIS_L1,  // 錘
	0x968F, KANJI_SJIS_L1,  // 随
	0x745E, KANJI_SJIS_L1,  // 瑞
	0x9AC4, KANJI_SJIS_L1,  // 髄
	0x5D07, KANJI_SJIS_L1,  // 崇
	0x5D69, KANJI_SJIS_L1,  // 嵩
	0x6570, KANJI_SJIS_L1,  // 数
	0x67A2, KANJI_SJIS_L1,  // 枢
	0x8DA8, KANJI_SJIS_L1,  // 趨
	0x96DB, KANJI_SJIS_L1,  // 雛
	0x636E, KANJI_SJIS_L1,  // 据
	0x6749, KANJI_SJIS_L1,  // 杉
	0x6919, KANJI_SJIS_L1,  // 椙
	0x83C5, KANJI_SJIS_L1,  // 菅
	0x9817, KANJI_SJIS_L1,  // 頗
	0x96C0, KANJI_SJIS_L1,  // 雀
	0x88FE, KANJI_SJIS_L1,  // 裾
	0x6F84, KANJI_SJIS_L1,  // 澄
	0x647A, KANJI_SJIS_L1,  // 摺
	0x5BF8, KANJI_SJIS_L1,  // 寸
	0x4E16, KANJI_SJIS_L1,  // 世
	0x702C, KANJI_SJIS_L1,  // 瀬
	0x755D, KANJI_SJIS_L1,  // 畝
	0x662F, KANJI_SJIS_L1,  // 是
	0x51C4, KANJI_SJIS_L1,  // 凄
	0x5236, KANJI_SJIS_L1,  // 制
	0x52E2, KANJI_SJIS_L1,  // 勢
	0x59D3, KANJI_SJIS_L1,  // 姓
	0x5F81, KANJI_SJIS_L1,  // 征
	0x6027, KANJI_SJIS_L1,  // 性
	0x6210, KANJI_SJIS_L1,  // 成
	0x653F, KANJI_SJIS_L1,  // 政
	0x6574, KANJI_SJIS_L1,  // 整
	0x661F, KANJI_SJIS_L1,  // 星
	0x6674, KANJI_SJIS_L1,  // 晴
	0x68F2, KANJI_SJIS_L1,  // 棲
	0x6816, KANJI_SJIS_L1,  // 栖
	0x6B63, KANJI_SJIS_L1,  // 正
	0x6E05, KANJI_SJIS_L1,  // 清
	0x7272, KANJI_SJIS_L1,  // 牲
	0x751F, KANJI_SJIS_L1,  // 生
	0x76DB, KANJI_SJIS_L1,  // 盛
	0x7CBE, KANJI_SJIS_L1,  // 精
	0x8056, KANJI_SJIS_L1,  // 聖
	0x58F0, KANJI_SJIS_L1,  // 声
	0x88FD, KANJI_SJIS_L1,  // 製
	0x897F, KANJI_SJIS_L1,  // 西
	0x8AA0, KANJI_SJIS_L1,  // 誠
	0x8A93, KANJI_SJIS_L1,  // 誓
	0x8ACB, KANJI_SJIS_L1,  // 請
	0x901D, KANJI_SJIS_L1,  // 逝
	0x9192, KANJI_SJIS_L1,  // 醒
	0x9752, KANJI_SJIS_L1,  // 青
	0x9759, KANJI_SJIS_L1,  // 静
	0x6589, KANJI_SJIS_L1,  // 斉
	0x7A0E, KANJI_SJIS_L1,  // 税
	0x8106, KANJI_SJIS_L1,  // 脆
	0x96BB, KANJI_SJIS_L1,  // 隻
	0x5E2D, KANJI_SJIS_L1,  // 席
	0x60DC, KANJI_SJIS_L1,  // 惜
	0x621A, KANJI_SJIS_L1,  // 戚
	0x65A5, KANJI_SJIS_L1,  // 斥
	0x6614, KANJI_SJIS_L1,  // 昔
	0x6790, KANJI_SJIS_L1,  // 析
	0x77F3, KANJI_SJIS_L1,  // 石
	0x7A4D, KANJI_SJIS_L1,  // 積
	0x7C4D, KANJI_SJIS_L1,  // 籍
	0x7E3E, KANJI_SJIS_L1,  // 績
	0x810A, KANJI_SJIS_L1,  // 脊
	0x8CAC, KANJI_SJIS_L1,  // 責
	0x8D64, KANJI_SJIS_L1,  // 赤
	0x8DE1, KANJI_SJIS_L1,  // 跡
	0x8E5F, KANJI_SJIS_L1,  // 蹟
	0x78A9, KANJI_SJIS_L1,  // 碩
	0x5207, KANJI_SJIS_L1,  // 切
	0x62D9, KANJI_SJIS_L1,  // 拙
	0x63A5, KANJI_SJIS_L1,  // 接
	0x6442, KANJI_SJIS_L1,  // 摂
	0x6298, KANJI_SJIS_L1,  // 折
	0x8A2D, KANJI_SJIS_L1,  // 設
	0x7A83, KANJI_SJIS_L1,  // 窃
	0x7BC0, KANJI_SJIS_L1,  // 節
	0x8AAC, KANJI_SJIS_L1,  // 説
	0x96EA, KANJI_SJIS_L1,  // 雪
	0x7D76, KANJI_SJIS_L1,  // 絶
	0x820C, KANJI_SJIS_L1,  // 舌
	0x8749, KANJI_SJIS_L1,  // 蝉
	0x4ED9, KANJI_SJIS_L1,  // 仙
	0x5148, KANJI_SJIS_L1,  // 先
	0x5343, KANJI_SJIS_L1,  // 千
	0x5360, KANJI_SJIS_L1,  // 占
	0x5BA3, KANJI_SJIS_L1,  // 宣
	0x5C02, KANJI_SJIS_L1,  // 専
	0x5C16, KANJI_SJIS_L1,  // 尖
	0x5DDD, KANJI_SJIS_L1,  // 川
	0x6226, KANJI_SJIS_L1,  // 戦
	0x6247, KANJI_SJIS_L1,  // 扇
	0x64B0, KANJI_SJIS_L1,  // 撰
	0x6813, KANJI_SJIS_L1,  // 栓
	0x6834, KANJI_SJIS_L1,  // 栴
	0x6CC9, KANJI_SJIS_L1,  // 泉
	0x6D45, KANJI_SJIS_L1,  // 浅
	0x6D17, KANJI_SJIS_L1,  // 洗
	0x67D3, KANJI_SJIS_L1,  // 染
	0x6F5C, KANJI_SJIS_L1,  // 潜
	0x714E, KANJI_SJIS_L1,  // 煎
	0x717D, KANJI_SJIS_L1,  // 煽
	0x65CB, KANJI_SJIS_L1,  // 旋
	0x7A7F, KANJI_SJIS_L1,  // 穿
	0x7BAD, KANJI_SJIS_L1,  // 箭
	0x7DDA, KANJI_SJIS_L1,  // 線
	0x7E4A, KANJI_SJIS_L1,  // 繊
	0x7FA8, KANJI_SJIS_L1,  // 羨
	0x817A, KANJI_SJIS_L1,  // 腺
	0x821B, KANJI_SJIS_L1,  // 舛
	0x8239, KANJI_SJIS_L1,  // 船
	0x85A6, KANJI_SJIS_L1,  // 薦
	0x8A6E, KANJI_SJIS_L1,  // 詮
	0x8CCE, KANJI_SJIS_L1,  // 賎
	0x8DF5, KANJI_SJIS_L1,  // 践
	0x9078, KANJI_SJIS_L1,  // 選
	0x9077, KANJI_SJIS_L1,  // 遷
	0x92AD, KANJI_SJIS_L1,  // 銭
	0x9291, KANJI_SJIS_L1,  // 銑
	0x9583, KANJI_SJIS_L1,  // 閃
	0x9BAE, KANJI_SJIS_L1,  // 鮮
	0x524D, KANJI_SJIS_L1,  // 前
	0x5584, KANJI_SJIS_L1,  // 善
	0x6F38, KANJI_SJIS_L1,  // 漸
	0x7136, KANJI_SJIS_L1,  // 然
	0x5168, KANJI_SJIS_L1,  // 全
	0x7985, KANJI_SJIS_L1,  // 禅
	0x7E55, KANJI_SJIS_L1,  // 繕
	0x81B3, KANJI_SJIS_L1,  // 膳
	0x7CCE, KANJI_SJIS_L1,  // 糎
	0x564C, KANJI_SJIS_L1,  // 噌
	0x5851, KANJI_SJIS_L1,  // 塑
	0x5CA8, KANJI_SJIS_L1,  // 岨
	0x63AA, KANJI_SJIS_L1,  // 措
	0x66FE, KANJI_SJIS_L1,  // 曾
	0x66FD, KANJI_SJIS_L1,  // 曽
	0x695A, KANJI_SJIS_L1,  // 楚
	0x72D9, KANJI_SJIS_L1,  // 狙
	0x758F, KANJI_SJIS_L1,  // 疏
	0x758E, KANJI_SJIS_L1,  // 疎
	0x790E, KANJI_SJIS_L1,  // 礎
	0x7956, KANJI_SJIS_L1,  // 祖
	0x79DF, KANJI_SJIS_L1,  // 租
	0x7C97, KANJI_SJIS_L1,  // 粗
	0x7D20, KANJI_SJIS_L1,  // 素
	0x7D44, KANJI_SJIS_L1,  // 組
	0x8607, KANJI_SJIS_L1,  // 蘇
	0x8A34, KANJI_SJIS_L1,  // 訴
	0x963B, KANJI_SJIS_L1,  // 阻
	0x9061, KANJI_SJIS_L1,  // 遡
	0x9F20, KANJI_SJIS_L1,  // 鼠
	0x50E7, KANJI_SJIS_L1,  // 僧
	0x5275, KANJI_SJIS_L1,  // 創
	0x53CC, KANJI_SJIS_L1,  // 双
	0x53E2, KANJI_SJIS_L1,  // 叢
	0x5009, KANJI_SJIS_L1,  // 倉
	0x55AA, KANJI_SJIS_L1,  // 喪
	0x58EE, KANJI_SJIS_L1,  // 壮
	0x594F, KANJI_SJIS_L1,  // 奏
	0x723D, KANJI_SJIS_L1,  // 爽
	0x5B8B, KANJI_SJIS_L1,  // 宋
	0x5C64, KANJI_SJIS_L1,  // 層
	0x531D, KANJI_SJIS_L1,  // 匝
	0x60E3, KANJI_SJIS_L1,  // 惣
	0x60F3, KANJI_SJIS_L1,  // 想
	0x635C, KANJI_SJIS_L1,  // 捜
	0x6383, KANJI_SJIS_L1,  // 掃
	0x633F, KANJI_SJIS_L1,  // 挿
	0x63BB, KANJI_SJIS_L1,  // 掻
	0x3000, KANJI_SJIS_L1,  // 　
	0x64CD, KANJI_SJIS_L1,  // 操
	0x65E9, KANJI_SJIS_L1,  // 早
	0x66F9, KANJI_SJIS_L1,  // 曹
	0x5DE3, KANJI_SJIS_L1,  // 巣
	0x69CD, KANJI_SJIS_L1,  // 槍
	0x69FD, KANJI_SJIS_L1,  // 槽
	0x6F15, KANJI_SJIS_L1,  // 漕
	0x71E5, KANJI_SJIS_L1,  // 燥
	0x4E89, KANJI_SJIS_L1,  // 争
	0x75E9, KANJI_SJIS_L1,  // 痩
	0x76F8, KANJI_SJIS_L1,  // 相
	0x7A93, KANJI_SJIS_L1,  // 窓
	0x7CDF, KANJI_SJIS_L1,  // 糟
	0x7DCF, KANJI_SJIS_L1,  // 総
	0x7D9C, KANJI_SJIS_L1,  // 綜
	0x8061, KANJI_SJIS_L1,  // 聡
	0x8349, KANJI_SJIS_L1,  // 草
	0x8358, KANJI_SJIS_L1,  // 荘
	0x846C, KANJI_SJIS_L1,  // 葬
	0x84BC, KANJI_SJIS_L1,  // 蒼
	0x85FB, KANJI_SJIS_L1,  // 藻
	0x88C5, KANJI_SJIS_L1,  // 装
	0x8D70, KANJI_SJIS_L1,  // 走
	0x9001, KANJI_SJIS_L1,  // 送
	0x906D, KANJI_SJIS_L1,  // 遭
	0x9397, KANJI_SJIS_L1,  // 鎗
	0x971C, KANJI_SJIS_L1,  // 霜
	0x9A12, KANJI_SJIS_L1,  // 騒
	0x50CF, KANJI_SJIS_L1,  // 像
	0x5897, KANJI_SJIS_L1,  // 増
	0x618E, KANJI_SJIS_L1,  // 憎
	0x81D3, KANJI_SJIS_L1,  // 臓
	0x8535, KANJI_SJIS_L1,  // 蔵
	0x8D08, KANJI_SJIS_L1,  // 贈
	0x9020, KANJI_SJIS_L1,  // 造
	0x4FC3, KANJI_SJIS_L1,  // 促
	0x5074, KANJI_SJIS_L1,  // 側
	0x5247, KANJI_SJIS_L1,  // 則
	0x5373, KANJI_SJIS_L1,  // 即
	0x606F, KANJI_SJIS_L1,  // 息
	0x6349, KANJI_SJIS_L1,  // 捉
	0x675F, KANJI_SJIS_L1,  // 束
	0x6E2C, KANJI_SJIS_L1,  // 測
	0x8DB3, KANJI_SJIS_L1,  // 足
	0x901F, KANJI_SJIS_L1,  // 速
	0x4FD7, KANJI_SJIS_L1,  // 俗
	0x5C5E, KANJI_SJIS_L1,  // 属
	0x8CCA, KANJI_SJIS_L1,  // 賊
	0x65CF, KANJI_SJIS_L1,  // 族
	0x7D9A, KANJI_SJIS_L1,  // 続
	0x5352, KANJI_SJIS_L1,  // 卒
	0x8896, KANJI_SJIS_L1,  // 袖
	0x5176, KANJI_SJIS_L1,  // 其
	0x63C3, KANJI_SJIS_L1,  // 揃
	0x5B58, KANJI_SJIS_L1,  // 存
	0x5B6B, KANJI_SJIS_L1,  // 孫
	0x5C0A, KANJI_SJIS_L1,  // 尊
	0x640D, KANJI_SJIS_L1,  // 損
	0x6751, KANJI_SJIS_L1,  // 村
	0x905C, KANJI_SJIS_L1,  // 遜
	0x4ED6, KANJI_SJIS_L1,  // 他
	0x591A, KANJI_SJIS_L1,  // 多
	0x592A, KANJI_SJIS_L1,  // 太
	0x6C70, KANJI_SJIS_L1,  // 汰
	0x8A51, KANJI_SJIS_L1,  // 詑
	0x553E, KANJI_SJIS_L1,  // 唾
	0x5815, KANJI_SJIS_L1,  // 堕
	0x59A5, KANJI_SJIS_L1,  // 妥
	0x60F0, KANJI_SJIS_L1,  // 惰
	0x6253, KANJI_SJIS_L1,  // 打
	0x67C1, KANJI_SJIS_L1,  // 柁
	0x8235, KANJI_SJIS_L1,  // 舵
	0x6955, KANJI_SJIS_L1,  // 楕
	0x9640, KANJI_SJIS_L1,  // 陀
	0x99C4, KANJI_SJIS_L1,  // 駄
	0x9A28, KANJI_SJIS_L1,  // 騨
	0x4F53, KANJI_SJIS_L1,  // 体
	0x5806, KANJI_SJIS_L1,  // 堆
	0x5BFE, KANJI_SJIS_L1,  // 対
	0x8010, KANJI_SJIS_L1,  // 耐
	0x5CB1, KANJI_SJIS_L1,  // 岱
	0x5E2F, KANJI_SJIS_L1,  // 帯
	0x5F85, KANJI_SJIS_L1,  // 待
	0x6020, KANJI_SJIS_L1,  // 怠
	0x614B, KANJI_SJIS_L1,  // 態
	0x6234, KANJI_SJIS_L1,  // 戴
	0x66FF, KANJI_SJIS_L1,  // 替
	0x6CF0, KANJI_SJIS_L1,  // 泰
	0x6EDE, KANJI_SJIS_L1,  // 滞
	0x80CE, KANJI_SJIS_L1,  // 胎
	0x817F, KANJI_SJIS_L1,  // 腿
	0x82D4, KANJI_SJIS_L1,  // 苔
	0x888B, KANJI_SJIS_L1,  // 袋
	0x8CB8, KANJI_SJIS_L1,  // 貸
	0x9000, KANJI_SJIS_L1,  // 退
	0x902E, KANJI_SJIS_L1,  // 逮
	0x968A, KANJI_SJIS_L1,  // 隊
	0x9EDB, KANJI_SJIS_L1,  // 黛
	0x9BDB, KANJI_SJIS_L1,  // 鯛
	0x4EE3, KANJI_SJIS_L1,  // 代
	0x53F0, KANJI_SJIS_L1,  // 台
	0x5927, KANJI_SJIS_L1,  // 大
	0x7B2C, KANJI_SJIS_L1,  // 第
	0x918D, KANJI_SJIS_L1,  // 醍
	0x984C, KANJI_SJIS_L1,  // 題
	0x9DF9, KANJI_SJIS_L1,  // 鷹
	0x6EDD, KANJI_SJIS_L1,  // 滝
	0x7027, KANJI_SJIS_L1,  // 瀧
	0x5353, KANJI_SJIS_L1,  // 卓
	0x5544, KANJI_SJIS_L1,  // 啄
	0x5B85, KANJI_SJIS_L1,  // 宅
	0x6258, KANJI_SJIS_L1,  // 托
	0x629E, KANJI_SJIS_L1,  // 択
	0x62D3, KANJI_SJIS_L1,  // 拓
	0x6CA2, KANJI_SJIS_L1,  // 沢
	0x6FEF, KANJI_SJIS_L1,  // 濯
	0x7422, KANJI_SJIS_L1,  // 琢
	0x8A17, KANJI_SJIS_L1,  // 託
	0x9438, KANJI_SJIS_L1,  // 鐸
	0x6FC1, KANJI_SJIS_L1,  // 濁
	0x8AFE, KANJI_SJIS_L1,  // 諾
	0x8338, KANJI_SJIS_L1,  // 茸
	0x51E7, KANJI_SJIS_L1,  // 凧
	0x86F8, KANJI_SJIS_L1,  // 蛸
	0x53EA, KANJI_SJIS_L1,  // 只
	0x53E9, KANJI_SJIS_L1,  // 叩
	0x4F46, KANJI_SJIS_L1,  // 但
	0x9054, KANJI_SJIS_L1,  // 達
	0x8FB0, KANJI_SJIS_L1,  // 辰
	0x596A, KANJI_SJIS_L1,  // 奪
	0x8131, KANJI_SJIS_L1,  // 脱
	0x5DFD, KANJI_SJIS_L1,  // 巽
	0x7AEA, KANJI_SJIS_L1,  // 竪
	0x8FBF, KANJI_SJIS_L1,  // 辿
	0x68DA, KANJI_SJIS_L1,  // 棚
	0x8C37, KANJI_SJIS_L1,  // 谷
	0x72F8, KANJI_SJIS_L1,  // 狸
	0x9C48, KANJI_SJIS_L1,  // 鱈
	0x6A3D, KANJI_SJIS_L1,  // 樽
	0x8AB0, KANJI_SJIS_L1,  // 誰
	0x4E39, KANJI_SJIS_L1,  // 丹
	0x5358, KANJI_SJIS_L1,  // 単
	0x5606, KANJI_SJIS_L1,  // 嘆
	0x5766, KANJI_SJIS_L1,  // 坦
	0x62C5, KANJI_SJIS_L1,  // 担
	0x63A2, KANJI_SJIS_L1,  // 探
	0x65E6, KANJI_SJIS_L1,  // 旦
	0x6B4E, KANJI_SJIS_L1,  // 歎
	0x6DE1, KANJI_SJIS_L1,  // 淡
	0x6E5B, KANJI_SJIS_L1,  // 湛
	0x70AD, KANJI_SJIS_L1,  // 炭
	0x77ED, KANJI_SJIS_L1,  // 短
	0x7AEF, KANJI_SJIS_L1,  // 端
	0x7BAA, KANJI_SJIS_L1,  // 箪
	0x7DBB, KANJI_SJIS_L1,  // 綻
	0x803D, KANJI_SJIS_L1,  // 耽
	0x80C6, KANJI_SJIS_L1,  // 胆
	0x86CB, KANJI_SJIS_L1,  // 蛋
	0x8A95, KANJI_SJIS_L1,  // 誕
	0x935B, KANJI_SJIS_L1,  // 鍛
	0x56E3, KANJI_SJIS_L1,  // 団
	0x58C7, KANJI_SJIS_L1,  // 壇
	0x5F3E, KANJI_SJIS_L1,  // 弾
	0x65AD, KANJI_SJIS_L1,  // 断
	0x6696, KANJI_SJIS_L1,  // 暖
	0x6A80, KANJI_SJIS_L1,  // 檀
	0x6BB5, KANJI_SJIS_L1,  // 段
	0x7537, KANJI_SJIS_L1,  // 男
	0x8AC7, KANJI_SJIS_L1,  // 談
	0x5024, KANJI_SJIS_L1,  // 値
	0x77E5, KANJI_SJIS_L1,  // 知
	0x5730, KANJI_SJIS_L1,  // 地
	0x5F1B, KANJI_SJIS_L1,  // 弛
	0x6065, KANJI_SJIS_L1,  // 恥
	0x667A, KANJI_SJIS_L1,  // 智
	0x6C60, KANJI_SJIS_L1,  // 池
	0x75F4, KANJI_SJIS_L1,  // 痴
	0x7A1A, KANJI_SJIS_L1,  // 稚
	0x7F6E, KANJI_SJIS_L1,  // 置
	0x81F4, KANJI_SJIS_L1,  // 致
	0x8718, KANJI_SJIS_L1,  // 蜘
	0x9045, KANJI_SJIS_L1,  // 遅
	0x99B3, KANJI_SJIS_L1,  // 馳
	0x7BC9, KANJI_SJIS_L1,  // 築
	0x755C, KANJI_SJIS_L1,  // 畜
	0x7AF9, KANJI_SJIS_L1,  // 竹
	0x7B51, KANJI_SJIS_L1,  // 筑
	0x84C4, KANJI_SJIS_L1,  // 蓄
	0x3000, KANJI_SJIS_L1,  // 　
	0x9010, KANJI_SJIS_L1,  // 逐
	0x79E9, KANJI_SJIS_L1,  // 秩
	0x7A92, KANJI_SJIS_L1,  // 窒
	0x8336, KANJI_SJIS_L1,  // 茶
	0x5AE1, KANJI_SJIS_L1,  // 嫡
	0x7740, KANJI_SJIS_L1,  // 着
	0x4E2D, KANJI_SJIS_L1,  // 中
	0x4EF2, KANJI_SJIS_L1,  // 仲
	0x5B99, KANJI_SJIS_L1,  // 宙
	0x5FE0, KANJI_SJIS_L1,  // 忠
	0x62BD, KANJI_SJIS_L1,  // 抽
	0x663C, KANJI_SJIS_L1,  // 昼
	0x67F1, KANJI_SJIS_L1,  // 柱
	0x6CE8, KANJI_SJIS_L1,  // 注
	0x866B, KANJI_SJIS_L1,  // 虫
	0x8877, KANJI_SJIS_L1,  // 衷
	0x8A3B, KANJI_SJIS_L1,  // 註
	0x914E, KANJI_SJIS_L1,  // 酎
	0x92F3, KANJI_SJIS_L1,  // 鋳
	0x99D0, KANJI_SJIS_L1,  // 駐
	0x6A17, KANJI_SJIS_L1,  // 樗
	0x7026, KANJI_SJIS_L1,  // 瀦
	0x732A, KANJI_SJIS_L1,  // 猪
	0x82E7, KANJI_SJIS_L1,  // 苧
	0x8457, KANJI_SJIS_L1,  // 著
	0x8CAF, KANJI_SJIS_L1,  // 貯
	0x4E01, KANJI_SJIS_L1,  // 丁
	0x5146, KANJI_SJIS_L1,  // 兆
	0x51CB, KANJI_SJIS_L1,  // 凋
	0x558B, KANJI_SJIS_L1,  // 喋
	0x5BF5, KANJI_SJIS_L1,  // 寵
	0x5E16, KANJI_SJIS_L1,  // 帖
	0x5E33, KANJI_SJIS_L1,  // 帳
	0x5E81, KANJI_SJIS_L1,  // 庁
	0x5F14, KANJI_SJIS_L1,  // 弔
	0x5F35, KANJI_SJIS_L1,  // 張
	0x5F6B, KANJI_SJIS_L1,  // 彫
	0x5FB4, KANJI_SJIS_L1,  // 徴
	0x61F2, KANJI_SJIS_L1,  // 懲
	0x6311, KANJI_SJIS_L1,  // 挑
	0x66A2, KANJI_SJIS_L1,  // 暢
	0x671D, KANJI_SJIS_L1,  // 朝
	0x6F6E, KANJI_SJIS_L1,  // 潮
	0x7252, KANJI_SJIS_L1,  // 牒
	0x753A, KANJI_SJIS_L1,  // 町
	0x773A, KANJI_SJIS_L1,  // 眺
	0x8074, KANJI_SJIS_L1,  // 聴
	0x8139, KANJI_SJIS_L1,  // 脹
	0x8178, KANJI_SJIS_L1,  // 腸
	0x8776, KANJI_SJIS_L1,  // 蝶
	0x8ABF, KANJI_SJIS_L1,  // 調
	0x8ADC, KANJI_SJIS_L1,  // 諜
	0x8D85, KANJI_SJIS_L1,  // 超
	0x8DF3, KANJI_SJIS_L1,  // 跳
	0x929A, KANJI_SJIS_L1,  // 銚
	0x9577, KANJI_SJIS_L1,  // 長
	0x9802, KANJI_SJIS_L1,  // 頂
	0x9CE5, KANJI_SJIS_L1,  // 鳥
	0x52C5, KANJI_SJIS_L1,  // 勅
	0x6357, KANJI_SJIS_L1,  // 捗
	0x76F4, KANJI_SJIS_L1,  // 直
	0x6715, KANJI_SJIS_L1,  // 朕
	0x6C88, KANJI_SJIS_L1,  // 沈
	0x73CD, KANJI_SJIS_L1,  // 珍
	0x8CC3, KANJI_SJIS_L1,  // 賃
	0x93AE, KANJI_SJIS_L1,  // 鎮
	0x9673, KANJI_SJIS_L1,  // 陳
	0x6D25, KANJI_SJIS_L1,  // 津
	0x589C, KANJI_SJIS_L1,  // 墜
	0x690E, KANJI_SJIS_L1,  // 椎
	0x69CC, KANJI_SJIS_L1,  // 槌
	0x8FFD, KANJI_SJIS_L1,  // 追
	0x939A, KANJI_SJIS_L1,  // 鎚
	0x75DB, KANJI_SJIS_L1,  // 痛
	0x901A, KANJI_SJIS_L1,  // 通
	0x585A, KANJI_SJIS_L1,  // 塚
	0x6802, KANJI_SJIS_L1,  // 栂
	0x63B4, KANJI_SJIS_L1,  // 掴
	0x69FB, KANJI_SJIS_L1,  // 槻
	0x4F43, KANJI_SJIS_L1,  // 佃
	0x6F2C, KANJI_SJIS_L1,  // 漬
	0x67D8, KANJI_SJIS_L1,  // 柘
	0x8FBB, KANJI_SJIS_L1,  // 辻
	0x8526, KANJI_SJIS_L1,  // 蔦
	0x7DB4, KANJI_SJIS_L1,  // 綴
	0x9354, KANJI_SJIS_L1,  // 鍔
	0x693F, KANJI_SJIS_L1,  // 椿
	0x6F70, KANJI_SJIS_L1,  // 潰
	0x576A, KANJI_SJIS_L1,  // 坪
	0x58F7, KANJI_SJIS_L1,  // 壷
	0x5B2C, KANJI_SJIS_L1,  // 嬬
	0x7D2C, KANJI_SJIS_L1,  // 紬
	0x722A, KANJI_SJIS_L1,  // 爪
	0x540A, KANJI_SJIS_L1,  // 吊
	0x91E3, KANJI_SJIS_L1,  // 釣
	0x9DB4, KANJI_SJIS_L1,  // 鶴
	0x4EAD, KANJI_SJIS_L1,  // 亭
	0x4F4E, KANJI_SJIS_L1,  // 低
	0x505C, KANJI_SJIS_L1,  // 停
	0x5075, KANJI_SJIS_L1,  // 偵
	0x5243, KANJI_SJIS_L1,  // 剃
	0x8C9E, KANJI_SJIS_L1,  // 貞
	0x5448, KANJI_SJIS_L1,  // 呈
	0x5824, KANJI_SJIS_L1,  // 堤
	0x5B9A, KANJI_SJIS_L1,  // 定
	0x5E1D, KANJI_SJIS_L1,  // 帝
	0x5E95, KANJI_SJIS_L1,  // 底
	0x5EAD, KANJI_SJIS_L1,  // 庭
	0x5EF7, KANJI_SJIS_L1,  // 廷
	0x5F1F, KANJI_SJIS_L1,  // 弟
	0x608C, KANJI_SJIS_L1,  // 悌
	0x62B5, KANJI_SJIS_L1,  // 抵
	0x633A, KANJI_SJIS_L1,  // 挺
	0x63D0, KANJI_SJIS_L1,  // 提
	0x68AF, KANJI_SJIS_L1,  // 梯
	0x6C40, KANJI_SJIS_L1,  // 汀
	0x7887, KANJI_SJIS_L1,  // 碇
	0x798E, KANJI_SJIS_L1,  // 禎
	0x7A0B, KANJI_SJIS_L1,  // 程
	0x7DE0, KANJI_SJIS_L1,  // 締
	0x8247, KANJI_SJIS_L1,  // 艇
	0x8A02, KANJI_SJIS_L1,  // 訂
	0x8AE6, KANJI_SJIS_L1,  // 諦
	0x8E44, KANJI_SJIS_L1,  // 蹄
	0x9013, KANJI_SJIS_L1,  // 逓
	0x90B8, KANJI_SJIS_L1,  // 邸
	0x912D, KANJI_SJIS_L1,  // 鄭
	0x91D8, KANJI_SJIS_L1,  // 釘
	0x9F0E, KANJI_SJIS_L1,  // 鼎
	0x6CE5, KANJI_SJIS_L1,  // 泥
	0x6458, KANJI_SJIS_L1,  // 摘
	0x64E2, KANJI_SJIS_L1,  // 擢
	0x6575, KANJI_SJIS_L1,  // 敵
	0x6EF4, KANJI_SJIS_L1,  // 滴
	0x7684, KANJI_SJIS_L1,  // 的
	0x7B1B, KANJI_SJIS_L1,  // 笛
	0x9069, KANJI_SJIS_L1,  // 適
	0x93D1, KANJI_SJIS_L1,  // 鏑
	0x6EBA, KANJI_SJIS_L1,  // 溺
	0x54F2, KANJI_SJIS_L1,  // 哲
	0x5FB9, KANJI_SJIS_L1,  // 徹
	0x64A4, KANJI_SJIS_L1,  // 撤
	0x8F4D, KANJI_SJIS_L1,  // 轍
	0x8FED, KANJI_SJIS_L1,  // 迭
	0x9244, KANJI_SJIS_L1,  // 鉄
	0x5178, KANJI_SJIS_L1,  // 典
	0x586B, KANJI_SJIS_L1,  // 填
	0x5929, KANJI_SJIS_L1,  // 天
	0x5C55, KANJI_SJIS_L1,  // 展
	0x5E97, KANJI_SJIS_L1,  // 店
	0x6DFB, KANJI_SJIS_L1,  // 添
	0x7E8F, KANJI_SJIS_L1,  // 纏
	0x751C, KANJI_SJIS_L1,  // 甜
	0x8CBC, KANJI_SJIS_L1,  // 貼
	0x8EE2, KANJI_SJIS_L1,  // 転
	0x985B, KANJI_SJIS_L1,  // 顛
	0x70B9, KANJI_SJIS_L1,  // 点
	0x4F1D, KANJI_SJIS_L1,  // 伝
	0x6BBF, KANJI_SJIS_L1,  // 殿
	0x6FB1, KANJI_SJIS_L1,  // 澱
	0x7530, KANJI_SJIS_L1,  // 田
	0x96FB, KANJI_SJIS_L1,  // 電
	0x514E, KANJI_SJIS_L1,  // 兎
	0x5410, KANJI_SJIS_L1,  // 吐
	0x5835, KANJI_SJIS_L1,  // 堵
	0x5857, KANJI_SJIS_L1,  // 塗
	0x59AC, KANJI_SJIS_L1,  // 妬
	0x5C60, KANJI_SJIS_L1,  // 屠
	0x5F92, KANJI_SJIS_L1,  // 徒
	0x6597, KANJI_SJIS_L1,  // 斗
	0x675C, KANJI_SJIS_L1,  // 杜
	0x6E21, KANJI_SJIS_L1,  // 渡
	0x767B, KANJI_SJIS_L1,  // 登
	0x83DF, KANJI_SJIS_L1,  // 菟
	0x8CED, KANJI_SJIS_L1,  // 賭
	0x9014, KANJI_SJIS_L1,  // 途
	0x90FD, KANJI_SJIS_L1,  // 都
	0x934D, KANJI_SJIS_L1,  // 鍍
	0x7825, KANJI_SJIS_L1,  // 砥
	0x783A, KANJI_SJIS_L1,  // 砺
	0x52AA, KANJI_SJIS_L1,  // 努
	0x5EA6, KANJI_SJIS_L1,  // 度
	0x571F, KANJI_SJIS_L1,  // 土
	0x5974, KANJI_SJIS_L1,  // 奴
	0x6012, KANJI_SJIS_L1,  // 怒
	0x5012, KANJI_SJIS_L1,  // 倒
	0x515A, KANJI_SJIS_L1,  // 党
	0x51AC, KANJI_SJIS_L1,  // 冬
	0x3000, KANJI_SJIS_L1,  // 　
	0x51CD, KANJI_SJIS_L1,  // 凍
	0x5200, KANJI_SJIS_L1,  // 刀
	0x5510, KANJI_SJIS_L1,  // 唐
	0x5854, KANJI_SJIS_L1,  // 塔
	0x5858, KANJI_SJIS_L1,  // 塘
	0x5957, KANJI_SJIS_L1,  // 套
	0x5B95, KANJI_SJIS_L1,  // 宕
	0x5CF6, KANJI_SJIS_L1,  // 島
	0x5D8B, KANJI_SJIS_L1,  // 嶋
	0x60BC, KANJI_SJIS_L1,  // 悼
	0x6295, KANJI_SJIS_L1,  // 投
	0x642D, KANJI_SJIS_L1,  // 搭
	0x6771, KANJI_SJIS_L1,  // 東
	0x6843, KANJI_SJIS_L1,  // 桃
	0x68BC, KANJI_SJIS_L1,  // 梼
	0x68DF, KANJI_SJIS_L1,  // 棟
	0x76D7, KANJI_SJIS_L1,  // 盗
	0x6DD8, KANJI_SJIS_L1,  // 淘
	0x6E6F, KANJI_SJIS_L1,  // 湯
	0x6D9B, KANJI_SJIS_L1,  // 涛
	0x706F, KANJI_SJIS_L1,  // 灯
	0x71C8, KANJI_SJIS_L1,  // 燈
	0x5F53, KANJI_SJIS_L1,  // 当
	0x75D8, KANJI_SJIS_L1,  // 痘
	0x7977, KANJI_SJIS_L1,  // 祷
	0x7B49, KANJI_SJIS_L1,  // 等
	0x7B54, KANJI_SJIS_L1,  // 答
	0x7B52, KANJI_SJIS_L1,  // 筒
	0x7CD6, KANJI_SJIS_L1,  // 糖
	0x7D71, KANJI_SJIS_L1,  // 統
	0x5230, KANJI_SJIS_L1,  // 到
	0x8463, KANJI_SJIS_L1,  // 董
	0x8569, KANJI_SJIS_L1,  // 蕩
	0x85E4, KANJI_SJIS_L1,  // 藤
	0x8A0E, KANJI_SJIS_L1,  // 討
	0x8B04, KANJI_SJIS_L1,  // 謄
	0x8C46, KANJI_SJIS_L1,  // 豆
	0x8E0F, KANJI_SJIS_L1,  // 踏
	0x9003, KANJI_SJIS_L1,  // 逃
	0x900F, KANJI_SJIS_L1,  // 透
	0x9419, KANJI_SJIS_L1,  // 鐙
	0x9676, KANJI_SJIS_L1,  // 陶
	0x982D, KANJI_SJIS_L1,  // 頭
	0x9A30, KANJI_SJIS_L1,  // 騰
	0x95D8, KANJI_SJIS_L1,  // 闘
	0x50CD, KANJI_SJIS_L1,  // 働
	0x52D5, KANJI_SJIS_L1,  // 動
	0x540C, KANJI_SJIS_L1,  // 同
	0x5802, KANJI_SJIS_L1,  // 堂
	0x5C0E, KANJI_SJIS_L1,  // 導
	0x61A7, KANJI_SJIS_L1,  // 憧
	0x649E, KANJI_SJIS_L1,  // 撞
	0x6D1E, KANJI_SJIS_L1,  // 洞
	0x77B3, KANJI_SJIS_L1,  // 瞳
	0x7AE5, KANJI_SJIS_L1,  // 童
	0x80F4, KANJI_SJIS_L1,  // 胴
	0x8404, KANJI_SJIS_L1,  // 萄
	0x9053, KANJI_SJIS_L1,  // 道
	0x9285, KANJI_SJIS_L1,  // 銅
	0x5CE0, KANJI_SJIS_L1,  // 峠
	0x9D07, KANJI_SJIS_L1,  // 鴇
	0x533F, KANJI_SJIS_L1,  // 匿
	0x5F97, KANJI_SJIS_L1,  // 得
	0x5FB3, KANJI_SJIS_L1,  // 徳
	0x6D9C, KANJI_SJIS_L1,  // 涜
	0x7279, KANJI_SJIS_L1,  // 特
	0x7763, KANJI_SJIS_L1,  // 督
	0x79BF, KANJI_SJIS_L1,  // 禿
	0x7BE4, KANJI_SJIS_L1,  // 篤
	0x6BD2, KANJI_SJIS_L1,  // 毒
	0x72EC, KANJI_SJIS_L1,  // 独
	0x8AAD, KANJI_SJIS_L1,  // 読
	0x6803, KANJI_SJIS_L1,  // 栃
	0x6A61, KANJI_SJIS_L1,  // 橡
	0x51F8, KANJI_SJIS_L1,  // 凸
	0x7A81, KANJI_SJIS_L1,  // 突
	0x6934, KANJI_SJIS_L1,  // 椴
	0x5C4A, KANJI_SJIS_L1,  // 届
	0x9CF6, KANJI_SJIS_L1,  // 鳶
	0x82EB, KANJI_SJIS_L1,  // 苫
	0x5BC5, KANJI_SJIS_L1,  // 寅
	0x9149, KANJI_SJIS_L1,  // 酉
	0x701E, KANJI_SJIS_L1,  // 瀞
	0x5678, KANJI_SJIS_L1,  // 噸
	0x5C6F, KANJI_SJIS_L1,  // 屯
	0x60C7, KANJI_SJIS_L1,  // 惇
	0x6566, KANJI_SJIS_L1,  // 敦
	0x6C8C, KANJI_SJIS_L1,  // 沌
	0x8C5A, KANJI_SJIS_L1,  // 豚
	0x9041, KANJI_SJIS_L1,  // 遁
	0x9813, KANJI_SJIS_L1,  // 頓
	0x5451, KANJI_SJIS_L1,  // 呑
	0x66C7, KANJI_SJIS_L1,  // 曇
	0x920D, KANJI_SJIS_L1,  // 鈍
	0x5948, KANJI_SJIS_L1,  // 奈
	0x90A3, KANJI_SJIS_L1,  // 那
	0x5185, KANJI_SJIS_L1,  // 内
	0x4E4D, KANJI_SJIS_L1,  // 乍
	0x51EA, KANJI_SJIS_L1,  // 凪
	0x8599, KANJI_SJIS_L1,  // 薙
	0x8B0E, KANJI_SJIS_L1,  // 謎
	0x7058, KANJI_SJIS_L1,  // 灘
	0x637A, KANJI_SJIS_L1,  // 捺
	0x934B, KANJI_SJIS_L1,  // 鍋
	0x6962, KANJI_SJIS_L1,  // 楢
	0x99B4, KANJI_SJIS_L1,  // 馴
	0x7E04, KANJI_SJIS_L1,  // 縄
	0x7577, KANJI_SJIS_L1,  // 畷
	0x5357, KANJI_SJIS_L1,  // 南
	0x6960, KANJI_SJIS_L1,  // 楠
	0x8EDF, KANJI_SJIS_L1,  // 軟
	0x96E3, KANJI_SJIS_L1,  // 難
	0x6C5D, KANJI_SJIS_L1,  // 汝
	0x4E8C, KANJI_SJIS_L1,  // 二
	0x5C3C, KANJI_SJIS_L1,  // 尼
	0x5F10, KANJI_SJIS_L1,  // 弐
	0x8FE9, KANJI_SJIS_L1,  // 迩
	0x5302, KANJI_SJIS_L1,  // 匂
	0x8CD1, KANJI_SJIS_L1,  // 賑
	0x8089, KANJI_SJIS_L1,  // 肉
	0x8679, KANJI_SJIS_L1,  // 虹
	0x5EFF, KANJI_SJIS_L1,  // 廿
	0x65E5, KANJI_SJIS_L1,  // 日
	0x4E73, KANJI_SJIS_L1,  // 乳
	0x5165, KANJI_SJIS_L1,  // 入
	0x5982, KANJI_SJIS_L1,  // 如
	0x5C3F, KANJI_SJIS_L1,  // 尿
	0x97EE, KANJI_SJIS_L1,  // 韮
	0x4EFB, KANJI_SJIS_L1,  // 任
	0x598A, KANJI_SJIS_L1,  // 妊
	0x5FCD, KANJI_SJIS_L1,  // 忍
	0x8A8D, KANJI_SJIS_L1,  // 認
	0x6FE1, KANJI_SJIS_L1,  // 濡
	0x79B0, KANJI_SJIS_L1,  // 禰
	0x7962, KANJI_SJIS_L1,  // 祢
	0x5BE7, KANJI_SJIS_L1,  // 寧
	0x8471, KANJI_SJIS_L1,  // 葱
	0x732B, KANJI_SJIS_L1,  // 猫
	0x71B1, KANJI_SJIS_L1,  // 熱
	0x5E74, KANJI_SJIS_L1,  // 年
	0x5FF5, KANJI_SJIS_L1,  // 念
	0x637B, KANJI_SJIS_L1,  // 捻
	0x649A, KANJI_SJIS_L1,  // 撚
	0x71C3, KANJI_SJIS_L1,  // 燃
	0x7C98, KANJI_SJIS_L1,  // 粘
	0x4E43, KANJI_SJIS_L1,  // 乃
	0x5EFC, KANJI_SJIS_L1,  // 廼
	0x4E4B, KANJI_SJIS_L1,  // 之
	0x57DC, KANJI_SJIS_L1,  // 埜
	0x56A2, KANJI_SJIS_L1,  // 嚢
	0x60A9, KANJI_SJIS_L1,  // 悩
	0x6FC3, KANJI_SJIS_L1,  // 濃
	0x7D0D, KANJI_SJIS_L1,  // 納
	0x80FD, KANJI_SJIS_L1,  // 能
	0x8133, KANJI_SJIS_L1,  // 脳
	0x81BF, KANJI_SJIS_L1,  // 膿
	0x8FB2, KANJI_SJIS_L1,  // 農
	0x8997, KANJI_SJIS_L1,  // 覗
	0x86A4, KANJI_SJIS_L1,  // 蚤
	0x5DF4, KANJI_SJIS_L1,  // 巴
	0x628A, KANJI_SJIS_L1,  // 把
	0x64AD, KANJI_SJIS_L1,  // 播
	0x8987, KANJI_SJIS_L1,  // 覇
	0x6777, KANJI_SJIS_L1,  // 杷
	0x6CE2, KANJI_SJIS_L1,  // 波
	0x6D3E, KANJI_SJIS_L1,  // 派
	0x7436, KANJI_SJIS_L1,  // 琶
	0x7834, KANJI_SJIS_L1,  // 破
	0x5A46, KANJI_SJIS_L1,  // 婆
	0x7F75, KANJI_SJIS_L1,  // 罵
	0x82AD, KANJI_SJIS_L1,  // 芭
	0x99AC, KANJI_SJIS_L1,  // 馬
	0x4FF3, KANJI_SJIS_L1,  // 俳
	0x5EC3, KANJI_SJIS_L1,  // 廃
	0x62DD, KANJI_SJIS_L1,  // 拝
	0x6392, KANJI_SJIS_L1,  // 排
	0x6557, KANJI_SJIS_L1,  // 敗
	0x676F, KANJI_SJIS_L1,  // 杯
	0x76C3, KANJI_SJIS_L1,  // 盃
	0x724C, KANJI_SJIS_L1,  // 牌
	0x80CC, KANJI_SJIS_L1,  // 背
	0x80BA, KANJI_SJIS_L1,  // 肺
	0x8F29, KANJI_SJIS_L1,  // 輩
	0x914D, KANJI_SJIS_L1,  // 配
	0x500D, KANJI_SJIS_L1,  // 倍
	0x57F9, KANJI_SJIS_L1,  // 培
	0x5A92, KANJI_SJIS_L1,  // 媒
	0x6885, KANJI_SJIS_L1,  // 梅
	0x3000, KANJI_SJIS_L1,  // 　
	0x6973, KANJI_SJIS_L1,  // 楳
	0x7164, KANJI_SJIS_L1,  // 煤
	0x72FD, KANJI_SJIS_L1,  // 狽
	0x8CB7, KANJI_SJIS_L1,  // 買
	0x58F2, KANJI_SJIS_L1,  // 売
	0x8CE0, KANJI_SJIS_L1,  // 賠
	0x966A, KANJI_SJIS_L1,  // 陪
	0x9019, KANJI_SJIS_L1,  // 這
	0x877F, KANJI_SJIS_L1,  // 蝿
	0x79E4, KANJI_SJIS_L1,  // 秤
	0x77E7, KANJI_SJIS_L1,  // 矧
	0x8429, KANJI_SJIS_L1,  // 萩
	0x4F2F, KANJI_SJIS_L1,  // 伯
	0x5265, KANJI_SJIS_L1,  // 剥
	0x535A, KANJI_SJIS_L1,  // 博
	0x62CD, KANJI_SJIS_L1,  // 拍
	0x67CF, KANJI_SJIS_L1,  // 柏
	0x6CCA, KANJI_SJIS_L1,  // 泊
	0x767D, KANJI_SJIS_L1,  // 白
	0x7B94, KANJI_SJIS_L1,  // 箔
	0x7C95, KANJI_SJIS_L1,  // 粕
	0x8236, KANJI_SJIS_L1,  // 舶
	0x8584, KANJI_SJIS_L1,  // 薄
	0x8FEB, KANJI_SJIS_L1,  // 迫
	0x66DD, KANJI_SJIS_L1,  // 曝
	0x6F20, KANJI_SJIS_L1,  // 漠
	0x7206, KANJI_SJIS_L1,  // 爆
	0x7E1B, KANJI_SJIS_L1,  // 縛
	0x83AB, KANJI_SJIS_L1,  // 莫
	0x99C1, KANJI_SJIS_L1,  // 駁
	0x9EA6, KANJI_SJIS_L1,  // 麦
	0x51FD, KANJI_SJIS_L1,  // 函
	0x7BB1, KANJI_SJIS_L1,  // 箱
	0x7872, KANJI_SJIS_L1,  // 硲
	0x7BB8, KANJI_SJIS_L1,  // 箸
	0x8087, KANJI_SJIS_L1,  // 肇
	0x7B48, KANJI_SJIS_L1,  // 筈
	0x6AE8, KANJI_SJIS_L1,  // 櫨
	0x5E61, KANJI_SJIS_L1,  // 幡
	0x808C, KANJI_SJIS_L1,  // 肌
	0x7551, KANJI_SJIS_L1,  // 畑
	0x7560, KANJI_SJIS_L1,  // 畠
	0x516B, KANJI_SJIS_L1,  // 八
	0x9262, KANJI_SJIS_L1,  // 鉢
	0x6E8C, KANJI_SJIS_L1,  // 溌
	0x767A, KANJI_SJIS_L1,  // 発
	0x9197, KANJI_SJIS_L1,  // 醗
	0x9AEA, KANJI_SJIS_L1,  // 髪
	0x4F10, KANJI_SJIS_L1,  // 伐
	0x7F70, KANJI_SJIS_L1,  // 罰
	0x629C, KANJI_SJIS_L1,  // 抜
	0x7B4F, KANJI_SJIS_L1,  // 筏
	0x95A5, KANJI_SJIS_L1,  // 閥
	0x9CE9, KANJI_SJIS_L1,  // 鳩
	0x567A, KANJI_SJIS_L1,  // 噺
	0x5859, KANJI_SJIS_L1,  // 塙
	0x86E4, KANJI_SJIS_L1,  // 蛤
	0x96BC, KANJI_SJIS_L1,  // 隼
	0x4F34, KANJI_SJIS_L1,  // 伴
	0x5224, KANJI_SJIS_L1,  // 判
	0x534A, KANJI_SJIS_L1,  // 半
	0x53CD, KANJI_SJIS_L1,  // 反
	0x53DB, KANJI_SJIS_L1,  // 叛
	0x5E06, KANJI_SJIS_L1,  // 帆
	0x642C, KANJI_SJIS_L1,  // 搬
	0x6591, KANJI_SJIS_L1,  // 斑
	0x677F, KANJI_SJIS_L1,  // 板
	0x6C3E, KANJI_SJIS_L1,  // 氾
	0x6C4E, KANJI_SJIS_L1,  // 汎
	0x7248, KANJI_SJIS_L1,  // 版
	0x72AF, KANJI_SJIS_L1,  // 犯
	0x73ED, KANJI_SJIS_L1,  // 班
	0x7554, KANJI_SJIS_L1,  // 畔
	0x7E41, KANJI_SJIS_L1,  // 繁
	0x822C, KANJI_SJIS_L1,  // 般
	0x85E9, KANJI_SJIS_L1,  // 藩
	0x8CA9, KANJI_SJIS_L1,  // 販
	0x7BC4, KANJI_SJIS_L1,  // 範
	0x91C6, KANJI_SJIS_L1,  // 釆
	0x7169, KANJI_SJIS_L1,  // 煩
	0x9812, KANJI_SJIS_L1,  // 頒
	0x98EF, KANJI_SJIS_L1,  // 飯
	0x633D, KANJI_SJIS_L1,  // 挽
	0x6669, KANJI_SJIS_L1,  // 晩
	0x756A, KANJI_SJIS_L1,  // 番
	0x76E4, KANJI_SJIS_L1,  // 盤
	0x78D0, KANJI_SJIS_L1,  // 磐
	0x8543, KANJI_SJIS_L1,  // 蕃
	0x86EE, KANJI_SJIS_L1,  // 蛮
	0x532A, KANJI_SJIS_L1,  // 匪
	0x5351, KANJI_SJIS_L1,  // 卑
	0x5426, KANJI_SJIS_L1,  // 否
	0x5983, KANJI_SJIS_L1,  // 妃
	0x5E87, KANJI_SJIS_L1,  // 庇
	0x5F7C, KANJI_SJIS_L1,  // 彼
	0x60B2, KANJI_SJIS_L1,  // 悲
	0x6249, KANJI_SJIS_L1,  // 扉
	0x6279, KANJI_SJIS_L1,  // 批
	0x62AB, KANJI_SJIS_L1,  // 披
	0x6590, KANJI_SJIS_L1,  // 斐
	0x6BD4, KANJI_SJIS_L1,  // 比
	0x6CCC, KANJI_SJIS_L1,  // 泌
	0x75B2, KANJI_SJIS_L1,  // 疲
	0x76AE, KANJI_SJIS_L1,  // 皮
	0x7891, KANJI_SJIS_L1,  // 碑
	0x79D8, KANJI_SJIS_L1,  // 秘
	0x7DCB, KANJI_SJIS_L1,  // 緋
	0x7F77, KANJI_SJIS_L1,  // 罷
	0x80A5, KANJI_SJIS_L1,  // 肥
	0x88AB, KANJI_SJIS_L1,  // 被
	0x8AB9, KANJI_SJIS_L1,  // 誹
	0x8CBB, KANJI_SJIS_L1,  // 費
	0x907F, KANJI_SJIS_L1,  // 避
	0x975E, KANJI_SJIS_L1,  // 非
	0x98DB, KANJI_SJIS_L1,  // 飛
	0x6A0B, KANJI_SJIS_L1,  // 樋
	0x7C38, KANJI_SJIS_L1,  // 簸
	0x5099, KANJI_SJIS_L1,  // 備
	0x5C3E, KANJI_SJIS_L1,  // 尾
	0x5FAE, KANJI_SJIS_L1,  // 微
	0x6787, KANJI_SJIS_L1,  // 枇
	0x6BD8, KANJI_SJIS_L1,  // 毘
	0x7435, KANJI_SJIS_L1,  // 琵
	0x7709, KANJI_SJIS_L1,  // 眉
	0x7F8E, KANJI_SJIS_L1,  // 美
	0x9F3B, KANJI_SJIS_L1,  // 鼻
	0x67CA, KANJI_SJIS_L1,  // 柊
	0x7A17, KANJI_SJIS_L1,  // 稗
	0x5339, KANJI_SJIS_L1,  // 匹
	0x758B, KANJI_SJIS_L1,  // 疋
	0x9AED, KANJI_SJIS_L1,  // 髭
	0x5F66, KANJI_SJIS_L1,  // 彦
	0x819D, KANJI_SJIS_L1,  // 膝
	0x83F1, KANJI_SJIS_L1,  // 菱
	0x8098, KANJI_SJIS_L1,  // 肘
	0x5F3C, KANJI_SJIS_L1,  // 弼
	0x5FC5, KANJI_SJIS_L1,  // 必
	0x7562, KANJI_SJIS_L1,  // 畢
	0x7B46, KANJI_SJIS_L1,  // 筆
	0x903C, KANJI_SJIS_L1,  // 逼
	0x6867, KANJI_SJIS_L1,  // 桧
	0x59EB, KANJI_SJIS_L1,  // 姫
	0x5A9B, KANJI_SJIS_L1,  // 媛
	0x7D10, KANJI_SJIS_L1,  // 紐
	0x767E, KANJI_SJIS_L1,  // 百
	0x8B2C, KANJI_SJIS_L1,  // 謬
	0x4FF5, KANJI_SJIS_L1,  // 俵
	0x5F6A, KANJI_SJIS_L1,  // 彪
	0x6A19, KANJI_SJIS_L1,  // 標
	0x6C37, KANJI_SJIS_L1,  // 氷
	0x6F02, KANJI_SJIS_L1,  // 漂
	0x74E2, KANJI_SJIS_L1,  // 瓢
	0x7968, KANJI_SJIS_L1,  // 票
	0x8868, KANJI_SJIS_L1,  // 表
	0x8A55, KANJI_SJIS_L1,  // 評
	0x8C79, KANJI_SJIS_L1,  // 豹
	0x5EDF, KANJI_SJIS_L1,  // 廟
	0x63CF, KANJI_SJIS_L1,  // 描
	0x75C5, KANJI_SJIS_L1,  // 病
	0x79D2, KANJI_SJIS_L1,  // 秒
	0x82D7, KANJI_SJIS_L1,  // 苗
	0x9328, KANJI_SJIS_L1,  // 錨
	0x92F2, KANJI_SJIS_L1,  // 鋲
	0x849C, KANJI_SJIS_L1,  // 蒜
	0x86ED, KANJI_SJIS_L1,  // 蛭
	0x9C2D, KANJI_SJIS_L1,  // 鰭
	0x54C1, KANJI_SJIS_L1,  // 品
	0x5F6C, KANJI_SJIS_L1,  // 彬
	0x658C, KANJI_SJIS_L1,  // 斌
	0x6D5C, KANJI_SJIS_L1,  // 浜
	0x7015, KANJI_SJIS_L1,  // 瀕
	0x8CA7, KANJI_SJIS_L1,  // 貧
	0x8CD3, KANJI_SJIS_L1,  // 賓
	0x983B, KANJI_SJIS_L1,  // 頻
	0x654F, KANJI_SJIS_L1,  // 敏
	0x74F6, KANJI_SJIS_L1,  // 瓶
	0x4E0D, KANJI_SJIS_L1,  // 不
	0x4ED8, KANJI_SJIS_L1,  // 付
	0x57E0, KANJI_SJIS_L1,  // 埠
	0x592B, KANJI_SJIS_L1,  // 夫
	0x5A66, KANJI_SJIS_L1,  // 婦
	0x5BCC, KANJI_SJIS_L1,  // 富
	0x51A8, KANJI_SJIS_L1,  // 冨
	0x5E03, KANJI_SJIS_L1,  // 布
	0x5E9C, KANJI_SJIS_L1,  // 府
	0x6016, KANJI_SJIS_L1,  // 怖
	0x6276, KANJI_SJIS_L1,  // 扶
	0x6577, KANJI_SJIS_L1,  // 敷
	0x3000, KANJI_SJIS_L1,  // 　
	0x65A7, KANJI_SJIS_L1,  // 斧
	0x666E, KANJI_SJIS_L1,  // 普
	0x6D6E, KANJI_SJIS_L1,  // 浮
	0x7236, KANJI_SJIS_L1,  // 父
	0x7B26, KANJI_SJIS_L1,  // 符
	0x8150, KANJI_SJIS_L1,  // 腐
	0x819A, KANJI_SJIS_L1,  // 膚
	0x8299, KANJI_SJIS_L1,  // 芙
	0x8B5C, KANJI_SJIS_L1,  // 譜
	0x8CA0, KANJI_SJIS_L1,  // 負
	0x8CE6, KANJI_SJIS_L1,  // 賦
	0x8D74, KANJI_SJIS_L1,  // 赴
	0x961C, KANJI_SJIS_L1,  // 阜
	0x9644, KANJI_SJIS_L1,  // 附
	0x4FAE, KANJI_SJIS_L1,  // 侮
	0x64AB, KANJI_SJIS_L1,  // 撫
	0x6B66, KANJI_SJIS_L1,  // 武
	0x821E, KANJI_SJIS_L1,  // 舞
	0x8461, KANJI_SJIS_L1,  // 葡
	0x856A, KANJI_SJIS_L1,  // 蕪
	0x90E8, KANJI_SJIS_L1,  // 部
	0x5C01, KANJI_SJIS_L1,  // 封
	0x6953, KANJI_SJIS_L1,  // 楓
	0x98A8, KANJI_SJIS_L1,  // 風
	0x847A, KANJI_SJIS_L1,  // 葺
	0x8557, KANJI_SJIS_L1,  // 蕗
	0x4F0F, KANJI_SJIS_L1,  // 伏
	0x526F, KANJI_SJIS_L1,  // 副
	0x5FA9, KANJI_SJIS_L1,  // 復
	0x5E45, KANJI_SJIS_L1,  // 幅
	0x670D, KANJI_SJIS_L1,  // 服
	0x798F, KANJI_SJIS_L1,  // 福
	0x8179, KANJI_SJIS_L1,  // 腹
	0x8907, KANJI_SJIS_L1,  // 複
	0x8986, KANJI_SJIS_L1,  // 覆
	0x6DF5, KANJI_SJIS_L1,  // 淵
	0x5F17, KANJI_SJIS_L1,  // 弗
	0x6255, KANJI_SJIS_L1,  // 払
	0x6CB8, KANJI_SJIS_L1,  // 沸
	0x4ECF, KANJI_SJIS_L1,  // 仏
	0x7269, KANJI_SJIS_L1,  // 物
	0x9B92, KANJI_SJIS_L1,  // 鮒
	0x5206, KANJI_SJIS_L1,  // 分
	0x543B, KANJI_SJIS_L1,  // 吻
	0x5674, KANJI_SJIS_L1,  // 噴
	0x58B3, KANJI_SJIS_L1,  // 墳
	0x61A4, KANJI_SJIS_L1,  // 憤
	0x626E, KANJI_SJIS_L1,  // 扮
	0x711A, KANJI_SJIS_L1,  // 焚
	0x596E, KANJI_SJIS_L1,  // 奮
	0x7C89, KANJI_SJIS_L1,  // 粉
	0x7CDE, KANJI_SJIS_L1,  // 糞
	0x7D1B, KANJI_SJIS_L1,  // 紛
	0x96F0, KANJI_SJIS_L1,  // 雰
	0x6587, KANJI_SJIS_L1,  // 文
	0x805E, KANJI_SJIS_L1,  // 聞
	0x4E19, KANJI_SJIS_L1,  // 丙
	0x4F75, KANJI_SJIS_L1,  // 併
	0x5175, KANJI_SJIS_L1,  // 兵
	0x5840, KANJI_SJIS_L1,  // 塀
	0x5E63, KANJI_SJIS_L1,  // 幣
	0x5E73, KANJI_SJIS_L1,  // 平
	0x5F0A, KANJI_SJIS_L1,  // 弊
	0x67C4, KANJI_SJIS_L1,  // 柄
	0x4E26, KANJI_SJIS_L1,  // 並
	0x853D, KANJI_SJIS_L1,  // 蔽
	0x9589, KANJI_SJIS_L1,  // 閉
	0x965B, KANJI_SJIS_L1,  // 陛
	0x7C73, KANJI_SJIS_L1,  // 米
	0x9801, KANJI_SJIS_L1,  // 頁
	0x50FB, KANJI_SJIS_L1,  // 僻
	0x58C1, KANJI_SJIS_L1,  // 壁
	0x7656, KANJI_SJIS_L1,  // 癖
	0x78A7, KANJI_SJIS_L1,  // 碧
	0x5225, KANJI_SJIS_L1,  // 別
	0x77A5, KANJI_SJIS_L1,  // 瞥
	0x8511, KANJI_SJIS_L1,  // 蔑
	0x7B86, KANJI_SJIS_L1,  // 箆
	0x504F, KANJI_SJIS_L1,  // 偏
	0x5909, KANJI_SJIS_L1,  // 変
	0x7247, KANJI_SJIS_L1,  // 片
	0x7BC7, KANJI_SJIS_L1,  // 篇
	0x7DE8, KANJI_SJIS_L1,  // 編
	0x8FBA, KANJI_SJIS_L1,  // 辺
	0x8FD4, KANJI_SJIS_L1,  // 返
	0x904D, KANJI_SJIS_L1,  // 遍
	0x4FBF, KANJI_SJIS_L1,  // 便
	0x52C9, KANJI_SJIS_L1,  // 勉
	0x5A29, KANJI_SJIS_L1,  // 娩
	0x5F01, KANJI_SJIS_L1,  // 弁
	0x97AD, KANJI_SJIS_L1,  // 鞭
	0x4FDD, KANJI_SJIS_L1,  // 保
	0x8217, KANJI_SJIS_L1,  // 舗
	0x92EA, KANJI_SJIS_L1,  // 鋪
	0x5703, KANJI_SJIS_L1,  // 圃
	0x6355, KANJI_SJIS_L1,  // 捕
	0x6B69, KANJI_SJIS_L1,  // 歩
	0x752B, KANJI_SJIS_L1,  // 甫
	0x88DC, KANJI_SJIS_L1,  // 補
	0x8F14, KANJI_SJIS_L1,  // 輔
	0x7A42, KANJI_SJIS_L1,  // 穂
	0x52DF, KANJI_SJIS_L1,  // 募
	0x5893, KANJI_SJIS_L1,  // 墓
	0x6155, KANJI_SJIS_L1,  // 慕
	0x620A, KANJI_SJIS_L1,  // 戊
	0x66AE, KANJI_SJIS_L1,  // 暮
	0x6BCD, KANJI_SJIS_L1,  // 母
	0x7C3F, KANJI_SJIS_L1,  // 簿
	0x83E9, KANJI_SJIS_L1,  // 菩
	0x5023, KANJI_SJIS_L1,  // 倣
	0x4FF8, KANJI_SJIS_L1,  // 俸
	0x5305, KANJI_SJIS_L1,  // 包
	0x5446, KANJI_SJIS_L1,  // 呆
	0x5831, KANJI_SJIS_L1,  // 報
	0x5949, KANJI_SJIS_L1,  // 奉
	0x5B9D, KANJI_SJIS_L1,  // 宝
	0x5CF0, KANJI_SJIS_L1,  // 峰
	0x5CEF, KANJI_SJIS_L1,  // 峯
	0x5D29, KANJI_SJIS_L1,  // 崩
	0x5E96, KANJI_SJIS_L1,  // 庖
	0x62B1, KANJI_SJIS_L1,  // 抱
	0x6367, KANJI_SJIS_L1,  // 捧
	0x653E, KANJI_SJIS_L1,  // 放
	0x65B9, KANJI_SJIS_L1,  // 方
	0x670B, KANJI_SJIS_L1,  // 朋
	0x6CD5, KANJI_SJIS_L1,  // 法
	0x6CE1, KANJI_SJIS_L1,  // 泡
	0x70F9, KANJI_SJIS_L1,  // 烹
	0x7832, KANJI_SJIS_L1,  // 砲
	0x7E2B, KANJI_SJIS_L1,  // 縫
	0x80DE, KANJI_SJIS_L1,  // 胞
	0x82B3, KANJI_SJIS_L1,  // 芳
	0x840C, KANJI_SJIS_L1,  // 萌
	0x84EC, KANJI_SJIS_L1,  // 蓬
	0x8702, KANJI_SJIS_L1,  // 蜂
	0x8912, KANJI_SJIS_L1,  // 褒
	0x8A2A, KANJI_SJIS_L1,  // 訪
	0x8C4A, KANJI_SJIS_L1,  // 豊
	0x90A6, KANJI_SJIS_L1,  // 邦
	0x92D2, KANJI_SJIS_L1,  // 鋒
	0x98FD, KANJI_SJIS_L1,  // 飽
	0x9CF3, KANJI_SJIS_L1,  // 鳳
	0x9D6C, KANJI_SJIS_L1,  // 鵬
	0x4E4F, KANJI_SJIS_L1,  // 乏
	0x4EA1, KANJI_SJIS_L1,  // 亡
	0x508D, KANJI_SJIS_L1,  // 傍
	0x5256, KANJI_SJIS_L1,  // 剖
	0x574A, KANJI_SJIS_L1,  // 坊
	0x59A8, KANJI_SJIS_L1,  // 妨
	0x5E3D, KANJI_SJIS_L1,  // 帽
	0x5FD8, KANJI_SJIS_L1,  // 忘
	0x5FD9, KANJI_SJIS_L1,  // 忙
	0x623F, KANJI_SJIS_L1,  // 房
	0x66B4, KANJI_SJIS_L1,  // 暴
	0x671B, KANJI_SJIS_L1,  // 望
	0x67D0, KANJI_SJIS_L1,  // 某
	0x68D2, KANJI_SJIS_L1,  // 棒
	0x5192, KANJI_SJIS_L1,  // 冒
	0x7D21, KANJI_SJIS_L1,  // 紡
	0x80AA, KANJI_SJIS_L1,  // 肪
	0x81A8, KANJI_SJIS_L1,  // 膨
	0x8B00, KANJI_SJIS_L1,  // 謀
	0x8C8C, KANJI_SJIS_L1,  // 貌
	0x8CBF, KANJI_SJIS_L1,  // 貿
	0x927E, KANJI_SJIS_L1,  // 鉾
	0x9632, KANJI_SJIS_L1,  // 防
	0x5420, KANJI_SJIS_L1,  // 吠
	0x982C, KANJI_SJIS_L1,  // 頬
	0x5317, KANJI_SJIS_L1,  // 北
	0x50D5, KANJI_SJIS_L1,  // 僕
	0x535C, KANJI_SJIS_L1,  // 卜
	0x58A8, KANJI_SJIS_L1,  // 墨
	0x64B2, KANJI_SJIS_L1,  // 撲
	0x6734, KANJI_SJIS_L1,  // 朴
	0x7267, KANJI_SJIS_L1,  // 牧
	0x7766, KANJI_SJIS_L1,  // 睦
	0x7A46, KANJI_SJIS_L1,  // 穆
	0x91E6, KANJI_SJIS_L1,  // 釦
	0x52C3, KANJI_SJIS_L1,  // 勃
	0x6CA1, KANJI_SJIS_L1,  // 没
	0x6B86, KANJI_SJIS_L1,  // 殆
	0x5800, KANJI_SJIS_L1,  // 堀
	0x5E4C, KANJI_SJIS_L1,  // 幌
	0x5954, KANJI_SJIS_L1,  // 奔
	0x672C, KANJI_SJIS_L1,  // 本
	0x7FFB, KANJI_SJIS_L1,  // 翻
	0x51E1, KANJI_SJIS_L1,  // 凡
	0x76C6, KANJI_SJIS_L1,  // 盆
	0x3000, KANJI_SJIS_L1,  // 　
	0x6469, KANJI_SJIS_L1,  // 摩
	0x78E8, KANJI_SJIS_L1,  // 磨
	0x9B54, KANJI_SJIS_L1,  // 魔
	0x9EBB, KANJI_SJIS_L1,  // 麻
	0x57CB, KANJI_SJIS_L1,  // 埋
	0x59B9, KANJI_SJIS_L1,  // 妹
	0x6627, KANJI_SJIS_L1,  // 昧
	0x679A, KANJI_SJIS_L1,  // 枚
	0x6BCE, KANJI_SJIS_L1,  // 毎
	0x54E9, KANJI_SJIS_L1,  // 哩
	0x69D9, KANJI_SJIS_L1,  // 槙
	0x5E55, KANJI_SJIS_L1,  // 幕
	0x819C, KANJI_SJIS_L1,  // 膜
	0x6795, KANJI_SJIS_L1,  // 枕
	0x9BAA, KANJI_SJIS_L1,  // 鮪
	0x67FE, KANJI_SJIS_L1,  // 柾
	0x9C52, KANJI_SJIS_L1,  // 鱒
	0x685D, KANJI_SJIS_L1,  // 桝
	0x4EA6, KANJI_SJIS_L1,  // 亦
	0x4FE3, KANJI_SJIS_L1,  // 俣
	0x53C8, KANJI_SJIS_L1,  // 又
	0x62B9, KANJI_SJIS_L1,  // 抹
	0x672B, KANJI_SJIS_L1,  // 末
	0x6CAB, KANJI_SJIS_L1,  // 沫
	0x8FC4, KANJI_SJIS_L1,  // 迄
	0x4FAD, KANJI_SJIS_L1,  // 侭
	0x7E6D, KANJI_SJIS_L1,  // 繭
	0x9EBF, KANJI_SJIS_L1,  // 麿
	0x4E07, KANJI_SJIS_L1,  // 万
	0x6162, KANJI_SJIS_L1,  // 慢
	0x6E80, KANJI_SJIS_L1,  // 満
	0x6F2B, KANJI_SJIS_L1,  // 漫
	0x8513, KANJI_SJIS_L1,  // 蔓
	0x5473, KANJI_SJIS_L1,  // 味
	0x672A, KANJI_SJIS_L1,  // 未
	0x9B45, KANJI_SJIS_L1,  // 魅
	0x5DF3, KANJI_SJIS_L1,  // 巳
	0x7B95, KANJI_SJIS_L1,  // 箕
	0x5CAC, KANJI_SJIS_L1,  // 岬
	0x5BC6, KANJI_SJIS_L1,  // 密
	0x871C, KANJI_SJIS_L1,  // 蜜
	0x6E4A, KANJI_SJIS_L1,  // 湊
	0x84D1, KANJI_SJIS_L1,  // 蓑
	0x7A14, KANJI_SJIS_L1,  // 稔
	0x8108, KANJI_SJIS_L1,  // 脈
	0x5999, KANJI_SJIS_L1,  // 妙
	0x7C8D, KANJI_SJIS_L1,  // 粍
	0x6C11, KANJI_SJIS_L1,  // 民
	0x7720, KANJI_SJIS_L1,  // 眠
	0x52D9, KANJI_SJIS_L1,  // 務
	0x5922, KANJI_SJIS_L1,  // 夢
	0x7121, KANJI_SJIS_L1,  // 無
	0x725F, KANJI_SJIS_L1,  // 牟
	0x77DB, KANJI_SJIS_L1,  // 矛
	0x9727, KANJI_SJIS_L1,  // 霧
	0x9D61, KANJI_SJIS_L1,  // 鵡
	0x690B, KANJI_SJIS_L1,  // 椋
	0x5A7F, KANJI_SJIS_L1,  // 婿
	0x5A18, KANJI_SJIS_L1,  // 娘
	0x51A5, KANJI_SJIS_L1,  // 冥
	0x540D, KANJI_SJIS_L1,  // 名
	0x547D, KANJI_SJIS_L1,  // 命
	0x660E, KANJI_SJIS_L1,  // 明
	0x76DF, KANJI_SJIS_L1,  // 盟
	0x8FF7, KANJI_SJIS_L1,  // 迷
	0x9298, KANJI_SJIS_L1,  // 銘
	0x9CF4, KANJI_SJIS_L1,  // 鳴
	0x59EA, KANJI_SJIS_L1,  // 姪
	0x725D, KANJI_SJIS_L1,  // 牝
	0x6EC5, KANJI_SJIS_L1,  // 滅
	0x514D, KANJI_SJIS_L1,  // 免
	0x68C9, KANJI_SJIS_L1,  // 棉
	0x7DBF, KANJI_SJIS_L1,  // 綿
	0x7DEC, KANJI_SJIS_L1,  // 緬
	0x9762, KANJI_SJIS_L1,  // 面
	0x9EBA, KANJI_SJIS_L1,  // 麺
	0x6478, KANJI_SJIS_L1,  // 摸
	0x6A21, KANJI_SJIS_L1,  // 模
	0x8302, KANJI_SJIS_L1,  // 茂
	0x5984, KANJI_SJIS_L1,  // 妄
	0x5B5F, KANJI_SJIS_L1,  // 孟
	0x6BDB, KANJI_SJIS_L1,  // 毛
	0x731B, KANJI_SJIS_L1,  // 猛
	0x76F2, KANJI_SJIS_L1,  // 盲
	0x7DB2, KANJI_SJIS_L1,  // 網
	0x8017, KANJI_SJIS_L1,  // 耗
	0x8499, KANJI_SJIS_L1,  // 蒙
	0x5132, KANJI_SJIS_L1,  // 儲
	0x6728, KANJI_SJIS_L1,  // 木
	0x9ED9, KANJI_SJIS_L1,  // 黙
	0x76EE, KANJI_SJIS_L1,  // 目
	0x6762, KANJI_SJIS_L1,  // 杢
	0x52FF, KANJI_SJIS_L1,  // 勿
	0x9905, KANJI_SJIS_L1,  // 餅
	0x5C24, KANJI_SJIS_L1,  // 尤
	0x623B, KANJI_SJIS_L1,  // 戻
	0x7C7E, KANJI_SJIS_L1,  // 籾
	0x8CB0, KANJI_SJIS_L1,  // 貰
	0x554F, KANJI_SJIS_L1,  // 問
	0x60B6, KANJI_SJIS_L1,  // 悶
	0x7D0B, KANJI_SJIS_L1,  // 紋
	0x9580, KANJI_SJIS_L1,  // 門
	0x5301, KANJI_SJIS_L1,  // 匁
	0x4E5F, KANJI_SJIS_L1,  // 也
	0x51B6, KANJI_SJIS_L1,  // 冶
	0x591C, KANJI_SJIS_L1,  // 夜
	0x723A, KANJI_SJIS_L1,  // 爺
	0x8036, KANJI_SJIS_L1,  // 耶
	0x91CE, KANJI_SJIS_L1,  // 野
	0x5F25, KANJI_SJIS_L1,  // 弥
	0x77E2, KANJI_SJIS_L1,  // 矢
	0x5384, KANJI_SJIS_L1,  // 厄
	0x5F79, KANJI_SJIS_L1,  // 役
	0x7D04, KANJI_SJIS_L1,  // 約
	0x85AC, KANJI_SJIS_L1,  // 薬
	0x8A33, KANJI_SJIS_L1,  // 訳
	0x8E8D, KANJI_SJIS_L1,  // 躍
	0x9756, KANJI_SJIS_L1,  // 靖
	0x67F3, KANJI_SJIS_L1,  // 柳
	0x85AE, KANJI_SJIS_L1,  // 薮
	0x9453, KANJI_SJIS_L1,  // 鑓
	0x6109, KANJI_SJIS_L1,  // 愉
	0x6108, KANJI_SJIS_L1,  // 愈
	0x6CB9, KANJI_SJIS_L1,  // 油
	0x7652, KANJI_SJIS_L1,  // 癒
	0x8AED, KANJI_SJIS_L1,  // 諭
	0x8F38, KANJI_SJIS_L1,  // 輸
	0x552F, KANJI_SJIS_L1,  // 唯
	0x4F51, KANJI_SJIS_L1,  // 佑
	0x512A, KANJI_SJIS_L1,  // 優
	0x52C7, KANJI_SJIS_L1,  // 勇
	0x53CB, KANJI_SJIS_L1,  // 友
	0x5BA5, KANJI_SJIS_L1,  // 宥
	0x5E7D, KANJI_SJIS_L1,  // 幽
	0x60A0, KANJI_SJIS_L1,  // 悠
	0x6182, KANJI_SJIS_L1,  // 憂
	0x63D6, KANJI_SJIS_L1,  // 揖
	0x6709, KANJI_SJIS_L1,  // 有
	0x67DA, KANJI_SJIS_L1,  // 柚
	0x6E67, KANJI_SJIS_L1,  // 湧
	0x6D8C, KANJI_SJIS_L1,  // 涌
	0x7336, KANJI_SJIS_L1,  // 猶
	0x7337, KANJI_SJIS_L1,  // 猷
	0x7531, KANJI_SJIS_L1,  // 由
	0x7950, KANJI_SJIS_L1,  // 祐
	0x88D5, KANJI_SJIS_L1,  // 裕
	0x8A98, KANJI_SJIS_L1,  // 誘
	0x904A, KANJI_SJIS_L1,  // 遊
	0x9091, KANJI_SJIS_L1,  // 邑
	0x90F5, KANJI_SJIS_L1,  // 郵
	0x96C4, KANJI_SJIS_L1,  // 雄
	0x878D, KANJI_SJIS_L1,  // 融
	0x5915, KANJI_SJIS_L1,  // 夕
	0x4E88, KANJI_SJIS_L1,  // 予
	0x4F59, KANJI_SJIS_L1,  // 余
	0x4E0E, KANJI_SJIS_L1,  // 与
	0x8A89, KANJI_SJIS_L1,  // 誉
	0x8F3F, KANJI_SJIS_L1,  // 輿
	0x9810, KANJI_SJIS_L1,  // 預
	0x50AD, KANJI_SJIS_L1,  // 傭
	0x5E7C, KANJI_SJIS_L1,  // 幼
	0x5996, KANJI_SJIS_L1,  // 妖
	0x5BB9, KANJI_SJIS_L1,  // 容
	0x5EB8, KANJI_SJIS_L1,  // 庸
	0x63DA, KANJI_SJIS_L1,  // 揚
	0x63FA, KANJI_SJIS_L1,  // 揺
	0x64C1, KANJI_SJIS_L1,  // 擁
	0x66DC, KANJI_SJIS_L1,  // 曜
	0x694A, KANJI_SJIS_L1,  // 楊
	0x69D8, KANJI_SJIS_L1,  // 様
	0x6D0B, KANJI_SJIS_L1,  // 洋
	0x6EB6, KANJI_SJIS_L1,  // 溶
	0x7194, KANJI_SJIS_L1,  // 熔
	0x7528, KANJI_SJIS_L1,  // 用
	0x7AAF, KANJI_SJIS_L1,  // 窯
	0x7F8A, KANJI_SJIS_L1,  // 羊
	0x8000, KANJI_SJIS_L1,  // 耀
	0x8449, KANJI_SJIS_L1,  // 葉
	0x84C9, KANJI_SJIS_L1,  // 蓉
	0x8981, KANJI_SJIS_L1,  // 要
	0x8B21, KANJI_SJIS_L1,  // 謡
	0x8E0A, KANJI_SJIS_L1,  // 踊
	0x9065, KANJI_SJIS_L1,  // 遥
	0x967D, KANJI_SJIS_L1,  // 陽
	0x990A, KANJI_SJIS_L1,  // 養
	0x617E, KANJI_SJIS_L1,  // 慾
	0x6291, KANJI_SJIS_L1,  // 抑
	0x6B32, KANJI_SJIS_L1,  // 欲
	0x3000, KANJI_SJIS_L1,  // 　
	0x6C83, KANJI_SJIS_L1,  // 沃
	0x6D74, KANJI_SJIS_L1,  // 浴
	0x7FCC, KANJI_SJIS_L1,  // 翌
	0x7FFC, KANJI_SJIS_L1,  // 翼
	0x6DC0, KANJI_SJIS_L1,  // 淀
	0x7F85, KANJI_SJIS_L1,  // 羅
	0x87BA, KANJI_SJIS_L1,  // 螺
	0x88F8, KANJI_SJIS_L1,  // 裸
	0x6765, KANJI_SJIS_L1,  // 来
	0x83B1, KANJI_SJIS_L1,  // 莱
	0x983C, KANJI_SJIS_L1,  // 頼
	0x96F7, KANJI_SJIS_L1,  // 雷
	0x6D1B, KANJI_SJIS_L1,  // 洛
	0x7D61, KANJI_SJIS_L1,  // 絡
	0x843D, KANJI_SJIS_L1,  // 落
	0x916A, KANJI_SJIS_L1,  // 酪
	0x4E71, KANJI_SJIS_L1,  // 乱
	0x5375, KANJI_SJIS_L1,  // 卵
	0x5D50, KANJI_SJIS_L1,  // 嵐
	0x6B04, KANJI_SJIS_L1,  // 欄
	0x6FEB, KANJI_SJIS_L1,  // 濫
	0x85CD, KANJI_SJIS_L1,  // 藍
	0x862D, KANJI_SJIS_L1,  // 蘭
	0x89A7, KANJI_SJIS_L1,  // 覧
	0x5229, KANJI_SJIS_L1,  // 利
	0x540F, KANJI_SJIS_L1,  // 吏
	0x5C65, KANJI_SJIS_L1,  // 履
	0x674E, KANJI_SJIS_L1,  // 李
	0x68A8, KANJI_SJIS_L1,  // 梨
	0x7406, KANJI_SJIS_L1,  // 理
	0x7483, KANJI_SJIS_L1,  // 璃
	0x75E2, KANJI_SJIS_L1,  // 痢
	0x88CF, KANJI_SJIS_L1,  // 裏
	0x88E1, KANJI_SJIS_L1,  // 裡
	0x91CC, KANJI_SJIS_L1,  // 里
	0x96E2, KANJI_SJIS_L1,  // 離
	0x9678, KANJI_SJIS_L1,  // 陸
	0x5F8B, KANJI_SJIS_L1,  // 律
	0x7387, KANJI_SJIS_L1,  // 率
	0x7ACB, KANJI_SJIS_L1,  // 立
	0x844E, KANJI_SJIS_L1,  // 葎
	0x63A0, KANJI_SJIS_L1,  // 掠
	0x7565, KANJI_SJIS_L1,  // 略
	0x5289, KANJI_SJIS_L1,  // 劉
	0x6D41, KANJI_SJIS_L1,  // 流
	0x6E9C, KANJI_SJIS_L1,  // 溜
	0x7409, KANJI_SJIS_L1,  // 琉
	0x7559, KANJI_SJIS_L1,  // 留
	0x786B, KANJI_SJIS_L1,  // 硫
	0x7C92, KANJI_SJIS_L1,  // 粒
	0x9686, KANJI_SJIS_L1,  // 隆
	0x7ADC, KANJI_SJIS_L1,  // 竜
	0x9F8D, KANJI_SJIS_L1,  // 龍
	0x4FB6, KANJI_SJIS_L1,  // 侶
	0x616E, KANJI_SJIS_L1,  // 慮
	0x65C5, KANJI_SJIS_L1,  // 旅
	0x865C, KANJI_SJIS_L1,  // 虜
	0x4E86, KANJI_SJIS_L1,  // 了
	0x4EAE, KANJI_SJIS_L1,  // 亮
	0x50DA, KANJI_SJIS_L1,  // 僚
	0x4E21, KANJI_SJIS_L1,  // 両
	0x51CC, KANJI_SJIS_L1,  // 凌
	0x5BEE, KANJI_SJIS_L1,  // 寮
	0x6599, KANJI_SJIS_L1,  // 料
	0x6881, KANJI_SJIS_L1,  // 梁
	0x6DBC, KANJI_SJIS_L1,  // 涼
	0x731F, KANJI_SJIS_L1,  // 猟
	0x7642, KANJI_SJIS_L1,  // 療
	0x77AD, KANJI_SJIS_L1,  // 瞭
	0x7A1C, KANJI_SJIS_L1,  // 稜
	0x7CE7, KANJI_SJIS_L1,  // 糧
	0x826F, KANJI_SJIS_L1,  // 良
	0x8AD2, KANJI_SJIS_L1,  // 諒
	0x907C, KANJI_SJIS_L1,  // 遼
	0x91CF, KANJI_SJIS_L1,  // 量
	0x9675, KANJI_SJIS_L1,  // 陵
	0x9818, KANJI_SJIS_L1,  // 領
	0x529B, KANJI_SJIS_L1,  // 力
	0x7DD1, KANJI_SJIS_L1,  // 緑
	0x502B, KANJI_SJIS_L1,  // 倫
	0x5398, KANJI_SJIS_L1,  // 厘
	0x6797, KANJI_SJIS_L1,  // 林
	0x6DCB, KANJI_SJIS_L1,  // 淋
	0x71D0, KANJI_SJIS_L1,  // 燐
	0x7433, KANJI_SJIS_L1,  // 琳
	0x81E8, KANJI_SJIS_L1,  // 臨
	0x8F2A, KANJI_SJIS_L1,  // 輪
	0x96A3, KANJI_SJIS_L1,  // 隣
	0x9C57, KANJI_SJIS_L1,  // 鱗
	0x9E9F, KANJI_SJIS_L1,  // 麟
	0x7460, KANJI_SJIS_L1,  // 瑠
	0x5841, KANJI_SJIS_L1,  // 塁
	0x6D99, KANJI_SJIS_L1,  // 涙
	0x7D2F, KANJI_SJIS_L1,  // 累
	0x985E, KANJI_SJIS_L1,  // 類
	0x4EE4, KANJI_SJIS_L1,  // 令
	0x4F36, KANJI_SJIS_L1,  // 伶
	0x4F8B, KANJI_SJIS_L1,  // 例
	0x51B7, KANJI_SJIS_L1,  // 冷
	0x52B1, KANJI_SJIS_L1,  // 励
	0x5DBA, KANJI_SJIS_L1,  // 嶺
	0x601C, KANJI_SJIS_L1,  // 怜
	0x73B2, KANJI_SJIS_L1,  // 玲
	0x793C, KANJI_SJIS_L1,  // 礼
	0x82D3, KANJI_SJIS_L1,  // 苓
	0x9234, KANJI_SJIS_L1,  // 鈴
	0x96B7, KANJI_SJIS_L1,  // 隷
	0x96F6, KANJI_SJIS_L1,  // 零
	0x970A, KANJI_SJIS_L1,  // 霊
	0x9E97, KANJI_SJIS_L1,  // 麗
	0x9F62, KANJI_SJIS_L1,  // 齢
	0x66A6, KANJI_SJIS_L1,  // 暦
	0x6B74, KANJI_SJIS_L1,  // 歴
	0x5217, KANJI_SJIS_L1,  // 列
	0x52A3, KANJI_SJIS_L1,  // 劣
	0x70C8, KANJI_SJIS_L1,  // 烈
	0x88C2, KANJI_SJIS_L1,  // 裂
	0x5EC9, KANJI_SJIS_L1,  // 廉
	0x604B, KANJI_SJIS_L1,  // 恋
	0x6190, KANJI_SJIS_L1,  // 憐
	0x6F23, KANJI_SJIS_L1,  // 漣
	0x7149, KANJI_SJIS_L1,  // 煉
	0x7C3E, KANJI_SJIS_L1,  // 簾
	0x7DF4, KANJI_SJIS_L1,  // 練
	0x806F, KANJI_SJIS_L1,  // 聯
	0x84EE, KANJI_SJIS_L1,  // 蓮
	0x9023, KANJI_SJIS_L1,  // 連
	0x932C, KANJI_SJIS_L1,  // 錬
	0x5442, KANJI_SJIS_L1,  // 呂
	0x9B6F, KANJI_SJIS_L1,  // 魯
	0x6AD3, KANJI_SJIS_L1,  // 櫓
	0x7089, KANJI_SJIS_L1,  // 炉
	0x8CC2, KANJI_SJIS_L1,  // 賂
	0x8DEF, KANJI_SJIS_L1,  // 路
	0x9732, KANJI_SJIS_L1,  // 露
	0x52B4, KANJI_SJIS_L1,  // 労
	0x5A41, KANJI_SJIS_L1,  // 婁
	0x5ECA, KANJI_SJIS_L1,  // 廊
	0x5F04, KANJI_SJIS_L1,  // 弄
	0x6717, KANJI_SJIS_L1,  // 朗
	0x697C, KANJI_SJIS_L1,  // 楼
	0x6994, KANJI_SJIS_L1,  // 榔
	0x6D6A, KANJI_SJIS_L1,  // 浪
	0x6F0F, KANJI_SJIS_L1,  // 漏
	0x7262, KANJI_SJIS_L1,  // 牢
	0x72FC, KANJI_SJIS_L1,  // 狼
	0x7BED, KANJI_SJIS_L1,  // 篭
	0x8001, KANJI_SJIS_L1,  // 老
	0x807E, KANJI_SJIS_L1,  // 聾
	0x874B, KANJI_SJIS_L1,  // 蝋
	0x90CE, KANJI_SJIS_L1,  // 郎
	0x516D, KANJI_SJIS_L1,  // 六
	0x9E93, KANJI_SJIS_L1,  // 麓
	0x7984, KANJI_SJIS_L1,  // 禄
	0x808B, KANJI_SJIS_L1,  // 肋
	0x9332, KANJI_SJIS_L1,  // 録
	0x8AD6, KANJI_SJIS_L1,  // 論
	0x502D, KANJI_SJIS_L1,  // 倭
	0x548C, KANJI_SJIS_L1,  // 和
	0x8A71, KANJI_SJIS_L1,  // 話
	0x6B6A, KANJI_SJIS_L1,  // 歪
	0x8CC4, KANJI_SJIS_L1,  // 賄
	0x8107, KANJI_SJIS_L1,  // 脇
	0x60D1, KANJI_SJIS_L1,  // 惑
	0x67A0, KANJI_SJIS_L1,  // 枠
	0x9DF2, KANJI_SJIS_L1,  // 鷲
	0x4E99, KANJI_SJIS_L1,  // 亙
	0x4E98, KANJI_SJIS_L1,  // 亘
	0x9C10, KANJI_SJIS_L1,  // 鰐
	0x8A6B, KANJI_SJIS_L1,  // 詫
	0x85C1, KANJI_SJIS_L1,  // 藁
	0x8568, KANJI_SJIS_L1,  // 蕨
	0x6900, KANJI_SJIS_L1,  // 椀
	0x6E7E, KANJI_SJIS_L1,  // 湾
	0x7897, KANJI_SJIS_L1,  // 碗
	0x8155, KANJI_SJIS_L1,  // 腕
	0x5F0C, KANJI_SJIS_L2,  // 弌
	0x4E10, KANJI_SJIS_L2,  // 丐
	0x4E15, KANJI_SJIS_L2,  // 丕
	0x4E2A, KANJI_SJIS_L2,  // 个
	0x4E31, KANJI_SJIS_L2,  // 丱
	0x4E36, KANJI_SJIS_L2,  // 丶
	0x4E3C, KANJI_SJIS_L2,  // 丼
	0x4E3F, KANJI_SJIS_L2,  // 丿
	0x4E42, KANJI_SJIS_L2,  // 乂
	0x4E56, KANJI_SJIS_L2,  // 乖
	0x4E58, KANJI_SJIS_L2,  // 乘
	0x4E82, KANJI_SJIS_L2,  // 亂
	0x4E85, KANJI_SJIS_L2,  // 亅
	0x8C6B, KANJI_SJIS_L2,  // 豫
	0x4E8A, KANJI_SJIS_L2,  // 亊
	0x8212, KANJI_SJIS_L2,  // 舒
	0x5F0D, KANJI_SJIS_L2,  // 弍
	0x4E8E, KANJI_SJIS_L2,  // 于
	0x4E9E, KANJI_SJIS_L2,  // 亞
	0x4E9F, KANJI_SJIS_L2,  // 亟
	0x4EA0, KANJI_SJIS_L2,  // 亠
	0x4EA2, KANJI_SJIS_L2,  // 亢
	0x4EB0, KANJI_SJIS_L2,  // 亰
	0x4EB3, KANJI_SJIS_L2,  // 亳
	0x4EB6, KANJI_SJIS_L2,  // 亶
	0x4ECE, KANJI_SJIS_L2,  // 从
	0x4ECD, KANJI_SJIS_L2,  // 仍
	0x4EC4, KANJI_SJIS_L2,  // 仄
	0x4EC6, KANJI_SJIS_L2,  // 仆
	0x4EC2, KANJI_SJIS_L2,  // 仂
	0x4ED7, KANJI_SJIS_L2,  // 仗
	0x4EDE, KANJI_SJIS_L2,  // 仞
	0x4EED, KANJI_SJIS_L2,  // 仭
	0x4EDF, KANJI_SJIS_L2,  // 仟
	0x4EF7, KANJI_SJIS_L2,  // 价
	0x4F09, KANJI_SJIS_L2,  // 伉
	0x4F5A, KANJI_SJIS_L2,  // 佚
	0x4F30, KANJI_SJIS_L2,  // 估
	0x4F5B, KANJI_SJIS_L2,  // 佛
	0x4F5D, KANJI_SJIS_L2,  // 佝
	0x4F57, KANJI_SJIS_L2,  // 佗
	0x4F47, KANJI_SJIS_L2,  // 佇
	0x4F76, KANJI_SJIS_L2,  // 佶
	0x4F88, KANJI_SJIS_L2,  // 侈
	0x4F8F, KANJI_SJIS_L2,  // 侏
	0x4F98, KANJI_SJIS_L2,  // 侘
	0x4F7B, KANJI_SJIS_L2,  // 佻
	0x4F69, KANJI_SJIS_L2,  // 佩
	0x4F70, KANJI_SJIS_L2,  // 佰
	0x4F91, KANJI_SJIS_L2,  // 侑
	0x4F6F, KANJI_SJIS_L2,  // 佯
	0x4F86, KANJI_SJIS_L2,  // 來
	0x4F96, KANJI_SJIS_L2,  // 侖
	0x5118, KANJI_SJIS_L2,  // 儘
	0x4FD4, KANJI_SJIS_L2,  // 俔
	0x4FDF, KANJI_SJIS_L2,  // 俟
	0x4FCE, KANJI_SJIS_L2,  // 俎
	0x4FD8, KANJI_SJIS_L2,  // 俘
	0x4FDB, KANJI_SJIS_L2,  // 俛
	0x4FD1, KANJI_SJIS_L2,  // 俑
	0x4FDA, KANJI_SJIS_L2,  // 俚
	0x4FD0, KANJI_SJIS_L2,  // 俐
	0x4FE4, KANJI_SJIS_L2,  // 俤
	0x4FE5, KANJI_SJIS_L2,  // 俥
	0x501A, KANJI_SJIS_L2,  // 倚
	0x5028, KANJI_SJIS_L2,  // 倨
	0x5014, KANJI_SJIS_L2,  // 倔
	0x502A, KANJI_SJIS_L2,  // 倪
	0x5025, KANJI_SJIS_L2,  // 倥
	0x5005, KANJI_SJIS_L2,  // 倅
	0x4F1C, KANJI_SJIS_L2,  // 伜
	0x4FF6, KANJI_SJIS_L2,  // 俶
	0x5021, KANJI_SJIS_L2,  // 倡
	0x5029, KANJI_SJIS_L2,  // 倩
	0x502C, KANJI_SJIS_L2,  // 倬
	0x4FFE, KANJI_SJIS_L2,  // 俾
	0x4FEF, KANJI_SJIS_L2,  // 俯
	0x5011, KANJI_SJIS_L2,  // 們
	0x5006, KANJI_SJIS_L2,  // 倆
	0x5043, KANJI_SJIS_L2,  // 偃
	0x5047, KANJI_SJIS_L2,  // 假
	0x6703, KANJI_SJIS_L2,  // 會
	0x5055, KANJI_SJIS_L2,  // 偕
	0x5050, KANJI_SJIS_L2,  // 偐
	0x5048, KANJI_SJIS_L2,  // 偈
	0x505A, KANJI_SJIS_L2,  // 做
	0x5056, KANJI_SJIS_L2,  // 偖
	0x506C, KANJI_SJIS_L2,  // 偬
	0x5078, KANJI_SJIS_L2,  // 偸
	0x5080, KANJI_SJIS_L2,  // 傀
	0x509A, KANJI_SJIS_L2,  // 傚
	0x5085, KANJI_SJIS_L2,  // 傅
	0x50B4, KANJI_SJIS_L2,  // 傴
	0x50B2, KANJI_SJIS_L2,  // 傲
	0x50C9, KANJI_SJIS_L2,  // 僉
	0x50CA, KANJI_SJIS_L2,  // 僊
	0x50B3, KANJI_SJIS_L2,  // 傳
	0x50C2, KANJI_SJIS_L2,  // 僂
	0x50D6, KANJI_SJIS_L2,  // 僖
	0x50DE, KANJI_SJIS_L2,  // 僞
	0x50E5, KANJI_SJIS_L2,  // 僥
	0x50ED, KANJI_SJIS_L2,  // 僭
	0x50E3, KANJI_SJIS_L2,  // 僣
	0x50EE, KANJI_SJIS_L2,  // 僮
	0x50F9, KANJI_SJIS_L2,  // 價
	0x50F5, KANJI_SJIS_L2,  // 僵
	0x5109, KANJI_SJIS_L2,  // 儉
	0x5101, KANJI_SJIS_L2,  // 儁
	0x5102, KANJI_SJIS_L2,  // 儂
	0x5116, KANJI_SJIS_L2,  // 儖
	0x5115, KANJI_SJIS_L2,  // 儕
	0x5114, KANJI_SJIS_L2,  // 儔
	0x511A, KANJI_SJIS_L2,  // 儚
	0x5121, KANJI_SJIS_L2,  // 儡
	0x513A, KANJI_SJIS_L2,  // 儺
	0x5137, KANJI_SJIS_L2,  // 儷
	0x513C, KANJI_SJIS_L2,  // 儼
	0x513B, KANJI_SJIS_L2,  // 儻
	0x513F, KANJI_SJIS_L2,  // 儿
	0x5140, KANJI_SJIS_L2,  // 兀
	0x5152, KANJI_SJIS_L2,  // 兒
	0x514C, KANJI_SJIS_L2,  // 兌
	0x5154, KANJI_SJIS_L2,  // 兔
	0x5162, KANJI_SJIS_L2,  // 兢
	0x7AF8, KANJI_SJIS_L2,  // 竸
	0x5169, KANJI_SJIS_L2,  // 兩
	0x516A, KANJI_SJIS_L2,  // 兪
	0x516E, KANJI_SJIS_L2,  // 兮
	0x5180, KANJI_SJIS_L2,  // 冀
	0x5182, KANJI_SJIS_L2,  // 冂
	0x56D8, KANJI_SJIS_L2,  // 囘
	0x518C, KANJI_SJIS_L2,  // 册
	0x5189, KANJI_SJIS_L2,  // 冉
	0x518F, KANJI_SJIS_L2,  // 冏
	0x5191, KANJI_SJIS_L2,  // 冑
	0x5193, KANJI_SJIS_L2,  // 冓
	0x5195, KANJI_SJIS_L2,  // 冕
	0x5196, KANJI_SJIS_L2,  // 冖
	0x51A4, KANJI_SJIS_L2,  // 冤
	0x51A6, KANJI_SJIS_L2,  // 冦
	0x51A2, KANJI_SJIS_L2,  // 冢
	0x51A9, KANJI_SJIS_L2,  // 冩
	0x51AA, KANJI_SJIS_L2,  // 冪
	0x51AB, KANJI_SJIS_L2,  // 冫
	0x51B3, KANJI_SJIS_L2,  // 决
	0x51B1, KANJI_SJIS_L2,  // 冱
	0x51B2, KANJI_SJIS_L2,  // 冲
	0x51B0, KANJI_SJIS_L2,  // 冰
	0x51B5, KANJI_SJIS_L2,  // 况
	0x51BD, KANJI_SJIS_L2,  // 冽
	0x51C5, KANJI_SJIS_L2,  // 凅
	0x51C9, KANJI_SJIS_L2,  // 凉
	0x51DB, KANJI_SJIS_L2,  // 凛
	0x51E0, KANJI_SJIS_L2,  // 几
	0x8655, KANJI_SJIS_L2,  // 處
	0x51E9, KANJI_SJIS_L2,  // 凩
	0x51ED, KANJI_SJIS_L2,  // 凭
	0x3000, KANJI_SJIS_L2,  // 　
	0x51F0, KANJI_SJIS_L2,  // 凰
	0x51F5, KANJI_SJIS_L2,  // 凵
	0x51FE, KANJI_SJIS_L2,  // 凾
	0x5204, KANJI_SJIS_L2,  // 刄
	0x520B, KANJI_SJIS_L2,  // 刋
	0x5214, KANJI_SJIS_L2,  // 刔
	0x520E, KANJI_SJIS_L2,  // 刎
	0x5227, KANJI_SJIS_L2,  // 刧
	0x522A, KANJI_SJIS_L2,  // 刪
	0x522E, KANJI_SJIS_L2,  // 刮
	0x5233, KANJI_SJIS_L2,  // 刳
	0x5239, KANJI_SJIS_L2,  // 刹
	0x524F, KANJI_SJIS_L2,  // 剏
	0x5244, KANJI_SJIS_L2,  // 剄
	0x524B, KANJI_SJIS_L2,  // 剋
	0x524C, KANJI_SJIS_L2,  // 剌
	0x525E, KANJI_SJIS_L2,  // 剞
	0x5254, KANJI_SJIS_L2,  // 剔
	0x526A, KANJI_SJIS_L2,  // 剪
	0x5274, KANJI_SJIS_L2,  // 剴
	0x5269, KANJI_SJIS_L2,  // 剩
	0x5273, KANJI_SJIS_L2,  // 剳
	0x527F, KANJI_SJIS_L2,  // 剿
	0x527D, KANJI_SJIS_L2,  // 剽
	0x528D, KANJI_SJIS_L2,  // 劍
	0x5294, KANJI_SJIS_L2,  // 劔
	0x5292, KANJI_SJIS_L2,  // 劒
	0x5271, KANJI_SJIS_L2,  // 剱
	0x5288, KANJI_SJIS_L2,  // 劈
	0x5291, KANJI_SJIS_L2,  // 劑
	0x8FA8, KANJI_SJIS_L2,  // 辨
	0x8FA7, KANJI_SJIS_L2,  // 辧
	0x52AC, KANJI_SJIS_L2,  // 劬
	0x52AD, KANJI_SJIS_L2,  // 劭
	0x52BC, KANJI_SJIS_L2,  // 劼
	0x52B5, KANJI_SJIS_L2,  // 劵
	0x52C1, KANJI_SJIS_L2,  // 勁
	0x52CD, KANJI_SJIS_L2,  // 勍
	0x52D7, KANJI_SJIS_L2,  // 勗
	0x52DE, KANJI_SJIS_L2,  // 勞
	0x52E3, KANJI_SJIS_L2,  // 勣
	0x52E6, KANJI_SJIS_L2,  // 勦
	0x98ED, KANJI_SJIS_L2,  // 飭
	0x52E0, KANJI_SJIS_L2,  // 勠
	0x52F3, KANJI_SJIS_L2,  // 勳
	0x52F5, KANJI_SJIS_L2,  // 勵
	0x52F8, KANJI_SJIS_L2,  // 勸
	0x52F9, KANJI_SJIS_L2,  // 勹
	0x5306, KANJI_SJIS_L2,  // 匆
	0x5308, KANJI_SJIS_L2,  // 匈
	0x7538, KANJI_SJIS_L2,  // 甸
	0x530D, KANJI_SJIS_L2,  // 匍
	0x5310, KANJI_SJIS_L2,  // 匐
	0x530F, KANJI_SJIS_L2,  // 匏
	0x5315, KANJI_SJIS_L2,  // 匕
	0x531A, KANJI_SJIS_L2,  // 匚
	0x5323, KANJI_SJIS_L2,  // 匣
	0x532F, KANJI_SJIS_L2,  // 匯
	0x5331, KANJI_SJIS_L2,  // 匱
	0x5333, KANJI_SJIS_L2,  // 匳
	0x5338, KANJI_SJIS_L2,  // 匸
	0x5340, KANJI_SJIS_L2,  // 區
	0x5346, KANJI_SJIS_L2,  // 卆
	0x5345, KANJI_SJIS_L2,  // 卅
	0x4E17, KANJI_SJIS_L2,  // 丗
	0x5349, KANJI_SJIS_L2,  // 卉
	0x534D, KANJI_SJIS_L2,  // 卍
	0x51D6, KANJI_SJIS_L2,  // 凖
	0x535E, KANJI_SJIS_L2,  // 卞
	0x5369, KANJI_SJIS_L2,  // 卩
	0x536E, KANJI_SJIS_L2,  // 卮
	0x5918, KANJI_SJIS_L2,  // 夘
	0x537B, KANJI_SJIS_L2,  // 卻
	0x5377, KANJI_SJIS_L2,  // 卷
	0x5382, KANJI_SJIS_L2,  // 厂
	0x5396, KANJI_SJIS_L2,  // 厖
	0x53A0, KANJI_SJIS_L2,  // 厠
	0x53A6, KANJI_SJIS_L2,  // 厦
	0x53A5, KANJI_SJIS_L2,  // 厥
	0x53AE, KANJI_SJIS_L2,  // 厮
	0x53B0, KANJI_SJIS_L2,  // 厰
	0x53B6, KANJI_SJIS_L2,  // 厶
	0x53C3, KANJI_SJIS_L2,  // 參
	0x7C12, KANJI_SJIS_L2,  // 簒
	0x96D9, KANJI_SJIS_L2,  // 雙
	0x53DF, KANJI_SJIS_L2,  // 叟
	0x66FC, KANJI_SJIS_L2,  // 曼
	0x71EE, KANJI_SJIS_L2,  // 燮
	0x53EE, KANJI_SJIS_L2,  // 叮
	0x53E8, KANJI_SJIS_L2,  // 叨
	0x53ED, KANJI_SJIS_L2,  // 叭
	0x53FA, KANJI_SJIS_L2,  // 叺
	0x5401, KANJI_SJIS_L2,  // 吁
	0x543D, KANJI_SJIS_L2,  // 吽
	0x5440, KANJI_SJIS_L2,  // 呀
	0x542C, KANJI_SJIS_L2,  // 听
	0x542D, KANJI_SJIS_L2,  // 吭
	0x543C, KANJI_SJIS_L2,  // 吼
	0x542E, KANJI_SJIS_L2,  // 吮
	0x5436, KANJI_SJIS_L2,  // 吶
	0x5429, KANJI_SJIS_L2,  // 吩
	0x541D, KANJI_SJIS_L2,  // 吝
	0x544E, KANJI_SJIS_L2,  // 呎
	0x548F, KANJI_SJIS_L2,  // 咏
	0x5475, KANJI_SJIS_L2,  // 呵
	0x548E, KANJI_SJIS_L2,  // 咎
	0x545F, KANJI_SJIS_L2,  // 呟
	0x5471, KANJI_SJIS_L2,  // 呱
	0x5477, KANJI_SJIS_L2,  // 呷
	0x5470, KANJI_SJIS_L2,  // 呰
	0x5492, KANJI_SJIS_L2,  // 咒
	0x547B, KANJI_SJIS_L2,  // 呻
	0x5480, KANJI_SJIS_L2,  // 咀
	0x5476, KANJI_SJIS_L2,  // 呶
	0x5484, KANJI_SJIS_L2,  // 咄
	0x5490, KANJI_SJIS_L2,  // 咐
	0x5486, KANJI_SJIS_L2,  // 咆
	0x54C7, KANJI_SJIS_L2,  // 哇
	0x54A2, KANJI_SJIS_L2,  // 咢
	0x54B8, KANJI_SJIS_L2,  // 咸
	0x54A5, KANJI_SJIS_L2,  // 咥
	0x54AC, KANJI_SJIS_L2,  // 咬
	0x54C4, KANJI_SJIS_L2,  // 哄
	0x54C8, KANJI_SJIS_L2,  // 哈
	0x54A8, KANJI_SJIS_L2,  // 咨
	0x54AB, KANJI_SJIS_L2,  // 咫
	0x54C2, KANJI_SJIS_L2,  // 哂
	0x54A4, KANJI_SJIS_L2,  // 咤
	0x54BE, KANJI_SJIS_L2,  // 咾
	0x54BC, KANJI_SJIS_L2,  // 咼
	0x54D8, KANJI_SJIS_L2,  // 哘
	0x54E5, KANJI_SJIS_L2,  // 哥
	0x54E6, KANJI_SJIS_L2,  // 哦
	0x550F, KANJI_SJIS_L2,  // 唏
	0x5514, KANJI_SJIS_L2,  // 唔
	0x54FD, KANJI_SJIS_L2,  // 哽
	0x54EE, KANJI_SJIS_L2,  // 哮
	0x54ED, KANJI_SJIS_L2,  // 哭
	0x54FA, KANJI_SJIS_L2,  // 哺
	0x54E2, KANJI_SJIS_L2,  // 哢
	0x5539, KANJI_SJIS_L2,  // 唹
	0x5540, KANJI_SJIS_L2,  // 啀
	0x5563, KANJI_SJIS_L2,  // 啣
	0x554C, KANJI_SJIS_L2,  // 啌
	0x552E, KANJI_SJIS_L2,  // 售
	0x555C, KANJI_SJIS_L2,  // 啜
	0x5545, KANJI_SJIS_L2,  // 啅
	0x5556, KANJI_SJIS_L2,  // 啖
	0x5557, KANJI_SJIS_L2,  // 啗
	0x5538, KANJI_SJIS_L2,  // 唸
	0x5533, KANJI_SJIS_L2,  // 唳
	0x555D, KANJI_SJIS_L2,  // 啝
	0x5599, KANJI_SJIS_L2,  // 喙
	0x5580, KANJI_SJIS_L2,  // 喀
	0x54AF, KANJI_SJIS_L2,  // 咯
	0x558A, KANJI_SJIS_L2,  // 喊
	0x559F, KANJI_SJIS_L2,  // 喟
	0x557B, KANJI_SJIS_L2,  // 啻
	0x557E, KANJI_SJIS_L2,  // 啾
	0x5598, KANJI_SJIS_L2,  // 喘
	0x559E, KANJI_SJIS_L2,  // 喞
	0x55AE, KANJI_SJIS_L2,  // 單
	0x557C, KANJI_SJIS_L2,  // 啼
	0x5583, KANJI_SJIS_L2,  // 喃
	0x55A9, KANJI_SJIS_L2,  // 喩
	0x5587, KANJI_SJIS_L2,  // 喇
	0x55A8, KANJI_SJIS_L2,  // 喨
	0x55DA, KANJI_SJIS_L2,  // 嗚
	0x55C5, KANJI_SJIS_L2,  // 嗅
	0x55DF, KANJI_SJIS_L2,  // 嗟
	0x55C4, KANJI_SJIS_L2,  // 嗄
	0x55DC, KANJI_SJIS_L2,  // 嗜
	0x55E4, KANJI_SJIS_L2,  // 嗤
	0x55D4, KANJI_SJIS_L2,  // 嗔
	0x5614, KANJI_SJIS_L2,  // 嘔
	0x55F7, KANJI_SJIS_L2,  // 嗷
	0x5616, KANJI_SJIS_L2,  // 嘖
	0x55FE, KANJI_SJIS_L2,  // 嗾
	0x55FD, KANJI_SJIS_L2,  // 嗽
	0x561B, KANJI_SJIS_L2,  // 嘛
	0x55F9, KANJI_SJIS_L2,  // 嗹
	0x564E, KANJI_SJIS_L2,  // 噎
	0x5650, KANJI_SJIS_L2,  // 噐
	0x71DF, KANJI_SJIS_L2,  // 營
	0x5634, KANJI_SJIS_L2,  // 嘴
	0x5636, KANJI_SJIS_L2,  // 嘶
	0x5632, KANJI_SJIS_L2,  // 嘲
	0x5638, KANJI_SJIS_L2,  // 嘸
	0x3000, KANJI_SJIS_L2,  // 　
	0x566B, KANJI_SJIS_L2,  // 噫
	0x5664, KANJI_SJIS_L2,  // 噤
	0x562F, KANJI_SJIS_L2,  // 嘯
	0x566C, KANJI_SJIS_L2,  // 噬
	0x566A, KANJI_SJIS_L2,  // 噪
	0x5686, KANJI_SJIS_L2,  // 嚆
	0x5680, KANJI_SJIS_L2,  // 嚀
	0x568A, KANJI_SJIS_L2,  // 嚊
	0x56A0, KANJI_SJIS_L2,  // 嚠
	0x5694, KANJI_SJIS_L2,  // 嚔
	0x568F, KANJI_SJIS_L2,  // 嚏
	0x56A5, KANJI_SJIS_L2,  // 嚥
	0x56AE, KANJI_SJIS_L2,  // 嚮
	0x56B6, KANJI_SJIS_L2,  // 嚶
	0x56B4, KANJI_SJIS_L2,  // 嚴
	0x56C2, KANJI_SJIS_L2,  // 囂
	0x56BC, KANJI_SJIS_L2,  // 嚼
	0x56C1, KANJI_SJIS_L2,  // 囁
	0x56C3, KANJI_SJIS_L2,  // 囃
	0x56C0, KANJI_SJIS_L2,  // 囀
	0x56C8, KANJI_SJIS_L2,  // 囈
	0x56CE, KANJI_SJIS_L2,  // 囎
	0x56D1, KANJI_SJIS_L2,  // 囑
	0x56D3, KANJI_SJIS_L2,  // 囓
	0x56D7, KANJI_SJIS_L2,  // 囗
	0x56EE, KANJI_SJIS_L2,  // 囮
	0x56F9, KANJI_SJIS_L2,  // 囹
	0x5700, KANJI_SJIS_L2,  // 圀
	0x56FF, KANJI_SJIS_L2,  // 囿
	0x5704, KANJI_SJIS_L2,  // 圄
	0x5709, KANJI_SJIS_L2,  // 圉
	0x5708, KANJI_SJIS_L2,  // 圈
	0x570B, KANJI_SJIS_L2,  // 國
	0x570D, KANJI_SJIS_L2,  // 圍
	0x5713, KANJI_SJIS_L2,  // 圓
	0x5718, KANJI_SJIS_L2,  // 團
	0x5716, KANJI_SJIS_L2,  // 圖
	0x55C7, KANJI_SJIS_L2,  // 嗇
	0x571C, KANJI_SJIS_L2,  // 圜
	0x5726, KANJI_SJIS_L2,  // 圦
	0x5737, KANJI_SJIS_L2,  // 圷
	0x5738, KANJI_SJIS_L2,  // 圸
	0x574E, KANJI_SJIS_L2,  // 坎
	0x573B, KANJI_SJIS_L2,  // 圻
	0x5740, KANJI_SJIS_L2,  // 址
	0x574F, KANJI_SJIS_L2,  // 坏
	0x5769, KANJI_SJIS_L2,  // 坩
	0x57C0, KANJI_SJIS_L2,  // 埀
	0x5788, KANJI_SJIS_L2,  // 垈
	0x5761, KANJI_SJIS_L2,  // 坡
	0x577F, KANJI_SJIS_L2,  // 坿
	0x5789, KANJI_SJIS_L2,  // 垉
	0x5793, KANJI_SJIS_L2,  // 垓
	0x57A0, KANJI_SJIS_L2,  // 垠
	0x57B3, KANJI_SJIS_L2,  // 垳
	0x57A4, KANJI_SJIS_L2,  // 垤
	0x57AA, KANJI_SJIS_L2,  // 垪
	0x57B0, KANJI_SJIS_L2,  // 垰
	0x57C3, KANJI_SJIS_L2,  // 埃
	0x57C6, KANJI_SJIS_L2,  // 埆
	0x57D4, KANJI_SJIS_L2,  // 埔
	0x57D2, KANJI_SJIS_L2,  // 埒
	0x57D3, KANJI_SJIS_L2,  // 埓
	0x580A, KANJI_SJIS_L2,  // 堊
	0x57D6, KANJI_SJIS_L2,  // 埖
	0x57E3, KANJI_SJIS_L2,  // 埣
	0x580B, KANJI_SJIS_L2,  // 堋
	0x5819, KANJI_SJIS_L2,  // 堙
	0x581D, KANJI_SJIS_L2,  // 堝
	0x5872, KANJI_SJIS_L2,  // 塲
	0x5821, KANJI_SJIS_L2,  // 堡
	0x5862, KANJI_SJIS_L2,  // 塢
	0x584B, KANJI_SJIS_L2,  // 塋
	0x5870, KANJI_SJIS_L2,  // 塰
	0x6BC0, KANJI_SJIS_L2,  // 毀
	0x5852, KANJI_SJIS_L2,  // 塒
	0x583D, KANJI_SJIS_L2,  // 堽
	0x5879, KANJI_SJIS_L2,  // 塹
	0x5885, KANJI_SJIS_L2,  // 墅
	0x58B9, KANJI_SJIS_L2,  // 墹
	0x589F, KANJI_SJIS_L2,  // 墟
	0x58AB, KANJI_SJIS_L2,  // 墫
	0x58BA, KANJI_SJIS_L2,  // 墺
	0x58DE, KANJI_SJIS_L2,  // 壞
	0x58BB, KANJI_SJIS_L2,  // 墻
	0x58B8, KANJI_SJIS_L2,  // 墸
	0x58AE, KANJI_SJIS_L2,  // 墮
	0x58C5, KANJI_SJIS_L2,  // 壅
	0x58D3, KANJI_SJIS_L2,  // 壓
	0x58D1, KANJI_SJIS_L2,  // 壑
	0x58D7, KANJI_SJIS_L2,  // 壗
	0x58D9, KANJI_SJIS_L2,  // 壙
	0x58D8, KANJI_SJIS_L2,  // 壘
	0x58E5, KANJI_SJIS_L2,  // 壥
	0x58DC, KANJI_SJIS_L2,  // 壜
	0x58E4, KANJI_SJIS_L2,  // 壤
	0x58DF, KANJI_SJIS_L2,  // 壟
	0x58EF, KANJI_SJIS_L2,  // 壯
	0x58FA, KANJI_SJIS_L2,  // 壺
	0x58F9, KANJI_SJIS_L2,  // 壹
	0x58FB, KANJI_SJIS_L2,  // 壻
	0x58FC, KANJI_SJIS_L2,  // 壼
	0x58FD, KANJI_SJIS_L2,  // 壽
	0x5902, KANJI_SJIS_L2,  // 夂
	0x590A, KANJI_SJIS_L2,  // 夊
	0x5910, KANJI_SJIS_L2,  // 夐
	0x591B, KANJI_SJIS_L2,  // 夛
	0x68A6, KANJI_SJIS_L2,  // 梦
	0x5925, KANJI_SJIS_L2,  // 夥
	0x592C, KANJI_SJIS_L2,  // 夬
	0x592D, KANJI_SJIS_L2,  // 夭
	0x5932, KANJI_SJIS_L2,  // 夲
	0x5938, KANJI_SJIS_L2,  // 夸
	0x593E, KANJI_SJIS_L2,  // 夾
	0x7AD2, KANJI_SJIS_L2,  // 竒
	0x5955, KANJI_SJIS_L2,  // 奕
	0x5950, KANJI_SJIS_L2,  // 奐
	0x594E, KANJI_SJIS_L2,  // 奎
	0x595A, KANJI_SJIS_L2,  // 奚
	0x5958, KANJI_SJIS_L2,  // 奘
	0x5962, KANJI_SJIS_L2,  // 奢
	0x5960, KANJI_SJIS_L2,  // 奠
	0x5967, KANJI_SJIS_L2,  // 奧
	0x596C, KANJI_SJIS_L2,  // 奬
	0x5969, KANJI_SJIS_L2,  // 奩
	0x5978, KANJI_SJIS_L2,  // 奸
	0x5981, KANJI_SJIS_L2,  // 妁
	0x599D, KANJI_SJIS_L2,  // 妝
	0x4F5E, KANJI_SJIS_L2,  // 佞
	0x4FAB, KANJI_SJIS_L2,  // 侫
	0x59A3, KANJI_SJIS_L2,  // 妣
	0x59B2, KANJI_SJIS_L2,  // 妲
	0x59C6, KANJI_SJIS_L2,  // 姆
	0x59E8, KANJI_SJIS_L2,  // 姨
	0x59DC, KANJI_SJIS_L2,  // 姜
	0x598D, KANJI_SJIS_L2,  // 妍
	0x59D9, KANJI_SJIS_L2,  // 姙
	0x59DA, KANJI_SJIS_L2,  // 姚
	0x5A25, KANJI_SJIS_L2,  // 娥
	0x5A1F, KANJI_SJIS_L2,  // 娟
	0x5A11, KANJI_SJIS_L2,  // 娑
	0x5A1C, KANJI_SJIS_L2,  // 娜
	0x5A09, KANJI_SJIS_L2,  // 娉
	0x5A1A, KANJI_SJIS_L2,  // 娚
	0x5A40, KANJI_SJIS_L2,  // 婀
	0x5A6C, KANJI_SJIS_L2,  // 婬
	0x5A49, KANJI_SJIS_L2,  // 婉
	0x5A35, KANJI_SJIS_L2,  // 娵
	0x5A36, KANJI_SJIS_L2,  // 娶
	0x5A62, KANJI_SJIS_L2,  // 婢
	0x5A6A, KANJI_SJIS_L2,  // 婪
	0x5A9A, KANJI_SJIS_L2,  // 媚
	0x5ABC, KANJI_SJIS_L2,  // 媼
	0x5ABE, KANJI_SJIS_L2,  // 媾
	0x5ACB, KANJI_SJIS_L2,  // 嫋
	0x5AC2, KANJI_SJIS_L2,  // 嫂
	0x5ABD, KANJI_SJIS_L2,  // 媽
	0x5AE3, KANJI_SJIS_L2,  // 嫣
	0x5AD7, KANJI_SJIS_L2,  // 嫗
	0x5AE6, KANJI_SJIS_L2,  // 嫦
	0x5AE9, KANJI_SJIS_L2,  // 嫩
	0x5AD6, KANJI_SJIS_L2,  // 嫖
	0x5AFA, KANJI_SJIS_L2,  // 嫺
	0x5AFB, KANJI_SJIS_L2,  // 嫻
	0x5B0C, KANJI_SJIS_L2,  // 嬌
	0x5B0B, KANJI_SJIS_L2,  // 嬋
	0x5B16, KANJI_SJIS_L2,  // 嬖
	0x5B32, KANJI_SJIS_L2,  // 嬲
	0x5AD0, KANJI_SJIS_L2,  // 嫐
	0x5B2A, KANJI_SJIS_L2,  // 嬪
	0x5B36, KANJI_SJIS_L2,  // 嬶
	0x5B3E, KANJI_SJIS_L2,  // 嬾
	0x5B43, KANJI_SJIS_L2,  // 孃
	0x5B45, KANJI_SJIS_L2,  // 孅
	0x5B40, KANJI_SJIS_L2,  // 孀
	0x5B51, KANJI_SJIS_L2,  // 孑
	0x5B55, KANJI_SJIS_L2,  // 孕
	0x5B5A, KANJI_SJIS_L2,  // 孚
	0x5B5B, KANJI_SJIS_L2,  // 孛
	0x5B65, KANJI_SJIS_L2,  // 孥
	0x5B69, KANJI_SJIS_L2,  // 孩
	0x5B70, KANJI_SJIS_L2,  // 孰
	0x5B73, KANJI_SJIS_L2,  // 孳
	0x5B75, KANJI_SJIS_L2,  // 孵
	0x5B78, KANJI_SJIS_L2,  // 學
	0x6588, KANJI_SJIS_L2,  // 斈
	0x5B7A, KANJI_SJIS_L2,  // 孺
	0x5B80, KANJI_SJIS_L2,  // 宀
	0x3000, KANJI_SJIS_L2,  // 　
	0x5B83, KANJI_SJIS_L2,  // 它
	0x5BA6, KANJI_SJIS_L2,  // 宦
	0x5BB8, KANJI_SJIS_L2,  // 宸
	0x5BC3, KANJI_SJIS_L2,  // 寃
	0x5BC7, KANJI_SJIS_L2,  // 寇
	0x5BC9, KANJI_SJIS_L2,  // 寉
	0x5BD4, KANJI_SJIS_L2,  // 寔
	0x5BD0, KANJI_SJIS_L2,  // 寐
	0x5BE4, KANJI_SJIS_L2,  // 寤
	0x5BE6, KANJI_SJIS_L2,  // 實
	0x5BE2, KANJI_SJIS_L2,  // 寢
	0x5BDE, KANJI_SJIS_L2,  // 寞
	0x5BE5, KANJI_SJIS_L2,  // 寥
	0x5BEB, KANJI_SJIS_L2,  // 寫
	0x5BF0, KANJI_SJIS_L2,  // 寰
	0x5BF6, KANJI_SJIS_L2,  // 寶
	0x5BF3, KANJI_SJIS_L2,  // 寳
	0x5C05, KANJI_SJIS_L2,  // 尅
	0x5C07, KANJI_SJIS_L2,  // 將
	0x5C08, KANJI_SJIS_L2,  // 專
	0x5C0D, KANJI_SJIS_L2,  // 對
	0x5C13, KANJI_SJIS_L2,  // 尓
	0x5C20, KANJI_SJIS_L2,  // 尠
	0x5C22, KANJI_SJIS_L2,  // 尢
	0x5C28, KANJI_SJIS_L2,  // 尨
	0x5C38, KANJI_SJIS_L2,  // 尸
	0x5C39, KANJI_SJIS_L2,  // 尹
	0x5C41, KANJI_SJIS_L2,  // 屁
	0x5C46, KANJI_SJIS_L2,  // 屆
	0x5C4E, KANJI_SJIS_L2,  // 屎
	0x5C53, KANJI_SJIS_L2,  // 屓
	0x5C50, KANJI_SJIS_L2,  // 屐
	0x5C4F, KANJI_SJIS_L2,  // 屏
	0x5B71, KANJI_SJIS_L2,  // 孱
	0x5C6C, KANJI_SJIS_L2,  // 屬
	0x5C6E, KANJI_SJIS_L2,  // 屮
	0x4E62, KANJI_SJIS_L2,  // 乢
	0x5C76, KANJI_SJIS_L2,  // 屶
	0x5C79, KANJI_SJIS_L2,  // 屹
	0x5C8C, KANJI_SJIS_L2,  // 岌
	0x5C91, KANJI_SJIS_L2,  // 岑
	0x5C94, KANJI_SJIS_L2,  // 岔
	0x599B, KANJI_SJIS_L2,  // 妛
	0x5CAB, KANJI_SJIS_L2,  // 岫
	0x5CBB, KANJI_SJIS_L2,  // 岻
	0x5CB6, KANJI_SJIS_L2,  // 岶
	0x5CBC, KANJI_SJIS_L2,  // 岼
	0x5CB7, KANJI_SJIS_L2,  // 岷
	0x5CC5, KANJI_SJIS_L2,  // 峅
	0x5CBE, KANJI_SJIS_L2,  // 岾
	0x5CC7, KANJI_SJIS_L2,  // 峇
	0x5CD9, KANJI_SJIS_L2,  // 峙
	0x5CE9, KANJI_SJIS_L2,  // 峩
	0x5CFD, KANJI_SJIS_L2,  // 峽
	0x5CFA, KANJI_SJIS_L2,  // 峺
	0x5CED, KANJI_SJIS_L2,  // 峭
	0x5D8C, KANJI_SJIS_L2,  // 嶌
	0x5CEA, KANJI_SJIS_L2,  // 峪
	0x5D0B, KANJI_SJIS_L2,  // 崋
	0x5D15, KANJI_SJIS_L2,  // 崕
	0x5D17, KANJI_SJIS_L2,  // 崗
	0x5D5C, KANJI_SJIS_L2,  // 嵜
	0x5D1F, KANJI_SJIS_L2,  // 崟
	0x5D1B, KANJI_SJIS_L2,  // 崛
	0x5D11, KANJI_SJIS_L2,  // 崑
	0x5D14, KANJI_SJIS_L2,  // 崔
	0x5D22, KANJI_SJIS_L2,  // 崢
	0x5D1A, KANJI_SJIS_L2,  // 崚
	0x5D19, KANJI_SJIS_L2,  // 崙
	0x5D18, KANJI_SJIS_L2,  // 崘
	0x5D4C, KANJI_SJIS_L2,  // 嵌
	0x5D52, KANJI_SJIS_L2,  // 嵒
	0x5D4E, KANJI_SJIS_L2,  // 嵎
	0x5D4B, KANJI_SJIS_L2,  // 嵋
	0x5D6C, KANJI_SJIS_L2,  // 嵬
	0x5D73, KANJI_SJIS_L2,  // 嵳
	0x5D76, KANJI_SJIS_L2,  // 嵶
	0x5D87, KANJI_SJIS_L2,  // 嶇
	0x5D84, KANJI_SJIS_L2,  // 嶄
	0x5D82, KANJI_SJIS_L2,  // 嶂
	0x5DA2, KANJI_SJIS_L2,  // 嶢
	0x5D9D, KANJI_SJIS_L2,  // 嶝
	0x5DAC, KANJI_SJIS_L2,  // 嶬
	0x5DAE, KANJI_SJIS_L2,  // 嶮
	0x5DBD, KANJI_SJIS_L2,  // 嶽
	0x5D90, KANJI_SJIS_L2,  // 嶐
	0x5DB7, KANJI_SJIS_L2,  // 嶷
	0x5DBC, KANJI_SJIS_L2,  // 嶼
	0x5DC9, KANJI_SJIS_L2,  // 巉
	0x5DCD, KANJI_SJIS_L2,  // 巍
	0x5DD3, KANJI_SJIS_L2,  // 巓
	0x5DD2, KANJI_SJIS_L2,  // 巒
	0x5DD6, KANJI_SJIS_L2,  // 巖
	0x5DDB, KANJI_SJIS_L2,  // 巛
	0x5DEB, KANJI_SJIS_L2,  // 巫
	0x5DF2, KANJI_SJIS_L2,  // 已
	0x5DF5, KANJI_SJIS_L2,  // 巵
	0x5E0B, KANJI_SJIS_L2,  // 帋
	0x5E1A, KANJI_SJIS_L2,  // 帚
	0x5E19, KANJI_SJIS_L2,  // 帙
	0x5E11, KANJI_SJIS_L2,  // 帑
	0x5E1B, KANJI_SJIS_L2,  // 帛
	0x5E36, KANJI_SJIS_L2,  // 帶
	0x5E37, KANJI_SJIS_L2,  // 帷
	0x5E44, KANJI_SJIS_L2,  // 幄
	0x5E43, KANJI_SJIS_L2,  // 幃
	0x5E40, KANJI_SJIS_L2,  // 幀
	0x5E4E, KANJI_SJIS_L2,  // 幎
	0x5E57, KANJI_SJIS_L2,  // 幗
	0x5E54, KANJI_SJIS_L2,  // 幔
	0x5E5F, KANJI_SJIS_L2,  // 幟
	0x5E62, KANJI_SJIS_L2,  // 幢
	0x5E64, KANJI_SJIS_L2,  // 幤
	0x5E47, KANJI_SJIS_L2,  // 幇
	0x5E75, KANJI_SJIS_L2,  // 幵
	0x5E76, KANJI_SJIS_L2,  // 并
	0x5E7A, KANJI_SJIS_L2,  // 幺
	0x9EBC, KANJI_SJIS_L2,  // 麼
	0x5E7F, KANJI_SJIS_L2,  // 广
	0x5EA0, KANJI_SJIS_L2,  // 庠
	0x5EC1, KANJI_SJIS_L2,  // 廁
	0x5EC2, KANJI_SJIS_L2,  // 廂
	0x5EC8, KANJI_SJIS_L2,  // 廈
	0x5ED0, KANJI_SJIS_L2,  // 廐
	0x5ECF, KANJI_SJIS_L2,  // 廏
	0x5ED6, KANJI_SJIS_L2,  // 廖
	0x5EE3, KANJI_SJIS_L2,  // 廣
	0x5EDD, KANJI_SJIS_L2,  // 廝
	0x5EDA, KANJI_SJIS_L2,  // 廚
	0x5EDB, KANJI_SJIS_L2,  // 廛
	0x5EE2, KANJI_SJIS_L2,  // 廢
	0x5EE1, KANJI_SJIS_L2,  // 廡
	0x5EE8, KANJI_SJIS_L2,  // 廨
	0x5EE9, KANJI_SJIS_L2,  // 廩
	0x5EEC, KANJI_SJIS_L2,  // 廬
	0x5EF1, KANJI_SJIS_L2,  // 廱
	0x5EF3, KANJI_SJIS_L2,  // 廳
	0x5EF0, KANJI_SJIS_L2,  // 廰
	0x5EF4, KANJI_SJIS_L2,  // 廴
	0x5EF8, KANJI_SJIS_L2,  // 廸
	0x5EFE, KANJI_SJIS_L2,  // 廾
	0x5F03, KANJI_SJIS_L2,  // 弃
	0x5F09, KANJI_SJIS_L2,  // 弉
	0x5F5D, KANJI_SJIS_L2,  // 彝
	0x5F5C, KANJI_SJIS_L2,  // 彜
	0x5F0B, KANJI_SJIS_L2,  // 弋
	0x5F11, KANJI_SJIS_L2,  // 弑
	0x5F16, KANJI_SJIS_L2,  // 弖
	0x5F29, KANJI_SJIS_L2,  // 弩
	0x5F2D, KANJI_SJIS_L2,  // 弭
	0x5F38, KANJI_SJIS_L2,  // 弸
	0x5F41, KANJI_SJIS_L2,  // 彁
	0x5F48, KANJI_SJIS_L2,  // 彈
	0x5F4C, KANJI_SJIS_L2,  // 彌
	0x5F4E, KANJI_SJIS_L2,  // 彎
	0x5F2F, KANJI_SJIS_L2,  // 弯
	0x5F51, KANJI_SJIS_L2,  // 彑
	0x5F56, KANJI_SJIS_L2,  // 彖
	0x5F57, KANJI_SJIS_L2,  // 彗
	0x5F59, KANJI_SJIS_L2,  // 彙
	0x5F61, KANJI_SJIS_L2,  // 彡
	0x5F6D, KANJI_SJIS_L2,  // 彭
	0x5F73, KANJI_SJIS_L2,  // 彳
	0x5F77, KANJI_SJIS_L2,  // 彷
	0x5F83, KANJI_SJIS_L2,  // 徃
	0x5F82, KANJI_SJIS_L2,  // 徂
	0x5F7F, KANJI_SJIS_L2,  // 彿
	0x5F8A, KANJI_SJIS_L2,  // 徊
	0x5F88, KANJI_SJIS_L2,  // 很
	0x5F91, KANJI_SJIS_L2,  // 徑
	0x5F87, KANJI_SJIS_L2,  // 徇
	0x5F9E, KANJI_SJIS_L2,  // 從
	0x5F99, KANJI_SJIS_L2,  // 徙
	0x5F98, KANJI_SJIS_L2,  // 徘
	0x5FA0, KANJI_SJIS_L2,  // 徠
	0x5FA8, KANJI_SJIS_L2,  // 徨
	0x5FAD, KANJI_SJIS_L2,  // 徭
	0x5FBC, KANJI_SJIS_L2,  // 徼
	0x5FD6, KANJI_SJIS_L2,  // 忖
	0x5FFB, KANJI_SJIS_L2,  // 忻
	0x5FE4, KANJI_SJIS_L2,  // 忤
	0x5FF8, KANJI_SJIS_L2,  // 忸
	0x5FF1, KANJI_SJIS_L2,  // 忱
	0x5FDD, KANJI_SJIS_L2,  // 忝
	0x60B3, KANJI_SJIS_L2,  // 悳
	0x5FFF, KANJI_SJIS_L2,  // 忿
	0x6021, KANJI_SJIS_L2,  // 怡
	0x6060, KANJI_SJIS_L2,  // 恠
	0x3000, KANJI_SJIS_L2,  // 　
	0x6019, KANJI_SJIS_L2,  // 怙
	0x6010, KANJI_SJIS_L2,  // 怐
	0x6029, KANJI_SJIS_L2,  // 怩
	0x600E, KANJI_SJIS_L2,  // 怎
	0x6031, KANJI_SJIS_L2,  // 怱
	0x601B, KANJI_SJIS_L2,  // 怛
	0x6015, KANJI_SJIS_L2,  // 怕
	0x602B, KANJI_SJIS_L2,  // 怫
	0x6026, KANJI_SJIS_L2,  // 怦
	0x600F, KANJI_SJIS_L2,  // 怏
	0x603A, KANJI_SJIS_L2,  // 怺
	0x605A, KANJI_SJIS_L2,  // 恚
	0x6041, KANJI_SJIS_L2,  // 恁
	0x606A, KANJI_SJIS_L2,  // 恪
	0x6077, KANJI_SJIS_L2,  // 恷
	0x605F, KANJI_SJIS_L2,  // 恟
	0x604A, KANJI_SJIS_L2,  // 恊
	0x6046, KANJI_SJIS_L2,  // 恆
	0x604D, KANJI_SJIS_L2,  // 恍
	0x6063, KANJI_SJIS_L2,  // 恣
	0x6043, KANJI_SJIS_L2,  // 恃
	0x6064, KANJI_SJIS_L2,  // 恤
	0x6042, KANJI_SJIS_L2,  // 恂
	0x606C, KANJI_SJIS_L2,  // 恬
	0x606B, KANJI_SJIS_L2,  // 恫
	0x6059, KANJI_SJIS_L2,  // 恙
	0x6081, KANJI_SJIS_L2,  // 悁
	0x608D, KANJI_SJIS_L2,  // 悍
	0x60E7, KANJI_SJIS_L2,  // 惧
	0x6083, KANJI_SJIS_L2,  // 悃
	0x609A, KANJI_SJIS_L2,  // 悚
	0x6084, KANJI_SJIS_L2,  // 悄
	0x609B, KANJI_SJIS_L2,  // 悛
	0x6096, KANJI_SJIS_L2,  // 悖
	0x6097, KANJI_SJIS_L2,  // 悗
	0x6092, KANJI_SJIS_L2,  // 悒
	0x60A7, KANJI_SJIS_L2,  // 悧
	0x608B, KANJI_SJIS_L2,  // 悋
	0x60E1, KANJI_SJIS_L2,  // 惡
	0x60B8, KANJI_SJIS_L2,  // 悸
	0x60E0, KANJI_SJIS_L2,  // 惠
	0x60D3, KANJI_SJIS_L2,  // 惓
	0x60B4, KANJI_SJIS_L2,  // 悴
	0x5FF0, KANJI_SJIS_L2,  // 忰
	0x60BD, KANJI_SJIS_L2,  // 悽
	0x60C6, KANJI_SJIS_L2,  // 惆
	0x60B5, KANJI_SJIS_L2,  // 悵
	0x60D8, KANJI_SJIS_L2,  // 惘
	0x614D, KANJI_SJIS_L2,  // 慍
	0x6115, KANJI_SJIS_L2,  // 愕
	0x6106, KANJI_SJIS_L2,  // 愆
	0x60F6, KANJI_SJIS_L2,  // 惶
	0x60F7, KANJI_SJIS_L2,  // 惷
	0x6100, KANJI_SJIS_L2,  // 愀
	0x60F4, KANJI_SJIS_L2,  // 惴
	0x60FA, KANJI_SJIS_L2,  // 惺
	0x6103, KANJI_SJIS_L2,  // 愃
	0x6121, KANJI_SJIS_L2,  // 愡
	0x60FB, KANJI_SJIS_L2,  // 惻
	0x60F1, KANJI_SJIS_L2,  // 惱
	0x610D, KANJI_SJIS_L2,  // 愍
	0x610E, KANJI_SJIS_L2,  // 愎
	0x6147, KANJI_SJIS_L2,  // 慇
	0x613E, KANJI_SJIS_L2,  // 愾
	0x6128, KANJI_SJIS_L2,  // 愨
	0x6127, KANJI_SJIS_L2,  // 愧
	0x614A, KANJI_SJIS_L2,  // 慊
	0x613F, KANJI_SJIS_L2,  // 愿
	0x613C, KANJI_SJIS_L2,  // 愼
	0x612C, KANJI_SJIS_L2,  // 愬
	0x6134, KANJI_SJIS_L2,  // 愴
	0x613D, KANJI_SJIS_L2,  // 愽
	0x6142, KANJI_SJIS_L2,  // 慂
	0x6144, KANJI_SJIS_L2,  // 慄
	0x6173, KANJI_SJIS_L2,  // 慳
	0x6177, KANJI_SJIS_L2,  // 慷
	0x6158, KANJI_SJIS_L2,  // 慘
	0x6159, KANJI_SJIS_L2,  // 慙
	0x615A, KANJI_SJIS_L2,  // 慚
	0x616B, KANJI_SJIS_L2,  // 慫
	0x6174, KANJI_SJIS_L2,  // 慴
	0x616F, KANJI_SJIS_L2,  // 慯
	0x6165, KANJI_SJIS_L2,  // 慥
	0x6171, KANJI_SJIS_L2,  // 慱
	0x615F, KANJI_SJIS_L2,  // 慟
	0x615D, KANJI_SJIS_L2,  // 慝
	0x6153, KANJI_SJIS_L2,  // 慓
	0x6175, KANJI_SJIS_L2,  // 慵
	0x6199, KANJI_SJIS_L2,  // 憙
	0x6196, KANJI_SJIS_L2,  // 憖
	0x6187, KANJI_SJIS_L2,  // 憇
	0x61AC, KANJI_SJIS_L2,  // 憬
	0x6194, KANJI_SJIS_L2,  // 憔
	0x619A, KANJI_SJIS_L2,  // 憚
	0x618A, KANJI_SJIS_L2,  // 憊
	0x6191, KANJI_SJIS_L2,  // 憑
	0x61AB, KANJI_SJIS_L2,  // 憫
	0x61AE, KANJI_SJIS_L2,  // 憮
	0x61CC, KANJI_SJIS_L2,  // 懌
	0x61CA, KANJI_SJIS_L2,  // 懊
	0x61C9, KANJI_SJIS_L2,  // 應
	0x61F7, KANJI_SJIS_L2,  // 懷
	0x61C8, KANJI_SJIS_L2,  // 懈
	0x61C3, KANJI_SJIS_L2,  // 懃
	0x61C6, KANJI_SJIS_L2,  // 懆
	0x61BA, KANJI_SJIS_L2,  // 憺
	0x61CB, KANJI_SJIS_L2,  // 懋
	0x7F79, KANJI_SJIS_L2,  // 罹
	0x61CD, KANJI_SJIS_L2,  // 懍
	0x61E6, KANJI_SJIS_L2,  // 懦
	0x61E3, KANJI_SJIS_L2,  // 懣
	0x61F6, KANJI_SJIS_L2,  // 懶
	0x61FA, KANJI_SJIS_L2,  // 懺
	0x61F4, KANJI_SJIS_L2,  // 懴
	0x61FF, KANJI_SJIS_L2,  // 懿
	0x61FD, KANJI_SJIS_L2,  // 懽
	0x61FC, KANJI_SJIS_L2,  // 懼
	0x61FE, KANJI_SJIS_L2,  // 懾
	0x6200, KANJI_SJIS_L2,  // 戀
	0x6208, KANJI_SJIS_L2,  // 戈
	0x6209, KANJI_SJIS_L2,  // 戉
	0x620D, KANJI_SJIS_L2,  // 戍
	0x620C, KANJI_SJIS_L2,  // 戌
	0x6214, KANJI_SJIS_L2,  // 戔
	0x621B, KANJI_SJIS_L2,  // 戛
	0x621E, KANJI_SJIS_L2,  // 戞
	0x6221, KANJI_SJIS_L2,  // 戡
	0x622A, KANJI_SJIS_L2,  // 截
	0x622E, KANJI_SJIS_L2,  // 戮
	0x6230, KANJI_SJIS_L2,  // 戰
	0x6232, KANJI_SJIS_L2,  // 戲
	0x6233, KANJI_SJIS_L2,  // 戳
	0x6241, KANJI_SJIS_L2,  // 扁
	0x624E, KANJI_SJIS_L2,  // 扎
	0x625E, KANJI_SJIS_L2,  // 扞
	0x6263, KANJI_SJIS_L2,  // 扣
	0x625B, KANJI_SJIS_L2,  // 扛
	0x6260, KANJI_SJIS_L2,  // 扠
	0x6268, KANJI_SJIS_L2,  // 扨
	0x627C, KANJI_SJIS_L2,  // 扼
	0x6282, KANJI_SJIS_L2,  // 抂
	0x6289, KANJI_SJIS_L2,  // 抉
	0x627E, KANJI_SJIS_L2,  // 找
	0x6292, KANJI_SJIS_L2,  // 抒
	0x6293, KANJI_SJIS_L2,  // 抓
	0x6296, KANJI_SJIS_L2,  // 抖
	0x62D4, KANJI_SJIS_L2,  // 拔
	0x6283, KANJI_SJIS_L2,  // 抃
	0x6294, KANJI_SJIS_L2,  // 抔
	0x62D7, KANJI_SJIS_L2,  // 拗
	0x62D1, KANJI_SJIS_L2,  // 拑
	0x62BB, KANJI_SJIS_L2,  // 抻
	0x62CF, KANJI_SJIS_L2,  // 拏
	0x62FF, KANJI_SJIS_L2,  // 拿
	0x62C6, KANJI_SJIS_L2,  // 拆
	0x64D4, KANJI_SJIS_L2,  // 擔
	0x62C8, KANJI_SJIS_L2,  // 拈
	0x62DC, KANJI_SJIS_L2,  // 拜
	0x62CC, KANJI_SJIS_L2,  // 拌
	0x62CA, KANJI_SJIS_L2,  // 拊
	0x62C2, KANJI_SJIS_L2,  // 拂
	0x62C7, KANJI_SJIS_L2,  // 拇
	0x629B, KANJI_SJIS_L2,  // 抛
	0x62C9, KANJI_SJIS_L2,  // 拉
	0x630C, KANJI_SJIS_L2,  // 挌
	0x62EE, KANJI_SJIS_L2,  // 拮
	0x62F1, KANJI_SJIS_L2,  // 拱
	0x6327, KANJI_SJIS_L2,  // 挧
	0x6302, KANJI_SJIS_L2,  // 挂
	0x6308, KANJI_SJIS_L2,  // 挈
	0x62EF, KANJI_SJIS_L2,  // 拯
	0x62F5, KANJI_SJIS_L2,  // 拵
	0x6350, KANJI_SJIS_L2,  // 捐
	0x633E, KANJI_SJIS_L2,  // 挾
	0x634D, KANJI_SJIS_L2,  // 捍
	0x641C, KANJI_SJIS_L2,  // 搜
	0x634F, KANJI_SJIS_L2,  // 捏
	0x6396, KANJI_SJIS_L2,  // 掖
	0x638E, KANJI_SJIS_L2,  // 掎
	0x6380, KANJI_SJIS_L2,  // 掀
	0x63AB, KANJI_SJIS_L2,  // 掫
	0x6376, KANJI_SJIS_L2,  // 捶
	0x63A3, KANJI_SJIS_L2,  // 掣
	0x638F, KANJI_SJIS_L2,  // 掏
	0x6389, KANJI_SJIS_L2,  // 掉
	0x639F, KANJI_SJIS_L2,  // 掟
	0x63B5, KANJI_SJIS_L2,  // 掵
	0x636B, KANJI_SJIS_L2,  // 捫
	0x3000, KANJI_SJIS_L2,  // 　
	0x6369, KANJI_SJIS_L2,  // 捩
	0x63BE, KANJI_SJIS_L2,  // 掾
	0x63E9, KANJI_SJIS_L2,  // 揩
	0x63C0, KANJI_SJIS_L2,  // 揀
	0x63C6, KANJI_SJIS_L2,  // 揆
	0x63E3, KANJI_SJIS_L2,  // 揣
	0x63C9, KANJI_SJIS_L2,  // 揉
	0x63D2, KANJI_SJIS_L2,  // 插
	0x63F6, KANJI_SJIS_L2,  // 揶
	0x63C4, KANJI_SJIS_L2,  // 揄
	0x6416, KANJI_SJIS_L2,  // 搖
	0x6434, KANJI_SJIS_L2,  // 搴
	0x6406, KANJI_SJIS_L2,  // 搆
	0x6413, KANJI_SJIS_L2,  // 搓
	0x6426, KANJI_SJIS_L2,  // 搦
	0x6436, KANJI_SJIS_L2,  // 搶
	0x651D, KANJI_SJIS_L2,  // 攝
	0x6417, KANJI_SJIS_L2,  // 搗
	0x6428, KANJI_SJIS_L2,  // 搨
	0x640F, KANJI_SJIS_L2,  // 搏
	0x6467, KANJI_SJIS_L2,  // 摧
	0x646F, KANJI_SJIS_L2,  // 摯
	0x6476, KANJI_SJIS_L2,  // 摶
	0x644E, KANJI_SJIS_L2,  // 摎
	0x652A, KANJI_SJIS_L2,  // 攪
	0x6495, KANJI_SJIS_L2,  // 撕
	0x6493, KANJI_SJIS_L2,  // 撓
	0x64A5, KANJI_SJIS_L2,  // 撥
	0x64A9, KANJI_SJIS_L2,  // 撩
	0x6488, KANJI_SJIS_L2,  // 撈
	0x64BC, KANJI_SJIS_L2,  // 撼
	0x64DA, KANJI_SJIS_L2,  // 據
	0x64D2, KANJI_SJIS_L2,  // 擒
	0x64C5, KANJI_SJIS_L2,  // 擅
	0x64C7, KANJI_SJIS_L2,  // 擇
	0x64BB, KANJI_SJIS_L2,  // 撻
	0x64D8, KANJI_SJIS_L2,  // 擘
	0x64C2, KANJI_SJIS_L2,  // 擂
	0x64F1, KANJI_SJIS_L2,  // 擱
	0x64E7, KANJI_SJIS_L2,  // 擧
	0x8209, KANJI_SJIS_L2,  // 舉
	0x64E0, KANJI_SJIS_L2,  // 擠
	0x64E1, KANJI_SJIS_L2,  // 擡
	0x62AC, KANJI_SJIS_L2,  // 抬
	0x64E3, KANJI_SJIS_L2,  // 擣
	0x64EF, KANJI_SJIS_L2,  // 擯
	0x652C, KANJI_SJIS_L2,  // 攬
	0x64F6, KANJI_SJIS_L2,  // 擶
	0x64F4, KANJI_SJIS_L2,  // 擴
	0x64F2, KANJI_SJIS_L2,  // 擲
	0x64FA, KANJI_SJIS_L2,  // 擺
	0x6500, KANJI_SJIS_L2,  // 攀
	0x64FD, KANJI_SJIS_L2,  // 擽
	0x6518, KANJI_SJIS_L2,  // 攘
	0x651C, KANJI_SJIS_L2,  // 攜
	0x6505, KANJI_SJIS_L2,  // 攅
	0x6524, KANJI_SJIS_L2,  // 攤
	0x6523, KANJI_SJIS_L2,  // 攣
	0x652B, KANJI_SJIS_L2,  // 攫
	0x6534, KANJI_SJIS_L2,  // 攴
	0x6535, KANJI_SJIS_L2,  // 攵
	0x6537, KANJI_SJIS_L2,  // 攷
	0x6536, KANJI_SJIS_L2,  // 收
	0x6538, KANJI_SJIS_L2,  // 攸
	0x754B, KANJI_SJIS_L2,  // 畋
	0x6548, KANJI_SJIS_L2,  // 效
	0x6556, KANJI_SJIS_L2,  // 敖
	0x6555, KANJI_SJIS_L2,  // 敕
	0x654D, KANJI_SJIS_L2,  // 敍
	0x6558, KANJI_SJIS_L2,  // 敘
	0x655E, KANJI_SJIS_L2,  // 敞
	0x655D, KANJI_SJIS_L2,  // 敝
	0x6572, KANJI_SJIS_L2,  // 敲
	0x6578, KANJI_SJIS_L2,  // 數
	0x6582, KANJI_SJIS_L2,  // 斂
	0x6583, KANJI_SJIS_L2,  // 斃
	0x8B8A, KANJI_SJIS_L2,  // 變
	0x659B, KANJI_SJIS_L2,  // 斛
	0x659F, KANJI_SJIS_L2,  // 斟
	0x65AB, KANJI_SJIS_L2,  // 斫
	0x65B7, KANJI_SJIS_L2,  // 斷
	0x65C3, KANJI_SJIS_L2,  // 旃
	0x65C6, KANJI_SJIS_L2,  // 旆
	0x65C1, KANJI_SJIS_L2,  // 旁
	0x65C4, KANJI_SJIS_L2,  // 旄
	0x65CC, KANJI_SJIS_L2,  // 旌
	0x65D2, KANJI_SJIS_L2,  // 旒
	0x65DB, KANJI_SJIS_L2,  // 旛
	0x65D9, KANJI_SJIS_L2,  // 旙
	0x65E0, KANJI_SJIS_L2,  // 无
	0x65E1, KANJI_SJIS_L2,  // 旡
	0x65F1, KANJI_SJIS_L2,  // 旱
	0x6772, KANJI_SJIS_L2,  // 杲
	0x660A, KANJI_SJIS_L2,  // 昊
	0x6603, KANJI_SJIS_L2,  // 昃
	0x65FB, KANJI_SJIS_L2,  // 旻
	0x6773, KANJI_SJIS_L2,  // 杳
	0x6635, KANJI_SJIS_L2,  // 昵
	0x6636, KANJI_SJIS_L2,  // 昶
	0x6634, KANJI_SJIS_L2,  // 昴
	0x661C, KANJI_SJIS_L2,  // 昜
	0x664F, KANJI_SJIS_L2,  // 晏
	0x6644, KANJI_SJIS_L2,  // 晄
	0x6649, KANJI_SJIS_L2,  // 晉
	0x6641, KANJI_SJIS_L2,  // 晁
	0x665E, KANJI_SJIS_L2,  // 晞
	0x665D, KANJI_SJIS_L2,  // 晝
	0x6664, KANJI_SJIS_L2,  // 晤
	0x6667, KANJI_SJIS_L2,  // 晧
	0x6668, KANJI_SJIS_L2,  // 晨
	0x665F, KANJI_SJIS_L2,  // 晟
	0x6662, KANJI_SJIS_L2,  // 晢
	0x6670, KANJI_SJIS_L2,  // 晰
	0x6683, KANJI_SJIS_L2,  // 暃
	0x6688, KANJI_SJIS_L2,  // 暈
	0x668E, KANJI_SJIS_L2,  // 暎
	0x6689, KANJI_SJIS_L2,  // 暉
	0x6684, KANJI_SJIS_L2,  // 暄
	0x6698, KANJI_SJIS_L2,  // 暘
	0x669D, KANJI_SJIS_L2,  // 暝
	0x66C1, KANJI_SJIS_L2,  // 曁
	0x66B9, KANJI_SJIS_L2,  // 暹
	0x66C9, KANJI_SJIS_L2,  // 曉
	0x66BE, KANJI_SJIS_L2,  // 暾
	0x66BC, KANJI_SJIS_L2,  // 暼
	0x66C4, KANJI_SJIS_L2,  // 曄
	0x66B8, KANJI_SJIS_L2,  // 暸
	0x66D6, KANJI_SJIS_L2,  // 曖
	0x66DA, KANJI_SJIS_L2,  // 曚
	0x66E0, KANJI_SJIS_L2,  // 曠
	0x663F, KANJI_SJIS_L2,  // 昿
	0x66E6, KANJI_SJIS_L2,  // 曦
	0x66E9, KANJI_SJIS_L2,  // 曩
	0x66F0, KANJI_SJIS_L2,  // 曰
	0x66F5, KANJI_SJIS_L2,  // 曵
	0x66F7, KANJI_SJIS_L2,  // 曷
	0x670F, KANJI_SJIS_L2,  // 朏
	0x6716, KANJI_SJIS_L2,  // 朖
	0x671E, KANJI_SJIS_L2,  // 朞
	0x6726, KANJI_SJIS_L2,  // 朦
	0x6727, KANJI_SJIS_L2,  // 朧
	0x9738, KANJI_SJIS_L2,  // 霸
	0x672E, KANJI_SJIS_L2,  // 朮
	0x673F, KANJI_SJIS_L2,  // 朿
	0x6736, KANJI_SJIS_L2,  // 朶
	0x6741, KANJI_SJIS_L2,  // 杁
	0x6738, KANJI_SJIS_L2,  // 朸
	0x6737, KANJI_SJIS_L2,  // 朷
	0x6746, KANJI_SJIS_L2,  // 杆
	0x675E, KANJI_SJIS_L2,  // 杞
	0x6760, KANJI_SJIS_L2,  // 杠
	0x6759, KANJI_SJIS_L2,  // 杙
	0x6763, KANJI_SJIS_L2,  // 杣
	0x6764, KANJI_SJIS_L2,  // 杤
	0x6789, KANJI_SJIS_L2,  // 枉
	0x6770, KANJI_SJIS_L2,  // 杰
	0x67A9, KANJI_SJIS_L2,  // 枩
	0x677C, KANJI_SJIS_L2,  // 杼
	0x676A, KANJI_SJIS_L2,  // 杪
	0x678C, KANJI_SJIS_L2,  // 枌
	0x678B, KANJI_SJIS_L2,  // 枋
	0x67A6, KANJI_SJIS_L2,  // 枦
	0x67A1, KANJI_SJIS_L2,  // 枡
	0x6785, KANJI_SJIS_L2,  // 枅
	0x67B7, KANJI_SJIS_L2,  // 枷
	0x67EF, KANJI_SJIS_L2,  // 柯
	0x67B4, KANJI_SJIS_L2,  // 枴
	0x67EC, KANJI_SJIS_L2,  // 柬
	0x67B3, KANJI_SJIS_L2,  // 枳
	0x67E9, KANJI_SJIS_L2,  // 柩
	0x67B8, KANJI_SJIS_L2,  // 枸
	0x67E4, KANJI_SJIS_L2,  // 柤
	0x67DE, KANJI_SJIS_L2,  // 柞
	0x67DD, KANJI_SJIS_L2,  // 柝
	0x67E2, KANJI_SJIS_L2,  // 柢
	0x67EE, KANJI_SJIS_L2,  // 柮
	0x67B9, KANJI_SJIS_L2,  // 枹
	0x67CE, KANJI_SJIS_L2,  // 柎
	0x67C6, KANJI_SJIS_L2,  // 柆
	0x67E7, KANJI_SJIS_L2,  // 柧
	0x6A9C, KANJI_SJIS_L2,  // 檜
	0x681E, KANJI_SJIS_L2,  // 栞
	0x6846, KANJI_SJIS_L2,  // 框
	0x6829, KANJI_SJIS_L2,  // 栩
	0x6840, KANJI_SJIS_L2,  // 桀
	0x684D, KANJI_SJIS_L2,  // 桍
	0x6832, KANJI_SJIS_L2,  // 栲
	0x684E, KANJI_SJIS_L2,  // 桎
	0x3000, KANJI_SJIS_L2,  // 　
	0x68B3, KANJI_SJIS_L2,  // 梳
	0x682B, KANJI_SJIS_L2,  // 栫
	0x6859, KANJI_SJIS_L2,  // 桙
	0x6863, KANJI_SJIS_L2,  // 档
	0x6877, KANJI_SJIS_L2,  // 桷
	0x687F, KANJI_SJIS_L2,  // 桿
	0x689F, KANJI_SJIS_L2,  // 梟
	0x688F, KANJI_SJIS_L2,  // 梏
	0x68AD, KANJI_SJIS_L2,  // 梭
	0x6894, KANJI_SJIS_L2,  // 梔
	0x689D, KANJI_SJIS_L2,  // 條
	0x689B, KANJI_SJIS_L2,  // 梛
	0x6883, KANJI_SJIS_L2,  // 梃
	0x6AAE, KANJI_SJIS_L2,  // 檮
	0x68B9, KANJI_SJIS_L2,  // 梹
	0x6874, KANJI_SJIS_L2,  // 桴
	0x68B5, KANJI_SJIS_L2,  // 梵
	0x68A0, KANJI_SJIS_L2,  // 梠
	0x68BA, KANJI_SJIS_L2,  // 梺
	0x690F, KANJI_SJIS_L2,  // 椏
	0x688D, KANJI_SJIS_L2,  // 梍
	0x687E, KANJI_SJIS_L2,  // 桾
	0x6901, KANJI_SJIS_L2,  // 椁
	0x68CA, KANJI_SJIS_L2,  // 棊
	0x6908, KANJI_SJIS_L2,  // 椈
	0x68D8, KANJI_SJIS_L2,  // 棘
	0x6922, KANJI_SJIS_L2,  // 椢
	0x6926, KANJI_SJIS_L2,  // 椦
	0x68E1, KANJI_SJIS_L2,  // 棡
	0x690C, KANJI_SJIS_L2,  // 椌
	0x68CD, KANJI_SJIS_L2,  // 棍
	0x68D4, KANJI_SJIS_L2,  // 棔
	0x68E7, KANJI_SJIS_L2,  // 棧
	0x68D5, KANJI_SJIS_L2,  // 棕
	0x6936, KANJI_SJIS_L2,  // 椶
	0x6912, KANJI_SJIS_L2,  // 椒
	0x6904, KANJI_SJIS_L2,  // 椄
	0x68D7, KANJI_SJIS_L2,  // 棗
	0x68E3, KANJI_SJIS_L2,  // 棣
	0x6925, KANJI_SJIS_L2,  // 椥
	0x68F9, KANJI_SJIS_L2,  // 棹
	0x68E0, KANJI_SJIS_L2,  // 棠
	0x68EF, KANJI_SJIS_L2,  // 棯
	0x6928, KANJI_SJIS_L2,  // 椨
	0x692A, KANJI_SJIS_L2,  // 椪
	0x691A, KANJI_SJIS_L2,  // 椚
	0x6923, KANJI_SJIS_L2,  // 椣
	0x6921, KANJI_SJIS_L2,  // 椡
	0x68C6, KANJI_SJIS_L2,  // 棆
	0x6979, KANJI_SJIS_L2,  // 楹
	0x6977, KANJI_SJIS_L2,  // 楷
	0x695C, KANJI_SJIS_L2,  // 楜
	0x6978, KANJI_SJIS_L2,  // 楸
	0x696B, KANJI_SJIS_L2,  // 楫
	0x6954, KANJI_SJIS_L2,  // 楔
	0x697E, KANJI_SJIS_L2,  // 楾
	0x696E, KANJI_SJIS_L2,  // 楮
	0x6939, KANJI_SJIS_L2,  // 椹
	0x6974, KANJI_SJIS_L2,  // 楴
	0x693D, KANJI_SJIS_L2,  // 椽
	0x6959, KANJI_SJIS_L2,  // 楙
	0x6930, KANJI_SJIS_L2,  // 椰
	0x6961, KANJI_SJIS_L2,  // 楡
	0x695E, KANJI_SJIS_L2,  // 楞
	0x695D, KANJI_SJIS_L2,  // 楝
	0x6981, KANJI_SJIS_L2,  // 榁
	0x696A, KANJI_SJIS_L2,  // 楪
	0x69B2, KANJI_SJIS_L2,  // 榲
	0x69AE, KANJI_SJIS_L2,  // 榮
	0x69D0, KANJI_SJIS_L2,  // 槐
	0x69BF, KANJI_SJIS_L2,  // 榿
	0x69C1, KANJI_SJIS_L2,  // 槁
	0x69D3, KANJI_SJIS_L2,  // 槓
	0x69BE, KANJI_SJIS_L2,  // 榾
	0x69CE, KANJI_SJIS_L2,  // 槎
	0x5BE8, KANJI_SJIS_L2,  // 寨
	0x69CA, KANJI_SJIS_L2,  // 槊
	0x69DD, KANJI_SJIS_L2,  // 槝
	0x69BB, KANJI_SJIS_L2,  // 榻
	0x69C3, KANJI_SJIS_L2,  // 槃
	0x69A7, KANJI_SJIS_L2,  // 榧
	0x6A2E, KANJI_SJIS_L2,  // 樮
	0x6991, KANJI_SJIS_L2,  // 榑
	0x69A0, KANJI_SJIS_L2,  // 榠
	0x699C, KANJI_SJIS_L2,  // 榜
	0x6995, KANJI_SJIS_L2,  // 榕
	0x69B4, KANJI_SJIS_L2,  // 榴
	0x69DE, KANJI_SJIS_L2,  // 槞
	0x69E8, KANJI_SJIS_L2,  // 槨
	0x6A02, KANJI_SJIS_L2,  // 樂
	0x6A1B, KANJI_SJIS_L2,  // 樛
	0x69FF, KANJI_SJIS_L2,  // 槿
	0x6B0A, KANJI_SJIS_L2,  // 權
	0x69F9, KANJI_SJIS_L2,  // 槹
	0x69F2, KANJI_SJIS_L2,  // 槲
	0x69E7, KANJI_SJIS_L2,  // 槧
	0x6A05, KANJI_SJIS_L2,  // 樅
	0x69B1, KANJI_SJIS_L2,  // 榱
	0x6A1E, KANJI_SJIS_L2,  // 樞
	0x69ED, KANJI_SJIS_L2,  // 槭
	0x6A14, KANJI_SJIS_L2,  // 樔
	0x69EB, KANJI_SJIS_L2,  // 槫
	0x6A0A, KANJI_SJIS_L2,  // 樊
	0x6A12, KANJI_SJIS_L2,  // 樒
	0x6AC1, KANJI_SJIS_L2,  // 櫁
	0x6A23, KANJI_SJIS_L2,  // 樣
	0x6A13, KANJI_SJIS_L2,  // 樓
	0x6A44, KANJI_SJIS_L2,  // 橄
	0x6A0C, KANJI_SJIS_L2,  // 樌
	0x6A72, KANJI_SJIS_L2,  // 橲
	0x6A36, KANJI_SJIS_L2,  // 樶
	0x6A78, KANJI_SJIS_L2,  // 橸
	0x6A47, KANJI_SJIS_L2,  // 橇
	0x6A62, KANJI_SJIS_L2,  // 橢
	0x6A59, KANJI_SJIS_L2,  // 橙
	0x6A66, KANJI_SJIS_L2,  // 橦
	0x6A48, KANJI_SJIS_L2,  // 橈
	0x6A38, KANJI_SJIS_L2,  // 樸
	0x6A22, KANJI_SJIS_L2,  // 樢
	0x6A90, KANJI_SJIS_L2,  // 檐
	0x6A8D, KANJI_SJIS_L2,  // 檍
	0x6AA0, KANJI_SJIS_L2,  // 檠
	0x6A84, KANJI_SJIS_L2,  // 檄
	0x6AA2, KANJI_SJIS_L2,  // 檢
	0x6AA3, KANJI_SJIS_L2,  // 檣
	0x6A97, KANJI_SJIS_L2,  // 檗
	0x8617, KANJI_SJIS_L2,  // 蘗
	0x6ABB, KANJI_SJIS_L2,  // 檻
	0x6AC3, KANJI_SJIS_L2,  // 櫃
	0x6AC2, KANJI_SJIS_L2,  // 櫂
	0x6AB8, KANJI_SJIS_L2,  // 檸
	0x6AB3, KANJI_SJIS_L2,  // 檳
	0x6AAC, KANJI_SJIS_L2,  // 檬
	0x6ADE, KANJI_SJIS_L2,  // 櫞
	0x6AD1, KANJI_SJIS_L2,  // 櫑
	0x6ADF, KANJI_SJIS_L2,  // 櫟
	0x6AAA, KANJI_SJIS_L2,  // 檪
	0x6ADA, KANJI_SJIS_L2,  // 櫚
	0x6AEA, KANJI_SJIS_L2,  // 櫪
	0x6AFB, KANJI_SJIS_L2,  // 櫻
	0x6B05, KANJI_SJIS_L2,  // 欅
	0x8616, KANJI_SJIS_L2,  // 蘖
	0x6AFA, KANJI_SJIS_L2,  // 櫺
	0x6B12, KANJI_SJIS_L2,  // 欒
	0x6B16, KANJI_SJIS_L2,  // 欖
	0x9B31, KANJI_SJIS_L2,  // 鬱
	0x6B1F, KANJI_SJIS_L2,  // 欟
	0x6B38, KANJI_SJIS_L2,  // 欸
	0x6B37, KANJI_SJIS_L2,  // 欷
	0x76DC, KANJI_SJIS_L2,  // 盜
	0x6B39, KANJI_SJIS_L2,  // 欹
	0x98EE, KANJI_SJIS_L2,  // 飮
	0x6B47, KANJI_SJIS_L2,  // 歇
	0x6B43, KANJI_SJIS_L2,  // 歃
	0x6B49, KANJI_SJIS_L2,  // 歉
	0x6B50, KANJI_SJIS_L2,  // 歐
	0x6B59, KANJI_SJIS_L2,  // 歙
	0x6B54, KANJI_SJIS_L2,  // 歔
	0x6B5B, KANJI_SJIS_L2,  // 歛
	0x6B5F, KANJI_SJIS_L2,  // 歟
	0x6B61, KANJI_SJIS_L2,  // 歡
	0x6B78, KANJI_SJIS_L2,  // 歸
	0x6B79, KANJI_SJIS_L2,  // 歹
	0x6B7F, KANJI_SJIS_L2,  // 歿
	0x6B80, KANJI_SJIS_L2,  // 殀
	0x6B84, KANJI_SJIS_L2,  // 殄
	0x6B83, KANJI_SJIS_L2,  // 殃
	0x6B8D, KANJI_SJIS_L2,  // 殍
	0x6B98, KANJI_SJIS_L2,  // 殘
	0x6B95, KANJI_SJIS_L2,  // 殕
	0x6B9E, KANJI_SJIS_L2,  // 殞
	0x6BA4, KANJI_SJIS_L2,  // 殤
	0x6BAA, KANJI_SJIS_L2,  // 殪
	0x6BAB, KANJI_SJIS_L2,  // 殫
	0x6BAF, KANJI_SJIS_L2,  // 殯
	0x6BB2, KANJI_SJIS_L2,  // 殲
	0x6BB1, KANJI_SJIS_L2,  // 殱
	0x6BB3, KANJI_SJIS_L2,  // 殳
	0x6BB7, KANJI_SJIS_L2,  // 殷
	0x6BBC, KANJI_SJIS_L2,  // 殼
	0x6BC6, KANJI_SJIS_L2,  // 毆
	0x6BCB, KANJI_SJIS_L2,  // 毋
	0x6BD3, KANJI_SJIS_L2,  // 毓
	0x6BDF, KANJI_SJIS_L2,  // 毟
	0x6BEC, KANJI_SJIS_L2,  // 毬
	0x6BEB, KANJI_SJIS_L2,  // 毫
	0x6BF3, KANJI_SJIS_L2,  // 毳
	0x6BEF, KANJI_SJIS_L2,  // 毯
	0x3000, KANJI_SJIS_L2,  // 　
	0x9EBE, KANJI_SJIS_L2,  // 麾
	0x6C08, KANJI_SJIS_L2,  // 氈
	0x6C13, KANJI_SJIS_L2,  // 氓
	0x6C14, KANJI_SJIS_L2,  // 气
	0x6C1B, KANJI_SJIS_L2,  // 氛
	0x6C24, KANJI_SJIS_L2,  // 氤
	0x6C23, KANJI_SJIS_L2,  // 氣
	0x6C5E, KANJI_SJIS_L2,  // 汞
	0x6C55, KANJI_SJIS_L2,  // 汕
	0x6C62, KANJI_SJIS_L2,  // 汢
	0x6C6A, KANJI_SJIS_L2,  // 汪
	0x6C82, KANJI_SJIS_L2,  // 沂
	0x6C8D, KANJI_SJIS_L2,  // 沍
	0x6C9A, KANJI_SJIS_L2,  // 沚
	0x6C81, KANJI_SJIS_L2,  // 沁
	0x6C9B, KANJI_SJIS_L2,  // 沛
	0x6C7E, KANJI_SJIS_L2,  // 汾
	0x6C68, KANJI_SJIS_L2,  // 汨
	0x6C73, KANJI_SJIS_L2,  // 汳
	0x6C92, KANJI_SJIS_L2,  // 沒
	0x6C90, KANJI_SJIS_L2,  // 沐
	0x6CC4, KANJI_SJIS_L2,  // 泄
	0x6CF1, KANJI_SJIS_L2,  // 泱
	0x6CD3, KANJI_SJIS_L2,  // 泓
	0x6CBD, KANJI_SJIS_L2,  // 沽
	0x6CD7, KANJI_SJIS_L2,  // 泗
	0x6CC5, KANJI_SJIS_L2,  // 泅
	0x6CDD, KANJI_SJIS_L2,  // 泝
	0x6CAE, KANJI_SJIS_L2,  // 沮
	0x6CB1, KANJI_SJIS_L2,  // 沱
	0x6CBE, KANJI_SJIS_L2,  // 沾
	0x6CBA, KANJI_SJIS_L2,  // 沺
	0x6CDB, KANJI_SJIS_L2,  // 泛
	0x6CEF, KANJI_SJIS_L2,  // 泯
	0x6CD9, KANJI_SJIS_L2,  // 泙
	0x6CEA, KANJI_SJIS_L2,  // 泪
	0x6D1F, KANJI_SJIS_L2,  // 洟
	0x884D, KANJI_SJIS_L2,  // 衍
	0x6D36, KANJI_SJIS_L2,  // 洶
	0x6D2B, KANJI_SJIS_L2,  // 洫
	0x6D3D, KANJI_SJIS_L2,  // 洽
	0x6D38, KANJI_SJIS_L2,  // 洸
	0x6D19, KANJI_SJIS_L2,  // 洙
	0x6D35, KANJI_SJIS_L2,  // 洵
	0x6D33, KANJI_SJIS_L2,  // 洳
	0x6D12, KANJI_SJIS_L2,  // 洒
	0x6D0C, KANJI_SJIS_L2,  // 洌
	0x6D63, KANJI_SJIS_L2,  // 浣
	0x6D93, KANJI_SJIS_L2,  // 涓
	0x6D64, KANJI_SJIS_L2,  // 浤
	0x6D5A, KANJI_SJIS_L2,  // 浚
	0x6D79, KANJI_SJIS_L2,  // 浹
	0x6D59, KANJI_SJIS_L2,  // 浙
	0x6D8E, KANJI_SJIS_L2,  // 涎
	0x6D95, KANJI_SJIS_L2,  // 涕
	0x6FE4, KANJI_SJIS_L2,  // 濤
	0x6D85, KANJI_SJIS_L2,  // 涅
	0x6DF9, KANJI_SJIS_L2,  // 淹
	0x6E15, KANJI_SJIS_L2,  // 渕
	0x6E0A, KANJI_SJIS_L2,  // 渊
	0x6DB5, KANJI_SJIS_L2,  // 涵
	0x6DC7, KANJI_SJIS_L2,  // 淇
	0x6DE6, KANJI_SJIS_L2,  // 淦
	0x6DB8, KANJI_SJIS_L2,  // 涸
	0x6DC6, KANJI_SJIS_L2,  // 淆
	0x6DEC, KANJI_SJIS_L2,  // 淬
	0x6DDE, KANJI_SJIS_L2,  // 淞
	0x6DCC, KANJI_SJIS_L2,  // 淌
	0x6DE8, KANJI_SJIS_L2,  // 淨
	0x6DD2, KANJI_SJIS_L2,  // 淒
	0x6DC5, KANJI_SJIS_L2,  // 淅
	0x6DFA, KANJI_SJIS_L2,  // 淺
	0x6DD9, KANJI_SJIS_L2,  // 淙
	0x6DE4, KANJI_SJIS_L2,  // 淤
	0x6DD5, KANJI_SJIS_L2,  // 淕
	0x6DEA, KANJI_SJIS_L2,  // 淪
	0x6DEE, KANJI_SJIS_L2,  // 淮
	0x6E2D, KANJI_SJIS_L2,  // 渭
	0x6E6E, KANJI_SJIS_L2,  // 湮
	0x6E2E, KANJI_SJIS_L2,  // 渮
	0x6E19, KANJI_SJIS_L2,  // 渙
	0x6E72, KANJI_SJIS_L2,  // 湲
	0x6E5F, KANJI_SJIS_L2,  // 湟
	0x6E3E, KANJI_SJIS_L2,  // 渾
	0x6E23, KANJI_SJIS_L2,  // 渣
	0x6E6B, KANJI_SJIS_L2,  // 湫
	0x6E2B, KANJI_SJIS_L2,  // 渫
	0x6E76, KANJI_SJIS_L2,  // 湶
	0x6E4D, KANJI_SJIS_L2,  // 湍
	0x6E1F, KANJI_SJIS_L2,  // 渟
	0x6E43, KANJI_SJIS_L2,  // 湃
	0x6E3A, KANJI_SJIS_L2,  // 渺
	0x6E4E, KANJI_SJIS_L2,  // 湎
	0x6E24, KANJI_SJIS_L2,  // 渤
	0x6EFF, KANJI_SJIS_L2,  // 滿
	0x6E1D, KANJI_SJIS_L2,  // 渝
	0x6E38, KANJI_SJIS_L2,  // 游
	0x6E82, KANJI_SJIS_L2,  // 溂
	0x6EAA, KANJI_SJIS_L2,  // 溪
	0x6E98, KANJI_SJIS_L2,  // 溘
	0x6EC9, KANJI_SJIS_L2,  // 滉
	0x6EB7, KANJI_SJIS_L2,  // 溷
	0x6ED3, KANJI_SJIS_L2,  // 滓
	0x6EBD, KANJI_SJIS_L2,  // 溽
	0x6EAF, KANJI_SJIS_L2,  // 溯
	0x6EC4, KANJI_SJIS_L2,  // 滄
	0x6EB2, KANJI_SJIS_L2,  // 溲
	0x6ED4, KANJI_SJIS_L2,  // 滔
	0x6ED5, KANJI_SJIS_L2,  // 滕
	0x6E8F, KANJI_SJIS_L2,  // 溏
	0x6EA5, KANJI_SJIS_L2,  // 溥
	0x6EC2, KANJI_SJIS_L2,  // 滂
	0x6E9F, KANJI_SJIS_L2,  // 溟
	0x6F41, KANJI_SJIS_L2,  // 潁
	0x6F11, KANJI_SJIS_L2,  // 漑
	0x704C, KANJI_SJIS_L2,  // 灌
	0x6EEC, KANJI_SJIS_L2,  // 滬
	0x6EF8, KANJI_SJIS_L2,  // 滸
	0x6EFE, KANJI_SJIS_L2,  // 滾
	0x6F3F, KANJI_SJIS_L2,  // 漿
	0x6EF2, KANJI_SJIS_L2,  // 滲
	0x6F31, KANJI_SJIS_L2,  // 漱
	0x6EEF, KANJI_SJIS_L2,  // 滯
	0x6F32, KANJI_SJIS_L2,  // 漲
	0x6ECC, KANJI_SJIS_L2,  // 滌
	0x6F3E, KANJI_SJIS_L2,  // 漾
	0x6F13, KANJI_SJIS_L2,  // 漓
	0x6EF7, KANJI_SJIS_L2,  // 滷
	0x6F86, KANJI_SJIS_L2,  // 澆
	0x6F7A, KANJI_SJIS_L2,  // 潺
	0x6F78, KANJI_SJIS_L2,  // 潸
	0x6F81, KANJI_SJIS_L2,  // 澁
	0x6F80, KANJI_SJIS_L2,  // 澀
	0x6F6F, KANJI_SJIS_L2,  // 潯
	0x6F5B, KANJI_SJIS_L2,  // 潛
	0x6FF3, KANJI_SJIS_L2,  // 濳
	0x6F6D, KANJI_SJIS_L2,  // 潭
	0x6F82, KANJI_SJIS_L2,  // 澂
	0x6F7C, KANJI_SJIS_L2,  // 潼
	0x6F58, KANJI_SJIS_L2,  // 潘
	0x6F8E, KANJI_SJIS_L2,  // 澎
	0x6F91, KANJI_SJIS_L2,  // 澑
	0x6FC2, KANJI_SJIS_L2,  // 濂
	0x6F66, KANJI_SJIS_L2,  // 潦
	0x6FB3, KANJI_SJIS_L2,  // 澳
	0x6FA3, KANJI_SJIS_L2,  // 澣
	0x6FA1, KANJI_SJIS_L2,  // 澡
	0x6FA4, KANJI_SJIS_L2,  // 澤
	0x6FB9, KANJI_SJIS_L2,  // 澹
	0x6FC6, KANJI_SJIS_L2,  // 濆
	0x6FAA, KANJI_SJIS_L2,  // 澪
	0x6FDF, KANJI_SJIS_L2,  // 濟
	0x6FD5, KANJI_SJIS_L2,  // 濕
	0x6FEC, KANJI_SJIS_L2,  // 濬
	0x6FD4, KANJI_SJIS_L2,  // 濔
	0x6FD8, KANJI_SJIS_L2,  // 濘
	0x6FF1, KANJI_SJIS_L2,  // 濱
	0x6FEE, KANJI_SJIS_L2,  // 濮
	0x6FDB, KANJI_SJIS_L2,  // 濛
	0x7009, KANJI_SJIS_L2,  // 瀉
	0x700B, KANJI_SJIS_L2,  // 瀋
	0x6FFA, KANJI_SJIS_L2,  // 濺
	0x7011, KANJI_SJIS_L2,  // 瀑
	0x7001, KANJI_SJIS_L2,  // 瀁
	0x700F, KANJI_SJIS_L2,  // 瀏
	0x6FFE, KANJI_SJIS_L2,  // 濾
	0x701B, KANJI_SJIS_L2,  // 瀛
	0x701A, KANJI_SJIS_L2,  // 瀚
	0x6F74, KANJI_SJIS_L2,  // 潴
	0x701D, KANJI_SJIS_L2,  // 瀝
	0x7018, KANJI_SJIS_L2,  // 瀘
	0x701F, KANJI_SJIS_L2,  // 瀟
	0x7030, KANJI_SJIS_L2,  // 瀰
	0x703E, KANJI_SJIS_L2,  // 瀾
	0x7032, KANJI_SJIS_L2,  // 瀲
	0x7051, KANJI_SJIS_L2,  // 灑
	0x7063, KANJI_SJIS_L2,  // 灣
	0x7099, KANJI_SJIS_L2,  // 炙
	0x7092, KANJI_SJIS_L2,  // 炒
	0x70AF, KANJI_SJIS_L2,  // 炯
	0x70F1, KANJI_SJIS_L2,  // 烱
	0x70AC, KANJI_SJIS_L2,  // 炬
	0x70B8, KANJI_SJIS_L2,  // 炸
	0x70B3, KANJI_SJIS_L2,  // 炳
	0x70AE, KANJI_SJIS_L2,  // 炮
	0x70DF, KANJI_SJIS_L2,  // 烟
	0x70CB, KANJI_SJIS_L2,  // 烋
	0x70DD, KANJI_SJIS_L2,  // 烝
	0x3000, KANJI_SJIS_L2,  // 　
	0x70D9, KANJI_SJIS_L2,  // 烙
	0x7109, KANJI_SJIS_L2,  // 焉
	0x70FD, KANJI_SJIS_L2,  // 烽
	0x711C, KANJI_SJIS_L2,  // 焜
	0x7119, KANJI_SJIS_L2,  // 焙
	0x7165, KANJI_SJIS_L2,  // 煥
	0x7155, KANJI_SJIS_L2,  // 煕
	0x7188, KANJI_SJIS_L2,  // 熈
	0x7166, KANJI_SJIS_L2,  // 煦
	0x7162, KANJI_SJIS_L2,  // 煢
	0x714C, KANJI_SJIS_L2,  // 煌
	0x7156, KANJI_SJIS_L2,  // 煖
	0x716C, KANJI_SJIS_L2,  // 煬
	0x718F, KANJI_SJIS_L2,  // 熏
	0x71FB, KANJI_SJIS_L2,  // 燻
	0x7184, KANJI_SJIS_L2,  // 熄
	0x7195, KANJI_SJIS_L2,  // 熕
	0x71A8, KANJI_SJIS_L2,  // 熨
	0x71AC, KANJI_SJIS_L2,  // 熬
	0x71D7, KANJI_SJIS_L2,  // 燗
	0x71B9, KANJI_SJIS_L2,  // 熹
	0x71BE, KANJI_SJIS_L2,  // 熾
	0x71D2, KANJI_SJIS_L2,  // 燒
	0x71C9, KANJI_SJIS_L2,  // 燉
	0x71D4, KANJI_SJIS_L2,  // 燔
	0x71CE, KANJI_SJIS_L2,  // 燎
	0x71E0, KANJI_SJIS_L2,  // 燠
	0x71EC, KANJI_SJIS_L2,  // 燬
	0x71E7, KANJI_SJIS_L2,  // 燧
	0x71F5, KANJI_SJIS_L2,  // 燵
	0x71FC, KANJI_SJIS_L2,  // 燼
	0x71F9, KANJI_SJIS_L2,  // 燹
	0x71FF, KANJI_SJIS_L2,  // 燿
	0x720D, KANJI_SJIS_L2,  // 爍
	0x7210, KANJI_SJIS_L2,  // 爐
	0x721B, KANJI_SJIS_L2,  // 爛
	0x7228, KANJI_SJIS_L2,  // 爨
	0x722D, KANJI_SJIS_L2,  // 爭
	0x722C, KANJI_SJIS_L2,  // 爬
	0x7230, KANJI_SJIS_L2,  // 爰
	0x7232, KANJI_SJIS_L2,  // 爲
	0x723B, KANJI_SJIS_L2,  // 爻
	0x723C, KANJI_SJIS_L2,  // 爼
	0x723F, KANJI_SJIS_L2,  // 爿
	0x7240, KANJI_SJIS_L2,  // 牀
	0x7246, KANJI_SJIS_L2,  // 牆
	0x724B, KANJI_SJIS_L2,  // 牋
	0x7258, KANJI_SJIS_L2,  // 牘
	0x7274, KANJI_SJIS_L2,  // 牴
	0x727E, KANJI_SJIS_L2,  // 牾
	0x7282, KANJI_SJIS_L2,  // 犂
	0x7281, KANJI_SJIS_L2,  // 犁
	0x7287, KANJI_SJIS_L2,  // 犇
	0x7292, KANJI_SJIS_L2,  // 犒
	0x7296, KANJI_SJIS_L2,  // 犖
	0x72A2, KANJI_SJIS_L2,  // 犢
	0x72A7, KANJI_SJIS_L2,  // 犧
	0x72B9, KANJI_SJIS_L2,  // 犹
	0x72B2, KANJI_SJIS_L2,  // 犲
	0x72C3, KANJI_SJIS_L2,  // 狃
	0x72C6, KANJI_SJIS_L2,  // 狆
	0x72C4, KANJI_SJIS_L2,  // 狄
	0x72CE, KANJI_SJIS_L2,  // 狎
	0x72D2, KANJI_SJIS_L2,  // 狒
	0x72E2, KANJI_SJIS_L2,  // 狢
	0x72E0, KANJI_SJIS_L2,  // 狠
	0x72E1, KANJI_SJIS_L2,  // 狡
	0x72F9, KANJI_SJIS_L2,  // 狹
	0x72F7, KANJI_SJIS_L2,  // 狷
	0x500F, KANJI_SJIS_L2,  // 倏
	0x7317, KANJI_SJIS_L2,  // 猗
	0x730A, KANJI_SJIS_L2,  // 猊
	0x731C, KANJI_SJIS_L2,  // 猜
	0x7316, KANJI_SJIS_L2,  // 猖
	0x731D, KANJI_SJIS_L2,  // 猝
	0x7334, KANJI_SJIS_L2,  // 猴
	0x732F, KANJI_SJIS_L2,  // 猯
	0x7329, KANJI_SJIS_L2,  // 猩
	0x7325, KANJI_SJIS_L2,  // 猥
	0x733E, KANJI_SJIS_L2,  // 猾
	0x734E, KANJI_SJIS_L2,  // 獎
	0x734F, KANJI_SJIS_L2,  // 獏
	0x9ED8, KANJI_SJIS_L2,  // 默
	0x7357, KANJI_SJIS_L2,  // 獗
	0x736A, KANJI_SJIS_L2,  // 獪
	0x7368, KANJI_SJIS_L2,  // 獨
	0x7370, KANJI_SJIS_L2,  // 獰
	0x7378, KANJI_SJIS_L2,  // 獸
	0x7375, KANJI_SJIS_L2,  // 獵
	0x737B, KANJI_SJIS_L2,  // 獻
	0x737A, KANJI_SJIS_L2,  // 獺
	0x73C8, KANJI_SJIS_L2,  // 珈
	0x73B3, KANJI_SJIS_L2,  // 玳
	0x73CE, KANJI_SJIS_L2,  // 珎
	0x73BB, KANJI_SJIS_L2,  // 玻
	0x73C0, KANJI_SJIS_L2,  // 珀
	0x73E5, KANJI_SJIS_L2,  // 珥
	0x73EE, KANJI_SJIS_L2,  // 珮
	0x73DE, KANJI_SJIS_L2,  // 珞
	0x74A2, KANJI_SJIS_L2,  // 璢
	0x7405, KANJI_SJIS_L2,  // 琅
	0x746F, KANJI_SJIS_L2,  // 瑯
	0x7425, KANJI_SJIS_L2,  // 琥
	0x73F8, KANJI_SJIS_L2,  // 珸
	0x7432, KANJI_SJIS_L2,  // 琲
	0x743A, KANJI_SJIS_L2,  // 琺
	0x7455, KANJI_SJIS_L2,  // 瑕
	0x743F, KANJI_SJIS_L2,  // 琿
	0x745F, KANJI_SJIS_L2,  // 瑟
	0x7459, KANJI_SJIS_L2,  // 瑙
	0x7441, KANJI_SJIS_L2,  // 瑁
	0x745C, KANJI_SJIS_L2,  // 瑜
	0x7469, KANJI_SJIS_L2,  // 瑩
	0x7470, KANJI_SJIS_L2,  // 瑰
	0x7463, KANJI_SJIS_L2,  // 瑣
	0x746A, KANJI_SJIS_L2,  // 瑪
	0x7476, KANJI_SJIS_L2,  // 瑶
	0x747E, KANJI_SJIS_L2,  // 瑾
	0x748B, KANJI_SJIS_L2,  // 璋
	0x749E, KANJI_SJIS_L2,  // 璞
	0x74A7, KANJI_SJIS_L2,  // 璧
	0x74CA, KANJI_SJIS_L2,  // 瓊
	0x74CF, KANJI_SJIS_L2,  // 瓏
	0x74D4, KANJI_SJIS_L2,  // 瓔
	0x73F1, KANJI_SJIS_L2,  // 珱
	0x74E0, KANJI_SJIS_L2,  // 瓠
	0x74E3, KANJI_SJIS_L2,  // 瓣
	0x74E7, KANJI_SJIS_L2,  // 瓧
	0x74E9, KANJI_SJIS_L2,  // 瓩
	0x74EE, KANJI_SJIS_L2,  // 瓮
	0x74F2, KANJI_SJIS_L2,  // 瓲
	0x74F0, KANJI_SJIS_L2,  // 瓰
	0x74F1, KANJI_SJIS_L2,  // 瓱
	0x74F8, KANJI_SJIS_L2,  // 瓸
	0x74F7, KANJI_SJIS_L2,  // 瓷
	0x7504, KANJI_SJIS_L2,  // 甄
	0x7503, KANJI_SJIS_L2,  // 甃
	0x7505, KANJI_SJIS_L2,  // 甅
	0x750C, KANJI_SJIS_L2,  // 甌
	0x750E, KANJI_SJIS_L2,  // 甎
	0x750D, KANJI_SJIS_L2,  // 甍
	0x7515, KANJI_SJIS_L2,  // 甕
	0x7513, KANJI_SJIS_L2,  // 甓
	0x751E, KANJI_SJIS_L2,  // 甞
	0x7526, KANJI_SJIS_L2,  // 甦
	0x752C, KANJI_SJIS_L2,  // 甬
	0x753C, KANJI_SJIS_L2,  // 甼
	0x7544, KANJI_SJIS_L2,  // 畄
	0x754D, KANJI_SJIS_L2,  // 畍
	0x754A, KANJI_SJIS_L2,  // 畊
	0x7549, KANJI_SJIS_L2,  // 畉
	0x755B, KANJI_SJIS_L2,  // 畛
	0x7546, KANJI_SJIS_L2,  // 畆
	0x755A, KANJI_SJIS_L2,  // 畚
	0x7569, KANJI_SJIS_L2,  // 畩
	0x7564, KANJI_SJIS_L2,  // 畤
	0x7567, KANJI_SJIS_L2,  // 畧
	0x756B, KANJI_SJIS_L2,  // 畫
	0x756D, KANJI_SJIS_L2,  // 畭
	0x7578, KANJI_SJIS_L2,  // 畸
	0x7576, KANJI_SJIS_L2,  // 當
	0x7586, KANJI_SJIS_L2,  // 疆
	0x7587, KANJI_SJIS_L2,  // 疇
	0x7574, KANJI_SJIS_L2,  // 畴
	0x758A, KANJI_SJIS_L2,  // 疊
	0x7589, KANJI_SJIS_L2,  // 疉
	0x7582, KANJI_SJIS_L2,  // 疂
	0x7594, KANJI_SJIS_L2,  // 疔
	0x759A, KANJI_SJIS_L2,  // 疚
	0x759D, KANJI_SJIS_L2,  // 疝
	0x75A5, KANJI_SJIS_L2,  // 疥
	0x75A3, KANJI_SJIS_L2,  // 疣
	0x75C2, KANJI_SJIS_L2,  // 痂
	0x75B3, KANJI_SJIS_L2,  // 疳
	0x75C3, KANJI_SJIS_L2,  // 痃
	0x75B5, KANJI_SJIS_L2,  // 疵
	0x75BD, KANJI_SJIS_L2,  // 疽
	0x75B8, KANJI_SJIS_L2,  // 疸
	0x75BC, KANJI_SJIS_L2,  // 疼
	0x75B1, KANJI_SJIS_L2,  // 疱
	0x75CD, KANJI_SJIS_L2,  // 痍
	0x75CA, KANJI_SJIS_L2,  // 痊
	0x75D2, KANJI_SJIS_L2,  // 痒
	0x75D9, KANJI_SJIS_L2,  // 痙
	0x75E3, KANJI_SJIS_L2,  // 痣
	0x75DE, KANJI_SJIS_L2,  // 痞
	0x75FE, KANJI_SJIS_L2,  // 痾
	0x75FF, KANJI_SJIS_L2,  // 痿
	0x3000, KANJI_SJIS_L2,  // 　
	0x75FC, KANJI_SJIS_L2,  // 痼
	0x7601, KANJI_SJIS_L2,  // 瘁
	0x75F0, KANJI_SJIS_L2,  // 痰
	0x75FA, KANJI_SJIS_L2,  // 痺
	0x75F2, KANJI_SJIS_L2,  // 痲
	0x75F3, KANJI_SJIS_L2,  // 痳
	0x760B, KANJI_SJIS_L2,  // 瘋
	0x760D, KANJI_SJIS_L2,  // 瘍
	0x7609, KANJI_SJIS_L2,  // 瘉
	0x761F, KANJI_SJIS_L2,  // 瘟
	0x7627, KANJI_SJIS_L2,  // 瘧
	0x7620, KANJI_SJIS_L2,  // 瘠
	0x7621, KANJI_SJIS_L2,  // 瘡
	0x7622, KANJI_SJIS_L2,  // 瘢
	0x7624, KANJI_SJIS_L2,  // 瘤
	0x7634, KANJI_SJIS_L2,  // 瘴
	0x7630, KANJI_SJIS_L2,  // 瘰
	0x763B, KANJI_SJIS_L2,  // 瘻
	0x7647, KANJI_SJIS_L2,  // 癇
	0x7648, KANJI_SJIS_L2,  // 癈
	0x7646, KANJI_SJIS_L2,  // 癆
	0x765C, KANJI_SJIS_L2,  // 癜
	0x7658, KANJI_SJIS_L2,  // 癘
	0x7661, KANJI_SJIS_L2,  // 癡
	0x7662, KANJI_SJIS_L2,  // 癢
	0x7668, KANJI_SJIS_L2,  // 癨
	0x7669, KANJI_SJIS_L2,  // 癩
	0x766A, KANJI_SJIS_L2,  // 癪
	0x7667, KANJI_SJIS_L2,  // 癧
	0x766C, KANJI_SJIS_L2,  // 癬
	0x7670, KANJI_SJIS_L2,  // 癰
	0x7672, KANJI_SJIS_L2,  // 癲
	0x7676, KANJI_SJIS_L2,  // 癶
	0x7678, KANJI_SJIS_L2,  // 癸
	0x767C, KANJI_SJIS_L2,  // 發
	0x7680, KANJI_SJIS_L2,  // 皀
	0x7683, KANJI_SJIS_L2,  // 皃
	0x7688, KANJI_SJIS_L2,  // 皈
	0x768B, KANJI_SJIS_L2,  // 皋
	0x768E, KANJI_SJIS_L2,  // 皎
	0x7696, KANJI_SJIS_L2,  // 皖
	0x7693, KANJI_SJIS_L2,  // 皓
	0x7699, KANJI_SJIS_L2,  // 皙
	0x769A, KANJI_SJIS_L2,  // 皚
	0x76B0, KANJI_SJIS_L2,  // 皰
	0x76B4, KANJI_SJIS_L2,  // 皴
	0x76B8, KANJI_SJIS_L2,  // 皸
	0x76B9, KANJI_SJIS_L2,  // 皹
	0x76BA, KANJI_SJIS_L2,  // 皺
	0x76C2, KANJI_SJIS_L2,  // 盂
	0x76CD, KANJI_SJIS_L2,  // 盍
	0x76D6, KANJI_SJIS_L2,  // 盖
	0x76D2, KANJI_SJIS_L2,  // 盒
	0x76DE, KANJI_SJIS_L2,  // 盞
	0x76E1, KANJI_SJIS_L2,  // 盡
	0x76E5, KANJI_SJIS_L2,  // 盥
	0x76E7, KANJI_SJIS_L2,  // 盧
	0x76EA, KANJI_SJIS_L2,  // 盪
	0x862F, KANJI_SJIS_L2,  // 蘯
	0x76FB, KANJI_SJIS_L2,  // 盻
	0x7708, KANJI_SJIS_L2,  // 眈
	0x7707, KANJI_SJIS_L2,  // 眇
	0x7704, KANJI_SJIS_L2,  // 眄
	0x7729, KANJI_SJIS_L2,  // 眩
	0x7724, KANJI_SJIS_L2,  // 眤
	0x771E, KANJI_SJIS_L2,  // 眞
	0x7725, KANJI_SJIS_L2,  // 眥
	0x7726, KANJI_SJIS_L2,  // 眦
	0x771B, KANJI_SJIS_L2,  // 眛
	0x7737, KANJI_SJIS_L2,  // 眷
	0x7738, KANJI_SJIS_L2,  // 眸
	0x7747, KANJI_SJIS_L2,  // 睇
	0x775A, KANJI_SJIS_L2,  // 睚
	0x7768, KANJI_SJIS_L2,  // 睨
	0x776B, KANJI_SJIS_L2,  // 睫
	0x775B, KANJI_SJIS_L2,  // 睛
	0x7765, KANJI_SJIS_L2,  // 睥
	0x777F, KANJI_SJIS_L2,  // 睿
	0x777E, KANJI_SJIS_L2,  // 睾
	0x7779, KANJI_SJIS_L2,  // 睹
	0x778E, KANJI_SJIS_L2,  // 瞎
	0x778B, KANJI_SJIS_L2,  // 瞋
	0x7791, KANJI_SJIS_L2,  // 瞑
	0x77A0, KANJI_SJIS_L2,  // 瞠
	0x779E, KANJI_SJIS_L2,  // 瞞
	0x77B0, KANJI_SJIS_L2,  // 瞰
	0x77B6, KANJI_SJIS_L2,  // 瞶
	0x77B9, KANJI_SJIS_L2,  // 瞹
	0x77BF, KANJI_SJIS_L2,  // 瞿
	0x77BC, KANJI_SJIS_L2,  // 瞼
	0x77BD, KANJI_SJIS_L2,  // 瞽
	0x77BB, KANJI_SJIS_L2,  // 瞻
	0x77C7, KANJI_SJIS_L2,  // 矇
	0x77CD, KANJI_SJIS_L2,  // 矍
	0x77D7, KANJI_SJIS_L2,  // 矗
	0x77DA, KANJI_SJIS_L2,  // 矚
	0x77DC, KANJI_SJIS_L2,  // 矜
	0x77E3, KANJI_SJIS_L2,  // 矣
	0x77EE, KANJI_SJIS_L2,  // 矮
	0x77FC, KANJI_SJIS_L2,  // 矼
	0x780C, KANJI_SJIS_L2,  // 砌
	0x7812, KANJI_SJIS_L2,  // 砒
	0x7926, KANJI_SJIS_L2,  // 礦
	0x7820, KANJI_SJIS_L2,  // 砠
	0x792A, KANJI_SJIS_L2,  // 礪
	0x7845, KANJI_SJIS_L2,  // 硅
	0x788E, KANJI_SJIS_L2,  // 碎
	0x7874, KANJI_SJIS_L2,  // 硴
	0x7886, KANJI_SJIS_L2,  // 碆
	0x787C, KANJI_SJIS_L2,  // 硼
	0x789A, KANJI_SJIS_L2,  // 碚
	0x788C, KANJI_SJIS_L2,  // 碌
	0x78A3, KANJI_SJIS_L2,  // 碣
	0x78B5, KANJI_SJIS_L2,  // 碵
	0x78AA, KANJI_SJIS_L2,  // 碪
	0x78AF, KANJI_SJIS_L2,  // 碯
	0x78D1, KANJI_SJIS_L2,  // 磑
	0x78C6, KANJI_SJIS_L2,  // 磆
	0x78CB, KANJI_SJIS_L2,  // 磋
	0x78D4, KANJI_SJIS_L2,  // 磔
	0x78BE, KANJI_SJIS_L2,  // 碾
	0x78BC, KANJI_SJIS_L2,  // 碼
	0x78C5, KANJI_SJIS_L2,  // 磅
	0x78CA, KANJI_SJIS_L2,  // 磊
	0x78EC, KANJI_SJIS_L2,  // 磬
	0x78E7, KANJI_SJIS_L2,  // 磧
	0x78DA, KANJI_SJIS_L2,  // 磚
	0x78FD, KANJI_SJIS_L2,  // 磽
	0x78F4, KANJI_SJIS_L2,  // 磴
	0x7907, KANJI_SJIS_L2,  // 礇
	0x7912, KANJI_SJIS_L2,  // 礒
	0x7911, KANJI_SJIS_L2,  // 礑
	0x7919, KANJI_SJIS_L2,  // 礙
	0x792C, KANJI_SJIS_L2,  // 礬
	0x792B, KANJI_SJIS_L2,  // 礫
	0x7940, KANJI_SJIS_L2,  // 祀
	0x7960, KANJI_SJIS_L2,  // 祠
	0x7957, KANJI_SJIS_L2,  // 祗
	0x795F, KANJI_SJIS_L2,  // 祟
	0x795A, KANJI_SJIS_L2,  // 祚
	0x7955, KANJI_SJIS_L2,  // 祕
	0x7953, KANJI_SJIS_L2,  // 祓
	0x797A, KANJI_SJIS_L2,  // 祺
	0x797F, KANJI_SJIS_L2,  // 祿
	0x798A, KANJI_SJIS_L2,  // 禊
	0x799D, KANJI_SJIS_L2,  // 禝
	0x79A7, KANJI_SJIS_L2,  // 禧
	0x9F4B, KANJI_SJIS_L2,  // 齋
	0x79AA, KANJI_SJIS_L2,  // 禪
	0x79AE, KANJI_SJIS_L2,  // 禮
	0x79B3, KANJI_SJIS_L2,  // 禳
	0x79B9, KANJI_SJIS_L2,  // 禹
	0x79BA, KANJI_SJIS_L2,  // 禺
	0x79C9, KANJI_SJIS_L2,  // 秉
	0x79D5, KANJI_SJIS_L2,  // 秕
	0x79E7, KANJI_SJIS_L2,  // 秧
	0x79EC, KANJI_SJIS_L2,  // 秬
	0x79E1, KANJI_SJIS_L2,  // 秡
	0x79E3, KANJI_SJIS_L2,  // 秣
	0x7A08, KANJI_SJIS_L2,  // 稈
	0x7A0D, KANJI_SJIS_L2,  // 稍
	0x7A18, KANJI_SJIS_L2,  // 稘
	0x7A19, KANJI_SJIS_L2,  // 稙
	0x7A20, KANJI_SJIS_L2,  // 稠
	0x7A1F, KANJI_SJIS_L2,  // 稟
	0x7980, KANJI_SJIS_L2,  // 禀
	0x7A31, KANJI_SJIS_L2,  // 稱
	0x7A3B, KANJI_SJIS_L2,  // 稻
	0x7A3E, KANJI_SJIS_L2,  // 稾
	0x7A37, KANJI_SJIS_L2,  // 稷
	0x7A43, KANJI_SJIS_L2,  // 穃
	0x7A57, KANJI_SJIS_L2,  // 穗
	0x7A49, KANJI_SJIS_L2,  // 穉
	0x7A61, KANJI_SJIS_L2,  // 穡
	0x7A62, KANJI_SJIS_L2,  // 穢
	0x7A69, KANJI_SJIS_L2,  // 穩
	0x9F9D, KANJI_SJIS_L2,  // 龝
	0x7A70, KANJI_SJIS_L2,  // 穰
	0x7A79, KANJI_SJIS_L2,  // 穹
	0x7A7D, KANJI_SJIS_L2,  // 穽
	0x7A88, KANJI_SJIS_L2,  // 窈
	0x7A97, KANJI_SJIS_L2,  // 窗
	0x7A95, KANJI_SJIS_L2,  // 窕
	0x7A98, KANJI_SJIS_L2,  // 窘
	0x7A96, KANJI_SJIS_L2,  // 窖
	0x7AA9, KANJI_SJIS_L2,  // 窩
	0x7AC8, KANJI_SJIS_L2,  // 竈
	0x7AB0, KANJI_SJIS_L2,  // 窰
	0x3000, KANJI_SJIS_L2,  // 　
	0x7AB6, KANJI_SJIS_L2,  // 窶
	0x7AC5, KANJI_SJIS_L2,  // 竅
	0x7AC4, KANJI_SJIS_L2,  // 竄
	0x7ABF, KANJI_SJIS_L2,  // 窿
	0x9083, KANJI_SJIS_L2,  // 邃
	0x7AC7, KANJI_SJIS_L2,  // 竇
	0x7ACA, KANJI_SJIS_L2,  // 竊
	0x7ACD, KANJI_SJIS_L2,  // 竍
	0x7ACF, KANJI_SJIS_L2,  // 竏
	0x7AD5, KANJI_SJIS_L2,  // 竕
	0x7AD3, KANJI_SJIS_L2,  // 竓
	0x7AD9, KANJI_SJIS_L2,  // 站
	0x7ADA, KANJI_SJIS_L2,  // 竚
	0x7ADD, KANJI_SJIS_L2,  // 竝
	0x7AE1, KANJI_SJIS_L2,  // 竡
	0x7AE2, KANJI_SJIS_L2,  // 竢
	0x7AE6, KANJI_SJIS_L2,  // 竦
	0x7AED, KANJI_SJIS_L2,  // 竭
	0x7AF0, KANJI_SJIS_L2,  // 竰
	0x7B02, KANJI_SJIS_L2,  // 笂
	0x7B0F, KANJI_SJIS_L2,  // 笏
	0x7B0A, KANJI_SJIS_L2,  // 笊
	0x7B06, KANJI_SJIS_L2,  // 笆
	0x7B33, KANJI_SJIS_L2,  // 笳
	0x7B18, KANJI_SJIS_L2,  // 笘
	0x7B19, KANJI_SJIS_L2,  // 笙
	0x7B1E, KANJI_SJIS_L2,  // 笞
	0x7B35, KANJI_SJIS_L2,  // 笵
	0x7B28, KANJI_SJIS_L2,  // 笨
	0x7B36, KANJI_SJIS_L2,  // 笶
	0x7B50, KANJI_SJIS_L2,  // 筐
	0x7B7A, KANJI_SJIS_L2,  // 筺
	0x7B04, KANJI_SJIS_L2,  // 笄
	0x7B4D, KANJI_SJIS_L2,  // 筍
	0x7B0B, KANJI_SJIS_L2,  // 笋
	0x7B4C, KANJI_SJIS_L2,  // 筌
	0x7B45, KANJI_SJIS_L2,  // 筅
	0x7B75, KANJI_SJIS_L2,  // 筵
	0x7B65, KANJI_SJIS_L2,  // 筥
	0x7B74, KANJI_SJIS_L2,  // 筴
	0x7B67, KANJI_SJIS_L2,  // 筧
	0x7B70, KANJI_SJIS_L2,  // 筰
	0x7B71, KANJI_SJIS_L2,  // 筱
	0x7B6C, KANJI_SJIS_L2,  // 筬
	0x7B6E, KANJI_SJIS_L2,  // 筮
	0x7B9D, KANJI_SJIS_L2,  // 箝
	0x7B98, KANJI_SJIS_L2,  // 箘
	0x7B9F, KANJI_SJIS_L2,  // 箟
	0x7B8D, KANJI_SJIS_L2,  // 箍
	0x7B9C, KANJI_SJIS_L2,  // 箜
	0x7B9A, KANJI_SJIS_L2,  // 箚
	0x7B8B, KANJI_SJIS_L2,  // 箋
	0x7B92, KANJI_SJIS_L2,  // 箒
	0x7B8F, KANJI_SJIS_L2,  // 箏
	0x7B5D, KANJI_SJIS_L2,  // 筝
	0x7B99, KANJI_SJIS_L2,  // 箙
	0x7BCB, KANJI_SJIS_L2,  // 篋
	0x7BC1, KANJI_SJIS_L2,  // 篁
	0x7BCC, KANJI_SJIS_L2,  // 篌
	0x7BCF, KANJI_SJIS_L2,  // 篏
	0x7BB4, KANJI_SJIS_L2,  // 箴
	0x7BC6, KANJI_SJIS_L2,  // 篆
	0x7BDD, KANJI_SJIS_L2,  // 篝
	0x7BE9, KANJI_SJIS_L2,  // 篩
	0x7C11, KANJI_SJIS_L2,  // 簑
	0x7C14, KANJI_SJIS_L2,  // 簔
	0x7BE6, KANJI_SJIS_L2,  // 篦
	0x7BE5, KANJI_SJIS_L2,  // 篥
	0x7C60, KANJI_SJIS_L2,  // 籠
	0x7C00, KANJI_SJIS_L2,  // 簀
	0x7C07, KANJI_SJIS_L2,  // 簇
	0x7C13, KANJI_SJIS_L2,  // 簓
	0x7BF3, KANJI_SJIS_L2,  // 篳
	0x7BF7, KANJI_SJIS_L2,  // 篷
	0x7C17, KANJI_SJIS_L2,  // 簗
	0x7C0D, KANJI_SJIS_L2,  // 簍
	0x7BF6, KANJI_SJIS_L2,  // 篶
	0x7C23, KANJI_SJIS_L2,  // 簣
	0x7C27, KANJI_SJIS_L2,  // 簧
	0x7C2A, KANJI_SJIS_L2,  // 簪
	0x7C1F, KANJI_SJIS_L2,  // 簟
	0x7C37, KANJI_SJIS_L2,  // 簷
	0x7C2B, KANJI_SJIS_L2,  // 簫
	0x7C3D, KANJI_SJIS_L2,  // 簽
	0x7C4C, KANJI_SJIS_L2,  // 籌
	0x7C43, KANJI_SJIS_L2,  // 籃
	0x7C54, KANJI_SJIS_L2,  // 籔
	0x7C4F, KANJI_SJIS_L2,  // 籏
	0x7C40, KANJI_SJIS_L2,  // 籀
	0x7C50, KANJI_SJIS_L2,  // 籐
	0x7C58, KANJI_SJIS_L2,  // 籘
	0x7C5F, KANJI_SJIS_L2,  // 籟
	0x7C64, KANJI_SJIS_L2,  // 籤
	0x7C56, KANJI_SJIS_L2,  // 籖
	0x7C65, KANJI_SJIS_L2,  // 籥
	0x7C6C, KANJI_SJIS_L2,  // 籬
	0x7C75, KANJI_SJIS_L2,  // 籵
	0x7C83, KANJI_SJIS_L2,  // 粃
	0x7C90, KANJI_SJIS_L2,  // 粐
	0x7CA4, KANJI_SJIS_L2,  // 粤
	0x7CAD, KANJI_SJIS_L2,  // 粭
	0x7CA2, KANJI_SJIS_L2,  // 粢
	0x7CAB, KANJI_SJIS_L2,  // 粫
	0x7CA1, KANJI_SJIS_L2,  // 粡
	0x7CA8, KANJI_SJIS_L2,  // 粨
	0x7CB3, KANJI_SJIS_L2,  // 粳
	0x7CB2, KANJI_SJIS_L2,  // 粲
	0x7CB1, KANJI_SJIS_L2,  // 粱
	0x7CAE, KANJI_SJIS_L2,  // 粮
	0x7CB9, KANJI_SJIS_L2,  // 粹
	0x7CBD, KANJI_SJIS_L2,  // 粽
	0x7CC0, KANJI_SJIS_L2,  // 糀
	0x7CC5, KANJI_SJIS_L2,  // 糅
	0x7CC2, KANJI_SJIS_L2,  // 糂
	0x7CD8, KANJI_SJIS_L2,  // 糘
	0x7CD2, KANJI_SJIS_L2,  // 糒
	0x7CDC, KANJI_SJIS_L2,  // 糜
	0x7CE2, KANJI_SJIS_L2,  // 糢
	0x9B3B, KANJI_SJIS_L2,  // 鬻
	0x7CEF, KANJI_SJIS_L2,  // 糯
	0x7CF2, KANJI_SJIS_L2,  // 糲
	0x7CF4, KANJI_SJIS_L2,  // 糴
	0x7CF6, KANJI_SJIS_L2,  // 糶
	0x7CFA, KANJI_SJIS_L2,  // 糺
	0x7D06, KANJI_SJIS_L2,  // 紆
	0x7D02, KANJI_SJIS_L2,  // 紂
	0x7D1C, KANJI_SJIS_L2,  // 紜
	0x7D15, KANJI_SJIS_L2,  // 紕
	0x7D0A, KANJI_SJIS_L2,  // 紊
	0x7D45, KANJI_SJIS_L2,  // 絅
	0x7D4B, KANJI_SJIS_L2,  // 絋
	0x7D2E, KANJI_SJIS_L2,  // 紮
	0x7D32, KANJI_SJIS_L2,  // 紲
	0x7D3F, KANJI_SJIS_L2,  // 紿
	0x7D35, KANJI_SJIS_L2,  // 紵
	0x7D46, KANJI_SJIS_L2,  // 絆
	0x7D73, KANJI_SJIS_L2,  // 絳
	0x7D56, KANJI_SJIS_L2,  // 絖
	0x7D4E, KANJI_SJIS_L2,  // 絎
	0x7D72, KANJI_SJIS_L2,  // 絲
	0x7D68, KANJI_SJIS_L2,  // 絨
	0x7D6E, KANJI_SJIS_L2,  // 絮
	0x7D4F, KANJI_SJIS_L2,  // 絏
	0x7D63, KANJI_SJIS_L2,  // 絣
	0x7D93, KANJI_SJIS_L2,  // 經
	0x7D89, KANJI_SJIS_L2,  // 綉
	0x7D5B, KANJI_SJIS_L2,  // 絛
	0x7D8F, KANJI_SJIS_L2,  // 綏
	0x7D7D, KANJI_SJIS_L2,  // 絽
	0x7D9B, KANJI_SJIS_L2,  // 綛
	0x7DBA, KANJI_SJIS_L2,  // 綺
	0x7DAE, KANJI_SJIS_L2,  // 綮
	0x7DA3, KANJI_SJIS_L2,  // 綣
	0x7DB5, KANJI_SJIS_L2,  // 綵
	0x7DC7, KANJI_SJIS_L2,  // 緇
	0x7DBD, KANJI_SJIS_L2,  // 綽
	0x7DAB, KANJI_SJIS_L2,  // 綫
	0x7E3D, KANJI_SJIS_L2,  // 總
	0x7DA2, KANJI_SJIS_L2,  // 綢
	0x7DAF, KANJI_SJIS_L2,  // 綯
	0x7DDC, KANJI_SJIS_L2,  // 緜
	0x7DB8, KANJI_SJIS_L2,  // 綸
	0x7D9F, KANJI_SJIS_L2,  // 綟
	0x7DB0, KANJI_SJIS_L2,  // 綰
	0x7DD8, KANJI_SJIS_L2,  // 緘
	0x7DDD, KANJI_SJIS_L2,  // 緝
	0x7DE4, KANJI_SJIS_L2,  // 緤
	0x7DDE, KANJI_SJIS_L2,  // 緞
	0x7DFB, KANJI_SJIS_L2,  // 緻
	0x7DF2, KANJI_SJIS_L2,  // 緲
	0x7DE1, KANJI_SJIS_L2,  // 緡
	0x7E05, KANJI_SJIS_L2,  // 縅
	0x7E0A, KANJI_SJIS_L2,  // 縊
	0x7E23, KANJI_SJIS_L2,  // 縣
	0x7E21, KANJI_SJIS_L2,  // 縡
	0x7E12, KANJI_SJIS_L2,  // 縒
	0x7E31, KANJI_SJIS_L2,  // 縱
	0x7E1F, KANJI_SJIS_L2,  // 縟
	0x7E09, KANJI_SJIS_L2,  // 縉
	0x7E0B, KANJI_SJIS_L2,  // 縋
	0x7E22, KANJI_SJIS_L2,  // 縢
	0x7E46, KANJI_SJIS_L2,  // 繆
	0x7E66, KANJI_SJIS_L2,  // 繦
	0x7E3B, KANJI_SJIS_L2,  // 縻
	0x7E35, KANJI_SJIS_L2,  // 縵
	0x7E39, KANJI_SJIS_L2,  // 縹
	0x7E43, KANJI_SJIS_L2,  // 繃
	0x7E37, KANJI_SJIS_L2,  // 縷
	0x3000, KANJI_SJIS_L2,  // 　
	0x7E32, KANJI_SJIS_L2,  // 縲
	0x7E3A, KANJI_SJIS_L2,  // 縺
	0x7E67, KANJI_SJIS_L2,  // 繧
	0x7E5D, KANJI_SJIS_L2,  // 繝
	0x7E56, KANJI_SJIS_L2,  // 繖
	0x7E5E, KANJI_SJIS_L2,  // 繞
	0x7E59, KANJI_SJIS_L2,  // 繙
	0x7E5A, KANJI_SJIS_L2,  // 繚
	0x7E79, KANJI_SJIS_L2,  // 繹
	0x7E6A, KANJI_SJIS_L2,  // 繪
	0x7E69, KANJI_SJIS_L2,  // 繩
	0x7E7C, KANJI_SJIS_L2,  // 繼
	0x7E7B, KANJI_SJIS_L2,  // 繻
	0x7E83, KANJI_SJIS_L2,  // 纃
	0x7DD5, KANJI_SJIS_L2,  // 緕
	0x7E7D, KANJI_SJIS_L2,  // 繽
	0x8FAE, KANJI_SJIS_L2,  // 辮
	0x7E7F, KANJI_SJIS_L2,  // 繿
	0x7E88, KANJI_SJIS_L2,  // 纈
	0x7E89, KANJI_SJIS_L2,  // 纉
	0x7E8C, KANJI_SJIS_L2,  // 續
	0x7E92, KANJI_SJIS_L2,  // 纒
	0x7E90, KANJI_SJIS_L2,  // 纐
	0x7E93, KANJI_SJIS_L2,  // 纓
	0x7E94, KANJI_SJIS_L2,  // 纔
	0x7E96, KANJI_SJIS_L2,  // 纖
	0x7E8E, KANJI_SJIS_L2,  // 纎
	0x7E9B, KANJI_SJIS_L2,  // 纛
	0x7E9C, KANJI_SJIS_L2,  // 纜
	0x7F38, KANJI_SJIS_L2,  // 缸
	0x7F3A, KANJI_SJIS_L2,  // 缺
	0x7F45, KANJI_SJIS_L2,  // 罅
	0x7F4C, KANJI_SJIS_L2,  // 罌
	0x7F4D, KANJI_SJIS_L2,  // 罍
	0x7F4E, KANJI_SJIS_L2,  // 罎
	0x7F50, KANJI_SJIS_L2,  // 罐
	0x7F51, KANJI_SJIS_L2,  // 网
	0x7F55, KANJI_SJIS_L2,  // 罕
	0x7F54, KANJI_SJIS_L2,  // 罔
	0x7F58, KANJI_SJIS_L2,  // 罘
	0x7F5F, KANJI_SJIS_L2,  // 罟
	0x7F60, KANJI_SJIS_L2,  // 罠
	0x7F68, KANJI_SJIS_L2,  // 罨
	0x7F69, KANJI_SJIS_L2,  // 罩
	0x7F67, KANJI_SJIS_L2,  // 罧
	0x7F78, KANJI_SJIS_L2,  // 罸
	0x7F82, KANJI_SJIS_L2,  // 羂
	0x7F86, KANJI_SJIS_L2,  // 羆
	0x7F83, KANJI_SJIS_L2,  // 羃
	0x7F88, KANJI_SJIS_L2,  // 羈
	0x7F87, KANJI_SJIS_L2,  // 羇
	0x7F8C, KANJI_SJIS_L2,  // 羌
	0x7F94, KANJI_SJIS_L2,  // 羔
	0x7F9E, KANJI_SJIS_L2,  // 羞
	0x7F9D, KANJI_SJIS_L2,  // 羝
	0x7F9A, KANJI_SJIS_L2,  // 羚
	0x7FA3, KANJI_SJIS_L2,  // 羣
	0x7FAF, KANJI_SJIS_L2,  // 羯
	0x7FB2, KANJI_SJIS_L2,  // 羲
	0x7FB9, KANJI_SJIS_L2,  // 羹
	0x7FAE, KANJI_SJIS_L2,  // 羮
	0x7FB6, KANJI_SJIS_L2,  // 羶
	0x7FB8, KANJI_SJIS_L2,  // 羸
	0x8B71, KANJI_SJIS_L2,  // 譱
	0x7FC5, KANJI_SJIS_L2,  // 翅
	0x7FC6, KANJI_SJIS_L2,  // 翆
	0x7FCA, KANJI_SJIS_L2,  // 翊
	0x7FD5, KANJI_SJIS_L2,  // 翕
	0x7FD4, KANJI_SJIS_L2,  // 翔
	0x7FE1, KANJI_SJIS_L2,  // 翡
	0x7FE6, KANJI_SJIS_L2,  // 翦
	0x7FE9, KANJI_SJIS_L2,  // 翩
	0x7FF3, KANJI_SJIS_L2,  // 翳
	0x7FF9, KANJI_SJIS_L2,  // 翹
	0x98DC, KANJI_SJIS_L2,  // 飜
	0x8006, KANJI_SJIS_L2,  // 耆
	0x8004, KANJI_SJIS_L2,  // 耄
	0x800B, KANJI_SJIS_L2,  // 耋
	0x8012, KANJI_SJIS_L2,  // 耒
	0x8018, KANJI_SJIS_L2,  // 耘
	0x8019, KANJI_SJIS_L2,  // 耙
	0x801C, KANJI_SJIS_L2,  // 耜
	0x8021, KANJI_SJIS_L2,  // 耡
	0x8028, KANJI_SJIS_L2,  // 耨
	0x803F, KANJI_SJIS_L2,  // 耿
	0x803B, KANJI_SJIS_L2,  // 耻
	0x804A, KANJI_SJIS_L2,  // 聊
	0x8046, KANJI_SJIS_L2,  // 聆
	0x8052, KANJI_SJIS_L2,  // 聒
	0x8058, KANJI_SJIS_L2,  // 聘
	0x805A, KANJI_SJIS_L2,  // 聚
	0x805F, KANJI_SJIS_L2,  // 聟
	0x8062, KANJI_SJIS_L2,  // 聢
	0x8068, KANJI_SJIS_L2,  // 聨
	0x8073, KANJI_SJIS_L2,  // 聳
	0x8072, KANJI_SJIS_L2,  // 聲
	0x8070, KANJI_SJIS_L2,  // 聰
	0x8076, KANJI_SJIS_L2,  // 聶
	0x8079, KANJI_SJIS_L2,  // 聹
	0x807D, KANJI_SJIS_L2,  // 聽
	0x807F, KANJI_SJIS_L2,  // 聿
	0x8084, KANJI_SJIS_L2,  // 肄
	0x8086, KANJI_SJIS_L2,  // 肆
	0x8085, KANJI_SJIS_L2,  // 肅
	0x809B, KANJI_SJIS_L2,  // 肛
	0x8093, KANJI_SJIS_L2,  // 肓
	0x809A, KANJI_SJIS_L2,  // 肚
	0x80AD, KANJI_SJIS_L2,  // 肭
	0x5190, KANJI_SJIS_L2,  // 冐
	0x80AC, KANJI_SJIS_L2,  // 肬
	0x80DB, KANJI_SJIS_L2,  // 胛
	0x80E5, KANJI_SJIS_L2,  // 胥
	0x80D9, KANJI_SJIS_L2,  // 胙
	0x80DD, KANJI_SJIS_L2,  // 胝
	0x80C4, KANJI_SJIS_L2,  // 胄
	0x80DA, KANJI_SJIS_L2,  // 胚
	0x80D6, KANJI_SJIS_L2,  // 胖
	0x8109, KANJI_SJIS_L2,  // 脉
	0x80EF, KANJI_SJIS_L2,  // 胯
	0x80F1, KANJI_SJIS_L2,  // 胱
	0x811B, KANJI_SJIS_L2,  // 脛
	0x8129, KANJI_SJIS_L2,  // 脩
	0x8123, KANJI_SJIS_L2,  // 脣
	0x812F, KANJI_SJIS_L2,  // 脯
	0x814B, KANJI_SJIS_L2,  // 腋
	0x968B, KANJI_SJIS_L2,  // 隋
	0x8146, KANJI_SJIS_L2,  // 腆
	0x813E, KANJI_SJIS_L2,  // 脾
	0x8153, KANJI_SJIS_L2,  // 腓
	0x8151, KANJI_SJIS_L2,  // 腑
	0x80FC, KANJI_SJIS_L2,  // 胼
	0x8171, KANJI_SJIS_L2,  // 腱
	0x816E, KANJI_SJIS_L2,  // 腮
	0x8165, KANJI_SJIS_L2,  // 腥
	0x8166, KANJI_SJIS_L2,  // 腦
	0x8174, KANJI_SJIS_L2,  // 腴
	0x8183, KANJI_SJIS_L2,  // 膃
	0x8188, KANJI_SJIS_L2,  // 膈
	0x818A, KANJI_SJIS_L2,  // 膊
	0x8180, KANJI_SJIS_L2,  // 膀
	0x8182, KANJI_SJIS_L2,  // 膂
	0x81A0, KANJI_SJIS_L2,  // 膠
	0x8195, KANJI_SJIS_L2,  // 膕
	0x81A4, KANJI_SJIS_L2,  // 膤
	0x81A3, KANJI_SJIS_L2,  // 膣
	0x815F, KANJI_SJIS_L2,  // 腟
	0x8193, KANJI_SJIS_L2,  // 膓
	0x81A9, KANJI_SJIS_L2,  // 膩
	0x81B0, KANJI_SJIS_L2,  // 膰
	0x81B5, KANJI_SJIS_L2,  // 膵
	0x81BE, KANJI_SJIS_L2,  // 膾
	0x81B8, KANJI_SJIS_L2,  // 膸
	0x81BD, KANJI_SJIS_L2,  // 膽
	0x81C0, KANJI_SJIS_L2,  // 臀
	0x81C2, KANJI_SJIS_L2,  // 臂
	0x81BA, KANJI_SJIS_L2,  // 膺
	0x81C9, KANJI_SJIS_L2,  // 臉
	0x81CD, KANJI_SJIS_L2,  // 臍
	0x81D1, KANJI_SJIS_L2,  // 臑
	0x81D9, KANJI_SJIS_L2,  // 臙
	0x81D8, KANJI_SJIS_L2,  // 臘
	0x81C8, KANJI_SJIS_L2,  // 臈
	0x81DA, KANJI_SJIS_L2,  // 臚
	0x81DF, KANJI_SJIS_L2,  // 臟
	0x81E0, KANJI_SJIS_L2,  // 臠
	0x81E7, KANJI_SJIS_L2,  // 臧
	0x81FA, KANJI_SJIS_L2,  // 臺
	0x81FB, KANJI_SJIS_L2,  // 臻
	0x81FE, KANJI_SJIS_L2,  // 臾
	0x8201, KANJI_SJIS_L2,  // 舁
	0x8202, KANJI_SJIS_L2,  // 舂
	0x8205, KANJI_SJIS_L2,  // 舅
	0x8207, KANJI_SJIS_L2,  // 與
	0x820A, KANJI_SJIS_L2,  // 舊
	0x820D, KANJI_SJIS_L2,  // 舍
	0x8210, KANJI_SJIS_L2,  // 舐
	0x8216, KANJI_SJIS_L2,  // 舖
	0x8229, KANJI_SJIS_L2,  // 舩
	0x822B, KANJI_SJIS_L2,  // 舫
	0x8238, KANJI_SJIS_L2,  // 舸
	0x8233, KANJI_SJIS_L2,  // 舳
	0x8240, KANJI_SJIS_L2,  // 艀
	0x8259, KANJI_SJIS_L2,  // 艙
	0x8258, KANJI_SJIS_L2,  // 艘
	0x825D, KANJI_SJIS_L2,  // 艝
	0x825A, KANJI_SJIS_L2,  // 艚
	0x825F, KANJI_SJIS_L2,  // 艟
	0x8264, KANJI_SJIS_L2,  // 艤
	0x3000, KANJI_SJIS_L2,  // 　
	0x8262, KANJI_SJIS_L2,  // 艢
	0x8268, KANJI_SJIS_L2,  // 艨
	0x826A, KANJI_SJIS_L2,  // 艪
	0x826B, KANJI_SJIS_L2,  // 艫
	0x822E, KANJI_SJIS_L2,  // 舮
	0x8271, KANJI_SJIS_L2,  // 艱
	0x8277, KANJI_SJIS_L2,  // 艷
	0x8278, KANJI_SJIS_L2,  // 艸
	0x827E, KANJI_SJIS_L2,  // 艾
	0x828D, KANJI_SJIS_L2,  // 芍
	0x8292, KANJI_SJIS_L2,  // 芒
	0x82AB, KANJI_SJIS_L2,  // 芫
	0x829F, KANJI_SJIS_L2,  // 芟
	0x82BB, KANJI_SJIS_L2,  // 芻
	0x82AC, KANJI_SJIS_L2,  // 芬
	0x82E1, KANJI_SJIS_L2,  // 苡
	0x82E3, KANJI_SJIS_L2,  // 苣
	0x82DF, KANJI_SJIS_L2,  // 苟
	0x82D2, KANJI_SJIS_L2,  // 苒
	0x82F4, KANJI_SJIS_L2,  // 苴
	0x82F3, KANJI_SJIS_L2,  // 苳
	0x82FA, KANJI_SJIS_L2,  // 苺
	0x8393, KANJI_SJIS_L2,  // 莓
	0x8303, KANJI_SJIS_L2,  // 范
	0x82FB, KANJI_SJIS_L2,  // 苻
	0x82F9, KANJI_SJIS_L2,  // 苹
	0x82DE, KANJI_SJIS_L2,  // 苞
	0x8306, KANJI_SJIS_L2,  // 茆
	0x82DC, KANJI_SJIS_L2,  // 苜
	0x8309, KANJI_SJIS_L2,  // 茉
	0x82D9, KANJI_SJIS_L2,  // 苙
	0x8335, KANJI_SJIS_L2,  // 茵
	0x8334, KANJI_SJIS_L2,  // 茴
	0x8316, KANJI_SJIS_L2,  // 茖
	0x8332, KANJI_SJIS_L2,  // 茲
	0x8331, KANJI_SJIS_L2,  // 茱
	0x8340, KANJI_SJIS_L2,  // 荀
	0x8339, KANJI_SJIS_L2,  // 茹
	0x8350, KANJI_SJIS_L2,  // 荐
	0x8345, KANJI_SJIS_L2,  // 荅
	0x832F, KANJI_SJIS_L2,  // 茯
	0x832B, KANJI_SJIS_L2,  // 茫
	0x8317, KANJI_SJIS_L2,  // 茗
	0x8318, KANJI_SJIS_L2,  // 茘
	0x8385, KANJI_SJIS_L2,  // 莅
	0x839A, KANJI_SJIS_L2,  // 莚
	0x83AA, KANJI_SJIS_L2,  // 莪
	0x839F, KANJI_SJIS_L2,  // 莟
	0x83A2, KANJI_SJIS_L2,  // 莢
	0x8396, KANJI_SJIS_L2,  // 莖
	0x8323, KANJI_SJIS_L2,  // 茣
	0x838E, KANJI_SJIS_L2,  // 莎
	0x8387, KANJI_SJIS_L2,  // 莇
	0x838A, KANJI_SJIS_L2,  // 莊
	0x837C, KANJI_SJIS_L2,  // 荼
	0x83B5, KANJI_SJIS_L2,  // 莵
	0x8373, KANJI_SJIS_L2,  // 荳
	0x8375, KANJI_SJIS_L2,  // 荵
	0x83A0, KANJI_SJIS_L2,  // 莠
	0x8389, KANJI_SJIS_L2,  // 莉
	0x83A8, KANJI_SJIS_L2,  // 莨
	0x83F4, KANJI_SJIS_L2,  // 菴
	0x8413, KANJI_SJIS_L2,  // 萓
	0x83EB, KANJI_SJIS_L2,  // 菫
	0x83CE, KANJI_SJIS_L2,  // 菎
	0x83FD, KANJI_SJIS_L2,  // 菽
	0x8403, KANJI_SJIS_L2,  // 萃
	0x83D8, KANJI_SJIS_L2,  // 菘
	0x840B, KANJI_SJIS_L2,  // 萋
	0x83C1, KANJI_SJIS_L2,  // 菁
	0x83F7, KANJI_SJIS_L2,  // 菷
	0x8407, KANJI_SJIS_L2,  // 萇
	0x83E0, KANJI_SJIS_L2,  // 菠
	0x83F2, KANJI_SJIS_L2,  // 菲
	0x840D, KANJI_SJIS_L2,  // 萍
	0x8422, KANJI_SJIS_L2,  // 萢
	0x8420, KANJI_SJIS_L2,  // 萠
	0x83BD, KANJI_SJIS_L2,  // 莽
	0x8438, KANJI_SJIS_L2,  // 萸
	0x8506, KANJI_SJIS_L2,  // 蔆
	0x83FB, KANJI_SJIS_L2,  // 菻
	0x846D, KANJI_SJIS_L2,  // 葭
	0x842A, KANJI_SJIS_L2,  // 萪
	0x843C, KANJI_SJIS_L2,  // 萼
	0x855A, KANJI_SJIS_L2,  // 蕚
	0x8484, KANJI_SJIS_L2,  // 蒄
	0x8477, KANJI_SJIS_L2,  // 葷
	0x846B, KANJI_SJIS_L2,  // 葫
	0x84AD, KANJI_SJIS_L2,  // 蒭
	0x846E, KANJI_SJIS_L2,  // 葮
	0x8482, KANJI_SJIS_L2,  // 蒂
	0x8469, KANJI_SJIS_L2,  // 葩
	0x8446, KANJI_SJIS_L2,  // 葆
	0x842C, KANJI_SJIS_L2,  // 萬
	0x846F, KANJI_SJIS_L2,  // 葯
	0x8479, KANJI_SJIS_L2,  // 葹
	0x8435, KANJI_SJIS_L2,  // 萵
	0x84CA, KANJI_SJIS_L2,  // 蓊
	0x8462, KANJI_SJIS_L2,  // 葢
	0x84B9, KANJI_SJIS_L2,  // 蒹
	0x84BF, KANJI_SJIS_L2,  // 蒿
	0x849F, KANJI_SJIS_L2,  // 蒟
	0x84D9, KANJI_SJIS_L2,  // 蓙
	0x84CD, KANJI_SJIS_L2,  // 蓍
	0x84BB, KANJI_SJIS_L2,  // 蒻
	0x84DA, KANJI_SJIS_L2,  // 蓚
	0x84D0, KANJI_SJIS_L2,  // 蓐
	0x84C1, KANJI_SJIS_L2,  // 蓁
	0x84C6, KANJI_SJIS_L2,  // 蓆
	0x84D6, KANJI_SJIS_L2,  // 蓖
	0x84A1, KANJI_SJIS_L2,  // 蒡
	0x8521, KANJI_SJIS_L2,  // 蔡
	0x84FF, KANJI_SJIS_L2,  // 蓿
	0x84F4, KANJI_SJIS_L2,  // 蓴
	0x8517, KANJI_SJIS_L2,  // 蔗
	0x8518, KANJI_SJIS_L2,  // 蔘
	0x852C, KANJI_SJIS_L2,  // 蔬
	0x851F, KANJI_SJIS_L2,  // 蔟
	0x8515, KANJI_SJIS_L2,  // 蔕
	0x8514, KANJI_SJIS_L2,  // 蔔
	0x84FC, KANJI_SJIS_L2,  // 蓼
	0x8540, KANJI_SJIS_L2,  // 蕀
	0x8563, KANJI_SJIS_L2,  // 蕣
	0x8558, KANJI_SJIS_L2,  // 蕘
	0x8548, KANJI_SJIS_L2,  // 蕈
	0x8541, KANJI_SJIS_L2,  // 蕁
	0x8602, KANJI_SJIS_L2,  // 蘂
	0x854B, KANJI_SJIS_L2,  // 蕋
	0x8555, KANJI_SJIS_L2,  // 蕕
	0x8580, KANJI_SJIS_L2,  // 薀
	0x85A4, KANJI_SJIS_L2,  // 薤
	0x8588, KANJI_SJIS_L2,  // 薈
	0x8591, KANJI_SJIS_L2,  // 薑
	0x858A, KANJI_SJIS_L2,  // 薊
	0x85A8, KANJI_SJIS_L2,  // 薨
	0x856D, KANJI_SJIS_L2,  // 蕭
	0x8594, KANJI_SJIS_L2,  // 薔
	0x859B, KANJI_SJIS_L2,  // 薛
	0x85EA, KANJI_SJIS_L2,  // 藪
	0x8587, KANJI_SJIS_L2,  // 薇
	0x859C, KANJI_SJIS_L2,  // 薜
	0x8577, KANJI_SJIS_L2,  // 蕷
	0x857E, KANJI_SJIS_L2,  // 蕾
	0x8590, KANJI_SJIS_L2,  // 薐
	0x85C9, KANJI_SJIS_L2,  // 藉
	0x85BA, KANJI_SJIS_L2,  // 薺
	0x85CF, KANJI_SJIS_L2,  // 藏
	0x85B9, KANJI_SJIS_L2,  // 薹
	0x85D0, KANJI_SJIS_L2,  // 藐
	0x85D5, KANJI_SJIS_L2,  // 藕
	0x85DD, KANJI_SJIS_L2,  // 藝
	0x85E5, KANJI_SJIS_L2,  // 藥
	0x85DC, KANJI_SJIS_L2,  // 藜
	0x85F9, KANJI_SJIS_L2,  // 藹
	0x860A, KANJI_SJIS_L2,  // 蘊
	0x8613, KANJI_SJIS_L2,  // 蘓
	0x860B, KANJI_SJIS_L2,  // 蘋
	0x85FE, KANJI_SJIS_L2,  // 藾
	0x85FA, KANJI_SJIS_L2,  // 藺
	0x8606, KANJI_SJIS_L2,  // 蘆
	0x8622, KANJI_SJIS_L2,  // 蘢
	0x861A, KANJI_SJIS_L2,  // 蘚
	0x8630, KANJI_SJIS_L2,  // 蘰
	0x863F, KANJI_SJIS_L2,  // 蘿
	0x864D, KANJI_SJIS_L2,  // 虍
	0x4E55, KANJI_SJIS_L2,  // 乕
	0x8654, KANJI_SJIS_L2,  // 虔
	0x865F, KANJI_SJIS_L2,  // 號
	0x8667, KANJI_SJIS_L2,  // 虧
	0x8671, KANJI_SJIS_L2,  // 虱
	0x8693, KANJI_SJIS_L2,  // 蚓
	0x86A3, KANJI_SJIS_L2,  // 蚣
	0x86A9, KANJI_SJIS_L2,  // 蚩
	0x86AA, KANJI_SJIS_L2,  // 蚪
	0x868B, KANJI_SJIS_L2,  // 蚋
	0x868C, KANJI_SJIS_L2,  // 蚌
	0x86B6, KANJI_SJIS_L2,  // 蚶
	0x86AF, KANJI_SJIS_L2,  // 蚯
	0x86C4, KANJI_SJIS_L2,  // 蛄
	0x86C6, KANJI_SJIS_L2,  // 蛆
	0x86B0, KANJI_SJIS_L2,  // 蚰
	0x86C9, KANJI_SJIS_L2,  // 蛉
	0x8823, KANJI_SJIS_L2,  // 蠣
	0x86AB, KANJI_SJIS_L2,  // 蚫
	0x86D4, KANJI_SJIS_L2,  // 蛔
	0x86DE, KANJI_SJIS_L2,  // 蛞
	0x86E9, KANJI_SJIS_L2,  // 蛩
	0x86EC, KANJI_SJIS_L2,  // 蛬
	0x3000, KANJI_SJIS_L2,  // 　
	0x86DF, KANJI_SJIS_L2,  // 蛟
	0x86DB, KANJI_SJIS_L2,  // 蛛
	0x86EF, KANJI_SJIS_L2,  // 蛯
	0x8712, KANJI_SJIS_L2,  // 蜒
	0x8706, KANJI_SJIS_L2,  // 蜆
	0x8708, KANJI_SJIS_L2,  // 蜈
	0x8700, KANJI_SJIS_L2,  // 蜀
	0x8703, KANJI_SJIS_L2,  // 蜃
	0x86FB, KANJI_SJIS_L2,  // 蛻
	0x8711, KANJI_SJIS_L2,  // 蜑
	0x8709, KANJI_SJIS_L2,  // 蜉
	0x870D, KANJI_SJIS_L2,  // 蜍
	0x86F9, KANJI_SJIS_L2,  // 蛹
	0x870A, KANJI_SJIS_L2,  // 蜊
	0x8734, KANJI_SJIS_L2,  // 蜴
	0x873F, KANJI_SJIS_L2,  // 蜿
	0x8737, KANJI_SJIS_L2,  // 蜷
	0x873B, KANJI_SJIS_L2,  // 蜻
	0x8725, KANJI_SJIS_L2,  // 蜥
	0x8729, KANJI_SJIS_L2,  // 蜩
	0x871A, KANJI_SJIS_L2,  // 蜚
	0x8760, KANJI_SJIS_L2,  // 蝠
	0x875F, KANJI_SJIS_L2,  // 蝟
	0x8778, KANJI_SJIS_L2,  // 蝸
	0x874C, KANJI_SJIS_L2,  // 蝌
	0x874E, KANJI_SJIS_L2,  // 蝎
	0x8774, KANJI_SJIS_L2,  // 蝴
	0x8757, KANJI_SJIS_L2,  // 蝗
	0x8768, KANJI_SJIS_L2,  // 蝨
	0x876E, KANJI_SJIS_L2,  // 蝮
	0x8759, KANJI_SJIS_L2,  // 蝙
	0x8753, KANJI_SJIS_L2,  // 蝓
	0x8763, KANJI_SJIS_L2,  // 蝣
	0x876A, KANJI_SJIS_L2,  // 蝪
	0x8805, KANJI_SJIS_L2,  // 蠅
	0x87A2, KANJI_SJIS_L2,  // 螢
	0x879F, KANJI_SJIS_L2,  // 螟
	0x8782, KANJI_SJIS_L2,  // 螂
	0x87AF, KANJI_SJIS_L2,  // 螯
	0x87CB, KANJI_SJIS_L2,  // 蟋
	0x87BD, KANJI_SJIS_L2,  // 螽
	0x87C0, KANJI_SJIS_L2,  // 蟀
	0x87D0, KANJI_SJIS_L2,  // 蟐
	0x96D6, KANJI_SJIS_L2,  // 雖
	0x87AB, KANJI_SJIS_L2,  // 螫
	0x87C4, KANJI_SJIS_L2,  // 蟄
	0x87B3, KANJI_SJIS_L2,  // 螳
	0x87C7, KANJI_SJIS_L2,  // 蟇
	0x87C6, KANJI_SJIS_L2,  // 蟆
	0x87BB, KANJI_SJIS_L2,  // 螻
	0x87EF, KANJI_SJIS_L2,  // 蟯
	0x87F2, KANJI_SJIS_L2,  // 蟲
	0x87E0, KANJI_SJIS_L2,  // 蟠
	0x880F, KANJI_SJIS_L2,  // 蠏
	0x880D, KANJI_SJIS_L2,  // 蠍
	0x87FE, KANJI_SJIS_L2,  // 蟾
	0x87F6, KANJI_SJIS_L2,  // 蟶
	0x87F7, KANJI_SJIS_L2,  // 蟷
	0x880E, KANJI_SJIS_L2,  // 蠎
	0x87D2, KANJI_SJIS_L2,  // 蟒
	0x8811, KANJI_SJIS_L2,  // 蠑
	0x8816, KANJI_SJIS_L2,  // 蠖
	0x8815, KANJI_SJIS_L2,  // 蠕
	0x8822, KANJI_SJIS_L2,  // 蠢
	0x8821, KANJI_SJIS_L2,  // 蠡
	0x8831, KANJI_SJIS_L2,  // 蠱
	0x8836, KANJI_SJIS_L2,  // 蠶
	0x8839, KANJI_SJIS_L2,  // 蠹
	0x8827, KANJI_SJIS_L2,  // 蠧
	0x883B, KANJI_SJIS_L2,  // 蠻
	0x8844, KANJI_SJIS_L2,  // 衄
	0x8842, KANJI_SJIS_L2,  // 衂
	0x8852, KANJI_SJIS_L2,  // 衒
	0x8859, KANJI_SJIS_L2,  // 衙
	0x885E, KANJI_SJIS_L2,  // 衞
	0x8862, KANJI_SJIS_L2,  // 衢
	0x886B, KANJI_SJIS_L2,  // 衫
	0x8881, KANJI_SJIS_L2,  // 袁
	0x887E, KANJI_SJIS_L2,  // 衾
	0x889E, KANJI_SJIS_L2,  // 袞
	0x8875, KANJI_SJIS_L2,  // 衵
	0x887D, KANJI_SJIS_L2,  // 衽
	0x88B5, KANJI_SJIS_L2,  // 袵
	0x8872, KANJI_SJIS_L2,  // 衲
	0x8882, KANJI_SJIS_L2,  // 袂
	0x8897, KANJI_SJIS_L2,  // 袗
	0x8892, KANJI_SJIS_L2,  // 袒
	0x88AE, KANJI_SJIS_L2,  // 袮
	0x8899, KANJI_SJIS_L2,  // 袙
	0x88A2, KANJI_SJIS_L2,  // 袢
	0x888D, KANJI_SJIS_L2,  // 袍
	0x88A4, KANJI_SJIS_L2,  // 袤
	0x88B0, KANJI_SJIS_L2,  // 袰
	0x88BF, KANJI_SJIS_L2,  // 袿
	0x88B1, KANJI_SJIS_L2,  // 袱
	0x88C3, KANJI_SJIS_L2,  // 裃
	0x88C4, KANJI_SJIS_L2,  // 裄
	0x88D4, KANJI_SJIS_L2,  // 裔
	0x88D8, KANJI_SJIS_L2,  // 裘
	0x88D9, KANJI_SJIS_L2,  // 裙
	0x88DD, KANJI_SJIS_L2,  // 裝
	0x88F9, KANJI_SJIS_L2,  // 裹
	0x8902, KANJI_SJIS_L2,  // 褂
	0x88FC, KANJI_SJIS_L2,  // 裼
	0x88F4, KANJI_SJIS_L2,  // 裴
	0x88E8, KANJI_SJIS_L2,  // 裨
	0x88F2, KANJI_SJIS_L2,  // 裲
	0x8904, KANJI_SJIS_L2,  // 褄
	0x890C, KANJI_SJIS_L2,  // 褌
	0x890A, KANJI_SJIS_L2,  // 褊
	0x8913, KANJI_SJIS_L2,  // 褓
	0x8943, KANJI_SJIS_L2,  // 襃
	0x891E, KANJI_SJIS_L2,  // 褞
	0x8925, KANJI_SJIS_L2,  // 褥
	0x892A, KANJI_SJIS_L2,  // 褪
	0x892B, KANJI_SJIS_L2,  // 褫
	0x8941, KANJI_SJIS_L2,  // 襁
	0x8944, KANJI_SJIS_L2,  // 襄
	0x893B, KANJI_SJIS_L2,  // 褻
	0x8936, KANJI_SJIS_L2,  // 褶
	0x8938, KANJI_SJIS_L2,  // 褸
	0x894C, KANJI_SJIS_L2,  // 襌
	0x891D, KANJI_SJIS_L2,  // 褝
	0x8960, KANJI_SJIS_L2,  // 襠
	0x895E, KANJI_SJIS_L2,  // 襞
	0x8966, KANJI_SJIS_L2,  // 襦
	0x8964, KANJI_SJIS_L2,  // 襤
	0x896D, KANJI_SJIS_L2,  // 襭
	0x896A, KANJI_SJIS_L2,  // 襪
	0x896F, KANJI_SJIS_L2,  // 襯
	0x8974, KANJI_SJIS_L2,  // 襴
	0x8977, KANJI_SJIS_L2,  // 襷
	0x897E, KANJI_SJIS_L2,  // 襾
	0x8983, KANJI_SJIS_L2,  // 覃
	0x8988, KANJI_SJIS_L2,  // 覈
	0x898A, KANJI_SJIS_L2,  // 覊
	0x8993, KANJI_SJIS_L2,  // 覓
	0x8998, KANJI_SJIS_L2,  // 覘
	0x89A1, KANJI_SJIS_L2,  // 覡
	0x89A9, KANJI_SJIS_L2,  // 覩
	0x89A6, KANJI_SJIS_L2,  // 覦
	0x89AC, KANJI_SJIS_L2,  // 覬
	0x89AF, KANJI_SJIS_L2,  // 覯
	0x89B2, KANJI_SJIS_L2,  // 覲
	0x89BA, KANJI_SJIS_L2,  // 覺
	0x89BD, KANJI_SJIS_L2,  // 覽
	0x89BF, KANJI_SJIS_L2,  // 覿
	0x89C0, KANJI_SJIS_L2,  // 觀
	0x89DA, KANJI_SJIS_L2,  // 觚
	0x89DC, KANJI_SJIS_L2,  // 觜
	0x89DD, KANJI_SJIS_L2,  // 觝
	0x89E7, KANJI_SJIS_L2,  // 觧
	0x89F4, KANJI_SJIS_L2,  // 觴
	0x89F8, KANJI_SJIS_L2,  // 觸
	0x8A03, KANJI_SJIS_L2,  // 訃
	0x8A16, KANJI_SJIS_L2,  // 訖
	0x8A10, KANJI_SJIS_L2,  // 訐
	0x8A0C, KANJI_SJIS_L2,  // 訌
	0x8A1B, KANJI_SJIS_L2,  // 訛
	0x8A1D, KANJI_SJIS_L2,  // 訝
	0x8A25, KANJI_SJIS_L2,  // 訥
	0x8A36, KANJI_SJIS_L2,  // 訶
	0x8A41, KANJI_SJIS_L2,  // 詁
	0x8A5B, KANJI_SJIS_L2,  // 詛
	0x8A52, KANJI_SJIS_L2,  // 詒
	0x8A46, KANJI_SJIS_L2,  // 詆
	0x8A48, KANJI_SJIS_L2,  // 詈
	0x8A7C, KANJI_SJIS_L2,  // 詼
	0x8A6D, KANJI_SJIS_L2,  // 詭
	0x8A6C, KANJI_SJIS_L2,  // 詬
	0x8A62, KANJI_SJIS_L2,  // 詢
	0x8A85, KANJI_SJIS_L2,  // 誅
	0x8A82, KANJI_SJIS_L2,  // 誂
	0x8A84, KANJI_SJIS_L2,  // 誄
	0x8AA8, KANJI_SJIS_L2,  // 誨
	0x8AA1, KANJI_SJIS_L2,  // 誡
	0x8A91, KANJI_SJIS_L2,  // 誑
	0x8AA5, KANJI_SJIS_L2,  // 誥
	0x8AA6, KANJI_SJIS_L2,  // 誦
	0x8A9A, KANJI_SJIS_L2,  // 誚
	0x8AA3, KANJI_SJIS_L2,  // 誣
	0x8AC4, KANJI_SJIS_L2,  // 諄
	0x8ACD, KANJI_SJIS_L2,  // 諍
	0x8AC2, KANJI_SJIS_L2,  // 諂
	0x8ADA, KANJI_SJIS_L2,  // 諚
	0x8AEB, KANJI_SJIS_L2,  // 諫
	0x8AF3, KANJI_SJIS_L2,  // 諳
	0x8AE7, KANJI_SJIS_L2,  // 諧
	0x3000, KANJI_SJIS_L2,  // 　
	0x8AE4, KANJI_SJIS_L2,  // 諤
	0x8AF1, KANJI_SJIS_L2,  // 諱
	0x8B14, KANJI_SJIS_L2,  // 謔
	0x8AE0, KANJI_SJIS_L2,  // 諠
	0x8AE2, KANJI_SJIS_L2,  // 諢
	0x8AF7, KANJI_SJIS_L2,  // 諷
	0x8ADE, KANJI_SJIS_L2,  // 諞
	0x8ADB, KANJI_SJIS_L2,  // 諛
	0x8B0C, KANJI_SJIS_L2,  // 謌
	0x8B07, KANJI_SJIS_L2,  // 謇
	0x8B1A, KANJI_SJIS_L2,  // 謚
	0x8AE1, KANJI_SJIS_L2,  // 諡
	0x8B16, KANJI_SJIS_L2,  // 謖
	0x8B10, KANJI_SJIS_L2,  // 謐
	0x8B17, KANJI_SJIS_L2,  // 謗
	0x8B20, KANJI_SJIS_L2,  // 謠
	0x8B33, KANJI_SJIS_L2,  // 謳
	0x97AB, KANJI_SJIS_L2,  // 鞫
	0x8B26, KANJI_SJIS_L2,  // 謦
	0x8B2B, KANJI_SJIS_L2,  // 謫
	0x8B3E, KANJI_SJIS_L2,  // 謾
	0x8B28, KANJI_SJIS_L2,  // 謨
	0x8B41, KANJI_SJIS_L2,  // 譁
	0x8B4C, KANJI_SJIS_L2,  // 譌
	0x8B4F, KANJI_SJIS_L2,  // 譏
	0x8B4E, KANJI_SJIS_L2,  // 譎
	0x8B49, KANJI_SJIS_L2,  // 證
	0x8B56, KANJI_SJIS_L2,  // 譖
	0x8B5B, KANJI_SJIS_L2,  // 譛
	0x8B5A, KANJI_SJIS_L2,  // 譚
	0x8B6B, KANJI_SJIS_L2,  // 譫
	0x8B5F, KANJI_SJIS_L2,  // 譟
	0x8B6C, KANJI_SJIS_L2,  // 譬
	0x8B6F, KANJI_SJIS_L2,  // 譯
	0x8B74, KANJI_SJIS_L2,  // 譴
	0x8B7D, KANJI_SJIS_L2,  // 譽
	0x8B80, KANJI_SJIS_L2,  // 讀
	0x8B8C, KANJI_SJIS_L2,  // 讌
	0x8B8E, KANJI_SJIS_L2,  // 讎
	0x8B92, KANJI_SJIS_L2,  // 讒
	0x8B93, KANJI_SJIS_L2,  // 讓
	0x8B96, KANJI_SJIS_L2,  // 讖
	0x8B99, KANJI_SJIS_L2,  // 讙
	0x8B9A, KANJI_SJIS_L2,  // 讚
	0x8C3A, KANJI_SJIS_L2,  // 谺
	0x8C41, KANJI_SJIS_L2,  // 豁
	0x8C3F, KANJI_SJIS_L2,  // 谿
	0x8C48, KANJI_SJIS_L2,  // 豈
	0x8C4C, KANJI_SJIS_L2,  // 豌
	0x8C4E, KANJI_SJIS_L2,  // 豎
	0x8C50, KANJI_SJIS_L2,  // 豐
	0x8C55, KANJI_SJIS_L2,  // 豕
	0x8C62, KANJI_SJIS_L2,  // 豢
	0x8C6C, KANJI_SJIS_L2,  // 豬
	0x8C78, KANJI_SJIS_L2,  // 豸
	0x8C7A, KANJI_SJIS_L2,  // 豺
	0x8C82, KANJI_SJIS_L2,  // 貂
	0x8C89, KANJI_SJIS_L2,  // 貉
	0x8C85, KANJI_SJIS_L2,  // 貅
	0x8C8A, KANJI_SJIS_L2,  // 貊
	0x8C8D, KANJI_SJIS_L2,  // 貍
	0x8C8E, KANJI_SJIS_L2,  // 貎
	0x8C94, KANJI_SJIS_L2,  // 貔
	0x8C7C, KANJI_SJIS_L2,  // 豼
	0x8C98, KANJI_SJIS_L2,  // 貘
	0x621D, KANJI_SJIS_L2,  // 戝
	0x8CAD, KANJI_SJIS_L2,  // 貭
	0x8CAA, KANJI_SJIS_L2,  // 貪
	0x8CBD, KANJI_SJIS_L2,  // 貽
	0x8CB2, KANJI_SJIS_L2,  // 貲
	0x8CB3, KANJI_SJIS_L2,  // 貳
	0x8CAE, KANJI_SJIS_L2,  // 貮
	0x8CB6, KANJI_SJIS_L2,  // 貶
	0x8CC8, KANJI_SJIS_L2,  // 賈
	0x8CC1, KANJI_SJIS_L2,  // 賁
	0x8CE4, KANJI_SJIS_L2,  // 賤
	0x8CE3, KANJI_SJIS_L2,  // 賣
	0x8CDA, KANJI_SJIS_L2,  // 賚
	0x8CFD, KANJI_SJIS_L2,  // 賽
	0x8CFA, KANJI_SJIS_L2,  // 賺
	0x8CFB, KANJI_SJIS_L2,  // 賻
	0x8D04, KANJI_SJIS_L2,  // 贄
	0x8D05, KANJI_SJIS_L2,  // 贅
	0x8D0A, KANJI_SJIS_L2,  // 贊
	0x8D07, KANJI_SJIS_L2,  // 贇
	0x8D0F, KANJI_SJIS_L2,  // 贏
	0x8D0D, KANJI_SJIS_L2,  // 贍
	0x8D10, KANJI_SJIS_L2,  // 贐
	0x9F4E, KANJI_SJIS_L2,  // 齎
	0x8D13, KANJI_SJIS_L2,  // 贓
	0x8CCD, KANJI_SJIS_L2,  // 賍
	0x8D14, KANJI_SJIS_L2,  // 贔
	0x8D16, KANJI_SJIS_L2,  // 贖
	0x8D67, KANJI_SJIS_L2,  // 赧
	0x8D6D, KANJI_SJIS_L2,  // 赭
	0x8D71, KANJI_SJIS_L2,  // 赱
	0x8D73, KANJI_SJIS_L2,  // 赳
	0x8D81, KANJI_SJIS_L2,  // 趁
	0x8D99, KANJI_SJIS_L2,  // 趙
	0x8DC2, KANJI_SJIS_L2,  // 跂
	0x8DBE, KANJI_SJIS_L2,  // 趾
	0x8DBA, KANJI_SJIS_L2,  // 趺
	0x8DCF, KANJI_SJIS_L2,  // 跏
	0x8DDA, KANJI_SJIS_L2,  // 跚
	0x8DD6, KANJI_SJIS_L2,  // 跖
	0x8DCC, KANJI_SJIS_L2,  // 跌
	0x8DDB, KANJI_SJIS_L2,  // 跛
	0x8DCB, KANJI_SJIS_L2,  // 跋
	0x8DEA, KANJI_SJIS_L2,  // 跪
	0x8DEB, KANJI_SJIS_L2,  // 跫
	0x8DDF, KANJI_SJIS_L2,  // 跟
	0x8DE3, KANJI_SJIS_L2,  // 跣
	0x8DFC, KANJI_SJIS_L2,  // 跼
	0x8E08, KANJI_SJIS_L2,  // 踈
	0x8E09, KANJI_SJIS_L2,  // 踉
	0x8DFF, KANJI_SJIS_L2,  // 跿
	0x8E1D, KANJI_SJIS_L2,  // 踝
	0x8E1E, KANJI_SJIS_L2,  // 踞
	0x8E10, KANJI_SJIS_L2,  // 踐
	0x8E1F, KANJI_SJIS_L2,  // 踟
	0x8E42, KANJI_SJIS_L2,  // 蹂
	0x8E35, KANJI_SJIS_L2,  // 踵
	0x8E30, KANJI_SJIS_L2,  // 踰
	0x8E34, KANJI_SJIS_L2,  // 踴
	0x8E4A, KANJI_SJIS_L2,  // 蹊
	0x8E47, KANJI_SJIS_L2,  // 蹇
	0x8E49, KANJI_SJIS_L2,  // 蹉
	0x8E4C, KANJI_SJIS_L2,  // 蹌
	0x8E50, KANJI_SJIS_L2,  // 蹐
	0x8E48, KANJI_SJIS_L2,  // 蹈
	0x8E59, KANJI_SJIS_L2,  // 蹙
	0x8E64, KANJI_SJIS_L2,  // 蹤
	0x8E60, KANJI_SJIS_L2,  // 蹠
	0x8E2A, KANJI_SJIS_L2,  // 踪
	0x8E63, KANJI_SJIS_L2,  // 蹣
	0x8E55, KANJI_SJIS_L2,  // 蹕
	0x8E76, KANJI_SJIS_L2,  // 蹶
	0x8E72, KANJI_SJIS_L2,  // 蹲
	0x8E7C, KANJI_SJIS_L2,  // 蹼
	0x8E81, KANJI_SJIS_L2,  // 躁
	0x8E87, KANJI_SJIS_L2,  // 躇
	0x8E85, KANJI_SJIS_L2,  // 躅
	0x8E84, KANJI_SJIS_L2,  // 躄
	0x8E8B, KANJI_SJIS_L2,  // 躋
	0x8E8A, KANJI_SJIS_L2,  // 躊
	0x8E93, KANJI_SJIS_L2,  // 躓
	0x8E91, KANJI_SJIS_L2,  // 躑
	0x8E94, KANJI_SJIS_L2,  // 躔
	0x8E99, KANJI_SJIS_L2,  // 躙
	0x8EAA, KANJI_SJIS_L2,  // 躪
	0x8EA1, KANJI_SJIS_L2,  // 躡
	0x8EAC, KANJI_SJIS_L2,  // 躬
	0x8EB0, KANJI_SJIS_L2,  // 躰
	0x8EC6, KANJI_SJIS_L2,  // 軆
	0x8EB1, KANJI_SJIS_L2,  // 躱
	0x8EBE, KANJI_SJIS_L2,  // 躾
	0x8EC5, KANJI_SJIS_L2,  // 軅
	0x8EC8, KANJI_SJIS_L2,  // 軈
	0x8ECB, KANJI_SJIS_L2,  // 軋
	0x8EDB, KANJI_SJIS_L2,  // 軛
	0x8EE3, KANJI_SJIS_L2,  // 軣
	0x8EFC, KANJI_SJIS_L2,  // 軼
	0x8EFB, KANJI_SJIS_L2,  // 軻
	0x8EEB, KANJI_SJIS_L2,  // 軫
	0x8EFE, KANJI_SJIS_L2,  // 軾
	0x8F0A, KANJI_SJIS_L2,  // 輊
	0x8F05, KANJI_SJIS_L2,  // 輅
	0x8F15, KANJI_SJIS_L2,  // 輕
	0x8F12, KANJI_SJIS_L2,  // 輒
	0x8F19, KANJI_SJIS_L2,  // 輙
	0x8F13, KANJI_SJIS_L2,  // 輓
	0x8F1C, KANJI_SJIS_L2,  // 輜
	0x8F1F, KANJI_SJIS_L2,  // 輟
	0x8F1B, KANJI_SJIS_L2,  // 輛
	0x8F0C, KANJI_SJIS_L2,  // 輌
	0x8F26, KANJI_SJIS_L2,  // 輦
	0x8F33, KANJI_SJIS_L2,  // 輳
	0x8F3B, KANJI_SJIS_L2,  // 輻
	0x8F39, KANJI_SJIS_L2,  // 輹
	0x8F45, KANJI_SJIS_L2,  // 轅
	0x8F42, KANJI_SJIS_L2,  // 轂
	0x8F3E, KANJI_SJIS_L2,  // 輾
	0x8F4C, KANJI_SJIS_L2,  // 轌
	0x8F49, KANJI_SJIS_L2,  // 轉
	0x8F46, KANJI_SJIS_L2,  // 轆
	0x8F4E, KANJI_SJIS_L2,  // 轎
	0x8F57, KANJI_SJIS_L2,  // 轗
	0x8F5C, KANJI_SJIS_L2,  // 轜
	0x3000, KANJI_SJIS_L2,  // 　
	0x8F62, KANJI_SJIS_L2,  // 轢
	0x8F63, KANJI_SJIS_L2,  // 轣
	0x8F64, KANJI_SJIS_L2,  // 轤
	0x8F9C, KANJI_SJIS_L2,  // 辜
	0x8F9F, KANJI_SJIS_L2,  // 辟
	0x8FA3, KANJI_SJIS_L2,  // 辣
	0x8FAD, KANJI_SJIS_L2,  // 辭
	0x8FAF, KANJI_SJIS_L2,  // 辯
	0x8FB7, KANJI_SJIS_L2,  // 辷
	0x8FDA, KANJI_SJIS_L2,  // 迚
	0x8FE5, KANJI_SJIS_L2,  // 迥
	0x8FE2, KANJI_SJIS_L2,  // 迢
	0x8FEA, KANJI_SJIS_L2,  // 迪
	0x8FEF, KANJI_SJIS_L2,  // 迯
	0x9087, KANJI_SJIS_L2,  // 邇
	0x8FF4, KANJI_SJIS_L2,  // 迴
	0x9005, KANJI_SJIS_L2,  // 逅
	0x8FF9, KANJI_SJIS_L2,  // 迹
	0x8FFA, KANJI_SJIS_L2,  // 迺
	0x9011, KANJI_SJIS_L2,  // 逑
	0x9015, KANJI_SJIS_L2,  // 逕
	0x9021, KANJI_SJIS_L2,  // 逡
	0x900D, KANJI_SJIS_L2,  // 逍
	0x901E, KANJI_SJIS_L2,  // 逞
	0x9016, KANJI_SJIS_L2,  // 逖
	0x900B, KANJI_SJIS_L2,  // 逋
	0x9027, KANJI_SJIS_L2,  // 逧
	0x9036, KANJI_SJIS_L2,  // 逶
	0x9035, KANJI_SJIS_L2,  // 逵
	0x9039, KANJI_SJIS_L2,  // 逹
	0x8FF8, KANJI_SJIS_L2,  // 迸
	0x904F, KANJI_SJIS_L2,  // 遏
	0x9050, KANJI_SJIS_L2,  // 遐
	0x9051, KANJI_SJIS_L2,  // 遑
	0x9052, KANJI_SJIS_L2,  // 遒
	0x900E, KANJI_SJIS_L2,  // 逎
	0x9049, KANJI_SJIS_L2,  // 遉
	0x903E, KANJI_SJIS_L2,  // 逾
	0x9056, KANJI_SJIS_L2,  // 遖
	0x9058, KANJI_SJIS_L2,  // 遘
	0x905E, KANJI_SJIS_L2,  // 遞
	0x9068, KANJI_SJIS_L2,  // 遨
	0x906F, KANJI_SJIS_L2,  // 遯
	0x9076, KANJI_SJIS_L2,  // 遶
	0x96A8, KANJI_SJIS_L2,  // 隨
	0x9072, KANJI_SJIS_L2,  // 遲
	0x9082, KANJI_SJIS_L2,  // 邂
	0x907D, KANJI_SJIS_L2,  // 遽
	0x9081, KANJI_SJIS_L2,  // 邁
	0x9080, KANJI_SJIS_L2,  // 邀
	0x908A, KANJI_SJIS_L2,  // 邊
	0x9089, KANJI_SJIS_L2,  // 邉
	0x908F, KANJI_SJIS_L2,  // 邏
	0x90A8, KANJI_SJIS_L2,  // 邨
	0x90AF, KANJI_SJIS_L2,  // 邯
	0x90B1, KANJI_SJIS_L2,  // 邱
	0x90B5, KANJI_SJIS_L2,  // 邵
	0x90E2, KANJI_SJIS_L2,  // 郢
	0x90E4, KANJI_SJIS_L2,  // 郤
	0x6248, KANJI_SJIS_L2,  // 扈
	0x90DB, KANJI_SJIS_L2,  // 郛
	0x9102, KANJI_SJIS_L2,  // 鄂
	0x9112, KANJI_SJIS_L2,  // 鄒
	0x9119, KANJI_SJIS_L2,  // 鄙
	0x9132, KANJI_SJIS_L2,  // 鄲
	0x9130, KANJI_SJIS_L2,  // 鄰
	0x914A, KANJI_SJIS_L2,  // 酊
	0x9156, KANJI_SJIS_L2,  // 酖
	0x9158, KANJI_SJIS_L2,  // 酘
	0x9163, KANJI_SJIS_L2,  // 酣
	0x9165, KANJI_SJIS_L2,  // 酥
	0x9169, KANJI_SJIS_L2,  // 酩
	0x9173, KANJI_SJIS_L2,  // 酳
	0x9172, KANJI_SJIS_L2,  // 酲
	0x918B, KANJI_SJIS_L2,  // 醋
	0x9189, KANJI_SJIS_L2,  // 醉
	0x9182, KANJI_SJIS_L2,  // 醂
	0x91A2, KANJI_SJIS_L2,  // 醢
	0x91AB, KANJI_SJIS_L2,  // 醫
	0x91AF, KANJI_SJIS_L2,  // 醯
	0x91AA, KANJI_SJIS_L2,  // 醪
	0x91B5, KANJI_SJIS_L2,  // 醵
	0x91B4, KANJI_SJIS_L2,  // 醴
	0x91BA, KANJI_SJIS_L2,  // 醺
	0x91C0, KANJI_SJIS_L2,  // 釀
	0x91C1, KANJI_SJIS_L2,  // 釁
	0x91C9, KANJI_SJIS_L2,  // 釉
	0x91CB, KANJI_SJIS_L2,  // 釋
	0x91D0, KANJI_SJIS_L2,  // 釐
	0x91D6, KANJI_SJIS_L2,  // 釖
	0x91DF, KANJI_SJIS_L2,  // 釟
	0x91E1, KANJI_SJIS_L2,  // 釡
	0x91DB, KANJI_SJIS_L2,  // 釛
	0x91FC, KANJI_SJIS_L2,  // 釼
	0x91F5, KANJI_SJIS_L2,  // 釵
	0x91F6, KANJI_SJIS_L2,  // 釶
	0x921E, KANJI_SJIS_L2,  // 鈞
	0x91FF, KANJI_SJIS_L2,  // 釿
	0x9214, KANJI_SJIS_L2,  // 鈔
	0x922C, KANJI_SJIS_L2,  // 鈬
	0x9215, KANJI_SJIS_L2,  // 鈕
	0x9211, KANJI_SJIS_L2,  // 鈑
	0x925E, KANJI_SJIS_L2,  // 鉞
	0x9257, KANJI_SJIS_L2,  // 鉗
	0x9245, KANJI_SJIS_L2,  // 鉅
	0x9249, KANJI_SJIS_L2,  // 鉉
	0x9264, KANJI_SJIS_L2,  // 鉤
	0x9248, KANJI_SJIS_L2,  // 鉈
	0x9295, KANJI_SJIS_L2,  // 銕
	0x923F, KANJI_SJIS_L2,  // 鈿
	0x924B, KANJI_SJIS_L2,  // 鉋
	0x9250, KANJI_SJIS_L2,  // 鉐
	0x929C, KANJI_SJIS_L2,  // 銜
	0x9296, KANJI_SJIS_L2,  // 銖
	0x9293, KANJI_SJIS_L2,  // 銓
	0x929B, KANJI_SJIS_L2,  // 銛
	0x925A, KANJI_SJIS_L2,  // 鉚
	0x92CF, KANJI_SJIS_L2,  // 鋏
	0x92B9, KANJI_SJIS_L2,  // 銹
	0x92B7, KANJI_SJIS_L2,  // 銷
	0x92E9, KANJI_SJIS_L2,  // 鋩
	0x930F, KANJI_SJIS_L2,  // 錏
	0x92FA, KANJI_SJIS_L2,  // 鋺
	0x9344, KANJI_SJIS_L2,  // 鍄
	0x932E, KANJI_SJIS_L2,  // 錮
	0x9319, KANJI_SJIS_L2,  // 錙
	0x9322, KANJI_SJIS_L2,  // 錢
	0x931A, KANJI_SJIS_L2,  // 錚
	0x9323, KANJI_SJIS_L2,  // 錣
	0x933A, KANJI_SJIS_L2,  // 錺
	0x9335, KANJI_SJIS_L2,  // 錵
	0x933B, KANJI_SJIS_L2,  // 錻
	0x935C, KANJI_SJIS_L2,  // 鍜
	0x9360, KANJI_SJIS_L2,  // 鍠
	0x937C, KANJI_SJIS_L2,  // 鍼
	0x936E, KANJI_SJIS_L2,  // 鍮
	0x9356, KANJI_SJIS_L2,  // 鍖
	0x93B0, KANJI_SJIS_L2,  // 鎰
	0x93AC, KANJI_SJIS_L2,  // 鎬
	0x93AD, KANJI_SJIS_L2,  // 鎭
	0x9394, KANJI_SJIS_L2,  // 鎔
	0x93B9, KANJI_SJIS_L2,  // 鎹
	0x93D6, KANJI_SJIS_L2,  // 鏖
	0x93D7, KANJI_SJIS_L2,  // 鏗
	0x93E8, KANJI_SJIS_L2,  // 鏨
	0x93E5, KANJI_SJIS_L2,  // 鏥
	0x93D8, KANJI_SJIS_L2,  // 鏘
	0x93C3, KANJI_SJIS_L2,  // 鏃
	0x93DD, KANJI_SJIS_L2,  // 鏝
	0x93D0, KANJI_SJIS_L2,  // 鏐
	0x93C8, KANJI_SJIS_L2,  // 鏈
	0x93E4, KANJI_SJIS_L2,  // 鏤
	0x941A, KANJI_SJIS_L2,  // 鐚
	0x9414, KANJI_SJIS_L2,  // 鐔
	0x9413, KANJI_SJIS_L2,  // 鐓
	0x9403, KANJI_SJIS_L2,  // 鐃
	0x9407, KANJI_SJIS_L2,  // 鐇
	0x9410, KANJI_SJIS_L2,  // 鐐
	0x9436, KANJI_SJIS_L2,  // 鐶
	0x942B, KANJI_SJIS_L2,  // 鐫
	0x9435, KANJI_SJIS_L2,  // 鐵
	0x9421, KANJI_SJIS_L2,  // 鐡
	0x943A, KANJI_SJIS_L2,  // 鐺
	0x9441, KANJI_SJIS_L2,  // 鑁
	0x9452, KANJI_SJIS_L2,  // 鑒
	0x9444, KANJI_SJIS_L2,  // 鑄
	0x945B, KANJI_SJIS_L2,  // 鑛
	0x9460, KANJI_SJIS_L2,  // 鑠
	0x9462, KANJI_SJIS_L2,  // 鑢
	0x945E, KANJI_SJIS_L2,  // 鑞
	0x946A, KANJI_SJIS_L2,  // 鑪
	0x9229, KANJI_SJIS_L2,  // 鈩
	0x9470, KANJI_SJIS_L2,  // 鑰
	0x9475, KANJI_SJIS_L2,  // 鑵
	0x9477, KANJI_SJIS_L2,  // 鑷
	0x947D, KANJI_SJIS_L2,  // 鑽
	0x945A, KANJI_SJIS_L2,  // 鑚
	0x947C, KANJI_SJIS_L2,  // 鑼
	0x947E, KANJI_SJIS_L2,  // 鑾
	0x9481, KANJI_SJIS_L2,  // 钁
	0x947F, KANJI_SJIS_L2,  // 鑿
	0x9582, KANJI_SJIS_L2,  // 閂
	0x9587, KANJI_SJIS_L2,  // 閇
	0x958A, KANJI_SJIS_L2,  // 閊
	0x9594, KANJI_SJIS_L2,  // 閔
	0x9596, KANJI_SJIS_L2,  // 閖
	0x9598, KANJI_SJIS_L2,  // 閘
	0x9599, KANJI_SJIS_L2,  // 閙
	0x3000, KANJI_SJIS_L2,  // 　
	0x95A0, KANJI_SJIS_L2,  // 閠
	0x95A8, KANJI_SJIS_L2,  // 閨
	0x95A7, KANJI_SJIS_L2,  // 閧
	0x95AD, KANJI_SJIS_L2,  // 閭
	0x95BC, KANJI_SJIS_L2,  // 閼
	0x95BB, KANJI_SJIS_L2,  // 閻
	0x95B9, KANJI_SJIS_L2,  // 閹
	0x95BE, KANJI_SJIS_L2,  // 閾
	0x95CA, KANJI_SJIS_L2,  // 闊
	0x6FF6, KANJI_SJIS_L2,  // 濶
	0x95C3, KANJI_SJIS_L2,  // 闃
	0x95CD, KANJI_SJIS_L2,  // 闍
	0x95CC, KANJI_SJIS_L2,  // 闌
	0x95D5, KANJI_SJIS_L2,  // 闕
	0x95D4, KANJI_SJIS_L2,  // 闔
	0x95D6, KANJI_SJIS_L2,  // 闖
	0x95DC, KANJI_SJIS_L2,  // 關
	0x95E1, KANJI_SJIS_L2,  // 闡
	0x95E5, KANJI_SJIS_L2,  // 闥
	0x95E2, KANJI_SJIS_L2,  // 闢
	0x9621, KANJI_SJIS_L2,  // 阡
	0x9628, KANJI_SJIS_L2,  // 阨
	0x962E, KANJI_SJIS_L2,  // 阮
	0x962F, KANJI_SJIS_L2,  // 阯
	0x9642, KANJI_SJIS_L2,  // 陂
	0x964C, KANJI_SJIS_L2,  // 陌
	0x964F, KANJI_SJIS_L2,  // 陏
	0x964B, KANJI_SJIS_L2,  // 陋
	0x9677, KANJI_SJIS_L2,  // 陷
	0x965C, KANJI_SJIS_L2,  // 陜
	0x965E, KANJI_SJIS_L2,  // 陞
	0x965D, KANJI_SJIS_L2,  // 陝
	0x965F, KANJI_SJIS_L2,  // 陟
	0x9666, KANJI_SJIS_L2,  // 陦
	0x9672, KANJI_SJIS_L2,  // 陲
	0x966C, KANJI_SJIS_L2,  // 陬
	0x968D, KANJI_SJIS_L2,  // 隍
	0x9698, KANJI_SJIS_L2,  // 隘
	0x9695, KANJI_SJIS_L2,  // 隕
	0x9697, KANJI_SJIS_L2,  // 隗
	0x96AA, KANJI_SJIS_L2,  // 險
	0x96A7, KANJI_SJIS_L2,  // 隧
	0x96B1, KANJI_SJIS_L2,  // 隱
	0x96B2, KANJI_SJIS_L2,  // 隲
	0x96B0, KANJI_SJIS_L2,  // 隰
	0x96B4, KANJI_SJIS_L2,  // 隴
	0x96B6, KANJI_SJIS_L2,  // 隶
	0x96B8, KANJI_SJIS_L2,  // 隸
	0x96B9, KANJI_SJIS_L2,  // 隹
	0x96CE, KANJI_SJIS_L2,  // 雎
	0x96CB, KANJI_SJIS_L2,  // 雋
	0x96C9, KANJI_SJIS_L2,  // 雉
	0x96CD, KANJI_SJIS_L2,  // 雍
	0x894D, KANJI_SJIS_L2,  // 襍
	0x96DC, KANJI_SJIS_L2,  // 雜
	0x970D, KANJI_SJIS_L2,  // 霍
	0x96D5, KANJI_SJIS_L2,  // 雕
	0x96F9, KANJI_SJIS_L2,  // 雹
	0x9704, KANJI_SJIS_L2,  // 霄
	0x9706, KANJI_SJIS_L2,  // 霆
	0x9708, KANJI_SJIS_L2,  // 霈
	0x9713, KANJI_SJIS_L2,  // 霓
	0x970E, KANJI_SJIS_L2,  // 霎
	0x9711, KANJI_SJIS_L2,  // 霑
	0x970F, KANJI_SJIS_L2,  // 霏
	0x9716, KANJI_SJIS_L2,  // 霖
	0x9719, KANJI_SJIS_L2,  // 霙
	0x9724, KANJI_SJIS_L2,  // 霤
	0x972A, KANJI_SJIS_L2,  // 霪
	0x9730, KANJI_SJIS_L2,  // 霰
	0x9739, KANJI_SJIS_L2,  // 霹
	0x973D, KANJI_SJIS_L2,  // 霽
	0x973E, KANJI_SJIS_L2,  // 霾
	0x9744, KANJI_SJIS_L2,  // 靄
	0x9746, KANJI_SJIS_L2,  // 靆
	0x9748, KANJI_SJIS_L2,  // 靈
	0x9742, KANJI_SJIS_L2,  // 靂
	0x9749, KANJI_SJIS_L2,  // 靉
	0x975C, KANJI_SJIS_L2,  // 靜
	0x9760, KANJI_SJIS_L2,  // 靠
	0x9764, KANJI_SJIS_L2,  // 靤
	0x9766, KANJI_SJIS_L2,  // 靦
	0x9768, KANJI_SJIS_L2,  // 靨
	0x52D2, KANJI_SJIS_L2,  // 勒
	0x976B, KANJI_SJIS_L2,  // 靫
	0x9771, KANJI_SJIS_L2,  // 靱
	0x9779, KANJI_SJIS_L2,  // 靹
	0x9785, KANJI_SJIS_L2,  // 鞅
	0x977C, KANJI_SJIS_L2,  // 靼
	0x9781, KANJI_SJIS_L2,  // 鞁
	0x977A, KANJI_SJIS_L2,  // 靺
	0x9786, KANJI_SJIS_L2,  // 鞆
	0x978B, KANJI_SJIS_L2,  // 鞋
	0x978F, KANJI_SJIS_L2,  // 鞏
	0x9790, KANJI_SJIS_L2,  // 鞐
	0x979C, KANJI_SJIS_L2,  // 鞜
	0x97A8, KANJI_SJIS_L2,  // 鞨
	0x97A6, KANJI_SJIS_L2,  // 鞦
	0x97A3, KANJI_SJIS_L2,  // 鞣
	0x97B3, KANJI_SJIS_L2,  // 鞳
	0x97B4, KANJI_SJIS_L2,  // 鞴
	0x97C3, KANJI_SJIS_L2,  // 韃
	0x97C6, KANJI_SJIS_L2,  // 韆
	0x97C8, KANJI_SJIS_L2,  // 韈
	0x97CB, KANJI_SJIS_L2,  // 韋
	0x97DC, KANJI_SJIS_L2,  // 韜
	0x97ED, KANJI_SJIS_L2,  // 韭
	0x9F4F, KANJI_SJIS_L2,  // 齏
	0x97F2, KANJI_SJIS_L2,  // 韲
	0x7ADF, KANJI_SJIS_L2,  // 竟
	0x97F6, KANJI_SJIS_L2,  // 韶
	0x97F5, KANJI_SJIS_L2,  // 韵
	0x980F, KANJI_SJIS_L2,  // 頏
	0x980C, KANJI_SJIS_L2,  // 頌
	0x9838, KANJI_SJIS_L2,  // 頸
	0x9824, KANJI_SJIS_L2,  // 頤
	0x9821, KANJI_SJIS_L2,  // 頡
	0x9837, KANJI_SJIS_L2,  // 頷
	0x983D, KANJI_SJIS_L2,  // 頽
	0x9846, KANJI_SJIS_L2,  // 顆
	0x984F, KANJI_SJIS_L2,  // 顏
	0x984B, KANJI_SJIS_L2,  // 顋
	0x986B, KANJI_SJIS_L2,  // 顫
	0x986F, KANJI_SJIS_L2,  // 顯
	0x9870, KANJI_SJIS_L2,  // 顰
	0x9871, KANJI_SJIS_L2,  // 顱
	0x9874, KANJI_SJIS_L2,  // 顴
	0x9873, KANJI_SJIS_L2,  // 顳
	0x98AA, KANJI_SJIS_L2,  // 颪
	0x98AF, KANJI_SJIS_L2,  // 颯
	0x98B1, KANJI_SJIS_L2,  // 颱
	0x98B6, KANJI_SJIS_L2,  // 颶
	0x98C4, KANJI_SJIS_L2,  // 飄
	0x98C3, KANJI_SJIS_L2,  // 飃
	0x98C6, KANJI_SJIS_L2,  // 飆
	0x98E9, KANJI_SJIS_L2,  // 飩
	0x98EB, KANJI_SJIS_L2,  // 飫
	0x9903, KANJI_SJIS_L2,  // 餃
	0x9909, KANJI_SJIS_L2,  // 餉
	0x9912, KANJI_SJIS_L2,  // 餒
	0x9914, KANJI_SJIS_L2,  // 餔
	0x9918, KANJI_SJIS_L2,  // 餘
	0x9921, KANJI_SJIS_L2,  // 餡
	0x991D, KANJI_SJIS_L2,  // 餝
	0x991E, KANJI_SJIS_L2,  // 餞
	0x9924, KANJI_SJIS_L2,  // 餤
	0x9920, KANJI_SJIS_L2,  // 餠
	0x992C, KANJI_SJIS_L2,  // 餬
	0x992E, KANJI_SJIS_L2,  // 餮
	0x993D, KANJI_SJIS_L2,  // 餽
	0x993E, KANJI_SJIS_L2,  // 餾
	0x9942, KANJI_SJIS_L2,  // 饂
	0x9949, KANJI_SJIS_L2,  // 饉
	0x9945, KANJI_SJIS_L2,  // 饅
	0x9950, KANJI_SJIS_L2,  // 饐
	0x994B, KANJI_SJIS_L2,  // 饋
	0x9951, KANJI_SJIS_L2,  // 饑
	0x9952, KANJI_SJIS_L2,  // 饒
	0x994C, KANJI_SJIS_L2,  // 饌
	0x9955, KANJI_SJIS_L2,  // 饕
	0x9997, KANJI_SJIS_L2,  // 馗
	0x9998, KANJI_SJIS_L2,  // 馘
	0x99A5, KANJI_SJIS_L2,  // 馥
	0x99AD, KANJI_SJIS_L2,  // 馭
	0x99AE, KANJI_SJIS_L2,  // 馮
	0x99BC, KANJI_SJIS_L2,  // 馼
	0x99DF, KANJI_SJIS_L2,  // 駟
	0x99DB, KANJI_SJIS_L2,  // 駛
	0x99DD, KANJI_SJIS_L2,  // 駝
	0x99D8, KANJI_SJIS_L2,  // 駘
	0x99D1, KANJI_SJIS_L2,  // 駑
	0x99ED, KANJI_SJIS_L2,  // 駭
	0x99EE, KANJI_SJIS_L2,  // 駮
	0x99F1, KANJI_SJIS_L2,  // 駱
	0x99F2, KANJI_SJIS_L2,  // 駲
	0x99FB, KANJI_SJIS_L2,  // 駻
	0x99F8, KANJI_SJIS_L2,  // 駸
	0x9A01, KANJI_SJIS_L2,  // 騁
	0x9A0F, KANJI_SJIS_L2,  // 騏
	0x9A05, KANJI_SJIS_L2,  // 騅
	0x99E2, KANJI_SJIS_L2,  // 駢
	0x9A19, KANJI_SJIS_L2,  // 騙
	0x9A2B, KANJI_SJIS_L2,  // 騫
	0x9A37, KANJI_SJIS_L2,  // 騷
	0x9A45, KANJI_SJIS_L2,  // 驅
	0x9A42, KANJI_SJIS_L2,  // 驂
	0x9A40, KANJI_SJIS_L2,  // 驀
	0x9A43, KANJI_SJIS_L2,  // 驃
	0x3000, KANJI_SJIS_L2,  // 　
	0x9A3E, KANJI_SJIS_L2,  // 騾
	0x9A55, KANJI_SJIS_L2,  // 驕
	0x9A4D, KANJI_SJIS_L2,  // 驍
	0x9A5B, KANJI_SJIS_L2,  // 驛
	0x9A57, KANJI_SJIS_L2,  // 驗
	0x9A5F, KANJI_SJIS_L2,  // 驟
	0x9A62, KANJI_SJIS_L2,  // 驢
	0x9A65, KANJI_SJIS_L2,  // 驥
	0x9A64, KANJI_SJIS_L2,  // 驤
	0x9A69, KANJI_SJIS_L2,  // 驩
	0x9A6B, KANJI_SJIS_L2,  // 驫
	0x9A6A, KANJI_SJIS_L2,  // 驪
	0x9AAD, KANJI_SJIS_L2,  // 骭
	0x9AB0, KANJI_SJIS_L2,  // 骰
	0x9ABC, KANJI_SJIS_L2,  // 骼
	0x9AC0, KANJI_SJIS_L2,  // 髀
	0x9ACF, KANJI_SJIS_L2,  // 髏
	0x9AD1, KANJI_SJIS_L2,  // 髑
	0x9AD3, KANJI_SJIS_L2,  // 髓
	0x9AD4, KANJI_SJIS_L2,  // 體
	0x9ADE, KANJI_SJIS_L2,  // 髞
	0x9ADF, KANJI_SJIS_L2,  // 髟
	0x9AE2, KANJI_SJIS_L2,  // 髢
	0x9AE3, KANJI_SJIS_L2,  // 髣
	0x9AE6, KANJI_SJIS_L2,  // 髦
	0x9AEF, KANJI_SJIS_L2,  // 髯
	0x9AEB, KANJI_SJIS_L2,  // 髫
	0x9AEE, KANJI_SJIS_L2,  // 髮
	0x9AF4, KANJI_SJIS_L2,  // 髴
	0x9AF1, KANJI_SJIS_L2,  // 髱
	0x9AF7, KANJI_SJIS_L2,  // 髷
	0x9AFB, KANJI_SJIS_L2,  // 髻
	0x9B06, KANJI_SJIS_L2,  // 鬆
	0x9B18, KANJI_SJIS_L2,  // 鬘
	0x9B1A, KANJI_SJIS_L2,  // 鬚
	0x9B1F, KANJI_SJIS_L2,  // 鬟
	0x9B22, KANJI_SJIS_L2,  // 鬢
	0x9B23, KANJI_SJIS_L2,  // 鬣
	0x9B25, KANJI_SJIS_L2,  // 鬥
	0x9B27, KANJI_SJIS_L2,  // 鬧
	0x9B28, KANJI_SJIS_L2,  // 鬨
	0x9B29, KANJI_SJIS_L2,  // 鬩
	0x9B2A, KANJI_SJIS_L2,  // 鬪
	0x9B2E, KANJI_SJIS_L2,  // 鬮
	0x9B2F, KANJI_SJIS_L2,  // 鬯
	0x9B32, KANJI_SJIS_L2,  // 鬲
	0x9B44, KANJI_SJIS_L2,  // 魄
	0x9B43, KANJI_SJIS_L2,  // 魃
	0x9B4F, KANJI_SJIS_L2,  // 魏
	0x9B4D, KANJI_SJIS_L2,  // 魍
	0x9B4E, KANJI_SJIS_L2,  // 魎
	0x9B51, KANJI_SJIS_L2,  // 魑
	0x9B58, KANJI_SJIS_L2,  // 魘
	0x9B74, KANJI_SJIS_L2,  // 魴
	0x9B93, KANJI_SJIS_L2,  // 鮓
	0x9B83, KANJI_SJIS_L2,  // 鮃
	0x9B91, KANJI_SJIS_L2,  // 鮑
	0x9B96, KANJI_SJIS_L2,  // 鮖
	0x9B97, KANJI_SJIS_L2,  // 鮗
	0x9B9F, KANJI_SJIS_L2,  // 鮟
	0x9BA0, KANJI_SJIS_L2,  // 鮠
	0x9BA8, KANJI_SJIS_L2,  // 鮨
	0x9BB4, KANJI_SJIS_L2,  // 鮴
	0x9BC0, KANJI_SJIS_L2,  // 鯀
	0x9BCA, KANJI_SJIS_L2,  // 鯊
	0x9BB9, KANJI_SJIS_L2,  // 鮹
	0x9BC6, KANJI_SJIS_L2,  // 鯆
	0x9BCF, KANJI_SJIS_L2,  // 鯏
	0x9BD1, KANJI_SJIS_L2,  // 鯑
	0x9BD2, KANJI_SJIS_L2,  // 鯒
	0x9BE3, KANJI_SJIS_L2,  // 鯣
	0x9BE2, KANJI_SJIS_L2,  // 鯢
	0x9BE4, KANJI_SJIS_L2,  // 鯤
	0x9BD4, KANJI_SJIS_L2,  // 鯔
	0x9BE1, KANJI_SJIS_L2,  // 鯡
	0x9C3A, KANJI_SJIS_L2,  // 鰺
	0x9BF2, KANJI_SJIS_L2,  // 鯲
	0x9BF1, KANJI_SJIS_L2,  // 鯱
	0x9BF0, KANJI_SJIS_L2,  // 鯰
	0x9C15, KANJI_SJIS_L2,  // 鰕
	0x9C14, KANJI_SJIS_L2,  // 鰔
	0x9C09, KANJI_SJIS_L2,  // 鰉
	0x9C13, KANJI_SJIS_L2,  // 鰓
	0x9C0C, KANJI_SJIS_L2,  // 鰌
	0x9C06, KANJI_SJIS_L2,  // 鰆
	0x9C08, KANJI_SJIS_L2,  // 鰈
	0x9C12, KANJI_SJIS_L2,  // 鰒
	0x9C0A, KANJI_SJIS_L2,  // 鰊
	0x9C04, KANJI_SJIS_L2,  // 鰄
	0x9C2E, KANJI_SJIS_L2,  // 鰮
	0x9C1B, KANJI_SJIS_L2,  // 鰛
	0x9C25, KANJI_SJIS_L2,  // 鰥
	0x9C24, KANJI_SJIS_L2,  // 鰤
	0x9C21, KANJI_SJIS_L2,  // 鰡
	0x9C30, KANJI_SJIS_L2,  // 鰰
	0x9C47, KANJI_SJIS_L2,  // 鱇
	0x9C32, KANJI_SJIS_L2,  // 鰲
	0x9C46, KANJI_SJIS_L2,  // 鱆
	0x9C3E, KANJI_SJIS_L2,  // 鰾
	0x9C5A, KANJI_SJIS_L2,  // 鱚
	0x9C60, KANJI_SJIS_L2,  // 鱠
	0x9C67, KANJI_SJIS_L2,  // 鱧
	0x9C76, KANJI_SJIS_L2,  // 鱶
	0x9C78, KANJI_SJIS_L2,  // 鱸
	0x9CE7, KANJI_SJIS_L2,  // 鳧
	0x9CEC, KANJI_SJIS_L2,  // 鳬
	0x9CF0, KANJI_SJIS_L2,  // 鳰
	0x9D09, KANJI_SJIS_L2,  // 鴉
	0x9D08, KANJI_SJIS_L2,  // 鴈
	0x9CEB, KANJI_SJIS_L2,  // 鳫
	0x9D03, KANJI_SJIS_L2,  // 鴃
	0x9D06, KANJI_SJIS_L2,  // 鴆
	0x9D2A, KANJI_SJIS_L2,  // 鴪
	0x9D26, KANJI_SJIS_L2,  // 鴦
	0x9DAF, KANJI_SJIS_L2,  // 鶯
	0x9D23, KANJI_SJIS_L2,  // 鴣
	0x9D1F, KANJI_SJIS_L2,  // 鴟
	0x9D44, KANJI_SJIS_L2,  // 鵄
	0x9D15, KANJI_SJIS_L2,  // 鴕
	0x9D12, KANJI_SJIS_L2,  // 鴒
	0x9D41, KANJI_SJIS_L2,  // 鵁
	0x9D3F, KANJI_SJIS_L2,  // 鴿
	0x9D3E, KANJI_SJIS_L2,  // 鴾
	0x9D46, KANJI_SJIS_L2,  // 鵆
	0x9D48, KANJI_SJIS_L2,  // 鵈
	0x9D5D, KANJI_SJIS_L2,  // 鵝
	0x9D5E, KANJI_SJIS_L2,  // 鵞
	0x9D64, KANJI_SJIS_L2,  // 鵤
	0x9D51, KANJI_SJIS_L2,  // 鵑
	0x9D50, KANJI_SJIS_L2,  // 鵐
	0x9D59, KANJI_SJIS_L2,  // 鵙
	0x9D72, KANJI_SJIS_L2,  // 鵲
	0x9D89, KANJI_SJIS_L2,  // 鶉
	0x9D87, KANJI_SJIS_L2,  // 鶇
	0x9DAB, KANJI_SJIS_L2,  // 鶫
	0x9D6F, KANJI_SJIS_L2,  // 鵯
	0x9D7A, KANJI_SJIS_L2,  // 鵺
	0x9D9A, KANJI_SJIS_L2,  // 鶚
	0x9DA4, KANJI_SJIS_L2,  // 鶤
	0x9DA9, KANJI_SJIS_L2,  // 鶩
	0x9DB2, KANJI_SJIS_L2,  // 鶲
	0x9DC4, KANJI_SJIS_L2,  // 鷄
	0x9DC1, KANJI_SJIS_L2,  // 鷁
	0x9DBB, KANJI_SJIS_L2,  // 鶻
	0x9DB8, KANJI_SJIS_L2,  // 鶸
	0x9DBA, KANJI_SJIS_L2,  // 鶺
	0x9DC6, KANJI_SJIS_L2,  // 鷆
	0x9DCF, KANJI_SJIS_L2,  // 鷏
	0x9DC2, KANJI_SJIS_L2,  // 鷂
	0x9DD9, KANJI_SJIS_L2,  // 鷙
	0x9DD3, KANJI_SJIS_L2,  // 鷓
	0x9DF8, KANJI_SJIS_L2,  // 鷸
	0x9DE6, KANJI_SJIS_L2,  // 鷦
	0x9DED, KANJI_SJIS_L2,  // 鷭
	0x9DEF, KANJI_SJIS_L2,  // 鷯
	0x9DFD, KANJI_SJIS_L2,  // 鷽
	0x9E1A, KANJI_SJIS_L2,  // 鸚
	0x9E1B, KANJI_SJIS_L2,  // 鸛
	0x9E1E, KANJI_SJIS_L2,  // 鸞
	0x9E75, KANJI_SJIS_L2,  // 鹵
	0x9E79, KANJI_SJIS_L2,  // 鹹
	0x9E7D, KANJI_SJIS_L2,  // 鹽
	0x9E81, KANJI_SJIS_L2,  // 麁
	0x9E88, KANJI_SJIS_L2,  // 麈
	0x9E8B, KANJI_SJIS_L2,  // 麋
	0x9E8C, KANJI_SJIS_L2,  // 麌
	0x9E92, KANJI_SJIS_L2,  // 麒
	0x9E95, KANJI_SJIS_L2,  // 麕
	0x9E91, KANJI_SJIS_L2,  // 麑
	0x9E9D, KANJI_SJIS_L2,  // 麝
	0x9EA5, KANJI_SJIS_L2,  // 麥
	0x9EA9, KANJI_SJIS_L2,  // 麩
	0x9EB8, KANJI_SJIS_L2,  // 麸
	0x9EAA, KANJI_SJIS_L2,  // 麪
	0x9EAD, KANJI_SJIS_L2,  // 麭
	0x9761, KANJI_SJIS_L2,  // 靡
	0x9ECC, KANJI_SJIS_L2,  // 黌
	0x9ECE, KANJI_SJIS_L2,  // 黎
	0x9ECF, KANJI_SJIS_L2,  // 黏
	0x9ED0, KANJI_SJIS_L2,  // 黐
	0x9ED4, KANJI_SJIS_L2,  // 黔
	0x9EDC, KANJI_SJIS_L2,  // 黜
	0x9EDE, KANJI_SJIS_L2,  // 點
	0x9EDD, KANJI_SJIS_L2,  // 黝
	0x9EE0, KANJI_SJIS_L2,  // 黠
	0x9EE5, KANJI_SJIS_L2,  // 黥
	0x9EE8, KANJI_SJIS_L2,  // 黨
	0x9EEF, KANJI_SJIS_L2,  // 黯
	0x3000, KANJI_SJIS_L2,  // 　
	0x9EF4, KANJI_SJIS_L2,  // 黴
	0x9EF6, KANJI_SJIS_L2,  // 黶
	0x9EF7, KANJI_SJIS_L2,  // 黷
	0x9EF9, KANJI_SJIS_L2,  // 黹
	0x9EFB, KANJI_SJIS_L2,  // 黻
	0x9EFC, KANJI_SJIS_L2,  // 黼
	0x9EFD, KANJI_SJIS_L2,  // 黽
	0x9F07, KANJI_SJIS_L2,  // 鼇
	0x9F08, KANJI_SJIS_L2,  // 鼈
	0x76B7, KANJI_SJIS_L2,  // 皷
	0x9F15, KANJI_SJIS_L2,  // 鼕
	0x9F21, KANJI_SJIS_L2,  // 鼡
	0x9F2C, KANJI_SJIS_L2,  // 鼬
	0x9F3E, KANJI_SJIS_L2,  // 鼾
	0x9F4A, KANJI_SJIS_L2,  // 齊
	0x9F52, KANJI_SJIS_L2,  // 齒
	0x9F54, KANJI_SJIS_L2,  // 齔
	0x9F63, KANJI_SJIS_L2,  // 齣
	0x9F5F, KANJI_SJIS_L2,  // 齟
	0x9F60, KANJI_SJIS_L2,  // 齠
	0x9F61, KANJI_SJIS_L2,  // 齡
	0x9F66, KANJI_SJIS_L2,  // 齦
	0x9F67, KANJI_SJIS_L2,  // 齧
	0x9F6C, KANJI_SJIS_L2,  // 齬
	0x9F6A, KANJI_SJIS_L2,  // 齪
	0x9F77, KANJI_SJIS_L2,  // 齷
	0x9F72, KANJI_SJIS_L2,  // 齲
	0x9F76, KANJI_SJIS_L2,  // 齶
	0x9F95, KANJI_SJIS_L2,  // 龕
	0x9F9C, KANJI_SJIS_L2,  // 龜
	0x9FA0, KANJI_SJIS_L2,  // 龠
	0x582F, KANJI_SJIS_L2,  // 堯
	0x69C7, KANJI_SJIS_L2,  // 槇
	0x9059, KANJI_SJIS_L2,  // 遙
	0x7464, KANJI_SJIS_L2,  // 瑤
	0x51DC, KANJI_SJIS_L2,  // 凜
	0x7199, KANJI_SJIS_L2,  // 熙
	0x7E8A, KANJI_SJIS_L3,  // 纊
	0x891C, KANJI_SJIS_L3,  // 褜
	0x9348, KANJI_SJIS_L3,  // 鍈
	0x9288, KANJI_SJIS_L3,  // 銈
	0x84DC, KANJI_SJIS_L3,  // 蓜
	0x4FC9, KANJI_SJIS_L3,  // 俉
	0x70BB, KANJI_SJIS_L3,  // 炻
	0x6631, KANJI_SJIS_L3,  // 昱
	0x68C8, KANJI_SJIS_L3,  // 棈
	0x92F9, KANJI_SJIS_L3,  // 鋹
	0x66FB, KANJI_SJIS_L3,  // 曻
	0x5F45, KANJI_SJIS_L3,  // 彅
	0x4E28, KANJI_SJIS_L3,  // 丨
	0x4EE1, KANJI_SJIS_L3,  // 仡
	0x4EFC, KANJI_SJIS_L3,  // 仼
	0x4F00, KANJI_SJIS_L3,  // 伀
	0x4F03, KANJI_SJIS_L3,  // 伃
	0x4F39, KANJI_SJIS_L3,  // 伹
	0x4F56, KANJI_SJIS_L3,  // 佖
	0x4F92, KANJI_SJIS_L3,  // 侒
	0x4F8A, KANJI_SJIS_L3,  // 侊
	0x4F9A, KANJI_SJIS_L3,  // 侚
	0x4F94, KANJI_SJIS_L3,  // 侔
	0x4FCD, KANJI_SJIS_L3,  // 俍
	0x5040, KANJI_SJIS_L3,  // 偀
	0x5022, KANJI_SJIS_L3,  // 倢
	0x4FFF, KANJI_SJIS_L3,  // 俿
	0x501E, KANJI_SJIS_L3,  // 倞
	0x5046, KANJI_SJIS_L3,  // 偆
	0x5070, KANJI_SJIS_L3,  // 偰
	0x5042, KANJI_SJIS_L3,  // 偂
	0x5094, KANJI_SJIS_L3,  // 傔
	0x50F4, KANJI_SJIS_L3,  // 僴
	0x50D8, KANJI_SJIS_L3,  // 僘
	0x514A, KANJI_SJIS_L3,  // 兊
	0x5164, KANJI_SJIS_L3,  // 兤
	0x519D, KANJI_SJIS_L3,  // 冝
	0x51BE, KANJI_SJIS_L3,  // 冾
	0x51EC, KANJI_SJIS_L3,  // 凬
	0x5215, KANJI_SJIS_L3,  // 刕
	0x529C, KANJI_SJIS_L3,  // 劜
	0x52A6, KANJI_SJIS_L3,  // 劦
	0x52C0, KANJI_SJIS_L3,  // 勀
	0x52DB, KANJI_SJIS_L3,  // 勛
	0x5300, KANJI_SJIS_L3,  // 匀
	0x5307, KANJI_SJIS_L3,  // 匇
	0x5324, KANJI_SJIS_L3,  // 匤
	0x5372, KANJI_SJIS_L3,  // 卲
	0x5393, KANJI_SJIS_L3,  // 厓
	0x53B2, KANJI_SJIS_L3,  // 厲
	0x53DD, KANJI_SJIS_L3,  // 叝
	0xFA0E, KANJI_SJIS_L3,  // 﨎
	0x549C, KANJI_SJIS_L3,  // 咜
	0x548A, KANJI_SJIS_L3,  // 咊
	0x54A9, KANJI_SJIS_L3,  // 咩
	0x54FF, KANJI_SJIS_L3,  // 哿
	0x5586, KANJI_SJIS_L3,  // 喆
	0x5759, KANJI_SJIS_L3,  // 坙
	0x5765, KANJI_SJIS_L3,  // 坥
	0x57AC, KANJI_SJIS_L3,  // 垬
	0x57C8, KANJI_SJIS_L3,  // 埈
	0x57C7, KANJI_SJIS_L3,  // 埇
	0xFA0F, KANJI_SJIS_L3,  // 﨏
	0x3000, KANJI_SJIS_L3,  // 　
	0xFA10, KANJI_SJIS_L3,  // 塚
	0x589E, KANJI_SJIS_L3,  // 增
	0x58B2, KANJI_SJIS_L3,  // 墲
	0x590B, KANJI_SJIS_L3,  // 夋
	0x5953, KANJI_SJIS_L3,  // 奓
	0x595B, KANJI_SJIS_L3,  // 奛
	0x595D, KANJI_SJIS_L3,  // 奝
	0x5963, KANJI_SJIS_L3,  // 奣
	0x59A4, KANJI_SJIS_L3,  // 妤
	0x59BA, KANJI_SJIS_L3,  // 妺
	0x5B56, KANJI_SJIS_L3,  // 孖
	0x5BC0, KANJI_SJIS_L3,  // 寀
	0x752F, KANJI_SJIS_L3,  // 甯
	0x5BD8, KANJI_SJIS_L3,  // 寘
	0x5BEC, KANJI_SJIS_L3,  // 寬
	0x5C1E, KANJI_SJIS_L3,  // 尞
	0x5CA6, KANJI_SJIS_L3,  // 岦
	0x5CBA, KANJI_SJIS_L3,  // 岺
	0x5CF5, KANJI_SJIS_L3,  // 峵
	0x5D27, KANJI_SJIS_L3,  // 崧
	0x5D53, KANJI_SJIS_L3,  // 嵓
	0xFA11, KANJI_SJIS_L3,  // 﨑
	0x5D42, KANJI_SJIS_L3,  // 嵂
	0x5D6D, KANJI_SJIS_L3,  // 嵭
	0x5DB8, KANJI_SJIS_L3,  // 嶸
	0x5DB9, KANJI_SJIS_L3,  // 嶹
	0x5DD0, KANJI_SJIS_L3,  // 巐
	0x5F21, KANJI_SJIS_L3,  // 弡
	0x5F34, KANJI_SJIS_L3,  // 弴
	0x5F67, KANJI_SJIS_L3,  // 彧
	0x5FB7, KANJI_SJIS_L3,  // 德
	0x5FDE, KANJI_SJIS_L3,  // 忞
	0x605D, KANJI_SJIS_L3,  // 恝
	0x6085, KANJI_SJIS_L3,  // 悅
	0x608A, KANJI_SJIS_L3,  // 悊
	0x60DE, KANJI_SJIS_L3,  // 惞
	0x60D5, KANJI_SJIS_L3,  // 惕
	0x6120, KANJI_SJIS_L3,  // 愠
	0x60F2, KANJI_SJIS_L3,  // 惲
	0x6111, KANJI_SJIS_L3,  // 愑
	0x6137, KANJI_SJIS_L3,  // 愷
	0x6130, KANJI_SJIS_L3,  // 愰
	0x6198, KANJI_SJIS_L3,  // 憘
	0x6213, KANJI_SJIS_L3,  // 戓
	0x62A6, KANJI_SJIS_L3,  // 抦
	0x63F5, KANJI_SJIS_L3,  // 揵
	0x6460, KANJI_SJIS_L3,  // 摠
	0x649D, KANJI_SJIS_L3,  // 撝
	0x64CE, KANJI_SJIS_L3,  // 擎
	0x654E, KANJI_SJIS_L3,  // 敎
	0x6600, KANJI_SJIS_L3,  // 昀
	0x6615, KANJI_SJIS_L3,  // 昕
	0x663B, KANJI_SJIS_L3,  // 昻
	0x6609, KANJI_SJIS_L3,  // 昉
	0x662E, KANJI_SJIS_L3,  // 昮
	0x661E, KANJI_SJIS_L3,  // 昞
	0x6624, KANJI_SJIS_L3,  // 昤
	0x6665, KANJI_SJIS_L3,  // 晥
	0x6657, KANJI_SJIS_L3,  // 晗
	0x6659, KANJI_SJIS_L3,  // 晙
	0xFA12, KANJI_SJIS_L3,  // 晴
	0x6673, KANJI_SJIS_L3,  // 晳
	0x6699, KANJI_SJIS_L3,  // 暙
	0x66A0, KANJI_SJIS_L3,  // 暠
	0x66B2, KANJI_SJIS_L3,  // 暲
	0x66BF, KANJI_SJIS_L3,  // 暿
	0x66FA, KANJI_SJIS_L3,  // 曺
	0x670E, KANJI_SJIS_L3,  // 朎
	0xF929, KANJI_SJIS_L3,  // 朗
	0x6766, KANJI_SJIS_L3,  // 杦
	0x67BB, KANJI_SJIS_L3,  // 枻
	0x6852, KANJI_SJIS_L3,  // 桒
	0x67C0, KANJI_SJIS_L3,  // 柀
	0x6801, KANJI_SJIS_L3,  // 栁
	0x6844, KANJI_SJIS_L3,  // 桄
	0x68CF, KANJI_SJIS_L3,  // 棏
	0xFA13, KANJI_SJIS_L3,  // 﨓
	0x6968, KANJI_SJIS_L3,  // 楨
	0xFA14, KANJI_SJIS_L3,  // 﨔
	0x6998, KANJI_SJIS_L3,  // 榘
	0x69E2, KANJI_SJIS_L3,  // 槢
	0x6A30, KANJI_SJIS_L3,  // 樰
	0x6A6B, KANJI_SJIS_L3,  // 橫
	0x6A46, KANJI_SJIS_L3,  // 橆
	0x6A73, KANJI_SJIS_L3,  // 橳
	0x6A7E, KANJI_SJIS_L3,  // 橾
	0x6AE2, KANJI_SJIS_L3,  // 櫢
	0x6AE4, KANJI_SJIS_L3,  // 櫤
	0x6BD6, KANJI_SJIS_L3,  // 毖
	0x6C3F, KANJI_SJIS_L3,  // 氿
	0x6C5C, KANJI_SJIS_L3,  // 汜
	0x6C86, KANJI_SJIS_L3,  // 沆
	0x6C6F, KANJI_SJIS_L3,  // 汯
	0x6CDA, KANJI_SJIS_L3,  // 泚
	0x6D04, KANJI_SJIS_L3,  // 洄
	0x6D87, KANJI_SJIS_L3,  // 涇
	0x6D6F, KANJI_SJIS_L3,  // 浯
	0x6D96, KANJI_SJIS_L3,  // 涖
	0x6DAC, KANJI_SJIS_L3,  // 涬
	0x6DCF, KANJI_SJIS_L3,  // 淏
	0x6DF8, KANJI_SJIS_L3,  // 淸
	0x6DF2, KANJI_SJIS_L3,  // 淲
	0x6DFC, KANJI_SJIS_L3,  // 淼
	0x6E39, KANJI_SJIS_L3,  // 渹
	0x6E5C, KANJI_SJIS_L3,  // 湜
	0x6E27, KANJI_SJIS_L3,  // 渧
	0x6E3C, KANJI_SJIS_L3,  // 渼
	0x6EBF, KANJI_SJIS_L3,  // 溿
	0x6F88, KANJI_SJIS_L3,  // 澈
	0x6FB5, KANJI_SJIS_L3,  // 澵
	0x6FF5, KANJI_SJIS_L3,  // 濵
	0x7005, KANJI_SJIS_L3,  // 瀅
	0x7007, KANJI_SJIS_L3,  // 瀇
	0x7028, KANJI_SJIS_L3,  // 瀨
	0x7085, KANJI_SJIS_L3,  // 炅
	0x70AB, KANJI_SJIS_L3,  // 炫
	0x710F, KANJI_SJIS_L3,  // 焏
	0x7104, KANJI_SJIS_L3,  // 焄
	0x715C, KANJI_SJIS_L3,  // 煜
	0x7146, KANJI_SJIS_L3,  // 煆
	0x7147, KANJI_SJIS_L3,  // 煇
	0xFA15, KANJI_SJIS_L3,  // 凞
	0x71C1, KANJI_SJIS_L3,  // 燁
	0x71FE, KANJI_SJIS_L3,  // 燾
	0x72B1, KANJI_SJIS_L3,  // 犱
	0x72BE, KANJI_SJIS_L3,  // 犾
	0x7324, KANJI_SJIS_L3,  // 猤
	0xFA16, KANJI_SJIS_L3,  // 猪
	0x7377, KANJI_SJIS_L3,  // 獷
	0x73BD, KANJI_SJIS_L3,  // 玽
	0x73C9, KANJI_SJIS_L3,  // 珉
	0x73D6, KANJI_SJIS_L3,  // 珖
	0x73E3, KANJI_SJIS_L3,  // 珣
	0x73D2, KANJI_SJIS_L3,  // 珒
	0x7407, KANJI_SJIS_L3,  // 琇
	0x73F5, KANJI_SJIS_L3,  // 珵
	0x7426, KANJI_SJIS_L3,  // 琦
	0x742A, KANJI_SJIS_L3,  // 琪
	0x7429, KANJI_SJIS_L3,  // 琩
	0x742E, KANJI_SJIS_L3,  // 琮
	0x7462, KANJI_SJIS_L3,  // 瑢
	0x7489, KANJI_SJIS_L3,  // 璉
	0x749F, KANJI_SJIS_L3,  // 璟
	0x7501, KANJI_SJIS_L3,  // 甁
	0x756F, KANJI_SJIS_L3,  // 畯
	0x7682, KANJI_SJIS_L3,  // 皂
	0x769C, KANJI_SJIS_L3,  // 皜
	0x769E, KANJI_SJIS_L3,  // 皞
	0x769B, KANJI_SJIS_L3,  // 皛
	0x76A6, KANJI_SJIS_L3,  // 皦
	0xFA17, KANJI_SJIS_L3,  // 益
	0x7746, KANJI_SJIS_L3,  // 睆
	0x52AF, KANJI_SJIS_L3,  // 劯
	0x7821, KANJI_SJIS_L3,  // 砡
	0x784E, KANJI_SJIS_L3,  // 硎
	0x7864, KANJI_SJIS_L3,  // 硤
	0x787A, KANJI_SJIS_L3,  // 硺
	0x7930, KANJI_SJIS_L3,  // 礰
	0xFA18, KANJI_SJIS_L3,  // 礼
	0xFA19, KANJI_SJIS_L3,  // 神
	0xFA1A, KANJI_SJIS_L3,  // 祥
	0x7994, KANJI_SJIS_L3,  // 禔
	0xFA1B, KANJI_SJIS_L3,  // 福
	0x799B, KANJI_SJIS_L3,  // 禛
	0x7AD1, KANJI_SJIS_L3,  // 竑
	0x7AE7, KANJI_SJIS_L3,  // 竧
	0xFA1C, KANJI_SJIS_L3,  // 靖
	0x7AEB, KANJI_SJIS_L3,  // 竫
	0x7B9E, KANJI_SJIS_L3,  // 箞
	0xFA1D, KANJI_SJIS_L3,  // 精
	0x7D48, KANJI_SJIS_L3,  // 絈
	0x7D5C, KANJI_SJIS_L3,  // 絜
	0x7DB7, KANJI_SJIS_L3,  // 綷
	0x7DA0, KANJI_SJIS_L3,  // 綠
	0x7DD6, KANJI_SJIS_L3,  // 緖
	0x7E52, KANJI_SJIS_L3,  // 繒
	0x7F47, KANJI_SJIS_L3,  // 罇
	0x7FA1, KANJI_SJIS_L3,  // 羡
	0xFA1E, KANJI_SJIS_L3,  // 羽
	0x8301, KANJI_SJIS_L3,  // 茁
	0x8362, KANJI_SJIS_L3,  // 荢
	0x837F, KANJI_SJIS_L3,  // 荿
	0x83C7, KANJI_SJIS_L3,  // 菇
	0x83F6, KANJI_SJIS_L3,  // 菶
	0x8448, KANJI_SJIS_L3,  // 葈
	0x84B4, KANJI_SJIS_L3,  // 蒴
	0x8553, KANJI_SJIS_L3,  // 蕓
	0x8559, KANJI_SJIS_L3,  // 蕙
	0x3000, KANJI_SJIS_L3,  // 　
	0x856B, KANJI_SJIS_L3,  // 蕫
	0xFA1F, KANJI_SJIS_L3,  // 﨟
	0x85B0, KANJI_SJIS_L3,  // 薰
	0xFA20, KANJI_SJIS_L3,  // 蘒
	0xFA21, KANJI_SJIS_L3,  // 﨡
	0x8807, KANJI_SJIS_L3,  // 蠇
	0x88F5, KANJI_SJIS_L3,  // 裵
	0x8A12, KANJI_SJIS_L3,  // 訒
	0x8A37, KANJI_SJIS_L3,  // 訷
	0x8A79, KANJI_SJIS_L3,  // 詹
	0x8AA7, KANJI_SJIS_L3,  // 誧
	0x8ABE, KANJI_SJIS_L3,  // 誾
	0x8ADF, KANJI_SJIS_L3,  // 諟
	0xFA22, KANJI_SJIS_L3,  // 諸
	0x8AF6, KANJI_SJIS_L3,  // 諶
	0x8B53, KANJI_SJIS_L3,  // 譓
	0x8B7F, KANJI_SJIS_L3,  // 譿
	0x8CF0, KANJI_SJIS_L3,  // 賰
	0x8CF4, KANJI_SJIS_L3,  // 賴
	0x8D12, KANJI_SJIS_L3,  // 贒
	0x8D76, KANJI_SJIS_L3,  // 赶
	0xFA23, KANJI_SJIS_L3,  // 﨣
	0x8ECF, KANJI_SJIS_L3,  // 軏
	0xFA24, KANJI_SJIS_L3,  // 﨤
	0xFA25, KANJI_SJIS_L3,  // 逸
	0x9067, KANJI_SJIS_L3,  // 遧
	0x90DE, KANJI_SJIS_L3,  // 郞
	0xFA26, KANJI_SJIS_L3,  // 都
	0x9115, KANJI_SJIS_L3,  // 鄕
	0x9127, KANJI_SJIS_L3,  // 鄧
	0x91DA, KANJI_SJIS_L3,  // 釚
	0x91D7, KANJI_SJIS_L3,  // 釗
	0x91DE, KANJI_SJIS_L3,  // 釞
	0x91ED, KANJI_SJIS_L3,  // 釭
	0x91EE, KANJI_SJIS_L3,  // 釮
	0x91E4, KANJI_SJIS_L3,  // 釤
	0x91E5, KANJI_SJIS_L3,  // 釥
	0x9206, KANJI_SJIS_L3,  // 鈆
	0x9210, KANJI_SJIS_L3,  // 鈐
	0x920A, KANJI_SJIS_L3,  // 鈊
	0x923A, KANJI_SJIS_L3,  // 鈺
	0x9240, KANJI_SJIS_L3,  // 鉀
	0x923C, KANJI_SJIS_L3,  // 鈼
	0x924E, KANJI_SJIS_L3,  // 鉎
	0x9259, KANJI_SJIS_L3,  // 鉙
	0x9251, KANJI_SJIS_L3,  // 鉑
	0x9239, KANJI_SJIS_L3,  // 鈹
	0x9267, KANJI_SJIS_L3,  // 鉧
	0x92A7, KANJI_SJIS_L3,  // 銧
	0x9277, KANJI_SJIS_L3,  // 鉷
	0x9278, KANJI_SJIS_L3,  // 鉸
	0x92E7, KANJI_SJIS_L3,  // 鋧
	0x92D7, KANJI_SJIS_L3,  // 鋗
	0x92D9, KANJI_SJIS_L3,  // 鋙
	0x92D0, KANJI_SJIS_L3,  // 鋐
	0xFA27, KANJI_SJIS_L3,  // 﨧
	0x92D5, KANJI_SJIS_L3,  // 鋕
	0x92E0, KANJI_SJIS_L3,  // 鋠
	0x92D3, KANJI_SJIS_L3,  // 鋓
	0x9325, KANJI_SJIS_L3,  // 錥
	0x9321, KANJI_SJIS_L3,  // 錡
	0x92FB, KANJI_SJIS_L3,  // 鋻
	0xFA28, KANJI_SJIS_L3,  // 﨨
	0x931E, KANJI_SJIS_L3,  // 錞
	0x92FF, KANJI_SJIS_L3,  // 鋿
	0x931D, KANJI_SJIS_L3,  // 錝
	0x9302, KANJI_SJIS_L3,  // 錂
	0x9370, KANJI_SJIS_L3,  // 鍰
	0x9357, KANJI_SJIS_L3,  // 鍗
	0x93A4, KANJI_SJIS_L3,  // 鎤
	0x93C6, KANJI_SJIS_L3,  // 鏆
	0x93DE, KANJI_SJIS_L3,  // 鏞
	0x93F8, KANJI_SJIS_L3,  // 鏸
	0x9431, KANJI_SJIS_L3,  // 鐱
	0x9445, KANJI_SJIS_L3,  // 鑅
	0x9448, KANJI_SJIS_L3,  // 鑈
	0x9592, KANJI_SJIS_L3,  // 閒
	0xF9DC, KANJI_SJIS_L3,  // 隆
	0xFA29, KANJI_SJIS_L3,  // 﨩
	0x969D, KANJI_SJIS_L3,  // 隝
	0x96AF, KANJI_SJIS_L3,  // 隯
	0x9733, KANJI_SJIS_L3,  // 霳
	0x973B, KANJI_SJIS_L3,  // 霻
	0x9743, KANJI_SJIS_L3,  // 靃
	0x974D, KANJI_SJIS_L3,  // 靍
	0x974F, KANJI_SJIS_L3,  // 靏
	0x9751, KANJI_SJIS_L3,  // 靑
	0x9755, KANJI_SJIS_L3,  // 靕
	0x9857, KANJI_SJIS_L3,  // 顗
	0x9865, KANJI_SJIS_L3,  // 顥
	0xFA2A, KANJI_SJIS_L3,  // 飯
	0xFA2B, KANJI_SJIS_L3,  // 飼
	0x9927, KANJI_SJIS_L3,  // 餧
	0xFA2C, KANJI_SJIS_L3,  // 館
	0x999E, KANJI_SJIS_L3,  // 馞
	0x9A4E, KANJI_SJIS_L3,  // 驎
	0x9AD9, KANJI_SJIS_L3,  // 髙
	0x9ADC, KANJI_SJIS_L3,  // 髜
	0x9B75, KANJI_SJIS_L3,  // 魵
	0x9B72, KANJI_SJIS_L3,  // 魲
	0x9B8F, KANJI_SJIS_L3,  // 鮏
	0x9BB1, KANJI_SJIS_L3,  // 鮱
	0x9BBB, KANJI_SJIS_L3,  // 鮻
	0x9C00, KANJI_SJIS_L3,  // 鰀
	0x9D70, KANJI_SJIS_L3,  // 鵰
	0x9D6B, KANJI_SJIS_L3,  // 鵫
	0xFA2D, KANJI_SJIS_L3,  // 鶴
	0x9E19, KANJI_SJIS_L3,  // 鸙
	0x9ED1, KANJI_SJIS_L3,  // 黑
	0x7E8A, KANJI_SJIS_L3,  // 纊
	0x891C, KANJI_SJIS_L3,  // 褜
	0x9348, KANJI_SJIS_L3,  // 鍈
	0x9288, KANJI_SJIS_L3,  // 銈
	0x84DC, KANJI_SJIS_L3,  // 蓜
	0x4FC9, KANJI_SJIS_L3,  // 俉
	0x70BB, KANJI_SJIS_L3,  // 炻
	0x6631, KANJI_SJIS_L3,  // 昱
	0x68C8, KANJI_SJIS_L3,  // 棈
	0x92F9, KANJI_SJIS_L3,  // 鋹
	0x66FB, KANJI_SJIS_L3,  // 曻
	0x5F45, KANJI_SJIS_L3,  // 彅
	0x4E28, KANJI_SJIS_L3,  // 丨
	0x4EE1, KANJI_SJIS_L3,  // 仡
	0x4EFC, KANJI_SJIS_L3,  // 仼
	0x4F00, KANJI_SJIS_L3,  // 伀
	0x4F03, KANJI_SJIS_L3,  // 伃
	0x4F39, KANJI_SJIS_L3,  // 伹
	0x4F56, KANJI_SJIS_L3,  // 佖
	0x4F92, KANJI_SJIS_L3,  // 侒
	0x4F8A, KANJI_SJIS_L3,  // 侊
	0x4F9A, KANJI_SJIS_L3,  // 侚
	0x4F94, KANJI_SJIS_L3,  // 侔
	0x4FCD, KANJI_SJIS_L3,  // 俍
	0x5040, KANJI_SJIS_L3,  // 偀
	0x5022, KANJI_SJIS_L3,  // 倢
	0x4FFF, KANJI_SJIS_L3,  // 俿
	0x501E, KANJI_SJIS_L3,  // 倞
	0x5046, KANJI_SJIS_L3,  // 偆
	0x5070, KANJI_SJIS_L3,  // 偰
	0x5042, KANJI_SJIS_L3,  // 偂
	0x5094, KANJI_SJIS_L3,  // 傔
	0x50F4, KANJI_SJIS_L3,  // 僴
	0x50D8, KANJI_SJIS_L3,  // 僘
	0x514A, KANJI_SJIS_L3,  // 兊
	0x3000, KANJI_SJIS_L3,  // 　
	0x5164, KANJI_SJIS_L3,  // 兤
	0x519D, KANJI_SJIS_L3,  // 冝
	0x51BE, KANJI_SJIS_L3,  // 冾
	0x51EC, KANJI_SJIS_L3,  // 凬
	0x5215, KANJI_SJIS_L3,  // 刕
	0x529C, KANJI_SJIS_L3,  // 劜
	0x52A6, KANJI_SJIS_L3,  // 劦
	0x52C0, KANJI_SJIS_L3,  // 勀
	0x52DB, KANJI_SJIS_L3,  // 勛
	0x5300, KANJI_SJIS_L3,  // 匀
	0x5307, KANJI_SJIS_L3,  // 匇
	0x5324, KANJI_SJIS_L3,  // 匤
	0x5372, KANJI_SJIS_L3,  // 卲
	0x5393, KANJI_SJIS_L3,  // 厓
	0x53B2, KANJI_SJIS_L3,  // 厲
	0x53DD, KANJI_SJIS_L3,  // 叝
	0xFA0E, KANJI_SJIS_L3,  // 﨎
	0x549C, KANJI_SJIS_L3,  // 咜
	0x548A, KANJI_SJIS_L3,  // 咊
	0x54A9, KANJI_SJIS_L3,  // 咩
	0x54FF, KANJI_SJIS_L3,  // 哿
	0x5586, KANJI_SJIS_L3,  // 喆
	0x5759, KANJI_SJIS_L3,  // 坙
	0x5765, KANJI_SJIS_L3,  // 坥
	0x57AC, KANJI_SJIS_L3,  // 垬
	0x57C8, KANJI_SJIS_L3,  // 埈
	0x57C7, KANJI_SJIS_L3,  // 埇
	0xFA0F, KANJI_SJIS_L3,  // 﨏
	0xFA10, KANJI_SJIS_L3,  // 塚
	0x589E, KANJI_SJIS_L3,  // 增
	0x58B2, KANJI_SJIS_L3,  // 墲
	0x590B, KANJI_SJIS_L3,  // 夋
	0x5953, KANJI_SJIS_L3,  // 奓
	0x595B, KANJI_SJIS_L3,  // 奛
	0x595D, KANJI_SJIS_L3,  // 奝
	0x5963, KANJI_SJIS_L3,  // 奣
	0x59A4, KANJI_SJIS_L3,  // 妤
	0x59BA, KANJI_SJIS_L3,  // 妺
	0x5B56, KANJI_SJIS_L3,  // 孖
	0x5BC0, KANJI_SJIS_L3,  // 寀
	0x752F, KANJI_SJIS_L3,  // 甯
	0x5BD8, KANJI_SJIS_L3,  // 寘
	0x5BEC, KANJI_SJIS_L3,  // 寬
	0x5C1E, KANJI_SJIS_L3,  // 尞
	0x5CA6, KANJI_SJIS_L3,  // 岦
	0x5CBA, KANJI_SJIS_L3,  // 岺
	0x5CF5, KANJI_SJIS_L3,  // 峵
	0x5D27, KANJI_SJIS_L3,  // 崧
	0x5D53, KANJI_SJIS_L3,  // 嵓
	0xFA11, KANJI_SJIS_L3,  // 﨑
	0x5D42, KANJI_SJIS_L3,  // 嵂
	0x5D6D, KANJI_SJIS_L3,  // 嵭
	0x5DB8, KANJI_SJIS_L3,  // 嶸
	0x5DB9, KANJI_SJIS_L3,  // 嶹
	0x5DD0, KANJI_SJIS_L3,  // 巐
	0x5F21, KANJI_SJIS_L3,  // 弡
	0x5F34, KANJI_SJIS_L3,  // 弴
	0x5F67, KANJI_SJIS_L3,  // 彧
	0x5FB7, KANJI_SJIS_L3,  // 德
	0x5FDE, KANJI_SJIS_L3,  // 忞
	0x605D, KANJI_SJIS_L3,  // 恝
	0x6085, KANJI_SJIS_L3,  // 悅
	0x608A, KANJI_SJIS_L3,  // 悊
	0x60DE, KANJI_SJIS_L3,  // 惞
	0x60D5, KANJI_SJIS_L3,  // 惕
	0x6120, KANJI_SJIS_L3,  // 愠
	0x60F2, KANJI_SJIS_L3,  // 惲
	0x6111, KANJI_SJIS_L3,  // 愑
	0x6137, KANJI_SJIS_L3,  // 愷
	0x6130, KANJI_SJIS_L3,  // 愰
	0x6198, KANJI_SJIS_L3,  // 憘
	0x6213, KANJI_SJIS_L3,  // 戓
	0x62A6, KANJI_SJIS_L3,  // 抦
	0x63F5, KANJI_SJIS_L3,  // 揵
	0x6460, KANJI_SJIS_L3,  // 摠
	0x649D, KANJI_SJIS_L3,  // 撝
	0x64CE, KANJI_SJIS_L3,  // 擎
	0x654E, KANJI_SJIS_L3,  // 敎
	0x6600, KANJI_SJIS_L3,  // 昀
	0x6615, KANJI_SJIS_L3,  // 昕
	0x663B, KANJI_SJIS_L3,  // 昻
	0x6609, KANJI_SJIS_L3,  // 昉
	0x662E, KANJI_SJIS_L3,  // 昮
	0x661E, KANJI_SJIS_L3,  // 昞
	0x6624, KANJI_SJIS_L3,  // 昤
	0x6665, KANJI_SJIS_L3,  // 晥
	0x6657, KANJI_SJIS_L3,  // 晗
	0x6659, KANJI_SJIS_L3,  // 晙
	0xFA12, KANJI_SJIS_L3,  // 晴
	0x6673, KANJI_SJIS_L3,  // 晳
	0x6699, KANJI_SJIS_L3,  // 暙
	0x66A0, KANJI_SJIS_L3,  // 暠
	0x66B2, KANJI_SJIS_L3,  // 暲
	0x66BF, KANJI_SJIS_L3,  // 暿
	0x66FA, KANJI_SJIS_L3,  // 曺
	0x670E, KANJI_SJIS_L3,  // 朎
	0xF929, KANJI_SJIS_L3,  // 朗
	0x6766, KANJI_SJIS_L3,  // 杦
	0x67BB, KANJI_SJIS_L3,  // 枻
	0x6852, KANJI_SJIS_L3,  // 桒
	0x67C0, KANJI_SJIS_L3,  // 柀
	0x6801, KANJI_SJIS_L3,  // 栁
	0x6844, KANJI_SJIS_L3,  // 桄
	0x68CF, KANJI_SJIS_L3,  // 棏
	0xFA13, KANJI_SJIS_L3,  // 﨓
	0x6968, KANJI_SJIS_L3,  // 楨
	0xFA14, KANJI_SJIS_L3,  // 﨔
	0x6998, KANJI_SJIS_L3,  // 榘
	0x69E2, KANJI_SJIS_L3,  // 槢
	0x6A30, KANJI_SJIS_L3,  // 樰
	0x6A6B, KANJI_SJIS_L3,  // 橫
	0x6A46, KANJI_SJIS_L3,  // 橆
	0x6A73, KANJI_SJIS_L3,  // 橳
	0x6A7E, KANJI_SJIS_L3,  // 橾
	0x6AE2, KANJI_SJIS_L3,  // 櫢
	0x6AE4, KANJI_SJIS_L3,  // 櫤
	0x6BD6, KANJI_SJIS_L3,  // 毖
	0x6C3F, KANJI_SJIS_L3,  // 氿
	0x6C5C, KANJI_SJIS_L3,  // 汜
	0x6C86, KANJI_SJIS_L3,  // 沆
	0x6C6F, KANJI_SJIS_L3,  // 汯
	0x6CDA, KANJI_SJIS_L3,  // 泚
	0x6D04, KANJI_SJIS_L3,  // 洄
	0x6D87, KANJI_SJIS_L3,  // 涇
	0x6D6F, KANJI_SJIS_L3,  // 浯
	0x6D96, KANJI_SJIS_L3,  // 涖
	0x6DAC, KANJI_SJIS_L3,  // 涬
	0x6DCF, KANJI_SJIS_L3,  // 淏
	0x6DF8, KANJI_SJIS_L3,  // 淸
	0x6DF2, KANJI_SJIS_L3,  // 淲
	0x6DFC, KANJI_SJIS_L3,  // 淼
	0x6E39, KANJI_SJIS_L3,  // 渹
	0x6E5C, KANJI_SJIS_L3,  // 湜
	0x6E27, KANJI_SJIS_L3,  // 渧
	0x6E3C, KANJI_SJIS_L3,  // 渼
	0x6EBF, KANJI_SJIS_L3,  // 溿
	0x6F88, KANJI_SJIS_L3,  // 澈
	0x6FB5, KANJI_SJIS_L3,  // 澵
	0x6FF5, KANJI_SJIS_L3,  // 濵
	0x7005, KANJI_SJIS_L3,  // 瀅
	0x7007, KANJI_SJIS_L3,  // 瀇
	0x7028, KANJI_SJIS_L3,  // 瀨
	0x7085, KANJI_SJIS_L3,  // 炅
	0x70AB, KANJI_SJIS_L3,  // 炫
	0x710F, KANJI_SJIS_L3,  // 焏
	0x7104, KANJI_SJIS_L3,  // 焄
	0x715C, KANJI_SJIS_L3,  // 煜
	0x7146, KANJI_SJIS_L3,  // 煆
	0x7147, KANJI_SJIS_L3,  // 煇
	0xFA15, KANJI_SJIS_L3,  // 凞
	0x71C1, KANJI_SJIS_L3,  // 燁
	0x71FE, KANJI_SJIS_L3,  // 燾
	0x72B1, KANJI_SJIS_L3,  // 犱
	0x72BE, KANJI_SJIS_L3,  // 犾
	0x7324, KANJI_SJIS_L3,  // 猤
	0xFA16, KANJI_SJIS_L3,  // 猪
	0x7377, KANJI_SJIS_L3,  // 獷
	0x73BD, KANJI_SJIS_L3,  // 玽
	0x73C9, KANJI_SJIS_L3,  // 珉
	0x73D6, KANJI_SJIS_L3,  // 珖
	0x73E3, KANJI_SJIS_L3,  // 珣
	0x73D2, KANJI_SJIS_L3,  // 珒
	0x7407, KANJI_SJIS_L3,  // 琇
	0x73F5, KANJI_SJIS_L3,  // 珵
	0x7426, KANJI_SJIS_L3,  // 琦
	0x742A, KANJI_SJIS_L3,  // 琪
	0x7429, KANJI_SJIS_L3,  // 琩
	0x742E, KANJI_SJIS_L3,  // 琮
	0x7462, KANJI_SJIS_L3,  // 瑢
	0x7489, KANJI_SJIS_L3,  // 璉
	0x749F, KANJI_SJIS_L3,  // 璟
	0x7501, KANJI_SJIS_L3,  // 甁
	0x756F, KANJI_SJIS_L3,  // 畯
	0x7682, KANJI_SJIS_L3,  // 皂
	0x769C, KANJI_SJIS_L3,  // 皜
	0x769E, KANJI_SJIS_L3,  // 皞
	0x769B, KANJI_SJIS_L3,  // 皛
	0x76A6, KANJI_SJIS_L3,  // 皦
	0xFA17, KANJI_SJIS_L3,  // 益
	0x7746, KANJI_SJIS_L3,  // 睆
	0x52AF, KANJI_SJIS_L3,  // 劯
	0x7821, KANJI_SJIS_L3,  // 砡
	0x784E, KANJI_SJIS_L3,  // 硎
	0x7864, KANJI_SJIS_L3,  // 硤
	0x787A, KANJI_SJIS_L3,  // 硺
	0x7930, KANJI_SJIS_L3,  // 礰
	0xFA18, KANJI_SJIS_L3,  // 礼
	0xFA19, KANJI_SJIS_L3,  // 神
	0x3000, KANJI_SJIS_L3,  // 　
	0xFA1A, KANJI_SJIS_L3,  // 祥
	0x7994, KANJI_SJIS_L3,  // 禔
	0xFA1B, KANJI_SJIS_L3,  // 福
	0x799B, KANJI_SJIS_L3,  // 禛
	0x7AD1, KANJI_SJIS_L3,  // 竑
	0x7AE7, KANJI_SJIS_L3,  // 竧
	0xFA1C, KANJI_SJIS_L3,  // 靖
	0x7AEB, KANJI_SJIS_L3,  // 竫
	0x7B9E, KANJI_SJIS_L3,  // 箞
	0xFA1D, KANJI_SJIS_L3,  // 精
	0x7D48, KANJI_SJIS_L3,  // 絈
	0x7D5C, KANJI_SJIS_L3,  // 絜
	0x7DB7, KANJI_SJIS_L3,  // 綷
	0x7DA0, KANJI_SJIS_L3,  // 綠
	0x7DD6, KANJI_SJIS_L3,  // 緖
	0x7E52, KANJI_SJIS_L3,  // 繒
	0x7F47, KANJI_SJIS_L3,  // 罇
	0x7FA1, KANJI_SJIS_L3,  // 羡
	0xFA1E, KANJI_SJIS_L3,  // 羽
	0x8301, KANJI_SJIS_L3,  // 茁
	0x8362, KANJI_SJIS_L3,  // 荢
	0x837F, KANJI_SJIS_L3,  // 荿
	0x83C7, KANJI_SJIS_L3,  // 菇
	0x83F6, KANJI_SJIS_L3,  // 菶
	0x8448, KANJI_SJIS_L3,  // 葈
	0x84B4, KANJI_SJIS_L3,  // 蒴
	0x8553, KANJI_SJIS_L3,  // 蕓
	0x8559, KANJI_SJIS_L3,  // 蕙
	0x856B, KANJI_SJIS_L3,  // 蕫
	0xFA1F, KANJI_SJIS_L3,  // 﨟
	0x85B0, KANJI_SJIS_L3,  // 薰
	0xFA20, KANJI_SJIS_L3,  // 蘒
	0xFA21, KANJI_SJIS_L3,  // 﨡
	0x8807, KANJI_SJIS_L3,  // 蠇
	0x88F5, KANJI_SJIS_L3,  // 裵
	0x8A12, KANJI_SJIS_L3,  // 訒
	0x8A37, KANJI_SJIS_L3,  // 訷
	0x8A79, KANJI_SJIS_L3,  // 詹
	0x8AA7, KANJI_SJIS_L3,  // 誧
	0x8ABE, KANJI_SJIS_L3,  // 誾
	0x8ADF, KANJI_SJIS_L3,  // 諟
	0xFA22, KANJI_SJIS_L3,  // 諸
	0x8AF6, KANJI_SJIS_L3,  // 諶
	0x8B53, KANJI_SJIS_L3,  // 譓
	0x8B7F, KANJI_SJIS_L3,  // 譿
	0x8CF0, KANJI_SJIS_L3,  // 賰
	0x8CF4, KANJI_SJIS_L3,  // 賴
	0x8D12, KANJI_SJIS_L3,  // 贒
	0x8D76, KANJI_SJIS_L3,  // 赶
	0xFA23, KANJI_SJIS_L3,  // 﨣
	0x8ECF, KANJI_SJIS_L3,  // 軏
	0xFA24, KANJI_SJIS_L3,  // 﨤
	0xFA25, KANJI_SJIS_L3,  // 逸
	0x9067, KANJI_SJIS_L3,  // 遧
	0x90DE, KANJI_SJIS_L3,  // 郞
	0xFA26, KANJI_SJIS_L3,  // 都
	0x9115, KANJI_SJIS_L3,  // 鄕
	0x9127, KANJI_SJIS_L3,  // 鄧
	0x91DA, KANJI_SJIS_L3,  // 釚
	0x91D7, KANJI_SJIS_L3,  // 釗
	0x91DE, KANJI_SJIS_L3,  // 釞
	0x91ED, KANJI_SJIS_L3,  // 釭
	0x91EE, KANJI_SJIS_L3,  // 釮
	0x91E4, KANJI_SJIS_L3,  // 釤
	0x91E5, KANJI_SJIS_L3,  // 釥
	0x9206, KANJI_SJIS_L3,  // 鈆
	0x9210, KANJI_SJIS_L3,  // 鈐
	0x920A, KANJI_SJIS_L3,  // 鈊
	0x923A, KANJI_SJIS_L3,  // 鈺
	0x9240, KANJI_SJIS_L3,  // 鉀
	0x923C, KANJI_SJIS_L3,  // 鈼
	0x924E, KANJI_SJIS_L3,  // 鉎
	0x9259, KANJI_SJIS_L3,  // 鉙
	0x9251, KANJI_SJIS_L3,  // 鉑
	0x9239, KANJI_SJIS_L3,  // 鈹
	0x9267, KANJI_SJIS_L3,  // 鉧
	0x92A7, KANJI_SJIS_L3,  // 銧
	0x9277, KANJI_SJIS_L3,  // 鉷
	0x9278, KANJI_SJIS_L3,  // 鉸
	0x92E7, KANJI_SJIS_L3,  // 鋧
	0x92D7, KANJI_SJIS_L3,  // 鋗
	0x92D9, KANJI_SJIS_L3,  // 鋙
	0x92D0, KANJI_SJIS_L3,  // 鋐
	0xFA27, KANJI_SJIS_L3,  // 﨧
	0x92D5, KANJI_SJIS_L3,  // 鋕
	0x92E0, KANJI_SJIS_L3,  // 鋠
	0x92D3, KANJI_SJIS_L3,  // 鋓
	0x9325, KANJI_SJIS_L3,  // 錥
	0x9321, KANJI_SJIS_L3,  // 錡
	0x92FB, KANJI_SJIS_L3,  // 鋻
	0xFA28, KANJI_SJIS_L3,  // 﨨
	0x931E, KANJI_SJIS_L3,  // 錞
	0x9357, KANJI_SJIS_L3,  // 鍗
	0x93A4, KANJI_SJIS_L3,  // 鎤
	0x93C6, KANJI_SJIS_L3,  // 鏆
	0x93DE, KANJI_SJIS_L3,  // 鏞
	0x93F8, KANJI_SJIS_L3,  // 鏸
	0x9431, KANJI_SJIS_L3,  // 鐱
	0x9445, KANJI_SJIS_L3,  // 鑅
	0x9448, KANJI_SJIS_L3,  // 鑈
	0x9592, KANJI_SJIS_L3,  // 閒
	0xF9DC, KANJI_SJIS_L3,  // 隆
	0xFA29, KANJI_SJIS_L3,  // 﨩
	0x969D, KANJI_SJIS_L3,  // 隝
	0x96AF, KANJI_SJIS_L3,  // 隯
	0x9733, KANJI_SJIS_L3,  // 霳
	0x973B, KANJI_SJIS_L3,  // 霻
	0x9743, KANJI_SJIS_L3,  // 靃
	0x974D, KANJI_SJIS_L3,  // 靍
	0x974F, KANJI_SJIS_L3,  // 靏
	0x9751, KANJI_SJIS_L3,  // 靑
	0x9755, KANJI_SJIS_L3,  // 靕
	0x9857, KANJI_SJIS_L3,  // 顗
	0x9865, KANJI_SJIS_L3,  // 顥
	0xFA2A, KANJI_SJIS_L3,  // 飯
	0xFA2B, KANJI_SJIS_L3,  // 飼
	0x9927, KANJI_SJIS_L3,  // 餧
	0xFA2C, KANJI_SJIS_L3,  // 館
	0x999E, KANJI_SJIS_L3,  // 馞
	0x9A4E, KANJI_SJIS_L3,  // 驎
	0x9AD9, KANJI_SJIS_L3,  // 髙
	0x9ADC, KANJI_SJIS_L3,  // 髜
	0x9B75, KANJI_SJIS_L3,  // 魵
	0x9B72, KANJI_SJIS_L3,  // 魲
	0x9B8F, KANJI_SJIS_L3,  // 鮏
	0x9BB1, KANJI_SJIS_L3,  // 鮱
	0x9BBB, KANJI_SJIS_L3,  // 鮻
	0x9C00, KANJI_SJIS_L3,  // 鰀
	0x9D70, KANJI_SJIS_L3,  // 鵰
	0x9D6B, KANJI_SJIS_L3,  // 鵫
	0xFA2D, KANJI_SJIS_L3,  // 鶴
	0x9E19, KANJI_SJIS_L3,  // 鸙
	0x9ED1, KANJI_SJIS_L3,  // 黑
};