/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "naq" locale.
 */
public class LocalizedNamesImpl_naq extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BV",
        "KH",
        "CM",
        "CV",
        "KY",
        "CC",
        "CF",
        "TD",
        "CL",
        "CN",
        "CO",
        "KM",
        "CG",
        "CK",
        "CR",
        "CP",
        "HR",
        "CU",
        "CW",
        "CX",
        "CY",
        "CZ",
        "CD",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DE",
        "EA",
        "TL",
        "EC",
        "EG",
        "EH",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FJ",
        "FI",
        "FO",
        "FR",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GG",
        "GH",
        "GI",
        "GL",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IS",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IL",
        "IT",
        "CI",
        "JM",
        "JP",
        "JE",
        "JO",
        "CA",
        "KZ",
        "KE",
        "KI",
        "KP",
        "KR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NF",
        "MP",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "RU",
        "RE",
        "RO",
        "RS",
        "RW",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SB",
        "SO",
        "ES",
        "LK",
        "SS",
        "SD",
        "ZA",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TA",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "UM",
        "AE",
        "GB",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XK",
        "GR",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andorrab");
    namesMap.put("AF", "Afghanistanni");
    namesMap.put("AG", "Antiguab tsî Barbudab");
    namesMap.put("AI", "Anguillab");
    namesMap.put("AL", "Albaniab");
    namesMap.put("AM", "Armeniab");
    namesMap.put("AO", "Angolab");
    namesMap.put("AR", "Argentinab");
    namesMap.put("AS", "Americab Samoab");
    namesMap.put("AT", "Austriab");
    namesMap.put("AU", "Australieb");
    namesMap.put("AW", "Arubab");
    namesMap.put("AZ", "Azerbaijanni");
    namesMap.put("BA", "Bosniab tsî Herzegovinab");
    namesMap.put("BD", "Banglades");
    namesMap.put("BE", "Belgiummi");
    namesMap.put("BF", "Burkina Fasob");
    namesMap.put("BG", "Bulgariab");
    namesMap.put("BI", "Burundib");
    namesMap.put("BJ", "Benins");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Boliviab");
    namesMap.put("BR", "Braziliab");
    namesMap.put("BT", "Bhutans");
    namesMap.put("BW", "Botswanab");
    namesMap.put("CA", "Kanadab");
    namesMap.put("CD", "Democratic Republic of the Congo");
    namesMap.put("CF", "Central African Republiki");
    namesMap.put("CG", "Congob");
    namesMap.put("CH", "Switzerlandi");
    namesMap.put("CI", "Ivoorkusi");
    namesMap.put("CL", "Chilib");
    namesMap.put("CM", "Cameroonni");
    namesMap.put("CN", "Chinab");
    namesMap.put("CO", "Colombiab");
    namesMap.put("CU", "Cubab");
    namesMap.put("CV", "Cape Verde Islands");
    namesMap.put("CZ", "Czech Republiki");
    namesMap.put("DE", "Duitslandi");
    namesMap.put("DK", "Denmarki");
    namesMap.put("DM", "Dominicab");
    namesMap.put("DZ", "Algeriab");
    namesMap.put("EC", "Ecuadori");
    namesMap.put("EE", "Estoniab");
    namesMap.put("EG", "Egipteb");
    namesMap.put("ER", "Eritreab");
    namesMap.put("ES", "Spanieb");
    namesMap.put("ET", "Ethiopiab");
    namesMap.put("FI", "Finlandi");
    namesMap.put("FJ", "Fijib");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FR", "Frankreiki");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GE", "Georgiab");
    namesMap.put("GH", "Ghanab");
    namesMap.put("GM", "Gambiab");
    namesMap.put("GN", "Guineab");
    namesMap.put("GQ", "Equatorial Guineab");
    namesMap.put("GR", "Xrikelandi");
    namesMap.put("HR", "Croatiab");
    namesMap.put("HU", "Hongareieb");
    namesMap.put("ID", "Indonesiab");
    namesMap.put("IE", "Irlandi");
    namesMap.put("IL", "Israeli");
    namesMap.put("IN", "Indiab");
    namesMap.put("IQ", "Iraqi");
    namesMap.put("IR", "Iranni");
    namesMap.put("IT", "Italiab");
    namesMap.put("JM", "Jamaicab");
    namesMap.put("JO", "Jordanni");
    namesMap.put("JP", "Japanni");
    namesMap.put("KE", "Kenyab");
    namesMap.put("KG", "Kyrgyzstanni");
    namesMap.put("KH", "Cambodiab");
    namesMap.put("KP", "Koreab, Noord");
    namesMap.put("KR", "Koreab, Suid");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KZ", "Kazakhstanni");
    namesMap.put("LB", "Lebanonni");
    namesMap.put("LI", "Liechtensteinni");
    namesMap.put("LK", "Sri Lankab");
    namesMap.put("LR", "Liberiab");
    namesMap.put("LS", "Lesothob");
    namesMap.put("LT", "Lithuaniab");
    namesMap.put("LU", "Luxembourgi");
    namesMap.put("LY", "Libyab");
    namesMap.put("MG", "Madagascari");
    namesMap.put("MK", "Macedoniab");
    namesMap.put("ML", "Malib");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MW", "Malawib");
    namesMap.put("MX", "Mexicob");
    namesMap.put("MY", "Malaysiab");
    namesMap.put("MZ", "Mozambiki");
    namesMap.put("NA", "Namibiab");
    namesMap.put("NE", "Nigeri");
    namesMap.put("NG", "Nigerieb");
    namesMap.put("NI", "Nicaraguab");
    namesMap.put("NO", "Noorweeb");
    namesMap.put("NP", "Nepali");
    namesMap.put("NZ", "New Zealandi");
    namesMap.put("PE", "Perub");
    namesMap.put("PG", "Papua New Guineab");
    namesMap.put("PH", "Philippinni");
    namesMap.put("PK", "Pakistanni");
    namesMap.put("PL", "Polandi");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian West Bank and Gaza");
    namesMap.put("PT", "Portugali");
    namesMap.put("PY", "Paraguaib");
    namesMap.put("RU", "Rasiab");
    namesMap.put("RW", "Rwandab");
    namesMap.put("SA", "Saudi Arabiab");
    namesMap.put("SD", "Sudanni");
    namesMap.put("SE", "Swedeb");
    namesMap.put("SN", "Senegali");
    namesMap.put("SO", "Somaliab");
    namesMap.put("SV", "El Salvadori");
    namesMap.put("SY", "Syriab");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TD", "Chadi");
    namesMap.put("TG", "Togob");
    namesMap.put("TH", "Thailandi");
    namesMap.put("TL", "East Timor");
    namesMap.put("TN", "Tunisiab");
    namesMap.put("TR", "Turkeieb");
    namesMap.put("TZ", "Tanzaniab");
    namesMap.put("UG", "Ugandab");
    namesMap.put("US", "Amerikab");
    namesMap.put("UY", "Uruguaib");
    namesMap.put("VA", "Vatican State");
    namesMap.put("VC", "Saint Vincent and the Grenadines");
    namesMap.put("VE", "Venezuelab");
    namesMap.put("VN", "Vietnammi");
    namesMap.put("ZA", "Suid Afrikab");
    namesMap.put("ZM", "Zambiab");
    namesMap.put("ZW", "Zimbabweb");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andorrab",
        "AF": "Afghanistanni",
        "AG": "Antiguab tsî Barbudab",
        "AI": "Anguillab",
        "AL": "Albaniab",
        "AM": "Armeniab",
        "AO": "Angolab",
        "AR": "Argentinab",
        "AS": "Americab Samoab",
        "AT": "Austriab",
        "AU": "Australieb",
        "AW": "Arubab",
        "AZ": "Azerbaijanni",
        "BA": "Bosniab tsî Herzegovinab",
        "BD": "Banglades",
        "BE": "Belgiummi",
        "BF": "Burkina Fasob",
        "BG": "Bulgariab",
        "BI": "Burundib",
        "BJ": "Benins",
        "BM": "Bermudas",
        "BO": "Boliviab",
        "BR": "Braziliab",
        "BT": "Bhutans",
        "BW": "Botswanab",
        "CA": "Kanadab",
        "CD": "Democratic Republic of the Congo",
        "CF": "Central African Republiki",
        "CG": "Congob",
        "CH": "Switzerlandi",
        "CI": "Ivoorkusi",
        "CL": "Chilib",
        "CM": "Cameroonni",
        "CN": "Chinab",
        "CO": "Colombiab",
        "CU": "Cubab",
        "CV": "Cape Verde Islands",
        "CZ": "Czech Republiki",
        "DE": "Duitslandi",
        "DK": "Denmarki",
        "DM": "Dominicab",
        "DZ": "Algeriab",
        "EC": "Ecuadori",
        "EE": "Estoniab",
        "EG": "Egipteb",
        "ER": "Eritreab",
        "ES": "Spanieb",
        "ET": "Ethiopiab",
        "FI": "Finlandi",
        "FJ": "Fijib",
        "FK": "Falkland Islands",
        "FR": "Frankreiki",
        "GA": "Gaboni",
        "GE": "Georgiab",
        "GH": "Ghanab",
        "GM": "Gambiab",
        "GN": "Guineab",
        "GQ": "Equatorial Guineab",
        "GR": "Xrikelandi",
        "HR": "Croatiab",
        "HU": "Hongareieb",
        "ID": "Indonesiab",
        "IE": "Irlandi",
        "IL": "Israeli",
        "IN": "Indiab",
        "IQ": "Iraqi",
        "IR": "Iranni",
        "IT": "Italiab",
        "JM": "Jamaicab",
        "JO": "Jordanni",
        "JP": "Japanni",
        "KE": "Kenyab",
        "KG": "Kyrgyzstanni",
        "KH": "Cambodiab",
        "KP": "Koreab, Noord",
        "KR": "Koreab, Suid",
        "KW": "Kuwaiti",
        "KZ": "Kazakhstanni",
        "LB": "Lebanonni",
        "LI": "Liechtensteinni",
        "LK": "Sri Lankab",
        "LR": "Liberiab",
        "LS": "Lesothob",
        "LT": "Lithuaniab",
        "LU": "Luxembourgi",
        "LY": "Libyab",
        "MG": "Madagascari",
        "MK": "Macedoniab",
        "ML": "Malib",
        "MM": "Myanmar",
        "MW": "Malawib",
        "MX": "Mexicob",
        "MY": "Malaysiab",
        "MZ": "Mozambiki",
        "NA": "Namibiab",
        "NE": "Nigeri",
        "NG": "Nigerieb",
        "NI": "Nicaraguab",
        "NO": "Noorweeb",
        "NP": "Nepali",
        "NZ": "New Zealandi",
        "PE": "Perub",
        "PG": "Papua New Guineab",
        "PH": "Philippinni",
        "PK": "Pakistanni",
        "PL": "Polandi",
        "PN": "Pitcairn",
        "PS": "Palestinian West Bank and Gaza",
        "PT": "Portugali",
        "PY": "Paraguaib",
        "RU": "Rasiab",
        "RW": "Rwandab",
        "SA": "Saudi Arabiab",
        "SD": "Sudanni",
        "SE": "Swedeb",
        "SN": "Senegali",
        "SO": "Somaliab",
        "SV": "El Salvadori",
        "SY": "Syriab",
        "SZ": "Swazilandi",
        "TD": "Chadi",
        "TG": "Togob",
        "TH": "Thailandi",
        "TL": "East Timor",
        "TN": "Tunisiab",
        "TR": "Turkeieb",
        "TZ": "Tanzaniab",
        "UG": "Ugandab",
        "US": "Amerikab",
        "UY": "Uruguaib",
        "VA": "Vatican State",
        "VC": "Saint Vincent and the Grenadines",
        "VE": "Venezuelab",
        "VN": "Vietnammi",
        "ZA": "Suid Afrikab",
        "ZM": "Zambiab",
        "ZW": "Zimbabweb"
    };
  }-*/;
}
