/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sv" locale.
 */
public class LocalizedNamesImpl_sv extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "SE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "VI",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "KY",
        "CF",
        "EA",
        "CL",
        "CP",
        "CO",
        "CK",
        "CR",
        "CW",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "GQ",
        "CI",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "PF",
        "TF",
        "FO",
        "AE",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CX",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CC",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MM",
        "NA",
        "NR",
        "NL",
        "AN",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "KP",
        "MP",
        "NF",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RW",
        "RU",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SB",
        "WS",
        "SM",
        "ST",
        "SA",
        "CH",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "GB",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "TH",
        "CZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "DE",
        "UG",
        "UA",
        "HU",
        "UY",
        "US",
        "UM",
        "UZ",
        "WF",
        "VU",
        "VA",
        "VE",
        "VN",
        "BY",
        "EH",
        "QO",
        "ZM",
        "ZW",
        "AX",
        "AT",
        "TL",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "världen");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nordamerika");
    namesMap.put("005", "Sydamerika");
    namesMap.put("009", "Oceanien");
    namesMap.put("011", "Västafrika");
    namesMap.put("013", "Centralamerika");
    namesMap.put("014", "Östafrika");
    namesMap.put("015", "Nordafrika");
    namesMap.put("017", "Centralafrika");
    namesMap.put("018", "södra Afrika");
    namesMap.put("019", "Nord- och Sydamerika");
    namesMap.put("021", "norra Amerika");
    namesMap.put("029", "Karibien");
    namesMap.put("030", "Östasien");
    namesMap.put("034", "Sydasien");
    namesMap.put("035", "Sydostasien");
    namesMap.put("039", "Sydeuropa");
    namesMap.put("053", "Australasien");
    namesMap.put("054", "Melanesien");
    namesMap.put("057", "Mikronesiska öarna");
    namesMap.put("061", "Polynesien");
    namesMap.put("142", "Asien");
    namesMap.put("143", "Centralasien");
    namesMap.put("145", "Västasien");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Östeuropa");
    namesMap.put("154", "Nordeuropa");
    namesMap.put("155", "Västeuropa");
    namesMap.put("419", "Latinamerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Förenade Arabemiraten");
    namesMap.put("AG", "Antigua och Barbuda");
    namesMap.put("AL", "Albanien");
    namesMap.put("AM", "Armenien");
    namesMap.put("AN", "Nederländska Antillerna");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerikanska Samoa");
    namesMap.put("AT", "Österrike");
    namesMap.put("AU", "Australien");
    namesMap.put("AX", "Åland");
    namesMap.put("AZ", "Azerbajdzjan");
    namesMap.put("BA", "Bosnien och Hercegovina");
    namesMap.put("BE", "Belgien");
    namesMap.put("BG", "Bulgarien");
    namesMap.put("BL", "S:t Barthélemy");
    namesMap.put("BQ", "Karibiska Nederländerna");
    namesMap.put("BR", "Brasilien");
    namesMap.put("BV", "Bouvetön");
    namesMap.put("BY", "Vitryssland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosöarna");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Centralafrikanska republiken");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Schweiz");
    namesMap.put("CI", "Elfenbenskusten");
    namesMap.put("CK", "Cooköarna");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CP", "Clippertonön");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Julön");
    namesMap.put("CY", "Cypern");
    namesMap.put("CZ", "Tjeckien");
    namesMap.put("DE", "Tyskland");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Dominikanska republiken");
    namesMap.put("DZ", "Algeriet");
    namesMap.put("EA", "Ceuta och Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Egypten");
    namesMap.put("EH", "Västsahara");
    namesMap.put("ES", "Spanien");
    namesMap.put("ET", "Etiopien");
    namesMap.put("EU", "Europeiska unionen");
    namesMap.put("FK", "Falklandsöarna");
    namesMap.put("FM", "Mikronesien");
    namesMap.put("FO", "Färöarna");
    namesMap.put("FR", "Frankrike");
    namesMap.put("GB", "Storbritannien");
    namesMap.put("GE", "Georgien");
    namesMap.put("GF", "Franska Guyana");
    namesMap.put("GL", "Grönland");
    namesMap.put("GQ", "Ekvatorialguinea");
    namesMap.put("GR", "Grekland");
    namesMap.put("GS", "Sydgeorgien och Sydsandwichöarna");
    namesMap.put("HK", "Hongkong (S.A.R. Kina)");
    namesMap.put("HM", "Heardön och McDonaldöarna");
    namesMap.put("HR", "Kroatien");
    namesMap.put("HU", "Ungern");
    namesMap.put("IC", "Kanarieöarna");
    namesMap.put("ID", "Indonesien");
    namesMap.put("IE", "Irland");
    namesMap.put("IN", "Indien");
    namesMap.put("IO", "Brittiska territoriet i Indiska oceanen");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italien");
    namesMap.put("JO", "Jordanien");
    namesMap.put("KG", "Kirgizistan");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komorerna");
    namesMap.put("KN", "S:t Kitts och Nevis");
    namesMap.put("KP", "Nordkorea");
    namesMap.put("KR", "Sydkorea");
    namesMap.put("KY", "Caymanöarna");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "S:t Lucia");
    namesMap.put("LT", "Litauen");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Libyen");
    namesMap.put("MA", "Marocko");
    namesMap.put("MD", "Moldavien");
    namesMap.put("MF", "S:t Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallöarna");
    namesMap.put("MK", "Makedonien");
    namesMap.put("MN", "Mongoliet");
    namesMap.put("MO", "Macao (S.A.R. Kina)");
    namesMap.put("MP", "Nordmarianerna");
    namesMap.put("MR", "Mauretanien");
    namesMap.put("MV", "Maldiverna");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Moçambique");
    namesMap.put("NC", "Nya Kaledonien");
    namesMap.put("NF", "Norfolkön");
    namesMap.put("NL", "Nederländerna");
    namesMap.put("NO", "Norge");
    namesMap.put("NZ", "Nya Zeeland");
    namesMap.put("PF", "Franska Polynesien");
    namesMap.put("PG", "Papua Nya Guinea");
    namesMap.put("PH", "Filippinerna");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "S:t Pierre och Miquelon");
    namesMap.put("PN", "Pitcairnöarna");
    namesMap.put("PS", "Palestinska territorierna");
    namesMap.put("QO", "yttre öar i Oceanien");
    namesMap.put("RO", "Rumänien");
    namesMap.put("RS", "Serbien");
    namesMap.put("RU", "Ryssland");
    namesMap.put("SA", "Saudiarabien");
    namesMap.put("SB", "Salomonöarna");
    namesMap.put("SC", "Seychellerna");
    namesMap.put("SE", "Sverige");
    namesMap.put("SH", "S:t Helena");
    namesMap.put("SI", "Slovenien");
    namesMap.put("SJ", "Svalbard och Jan Mayen");
    namesMap.put("SK", "Slovakien");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sydsudan");
    namesMap.put("ST", "São Tomé och Príncipe");
    namesMap.put("SY", "Syrien");
    namesMap.put("TC", "Turks- och Caicosöarna");
    namesMap.put("TD", "Tchad");
    namesMap.put("TF", "Franska sydterritorierna");
    namesMap.put("TJ", "Tadzjikistan");
    namesMap.put("TL", "Östtimor");
    namesMap.put("TN", "Tunisien");
    namesMap.put("TR", "Turkiet");
    namesMap.put("TT", "Trinidad och Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "USA:s yttre öar");
    namesMap.put("US", "USA");
    namesMap.put("VA", "Vatikanstaten");
    namesMap.put("VC", "S:t Vincent och Grenadinerna");
    namesMap.put("VG", "Brittiska Jungfruöarna");
    namesMap.put("VI", "Amerikanska Jungfruöarna");
    namesMap.put("WF", "Wallis- och Futunaöarna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Sydafrika");
    namesMap.put("ZZ", "okänd region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "världen",
        "002": "Afrika",
        "003": "Nordamerika",
        "005": "Sydamerika",
        "009": "Oceanien",
        "011": "Västafrika",
        "013": "Centralamerika",
        "014": "Östafrika",
        "015": "Nordafrika",
        "017": "Centralafrika",
        "018": "södra Afrika",
        "019": "Nord- och Sydamerika",
        "021": "norra Amerika",
        "029": "Karibien",
        "030": "Östasien",
        "034": "Sydasien",
        "035": "Sydostasien",
        "039": "Sydeuropa",
        "053": "Australasien",
        "054": "Melanesien",
        "057": "Mikronesiska öarna",
        "061": "Polynesien",
        "142": "Asien",
        "143": "Centralasien",
        "145": "Västasien",
        "150": "Europa",
        "151": "Östeuropa",
        "154": "Nordeuropa",
        "155": "Västeuropa",
        "419": "Latinamerika",
        "AC": "Ascension",
        "AE": "Förenade Arabemiraten",
        "AG": "Antigua och Barbuda",
        "AL": "Albanien",
        "AM": "Armenien",
        "AN": "Nederländska Antillerna",
        "AQ": "Antarktis",
        "AS": "Amerikanska Samoa",
        "AT": "Österrike",
        "AU": "Australien",
        "AX": "Åland",
        "AZ": "Azerbajdzjan",
        "BA": "Bosnien och Hercegovina",
        "BE": "Belgien",
        "BG": "Bulgarien",
        "BL": "S:t Barthélemy",
        "BQ": "Karibiska Nederländerna",
        "BR": "Brasilien",
        "BV": "Bouvetön",
        "BY": "Vitryssland",
        "CA": "Kanada",
        "CC": "Kokosöarna",
        "CD": "Kongo-Kinshasa",
        "CF": "Centralafrikanska republiken",
        "CG": "Kongo-Brazzaville",
        "CH": "Schweiz",
        "CI": "Elfenbenskusten",
        "CK": "Cooköarna",
        "CM": "Kamerun",
        "CN": "Kina",
        "CP": "Clippertonön",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Julön",
        "CY": "Cypern",
        "CZ": "Tjeckien",
        "DE": "Tyskland",
        "DK": "Danmark",
        "DO": "Dominikanska republiken",
        "DZ": "Algeriet",
        "EA": "Ceuta och Melilla",
        "EE": "Estland",
        "EG": "Egypten",
        "EH": "Västsahara",
        "ES": "Spanien",
        "ET": "Etiopien",
        "EU": "Europeiska unionen",
        "FK": "Falklandsöarna",
        "FM": "Mikronesien",
        "FO": "Färöarna",
        "FR": "Frankrike",
        "GB": "Storbritannien",
        "GE": "Georgien",
        "GF": "Franska Guyana",
        "GL": "Grönland",
        "GQ": "Ekvatorialguinea",
        "GR": "Grekland",
        "GS": "Sydgeorgien och Sydsandwichöarna",
        "HK": "Hongkong (S.A.R. Kina)",
        "HM": "Heardön och McDonaldöarna",
        "HR": "Kroatien",
        "HU": "Ungern",
        "IC": "Kanarieöarna",
        "ID": "Indonesien",
        "IE": "Irland",
        "IN": "Indien",
        "IO": "Brittiska territoriet i Indiska oceanen",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italien",
        "JO": "Jordanien",
        "KG": "Kirgizistan",
        "KH": "Kambodja",
        "KM": "Komorerna",
        "KN": "S:t Kitts och Nevis",
        "KP": "Nordkorea",
        "KR": "Sydkorea",
        "KY": "Caymanöarna",
        "KZ": "Kazakstan",
        "LB": "Libanon",
        "LC": "S:t Lucia",
        "LT": "Litauen",
        "LU": "Luxemburg",
        "LV": "Lettland",
        "LY": "Libyen",
        "MA": "Marocko",
        "MD": "Moldavien",
        "MF": "S:t Martin",
        "MG": "Madagaskar",
        "MH": "Marshallöarna",
        "MK": "Makedonien",
        "MN": "Mongoliet",
        "MO": "Macao (S.A.R. Kina)",
        "MP": "Nordmarianerna",
        "MR": "Mauretanien",
        "MV": "Maldiverna",
        "MX": "Mexiko",
        "MZ": "Moçambique",
        "NC": "Nya Kaledonien",
        "NF": "Norfolkön",
        "NL": "Nederländerna",
        "NO": "Norge",
        "NZ": "Nya Zeeland",
        "PF": "Franska Polynesien",
        "PG": "Papua Nya Guinea",
        "PH": "Filippinerna",
        "PL": "Polen",
        "PM": "S:t Pierre och Miquelon",
        "PN": "Pitcairnöarna",
        "PS": "Palestinska territorierna",
        "QO": "yttre öar i Oceanien",
        "RO": "Rumänien",
        "RS": "Serbien",
        "RU": "Ryssland",
        "SA": "Saudiarabien",
        "SB": "Salomonöarna",
        "SC": "Seychellerna",
        "SE": "Sverige",
        "SH": "S:t Helena",
        "SI": "Slovenien",
        "SJ": "Svalbard och Jan Mayen",
        "SK": "Slovakien",
        "SR": "Surinam",
        "SS": "Sydsudan",
        "ST": "São Tomé och Príncipe",
        "SY": "Syrien",
        "TC": "Turks- och Caicosöarna",
        "TD": "Tchad",
        "TF": "Franska sydterritorierna",
        "TJ": "Tadzjikistan",
        "TL": "Östtimor",
        "TN": "Tunisien",
        "TR": "Turkiet",
        "TT": "Trinidad och Tobago",
        "UA": "Ukraina",
        "UM": "USA:s yttre öar",
        "US": "USA",
        "VA": "Vatikanstaten",
        "VC": "S:t Vincent och Grenadinerna",
        "VG": "Brittiska Jungfruöarna",
        "VI": "Amerikanska Jungfruöarna",
        "WF": "Wallis- och Futunaöarna",
        "YE": "Jemen",
        "ZA": "Sydafrika",
        "ZZ": "okänd region"
    };
  }-*/;
}
