// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointemail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSet for more information on using the CreateConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetRequest method.
//    req, resp := client.CreateConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateConfigurationSet
func (c *PinpointEmail) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/configuration-sets",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSet API operation for Amazon Pinpoint Email Service.
//
// Create a configuration set. Configuration sets are groups of rules that you
// can apply to the emails you send using Amazon Pinpoint. You apply a configuration
// set to an email by including a reference to the configuration set in the
// headers of the email. When you apply a configuration set to an email, all
// of the rules in that configuration set are applied to the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateConfigurationSet
func (c *PinpointEmail) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetEventDestination = "CreateConfigurationSetEventDestination"

// CreateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSetEventDestination for more information on using the CreateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetEventDestinationRequest method.
//    req, resp := client.CreateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateConfigurationSetEventDestination
func (c *PinpointEmail) CreateConfigurationSetEventDestinationRequest(input *CreateConfigurationSetEventDestinationInput) (req *request.Request, output *CreateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &CreateConfigurationSetEventDestinationInput{}
	}

	output = &CreateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSetEventDestination API operation for Amazon Pinpoint Email Service.
//
// Create an event destination. In Amazon Pinpoint, events include message sends,
// deliveries, opens, clicks, bounces, and complaints. Event destinations are
// places that you can send information about these events to. For example,
// you can send event data to Amazon SNS to receive notifications when you receive
// bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream
// data to Amazon S3 for long-term storage.
//
// A single configuration set can include more than one event destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation CreateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateConfigurationSetEventDestination
func (c *PinpointEmail) CreateConfigurationSetEventDestination(input *CreateConfigurationSetEventDestinationInput) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetEventDestinationWithContext is the same as CreateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) CreateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *CreateConfigurationSetEventDestinationInput, opts ...request.Option) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDedicatedIpPool = "CreateDedicatedIpPool"

// CreateDedicatedIpPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateDedicatedIpPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDedicatedIpPool for more information on using the CreateDedicatedIpPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDedicatedIpPoolRequest method.
//    req, resp := client.CreateDedicatedIpPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateDedicatedIpPool
func (c *PinpointEmail) CreateDedicatedIpPoolRequest(input *CreateDedicatedIpPoolInput) (req *request.Request, output *CreateDedicatedIpPoolOutput) {
	op := &request.Operation{
		Name:       opCreateDedicatedIpPool,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/dedicated-ip-pools",
	}

	if input == nil {
		input = &CreateDedicatedIpPoolInput{}
	}

	output = &CreateDedicatedIpPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDedicatedIpPool API operation for Amazon Pinpoint Email Service.
//
// Create a new pool of dedicated IP addresses. A pool can include one or more
// dedicated IP addresses that are associated with your Amazon Pinpoint account.
// You can associate a pool with a configuration set. When you send an email
// that uses that configuration set, Amazon Pinpoint sends it using only the
// IP addresses in the associated pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation CreateDedicatedIpPool for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateDedicatedIpPool
func (c *PinpointEmail) CreateDedicatedIpPool(input *CreateDedicatedIpPoolInput) (*CreateDedicatedIpPoolOutput, error) {
	req, out := c.CreateDedicatedIpPoolRequest(input)
	return out, req.Send()
}

// CreateDedicatedIpPoolWithContext is the same as CreateDedicatedIpPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDedicatedIpPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) CreateDedicatedIpPoolWithContext(ctx aws.Context, input *CreateDedicatedIpPoolInput, opts ...request.Option) (*CreateDedicatedIpPoolOutput, error) {
	req, out := c.CreateDedicatedIpPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeliverabilityTestReport = "CreateDeliverabilityTestReport"

// CreateDeliverabilityTestReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeliverabilityTestReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeliverabilityTestReport for more information on using the CreateDeliverabilityTestReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeliverabilityTestReportRequest method.
//    req, resp := client.CreateDeliverabilityTestReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateDeliverabilityTestReport
func (c *PinpointEmail) CreateDeliverabilityTestReportRequest(input *CreateDeliverabilityTestReportInput) (req *request.Request, output *CreateDeliverabilityTestReportOutput) {
	op := &request.Operation{
		Name:       opCreateDeliverabilityTestReport,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/deliverability-dashboard/test",
	}

	if input == nil {
		input = &CreateDeliverabilityTestReportInput{}
	}

	output = &CreateDeliverabilityTestReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeliverabilityTestReport API operation for Amazon Pinpoint Email Service.
//
// Create a new predictive inbox placement test. Predictive inbox placement
// tests can help you predict how your messages will be handled by various email
// providers around the world. When you perform a predictive inbox placement
// test, you provide a sample message that contains the content that you plan
// to send to your customers. Amazon Pinpoint then sends that message to special
// email addresses spread across several major email providers. After about
// 24 hours, the test is complete, and you can use the GetDeliverabilityTestReport
// operation to view the results of the test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation CreateDeliverabilityTestReport for usage and error information.
//
// Returned Error Types:
//   * AccountSuspendedException
//   The message can't be sent because the account's ability to send email has
//   been permanently restricted.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateDeliverabilityTestReport
func (c *PinpointEmail) CreateDeliverabilityTestReport(input *CreateDeliverabilityTestReportInput) (*CreateDeliverabilityTestReportOutput, error) {
	req, out := c.CreateDeliverabilityTestReportRequest(input)
	return out, req.Send()
}

// CreateDeliverabilityTestReportWithContext is the same as CreateDeliverabilityTestReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeliverabilityTestReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) CreateDeliverabilityTestReportWithContext(ctx aws.Context, input *CreateDeliverabilityTestReportInput, opts ...request.Option) (*CreateDeliverabilityTestReportOutput, error) {
	req, out := c.CreateDeliverabilityTestReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEmailIdentity = "CreateEmailIdentity"

// CreateEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the CreateEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEmailIdentity for more information on using the CreateEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEmailIdentityRequest method.
//    req, resp := client.CreateEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateEmailIdentity
func (c *PinpointEmail) CreateEmailIdentityRequest(input *CreateEmailIdentityInput) (req *request.Request, output *CreateEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opCreateEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/identities",
	}

	if input == nil {
		input = &CreateEmailIdentityInput{}
	}

	output = &CreateEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEmailIdentity API operation for Amazon Pinpoint Email Service.
//
// Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint,
// an identity is an email address or domain that you use when you send email.
// Before you can use an identity to send email with Amazon Pinpoint, you first
// have to verify it. By verifying an address, you demonstrate that you're the
// owner of the address, and that you've given Amazon Pinpoint permission to
// send email from the address.
//
// When you verify an email address, Amazon Pinpoint sends an email to the address.
// Your email address is verified as soon as you follow the link in the verification
// email.
//
// When you verify a domain, this operation provides a set of DKIM tokens, which
// you can convert into CNAME tokens. You add these CNAME tokens to the DNS
// configuration for your domain. Your domain is verified when Amazon Pinpoint
// detects these records in the DNS configuration for your domain. It usually
// takes around 72 hours to complete the domain verification process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation CreateEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CreateEmailIdentity
func (c *PinpointEmail) CreateEmailIdentity(input *CreateEmailIdentityInput) (*CreateEmailIdentityOutput, error) {
	req, out := c.CreateEmailIdentityRequest(input)
	return out, req.Send()
}

// CreateEmailIdentityWithContext is the same as CreateEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) CreateEmailIdentityWithContext(ctx aws.Context, input *CreateEmailIdentityInput, opts ...request.Option) (*CreateEmailIdentityOutput, error) {
	req, out := c.CreateEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSet for more information on using the DeleteConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetRequest method.
//    req, resp := client.DeleteConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteConfigurationSet
func (c *PinpointEmail) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSet API operation for Amazon Pinpoint Email Service.
//
// Delete an existing configuration set.
//
// In Amazon Pinpoint, configuration sets are groups of rules that you can apply
// to the emails you send. You apply a configuration set to an email by including
// a reference to the configuration set in the headers of the email. When you
// apply a configuration set to an email, all of the rules in that configuration
// set are applied to the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteConfigurationSet
func (c *PinpointEmail) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetEventDestination = "DeleteConfigurationSetEventDestination"

// DeleteConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSetEventDestination for more information on using the DeleteConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetEventDestinationRequest method.
//    req, resp := client.DeleteConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteConfigurationSetEventDestination
func (c *PinpointEmail) DeleteConfigurationSetEventDestinationRequest(input *DeleteConfigurationSetEventDestinationInput) (req *request.Request, output *DeleteConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetEventDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetEventDestinationInput{}
	}

	output = &DeleteConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSetEventDestination API operation for Amazon Pinpoint Email Service.
//
// Delete an event destination.
//
// In Amazon Pinpoint, events include message sends, deliveries, opens, clicks,
// bounces, and complaints. Event destinations are places that you can send
// information about these events to. For example, you can send event data to
// Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation DeleteConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteConfigurationSetEventDestination
func (c *PinpointEmail) DeleteConfigurationSetEventDestination(input *DeleteConfigurationSetEventDestinationInput) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetEventDestinationWithContext is the same as DeleteConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) DeleteConfigurationSetEventDestinationWithContext(ctx aws.Context, input *DeleteConfigurationSetEventDestinationInput, opts ...request.Option) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDedicatedIpPool = "DeleteDedicatedIpPool"

// DeleteDedicatedIpPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDedicatedIpPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDedicatedIpPool for more information on using the DeleteDedicatedIpPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDedicatedIpPoolRequest method.
//    req, resp := client.DeleteDedicatedIpPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteDedicatedIpPool
func (c *PinpointEmail) DeleteDedicatedIpPoolRequest(input *DeleteDedicatedIpPoolInput) (req *request.Request, output *DeleteDedicatedIpPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteDedicatedIpPool,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/email/dedicated-ip-pools/{PoolName}",
	}

	if input == nil {
		input = &DeleteDedicatedIpPoolInput{}
	}

	output = &DeleteDedicatedIpPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDedicatedIpPool API operation for Amazon Pinpoint Email Service.
//
// Delete a dedicated IP pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation DeleteDedicatedIpPool for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteDedicatedIpPool
func (c *PinpointEmail) DeleteDedicatedIpPool(input *DeleteDedicatedIpPoolInput) (*DeleteDedicatedIpPoolOutput, error) {
	req, out := c.DeleteDedicatedIpPoolRequest(input)
	return out, req.Send()
}

// DeleteDedicatedIpPoolWithContext is the same as DeleteDedicatedIpPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDedicatedIpPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) DeleteDedicatedIpPoolWithContext(ctx aws.Context, input *DeleteDedicatedIpPoolInput, opts ...request.Option) (*DeleteDedicatedIpPoolOutput, error) {
	req, out := c.DeleteDedicatedIpPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailIdentity = "DeleteEmailIdentity"

// DeleteEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailIdentity for more information on using the DeleteEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailIdentityRequest method.
//    req, resp := client.DeleteEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteEmailIdentity
func (c *PinpointEmail) DeleteEmailIdentityRequest(input *DeleteEmailIdentityInput) (req *request.Request, output *DeleteEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}",
	}

	if input == nil {
		input = &DeleteEmailIdentityInput{}
	}

	output = &DeleteEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEmailIdentity API operation for Amazon Pinpoint Email Service.
//
// Deletes an email identity that you previously verified for use with Amazon
// Pinpoint. An identity can be either an email address or a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation DeleteEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeleteEmailIdentity
func (c *PinpointEmail) DeleteEmailIdentity(input *DeleteEmailIdentityInput) (*DeleteEmailIdentityOutput, error) {
	req, out := c.DeleteEmailIdentityRequest(input)
	return out, req.Send()
}

// DeleteEmailIdentityWithContext is the same as DeleteEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) DeleteEmailIdentityWithContext(ctx aws.Context, input *DeleteEmailIdentityInput, opts ...request.Option) (*DeleteEmailIdentityOutput, error) {
	req, out := c.DeleteEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountRequest method.
//    req, resp := client.GetAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetAccount
func (c *PinpointEmail) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *GetAccountOutput) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/account",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &GetAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon Pinpoint Email Service.
//
// Obtain information about the email-sending status and capabilities of your
// Amazon Pinpoint account in the current AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetAccount for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetAccount
func (c *PinpointEmail) GetAccount(input *GetAccountInput) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlacklistReports = "GetBlacklistReports"

// GetBlacklistReportsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlacklistReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlacklistReports for more information on using the GetBlacklistReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlacklistReportsRequest method.
//    req, resp := client.GetBlacklistReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetBlacklistReports
func (c *PinpointEmail) GetBlacklistReportsRequest(input *GetBlacklistReportsInput) (req *request.Request, output *GetBlacklistReportsOutput) {
	op := &request.Operation{
		Name:       opGetBlacklistReports,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/blacklist-report",
	}

	if input == nil {
		input = &GetBlacklistReportsInput{}
	}

	output = &GetBlacklistReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlacklistReports API operation for Amazon Pinpoint Email Service.
//
// Retrieve a list of the blacklists that your dedicated IP addresses appear
// on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetBlacklistReports for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetBlacklistReports
func (c *PinpointEmail) GetBlacklistReports(input *GetBlacklistReportsInput) (*GetBlacklistReportsOutput, error) {
	req, out := c.GetBlacklistReportsRequest(input)
	return out, req.Send()
}

// GetBlacklistReportsWithContext is the same as GetBlacklistReports with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlacklistReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetBlacklistReportsWithContext(ctx aws.Context, input *GetBlacklistReportsInput, opts ...request.Option) (*GetBlacklistReportsOutput, error) {
	req, out := c.GetBlacklistReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationSet = "GetConfigurationSet"

// GetConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationSet for more information on using the GetConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigurationSetRequest method.
//    req, resp := client.GetConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetConfigurationSet
func (c *PinpointEmail) GetConfigurationSetRequest(input *GetConfigurationSetInput) (req *request.Request, output *GetConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}",
	}

	if input == nil {
		input = &GetConfigurationSetInput{}
	}

	output = &GetConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationSet API operation for Amazon Pinpoint Email Service.
//
// Get information about an existing configuration set, including the dedicated
// IP pool that it's associated with, whether or not it's enabled for sending
// email, and more.
//
// In Amazon Pinpoint, configuration sets are groups of rules that you can apply
// to the emails you send. You apply a configuration set to an email by including
// a reference to the configuration set in the headers of the email. When you
// apply a configuration set to an email, all of the rules in that configuration
// set are applied to the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetConfigurationSet
func (c *PinpointEmail) GetConfigurationSet(input *GetConfigurationSetInput) (*GetConfigurationSetOutput, error) {
	req, out := c.GetConfigurationSetRequest(input)
	return out, req.Send()
}

// GetConfigurationSetWithContext is the same as GetConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetConfigurationSetWithContext(ctx aws.Context, input *GetConfigurationSetInput, opts ...request.Option) (*GetConfigurationSetOutput, error) {
	req, out := c.GetConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationSetEventDestinations = "GetConfigurationSetEventDestinations"

// GetConfigurationSetEventDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationSetEventDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationSetEventDestinations for more information on using the GetConfigurationSetEventDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigurationSetEventDestinationsRequest method.
//    req, resp := client.GetConfigurationSetEventDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetConfigurationSetEventDestinations
func (c *PinpointEmail) GetConfigurationSetEventDestinationsRequest(input *GetConfigurationSetEventDestinationsInput) (req *request.Request, output *GetConfigurationSetEventDestinationsOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationSetEventDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &GetConfigurationSetEventDestinationsInput{}
	}

	output = &GetConfigurationSetEventDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationSetEventDestinations API operation for Amazon Pinpoint Email Service.
//
// Retrieve a list of event destinations that are associated with a configuration
// set.
//
// In Amazon Pinpoint, events include message sends, deliveries, opens, clicks,
// bounces, and complaints. Event destinations are places that you can send
// information about these events to. For example, you can send event data to
// Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetConfigurationSetEventDestinations for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetConfigurationSetEventDestinations
func (c *PinpointEmail) GetConfigurationSetEventDestinations(input *GetConfigurationSetEventDestinationsInput) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	return out, req.Send()
}

// GetConfigurationSetEventDestinationsWithContext is the same as GetConfigurationSetEventDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationSetEventDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetConfigurationSetEventDestinationsWithContext(ctx aws.Context, input *GetConfigurationSetEventDestinationsInput, opts ...request.Option) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDedicatedIp = "GetDedicatedIp"

// GetDedicatedIpRequest generates a "aws/request.Request" representing the
// client's request for the GetDedicatedIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDedicatedIp for more information on using the GetDedicatedIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDedicatedIpRequest method.
//    req, resp := client.GetDedicatedIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDedicatedIp
func (c *PinpointEmail) GetDedicatedIpRequest(input *GetDedicatedIpInput) (req *request.Request, output *GetDedicatedIpOutput) {
	op := &request.Operation{
		Name:       opGetDedicatedIp,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/dedicated-ips/{IP}",
	}

	if input == nil {
		input = &GetDedicatedIpInput{}
	}

	output = &GetDedicatedIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDedicatedIp API operation for Amazon Pinpoint Email Service.
//
// Get information about a dedicated IP address, including the name of the dedicated
// IP pool that it's associated with, as well information about the automatic
// warm-up process for the address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDedicatedIp for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDedicatedIp
func (c *PinpointEmail) GetDedicatedIp(input *GetDedicatedIpInput) (*GetDedicatedIpOutput, error) {
	req, out := c.GetDedicatedIpRequest(input)
	return out, req.Send()
}

// GetDedicatedIpWithContext is the same as GetDedicatedIp with the addition of
// the ability to pass a context and additional request options.
//
// See GetDedicatedIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDedicatedIpWithContext(ctx aws.Context, input *GetDedicatedIpInput, opts ...request.Option) (*GetDedicatedIpOutput, error) {
	req, out := c.GetDedicatedIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDedicatedIps = "GetDedicatedIps"

// GetDedicatedIpsRequest generates a "aws/request.Request" representing the
// client's request for the GetDedicatedIps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDedicatedIps for more information on using the GetDedicatedIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDedicatedIpsRequest method.
//    req, resp := client.GetDedicatedIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDedicatedIps
func (c *PinpointEmail) GetDedicatedIpsRequest(input *GetDedicatedIpsInput) (req *request.Request, output *GetDedicatedIpsOutput) {
	op := &request.Operation{
		Name:       opGetDedicatedIps,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/dedicated-ips",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDedicatedIpsInput{}
	}

	output = &GetDedicatedIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDedicatedIps API operation for Amazon Pinpoint Email Service.
//
// List the dedicated IP addresses that are associated with your Amazon Pinpoint
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDedicatedIps for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDedicatedIps
func (c *PinpointEmail) GetDedicatedIps(input *GetDedicatedIpsInput) (*GetDedicatedIpsOutput, error) {
	req, out := c.GetDedicatedIpsRequest(input)
	return out, req.Send()
}

// GetDedicatedIpsWithContext is the same as GetDedicatedIps with the addition of
// the ability to pass a context and additional request options.
//
// See GetDedicatedIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDedicatedIpsWithContext(ctx aws.Context, input *GetDedicatedIpsInput, opts ...request.Option) (*GetDedicatedIpsOutput, error) {
	req, out := c.GetDedicatedIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDedicatedIpsPages iterates over the pages of a GetDedicatedIps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDedicatedIps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDedicatedIps operation.
//    pageNum := 0
//    err := client.GetDedicatedIpsPages(params,
//        func(page *pinpointemail.GetDedicatedIpsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) GetDedicatedIpsPages(input *GetDedicatedIpsInput, fn func(*GetDedicatedIpsOutput, bool) bool) error {
	return c.GetDedicatedIpsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDedicatedIpsPagesWithContext same as GetDedicatedIpsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDedicatedIpsPagesWithContext(ctx aws.Context, input *GetDedicatedIpsInput, fn func(*GetDedicatedIpsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDedicatedIpsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDedicatedIpsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDedicatedIpsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDeliverabilityDashboardOptions = "GetDeliverabilityDashboardOptions"

// GetDeliverabilityDashboardOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeliverabilityDashboardOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeliverabilityDashboardOptions for more information on using the GetDeliverabilityDashboardOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeliverabilityDashboardOptionsRequest method.
//    req, resp := client.GetDeliverabilityDashboardOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDeliverabilityDashboardOptions
func (c *PinpointEmail) GetDeliverabilityDashboardOptionsRequest(input *GetDeliverabilityDashboardOptionsInput) (req *request.Request, output *GetDeliverabilityDashboardOptionsOutput) {
	op := &request.Operation{
		Name:       opGetDeliverabilityDashboardOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard",
	}

	if input == nil {
		input = &GetDeliverabilityDashboardOptionsInput{}
	}

	output = &GetDeliverabilityDashboardOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeliverabilityDashboardOptions API operation for Amazon Pinpoint Email Service.
//
// Retrieve information about the status of the Deliverability dashboard for
// your Amazon Pinpoint account. When the Deliverability dashboard is enabled,
// you gain access to reputation, deliverability, and other metrics for the
// domains that you use to send email using Amazon Pinpoint. You also gain the
// ability to perform predictive inbox placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon Pinpoint.
// For more information about the features and cost of a Deliverability dashboard
// subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDeliverabilityDashboardOptions for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDeliverabilityDashboardOptions
func (c *PinpointEmail) GetDeliverabilityDashboardOptions(input *GetDeliverabilityDashboardOptionsInput) (*GetDeliverabilityDashboardOptionsOutput, error) {
	req, out := c.GetDeliverabilityDashboardOptionsRequest(input)
	return out, req.Send()
}

// GetDeliverabilityDashboardOptionsWithContext is the same as GetDeliverabilityDashboardOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeliverabilityDashboardOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDeliverabilityDashboardOptionsWithContext(ctx aws.Context, input *GetDeliverabilityDashboardOptionsInput, opts ...request.Option) (*GetDeliverabilityDashboardOptionsOutput, error) {
	req, out := c.GetDeliverabilityDashboardOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeliverabilityTestReport = "GetDeliverabilityTestReport"

// GetDeliverabilityTestReportRequest generates a "aws/request.Request" representing the
// client's request for the GetDeliverabilityTestReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeliverabilityTestReport for more information on using the GetDeliverabilityTestReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeliverabilityTestReportRequest method.
//    req, resp := client.GetDeliverabilityTestReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDeliverabilityTestReport
func (c *PinpointEmail) GetDeliverabilityTestReportRequest(input *GetDeliverabilityTestReportInput) (req *request.Request, output *GetDeliverabilityTestReportOutput) {
	op := &request.Operation{
		Name:       opGetDeliverabilityTestReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/test-reports/{ReportId}",
	}

	if input == nil {
		input = &GetDeliverabilityTestReportInput{}
	}

	output = &GetDeliverabilityTestReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeliverabilityTestReport API operation for Amazon Pinpoint Email Service.
//
// Retrieve the results of a predictive inbox placement test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDeliverabilityTestReport for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDeliverabilityTestReport
func (c *PinpointEmail) GetDeliverabilityTestReport(input *GetDeliverabilityTestReportInput) (*GetDeliverabilityTestReportOutput, error) {
	req, out := c.GetDeliverabilityTestReportRequest(input)
	return out, req.Send()
}

// GetDeliverabilityTestReportWithContext is the same as GetDeliverabilityTestReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeliverabilityTestReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDeliverabilityTestReportWithContext(ctx aws.Context, input *GetDeliverabilityTestReportInput, opts ...request.Option) (*GetDeliverabilityTestReportOutput, error) {
	req, out := c.GetDeliverabilityTestReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainDeliverabilityCampaign = "GetDomainDeliverabilityCampaign"

// GetDomainDeliverabilityCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainDeliverabilityCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainDeliverabilityCampaign for more information on using the GetDomainDeliverabilityCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainDeliverabilityCampaignRequest method.
//    req, resp := client.GetDomainDeliverabilityCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDomainDeliverabilityCampaign
func (c *PinpointEmail) GetDomainDeliverabilityCampaignRequest(input *GetDomainDeliverabilityCampaignInput) (req *request.Request, output *GetDomainDeliverabilityCampaignOutput) {
	op := &request.Operation{
		Name:       opGetDomainDeliverabilityCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/campaigns/{CampaignId}",
	}

	if input == nil {
		input = &GetDomainDeliverabilityCampaignInput{}
	}

	output = &GetDomainDeliverabilityCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainDeliverabilityCampaign API operation for Amazon Pinpoint Email Service.
//
// Retrieve all the deliverability data for a specific campaign. This data is
// available for a campaign only if the campaign sent email by using a domain
// that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDomainDeliverabilityCampaign for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDomainDeliverabilityCampaign
func (c *PinpointEmail) GetDomainDeliverabilityCampaign(input *GetDomainDeliverabilityCampaignInput) (*GetDomainDeliverabilityCampaignOutput, error) {
	req, out := c.GetDomainDeliverabilityCampaignRequest(input)
	return out, req.Send()
}

// GetDomainDeliverabilityCampaignWithContext is the same as GetDomainDeliverabilityCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainDeliverabilityCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDomainDeliverabilityCampaignWithContext(ctx aws.Context, input *GetDomainDeliverabilityCampaignInput, opts ...request.Option) (*GetDomainDeliverabilityCampaignOutput, error) {
	req, out := c.GetDomainDeliverabilityCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainStatisticsReport = "GetDomainStatisticsReport"

// GetDomainStatisticsReportRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainStatisticsReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainStatisticsReport for more information on using the GetDomainStatisticsReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainStatisticsReportRequest method.
//    req, resp := client.GetDomainStatisticsReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDomainStatisticsReport
func (c *PinpointEmail) GetDomainStatisticsReportRequest(input *GetDomainStatisticsReportInput) (req *request.Request, output *GetDomainStatisticsReportOutput) {
	op := &request.Operation{
		Name:       opGetDomainStatisticsReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/statistics-report/{Domain}",
	}

	if input == nil {
		input = &GetDomainStatisticsReportInput{}
	}

	output = &GetDomainStatisticsReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainStatisticsReport API operation for Amazon Pinpoint Email Service.
//
// Retrieve inbox placement and engagement rates for the domains that you use
// to send email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetDomainStatisticsReport for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetDomainStatisticsReport
func (c *PinpointEmail) GetDomainStatisticsReport(input *GetDomainStatisticsReportInput) (*GetDomainStatisticsReportOutput, error) {
	req, out := c.GetDomainStatisticsReportRequest(input)
	return out, req.Send()
}

// GetDomainStatisticsReportWithContext is the same as GetDomainStatisticsReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainStatisticsReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetDomainStatisticsReportWithContext(ctx aws.Context, input *GetDomainStatisticsReportInput, opts ...request.Option) (*GetDomainStatisticsReportOutput, error) {
	req, out := c.GetDomainStatisticsReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailIdentity = "GetEmailIdentity"

// GetEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailIdentity for more information on using the GetEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailIdentityRequest method.
//    req, resp := client.GetEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetEmailIdentity
func (c *PinpointEmail) GetEmailIdentityRequest(input *GetEmailIdentityInput) (req *request.Request, output *GetEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opGetEmailIdentity,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}",
	}

	if input == nil {
		input = &GetEmailIdentityInput{}
	}

	output = &GetEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailIdentity API operation for Amazon Pinpoint Email Service.
//
// Provides information about a specific identity associated with your Amazon
// Pinpoint account, including the identity's verification status, its DKIM
// authentication status, and its custom Mail-From settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation GetEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/GetEmailIdentity
func (c *PinpointEmail) GetEmailIdentity(input *GetEmailIdentityInput) (*GetEmailIdentityOutput, error) {
	req, out := c.GetEmailIdentityRequest(input)
	return out, req.Send()
}

// GetEmailIdentityWithContext is the same as GetEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) GetEmailIdentityWithContext(ctx aws.Context, input *GetEmailIdentityInput, opts ...request.Option) (*GetEmailIdentityOutput, error) {
	req, out := c.GetEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationSets for more information on using the ListConfigurationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationSetsRequest method.
//    req, resp := client.ListConfigurationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListConfigurationSets
func (c *PinpointEmail) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) (req *request.Request, output *ListConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/configuration-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	output = &ListConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationSets API operation for Amazon Pinpoint Email Service.
//
// List all of the configuration sets associated with your Amazon Pinpoint account
// in the current region.
//
// In Amazon Pinpoint, configuration sets are groups of rules that you can apply
// to the emails you send. You apply a configuration set to an email by including
// a reference to the configuration set in the headers of the email. When you
// apply a configuration set to an email, all of the rules in that configuration
// set are applied to the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListConfigurationSets for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListConfigurationSets
func (c *PinpointEmail) ListConfigurationSets(input *ListConfigurationSetsInput) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	return out, req.Send()
}

// ListConfigurationSetsWithContext is the same as ListConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListConfigurationSetsWithContext(ctx aws.Context, input *ListConfigurationSetsInput, opts ...request.Option) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationSetsPages iterates over the pages of a ListConfigurationSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigurationSets operation.
//    pageNum := 0
//    err := client.ListConfigurationSetsPages(params,
//        func(page *pinpointemail.ListConfigurationSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) ListConfigurationSetsPages(input *ListConfigurationSetsInput, fn func(*ListConfigurationSetsOutput, bool) bool) error {
	return c.ListConfigurationSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationSetsPagesWithContext same as ListConfigurationSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListConfigurationSetsPagesWithContext(ctx aws.Context, input *ListConfigurationSetsInput, fn func(*ListConfigurationSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDedicatedIpPools = "ListDedicatedIpPools"

// ListDedicatedIpPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListDedicatedIpPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDedicatedIpPools for more information on using the ListDedicatedIpPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDedicatedIpPoolsRequest method.
//    req, resp := client.ListDedicatedIpPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDedicatedIpPools
func (c *PinpointEmail) ListDedicatedIpPoolsRequest(input *ListDedicatedIpPoolsInput) (req *request.Request, output *ListDedicatedIpPoolsOutput) {
	op := &request.Operation{
		Name:       opListDedicatedIpPools,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/dedicated-ip-pools",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDedicatedIpPoolsInput{}
	}

	output = &ListDedicatedIpPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDedicatedIpPools API operation for Amazon Pinpoint Email Service.
//
// List all of the dedicated IP pools that exist in your Amazon Pinpoint account
// in the current AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListDedicatedIpPools for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDedicatedIpPools
func (c *PinpointEmail) ListDedicatedIpPools(input *ListDedicatedIpPoolsInput) (*ListDedicatedIpPoolsOutput, error) {
	req, out := c.ListDedicatedIpPoolsRequest(input)
	return out, req.Send()
}

// ListDedicatedIpPoolsWithContext is the same as ListDedicatedIpPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListDedicatedIpPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDedicatedIpPoolsWithContext(ctx aws.Context, input *ListDedicatedIpPoolsInput, opts ...request.Option) (*ListDedicatedIpPoolsOutput, error) {
	req, out := c.ListDedicatedIpPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDedicatedIpPoolsPages iterates over the pages of a ListDedicatedIpPools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDedicatedIpPools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDedicatedIpPools operation.
//    pageNum := 0
//    err := client.ListDedicatedIpPoolsPages(params,
//        func(page *pinpointemail.ListDedicatedIpPoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) ListDedicatedIpPoolsPages(input *ListDedicatedIpPoolsInput, fn func(*ListDedicatedIpPoolsOutput, bool) bool) error {
	return c.ListDedicatedIpPoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDedicatedIpPoolsPagesWithContext same as ListDedicatedIpPoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDedicatedIpPoolsPagesWithContext(ctx aws.Context, input *ListDedicatedIpPoolsInput, fn func(*ListDedicatedIpPoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDedicatedIpPoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDedicatedIpPoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDedicatedIpPoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeliverabilityTestReports = "ListDeliverabilityTestReports"

// ListDeliverabilityTestReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeliverabilityTestReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeliverabilityTestReports for more information on using the ListDeliverabilityTestReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeliverabilityTestReportsRequest method.
//    req, resp := client.ListDeliverabilityTestReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDeliverabilityTestReports
func (c *PinpointEmail) ListDeliverabilityTestReportsRequest(input *ListDeliverabilityTestReportsInput) (req *request.Request, output *ListDeliverabilityTestReportsOutput) {
	op := &request.Operation{
		Name:       opListDeliverabilityTestReports,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/test-reports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeliverabilityTestReportsInput{}
	}

	output = &ListDeliverabilityTestReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeliverabilityTestReports API operation for Amazon Pinpoint Email Service.
//
// Show a list of the predictive inbox placement tests that you've performed,
// regardless of their statuses. For predictive inbox placement tests that are
// complete, you can use the GetDeliverabilityTestReport operation to view the
// results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListDeliverabilityTestReports for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDeliverabilityTestReports
func (c *PinpointEmail) ListDeliverabilityTestReports(input *ListDeliverabilityTestReportsInput) (*ListDeliverabilityTestReportsOutput, error) {
	req, out := c.ListDeliverabilityTestReportsRequest(input)
	return out, req.Send()
}

// ListDeliverabilityTestReportsWithContext is the same as ListDeliverabilityTestReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeliverabilityTestReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDeliverabilityTestReportsWithContext(ctx aws.Context, input *ListDeliverabilityTestReportsInput, opts ...request.Option) (*ListDeliverabilityTestReportsOutput, error) {
	req, out := c.ListDeliverabilityTestReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeliverabilityTestReportsPages iterates over the pages of a ListDeliverabilityTestReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeliverabilityTestReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeliverabilityTestReports operation.
//    pageNum := 0
//    err := client.ListDeliverabilityTestReportsPages(params,
//        func(page *pinpointemail.ListDeliverabilityTestReportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) ListDeliverabilityTestReportsPages(input *ListDeliverabilityTestReportsInput, fn func(*ListDeliverabilityTestReportsOutput, bool) bool) error {
	return c.ListDeliverabilityTestReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeliverabilityTestReportsPagesWithContext same as ListDeliverabilityTestReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDeliverabilityTestReportsPagesWithContext(ctx aws.Context, input *ListDeliverabilityTestReportsInput, fn func(*ListDeliverabilityTestReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeliverabilityTestReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeliverabilityTestReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeliverabilityTestReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomainDeliverabilityCampaigns = "ListDomainDeliverabilityCampaigns"

// ListDomainDeliverabilityCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainDeliverabilityCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainDeliverabilityCampaigns for more information on using the ListDomainDeliverabilityCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainDeliverabilityCampaignsRequest method.
//    req, resp := client.ListDomainDeliverabilityCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDomainDeliverabilityCampaigns
func (c *PinpointEmail) ListDomainDeliverabilityCampaignsRequest(input *ListDomainDeliverabilityCampaignsInput) (req *request.Request, output *ListDomainDeliverabilityCampaignsOutput) {
	op := &request.Operation{
		Name:       opListDomainDeliverabilityCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainDeliverabilityCampaignsInput{}
	}

	output = &ListDomainDeliverabilityCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainDeliverabilityCampaigns API operation for Amazon Pinpoint Email Service.
//
// Retrieve deliverability data for all the campaigns that used a specific domain
// to send email during a specified time range. This data is available for a
// domain only if you enabled the Deliverability dashboard (PutDeliverabilityDashboardOption
// operation) for the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListDomainDeliverabilityCampaigns for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListDomainDeliverabilityCampaigns
func (c *PinpointEmail) ListDomainDeliverabilityCampaigns(input *ListDomainDeliverabilityCampaignsInput) (*ListDomainDeliverabilityCampaignsOutput, error) {
	req, out := c.ListDomainDeliverabilityCampaignsRequest(input)
	return out, req.Send()
}

// ListDomainDeliverabilityCampaignsWithContext is the same as ListDomainDeliverabilityCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainDeliverabilityCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDomainDeliverabilityCampaignsWithContext(ctx aws.Context, input *ListDomainDeliverabilityCampaignsInput, opts ...request.Option) (*ListDomainDeliverabilityCampaignsOutput, error) {
	req, out := c.ListDomainDeliverabilityCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainDeliverabilityCampaignsPages iterates over the pages of a ListDomainDeliverabilityCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainDeliverabilityCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomainDeliverabilityCampaigns operation.
//    pageNum := 0
//    err := client.ListDomainDeliverabilityCampaignsPages(params,
//        func(page *pinpointemail.ListDomainDeliverabilityCampaignsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) ListDomainDeliverabilityCampaignsPages(input *ListDomainDeliverabilityCampaignsInput, fn func(*ListDomainDeliverabilityCampaignsOutput, bool) bool) error {
	return c.ListDomainDeliverabilityCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainDeliverabilityCampaignsPagesWithContext same as ListDomainDeliverabilityCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListDomainDeliverabilityCampaignsPagesWithContext(ctx aws.Context, input *ListDomainDeliverabilityCampaignsInput, fn func(*ListDomainDeliverabilityCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainDeliverabilityCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainDeliverabilityCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainDeliverabilityCampaignsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEmailIdentities = "ListEmailIdentities"

// ListEmailIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListEmailIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEmailIdentities for more information on using the ListEmailIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEmailIdentitiesRequest method.
//    req, resp := client.ListEmailIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListEmailIdentities
func (c *PinpointEmail) ListEmailIdentitiesRequest(input *ListEmailIdentitiesInput) (req *request.Request, output *ListEmailIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListEmailIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/identities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEmailIdentitiesInput{}
	}

	output = &ListEmailIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEmailIdentities API operation for Amazon Pinpoint Email Service.
//
// Returns a list of all of the email identities that are associated with your
// Amazon Pinpoint account. An identity can be either an email address or a
// domain. This operation returns identities that are verified as well as those
// that aren't.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListEmailIdentities for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListEmailIdentities
func (c *PinpointEmail) ListEmailIdentities(input *ListEmailIdentitiesInput) (*ListEmailIdentitiesOutput, error) {
	req, out := c.ListEmailIdentitiesRequest(input)
	return out, req.Send()
}

// ListEmailIdentitiesWithContext is the same as ListEmailIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListEmailIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListEmailIdentitiesWithContext(ctx aws.Context, input *ListEmailIdentitiesInput, opts ...request.Option) (*ListEmailIdentitiesOutput, error) {
	req, out := c.ListEmailIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEmailIdentitiesPages iterates over the pages of a ListEmailIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEmailIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEmailIdentities operation.
//    pageNum := 0
//    err := client.ListEmailIdentitiesPages(params,
//        func(page *pinpointemail.ListEmailIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointEmail) ListEmailIdentitiesPages(input *ListEmailIdentitiesInput, fn func(*ListEmailIdentitiesOutput, bool) bool) error {
	return c.ListEmailIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEmailIdentitiesPagesWithContext same as ListEmailIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListEmailIdentitiesPagesWithContext(ctx aws.Context, input *ListEmailIdentitiesInput, fn func(*ListEmailIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEmailIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEmailIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEmailIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListTagsForResource
func (c *PinpointEmail) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Pinpoint Email Service.
//
// Retrieve a list of the tags (keys and values) that are associated with a
// specified resource. A tag is a label that you optionally define and associate
// with a resource in Amazon Pinpoint. Each tag consists of a required tag key
// and an optional associated tag value. A tag key is a general label that acts
// as a category for more specific tag values. A tag value acts as a descriptor
// within a tag key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListTagsForResource
func (c *PinpointEmail) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountDedicatedIpWarmupAttributes = "PutAccountDedicatedIpWarmupAttributes"

// PutAccountDedicatedIpWarmupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountDedicatedIpWarmupAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountDedicatedIpWarmupAttributes for more information on using the PutAccountDedicatedIpWarmupAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountDedicatedIpWarmupAttributesRequest method.
//    req, resp := client.PutAccountDedicatedIpWarmupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutAccountDedicatedIpWarmupAttributes
func (c *PinpointEmail) PutAccountDedicatedIpWarmupAttributesRequest(input *PutAccountDedicatedIpWarmupAttributesInput) (req *request.Request, output *PutAccountDedicatedIpWarmupAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAccountDedicatedIpWarmupAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/account/dedicated-ips/warmup",
	}

	if input == nil {
		input = &PutAccountDedicatedIpWarmupAttributesInput{}
	}

	output = &PutAccountDedicatedIpWarmupAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountDedicatedIpWarmupAttributes API operation for Amazon Pinpoint Email Service.
//
// Enable or disable the automatic warm-up feature for dedicated IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutAccountDedicatedIpWarmupAttributes for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutAccountDedicatedIpWarmupAttributes
func (c *PinpointEmail) PutAccountDedicatedIpWarmupAttributes(input *PutAccountDedicatedIpWarmupAttributesInput) (*PutAccountDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutAccountDedicatedIpWarmupAttributesRequest(input)
	return out, req.Send()
}

// PutAccountDedicatedIpWarmupAttributesWithContext is the same as PutAccountDedicatedIpWarmupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountDedicatedIpWarmupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutAccountDedicatedIpWarmupAttributesWithContext(ctx aws.Context, input *PutAccountDedicatedIpWarmupAttributesInput, opts ...request.Option) (*PutAccountDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutAccountDedicatedIpWarmupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountSendingAttributes = "PutAccountSendingAttributes"

// PutAccountSendingAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSendingAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSendingAttributes for more information on using the PutAccountSendingAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountSendingAttributesRequest method.
//    req, resp := client.PutAccountSendingAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutAccountSendingAttributes
func (c *PinpointEmail) PutAccountSendingAttributesRequest(input *PutAccountSendingAttributesInput) (req *request.Request, output *PutAccountSendingAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAccountSendingAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/account/sending",
	}

	if input == nil {
		input = &PutAccountSendingAttributesInput{}
	}

	output = &PutAccountSendingAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountSendingAttributes API operation for Amazon Pinpoint Email Service.
//
// Enable or disable the ability of your account to send email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutAccountSendingAttributes for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutAccountSendingAttributes
func (c *PinpointEmail) PutAccountSendingAttributes(input *PutAccountSendingAttributesInput) (*PutAccountSendingAttributesOutput, error) {
	req, out := c.PutAccountSendingAttributesRequest(input)
	return out, req.Send()
}

// PutAccountSendingAttributesWithContext is the same as PutAccountSendingAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSendingAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutAccountSendingAttributesWithContext(ctx aws.Context, input *PutAccountSendingAttributesInput, opts ...request.Option) (*PutAccountSendingAttributesOutput, error) {
	req, out := c.PutAccountSendingAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetDeliveryOptions = "PutConfigurationSetDeliveryOptions"

// PutConfigurationSetDeliveryOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetDeliveryOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetDeliveryOptions for more information on using the PutConfigurationSetDeliveryOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetDeliveryOptionsRequest method.
//    req, resp := client.PutConfigurationSetDeliveryOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetDeliveryOptions
func (c *PinpointEmail) PutConfigurationSetDeliveryOptionsRequest(input *PutConfigurationSetDeliveryOptionsInput) (req *request.Request, output *PutConfigurationSetDeliveryOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetDeliveryOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/delivery-options",
	}

	if input == nil {
		input = &PutConfigurationSetDeliveryOptionsInput{}
	}

	output = &PutConfigurationSetDeliveryOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetDeliveryOptions API operation for Amazon Pinpoint Email Service.
//
// Associate a configuration set with a dedicated IP pool. You can use dedicated
// IP pools to create groups of dedicated IP addresses for sending specific
// types of email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutConfigurationSetDeliveryOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetDeliveryOptions
func (c *PinpointEmail) PutConfigurationSetDeliveryOptions(input *PutConfigurationSetDeliveryOptionsInput) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetDeliveryOptionsWithContext is the same as PutConfigurationSetDeliveryOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetDeliveryOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutConfigurationSetDeliveryOptionsWithContext(ctx aws.Context, input *PutConfigurationSetDeliveryOptionsInput, opts ...request.Option) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetReputationOptions = "PutConfigurationSetReputationOptions"

// PutConfigurationSetReputationOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetReputationOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetReputationOptions for more information on using the PutConfigurationSetReputationOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetReputationOptionsRequest method.
//    req, resp := client.PutConfigurationSetReputationOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetReputationOptions
func (c *PinpointEmail) PutConfigurationSetReputationOptionsRequest(input *PutConfigurationSetReputationOptionsInput) (req *request.Request, output *PutConfigurationSetReputationOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetReputationOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/reputation-options",
	}

	if input == nil {
		input = &PutConfigurationSetReputationOptionsInput{}
	}

	output = &PutConfigurationSetReputationOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetReputationOptions API operation for Amazon Pinpoint Email Service.
//
// Enable or disable collection of reputation metrics for emails that you send
// using a particular configuration set in a specific AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutConfigurationSetReputationOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetReputationOptions
func (c *PinpointEmail) PutConfigurationSetReputationOptions(input *PutConfigurationSetReputationOptionsInput) (*PutConfigurationSetReputationOptionsOutput, error) {
	req, out := c.PutConfigurationSetReputationOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetReputationOptionsWithContext is the same as PutConfigurationSetReputationOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetReputationOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutConfigurationSetReputationOptionsWithContext(ctx aws.Context, input *PutConfigurationSetReputationOptionsInput, opts ...request.Option) (*PutConfigurationSetReputationOptionsOutput, error) {
	req, out := c.PutConfigurationSetReputationOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetSendingOptions = "PutConfigurationSetSendingOptions"

// PutConfigurationSetSendingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetSendingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetSendingOptions for more information on using the PutConfigurationSetSendingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetSendingOptionsRequest method.
//    req, resp := client.PutConfigurationSetSendingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetSendingOptions
func (c *PinpointEmail) PutConfigurationSetSendingOptionsRequest(input *PutConfigurationSetSendingOptionsInput) (req *request.Request, output *PutConfigurationSetSendingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetSendingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/sending",
	}

	if input == nil {
		input = &PutConfigurationSetSendingOptionsInput{}
	}

	output = &PutConfigurationSetSendingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetSendingOptions API operation for Amazon Pinpoint Email Service.
//
// Enable or disable email sending for messages that use a particular configuration
// set in a specific AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutConfigurationSetSendingOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetSendingOptions
func (c *PinpointEmail) PutConfigurationSetSendingOptions(input *PutConfigurationSetSendingOptionsInput) (*PutConfigurationSetSendingOptionsOutput, error) {
	req, out := c.PutConfigurationSetSendingOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetSendingOptionsWithContext is the same as PutConfigurationSetSendingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetSendingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutConfigurationSetSendingOptionsWithContext(ctx aws.Context, input *PutConfigurationSetSendingOptionsInput, opts ...request.Option) (*PutConfigurationSetSendingOptionsOutput, error) {
	req, out := c.PutConfigurationSetSendingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetTrackingOptions = "PutConfigurationSetTrackingOptions"

// PutConfigurationSetTrackingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetTrackingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetTrackingOptions for more information on using the PutConfigurationSetTrackingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetTrackingOptionsRequest method.
//    req, resp := client.PutConfigurationSetTrackingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetTrackingOptions
func (c *PinpointEmail) PutConfigurationSetTrackingOptionsRequest(input *PutConfigurationSetTrackingOptionsInput) (req *request.Request, output *PutConfigurationSetTrackingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetTrackingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options",
	}

	if input == nil {
		input = &PutConfigurationSetTrackingOptionsInput{}
	}

	output = &PutConfigurationSetTrackingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetTrackingOptions API operation for Amazon Pinpoint Email Service.
//
// Specify a custom domain to use for open and click tracking elements in email
// that you send using Amazon Pinpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutConfigurationSetTrackingOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetTrackingOptions
func (c *PinpointEmail) PutConfigurationSetTrackingOptions(input *PutConfigurationSetTrackingOptionsInput) (*PutConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.PutConfigurationSetTrackingOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetTrackingOptionsWithContext is the same as PutConfigurationSetTrackingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetTrackingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutConfigurationSetTrackingOptionsWithContext(ctx aws.Context, input *PutConfigurationSetTrackingOptionsInput, opts ...request.Option) (*PutConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.PutConfigurationSetTrackingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDedicatedIpInPool = "PutDedicatedIpInPool"

// PutDedicatedIpInPoolRequest generates a "aws/request.Request" representing the
// client's request for the PutDedicatedIpInPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDedicatedIpInPool for more information on using the PutDedicatedIpInPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDedicatedIpInPoolRequest method.
//    req, resp := client.PutDedicatedIpInPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDedicatedIpInPool
func (c *PinpointEmail) PutDedicatedIpInPoolRequest(input *PutDedicatedIpInPoolInput) (req *request.Request, output *PutDedicatedIpInPoolOutput) {
	op := &request.Operation{
		Name:       opPutDedicatedIpInPool,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/dedicated-ips/{IP}/pool",
	}

	if input == nil {
		input = &PutDedicatedIpInPoolInput{}
	}

	output = &PutDedicatedIpInPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDedicatedIpInPool API operation for Amazon Pinpoint Email Service.
//
// Move a dedicated IP address to an existing dedicated IP pool.
//
// The dedicated IP address that you specify must already exist, and must be
// associated with your Amazon Pinpoint account.
//
// The dedicated IP pool you specify must already exist. You can create a new
// pool by using the CreateDedicatedIpPool operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutDedicatedIpInPool for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDedicatedIpInPool
func (c *PinpointEmail) PutDedicatedIpInPool(input *PutDedicatedIpInPoolInput) (*PutDedicatedIpInPoolOutput, error) {
	req, out := c.PutDedicatedIpInPoolRequest(input)
	return out, req.Send()
}

// PutDedicatedIpInPoolWithContext is the same as PutDedicatedIpInPool with the addition of
// the ability to pass a context and additional request options.
//
// See PutDedicatedIpInPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutDedicatedIpInPoolWithContext(ctx aws.Context, input *PutDedicatedIpInPoolInput, opts ...request.Option) (*PutDedicatedIpInPoolOutput, error) {
	req, out := c.PutDedicatedIpInPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDedicatedIpWarmupAttributes = "PutDedicatedIpWarmupAttributes"

// PutDedicatedIpWarmupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutDedicatedIpWarmupAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDedicatedIpWarmupAttributes for more information on using the PutDedicatedIpWarmupAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDedicatedIpWarmupAttributesRequest method.
//    req, resp := client.PutDedicatedIpWarmupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDedicatedIpWarmupAttributes
func (c *PinpointEmail) PutDedicatedIpWarmupAttributesRequest(input *PutDedicatedIpWarmupAttributesInput) (req *request.Request, output *PutDedicatedIpWarmupAttributesOutput) {
	op := &request.Operation{
		Name:       opPutDedicatedIpWarmupAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/dedicated-ips/{IP}/warmup",
	}

	if input == nil {
		input = &PutDedicatedIpWarmupAttributesInput{}
	}

	output = &PutDedicatedIpWarmupAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDedicatedIpWarmupAttributes API operation for Amazon Pinpoint Email Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutDedicatedIpWarmupAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDedicatedIpWarmupAttributes
func (c *PinpointEmail) PutDedicatedIpWarmupAttributes(input *PutDedicatedIpWarmupAttributesInput) (*PutDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutDedicatedIpWarmupAttributesRequest(input)
	return out, req.Send()
}

// PutDedicatedIpWarmupAttributesWithContext is the same as PutDedicatedIpWarmupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutDedicatedIpWarmupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutDedicatedIpWarmupAttributesWithContext(ctx aws.Context, input *PutDedicatedIpWarmupAttributesInput, opts ...request.Option) (*PutDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutDedicatedIpWarmupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDeliverabilityDashboardOption = "PutDeliverabilityDashboardOption"

// PutDeliverabilityDashboardOptionRequest generates a "aws/request.Request" representing the
// client's request for the PutDeliverabilityDashboardOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDeliverabilityDashboardOption for more information on using the PutDeliverabilityDashboardOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDeliverabilityDashboardOptionRequest method.
//    req, resp := client.PutDeliverabilityDashboardOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDeliverabilityDashboardOption
func (c *PinpointEmail) PutDeliverabilityDashboardOptionRequest(input *PutDeliverabilityDashboardOptionInput) (req *request.Request, output *PutDeliverabilityDashboardOptionOutput) {
	op := &request.Operation{
		Name:       opPutDeliverabilityDashboardOption,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/deliverability-dashboard",
	}

	if input == nil {
		input = &PutDeliverabilityDashboardOptionInput{}
	}

	output = &PutDeliverabilityDashboardOptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDeliverabilityDashboardOption API operation for Amazon Pinpoint Email Service.
//
// Enable or disable the Deliverability dashboard for your Amazon Pinpoint account.
// When you enable the Deliverability dashboard, you gain access to reputation,
// deliverability, and other metrics for the domains that you use to send email
// using Amazon Pinpoint. You also gain the ability to perform predictive inbox
// placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon Pinpoint.
// For more information about the features and cost of a Deliverability dashboard
// subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutDeliverabilityDashboardOption for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutDeliverabilityDashboardOption
func (c *PinpointEmail) PutDeliverabilityDashboardOption(input *PutDeliverabilityDashboardOptionInput) (*PutDeliverabilityDashboardOptionOutput, error) {
	req, out := c.PutDeliverabilityDashboardOptionRequest(input)
	return out, req.Send()
}

// PutDeliverabilityDashboardOptionWithContext is the same as PutDeliverabilityDashboardOption with the addition of
// the ability to pass a context and additional request options.
//
// See PutDeliverabilityDashboardOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutDeliverabilityDashboardOptionWithContext(ctx aws.Context, input *PutDeliverabilityDashboardOptionInput, opts ...request.Option) (*PutDeliverabilityDashboardOptionOutput, error) {
	req, out := c.PutDeliverabilityDashboardOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityDkimAttributes = "PutEmailIdentityDkimAttributes"

// PutEmailIdentityDkimAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityDkimAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityDkimAttributes for more information on using the PutEmailIdentityDkimAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityDkimAttributesRequest method.
//    req, resp := client.PutEmailIdentityDkimAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityDkimAttributes
func (c *PinpointEmail) PutEmailIdentityDkimAttributesRequest(input *PutEmailIdentityDkimAttributesInput) (req *request.Request, output *PutEmailIdentityDkimAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityDkimAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}/dkim",
	}

	if input == nil {
		input = &PutEmailIdentityDkimAttributesInput{}
	}

	output = &PutEmailIdentityDkimAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityDkimAttributes API operation for Amazon Pinpoint Email Service.
//
// Used to enable or disable DKIM authentication for an email identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutEmailIdentityDkimAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityDkimAttributes
func (c *PinpointEmail) PutEmailIdentityDkimAttributes(input *PutEmailIdentityDkimAttributesInput) (*PutEmailIdentityDkimAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityDkimAttributesWithContext is the same as PutEmailIdentityDkimAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityDkimAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutEmailIdentityDkimAttributesWithContext(ctx aws.Context, input *PutEmailIdentityDkimAttributesInput, opts ...request.Option) (*PutEmailIdentityDkimAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityFeedbackAttributes = "PutEmailIdentityFeedbackAttributes"

// PutEmailIdentityFeedbackAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityFeedbackAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityFeedbackAttributes for more information on using the PutEmailIdentityFeedbackAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityFeedbackAttributesRequest method.
//    req, resp := client.PutEmailIdentityFeedbackAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityFeedbackAttributes
func (c *PinpointEmail) PutEmailIdentityFeedbackAttributesRequest(input *PutEmailIdentityFeedbackAttributesInput) (req *request.Request, output *PutEmailIdentityFeedbackAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityFeedbackAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}/feedback",
	}

	if input == nil {
		input = &PutEmailIdentityFeedbackAttributesInput{}
	}

	output = &PutEmailIdentityFeedbackAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityFeedbackAttributes API operation for Amazon Pinpoint Email Service.
//
// Used to enable or disable feedback forwarding for an identity. This setting
// determines what happens when an identity is used to send an email that results
// in a bounce or complaint event.
//
// When you enable feedback forwarding, Amazon Pinpoint sends you email notifications
// when bounce or complaint events occur. Amazon Pinpoint sends this notification
// to the address that you specified in the Return-Path header of the original
// email.
//
// When you disable feedback forwarding, Amazon Pinpoint sends notifications
// through other mechanisms, such as by notifying an Amazon SNS topic. You're
// required to have a method of tracking bounces and complaints. If you haven't
// set up another mechanism for receiving bounce or complaint notifications,
// Amazon Pinpoint sends an email notification when these events occur (even
// if this setting is disabled).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutEmailIdentityFeedbackAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityFeedbackAttributes
func (c *PinpointEmail) PutEmailIdentityFeedbackAttributes(input *PutEmailIdentityFeedbackAttributesInput) (*PutEmailIdentityFeedbackAttributesOutput, error) {
	req, out := c.PutEmailIdentityFeedbackAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityFeedbackAttributesWithContext is the same as PutEmailIdentityFeedbackAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityFeedbackAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutEmailIdentityFeedbackAttributesWithContext(ctx aws.Context, input *PutEmailIdentityFeedbackAttributesInput, opts ...request.Option) (*PutEmailIdentityFeedbackAttributesOutput, error) {
	req, out := c.PutEmailIdentityFeedbackAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityMailFromAttributes = "PutEmailIdentityMailFromAttributes"

// PutEmailIdentityMailFromAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityMailFromAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityMailFromAttributes for more information on using the PutEmailIdentityMailFromAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityMailFromAttributesRequest method.
//    req, resp := client.PutEmailIdentityMailFromAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityMailFromAttributes
func (c *PinpointEmail) PutEmailIdentityMailFromAttributesRequest(input *PutEmailIdentityMailFromAttributesInput) (req *request.Request, output *PutEmailIdentityMailFromAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityMailFromAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}/mail-from",
	}

	if input == nil {
		input = &PutEmailIdentityMailFromAttributesInput{}
	}

	output = &PutEmailIdentityMailFromAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityMailFromAttributes API operation for Amazon Pinpoint Email Service.
//
// Used to enable or disable the custom Mail-From domain configuration for an
// email identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation PutEmailIdentityMailFromAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutEmailIdentityMailFromAttributes
func (c *PinpointEmail) PutEmailIdentityMailFromAttributes(input *PutEmailIdentityMailFromAttributesInput) (*PutEmailIdentityMailFromAttributesOutput, error) {
	req, out := c.PutEmailIdentityMailFromAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityMailFromAttributesWithContext is the same as PutEmailIdentityMailFromAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityMailFromAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) PutEmailIdentityMailFromAttributesWithContext(ctx aws.Context, input *PutEmailIdentityMailFromAttributesInput, opts ...request.Option) (*PutEmailIdentityMailFromAttributesOutput, error) {
	req, out := c.PutEmailIdentityMailFromAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEmail for more information on using the SendEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendEmailRequest method.
//    req, resp := client.SendEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/SendEmail
func (c *PinpointEmail) SendEmailRequest(input *SendEmailInput) (req *request.Request, output *SendEmailOutput) {
	op := &request.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/outbound-emails",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	output = &SendEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEmail API operation for Amazon Pinpoint Email Service.
//
// Sends an email message. You can use the Amazon Pinpoint Email API to send
// two types of messages:
//
//    * Simple – A standard email message. When you create this type of message,
//    you specify the sender, the recipient, and the message body, and Amazon
//    Pinpoint assembles the message for you.
//
//    * Raw – A raw, MIME-formatted email message. When you send this type
//    of email, you have to specify all of the message headers, as well as the
//    message body. You can use this message type to send messages that contain
//    attachments. The message that you specify has to be a valid MIME message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation SendEmail for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * AccountSuspendedException
//   The message can't be sent because the account's ability to send email has
//   been permanently restricted.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/SendEmail
func (c *PinpointEmail) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	return out, req.Send()
}

// SendEmailWithContext is the same as SendEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) SendEmailWithContext(ctx aws.Context, input *SendEmailInput, opts ...request.Option) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/TagResource
func (c *PinpointEmail) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/email/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Pinpoint Email Service.
//
// Add one or more tags (keys and values) to a specified resource. A tag is
// a label that you optionally define and associate with a resource in Amazon
// Pinpoint. Tags can help you categorize and manage resources in different
// ways, such as by purpose, owner, environment, or other criteria. A resource
// can have as many as 50 tags.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for more specific tag values. A tag value acts as a descriptor within a tag
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/TagResource
func (c *PinpointEmail) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/UntagResource
func (c *PinpointEmail) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/email/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Pinpoint Email Service.
//
// Remove one or more tags (keys and values) from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/UntagResource
func (c *PinpointEmail) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetEventDestination = "UpdateConfigurationSetEventDestination"

// UpdateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetEventDestination for more information on using the UpdateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigurationSetEventDestinationRequest method.
//    req, resp := client.UpdateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/UpdateConfigurationSetEventDestination
func (c *PinpointEmail) UpdateConfigurationSetEventDestinationRequest(input *UpdateConfigurationSetEventDestinationInput) (req *request.Request, output *UpdateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetEventDestination,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &UpdateConfigurationSetEventDestinationInput{}
	}

	output = &UpdateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetEventDestination API operation for Amazon Pinpoint Email Service.
//
// Update the configuration of an event destination for a configuration set.
//
// In Amazon Pinpoint, events include message sends, deliveries, opens, clicks,
// bounces, and complaints. Event destinations are places that you can send
// information about these events to. For example, you can send event data to
// Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint Email Service's
// API operation UpdateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/UpdateConfigurationSetEventDestination
func (c *PinpointEmail) UpdateConfigurationSetEventDestination(input *UpdateConfigurationSetEventDestinationInput) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetEventDestinationWithContext is the same as UpdateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointEmail) UpdateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *UpdateConfigurationSetEventDestinationInput, opts ...request.Option) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The message can't be sent because the account's ability to send email has
// been permanently restricted.
type AccountSuspendedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccountSuspendedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSuspendedException) GoString() string {
	return s.String()
}

func newErrorAccountSuspendedException(v protocol.ResponseMetadata) error {
	return &AccountSuspendedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountSuspendedException) Code() string {
	return "AccountSuspendedException"
}

// Message returns the exception's message.
func (s *AccountSuspendedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountSuspendedException) OrigErr() error {
	return nil
}

func (s *AccountSuspendedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountSuspendedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountSuspendedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified in your request already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input you provided is invalid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about a blacklisting event that impacts
// one of the dedicated IP addresses that is associated with your account.
type BlacklistEntry struct {
	_ struct{} `type:"structure"`

	// Additional information about the blacklisting event, as provided by the blacklist
	// maintainer.
	Description *string `type:"string"`

	// The time when the blacklisting event occurred, shown in Unix time format.
	ListingTime *time.Time `type:"timestamp"`

	// The name of the blacklist that the IP address appears on.
	RblName *string `type:"string"`
}

// String returns the string representation
func (s BlacklistEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlacklistEntry) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BlacklistEntry) SetDescription(v string) *BlacklistEntry {
	s.Description = &v
	return s
}

// SetListingTime sets the ListingTime field's value.
func (s *BlacklistEntry) SetListingTime(v time.Time) *BlacklistEntry {
	s.ListingTime = &v
	return s
}

// SetRblName sets the RblName field's value.
func (s *BlacklistEntry) SetRblName(v string) *BlacklistEntry {
	s.RblName = &v
	return s
}

// Represents the body of the email message.
type Body struct {
	_ struct{} `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that support HTML. HTML messages can include formatted text,
	// hyperlinks, images, and more.
	Html *Content `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that don't support HTML, or clients where the recipient has
	// disabled HTML rendering.
	Text *Content `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(request.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtml sets the Html field's value.
func (s *Body) SetHtml(v *Content) *Body {
	s.Html = v
	return s
}

// SetText sets the Text field's value.
func (s *Body) SetText(v *Content) *Body {
	s.Text = v
	return s
}

// An object that defines an Amazon CloudWatch destination for email events.
// You can use Amazon CloudWatch to monitor and gain insights on your email
// sending metrics.
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// An array of objects that define the dimensions to use when you send email
	// events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []*CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDestination"}
	if s.DimensionConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionConfigurations sets the DimensionConfigurations field's value.
func (s *CloudWatchDestination) SetDimensionConfigurations(v []*CloudWatchDimensionConfiguration) *CloudWatchDestination {
	s.DimensionConfigurations = v
	return s
}

// An object that defines the dimension configuration to use when you send Amazon
// Pinpoint email events to Amazon CloudWatch.
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you don't provide the value of the dimension when you send an email. This
	// value has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The location where Amazon Pinpoint finds the value of a dimension to publish
	// to Amazon CloudWatch. If you want Amazon Pinpoint to use the message tags
	// that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the
	// SendEmail/SendRawEmail API, choose messageTag. If you want Amazon Pinpoint
	// to use your own email headers, choose emailHeader. If you want Amazon Pinpoint
	// to use link tags, choose linkTags.
	//
	// DimensionValueSource is a required field
	DimensionValueSource *string `type:"string" required:"true" enum:"DimensionValueSource"`
}

// String returns the string representation
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDimensionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}
	if s.DefaultDimensionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultDimensionValue"))
	}
	if s.DimensionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionName"))
	}
	if s.DimensionValueSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultDimensionValue sets the DefaultDimensionValue field's value.
func (s *CloudWatchDimensionConfiguration) SetDefaultDimensionValue(v string) *CloudWatchDimensionConfiguration {
	s.DefaultDimensionValue = &v
	return s
}

// SetDimensionName sets the DimensionName field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionName(v string) *CloudWatchDimensionConfiguration {
	s.DimensionName = &v
	return s
}

// SetDimensionValueSource sets the DimensionValueSource field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionValueSource(v string) *CloudWatchDimensionConfiguration {
	s.DimensionValueSource = &v
	return s
}

// The resource is being modified by another operation or thread.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the content of the email, and optionally a character
// set specification.
type Content struct {
	_ struct{} `type:"structure"`

	// The character set for the content. Because of the constraints of the SMTP
	// protocol, Amazon Pinpoint uses 7-bit ASCII by default. If the text includes
	// characters outside of the ASCII range, you have to specify a character set.
	// For example, you could specify UTF-8, ISO-8859-1, or Shift_JIS.
	Charset *string `type:"string"`

	// The content of the message itself.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Content) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Content"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCharset sets the Charset field's value.
func (s *Content) SetCharset(v string) *Content {
	s.Charset = &v
	return s
}

// SetData sets the Data field's value.
func (s *Content) SetData(v string) *Content {
	s.Data = &v
	return s
}

// A request to add an event destination to a configuration set.
type CreateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to add an event destination
	// to.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines the event destination.
	//
	// EventDestination is a required field
	EventDestination *EventDestinationDefinition `type:"structure" required:"true"`

	// A name that identifies the event destination within the configuration set.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *CreateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *CreateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *CreateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// A request to create a configuration set.
type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// An object that defines the dedicated IP pool that is used to send emails
	// that you send using the configuration set.
	DeliveryOptions *DeliveryOptions `type:"structure"`

	// An object that defines whether or not Amazon Pinpoint collects reputation
	// metrics for the emails that you send that use the configuration set.
	ReputationOptions *ReputationOptions `type:"structure"`

	// An object that defines whether or not Amazon Pinpoint can send email that
	// you send using the configuration set.
	SendingOptions *SendingOptions `type:"structure"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the configuration set.
	Tags []*Tag `type:"list"`

	// An object that defines the open and click tracking options for emails that
	// you send using the configuration set.
	TrackingOptions *TrackingOptions `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrackingOptions != nil {
		if err := s.TrackingOptions.Validate(); err != nil {
			invalidParams.AddNested("TrackingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSetName(v string) *CreateConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *CreateConfigurationSetInput) SetDeliveryOptions(v *DeliveryOptions) *CreateConfigurationSetInput {
	s.DeliveryOptions = v
	return s
}

// SetReputationOptions sets the ReputationOptions field's value.
func (s *CreateConfigurationSetInput) SetReputationOptions(v *ReputationOptions) *CreateConfigurationSetInput {
	s.ReputationOptions = v
	return s
}

// SetSendingOptions sets the SendingOptions field's value.
func (s *CreateConfigurationSetInput) SetSendingOptions(v *SendingOptions) *CreateConfigurationSetInput {
	s.SendingOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationSetInput) SetTags(v []*Tag) *CreateConfigurationSetInput {
	s.Tags = v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *CreateConfigurationSetInput) SetTrackingOptions(v *TrackingOptions) *CreateConfigurationSetInput {
	s.TrackingOptions = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

// A request to create a new dedicated IP pool.
type CreateDedicatedIpPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool.
	//
	// PoolName is a required field
	PoolName *string `type:"string" required:"true"`

	// An object that defines the tags (keys and values) that you want to associate
	// with the pool.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDedicatedIpPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDedicatedIpPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDedicatedIpPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDedicatedIpPoolInput"}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolName sets the PoolName field's value.
func (s *CreateDedicatedIpPoolInput) SetPoolName(v string) *CreateDedicatedIpPoolInput {
	s.PoolName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDedicatedIpPoolInput) SetTags(v []*Tag) *CreateDedicatedIpPoolInput {
	s.Tags = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateDedicatedIpPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDedicatedIpPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDedicatedIpPoolOutput) GoString() string {
	return s.String()
}

// A request to perform a predictive inbox placement test. Predictive inbox
// placement tests can help you predict how your messages will be handled by
// various email providers around the world. When you perform a predictive inbox
// placement test, you provide a sample message that contains the content that
// you plan to send to your customers. Amazon Pinpoint then sends that message
// to special email addresses spread across several major email providers. After
// about 24 hours, the test is complete, and you can use the GetDeliverabilityTestReport
// operation to view the results of the test.
type CreateDeliverabilityTestReportInput struct {
	_ struct{} `type:"structure"`

	// The HTML body of the message that you sent when you performed the predictive
	// inbox placement test.
	//
	// Content is a required field
	Content *EmailContent `type:"structure" required:"true"`

	// The email address that the predictive inbox placement test email was sent
	// from.
	//
	// FromEmailAddress is a required field
	FromEmailAddress *string `type:"string" required:"true"`

	// A unique name that helps you to identify the predictive inbox placement test
	// when you retrieve the results.
	ReportName *string `type:"string"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the predictive inbox placement test.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDeliverabilityTestReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliverabilityTestReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeliverabilityTestReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeliverabilityTestReportInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.FromEmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromEmailAddress"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateDeliverabilityTestReportInput) SetContent(v *EmailContent) *CreateDeliverabilityTestReportInput {
	s.Content = v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CreateDeliverabilityTestReportInput) SetFromEmailAddress(v string) *CreateDeliverabilityTestReportInput {
	s.FromEmailAddress = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *CreateDeliverabilityTestReportInput) SetReportName(v string) *CreateDeliverabilityTestReportInput {
	s.ReportName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeliverabilityTestReportInput) SetTags(v []*Tag) *CreateDeliverabilityTestReportInput {
	s.Tags = v
	return s
}

// Information about the predictive inbox placement test that you created.
type CreateDeliverabilityTestReportOutput struct {
	_ struct{} `type:"structure"`

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS,
	// then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the
	// test. If the status is COMPLETE, then the test is finished, and you can use
	// the GetDeliverabilityTestReport to view the results of the test.
	//
	// DeliverabilityTestStatus is a required field
	DeliverabilityTestStatus *string `type:"string" required:"true" enum:"DeliverabilityTestStatus"`

	// A unique string that identifies the predictive inbox placement test.
	//
	// ReportId is a required field
	ReportId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDeliverabilityTestReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliverabilityTestReportOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestStatus sets the DeliverabilityTestStatus field's value.
func (s *CreateDeliverabilityTestReportOutput) SetDeliverabilityTestStatus(v string) *CreateDeliverabilityTestReportOutput {
	s.DeliverabilityTestStatus = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *CreateDeliverabilityTestReportOutput) SetReportId(v string) *CreateDeliverabilityTestReportOutput {
	s.ReportId = &v
	return s
}

// A request to begin the verification process for an email identity (an email
// address or domain).
type CreateEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email address or domain that you want to verify.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `type:"string" required:"true"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the email identity.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *CreateEmailIdentityInput) SetEmailIdentity(v string) *CreateEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEmailIdentityInput) SetTags(v []*Tag) *CreateEmailIdentityInput {
	s.Tags = v
	return s
}

// If the email identity is a domain, this object contains tokens that you can
// use to create a set of CNAME records. To sucessfully verify your domain,
// you have to add these records to the DNS configuration for your domain.
//
// If the email identity is an email address, this object is empty.
type CreateEmailIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the DKIM attributes for the identity.
	// This object includes the tokens that you use to create the CNAME records
	// that are required to complete the DKIM verification process.
	DkimAttributes *DkimAttributes `type:"structure"`

	// The email identity type.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// Specifies whether or not the identity is verified. In Amazon Pinpoint, you
	// can only send email from verified email addresses or domains. For more information
	// about verifying identities, see the Amazon Pinpoint User Guide (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
	VerifiedForSendingStatus *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *CreateEmailIdentityOutput) SetDkimAttributes(v *DkimAttributes) *CreateEmailIdentityOutput {
	s.DkimAttributes = v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *CreateEmailIdentityOutput) SetIdentityType(v string) *CreateEmailIdentityOutput {
	s.IdentityType = &v
	return s
}

// SetVerifiedForSendingStatus sets the VerifiedForSendingStatus field's value.
func (s *CreateEmailIdentityOutput) SetVerifiedForSendingStatus(v bool) *CreateEmailIdentityOutput {
	s.VerifiedForSendingStatus = &v
	return s
}

// An object that contains information about the volume of email sent on each
// day of the analysis period.
type DailyVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox placement metrics for a specified day in the
	// analysis period, broken out by the recipient's email provider.
	DomainIspPlacements []*DomainIspPlacement `type:"list"`

	// The date that the DailyVolume metrics apply to, in Unix time.
	StartDate *time.Time `type:"timestamp"`

	// An object that contains inbox placement metrics for a specific day in the
	// analysis period.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s DailyVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DailyVolume) GoString() string {
	return s.String()
}

// SetDomainIspPlacements sets the DomainIspPlacements field's value.
func (s *DailyVolume) SetDomainIspPlacements(v []*DomainIspPlacement) *DailyVolume {
	s.DomainIspPlacements = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DailyVolume) SetStartDate(v time.Time) *DailyVolume {
	s.StartDate = &v
	return s
}

// SetVolumeStatistics sets the VolumeStatistics field's value.
func (s *DailyVolume) SetVolumeStatistics(v *VolumeStatistics) *DailyVolume {
	s.VolumeStatistics = v
	return s
}

// Contains information about a dedicated IP address that is associated with
// your Amazon Pinpoint account.
type DedicatedIp struct {
	_ struct{} `type:"structure"`

	// An IP address that is reserved for use by your Amazon Pinpoint account.
	//
	// Ip is a required field
	Ip *string `type:"string" required:"true"`

	// The name of the dedicated IP pool that the IP address is associated with.
	PoolName *string `type:"string"`

	// Indicates how complete the dedicated IP warm-up process is. When this value
	// equals 1, the address has completed the warm-up process and is ready for
	// use.
	//
	// WarmupPercentage is a required field
	WarmupPercentage *int64 `type:"integer" required:"true"`

	// The warm-up status of a dedicated IP address. The status can have one of
	// the following values:
	//
	//    * IN_PROGRESS – The IP address isn't ready to use because the dedicated
	//    IP warm-up process is ongoing.
	//
	//    * DONE – The dedicated IP warm-up process is complete, and the IP address
	//    is ready to use.
	//
	// WarmupStatus is a required field
	WarmupStatus *string `type:"string" required:"true" enum:"WarmupStatus"`
}

// String returns the string representation
func (s DedicatedIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DedicatedIp) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *DedicatedIp) SetIp(v string) *DedicatedIp {
	s.Ip = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *DedicatedIp) SetPoolName(v string) *DedicatedIp {
	s.PoolName = &v
	return s
}

// SetWarmupPercentage sets the WarmupPercentage field's value.
func (s *DedicatedIp) SetWarmupPercentage(v int64) *DedicatedIp {
	s.WarmupPercentage = &v
	return s
}

// SetWarmupStatus sets the WarmupStatus field's value.
func (s *DedicatedIp) SetWarmupStatus(v string) *DedicatedIp {
	s.WarmupStatus = &v
	return s
}

// A request to delete an event destination from a configuration set.
type DeleteConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination that
	// you want to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The name of the event destination that you want to delete.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// A request to delete a configuration set.
type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// A request to delete a dedicated IP pool.
type DeleteDedicatedIpPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool that you want to delete.
	//
	// PoolName is a required field
	PoolName *string `location:"uri" locationName:"PoolName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDedicatedIpPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDedicatedIpPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDedicatedIpPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDedicatedIpPoolInput"}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolName sets the PoolName field's value.
func (s *DeleteDedicatedIpPoolInput) SetPoolName(v string) *DeleteDedicatedIpPoolInput {
	s.PoolName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteDedicatedIpPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDedicatedIpPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDedicatedIpPoolOutput) GoString() string {
	return s.String()
}

// A request to delete an existing email identity. When you delete an identity,
// you lose the ability to use Amazon Pinpoint to send email from that identity.
// You can restore your ability to send email by completing the verification
// process for the identity again.
type DeleteEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity (that is, the email address or domain) that you want to delete
	// from your Amazon Pinpoint account.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *DeleteEmailIdentityInput) SetEmailIdentity(v string) *DeleteEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteEmailIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityOutput) GoString() string {
	return s.String()
}

// An object that contains metadata related to a predictive inbox placement
// test.
type DeliverabilityTestReport struct {
	_ struct{} `type:"structure"`

	// The date and time when the predictive inbox placement test was created, in
	// Unix time format.
	CreateDate *time.Time `type:"timestamp"`

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS,
	// then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the
	// test. If the status is COMPLETE, then the test is finished, and you can use
	// the GetDeliverabilityTestReport to view the results of the test.
	DeliverabilityTestStatus *string `type:"string" enum:"DeliverabilityTestStatus"`

	// The sender address that you specified for the predictive inbox placement
	// test.
	FromEmailAddress *string `type:"string"`

	// A unique string that identifies the predictive inbox placement test.
	ReportId *string `type:"string"`

	// A name that helps you identify a predictive inbox placement test report.
	ReportName *string `type:"string"`

	// The subject line for an email that you submitted in a predictive inbox placement
	// test.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DeliverabilityTestReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverabilityTestReport) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DeliverabilityTestReport) SetCreateDate(v time.Time) *DeliverabilityTestReport {
	s.CreateDate = &v
	return s
}

// SetDeliverabilityTestStatus sets the DeliverabilityTestStatus field's value.
func (s *DeliverabilityTestReport) SetDeliverabilityTestStatus(v string) *DeliverabilityTestReport {
	s.DeliverabilityTestStatus = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *DeliverabilityTestReport) SetFromEmailAddress(v string) *DeliverabilityTestReport {
	s.FromEmailAddress = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *DeliverabilityTestReport) SetReportId(v string) *DeliverabilityTestReport {
	s.ReportId = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *DeliverabilityTestReport) SetReportName(v string) *DeliverabilityTestReport {
	s.ReportName = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DeliverabilityTestReport) SetSubject(v string) *DeliverabilityTestReport {
	s.Subject = &v
	return s
}

// Used to associate a configuration set with a dedicated IP pool.
type DeliveryOptions struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool that you want to associate with the configuration
	// set.
	SendingPoolName *string `type:"string"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS). If the value is Require, messages are
	// only delivered if a TLS connection can be established. If the value is Optional,
	// messages can be delivered in plain text if a TLS connection can't be established.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation
func (s DeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryOptions) GoString() string {
	return s.String()
}

// SetSendingPoolName sets the SendingPoolName field's value.
func (s *DeliveryOptions) SetSendingPoolName(v string) *DeliveryOptions {
	s.SendingPoolName = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *DeliveryOptions) SetTlsPolicy(v string) *DeliveryOptions {
	s.TlsPolicy = &v
	return s
}

// An object that describes the recipients for an email.
type Destination struct {
	_ struct{} `type:"structure"`

	// An array that contains the email addresses of the "BCC" (blind carbon copy)
	// recipients for the email.
	BccAddresses []*string `type:"list"`

	// An array that contains the email addresses of the "CC" (carbon copy) recipients
	// for the email.
	CcAddresses []*string `type:"list"`

	// An array that contains the email addresses of the "To" recipients for the
	// email.
	ToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// SetBccAddresses sets the BccAddresses field's value.
func (s *Destination) SetBccAddresses(v []*string) *Destination {
	s.BccAddresses = v
	return s
}

// SetCcAddresses sets the CcAddresses field's value.
func (s *Destination) SetCcAddresses(v []*string) *Destination {
	s.CcAddresses = v
	return s
}

// SetToAddresses sets the ToAddresses field's value.
func (s *Destination) SetToAddresses(v []*string) *Destination {
	s.ToAddresses = v
	return s
}

// An object that contains information about the DKIM configuration for an email
// identity.
type DkimAttributes struct {
	_ struct{} `type:"structure"`

	// If the value is true, then the messages that Amazon Pinpoint sends from the
	// identity are DKIM-signed. If the value is false, then the messages that Amazon
	// Pinpoint sends from the identity aren't DKIM-signed.
	SigningEnabled *bool `type:"boolean"`

	// Describes whether or not Amazon Pinpoint has successfully located the DKIM
	// records in the DNS records for the domain. The status can be one of the following:
	//
	//    * PENDING – Amazon Pinpoint hasn't yet located the DKIM records in the
	//    DNS configuration for the domain, but will continue to attempt to locate
	//    them.
	//
	//    * SUCCESS – Amazon Pinpoint located the DKIM records in the DNS configuration
	//    for the domain and determined that they're correct. Amazon Pinpoint can
	//    now send DKIM-signed email from the identity.
	//
	//    * FAILED – Amazon Pinpoint was unable to locate the DKIM records in
	//    the DNS settings for the domain, and won't continue to search for them.
	//
	//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
	//    Pinpoint from determining the DKIM status for the domain.
	//
	//    * NOT_STARTED – Amazon Pinpoint hasn't yet started searching for the
	//    DKIM records in the DKIM records for the domain.
	Status *string `type:"string" enum:"DkimStatus"`

	// A set of unique strings that you use to create a set of CNAME records that
	// you add to the DNS configuration for your domain. When Amazon Pinpoint detects
	// these records in the DNS configuration for your domain, the DKIM authentication
	// process is complete. Amazon Pinpoint usually detects these records within
	// about 72 hours of adding them to the DNS configuration for your domain.
	Tokens []*string `type:"list"`
}

// String returns the string representation
func (s DkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DkimAttributes) GoString() string {
	return s.String()
}

// SetSigningEnabled sets the SigningEnabled field's value.
func (s *DkimAttributes) SetSigningEnabled(v bool) *DkimAttributes {
	s.SigningEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DkimAttributes) SetStatus(v string) *DkimAttributes {
	s.Status = &v
	return s
}

// SetTokens sets the Tokens field's value.
func (s *DkimAttributes) SetTokens(v []*string) *DkimAttributes {
	s.Tokens = v
	return s
}

// An object that contains the deliverability data for a specific campaign.
// This data is available for a campaign only if the campaign sent email by
// using a domain that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
type DomainDeliverabilityCampaign struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the campaign. Amazon Pinpoint automatically generates
	// and assigns this identifier to a campaign. This value is not the same as
	// the campaign identifier that Amazon Pinpoint assigns to campaigns that you
	// create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint
	// console.
	CampaignId *string `type:"string"`

	// The percentage of email messages that were deleted by recipients, without
	// being opened first. Due to technical limitations, this value only includes
	// recipients who opened the message by using an email client that supports
	// images.
	DeleteRate *float64 `type:"double"`

	// The major email providers who handled the email message.
	Esps []*string `type:"list"`

	// The first time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	FirstSeenDateTime *time.Time `type:"timestamp"`

	// The verified email address that the email message was sent from.
	FromAddress *string `type:"string"`

	// The URL of an image that contains a snapshot of the email message that was
	// sent.
	ImageUrl *string `type:"string"`

	// The number of email messages that were delivered to recipients’ inboxes.
	InboxCount *int64 `type:"long"`

	// The last time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	LastSeenDateTime *time.Time `type:"timestamp"`

	// The projected number of recipients that the email message was sent to.
	ProjectedVolume *int64 `type:"long"`

	// The percentage of email messages that were opened and then deleted by recipients.
	// Due to technical limitations, this value only includes recipients who opened
	// the message by using an email client that supports images.
	ReadDeleteRate *float64 `type:"double"`

	// The percentage of email messages that were opened by recipients. Due to technical
	// limitations, this value only includes recipients who opened the message by
	// using an email client that supports images.
	ReadRate *float64 `type:"double"`

	// The IP addresses that were used to send the email message.
	SendingIps []*string `type:"list"`

	// The number of email messages that were delivered to recipients' spam or junk
	// mail folders.
	SpamCount *int64 `type:"long"`

	// The subject line, or title, of the email message.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DomainDeliverabilityCampaign) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDeliverabilityCampaign) GoString() string {
	return s.String()
}

// SetCampaignId sets the CampaignId field's value.
func (s *DomainDeliverabilityCampaign) SetCampaignId(v string) *DomainDeliverabilityCampaign {
	s.CampaignId = &v
	return s
}

// SetDeleteRate sets the DeleteRate field's value.
func (s *DomainDeliverabilityCampaign) SetDeleteRate(v float64) *DomainDeliverabilityCampaign {
	s.DeleteRate = &v
	return s
}

// SetEsps sets the Esps field's value.
func (s *DomainDeliverabilityCampaign) SetEsps(v []*string) *DomainDeliverabilityCampaign {
	s.Esps = v
	return s
}

// SetFirstSeenDateTime sets the FirstSeenDateTime field's value.
func (s *DomainDeliverabilityCampaign) SetFirstSeenDateTime(v time.Time) *DomainDeliverabilityCampaign {
	s.FirstSeenDateTime = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *DomainDeliverabilityCampaign) SetFromAddress(v string) *DomainDeliverabilityCampaign {
	s.FromAddress = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *DomainDeliverabilityCampaign) SetImageUrl(v string) *DomainDeliverabilityCampaign {
	s.ImageUrl = &v
	return s
}

// SetInboxCount sets the InboxCount field's value.
func (s *DomainDeliverabilityCampaign) SetInboxCount(v int64) *DomainDeliverabilityCampaign {
	s.InboxCount = &v
	return s
}

// SetLastSeenDateTime sets the LastSeenDateTime field's value.
func (s *DomainDeliverabilityCampaign) SetLastSeenDateTime(v time.Time) *DomainDeliverabilityCampaign {
	s.LastSeenDateTime = &v
	return s
}

// SetProjectedVolume sets the ProjectedVolume field's value.
func (s *DomainDeliverabilityCampaign) SetProjectedVolume(v int64) *DomainDeliverabilityCampaign {
	s.ProjectedVolume = &v
	return s
}

// SetReadDeleteRate sets the ReadDeleteRate field's value.
func (s *DomainDeliverabilityCampaign) SetReadDeleteRate(v float64) *DomainDeliverabilityCampaign {
	s.ReadDeleteRate = &v
	return s
}

// SetReadRate sets the ReadRate field's value.
func (s *DomainDeliverabilityCampaign) SetReadRate(v float64) *DomainDeliverabilityCampaign {
	s.ReadRate = &v
	return s
}

// SetSendingIps sets the SendingIps field's value.
func (s *DomainDeliverabilityCampaign) SetSendingIps(v []*string) *DomainDeliverabilityCampaign {
	s.SendingIps = v
	return s
}

// SetSpamCount sets the SpamCount field's value.
func (s *DomainDeliverabilityCampaign) SetSpamCount(v int64) *DomainDeliverabilityCampaign {
	s.SpamCount = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DomainDeliverabilityCampaign) SetSubject(v string) *DomainDeliverabilityCampaign {
	s.Subject = &v
	return s
}

// An object that contains information about the Deliverability dashboard subscription
// for a verified domain that you use to send email and currently has an active
// Deliverability dashboard subscription. If a Deliverability dashboard subscription
// is active for a domain, you gain access to reputation, inbox placement, and
// other metrics for the domain.
type DomainDeliverabilityTrackingOption struct {
	_ struct{} `type:"structure"`

	// A verified domain that’s associated with your AWS account and currently
	// has an active Deliverability dashboard subscription.
	Domain *string `type:"string"`

	// An object that contains information about the inbox placement data settings
	// for the domain.
	InboxPlacementTrackingOption *InboxPlacementTrackingOption `type:"structure"`

	// The date, in Unix time format, when you enabled the Deliverability dashboard
	// for the domain.
	SubscriptionStartDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DomainDeliverabilityTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDeliverabilityTrackingOption) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DomainDeliverabilityTrackingOption) SetDomain(v string) *DomainDeliverabilityTrackingOption {
	s.Domain = &v
	return s
}

// SetInboxPlacementTrackingOption sets the InboxPlacementTrackingOption field's value.
func (s *DomainDeliverabilityTrackingOption) SetInboxPlacementTrackingOption(v *InboxPlacementTrackingOption) *DomainDeliverabilityTrackingOption {
	s.InboxPlacementTrackingOption = v
	return s
}

// SetSubscriptionStartDate sets the SubscriptionStartDate field's value.
func (s *DomainDeliverabilityTrackingOption) SetSubscriptionStartDate(v time.Time) *DomainDeliverabilityTrackingOption {
	s.SubscriptionStartDate = &v
	return s
}

// An object that contains inbox placement data for email sent from one of your
// email domains to a specific email provider.
type DomainIspPlacement struct {
	_ struct{} `type:"structure"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s DomainIspPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainIspPlacement) GoString() string {
	return s.String()
}

// SetInboxPercentage sets the InboxPercentage field's value.
func (s *DomainIspPlacement) SetInboxPercentage(v float64) *DomainIspPlacement {
	s.InboxPercentage = &v
	return s
}

// SetInboxRawCount sets the InboxRawCount field's value.
func (s *DomainIspPlacement) SetInboxRawCount(v int64) *DomainIspPlacement {
	s.InboxRawCount = &v
	return s
}

// SetIspName sets the IspName field's value.
func (s *DomainIspPlacement) SetIspName(v string) *DomainIspPlacement {
	s.IspName = &v
	return s
}

// SetSpamPercentage sets the SpamPercentage field's value.
func (s *DomainIspPlacement) SetSpamPercentage(v float64) *DomainIspPlacement {
	s.SpamPercentage = &v
	return s
}

// SetSpamRawCount sets the SpamRawCount field's value.
func (s *DomainIspPlacement) SetSpamRawCount(v int64) *DomainIspPlacement {
	s.SpamRawCount = &v
	return s
}

// An object that defines the entire content of the email, including the message
// headers and the body content. You can create a simple email message, in which
// you specify the subject and the text and HTML versions of the message body.
// You can also create raw messages, in which you specify a complete MIME-formatted
// message. Raw messages can include attachments and custom headers.
type EmailContent struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * If you include attachments, they must be in a file format that Amazon
	//    Pinpoint supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	Raw *RawMessage `type:"structure"`

	// The simple email message. The message consists of a subject and a message
	// body.
	Simple *Message `type:"structure"`

	// The template to use for the email message.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s EmailContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailContent"}
	if s.Raw != nil {
		if err := s.Raw.Validate(); err != nil {
			invalidParams.AddNested("Raw", err.(request.ErrInvalidParams))
		}
	}
	if s.Simple != nil {
		if err := s.Simple.Validate(); err != nil {
			invalidParams.AddNested("Simple", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRaw sets the Raw field's value.
func (s *EmailContent) SetRaw(v *RawMessage) *EmailContent {
	s.Raw = v
	return s
}

// SetSimple sets the Simple field's value.
func (s *EmailContent) SetSimple(v *Message) *EmailContent {
	s.Simple = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *EmailContent) SetTemplate(v *Template) *EmailContent {
	s.Template = v
	return s
}

// In Amazon Pinpoint, events include message sends, deliveries, opens, clicks,
// bounces, and complaints. Event destinations are places that you can send
// information about these events to. For example, you can send event data to
// Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The types of events that Amazon Pinpoint sends to the specified event destinations.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `type:"list" required:"true"`

	// A name that identifies the event destination.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An object that defines a Amazon Pinpoint destination for email events. You
	// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
	// You can use these attributes to create segments for your campaigns.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDestination) GoString() string {
	return s.String()
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestination) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestination {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *EventDestination) SetName(v string) *EventDestination {
	s.Name = &v
	return s
}

// SetPinpointDestination sets the PinpointDestination field's value.
func (s *EventDestination) SetPinpointDestination(v *PinpointDestination) *EventDestination {
	s.PinpointDestination = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestination) SetSnsDestination(v *SnsDestination) *EventDestination {
	s.SnsDestination = v
	return s
}

// An object that defines the event destination. Specifically, it defines which
// services receive events from emails sent using the configuration set that
// the event destination is associated with. Also defines the types of events
// that are sent to the event destination.
type EventDestinationDefinition struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array that specifies which events Amazon Pinpoint should send to the destinations
	// in this EventDestinationDefinition.
	MatchingEventTypes []*string `type:"list"`

	// An object that defines a Amazon Pinpoint destination for email events. You
	// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
	// You can use these attributes to create segments for your campaigns.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestinationDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDestinationDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestinationDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDestinationDefinition"}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.SnsDestination != nil {
		if err := s.SnsDestination.Validate(); err != nil {
			invalidParams.AddNested("SnsDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestinationDefinition) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestinationDefinition {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestinationDefinition) SetEnabled(v bool) *EventDestinationDefinition {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestinationDefinition) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestinationDefinition {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestinationDefinition) SetMatchingEventTypes(v []*string) *EventDestinationDefinition {
	s.MatchingEventTypes = v
	return s
}

// SetPinpointDestination sets the PinpointDestination field's value.
func (s *EventDestinationDefinition) SetPinpointDestination(v *PinpointDestination) *EventDestinationDefinition {
	s.PinpointDestination = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestinationDefinition) SetSnsDestination(v *SnsDestination) *EventDestinationDefinition {
	s.SnsDestination = v
	return s
}

// A request to obtain information about the email-sending capabilities of your
// Amazon Pinpoint account.
type GetAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountInput) GoString() string {
	return s.String()
}

// A list of details about the email-sending capabilities of your Amazon Pinpoint
// account in the current AWS Region.
type GetAccountOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not the automatic warm-up feature is enabled for dedicated
	// IP addresses that are associated with your account.
	DedicatedIpAutoWarmupEnabled *bool `type:"boolean"`

	// The reputation status of your Amazon Pinpoint account. The status can be
	// one of the following:
	//
	//    * HEALTHY – There are no reputation-related issues that currently impact
	//    your account.
	//
	//    * PROBATION – We've identified some issues with your Amazon Pinpoint
	//    account. We're placing your account under review while you work on correcting
	//    these issues.
	//
	//    * SHUTDOWN – Your account's ability to send email is currently paused
	//    because of an issue with the email sent from your account. When you correct
	//    the issue, you can contact us and request that your account's ability
	//    to send email is resumed.
	EnforcementStatus *string `type:"string"`

	// Indicates whether or not your account has production access in the current
	// AWS Region.
	//
	// If the value is false, then your account is in the sandbox. When your account
	// is in the sandbox, you can only send email to verified identities. Additionally,
	// the maximum number of emails you can send in a 24-hour period (your sending
	// quota) is 200, and the maximum number of emails you can send per second (your
	// maximum sending rate) is 1.
	//
	// If the value is true, then your account has production access. When your
	// account has production access, you can send email to any address. The sending
	// quota and maximum sending rate for your account vary based on your specific
	// use case.
	ProductionAccessEnabled *bool `type:"boolean"`

	// An object that contains information about the per-day and per-second sending
	// limits for your Amazon Pinpoint account in the current AWS Region.
	SendQuota *SendQuota `type:"structure"`

	// Indicates whether or not email sending is enabled for your Amazon Pinpoint
	// account in the current AWS Region.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountOutput) GoString() string {
	return s.String()
}

// SetDedicatedIpAutoWarmupEnabled sets the DedicatedIpAutoWarmupEnabled field's value.
func (s *GetAccountOutput) SetDedicatedIpAutoWarmupEnabled(v bool) *GetAccountOutput {
	s.DedicatedIpAutoWarmupEnabled = &v
	return s
}

// SetEnforcementStatus sets the EnforcementStatus field's value.
func (s *GetAccountOutput) SetEnforcementStatus(v string) *GetAccountOutput {
	s.EnforcementStatus = &v
	return s
}

// SetProductionAccessEnabled sets the ProductionAccessEnabled field's value.
func (s *GetAccountOutput) SetProductionAccessEnabled(v bool) *GetAccountOutput {
	s.ProductionAccessEnabled = &v
	return s
}

// SetSendQuota sets the SendQuota field's value.
func (s *GetAccountOutput) SetSendQuota(v *SendQuota) *GetAccountOutput {
	s.SendQuota = v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *GetAccountOutput) SetSendingEnabled(v bool) *GetAccountOutput {
	s.SendingEnabled = &v
	return s
}

// A request to retrieve a list of the blacklists that your dedicated IP addresses
// appear on.
type GetBlacklistReportsInput struct {
	_ struct{} `type:"structure"`

	// A list of IP addresses that you want to retrieve blacklist information about.
	// You can only specify the dedicated IP addresses that you use to send email
	// using Amazon Pinpoint or Amazon SES.
	//
	// BlacklistItemNames is a required field
	BlacklistItemNames []*string `location:"querystring" locationName:"BlacklistItemNames" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBlacklistReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlacklistReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBlacklistReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBlacklistReportsInput"}
	if s.BlacklistItemNames == nil {
		invalidParams.Add(request.NewErrParamRequired("BlacklistItemNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlacklistItemNames sets the BlacklistItemNames field's value.
func (s *GetBlacklistReportsInput) SetBlacklistItemNames(v []*string) *GetBlacklistReportsInput {
	s.BlacklistItemNames = v
	return s
}

// An object that contains information about blacklist events.
type GetBlacklistReportsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about a blacklist that one of your dedicated
	// IP addresses appears on.
	//
	// BlacklistReport is a required field
	BlacklistReport map[string][]*BlacklistEntry `type:"map" required:"true"`
}

// String returns the string representation
func (s GetBlacklistReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlacklistReportsOutput) GoString() string {
	return s.String()
}

// SetBlacklistReport sets the BlacklistReport field's value.
func (s *GetBlacklistReportsOutput) SetBlacklistReport(v map[string][]*BlacklistEntry) *GetBlacklistReportsOutput {
	s.BlacklistReport = v
	return s
}

// A request to obtain information about the event destinations for a configuration
// set.
type GetConfigurationSetEventDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConfigurationSetEventDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetEventDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationSetEventDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationSetEventDestinationsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetEventDestinationsInput) SetConfigurationSetName(v string) *GetConfigurationSetEventDestinationsInput {
	s.ConfigurationSetName = &v
	return s
}

// Information about an event destination for a configuration set.
type GetConfigurationSetEventDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// An array that includes all of the events destinations that have been configured
	// for the configuration set.
	EventDestinations []*EventDestination `type:"list"`
}

// String returns the string representation
func (s GetConfigurationSetEventDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetEventDestinationsOutput) GoString() string {
	return s.String()
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *GetConfigurationSetEventDestinationsOutput) SetEventDestinations(v []*EventDestination) *GetConfigurationSetEventDestinationsOutput {
	s.EventDestinations = v
	return s
}

// A request to obtain information about a configuration set.
type GetConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to obtain more information
	// about.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetInput) SetConfigurationSetName(v string) *GetConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// Information about a configuration set.
type GetConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	ConfigurationSetName *string `type:"string"`

	// An object that defines the dedicated IP pool that is used to send emails
	// that you send using the configuration set.
	DeliveryOptions *DeliveryOptions `type:"structure"`

	// An object that defines whether or not Amazon Pinpoint collects reputation
	// metrics for the emails that you send that use the configuration set.
	ReputationOptions *ReputationOptions `type:"structure"`

	// An object that defines whether or not Amazon Pinpoint can send email that
	// you send using the configuration set.
	SendingOptions *SendingOptions `type:"structure"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the configuration set.
	Tags []*Tag `type:"list"`

	// An object that defines the open and click tracking options for emails that
	// you send using the configuration set.
	TrackingOptions *TrackingOptions `type:"structure"`
}

// String returns the string representation
func (s GetConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetOutput) SetConfigurationSetName(v string) *GetConfigurationSetOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *GetConfigurationSetOutput) SetDeliveryOptions(v *DeliveryOptions) *GetConfigurationSetOutput {
	s.DeliveryOptions = v
	return s
}

// SetReputationOptions sets the ReputationOptions field's value.
func (s *GetConfigurationSetOutput) SetReputationOptions(v *ReputationOptions) *GetConfigurationSetOutput {
	s.ReputationOptions = v
	return s
}

// SetSendingOptions sets the SendingOptions field's value.
func (s *GetConfigurationSetOutput) SetSendingOptions(v *SendingOptions) *GetConfigurationSetOutput {
	s.SendingOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetConfigurationSetOutput) SetTags(v []*Tag) *GetConfigurationSetOutput {
	s.Tags = v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *GetConfigurationSetOutput) SetTrackingOptions(v *TrackingOptions) *GetConfigurationSetOutput {
	s.TrackingOptions = v
	return s
}

// A request to obtain more information about a dedicated IP address.
type GetDedicatedIpInput struct {
	_ struct{} `type:"structure"`

	// The IP address that you want to obtain more information about. The value
	// you specify has to be a dedicated IP address that's assocaited with your
	// Amazon Pinpoint account.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDedicatedIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDedicatedIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDedicatedIpInput"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *GetDedicatedIpInput) SetIp(v string) *GetDedicatedIpInput {
	s.Ip = &v
	return s
}

// Information about a dedicated IP address.
type GetDedicatedIpOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about a dedicated IP address.
	DedicatedIp *DedicatedIp `type:"structure"`
}

// String returns the string representation
func (s GetDedicatedIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpOutput) GoString() string {
	return s.String()
}

// SetDedicatedIp sets the DedicatedIp field's value.
func (s *GetDedicatedIpOutput) SetDedicatedIp(v *DedicatedIp) *GetDedicatedIpOutput {
	s.DedicatedIp = v
	return s
}

// A request to obtain more information about dedicated IP pools.
type GetDedicatedIpsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to GetDedicatedIps to indicate the
	// position of the dedicated IP pool in the list of IP pools.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to GetDedicatedIpsRequest.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`

	// The name of the IP pool that the dedicated IP address is associated with.
	PoolName *string `location:"querystring" locationName:"PoolName" type:"string"`
}

// String returns the string representation
func (s GetDedicatedIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetDedicatedIpsInput) SetNextToken(v string) *GetDedicatedIpsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetDedicatedIpsInput) SetPageSize(v int64) *GetDedicatedIpsInput {
	s.PageSize = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *GetDedicatedIpsInput) SetPoolName(v string) *GetDedicatedIpsInput {
	s.PoolName = &v
	return s
}

// Information about the dedicated IP addresses that are associated with your
// Amazon Pinpoint account.
type GetDedicatedIpsOutput struct {
	_ struct{} `type:"structure"`

	// A list of dedicated IP addresses that are reserved for use by your Amazon
	// Pinpoint account.
	DedicatedIps []*DedicatedIp `type:"list"`

	// A token that indicates that there are additional dedicated IP addresses to
	// list. To view additional addresses, issue another request to GetDedicatedIps,
	// passing this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDedicatedIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpsOutput) GoString() string {
	return s.String()
}

// SetDedicatedIps sets the DedicatedIps field's value.
func (s *GetDedicatedIpsOutput) SetDedicatedIps(v []*DedicatedIp) *GetDedicatedIpsOutput {
	s.DedicatedIps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDedicatedIpsOutput) SetNextToken(v string) *GetDedicatedIpsOutput {
	s.NextToken = &v
	return s
}

// Retrieve information about the status of the Deliverability dashboard for
// your Amazon Pinpoint account. When the Deliverability dashboard is enabled,
// you gain access to reputation, deliverability, and other metrics for the
// domains that you use to send email using Amazon Pinpoint. You also gain the
// ability to perform predictive inbox placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon Pinpoint.
// For more information about the features and cost of a Deliverability dashboard
// subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
type GetDeliverabilityDashboardOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDeliverabilityDashboardOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityDashboardOptionsInput) GoString() string {
	return s.String()
}

// An object that shows the status of the Deliverability dashboard for your
// Amazon Pinpoint account.
type GetDeliverabilityDashboardOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current status of your Deliverability dashboard subscription. If this
	// value is PENDING_EXPIRATION, your subscription is scheduled to expire at
	// the end of the current calendar month.
	AccountStatus *string `type:"string" enum:"DeliverabilityDashboardAccountStatus"`

	// An array of objects, one for each verified domain that you use to send email
	// and currently has an active Deliverability dashboard subscription that isn’t
	// scheduled to expire at the end of the current calendar month.
	ActiveSubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`

	// Specifies whether the Deliverability dashboard is enabled for your Amazon
	// Pinpoint account. If this value is true, the dashboard is enabled.
	//
	// DashboardEnabled is a required field
	DashboardEnabled *bool `type:"boolean" required:"true"`

	// An array of objects, one for each verified domain that you use to send email
	// and currently has an active Deliverability dashboard subscription that's
	// scheduled to expire at the end of the current calendar month.
	PendingExpirationSubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`

	// The date, in Unix time format, when your current subscription to the Deliverability
	// dashboard is scheduled to expire, if your subscription is scheduled to expire
	// at the end of the current calendar month. This value is null if you have
	// an active subscription that isn’t due to expire at the end of the month.
	SubscriptionExpiryDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetDeliverabilityDashboardOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityDashboardOptionsOutput) GoString() string {
	return s.String()
}

// SetAccountStatus sets the AccountStatus field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetAccountStatus(v string) *GetDeliverabilityDashboardOptionsOutput {
	s.AccountStatus = &v
	return s
}

// SetActiveSubscribedDomains sets the ActiveSubscribedDomains field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetActiveSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *GetDeliverabilityDashboardOptionsOutput {
	s.ActiveSubscribedDomains = v
	return s
}

// SetDashboardEnabled sets the DashboardEnabled field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetDashboardEnabled(v bool) *GetDeliverabilityDashboardOptionsOutput {
	s.DashboardEnabled = &v
	return s
}

// SetPendingExpirationSubscribedDomains sets the PendingExpirationSubscribedDomains field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetPendingExpirationSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *GetDeliverabilityDashboardOptionsOutput {
	s.PendingExpirationSubscribedDomains = v
	return s
}

// SetSubscriptionExpiryDate sets the SubscriptionExpiryDate field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetSubscriptionExpiryDate(v time.Time) *GetDeliverabilityDashboardOptionsOutput {
	s.SubscriptionExpiryDate = &v
	return s
}

// A request to retrieve the results of a predictive inbox placement test.
type GetDeliverabilityTestReportInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the predictive inbox placement test.
	//
	// ReportId is a required field
	ReportId *string `location:"uri" locationName:"ReportId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeliverabilityTestReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityTestReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeliverabilityTestReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeliverabilityTestReportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetDeliverabilityTestReportInput) SetReportId(v string) *GetDeliverabilityTestReportInput {
	s.ReportId = &v
	return s
}

// The results of the predictive inbox placement test.
type GetDeliverabilityTestReportOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the predictive inbox placement test.
	//
	// DeliverabilityTestReport is a required field
	DeliverabilityTestReport *DeliverabilityTestReport `type:"structure" required:"true"`

	// An object that describes how the test email was handled by several email
	// providers, including Gmail, Hotmail, Yahoo, AOL, and others.
	//
	// IspPlacements is a required field
	IspPlacements []*IspPlacement `type:"list" required:"true"`

	// An object that contains the message that you sent when you performed this
	// predictive inbox placement test.
	Message *string `type:"string"`

	// An object that specifies how many test messages that were sent during the
	// predictive inbox placement test were delivered to recipients' inboxes, how
	// many were sent to recipients' spam folders, and how many weren't delivered.
	//
	// OverallPlacement is a required field
	OverallPlacement *PlacementStatistics `type:"structure" required:"true"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the predictive inbox placement test.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s GetDeliverabilityTestReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityTestReportOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestReport sets the DeliverabilityTestReport field's value.
func (s *GetDeliverabilityTestReportOutput) SetDeliverabilityTestReport(v *DeliverabilityTestReport) *GetDeliverabilityTestReportOutput {
	s.DeliverabilityTestReport = v
	return s
}

// SetIspPlacements sets the IspPlacements field's value.
func (s *GetDeliverabilityTestReportOutput) SetIspPlacements(v []*IspPlacement) *GetDeliverabilityTestReportOutput {
	s.IspPlacements = v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetDeliverabilityTestReportOutput) SetMessage(v string) *GetDeliverabilityTestReportOutput {
	s.Message = &v
	return s
}

// SetOverallPlacement sets the OverallPlacement field's value.
func (s *GetDeliverabilityTestReportOutput) SetOverallPlacement(v *PlacementStatistics) *GetDeliverabilityTestReportOutput {
	s.OverallPlacement = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDeliverabilityTestReportOutput) SetTags(v []*Tag) *GetDeliverabilityTestReportOutput {
	s.Tags = v
	return s
}

// Retrieve all the deliverability data for a specific campaign. This data is
// available for a campaign only if the campaign sent email by using a domain
// that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
type GetDomainDeliverabilityCampaignInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the campaign. Amazon Pinpoint automatically generates
	// and assigns this identifier to a campaign. This value is not the same as
	// the campaign identifier that Amazon Pinpoint assigns to campaigns that you
	// create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint
	// console.
	//
	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"CampaignId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainDeliverabilityCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDeliverabilityCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainDeliverabilityCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainDeliverabilityCampaignInput"}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetDomainDeliverabilityCampaignInput) SetCampaignId(v string) *GetDomainDeliverabilityCampaignInput {
	s.CampaignId = &v
	return s
}

// An object that contains all the deliverability data for a specific campaign.
// This data is available for a campaign only if the campaign sent email by
// using a domain that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
type GetDomainDeliverabilityCampaignOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the deliverability data for the campaign.
	//
	// DomainDeliverabilityCampaign is a required field
	DomainDeliverabilityCampaign *DomainDeliverabilityCampaign `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDomainDeliverabilityCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDeliverabilityCampaignOutput) GoString() string {
	return s.String()
}

// SetDomainDeliverabilityCampaign sets the DomainDeliverabilityCampaign field's value.
func (s *GetDomainDeliverabilityCampaignOutput) SetDomainDeliverabilityCampaign(v *DomainDeliverabilityCampaign) *GetDomainDeliverabilityCampaignOutput {
	s.DomainDeliverabilityCampaign = v
	return s
}

// A request to obtain deliverability metrics for a domain.
type GetDomainStatisticsReportInput struct {
	_ struct{} `type:"structure"`

	// The domain that you want to obtain deliverability metrics for.
	//
	// Domain is a required field
	Domain *string `location:"uri" locationName:"Domain" type:"string" required:"true"`

	// The last day (in Unix time) that you want to obtain domain deliverability
	// metrics for. The EndDate that you specify has to be less than or equal to
	// 30 days after the StartDate.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"EndDate" type:"timestamp" required:"true"`

	// The first day (in Unix time) that you want to obtain domain deliverability
	// metrics for.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"StartDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetDomainStatisticsReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainStatisticsReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainStatisticsReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainStatisticsReportInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetDomainStatisticsReportInput) SetDomain(v string) *GetDomainStatisticsReportInput {
	s.Domain = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetDomainStatisticsReportInput) SetEndDate(v time.Time) *GetDomainStatisticsReportInput {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetDomainStatisticsReportInput) SetStartDate(v time.Time) *GetDomainStatisticsReportInput {
	s.StartDate = &v
	return s
}

// An object that includes statistics that are related to the domain that you
// specified.
type GetDomainStatisticsReportOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains deliverability metrics for the domain that you specified.
	// This object contains data for each day, starting on the StartDate and ending
	// on the EndDate.
	//
	// DailyVolumes is a required field
	DailyVolumes []*DailyVolume `type:"list" required:"true"`

	// An object that contains deliverability metrics for the domain that you specified.
	// The data in this object is a summary of all of the data that was collected
	// from the StartDate to the EndDate.
	//
	// OverallVolume is a required field
	OverallVolume *OverallVolume `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDomainStatisticsReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainStatisticsReportOutput) GoString() string {
	return s.String()
}

// SetDailyVolumes sets the DailyVolumes field's value.
func (s *GetDomainStatisticsReportOutput) SetDailyVolumes(v []*DailyVolume) *GetDomainStatisticsReportOutput {
	s.DailyVolumes = v
	return s
}

// SetOverallVolume sets the OverallVolume field's value.
func (s *GetDomainStatisticsReportOutput) SetOverallVolume(v *OverallVolume) *GetDomainStatisticsReportOutput {
	s.OverallVolume = v
	return s
}

// A request to return details about an email identity.
type GetEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to retrieve details for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *GetEmailIdentityInput) SetEmailIdentity(v string) *GetEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// Details about an email identity.
type GetEmailIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the DKIM attributes for the identity.
	// This object includes the tokens that you use to create the CNAME records
	// that are required to complete the DKIM verification process.
	DkimAttributes *DkimAttributes `type:"structure"`

	// The feedback forwarding configuration for the identity.
	//
	// If the value is true, Amazon Pinpoint sends you email notifications when
	// bounce or complaint events occur. Amazon Pinpoint sends this notification
	// to the address that you specified in the Return-Path header of the original
	// email.
	//
	// When you set this value to false, Amazon Pinpoint sends notifications through
	// other mechanisms, such as by notifying an Amazon SNS topic or another event
	// destination. You're required to have a method of tracking bounces and complaints.
	// If you haven't set up another mechanism for receiving bounce or complaint
	// notifications, Amazon Pinpoint sends an email notification when these events
	// occur (even if this setting is disabled).
	FeedbackForwardingStatus *bool `type:"boolean"`

	// The email identity type.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// An object that contains information about the Mail-From attributes for the
	// email identity.
	MailFromAttributes *MailFromAttributes `type:"structure"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the email identity.
	Tags []*Tag `type:"list"`

	// Specifies whether or not the identity is verified. In Amazon Pinpoint, you
	// can only send email from verified email addresses or domains. For more information
	// about verifying identities, see the Amazon Pinpoint User Guide (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
	VerifiedForSendingStatus *bool `type:"boolean"`
}

// String returns the string representation
func (s GetEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *GetEmailIdentityOutput) SetDkimAttributes(v *DkimAttributes) *GetEmailIdentityOutput {
	s.DkimAttributes = v
	return s
}

// SetFeedbackForwardingStatus sets the FeedbackForwardingStatus field's value.
func (s *GetEmailIdentityOutput) SetFeedbackForwardingStatus(v bool) *GetEmailIdentityOutput {
	s.FeedbackForwardingStatus = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetEmailIdentityOutput) SetIdentityType(v string) *GetEmailIdentityOutput {
	s.IdentityType = &v
	return s
}

// SetMailFromAttributes sets the MailFromAttributes field's value.
func (s *GetEmailIdentityOutput) SetMailFromAttributes(v *MailFromAttributes) *GetEmailIdentityOutput {
	s.MailFromAttributes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEmailIdentityOutput) SetTags(v []*Tag) *GetEmailIdentityOutput {
	s.Tags = v
	return s
}

// SetVerifiedForSendingStatus sets the VerifiedForSendingStatus field's value.
func (s *GetEmailIdentityOutput) SetVerifiedForSendingStatus(v bool) *GetEmailIdentityOutput {
	s.VerifiedForSendingStatus = &v
	return s
}

// Information about an email identity.
type IdentityInfo struct {
	_ struct{} `type:"structure"`

	// The address or domain of the identity.
	IdentityName *string `type:"string"`

	// The email identity type. The identity type can be one of the following:
	//
	//    * EMAIL_ADDRESS – The identity is an email address.
	//
	//    * DOMAIN – The identity is a domain.
	//
	//    * MANAGED_DOMAIN – The identity is a domain that is managed by AWS.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// Indicates whether or not you can send email from the identity.
	//
	// In Amazon Pinpoint, an identity is an email address or domain that you send
	// email from. Before you can send email from an identity, you have to demostrate
	// that you own the identity, and that you authorize Amazon Pinpoint to send
	// email from that identity.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s IdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityInfo) GoString() string {
	return s.String()
}

// SetIdentityName sets the IdentityName field's value.
func (s *IdentityInfo) SetIdentityName(v string) *IdentityInfo {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *IdentityInfo) SetIdentityType(v string) *IdentityInfo {
	s.IdentityType = &v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *IdentityInfo) SetSendingEnabled(v bool) *IdentityInfo {
	s.SendingEnabled = &v
	return s
}

// An object that contains information about the inbox placement data settings
// for a verified domain that’s associated with your AWS account. This data
// is available only if you enabled the Deliverability dashboard for the domain
// (PutDeliverabilityDashboardOption operation).
type InboxPlacementTrackingOption struct {
	_ struct{} `type:"structure"`

	// Specifies whether inbox placement data is being tracked for the domain.
	Global *bool `type:"boolean"`

	// An array of strings, one for each major email provider that the inbox placement
	// data applies to.
	TrackedIsps []*string `type:"list"`
}

// String returns the string representation
func (s InboxPlacementTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InboxPlacementTrackingOption) GoString() string {
	return s.String()
}

// SetGlobal sets the Global field's value.
func (s *InboxPlacementTrackingOption) SetGlobal(v bool) *InboxPlacementTrackingOption {
	s.Global = &v
	return s
}

// SetTrackedIsps sets the TrackedIsps field's value.
func (s *InboxPlacementTrackingOption) SetTrackedIsps(v []*string) *InboxPlacementTrackingOption {
	s.TrackedIsps = v
	return s
}

// An object that describes how email sent during the predictive inbox placement
// test was handled by a certain email provider.
type IspPlacement struct {
	_ struct{} `type:"structure"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// An object that contains inbox placement metrics for a specific email provider.
	PlacementStatistics *PlacementStatistics `type:"structure"`
}

// String returns the string representation
func (s IspPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IspPlacement) GoString() string {
	return s.String()
}

// SetIspName sets the IspName field's value.
func (s *IspPlacement) SetIspName(v string) *IspPlacement {
	s.IspName = &v
	return s
}

// SetPlacementStatistics sets the PlacementStatistics field's value.
func (s *IspPlacement) SetPlacementStatistics(v *PlacementStatistics) *IspPlacement {
	s.PlacementStatistics = v
	return s
}

// An object that defines an Amazon Kinesis Data Firehose destination for email
// events. You can use Amazon Kinesis Data Firehose to stream data to other
// services, such as Amazon S3 and Amazon Redshift.
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream
	// that Amazon Pinpoint sends email events to.
	//
	// DeliveryStreamArn is a required field
	DeliveryStreamArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that Amazon Pinpoint uses
	// when sending email events to the Amazon Kinesis Data Firehose stream.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseDestination"}
	if s.DeliveryStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamArn"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamArn(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *KinesisFirehoseDestination) SetIamRoleArn(v string) *KinesisFirehoseDestination {
	s.IamRoleArn = &v
	return s
}

// There are too many instances of the specified resource type.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to obtain a list of configuration sets for your Amazon Pinpoint
// account in the current AWS Region.
type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position in the list of configuration sets.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListConfigurationSets.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsInput) SetNextToken(v string) *ListConfigurationSetsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListConfigurationSetsInput) SetPageSize(v int64) *ListConfigurationSetsInput {
	s.PageSize = &v
	return s
}

// A list of configuration sets in your Amazon Pinpoint account in the current
// AWS Region.
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains all of the configuration sets in your Amazon Pinpoint
	// account in the current AWS Region.
	ConfigurationSets []*string `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListConfigurationSets,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *ListConfigurationSetsOutput) SetConfigurationSets(v []*string) *ListConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsOutput) SetNextToken(v string) *ListConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

// A request to obtain a list of dedicated IP pools.
type ListDedicatedIpPoolsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListDedicatedIpPools to indicate
	// the position in the list of dedicated IP pools.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListDedicatedIpPools. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListDedicatedIpPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDedicatedIpPoolsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDedicatedIpPoolsInput) SetNextToken(v string) *ListDedicatedIpPoolsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDedicatedIpPoolsInput) SetPageSize(v int64) *ListDedicatedIpPoolsInput {
	s.PageSize = &v
	return s
}

// A list of dedicated IP pools.
type ListDedicatedIpPoolsOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the dedicated IP pools that are associated with your Amazon
	// Pinpoint account.
	DedicatedIpPools []*string `type:"list"`

	// A token that indicates that there are additional IP pools to list. To view
	// additional IP pools, issue another request to ListDedicatedIpPools, passing
	// this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDedicatedIpPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDedicatedIpPoolsOutput) GoString() string {
	return s.String()
}

// SetDedicatedIpPools sets the DedicatedIpPools field's value.
func (s *ListDedicatedIpPoolsOutput) SetDedicatedIpPools(v []*string) *ListDedicatedIpPoolsOutput {
	s.DedicatedIpPools = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDedicatedIpPoolsOutput) SetNextToken(v string) *ListDedicatedIpPoolsOutput {
	s.NextToken = &v
	return s
}

// A request to list all of the predictive inbox placement tests that you've
// performed.
type ListDeliverabilityTestReportsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListDeliverabilityTestReports to
	// indicate the position in the list of predictive inbox placement tests.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListDeliverabilityTestReports.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	//
	// The value you specify has to be at least 0, and can be no more than 1000.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListDeliverabilityTestReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliverabilityTestReportsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeliverabilityTestReportsInput) SetNextToken(v string) *ListDeliverabilityTestReportsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDeliverabilityTestReportsInput) SetPageSize(v int64) *ListDeliverabilityTestReportsInput {
	s.PageSize = &v
	return s
}

// A list of the predictive inbox placement test reports that are available
// for your account, regardless of whether or not those tests are complete.
type ListDeliverabilityTestReportsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains a lists of predictive inbox placement tests that
	// you've performed.
	//
	// DeliverabilityTestReports is a required field
	DeliverabilityTestReports []*DeliverabilityTestReport `type:"list" required:"true"`

	// A token that indicates that there are additional predictive inbox placement
	// tests to list. To view additional predictive inbox placement tests, issue
	// another request to ListDeliverabilityTestReports, and pass this token in
	// the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeliverabilityTestReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliverabilityTestReportsOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestReports sets the DeliverabilityTestReports field's value.
func (s *ListDeliverabilityTestReportsOutput) SetDeliverabilityTestReports(v []*DeliverabilityTestReport) *ListDeliverabilityTestReportsOutput {
	s.DeliverabilityTestReports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeliverabilityTestReportsOutput) SetNextToken(v string) *ListDeliverabilityTestReportsOutput {
	s.NextToken = &v
	return s
}

// Retrieve deliverability data for all the campaigns that used a specific domain
// to send email during a specified time range. This data is available for a
// domain only if you enabled the Deliverability dashboard (PutDeliverabilityDashboardOption
// operation) for the domain.
type ListDomainDeliverabilityCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The last day, in Unix time format, that you want to obtain deliverability
	// data for. This value has to be less than or equal to 30 days after the value
	// of the StartDate parameter.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"EndDate" type:"timestamp" required:"true"`

	// A token that’s returned from a previous call to the ListDomainDeliverabilityCampaigns
	// operation. This token indicates the position of a campaign in the list of
	// campaigns.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The maximum number of results to include in response to a single call to
	// the ListDomainDeliverabilityCampaigns operation. If the number of results
	// is larger than the number that you specify in this parameter, the response
	// includes a NextToken element, which you can use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`

	// The first day, in Unix time format, that you want to obtain deliverability
	// data for.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"StartDate" type:"timestamp" required:"true"`

	// The domain to obtain deliverability data for.
	//
	// SubscribedDomain is a required field
	SubscribedDomain *string `location:"uri" locationName:"SubscribedDomain" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDomainDeliverabilityCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainDeliverabilityCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainDeliverabilityCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainDeliverabilityCampaignsInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}
	if s.SubscribedDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscribedDomain"))
	}
	if s.SubscribedDomain != nil && len(*s.SubscribedDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscribedDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetEndDate(v time.Time) *ListDomainDeliverabilityCampaignsInput {
	s.EndDate = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetNextToken(v string) *ListDomainDeliverabilityCampaignsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetPageSize(v int64) *ListDomainDeliverabilityCampaignsInput {
	s.PageSize = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetStartDate(v time.Time) *ListDomainDeliverabilityCampaignsInput {
	s.StartDate = &v
	return s
}

// SetSubscribedDomain sets the SubscribedDomain field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetSubscribedDomain(v string) *ListDomainDeliverabilityCampaignsInput {
	s.SubscribedDomain = &v
	return s
}

// An array of objects that provide deliverability data for all the campaigns
// that used a specific domain to send email during a specified time range.
// This data is available for a domain only if you enabled the Deliverability
// dashboard (PutDeliverabilityDashboardOption operation) for the domain.
type ListDomainDeliverabilityCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each campaign that used the domain to send
	// email during the specified time range.
	//
	// DomainDeliverabilityCampaigns is a required field
	DomainDeliverabilityCampaigns []*DomainDeliverabilityCampaign `type:"list" required:"true"`

	// A token that’s returned from a previous call to the ListDomainDeliverabilityCampaigns
	// operation. This token indicates the position of the campaign in the list
	// of campaigns.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDomainDeliverabilityCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainDeliverabilityCampaignsOutput) GoString() string {
	return s.String()
}

// SetDomainDeliverabilityCampaigns sets the DomainDeliverabilityCampaigns field's value.
func (s *ListDomainDeliverabilityCampaignsOutput) SetDomainDeliverabilityCampaigns(v []*DomainDeliverabilityCampaign) *ListDomainDeliverabilityCampaignsOutput {
	s.DomainDeliverabilityCampaigns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainDeliverabilityCampaignsOutput) SetNextToken(v string) *ListDomainDeliverabilityCampaignsOutput {
	s.NextToken = &v
	return s
}

// A request to list all of the email identities associated with your Amazon
// Pinpoint account. This list includes identities that you've already verified,
// identities that are unverified, and identities that were verified in the
// past, but are no longer verified.
type ListEmailIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListEmailIdentities to indicate
	// the position in the list of identities.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListEmailIdentities. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	//
	// The value you specify has to be at least 0, and can be no more than 1000.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListEmailIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailIdentitiesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailIdentitiesInput) SetNextToken(v string) *ListEmailIdentitiesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListEmailIdentitiesInput) SetPageSize(v int64) *ListEmailIdentitiesInput {
	s.PageSize = &v
	return s
}

// A list of all of the identities that you've attempted to verify for use with
// Amazon Pinpoint, regardless of whether or not those identities were successfully
// verified.
type ListEmailIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array that includes all of the identities associated with your Amazon
	// Pinpoint account.
	EmailIdentities []*IdentityInfo `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListEmailIdentities,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEmailIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailIdentitiesOutput) GoString() string {
	return s.String()
}

// SetEmailIdentities sets the EmailIdentities field's value.
func (s *ListEmailIdentitiesOutput) SetEmailIdentities(v []*IdentityInfo) *ListEmailIdentitiesOutput {
	s.EmailIdentities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailIdentitiesOutput) SetNextToken(v string) *ListEmailIdentitiesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to retrieve
	// tag information for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array that lists all the tags that are associated with the resource. Each
	// tag consists of a required tag key (Key) and an associated tag value (Value)
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A list of attributes that are associated with a MAIL FROM domain.
type MailFromAttributes struct {
	_ struct{} `type:"structure"`

	// The action that Amazon Pinpoint to takes if it can't read the required MX
	// record for a custom MAIL FROM domain. When you set this value to UseDefaultValue,
	// Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set
	// this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified
	// error, and doesn't attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration
	// is in the Pending, Failed, and TemporaryFailure states.
	//
	// BehaviorOnMxFailure is a required field
	BehaviorOnMxFailure *string `type:"string" required:"true" enum:"BehaviorOnMxFailure"`

	// The name of a domain that an email identity uses as a custom MAIL FROM domain.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The status of the MAIL FROM domain. This status can have the following values:
	//
	//    * PENDING – Amazon Pinpoint hasn't started searching for the MX record
	//    yet.
	//
	//    * SUCCESS – Amazon Pinpoint detected the required MX record for the
	//    MAIL FROM domain.
	//
	//    * FAILED – Amazon Pinpoint can't find the required MX record, or the
	//    record no longer exists.
	//
	//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
	//    Pinpoint from determining the status of the MAIL FROM domain.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus *string `type:"string" required:"true" enum:"MailFromDomainStatus"`
}

// String returns the string representation
func (s MailFromAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailFromAttributes) GoString() string {
	return s.String()
}

// SetBehaviorOnMxFailure sets the BehaviorOnMxFailure field's value.
func (s *MailFromAttributes) SetBehaviorOnMxFailure(v string) *MailFromAttributes {
	s.BehaviorOnMxFailure = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *MailFromAttributes) SetMailFromDomain(v string) *MailFromAttributes {
	s.MailFromDomain = &v
	return s
}

// SetMailFromDomainStatus sets the MailFromDomainStatus field's value.
func (s *MailFromAttributes) SetMailFromDomainStatus(v string) *MailFromAttributes {
	s.MailFromDomainStatus = &v
	return s
}

// The message can't be sent because the sending domain isn't verified.
type MailFromDomainNotVerifiedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MailFromDomainNotVerifiedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailFromDomainNotVerifiedException) GoString() string {
	return s.String()
}

func newErrorMailFromDomainNotVerifiedException(v protocol.ResponseMetadata) error {
	return &MailFromDomainNotVerifiedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MailFromDomainNotVerifiedException) Code() string {
	return "MailFromDomainNotVerifiedException"
}

// Message returns the exception's message.
func (s *MailFromDomainNotVerifiedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MailFromDomainNotVerifiedException) OrigErr() error {
	return nil
}

func (s *MailFromDomainNotVerifiedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MailFromDomainNotVerifiedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MailFromDomainNotVerifiedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the email message that you're sending. The Message object consists
// of a subject line and a message body.
type Message struct {
	_ struct{} `type:"structure"`

	// The body of the message. You can specify an HTML version of the message,
	// a text-only version of the message, or both.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject line of the email. The subject line can only contain 7-bit ASCII
	// characters. However, you can specify non-ASCII characters in the subject
	// line by using encoded-word syntax, as described in RFC 2047 (https://tools.ietf.org/html/rfc2047).
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v *Body) *Message {
	s.Body = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Message) SetSubject(v *Content) *Message {
	s.Subject = v
	return s
}

// The message can't be sent because it contains invalid content.
type MessageRejected struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MessageRejected) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageRejected) GoString() string {
	return s.String()
}

func newErrorMessageRejected(v protocol.ResponseMetadata) error {
	return &MessageRejected{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MessageRejected) Code() string {
	return "MessageRejected"
}

// Message returns the exception's message.
func (s *MessageRejected) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MessageRejected) OrigErr() error {
	return nil
}

func (s *MessageRejected) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MessageRejected) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MessageRejected) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the name and value of a tag that you apply to an email. You can
// use message tags when you publish email sending events.
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the message tag. The message tag name has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the message tag. The message tag value has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTag"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MessageTag) SetName(v string) *MessageTag {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageTag) SetValue(v string) *MessageTag {
	s.Value = &v
	return s
}

// The resource you attempted to access doesn't exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about email that was sent from the selected
// domain.
type OverallVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox and junk mail placement metrics for individual
	// email providers.
	DomainIspPlacements []*DomainIspPlacement `type:"list"`

	// The percentage of emails that were sent from the domain that were read by
	// their recipients.
	ReadRatePercent *float64 `type:"double"`

	// An object that contains information about the numbers of messages that arrived
	// in recipients' inboxes and junk mail folders.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s OverallVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OverallVolume) GoString() string {
	return s.String()
}

// SetDomainIspPlacements sets the DomainIspPlacements field's value.
func (s *OverallVolume) SetDomainIspPlacements(v []*DomainIspPlacement) *OverallVolume {
	s.DomainIspPlacements = v
	return s
}

// SetReadRatePercent sets the ReadRatePercent field's value.
func (s *OverallVolume) SetReadRatePercent(v float64) *OverallVolume {
	s.ReadRatePercent = &v
	return s
}

// SetVolumeStatistics sets the VolumeStatistics field's value.
func (s *OverallVolume) SetVolumeStatistics(v *VolumeStatistics) *OverallVolume {
	s.VolumeStatistics = v
	return s
}

// An object that defines a Amazon Pinpoint destination for email events. You
// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
// You can use these attributes to create segments for your campaigns.
type PinpointDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want
	// to send email events to.
	ApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s PinpointDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PinpointDestination) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PinpointDestination) SetApplicationArn(v string) *PinpointDestination {
	s.ApplicationArn = &v
	return s
}

// An object that contains inbox placement data for an email provider.
type PlacementStatistics struct {
	_ struct{} `type:"structure"`

	// The percentage of emails that were authenticated by using DomainKeys Identified
	// Mail (DKIM) during the predictive inbox placement test.
	DkimPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' inboxes during the predictive
	// inbox placement test.
	InboxPercentage *float64 `type:"double"`

	// The percentage of emails that didn't arrive in recipients' inboxes at all
	// during the predictive inbox placement test.
	MissingPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' spam or junk mail folders
	// during the predictive inbox placement test.
	SpamPercentage *float64 `type:"double"`

	// The percentage of emails that were authenticated by using Sender Policy Framework
	// (SPF) during the predictive inbox placement test.
	SpfPercentage *float64 `type:"double"`
}

// String returns the string representation
func (s PlacementStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementStatistics) GoString() string {
	return s.String()
}

// SetDkimPercentage sets the DkimPercentage field's value.
func (s *PlacementStatistics) SetDkimPercentage(v float64) *PlacementStatistics {
	s.DkimPercentage = &v
	return s
}

// SetInboxPercentage sets the InboxPercentage field's value.
func (s *PlacementStatistics) SetInboxPercentage(v float64) *PlacementStatistics {
	s.InboxPercentage = &v
	return s
}

// SetMissingPercentage sets the MissingPercentage field's value.
func (s *PlacementStatistics) SetMissingPercentage(v float64) *PlacementStatistics {
	s.MissingPercentage = &v
	return s
}

// SetSpamPercentage sets the SpamPercentage field's value.
func (s *PlacementStatistics) SetSpamPercentage(v float64) *PlacementStatistics {
	s.SpamPercentage = &v
	return s
}

// SetSpfPercentage sets the SpfPercentage field's value.
func (s *PlacementStatistics) SetSpfPercentage(v float64) *PlacementStatistics {
	s.SpfPercentage = &v
	return s
}

// A request to enable or disable the automatic IP address warm-up feature.
type PutAccountDedicatedIpWarmupAttributesInput struct {
	_ struct{} `type:"structure"`

	// Enables or disables the automatic warm-up feature for dedicated IP addresses
	// that are associated with your Amazon Pinpoint account in the current AWS
	// Region. Set to true to enable the automatic warm-up feature, or set to false
	// to disable it.
	AutoWarmupEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesInput) GoString() string {
	return s.String()
}

// SetAutoWarmupEnabled sets the AutoWarmupEnabled field's value.
func (s *PutAccountDedicatedIpWarmupAttributesInput) SetAutoWarmupEnabled(v bool) *PutAccountDedicatedIpWarmupAttributesInput {
	s.AutoWarmupEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountDedicatedIpWarmupAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesOutput) GoString() string {
	return s.String()
}

// A request to change the ability of your account to send email.
type PutAccountSendingAttributesInput struct {
	_ struct{} `type:"structure"`

	// Enables or disables your account's ability to send email. Set to true to
	// enable email sending, or set to false to disable email sending.
	//
	// If AWS paused your account's ability to send email, you can't use this operation
	// to resume your account's ability to send email.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutAccountSendingAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSendingAttributesInput) GoString() string {
	return s.String()
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *PutAccountSendingAttributesInput) SetSendingEnabled(v bool) *PutAccountSendingAttributesInput {
	s.SendingEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountSendingAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountSendingAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSendingAttributesOutput) GoString() string {
	return s.String()
}

// A request to associate a configuration set with a dedicated IP pool.
type PutConfigurationSetDeliveryOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to associate with a dedicated
	// IP pool.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The name of the dedicated IP pool that you want to associate with the configuration
	// set.
	SendingPoolName *string `type:"string"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS). If the value is Require, messages are
	// only delivered if a TLS connection can be established. If the value is Optional,
	// messages can be delivered in plain text if a TLS connection can't be established.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation
func (s PutConfigurationSetDeliveryOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetDeliveryOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetDeliveryOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetDeliveryOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSendingPoolName sets the SendingPoolName field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetSendingPoolName(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.SendingPoolName = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetTlsPolicy(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.TlsPolicy = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetDeliveryOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetDeliveryOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetDeliveryOptionsOutput) GoString() string {
	return s.String()
}

// A request to enable or disable tracking of reputation metrics for a configuration
// set.
type PutConfigurationSetReputationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to enable or disable reputation
	// metric tracking for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetReputationOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetReputationOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetReputationOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetReputationOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetReputationOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetReputationMetricsEnabled sets the ReputationMetricsEnabled field's value.
func (s *PutConfigurationSetReputationOptionsInput) SetReputationMetricsEnabled(v bool) *PutConfigurationSetReputationOptionsInput {
	s.ReputationMetricsEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetReputationOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetReputationOptionsOutput) GoString() string {
	return s.String()
}

// A request to enable or disable the ability of Amazon Pinpoint to send emails
// that use a specific configuration set.
type PutConfigurationSetSendingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to enable or disable email
	// sending for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// If true, email sending is enabled for the configuration set. If false, email
	// sending is disabled for the configuration set.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutConfigurationSetSendingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSendingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetSendingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetSendingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetSendingOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetSendingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *PutConfigurationSetSendingOptionsInput) SetSendingEnabled(v bool) *PutConfigurationSetSendingOptionsInput {
	s.SendingEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetSendingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetSendingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSendingOptionsOutput) GoString() string {
	return s.String()
}

// A request to add a custom domain for tracking open and click events to a
// configuration set.
type PutConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to add a custom tracking
	// domain to.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The domain that you want to use to track open and click events.
	CustomRedirectDomain *string `type:"string"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetTrackingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetTrackingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetTrackingOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetTrackingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetCustomRedirectDomain sets the CustomRedirectDomain field's value.
func (s *PutConfigurationSetTrackingOptionsInput) SetCustomRedirectDomain(v string) *PutConfigurationSetTrackingOptionsInput {
	s.CustomRedirectDomain = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetTrackingOptionsOutput) GoString() string {
	return s.String()
}

// A request to move a dedicated IP address to a dedicated IP pool.
type PutDedicatedIpInPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the IP pool that you want to add the dedicated IP address to.
	// You have to specify an IP pool that already exists.
	//
	// DestinationPoolName is a required field
	DestinationPoolName *string `type:"string" required:"true"`

	// The IP address that you want to move to the dedicated IP pool. The value
	// you specify has to be a dedicated IP address that's associated with your
	// Amazon Pinpoint account.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDedicatedIpInPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpInPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDedicatedIpInPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDedicatedIpInPoolInput"}
	if s.DestinationPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPoolName"))
	}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationPoolName sets the DestinationPoolName field's value.
func (s *PutDedicatedIpInPoolInput) SetDestinationPoolName(v string) *PutDedicatedIpInPoolInput {
	s.DestinationPoolName = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *PutDedicatedIpInPoolInput) SetIp(v string) *PutDedicatedIpInPoolInput {
	s.Ip = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutDedicatedIpInPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDedicatedIpInPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpInPoolOutput) GoString() string {
	return s.String()
}

// A request to change the warm-up attributes for a dedicated IP address. This
// operation is useful when you want to resume the warm-up process for an existing
// IP address.
type PutDedicatedIpWarmupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The dedicated IP address that you want to update the warm-up attributes for.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`

	// The warm-up percentage that you want to associate with the dedicated IP address.
	//
	// WarmupPercentage is a required field
	WarmupPercentage *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutDedicatedIpWarmupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpWarmupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDedicatedIpWarmupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDedicatedIpWarmupAttributesInput"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}
	if s.WarmupPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("WarmupPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *PutDedicatedIpWarmupAttributesInput) SetIp(v string) *PutDedicatedIpWarmupAttributesInput {
	s.Ip = &v
	return s
}

// SetWarmupPercentage sets the WarmupPercentage field's value.
func (s *PutDedicatedIpWarmupAttributesInput) SetWarmupPercentage(v int64) *PutDedicatedIpWarmupAttributesInput {
	s.WarmupPercentage = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutDedicatedIpWarmupAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDedicatedIpWarmupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpWarmupAttributesOutput) GoString() string {
	return s.String()
}

// Enable or disable the Deliverability dashboard for your Amazon Pinpoint account.
// When you enable the Deliverability dashboard, you gain access to reputation,
// deliverability, and other metrics for the domains that you use to send email
// using Amazon Pinpoint. You also gain the ability to perform predictive inbox
// placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon Pinpoint.
// For more information about the features and cost of a Deliverability dashboard
// subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
type PutDeliverabilityDashboardOptionInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the Deliverability dashboard for your Amazon
	// Pinpoint account. To enable the dashboard, set this value to true.
	//
	// DashboardEnabled is a required field
	DashboardEnabled *bool `type:"boolean" required:"true"`

	// An array of objects, one for each verified domain that you use to send email
	// and enabled the Deliverability dashboard for.
	SubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`
}

// String returns the string representation
func (s PutDeliverabilityDashboardOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliverabilityDashboardOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDeliverabilityDashboardOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDeliverabilityDashboardOptionInput"}
	if s.DashboardEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardEnabled sets the DashboardEnabled field's value.
func (s *PutDeliverabilityDashboardOptionInput) SetDashboardEnabled(v bool) *PutDeliverabilityDashboardOptionInput {
	s.DashboardEnabled = &v
	return s
}

// SetSubscribedDomains sets the SubscribedDomains field's value.
func (s *PutDeliverabilityDashboardOptionInput) SetSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *PutDeliverabilityDashboardOptionInput {
	s.SubscribedDomains = v
	return s
}

// A response that indicates whether the Deliverability dashboard is enabled
// for your Amazon Pinpoint account.
type PutDeliverabilityDashboardOptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDeliverabilityDashboardOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliverabilityDashboardOptionOutput) GoString() string {
	return s.String()
}

// A request to enable or disable DKIM signing of email that you send from an
// email identity.
type PutEmailIdentityDkimAttributesInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to change the DKIM settings for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" type:"string" required:"true"`

	// Sets the DKIM signing configuration for the identity.
	//
	// When you set this value true, then the messages that Amazon Pinpoint sends
	// from the identity are DKIM-signed. When you set this value to false, then
	// the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.
	SigningEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutEmailIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityDkimAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityDkimAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityDkimAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityDkimAttributesInput {
	s.EmailIdentity = &v
	return s
}

// SetSigningEnabled sets the SigningEnabled field's value.
func (s *PutEmailIdentityDkimAttributesInput) SetSigningEnabled(v bool) *PutEmailIdentityDkimAttributesInput {
	s.SigningEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityDkimAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimAttributesOutput) GoString() string {
	return s.String()
}

// A request to set the attributes that control how bounce and complaint events
// are processed.
type PutEmailIdentityFeedbackAttributesInput struct {
	_ struct{} `type:"structure"`

	// Sets the feedback forwarding configuration for the identity.
	//
	// If the value is true, Amazon Pinpoint sends you email notifications when
	// bounce or complaint events occur. Amazon Pinpoint sends this notification
	// to the address that you specified in the Return-Path header of the original
	// email.
	//
	// When you set this value to false, Amazon Pinpoint sends notifications through
	// other mechanisms, such as by notifying an Amazon SNS topic or another event
	// destination. You're required to have a method of tracking bounces and complaints.
	// If you haven't set up another mechanism for receiving bounce or complaint
	// notifications, Amazon Pinpoint sends an email notification when these events
	// occur (even if this setting is disabled).
	EmailForwardingEnabled *bool `type:"boolean"`

	// The email identity that you want to configure bounce and complaint feedback
	// forwarding for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" type:"string" required:"true"`
}

// String returns the string representation
func (s PutEmailIdentityFeedbackAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityFeedbackAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityFeedbackAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityFeedbackAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailForwardingEnabled sets the EmailForwardingEnabled field's value.
func (s *PutEmailIdentityFeedbackAttributesInput) SetEmailForwardingEnabled(v bool) *PutEmailIdentityFeedbackAttributesInput {
	s.EmailForwardingEnabled = &v
	return s
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityFeedbackAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityFeedbackAttributesInput {
	s.EmailIdentity = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityFeedbackAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityFeedbackAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityFeedbackAttributesOutput) GoString() string {
	return s.String()
}

// A request to configure the custom MAIL FROM domain for a verified identity.
type PutEmailIdentityMailFromAttributesInput struct {
	_ struct{} `type:"structure"`

	// The action that you want Amazon Pinpoint to take if it can't read the required
	// MX record when you send an email. When you set this value to UseDefaultValue,
	// Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set
	// this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified
	// error, and doesn't attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration
	// is in the Pending, Failed, and TemporaryFailure states.
	BehaviorOnMxFailure *string `type:"string" enum:"BehaviorOnMxFailure"`

	// The verified email identity that you want to set up the custom MAIL FROM
	// domain for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" type:"string" required:"true"`

	// The custom MAIL FROM domain that you want the verified identity to use. The
	// MAIL FROM domain must meet the following criteria:
	//
	//    * It has to be a subdomain of the verified identity.
	//
	//    * It can't be used to receive email.
	//
	//    * It can't be used in a "From" address if the MAIL FROM domain is a destination
	//    for feedback forwarding emails.
	MailFromDomain *string `type:"string"`
}

// String returns the string representation
func (s PutEmailIdentityMailFromAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityMailFromAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityMailFromAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityMailFromAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBehaviorOnMxFailure sets the BehaviorOnMxFailure field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetBehaviorOnMxFailure(v string) *PutEmailIdentityMailFromAttributesInput {
	s.BehaviorOnMxFailure = &v
	return s
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityMailFromAttributesInput {
	s.EmailIdentity = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetMailFromDomain(v string) *PutEmailIdentityMailFromAttributesInput {
	s.MailFromDomain = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityMailFromAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityMailFromAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityMailFromAttributesOutput) GoString() string {
	return s.String()
}

// The raw email message.
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * Attachments must be in a file format that Amazon Pinpoint supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RawMessage"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *RawMessage) SetData(v []byte) *RawMessage {
	s.Data = v
	return s
}

// Enable or disable collection of reputation metrics for emails that you send
// using this configuration set in the current AWS Region.
type ReputationOptions struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) when the reputation metrics were last given
	// a fresh start. When your account is given a fresh start, your reputation
	// metrics are calculated starting from the date of the fresh start.
	LastFreshStart *time.Time `type:"timestamp"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReputationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReputationOptions) GoString() string {
	return s.String()
}

// SetLastFreshStart sets the LastFreshStart field's value.
func (s *ReputationOptions) SetLastFreshStart(v time.Time) *ReputationOptions {
	s.LastFreshStart = &v
	return s
}

// SetReputationMetricsEnabled sets the ReputationMetricsEnabled field's value.
func (s *ReputationOptions) SetReputationMetricsEnabled(v bool) *ReputationOptions {
	s.ReputationMetricsEnabled = &v
	return s
}

// A request to send an email message.
type SendEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to use when sending the email.
	ConfigurationSetName *string `type:"string"`

	// An object that contains the body of the message. You can send either a Simple
	// message or a Raw message.
	//
	// Content is a required field
	Content *EmailContent `type:"structure" required:"true"`

	// An object that contains the recipients of the email message.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using the SendEmail operation. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	EmailTags []*MessageTag `type:"list"`

	// The address that Amazon Pinpoint should send bounce and complaint notifications
	// to.
	FeedbackForwardingEmailAddress *string `type:"string"`

	// The email address that you want to use as the "From" address for the email.
	// The address that you specify has to be verified.
	FromEmailAddress *string `type:"string"`

	// The "Reply-to" email addresses for the message. When the recipient replies
	// to the message, each Reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEmailInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailTags != nil {
		for i, v := range s.EmailTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EmailTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendEmailInput) SetConfigurationSetName(v string) *SendEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendEmailInput) SetContent(v *EmailContent) *SendEmailInput {
	s.Content = v
	return s
}

// SetDestination sets the Destination field's value.
func (s *SendEmailInput) SetDestination(v *Destination) *SendEmailInput {
	s.Destination = v
	return s
}

// SetEmailTags sets the EmailTags field's value.
func (s *SendEmailInput) SetEmailTags(v []*MessageTag) *SendEmailInput {
	s.EmailTags = v
	return s
}

// SetFeedbackForwardingEmailAddress sets the FeedbackForwardingEmailAddress field's value.
func (s *SendEmailInput) SetFeedbackForwardingEmailAddress(v string) *SendEmailInput {
	s.FeedbackForwardingEmailAddress = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *SendEmailInput) SetFromEmailAddress(v string) *SendEmailInput {
	s.FromEmailAddress = &v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendEmailInput) SetReplyToAddresses(v []*string) *SendEmailInput {
	s.ReplyToAddresses = v
	return s
}

// A unique message ID that you receive when Amazon Pinpoint accepts an email
// for sending.
type SendEmailOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the message that is generated when Amazon Pinpoint
	// accepts the message.
	//
	// It is possible for Amazon Pinpoint to accept a message without sending it.
	// This can happen when the message you're trying to send has an attachment
	// doesn't pass a virus check, or when you send a templated email that contains
	// invalid personalization content, for example.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendEmailOutput) SetMessageId(v string) *SendEmailOutput {
	s.MessageId = &v
	return s
}

// An object that contains information about the per-day and per-second sending
// limits for your Amazon Pinpoint account in the current AWS Region.
type SendQuota struct {
	_ struct{} `type:"structure"`

	// The maximum number of emails that you can send in the current AWS Region
	// over a 24-hour period. This value is also called your sending quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that you can send per second in the current
	// AWS Region. This value is also called your maximum sending rate or your maximum
	// TPS (transactions per second) rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent from your Amazon Pinpoint account in the current
	// AWS Region over the past 24 hours.
	SentLast24Hours *float64 `type:"double"`
}

// String returns the string representation
func (s SendQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendQuota) GoString() string {
	return s.String()
}

// SetMax24HourSend sets the Max24HourSend field's value.
func (s *SendQuota) SetMax24HourSend(v float64) *SendQuota {
	s.Max24HourSend = &v
	return s
}

// SetMaxSendRate sets the MaxSendRate field's value.
func (s *SendQuota) SetMaxSendRate(v float64) *SendQuota {
	s.MaxSendRate = &v
	return s
}

// SetSentLast24Hours sets the SentLast24Hours field's value.
func (s *SendQuota) SetSentLast24Hours(v float64) *SendQuota {
	s.SentLast24Hours = &v
	return s
}

// Used to enable or disable email sending for messages that use this configuration
// set in the current AWS Region.
type SendingOptions struct {
	_ struct{} `type:"structure"`

	// If true, email sending is enabled for the configuration set. If false, email
	// sending is disabled for the configuration set.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s SendingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendingOptions) GoString() string {
	return s.String()
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *SendingOptions) SetSendingEnabled(v bool) *SendingOptions {
	s.SendingEnabled = &v
	return s
}

// The message can't be sent because the account's ability to send email is
// currently paused.
type SendingPausedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SendingPausedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendingPausedException) GoString() string {
	return s.String()
}

func newErrorSendingPausedException(v protocol.ResponseMetadata) error {
	return &SendingPausedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SendingPausedException) Code() string {
	return "SendingPausedException"
}

// Message returns the exception's message.
func (s *SendingPausedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SendingPausedException) OrigErr() error {
	return nil
}

func (s *SendingPausedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SendingPausedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SendingPausedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines an Amazon SNS destination for email events. You can
// use Amazon SNS to send notification when certain email events occur.
type SnsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// email events to. For more information about Amazon SNS topics, see the Amazon
	// SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SnsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsDestination"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsDestination) SetTopicArn(v string) *SnsDestination {
	s.TopicArn = &v
	return s
}

// An object that defines the tags that are associated with a resource. A tag
// is a label that you optionally define and associate with a resource in Amazon
// Pinpoint. Tags can help you categorize and manage resources in different
// ways, such as by purpose, owner, environment, or other criteria. A resource
// can have as many as 50 tags.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for a more specific tag value. A tag value acts as a descriptor within a
// tag key. A tag key can contain as many as 128 characters. A tag value can
// contain as many as 256 characters. The characters can be Unicode letters,
// digits, white space, or one of the following symbols: _ . : / = + -. The
// following additional restrictions apply to tags:
//
//    * Tag keys and values are case sensitive.
//
//    * For each associated resource, each tag key must be unique and it can
//    have only one value.
//
//    * The aws: prefix is reserved for use by AWS; you can’t use it in any
//    tag keys or values that you define. In addition, you can't edit or remove
//    tag keys or values that use this prefix. Tags that use this prefix don’t
//    count against the limit of 50 tags per resource.
//
//    * You can associate tags with public or shared resources, but the tags
//    are available only for your AWS account, not any other accounts that share
//    the resource. In addition, the tags are available only for resources that
//    are located in the specified AWS Region for your AWS account.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that defines a tag. The maximum length of a
	// tag key is 128 characters. The minimum length is 1 character.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The optional part of a key-value pair that defines a tag. The maximum length
	// of a tag value is 256 characters. The minimum length is 0 characters. If
	// you don’t want a resource to have a specific tag value, don’t specify
	// a value for this parameter. Amazon Pinpoint will set the value to an empty
	// string.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to add one or
	// more tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of the tags that you want to add to the resource. A tag consists of
	// a required tag key (Key) and an associated tag value (Value). The maximum
	// length of a tag key is 128 characters. The maximum length of a tag value
	// is 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type Template struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string `type:"string"`

	// An object that defines the values to use for message variables in the template.
	// This object is a set of key-value pairs. Each key defines a message variable
	// in the template. The corresponding value defines the value to use for that
	// variable.
	TemplateData *string `type:"string"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Template) GoString() string {
	return s.String()
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *Template) SetTemplateArn(v string) *Template {
	s.TemplateArn = &v
	return s
}

// SetTemplateData sets the TemplateData field's value.
func (s *Template) SetTemplateData(v string) *Template {
	s.TemplateData = &v
	return s
}

// Too many requests have been made to the operation.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines the tracking options for a configuration set. When
// you use Amazon Pinpoint to send an email, it contains an invisible image
// that's used to track when recipients open your email. If your email contains
// links, those links are changed slightly in order to track when recipients
// click them.
//
// These images and links include references to a domain operated by AWS. You
// can optionally configure Amazon Pinpoint to use a domain that you operate
// for these images and links.
type TrackingOptions struct {
	_ struct{} `type:"structure"`

	// The domain that you want to use for tracking open and click events.
	//
	// CustomRedirectDomain is a required field
	CustomRedirectDomain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TrackingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrackingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrackingOptions"}
	if s.CustomRedirectDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomRedirectDomain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomRedirectDomain sets the CustomRedirectDomain field's value.
func (s *TrackingOptions) SetCustomRedirectDomain(v string) *TrackingOptions {
	s.CustomRedirectDomain = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove one
	// or more tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags (tag keys) that you want to remove from the resource. When you specify
	// a tag key, the action removes both that key and its associated tag value.
	//
	// To remove more than one tag from the resource, append the TagKeys parameter
	// and argument for each additional tag to remove, separated by an ampersand.
	// For example: /v1/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"TagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// A request to change the settings for an event destination for a configuration
// set.
type UpdateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination that
	// you want to modify.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines the event destination.
	//
	// EventDestination is a required field
	EventDestination *EventDestinationDefinition `type:"structure" required:"true"`

	// The name of the event destination that you want to modify.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type UpdateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// An object that contains information about the amount of email that was delivered
// to recipients.
type VolumeStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of emails that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' inboxes.
	ProjectedInbox *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' spam or junk mail folders.
	ProjectedSpam *int64 `type:"long"`

	// The total number of emails that arrived in recipients' spam or junk mail
	// folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatistics) GoString() string {
	return s.String()
}

// SetInboxRawCount sets the InboxRawCount field's value.
func (s *VolumeStatistics) SetInboxRawCount(v int64) *VolumeStatistics {
	s.InboxRawCount = &v
	return s
}

// SetProjectedInbox sets the ProjectedInbox field's value.
func (s *VolumeStatistics) SetProjectedInbox(v int64) *VolumeStatistics {
	s.ProjectedInbox = &v
	return s
}

// SetProjectedSpam sets the ProjectedSpam field's value.
func (s *VolumeStatistics) SetProjectedSpam(v int64) *VolumeStatistics {
	s.ProjectedSpam = &v
	return s
}

// SetSpamRawCount sets the SpamRawCount field's value.
func (s *VolumeStatistics) SetSpamRawCount(v int64) *VolumeStatistics {
	s.SpamRawCount = &v
	return s
}

// The action that you want Amazon Pinpoint to take if it can't read the required
// MX record for a custom MAIL FROM domain. When you set this value to UseDefaultValue,
// Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set
// this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified
// error, and doesn't attempt to deliver the email.
//
// These behaviors are taken when the custom MAIL FROM domain configuration
// is in the Pending, Failed, and TemporaryFailure states.
const (
	// BehaviorOnMxFailureUseDefaultValue is a BehaviorOnMxFailure enum value
	BehaviorOnMxFailureUseDefaultValue = "USE_DEFAULT_VALUE"

	// BehaviorOnMxFailureRejectMessage is a BehaviorOnMxFailure enum value
	BehaviorOnMxFailureRejectMessage = "REJECT_MESSAGE"
)

// The current status of your Deliverability dashboard subscription. If this
// value is PENDING_EXPIRATION, your subscription is scheduled to expire at
// the end of the current calendar month.
const (
	// DeliverabilityDashboardAccountStatusActive is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusActive = "ACTIVE"

	// DeliverabilityDashboardAccountStatusPendingExpiration is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusPendingExpiration = "PENDING_EXPIRATION"

	// DeliverabilityDashboardAccountStatusDisabled is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusDisabled = "DISABLED"
)

// The status of a predictive inbox placement test. If the status is IN_PROGRESS,
// then the predictive inbox placement test is currently running. Predictive
// inbox placement tests are usually complete within 24 hours of creating the
// test. If the status is COMPLETE, then the test is finished, and you can use
// the GetDeliverabilityTestReport operation to view the results of the test.
const (
	// DeliverabilityTestStatusInProgress is a DeliverabilityTestStatus enum value
	DeliverabilityTestStatusInProgress = "IN_PROGRESS"

	// DeliverabilityTestStatusCompleted is a DeliverabilityTestStatus enum value
	DeliverabilityTestStatusCompleted = "COMPLETED"
)

// The location where Amazon Pinpoint finds the value of a dimension to publish
// to Amazon CloudWatch. If you want Amazon Pinpoint to use the message tags
// that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the
// SendEmail/SendRawEmail API, choose messageTag. If you want Amazon Pinpoint
// to use your own email headers, choose emailHeader. If you want Amazon Pinpoint
// to use link tags, choose linkTags.
const (
	// DimensionValueSourceMessageTag is a DimensionValueSource enum value
	DimensionValueSourceMessageTag = "MESSAGE_TAG"

	// DimensionValueSourceEmailHeader is a DimensionValueSource enum value
	DimensionValueSourceEmailHeader = "EMAIL_HEADER"

	// DimensionValueSourceLinkTag is a DimensionValueSource enum value
	DimensionValueSourceLinkTag = "LINK_TAG"
)

// The DKIM authentication status of the identity. The status can be one of
// the following:
//
//    * PENDING – The DKIM verification process was initiated, and Amazon
//    Pinpoint is still waiting for the required CNAME records to appear in
//    the DNS configuration for the domain.
//
//    * SUCCESS – The DKIM authentication process completed successfully.
//
//    * FAILED – The DKIM authentication process failed. This can happen when
//    Amazon Pinpoint fails to find the required CNAME records in the DNS configuration
//    of the domain.
//
//    * TEMPORARY_FAILURE – A temporary issue is preventing Amazon Pinpoint
//    from determining the DKIM authentication status of the domain.
//
//    * NOT_STARTED – The DKIM verification process hasn't been initiated
//    for the domain.
const (
	// DkimStatusPending is a DkimStatus enum value
	DkimStatusPending = "PENDING"

	// DkimStatusSuccess is a DkimStatus enum value
	DkimStatusSuccess = "SUCCESS"

	// DkimStatusFailed is a DkimStatus enum value
	DkimStatusFailed = "FAILED"

	// DkimStatusTemporaryFailure is a DkimStatus enum value
	DkimStatusTemporaryFailure = "TEMPORARY_FAILURE"

	// DkimStatusNotStarted is a DkimStatus enum value
	DkimStatusNotStarted = "NOT_STARTED"
)

// An email sending event type. For example, email sends, opens, and bounces
// are all email events.
const (
	// EventTypeSend is a EventType enum value
	EventTypeSend = "SEND"

	// EventTypeReject is a EventType enum value
	EventTypeReject = "REJECT"

	// EventTypeBounce is a EventType enum value
	EventTypeBounce = "BOUNCE"

	// EventTypeComplaint is a EventType enum value
	EventTypeComplaint = "COMPLAINT"

	// EventTypeDelivery is a EventType enum value
	EventTypeDelivery = "DELIVERY"

	// EventTypeOpen is a EventType enum value
	EventTypeOpen = "OPEN"

	// EventTypeClick is a EventType enum value
	EventTypeClick = "CLICK"

	// EventTypeRenderingFailure is a EventType enum value
	EventTypeRenderingFailure = "RENDERING_FAILURE"
)

// The email identity type. The identity type can be one of the following:
//
//    * EMAIL_ADDRESS – The identity is an email address.
//
//    * DOMAIN – The identity is a domain.
const (
	// IdentityTypeEmailAddress is a IdentityType enum value
	IdentityTypeEmailAddress = "EMAIL_ADDRESS"

	// IdentityTypeDomain is a IdentityType enum value
	IdentityTypeDomain = "DOMAIN"

	// IdentityTypeManagedDomain is a IdentityType enum value
	IdentityTypeManagedDomain = "MANAGED_DOMAIN"
)

// The status of the MAIL FROM domain. This status can have the following values:
//
//    * PENDING – Amazon Pinpoint hasn't started searching for the MX record
//    yet.
//
//    * SUCCESS – Amazon Pinpoint detected the required MX record for the
//    MAIL FROM domain.
//
//    * FAILED – Amazon Pinpoint can't find the required MX record, or the
//    record no longer exists.
//
//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
//    Pinpoint from determining the status of the MAIL FROM domain.
const (
	// MailFromDomainStatusPending is a MailFromDomainStatus enum value
	MailFromDomainStatusPending = "PENDING"

	// MailFromDomainStatusSuccess is a MailFromDomainStatus enum value
	MailFromDomainStatusSuccess = "SUCCESS"

	// MailFromDomainStatusFailed is a MailFromDomainStatus enum value
	MailFromDomainStatusFailed = "FAILED"

	// MailFromDomainStatusTemporaryFailure is a MailFromDomainStatus enum value
	MailFromDomainStatusTemporaryFailure = "TEMPORARY_FAILURE"
)

// Specifies whether messages that use the configuration set are required to
// use Transport Layer Security (TLS). If the value is Require, messages are
// only delivered if a TLS connection can be established. If the value is Optional,
// messages can be delivered in plain text if a TLS connection can't be established.
const (
	// TlsPolicyRequire is a TlsPolicy enum value
	TlsPolicyRequire = "REQUIRE"

	// TlsPolicyOptional is a TlsPolicy enum value
	TlsPolicyOptional = "OPTIONAL"
)

// The warmup status of a dedicated IP.
const (
	// WarmupStatusInProgress is a WarmupStatus enum value
	WarmupStatusInProgress = "IN_PROGRESS"

	// WarmupStatusDone is a WarmupStatus enum value
	WarmupStatusDone = "DONE"
)
