// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptResourceShareInvitation = "AcceptResourceShareInvitation"

// AcceptResourceShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptResourceShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptResourceShareInvitation for more information on using the AcceptResourceShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptResourceShareInvitationRequest method.
//    req, resp := client.AcceptResourceShareInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation
func (c *RAM) AcceptResourceShareInvitationRequest(input *AcceptResourceShareInvitationInput) (req *request.Request, output *AcceptResourceShareInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptResourceShareInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/acceptresourceshareinvitation",
	}

	if input == nil {
		input = &AcceptResourceShareInvitationInput{}
	}

	output = &AcceptResourceShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptResourceShareInvitation API operation for AWS Resource Access Manager.
//
// Accepts an invitation to a resource share from another AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AcceptResourceShareInvitation for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ResourceShareInvitationArnNotFoundException
//   The Amazon Resource Name (ARN) for an invitation was not found.
//
//   * ResourceShareInvitationAlreadyAcceptedException
//   The invitation was already accepted.
//
//   * ResourceShareInvitationAlreadyRejectedException
//   The invitation was already rejected.
//
//   * ResourceShareInvitationExpiredException
//   The invitation is expired.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation
func (c *RAM) AcceptResourceShareInvitation(input *AcceptResourceShareInvitationInput) (*AcceptResourceShareInvitationOutput, error) {
	req, out := c.AcceptResourceShareInvitationRequest(input)
	return out, req.Send()
}

// AcceptResourceShareInvitationWithContext is the same as AcceptResourceShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptResourceShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AcceptResourceShareInvitationWithContext(ctx aws.Context, input *AcceptResourceShareInvitationInput, opts ...request.Option) (*AcceptResourceShareInvitationOutput, error) {
	req, out := c.AcceptResourceShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResourceShare = "AssociateResourceShare"

// AssociateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResourceShare for more information on using the AssociateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResourceShareRequest method.
//    req, resp := client.AssociateResourceShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare
func (c *RAM) AssociateResourceShareRequest(input *AssociateResourceShareInput) (req *request.Request, output *AssociateResourceShareOutput) {
	op := &request.Operation{
		Name:       opAssociateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/associateresourceshare",
	}

	if input == nil {
		input = &AssociateResourceShareInput{}
	}

	output = &AssociateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResourceShare API operation for AWS Resource Access Manager.
//
// Associates the specified resource share with the specified principals and
// resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AssociateResourceShare for usage and error information.
//
// Returned Error Types:
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * InvalidStateTransitionException
//   The requested state transition is not valid.
//
//   * ResourceShareLimitExceededException
//   The requested resource share exceeds the limit for your account.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidStateTransitionException
//   The requested state transition is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare
func (c *RAM) AssociateResourceShare(input *AssociateResourceShareInput) (*AssociateResourceShareOutput, error) {
	req, out := c.AssociateResourceShareRequest(input)
	return out, req.Send()
}

// AssociateResourceShareWithContext is the same as AssociateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AssociateResourceShareWithContext(ctx aws.Context, input *AssociateResourceShareInput, opts ...request.Option) (*AssociateResourceShareOutput, error) {
	req, out := c.AssociateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResourceSharePermission = "AssociateResourceSharePermission"

// AssociateResourceSharePermissionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResourceSharePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResourceSharePermission for more information on using the AssociateResourceSharePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResourceSharePermissionRequest method.
//    req, resp := client.AssociateResourceSharePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission
func (c *RAM) AssociateResourceSharePermissionRequest(input *AssociateResourceSharePermissionInput) (req *request.Request, output *AssociateResourceSharePermissionOutput) {
	op := &request.Operation{
		Name:       opAssociateResourceSharePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/associateresourcesharepermission",
	}

	if input == nil {
		input = &AssociateResourceSharePermissionInput{}
	}

	output = &AssociateResourceSharePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResourceSharePermission API operation for AWS Resource Access Manager.
//
// Associates a permission with a resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AssociateResourceSharePermission for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission
func (c *RAM) AssociateResourceSharePermission(input *AssociateResourceSharePermissionInput) (*AssociateResourceSharePermissionOutput, error) {
	req, out := c.AssociateResourceSharePermissionRequest(input)
	return out, req.Send()
}

// AssociateResourceSharePermissionWithContext is the same as AssociateResourceSharePermission with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResourceSharePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AssociateResourceSharePermissionWithContext(ctx aws.Context, input *AssociateResourceSharePermissionInput, opts ...request.Option) (*AssociateResourceSharePermissionOutput, error) {
	req, out := c.AssociateResourceSharePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceShare = "CreateResourceShare"

// CreateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceShare for more information on using the CreateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceShareRequest method.
//    req, resp := client.CreateResourceShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare
func (c *RAM) CreateResourceShareRequest(input *CreateResourceShareInput) (req *request.Request, output *CreateResourceShareOutput) {
	op := &request.Operation{
		Name:       opCreateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/createresourceshare",
	}

	if input == nil {
		input = &CreateResourceShareInput{}
	}

	output = &CreateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceShare API operation for AWS Resource Access Manager.
//
// Creates a resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation CreateResourceShare for usage and error information.
//
// Returned Error Types:
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
//   * InvalidStateTransitionException
//   The requested state transition is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ResourceShareLimitExceededException
//   The requested resource share exceeds the limit for your account.
//
//   * TagPolicyViolationException
//   The specified tag is a reserved word and cannot be used.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare
func (c *RAM) CreateResourceShare(input *CreateResourceShareInput) (*CreateResourceShareOutput, error) {
	req, out := c.CreateResourceShareRequest(input)
	return out, req.Send()
}

// CreateResourceShareWithContext is the same as CreateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) CreateResourceShareWithContext(ctx aws.Context, input *CreateResourceShareInput, opts ...request.Option) (*CreateResourceShareOutput, error) {
	req, out := c.CreateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceShare = "DeleteResourceShare"

// DeleteResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceShare for more information on using the DeleteResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceShareRequest method.
//    req, resp := client.DeleteResourceShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare
func (c *RAM) DeleteResourceShareRequest(input *DeleteResourceShareInput) (req *request.Request, output *DeleteResourceShareOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deleteresourceshare",
	}

	if input == nil {
		input = &DeleteResourceShareInput{}
	}

	output = &DeleteResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourceShare API operation for AWS Resource Access Manager.
//
// Deletes the specified resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DeleteResourceShare for usage and error information.
//
// Returned Error Types:
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
//   * InvalidStateTransitionException
//   The requested state transition is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare
func (c *RAM) DeleteResourceShare(input *DeleteResourceShareInput) (*DeleteResourceShareOutput, error) {
	req, out := c.DeleteResourceShareRequest(input)
	return out, req.Send()
}

// DeleteResourceShareWithContext is the same as DeleteResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DeleteResourceShareWithContext(ctx aws.Context, input *DeleteResourceShareInput, opts ...request.Option) (*DeleteResourceShareOutput, error) {
	req, out := c.DeleteResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResourceShare = "DisassociateResourceShare"

// DisassociateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResourceShare for more information on using the DisassociateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResourceShareRequest method.
//    req, resp := client.DisassociateResourceShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare
func (c *RAM) DisassociateResourceShareRequest(input *DisassociateResourceShareInput) (req *request.Request, output *DisassociateResourceShareOutput) {
	op := &request.Operation{
		Name:       opDisassociateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateresourceshare",
	}

	if input == nil {
		input = &DisassociateResourceShareInput{}
	}

	output = &DisassociateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResourceShare API operation for AWS Resource Access Manager.
//
// Disassociates the specified principals or resources from the specified resource
// share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DisassociateResourceShare for usage and error information.
//
// Returned Error Types:
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
//   * ResourceShareLimitExceededException
//   The requested resource share exceeds the limit for your account.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidStateTransitionException
//   The requested state transition is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare
func (c *RAM) DisassociateResourceShare(input *DisassociateResourceShareInput) (*DisassociateResourceShareOutput, error) {
	req, out := c.DisassociateResourceShareRequest(input)
	return out, req.Send()
}

// DisassociateResourceShareWithContext is the same as DisassociateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DisassociateResourceShareWithContext(ctx aws.Context, input *DisassociateResourceShareInput, opts ...request.Option) (*DisassociateResourceShareOutput, error) {
	req, out := c.DisassociateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResourceSharePermission = "DisassociateResourceSharePermission"

// DisassociateResourceSharePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResourceSharePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResourceSharePermission for more information on using the DisassociateResourceSharePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResourceSharePermissionRequest method.
//    req, resp := client.DisassociateResourceSharePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission
func (c *RAM) DisassociateResourceSharePermissionRequest(input *DisassociateResourceSharePermissionInput) (req *request.Request, output *DisassociateResourceSharePermissionOutput) {
	op := &request.Operation{
		Name:       opDisassociateResourceSharePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateresourcesharepermission",
	}

	if input == nil {
		input = &DisassociateResourceSharePermissionInput{}
	}

	output = &DisassociateResourceSharePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResourceSharePermission API operation for AWS Resource Access Manager.
//
// Disassociates an AWS RAM permission from a resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DisassociateResourceSharePermission for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission
func (c *RAM) DisassociateResourceSharePermission(input *DisassociateResourceSharePermissionInput) (*DisassociateResourceSharePermissionOutput, error) {
	req, out := c.DisassociateResourceSharePermissionRequest(input)
	return out, req.Send()
}

// DisassociateResourceSharePermissionWithContext is the same as DisassociateResourceSharePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResourceSharePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DisassociateResourceSharePermissionWithContext(ctx aws.Context, input *DisassociateResourceSharePermissionInput, opts ...request.Option) (*DisassociateResourceSharePermissionOutput, error) {
	req, out := c.DisassociateResourceSharePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSharingWithAwsOrganization = "EnableSharingWithAwsOrganization"

// EnableSharingWithAwsOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the EnableSharingWithAwsOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSharingWithAwsOrganization for more information on using the EnableSharingWithAwsOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSharingWithAwsOrganizationRequest method.
//    req, resp := client.EnableSharingWithAwsOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization
func (c *RAM) EnableSharingWithAwsOrganizationRequest(input *EnableSharingWithAwsOrganizationInput) (req *request.Request, output *EnableSharingWithAwsOrganizationOutput) {
	op := &request.Operation{
		Name:       opEnableSharingWithAwsOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/enablesharingwithawsorganization",
	}

	if input == nil {
		input = &EnableSharingWithAwsOrganizationInput{}
	}

	output = &EnableSharingWithAwsOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableSharingWithAwsOrganization API operation for AWS Resource Access Manager.
//
// Enables resource sharing within your AWS Organization.
//
// The caller must be the master account for the AWS Organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation EnableSharingWithAwsOrganization for usage and error information.
//
// Returned Error Types:
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization
func (c *RAM) EnableSharingWithAwsOrganization(input *EnableSharingWithAwsOrganizationInput) (*EnableSharingWithAwsOrganizationOutput, error) {
	req, out := c.EnableSharingWithAwsOrganizationRequest(input)
	return out, req.Send()
}

// EnableSharingWithAwsOrganizationWithContext is the same as EnableSharingWithAwsOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSharingWithAwsOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) EnableSharingWithAwsOrganizationWithContext(ctx aws.Context, input *EnableSharingWithAwsOrganizationInput, opts ...request.Option) (*EnableSharingWithAwsOrganizationOutput, error) {
	req, out := c.EnableSharingWithAwsOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermission = "GetPermission"

// GetPermissionRequest generates a "aws/request.Request" representing the
// client's request for the GetPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermission for more information on using the GetPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPermissionRequest method.
//    req, resp := client.GetPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission
func (c *RAM) GetPermissionRequest(input *GetPermissionInput) (req *request.Request, output *GetPermissionOutput) {
	op := &request.Operation{
		Name:       opGetPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/getpermission",
	}

	if input == nil {
		input = &GetPermissionInput{}
	}

	output = &GetPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermission API operation for AWS Resource Access Manager.
//
// Gets the contents of an AWS RAM permission in JSON format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetPermission for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission
func (c *RAM) GetPermission(input *GetPermissionInput) (*GetPermissionOutput, error) {
	req, out := c.GetPermissionRequest(input)
	return out, req.Send()
}

// GetPermissionWithContext is the same as GetPermission with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetPermissionWithContext(ctx aws.Context, input *GetPermissionInput, opts ...request.Option) (*GetPermissionOutput, error) {
	req, out := c.GetPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicies = "GetResourcePolicies"

// GetResourcePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicies for more information on using the GetResourcePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePoliciesRequest method.
//    req, resp := client.GetResourcePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies
func (c *RAM) GetResourcePoliciesRequest(input *GetResourcePoliciesInput) (req *request.Request, output *GetResourcePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourcepolicies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcePoliciesInput{}
	}

	output = &GetResourcePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicies API operation for AWS Resource Access Manager.
//
// Gets the policies for the specified resources that you own and have shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourcePolicies for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies
func (c *RAM) GetResourcePolicies(input *GetResourcePoliciesInput) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	return out, req.Send()
}

// GetResourcePoliciesWithContext is the same as GetResourcePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourcePoliciesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, opts ...request.Option) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcePoliciesPages iterates over the pages of a GetResourcePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourcePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourcePolicies operation.
//    pageNum := 0
//    err := client.GetResourcePoliciesPages(params,
//        func(page *ram.GetResourcePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) GetResourcePoliciesPages(input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool) error {
	return c.GetResourcePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcePoliciesPagesWithContext same as GetResourcePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourcePoliciesPagesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShareAssociations = "GetResourceShareAssociations"

// GetResourceShareAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShareAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShareAssociations for more information on using the GetResourceShareAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceShareAssociationsRequest method.
//    req, resp := client.GetResourceShareAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations
func (c *RAM) GetResourceShareAssociationsRequest(input *GetResourceShareAssociationsInput) (req *request.Request, output *GetResourceShareAssociationsOutput) {
	op := &request.Operation{
		Name:       opGetResourceShareAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshareassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceShareAssociationsInput{}
	}

	output = &GetResourceShareAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShareAssociations API operation for AWS Resource Access Manager.
//
// Gets the resources or principals for the resource shares that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShareAssociations for usage and error information.
//
// Returned Error Types:
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations
func (c *RAM) GetResourceShareAssociations(input *GetResourceShareAssociationsInput) (*GetResourceShareAssociationsOutput, error) {
	req, out := c.GetResourceShareAssociationsRequest(input)
	return out, req.Send()
}

// GetResourceShareAssociationsWithContext is the same as GetResourceShareAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShareAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareAssociationsWithContext(ctx aws.Context, input *GetResourceShareAssociationsInput, opts ...request.Option) (*GetResourceShareAssociationsOutput, error) {
	req, out := c.GetResourceShareAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceShareAssociationsPages iterates over the pages of a GetResourceShareAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShareAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceShareAssociations operation.
//    pageNum := 0
//    err := client.GetResourceShareAssociationsPages(params,
//        func(page *ram.GetResourceShareAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) GetResourceShareAssociationsPages(input *GetResourceShareAssociationsInput, fn func(*GetResourceShareAssociationsOutput, bool) bool) error {
	return c.GetResourceShareAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceShareAssociationsPagesWithContext same as GetResourceShareAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareAssociationsPagesWithContext(ctx aws.Context, input *GetResourceShareAssociationsInput, fn func(*GetResourceShareAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceShareAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceShareAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceShareAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShareInvitations = "GetResourceShareInvitations"

// GetResourceShareInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShareInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShareInvitations for more information on using the GetResourceShareInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceShareInvitationsRequest method.
//    req, resp := client.GetResourceShareInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations
func (c *RAM) GetResourceShareInvitationsRequest(input *GetResourceShareInvitationsInput) (req *request.Request, output *GetResourceShareInvitationsOutput) {
	op := &request.Operation{
		Name:       opGetResourceShareInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshareinvitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceShareInvitationsInput{}
	}

	output = &GetResourceShareInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShareInvitations API operation for AWS Resource Access Manager.
//
// Gets the invitations for resource sharing that you've received.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShareInvitations for usage and error information.
//
// Returned Error Types:
//   * ResourceShareInvitationArnNotFoundException
//   The Amazon Resource Name (ARN) for an invitation was not found.
//
//   * InvalidMaxResultsException
//   The specified value for MaxResults is not valid.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations
func (c *RAM) GetResourceShareInvitations(input *GetResourceShareInvitationsInput) (*GetResourceShareInvitationsOutput, error) {
	req, out := c.GetResourceShareInvitationsRequest(input)
	return out, req.Send()
}

// GetResourceShareInvitationsWithContext is the same as GetResourceShareInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShareInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareInvitationsWithContext(ctx aws.Context, input *GetResourceShareInvitationsInput, opts ...request.Option) (*GetResourceShareInvitationsOutput, error) {
	req, out := c.GetResourceShareInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceShareInvitationsPages iterates over the pages of a GetResourceShareInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShareInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceShareInvitations operation.
//    pageNum := 0
//    err := client.GetResourceShareInvitationsPages(params,
//        func(page *ram.GetResourceShareInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) GetResourceShareInvitationsPages(input *GetResourceShareInvitationsInput, fn func(*GetResourceShareInvitationsOutput, bool) bool) error {
	return c.GetResourceShareInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceShareInvitationsPagesWithContext same as GetResourceShareInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareInvitationsPagesWithContext(ctx aws.Context, input *GetResourceShareInvitationsInput, fn func(*GetResourceShareInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceShareInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceShareInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceShareInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShares = "GetResourceShares"

// GetResourceSharesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShares for more information on using the GetResourceShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceSharesRequest method.
//    req, resp := client.GetResourceSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares
func (c *RAM) GetResourceSharesRequest(input *GetResourceSharesInput) (req *request.Request, output *GetResourceSharesOutput) {
	op := &request.Operation{
		Name:       opGetResourceShares,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceSharesInput{}
	}

	output = &GetResourceSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShares API operation for AWS Resource Access Manager.
//
// Gets the resource shares that you own or the resource shares that are shared
// with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShares for usage and error information.
//
// Returned Error Types:
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares
func (c *RAM) GetResourceShares(input *GetResourceSharesInput) (*GetResourceSharesOutput, error) {
	req, out := c.GetResourceSharesRequest(input)
	return out, req.Send()
}

// GetResourceSharesWithContext is the same as GetResourceShares with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceSharesWithContext(ctx aws.Context, input *GetResourceSharesInput, opts ...request.Option) (*GetResourceSharesOutput, error) {
	req, out := c.GetResourceSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceSharesPages iterates over the pages of a GetResourceShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceShares operation.
//    pageNum := 0
//    err := client.GetResourceSharesPages(params,
//        func(page *ram.GetResourceSharesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) GetResourceSharesPages(input *GetResourceSharesInput, fn func(*GetResourceSharesOutput, bool) bool) error {
	return c.GetResourceSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceSharesPagesWithContext same as GetResourceSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceSharesPagesWithContext(ctx aws.Context, input *GetResourceSharesInput, fn func(*GetResourceSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPendingInvitationResources = "ListPendingInvitationResources"

// ListPendingInvitationResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListPendingInvitationResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPendingInvitationResources for more information on using the ListPendingInvitationResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPendingInvitationResourcesRequest method.
//    req, resp := client.ListPendingInvitationResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources
func (c *RAM) ListPendingInvitationResourcesRequest(input *ListPendingInvitationResourcesInput) (req *request.Request, output *ListPendingInvitationResourcesOutput) {
	op := &request.Operation{
		Name:       opListPendingInvitationResources,
		HTTPMethod: "POST",
		HTTPPath:   "/listpendinginvitationresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPendingInvitationResourcesInput{}
	}

	output = &ListPendingInvitationResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPendingInvitationResources API operation for AWS Resource Access Manager.
//
// Lists the resources in a resource share that is shared with you but that
// the invitation is still pending for.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPendingInvitationResources for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * ResourceShareInvitationArnNotFoundException
//   The Amazon Resource Name (ARN) for an invitation was not found.
//
//   * MissingRequiredParameterException
//   A required input parameter is missing.
//
//   * ResourceShareInvitationAlreadyRejectedException
//   The invitation was already rejected.
//
//   * ResourceShareInvitationExpiredException
//   The invitation is expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources
func (c *RAM) ListPendingInvitationResources(input *ListPendingInvitationResourcesInput) (*ListPendingInvitationResourcesOutput, error) {
	req, out := c.ListPendingInvitationResourcesRequest(input)
	return out, req.Send()
}

// ListPendingInvitationResourcesWithContext is the same as ListPendingInvitationResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListPendingInvitationResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPendingInvitationResourcesWithContext(ctx aws.Context, input *ListPendingInvitationResourcesInput, opts ...request.Option) (*ListPendingInvitationResourcesOutput, error) {
	req, out := c.ListPendingInvitationResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPendingInvitationResourcesPages iterates over the pages of a ListPendingInvitationResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPendingInvitationResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPendingInvitationResources operation.
//    pageNum := 0
//    err := client.ListPendingInvitationResourcesPages(params,
//        func(page *ram.ListPendingInvitationResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) ListPendingInvitationResourcesPages(input *ListPendingInvitationResourcesInput, fn func(*ListPendingInvitationResourcesOutput, bool) bool) error {
	return c.ListPendingInvitationResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPendingInvitationResourcesPagesWithContext same as ListPendingInvitationResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPendingInvitationResourcesPagesWithContext(ctx aws.Context, input *ListPendingInvitationResourcesInput, fn func(*ListPendingInvitationResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPendingInvitationResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPendingInvitationResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPendingInvitationResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionsRequest method.
//    req, resp := client.ListPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions
func (c *RAM) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/listpermissions",
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Resource Access Manager.
//
// Lists the AWS RAM permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions
func (c *RAM) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipals = "ListPrincipals"

// ListPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipals for more information on using the ListPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPrincipalsRequest method.
//    req, resp := client.ListPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals
func (c *RAM) ListPrincipalsRequest(input *ListPrincipalsInput) (req *request.Request, output *ListPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListPrincipals,
		HTTPMethod: "POST",
		HTTPPath:   "/listprincipals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPrincipalsInput{}
	}

	output = &ListPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipals API operation for AWS Resource Access Manager.
//
// Lists the principals that you have shared resources with or that have shared
// resources with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPrincipals for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals
func (c *RAM) ListPrincipals(input *ListPrincipalsInput) (*ListPrincipalsOutput, error) {
	req, out := c.ListPrincipalsRequest(input)
	return out, req.Send()
}

// ListPrincipalsWithContext is the same as ListPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPrincipalsWithContext(ctx aws.Context, input *ListPrincipalsInput, opts ...request.Option) (*ListPrincipalsOutput, error) {
	req, out := c.ListPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPrincipalsPages iterates over the pages of a ListPrincipals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrincipals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPrincipals operation.
//    pageNum := 0
//    err := client.ListPrincipalsPages(params,
//        func(page *ram.ListPrincipalsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) ListPrincipalsPages(input *ListPrincipalsInput, fn func(*ListPrincipalsOutput, bool) bool) error {
	return c.ListPrincipalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPrincipalsPagesWithContext same as ListPrincipalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPrincipalsPagesWithContext(ctx aws.Context, input *ListPrincipalsInput, fn func(*ListPrincipalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPrincipalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPrincipalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPrincipalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceSharePermissions = "ListResourceSharePermissions"

// ListResourceSharePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceSharePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceSharePermissions for more information on using the ListResourceSharePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceSharePermissionsRequest method.
//    req, resp := client.ListResourceSharePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions
func (c *RAM) ListResourceSharePermissionsRequest(input *ListResourceSharePermissionsInput) (req *request.Request, output *ListResourceSharePermissionsOutput) {
	op := &request.Operation{
		Name:       opListResourceSharePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/listresourcesharepermissions",
	}

	if input == nil {
		input = &ListResourceSharePermissionsInput{}
	}

	output = &ListResourceSharePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceSharePermissions API operation for AWS Resource Access Manager.
//
// Lists the AWS RAM permissions that are associated with a resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListResourceSharePermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions
func (c *RAM) ListResourceSharePermissions(input *ListResourceSharePermissionsInput) (*ListResourceSharePermissionsOutput, error) {
	req, out := c.ListResourceSharePermissionsRequest(input)
	return out, req.Send()
}

// ListResourceSharePermissionsWithContext is the same as ListResourceSharePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceSharePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourceSharePermissionsWithContext(ctx aws.Context, input *ListResourceSharePermissionsInput, opts ...request.Option) (*ListResourceSharePermissionsOutput, error) {
	req, out := c.ListResourceSharePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources
func (c *RAM) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/listresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS Resource Access Manager.
//
// Lists the resources that you added to a resource shares or the resources
// that are shared with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceTypeException
//   The specified resource type is not valid.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidNextTokenException
//   The specified value for NextToken is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources
func (c *RAM) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResources operation.
//    pageNum := 0
//    err := client.ListResourcesPages(params,
//        func(page *ram.ListResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RAM) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPromoteResourceShareCreatedFromPolicy = "PromoteResourceShareCreatedFromPolicy"

// PromoteResourceShareCreatedFromPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PromoteResourceShareCreatedFromPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteResourceShareCreatedFromPolicy for more information on using the PromoteResourceShareCreatedFromPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteResourceShareCreatedFromPolicyRequest method.
//    req, resp := client.PromoteResourceShareCreatedFromPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy
func (c *RAM) PromoteResourceShareCreatedFromPolicyRequest(input *PromoteResourceShareCreatedFromPolicyInput) (req *request.Request, output *PromoteResourceShareCreatedFromPolicyOutput) {
	op := &request.Operation{
		Name:       opPromoteResourceShareCreatedFromPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/promoteresourcesharecreatedfrompolicy",
	}

	if input == nil {
		input = &PromoteResourceShareCreatedFromPolicyInput{}
	}

	output = &PromoteResourceShareCreatedFromPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteResourceShareCreatedFromPolicy API operation for AWS Resource Access Manager.
//
// Resource shares that were created by attaching a policy to a resource are
// visible only to the resource share owner, and the resource share cannot be
// modified in AWS RAM.
//
// Use this API action to promote the resource share. When you promote the resource
// share, it becomes:
//
//    * Visible to all principals that it is shared with.
//
//    * Modifiable in AWS RAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation PromoteResourceShareCreatedFromPolicy for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required input parameter is missing.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy
func (c *RAM) PromoteResourceShareCreatedFromPolicy(input *PromoteResourceShareCreatedFromPolicyInput) (*PromoteResourceShareCreatedFromPolicyOutput, error) {
	req, out := c.PromoteResourceShareCreatedFromPolicyRequest(input)
	return out, req.Send()
}

// PromoteResourceShareCreatedFromPolicyWithContext is the same as PromoteResourceShareCreatedFromPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteResourceShareCreatedFromPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) PromoteResourceShareCreatedFromPolicyWithContext(ctx aws.Context, input *PromoteResourceShareCreatedFromPolicyInput, opts ...request.Option) (*PromoteResourceShareCreatedFromPolicyOutput, error) {
	req, out := c.PromoteResourceShareCreatedFromPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectResourceShareInvitation = "RejectResourceShareInvitation"

// RejectResourceShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectResourceShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectResourceShareInvitation for more information on using the RejectResourceShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectResourceShareInvitationRequest method.
//    req, resp := client.RejectResourceShareInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation
func (c *RAM) RejectResourceShareInvitationRequest(input *RejectResourceShareInvitationInput) (req *request.Request, output *RejectResourceShareInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectResourceShareInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/rejectresourceshareinvitation",
	}

	if input == nil {
		input = &RejectResourceShareInvitationInput{}
	}

	output = &RejectResourceShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectResourceShareInvitation API operation for AWS Resource Access Manager.
//
// Rejects an invitation to a resource share from another AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation RejectResourceShareInvitation for usage and error information.
//
// Returned Error Types:
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ResourceShareInvitationArnNotFoundException
//   The Amazon Resource Name (ARN) for an invitation was not found.
//
//   * ResourceShareInvitationAlreadyAcceptedException
//   The invitation was already accepted.
//
//   * ResourceShareInvitationAlreadyRejectedException
//   The invitation was already rejected.
//
//   * ResourceShareInvitationExpiredException
//   The invitation is expired.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation
func (c *RAM) RejectResourceShareInvitation(input *RejectResourceShareInvitationInput) (*RejectResourceShareInvitationOutput, error) {
	req, out := c.RejectResourceShareInvitationRequest(input)
	return out, req.Send()
}

// RejectResourceShareInvitationWithContext is the same as RejectResourceShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectResourceShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) RejectResourceShareInvitationWithContext(ctx aws.Context, input *RejectResourceShareInvitationInput, opts ...request.Option) (*RejectResourceShareInvitationOutput, error) {
	req, out := c.RejectResourceShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource
func (c *RAM) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tagresource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Resource Access Manager.
//
// Adds the specified tags to the specified resource share that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * TagLimitExceededException
//   The requested tags exceed the limit for your account.
//
//   * ResourceArnNotFoundException
//   An Amazon Resource Name (ARN) was not found.
//
//   * TagPolicyViolationException
//   The specified tag is a reserved word and cannot be used.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource
func (c *RAM) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource
func (c *RAM) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untagresource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Resource Access Manager.
//
// Removes the specified tags from the specified resource share that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource
func (c *RAM) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceShare = "UpdateResourceShare"

// UpdateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceShare for more information on using the UpdateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceShareRequest method.
//    req, resp := client.UpdateResourceShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare
func (c *RAM) UpdateResourceShareRequest(input *UpdateResourceShareInput) (req *request.Request, output *UpdateResourceShareOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/updateresourceshare",
	}

	if input == nil {
		input = &UpdateResourceShareInput{}
	}

	output = &UpdateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceShare API operation for AWS Resource Access Manager.
//
// Updates the specified resource share that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation UpdateResourceShare for usage and error information.
//
// Returned Error Types:
//   * IdempotentParameterMismatchException
//   A client token input parameter was reused with an operation, but at least
//   one of the other input parameters is different from the previous call to
//   the operation.
//
//   * MissingRequiredParameterException
//   A required input parameter is missing.
//
//   * UnknownResourceException
//   A specified resource was not found.
//
//   * MalformedArnException
//   The format of an Amazon Resource Name (ARN) is not valid.
//
//   * InvalidClientTokenException
//   A client token is not valid.
//
//   * InvalidParameterException
//   A parameter is not valid.
//
//   * OperationNotPermittedException
//   The requested operation is not permitted.
//
//   * ServerInternalException
//   The service could not respond to the request due to an internal problem.
//
//   * ServiceUnavailableException
//   The service is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare
func (c *RAM) UpdateResourceShare(input *UpdateResourceShareInput) (*UpdateResourceShareOutput, error) {
	req, out := c.UpdateResourceShareRequest(input)
	return out, req.Send()
}

// UpdateResourceShareWithContext is the same as UpdateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) UpdateResourceShareWithContext(ctx aws.Context, input *UpdateResourceShareInput, opts ...request.Option) (*UpdateResourceShareOutput, error) {
	req, out := c.UpdateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptResourceShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) of the invitation.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptResourceShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptResourceShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptResourceShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptResourceShareInvitationInput"}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptResourceShareInvitationInput) SetClientToken(v string) *AcceptResourceShareInvitationInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *AcceptResourceShareInvitationInput) SetResourceShareInvitationArn(v string) *AcceptResourceShareInvitationInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type AcceptResourceShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the invitation.
	ResourceShareInvitation *ResourceShareInvitation `locationName:"resourceShareInvitation" type:"structure"`
}

// String returns the string representation
func (s AcceptResourceShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptResourceShareInvitationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptResourceShareInvitationOutput) SetClientToken(v string) *AcceptResourceShareInvitationOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitation sets the ResourceShareInvitation field's value.
func (s *AcceptResourceShareInvitationOutput) SetResourceShareInvitation(v *ResourceShareInvitation) *AcceptResourceShareInvitationOutput {
	s.ResourceShareInvitation = v
	return s
}

type AssociateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The principals.
	Principals []*string `locationName:"principals" type:"list"`

	// The Amazon Resource Names (ARN) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceShareInput) SetClientToken(v string) *AssociateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *AssociateResourceShareInput) SetPrincipals(v []*string) *AssociateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *AssociateResourceShareInput) SetResourceArns(v []*string) *AssociateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *AssociateResourceShareInput) SetResourceShareArn(v string) *AssociateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type AssociateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the associations.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation
func (s AssociateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceShareOutput) SetClientToken(v string) *AssociateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *AssociateResourceShareOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *AssociateResourceShareOutput {
	s.ResourceShareAssociations = v
	return s
}

type AssociateResourceSharePermissionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The ARN of the AWS RAM permission to associate with the resource share.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// Indicates whether the permission should replace the permissions that are
	// currently associated with the resource share. Use true to replace the current
	// permissions. Use false to add the permission to the current permission.
	Replace *bool `locationName:"replace" type:"boolean"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResourceSharePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResourceSharePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceSharePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceSharePermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceSharePermissionInput) SetClientToken(v string) *AssociateResourceSharePermissionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *AssociateResourceSharePermissionInput) SetPermissionArn(v string) *AssociateResourceSharePermissionInput {
	s.PermissionArn = &v
	return s
}

// SetReplace sets the Replace field's value.
func (s *AssociateResourceSharePermissionInput) SetReplace(v bool) *AssociateResourceSharePermissionInput {
	s.Replace = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *AssociateResourceSharePermissionInput) SetResourceShareArn(v string) *AssociateResourceSharePermissionInput {
	s.ResourceShareArn = &v
	return s
}

type AssociateResourceSharePermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s AssociateResourceSharePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResourceSharePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceSharePermissionOutput) SetClientToken(v string) *AssociateResourceSharePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *AssociateResourceSharePermissionOutput) SetReturnValue(v bool) *AssociateResourceSharePermissionOutput {
	s.ReturnValue = &v
	return s
}

type CreateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether principals outside your AWS organization can be associated
	// with a resource share.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The name of the resource share.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARNs of the permissions to associate with the resource share. If you
	// do not specify an ARN for the permission, AWS RAM automatically attaches
	// the default version of the permission for each resource type.
	PermissionArns []*string `locationName:"permissionArns" type:"list"`

	// The principals to associate with the resource share. The possible values
	// are IDs of AWS accounts, the ARN of an OU or organization from AWS Organizations.
	Principals []*string `locationName:"principals" type:"list"`

	// The Amazon Resource Names (ARN) of the resources to associate with the resource
	// share.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// One or more tags.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceShareInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *CreateResourceShareInput) SetAllowExternalPrincipals(v bool) *CreateResourceShareInput {
	s.AllowExternalPrincipals = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResourceShareInput) SetClientToken(v string) *CreateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceShareInput) SetName(v string) *CreateResourceShareInput {
	s.Name = &v
	return s
}

// SetPermissionArns sets the PermissionArns field's value.
func (s *CreateResourceShareInput) SetPermissionArns(v []*string) *CreateResourceShareInput {
	s.PermissionArns = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *CreateResourceShareInput) SetPrincipals(v []*string) *CreateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *CreateResourceShareInput) SetResourceArns(v []*string) *CreateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResourceShareInput) SetTags(v []*Tag) *CreateResourceShareInput {
	s.Tags = v
	return s
}

type CreateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the resource share.
	ResourceShare *ResourceShare `locationName:"resourceShare" type:"structure"`
}

// String returns the string representation
func (s CreateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResourceShareOutput) SetClientToken(v string) *CreateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShare sets the ResourceShare field's value.
func (s *CreateResourceShareOutput) SetResourceShare(v *ResourceShare) *CreateResourceShareOutput {
	s.ResourceShare = v
	return s
}

type DeleteResourceShareInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `location:"querystring" locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResourceShareInput) SetClientToken(v string) *DeleteResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DeleteResourceShareInput) SetResourceShareArn(v string) *DeleteResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type DeleteResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s DeleteResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResourceShareOutput) SetClientToken(v string) *DeleteResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DeleteResourceShareOutput) SetReturnValue(v bool) *DeleteResourceShareOutput {
	s.ReturnValue = &v
	return s
}

type DisassociateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The principals.
	Principals []*string `locationName:"principals" type:"list"`

	// The Amazon Resource Names (ARNs) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceShareInput) SetClientToken(v string) *DisassociateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *DisassociateResourceShareInput) SetPrincipals(v []*string) *DisassociateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *DisassociateResourceShareInput) SetResourceArns(v []*string) *DisassociateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DisassociateResourceShareInput) SetResourceShareArn(v string) *DisassociateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type DisassociateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the associations.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation
func (s DisassociateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceShareOutput) SetClientToken(v string) *DisassociateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *DisassociateResourceShareOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *DisassociateResourceShareOutput {
	s.ResourceShareAssociations = v
	return s
}

type DisassociateResourceSharePermissionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The ARN of the permission to disassociate from the resource share.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResourceSharePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResourceSharePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceSharePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceSharePermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceSharePermissionInput) SetClientToken(v string) *DisassociateResourceSharePermissionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *DisassociateResourceSharePermissionInput) SetPermissionArn(v string) *DisassociateResourceSharePermissionInput {
	s.PermissionArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DisassociateResourceSharePermissionInput) SetResourceShareArn(v string) *DisassociateResourceSharePermissionInput {
	s.ResourceShareArn = &v
	return s
}

type DisassociateResourceSharePermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s DisassociateResourceSharePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResourceSharePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceSharePermissionOutput) SetClientToken(v string) *DisassociateResourceSharePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DisassociateResourceSharePermissionOutput) SetReturnValue(v bool) *DisassociateResourceSharePermissionOutput {
	s.ReturnValue = &v
	return s
}

type EnableSharingWithAwsOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSharingWithAwsOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSharingWithAwsOrganizationInput) GoString() string {
	return s.String()
}

type EnableSharingWithAwsOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s EnableSharingWithAwsOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSharingWithAwsOrganizationOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *EnableSharingWithAwsOrganizationOutput) SetReturnValue(v bool) *EnableSharingWithAwsOrganizationOutput {
	s.ReturnValue = &v
	return s
}

type GetPermissionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the permission.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// The identifier for the version of the permission.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`
}

// String returns the string representation
func (s GetPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *GetPermissionInput) SetPermissionArn(v string) *GetPermissionInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *GetPermissionInput) SetPermissionVersion(v int64) *GetPermissionInput {
	s.PermissionVersion = &v
	return s
}

type GetPermissionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the permission.
	Permission *ResourceSharePermissionDetail `locationName:"permission" type:"structure"`
}

// String returns the string representation
func (s GetPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionOutput) GoString() string {
	return s.String()
}

// SetPermission sets the Permission field's value.
func (s *GetPermissionOutput) SetPermission(v *ResourceSharePermissionDetail) *GetPermissionOutput {
	s.Permission = v
	return s
}

type GetResourcePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The principal.
	Principal *string `locationName:"principal" type:"string"`

	// The Amazon Resource Names (ARN) of the resources.
	//
	// ResourceArns is a required field
	ResourceArns []*string `locationName:"resourceArns" type:"list" required:"true"`
}

// String returns the string representation
func (s GetResourcePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourcePoliciesInput) SetMaxResults(v int64) *GetResourcePoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesInput) SetNextToken(v string) *GetResourcePoliciesInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetResourcePoliciesInput) SetPrincipal(v string) *GetResourcePoliciesInput {
	s.Principal = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *GetResourcePoliciesInput) SetResourceArns(v []*string) *GetResourcePoliciesInput {
	s.ResourceArns = v
	return s
}

type GetResourcePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A key policy document, in JSON format.
	Policies []*string `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s GetResourcePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcePoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesOutput) SetNextToken(v string) *GetResourcePoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *GetResourcePoliciesOutput) SetPolicies(v []*string) *GetResourcePoliciesOutput {
	s.Policies = v
	return s
}

type GetResourceShareAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The association status.
	AssociationStatus *string `locationName:"associationStatus" type:"string" enum:"ResourceShareAssociationStatus"`

	// The association type. Specify PRINCIPAL to list the principals that are associated
	// with the specified resource share. Specify RESOURCE to list the resources
	// that are associated with the specified resource share.
	//
	// AssociationType is a required field
	AssociationType *string `locationName:"associationType" type:"string" required:"true" enum:"ResourceShareAssociationType"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The principal. You cannot specify this parameter if the association type
	// is RESOURCE.
	Principal *string `locationName:"principal" type:"string"`

	// The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter
	// if the association type is PRINCIPAL.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`
}

// String returns the string representation
func (s GetResourceShareAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceShareAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceShareAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceShareAssociationsInput"}
	if s.AssociationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *GetResourceShareAssociationsInput) SetAssociationStatus(v string) *GetResourceShareAssociationsInput {
	s.AssociationStatus = &v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *GetResourceShareAssociationsInput) SetAssociationType(v string) *GetResourceShareAssociationsInput {
	s.AssociationType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceShareAssociationsInput) SetMaxResults(v int64) *GetResourceShareAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareAssociationsInput) SetNextToken(v string) *GetResourceShareAssociationsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetResourceShareAssociationsInput) SetPrincipal(v string) *GetResourceShareAssociationsInput {
	s.Principal = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourceShareAssociationsInput) SetResourceArn(v string) *GetResourceShareAssociationsInput {
	s.ResourceArn = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceShareAssociationsInput) SetResourceShareArns(v []*string) *GetResourceShareAssociationsInput {
	s.ResourceShareArns = v
	return s
}

type GetResourceShareAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the associations.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation
func (s GetResourceShareAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceShareAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareAssociationsOutput) SetNextToken(v string) *GetResourceShareAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *GetResourceShareAssociationsOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *GetResourceShareAssociationsOutput {
	s.ResourceShareAssociations = v
	return s
}

type GetResourceShareInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// The Amazon Resource Names (ARN) of the invitations.
	ResourceShareInvitationArns []*string `locationName:"resourceShareInvitationArns" type:"list"`
}

// String returns the string representation
func (s GetResourceShareInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceShareInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceShareInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceShareInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceShareInvitationsInput) SetMaxResults(v int64) *GetResourceShareInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareInvitationsInput) SetNextToken(v string) *GetResourceShareInvitationsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceShareInvitationsInput) SetResourceShareArns(v []*string) *GetResourceShareInvitationsInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceShareInvitationArns sets the ResourceShareInvitationArns field's value.
func (s *GetResourceShareInvitationsInput) SetResourceShareInvitationArns(v []*string) *GetResourceShareInvitationsInput {
	s.ResourceShareInvitationArns = v
	return s
}

type GetResourceShareInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the invitations.
	ResourceShareInvitations []*ResourceShareInvitation `locationName:"resourceShareInvitations" type:"list"`
}

// String returns the string representation
func (s GetResourceShareInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceShareInvitationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareInvitationsOutput) SetNextToken(v string) *GetResourceShareInvitationsOutput {
	s.NextToken = &v
	return s
}

// SetResourceShareInvitations sets the ResourceShareInvitations field's value.
func (s *GetResourceShareInvitationsOutput) SetResourceShareInvitations(v []*ResourceShareInvitation) *GetResourceShareInvitationsOutput {
	s.ResourceShareInvitations = v
	return s
}

type GetResourceSharesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of the resource share.
	Name *string `locationName:"name" type:"string"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of owner.
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// The status of the resource share.
	ResourceShareStatus *string `locationName:"resourceShareStatus" type:"string" enum:"ResourceShareStatus"`

	// One or more tag filters.
	TagFilters []*TagFilter `locationName:"tagFilters" type:"list"`
}

// String returns the string representation
func (s GetResourceSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceSharesInput) SetMaxResults(v int64) *GetResourceSharesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourceSharesInput) SetName(v string) *GetResourceSharesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceSharesInput) SetNextToken(v string) *GetResourceSharesInput {
	s.NextToken = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *GetResourceSharesInput) SetResourceOwner(v string) *GetResourceSharesInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceSharesInput) SetResourceShareArns(v []*string) *GetResourceSharesInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceShareStatus sets the ResourceShareStatus field's value.
func (s *GetResourceSharesInput) SetResourceShareStatus(v string) *GetResourceSharesInput {
	s.ResourceShareStatus = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *GetResourceSharesInput) SetTagFilters(v []*TagFilter) *GetResourceSharesInput {
	s.TagFilters = v
	return s
}

type GetResourceSharesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the resource shares.
	ResourceShares []*ResourceShare `locationName:"resourceShares" type:"list"`
}

// String returns the string representation
func (s GetResourceSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceSharesOutput) SetNextToken(v string) *GetResourceSharesOutput {
	s.NextToken = &v
	return s
}

// SetResourceShares sets the ResourceShares field's value.
func (s *GetResourceSharesOutput) SetResourceShares(v []*ResourceShare) *GetResourceSharesOutput {
	s.ResourceShares = v
	return s
}

// A client token input parameter was reused with an operation, but at least
// one of the other input parameters is different from the previous call to
// the operation.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A client token is not valid.
type InvalidClientTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidClientTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidClientTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidClientTokenException(v protocol.ResponseMetadata) error {
	return &InvalidClientTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClientTokenException) Code() string {
	return "InvalidClientTokenException"
}

// Message returns the exception's message.
func (s *InvalidClientTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClientTokenException) OrigErr() error {
	return nil
}

func (s *InvalidClientTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClientTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClientTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified value for MaxResults is not valid.
type InvalidMaxResultsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidMaxResultsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidMaxResultsException) GoString() string {
	return s.String()
}

func newErrorInvalidMaxResultsException(v protocol.ResponseMetadata) error {
	return &InvalidMaxResultsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidMaxResultsException) Code() string {
	return "InvalidMaxResultsException"
}

// Message returns the exception's message.
func (s *InvalidMaxResultsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidMaxResultsException) OrigErr() error {
	return nil
}

func (s *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidMaxResultsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidMaxResultsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified value for NextToken is not valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter is not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource type is not valid.
type InvalidResourceTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidResourceTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResourceTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceTypeException(v protocol.ResponseMetadata) error {
	return &InvalidResourceTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceTypeException) Code() string {
	return "InvalidResourceTypeException"
}

// Message returns the exception's message.
func (s *InvalidResourceTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceTypeException) OrigErr() error {
	return nil
}

func (s *InvalidResourceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested state transition is not valid.
type InvalidStateTransitionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidStateTransitionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidStateTransitionException) GoString() string {
	return s.String()
}

func newErrorInvalidStateTransitionException(v protocol.ResponseMetadata) error {
	return &InvalidStateTransitionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateTransitionException) Code() string {
	return "InvalidStateTransitionException"
}

// Message returns the exception's message.
func (s *InvalidStateTransitionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateTransitionException) OrigErr() error {
	return nil
}

func (s *InvalidStateTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateTransitionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateTransitionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPendingInvitationResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the invitation.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPendingInvitationResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPendingInvitationResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPendingInvitationResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPendingInvitationResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPendingInvitationResourcesInput) SetMaxResults(v int64) *ListPendingInvitationResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPendingInvitationResourcesInput) SetNextToken(v string) *ListPendingInvitationResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *ListPendingInvitationResourcesInput) SetResourceShareInvitationArn(v string) *ListPendingInvitationResourcesInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type ListPendingInvitationResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the resources included the resource share.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListPendingInvitationResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPendingInvitationResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPendingInvitationResourcesOutput) SetNextToken(v string) *ListPendingInvitationResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListPendingInvitationResourcesOutput) SetResources(v []*Resource) *ListPendingInvitationResourcesOutput {
	s.Resources = v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the resource type for which to list permissions. For example, to
	// list only permissions that apply to EC2 subnets, specify ec2:Subnet.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPermissionsInput) SetResourceType(v string) *ListPermissionsInput {
	s.ResourceType = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the permissions.
	Permissions []*ResourceSharePermissionSummary `locationName:"permissions" type:"list"`
}

// String returns the string representation
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionsOutput) SetPermissions(v []*ResourceSharePermissionSummary) *ListPermissionsOutput {
	s.Permissions = v
	return s
}

type ListPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The principals.
	Principals []*string `locationName:"principals" type:"list"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The type of owner.
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// The resource type.
	//
	// Valid values: ec2:CapacityReservation | ec2:Subnet | ec2:TrafficMirrorTarget
	// | ec2:TransitGateway | license-manager:LicenseConfiguration | rds:Cluster
	// | route53resolver:ResolverRule I resource-groups:Group
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s ListPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrincipalsInput) SetMaxResults(v int64) *ListPrincipalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalsInput) SetNextToken(v string) *ListPrincipalsInput {
	s.NextToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPrincipalsInput) SetPrincipals(v []*string) *ListPrincipalsInput {
	s.Principals = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListPrincipalsInput) SetResourceArn(v string) *ListPrincipalsInput {
	s.ResourceArn = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListPrincipalsInput) SetResourceOwner(v string) *ListPrincipalsInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *ListPrincipalsInput) SetResourceShareArns(v []*string) *ListPrincipalsInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPrincipalsInput) SetResourceType(v string) *ListPrincipalsInput {
	s.ResourceType = &v
	return s
}

type ListPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The principals.
	Principals []*Principal `locationName:"principals" type:"list"`
}

// String returns the string representation
func (s ListPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalsOutput) SetNextToken(v string) *ListPrincipalsOutput {
	s.NextToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPrincipalsOutput) SetPrincipals(v []*Principal) *ListPrincipalsOutput {
	s.Principals = v
	return s
}

type ListResourceSharePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceSharePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceSharePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceSharePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceSharePermissionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceSharePermissionsInput) SetMaxResults(v int64) *ListResourceSharePermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSharePermissionsInput) SetNextToken(v string) *ListResourceSharePermissionsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ListResourceSharePermissionsInput) SetResourceShareArn(v string) *ListResourceSharePermissionsInput {
	s.ResourceShareArn = &v
	return s
}

type ListResourceSharePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The permissions associated with the resource share.
	Permissions []*ResourceSharePermissionSummary `locationName:"permissions" type:"list"`
}

// String returns the string representation
func (s ListResourceSharePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceSharePermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSharePermissionsOutput) SetNextToken(v string) *ListResourceSharePermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListResourceSharePermissionsOutput) SetPermissions(v []*ResourceSharePermissionSummary) *ListResourceSharePermissionsOutput {
	s.Permissions = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The principal.
	Principal *string `locationName:"principal" type:"string"`

	// The Amazon Resource Names (ARN) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The type of owner.
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// The resource type.
	//
	// Valid values: ec2:CapacityReservation | ec2:Subnet | ec2:TrafficMirrorTarget
	// | ec2:TransitGateway | license-manager:LicenseConfiguration | rds:Cluster
	// | route53resolver:ResolverRule | resource-groups:Group
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListResourcesInput) SetPrincipal(v string) *ListResourcesInput {
	s.Principal = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListResourcesInput) SetResourceArns(v []*string) *ListResourcesInput {
	s.ResourceArns = v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListResourcesInput) SetResourceOwner(v string) *ListResourcesInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *ListResourcesInput) SetResourceShareArns(v []*string) *ListResourcesInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListResourcesInput) SetResourceType(v string) *ListResourcesInput {
	s.ResourceType = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the resources.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

// The format of an Amazon Resource Name (ARN) is not valid.
type MalformedArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MalformedArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MalformedArnException) GoString() string {
	return s.String()
}

func newErrorMalformedArnException(v protocol.ResponseMetadata) error {
	return &MalformedArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedArnException) Code() string {
	return "MalformedArnException"
}

// Message returns the exception's message.
func (s *MalformedArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedArnException) OrigErr() error {
	return nil
}

func (s *MalformedArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A required input parameter is missing.
type MissingRequiredParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MissingRequiredParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissingRequiredParameterException) GoString() string {
	return s.String()
}

func newErrorMissingRequiredParameterException(v protocol.ResponseMetadata) error {
	return &MissingRequiredParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingRequiredParameterException) Code() string {
	return "MissingRequiredParameterException"
}

// Message returns the exception's message.
func (s *MissingRequiredParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingRequiredParameterException) OrigErr() error {
	return nil
}

func (s *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingRequiredParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingRequiredParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation is not permitted.
type OperationNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OperationNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOperationNotPermittedException(v protocol.ResponseMetadata) error {
	return &OperationNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotPermittedException) Code() string {
	return "OperationNotPermittedException"
}

// Message returns the exception's message.
func (s *OperationNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotPermittedException) OrigErr() error {
	return nil
}

func (s *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a principal for use with AWS Resource Access Manager.
type Principal struct {
	_ struct{} `type:"structure"`

	// The time when the principal was associated with the resource share.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates whether the principal belongs to the same AWS organization as the
	// AWS account that owns the resource share.
	External *bool `locationName:"external" type:"boolean"`

	// The ID of the principal.
	Id *string `locationName:"id" type:"string"`

	// The time when the association was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Principal) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Principal) SetCreationTime(v time.Time) *Principal {
	s.CreationTime = &v
	return s
}

// SetExternal sets the External field's value.
func (s *Principal) SetExternal(v bool) *Principal {
	s.External = &v
	return s
}

// SetId sets the Id field's value.
func (s *Principal) SetId(v string) *Principal {
	s.Id = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Principal) SetLastUpdatedTime(v time.Time) *Principal {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *Principal) SetResourceShareArn(v string) *Principal {
	s.ResourceShareArn = &v
	return s
}

type PromoteResourceShareCreatedFromPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource share to promote.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `location:"querystring" locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s PromoteResourceShareCreatedFromPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteResourceShareCreatedFromPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromoteResourceShareCreatedFromPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromoteResourceShareCreatedFromPolicyInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *PromoteResourceShareCreatedFromPolicyInput) SetResourceShareArn(v string) *PromoteResourceShareCreatedFromPolicyInput {
	s.ResourceShareArn = &v
	return s
}

type PromoteResourceShareCreatedFromPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s PromoteResourceShareCreatedFromPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteResourceShareCreatedFromPolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PromoteResourceShareCreatedFromPolicyOutput) SetReturnValue(v bool) *PromoteResourceShareCreatedFromPolicyOutput {
	s.ReturnValue = &v
	return s
}

type RejectResourceShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) of the invitation.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectResourceShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectResourceShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectResourceShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectResourceShareInvitationInput"}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *RejectResourceShareInvitationInput) SetClientToken(v string) *RejectResourceShareInvitationInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *RejectResourceShareInvitationInput) SetResourceShareInvitationArn(v string) *RejectResourceShareInvitationInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type RejectResourceShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the invitation.
	ResourceShareInvitation *ResourceShareInvitation `locationName:"resourceShareInvitation" type:"structure"`
}

// String returns the string representation
func (s RejectResourceShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectResourceShareInvitationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *RejectResourceShareInvitationOutput) SetClientToken(v string) *RejectResourceShareInvitationOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitation sets the ResourceShareInvitation field's value.
func (s *RejectResourceShareInvitationOutput) SetResourceShareInvitation(v *ResourceShareInvitation) *RejectResourceShareInvitationOutput {
	s.ResourceShareInvitation = v
	return s
}

// Describes a resource associated with a resource share.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the resource was associated with the resource share.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time when the association was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The ARN of the resource group. This value is returned only if the resource
	// is a resource group.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The status of the resource.
	Status *string `locationName:"status" type:"string" enum:"ResourceStatus"`

	// A message about the status of the resource.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The resource type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Resource) SetCreationTime(v time.Time) *Resource {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Resource) SetLastUpdatedTime(v time.Time) *Resource {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *Resource) SetResourceGroupArn(v string) *Resource {
	s.ResourceGroupArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *Resource) SetResourceShareArn(v string) *Resource {
	s.ResourceShareArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Resource) SetStatus(v string) *Resource {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Resource) SetStatusMessage(v string) *Resource {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// An Amazon Resource Name (ARN) was not found.
type ResourceArnNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceArnNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceArnNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceArnNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceArnNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceArnNotFoundException) Code() string {
	return "ResourceArnNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceArnNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceArnNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceArnNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceArnNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a resource share.
type ResourceShare struct {
	_ struct{} `type:"structure"`

	// Indicates whether principals outside your AWS organization can be associated
	// with a resource share.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// The time when the resource share was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates how the resource share was created. Possible values include:
	//
	//    * CREATED_FROM_POLICY - Indicates that the resource share was created
	//    from an AWS Identity and Access Management (AWS IAM) policy attached to
	//    a resource. These resource shares are visible only to the AWS account
	//    that created it. They cannot be modified in AWS RAM.
	//
	//    * PROMOTING_TO_STANDARD - The resource share is in the process of being
	//    promoted. For more information, see PromoteResourceShareCreatedFromPolicy.
	//
	//    * STANDARD - Indicates that the resource share was created in AWS RAM
	//    using the console or APIs. These resource shares are visible to all principals.
	//    They can be modified in AWS RAM.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"ResourceShareFeatureSet"`

	// The time when the resource share was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of the resource share.
	Name *string `locationName:"name" type:"string"`

	// The ID of the AWS account that owns the resource share.
	OwningAccountId *string `locationName:"owningAccountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The status of the resource share.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareStatus"`

	// A message about the status of the resource share.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The tags for the resource share.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ResourceShare) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShare) GoString() string {
	return s.String()
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *ResourceShare) SetAllowExternalPrincipals(v bool) *ResourceShare {
	s.AllowExternalPrincipals = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceShare) SetCreationTime(v time.Time) *ResourceShare {
	s.CreationTime = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *ResourceShare) SetFeatureSet(v string) *ResourceShare {
	s.FeatureSet = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceShare) SetLastUpdatedTime(v time.Time) *ResourceShare {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceShare) SetName(v string) *ResourceShare {
	s.Name = &v
	return s
}

// SetOwningAccountId sets the OwningAccountId field's value.
func (s *ResourceShare) SetOwningAccountId(v string) *ResourceShare {
	s.OwningAccountId = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShare) SetResourceShareArn(v string) *ResourceShare {
	s.ResourceShareArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShare) SetStatus(v string) *ResourceShare {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResourceShare) SetStatusMessage(v string) *ResourceShare {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceShare) SetTags(v []*Tag) *ResourceShare {
	s.Tags = v
	return s
}

// Describes an association with a resource share.
type ResourceShareAssociation struct {
	_ struct{} `type:"structure"`

	// The associated entity. For resource associations, this is the ARN of the
	// resource. For principal associations, this is the ID of an AWS account or
	// the ARN of an OU or organization from AWS Organizations.
	AssociatedEntity *string `locationName:"associatedEntity" type:"string"`

	// The association type.
	AssociationType *string `locationName:"associationType" type:"string" enum:"ResourceShareAssociationType"`

	// The time when the association was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates whether the principal belongs to the same AWS organization as the
	// AWS account that owns the resource share.
	External *bool `locationName:"external" type:"boolean"`

	// The time when the association was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The name of the resource share.
	ResourceShareName *string `locationName:"resourceShareName" type:"string"`

	// The status of the association.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareAssociationStatus"`

	// A message about the status of the association.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s ResourceShareAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareAssociation) GoString() string {
	return s.String()
}

// SetAssociatedEntity sets the AssociatedEntity field's value.
func (s *ResourceShareAssociation) SetAssociatedEntity(v string) *ResourceShareAssociation {
	s.AssociatedEntity = &v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *ResourceShareAssociation) SetAssociationType(v string) *ResourceShareAssociation {
	s.AssociationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceShareAssociation) SetCreationTime(v time.Time) *ResourceShareAssociation {
	s.CreationTime = &v
	return s
}

// SetExternal sets the External field's value.
func (s *ResourceShareAssociation) SetExternal(v bool) *ResourceShareAssociation {
	s.External = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceShareAssociation) SetLastUpdatedTime(v time.Time) *ResourceShareAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShareAssociation) SetResourceShareArn(v string) *ResourceShareAssociation {
	s.ResourceShareArn = &v
	return s
}

// SetResourceShareName sets the ResourceShareName field's value.
func (s *ResourceShareAssociation) SetResourceShareName(v string) *ResourceShareAssociation {
	s.ResourceShareName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShareAssociation) SetStatus(v string) *ResourceShareAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResourceShareAssociation) SetStatusMessage(v string) *ResourceShareAssociation {
	s.StatusMessage = &v
	return s
}

// Describes an invitation to join a resource share.
type ResourceShareInvitation struct {
	_ struct{} `type:"structure"`

	// The date and time when the invitation was sent.
	InvitationTimestamp *time.Time `locationName:"invitationTimestamp" type:"timestamp"`

	// The ID of the AWS account that received the invitation.
	ReceiverAccountId *string `locationName:"receiverAccountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// To view the resources associated with a pending resource share invitation,
	// use ListPendingInvitationResources (https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html).
	//
	// Deprecated: This member has been deprecated. Use ListPendingInvitationResources.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" deprecated:"true" type:"list"`

	// The Amazon Resource Name (ARN) of the invitation.
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string"`

	// The name of the resource share.
	ResourceShareName *string `locationName:"resourceShareName" type:"string"`

	// The ID of the AWS account that sent the invitation.
	SenderAccountId *string `locationName:"senderAccountId" type:"string"`

	// The status of the invitation.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareInvitationStatus"`
}

// String returns the string representation
func (s ResourceShareInvitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareInvitation) GoString() string {
	return s.String()
}

// SetInvitationTimestamp sets the InvitationTimestamp field's value.
func (s *ResourceShareInvitation) SetInvitationTimestamp(v time.Time) *ResourceShareInvitation {
	s.InvitationTimestamp = &v
	return s
}

// SetReceiverAccountId sets the ReceiverAccountId field's value.
func (s *ResourceShareInvitation) SetReceiverAccountId(v string) *ResourceShareInvitation {
	s.ReceiverAccountId = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShareInvitation) SetResourceShareArn(v string) *ResourceShareInvitation {
	s.ResourceShareArn = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *ResourceShareInvitation) SetResourceShareAssociations(v []*ResourceShareAssociation) *ResourceShareInvitation {
	s.ResourceShareAssociations = v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *ResourceShareInvitation) SetResourceShareInvitationArn(v string) *ResourceShareInvitation {
	s.ResourceShareInvitationArn = &v
	return s
}

// SetResourceShareName sets the ResourceShareName field's value.
func (s *ResourceShareInvitation) SetResourceShareName(v string) *ResourceShareInvitation {
	s.ResourceShareName = &v
	return s
}

// SetSenderAccountId sets the SenderAccountId field's value.
func (s *ResourceShareInvitation) SetSenderAccountId(v string) *ResourceShareInvitation {
	s.SenderAccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShareInvitation) SetStatus(v string) *ResourceShareInvitation {
	s.Status = &v
	return s
}

// The invitation was already accepted.
type ResourceShareInvitationAlreadyAcceptedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceShareInvitationAlreadyAcceptedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareInvitationAlreadyAcceptedException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationAlreadyAcceptedException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationAlreadyAcceptedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationAlreadyAcceptedException) Code() string {
	return "ResourceShareInvitationAlreadyAcceptedException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationAlreadyAcceptedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationAlreadyAcceptedException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationAlreadyAcceptedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationAlreadyAcceptedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationAlreadyAcceptedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The invitation was already rejected.
type ResourceShareInvitationAlreadyRejectedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceShareInvitationAlreadyRejectedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareInvitationAlreadyRejectedException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationAlreadyRejectedException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationAlreadyRejectedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationAlreadyRejectedException) Code() string {
	return "ResourceShareInvitationAlreadyRejectedException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationAlreadyRejectedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationAlreadyRejectedException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationAlreadyRejectedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationAlreadyRejectedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationAlreadyRejectedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon Resource Name (ARN) for an invitation was not found.
type ResourceShareInvitationArnNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceShareInvitationArnNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareInvitationArnNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationArnNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationArnNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationArnNotFoundException) Code() string {
	return "ResourceShareInvitationArnNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationArnNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationArnNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationArnNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationArnNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The invitation is expired.
type ResourceShareInvitationExpiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceShareInvitationExpiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareInvitationExpiredException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationExpiredException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationExpiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationExpiredException) Code() string {
	return "ResourceShareInvitationExpiredException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationExpiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationExpiredException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationExpiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationExpiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource share exceeds the limit for your account.
type ResourceShareLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceShareLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceShareLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceShareLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceShareLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareLimitExceededException) Code() string {
	return "ResourceShareLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceShareLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceShareLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about an AWS RAM permission.
type ResourceSharePermissionDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the permission.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the permission was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The identifier for the version of the permission that is set as the default
	// version.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// The date and time when the permission was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of the permission.
	Name *string `locationName:"name" type:"string"`

	// The permission's effect and actions in JSON format. The effect indicates
	// whether the actions are allowed or denied. The actions list the API actions
	// to which the principal is granted or denied access.
	Permission *string `locationName:"permission" type:"string"`

	// The resource type to which the permission applies.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The identifier for the version of the permission.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ResourceSharePermissionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceSharePermissionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceSharePermissionDetail) SetArn(v string) *ResourceSharePermissionDetail {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceSharePermissionDetail) SetCreationTime(v time.Time) *ResourceSharePermissionDetail {
	s.CreationTime = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *ResourceSharePermissionDetail) SetDefaultVersion(v bool) *ResourceSharePermissionDetail {
	s.DefaultVersion = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceSharePermissionDetail) SetLastUpdatedTime(v time.Time) *ResourceSharePermissionDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSharePermissionDetail) SetName(v string) *ResourceSharePermissionDetail {
	s.Name = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *ResourceSharePermissionDetail) SetPermission(v string) *ResourceSharePermissionDetail {
	s.Permission = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSharePermissionDetail) SetResourceType(v string) *ResourceSharePermissionDetail {
	s.ResourceType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceSharePermissionDetail) SetVersion(v string) *ResourceSharePermissionDetail {
	s.Version = &v
	return s
}

// Information about a permission that is associated with a resource share.
type ResourceSharePermissionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the permission.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the permission was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The identifier for the version of the permission that is set as the default
	// version.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// The date and time when the permission was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of the permission.
	Name *string `locationName:"name" type:"string"`

	// The type of resource to which the permission applies.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The current status of the permission.
	Status *string `locationName:"status" type:"string"`

	// The identifier for the version of the permission.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ResourceSharePermissionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceSharePermissionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceSharePermissionSummary) SetArn(v string) *ResourceSharePermissionSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceSharePermissionSummary) SetCreationTime(v time.Time) *ResourceSharePermissionSummary {
	s.CreationTime = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *ResourceSharePermissionSummary) SetDefaultVersion(v bool) *ResourceSharePermissionSummary {
	s.DefaultVersion = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceSharePermissionSummary) SetLastUpdatedTime(v time.Time) *ResourceSharePermissionSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSharePermissionSummary) SetName(v string) *ResourceSharePermissionSummary {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSharePermissionSummary) SetResourceType(v string) *ResourceSharePermissionSummary {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceSharePermissionSummary) SetStatus(v string) *ResourceSharePermissionSummary {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceSharePermissionSummary) SetVersion(v string) *ResourceSharePermissionSummary {
	s.Version = &v
	return s
}

// The service could not respond to the request due to an internal problem.
type ServerInternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServerInternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerInternalException) GoString() string {
	return s.String()
}

func newErrorServerInternalException(v protocol.ResponseMetadata) error {
	return &ServerInternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerInternalException) Code() string {
	return "ServerInternalException"
}

// Message returns the exception's message.
func (s *ServerInternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerInternalException) OrigErr() error {
	return nil
}

func (s *ServerInternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerInternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerInternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is not available.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `locationName:"key" type:"string"`

	// The value of the tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Used to filter information based on tags.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag key.
	TagKey *string `locationName:"tagKey" type:"string"`

	// The tag values.
	TagValues []*string `locationName:"tagValues" type:"list"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// SetTagKey sets the TagKey field's value.
func (s *TagFilter) SetTagKey(v string) *TagFilter {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagFilter) SetTagValues(v []*string) *TagFilter {
	s.TagValues = v
	return s
}

// The requested tags exceed the limit for your account.
type TagLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TagLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTagLimitExceededException(v protocol.ResponseMetadata) error {
	return &TagLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagLimitExceededException) Code() string {
	return "TagLimitExceededException"
}

// Message returns the exception's message.
func (s *TagLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagLimitExceededException) OrigErr() error {
	return nil
}

func (s *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified tag is a reserved word and cannot be used.
type TagPolicyViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TagPolicyViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagPolicyViolationException) GoString() string {
	return s.String()
}

func newErrorTagPolicyViolationException(v protocol.ResponseMetadata) error {
	return &TagPolicyViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagPolicyViolationException) Code() string {
	return "TagPolicyViolationException"
}

// Message returns the exception's message.
func (s *TagPolicyViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagPolicyViolationException) OrigErr() error {
	return nil
}

func (s *TagPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagPolicyViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagPolicyViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *TagResourceInput) SetResourceShareArn(v string) *TagResourceInput {
	s.ResourceShareArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A specified resource was not found.
type UnknownResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnknownResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnknownResourceException) GoString() string {
	return s.String()
}

func newErrorUnknownResourceException(v protocol.ResponseMetadata) error {
	return &UnknownResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownResourceException) Code() string {
	return "UnknownResourceException"
}

// Message returns the exception's message.
func (s *UnknownResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownResourceException) OrigErr() error {
	return nil
}

func (s *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`

	// The tag keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *UntagResourceInput) SetResourceShareArn(v string) *UntagResourceInput {
	s.ResourceShareArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether principals outside your AWS organization can be associated
	// with a resource share.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The name of the resource share.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *UpdateResourceShareInput) SetAllowExternalPrincipals(v bool) *UpdateResourceShareInput {
	s.AllowExternalPrincipals = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResourceShareInput) SetClientToken(v string) *UpdateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceShareInput) SetName(v string) *UpdateResourceShareInput {
	s.Name = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *UpdateResourceShareInput) SetResourceShareArn(v string) *UpdateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type UpdateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the resource share.
	ResourceShare *ResourceShare `locationName:"resourceShare" type:"structure"`
}

// String returns the string representation
func (s UpdateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResourceShareOutput) SetClientToken(v string) *UpdateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShare sets the ResourceShare field's value.
func (s *UpdateResourceShareOutput) SetResourceShare(v *ResourceShare) *UpdateResourceShareOutput {
	s.ResourceShare = v
	return s
}

const (
	// ResourceOwnerSelf is a ResourceOwner enum value
	ResourceOwnerSelf = "SELF"

	// ResourceOwnerOtherAccounts is a ResourceOwner enum value
	ResourceOwnerOtherAccounts = "OTHER-ACCOUNTS"
)

const (
	// ResourceShareAssociationStatusAssociating is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusAssociating = "ASSOCIATING"

	// ResourceShareAssociationStatusAssociated is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusAssociated = "ASSOCIATED"

	// ResourceShareAssociationStatusFailed is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusFailed = "FAILED"

	// ResourceShareAssociationStatusDisassociating is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusDisassociating = "DISASSOCIATING"

	// ResourceShareAssociationStatusDisassociated is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusDisassociated = "DISASSOCIATED"
)

const (
	// ResourceShareAssociationTypePrincipal is a ResourceShareAssociationType enum value
	ResourceShareAssociationTypePrincipal = "PRINCIPAL"

	// ResourceShareAssociationTypeResource is a ResourceShareAssociationType enum value
	ResourceShareAssociationTypeResource = "RESOURCE"
)

const (
	// ResourceShareFeatureSetCreatedFromPolicy is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetCreatedFromPolicy = "CREATED_FROM_POLICY"

	// ResourceShareFeatureSetPromotingToStandard is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetPromotingToStandard = "PROMOTING_TO_STANDARD"

	// ResourceShareFeatureSetStandard is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetStandard = "STANDARD"
)

const (
	// ResourceShareInvitationStatusPending is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusPending = "PENDING"

	// ResourceShareInvitationStatusAccepted is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusAccepted = "ACCEPTED"

	// ResourceShareInvitationStatusRejected is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusRejected = "REJECTED"

	// ResourceShareInvitationStatusExpired is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusExpired = "EXPIRED"
)

const (
	// ResourceShareStatusPending is a ResourceShareStatus enum value
	ResourceShareStatusPending = "PENDING"

	// ResourceShareStatusActive is a ResourceShareStatus enum value
	ResourceShareStatusActive = "ACTIVE"

	// ResourceShareStatusFailed is a ResourceShareStatus enum value
	ResourceShareStatusFailed = "FAILED"

	// ResourceShareStatusDeleting is a ResourceShareStatus enum value
	ResourceShareStatusDeleting = "DELETING"

	// ResourceShareStatusDeleted is a ResourceShareStatus enum value
	ResourceShareStatusDeleted = "DELETED"
)

const (
	// ResourceStatusAvailable is a ResourceStatus enum value
	ResourceStatusAvailable = "AVAILABLE"

	// ResourceStatusZonalResourceInaccessible is a ResourceStatus enum value
	ResourceStatusZonalResourceInaccessible = "ZONAL_RESOURCE_INACCESSIBLE"

	// ResourceStatusLimitExceeded is a ResourceStatus enum value
	ResourceStatusLimitExceeded = "LIMIT_EXCEEDED"

	// ResourceStatusUnavailable is a ResourceStatus enum value
	ResourceStatusUnavailable = "UNAVAILABLE"

	// ResourceStatusPending is a ResourceStatus enum value
	ResourceStatusPending = "PENDING"
)
