// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

package vmwareenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum State defines possible states of private clouds.
type PrivateCloud_State int32

const (
	// The default value. This value should never be used.
	PrivateCloud_STATE_UNSPECIFIED PrivateCloud_State = 0
	// The private cloud is ready.
	PrivateCloud_ACTIVE PrivateCloud_State = 1
	// The private cloud is being created.
	PrivateCloud_CREATING PrivateCloud_State = 2
	// The private cloud is being updated.
	PrivateCloud_UPDATING PrivateCloud_State = 3
	// The private cloud is in failed state.
	PrivateCloud_FAILED PrivateCloud_State = 5
	// The private cloud is scheduled for deletion. The deletion process can be
	// cancelled by using the corresponding undelete method.
	PrivateCloud_DELETED PrivateCloud_State = 6
	// The private cloud is irreversibly deleted and is being removed from the
	// system.
	PrivateCloud_PURGING PrivateCloud_State = 7
)

// Enum value maps for PrivateCloud_State.
var (
	PrivateCloud_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		5: "FAILED",
		6: "DELETED",
		7: "PURGING",
	}
	PrivateCloud_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"FAILED":            5,
		"DELETED":           6,
		"PURGING":           7,
	}
)

func (x PrivateCloud_State) Enum() *PrivateCloud_State {
	p := new(PrivateCloud_State)
	*p = x
	return p
}

func (x PrivateCloud_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateCloud_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[0].Descriptor()
}

func (PrivateCloud_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[0]
}

func (x PrivateCloud_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateCloud_State.Descriptor instead.
func (PrivateCloud_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3, 0}
}

// Enum Type defines private cloud type.
type PrivateCloud_Type int32

const (
	// Standard private is a zonal resource, with 3+ nodes. Default type.
	PrivateCloud_STANDARD PrivateCloud_Type = 0
	// Time limited private cloud is a zonal resource, can have only 1 node and
	// has limited life span. Will be deleted after defined period of time,
	// can be converted into standard private cloud by expanding it up to 3
	// or more nodes.
	PrivateCloud_TIME_LIMITED PrivateCloud_Type = 1
	// Stretched private cloud is a regional resource with redundancy,
	// with a minimum of 6 nodes, nodes count has to be even.
	PrivateCloud_STRETCHED PrivateCloud_Type = 2
)

// Enum value maps for PrivateCloud_Type.
var (
	PrivateCloud_Type_name = map[int32]string{
		0: "STANDARD",
		1: "TIME_LIMITED",
		2: "STRETCHED",
	}
	PrivateCloud_Type_value = map[string]int32{
		"STANDARD":     0,
		"TIME_LIMITED": 1,
		"STRETCHED":    2,
	}
)

func (x PrivateCloud_Type) Enum() *PrivateCloud_Type {
	p := new(PrivateCloud_Type)
	*p = x
	return p
}

func (x PrivateCloud_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateCloud_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[1].Descriptor()
}

func (PrivateCloud_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[1]
}

func (x PrivateCloud_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateCloud_Type.Descriptor instead.
func (PrivateCloud_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3, 1}
}

// Enum State defines possible states of private cloud clusters.
type Cluster_State int32

const (
	// The default value. This value should never be used.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// The Cluster is operational and can be used by the user.
	Cluster_ACTIVE Cluster_State = 1
	// The Cluster is being deployed.
	Cluster_CREATING Cluster_State = 2
	// Adding or removing of a node to the cluster, any other cluster specific
	// updates.
	Cluster_UPDATING Cluster_State = 3
	// The Cluster is being deleted.
	Cluster_DELETING Cluster_State = 4
	// The Cluster is undergoing maintenance, for example: a failed node is
	// getting replaced.
	Cluster_REPAIRING Cluster_State = 5
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "REPAIRING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"REPAIRING":         5,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[2].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[2]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{4, 0}
}

// Enum State defines possible states of a node in a cluster.
type Node_State int32

const (
	// The default value. This value should never be used.
	Node_STATE_UNSPECIFIED Node_State = 0
	// Node is operational and can be used by the user.
	Node_ACTIVE Node_State = 1
	// Node is being provisioned.
	Node_CREATING Node_State = 2
	// Node is in a failed state.
	Node_FAILED Node_State = 3
	// Node is undergoing maintenance, e.g.: during private cloud upgrade.
	Node_UPGRADING Node_State = 4
)

// Enum value maps for Node_State.
var (
	Node_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "FAILED",
		4: "UPGRADING",
	}
	Node_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"FAILED":            3,
		"UPGRADING":         4,
	}
)

func (x Node_State) Enum() *Node_State {
	p := new(Node_State)
	*p = x
	return p
}

func (x Node_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Node_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[3].Descriptor()
}

func (Node_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[3]
}

func (x Node_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Node_State.Descriptor instead.
func (Node_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{5, 0}
}

// Enum State defines possible states of external addresses.
type ExternalAddress_State int32

const (
	// The default value. This value should never be used.
	ExternalAddress_STATE_UNSPECIFIED ExternalAddress_State = 0
	// The address is ready.
	ExternalAddress_ACTIVE ExternalAddress_State = 1
	// The address is being created.
	ExternalAddress_CREATING ExternalAddress_State = 2
	// The address is being updated.
	ExternalAddress_UPDATING ExternalAddress_State = 3
	// The address is being deleted.
	ExternalAddress_DELETING ExternalAddress_State = 4
)

// Enum value maps for ExternalAddress_State.
var (
	ExternalAddress_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
	}
	ExternalAddress_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x ExternalAddress_State) Enum() *ExternalAddress_State {
	p := new(ExternalAddress_State)
	*p = x
	return p
}

func (x ExternalAddress_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalAddress_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[4].Descriptor()
}

func (ExternalAddress_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[4]
}

func (x ExternalAddress_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalAddress_State.Descriptor instead.
func (ExternalAddress_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{6, 0}
}

// Defines possible states of subnets.
type Subnet_State int32

const (
	// The default value. This value should never be used.
	Subnet_STATE_UNSPECIFIED Subnet_State = 0
	// The subnet is ready.
	Subnet_ACTIVE Subnet_State = 1
	// The subnet is being created.
	Subnet_CREATING Subnet_State = 2
	// The subnet is being updated.
	Subnet_UPDATING Subnet_State = 3
	// The subnet is being deleted.
	Subnet_DELETING Subnet_State = 4
	// Changes requested in the last operation are being propagated.
	Subnet_RECONCILING Subnet_State = 5
	// Last operation on the subnet did not succeed. Subnet's payload is
	// reverted back to its most recent working state.
	Subnet_FAILED Subnet_State = 6
)

// Enum value maps for Subnet_State.
var (
	Subnet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "RECONCILING",
		6: "FAILED",
	}
	Subnet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"RECONCILING":       5,
		"FAILED":            6,
	}
)

func (x Subnet_State) Enum() *Subnet_State {
	p := new(Subnet_State)
	*p = x
	return p
}

func (x Subnet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[5].Descriptor()
}

func (Subnet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[5]
}

func (x Subnet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnet_State.Descriptor instead.
func (Subnet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{7, 0}
}

// Action determines whether the external access rule permits or blocks
// traffic, subject to the other components of the rule matching the traffic.
type ExternalAccessRule_Action int32

const (
	// Defaults to allow.
	ExternalAccessRule_ACTION_UNSPECIFIED ExternalAccessRule_Action = 0
	// Allows connections that match the other specified components.
	ExternalAccessRule_ALLOW ExternalAccessRule_Action = 1
	// Blocks connections that match the other specified components.
	ExternalAccessRule_DENY ExternalAccessRule_Action = 2
)

// Enum value maps for ExternalAccessRule_Action.
var (
	ExternalAccessRule_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	ExternalAccessRule_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"ALLOW":              1,
		"DENY":               2,
	}
)

func (x ExternalAccessRule_Action) Enum() *ExternalAccessRule_Action {
	p := new(ExternalAccessRule_Action)
	*p = x
	return p
}

func (x ExternalAccessRule_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalAccessRule_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[6].Descriptor()
}

func (ExternalAccessRule_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[6]
}

func (x ExternalAccessRule_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalAccessRule_Action.Descriptor instead.
func (ExternalAccessRule_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8, 0}
}

// Defines possible states of external access firewall rules.
type ExternalAccessRule_State int32

const (
	// The default value. This value is used if the state is omitted.
	ExternalAccessRule_STATE_UNSPECIFIED ExternalAccessRule_State = 0
	// The rule is ready.
	ExternalAccessRule_ACTIVE ExternalAccessRule_State = 1
	// The rule is being created.
	ExternalAccessRule_CREATING ExternalAccessRule_State = 2
	// The rule is being updated.
	ExternalAccessRule_UPDATING ExternalAccessRule_State = 3
	// The rule is being deleted.
	ExternalAccessRule_DELETING ExternalAccessRule_State = 4
)

// Enum value maps for ExternalAccessRule_State.
var (
	ExternalAccessRule_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
	}
	ExternalAccessRule_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x ExternalAccessRule_State) Enum() *ExternalAccessRule_State {
	p := new(ExternalAccessRule_State)
	*p = x
	return p
}

func (x ExternalAccessRule_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalAccessRule_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[7].Descriptor()
}

func (ExternalAccessRule_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[7]
}

func (x ExternalAccessRule_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalAccessRule_State.Descriptor instead.
func (ExternalAccessRule_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8, 1}
}

// Defines possible protocols used to send logs to
// a logging server.
type LoggingServer_Protocol int32

const (
	// Unspecified communications protocol. This is the default value.
	LoggingServer_PROTOCOL_UNSPECIFIED LoggingServer_Protocol = 0
	// UDP
	LoggingServer_UDP LoggingServer_Protocol = 1
	// TCP
	LoggingServer_TCP LoggingServer_Protocol = 2
	// TLS
	LoggingServer_TLS LoggingServer_Protocol = 3
	// SSL
	LoggingServer_SSL LoggingServer_Protocol = 4
	// RELP
	LoggingServer_RELP LoggingServer_Protocol = 5
)

// Enum value maps for LoggingServer_Protocol.
var (
	LoggingServer_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "UDP",
		2: "TCP",
		3: "TLS",
		4: "SSL",
		5: "RELP",
	}
	LoggingServer_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"UDP":                  1,
		"TCP":                  2,
		"TLS":                  3,
		"SSL":                  4,
		"RELP":                 5,
	}
)

func (x LoggingServer_Protocol) Enum() *LoggingServer_Protocol {
	p := new(LoggingServer_Protocol)
	*p = x
	return p
}

func (x LoggingServer_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingServer_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[8].Descriptor()
}

func (LoggingServer_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[8]
}

func (x LoggingServer_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingServer_Protocol.Descriptor instead.
func (LoggingServer_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{9, 0}
}

// Defines possible types of component that produces logs.
type LoggingServer_SourceType int32

const (
	// The default value. This value should never be used.
	LoggingServer_SOURCE_TYPE_UNSPECIFIED LoggingServer_SourceType = 0
	// Logs produced by ESXI hosts
	LoggingServer_ESXI LoggingServer_SourceType = 1
	// Logs produced by vCenter server
	LoggingServer_VCSA LoggingServer_SourceType = 2
)

// Enum value maps for LoggingServer_SourceType.
var (
	LoggingServer_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "ESXI",
		2: "VCSA",
	}
	LoggingServer_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED": 0,
		"ESXI":                    1,
		"VCSA":                    2,
	}
)

func (x LoggingServer_SourceType) Enum() *LoggingServer_SourceType {
	p := new(LoggingServer_SourceType)
	*p = x
	return p
}

func (x LoggingServer_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingServer_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[9].Descriptor()
}

func (LoggingServer_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[9]
}

func (x LoggingServer_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingServer_SourceType.Descriptor instead.
func (LoggingServer_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{9, 1}
}

// Enum Kind defines possible types of a NodeType.
type NodeType_Kind int32

const (
	// The default value. This value should never be used.
	NodeType_KIND_UNSPECIFIED NodeType_Kind = 0
	// Standard HCI node.
	NodeType_STANDARD NodeType_Kind = 1
	// Storage only Node.
	NodeType_STORAGE_ONLY NodeType_Kind = 2
)

// Enum value maps for NodeType_Kind.
var (
	NodeType_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "STANDARD",
		2: "STORAGE_ONLY",
	}
	NodeType_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"STANDARD":         1,
		"STORAGE_ONLY":     2,
	}
)

func (x NodeType_Kind) Enum() *NodeType_Kind {
	p := new(NodeType_Kind)
	*p = x
	return p
}

func (x NodeType_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[10].Descriptor()
}

func (NodeType_Kind) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[10]
}

func (x NodeType_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType_Kind.Descriptor instead.
func (NodeType_Kind) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{10, 0}
}

// Capability of a node type.
type NodeType_Capability int32

const (
	// The default value. This value is used if the capability is omitted or
	// unknown.
	NodeType_CAPABILITY_UNSPECIFIED NodeType_Capability = 0
	// This node type supports stretch clusters.
	NodeType_STRETCHED_CLUSTERS NodeType_Capability = 1
)

// Enum value maps for NodeType_Capability.
var (
	NodeType_Capability_name = map[int32]string{
		0: "CAPABILITY_UNSPECIFIED",
		1: "STRETCHED_CLUSTERS",
	}
	NodeType_Capability_value = map[string]int32{
		"CAPABILITY_UNSPECIFIED": 0,
		"STRETCHED_CLUSTERS":     1,
	}
)

func (x NodeType_Capability) Enum() *NodeType_Capability {
	p := new(NodeType_Capability)
	*p = x
	return p
}

func (x NodeType_Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType_Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[11].Descriptor()
}

func (NodeType_Capability) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[11]
}

func (x NodeType_Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType_Capability.Descriptor instead.
func (NodeType_Capability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{10, 1}
}

// State of HCX activation key
type HcxActivationKey_State int32

const (
	// Unspecified state.
	HcxActivationKey_STATE_UNSPECIFIED HcxActivationKey_State = 0
	// State of a newly generated activation key.
	HcxActivationKey_AVAILABLE HcxActivationKey_State = 1
	// State of key when it has been used to activate HCX appliance.
	HcxActivationKey_CONSUMED HcxActivationKey_State = 2
	// State of key when it is being created.
	HcxActivationKey_CREATING HcxActivationKey_State = 3
)

// Enum value maps for HcxActivationKey_State.
var (
	HcxActivationKey_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "AVAILABLE",
		2: "CONSUMED",
		3: "CREATING",
	}
	HcxActivationKey_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"AVAILABLE":         1,
		"CONSUMED":          2,
		"CREATING":          3,
	}
)

func (x HcxActivationKey_State) Enum() *HcxActivationKey_State {
	p := new(HcxActivationKey_State)
	*p = x
	return p
}

func (x HcxActivationKey_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HcxActivationKey_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[12].Descriptor()
}

func (HcxActivationKey_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[12]
}

func (x HcxActivationKey_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HcxActivationKey_State.Descriptor instead.
func (HcxActivationKey_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{12, 0}
}

// State of the appliance
type Hcx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Hcx_STATE_UNSPECIFIED Hcx_State = 0
	// The appliance is operational and can be used.
	Hcx_ACTIVE Hcx_State = 1
	// The appliance is being deployed.
	Hcx_CREATING Hcx_State = 2
	// The appliance is being activated.
	Hcx_ACTIVATING Hcx_State = 3
)

// Enum value maps for Hcx_State.
var (
	Hcx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "ACTIVATING",
	}
	Hcx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"ACTIVATING":        3,
	}
)

func (x Hcx_State) Enum() *Hcx_State {
	p := new(Hcx_State)
	*p = x
	return p
}

func (x Hcx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Hcx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[13].Descriptor()
}

func (Hcx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[13]
}

func (x Hcx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Hcx_State.Descriptor instead.
func (Hcx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13, 0}
}

// State of the appliance
type Nsx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Nsx_STATE_UNSPECIFIED Nsx_State = 0
	// The appliance is operational and can be used.
	Nsx_ACTIVE Nsx_State = 1
	// The appliance is being deployed.
	Nsx_CREATING Nsx_State = 2
)

// Enum value maps for Nsx_State.
var (
	Nsx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Nsx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Nsx_State) Enum() *Nsx_State {
	p := new(Nsx_State)
	*p = x
	return p
}

func (x Nsx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Nsx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[14].Descriptor()
}

func (Nsx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[14]
}

func (x Nsx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Nsx_State.Descriptor instead.
func (Nsx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14, 0}
}

// State of the appliance
type Vcenter_State int32

const (
	// Unspecified appliance state. This is the default value.
	Vcenter_STATE_UNSPECIFIED Vcenter_State = 0
	// The appliance is operational and can be used.
	Vcenter_ACTIVE Vcenter_State = 1
	// The appliance is being deployed.
	Vcenter_CREATING Vcenter_State = 2
)

// Enum value maps for Vcenter_State.
var (
	Vcenter_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Vcenter_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Vcenter_State) Enum() *Vcenter_State {
	p := new(Vcenter_State)
	*p = x
	return p
}

func (x Vcenter_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Vcenter_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[15].Descriptor()
}

func (Vcenter_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[15]
}

func (x Vcenter_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Vcenter_State.Descriptor instead.
func (Vcenter_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{15, 0}
}

// Possible states of a network peering.
type NetworkPeering_State int32

const (
	// Unspecified network peering state. This is the default value.
	NetworkPeering_STATE_UNSPECIFIED NetworkPeering_State = 0
	// The peering is not active.
	NetworkPeering_INACTIVE NetworkPeering_State = 1
	// The peering is active.
	NetworkPeering_ACTIVE NetworkPeering_State = 2
	// The peering is being created.
	NetworkPeering_CREATING NetworkPeering_State = 3
	// The peering is being deleted.
	NetworkPeering_DELETING NetworkPeering_State = 4
)

// Enum value maps for NetworkPeering_State.
var (
	NetworkPeering_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INACTIVE",
		2: "ACTIVE",
		3: "CREATING",
		4: "DELETING",
	}
	NetworkPeering_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INACTIVE":          1,
		"ACTIVE":            2,
		"CREATING":          3,
		"DELETING":          4,
	}
)

func (x NetworkPeering_State) Enum() *NetworkPeering_State {
	p := new(NetworkPeering_State)
	*p = x
	return p
}

func (x NetworkPeering_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[16].Descriptor()
}

func (NetworkPeering_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[16]
}

func (x NetworkPeering_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_State.Descriptor instead.
func (NetworkPeering_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{18, 0}
}

// Type or purpose of the network peering connection.
type NetworkPeering_PeerNetworkType int32

const (
	// Unspecified
	NetworkPeering_PEER_NETWORK_TYPE_UNSPECIFIED NetworkPeering_PeerNetworkType = 0
	// Peering connection used for connecting to another VPC network established
	// by the same user. For example, a peering connection to another VPC
	// network in the same project or to an on-premises network.
	NetworkPeering_STANDARD NetworkPeering_PeerNetworkType = 1
	// Peering connection used for connecting to another VMware Engine network.
	NetworkPeering_VMWARE_ENGINE_NETWORK NetworkPeering_PeerNetworkType = 2
	// Peering connection used for establishing [private services
	// access](https://cloud.google.com/vpc/docs/private-services-access).
	NetworkPeering_PRIVATE_SERVICES_ACCESS NetworkPeering_PeerNetworkType = 3
	// Peering connection used for connecting to NetApp Cloud Volumes.
	NetworkPeering_NETAPP_CLOUD_VOLUMES NetworkPeering_PeerNetworkType = 4
	// Peering connection used for connecting to third-party services. Most
	// third-party services require manual setup of reverse peering on the VPC
	// network associated with the third-party service.
	NetworkPeering_THIRD_PARTY_SERVICE NetworkPeering_PeerNetworkType = 5
	// Peering connection used for connecting to Dell PowerScale Filers
	NetworkPeering_DELL_POWERSCALE NetworkPeering_PeerNetworkType = 6
	// Peering connection used for connecting to Google Cloud NetApp Volumes.
	NetworkPeering_GOOGLE_CLOUD_NETAPP_VOLUMES NetworkPeering_PeerNetworkType = 7
)

// Enum value maps for NetworkPeering_PeerNetworkType.
var (
	NetworkPeering_PeerNetworkType_name = map[int32]string{
		0: "PEER_NETWORK_TYPE_UNSPECIFIED",
		1: "STANDARD",
		2: "VMWARE_ENGINE_NETWORK",
		3: "PRIVATE_SERVICES_ACCESS",
		4: "NETAPP_CLOUD_VOLUMES",
		5: "THIRD_PARTY_SERVICE",
		6: "DELL_POWERSCALE",
		7: "GOOGLE_CLOUD_NETAPP_VOLUMES",
	}
	NetworkPeering_PeerNetworkType_value = map[string]int32{
		"PEER_NETWORK_TYPE_UNSPECIFIED": 0,
		"STANDARD":                      1,
		"VMWARE_ENGINE_NETWORK":         2,
		"PRIVATE_SERVICES_ACCESS":       3,
		"NETAPP_CLOUD_VOLUMES":          4,
		"THIRD_PARTY_SERVICE":           5,
		"DELL_POWERSCALE":               6,
		"GOOGLE_CLOUD_NETAPP_VOLUMES":   7,
	}
)

func (x NetworkPeering_PeerNetworkType) Enum() *NetworkPeering_PeerNetworkType {
	p := new(NetworkPeering_PeerNetworkType)
	*p = x
	return p
}

func (x NetworkPeering_PeerNetworkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_PeerNetworkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[17].Descriptor()
}

func (NetworkPeering_PeerNetworkType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[17]
}

func (x NetworkPeering_PeerNetworkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_PeerNetworkType.Descriptor instead.
func (NetworkPeering_PeerNetworkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{18, 1}
}

// The type of the peering route.
type PeeringRoute_Type int32

const (
	// Unspecified peering route type. This is the default value.
	PeeringRoute_TYPE_UNSPECIFIED PeeringRoute_Type = 0
	// Dynamic routes in the peer network.
	PeeringRoute_DYNAMIC_PEERING_ROUTE PeeringRoute_Type = 1
	// Static routes in the peer network.
	PeeringRoute_STATIC_PEERING_ROUTE PeeringRoute_Type = 2
	// Created, updated, and removed automatically by Google Cloud when subnets
	// are created, modified, or deleted in the peer network.
	PeeringRoute_SUBNET_PEERING_ROUTE PeeringRoute_Type = 3
)

// Enum value maps for PeeringRoute_Type.
var (
	PeeringRoute_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DYNAMIC_PEERING_ROUTE",
		2: "STATIC_PEERING_ROUTE",
		3: "SUBNET_PEERING_ROUTE",
	}
	PeeringRoute_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":      0,
		"DYNAMIC_PEERING_ROUTE": 1,
		"STATIC_PEERING_ROUTE":  2,
		"SUBNET_PEERING_ROUTE":  3,
	}
)

func (x PeeringRoute_Type) Enum() *PeeringRoute_Type {
	p := new(PeeringRoute_Type)
	*p = x
	return p
}

func (x PeeringRoute_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeeringRoute_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[18].Descriptor()
}

func (PeeringRoute_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[18]
}

func (x PeeringRoute_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeeringRoute_Type.Descriptor instead.
func (PeeringRoute_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{19, 0}
}

// The direction of the exchanged routes.
type PeeringRoute_Direction int32

const (
	// Unspecified exchanged routes direction. This is default.
	PeeringRoute_DIRECTION_UNSPECIFIED PeeringRoute_Direction = 0
	// Routes imported from the peer network.
	PeeringRoute_INCOMING PeeringRoute_Direction = 1
	// Routes exported to the peer network.
	PeeringRoute_OUTGOING PeeringRoute_Direction = 2
)

// Enum value maps for PeeringRoute_Direction.
var (
	PeeringRoute_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "INCOMING",
		2: "OUTGOING",
	}
	PeeringRoute_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"INCOMING":              1,
		"OUTGOING":              2,
	}
)

func (x PeeringRoute_Direction) Enum() *PeeringRoute_Direction {
	p := new(PeeringRoute_Direction)
	*p = x
	return p
}

func (x PeeringRoute_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeeringRoute_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[19].Descriptor()
}

func (PeeringRoute_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[19]
}

func (x PeeringRoute_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeeringRoute_Direction.Descriptor instead.
func (PeeringRoute_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{19, 1}
}

// Enum State defines possible states of a network policy controlled
// service.
type NetworkPolicy_NetworkService_State int32

const (
	// Unspecified service state. This is the default value.
	NetworkPolicy_NetworkService_STATE_UNSPECIFIED NetworkPolicy_NetworkService_State = 0
	// Service is not provisioned.
	NetworkPolicy_NetworkService_UNPROVISIONED NetworkPolicy_NetworkService_State = 1
	// Service is in the process of being provisioned/deprovisioned.
	NetworkPolicy_NetworkService_RECONCILING NetworkPolicy_NetworkService_State = 2
	// Service is active.
	NetworkPolicy_NetworkService_ACTIVE NetworkPolicy_NetworkService_State = 3
)

// Enum value maps for NetworkPolicy_NetworkService_State.
var (
	NetworkPolicy_NetworkService_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNPROVISIONED",
		2: "RECONCILING",
		3: "ACTIVE",
	}
	NetworkPolicy_NetworkService_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNPROVISIONED":     1,
		"RECONCILING":       2,
		"ACTIVE":            3,
	}
)

func (x NetworkPolicy_NetworkService_State) Enum() *NetworkPolicy_NetworkService_State {
	p := new(NetworkPolicy_NetworkService_State)
	*p = x
	return p
}

func (x NetworkPolicy_NetworkService_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicy_NetworkService_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[20].Descriptor()
}

func (NetworkPolicy_NetworkService_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[20]
}

func (x NetworkPolicy_NetworkService_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicy_NetworkService_State.Descriptor instead.
func (NetworkPolicy_NetworkService_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{20, 0, 0}
}

// Enum State defines possible states of binding between the consumer VPC
// network and the management DNS zone.
type ManagementDnsZoneBinding_State int32

const (
	// The default value. This value should never be used.
	ManagementDnsZoneBinding_STATE_UNSPECIFIED ManagementDnsZoneBinding_State = 0
	// The binding is ready.
	ManagementDnsZoneBinding_ACTIVE ManagementDnsZoneBinding_State = 1
	// The binding is being created.
	ManagementDnsZoneBinding_CREATING ManagementDnsZoneBinding_State = 2
	// The binding is being updated.
	ManagementDnsZoneBinding_UPDATING ManagementDnsZoneBinding_State = 3
	// The binding is being deleted.
	ManagementDnsZoneBinding_DELETING ManagementDnsZoneBinding_State = 4
	// The binding has failed.
	ManagementDnsZoneBinding_FAILED ManagementDnsZoneBinding_State = 5
)

// Enum value maps for ManagementDnsZoneBinding_State.
var (
	ManagementDnsZoneBinding_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "FAILED",
	}
	ManagementDnsZoneBinding_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"FAILED":            5,
	}
)

func (x ManagementDnsZoneBinding_State) Enum() *ManagementDnsZoneBinding_State {
	p := new(ManagementDnsZoneBinding_State)
	*p = x
	return p
}

func (x ManagementDnsZoneBinding_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagementDnsZoneBinding_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[21].Descriptor()
}

func (ManagementDnsZoneBinding_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[21]
}

func (x ManagementDnsZoneBinding_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagementDnsZoneBinding_State.Descriptor instead.
func (ManagementDnsZoneBinding_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{21, 0}
}

// Enum State defines possible states of VMware Engine network.
type VmwareEngineNetwork_State int32

const (
	// The default value. This value is used if the state is omitted.
	VmwareEngineNetwork_STATE_UNSPECIFIED VmwareEngineNetwork_State = 0
	// The VMware Engine network is being created.
	VmwareEngineNetwork_CREATING VmwareEngineNetwork_State = 1
	// The VMware Engine network is ready.
	VmwareEngineNetwork_ACTIVE VmwareEngineNetwork_State = 2
	// The VMware Engine network is being updated.
	VmwareEngineNetwork_UPDATING VmwareEngineNetwork_State = 3
	// The VMware Engine network is being deleted.
	VmwareEngineNetwork_DELETING VmwareEngineNetwork_State = 4
)

// Enum value maps for VmwareEngineNetwork_State.
var (
	VmwareEngineNetwork_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	VmwareEngineNetwork_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x VmwareEngineNetwork_State) Enum() *VmwareEngineNetwork_State {
	p := new(VmwareEngineNetwork_State)
	*p = x
	return p
}

func (x VmwareEngineNetwork_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[22].Descriptor()
}

func (VmwareEngineNetwork_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[22]
}

func (x VmwareEngineNetwork_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_State.Descriptor instead.
func (VmwareEngineNetwork_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{22, 0}
}

// Enum Type defines possible types of VMware Engine network.
type VmwareEngineNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_Type = 0
	// Network type used by private clouds created in projects without a network
	// of type `STANDARD`. This network type is no longer used for new VMware
	// Engine private cloud deployments.
	VmwareEngineNetwork_LEGACY VmwareEngineNetwork_Type = 1
	// Standard network type used for private cloud connectivity.
	VmwareEngineNetwork_STANDARD VmwareEngineNetwork_Type = 2
)

// Enum value maps for VmwareEngineNetwork_Type.
var (
	VmwareEngineNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LEGACY",
		2: "STANDARD",
	}
	VmwareEngineNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LEGACY":           1,
		"STANDARD":         2,
	}
)

func (x VmwareEngineNetwork_Type) Enum() *VmwareEngineNetwork_Type {
	p := new(VmwareEngineNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[23].Descriptor()
}

func (VmwareEngineNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[23]
}

func (x VmwareEngineNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{22, 1}
}

// Enum Type defines possible types of a VMware Engine network controlled
// service.
type VmwareEngineNetwork_VpcNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_VpcNetwork_Type = 0
	// VPC network that will be peered with a consumer VPC network or the
	// intranet VPC of another VMware Engine network. Access a private cloud
	// through Compute Engine VMs on a peered VPC network or an on-premises
	// resource connected to a peered consumer VPC network.
	VmwareEngineNetwork_VpcNetwork_INTRANET VmwareEngineNetwork_VpcNetwork_Type = 1
	// VPC network used for internet access to and from a private cloud.
	VmwareEngineNetwork_VpcNetwork_INTERNET VmwareEngineNetwork_VpcNetwork_Type = 2
	// VPC network used for access to Google Cloud services like
	// Cloud Storage.
	VmwareEngineNetwork_VpcNetwork_GOOGLE_CLOUD VmwareEngineNetwork_VpcNetwork_Type = 3
)

// Enum value maps for VmwareEngineNetwork_VpcNetwork_Type.
var (
	VmwareEngineNetwork_VpcNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INTRANET",
		2: "INTERNET",
		3: "GOOGLE_CLOUD",
	}
	VmwareEngineNetwork_VpcNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INTRANET":         1,
		"INTERNET":         2,
		"GOOGLE_CLOUD":     3,
	}
)

func (x VmwareEngineNetwork_VpcNetwork_Type) Enum() *VmwareEngineNetwork_VpcNetwork_Type {
	p := new(VmwareEngineNetwork_VpcNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_VpcNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_VpcNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[24].Descriptor()
}

func (VmwareEngineNetwork_VpcNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[24]
}

func (x VmwareEngineNetwork_VpcNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_VpcNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{22, 0, 0}
}

// Enum State defines possible states of private connection.
type PrivateConnection_State int32

const (
	// The default value. This value is used if the state is omitted.
	PrivateConnection_STATE_UNSPECIFIED PrivateConnection_State = 0
	// The private connection is being created.
	PrivateConnection_CREATING PrivateConnection_State = 1
	// The private connection is ready.
	PrivateConnection_ACTIVE PrivateConnection_State = 2
	// The private connection is being updated.
	PrivateConnection_UPDATING PrivateConnection_State = 3
	// The private connection is being deleted.
	PrivateConnection_DELETING PrivateConnection_State = 4
	// The private connection is not provisioned, since no private cloud is
	// present for which this private connection is needed.
	PrivateConnection_UNPROVISIONED PrivateConnection_State = 5
	// The private connection is in failed state.
	PrivateConnection_FAILED PrivateConnection_State = 6
)

// Enum value maps for PrivateConnection_State.
var (
	PrivateConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
		5: "UNPROVISIONED",
		6: "FAILED",
	}
	PrivateConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
		"UNPROVISIONED":     5,
		"FAILED":            6,
	}
)

func (x PrivateConnection_State) Enum() *PrivateConnection_State {
	p := new(PrivateConnection_State)
	*p = x
	return p
}

func (x PrivateConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[25].Descriptor()
}

func (PrivateConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[25]
}

func (x PrivateConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_State.Descriptor instead.
func (PrivateConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{23, 0}
}

// Enum Type defines possible types of private connection.
type PrivateConnection_Type int32

const (
	// The default value. This value should never be used.
	PrivateConnection_TYPE_UNSPECIFIED PrivateConnection_Type = 0
	// Connection used for establishing [private services
	// access](https://cloud.google.com/vpc/docs/private-services-access).
	PrivateConnection_PRIVATE_SERVICE_ACCESS PrivateConnection_Type = 1
	// Connection used for connecting to NetApp Cloud Volumes.
	PrivateConnection_NETAPP_CLOUD_VOLUMES PrivateConnection_Type = 2
	// Connection used for connecting to Dell PowerScale.
	PrivateConnection_DELL_POWERSCALE PrivateConnection_Type = 3
	// Connection used for connecting to third-party services.
	PrivateConnection_THIRD_PARTY_SERVICE PrivateConnection_Type = 4
)

// Enum value maps for PrivateConnection_Type.
var (
	PrivateConnection_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PRIVATE_SERVICE_ACCESS",
		2: "NETAPP_CLOUD_VOLUMES",
		3: "DELL_POWERSCALE",
		4: "THIRD_PARTY_SERVICE",
	}
	PrivateConnection_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":       0,
		"PRIVATE_SERVICE_ACCESS": 1,
		"NETAPP_CLOUD_VOLUMES":   2,
		"DELL_POWERSCALE":        3,
		"THIRD_PARTY_SERVICE":    4,
	}
)

func (x PrivateConnection_Type) Enum() *PrivateConnection_Type {
	p := new(PrivateConnection_Type)
	*p = x
	return p
}

func (x PrivateConnection_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[26].Descriptor()
}

func (PrivateConnection_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[26]
}

func (x PrivateConnection_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_Type.Descriptor instead.
func (PrivateConnection_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{23, 1}
}

// Possible types for RoutingMode
type PrivateConnection_RoutingMode int32

const (
	// The default value. This value should never be used.
	PrivateConnection_ROUTING_MODE_UNSPECIFIED PrivateConnection_RoutingMode = 0
	// Global Routing Mode
	PrivateConnection_GLOBAL PrivateConnection_RoutingMode = 1
	// Regional Routing Mode
	PrivateConnection_REGIONAL PrivateConnection_RoutingMode = 2
)

// Enum value maps for PrivateConnection_RoutingMode.
var (
	PrivateConnection_RoutingMode_name = map[int32]string{
		0: "ROUTING_MODE_UNSPECIFIED",
		1: "GLOBAL",
		2: "REGIONAL",
	}
	PrivateConnection_RoutingMode_value = map[string]int32{
		"ROUTING_MODE_UNSPECIFIED": 0,
		"GLOBAL":                   1,
		"REGIONAL":                 2,
	}
)

func (x PrivateConnection_RoutingMode) Enum() *PrivateConnection_RoutingMode {
	p := new(PrivateConnection_RoutingMode)
	*p = x
	return p
}

func (x PrivateConnection_RoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_RoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[27].Descriptor()
}

func (PrivateConnection_RoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[27]
}

func (x PrivateConnection_RoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_RoutingMode.Descriptor instead.
func (PrivateConnection_RoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{23, 2}
}

// Enum PeeringState defines the possible states of peering between service
// network and the vpc network peered to service network
type PrivateConnection_PeeringState int32

const (
	// The default value. This value is used if the peering state is omitted or
	// unknown.
	PrivateConnection_PEERING_STATE_UNSPECIFIED PrivateConnection_PeeringState = 0
	// The peering is in active state.
	PrivateConnection_PEERING_ACTIVE PrivateConnection_PeeringState = 1
	// The peering is in inactive state.
	PrivateConnection_PEERING_INACTIVE PrivateConnection_PeeringState = 2
)

// Enum value maps for PrivateConnection_PeeringState.
var (
	PrivateConnection_PeeringState_name = map[int32]string{
		0: "PEERING_STATE_UNSPECIFIED",
		1: "PEERING_ACTIVE",
		2: "PEERING_INACTIVE",
	}
	PrivateConnection_PeeringState_value = map[string]int32{
		"PEERING_STATE_UNSPECIFIED": 0,
		"PEERING_ACTIVE":            1,
		"PEERING_INACTIVE":          2,
	}
)

func (x PrivateConnection_PeeringState) Enum() *PrivateConnection_PeeringState {
	p := new(PrivateConnection_PeeringState)
	*p = x
	return p
}

func (x PrivateConnection_PeeringState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_PeeringState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[28].Descriptor()
}

func (PrivateConnection_PeeringState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[28]
}

func (x PrivateConnection_PeeringState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_PeeringState.Descriptor instead.
func (PrivateConnection_PeeringState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{23, 3}
}

// Capability of a location.
type LocationMetadata_Capability int32

const (
	// The default value. This value is used if the capability is omitted or
	// unknown.
	LocationMetadata_CAPABILITY_UNSPECIFIED LocationMetadata_Capability = 0
	// Stretch clusters are supported in this location.
	LocationMetadata_STRETCHED_CLUSTERS LocationMetadata_Capability = 1
)

// Enum value maps for LocationMetadata_Capability.
var (
	LocationMetadata_Capability_name = map[int32]string{
		0: "CAPABILITY_UNSPECIFIED",
		1: "STRETCHED_CLUSTERS",
	}
	LocationMetadata_Capability_value = map[string]int32{
		"CAPABILITY_UNSPECIFIED": 0,
		"STRETCHED_CLUSTERS":     1,
	}
)

func (x LocationMetadata_Capability) Enum() *LocationMetadata_Capability {
	p := new(LocationMetadata_Capability)
	*p = x
	return p
}

func (x LocationMetadata_Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationMetadata_Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[29].Descriptor()
}

func (LocationMetadata_Capability) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[29]
}

func (x LocationMetadata_Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationMetadata_Capability.Descriptor instead.
func (LocationMetadata_Capability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{24, 0}
}

// Network configuration in the consumer project
// with which the peering has to be done.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Management CIDR used by VMware management appliances.
	ManagementCidr string `protobuf:"bytes,4,opt,name=management_cidr,json=managementCidr,proto3" json:"management_cidr,omitempty"`
	// Optional. The relative resource name of the VMware Engine network attached
	// to the private cloud. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,5,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,6,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
	// Output only. The IP address layout version of the management IP address
	// range. Possible versions include:
	// * `managementIpAddressLayoutVersion=1`: Indicates the legacy IP address
	// layout used by some existing private clouds. This is no longer supported
	// for new private clouds as it does not support all features.
	// * `managementIpAddressLayoutVersion=2`: Indicates the latest IP address
	// layout used by all newly created private clouds. This version supports all
	// current features.
	ManagementIpAddressLayoutVersion int32 `protobuf:"varint,8,opt,name=management_ip_address_layout_version,json=managementIpAddressLayoutVersion,proto3" json:"management_ip_address_layout_version,omitempty"`
	// Output only. DNS Server IP of the Private Cloud.
	// All DNS queries can be forwarded to this address for name resolution of
	// Private Cloud's management entities like vCenter, NSX-T Manager and
	// ESXi hosts.
	DnsServerIp string `protobuf:"bytes,9,opt,name=dns_server_ip,json=dnsServerIp,proto3" json:"dns_server_ip,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkConfig) GetManagementCidr() string {
	if x != nil {
		return x.ManagementCidr
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

func (x *NetworkConfig) GetManagementIpAddressLayoutVersion() int32 {
	if x != nil {
		return x.ManagementIpAddressLayoutVersion
	}
	return 0
}

func (x *NetworkConfig) GetDnsServerIp() string {
	if x != nil {
		return x.DnsServerIp
	}
	return ""
}

// Information about the type and number of nodes associated with the cluster.
type NodeTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of nodes of this type in the cluster
	NodeCount int32 `protobuf:"varint,1,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Optional. Customized number of cores available to each node of the type.
	// This number must always be one of `nodeType.availableCustomCoreCounts`.
	// If zero is provided max value from `nodeType.availableCustomCoreCounts`
	// will be used.
	CustomCoreCount int32 `protobuf:"varint,2,opt,name=custom_core_count,json=customCoreCount,proto3" json:"custom_core_count,omitempty"`
}

func (x *NodeTypeConfig) Reset() {
	*x = NodeTypeConfig{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTypeConfig) ProtoMessage() {}

func (x *NodeTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTypeConfig.ProtoReflect.Descriptor instead.
func (*NodeTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{1}
}

func (x *NodeTypeConfig) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *NodeTypeConfig) GetCustomCoreCount() int32 {
	if x != nil {
		return x.CustomCoreCount
	}
	return 0
}

// Configuration of a stretched cluster.
type StretchedClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Zone that will remain operational when connection between the two
	// zones is lost. Specify the resource name of a zone that belongs to the
	// region of the private cloud. For example:
	// `projects/{project}/locations/europe-west3-a` where `{project}` can either
	// be a project number or a project ID.
	PreferredLocation string `protobuf:"bytes,1,opt,name=preferred_location,json=preferredLocation,proto3" json:"preferred_location,omitempty"`
	// Required. Additional zone for a higher level of availability and load
	// balancing. Specify the resource name of a zone that belongs to the region
	// of the private cloud. For example:
	// `projects/{project}/locations/europe-west3-b` where `{project}` can either
	// be a project number or a project ID.
	SecondaryLocation string `protobuf:"bytes,2,opt,name=secondary_location,json=secondaryLocation,proto3" json:"secondary_location,omitempty"`
}

func (x *StretchedClusterConfig) Reset() {
	*x = StretchedClusterConfig{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StretchedClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StretchedClusterConfig) ProtoMessage() {}

func (x *StretchedClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StretchedClusterConfig.ProtoReflect.Descriptor instead.
func (*StretchedClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{2}
}

func (x *StretchedClusterConfig) GetPreferredLocation() string {
	if x != nil {
		return x.PreferredLocation
	}
	return ""
}

func (x *StretchedClusterConfig) GetSecondaryLocation() string {
	if x != nil {
		return x.SecondaryLocation
	}
	return ""
}

// Represents a private cloud resource. Private clouds of type `STANDARD` and
// `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
// regional.
type PrivateCloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this private cloud.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when the resource was scheduled for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. Time when the resource will be irreversibly deleted.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. State of the resource. New values may be added to this enum
	// when appropriate.
	State PrivateCloud_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.PrivateCloud_State" json:"state,omitempty"`
	// Required. Network configuration of the private cloud.
	NetworkConfig *NetworkConfig `protobuf:"bytes,9,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Required. Input only. The management cluster for this private cloud.
	// This field is required during creation of the private cloud to provide
	// details for the default cluster.
	//
	// The following fields can't be changed after private cloud creation:
	// `ManagementCluster.clusterId`, `ManagementCluster.nodeTypeId`.
	ManagementCluster *PrivateCloud_ManagementCluster `protobuf:"bytes,10,opt,name=management_cluster,json=managementCluster,proto3" json:"management_cluster,omitempty"`
	// User-provided description for this private cloud.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. HCX appliance.
	Hcx *Hcx `protobuf:"bytes,17,opt,name=hcx,proto3" json:"hcx,omitempty"`
	// Output only. NSX appliance.
	Nsx *Nsx `protobuf:"bytes,18,opt,name=nsx,proto3" json:"nsx,omitempty"`
	// Output only. Vcenter appliance.
	Vcenter *Vcenter `protobuf:"bytes,19,opt,name=vcenter,proto3" json:"vcenter,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,20,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Type of the private cloud. Defaults to STANDARD.
	Type PrivateCloud_Type `protobuf:"varint,22,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PrivateCloud_Type" json:"type,omitempty"`
}

func (x *PrivateCloud) Reset() {
	*x = PrivateCloud{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateCloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud) ProtoMessage() {}

func (x *PrivateCloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud.ProtoReflect.Descriptor instead.
func (*PrivateCloud) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3}
}

func (x *PrivateCloud) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateCloud) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateCloud) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateCloud) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *PrivateCloud) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *PrivateCloud) GetState() PrivateCloud_State {
	if x != nil {
		return x.State
	}
	return PrivateCloud_STATE_UNSPECIFIED
}

func (x *PrivateCloud) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *PrivateCloud) GetManagementCluster() *PrivateCloud_ManagementCluster {
	if x != nil {
		return x.ManagementCluster
	}
	return nil
}

func (x *PrivateCloud) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrivateCloud) GetHcx() *Hcx {
	if x != nil {
		return x.Hcx
	}
	return nil
}

func (x *PrivateCloud) GetNsx() *Nsx {
	if x != nil {
		return x.Nsx
	}
	return nil
}

func (x *PrivateCloud) GetVcenter() *Vcenter {
	if x != nil {
		return x.Vcenter
	}
	return nil
}

func (x *PrivateCloud) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PrivateCloud) GetType() PrivateCloud_Type {
	if x != nil {
		return x.Type
	}
	return PrivateCloud_STANDARD
}

// A cluster in a private cloud.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this cluster.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the resource.
	State Cluster_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Cluster_State" json:"state,omitempty"`
	// Output only. True if the cluster is a management cluster; false otherwise.
	// There can only be one management cluster in a private cloud
	// and it has to be the first one.
	Management bool `protobuf:"varint,7,opt,name=management,proto3" json:"management,omitempty"`
	// Optional. Configuration of the autoscaling applied to this cluster.
	AutoscalingSettings *AutoscalingSettings `protobuf:"bytes,18,opt,name=autoscaling_settings,json=autoscalingSettings,proto3" json:"autoscaling_settings,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is
	// canonical identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,16,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Configuration of a stretched cluster. Required for clusters that
	// belong to a STRETCHED private cloud.
	StretchedClusterConfig *StretchedClusterConfig `protobuf:"bytes,17,opt,name=stretched_cluster_config,json=stretchedClusterConfig,proto3" json:"stretched_cluster_config,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetManagement() bool {
	if x != nil {
		return x.Management
	}
	return false
}

func (x *Cluster) GetAutoscalingSettings() *AutoscalingSettings {
	if x != nil {
		return x.AutoscalingSettings
	}
	return nil
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

func (x *Cluster) GetStretchedClusterConfig() *StretchedClusterConfig {
	if x != nil {
		return x.StretchedClusterConfig
	}
	return nil
}

// Node in a cluster.
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this node.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster/nodes/my-node
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Fully qualified domain name of the node.
	Fqdn string `protobuf:"bytes,2,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// Output only. Internal IP address of the node.
	InternalIp string `protobuf:"bytes,3,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Output only. The canonical identifier of the node type (corresponds to the
	// `NodeType`).
	// For example: standard-72.
	NodeTypeId string `protobuf:"bytes,4,opt,name=node_type_id,json=nodeTypeId,proto3" json:"node_type_id,omitempty"`
	// Output only. The version number of the VMware ESXi
	// management component in this cluster.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. Customized number of cores
	CustomCoreCount int64 `protobuf:"varint,6,opt,name=custom_core_count,json=customCoreCount,proto3" json:"custom_core_count,omitempty"`
	// Output only. The state of the appliance.
	State Node_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Node_State" json:"state,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{5}
}

func (x *Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Node) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

func (x *Node) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Node) GetNodeTypeId() string {
	if x != nil {
		return x.NodeTypeId
	}
	return ""
}

func (x *Node) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Node) GetCustomCoreCount() int64 {
	if x != nil {
		return x.CustomCoreCount
	}
	return 0
}

func (x *Node) GetState() Node_State {
	if x != nil {
		return x.State
	}
	return Node_STATE_UNSPECIFIED
}

// Represents an allocated external IP address and its corresponding internal IP
// address in a private cloud.
type ExternalAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this external IP address.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-address`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The internal IP address of a workload VM.
	InternalIp string `protobuf:"bytes,6,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Output only. The external IP address of a workload VM.
	ExternalIp string `protobuf:"bytes,7,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Output only. The state of the resource.
	State ExternalAddress_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.ExternalAddress_State" json:"state,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// User-provided description for this resource.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *ExternalAddress) Reset() {
	*x = ExternalAddress{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalAddress) ProtoMessage() {}

func (x *ExternalAddress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalAddress.ProtoReflect.Descriptor instead.
func (*ExternalAddress) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ExternalAddress) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExternalAddress) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExternalAddress) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ExternalAddress) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *ExternalAddress) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *ExternalAddress) GetState() ExternalAddress_State {
	if x != nil {
		return x.State
	}
	return ExternalAddress_STATE_UNSPECIFIED
}

func (x *ExternalAddress) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *ExternalAddress) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Subnet in a private cloud. Either `management` subnets (such as vMotion) that
// are read-only, or `userDefined`, which can also be updated.
type Subnet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this subnet.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The IP address range of the subnet in CIDR format '10.0.0.0/24'.
	IpCidrRange string `protobuf:"bytes,7,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// The IP address of the gateway of this subnet.
	// Must fall within the IP prefix defined above.
	GatewayIp string `protobuf:"bytes,8,opt,name=gateway_ip,json=gatewayIp,proto3" json:"gateway_ip,omitempty"`
	// Output only. The type of the subnet. For example "management" or
	// "userDefined".
	Type string `protobuf:"bytes,11,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The state of the resource.
	State Subnet_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Subnet_State" json:"state,omitempty"`
	// Output only. VLAN ID of the VLAN on which the subnet is configured
	VlanId int32 `protobuf:"varint,16,opt,name=vlan_id,json=vlanId,proto3" json:"vlan_id,omitempty"`
}

func (x *Subnet) Reset() {
	*x = Subnet{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Subnet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subnet) ProtoMessage() {}

func (x *Subnet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subnet.ProtoReflect.Descriptor instead.
func (*Subnet) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{7}
}

func (x *Subnet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subnet) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *Subnet) GetGatewayIp() string {
	if x != nil {
		return x.GatewayIp
	}
	return ""
}

func (x *Subnet) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Subnet) GetState() Subnet_State {
	if x != nil {
		return x.State
	}
	return Subnet_STATE_UNSPECIFIED
}

func (x *Subnet) GetVlanId() int32 {
	if x != nil {
		return x.VlanId
	}
	return 0
}

// External access firewall rules for filtering incoming traffic destined to
// `ExternalAddress` resources.
type ExternalAccessRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this external access rule.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description for this external access rule.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// External access rule priority, which determines the external access rule to
	// use when multiple rules apply. If multiple rules have the same priority,
	// their ordering is non-deterministic. If specific ordering is required,
	// assign unique priorities to enforce such ordering. The external access rule
	// priority is an integer from 100 to 4096, both inclusive. Lower integers
	// indicate higher precedence. For example, a rule with priority `100` has
	// higher precedence than a rule with priority `101`.
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// The action that the external access rule performs.
	Action ExternalAccessRule_Action `protobuf:"varint,7,opt,name=action,proto3,enum=google.cloud.vmwareengine.v1.ExternalAccessRule_Action" json:"action,omitempty"`
	// The IP protocol to which the external access rule applies. This value can
	// be one of the following three protocol strings (not case-sensitive):
	// `tcp`, `udp`, or `icmp`.
	IpProtocol string `protobuf:"bytes,8,opt,name=ip_protocol,json=ipProtocol,proto3" json:"ip_protocol,omitempty"`
	// If source ranges are specified, the external access rule applies only to
	// traffic that has a source IP address in these ranges. These ranges can
	// either be expressed in the CIDR format or as an IP address. As only inbound
	// rules are supported, `ExternalAddress` resources cannot be the source IP
	// addresses of an external access rule. To match all source addresses,
	// specify `0.0.0.0/0`.
	SourceIpRanges []*ExternalAccessRule_IpRange `protobuf:"bytes,9,rep,name=source_ip_ranges,json=sourceIpRanges,proto3" json:"source_ip_ranges,omitempty"`
	// A list of source ports to which the external access rule applies. This
	// field is only applicable for the UDP or TCP protocol.
	// Each entry must be either an integer or a range. For example: `["22"]`,
	// `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
	// `["0-65535"]`.
	SourcePorts []string `protobuf:"bytes,10,rep,name=source_ports,json=sourcePorts,proto3" json:"source_ports,omitempty"`
	// If destination ranges are specified, the external access rule applies only
	// to the traffic that has a destination IP address in these ranges. The
	// specified IP addresses must have reserved external IP addresses in the
	// scope of the parent network policy. To match all external IP addresses in
	// the scope of the parent network policy, specify `0.0.0.0/0`. To match a
	// specific external IP address, specify it using the
	// `IpRange.external_address` property.
	DestinationIpRanges []*ExternalAccessRule_IpRange `protobuf:"bytes,11,rep,name=destination_ip_ranges,json=destinationIpRanges,proto3" json:"destination_ip_ranges,omitempty"`
	// A list of destination ports to which the external access rule applies. This
	// field is only applicable for the UDP or TCP protocol.
	// Each entry must be either an integer or a range. For example: `["22"]`,
	// `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
	// specify `["0-65535"]`.
	DestinationPorts []string `protobuf:"bytes,12,rep,name=destination_ports,json=destinationPorts,proto3" json:"destination_ports,omitempty"`
	// Output only. The state of the resource.
	State ExternalAccessRule_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.ExternalAccessRule_State" json:"state,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *ExternalAccessRule) Reset() {
	*x = ExternalAccessRule{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalAccessRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalAccessRule) ProtoMessage() {}

func (x *ExternalAccessRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalAccessRule.ProtoReflect.Descriptor instead.
func (*ExternalAccessRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8}
}

func (x *ExternalAccessRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExternalAccessRule) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExternalAccessRule) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ExternalAccessRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ExternalAccessRule) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *ExternalAccessRule) GetAction() ExternalAccessRule_Action {
	if x != nil {
		return x.Action
	}
	return ExternalAccessRule_ACTION_UNSPECIFIED
}

func (x *ExternalAccessRule) GetIpProtocol() string {
	if x != nil {
		return x.IpProtocol
	}
	return ""
}

func (x *ExternalAccessRule) GetSourceIpRanges() []*ExternalAccessRule_IpRange {
	if x != nil {
		return x.SourceIpRanges
	}
	return nil
}

func (x *ExternalAccessRule) GetSourcePorts() []string {
	if x != nil {
		return x.SourcePorts
	}
	return nil
}

func (x *ExternalAccessRule) GetDestinationIpRanges() []*ExternalAccessRule_IpRange {
	if x != nil {
		return x.DestinationIpRanges
	}
	return nil
}

func (x *ExternalAccessRule) GetDestinationPorts() []string {
	if x != nil {
		return x.DestinationPorts
	}
	return nil
}

func (x *ExternalAccessRule) GetState() ExternalAccessRule_State {
	if x != nil {
		return x.State
	}
	return ExternalAccessRule_STATE_UNSPECIFIED
}

func (x *ExternalAccessRule) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Logging server to receive vCenter or ESXi logs.
type LoggingServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this logging server.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Fully-qualified domain name (FQDN) or IP Address of the logging
	// server.
	Hostname string `protobuf:"bytes,5,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Required. Port number at which the logging server receives logs.
	Port int32 `protobuf:"varint,7,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Protocol used by vCenter to send logs to a logging server.
	Protocol LoggingServer_Protocol `protobuf:"varint,6,opt,name=protocol,proto3,enum=google.cloud.vmwareengine.v1.LoggingServer_Protocol" json:"protocol,omitempty"`
	// Required. The type of component that produces logs that will be forwarded
	// to this logging server.
	SourceType LoggingServer_SourceType `protobuf:"varint,10,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.vmwareengine.v1.LoggingServer_SourceType" json:"source_type,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,8,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *LoggingServer) Reset() {
	*x = LoggingServer{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingServer) ProtoMessage() {}

func (x *LoggingServer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingServer.ProtoReflect.Descriptor instead.
func (*LoggingServer) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{9}
}

func (x *LoggingServer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoggingServer) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *LoggingServer) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *LoggingServer) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *LoggingServer) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *LoggingServer) GetProtocol() LoggingServer_Protocol {
	if x != nil {
		return x.Protocol
	}
	return LoggingServer_PROTOCOL_UNSPECIFIED
}

func (x *LoggingServer) GetSourceType() LoggingServer_SourceType {
	if x != nil {
		return x.SourceType
	}
	return LoggingServer_SOURCE_TYPE_UNSPECIFIED
}

func (x *LoggingServer) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Describes node type.
type NodeType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this node type.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The canonical identifier of the node type
	// (corresponds to the `NodeType`). For example: standard-72.
	NodeTypeId string `protobuf:"bytes,2,opt,name=node_type_id,json=nodeTypeId,proto3" json:"node_type_id,omitempty"`
	// Output only. The friendly name for this node type.
	// For example: ve1-standard-72
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The total number of virtual CPUs in a single node.
	VirtualCpuCount int32 `protobuf:"varint,4,opt,name=virtual_cpu_count,json=virtualCpuCount,proto3" json:"virtual_cpu_count,omitempty"`
	// Output only. The total number of CPU cores in a single node.
	TotalCoreCount int32 `protobuf:"varint,5,opt,name=total_core_count,json=totalCoreCount,proto3" json:"total_core_count,omitempty"`
	// Output only. The amount of physical memory available, defined in GB.
	MemoryGb int32 `protobuf:"varint,7,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Output only. The amount of storage available, defined in GB.
	DiskSizeGb int32 `protobuf:"varint,8,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Output only. List of possible values of custom core count.
	AvailableCustomCoreCounts []int32 `protobuf:"varint,11,rep,packed,name=available_custom_core_counts,json=availableCustomCoreCounts,proto3" json:"available_custom_core_counts,omitempty"`
	// Output only. The type of the resource.
	Kind NodeType_Kind `protobuf:"varint,12,opt,name=kind,proto3,enum=google.cloud.vmwareengine.v1.NodeType_Kind" json:"kind,omitempty"`
	// Output only. Families of the node type.
	// For node types to be in the same cluster
	// they must share at least one element in the `families`.
	Families []string `protobuf:"bytes,13,rep,name=families,proto3" json:"families,omitempty"`
	// Output only. Capabilities of this node type.
	Capabilities []NodeType_Capability `protobuf:"varint,14,rep,packed,name=capabilities,proto3,enum=google.cloud.vmwareengine.v1.NodeType_Capability" json:"capabilities,omitempty"`
}

func (x *NodeType) Reset() {
	*x = NodeType{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeType) ProtoMessage() {}

func (x *NodeType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeType.ProtoReflect.Descriptor instead.
func (*NodeType) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{10}
}

func (x *NodeType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeType) GetNodeTypeId() string {
	if x != nil {
		return x.NodeTypeId
	}
	return ""
}

func (x *NodeType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NodeType) GetVirtualCpuCount() int32 {
	if x != nil {
		return x.VirtualCpuCount
	}
	return 0
}

func (x *NodeType) GetTotalCoreCount() int32 {
	if x != nil {
		return x.TotalCoreCount
	}
	return 0
}

func (x *NodeType) GetMemoryGb() int32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *NodeType) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeType) GetAvailableCustomCoreCounts() []int32 {
	if x != nil {
		return x.AvailableCustomCoreCounts
	}
	return nil
}

func (x *NodeType) GetKind() NodeType_Kind {
	if x != nil {
		return x.Kind
	}
	return NodeType_KIND_UNSPECIFIED
}

func (x *NodeType) GetFamilies() []string {
	if x != nil {
		return x.Families
	}
	return nil
}

func (x *NodeType) GetCapabilities() []NodeType_Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

// Credentials for a private cloud.
type Credentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Initial username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Initial password.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *Credentials) Reset() {
	*x = Credentials{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Credentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Credentials) ProtoMessage() {}

func (x *Credentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Credentials.ProtoReflect.Descriptor instead.
func (*Credentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{11}
}

func (x *Credentials) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Credentials) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// HCX activation key. A default key is created during
// private cloud provisioning, but this behavior is subject to change
// and you should always verify active keys.
// Use
// [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
// to retrieve existing keys and
// [VmwareEngine.CreateHcxActivationKey][google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey]
// to create new ones.
type HcxActivationKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this HcxActivationKey.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of HCX activation key.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. State of HCX activation key.
	State HcxActivationKey_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.HcxActivationKey_State" json:"state,omitempty"`
	// Output only. HCX activation key.
	ActivationKey string `protobuf:"bytes,4,opt,name=activation_key,json=activationKey,proto3" json:"activation_key,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *HcxActivationKey) Reset() {
	*x = HcxActivationKey{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HcxActivationKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HcxActivationKey) ProtoMessage() {}

func (x *HcxActivationKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HcxActivationKey.ProtoReflect.Descriptor instead.
func (*HcxActivationKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{12}
}

func (x *HcxActivationKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HcxActivationKey) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *HcxActivationKey) GetState() HcxActivationKey_State {
	if x != nil {
		return x.State
	}
	return HcxActivationKey_STATE_UNSPECIFIED
}

func (x *HcxActivationKey) GetActivationKey() string {
	if x != nil {
		return x.ActivationKey
	}
	return ""
}

func (x *HcxActivationKey) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Details about a HCX Cloud Manager appliance.
type Hcx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Hcx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Hcx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Hcx) Reset() {
	*x = Hcx{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Hcx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hcx) ProtoMessage() {}

func (x *Hcx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hcx.ProtoReflect.Descriptor instead.
func (*Hcx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13}
}

func (x *Hcx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Hcx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Hcx) GetState() Hcx_State {
	if x != nil {
		return x.State
	}
	return Hcx_STATE_UNSPECIFIED
}

func (x *Hcx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a NSX Manager appliance.
type Nsx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Nsx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Nsx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Nsx) Reset() {
	*x = Nsx{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Nsx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Nsx) ProtoMessage() {}

func (x *Nsx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Nsx.ProtoReflect.Descriptor instead.
func (*Nsx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14}
}

func (x *Nsx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Nsx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Nsx) GetState() Nsx_State {
	if x != nil {
		return x.State
	}
	return Nsx_STATE_UNSPECIFIED
}

func (x *Nsx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a vCenter Server management appliance.
type Vcenter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Vcenter_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Vcenter_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Vcenter) Reset() {
	*x = Vcenter{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Vcenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vcenter) ProtoMessage() {}

func (x *Vcenter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vcenter.ProtoReflect.Descriptor instead.
func (*Vcenter) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{15}
}

func (x *Vcenter) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Vcenter) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Vcenter) GetState() Vcenter_State {
	if x != nil {
		return x.State
	}
	return Vcenter_STATE_UNSPECIFIED
}

func (x *Vcenter) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Autoscaling settings define the rules used by VMware Engine to
// automatically scale-out and scale-in the clusters in a private cloud.
type AutoscalingSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The map with autoscaling policies applied to the cluster.
	// The key is the identifier of the policy.
	// It must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC
	// 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
	//
	// Currently there map must contain only one element
	// that describes the autoscaling policy for compute nodes.
	AutoscalingPolicies map[string]*AutoscalingSettings_AutoscalingPolicy `protobuf:"bytes,1,rep,name=autoscaling_policies,json=autoscalingPolicies,proto3" json:"autoscaling_policies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Minimum number of nodes of any type in a cluster.
	// If not specified the default limits apply.
	MinClusterNodeCount int32 `protobuf:"varint,2,opt,name=min_cluster_node_count,json=minClusterNodeCount,proto3" json:"min_cluster_node_count,omitempty"`
	// Optional. Maximum number of nodes of any type in a cluster.
	// If not specified the default limits apply.
	MaxClusterNodeCount int32 `protobuf:"varint,3,opt,name=max_cluster_node_count,json=maxClusterNodeCount,proto3" json:"max_cluster_node_count,omitempty"`
	// Optional. The minimum duration between consecutive autoscale operations.
	// It starts once addition or removal of nodes is fully completed.
	// Defaults to 30 minutes if not specified. Cool down period must be in whole
	// minutes (for example, 30, 31, 50, 180 minutes).
	CoolDownPeriod *durationpb.Duration `protobuf:"bytes,4,opt,name=cool_down_period,json=coolDownPeriod,proto3" json:"cool_down_period,omitempty"`
}

func (x *AutoscalingSettings) Reset() {
	*x = AutoscalingSettings{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingSettings) ProtoMessage() {}

func (x *AutoscalingSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingSettings.ProtoReflect.Descriptor instead.
func (*AutoscalingSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{16}
}

func (x *AutoscalingSettings) GetAutoscalingPolicies() map[string]*AutoscalingSettings_AutoscalingPolicy {
	if x != nil {
		return x.AutoscalingPolicies
	}
	return nil
}

func (x *AutoscalingSettings) GetMinClusterNodeCount() int32 {
	if x != nil {
		return x.MinClusterNodeCount
	}
	return 0
}

func (x *AutoscalingSettings) GetMaxClusterNodeCount() int32 {
	if x != nil {
		return x.MaxClusterNodeCount
	}
	return 0
}

func (x *AutoscalingSettings) GetCoolDownPeriod() *durationpb.Duration {
	if x != nil {
		return x.CoolDownPeriod
	}
	return nil
}

// DNS forwarding config.
// This config defines a list of domain to name server mappings,
// and is attached to the private cloud for custom domain resolution.
type DnsForwarding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this DNS profile.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. List of domain mappings to configure
	ForwardingRules []*DnsForwarding_ForwardingRule `protobuf:"bytes,4,rep,name=forwarding_rules,json=forwardingRules,proto3" json:"forwarding_rules,omitempty"`
}

func (x *DnsForwarding) Reset() {
	*x = DnsForwarding{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnsForwarding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsForwarding) ProtoMessage() {}

func (x *DnsForwarding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsForwarding.ProtoReflect.Descriptor instead.
func (*DnsForwarding) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{17}
}

func (x *DnsForwarding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DnsForwarding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DnsForwarding) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DnsForwarding) GetForwardingRules() []*DnsForwarding_ForwardingRule {
	if x != nil {
		return x.ForwardingRules
	}
	return nil
}

// Details of a network peering.
type NetworkPeering struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the network peering. NetworkPeering is a
	// global resource and location can only be global. Resource names are
	// scheme-less URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/networkPeerings/my-peering`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The relative resource name of the network to peer with
	// a standard VMware Engine network. The provided network can be a
	// consumer VPC network or another standard VMware Engine network. If the
	// `peer_network_type` is VMWARE_ENGINE_NETWORK, specify the name in the form:
	// `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engine_network_id}`.
	// Otherwise specify the name in the form:
	// `projects/{project}/global/networks/{network_id}`, where
	// `{project}` can either be a project number or a project ID.
	PeerNetwork string `protobuf:"bytes,5,opt,name=peer_network,json=peerNetwork,proto3" json:"peer_network,omitempty"`
	// Optional. True if custom routes are exported to the peered network;
	// false otherwise. The default value is true.
	ExportCustomRoutes *bool `protobuf:"varint,8,opt,name=export_custom_routes,json=exportCustomRoutes,proto3,oneof" json:"export_custom_routes,omitempty"`
	// Optional. True if custom routes are imported from the peered network;
	// false otherwise. The default value is true.
	ImportCustomRoutes *bool `protobuf:"varint,9,opt,name=import_custom_routes,json=importCustomRoutes,proto3,oneof" json:"import_custom_routes,omitempty"`
	// Optional. True if full mesh connectivity is created and managed
	// automatically between peered networks; false otherwise. Currently this
	// field is always true because Google Compute Engine automatically creates
	// and manages subnetwork routes between two VPC networks when peering state
	// is 'ACTIVE'.
	ExchangeSubnetRoutes *bool `protobuf:"varint,10,opt,name=exchange_subnet_routes,json=exchangeSubnetRoutes,proto3,oneof" json:"exchange_subnet_routes,omitempty"`
	// Optional. True if all subnet routes with a public IP address range are
	// exported; false otherwise. The default value is true. IPv4 special-use
	// ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
	// exported to peers and are not controlled by this field.
	ExportCustomRoutesWithPublicIp *bool `protobuf:"varint,11,opt,name=export_custom_routes_with_public_ip,json=exportCustomRoutesWithPublicIp,proto3,oneof" json:"export_custom_routes_with_public_ip,omitempty"`
	// Optional. True if all subnet routes with public IP address range are
	// imported; false otherwise. The default value is true. IPv4 special-use
	// ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
	// imported to peers and are not controlled by this field.
	ImportCustomRoutesWithPublicIp *bool `protobuf:"varint,12,opt,name=import_custom_routes_with_public_ip,json=importCustomRoutesWithPublicIp,proto3,oneof" json:"import_custom_routes_with_public_ip,omitempty"`
	// Output only. State of the network peering. This field
	// has a value of 'ACTIVE' when there's a matching configuration in the peer
	// network. New values may be added to this enum when appropriate.
	State NetworkPeering_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.NetworkPeering_State" json:"state,omitempty"`
	// Output only. Output Only. Details about the current state of the network
	// peering.
	StateDetails string `protobuf:"bytes,7,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
	// Optional. Maximum transmission unit (MTU) in bytes.
	// The default value is `1500`. If a value of `0` is provided for this field,
	// VMware Engine uses the default value instead.
	PeerMtu int32 `protobuf:"varint,14,opt,name=peer_mtu,json=peerMtu,proto3" json:"peer_mtu,omitempty"`
	// Required. The type of the network to peer with the VMware Engine network.
	PeerNetworkType NetworkPeering_PeerNetworkType `protobuf:"varint,16,opt,name=peer_network_type,json=peerNetworkType,proto3,enum=google.cloud.vmwareengine.v1.NetworkPeering_PeerNetworkType" json:"peer_network_type,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,17,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The relative resource name of the VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,20,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. User-provided description for this network peering.
	Description string `protobuf:"bytes,21,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *NetworkPeering) Reset() {
	*x = NetworkPeering{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPeering) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPeering) ProtoMessage() {}

func (x *NetworkPeering) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPeering.ProtoReflect.Descriptor instead.
func (*NetworkPeering) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{18}
}

func (x *NetworkPeering) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkPeering) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NetworkPeering) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NetworkPeering) GetPeerNetwork() string {
	if x != nil {
		return x.PeerNetwork
	}
	return ""
}

func (x *NetworkPeering) GetExportCustomRoutes() bool {
	if x != nil && x.ExportCustomRoutes != nil {
		return *x.ExportCustomRoutes
	}
	return false
}

func (x *NetworkPeering) GetImportCustomRoutes() bool {
	if x != nil && x.ImportCustomRoutes != nil {
		return *x.ImportCustomRoutes
	}
	return false
}

func (x *NetworkPeering) GetExchangeSubnetRoutes() bool {
	if x != nil && x.ExchangeSubnetRoutes != nil {
		return *x.ExchangeSubnetRoutes
	}
	return false
}

func (x *NetworkPeering) GetExportCustomRoutesWithPublicIp() bool {
	if x != nil && x.ExportCustomRoutesWithPublicIp != nil {
		return *x.ExportCustomRoutesWithPublicIp
	}
	return false
}

func (x *NetworkPeering) GetImportCustomRoutesWithPublicIp() bool {
	if x != nil && x.ImportCustomRoutesWithPublicIp != nil {
		return *x.ImportCustomRoutesWithPublicIp
	}
	return false
}

func (x *NetworkPeering) GetState() NetworkPeering_State {
	if x != nil {
		return x.State
	}
	return NetworkPeering_STATE_UNSPECIFIED
}

func (x *NetworkPeering) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

func (x *NetworkPeering) GetPeerMtu() int32 {
	if x != nil {
		return x.PeerMtu
	}
	return 0
}

func (x *NetworkPeering) GetPeerNetworkType() NetworkPeering_PeerNetworkType {
	if x != nil {
		return x.PeerNetworkType
	}
	return NetworkPeering_PEER_NETWORK_TYPE_UNSPECIFIED
}

func (x *NetworkPeering) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *NetworkPeering) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkPeering) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Exchanged network peering route.
type PeeringRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Destination range of the peering route in CIDR notation.
	DestRange string `protobuf:"bytes,1,opt,name=dest_range,json=destRange,proto3" json:"dest_range,omitempty"`
	// Output only. Type of the route in the peer VPC network.
	Type PeeringRoute_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PeeringRoute_Type" json:"type,omitempty"`
	// Output only. Region containing the next hop of the peering route. This
	// field only applies to dynamic routes in the peer VPC network.
	NextHopRegion string `protobuf:"bytes,3,opt,name=next_hop_region,json=nextHopRegion,proto3" json:"next_hop_region,omitempty"`
	// Output only. The priority of the peering route.
	Priority int64 `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
	// Output only. True if the peering route has been imported from a peered
	// VPC network; false otherwise. The import happens if the field
	// `NetworkPeering.importCustomRoutes` is true for this network,
	// `NetworkPeering.exportCustomRoutes` is true for the peer VPC network, and
	// the import does not result in a route conflict.
	Imported bool `protobuf:"varint,5,opt,name=imported,proto3" json:"imported,omitempty"`
	// Output only. Direction of the routes exchanged with the peer network, from
	// the VMware Engine network perspective:
	//
	// * Routes of direction `INCOMING` are imported from the peer network.
	// * Routes of direction `OUTGOING` are exported from the intranet VPC network
	// of the VMware Engine network.
	Direction PeeringRoute_Direction `protobuf:"varint,6,opt,name=direction,proto3,enum=google.cloud.vmwareengine.v1.PeeringRoute_Direction" json:"direction,omitempty"`
}

func (x *PeeringRoute) Reset() {
	*x = PeeringRoute{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeeringRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringRoute) ProtoMessage() {}

func (x *PeeringRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringRoute.ProtoReflect.Descriptor instead.
func (*PeeringRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{19}
}

func (x *PeeringRoute) GetDestRange() string {
	if x != nil {
		return x.DestRange
	}
	return ""
}

func (x *PeeringRoute) GetType() PeeringRoute_Type {
	if x != nil {
		return x.Type
	}
	return PeeringRoute_TYPE_UNSPECIFIED
}

func (x *PeeringRoute) GetNextHopRegion() string {
	if x != nil {
		return x.NextHopRegion
	}
	return ""
}

func (x *PeeringRoute) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *PeeringRoute) GetImported() bool {
	if x != nil {
		return x.Imported
	}
	return false
}

func (x *PeeringRoute) GetDirection() PeeringRoute_Direction {
	if x != nil {
		return x.Direction
	}
	return PeeringRoute_DIRECTION_UNSPECIFIED
}

// Represents a network policy resource. Network policies are regional
// resources. You can use a network policy to enable or disable internet access
// and external IP access. Network policies are associated with a VMware Engine
// network, which might span across regions. For a given region, a network
// policy applies to all private clouds in the VMware Engine network associated
// with the policy.
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this network policy.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Network service that allows VMware workloads to access the internet.
	InternetAccess *NetworkPolicy_NetworkService `protobuf:"bytes,6,opt,name=internet_access,json=internetAccess,proto3" json:"internet_access,omitempty"`
	// Network service that allows External IP addresses to be assigned to VMware
	// workloads. This service can only be enabled when `internet_access` is also
	// enabled.
	ExternalIp *NetworkPolicy_NetworkService `protobuf:"bytes,7,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Required. IP address range in CIDR notation used to create internet access
	// and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
	// required. The range cannot overlap with any prefixes either in the consumer
	// VPC network or in use by the private clouds attached to that VPC network.
	EdgeServicesCidr string `protobuf:"bytes,9,opt,name=edge_services_cidr,json=edgeServicesCidr,proto3" json:"edge_services_cidr,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,10,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The relative resource name of the VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,12,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. User-provided description for this network policy.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,14,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{20}
}

func (x *NetworkPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NetworkPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NetworkPolicy) GetInternetAccess() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.InternetAccess
	}
	return nil
}

func (x *NetworkPolicy) GetExternalIp() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.ExternalIp
	}
	return nil
}

func (x *NetworkPolicy) GetEdgeServicesCidr() string {
	if x != nil {
		return x.EdgeServicesCidr
	}
	return ""
}

func (x *NetworkPolicy) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

// Represents a binding between a network and the management DNS zone.
// A management DNS zone is the Cloud DNS cross-project binding zone that
// VMware Engine creates for each private cloud. It contains FQDNs and
// corresponding IP addresses for the private cloud's ESXi hosts and management
// VM appliances like vCenter and NSX Manager.
type ManagementDnsZoneBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this binding.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The state of the resource.
	State ManagementDnsZoneBinding_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.ManagementDnsZoneBinding_State" json:"state,omitempty"`
	// User-provided description for this resource.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The relative resource name of the network to bind to the
	// management DNS zone. This network can be a consumer VPC network or a
	// VMware engine network.
	//
	// Types that are assignable to BindNetwork:
	//
	//	*ManagementDnsZoneBinding_VpcNetwork
	//	*ManagementDnsZoneBinding_VmwareEngineNetwork
	BindNetwork isManagementDnsZoneBinding_BindNetwork `protobuf_oneof:"bind_network"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *ManagementDnsZoneBinding) Reset() {
	*x = ManagementDnsZoneBinding{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManagementDnsZoneBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagementDnsZoneBinding) ProtoMessage() {}

func (x *ManagementDnsZoneBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagementDnsZoneBinding.ProtoReflect.Descriptor instead.
func (*ManagementDnsZoneBinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{21}
}

func (x *ManagementDnsZoneBinding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ManagementDnsZoneBinding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagementDnsZoneBinding) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ManagementDnsZoneBinding) GetState() ManagementDnsZoneBinding_State {
	if x != nil {
		return x.State
	}
	return ManagementDnsZoneBinding_STATE_UNSPECIFIED
}

func (x *ManagementDnsZoneBinding) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *ManagementDnsZoneBinding) GetBindNetwork() isManagementDnsZoneBinding_BindNetwork {
	if m != nil {
		return m.BindNetwork
	}
	return nil
}

func (x *ManagementDnsZoneBinding) GetVpcNetwork() string {
	if x, ok := x.GetBindNetwork().(*ManagementDnsZoneBinding_VpcNetwork); ok {
		return x.VpcNetwork
	}
	return ""
}

func (x *ManagementDnsZoneBinding) GetVmwareEngineNetwork() string {
	if x, ok := x.GetBindNetwork().(*ManagementDnsZoneBinding_VmwareEngineNetwork); ok {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *ManagementDnsZoneBinding) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

type isManagementDnsZoneBinding_BindNetwork interface {
	isManagementDnsZoneBinding_BindNetwork()
}

type ManagementDnsZoneBinding_VpcNetwork struct {
	// Network to bind is a standard consumer VPC.
	// Specify the name in the following form for consumer
	// VPC network: `projects/{project}/global/networks/{network_id}`.
	// `{project}` can either be a project number or a project ID.
	VpcNetwork string `protobuf:"bytes,14,opt,name=vpc_network,json=vpcNetwork,proto3,oneof"`
}

type ManagementDnsZoneBinding_VmwareEngineNetwork struct {
	// Network to bind is a VMware Engine network.
	// Specify the name in the following form for VMware engine network:
	// `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engine_network_id}`.
	// `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,15,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3,oneof"`
}

func (*ManagementDnsZoneBinding_VpcNetwork) isManagementDnsZoneBinding_BindNetwork() {}

func (*ManagementDnsZoneBinding_VmwareEngineNetwork) isManagementDnsZoneBinding_BindNetwork() {}

// VMware Engine network resource that provides connectivity for VMware Engine
// private clouds.
type VmwareEngineNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the VMware Engine network.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description for this VMware Engine network.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. VMware Engine service VPC networks that provide connectivity
	// from a private cloud to customer projects, the internet, and other Google
	// Cloud services.
	VpcNetworks []*VmwareEngineNetwork_VpcNetwork `protobuf:"bytes,6,rep,name=vpc_networks,json=vpcNetworks,proto3" json:"vpc_networks,omitempty"`
	// Output only. State of the VMware Engine network.
	State VmwareEngineNetwork_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_State" json:"state,omitempty"`
	// Required. VMware Engine network type.
	Type VmwareEngineNetwork_Type `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_Type" json:"type,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Checksum that may be sent on update and delete requests to ensure that the
	// user-provided value is up to date before the server processes a request.
	// The server computes checksums based on the value of other fields in the
	// request.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *VmwareEngineNetwork) Reset() {
	*x = VmwareEngineNetwork{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareEngineNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{22}
}

func (x *VmwareEngineNetwork) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VmwareEngineNetwork) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VmwareEngineNetwork) GetVpcNetworks() []*VmwareEngineNetwork_VpcNetwork {
	if x != nil {
		return x.VpcNetworks
	}
	return nil
}

func (x *VmwareEngineNetwork) GetState() VmwareEngineNetwork_State {
	if x != nil {
		return x.State
	}
	return VmwareEngineNetwork_STATE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetType() VmwareEngineNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *VmwareEngineNetwork) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Private connection resource that provides connectivity for VMware Engine
// private clouds.
type PrivateConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the private connection.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateConnections/my-connection`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-provided description for this private connection.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. State of the private connection.
	State PrivateConnection_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_State" json:"state,omitempty"`
	// Required. The relative resource name of Legacy VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}`, `{location}` will be same as specified in private
	// connection resource name and `{vmware_engine_network_id}` will be in the
	// form of `{location}`-default e.g.
	// projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
	VmwareEngineNetwork string `protobuf:"bytes,8,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,9,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
	// Required. Private connection type.
	Type PrivateConnection_Type `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_Type" json:"type,omitempty"`
	// Output only. VPC network peering id between given network VPC and
	// VMwareEngineNetwork.
	PeeringId string `protobuf:"bytes,12,opt,name=peering_id,json=peeringId,proto3" json:"peering_id,omitempty"`
	// Optional. Routing Mode.
	// Default value is set to GLOBAL.
	// For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
	// REGIONAL, for other types only GLOBAL is supported.
	RoutingMode PrivateConnection_RoutingMode `protobuf:"varint,13,opt,name=routing_mode,json=routingMode,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_RoutingMode" json:"routing_mode,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. Service network to create private connection.
	// Specify the name in the following form:
	// `projects/{project}/global/networks/{network_id}`
	// For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
	// VPC, e.g. projects/project-tp/global/networks/servicenetworking.
	// For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
	// e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
	// For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
	// projects/project-tp/global/networks/dell-tenant-vpc.
	// For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
	// any other producer VPC to which the VMware Engine Network needs to be
	// connected, e.g. projects/project/global/networks/vpc.
	ServiceNetwork string `protobuf:"bytes,16,opt,name=service_network,json=serviceNetwork,proto3" json:"service_network,omitempty"`
	// Output only. Peering state between service network and VMware Engine
	// network.
	PeeringState PrivateConnection_PeeringState `protobuf:"varint,17,opt,name=peering_state,json=peeringState,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_PeeringState" json:"peering_state,omitempty"`
}

func (x *PrivateConnection) Reset() {
	*x = PrivateConnection{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnection) ProtoMessage() {}

func (x *PrivateConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnection.ProtoReflect.Descriptor instead.
func (*PrivateConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{23}
}

func (x *PrivateConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateConnection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrivateConnection) GetState() PrivateConnection_State {
	if x != nil {
		return x.State
	}
	return PrivateConnection_STATE_UNSPECIFIED
}

func (x *PrivateConnection) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *PrivateConnection) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

func (x *PrivateConnection) GetType() PrivateConnection_Type {
	if x != nil {
		return x.Type
	}
	return PrivateConnection_TYPE_UNSPECIFIED
}

func (x *PrivateConnection) GetPeeringId() string {
	if x != nil {
		return x.PeeringId
	}
	return ""
}

func (x *PrivateConnection) GetRoutingMode() PrivateConnection_RoutingMode {
	if x != nil {
		return x.RoutingMode
	}
	return PrivateConnection_ROUTING_MODE_UNSPECIFIED
}

func (x *PrivateConnection) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PrivateConnection) GetServiceNetwork() string {
	if x != nil {
		return x.ServiceNetwork
	}
	return ""
}

func (x *PrivateConnection) GetPeeringState() PrivateConnection_PeeringState {
	if x != nil {
		return x.PeeringState
	}
	return PrivateConnection_PEERING_STATE_UNSPECIFIED
}

// VmwareEngine specific metadata for the given
// [google.cloud.location.Location][google.cloud.location.Location]. It is
// returned as a content of the `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Capabilities of this location.
	Capabilities []LocationMetadata_Capability `protobuf:"varint,1,rep,packed,name=capabilities,proto3,enum=google.cloud.vmwareengine.v1.LocationMetadata_Capability" json:"capabilities,omitempty"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{24}
}

func (x *LocationMetadata) GetCapabilities() []LocationMetadata_Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

// DnsBindPermission resource that contains the accounts having the consumer DNS
// bind permission on the corresponding intranet VPC of the consumer project.
type DnsBindPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output only. The name of the resource which stores the
	// users/service accounts having the permission to bind to the corresponding
	// intranet VPC of the consumer project. DnsBindPermission is a global
	// resource and location can only be global. Resource names are schemeless
	// URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global/dnsBindPermission`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Users/Service accounts which have access for binding on the
	// intranet VPC project corresponding to the consumer project.
	Principals []*Principal `protobuf:"bytes,2,rep,name=principals,proto3" json:"principals,omitempty"`
}

func (x *DnsBindPermission) Reset() {
	*x = DnsBindPermission{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnsBindPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsBindPermission) ProtoMessage() {}

func (x *DnsBindPermission) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsBindPermission.ProtoReflect.Descriptor instead.
func (*DnsBindPermission) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{25}
}

func (x *DnsBindPermission) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DnsBindPermission) GetPrincipals() []*Principal {
	if x != nil {
		return x.Principals
	}
	return nil
}

// Users/Service accounts which have access for DNS binding on the intranet
// VPC corresponding to the consumer project.
type Principal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The consumer provided user/service account which needs to be
	// granted permission to DNS bind with the intranet VPC corresponding to the
	// consumer project.
	//
	// Types that are assignable to Principal:
	//
	//	*Principal_User
	//	*Principal_ServiceAccount
	Principal isPrincipal_Principal `protobuf_oneof:"principal"`
}

func (x *Principal) Reset() {
	*x = Principal{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Principal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Principal) ProtoMessage() {}

func (x *Principal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Principal.ProtoReflect.Descriptor instead.
func (*Principal) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{26}
}

func (m *Principal) GetPrincipal() isPrincipal_Principal {
	if m != nil {
		return m.Principal
	}
	return nil
}

func (x *Principal) GetUser() string {
	if x, ok := x.GetPrincipal().(*Principal_User); ok {
		return x.User
	}
	return ""
}

func (x *Principal) GetServiceAccount() string {
	if x, ok := x.GetPrincipal().(*Principal_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return ""
}

type isPrincipal_Principal interface {
	isPrincipal_Principal()
}

type Principal_User struct {
	// The user who needs to be granted permission.
	User string `protobuf:"bytes,1,opt,name=user,proto3,oneof"`
}

type Principal_ServiceAccount struct {
	// The service account which needs to be granted the permission.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3,oneof"`
}

func (*Principal_User) isPrincipal_Principal() {}

func (*Principal_ServiceAccount) isPrincipal_Principal() {}

// Management cluster configuration.
type PrivateCloud_ManagementCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user-provided identifier of the new `Cluster`.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC
	// 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is
	// canonical identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,7,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Configuration of a stretched cluster. Required for STRETCHED
	// private clouds.
	StretchedClusterConfig *StretchedClusterConfig `protobuf:"bytes,8,opt,name=stretched_cluster_config,json=stretchedClusterConfig,proto3" json:"stretched_cluster_config,omitempty"`
}

func (x *PrivateCloud_ManagementCluster) Reset() {
	*x = PrivateCloud_ManagementCluster{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateCloud_ManagementCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud_ManagementCluster) ProtoMessage() {}

func (x *PrivateCloud_ManagementCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud_ManagementCluster.ProtoReflect.Descriptor instead.
func (*PrivateCloud_ManagementCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PrivateCloud_ManagementCluster) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *PrivateCloud_ManagementCluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

func (x *PrivateCloud_ManagementCluster) GetStretchedClusterConfig() *StretchedClusterConfig {
	if x != nil {
		return x.StretchedClusterConfig
	}
	return nil
}

// An IP range provided in any one of the supported formats.
type ExternalAccessRule_IpRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to IpRange:
	//
	//	*ExternalAccessRule_IpRange_IpAddress
	//	*ExternalAccessRule_IpRange_IpAddressRange
	//	*ExternalAccessRule_IpRange_ExternalAddress
	IpRange isExternalAccessRule_IpRange_IpRange `protobuf_oneof:"ip_range"`
}

func (x *ExternalAccessRule_IpRange) Reset() {
	*x = ExternalAccessRule_IpRange{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalAccessRule_IpRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalAccessRule_IpRange) ProtoMessage() {}

func (x *ExternalAccessRule_IpRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalAccessRule_IpRange.ProtoReflect.Descriptor instead.
func (*ExternalAccessRule_IpRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8, 0}
}

func (m *ExternalAccessRule_IpRange) GetIpRange() isExternalAccessRule_IpRange_IpRange {
	if m != nil {
		return m.IpRange
	}
	return nil
}

func (x *ExternalAccessRule_IpRange) GetIpAddress() string {
	if x, ok := x.GetIpRange().(*ExternalAccessRule_IpRange_IpAddress); ok {
		return x.IpAddress
	}
	return ""
}

func (x *ExternalAccessRule_IpRange) GetIpAddressRange() string {
	if x, ok := x.GetIpRange().(*ExternalAccessRule_IpRange_IpAddressRange); ok {
		return x.IpAddressRange
	}
	return ""
}

func (x *ExternalAccessRule_IpRange) GetExternalAddress() string {
	if x, ok := x.GetIpRange().(*ExternalAccessRule_IpRange_ExternalAddress); ok {
		return x.ExternalAddress
	}
	return ""
}

type isExternalAccessRule_IpRange_IpRange interface {
	isExternalAccessRule_IpRange_IpRange()
}

type ExternalAccessRule_IpRange_IpAddress struct {
	// A single IP address. For example: `10.0.0.5`.
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3,oneof"`
}

type ExternalAccessRule_IpRange_IpAddressRange struct {
	// An IP address range in the CIDR format. For example: `10.0.0.0/24`.
	IpAddressRange string `protobuf:"bytes,2,opt,name=ip_address_range,json=ipAddressRange,proto3,oneof"`
}

type ExternalAccessRule_IpRange_ExternalAddress struct {
	// The name of an `ExternalAddress` resource. The external address must
	// have been reserved in the scope of this external access rule's parent
	// network policy.  Provide the external address name in the form of
	// `projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}`.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-address`.
	ExternalAddress string `protobuf:"bytes,3,opt,name=external_address,json=externalAddress,proto3,oneof"`
}

func (*ExternalAccessRule_IpRange_IpAddress) isExternalAccessRule_IpRange_IpRange() {}

func (*ExternalAccessRule_IpRange_IpAddressRange) isExternalAccessRule_IpRange_IpRange() {}

func (*ExternalAccessRule_IpRange_ExternalAddress) isExternalAccessRule_IpRange_IpRange() {}

// Thresholds define the utilization of resources triggering
// scale-out and scale-in operations.
type AutoscalingSettings_Thresholds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The utilization triggering the scale-out operation in percent.
	ScaleOut int32 `protobuf:"varint,1,opt,name=scale_out,json=scaleOut,proto3" json:"scale_out,omitempty"`
	// Required. The utilization triggering the scale-in operation in percent.
	ScaleIn int32 `protobuf:"varint,2,opt,name=scale_in,json=scaleIn,proto3" json:"scale_in,omitempty"`
}

func (x *AutoscalingSettings_Thresholds) Reset() {
	*x = AutoscalingSettings_Thresholds{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingSettings_Thresholds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingSettings_Thresholds) ProtoMessage() {}

func (x *AutoscalingSettings_Thresholds) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingSettings_Thresholds.ProtoReflect.Descriptor instead.
func (*AutoscalingSettings_Thresholds) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{16, 0}
}

func (x *AutoscalingSettings_Thresholds) GetScaleOut() int32 {
	if x != nil {
		return x.ScaleOut
	}
	return 0
}

func (x *AutoscalingSettings_Thresholds) GetScaleIn() int32 {
	if x != nil {
		return x.ScaleIn
	}
	return 0
}

// Autoscaling policy describes the behavior of the autoscaling
// with respect to the resource utilization.
// The scale-out operation is initiated if the utilization
// exceeds ANY of the respective thresholds.
// The scale-in operation is initiated if the utilization
// is below ALL of the respective thresholds.
type AutoscalingSettings_AutoscalingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical identifier of the node type to add or remove.
	// Corresponds to the `NodeType`.
	NodeTypeId string `protobuf:"bytes,1,opt,name=node_type_id,json=nodeTypeId,proto3" json:"node_type_id,omitempty"`
	// Required. Number of nodes to add to a cluster during a scale-out
	// operation. Must be divisible by 2 for stretched clusters. During a
	// scale-in operation only one node (or 2 for stretched clusters) are
	// removed in a single iteration.
	ScaleOutSize int32 `protobuf:"varint,2,opt,name=scale_out_size,json=scaleOutSize,proto3" json:"scale_out_size,omitempty"`
	// Optional. Utilization thresholds pertaining to CPU utilization.
	CpuThresholds *AutoscalingSettings_Thresholds `protobuf:"bytes,11,opt,name=cpu_thresholds,json=cpuThresholds,proto3" json:"cpu_thresholds,omitempty"`
	// Optional. Utilization thresholds pertaining to amount of granted memory.
	GrantedMemoryThresholds *AutoscalingSettings_Thresholds `protobuf:"bytes,12,opt,name=granted_memory_thresholds,json=grantedMemoryThresholds,proto3" json:"granted_memory_thresholds,omitempty"`
	// Optional. Utilization thresholds pertaining to amount of consumed memory.
	ConsumedMemoryThresholds *AutoscalingSettings_Thresholds `protobuf:"bytes,13,opt,name=consumed_memory_thresholds,json=consumedMemoryThresholds,proto3" json:"consumed_memory_thresholds,omitempty"`
	// Optional. Utilization thresholds pertaining to amount of consumed
	// storage.
	StorageThresholds *AutoscalingSettings_Thresholds `protobuf:"bytes,14,opt,name=storage_thresholds,json=storageThresholds,proto3" json:"storage_thresholds,omitempty"`
}

func (x *AutoscalingSettings_AutoscalingPolicy) Reset() {
	*x = AutoscalingSettings_AutoscalingPolicy{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingSettings_AutoscalingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingSettings_AutoscalingPolicy) ProtoMessage() {}

func (x *AutoscalingSettings_AutoscalingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingSettings_AutoscalingPolicy.ProtoReflect.Descriptor instead.
func (*AutoscalingSettings_AutoscalingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{16, 1}
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetNodeTypeId() string {
	if x != nil {
		return x.NodeTypeId
	}
	return ""
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetScaleOutSize() int32 {
	if x != nil {
		return x.ScaleOutSize
	}
	return 0
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetCpuThresholds() *AutoscalingSettings_Thresholds {
	if x != nil {
		return x.CpuThresholds
	}
	return nil
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetGrantedMemoryThresholds() *AutoscalingSettings_Thresholds {
	if x != nil {
		return x.GrantedMemoryThresholds
	}
	return nil
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetConsumedMemoryThresholds() *AutoscalingSettings_Thresholds {
	if x != nil {
		return x.ConsumedMemoryThresholds
	}
	return nil
}

func (x *AutoscalingSettings_AutoscalingPolicy) GetStorageThresholds() *AutoscalingSettings_Thresholds {
	if x != nil {
		return x.StorageThresholds
	}
	return nil
}

// A forwarding rule is a mapping of a `domain` to `name_servers`.
// This mapping allows VMware Engine to resolve domains for attached private
// clouds by forwarding DNS requests for a given domain to the specified
// nameservers.
type DnsForwarding_ForwardingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Domain used to resolve a `name_servers` list.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// Required. List of DNS servers to use for domain resolution
	NameServers []string `protobuf:"bytes,2,rep,name=name_servers,json=nameServers,proto3" json:"name_servers,omitempty"`
}

func (x *DnsForwarding_ForwardingRule) Reset() {
	*x = DnsForwarding_ForwardingRule{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnsForwarding_ForwardingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsForwarding_ForwardingRule) ProtoMessage() {}

func (x *DnsForwarding_ForwardingRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsForwarding_ForwardingRule.ProtoReflect.Descriptor instead.
func (*DnsForwarding_ForwardingRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{17, 0}
}

func (x *DnsForwarding_ForwardingRule) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *DnsForwarding_ForwardingRule) GetNameServers() []string {
	if x != nil {
		return x.NameServers
	}
	return nil
}

// Represents a network service that is managed by a `NetworkPolicy` resource.
// A network service provides a way to control an aspect of external access to
// VMware workloads. For example, whether the VMware workloads in the
// private clouds governed by a network policy can access or be accessed from
// the internet.
type NetworkPolicy_NetworkService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the service is enabled; false otherwise.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Output only. State of the service. New values may be added to this enum
	// when appropriate.
	State NetworkPolicy_NetworkService_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.NetworkPolicy_NetworkService_State" json:"state,omitempty"`
}

func (x *NetworkPolicy_NetworkService) Reset() {
	*x = NetworkPolicy_NetworkService{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPolicy_NetworkService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy_NetworkService) ProtoMessage() {}

func (x *NetworkPolicy_NetworkService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy_NetworkService.ProtoReflect.Descriptor instead.
func (*NetworkPolicy_NetworkService) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{20, 0}
}

func (x *NetworkPolicy_NetworkService) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NetworkPolicy_NetworkService) GetState() NetworkPolicy_NetworkService_State {
	if x != nil {
		return x.State
	}
	return NetworkPolicy_NetworkService_STATE_UNSPECIFIED
}

// Represents a VMware Engine VPC network that is managed by a
// VMware Engine network resource.
type VmwareEngineNetwork_VpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Type of VPC network (INTRANET, INTERNET, or
	// GOOGLE_CLOUD)
	Type VmwareEngineNetwork_VpcNetwork_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_VpcNetwork_Type" json:"type,omitempty"`
	// Output only. The relative resource name of the service VPC network this
	// VMware Engine network is attached to. For example:
	// `projects/123123/global/networks/my-network`
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *VmwareEngineNetwork_VpcNetwork) Reset() {
	*x = VmwareEngineNetwork_VpcNetwork{}
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareEngineNetwork_VpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork_VpcNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork_VpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork_VpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{22, 0}
}

func (x *VmwareEngineNetwork_VpcNetwork) GetType() VmwareEngineNetwork_VpcNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork_VpcNetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

var File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto protoreflect.FileDescriptor

var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x03, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x69, 0x64, 0x72, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c,
	0x12, 0x53, 0x0a, 0x24, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0d, 0x64, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x70, 0x22, 0x65,
	0x0a, 0x0e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x72, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xcc, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x72, 0x65, 0x74, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x58, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x12, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc8, 0x0c, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x12,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x03, 0x68, 0x63, 0x78, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x63, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x68, 0x63, 0x78, 0x12, 0x38, 0x0a,
	0x03, 0x6e, 0x73, 0x78, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x6e, 0x73, 0x78, 0x12, 0x44, 0x0a, 0x07, 0x76, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xa3,
	0x03, 0x0a, 0x11, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6e, 0x6f,
	0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x73, 0x0a,
	0x18, 0x73, 0x74, 0x72, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x74, 0x72, 0x65,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x55, 0x52, 0x47, 0x49, 0x4e, 0x47,
	0x10, 0x07, 0x22, 0x35, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x49, 0x4d, 0x45,
	0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x54,
	0x52, 0x45, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x28,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x22,
	0xd3, 0x07, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x69, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x10, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0x73, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x65, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x73, 0x74, 0x72, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x63, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05,
	0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x58, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0xff, 0x03, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x22, 0x53, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x50, 0x47, 0x52,
	0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x8d, 0x01, 0xea, 0x41, 0x89, 0x01, 0x0a, 0x20,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65,
	0x12, 0x65, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x7d, 0x22, 0xf4, 0x04, 0x0a, 0x0f, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12,
	0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x9d,
	0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x2b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x7d, 0x22, 0xd6,
	0x03, 0x0a, 0x06, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69, 0x64,
	0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x69, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x49, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x45,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x76, 0x6c, 0x61,
	0x6e, 0x49, 0x64, 0x22, 0x71, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43,
	0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x22, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12,
	0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x7d, 0x22, 0xea, 0x09, 0x0a, 0x12, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4f, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x70,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x69, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x62, 0x0a, 0x10, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72,
	0x74, 0x73, 0x12, 0x6c, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x13, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x51, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x1a, 0xc1, 0x01, 0x0a, 0x07, 0x49, 0x70, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0e, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x5d, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42,
	0x0a, 0x0a, 0x08, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x35, 0x0a, 0x06, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e, 0x59,
	0x10, 0x02, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0xa9, 0x01, 0xea, 0x41, 0xa5, 0x01, 0x0a,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x73, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x7d, 0x22, 0xde, 0x05, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x55, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x5c, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x22, 0x52, 0x0a, 0x08, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f,
	0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x55, 0x44, 0x50, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10,
	0x02, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x53,
	0x4c, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45, 0x4c, 0x50, 0x10, 0x05, 0x22, 0x3d, 0x0a,
	0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x53, 0x58, 0x49,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x43, 0x53, 0x41, 0x10, 0x02, 0x3a, 0x96, 0x01, 0xea,
	0x41, 0x92, 0x01, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x65,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x7d, 0x22, 0x8e, 0x06, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x76, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x43, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x67, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x25, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x47, 0x62, 0x12, 0x44, 0x0a, 0x1c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x1f, 0x0a, 0x08, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73,
	0x12, 0x5a, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x3c, 0x0a, 0x04,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x4f, 0x52,
	0x41, 0x47, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x40, 0x0a, 0x0a, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x50, 0x41,
	0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x52, 0x45, 0x54, 0x43, 0x48, 0x45,
	0x44, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x53, 0x10, 0x01, 0x3a, 0x68, 0xea, 0x41,
	0x65, 0x0a, 0x24, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x22, 0x45, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0xef, 0x03,
	0x0a, 0x10, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a,
	0x0a, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x22, 0x49, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0xa0, 0x01, 0xea,
	0x41, 0x9c, 0x01, 0x0a, 0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x12, 0x6c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x68, 0x63, 0x78, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x22,
	0xe2, 0x01, 0x0a, 0x03, 0x48, 0x63, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x63, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x48, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x22, 0xd2, 0x01, 0x0a, 0x03, 0x4e, 0x73, 0x78, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66,
	0x71, 0x64, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22,
	0x38, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xda, 0x01, 0x0a, 0x07, 0x56, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xfa, 0x08, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x82,
	0x01, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x16, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6d, 0x69, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a,
	0x16, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x10, 0x63, 0x6f, 0x6f, 0x6c, 0x5f,
	0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6f, 0x6c, 0x44, 0x6f, 0x77, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x1a, 0x4e, 0x0a, 0x0a, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x12,
	0x20, 0x0a, 0x09, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x4f, 0x75,
	0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x49,
	0x6e, 0x1a, 0xc1, 0x04, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x29,
	0x0a, 0x0e, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x63, 0x61,
	0x6c, 0x65, 0x4f, 0x75, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x68, 0x0a, 0x0e, 0x63, 0x70, 0x75,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x70, 0x75, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x73, 0x12, 0x7d, 0x0a, 0x19, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x73, 0x12, 0x7f, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x73, 0x12, 0x70, 0x0a, 0x12, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x73, 0x1a, 0x8b, 0x01, 0x0a, 0x18, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x59, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xf6, 0x03, 0x0a, 0x0d, 0x44, 0x6e, 0x73, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0x55,
	0x0a, 0x0e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x26, 0x0a,
	0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x29, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x64,
	0x6e, 0x73, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xc3, 0x0c, 0x0a,
	0x0e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x70, 0x65, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x65, 0x65, 0x72, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3a, 0x0a, 0x14, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x3a, 0x0a, 0x14, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x12, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x16,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x02, 0x52, 0x14, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x23,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x69, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03,
	0x52, 0x1e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x57, 0x69, 0x74, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70,
	0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x23, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68,
	0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x1e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x57, 0x69, 0x74, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x6d, 0x74, 0x75, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70, 0x65, 0x65, 0x72,
	0x4d, 0x74, 0x75, 0x12, 0x6d, 0x0a, 0x11, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65,
	0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x70, 0x65, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x22, 0xe3, 0x01, 0x0a, 0x0f, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x45, 0x45, 0x52, 0x5f,
	0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x4d, 0x57, 0x41,
	0x52, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03,
	0x12, 0x18, 0x0a, 0x14, 0x4e, 0x45, 0x54, 0x41, 0x50, 0x50, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x53, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x48,
	0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43,
	0x45, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x4c, 0x5f, 0x50, 0x4f, 0x57, 0x45,
	0x52, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x06, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4e, 0x45, 0x54, 0x41, 0x50, 0x50, 0x5f,
	0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x53, 0x10, 0x07, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a, 0x2a,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x7d, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x42, 0x17,
	0x0a, 0x15, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x65, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68,
	0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x69, 0x70, 0x22, 0xf5, 0x03, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x65,
	0x73, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x1f, 0x0a, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x12, 0x57, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x59, 0x4e, 0x41, 0x4d,
	0x49, 0x43, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x50, 0x45, 0x45,
	0x52, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14,
	0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x10, 0x03, 0x22, 0x42, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x4f, 0x55, 0x54, 0x47, 0x4f, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xa0, 0x08, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x5b,
	0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x31, 0x0a, 0x12, 0x65,
	0x64, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x69, 0x64,
	0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x65, 0x64,
	0x67, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x69, 0x64, 0x72, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x13, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x1a, 0xd7, 0x01, 0x0a, 0x0e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x4e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49,
	0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43,
	0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x03, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x48, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x22, 0xab, 0x06,
	0x0a, 0x18, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x6e, 0x73, 0x5a,
	0x6f, 0x6e, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x44, 0x6e, 0x73, 0x5a, 0x6f, 0x6e, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x48, 0x00, 0x52, 0x0a,
	0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x6a, 0x0a, 0x15, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x48,
	0x00, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x22, 0x60, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x3a,
	0xb9, 0x01, 0xea, 0x41, 0xb5, 0x01, 0x0a, 0x34, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x6e,
	0x73, 0x5a, 0x6f, 0x6e, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x7d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x6e,
	0x73, 0x5a, 0x6f, 0x6e, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x7a, 0x6f,
	0x6e, 0x65, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x42, 0x0e, 0x0a, 0x0c, 0x62,
	0x69, 0x6e, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x9f, 0x08, 0x0a, 0x13,
	0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0c, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56, 0x70, 0x63, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x76, 0x70, 0x63,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x1a, 0xf6, 0x01, 0x0a, 0x0a, 0x56, 0x70, 0x63,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x52, 0x41, 0x4e, 0x45, 0x54, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12,
	0x10, 0x0a, 0x0c, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x10,
	0x03, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x02, 0x3a,
	0x8b, 0x01, 0xea, 0x41, 0x87, 0x01, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x22, 0xdd, 0x0b,
	0x0a, 0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x63, 0x0a, 0x0c, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x4f, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x66, 0x0a, 0x0d, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x73,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x06, 0x22, 0x80, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x4e, 0x45, 0x54, 0x41, 0x50, 0x50, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x56,
	0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x53, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x4c,
	0x5f, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x17, 0x0a,
	0x13, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x10, 0x04, 0x22, 0x45, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x57, 0x0a,
	0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x19, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x2d, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xb8, 0x01,
	0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x62, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x40, 0x0a, 0x0a, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x52, 0x45, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x43, 0x4c,
	0x55, 0x53, 0x54, 0x45, 0x52, 0x53, 0x10, 0x01, 0x22, 0xe9, 0x01, 0x0a, 0x11, 0x44, 0x6e, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x73, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x2d, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x6e, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x12, 0x14, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x42,
	0xe6, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescOnce sync.Once
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData = file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc
)

func file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData)
	})
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData
}

var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 30)
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes = []any{
	(PrivateCloud_State)(0),                       // 0: google.cloud.vmwareengine.v1.PrivateCloud.State
	(PrivateCloud_Type)(0),                        // 1: google.cloud.vmwareengine.v1.PrivateCloud.Type
	(Cluster_State)(0),                            // 2: google.cloud.vmwareengine.v1.Cluster.State
	(Node_State)(0),                               // 3: google.cloud.vmwareengine.v1.Node.State
	(ExternalAddress_State)(0),                    // 4: google.cloud.vmwareengine.v1.ExternalAddress.State
	(Subnet_State)(0),                             // 5: google.cloud.vmwareengine.v1.Subnet.State
	(ExternalAccessRule_Action)(0),                // 6: google.cloud.vmwareengine.v1.ExternalAccessRule.Action
	(ExternalAccessRule_State)(0),                 // 7: google.cloud.vmwareengine.v1.ExternalAccessRule.State
	(LoggingServer_Protocol)(0),                   // 8: google.cloud.vmwareengine.v1.LoggingServer.Protocol
	(LoggingServer_SourceType)(0),                 // 9: google.cloud.vmwareengine.v1.LoggingServer.SourceType
	(NodeType_Kind)(0),                            // 10: google.cloud.vmwareengine.v1.NodeType.Kind
	(NodeType_Capability)(0),                      // 11: google.cloud.vmwareengine.v1.NodeType.Capability
	(HcxActivationKey_State)(0),                   // 12: google.cloud.vmwareengine.v1.HcxActivationKey.State
	(Hcx_State)(0),                                // 13: google.cloud.vmwareengine.v1.Hcx.State
	(Nsx_State)(0),                                // 14: google.cloud.vmwareengine.v1.Nsx.State
	(Vcenter_State)(0),                            // 15: google.cloud.vmwareengine.v1.Vcenter.State
	(NetworkPeering_State)(0),                     // 16: google.cloud.vmwareengine.v1.NetworkPeering.State
	(NetworkPeering_PeerNetworkType)(0),           // 17: google.cloud.vmwareengine.v1.NetworkPeering.PeerNetworkType
	(PeeringRoute_Type)(0),                        // 18: google.cloud.vmwareengine.v1.PeeringRoute.Type
	(PeeringRoute_Direction)(0),                   // 19: google.cloud.vmwareengine.v1.PeeringRoute.Direction
	(NetworkPolicy_NetworkService_State)(0),       // 20: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	(ManagementDnsZoneBinding_State)(0),           // 21: google.cloud.vmwareengine.v1.ManagementDnsZoneBinding.State
	(VmwareEngineNetwork_State)(0),                // 22: google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	(VmwareEngineNetwork_Type)(0),                 // 23: google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	(VmwareEngineNetwork_VpcNetwork_Type)(0),      // 24: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	(PrivateConnection_State)(0),                  // 25: google.cloud.vmwareengine.v1.PrivateConnection.State
	(PrivateConnection_Type)(0),                   // 26: google.cloud.vmwareengine.v1.PrivateConnection.Type
	(PrivateConnection_RoutingMode)(0),            // 27: google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode
	(PrivateConnection_PeeringState)(0),           // 28: google.cloud.vmwareengine.v1.PrivateConnection.PeeringState
	(LocationMetadata_Capability)(0),              // 29: google.cloud.vmwareengine.v1.LocationMetadata.Capability
	(*NetworkConfig)(nil),                         // 30: google.cloud.vmwareengine.v1.NetworkConfig
	(*NodeTypeConfig)(nil),                        // 31: google.cloud.vmwareengine.v1.NodeTypeConfig
	(*StretchedClusterConfig)(nil),                // 32: google.cloud.vmwareengine.v1.StretchedClusterConfig
	(*PrivateCloud)(nil),                          // 33: google.cloud.vmwareengine.v1.PrivateCloud
	(*Cluster)(nil),                               // 34: google.cloud.vmwareengine.v1.Cluster
	(*Node)(nil),                                  // 35: google.cloud.vmwareengine.v1.Node
	(*ExternalAddress)(nil),                       // 36: google.cloud.vmwareengine.v1.ExternalAddress
	(*Subnet)(nil),                                // 37: google.cloud.vmwareengine.v1.Subnet
	(*ExternalAccessRule)(nil),                    // 38: google.cloud.vmwareengine.v1.ExternalAccessRule
	(*LoggingServer)(nil),                         // 39: google.cloud.vmwareengine.v1.LoggingServer
	(*NodeType)(nil),                              // 40: google.cloud.vmwareengine.v1.NodeType
	(*Credentials)(nil),                           // 41: google.cloud.vmwareengine.v1.Credentials
	(*HcxActivationKey)(nil),                      // 42: google.cloud.vmwareengine.v1.HcxActivationKey
	(*Hcx)(nil),                                   // 43: google.cloud.vmwareengine.v1.Hcx
	(*Nsx)(nil),                                   // 44: google.cloud.vmwareengine.v1.Nsx
	(*Vcenter)(nil),                               // 45: google.cloud.vmwareengine.v1.Vcenter
	(*AutoscalingSettings)(nil),                   // 46: google.cloud.vmwareengine.v1.AutoscalingSettings
	(*DnsForwarding)(nil),                         // 47: google.cloud.vmwareengine.v1.DnsForwarding
	(*NetworkPeering)(nil),                        // 48: google.cloud.vmwareengine.v1.NetworkPeering
	(*PeeringRoute)(nil),                          // 49: google.cloud.vmwareengine.v1.PeeringRoute
	(*NetworkPolicy)(nil),                         // 50: google.cloud.vmwareengine.v1.NetworkPolicy
	(*ManagementDnsZoneBinding)(nil),              // 51: google.cloud.vmwareengine.v1.ManagementDnsZoneBinding
	(*VmwareEngineNetwork)(nil),                   // 52: google.cloud.vmwareengine.v1.VmwareEngineNetwork
	(*PrivateConnection)(nil),                     // 53: google.cloud.vmwareengine.v1.PrivateConnection
	(*LocationMetadata)(nil),                      // 54: google.cloud.vmwareengine.v1.LocationMetadata
	(*DnsBindPermission)(nil),                     // 55: google.cloud.vmwareengine.v1.DnsBindPermission
	(*Principal)(nil),                             // 56: google.cloud.vmwareengine.v1.Principal
	(*PrivateCloud_ManagementCluster)(nil),        // 57: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	nil,                                           // 58: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	nil,                                           // 59: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	(*ExternalAccessRule_IpRange)(nil),            // 60: google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange
	(*AutoscalingSettings_Thresholds)(nil),        // 61: google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds
	(*AutoscalingSettings_AutoscalingPolicy)(nil), // 62: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy
	nil,                                    // 63: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPoliciesEntry
	(*DnsForwarding_ForwardingRule)(nil),   // 64: google.cloud.vmwareengine.v1.DnsForwarding.ForwardingRule
	(*NetworkPolicy_NetworkService)(nil),   // 65: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	(*VmwareEngineNetwork_VpcNetwork)(nil), // 66: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	(*timestamppb.Timestamp)(nil),          // 67: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),            // 68: google.protobuf.Duration
}
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs = []int32{
	67, // 0: google.cloud.vmwareengine.v1.PrivateCloud.create_time:type_name -> google.protobuf.Timestamp
	67, // 1: google.cloud.vmwareengine.v1.PrivateCloud.update_time:type_name -> google.protobuf.Timestamp
	67, // 2: google.cloud.vmwareengine.v1.PrivateCloud.delete_time:type_name -> google.protobuf.Timestamp
	67, // 3: google.cloud.vmwareengine.v1.PrivateCloud.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.vmwareengine.v1.PrivateCloud.state:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.State
	30, // 5: google.cloud.vmwareengine.v1.PrivateCloud.network_config:type_name -> google.cloud.vmwareengine.v1.NetworkConfig
	57, // 6: google.cloud.vmwareengine.v1.PrivateCloud.management_cluster:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	43, // 7: google.cloud.vmwareengine.v1.PrivateCloud.hcx:type_name -> google.cloud.vmwareengine.v1.Hcx
	44, // 8: google.cloud.vmwareengine.v1.PrivateCloud.nsx:type_name -> google.cloud.vmwareengine.v1.Nsx
	45, // 9: google.cloud.vmwareengine.v1.PrivateCloud.vcenter:type_name -> google.cloud.vmwareengine.v1.Vcenter
	1,  // 10: google.cloud.vmwareengine.v1.PrivateCloud.type:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.Type
	67, // 11: google.cloud.vmwareengine.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	67, // 12: google.cloud.vmwareengine.v1.Cluster.update_time:type_name -> google.protobuf.Timestamp
	2,  // 13: google.cloud.vmwareengine.v1.Cluster.state:type_name -> google.cloud.vmwareengine.v1.Cluster.State
	46, // 14: google.cloud.vmwareengine.v1.Cluster.autoscaling_settings:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings
	59, // 15: google.cloud.vmwareengine.v1.Cluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	32, // 16: google.cloud.vmwareengine.v1.Cluster.stretched_cluster_config:type_name -> google.cloud.vmwareengine.v1.StretchedClusterConfig
	3,  // 17: google.cloud.vmwareengine.v1.Node.state:type_name -> google.cloud.vmwareengine.v1.Node.State
	67, // 18: google.cloud.vmwareengine.v1.ExternalAddress.create_time:type_name -> google.protobuf.Timestamp
	67, // 19: google.cloud.vmwareengine.v1.ExternalAddress.update_time:type_name -> google.protobuf.Timestamp
	4,  // 20: google.cloud.vmwareengine.v1.ExternalAddress.state:type_name -> google.cloud.vmwareengine.v1.ExternalAddress.State
	5,  // 21: google.cloud.vmwareengine.v1.Subnet.state:type_name -> google.cloud.vmwareengine.v1.Subnet.State
	67, // 22: google.cloud.vmwareengine.v1.ExternalAccessRule.create_time:type_name -> google.protobuf.Timestamp
	67, // 23: google.cloud.vmwareengine.v1.ExternalAccessRule.update_time:type_name -> google.protobuf.Timestamp
	6,  // 24: google.cloud.vmwareengine.v1.ExternalAccessRule.action:type_name -> google.cloud.vmwareengine.v1.ExternalAccessRule.Action
	60, // 25: google.cloud.vmwareengine.v1.ExternalAccessRule.source_ip_ranges:type_name -> google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange
	60, // 26: google.cloud.vmwareengine.v1.ExternalAccessRule.destination_ip_ranges:type_name -> google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange
	7,  // 27: google.cloud.vmwareengine.v1.ExternalAccessRule.state:type_name -> google.cloud.vmwareengine.v1.ExternalAccessRule.State
	67, // 28: google.cloud.vmwareengine.v1.LoggingServer.create_time:type_name -> google.protobuf.Timestamp
	67, // 29: google.cloud.vmwareengine.v1.LoggingServer.update_time:type_name -> google.protobuf.Timestamp
	8,  // 30: google.cloud.vmwareengine.v1.LoggingServer.protocol:type_name -> google.cloud.vmwareengine.v1.LoggingServer.Protocol
	9,  // 31: google.cloud.vmwareengine.v1.LoggingServer.source_type:type_name -> google.cloud.vmwareengine.v1.LoggingServer.SourceType
	10, // 32: google.cloud.vmwareengine.v1.NodeType.kind:type_name -> google.cloud.vmwareengine.v1.NodeType.Kind
	11, // 33: google.cloud.vmwareengine.v1.NodeType.capabilities:type_name -> google.cloud.vmwareengine.v1.NodeType.Capability
	67, // 34: google.cloud.vmwareengine.v1.HcxActivationKey.create_time:type_name -> google.protobuf.Timestamp
	12, // 35: google.cloud.vmwareengine.v1.HcxActivationKey.state:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey.State
	13, // 36: google.cloud.vmwareengine.v1.Hcx.state:type_name -> google.cloud.vmwareengine.v1.Hcx.State
	14, // 37: google.cloud.vmwareengine.v1.Nsx.state:type_name -> google.cloud.vmwareengine.v1.Nsx.State
	15, // 38: google.cloud.vmwareengine.v1.Vcenter.state:type_name -> google.cloud.vmwareengine.v1.Vcenter.State
	63, // 39: google.cloud.vmwareengine.v1.AutoscalingSettings.autoscaling_policies:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPoliciesEntry
	68, // 40: google.cloud.vmwareengine.v1.AutoscalingSettings.cool_down_period:type_name -> google.protobuf.Duration
	67, // 41: google.cloud.vmwareengine.v1.DnsForwarding.create_time:type_name -> google.protobuf.Timestamp
	67, // 42: google.cloud.vmwareengine.v1.DnsForwarding.update_time:type_name -> google.protobuf.Timestamp
	64, // 43: google.cloud.vmwareengine.v1.DnsForwarding.forwarding_rules:type_name -> google.cloud.vmwareengine.v1.DnsForwarding.ForwardingRule
	67, // 44: google.cloud.vmwareengine.v1.NetworkPeering.create_time:type_name -> google.protobuf.Timestamp
	67, // 45: google.cloud.vmwareengine.v1.NetworkPeering.update_time:type_name -> google.protobuf.Timestamp
	16, // 46: google.cloud.vmwareengine.v1.NetworkPeering.state:type_name -> google.cloud.vmwareengine.v1.NetworkPeering.State
	17, // 47: google.cloud.vmwareengine.v1.NetworkPeering.peer_network_type:type_name -> google.cloud.vmwareengine.v1.NetworkPeering.PeerNetworkType
	18, // 48: google.cloud.vmwareengine.v1.PeeringRoute.type:type_name -> google.cloud.vmwareengine.v1.PeeringRoute.Type
	19, // 49: google.cloud.vmwareengine.v1.PeeringRoute.direction:type_name -> google.cloud.vmwareengine.v1.PeeringRoute.Direction
	67, // 50: google.cloud.vmwareengine.v1.NetworkPolicy.create_time:type_name -> google.protobuf.Timestamp
	67, // 51: google.cloud.vmwareengine.v1.NetworkPolicy.update_time:type_name -> google.protobuf.Timestamp
	65, // 52: google.cloud.vmwareengine.v1.NetworkPolicy.internet_access:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	65, // 53: google.cloud.vmwareengine.v1.NetworkPolicy.external_ip:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	67, // 54: google.cloud.vmwareengine.v1.ManagementDnsZoneBinding.create_time:type_name -> google.protobuf.Timestamp
	67, // 55: google.cloud.vmwareengine.v1.ManagementDnsZoneBinding.update_time:type_name -> google.protobuf.Timestamp
	21, // 56: google.cloud.vmwareengine.v1.ManagementDnsZoneBinding.state:type_name -> google.cloud.vmwareengine.v1.ManagementDnsZoneBinding.State
	67, // 57: google.cloud.vmwareengine.v1.VmwareEngineNetwork.create_time:type_name -> google.protobuf.Timestamp
	67, // 58: google.cloud.vmwareengine.v1.VmwareEngineNetwork.update_time:type_name -> google.protobuf.Timestamp
	66, // 59: google.cloud.vmwareengine.v1.VmwareEngineNetwork.vpc_networks:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	22, // 60: google.cloud.vmwareengine.v1.VmwareEngineNetwork.state:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	23, // 61: google.cloud.vmwareengine.v1.VmwareEngineNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	67, // 62: google.cloud.vmwareengine.v1.PrivateConnection.create_time:type_name -> google.protobuf.Timestamp
	67, // 63: google.cloud.vmwareengine.v1.PrivateConnection.update_time:type_name -> google.protobuf.Timestamp
	25, // 64: google.cloud.vmwareengine.v1.PrivateConnection.state:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.State
	26, // 65: google.cloud.vmwareengine.v1.PrivateConnection.type:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.Type
	27, // 66: google.cloud.vmwareengine.v1.PrivateConnection.routing_mode:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode
	28, // 67: google.cloud.vmwareengine.v1.PrivateConnection.peering_state:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.PeeringState
	29, // 68: google.cloud.vmwareengine.v1.LocationMetadata.capabilities:type_name -> google.cloud.vmwareengine.v1.LocationMetadata.Capability
	56, // 69: google.cloud.vmwareengine.v1.DnsBindPermission.principals:type_name -> google.cloud.vmwareengine.v1.Principal
	58, // 70: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	32, // 71: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.stretched_cluster_config:type_name -> google.cloud.vmwareengine.v1.StretchedClusterConfig
	31, // 72: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	31, // 73: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	61, // 74: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy.cpu_thresholds:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds
	61, // 75: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy.granted_memory_thresholds:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds
	61, // 76: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy.consumed_memory_thresholds:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds
	61, // 77: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy.storage_thresholds:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.Thresholds
	62, // 78: google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPoliciesEntry.value:type_name -> google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy
	20, // 79: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.state:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	24, // 80: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	81, // [81:81] is the sub-list for method output_type
	81, // [81:81] is the sub-list for method input_type
	81, // [81:81] is the sub-list for extension type_name
	81, // [81:81] is the sub-list for extension extendee
	0,  // [0:81] is the sub-list for field type_name
}

func init() { file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_init() }
func file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_init() {
	if File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto != nil {
		return
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[21].OneofWrappers = []any{
		(*ManagementDnsZoneBinding_VpcNetwork)(nil),
		(*ManagementDnsZoneBinding_VmwareEngineNetwork)(nil),
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[26].OneofWrappers = []any{
		(*Principal_User)(nil),
		(*Principal_ServiceAccount)(nil),
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[30].OneofWrappers = []any{
		(*ExternalAccessRule_IpRange_IpAddress)(nil),
		(*ExternalAccessRule_IpRange_IpAddressRange)(nil),
		(*ExternalAccessRule_IpRange_ExternalAddress)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc,
			NumEnums:      30,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto = out.File
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs = nil
}
