/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;

class NodeStateMerger {
    NodeStateMerger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean merge(NodeState state, MergeContext context) {
        NodeState overlayedState = (NodeState)state.getOverlayedState();
        if (overlayedState == null || state.getModCount() == overlayedState.getModCount()) {
            return false;
        }
        NodeState nodeState = overlayedState;
        synchronized (nodeState) {
            NodeState nodeState2 = state;
            synchronized (nodeState2) {
                Iterator iter;
                AbstractCollection removed;
                AbstractCollection added;
                if (!state.getReorderedChildNodeEntries().isEmpty()) {
                    return false;
                }
                if (!((Object)state.getMixinTypeNames()).equals(overlayedState.getMixinTypeNames())) {
                    return false;
                }
                if (state.getParentId() != null && !state.getParentId().equals(overlayedState.getParentId())) {
                    return false;
                }
                if (!((Object)state.getChildNodeEntries()).equals(overlayedState.getChildNodeEntries())) {
                    ChildNodeEntry cne;
                    added = new ArrayList();
                    removed = new ArrayList();
                    iter = state.getAddedChildNodeEntries().iterator();
                    while (iter.hasNext()) {
                        cne = (ChildNodeEntry)iter.next();
                        if (!context.isAdded(cne.getId())) continue;
                        if (overlayedState.hasChildNodeEntry(cne.getName()) && cne.getIndex() < 2 && !context.allowsSameNameSiblings(cne.getId())) {
                            return false;
                        }
                        ((ArrayList)added).add(cne);
                    }
                    iter = state.getRemovedChildNodeEntries().iterator();
                    while (iter.hasNext()) {
                        cne = (ChildNodeEntry)iter.next();
                        if (!context.isDeleted(cne.getId())) continue;
                        ((ArrayList)removed).add(cne);
                    }
                    state.setChildNodeEntries(overlayedState.getChildNodeEntries());
                    iter = ((ArrayList)added).iterator();
                    while (iter.hasNext()) {
                        cne = (ChildNodeEntry)iter.next();
                        state.addChildNodeEntry(cne.getName(), cne.getId());
                    }
                    iter = ((ArrayList)removed).iterator();
                    while (iter.hasNext()) {
                        cne = (ChildNodeEntry)iter.next();
                        state.removeChildNodeEntry(cne.getId());
                    }
                }
                if (!((Object)state.getPropertyNames()).equals(overlayedState.getPropertyNames())) {
                    PropertyId propId;
                    Name name;
                    added = new HashSet();
                    removed = new HashSet();
                    iter = state.getAddedPropertyNames().iterator();
                    while (iter.hasNext()) {
                        name = (Name)iter.next();
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isAdded(propId)) continue;
                        if (overlayedState.hasPropertyName(name) || overlayedState.hasChildNodeEntry(name)) {
                            return false;
                        }
                        ((HashSet)added).add(name);
                    }
                    iter = state.getRemovedPropertyNames().iterator();
                    while (iter.hasNext()) {
                        name = (Name)iter.next();
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isDeleted(propId)) continue;
                        ((HashSet)removed).add(name);
                    }
                    state.setPropertyNames(overlayedState.getPropertyNames());
                    iter = ((HashSet)added).iterator();
                    while (iter.hasNext()) {
                        name = (Name)iter.next();
                        state.addPropertyName(name);
                    }
                    iter = ((HashSet)removed).iterator();
                    while (iter.hasNext()) {
                        name = (Name)iter.next();
                        state.removePropertyName(name);
                    }
                }
                state.setModCount(overlayedState.getModCount());
                return true;
            }
        }
    }

    static interface MergeContext {
        public boolean isAdded(ItemId var1);

        public boolean isDeleted(ItemId var1);

        public boolean allowsSameNameSiblings(NodeId var1);
    }
}

