/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BaseNonStreamValue;
import org.apache.jackrabbit.rmi.value.BooleanValue;
import org.apache.jackrabbit.rmi.value.DoubleValue;
import org.apache.jackrabbit.rmi.value.ISO8601;
import org.apache.jackrabbit.rmi.value.LongValue;
import org.apache.jackrabbit.rmi.value.StatefulValue;

public class StringValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -6456025645604163205L;
    private final String value;

    protected StringValue(String value) {
        this.value = value;
    }

    public int getType() {
        return 1;
    }

    public String getString() {
        return this.value;
    }

    public long getLong() throws ValueFormatException {
        return LongValue.toLong(this.value);
    }

    public double getDouble() throws ValueFormatException {
        return DoubleValue.toDouble(this.value);
    }

    public Calendar getDate() throws ValueFormatException {
        return ISO8601.parse(this.value);
    }

    public boolean getBoolean() {
        return BooleanValue.toBoolean(this.value);
    }
}

