/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.lock.AbstractLockEntry;
import org.apache.jackrabbit.webdav.lock.LockEntry;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedLock
extends AbstractDavProperty {
    private final ArrayList entries = new ArrayList();

    public SupportedLock() {
        super(DavPropertyName.SUPPORTEDLOCK, false);
    }

    public void addEntry(Type type, Scope scope) {
        this.entries.add(new WriteLockEntry(type, scope));
    }

    public void addEntry(LockEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("The lock entry cannot be null.");
        }
        this.entries.add(entry);
    }

    public boolean isSupportedLock(Type type, Scope scope) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            LockEntry le = (LockEntry)it.next();
            if (!le.getType().equals(type) || !le.getScope().equals(scope)) continue;
            return true;
        }
        return false;
    }

    public Iterator getSupportedLocks() {
        return this.entries.iterator();
    }

    public Element toXml(Document document) {
        Element support = this.getName().toXml(document);
        Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            LockEntry le = (LockEntry)iter.next();
            support.appendChild(le.toXml(document));
        }
        return support;
    }

    public Object getValue() {
        return this.entries;
    }

    private static final class WriteLockEntry
    extends AbstractLockEntry {
        private final Scope scope;

        WriteLockEntry(Type type, Scope scope) {
            if (!Type.WRITE.equals(type)) {
                throw new IllegalArgumentException("Invalid Type:" + type);
            }
            if (!Scope.EXCLUSIVE.equals(scope) && !Scope.SHARED.equals(scope)) {
                throw new IllegalArgumentException("Invalid scope:" + scope);
            }
            this.scope = scope;
        }

        public Type getType() {
            return Type.WRITE;
        }

        public Scope getScope() {
            return this.scope;
        }
    }
}

