/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import io.netty.util.internal.logging.InternalLogger;
import java.io.File;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.os.JavaHome;

public class PosixJavaHome
implements JavaHome {
    Configuration _config;
    InternalLogger _logger;
    int _debug = 3;

    public PosixJavaHome(Configuration config) {
        this._config = config != null ? config : new BaseConfiguration();
    }

    @Override
    public String findJava(String wrapperJava, String customProcessName) {
        File customProc = null;
        File wrapJava = null;
        if (wrapperJava == null && customProcessName == null) {
            return this.findJava();
        }
        customProc = customProcessName != null ? new File(customProcessName) : null;
        File file = wrapJava = wrapperJava != null ? new File(wrapperJava) : null;
        if (customProc != null && customProc.exists() && customProc.canExecute()) {
            return customProcessName;
        }
        if (wrapJava != null && wrapJava.exists() && wrapJava.canExecute()) {
            return wrapperJava;
        }
        return this.findJava();
    }

    private String findJava() {
        File fJavaTmp;
        String home;
        String javaName;
        File fJava = null;
        String java = null;
        String[] javaFiles = new String[]{this._config.getString("wrapper.java.command"), this._config.getString("wrapper.ntservice.java.command"), "java"};
        block0: for (int idx = 0; fJava == null && idx < javaFiles.length; ++idx) {
            for (int loop = 0; loop < 2; ++loop) {
                File fJavaTmp2;
                if (javaFiles[idx] == null || !(fJavaTmp2 = new File(javaName = loop == 0 ? javaFiles[idx] : System.getProperty("JAVA_HOME", "") + File.separator + "bin" + File.separator + javaFiles[idx])).exists() || !fJavaTmp2.canExecute()) continue;
                fJava = fJavaTmp2;
                continue block0;
            }
        }
        if (fJava == null && (home = this.findJavaHomeFromPath(null)) != null && (fJavaTmp = new File(javaName = home + File.separator + "bin" + File.separator + "java")).exists() && fJavaTmp.canExecute()) {
            fJava = fJavaTmp;
        }
        if (fJava != null) {
            java = fJava.getAbsolutePath();
            this._config.setProperty("wrapper.java.command", (Object)java);
            this._config.setProperty("wrapper.ntservice.java.command", (Object)java);
        }
        if (java == null) {
            java = this._config.getString("wrapper.java.command", "java");
        }
        return java;
    }

    private String findJavaHomeFromPath(String javaHome) {
        String[] paths;
        File fJavaHome;
        if (javaHome != null && (fJavaHome = new File(javaHome)).exists()) {
            return javaHome;
        }
        if (System.getenv("path") == null) {
            return null;
        }
        for (String path : paths = System.getenv("path").split(File.pathSeparator)) {
            File fJavaHome2;
            if (!path.contains("jdk") && !path.contains("jre") || !(fJavaHome2 = new File(path + File.separator + "java")).exists()) continue;
            return fJavaHome2.getParentFile().getParentFile().getAbsolutePath();
        }
        return null;
    }

    @Override
    public void setLogger(InternalLogger logger, int debug) {
        this._logger = logger;
        this._debug = debug;
    }
}

