/*
 * PIextcall.c - ProIcon version of extcall.c.
 *
 * This interface provides two types of calls, both accessible from callout():
 *  1.  Calls to XCMDs and XFCNs.
 *  2.  Calls to arbitrary code resources.
 *
 * XCMD/XFCN calls provide a string-based interface via the package "CallXCmd"
 * by Cybersoft.  It is identified by invoking callout with one argument.
 *
 * Code resource calls provide a descriptor-based interface, and are recognized by
 * the presence of at least two arguments to callout, callout("type", ID, ...) or
 * callout("type", "resource name", ...) where:
 *  "type" is a Macintosh 4-character resource type code
 *  ID is an integer used to select a resource by number.
 *  "resource name" is used to select a resource by name.
 *  ... are additional arguments whose dptrs are pushed on the stack
 */

#include "::h:config.h"
#include "::h:rt.h"
#include "rproto.h"
#include "tproto.h"

#ifdef ExternalFunctions
#include "XCmdStorLC.h"

static XCmdRecPtr pxRec = NULL;		/* instance record used by CallXCmd	*/
static int initxcmd Params((noargs));
static dptr xcmdcall(dptr dargv, int argc, int *ip);
static dptr crcall(dptr dargv, int argc, int *ip);
static void *(*fnctab[])() = {
	(void *)alcactiv,
	(void *)alcbignum,
	(void *)alccoexp,
	(void *)alccset,
	(void *)alcextrnl,
	(void *)alcfile,
	(void *)alchash,
	(void *)alclist,
	(void *)alclstb,
	(void *)alcreal,
	(void *)alcrecd,
	(void *)alcrefresh,
	(void *)alcsegment,
	(void *)alcselem,
	(void *)alcstr,
	(void *)alcsubs,
	(void *)alctelem,
	(void *)alctvtbl,
	(void *)blkreq,
	(void *)cvint,
	(void *)cvreal,
	(void *)cvstr,
	(void *)&emptystr,
	(void *)makereal,
	(void *)&nulldesc,
	(void *)&onedesc,
	(void *)qtos,
	(void *)strreq,
	(void *)&zerodesc
	};

/*
 * extcall - procedure for external call interface.
 *
 * Used to call XCMD/XFNCs or pure code resources.
 *
 * Possible returns:
 *   Success: Leave *ip unaltered, return descriptor pointer.
 *   Failure: Leave *ip unaltered, return NULL.
 *   Error:   Set *ip to error code >= 0.  Return descriptor pointer or NULL
 *            to have value displayed or not displayed in error message.
 */
dptr extcall(dargv, argc, ip)
dptr dargv;				/* pointer to list of argument descriptors */
int argc;				/* number of arguments */
int *ip;				/* pointer to error signal */
   {
   char sbuf[MaxCvtLen];
   int i;
   
   if (!argc) {				/* no arguments is illegal */
      *ip = 216;			/* no external function to find */
      return (dptr)NULL;
      }

   /* Make first argument into a string */
   if ((i = cvstr(&dargv[0], sbuf)) != Cvt && i != NoCvt) {
         *ip = 103;			/* string expected for first argument */
         return &dargv[0];
      }

   if (argc == 1)			/* one argument is an XCMD/XFCN call */
      return xcmdcall(dargv, argc, ip);
   else
      return crcall(dargv, argc, ip);	/* two or more args is a code resource call */
   }



/*
 * crcall - code resource call
 *
 * First argument is a string providing the 4-character resource type,
 * e.g.,  "CODE", "TEST", etc.
 *
 * Second argument is either an integer or a string.  If an integer, it
 * is the resource ID to be used when searching for the code.  If a
 * string, the code is looked up as a named resource.
 */
static dptr crcall(dargv, argc, ip)
dptr dargv;
int argc;
int *ip;
   {
   char sbuf[MaxCvtLen+1];
   ResType type;
   int id;
   dptr (**hcode)();
   dptr result;

   /* obtain 4-character resource type */
   type = *((ResType *)StrLoc(dargv[0]));
      
   /* obtain resource ID or name */
   if (cvnum(&dargv[1]) == T_Integer) {
      id = IntVal(dargv[1]);
      hcode = (dptr (**)())GetResource(type, id);	/* get resource by number */
      }
   else {
      switch (cvstr(&dargv[1], &sbuf[1])) {
         case Cvt:
            break;
         case NoCvt:
            memcopy(&sbuf[1], StrLoc(dargv[1]),
              StrLen(dargv[1]) > MaxCvtLen ? MaxCvtLen : StrLen(dargv[1]));
            break;
         default:
            *ip = 103;		/* string expected as second argument */
            return &dargv[1];
         }
      sbuf[0] = StrLen(dargv[1]);
      hcode = (dptr (**)())GetNamedResource(type, (StringPtr)sbuf); /* get resource by name */
      }

   if (hcode == NULL) {
      *ip = 216;			/* external function's resource not found */
      return (dptr)NULL;
      }
   
   /* Move resource up in memory, lock it, and initiate call */
   MoveHHi((Handle)hcode);
   HLock((Handle)hcode);
   result = ((dptr (*)())StripAddress((long)*hcode))(dargv, argc, ip, fnctab);
   HUnlock((Handle)hcode);

   return result;
   }


/*
 * xcmdcall - procedure for XCMD/XFNC call interface.
 *
 * Argument is a string of the form "XCMDname arguments"
 * e.g.,  "MoveFile \"Drive:Path:File\",\"Drive:NewPath\""
 *
 * or "XFCNname (arguments)", e.g., "FileName (\"Text\")"
 *
 */
static dptr xcmdcall(dargv, argc, ip)
dptr dargv;
int argc;
int *ip;
   {
   uword slen;

   if (initxcmd()) {			/* make sure call logic is loaded */
      *ip = 351;			/* insufficient memory */
      return (dptr)NULL;
      }
   pxRec->commandText.text = StrLoc(dargv[0]);
   pxRec->commandText.length = StrLen(dargv[0]);
   CallXCmd(pxRec, Do_XCmd);
   if (!pxRec->ErrVal) {
      slen = lstrlen(*(pxRec->returnValue));
      if (!slen) {
         return &emptystr;
         }
      if (strreq(slen) == Error) {
         runerr(0, (dptr)NULL);
         return (dptr)NULL;		/* signal failure */
         }
      StrLen(dargv[0]) = slen;
      StrLoc(dargv[0]) = alcstr(NULL, slen);
      memcopy(StrLoc(dargv[0]), *(pxRec->returnValue), slen);
      return &dargv[0];
      }
   else {
      *ip = 352;
      return &dargv[0];
      }
   }
   

/*
 * endxcmd - deallocate a CallXCMD record if it exists.
 */
novalue endxcmd()
{
   if (pxRec != NULL) {
      CallXCmd(pxRec, Free_XCmd);
      free(pxRec);
      pxRec = NULL;
      }
}


/*
 * initxcmd - allocate and initialize a CallXCMD record if needed.
 *
 * returns non-zero if error initializing.
 */
static int initxcmd()
{
   if (pxRec == NULL) {
      if ((pxRec = (XCmdRecPtr)malloc(sizeof(XCmdRec))) == NULL)
         return 1;
      CallXCmd(pxRec, Init_XCmd);
      return pxRec->ErrVal;
      }
   return 0;
}


#else					/* ExternalFunctions */
static char x;			/* prevent empty module */
#endif 					/* ExternalFunctions */
