#
# makefile for constructing ivib
#

ICONDIR=icon

LIBFILES=../lib/qsort.u \
      ../lib/gui.u \
      ../lib/encode.u \
      ../lib/file_dialog.u

UFILES=cdialog.u \
      common_dialog.u \
      grid.u \
      canvascomps.u \
      ivib.u \
      groups.u \
      canvas.u \
      images.u \
      utils.u \
      code.u 

ICONS=$(ICONDIR)/icn1.icon \
      $(ICONDIR)/icn2.icon \
      $(ICONDIR)/icn3.icon \
      $(ICONDIR)/icn4.icon \
      $(ICONDIR)/icn5.icon \
      $(ICONDIR)/icn6.icon \
      $(ICONDIR)/icn7.icon \
      $(ICONDIR)/icn8.icon \
      $(ICONDIR)/icn9.icon \
      $(ICONDIR)/icn10.icon \
      $(ICONDIR)/icn11.icon \
      $(ICONDIR)/icn12.icon \
      $(ICONDIR)/icn13.icon \
      $(ICONDIR)/icn14.icon \
      $(ICONDIR)/icn15.icon \
      $(ICONDIR)/icn16.icon \
      $(ICONDIR)/icn17.icon \
      $(ICONDIR)/icn18.icon \
      $(ICONDIR)/icn19.icon \
      $(ICONDIR)/icn20.icon \
      $(ICONDIR)/icn21.icon \
      $(ICONDIR)/icn22.icon \
      $(ICONDIR)/icn23.icon \
      $(ICONDIR)/icn24.icon \
      $(ICONDIR)/icn25.icon \
      $(ICONDIR)/icn26.icon \
      $(ICONDIR)/icn27.icon \
      $(ICONDIR)/icn28.icon \
      $(ICONDIR)/icn29.icon \
      $(ICONDIR)/icn30.icon \
      $(ICONDIR)/icn31.icon \
      $(ICONDIR)/icn32.icon \
      $(ICONDIR)/icon.icon

#
# Rule for making the object file
#
#
# Linking
#
ivib: ivib2 $(UFILES)
	$(UNICON) -o ivib $(UFILES) $(LIBFILES)
	$(COPY) ivib$(EXE) $(BINDIR)
	@echo Linking complete.

ivib2:
	cd ../lib; make

#
# Program to translate xpm to Icon image format.
#
# uncomment these if you modify the .xpm images
#
#$(ICONDIR)/xpmtoims: $(ICONDIR)/xpmtoims.icn
#	cd $(ICONDIR) && \
#	icont xpmtoims.icn

#
# Rule to translate xpm to icon image format.
#
#$(ICONDIR)/%.icon: $(ICONDIR)/%.xpm
#	$(ICONDIR)/xpmtoims $< >$@

#
# Class and include dependencies
#

cdialog.u : cdialog.icn ../lib/gui.u ../lib/encode.u
	$(UNICON) -c cdialog
common_dialog.u : common_dialog.icn ../lib/gui.u
	$(UNICON) -c common_dialog
grid.u : grid.icn ../lib/qsort.u
	$(UNICON) -c grid
canvascomps.u : canvascomps.icn ../lib/gui.u ../lib/encode.u common_dialog.icn
	$(UNICON) -c canvascomps
ivib.u : ivib.icn ../lib/gui.u version.icn
	$(UNICON) -c ivib
groups.u : groups.icn ../lib/gui.u ../lib/encode.u common_dialog.icn
	$(UNICON) -c groups
canvas.u : canvas.icn ../lib/gui.u ../lib/encode.u ../lib/keysyms.icn grid.icn common_dialog.icn
	$(UNICON) -c canvas
images.u : images.icn $(ICONS)
	$(UNICON) -c images
utils.u : utils.icn
	$(UNICON) -c $?
code.u : code.icn
	$(UNICON) -c $?

Clean:
	$(RM) -f *.u uniclass.dir uniclass.pag
