/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualResolver;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002JX\u0010\u0010\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122&\u0010\u0013\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00160\u00142\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u001c\u0010\u001f\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u000f*\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0002\b\u00030\u0014J\u0016\u0010#\u001a\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015H\u0002J\u0010\u0010$\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkActualDeclarationHasExpected", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkActual", "", "checkAmbiguousExpects", "actualDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "symbol", "checkAnnotationConstructors", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "expected", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "actual", "isUnderlyingPropertyOfInlineClass", "requireActualModifier", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "allStrongIncompatibilities", "isCompatibleOrWeakCompatible", "isExplicitActualDeclaration", "checkers"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$default(this, (FirMemberDeclaration)declaration2, context2, reporter, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualDeclarationHasExpected(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean checkActual) {
        ScopeSession scopeSession = new ScopeSession();
        FirBasedSymbol<? extends FirDeclaration> symbol2 = declaration2.getSymbol();
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map = FirExpectActualResolver.INSTANCE.findExpectForActual(symbol2, context2.getSession(), scopeSession);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> compatibilityToMembersMap = map;
        FirSession session2 = context2.getSession();
        this.checkAmbiguousExpects(symbol2, compatibilityToMembersMap, symbol2, context2, reporter);
        KtSourceElement source = declaration2.getSource();
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            if (this.allStrongIncompatibilities(compatibilityToMembersMap)) {
                return;
            }
            if (compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
                if (checkActual && this.requireActualModifier(symbol2, session2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), (DiagnosticContext)context2, null, 8, null);
                }
                return;
            }
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.singleOrNull((Iterable)compatibilityToMembersMap.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            void $this$filterNotTo$iv$iv;
            boolean bl = $i$f$isActual = symbol2 instanceof FirRegularClassSymbol || symbol2 instanceof FirTypeAliasSymbol;
            if (_Assertions.ENABLED && !$i$f$isActual) {
                boolean $i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = false;
                String $i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + declaration2;
                throw new AssertionError((Object)$i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22);
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Pair p0 = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(session2, scopeSession, p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol2, (Object)nonTrivialUnfulfilled, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (!compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
            Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> $this$cast$iv = compatibilityToMembersMap;
            boolean $i$f$cast = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol2, $this$cast$iv, (DiagnosticContext)context2, null, 32, null);
        } else {
            List<FirBasedSymbol<?>> list2 = compatibilityToMembersMap.get(ExpectActualCompatibility.Compatible.INSTANCE);
            Intrinsics.checkNotNull(list2);
            FirBasedSymbol<?> expected = CollectionsKt.first(list2);
            if (expected instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)expected).getClassKind() == ClassKind.ANNOTATION_CLASS) {
                Object v6;
                FirConstructorSymbol actualConstructor;
                block19: {
                    FirConstructorSymbol firConstructorSymbol;
                    boolean $i$f$firstIsInstanceOrNull;
                    Iterable $this$firstIsInstanceOrNull$iv;
                    FirRegularClassSymbol klass = FirExpectActualDeclarationCheckerKt.expandedClass(symbol2, session2);
                    Object object = klass;
                    if (object != null && (object = ((FirClassSymbol)object).getDeclarationSymbols()) != null) {
                        Object v4;
                        block18: {
                            $this$firstIsInstanceOrNull$iv = (Iterable)object;
                            $i$f$firstIsInstanceOrNull = false;
                            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                                if (!(element$iv instanceof FirConstructorSymbol)) continue;
                                v4 = element$iv;
                                break block18;
                            }
                            v4 = null;
                        }
                        firConstructorSymbol = v4;
                    } else {
                        firConstructorSymbol = null;
                    }
                    actualConstructor = firConstructorSymbol;
                    $this$firstIsInstanceOrNull$iv = ((FirRegularClassSymbol)expected).getDeclarationSymbols();
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof FirConstructorSymbol)) continue;
                        v6 = element$iv;
                        break block19;
                    }
                    v6 = null;
                }
                FirConstructorSymbol expectedConstructor = v6;
                if (expectedConstructor != null && actualConstructor != null) {
                    this.checkAnnotationConstructors(source, expectedConstructor, actualConstructor, context2, reporter);
                }
            }
        }
    }

    static /* synthetic */ void checkActualDeclarationHasExpected$default(FirExpectActualDeclarationChecker firExpectActualDeclarationChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        firExpectActualDeclarationChecker.checkActualDeclarationHasExpected(firMemberDeclaration, checkerContext, diagnosticReporter, bl);
    }

    private final void checkAnnotationConstructors(KtSourceElement source, FirConstructorSymbol expected, FirConstructorSymbol actual, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirValueParameterSymbol expectedValueParameter : expected.getValueParameterSymbols()) {
            Object element$iv2;
            block2: {
                Iterable $this$first$iv = actual.getValueParameterSymbols();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), expectedValueParameter.getName())) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FirValueParameterSymbol actualValueDescriptor = (FirValueParameterSymbol)element$iv2;
            if (!expectedValueParameter.getHasDefaultValue() || !actualValueDescriptor.getHasDefaultValue()) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(FirBasedSymbol<?> actualDeclaration, Map<ExpectActualCompatibility<FirBasedSymbol<?>>, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map(SequencesKt.flattenSequenceOfIterable(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence(compatibility), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.1.INSTANCE), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FirModuleData it = (FirModuleData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName().asString()));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol2, filesWithAtLeastWeaklyCompatibleExpects2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<?>, ?> $this$allStrongIncompatibilities) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, "<this>");
            Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectActualCompatibility<? extends FirBasedSymbol<?>> $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration2, FirSession session2) {
        return !FirExpectActualDeclarationCheckerKt.isAnnotationConstructor(declaration2, session2) && !FirExpectActualDeclarationCheckerKt.isPrimaryConstructorOfInlineClass(declaration2, session2) && !this.isUnderlyingPropertyOfInlineClass(declaration2);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(FirBasedSymbol<?> declaration2) {
        return false;
    }

    private final boolean isExplicitActualDeclaration(FirBasedSymbol<?> $this$isExplicitActualDeclaration) {
        return true;
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(FirSession session2, ScopeSession scopeSession, Pair<? extends FirBasedSymbol<?>, ? extends Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, ? extends Collection<? extends FirBasedSymbol<?>>>> expectedWithIncompatibility) {
        List list2;
        Collection<List<FirBasedSymbol<?>>> collection;
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map;
        FirBasedSymbol actualMember;
        FirBasedSymbol<?> expectedMember = expectedWithIncompatibility.component1();
        Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, Collection<FirBasedSymbol<?>>> incompatibility = expectedWithIncompatibility.component2();
        Collection collection2 = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        FirBasedSymbol firBasedSymbol = actualMember = collection2 != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(collection2) : null;
        return actualMember != null && INSTANCE.isExplicitActualDeclaration(actualMember) && !INSTANCE.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((map = FirExpectActualResolver.INSTANCE.findExpectForActual(actualMember, session2, scopeSession)) != null && (collection = map.values()) != null && (list2 = (List)CollectionsKt.singleOrNull((Iterable)collection)) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(list2) : null, expectedMember);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(FirExpectActualDeclarationChecker $this, ExpectActualCompatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }
}

