/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.PrimitiveTypeUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001J\u0006\u0010\u001a\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'H\u0017J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(JLorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "possibleTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(JLorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/Set;)V", "getPossibleTypes", "()Ljava/util/Set;", "supertypes", "", "getSupertypes", "()Ljava/util/List;", "supertypes$delegate", "Lkotlin/Lazy;", "type", "Lorg/jetbrains/kotlin/types/SimpleType;", "checkConstructor", "", "constructor", "getApproximatedType", "getBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getDeclarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "isContainsOnlyUnsignedTypes", "isDenotable", "isFinal", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "toString", "", "valueToString", "Companion", "descriptors"})
public final class IntegerLiteralTypeConstructor
implements TypeConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final Set<KotlinType> possibleTypes;
    @NotNull
    private final SimpleType type;
    @NotNull
    private final Lazy supertypes$delegate;

    @NotNull
    public final Set<KotlinType> getPossibleTypes() {
        return this.possibleTypes;
    }

    public IntegerLiteralTypeConstructor(long value2, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.type = KotlinTypeFactory.integerLiteralType(Annotations.Companion.getEMPTY(), this, false);
        this.supertypes$delegate = LazyKt.lazy((Function0)new Function0<List<SimpleType>>(this){
            final /* synthetic */ IntegerLiteralTypeConstructor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<SimpleType> invoke() {
                SimpleType[] simpleTypeArray = new SimpleType[1];
                SimpleType simpleType2 = this.this$0.getBuiltIns().getComparable().getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.comparable.defaultType");
                simpleTypeArray[0] = TypeSubstitutionKt.replace$default(simpleType2, CollectionsKt.listOf(new TypeProjectionImpl(Variance.IN_VARIANCE, IntegerLiteralTypeConstructor.access$getType$p(this.this$0))), null, 2, null);
                List<SimpleType> result2 = CollectionsKt.mutableListOf(simpleTypeArray);
                if (!IntegerLiteralTypeConstructor.access$isContainsOnlyUnsignedTypes(this.this$0)) {
                    ((Collection)result2).add(this.this$0.getBuiltIns().getNumberType());
                }
                return result2;
            }
        });
        this.value = value2;
        this.module = module2;
        Set possibleTypes = new LinkedHashSet();
        boolean isUnsigned = parameters2.isUnsignedNumberLiteral();
        boolean isConvertable = parameters2.isConvertableConstVal();
        if (isUnsigned || isConvertable) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(module2);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw new AssertionError((Object)string2);
            }
        }
        if (isConvertable) {
            IntegerLiteralTypeConstructor._init_$addSignedPossibleTypes(value2, this, possibleTypes);
            IntegerLiteralTypeConstructor._init_$addUnsignedPossibleTypes(value2, module2, possibleTypes);
        } else if (isUnsigned) {
            IntegerLiteralTypeConstructor._init_$addUnsignedPossibleTypes(value2, module2, possibleTypes);
        } else {
            IntegerLiteralTypeConstructor._init_$addSignedPossibleTypes(value2, this, possibleTypes);
        }
        this.possibleTypes = possibleTypes;
    }

    private IntegerLiteralTypeConstructor(long value2, ModuleDescriptor module2, Set<? extends KotlinType> possibleTypes) {
        this.type = KotlinTypeFactory.integerLiteralType(Annotations.Companion.getEMPTY(), this, false);
        this.supertypes$delegate = LazyKt.lazy((Function0)new /* invalid duplicate definition of identical inner class */);
        this.value = value2;
        this.module = module2;
        this.possibleTypes = possibleTypes;
    }

    private final boolean isContainsOnlyUnsignedTypes() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = PrimitiveTypeUtilKt.getAllSignedLiteralTypes(this.module);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!this.possibleTypes.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final List<KotlinType> getSupertypes() {
        Lazy lazy = this.supertypes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final KotlinType getApproximatedType() {
        KotlinType kotlinType;
        if (this.possibleTypes.contains(this.getBuiltIns().getIntType())) {
            SimpleType simpleType2 = this.getBuiltIns().getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.intType");
            kotlinType = simpleType2;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getLongType())) {
            SimpleType simpleType3 = this.getBuiltIns().getLongType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "builtIns.longType");
            kotlinType = simpleType3;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getByteType())) {
            SimpleType simpleType4 = this.getBuiltIns().getByteType();
            Intrinsics.checkNotNullExpressionValue(simpleType4, "builtIns.byteType");
            kotlinType = simpleType4;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getShortType())) {
            SimpleType simpleType5 = this.getBuiltIns().getShortType();
            Intrinsics.checkNotNullExpressionValue(simpleType5, "builtIns.shortType");
            kotlinType = simpleType5;
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUIntType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUIntType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getULongType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getULongType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUByteType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUByteType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUShortType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUShortType(this.module);
        } else {
            throw new IllegalStateException();
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.getSupertypes();
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }

    @NotNull
    public String toString() {
        return "IntegerLiteralType" + this.valueToString();
    }

    public final boolean checkConstructor(@NotNull TypeConstructor constructor2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            Iterable $this$any$iv = this.possibleTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getConstructor(), constructor2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String valueToString() {
        return '[' + CollectionsKt.joinToString$default(this.possibleTypes, ",", null, null, 0, null, valueToString.1.INSTANCE, 30, null) + ']';
    }

    private static final void _init_$checkBoundsAndAddPossibleType(Set<KotlinType> possibleTypes, long value2, KotlinType kotlinType) {
        long l = PrimitiveTypeUtilKt.minValue(kotlinType);
        boolean bl = value2 <= PrimitiveTypeUtilKt.maxValue(kotlinType) ? l <= value2 : false;
        if (bl) {
            possibleTypes.add(kotlinType);
        }
    }

    private static final void _init_$addSignedPossibleTypes(long $value, IntegerLiteralTypeConstructor this$0, Set<KotlinType> possibleTypes) {
        SimpleType simpleType2 = this$0.getBuiltIns().getIntType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.intType");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType2);
        SimpleType simpleType3 = this$0.getBuiltIns().getLongType();
        Intrinsics.checkNotNullExpressionValue(simpleType3, "builtIns.longType");
        possibleTypes.add(simpleType3);
        SimpleType simpleType4 = this$0.getBuiltIns().getByteType();
        Intrinsics.checkNotNullExpressionValue(simpleType4, "builtIns.byteType");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType4);
        SimpleType simpleType5 = this$0.getBuiltIns().getShortType();
        Intrinsics.checkNotNullExpressionValue(simpleType5, "builtIns.shortType");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType5);
    }

    private static final void _init_$addUnsignedPossibleTypes(long $value, ModuleDescriptor $module, Set<KotlinType> possibleTypes) {
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUIntType($module));
        possibleTypes.add(PrimitiveTypeUtilKt.getULongType($module));
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUByteType($module));
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUShortType($module));
    }

    public /* synthetic */ IntegerLiteralTypeConstructor(long value2, ModuleDescriptor module2, Set possibleTypes, DefaultConstructorMarker $constructor_marker) {
        this(value2, module2, possibleTypes);
    }

    public static final /* synthetic */ SimpleType access$getType$p(IntegerLiteralTypeConstructor $this) {
        return $this.type;
    }

    public static final /* synthetic */ boolean access$isContainsOnlyUnsignedTypes(IntegerLiteralTypeConstructor $this) {
        return $this.isContainsOnlyUnsignedTypes();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J&\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor$Companion;", "", "()V", "findCommonSuperType", "Lorg/jetbrains/kotlin/types/SimpleType;", "types", "", "findCommonSuperTypeOrIntersectionType", "mode", "Lorg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor$Companion$Mode;", "findIntersectionType", "fold", "left", "Lorg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor;", "right", "Mode", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SimpleType findCommonSuperType(@NotNull Collection<? extends SimpleType> types2) {
            Intrinsics.checkNotNullParameter(types2, "types");
            return this.findCommonSuperTypeOrIntersectionType(types2, Mode.COMMON_SUPER_TYPE);
        }

        @Nullable
        public final SimpleType findIntersectionType(@NotNull Collection<? extends SimpleType> types2) {
            Intrinsics.checkNotNullParameter(types2, "types");
            return this.findCommonSuperTypeOrIntersectionType(types2, Mode.INTERSECTION_TYPE);
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleType findCommonSuperTypeOrIntersectionType(Collection<? extends SimpleType> types2, Mode mode) {
            if (types2.isEmpty()) {
                return null;
            }
            Iterable $this$reduce$iv = types2;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void right;
                SimpleType simpleType2 = (SimpleType)iterator$iv.next();
                SimpleType left = (SimpleType)accumulator$iv;
                boolean bl = false;
                accumulator$iv = Companion.fold(left, (SimpleType)right, mode);
            }
            return (SimpleType)accumulator$iv;
        }

        private final SimpleType fold(SimpleType left, SimpleType right, Mode mode) {
            if (left == null || right == null) {
                return null;
            }
            TypeConstructor leftConstructor = left.getConstructor();
            TypeConstructor rightConstructor = right.getConstructor();
            return leftConstructor instanceof IntegerLiteralTypeConstructor && rightConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)leftConstructor, (IntegerLiteralTypeConstructor)rightConstructor, mode) : (leftConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)leftConstructor, right) : (rightConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)rightConstructor, left) : null));
        }

        private final SimpleType fold(IntegerLiteralTypeConstructor left, IntegerLiteralTypeConstructor right, Mode mode) {
            Set set;
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    set = CollectionsKt.intersect((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
                    break;
                }
                case 2: {
                    set = CollectionsKt.union((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Set possibleTypes = set;
            IntegerLiteralTypeConstructor constructor2 = new IntegerLiteralTypeConstructor(left.value, left.module, possibleTypes, null);
            return KotlinTypeFactory.integerLiteralType(Annotations.Companion.getEMPTY(), constructor2, false);
        }

        private final SimpleType fold(IntegerLiteralTypeConstructor left, SimpleType right) {
            return left.getPossibleTypes().contains(right) ? right : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor$Companion$Mode;", "", "(Ljava/lang/String;I)V", "COMMON_SUPER_TYPE", "INTERSECTION_TYPE", "descriptors"})
        private static final class Mode
        extends Enum<Mode> {
            public static final /* enum */ Mode COMMON_SUPER_TYPE = new Mode();
            public static final /* enum */ Mode INTERSECTION_TYPE = new Mode();
            private static final /* synthetic */ Mode[] $VALUES;

            public static Mode[] values() {
                return (Mode[])$VALUES.clone();
            }

            public static Mode valueOf(String value2) {
                return Enum.valueOf(Mode.class, value2);
            }

            static {
                $VALUES = modeArray = new Mode[]{Mode.COMMON_SUPER_TYPE, Mode.INTERSECTION_TYPE};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                nArray[Mode.COMMON_SUPER_TYPE.ordinal()] = 1;
                nArray[Mode.INTERSECTION_TYPE.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

