/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    @NotNull
    public static final ConstructorHeaderCallChecker INSTANCE = new ConstructorHeaderCallChecker();

    private ConstructorHeaderCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        block3: {
            ClassDescriptor labelReferenceClass;
            Object v;
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getDispatchReceiver());
            ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getExtensionReceiver());
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue(ktElement, "resolvedCall.call.callElement");
            KtElement callElement = ktElement;
            ClassDescriptor classDescriptor = callElement instanceof KtInstanceExpressionWithLabel ? ((v = context2.getTrace().get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference())) instanceof ClassDescriptor ? (ClassDescriptor)v : null) : (labelReferenceClass = null);
            if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
                return;
            }
            ClassDescriptor[] classDescriptorArray = new ClassDescriptor[]{dispatchReceiverClass, extensionReceiverClass, labelReferenceClass};
            Set<ClassDescriptor> classes2 = SetsKt.setOf(classDescriptorArray);
            Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context2.getScope());
            boolean $i$f$any = false;
            Iterator<HierarchicalScope> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                HierarchicalScope element$iv;
                HierarchicalScope scope2 = element$iv = iterator2.next();
                boolean bl2 = false;
                boolean bl3 = scope2 instanceof LexicalScope && ((LexicalScope)scope2).getKind() == LexicalScopeKind.CONSTRUCTOR_HEADER && classes2.contains(((ClassConstructorDescriptor)((LexicalScope)scope2).getOwnerDescriptor()).getContainingDeclaration());
                if (!bl3) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            context2.getTrace().report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(reportOn, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
        }
    }
}

