// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/scheduler/v1/target.proto

package schedulerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The HTTP method used to execute the job.
type HttpMethod int32

const (
	// HTTP method unspecified. Defaults to POST.
	HttpMethod_HTTP_METHOD_UNSPECIFIED HttpMethod = 0
	// HTTP POST
	HttpMethod_POST HttpMethod = 1
	// HTTP GET
	HttpMethod_GET HttpMethod = 2
	// HTTP HEAD
	HttpMethod_HEAD HttpMethod = 3
	// HTTP PUT
	HttpMethod_PUT HttpMethod = 4
	// HTTP DELETE
	HttpMethod_DELETE HttpMethod = 5
	// HTTP PATCH
	HttpMethod_PATCH HttpMethod = 6
	// HTTP OPTIONS
	HttpMethod_OPTIONS HttpMethod = 7
)

// Enum value maps for HttpMethod.
var (
	HttpMethod_name = map[int32]string{
		0: "HTTP_METHOD_UNSPECIFIED",
		1: "POST",
		2: "GET",
		3: "HEAD",
		4: "PUT",
		5: "DELETE",
		6: "PATCH",
		7: "OPTIONS",
	}
	HttpMethod_value = map[string]int32{
		"HTTP_METHOD_UNSPECIFIED": 0,
		"POST":                    1,
		"GET":                     2,
		"HEAD":                    3,
		"PUT":                     4,
		"DELETE":                  5,
		"PATCH":                   6,
		"OPTIONS":                 7,
	}
)

func (x HttpMethod) Enum() *HttpMethod {
	p := new(HttpMethod)
	*p = x
	return p
}

func (x HttpMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_scheduler_v1_target_proto_enumTypes[0].Descriptor()
}

func (HttpMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_scheduler_v1_target_proto_enumTypes[0]
}

func (x HttpMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpMethod.Descriptor instead.
func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{0}
}

// Http target. The job will be pushed to the job handler by means of
// an HTTP request via an
// [http_method][google.cloud.scheduler.v1.HttpTarget.http_method] such as HTTP
// POST, HTTP GET, etc. The job is acknowledged by means of an HTTP
// response code in the range [200 - 299]. A failure to receive a response
// constitutes a failed execution. For a redirected request, the response
// returned by the redirected request is considered.
type HttpTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full URI path that the request will be sent to. This string
	// must begin with either "http://" or "https://". Some examples of
	// valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
	// `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
	// encode some characters for safety and compatibility. The maximum allowed
	// URL length is 2083 characters after encoding.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Which HTTP method to use for the request.
	HttpMethod HttpMethod `protobuf:"varint,2,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.scheduler.v1.HttpMethod" json:"http_method,omitempty"`
	// The user can specify HTTP request headers to send with the job's
	// HTTP request. This map contains the header field names and
	// values. Repeated headers are not supported, but a header value can
	// contain commas. These headers represent a subset of the headers
	// that will accompany the job's HTTP request. Some HTTP request
	// headers will be ignored or replaced. A partial list of headers that
	// will be ignored or replaced is below:
	// - Host: This will be computed by Cloud Scheduler and derived from
	// [uri][google.cloud.scheduler.v1.HttpTarget.uri].
	// * `Content-Length`: This will be computed by Cloud Scheduler.
	// * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
	// * `X-Google-*`: Google internal use only.
	// * `X-AppEngine-*`: Google internal use only.
	// * `X-CloudScheduler`: This header will be set to true.
	// * `X-CloudScheduler-JobName`: This header will contain the job name.
	// * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
	// the unix-cron format, this header will contain the job schedule time in
	// RFC3339 UTC "Zulu" format.
	//
	// The total size of headers must be less than 80KB.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body. A request body is allowed only if the HTTP
	// method is POST, PUT, or PATCH. It is an error to set body on a job with an
	// incompatible [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	// The mode for generating an `Authorization` header for HTTP requests.
	//
	// If specified, all `Authorization` headers in the
	// [HttpTarget.headers][google.cloud.scheduler.v1.HttpTarget.headers] field
	// will be overridden.
	//
	// Types that are assignable to AuthorizationHeader:
	//	*HttpTarget_OauthToken
	//	*HttpTarget_OidcToken
	AuthorizationHeader isHttpTarget_AuthorizationHeader `protobuf_oneof:"authorization_header"`
}

func (x *HttpTarget) Reset() {
	*x = HttpTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpTarget) ProtoMessage() {}

func (x *HttpTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpTarget.ProtoReflect.Descriptor instead.
func (*HttpTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{0}
}

func (x *HttpTarget) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *HttpTarget) GetHttpMethod() HttpMethod {
	if x != nil {
		return x.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (x *HttpTarget) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpTarget) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

func (m *HttpTarget) GetAuthorizationHeader() isHttpTarget_AuthorizationHeader {
	if m != nil {
		return m.AuthorizationHeader
	}
	return nil
}

func (x *HttpTarget) GetOauthToken() *OAuthToken {
	if x, ok := x.GetAuthorizationHeader().(*HttpTarget_OauthToken); ok {
		return x.OauthToken
	}
	return nil
}

func (x *HttpTarget) GetOidcToken() *OidcToken {
	if x, ok := x.GetAuthorizationHeader().(*HttpTarget_OidcToken); ok {
		return x.OidcToken
	}
	return nil
}

type isHttpTarget_AuthorizationHeader interface {
	isHttpTarget_AuthorizationHeader()
}

type HttpTarget_OauthToken struct {
	// If specified, an
	// [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
	// will be generated and attached as an `Authorization` header in the HTTP
	// request.
	//
	// This type of authorization should generally only be used when calling
	// Google APIs hosted on *.googleapis.com.
	OauthToken *OAuthToken `protobuf:"bytes,5,opt,name=oauth_token,json=oauthToken,proto3,oneof"`
}

type HttpTarget_OidcToken struct {
	// If specified, an
	// [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
	// token will be generated and attached as an `Authorization` header in the
	// HTTP request.
	//
	// This type of authorization can be used for many scenarios, including
	// calling Cloud Run, or endpoints where you intend to validate the token
	// yourself.
	OidcToken *OidcToken `protobuf:"bytes,6,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*HttpTarget_OauthToken) isHttpTarget_AuthorizationHeader() {}

func (*HttpTarget_OidcToken) isHttpTarget_AuthorizationHeader() {}

// App Engine target. The job will be pushed to a job handler by means
// of an HTTP request via an
// [http_method][google.cloud.scheduler.v1.AppEngineHttpTarget.http_method] such
// as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an
// HTTP response code in the range [200 - 299]. Error 503 is
// considered an App Engine system error instead of an application
// error. Requests returning error 503 will be retried regardless of
// retry configuration and not counted against retry counts. Any other
// response code, or a failure to receive a response before the
// deadline, constitutes a failed attempt.
type AppEngineHttpTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP method to use for the request. PATCH and OPTIONS are not
	// permitted.
	HttpMethod HttpMethod `protobuf:"varint,1,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.scheduler.v1.HttpMethod" json:"http_method,omitempty"`
	// App Engine Routing setting for the job.
	AppEngineRouting *AppEngineRouting `protobuf:"bytes,2,opt,name=app_engine_routing,json=appEngineRouting,proto3" json:"app_engine_routing,omitempty"`
	// The relative URI.
	//
	// The relative URL must begin with "/" and must be a valid HTTP relative URL.
	// It can contain a path, query string arguments, and `#` fragments.
	// If the relative URL is empty, then the root path "/" will be used.
	// No spaces are allowed, and the maximum length allowed is 2083 characters.
	RelativeUri string `protobuf:"bytes,3,opt,name=relative_uri,json=relativeUri,proto3" json:"relative_uri,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values. Headers can be set
	// when the job is created.
	//
	// Cloud Scheduler sets some headers to default values:
	//
	// * `User-Agent`: By default, this header is
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
	//   This header can be modified, but Cloud Scheduler will append
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
	//   modified `User-Agent`.
	// * `X-CloudScheduler`: This header will be set to true.
	// * `X-CloudScheduler-JobName`: This header will contain the job name.
	// * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
	// the unix-cron format, this header will contain the job schedule time in
	// RFC3339 UTC "Zulu" format.
	//
	// If the job has an
	// [body][google.cloud.scheduler.v1.AppEngineHttpTarget.body], Cloud Scheduler
	// sets the following headers:
	//
	// * `Content-Type`: By default, the `Content-Type` header is set to
	//   `"application/octet-stream"`. The default can be overridden by explictly
	//   setting `Content-Type` to a particular media type when the job is
	//   created.
	//   For example, `Content-Type` can be set to `"application/json"`.
	// * `Content-Length`: This is computed by Cloud Scheduler. This value is
	//   output only. It cannot be changed.
	//
	// The headers below are output only. They cannot be set or overridden:
	//
	// * `X-Google-*`: For Google internal use only.
	// * `X-AppEngine-*`: For Google internal use only.
	//
	// In addition, some App Engine headers, which contain
	// job-specific information, are also be sent to the job handler.
	Headers map[string]string `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Body.
	//
	// HTTP request body. A request body is allowed only if the HTTP method is
	// POST or PUT. It will result in invalid argument error to set a body on a
	// job with an incompatible
	// [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
	Body []byte `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *AppEngineHttpTarget) Reset() {
	*x = AppEngineHttpTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEngineHttpTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineHttpTarget) ProtoMessage() {}

func (x *AppEngineHttpTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineHttpTarget.ProtoReflect.Descriptor instead.
func (*AppEngineHttpTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{1}
}

func (x *AppEngineHttpTarget) GetHttpMethod() HttpMethod {
	if x != nil {
		return x.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (x *AppEngineHttpTarget) GetAppEngineRouting() *AppEngineRouting {
	if x != nil {
		return x.AppEngineRouting
	}
	return nil
}

func (x *AppEngineHttpTarget) GetRelativeUri() string {
	if x != nil {
		return x.RelativeUri
	}
	return ""
}

func (x *AppEngineHttpTarget) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *AppEngineHttpTarget) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

// Pub/Sub target. The job will be delivered by publishing a message to
// the given Pub/Sub topic.
type PubsubTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud Pub/Sub topic to which messages will
	// be published when a job is delivered. The topic name must be in the
	// same format as required by Pub/Sub's
	// [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest),
	// for example `projects/PROJECT_ID/topics/TOPIC_ID`.
	//
	// The topic must be in the same project as the Cloud Scheduler job.
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	// The message payload for PubsubMessage.
	//
	// Pubsub message must contain either non-empty data, or at least one
	// attribute.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// Attributes for PubsubMessage.
	//
	// Pubsub message must contain either non-empty data, or at least one
	// attribute.
	Attributes map[string]string `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PubsubTarget) Reset() {
	*x = PubsubTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubTarget) ProtoMessage() {}

func (x *PubsubTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubTarget.ProtoReflect.Descriptor instead.
func (*PubsubTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{2}
}

func (x *PubsubTarget) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

func (x *PubsubTarget) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PubsubTarget) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// App Engine Routing.
//
// For more information about services, versions, and instances see
// [An Overview of App
// Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
// [Microservices Architecture on Google App
// Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
// [App Engine Standard request
// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
// and [App Engine Flex request
// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
type AppEngineRouting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// App service.
	//
	// By default, the job is sent to the service which is the default
	// service when the job is attempted.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// App version.
	//
	// By default, the job is sent to the version which is the default
	// version when the job is attempted.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// App instance.
	//
	// By default, the job is sent to an instance which is available when
	// the job is attempted.
	//
	// Requests can only be sent to a specific instance if
	// [manual scaling is used in App Engine
	// Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?#scaling_types_and_instance_classes).
	// App Engine Flex does not support instances. For more information, see
	// [App Engine Standard request
	// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
	// and [App Engine Flex request
	// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Output only. The host that the job is sent to.
	//
	// For more information about how App Engine requests are routed, see
	// [here](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
	//
	// The host is constructed as:
	//
	//
	// * `host = [application_domain_name]`</br>
	//   `| [service] + '.' + [application_domain_name]`</br>
	//   `| [version] + '.' + [application_domain_name]`</br>
	//   `| [version_dot_service]+ '.' + [application_domain_name]`</br>
	//   `| [instance] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_service] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version_dot_service] + '.' + [application_domain_name]`
	//
	// * `application_domain_name` = The domain name of the app, for
	//   example <app-id>.appspot.com, which is associated with the
	//   job's project ID.
	//
	// * `service =` [service][google.cloud.scheduler.v1.AppEngineRouting.service]
	//
	// * `version =` [version][google.cloud.scheduler.v1.AppEngineRouting.version]
	//
	// * `version_dot_service =`
	//   [version][google.cloud.scheduler.v1.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.scheduler.v1.AppEngineRouting.service]
	//
	// * `instance =`
	// [instance][google.cloud.scheduler.v1.AppEngineRouting.instance]
	//
	// * `instance_dot_service =`
	//   [instance][google.cloud.scheduler.v1.AppEngineRouting.instance] `+ '.' +`
	//   [service][google.cloud.scheduler.v1.AppEngineRouting.service]
	//
	// * `instance_dot_version =`
	//   [instance][google.cloud.scheduler.v1.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.scheduler.v1.AppEngineRouting.version]
	//
	// * `instance_dot_version_dot_service =`
	//   [instance][google.cloud.scheduler.v1.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.scheduler.v1.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.scheduler.v1.AppEngineRouting.service]
	//
	//
	// If [service][google.cloud.scheduler.v1.AppEngineRouting.service] is empty,
	// then the job will be sent to the service which is the default service when
	// the job is attempted.
	//
	// If [version][google.cloud.scheduler.v1.AppEngineRouting.version] is empty,
	// then the job will be sent to the version which is the default version when
	// the job is attempted.
	//
	// If [instance][google.cloud.scheduler.v1.AppEngineRouting.instance] is
	// empty, then the job will be sent to an instance which is available when the
	// job is attempted.
	//
	// If [service][google.cloud.scheduler.v1.AppEngineRouting.service],
	// [version][google.cloud.scheduler.v1.AppEngineRouting.version], or
	// [instance][google.cloud.scheduler.v1.AppEngineRouting.instance] is invalid,
	// then the job will be sent to the default version of the default service
	// when the job is attempted.
	Host string `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
}

func (x *AppEngineRouting) Reset() {
	*x = AppEngineRouting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEngineRouting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineRouting) ProtoMessage() {}

func (x *AppEngineRouting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineRouting.ProtoReflect.Descriptor instead.
func (*AppEngineRouting) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{3}
}

func (x *AppEngineRouting) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *AppEngineRouting) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AppEngineRouting) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *AppEngineRouting) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

// Contains information needed for generating an
// [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
// This type of authorization should generally only be used when calling Google
// APIs hosted on *.googleapis.com.
type OAuthToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OAuth token.
	// The service account must be within the same project as the job. The caller
	// must have iam.serviceAccounts.actAs permission for the service account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// OAuth scope to be used for generating OAuth access token.
	// If not specified, "https://www.googleapis.com/auth/cloud-platform"
	// will be used.
	Scope string `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
}

func (x *OAuthToken) Reset() {
	*x = OAuthToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuthToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuthToken) ProtoMessage() {}

func (x *OAuthToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuthToken.ProtoReflect.Descriptor instead.
func (*OAuthToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{4}
}

func (x *OAuthToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *OAuthToken) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
// This type of authorization can be used for many scenarios, including
// calling Cloud Run, or endpoints where you intend to validate the token
// yourself.
type OidcToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OIDC token.
	// The service account must be within the same project as the job. The caller
	// must have iam.serviceAccounts.actAs permission for the service account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Audience to be used when generating OIDC token. If not specified, the URI
	// specified in target will be used.
	Audience string `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *OidcToken) Reset() {
	*x = OidcToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcToken) ProtoMessage() {}

func (x *OidcToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_scheduler_v1_target_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcToken.ProtoReflect.Descriptor instead.
func (*OidcToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_scheduler_v1_target_proto_rawDescGZIP(), []int{5}
}

func (x *OidcToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *OidcToken) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

var File_google_cloud_scheduler_v1_target_proto protoreflect.FileDescriptor

var file_google_cloud_scheduler_v1_target_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad,
	0x03, 0x0a, 0x0a, 0x48, 0x74, 0x74, 0x70, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x46, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0a, 0x68, 0x74, 0x74,
	0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x48, 0x0a, 0x0b, 0x6f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x45, 0x0a, 0x0a, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52,
	0x09, 0x6f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x82,
	0x03, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x48, 0x74, 0x74, 0x70,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x46, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x59,
	0x0a, 0x12, 0x61, 0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x61, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x12, 0x55, 0x0a, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x48, 0x74, 0x74, 0x70, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xfb, 0x01, 0x0a, 0x0c, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x3f, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x57, 0x0a, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x76, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x22, 0x56, 0x0a, 0x0a, 0x4f, 0x41, 0x75,
	0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x22, 0x5b, 0x0a, 0x09, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x32,
	0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61,
	0x69, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2a, 0x73,
	0x0a, 0x0a, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x17,
	0x48, 0x54, 0x54, 0x50, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x45, 0x54, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04,
	0x48, 0x45, 0x41, 0x44, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x55, 0x54, 0x10, 0x04, 0x12,
	0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x50,
	0x41, 0x54, 0x43, 0x48, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x10, 0x07, 0x42, 0xae, 0x01, 0xea, 0x41, 0x40, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x7d, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_scheduler_v1_target_proto_rawDescOnce sync.Once
	file_google_cloud_scheduler_v1_target_proto_rawDescData = file_google_cloud_scheduler_v1_target_proto_rawDesc
)

func file_google_cloud_scheduler_v1_target_proto_rawDescGZIP() []byte {
	file_google_cloud_scheduler_v1_target_proto_rawDescOnce.Do(func() {
		file_google_cloud_scheduler_v1_target_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_scheduler_v1_target_proto_rawDescData)
	})
	return file_google_cloud_scheduler_v1_target_proto_rawDescData
}

var file_google_cloud_scheduler_v1_target_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_scheduler_v1_target_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_scheduler_v1_target_proto_goTypes = []interface{}{
	(HttpMethod)(0),             // 0: google.cloud.scheduler.v1.HttpMethod
	(*HttpTarget)(nil),          // 1: google.cloud.scheduler.v1.HttpTarget
	(*AppEngineHttpTarget)(nil), // 2: google.cloud.scheduler.v1.AppEngineHttpTarget
	(*PubsubTarget)(nil),        // 3: google.cloud.scheduler.v1.PubsubTarget
	(*AppEngineRouting)(nil),    // 4: google.cloud.scheduler.v1.AppEngineRouting
	(*OAuthToken)(nil),          // 5: google.cloud.scheduler.v1.OAuthToken
	(*OidcToken)(nil),           // 6: google.cloud.scheduler.v1.OidcToken
	nil,                         // 7: google.cloud.scheduler.v1.HttpTarget.HeadersEntry
	nil,                         // 8: google.cloud.scheduler.v1.AppEngineHttpTarget.HeadersEntry
	nil,                         // 9: google.cloud.scheduler.v1.PubsubTarget.AttributesEntry
}
var file_google_cloud_scheduler_v1_target_proto_depIdxs = []int32{
	0, // 0: google.cloud.scheduler.v1.HttpTarget.http_method:type_name -> google.cloud.scheduler.v1.HttpMethod
	7, // 1: google.cloud.scheduler.v1.HttpTarget.headers:type_name -> google.cloud.scheduler.v1.HttpTarget.HeadersEntry
	5, // 2: google.cloud.scheduler.v1.HttpTarget.oauth_token:type_name -> google.cloud.scheduler.v1.OAuthToken
	6, // 3: google.cloud.scheduler.v1.HttpTarget.oidc_token:type_name -> google.cloud.scheduler.v1.OidcToken
	0, // 4: google.cloud.scheduler.v1.AppEngineHttpTarget.http_method:type_name -> google.cloud.scheduler.v1.HttpMethod
	4, // 5: google.cloud.scheduler.v1.AppEngineHttpTarget.app_engine_routing:type_name -> google.cloud.scheduler.v1.AppEngineRouting
	8, // 6: google.cloud.scheduler.v1.AppEngineHttpTarget.headers:type_name -> google.cloud.scheduler.v1.AppEngineHttpTarget.HeadersEntry
	9, // 7: google.cloud.scheduler.v1.PubsubTarget.attributes:type_name -> google.cloud.scheduler.v1.PubsubTarget.AttributesEntry
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_scheduler_v1_target_proto_init() }
func file_google_cloud_scheduler_v1_target_proto_init() {
	if File_google_cloud_scheduler_v1_target_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_scheduler_v1_target_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_scheduler_v1_target_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEngineHttpTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_scheduler_v1_target_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubsubTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_scheduler_v1_target_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEngineRouting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_scheduler_v1_target_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuthToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_scheduler_v1_target_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OidcToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_scheduler_v1_target_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*HttpTarget_OauthToken)(nil),
		(*HttpTarget_OidcToken)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_scheduler_v1_target_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_scheduler_v1_target_proto_goTypes,
		DependencyIndexes: file_google_cloud_scheduler_v1_target_proto_depIdxs,
		EnumInfos:         file_google_cloud_scheduler_v1_target_proto_enumTypes,
		MessageInfos:      file_google_cloud_scheduler_v1_target_proto_msgTypes,
	}.Build()
	File_google_cloud_scheduler_v1_target_proto = out.File
	file_google_cloud_scheduler_v1_target_proto_rawDesc = nil
	file_google_cloud_scheduler_v1_target_proto_goTypes = nil
	file_google_cloud_scheduler_v1_target_proto_depIdxs = nil
}
