// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// Code generated by MockGen. DO NOT EDIT.
// Source: ./auth/token.go

package mock

import (
	reflect "reflect"

	auth "github.com/Azure/azure-sdk-for-go/sdk/messaging/azeventhubs/internal/auth"
	gomock "github.com/golang/mock/gomock"
)

// MockTokenProvider is a mock of TokenProvider interface.
type MockTokenProvider struct {
	ctrl     *gomock.Controller
	recorder *MockTokenProviderMockRecorder
}

// MockTokenProviderMockRecorder is the mock recorder for MockTokenProvider.
type MockTokenProviderMockRecorder struct {
	mock *MockTokenProvider
}

// NewMockTokenProvider creates a new mock instance.
func NewMockTokenProvider(ctrl *gomock.Controller) *MockTokenProvider {
	mock := &MockTokenProvider{ctrl: ctrl}
	mock.recorder = &MockTokenProviderMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTokenProvider) EXPECT() *MockTokenProviderMockRecorder {
	return m.recorder
}

// GetToken mocks base method.
func (m *MockTokenProvider) GetToken(uri string) (*auth.Token, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetToken", uri)
	ret0, _ := ret[0].(*auth.Token)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetToken indicates an expected call of GetToken.
func (mr *MockTokenProviderMockRecorder) GetToken(uri interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetToken", reflect.TypeOf((*MockTokenProvider)(nil).GetToken), uri)
}
