/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.types;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.types.ArrayType;
import mockit.asm.types.JavaType;
import mockit.asm.types.MethodType;
import mockit.asm.types.ObjectType;

public abstract class ReferenceType
extends JavaType {
    @Nonnull
    final char[] typeDescChars;
    @Nonnegative
    final int off;

    ReferenceType(@Nonnull char[] typeDesc) {
        super(typeDesc.length);
        this.typeDescChars = typeDesc;
        this.off = 0;
    }

    ReferenceType(@Nonnull char[] typeDesc, @Nonnegative int off, @Nonnegative int len) {
        super(len);
        this.typeDescChars = typeDesc;
        this.off = off;
    }

    @Nonnull
    public static ReferenceType createFromTypeDescriptor(@Nonnull String typeDesc) {
        return ReferenceType.getReferenceType(typeDesc.toCharArray(), 0);
    }

    @Nonnull
    static ReferenceType getReferenceType(@Nonnull char[] buf, @Nonnegative int off) {
        switch (buf[off]) {
            case '[': {
                return ArrayType.create(buf, off);
            }
            case 'L': {
                return ObjectType.create(buf, off);
            }
            case '(': {
                return new MethodType(buf, off, buf.length - off);
            }
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + new String(buf));
    }

    @Nonnull
    public static ReferenceType createFromInternalName(@Nonnull String internalName) {
        char[] buf = internalName.toCharArray();
        return buf[0] == '[' ? new ArrayType(buf) : new ObjectType(buf);
    }

    static int findTypeNameLength(@Nonnull char[] buf, @Nonnegative int off, @Nonnegative int len) {
        ++len;
        while (buf[off + len] != ';') {
            ++len;
        }
        return len;
    }

    static void getDescriptor(@Nonnull StringBuilder buf, @Nonnull Class<?> aClass) {
        buf.append('L');
        String name = aClass.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            buf.append(c == '.' ? (char)'/' : (char)c);
        }
        buf.append(';');
    }

    @Override
    void getDescriptor(@Nonnull StringBuilder typeDesc) {
        typeDesc.append(this.typeDescChars, this.off, this.len);
    }

    @Nonnull
    public final String getInternalName() {
        return new String(this.typeDescChars, this.off, this.len);
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getOpcode(int opcode) {
        return opcode + 4;
    }

    @Override
    public final int getLoadOpcode() {
        return 25;
    }

    @Override
    public final int getConstOpcode() {
        return 1;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceType)) {
            return false;
        }
        ReferenceType t = (ReferenceType)o;
        if (this.getClass() != t.getClass() || this.len != t.len) {
            return false;
        }
        int i = this.off;
        int j = t.off;
        int end = i + this.len;
        while (i < end) {
            if (this.typeDescChars[i] != t.typeDescChars[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final int hashCode() {
        int i;
        int hc = 13;
        int end = i + this.len;
        for (i = this.off; i < end; ++i) {
            hc = 17 * (hc + this.typeDescChars[i]);
        }
        return hc;
    }
}

