/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Configuration;
import mockit.coverage.Metrics;
import mockit.coverage.data.CoverageData;

final class CoverageCheck {
    @Nullable
    private final List<Threshold> thresholds;
    private boolean allThresholdsSatisfied;

    CoverageCheck() {
        String configuration = Configuration.getProperty("check", "");
        if (configuration.isEmpty()) {
            this.thresholds = null;
            return;
        }
        String[] configurationParameters = configuration.split(";");
        int n = configurationParameters.length;
        this.thresholds = new ArrayList<Threshold>(n);
        for (String configurationParameter : configurationParameters) {
            this.thresholds.add(new Threshold(configurationParameter));
        }
    }

    void verifyThresholds() {
        if (this.thresholds == null) {
            return;
        }
        this.allThresholdsSatisfied = true;
        for (final Threshold threshold : this.thresholds) {
            Metrics.performAction(new Metrics.Action(){

                @Override
                public void perform(@Nonnull Metrics metric) {
                    CoverageCheck.this.allThresholdsSatisfied = CoverageCheck.this.allThresholdsSatisfied & threshold.verifyMinimum(metric);
                }
            });
        }
        this.createOrDeleteIndicatorFile();
        if (!this.allThresholdsSatisfied) {
            throw new AssertionError((Object)"JMockit: minimum coverage percentages not reached; see previous messages.");
        }
    }

    private void createOrDeleteIndicatorFile() {
        String parentDir = Configuration.getOrChooseOutputDirectory("");
        File indicatorFile = new File(parentDir, "coverage.check.failed");
        if (indicatorFile.exists()) {
            if (this.allThresholdsSatisfied) {
                indicatorFile.delete();
            } else {
                indicatorFile.setLastModified(System.currentTimeMillis());
            }
        } else if (!this.allThresholdsSatisfied) {
            try {
                indicatorFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class Threshold {
        private static final Pattern PARAMETER_SEPARATORS = Pattern.compile(":|=");
        @Nullable
        private final String sourceFilePrefix;
        @Nonnull
        private final String scopeDescription;
        @Nonnull
        private final int[] minPercentages;

        Threshold(@Nonnull String configurationParameter) {
            String csvPercentages;
            String[] sourceFilePrefixAndMinPercentages = PARAMETER_SEPARATORS.split(configurationParameter);
            if (sourceFilePrefixAndMinPercentages.length == 1) {
                this.sourceFilePrefix = null;
                this.scopeDescription = "";
                csvPercentages = sourceFilePrefixAndMinPercentages[0];
            } else {
                String scope = sourceFilePrefixAndMinPercentages[0].trim();
                if (Threshold.isPerFile(scope)) {
                    this.sourceFilePrefix = scope;
                    this.scopeDescription = " for some source files";
                } else {
                    this.sourceFilePrefix = scope.replace('.', '/');
                    this.scopeDescription = " for " + scope;
                }
                csvPercentages = sourceFilePrefixAndMinPercentages[1];
            }
            this.minPercentages = new int[Metrics.values().length];
            this.parseMinimumPercentages(csvPercentages);
        }

        private static boolean isPerFile(@Nullable String scope) {
            return "perFile".equalsIgnoreCase(scope);
        }

        private void parseMinimumPercentages(@Nonnull String csvPercentages) {
            String[] textualPercentages = csvPercentages.split(",");
            int n = Math.min(textualPercentages.length, this.minPercentages.length);
            for (int i = 0; i < n; ++i) {
                String textualValue = textualPercentages[i].trim();
                try {
                    this.minPercentages[i] = Integer.parseInt(textualValue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        boolean verifyMinimum(@Nonnull Metrics metric) {
            CoverageData coverageData = CoverageData.instance();
            int percentage = Threshold.isPerFile(this.sourceFilePrefix) ? coverageData.getSmallestPerFilePercentage(metric) : coverageData.getPercentage(metric, this.sourceFilePrefix);
            return percentage < 0 || this.verifyMinimum(metric, percentage);
        }

        private boolean verifyMinimum(@Nonnull Metrics metric, int percentage) {
            int minPercentage = this.minPercentages[metric.ordinal()];
            if (percentage < minPercentage) {
                System.out.println("JMockit: " + (Object)((Object)metric) + " coverage too low" + this.scopeDescription + ": " + percentage + "% < " + minPercentage + '%');
                return false;
            }
            return true;
        }
    }
}

