/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import javax.annotation.Nonnull;

public final class CoveragePercentage {
    private CoveragePercentage() {
    }

    public static int calculate(int coveredCount, int totalCount) {
        if (totalCount <= 0) {
            return -1;
        }
        return (int)(100.0 * (double)coveredCount / (double)totalCount + 0.5);
    }

    @Nonnull
    public static String percentageColor(int coveredCount, int totalCount) {
        if (coveredCount == 0) {
            return "ff0000";
        }
        if (coveredCount == totalCount) {
            return "00ff00";
        }
        double percentage = 100.0 * (double)coveredCount / (double)totalCount;
        int green = (int)(255.0 * percentage / 100.0 + 0.5);
        int red = 255 - green;
        StringBuilder color = new StringBuilder(6);
        CoveragePercentage.appendColorInHexadecimal(color, red);
        CoveragePercentage.appendColorInHexadecimal(color, green);
        color.append("00");
        return color.toString();
    }

    private static void appendColorInHexadecimal(@Nonnull StringBuilder colorInHexa, int rgb) {
        String hex = Integer.toHexString(rgb);
        if (hex.length() == 1) {
            colorInHexa.append('0');
        }
        colorInHexa.append(hex);
    }
}

