/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.dataCoverage.DataCoverageOutput;
import mockit.coverage.reporting.lineCoverage.LineCoverageOutput;
import mockit.coverage.reporting.parsing.FileParser;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;
import mockit.coverage.reporting.pathCoverage.PathCoverageOutput;
import mockit.coverage.reporting.sourceFiles.InputFile;
import mockit.coverage.reporting.sourceFiles.NeutralOutput;

public final class FileCoverageReport {
    @Nonnull
    private final InputFile inputFile;
    @Nonnull
    private final OutputFile output;
    @Nonnull
    private final FileParser fileParser;
    @Nonnull
    private final NeutralOutput neutralOutput;
    @Nonnull
    private final LineCoverageOutput lineCoverage;
    @Nullable
    private final PathCoverageOutput pathCoverage;
    @Nullable
    private final DataCoverageOutput dataCoverage;

    public FileCoverageReport(@Nonnull String outputDir, @Nonnull InputFile inputFile, @Nonnull FileCoverageData fileData, boolean withCallPoints) throws IOException {
        this.inputFile = inputFile;
        this.output = new OutputFile(outputDir, inputFile.filePath);
        this.fileParser = new FileParser();
        this.neutralOutput = new NeutralOutput(this.output);
        this.lineCoverage = new LineCoverageOutput(this.output, fileData.getLineCoverageData(), withCallPoints);
        this.pathCoverage = this.createPathCoverageOutput(fileData);
        this.dataCoverage = FileCoverageReport.createDataCoverageOutput(fileData);
    }

    @Nullable
    private PathCoverageOutput createPathCoverageOutput(@Nonnull FileCoverageData fileData) {
        if (Metrics.PathCoverage.active) {
            Collection<MethodCoverageData> methods = fileData.getMethods();
            return methods.isEmpty() ? null : new PathCoverageOutput(this.output, methods);
        }
        return null;
    }

    @Nullable
    private static DataCoverageOutput createDataCoverageOutput(@Nonnull FileCoverageData fileData) {
        if (Metrics.DataCoverage.active) {
            PerFileDataCoverage dataCoverageInfo = fileData.dataCoverageInfo;
            return dataCoverageInfo.hasFields() ? new DataCoverageOutput(dataCoverageInfo) : null;
        }
        return null;
    }

    public void generate() throws IOException {
        try {
            this.writeHeader();
            this.writeFormattedSourceLines();
            this.writeFooter();
        }
        finally {
            this.inputFile.close();
            this.output.close();
        }
    }

    private void writeHeader() {
        this.output.writeCommonHeader(this.inputFile.getSourceFileName());
        this.output.println("  <table cellpadding='0' cellspacing='1'>");
        this.output.println("    <caption>" + this.inputFile.getSourceFilePath() + "</caption>");
    }

    private void writeFormattedSourceLines() throws IOException {
        String line;
        LineParser lineParser = this.fileParser.lineParser;
        while ((line = this.inputFile.nextLine()) != null) {
            boolean lineWithCodeElements = this.fileParser.parseCurrentLine(line);
            if (lineWithCodeElements) {
                if (this.dataCoverage != null) {
                    this.dataCoverage.writeCoverageInfoIfLineStartsANewFieldDeclaration(this.fileParser);
                }
                if (this.pathCoverage != null) {
                    this.pathCoverage.writePathCoverageInfoIfLineStartsANewMethodOrConstructor(lineParser.getNumber());
                }
            }
            if (this.neutralOutput.writeLineWithoutCoverageInfo(lineParser)) continue;
            this.writeOpeningOfNewLine(lineParser.getNumber());
            if (!this.lineCoverage.writeLineWithCoverageInfo(lineParser)) {
                this.writeLineWithoutCoverageInfo(lineParser.getInitialElement());
            }
            this.output.println("    </tr>");
        }
    }

    private void writeOpeningOfNewLine(int lineNumber) {
        this.output.println("    <tr>");
        this.output.write("      <td class='line'>");
        this.output.print(lineNumber);
        this.output.write("</td>");
    }

    private void writeLineWithoutCoverageInfo(@Nonnull LineElement initialElement) {
        this.output.println("<td>&nbsp;</td>");
        this.output.write("      <td><pre class='");
        this.output.write(initialElement.isComment() ? "comment'>" : "prettyprint'>");
        this.output.write(initialElement.toString());
        this.output.println("</pre></td>");
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.writeCommonFooter();
    }
}

