/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.MockUp;
import mockit.internal.faking.FakeStates;
import mockit.internal.util.ClassLoad;

public final class FakeClasses {
    private static final Method ON_TEAR_DOWN_METHOD;
    @Nonnull
    private final Map<String, MockUp<?>> startupFakes = new IdentityHashMap(8);
    @Nonnull
    private final Map<Class<?>, MockUp<?>> fakeClassesToFakeInstances = new IdentityHashMap();
    @Nonnull
    public final FakeStates fakeStates = new FakeStates();

    private static void notifyOfTearDown(@Nonnull MockUp<?> fake) {
        try {
            ON_TEAR_DOWN_METHOD.invoke(fake, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
    }

    void addFake(@Nonnull String fakeClassDesc, @Nonnull MockUp<?> fake) {
        this.startupFakes.put(fakeClassDesc, fake);
    }

    void addFake(@Nonnull MockUp<?> fake) {
        Class<?> fakeClass = fake.getClass();
        this.fakeClassesToFakeInstances.put(fakeClass, fake);
    }

    @Nonnull
    public MockUp<?> getFake(@Nonnull String fakeClassDesc) {
        MockUp<?> startupFake = this.startupFakes.get(fakeClassDesc);
        if (startupFake != null) {
            return startupFake;
        }
        Class fakeClass = ClassLoad.loadByInternalName(fakeClassDesc);
        MockUp<?> fakeInstance = this.fakeClassesToFakeInstances.get(fakeClass);
        return fakeInstance;
    }

    public void discardStartupFakes() {
        for (MockUp<?> startupFake : this.startupFakes.values()) {
            FakeClasses.notifyOfTearDown(startupFake);
        }
    }

    static {
        try {
            ON_TEAR_DOWN_METHOD = MockUp.class.getDeclaredMethod("onTearDown", new Class[0]);
            ON_TEAR_DOWN_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public final class SavePoint {
        @Nonnull
        private final Map<Class<?>, Boolean> previousFakeClasses = new IdentityHashMap();

        public SavePoint() {
            for (Map.Entry fakeClassAndInstance : FakeClasses.this.fakeClassesToFakeInstances.entrySet()) {
                Class fakeClass = (Class)fakeClassAndInstance.getKey();
                this.previousFakeClasses.put(fakeClass, false);
            }
        }

        public void rollback() {
            if (this.previousFakeClasses.isEmpty()) {
                this.discardAllFakeInstances();
            } else {
                this.discardFakeInstancesExceptPreviousOnes();
            }
        }

        private void discardAllFakeInstances() {
            if (!FakeClasses.this.fakeClassesToFakeInstances.isEmpty()) {
                for (MockUp fakeInstance : FakeClasses.this.fakeClassesToFakeInstances.values()) {
                    FakeClasses.notifyOfTearDown(fakeInstance);
                }
                FakeClasses.this.fakeClassesToFakeInstances.clear();
            }
        }

        private void discardFakeInstancesExceptPreviousOnes() {
            for (Map.Entry fakeClassAndInstances : FakeClasses.this.fakeClassesToFakeInstances.entrySet()) {
                Class fakeClass = (Class)fakeClassAndInstances.getKey();
                if (this.previousFakeClasses.containsKey(fakeClass)) continue;
                MockUp fakeInstance = (MockUp)fakeClassAndInstances.getValue();
                FakeClasses.notifyOfTearDown(fakeInstance);
            }
            FakeClasses.this.fakeClassesToFakeInstances.keySet().retainAll(this.previousFakeClasses.keySet());
        }
    }
}

