/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.classes.ClassReader;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.BootstrapMethodItem;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.constantPool.InvokeDynamicItem;
import mockit.asm.constantPool.Item;
import mockit.asm.constantPool.MethodHandleItem;
import mockit.asm.util.ByteVector;
import mockit.asm.util.MethodHandle;

final class BootstrapMethodsWriter
extends AttributeWriter {
    @Nonnull
    private final ByteVector bootstrapMethods;
    @Nonnegative
    private final int bootstrapMethodsCount;
    @Nonnegative
    private final int bsmStartCodeIndex;

    BootstrapMethodsWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull ClassReader cr) {
        super(cp);
        int attrSize = cr.readInt();
        this.bootstrapMethods = new ByteVector(attrSize + 62);
        this.bootstrapMethodsCount = cr.readUnsignedShort();
        this.bsmStartCodeIndex = cr.codeIndex;
        this.bootstrapMethods.putByteArray(cr.code, this.bsmStartCodeIndex, attrSize - 2);
    }

    void copyBootstrapMethods(@Nonnull ClassReader cr, @Nonnull Item[] items) {
        int previousCodeIndex = cr.codeIndex;
        cr.codeIndex = this.bsmStartCodeIndex;
        int bsmCount = this.bootstrapMethodsCount;
        for (int bsmIndex = 0; bsmIndex < bsmCount; ++bsmIndex) {
            this.copyBootstrapMethod(cr, items, bsmIndex);
        }
        cr.codeIndex = previousCodeIndex;
    }

    private void copyBootstrapMethod(@Nonnull ClassReader cr, @Nonnull Item[] items, @Nonnegative int bsmIndex) {
        int position = cr.codeIndex - this.bsmStartCodeIndex;
        MethodHandle bsm = cr.readMethodHandle();
        int hashCode = bsm.hashCode();
        for (int bsmArgCount = cr.readUnsignedShort(); bsmArgCount > 0; --bsmArgCount) {
            Object bsmArg = cr.readConstItem();
            hashCode ^= bsmArg.hashCode();
        }
        BootstrapMethodItem item = new BootstrapMethodItem(bsmIndex, position, hashCode);
        item.setNext(items);
    }

    @Nonnull
    InvokeDynamicItem addInvokeDynamicReference(@Nonnull String name, @Nonnull String desc, @Nonnull MethodHandle bsm, Object ... bsmArgs) {
        ByteVector methods = this.bootstrapMethods;
        int position = methods.getLength();
        MethodHandleItem methodHandleItem = this.cp.newMethodHandleItem(bsm);
        methods.putShort(methodHandleItem.index);
        int argsLength = bsmArgs.length;
        methods.putShort(argsLength);
        int hashCode = bsm.hashCode();
        hashCode = this.putBSMArgs(hashCode, bsmArgs);
        methods.setLength(position);
        BootstrapMethodItem bsmItem = this.getBSMItem(hashCode &= Integer.MAX_VALUE);
        InvokeDynamicItem result = this.cp.createInvokeDynamicItem(name, desc, bsmItem.index);
        return result;
    }

    private int putBSMArgs(int hashCode, @Nonnull Object[] bsmArgs) {
        for (Object bsmArg : bsmArgs) {
            hashCode ^= bsmArg.hashCode();
            Item constItem = this.cp.newConstItem(bsmArg);
            this.bootstrapMethods.putShort(constItem.index);
        }
        return hashCode;
    }

    @Nonnull
    private BootstrapMethodItem getBSMItem(@Nonnegative int hashCode) {
        for (Item item = this.cp.getItem(hashCode); item != null; item = item.getNext()) {
            if (!(item instanceof BootstrapMethodItem) || item.getHashCode() != hashCode) continue;
            return (BootstrapMethodItem)item;
        }
        throw new IllegalStateException("BootstrapMethodItem not found for hash code " + hashCode);
    }

    @Override
    @Nonnegative
    public int getSize() {
        return 8 + this.bootstrapMethods.getLength();
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        this.setAttribute("BootstrapMethods");
        this.put(out, 2 + this.bootstrapMethods.getLength());
        out.putShort(this.bootstrapMethodsCount);
        out.putByteVector(this.bootstrapMethods);
    }
}

