/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.BaseWriter;
import mockit.asm.SignatureWriter;
import mockit.asm.classes.BootstrapMethodsWriter;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.classes.ConstantPoolCopying;
import mockit.asm.classes.InnerClassesWriter;
import mockit.asm.classes.InterfaceWriter;
import mockit.asm.classes.NestHostWriter;
import mockit.asm.classes.NestMembersWriter;
import mockit.asm.classes.SourceFileWriter;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.constantPool.InvokeDynamicItem;
import mockit.asm.fields.FieldVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.asm.util.ByteVector;
import mockit.asm.util.MethodHandle;
import mockit.internal.util.ClassLoad;

public final class ClassWriter
extends ClassVisitor {
    @Nonnull
    public final byte[] code;
    private int classVersion;
    @Nonnegative
    private int nameItemIndex;
    private String thisName;
    @Nonnegative
    private int superNameItemIndex;
    @Nonnull
    private final List<AttributeWriter> attributeWriters;
    @Nullable
    final BootstrapMethodsWriter bootstrapMethodsWriter;
    @Nullable
    private InterfaceWriter interfaceWriter;
    @Nullable
    private InnerClassesWriter innerClassesWriter;
    @Nonnull
    private final List<FieldVisitor> fields;
    @Nonnull
    private final List<MethodWriter> methods;

    public ClassWriter(@Nonnull ClassReader classReader) {
        this.code = classReader.code;
        this.classVersion = classReader.getVersion();
        this.cp = new ConstantPoolGeneration();
        this.bootstrapMethodsWriter = classReader.positionAtBootstrapMethodsAttribute() ? new BootstrapMethodsWriter(this.cp, classReader) : null;
        new ConstantPoolCopying(classReader, this).copyPool(this.bootstrapMethodsWriter);
        this.attributeWriters = new ArrayList<AttributeWriter>(5);
        if (this.bootstrapMethodsWriter != null) {
            this.attributeWriters.add(this.bootstrapMethodsWriter);
        }
        this.fields = new ArrayList<FieldVisitor>();
        this.methods = new ArrayList<MethodWriter>();
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public String getInternalClassName() {
        return this.thisName;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        this.classVersion = version;
        this.classOrMemberAccess = access;
        this.nameItemIndex = this.cp.newClass(name);
        this.thisName = name;
        this.createMarkerAttributes(version);
        String superName = additionalInfo.superName;
        this.superNameItemIndex = superName == null ? 0 : this.cp.newClass(superName);
        this.createInterfaceWriterIfApplicable(additionalInfo.interfaces);
        this.createSignatureWriterIfApplicable(additionalInfo.signature);
        this.createSourceFileWriterIfApplicable(additionalInfo.sourceFileName);
        this.createNestWritersIfApplicable(additionalInfo.hostClassName, additionalInfo.nestMembers);
        if (superName != null) {
            ClassLoad.addSuperClass(name, superName);
        }
    }

    private void createInterfaceWriterIfApplicable(@Nonnull String[] interfaces) {
        if (interfaces.length > 0) {
            this.interfaceWriter = new InterfaceWriter(this.cp, interfaces);
        }
    }

    private void createSignatureWriterIfApplicable(@Nullable String signature) {
        if (signature != null) {
            this.attributeWriters.add(new SignatureWriter(this.cp, signature));
        }
    }

    private void createSourceFileWriterIfApplicable(@Nullable String sourceFileName) {
        if (sourceFileName != null) {
            this.attributeWriters.add(new SourceFileWriter(this.cp, sourceFileName));
        }
    }

    private void createNestWritersIfApplicable(@Nullable String hostClassName, @Nullable String[] memberClassNames) {
        if (hostClassName != null) {
            this.attributeWriters.add(new NestHostWriter(this.cp, hostClassName));
        } else if (memberClassNames != null) {
            this.attributeWriters.add(new NestMembersWriter(this.cp, memberClassNames));
        }
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        if (this.innerClassesWriter == null) {
            this.innerClassesWriter = new InnerClassesWriter(this.cp);
            this.attributeWriters.add(this.innerClassesWriter);
        }
        this.innerClassesWriter.add(name, outerName, innerName, access);
    }

    @Override
    @Nonnull
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        FieldVisitor field = new FieldVisitor(this, access, name, desc, signature, value);
        this.fields.add(field);
        return field;
    }

    @Override
    @Nonnull
    public MethodWriter visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        boolean computeFrames = this.classVersion >= 51;
        MethodWriter method = new MethodWriter(this, access, name, desc, signature, exceptions, computeFrames);
        this.methods.add(method);
        return method;
    }

    @Override
    @Nonnull
    public byte[] toByteArray() {
        this.cp.checkConstantPoolMaxSize();
        int size = this.getBytecodeSize();
        ByteVector out = new ByteVector(size);
        this.putClassAttributes(out);
        this.putAnnotations(out);
        return out.getData();
    }

    @Nonnegative
    private int getBytecodeSize() {
        int size = 24 + this.getMarkerAttributesSize() + this.getFieldsSize() + this.getMethodsSize();
        if (this.interfaceWriter != null) {
            size += this.interfaceWriter.getSize();
        }
        for (AttributeWriter attributeWriter : this.attributeWriters) {
            size += attributeWriter.getSize();
        }
        return size + this.getAnnotationsSize() + this.cp.getSize();
    }

    @Nonnegative
    private int getFieldsSize() {
        int size = 0;
        for (FieldVisitor fv : this.fields) {
            size += fv.getSize();
        }
        return size;
    }

    @Nonnegative
    private int getMethodsSize() {
        int size = 0;
        for (MethodWriter mb : this.methods) {
            size += mb.getSize();
        }
        return size;
    }

    private void putClassAttributes(@Nonnull ByteVector out) {
        out.putInt(-889275714).putInt(this.classVersion);
        this.cp.put(out);
        this.putAccess(out, 0);
        out.putShort(this.nameItemIndex).putShort(this.superNameItemIndex);
        if (this.interfaceWriter == null) {
            out.putShort(0);
        } else {
            this.interfaceWriter.put(out);
        }
        BaseWriter.put(out, this.fields);
        BaseWriter.put(out, this.methods);
        int attributeCount = this.getAttributeCount();
        out.putShort(attributeCount);
        for (AttributeWriter attributeWriter : this.attributeWriters) {
            attributeWriter.put(out);
        }
        this.putMarkerAttributes(out);
    }

    @Nonnegative
    private int getAttributeCount() {
        int attributeCount = this.getMarkerAttributeCount() + this.attributeWriters.size();
        if (this.annotations != null) {
            ++attributeCount;
        }
        return attributeCount;
    }

    @Nonnull
    public InvokeDynamicItem addInvokeDynamicReference(@Nonnull String name, @Nonnull String desc, @Nonnull MethodHandle bsm, Object ... bsmArgs) {
        assert (this.bootstrapMethodsWriter != null);
        return this.bootstrapMethodsWriter.addInvokeDynamicReference(name, desc, bsm, bsmArgs);
    }

    public boolean isJava6OrNewer() {
        return this.classVersion >= 50;
    }
}

