/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.springframework;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.springframework.BeanLookup;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.state.TestRun;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public final class FakeBeanFactory
extends MockUp<DefaultListableBeanFactory> {
    @Mock
    public static Object getBean(@Nonnull Invocation invocation, @Nonnull String name) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses == null) {
            return invocation.proceed(new Object[0]);
        }
        BeanExporter beanExporter = testedClasses.getBeanExporter();
        Object bean = BeanLookup.getBean(beanExporter, name);
        return bean;
    }

    @Mock
    public static <T> T getBean(@Nonnull Invocation invocation, @Nonnull String name, @Nullable Class<T> requiredType) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses == null) {
            return invocation.proceed(new Object[0]);
        }
        BeanExporter beanExporter = testedClasses.getBeanExporter();
        T bean = BeanLookup.getBean(beanExporter, name, requiredType);
        return bean;
    }

    @Mock
    public static <T> T getBean(@Nonnull Invocation invocation, @Nonnull Class<T> requiredType) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses == null) {
            return invocation.proceed(new Object[0]);
        }
        BeanExporter beanExporter = testedClasses.getBeanExporter();
        T bean = BeanLookup.getBean(beanExporter, requiredType);
        return bean;
    }
}

