/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.CaptureMatcher;
import mockit.internal.expectations.argumentMatching.EqualityMatcher;
import mockit.internal.expectations.argumentMatching.LenientEqualityMatcher;
import mockit.internal.expectations.invocation.ArgumentValuesAndMatchers;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.expectations.invocation.UnexpectedInvocation;

final class ArgumentValuesAndMatchersWithVarargs
extends ArgumentValuesAndMatchers {
    private static final Object[] NULL_VARARGS = new Object[0];

    ArgumentValuesAndMatchersWithVarargs(@Nonnull InvocationArguments signature, @Nonnull Object[] values) {
        super(signature, values);
    }

    @Override
    boolean isMatch(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        if (this.matchers == null) {
            return this.areEqual(replayArgs, instanceMap);
        }
        VarargsComparison varargsComparison = new VarargsComparison(replayArgs);
        int totalArgCount = varargsComparison.getTotalArgumentCountWhenDifferent();
        int regularArgCount = varargsComparison.regularArgCount;
        if (totalArgCount < 0) {
            return false;
        }
        for (int i = 0; i < totalArgCount; ++i) {
            Object[] actual = varargsComparison.getOtherArgument(i);
            LenientEqualityMatcher expected = this.getArgumentMatcher(i);
            if (expected == null) {
                Object arg = varargsComparison.getThisArgument(i);
                if (arg == null) continue;
                expected = new LenientEqualityMatcher(arg, instanceMap);
            } else if (i == regularArgCount && expected instanceof CaptureMatcher) {
                actual = varargsComparison.getOtherVarArgs();
                i = totalArgCount;
            }
            if (expected.matches(actual)) continue;
            return false;
        }
        return true;
    }

    private boolean areEqual(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        int argCount = replayArgs.length;
        if (!ArgumentValuesAndMatchersWithVarargs.areEqual(this.values, replayArgs, argCount - 1, instanceMap)) {
            return false;
        }
        VarargsComparison varargsComparison = new VarargsComparison(replayArgs);
        Object[] expectedValues = varargsComparison.getThisVarArgs();
        Object[] actualValues = varargsComparison.getOtherVarArgs();
        return varargsComparison.sameVarargArrayLength() && ArgumentValuesAndMatchersWithVarargs.areEqual(expectedValues, actualValues, expectedValues.length, instanceMap);
    }

    @Override
    @Nullable
    Error assertMatch(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        if (this.matchers == null) {
            return this.assertEquality(replayArgs, instanceMap);
        }
        VarargsComparison varargsComparison = new VarargsComparison(replayArgs);
        int n = varargsComparison.getTotalArgumentCountWhenDifferent();
        if (n < 0) {
            return varargsComparison.errorForVarargsArraysOfDifferentLengths();
        }
        for (int i = 0; i < n; ++i) {
            Object actual = varargsComparison.getOtherArgument(i);
            LenientEqualityMatcher expected = this.getArgumentMatcher(i);
            if (expected == null) {
                Object arg = varargsComparison.getThisArgument(i);
                if (arg == null) continue;
                expected = new LenientEqualityMatcher(arg, instanceMap);
            }
            if (expected.matches(actual)) continue;
            int paramIndex = i < replayArgs.length ? i : replayArgs.length - 1;
            return this.signature.argumentMismatchMessage(paramIndex, expected, actual);
        }
        return null;
    }

    @Nullable
    private Error assertEquality(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        int argCount = replayArgs.length;
        Error nonVarargsError = this.assertEquals(this.values, replayArgs, argCount - 1, instanceMap);
        if (nonVarargsError != null) {
            return nonVarargsError;
        }
        VarargsComparison varargsComparison = new VarargsComparison(replayArgs);
        Object[] expectedValues = varargsComparison.getThisVarArgs();
        Object[] actualValues = varargsComparison.getOtherVarArgs();
        if (!varargsComparison.sameVarargArrayLength()) {
            return varargsComparison.errorForVarargsArraysOfDifferentLengths();
        }
        Error varargsError = this.assertEquals(expectedValues, actualValues, expectedValues.length, instanceMap);
        if (varargsError != null) {
            return new UnexpectedInvocation("Varargs " + varargsError);
        }
        return null;
    }

    @Override
    boolean hasEquivalentMatchers(@Nonnull ArgumentValuesAndMatchers other) {
        int i = this.indexOfFirstValueAfterEquivalentMatchers(other);
        if (i < 0) {
            return false;
        }
        VarargsComparison varargsComparison = new VarargsComparison(other.values);
        int n = varargsComparison.getTotalArgumentCountWhenDifferent();
        if (n < 0) {
            return false;
        }
        while (i < n) {
            Object otherArg;
            Object thisArg = varargsComparison.getThisArgument(i);
            if (!EqualityMatcher.areEqual(thisArg, otherArg = varargsComparison.getOtherArgument(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final class VarargsComparison {
        @Nonnull
        private final Object[] otherValues;
        @Nullable
        private final Object[] thisVarArgs;
        @Nullable
        private final Object[] otherVarArgs;
        final int regularArgCount;

        VarargsComparison(Object[] otherValues) {
            this.otherValues = otherValues;
            this.thisVarArgs = this.getVarArgs(ArgumentValuesAndMatchersWithVarargs.this.values);
            this.otherVarArgs = this.getVarArgs(otherValues);
            this.regularArgCount = ArgumentValuesAndMatchersWithVarargs.this.values.length - 1;
        }

        @Nonnull
        Object[] getThisVarArgs() {
            return this.thisVarArgs == null ? NULL_VARARGS : this.thisVarArgs;
        }

        @Nonnull
        Object[] getOtherVarArgs() {
            return this.otherVarArgs == null ? NULL_VARARGS : this.otherVarArgs;
        }

        @Nullable
        private Object[] getVarArgs(@Nonnull Object[] args) {
            Object lastArg = args[args.length - 1];
            if (lastArg == null) {
                return null;
            }
            if (lastArg instanceof Object[]) {
                return (Object[])lastArg;
            }
            int varArgsLength = Array.getLength(lastArg);
            Object[] results = new Object[varArgsLength];
            for (int i = 0; i < varArgsLength; ++i) {
                results[i] = Array.get(lastArg, i);
            }
            return results;
        }

        int getTotalArgumentCountWhenDifferent() {
            if (this.thisVarArgs == null) {
                return this.regularArgCount + 1;
            }
            if (!this.sameVarargArrayLength()) {
                return -1;
            }
            return this.regularArgCount + this.thisVarArgs.length;
        }

        boolean sameVarargArrayLength() {
            return this.getThisVarArgs().length == this.getOtherVarArgs().length;
        }

        @Nullable
        Object getThisArgument(int parameter) {
            if (parameter < this.regularArgCount) {
                return ArgumentValuesAndMatchersWithVarargs.this.values[parameter];
            }
            int p = parameter - this.regularArgCount;
            if (this.thisVarArgs == null || p >= this.thisVarArgs.length) {
                return null;
            }
            return this.thisVarArgs[p];
        }

        @Nullable
        Object getOtherArgument(int parameter) {
            if (parameter < this.regularArgCount) {
                return this.otherValues[parameter];
            }
            int p = parameter - this.regularArgCount;
            if (this.otherVarArgs == null || p >= this.otherVarArgs.length) {
                return null;
            }
            return this.otherVarArgs[p];
        }

        @Nonnull
        Error errorForVarargsArraysOfDifferentLengths() {
            int n = this.getThisVarArgs().length;
            int m = this.getOtherVarArgs().length;
            return new UnexpectedInvocation("Expected " + n + " values for varargs parameter, got " + m);
        }
    }
}

