// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

package filestorepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudFilestoreManager_ListInstances_FullMethodName   = "/google.cloud.filestore.v1.CloudFilestoreManager/ListInstances"
	CloudFilestoreManager_GetInstance_FullMethodName     = "/google.cloud.filestore.v1.CloudFilestoreManager/GetInstance"
	CloudFilestoreManager_CreateInstance_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/CreateInstance"
	CloudFilestoreManager_UpdateInstance_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateInstance"
	CloudFilestoreManager_RestoreInstance_FullMethodName = "/google.cloud.filestore.v1.CloudFilestoreManager/RestoreInstance"
	CloudFilestoreManager_RevertInstance_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/RevertInstance"
	CloudFilestoreManager_DeleteInstance_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteInstance"
	CloudFilestoreManager_ListSnapshots_FullMethodName   = "/google.cloud.filestore.v1.CloudFilestoreManager/ListSnapshots"
	CloudFilestoreManager_GetSnapshot_FullMethodName     = "/google.cloud.filestore.v1.CloudFilestoreManager/GetSnapshot"
	CloudFilestoreManager_CreateSnapshot_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/CreateSnapshot"
	CloudFilestoreManager_DeleteSnapshot_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteSnapshot"
	CloudFilestoreManager_UpdateSnapshot_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateSnapshot"
	CloudFilestoreManager_ListBackups_FullMethodName     = "/google.cloud.filestore.v1.CloudFilestoreManager/ListBackups"
	CloudFilestoreManager_GetBackup_FullMethodName       = "/google.cloud.filestore.v1.CloudFilestoreManager/GetBackup"
	CloudFilestoreManager_CreateBackup_FullMethodName    = "/google.cloud.filestore.v1.CloudFilestoreManager/CreateBackup"
	CloudFilestoreManager_DeleteBackup_FullMethodName    = "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteBackup"
	CloudFilestoreManager_UpdateBackup_FullMethodName    = "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateBackup"
	CloudFilestoreManager_PromoteReplica_FullMethodName  = "/google.cloud.filestore.v1.CloudFilestoreManager/PromoteReplica"
)

// CloudFilestoreManagerClient is the client API for CloudFilestoreManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudFilestoreManagerClient interface {
	// Lists all instances in a project for either a specified location
	// or for all locations.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance.
	// When creating from a backup, the capacity of the new instance needs to be
	// equal to or larger than the capacity of the backup (and also equal to or
	// larger than the minimum capacity of the tier).
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific instance.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores an existing instance's file share from a backup.
	//
	// The capacity of the instance needs to be equal to or larger than the
	// capacity of the backup (and also equal to or larger than the minimum
	// capacity of the tier).
	RestoreInstance(ctx context.Context, in *RestoreInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Revert an existing instance's file system to a specified snapshot.
	RevertInstance(ctx context.Context, in *RevertInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all snapshots in a project for either a specified location
	// or for all locations.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Gets the details of a specific snapshot.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Creates a snapshot.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all backups in a project for either a specified location or for all
	// locations.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Creates a backup.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Promote the standby instance (replica).
	PromoteReplica(ctx context.Context, in *PromoteReplicaRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudFilestoreManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudFilestoreManagerClient(cc grpc.ClientConnInterface) CloudFilestoreManagerClient {
	return &cloudFilestoreManagerClient{cc}
}

func (c *cloudFilestoreManagerClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) RestoreInstance(ctx context.Context, in *RestoreInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_RestoreInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) RevertInstance(ctx context.Context, in *RevertInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_RevertInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_ListSnapshots_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_GetSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_CreateSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_DeleteSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_UpdateSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_CreateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_UpdateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) PromoteReplica(ctx context.Context, in *PromoteReplicaRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFilestoreManager_PromoteReplica_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFilestoreManagerServer is the server API for CloudFilestoreManager service.
// All implementations should embed UnimplementedCloudFilestoreManagerServer
// for forward compatibility
type CloudFilestoreManagerServer interface {
	// Lists all instances in a project for either a specified location
	// or for all locations.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance.
	// When creating from a backup, the capacity of the new instance needs to be
	// equal to or larger than the capacity of the backup (and also equal to or
	// larger than the minimum capacity of the tier).
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific instance.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Restores an existing instance's file share from a backup.
	//
	// The capacity of the instance needs to be equal to or larger than the
	// capacity of the backup (and also equal to or larger than the minimum
	// capacity of the tier).
	RestoreInstance(context.Context, *RestoreInstanceRequest) (*longrunningpb.Operation, error)
	// Revert an existing instance's file system to a specified snapshot.
	RevertInstance(context.Context, *RevertInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes an instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Lists all snapshots in a project for either a specified location
	// or for all locations.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Gets the details of a specific snapshot.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Creates a snapshot.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error)
	// Lists all backups in a project for either a specified location or for all
	// locations.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Creates a backup.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes a backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error)
	// Promote the standby instance (replica).
	PromoteReplica(context.Context, *PromoteReplicaRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudFilestoreManagerServer should be embedded to have forward compatible implementations.
type UnimplementedCloudFilestoreManagerServer struct {
}

func (UnimplementedCloudFilestoreManagerServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) RestoreInstance(context.Context, *RestoreInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) RevertInstance(context.Context, *RevertInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevertInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnapshot not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (UnimplementedCloudFilestoreManagerServer) PromoteReplica(context.Context, *PromoteReplicaRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteReplica not implemented")
}

// UnsafeCloudFilestoreManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudFilestoreManagerServer will
// result in compilation errors.
type UnsafeCloudFilestoreManagerServer interface {
	mustEmbedUnimplementedCloudFilestoreManagerServer()
}

func RegisterCloudFilestoreManagerServer(s grpc.ServiceRegistrar, srv CloudFilestoreManagerServer) {
	s.RegisterService(&CloudFilestoreManager_ServiceDesc, srv)
}

func _CloudFilestoreManager_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_RestoreInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).RestoreInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_RestoreInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).RestoreInstance(ctx, req.(*RestoreInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_RevertInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevertInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).RevertInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_RevertInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).RevertInstance(ctx, req.(*RevertInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_ListSnapshots_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_GetSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_CreateSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_DeleteSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_UpdateSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateSnapshot(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_CreateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_UpdateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_PromoteReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PromoteReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).PromoteReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFilestoreManager_PromoteReplica_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).PromoteReplica(ctx, req.(*PromoteReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudFilestoreManager_ServiceDesc is the grpc.ServiceDesc for CloudFilestoreManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudFilestoreManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.filestore.v1.CloudFilestoreManager",
	HandlerType: (*CloudFilestoreManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudFilestoreManager_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudFilestoreManager_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudFilestoreManager_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudFilestoreManager_UpdateInstance_Handler,
		},
		{
			MethodName: "RestoreInstance",
			Handler:    _CloudFilestoreManager_RestoreInstance_Handler,
		},
		{
			MethodName: "RevertInstance",
			Handler:    _CloudFilestoreManager_RevertInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudFilestoreManager_DeleteInstance_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _CloudFilestoreManager_ListSnapshots_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _CloudFilestoreManager_GetSnapshot_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _CloudFilestoreManager_CreateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _CloudFilestoreManager_DeleteSnapshot_Handler,
		},
		{
			MethodName: "UpdateSnapshot",
			Handler:    _CloudFilestoreManager_UpdateSnapshot_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _CloudFilestoreManager_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _CloudFilestoreManager_GetBackup_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _CloudFilestoreManager_CreateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _CloudFilestoreManager_DeleteBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _CloudFilestoreManager_UpdateBackup_Handler,
		},
		{
			MethodName: "PromoteReplica",
			Handler:    _CloudFilestoreManager_PromoteReplica_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/filestore/v1/cloud_filestore_service.proto",
}
