/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.REMatchState;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_CLASS = 50;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_END = 53;
    private static final int OFFSET_LEN = 2;
    private static final int ARG_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_toSource = 8;
    private static final int Id_exec = 9;
    private static final int Id_test = 10;
    private static final int Id_prefix = 11;
    private static final int MAX_PROTOTYPE_ID = 11;
    private boolean prototypeFlag;
    RECompiled re;
    private double lastIndex;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeRegExp proto = new NativeRegExp();
        proto.re = (RECompiled)NativeRegExp.compileRE("", null, false);
        proto.prototypeFlag = true;
        proto.setMaxId(11);
        proto.setParentScope(scope);
        proto.setPrototype(ScriptableObject.getObjectPrototype(scope));
        NativeRegExpCtor ctor = new NativeRegExpCtor();
        ScriptRuntime.setFunctionProtoAndParent(scope, ctor);
        ctor.setImmunePrototypeProperty(proto);
        if (sealed) {
            proto.sealObject();
            ctor.sealObject();
        }
        ScriptableObject.defineProperty(scope, "RegExp", ctor, 2);
    }

    NativeRegExp(Scriptable scope, Object regexpCompiled) {
        this.setMaxId(5);
        this.re = (RECompiled)regexpCompiled;
        this.lastIndex = 0.0;
        scope = ScriptableObject.getTopLevelScope(scope);
        this.setPrototype(ScriptableObject.getClassPrototype(scope, "RegExp"));
        this.setParentScope(scope);
    }

    public String getClassName() {
        return "RegExp";
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.execSub(cx, scope, args, 1);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return (Scriptable)this.execSub(cx, scope, args, 1);
    }

    Scriptable compile(Context cx, Scriptable scope, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp) {
            if (args.length > 1 && args[1] != Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.bad.regexp.compile");
            }
            NativeRegExp thatObj = (NativeRegExp)args[0];
            this.re = thatObj.re;
            this.lastIndex = thatObj.lastIndex;
            return this;
        }
        String s = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
        String global = args.length > 1 && args[1] != Undefined.instance ? ScriptRuntime.toString(args[1]) : null;
        this.re = (RECompiled)NativeRegExp.compileRE(s, global, false);
        this.lastIndex = 0.0;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('/');
        if (this.re.source.length != 0) {
            buf.append(this.re.source);
        } else {
            buf.append("(?:)");
        }
        buf.append('/');
        if ((this.re.flags & 1) != 0) {
            buf.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            buf.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            buf.append('m');
        }
        return buf.toString();
    }

    NativeRegExp() {
        this.setMaxId(5);
    }

    private static RegExpImpl getImpl(Context cx) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    private Object execSub(Context cx, Scriptable scopeObj, Object[] args, int matchType) {
        Object rval;
        double d;
        String str;
        RegExpImpl reImpl = NativeRegExp.getImpl(cx);
        if (args.length == 0) {
            str = reImpl.input;
            if (str == null) {
                NativeRegExp.reportError("msg.no.re.input.for", this.toString());
            }
        } else {
            str = ScriptRuntime.toString(args[0]);
        }
        double d2 = d = (this.re.flags & 1) != 0 ? this.lastIndex : 0.0;
        if (d < 0.0 || (double)str.length() < d) {
            this.lastIndex = 0.0;
            rval = null;
        } else {
            int[] indexp = new int[]{(int)d};
            rval = this.executeRegExp(cx, scopeObj, reImpl, str, indexp, matchType);
            if ((this.re.flags & 1) != 0) {
                this.lastIndex = rval == null || rval == Undefined.instance ? 0.0 : (double)indexp[0];
            }
        }
        return rval;
    }

    static Object compileRE(String str, String global, boolean flat) {
        RECompiled regexp = new RECompiled();
        regexp.source = str.toCharArray();
        int length = str.length();
        int flags = 0;
        if (global != null) {
            int i = 0;
            while (i < global.length()) {
                char c = global.charAt(i);
                if (c == 'g') {
                    flags |= 1;
                } else if (c == 'i') {
                    flags |= 2;
                } else if (c == 'm') {
                    flags |= 4;
                } else {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf(c));
                }
                ++i;
            }
        }
        regexp.flags = flags;
        CompilerState state = new CompilerState(regexp.source, length, flags);
        if (flat && length > 0) {
            state.result = new RENode(21);
            state.result.chr = state.cpbegin[0];
            state.result.length = length;
            state.result.flatIndex = 0;
            state.progLength += 5;
        } else if (!NativeRegExp.parseDisjunction(state)) {
            return null;
        }
        regexp.program = new byte[state.progLength + 1];
        if (state.classCount != 0) {
            regexp.classList = new RECharSet[state.classCount];
            int i = 0;
            while (i < state.classCount) {
                regexp.classList[i] = new RECharSet();
                ++i;
            }
            regexp.classCount = state.classCount;
        }
        int endPC = NativeRegExp.emitREBytecode(state, regexp, 0, state.result);
        regexp.program[endPC++] = 53;
        regexp.parenCount = state.parenCount;
        switch (regexp.program[0]) {
            case 28: 
            case 35: {
                regexp.anchorCh = (char)NativeRegExp.GET_ARG(regexp.program, 1);
                break;
            }
            case 22: 
            case 33: {
                regexp.anchorCh = (char)(regexp.program[1] & 0xFF);
                break;
            }
            case 21: 
            case 32: {
                int k = NativeRegExp.GET_ARG(regexp.program, 1);
                regexp.anchorCh = regexp.source[k];
            }
        }
        return regexp;
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean isLineTerm(char c) {
        return TokenStream.isJSLineTerminator(c);
    }

    private static boolean isREWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 8232 || c == 8233 || c == 12 || c == 11 || c == 160 || Character.getType((char)c) == 12;
    }

    private static char upcase(char ch) {
        if (ch < '\u0080') {
            if ('a' <= ch && ch <= 'z') {
                return (char)(ch + -32);
            }
            return ch;
        }
        char cu = Character.toUpperCase(ch);
        if (ch >= '\u0080' && cu < '\u0080') {
            return ch;
        }
        return cu;
    }

    private static char downcase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        char cl = Character.toLowerCase(ch);
        if (ch >= '\u0080' && cl < '\u0080') {
            return ch;
        }
        return cl;
    }

    private static int toASCIIHexDigit(int c) {
        if (c < 48) {
            return -1;
        }
        if (c <= 57) {
            return c - 48;
        }
        if (97 <= (c |= 0x20) && c <= 102) {
            return c - 97 + 10;
        }
        return -1;
    }

    private static boolean parseDisjunction(CompilerState state) {
        int index;
        if (!NativeRegExp.parseAlternative(state)) {
            return false;
        }
        char[] source = state.cpbegin;
        if ((index = state.cp++) != source.length && source[index] == '|') {
            RENode altResult = new RENode(1);
            altResult.kid = state.result;
            if (!NativeRegExp.parseDisjunction(state)) {
                return false;
            }
            altResult.kid2 = state.result;
            state.result = altResult;
            state.progLength += 9;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean parseAlternative(CompilerState state) {
        headTerm = null;
        tailTerm = null;
        source = state.cpbegin;
        block0: while (true) {
            if (state.cp == state.cpend || source[state.cp] == '|' || state.parenNesting != 0 && source[state.cp] == ')') {
                state.result = headTerm == null ? new RENode(0) : headTerm;
                return true;
            }
            if (!NativeRegExp.parseTerm(state)) {
                return false;
            }
            if (headTerm == null) {
                headTerm = state.result;
                continue;
            }
            if (tailTerm == null) {
                headTerm.next = state.result;
                tailTerm = state.result;
                while (true) {
                    if (tailTerm.next == null) continue block0;
                    tailTerm = tailTerm.next;
                }
            }
            tailTerm = tailTerm.next = state.result;
            while (true) {
                if (tailTerm.next != null) ** break;
                continue block0;
                tailTerm = tailTerm.next;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(CompilerState state, RENode target, char[] src, int index, int end) {
        int rangeStart = 0;
        int max = 0;
        boolean inRange = false;
        target.bmsize = 0;
        if (index == end) {
            return true;
        }
        if (src[index] == '^') {
            ++index;
        }
        while (index != end) {
            int localMax = 0;
            int nDigits = 2;
            block0 : switch (src[index]) {
                case '\\': {
                    int n = ++index;
                    ++index;
                    int c = src[n];
                    switch (c) {
                        case 98: {
                            localMax = 8;
                            break block0;
                        }
                        case 102: {
                            localMax = 12;
                            break block0;
                        }
                        case 110: {
                            localMax = 10;
                            break block0;
                        }
                        case 114: {
                            localMax = 13;
                            break block0;
                        }
                        case 116: {
                            localMax = 9;
                            break block0;
                        }
                        case 118: {
                            localMax = 11;
                            break block0;
                        }
                        case 99: {
                            if (index + 1 < end && Character.isLetter(src[index + 1])) {
                                localMax = (char)(src[index++] & 0x1F);
                                break block0;
                            }
                            localMax = 92;
                            break block0;
                        }
                        case 117: {
                            nDigits += 2;
                        }
                        case 120: {
                            int n2 = 0;
                            int i = 0;
                            while (i < nDigits && index < end) {
                                if (!NativeRegExp.isHex((char)(c = src[index++]))) {
                                    index -= i + 1;
                                    n2 = 92;
                                    break;
                                }
                                n2 = n2 << 4 | NativeRegExp.unHex((char)c);
                                ++i;
                            }
                            localMax = n2;
                            break block0;
                        }
                        case 100: {
                            if (inRange) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            localMax = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (inRange) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            target.bmsize = 65535;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int i;
                            int n2 = c - 48;
                            c = src[index];
                            if (48 <= c && c <= 55) {
                                n2 = 8 * n2 + (c - 48);
                                if (48 <= (c = src[++index]) && c <= 55) {
                                    ++index;
                                    i = 8 * n2 + (c - 48);
                                    if (i <= 255) {
                                        n2 = i;
                                    } else {
                                        --index;
                                    }
                                }
                            }
                            localMax = n2;
                            break block0;
                        }
                    }
                    localMax = c;
                    break;
                }
                default: {
                    localMax = src[index++];
                }
            }
            if (inRange) {
                if (rangeStart > localMax) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return false;
                }
                inRange = false;
            } else if (index < end - 1 && src[index] == '-') {
                ++index;
                inRange = true;
                rangeStart = (char)localMax;
                continue;
            }
            if ((state.flags & 2) != 0) {
                int cd;
                int cu = NativeRegExp.upcase((char)localMax);
                int n = localMax = cu >= (cd = NativeRegExp.downcase((char)localMax)) ? cu : cd;
            }
            if (localMax <= max) continue;
            max = localMax;
        }
        target.bmsize = max;
        return true;
    }

    private static void doFlat(CompilerState state, char c) {
        state.result = new RENode(21);
        state.result.chr = c;
        state.result.length = 1;
        state.result.flatIndex = -1;
        state.progLength += 3;
    }

    private static int getDecimalValue(char c, CompilerState state, int maxValue, String overflowMessageId) {
        boolean overflow = false;
        int start = state.cp;
        char[] src = state.cpbegin;
        int value = c - 48;
        while (state.cp != state.cpend) {
            c = src[state.cp];
            if (!NativeRegExp.isDigit(c)) break;
            if (!overflow) {
                int digit = c - 48;
                if (value < (maxValue - digit) / 10) {
                    value = value * 10 + digit;
                } else {
                    overflow = true;
                    value = maxValue;
                }
            }
            ++state.cp;
        }
        if (overflow) {
            NativeRegExp.reportError(overflowMessageId, String.valueOf(src, start, state.cp - start));
        }
        return value;
    }

    private static boolean parseTerm(CompilerState state) {
        char[] src = state.cpbegin;
        char c = src[state.cp++];
        int nDigits = 2;
        int parenBaseCount = state.parenCount;
        int ocp = state.cp;
        block0 : switch (c) {
            case '^': {
                state.result = new RENode(2);
                ++state.progLength;
                return true;
            }
            case '$': {
                state.result = new RENode(3);
                ++state.progLength;
                return true;
            }
            case '\\': {
                if (state.cp < state.cpend) {
                    c = src[state.cp++];
                    switch (c) {
                        case 'b': {
                            state.result = new RENode(4);
                            ++state.progLength;
                            return true;
                        }
                        case 'B': {
                            state.result = new RENode(5);
                            ++state.progLength;
                            return true;
                        }
                        case '0': {
                            int num = 0;
                            while (state.cp < state.cpend) {
                                c = src[state.cp];
                                if (c < 48 || c > 55) break;
                                ++state.cp;
                                int tmp = 8 * num + (c - 48);
                                if (tmp > 255) break;
                                num = tmp;
                            }
                            c = (char)num;
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int termStart = state.cp - 1;
                            int num = NativeRegExp.getDecimalValue(c, state, 65535, "msg.overlarge.backref");
                            if (num > 9 && num > state.parenCount) {
                                state.cp = termStart;
                                num = 0;
                                while (state.cp < state.cpend) {
                                    c = src[state.cp];
                                    if (c < 48 || c > 55) break;
                                    ++state.cp;
                                    int tmp = 8 * num + (c - 48);
                                    if (tmp > 255) break;
                                    num = tmp;
                                }
                                c = (char)num;
                                NativeRegExp.doFlat(state, c);
                                break block0;
                            }
                            state.result = new RENode(20);
                            state.result.parenIndex = num - 1;
                            state.progLength += 3;
                            break block0;
                        }
                        case 'f': {
                            c = '\f';
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'n': {
                            c = '\n';
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'r': {
                            c = '\r';
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 't': {
                            c = '\t';
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'v': {
                            c = '\u000b';
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'c': {
                            if (state.cp + 1 < state.cpend && Character.isLetter(src[state.cp + 1])) {
                                c = (char)(src[state.cp++] & 0x1F);
                            } else {
                                --state.cp;
                                c = '\\';
                            }
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'u': {
                            nDigits += 2;
                        }
                        case 'x': {
                            int n = 0;
                            int i = 0;
                            while (i < nDigits && state.cp < state.cpend) {
                                if (!NativeRegExp.isHex(c = src[state.cp++])) {
                                    state.cp -= i + 2;
                                    n = src[state.cp++];
                                    break;
                                }
                                n = n << 4 | NativeRegExp.unHex(c);
                                ++i;
                            }
                            c = (char)n;
                            NativeRegExp.doFlat(state, c);
                            break block0;
                        }
                        case 'd': {
                            state.result = new RENode(14);
                            ++state.progLength;
                            break block0;
                        }
                        case 'D': {
                            state.result = new RENode(15);
                            ++state.progLength;
                            break block0;
                        }
                        case 's': {
                            state.result = new RENode(18);
                            ++state.progLength;
                            break block0;
                        }
                        case 'S': {
                            state.result = new RENode(19);
                            ++state.progLength;
                            break block0;
                        }
                        case 'w': {
                            state.result = new RENode(16);
                            ++state.progLength;
                            break block0;
                        }
                        case 'W': {
                            state.result = new RENode(17);
                            ++state.progLength;
                            break block0;
                        }
                    }
                    state.result = new RENode(21);
                    state.result.chr = c;
                    state.result.length = 1;
                    state.result.flatIndex = state.cp - 1;
                    state.progLength += 3;
                    break;
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                return false;
            }
            case '(': {
                RENode result = null;
                int termStart = state.cp;
                if (state.cp + 1 < state.cpend && src[state.cp] == '?' && ((c = src[state.cp + 1]) == '=' || c == '!' || c == ':')) {
                    state.cp += 2;
                    if (c == '=') {
                        result = new RENode(41);
                        state.progLength += 4;
                    } else if (c == '!') {
                        result = new RENode(42);
                        state.progLength += 4;
                    }
                } else {
                    result = new RENode(10);
                    state.progLength += 6;
                    result.parenIndex = state.parenCount++;
                }
                ++state.parenNesting;
                if (!NativeRegExp.parseDisjunction(state)) {
                    return false;
                }
                if (state.cp == state.cpend || src[state.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++state.cp;
                --state.parenNesting;
                if (result == null) break;
                result.kid = state.result;
                state.result = result;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                int termStart;
                state.result = new RENode(50);
                state.result.startIndex = termStart = state.cp;
                while (true) {
                    if (state.cp == state.cpend) {
                        NativeRegExp.reportError("msg.unterm.class", "");
                        return false;
                    }
                    if (src[state.cp] == '\\') {
                        ++state.cp;
                    } else if (src[state.cp] == ']') break;
                    ++state.cp;
                }
                state.result.kidlen = state.cp - termStart;
                state.result.index = state.classCount++;
                if (!NativeRegExp.calculateBitmapSize(state, state.result, src, termStart, state.cp++)) {
                    return false;
                }
                state.progLength += 3;
                break;
            }
            case '.': {
                state.result = new RENode(12);
                ++state.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(src[state.cp - 1]));
                return false;
            }
            default: {
                state.result = new RENode(21);
                state.result.chr = c;
                state.result.length = 1;
                state.result.flatIndex = state.cp - 1;
                state.progLength += 3;
            }
        }
        RENode term = state.result;
        if (state.cp == state.cpend) {
            return true;
        }
        boolean hasQ = false;
        switch (src[state.cp]) {
            case '+': {
                state.result = new RENode(6);
                state.result.min = 1;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '*': {
                state.result = new RENode(6);
                state.result.min = 0;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '?': {
                state.result = new RENode(6);
                state.result.min = 0;
                state.result.max = 1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '{': {
                int min = 0;
                int max = -1;
                int leftCurl = state.cp++;
                c = src[state.cp];
                if (NativeRegExp.isDigit(c)) {
                    ++state.cp;
                    min = NativeRegExp.getDecimalValue(c, state, 65535, "msg.overlarge.min");
                    c = src[state.cp];
                    if (c == ',') {
                        if (NativeRegExp.isDigit(c = src[++state.cp])) {
                            ++state.cp;
                            max = NativeRegExp.getDecimalValue(c, state, 65535, "msg.overlarge.max");
                            c = src[state.cp];
                            if (min > max) {
                                NativeRegExp.reportError("msg.max.lt.min", String.valueOf(src[state.cp]));
                                return false;
                            }
                        }
                    } else {
                        max = min;
                    }
                    if (c == '}') {
                        state.result = new RENode(6);
                        state.result.min = min;
                        state.result.max = max;
                        state.progLength += 12;
                        hasQ = true;
                    }
                }
                if (hasQ) break;
                state.cp = leftCurl;
                break;
            }
        }
        if (!hasQ) {
            return true;
        }
        ++state.cp;
        state.result.kid = term;
        state.result.parenIndex = parenBaseCount;
        state.result.parenCount = state.parenCount - parenBaseCount;
        if (state.cp < state.cpend && src[state.cp] == '?') {
            ++state.cp;
            state.result.greedy = false;
        } else {
            state.result.greedy = true;
        }
        return true;
    }

    private static void CHECK_OFFSET(int diff) {
        if ((short)diff != diff) {
            throw new RuntimeException();
        }
    }

    private static void SET_OFFSET(byte[] array, int pc, int off) {
        array[pc] = (byte)(off >> 8);
        array[pc + 1] = (byte)off;
    }

    private static int GET_OFFSET(byte[] array, int pc) {
        return (array[pc] & 0xFF) << 8 | array[pc + 1] & 0xFF;
    }

    private static int GET_ARG(byte[] array, int pc) {
        return NativeRegExp.GET_OFFSET(array, pc);
    }

    private static void SET_ARG(byte[] array, int pc, int arg) {
        NativeRegExp.SET_OFFSET(array, pc, arg);
    }

    private static int emitREBytecode(CompilerState state, RECompiled re, int pc, RENode t) {
        byte[] program = re.program;
        while (t != null) {
            program[pc++] = t.op;
            switch (t.op) {
                case 0: {
                    --pc;
                    break;
                }
                case 1: {
                    RENode nextAlt = t.kid2;
                    int nextAltFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 23;
                    int nextTermFixup = pc;
                    int diff = (pc += 2) - nextAltFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextAltFixup, diff);
                    pc = NativeRegExp.emitREBytecode(state, re, pc, nextAlt);
                    program[pc++] = 23;
                    nextAltFixup = pc;
                    diff = (pc += 2) - nextTermFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextTermFixup, diff);
                    diff = pc - nextAltFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextAltFixup, diff);
                    break;
                }
                case 21: {
                    if (t.flatIndex != -1) {
                        while (t.next != null && t.next.op == 21 && t.flatIndex + t.length == t.next.flatIndex) {
                            t.length += t.next.length;
                            t.next = t.next.next;
                        }
                    }
                    if (t.flatIndex != -1 && t.length > 1) {
                        program[pc - 1] = (state.flags & 2) != 0 ? 32 : 21;
                        NativeRegExp.SET_ARG(program, pc, t.flatIndex);
                        NativeRegExp.SET_ARG(program, pc += 2, t.length);
                        pc += 2;
                        break;
                    }
                    if (t.chr < '\u0100') {
                        program[pc - 1] = (state.flags & 2) != 0 ? 33 : 22;
                        program[pc++] = (byte)t.chr;
                        break;
                    }
                    program[pc - 1] = (state.flags & 2) != 0 ? 35 : 28;
                    NativeRegExp.SET_ARG(program, pc, t.chr);
                    pc += 2;
                    break;
                }
                case 10: {
                    NativeRegExp.SET_ARG(program, pc, t.parenIndex);
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 11;
                    NativeRegExp.SET_ARG(program, pc, t.parenIndex);
                    pc += 2;
                    break;
                }
                case 20: {
                    NativeRegExp.SET_ARG(program, pc, t.parenIndex);
                    pc += 2;
                    break;
                }
                case 41: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 43;
                    int diff = pc - nextTermFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextTermFixup, diff);
                    break;
                }
                case 42: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 44;
                    int diff = pc - nextTermFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextTermFixup, diff);
                    break;
                }
                case 6: {
                    if (t.min == 0 && t.max == -1) {
                        program[pc - 1] = t.greedy ? 7 : 45;
                    } else if (t.min == 0 && t.max == 1) {
                        program[pc - 1] = t.greedy ? 9 : 47;
                    } else if (t.min == 1 && t.max == -1) {
                        program[pc - 1] = t.greedy ? 8 : 46;
                    } else {
                        if (!t.greedy) {
                            program[pc - 1] = 48;
                        }
                        NativeRegExp.SET_ARG(program, pc, t.min);
                        NativeRegExp.SET_ARG(program, pc += 2, t.max);
                        pc += 2;
                    }
                    NativeRegExp.SET_ARG(program, pc, t.parenCount);
                    NativeRegExp.SET_ARG(program, pc += 2, t.parenIndex);
                    int nextTermFixup = pc += 2;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 49;
                    int diff = pc - nextTermFixup;
                    NativeRegExp.CHECK_OFFSET(diff);
                    NativeRegExp.SET_OFFSET(program, nextTermFixup, diff);
                    break;
                }
                case 50: {
                    NativeRegExp.SET_ARG(program, pc, t.index);
                    pc += 2;
                    RECharSet charSet = re.classList[t.index];
                    charSet.converted = false;
                    charSet.length = t.bmsize;
                    charSet.startIndex = t.startIndex;
                    charSet.strlength = t.kidlen;
                    break;
                }
            }
            t = t.next;
        }
        return pc;
    }

    private static REBackTrackData pushBackTrackState(REGlobalData gData, byte op, int target, REMatchState x) {
        if (gData.backTrackStackTop == gData.maxBackTrack) {
            gData.maxBackTrack <<= 1;
            REBackTrackData[] newStack = new REBackTrackData[gData.maxBackTrack];
            int i = 0;
            while (i < gData.backTrackStackTop) {
                newStack[i] = gData.backTrackStack[i];
                ++i;
            }
            int i2 = gData.backTrackStackTop;
            while (i2 < gData.maxBackTrack) {
                newStack[i2] = new REBackTrackData(x);
                ++i2;
            }
            gData.backTrackStack = newStack;
        }
        REBackTrackData result = new REBackTrackData(x);
        gData.backTrackStack[gData.backTrackStackTop++] = result;
        result.continuation_op = op;
        result.continuation_pc = target;
        result.lastParen = gData.lastParen;
        result.currentState = new REProgState(gData.stateStack[gData.stateStackTop - 1]);
        if (gData.stateStackTop > 1) {
            result.precedingStateTop = gData.stateStackTop - 1;
            result.precedingState = new REProgState[result.precedingStateTop];
            int i = 0;
            while (i < result.precedingStateTop) {
                result.precedingState[i] = new REProgState(gData.stateStack[i]);
                ++i;
            }
        } else {
            result.precedingStateTop = 0;
            result.precedingState = null;
        }
        return result;
    }

    private static REMatchState flatNMatcher(REGlobalData gData, REMatchState x, int matchChars, int length, char[] chars, int end) {
        if (x.cp + length > end) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (gData.regexp.source[matchChars + i] != chars[x.cp + i]) {
                return null;
            }
            ++i;
        }
        x.cp += length;
        return x;
    }

    private static REMatchState flatNIMatcher(REGlobalData gData, REMatchState x, int matchChars, int length, char[] chars, int end) {
        if (x.cp + length > end) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (NativeRegExp.upcase(gData.regexp.source[matchChars + i]) != NativeRegExp.upcase(chars[x.cp + i])) {
                return null;
            }
            ++i;
        }
        x.cp += length;
        return x;
    }

    private static REMatchState backrefMatcher(REGlobalData gData, REMatchState x, int parenIndex, char[] chars, int end) {
        int parenContent = x.parens_index(parenIndex);
        if (parenContent == -1) {
            return x;
        }
        int len = x.parens_length(parenIndex);
        if (x.cp + len > end) {
            return null;
        }
        if ((gData.regexp.flags & 2) != 0) {
            int i = 0;
            while (i < len) {
                if (NativeRegExp.upcase(chars[parenContent + i]) != NativeRegExp.upcase(chars[x.cp + i])) {
                    return null;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (chars[parenContent + i] != chars[x.cp + i]) {
                    return null;
                }
                ++i;
            }
        }
        x.cp += len;
        return x;
    }

    private static void addCharacterToCharSet(RECharSet cs, char c) {
        int byteIndex = c / 8;
        if (c > cs.length) {
            throw new RuntimeException();
        }
        int n = byteIndex;
        cs.bits[n] = (byte)(cs.bits[n] | 1 << (c & 7));
    }

    private static void addCharacterRangeToCharSet(RECharSet cs, char c1, char c2) {
        int byteIndex1 = c1 / 8;
        int byteIndex2 = c2 / 8;
        if (c2 > cs.length || c1 > c2) {
            throw new RuntimeException();
        }
        c1 = (char)(c1 & 7);
        c2 = (char)(c2 & 7);
        if (byteIndex1 == byteIndex2) {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | 255 >> 7 - (c2 - c1) << c1);
        } else {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | 255 << c1);
            int i = byteIndex1 + 1;
            while (i < byteIndex2) {
                cs.bits[i] = -1;
                ++i;
            }
            int n2 = byteIndex2;
            cs.bits[n2] = (byte)(cs.bits[n2] | 255 >> 7 - c2);
        }
    }

    private static void processCharSet(REGlobalData gData, RECharSet charSet) {
        int src = charSet.startIndex;
        int end = src + charSet.strlength;
        char rangeStart = '\u0000';
        boolean inRange = false;
        charSet.sense = true;
        int byteLength = charSet.length / 8 + 1;
        charSet.bits = new byte[byteLength];
        if (src == end) {
            return;
        }
        if (gData.regexp.source[src] == '^') {
            charSet.sense = false;
            ++src;
        }
        block21: while (src != end) {
            char thisCh;
            int nDigits = 2;
            switch (gData.regexp.source[src]) {
                case '\\': {
                    int n = ++src;
                    ++src;
                    char c = gData.regexp.source[n];
                    switch (c) {
                        case 'b': {
                            thisCh = '\b';
                            break;
                        }
                        case 'f': {
                            thisCh = '\f';
                            break;
                        }
                        case 'n': {
                            thisCh = '\n';
                            break;
                        }
                        case 'r': {
                            thisCh = '\r';
                            break;
                        }
                        case 't': {
                            thisCh = '\t';
                            break;
                        }
                        case 'v': {
                            thisCh = '\u000b';
                            break;
                        }
                        case 'c': {
                            if (src + 1 < end && NativeRegExp.isWord(gData.regexp.source[src + 1])) {
                                thisCh = (char)(gData.regexp.source[src++] & 0x1F);
                                break;
                            }
                            --src;
                            thisCh = '\\';
                            break;
                        }
                        case 'u': {
                            nDigits += 2;
                        }
                        case 'x': {
                            int n2 = 0;
                            int i = 0;
                            while (i < nDigits && src < end) {
                                int digit;
                                if ((digit = NativeRegExp.toASCIIHexDigit(c = gData.regexp.source[src++])) < 0) {
                                    src -= i + 1;
                                    n2 = 92;
                                    break;
                                }
                                n2 = n2 << 4 | digit;
                                ++i;
                            }
                            thisCh = (char)n2;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int i;
                            int n2 = c - 48;
                            c = gData.regexp.source[src];
                            if ('0' <= c && c <= '7') {
                                n2 = 8 * n2 + (c - 48);
                                if ('0' <= (c = gData.regexp.source[++src]) && c <= '7') {
                                    ++src;
                                    i = 8 * n2 + (c - 48);
                                    if (i <= 255) {
                                        n2 = i;
                                    } else {
                                        --src;
                                    }
                                }
                            }
                            thisCh = (char)n2;
                            break;
                        }
                        case 'd': {
                            NativeRegExp.addCharacterRangeToCharSet(charSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            NativeRegExp.addCharacterRangeToCharSet(charSet, '\u0000', '/');
                            NativeRegExp.addCharacterRangeToCharSet(charSet, ':', (char)charSet.length);
                            continue block21;
                        }
                        case 's': {
                            int i = charSet.length;
                            while (i >= 0) {
                                if (NativeRegExp.isREWhiteSpace(i)) {
                                    NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                                }
                                --i;
                            }
                            continue block21;
                        }
                        case 'S': {
                            int i = charSet.length;
                            while (i >= 0) {
                                if (!NativeRegExp.isREWhiteSpace(i)) {
                                    NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                                }
                                --i;
                            }
                            continue block21;
                        }
                        case 'w': {
                            int i = charSet.length;
                            while (i >= 0) {
                                if (NativeRegExp.isWord((char)i)) {
                                    NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                                }
                                --i;
                            }
                            continue block21;
                        }
                        case 'W': {
                            int i = charSet.length;
                            while (i >= 0) {
                                if (!NativeRegExp.isWord((char)i)) {
                                    NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                                }
                                --i;
                            }
                            continue block21;
                        }
                        default: {
                            thisCh = c;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    thisCh = gData.regexp.source[src++];
                }
            }
            if (inRange) {
                if ((gData.regexp.flags & 2) != 0) {
                    NativeRegExp.addCharacterRangeToCharSet(charSet, NativeRegExp.upcase(rangeStart), NativeRegExp.upcase(thisCh));
                    NativeRegExp.addCharacterRangeToCharSet(charSet, NativeRegExp.downcase(rangeStart), NativeRegExp.downcase(thisCh));
                } else {
                    NativeRegExp.addCharacterRangeToCharSet(charSet, rangeStart, thisCh);
                }
                inRange = false;
                continue;
            }
            if ((gData.regexp.flags & 2) != 0) {
                NativeRegExp.addCharacterToCharSet(charSet, NativeRegExp.upcase(thisCh));
                NativeRegExp.addCharacterToCharSet(charSet, NativeRegExp.downcase(thisCh));
            } else {
                NativeRegExp.addCharacterToCharSet(charSet, thisCh);
            }
            if (src >= end - 1 || gData.regexp.source[src] != '-') continue;
            ++src;
            inRange = true;
            rangeStart = thisCh;
        }
    }

    private static boolean classMatcher(REGlobalData gData, RECharSet charSet, char ch) {
        if (!charSet.converted) {
            NativeRegExp.processCharSet(gData, charSet);
            charSet.converted = true;
        }
        int byteIndex = ch / 8;
        return !(charSet.sense ? charSet.length == 0 || ch > charSet.length || (charSet.bits[byteIndex] & 1 << (ch & 7)) == 0 : charSet.length != 0 && ch <= charSet.length && (charSet.bits[byteIndex] & 1 << (ch & 7)) != 0);
    }

    private static REMatchState executeREBytecode(REGlobalData gData, REMatchState x, char[] chars, int end) {
        int pc = 0;
        byte[] program = gData.regexp.program;
        int op = program[pc++];
        REMatchState result = null;
        int currentContinuation_pc = 0;
        int currentContinuation_op = 53;
        block42: while (true) {
            int k;
            switch (op) {
                case 0: {
                    result = x;
                    break;
                }
                case 2: {
                    if (x.cp != 0) {
                        if (gData.multiline || (gData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(chars[x.cp - 1])) {
                                result = null;
                                break;
                            }
                        } else {
                            result = null;
                            break;
                        }
                    }
                    result = x;
                    break;
                }
                case 3: {
                    if (x.cp != end) {
                        if (gData.multiline || (gData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(chars[x.cp])) {
                                result = null;
                                break;
                            }
                        } else {
                            result = null;
                            break;
                        }
                    }
                    result = x;
                    break;
                }
                case 4: {
                    if ((x.cp == 0 || !NativeRegExp.isWord(chars[x.cp - 1])) ^ (x.cp >= end || !NativeRegExp.isWord(chars[x.cp]))) {
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 5: {
                    if ((x.cp == 0 || !NativeRegExp.isWord(chars[x.cp - 1])) ^ (x.cp < end && NativeRegExp.isWord(chars[x.cp]))) {
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 12: {
                    if (x.cp != end && !NativeRegExp.isLineTerm(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 14: {
                    if (x.cp != end && NativeRegExp.isDigit(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 15: {
                    if (x.cp != end && !NativeRegExp.isDigit(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 18: {
                    if (x.cp != end && NativeRegExp.isREWhiteSpace(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 19: {
                    if (x.cp != end && !NativeRegExp.isREWhiteSpace(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 16: {
                    if (x.cp != end && NativeRegExp.isWord(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 17: {
                    if (x.cp != end && !NativeRegExp.isWord(chars[x.cp])) {
                        result = x;
                        ++result.cp;
                        break;
                    }
                    result = null;
                    break;
                }
                case 21: {
                    int offset = NativeRegExp.GET_ARG(program, pc);
                    int length = NativeRegExp.GET_ARG(program, pc += 2);
                    pc += 2;
                    result = NativeRegExp.flatNMatcher(gData, x, offset, length, chars, end);
                    break;
                }
                case 32: {
                    int offset = NativeRegExp.GET_ARG(program, pc);
                    int length = NativeRegExp.GET_ARG(program, pc += 2);
                    pc += 2;
                    result = NativeRegExp.flatNIMatcher(gData, x, offset, length, chars, end);
                    break;
                }
                case 22: {
                    char matchCh = (char)(program[pc++] & 0xFF);
                    if (x.cp != end && chars[x.cp] == matchCh) {
                        ++x.cp;
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 33: {
                    char matchCh = (char)(program[pc++] & 0xFF);
                    if (x.cp != end && NativeRegExp.upcase(chars[x.cp]) == NativeRegExp.upcase(matchCh)) {
                        ++x.cp;
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 28: {
                    char matchCh = (char)NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    if (x.cp != end && chars[x.cp] == matchCh) {
                        ++x.cp;
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 35: {
                    char matchCh = (char)NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    if (x.cp != end && NativeRegExp.upcase(chars[x.cp]) == NativeRegExp.upcase(matchCh)) {
                        ++x.cp;
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 1: {
                    int nextpc = pc + NativeRegExp.GET_OFFSET(program, pc);
                    byte nextop = program[nextpc++];
                    gData.stateStack[gData.stateStackTop].continuation_pc = currentContinuation_pc;
                    gData.stateStack[gData.stateStackTop].continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    NativeRegExp.pushBackTrackState(gData, nextop, nextpc, x);
                    pc += 2;
                    op = program[pc++];
                    continue block42;
                }
                case 23: {
                    --gData.stateStackTop;
                    currentContinuation_pc = gData.stateStack[gData.stateStackTop].continuation_pc;
                    currentContinuation_op = gData.stateStack[gData.stateStackTop].continuation_op;
                    int offset = NativeRegExp.GET_OFFSET(program, pc);
                    pc += offset;
                    op = program[pc++];
                    continue block42;
                }
                case 10: {
                    int parenIndex = NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    x.set_parens(parenIndex, x.cp, 0);
                    op = program[pc++];
                    continue block42;
                }
                case 11: {
                    int parenIndex = NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    int cap_index = x.parens_index(parenIndex);
                    x.set_parens(parenIndex, cap_index, x.cp - cap_index);
                    if (parenIndex > gData.lastParen) {
                        gData.lastParen = parenIndex;
                    }
                    op = program[pc++];
                    continue block42;
                }
                case 20: {
                    int parenIndex = NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    result = NativeRegExp.backrefMatcher(gData, x, parenIndex, chars, end);
                    break;
                }
                case 41: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    curState.max = gData.backTrackStackTop;
                    curState.index = x.cp;
                    ++gData.stateStackTop;
                    NativeRegExp.pushBackTrackState(gData, (byte)43, pc + NativeRegExp.GET_OFFSET(program, pc), x);
                    pc += 2;
                    op = program[pc++];
                    continue block42;
                }
                case 42: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    curState.max = gData.backTrackStackTop;
                    curState.index = x.cp;
                    ++gData.stateStackTop;
                    NativeRegExp.pushBackTrackState(gData, (byte)44, pc + NativeRegExp.GET_OFFSET(program, pc), x);
                    pc += 2;
                    op = program[pc++];
                    continue block42;
                }
                case 43: {
                    --gData.stateStackTop;
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    x.cp = curState.index;
                    gData.backTrackStackTop = curState.max;
                    currentContinuation_pc = curState.continuation_pc;
                    currentContinuation_op = curState.continuation_op;
                    if (result == null) break;
                    result = x;
                    break;
                }
                case 44: {
                    --gData.stateStackTop;
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    x.cp = curState.index;
                    gData.backTrackStackTop = curState.max;
                    currentContinuation_pc = curState.continuation_pc;
                    currentContinuation_op = curState.continuation_op;
                    if (result == null) {
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 50: {
                    int index = NativeRegExp.GET_ARG(program, pc);
                    pc += 2;
                    if (x.cp != end && NativeRegExp.classMatcher(gData, gData.regexp.classList[index], chars[x.cp])) {
                        ++x.cp;
                        result = x;
                        break;
                    }
                    result = null;
                    break;
                }
                case 53: {
                    if (x == null) break;
                    return x;
                }
                case 7: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 0;
                    curState.max = -1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    currentContinuation_op = 51;
                    currentContinuation_pc = pc;
                    NativeRegExp.pushBackTrackState(gData, (byte)51, pc, x);
                    pc += 6;
                    op = program[pc++];
                    continue block42;
                }
                case 8: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 1;
                    curState.max = -1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    currentContinuation_op = 51;
                    currentContinuation_pc = pc;
                    NativeRegExp.pushBackTrackState(gData, (byte)51, pc, x);
                    pc += 6;
                    op = program[pc++];
                    continue block42;
                }
                case 9: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 0;
                    curState.max = 1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    currentContinuation_op = 51;
                    currentContinuation_pc = pc;
                    NativeRegExp.pushBackTrackState(gData, (byte)51, pc, x);
                    pc += 6;
                    op = program[pc++];
                    continue block42;
                }
                case 6: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = NativeRegExp.GET_ARG(program, pc);
                    curState.max = NativeRegExp.GET_ARG(program, pc += 2);
                    pc += 2;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    currentContinuation_op = 51;
                    currentContinuation_pc = pc;
                    NativeRegExp.pushBackTrackState(gData, (byte)51, pc, x);
                    pc += 6;
                    op = program[pc++];
                    continue block42;
                }
                case 49: {
                    pc = currentContinuation_pc;
                    op = currentContinuation_op;
                    continue block42;
                }
                case 51: {
                    --gData.stateStackTop;
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    if (result == null) {
                        currentContinuation_pc = curState.continuation_pc;
                        currentContinuation_op = curState.continuation_op;
                        if (curState.min == 0) {
                            result = x;
                        }
                        pc += 4;
                        pc += NativeRegExp.GET_OFFSET(program, pc);
                        break;
                    }
                    if (curState.min == 0 && x.cp == curState.index) {
                        result = null;
                        currentContinuation_pc = curState.continuation_pc;
                        currentContinuation_op = curState.continuation_op;
                        pc += 4;
                        pc += NativeRegExp.GET_OFFSET(program, pc);
                        break;
                    }
                    if (curState.min != 0) {
                        --curState.min;
                    }
                    if (curState.max != -1) {
                        --curState.max;
                    }
                    if (curState.max == 0) {
                        result = x;
                        currentContinuation_pc = curState.continuation_pc;
                        currentContinuation_op = curState.continuation_op;
                        pc += 4;
                        pc += NativeRegExp.GET_OFFSET(program, pc);
                        break;
                    }
                    curState.index = x.cp;
                    ++gData.stateStackTop;
                    currentContinuation_op = 51;
                    currentContinuation_pc = pc;
                    NativeRegExp.pushBackTrackState(gData, (byte)51, pc, x);
                    int parenCount = NativeRegExp.GET_ARG(program, pc);
                    int parenIndex = NativeRegExp.GET_ARG(program, pc += 2);
                    pc += 4;
                    op = program[pc++];
                    k = 0;
                    while (true) {
                        if (k >= parenCount) continue block42;
                        x.set_parens(parenIndex + k, -1, 0);
                        ++k;
                    }
                }
                case 45: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 0;
                    curState.max = -1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    if (curState.min != 0) {
                        currentContinuation_op = 52;
                        currentContinuation_pc = pc;
                        pc += 6;
                        op = program[pc++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(gData, (byte)52, pc, x);
                    --gData.stateStackTop;
                    pc += 4;
                    pc += NativeRegExp.GET_OFFSET(program, pc);
                    op = program[pc++];
                    continue block42;
                }
                case 46: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 1;
                    curState.max = -1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    if (curState.min != 0) {
                        currentContinuation_op = 52;
                        currentContinuation_pc = pc;
                        pc += 6;
                        op = program[pc++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(gData, (byte)52, pc, x);
                    --gData.stateStackTop;
                    pc += 4;
                    pc += NativeRegExp.GET_OFFSET(program, pc);
                    op = program[pc++];
                    continue block42;
                }
                case 47: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = 0;
                    curState.max = 1;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    if (curState.min != 0) {
                        currentContinuation_op = 52;
                        currentContinuation_pc = pc;
                        pc += 6;
                        op = program[pc++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(gData, (byte)52, pc, x);
                    --gData.stateStackTop;
                    pc += 4;
                    pc += NativeRegExp.GET_OFFSET(program, pc);
                    op = program[pc++];
                    continue block42;
                }
                case 48: {
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    curState.min = NativeRegExp.GET_ARG(program, pc);
                    curState.max = NativeRegExp.GET_ARG(program, pc += 2);
                    pc += 2;
                    curState.index = x.cp;
                    curState.continuation_pc = currentContinuation_pc;
                    curState.continuation_op = currentContinuation_op;
                    ++gData.stateStackTop;
                    if (curState.min != 0) {
                        currentContinuation_op = 52;
                        currentContinuation_pc = pc;
                        pc += 6;
                        op = program[pc++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(gData, (byte)52, pc, x);
                    --gData.stateStackTop;
                    pc += 4;
                    pc += NativeRegExp.GET_OFFSET(program, pc);
                    op = program[pc++];
                    continue block42;
                }
                case 52: {
                    int parenCount;
                    int parenIndex;
                    --gData.stateStackTop;
                    REProgState curState = gData.stateStack[gData.stateStackTop];
                    if (result == null) {
                        if (curState.max == -1 || curState.max > 0) {
                            curState.index = x.cp;
                            currentContinuation_op = 52;
                            currentContinuation_pc = pc;
                            parenCount = NativeRegExp.GET_ARG(program, pc);
                            parenIndex = NativeRegExp.GET_ARG(program, pc += 2);
                            pc += 4;
                            k = 0;
                            while (k < parenCount) {
                                x.set_parens(parenIndex + k, -1, 0);
                                ++k;
                            }
                            ++gData.stateStackTop;
                            op = program[pc++];
                            continue block42;
                        }
                        currentContinuation_pc = curState.continuation_pc;
                        currentContinuation_op = curState.continuation_op;
                        break;
                    }
                    if (curState.min == 0 && x.cp == curState.index) {
                        result = null;
                        currentContinuation_pc = curState.continuation_pc;
                        currentContinuation_op = curState.continuation_op;
                        break;
                    }
                    if (curState.min != 0) {
                        --curState.min;
                    }
                    if (curState.max != -1) {
                        --curState.max;
                    }
                    if (curState.min != 0) {
                        currentContinuation_op = 52;
                        currentContinuation_pc = pc;
                        parenCount = NativeRegExp.GET_ARG(program, pc);
                        parenIndex = NativeRegExp.GET_ARG(program, pc += 2);
                        pc += 4;
                        k = 0;
                        while (k < parenCount) {
                            x.set_parens(parenIndex + k, -1, 0);
                            ++k;
                        }
                        curState.index = x.cp;
                        ++gData.stateStackTop;
                        op = program[pc++];
                        continue block42;
                    }
                    currentContinuation_pc = curState.continuation_pc;
                    currentContinuation_op = curState.continuation_op;
                    curState.index = x.cp;
                    ++gData.stateStackTop;
                    NativeRegExp.pushBackTrackState(gData, (byte)52, pc, x);
                    --gData.stateStackTop;
                    pc += 4;
                    pc += NativeRegExp.GET_OFFSET(program, pc);
                    op = program[pc++];
                    continue block42;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (result == null) {
                if (gData.backTrackStackTop > 0) {
                    --gData.backTrackStackTop;
                    REBackTrackData backTrackData = gData.backTrackStack[gData.backTrackStackTop];
                    gData.lastParen = backTrackData.lastParen;
                    x = new REMatchState(backTrackData.state);
                    k = 0;
                    while (k < backTrackData.precedingStateTop) {
                        gData.stateStack[k] = backTrackData.precedingState[k];
                        ++k;
                    }
                    gData.stateStackTop = backTrackData.precedingStateTop + 1;
                    gData.stateStack[gData.stateStackTop - 1] = backTrackData.currentState;
                    currentContinuation_op = gData.stateStack[gData.stateStackTop - 1].continuation_op;
                    currentContinuation_pc = gData.stateStack[gData.stateStackTop - 1].continuation_pc;
                    pc = backTrackData.continuation_pc;
                    op = backTrackData.continuation_op;
                    continue;
                }
                return null;
            }
            x = result;
            if ((op = program[pc++]) != 49) continue;
            pc = currentContinuation_pc;
            op = currentContinuation_op;
        }
    }

    private static REMatchState matchRegExp(REGlobalData gData, RECompiled re, char[] chars, int start, int end, boolean multiline) {
        int INITIAL_STATESTACK = 20;
        int INITIAL_BACKTRACK = 20;
        REMatchState x = new REMatchState(re.parenCount);
        gData.maxBackTrack = 20;
        gData.backTrackStack = new REBackTrackData[20];
        int i = 0;
        while (i < 20) {
            gData.backTrackStack[i] = new REBackTrackData(x);
            ++i;
        }
        gData.backTrackStackTop = 0;
        gData.maxStateStack = 20;
        gData.stateStack = new REProgState[20];
        int i2 = 0;
        while (i2 < 20) {
            gData.stateStack[i2] = new REProgState();
            ++i2;
        }
        gData.stateStackTop = 0;
        gData.multiline = multiline;
        gData.regexp = re;
        gData.lastParen = 0;
        int anchorCh = gData.regexp.anchorCh;
        int i3 = start;
        while (i3 <= end) {
            if (anchorCh >= 0) {
                while (true) {
                    if (i3 == end) {
                        return null;
                    }
                    char matchCh = chars[i3];
                    if (matchCh == anchorCh || (gData.regexp.flags & 2) != 0 && NativeRegExp.upcase(matchCh) == NativeRegExp.upcase((char)anchorCh)) break;
                    ++i3;
                }
            }
            x.cp = i3;
            int j = 0;
            while (j < x.parenCount) {
                x.set_parens(j, -1, 0);
                ++j;
            }
            REMatchState result = NativeRegExp.executeREBytecode(gData, x, chars, end);
            gData.backTrackStackTop = 0;
            gData.stateStackTop = 0;
            if (result != null) {
                gData.skipped = i3 - start;
                return result;
            }
            ++i3;
        }
        return null;
    }

    Object executeRegExp(Context cx, Scriptable scopeObj, RegExpImpl res, String str, int[] indexp, int matchType) {
        Scriptable obj;
        Object result;
        int index;
        int i;
        REMatchState state;
        REGlobalData gData = new REGlobalData();
        int start = indexp[0];
        char[] charArray = str.toCharArray();
        int end = charArray.length;
        if (start > end) {
            start = end;
        }
        if ((state = NativeRegExp.matchRegExp(gData, this.re, charArray, start, end, res.multiline)) == null) {
            if (matchType != 2) {
                return null;
            }
            return Undefined.instance;
        }
        indexp[0] = i = (index = state.cp);
        int matchlen = i - (start + gData.skipped);
        int ep = index;
        index -= matchlen;
        if (matchType == 0) {
            result = Boolean.TRUE;
            obj = null;
        } else {
            Scriptable scope = ScriptableObject.getTopLevelScope(scopeObj);
            result = ScriptRuntime.newObject(cx, scope, "Array", null);
            obj = (Scriptable)result;
            String matchstr = new String(charArray, index, matchlen);
            obj.put(0, obj, (Object)matchstr);
        }
        if (state.parenCount > this.re.parenCount) {
            throw new RuntimeException();
        }
        if (state.parenCount == 0) {
            res.parens = null;
            res.lastParen = SubString.emptySubString;
        } else {
            SubString parsub = null;
            res.parens = new SubString[this.re.parenCount];
            int num = 0;
            while (num < this.re.parenCount) {
                int cap_index = state.parens_index(num);
                if (cap_index != -1) {
                    int cap_length = state.parens_length(num);
                    res.parens[num] = parsub = new SubString(charArray, cap_index, cap_length);
                    if (matchType != 0) {
                        String parstr = parsub.toString();
                        obj.put(num + 1, obj, (Object)parstr);
                    }
                } else if (matchType != 0) {
                    obj.put(num + 1, obj, (Object)Undefined.instance);
                }
                ++num;
            }
            res.lastParen = parsub;
        }
        if (matchType != 0) {
            obj.put("index", obj, (Object)new Integer(start + gData.skipped));
            obj.put("input", obj, (Object)str);
        }
        if (res.lastMatch == null) {
            res.lastMatch = new SubString();
            res.leftContext = new SubString();
            res.rightContext = new SubString();
        }
        res.lastMatch.charArray = charArray;
        res.lastMatch.index = index;
        res.lastMatch.length = matchlen;
        res.leftContext.charArray = charArray;
        if (cx.getLanguageVersion() == 120) {
            res.leftContext.index = start;
            res.leftContext.length = gData.skipped;
        } else {
            res.leftContext.index = 0;
            res.leftContext.length = start + gData.skipped;
        }
        res.rightContext.charArray = charArray;
        res.rightContext.index = ep;
        res.rightContext.length = end - ep;
        return result;
    }

    int getFlags() {
        return this.re.flags;
    }

    private static void reportError(String messageId, String arg) {
        String msg = ScriptRuntime.getMessage1(messageId, arg);
        throw ScriptRuntime.constructError("SyntaxError", msg);
    }

    protected int getIdAttributes(int id) {
        switch (id) {
            case 1: {
                return 6;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 7;
            }
        }
        return super.getIdAttributes(id);
    }

    protected Object getIdValue(int id) {
        switch (id) {
            case 1: {
                return this.wrap_double(this.lastIndex);
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                return this.wrap_boolean((this.re.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.re.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.re.flags & 4) != 0);
            }
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.setLastIndex(ScriptRuntime.toNumber(value));
            return;
        }
        super.setIdValue(id, value);
    }

    void setLastIndex(double value) {
        this.lastIndex = value;
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return NativeRegExp.realThis(thisObj, f).compile(cx, scope, args);
                }
                case 7: 
                case 8: {
                    return NativeRegExp.realThis(thisObj, f).toString();
                }
                case 9: {
                    return NativeRegExp.realThis(thisObj, f).execSub(cx, scope, args, 1);
                }
                case 10: {
                    Object x = NativeRegExp.realThis(thisObj, f).execSub(cx, scope, args, 0);
                    return Boolean.TRUE.equals(x) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 11: {
                    return NativeRegExp.realThis(thisObj, f).execSub(cx, scope, args, 2);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static NativeRegExp realThis(Scriptable thisObj, IdFunction f) {
        if (!(thisObj instanceof NativeRegExp)) {
            throw IdScriptable.incompatibleCallError(f);
        }
        return (NativeRegExp)thisObj;
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "toSource";
                }
                case 9: {
                    return "exec";
                }
                case 10: {
                    return "test";
                }
                case 11: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        char c;
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 6) {
            c = s.charAt(0);
            if (c == 'g') {
                X = "global";
                id = 3;
            } else if (c == 's') {
                X = "source";
                id = 2;
            }
        } else if (s_length == 9) {
            c = s.charAt(0);
            if (c == 'l') {
                X = "lastIndex";
                id = 1;
            } else if (c == 'm') {
                X = "multiline";
                id = 5;
            }
        } else if (s_length == 10) {
            X = "ignoreCase";
            id = 4;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id != 0 || !this.prototypeFlag) {
            return id;
        }
        id = 0;
        X = null;
        switch (s.length()) {
            case 4: {
                c = s.charAt(0);
                if (c == 'e') {
                    X = "exec";
                    id = 9;
                    break;
                }
                if (c != 't') break;
                X = "test";
                id = 10;
                break;
            }
            case 6: {
                X = "prefix";
                id = 11;
                break;
            }
            case 7: {
                X = "compile";
                id = 6;
                break;
            }
            case 8: {
                c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 8;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 7;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

