// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package notebooks

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	notebookspb "cloud.google.com/go/notebooks/apiv1/notebookspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newNotebookClientHook clientHook

// NotebookCallOptions contains the retry settings for each method of NotebookClient.
type NotebookCallOptions struct {
	ListInstances                []gax.CallOption
	GetInstance                  []gax.CallOption
	CreateInstance               []gax.CallOption
	RegisterInstance             []gax.CallOption
	SetInstanceAccelerator       []gax.CallOption
	SetInstanceMachineType       []gax.CallOption
	UpdateInstanceConfig         []gax.CallOption
	UpdateShieldedInstanceConfig []gax.CallOption
	SetInstanceLabels            []gax.CallOption
	UpdateInstanceMetadataItems  []gax.CallOption
	DeleteInstance               []gax.CallOption
	StartInstance                []gax.CallOption
	StopInstance                 []gax.CallOption
	ResetInstance                []gax.CallOption
	ReportInstanceInfo           []gax.CallOption
	IsInstanceUpgradeable        []gax.CallOption
	GetInstanceHealth            []gax.CallOption
	UpgradeInstance              []gax.CallOption
	RollbackInstance             []gax.CallOption
	DiagnoseInstance             []gax.CallOption
	UpgradeInstanceInternal      []gax.CallOption
	ListEnvironments             []gax.CallOption
	GetEnvironment               []gax.CallOption
	CreateEnvironment            []gax.CallOption
	DeleteEnvironment            []gax.CallOption
	ListSchedules                []gax.CallOption
	GetSchedule                  []gax.CallOption
	DeleteSchedule               []gax.CallOption
	CreateSchedule               []gax.CallOption
	TriggerSchedule              []gax.CallOption
	ListExecutions               []gax.CallOption
	GetExecution                 []gax.CallOption
	DeleteExecution              []gax.CallOption
	CreateExecution              []gax.CallOption
	GetLocation                  []gax.CallOption
	ListLocations                []gax.CallOption
	GetIamPolicy                 []gax.CallOption
	SetIamPolicy                 []gax.CallOption
	TestIamPermissions           []gax.CallOption
	CancelOperation              []gax.CallOption
	DeleteOperation              []gax.CallOption
	GetOperation                 []gax.CallOption
	ListOperations               []gax.CallOption
}

func defaultNotebookGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("notebooks.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("notebooks.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("notebooks.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://notebooks.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultNotebookCallOptions() *NotebookCallOptions {
	return &NotebookCallOptions{
		ListInstances: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RegisterInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetInstanceAccelerator: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetInstanceMachineType: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateInstanceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateShieldedInstanceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetInstanceLabels: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateInstanceMetadataItems: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReportInstanceInfo: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		IsInstanceUpgradeable: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetInstanceHealth: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpgradeInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RollbackInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DiagnoseInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpgradeInstanceInternal: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListEnvironments: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetEnvironment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateEnvironment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteEnvironment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSchedules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSchedule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSchedule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSchedule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		TriggerSchedule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListExecutions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetExecution: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteExecution: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateExecution: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        300000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalNotebookClient is an interface that defines the methods available from Notebooks API.
type internalNotebookClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListInstances(context.Context, *notebookspb.ListInstancesRequest, ...gax.CallOption) *InstanceIterator
	GetInstance(context.Context, *notebookspb.GetInstanceRequest, ...gax.CallOption) (*notebookspb.Instance, error)
	CreateInstance(context.Context, *notebookspb.CreateInstanceRequest, ...gax.CallOption) (*CreateInstanceOperation, error)
	CreateInstanceOperation(name string) *CreateInstanceOperation
	RegisterInstance(context.Context, *notebookspb.RegisterInstanceRequest, ...gax.CallOption) (*RegisterInstanceOperation, error)
	RegisterInstanceOperation(name string) *RegisterInstanceOperation
	SetInstanceAccelerator(context.Context, *notebookspb.SetInstanceAcceleratorRequest, ...gax.CallOption) (*SetInstanceAcceleratorOperation, error)
	SetInstanceAcceleratorOperation(name string) *SetInstanceAcceleratorOperation
	SetInstanceMachineType(context.Context, *notebookspb.SetInstanceMachineTypeRequest, ...gax.CallOption) (*SetInstanceMachineTypeOperation, error)
	SetInstanceMachineTypeOperation(name string) *SetInstanceMachineTypeOperation
	UpdateInstanceConfig(context.Context, *notebookspb.UpdateInstanceConfigRequest, ...gax.CallOption) (*UpdateInstanceConfigOperation, error)
	UpdateInstanceConfigOperation(name string) *UpdateInstanceConfigOperation
	UpdateShieldedInstanceConfig(context.Context, *notebookspb.UpdateShieldedInstanceConfigRequest, ...gax.CallOption) (*UpdateShieldedInstanceConfigOperation, error)
	UpdateShieldedInstanceConfigOperation(name string) *UpdateShieldedInstanceConfigOperation
	SetInstanceLabels(context.Context, *notebookspb.SetInstanceLabelsRequest, ...gax.CallOption) (*SetInstanceLabelsOperation, error)
	SetInstanceLabelsOperation(name string) *SetInstanceLabelsOperation
	UpdateInstanceMetadataItems(context.Context, *notebookspb.UpdateInstanceMetadataItemsRequest, ...gax.CallOption) (*notebookspb.UpdateInstanceMetadataItemsResponse, error)
	DeleteInstance(context.Context, *notebookspb.DeleteInstanceRequest, ...gax.CallOption) (*DeleteInstanceOperation, error)
	DeleteInstanceOperation(name string) *DeleteInstanceOperation
	StartInstance(context.Context, *notebookspb.StartInstanceRequest, ...gax.CallOption) (*StartInstanceOperation, error)
	StartInstanceOperation(name string) *StartInstanceOperation
	StopInstance(context.Context, *notebookspb.StopInstanceRequest, ...gax.CallOption) (*StopInstanceOperation, error)
	StopInstanceOperation(name string) *StopInstanceOperation
	ResetInstance(context.Context, *notebookspb.ResetInstanceRequest, ...gax.CallOption) (*ResetInstanceOperation, error)
	ResetInstanceOperation(name string) *ResetInstanceOperation
	ReportInstanceInfo(context.Context, *notebookspb.ReportInstanceInfoRequest, ...gax.CallOption) (*ReportInstanceInfoOperation, error)
	ReportInstanceInfoOperation(name string) *ReportInstanceInfoOperation
	IsInstanceUpgradeable(context.Context, *notebookspb.IsInstanceUpgradeableRequest, ...gax.CallOption) (*notebookspb.IsInstanceUpgradeableResponse, error)
	GetInstanceHealth(context.Context, *notebookspb.GetInstanceHealthRequest, ...gax.CallOption) (*notebookspb.GetInstanceHealthResponse, error)
	UpgradeInstance(context.Context, *notebookspb.UpgradeInstanceRequest, ...gax.CallOption) (*UpgradeInstanceOperation, error)
	UpgradeInstanceOperation(name string) *UpgradeInstanceOperation
	RollbackInstance(context.Context, *notebookspb.RollbackInstanceRequest, ...gax.CallOption) (*RollbackInstanceOperation, error)
	RollbackInstanceOperation(name string) *RollbackInstanceOperation
	DiagnoseInstance(context.Context, *notebookspb.DiagnoseInstanceRequest, ...gax.CallOption) (*DiagnoseInstanceOperation, error)
	DiagnoseInstanceOperation(name string) *DiagnoseInstanceOperation
	UpgradeInstanceInternal(context.Context, *notebookspb.UpgradeInstanceInternalRequest, ...gax.CallOption) (*UpgradeInstanceInternalOperation, error)
	UpgradeInstanceInternalOperation(name string) *UpgradeInstanceInternalOperation
	ListEnvironments(context.Context, *notebookspb.ListEnvironmentsRequest, ...gax.CallOption) *EnvironmentIterator
	GetEnvironment(context.Context, *notebookspb.GetEnvironmentRequest, ...gax.CallOption) (*notebookspb.Environment, error)
	CreateEnvironment(context.Context, *notebookspb.CreateEnvironmentRequest, ...gax.CallOption) (*CreateEnvironmentOperation, error)
	CreateEnvironmentOperation(name string) *CreateEnvironmentOperation
	DeleteEnvironment(context.Context, *notebookspb.DeleteEnvironmentRequest, ...gax.CallOption) (*DeleteEnvironmentOperation, error)
	DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation
	ListSchedules(context.Context, *notebookspb.ListSchedulesRequest, ...gax.CallOption) *ScheduleIterator
	GetSchedule(context.Context, *notebookspb.GetScheduleRequest, ...gax.CallOption) (*notebookspb.Schedule, error)
	DeleteSchedule(context.Context, *notebookspb.DeleteScheduleRequest, ...gax.CallOption) (*DeleteScheduleOperation, error)
	DeleteScheduleOperation(name string) *DeleteScheduleOperation
	CreateSchedule(context.Context, *notebookspb.CreateScheduleRequest, ...gax.CallOption) (*CreateScheduleOperation, error)
	CreateScheduleOperation(name string) *CreateScheduleOperation
	TriggerSchedule(context.Context, *notebookspb.TriggerScheduleRequest, ...gax.CallOption) (*TriggerScheduleOperation, error)
	TriggerScheduleOperation(name string) *TriggerScheduleOperation
	ListExecutions(context.Context, *notebookspb.ListExecutionsRequest, ...gax.CallOption) *ExecutionIterator
	GetExecution(context.Context, *notebookspb.GetExecutionRequest, ...gax.CallOption) (*notebookspb.Execution, error)
	DeleteExecution(context.Context, *notebookspb.DeleteExecutionRequest, ...gax.CallOption) (*DeleteExecutionOperation, error)
	DeleteExecutionOperation(name string) *DeleteExecutionOperation
	CreateExecution(context.Context, *notebookspb.CreateExecutionRequest, ...gax.CallOption) (*CreateExecutionOperation, error)
	CreateExecutionOperation(name string) *CreateExecutionOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// NotebookClient is a client for interacting with Notebooks API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// API v1 service for Cloud AI Platform Notebooks.
type NotebookClient struct {
	// The internal transport-dependent client.
	internalClient internalNotebookClient

	// The call options for this service.
	CallOptions *NotebookCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *NotebookClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *NotebookClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *NotebookClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListInstances lists instances in a given project and location.
func (c *NotebookClient) ListInstances(ctx context.Context, req *notebookspb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	return c.internalClient.ListInstances(ctx, req, opts...)
}

// GetInstance gets details of a single Instance.
func (c *NotebookClient) GetInstance(ctx context.Context, req *notebookspb.GetInstanceRequest, opts ...gax.CallOption) (*notebookspb.Instance, error) {
	return c.internalClient.GetInstance(ctx, req, opts...)
}

// CreateInstance creates a new Instance in a given project and location.
func (c *NotebookClient) CreateInstance(ctx context.Context, req *notebookspb.CreateInstanceRequest, opts ...gax.CallOption) (*CreateInstanceOperation, error) {
	return c.internalClient.CreateInstance(ctx, req, opts...)
}

// CreateInstanceOperation returns a new CreateInstanceOperation from a given name.
// The name must be that of a previously created CreateInstanceOperation, possibly from a different process.
func (c *NotebookClient) CreateInstanceOperation(name string) *CreateInstanceOperation {
	return c.internalClient.CreateInstanceOperation(name)
}

// RegisterInstance registers an existing legacy notebook instance to the Notebooks API server.
// Legacy instances are instances created with the legacy Compute Engine
// calls. They are not manageable by the Notebooks API out of the box. This
// call makes these instances manageable by the Notebooks API.
func (c *NotebookClient) RegisterInstance(ctx context.Context, req *notebookspb.RegisterInstanceRequest, opts ...gax.CallOption) (*RegisterInstanceOperation, error) {
	return c.internalClient.RegisterInstance(ctx, req, opts...)
}

// RegisterInstanceOperation returns a new RegisterInstanceOperation from a given name.
// The name must be that of a previously created RegisterInstanceOperation, possibly from a different process.
func (c *NotebookClient) RegisterInstanceOperation(name string) *RegisterInstanceOperation {
	return c.internalClient.RegisterInstanceOperation(name)
}

// SetInstanceAccelerator updates the guest accelerators of a single Instance.
func (c *NotebookClient) SetInstanceAccelerator(ctx context.Context, req *notebookspb.SetInstanceAcceleratorRequest, opts ...gax.CallOption) (*SetInstanceAcceleratorOperation, error) {
	return c.internalClient.SetInstanceAccelerator(ctx, req, opts...)
}

// SetInstanceAcceleratorOperation returns a new SetInstanceAcceleratorOperation from a given name.
// The name must be that of a previously created SetInstanceAcceleratorOperation, possibly from a different process.
func (c *NotebookClient) SetInstanceAcceleratorOperation(name string) *SetInstanceAcceleratorOperation {
	return c.internalClient.SetInstanceAcceleratorOperation(name)
}

// SetInstanceMachineType updates the machine type of a single Instance.
func (c *NotebookClient) SetInstanceMachineType(ctx context.Context, req *notebookspb.SetInstanceMachineTypeRequest, opts ...gax.CallOption) (*SetInstanceMachineTypeOperation, error) {
	return c.internalClient.SetInstanceMachineType(ctx, req, opts...)
}

// SetInstanceMachineTypeOperation returns a new SetInstanceMachineTypeOperation from a given name.
// The name must be that of a previously created SetInstanceMachineTypeOperation, possibly from a different process.
func (c *NotebookClient) SetInstanceMachineTypeOperation(name string) *SetInstanceMachineTypeOperation {
	return c.internalClient.SetInstanceMachineTypeOperation(name)
}

// UpdateInstanceConfig update Notebook Instance configurations.
func (c *NotebookClient) UpdateInstanceConfig(ctx context.Context, req *notebookspb.UpdateInstanceConfigRequest, opts ...gax.CallOption) (*UpdateInstanceConfigOperation, error) {
	return c.internalClient.UpdateInstanceConfig(ctx, req, opts...)
}

// UpdateInstanceConfigOperation returns a new UpdateInstanceConfigOperation from a given name.
// The name must be that of a previously created UpdateInstanceConfigOperation, possibly from a different process.
func (c *NotebookClient) UpdateInstanceConfigOperation(name string) *UpdateInstanceConfigOperation {
	return c.internalClient.UpdateInstanceConfigOperation(name)
}

// UpdateShieldedInstanceConfig updates the Shielded instance configuration of a single Instance.
func (c *NotebookClient) UpdateShieldedInstanceConfig(ctx context.Context, req *notebookspb.UpdateShieldedInstanceConfigRequest, opts ...gax.CallOption) (*UpdateShieldedInstanceConfigOperation, error) {
	return c.internalClient.UpdateShieldedInstanceConfig(ctx, req, opts...)
}

// UpdateShieldedInstanceConfigOperation returns a new UpdateShieldedInstanceConfigOperation from a given name.
// The name must be that of a previously created UpdateShieldedInstanceConfigOperation, possibly from a different process.
func (c *NotebookClient) UpdateShieldedInstanceConfigOperation(name string) *UpdateShieldedInstanceConfigOperation {
	return c.internalClient.UpdateShieldedInstanceConfigOperation(name)
}

// SetInstanceLabels replaces all the labels of an Instance.
func (c *NotebookClient) SetInstanceLabels(ctx context.Context, req *notebookspb.SetInstanceLabelsRequest, opts ...gax.CallOption) (*SetInstanceLabelsOperation, error) {
	return c.internalClient.SetInstanceLabels(ctx, req, opts...)
}

// SetInstanceLabelsOperation returns a new SetInstanceLabelsOperation from a given name.
// The name must be that of a previously created SetInstanceLabelsOperation, possibly from a different process.
func (c *NotebookClient) SetInstanceLabelsOperation(name string) *SetInstanceLabelsOperation {
	return c.internalClient.SetInstanceLabelsOperation(name)
}

// UpdateInstanceMetadataItems add/update metadata items for an instance.
func (c *NotebookClient) UpdateInstanceMetadataItems(ctx context.Context, req *notebookspb.UpdateInstanceMetadataItemsRequest, opts ...gax.CallOption) (*notebookspb.UpdateInstanceMetadataItemsResponse, error) {
	return c.internalClient.UpdateInstanceMetadataItems(ctx, req, opts...)
}

// DeleteInstance deletes a single Instance.
func (c *NotebookClient) DeleteInstance(ctx context.Context, req *notebookspb.DeleteInstanceRequest, opts ...gax.CallOption) (*DeleteInstanceOperation, error) {
	return c.internalClient.DeleteInstance(ctx, req, opts...)
}

// DeleteInstanceOperation returns a new DeleteInstanceOperation from a given name.
// The name must be that of a previously created DeleteInstanceOperation, possibly from a different process.
func (c *NotebookClient) DeleteInstanceOperation(name string) *DeleteInstanceOperation {
	return c.internalClient.DeleteInstanceOperation(name)
}

// StartInstance starts a notebook instance.
func (c *NotebookClient) StartInstance(ctx context.Context, req *notebookspb.StartInstanceRequest, opts ...gax.CallOption) (*StartInstanceOperation, error) {
	return c.internalClient.StartInstance(ctx, req, opts...)
}

// StartInstanceOperation returns a new StartInstanceOperation from a given name.
// The name must be that of a previously created StartInstanceOperation, possibly from a different process.
func (c *NotebookClient) StartInstanceOperation(name string) *StartInstanceOperation {
	return c.internalClient.StartInstanceOperation(name)
}

// StopInstance stops a notebook instance.
func (c *NotebookClient) StopInstance(ctx context.Context, req *notebookspb.StopInstanceRequest, opts ...gax.CallOption) (*StopInstanceOperation, error) {
	return c.internalClient.StopInstance(ctx, req, opts...)
}

// StopInstanceOperation returns a new StopInstanceOperation from a given name.
// The name must be that of a previously created StopInstanceOperation, possibly from a different process.
func (c *NotebookClient) StopInstanceOperation(name string) *StopInstanceOperation {
	return c.internalClient.StopInstanceOperation(name)
}

// ResetInstance resets a notebook instance.
func (c *NotebookClient) ResetInstance(ctx context.Context, req *notebookspb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	return c.internalClient.ResetInstance(ctx, req, opts...)
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *NotebookClient) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return c.internalClient.ResetInstanceOperation(name)
}

// ReportInstanceInfo allows notebook instances to
// report their latest instance information to the Notebooks
// API server. The server will merge the reported information to
// the instance metadata store. Do not use this method directly.
func (c *NotebookClient) ReportInstanceInfo(ctx context.Context, req *notebookspb.ReportInstanceInfoRequest, opts ...gax.CallOption) (*ReportInstanceInfoOperation, error) {
	return c.internalClient.ReportInstanceInfo(ctx, req, opts...)
}

// ReportInstanceInfoOperation returns a new ReportInstanceInfoOperation from a given name.
// The name must be that of a previously created ReportInstanceInfoOperation, possibly from a different process.
func (c *NotebookClient) ReportInstanceInfoOperation(name string) *ReportInstanceInfoOperation {
	return c.internalClient.ReportInstanceInfoOperation(name)
}

// IsInstanceUpgradeable check if a notebook instance is upgradable.
func (c *NotebookClient) IsInstanceUpgradeable(ctx context.Context, req *notebookspb.IsInstanceUpgradeableRequest, opts ...gax.CallOption) (*notebookspb.IsInstanceUpgradeableResponse, error) {
	return c.internalClient.IsInstanceUpgradeable(ctx, req, opts...)
}

// GetInstanceHealth check if a notebook instance is healthy.
func (c *NotebookClient) GetInstanceHealth(ctx context.Context, req *notebookspb.GetInstanceHealthRequest, opts ...gax.CallOption) (*notebookspb.GetInstanceHealthResponse, error) {
	return c.internalClient.GetInstanceHealth(ctx, req, opts...)
}

// UpgradeInstance upgrades a notebook instance to the latest version.
func (c *NotebookClient) UpgradeInstance(ctx context.Context, req *notebookspb.UpgradeInstanceRequest, opts ...gax.CallOption) (*UpgradeInstanceOperation, error) {
	return c.internalClient.UpgradeInstance(ctx, req, opts...)
}

// UpgradeInstanceOperation returns a new UpgradeInstanceOperation from a given name.
// The name must be that of a previously created UpgradeInstanceOperation, possibly from a different process.
func (c *NotebookClient) UpgradeInstanceOperation(name string) *UpgradeInstanceOperation {
	return c.internalClient.UpgradeInstanceOperation(name)
}

// RollbackInstance rollbacks a notebook instance to the previous version.
func (c *NotebookClient) RollbackInstance(ctx context.Context, req *notebookspb.RollbackInstanceRequest, opts ...gax.CallOption) (*RollbackInstanceOperation, error) {
	return c.internalClient.RollbackInstance(ctx, req, opts...)
}

// RollbackInstanceOperation returns a new RollbackInstanceOperation from a given name.
// The name must be that of a previously created RollbackInstanceOperation, possibly from a different process.
func (c *NotebookClient) RollbackInstanceOperation(name string) *RollbackInstanceOperation {
	return c.internalClient.RollbackInstanceOperation(name)
}

// DiagnoseInstance creates a Diagnostic File and runs Diagnostic Tool given an Instance.
func (c *NotebookClient) DiagnoseInstance(ctx context.Context, req *notebookspb.DiagnoseInstanceRequest, opts ...gax.CallOption) (*DiagnoseInstanceOperation, error) {
	return c.internalClient.DiagnoseInstance(ctx, req, opts...)
}

// DiagnoseInstanceOperation returns a new DiagnoseInstanceOperation from a given name.
// The name must be that of a previously created DiagnoseInstanceOperation, possibly from a different process.
func (c *NotebookClient) DiagnoseInstanceOperation(name string) *DiagnoseInstanceOperation {
	return c.internalClient.DiagnoseInstanceOperation(name)
}

// UpgradeInstanceInternal allows notebook instances to
// call this endpoint to upgrade themselves. Do not use this method directly.
func (c *NotebookClient) UpgradeInstanceInternal(ctx context.Context, req *notebookspb.UpgradeInstanceInternalRequest, opts ...gax.CallOption) (*UpgradeInstanceInternalOperation, error) {
	return c.internalClient.UpgradeInstanceInternal(ctx, req, opts...)
}

// UpgradeInstanceInternalOperation returns a new UpgradeInstanceInternalOperation from a given name.
// The name must be that of a previously created UpgradeInstanceInternalOperation, possibly from a different process.
func (c *NotebookClient) UpgradeInstanceInternalOperation(name string) *UpgradeInstanceInternalOperation {
	return c.internalClient.UpgradeInstanceInternalOperation(name)
}

// ListEnvironments lists environments in a project.
func (c *NotebookClient) ListEnvironments(ctx context.Context, req *notebookspb.ListEnvironmentsRequest, opts ...gax.CallOption) *EnvironmentIterator {
	return c.internalClient.ListEnvironments(ctx, req, opts...)
}

// GetEnvironment gets details of a single Environment.
func (c *NotebookClient) GetEnvironment(ctx context.Context, req *notebookspb.GetEnvironmentRequest, opts ...gax.CallOption) (*notebookspb.Environment, error) {
	return c.internalClient.GetEnvironment(ctx, req, opts...)
}

// CreateEnvironment creates a new Environment.
func (c *NotebookClient) CreateEnvironment(ctx context.Context, req *notebookspb.CreateEnvironmentRequest, opts ...gax.CallOption) (*CreateEnvironmentOperation, error) {
	return c.internalClient.CreateEnvironment(ctx, req, opts...)
}

// CreateEnvironmentOperation returns a new CreateEnvironmentOperation from a given name.
// The name must be that of a previously created CreateEnvironmentOperation, possibly from a different process.
func (c *NotebookClient) CreateEnvironmentOperation(name string) *CreateEnvironmentOperation {
	return c.internalClient.CreateEnvironmentOperation(name)
}

// DeleteEnvironment deletes a single Environment.
func (c *NotebookClient) DeleteEnvironment(ctx context.Context, req *notebookspb.DeleteEnvironmentRequest, opts ...gax.CallOption) (*DeleteEnvironmentOperation, error) {
	return c.internalClient.DeleteEnvironment(ctx, req, opts...)
}

// DeleteEnvironmentOperation returns a new DeleteEnvironmentOperation from a given name.
// The name must be that of a previously created DeleteEnvironmentOperation, possibly from a different process.
func (c *NotebookClient) DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation {
	return c.internalClient.DeleteEnvironmentOperation(name)
}

// ListSchedules lists schedules in a given project and location.
func (c *NotebookClient) ListSchedules(ctx context.Context, req *notebookspb.ListSchedulesRequest, opts ...gax.CallOption) *ScheduleIterator {
	return c.internalClient.ListSchedules(ctx, req, opts...)
}

// GetSchedule gets details of schedule
func (c *NotebookClient) GetSchedule(ctx context.Context, req *notebookspb.GetScheduleRequest, opts ...gax.CallOption) (*notebookspb.Schedule, error) {
	return c.internalClient.GetSchedule(ctx, req, opts...)
}

// DeleteSchedule deletes schedule and all underlying jobs
func (c *NotebookClient) DeleteSchedule(ctx context.Context, req *notebookspb.DeleteScheduleRequest, opts ...gax.CallOption) (*DeleteScheduleOperation, error) {
	return c.internalClient.DeleteSchedule(ctx, req, opts...)
}

// DeleteScheduleOperation returns a new DeleteScheduleOperation from a given name.
// The name must be that of a previously created DeleteScheduleOperation, possibly from a different process.
func (c *NotebookClient) DeleteScheduleOperation(name string) *DeleteScheduleOperation {
	return c.internalClient.DeleteScheduleOperation(name)
}

// CreateSchedule creates a new Scheduled Notebook in a given project and location.
func (c *NotebookClient) CreateSchedule(ctx context.Context, req *notebookspb.CreateScheduleRequest, opts ...gax.CallOption) (*CreateScheduleOperation, error) {
	return c.internalClient.CreateSchedule(ctx, req, opts...)
}

// CreateScheduleOperation returns a new CreateScheduleOperation from a given name.
// The name must be that of a previously created CreateScheduleOperation, possibly from a different process.
func (c *NotebookClient) CreateScheduleOperation(name string) *CreateScheduleOperation {
	return c.internalClient.CreateScheduleOperation(name)
}

// TriggerSchedule triggers execution of an existing schedule.
func (c *NotebookClient) TriggerSchedule(ctx context.Context, req *notebookspb.TriggerScheduleRequest, opts ...gax.CallOption) (*TriggerScheduleOperation, error) {
	return c.internalClient.TriggerSchedule(ctx, req, opts...)
}

// TriggerScheduleOperation returns a new TriggerScheduleOperation from a given name.
// The name must be that of a previously created TriggerScheduleOperation, possibly from a different process.
func (c *NotebookClient) TriggerScheduleOperation(name string) *TriggerScheduleOperation {
	return c.internalClient.TriggerScheduleOperation(name)
}

// ListExecutions lists executions in a given project and location
func (c *NotebookClient) ListExecutions(ctx context.Context, req *notebookspb.ListExecutionsRequest, opts ...gax.CallOption) *ExecutionIterator {
	return c.internalClient.ListExecutions(ctx, req, opts...)
}

// GetExecution gets details of executions
func (c *NotebookClient) GetExecution(ctx context.Context, req *notebookspb.GetExecutionRequest, opts ...gax.CallOption) (*notebookspb.Execution, error) {
	return c.internalClient.GetExecution(ctx, req, opts...)
}

// DeleteExecution deletes execution
func (c *NotebookClient) DeleteExecution(ctx context.Context, req *notebookspb.DeleteExecutionRequest, opts ...gax.CallOption) (*DeleteExecutionOperation, error) {
	return c.internalClient.DeleteExecution(ctx, req, opts...)
}

// DeleteExecutionOperation returns a new DeleteExecutionOperation from a given name.
// The name must be that of a previously created DeleteExecutionOperation, possibly from a different process.
func (c *NotebookClient) DeleteExecutionOperation(name string) *DeleteExecutionOperation {
	return c.internalClient.DeleteExecutionOperation(name)
}

// CreateExecution creates a new Execution in a given project and location.
func (c *NotebookClient) CreateExecution(ctx context.Context, req *notebookspb.CreateExecutionRequest, opts ...gax.CallOption) (*CreateExecutionOperation, error) {
	return c.internalClient.CreateExecution(ctx, req, opts...)
}

// CreateExecutionOperation returns a new CreateExecutionOperation from a given name.
// The name must be that of a previously created CreateExecutionOperation, possibly from a different process.
func (c *NotebookClient) CreateExecutionOperation(name string) *CreateExecutionOperation {
	return c.internalClient.CreateExecutionOperation(name)
}

// GetLocation gets information about a location.
func (c *NotebookClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *NotebookClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *NotebookClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *NotebookClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *NotebookClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *NotebookClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// notebookGRPCClient is a client for interacting with Notebooks API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type notebookGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing NotebookClient
	CallOptions **NotebookCallOptions

	// The gRPC API client.
	notebookClient notebookspb.NotebookServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewNotebookClient creates a new notebook service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// API v1 service for Cloud AI Platform Notebooks.
func NewNotebookClient(ctx context.Context, opts ...option.ClientOption) (*NotebookClient, error) {
	clientOpts := defaultNotebookGRPCClientOptions()
	if newNotebookClientHook != nil {
		hookOpts, err := newNotebookClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := NotebookClient{CallOptions: defaultNotebookCallOptions()}

	c := &notebookGRPCClient{
		connPool:         connPool,
		notebookClient:   notebookspb.NewNotebookServiceClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:  iampb.NewIAMPolicyClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *notebookGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *notebookGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *notebookGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *notebookGRPCClient) ListInstances(ctx context.Context, req *notebookspb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListInstances[0:len((*c.CallOptions).ListInstances):len((*c.CallOptions).ListInstances)], opts...)
	it := &InstanceIterator{}
	req = proto.Clone(req).(*notebookspb.ListInstancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Instance, string, error) {
		resp := &notebookspb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListInstances, req, settings.GRPC, c.logger, "ListInstances")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetInstance(ctx context.Context, req *notebookspb.GetInstanceRequest, opts ...gax.CallOption) (*notebookspb.Instance, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	var resp *notebookspb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetInstance, req, settings.GRPC, c.logger, "GetInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) CreateInstance(ctx context.Context, req *notebookspb.CreateInstanceRequest, opts ...gax.CallOption) (*CreateInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateInstance[0:len((*c.CallOptions).CreateInstance):len((*c.CallOptions).CreateInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateInstance, req, settings.GRPC, c.logger, "CreateInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) RegisterInstance(ctx context.Context, req *notebookspb.RegisterInstanceRequest, opts ...gax.CallOption) (*RegisterInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RegisterInstance[0:len((*c.CallOptions).RegisterInstance):len((*c.CallOptions).RegisterInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.RegisterInstance, req, settings.GRPC, c.logger, "RegisterInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RegisterInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) SetInstanceAccelerator(ctx context.Context, req *notebookspb.SetInstanceAcceleratorRequest, opts ...gax.CallOption) (*SetInstanceAcceleratorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetInstanceAccelerator[0:len((*c.CallOptions).SetInstanceAccelerator):len((*c.CallOptions).SetInstanceAccelerator)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.SetInstanceAccelerator, req, settings.GRPC, c.logger, "SetInstanceAccelerator")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SetInstanceAcceleratorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) SetInstanceMachineType(ctx context.Context, req *notebookspb.SetInstanceMachineTypeRequest, opts ...gax.CallOption) (*SetInstanceMachineTypeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetInstanceMachineType[0:len((*c.CallOptions).SetInstanceMachineType):len((*c.CallOptions).SetInstanceMachineType)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.SetInstanceMachineType, req, settings.GRPC, c.logger, "SetInstanceMachineType")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SetInstanceMachineTypeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpdateInstanceConfig(ctx context.Context, req *notebookspb.UpdateInstanceConfigRequest, opts ...gax.CallOption) (*UpdateInstanceConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateInstanceConfig[0:len((*c.CallOptions).UpdateInstanceConfig):len((*c.CallOptions).UpdateInstanceConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpdateInstanceConfig, req, settings.GRPC, c.logger, "UpdateInstanceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateInstanceConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpdateShieldedInstanceConfig(ctx context.Context, req *notebookspb.UpdateShieldedInstanceConfigRequest, opts ...gax.CallOption) (*UpdateShieldedInstanceConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateShieldedInstanceConfig[0:len((*c.CallOptions).UpdateShieldedInstanceConfig):len((*c.CallOptions).UpdateShieldedInstanceConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpdateShieldedInstanceConfig, req, settings.GRPC, c.logger, "UpdateShieldedInstanceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateShieldedInstanceConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) SetInstanceLabels(ctx context.Context, req *notebookspb.SetInstanceLabelsRequest, opts ...gax.CallOption) (*SetInstanceLabelsOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetInstanceLabels[0:len((*c.CallOptions).SetInstanceLabels):len((*c.CallOptions).SetInstanceLabels)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.SetInstanceLabels, req, settings.GRPC, c.logger, "SetInstanceLabels")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SetInstanceLabelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpdateInstanceMetadataItems(ctx context.Context, req *notebookspb.UpdateInstanceMetadataItemsRequest, opts ...gax.CallOption) (*notebookspb.UpdateInstanceMetadataItemsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateInstanceMetadataItems[0:len((*c.CallOptions).UpdateInstanceMetadataItems):len((*c.CallOptions).UpdateInstanceMetadataItems)], opts...)
	var resp *notebookspb.UpdateInstanceMetadataItemsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpdateInstanceMetadataItems, req, settings.GRPC, c.logger, "UpdateInstanceMetadataItems")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) DeleteInstance(ctx context.Context, req *notebookspb.DeleteInstanceRequest, opts ...gax.CallOption) (*DeleteInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteInstance[0:len((*c.CallOptions).DeleteInstance):len((*c.CallOptions).DeleteInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteInstance, req, settings.GRPC, c.logger, "DeleteInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) StartInstance(ctx context.Context, req *notebookspb.StartInstanceRequest, opts ...gax.CallOption) (*StartInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartInstance[0:len((*c.CallOptions).StartInstance):len((*c.CallOptions).StartInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.StartInstance, req, settings.GRPC, c.logger, "StartInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) StopInstance(ctx context.Context, req *notebookspb.StopInstanceRequest, opts ...gax.CallOption) (*StopInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopInstance[0:len((*c.CallOptions).StopInstance):len((*c.CallOptions).StopInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.StopInstance, req, settings.GRPC, c.logger, "StopInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) ResetInstance(ctx context.Context, req *notebookspb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResetInstance[0:len((*c.CallOptions).ResetInstance):len((*c.CallOptions).ResetInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.ResetInstance, req, settings.GRPC, c.logger, "ResetInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) ReportInstanceInfo(ctx context.Context, req *notebookspb.ReportInstanceInfoRequest, opts ...gax.CallOption) (*ReportInstanceInfoOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReportInstanceInfo[0:len((*c.CallOptions).ReportInstanceInfo):len((*c.CallOptions).ReportInstanceInfo)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.ReportInstanceInfo, req, settings.GRPC, c.logger, "ReportInstanceInfo")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReportInstanceInfoOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) IsInstanceUpgradeable(ctx context.Context, req *notebookspb.IsInstanceUpgradeableRequest, opts ...gax.CallOption) (*notebookspb.IsInstanceUpgradeableResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "notebook_instance", url.QueryEscape(req.GetNotebookInstance()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).IsInstanceUpgradeable[0:len((*c.CallOptions).IsInstanceUpgradeable):len((*c.CallOptions).IsInstanceUpgradeable)], opts...)
	var resp *notebookspb.IsInstanceUpgradeableResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.IsInstanceUpgradeable, req, settings.GRPC, c.logger, "IsInstanceUpgradeable")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) GetInstanceHealth(ctx context.Context, req *notebookspb.GetInstanceHealthRequest, opts ...gax.CallOption) (*notebookspb.GetInstanceHealthResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstanceHealth[0:len((*c.CallOptions).GetInstanceHealth):len((*c.CallOptions).GetInstanceHealth)], opts...)
	var resp *notebookspb.GetInstanceHealthResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetInstanceHealth, req, settings.GRPC, c.logger, "GetInstanceHealth")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) UpgradeInstance(ctx context.Context, req *notebookspb.UpgradeInstanceRequest, opts ...gax.CallOption) (*UpgradeInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpgradeInstance[0:len((*c.CallOptions).UpgradeInstance):len((*c.CallOptions).UpgradeInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpgradeInstance, req, settings.GRPC, c.logger, "UpgradeInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpgradeInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) RollbackInstance(ctx context.Context, req *notebookspb.RollbackInstanceRequest, opts ...gax.CallOption) (*RollbackInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RollbackInstance[0:len((*c.CallOptions).RollbackInstance):len((*c.CallOptions).RollbackInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.RollbackInstance, req, settings.GRPC, c.logger, "RollbackInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RollbackInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) DiagnoseInstance(ctx context.Context, req *notebookspb.DiagnoseInstanceRequest, opts ...gax.CallOption) (*DiagnoseInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DiagnoseInstance[0:len((*c.CallOptions).DiagnoseInstance):len((*c.CallOptions).DiagnoseInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DiagnoseInstance, req, settings.GRPC, c.logger, "DiagnoseInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DiagnoseInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpgradeInstanceInternal(ctx context.Context, req *notebookspb.UpgradeInstanceInternalRequest, opts ...gax.CallOption) (*UpgradeInstanceInternalOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpgradeInstanceInternal[0:len((*c.CallOptions).UpgradeInstanceInternal):len((*c.CallOptions).UpgradeInstanceInternal)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpgradeInstanceInternal, req, settings.GRPC, c.logger, "UpgradeInstanceInternal")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpgradeInstanceInternalOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) ListEnvironments(ctx context.Context, req *notebookspb.ListEnvironmentsRequest, opts ...gax.CallOption) *EnvironmentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEnvironments[0:len((*c.CallOptions).ListEnvironments):len((*c.CallOptions).ListEnvironments)], opts...)
	it := &EnvironmentIterator{}
	req = proto.Clone(req).(*notebookspb.ListEnvironmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Environment, string, error) {
		resp := &notebookspb.ListEnvironmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListEnvironments, req, settings.GRPC, c.logger, "ListEnvironments")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEnvironments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetEnvironment(ctx context.Context, req *notebookspb.GetEnvironmentRequest, opts ...gax.CallOption) (*notebookspb.Environment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEnvironment[0:len((*c.CallOptions).GetEnvironment):len((*c.CallOptions).GetEnvironment)], opts...)
	var resp *notebookspb.Environment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetEnvironment, req, settings.GRPC, c.logger, "GetEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) CreateEnvironment(ctx context.Context, req *notebookspb.CreateEnvironmentRequest, opts ...gax.CallOption) (*CreateEnvironmentOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEnvironment[0:len((*c.CallOptions).CreateEnvironment):len((*c.CallOptions).CreateEnvironment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateEnvironment, req, settings.GRPC, c.logger, "CreateEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) DeleteEnvironment(ctx context.Context, req *notebookspb.DeleteEnvironmentRequest, opts ...gax.CallOption) (*DeleteEnvironmentOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEnvironment[0:len((*c.CallOptions).DeleteEnvironment):len((*c.CallOptions).DeleteEnvironment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteEnvironment, req, settings.GRPC, c.logger, "DeleteEnvironment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) ListSchedules(ctx context.Context, req *notebookspb.ListSchedulesRequest, opts ...gax.CallOption) *ScheduleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSchedules[0:len((*c.CallOptions).ListSchedules):len((*c.CallOptions).ListSchedules)], opts...)
	it := &ScheduleIterator{}
	req = proto.Clone(req).(*notebookspb.ListSchedulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Schedule, string, error) {
		resp := &notebookspb.ListSchedulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListSchedules, req, settings.GRPC, c.logger, "ListSchedules")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSchedules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetSchedule(ctx context.Context, req *notebookspb.GetScheduleRequest, opts ...gax.CallOption) (*notebookspb.Schedule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSchedule[0:len((*c.CallOptions).GetSchedule):len((*c.CallOptions).GetSchedule)], opts...)
	var resp *notebookspb.Schedule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetSchedule, req, settings.GRPC, c.logger, "GetSchedule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) DeleteSchedule(ctx context.Context, req *notebookspb.DeleteScheduleRequest, opts ...gax.CallOption) (*DeleteScheduleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSchedule[0:len((*c.CallOptions).DeleteSchedule):len((*c.CallOptions).DeleteSchedule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteSchedule, req, settings.GRPC, c.logger, "DeleteSchedule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) CreateSchedule(ctx context.Context, req *notebookspb.CreateScheduleRequest, opts ...gax.CallOption) (*CreateScheduleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSchedule[0:len((*c.CallOptions).CreateSchedule):len((*c.CallOptions).CreateSchedule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateSchedule, req, settings.GRPC, c.logger, "CreateSchedule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) TriggerSchedule(ctx context.Context, req *notebookspb.TriggerScheduleRequest, opts ...gax.CallOption) (*TriggerScheduleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TriggerSchedule[0:len((*c.CallOptions).TriggerSchedule):len((*c.CallOptions).TriggerSchedule)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.TriggerSchedule, req, settings.GRPC, c.logger, "TriggerSchedule")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &TriggerScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) ListExecutions(ctx context.Context, req *notebookspb.ListExecutionsRequest, opts ...gax.CallOption) *ExecutionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListExecutions[0:len((*c.CallOptions).ListExecutions):len((*c.CallOptions).ListExecutions)], opts...)
	it := &ExecutionIterator{}
	req = proto.Clone(req).(*notebookspb.ListExecutionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Execution, string, error) {
		resp := &notebookspb.ListExecutionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListExecutions, req, settings.GRPC, c.logger, "ListExecutions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetExecutions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetExecution(ctx context.Context, req *notebookspb.GetExecutionRequest, opts ...gax.CallOption) (*notebookspb.Execution, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetExecution[0:len((*c.CallOptions).GetExecution):len((*c.CallOptions).GetExecution)], opts...)
	var resp *notebookspb.Execution
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetExecution, req, settings.GRPC, c.logger, "GetExecution")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) DeleteExecution(ctx context.Context, req *notebookspb.DeleteExecutionRequest, opts ...gax.CallOption) (*DeleteExecutionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteExecution[0:len((*c.CallOptions).DeleteExecution):len((*c.CallOptions).DeleteExecution)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteExecution, req, settings.GRPC, c.logger, "DeleteExecution")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteExecutionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) CreateExecution(ctx context.Context, req *notebookspb.CreateExecutionRequest, opts ...gax.CallOption) (*CreateExecutionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateExecution[0:len((*c.CallOptions).CreateExecution):len((*c.CallOptions).CreateExecution)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateExecution, req, settings.GRPC, c.logger, "CreateExecution")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateExecutionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *notebookGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *notebookGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateEnvironmentOperation returns a new CreateEnvironmentOperation from a given name.
// The name must be that of a previously created CreateEnvironmentOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateEnvironmentOperation(name string) *CreateEnvironmentOperation {
	return &CreateEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateExecutionOperation returns a new CreateExecutionOperation from a given name.
// The name must be that of a previously created CreateExecutionOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateExecutionOperation(name string) *CreateExecutionOperation {
	return &CreateExecutionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateInstanceOperation returns a new CreateInstanceOperation from a given name.
// The name must be that of a previously created CreateInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateInstanceOperation(name string) *CreateInstanceOperation {
	return &CreateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateScheduleOperation returns a new CreateScheduleOperation from a given name.
// The name must be that of a previously created CreateScheduleOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateScheduleOperation(name string) *CreateScheduleOperation {
	return &CreateScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEnvironmentOperation returns a new DeleteEnvironmentOperation from a given name.
// The name must be that of a previously created DeleteEnvironmentOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteEnvironmentOperation(name string) *DeleteEnvironmentOperation {
	return &DeleteEnvironmentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteExecutionOperation returns a new DeleteExecutionOperation from a given name.
// The name must be that of a previously created DeleteExecutionOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteExecutionOperation(name string) *DeleteExecutionOperation {
	return &DeleteExecutionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteInstanceOperation returns a new DeleteInstanceOperation from a given name.
// The name must be that of a previously created DeleteInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteInstanceOperation(name string) *DeleteInstanceOperation {
	return &DeleteInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteScheduleOperation returns a new DeleteScheduleOperation from a given name.
// The name must be that of a previously created DeleteScheduleOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteScheduleOperation(name string) *DeleteScheduleOperation {
	return &DeleteScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DiagnoseInstanceOperation returns a new DiagnoseInstanceOperation from a given name.
// The name must be that of a previously created DiagnoseInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) DiagnoseInstanceOperation(name string) *DiagnoseInstanceOperation {
	return &DiagnoseInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RegisterInstanceOperation returns a new RegisterInstanceOperation from a given name.
// The name must be that of a previously created RegisterInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) RegisterInstanceOperation(name string) *RegisterInstanceOperation {
	return &RegisterInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReportInstanceInfoOperation returns a new ReportInstanceInfoOperation from a given name.
// The name must be that of a previously created ReportInstanceInfoOperation, possibly from a different process.
func (c *notebookGRPCClient) ReportInstanceInfoOperation(name string) *ReportInstanceInfoOperation {
	return &ReportInstanceInfoOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RollbackInstanceOperation returns a new RollbackInstanceOperation from a given name.
// The name must be that of a previously created RollbackInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) RollbackInstanceOperation(name string) *RollbackInstanceOperation {
	return &RollbackInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SetInstanceAcceleratorOperation returns a new SetInstanceAcceleratorOperation from a given name.
// The name must be that of a previously created SetInstanceAcceleratorOperation, possibly from a different process.
func (c *notebookGRPCClient) SetInstanceAcceleratorOperation(name string) *SetInstanceAcceleratorOperation {
	return &SetInstanceAcceleratorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SetInstanceLabelsOperation returns a new SetInstanceLabelsOperation from a given name.
// The name must be that of a previously created SetInstanceLabelsOperation, possibly from a different process.
func (c *notebookGRPCClient) SetInstanceLabelsOperation(name string) *SetInstanceLabelsOperation {
	return &SetInstanceLabelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SetInstanceMachineTypeOperation returns a new SetInstanceMachineTypeOperation from a given name.
// The name must be that of a previously created SetInstanceMachineTypeOperation, possibly from a different process.
func (c *notebookGRPCClient) SetInstanceMachineTypeOperation(name string) *SetInstanceMachineTypeOperation {
	return &SetInstanceMachineTypeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartInstanceOperation returns a new StartInstanceOperation from a given name.
// The name must be that of a previously created StartInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) StartInstanceOperation(name string) *StartInstanceOperation {
	return &StartInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopInstanceOperation returns a new StopInstanceOperation from a given name.
// The name must be that of a previously created StopInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) StopInstanceOperation(name string) *StopInstanceOperation {
	return &StopInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// TriggerScheduleOperation returns a new TriggerScheduleOperation from a given name.
// The name must be that of a previously created TriggerScheduleOperation, possibly from a different process.
func (c *notebookGRPCClient) TriggerScheduleOperation(name string) *TriggerScheduleOperation {
	return &TriggerScheduleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateInstanceConfigOperation returns a new UpdateInstanceConfigOperation from a given name.
// The name must be that of a previously created UpdateInstanceConfigOperation, possibly from a different process.
func (c *notebookGRPCClient) UpdateInstanceConfigOperation(name string) *UpdateInstanceConfigOperation {
	return &UpdateInstanceConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateShieldedInstanceConfigOperation returns a new UpdateShieldedInstanceConfigOperation from a given name.
// The name must be that of a previously created UpdateShieldedInstanceConfigOperation, possibly from a different process.
func (c *notebookGRPCClient) UpdateShieldedInstanceConfigOperation(name string) *UpdateShieldedInstanceConfigOperation {
	return &UpdateShieldedInstanceConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpgradeInstanceOperation returns a new UpgradeInstanceOperation from a given name.
// The name must be that of a previously created UpgradeInstanceOperation, possibly from a different process.
func (c *notebookGRPCClient) UpgradeInstanceOperation(name string) *UpgradeInstanceOperation {
	return &UpgradeInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpgradeInstanceInternalOperation returns a new UpgradeInstanceInternalOperation from a given name.
// The name must be that of a previously created UpgradeInstanceInternalOperation, possibly from a different process.
func (c *notebookGRPCClient) UpgradeInstanceInternalOperation(name string) *UpgradeInstanceInternalOperation {
	return &UpgradeInstanceInternalOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
