/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.util.function.Function;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.CheckReturnValue;
import org.mockito.InOrder;
import org.mockito.Incubating;
import org.mockito.MockSettings;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.MockingDetails;
import org.mockito.MockitoDebugger;
import org.mockito.MockitoFramework;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.debugging.MockitoDebuggerImpl;
import org.mockito.internal.framework.DefaultMockitoFramework;
import org.mockito.internal.session.DefaultMockitoSessionBuilder;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.session.MockitoSessionBuilder;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.LenientStubber;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.After;
import org.mockito.verification.Timeout;
import org.mockito.verification.VerificationAfterDelay;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

@CheckReturnValue
public class Mockito
extends ArgumentMatchers {
    static final MockitoCore MOCKITO_CORE = new MockitoCore();
    public static final Answer<Object> RETURNS_DEFAULTS = Answers.RETURNS_DEFAULTS;
    public static final Answer<Object> RETURNS_SMART_NULLS = Answers.RETURNS_SMART_NULLS;
    public static final Answer<Object> RETURNS_MOCKS = Answers.RETURNS_MOCKS;
    public static final Answer<Object> RETURNS_DEEP_STUBS = Answers.RETURNS_DEEP_STUBS;
    public static final Answer<Object> CALLS_REAL_METHODS = Answers.CALLS_REAL_METHODS;
    public static final Answer<Object> RETURNS_SELF = Answers.RETURNS_SELF;

    public static <T> T mock(Class<T> classToMock) {
        return Mockito.mock(classToMock, Mockito.withSettings());
    }

    public static <T> T mock(Class<T> classToMock, String name) {
        return Mockito.mock(classToMock, Mockito.withSettings().name(name).defaultAnswer(RETURNS_DEFAULTS));
    }

    public static MockingDetails mockingDetails(Object toInspect) {
        return MOCKITO_CORE.mockingDetails(toInspect);
    }

    public static <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return Mockito.mock(classToMock, Mockito.withSettings().defaultAnswer(defaultAnswer));
    }

    public static <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return MOCKITO_CORE.mock(classToMock, mockSettings);
    }

    public static <T> T spy(T object) {
        return (T)MOCKITO_CORE.mock(object.getClass(), Mockito.withSettings().spiedInstance(object).defaultAnswer(CALLS_REAL_METHODS));
    }

    @Incubating
    public static <T> T spy(Class<T> classToSpy) {
        return MOCKITO_CORE.mock(classToSpy, Mockito.withSettings().useConstructor(new Object[0]).defaultAnswer(CALLS_REAL_METHODS));
    }

    @Incubating
    public static <T> MockedStatic<T> mockStatic(Class<T> classToMock) {
        return Mockito.mockStatic(classToMock, Mockito.withSettings());
    }

    @Incubating
    public static <T> MockedStatic<T> mockStatic(Class<T> classToMock, Answer defaultAnswer) {
        return Mockito.mockStatic(classToMock, Mockito.withSettings().defaultAnswer(defaultAnswer));
    }

    @Incubating
    public static <T> MockedStatic<T> mockStatic(Class<T> classToMock, String name) {
        return Mockito.mockStatic(classToMock, Mockito.withSettings().name(name));
    }

    @Incubating
    public static <T> MockedStatic<T> mockStatic(Class<T> classToMock, MockSettings mockSettings) {
        return MOCKITO_CORE.mockStatic(classToMock, mockSettings);
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstructionWithAnswer(Class<T> classToMock, Answer defaultAnswer, Answer ... additionalAnswers) {
        return Mockito.mockConstruction(classToMock, (MockedConstruction.Context context) -> {
            if (context.getCount() == 1 || additionalAnswers.length == 0) {
                return Mockito.withSettings().defaultAnswer(defaultAnswer);
            }
            if (context.getCount() >= additionalAnswers.length) {
                return Mockito.withSettings().defaultAnswer(additionalAnswers[additionalAnswers.length - 1]);
            }
            return Mockito.withSettings().defaultAnswer(additionalAnswers[context.getCount() - 2]);
        }, (T mock, MockedConstruction.Context context) -> {});
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock) {
        return Mockito.mockConstruction(classToMock, (MockedConstruction.Context index) -> Mockito.withSettings(), (T mock, MockedConstruction.Context context) -> {});
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockedConstruction.MockInitializer<T> mockInitializer) {
        return Mockito.mockConstruction(classToMock, Mockito.withSettings(), mockInitializer);
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockSettings mockSettings) {
        return Mockito.mockConstruction(classToMock, (MockedConstruction.Context context) -> mockSettings);
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, Function<MockedConstruction.Context, MockSettings> mockSettingsFactory) {
        return Mockito.mockConstruction(classToMock, mockSettingsFactory, (T mock, MockedConstruction.Context context) -> {});
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockSettings mockSettings, MockedConstruction.MockInitializer<T> mockInitializer) {
        return Mockito.mockConstruction(classToMock, (MockedConstruction.Context index) -> mockSettings, mockInitializer);
    }

    @Incubating
    public static <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, Function<MockedConstruction.Context, MockSettings> mockSettingsFactory, MockedConstruction.MockInitializer<T> mockInitializer) {
        return MOCKITO_CORE.mockConstruction(classToMock, mockSettingsFactory, mockInitializer);
    }

    public static <T> OngoingStubbing<T> when(T methodCall) {
        return MOCKITO_CORE.when(methodCall);
    }

    public static <T> T verify(T mock) {
        return MOCKITO_CORE.verify(mock, Mockito.times(1));
    }

    public static <T> T verify(T mock, VerificationMode mode) {
        return MOCKITO_CORE.verify(mock, mode);
    }

    public static <T> void reset(T ... mocks) {
        MOCKITO_CORE.reset(mocks);
    }

    public static void clearAllCaches() {
        MOCKITO_CORE.clearAllCaches();
    }

    public static <T> void clearInvocations(T ... mocks) {
        MOCKITO_CORE.clearInvocations(mocks);
    }

    public static void verifyNoMoreInteractions(Object ... mocks) {
        MOCKITO_CORE.verifyNoMoreInteractions(mocks);
    }

    @Deprecated
    public static void verifyZeroInteractions(Object ... mocks) {
        MOCKITO_CORE.verifyNoMoreInteractions(mocks);
    }

    public static void verifyNoInteractions(Object ... mocks) {
        MOCKITO_CORE.verifyNoInteractions(mocks);
    }

    public static Stubber doThrow(Throwable ... toBeThrown) {
        return MOCKITO_CORE.stubber().doThrow(toBeThrown);
    }

    public static Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return MOCKITO_CORE.stubber().doThrow(toBeThrown);
    }

    public static Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... toBeThrownNext) {
        return MOCKITO_CORE.stubber().doThrow(toBeThrown, toBeThrownNext);
    }

    public static Stubber doCallRealMethod() {
        return MOCKITO_CORE.stubber().doCallRealMethod();
    }

    public static Stubber doAnswer(Answer answer) {
        return MOCKITO_CORE.stubber().doAnswer(answer);
    }

    public static Stubber doNothing() {
        return MOCKITO_CORE.stubber().doNothing();
    }

    public static Stubber doReturn(Object toBeReturned) {
        return MOCKITO_CORE.stubber().doReturn(toBeReturned);
    }

    public static Stubber doReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return MOCKITO_CORE.stubber().doReturn(toBeReturned, toBeReturnedNext);
    }

    public static InOrder inOrder(Object ... mocks) {
        return MOCKITO_CORE.inOrder(mocks);
    }

    public static Object[] ignoreStubs(Object ... mocks) {
        return MOCKITO_CORE.ignoreStubs(mocks);
    }

    public static VerificationMode times(int wantedNumberOfInvocations) {
        return VerificationModeFactory.times(wantedNumberOfInvocations);
    }

    public static VerificationMode never() {
        return Mockito.times(0);
    }

    public static VerificationMode atLeastOnce() {
        return VerificationModeFactory.atLeastOnce();
    }

    public static VerificationMode atLeast(int minNumberOfInvocations) {
        return VerificationModeFactory.atLeast(minNumberOfInvocations);
    }

    public static VerificationMode atMostOnce() {
        return VerificationModeFactory.atMostOnce();
    }

    public static VerificationMode atMost(int maxNumberOfInvocations) {
        return VerificationModeFactory.atMost(maxNumberOfInvocations);
    }

    public static VerificationMode calls(int wantedNumberOfInvocations) {
        return VerificationModeFactory.calls(wantedNumberOfInvocations);
    }

    public static VerificationMode only() {
        return VerificationModeFactory.only();
    }

    public static VerificationWithTimeout timeout(long millis) {
        return new Timeout(millis, VerificationModeFactory.times(1));
    }

    public static VerificationAfterDelay after(long millis) {
        return new After(millis, VerificationModeFactory.times(1));
    }

    public static void validateMockitoUsage() {
        MOCKITO_CORE.validateMockitoUsage();
    }

    public static MockSettings withSettings() {
        return new MockSettingsImpl().defaultAnswer(RETURNS_DEFAULTS);
    }

    public static VerificationMode description(String description) {
        return Mockito.times(1).description(description);
    }

    @Deprecated
    static MockitoDebugger debug() {
        return new MockitoDebuggerImpl();
    }

    @Incubating
    public static MockitoFramework framework() {
        return new DefaultMockitoFramework();
    }

    @Incubating
    public static MockitoSessionBuilder mockitoSession() {
        return new DefaultMockitoSessionBuilder();
    }

    @Incubating
    public static LenientStubber lenient() {
        return MOCKITO_CORE.lenient();
    }
}

