/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.tree;

public enum TurbineOperatorKind {
    POST_INCR("++", Precedence.POSTFIX),
    POST_DECR("--", Precedence.POSTFIX),
    PRE_INCR("++", Precedence.UNARY),
    PRE_DECR("--", Precedence.UNARY),
    UNARY_PLUS("+", Precedence.UNARY),
    NEG("-", Precedence.UNARY),
    BITWISE_COMP("~", Precedence.UNARY),
    NOT("!", Precedence.UNARY),
    MULT("*", Precedence.MULTIPLICATIVE),
    DIVIDE("/", Precedence.MULTIPLICATIVE),
    MODULO("%", Precedence.MULTIPLICATIVE),
    PLUS("+", Precedence.ADDITIVE),
    MINUS("-", Precedence.ADDITIVE),
    SHIFT_LEFT("<<", Precedence.SHIFT),
    SHIFT_RIGHT(">>", Precedence.SHIFT),
    UNSIGNED_SHIFT_RIGHT(">>>", Precedence.SHIFT),
    LESS_THAN("<", Precedence.RELATIONAL),
    GREATER_THAN(">", Precedence.RELATIONAL),
    GREATER_THAN_EQ(">=", Precedence.RELATIONAL),
    LESS_THAN_EQ("<=", Precedence.RELATIONAL),
    INSTANCE_OF("instanceof", Precedence.RELATIONAL),
    EQUAL("==", Precedence.EQUALITY),
    NOT_EQUAL("!=", Precedence.EQUALITY),
    BITWISE_AND("&", Precedence.BIT_AND),
    BITWISE_XOR("^", Precedence.BIT_XOR),
    BITWISE_OR("|", Precedence.BIT_IOR),
    AND("&&", Precedence.AND),
    OR("||", Precedence.OR),
    TERNARY("?", Precedence.TERNARY),
    ASSIGN("=", Precedence.ASSIGNMENT);

    private final String name;
    private final Precedence prec;

    private TurbineOperatorKind(String name, Precedence prec) {
        this.name = name;
        this.prec = prec;
    }

    public String toString() {
        return this.name;
    }

    public Precedence prec() {
        return this.prec;
    }

    public static enum Precedence {
        CAST(14),
        POSTFIX(13),
        UNARY(12),
        MULTIPLICATIVE(11),
        ADDITIVE(10),
        SHIFT(9),
        RELATIONAL(8),
        EQUALITY(7),
        BIT_AND(6),
        BIT_XOR(5),
        BIT_IOR(4),
        AND(3),
        OR(2),
        TERNARY(1),
        ASSIGNMENT(0);

        private final int rank;

        public int rank() {
            return this.rank;
        }

        private Precedence(int rank) {
            this.rank = rank;
        }
    }
}

