/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Object arrays are inferior to collections in almost every way. Prefer immutable collections (e.g., ImmutableSet, ImmutableList, etc.) over an object array whenever possible.", severity=BugPattern.SeverityLevel.WARNING)
public class AvoidObjectArrays
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of((Object)"com.tngtech.java.junit.dataprovider.DataProvider", (Object)"org.junit.runners.Parameterized.Parameters", (Object)"org.junit.experimental.theories.DataPoints", (Object)"junitparams.Parameters");

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (AvoidObjectArrays.shouldApplyApiChecks(method, state)) {
            if (AvoidObjectArrays.isObjectArray(method.getReturnType())) {
                state.reportMatch(this.createDescription(method.getReturnType(), state, "returning", "ImmutableList"));
            }
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)method);
            for (int i = 0; i < method.getParameters().size(); ++i) {
                VariableTree varTree = method.getParameters().get(i);
                if (!AvoidObjectArrays.isObjectArray(varTree) || methodSymbol.isVarArgs() && i == method.getParameters().size() - 1 || ASTHelpers.hasOverloadWithOnlyOneParameter((Symbol.MethodSymbol)methodSymbol, (Name)methodSymbol.name, (Type)state.getSymtab().iterableType, (VisitorState)state)) continue;
                state.reportMatch(this.createDescription(varTree.getType(), state, "accepting", "Iterable"));
            }
        }
        return Description.NO_MATCH;
    }

    private Description createDescription(Tree tree, VisitorState state, String verb, String newType) {
        boolean isMultiDimensional;
        Type type = ASTHelpers.getType((Tree)tree);
        Object message = String.format("Avoid %s a %s", verb, SuggestedFixes.prettyType((Type)type, (VisitorState)state));
        if (type instanceof Type.ArrayType && !(isMultiDimensional = (type = ((Type.ArrayType)type).getComponentType()) instanceof Type.ArrayType)) {
            message = (String)message + String.format("; consider an %s<%s> instead", newType, SuggestedFixes.prettyType((Type)type, (VisitorState)state));
        }
        return this.buildDescription(tree).setMessage((String)message).build();
    }

    private static boolean isObjectArray(Tree tree) {
        Type type = ASTHelpers.getType((Tree)tree);
        return type instanceof Type.ArrayType && !((Type.ArrayType)type).getComponentType().isPrimitive();
    }

    private static boolean shouldApplyApiChecks(MethodTree methodTree, VisitorState state) {
        if (Matchers.MAIN_METHOD.matches((Tree)methodTree, state)) {
            return false;
        }
        for (String annotationName : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Tree)methodTree, (String)annotationName, (VisitorState)state)) continue;
            return false;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (state.getTypes().closure(method.owner.type).stream().map(superType -> superType.tsym.getKind()).anyMatch(Predicate.isEqual((Object)ElementKind.ANNOTATION_TYPE))) {
            return false;
        }
        return ASTHelpers.methodIsPublicAndNotAnOverride((Symbol.MethodSymbol)method, (VisitorState)state);
    }
}

