/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Printing to standard output should only be used for debugging, not in production code", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class SystemOut
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private static final Matcher<ExpressionTree> SYSTEM_OUT = Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)System.class.getName(), (String)"out"), FieldMatchers.staticField((String)System.class.getName(), (String)"err")});
    private static final Matcher<ExpressionTree> PRINT_STACK_TRACE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Thread.class.getName()).named("dumpStack").withNoParameters(), Matchers.instanceMethod().onDescendantOf(Throwable.class.getName()).named("printStackTrace").withNoParameters()});

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (SYSTEM_OUT.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (PRINT_STACK_TRACE.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

