// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/storage/control/v2/storage_control.proto

package controlpb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	StorageControl_CreateFolder_FullMethodName                         = "/google.storage.control.v2.StorageControl/CreateFolder"
	StorageControl_DeleteFolder_FullMethodName                         = "/google.storage.control.v2.StorageControl/DeleteFolder"
	StorageControl_GetFolder_FullMethodName                            = "/google.storage.control.v2.StorageControl/GetFolder"
	StorageControl_ListFolders_FullMethodName                          = "/google.storage.control.v2.StorageControl/ListFolders"
	StorageControl_RenameFolder_FullMethodName                         = "/google.storage.control.v2.StorageControl/RenameFolder"
	StorageControl_GetStorageLayout_FullMethodName                     = "/google.storage.control.v2.StorageControl/GetStorageLayout"
	StorageControl_CreateManagedFolder_FullMethodName                  = "/google.storage.control.v2.StorageControl/CreateManagedFolder"
	StorageControl_DeleteManagedFolder_FullMethodName                  = "/google.storage.control.v2.StorageControl/DeleteManagedFolder"
	StorageControl_GetManagedFolder_FullMethodName                     = "/google.storage.control.v2.StorageControl/GetManagedFolder"
	StorageControl_ListManagedFolders_FullMethodName                   = "/google.storage.control.v2.StorageControl/ListManagedFolders"
	StorageControl_CreateAnywhereCache_FullMethodName                  = "/google.storage.control.v2.StorageControl/CreateAnywhereCache"
	StorageControl_UpdateAnywhereCache_FullMethodName                  = "/google.storage.control.v2.StorageControl/UpdateAnywhereCache"
	StorageControl_DisableAnywhereCache_FullMethodName                 = "/google.storage.control.v2.StorageControl/DisableAnywhereCache"
	StorageControl_PauseAnywhereCache_FullMethodName                   = "/google.storage.control.v2.StorageControl/PauseAnywhereCache"
	StorageControl_ResumeAnywhereCache_FullMethodName                  = "/google.storage.control.v2.StorageControl/ResumeAnywhereCache"
	StorageControl_GetAnywhereCache_FullMethodName                     = "/google.storage.control.v2.StorageControl/GetAnywhereCache"
	StorageControl_ListAnywhereCaches_FullMethodName                   = "/google.storage.control.v2.StorageControl/ListAnywhereCaches"
	StorageControl_GetProjectIntelligenceConfig_FullMethodName         = "/google.storage.control.v2.StorageControl/GetProjectIntelligenceConfig"
	StorageControl_UpdateProjectIntelligenceConfig_FullMethodName      = "/google.storage.control.v2.StorageControl/UpdateProjectIntelligenceConfig"
	StorageControl_GetFolderIntelligenceConfig_FullMethodName          = "/google.storage.control.v2.StorageControl/GetFolderIntelligenceConfig"
	StorageControl_UpdateFolderIntelligenceConfig_FullMethodName       = "/google.storage.control.v2.StorageControl/UpdateFolderIntelligenceConfig"
	StorageControl_GetOrganizationIntelligenceConfig_FullMethodName    = "/google.storage.control.v2.StorageControl/GetOrganizationIntelligenceConfig"
	StorageControl_UpdateOrganizationIntelligenceConfig_FullMethodName = "/google.storage.control.v2.StorageControl/UpdateOrganizationIntelligenceConfig"
	StorageControl_GetIamPolicy_FullMethodName                         = "/google.storage.control.v2.StorageControl/GetIamPolicy"
	StorageControl_SetIamPolicy_FullMethodName                         = "/google.storage.control.v2.StorageControl/SetIamPolicy"
	StorageControl_TestIamPermissions_FullMethodName                   = "/google.storage.control.v2.StorageControl/TestIamPermissions"
)

// StorageControlClient is the client API for StorageControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageControlClient interface {
	// Creates a new folder. This operation is only applicable to a hierarchical
	// namespace enabled bucket.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Permanently deletes an empty folder. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns metadata for the specified folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Retrieves a list of folders. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Renames a source folder to a destination folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket. During a rename, the
	// source and destination folders are locked until the long running operation
	// completes.
	RenameFolder(ctx context.Context, in *RenameFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the storage layout configuration for a given bucket.
	GetStorageLayout(ctx context.Context, in *GetStorageLayoutRequest, opts ...grpc.CallOption) (*StorageLayout, error)
	// Creates a new managed folder.
	CreateManagedFolder(ctx context.Context, in *CreateManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error)
	// Permanently deletes an empty managed folder.
	DeleteManagedFolder(ctx context.Context, in *DeleteManagedFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns metadata for the specified managed folder.
	GetManagedFolder(ctx context.Context, in *GetManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error)
	// Retrieves a list of managed folders for a given bucket.
	ListManagedFolders(ctx context.Context, in *ListManagedFoldersRequest, opts ...grpc.CallOption) (*ListManagedFoldersResponse, error)
	// Creates an Anywhere Cache instance.
	CreateAnywhereCache(ctx context.Context, in *CreateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an Anywhere Cache instance. Mutable fields include `ttl` and
	// `admission_policy`.
	UpdateAnywhereCache(ctx context.Context, in *UpdateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disables an Anywhere Cache instance. A disabled instance is read-only. The
	// disablement could be revoked by calling ResumeAnywhereCache. The cache
	// instance will be deleted automatically if it remains in the disabled state
	// for at least one hour.
	DisableAnywhereCache(ctx context.Context, in *DisableAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Pauses an Anywhere Cache instance.
	PauseAnywhereCache(ctx context.Context, in *PauseAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Resumes a disabled or paused Anywhere Cache instance.
	ResumeAnywhereCache(ctx context.Context, in *ResumeAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Gets an Anywhere Cache instance.
	GetAnywhereCache(ctx context.Context, in *GetAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Lists Anywhere Cache instances for a given bucket.
	ListAnywhereCaches(ctx context.Context, in *ListAnywhereCachesRequest, opts ...grpc.CallOption) (*ListAnywhereCachesResponse, error)
	// Returns the Project scoped singleton IntelligenceConfig resource.
	GetProjectIntelligenceConfig(ctx context.Context, in *GetProjectIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Updates the Project scoped singleton IntelligenceConfig resource.
	UpdateProjectIntelligenceConfig(ctx context.Context, in *UpdateProjectIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Returns the Folder scoped singleton IntelligenceConfig resource.
	GetFolderIntelligenceConfig(ctx context.Context, in *GetFolderIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Updates the Folder scoped singleton IntelligenceConfig resource.
	UpdateFolderIntelligenceConfig(ctx context.Context, in *UpdateFolderIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Returns the Organization scoped singleton IntelligenceConfig resource.
	GetOrganizationIntelligenceConfig(ctx context.Context, in *GetOrganizationIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Updates the Organization scoped singleton IntelligenceConfig resource.
	UpdateOrganizationIntelligenceConfig(ctx context.Context, in *UpdateOrganizationIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error)
	// Gets the IAM policy for a specified bucket.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Updates an IAM policy for the specified bucket.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests a set of permissions on the given bucket, object, or managed folder
	// to see which, if any, are held by the caller.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket,
	// `projects/_/buckets/{bucket}/objects/{object}` for an object, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type storageControlClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageControlClient(cc grpc.ClientConnInterface) StorageControlClient {
	return &storageControlClient{cc}
}

func (c *storageControlClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, StorageControl_CreateFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageControl_DeleteFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, StorageControl_GetFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, StorageControl_ListFolders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) RenameFolder(ctx context.Context, in *RenameFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, StorageControl_RenameFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetStorageLayout(ctx context.Context, in *GetStorageLayoutRequest, opts ...grpc.CallOption) (*StorageLayout, error) {
	out := new(StorageLayout)
	err := c.cc.Invoke(ctx, StorageControl_GetStorageLayout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) CreateManagedFolder(ctx context.Context, in *CreateManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error) {
	out := new(ManagedFolder)
	err := c.cc.Invoke(ctx, StorageControl_CreateManagedFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DeleteManagedFolder(ctx context.Context, in *DeleteManagedFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageControl_DeleteManagedFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetManagedFolder(ctx context.Context, in *GetManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error) {
	out := new(ManagedFolder)
	err := c.cc.Invoke(ctx, StorageControl_GetManagedFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListManagedFolders(ctx context.Context, in *ListManagedFoldersRequest, opts ...grpc.CallOption) (*ListManagedFoldersResponse, error) {
	out := new(ListManagedFoldersResponse)
	err := c.cc.Invoke(ctx, StorageControl_ListManagedFolders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) CreateAnywhereCache(ctx context.Context, in *CreateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, StorageControl_CreateAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) UpdateAnywhereCache(ctx context.Context, in *UpdateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, StorageControl_UpdateAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DisableAnywhereCache(ctx context.Context, in *DisableAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, StorageControl_DisableAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) PauseAnywhereCache(ctx context.Context, in *PauseAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, StorageControl_PauseAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ResumeAnywhereCache(ctx context.Context, in *ResumeAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, StorageControl_ResumeAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetAnywhereCache(ctx context.Context, in *GetAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, StorageControl_GetAnywhereCache_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListAnywhereCaches(ctx context.Context, in *ListAnywhereCachesRequest, opts ...grpc.CallOption) (*ListAnywhereCachesResponse, error) {
	out := new(ListAnywhereCachesResponse)
	err := c.cc.Invoke(ctx, StorageControl_ListAnywhereCaches_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetProjectIntelligenceConfig(ctx context.Context, in *GetProjectIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_GetProjectIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) UpdateProjectIntelligenceConfig(ctx context.Context, in *UpdateProjectIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_UpdateProjectIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetFolderIntelligenceConfig(ctx context.Context, in *GetFolderIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_GetFolderIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) UpdateFolderIntelligenceConfig(ctx context.Context, in *UpdateFolderIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_UpdateFolderIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetOrganizationIntelligenceConfig(ctx context.Context, in *GetOrganizationIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_GetOrganizationIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) UpdateOrganizationIntelligenceConfig(ctx context.Context, in *UpdateOrganizationIntelligenceConfigRequest, opts ...grpc.CallOption) (*IntelligenceConfig, error) {
	out := new(IntelligenceConfig)
	err := c.cc.Invoke(ctx, StorageControl_UpdateOrganizationIntelligenceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, StorageControl_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, StorageControl_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, StorageControl_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageControlServer is the server API for StorageControl service.
// All implementations should embed UnimplementedStorageControlServer
// for forward compatibility
type StorageControlServer interface {
	// Creates a new folder. This operation is only applicable to a hierarchical
	// namespace enabled bucket.
	CreateFolder(context.Context, *CreateFolderRequest) (*Folder, error)
	// Permanently deletes an empty folder. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*emptypb.Empty, error)
	// Returns metadata for the specified folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Retrieves a list of folders. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Renames a source folder to a destination folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket. During a rename, the
	// source and destination folders are locked until the long running operation
	// completes.
	RenameFolder(context.Context, *RenameFolderRequest) (*longrunningpb.Operation, error)
	// Returns the storage layout configuration for a given bucket.
	GetStorageLayout(context.Context, *GetStorageLayoutRequest) (*StorageLayout, error)
	// Creates a new managed folder.
	CreateManagedFolder(context.Context, *CreateManagedFolderRequest) (*ManagedFolder, error)
	// Permanently deletes an empty managed folder.
	DeleteManagedFolder(context.Context, *DeleteManagedFolderRequest) (*emptypb.Empty, error)
	// Returns metadata for the specified managed folder.
	GetManagedFolder(context.Context, *GetManagedFolderRequest) (*ManagedFolder, error)
	// Retrieves a list of managed folders for a given bucket.
	ListManagedFolders(context.Context, *ListManagedFoldersRequest) (*ListManagedFoldersResponse, error)
	// Creates an Anywhere Cache instance.
	CreateAnywhereCache(context.Context, *CreateAnywhereCacheRequest) (*longrunningpb.Operation, error)
	// Updates an Anywhere Cache instance. Mutable fields include `ttl` and
	// `admission_policy`.
	UpdateAnywhereCache(context.Context, *UpdateAnywhereCacheRequest) (*longrunningpb.Operation, error)
	// Disables an Anywhere Cache instance. A disabled instance is read-only. The
	// disablement could be revoked by calling ResumeAnywhereCache. The cache
	// instance will be deleted automatically if it remains in the disabled state
	// for at least one hour.
	DisableAnywhereCache(context.Context, *DisableAnywhereCacheRequest) (*AnywhereCache, error)
	// Pauses an Anywhere Cache instance.
	PauseAnywhereCache(context.Context, *PauseAnywhereCacheRequest) (*AnywhereCache, error)
	// Resumes a disabled or paused Anywhere Cache instance.
	ResumeAnywhereCache(context.Context, *ResumeAnywhereCacheRequest) (*AnywhereCache, error)
	// Gets an Anywhere Cache instance.
	GetAnywhereCache(context.Context, *GetAnywhereCacheRequest) (*AnywhereCache, error)
	// Lists Anywhere Cache instances for a given bucket.
	ListAnywhereCaches(context.Context, *ListAnywhereCachesRequest) (*ListAnywhereCachesResponse, error)
	// Returns the Project scoped singleton IntelligenceConfig resource.
	GetProjectIntelligenceConfig(context.Context, *GetProjectIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Updates the Project scoped singleton IntelligenceConfig resource.
	UpdateProjectIntelligenceConfig(context.Context, *UpdateProjectIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Returns the Folder scoped singleton IntelligenceConfig resource.
	GetFolderIntelligenceConfig(context.Context, *GetFolderIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Updates the Folder scoped singleton IntelligenceConfig resource.
	UpdateFolderIntelligenceConfig(context.Context, *UpdateFolderIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Returns the Organization scoped singleton IntelligenceConfig resource.
	GetOrganizationIntelligenceConfig(context.Context, *GetOrganizationIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Updates the Organization scoped singleton IntelligenceConfig resource.
	UpdateOrganizationIntelligenceConfig(context.Context, *UpdateOrganizationIntelligenceConfigRequest) (*IntelligenceConfig, error)
	// Gets the IAM policy for a specified bucket.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Updates an IAM policy for the specified bucket.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Tests a set of permissions on the given bucket, object, or managed folder
	// to see which, if any, are held by the caller.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket,
	// `projects/_/buckets/{bucket}/objects/{object}` for an object, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedStorageControlServer should be embedded to have forward compatible implementations.
type UnimplementedStorageControlServer struct {
}

func (UnimplementedStorageControlServer) CreateFolder(context.Context, *CreateFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFolder not implemented")
}
func (UnimplementedStorageControlServer) DeleteFolder(context.Context, *DeleteFolderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFolder not implemented")
}
func (UnimplementedStorageControlServer) GetFolder(context.Context, *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolder not implemented")
}
func (UnimplementedStorageControlServer) ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFolders not implemented")
}
func (UnimplementedStorageControlServer) RenameFolder(context.Context, *RenameFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameFolder not implemented")
}
func (UnimplementedStorageControlServer) GetStorageLayout(context.Context, *GetStorageLayoutRequest) (*StorageLayout, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStorageLayout not implemented")
}
func (UnimplementedStorageControlServer) CreateManagedFolder(context.Context, *CreateManagedFolderRequest) (*ManagedFolder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateManagedFolder not implemented")
}
func (UnimplementedStorageControlServer) DeleteManagedFolder(context.Context, *DeleteManagedFolderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteManagedFolder not implemented")
}
func (UnimplementedStorageControlServer) GetManagedFolder(context.Context, *GetManagedFolderRequest) (*ManagedFolder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManagedFolder not implemented")
}
func (UnimplementedStorageControlServer) ListManagedFolders(context.Context, *ListManagedFoldersRequest) (*ListManagedFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListManagedFolders not implemented")
}
func (UnimplementedStorageControlServer) CreateAnywhereCache(context.Context, *CreateAnywhereCacheRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) UpdateAnywhereCache(context.Context, *UpdateAnywhereCacheRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) DisableAnywhereCache(context.Context, *DisableAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) PauseAnywhereCache(context.Context, *PauseAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) ResumeAnywhereCache(context.Context, *ResumeAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) GetAnywhereCache(context.Context, *GetAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnywhereCache not implemented")
}
func (UnimplementedStorageControlServer) ListAnywhereCaches(context.Context, *ListAnywhereCachesRequest) (*ListAnywhereCachesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnywhereCaches not implemented")
}
func (UnimplementedStorageControlServer) GetProjectIntelligenceConfig(context.Context, *GetProjectIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) UpdateProjectIntelligenceConfig(context.Context, *UpdateProjectIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProjectIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) GetFolderIntelligenceConfig(context.Context, *GetFolderIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolderIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) UpdateFolderIntelligenceConfig(context.Context, *UpdateFolderIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFolderIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) GetOrganizationIntelligenceConfig(context.Context, *GetOrganizationIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) UpdateOrganizationIntelligenceConfig(context.Context, *UpdateOrganizationIntelligenceConfigRequest) (*IntelligenceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationIntelligenceConfig not implemented")
}
func (UnimplementedStorageControlServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedStorageControlServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedStorageControlServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeStorageControlServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageControlServer will
// result in compilation errors.
type UnsafeStorageControlServer interface {
	mustEmbedUnimplementedStorageControlServer()
}

func RegisterStorageControlServer(s grpc.ServiceRegistrar, srv StorageControlServer) {
	s.RegisterService(&StorageControl_ServiceDesc, srv)
}

func _StorageControl_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_CreateFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_DeleteFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_ListFolders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_RenameFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).RenameFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_RenameFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).RenameFolder(ctx, req.(*RenameFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetStorageLayout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStorageLayoutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetStorageLayout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetStorageLayout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetStorageLayout(ctx, req.(*GetStorageLayoutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_CreateManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_CreateManagedFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateManagedFolder(ctx, req.(*CreateManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DeleteManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DeleteManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_DeleteManagedFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DeleteManagedFolder(ctx, req.(*DeleteManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetManagedFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetManagedFolder(ctx, req.(*GetManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListManagedFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagedFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListManagedFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_ListManagedFolders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListManagedFolders(ctx, req.(*ListManagedFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_CreateAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_CreateAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateAnywhereCache(ctx, req.(*CreateAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_UpdateAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).UpdateAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_UpdateAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).UpdateAnywhereCache(ctx, req.(*UpdateAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DisableAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DisableAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_DisableAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DisableAnywhereCache(ctx, req.(*DisableAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_PauseAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).PauseAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_PauseAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).PauseAnywhereCache(ctx, req.(*PauseAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ResumeAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ResumeAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_ResumeAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ResumeAnywhereCache(ctx, req.(*ResumeAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetAnywhereCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetAnywhereCache(ctx, req.(*GetAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListAnywhereCaches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnywhereCachesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListAnywhereCaches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_ListAnywhereCaches_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListAnywhereCaches(ctx, req.(*ListAnywhereCachesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetProjectIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetProjectIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetProjectIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetProjectIntelligenceConfig(ctx, req.(*GetProjectIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_UpdateProjectIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).UpdateProjectIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_UpdateProjectIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).UpdateProjectIntelligenceConfig(ctx, req.(*UpdateProjectIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetFolderIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetFolderIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetFolderIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetFolderIntelligenceConfig(ctx, req.(*GetFolderIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_UpdateFolderIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).UpdateFolderIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_UpdateFolderIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).UpdateFolderIntelligenceConfig(ctx, req.(*UpdateFolderIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetOrganizationIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetOrganizationIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetOrganizationIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetOrganizationIntelligenceConfig(ctx, req.(*GetOrganizationIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_UpdateOrganizationIntelligenceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationIntelligenceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).UpdateOrganizationIntelligenceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_UpdateOrganizationIntelligenceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).UpdateOrganizationIntelligenceConfig(ctx, req.(*UpdateOrganizationIntelligenceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageControl_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StorageControl_ServiceDesc is the grpc.ServiceDesc for StorageControl service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StorageControl_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.control.v2.StorageControl",
	HandlerType: (*StorageControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFolder",
			Handler:    _StorageControl_CreateFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _StorageControl_DeleteFolder_Handler,
		},
		{
			MethodName: "GetFolder",
			Handler:    _StorageControl_GetFolder_Handler,
		},
		{
			MethodName: "ListFolders",
			Handler:    _StorageControl_ListFolders_Handler,
		},
		{
			MethodName: "RenameFolder",
			Handler:    _StorageControl_RenameFolder_Handler,
		},
		{
			MethodName: "GetStorageLayout",
			Handler:    _StorageControl_GetStorageLayout_Handler,
		},
		{
			MethodName: "CreateManagedFolder",
			Handler:    _StorageControl_CreateManagedFolder_Handler,
		},
		{
			MethodName: "DeleteManagedFolder",
			Handler:    _StorageControl_DeleteManagedFolder_Handler,
		},
		{
			MethodName: "GetManagedFolder",
			Handler:    _StorageControl_GetManagedFolder_Handler,
		},
		{
			MethodName: "ListManagedFolders",
			Handler:    _StorageControl_ListManagedFolders_Handler,
		},
		{
			MethodName: "CreateAnywhereCache",
			Handler:    _StorageControl_CreateAnywhereCache_Handler,
		},
		{
			MethodName: "UpdateAnywhereCache",
			Handler:    _StorageControl_UpdateAnywhereCache_Handler,
		},
		{
			MethodName: "DisableAnywhereCache",
			Handler:    _StorageControl_DisableAnywhereCache_Handler,
		},
		{
			MethodName: "PauseAnywhereCache",
			Handler:    _StorageControl_PauseAnywhereCache_Handler,
		},
		{
			MethodName: "ResumeAnywhereCache",
			Handler:    _StorageControl_ResumeAnywhereCache_Handler,
		},
		{
			MethodName: "GetAnywhereCache",
			Handler:    _StorageControl_GetAnywhereCache_Handler,
		},
		{
			MethodName: "ListAnywhereCaches",
			Handler:    _StorageControl_ListAnywhereCaches_Handler,
		},
		{
			MethodName: "GetProjectIntelligenceConfig",
			Handler:    _StorageControl_GetProjectIntelligenceConfig_Handler,
		},
		{
			MethodName: "UpdateProjectIntelligenceConfig",
			Handler:    _StorageControl_UpdateProjectIntelligenceConfig_Handler,
		},
		{
			MethodName: "GetFolderIntelligenceConfig",
			Handler:    _StorageControl_GetFolderIntelligenceConfig_Handler,
		},
		{
			MethodName: "UpdateFolderIntelligenceConfig",
			Handler:    _StorageControl_UpdateFolderIntelligenceConfig_Handler,
		},
		{
			MethodName: "GetOrganizationIntelligenceConfig",
			Handler:    _StorageControl_GetOrganizationIntelligenceConfig_Handler,
		},
		{
			MethodName: "UpdateOrganizationIntelligenceConfig",
			Handler:    _StorageControl_UpdateOrganizationIntelligenceConfig_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _StorageControl_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _StorageControl_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _StorageControl_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/storage/control/v2/storage_control.proto",
}
