// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/analyticshub/v1/pubsub.proto

package analyticshubpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the destination Pub/Sub subscription.
// If none of `push_config`, `bigquery_config`, `cloud_storage_config`,
// `pubsub_export_config`, or `pubsublite_export_config`
// is set, then the subscriber will pull and ack messages using API methods. At
// most one of these fields may be set.
type PubSubSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If push delivery is used with this subscription, this field is
	// used to configure it.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	// Optional. If delivery to BigQuery is used with this subscription, this
	// field is used to configure it.
	BigqueryConfig *BigQueryConfig `protobuf:"bytes,18,opt,name=bigquery_config,json=bigqueryConfig,proto3" json:"bigquery_config,omitempty"`
	// Optional. If delivery to Google Cloud Storage is used with this
	// subscription, this field is used to configure it.
	CloudStorageConfig *CloudStorageConfig `protobuf:"bytes,22,opt,name=cloud_storage_config,json=cloudStorageConfig,proto3" json:"cloud_storage_config,omitempty"`
	// Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
	// waits for the subscriber to acknowledge receipt before resending the
	// message. In the interval after the message is delivered and before it is
	// acknowledged, it is considered to be _outstanding_. During that time
	// period, the message will not be redelivered (on a best-effort basis).
	//
	// For pull subscriptions, this value is used as the initial value for the ack
	// deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using
	// non-streaming pull or send the `ack_id` in a
	// `StreamingModifyAckDeadlineRequest` if using streaming pull.
	// The minimum custom deadline you can specify is 10 seconds.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes).
	// If this parameter is 0, a default value of 10 seconds is used.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	// Optional. Indicates whether to retain acknowledged messages. If true, then
	// messages are not expunged from the subscription's backlog, even if they are
	// acknowledged, until they fall out of the `message_retention_duration`
	// window. This must be true if you would like to [`Seek` to a timestamp]
	// (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
	// the past to replay previously-acknowledged messages.
	RetainAckedMessages bool `protobuf:"varint,7,opt,name=retain_acked_messages,json=retainAckedMessages,proto3" json:"retain_acked_messages,omitempty"`
	// Optional. How long to retain unacknowledged messages in the subscription's
	// backlog, from the moment a message is published. If `retain_acked_messages`
	// is true, then this also configures the retention of acknowledged messages,
	// and thus configures how far back in time a `Seek` can be done. Defaults to
	// 7 days. Cannot be more than 31 days or less than 10 minutes.
	MessageRetentionDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=message_retention_duration,json=messageRetentionDuration,proto3" json:"message_retention_duration,omitempty"`
	// Optional. See [Creating and managing
	// labels](https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. If true, messages published with the same `ordering_key` in
	// `PubsubMessage` will be delivered to the subscribers in the order in which
	// they are received by the Pub/Sub system. Otherwise, they may be delivered
	// in any order.
	EnableMessageOrdering bool `protobuf:"varint,10,opt,name=enable_message_ordering,json=enableMessageOrdering,proto3" json:"enable_message_ordering,omitempty"`
	// Optional. A policy that specifies the conditions for this subscription's
	// expiration. A subscription is considered active as long as any connected
	// subscriber is successfully consuming messages from the subscription or is
	// issuing operations on the subscription. If `expiration_policy` is not set,
	// a *default policy* with `ttl` of 31 days will be used. The minimum allowed
	// value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
	// but `expiration_policy.ttl` is not set, the subscription never expires.
	ExpirationPolicy *ExpirationPolicy `protobuf:"bytes,11,opt,name=expiration_policy,json=expirationPolicy,proto3" json:"expiration_policy,omitempty"`
	// Optional. An expression written in the Pub/Sub [filter
	// language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
	// then only `PubsubMessage`s whose `attributes` field matches the filter are
	// delivered on this subscription. If empty, then no messages are filtered
	// out.
	Filter string `protobuf:"bytes,12,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A policy that specifies the conditions for dead lettering
	// messages in this subscription. If dead_letter_policy is not set, dead
	// lettering is disabled.
	//
	// The Pub/Sub service account associated with this subscriptions's
	// parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Acknowledge() messages on this subscription.
	DeadLetterPolicy *DeadLetterPolicy `protobuf:"bytes,13,opt,name=dead_letter_policy,json=deadLetterPolicy,proto3" json:"dead_letter_policy,omitempty"`
	// Optional. A policy that specifies how Pub/Sub retries message delivery for
	// this subscription.
	//
	// If not set, the default retry policy is applied. This generally implies
	// that messages will be retried as soon as possible for healthy subscribers.
	// RetryPolicy will be triggered on NACKs or acknowledgement deadline
	// exceeded events for a given message.
	RetryPolicy *RetryPolicy `protobuf:"bytes,14,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Optional. Indicates whether the subscription is detached from its topic.
	// Detached subscriptions don't receive messages from their topic and don't
	// retain any backlog. `Pull` and `StreamingPull` requests will return
	// FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
	// the endpoint will not be made.
	Detached bool `protobuf:"varint,15,opt,name=detached,proto3" json:"detached,omitempty"`
	// Optional. If true, Pub/Sub provides the following guarantees for the
	// delivery of a message with a given value of `message_id` on this
	// subscription:
	//
	// * The message sent to a subscriber is guaranteed not to be resent
	// before the message's acknowledgement deadline expires.
	// * An acknowledged message will not be resent to a subscriber.
	//
	// Note that subscribers may still receive multiple copies of a message
	// when `enable_exactly_once_delivery` is true if the message was published
	// multiple times by a publisher client. These copies are  considered distinct
	// by Pub/Sub and have distinct `message_id` values.
	EnableExactlyOnceDelivery bool `protobuf:"varint,16,opt,name=enable_exactly_once_delivery,json=enableExactlyOnceDelivery,proto3" json:"enable_exactly_once_delivery,omitempty"`
	// Optional. Transforms to be applied to messages before they are delivered to
	// subscribers. Transforms are applied in the order specified.
	MessageTransforms []*MessageTransform `protobuf:"bytes,25,rep,name=message_transforms,json=messageTransforms,proto3" json:"message_transforms,omitempty"`
}

func (x *PubSubSubscription) Reset() {
	*x = PubSubSubscription{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PubSubSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubSubscription) ProtoMessage() {}

func (x *PubSubSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubSubscription.ProtoReflect.Descriptor instead.
func (*PubSubSubscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{0}
}

func (x *PubSubSubscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PubSubSubscription) GetPushConfig() *PushConfig {
	if x != nil {
		return x.PushConfig
	}
	return nil
}

func (x *PubSubSubscription) GetBigqueryConfig() *BigQueryConfig {
	if x != nil {
		return x.BigqueryConfig
	}
	return nil
}

func (x *PubSubSubscription) GetCloudStorageConfig() *CloudStorageConfig {
	if x != nil {
		return x.CloudStorageConfig
	}
	return nil
}

func (x *PubSubSubscription) GetAckDeadlineSeconds() int32 {
	if x != nil {
		return x.AckDeadlineSeconds
	}
	return 0
}

func (x *PubSubSubscription) GetRetainAckedMessages() bool {
	if x != nil {
		return x.RetainAckedMessages
	}
	return false
}

func (x *PubSubSubscription) GetMessageRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.MessageRetentionDuration
	}
	return nil
}

func (x *PubSubSubscription) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PubSubSubscription) GetEnableMessageOrdering() bool {
	if x != nil {
		return x.EnableMessageOrdering
	}
	return false
}

func (x *PubSubSubscription) GetExpirationPolicy() *ExpirationPolicy {
	if x != nil {
		return x.ExpirationPolicy
	}
	return nil
}

func (x *PubSubSubscription) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *PubSubSubscription) GetDeadLetterPolicy() *DeadLetterPolicy {
	if x != nil {
		return x.DeadLetterPolicy
	}
	return nil
}

func (x *PubSubSubscription) GetRetryPolicy() *RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *PubSubSubscription) GetDetached() bool {
	if x != nil {
		return x.Detached
	}
	return false
}

func (x *PubSubSubscription) GetEnableExactlyOnceDelivery() bool {
	if x != nil {
		return x.EnableExactlyOnceDelivery
	}
	return false
}

func (x *PubSubSubscription) GetMessageTransforms() []*MessageTransform {
	if x != nil {
		return x.MessageTransforms
	}
	return nil
}

// A policy that specifies how Pub/Sub retries message delivery.
//
// Retry delay will be exponential based on provided minimum and maximum
// backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
//
// RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
// events for a given message.
//
// Retry Policy is implemented on a best effort basis. At times, the delay
// between consecutive deliveries may not match the configuration. That is,
// delay can be more or less than configured backoff.
type RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum delay between consecutive deliveries of a given
	// message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
	MinimumBackoff *durationpb.Duration `protobuf:"bytes,1,opt,name=minimum_backoff,json=minimumBackoff,proto3" json:"minimum_backoff,omitempty"`
	// Optional. The maximum delay between consecutive deliveries of a given
	// message. Value should be between 0 and 600 seconds. Defaults to 600
	// seconds.
	MaximumBackoff *durationpb.Duration `protobuf:"bytes,2,opt,name=maximum_backoff,json=maximumBackoff,proto3" json:"maximum_backoff,omitempty"`
}

func (x *RetryPolicy) Reset() {
	*x = RetryPolicy{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicy) ProtoMessage() {}

func (x *RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicy.ProtoReflect.Descriptor instead.
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{1}
}

func (x *RetryPolicy) GetMinimumBackoff() *durationpb.Duration {
	if x != nil {
		return x.MinimumBackoff
	}
	return nil
}

func (x *RetryPolicy) GetMaximumBackoff() *durationpb.Duration {
	if x != nil {
		return x.MaximumBackoff
	}
	return nil
}

// Dead lettering is done on a best effort basis. The same message might be
// dead lettered multiple times.
//
// If validation on any of the fields fails at subscription creation/updation,
// the create/update subscription request will fail.
type DeadLetterPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the topic to which dead letter messages should be
	// published. Format is `projects/{project}/topics/{topic}`.The Pub/Sub
	// service account associated with the enclosing subscription's parent project
	// (i.e., service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must
	// have permission to Publish() to this topic.
	//
	// The operation will fail if the topic does not exist.
	// Users should ensure that there is a subscription attached to this topic
	// since messages published to a topic with no subscriptions are lost.
	DeadLetterTopic string `protobuf:"bytes,1,opt,name=dead_letter_topic,json=deadLetterTopic,proto3" json:"dead_letter_topic,omitempty"`
	// Optional. The maximum number of delivery attempts for any message. The
	// value must be between 5 and 100.
	//
	// The number of delivery attempts is defined as 1 + (the sum of number of
	// NACKs and number of times the acknowledgement deadline has been exceeded
	// for the message).
	//
	// A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
	// client libraries may automatically extend ack_deadlines.
	//
	// This field will be honored on a best effort basis.
	//
	// If this parameter is 0, a default value of 5 is used.
	MaxDeliveryAttempts int32 `protobuf:"varint,2,opt,name=max_delivery_attempts,json=maxDeliveryAttempts,proto3" json:"max_delivery_attempts,omitempty"`
}

func (x *DeadLetterPolicy) Reset() {
	*x = DeadLetterPolicy{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeadLetterPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeadLetterPolicy) ProtoMessage() {}

func (x *DeadLetterPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeadLetterPolicy.ProtoReflect.Descriptor instead.
func (*DeadLetterPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{2}
}

func (x *DeadLetterPolicy) GetDeadLetterTopic() string {
	if x != nil {
		return x.DeadLetterTopic
	}
	return ""
}

func (x *DeadLetterPolicy) GetMaxDeliveryAttempts() int32 {
	if x != nil {
		return x.MaxDeliveryAttempts
	}
	return 0
}

// A policy that specifies the conditions for resource expiration (i.e.,
// automatic resource deletion).
type ExpirationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the "time-to-live" duration for an associated resource.
	// The resource expires if it is not active for a period of `ttl`. The
	// definition of "activity" depends on the type of the associated resource.
	// The minimum and maximum allowed values for `ttl` depend on the type of the
	// associated resource, as well. If `ttl` is not set, the associated resource
	// never expires.
	Ttl *durationpb.Duration `protobuf:"bytes,1,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *ExpirationPolicy) Reset() {
	*x = ExpirationPolicy{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExpirationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpirationPolicy) ProtoMessage() {}

func (x *ExpirationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpirationPolicy.ProtoReflect.Descriptor instead.
func (*ExpirationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{3}
}

func (x *ExpirationPolicy) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An authentication method used by push endpoints to verify the source of
	// push requests. This can be used with push endpoints that are private by
	// default to allow requests only from the Pub/Sub system, for example.
	// This field is optional and should be set only by users interested in
	// authenticated push.
	//
	// Types that are assignable to AuthenticationMethod:
	//
	//	*PushConfig_OidcToken_
	AuthenticationMethod isPushConfig_AuthenticationMethod `protobuf_oneof:"authentication_method"`
	// The format of the delivered message to the push endpoint is defined by
	// the chosen wrapper. When unset, `PubsubWrapper` is used.
	//
	// Types that are assignable to Wrapper:
	//
	//	*PushConfig_PubsubWrapper_
	//	*PushConfig_NoWrapper_
	Wrapper isPushConfig_Wrapper `protobuf_oneof:"wrapper"`
	// Optional. A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use `https://example.com/push`.
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint,proto3" json:"push_endpoint,omitempty"`
	// Optional. Endpoint configuration attributes that can be used to control
	// different aspects of the message delivery.
	//
	// The only currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the pushed message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the pushed message (i.e., its fields and metadata).
	//
	// If not present during the `CreateSubscription` call, it will default to
	// the version of the Pub/Sub API used to make such call. If not present in a
	// `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The only supported values for the `x-goog-version` attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
	//
	// For example:
	// `attributes { "x-goog-version": "v1" }`
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PushConfig) Reset() {
	*x = PushConfig{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig) ProtoMessage() {}

func (x *PushConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig.ProtoReflect.Descriptor instead.
func (*PushConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{4}
}

func (m *PushConfig) GetAuthenticationMethod() isPushConfig_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

func (x *PushConfig) GetOidcToken() *PushConfig_OidcToken {
	if x, ok := x.GetAuthenticationMethod().(*PushConfig_OidcToken_); ok {
		return x.OidcToken
	}
	return nil
}

func (m *PushConfig) GetWrapper() isPushConfig_Wrapper {
	if m != nil {
		return m.Wrapper
	}
	return nil
}

func (x *PushConfig) GetPubsubWrapper() *PushConfig_PubsubWrapper {
	if x, ok := x.GetWrapper().(*PushConfig_PubsubWrapper_); ok {
		return x.PubsubWrapper
	}
	return nil
}

func (x *PushConfig) GetNoWrapper() *PushConfig_NoWrapper {
	if x, ok := x.GetWrapper().(*PushConfig_NoWrapper_); ok {
		return x.NoWrapper
	}
	return nil
}

func (x *PushConfig) GetPushEndpoint() string {
	if x != nil {
		return x.PushEndpoint
	}
	return ""
}

func (x *PushConfig) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

type isPushConfig_AuthenticationMethod interface {
	isPushConfig_AuthenticationMethod()
}

type PushConfig_OidcToken_ struct {
	// Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
	// token as an `Authorization` header in the HTTP request for every pushed
	// message.
	OidcToken *PushConfig_OidcToken `protobuf:"bytes,3,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*PushConfig_OidcToken_) isPushConfig_AuthenticationMethod() {}

type isPushConfig_Wrapper interface {
	isPushConfig_Wrapper()
}

type PushConfig_PubsubWrapper_ struct {
	// Optional. When set, the payload to the push endpoint is in the form of
	// the JSON representation of a PubsubMessage
	// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
	PubsubWrapper *PushConfig_PubsubWrapper `protobuf:"bytes,4,opt,name=pubsub_wrapper,json=pubsubWrapper,proto3,oneof"`
}

type PushConfig_NoWrapper_ struct {
	// Optional. When set, the payload to the push endpoint is not wrapped.
	NoWrapper *PushConfig_NoWrapper `protobuf:"bytes,5,opt,name=no_wrapper,json=noWrapper,proto3,oneof"`
}

func (*PushConfig_PubsubWrapper_) isPushConfig_Wrapper() {}

func (*PushConfig_NoWrapper_) isPushConfig_Wrapper() {}

// Configuration for a BigQuery subscription.
type BigQueryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the table to which to write data, of the form
	// {projectId}.{datasetId}.{tableId}
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Optional. When true, use the topic's schema as the columns to write to in
	// BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
	// enabled at the same time.
	UseTopicSchema bool `protobuf:"varint,2,opt,name=use_topic_schema,json=useTopicSchema,proto3" json:"use_topic_schema,omitempty"`
	// Optional. When true, write the subscription name, message_id, publish_time,
	// attributes, and ordering_key to additional columns in the table. The
	// subscription name, message_id, and publish_time fields are put in their own
	// columns while all other message properties (other than data) are written to
	// a JSON object in the attributes column.
	WriteMetadata bool `protobuf:"varint,3,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
	// Optional. When true and use_topic_schema is true, any fields that are a
	// part of the topic schema that are not part of the BigQuery table schema are
	// dropped when writing to BigQuery. Otherwise, the schemas must be kept in
	// sync and any messages with extra fields are not written and remain in the
	// subscription's backlog.
	DropUnknownFields bool `protobuf:"varint,4,opt,name=drop_unknown_fields,json=dropUnknownFields,proto3" json:"drop_unknown_fields,omitempty"`
	// Optional. When true, use the BigQuery table's schema as the columns to
	// write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
	// enabled at the same time.
	UseTableSchema bool `protobuf:"varint,6,opt,name=use_table_schema,json=useTableSchema,proto3" json:"use_table_schema,omitempty"`
	// Optional. The service account to use to write to BigQuery. The subscription
	// creator or updater that specifies this field must have
	// `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub [service
	// agent](https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `protobuf:"bytes,7,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
}

func (x *BigQueryConfig) Reset() {
	*x = BigQueryConfig{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQueryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryConfig) ProtoMessage() {}

func (x *BigQueryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryConfig.ProtoReflect.Descriptor instead.
func (*BigQueryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{5}
}

func (x *BigQueryConfig) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryConfig) GetUseTopicSchema() bool {
	if x != nil {
		return x.UseTopicSchema
	}
	return false
}

func (x *BigQueryConfig) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

func (x *BigQueryConfig) GetDropUnknownFields() bool {
	if x != nil {
		return x.DropUnknownFields
	}
	return false
}

func (x *BigQueryConfig) GetUseTableSchema() bool {
	if x != nil {
		return x.UseTableSchema
	}
	return false
}

func (x *BigQueryConfig) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

// Configuration for a Cloud Storage subscription.
type CloudStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defaults to text format.
	//
	// Types that are assignable to OutputFormat:
	//
	//	*CloudStorageConfig_TextConfig_
	//	*CloudStorageConfig_AvroConfig_
	OutputFormat isCloudStorageConfig_OutputFormat `protobuf_oneof:"output_format"`
	// Required. User-provided name for the Cloud Storage bucket.
	// The bucket must be created by the user. The bucket name must be without
	// any prefix like "gs://". See the [bucket naming
	// requirements] (https://cloud.google.com/storage/docs/buckets#naming).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Optional. User-provided prefix for Cloud Storage filename. See the [object
	// naming requirements](https://cloud.google.com/storage/docs/objects#naming).
	FilenamePrefix string `protobuf:"bytes,2,opt,name=filename_prefix,json=filenamePrefix,proto3" json:"filename_prefix,omitempty"`
	// Optional. User-provided suffix for Cloud Storage filename. See the [object
	// naming requirements](https://cloud.google.com/storage/docs/objects#naming).
	// Must not end in "/".
	FilenameSuffix string `protobuf:"bytes,3,opt,name=filename_suffix,json=filenameSuffix,proto3" json:"filename_suffix,omitempty"`
	// Optional. User-provided format string specifying how to represent datetimes
	// in Cloud Storage filenames. See the [datetime format
	// guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
	FilenameDatetimeFormat string `protobuf:"bytes,10,opt,name=filename_datetime_format,json=filenameDatetimeFormat,proto3" json:"filename_datetime_format,omitempty"`
	// Optional. File batching settings.
	// If no max_duration setting is specified, a max_duration of 5 minutes will
	// be set by default. max_duration is required regardless of whether other
	// file batching settings are specified.
	//
	// The maximum duration that can elapse before a new Cloud Storage file is
	// created. Min 1 minute, max 10 minutes, default 5 minutes. May not exceed
	// the subscription's acknowledgement deadline.
	MaxDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=max_duration,json=maxDuration,proto3" json:"max_duration,omitempty"`
	// Optional. The maximum bytes that can be written to a Cloud Storage file
	// before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
	// be exceeded in cases where messages are larger than the limit.
	MaxBytes int64 `protobuf:"varint,7,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Optional. The maximum number of messages that can be written to a Cloud
	// Storage file before a new file is created. Min 1000 messages.
	MaxMessages int64 `protobuf:"varint,8,opt,name=max_messages,json=maxMessages,proto3" json:"max_messages,omitempty"`
	// Optional. The service account to use to write to Cloud Storage. The
	// subscription creator or updater that specifies this field must have
	// `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub
	// [service agent](https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `protobuf:"bytes,11,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
}

func (x *CloudStorageConfig) Reset() {
	*x = CloudStorageConfig{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig) ProtoMessage() {}

func (x *CloudStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{6}
}

func (m *CloudStorageConfig) GetOutputFormat() isCloudStorageConfig_OutputFormat {
	if m != nil {
		return m.OutputFormat
	}
	return nil
}

func (x *CloudStorageConfig) GetTextConfig() *CloudStorageConfig_TextConfig {
	if x, ok := x.GetOutputFormat().(*CloudStorageConfig_TextConfig_); ok {
		return x.TextConfig
	}
	return nil
}

func (x *CloudStorageConfig) GetAvroConfig() *CloudStorageConfig_AvroConfig {
	if x, ok := x.GetOutputFormat().(*CloudStorageConfig_AvroConfig_); ok {
		return x.AvroConfig
	}
	return nil
}

func (x *CloudStorageConfig) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenamePrefix() string {
	if x != nil {
		return x.FilenamePrefix
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenameSuffix() string {
	if x != nil {
		return x.FilenameSuffix
	}
	return ""
}

func (x *CloudStorageConfig) GetFilenameDatetimeFormat() string {
	if x != nil {
		return x.FilenameDatetimeFormat
	}
	return ""
}

func (x *CloudStorageConfig) GetMaxDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxDuration
	}
	return nil
}

func (x *CloudStorageConfig) GetMaxBytes() int64 {
	if x != nil {
		return x.MaxBytes
	}
	return 0
}

func (x *CloudStorageConfig) GetMaxMessages() int64 {
	if x != nil {
		return x.MaxMessages
	}
	return 0
}

func (x *CloudStorageConfig) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

type isCloudStorageConfig_OutputFormat interface {
	isCloudStorageConfig_OutputFormat()
}

type CloudStorageConfig_TextConfig_ struct {
	// Optional. If set, message data will be written to Cloud Storage in text
	// format.
	TextConfig *CloudStorageConfig_TextConfig `protobuf:"bytes,4,opt,name=text_config,json=textConfig,proto3,oneof"`
}

type CloudStorageConfig_AvroConfig_ struct {
	// Optional. If set, message data will be written to Cloud Storage in Avro
	// format.
	AvroConfig *CloudStorageConfig_AvroConfig `protobuf:"bytes,5,opt,name=avro_config,json=avroConfig,proto3,oneof"`
}

func (*CloudStorageConfig_TextConfig_) isCloudStorageConfig_OutputFormat() {}

func (*CloudStorageConfig_AvroConfig_) isCloudStorageConfig_OutputFormat() {}

// All supported message transforms types.
type MessageTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of transform to apply to messages.
	//
	// Types that are assignable to Transform:
	//
	//	*MessageTransform_JavascriptUdf
	Transform isMessageTransform_Transform `protobuf_oneof:"transform"`
	// Optional. This field is deprecated, use the `disabled` field to disable
	// transforms.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/analyticshub/v1/pubsub.proto.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. If true, the transform is disabled and will not be applied to
	// messages. Defaults to `false`.
	Disabled bool `protobuf:"varint,4,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *MessageTransform) Reset() {
	*x = MessageTransform{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageTransform) ProtoMessage() {}

func (x *MessageTransform) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageTransform.ProtoReflect.Descriptor instead.
func (*MessageTransform) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{7}
}

func (m *MessageTransform) GetTransform() isMessageTransform_Transform {
	if m != nil {
		return m.Transform
	}
	return nil
}

func (x *MessageTransform) GetJavascriptUdf() *JavaScriptUDF {
	if x, ok := x.GetTransform().(*MessageTransform_JavascriptUdf); ok {
		return x.JavascriptUdf
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/analyticshub/v1/pubsub.proto.
func (x *MessageTransform) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *MessageTransform) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

type isMessageTransform_Transform interface {
	isMessageTransform_Transform()
}

type MessageTransform_JavascriptUdf struct {
	// Optional. JavaScript User Defined Function. If multiple JavaScriptUDF's
	// are specified on a resource, each must have a unique `function_name`.
	JavascriptUdf *JavaScriptUDF `protobuf:"bytes,2,opt,name=javascript_udf,json=javascriptUdf,proto3,oneof"`
}

func (*MessageTransform_JavascriptUdf) isMessageTransform_Transform() {}

// User-defined JavaScript function that can transform or filter a Pub/Sub
// message.
type JavaScriptUDF struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the JavasScript function that should applied to Pub/Sub
	// messages.
	FunctionName string `protobuf:"bytes,1,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// Required. JavaScript code that contains a function `function_name` with the
	// below signature:
	//
	// ```
	//
	//	/**
	//	* Transforms a Pub/Sub message.
	//
	//	* @return {(Object<string, (string | Object<string, string>)>|null)} - To
	//	* filter a message, return `null`. To transform a message return a map
	//	* with the following keys:
	//	*   - (required) 'data' : {string}
	//	*   - (optional) 'attributes' : {Object<string, string>}
	//	* Returning empty `attributes` will remove all attributes from the
	//	* message.
	//	*
	//	* @param  {(Object<string, (string | Object<string, string>)>} Pub/Sub
	//	* message. Keys:
	//	*   - (required) 'data' : {string}
	//	*   - (required) 'attributes' : {Object<string, string>}
	//	*
	//	* @param  {Object<string, any>} metadata - Pub/Sub message metadata.
	//	* Keys:
	//	*   - (required) 'message_id'  : {string}
	//	*   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
	//	*   - (optional) 'ordering_key': {string}
	//	*/
	//
	//	function <function_name>(message, metadata) {
	//	}
	//
	// ```
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *JavaScriptUDF) Reset() {
	*x = JavaScriptUDF{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JavaScriptUDF) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavaScriptUDF) ProtoMessage() {}

func (x *JavaScriptUDF) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavaScriptUDF.ProtoReflect.Descriptor instead.
func (*JavaScriptUDF) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{8}
}

func (x *JavaScriptUDF) GetFunctionName() string {
	if x != nil {
		return x.FunctionName
	}
	return ""
}

func (x *JavaScriptUDF) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
type PushConfig_OidcToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. [Service account
	// email](https://cloud.google.com/iam/docs/service-accounts)
	// used for generating the OIDC token. For more information
	// on setting up authentication, see
	// [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Optional. Audience to be used when generating OIDC token. The audience
	// claim identifies the recipients that the JWT is intended for. The
	// audience value is a single case-sensitive string. Having multiple values
	// (array) for the audience field is not supported. More info about the OIDC
	// JWT token audience here:
	// https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
	// the Push endpoint URL will be used.
	Audience string `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *PushConfig_OidcToken) Reset() {
	*x = PushConfig_OidcToken{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_OidcToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_OidcToken) ProtoMessage() {}

func (x *PushConfig_OidcToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_OidcToken.ProtoReflect.Descriptor instead.
func (*PushConfig_OidcToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PushConfig_OidcToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *PushConfig_OidcToken) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

// The payload to the push endpoint is in the form of the JSON representation
// of a PubsubMessage
// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
type PushConfig_PubsubWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PushConfig_PubsubWrapper) Reset() {
	*x = PushConfig_PubsubWrapper{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_PubsubWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_PubsubWrapper) ProtoMessage() {}

func (x *PushConfig_PubsubWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_PubsubWrapper.ProtoReflect.Descriptor instead.
func (*PushConfig_PubsubWrapper) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{4, 1}
}

// Sets the `data` field as the HTTP body for delivery.
type PushConfig_NoWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, writes the Pub/Sub message metadata to
	// `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
	// Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
	WriteMetadata bool `protobuf:"varint,1,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
}

func (x *PushConfig_NoWrapper) Reset() {
	*x = PushConfig_NoWrapper{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushConfig_NoWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushConfig_NoWrapper) ProtoMessage() {}

func (x *PushConfig_NoWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushConfig_NoWrapper.ProtoReflect.Descriptor instead.
func (*PushConfig_NoWrapper) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{4, 2}
}

func (x *PushConfig_NoWrapper) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

// Configuration for writing message data in text format.
// Message payloads will be written to files as raw text, separated by a
// newline.
type CloudStorageConfig_TextConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CloudStorageConfig_TextConfig) Reset() {
	*x = CloudStorageConfig_TextConfig{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig_TextConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig_TextConfig) ProtoMessage() {}

func (x *CloudStorageConfig_TextConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig_TextConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig_TextConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{6, 0}
}

// Configuration for writing message data in Avro format.
// Message payloads and metadata will be written to files as an Avro binary.
type CloudStorageConfig_AvroConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, write the subscription name, message_id,
	// publish_time, attributes, and ordering_key as additional fields in the
	// output. The subscription name, message_id, and publish_time fields are
	// put in their own fields while all other message properties other than
	// data (for example, an ordering_key, if present) are added as entries in
	// the attributes map.
	WriteMetadata bool `protobuf:"varint,1,opt,name=write_metadata,json=writeMetadata,proto3" json:"write_metadata,omitempty"`
	// Optional. When true, the output Cloud Storage file will be serialized
	// using the topic schema, if it exists.
	UseTopicSchema bool `protobuf:"varint,2,opt,name=use_topic_schema,json=useTopicSchema,proto3" json:"use_topic_schema,omitempty"`
}

func (x *CloudStorageConfig_AvroConfig) Reset() {
	*x = CloudStorageConfig_AvroConfig{}
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageConfig_AvroConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageConfig_AvroConfig) ProtoMessage() {}

func (x *CloudStorageConfig_AvroConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageConfig_AvroConfig.ProtoReflect.Descriptor instead.
func (*CloudStorageConfig_AvroConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP(), []int{6, 1}
}

func (x *CloudStorageConfig_AvroConfig) GetWriteMetadata() bool {
	if x != nil {
		return x.WriteMetadata
	}
	return false
}

func (x *CloudStorageConfig_AvroConfig) GetUseTopicSchema() bool {
	if x != nil {
		return x.UseTopicSchema
	}
	return false
}

var File_google_cloud_bigquery_analyticshub_v1_pubsub_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xab, 0x0a, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x70, 0x75, 0x73, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x63, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x14, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35, 0x0a, 0x14, 0x61, 0x63, 0x6b, 0x5f, 0x64,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x63, 0x6b, 0x44,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x37,
	0x0a, 0x15, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x41, 0x63, 0x6b, 0x65, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x69, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x6a,
	0x0a, 0x12, 0x64, 0x65, 0x61, 0x64, 0x5f, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64, 0x65, 0x61, 0x64, 0x4c, 0x65,
	0x74, 0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5a, 0x0a, 0x0c, 0x72, 0x65,
	0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x65, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64,
	0x65, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79, 0x5f, 0x6f, 0x6e, 0x63, 0x65, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x61, 0x63, 0x74, 0x6c,
	0x79, 0x4f, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x12, 0x6b, 0x0a,
	0x12, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9f, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x47, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x47,
	0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66,
	0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
	0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x22, 0x7c, 0x0a, 0x10, 0x44, 0x65, 0x61, 0x64, 0x4c,
	0x65, 0x74, 0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2f, 0x0a, 0x11, 0x64,
	0x65, 0x61, 0x64, 0x5f, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x61,
	0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x37, 0x0a, 0x15,
	0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x73, 0x22, 0x44, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x30, 0x0a, 0x03, 0x74, 0x74, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0xe7, 0x05, 0x0a, 0x0a,
	0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x0a, 0x6f, 0x69,
	0x64, 0x63, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x09, 0x6f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6d, 0x0a,
	0x0e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75,
	0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x57,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0d, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x61, 0x0a, 0x0a,
	0x6e, 0x6f, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x6e, 0x6f, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12,
	0x28, 0x0a, 0x0d, 0x70, 0x75, 0x73, 0x68, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x75, 0x73,
	0x68, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x66, 0x0a, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x1a, 0x65, 0x0a, 0x09, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37,
	0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x0f, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x1a, 0x37, 0x0a, 0x09, 0x4e, 0x6f, 0x57,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x42, 0x17, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x22, 0xa3, 0x02, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x2a, 0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x33,
	0x0a, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0xf6, 0x05, 0x0a, 0x12,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6c, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6c, 0x0a, 0x0b, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x76, 0x72, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0a, 0x61, 0x76, 0x72, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b,
	0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x66,
	0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x3d, 0x0a, 0x18, 0x66, 0x69, 0x6c, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16,
	0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x41, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6d,
	0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x1a, 0x0c, 0x0a, 0x0a,
	0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x67, 0x0a, 0x0a, 0x41, 0x76,
	0x72, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x22, 0xc5, 0x01, 0x0a, 0x10, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x62, 0x0a, 0x0e, 0x6a, 0x61, 0x76,
	0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x75, 0x64, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x55, 0x44, 0x46, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d,
	0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x55, 0x64, 0x66, 0x12, 0x1f, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05,
	0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1f,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42,
	0x0b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x22, 0x52, 0x0a, 0x0d,
	0x4a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x55, 0x44, 0x46, 0x12, 0x28, 0x0a,
	0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x42, 0x85, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x0b,
	0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75,
	0x62, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x29, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x3a, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescData = file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDesc
)

func file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescData)
	})
	return file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDescData
}

var file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_goTypes = []any{
	(*PubSubSubscription)(nil),            // 0: google.cloud.bigquery.analyticshub.v1.PubSubSubscription
	(*RetryPolicy)(nil),                   // 1: google.cloud.bigquery.analyticshub.v1.RetryPolicy
	(*DeadLetterPolicy)(nil),              // 2: google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy
	(*ExpirationPolicy)(nil),              // 3: google.cloud.bigquery.analyticshub.v1.ExpirationPolicy
	(*PushConfig)(nil),                    // 4: google.cloud.bigquery.analyticshub.v1.PushConfig
	(*BigQueryConfig)(nil),                // 5: google.cloud.bigquery.analyticshub.v1.BigQueryConfig
	(*CloudStorageConfig)(nil),            // 6: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig
	(*MessageTransform)(nil),              // 7: google.cloud.bigquery.analyticshub.v1.MessageTransform
	(*JavaScriptUDF)(nil),                 // 8: google.cloud.bigquery.analyticshub.v1.JavaScriptUDF
	nil,                                   // 9: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.LabelsEntry
	(*PushConfig_OidcToken)(nil),          // 10: google.cloud.bigquery.analyticshub.v1.PushConfig.OidcToken
	(*PushConfig_PubsubWrapper)(nil),      // 11: google.cloud.bigquery.analyticshub.v1.PushConfig.PubsubWrapper
	(*PushConfig_NoWrapper)(nil),          // 12: google.cloud.bigquery.analyticshub.v1.PushConfig.NoWrapper
	nil,                                   // 13: google.cloud.bigquery.analyticshub.v1.PushConfig.AttributesEntry
	(*CloudStorageConfig_TextConfig)(nil), // 14: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.TextConfig
	(*CloudStorageConfig_AvroConfig)(nil), // 15: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.AvroConfig
	(*durationpb.Duration)(nil),           // 16: google.protobuf.Duration
}
var file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_depIdxs = []int32{
	4,  // 0: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.push_config:type_name -> google.cloud.bigquery.analyticshub.v1.PushConfig
	5,  // 1: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.bigquery_config:type_name -> google.cloud.bigquery.analyticshub.v1.BigQueryConfig
	6,  // 2: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.cloud_storage_config:type_name -> google.cloud.bigquery.analyticshub.v1.CloudStorageConfig
	16, // 3: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.message_retention_duration:type_name -> google.protobuf.Duration
	9,  // 4: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.labels:type_name -> google.cloud.bigquery.analyticshub.v1.PubSubSubscription.LabelsEntry
	3,  // 5: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.expiration_policy:type_name -> google.cloud.bigquery.analyticshub.v1.ExpirationPolicy
	2,  // 6: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.dead_letter_policy:type_name -> google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy
	1,  // 7: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.retry_policy:type_name -> google.cloud.bigquery.analyticshub.v1.RetryPolicy
	7,  // 8: google.cloud.bigquery.analyticshub.v1.PubSubSubscription.message_transforms:type_name -> google.cloud.bigquery.analyticshub.v1.MessageTransform
	16, // 9: google.cloud.bigquery.analyticshub.v1.RetryPolicy.minimum_backoff:type_name -> google.protobuf.Duration
	16, // 10: google.cloud.bigquery.analyticshub.v1.RetryPolicy.maximum_backoff:type_name -> google.protobuf.Duration
	16, // 11: google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.ttl:type_name -> google.protobuf.Duration
	10, // 12: google.cloud.bigquery.analyticshub.v1.PushConfig.oidc_token:type_name -> google.cloud.bigquery.analyticshub.v1.PushConfig.OidcToken
	11, // 13: google.cloud.bigquery.analyticshub.v1.PushConfig.pubsub_wrapper:type_name -> google.cloud.bigquery.analyticshub.v1.PushConfig.PubsubWrapper
	12, // 14: google.cloud.bigquery.analyticshub.v1.PushConfig.no_wrapper:type_name -> google.cloud.bigquery.analyticshub.v1.PushConfig.NoWrapper
	13, // 15: google.cloud.bigquery.analyticshub.v1.PushConfig.attributes:type_name -> google.cloud.bigquery.analyticshub.v1.PushConfig.AttributesEntry
	14, // 16: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.text_config:type_name -> google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.TextConfig
	15, // 17: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.avro_config:type_name -> google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.AvroConfig
	16, // 18: google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.max_duration:type_name -> google.protobuf.Duration
	8,  // 19: google.cloud.bigquery.analyticshub.v1.MessageTransform.javascript_udf:type_name -> google.cloud.bigquery.analyticshub.v1.JavaScriptUDF
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_init() }
func file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_init() {
	if File_google_cloud_bigquery_analyticshub_v1_pubsub_proto != nil {
		return
	}
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[4].OneofWrappers = []any{
		(*PushConfig_OidcToken_)(nil),
		(*PushConfig_PubsubWrapper_)(nil),
		(*PushConfig_NoWrapper_)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[6].OneofWrappers = []any{
		(*CloudStorageConfig_TextConfig_)(nil),
		(*CloudStorageConfig_AvroConfig_)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes[7].OneofWrappers = []any{
		(*MessageTransform_JavascriptUdf)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_analyticshub_v1_pubsub_proto = out.File
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_rawDesc = nil
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_goTypes = nil
	file_google_cloud_bigquery_analyticshub_v1_pubsub_proto_depIdxs = nil
}
