package main

import (
	"fmt"
	"os"
)

const tmpl = `
// Repeated%[1]s will append the repeated value(s) to the buffer.
// This method supports packed or unpacked encoding.
func (m *Message) Repeated%[1]s(buf []%[2]s) ([]%[2]s, error) {
	if m.wireType == %[3]s {
		v, err := m.%[1]s()
		if err != nil {
			return nil, err
		}

		return append(buf, v), nil
	}

	l, err := m.packedLength()
	if err != nil {
		return nil, err
	}

	// if provided we append.
	if buf == nil {
		buf = make([]%[2]s, 0, %[4]s)
	}

	postIndex := m.index + l
	for m.index < postIndex {
		v, err := m.%[1]s()
		if err != nil {
			return nil, err
		}

		buf = append(buf, v)
	}

	return buf, nil
}
`

var types = [][]string{
	{"Float", "float32", "WireType32bit", "l/4"},
	{"Double", "float64", "WireType64bit", "l/8"},
	{"Int32", "int32", "WireTypeVarint", "m.count(l)"},
	{"Int64", "int64", "WireTypeVarint", "m.count(l)"},
	{"Uint32", "uint32", "WireTypeVarint", "m.count(l)"},
	{"Uint64", "uint64", "WireTypeVarint", "m.count(l)"},
	{"Sint32", "int32", "WireTypeVarint", "m.count(l)"},
	{"Sint64", "int64", "WireTypeVarint", "m.count(l)"},
	{"Fixed32", "uint32", "WireType32bit", "l/4"},
	{"Fixed64", "uint64", "WireType64bit", "l/8"},
	{"Sfixed32", "int32", "WireType32bit", "l/4"},
	{"Sfixed64", "int64", "WireType64bit", "l/8"},
	{"Bool", "bool", "WireTypeVarint", "l"},
}

func main() {
	f, err := os.Create("repeated.go")
	if err != nil {
		panic(err)
	}

	fmt.Fprintf(f, "// Code generated by internal/gen_repeated.go. DO NOT EDIT.\n\n")
	fmt.Fprintf(f, "package protoscan\n")

	for _, t := range types {
		fmt.Fprintf(f, tmpl, t[0], t[1], t[2], t[3])
	}
}
