package monitor

var (
	viewRefreshIntervalTmplVar   = []byte(`{{.ViewRefreshInterval}}`)
	viewAnimationIntervalTmplVar = []byte(`{{.ViewAnimationInterval}}`)
	viewTitleTmplVar             = []byte(`{{.ViewTitle}}`)
	defaultViewBody              = []byte(`<!doctypehtml><html lang=en><meta charset=UTF-8><meta content="width=device-width,initial-scale=1"name=viewport><link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;900&display=swap"rel=stylesheet><script src=https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.0/chart.min.js></script><script src=https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns/dist/chartjs-adapter-date-fns.bundle.min.js></script><title>` + string(viewTitleTmplVar) + `</title><style>body{margin:0;font:16px/1.6 Roboto,sans-serif}.wrapper{max-width:900px;margin:0 auto;padding:30px 0}.title{text-align:center;margin-bottom:2em}.title h1{font-size:2em;padding:0;margin:0}.row{display:flex;margin-bottom:20px;align-items:center}.row .column:first-child{width:35%}.row .column:last-child{width:65%}.metric{color:#777;font-weight:900}h2{padding:0;margin:0;font-size:1.8em}h2 span{font-size:12px;color:#777}h2 span.ram_os{color:rgba(255,150,0,.8)}h2 span.ram_total{color:rgba(0,200,0,.8)}canvas{width:200px;height:180px}</style><section class=wrapper><div class=title><h1>` + string(viewTitleTmplVar) + `</h1></div><section class=charts><div class=row><div class=column><div class=metric>CPU Usage</div><h2 id=cpuMetric>0.00%</h2></div><div class=column><canvas id=cpuChart></canvas></div></div><div class=row><div class=column><div class=metric>Memory Usage</div><h2 id=ramMetric title="PID used / OS used / OS total">0.00 MB</h2></div><div class=column><canvas id=ramChart></canvas></div></div><div class=row><div class=column><div class=metric>Response Time</div><h2 id=rtimeMetric>0ms</h2></div><div class=column><canvas id=rtimeChart></canvas></div></div><div class=row><div class=column><div class=metric>Open Connections</div><h2 id=connsMetric>0</h2></div><div class=column><canvas id=connsChart></canvas></div></div></section></section><script>
            Chart.defaults.plugins.legend.display=!1,Chart.defaults.font.size=8,Chart.defaults.elements.line.backgroundColor="rgba(0, 172, 215, 0.25)",Chart.defaults.elements.line.borderColor="rgba(0, 172, 215, 1)",Chart.defaults.elements.line.borderWidth=2,Chart.defaults.plugins.tooltip.enabled=!1,Chart.defaults.elements.line.tension=.2,Chart.defaults.elements.point.radius=0,Chart.defaults.animation.duration="` + string(viewAnimationIntervalTmplVar) + `",Chart.defaults.animation.easing="easeOutQuart";const options={scales:{y:{beginAtZero:!0},x:{type:"time",time:{stepSize:30,unit:"second"},grid:{display:!1}}},responsive:!0,maintainAspectRatio:!1,animation:` + string(viewAnimationIntervalTmplVar) + `>0};
			const cpuMetric=document.querySelector("#cpuMetric"),ramMetric=document.querySelector("#ramMetric"),rtimeMetric=document.querySelector("#rtimeMetric"),connsMetric=document.querySelector("#connsMetric"),cpuChartCtx=document.querySelector("#cpuChart").getContext("2d"),ramChartCtx=document.querySelector("#ramChart").getContext("2d"),rtimeChartCtx=document.querySelector("#rtimeChart").getContext("2d"),connsChartCtx=document.querySelector("#connsChart").getContext("2d"),cpuChart=createChart(cpuChartCtx),ramChart=createChart(ramChartCtx),rtimeChart=createChart(rtimeChartCtx),connsChart=createChart(connsChartCtx),charts=[cpuChart,ramChart,rtimeChart,connsChart];
			function createChart(t){return new Chart(t,{type:"line",data:{labels:[],datasets:[{label:"",data:[],fill:"start"}]},options:options})}
            ramChart.data.datasets.push({data:[],fill:"start",backgroundColor:["rgba(255, 200, 0, .6)"],borderColor:["rgba(255, 150, 0, .8)"]}),ramChart.data.datasets.push({data:[],fill:"start",backgroundColor:["rgba(0, 255, 0, .4)"],borderColor:["rgba(0, 200, 0, .8)"]});
            function formatBytes(a,b=2,k=1024){with(Math){let d=floor(log(a)/log(k));return 0==a?"0 Bytes":parseFloat((a/pow(k,d)).toFixed(max(0,b)))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][d]}}
            function refreshChart(a,t){cpu=a.pid_cpu.toFixed(1),cpuOS=a.os_cpu.toFixed(1),cpuMetric.innerHTML=cpu+"% <span>"+cpuOS+"%</span>",ramMetric.innerHTML=formatBytes(a.pid_ram)+'<span> / </span><span class="ram_os">'+formatBytes(a.os_ram)+'<span><span> / </span><span class="ram_total">'+formatBytes(a.os_total_ram)+"</span>",rtimeMetric.innerHTML=t+"ms <span>client</span>",connsMetric.innerHTML=a.pid_conns+" <span>"+a.os_conns+"</span>",cpuChart.data.datasets[0].data.push(cpu),ramChart.data.datasets[2].data.push((a.os_total_ram/1e6).toFixed(2)),ramChart.data.datasets[1].data.push((a.os_ram/1e6).toFixed(2)),ramChart.data.datasets[0].data.push((a.pid_ram/1e6).toFixed(2)),rtimeChart.data.datasets[0].data.push(t),connsChart.data.datasets[0].data.push(a.pid_conns);const s=(new Date).getTime();charts.forEach(a=>{a.data.labels.length>50&&(a.data.datasets.forEach(function(a){a.data.shift()}),a.data.labels.shift()),a.data.labels.push(s),a.update()}),setTimeout(fetchData," ` + string(viewRefreshIntervalTmplVar) + `")}
			function fetchData(){var e="",n=performance.now();fetch(window.location.href,{method:"POST",headers:{Accept:"application/json"},credentials:"same-origin"}).then(n=>(e=performance.now(),n.json())).then(o=>{refreshChart(o,Math.round(e-n))}).catch(console.error)}fetchData();</script></body></html>`)
)
