// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/example.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A single example of a conversation with the model.
type ContentsExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The content of the conversation with the model that resulted in
	// the expected output.
	Contents []*Content `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// Required. The expected output for the given `contents`. To represent
	// multi-step reasoning, this is a repeated field that contains the iterative
	// steps of the expected output.
	ExpectedContents []*ContentsExample_ExpectedContent `protobuf:"bytes,2,rep,name=expected_contents,json=expectedContents,proto3" json:"expected_contents,omitempty"`
}

func (x *ContentsExample) Reset() {
	*x = ContentsExample{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContentsExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentsExample) ProtoMessage() {}

func (x *ContentsExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentsExample.ProtoReflect.Descriptor instead.
func (*ContentsExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP(), []int{0}
}

func (x *ContentsExample) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *ContentsExample) GetExpectedContents() []*ContentsExample_ExpectedContent {
	if x != nil {
		return x.ExpectedContents
	}
	return nil
}

// A ContentsExample to be used with GenerateContent alongside information
// required for storage and retrieval with Example Store.
type StoredContentsExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. (Optional) the search key used for retrieval. If not provided at
	// upload-time, the search key will be generated from
	// `contents_example.contents` using the method provided by
	// `search_key_generation_method`. The generated search key will be included
	// in retrieved examples.
	SearchKey string `protobuf:"bytes,1,opt,name=search_key,json=searchKey,proto3" json:"search_key,omitempty"`
	// Required. The example to be used with GenerateContent.
	ContentsExample *ContentsExample `protobuf:"bytes,2,opt,name=contents_example,json=contentsExample,proto3" json:"contents_example,omitempty"`
	// Optional. The method used to generate the search key from
	// `contents_example.contents`. This is ignored when uploading an example if
	// `search_key` is provided.
	SearchKeyGenerationMethod *StoredContentsExample_SearchKeyGenerationMethod `protobuf:"bytes,3,opt,name=search_key_generation_method,json=searchKeyGenerationMethod,proto3" json:"search_key_generation_method,omitempty"`
}

func (x *StoredContentsExample) Reset() {
	*x = StoredContentsExample{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoredContentsExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredContentsExample) ProtoMessage() {}

func (x *StoredContentsExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredContentsExample.ProtoReflect.Descriptor instead.
func (*StoredContentsExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP(), []int{1}
}

func (x *StoredContentsExample) GetSearchKey() string {
	if x != nil {
		return x.SearchKey
	}
	return ""
}

func (x *StoredContentsExample) GetContentsExample() *ContentsExample {
	if x != nil {
		return x.ContentsExample
	}
	return nil
}

func (x *StoredContentsExample) GetSearchKeyGenerationMethod() *StoredContentsExample_SearchKeyGenerationMethod {
	if x != nil {
		return x.SearchKeyGenerationMethod
	}
	return nil
}

// A single step of the expected output.
type ContentsExample_ExpectedContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A single step's content.
	Content *Content `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *ContentsExample_ExpectedContent) Reset() {
	*x = ContentsExample_ExpectedContent{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContentsExample_ExpectedContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentsExample_ExpectedContent) ProtoMessage() {}

func (x *ContentsExample_ExpectedContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentsExample_ExpectedContent.ProtoReflect.Descriptor instead.
func (*ContentsExample_ExpectedContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ContentsExample_ExpectedContent) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

// Options for generating the search key from the conversation history.
type StoredContentsExample_SearchKeyGenerationMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The method for generating the search key.
	//
	// Types that are assignable to Method:
	//
	//	*StoredContentsExample_SearchKeyGenerationMethod_LastEntry_
	Method isStoredContentsExample_SearchKeyGenerationMethod_Method `protobuf_oneof:"method"`
}

func (x *StoredContentsExample_SearchKeyGenerationMethod) Reset() {
	*x = StoredContentsExample_SearchKeyGenerationMethod{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoredContentsExample_SearchKeyGenerationMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredContentsExample_SearchKeyGenerationMethod) ProtoMessage() {}

func (x *StoredContentsExample_SearchKeyGenerationMethod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredContentsExample_SearchKeyGenerationMethod.ProtoReflect.Descriptor instead.
func (*StoredContentsExample_SearchKeyGenerationMethod) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP(), []int{1, 0}
}

func (m *StoredContentsExample_SearchKeyGenerationMethod) GetMethod() isStoredContentsExample_SearchKeyGenerationMethod_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (x *StoredContentsExample_SearchKeyGenerationMethod) GetLastEntry() *StoredContentsExample_SearchKeyGenerationMethod_LastEntry {
	if x, ok := x.GetMethod().(*StoredContentsExample_SearchKeyGenerationMethod_LastEntry_); ok {
		return x.LastEntry
	}
	return nil
}

type isStoredContentsExample_SearchKeyGenerationMethod_Method interface {
	isStoredContentsExample_SearchKeyGenerationMethod_Method()
}

type StoredContentsExample_SearchKeyGenerationMethod_LastEntry_ struct {
	// Use only the last entry of the conversation history
	// (`contents_example.contents`) as the search key.
	LastEntry *StoredContentsExample_SearchKeyGenerationMethod_LastEntry `protobuf:"bytes,1,opt,name=last_entry,json=lastEntry,proto3,oneof"`
}

func (*StoredContentsExample_SearchKeyGenerationMethod_LastEntry_) isStoredContentsExample_SearchKeyGenerationMethod_Method() {
}

// Configuration for using only the last entry of the conversation history
// as the search key.
type StoredContentsExample_SearchKeyGenerationMethod_LastEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StoredContentsExample_SearchKeyGenerationMethod_LastEntry) Reset() {
	*x = StoredContentsExample_SearchKeyGenerationMethod_LastEntry{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoredContentsExample_SearchKeyGenerationMethod_LastEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredContentsExample_SearchKeyGenerationMethod_LastEntry) ProtoMessage() {}

func (x *StoredContentsExample_SearchKeyGenerationMethod_LastEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredContentsExample_SearchKeyGenerationMethod_LastEntry.ProtoReflect.Descriptor instead.
func (*StoredContentsExample_SearchKeyGenerationMethod_LastEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP(), []int{1, 0, 0}
}

var File_google_cloud_aiplatform_v1beta1_example_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_example_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xac, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x72, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x45, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x1a, 0x5a, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22,
	0xe8, 0x03, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x12, 0x60, 0x0a,
	0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12,
	0x96, 0x01, 0x0a, 0x1c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x1a, 0xaf, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x7b, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x4c, 0x61, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x1a, 0x0b, 0x0a, 0x09, 0x4c, 0x61, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x08, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0xe3, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x0c, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_example_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_example_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_example_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_example_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_example_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_example_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_example_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_example_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_aiplatform_v1beta1_example_proto_goTypes = []any{
	(*ContentsExample)(nil),                                           // 0: google.cloud.aiplatform.v1beta1.ContentsExample
	(*StoredContentsExample)(nil),                                     // 1: google.cloud.aiplatform.v1beta1.StoredContentsExample
	(*ContentsExample_ExpectedContent)(nil),                           // 2: google.cloud.aiplatform.v1beta1.ContentsExample.ExpectedContent
	(*StoredContentsExample_SearchKeyGenerationMethod)(nil),           // 3: google.cloud.aiplatform.v1beta1.StoredContentsExample.SearchKeyGenerationMethod
	(*StoredContentsExample_SearchKeyGenerationMethod_LastEntry)(nil), // 4: google.cloud.aiplatform.v1beta1.StoredContentsExample.SearchKeyGenerationMethod.LastEntry
	(*Content)(nil), // 5: google.cloud.aiplatform.v1beta1.Content
}
var file_google_cloud_aiplatform_v1beta1_example_proto_depIdxs = []int32{
	5, // 0: google.cloud.aiplatform.v1beta1.ContentsExample.contents:type_name -> google.cloud.aiplatform.v1beta1.Content
	2, // 1: google.cloud.aiplatform.v1beta1.ContentsExample.expected_contents:type_name -> google.cloud.aiplatform.v1beta1.ContentsExample.ExpectedContent
	0, // 2: google.cloud.aiplatform.v1beta1.StoredContentsExample.contents_example:type_name -> google.cloud.aiplatform.v1beta1.ContentsExample
	3, // 3: google.cloud.aiplatform.v1beta1.StoredContentsExample.search_key_generation_method:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExample.SearchKeyGenerationMethod
	5, // 4: google.cloud.aiplatform.v1beta1.ContentsExample.ExpectedContent.content:type_name -> google.cloud.aiplatform.v1beta1.Content
	4, // 5: google.cloud.aiplatform.v1beta1.StoredContentsExample.SearchKeyGenerationMethod.last_entry:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExample.SearchKeyGenerationMethod.LastEntry
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_example_proto_init() }
func file_google_cloud_aiplatform_v1beta1_example_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_example_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_init()
	file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes[3].OneofWrappers = []any{
		(*StoredContentsExample_SearchKeyGenerationMethod_LastEntry_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_example_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_example_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_example_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_example_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_example_proto = out.File
	file_google_cloud_aiplatform_v1beta1_example_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_example_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_example_proto_depIdxs = nil
}
