// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/data/v1alpha/data.proto

package data

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Scoping specifies which events are considered when evaluating if a user
// meets a criteria.
type UserCriteriaScoping int32

const (
	// Unspecified criteria scoping. Do not specify.
	UserCriteriaScoping_USER_CRITERIA_SCOPING_UNSPECIFIED UserCriteriaScoping = 0
	// If the criteria is satisfied within one event, the user matches the
	// criteria.
	UserCriteriaScoping_USER_CRITERIA_WITHIN_SAME_EVENT UserCriteriaScoping = 1
	// If the criteria is satisfied within one session, the user matches the
	// criteria.
	UserCriteriaScoping_USER_CRITERIA_WITHIN_SAME_SESSION UserCriteriaScoping = 2
	// If the criteria is satisfied by any events for the user, the user
	// matches the criteria.
	UserCriteriaScoping_USER_CRITERIA_ACROSS_ALL_SESSIONS UserCriteriaScoping = 3
)

// Enum value maps for UserCriteriaScoping.
var (
	UserCriteriaScoping_name = map[int32]string{
		0: "USER_CRITERIA_SCOPING_UNSPECIFIED",
		1: "USER_CRITERIA_WITHIN_SAME_EVENT",
		2: "USER_CRITERIA_WITHIN_SAME_SESSION",
		3: "USER_CRITERIA_ACROSS_ALL_SESSIONS",
	}
	UserCriteriaScoping_value = map[string]int32{
		"USER_CRITERIA_SCOPING_UNSPECIFIED": 0,
		"USER_CRITERIA_WITHIN_SAME_EVENT":   1,
		"USER_CRITERIA_WITHIN_SAME_SESSION": 2,
		"USER_CRITERIA_ACROSS_ALL_SESSIONS": 3,
	}
)

func (x UserCriteriaScoping) Enum() *UserCriteriaScoping {
	p := new(UserCriteriaScoping)
	*p = x
	return p
}

func (x UserCriteriaScoping) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserCriteriaScoping) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[0].Descriptor()
}

func (UserCriteriaScoping) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[0]
}

func (x UserCriteriaScoping) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserCriteriaScoping.Descriptor instead.
func (UserCriteriaScoping) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{0}
}

// Enumerates options for how long an exclusion will last if a user matches
// the `userExclusionCriteria`.
type UserExclusionDuration int32

const (
	// Unspecified exclusion duration. Do not specify.
	UserExclusionDuration_USER_EXCLUSION_DURATION_UNSPECIFIED UserExclusionDuration = 0
	// Temporarily exclude users from the segment during periods when the
	// user meets the `userExclusionCriteria` condition.
	UserExclusionDuration_USER_EXCLUSION_TEMPORARY UserExclusionDuration = 1
	// Permanently exclude users from the segment if the user ever meets the
	// `userExclusionCriteria` condition.
	UserExclusionDuration_USER_EXCLUSION_PERMANENT UserExclusionDuration = 2
)

// Enum value maps for UserExclusionDuration.
var (
	UserExclusionDuration_name = map[int32]string{
		0: "USER_EXCLUSION_DURATION_UNSPECIFIED",
		1: "USER_EXCLUSION_TEMPORARY",
		2: "USER_EXCLUSION_PERMANENT",
	}
	UserExclusionDuration_value = map[string]int32{
		"USER_EXCLUSION_DURATION_UNSPECIFIED": 0,
		"USER_EXCLUSION_TEMPORARY":            1,
		"USER_EXCLUSION_PERMANENT":            2,
	}
)

func (x UserExclusionDuration) Enum() *UserExclusionDuration {
	p := new(UserExclusionDuration)
	*p = x
	return p
}

func (x UserExclusionDuration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserExclusionDuration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[1].Descriptor()
}

func (UserExclusionDuration) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[1]
}

func (x UserExclusionDuration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserExclusionDuration.Descriptor instead.
func (UserExclusionDuration) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{1}
}

// Scoping specifies which events are considered when evaluating if a
// session meets a criteria.
type SessionCriteriaScoping int32

const (
	// Unspecified criteria scoping. Do not specify.
	SessionCriteriaScoping_SESSION_CRITERIA_SCOPING_UNSPECIFIED SessionCriteriaScoping = 0
	// If the criteria is satisfied within one event, the session matches the
	// criteria.
	SessionCriteriaScoping_SESSION_CRITERIA_WITHIN_SAME_EVENT SessionCriteriaScoping = 1
	// If the criteria is satisfied within one session, the session matches
	// the criteria.
	SessionCriteriaScoping_SESSION_CRITERIA_WITHIN_SAME_SESSION SessionCriteriaScoping = 2
)

// Enum value maps for SessionCriteriaScoping.
var (
	SessionCriteriaScoping_name = map[int32]string{
		0: "SESSION_CRITERIA_SCOPING_UNSPECIFIED",
		1: "SESSION_CRITERIA_WITHIN_SAME_EVENT",
		2: "SESSION_CRITERIA_WITHIN_SAME_SESSION",
	}
	SessionCriteriaScoping_value = map[string]int32{
		"SESSION_CRITERIA_SCOPING_UNSPECIFIED": 0,
		"SESSION_CRITERIA_WITHIN_SAME_EVENT":   1,
		"SESSION_CRITERIA_WITHIN_SAME_SESSION": 2,
	}
)

func (x SessionCriteriaScoping) Enum() *SessionCriteriaScoping {
	p := new(SessionCriteriaScoping)
	*p = x
	return p
}

func (x SessionCriteriaScoping) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionCriteriaScoping) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[2].Descriptor()
}

func (SessionCriteriaScoping) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[2]
}

func (x SessionCriteriaScoping) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionCriteriaScoping.Descriptor instead.
func (SessionCriteriaScoping) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{2}
}

// Enumerates options for how long an exclusion will last if a session
// matches the `sessionExclusionCriteria`.
type SessionExclusionDuration int32

const (
	// Unspecified exclusion duration. Do not specify.
	SessionExclusionDuration_SESSION_EXCLUSION_DURATION_UNSPECIFIED SessionExclusionDuration = 0
	// Temporarily exclude sessions from the segment during periods when the
	// session meets the `sessionExclusionCriteria` condition.
	SessionExclusionDuration_SESSION_EXCLUSION_TEMPORARY SessionExclusionDuration = 1
	// Permanently exclude sessions from the segment if the session ever meets
	// the `sessionExclusionCriteria` condition.
	SessionExclusionDuration_SESSION_EXCLUSION_PERMANENT SessionExclusionDuration = 2
)

// Enum value maps for SessionExclusionDuration.
var (
	SessionExclusionDuration_name = map[int32]string{
		0: "SESSION_EXCLUSION_DURATION_UNSPECIFIED",
		1: "SESSION_EXCLUSION_TEMPORARY",
		2: "SESSION_EXCLUSION_PERMANENT",
	}
	SessionExclusionDuration_value = map[string]int32{
		"SESSION_EXCLUSION_DURATION_UNSPECIFIED": 0,
		"SESSION_EXCLUSION_TEMPORARY":            1,
		"SESSION_EXCLUSION_PERMANENT":            2,
	}
)

func (x SessionExclusionDuration) Enum() *SessionExclusionDuration {
	p := new(SessionExclusionDuration)
	*p = x
	return p
}

func (x SessionExclusionDuration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionExclusionDuration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[3].Descriptor()
}

func (SessionExclusionDuration) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[3]
}

func (x SessionExclusionDuration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionExclusionDuration.Descriptor instead.
func (SessionExclusionDuration) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{3}
}

// Scoping specifies which events are considered when evaluating if an event
// meets a criteria.
type EventCriteriaScoping int32

const (
	// Unspecified criteria scoping. Do not specify.
	EventCriteriaScoping_EVENT_CRITERIA_SCOPING_UNSPECIFIED EventCriteriaScoping = 0
	// If the criteria is satisfied within one event, the event matches the
	// criteria.
	EventCriteriaScoping_EVENT_CRITERIA_WITHIN_SAME_EVENT EventCriteriaScoping = 1
)

// Enum value maps for EventCriteriaScoping.
var (
	EventCriteriaScoping_name = map[int32]string{
		0: "EVENT_CRITERIA_SCOPING_UNSPECIFIED",
		1: "EVENT_CRITERIA_WITHIN_SAME_EVENT",
	}
	EventCriteriaScoping_value = map[string]int32{
		"EVENT_CRITERIA_SCOPING_UNSPECIFIED": 0,
		"EVENT_CRITERIA_WITHIN_SAME_EVENT":   1,
	}
)

func (x EventCriteriaScoping) Enum() *EventCriteriaScoping {
	p := new(EventCriteriaScoping)
	*p = x
	return p
}

func (x EventCriteriaScoping) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventCriteriaScoping) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[4].Descriptor()
}

func (EventCriteriaScoping) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[4]
}

func (x EventCriteriaScoping) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventCriteriaScoping.Descriptor instead.
func (EventCriteriaScoping) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{4}
}

// Enumerates options for how long an exclusion will last if an event
// matches the `eventExclusionCriteria`.
type EventExclusionDuration int32

const (
	// Unspecified exclusion duration. Do not specify.
	EventExclusionDuration_EVENT_EXCLUSION_DURATION_UNSPECIFIED EventExclusionDuration = 0
	// Permanently exclude events from the segment if the event ever meets
	// the `eventExclusionCriteria` condition.
	EventExclusionDuration_EVENT_EXCLUSION_PERMANENT EventExclusionDuration = 1
)

// Enum value maps for EventExclusionDuration.
var (
	EventExclusionDuration_name = map[int32]string{
		0: "EVENT_EXCLUSION_DURATION_UNSPECIFIED",
		1: "EVENT_EXCLUSION_PERMANENT",
	}
	EventExclusionDuration_value = map[string]int32{
		"EVENT_EXCLUSION_DURATION_UNSPECIFIED": 0,
		"EVENT_EXCLUSION_PERMANENT":            1,
	}
)

func (x EventExclusionDuration) Enum() *EventExclusionDuration {
	p := new(EventExclusionDuration)
	*p = x
	return p
}

func (x EventExclusionDuration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventExclusionDuration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[5].Descriptor()
}

func (EventExclusionDuration) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[5]
}

func (x EventExclusionDuration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventExclusionDuration.Descriptor instead.
func (EventExclusionDuration) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{5}
}

// A metric's value type.
type MetricType int32

const (
	// Unspecified type.
	MetricType_METRIC_TYPE_UNSPECIFIED MetricType = 0
	// Integer type.
	MetricType_TYPE_INTEGER MetricType = 1
	// Floating point type.
	MetricType_TYPE_FLOAT MetricType = 2
	// A duration of seconds; a special floating point type.
	MetricType_TYPE_SECONDS MetricType = 4
	// A duration in milliseconds; a special floating point type.
	MetricType_TYPE_MILLISECONDS MetricType = 5
	// A duration in minutes; a special floating point type.
	MetricType_TYPE_MINUTES MetricType = 6
	// A duration in hours; a special floating point type.
	MetricType_TYPE_HOURS MetricType = 7
	// A custom metric of standard type; a special floating point type.
	MetricType_TYPE_STANDARD MetricType = 8
	// An amount of money; a special floating point type.
	MetricType_TYPE_CURRENCY MetricType = 9
	// A length in feet; a special floating point type.
	MetricType_TYPE_FEET MetricType = 10
	// A length in miles; a special floating point type.
	MetricType_TYPE_MILES MetricType = 11
	// A length in meters; a special floating point type.
	MetricType_TYPE_METERS MetricType = 12
	// A length in kilometers; a special floating point type.
	MetricType_TYPE_KILOMETERS MetricType = 13
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0:  "METRIC_TYPE_UNSPECIFIED",
		1:  "TYPE_INTEGER",
		2:  "TYPE_FLOAT",
		4:  "TYPE_SECONDS",
		5:  "TYPE_MILLISECONDS",
		6:  "TYPE_MINUTES",
		7:  "TYPE_HOURS",
		8:  "TYPE_STANDARD",
		9:  "TYPE_CURRENCY",
		10: "TYPE_FEET",
		11: "TYPE_MILES",
		12: "TYPE_METERS",
		13: "TYPE_KILOMETERS",
	}
	MetricType_value = map[string]int32{
		"METRIC_TYPE_UNSPECIFIED": 0,
		"TYPE_INTEGER":            1,
		"TYPE_FLOAT":              2,
		"TYPE_SECONDS":            4,
		"TYPE_MILLISECONDS":       5,
		"TYPE_MINUTES":            6,
		"TYPE_HOURS":              7,
		"TYPE_STANDARD":           8,
		"TYPE_CURRENCY":           9,
		"TYPE_FEET":               10,
		"TYPE_MILES":              11,
		"TYPE_METERS":             12,
		"TYPE_KILOMETERS":         13,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[6].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[6]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{6}
}

// The match type of a string filter
type StringFilter_MatchType int32

const (
	// Unspecified
	StringFilter_MATCH_TYPE_UNSPECIFIED StringFilter_MatchType = 0
	// Exact match of the string value.
	StringFilter_EXACT StringFilter_MatchType = 1
	// Begins with the string value.
	StringFilter_BEGINS_WITH StringFilter_MatchType = 2
	// Ends with the string value.
	StringFilter_ENDS_WITH StringFilter_MatchType = 3
	// Contains the string value.
	StringFilter_CONTAINS StringFilter_MatchType = 4
	// Full match for the regular expression with the string value.
	StringFilter_FULL_REGEXP StringFilter_MatchType = 5
	// Partial match for the regular expression with the string value.
	StringFilter_PARTIAL_REGEXP StringFilter_MatchType = 6
)

// Enum value maps for StringFilter_MatchType.
var (
	StringFilter_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "BEGINS_WITH",
		3: "ENDS_WITH",
		4: "CONTAINS",
		5: "FULL_REGEXP",
		6: "PARTIAL_REGEXP",
	}
	StringFilter_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"EXACT":                  1,
		"BEGINS_WITH":            2,
		"ENDS_WITH":              3,
		"CONTAINS":               4,
		"FULL_REGEXP":            5,
		"PARTIAL_REGEXP":         6,
	}
)

func (x StringFilter_MatchType) Enum() *StringFilter_MatchType {
	p := new(StringFilter_MatchType)
	*p = x
	return p
}

func (x StringFilter_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StringFilter_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[7].Descriptor()
}

func (StringFilter_MatchType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[7]
}

func (x StringFilter_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StringFilter_MatchType.Descriptor instead.
func (StringFilter_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{6, 0}
}

// The operation applied to a numeric filter
type NumericFilter_Operation int32

const (
	// Unspecified.
	NumericFilter_OPERATION_UNSPECIFIED NumericFilter_Operation = 0
	// Equal
	NumericFilter_EQUAL NumericFilter_Operation = 1
	// Less than
	NumericFilter_LESS_THAN NumericFilter_Operation = 2
	// Less than or equal
	NumericFilter_LESS_THAN_OR_EQUAL NumericFilter_Operation = 3
	// Greater than
	NumericFilter_GREATER_THAN NumericFilter_Operation = 4
	// Greater than or equal
	NumericFilter_GREATER_THAN_OR_EQUAL NumericFilter_Operation = 5
)

// Enum value maps for NumericFilter_Operation.
var (
	NumericFilter_Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "EQUAL",
		2: "LESS_THAN",
		3: "LESS_THAN_OR_EQUAL",
		4: "GREATER_THAN",
		5: "GREATER_THAN_OR_EQUAL",
	}
	NumericFilter_Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"EQUAL":                 1,
		"LESS_THAN":             2,
		"LESS_THAN_OR_EQUAL":    3,
		"GREATER_THAN":          4,
		"GREATER_THAN_OR_EQUAL": 5,
	}
)

func (x NumericFilter_Operation) Enum() *NumericFilter_Operation {
	p := new(NumericFilter_Operation)
	*p = x
	return p
}

func (x NumericFilter_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NumericFilter_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_data_proto_enumTypes[8].Descriptor()
}

func (NumericFilter_Operation) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_data_proto_enumTypes[8]
}

func (x NumericFilter_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NumericFilter_Operation.Descriptor instead.
func (NumericFilter_Operation) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{8, 0}
}

// A contiguous set of days: startDate, startDate + 1, ..., endDate. Requests
// are allowed up to 4 date ranges.
type DateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot
	// be after `end_date`. The format `NdaysAgo`, `yesterday`, or `today` is also
	// accepted, and in that case, the date is inferred based on the property's
	// reporting time zone.
	StartDate string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot
	// be before `start_date`. The format `NdaysAgo`, `yesterday`, or `today` is
	// also accepted, and in that case, the date is inferred based on the
	// property's reporting time zone.
	EndDate string `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Assigns a name to this date range. The dimension `dateRange` is valued to
	// this name in a report response. If set, cannot begin with `date_range_` or
	// `RESERVED_`. If not set, date ranges are named by their zero based index in
	// the request: `date_range_0`, `date_range_1`, etc.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DateRange) Reset() {
	*x = DateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateRange) ProtoMessage() {}

func (x *DateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateRange.ProtoReflect.Descriptor instead.
func (*DateRange) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{0}
}

func (x *DateRange) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *DateRange) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

func (x *DateRange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Dimensions are attributes of your data. For example, the dimension city
// indicates the city from which an event originates. Dimension values in report
// responses are strings; for example, the city could be "Paris" or "New York".
type Dimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the dimension. See the [API
	// Dimensions](https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#dimensions)
	// for the list of dimension names.
	//
	// If `dimensionExpression` is specified, `name` can be any string that you
	// would like within the allowed character set. For example if a
	// `dimensionExpression` concatenates `country` and `city`, you could call
	// that dimension `countryAndCity`. Dimension names that you choose must match
	// the regular expression `^[a-zA-Z0-9_]$`.
	//
	// Dimensions are referenced by `name` in `dimensionFilter`, `orderBys`,
	// `dimensionExpression`, and `pivots`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One dimension can be the result of an expression of multiple dimensions.
	// For example, dimension "country, city": concatenate(country, ", ", city).
	DimensionExpression *DimensionExpression `protobuf:"bytes,2,opt,name=dimension_expression,json=dimensionExpression,proto3" json:"dimension_expression,omitempty"`
}

func (x *Dimension) Reset() {
	*x = Dimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension) ProtoMessage() {}

func (x *Dimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension.ProtoReflect.Descriptor instead.
func (*Dimension) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{1}
}

func (x *Dimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dimension) GetDimensionExpression() *DimensionExpression {
	if x != nil {
		return x.DimensionExpression
	}
	return nil
}

// Used to express a dimension which is the result of a formula of multiple
// dimensions. Example usages:
// 1) lower_case(dimension)
// 2) concatenate(dimension1, symbol, dimension2).
type DimensionExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of dimension expression for `DimensionExpression`.
	//
	// Types that are assignable to OneExpression:
	//	*DimensionExpression_LowerCase
	//	*DimensionExpression_UpperCase
	//	*DimensionExpression_Concatenate
	OneExpression isDimensionExpression_OneExpression `protobuf_oneof:"one_expression"`
}

func (x *DimensionExpression) Reset() {
	*x = DimensionExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression) ProtoMessage() {}

func (x *DimensionExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{2}
}

func (m *DimensionExpression) GetOneExpression() isDimensionExpression_OneExpression {
	if m != nil {
		return m.OneExpression
	}
	return nil
}

func (x *DimensionExpression) GetLowerCase() *DimensionExpression_CaseExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_LowerCase); ok {
		return x.LowerCase
	}
	return nil
}

func (x *DimensionExpression) GetUpperCase() *DimensionExpression_CaseExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_UpperCase); ok {
		return x.UpperCase
	}
	return nil
}

func (x *DimensionExpression) GetConcatenate() *DimensionExpression_ConcatenateExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_Concatenate); ok {
		return x.Concatenate
	}
	return nil
}

type isDimensionExpression_OneExpression interface {
	isDimensionExpression_OneExpression()
}

type DimensionExpression_LowerCase struct {
	// Used to convert a dimension value to lower case.
	LowerCase *DimensionExpression_CaseExpression `protobuf:"bytes,4,opt,name=lower_case,json=lowerCase,proto3,oneof"`
}

type DimensionExpression_UpperCase struct {
	// Used to convert a dimension value to upper case.
	UpperCase *DimensionExpression_CaseExpression `protobuf:"bytes,5,opt,name=upper_case,json=upperCase,proto3,oneof"`
}

type DimensionExpression_Concatenate struct {
	// Used to combine dimension values to a single dimension.
	// For example, dimension "country, city": concatenate(country, ", ", city).
	Concatenate *DimensionExpression_ConcatenateExpression `protobuf:"bytes,6,opt,name=concatenate,proto3,oneof"`
}

func (*DimensionExpression_LowerCase) isDimensionExpression_OneExpression() {}

func (*DimensionExpression_UpperCase) isDimensionExpression_OneExpression() {}

func (*DimensionExpression_Concatenate) isDimensionExpression_OneExpression() {}

// To express dimension or metric filters. The fields in the same
// FilterExpression need to be either all dimensions or all metrics.
type FilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter expression for `FilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*FilterExpression_AndGroup
	//	*FilterExpression_OrGroup
	//	*FilterExpression_NotExpression
	//	*FilterExpression_Filter
	Expr isFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *FilterExpression) Reset() {
	*x = FilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpression) ProtoMessage() {}

func (x *FilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpression.ProtoReflect.Descriptor instead.
func (*FilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{3}
}

func (m *FilterExpression) GetExpr() isFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *FilterExpression) GetAndGroup() *FilterExpressionList {
	if x, ok := x.GetExpr().(*FilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *FilterExpression) GetOrGroup() *FilterExpressionList {
	if x, ok := x.GetExpr().(*FilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *FilterExpression) GetNotExpression() *FilterExpression {
	if x, ok := x.GetExpr().(*FilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *FilterExpression) GetFilter() *Filter {
	if x, ok := x.GetExpr().(*FilterExpression_Filter); ok {
		return x.Filter
	}
	return nil
}

type isFilterExpression_Expr interface {
	isFilterExpression_Expr()
}

type FilterExpression_AndGroup struct {
	// The FilterExpressions in and_group have an AND relationship.
	AndGroup *FilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type FilterExpression_OrGroup struct {
	// The FilterExpressions in or_group have an OR relationship.
	OrGroup *FilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type FilterExpression_NotExpression struct {
	// The FilterExpression is NOT of not_expression.
	NotExpression *FilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type FilterExpression_Filter struct {
	// A primitive filter. In the same FilterExpression, all of the filter's
	// field names need to be either all dimensions or all metrics.
	Filter *Filter `protobuf:"bytes,4,opt,name=filter,proto3,oneof"`
}

func (*FilterExpression_AndGroup) isFilterExpression_Expr() {}

func (*FilterExpression_OrGroup) isFilterExpression_Expr() {}

func (*FilterExpression_NotExpression) isFilterExpression_Expr() {}

func (*FilterExpression_Filter) isFilterExpression_Expr() {}

// A list of filter expressions.
type FilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of filter expressions.
	Expressions []*FilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *FilterExpressionList) Reset() {
	*x = FilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpressionList) ProtoMessage() {}

func (x *FilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpressionList.ProtoReflect.Descriptor instead.
func (*FilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{4}
}

func (x *FilterExpressionList) GetExpressions() []*FilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter dimension or metric values.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension name or metric name. Must be a name defined in dimensions
	// or metrics.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Specify one type of filter for `Filter`.
	//
	// Types that are assignable to OneFilter:
	//	*Filter_StringFilter
	//	*Filter_InListFilter
	//	*Filter_NumericFilter
	//	*Filter_BetweenFilter
	OneFilter isFilter_OneFilter `protobuf_oneof:"one_filter"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{5}
}

func (x *Filter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (m *Filter) GetOneFilter() isFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *Filter) GetStringFilter() *StringFilter {
	if x, ok := x.GetOneFilter().(*Filter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *Filter) GetInListFilter() *InListFilter {
	if x, ok := x.GetOneFilter().(*Filter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *Filter) GetNumericFilter() *NumericFilter {
	if x, ok := x.GetOneFilter().(*Filter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *Filter) GetBetweenFilter() *BetweenFilter {
	if x, ok := x.GetOneFilter().(*Filter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

type isFilter_OneFilter interface {
	isFilter_OneFilter()
}

type Filter_StringFilter struct {
	// Strings related filter.
	StringFilter *StringFilter `protobuf:"bytes,2,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type Filter_InListFilter struct {
	// A filter for in list values.
	InListFilter *InListFilter `protobuf:"bytes,3,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type Filter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *NumericFilter `protobuf:"bytes,4,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type Filter_BetweenFilter struct {
	// A filter for between two values.
	BetweenFilter *BetweenFilter `protobuf:"bytes,5,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*Filter_StringFilter) isFilter_OneFilter() {}

func (*Filter_InListFilter) isFilter_OneFilter() {}

func (*Filter_NumericFilter) isFilter_OneFilter() {}

func (*Filter_BetweenFilter) isFilter_OneFilter() {}

// The filter for string
type StringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The match type for this filter.
	MatchType StringFilter_MatchType `protobuf:"varint,1,opt,name=match_type,json=matchType,proto3,enum=google.analytics.data.v1alpha.StringFilter_MatchType" json:"match_type,omitempty"`
	// The string value used for the matching.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *StringFilter) Reset() {
	*x = StringFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringFilter) ProtoMessage() {}

func (x *StringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringFilter.ProtoReflect.Descriptor instead.
func (*StringFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{6}
}

func (x *StringFilter) GetMatchType() StringFilter_MatchType {
	if x != nil {
		return x.MatchType
	}
	return StringFilter_MATCH_TYPE_UNSPECIFIED
}

func (x *StringFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *StringFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// The result needs to be in a list of string values.
type InListFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of string values.
	// Must be non-empty.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,2,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *InListFilter) Reset() {
	*x = InListFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InListFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InListFilter) ProtoMessage() {}

func (x *InListFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InListFilter.ProtoReflect.Descriptor instead.
func (*InListFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{7}
}

func (x *InListFilter) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *InListFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// Filters for numeric or date values.
type NumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation type for this filter.
	Operation NumericFilter_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=google.analytics.data.v1alpha.NumericFilter_Operation" json:"operation,omitempty"`
	// A numeric value or a date value.
	Value *NumericValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *NumericFilter) Reset() {
	*x = NumericFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NumericFilter) ProtoMessage() {}

func (x *NumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NumericFilter.ProtoReflect.Descriptor instead.
func (*NumericFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{8}
}

func (x *NumericFilter) GetOperation() NumericFilter_Operation {
	if x != nil {
		return x.Operation
	}
	return NumericFilter_OPERATION_UNSPECIFIED
}

func (x *NumericFilter) GetValue() *NumericValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// To express that the result needs to be between two numbers (inclusive).
type BetweenFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Begins with this number.
	FromValue *NumericValue `protobuf:"bytes,1,opt,name=from_value,json=fromValue,proto3" json:"from_value,omitempty"`
	// Ends with this number.
	ToValue *NumericValue `protobuf:"bytes,2,opt,name=to_value,json=toValue,proto3" json:"to_value,omitempty"`
}

func (x *BetweenFilter) Reset() {
	*x = BetweenFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BetweenFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BetweenFilter) ProtoMessage() {}

func (x *BetweenFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BetweenFilter.ProtoReflect.Descriptor instead.
func (*BetweenFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{9}
}

func (x *BetweenFilter) GetFromValue() *NumericValue {
	if x != nil {
		return x.FromValue
	}
	return nil
}

func (x *BetweenFilter) GetToValue() *NumericValue {
	if x != nil {
		return x.ToValue
	}
	return nil
}

// To represent a number.
type NumericValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of a numeric value
	//
	// Types that are assignable to OneValue:
	//	*NumericValue_Int64Value
	//	*NumericValue_DoubleValue
	OneValue isNumericValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *NumericValue) Reset() {
	*x = NumericValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NumericValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NumericValue) ProtoMessage() {}

func (x *NumericValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NumericValue.ProtoReflect.Descriptor instead.
func (*NumericValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{10}
}

func (m *NumericValue) GetOneValue() isNumericValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *NumericValue) GetInt64Value() int64 {
	if x, ok := x.GetOneValue().(*NumericValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *NumericValue) GetDoubleValue() float64 {
	if x, ok := x.GetOneValue().(*NumericValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isNumericValue_OneValue interface {
	isNumericValue_OneValue()
}

type NumericValue_Int64Value struct {
	// Integer value
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type NumericValue_DoubleValue struct {
	// Double value
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*NumericValue_Int64Value) isNumericValue_OneValue() {}

func (*NumericValue_DoubleValue) isNumericValue_OneValue() {}

// Describes a dimension column in the report. Dimensions requested in a report
// produce column entries within rows and DimensionHeaders. However, dimensions
// used exclusively within filters or expressions do not produce columns in a
// report; correspondingly, those dimensions do not produce headers.
type DimensionHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DimensionHeader) Reset() {
	*x = DimensionHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionHeader) ProtoMessage() {}

func (x *DimensionHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionHeader.ProtoReflect.Descriptor instead.
func (*DimensionHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{11}
}

func (x *DimensionHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Describes a metric column in the report. Visible metrics requested in a
// report produce column entries within rows and MetricHeaders. However,
// metrics used exclusively within filters or expressions do not produce columns
// in a report; correspondingly, those metrics do not produce headers.
type MetricHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metric's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The metric's data type.
	Type MetricType `protobuf:"varint,2,opt,name=type,proto3,enum=google.analytics.data.v1alpha.MetricType" json:"type,omitempty"`
}

func (x *MetricHeader) Reset() {
	*x = MetricHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricHeader) ProtoMessage() {}

func (x *MetricHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricHeader.ProtoReflect.Descriptor instead.
func (*MetricHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{12}
}

func (x *MetricHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricHeader) GetType() MetricType {
	if x != nil {
		return x.Type
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

// Report data for each row.
// For example if RunReportRequest contains:
//
// ```none
// "dimensions": [
//   {
//     "name": "eventName"
//   },
//   {
//     "name": "countryId"
//   }
// ],
// "metrics": [
//   {
//     "name": "eventCount"
//   }
// ]
// ```
//
// One row with 'in_app_purchase' as the eventName, 'JP' as the countryId, and
// 15 as the eventCount, would be:
//
// ```none
// "dimensionValues": [
//   {
//     "value": "in_app_purchase"
//   },
//   {
//     "value": "JP"
//   }
// ],
// "metricValues": [
//   {
//     "value": "15"
//   }
// ]
// ```
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of requested dimension values. In a PivotReport, dimension_values
	// are only listed for dimensions included in a pivot.
	DimensionValues []*DimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty"`
	// List of requested visible metric values.
	MetricValues []*MetricValue `protobuf:"bytes,2,rep,name=metric_values,json=metricValues,proto3" json:"metric_values,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{13}
}

func (x *Row) GetDimensionValues() []*DimensionValue {
	if x != nil {
		return x.DimensionValues
	}
	return nil
}

func (x *Row) GetMetricValues() []*MetricValue {
	if x != nil {
		return x.MetricValues
	}
	return nil
}

// The value of a dimension.
type DimensionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One kind of dimension value
	//
	// Types that are assignable to OneValue:
	//	*DimensionValue_Value
	OneValue isDimensionValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *DimensionValue) Reset() {
	*x = DimensionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionValue) ProtoMessage() {}

func (x *DimensionValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionValue.ProtoReflect.Descriptor instead.
func (*DimensionValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{14}
}

func (m *DimensionValue) GetOneValue() isDimensionValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *DimensionValue) GetValue() string {
	if x, ok := x.GetOneValue().(*DimensionValue_Value); ok {
		return x.Value
	}
	return ""
}

type isDimensionValue_OneValue interface {
	isDimensionValue_OneValue()
}

type DimensionValue_Value struct {
	// Value as a string if the dimension type is a string.
	Value string `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

func (*DimensionValue_Value) isDimensionValue_OneValue() {}

// The value of a metric.
type MetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of metric value
	//
	// Types that are assignable to OneValue:
	//	*MetricValue_Value
	OneValue isMetricValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *MetricValue) Reset() {
	*x = MetricValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricValue) ProtoMessage() {}

func (x *MetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricValue.ProtoReflect.Descriptor instead.
func (*MetricValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{15}
}

func (m *MetricValue) GetOneValue() isMetricValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *MetricValue) GetValue() string {
	if x, ok := x.GetOneValue().(*MetricValue_Value); ok {
		return x.Value
	}
	return ""
}

type isMetricValue_OneValue interface {
	isMetricValue_OneValue()
}

type MetricValue_Value struct {
	// Measurement value. See MetricHeader for type.
	Value string `protobuf:"bytes,4,opt,name=value,proto3,oneof"`
}

func (*MetricValue_Value) isMetricValue_OneValue() {}

// Current state of all quotas for this Analytics Property. If any quota for a
// property is exhausted, all requests to that property will return Resource
// Exhausted errors.
type PropertyQuota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Standard Analytics Properties can use up to 25,000 tokens per day;
	// Analytics 360 Properties can use 250,000 tokens per day. Most requests
	// consume fewer than 10 tokens.
	TokensPerDay *QuotaStatus `protobuf:"bytes,1,opt,name=tokens_per_day,json=tokensPerDay,proto3" json:"tokens_per_day,omitempty"`
	// Standard Analytics Properties can use up to 5,000 tokens per hour;
	// Analytics 360 Properties can use 50,000 tokens per hour. An API request
	// consumes a single number of tokens, and that number is deducted from both
	// the hourly and daily quotas.
	TokensPerHour *QuotaStatus `protobuf:"bytes,2,opt,name=tokens_per_hour,json=tokensPerHour,proto3" json:"tokens_per_hour,omitempty"`
	// Standard Analytics Properties can send up to 10 concurrent requests;
	// Analytics 360 Properties can use up to 50 concurrent requests.
	ConcurrentRequests *QuotaStatus `protobuf:"bytes,3,opt,name=concurrent_requests,json=concurrentRequests,proto3" json:"concurrent_requests,omitempty"`
	// Standard Analytics Properties and cloud project pairs can have up to 10
	// server errors per hour; Analytics 360 Properties and cloud project pairs
	// can have up to 50 server errors per hour.
	ServerErrorsPerProjectPerHour *QuotaStatus `protobuf:"bytes,4,opt,name=server_errors_per_project_per_hour,json=serverErrorsPerProjectPerHour,proto3" json:"server_errors_per_project_per_hour,omitempty"`
	// Analytics Properties can send up to 120 requests with potentially
	// thresholded dimensions per hour. In a batch request, each report request
	// is individually counted for this quota if the request contains potentially
	// thresholded dimensions.
	PotentiallyThresholdedRequestsPerHour *QuotaStatus `protobuf:"bytes,5,opt,name=potentially_thresholded_requests_per_hour,json=potentiallyThresholdedRequestsPerHour,proto3" json:"potentially_thresholded_requests_per_hour,omitempty"`
}

func (x *PropertyQuota) Reset() {
	*x = PropertyQuota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyQuota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyQuota) ProtoMessage() {}

func (x *PropertyQuota) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyQuota.ProtoReflect.Descriptor instead.
func (*PropertyQuota) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{16}
}

func (x *PropertyQuota) GetTokensPerDay() *QuotaStatus {
	if x != nil {
		return x.TokensPerDay
	}
	return nil
}

func (x *PropertyQuota) GetTokensPerHour() *QuotaStatus {
	if x != nil {
		return x.TokensPerHour
	}
	return nil
}

func (x *PropertyQuota) GetConcurrentRequests() *QuotaStatus {
	if x != nil {
		return x.ConcurrentRequests
	}
	return nil
}

func (x *PropertyQuota) GetServerErrorsPerProjectPerHour() *QuotaStatus {
	if x != nil {
		return x.ServerErrorsPerProjectPerHour
	}
	return nil
}

func (x *PropertyQuota) GetPotentiallyThresholdedRequestsPerHour() *QuotaStatus {
	if x != nil {
		return x.PotentiallyThresholdedRequestsPerHour
	}
	return nil
}

// Current state for a particular quota group.
type QuotaStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quota consumed by this request.
	Consumed int32 `protobuf:"varint,1,opt,name=consumed,proto3" json:"consumed,omitempty"`
	// Quota remaining after this request.
	Remaining int32 `protobuf:"varint,2,opt,name=remaining,proto3" json:"remaining,omitempty"`
}

func (x *QuotaStatus) Reset() {
	*x = QuotaStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaStatus) ProtoMessage() {}

func (x *QuotaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaStatus.ProtoReflect.Descriptor instead.
func (*QuotaStatus) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{17}
}

func (x *QuotaStatus) GetConsumed() int32 {
	if x != nil {
		return x.Consumed
	}
	return 0
}

func (x *QuotaStatus) GetRemaining() int32 {
	if x != nil {
		return x.Remaining
	}
	return 0
}

// Breakdowns add a dimension to the funnel table sub report response.
type FunnelBreakdown struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension column added to the funnel table sub report response. The
	// breakdown dimension breaks down each funnel step. A valid
	// `breakdownDimension` is required if `funnelBreakdown` is specified.
	BreakdownDimension *Dimension `protobuf:"bytes,1,opt,name=breakdown_dimension,json=breakdownDimension,proto3" json:"breakdown_dimension,omitempty"`
	// The maximum number of distinct values of the breakdown dimension to return
	// in the response. A `limit` of `5` is used if limit is not specified. Limit
	// must exceed zero and cannot exceed 15.
	Limit *int64 `protobuf:"varint,2,opt,name=limit,proto3,oneof" json:"limit,omitempty"`
}

func (x *FunnelBreakdown) Reset() {
	*x = FunnelBreakdown{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelBreakdown) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelBreakdown) ProtoMessage() {}

func (x *FunnelBreakdown) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelBreakdown.ProtoReflect.Descriptor instead.
func (*FunnelBreakdown) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{18}
}

func (x *FunnelBreakdown) GetBreakdownDimension() *Dimension {
	if x != nil {
		return x.BreakdownDimension
	}
	return nil
}

func (x *FunnelBreakdown) GetLimit() int64 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

// Next actions state the value for a dimension after the user has achieved
// a step but before the same user has achieved the next step. For example if
// the `nextActionDimension` is `eventName`, then `nextActionDimension` in the
// `i`th funnel step row will return first event after the event that qualified
// the user into the `i`th funnel step but before the user achieved the `i+1`th
// funnel step.
type FunnelNextAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension column added to the funnel visualization sub report response.
	// The next action dimension returns the next dimension value of this
	// dimension after the user has attained the `i`th funnel step.
	//
	// `nextActionDimension` currently only supports `eventName` and most Page /
	// Screen dimensions like `pageTitle` and `pagePath`. `nextActionDimension`
	// cannot be a dimension expression.
	NextActionDimension *Dimension `protobuf:"bytes,1,opt,name=next_action_dimension,json=nextActionDimension,proto3" json:"next_action_dimension,omitempty"`
	// The maximum number of distinct values of the breakdown dimension to return
	// in the response. A `limit` of `5` is used if limit is not specified. Limit
	// must exceed zero and cannot exceed 5.
	Limit *int64 `protobuf:"varint,2,opt,name=limit,proto3,oneof" json:"limit,omitempty"`
}

func (x *FunnelNextAction) Reset() {
	*x = FunnelNextAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelNextAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelNextAction) ProtoMessage() {}

func (x *FunnelNextAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelNextAction.ProtoReflect.Descriptor instead.
func (*FunnelNextAction) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{19}
}

func (x *FunnelNextAction) GetNextActionDimension() *Dimension {
	if x != nil {
		return x.NextActionDimension
	}
	return nil
}

func (x *FunnelNextAction) GetLimit() int64 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

// Configures the funnel in a funnel report request. A funnel reports on users
// as they pass through a sequence of steps.
//
// Funnel exploration lets you visualize the steps your users take to complete a
// task and quickly see how well they are succeeding or failing at each step.
// For example, how do prospects become shoppers and then become buyers? How do
// one time buyers become repeat buyers? With this information, you can improve
// inefficient or abandoned customer journeys.
type Funnel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// In an open funnel, users can enter the funnel in any step, and in a closed
	// funnel, users must enter the funnel in the first step. Optional. If
	// unspecified, a closed funnel is used.
	IsOpenFunnel bool `protobuf:"varint,1,opt,name=is_open_funnel,json=isOpenFunnel,proto3" json:"is_open_funnel,omitempty"`
	// The sequential steps of this funnel.
	Steps []*FunnelStep `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Funnel) Reset() {
	*x = Funnel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Funnel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Funnel) ProtoMessage() {}

func (x *Funnel) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Funnel.ProtoReflect.Descriptor instead.
func (*Funnel) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{20}
}

func (x *Funnel) GetIsOpenFunnel() bool {
	if x != nil {
		return x.IsOpenFunnel
	}
	return false
}

func (x *Funnel) GetSteps() []*FunnelStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Steps define the user journey you want to measure. Steps contain one or
// more conditions that your users must meet to be included in that step of
// the funnel journey.
type FunnelStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The distinctive name for this step. If unspecified, steps will be named
	// by a 1 based indexed name (i.e. "0. ", "1. ", etc.). This name defines
	// string value returned by the `funnelStepName` dimension. For example,
	// specifying `name = Purchase` in the request's third funnel step will
	// produce `3. Purchase` in the funnel report response.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If true, this step must directly follow the previous step. If false,
	// there can be events between the previous step and this step. If
	// unspecified, `isDirectlyFollowedBy` is treated as false.
	IsDirectlyFollowedBy bool `protobuf:"varint,2,opt,name=is_directly_followed_by,json=isDirectlyFollowedBy,proto3" json:"is_directly_followed_by,omitempty"`
	// If specified, this step must complete within this duration of the
	// completion of the prior step. `withinDurationFromPriorStep` is inclusive
	// of the endpoint at the microsecond granularity. For example a duration of
	// 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
	// microsecond.
	//
	// `withinDurationFromPriorStep` is optional, and if unspecified, steps may
	// be separated by any time duration.
	WithinDurationFromPriorStep *durationpb.Duration `protobuf:"bytes,3,opt,name=within_duration_from_prior_step,json=withinDurationFromPriorStep,proto3,oneof" json:"within_duration_from_prior_step,omitempty"`
	// The condition that your users must meet to be included in this step of
	// the funnel journey.
	FilterExpression *FunnelFilterExpression `protobuf:"bytes,4,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
}

func (x *FunnelStep) Reset() {
	*x = FunnelStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelStep) ProtoMessage() {}

func (x *FunnelStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelStep.ProtoReflect.Descriptor instead.
func (*FunnelStep) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{21}
}

func (x *FunnelStep) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunnelStep) GetIsDirectlyFollowedBy() bool {
	if x != nil {
		return x.IsDirectlyFollowedBy
	}
	return false
}

func (x *FunnelStep) GetWithinDurationFromPriorStep() *durationpb.Duration {
	if x != nil {
		return x.WithinDurationFromPriorStep
	}
	return nil
}

func (x *FunnelStep) GetFilterExpression() *FunnelFilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

// Funnel sub reports contain the dimension and metric data values. For example,
// 12 users reached the second step of the funnel.
type FunnelSubReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes dimension columns. Funnel reports always include the funnel step
	// dimension in sub report responses. Additional dimensions like breakdowns,
	// dates, and next actions may be present in the response if requested.
	DimensionHeaders []*DimensionHeader `protobuf:"bytes,1,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// Describes metric columns. Funnel reports always include active users in sub
	// report responses. The funnel table includes additional metrics like
	// completion rate, abandonments, and abandonments rate.
	MetricHeaders []*MetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// Metadata for the funnel report.
	Metadata *FunnelResponseMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *FunnelSubReport) Reset() {
	*x = FunnelSubReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelSubReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelSubReport) ProtoMessage() {}

func (x *FunnelSubReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelSubReport.ProtoReflect.Descriptor instead.
func (*FunnelSubReport) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{22}
}

func (x *FunnelSubReport) GetDimensionHeaders() []*DimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *FunnelSubReport) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *FunnelSubReport) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *FunnelSubReport) GetMetadata() *FunnelResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// User segments are subsets of users who engaged with your site or app. For
// example, users who have previously purchased; users who added items to their
// shopping carts, but didn’t complete a purchase.
type UserSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines which users are included in this segment. Optional.
	UserInclusionCriteria *UserSegmentCriteria `protobuf:"bytes,1,opt,name=user_inclusion_criteria,json=userInclusionCriteria,proto3" json:"user_inclusion_criteria,omitempty"`
	// Defines which users are excluded in this segment. Optional.
	Exclusion *UserSegmentExclusion `protobuf:"bytes,2,opt,name=exclusion,proto3" json:"exclusion,omitempty"`
}

func (x *UserSegment) Reset() {
	*x = UserSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSegment) ProtoMessage() {}

func (x *UserSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSegment.ProtoReflect.Descriptor instead.
func (*UserSegment) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{23}
}

func (x *UserSegment) GetUserInclusionCriteria() *UserSegmentCriteria {
	if x != nil {
		return x.UserInclusionCriteria
	}
	return nil
}

func (x *UserSegment) GetExclusion() *UserSegmentExclusion {
	if x != nil {
		return x.Exclusion
	}
	return nil
}

// A user matches a criteria if the user's events meet the conditions in the
// criteria.
type UserSegmentCriteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user matches this criteria if the user matches each of these
	// `andConditionGroups` and each of the `andSequenceGroups`.
	// `andConditionGroups` may be empty if `andSequenceGroups` are specified.
	AndConditionGroups []*UserSegmentConditionGroup `protobuf:"bytes,1,rep,name=and_condition_groups,json=andConditionGroups,proto3" json:"and_condition_groups,omitempty"`
	// A user matches this criteria if the user matches each of these
	// `andSequenceGroups` and each of the `andConditionGroups`.
	// `andSequenceGroups` may be empty if `andConditionGroups` are specified.
	AndSequenceGroups []*UserSegmentSequenceGroup `protobuf:"bytes,2,rep,name=and_sequence_groups,json=andSequenceGroups,proto3" json:"and_sequence_groups,omitempty"`
}

func (x *UserSegmentCriteria) Reset() {
	*x = UserSegmentCriteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSegmentCriteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSegmentCriteria) ProtoMessage() {}

func (x *UserSegmentCriteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSegmentCriteria.ProtoReflect.Descriptor instead.
func (*UserSegmentCriteria) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{24}
}

func (x *UserSegmentCriteria) GetAndConditionGroups() []*UserSegmentConditionGroup {
	if x != nil {
		return x.AndConditionGroups
	}
	return nil
}

func (x *UserSegmentCriteria) GetAndSequenceGroups() []*UserSegmentSequenceGroup {
	if x != nil {
		return x.AndSequenceGroups
	}
	return nil
}

// Conditions tell Analytics what data to include in or exclude from the
// segment.
type UserSegmentConditionGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data is included or excluded from the segment based on if it matches
	// the condition group. This scoping defines how many events the
	// `segmentFilterExpression` is evaluated on before the condition group
	// is determined to be matched or not. For example if `conditionScoping =
	// USER_CRITERIA_WITHIN_SAME_SESSION`, the expression is evaluated on all
	// events in a session, and then, the condition group is determined to be
	// matched or not for this user. For example if `conditionScoping =
	// USER_CRITERIA_WITHIN_SAME_EVENT`, the expression is evaluated on a single
	// event, and then, the condition group is determined to be matched or not for
	// this user.
	//
	// Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
	// used.
	ConditionScoping UserCriteriaScoping `protobuf:"varint,1,opt,name=condition_scoping,json=conditionScoping,proto3,enum=google.analytics.data.v1alpha.UserCriteriaScoping" json:"condition_scoping,omitempty"`
	// Data is included or excluded from the segment based on if it matches
	// this expression. Expressions express criteria on dimension, metrics,
	// and/or parameters.
	SegmentFilterExpression *SegmentFilterExpression `protobuf:"bytes,2,opt,name=segment_filter_expression,json=segmentFilterExpression,proto3" json:"segment_filter_expression,omitempty"`
}

func (x *UserSegmentConditionGroup) Reset() {
	*x = UserSegmentConditionGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSegmentConditionGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSegmentConditionGroup) ProtoMessage() {}

func (x *UserSegmentConditionGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSegmentConditionGroup.ProtoReflect.Descriptor instead.
func (*UserSegmentConditionGroup) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{25}
}

func (x *UserSegmentConditionGroup) GetConditionScoping() UserCriteriaScoping {
	if x != nil {
		return x.ConditionScoping
	}
	return UserCriteriaScoping_USER_CRITERIA_SCOPING_UNSPECIFIED
}

func (x *UserSegmentConditionGroup) GetSegmentFilterExpression() *SegmentFilterExpression {
	if x != nil {
		return x.SegmentFilterExpression
	}
	return nil
}

// Define conditions that must occur in a specific order for the user to be
// a member of the segment.
type UserSegmentSequenceGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All sequence steps must be satisfied in the scoping for the user to
	// match the sequence. For example if `sequenceScoping =
	// USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
	// one session for the user to match the sequence. `sequenceScoping =
	// USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
	//
	// Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
	// used.
	SequenceScoping UserCriteriaScoping `protobuf:"varint,1,opt,name=sequence_scoping,json=sequenceScoping,proto3,enum=google.analytics.data.v1alpha.UserCriteriaScoping" json:"sequence_scoping,omitempty"`
	// Defines the time period in which the whole sequence must occur; for
	// example, 30 Minutes. `sequenceMaximumDuration` is inclusive
	// of the endpoint at the microsecond granularity. For example a sequence
	// with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
	// seconds, but not 5 seconds and 1 microsecond.
	//
	// `sequenceMaximumDuration` is optional, and if unspecified, sequences can
	// be completed in any time duration.
	SequenceMaximumDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=sequence_maximum_duration,json=sequenceMaximumDuration,proto3" json:"sequence_maximum_duration,omitempty"`
	// An ordered sequence of condition steps. A user's events must complete
	// each step in order for the user to match the
	// `UserSegmentSequenceGroup`.
	UserSequenceSteps []*UserSequenceStep `protobuf:"bytes,3,rep,name=user_sequence_steps,json=userSequenceSteps,proto3" json:"user_sequence_steps,omitempty"`
}

func (x *UserSegmentSequenceGroup) Reset() {
	*x = UserSegmentSequenceGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSegmentSequenceGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSegmentSequenceGroup) ProtoMessage() {}

func (x *UserSegmentSequenceGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSegmentSequenceGroup.ProtoReflect.Descriptor instead.
func (*UserSegmentSequenceGroup) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{26}
}

func (x *UserSegmentSequenceGroup) GetSequenceScoping() UserCriteriaScoping {
	if x != nil {
		return x.SequenceScoping
	}
	return UserCriteriaScoping_USER_CRITERIA_SCOPING_UNSPECIFIED
}

func (x *UserSegmentSequenceGroup) GetSequenceMaximumDuration() *durationpb.Duration {
	if x != nil {
		return x.SequenceMaximumDuration
	}
	return nil
}

func (x *UserSegmentSequenceGroup) GetUserSequenceSteps() []*UserSequenceStep {
	if x != nil {
		return x.UserSequenceSteps
	}
	return nil
}

// A condition that must occur in the specified step order for this user
// to match the sequence.
type UserSequenceStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, the event satisfying this step must be the very next event
	// after the event satifying the last step. If false, this step indirectly
	// follows the prior step; for example, there may be events between the
	// prior step and this step. `isDirectlyFollowedBy` must be false for
	// the first step.
	IsDirectlyFollowedBy bool `protobuf:"varint,1,opt,name=is_directly_followed_by,json=isDirectlyFollowedBy,proto3" json:"is_directly_followed_by,omitempty"`
	// This sequence step must be satisfied in the scoping for the user to
	// match the sequence. For example if `sequenceScoping =
	// WITHIN_SAME_SESSION`, this sequence steps must complete within one
	// session for the user to match the sequence. `stepScoping =
	// ACROSS_ALL_SESSIONS` is only allowed if the `sequenceScoping =
	// ACROSS_ALL_SESSIONS`.
	//
	// Optional. If unspecified, `stepScoping` uses the same
	// `UserCriteriaScoping` as the `sequenceScoping`.
	StepScoping UserCriteriaScoping `protobuf:"varint,2,opt,name=step_scoping,json=stepScoping,proto3,enum=google.analytics.data.v1alpha.UserCriteriaScoping" json:"step_scoping,omitempty"`
	// A user matches this sequence step if their events match this
	// expression. Expressions express criteria on dimension, metrics,
	// and/or parameters.
	SegmentFilterExpression *SegmentFilterExpression `protobuf:"bytes,3,opt,name=segment_filter_expression,json=segmentFilterExpression,proto3" json:"segment_filter_expression,omitempty"`
}

func (x *UserSequenceStep) Reset() {
	*x = UserSequenceStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSequenceStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSequenceStep) ProtoMessage() {}

func (x *UserSequenceStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSequenceStep.ProtoReflect.Descriptor instead.
func (*UserSequenceStep) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{27}
}

func (x *UserSequenceStep) GetIsDirectlyFollowedBy() bool {
	if x != nil {
		return x.IsDirectlyFollowedBy
	}
	return false
}

func (x *UserSequenceStep) GetStepScoping() UserCriteriaScoping {
	if x != nil {
		return x.StepScoping
	}
	return UserCriteriaScoping_USER_CRITERIA_SCOPING_UNSPECIFIED
}

func (x *UserSequenceStep) GetSegmentFilterExpression() *SegmentFilterExpression {
	if x != nil {
		return x.SegmentFilterExpression
	}
	return nil
}

// Specifies which users are excluded in this segment.
type UserSegmentExclusion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how long an exclusion will last if a user matches the
	// `userExclusionCriteria`.
	//
	// Optional. If unspecified, `userExclusionDuration` of
	// `USER_EXCLUSION_TEMPORARY` is used.
	UserExclusionDuration UserExclusionDuration `protobuf:"varint,1,opt,name=user_exclusion_duration,json=userExclusionDuration,proto3,enum=google.analytics.data.v1alpha.UserExclusionDuration" json:"user_exclusion_duration,omitempty"`
	// If a user meets this condition, the user is excluded from membership in
	// the segment for the `userExclusionDuration`.
	UserExclusionCriteria *UserSegmentCriteria `protobuf:"bytes,2,opt,name=user_exclusion_criteria,json=userExclusionCriteria,proto3" json:"user_exclusion_criteria,omitempty"`
}

func (x *UserSegmentExclusion) Reset() {
	*x = UserSegmentExclusion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSegmentExclusion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSegmentExclusion) ProtoMessage() {}

func (x *UserSegmentExclusion) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSegmentExclusion.ProtoReflect.Descriptor instead.
func (*UserSegmentExclusion) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{28}
}

func (x *UserSegmentExclusion) GetUserExclusionDuration() UserExclusionDuration {
	if x != nil {
		return x.UserExclusionDuration
	}
	return UserExclusionDuration_USER_EXCLUSION_DURATION_UNSPECIFIED
}

func (x *UserSegmentExclusion) GetUserExclusionCriteria() *UserSegmentCriteria {
	if x != nil {
		return x.UserExclusionCriteria
	}
	return nil
}

// Session segments are subsets of the sessions that occurred on your site or
// app: for example, all the sessions that originated from a particular
// advertising campaign.
type SessionSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines which sessions are included in this segment. Optional.
	SessionInclusionCriteria *SessionSegmentCriteria `protobuf:"bytes,1,opt,name=session_inclusion_criteria,json=sessionInclusionCriteria,proto3" json:"session_inclusion_criteria,omitempty"`
	// Defines which sessions are excluded in this segment. Optional.
	Exclusion *SessionSegmentExclusion `protobuf:"bytes,2,opt,name=exclusion,proto3" json:"exclusion,omitempty"`
}

func (x *SessionSegment) Reset() {
	*x = SessionSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionSegment) ProtoMessage() {}

func (x *SessionSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionSegment.ProtoReflect.Descriptor instead.
func (*SessionSegment) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{29}
}

func (x *SessionSegment) GetSessionInclusionCriteria() *SessionSegmentCriteria {
	if x != nil {
		return x.SessionInclusionCriteria
	}
	return nil
}

func (x *SessionSegment) GetExclusion() *SessionSegmentExclusion {
	if x != nil {
		return x.Exclusion
	}
	return nil
}

// A session matches a criteria if the session's events meet the conditions in
// the criteria.
type SessionSegmentCriteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A session matches this criteria if the session matches each of these
	// `andConditionGroups`.
	AndConditionGroups []*SessionSegmentConditionGroup `protobuf:"bytes,1,rep,name=and_condition_groups,json=andConditionGroups,proto3" json:"and_condition_groups,omitempty"`
}

func (x *SessionSegmentCriteria) Reset() {
	*x = SessionSegmentCriteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionSegmentCriteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionSegmentCriteria) ProtoMessage() {}

func (x *SessionSegmentCriteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionSegmentCriteria.ProtoReflect.Descriptor instead.
func (*SessionSegmentCriteria) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{30}
}

func (x *SessionSegmentCriteria) GetAndConditionGroups() []*SessionSegmentConditionGroup {
	if x != nil {
		return x.AndConditionGroups
	}
	return nil
}

// Conditions tell Analytics what data to include in or exclude from the
// segment.
type SessionSegmentConditionGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data is included or excluded from the segment based on if it matches
	// the condition group. This scoping defines how many events the
	// `segmentFilterExpression` is evaluated on before the condition group
	// is determined to be matched or not. For example if `conditionScoping =
	// SESSION_CRITERIA_WITHIN_SAME_SESSION`, the expression is evaluated on all
	// events in a session, and then, the condition group is determined to be
	// matched or not for this session. For example if `conditionScoping =
	// SESSION_CRITERIA_WITHIN_SAME_EVENT`, the expression is evaluated on a
	// single event, and then, the condition group is determined to be matched or
	// not for this session.
	//
	// Optional. If unspecified, a `conditionScoping` of `WITHIN_SAME_SESSION`
	// is used.
	ConditionScoping SessionCriteriaScoping `protobuf:"varint,1,opt,name=condition_scoping,json=conditionScoping,proto3,enum=google.analytics.data.v1alpha.SessionCriteriaScoping" json:"condition_scoping,omitempty"`
	// Data is included or excluded from the segment based on if it matches
	// this expression. Expressions express criteria on dimension, metrics,
	// and/or parameters.
	SegmentFilterExpression *SegmentFilterExpression `protobuf:"bytes,2,opt,name=segment_filter_expression,json=segmentFilterExpression,proto3" json:"segment_filter_expression,omitempty"`
}

func (x *SessionSegmentConditionGroup) Reset() {
	*x = SessionSegmentConditionGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionSegmentConditionGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionSegmentConditionGroup) ProtoMessage() {}

func (x *SessionSegmentConditionGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionSegmentConditionGroup.ProtoReflect.Descriptor instead.
func (*SessionSegmentConditionGroup) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{31}
}

func (x *SessionSegmentConditionGroup) GetConditionScoping() SessionCriteriaScoping {
	if x != nil {
		return x.ConditionScoping
	}
	return SessionCriteriaScoping_SESSION_CRITERIA_SCOPING_UNSPECIFIED
}

func (x *SessionSegmentConditionGroup) GetSegmentFilterExpression() *SegmentFilterExpression {
	if x != nil {
		return x.SegmentFilterExpression
	}
	return nil
}

// Specifies which sessions are excluded in this segment.
type SessionSegmentExclusion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how long an exclusion will last if a session matches the
	// `sessionExclusionCriteria`.
	//
	// Optional. If unspecified, a `sessionExclusionDuration` of
	// `SESSION_EXCLUSION_TEMPORARY` is used.
	SessionExclusionDuration SessionExclusionDuration `protobuf:"varint,1,opt,name=session_exclusion_duration,json=sessionExclusionDuration,proto3,enum=google.analytics.data.v1alpha.SessionExclusionDuration" json:"session_exclusion_duration,omitempty"`
	// If a session meets this condition, the session is excluded from
	// membership in the segment for the `sessionExclusionDuration`.
	SessionExclusionCriteria *SessionSegmentCriteria `protobuf:"bytes,2,opt,name=session_exclusion_criteria,json=sessionExclusionCriteria,proto3" json:"session_exclusion_criteria,omitempty"`
}

func (x *SessionSegmentExclusion) Reset() {
	*x = SessionSegmentExclusion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionSegmentExclusion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionSegmentExclusion) ProtoMessage() {}

func (x *SessionSegmentExclusion) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionSegmentExclusion.ProtoReflect.Descriptor instead.
func (*SessionSegmentExclusion) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{32}
}

func (x *SessionSegmentExclusion) GetSessionExclusionDuration() SessionExclusionDuration {
	if x != nil {
		return x.SessionExclusionDuration
	}
	return SessionExclusionDuration_SESSION_EXCLUSION_DURATION_UNSPECIFIED
}

func (x *SessionSegmentExclusion) GetSessionExclusionCriteria() *SessionSegmentCriteria {
	if x != nil {
		return x.SessionExclusionCriteria
	}
	return nil
}

// Event segments are subsets of events that were triggered on your site or app.
// for example, all purchase events made in a particular location; app_exception
// events that occurred on a specific operating system.
type EventSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines which events are included in this segment. Optional.
	EventInclusionCriteria *EventSegmentCriteria `protobuf:"bytes,1,opt,name=event_inclusion_criteria,json=eventInclusionCriteria,proto3" json:"event_inclusion_criteria,omitempty"`
	// Defines which events are excluded in this segment. Optional.
	Exclusion *EventSegmentExclusion `protobuf:"bytes,2,opt,name=exclusion,proto3" json:"exclusion,omitempty"`
}

func (x *EventSegment) Reset() {
	*x = EventSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventSegment) ProtoMessage() {}

func (x *EventSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventSegment.ProtoReflect.Descriptor instead.
func (*EventSegment) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{33}
}

func (x *EventSegment) GetEventInclusionCriteria() *EventSegmentCriteria {
	if x != nil {
		return x.EventInclusionCriteria
	}
	return nil
}

func (x *EventSegment) GetExclusion() *EventSegmentExclusion {
	if x != nil {
		return x.Exclusion
	}
	return nil
}

// An event matches a criteria if the event meet the conditions in the
// criteria.
type EventSegmentCriteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An event matches this criteria if the event matches each of these
	// `andConditionGroups`.
	AndConditionGroups []*EventSegmentConditionGroup `protobuf:"bytes,1,rep,name=and_condition_groups,json=andConditionGroups,proto3" json:"and_condition_groups,omitempty"`
}

func (x *EventSegmentCriteria) Reset() {
	*x = EventSegmentCriteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventSegmentCriteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventSegmentCriteria) ProtoMessage() {}

func (x *EventSegmentCriteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventSegmentCriteria.ProtoReflect.Descriptor instead.
func (*EventSegmentCriteria) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{34}
}

func (x *EventSegmentCriteria) GetAndConditionGroups() []*EventSegmentConditionGroup {
	if x != nil {
		return x.AndConditionGroups
	}
	return nil
}

// Conditions tell Analytics what data to include in or exclude from the
// segment.
type EventSegmentConditionGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `conditionScoping` should always be `EVENT_CRITERIA_WITHIN_SAME_EVENT`.
	//
	// Optional. If unspecified, a `conditionScoping` of
	// `EVENT_CRITERIA_WITHIN_SAME_EVENT` is used.
	ConditionScoping EventCriteriaScoping `protobuf:"varint,1,opt,name=condition_scoping,json=conditionScoping,proto3,enum=google.analytics.data.v1alpha.EventCriteriaScoping" json:"condition_scoping,omitempty"`
	// Data is included or excluded from the segment based on if it matches
	// this expression. Expressions express criteria on dimension, metrics,
	// and/or parameters.
	SegmentFilterExpression *SegmentFilterExpression `protobuf:"bytes,2,opt,name=segment_filter_expression,json=segmentFilterExpression,proto3" json:"segment_filter_expression,omitempty"`
}

func (x *EventSegmentConditionGroup) Reset() {
	*x = EventSegmentConditionGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventSegmentConditionGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventSegmentConditionGroup) ProtoMessage() {}

func (x *EventSegmentConditionGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventSegmentConditionGroup.ProtoReflect.Descriptor instead.
func (*EventSegmentConditionGroup) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{35}
}

func (x *EventSegmentConditionGroup) GetConditionScoping() EventCriteriaScoping {
	if x != nil {
		return x.ConditionScoping
	}
	return EventCriteriaScoping_EVENT_CRITERIA_SCOPING_UNSPECIFIED
}

func (x *EventSegmentConditionGroup) GetSegmentFilterExpression() *SegmentFilterExpression {
	if x != nil {
		return x.SegmentFilterExpression
	}
	return nil
}

// Specifies which events are excluded in this segment.
type EventSegmentExclusion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `eventExclusionDuration` should always be `PERMANENTLY_EXCLUDE`.
	//
	// Optional. If unspecified, an `eventExclusionDuration` of
	// `EVENT_EXCLUSION_PERMANENT` is used.
	EventExclusionDuration EventExclusionDuration `protobuf:"varint,1,opt,name=event_exclusion_duration,json=eventExclusionDuration,proto3,enum=google.analytics.data.v1alpha.EventExclusionDuration" json:"event_exclusion_duration,omitempty"`
	// If an event meets this condition, the event is excluded from membership
	// in the segment for the `eventExclusionDuration`.
	EventExclusionCriteria *EventSegmentCriteria `protobuf:"bytes,2,opt,name=event_exclusion_criteria,json=eventExclusionCriteria,proto3" json:"event_exclusion_criteria,omitempty"`
}

func (x *EventSegmentExclusion) Reset() {
	*x = EventSegmentExclusion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventSegmentExclusion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventSegmentExclusion) ProtoMessage() {}

func (x *EventSegmentExclusion) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventSegmentExclusion.ProtoReflect.Descriptor instead.
func (*EventSegmentExclusion) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{36}
}

func (x *EventSegmentExclusion) GetEventExclusionDuration() EventExclusionDuration {
	if x != nil {
		return x.EventExclusionDuration
	}
	return EventExclusionDuration_EVENT_EXCLUSION_DURATION_UNSPECIFIED
}

func (x *EventSegmentExclusion) GetEventExclusionCriteria() *EventSegmentCriteria {
	if x != nil {
		return x.EventExclusionCriteria
	}
	return nil
}

// A segment is a subset of your Analytics data. For example, of your entire set
// of users, one segment might be users from a particular country or city.
// Another segment might be users who purchase a particular line of products or
// who visit a specific part of your site or trigger certain events in your app.
//
// To learn more, see [GA4 Segment
// Builder](https://support.google.com/analytics/answer/9304353).
type Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name for this segment. If unspecified, segments are named "Segment".
	// This name defines string value returned by the `segment` dimension. The
	// `segment` dimension prefixes segment names by the 1-based index number of
	// the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A segment is specified in one scope.
	//
	// Types that are assignable to OneSegmentScope:
	//	*Segment_UserSegment
	//	*Segment_SessionSegment
	//	*Segment_EventSegment
	OneSegmentScope isSegment_OneSegmentScope `protobuf_oneof:"one_segment_scope"`
}

func (x *Segment) Reset() {
	*x = Segment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Segment) ProtoMessage() {}

func (x *Segment) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Segment.ProtoReflect.Descriptor instead.
func (*Segment) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{37}
}

func (x *Segment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Segment) GetOneSegmentScope() isSegment_OneSegmentScope {
	if m != nil {
		return m.OneSegmentScope
	}
	return nil
}

func (x *Segment) GetUserSegment() *UserSegment {
	if x, ok := x.GetOneSegmentScope().(*Segment_UserSegment); ok {
		return x.UserSegment
	}
	return nil
}

func (x *Segment) GetSessionSegment() *SessionSegment {
	if x, ok := x.GetOneSegmentScope().(*Segment_SessionSegment); ok {
		return x.SessionSegment
	}
	return nil
}

func (x *Segment) GetEventSegment() *EventSegment {
	if x, ok := x.GetOneSegmentScope().(*Segment_EventSegment); ok {
		return x.EventSegment
	}
	return nil
}

type isSegment_OneSegmentScope interface {
	isSegment_OneSegmentScope()
}

type Segment_UserSegment struct {
	// User segments are subsets of users who engaged with your site or app.
	UserSegment *UserSegment `protobuf:"bytes,2,opt,name=user_segment,json=userSegment,proto3,oneof"`
}

type Segment_SessionSegment struct {
	// Session segments are subsets of the sessions that occurred on your site
	// or app.
	SessionSegment *SessionSegment `protobuf:"bytes,3,opt,name=session_segment,json=sessionSegment,proto3,oneof"`
}

type Segment_EventSegment struct {
	// Event segments are subsets of events that were triggered on your site or
	// app.
	EventSegment *EventSegment `protobuf:"bytes,4,opt,name=event_segment,json=eventSegment,proto3,oneof"`
}

func (*Segment_UserSegment) isSegment_OneSegmentScope() {}

func (*Segment_SessionSegment) isSegment_OneSegmentScope() {}

func (*Segment_EventSegment) isSegment_OneSegmentScope() {}

// Expresses combinations of segment filters.
type SegmentFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter for `SegmentFilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*SegmentFilterExpression_AndGroup
	//	*SegmentFilterExpression_OrGroup
	//	*SegmentFilterExpression_NotExpression
	//	*SegmentFilterExpression_SegmentFilter
	//	*SegmentFilterExpression_SegmentEventFilter
	Expr isSegmentFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *SegmentFilterExpression) Reset() {
	*x = SegmentFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentFilterExpression) ProtoMessage() {}

func (x *SegmentFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentFilterExpression.ProtoReflect.Descriptor instead.
func (*SegmentFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{38}
}

func (m *SegmentFilterExpression) GetExpr() isSegmentFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *SegmentFilterExpression) GetAndGroup() *SegmentFilterExpressionList {
	if x, ok := x.GetExpr().(*SegmentFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *SegmentFilterExpression) GetOrGroup() *SegmentFilterExpressionList {
	if x, ok := x.GetExpr().(*SegmentFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *SegmentFilterExpression) GetNotExpression() *SegmentFilterExpression {
	if x, ok := x.GetExpr().(*SegmentFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *SegmentFilterExpression) GetSegmentFilter() *SegmentFilter {
	if x, ok := x.GetExpr().(*SegmentFilterExpression_SegmentFilter); ok {
		return x.SegmentFilter
	}
	return nil
}

func (x *SegmentFilterExpression) GetSegmentEventFilter() *SegmentEventFilter {
	if x, ok := x.GetExpr().(*SegmentFilterExpression_SegmentEventFilter); ok {
		return x.SegmentEventFilter
	}
	return nil
}

type isSegmentFilterExpression_Expr interface {
	isSegmentFilterExpression_Expr()
}

type SegmentFilterExpression_AndGroup struct {
	// The SegmentFilterExpression in `andGroup` have an AND relationship.
	AndGroup *SegmentFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type SegmentFilterExpression_OrGroup struct {
	// The SegmentFilterExpression in `orGroup` have an OR relationship.
	OrGroup *SegmentFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type SegmentFilterExpression_NotExpression struct {
	// The SegmentFilterExpression is NOT of `notExpression`.
	NotExpression *SegmentFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type SegmentFilterExpression_SegmentFilter struct {
	// A primitive segment filter.
	SegmentFilter *SegmentFilter `protobuf:"bytes,4,opt,name=segment_filter,json=segmentFilter,proto3,oneof"`
}

type SegmentFilterExpression_SegmentEventFilter struct {
	// Creates a filter that matches events of a single event name. If a
	// parameter filter expression is specified, only the subset of events that
	// match both the single event name and the parameter filter expressions
	// match this event filter.
	SegmentEventFilter *SegmentEventFilter `protobuf:"bytes,5,opt,name=segment_event_filter,json=segmentEventFilter,proto3,oneof"`
}

func (*SegmentFilterExpression_AndGroup) isSegmentFilterExpression_Expr() {}

func (*SegmentFilterExpression_OrGroup) isSegmentFilterExpression_Expr() {}

func (*SegmentFilterExpression_NotExpression) isSegmentFilterExpression_Expr() {}

func (*SegmentFilterExpression_SegmentFilter) isSegmentFilterExpression_Expr() {}

func (*SegmentFilterExpression_SegmentEventFilter) isSegmentFilterExpression_Expr() {}

// A list of segment filter expressions.
type SegmentFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of segment filter expressions
	Expressions []*SegmentFilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *SegmentFilterExpressionList) Reset() {
	*x = SegmentFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentFilterExpressionList) ProtoMessage() {}

func (x *SegmentFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentFilterExpressionList.ProtoReflect.Descriptor instead.
func (*SegmentFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{39}
}

func (x *SegmentFilterExpressionList) GetExpressions() []*SegmentFilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter dimension or metric values.
type SegmentFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension name or metric name.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Specify one type of filter for `Filter`.
	//
	// Types that are assignable to OneFilter:
	//	*SegmentFilter_StringFilter
	//	*SegmentFilter_InListFilter
	//	*SegmentFilter_NumericFilter
	//	*SegmentFilter_BetweenFilter
	OneFilter isSegmentFilter_OneFilter `protobuf_oneof:"one_filter"`
	// Specifies the scope for the filter.
	FilterScoping *SegmentFilterScoping `protobuf:"bytes,8,opt,name=filter_scoping,json=filterScoping,proto3" json:"filter_scoping,omitempty"`
}

func (x *SegmentFilter) Reset() {
	*x = SegmentFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentFilter) ProtoMessage() {}

func (x *SegmentFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentFilter.ProtoReflect.Descriptor instead.
func (*SegmentFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{40}
}

func (x *SegmentFilter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (m *SegmentFilter) GetOneFilter() isSegmentFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *SegmentFilter) GetStringFilter() *StringFilter {
	if x, ok := x.GetOneFilter().(*SegmentFilter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *SegmentFilter) GetInListFilter() *InListFilter {
	if x, ok := x.GetOneFilter().(*SegmentFilter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *SegmentFilter) GetNumericFilter() *NumericFilter {
	if x, ok := x.GetOneFilter().(*SegmentFilter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *SegmentFilter) GetBetweenFilter() *BetweenFilter {
	if x, ok := x.GetOneFilter().(*SegmentFilter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

func (x *SegmentFilter) GetFilterScoping() *SegmentFilterScoping {
	if x != nil {
		return x.FilterScoping
	}
	return nil
}

type isSegmentFilter_OneFilter interface {
	isSegmentFilter_OneFilter()
}

type SegmentFilter_StringFilter struct {
	// Strings related filter.
	StringFilter *StringFilter `protobuf:"bytes,4,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type SegmentFilter_InListFilter struct {
	// A filter for in list values.
	InListFilter *InListFilter `protobuf:"bytes,5,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type SegmentFilter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *NumericFilter `protobuf:"bytes,6,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type SegmentFilter_BetweenFilter struct {
	// A filter for between two values.
	BetweenFilter *BetweenFilter `protobuf:"bytes,7,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*SegmentFilter_StringFilter) isSegmentFilter_OneFilter() {}

func (*SegmentFilter_InListFilter) isSegmentFilter_OneFilter() {}

func (*SegmentFilter_NumericFilter) isSegmentFilter_OneFilter() {}

func (*SegmentFilter_BetweenFilter) isSegmentFilter_OneFilter() {}

// Scopings specify how the dimensions & metrics of multiple events
// should be considered when evaluating a segment filter.
type SegmentFilterScoping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `atAnyPointInTime` is true, this filter evaluates to true for all
	// events if it evaluates to true for any event in the date range of the
	// request.
	//
	// This `atAnyPointInTime` parameter does not extend the date range of
	// events in the report. If `atAnyPointInTime` is true, only events within
	// the report's date range are considered when evaluating this filter.
	//
	// This `atAnyPointInTime` is only able to be specified if the criteria
	// scoping is `ACROSS_ALL_SESSIONS` and is not able to be specified in
	// sequences.
	//
	// If the criteria scoping is `ACROSS_ALL_SESSIONS`, `atAnyPointInTime` =
	// false is used if unspecified.
	AtAnyPointInTime *bool `protobuf:"varint,1,opt,name=at_any_point_in_time,json=atAnyPointInTime,proto3,oneof" json:"at_any_point_in_time,omitempty"`
}

func (x *SegmentFilterScoping) Reset() {
	*x = SegmentFilterScoping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentFilterScoping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentFilterScoping) ProtoMessage() {}

func (x *SegmentFilterScoping) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentFilterScoping.ProtoReflect.Descriptor instead.
func (*SegmentFilterScoping) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{41}
}

func (x *SegmentFilterScoping) GetAtAnyPointInTime() bool {
	if x != nil && x.AtAnyPointInTime != nil {
		return *x.AtAnyPointInTime
	}
	return false
}

// Creates a filter that matches events of a single event name. If a parameter
// filter expression is specified, only the subset of events that match both the
// single event name and the parameter filter expressions match this event
// filter.
type SegmentEventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This filter matches events of this single event name. Event name is
	// required.
	EventName *string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3,oneof" json:"event_name,omitempty"`
	// If specified, this filter matches events that match both the single event
	// name and the parameter filter expressions.
	//
	// Inside the parameter filter expression, only parameter filters are
	// available.
	SegmentParameterFilterExpression *SegmentParameterFilterExpression `protobuf:"bytes,2,opt,name=segment_parameter_filter_expression,json=segmentParameterFilterExpression,proto3,oneof" json:"segment_parameter_filter_expression,omitempty"`
}

func (x *SegmentEventFilter) Reset() {
	*x = SegmentEventFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentEventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentEventFilter) ProtoMessage() {}

func (x *SegmentEventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentEventFilter.ProtoReflect.Descriptor instead.
func (*SegmentEventFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{42}
}

func (x *SegmentEventFilter) GetEventName() string {
	if x != nil && x.EventName != nil {
		return *x.EventName
	}
	return ""
}

func (x *SegmentEventFilter) GetSegmentParameterFilterExpression() *SegmentParameterFilterExpression {
	if x != nil {
		return x.SegmentParameterFilterExpression
	}
	return nil
}

// Expresses combinations of segment filter on parameters.
type SegmentParameterFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter for `SegmentParameterFilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*SegmentParameterFilterExpression_AndGroup
	//	*SegmentParameterFilterExpression_OrGroup
	//	*SegmentParameterFilterExpression_NotExpression
	//	*SegmentParameterFilterExpression_SegmentParameterFilter
	Expr isSegmentParameterFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *SegmentParameterFilterExpression) Reset() {
	*x = SegmentParameterFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentParameterFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentParameterFilterExpression) ProtoMessage() {}

func (x *SegmentParameterFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentParameterFilterExpression.ProtoReflect.Descriptor instead.
func (*SegmentParameterFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{43}
}

func (m *SegmentParameterFilterExpression) GetExpr() isSegmentParameterFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *SegmentParameterFilterExpression) GetAndGroup() *SegmentParameterFilterExpressionList {
	if x, ok := x.GetExpr().(*SegmentParameterFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *SegmentParameterFilterExpression) GetOrGroup() *SegmentParameterFilterExpressionList {
	if x, ok := x.GetExpr().(*SegmentParameterFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *SegmentParameterFilterExpression) GetNotExpression() *SegmentParameterFilterExpression {
	if x, ok := x.GetExpr().(*SegmentParameterFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *SegmentParameterFilterExpression) GetSegmentParameterFilter() *SegmentParameterFilter {
	if x, ok := x.GetExpr().(*SegmentParameterFilterExpression_SegmentParameterFilter); ok {
		return x.SegmentParameterFilter
	}
	return nil
}

type isSegmentParameterFilterExpression_Expr interface {
	isSegmentParameterFilterExpression_Expr()
}

type SegmentParameterFilterExpression_AndGroup struct {
	// The SegmentParameterFilterExpression in `andGroup` have an AND
	// relationship.
	AndGroup *SegmentParameterFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type SegmentParameterFilterExpression_OrGroup struct {
	// The SegmentParameterFilterExpression in `orGroup` have an OR
	// relationship.
	OrGroup *SegmentParameterFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type SegmentParameterFilterExpression_NotExpression struct {
	// The SegmentParameterFilterExpression is NOT of `notExpression`.
	NotExpression *SegmentParameterFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type SegmentParameterFilterExpression_SegmentParameterFilter struct {
	// A primitive segment parameter filter.
	SegmentParameterFilter *SegmentParameterFilter `protobuf:"bytes,4,opt,name=segment_parameter_filter,json=segmentParameterFilter,proto3,oneof"`
}

func (*SegmentParameterFilterExpression_AndGroup) isSegmentParameterFilterExpression_Expr() {}

func (*SegmentParameterFilterExpression_OrGroup) isSegmentParameterFilterExpression_Expr() {}

func (*SegmentParameterFilterExpression_NotExpression) isSegmentParameterFilterExpression_Expr() {}

func (*SegmentParameterFilterExpression_SegmentParameterFilter) isSegmentParameterFilterExpression_Expr() {
}

// A list of segment parameter filter expressions.
type SegmentParameterFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of segment parameter filter expressions.
	Expressions []*SegmentParameterFilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *SegmentParameterFilterExpressionList) Reset() {
	*x = SegmentParameterFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentParameterFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentParameterFilterExpressionList) ProtoMessage() {}

func (x *SegmentParameterFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentParameterFilterExpressionList.ProtoReflect.Descriptor instead.
func (*SegmentParameterFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{44}
}

func (x *SegmentParameterFilterExpressionList) GetExpressions() []*SegmentParameterFilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter parameter values in a segment.
type SegmentParameterFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field that is being filtered.
	//
	// Types that are assignable to OneParameter:
	//	*SegmentParameterFilter_EventParameterName
	//	*SegmentParameterFilter_ItemParameterName
	OneParameter isSegmentParameterFilter_OneParameter `protobuf_oneof:"one_parameter"`
	// Specify one type of filter.
	//
	// Types that are assignable to OneFilter:
	//	*SegmentParameterFilter_StringFilter
	//	*SegmentParameterFilter_InListFilter
	//	*SegmentParameterFilter_NumericFilter
	//	*SegmentParameterFilter_BetweenFilter
	OneFilter isSegmentParameterFilter_OneFilter `protobuf_oneof:"one_filter"`
	// Specifies the scope for the filter.
	FilterScoping *SegmentParameterFilterScoping `protobuf:"bytes,8,opt,name=filter_scoping,json=filterScoping,proto3" json:"filter_scoping,omitempty"`
}

func (x *SegmentParameterFilter) Reset() {
	*x = SegmentParameterFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentParameterFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentParameterFilter) ProtoMessage() {}

func (x *SegmentParameterFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentParameterFilter.ProtoReflect.Descriptor instead.
func (*SegmentParameterFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{45}
}

func (m *SegmentParameterFilter) GetOneParameter() isSegmentParameterFilter_OneParameter {
	if m != nil {
		return m.OneParameter
	}
	return nil
}

func (x *SegmentParameterFilter) GetEventParameterName() string {
	if x, ok := x.GetOneParameter().(*SegmentParameterFilter_EventParameterName); ok {
		return x.EventParameterName
	}
	return ""
}

func (x *SegmentParameterFilter) GetItemParameterName() string {
	if x, ok := x.GetOneParameter().(*SegmentParameterFilter_ItemParameterName); ok {
		return x.ItemParameterName
	}
	return ""
}

func (m *SegmentParameterFilter) GetOneFilter() isSegmentParameterFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *SegmentParameterFilter) GetStringFilter() *StringFilter {
	if x, ok := x.GetOneFilter().(*SegmentParameterFilter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *SegmentParameterFilter) GetInListFilter() *InListFilter {
	if x, ok := x.GetOneFilter().(*SegmentParameterFilter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *SegmentParameterFilter) GetNumericFilter() *NumericFilter {
	if x, ok := x.GetOneFilter().(*SegmentParameterFilter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *SegmentParameterFilter) GetBetweenFilter() *BetweenFilter {
	if x, ok := x.GetOneFilter().(*SegmentParameterFilter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

func (x *SegmentParameterFilter) GetFilterScoping() *SegmentParameterFilterScoping {
	if x != nil {
		return x.FilterScoping
	}
	return nil
}

type isSegmentParameterFilter_OneParameter interface {
	isSegmentParameterFilter_OneParameter()
}

type SegmentParameterFilter_EventParameterName struct {
	// This filter will be evaluated on the specified event parameter. Event
	// parameters are logged as parameters of the event. Event parameters
	// include fields like "firebase_screen" & "currency".
	//
	// Event parameters can only be used in segments & funnels and can only be
	// used in a descendent filter from an EventFilter. In a descendent filter
	// from an EventFilter either event or item parameters should be used.
	EventParameterName string `protobuf:"bytes,1,opt,name=event_parameter_name,json=eventParameterName,proto3,oneof"`
}

type SegmentParameterFilter_ItemParameterName struct {
	// This filter will be evaluated on the specified item parameter. Item
	// parameters are logged as parameters in the item array. Item parameters
	// include fields like "item_name" & "item_category".
	//
	// Item parameters can only be used in segments & funnels and can only be
	// used in a descendent filter from an EventFilter. In a descendent filter
	// from an EventFilter either event or item parameters should be used.
	//
	// Item parameters are only available in ecommerce events. To learn more
	// about ecommerce events, see the [Measure ecommerce]
	// (https://developers.google.com/analytics/devguides/collection/ga4/ecommerce)
	// guide.
	ItemParameterName string `protobuf:"bytes,2,opt,name=item_parameter_name,json=itemParameterName,proto3,oneof"`
}

func (*SegmentParameterFilter_EventParameterName) isSegmentParameterFilter_OneParameter() {}

func (*SegmentParameterFilter_ItemParameterName) isSegmentParameterFilter_OneParameter() {}

type isSegmentParameterFilter_OneFilter interface {
	isSegmentParameterFilter_OneFilter()
}

type SegmentParameterFilter_StringFilter struct {
	// Strings related filter.
	StringFilter *StringFilter `protobuf:"bytes,4,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type SegmentParameterFilter_InListFilter struct {
	// A filter for in list values.
	InListFilter *InListFilter `protobuf:"bytes,5,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type SegmentParameterFilter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *NumericFilter `protobuf:"bytes,6,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type SegmentParameterFilter_BetweenFilter struct {
	// A filter for between two values.
	BetweenFilter *BetweenFilter `protobuf:"bytes,7,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*SegmentParameterFilter_StringFilter) isSegmentParameterFilter_OneFilter() {}

func (*SegmentParameterFilter_InListFilter) isSegmentParameterFilter_OneFilter() {}

func (*SegmentParameterFilter_NumericFilter) isSegmentParameterFilter_OneFilter() {}

func (*SegmentParameterFilter_BetweenFilter) isSegmentParameterFilter_OneFilter() {}

// Scopings specify how multiple events should be considered when evaluating a
// segment parameter filter.
type SegmentParameterFilterScoping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Accumulates the parameter over the specified period of days before
	// applying the filter. Only supported if criteria scoping is
	// `ACROSS_ALL_SESSIONS` or `WITHIN_SAME_SESSION`. Only supported if the
	// parameter is `event_count`.
	//
	// For example if `inAnyNDayPeriod` is 3, the event_name is "purchase",
	// the event parameter is "event_count", and the Filter's criteria is
	// greater than 5, this filter will accumulate the event count of purchase
	// events over every 3 consecutive day period in the report's date range; a
	// user will pass this Filter's criteria to be included in this segment if
	// their count of purchase events exceeds 5 in any 3 consecutive day period.
	// For example, the periods 2021-11-01 to 2021-11-03, 2021-11-02 to
	// 2021-11-04, 2021-11-03 to 2021-11-05, and etc. will be considered.
	//
	// The date range is not extended for the purpose of having a full N day
	// window near the start of the date range. For example if a report is for
	// 2021-11-01 to 2021-11-10 and `inAnyNDayPeriod` = 3, the first two day
	// period will be effectively shortened because no event data outside the
	// report's date range will be read. For example, the first four periods
	// will effectively be: 2021-11-01 to 2021-11-01, 2021-11-01 to 2021-11-02,
	// 2021-11-01 to 2021-11-03, and 2021-11-02 to 2021-11-04.
	//
	// `inAnyNDayPeriod` is optional. If not specified, the
	// `segmentParameterFilter` is applied to each event individually.
	InAnyNDayPeriod *int64 `protobuf:"varint,1,opt,name=in_any_n_day_period,json=inAnyNDayPeriod,proto3,oneof" json:"in_any_n_day_period,omitempty"`
}

func (x *SegmentParameterFilterScoping) Reset() {
	*x = SegmentParameterFilterScoping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentParameterFilterScoping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentParameterFilterScoping) ProtoMessage() {}

func (x *SegmentParameterFilterScoping) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentParameterFilterScoping.ProtoReflect.Descriptor instead.
func (*SegmentParameterFilterScoping) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{46}
}

func (x *SegmentParameterFilterScoping) GetInAnyNDayPeriod() int64 {
	if x != nil && x.InAnyNDayPeriod != nil {
		return *x.InAnyNDayPeriod
	}
	return 0
}

// Expresses combinations of funnel filters.
type FunnelFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter for `FunnelFilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*FunnelFilterExpression_AndGroup
	//	*FunnelFilterExpression_OrGroup
	//	*FunnelFilterExpression_NotExpression
	//	*FunnelFilterExpression_FunnelFieldFilter
	//	*FunnelFilterExpression_FunnelEventFilter
	Expr isFunnelFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *FunnelFilterExpression) Reset() {
	*x = FunnelFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelFilterExpression) ProtoMessage() {}

func (x *FunnelFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelFilterExpression.ProtoReflect.Descriptor instead.
func (*FunnelFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{47}
}

func (m *FunnelFilterExpression) GetExpr() isFunnelFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *FunnelFilterExpression) GetAndGroup() *FunnelFilterExpressionList {
	if x, ok := x.GetExpr().(*FunnelFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *FunnelFilterExpression) GetOrGroup() *FunnelFilterExpressionList {
	if x, ok := x.GetExpr().(*FunnelFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *FunnelFilterExpression) GetNotExpression() *FunnelFilterExpression {
	if x, ok := x.GetExpr().(*FunnelFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *FunnelFilterExpression) GetFunnelFieldFilter() *FunnelFieldFilter {
	if x, ok := x.GetExpr().(*FunnelFilterExpression_FunnelFieldFilter); ok {
		return x.FunnelFieldFilter
	}
	return nil
}

func (x *FunnelFilterExpression) GetFunnelEventFilter() *FunnelEventFilter {
	if x, ok := x.GetExpr().(*FunnelFilterExpression_FunnelEventFilter); ok {
		return x.FunnelEventFilter
	}
	return nil
}

type isFunnelFilterExpression_Expr interface {
	isFunnelFilterExpression_Expr()
}

type FunnelFilterExpression_AndGroup struct {
	// The FunnelFilterExpression in `andGroup` have an AND relationship.
	AndGroup *FunnelFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type FunnelFilterExpression_OrGroup struct {
	// The FunnelFilterExpression in `orGroup` have an OR relationship.
	OrGroup *FunnelFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type FunnelFilterExpression_NotExpression struct {
	// The FunnelFilterExpression is NOT of `notExpression`.
	NotExpression *FunnelFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type FunnelFilterExpression_FunnelFieldFilter struct {
	// A funnel filter for a dimension or metric.
	FunnelFieldFilter *FunnelFieldFilter `protobuf:"bytes,4,opt,name=funnel_field_filter,json=funnelFieldFilter,proto3,oneof"`
}

type FunnelFilterExpression_FunnelEventFilter struct {
	// Creates a filter that matches events of a single event name. If a
	// parameter filter expression is specified, only the subset of events that
	// match both the single event name and the parameter filter expressions
	// match this event filter.
	FunnelEventFilter *FunnelEventFilter `protobuf:"bytes,5,opt,name=funnel_event_filter,json=funnelEventFilter,proto3,oneof"`
}

func (*FunnelFilterExpression_AndGroup) isFunnelFilterExpression_Expr() {}

func (*FunnelFilterExpression_OrGroup) isFunnelFilterExpression_Expr() {}

func (*FunnelFilterExpression_NotExpression) isFunnelFilterExpression_Expr() {}

func (*FunnelFilterExpression_FunnelFieldFilter) isFunnelFilterExpression_Expr() {}

func (*FunnelFilterExpression_FunnelEventFilter) isFunnelFilterExpression_Expr() {}

// A list of funnel filter expressions.
type FunnelFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of funnel filter expressions.
	Expressions []*FunnelFilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *FunnelFilterExpressionList) Reset() {
	*x = FunnelFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelFilterExpressionList) ProtoMessage() {}

func (x *FunnelFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelFilterExpressionList.ProtoReflect.Descriptor instead.
func (*FunnelFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{48}
}

func (x *FunnelFilterExpressionList) GetExpressions() []*FunnelFilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter dimension or metric values.
type FunnelFieldFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension name or metric name.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Specify one type of filter.
	//
	// Types that are assignable to OneFilter:
	//	*FunnelFieldFilter_StringFilter
	//	*FunnelFieldFilter_InListFilter
	//	*FunnelFieldFilter_NumericFilter
	//	*FunnelFieldFilter_BetweenFilter
	OneFilter isFunnelFieldFilter_OneFilter `protobuf_oneof:"one_filter"`
}

func (x *FunnelFieldFilter) Reset() {
	*x = FunnelFieldFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelFieldFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelFieldFilter) ProtoMessage() {}

func (x *FunnelFieldFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelFieldFilter.ProtoReflect.Descriptor instead.
func (*FunnelFieldFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{49}
}

func (x *FunnelFieldFilter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (m *FunnelFieldFilter) GetOneFilter() isFunnelFieldFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *FunnelFieldFilter) GetStringFilter() *StringFilter {
	if x, ok := x.GetOneFilter().(*FunnelFieldFilter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *FunnelFieldFilter) GetInListFilter() *InListFilter {
	if x, ok := x.GetOneFilter().(*FunnelFieldFilter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *FunnelFieldFilter) GetNumericFilter() *NumericFilter {
	if x, ok := x.GetOneFilter().(*FunnelFieldFilter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *FunnelFieldFilter) GetBetweenFilter() *BetweenFilter {
	if x, ok := x.GetOneFilter().(*FunnelFieldFilter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

type isFunnelFieldFilter_OneFilter interface {
	isFunnelFieldFilter_OneFilter()
}

type FunnelFieldFilter_StringFilter struct {
	// Strings related filter.
	StringFilter *StringFilter `protobuf:"bytes,4,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type FunnelFieldFilter_InListFilter struct {
	// A filter for in list values.
	InListFilter *InListFilter `protobuf:"bytes,5,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type FunnelFieldFilter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *NumericFilter `protobuf:"bytes,6,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type FunnelFieldFilter_BetweenFilter struct {
	// A filter for between two values.
	BetweenFilter *BetweenFilter `protobuf:"bytes,7,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*FunnelFieldFilter_StringFilter) isFunnelFieldFilter_OneFilter() {}

func (*FunnelFieldFilter_InListFilter) isFunnelFieldFilter_OneFilter() {}

func (*FunnelFieldFilter_NumericFilter) isFunnelFieldFilter_OneFilter() {}

func (*FunnelFieldFilter_BetweenFilter) isFunnelFieldFilter_OneFilter() {}

// Creates a filter that matches events of a single event name. If a parameter
// filter expression is specified, only the subset of events that match both the
// single event name and the parameter filter expressions match this event
// filter.
type FunnelEventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This filter matches events of this single event name. Event name is
	// required.
	EventName *string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3,oneof" json:"event_name,omitempty"`
	// If specified, this filter matches events that match both the single event
	// name and the parameter filter expressions.
	//
	// Inside the parameter filter expression, only parameter filters are
	// available.
	FunnelParameterFilterExpression *FunnelParameterFilterExpression `protobuf:"bytes,2,opt,name=funnel_parameter_filter_expression,json=funnelParameterFilterExpression,proto3,oneof" json:"funnel_parameter_filter_expression,omitempty"`
}

func (x *FunnelEventFilter) Reset() {
	*x = FunnelEventFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelEventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelEventFilter) ProtoMessage() {}

func (x *FunnelEventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelEventFilter.ProtoReflect.Descriptor instead.
func (*FunnelEventFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{50}
}

func (x *FunnelEventFilter) GetEventName() string {
	if x != nil && x.EventName != nil {
		return *x.EventName
	}
	return ""
}

func (x *FunnelEventFilter) GetFunnelParameterFilterExpression() *FunnelParameterFilterExpression {
	if x != nil {
		return x.FunnelParameterFilterExpression
	}
	return nil
}

// Expresses combinations of funnel filters on parameters.
type FunnelParameterFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter for `FunnelParameterFilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*FunnelParameterFilterExpression_AndGroup
	//	*FunnelParameterFilterExpression_OrGroup
	//	*FunnelParameterFilterExpression_NotExpression
	//	*FunnelParameterFilterExpression_FunnelParameterFilter
	Expr isFunnelParameterFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *FunnelParameterFilterExpression) Reset() {
	*x = FunnelParameterFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelParameterFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelParameterFilterExpression) ProtoMessage() {}

func (x *FunnelParameterFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelParameterFilterExpression.ProtoReflect.Descriptor instead.
func (*FunnelParameterFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{51}
}

func (m *FunnelParameterFilterExpression) GetExpr() isFunnelParameterFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *FunnelParameterFilterExpression) GetAndGroup() *FunnelParameterFilterExpressionList {
	if x, ok := x.GetExpr().(*FunnelParameterFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *FunnelParameterFilterExpression) GetOrGroup() *FunnelParameterFilterExpressionList {
	if x, ok := x.GetExpr().(*FunnelParameterFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *FunnelParameterFilterExpression) GetNotExpression() *FunnelParameterFilterExpression {
	if x, ok := x.GetExpr().(*FunnelParameterFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *FunnelParameterFilterExpression) GetFunnelParameterFilter() *FunnelParameterFilter {
	if x, ok := x.GetExpr().(*FunnelParameterFilterExpression_FunnelParameterFilter); ok {
		return x.FunnelParameterFilter
	}
	return nil
}

type isFunnelParameterFilterExpression_Expr interface {
	isFunnelParameterFilterExpression_Expr()
}

type FunnelParameterFilterExpression_AndGroup struct {
	// The FunnelParameterFilterExpression in `andGroup` have an AND
	// relationship.
	AndGroup *FunnelParameterFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type FunnelParameterFilterExpression_OrGroup struct {
	// The FunnelParameterFilterExpression in `orGroup` have an OR
	// relationship.
	OrGroup *FunnelParameterFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type FunnelParameterFilterExpression_NotExpression struct {
	// The FunnelParameterFilterExpression is NOT of `notExpression`.
	NotExpression *FunnelParameterFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type FunnelParameterFilterExpression_FunnelParameterFilter struct {
	// A primitive funnel parameter filter.
	FunnelParameterFilter *FunnelParameterFilter `protobuf:"bytes,4,opt,name=funnel_parameter_filter,json=funnelParameterFilter,proto3,oneof"`
}

func (*FunnelParameterFilterExpression_AndGroup) isFunnelParameterFilterExpression_Expr() {}

func (*FunnelParameterFilterExpression_OrGroup) isFunnelParameterFilterExpression_Expr() {}

func (*FunnelParameterFilterExpression_NotExpression) isFunnelParameterFilterExpression_Expr() {}

func (*FunnelParameterFilterExpression_FunnelParameterFilter) isFunnelParameterFilterExpression_Expr() {
}

// A list of funnel parameter filter expressions.
type FunnelParameterFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of funnel parameter filter expressions.
	Expressions []*FunnelParameterFilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *FunnelParameterFilterExpressionList) Reset() {
	*x = FunnelParameterFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelParameterFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelParameterFilterExpressionList) ProtoMessage() {}

func (x *FunnelParameterFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelParameterFilterExpressionList.ProtoReflect.Descriptor instead.
func (*FunnelParameterFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{52}
}

func (x *FunnelParameterFilterExpressionList) GetExpressions() []*FunnelParameterFilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter parameter values in a funnel.
type FunnelParameterFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field that is being filtered.
	//
	// Types that are assignable to OneParameter:
	//	*FunnelParameterFilter_EventParameterName
	//	*FunnelParameterFilter_ItemParameterName
	OneParameter isFunnelParameterFilter_OneParameter `protobuf_oneof:"one_parameter"`
	// Specify one type of filter.
	//
	// Types that are assignable to OneFilter:
	//	*FunnelParameterFilter_StringFilter
	//	*FunnelParameterFilter_InListFilter
	//	*FunnelParameterFilter_NumericFilter
	//	*FunnelParameterFilter_BetweenFilter
	OneFilter isFunnelParameterFilter_OneFilter `protobuf_oneof:"one_filter"`
}

func (x *FunnelParameterFilter) Reset() {
	*x = FunnelParameterFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelParameterFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelParameterFilter) ProtoMessage() {}

func (x *FunnelParameterFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelParameterFilter.ProtoReflect.Descriptor instead.
func (*FunnelParameterFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{53}
}

func (m *FunnelParameterFilter) GetOneParameter() isFunnelParameterFilter_OneParameter {
	if m != nil {
		return m.OneParameter
	}
	return nil
}

func (x *FunnelParameterFilter) GetEventParameterName() string {
	if x, ok := x.GetOneParameter().(*FunnelParameterFilter_EventParameterName); ok {
		return x.EventParameterName
	}
	return ""
}

func (x *FunnelParameterFilter) GetItemParameterName() string {
	if x, ok := x.GetOneParameter().(*FunnelParameterFilter_ItemParameterName); ok {
		return x.ItemParameterName
	}
	return ""
}

func (m *FunnelParameterFilter) GetOneFilter() isFunnelParameterFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *FunnelParameterFilter) GetStringFilter() *StringFilter {
	if x, ok := x.GetOneFilter().(*FunnelParameterFilter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *FunnelParameterFilter) GetInListFilter() *InListFilter {
	if x, ok := x.GetOneFilter().(*FunnelParameterFilter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *FunnelParameterFilter) GetNumericFilter() *NumericFilter {
	if x, ok := x.GetOneFilter().(*FunnelParameterFilter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *FunnelParameterFilter) GetBetweenFilter() *BetweenFilter {
	if x, ok := x.GetOneFilter().(*FunnelParameterFilter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

type isFunnelParameterFilter_OneParameter interface {
	isFunnelParameterFilter_OneParameter()
}

type FunnelParameterFilter_EventParameterName struct {
	// This filter will be evaluated on the specified event parameter. Event
	// parameters are logged as parameters of the event. Event parameters
	// include fields like "firebase_screen" & "currency".
	//
	// Event parameters can only be used in segments & funnels and can only be
	// used in a descendent filter from an EventFilter. In a descendent filter
	// from an EventFilter either event or item parameters should be used.
	EventParameterName string `protobuf:"bytes,1,opt,name=event_parameter_name,json=eventParameterName,proto3,oneof"`
}

type FunnelParameterFilter_ItemParameterName struct {
	// This filter will be evaluated on the specified item parameter. Item
	// parameters are logged as parameters in the item array. Item parameters
	// include fields like "item_name" & "item_category".
	//
	// Item parameters can only be used in segments & funnels and can only be
	// used in a descendent filter from an EventFilter. In a descendent filter
	// from an EventFilter either event or item parameters should be used.
	//
	// Item parameters are only available in ecommerce events. To learn more
	// about ecommerce events, see the [Measure ecommerce]
	// (https://developers.google.com/analytics/devguides/collection/ga4/ecommerce)
	// guide.
	ItemParameterName string `protobuf:"bytes,2,opt,name=item_parameter_name,json=itemParameterName,proto3,oneof"`
}

func (*FunnelParameterFilter_EventParameterName) isFunnelParameterFilter_OneParameter() {}

func (*FunnelParameterFilter_ItemParameterName) isFunnelParameterFilter_OneParameter() {}

type isFunnelParameterFilter_OneFilter interface {
	isFunnelParameterFilter_OneFilter()
}

type FunnelParameterFilter_StringFilter struct {
	// Strings related filter.
	StringFilter *StringFilter `protobuf:"bytes,4,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type FunnelParameterFilter_InListFilter struct {
	// A filter for in list values.
	InListFilter *InListFilter `protobuf:"bytes,5,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type FunnelParameterFilter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *NumericFilter `protobuf:"bytes,6,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type FunnelParameterFilter_BetweenFilter struct {
	// A filter for between two values.
	BetweenFilter *BetweenFilter `protobuf:"bytes,7,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*FunnelParameterFilter_StringFilter) isFunnelParameterFilter_OneFilter() {}

func (*FunnelParameterFilter_InListFilter) isFunnelParameterFilter_OneFilter() {}

func (*FunnelParameterFilter_NumericFilter) isFunnelParameterFilter_OneFilter() {}

func (*FunnelParameterFilter_BetweenFilter) isFunnelParameterFilter_OneFilter() {}

// The funnel report's response metadata carries additional information about
// the funnel report.
type FunnelResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If funnel report results are
	// [sampled](https://support.google.com/analytics/answer/2637192), this
	// describes what percentage of events were used in this funnel report. One
	// `samplingMetadatas` is populated for each date range. Each
	// `samplingMetadatas` corresponds to a date range in order that date ranges
	// were specified in the request.
	//
	// However if the results are not sampled, this field will not be defined.
	SamplingMetadatas []*SamplingMetadata `protobuf:"bytes,1,rep,name=sampling_metadatas,json=samplingMetadatas,proto3" json:"sampling_metadatas,omitempty"`
}

func (x *FunnelResponseMetadata) Reset() {
	*x = FunnelResponseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunnelResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunnelResponseMetadata) ProtoMessage() {}

func (x *FunnelResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunnelResponseMetadata.ProtoReflect.Descriptor instead.
func (*FunnelResponseMetadata) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{54}
}

func (x *FunnelResponseMetadata) GetSamplingMetadatas() []*SamplingMetadata {
	if x != nil {
		return x.SamplingMetadatas
	}
	return nil
}

// If funnel report results are
// [sampled](https://support.google.com/analytics/answer/2637192), this
// metadata describes what percentage of events were used in this funnel
// report for a date range. Sampling is the practice of analyzing a subset of
// all data in order to uncover the meaningful information in the larger data
// set.
type SamplingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of events read in this sampled report for a date range.
	// This is the size of the subset this property's data that was analyzed in
	// this funnel report.
	SamplesReadCount int64 `protobuf:"varint,1,opt,name=samples_read_count,json=samplesReadCount,proto3" json:"samples_read_count,omitempty"`
	// The total number of events present in this property's data that could
	// have been analyzed in this funnel report for a date range. Sampling
	// uncovers the meaningful information about the larger data set, and this
	// is the size of the larger data set.
	//
	// To calculate the percentage of available data that was used in this
	// funnel report, compute `samplesReadCount/samplingSpaceSize`.
	SamplingSpaceSize int64 `protobuf:"varint,2,opt,name=sampling_space_size,json=samplingSpaceSize,proto3" json:"sampling_space_size,omitempty"`
}

func (x *SamplingMetadata) Reset() {
	*x = SamplingMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SamplingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SamplingMetadata) ProtoMessage() {}

func (x *SamplingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SamplingMetadata.ProtoReflect.Descriptor instead.
func (*SamplingMetadata) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{55}
}

func (x *SamplingMetadata) GetSamplesReadCount() int64 {
	if x != nil {
		return x.SamplesReadCount
	}
	return 0
}

func (x *SamplingMetadata) GetSamplingSpaceSize() int64 {
	if x != nil {
		return x.SamplingSpaceSize
	}
	return 0
}

// Used to convert a dimension value to a single case.
type DimensionExpression_CaseExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a dimension. The name must refer back to a name in dimensions
	// field of the request.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
}

func (x *DimensionExpression_CaseExpression) Reset() {
	*x = DimensionExpression_CaseExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression_CaseExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression_CaseExpression) ProtoMessage() {}

func (x *DimensionExpression_CaseExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression_CaseExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression_CaseExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{2, 0}
}

func (x *DimensionExpression_CaseExpression) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

// Used to combine dimension values to a single dimension.
type DimensionExpression_ConcatenateExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of dimensions. The names must refer back to names in the dimensions
	// field of the request.
	DimensionNames []string `protobuf:"bytes,1,rep,name=dimension_names,json=dimensionNames,proto3" json:"dimension_names,omitempty"`
	// The delimiter placed between dimension names.
	//
	// Delimiters are often single characters such as "|" or "," but can be
	// longer strings. If a dimension value contains the delimiter, both will be
	// present in response with no distinction. For example if dimension 1 value
	// = "US,FR", dimension 2 value = "JP", and delimiter = ",", then the
	// response will contain "US,FR,JP".
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
}

func (x *DimensionExpression_ConcatenateExpression) Reset() {
	*x = DimensionExpression_ConcatenateExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression_ConcatenateExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression_ConcatenateExpression) ProtoMessage() {}

func (x *DimensionExpression_ConcatenateExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_data_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression_ConcatenateExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression_ConcatenateExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_data_proto_rawDescGZIP(), []int{2, 1}
}

func (x *DimensionExpression_ConcatenateExpression) GetDimensionNames() []string {
	if x != nil {
		return x.DimensionNames
	}
	return nil
}

func (x *DimensionExpression_ConcatenateExpression) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

var File_google_analytics_data_v1alpha_data_proto protoreflect.FileDescriptor

var file_google_analytics_data_v1alpha_data_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x59, 0x0a, 0x09, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf6, 0x03,
	0x0a, 0x13, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x63,
	0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61,
	0x73, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09,
	0x6c, 0x6f, 0x77, 0x65, 0x72, 0x43, 0x61, 0x73, 0x65, 0x12, 0x62, 0x0a, 0x0a, 0x75, 0x70, 0x70,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x09, 0x75, 0x70, 0x70, 0x65, 0x72, 0x43, 0x61, 0x73, 0x65, 0x12, 0x6c, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e, 0x61,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e, 0x61, 0x74, 0x65, 0x1a, 0x37, 0x0a, 0x0e, 0x43,
	0x61, 0x73, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x5e, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x65, 0x72, 0x42, 0x10, 0x0a, 0x0e, 0x6f, 0x6e, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x02, 0x0a, 0x10, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x09, 0x61,
	0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x50, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x58, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f,
	0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04,
	0x65, 0x78, 0x70, 0x72, 0x22, 0x69, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0b,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x8c, 0x03, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52,
	0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a,
	0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x62, 0x65, 0x74,
	0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48,
	0x00, 0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa9,
	0x02, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x54, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x47, 0x49, 0x4e,
	0x53, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x44, 0x53,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41,
	0x49, 0x4e, 0x53, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x52, 0x45,
	0x47, 0x45, 0x58, 0x50, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41,
	0x4c, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58, 0x50, 0x10, 0x06, 0x22, 0x4d, 0x0a, 0x0c, 0x49, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0xb0, 0x02, 0x0a, 0x0d, 0x4e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x53, 0x53, 0x5f,
	0x54, 0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x03, 0x12,
	0x10, 0x0a, 0x0c, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10,
	0x04, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41,
	0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x05, 0x22, 0xa3, 0x01, 0x0a,
	0x0d, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4a,
	0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x09, 0x66, 0x72, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x74, 0x6f,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x74, 0x6f, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x63, 0x0a, 0x0c, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x25, 0x0a, 0x0f, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x61,
	0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xb0, 0x01, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x58, 0x0a, 0x10, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0x35, 0x0a, 0x0e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b,
	0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x32, 0x0a, 0x0b, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x90, 0x04, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x12, 0x50, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x50, 0x65, 0x72,
	0x44, 0x61, 0x79, 0x12, 0x52, 0x0a, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x5b, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x12, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x12, 0x75, 0x0a, 0x22, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x1d, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x50, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x84, 0x01, 0x0a, 0x29,
	0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x25, 0x70, 0x6f, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x48, 0x6f,
	0x75, 0x72, 0x22, 0x47, 0x0a, 0x0b, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x1c, 0x0a,
	0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x22, 0x91, 0x01, 0x0a, 0x0f,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x12,
	0x59, 0x0a, 0x13, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77,
	0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22,
	0x95, 0x01, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x4e, 0x65, 0x78, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x15, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6e,
	0x65, 0x78, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x6f, 0x0a, 0x06, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x66, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x4f, 0x70, 0x65,
	0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65,
	0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0xc5, 0x02, 0x0a, 0x0a, 0x46, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x69,
	0x73, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x5f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x73,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x42, 0x79, 0x12, 0x64, 0x0a, 0x1f, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1b, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x53, 0x74, 0x65, 0x70, 0x88, 0x01, 0x01, 0x12, 0x62, 0x0a, 0x11, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x22, 0x0a, 0x20,
	0x5f, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x65, 0x70,
	0x22, 0xcd, 0x02, 0x0a, 0x0f, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x5b, 0x0a, 0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x52, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x36, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x51, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xcc, 0x01, 0x0a, 0x0b, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x6a, 0x0a, 0x17, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x15, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x51, 0x0a, 0x09,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xea, 0x01, 0x0a, 0x13, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x6a, 0x0a, 0x14, 0x61, 0x6e, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x12, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x67, 0x0a, 0x13, 0x61, 0x6e, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x11, 0x61, 0x6e, 0x64, 0x53, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0xf0, 0x01, 0x0a,
	0x19, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5f, 0x0a, 0x11, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x72, 0x0a, 0x19, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xb1, 0x02, 0x0a, 0x18, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5d, 0x0a, 0x10,
	0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0f, 0x73, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x55, 0x0a, 0x19, 0x73,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x13, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x65, 0x70,
	0x52, 0x11, 0x75, 0x73, 0x65, 0x72, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x65, 0x70, 0x73, 0x22, 0x94, 0x02, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x35, 0x0a, 0x17, 0x69, 0x73, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x5f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x73, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6c, 0x79, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x42, 0x79, 0x12,
	0x55, 0x0a, 0x0c, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x73, 0x74, 0x65, 0x70, 0x53,
	0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x72, 0x0a, 0x19, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf0, 0x01, 0x0a, 0x14, 0x55,
	0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x17, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x75, 0x73, 0x65, 0x72,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x15, 0x75, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x22, 0xdb, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x73, 0x0a, 0x1a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x18, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x54, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x16,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x6d, 0x0a, 0x14, 0x61, 0x6e, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x12, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x62, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x72, 0x0a, 0x19, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x85,
	0x02, 0x0a, 0x17, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x1a, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x18, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x73, 0x0a, 0x1a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x18, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x22, 0xd1, 0x01, 0x0a, 0x0c, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x18, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x16,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x52, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x14, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x12, 0x6b, 0x0a, 0x14, 0x61, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x12, 0x61, 0x6e,
	0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x22, 0xf2, 0x01, 0x0a, 0x1a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x60, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f,
	0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e,
	0x67, 0x12, 0x72, 0x0a, 0x19, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf7, 0x01, 0x0a, 0x15, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x6f, 0x0a, 0x18, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6d, 0x0a, 0x18, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x16, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x22,
	0xb1, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x4f, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x58, 0x0a, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x13,
	0x0a, 0x11, 0x6f, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x22, 0xf4, 0x03, 0x0a, 0x17, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x59, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x57, 0x0a, 0x08, 0x6f, 0x72,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x5f, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x14, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x12,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x65, 0x78, 0x70, 0x72, 0x22, 0x77, 0x0a, 0x1b, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xef, 0x03, 0x0a, 0x0d, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52,
	0x0c, 0x69, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a,
	0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x65, 0x74,
	0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x65,
	0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x64, 0x0a, 0x14, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x33, 0x0a,
	0x14, 0x61, 0x74, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x10, 0x61,
	0x74, 0x41, 0x6e, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x74, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x12,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x93, 0x01, 0x0a, 0x23, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x20, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x26, 0x0a, 0x24, 0x5f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0xcd, 0x03, 0x0a, 0x20, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x60, 0x0a, 0x08,
	0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x68,
	0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x18, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x16, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x65,
	0x78, 0x70, 0x72, 0x22, 0x89, 0x01, 0x0a, 0x24, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x0b,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xd9, 0x04, 0x0a, 0x16, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x14, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30,
	0x0a, 0x13, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x69,
	0x74, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x69, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48,
	0x01, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x55, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x63, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x42, 0x0f, 0x0a, 0x0d,
	0x6f, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a,
	0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x6a, 0x0a, 0x1d, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x0a, 0x13,
	0x69, 0x6e, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x41,
	0x6e, 0x79, 0x4e, 0x44, 0x61, 0x79, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x69, 0x6e, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x6e, 0x5f, 0x64, 0x61, 0x79,
	0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0xfa, 0x03, 0x0a, 0x16, 0x46, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x56, 0x0a, 0x08,
	0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x5e, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x13, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x11, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x62, 0x0a, 0x13, 0x66, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x11, 0x66, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04,
	0x65, 0x78, 0x70, 0x72, 0x22, 0x75, 0x0a, 0x1a, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x97, 0x03, 0x0a, 0x11,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48,
	0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x55, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x80, 0x02, 0x0a, 0x11, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x90, 0x01, 0x0a, 0x22, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x1f,
	0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc6, 0x03, 0x0a, 0x1f, 0x46, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x09,
	0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x5f, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x67, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x17, 0x66, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x15, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x65, 0x78, 0x70,
	0x72, 0x22, 0x87, 0x01, 0x0a, 0x23, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf3, 0x03, 0x0a, 0x15,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x14, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x13, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x69, 0x74, 0x65, 0x6d, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48,
	0x01, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x69, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0d, 0x6e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x62,
	0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x48, 0x01, 0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x78, 0x0a, 0x16, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e, 0x0a, 0x12, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x73, 0x22, 0x70, 0x0a, 0x10, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x2c, 0x0a, 0x12, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a,
	0x13, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x61, 0x63, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x2a, 0xaf, 0x01,
	0x0a, 0x13, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x53, 0x63,
	0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x25, 0x0a, 0x21, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x52,
	0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x57, 0x49,
	0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10,
	0x01, 0x12, 0x25, 0x0a, 0x21, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52,
	0x49, 0x41, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x53,
	0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x41, 0x43, 0x52, 0x4f, 0x53, 0x53,
	0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x03, 0x2a,
	0x7c, 0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x23, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12,
	0x1c, 0x0a, 0x18, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x2a, 0x94, 0x01,
	0x0a, 0x16, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x53, 0x43, 0x4f,
	0x50, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52,
	0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41,
	0x4d, 0x45, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x10, 0x02, 0x2a, 0x88, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2a, 0x0a, 0x26, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x43,
	0x4c, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a,
	0x1b, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x1f,
	0x0a, 0x1b, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x2a,
	0x64, 0x0a, 0x14, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61,
	0x53, 0x63, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x26, 0x0a, 0x22, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49, 0x41, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x49, 0x4e,
	0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x24, 0x0a, 0x20, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x45, 0x52, 0x49,
	0x41, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x10, 0x01, 0x2a, 0x61, 0x0a, 0x16, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x24, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x52,
	0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x2a, 0x81, 0x02, 0x0a, 0x0a, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x52, 0x49,
	0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x47, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46,
	0x4c, 0x4f, 0x41, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53,
	0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x05, 0x12,
	0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x53, 0x10,
	0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10,
	0x07, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41,
	0x52, 0x44, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x52,
	0x52, 0x45, 0x4e, 0x43, 0x59, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x46, 0x45, 0x45, 0x54, 0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d,
	0x49, 0x4c, 0x45, 0x53, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d,
	0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4b, 0x49, 0x4c, 0x4f, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x0d, 0x42, 0x7b, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x11, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x70, 0x69, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_analytics_data_v1alpha_data_proto_rawDescOnce sync.Once
	file_google_analytics_data_v1alpha_data_proto_rawDescData = file_google_analytics_data_v1alpha_data_proto_rawDesc
)

func file_google_analytics_data_v1alpha_data_proto_rawDescGZIP() []byte {
	file_google_analytics_data_v1alpha_data_proto_rawDescOnce.Do(func() {
		file_google_analytics_data_v1alpha_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_data_v1alpha_data_proto_rawDescData)
	})
	return file_google_analytics_data_v1alpha_data_proto_rawDescData
}

var file_google_analytics_data_v1alpha_data_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_analytics_data_v1alpha_data_proto_msgTypes = make([]protoimpl.MessageInfo, 58)
var file_google_analytics_data_v1alpha_data_proto_goTypes = []interface{}{
	(UserCriteriaScoping)(0),                          // 0: google.analytics.data.v1alpha.UserCriteriaScoping
	(UserExclusionDuration)(0),                        // 1: google.analytics.data.v1alpha.UserExclusionDuration
	(SessionCriteriaScoping)(0),                       // 2: google.analytics.data.v1alpha.SessionCriteriaScoping
	(SessionExclusionDuration)(0),                     // 3: google.analytics.data.v1alpha.SessionExclusionDuration
	(EventCriteriaScoping)(0),                         // 4: google.analytics.data.v1alpha.EventCriteriaScoping
	(EventExclusionDuration)(0),                       // 5: google.analytics.data.v1alpha.EventExclusionDuration
	(MetricType)(0),                                   // 6: google.analytics.data.v1alpha.MetricType
	(StringFilter_MatchType)(0),                       // 7: google.analytics.data.v1alpha.StringFilter.MatchType
	(NumericFilter_Operation)(0),                      // 8: google.analytics.data.v1alpha.NumericFilter.Operation
	(*DateRange)(nil),                                 // 9: google.analytics.data.v1alpha.DateRange
	(*Dimension)(nil),                                 // 10: google.analytics.data.v1alpha.Dimension
	(*DimensionExpression)(nil),                       // 11: google.analytics.data.v1alpha.DimensionExpression
	(*FilterExpression)(nil),                          // 12: google.analytics.data.v1alpha.FilterExpression
	(*FilterExpressionList)(nil),                      // 13: google.analytics.data.v1alpha.FilterExpressionList
	(*Filter)(nil),                                    // 14: google.analytics.data.v1alpha.Filter
	(*StringFilter)(nil),                              // 15: google.analytics.data.v1alpha.StringFilter
	(*InListFilter)(nil),                              // 16: google.analytics.data.v1alpha.InListFilter
	(*NumericFilter)(nil),                             // 17: google.analytics.data.v1alpha.NumericFilter
	(*BetweenFilter)(nil),                             // 18: google.analytics.data.v1alpha.BetweenFilter
	(*NumericValue)(nil),                              // 19: google.analytics.data.v1alpha.NumericValue
	(*DimensionHeader)(nil),                           // 20: google.analytics.data.v1alpha.DimensionHeader
	(*MetricHeader)(nil),                              // 21: google.analytics.data.v1alpha.MetricHeader
	(*Row)(nil),                                       // 22: google.analytics.data.v1alpha.Row
	(*DimensionValue)(nil),                            // 23: google.analytics.data.v1alpha.DimensionValue
	(*MetricValue)(nil),                               // 24: google.analytics.data.v1alpha.MetricValue
	(*PropertyQuota)(nil),                             // 25: google.analytics.data.v1alpha.PropertyQuota
	(*QuotaStatus)(nil),                               // 26: google.analytics.data.v1alpha.QuotaStatus
	(*FunnelBreakdown)(nil),                           // 27: google.analytics.data.v1alpha.FunnelBreakdown
	(*FunnelNextAction)(nil),                          // 28: google.analytics.data.v1alpha.FunnelNextAction
	(*Funnel)(nil),                                    // 29: google.analytics.data.v1alpha.Funnel
	(*FunnelStep)(nil),                                // 30: google.analytics.data.v1alpha.FunnelStep
	(*FunnelSubReport)(nil),                           // 31: google.analytics.data.v1alpha.FunnelSubReport
	(*UserSegment)(nil),                               // 32: google.analytics.data.v1alpha.UserSegment
	(*UserSegmentCriteria)(nil),                       // 33: google.analytics.data.v1alpha.UserSegmentCriteria
	(*UserSegmentConditionGroup)(nil),                 // 34: google.analytics.data.v1alpha.UserSegmentConditionGroup
	(*UserSegmentSequenceGroup)(nil),                  // 35: google.analytics.data.v1alpha.UserSegmentSequenceGroup
	(*UserSequenceStep)(nil),                          // 36: google.analytics.data.v1alpha.UserSequenceStep
	(*UserSegmentExclusion)(nil),                      // 37: google.analytics.data.v1alpha.UserSegmentExclusion
	(*SessionSegment)(nil),                            // 38: google.analytics.data.v1alpha.SessionSegment
	(*SessionSegmentCriteria)(nil),                    // 39: google.analytics.data.v1alpha.SessionSegmentCriteria
	(*SessionSegmentConditionGroup)(nil),              // 40: google.analytics.data.v1alpha.SessionSegmentConditionGroup
	(*SessionSegmentExclusion)(nil),                   // 41: google.analytics.data.v1alpha.SessionSegmentExclusion
	(*EventSegment)(nil),                              // 42: google.analytics.data.v1alpha.EventSegment
	(*EventSegmentCriteria)(nil),                      // 43: google.analytics.data.v1alpha.EventSegmentCriteria
	(*EventSegmentConditionGroup)(nil),                // 44: google.analytics.data.v1alpha.EventSegmentConditionGroup
	(*EventSegmentExclusion)(nil),                     // 45: google.analytics.data.v1alpha.EventSegmentExclusion
	(*Segment)(nil),                                   // 46: google.analytics.data.v1alpha.Segment
	(*SegmentFilterExpression)(nil),                   // 47: google.analytics.data.v1alpha.SegmentFilterExpression
	(*SegmentFilterExpressionList)(nil),               // 48: google.analytics.data.v1alpha.SegmentFilterExpressionList
	(*SegmentFilter)(nil),                             // 49: google.analytics.data.v1alpha.SegmentFilter
	(*SegmentFilterScoping)(nil),                      // 50: google.analytics.data.v1alpha.SegmentFilterScoping
	(*SegmentEventFilter)(nil),                        // 51: google.analytics.data.v1alpha.SegmentEventFilter
	(*SegmentParameterFilterExpression)(nil),          // 52: google.analytics.data.v1alpha.SegmentParameterFilterExpression
	(*SegmentParameterFilterExpressionList)(nil),      // 53: google.analytics.data.v1alpha.SegmentParameterFilterExpressionList
	(*SegmentParameterFilter)(nil),                    // 54: google.analytics.data.v1alpha.SegmentParameterFilter
	(*SegmentParameterFilterScoping)(nil),             // 55: google.analytics.data.v1alpha.SegmentParameterFilterScoping
	(*FunnelFilterExpression)(nil),                    // 56: google.analytics.data.v1alpha.FunnelFilterExpression
	(*FunnelFilterExpressionList)(nil),                // 57: google.analytics.data.v1alpha.FunnelFilterExpressionList
	(*FunnelFieldFilter)(nil),                         // 58: google.analytics.data.v1alpha.FunnelFieldFilter
	(*FunnelEventFilter)(nil),                         // 59: google.analytics.data.v1alpha.FunnelEventFilter
	(*FunnelParameterFilterExpression)(nil),           // 60: google.analytics.data.v1alpha.FunnelParameterFilterExpression
	(*FunnelParameterFilterExpressionList)(nil),       // 61: google.analytics.data.v1alpha.FunnelParameterFilterExpressionList
	(*FunnelParameterFilter)(nil),                     // 62: google.analytics.data.v1alpha.FunnelParameterFilter
	(*FunnelResponseMetadata)(nil),                    // 63: google.analytics.data.v1alpha.FunnelResponseMetadata
	(*SamplingMetadata)(nil),                          // 64: google.analytics.data.v1alpha.SamplingMetadata
	(*DimensionExpression_CaseExpression)(nil),        // 65: google.analytics.data.v1alpha.DimensionExpression.CaseExpression
	(*DimensionExpression_ConcatenateExpression)(nil), // 66: google.analytics.data.v1alpha.DimensionExpression.ConcatenateExpression
	(*durationpb.Duration)(nil),                       // 67: google.protobuf.Duration
}
var file_google_analytics_data_v1alpha_data_proto_depIdxs = []int32{
	11,  // 0: google.analytics.data.v1alpha.Dimension.dimension_expression:type_name -> google.analytics.data.v1alpha.DimensionExpression
	65,  // 1: google.analytics.data.v1alpha.DimensionExpression.lower_case:type_name -> google.analytics.data.v1alpha.DimensionExpression.CaseExpression
	65,  // 2: google.analytics.data.v1alpha.DimensionExpression.upper_case:type_name -> google.analytics.data.v1alpha.DimensionExpression.CaseExpression
	66,  // 3: google.analytics.data.v1alpha.DimensionExpression.concatenate:type_name -> google.analytics.data.v1alpha.DimensionExpression.ConcatenateExpression
	13,  // 4: google.analytics.data.v1alpha.FilterExpression.and_group:type_name -> google.analytics.data.v1alpha.FilterExpressionList
	13,  // 5: google.analytics.data.v1alpha.FilterExpression.or_group:type_name -> google.analytics.data.v1alpha.FilterExpressionList
	12,  // 6: google.analytics.data.v1alpha.FilterExpression.not_expression:type_name -> google.analytics.data.v1alpha.FilterExpression
	14,  // 7: google.analytics.data.v1alpha.FilterExpression.filter:type_name -> google.analytics.data.v1alpha.Filter
	12,  // 8: google.analytics.data.v1alpha.FilterExpressionList.expressions:type_name -> google.analytics.data.v1alpha.FilterExpression
	15,  // 9: google.analytics.data.v1alpha.Filter.string_filter:type_name -> google.analytics.data.v1alpha.StringFilter
	16,  // 10: google.analytics.data.v1alpha.Filter.in_list_filter:type_name -> google.analytics.data.v1alpha.InListFilter
	17,  // 11: google.analytics.data.v1alpha.Filter.numeric_filter:type_name -> google.analytics.data.v1alpha.NumericFilter
	18,  // 12: google.analytics.data.v1alpha.Filter.between_filter:type_name -> google.analytics.data.v1alpha.BetweenFilter
	7,   // 13: google.analytics.data.v1alpha.StringFilter.match_type:type_name -> google.analytics.data.v1alpha.StringFilter.MatchType
	8,   // 14: google.analytics.data.v1alpha.NumericFilter.operation:type_name -> google.analytics.data.v1alpha.NumericFilter.Operation
	19,  // 15: google.analytics.data.v1alpha.NumericFilter.value:type_name -> google.analytics.data.v1alpha.NumericValue
	19,  // 16: google.analytics.data.v1alpha.BetweenFilter.from_value:type_name -> google.analytics.data.v1alpha.NumericValue
	19,  // 17: google.analytics.data.v1alpha.BetweenFilter.to_value:type_name -> google.analytics.data.v1alpha.NumericValue
	6,   // 18: google.analytics.data.v1alpha.MetricHeader.type:type_name -> google.analytics.data.v1alpha.MetricType
	23,  // 19: google.analytics.data.v1alpha.Row.dimension_values:type_name -> google.analytics.data.v1alpha.DimensionValue
	24,  // 20: google.analytics.data.v1alpha.Row.metric_values:type_name -> google.analytics.data.v1alpha.MetricValue
	26,  // 21: google.analytics.data.v1alpha.PropertyQuota.tokens_per_day:type_name -> google.analytics.data.v1alpha.QuotaStatus
	26,  // 22: google.analytics.data.v1alpha.PropertyQuota.tokens_per_hour:type_name -> google.analytics.data.v1alpha.QuotaStatus
	26,  // 23: google.analytics.data.v1alpha.PropertyQuota.concurrent_requests:type_name -> google.analytics.data.v1alpha.QuotaStatus
	26,  // 24: google.analytics.data.v1alpha.PropertyQuota.server_errors_per_project_per_hour:type_name -> google.analytics.data.v1alpha.QuotaStatus
	26,  // 25: google.analytics.data.v1alpha.PropertyQuota.potentially_thresholded_requests_per_hour:type_name -> google.analytics.data.v1alpha.QuotaStatus
	10,  // 26: google.analytics.data.v1alpha.FunnelBreakdown.breakdown_dimension:type_name -> google.analytics.data.v1alpha.Dimension
	10,  // 27: google.analytics.data.v1alpha.FunnelNextAction.next_action_dimension:type_name -> google.analytics.data.v1alpha.Dimension
	30,  // 28: google.analytics.data.v1alpha.Funnel.steps:type_name -> google.analytics.data.v1alpha.FunnelStep
	67,  // 29: google.analytics.data.v1alpha.FunnelStep.within_duration_from_prior_step:type_name -> google.protobuf.Duration
	56,  // 30: google.analytics.data.v1alpha.FunnelStep.filter_expression:type_name -> google.analytics.data.v1alpha.FunnelFilterExpression
	20,  // 31: google.analytics.data.v1alpha.FunnelSubReport.dimension_headers:type_name -> google.analytics.data.v1alpha.DimensionHeader
	21,  // 32: google.analytics.data.v1alpha.FunnelSubReport.metric_headers:type_name -> google.analytics.data.v1alpha.MetricHeader
	22,  // 33: google.analytics.data.v1alpha.FunnelSubReport.rows:type_name -> google.analytics.data.v1alpha.Row
	63,  // 34: google.analytics.data.v1alpha.FunnelSubReport.metadata:type_name -> google.analytics.data.v1alpha.FunnelResponseMetadata
	33,  // 35: google.analytics.data.v1alpha.UserSegment.user_inclusion_criteria:type_name -> google.analytics.data.v1alpha.UserSegmentCriteria
	37,  // 36: google.analytics.data.v1alpha.UserSegment.exclusion:type_name -> google.analytics.data.v1alpha.UserSegmentExclusion
	34,  // 37: google.analytics.data.v1alpha.UserSegmentCriteria.and_condition_groups:type_name -> google.analytics.data.v1alpha.UserSegmentConditionGroup
	35,  // 38: google.analytics.data.v1alpha.UserSegmentCriteria.and_sequence_groups:type_name -> google.analytics.data.v1alpha.UserSegmentSequenceGroup
	0,   // 39: google.analytics.data.v1alpha.UserSegmentConditionGroup.condition_scoping:type_name -> google.analytics.data.v1alpha.UserCriteriaScoping
	47,  // 40: google.analytics.data.v1alpha.UserSegmentConditionGroup.segment_filter_expression:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	0,   // 41: google.analytics.data.v1alpha.UserSegmentSequenceGroup.sequence_scoping:type_name -> google.analytics.data.v1alpha.UserCriteriaScoping
	67,  // 42: google.analytics.data.v1alpha.UserSegmentSequenceGroup.sequence_maximum_duration:type_name -> google.protobuf.Duration
	36,  // 43: google.analytics.data.v1alpha.UserSegmentSequenceGroup.user_sequence_steps:type_name -> google.analytics.data.v1alpha.UserSequenceStep
	0,   // 44: google.analytics.data.v1alpha.UserSequenceStep.step_scoping:type_name -> google.analytics.data.v1alpha.UserCriteriaScoping
	47,  // 45: google.analytics.data.v1alpha.UserSequenceStep.segment_filter_expression:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	1,   // 46: google.analytics.data.v1alpha.UserSegmentExclusion.user_exclusion_duration:type_name -> google.analytics.data.v1alpha.UserExclusionDuration
	33,  // 47: google.analytics.data.v1alpha.UserSegmentExclusion.user_exclusion_criteria:type_name -> google.analytics.data.v1alpha.UserSegmentCriteria
	39,  // 48: google.analytics.data.v1alpha.SessionSegment.session_inclusion_criteria:type_name -> google.analytics.data.v1alpha.SessionSegmentCriteria
	41,  // 49: google.analytics.data.v1alpha.SessionSegment.exclusion:type_name -> google.analytics.data.v1alpha.SessionSegmentExclusion
	40,  // 50: google.analytics.data.v1alpha.SessionSegmentCriteria.and_condition_groups:type_name -> google.analytics.data.v1alpha.SessionSegmentConditionGroup
	2,   // 51: google.analytics.data.v1alpha.SessionSegmentConditionGroup.condition_scoping:type_name -> google.analytics.data.v1alpha.SessionCriteriaScoping
	47,  // 52: google.analytics.data.v1alpha.SessionSegmentConditionGroup.segment_filter_expression:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	3,   // 53: google.analytics.data.v1alpha.SessionSegmentExclusion.session_exclusion_duration:type_name -> google.analytics.data.v1alpha.SessionExclusionDuration
	39,  // 54: google.analytics.data.v1alpha.SessionSegmentExclusion.session_exclusion_criteria:type_name -> google.analytics.data.v1alpha.SessionSegmentCriteria
	43,  // 55: google.analytics.data.v1alpha.EventSegment.event_inclusion_criteria:type_name -> google.analytics.data.v1alpha.EventSegmentCriteria
	45,  // 56: google.analytics.data.v1alpha.EventSegment.exclusion:type_name -> google.analytics.data.v1alpha.EventSegmentExclusion
	44,  // 57: google.analytics.data.v1alpha.EventSegmentCriteria.and_condition_groups:type_name -> google.analytics.data.v1alpha.EventSegmentConditionGroup
	4,   // 58: google.analytics.data.v1alpha.EventSegmentConditionGroup.condition_scoping:type_name -> google.analytics.data.v1alpha.EventCriteriaScoping
	47,  // 59: google.analytics.data.v1alpha.EventSegmentConditionGroup.segment_filter_expression:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	5,   // 60: google.analytics.data.v1alpha.EventSegmentExclusion.event_exclusion_duration:type_name -> google.analytics.data.v1alpha.EventExclusionDuration
	43,  // 61: google.analytics.data.v1alpha.EventSegmentExclusion.event_exclusion_criteria:type_name -> google.analytics.data.v1alpha.EventSegmentCriteria
	32,  // 62: google.analytics.data.v1alpha.Segment.user_segment:type_name -> google.analytics.data.v1alpha.UserSegment
	38,  // 63: google.analytics.data.v1alpha.Segment.session_segment:type_name -> google.analytics.data.v1alpha.SessionSegment
	42,  // 64: google.analytics.data.v1alpha.Segment.event_segment:type_name -> google.analytics.data.v1alpha.EventSegment
	48,  // 65: google.analytics.data.v1alpha.SegmentFilterExpression.and_group:type_name -> google.analytics.data.v1alpha.SegmentFilterExpressionList
	48,  // 66: google.analytics.data.v1alpha.SegmentFilterExpression.or_group:type_name -> google.analytics.data.v1alpha.SegmentFilterExpressionList
	47,  // 67: google.analytics.data.v1alpha.SegmentFilterExpression.not_expression:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	49,  // 68: google.analytics.data.v1alpha.SegmentFilterExpression.segment_filter:type_name -> google.analytics.data.v1alpha.SegmentFilter
	51,  // 69: google.analytics.data.v1alpha.SegmentFilterExpression.segment_event_filter:type_name -> google.analytics.data.v1alpha.SegmentEventFilter
	47,  // 70: google.analytics.data.v1alpha.SegmentFilterExpressionList.expressions:type_name -> google.analytics.data.v1alpha.SegmentFilterExpression
	15,  // 71: google.analytics.data.v1alpha.SegmentFilter.string_filter:type_name -> google.analytics.data.v1alpha.StringFilter
	16,  // 72: google.analytics.data.v1alpha.SegmentFilter.in_list_filter:type_name -> google.analytics.data.v1alpha.InListFilter
	17,  // 73: google.analytics.data.v1alpha.SegmentFilter.numeric_filter:type_name -> google.analytics.data.v1alpha.NumericFilter
	18,  // 74: google.analytics.data.v1alpha.SegmentFilter.between_filter:type_name -> google.analytics.data.v1alpha.BetweenFilter
	50,  // 75: google.analytics.data.v1alpha.SegmentFilter.filter_scoping:type_name -> google.analytics.data.v1alpha.SegmentFilterScoping
	52,  // 76: google.analytics.data.v1alpha.SegmentEventFilter.segment_parameter_filter_expression:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterExpression
	53,  // 77: google.analytics.data.v1alpha.SegmentParameterFilterExpression.and_group:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterExpressionList
	53,  // 78: google.analytics.data.v1alpha.SegmentParameterFilterExpression.or_group:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterExpressionList
	52,  // 79: google.analytics.data.v1alpha.SegmentParameterFilterExpression.not_expression:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterExpression
	54,  // 80: google.analytics.data.v1alpha.SegmentParameterFilterExpression.segment_parameter_filter:type_name -> google.analytics.data.v1alpha.SegmentParameterFilter
	52,  // 81: google.analytics.data.v1alpha.SegmentParameterFilterExpressionList.expressions:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterExpression
	15,  // 82: google.analytics.data.v1alpha.SegmentParameterFilter.string_filter:type_name -> google.analytics.data.v1alpha.StringFilter
	16,  // 83: google.analytics.data.v1alpha.SegmentParameterFilter.in_list_filter:type_name -> google.analytics.data.v1alpha.InListFilter
	17,  // 84: google.analytics.data.v1alpha.SegmentParameterFilter.numeric_filter:type_name -> google.analytics.data.v1alpha.NumericFilter
	18,  // 85: google.analytics.data.v1alpha.SegmentParameterFilter.between_filter:type_name -> google.analytics.data.v1alpha.BetweenFilter
	55,  // 86: google.analytics.data.v1alpha.SegmentParameterFilter.filter_scoping:type_name -> google.analytics.data.v1alpha.SegmentParameterFilterScoping
	57,  // 87: google.analytics.data.v1alpha.FunnelFilterExpression.and_group:type_name -> google.analytics.data.v1alpha.FunnelFilterExpressionList
	57,  // 88: google.analytics.data.v1alpha.FunnelFilterExpression.or_group:type_name -> google.analytics.data.v1alpha.FunnelFilterExpressionList
	56,  // 89: google.analytics.data.v1alpha.FunnelFilterExpression.not_expression:type_name -> google.analytics.data.v1alpha.FunnelFilterExpression
	58,  // 90: google.analytics.data.v1alpha.FunnelFilterExpression.funnel_field_filter:type_name -> google.analytics.data.v1alpha.FunnelFieldFilter
	59,  // 91: google.analytics.data.v1alpha.FunnelFilterExpression.funnel_event_filter:type_name -> google.analytics.data.v1alpha.FunnelEventFilter
	56,  // 92: google.analytics.data.v1alpha.FunnelFilterExpressionList.expressions:type_name -> google.analytics.data.v1alpha.FunnelFilterExpression
	15,  // 93: google.analytics.data.v1alpha.FunnelFieldFilter.string_filter:type_name -> google.analytics.data.v1alpha.StringFilter
	16,  // 94: google.analytics.data.v1alpha.FunnelFieldFilter.in_list_filter:type_name -> google.analytics.data.v1alpha.InListFilter
	17,  // 95: google.analytics.data.v1alpha.FunnelFieldFilter.numeric_filter:type_name -> google.analytics.data.v1alpha.NumericFilter
	18,  // 96: google.analytics.data.v1alpha.FunnelFieldFilter.between_filter:type_name -> google.analytics.data.v1alpha.BetweenFilter
	60,  // 97: google.analytics.data.v1alpha.FunnelEventFilter.funnel_parameter_filter_expression:type_name -> google.analytics.data.v1alpha.FunnelParameterFilterExpression
	61,  // 98: google.analytics.data.v1alpha.FunnelParameterFilterExpression.and_group:type_name -> google.analytics.data.v1alpha.FunnelParameterFilterExpressionList
	61,  // 99: google.analytics.data.v1alpha.FunnelParameterFilterExpression.or_group:type_name -> google.analytics.data.v1alpha.FunnelParameterFilterExpressionList
	60,  // 100: google.analytics.data.v1alpha.FunnelParameterFilterExpression.not_expression:type_name -> google.analytics.data.v1alpha.FunnelParameterFilterExpression
	62,  // 101: google.analytics.data.v1alpha.FunnelParameterFilterExpression.funnel_parameter_filter:type_name -> google.analytics.data.v1alpha.FunnelParameterFilter
	60,  // 102: google.analytics.data.v1alpha.FunnelParameterFilterExpressionList.expressions:type_name -> google.analytics.data.v1alpha.FunnelParameterFilterExpression
	15,  // 103: google.analytics.data.v1alpha.FunnelParameterFilter.string_filter:type_name -> google.analytics.data.v1alpha.StringFilter
	16,  // 104: google.analytics.data.v1alpha.FunnelParameterFilter.in_list_filter:type_name -> google.analytics.data.v1alpha.InListFilter
	17,  // 105: google.analytics.data.v1alpha.FunnelParameterFilter.numeric_filter:type_name -> google.analytics.data.v1alpha.NumericFilter
	18,  // 106: google.analytics.data.v1alpha.FunnelParameterFilter.between_filter:type_name -> google.analytics.data.v1alpha.BetweenFilter
	64,  // 107: google.analytics.data.v1alpha.FunnelResponseMetadata.sampling_metadatas:type_name -> google.analytics.data.v1alpha.SamplingMetadata
	108, // [108:108] is the sub-list for method output_type
	108, // [108:108] is the sub-list for method input_type
	108, // [108:108] is the sub-list for extension type_name
	108, // [108:108] is the sub-list for extension extendee
	0,   // [0:108] is the sub-list for field type_name
}

func init() { file_google_analytics_data_v1alpha_data_proto_init() }
func file_google_analytics_data_v1alpha_data_proto_init() {
	if File_google_analytics_data_v1alpha_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_data_v1alpha_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StringFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InListFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NumericFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BetweenFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NumericValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyQuota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelBreakdown); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelNextAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Funnel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelSubReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSegmentCriteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSegmentConditionGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSegmentSequenceGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSequenceStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSegmentExclusion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionSegmentCriteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionSegmentConditionGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionSegmentExclusion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventSegmentCriteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventSegmentConditionGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventSegmentExclusion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Segment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentFilterScoping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentEventFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentParameterFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentParameterFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentParameterFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentParameterFilterScoping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelFieldFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelEventFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelParameterFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelParameterFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelParameterFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunnelResponseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SamplingMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression_CaseExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_data_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression_ConcatenateExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*DimensionExpression_LowerCase)(nil),
		(*DimensionExpression_UpperCase)(nil),
		(*DimensionExpression_Concatenate)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*FilterExpression_AndGroup)(nil),
		(*FilterExpression_OrGroup)(nil),
		(*FilterExpression_NotExpression)(nil),
		(*FilterExpression_Filter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Filter_StringFilter)(nil),
		(*Filter_InListFilter)(nil),
		(*Filter_NumericFilter)(nil),
		(*Filter_BetweenFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*NumericValue_Int64Value)(nil),
		(*NumericValue_DoubleValue)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*DimensionValue_Value)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*MetricValue_Value)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[18].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[19].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[21].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[37].OneofWrappers = []interface{}{
		(*Segment_UserSegment)(nil),
		(*Segment_SessionSegment)(nil),
		(*Segment_EventSegment)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*SegmentFilterExpression_AndGroup)(nil),
		(*SegmentFilterExpression_OrGroup)(nil),
		(*SegmentFilterExpression_NotExpression)(nil),
		(*SegmentFilterExpression_SegmentFilter)(nil),
		(*SegmentFilterExpression_SegmentEventFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*SegmentFilter_StringFilter)(nil),
		(*SegmentFilter_InListFilter)(nil),
		(*SegmentFilter_NumericFilter)(nil),
		(*SegmentFilter_BetweenFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[41].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[42].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[43].OneofWrappers = []interface{}{
		(*SegmentParameterFilterExpression_AndGroup)(nil),
		(*SegmentParameterFilterExpression_OrGroup)(nil),
		(*SegmentParameterFilterExpression_NotExpression)(nil),
		(*SegmentParameterFilterExpression_SegmentParameterFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[45].OneofWrappers = []interface{}{
		(*SegmentParameterFilter_EventParameterName)(nil),
		(*SegmentParameterFilter_ItemParameterName)(nil),
		(*SegmentParameterFilter_StringFilter)(nil),
		(*SegmentParameterFilter_InListFilter)(nil),
		(*SegmentParameterFilter_NumericFilter)(nil),
		(*SegmentParameterFilter_BetweenFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[46].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[47].OneofWrappers = []interface{}{
		(*FunnelFilterExpression_AndGroup)(nil),
		(*FunnelFilterExpression_OrGroup)(nil),
		(*FunnelFilterExpression_NotExpression)(nil),
		(*FunnelFilterExpression_FunnelFieldFilter)(nil),
		(*FunnelFilterExpression_FunnelEventFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[49].OneofWrappers = []interface{}{
		(*FunnelFieldFilter_StringFilter)(nil),
		(*FunnelFieldFilter_InListFilter)(nil),
		(*FunnelFieldFilter_NumericFilter)(nil),
		(*FunnelFieldFilter_BetweenFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[50].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[51].OneofWrappers = []interface{}{
		(*FunnelParameterFilterExpression_AndGroup)(nil),
		(*FunnelParameterFilterExpression_OrGroup)(nil),
		(*FunnelParameterFilterExpression_NotExpression)(nil),
		(*FunnelParameterFilterExpression_FunnelParameterFilter)(nil),
	}
	file_google_analytics_data_v1alpha_data_proto_msgTypes[53].OneofWrappers = []interface{}{
		(*FunnelParameterFilter_EventParameterName)(nil),
		(*FunnelParameterFilter_ItemParameterName)(nil),
		(*FunnelParameterFilter_StringFilter)(nil),
		(*FunnelParameterFilter_InListFilter)(nil),
		(*FunnelParameterFilter_NumericFilter)(nil),
		(*FunnelParameterFilter_BetweenFilter)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_data_v1alpha_data_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   58,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_data_v1alpha_data_proto_goTypes,
		DependencyIndexes: file_google_analytics_data_v1alpha_data_proto_depIdxs,
		EnumInfos:         file_google_analytics_data_v1alpha_data_proto_enumTypes,
		MessageInfos:      file_google_analytics_data_v1alpha_data_proto_msgTypes,
	}.Build()
	File_google_analytics_data_v1alpha_data_proto = out.File
	file_google_analytics_data_v1alpha_data_proto_rawDesc = nil
	file_google_analytics_data_v1alpha_data_proto_goTypes = nil
	file_google_analytics_data_v1alpha_data_proto_depIdxs = nil
}
